// @ts-nocheck
export type TComponents = {
  requestBodies: {
    EnvelopeCustomFields: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/EnvelopeCustomFields';
          };
        };
      };
    };
    EnvelopeDocumentFields: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/EnvelopeDocumentFields';
          };
        };
      };
    };
    EnvelopeRecipientTabs: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/EnvelopeRecipientTabs';
          };
        };
      };
    };
    EnvelopeRecipients: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/EnvelopeRecipients';
          };
        };
      };
    };
    accountSignaturesInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/accountSignaturesInformation';
          };
        };
      };
    };
    brand: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/brand';
          };
        };
      };
    };
    brandsRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/brandsRequest';
          };
        };
      };
    };
    bulkSendRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/bulkSendRequest';
          };
        };
      };
    };
    bulkSendingList: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/bulkSendingList';
          };
        };
      };
    };
    chunkedUploadRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/chunkedUploadRequest';
          };
        };
      };
    };
    cloudStorageProviders: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/cloudStorageProviders';
          };
        };
      };
    };
    connectCustomConfiguration: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/connectCustomConfiguration';
          };
        };
      };
    };
    connectOAuthConfig: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/connectOAuthConfig';
          };
        };
      };
    };
    contactModRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/contactModRequest';
          };
        };
      };
    };
    correctViewRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/correctViewRequest';
          };
        };
      };
    };
    customField: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/customField';
          };
        };
      };
    };
    customSettingsInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/customSettingsInformation';
          };
        };
      };
    };
    delayedRouting: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/delayedRouting';
          };
        };
      };
      description: 'A complex element that specifies the delayed routing settings for the workflow step.';
    };
    documentFieldsInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/documentFieldsInformation';
          };
        };
      };
    };
    documentHtmlDefinition: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/documentHtmlDefinition';
          };
        };
      };
    };
    documentTemplateList: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/documentTemplateList';
          };
        };
      };
    };
    documentVisibilityList: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/documentVisibilityList';
          };
        };
      };
    };
    emailSettings: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/emailSettings';
          };
        };
      };
      description: 'A complex type that contains email settings.';
    };
    envelopeAttachmentsRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/envelopeAttachmentsRequest';
          };
        };
      };
    };
    envelopeDefinition: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/envelopeDefinition';
          };
        };
      };
    };
    envelopeTemplate: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/envelopeTemplate';
          };
        };
      };
    };
    favoriteTemplatesInfo: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/favoriteTemplatesInfo';
          };
        };
      };
    };
    groupInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/groupInformation';
          };
        };
      };
    };
    lockRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/lockRequest';
          };
        };
      };
    };
    notary: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/notary';
          };
        };
      };
    };
    notaryJurisdiction: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/notaryJurisdiction';
          };
        };
      };
    };
    pageRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/pageRequest';
          };
        };
      };
    };
    permissionProfile: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/permissionProfile';
          };
        };
      };
    };
    powerForm: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/powerForm';
          };
        };
      };
      description: 'Information about any PowerForms that are included in the envelope.';
    };
    recipientPreviewRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/recipientPreviewRequest';
          };
        };
      };
    };
    recipientViewRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/recipientViewRequest';
          };
        };
      };
    };
    returnUrlRequest: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/returnUrlRequest';
          };
        };
      };
    };
    scheduledSending: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/scheduledSending';
          };
        };
      };
      description: 'An object that describes the settings for scheduled sending.';
    };
    signingGroupInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/signingGroupInformation';
          };
        };
      };
    };
    signingGroupUsers: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/signingGroupUsers';
          };
        };
      };
      description: 'A complex type that contains information about users in the signing group.';
    };
    tabMetadata: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/tabMetadata';
          };
        };
      };
    };
    tabs: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/tabs';
          };
        };
      };
      description: 'A list of tabs, which are represented graphically as symbols on documents at the time of signing. Tabs show recipients where to sign, initial, or enter data. They may also display data to the recipients.';
    };
    templateCustomFields: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/templateCustomFields';
          };
        };
      };
    };
    templateDocumentVisibilityList: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/templateDocumentVisibilityList';
          };
        };
      };
    };
    templateRecipients: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/templateRecipients';
          };
        };
      };
    };
    templateTabs: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/templateTabs';
          };
        };
      };
    };
    userInfoList: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/userInfoList';
          };
        };
      };
    };
    userSignaturesInformation: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/userSignaturesInformation';
          };
        };
      };
    };
    watermark: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/watermark';
          };
        };
      };
      description: 'When **true,** the account has the watermark feature enabled, and the envelope is not complete, then the watermark for the account is added to the PDF documents. This option can remove the watermark. ';
    };
    workflow: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/workflow';
          };
        };
      };
    };
    workflowStep: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/workflowStep';
          };
        };
      };
    };
    workspace: {
      content: {
        'application/json': {
          schema: {
            $ref: '#/components/schemas/workspace';
          };
        };
      };
    };
  };
  schemas: {
    AccountBrands: {
      description: 'The AccountBrands resource enables you to use account-level brands to customize the styles and text that recipients see.';
      properties: {
        brands: {
          description: 'A list of brands.';
          items: {
            $ref: '#/components/schemas/brand';
          };
          type: 'array';
        };
        recipientBrandIdDefault: {
          description: 'The brand that envelope recipients see when a brand is not explicitly set.';
          type: 'string';
        };
        senderBrandIdDefault: {
          description: 'The brand that envelope senders see when a brand is not explicitly set.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'brandsResponse';
      'x-ds-order': '10';
      'x-ms-summary': 'The AccountBrands resource enables you to use account-level brands to customize the styles and text that recipients see.';
    };
    AccountConsumerDisclosures: {
      description: 'Details about account consumer disclosures.';
      properties: {
        accountEsignId: {
          description: 'The GUID of the account associated with the consumer disclosure.';
          type: 'string';
        };
        allowCDWithdraw: {
          description: 'When **true,** indicates that the customer can withdraw their consent to the consumer disclosure when they decline to sign documents. If these recipients sign documents sent to them from your account in the future, they will be required to agree to the terms in the disclosure. The default value is **false.**\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowCDWithdrawMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        changeEmail: {
          description: 'If the customer needs to change their email address, this is the email address to which they should the change request.\n\nMaximum length: 100 characters.';
          type: 'string';
        };
        changeEmailOther: {
          description: 'Other information about the requirements for the user to change their email address.\n\nMaximum length: 255 characters.\n\nExample: \n\n`We do not require any other information from you to change your email address.`';
          type: 'string';
        };
        companyName: {
          description: "Specifies the company name used in the disclosure. The default value is the account name.\n\nHowever, if your account uses signing brands that specify a company name, you can substitute the brand's company name by setting the `useBrand` property to **true.** Whenever an envelope is sent from the account that uses a signing brand with a specified `companyName`, that value is used in email notifications and in the signing experience.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. You must also set the value of the `useBrand` property to **true.**";
          type: 'string';
        };
        companyPhone: {
          description: 'The phone number of the company associated with the consumer disclosure, as a free-formatted string.';
          type: 'string';
        };
        copyCostPerPage: {
          description: 'The cost per page if the customer requests paper copies.\n\nExample: \n\n`0.0000`';
          type: 'string';
        };
        copyFeeCollectionMethod: {
          description: 'Specifies the fee collection method for cases in which the customer requires paper copies of the document.\n\nMaximum length: 255 characters.\n\nExample: \n\n`We will bill you for any fees at that time, if any.`';
          type: 'string';
        };
        copyRequestEmail: {
          description: 'The email address to which the customer should send a request for copies of a document.\n\nMaximum length: 100 characters.';
          type: 'string';
        };
        custom: {
          description: 'When **true,** indicates that the consumer disclosure is a custom disclosure. The default is **false.**';
          type: 'string';
        };
        enableEsign: {
          description: 'When **true** (default), indicates that eSign is enabled.';
          type: 'string';
        };
        esignAgreement: {
          description: 'The final, assembled text of the Electronic Record and Signature Disclosure that includes the appropriate `companyName` and other specifics. It also includes the HTML tags used for formatting.';
          type: 'string';
        };
        esignText: {
          description: 'The template for the Electronic Record and Signature Disclosure, which contains placeholders for information such as the `companyName`. It also includes the HTML tags used for formatting.\n\n**Note:** If you are switching to or updating a custom disclosure, you can edit both the text and the HTML formatting.';
          type: 'string';
        };
        languageCode: {
          description: 'The code for the language version of the disclosure. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          type: 'string';
        };
        mustAgreeToEsign: {
          description: "When **true,** the  recipient must agree to the consumer disclosure. The value of this property is read-only. It is calculated based on the account setting `consumerDisclosureFrequency` and the user's actions.";
          type: 'string';
        };
        pdfId: {
          description: '**Deprecated.** \n\nThe `pdfId` property in the consumer_disclosure PUT request is deprecated. For security reasons going forward, any value provided in the request packet must be ignored. ';
          type: 'string';
        };
        useBrand: {
          description: 'When **true,** specifies that the company name in the signing brand is used for the disclosure. Whenever an envelope is sent from the account that uses a signing brand with a specified company name, that value is used in email notifications and in the signing experience.  \n\nWhen **false** (default), or if the signing brand does not specify a company name, the account name is used instead.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. ';
          type: 'string';
        };
        useConsumerDisclosureWithinAccount: {
          description: 'When **true,** specifies that recipients in the same account as the sender must agree to eSign an Electronic Record and Signature Disclosure Statement.';
          type: 'string';
        };
        useConsumerDisclosureWithinAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        withdrawAddressLine1: {
          description: 'Contains the first address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawAddressLine2: {
          description: 'Contains the second address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawByEmail: {
          description: 'When **true** (default), indicates that the customer can withdraw consent by email.';
          type: 'string';
        };
        withdrawByMail: {
          description: 'When **true,** indicates that the customer can withdraw consent by postal mail. The default is **false.**';
          type: 'string';
        };
        withdrawByPhone: {
          description: 'When **true,** indicates that the customer can withdraw consent by phone. The default is **false.**';
          type: 'string';
        };
        withdrawCity: {
          description: 'Contains the city of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 50 characters. ';
          type: 'string';
        };
        withdrawConsequences: {
          description: 'Text indicating the consequences of withdrawing consent.\n\nMaximum length: 255 characters.';
          type: 'string';
        };
        withdrawEmail: {
          description: 'Contains the email address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawOther: {
          description: 'Contains any other information needed to withdraw consent.\n\nMaximum length: 255 characters.\n\nExample:\n\n`We do not need any other information from you to withdraw consent.`';
          type: 'string';
        };
        withdrawPhone: {
          description: 'Contains the phone number that a customer can call to register consent withdrawal notification as a free-formatted string.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawPostalCode: {
          description: 'Contains the postal code of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawState: {
          description: 'Contains the state of the postal address to which a customer can send a consent withdrawal notification.\n\nExample: `PA`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'consumerDisclosure';
      'x-ds-order': '20';
      'x-ms-summary': 'Details about account consumer disclosures.';
    };
    AccountCustomFields: {
      description: 'An `accountCustomField` is an envelope custom field that you set at the account level.\nApplying custom fields enables account administrators to group and manage envelopes.\n';
      properties: {
        listCustomFields: {
          description: 'An array of list custom fields.';
          items: {
            $ref: '#/components/schemas/listCustomField';
          };
          type: 'array';
        };
        textCustomFields: {
          description: 'An array of text custom fields.';
          items: {
            $ref: '#/components/schemas/textCustomField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'customFields';
      'x-ds-order': '30';
      'x-ms-summary': 'An `accountCustomField` is an envelope custom field that you set at the account level.\nApplying custom fields enables account administrators to group and manage envelopes.\n';
    };
    AccountPasswordRules: {
      description: 'Contains details about the password rules for an account.';
      properties: {
        expirePassword: {
          description: 'When **true,** passwords expire. The default value is `false`.';
          type: 'string';
        };
        expirePasswordDays: {
          description: 'The number of days before passwords expire. To use this property, the `expirePassword` property must be set to **true.**';
          type: 'string';
        };
        expirePasswordDaysMetadata: {
          $ref: '#/components/schemas/accountPasswordExpirePasswordDays';
        };
        lockoutDurationMinutes: {
          description: 'The number of minutes a user is locked out of the system after three failed login attempts. The default value is `2`.';
          type: 'string';
        };
        lockoutDurationMinutesMetadata: {
          $ref: '#/components/schemas/accountPasswordLockoutDurationMinutes';
        };
        lockoutDurationType: {
          description: 'The interval associated with the user lockout after a failed login attempt.\n\nPossible values are:\n\n- `minutes` (default)\n- `hours`\n- `days`';
          type: 'string';
        };
        lockoutDurationTypeMetadata: {
          $ref: '#/components/schemas/accountPasswordLockoutDurationType';
        };
        minimumPasswordAgeDays: {
          description: 'The minimum number of days after a password is set before it can be changed. This value can be `0` or more days. The default value is `0`.';
          type: 'string';
        };
        minimumPasswordAgeDaysMetadata: {
          $ref: '#/components/schemas/accountPasswordMinimumPasswordAgeDays';
        };
        minimumPasswordLength: {
          description: 'The minimum number of characters in the password. This value must be a number between `6` and `15`. The default value is `6`.';
          type: 'string';
        };
        minimumPasswordLengthMetadata: {
          $ref: '#/components/schemas/accountMinimumPasswordLength';
        };
        passwordIncludeDigit: {
          description: 'When **true,** passwords must include a digit. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeDigitOrSpecialCharacter: {
          description: 'When **true,** passwords must include either a digit or a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeLowerCase: {
          description: 'When **true,** passwords must include a lowercase letter. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeSpecialCharacter: {
          description: 'When **true,** passwords must include a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeUpperCase: {
          description: 'When **true,** passwords must include an uppercase letter. The default value is `false`.';
          type: 'string';
        };
        passwordStrengthType: {
          description: 'The type of password strength. Possible values are:\n\n- `basic`: The minimum password length is 6 characters with no other password requirements.\n- `medium`: The minimum password length is 7 characters. Passwords must also have one uppercase letter, one lowercase letter, and one number or special character.\n- `strong`: The minimum password length is 9 characters. Passwords must also have one uppercase letter, one lowercase letter, one number, and one special character.\n- `custom`: This option enables you to customize password requirements, including the following properties:\n\n   - `minimumPasswordLength`\n   - `minimumPasswordAgeDays`\n   - `passwordIncludeDigit`\n   - `passwordIncludeDigitOrSpecialCharacter`\n   - `passwordIncludeLowerCase`\n   - `passwordIncludeSpecialCharacter`\n   - `passwordIncludeUpperCase`\n   - `questionsRequired`';
          type: 'string';
        };
        passwordStrengthTypeMetadata: {
          $ref: '#/components/schemas/accountPasswordStrengthType';
        };
        questionsRequired: {
          description: 'The number of security questions required to confirm the user’s identity before the user can reset their password. The default value is `0`.';
          type: 'string';
        };
        questionsRequiredMetadata: {
          $ref: '#/components/schemas/accountPasswordQuestionsRequired';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountPasswordRules';
      'x-ds-order': '190';
      'x-ms-summary': 'Contains details about the password rules for an account.';
    };
    AccountPermissionProfiles: {
      description: 'The AccountPermissionProfiles resource provides methods that allow you to manage permission profiles for groups of account users.';
      properties: {
        modifiedByUsername: {
          description: 'The username of the user who last modified the permission profile.';
          type: 'string';
        };
        modifiedDateTime: {
          description: 'The date and time when the permission profile was last modified.';
          type: 'string';
        };
        permissionProfileId: {
          description: 'The ID of the permission profile.\n\nUse [AccountPermissionProfiles: list](/docs/esign-rest-api/reference/accounts/accountpermissionprofiles/list/)\nto get a list of permission profiles and their IDs.\n\nYou can also download a CSV file of all permission profiles\nand their IDs from the **Settings > Permission Profiles** page\nof your eSignature account page.\n';
          type: 'string';
        };
        permissionProfileName: {
          description: 'The name of the account permission profile. \n\nExample: `Account Administrator`';
          type: 'string';
        };
        settings: {
          $ref: '#/components/schemas/accountRoleSettings';
        };
        userCount: {
          description: 'The total number of users in the group associated with the account permission profile.';
          type: 'string';
        };
        users: {
          description: 'A list of user objects containing information about the users who are associated with the account permission profile.';
          items: {
            $ref: '#/components/schemas/userInformation';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'permissionProfile';
      'x-ds-order': '70';
      'x-ms-summary': 'The AccountPermissionProfiles resource provides methods that allow you to manage permission profiles for groups of account users.';
    };
    AccountSealProviders: {
      description: '';
      properties: {
        seals: {
          description: 'A list of electronic seals to apply to documents.';
          items: {
            $ref: '#/components/schemas/sealIdentifier';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountSeals';
      'x-ds-order': '10';
      'x-ms-summary': '';
    };
    AccountSignatureProviders: {
      description: 'This resource provides information on the Standards Based Signature providers that have been provisioned for an account.\n';
      properties: {
        signatureProviders: {
          description: 'Names of electronic or digital signature providers that can be used.';
          items: {
            $ref: '#/components/schemas/accountSignatureProvider';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountSignatureProviders';
      'x-ds-order': '30';
      'x-ms-summary': 'This resource provides information on the Standards Based Signature providers that have been provisioned for an account.\n';
    };
    AccountSignatures: {
      description: 'AccountSignatures represent stamps used to sign documents.';
      properties: {
        adoptedDateTime: {
          description: 'The UTC date and time when the user adopted the signature.';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        customField: {
          description: '';
          type: 'string';
        };
        dateStampProperties: {
          $ref: '#/components/schemas/dateStampProperties';
        };
        disallowUserResizeStamp: {
          description: 'When **true,** users may not resize the stamp.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        externalID: {
          description: "Optionally specify an external identifier for the user's signature.";
          type: 'string';
        };
        imageBase64: {
          description: '';
          type: 'string';
        };
        imageType: {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          type: 'string';
        };
        initials150ImageId: {
          description: "The ID of the user's initials image.";
          type: 'string';
        };
        initialsImageUri: {
          description: "The URI for retrieving the image of the user's initials.";
          type: 'string';
        };
        isDefault: {
          description: 'Boolean that specifies whether the signature is the default signature for the user.';
          type: 'string';
        };
        lastModifiedDateTime: {
          description: 'The date and time that the item was last modified.';
          type: 'string';
        };
        nrdsId: {
          description: 'The National Association of Realtors (NAR) membership ID for a user who is a realtor.';
          type: 'string';
        };
        nrdsLastName: {
          description: "The realtor's last name.";
          type: 'string';
        };
        nrdsStatus: {
          description: "The realtor's NAR membership status. The value `active` verifies that the user is a current NAR member. Valid values are:\n\n- `Active`\n- `Inactive`\n- `Terminate`\n- `Provisional`\n- `Deceased`\n- `Suspend`\n- `Unknown`";
          type: 'string';
        };
        phoneticName: {
          description: 'The phonetic spelling of the `signatureName`.';
          type: 'string';
        };
        signature150ImageId: {
          description: "The ID of the user's signature image.";
          type: 'string';
        };
        signatureFont: {
          description: 'The font type to use for the signature if the signature is not drawn. The following font styles  are supported. The quotes are to indicate that these values are strings, not `enums`.\n\n- `"1_DocuSign"`\n- `"2_DocuSign"`\n- `"3_DocuSign"`\n- `"4_DocuSign"`\n- `"5_DocuSign"`\n- `"6_DocuSign"`\n- `"7_DocuSign"`\n- `"8_DocuSign"`\n- `"Mistral"`\n- `"Rage Italic"`\n';
          type: 'string';
        };
        signatureGroups: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureGroup';
          };
          type: 'array';
        };
        signatureId: {
          description: 'Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as "&", "<", ">") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.';
          type: 'string';
        };
        signatureImageUri: {
          description: "An endpoint URI that you can use to retrieve the user's signature image.";
          type: 'string';
        };
        signatureInitials: {
          description: "Specifies the user's signature in initials format.";
          type: 'string';
        };
        signatureName: {
          description: "Specifies the user's signature name.";
          type: 'string';
        };
        signatureRights: {
          description: 'The rights that the user has to the signature. Valid values are:\n\n- `none`\n- `read`\n- `admin`';
          type: 'string';
        };
        signatureType: {
          description: 'Specifies the type of signature.';
          type: 'string';
        };
        signatureUsers: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureUser';
          };
          type: 'array';
        };
        stampFormat: {
          description: "The format of a stamp. Valid values are:\n\n- `NameHanko`: The stamp represents only the signer's name.\n- `NameDateHanko`: The stamp represents the signer's name and the date. ";
          type: 'string';
        };
        stampImageUri: {
          description: "The URI for retrieving the image of the user's stamp.";
          type: 'string';
        };
        stampSizeMM: {
          description: 'The physical height of the stamp image (in millimeters) that the stamp vendor recommends for displaying the image in PDF documents.';
          type: 'string';
        };
        stampType: {
          description: 'The type of stamp. Valid values are:\n\n- `signature`: A signature image. This is the default value.\n- `stamp`: A stamp image.\n- null';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountSignature';
      'x-ds-order': '40';
      'x-ms-summary': 'AccountSignatures represent stamps used to sign documents.';
    };
    AccountTabSettings: {
      description: 'Tab settings determine the tab types and tab functionality that are enabled for an account.';
      properties: {
        allowTabOrder: {
          description: 'When **true,** account users can set a tab order for the signing process.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowTabOrderMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        approveDeclineTabsEnabled: {
          description: 'When **true,** approve and decline tabs are enabled.';
          type: 'string';
        };
        approveDeclineTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        calculatedFieldsEnabled: {
          description: 'When **true,** [calculated fields](https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields) are enabled for tabs.';
          type: 'string';
        };
        calculatedFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        checkBoxTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        checkboxTabsEnabled: {
          description: 'When **true,** checkbox tabs are enabled.';
          type: 'string';
        };
        dataFieldRegexEnabled: {
          description: 'When **true,** regular expressions are enabled for tabs that contain data fields.';
          type: 'string';
        };
        dataFieldRegexMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        dataFieldSizeEnabled: {
          description: 'When **true,** setting character limits for input fields is enabled.';
          type: 'string';
        };
        dataFieldSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        drawTabsEnabled: {
          description: '';
          type: 'string';
        };
        drawTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        firstLastEmailTabsEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        firstLastEmailTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        listTabsEnabled: {
          description: 'When **true,** list tabs are enabled.';
          type: 'string';
        };
        listTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        noteTabsEnabled: {
          description: 'When **true,** note tabs are enabled.';
          type: 'string';
        };
        noteTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        numericalTabsEnabled: {
          description: '';
          type: 'string';
        };
        numericalTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        prefillTabsEnabled: {
          description: '';
          type: 'string';
        };
        prefillTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        radioTabsEnabled: {
          description: 'When **true,** radio button tabs are enabled.';
          type: 'string';
        };
        radioTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        savingCustomTabsEnabled: {
          description: 'When **true,** saving custom tabs is enabled.';
          type: 'string';
        };
        savingCustomTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        senderToChangeTabAssignmentsEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        senderToChangeTabAssignmentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sharedCustomTabsEnabled: {
          description: 'When **true,** shared custom tabs are enabled.';
          type: 'string';
        };
        sharedCustomTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabDataLabelEnabled: {
          description: 'When **true,** [data\nlabels](https://support.docusign.com/en/videos/Data-Labels) are enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabDataLabelMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabLocationEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        tabLocationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabLockingEnabled: {
          description: 'When **true,** tab locking is enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabLockingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabScaleEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        tabScaleMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabTextFormattingEnabled: {
          description: 'When **true,** text formatting (such as font type, font size,\nfont color, bold, italic, and underline) is enabled for tabs that\nsupport formatting.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabTextFormattingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        textTabsEnabled: {
          description: 'When **true,** text tabs are enabled.';
          type: 'string';
        };
        textTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'tabAccountSettings';
      'x-ds-order': '100';
      'x-ms-summary': 'Tab settings determine the tab types and tab functionality that are enabled for an account.';
    };
    AccountWatermarks: {
      description: '';
      properties: {
        displayAngle: {
          description: '';
          type: 'string';
        };
        enabled: {
          description: '';
          type: 'string';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        imageBase64: {
          description: '';
          type: 'string';
        };
        transparency: {
          description: '';
          type: 'string';
        };
        watermarkText: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'watermark';
      'x-ds-order': '200';
      'x-ms-summary': '';
    };
    Accounts: {
      description: 'Account management';
      properties: {
        accountIdGuid: {
          description: 'The GUID associated with the account ID.';
          type: 'string';
        };
        accountName: {
          description: 'The name on the account.';
          type: 'string';
        };
        accountSettings: {
          $ref: '#/components/schemas/accountSettingsInformation';
        };
        allowTransactionRooms: {
          description: 'When **true,** the transaction rooms feature exposed through the Workspaces API is enabled.';
          type: 'string';
        };
        billingPeriodDaysRemaining: {
          description: 'Number of days remaining in the current billing period.';
          type: 'string';
        };
        billingPeriodEndDate: {
          description: 'The billing period end date in UTC timedate format.';
          type: 'string';
        };
        billingPeriodEnvelopesAllowed: {
          description: 'The number of envelopes that can be sent in the current billing period (can be unlimited).';
          type: 'string';
        };
        billingPeriodEnvelopesSent: {
          description: 'The number of envelopes that have been sent in the current billing period.';
          type: 'string';
        };
        billingPeriodStartDate: {
          description: 'The billing period start date in UTC timedate format.';
          type: 'string';
        };
        billingProfile: {
          description: 'The type of billing method on the account. Valid values are: \n\n- `direct`\n- `web`';
          type: 'string';
        };
        brands: {
          $ref: '#/components/schemas/AccountBrands';
        };
        canUpgrade: {
          description: 'When **true,** specifies that you can upgrade the account through the API. For GET methods, you must set the `include_metadata` query parameter to **true** for this property to appear in the response.';
          type: 'string';
        };
        connectPermission: {
          description: '';
          type: 'string';
        };
        createdDate: {
          description: 'The creation date of the account in UTC timedate format.';
          type: 'string';
        };
        currencyCode: {
          description: 'The currency code for the account, based on the [ISO 4217 currency code](https://www.iso.org/iso-4217-currency-codes.html).';
          type: 'string';
        };
        currentPlanId: {
          description: 'ID of the plan used to create this account.';
          type: 'string';
        };
        displayApplianceStartUrl: {
          description: '';
          type: 'string';
        };
        displayApplianceUrl: {
          description: '';
          type: 'string';
        };
        distributorCode: {
          description: 'The code that identifies the billing plan groups and plans for the new account.';
          type: 'string';
        };
        docuSignLandingUrl: {
          description: 'URL of the landing page used to create the account.';
          type: 'string';
        };
        dssValues: {
          additionalProperties: {
            type: 'string';
          };
          description: '';
          type: 'object';
        };
        envelopeSendingBlocked: {
          description: 'When **true,** the ability to send envelopes is blocked. When **false,** envelopes can be sent.';
          type: 'string';
        };
        envelopeUnitPrice: {
          description: "The price of sending an envelope, represented in the account's local currency.";
          type: 'string';
        };
        externalAccountId: {
          description: "The Account ID displayed on the user's Account page.";
          type: 'string';
        };
        forgottenPasswordQuestionsCount: {
          description: ' A complex element that contains up to four Question/Answer pairs for forgotten password information for a user.';
          type: 'string';
        };
        isDowngrade: {
          description: 'When **true,** the account has been downgraded from a premium account type. Otherwise **false.**';
          type: 'string';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        planClassification: {
          description: 'Identifies the type of plan. Examples include:\n\n- `business`\n- `corporate`\n- `enterprise` \n- `free`';
          type: 'string';
        };
        planEndDate: {
          description: 'The date that the current plan will end.';
          type: 'string';
        };
        planName: {
          description: 'The name of the billing plan used for the account.\n\nExamples: \n\n- `Personal - Annual`\n- `Unlimited Envelope Subscription - Annual Billing`';
          type: 'string';
        };
        planStartDate: {
          description: 'The date that the Account started using the current plan.';
          type: 'string';
        };
        recipientDomains: {
          description: '';
          items: {
            $ref: '#/components/schemas/recipientDomain';
          };
          type: 'array';
        };
        seatsAllowed: {
          description: 'The number of active users the account can have at one time.';
          type: 'string';
        };
        seatsInUse: {
          description: 'The number of users currently active on the account.';
          type: 'string';
        };
        status21CFRPart11: {
          description: 'The status of the account content per (Title 21 CFR Part 11)[https://www.fda.gov/regulatory-information/search-fda-guidance-documents/part-11-electronic-records-electronic-signatures-scope-and-application]. This regulation defines the criteria under which electronic records and electronic signatures are considered trustworthy.';
          type: 'string';
        };
        suspensionDate: {
          description: 'The date on which the account was suspended.';
          type: 'string';
        };
        suspensionStatus: {
          description: 'Indicates whether the account is currently suspended.';
          type: 'string';
        };
        useDisplayAppliance: {
          description: '';
          type: 'boolean';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountInformation';
      'x-ds-order': '1';
      'x-ms-summary': 'Account management';
    };
    Authorizations: {
      description: '';
      properties: {
        agentUser: {
          $ref: '#/components/schemas/authorizationUser';
        };
        authorizationId: {
          description: '';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the workspace user authorization was created.';
          type: 'string';
        };
        createdBy: {
          description: '';
          type: 'string';
        };
        endDate: {
          description: '';
          type: 'string';
        };
        modified: {
          description: '';
          type: 'string';
        };
        modifiedBy: {
          description: 'The user ID (GUID) of the user who last modified this user record. This property is read-only.';
          type: 'string';
        };
        permission: {
          description: '';
          type: 'string';
        };
        principalUser: {
          $ref: '#/components/schemas/authorizationUser';
        };
        startDate: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'userAuthorization';
      'x-ds-order': '100';
      'x-ms-summary': '';
    };
    BCCEmailArchive: {
      description: 'The `EmailArchive` resource provides methods for managing your email archive configuration, which consists of the BCC email address or addresses that you want to use to archive DocuSign emails. Each account can use up to five BCC email addresses for archiving purposes.\n';
      properties: {
        bccEmailArchiveHistory: {
          description: 'A list of changes to the BCC email archive configuration.';
          items: {
            $ref: '#/components/schemas/bccEmailArchiveHistory';
          };
          type: 'array';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'EmailArchive';
      'x-ds-definition-name': 'bccEmailArchiveHistoryList';
      'x-ds-order': '120';
      'x-ms-summary': 'The `EmailArchive` resource provides methods for managing your email archive configuration, which consists of the BCC email address or addresses that you want to use to archive DocuSign emails. Each account can use up to five BCC email addresses for archiving purposes.\n';
    };
    BillingPlans: {
      description: 'Billing plans';
      properties: {
        billingAddress: {
          $ref: '#/components/schemas/accountAddress';
        };
        billingAddressIsCreditCardAddress: {
          description: 'When **true,** the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.';
          type: 'string';
        };
        billingPlan: {
          $ref: '#/components/schemas/accountBillingPlan';
        };
        creditCardInformation: {
          $ref: '#/components/schemas/creditCardInformation';
        };
        directDebitProcessorInformation: {
          $ref: '#/components/schemas/directDebitProcessorInformation';
        };
        downgradePlanInformation: {
          $ref: '#/components/schemas/downgradePlanUpdateResponse';
        };
        downgradeRequestInformation: {
          $ref: '#/components/schemas/downgradeRequestInformation';
        };
        entityInformation: {
          $ref: '#/components/schemas/billingEntityInformationResponse';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        paymentProcessorInformation: {
          $ref: '#/components/schemas/paymentProcessorInformation';
        };
        referralInformation: {
          $ref: '#/components/schemas/referralInformation';
        };
        successorPlans: {
          description: 'A list of billing plans that the current billing plan can be rolled into.';
          items: {
            $ref: '#/components/schemas/billingPlan';
          };
          type: 'array';
        };
        taxExemptId: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Billing';
      'x-ds-definition-name': 'accountBillingPlanResponse';
      'x-ds-order': '10';
      'x-ms-summary': 'Billing plans';
    };
    BulkSend: {
      description: 'The bulk send list resource provides methods that enable you to create and manage bulk sending lists, which you can use to send multiple copies of an envelope in a single batch. \n\n**Note:** The Bulk Send feature is only available on Business Pro and Enterprise Pro plans.';
      properties: {
        bulkCopies: {
          description: 'An array of `bulkCopy` objects. Each object represents an instance or copy of an envelope and contains details such as the recipient, custom fields, tabs, and other information.';
          items: {
            $ref: '#/components/schemas/bulkSendingCopy';
          };
          type: 'array';
        };
        listId: {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          type: 'string';
        };
        name: {
          description: 'The name of the bulk send list.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'BulkEnvelopes';
      'x-ds-definition-name': 'bulkSendingList';
      'x-ds-order': '120';
      'x-ms-summary': 'The bulk send list resource provides methods that enable you to create and manage bulk sending lists, which you can use to send multiple copies of an envelope in a single batch. \n\n**Note:** The Bulk Send feature is only available on Business Pro and Enterprise Pro plans.';
    };
    ChunkedUploads: {
      description: 'The ChunkedUploads resource provides methods to complete integrity checks, and to add, commit, retrieve, initiate and delete chunked uploads.';
      properties: {
        checksum: {
          description: 'A 64-byte, Secure Hash Algorithm 256 (SHA256) checksum that the caller computes across the entirety of the original content that has been uploaded to the chunked upload. DocuSign compares this value to its own computation. If the two values are not equal, the original content and received content are not the same and the commit action is refused.';
          type: 'string';
        };
        chunkedUploadId: {
          description: 'The ID of the chunked upload. ';
          type: 'string';
        };
        chunkedUploadParts: {
          description: 'A list of the parts that compose the chunked upload, including their byte sizes. The list must be contiguous before you can commit the chunked upload.';
          items: {
            $ref: '#/components/schemas/chunkedUploadPart';
          };
          type: 'array';
        };
        chunkedUploadUri: {
          description: 'The URI that you use to reference the chunked upload in other API requests, such as envelope document and envelope attachment requests. ';
          type: 'string';
        };
        committed: {
          description: 'When **true,** the chunked upload has been committed. A committed chunked upload can no longer receive any additional parts and is ready for use within other API requests. ';
          type: 'string';
        };
        expirationDateTime: {
          description: 'The UTC time at which the chunked upload expires and is no longer addressable. \n\n**Note:** The length of time before expiration is configurable, and begins when you initiate the chunked upload. You must fully upload and use a chunked upload within this time. The default value for this duration is 20 minutes.';
          type: 'string';
        };
        maxChunkedUploadParts: {
          description: 'The maximum number of parts allowed for a chunked upload. This value is configurable per DocuSign environment, account, or integrator. The default value is 128. The maximum possible value is 256.  \n';
          type: 'string';
        };
        maxTotalSize: {
          description: 'The maximum total size allowed for a chunked upload. This value is configured per DocuSign environment, account, or integrator. The default value is 50 MB.';
          type: 'string';
        };
        totalSize: {
          description: 'The total size of the parts of the chunked upload.\n\n**Note:** When a chunked upload is used as an envelope document, it is subject to the PDF size limit (25 MB) and page count limit that apply to all envelope documents.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'chunkedUploadResponse';
      'x-ds-order': '150';
      'x-ms-summary': 'The ChunkedUploads resource provides methods to complete integrity checks, and to add, commit, retrieve, initiate and delete chunked uploads.';
    };
    CloudStorage: {
      description: 'Cloud storage';
      properties: {
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/externalDocServiceErrorDetails';
        };
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        items: {
          description: 'A list of objects that contain information about a file or folder in cloud storage.';
          items: {
            $ref: '#/components/schemas/externalFile';
          };
          type: 'array';
        };
        name: {
          description: 'The name of the cloud storage item.';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'CloudStorage';
      'x-ds-definition-name': 'externalFolder';
      'x-ds-order': '10';
      'x-ms-summary': 'Cloud storage';
    };
    CloudStorageProviders: {
      description: 'The CloudStorageProviders resource provides methods that allow you to manage the cloud storage providers associate with an account.';
      properties: {
        storageProviders: {
          description: 'An Array containing the storage providers associated with the user.';
          items: {
            $ref: '#/components/schemas/cloudStorageProvider';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'CloudStorage';
      'x-ds-definition-name': 'cloudStorageProviders';
      'x-ds-order': '20';
      'x-ms-summary': 'The CloudStorageProviders resource provides methods that allow you to manage the cloud storage providers associate with an account.';
    };
    Comments: {
      description: 'Details about envelope comments.';
      properties: {
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        hmac: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        mentions: {
          description: 'An array of userIds that are mentioned directly in the body of a comment.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        read: {
          description: 'Indicates if the comment has been read by the target recipient of the comment.';
          type: 'boolean';
        };
        sentByEmail: {
          description: '';
          type: 'string';
        };
        sentByFullName: {
          description: '';
          type: 'string';
        };
        sentByImageId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        sentByInitials: {
          description: '';
          type: 'string';
        };
        sentByRecipientId: {
          description: '';
          type: 'string';
        };
        sentByUserId: {
          description: '';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
        subject: {
          description: '';
          type: 'string';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        text: {
          description: 'Specifies the text that is shown in the dropdown list. ';
          type: 'string';
        };
        threadId: {
          description: 'The unique identifier for the comment thread.';
          type: 'string';
        };
        threadOriginatorId: {
          description: 'The userId of the user who created the thread.';
          type: 'string';
        };
        timeStampFormatted: {
          description: '';
          type: 'string';
        };
        timestamp: {
          description: '';
          type: 'string';
        };
        visibleTo: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'comment';
      'x-ds-order': '160';
      'x-ms-summary': 'Details about envelope comments.';
    };
    ConnectConfigurations: {
      description: 'Contains information about a DocuSign Connect configuration.';
      properties: {
        allUsers: {
          description: 'When **true,** the tracked envelope and recipient events for all users, including users that are added a later time, are sent through Connect. The default value is **false.**\n\n**Note:** If this property is **false,** make sure you set the `userIds` property to a non-empty array of user IDs.';
          type: 'string';
        };
        allUsersExcept: {
          description: 'This flag allows you to toggle between including and excluding specified users from the configuration. When **false,** the users corresponding to the IDs in `userIds` will be included in the configuration. Conversely, when **true,** the users will be excluded from the configuration. The default value is **false.**';
          type: 'string';
        };
        allowEnvelopePublish: {
          description: 'When **true,** data is sent to the `urlToPublishTo` web address. The default value for this property is **false,** which will stop sending data while maintaining the Connect configuration information.';
          type: 'string';
        };
        allowSalesforcePublish: {
          description: 'When **true,** DocuSign sends data to the designated Salesforce account through Connect. The default value is **true.**';
          type: 'string';
        };
        configurationType: {
          description: 'If you are using merge fields, this property specifies the type of the merge field. The only supported value is `salesforce`.';
          type: 'string';
        };
        connectId: {
          description: 'The DocuSign-generated ID for the Connect configuration. This property is read-only.';
          type: 'string';
        };
        deliveryMode: {
          description: '';
          type: 'string';
        };
        disabledBy: {
          description: '';
          type: 'string';
        };
        enableLog: {
          description: 'When **true,** Connect logging is turned on. DocuSign recommends that you enable this functionality to help troubleshoot any issues. \n\nYou can have a maximum of 100 active logs in your account. You can view the entries in active logs in the **Logs** tab in the Connect console.';
          type: 'string';
        };
        envelopeEvents: {
          description: 'An array of strings that lists envelope-related events to track through Connect. The possible event values are: \n\n- `sent`: An envelope has the status `sent` in the following scenarios:\n   - When the envelope has been sent to recipients.\n   - When using remote signing, this event is triggered when the email notification with a link to the documents is sent to at least one recipient.\n   - When using embedded signing, this event is triggered when the link is ready for the recipient to sign the envelope.\n\n   An envelope remains in this state until all recipients have viewed or taken action on the envelope.\n\n- `delivered`: This status is triggered when all recipients have opened the envelope, selected the **Continue** button in the interface, and viewed the documents.\n- `completed`: This status is triggered when all recipients have completed their assigned actions on an envelope.\n- `declined`: This status is triggered when a recipient has declined to sign the envelope.\n- `voided`: The voided status indicates that the sender has voided the envelope.\n\n**Note:** In previous versions of the API, this value was a single comma-separated string.\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        eventData: {
          $ref: '#/components/schemas/connectEventData';
        };
        events: {
          description: 'A comma-separated list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `urlToPublishTo` property.\n\nSet this property when you are using the [JSON SIM event model](/platform/webhooks/connect/improved-json-sim-event-model/). If you are instead using any of [the legacy event message formats](/platform/webhooks/connect/legacy-message-formats/), set either the `envelopeEvents` property or the `recipientEvents` property.\n\nThe [possible event statuses](/platform/webhooks/connect/improved-json-sim-event-model/#eventreference) are:\n\n* `envelope-created`\n* `envelope-sent`\n* `envelope-resent`\n* `envelope-delivered`\n* `envelope-completed`\n* `envelope-declined`\n* `envelope-voided`\n* `recipient-authenticationfailed`\n* `recipient-autoresponded`\n* `recipient-declined`\n* `recipient-delivered`\n* `recipient-completed`\n* `recipient-sent`\n* `recipient-resent`\n* `template-created`\n* `template-modified`\n* `template-deleted`\n* `envelope-corrected`\n* `envelope-purge`\n* `envelope-deleted`\n* `envelope-discard`\n* `recipient-reassign`\n* `recipient-delegate`\n* `recipient-finish-later`\n* `click-agreed`\n* `click-declined`\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        externalFolderId: {
          description: 'The ID of an external folder.';
          type: 'string';
        };
        externalFolderLabel: {
          description: 'The label for an external folder.';
          type: 'string';
        };
        groupIds: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        includeCertSoapHeader: {
          description: 'When **true,** a certificate for a SOAP header is included in messages sent through Connect.';
          type: 'string';
        };
        includeCertificateOfCompletion: {
          description: 'When **true,** the Connect Service includes the Certificate of Completion with completed envelopes. ';
          type: 'string';
        };
        includeDocumentFields: {
          description: "When **true,** the Document Fields associated with the envelope's documents are included in the notification messages. Document Fields are optional custom name-value pairs added to documents using the API. ";
          type: 'string';
        };
        includeDocuments: {
          description: 'When **true,**\nConnect attaches the envelope documents\nto the payloads of your event notification messages.\n\n**Note:** Consider resources and scaling when adding documents\nto your event payloads. Documents attached to these messages\nare sent as base64 strings,\nwhich are larger than binary document data.\nThis can significantly increase your payload size,\nopening up windows for failure.\nIf you include documents,\nyou must build your application to scale in these situations.';
          type: 'string';
        };
        includeEnvelopeVoidReason: {
          description: 'When **true,** Connect will include the voidedReason for voided envelopes.';
          type: 'string';
        };
        includeHMAC: {
          description: 'When **true,** a Hash-based Message Authentication Code (HMAC) signature is included in messages sent through Connect.\nFor more information, see [Using HMAC Security with DocuSign Connect](/platform/webhooks/connect/hmac/).';
          type: 'string';
        };
        includeOAuth: {
          description: '';
          type: 'string';
        };
        includeSenderAccountasCustomField: {
          description: 'When **true,** Connect will include the sender account as Custom Field in the data.';
          type: 'string';
        };
        includeTimeZoneInformation: {
          description: 'When **true,** Connect will include the envelope time zone information.';
          type: 'string';
        };
        integratorManaged: {
          description: '';
          type: 'string';
        };
        name: {
          description: 'The name of the Connect configuration. The name helps identify the configuration in the list.';
          type: 'string';
        };
        password: {
          description: "The user's encrypted password hash.";
          type: 'string';
        };
        recipientEvents: {
          description: "An array of strings that lists of recipient-related events that trigger a notification\nto your webhook Connect listener. The possible event values are:\n\n- `sent`: If a recipient type is set to receive an email notification to take action on an envelope, the recipient status is set to `sent` upon delivery of the email.\n- `delivered`: The recipient has viewed the documents in the envelope. This recipient status does not indicate email delivery of the documents in the envelope.\n- `completed`: The recipient has completed their assigned actions on an envelope.\n- `declined`: The recipient has declined to sign a document in the envelope.\n- `authenticationfailed`: At least one signer has failed the authentication check on the document. If this occurs, you have two options:\n   - Send a reminder to the recipients, which provides the signer with another chance to access and pass the authentication.\n   - Correct the document and modify the authentication setting.\n- `autoresponded`: The recipient's email system sent back an automatic response. This status is only used when **Send-on-behalf-of** is turned off for the account.\n\n**Note:** In previous versions of the API, this value was a single comma-separated string.\n";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        requireMutualTls: {
          description: 'When **true,** [Mutual TLS](/platform/webhooks/mutual-tls/) authentication is enabled.';
          type: 'string';
        };
        requiresAcknowledgement: {
          description: 'When **true,** event delivery acknowledgements are enabled for your Connect configuration.\n\nDocuSign Connect awaits a valid 200 response from your application acknowledging that it received a message. If you do not acknowledge receiving an event notification message within 100 seconds, DocuSign treats the message as a failure and places it into a failure queue. It is imperative that you acknowledge successful receipt of Connect events as they occur by sending a 200 event back.\n\n#### When **true** and Send Individual Messages (SIM) mode is activated\n\nIf the HTTP status response to a notification message is not in the range of 200-299,\nthen the message delivery failed, and the configuration is marked as down.\n\nThe message will be queued and retried once per day.\nWhile a Connect configuration is marked down, subsequent notifications will not be tried. Instead they will be immediately queued with the reason `Pending`.\nWhen a message succeeds, all queued messages for the configuration will be tried immediately, in order.\n\nThere is a maximum of ten retries. Alternately, you can use **Republish Connect Information** to manually republish the notification.\n\n#### When **true** and SIM mode is not activated\n\nIf the HTTP Status response to a notification message is not in the range of 200-299,  then the message delivery failed, and the message is queued.\n\nThe message will be retried after at least a day the next time a subsequent message is successfully sent to this configuration (subscription).  Subsequent notifications will be tried when they occur.\nThere is a maximum of ten retries. Alternately, you can use **Republish Connect Information** to manually republish the notification.\n\n#### When **false**\n\nWhen `requiresAcknowledgement` is set to **false** and you do not acknowledge receiving an event notification message within 100 seconds, DocuSign treats the message as a failure and determines that the server is unavailable. It does not retry to send the notification message, and you must handle the failure manually.\n\n';
          type: 'string';
        };
        salesforceApiVersion: {
          description: 'The version of the Salesforce API that you are using.';
          type: 'string';
        };
        salesforceAuthcode: {
          description: '';
          type: 'string';
        };
        salesforceCallBackUrl: {
          description: '';
          type: 'string';
        };
        salesforceDocumentsAsContentFiles: {
          description: 'When **true,** DocuSign can use documents in your Salesforce account for sending and signing.';
          type: 'string';
        };
        senderOverride: {
          description: '';
          type: 'string';
        };
        senderSelectableItems: {
          description: 'This property sets the items that are available for selection when adding or editing Connect objects. ';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        sfObjects: {
          description: 'An array of Salesforce objects.';
          items: {
            $ref: '#/components/schemas/connectSalesforceObject';
          };
          type: 'array';
        };
        signMessageWithX509Certificate: {
          description: "When **true,** Mutual TLS will be enabled for notifications. Mutual TLS must be initiated by the listener (the customer's web server) during the TLS handshake protocol. ";
          type: 'string';
        };
        soapNamespace: {
          description: 'The namespace of the SOAP interface.\n\n**Note:** If `useSoapInterface` is set to **true,** you must set this value.';
          type: 'string';
        };
        urlToPublishTo: {
          description: "The endpoint to which Connect should send webhook notification messages via an HTTPS POST request. The URL must start with `https`. The customer's web server must use an SSL/TLS certificate whose CA is in the Microsoft list of trusted CAs. Self-signed certificates are not acceptable, but you can use free certificates from Let's Encrypt.\n\nThe maximum length of this property is 4096 bytes.";
          type: 'string';
        };
        useSoapInterface: {
          description: 'When **true,** indicates that the `urlToPublishTo` property contains a SOAP endpoint.';
          type: 'string';
        };
        userIds: {
          description: 'A comma-separated list of user IDs. This sets the users associated with the tracked envelope and recipient events. When a tracked event occurs for a set user, the a notification message is sent to your Connect listener.\n\nBy default, the users will be included in the configuration. If you want to exclude the users, set the `allUsersExcept` property to **true.**\n\n**Note:** If `allUsers` is set to `false`, then you must provide a list of user IDs.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        userName: {
          description: 'The name of the user.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Connect';
      'x-ds-definition-name': 'connectCustomConfiguration';
      'x-ds-order': '10';
      'x-ms-summary': 'Contains information about a DocuSign Connect configuration.';
    };
    ConnectEvents: {
      description: 'Connect event logging information. This object contains sections for regular Connect logs and for Connect failures. ';
      properties: {
        failures: {
          description: 'A list of Connect failure logs.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        logs: {
          description: 'A list of Connect general logs.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        totalRecords: {
          description: 'The count of records in the log list.';
          type: 'string';
        };
        type: {
          description: 'The type of this tab. Values are:\n\n- Approve\n- CheckBox\n- Company\n- Date\n- DateSigned,\tDecline\n- Email,\tEmailAddress\n- EnvelopeId\n- FirstName\n- Formula\n- FullName,\tInitialHere\n- InitialHereOptional\n- LastName\n- List\n- Note\n- Number\n- Radio\n- SignerAttachment\n- SignHere\n- SignHereOptional\n- Ssn\n- Text\n- Title\n- Zip5\n- Zip5Dash4\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Connect';
      'x-ds-definition-name': 'connectLogs';
      'x-ds-order': '20';
      'x-ms-summary': 'Connect event logging information. This object contains sections for regular Connect logs and for Connect failures. ';
    };
    ConnectSecret: {
      description: '';
      properties: {
        failures: {
          description: 'A list of Connect failure logs.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        logs: {
          description: 'A list of Connect general logs.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        totalRecords: {
          description: 'The count of records in the log list.';
          type: 'string';
        };
        type: {
          description: 'The type of this tab. Values are:\n\n- Approve\n- CheckBox\n- Company\n- Date\n- DateSigned,\tDecline\n- Email,\tEmailAddress\n- EnvelopeId\n- FirstName\n- Formula\n- FullName,\tInitialHere\n- InitialHereOptional\n- LastName\n- List\n- Note\n- Number\n- Radio\n- SignerAttachment\n- SignHere\n- SignHereOptional\n- Ssn\n- Text\n- Title\n- Zip5\n- Zip5Dash4\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Connect';
      'x-ds-definition-name': 'connectLogs';
      'x-ds-order': '50';
      'x-ms-summary': '';
    };
    Contacts: {
      description: "The `Contacts` resource enables you to manage the contact in an account's address book.";
      properties: {
        cloudProvider: {
          description: 'The cloud service that provided the contact. Valid values are:\n\n- `rooms`\n- `docusignCore` (default)\n\n<!-- Future:\n\n- `Box`\n- `GoogleDrive`\n- `Dropbox`\n- `SalesForce`\n- `SkyDrive`\n\n-->';
          type: 'string';
        };
        cloudProviderContainerId: {
          description: 'The ID of the container at the cloud provider. For example, this might be the room ID for a DocuSign Transaction Room.';
          type: 'string';
        };
        contactId: {
          description: "The ID of a contact person in the account's address book.";
          type: 'string';
        };
        contactPhoneNumbers: {
          description: "A list of the contact's phone numbers.\n\n**Note:** The phone numbers associated with shared contacts do not display to users other than the user who added the contact. Additionally, in the following scenarios, the phone number of a shared contact does not populate automatically for anyone other than the user who added the contact:\n\n- Sending an envelope by using SMS\n- Using phone authentication\n\nYou must ask the user who added the contact for the phone number and then manually enter it into the authentication box.";
          items: {
            $ref: '#/components/schemas/contactPhoneNumber';
          };
          type: 'array';
        };
        contactUri: {
          description: 'The URI for retrieving information about the contact.';
          type: 'string';
        };
        emails: {
          description: 'The email address or addresses associated with the contact.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        isOwner: {
          description: 'When **true,** the current user is the owner of the contact.';
          type: 'boolean';
        };
        name: {
          description: 'The name of the contact.';
          type: 'string';
        };
        notaryContactDetails: {
          $ref: '#/components/schemas/notaryContactDetails';
        };
        organization: {
          description: "The name of the contact's organization.";
          type: 'string';
        };
        roomContactType: {
          description: '';
          type: 'string';
        };
        shared: {
          description: 'When **true,** the contact is shared. For more information, see [Shared Contacts](https://support.docusign.com/guides/ndse-user-guide-manage-contacts).\n\n**Note:** The phone numbers associated with shared contacts do not display to users other than the user who added the contact. Additionally, in the following scenarios, the phone number of a shared contact does not populate automatically for anyone other than the user who added the contact:\n\n- Sending an envelope by using SMS\n- Using phone authentication\n\nYou must ask the user who added the contact for the phone number and then manually enter it into the authentication box.';
          type: 'string';
        };
        signingGroup: {
          description: 'If the contact belongs to a signing group, this property contains the `signingGroupId`.';
          type: 'string';
        };
        signingGroupName: {
          description: 'The name of the signing group that the contact belongs to.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Users';
      'x-ds-definition-name': 'contact';
      'x-ds-order': '50';
      'x-ms-summary': "The `Contacts` resource enables you to manage the contact in an account's address book.";
    };
    CustomTabs: {
      description: 'Custom tabs';
      properties: {
        anchor: {
          description: 'An optional string that is used to auto-match tabs to strings located in the documents of an envelope.';
          type: 'string';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        collaborative: {
          description: '';
          type: 'string';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        createdByDisplayName: {
          description: 'The user name of the DocuSign user who created this object.';
          type: 'string';
        };
        createdByUserId: {
          description: 'The userId of the DocuSign user who created this object.';
          type: 'string';
        };
        customTabId: {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. This property can only be used when adding new tabs for a recipient. When used, the new tab inherits all of the custom tab properties.';
          type: 'string';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        editable: {
          description: 'When **true,** the custom tab is editable. Otherwise the custom tab cannot be modified.';
          type: 'string';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        includedInEmail: {
          description: 'When **true,** the tab is included in e-mails related to the envelope on which it exists. This applies to only specific tabs.';
          type: 'string';
        };
        initialValue: {
          description: 'The original value of the tab.';
          type: 'string';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        items: {
          description: 'If the tab is a list, this represents the values that are possible for the tab.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        lastModified: {
          description: 'The UTC DateTime this object was last modified. This is in ISO 8601 format.';
          type: 'string';
        };
        lastModifiedByDisplayName: {
          description: 'The User Name of the DocuSign user who last modified this object.';
          type: 'string';
        };
        lastModifiedByUserId: {
          description: 'The userId of the DocuSign user who last modified this object.';
          type: 'string';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        maxNumericalValue: {
          description: '';
          type: 'string';
        };
        maximumLength: {
          description: 'The maximum number of entry characters supported by the custom tab.';
          type: 'string';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        minNumericalValue: {
          description: '';
          type: 'string';
        };
        name: {
          description: 'The name of the custom tab.';
          type: 'string';
        };
        numericalValue: {
          description: '';
          type: 'string';
        };
        paymentItemCode: {
          description: 'If the custom tab is for a payment request, this is the external code for the item associated with the charge. For example, this might be your product id.\n\nExample: `SHAK1`\n\nMaximum Length: 100 characters.';
          type: 'string';
        };
        paymentItemDescription: {
          description: 'If the custom tab is for a payment request, this is the description of the item associated with the charge.\n\nExample: `The Danish play by Shakespeare`\n\nMaximum Length: 100 characters.';
          type: 'string';
        };
        paymentItemName: {
          description: 'If the custom tab is for a payment request, this is the name of the item associated with the charge.\n\nMaximum Length: 100 characters.\n\nExample: `Hamlet`';
          type: 'string';
        };
        requireAll: {
          description: 'When **true** and shared is true, information must be entered in this field to complete the envelope. ';
          type: 'string';
        };
        requireInitialOnSharedChange: {
          description: 'Optional element for field markup. When **true,** the signer is required to initial when they modify a shared field.';
          type: 'string';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        scaleValue: {
          description: 'Sets the size of the tab. This field accepts values from `0.5` to `1.0`, where `1.0` represents full size and `0.5` is 50% of full size.';
          type: 'string';
        };
        selected: {
          description: 'When **true,** the radio button is selected.';
          type: 'string';
        };
        shared: {
          description: 'When **true,** this custom tab is shared.';
          type: 'string';
        };
        signatureProviderId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        stampType: {
          description: 'The type of stamp. Valid values are:\n\n- `signature`: A signature image. This is the default value.\n- `stamp`: A stamp image.\n- null';
          type: 'string';
        };
        stampTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        type: {
          description: 'The type of this tab. Values are:\n\n- Approve\n- CheckBox\n- Company\n- Date\n- DateSigned,\tDecline\n- Email,\tEmailAddress\n- EnvelopeId\n- FirstName\n- Formula\n- FullName,\tInitialHere\n- InitialHereOptional\n- LastName\n- List\n- Note\n- Number\n- Radio\n- SignerAttachment\n- SignHere\n- SignHereOptional\n- Ssn\n- Text\n- Title\n- Zip5\n- Zip5Dash4\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        validationMessage: {
          description: 'The message displayed if the custom tab fails input validation (either custom of embedded).';
          type: 'string';
        };
        validationPattern: {
          description: 'A regular expression used to validate input for the tab.';
          type: 'string';
        };
        validationType: {
          description: '';
          type: 'string';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'CustomTabs';
      'x-ds-definition-name': 'tabMetadata';
      'x-ds-order': '10';
      'x-ms-summary': 'Custom tabs';
    };
    DocumentGeneration: {
      description: '';
      properties: {
        docGenFormFields: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenFormFields';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'docGenFormFieldResponse';
      'x-ds-order': '100';
      'x-ms-summary': '';
    };
    DocumentResponsiveHtml: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '100';
      'x-ms-summary': '';
    };
    DocumentResponsiveHtmlPreview: {
      description: 'This resource is used to create a responsive preview of a specific document.';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitions';
      'x-ds-order': '230';
      'x-ms-summary': 'This resource is used to create a responsive preview of a specific document.';
    };
    ENoteConfigurations: {
      description: '';
      properties: {
        apiKey: {
          description: '';
          type: 'string';
        };
        connectConfigured: {
          description: '';
          type: 'string';
        };
        eNoteConfigured: {
          description: '';
          type: 'string';
        };
        organization: {
          description: '';
          type: 'string';
        };
        password: {
          description: "The user's encrypted password hash.";
          type: 'string';
        };
        userName: {
          description: 'The name of the user.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'eNoteConfiguration';
      'x-ds-order': '110';
      'x-ms-summary': '';
    };
    EnvelopeAttachments: {
      description: 'The EnvelopeAttachments resource provides methods that allow you to manage attachments.\n';
      properties: {
        accessControl: {
          description: 'Valid values are `sender` and `senderAndAllRecipients`.';
          type: 'string';
        };
        attachmentId: {
          description: 'The unique identifier for the attachment.';
          type: 'string';
        };
        attachmentType: {
          description: 'Specifies the type of the attachment for the recipient. Possible values are:\n\n- `.htm`\n- `.xml`';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        label: {
          description: 'A label for the attachment. Potential values include: \n\n- `guidedForm`: [Guided forms](https://www.docusign.com/products/guided-forms) provide a step-by-step, mobile-ready experience to help signers easily complete long or complex forms.\n- `eventNotifications`: A list of envelope-level event statuses that trigger Connect to send updates to the endpoint specified in the `url` property. ';
          type: 'string';
        };
        name: {
          description: 'The name of the attachment.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelopeAttachment';
      'x-ds-order': '60';
      'x-ms-summary': 'The EnvelopeAttachments resource provides methods that allow you to manage attachments.\n';
    };
    EnvelopeConsumerDisclosures: {
      description: 'Details about envelope consumer disclosures.';
      properties: {
        accountEsignId: {
          description: 'The GUID of the account associated with the consumer disclosure.';
          type: 'string';
        };
        allowCDWithdraw: {
          description: 'When **true,** indicates that the customer can withdraw their consent to the consumer disclosure when they decline to sign documents. If these recipients sign documents sent to them from your account in the future, they will be required to agree to the terms in the disclosure. The default value is **false.**\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowCDWithdrawMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        changeEmail: {
          description: 'If the customer needs to change their email address, this is the email address to which they should the change request.';
          type: 'string';
        };
        changeEmailOther: {
          description: 'Other information about the requirements for the user to change their email address.\n\nExample: \n\n`We do not require any other information from you to change your email address.`';
          type: 'string';
        };
        companyName: {
          description: "Specifies the company name used in the disclosure. The default value is the account name.\n\nHowever, if your account uses signing brands that specify a company name, you can substitute the brand's company name by setting the `useBrand` property to **true.** Whenever an envelope is sent from the account that uses a signing brand with a specified `companyName`, that value is used in email notifications and in the signing experience.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. You must also set the value of the `useBrand` property to **true.**\n";
          type: 'string';
        };
        companyPhone: {
          description: 'The phone number of the company associated with the consumer disclosure, as a free-formatted string.';
          type: 'string';
        };
        copyCostPerPage: {
          description: 'The cost per page if the customer requests paper copies.\n\nExample: \n\n`0.0000`';
          type: 'string';
        };
        copyFeeCollectionMethod: {
          description: 'Specifies the fee collection method for cases in which the customer requires paper copies of the document.\n\nMaximum length: 255 characters.\n\nExample: \n\n`We will bill you for any fees at that time, if any.`';
          type: 'string';
        };
        copyRequestEmail: {
          description: 'The email address to which the customer should send a request for copies of a document.\n\nMaximum length: 100 characters.';
          type: 'string';
        };
        custom: {
          description: 'When **true,** indicates that the consumer disclosure is a custom disclosure. The default is **false.**';
          type: 'string';
        };
        enableEsign: {
          description: 'When **true** (default), indicates that eSign is enabled.';
          type: 'string';
        };
        esignAgreement: {
          description: 'The final, assembled text of the Electronic Record and Signature Disclosure that includes the appropriate `companyName` and other specifics. It also includes the HTML tags used for formatting.';
          type: 'string';
        };
        esignText: {
          description: 'The template for the Electronic Record and Signature Disclosure, which contains placeholders for information such as the `companyName`. It also includes the HTML tags used for formatting.\n\n**Note:** If you are switching to or updating a custom disclosure, you can edit both the text and the HTML formatting.';
          type: 'string';
        };
        languageCode: {
          description: 'The simple type enumeration for the language to use when displaying the disclosure. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          type: 'string';
        };
        mustAgreeToEsign: {
          description: "When **true,** the  recipient must agree to the consumer disclosure. The value of this property is read-only. It is calculated based on the account setting `consumerDisclosureFrequency` and the user's actions.";
          type: 'string';
        };
        pdfId: {
          description: '**Deprecated.** \n\nThe `pdfId` property in the consumer_disclosure PUT request is deprecated. For security reasons going forward, any value provided in the request packet must be ignored. ';
          type: 'string';
        };
        useBrand: {
          description: 'When **true,** specifies that the company name in the signing brand is used for the disclosure. Whenever an envelope is sent from the account that uses a signing brand with a specified company name, that value is used in email notifications and in the signing experience.  \n\nWhen **false** (default), or if the signing brand does not specify a company name, the account name is used instead.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. ';
          type: 'string';
        };
        useConsumerDisclosureWithinAccount: {
          description: 'When **true,** specifies that recipients in the same account as the sender must agree to eSign an Electronic Record and Signature Disclosure Statement.';
          type: 'string';
        };
        useConsumerDisclosureWithinAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        withdrawAddressLine1: {
          description: 'Contains the first address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawAddressLine2: {
          description: 'Contains the second address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawByEmail: {
          description: 'When **true** (default), indicates that the customer can withdraw consent by email.';
          type: 'string';
        };
        withdrawByMail: {
          description: 'When **true,** indicates that the customer can withdraw consent by postal mail. The default is **false.**';
          type: 'string';
        };
        withdrawByPhone: {
          description: 'When **true,** indicates that the customer can withdraw consent by phone. The default is **false.**';
          type: 'string';
        };
        withdrawCity: {
          description: 'Contains the city of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 50 characters. ';
          type: 'string';
        };
        withdrawConsequences: {
          description: 'Text indicating the consequences of withdrawing consent.\n\nMaximum length: 255 characters.';
          type: 'string';
        };
        withdrawEmail: {
          description: 'Contains the email address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawOther: {
          description: 'Contains any other information needed to withdraw consent.\n\nMaximum length: 255 characters.\n\nExample:\n\n`We do not need any other information from you to withdraw consent.`';
          type: 'string';
        };
        withdrawPhone: {
          description: 'Contains the phone number that a customer can call to register consent withdrawal notification as a free-formatted string.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawPostalCode: {
          description: 'Contains the postal code of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawState: {
          description: 'Contains the state of the postal address to which a customer can send a consent withdrawal notification.\n\nExample: `PA`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'consumerDisclosure';
      'x-ds-order': '90';
      'x-ms-summary': 'Details about envelope consumer disclosures.';
    };
    EnvelopeCustomFields: {
      description: 'An envelope custom field enables you to collect custom data about envelopes on a per-envelope basis. You can then use the custom data for sorting, organizing, searching, and other downstream processes. For example, you can use custom fields to copy envelopes or data to multiple areas in Salesforce. eOriginal customers can eVault their documents from the web app on a per-envelope basis by setting an envelope custom field with a name like "eVault with eOriginal?" to "Yes" or "No".\n\nWhen a user creates an envelope, the envelope custom fields display in the **Envelope Settings** section of the DocuSign console. Envelope recipients do not see the envelope custom fields. For more information, see [Envelope Custom Fields](https://support.docusign.com/en/guides/ndse-admin-guide-document-labels).';
      properties: {
        listCustomFields: {
          description: 'An array of list custom fields.';
          items: {
            $ref: '#/components/schemas/listCustomField';
          };
          type: 'array';
        };
        textCustomFields: {
          description: 'An array of text custom fields.';
          items: {
            $ref: '#/components/schemas/textCustomField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'customFields';
      'x-ds-order': '70';
      'x-ms-summary': 'An envelope custom field enables you to collect custom data about envelopes on a per-envelope basis. You can then use the custom data for sorting, organizing, searching, and other downstream processes. For example, you can use custom fields to copy envelopes or data to multiple areas in Salesforce. eOriginal customers can eVault their documents from the web app on a per-envelope basis by setting an envelope custom field with a name like "eVault with eOriginal?" to "Yes" or "No".\n\nWhen a user creates an envelope, the envelope custom fields display in the **Envelope Settings** section of the DocuSign console. Envelope recipients do not see the envelope custom fields. For more information, see [Envelope Custom Fields](https://support.docusign.com/en/guides/ndse-admin-guide-document-labels).';
    };
    EnvelopeDocumentFields: {
      description: 'Envelope document fields';
      properties: {
        documentFields: {
          description: 'The array of name/value custom data strings to be added to a document. Custom document field information is returned in the status, but otherwise is not used by DocuSign. The array contains the elements: \n\n* name - A string that can be a maximum of 50 characters. \n* value - A string that can be a maximum of 200 characters.\n\n*IMPORTANT*: If you are using xml, the name/value pair is contained in a nameValue element. \n';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentFieldsInformation';
      'x-ds-order': '60';
      'x-ms-summary': 'Envelope document fields';
    };
    EnvelopeDocumentHtmlDefinitions: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '220';
      'x-ms-summary': '';
    };
    EnvelopeDocumentTabs: {
      description: 'Document tabs are tabs that are associated with a document rather than with a recipient.';
      properties: {
        approveTabs: {
          description: "A list of\n[Approve tabs][approve].\n\nAn Approve tab enables\nthe recipient to approve documents without\nplacing a signature or initials on the document. If the\nrecipient clicks the tab during the signing process, the\nrecipient is considered to have signed the document. No\ninformation is shown on the document of the approval, but it\nis recorded as a signature in the envelope history.\nThe value of an approve tab can't be set.\n\n[approve]:\t\t      /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/approve';
          };
          type: 'array';
        };
        checkboxTabs: {
          description: 'A list of\n[Checkbox tabs][checkbox].\n\n\nA Checkbox tab enables the recipient to select a yes/no (on/off) option. This value can be set.\n\n\n[checkbox]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/checkbox';
          };
          type: 'array';
        };
        commentThreadTabs: {
          description: "An array of tabs that represents a collection of comments in a comment thread. For example, if a recipient has questions about the content of a document, they can add a comment to the document and control who else can see the comment. This value can't be set.";
          items: {
            $ref: '#/components/schemas/commentThread';
          };
          type: 'array';
        };
        commissionCountyTabs: {
          description: "A list of\n[Commission County tabs][cc].\n\n\nA Commission County tab displays the county of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionCounty';
          };
          type: 'array';
        };
        commissionExpirationTabs: {
          description: "A list of\n[Commission Expiration tabs][tabref].\n\n\nA Commission Expiration tab displays the expiration date of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionExpiration';
          };
          type: 'array';
        };
        commissionNumberTabs: {
          description: "A list of\n[Commission Number tabs][tabref].\n\n\nA Commission Number tab displays a notary's commission number. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionNumber';
          };
          type: 'array';
        };
        commissionStateTabs: {
          description: "A list of\n[Commission State tabs][cc].\n\n\nA Commission County tab displays the state in which a notary's commission was granted. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionState';
          };
          type: 'array';
        };
        companyTabs: {
          description: "A list of\n[Company tabs][company].\n\nA Company tab displays a field for the name of the recipient's company. This value can't be set.\n\n[company]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_company\n";
          items: {
            $ref: '#/components/schemas/company';
          };
          type: 'array';
        };
        dateSignedTabs: {
          description: "A list of\n[Date Signed tabs][dateSigned].\n\n\nA Date Signed tab displays the date that the recipient signed the document. This value can't be set.\n\n[dateSigned]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/dateSigned';
          };
          type: 'array';
        };
        dateTabs: {
          description: "A list of\n[Date tabs][date].\n\nA Date tab enables the recipient to enter a date. This value can't be set. The tooltip for this tab recommends the date format MM/DD/YYYY, but several other date formats are also accepted. The system retains the format that the recipient enters.\n\n**Note:** If you need to enforce a specific date format, DocuSign recommends that you use a Text tab with a validation pattern and validation message.\n\n\n[date]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/date';
          };
          type: 'array';
        };
        declineTabs: {
          description: "A list of\n[Decline tabs][decline].\n\nA Decline tab enables the recipient to decline the envelope. If the recipient clicks the tab during the signing process, the envelope is voided. The value of this tab can't be set.\n\n\n[decline]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/decline';
          };
          type: 'array';
        };
        drawTabs: {
          description: 'A list of Draw Tabs.\n\nA Draw Tab allows the recipient to add a free-form drawing to the document.';
          items: {
            $ref: '#/components/schemas/draw';
          };
          type: 'array';
        };
        emailAddressTabs: {
          description: "A list of\n[Email Address tabs][emailAddress].\n\nAn Email Address tab displays the recipient's email as entered in the recipient information. This value can't be set.\n\n\n[emailAddress]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/emailAddress';
          };
          type: 'array';
        };
        emailTabs: {
          description: 'A list of\n[Email tabs][email].\n\nAn Email tab enables the recipient to enter an email address.\nThis is a one-line field that checks that a valid email\naddress is entered. It uses the same parameters as a Text\ntab, with the validation message and pattern set for email\ninformation. This value can be set.\n\nWhen getting information that includes\nthis tab type, the original value of the tab when the\nassociated envelope was sent is included in the response.\n\n[email]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/email';
          };
          type: 'array';
        };
        envelopeIdTabs: {
          description: "A list of\n[Envelope ID tabs][envelopeId].\n\nAn Envelope ID tab  displays the envelope ID. Recipients cannot enter or change the information in this tab. This value can't be set.\n\n\n[envelopeId]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#response201_envelopeid\n";
          items: {
            $ref: '#/components/schemas/envelopeId';
          };
          type: 'array';
        };
        firstNameTabs: {
          description: "A list of\n[First Name tabs][firstName].\n\nA First Name tab displays the recipient's first name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[firstName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_firstname\n";
          items: {
            $ref: '#/components/schemas/firstName';
          };
          type: 'array';
        };
        formulaTabs: {
          description: 'A list of [Formula tabs][formulaTab].\n\nThe value of a Formula tab is calculated from the values of other number or date tabs in the document. When the recipient completes the underlying fields, the Formula tab calculates and displays the result. This value can be set.\n\nThe `formula` property of the tab contains the references to the underlying tabs. To learn more about formulas, see [Calculated Fields][calculatedfields].\n\nIf a Formula tab contains a `paymentDetails` property, the tab is considered a payment item. To learn more about payments, see [Requesting Payments Along with Signatures][paymentguide].\n\n[calculatedfields]: https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields\n[paymentguide]:     https://support.docusign.com/en/guides/requesting-payments-along-with-signatures\n[formulaTab]:\t    \t/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/formulaTab';
          };
          type: 'array';
        };
        fullNameTabs: {
          description: "A list of\n[Full Name tabs][fullName].\n\nA Full Name tab displays the recipient's full name. This value can't be set.\n\n\n[fullName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/fullName';
          };
          type: 'array';
        };
        initialHereTabs: {
          description: "A list of\n[Initial Here tabs][initialHere].\n\nThis type of tab enables the recipient to initial the document. May be optional. This value can't be set.\n\n[initialHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/initialHere';
          };
          type: 'array';
        };
        lastNameTabs: {
          description: "A list of\n[Last Name tabs][lastName].\n\nA Last Name tab displays the recipient's last name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[lastName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/lastName';
          };
          type: 'array';
        };
        listTabs: {
          description: "An array of List tabs.\n\nA List tab enables the recipient to choose from a list of options. You specify the options in the `listItems` property. This value can't be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/list';
          };
          type: 'array';
        };
        notarizeTabs: {
          description: 'A list of  [Notarize tabs][notarize].\n\nA Notarize tab alerts notary recipients that they must take action on the page. This value can be set.\n\n**Note:** Only one notarize tab can appear on a page.\n\n[notarize]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/notarize';
          };
          type: 'array';
        };
        notarySealTabs: {
          description: 'A list of Notary Seal tabs.\n\nA Notary Seal tab enables the recipient to notarize a document. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/notarySeal';
          };
          type: 'array';
        };
        noteTabs: {
          description: 'A list of\n[Note tabs][note].\n\nA Note tab displays additional information to the recipient in the form of a note. This value can be set.\n\n[note]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/note';
          };
          type: 'array';
        };
        numberTabs: {
          description: 'A list of\n[Number tabs][number].\n\nA Number tab enables the recipient to enter numbers and decimal points (.). This value can be set.\n\n\n\n[number]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/number';
          };
          type: 'array';
        };
        numericalTabs: {
          description: '';
          items: {
            $ref: '#/components/schemas/numerical';
          };
          type: 'array';
        };
        phoneNumberTabs: {
          description: 'A list of\n[Phone Number tabs][cc].\n\n\nA Phone Number tab enables a recipient to enter a phone number.\n\n**Note:** This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/phoneNumber';
          };
          type: 'array';
        };
        polyLineOverlayTabs: {
          description: "This type of tab enables the recipient to strike through document text. This value can't be set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ";
          items: {
            $ref: '#/components/schemas/polyLineOverlay';
          };
          type: 'array';
        };
        prefillTabs: {
          $ref: '#/components/schemas/prefillTabs';
        };
        radioGroupTabs: {
          description: 'A list of [Radio Group tabs][radioGroup].\n\nA Radio Group tab places a group of radio buttons on a document. The `radios` property is used to add and place the radio\nbuttons associated with the group. Only one radio button can be selected in a group. This value can be set.\n\n\n[radioGroup]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/radioGroup';
          };
          type: 'array';
        };
        signHereTabs: {
          description: "A list of\n[Sign Here tabs][signHere].\n\nThis type of tab enables the recipient to sign a document. May be optional. This value can't be set.\n\n[signHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signHere';
          };
          type: 'array';
        };
        signerAttachmentTabs: {
          description: "A list of\n[Signer Attachment tabs][signerAttachment].\n\nThis type of tab enables the recipient to attach supporting documents to an envelope. This value can't be set.\n\n\n[signerAttachment]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signerAttachment';
          };
          type: 'array';
        };
        smartSectionTabs: {
          description: 'A list of [Smart Section](https://www.docusign.com/blog/dsdev-deep-dive-responsive-smart-sections) tabs.\n\nSmart Section tabs enhance responsive signing on mobile devices by enabling collapsible sections, page breaks, custom formatting options, and other advanced functionality.\n\n**Note:** Smart Sections are a premium feature. Responsive signing must also be enabled for your account.';
          items: {
            $ref: '#/components/schemas/smartSection';
          };
          type: 'array';
        };
        ssnTabs: {
          description: 'A list of\n[SSN tabs][ssn].\n\nAn SSN tab contains a one-line field that enables the recipient to enter a Social Security Number (SSN) with or without\ndashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information. This value can be set.\n\n\n[ssn]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/ssn';
          };
          type: 'array';
        };
        tabGroups: {
          description: "An array of `tabGroup` items.\n\nTo associate a tab with a tab group, add the tab group's `groupLabel` to the tab's `tabGroupLabels` array.\n";
          items: {
            $ref: '#/components/schemas/tabGroup';
          };
          type: 'array';
        };
        textTabs: {
          description: 'A list of\nText tabs.\n\nA text tab enables the recipient to enter free text. This value can be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/text';
          };
          type: 'array';
        };
        titleTabs: {
          description: "A list of\n[Title tabs][title].\n\nA Title tab displays the recipient's title.  This value can't be set.\n\n\n[title]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/title';
          };
          type: 'array';
        };
        viewTabs: {
          description: 'A list of\n[View tabs][view].\n\nA View tab is used with an Approve tab to handle supplemental documents.  This value can be set.\n\n[view]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/view';
          };
          type: 'array';
        };
        zipTabs: {
          description: 'A list of\n[Zip tabs][zip].\n\nA Zip tab enables the recipient to enter a ZIP code. The ZIP code can be five digits or nine digits ( in ZIP+4 format), and can be entered with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  This value can be set.\n\n\n[zip]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/zip';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'tabs';
      'x-ds-order': '50';
      'x-ms-summary': 'Document tabs are tabs that are associated with a document rather than with a recipient.';
    };
    EnvelopeDocumentVisibility: {
      description: "Document Visibility enables senders to control the visibility of the documents in an envelope at the recipient level. For example, if the parties associated with a legal proceeding should have access to different documents, the Document Visibility feature enables you to keep all of the documents in the same envelope and set view permissions for the documents by recipient. This functionality is enabled for envelopes and templates. It is not available for PowerForms.\n\n**Note:** Before you use Document Visibility, you should be aware of the following information:\n\n- Document Visibility must be enabled for your account by your DocuSign administrator. \n- A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. \n- When the Document Visibility setting hides a document from a recipient, the document also does not appear in the recipient's list of envelopes, documents, or page images.\n- Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all of the documents associated with the envelope or template.\n\nThe Document Visibility feature has multiple settings that specify the options that senders have when sending documents. For more information, see [Use Document Visibility to Control Recipient Access](https://support.docusign.com/en/guides/ndse-user-guide-document-visibility).";
      properties: {
        documentVisibility: {
          description: 'An array of `documentVisibility` objects that specifies which documents are visible to which recipients.';
          items: {
            $ref: '#/components/schemas/documentVisibility';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentVisibilityList';
      'x-ds-order': '170';
      'x-ms-summary': "Document Visibility enables senders to control the visibility of the documents in an envelope at the recipient level. For example, if the parties associated with a legal proceeding should have access to different documents, the Document Visibility feature enables you to keep all of the documents in the same envelope and set view permissions for the documents by recipient. This functionality is enabled for envelopes and templates. It is not available for PowerForms.\n\n**Note:** Before you use Document Visibility, you should be aware of the following information:\n\n- Document Visibility must be enabled for your account by your DocuSign administrator. \n- A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. \n- When the Document Visibility setting hides a document from a recipient, the document also does not appear in the recipient's list of envelopes, documents, or page images.\n- Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all of the documents associated with the envelope or template.\n\nThe Document Visibility feature has multiple settings that specify the options that senders have when sending documents. For more information, see [Use Document Visibility to Control Recipient Access](https://support.docusign.com/en/guides/ndse-user-guide-document-visibility).";
    };
    EnvelopeDocuments: {
      description: 'Envelope documents';
      properties: {
        envelopeDocuments: {
          description: 'An array of document objects.';
          items: {
            $ref: '#/components/schemas/envelopeDocument';
          };
          type: 'array';
        };
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelopeDocumentsResult';
      'x-ds-order': '40';
      'x-ms-summary': 'Envelope documents';
    };
    EnvelopeEmailSettings: {
      description: 'Envelope email settings';
      properties: {
        bccEmailAddresses: {
          description: 'An array containing the email address that should receive a copy of all email communications related to an envelope for archiving purposes. Maximum Length: 100 characters.\n\nWhile this property is an array, note that it takes only a single email address.\n\n**Note:** Only users with the `canManageAccount` setting set to **true** can use this option. \n\nDocuSign verifies that the email format is correct, but does not verify that the email address is active. You can use this for archiving purposes. However, using this property overrides the BCC for Email Archive information setting for this envelope. \n\n**Example:** if your account has BCC for Email Archive set up for the email address archive@mycompany.com and you send an envelope using the BCC Email Override to send a BCC email to salesarchive@mycompany.com, then a copy of the envelope is only sent to the salesarchive@mycompany.com email address.';
          items: {
            $ref: '#/components/schemas/bccEmailAddress';
          };
          type: 'array';
        };
        replyEmailAddressOverride: {
          description: 'The Reply To email address to use for email replies, instead of the one that is configured at the account level. DocuSign verifies that the email address is in a correct format, but does not verify that it is active. Maximum Length: 100 characters.';
          type: 'string';
        };
        replyEmailNameOverride: {
          description: 'The name to associate with the Reply To email address, instead of the name that is configured at the account level. Maximum Length: 100 characters.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'emailSettings';
      'x-ds-order': '30';
      'x-ms-summary': 'Envelope email settings';
    };
    EnvelopeFormData: {
      description: 'This object contains the data that recipients have entered into the form fields associated with an envelope.';
      properties: {
        emailSubject: {
          description: 'The subject line of the email message that is sent to all recipients.\n\nFor information about adding merge field information to the email subject, see [Template Email Subject Merge Fields](/docs/esign-rest-api/reference/templates/templates/create/#template-email-subject-merge-fields).\n\n**Note:** The subject line is limited to 100 characters, including any merged fields.It is not truncated. It is an error if the text is longer than 100 characters.\n';
          type: 'string';
        };
        envelopeId: {
          description: 'The ID of the envelope.';
          type: 'string';
        };
        formData: {
          description: 'An array of form data objects.';
          items: {
            $ref: '#/components/schemas/formDataItem';
          };
          type: 'array';
        };
        prefillFormData: {
          $ref: '#/components/schemas/prefillFormData';
        };
        recipientFormData: {
          description: 'An array of form data objects that are associated with specific recipients.';
          items: {
            $ref: '#/components/schemas/recipientFormData';
          };
          type: 'array';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* `completed`: The recipients have finished working with the envelope: the documents are signed and all required tabs are filled in.\n* `created`: The envelope is created as a draft. It can be modified and sent later.\n* `declined`: The envelope has been declined by the recipients.\n* `delivered`: The envelope has been delivered to the recipients.\n* `sent`: The envelope will be sent to the recipients after the envelope is created.\n* `signed`: The envelope has been signed by the recipients.\n* `voided`: The envelope is no longer valid and recipients cannot access or sign the envelope.\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelopeFormData';
      'x-ds-order': '160';
      'x-ms-summary': 'This object contains the data that recipients have entered into the form fields associated with an envelope.';
    };
    EnvelopeHtmlDefinitions: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '240';
      'x-ms-summary': '';
    };
    EnvelopeLocks: {
      description: 'Envelope locks let you lock an envelope to prevent any changes while you are updating an envelope.\n';
      properties: {
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        lockDurationInSeconds: {
          description: '\nThe number of seconds until the lock expires when there is no activity on the envelope.\n\nThe default value is 300 seconds. The maximum value is 1,800 seconds.\n\nThe lock duration can be extended.\n';
          type: 'string';
        };
        lockToken: {
          description: 'A unique identifier provided to the owner of the lock. You must use this token with subsequent calls to prove ownership of the lock.';
          type: 'string';
        };
        lockType: {
          description: 'The type of lock.  Currently `edit` is the only supported type.';
          type: 'string';
        };
        lockedByApp: {
          description: 'The human-readable name of the application that is locking the envelope or template. This value displays to the user in error messages when lock conflicts occur.';
          type: 'string';
        };
        lockedByUser: {
          $ref: '#/components/schemas/userInfo';
        };
        lockedUntilDateTime: {
          description: 'The date and time that the lock expires.';
          type: 'string';
        };
        useScratchPad: {
          description: 'When **true,** a scratchpad is used to edit information.\n ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'lockInformation';
      'x-ds-order': '80';
      'x-ms-summary': 'Envelope locks let you lock an envelope to prevent any changes while you are updating an envelope.\n';
    };
    EnvelopePublish: {
      description: 'The EnvelopePublish resource allows you to submit existing envelopes to any webhook.\n';
      properties: {
        applyConnectSettings: {
          description: '';
          type: 'string';
        };
        envelopeCount: {
          description: '';
          type: 'string';
        };
        envelopeLevelErrorRollups: {
          description: '';
          items: {
            $ref: '#/components/schemas/envelopePublishTransactionErrorRollup';
          };
          type: 'array';
        };
        envelopePublishTransactionId: {
          description: '';
          type: 'string';
        };
        errorCount: {
          description: '';
          type: 'string';
        };
        fileLevelErrors: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        noActionRequiredEnvelopeCount: {
          description: '';
          type: 'string';
        };
        processedEnvelopeCount: {
          description: '';
          type: 'string';
        };
        processingStatus: {
          description: '';
          type: 'string';
        };
        resultsUri: {
          description: '';
          type: 'string';
        };
        submissionDate: {
          description: '';
          type: 'string';
        };
        submittedByUserInfo: {
          $ref: '#/components/schemas/userInfo';
        };
        submittedForPublishingEnvelopeCount: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelopePublishTransaction';
      'x-ds-order': '100';
      'x-ms-summary': 'The EnvelopePublish resource allows you to submit existing envelopes to any webhook.\n';
    };
    EnvelopeRecipientTabs: {
      description: 'All of the tabs associated with a recipient. Each property is a list of a type of tab.\n';
      properties: {
        approveTabs: {
          description: "A list of\n[Approve tabs][approve].\n\nAn Approve tab enables\nthe recipient to approve documents without\nplacing a signature or initials on the document. If the\nrecipient clicks the tab during the signing process, the\nrecipient is considered to have signed the document. No\ninformation is shown on the document of the approval, but it\nis recorded as a signature in the envelope history.\nThe value of an approve tab can't be set.\n\n[approve]:\t\t      /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/approve';
          };
          type: 'array';
        };
        checkboxTabs: {
          description: 'A list of\n[Checkbox tabs][checkbox].\n\n\nA Checkbox tab enables the recipient to select a yes/no (on/off) option. This value can be set.\n\n\n[checkbox]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/checkbox';
          };
          type: 'array';
        };
        commentThreadTabs: {
          description: "An array of tabs that represents a collection of comments in a comment thread. For example, if a recipient has questions about the content of a document, they can add a comment to the document and control who else can see the comment. This value can't be set.";
          items: {
            $ref: '#/components/schemas/commentThread';
          };
          type: 'array';
        };
        commissionCountyTabs: {
          description: "A list of\n[Commission County tabs][cc].\n\n\nA Commission County tab displays the county of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionCounty';
          };
          type: 'array';
        };
        commissionExpirationTabs: {
          description: "A list of\n[Commission Expiration tabs][tabref].\n\n\nA Commission Expiration tab displays the expiration date of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionExpiration';
          };
          type: 'array';
        };
        commissionNumberTabs: {
          description: "A list of\n[Commission Number tabs][tabref].\n\n\nA Commission Number tab displays a notary's commission number. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionNumber';
          };
          type: 'array';
        };
        commissionStateTabs: {
          description: "A list of\n[Commission State tabs][cc].\n\n\nA Commission County tab displays the state in which a notary's commission was granted. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionState';
          };
          type: 'array';
        };
        companyTabs: {
          description: "A list of\n[Company tabs][company].\n\nA Company tab displays a field for the name of the recipient's company. This value can't be set.\n\n[company]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_company\n";
          items: {
            $ref: '#/components/schemas/company';
          };
          type: 'array';
        };
        dateSignedTabs: {
          description: "A list of\n[Date Signed tabs][dateSigned].\n\n\nA Date Signed tab displays the date that the recipient signed the document. This value can't be set.\n\n[dateSigned]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/dateSigned';
          };
          type: 'array';
        };
        dateTabs: {
          description: "A list of\n[Date tabs][date].\n\nA Date tab enables the recipient to enter a date. This value can't be set. The tooltip for this tab recommends the date format MM/DD/YYYY, but several other date formats are also accepted. The system retains the format that the recipient enters.\n\n**Note:** If you need to enforce a specific date format, DocuSign recommends that you use a Text tab with a validation pattern and validation message.\n\n\n[date]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/date';
          };
          type: 'array';
        };
        declineTabs: {
          description: "A list of\n[Decline tabs][decline].\n\nA Decline tab enables the recipient to decline the envelope. If the recipient clicks the tab during the signing process, the envelope is voided. The value of this tab can't be set.\n\n\n[decline]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/decline';
          };
          type: 'array';
        };
        drawTabs: {
          description: 'A list of Draw Tabs.\n\nA Draw Tab allows the recipient to add a free-form drawing to the document.';
          items: {
            $ref: '#/components/schemas/draw';
          };
          type: 'array';
        };
        emailAddressTabs: {
          description: "A list of\n[Email Address tabs][emailAddress].\n\nAn Email Address tab displays the recipient's email as entered in the recipient information. This value can't be set.\n\n\n[emailAddress]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/emailAddress';
          };
          type: 'array';
        };
        emailTabs: {
          description: 'A list of\n[Email tabs][email].\n\nAn Email tab enables the recipient to enter an email address.\nThis is a one-line field that checks that a valid email\naddress is entered. It uses the same parameters as a Text\ntab, with the validation message and pattern set for email\ninformation. This value can be set.\n\nWhen getting information that includes\nthis tab type, the original value of the tab when the\nassociated envelope was sent is included in the response.\n\n[email]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/email';
          };
          type: 'array';
        };
        envelopeIdTabs: {
          description: "A list of\n[Envelope ID tabs][envelopeId].\n\nAn Envelope ID tab  displays the envelope ID. Recipients cannot enter or change the information in this tab. This value can't be set.\n\n\n[envelopeId]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#response201_envelopeid\n";
          items: {
            $ref: '#/components/schemas/envelopeId';
          };
          type: 'array';
        };
        firstNameTabs: {
          description: "A list of\n[First Name tabs][firstName].\n\nA First Name tab displays the recipient's first name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[firstName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_firstname\n";
          items: {
            $ref: '#/components/schemas/firstName';
          };
          type: 'array';
        };
        formulaTabs: {
          description: 'A list of [Formula tabs][formulaTab].\n\nThe value of a Formula tab is calculated from the values of other number or date tabs in the document. When the recipient completes the underlying fields, the Formula tab calculates and displays the result. This value can be set.\n\nThe `formula` property of the tab contains the references to the underlying tabs. To learn more about formulas, see [Calculated Fields][calculatedfields].\n\nIf a Formula tab contains a `paymentDetails` property, the tab is considered a payment item. To learn more about payments, see [Requesting Payments Along with Signatures][paymentguide].\n\n[calculatedfields]: https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields\n[paymentguide]:     https://support.docusign.com/en/guides/requesting-payments-along-with-signatures\n[formulaTab]:\t    \t/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/formulaTab';
          };
          type: 'array';
        };
        fullNameTabs: {
          description: "A list of\n[Full Name tabs][fullName].\n\nA Full Name tab displays the recipient's full name. This value can't be set.\n\n\n[fullName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/fullName';
          };
          type: 'array';
        };
        initialHereTabs: {
          description: "A list of\n[Initial Here tabs][initialHere].\n\nThis type of tab enables the recipient to initial the document. May be optional. This value can't be set.\n\n[initialHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/initialHere';
          };
          type: 'array';
        };
        lastNameTabs: {
          description: "A list of\n[Last Name tabs][lastName].\n\nA Last Name tab displays the recipient's last name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[lastName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/lastName';
          };
          type: 'array';
        };
        listTabs: {
          description: "An array of List tabs.\n\nA List tab enables the recipient to choose from a list of options. You specify the options in the `listItems` property. This value can't be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/list';
          };
          type: 'array';
        };
        notarizeTabs: {
          description: 'A list of  [Notarize tabs][notarize].\n\nA Notarize tab alerts notary recipients that they must take action on the page. This value can be set.\n\n**Note:** Only one notarize tab can appear on a page.\n\n[notarize]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/notarize';
          };
          type: 'array';
        };
        notarySealTabs: {
          description: 'A list of Notary Seal tabs.\n\nA Notary Seal tab enables the recipient to notarize a document. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/notarySeal';
          };
          type: 'array';
        };
        noteTabs: {
          description: 'A list of\n[Note tabs][note].\n\nA Note tab displays additional information to the recipient in the form of a note. This value can be set.\n\n[note]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/note';
          };
          type: 'array';
        };
        numberTabs: {
          description: 'A list of\n[Number tabs][number].\n\nA Number tab enables the recipient to enter numbers and decimal points (.). This value can be set.\n\n\n\n[number]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/number';
          };
          type: 'array';
        };
        numericalTabs: {
          description: '';
          items: {
            $ref: '#/components/schemas/numerical';
          };
          type: 'array';
        };
        phoneNumberTabs: {
          description: 'A list of\n[Phone Number tabs][cc].\n\n\nA Phone Number tab enables a recipient to enter a phone number.\n\n**Note:** This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/phoneNumber';
          };
          type: 'array';
        };
        polyLineOverlayTabs: {
          description: "This type of tab enables the recipient to strike through document text. This value can't be set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ";
          items: {
            $ref: '#/components/schemas/polyLineOverlay';
          };
          type: 'array';
        };
        prefillTabs: {
          $ref: '#/components/schemas/prefillTabs';
        };
        radioGroupTabs: {
          description: 'A list of [Radio Group tabs][radioGroup].\n\nA Radio Group tab places a group of radio buttons on a document. The `radios` property is used to add and place the radio\nbuttons associated with the group. Only one radio button can be selected in a group. This value can be set.\n\n\n[radioGroup]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/radioGroup';
          };
          type: 'array';
        };
        signHereTabs: {
          description: "A list of\n[Sign Here tabs][signHere].\n\nThis type of tab enables the recipient to sign a document. May be optional. This value can't be set.\n\n[signHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signHere';
          };
          type: 'array';
        };
        signerAttachmentTabs: {
          description: "A list of\n[Signer Attachment tabs][signerAttachment].\n\nThis type of tab enables the recipient to attach supporting documents to an envelope. This value can't be set.\n\n\n[signerAttachment]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signerAttachment';
          };
          type: 'array';
        };
        smartSectionTabs: {
          description: 'A list of [Smart Section](https://www.docusign.com/blog/dsdev-deep-dive-responsive-smart-sections) tabs.\n\nSmart Section tabs enhance responsive signing on mobile devices by enabling collapsible sections, page breaks, custom formatting options, and other advanced functionality.\n\n**Note:** Smart Sections are a premium feature. Responsive signing must also be enabled for your account.';
          items: {
            $ref: '#/components/schemas/smartSection';
          };
          type: 'array';
        };
        ssnTabs: {
          description: 'A list of\n[SSN tabs][ssn].\n\nAn SSN tab contains a one-line field that enables the recipient to enter a Social Security Number (SSN) with or without\ndashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information. This value can be set.\n\n\n[ssn]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/ssn';
          };
          type: 'array';
        };
        tabGroups: {
          description: "An array of `tabGroup` items.\n\nTo associate a tab with a tab group, add the tab group's `groupLabel` to the tab's `tabGroupLabels` array.\n";
          items: {
            $ref: '#/components/schemas/tabGroup';
          };
          type: 'array';
        };
        textTabs: {
          description: 'A list of\nText tabs.\n\nA text tab enables the recipient to enter free text. This value can be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/text';
          };
          type: 'array';
        };
        titleTabs: {
          description: "A list of\n[Title tabs][title].\n\nA Title tab displays the recipient's title.  This value can't be set.\n\n\n[title]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/title';
          };
          type: 'array';
        };
        viewTabs: {
          description: 'A list of\n[View tabs][view].\n\nA View tab is used with an Approve tab to handle supplemental documents.  This value can be set.\n\n[view]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/view';
          };
          type: 'array';
        };
        zipTabs: {
          description: 'A list of\n[Zip tabs][zip].\n\nA Zip tab enables the recipient to enter a ZIP code. The ZIP code can be five digits or nine digits ( in ZIP+4 format), and can be entered with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  This value can be set.\n\n\n[zip]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/zip';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'tabs';
      'x-ds-order': '50';
      'x-ms-summary': 'All of the tabs associated with a recipient. Each property is a list of a type of tab.\n';
    };
    EnvelopeRecipients: {
      description: 'Envelope recipients';
      properties: {
        agents: {
          description: 'A list of agent recipients assigned to the documents.';
          items: {
            $ref: '#/components/schemas/agent';
          };
          type: 'array';
        };
        carbonCopies: {
          description: 'A list of carbon copy recipients assigned to the documents.';
          items: {
            $ref: '#/components/schemas/carbonCopy';
          };
          type: 'array';
        };
        certifiedDeliveries: {
          description: 'A complex type containing information on a recipient the must receive the completed documents for the envelope to be completed, but the recipient does not need to sign, initial, date, or add information to any of the documents.';
          items: {
            $ref: '#/components/schemas/certifiedDelivery';
          };
          type: 'array';
        };
        currentRoutingOrder: {
          description: "The routing order of the current recipient. If this value equals a particular signer's routing order, it indicates that the envelope has been sent to that recipient, but he or she has not completed the required actions.";
          type: 'string';
        };
        editors: {
          description: 'A list of users who can edit the envelope.';
          items: {
            $ref: '#/components/schemas/editor';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        inPersonSigners: {
          description: 'Specifies a signer that is in the same physical location as a DocuSign user who will act as a Signing Host for the transaction. The recipient added is the Signing Host and new separate Signer Name field appears after Sign in person is selected.';
          items: {
            $ref: '#/components/schemas/inPersonSigner';
          };
          type: 'array';
        };
        intermediaries: {
          description: 'Identifies a recipient that can, but is not required to, add name and email information for recipients at the same or subsequent level in the routing order (until subsequent Agents, Editors or Intermediaries recipient types are added).';
          items: {
            $ref: '#/components/schemas/intermediary';
          };
          type: 'array';
        };
        notaries: {
          description: 'A list of notary recipients on the envelope.';
          items: {
            $ref: '#/components/schemas/notaryRecipient';
          };
          type: 'array';
        };
        participants: {
          description: '';
          items: {
            $ref: '#/components/schemas/participant';
          };
          type: 'array';
        };
        recipientCount: {
          description: 'The number of recipients in the envelope.';
          type: 'string';
        };
        seals: {
          description: 'A list of electronic seals to apply to documents.';
          items: {
            $ref: '#/components/schemas/sealSign';
          };
          type: 'array';
        };
        signers: {
          description: 'A list of signers on the envelope.';
          items: {
            $ref: '#/components/schemas/signer';
          };
          type: 'array';
        };
        witnesses: {
          description: 'A list of signers who act as witnesses on the envelope.';
          items: {
            $ref: '#/components/schemas/witness';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'recipients';
      'x-ds-order': '20';
      'x-ms-summary': 'Envelope recipients';
    };
    EnvelopeTemplates: {
      description: 'Envelope templates';
      properties: {
        templates: {
          description: 'An array of `templateSummary` objects that contain information about templates.';
          items: {
            $ref: '#/components/schemas/templateSummary';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'templateInformation';
      'x-ds-order': '85';
      'x-ms-summary': 'Envelope templates';
    };
    EnvelopeTransferRules: {
      description: 'This resource provides methods that enable account administrators to create and manage envelope transfer rules.';
      properties: {
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        envelopeTransferRules: {
          description: 'Contains information about a specific envelope transfer rule.';
          items: {
            $ref: '#/components/schemas/envelopeTransferRule';
          };
          type: 'array';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelopeTransferRuleInformation';
      'x-ds-order': '120';
      'x-ms-summary': 'This resource provides methods that enable account administrators to create and manage envelope transfer rules.';
    };
    EnvelopeViews: {
      description: 'Provides a URL that you can embed in your application\nto provide access to the DocuSign UI.\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [Send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [Introducing customizable embedded sending](https://www.docusign.com/blog/developers/introducing-customizable-embedded-sending)\n\n';
      properties: {
        url: {
          description: 'The view URL to be navigated to.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'viewUrl';
      'x-ds-order': '1';
      'x-ms-summary': 'Provides a URL that you can embed in your application\nto provide access to the DocuSign UI.\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [Send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [Introducing customizable embedded sending](https://www.docusign.com/blog/developers/introducing-customizable-embedded-sending)\n\n';
    };
    EnvelopeWorkflowDefinition: {
      description: 'Describes the workflow for an envelope or template.';
      properties: {
        currentWorkflowStepId: {
          description: '';
          type: 'string';
        };
        resumeDate: {
          description: '';
          type: 'string';
        };
        scheduledSending: {
          $ref: '#/components/schemas/scheduledSending';
        };
        workflowStatus: {
          description: '';
          type: 'string';
        };
        workflowSteps: {
          description: '';
          items: {
            $ref: '#/components/schemas/workflowStep';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'workflow';
      'x-ds-order': '300';
      'x-ms-summary': 'Describes the workflow for an envelope or template.';
    };
    Envelopes: {
      description: 'Envelope creation, management';
      properties: {
        accessControlListBase64: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        allowComments: {
          description: 'When **true,** users can add comments to the documents in the envelope. For example, if a signer has a question about the text in the document, they can add a comment to the document.';
          type: 'string';
        };
        allowMarkup: {
          description: 'When **true,** the Document Markup feature is enabled.\n\n**Note:**  To use this feature, Document Markup must be enabled at both the account and envelope levels. Only Admin users can change this setting at the account level.\n';
          type: 'string';
        };
        allowReassign: {
          description: 'When **true,** the recipient can redirect an envelope to a more appropriate recipient.';
          type: 'string';
        };
        allowViewHistory: {
          description: 'When **true,** recipients can view the history of the envelope.';
          type: 'string';
        };
        anySigner: {
          description: 'Deprecated. This feature has been replaced by signing groups.';
          type: 'string';
        };
        asynchronous: {
          description: 'When **true,** the envelope is queued for\nprocessing and the value of the `status` property\nis set to `Processing`. Additionally, GET status\ncalls return `Processing` until completed.\n\n\n**Note:** A `transactionId` is required for this\ncall to work correctly. When the envelope is\ncreated, the status is `Processing` and an\n`envelopeId` is not returned in the response. To\nget the `envelopeId`, use a GET envelope query by\nusing the\n[transactionId](/docs/esign-rest-api/reference/envelopes/envelopes/create/) or by checking the\nConnect notification.';
          type: 'string';
        };
        attachmentsUri: {
          description: 'Contains a URL for retrieving the attachments that are associated with the envelope.';
          type: 'string';
        };
        authoritativeCopy: {
          description: 'When **true,** marks all of the documents in the envelope as authoritative copies.\n\n**Note:** You can override this value for a specific document. For example, you can set the `authoritativeCopy` property to **true** at the envelope level, but turn it off for a single document by setting the `authoritativeCopy` property for the document to **false.**';
          type: 'string';
        };
        authoritativeCopyDefault: {
          description: "The default `authoritativeCopy` setting for documents in this envelope that do not have `authoritativeCopy` set.\nIf this property is not set, each document defaults to the envelope's `authoritativeCopy`.";
          type: 'string';
        };
        autoNavigation: {
          description: 'When **true,** autonavigation is set for the recipient.\n';
          type: 'string';
        };
        brandId: {
          description: 'The ID of the brand.';
          type: 'string';
        };
        brandLock: {
          description: 'When **true,** the `brandId` for the envelope is locked and senders cannot change the brand used for the envelope.';
          type: 'string';
        };
        burnDefaultTabData: {
          description: '';
          type: 'string';
        };
        certificateUri: {
          description: 'The URI for retrieving certificate information.';
          type: 'string';
        };
        completedDateTime: {
          description: 'Specifies the date and time this item was completed.';
          type: 'string';
        };
        copyRecipientData: {
          description: '';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        customFields: {
          $ref: '#/components/schemas/AccountCustomFields';
        };
        customFieldsUri: {
          description: 'The URI for retrieving custom fields.';
          type: 'string';
        };
        declinedDateTime: {
          description: 'The date and time the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        deletedDateTime: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        deliveredDateTime: {
          description: 'The date and time that the envelope was delivered to the recipient. This property is read-only.';
          type: 'string';
        };
        disableResponsiveDocument: {
          description: 'When **true,** responsive documents are disabled for the envelope.';
          type: 'string';
        };
        documentBase64: {
          description: "The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.";
          type: 'string';
        };
        documentsCombinedUri: {
          description: 'The URI for retrieving all of the documents associated with the envelope as a single PDF file.';
          type: 'string';
        };
        documentsUri: {
          description: 'The URI for retrieving all of the documents associated with the envelope as separate files.';
          type: 'string';
        };
        emailBlurb: {
          description: 'This is the same as the email body. If specified it is included in the email body for all envelope recipients.';
          type: 'string';
        };
        emailSettings: {
          $ref: '#/components/schemas/emailSettings';
        };
        emailSubject: {
          description: 'The subject line of the email message that is sent to all recipients.\n\nFor information about adding merge field information to the email subject, see [Template Email Subject Merge Fields](/docs/esign-rest-api/reference/templates/templates/create/#template-email-subject-merge-fields).\n\n**Note:** The subject line is limited to 100 characters, including any merged fields.It is not truncated. It is an error if the text is longer than 100 characters.\n';
          type: 'string';
        };
        enableWetSign: {
          description: 'When **true,** the signer is allowed to print the document and sign it on paper.';
          type: 'string';
        };
        enforceSignerVisibility: {
          description: 'When **true,** signers can only view the documents on which they have tabs. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all of the documents in an envelope, unless they are specifically excluded by using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded by using this setting when an envelope is sent.\n\n**Note:** To use this functionality, [Document Visibility][docviz] must be enabled for the account by making the account setting `allowDocumentVisibility` **true.**\n\n[docviz]: /docs/esign-rest-api/reference/envelopes/envelopedocumentvisibility/';
          type: 'string';
        };
        envelopeAttachments: {
          description: 'An array of attachment objects that provide information about the attachments that are associated with the envelope.';
          items: {
            $ref: '#/components/schemas/attachment';
          };
          type: 'array';
        };
        envelopeCustomMetadata: {
          $ref: '#/components/schemas/envelopeCustomMetadata';
        };
        envelopeDocuments: {
          description: 'An array containing information about the documents that are included in the envelope.';
          items: {
            $ref: '#/components/schemas/envelopeDocument';
          };
          type: 'array';
        };
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        envelopeIdStamping: {
          description: 'When **true,** [Envelope ID Stamping](https://support.docusign.com/en/guides/ndse-user-guide-set-advanced-document-options) is enabled.\nAfter a document or attachment is stamped with an Envelope ID,\nthe ID is seen by all recipients\nand becomes a permanent part of the document\nand cannot be removed.';
          type: 'string';
        };
        envelopeLocation: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        envelopeMetadata: {
          $ref: '#/components/schemas/envelopeMetadata';
        };
        envelopeUri: {
          description: 'The URI for retrieving the envelope or envelopes.';
          type: 'string';
        };
        expireAfter: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        expireDateTime: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        expireEnabled: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        externalEnvelopeId: {
          description: 'May contain an external identifier for the envelope.';
          type: 'string';
        };
        folders: {
          description: 'A list of folder objects.';
          items: {
            $ref: '#/components/schemas/folder';
          };
          type: 'array';
        };
        hasComments: {
          description: 'When **true,** indicates that users have added comments to the envelope.';
          type: 'string';
        };
        hasFormDataChanged: {
          description: 'Specifies if the `EnvelopeFormData` associated with any forms in the envelope has changed.';
          type: 'string';
        };
        hasWavFile: {
          description: 'When **true,** indicates that a .wav file used for voice authentication is included in the envelope. ';
          type: 'string';
        };
        holder: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        initialSentDateTime: {
          description: 'The date and time the envelope was initially sent.';
          type: 'string';
        };
        is21CFRPart11: {
          description: 'When **true,** indicates compliance with United States Food and Drug Administration (FDA) regulations on electronic records and electronic signatures (ERES).';
          type: 'string';
        };
        isDynamicEnvelope: {
          description: 'When **true,** indicates that the envelope is a dynamic envelope.';
          type: 'string';
        };
        isSignatureProviderEnvelope: {
          description: 'When **true,** indicates that the envelope is a signature-provided envelope.';
          type: 'string';
        };
        lastModifiedDateTime: {
          description: 'The date and time that the item was last modified.';
          type: 'string';
        };
        location: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lockInformation: {
          $ref: '#/components/schemas/EnvelopeLocks';
        };
        messageLock: {
          description: 'When **true,** prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope. \n\nAdditionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes. \n\nHowever, if the `messageLock` node is set to **true** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.';
          type: 'string';
        };
        notification: {
          $ref: '#/components/schemas/notification';
        };
        notificationUri: {
          description: 'The URI for retrieving notifications.';
          type: 'string';
        };
        powerForm: {
          $ref: '#/components/schemas/powerForm';
        };
        purgeCompletedDate: {
          description: 'The date that a purge was completed.';
          type: 'string';
        };
        purgeRequestDate: {
          description: 'The date that a purge was requested.';
          type: 'string';
        };
        purgeState: {
          description: 'Shows the current purge state for the envelope. Valid values:\n\n- `unpurged`: There has been no successful request to purge documents.\n- `documents_queued`: The envelope documents have been added to the purge queue, but have not been purged.\n- `documents_dequeued`: The envelope documents have been taken out of the purge queue.\n- `documents_purged`: The envelope documents have been successfully purged.\n- `documents_and_metadata_queued`: The envelope documents and metadata have been added to the purge queue, but have not yet been purged.\n- `documents_and_metadata_purged`: The envelope documents and metadata have been successfully purged.\n- `documents_and_metadata_and_redact_queued`: The envelope documents and metadata have been added to the purge queue, but have not yet been purged, nor has personal information been redacted.\n- `documents_and_metadata_and_redact_purged`: The envelope documents and metadata have been successfully purged, and personal information has been redacted.\n\n**Related topics**\n\n- [Purging documents (eSingature Concepts)](/docs/esign-rest-api/esign101/concepts/documents/purging/)\n- [Purging documents in an envelope (blog post)](https://www.docusign.com/blog/developers/purging-documents-envelope)\n\n';
          type: 'string';
        };
        recipients: {
          $ref: '#/components/schemas/EnvelopeRecipients';
        };
        recipientsLock: {
          description: 'When **true,** prevents senders from changing, correcting, or deleting the recipient information for the envelope.';
          type: 'string';
        };
        recipientsUri: {
          description: 'Contains a URI for an endpoint that you can use to retrieve the recipients.';
          type: 'string';
        };
        sender: {
          $ref: '#/components/schemas/userInfo';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        signerCanSignOnMobile: {
          description: 'When **true,** recipients can sign on a mobile device.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signingLocation: {
          description: 'Specifies the physical location where the signing takes place. It can have two enumeration values; `inPerson` and `online`. The default value is `online`.';
          type: 'string';
        };
        status: {
          description: '* `completed`: The recipients have finished working with the envelope: the documents are signed and all required tabs are filled in.\n* `created`: The envelope is created as a draft. It can be modified and sent later.\n* `declined`: The envelope has been declined by the recipients.\n* `delivered`: The envelope has been delivered to the recipients.\n* `sent`: The envelope will be sent to the recipients after the envelope is created.\n* `signed`: The envelope has been signed by the recipients.\n* `voided`: The envelope is no longer valid and recipients cannot access or sign the envelope.\n';
          type: 'string';
        };
        statusChangedDateTime: {
          description: 'The data and time that the status changed.';
          type: 'string';
        };
        statusDateTime: {
          description: 'The DateTime that the envelope changed status (i.e. was created or sent.)';
          type: 'string';
        };
        templatesUri: {
          description: 'The URI for retrieving the templates.';
          type: 'string';
        };
        transactionId: {
          description: " Used to identify an envelope. The ID is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.";
          type: 'string';
        };
        useDisclosure: {
          description: "When **true,** the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When **false,** the Electronic Record and Signature Disclosure is not shown to any envelope recipients. \n\nIf the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.";
          type: 'string';
        };
        voidedDateTime: {
          description: 'The date and time the envelope or template was voided.';
          type: 'string';
        };
        voidedReason: {
          description: 'The reason the envelope or template was voided.\n\n**Note:** The string is truncated to the first 200 characters.\n';
          type: 'string';
        };
        workflow: {
          $ref: '#/components/schemas/workflow';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'envelope';
      'x-ds-order': '10';
      'x-ms-summary': 'Envelope creation, management';
    };
    FavoriteTemplates: {
      description: '';
      properties: {
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        favoriteTemplates: {
          description: '';
          items: {
            $ref: '#/components/schemas/favoriteTemplatesContentItem';
          };
          type: 'array';
        };
        templatesUpdatedCount: {
          description: 'The number of templates successfully updated by the call. This property is read-only.';
          format: 'int32';
          type: 'integer';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'favoriteTemplatesInfo';
      'x-ds-order': '270';
      'x-ms-summary': '';
    };
    Folders: {
      description: 'Folders allow you to organize envelopes and templates.';
      properties: {
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        envelopes: {
          description: 'A list of envelopes in this folder.';
          items: {
            $ref: '#/components/schemas/envelopeSummary';
          };
          type: 'array';
        };
        folders: {
          description: 'A list of folder objects.';
          items: {
            $ref: '#/components/schemas/folder';
          };
          type: 'array';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Folders';
      'x-ds-definition-name': 'foldersResponse';
      'x-ds-order': '10';
      'x-ms-summary': 'Folders allow you to organize envelopes and templates.';
    };
    GroupBrands: {
      description: 'If your account includes multiple signing brands, you can use the groups functionality to assign different brands to different groups. This resource enables you to manage group brands.';
      properties: {
        brandOptions: {
          description: 'A list of brands.';
          items: {
            $ref: '#/components/schemas/brand';
          };
          type: 'array';
        };
        recipientBrandIdDefault: {
          description: 'The brand that envelope recipients see when a brand is not explicitly set.';
          type: 'string';
        };
        senderBrandIdDefault: {
          description: 'The brand that envelope senders see when a brand is not explicitly set.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'UserGroups';
      'x-ds-definition-name': 'brandsResponse';
      'x-ds-order': '30';
      'x-ms-summary': 'If your account includes multiple signing brands, you can use the groups functionality to assign different brands to different groups. This resource enables you to manage group brands.';
    };
    GroupUsers: {
      description: "Groups' users";
      properties: {
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
        users: {
          description: 'An array of `userInfo` objects containing information about the users in the group.';
          items: {
            $ref: '#/components/schemas/userInfo';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'UserGroups';
      'x-ds-definition-name': 'usersResponse';
      'x-ds-order': '20';
      'x-ms-summary': "Groups' users";
    };
    Groups: {
      description: 'Group information';
      properties: {
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        groups: {
          description: 'A collection group objects containing information about the groups.';
          items: {
            $ref: '#/components/schemas/group';
          };
          type: 'array';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'UserGroups';
      'x-ds-definition-name': 'groupInformation';
      'x-ds-order': '10';
      'x-ms-summary': 'Group information';
    };
    IdentityVerifications: {
      description: "Identity Verification enables you to verify a signer's identity before they can access a document. The `IdentityVerifications` resource provides a method that enables you to list the workflows that are available to an account.";
      properties: {
        identityVerification: {
          description: "Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).";
          items: {
            $ref: '#/components/schemas/accountIdentityVerificationWorkflow';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'accountIdentityVerificationResponse';
      'x-ds-order': '30';
      'x-ms-summary': "Identity Verification enables you to verify a signer's identity before they can access a document. The `IdentityVerifications` resource provides a method that enables you to list the workflows that are available to an account.";
    };
    Invoices: {
      description: 'Invoices';
      properties: {
        amount: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        balance: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        dueDate: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceId: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceItems: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingInvoiceItem';
          };
          type: 'array';
        };
        invoiceNumber: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceUri: {
          description: 'Contains a URI for an endpoint that you can use to retrieve invoice information.';
          type: 'string';
        };
        nonTaxableAmount: {
          description: '';
          type: 'string';
        };
        pdfAvailable: {
          description: '';
          type: 'string';
        };
        taxableAmount: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Billing';
      'x-ds-definition-name': 'billingInvoice';
      'x-ds-order': '20';
      'x-ms-summary': 'Invoices';
    };
    Notary: {
      description: 'Use DocuSign eNotary to notarize documents digitally.\nCheck the [DocuSign eNotary support documentation](https://support.docusign.com/en/guides/ndse-user-guide-enotary-resources)\nto see which jurisdictions are supported.\n';
      properties: {
        createdDate: {
          description: 'The creation date of the account in UTC timedate format.';
          type: 'string';
        };
        enabled: {
          description: '';
          type: 'string';
        };
        searchable: {
          description: '';
          type: 'string';
        };
        userInfo: {
          $ref: '#/components/schemas/userInformation';
        };
      };
      type: 'object';
      'x-ds-category': 'Notary';
      'x-ds-definition-name': 'notary';
      'x-ds-order': '280';
      'x-ms-summary': 'Use DocuSign eNotary to notarize documents digitally.\nCheck the [DocuSign eNotary support documentation](https://support.docusign.com/en/guides/ndse-user-guide-enotary-resources)\nto see which jurisdictions are supported.\n';
    };
    NotaryJournals: {
      description: '';
      properties: {
        createdDate: {
          description: 'The creation date of the account in UTC timedate format.';
          type: 'string';
        };
        documentName: {
          description: '';
          type: 'string';
        };
        jurisdiction: {
          $ref: '#/components/schemas/jurisdiction';
        };
        notaryJournalId: {
          description: '';
          type: 'string';
        };
        notaryJournalMetaData: {
          $ref: '#/components/schemas/notaryJournalMetaData';
        };
        signerName: {
          description: "The in-person signer's full legal name.\n\nRequired when `inPersonSigningType` is `inPersonSigner`.\nFor eNotary flow, use `name` instead.\n\nMaximum Length: 100 characters.\n";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'notaryJournal';
      'x-ds-order': '220';
      'x-ms-summary': '';
    };
    NotaryJurisdiction: {
      description: 'Creating, updating, and deleting notary jurisdiction objects.';
      properties: {
        commissionExpiration: {
          description: '';
          type: 'string';
        };
        commissionId: {
          description: '';
          type: 'string';
        };
        county: {
          description: '';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        jurisdiction: {
          $ref: '#/components/schemas/jurisdiction';
        };
        registeredName: {
          description: '';
          type: 'string';
        };
        sealType: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Notary';
      'x-ds-definition-name': 'notaryJurisdiction';
      'x-ds-order': '290';
      'x-ms-summary': 'Creating, updating, and deleting notary jurisdiction objects.';
    };
    NotificationDefaults: {
      description: 'The `NotificationDefaults` resource provides methods that enable you to manage the default notifications for envelopes.';
      properties: {
        apiEmailNotifications: {
          $ref: '#/components/schemas/notificationDefaultSettings';
        };
        emailNotifications: {
          $ref: '#/components/schemas/notificationDefaultSettings';
        };
      };
      type: 'object';
      'x-ds-category': 'Accounts';
      'x-ds-definition-name': 'notificationDefaults';
      'x-ds-order': '120';
      'x-ms-summary': 'The `NotificationDefaults` resource provides methods that enable you to manage the default notifications for envelopes.';
    };
    PaymentGatewayAccounts: {
      description: 'Information about a connected payment gateway account.';
      properties: {
        allowCustomMetadata: {
          description: 'When **true,** the sender can pass custom metadata about the payment to the payment gateway. You pass in this metadata on an EnvelopeRecipientTab, in the `customMetadata` property under `paymentDetails`. \n\nFor example, this property is set to **true** for the Authorize.net gateway by default. As a result, the extra metadata that you send displays for the Authorize.net transaction in the merchant gateway portal under **Description.**\n\n**Note:** This property is read-only and cannot be changed.';
          type: 'boolean';
        };
        config: {
          $ref: '#/components/schemas/paymentGatewayAccountSetting';
        };
        displayName: {
          description: 'A user-defined name for a connected gateway account.\n\nThis name is used in the Admin panel in the list of connected accounts and in Tagger in the payment gateway selector.\n\nThe human-readable version of `paymentGatewayAccountId`.';
          type: 'string';
        };
        isEnabled: {
          description: 'When **true,** the payment gateway account is enabled.';
          type: 'string';
        };
        isLegacy: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lastModified: {
          description: 'The UTC DateTime that the payment gateway account was last updated.';
          type: 'string';
        };
        payPalLegacySettings: {
          $ref: '#/components/schemas/payPalLegacySettings';
        };
        paymentGateway: {
          description: 'Payment gateway used by the connected gateway account.\nThis is the name used by the API.\nFor a human-readable version use `paymentGatewayDisplayName`.\n\nPossible values are:\n\n* `Stripe`\n* `Braintree`\n* `AuthorizeDotNet`\n* `CyberSource`\n* `Zuora`\n* `Elavon`';
          type: 'string';
        };
        paymentGatewayAccountId: {
          description: 'A GUID that identifies the payment gateway account. For a human-readable version use `displayName`.';
          type: 'string';
        };
        paymentGatewayDisplayName: {
          description: 'The display name of the payment gateway that the connected gateway account uses.\nThis is the human-readable version of `paymentGateway`.\n\nPossible values are:\n\n* Stripe\n* Braintree\n* Authorize.Net\n* CyberSource\n* Zuora\n* Elavon';
          type: 'string';
        };
        supportedCurrencies: {
          description: 'A list of ISO 4217 currency codes for the currencies that the payment gateway account supports.\n\nExamples: \n\n- `USD`\n- `CAD`\n- `EUR`\n- `HKD`';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        supportedPaymentMethods: {
          description: 'An array of paymentMethodWithOptions objects that specify the payment methods that are available for the gateway.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        supportedPaymentMethodsWithOptions: {
          description: 'An array of `paymentMethodWithOptions` objects that specify the payment methods that are available for the gateway, as well as the payment options that are compatible with each payment method.';
          items: {
            $ref: '#/components/schemas/paymentMethodWithOptions';
          };
          type: 'array';
        };
        zeroDecimalCurrencies: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Payments';
      'x-ds-definition-name': 'paymentGatewayAccount';
      'x-ds-order': '210';
      'x-ms-summary': 'Information about a connected payment gateway account.';
    };
    Payments: {
      description: 'Payments';
      properties: {
        amount: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        description: {
          description: 'A sender-defined description of the line item.\n';
          type: 'string';
        };
        paymentDate: {
          description: '';
          type: 'string';
        };
        paymentId: {
          description: 'The ID of the payment.';
          type: 'string';
        };
        paymentNumber: {
          description: 'When **true,** a PDF version of the invoice is available. \n\nTo get the PDF, make the call again and change "Accept:" in the header to "Accept: application/pdf".';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Billing';
      'x-ds-definition-name': 'billingPaymentItem';
      'x-ds-order': '30';
      'x-ms-summary': 'Payments';
    };
    PowerFormData: {
      description: 'Data that recipients have entered in PowerForm fields.';
      properties: {
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        recipients: {
          description: 'An array of powerform recipients.';
          items: {
            $ref: '#/components/schemas/powerFormFormDataRecipient';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'PowerForms';
      'x-ds-definition-name': 'powerFormFormDataEnvelope';
      'x-ds-order': '90';
      'x-ms-summary': 'Data that recipients have entered in PowerForm fields.';
    };
    PowerForms: {
      description: 'The PowerForms resource enables you to create fillable forms that you can email or make available for self service on the web.';
      properties: {
        createdBy: {
          description: 'The ID of the user who created the PowerForm. This property is returned in a response only when you set the `include_created_by` query parameter to **true.**';
          type: 'string';
        };
        createdDateTime: {
          description: 'The date and time that the PowerForm was created.';
          type: 'string';
        };
        emailBody: {
          description: 'For a PowerForm that is sent by email, this is the body of the email message sent to the recipients.\n\nMaximum length: 10000 characters.';
          type: 'string';
        };
        emailSubject: {
          description: "Sets the envelope name for the envelopes that the PowerForm generates. One option is to make this property the same as the subject from the template.\n\nYou can customize the subject line to include a recipient's name or email address by using merge fields. For information about adding merge fields to the email subject, see [Template Email Subject Merge Fields](/docs/esign-rest-api/reference/templates/templates/create/).\n";
          type: 'string';
        };
        envelopes: {
          description: 'An array of envelope objects that contain information about the envelopes that are associated with the PowerForm.';
          items: {
            $ref: '#/components/schemas/envelope';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        instructions: {
          description: 'The instructions that display on the landing page for the first recipient. These instructions are important if the recipient accesses the PowerForm by a method other than email. When you include instructions, they display as an introduction after the recipient accesses the PowerForm.';
          type: 'string';
        };
        isActive: {
          description: 'When **true,** indicates that the PowerForm is active and can be sent to recipients. This is the default value.\n\n\nWhen **false,** the PowerForm cannot be emailed or accessed by a recipient, even if they arrive at the PowerForm URL. \n\nIf a recipient attempts to sign an inactive PowerForm, an error message informs the recipient that the document is not active and suggests that they contact the sender.';
          type: 'string';
        };
        lastUsed: {
          description: 'The date and time that the PowerForm was last used.';
          type: 'string';
        };
        limitUseInterval: {
          description: 'The length of time before the same recipient can sign the same PowerForm again. This property is used in combination with the `limitUseIntervalUnits` property.';
          type: 'string';
        };
        limitUseIntervalEnabled: {
          description: 'When **true,** the `limitUseInterval` is enabled.';
          type: 'string';
        };
        limitUseIntervalUnits: {
          description: 'The units associated with the `limitUseInterval`. Valid values are:\n\n- `minutes`\n- `hours`\n- `days`\n- `weeks`\n- `months`\n\nFor example, to limit a recipient to signing once per year, set the `limitUseInterval` to 365 and the `limitUseIntervalUnits` to `days`.\n';
          type: 'string';
        };
        maxUseEnabled: {
          description: 'When **true,** you can set a maximum number of uses for the PowerForm.';
          type: 'string';
        };
        name: {
          description: 'The name of the PowerForm.';
          type: 'string';
        };
        powerFormId: {
          description: 'The ID of the PowerForm.';
          type: 'string';
        };
        powerFormUrl: {
          description: 'The URL for the PowerForm.';
          type: 'string';
        };
        recipients: {
          description: 'An array of `powerFormRecipient` objects.\n\n**Note:** For self-service documents where you do not know who the recipients are in advance, you can enter generic information for the `role` property and leave other details (such as `name` and `email`) blank.';
          items: {
            $ref: '#/components/schemas/powerFormRecipient';
          };
          type: 'array';
        };
        senderName: {
          description: 'The name of the sender. \n\n**Note:** The default sender for a PowerForm is the PowerForm Administrator who created it.';
          type: 'string';
        };
        senderUserId: {
          description: 'The ID of the sender.';
          type: 'string';
        };
        signingMode: {
          description: "The signing method to use. Valid values are:\n\n- `email`: This mode verifies the recipient's identity by using email authentication before the recipient can sign a document.\n\n- `direct`: This mode does not require any verification. DocuSign recommends that you use this signing method only when another form of authentication is in use.\n\n**Note:** In the account settings, `enablePowerFormDirect` must be **true** to use `direct` as the `signingMode`.\n\nFor more information about signing modes, see the [overview of the Create method](/docs/esign-rest-api/reference/powerforms/powerforms/create/).";
          type: 'string';
        };
        templateId: {
          description: 'The ID of the template used to create the PowerForm.';
          type: 'string';
        };
        templateName: {
          description: 'The name of the template used to create the PowerForm.';
          type: 'string';
        };
        timesUsed: {
          description: 'The number of times the PowerForm has been used. ';
          type: 'string';
        };
        uri: {
          description: 'The URI for the PowerForm.';
          type: 'string';
        };
        usesRemaining: {
          description: 'The number of times that the PowerForm can still be used. If no use limit is set, the value is `Unlimited`. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'PowerForms';
      'x-ds-definition-name': 'powerForm';
      'x-ds-order': '80';
      'x-ms-summary': 'The PowerForms resource enables you to create fillable forms that you can email or make available for self service on the web.';
    };
    RequestLogs: {
      description: 'Request logs';
      properties: {
        apiRequestLogMaxEntries: {
          description: 'Specifies the maximum number of API requests to log.';
          type: 'string';
        };
        apiRequestLogRemainingEntries: {
          description: 'Indicates the remaining number of API requests that can be logged.';
          type: 'string';
        };
        apiRequestLogging: {
          description: ' When **true,** enables API request logging for the user. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Diagnostics';
      'x-ds-definition-name': 'diagnosticsSettingsInformation';
      'x-ds-order': '10';
      'x-ms-summary': 'Request logs';
    };
    ReservedDomains: {
      description: '';
      'x-ds-category': 'Accounts';
      'x-ms-summary': '';
    };
    Resources: {
      description: 'API resource information';
      properties: {
        resources: {
          description: '';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Diagnostics';
      'x-ds-definition-name': 'resourceInformation';
      'x-ds-order': '20';
      'x-ms-summary': 'API resource information';
    };
    ResponsiveHtml: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '100';
      'x-ms-summary': '';
    };
    ResponsiveHtmlPreview: {
      description: 'This resource is used to create a responsive preview of all of the documents in an envelope.';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'documentHtmlDefinitions';
      'x-ds-order': '250';
      'x-ms-summary': 'This resource is used to create a responsive preview of all of the documents in an envelope.';
    };
    Services: {
      description: 'API service information';
      properties: {
        buildBranch: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        buildBranchDeployedDateTime: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        buildSHA: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        buildVersion: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        linkedSites: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        serviceVersions: {
          description: '';
          items: {
            $ref: '#/components/schemas/serviceVersion';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Diagnostics';
      'x-ds-definition-name': 'serviceInformation';
      'x-ds-order': '30';
      'x-ms-summary': 'API service information';
    };
    SigningGroupUsers: {
      description: "Signing groups' users";
      properties: {
        users: {
          description: 'User management information.';
          items: {
            $ref: '#/components/schemas/signingGroupUser';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'SigningGroups';
      'x-ds-definition-name': 'signingGroupUsers';
      'x-ds-order': '20';
      'x-ms-summary': "Signing groups' users";
    };
    SigningGroups: {
      description: 'Signing groups';
      properties: {
        created: {
          description: 'The UTC DateTime when the workspace user authorization was created.';
          type: 'string';
        };
        createdBy: {
          description: 'The name of the user who created the signing group.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        groupEmail: {
          description: 'The email address for the signing group. You can use a group email address to email all of the group members at the same time.';
          type: 'string';
        };
        groupName: {
          description: 'The name of the group. The search_text provided in the call automatically performs a wild card search on group_name.';
          type: 'string';
        };
        groupType: {
          description: 'The group type. Possible values include:\n\n- `adminstrators`\n- `everyone`\n- `customGroup`\n- `sharedSigningGroup`\n\n<!-- More? To do -->';
          type: 'string';
        };
        modified: {
          description: 'The date and time that the signing group was last modified.';
          type: 'string';
        };
        modifiedBy: {
          description: 'The user ID (GUID) of the user who last modified this user record. This property is read-only.';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        users: {
          description: 'User management information.';
          items: {
            $ref: '#/components/schemas/signingGroupUser';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'SigningGroups';
      'x-ds-definition-name': 'signingGroup';
      'x-ds-order': '10';
      'x-ms-summary': 'Signing groups';
    };
    TabsBlob: {
      description: 'Reserved for DocuSign.';
      properties: {
        allowTabOrder: {
          description: 'When **true,** account users can set a tab order for the signing process.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowTabOrderMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        approveDeclineTabsEnabled: {
          description: 'When **true,** approve and decline tabs are enabled.';
          type: 'string';
        };
        approveDeclineTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        calculatedFieldsEnabled: {
          description: 'When **true,** [calculated fields](https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields) are enabled for tabs.';
          type: 'string';
        };
        calculatedFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        checkBoxTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        checkboxTabsEnabled: {
          description: 'When **true,** checkbox tabs are enabled.';
          type: 'string';
        };
        dataFieldRegexEnabled: {
          description: 'When **true,** regular expressions are enabled for tabs that contain data fields.';
          type: 'string';
        };
        dataFieldRegexMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        dataFieldSizeEnabled: {
          description: 'When **true,** setting character limits for input fields is enabled.';
          type: 'string';
        };
        dataFieldSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        drawTabsEnabled: {
          description: '';
          type: 'string';
        };
        drawTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        firstLastEmailTabsEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        firstLastEmailTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        listTabsEnabled: {
          description: 'When **true,** list tabs are enabled.';
          type: 'string';
        };
        listTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        noteTabsEnabled: {
          description: 'When **true,** note tabs are enabled.';
          type: 'string';
        };
        noteTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        numericalTabsEnabled: {
          description: '';
          type: 'string';
        };
        numericalTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        prefillTabsEnabled: {
          description: '';
          type: 'string';
        };
        prefillTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        radioTabsEnabled: {
          description: 'When **true,** radio button tabs are enabled.';
          type: 'string';
        };
        radioTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        savingCustomTabsEnabled: {
          description: 'When **true,** saving custom tabs is enabled.';
          type: 'string';
        };
        savingCustomTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        senderToChangeTabAssignmentsEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        senderToChangeTabAssignmentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sharedCustomTabsEnabled: {
          description: 'When **true,** shared custom tabs are enabled.';
          type: 'string';
        };
        sharedCustomTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabDataLabelEnabled: {
          description: 'When **true,** [data\nlabels](https://support.docusign.com/en/videos/Data-Labels) are enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabDataLabelMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabLocationEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        tabLocationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabLockingEnabled: {
          description: 'When **true,** tab locking is enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabLockingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabScaleEnabled: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        tabScaleMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabTextFormattingEnabled: {
          description: 'When **true,** text formatting (such as font type, font size,\nfont color, bold, italic, and underline) is enabled for tabs that\nsupport formatting.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        tabTextFormattingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        textTabsEnabled: {
          description: 'When **true,** text tabs are enabled.';
          type: 'string';
        };
        textTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-category': 'Envelopes';
      'x-ds-definition-name': 'tabAccountSettings';
      'x-ds-order': '120';
      'x-ms-summary': 'Reserved for DocuSign.';
    };
    TemplateBulkRecipients: {
      description: 'Template bulk recipients';
      'x-ds-category': 'Templates';
      'x-ms-summary': 'Template bulk recipients';
    };
    TemplateCustomFields: {
      description: 'A template custom field enables you to prepopulate custom metadata for all new envelopes that are created by using a specific template. You can then use the custom data for sorting, organizing, searching, and other downstream processes.';
      properties: {
        listCustomFields: {
          description: 'An array of list custom fields.';
          items: {
            $ref: '#/components/schemas/listCustomField';
          };
          type: 'array';
        };
        textCustomFields: {
          description: 'An array of text custom fields.';
          items: {
            $ref: '#/components/schemas/textCustomField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'customFields';
      'x-ds-order': '70';
      'x-ms-summary': 'A template custom field enables you to prepopulate custom metadata for all new envelopes that are created by using a specific template. You can then use the custom data for sorting, organizing, searching, and other downstream processes.';
    };
    TemplateDocumentFields: {
      description: 'Template document fields';
      properties: {
        documentFields: {
          description: 'The array of name/value custom data strings to add to a document. Custom document field information is returned in the status, but otherwise is not used by DocuSign. The array contains the following elements: \n\n* `name` - A string that can be a maximum of 50 characters. \n* `value` - A string that can be a maximum of 200 characters.\n\n**Important:** If you are using XML, the name/value pair is contained in a `nameValue` element. \n';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'documentFieldsInformation';
      'x-ds-order': '60';
      'x-ms-summary': 'Template document fields';
    };
    TemplateDocumentHtmlDefinitions: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '300';
      'x-ms-summary': '';
    };
    TemplateDocumentResponsiveHtmlPreview: {
      description: 'This resource is used to create a responsive preview of a specific template document.';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'documentHtmlDefinitions';
      'x-ds-order': '280';
      'x-ms-summary': 'This resource is used to create a responsive preview of a specific template document.';
    };
    TemplateDocumentTabs: {
      description: '';
      properties: {
        approveTabs: {
          description: "A list of\n[Approve tabs][approve].\n\nAn Approve tab enables\nthe recipient to approve documents without\nplacing a signature or initials on the document. If the\nrecipient clicks the tab during the signing process, the\nrecipient is considered to have signed the document. No\ninformation is shown on the document of the approval, but it\nis recorded as a signature in the envelope history.\nThe value of an approve tab can't be set.\n\n[approve]:\t\t      /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/approve';
          };
          type: 'array';
        };
        checkboxTabs: {
          description: 'A list of\n[Checkbox tabs][checkbox].\n\n\nA Checkbox tab enables the recipient to select a yes/no (on/off) option. This value can be set.\n\n\n[checkbox]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/checkbox';
          };
          type: 'array';
        };
        commentThreadTabs: {
          description: "An array of tabs that represents a collection of comments in a comment thread. For example, if a recipient has questions about the content of a document, they can add a comment to the document and control who else can see the comment. This value can't be set.";
          items: {
            $ref: '#/components/schemas/commentThread';
          };
          type: 'array';
        };
        commissionCountyTabs: {
          description: "A list of\n[Commission County tabs][cc].\n\n\nA Commission County tab displays the county of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionCounty';
          };
          type: 'array';
        };
        commissionExpirationTabs: {
          description: "A list of\n[Commission Expiration tabs][tabref].\n\n\nA Commission Expiration tab displays the expiration date of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionExpiration';
          };
          type: 'array';
        };
        commissionNumberTabs: {
          description: "A list of\n[Commission Number tabs][tabref].\n\n\nA Commission Number tab displays a notary's commission number. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionNumber';
          };
          type: 'array';
        };
        commissionStateTabs: {
          description: "A list of\n[Commission State tabs][cc].\n\n\nA Commission County tab displays the state in which a notary's commission was granted. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionState';
          };
          type: 'array';
        };
        companyTabs: {
          description: "A list of\n[Company tabs][company].\n\nA Company tab displays a field for the name of the recipient's company. This value can't be set.\n\n[company]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_company\n";
          items: {
            $ref: '#/components/schemas/company';
          };
          type: 'array';
        };
        dateSignedTabs: {
          description: "A list of\n[Date Signed tabs][dateSigned].\n\n\nA Date Signed tab displays the date that the recipient signed the document. This value can't be set.\n\n[dateSigned]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/dateSigned';
          };
          type: 'array';
        };
        dateTabs: {
          description: "A list of\n[Date tabs][date].\n\nA Date tab enables the recipient to enter a date. This value can't be set. The tooltip for this tab recommends the date format MM/DD/YYYY, but several other date formats are also accepted. The system retains the format that the recipient enters.\n\n**Note:** If you need to enforce a specific date format, DocuSign recommends that you use a Text tab with a validation pattern and validation message.\n\n\n[date]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/date';
          };
          type: 'array';
        };
        declineTabs: {
          description: "A list of\n[Decline tabs][decline].\n\nA Decline tab enables the recipient to decline the envelope. If the recipient clicks the tab during the signing process, the envelope is voided. The value of this tab can't be set.\n\n\n[decline]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/decline';
          };
          type: 'array';
        };
        drawTabs: {
          description: 'A list of Draw Tabs.\n\nA Draw Tab allows the recipient to add a free-form drawing to the document.';
          items: {
            $ref: '#/components/schemas/draw';
          };
          type: 'array';
        };
        emailAddressTabs: {
          description: "A list of\n[Email Address tabs][emailAddress].\n\nAn Email Address tab displays the recipient's email as entered in the recipient information. This value can't be set.\n\n\n[emailAddress]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/emailAddress';
          };
          type: 'array';
        };
        emailTabs: {
          description: 'A list of\n[Email tabs][email].\n\nAn Email tab enables the recipient to enter an email address.\nThis is a one-line field that checks that a valid email\naddress is entered. It uses the same parameters as a Text\ntab, with the validation message and pattern set for email\ninformation. This value can be set.\n\nWhen getting information that includes\nthis tab type, the original value of the tab when the\nassociated envelope was sent is included in the response.\n\n[email]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/email';
          };
          type: 'array';
        };
        envelopeIdTabs: {
          description: "A list of\n[Envelope ID tabs][envelopeId].\n\nAn Envelope ID tab  displays the envelope ID. Recipients cannot enter or change the information in this tab. This value can't be set.\n\n\n[envelopeId]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#response201_envelopeid\n";
          items: {
            $ref: '#/components/schemas/envelopeId';
          };
          type: 'array';
        };
        firstNameTabs: {
          description: "A list of\n[First Name tabs][firstName].\n\nA First Name tab displays the recipient's first name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[firstName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_firstname\n";
          items: {
            $ref: '#/components/schemas/firstName';
          };
          type: 'array';
        };
        formulaTabs: {
          description: 'A list of [Formula tabs][formulaTab].\n\nThe value of a Formula tab is calculated from the values of other number or date tabs in the document. When the recipient completes the underlying fields, the Formula tab calculates and displays the result. This value can be set.\n\nThe `formula` property of the tab contains the references to the underlying tabs. To learn more about formulas, see [Calculated Fields][calculatedfields].\n\nIf a Formula tab contains a `paymentDetails` property, the tab is considered a payment item. To learn more about payments, see [Requesting Payments Along with Signatures][paymentguide].\n\n[calculatedfields]: https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields\n[paymentguide]:     https://support.docusign.com/en/guides/requesting-payments-along-with-signatures\n[formulaTab]:\t    \t/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/formulaTab';
          };
          type: 'array';
        };
        fullNameTabs: {
          description: "A list of\n[Full Name tabs][fullName].\n\nA Full Name tab displays the recipient's full name. This value can't be set.\n\n\n[fullName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/fullName';
          };
          type: 'array';
        };
        initialHereTabs: {
          description: "A list of\n[Initial Here tabs][initialHere].\n\nThis type of tab enables the recipient to initial the document. May be optional. This value can't be set.\n\n[initialHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/initialHere';
          };
          type: 'array';
        };
        lastNameTabs: {
          description: "A list of\n[Last Name tabs][lastName].\n\nA Last Name tab displays the recipient's last name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[lastName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/lastName';
          };
          type: 'array';
        };
        listTabs: {
          description: "An array of List tabs.\n\nA List tab enables the recipient to choose from a list of options. You specify the options in the `listItems` property. This value can't be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/list';
          };
          type: 'array';
        };
        notarizeTabs: {
          description: 'A list of  [Notarize tabs][notarize].\n\nA Notarize tab alerts notary recipients that they must take action on the page. This value can be set.\n\n**Note:** Only one notarize tab can appear on a page.\n\n[notarize]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/notarize';
          };
          type: 'array';
        };
        notarySealTabs: {
          description: 'A list of Notary Seal tabs.\n\nA Notary Seal tab enables the recipient to notarize a document. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/notarySeal';
          };
          type: 'array';
        };
        noteTabs: {
          description: 'A list of\n[Note tabs][note].\n\nA Note tab displays additional information to the recipient in the form of a note. This value can be set.\n\n[note]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/note';
          };
          type: 'array';
        };
        numberTabs: {
          description: 'A list of\n[Number tabs][number].\n\nA Number tab enables the recipient to enter numbers and decimal points (.). This value can be set.\n\n\n\n[number]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/number';
          };
          type: 'array';
        };
        numericalTabs: {
          description: '';
          items: {
            $ref: '#/components/schemas/numerical';
          };
          type: 'array';
        };
        phoneNumberTabs: {
          description: 'A list of\n[Phone Number tabs][cc].\n\n\nA Phone Number tab enables a recipient to enter a phone number.\n\n**Note:** This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/phoneNumber';
          };
          type: 'array';
        };
        polyLineOverlayTabs: {
          description: "This type of tab enables the recipient to strike through document text. This value can't be set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ";
          items: {
            $ref: '#/components/schemas/polyLineOverlay';
          };
          type: 'array';
        };
        prefillTabs: {
          $ref: '#/components/schemas/prefillTabs';
        };
        radioGroupTabs: {
          description: 'A list of [Radio Group tabs][radioGroup].\n\nA Radio Group tab places a group of radio buttons on a document. The `radios` property is used to add and place the radio\nbuttons associated with the group. Only one radio button can be selected in a group. This value can be set.\n\n\n[radioGroup]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/radioGroup';
          };
          type: 'array';
        };
        signHereTabs: {
          description: "A list of\n[Sign Here tabs][signHere].\n\nThis type of tab enables the recipient to sign a document. May be optional. This value can't be set.\n\n[signHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signHere';
          };
          type: 'array';
        };
        signerAttachmentTabs: {
          description: "A list of\n[Signer Attachment tabs][signerAttachment].\n\nThis type of tab enables the recipient to attach supporting documents to an envelope. This value can't be set.\n\n\n[signerAttachment]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signerAttachment';
          };
          type: 'array';
        };
        smartSectionTabs: {
          description: 'A list of [Smart Section](https://www.docusign.com/blog/dsdev-deep-dive-responsive-smart-sections) tabs.\n\nSmart Section tabs enhance responsive signing on mobile devices by enabling collapsible sections, page breaks, custom formatting options, and other advanced functionality.\n\n**Note:** Smart Sections are a premium feature. Responsive signing must also be enabled for your account.';
          items: {
            $ref: '#/components/schemas/smartSection';
          };
          type: 'array';
        };
        ssnTabs: {
          description: 'A list of\n[SSN tabs][ssn].\n\nAn SSN tab contains a one-line field that enables the recipient to enter a Social Security Number (SSN) with or without\ndashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information. This value can be set.\n\n\n[ssn]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/ssn';
          };
          type: 'array';
        };
        tabGroups: {
          description: "An array of `tabGroup` items.\n\nTo associate a tab with a tab group, add the tab group's `groupLabel` to the tab's `tabGroupLabels` array.\n";
          items: {
            $ref: '#/components/schemas/tabGroup';
          };
          type: 'array';
        };
        textTabs: {
          description: 'A list of\nText tabs.\n\nA text tab enables the recipient to enter free text. This value can be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/text';
          };
          type: 'array';
        };
        titleTabs: {
          description: "A list of\n[Title tabs][title].\n\nA Title tab displays the recipient's title.  This value can't be set.\n\n\n[title]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/title';
          };
          type: 'array';
        };
        viewTabs: {
          description: 'A list of\n[View tabs][view].\n\nA View tab is used with an Approve tab to handle supplemental documents.  This value can be set.\n\n[view]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/view';
          };
          type: 'array';
        };
        zipTabs: {
          description: 'A list of\n[Zip tabs][zip].\n\nA Zip tab enables the recipient to enter a ZIP code. The ZIP code can be five digits or nine digits ( in ZIP+4 format), and can be entered with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  This value can be set.\n\n\n[zip]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/zip';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'tabs';
      'x-ds-order': '50';
      'x-ms-summary': '';
    };
    TemplateDocumentVisibility: {
      description: "Document Visibility enables senders to control the visibility of the documents in an envelope at the recipient level. For example, if the parties associated with a legal proceeding should have access to different documents, the Document Visibility feature enables you to keep all of the documents in the same envelope and set view permissions for the documents by recipient. This functionality is enabled for envelopes and templates. It is not available for PowerForms.\n\n**Note:** Before you use Document Visibility, you should be aware of the following information:\n\n- Document Visibility must be enabled for your account by your DocuSign administrator. \n- A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. \n- When the Document Visibility setting hides a document from a recipient, the document also does not appear in the recipient's list of envelopes, documents, or page images.\n- Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all of the documents associated with the envelope or template.\n\nThe Document Visibility feature has multiple settings that specify the options that senders have when sending documents. For more information, see [Use Document Visibility to Control Recipient Access](https://support.docusign.com/en/guides/ndse-user-guide-document-visibility).";
      properties: {
        documentVisibility: {
          description: 'An array of `documentVisibility` objects that specifies which documents are visible to which recipients.';
          items: {
            $ref: '#/components/schemas/documentVisibility';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'templateDocumentVisibilityList';
      'x-ds-order': '180';
      'x-ms-summary': "Document Visibility enables senders to control the visibility of the documents in an envelope at the recipient level. For example, if the parties associated with a legal proceeding should have access to different documents, the Document Visibility feature enables you to keep all of the documents in the same envelope and set view permissions for the documents by recipient. This functionality is enabled for envelopes and templates. It is not available for PowerForms.\n\n**Note:** Before you use Document Visibility, you should be aware of the following information:\n\n- Document Visibility must be enabled for your account by your DocuSign administrator. \n- A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. \n- When the Document Visibility setting hides a document from a recipient, the document also does not appear in the recipient's list of envelopes, documents, or page images.\n- Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all of the documents associated with the envelope or template.\n\nThe Document Visibility feature has multiple settings that specify the options that senders have when sending documents. For more information, see [Use Document Visibility to Control Recipient Access](https://support.docusign.com/en/guides/ndse-user-guide-document-visibility).";
    };
    TemplateDocuments: {
      description: 'Template documents';
      properties: {
        templateDocuments: {
          description: 'An array of document objects that contain information about the documents associated with the template.';
          items: {
            $ref: '#/components/schemas/envelopeDocument';
          };
          type: 'array';
        };
        templateId: {
          description: 'The ID of the template. If a value is not provided, DocuSign generates a value. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'templateDocumentsResult';
      'x-ds-order': '40';
      'x-ms-summary': 'Template documents';
    };
    TemplateHtmlDefinitions: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ds-order': '310';
      'x-ms-summary': '';
    };
    TemplateLocks: {
      description: 'This section provides information about template locks. You use template locks to prevent others from making changes to a template while you are modifying it.';
      properties: {
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        lockDurationInSeconds: {
          description: 'The number of seconds until the lock expires when there is no activity on the template.\n\nIf no value is entered, then the default value of 300 seconds is used. The maximum value is 1,800 seconds.\n\nThe lock duration can be extended.\n';
          type: 'string';
        };
        lockToken: {
          description: 'A unique identifier provided to the owner of the lock. You must use this token with subsequent calls to prove ownership of the lock.';
          type: 'string';
        };
        lockType: {
          description: 'The type of lock.  Currently `edit` is the only supported type.';
          type: 'string';
        };
        lockedByApp: {
          description: 'Specifies the friendly name of  the application that is locking the envelope.';
          type: 'string';
        };
        lockedByUser: {
          $ref: '#/components/schemas/userInfo';
        };
        lockedUntilDateTime: {
          description: 'The date and time that the lock expires.';
          type: 'string';
        };
        useScratchPad: {
          description: 'When **true,** a scratchpad is used to edit information.\n ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'lockInformation';
      'x-ds-order': '80';
      'x-ms-summary': 'This section provides information about template locks. You use template locks to prevent others from making changes to a template while you are modifying it.';
    };
    TemplateRecipientTabs: {
      description: 'Template tabs';
      properties: {
        approveTabs: {
          description: "A list of\n[Approve tabs][approve].\n\nAn Approve tab enables\nthe recipient to approve documents without\nplacing a signature or initials on the document. If the\nrecipient clicks the tab during the signing process, the\nrecipient is considered to have signed the document. No\ninformation is shown on the document of the approval, but it\nis recorded as a signature in the envelope history.\nThe value of an approve tab can't be set.\n\n[approve]:\t\t      /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/approve';
          };
          type: 'array';
        };
        checkboxTabs: {
          description: 'A list of\n[Checkbox tabs][checkbox].\n\n\nA Checkbox tab enables the recipient to select a yes/no (on/off) option. This value can be set.\n\n\n[checkbox]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/checkbox';
          };
          type: 'array';
        };
        commentThreadTabs: {
          description: "An array of tabs that represents a collection of comments in a comment thread. For example, if a recipient has questions about the content of a document, they can add a comment to the document and control who else can see the comment. This value can't be set.";
          items: {
            $ref: '#/components/schemas/commentThread';
          };
          type: 'array';
        };
        commissionCountyTabs: {
          description: "A list of\n[Commission County tabs][cc].\n\n\nA Commission County tab displays the county of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionCounty';
          };
          type: 'array';
        };
        commissionExpirationTabs: {
          description: "A list of\n[Commission Expiration tabs][tabref].\n\n\nA Commission Expiration tab displays the expiration date of a notary's commission. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionExpiration';
          };
          type: 'array';
        };
        commissionNumberTabs: {
          description: "A list of\n[Commission Number tabs][tabref].\n\n\nA Commission Number tab displays a notary's commission number. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[tabref]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionNumber';
          };
          type: 'array';
        };
        commissionStateTabs: {
          description: "A list of\n[Commission State tabs][cc].\n\n\nA Commission County tab displays the state in which a notary's commission was granted. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary]. The tab's value can be edited by the recipient.\n\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/";
          items: {
            $ref: '#/components/schemas/commissionState';
          };
          type: 'array';
        };
        companyTabs: {
          description: "A list of\n[Company tabs][company].\n\nA Company tab displays a field for the name of the recipient's company. This value can't be set.\n\n[company]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_company\n";
          items: {
            $ref: '#/components/schemas/company';
          };
          type: 'array';
        };
        dateSignedTabs: {
          description: "A list of\n[Date Signed tabs][dateSigned].\n\n\nA Date Signed tab displays the date that the recipient signed the document. This value can't be set.\n\n[dateSigned]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/dateSigned';
          };
          type: 'array';
        };
        dateTabs: {
          description: "A list of\n[Date tabs][date].\n\nA Date tab enables the recipient to enter a date. This value can't be set. The tooltip for this tab recommends the date format MM/DD/YYYY, but several other date formats are also accepted. The system retains the format that the recipient enters.\n\n**Note:** If you need to enforce a specific date format, DocuSign recommends that you use a Text tab with a validation pattern and validation message.\n\n\n[date]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/date';
          };
          type: 'array';
        };
        declineTabs: {
          description: "A list of\n[Decline tabs][decline].\n\nA Decline tab enables the recipient to decline the envelope. If the recipient clicks the tab during the signing process, the envelope is voided. The value of this tab can't be set.\n\n\n[decline]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/decline';
          };
          type: 'array';
        };
        drawTabs: {
          description: 'A list of Draw Tabs.\n\nA Draw Tab allows the recipient to add a free-form drawing to the document.';
          items: {
            $ref: '#/components/schemas/draw';
          };
          type: 'array';
        };
        emailAddressTabs: {
          description: "A list of\n[Email Address tabs][emailAddress].\n\nAn Email Address tab displays the recipient's email as entered in the recipient information. This value can't be set.\n\n\n[emailAddress]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/emailAddress';
          };
          type: 'array';
        };
        emailTabs: {
          description: 'A list of\n[Email tabs][email].\n\nAn Email tab enables the recipient to enter an email address.\nThis is a one-line field that checks that a valid email\naddress is entered. It uses the same parameters as a Text\ntab, with the validation message and pattern set for email\ninformation. This value can be set.\n\nWhen getting information that includes\nthis tab type, the original value of the tab when the\nassociated envelope was sent is included in the response.\n\n[email]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/email';
          };
          type: 'array';
        };
        envelopeIdTabs: {
          description: "A list of\n[Envelope ID tabs][envelopeId].\n\nAn Envelope ID tab  displays the envelope ID. Recipients cannot enter or change the information in this tab. This value can't be set.\n\n\n[envelopeId]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#response201_envelopeid\n";
          items: {
            $ref: '#/components/schemas/envelopeId';
          };
          type: 'array';
        };
        firstNameTabs: {
          description: "A list of\n[First Name tabs][firstName].\n\nA First Name tab displays the recipient's first name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[firstName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#parameters_firstname\n";
          items: {
            $ref: '#/components/schemas/firstName';
          };
          type: 'array';
        };
        formulaTabs: {
          description: 'A list of [Formula tabs][formulaTab].\n\nThe value of a Formula tab is calculated from the values of other number or date tabs in the document. When the recipient completes the underlying fields, the Formula tab calculates and displays the result. This value can be set.\n\nThe `formula` property of the tab contains the references to the underlying tabs. To learn more about formulas, see [Calculated Fields][calculatedfields].\n\nIf a Formula tab contains a `paymentDetails` property, the tab is considered a payment item. To learn more about payments, see [Requesting Payments Along with Signatures][paymentguide].\n\n[calculatedfields]: https://support.docusign.com/en/guides/ndse-user-guide-calculated-fields\n[paymentguide]:     https://support.docusign.com/en/guides/requesting-payments-along-with-signatures\n[formulaTab]:\t    \t/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/formulaTab';
          };
          type: 'array';
        };
        fullNameTabs: {
          description: "A list of\n[Full Name tabs][fullName].\n\nA Full Name tab displays the recipient's full name. This value can't be set.\n\n\n[fullName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/fullName';
          };
          type: 'array';
        };
        initialHereTabs: {
          description: "A list of\n[Initial Here tabs][initialHere].\n\nThis type of tab enables the recipient to initial the document. May be optional. This value can't be set.\n\n[initialHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/initialHere';
          };
          type: 'array';
        };
        lastNameTabs: {
          description: "A list of\n[Last Name tabs][lastName].\n\nA Last Name tab displays the recipient's last name. The system automatically populates this field by splitting the name in the recipient information on spaces. This value can't be set.\n\n\n[lastName]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/lastName';
          };
          type: 'array';
        };
        listTabs: {
          description: "An array of List tabs.\n\nA List tab enables the recipient to choose from a list of options. You specify the options in the `listItems` property. This value can't be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/list';
          };
          type: 'array';
        };
        notarizeTabs: {
          description: 'A list of  [Notarize tabs][notarize].\n\nA Notarize tab alerts notary recipients that they must take action on the page. This value can be set.\n\n**Note:** Only one notarize tab can appear on a page.\n\n[notarize]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/notarize';
          };
          type: 'array';
        };
        notarySealTabs: {
          description: 'A list of Notary Seal tabs.\n\nA Notary Seal tab enables the recipient to notarize a document. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/notarySeal';
          };
          type: 'array';
        };
        noteTabs: {
          description: 'A list of\n[Note tabs][note].\n\nA Note tab displays additional information to the recipient in the form of a note. This value can be set.\n\n[note]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/note';
          };
          type: 'array';
        };
        numberTabs: {
          description: 'A list of\n[Number tabs][number].\n\nA Number tab enables the recipient to enter numbers and decimal points (.). This value can be set.\n\n\n\n[number]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/number';
          };
          type: 'array';
        };
        numericalTabs: {
          description: '';
          items: {
            $ref: '#/components/schemas/numerical';
          };
          type: 'array';
        };
        phoneNumberTabs: {
          description: 'A list of\n[Phone Number tabs][cc].\n\n\nA Phone Number tab enables a recipient to enter a phone number.\n\n**Note:** This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[cc]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n[notary]: /docs/notary-api/';
          items: {
            $ref: '#/components/schemas/phoneNumber';
          };
          type: 'array';
        };
        polyLineOverlayTabs: {
          description: "This type of tab enables the recipient to strike through document text. This value can't be set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ";
          items: {
            $ref: '#/components/schemas/polyLineOverlay';
          };
          type: 'array';
        };
        prefillTabs: {
          $ref: '#/components/schemas/prefillTabs';
        };
        radioGroupTabs: {
          description: 'A list of [Radio Group tabs][radioGroup].\n\nA Radio Group tab places a group of radio buttons on a document. The `radios` property is used to add and place the radio\nbuttons associated with the group. Only one radio button can be selected in a group. This value can be set.\n\n\n[radioGroup]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/radioGroup';
          };
          type: 'array';
        };
        signHereTabs: {
          description: "A list of\n[Sign Here tabs][signHere].\n\nThis type of tab enables the recipient to sign a document. May be optional. This value can't be set.\n\n[signHere]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signHere';
          };
          type: 'array';
        };
        signerAttachmentTabs: {
          description: "A list of\n[Signer Attachment tabs][signerAttachment].\n\nThis type of tab enables the recipient to attach supporting documents to an envelope. This value can't be set.\n\n\n[signerAttachment]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/signerAttachment';
          };
          type: 'array';
        };
        smartSectionTabs: {
          description: 'A list of [Smart Section](https://www.docusign.com/blog/dsdev-deep-dive-responsive-smart-sections) tabs.\n\nSmart Section tabs enhance responsive signing on mobile devices by enabling collapsible sections, page breaks, custom formatting options, and other advanced functionality.\n\n**Note:** Smart Sections are a premium feature. Responsive signing must also be enabled for your account.';
          items: {
            $ref: '#/components/schemas/smartSection';
          };
          type: 'array';
        };
        ssnTabs: {
          description: 'A list of\n[SSN tabs][ssn].\n\nAn SSN tab contains a one-line field that enables the recipient to enter a Social Security Number (SSN) with or without\ndashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information. This value can be set.\n\n\n[ssn]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/ssn';
          };
          type: 'array';
        };
        tabGroups: {
          description: "An array of `tabGroup` items.\n\nTo associate a tab with a tab group, add the tab group's `groupLabel` to the tab's `tabGroupLabels` array.\n";
          items: {
            $ref: '#/components/schemas/tabGroup';
          };
          type: 'array';
        };
        textTabs: {
          description: 'A list of\nText tabs.\n\nA text tab enables the recipient to enter free text. This value can be set.\n\nFind descriptions of all tab types in\nthe [EnvelopeRecipientTabs Resource][ert].\n\n[ert]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/text';
          };
          type: 'array';
        };
        titleTabs: {
          description: "A list of\n[Title tabs][title].\n\nA Title tab displays the recipient's title.  This value can't be set.\n\n\n[title]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n";
          items: {
            $ref: '#/components/schemas/title';
          };
          type: 'array';
        };
        viewTabs: {
          description: 'A list of\n[View tabs][view].\n\nA View tab is used with an Approve tab to handle supplemental documents.  This value can be set.\n\n[view]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/view';
          };
          type: 'array';
        };
        zipTabs: {
          description: 'A list of\n[Zip tabs][zip].\n\nA Zip tab enables the recipient to enter a ZIP code. The ZIP code can be five digits or nine digits ( in ZIP+4 format), and can be entered with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  This value can be set.\n\n\n[zip]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n';
          items: {
            $ref: '#/components/schemas/zip';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'tabs';
      'x-ds-order': '50';
      'x-ms-summary': 'Template tabs';
    };
    TemplateRecipients: {
      description: 'Template recipients';
      properties: {
        agents: {
          description: 'A list of agent recipients assigned to the documents.';
          items: {
            $ref: '#/components/schemas/agent';
          };
          type: 'array';
        };
        carbonCopies: {
          description: 'A list of carbon copy recipients assigned to the documents.';
          items: {
            $ref: '#/components/schemas/carbonCopy';
          };
          type: 'array';
        };
        certifiedDeliveries: {
          description: 'A complex type containing information on a recipient the must receive the completed documents for the envelope to be completed, but the recipient does not need to sign, initial, date, or add information to any of the documents.';
          items: {
            $ref: '#/components/schemas/certifiedDelivery';
          };
          type: 'array';
        };
        currentRoutingOrder: {
          description: "The routing order of the current recipient. If this value equals a particular signer's routing order, it indicates that the envelope has been sent to that recipient, but he or she has not completed the required actions.";
          type: 'string';
        };
        editors: {
          description: 'A complex type defining the management and access rights of a recipient assigned assigned as an editor on the document.';
          items: {
            $ref: '#/components/schemas/editor';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        inPersonSigners: {
          description: 'Specifies a signer that is in the same physical location as a DocuSign user who will act as a Signing Host for the transaction. The recipient added is the Signing Host and new separate Signer Name field appears after Sign in person is selected.';
          items: {
            $ref: '#/components/schemas/inPersonSigner';
          };
          type: 'array';
        };
        intermediaries: {
          description: 'Identifies a recipient that can, but is not required to, add name and email information for recipients at the same or subsequent level in the routing order (until subsequent Agents, Editors or Intermediaries recipient types are added).';
          items: {
            $ref: '#/components/schemas/intermediary';
          };
          type: 'array';
        };
        notaries: {
          description: 'A list of notary recipients on the envelope.';
          items: {
            $ref: '#/components/schemas/notaryRecipient';
          };
          type: 'array';
        };
        participants: {
          description: '';
          items: {
            $ref: '#/components/schemas/participant';
          };
          type: 'array';
        };
        recipientCount: {
          description: 'The number of recipients in the envelope.';
          type: 'string';
        };
        seals: {
          description: 'Specifies one or more electronic seals to apply on documents. For more information on Electronic Seals , see https://support.docusign.com/en/guides/ndse-user-guide-apply-electronic-seals';
          items: {
            $ref: '#/components/schemas/sealSign';
          };
          type: 'array';
        };
        signers: {
          description: 'A list of signers on the envelope.';
          items: {
            $ref: '#/components/schemas/signer';
          };
          type: 'array';
        };
        witnesses: {
          description: 'A list of signers who act as witnesses on the envelope.';
          items: {
            $ref: '#/components/schemas/witness';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'recipients';
      'x-ds-order': '20';
      'x-ms-summary': 'Template recipients';
    };
    TemplateResponsiveHtmlPreview: {
      description: 'This resource is used to create a responsive preview of all of the documents associated with a template.';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'documentHtmlDefinitions';
      'x-ds-order': '290';
      'x-ms-summary': 'This resource is used to create a responsive preview of all of the documents associated with a template.';
    };
    TemplateViews: {
      description: 'A TemplateView contains a URL that you can embed in your application to generate a template view that uses the DocuSign user interface (UI).';
      properties: {
        url: {
          description: 'The URL that you navigate to in order to start the view.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'viewUrl';
      'x-ds-order': '55';
      'x-ms-summary': 'A TemplateView contains a URL that you can embed in your application to generate a template view that uses the DocuSign user interface (UI).';
    };
    Templates: {
      description: 'Template management';
      properties: {
        accessControlListBase64: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        allowComments: {
          description: 'When **true,** indicates that comments are allowed on the envelope.';
          type: 'string';
        };
        allowMarkup: {
          description: 'When **true,** the Document Markup feature is enabled.\n\n**Note:**  To use this feature, Document Markup must be enabled at both the account and envelope levels. Only Admin users can change this setting at the account level.\n';
          type: 'string';
        };
        allowReassign: {
          description: 'When **true,** the recipient can redirect an envelope to a more appropriate recipient.';
          type: 'string';
        };
        allowViewHistory: {
          description: 'When **true,** recipients can view the history of the envelope.';
          type: 'string';
        };
        anySigner: {
          description: 'Deprecated. This feature has been replaced by signing groups.';
          type: 'string';
        };
        asynchronous: {
          description: 'When **true,** the envelope is queued for\nprocessing and the value of the `status` property\nis set to `Processing`. Additionally, GET status\ncalls return `Processing` until completed.\n\n\n**Note:** A `transactionId` is required for this\ncall to work correctly. When the envelope is\ncreated, the status is `Processing` and an\n`envelopeId` is not returned in the response. To\nget the `envelopeId`, use a GET envelope query by\nusing the\n[transactionId](/docs/esign-rest-api/reference/envelopes/envelopes/create/) or by checking the\nConnect notification.';
          type: 'string';
        };
        attachmentsUri: {
          description: 'Contains a URL for retrieving the attachments that are associated with the envelope.';
          type: 'string';
        };
        authoritativeCopy: {
          description: 'When **true,** marks all of the documents in the envelope as authoritative copies.\n\n**Note:** You can override this value for a specific document. For example, you can set the `authoritativeCopy` property to **true** at the envelope level, but turn it off for a single document by setting the `authoritativeCopy` property for the document to **false.**';
          type: 'string';
        };
        authoritativeCopyDefault: {
          description: "The default `authoritativeCopy` setting for documents in this envelope that do not have `authoritativeCopy` set.\nIf this property is not set, each document defaults to the envelope's `authoritativeCopy`.";
          type: 'string';
        };
        autoMatch: {
          description: 'By default, templates that have been used within\nthe last 60 days are included in auto-matching.\n\nBy explicitly setting `autoMatch`,\nyou can permanently include or exclude the template\nin auto matching.\n\nWhen **true** the template is included in auto-matching\nregardless of when it was last used.\n\nWhen **false** the template is never included in auto-matching.';
          type: 'string';
        };
        autoMatchSpecifiedByUser: {
          description: 'When **true,** the template has been explicitly included in or excluded from auto-matching. The default is false.\nThis is a read-only property.';
          type: 'string';
        };
        autoNavigation: {
          description: 'When **true,** autonavigation is set for the recipient.\n';
          type: 'string';
        };
        brandId: {
          description: 'The ID of the brand.';
          type: 'string';
        };
        brandLock: {
          description: 'When **true,** the `brandId` for the envelope is locked and senders cannot change the brand used for the envelope.';
          type: 'string';
        };
        burnDefaultTabData: {
          description: '';
          type: 'string';
        };
        certificateUri: {
          description: 'The URI for retrieving certificate information.';
          type: 'string';
        };
        completedDateTime: {
          description: 'Specifies the date and time this item was completed.';
          type: 'string';
        };
        copyRecipientData: {
          description: '';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the workspace user authorization was created.';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        customFields: {
          $ref: '#/components/schemas/AccountCustomFields';
        };
        customFieldsUri: {
          description: 'The URI for retrieving custom fields.';
          type: 'string';
        };
        declinedDateTime: {
          description: 'The date and time the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        deletedDateTime: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        deliveredDateTime: {
          description: 'The date and time that the envelope was delivered to the recipient. This property is read-only.';
          type: 'string';
        };
        description: {
          description: 'A sender-defined description of the line item.\n';
          type: 'string';
        };
        disableResponsiveDocument: {
          description: 'When **true,** responsive documents are disabled for the envelope.';
          type: 'string';
        };
        documentBase64: {
          description: "The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.";
          type: 'string';
        };
        documents: {
          description: 'A complex element that contains details about the documents associated with the envelope.';
          items: {
            $ref: '#/components/schemas/document';
          };
          type: 'array';
        };
        documentsCombinedUri: {
          description: 'The URI for retrieving all of the documents associated with the envelope as a single PDF file.';
          type: 'string';
        };
        documentsUri: {
          description: 'The URI for retrieving all of the documents associated with the envelope as separate files.';
          type: 'string';
        };
        emailBlurb: {
          description: 'This is the same as the email body. If the sender enters an email blurb, it is included in the email body for all envelope recipients.';
          type: 'string';
        };
        emailSettings: {
          $ref: '#/components/schemas/emailSettings';
        };
        emailSubject: {
          description: 'The subject line of the email message that is sent to all recipients.\n\nFor information about adding merge field information to the email subject, see [Template Email Subject Merge Fields](/docs/esign-rest-api/reference/templates/templates/create/#template-email-subject-merge-fields).\n\n**Note:** The subject line is limited to 100 characters, including any merged fields.It is not truncated. It is an error if the text is longer than 100 characters.\n';
          type: 'string';
        };
        enableWetSign: {
          description: 'When **true,** the signer is allowed to print the document and sign it on paper.';
          type: 'string';
        };
        enforceSignerVisibility: {
          description: 'When **true,** signers can only view the documents on which they have tabs. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all of the documents in an envelope, unless they are specifically excluded by using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded by using this setting when an envelope is sent.\n\n**Note:** To use this functionality, [Document Visibility][docviz] must be enabled for the account by making the account setting `allowDocumentVisibility` **true.**\n\n[docviz]: /docs/esign-rest-api/reference/envelopes/envelopedocumentvisibility/';
          type: 'string';
        };
        envelopeAttachments: {
          description: 'An array of attachment objects that provide information about the attachments that are associated with the envelope.';
          items: {
            $ref: '#/components/schemas/attachment';
          };
          type: 'array';
        };
        envelopeCustomMetadata: {
          $ref: '#/components/schemas/envelopeCustomMetadata';
        };
        envelopeDocuments: {
          description: 'An array containing information about the documents that are included in the envelope.';
          items: {
            $ref: '#/components/schemas/envelopeDocument';
          };
          type: 'array';
        };
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        envelopeIdStamping: {
          description: 'When **true,** [Envelope ID Stamping](https://support.docusign.com/en/guides/ndse-user-guide-set-advanced-document-options) is enabled.\nAfter a document or attachment is stamped with an Envelope ID,\nthe ID is seen by all recipients\nand becomes a permanent part of the document\nand cannot be removed.';
          type: 'string';
        };
        envelopeLocation: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        envelopeMetadata: {
          $ref: '#/components/schemas/envelopeMetadata';
        };
        envelopeUri: {
          description: 'The URI for retrieving the envelope or envelopes.';
          type: 'string';
        };
        expireAfter: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        expireDateTime: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        expireEnabled: {
          description: 'Not used. Use the\n[`expirations`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification_expirations)\nproperty in the [`notification`](/docs/esign-rest-api/reference/envelopes/envelopes/create/#definition__envelopedefinition_notification) object instead.';
          type: 'string';
        };
        externalEnvelopeId: {
          description: 'May contain an external identifier for the envelope.';
          type: 'string';
        };
        favoritedByMe: {
          description: '';
          type: 'string';
        };
        folderId: {
          description: 'The unique identifier for the folder that the template belongs to.';
          type: 'string';
        };
        folderIds: {
          description: 'An array of folder IDs that the template is in.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        folderName: {
          description: 'The name of the folder the template belongs to.';
          type: 'string';
        };
        folders: {
          description: 'A list of folder objects.';
          items: {
            $ref: '#/components/schemas/folder';
          };
          type: 'array';
        };
        hasComments: {
          description: 'When **true,** indicates that users have added comments to the envelope.';
          type: 'string';
        };
        hasFormDataChanged: {
          description: 'Specifies if the `EnvelopeFormData` associated with any forms in the template has changed.';
          type: 'string';
        };
        hasWavFile: {
          description: 'When **true,** indicates that the template includes a .wav file.';
          type: 'string';
        };
        holder: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        initialSentDateTime: {
          description: 'The date and time the envelope that used the template was initially sent.';
          type: 'string';
        };
        is21CFRPart11: {
          description: 'When **true,** indicates compliance with United States Food and Drug Administration (FDA) regulations on electronic records and electronic signatures (ERES).';
          type: 'string';
        };
        isDocGenTemplate: {
          description: '';
          type: 'string';
        };
        isDynamicEnvelope: {
          description: 'When **true,** indicates that the envelope is a dynamic envelope.';
          type: 'string';
        };
        isSignatureProviderEnvelope: {
          description: 'When **true,** indicates that the envelope is a signature-provided envelope.';
          type: 'string';
        };
        lastModified: {
          description: 'The UTC date and time that the comment was last updated.\n\n**Note:** This can only be done by the creator.';
          type: 'string';
        };
        lastModifiedBy: {
          $ref: '#/components/schemas/userInfo';
        };
        lastModifiedDateTime: {
          description: 'The date and time the template was last modified.';
          type: 'string';
        };
        lastUsed: {
          description: 'The date and time the template was last used.';
          type: 'string';
        };
        location: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lockInformation: {
          $ref: '#/components/schemas/EnvelopeLocks';
        };
        messageLock: {
          description: 'When **true,** prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope. \n\nAdditionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes. \n\nHowever, if the `messageLock` node is set to **true** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.';
          type: 'string';
        };
        name: {
          description: 'The name of the template.';
          type: 'string';
        };
        newPassword: {
          description: "The user's new password.";
          type: 'string';
        };
        notification: {
          $ref: '#/components/schemas/notification';
        };
        notificationUri: {
          description: 'The URI for retrieving notifications.';
          type: 'string';
        };
        owner: {
          $ref: '#/components/schemas/userInfo';
        };
        pageCount: {
          description: 'An integer value specifying the number of document pages in the template. ';
          type: 'string';
        };
        password: {
          description: 'The password for editing the template.';
          type: 'string';
        };
        passwordProtected: {
          description: 'When **true,** a password is required to edit the template.';
          type: 'string';
        };
        powerForm: {
          $ref: '#/components/schemas/powerForm';
        };
        powerForms: {
          description: 'An array of PowerForm objects that contain information about any PowerForms that are included in the template.';
          items: {
            $ref: '#/components/schemas/powerForm';
          };
          type: 'array';
        };
        purgeCompletedDate: {
          description: 'The date that a purge was completed.';
          type: 'string';
        };
        purgeRequestDate: {
          description: 'The date that a purge was requested.';
          type: 'string';
        };
        purgeState: {
          description: 'Shows the current purge state for the envelope. Valid values:\n\n- `unpurged`: There has been no successful request to purge documents.\n- `documents_queued`: The envelope documents have been added to the purge queue, but have not been purged.\n- `documents_dequeued`: The envelope documents have been taken out of the purge queue.\n- `documents_purged`: The envelope documents have been successfully purged.\n- `documents_and_metadata_queued`: The envelope documents and metadata have been added to the purge queue, but have not yet been purged.\n- `documents_and_metadata_purged`: The envelope documents and metadata have been successfully purged.\n- `documents_and_metadata_and_redact_queued`: The envelope documents and metadata have been added to the purge queue, but have not yet been purged, nor has personal information been redacted.\n- `documents_and_metadata_and_redact_purged`: The envelope documents and metadata have been successfully purged, and personal information has been redacted.\n\n**Related topics**\n\n- [Purging documents (eSingature Concepts)](/docs/esign-rest-api/esign101/concepts/documents/purging/)\n- [Purging documents in an envelope (blog post)](https://www.docusign.com/blog/developers/purging-documents-envelope)\n\n';
          type: 'string';
        };
        recipients: {
          $ref: '#/components/schemas/EnvelopeRecipients';
        };
        recipientsLock: {
          description: 'When **true,** prevents senders from changing, correcting, or deleting the recipient information for the envelope.';
          type: 'string';
        };
        recipientsUri: {
          description: 'Contains a URI for an endpoint that you can use to retrieve the recipients.';
          type: 'string';
        };
        sender: {
          $ref: '#/components/schemas/userInfo';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        shared: {
          description: 'When **true,** indicates the template is shared with the **Everyone** group,\nand is shared with all users on the account.\n\nWhen **false,** the template is shared only with the groups you specify.';
          type: 'string';
        };
        signerCanSignOnMobile: {
          description: 'When **true,** recipients can sign on a mobile device.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signingLocation: {
          description: 'Specifies the physical location where the signing takes place. It can have two enumeration values; `inPerson` and `online`. The default value is `online`.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* `completed`: The recipients have finished working with the envelope: the documents are signed and all required tabs are filled in.\n* `created`: The envelope is created as a draft. It can be modified and sent later.\n* `declined`: The envelope has been declined by the recipients.\n* `delivered`: The envelope has been delivered to the recipients.\n* `sent`: The envelope will be sent to the recipients after the envelope is created.\n* `signed`: The envelope has been signed by the recipients.\n* `voided`: The envelope is no longer valid and recipients cannot access or sign the envelope.\n';
          type: 'string';
        };
        statusChangedDateTime: {
          description: 'The data and time that the status changed.';
          type: 'string';
        };
        statusDateTime: {
          description: 'The DateTime that the envelope changed status (i.e. was created or sent.)';
          type: 'string';
        };
        templateId: {
          description: 'The unique identifier of the template. If this is not provided, DocuSign will generate a value. ';
          type: 'string';
        };
        templatesUri: {
          description: 'The URI for retrieving the templates.';
          type: 'string';
        };
        transactionId: {
          description: " Used to identify an envelope. The ID is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.";
          type: 'string';
        };
        uri: {
          description: 'Contains a URI that you can use to retreve the template.';
          type: 'string';
        };
        useDisclosure: {
          description: "When **true,** the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When **false,** the Electronic Record and Signature Disclosure is not shown to any envelope recipients. \n\nIf the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.";
          type: 'string';
        };
        voidedDateTime: {
          description: 'The date and time the envelope or template was voided.';
          type: 'string';
        };
        voidedReason: {
          description: 'The reason the envelope or template was voided.\n\n**Note:** The string is truncated to the first 200 characters.\n';
          type: 'string';
        };
        workflow: {
          $ref: '#/components/schemas/workflow';
        };
      };
      type: 'object';
      'x-ds-category': 'Templates';
      'x-ds-definition-name': 'envelopeTemplate';
      'x-ds-order': '10';
      'x-ms-summary': 'Template management';
    };
    UserCustomSettings: {
      description: "Users' custom settings";
      properties: {
        customSettings: {
          description: 'The name/value pair information for the user custom setting.';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-category': 'Users';
      'x-ds-definition-name': 'customSettingsInformation';
      'x-ds-order': '30';
      'x-ms-summary': "Users' custom settings";
    };
    UserProfiles: {
      description: "Users' profiles";
      properties: {
        address: {
          $ref: '#/components/schemas/addressInformation';
        };
        authenticationMethods: {
          description: 'Indicates the authentication methods that the user uses. These properties cannot be modified by the PUT operation. ';
          items: {
            $ref: '#/components/schemas/authenticationMethod';
          };
          type: 'array';
        };
        companyName: {
          description: "The name of the user's company.";
          type: 'string';
        };
        displayOrganizationInfo: {
          description: " When **true,** the user's company and title information display on the ID card. ";
          type: 'string';
        };
        displayPersonalInfo: {
          description: "When **true,** the user's address and phone number display on the ID card.";
          type: 'string';
        };
        displayProfile: {
          description: "When **true,** the user's ID card can be viewed from signed documents and envelope history.";
          type: 'string';
        };
        displayUsageHistory: {
          description: "When **true,** the user's usage information displays on the ID card.";
          type: 'string';
        };
        profileImageUri: {
          description: "The URL for retrieving the user's profile image.";
          type: 'string';
        };
        title: {
          description: "The user's job title.\n\nLimit: 100 characters.";
          type: 'string';
        };
        usageHistory: {
          $ref: '#/components/schemas/usageHistory';
        };
        userDetails: {
          $ref: '#/components/schemas/userInformation';
        };
        userProfileLastModifiedDate: {
          description: "The date and time that the user's profile was last modified.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Users';
      'x-ds-definition-name': 'userProfile';
      'x-ds-order': '20';
      'x-ms-summary': "Users' profiles";
    };
    UserSignatures: {
      description: "Users' signatures";
      properties: {
        adoptedDateTime: {
          description: 'The date and time the user adopted their signature.';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC date and time when the user created the signature.';
          type: 'string';
        };
        customField: {
          description: 'Serialized information about any custom [eHanko stamps](https://support.docusign.com/en/articles/Sending-and-Signing-with-eHanko) that have been ordered from an eHanko provider, including the order status, purchase order id, time created, and time modified.';
          type: 'string';
        };
        dateStampProperties: {
          $ref: '#/components/schemas/dateStampProperties';
        };
        disallowUserResizeStamp: {
          description: 'When **true,** users may not resize the stamp.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        externalID: {
          description: "An external ID for the signature or stamp.\n\n**Note:** If a recipient uses a stamp instead of a signature, this is the stamp vendor's serial number for the stamp.";
          type: 'string';
        };
        imageBase64: {
          description: 'A Base64-encoded representation of the signature image.';
          type: 'string';
        };
        imageType: {
          description: 'The format of the signature image, such as:\n\n- `GIF`\n- `PNG`\n- `JPG`\n- `PDF`\n- `BMP`';
          type: 'string';
        };
        initials150ImageId: {
          description: "The ID of the user's initials image.";
          type: 'string';
        };
        initialsImageUri: {
          description: "The URI for retrieving the image of the user's initials.";
          type: 'string';
        };
        isDefault: {
          description: 'Boolean that specifies whether the signature is the default signature for the user.';
          type: 'string';
        };
        lastModifiedDateTime: {
          description: 'The UTC date and time when the signature was last modified.';
          type: 'string';
        };
        nrdsId: {
          description: 'The National Association of Realtors (NAR) membership ID for a user who is a realtor.';
          type: 'string';
        };
        nrdsLastName: {
          description: "The realtor's last name.";
          type: 'string';
        };
        nrdsStatus: {
          description: "The realtor's NAR membership status. The value `active` verifies that the user is a current NAR member. Valid values are:\n\n- `Active`\n- `Inactive`\n- `Terminate`\n- `Provisional`\n- `Deceased`\n- `Suspend`\n- `Unknown`";
          type: 'string';
        };
        phoneticName: {
          description: 'The phonetic spelling of the `signatureName`.';
          type: 'string';
        };
        signature150ImageId: {
          description: "The ID of the user's signature image.";
          type: 'string';
        };
        signatureFont: {
          description: 'The font type for the signature, if the signature is not drawn. The supported font types are:\n\n"7_DocuSign", "1_DocuSign", "6_DocuSign", "8_DocuSign", "3_DocuSign", "Mistral", "4_DocuSign", "2_DocuSign", "5_DocuSign", "Rage Italic"\n';
          type: 'string';
        };
        signatureId: {
          description: 'The ID associated with the signature name. You can use this property in the URI in place of the signature name. This enables the use of special characters (such as "&", "<", and ">") in a signature name.\n\n**Note:** When you update a signature, its signature ID might change. In that case you need to use `signatureName` to get the new `signatureId`.';
          type: 'string';
        };
        signatureImageUri: {
          description: "An endpoint URI that you can use to retrieve the user's signature image.";
          type: 'string';
        };
        signatureInitials: {
          description: ' The initials associated with the signature.';
          type: 'string';
        };
        signatureName: {
          description: "Specifies the user's signature name.";
          type: 'string';
        };
        signatureRights: {
          description: 'The rights that the user has to the signature. Valid values are:\n\n- `none`\n- `read`\n- `admin`';
          type: 'string';
        };
        signatureType: {
          description: "Specifies the type of signature. Possible values include:\n\n- `RubberStamp`: A DocuSign pre-formatted signature style. This is the default value.\n- `Imported`: A signature image that the user uploaded.\n- `Drawn`: A freehand drawing of the user's signature and initials.";
          type: 'string';
        };
        stampFormat: {
          description: "The format of a stamp. Valid values are:\n\n- `NameHanko`: The stamp represents only the signer's name.\n- `NameDateHanko`: The stamp represents the signer's name and the date. ";
          type: 'string';
        };
        stampImageUri: {
          description: "The URI for retrieving the image of the user's stamp.";
          type: 'string';
        };
        stampSizeMM: {
          description: 'The physical height of the stamp image (in millimeters) that the stamp vendor recommends for displaying the image in PDF documents.';
          type: 'string';
        };
        stampType: {
          description: 'The type of stamp. Valid values are:\n\n- `signature`: A signature image. This is the default value.\n- `stamp`: A stamp image.\n- null';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Users';
      'x-ds-definition-name': 'userSignature';
      'x-ds-order': '40';
      'x-ms-summary': "Users' signatures";
    };
    Users: {
      description: 'The Users resource enables you to create and manage account users.';
      properties: {
        activationAccessCode: {
          description: 'The activation code a new user must enter when activating their account.';
          type: 'string';
        };
        company: {
          description: "The name of the user's company.";
          type: 'string';
        };
        connectConfigurations: {
          description: "Object representing the user's custom Connect configuration.";
          items: {
            $ref: '#/components/schemas/connectUserObject';
          };
          type: 'array';
        };
        countryCode: {
          description: '';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        customSettings: {
          description: 'The name/value pair information for the user custom setting.';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
        defaultAccountId: {
          description: 'The default account ID associated with the user.';
          type: 'string';
        };
        email: {
          description: "The user's email address.";
          type: 'string';
        };
        enableConnectForUser: {
          description: 'Boolean value that specifies whether the user is enabled for updates from DocuSign Connect.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        firstName: {
          description: "The user's first name. \nMaximum Length: 50 characters.";
          type: 'string';
        };
        forgottenPasswordInfo: {
          $ref: '#/components/schemas/forgottenPasswordInformation';
        };
        groupList: {
          description: "A list of the group information for groups to add the user to.\nUse [UserGroups: listGroups](/docs/esign-rest-api/reference/usergroups/groups/list/) to get information about groups.\n\nWhen setting a user's group, only the `groupId` is required.\n";
          items: {
            $ref: '#/components/schemas/group';
          };
          type: 'array';
        };
        hasRemoteNotary: {
          description: '';
          type: 'boolean';
        };
        homeAddress: {
          $ref: '#/components/schemas/addressInformation';
        };
        initialsImageUri: {
          description: "The URI for retrieving the image of the user's initials.";
          type: 'string';
        };
        isAdmin: {
          description: 'Determines if the feature set is actively set as part of the plan.';
          type: 'string';
        };
        isAlternateAdmin: {
          description: '';
          type: 'string';
        };
        isNAREnabled: {
          description: 'When **true,** National Association of Realtors (NAR) signature logos are enabled for the user.';
          type: 'string';
        };
        jobTitle: {
          description: "The user's job title.";
          type: 'string';
        };
        lastLogin: {
          description: 'The date and time when the user last logged in to the system.';
          type: 'string';
        };
        lastName: {
          description: "The user's last name. \nMaximum Length: 50 characters.";
          type: 'string';
        };
        loginStatus: {
          description: "Shows the current status of the user's password. Possible values are: \n\n* password_reset\n* password_active\n* password_expired\n* password_locked\n* password_reset_failed \n";
          type: 'string';
        };
        middleName: {
          description: "The user's middle name. \nLimit: 50 characters.";
          type: 'string';
        };
        password: {
          description: "The user's password.";
          type: 'string';
        };
        passwordExpiration: {
          description: "If password expiration is enabled, the date-time when the user's password expires.";
          type: 'string';
        };
        permissionProfileId: {
          description: 'The ID of the permission profile associated with the user.';
          type: 'string';
        };
        permissionProfileName: {
          description: 'The name of the permission profile associated with the user.';
          type: 'string';
        };
        profileImageUri: {
          description: "The URL for retrieving the user's profile image.";
          type: 'string';
        };
        sendActivationEmail: {
          description: 'This field is no longer supported for most accounts. To create an eSignature user without sending an activation email, use the Admin API by following [these steps](/docs/admin-api/how-to/create-active-user/).';
          type: 'string';
        };
        sendActivationOnInvalidLogin: {
          description: "When **true,** specifies that an additional activation email be sent if user's log on fails before the account is activated.";
          type: 'string';
        };
        signatureImageUri: {
          description: "An endpoint URI that you can use to retrieve the user's signature image.";
          type: 'string';
        };
        subscribe: {
          description: '';
          type: 'string';
        };
        suffixName: {
          description: "The suffix for the user's name, such as Jr, IV, PhD, etc.\n\nLimit: 50 characters. ";
          type: 'string';
        };
        title: {
          description: 'The salutation for the user, such as Ms, Dr, Capt., etc.\n\nLimit: 10 characters.';
          type: 'string';
        };
        uri: {
          description: 'A URI containing the user ID.';
          type: 'string';
        };
        userAddedToAccountDateTime: {
          description: 'The date and time that the user was added to the account.';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
        userName: {
          description: "The user's full name.\n<!--\n`title` + `firstName` + `middleName` + `lastName` + `suffixName`\n-->";
          type: 'string';
        };
        userProfileLastModifiedDate: {
          description: "The date and time that the user's profile was last modified.";
          type: 'string';
        };
        userSettings: {
          $ref: '#/components/schemas/userSettingsInformation';
        };
        userStatus: {
          description: "Status of the user's account. One of:\n\n- `ActivationRequired`\n- `ActivationSent`\n- `Active`\n- `Closed`\n- `Disabled`\n";
          type: 'string';
        };
        userType: {
          description: 'The type of user, for example `CompanyUser`.';
          type: 'string';
        };
        workAddress: {
          $ref: '#/components/schemas/addressInformation';
        };
      };
      type: 'object';
      'x-ds-category': 'Users';
      'x-ds-definition-name': 'userInformation';
      'x-ds-order': '10';
      'x-ms-summary': 'The Users resource enables you to create and manage account users.';
    };
    WorkspaceItems: {
      description: 'This object contains information about a file or folder in a workspace.';
      properties: {
        callerAuthorization: {
          $ref: '#/components/schemas/workspaceUserAuthorization';
        };
        contentType: {
          description: 'If the item is a file, this property specifies the content type of the file.';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the workspace item was created.';
          type: 'string';
        };
        createdById: {
          description: 'The ID of the user who created the workspace item.';
          type: 'string';
        };
        createdByInformation: {
          $ref: '#/components/schemas/workspaceUser';
        };
        extension: {
          description: 'The file extension of a file item.';
          type: 'string';
        };
        fileSize: {
          description: 'The size of the file in bytes.';
          type: 'string';
        };
        fileUri: {
          description: 'The URI for retrieving the file.';
          type: 'string';
        };
        id: {
          description: 'The ID of the workspace item.';
          type: 'string';
        };
        isPublic: {
          description: ' When **true,** the item is public.';
          type: 'string';
        };
        lastModified: {
          description: 'The UTC DateTime that the item was last modified.';
          type: 'string';
        };
        lastModifiedById: {
          description: 'The ID of the user who last modified the item.';
          type: 'string';
        };
        lastModifiedByInformation: {
          $ref: '#/components/schemas/workspaceUser';
        };
        name: {
          description: 'The name of the file or folder.';
          type: 'string';
        };
        pageCount: {
          description: 'The number of pages in a file.';
          type: 'string';
        };
        parentFolderId: {
          description: 'The ID of the parent folder, or the special value `root` for the root folder.';
          type: 'string';
        };
        parentFolderUri: {
          description: 'The URI of the parent folder.';
          type: 'string';
        };
        sha256: {
          description: 'A 64-byte, Secure Hash Algorithm 256 (SHA256) checksum that the caller computes across the entirety of the original content of a file. DocuSign compares this value to its own computation. If the two values are not equal, the original content and received content are not the same and the upload is refused.';
          type: 'string';
        };
        thumbHeight: {
          description: 'The height of the thumbnail image.';
          type: 'string';
        };
        thumbWidth: {
          description: 'The width of the thumbnail image.';
          type: 'string';
        };
        thumbnail: {
          $ref: '#/components/schemas/page';
        };
        type: {
          description: 'The type of workspace item. Valid values are:\n\n- `file`\n- `folder`';
          type: 'string';
        };
        uri: {
          description: 'A URI containing the user ID.';
          type: 'string';
        };
        userAuthorization: {
          $ref: '#/components/schemas/workspaceUserAuthorization';
        };
      };
      type: 'object';
      'x-ds-category': 'Workspaces';
      'x-ds-definition-name': 'workspaceItem';
      'x-ds-order': '130';
      'x-ms-summary': 'This object contains information about a file or folder in a workspace.';
    };
    Workspaces: {
      description: 'A DocuSign workspace is a collaboration area for sharing files and data.';
      properties: {
        billableAccountId: {
          description: 'The ID of the account to bill.';
          type: 'string';
        };
        callerInformation: {
          $ref: '#/components/schemas/workspaceUser';
        };
        created: {
          description: 'The UTC DateTime when the workspace user authorization was created.';
          type: 'string';
        };
        createdByInformation: {
          $ref: '#/components/schemas/workspaceUser';
        };
        lastModified: {
          description: 'Utc date and time the comment was last updated (can only be done by creator.)';
          type: 'string';
        };
        lastModifiedByInformation: {
          $ref: '#/components/schemas/workspaceUser';
        };
        settings: {
          $ref: '#/components/schemas/workspaceSettings';
        };
        status: {
          description: 'The status of the workspace. Valid values are:\n\n- `active`\n- `closed`';
          type: 'string';
        };
        workspaceBaseUrl: {
          description: 'The relative URL for accessing the workspace.';
          type: 'string';
        };
        workspaceDescription: {
          description: 'Text describing the purpose of the workspace.';
          type: 'string';
        };
        workspaceId: {
          description: 'The ID of the workspace, always populated.';
          type: 'string';
        };
        workspaceName: {
          description: 'The name of the workspace.';
          type: 'string';
        };
        workspaceUri: {
          description: 'The relative URI for accessing the workspace.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-category': 'Workspaces';
      'x-ds-definition-name': 'workspace';
      'x-ds-order': '140';
      'x-ms-summary': 'A DocuSign workspace is a collaboration area for sharing files and data.';
    };
    accessCodeFormat: {
      description: 'Object specifying the format of the string provided to a recipient in order to access an envelope.';
      properties: {
        formatRequired: {
          description: 'Boolean specifying whether this format configuration is required.';
          type: 'string';
        };
        formatRequiredMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        letterRequired: {
          description: 'Boolean specifying whether alphabetical characters are required in the access code string.';
          type: 'string';
        };
        letterRequiredMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        minimumLength: {
          description: 'Minimum length of the access code string.';
          type: 'string';
        };
        minimumLengthMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        numberRequired: {
          description: 'Boolean specifying whether numerical characters (0-9) are required in the access code string.';
          type: 'string';
        };
        numberRequiredMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        specialCharacterRequired: {
          description: "Boolean specifying whether special characters are required in the access code string. The string cannot contain the special characters '<', '>', '&', or '#'.";
          type: 'string';
        };
        specialCharacterRequiredMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accessCodeFormat';
      'x-ms-summary': 'Object specifying the format of the string provided to a recipient in order to access an envelope.';
    };
    accountAddress: {
      description: 'Contains information about the address associated with the account.';
      properties: {
        address1: {
          description: 'The first line of the address. Maximum length: 100 characters.';
          type: 'string';
        };
        address2: {
          description: 'The second line of the address. Maximum length: 100 characters.';
          type: 'string';
        };
        city: {
          description: 'The city associated with the address. Maximum length: 40 characters.';
          type: 'string';
        };
        country: {
          description: 'The country associated with the address. Maximum length: 50 characters.';
          type: 'string';
        };
        email: {
          description: 'The email address associated with the account.';
          type: 'string';
        };
        fax: {
          description: 'The fax number associated with the account.';
          type: 'string';
        };
        firstName: {
          description: 'The first name of the user associated with the account. Maximum Length: 50 characters.';
          type: 'string';
        };
        lastName: {
          description: 'The last name of the user associated with the account.';
          type: 'string';
        };
        phone: {
          description: 'The phone number associated with the account.';
          type: 'string';
        };
        postalCode: {
          description: 'The postal code associated with the address. Maximum length: 20 characters.';
          type: 'string';
        };
        state: {
          description: 'The state or province associated with the address. Maximum length: 40 characters.';
          type: 'string';
        };
        supportedCountries: {
          description: 'An array of supported countries associated with the account.';
          items: {
            $ref: '#/components/schemas/country';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountAddress';
      'x-ms-summary': 'Contains information about the address associated with the account.';
    };
    accountBillingPlan: {
      description: 'Contains information about an account billing plan.';
      properties: {
        addOns: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/addOn';
          };
          type: 'array';
        };
        appStoreReceiptExpirationDate: {
          description: '';
          type: 'string';
        };
        appStoreReceiptPurchaseDate: {
          description: '';
          type: 'string';
        };
        canCancelRenewal: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        canUpgrade: {
          description: 'When **true,** specifies that you can upgrade the account through the API. For GET methods, you must set the `include_metadata` query parameter to **true** for this property to appear in the response.';
          type: 'string';
        };
        currencyCode: {
          description: 'Specifies the ISO currency code to use for the account.';
          type: 'string';
        };
        downgradePlanInformation: {
          $ref: '#/components/schemas/downgradePlanUpdateResponse';
        };
        enableSupport: {
          description: 'When **true,** customer support is provided as part of the account plan.';
          type: 'string';
        };
        includedSeats: {
          description: 'The number of seats (users) included in the plan.';
          type: 'string';
        };
        incrementalSeats: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        isDowngrade: {
          description: 'When **true,** the account has been downgraded from a premium account type. Otherwise **false.**';
          type: 'string';
        };
        notificationType: {
          description: '';
          type: 'string';
        };
        otherDiscountPercent: {
          description: ' Any other percentage discount for the plan. ';
          type: 'string';
        };
        paymentCycle: {
          description: 'The payment cycle associated with the plan. Valid values: \n\n- `Monthly`\n- `Annually` ';
          type: 'string';
        };
        paymentMethod: {
          description: ' The payment method used with the plan. Valid values: CreditCard, PurchaseOrder, Premium, or Freemium. ';
          type: 'string';
        };
        perSeatPrice: {
          description: 'The per-seat price associated with the plan.\n\nExample: `"456.0000"`';
          type: 'string';
        };
        planClassification: {
          description: 'Identifies the type of plan. Examples include:\n\n- `business`\n- `corporate`\n- `enterprise` \n- `free`';
          type: 'string';
        };
        planFeatureSets: {
          description: 'A complex type that sets the feature sets for the account. It contains the following information (all string content):\n\n* currencyFeatureSetPrices - Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, seatFee that are configured for this plan feature set.\n* envelopeFee - An incremental envelope cost for plans with envelope overages (when isEnabled=true).\n* featureSetId - A unique ID for the feature set.\n* fixedFee - A one-time fee associated with the plan (when isEnabled=true).\n* isActive - Specifies whether the feature set is actively set as part of the plan.\n* isEnabled - Specifies whether the feature set is actively enabled as part of the plan.\n* name - The name of the feature set.\n* seatFee - An incremental seat cost for seat-based plans (when isEnabled=true).\n';
          items: {
            $ref: '#/components/schemas/featureSet';
          };
          type: 'array';
        };
        planId: {
          description: "DocuSign's ID for the account plan.";
          type: 'string';
        };
        planName: {
          description: 'The name of the Billing Plan.';
          type: 'string';
        };
        planStartDate: {
          description: 'The date that the Account started using the current plan.';
          type: 'string';
        };
        productId: {
          description: 'The Product ID from the AppStore.';
          type: 'string';
        };
        renewalDate: {
          description: '';
          type: 'string';
        };
        renewalStatus: {
          description: 'The renewal status for the account. Valid values are:\n\n* `auto`: The account automatically renews.\n* `queued_for_close`: The account will be closed at the `billingPeriodEndDate`.\n* `queued_for_downgrade`: The account will be downgraded at the `billingPeriodEndDate`.\n\n**Note:** For GET methods, you must set the `include_metadata` query parameter to **true** for this property to appear in the response.';
          type: 'string';
        };
        seatDiscounts: {
          description: ' A complex type that contains any seat discount information. Valid values:\n \n - `BeginSeatCount` \n - `EndSeatCount`\n - `SeatDiscountPercent`\n \n';
          items: {
            $ref: '#/components/schemas/seatDiscount';
          };
          type: 'array';
        };
        subscriptionStartDate: {
          description: '';
          type: 'string';
        };
        supportIncidentFee: {
          description: 'The support incident fee charged for each support incident.\n\nExample: `"$0.00"`';
          type: 'string';
        };
        supportPlanFee: {
          description: 'The support plan fee charged for this plan.\n\nExample: `"$0.00"`';
          type: 'string';
        };
        taxExemptId: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountBillingPlan';
      'x-ms-summary': 'Contains information about an account billing plan.';
    };
    accountBillingPlanResponse: {
      description: 'Defines an account billing plan response object.';
      properties: {
        billingAddress: {
          $ref: '#/components/schemas/accountAddress';
        };
        billingAddressIsCreditCardAddress: {
          description: 'When **true,** the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.';
          type: 'string';
        };
        billingPlan: {
          $ref: '#/components/schemas/accountBillingPlan';
        };
        creditCardInformation: {
          $ref: '#/components/schemas/creditCardInformation';
        };
        directDebitProcessorInformation: {
          $ref: '#/components/schemas/directDebitProcessorInformation';
        };
        downgradePlanInformation: {
          $ref: '#/components/schemas/downgradePlanUpdateResponse';
        };
        downgradeRequestInformation: {
          $ref: '#/components/schemas/downgradeRequestInformation';
        };
        entityInformation: {
          $ref: '#/components/schemas/billingEntityInformationResponse';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        paymentProcessorInformation: {
          $ref: '#/components/schemas/paymentProcessorInformation';
        };
        referralInformation: {
          $ref: '#/components/schemas/referralInformation';
        };
        successorPlans: {
          description: 'A list of billing plans that the current billing plan can be rolled into.';
          items: {
            $ref: '#/components/schemas/billingPlan';
          };
          type: 'array';
        };
        taxExemptId: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountBillingPlanResponse';
      'x-ms-summary': 'Defines an account billing plan response object.';
    };
    accountIdentityInputOption: {
      description: '';
      properties: {
        isRequired: {
          description: '';
          type: 'boolean';
        };
        optionName: {
          description: '';
          type: 'string';
        };
        valueType: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountIdentityInputOption';
      'x-ms-summary': '';
    };
    accountIdentityVerificationResponse: {
      description: '';
      properties: {
        identityVerification: {
          description: "Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).";
          items: {
            $ref: '#/components/schemas/accountIdentityVerificationWorkflow';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountIdentityVerificationResponse';
      'x-ms-summary': '';
    };
    accountIdentityVerificationStep: {
      description: 'Information about a specific step in an Identity Verification workflow.';
      properties: {
        name: {
          description: 'The name of the Identity Verification workflow step.';
          type: 'string';
        };
        type: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountIdentityVerificationStep';
      'x-ms-summary': 'Information about a specific step in an Identity Verification workflow.';
    };
    accountIdentityVerificationWorkflow: {
      description: 'Specifies an Identity Verification workflow.';
      properties: {
        defaultDescription: {
          description: 'Text describing the purpose of the Identity Verification workflow.';
          type: 'string';
        };
        defaultName: {
          description: 'The name of the Identity Verification workflow.';
          type: 'string';
        };
        inputOptions: {
          description: '';
          items: {
            $ref: '#/components/schemas/accountIdentityInputOption';
          };
          type: 'array';
        };
        signatureProvider: {
          $ref: '#/components/schemas/accountSignatureProvider';
        };
        workflowId: {
          description: 'Workflow unique ID</br>This is the ID you must specify when setting ID Verification in an envelope using the `identityVerification`\n[core recipient parameter](/docs/esign-rest-api/reference/envelopes/enveloperecipients/#core-recipient-parameters)';
          type: 'string';
        };
        workflowLabel: {
          description: '';
          type: 'string';
        };
        workflowResourceKey: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountIdentityVerificationWorkflow';
      'x-ms-summary': 'Specifies an Identity Verification workflow.';
    };
    accountInformation: {
      description: 'Contains account Information.';
      properties: {
        accountIdGuid: {
          description: 'The GUID associated with the account ID.';
          type: 'string';
        };
        accountName: {
          description: 'The name of the current account.';
          type: 'string';
        };
        accountSettings: {
          $ref: '#/components/schemas/accountSettingsInformation';
        };
        allowTransactionRooms: {
          description: 'When **true,** the transaction rooms feature exposed through the Workspaces API is enabled.';
          type: 'string';
        };
        billingPeriodDaysRemaining: {
          description: 'Number of days remaining in the current billing period.';
          type: 'string';
        };
        billingPeriodEndDate: {
          description: 'The billing period end date in UTC timedate format.';
          type: 'string';
        };
        billingPeriodEnvelopesAllowed: {
          description: 'The number of envelopes that can be sent in the current billing period (can be unlimited).';
          type: 'string';
        };
        billingPeriodEnvelopesSent: {
          description: 'The number of envelopes that have been sent in the current billing period.';
          type: 'string';
        };
        billingPeriodStartDate: {
          description: 'The billing period start date in UTC timedate format.';
          type: 'string';
        };
        billingProfile: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        brands: {
          $ref: '#/components/schemas/AccountBrands';
        };
        canUpgrade: {
          description: 'When **true,** specifies that you can upgrade the account through the API. For GET methods, you must set the `include_metadata` query parameter to **true** for this property to appear in the response.';
          type: 'string';
        };
        connectPermission: {
          description: '';
          type: 'string';
        };
        createdDate: {
          description: 'The creation date of the account in UTC timedate format.';
          type: 'string';
        };
        currencyCode: {
          description: 'Specifies the ISO currency code for the account.';
          type: 'string';
        };
        currentPlanId: {
          description: 'ID of the plan used to create this account.';
          type: 'string';
        };
        displayApplianceStartUrl: {
          description: '';
          type: 'string';
        };
        displayApplianceUrl: {
          description: '';
          type: 'string';
        };
        distributorCode: {
          description: 'The code that identifies the billing plan groups and plans for the new account.';
          type: 'string';
        };
        docuSignLandingUrl: {
          description: 'URL of the landing page used to create the account.';
          type: 'string';
        };
        dssValues: {
          additionalProperties: {
            type: 'string';
          };
          description: '';
          type: 'object';
        };
        envelopeSendingBlocked: {
          description: 'When **true,** the ability to send envelopes is blocked. When **false,** envelopes can be sent.';
          type: 'string';
        };
        envelopeUnitPrice: {
          description: "The price of sending an envelope, represented in the account's local currency.";
          type: 'string';
        };
        externalAccountId: {
          description: "The Account ID displayed on the user's Account page.";
          type: 'string';
        };
        forgottenPasswordQuestionsCount: {
          description: ' A complex element that contains up to four Question/Answer pairs for forgotten password information for a user.';
          type: 'string';
        };
        isDowngrade: {
          description: 'When **true,** the account has been downgraded from a premium account type. Otherwise **false.**';
          type: 'string';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        planClassification: {
          description: 'Identifies the type of plan. Examples include:\n\n- `business`\n- `corporate`\n- `enterprise` \n- `free`';
          type: 'string';
        };
        planEndDate: {
          description: 'The date that the current plan will end.';
          type: 'string';
        };
        planName: {
          description: 'The name of the Billing Plan.';
          type: 'string';
        };
        planStartDate: {
          description: 'The date that the Account started using the current plan.';
          type: 'string';
        };
        recipientDomains: {
          description: '';
          items: {
            $ref: '#/components/schemas/recipientDomain';
          };
          type: 'array';
        };
        seatsAllowed: {
          description: 'The number of active users the account can have at one time.';
          type: 'string';
        };
        seatsInUse: {
          description: 'The number of users currently active on the account.';
          type: 'string';
        };
        status21CFRPart11: {
          description: 'The status of the account content per (Title 21 CFR Part 11)[https://www.fda.gov/regulatory-information/search-fda-guidance-documents/part-11-electronic-records-electronic-signatures-scope-and-application]. This regulation defines the criteria under which electronic records and electronic signatures are considered trustworthy.';
          type: 'string';
        };
        suspensionDate: {
          description: 'The date on which the account was suspended.';
          type: 'string';
        };
        suspensionStatus: {
          description: 'Indicates whether the account is currently suspended.';
          type: 'string';
        };
        useDisplayAppliance: {
          description: '';
          type: 'boolean';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountInformation';
      'x-ms-summary': 'Contains account Information.';
    };
    accountMinimumPasswordLength: {
      description: '';
      properties: {
        maximumLength: {
          description: 'The maximum number of entry characters supported by the custom tab.';
          type: 'string';
        };
        minimumLength: {
          description: 'Minimum length of the access code string.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountMinimumPasswordLength';
      'x-ms-summary': '';
    };
    accountNotification: {
      description: 'A complex element that specifies notifications (expirations and reminders) for the envelope.';
      properties: {
        expirations: {
          $ref: '#/components/schemas/expirations';
        };
        reminders: {
          $ref: '#/components/schemas/reminders';
        };
        userOverrideEnabled: {
          description: 'When **true,** the user can override envelope expirations.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountNotification';
      'x-ms-summary': 'A complex element that specifies notifications (expirations and reminders) for the envelope.';
    };
    accountPasswordExpirePasswordDays: {
      description: '';
      properties: {
        maximumDays: {
          description: '';
          type: 'string';
        };
        minimumDays: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordExpirePasswordDays';
      'x-ms-summary': '';
    };
    accountPasswordLockoutDurationMinutes: {
      description: '';
      properties: {
        maximumMinutes: {
          description: '';
          type: 'string';
        };
        minimumMinutes: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordLockoutDurationMinutes';
      'x-ms-summary': '';
    };
    accountPasswordLockoutDurationType: {
      description: '';
      properties: {
        options: {
          description: 'An array of option strings supported by this setting.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordLockoutDurationType';
      'x-ms-summary': '';
    };
    accountPasswordMinimumPasswordAgeDays: {
      description: '';
      properties: {
        maximumAge: {
          description: '';
          type: 'string';
        };
        minimumAge: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordMinimumPasswordAgeDays';
      'x-ms-summary': '';
    };
    accountPasswordQuestionsRequired: {
      description: "Information about the number of password questions required (0 to 4) to confirm a user's identity when a user needs to reset their password.";
      properties: {
        maximumQuestions: {
          description: 'The maximum number of password reset questions allowed for the account. This number must be between `0` and `4`, and equal to or greater than `minimumQuestions`.';
          type: 'string';
        };
        minimumQuestions: {
          description: 'The minimum number of password reset questions allowed for the account. This number must be between `0` and `4`, and equal to or less than `maximumQuestions`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordQuestionsRequired';
      'x-ms-summary': "Information about the number of password questions required (0 to 4) to confirm a user's identity when a user needs to reset their password.";
    };
    accountPasswordRules: {
      description: '';
      properties: {
        expirePassword: {
          description: 'When **true,** passwords expire. The default value is `false`.';
          type: 'string';
        };
        expirePasswordDays: {
          description: 'The number of days before passwords expire. To use this property, the `expirePassword` property must be set to **true.**';
          type: 'string';
        };
        expirePasswordDaysMetadata: {
          $ref: '#/components/schemas/accountPasswordExpirePasswordDays';
        };
        lockoutDurationMinutes: {
          description: 'The number of minutes a user is locked out of the system after three failed login attempts. The default value is `2`.';
          type: 'string';
        };
        lockoutDurationMinutesMetadata: {
          $ref: '#/components/schemas/accountPasswordLockoutDurationMinutes';
        };
        lockoutDurationType: {
          description: 'The interval associated with the user lockout after a failed login attempt.\n\nPossible values are:\n\n- `minutes` (default)\n- `hours`\n- `days`';
          type: 'string';
        };
        lockoutDurationTypeMetadata: {
          $ref: '#/components/schemas/accountPasswordLockoutDurationType';
        };
        minimumPasswordAgeDays: {
          description: 'The minimum number of days after a password is set before it can be changed. This value can be `0` or more days. The default value is `0`.';
          type: 'string';
        };
        minimumPasswordAgeDaysMetadata: {
          $ref: '#/components/schemas/accountPasswordMinimumPasswordAgeDays';
        };
        minimumPasswordLength: {
          description: 'The minimum number of characters in the password. This value must be a number between `6` and `15`. The default value is `6`.';
          type: 'string';
        };
        minimumPasswordLengthMetadata: {
          $ref: '#/components/schemas/accountMinimumPasswordLength';
        };
        passwordIncludeDigit: {
          description: 'When **true,** passwords must include a digit. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeDigitOrSpecialCharacter: {
          description: 'When **true,** passwords must include either a digit or a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeLowerCase: {
          description: 'When **true,** passwords must include a lowercase letter. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeSpecialCharacter: {
          description: 'When **true,** passwords must include a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeUpperCase: {
          description: 'When **true,** passwords must include an uppercase letter. The default value is `false`.';
          type: 'string';
        };
        passwordStrengthType: {
          description: 'The type of password strength. Possible values are:\n\n- `basic`: The minimum password length is 6 characters with no other password requirements.\n- `medium`: The minimum password length is 7 characters. Passwords must also have one uppercase letter, one lowercase letter, and one number or special character.\n- `strong`: The minimum password length is 9 characters. Passwords must also have one uppercase letter, one lowercase letter, one number, and one special character.\n- `custom`: This option enables you to customize password requirements, including the following properties:\n\n   - `minimumPasswordLength`\n   - `minimumPasswordAgeDays`\n   - `passwordIncludeDigit`\n   - `passwordIncludeDigitOrSpecialCharacter`\n   - `passwordIncludeLowerCase`\n   - `passwordIncludeSpecialCharacter`\n   - `passwordIncludeUpperCase`\n   - `questionsRequired`';
          type: 'string';
        };
        passwordStrengthTypeMetadata: {
          $ref: '#/components/schemas/accountPasswordStrengthType';
        };
        questionsRequired: {
          description: 'The number of security questions required to confirm the user’s identity before the user can reset their password. The default value is `0`.';
          type: 'string';
        };
        questionsRequiredMetadata: {
          $ref: '#/components/schemas/accountPasswordQuestionsRequired';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordRules';
      'x-ms-summary': '';
    };
    accountPasswordStrengthType: {
      description: '';
      properties: {
        options: {
          description: 'An array of option strings supported by this setting.';
          items: {
            $ref: '#/components/schemas/accountPasswordStrengthTypeOption';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordStrengthType';
      'x-ms-summary': '';
    };
    accountPasswordStrengthTypeOption: {
      description: '';
      properties: {
        minimumLength: {
          description: 'Minimum length of the access code string.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        passwordIncludeDigit: {
          description: 'When **true,** passwords must include a digit. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeDigitOrSpecialCharacter: {
          description: 'When **true,** passwords must include either a digit or a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeLowerCase: {
          description: 'When **true,** passwords must include a lowercase letter. The default value is `false`.';
          type: 'string';
        };
        passwordIncludeSpecialCharacter: {
          description: 'When **true,** passwords must include a special character. The default value is `false`.\n\n**Note:** Passwords cannot include angle brackets (`<` `>`) or spaces.';
          type: 'string';
        };
        passwordIncludeUpperCase: {
          description: 'When **true,** passwords must include an uppercase letter. The default value is `false`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountPasswordStrengthTypeOption';
      'x-ms-summary': '';
    };
    accountRoleSettings: {
      description: 'This object defines account permissions for users who are associated with the account permission profile. ';
      properties: {
        allowAccountManagement: {
          description: 'When **true,** users have full administrative access to the account.';
          type: 'string';
        };
        allowAccountManagementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowApiAccess: {
          description: 'When **true,** users can manage documents by using the API.';
          type: 'string';
        };
        allowApiAccessMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowApiAccessToAccount: {
          description: 'When **true,** users can access the account by using the eSignature API.';
          type: 'string';
        };
        allowApiAccessToAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowApiSendingOnBehalfOfOthers: {
          description: 'When **true,** users can send envelopes on behalf of others.';
          type: 'string';
        };
        allowApiSendingOnBehalfOfOthersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowApiSequentialSigning: {
          description: 'When **true,** users may specify sequential signing recipients when they send documents by using the API.';
          type: 'string';
        };
        allowApiSequentialSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAutoTagging: {
          description: ' When **true,** auto-tagging is enabled for the account.';
          type: 'string';
        };
        allowAutoTaggingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowBulkSending: {
          description: 'When **true,** bulk sending is enabled for users.';
          type: 'string';
        };
        allowBulkSendingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDocuSignDesktopClient: {
          description: 'When **true,** the DocuSign Desktop Client is enabled for users.\n';
          type: 'string';
        };
        allowDocuSignDesktopClientMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowESealRecipients: {
          description: 'When **true,** users can add electronic seal ([eSeal](https://support.docusign.com/en/guides/ndse-user-guide-apply-electronic-seals)) recipients.';
          type: 'string';
        };
        allowESealRecipientsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopeSending: {
          description: 'When **true,** users can send envelopes.';
          type: 'string';
        };
        allowEnvelopeSendingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPowerFormsAdminToAccessAllPowerFormEnvelopes: {
          description: 'When **true,** PowerForm Administrators can access all of the PowerForm envelopes associated with the account.';
          type: 'string';
        };
        allowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSendersToSetRecipientEmailLanguage: {
          description: 'When **true,** senders can set the language of the email that is sent to recipients.';
          type: 'string';
        };
        allowSendersToSetRecipientEmailLanguageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSignerAttachments: {
          description: 'When **true,** users can add requests for attachments from signers.';
          type: 'string';
        };
        allowSignerAttachmentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSupplementalDocuments: {
          description: 'When **true,** senders can include supplemental documents.';
          type: 'string';
        };
        allowSupplementalDocumentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowTaggingInSendAndCorrect: {
          description: 'When **true,** the tagger palette is visible during the sending and correct flows and users can add tabs to documents.';
          type: 'string';
        };
        allowTaggingInSendAndCorrectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowVaulting: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        allowVaultingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowWetSigningOverride: {
          description: 'When **true,** users can override the default account setting that controls whether recipients can sign documents on paper. The option to overrride this setting occurs during the sending process on a per-envelope basis.';
          type: 'string';
        };
        allowWetSigningOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowedAddressBookAccess: {
          description: "Specifies the level of access that users have to the account's address book. Valid values are:\n\n- `personal`\n- `useShared`\n- `usePersonalAndShared`\n- `personalAndShared`\n";
          type: 'string';
        };
        allowedAddressBookAccessMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowedClickwrapsAccess: {
          description: '';
          type: 'string';
        };
        allowedClickwrapsAccessMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowedTemplateAccess: {
          description: 'Specifies the level of access that users have to account templates. Valid values are: \n\n- `none` \n- `use`\n- `create`\n- `share`';
          type: 'string';
        };
        allowedTemplateAccessMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowedToBeEnvelopeTransferRecipient: {
          description: 'When **true,** users can be recipients of envelopes transferred to them by administrators of other accounts. ';
          type: 'string';
        };
        allowedToBeEnvelopeTransferRecipientMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        canCreateWorkspaces: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        canCreateWorkspacesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        canSendEnvelopesViaSMS: {
          description: '';
          type: 'string';
        };
        canSendEnvelopesViaSMSMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableDocumentUpload: {
          description: 'When **true,** users cannot upload documents.';
          type: 'string';
        };
        disableDocumentUploadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableOtherActions: {
          description: 'When **true,** users can access the **Other Actions** menu.';
          type: 'string';
        };
        disableOtherActionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableApiRequestLogging: {
          description: 'When **true,** API request logging is enabled.\n\n**Note:** Logging limits apply.';
          type: 'string';
        };
        enableApiRequestLoggingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableKeyTermsSuggestionsByDocumentType: {
          description: '';
          type: 'string';
        };
        enableKeyTermsSuggestionsByDocumentTypeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableRecipientViewingNotifications: {
          description: 'When **true,** senders are notified when recipients view the documents that they send.';
          type: 'string';
        };
        enableRecipientViewingNotificationsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSequentialSigningInterface: {
          description: 'When **true,** the sequential signing user interface is enabled.';
          type: 'string';
        };
        enableSequentialSigningInterfaceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableTransactionPointIntegration: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        enableTransactionPointIntegrationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        powerFormRole: {
          description: 'The PowerForms rights associated with the account permission profile. Valid values are:\n\n- `none` \n- `user` \n- `admin`\n';
          type: 'string';
        };
        powerFormRoleMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        receiveCompletedSelfSignedDocumentsAsEmailLinks: {
          description: 'When **true,** senders receive emails about completed, self-signed documents that contain links to the completed documents instead of PDF attachments.';
          type: 'string';
        };
        receiveCompletedSelfSignedDocumentsAsEmailLinksMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signingUiVersionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustAccept: {
          description: 'When **true,** senders can require recipients to accept supplemental documents.';
          type: 'string';
        };
        supplementalDocumentsMustAcceptMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustRead: {
          description: 'When **true,** senders can require recipients to read supplemental documents.';
          type: 'string';
        };
        supplementalDocumentsMustReadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustView: {
          description: 'When **true,** users can require recipients to view supplemental documents.';
          type: 'string';
        };
        supplementalDocumentsMustViewMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useNewDocuSignExperienceInterface: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        useNewDocuSignExperienceInterfaceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useNewSendingInterface: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        useNewSendingInterfaceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        vaultingMode: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        vaultingModeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        webForms: {
          description: '';
          type: 'string';
        };
        webFormsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountRoleSettings';
      'x-ms-summary': 'This object defines account permissions for users who are associated with the account permission profile. ';
    };
    accountSeals: {
      description: '';
      properties: {
        seals: {
          description: 'A list of electronic seals to apply to documents.';
          items: {
            $ref: '#/components/schemas/sealIdentifier';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSeals';
      'x-ms-summary': '';
    };
    accountSettingsInformation: {
      description: 'Contains account settings information. Used in requests to set property values. Used in responses to report property values.';
      properties: {
        EnvelopeLimitsTotalDocumentSizeAllowedInMB: {
          description: '';
          type: 'string';
        };
        EnvelopeLimitsTotalDocumentSizeAllowedInMBEnabled: {
          description: '';
          type: 'string';
        };
        EnvelopeLimitsTotalDocumentSizeAllowedInMBEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        EnvelopeLimitsTotalDocumentSizeAllowedInMBMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        accessCodeFormat: {
          $ref: '#/components/schemas/accessCodeFormat';
        };
        accountDateTimeFormat: {
          description: 'UTC date/time format for the account.';
          type: 'string';
        };
        accountDateTimeFormatMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        accountDefaultLanguage: {
          description: '';
          type: 'string';
        };
        accountDefaultLanguageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        accountName: {
          description: 'The name on the account.';
          type: 'string';
        };
        accountNameMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        accountNotification: {
          $ref: '#/components/schemas/accountNotification';
        };
        accountUISettings: {
          $ref: '#/components/schemas/accountUISettings';
        };
        adoptSigConfig: {
          description: 'When **true,** [Signature Adoption Configuration](https://support.docusign.com/en/guides/ndse-admin-guide-signature-adopt-config) is enabled. \n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        adoptSigConfigMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        advancedCorrect: {
          description: 'When **true,** the Advanced Correction feature is enabled for this account.';
          type: 'string';
        };
        advancedCorrectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAccessCodeFormat: {
          description: 'When **true,** the configured [Access Code Format](/docs/esign-rest-api/reference/accounts/accounts/get/#accessCodeFormat) page is enabled for account administrators.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowAccessCodeFormatMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAccountManagementGranular: {
          description: 'When **true,** the account can be managed on a per-user basis.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowAccountManagementGranularMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAccountMemberNameChange: {
          description: 'Boolean that specifies whether member names can be changed in the account.';
          type: 'string';
        };
        allowAccountMemberNameChangeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAdvancedRecipientRoutingConditional: {
          description: "When **true,** [Conditional Routing](https://support.docusign.com/en/guides/ndse-user-guide-conditional-recipients) is enabled for the account as part of DocuSign's Advanced Recipient Routing feature.";
          type: 'string';
        };
        allowAdvancedRecipientRoutingConditionalMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAgentNameEmailEdit: {
          description: '  When **true,** an agent recipient can change the email addresses of recipients later in the signing order.\n';
          type: 'string';
        };
        allowAgentNameEmailEditMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAgreementActions: {
          description: '';
          type: 'string';
        };
        allowAgreementActionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAgreementOrchestrationWorkflows: {
          description: '';
          type: 'string';
        };
        allowAgreementOrchestrationWorkflowsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAutoNavSettings: {
          description: '  When **true,** auto-navigation can be enabled for this account.\n';
          type: 'string';
        };
        allowAutoNavSettingsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowAutoTagging: {
          description: ' When **true,** auto-tagging is enabled for the account.';
          type: 'string';
        };
        allowAutoTaggingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowBulkSend: {
          description: 'When **true,** bulk send functionality is enabled for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowBulkSendMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowCDWithdraw: {
          description: 'When **true,** indicates that the customer can withdraw their consent to the consumer disclosure when they decline to sign documents. If these recipients sign documents sent to them from your account in the future, they will be required to agree to the terms in the disclosure. The default value is **false.**\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowCDWithdrawMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowConnectHttpListenerConfigs: {
          description: 'Boolean that specifies whether a Connect configuration can use HTTP listeners.';
          type: 'string';
        };
        allowConnectOAuthUI: {
          description: '';
          type: 'string';
        };
        allowConnectSendFinishLater: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        allowConnectSendFinishLaterMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowConnectUnifiedPayloadUI: {
          description: '';
          type: 'string';
        };
        allowConsumerDisclosureOverride: {
          description: 'When **true,**\nthe account has the ability to change the\n[Consumer Disclosure](https://support.docusign.com/en/guides/ndse-admin-guide-legal-disclosure)\nsetting.\n';
          type: 'string';
        };
        allowConsumerDisclosureOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDataDownload: {
          description: 'When **true,** senders can download form data from the envelopes that they send.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowDataDownloadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDelayedRouting: {
          description: '"true" if the account has permission to use the scheduled sending feature to send envelopes at a specified datetime in the future, "false" otherwise.';
          type: 'string';
        };
        allowDelayedRoutingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDelegatedSigning: {
          description: '';
          type: 'string';
        };
        allowDelegatedSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDocGenDocuments: {
          description: '';
          type: 'string';
        };
        allowDocGenDocumentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDocumentDisclosures: {
          description: 'Boolean that specifies whether disclosure documents can be included in envelopes.';
          type: 'string';
        };
        allowDocumentDisclosuresMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDocumentVisibility: {
          description: 'When **true,** the [Document Visibility](https://support.docusign.com/guides/ndse-user-guide-document-visibility) feature is enabled for the account.\n';
          type: 'string';
        };
        allowDocumentVisibilityMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowDocumentsOnSignedEnvelopes: {
          description: "Boolean that specifies whether notifications can include the envelope's signed document.";
          type: 'string';
        };
        allowDocumentsOnSignedEnvelopesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEHankoStamps: {
          description: 'When **true,**\n[eHanko stamps](https://support.docusign.com/en/guides/ndse-user-guide-manage-your-stamps)\nare enabled.\n';
          type: 'string';
        };
        allowEHankoStampsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowENoteEOriginal: {
          description: 'Specifies whether eNote eOriginal integration is enabled.\n';
          type: 'string';
        };
        allowENoteEOriginalMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEditingEnvelopesOnBehalfOfOthers: {
          description: '';
          type: 'string';
        };
        allowEditingEnvelopesOnBehalfOfOthersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopeCorrect: {
          description: 'When **true,** the envelope correction feature is enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowEnvelopeCorrectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopeCustodyTransfer: {
          description: 'Specifies whether the account is able to\nmanage rules that [transfer ownership](https://support.docusign.com/en/guides/ndse-admin-guide-custody-transfer)\nof envelopes within the same account.\n\n\n\n';
          type: 'string';
        };
        allowEnvelopeCustodyTransferMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopeCustomFields: {
          description: 'Specifies whether\n[envelope custom fields](https://support.docusign.com/en/guides/ndse-user-guide-manage-custom-fields)\nare enabled.\n';
          type: 'string';
        };
        allowEnvelopeCustomFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopePublishReporting: {
          description: 'When **true,** envelope publishing reporting is enabled.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowEnvelopePublishReportingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowEnvelopeReporting: {
          description: 'Specifies whether the account has access to reports.\n';
          type: 'string';
        };
        allowEnvelopeReportingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowExpressSignerCertificate: {
          description: 'When **true,** signers are required to use Express Digital Signatures.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowExpressSignerCertificateMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowExpression: {
          description: 'If the account plan does not include calculated fields, this setting allows an account to use them.\n\n';
          type: 'string';
        };
        allowExpressionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowExtendedSendingResourceFile: {
          description: 'Boolean that specifies whether resource files can be used for extended sending.';
          type: 'string';
        };
        allowExtendedSendingResourceFileMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowExternalLinkedAccounts: {
          description: '';
          type: 'string';
        };
        allowExternalLinkedAccountsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowExternalSignaturePad: {
          description: 'When **true,** the account can\nconfigure and use signature pads for their recipients.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowExternalSignaturePadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowIDVForEUQualifiedSignatures: {
          description: '';
          type: 'string';
        };
        allowIDVForEUQualifiedSignaturesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowIDVLevel1: {
          description: 'When **true,** IDV Level 1 is allowed. The default value is **false.**';
          type: 'string';
        };
        allowIDVLevel1Metadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowIDVLevel2: {
          description: '';
          type: 'string';
        };
        allowIDVLevel2Metadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowIDVLevel3: {
          description: '';
          type: 'string';
        };
        allowIDVLevel3Metadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowIDVPlatform: {
          description: '';
          type: 'string';
        };
        allowIDVPlatformMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowInPerson: {
          description: 'When **true,** the account administrator can enable in-person signing.\n\n**Note:** Only SysAdmin users can change this setting.\n\n';
          type: 'string';
        };
        allowInPersonElectronicNotary: {
          description: 'Account-level flag that determines the ability to perform In-Person Electronic Notary (IPEN) actions.\n';
          type: 'string';
        };
        allowInPersonElectronicNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowInPersonMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowManagedStamps: {
          description: 'When **true,** [Managed Stamps](https://support.docusign.com/en/guides/ndse-admin-guide-managed-stamps) are enabled.';
          type: 'string';
        };
        allowManagedStampsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowManagingEnvelopesOnBehalfOfOthers: {
          description: '';
          type: 'string';
        };
        allowManagingEnvelopesOnBehalfOfOthersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowMarkup: {
          description: 'When **true,** the Document Markup feature is enabled.\n\n**Note:**  To use this feature, Document Markup must be enabled at both the account and envelope levels. Only Admin users can change this setting at the account level.\n';
          type: 'string';
        };
        allowMarkupMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowMemberTimeZone: {
          description: 'When **true,** account users can set their own\n[time zone settings](https://support.docusign.com/en/articles/How-do-I-modify-time-zone-settings-for-my-account).\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowMemberTimeZoneMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowMergeFields: {
          description: 'When **true,** the account can use\n[merge fields](https://support.docusign.com/en/guides/dfs-user-guide-merge-fields-user)\nwith DocuSign for Salesforce.\n';
          type: 'string';
        };
        allowMergeFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowMultipleBrandProfiles: {
          description: 'Specifies whether the account supports multiple brands.\n';
          type: 'string';
        };
        allowMultipleBrandProfilesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowMultipleSignerAttachments: {
          description: 'When **true,** recipients can\nupload multiple signer attachments with a single attachment.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowMultipleSignerAttachmentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowNonUSPhoneAuth: {
          description: 'Specifies whether users can use\ninternational numbers\nfor phone authentication.\n';
          type: 'string';
        };
        allowNonUSPhoneAuthMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOcrOfEnvelopeDocuments: {
          description: '';
          type: 'string';
        };
        allowOcrOfEnvelopeDocumentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOfflineSigning: {
          description: 'When **true,**\n[offline signing](https://support.docusign.com/articles/Offline-access-with-the-DocuSign-Mobile-App-for-iOS-iPad-iPhone-iPod-Touch)\nis enabled for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowOfflineSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOpenTrustSignerCertificate: {
          description: 'When **true,** senders can use OpenTrust signer certificates.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowOpenTrustSignerCertificateMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationDocusignMonitor: {
          description: '';
          type: 'string';
        };
        allowOrganizationDocusignMonitorMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationDomainUserManagement: {
          description: '';
          type: 'string';
        };
        allowOrganizationDomainUserManagementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationSsoManagement: {
          description: '';
          type: 'string';
        };
        allowOrganizationSsoManagementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationToUseInPersonElectronicNotary: {
          description: 'Organization-level flag that determines the ability to perform In-Person Electronic Notary (IPEN) actions.\n';
          type: 'string';
        };
        allowOrganizationToUseInPersonElectronicNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationToUseRemoteNotary: {
          description: '';
          type: 'string';
        };
        allowOrganizationToUseRemoteNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizationToUseThirdPartyElectronicNotary: {
          description: 'Org level flag that determines the availability to perform Third Party Notary (3PN) actions.';
          type: 'string';
        };
        allowOrganizationToUseThirdPartyElectronicNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowOrganizations: {
          description: 'Boolean that specifies whether [DocuSign Admin](/docs/admin-api/) is enabled for the account.';
          type: 'string';
        };
        allowOrganizationsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowParticipantRecipientType: {
          description: '';
          type: 'string';
        };
        allowParticipantRecipientTypeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPaymentProcessing: {
          description: 'When **true,** payment processing is enabled for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowPaymentProcessingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPerformanceAnalytics: {
          description: '';
          type: 'string';
        };
        allowPerformanceAnalyticsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPhoneAuthOverride: {
          description: 'Boolean that specifies whether users can override phone authentication.';
          type: 'string';
        };
        allowPhoneAuthOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPhoneAuthentication: {
          description: 'Boolean that specifies whether phone authentication is enabled for the account.';
          type: 'string';
        };
        allowPhoneAuthenticationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowPrivateSigningGroups: {
          description: 'Reserved for DocuSign. This property returns the value **false** when listing account settings. This property is read-only.';
          type: 'string';
        };
        allowPrivateSigningGroupsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowRecipientConnect: {
          description: '';
          type: 'string';
        };
        allowRecipientConnectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowReminders: {
          description: 'When **true,**\nan account administrator can to turn on reminders\nand expiration defaults for the account.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowRemindersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowRemoteNotary: {
          description: '';
          type: 'string';
        };
        allowRemoteNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowResourceFileBranding: {
          description: 'When **true,**\nresource files can be uploaded in branding.\n';
          type: 'string';
        };
        allowResourceFileBrandingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSMSDelivery: {
          description: '';
          type: 'string';
        };
        allowSMSDeliveryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSafeBioPharmaSignerCertificate: {
          description: 'When **true,**\naccount administrators can\nspecify that signers are\nrequired to use SAFE-BioPharma digital signatures.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowSafeBioPharmaSignerCertificateMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowScheduledSending: {
          description: '"true" if the account has permission to use the scheduled sending feature to send envelopes at a specified datetime in the future, "false" otherwise.';
          type: 'string';
        };
        allowScheduledSendingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSecurityAppliance: {
          description: 'Boolean that specifies whether a DocuSign Signature Appliance can be used with the account.';
          type: 'string';
        };
        allowSecurityApplianceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSendToCertifiedDelivery: {
          description: 'When **true,**\nthe account admin can enable the\nSend to Certified Delivery\nfeature on the account.\n';
          type: 'string';
        };
        allowSendToCertifiedDeliveryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSendToIntermediary: {
          description: 'When **true,**\nthe account admin can enable the Send to Intermediary\nfeature on the account.\n';
          type: 'string';
        };
        allowSendToIntermediaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSendingEnvelopesOnBehalfOfOthers: {
          description: '';
          type: 'string';
        };
        allowSendingEnvelopesOnBehalfOfOthersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowServerTemplates: {
          description: 'When **true,**\nthe account can use templates.\n';
          type: 'string';
        };
        allowServerTemplatesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSetEmbeddedRecipientStartURL: {
          description: '';
          type: 'string';
        };
        allowSetEmbeddedRecipientStartURLMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSharedTabs: {
          description: 'When **true,**\nshared tabs are enabled for the account.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowSharedTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSignDocumentFromHomePage: {
          description: 'When **true,** recipients can sign documents from the home page.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowSignDocumentFromHomePageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSignNow: {
          description: 'When **true,**\nthe account administrator can enable\nthe Sign Now feature.\n';
          type: 'string';
        };
        allowSignNowMetadata: {
          description: 'Metadata that indicates whether the `allowSignNow` property is editable.\n';
          type: 'string';
        };
        allowSignatureStamps: {
          description: 'When **true,** Signature Stamps are enabled.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowSignatureStampsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSignerReassign: {
          description: 'When **true,** the recipient of an envelope sent from this account can reassign it to another person.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        allowSignerReassignMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSignerReassignOverride: {
          description: 'When **true,** an account administrator can override the ability of an envelope recipient to reassign it to another person.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowSignerReassignOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSigningExtensions: {
          description: 'Boolean that specifies whether Signing and App Extensions are allowed.';
          type: 'string';
        };
        allowSigningExtensionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSigningGroups: {
          description: 'When **true,** the account allows signing groups. This setting is only shown in responses that list account settings. This property is read-only.';
          type: 'string';
        };
        allowSigningGroupsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSigningInsights: {
          description: '';
          type: 'string';
        };
        allowSigningInsightsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSigningRadioDeselect: {
          description: 'Boolean that specifies whether the account supports radio buttons on tabs [Radio CustomTabType](/docs/esign-soap-api/reference/sending-group/tab/).';
          type: 'string';
        };
        allowSigningRadioDeselectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSocialIdLogin: {
          description: 'Deprecated.';
          type: 'string';
        };
        allowSocialIdLoginMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowSupplementalDocuments: {
          description: 'When **true,** this user can include supplemental documents.';
          type: 'string';
        };
        allowSupplementalDocumentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowThirdPartyElectronicNotary: {
          description: 'Account level flag that determines the availability to perform Third Party Notary (3PN) actions.';
          type: 'string';
        };
        allowThirdPartyElectronicNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowTransactionsWorkspace: {
          description: '';
          type: 'string';
        };
        allowTransactionsWorkspaceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowUsersToAccessDirectory: {
          description: '';
          type: 'string';
        };
        allowUsersToAccessDirectoryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowValueInsights: {
          description: '';
          type: 'string';
        };
        allowValueInsightsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowWebForms: {
          description: '';
          type: 'string';
        };
        allowWebFormsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        allowWhatsAppDelivery: {
          description: '';
          type: 'string';
        };
        allowWhatsAppDeliveryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        anchorPopulationScope: {
          description: 'This property determines how template anchor tabs are applied.\n\nValid values are:\n\n- `document`: Anchor tabs are applied only to the document that you specify. \n- `envelope`: Anchor tabs are applied to all of the documents in the envelope associated with the template.\n\n**Note:** When you are using the `anchorPopulationScope` property with a Composite Template, the value `document` is supported only with a single server template and a single inline template.\n\n';
          type: 'string';
        };
        anchorPopulationScopeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        anchorTagVersionedPlacementEnabled: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        anchorTagVersionedPlacementMetadataEnabled: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        attachCompletedEnvelope: {
          description: 'When **true,** envelope documents are included as a PDF file attachment to "signing completed" emails.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        attachCompletedEnvelopeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        authenticationCheck: {
          description: 'Sets when authentication checks are applied for recipient envelope access. This setting only applies to the following ID checks: \n\n- Phone Authentication\n- SMS Authentication\n- Knowledge-Based ID\n\nThis setting takes one of the following options: \n\n- `initial_access`: The authentication check always applies the first time a recipient accesses the documents. Recipients are not asked to authenticate again when they access the documents from the same browser on the same device. If the recipient attempts to access the documents from a different browser or a different device, the recipient must pass authentication again. Once authenticated, that recipient is not challenged again on the new device or browser. The ability for a recipient to skip authentication for documents is limited to documents sent from the same sending account.\n- `each_access`: Authentication checks apply every time a recipient attempts to access the envelope. However, you can configure the Authentication Expiration setting to allow recipients to skip authentication when they have recently passed authentication by setting a variable time frame.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        authenticationCheckMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        autoNavRule: {
          description: 'Specifies how auto-navigation works.\nValid values are:\n\n- `off`\n- `required_fields`\n- `required_and_blank_fields`\n- `all_fields`\n- `page_then_required_fields`\n- `page_then_required_and_blank_fields`\n- `page_then_all_fields`\n';
          type: 'string';
        };
        autoNavRuleMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        autoProvisionSignerAccount: {
          description: 'Boolean that specifies whether to automatically provision a user membership in the account for accountless recipients. (Also known as Just-in-Time provisioning.)';
          type: 'string';
        };
        autoProvisionSignerAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        bccEmailArchive: {
          description: 'Boolean that specifies whether BCC for Email Archive is enabled for the account. BCC for Email Archive allows you to set up an archive email address so that a BCC copy of an envelope is sent only to that address.';
          type: 'string';
        };
        bccEmailArchiveMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        betaSwitchConfiguration: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        betaSwitchConfigurationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        billingAddress: {
          $ref: '#/components/schemas/addressInformation';
        };
        billingAddressMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        bulkSend: {
          description: 'When **true,** this user can use the bulk send feature for the account.';
          type: 'string';
        };
        bulkSendActionResendLimit: {
          description: '';
          type: 'string';
        };
        bulkSendMaxCopiesInBatch: {
          description: '';
          type: 'string';
        };
        bulkSendMaxUnprocessedEnvelopesCount: {
          description: '';
          type: 'string';
        };
        bulkSendMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        canSelfBrandSend: {
          description: 'When **true,** account administrators can self-brand their sending console through the DocuSign console.';
          type: 'string';
        };
        canSelfBrandSendMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        canSelfBrandSign: {
          description: 'When **true,** account administrators can self-brand their signing console through the DocuSign console.';
          type: 'string';
        };
        canSelfBrandSignMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        canUseSalesforceOAuth: {
          description: '';
          type: 'string';
        };
        canUseSalesforceOAuthMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        captureVoiceRecording: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        captureVoiceRecordingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        cfr21SimplifiedSigningEnabled: {
          description: '';
          type: 'string';
        };
        cfr21SimplifiedSigningEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        cfrUseWideImage: {
          description: 'Boolean that specifies whether to use a shorter/wider format when generating the CFR Part 11 signature image.';
          type: 'string';
        };
        cfrUseWideImageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        checkForMultipleAdminsOnAccount: {
          description: '';
          type: 'string';
        };
        checkForMultipleAdminsOnAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        chromeSignatureEnabled: {
          description: 'Boolean that specifies whether the signers of the envelopes from this account use a signature with a DocuSign chrome around it or not.';
          type: 'string';
        };
        chromeSignatureEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        commentEmailShowMessageText: {
          description: 'When **true,** the text of comments is included in email notifications when a comment is posted.\n\n**Note:**  If the envelope requires additional recipient authentication, comment text is not included.';
          type: 'string';
        };
        commentEmailShowMessageTextMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        commentsAllowEnvelopeOverride: {
          description: 'When **true** and comments are enabled for the account, senders can disable comments for an envelope through the **Advanced Options** menu that appears during the sending process.';
          type: 'string';
        };
        commentsAllowEnvelopeOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        conditionalFieldsEnabled: {
          description: 'When **true,** conditional fields can be used in documents.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        conditionalFieldsEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        consumerDisclosureFrequency: {
          description: 'Speficies how often to display the consumer disclosure.\n\nValid values are:\n\n- `once`: Per account, the supplemental document is displayed once only per `userId`. \n- `always`: Per envelope, the supplemental document is displayed once only per `userId`. \n- `each_access`: Per envelope, the supplemental document is displayed once only per `recipientId`.\n';
          type: 'string';
        };
        consumerDisclosureFrequencyMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        convertPdfFields: {
          description: 'Boolean that specifies whether to enable PDF form fields to get converted to DocuSign secure fields when the document is added or uploaded to an envelope.';
          type: 'string';
        };
        convertPdfFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        dataPopulationScope: {
          description: 'Specifies how data is shared for tabs with the same tabLabel. Valid values are:\n\n- `document`: Tabs in a document with the same label populate with the same data.\n- `envelope`: Tabs in all documents in the envelope with the same label populate with the same data.\n\nThis setting applies to the following tab types: \n\n- Check box \n- Company\n- Data field\n- Drop-down list\n- Full name \n- Formula\n- Note\n- Title\n\n**Note:** Only Admin users can change this setting. Changing this setting affects envelopes that have been sent but not completed.                                                                                                                                                                                                                 ';
          type: 'string';
        };
        dataPopulationScopeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableAutoTemplateMatching: {
          description: '';
          type: 'string';
        };
        disableAutoTemplateMatchingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableMobileApp: {
          description: 'When **true,** the mobile app distributor key is prevented from connecting for account users.';
          type: 'string';
        };
        disableMobileAppMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableMobilePushNotifications: {
          description: 'When **true,** push notifications are disabled for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        disableMobilePushNotificationsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableMobileSending: {
          description: 'When **true,** sending from a mobile application is disabled.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        disableMobileSendingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableMultipleSessions: {
          description: 'When **true,** account users cannot be logged into multiple sessions at the same time.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        disableMultipleSessionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disablePurgeNotificationsForSenderMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableSignerCertView: {
          description: 'When **true,** signers cannot view certificates of completion.';
          type: 'string';
        };
        disableSignerCertViewMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableSignerHistoryView: {
          description: 'When **true,** signers cannot view envelope history.';
          type: 'string';
        };
        disableSignerHistoryViewMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableStyleSignature: {
          description: 'When **true,** the **Select Style** option is hidden from signers and they must draw their signature instead. ';
          type: 'string';
        };
        disableStyleSignatureMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableUploadSignature: {
          description: 'When **true,** signers cannot upload custom image files of their signature and initials.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        disableUploadSignatureMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        disableUserSharing: {
          description: 'When **true,** the User Sharing feature is disabled for the account.';
          type: 'string';
        };
        disableUserSharingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        displayBetaSwitch: {
          description: 'Boolean that specifies whether to display a Beta switch for your app.';
          type: 'string';
        };
        displayBetaSwitchMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        documentConversionRestrictions: {
          description: 'Sets the account document upload restriction for non-account administrators. Valid values are:\n\n- `no_restrictions`: There are no restrictions on the type of documents that can be uploaded.\n- `allow_pdf_only`: Non-administrators can only upload PDF files.\n- `no_upload`: Non-administrators cannot upload files.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        documentConversionRestrictionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        documentRetention: {
          description: 'Sets a document retention period, which controls the number of days that DocuSign retains documents after they have reached a completed,declined, or voided state. When document retention is enabled for the account, the default value is `356` days.';
          type: 'string';
        };
        documentRetentionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        documentRetentionPurgeTabs: {
          description: 'When **true** and `documentRetention` is set, document fields and metadata are also purged after the document retention period ends. The default value is **false.**\n\n**Note:** Only Admins can change this setting.';
          type: 'string';
        };
        documentVisibility: {
          description: 'Configures the Document Visibility feature for the account. Valid values are:\n\n- `Off`: Document Visibility is not active for the account.\n- `MustSignToViewUnlessSenderAccount`: Document Visibility is enabled for all envelopes sent from the account. Any member of the sending account can view all of the documents in an envelope.\n- `MustSignToViewUnlessSender`: Document Visibility is enabled for all envelopes sent from the account. Only the sender can view all of the documents in an envelope.\n- `SenderCanSetMustSignToViewUnlessSenderAccount`: The sender has the option to enable Document Visibility for an envelope. When enabled for an envelope, all of the documents within it are still visible to any member of the sending account.\nVd- `SenderCanSetMustSignToViewUnlessSender`: The sender has the option to enable Document Visibility for an envelope. When enabled for an envelope, all of the documents in the envelope are visible only to the sender.\n\n**Note:** For this configuration to take effect, `allowDocumentVisibility` must be set to **true.**';
          type: 'string';
        };
        documentVisibilityMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        dss_EnableProvisioningPenConfiguration_RadminOption: {
          description: '';
          type: 'string';
        };
        dss_SIGN_28411_EnableLeavePagePrompt_RadminOption: {
          description: '';
          type: 'string';
        };
        dss_SIGN_29182_SlideUpBar_RadminOption: {
          description: '';
          type: 'string';
        };
        emailTemplateVersion: {
          description: "Specifies the version of the email templates used in an account. If new signing is selected in a member's Admin page, the user is updated to the newest version (1.1), the minimum version of email supported for the account.";
          type: 'string';
        };
        emailTemplateVersionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAccessCodeGenerator: {
          description: 'When **true,** enables Access Code Generator on the account.';
          type: 'string';
        };
        enableAccessCodeGeneratorMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAdmHealthcare: {
          description: '';
          type: 'string';
        };
        enableAdmHealthcareMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAdvancedPayments: {
          description: 'When **true,** enables Advanced Payments for the account.';
          type: 'string';
        };
        enableAdvancedPaymentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAdvancedPowerForms: {
          description: 'When **true,** enables advanced PowerForms for the account.';
          type: 'string';
        };
        enableAdvancedPowerFormsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAgreementActionsForCLM: {
          description: '';
          type: 'string';
        };
        enableAgreementActionsForCLMMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAgreementActionsForESign: {
          description: '';
          type: 'string';
        };
        enableAgreementActionsForESignMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAutoNav: {
          description: 'When **true,** enables the account to set the AutoNav rule setting, which enables a sender to override the auto-navigation setting per envelope.\n\n**Note:** To change this setting, you must be a SysAdmin user or `EnableAutoNavByDSAdmin must be set.';
          type: 'string';
        };
        enableAutoNavMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableBccDummyLink: {
          description: '';
          type: 'string';
        };
        enableBccDummyLinkMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableCalculatedFields: {
          description: 'When **true,** calculated fields are enabled for the account. \n\n**Note:** This setting can be changed only by Admin users, and only if the account-level setting `allowExpression` is set to **true.**';
          type: 'string';
        };
        enableCalculatedFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickPlus: {
          description: '';
          type: 'string';
        };
        enableClickPlusConditionalContent: {
          description: '';
          type: 'string';
        };
        enableClickPlusConditionalContentMetaData: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickPlusCustomFields: {
          description: '';
          type: 'string';
        };
        enableClickPlusCustomFieldsMetaData: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickPlusCustomStyle: {
          description: '';
          type: 'string';
        };
        enableClickPlusCustomStyleMetaData: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickPlusDynamicContent: {
          description: '';
          type: 'string';
        };
        enableClickPlusDynamicContentMetaData: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickPlusMetaData: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableClickwraps: {
          description: 'Boolean that specifies whether clickwraps are enabled in your app. A [clickwrap](/docs/click-api/click101/) is an iframe that you embed in your own website or app.';
          type: 'string';
        };
        enableClickwrapsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableCombinedPDFDownloadForSBS: {
          description: '';
          type: 'string';
        };
        enableCommentsHistoryDownloadInSigning: {
          description: '';
          type: 'string';
        };
        enableCommentsHistoryDownloadInSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableContactSuggestions: {
          description: '';
          type: 'string';
        };
        enableContactSuggestionsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableCustomerSatisfactionMetricTracking: {
          description: 'When **true,** enables customer satisfaction metric tracking for the account.';
          type: 'string';
        };
        enableCustomerSatisfactionMetricTrackingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableDSPro: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        enableDSProMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableESignAPIHourlyLimitManagement: {
          description: '';
          type: 'string';
        };
        enableESignAPIHourlyLimitManagementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEnforceTlsEmailsSettingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEnvelopeStampingByAccountAdmin: {
          description: 'When **true,** enables the account administrator\nto control envelope stamping for an account\n(stamping the `envelopeId` in the document margins).\n\n**Note:** This setting can be changed only\nby Admin users, and only if the account-level\nsetting `enableEnvelopeStampingByDSAdmin` is set to **true.**';
          type: 'string';
        };
        enableEnvelopeStampingByAccountAdminMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEnvelopeStampingByDSAdmin: {
          description: 'When **true,** enables the DocuSign administrator to control envelope stamping for an account (placement of the `envelopeId`).';
          type: 'string';
        };
        enableEnvelopeStampingByDSAdminMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEsignCommunities: {
          description: '';
          type: 'string';
        };
        enableEsignCommunitiesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableIDFxAccountlessSMSAuthForPart11: {
          description: '';
          type: 'string';
        };
        enableIDFxAccountlessSMSAuthForPart11Metadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableIDFxIntuitKBA: {
          description: '';
          type: 'string';
        };
        enableIDFxIntuitKBAMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableIDFxPhoneAuthentication: {
          description: '';
          type: 'string';
        };
        enableIDFxPhoneAuthenticationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableIdfxPhoneAuthSignatureAuthStatus: {
          description: '';
          type: 'string';
        };
        enableIdfxPhoneAuthSignatureAuthStatusMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableInBrowserEditor: {
          description: '';
          type: 'string';
        };
        enableInBrowserEditorMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableKeyTermsSuggestionsByDocumentType: {
          description: '';
          type: 'string';
        };
        enableKeyTermsSuggestionsByDocumentTypeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enablePDFAConversion: {
          description: '';
          type: 'string';
        };
        enablePDFAConversionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableParticipantRecipientSettingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enablePaymentProcessing: {
          description: 'When **true,** payment processing is enabled for this account.\n\n**Note:** This setting can be changed only by Admin users, and only if the account-level setting `allowPaymentProcessing` is set.';
          type: 'string';
        };
        enablePaymentProcessingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enablePowerForm: {
          description: 'When **true,** enables PowerForms for the account.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        enablePowerFormDirect: {
          description: 'When **true,** enables direct PowerForms for an account. Direct PowerForms are in-session PowerForms.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        enablePowerFormDirectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enablePowerFormMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableRecipientDomainValidation: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        enableRecipientDomainValidationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableRecipientMayProvidePhoneNumber: {
          description: '';
          type: 'string';
        };
        enableRecipientMayProvidePhoneNumberMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableReportLinks: {
          description: 'Enables direct links to envelopes in reports for administrators in the following scopes:\n- `NoEnvelopes`\n- `AllEnvelopes`\n- `OnlyOwnEnvelopes`';
          type: 'string';
        };
        enableReportLinksMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableRequireSignOnPaper: {
          description: 'When **true,** the account can use the `requireSignOnPaper` option.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        enableRequireSignOnPaperMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableReservedDomain: {
          description: 'When **true,** account administrators can reserve a web domain and users. Domains are organization-specific reserved internet domains, such as `@exampledomain.com`. You can define policy settings for users of each reserved domain within your organization, export lists of domain users for audit purposes, and manage domain users.\n\n- Domains may be claimed by an organization.\n- When a domain is claimed by an organization, all users within that domain are added to the organization, even if they have trial or free accounts.\n- You can set domain controls for all users of the domain.\n- You can export information about your organization’s users that are associated with your reserved domains.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        enableReservedDomainMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableResponsiveSigning: {
          description: 'When **true,** enables responsive signing.';
          type: 'string';
        };
        enableResponsiveSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSMSAuthentication: {
          description: 'When **true,** the account can use SMS authentication.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        enableSMSAuthenticationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSMSDeliveryAdditionalNotification: {
          description: '';
          type: 'string';
        };
        enableSMSDeliveryAdditionalNotificationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSMSDeliveryPrimary: {
          description: '';
          type: 'string';
        };
        enableScheduledRelease: {
          description: 'When **true,** scheduled releases are enabled. The default value is **false.**';
          type: 'string';
        };
        enableScheduledReleaseMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSearch: {
          description: '';
          type: 'string';
        };
        enableSearchMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSearchSiteSpecificApi: {
          description: '';
          type: 'string';
        };
        enableSearchSiteSpecificApiMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSearchUI: {
          description: '';
          type: 'string';
        };
        enableSearchUIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSendToAgent: {
          description: 'When **true,** this account can use the Agent recipient type.\n\n**Note:** Only SysAdmin users can change this setting.\n';
          type: 'string';
        };
        enableSendToAgentMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSendToIntermediary: {
          description: 'When **true,** this account can use the Intermediary recipient type.\n\n**Note:** Only Admin users can change this setting, and only if `allowSendToIntermediary` is set.\n';
          type: 'string';
        };
        enableSendToIntermediaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSendToManage: {
          description: 'When **true,** this account can use the Editor recipient type.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        enableSendToManageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSendingTagsFontSettings: {
          description: 'When **true,** enables fonts to be set on tags for the account.';
          type: 'string';
        };
        enableSendingTagsFontSettingsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSequentialSigningAPI: {
          description: 'When **true,** the account can define the routing\norder of recipients for envelopes sent by using the eSignature API.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        enableSequentialSigningAPIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSequentialSigningUI: {
          description: 'When **true,** the account can define the routing order\nof recipients for envelopes sent by using the DocuSign application.\n\n**Note:** Only SysAdmin users can change this setting.\n';
          type: 'string';
        };
        enableSequentialSigningUIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSignOnPaper: {
          description: 'When **true,** a sender can allow signers to use the sign on paper option.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        enableSignOnPaperMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSignOnPaperOverride: {
          description: 'When **true,** a user can override the default default account setting for the Sign on Paper option, which specifies whether signers can sign documents on paper as an option to signing electronically.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        enableSignOnPaperOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSignWithNotary: {
          description: 'When **true,** Sign with Notary functionality is enabled for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        enableSignWithNotaryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSignerAttachments: {
          description: 'When **true,** users can use the signing attachments feature to request attachments from signers.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        enableSignerAttachmentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSigningExtensionComments: {
          description: 'When **true,** enables comments for the account so that signers and recipients can make and respond to comments in documents belonging to the envelopes that they are sent.';
          type: 'string';
        };
        enableSigningExtensionCommentsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSigningExtensionConversations: {
          description: 'When **true,** enables conversation functionality.';
          type: 'string';
        };
        enableSigningExtensionConversationsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSigningOrderSettingsForAccount: {
          description: 'When **true,** switches Signing Order to On by default for new envelopes.';
          type: 'string';
        };
        enableSigningOrderSettingsForAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSmartContracts: {
          description: 'When **true,** blockchain-based [Smart Contracts](https://www.docusign.com/products/blockchain) are enabled. The default value is **false.**';
          type: 'string';
        };
        enableSmartContractsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableSocialIdLogin: {
          description: 'Deprecated.';
          type: 'string';
        };
        enableSocialIdLoginMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableStrikeThrough: {
          description: 'When **true,** enables strikethrough formatting in documents.';
          type: 'string';
        };
        enableStrikeThroughMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableTransactionPoint: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        enableTransactionPointMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableVaulting: {
          description: 'When **true,** Vaulting is enabled for the account.';
          type: 'string';
        };
        enableVaultingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableWitnessing: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        enableWitnessingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enforceTemplateNameUniqueness: {
          description: 'When **true,** the template name must be unique.';
          type: 'string';
        };
        enforceTemplateNameUniquenessMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enforceTlsEmails: {
          description: '';
          type: 'string';
        };
        enforceTlsEmailsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        envelopeIntegrationAllowed: {
          description: 'Shows the envelope integration rule for the account, which indicates whether custom admins can enable Connect for their accounts. Enumeration values are: \n\n- `not_allowed`\n- `full` \n\n**Note:** Only SysAdmin users can change this setting.                                                                                 ';
          type: 'string';
        };
        envelopeIntegrationAllowedMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        envelopeIntegrationEnabled: {
          description: 'When **true,** enables Connect for an account. Note that Connect integration requires additional configuration that must be set up for it to take effect; this switch is only the on/off control for the account.\n\n**Note:** Only Admin users can change this setting, and only when `envelopeIntegrationAllowed` is set.';
          type: 'string';
        };
        envelopeIntegrationEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        envelopeSearchMode: {
          description: '';
          type: 'string';
        };
        envelopeSearchModeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        envelopeStampingDefaultValue: {
          description: 'When **true,** envelopes sent by this account automatically have the envelope ID stamped in the document margins, unless the sender selects not to have the documents stamped.';
          type: 'string';
        };
        envelopeStampingDefaultValueMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        exitPrompt: {
          description: '';
          type: 'string';
        };
        exitPromptMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        expressSend: {
          description: 'Boolean that specifies whether a member of an account can express send (without tags) or must send with tags on documents.';
          type: 'string';
        };
        expressSendAllowTabs: {
          description: 'Boolean that specifies whether a member of an account can send templates without the tags being stripped out, even when the account is configured to let its users express send only (they cannot use the tagger).';
          type: 'string';
        };
        expressSendAllowTabsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        expressSendMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        externalDocumentSources: {
          $ref: '#/components/schemas/externalDocumentSources';
        };
        externalSignaturePadType: {
          description: 'Specifies the signature pad type.\nValid values are:\n\n- `none`\n- `topaz`\n- `e_padv9`\n- `e_pad_integrisign`\n- `topaz_sigplusextlite`\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        externalSignaturePadTypeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        faxOutEnabled: {
          description: 'When **true,** fax delivery to recipients is allowed for the account.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        faxOutEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        finishReminder: {
          description: '';
          type: 'string';
        };
        finishReminderMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        guidedFormsHtmlAllowed: {
          description: 'When **true,** HTML used to implement [Guided Forms](https://www.docusign.com/products/guided-forms) is enabled for the account.';
          type: 'string';
        };
        guidedFormsHtmlAllowedMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        guidedFormsHtmlConversionPolicy: {
          description: '';
          type: 'string';
        };
        guidedFormsHtmlConversionPolicyMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hasRecipientConnectClaimedDomain: {
          description: '';
          type: 'string';
        };
        hideAccountAddressInCoC: {
          description: 'Boolean that specifies whether to hide the account address in the Certificate of Completion.';
          type: 'string';
        };
        hideAccountAddressInCoCMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hidePricing: {
          description: 'Boolean that specifies whether to hide the pricing functionality for an account.';
          type: 'string';
        };
        hidePricingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idCheckConfigurations: {
          description: 'A list of ID check configuration objects.';
          items: {
            $ref: '#/components/schemas/idCheckConfiguration';
          };
          type: 'array';
        };
        idCheckExpire: {
          description: "Determines when a user's authentication with the account expires. Valid values are:\n\n- `always`: Users are required to authenticate each time.\n- `variable`: If the authentication for a user is valid and falls within the value for the `idCheckExpireDays` property, the user is not required to authenticate again.\n\n**Note:** Only Admin users can change this setting.";
          type: 'string';
        };
        idCheckExpireDays: {
          description: 'The number of days before user authentication credentials expire. A value of `0` specifies that users must re-authenticate for each new session.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        idCheckExpireDaysMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idCheckExpireMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idCheckExpireMinutes: {
          description: 'The number of minutes before user authentication credentials expire.';
          type: 'string';
        };
        idCheckExpireMinutesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idCheckRequired: {
          description: 'Indicates if authentication is configured for the account. Valid values are:\n\n- `always`: Authentication checks are performed on every envelope.\n- `never`: Authentication checks are not performed on any envelopes.\n- `optional`: Authentication is configurable per envelope.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        idCheckRequiredMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        identityVerification: {
          description: "Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).";
          items: {
            $ref: '#/components/schemas/accountIdentityVerificationWorkflow';
          };
          type: 'array';
        };
        identityVerificationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idfxKBAAuthenticationOverride: {
          description: '';
          type: 'string';
        };
        idfxKBAAuthenticationOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        idfxPhoneAuthenticationOverride: {
          description: '';
          type: 'string';
        };
        idfxPhoneAuthenticationOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        ignoreErrorIfAnchorTabNotFound: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        ignoreErrorIfAnchorTabNotFoundMetadataEnabled: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        inPersonIDCheckQuestion: {
          description: "A text field containing the question that an in-person signing host uses to collect personal information from the recipient. The recipient's response to this question is saved and can be viewed in the certificate associated with the envelope.\n\n**Note:** Only Admin users can change this setting.";
          type: 'string';
        };
        inPersonIDCheckQuestionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        inPersonSigningEnabled: {
          description: 'When **true,** in-person signing is enabled for the account.';
          type: 'string';
        };
        inPersonSigningEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        inSessionEnabled: {
          description: 'When **true,** the account can send in-session (embedded) envelopes.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        inSessionEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        inSessionSuppressEmails: {
          description: 'When **true,** emails are not sent to the in-session (embedded) recipients on an envelope.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        inSessionSuppressEmailsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        isConnectDocumentFieldsEnabled: {
          description: '';
          type: 'string';
        };
        linkedExternalPrimaryAccounts: {
          description: '';
          items: {
            $ref: '#/components/schemas/linkedExternalPrimaryAccount';
          };
          type: 'array';
        };
        maxNumberOfCustomStamps: {
          description: 'The maximum number of custom stamps.';
          type: 'string';
        };
        maximumSigningGroups: {
          description: 'The maximum number of signing groups allowed on the account. The default value is `50`. This setting is only shown in responses that list account settings.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        maximumSigningGroupsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        maximumUsersPerSigningGroup: {
          description: 'The maximum number of users per signing group. The default value is `50`. This setting is only shown in responses that list account settings.\n\n**Note:** Only SysAdmin users can change this setting.';
          type: 'string';
        };
        maximumUsersPerSigningGroupMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        mergeMixedModeResults: {
          description: '';
          type: 'string';
        };
        mergeMixedModeResultsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        mobileSessionTimeout: {
          description: 'The number of minutes of inactivity before a mobile user is automatically logged out of the system. Valid values are `1` to `120` minutes. The default value is `20` minutes.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        mobileSessionTimeoutMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        numberOfActiveCustomStamps: {
          description: 'The number of active custom stamps associated with the account. DocuSign calculates this number automatically. This property is only visible to the DocuSign account manager.';
          type: 'string';
        };
        optInMobileSigningV02: {
          description: 'Boolean that specifies whether to opt in for Signing v02 on Mobile Devices functionality.';
          type: 'string';
        };
        optInMobileSigningV02Metadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        optInUniversalSignatures: {
          description: '';
          type: 'string';
        };
        optOutAutoNavTextAndTabColorUpdates: {
          description: 'Boolean that allows envelope senders to opt out of the recipient signing auto-navigation feature and opt out of updating tab font color.';
          type: 'string';
        };
        optOutAutoNavTextAndTabColorUpdatesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        optOutNewPlatformSeal: {
          description: 'Boolean that specifies whether to allow envelope senders to opt out of using the new platform seal.';
          type: 'string';
        };
        optOutNewPlatformSealPlatformMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        pdfMaxChunkedUploadPartSize: {
          description: '';
          type: 'string';
        };
        pdfMaxChunkedUploadPartSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        pdfMaxChunkedUploadTotalSize: {
          description: '';
          type: 'string';
        };
        pdfMaxChunkedUploadTotalSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        pdfMaxIndividualUploadSize: {
          description: '';
          type: 'string';
        };
        pdfMaxIndividualUploadSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        phoneAuthRecipientMayProvidePhoneNumber: {
          description: 'When **true,** senders can allow recipients to provide a phone number for the Phone Authentication process.\n\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        phoneAuthRecipientMayProvidePhoneNumberMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        pkiSignDownloadedPDFDocs: {
          description: 'The policy for adding a digital certificate to downloaded, printed, and emailed documents. \n\nPossible values are: \n\n- `no_sign`\n- `no_sign_allow_user_override`\n- `yes_sign` (Specifies that PDF files downloaded from the platform are signed.)\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        pkiSignDownloadedPDFDocsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        readOnlyMode: {
          description: '';
          type: 'string';
        };
        readOnlyModeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        recipientSigningAutoNavigationControl: {
          description: 'When **true,** recipients receiving envelopes from this account can override auto-navigation functionality.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        recipientSigningAutoNavigationControlMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        recipientsCanSignOffline: {
          description: 'When **true,**\nrecipients receiving envelopes from this account\ncan sign offline.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        recipientsCanSignOfflineMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        require21CFRpt11Compliance: {
          description: 'When **true,**\nrecipients are required\nto use a 21 CFR part 11-compliant signing experience.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        require21CFRpt11ComplianceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        requireDeclineReason: {
          description: 'When **true,** signers who decline to sign an envelope sent from this account\nare required to provide a reason for declining.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        requireDeclineReasonMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        requireExternalUserManagement: {
          description: 'When **true,** the account requires external management of users.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        requireExternalUserManagementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        requireSignerCertificateType: {
          description: 'Sets the Digital Signature certificate requirements for sending envelopes.\nValid values are:\n\n- `none`: A Digital Signature certificate is not required.\n- `docusign_express`: Signers must use a DocuSign Express certificate.\n- `docusign_personal`: Signers must use a DocuSign personal certificate.\n- `safe`\n- `open_trust`: Signers must use an OpenTrust certificate.\n';
          type: 'string';
        };
        requireSignerCertificateTypeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        rsaVeridAccountName: {
          description: 'The RSA account name.\n\n**Note:**\nOnly Admin users can change this setting. Modifying this value may disrupt\nyour ID Check capability.\nEnsure you have the correct value before changing it.\n';
          type: 'string';
        };
        rsaVeridPassword: {
          description: 'The password for the RSA account.\n\n\n**Note:**\nOnly Admin users can change this setting. Modifying this value may disrupt\nyour ID Check capability.\nEnsure you have the correct value before changing it.\n';
          type: 'string';
        };
        rsaVeridRuleset: {
          description: 'The RSA rule set used with the account.\n\n**Note:**\nOnly Admin users can change this setting. Modifying this value may disrupt\nyour ID Check capability.\nEnsure you have the correct value before changing it.\n';
          type: 'string';
        };
        rsaVeridUserId: {
          description: 'The user ID for the RSA account.\n\n**Note:**\nOnly Admin users can change this setting. Modifying this value may disrupt\nyour ID Check capability.\nEnsure you have the correct value before changing it.\n';
          type: 'string';
        };
        sbsTransactionLevel: {
          description: '';
          type: 'string';
        };
        selfSignedRecipientEmailDocument: {
          description: 'Sets how self-signed documents are presented to the email recipients.\nValid values are:\n\n- `include_pdf`: A PDF of the completed document is attached to the email.\n- `include_link`: A secure link to the self-signed documents is included\n   in the email.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        selfSignedRecipientEmailDocumentMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        selfSignedRecipientEmailDocumentUserOverride: {
          description: 'When **true,** the `selfSignedRecipientEmailDocument` user setting\ncan be set for an individual user.\nThe user setting overrides the account setting.\n\n**Note:** Only Admin users can change this account setting.\n';
          type: 'string';
        };
        selfSignedRecipientEmailDocumentUserOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sendLockoutRecipientNotification: {
          description: '';
          type: 'string';
        };
        sendLockoutRecipientNotificationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sendToCertifiedDeliveryEnabled: {
          description: 'When true,\nthe account can use the\ncertified deliveries recipient type.\n';
          type: 'string';
        };
        sendToCertifiedDeliveryEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        senderCanSignInEachLocation: {
          description: 'When **true,** a signer can draw their signature in each\nlocation where a sign or initial tab exists. This functionality\nis typically used for mobile signing.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        senderCanSignInEachLocationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        senderMustAuthenticateSigning: {
          description: 'When **true,** a sender who is also a recipient of an envelope\nmust follow the authentication requirements for the envelope.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        senderMustAuthenticateSigningMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sendingTagsFontColor: {
          description: 'The account-wide default font color to use for the content of the tab.\n\nValid values are:\n\n- `Black`\n- `BrightBlue`\n- `BrightRed`\n- `DarkGreen`\n- `DarkRed`\n- `Gold`\n- `Green`\n- `NavyBlue`\n- `Purple`\n- `White`\n';
          type: 'string';
        };
        sendingTagsFontColorMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sendingTagsFontName: {
          description: 'The account-wide default font to be used for the tab value. Supported fonts include:\n\n- `Default`\n- `Arial`\n- `ArialNarrow`\n- `Calibri`\n- `CourierNew`\n- `Garamond`\n- `Georgia`\n- `Helvetica`\n- `LucidaConsole`\n- `MSGothic`\n- `MSMincho`\n- `OCR-A`\n- `Tahoma`\n- `TimesNewRoman`\n- `Trebuchet`\n- `Verdana`';
          type: 'string';
        };
        sendingTagsFontNameMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sendingTagsFontSize: {
          description: 'The account-wide default font size used for the information in the tab:\n\n- `Size7`\n- `Size8`\n- `Size9`\n- `Size10`\n- `Size11`\n- `Size12`\n- `Size14`\n- `Size16`\n- `Size18`\n- `Size20`\n- `Size22`\n- `Size24`\n- `Size26`\n- `Size28`\n- `Size36`\n- `Size48`\n- `Size72`';
          type: 'string';
        };
        sendingTagsFontSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sessionTimeout: {
          description: 'The amount of idle activity time, in minutes, before a user is automatically logged out of the system. The minimum setting is 20 minutes and the maximum setting is 120 minutes.\n';
          type: 'string';
        };
        sessionTimeoutMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        setRecipEmailLang: {
          description: 'When **true,** senders can set the email language to use for\neach recipient.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        setRecipEmailLangMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        setRecipSignLang: {
          description: 'When **true,**\nsetting a unique language for a recipient\nnot only affects the email language, but also the signing\nlanguage they are presented with. When **false,** only the email will\nbe affected when the sender specifies a unique language for a\nrecipient.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        setRecipSignLangMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        sharedTemplateFolders: {
          description: 'Boolean that specifies whether an account can use Shared Template Folders.';
          type: 'string';
        };
        sharedTemplateFoldersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showCompleteDialogInEmbeddedSession: {
          description: 'Boolean that specifies whether complete dialogs are displayed directly within an application in embedded signing sessions.';
          type: 'string';
        };
        showCompleteDialogInEmbeddedSessionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showConditionalRoutingOnSend: {
          description: 'When **true,** Conditional Routing options display to senders during the sending experience.';
          type: 'string';
        };
        showConditionalRoutingOnSendMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showInitialConditionalFields: {
          description: 'Boolean that specifies whether conditional field options are initially displayed (before a user makes entries).';
          type: 'string';
        };
        showInitialConditionalFieldsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showLocalizedWatermarks: {
          description: 'Boolean that specifies whether localized watermarks are displayed.';
          type: 'string';
        };
        showLocalizedWatermarksMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showMaskedFieldsWhenDownloadingDocumentAsSender: {
          description: '';
          type: 'string';
        };
        showMaskedFieldsWhenDownloadingDocumentAsSenderMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        showTutorials: {
          description: 'When **true,**\nshow tutorials.\n';
          type: 'string';
        };
        showTutorialsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signDateFormat: {
          description: 'The format for the signature date. Valid values are:\n\n- `d/M/yyyy`\n- `dd-MM-yy`\n- `dd-MMM-yy`\n- `dd-MM-yyyy`\n- `dd.MM.yyyy`\n- `dd-MMM-yyyy`\n- `dd MMMM yyyy`\n- `M/d/yyyy`\n- `MM-dd-yyyy`\n- `MM/dd/yyyy`\n- `MM/dd/yy`\n- `MMM-dd-yyyy`\n- `MMM d, yyyy`\n- `MMMM d, yyyy`\n- `yyyy-MM-dd`\n- `yyyy-MMM-dd`\n- `yyyy/MM/dd`\n- `yyyy MMMM d`\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signDateFormatMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signDateTimeAccountLanguageOverride: {
          description: '';
          type: 'string';
        };
        signDateTimeAccountLanguageOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signDateTimeAccountTimezoneOverride: {
          description: '';
          type: 'string';
        };
        signDateTimeAccountTimezoneOverrideMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signTimeFormat: {
          description: 'The format for the signature time. Valid values are:\n\n- `none`\n- `HH:mm`\n- `h:mm`\n- `HH:mm:ss`\n- `h:mm:ss`\n';
          type: 'string';
        };
        signTimeFormatMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signTimeShowAmPm: {
          description: 'When **true,**\nthe time shows the AM or PM indicator.\n';
          type: 'string';
        };
        signTimeShowAmPmMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signatureProviders: {
          description: 'Names of electronic or digital signature providers that can be used.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        signatureProvidersMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerAttachCertificateToEnvelopePDF: {
          description: 'When **true,**\nthe Certificate of Completion is included in the PDF of the envelope documents\nwhen it is downloaded.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerAttachCertificateToEnvelopePDFMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerAttachConcat: {
          description: 'When **true,** signer attachments are added to the parent document\nthat contains the attachment.\nThe default behavior creates\na new document in the envelope for every signer attachment.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerAttachConcatMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerCanCreateAccount: {
          description: 'When **true,**\na signer can create a DocuSign account\nafter signing.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerCanCreateAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerCanSignOnMobile: {
          description: 'When **true,** recipients can sign on a mobile device.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerCanSignOnMobileMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerInSessionUseEnvelopeCompleteEmail: {
          description: 'When **true,** an "envelope complete" email is sent to an in-session\n(embedded) or offline signer after DocuSign processes the envelope\nif in-session emails are not suppressed.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerInSessionUseEnvelopeCompleteEmailMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerLoginRequirements: {
          description: 'Sets the login requirements for signers. Valid values are:\n\n- `login_not_required`: Signers are not required to log in.\n- `login_required_if_account_holder`: If the signer has a DocuSign account,\n  they must log in to sign the document.\n- `login_required_per_session`: The sender cannot send an envelope to anyone\n  who does not have a DocuSign account.\n- `login_required_per_envelope`: The sender cannot send an envelope to anyone\n  who does not have a DocuSign account, and the signer must also log in for\n  each envelope they will sign.\n\n\n**Note:** Only Admin users can change this setting. If you use Direct PowerForms\nor captive (embedded signers), the "Account required" settings are bypassed for\nthose signers. If your workflow requires that the signer have an account,\nyou should not use those methods.\n';
          type: 'string';
        };
        signerLoginRequirementsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerMustHaveAccount: {
          description: 'When **true,** senders can only send an envelope to a recipient\nthat has a DocuSign account.\n\n**Note:** Only Account Administrators can change this setting.\n';
          type: 'string';
        };
        signerMustHaveAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerMustLoginToSign: {
          description: 'When **true,**\nsigners must log in to the DocuSign platform to sign an envelope.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerMustLoginToSignMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signerShowSecureFieldInitialValues: {
          description: 'When **true,** the initial values of all SecureFields are written\nto the document when it is sent.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        signerShowSecureFieldInitialValuesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signingSessionTimeout: {
          description: 'The number of minutes\nthat a signing session stays\nalive without any activity.\n';
          type: 'string';
        };
        signingSessionTimeoutMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        signingUiVersion: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        signingUiVersionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        simplifiedSendingEnabled: {
          description: 'When **true,** simplified sending is enabled for the account. The default value is **false.**';
          type: 'string';
        };
        simplifiedSendingEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        singleSignOnEnabled: {
          description: 'When **true,**\nsingle sign-on (SSO) is enabled.\n';
          type: 'string';
        };
        singleSignOnEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        skipAuthCompletedEnvelopes: {
          description: 'When **true,**\ndo not require authentication prompt for viewing completed envelopes\n';
          type: 'string';
        };
        skipAuthCompletedEnvelopesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        socialIdRecipAuth: {
          description: 'When **true,**\nrecipients can use\n[social ids](https://support.docusign.com/guides/signer-authentication)\nwhen signing\n';
          type: 'string';
        };
        socialIdRecipAuthMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        specifyDocumentVisibility: {
          description: 'When **true,** senders can specify the visibility of the documents in an envelope at the recipient level.\n';
          type: 'string';
        };
        specifyDocumentVisibilityMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        startInAdvancedCorrect: {
          description: 'When **true,**\nwhen initiating correction of an in-flight envelope\nthe sender starts in advanced correct mode.\n';
          type: 'string';
        };
        startInAdvancedCorrectMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustAccept: {
          description: 'When **true,** account users must accept supplemental documents when signing.';
          type: 'string';
        };
        supplementalDocumentsMustAcceptMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustRead: {
          description: 'When **true,** account users must both view and accept supplemental documents when signing.';
          type: 'string';
        };
        supplementalDocumentsMustReadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        supplementalDocumentsMustView: {
          description: 'When **true,** account users must view supplemental documents when signing.';
          type: 'string';
        };
        supplementalDocumentsMustViewMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        suppressCertificateEnforcement: {
          description: 'Boolean that specifies whether or not API calls require a x509 cert in the header of the call.';
          type: 'string';
        };
        suppressCertificateEnforcementMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        tabAccountSettings: {
          $ref: '#/components/schemas/tabAccountSettings';
        };
        timezoneOffsetAPI: {
          description: 'Specifies the time zone\nto use with the API.\n\nValid values are:\n\n- `TZ_01_AfghanistanStandardTime`\n- `TZ_02_AlaskanStandardTime`\n- `TZ_03_ArabStandardTime`\n- `TZ_04_ArabianStandardTime`\n- `TZ_05_ArabicStandardTime`\n- `TZ_06_ArgentinaStandardTime`\n- `TZ_07_AtlanticStandardTime`\n- `TZ_08_AUS_CentralStandardTime`\n- `TZ_09_AUS_EasternStandardTime`\n- `TZ_10_AzerbaijanStandardTime`\n- `TZ_11_AzoresStandardTime`\n- `TZ_12_BangladeshStandardTime`\n- `TZ_13_CanadaCentralStandardTime`\n- `TZ_14_CapeVerdeStandardTime`\n- `TZ_15_CaucasusStandardTime`\n- `TZ_16_CentralAustraliaStandardTime`\n- `TZ_17_CentralAmericaStandardTime`\n- `TZ_18_CentralAsiaStandardTime`\n- `TZ_19_CentralBrazilianStandardTime`\n- `TZ_20_CentralEuropeStandardTime`\n- `TZ_21_CentralEuropeanStandardTime`\n- `TZ_22_CentralPacificStandardTime`\n- `TZ_23_CentralStandardTime`\n- `TZ_24_CentralStandardTimeMexico`\n- `TZ_25_ChinaStandardTime`\n- `TZ_26_DatelineStandardTime`\n- `TZ_27_E_AfricaStandardTime`\n- `TZ_28_E_AustraliaStandardTime`\n- `TZ_29_E_EuropeStandardTime`\n- `TZ_30_E_SouthAmericaStandardTime`\n- `TZ_31_EasternStandardTime`\n- `TZ_32_EgyptStandardTime`\n- `TZ_33_EkaterinburgStandardTime`\n- `TZ_34_FijiStandardTime`\n- `TZ_35_FLE_StandardTime`\n- `TZ_36_GeorgianStandardTime`\n- `TZ_37_GMT_StandardTime`\n- `TZ_38_GreenlandStandardTime`\n- `TZ_39_GreenwichStandardTime`\n- `TZ_40_GTB_StandardTime`\n- `TZ_41_HawaiianStandardTime`\n- `TZ_42_IndiaStandardTime`\n- `TZ_43_IranStandardTime`\n- `TZ_44_IsraelStandardTime`\n- `TZ_45_JordanStandardTime`\n- `TZ_46_KaliningradStandardTime`\n- `TZ_47_KamchatkaStandardTime`\n- `TZ_48_KoreaStandardTime`\n- `TZ_49_MagadanStandardTime`\n- `TZ_50_MauritiusStandardTime`\n- `TZ_51_MidAtlanticStandardTime`\n- `TZ_52_MiddleEastStandardTime`\n- `TZ_53_MontevideoStandardTime`\n- `TZ_54_MoroccoStandardTime`\n- `TZ_55_MountainStandardTime`\n- `TZ_56_MountainStandardTimeMMexico`\n- `TZ_57_MyanmarStandardTime`\n- `TZ_58_N_CentralAsiaStandardTime`\n- `TZ_59_NamibiaStandardTime`\n- `TZ_60_NepalStandardTime`\n- `TZ_61_NewZealandStandardTime`\n- `TZ_62_NewfoundlandStandardTime`\n- `TZ_63_NorthAsiaEastStandardTime`\n- `TZ_64_NorthAsiaStandardTime`\n- `TZ_65_PacificSAStandardTime`\n- `TZ_66_PacificStandardTime`\n- `TZ_67_PacificStandardTimeMexico`\n- `TZ_68_PakistanStandardTime`\n- `TZ_69_ParaguayStandardTime`\n- `TZ_70_RomanceStandardTime`\n- `TZ_71_RussianStandardTime`\n- `TZ_72_SAEasternStandardTime`\n- `TZ_73_SAPacificStandardTime`\n- `TZ_74_SAWesternStandardTime`\n- `TZ_75_SamoaStandardTime`\n- `TZ_76_SE_AsiaStandardTime`\n- `TZ_77_SingaporeStandardTime`\n- `TZ_78_SouthAfricaStandardTime`\n- `TZ_79_SriLankaStandardTime`\n- `TZ_80_SyriaStandardTime`\n- `TZ_81_TaipeiStandardTime`\n- `TZ_82_TasmaniaStandardTime`\n- `TZ_83_TokyoStandardTime`\n- `TZ_84_TongaStandardTime`\n- `TZ_85_TurkeyStandardTime`\n- `TZ_86_UlaanbaatarStandardTime`\n- `TZ_87_US_EasternStandardTime`\n- `TZ_88_USMountainStandardTime`\n- `TZ_89_VenezuelaStandardTime`\n- `TZ_90_VladivostokStandardTime`\n- `TZ_91_W_AustraliaStandardTime`\n- `TZ_92_W_CentralAfricaStandardTime`\n- `TZ_93_W_EuropeStandardTime`\n- `TZ_94_WestAsiaStandardTime`\n- `TZ_95_WestPacificStandardTime`\n- `TZ_96_YakutskStandardTime`\n';
          type: 'string';
        };
        timezoneOffsetAPIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        timezoneOffsetUI: {
          description: 'Specifies the time zone\nto use in the UI.\n\nValid values are:\n\n- `TZ_01_AfghanistanStandardTime`\n- `TZ_02_AlaskanStandardTime`\n- `TZ_03_ArabStandardTime`\n- `TZ_04_ArabianStandardTime`\n- `TZ_05_ArabicStandardTime`\n- `TZ_06_ArgentinaStandardTime`\n- `TZ_07_AtlanticStandardTime`\n- `TZ_08_AUS_CentralStandardTime`\n- `TZ_09_AUS_EasternStandardTime`\n- `TZ_10_AzerbaijanStandardTime`\n- `TZ_11_AzoresStandardTime`\n- `TZ_12_BangladeshStandardTime`\n- `TZ_13_CanadaCentralStandardTime`\n- `TZ_14_CapeVerdeStandardTime`\n- `TZ_15_CaucasusStandardTime`\n- `TZ_16_CentralAustraliaStandardTime`\n- `TZ_17_CentralAmericaStandardTime`\n- `TZ_18_CentralAsiaStandardTime`\n- `TZ_19_CentralBrazilianStandardTime`\n- `TZ_20_CentralEuropeStandardTime`\n- `TZ_21_CentralEuropeanStandardTime`\n- `TZ_22_CentralPacificStandardTime`\n- `TZ_23_CentralStandardTime`\n- `TZ_24_CentralStandardTimeMexico`\n- `TZ_25_ChinaStandardTime`\n- `TZ_26_DatelineStandardTime`\n- `TZ_27_E_AfricaStandardTime`\n- `TZ_28_E_AustraliaStandardTime`\n- `TZ_29_E_EuropeStandardTime`\n- `TZ_30_E_SouthAmericaStandardTime`\n- `TZ_31_EasternStandardTime`\n- `TZ_32_EgyptStandardTime`\n- `TZ_33_EkaterinburgStandardTime`\n- `TZ_34_FijiStandardTime`\n- `TZ_35_FLE_StandardTime`\n- `TZ_36_GeorgianStandardTime`\n- `TZ_37_GMT_StandardTime`\n- `TZ_38_GreenlandStandardTime`\n- `TZ_39_GreenwichStandardTime`\n- `TZ_40_GTB_StandardTime`\n- `TZ_41_HawaiianStandardTime`\n- `TZ_42_IndiaStandardTime`\n- `TZ_43_IranStandardTime`\n- `TZ_44_IsraelStandardTime`\n- `TZ_45_JordanStandardTime`\n- `TZ_46_KaliningradStandardTime`\n- `TZ_47_KamchatkaStandardTime`\n- `TZ_48_KoreaStandardTime`\n- `TZ_49_MagadanStandardTime`\n- `TZ_50_MauritiusStandardTime`\n- `TZ_51_MidAtlanticStandardTime`\n- `TZ_52_MiddleEastStandardTime`\n- `TZ_53_MontevideoStandardTime`\n- `TZ_54_MoroccoStandardTime`\n- `TZ_55_MountainStandardTime`\n- `TZ_56_MountainStandardTimeMMexico`\n- `TZ_57_MyanmarStandardTime`\n- `TZ_58_N_CentralAsiaStandardTime`\n- `TZ_59_NamibiaStandardTime`\n- `TZ_60_NepalStandardTime`\n- `TZ_61_NewZealandStandardTime`\n- `TZ_62_NewfoundlandStandardTime`\n- `TZ_63_NorthAsiaEastStandardTime`\n- `TZ_64_NorthAsiaStandardTime`\n- `TZ_65_PacificSAStandardTime`\n- `TZ_66_PacificStandardTime`\n- `TZ_67_PacificStandardTimeMexico`\n- `TZ_68_PakistanStandardTime`\n- `TZ_69_ParaguayStandardTime`\n- `TZ_70_RomanceStandardTime`\n- `TZ_71_RussianStandardTime`\n- `TZ_72_SAEasternStandardTime`\n- `TZ_73_SAPacificStandardTime`\n- `TZ_74_SAWesternStandardTime`\n- `TZ_75_SamoaStandardTime`\n- `TZ_76_SE_AsiaStandardTime`\n- `TZ_77_SingaporeStandardTime`\n- `TZ_78_SouthAfricaStandardTime`\n- `TZ_79_SriLankaStandardTime`\n- `TZ_80_SyriaStandardTime`\n- `TZ_81_TaipeiStandardTime`\n- `TZ_82_TasmaniaStandardTime`\n- `TZ_83_TokyoStandardTime`\n- `TZ_84_TongaStandardTime`\n- `TZ_85_TurkeyStandardTime`\n- `TZ_86_UlaanbaatarStandardTime`\n- `TZ_87_US_EasternStandardTime`\n- `TZ_88_USMountainStandardTime`\n- `TZ_89_VenezuelaStandardTime`\n- `TZ_90_VladivostokStandardTime`\n- `TZ_91_W_AustraliaStandardTime`\n- `TZ_92_W_CentralAfricaStandardTime`\n- `TZ_93_W_EuropeStandardTime`\n- `TZ_94_WestAsiaStandardTime`\n- `TZ_95_WestPacificStandardTime`\n- `TZ_96_YakutskStandardTime`\n';
          type: 'string';
        };
        timezoneOffsetUIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        universalSignatureOptIn: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        useAccountLevelEmail: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        useAccountLevelEmailMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useConsumerDisclosure: {
          description: 'When **true,** the account uses an Electronic Record and\nSignature Disclosure Statement.\n\n**Note:** Only Admin users can change this setting.\n';
          type: 'string';
        };
        useConsumerDisclosureMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useConsumerDisclosureWithinAccount: {
          description: 'When **true,** specifies that recipients in the same account as the sender must agree to eSign an Electronic Record and Signature Disclosure Statement.';
          type: 'string';
        };
        useConsumerDisclosureWithinAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useDerivedKeys: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        useDerivedKeysMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useDocuSignExpressSignerCertificate: {
          description: 'When **true,**\nsigners\nare required to use Express Digital Signatures.\n';
          type: 'string';
        };
        useDocuSignExpressSignerCertificateMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useEnvelopeSearchMixedMode: {
          description: '';
          type: 'string';
        };
        useEnvelopeSearchMixedModeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useMultiAppGroupsData: {
          description: '';
          type: 'string';
        };
        useMultiAppGroupsDataMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useNewBlobForPdf: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        useNewBlobForPdfMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useNewEnvelopeSearch: {
          description: '';
          type: 'string';
        };
        useNewEnvelopeSearchMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useSAFESignerCertificates: {
          description: 'When **true,**\nsigners are\nrequired to use SAFE digital signatures.\n';
          type: 'string';
        };
        useSAFESignerCertificatesMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useSignatureProviderPlatform: {
          description: 'Boolean that specifies whether the account uses the digital signature provider platform to eSign.';
          type: 'string';
        };
        useSignatureProviderPlatformMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        useSmartContractsV1: {
          description: '';
          type: 'string';
        };
        usesAPI: {
          description: 'When **true,**\nthe account can use the API.\n\n**Note:** Only SysAdmin users can change this setting.\n';
          type: 'string';
        };
        usesAPIMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        validationsAllowed: {
          description: 'Boolean that specifies whether validations on recipient email domains are allowed.';
          type: 'string';
        };
        validationsAllowedMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        validationsBrand: {
          description: 'Valid values are:\n\n- `docusign`\n- `account`\n';
          type: 'string';
        };
        validationsBrandMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        validationsCadence: {
          description: 'Valid values are:\n\n- `none`\n- `monthly`\n';
          type: 'string';
        };
        validationsCadenceMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        validationsEnabled: {
          description: 'When **true,**\nenables validations.\n';
          type: 'string';
        };
        validationsEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        validationsReport: {
          description: 'Valid values are:\n\n- `none`\n- `life_sciences_part11`\n';
          type: 'string';
        };
        validationsReportMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        waterMarkEnabled: {
          description: 'When **true,**\nthe\n[watermark feature](https://support.docusign.com/en/articles/How-do-I-manage-the-watermark-for-In-Process-envelopes-sent-from-my-account)\nis enabled for the account.\n';
          type: 'string';
        };
        waterMarkEnabledMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        writeReminderToEnvelopeHistory: {
          description: 'When **true,**\nsent reminders are included in the envelope history.';
          type: 'string';
        };
        writeReminderToEnvelopeHistoryMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        wurflMinAllowableScreenSize: {
          description: 'The smallest screen allowed.';
          type: 'string';
        };
        wurflMinAllowableScreenSizeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSettingsInformation';
      'x-ms-summary': 'Contains account settings information. Used in requests to set property values. Used in responses to report property values.';
    };
    accountSharedAccess: {
      description: 'Contains shared access information.';
      properties: {
        accountId: {
          description: 'The account ID associated with the envelope.';
          type: 'string';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        sharedAccess: {
          description: 'A list of shared access information of envelope and templates for the users specified in the request.';
          items: {
            $ref: '#/components/schemas/memberSharedItems';
          };
          type: 'array';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSharedAccess';
      'x-ms-summary': 'Contains shared access information.';
    };
    accountSignature: {
      description: '';
      properties: {
        adoptedDateTime: {
          description: 'The UTC date and time when the user adopted the signature.';
          type: 'string';
        };
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        customField: {
          description: '';
          type: 'string';
        };
        dateStampProperties: {
          $ref: '#/components/schemas/dateStampProperties';
        };
        disallowUserResizeStamp: {
          description: 'When **true,** users may not resize the stamp.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        externalID: {
          description: "Optionally specify an external identifier for the user's signature.";
          type: 'string';
        };
        imageBase64: {
          description: '';
          type: 'string';
        };
        imageType: {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          type: 'string';
        };
        initials150ImageId: {
          description: "The ID of the user's initials image.";
          type: 'string';
        };
        initialsImageUri: {
          description: "The URI for retrieving the image of the user's initials.";
          type: 'string';
        };
        isDefault: {
          description: 'Boolean that specifies whether the signature is the default signature for the user.';
          type: 'string';
        };
        lastModifiedDateTime: {
          description: 'The date and time that the item was last modified.';
          type: 'string';
        };
        nrdsId: {
          description: 'The National Association of Realtors (NAR) membership ID for a user who is a realtor.';
          type: 'string';
        };
        nrdsLastName: {
          description: "The realtor's last name.";
          type: 'string';
        };
        nrdsStatus: {
          description: "The realtor's NAR membership status. The value `active` verifies that the user is a current NAR member. Valid values are:\n\n- `Active`\n- `Inactive`\n- `Terminate`\n- `Provisional`\n- `Deceased`\n- `Suspend`\n- `Unknown`";
          type: 'string';
        };
        phoneticName: {
          description: 'The phonetic spelling of the `signatureName`.';
          type: 'string';
        };
        signature150ImageId: {
          description: "The ID of the user's signature image.";
          type: 'string';
        };
        signatureFont: {
          description: 'The font type to use for the signature if the signature is not drawn. The following font styles  are supported. The quotes are to indicate that these values are strings, not `enums`.\n\n- `"1_DocuSign"`\n- `"2_DocuSign"`\n- `"3_DocuSign"`\n- `"4_DocuSign"`\n- `"5_DocuSign"`\n- `"6_DocuSign"`\n- `"7_DocuSign"`\n- `"8_DocuSign"`\n- `"Mistral"`\n- `"Rage Italic"`\n';
          type: 'string';
        };
        signatureGroups: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureGroup';
          };
          type: 'array';
        };
        signatureId: {
          description: 'Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as "&", "<", ">") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.';
          type: 'string';
        };
        signatureImageUri: {
          description: "An endpoint URI that you can use to retrieve the user's signature image.";
          type: 'string';
        };
        signatureInitials: {
          description: "Specifies the user's signature in initials format.";
          type: 'string';
        };
        signatureName: {
          description: "Specifies the user's signature name.";
          type: 'string';
        };
        signatureRights: {
          description: 'The rights that the user has to the signature. Valid values are:\n\n- `none`\n- `read`\n- `admin`';
          type: 'string';
        };
        signatureType: {
          description: 'Specifies the type of signature.';
          type: 'string';
        };
        signatureUsers: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureUser';
          };
          type: 'array';
        };
        stampFormat: {
          description: "The format of a stamp. Valid values are:\n\n- `NameHanko`: The stamp represents only the signer's name.\n- `NameDateHanko`: The stamp represents the signer's name and the date. ";
          type: 'string';
        };
        stampImageUri: {
          description: "The URI for retrieving the image of the user's stamp.";
          type: 'string';
        };
        stampSizeMM: {
          description: 'The physical height of the stamp image (in millimeters) that the stamp vendor recommends for displaying the image in PDF documents.';
          type: 'string';
        };
        stampType: {
          description: 'The type of stamp. Valid values are:\n\n- `signature`: A signature image. This is the default value.\n- `stamp`: A stamp image.\n- null';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignature';
      'x-ms-summary': '';
    };
    accountSignatureDefinition: {
      description: '';
      properties: {
        dateStampProperties: {
          $ref: '#/components/schemas/dateStampProperties';
        };
        disallowUserResizeStamp: {
          description: 'When **true,** users may not resize the stamp.';
          type: 'string';
        };
        externalID: {
          description: "Optionally specify an external identifier for the user's signature.";
          type: 'string';
        };
        imageType: {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          type: 'string';
        };
        isDefault: {
          description: 'Boolean that specifies whether the signature is the default signature for the user.';
          type: 'string';
        };
        nrdsId: {
          description: 'The National Association of Realtors (NAR) membership ID for a user who is a realtor.';
          type: 'string';
        };
        nrdsLastName: {
          description: "The realtor's last name.";
          type: 'string';
        };
        phoneticName: {
          description: 'The phonetic spelling of the `signatureName`.';
          type: 'string';
        };
        signatureFont: {
          description: 'The font type to use for the signature if the signature is not drawn. The following font styles  are supported. The quotes are to indicate that these values are strings, not `enums`.\n\n- `"1_DocuSign"`\n- `"2_DocuSign"`\n- `"3_DocuSign"`\n- `"4_DocuSign"`\n- `"5_DocuSign"`\n- `"6_DocuSign"`\n- `"7_DocuSign"`\n- `"8_DocuSign"`\n- `"Mistral"`\n- `"Rage Italic"`\n';
          type: 'string';
        };
        signatureGroups: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureGroupDef';
          };
          type: 'array';
        };
        signatureId: {
          description: 'Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as "&", "<", ">") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.';
          type: 'string';
        };
        signatureInitials: {
          description: "Specifies the user's signature in initials format.";
          type: 'string';
        };
        signatureName: {
          description: "Specifies the user's signature name.";
          type: 'string';
        };
        signatureType: {
          description: 'Specifies the type of signature.';
          type: 'string';
        };
        signatureUsers: {
          description: '';
          items: {
            $ref: '#/components/schemas/signatureUserDef';
          };
          type: 'array';
        };
        stampFormat: {
          description: "The format of a stamp. Valid values are:\n\n- `NameHanko`: The stamp represents only the signer's name.\n- `NameDateHanko`: The stamp represents the signer's name and the date. ";
          type: 'string';
        };
        stampSizeMM: {
          description: 'The physical height of the stamp image (in millimeters) that the stamp vendor recommends for displaying the image in PDF documents.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignatureDefinition';
      'x-ms-summary': '';
    };
    accountSignatureProvider: {
      description: 'Contains information about the signature provider associated with the Identity Verification workflow.\nIf empty, then this specific workflow is not intended for signers.\n';
      properties: {
        isRequired: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        priority: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signatureProviderDisplayName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signatureProviderId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signatureProviderName: {
          description: 'The name of an Electronic or Standards Based Signature (digital signature) provider for the signer to use. For details, see [the current provider list](/docs/esign-rest-api/esign101/concepts/standards-based-signatures/). You can also retrieve the list by using the [AccountSignatureProviders: List](/docs/esign-rest-api/reference/accounts/accountsignatureproviders/list/) method.\n\nExample: `universalsignaturepen_default`\n\n';
          type: 'string';
        };
        signatureProviderOptionsMetadata: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/accountSignatureProviderOption';
          };
          type: 'array';
        };
        signatureProviderRequiredOptions: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/signatureProviderRequiredOption';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignatureProvider';
      'x-ms-summary': 'Contains information about the signature provider associated with the Identity Verification workflow.\nIf empty, then this specific workflow is not intended for signers.\n';
    };
    accountSignatureProviderOption: {
      description: 'Reserved for DocuSign.';
      properties: {
        signatureProviderOptionDisplayName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signatureProviderOptionId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signatureProviderOptionName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignatureProviderOption';
      'x-ms-summary': 'Reserved for DocuSign.';
    };
    accountSignatureProviders: {
      description: '';
      properties: {
        signatureProviders: {
          description: 'Names of electronic or digital signature providers that can be used.';
          items: {
            $ref: '#/components/schemas/accountSignatureProvider';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignatureProviders';
      'x-ms-summary': '';
    };
    accountSignaturesInformation: {
      description: '';
      properties: {
        accountSignatures: {
          description: '';
          items: {
            $ref: '#/components/schemas/accountSignature';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountSignaturesInformation';
      'x-ms-summary': '';
    };
    accountUISettings: {
      description: 'An object that defines the options that are available to non-administrators in the UI.';
      properties: {
        adminMessage: {
          $ref: '#/components/schemas/adminMessage';
        };
        askAnAdmin: {
          $ref: '#/components/schemas/askAnAdmin';
        };
        clickwrapSchemaVersion: {
          description: '';
          type: 'string';
        };
        clickwrapSchemaVersionMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableAdminMessage: {
          description: '';
          type: 'string';
        };
        enableAdminMessageMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEasySignCanUseMultiTemplateApply: {
          description: '';
          type: 'string';
        };
        enableEasySignCanUseMultiTemplateApplyMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEasySignTemplateUpload: {
          description: '';
          type: 'string';
        };
        enableEasySignTemplateUploadMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableEnvelopeCopyWithData: {
          description: '';
          type: 'string';
        };
        enableEnvelopeCopyWithDataMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        enableLegacySendflowLink: {
          description: '';
          type: 'string';
        };
        enableLegacySendflowLinkMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hasExternalLinkedAccounts: {
          description: '';
          type: 'string';
        };
        hasExternalLinkedAccountsMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hideSendAnEnvelope: {
          description: '';
          type: 'string';
        };
        hideSendAnEnvelopeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hideUseATemplate: {
          description: 'When **true,** the **Templates** menu is hidden from account users who are not Admins. The default value is **false.**';
          type: 'string';
        };
        hideUseATemplateInPrepare: {
          description: '';
          type: 'string';
        };
        hideUseATemplateInPrepareMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        hideUseATemplateMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        orderBasedRecipientIdGeneration: {
          description: '';
          type: 'string';
        };
        orderBasedRecipientIdGenerationMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        removeEnvelopeForwarding: {
          description: '';
          type: 'string';
        };
        removeEnvelopeForwardingMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        shouldRedactAccessCode: {
          description: '';
          type: 'string';
        };
        shouldRedactAccessCodeMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        uploadNewImageToSignOrInitial: {
          description: '';
          type: 'string';
        };
        uploadNewImageToSignOrInitialMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'accountUISettings';
      'x-ms-summary': 'An object that defines the options that are available to non-administrators in the UI.';
    };
    addOn: {
      description: 'Contains information about add ons.';
      properties: {
        active: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        addOnId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        name: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'addOn';
      'x-ms-summary': 'Contains information about add ons.';
    };
    addressInformation: {
      description: 'Contains address information.';
      properties: {
        address1: {
          description: "The first line of the user's address.\nMaximum length: 100 characters.";
          type: 'string';
        };
        address2: {
          description: "The second line of the user's address.\nMaximum length: 100 characters.";
          type: 'string';
        };
        city: {
          description: "The user's city. Maximum length: 40 characters.";
          type: 'string';
        };
        country: {
          description: "The user's country. Maximum length: 50 characters.";
          type: 'string';
        };
        fax: {
          description: 'A fax number associated with the address, if one is available.';
          type: 'string';
        };
        phone: {
          description: 'A phone number associated with the address.';
          type: 'string';
        };
        postalCode: {
          description: "The user's postal code. Maximum length: 20 characters.";
          type: 'string';
        };
        stateOrProvince: {
          description: "The user's state or province. Maximum length: 40 characters.";
          type: 'string';
        };
        zipPlus4: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'addressInformation';
      'x-ms-summary': 'Contains address information.';
    };
    addressInformationInput: {
      description: 'Contains address input information.';
      properties: {
        addressInformation: {
          $ref: '#/components/schemas/addressInformation';
        };
        displayLevelCode: {
          description: 'Specifies the display level for the recipient. Valid values are:\n* `ReadOnly`\n* `Editable`\n* `DoNotDisplay`';
          type: 'string';
        };
        receiveInResponse: {
          description: 'A Boolean value that specifies whether the information must be returned in the response.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'addressInformationInput';
      'x-ms-summary': 'Contains address input information.';
    };
    adminMessage: {
      description: '';
      properties: {
        baseMessage: {
          description: '';
          type: 'string';
        };
        moreInformation: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'adminMessage';
      'x-ms-summary': '';
    };
    agent: {
      description: 'Contains information about an agent recipient. An agent is a recipient who can add name and email information for recipients that appear after the agent in routing order.';
      properties: {
        accessCode: {
          description: "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and it must conform to the account's access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then the access code is not required.";
          type: 'string';
        };
        accessCodeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        addAccessCodeToEmail: {
          description: 'Optional. When **true,** the access code will be added to the email sent to the recipient. This nullifies the security measure of `accessCode` on the recipient.';
          type: 'string';
        };
        additionalNotifications: {
          description: 'An array of additional notification objects.';
          items: {
            $ref: '#/components/schemas/recipientAdditionalNotification';
          };
          type: 'array';
        };
        allowSystemOverrideForLockedRecipient: {
          description: 'When **true,** if the recipient is locked on a template, advanced recipient routing can override the lock.';
          type: 'string';
        };
        autoRespondedReason: {
          description: 'Error message provided by the destination email system. This field is only provided if the email notification to the recipient fails to send. This property is read-only.\n';
          type: 'string';
        };
        bulkSendV2Recipient: {
          description: '';
          type: 'string';
        };
        clientUserId: {
          description: 'Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Use this field to associate the signer with their userId in your app. Authenticating the user is the responsibility of your app when you use embedded signing.\n\nIf the `clientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true,** an error is generated on sending.\n\n**Note:** This property is not returned by the [listStatusChanges](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/) endpoint.\n\nMaximum length: 100 characters. \n';
          type: 'string';
        };
        completedCount: {
          description: 'Indicates the number of times that the recipient has been through a signing completion for the envelope. If this number is greater than 0 for a signing group, only the user who previously completed may sign again. This property is read-only.';
          type: 'string';
        };
        consentDetailsList: {
          description: '';
          items: {
            $ref: '#/components/schemas/consentDetails';
          };
          type: 'array';
        };
        customFields: {
          description: 'An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        declinedDateTime: {
          description: 'The date and time the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        declinedReason: {
          description: 'The reason the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        deliveredDateTime: {
          description: 'The date and time that the envelope was delivered to the recipient. This property is read-only.';
          type: 'string';
        };
        deliveryMethod: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        deliveryMethodMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        designatorId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        designatorIdGuid: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        documentVisibility: {
          description: 'A list of `documentVisibility` objects. Each object in the list specifies whether a document in the envelope is visible to this recipient. For the envelope to use this functionality, Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true.**';
          items: {
            $ref: '#/components/schemas/documentVisibility';
          };
          type: 'array';
        };
        email: {
          description: 'The email ID of the agent. Notification of the document to sign is sent to this email id. \n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        emailMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        emailNotification: {
          $ref: '#/components/schemas/recipientEmailNotification';
        };
        emailRecipientPostSigningURL: {
          description: '';
          type: 'string';
        };
        embeddedRecipientStartURL: {
          description: "Specifies a sender-provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nWhen `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation launched by a partner.\n\nIt is important to understand that in a typical embedded workflow, the authentication of an embedded recipient is the responsibility of the sending application. DocuSign expects that senders will follow their own processes for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process is initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process, bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: `envelopeId`, `recipientId`, `recipientName`, `recipientEmail`, and `customFields`. The `customFields` property must be set for the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ";
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        excludedDocuments: {
          description: 'Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.\n\nWhen enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        faxNumber: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        faxNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        firstName: {
          description: "The recipient's first name. Maximum Length: 50 characters.";
          type: 'string';
        };
        firstNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fullName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        fullNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckConfigurationName: {
          description: 'The name of the authentication check to use. This value must match one of the authentication types that the account uses. The names of these authentication types appear in the web console sending interface in the Identify list for a recipient. This setting overrides any default authentication setting. Valid values are:\n\n- `Phone Auth $`: The recipient must authenticate by using two-factor authentication (2FA). You provide the phone number to use for 2FA in the `phoneAuthentication` object.\n- `SMS Auth $`: The recipient must authenticate via SMS. You provide the phone number to use in the `smsAuthentication` object.\n- `ID Check $`: The  recipient must answer detailed security questions. \n\n**Example:** Your account has ID Check and SMS Authentication available. In the web console Identify list, these appear as ID Check $ and SMS Auth $. To use ID Check in an envelope, the idCheckConfigurationName should be ID Check $. For SMS, you would use SMS Auth $, and you would also need to add a phone number to the smsAuthentication node.';
          type: 'string';
        };
        idCheckConfigurationNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckInformationInput: {
          $ref: '#/components/schemas/idCheckInformationInput';
        };
        identityVerification: {
          $ref: '#/components/schemas/recipientIdentityVerification';
        };
        inheritEmailNotificationConfiguration: {
          description: "When **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ";
          type: 'string';
        };
        lastName: {
          description: "The recipient's last name.";
          type: 'string';
        };
        lastNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        lockedRecipientPhoneAuthEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lockedRecipientSmsEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The full legal name of the recipient. Maximum Length: 100 characters.\n\n**Note:** You must always set a value for this property in requests, even if `firstName` and `lastName` are set.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        note: {
          description: 'A note sent to the recipient in the signing email.\nThis note is unique to this recipient.\nIn the user interface,\nit appears near the upper left corner\nof the document\non the signing screen.\n\nMaximum Length: 1000 characters.\n';
          type: 'string';
        };
        noteMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        phoneAuthentication: {
          $ref: '#/components/schemas/recipientPhoneAuthentication';
        };
        phoneNumber: {
          $ref: '#/components/schemas/recipientPhoneNumber';
        };
        recipientAttachments: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/recipientAttachment';
          };
          type: 'array';
        };
        recipientAuthenticationStatus: {
          $ref: '#/components/schemas/authenticationStatus';
        };
        recipientFeatureMetadata: {
          description: 'Metadata about the features that are supported for the recipient type. This property is read-only.';
          items: {
            $ref: '#/components/schemas/featureAvailableMetadata';
          };
          type: 'array';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientType: {
          description: "The recipient type, as specified by the following values:\n- `agent`: Agent recipients can add name and email information for recipients that appear after the agent in routing order.\n- `carbonCopy`: Carbon copy recipients get a copy of the envelope but don't need to sign, initial, date, or add information to any of the documents. This type of recipient can be used in any routing order.\n- `certifiedDelivery`: Certified delivery recipients must receive the completed documents for the envelope to be completed. They don't need to sign, initial, date, or add information to any of the documents.\n- `editor`: Editors have the same management and access rights for the envelope as the sender. Editors can add name and email information, add or change the routing order, set authentication options, and can edit signature/initial tabs and data fields for the remaining recipients.\n- `inPersonSigner`: In-person recipients are DocuSign users who act as signing hosts in the same physical location as the signer.\n- `intermediaries`: Intermediary recipients can optionally add name and email information for recipients at the same or subsequent level in the routing order.\n- `seal`: Electronic seal recipients represent legal entities.\n- `signer`: Signers are recipients who must sign, initial, date, or add data to form fields on the documents in the envelope.\n- `witness`: Witnesses are recipients whose signatures affirm that the identified signers have signed the documents in the envelope.";
          type: 'string';
        };
        recipientTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireIdLookup: {
          description: 'When **true,** the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ';
          type: 'string';
        };
        requireIdLookupMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        roleName: {
          description: 'Optional element. Specifies the role name associated with the recipient.<br/><br/>This property is required when you are working with template recipients.';
          type: 'string';
        };
        routingOrder: {
          description: 'Specifies the routing order of the recipient in the envelope. ';
          type: 'string';
        };
        routingOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        signedDateTime: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        signingGroupIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
        signingGroupUsers: {
          description: 'A complex type that contains information about users in the signing group.';
          items: {
            $ref: '#/components/schemas/userInfo';
          };
          type: 'array';
        };
        smsAuthentication: {
          $ref: '#/components/schemas/recipientSMSAuthentication';
        };
        socialAuthentications: {
          description: 'Deprecated.';
          items: {
            $ref: '#/components/schemas/socialAuthentication';
          };
          type: 'array';
        };
        status: {
          description: "The recipient's status. This property is read-only. \n\nValid values:\n\n- `autoresponded`: The recipient's email system auto-responded to the email from DocuSign. This status is used in the web console to inform senders about the bounced-back email. This recipient status is only used if **Send-on-behalf-of** is turned off for the account.\n- `completed`: The recipient has completed their actions (signing or other required actions if not a signer) for an envelope.\n- `created`: The recipient is in a draft state. This value is only associated with draft envelopes (envelopes that have a status of `created`).\n- `declined`: The recipient declined to sign the documents in the envelope.\n- `delivered`: The recipient has viewed the documents in an envelope through the DocuSign signing website. This is not an email delivery of the documents in an envelope.\n- `faxPending`: The recipient has finished signing and the system is waiting for a fax attachment from the recipient before completing their signing step.\n- `sent`: The recipient has been sent an email notification that it is their turn to sign an envelope.\n- `signed`: The recipient has completed (signed) all required tags in an envelope. This is a temporary state during processing, after which the recipient's status automatically switches to `completed`.";
          type: 'string';
        };
        statusCode: {
          description: "The code associated with the recipient's status. This property is read-only.";
          type: 'string';
        };
        suppressEmails: {
          description: 'When **true,** email notifications are suppressed for the recipient, and they must access envelopes and documents from their DocuSign inbox.';
          type: 'string';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        totalTabCount: {
          description: 'The total number of tabs in the documents. This property is read-only.';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'agent';
      'x-ms-summary': 'Contains information about an agent recipient. An agent is a recipient who can add name and email information for recipients that appear after the agent in routing order.';
    };
    apiRequestLog: {
      description: 'Contains API request log information.';
      properties: {
        createdDateTime: {
          description: 'The UTC DateTime when the item was created.';
          type: 'string';
        };
        description: {
          description: 'The API endpoint that was called.';
          type: 'string';
        };
        requestLogId: {
          description: 'The ID of the log entry.';
          type: 'string';
        };
        status: {
          description: 'The status of the API request.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'apiRequestLog';
      'x-ms-summary': 'Contains API request log information.';
    };
    apiRequestLogsResult: {
      description: 'Contains information about multiple API request logs.';
      properties: {
        apiRequestLogs: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/apiRequestLog';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'apiRequestLogsResult';
      'x-ms-summary': 'Contains information about multiple API request logs.';
    };
    appStoreProduct: {
      description: 'Contains information about an APP store product.';
      properties: {
        marketPlace: {
          description: '';
          type: 'string';
        };
        productId: {
          description: 'The Product ID from the AppStore.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'appStoreProduct';
      'x-ms-summary': 'Contains information about an APP store product.';
    };
    appStoreReceipt: {
      description: 'Contains information about an APP store receipt.';
      properties: {
        downgradeProductId: {
          description: '';
          type: 'string';
        };
        isDowngradeCancellation: {
          description: '';
          type: 'string';
        };
        productId: {
          description: 'The Product ID from the AppStore.';
          type: 'string';
        };
        receiptData: {
          description: 'Reserved: TBD';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'appStoreReceipt';
      'x-ms-summary': 'Contains information about an APP store receipt.';
    };
    approve: {
      description: 'A tab that allows the recipient to approve documents\nwithout placing a signature or initials on the\ndocument.\n';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        buttonText: {
          description: ' Specifies the approval text that displays in the tab. ';
          type: 'string';
        };
        buttonTextMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. You can only use this when adding new tabs for a recipient. When used, the new tab inherits all of the properties of the custom tab.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located. For supplemental documents, this value must be `1`.\n';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: '**Note:** Approve tabs never display this tooltip in the signing interface.\n\nAlthough you can technically set a value via the API for this tab,\nit will not be displayed to the recipient.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'approve';
      'x-ms-summary': 'A tab that allows the recipient to approve documents\nwithout placing a signature or initials on the\ndocument.\n';
    };
    askAnAdmin: {
      description: '';
      properties: {
        email: {
          description: '';
          type: 'string';
        };
        message: {
          description: '';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        phone: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'askAnAdmin';
      'x-ms-summary': '';
    };
    attachment: {
      description: 'Contains information about an attachment.';
      properties: {
        accessControl: {
          description: 'Valid values are `sender` and `senderAndAllRecipients`.';
          type: 'string';
        };
        attachmentId: {
          description: 'The unique identifier for the attachment.';
          type: 'string';
        };
        attachmentType: {
          description: 'Specifies the type of the attachment for the recipient.';
          type: 'string';
        };
        data: {
          description: 'A Base64-encoded representation of the attachment that is used to upload and download the file. File attachments may be up to 50 MB in size.';
          type: 'string';
        };
        label: {
          description: 'A label for the attachment. Potential values include: \n\n- `guidedForm`: [Guided forms](https://www.docusign.com/products/guided-forms) provide a step-by-step, mobile-ready experience to help signers easily complete long or complex forms.\n- `eventNotifications`: A list of envelope-level event statuses that trigger Connect to send updates to the endpoint specified in the `url` property. \n';
          type: 'string';
        };
        name: {
          description: 'The name of the attachment.';
          type: 'string';
        };
        remoteUrl: {
          description: 'The URL of a previously staged chunked upload. Using a chunked upload enables you to stage a large, chunkable temp file. You then use the `remoteUrl` property to reference the chunked upload as the content in attachment and document-related requests. The `remoteUrl` property cannot be used for downloads.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'attachment';
      'x-ms-summary': 'Contains information about an attachment.';
    };
    authenticationMethod: {
      description: 'Contains information about the method used for authentication.';
      properties: {
        authenticationType: {
          description: 'Indicates the type of authentication. Valid values are: PhoneAuth, STAN, ISCheck, OFAC, AccessCode, AgeVerify, or SSOAuth. ';
          type: 'string';
        };
        lastProvider: {
          description: 'The last provider that authenticated the user. ';
          type: 'string';
        };
        lastTimestamp: {
          description: ' The data and time the user last used the authentication method. ';
          type: 'string';
        };
        totalCount: {
          description: 'The number of times the authentication method was used. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'authenticationMethod';
      'x-ms-summary': 'Contains information about the method used for authentication.';
    };
    authenticationStatus: {
      description: "A complex element that contains information about a user's authentication status.";
      properties: {
        accessCodeResult: {
          $ref: '#/components/schemas/eventResult';
        };
        ageVerifyResult: {
          $ref: '#/components/schemas/eventResult';
        };
        anySocialIDResult: {
          $ref: '#/components/schemas/eventResult';
        };
        facebookResult: {
          $ref: '#/components/schemas/eventResult';
        };
        googleResult: {
          $ref: '#/components/schemas/eventResult';
        };
        idLookupResult: {
          $ref: '#/components/schemas/eventResult';
        };
        idQuestionsResult: {
          $ref: '#/components/schemas/eventResult';
        };
        identityVerificationResult: {
          $ref: '#/components/schemas/eventResult';
        };
        linkedinResult: {
          $ref: '#/components/schemas/eventResult';
        };
        liveIDResult: {
          $ref: '#/components/schemas/eventResult';
        };
        ofacResult: {
          $ref: '#/components/schemas/eventResult';
        };
        openIDResult: {
          $ref: '#/components/schemas/eventResult';
        };
        phoneAuthResult: {
          $ref: '#/components/schemas/eventResult';
        };
        sTANPinResult: {
          $ref: '#/components/schemas/eventResult';
        };
        salesforceResult: {
          $ref: '#/components/schemas/eventResult';
        };
        signatureProviderResult: {
          $ref: '#/components/schemas/eventResult';
        };
        smsAuthResult: {
          $ref: '#/components/schemas/eventResult';
        };
        twitterResult: {
          $ref: '#/components/schemas/eventResult';
        };
        yahooResult: {
          $ref: '#/components/schemas/eventResult';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'authenticationStatus';
      'x-ms-summary': "A complex element that contains information about a user's authentication status.";
    };
    authorizationUser: {
      description: '';
      properties: {
        accountId: {
          description: 'The account ID associated with the envelope.';
          type: 'string';
        };
        email: {
          description: '';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'authorizationUser';
      'x-ms-summary': '';
    };
    bccEmailAddress: {
      description: 'Contains information about the BCC email address.';
      properties: {
        bccEmailAddressId: {
          description: "Only users with canManageAccount setting can use this option. An array of up to 5 email addresses the envelope is sent to as a BCC email. \n \nExample: If your account has BCC for Email Archive set up for the email address 'archive@mycompany.com' and you send an envelope using the BCC Email Override to send a BCC email to 'salesarchive@mycompany.com', then a copy of the envelope is only sent to the 'salesarchive@mycompany.com' email address.";
          type: 'string';
        };
        email: {
          description: 'Specifies the BCC email address. DocuSign verifies that the email format is correct, but does not verify that the email is active.Using this overrides the BCC for Email Archive information setting for this envelope.\n\nMaximum of length: 100 characters. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bccEmailAddress';
      'x-ms-summary': 'Contains information about the BCC email address.';
    };
    bccEmailArchive: {
      description: 'This object contains information abut a BCC email archive configuration (a BCC email address used to archive DocuSign-generated emails).';
      properties: {
        accountId: {
          description: 'The ID of the account that owns the BCC email archive configuration.';
          type: 'string';
        };
        bccEmailArchiveId: {
          description: 'The ID of the BCC email archive configuration.';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the BCC email archive configuration was created.';
          type: 'string';
        };
        createdBy: {
          $ref: '#/components/schemas/userInfo';
        };
        email: {
          description: 'The BCC email address to use for archiving DocuSign messages.\n\nExample: customer_bcc@example.com';
          type: 'string';
        };
        emailNotificationId: {
          description: 'The GUID of the activation email message sent to the BCC email address.';
          type: 'string';
        };
        modified: {
          description: 'The UTC DateTime when the BCC email archive configuration was last modified.';
          type: 'string';
        };
        modifiedBy: {
          $ref: '#/components/schemas/userInfo';
        };
        status: {
          description: 'The status of the BCC email address. Possible values are:\n\n- `activation_sent`: An activation link has been sent to the BCC email address.\n- `active`: The BCC email address is actively used for archiving.\n- `closed`: The BCC email address is no longer used for archiving.';
          type: 'string';
        };
        uri: {
          description: 'The helper URI for retrieving the BCC email archive.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bccEmailArchive';
      'x-ms-summary': 'This object contains information abut a BCC email archive configuration (a BCC email address used to archive DocuSign-generated emails).';
    };
    bccEmailArchiveHistory: {
      description: 'Contains details about the history of the BCC email archive configuration.';
      properties: {
        accountId: {
          description: 'The ID of the account that owns the BCC email archive configuration.';
          type: 'string';
        };
        action: {
          description: 'The action taken on the BCC email archive configuration.\n\nExamples: \n\n- `CREATED`: The BCC email archive configuration has been created.\n- `UPDATED`: The BCC email address has been activated by clicking on the activation link in the activation email message.\n- `CLOSED`: The BCC email address has been marked as closed is no longer used for archiving.';
          type: 'string';
        };
        email: {
          description: 'The BCC email address used to archive the emails that DocuSign generates. \n\nExample: customer_bcc@example.com';
          type: 'string';
        };
        modified: {
          description: 'The UTC DateTime when the BCC email address was last modified.';
          type: 'string';
        };
        modifiedBy: {
          $ref: '#/components/schemas/userInfo';
        };
        status: {
          description: 'The status of the BCC email address. Possible values are:\n\n- `activation_sent`: An activation link has been sent to the BCC email address.\n- `active`: The BCC email address is actively used for archiving.\n- `closed`: The BCC email address is no longer used for archiving.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bccEmailArchiveHistory';
      'x-ms-summary': 'Contains details about the history of the BCC email archive configuration.';
    };
    bccEmailArchiveHistoryList: {
      description: '';
      properties: {
        bccEmailArchiveHistory: {
          description: 'A list of changes to the BCC email archive configuration.';
          items: {
            $ref: '#/components/schemas/bccEmailArchiveHistory';
          };
          type: 'array';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bccEmailArchiveHistoryList';
      'x-ms-summary': '';
    };
    bccEmailArchiveList: {
      description: 'Contains a list of BCC email archive configurations.';
      properties: {
        bccEmailArchives: {
          description: 'A list of  BCC email archive configurations.';
          items: {
            $ref: '#/components/schemas/bccEmailArchive';
          };
          type: 'array';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bccEmailArchiveList';
      'x-ms-summary': 'Contains a list of BCC email archive configurations.';
    };
    billingCharge: {
      description: 'Contains information about a billing charge.';
      properties: {
        allowedQuantity: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        blocked: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        chargeName: {
          description: 'Provides information on what services the charge item is for.\n\nThe following table provides a description of the different chargeName values available at this time.\n\n| chargeName | Description |\n| --- | --- |\n| id_check | ID Check Charge |\n| in_person_signing | In Person Signing charge |\n| envelopes Included | Sent Envelopes for the account |\n| age_verify | Age verification check |\n| ofac | OFAC Check |\n| id_confirm | ID confirmation check |\n| student_authentication | STAN PIN authentication check |\n| wet_sign_fax | Pages for returning signed documents by fax |\n| attachment_fax | Pages for returning attachments by fax |\n| phone_authentication | Phone authentication charge |\n| powerforms | PowerForm envelopes sent |\n| signer_payments | Payment processing charge |\n| outbound_fax | Send by fax charge |\n| bulk_recipient_envelopes | Bulk Recipient Envelopes sent |\n| sms_authentications | SMS authentication charge |\n| saml_authentications | SAML authentication charge |\n| express_signer_certificate | DocuSign Express Certificate charge |\n| personal_signer_certificate | Personal Signer Certificate charge |\n| safe_certificate | SAFE BioPharma Signer Certificate charge |\n| seats | Included active seats charge |\n| open_trust_certificate | OpenTrust Signer Certificate charge |';
          type: 'string';
        };
        chargeType: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        chargeUnitOfMeasure: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        discounts: {
          description: '';
          items: {
            $ref: '#/components/schemas/billingDiscount';
          };
          type: 'array';
        };
        firstEffectiveDate: {
          description: '';
          type: 'string';
        };
        includedQuantity: {
          description: '';
          type: 'string';
        };
        incrementalQuantity: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        lastEffectiveDate: {
          description: '';
          type: 'string';
        };
        prices: {
          description: '';
          items: {
            $ref: '#/components/schemas/billingPrice';
          };
          type: 'array';
        };
        unitPrice: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        usedQuantity: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingCharge';
      'x-ms-summary': 'Contains information about a billing charge.';
    };
    billingChargeResponse: {
      description: 'Defines a billing charge response object.';
      properties: {
        billingChargeItems: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingCharge';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingChargeResponse';
      'x-ms-summary': 'Defines a billing charge response object.';
    };
    billingDiscount: {
      description: '';
      properties: {
        beginQuantity: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        discount: {
          description: '';
          type: 'string';
        };
        endQuantity: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingDiscount';
      'x-ms-summary': '';
    };
    billingEntityInformationResponse: {
      description: '';
      properties: {
        billingProfile: {
          description: 'The type of billing method on the account. Valid values are: \n\n- `direct`\n- `web`';
          type: 'string';
        };
        entityName: {
          description: '';
          type: 'string';
        };
        externalEntityId: {
          description: '';
          type: 'string';
        };
        isExternallyBilled: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingEntityInformationResponse';
      'x-ms-summary': '';
    };
    billingInvoice: {
      description: 'Contains information about a billing invoice.';
      properties: {
        amount: {
          description: 'The total amount of the purchase.';
          type: 'string';
        };
        balance: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        dueDate: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceId: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceItems: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingInvoiceItem';
          };
          type: 'array';
        };
        invoiceNumber: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceUri: {
          description: 'Contains a URI for an endpoint that you can use to retrieve invoice information.';
          type: 'string';
        };
        nonTaxableAmount: {
          description: '';
          type: 'string';
        };
        pdfAvailable: {
          description: '';
          type: 'string';
        };
        taxableAmount: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingInvoice';
      'x-ms-summary': 'Contains information about a billing invoice.';
    };
    billingInvoiceItem: {
      description: 'Contains information about an item on a billing invoice.';
      properties: {
        chargeAmount: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        chargeName: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceItemId: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        quantity: {
          description: 'The quantity of envelopes to add to the account.';
          type: 'string';
        };
        taxAmount: {
          description: '';
          type: 'string';
        };
        taxExemptAmount: {
          description: '';
          type: 'string';
        };
        unitPrice: {
          description: 'Reserved: TBD';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingInvoiceItem';
      'x-ms-summary': 'Contains information about an item on a billing invoice.';
    };
    billingInvoicesResponse: {
      description: 'Defines a billing invoice response object.';
      properties: {
        billingInvoices: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingInvoice';
          };
          type: 'array';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingInvoicesResponse';
      'x-ms-summary': 'Defines a billing invoice response object.';
    };
    billingInvoicesSummary: {
      description: '';
      properties: {
        accountBalance: {
          description: '';
          type: 'string';
        };
        billingInvoices: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingInvoice';
          };
          type: 'array';
        };
        currencyCode: {
          description: 'The currency code for the account, based on the [ISO 4217 currency code](https://www.iso.org/iso-4217-currency-codes.html).';
          type: 'string';
        };
        pastDueBalance: {
          description: '';
          type: 'string';
        };
        paymentAllowed: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingInvoicesSummary';
      'x-ms-summary': '';
    };
    billingPayment: {
      description: 'Contains information on a billing plan.';
      properties: {
        amount: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        invoiceId: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        paymentId: {
          description: 'The ID of the payment.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPayment';
      'x-ms-summary': 'Contains information on a billing plan.';
    };
    billingPaymentItem: {
      description: 'Defines a billing payment request object.';
      properties: {
        amount: {
          description: 'The total amount of the purchase.';
          type: 'string';
        };
        description: {
          description: 'A sender-defined description of the line item.\n';
          type: 'string';
        };
        paymentDate: {
          description: '';
          type: 'string';
        };
        paymentId: {
          description: 'The ID of the payment.';
          type: 'string';
        };
        paymentNumber: {
          description: 'When **true,** a PDF version of the invoice is available. \n\nTo get the PDF, make the call again and change "Accept:" in the header to "Accept: application/pdf".';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPaymentItem';
      'x-ms-summary': 'Defines a billing payment request object.';
    };
    billingPaymentRequest: {
      description: '';
      properties: {
        paymentAmount: {
          description: 'The payment amount for the past due invoices. This value must match the pastDueBalance value retrieved using Get Past Due Invoices.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPaymentRequest';
      'x-ms-summary': '';
    };
    billingPaymentResponse: {
      description: 'Defines an billing payment response object.';
      properties: {
        billingPayments: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingPayment';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPaymentResponse';
      'x-ms-summary': 'Defines an billing payment response object.';
    };
    billingPaymentsResponse: {
      description: 'Defines a billing payments response object.';
      properties: {
        billingPayments: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingPaymentItem';
          };
          type: 'array';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPaymentsResponse';
      'x-ms-summary': 'Defines a billing payments response object.';
    };
    billingPlan: {
      description: 'Contains information about a billing plan.';
      properties: {
        appStoreProducts: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/appStoreProduct';
          };
          type: 'array';
        };
        currencyPlanPrices: {
          description: 'Contains the `currencyCode` and `currencySymbol` for the alternate currency values for `envelopeFee`, `fixedFee`, and `seatFee` that are configured for this plan feature set.';
          items: {
            $ref: '#/components/schemas/currencyPlanPrice';
          };
          type: 'array';
        };
        enableSupport: {
          description: 'When **true,** customer support is provided as part of the account plan.';
          type: 'string';
        };
        includedSeats: {
          description: 'The number of seats (users) included in the plan.';
          type: 'string';
        };
        otherDiscountPercent: {
          description: 'Any other percentage discount for the plan.\n\nExample: `"0.00"`';
          type: 'string';
        };
        paymentCycle: {
          description: ' The payment cycle associated with the plan. Valid values: Monthly or Annually. ';
          type: 'string';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        perSeatPrice: {
          description: 'The per seat price for the plan.';
          type: 'string';
        };
        planClassification: {
          description: 'Identifies the type of plan. Examples include:\n\n- `business`\n- `corporate`\n- `enterprise` \n- `free`';
          type: 'string';
        };
        planFeatureSets: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/featureSet';
          };
          type: 'array';
        };
        planId: {
          description: "DocuSign's ID for the account plan.";
          type: 'string';
        };
        planName: {
          description: 'The name of the billing plan.\n';
          type: 'string';
        };
        seatDiscounts: {
          description: 'A complex type that returns information about any seat discounts. It contains the information `BeginSeatCount`, `EndSeatCount` and `SeatDiscountPercent`.';
          items: {
            $ref: '#/components/schemas/seatDiscount';
          };
          type: 'array';
        };
        supportIncidentFee: {
          description: 'The support incident fee charged for each support incident.\n\nExample: `"$0.00"`';
          type: 'string';
        };
        supportPlanFee: {
          description: 'The support plan fee charged for this plan.\n\nExample: `"$0.00"`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlan';
      'x-ms-summary': 'Contains information about a billing plan.';
    };
    billingPlanInformation: {
      description: 'This object contains details about a billing plan.';
      properties: {
        appStoreReceipt: {
          $ref: '#/components/schemas/appStoreReceipt';
        };
        billingAddress: {
          $ref: '#/components/schemas/accountAddress';
        };
        creditCardInformation: {
          $ref: '#/components/schemas/creditCardInformation';
        };
        directDebitProcessorInformation: {
          $ref: '#/components/schemas/directDebitProcessorInformation';
        };
        downgradeReason: {
          description: "(Optional) The user's reason for downgrading their billing plan.";
          type: 'string';
        };
        enablePreAuth: {
          description: '';
          type: 'string';
        };
        enableSupport: {
          description: 'When **true,** customer support is provided as part of the account plan.';
          type: 'string';
        };
        includedSeats: {
          description: 'The number of seats (users) included in the plan.';
          type: 'string';
        };
        incrementalSeats: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        paymentProcessor: {
          description: '';
          type: 'string';
        };
        paymentProcessorInformation: {
          $ref: '#/components/schemas/paymentProcessorInformation';
        };
        planInformation: {
          $ref: '#/components/schemas/planInformation';
        };
        processPayment: {
          description: '';
          type: 'string';
        };
        referralInformation: {
          $ref: '#/components/schemas/referralInformation';
        };
        renewalStatus: {
          description: 'The renewal status of the account. Possible values are:\n\n- `auto`: The account automatically renews. \n- `queued_for_close`: The account will be closed at the billingPeriodEndDate. \n- queued_for_downgrade`: The account will be downgraded at the `billingPeriodEndDate`.';
          type: 'string';
        };
        saleDiscountAmount: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        saleDiscountFixedAmount: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        saleDiscountPercent: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        saleDiscountPeriods: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        saleDiscountSeatPriceOverride: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        taxExemptId: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlanInformation';
      'x-ms-summary': 'This object contains details about a billing plan.';
    };
    billingPlanPreview: {
      description: 'Information used to provide a preview of a billing plan.';
      properties: {
        currencyCode: {
          description: 'Specifies the ISO currency code for the account.';
          type: 'string';
        };
        invoice: {
          $ref: '#/components/schemas/billingInvoice';
        };
        isProrated: {
          description: 'When **true,** the billing plan is prorated.';
          type: 'string';
        };
        subtotalAmount: {
          description: '';
          type: 'string';
        };
        taxAmount: {
          description: '';
          type: 'string';
        };
        totalAmount: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlanPreview';
      'x-ms-summary': 'Information used to provide a preview of a billing plan.';
    };
    billingPlanResponse: {
      description: 'Defines a billing plan response object.';
      properties: {
        billingPlan: {
          $ref: '#/components/schemas/billingPlan';
        };
        successorPlans: {
          description: 'A list of billing plans that the current billing plan can be rolled into.';
          items: {
            $ref: '#/components/schemas/billingPlan';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlanResponse';
      'x-ms-summary': 'Defines a billing plan response object.';
    };
    billingPlanUpdateResponse: {
      description: 'Defines a billing plan update response object.';
      properties: {
        accountPaymentMethod: {
          description: 'The type of payment method used for the account. Valid values are:\n\n- `credit_card`\n- ';
          type: 'string';
        };
        billingPlanPreview: {
          $ref: '#/components/schemas/billingPlanPreview';
        };
        currencyCode: {
          description: 'Specifies the ISO currency code for the account.';
          type: 'string';
        };
        includedSeats: {
          description: 'The number of seats (users) included in the plan.';
          type: 'string';
        };
        paymentCycle: {
          description: 'The payment cycle associated with the plan. Valid values: \n\n- `Monthly`\n- `Annually` ';
          type: 'string';
        };
        paymentMethod: {
          description: 'The payment method used for the billing plan. Valid values are:\n\n- `NotSupported`\n- `CreditCard`\n- `PurchaseOrder`\n- `Premium`\n- `Freemium`\n- `FreeTrial`\n- `AppStore`\n- `DigitalExternal`\n- `DirectDebit`';
          type: 'string';
        };
        planId: {
          description: "DocuSign's ID for the account plan.";
          type: 'string';
        };
        planName: {
          description: 'The name of the billing plan used for the account.\n\nExamples: \n\n- `Personal - Annual`\n- `Unlimited Envelope Subscription - Annual Billing`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlanUpdateResponse';
      'x-ms-summary': 'Defines a billing plan update response object.';
    };
    billingPlansResponse: {
      description: 'Defines a billing plans response object.';
      properties: {
        billingPlans: {
          description: 'Reserved: TBD';
          items: {
            $ref: '#/components/schemas/billingPlan';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPlansResponse';
      'x-ms-summary': 'Defines a billing plans response object.';
    };
    billingPrice: {
      description: '';
      properties: {
        beginQuantity: {
          description: 'Reserved: TBD';
          type: 'string';
        };
        endQuantity: {
          description: '';
          type: 'string';
        };
        unitPrice: {
          description: 'Reserved: TBD';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'billingPrice';
      'x-ms-summary': '';
    };
    brand: {
      description: 'Information about a brand that is associated with an account. A brand applies custom styles and text to an envelope.';
      properties: {
        brandCompany: {
          description: 'The name of the company associated with the brand.';
          type: 'string';
        };
        brandId: {
          description: 'The ID used to identify a specific brand in API calls.';
          type: 'string';
        };
        brandLanguages: {
          description: 'An array of two-letter codes for the languages that you want to use with the brand. The supported languages are:\n\n- Arabic (`ar`)\n- Armenian (`hy`)\n- Bahasa Indonesia (`id`)\n- Bahasa Malay (`ms`)\n- Bulgarian (`bg`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Czech (`cs`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English UK (`en_GB`)\n- English US (`en`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canada (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brasil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukranian (`uk`)\n- Vietnamese (`vi`)';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        brandName: {
          description: 'The name of the brand.';
          type: 'string';
        };
        colors: {
          description: 'An array of name-value pairs specifying the colors that the brand uses for the following elements:\n\n- Button background\n- Button text\n- Header background\n- Header text';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
        defaultBrandLanguage: {
          description: 'The two-letter code for the language that you want to use as the brand default. The supported languages are:\n\n- Arabic (`ar`)\n- Armenian (`hy`)\n- Bahasa Indonesia (`id`)\n- Bahasa Malay (`ms`)\n- Bulgarian (`bg`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Czech (`cs`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English UK (`en_GB`)\n- English US (`en`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canada (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brasil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukranian (`uk`)\n- Vietnamese (`vi`)';
          type: 'string';
        };
        emailContent: {
          description: 'Deprecated.';
          items: {
            $ref: '#/components/schemas/brandEmailContent';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        isOverridingCompanyName: {
          description: 'When **true,** the `brandCompany` property is overriding the name of the company in the account settings.';
          type: 'boolean';
        };
        isSendingDefault: {
          description: 'When **true,** the sending brand is the default brand for sending new envelopes.';
          type: 'boolean';
        };
        isSigningDefault: {
          description: 'When **true,** the siging brand is the default brand for the signing experience.';
          type: 'boolean';
        };
        landingPages: {
          description: 'An array of name/value pairs specifying the pages to which the user is redirected after the following events occur:\n\n- Signing Completed\n- Viewed Exit\n- Finish Later\n- Decline\n- Session Timeout\n- Authentication Failure\n\nIf you do not specify landing pages, the DocuSign default pages are used.';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
        links: {
          description: 'An array of `brandLink` objects that contain information about the links that the brand uses.';
          items: {
            $ref: '#/components/schemas/brandLink';
          };
          type: 'array';
        };
        logos: {
          $ref: '#/components/schemas/brandLogos';
        };
        resources: {
          $ref: '#/components/schemas/brandResourceUrls';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brand';
      'x-ms-summary': 'Information about a brand that is associated with an account. A brand applies custom styles and text to an envelope.';
    };
    brandEmailContent: {
      description: 'Deprecated.';
      properties: {
        content: {
          description: 'Deprecated.';
          type: 'string';
        };
        emailContentType: {
          description: 'Deprecated.';
          type: 'string';
        };
        emailToLink: {
          description: 'Deprecated.';
          type: 'string';
        };
        linkText: {
          description: 'Deprecated.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandEmailContent';
      'x-ms-summary': 'Deprecated.';
    };
    brandLink: {
      description: 'Information about a link that a brand uses.';
      properties: {
        linkText: {
          description: 'The text used for the link.';
          type: 'string';
        };
        linkType: {
          description: 'The type of link. Valid values include:\n\n- `aboutDocusign`\n- `closeButton`';
          type: 'string';
        };
        showLink: {
          description: 'When **true,** the link displays to the recipient.';
          type: 'string';
        };
        urlOrMailTo: {
          description: 'The URL or mailto address of the link.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandLink';
      'x-ms-summary': 'Information about a link that a brand uses.';
    };
    brandLogos: {
      description: 'The URIs for retrieving the logos that are associated with the brand.\n\nThese are read-only properties that provide a URI to logos in use.\nTo update a logo use\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/).\n';
      properties: {
        email: {
          description: "The URI for the brand's secondary logo.\n\nThis is a read-only property that provides a URI to the logo in use.\nTo update a logo use\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/).\n";
          type: 'string';
        };
        primary: {
          description: "The URI for the brand's secondary logo.\n\nThis is a read-only property that provides a URI to the logo in use.\nTo update a logo use\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/).\n";
          type: 'string';
        };
        secondary: {
          description: "The URI for the brand's secondary logo.\n\nThis is a read-only property that provides a URI to the logo in use.\nTo update a logo use\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/).\n";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandLogos';
      'x-ms-summary': 'The URIs for retrieving the logos that are associated with the brand.\n\nThese are read-only properties that provide a URI to logos in use.\nTo update a logo use\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/).\n';
    };
    brandRequest: {
      description: 'This request object contains information about a specific brand.';
      properties: {
        brandId: {
          description: 'The ID of the brand used in API calls';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandRequest';
      'x-ms-summary': 'This request object contains information about a specific brand.';
    };
    brandResourceUrls: {
      description: 'Brands use resource files to style the following experiences: \n\n- Email\n- Sending\n- Signing\n- Captive (embedded) signing \n\nYou can modify these resource files to customize these experiences.';
      properties: {
        email: {
          description: 'The URI for the email resource file that the brand uses.';
          type: 'string';
        };
        sending: {
          description: 'The URI for the sending resource file that the brand uses.';
          type: 'string';
        };
        signing: {
          description: 'The URI for the signing resource file that the brand uses.';
          type: 'string';
        };
        signingCaptive: {
          description: 'The URI for the captive (embedded) signing resource file that the brand uses.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandResourceUrls';
      'x-ms-summary': 'Brands use resource files to style the following experiences: \n\n- Email\n- Sending\n- Signing\n- Captive (embedded) signing \n\nYou can modify these resource files to customize these experiences.';
    };
    brandResources: {
      description: 'Information about the resource files that the brand uses for the email, signing, sending, and captive (embedded) signing experiences.';
      properties: {
        createdByUserInfo: {
          $ref: '#/components/schemas/userInfo';
        };
        createdDate: {
          description: 'The date and time that the brand resource was created.';
          type: 'string';
        };
        dataNotSavedNotInMaster: {
          description: 'Deprecated.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        modifiedByUserInfo: {
          $ref: '#/components/schemas/userInfo';
        };
        modifiedDate: {
          description: 'The date on which this user record was last modified.';
          type: 'string';
        };
        modifiedTemplates: {
          description: 'This property is returned in the response to the [AccountBrands::listResources][listResources] request. It contains a list of any email templates that have been modified to differ from the master resource files.\n\n[listResources]: /docs/esign-rest-api/reference/accounts/accountbrands/listresources/';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        resourcesContentType: {
          description: 'The type of brand resource file. A brand uses a different resource file to control each of the following experiences:\n\n- Sending (`sending`)\n- Signing (`signing`)\n- Email messages (`email`)\n- Captive (embedded) signing (`signing_captive`)\n\nYou can modify the default email messages and formats in these files and upload them to your brand to customize the user experience.';
          type: 'string';
        };
        resourcesContentUri: {
          description: 'The URI for the brand resource file.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandResources';
      'x-ms-summary': 'Information about the resource files that the brand uses for the email, signing, sending, and captive (embedded) signing experiences.';
    };
    brandResourcesList: {
      description: '';
      properties: {
        resourcesContentTypes: {
          description: 'A list of resources that the brand uses.';
          items: {
            $ref: '#/components/schemas/brandResources';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandResourcesList';
      'x-ms-summary': '';
    };
    brandsRequest: {
      description: 'Details about one or more brands.';
      properties: {
        brands: {
          description: 'A list of brands.';
          items: {
            $ref: '#/components/schemas/brandRequest';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandsRequest';
      'x-ms-summary': 'Details about one or more brands.';
    };
    brandsResponse: {
      description: '';
      properties: {
        brands: {
          description: 'A list of brands.';
          items: {
            $ref: '#/components/schemas/brand';
          };
          type: 'array';
        };
        recipientBrandIdDefault: {
          description: 'The brand that envelope recipients see when a brand is not explicitly set.';
          type: 'string';
        };
        senderBrandIdDefault: {
          description: 'The brand that envelope senders see when a brand is not explicitly set.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'brandsResponse';
      'x-ms-summary': '';
    };
    bulkEnvelope: {
      description: '';
      properties: {
        bulkRecipientRow: {
          description: 'The row of the recipient in the CSV file used to create the bulk recipient list.';
          type: 'string';
        };
        bulkStatus: {
          description: 'Indicates the status of the bulk send operation. Returned values can be:\n- `queued`\n- `processing`\n- `sent`\n- `failed`';
          type: 'string';
        };
        email: {
          description: 'The email address of the recipient assigned to this envelope transaction.';
          type: 'string';
        };
        envelopeId: {
          description: 'GUID of the bulk envelope.';
          type: 'string';
        };
        envelopeUri: {
          description: 'The URI for retrieving the envelope or envelopes.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        name: {
          description: 'The name of the recipient assigned to this envelope transaction.';
          type: 'string';
        };
        submittedDateTime: {
          description: 'The date and time on which the bulk envelope was created.';
          type: 'string';
        };
        transactionId: {
          description: "Identifier for the envelope transaction. The ID is a sender-generated value and is valid in the DocuSign system for 7 days. DocuSign recommends that you use a transaction ID for offline signing to ensure that an envelope is not sent multiple times. You can use the transaction ID to determine an envelope's status (queued, processing, sent, or failed) in cases where the Internet connection is lost before envelope status is returned.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkEnvelope';
      'x-ms-summary': '';
    };
    bulkEnvelopeStatus: {
      description: '';
      properties: {
        batchId: {
          description: 'Specifies an identifier which can be used to retrieve a more detailed status of individual bulk recipient batches.';
          type: 'string';
        };
        batchSize: {
          description: 'The number of items returned in this response.';
          type: 'string';
        };
        bulkEnvelopes: {
          description: 'A list of bulk envelope objects.';
          items: {
            $ref: '#/components/schemas/bulkEnvelope';
          };
          type: 'array';
        };
        bulkEnvelopesBatchUri: {
          description: 'URI at which you can retrieve the batch envelopes.';
          type: 'string';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        failed: {
          description: 'The number of entries with a status of failed. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        queued: {
          description: 'The number of entries with a status of queued. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        sent: {
          description: 'The number of entries with a status of sent.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        submittedDate: {
          description: 'The date on which the bulk envelope was created.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkEnvelopeStatus';
      'x-ms-summary': '';
    };
    bulkProcessRequest: {
      description: '';
      properties: {
        batchName: {
          description: '';
          type: 'string';
        };
        envelopeOrTemplateId: {
          description: 'The GUID of the envelope or template.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessRequest';
      'x-ms-summary': '';
    };
    bulkProcessResponse: {
      description: '';
      properties: {
        batchId: {
          description: 'Identifier used to query the status of an individual bulk recipient batch.';
          type: 'string';
        };
        batchName: {
          description: '';
          type: 'string';
        };
        batchSize: {
          description: 'The total number of items in the batch being queried.';
          type: 'string';
        };
        errorDetails: {
          description: 'Error details.\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        errors: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        queueLimit: {
          description: '';
          type: 'string';
        };
        totalQueued: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessResponse';
      'x-ms-summary': '';
    };
    bulkProcessResult: {
      description: '';
      properties: {
        errors: {
          description: '';
          items: {
            $ref: '#/components/schemas/bulkSendBatchError';
          };
          type: 'array';
        };
        listId: {
          description: 'The GUID of the bulk send list.';
          type: 'string';
        };
        success: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessResult';
      'x-ms-summary': '';
    };
    bulkProcessingListSummaries: {
      description: '';
      properties: {
        bulkListSummaries: {
          description: 'An array of `bulkSendingListSummary` objects where each summary provides basic information about a bulk send list that belongs to the current user.';
          items: {
            $ref: '#/components/schemas/bulkProcessingListSummary';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessingListSummaries';
      'x-ms-summary': '';
    };
    bulkProcessingListSummary: {
      description: '';
      properties: {
        bulkProcessListId: {
          description: '';
          type: 'string';
        };
        createdByUser: {
          description: '';
          type: 'string';
        };
        createdDate: {
          description: 'The creation date of the account in UTC timedate format.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessingListSummary';
      'x-ms-summary': '';
    };
    bulkProcessingLists: {
      description: '';
      properties: {
        bulkProcessListIds: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkProcessingLists';
      'x-ms-summary': '';
    };
    bulkSendBatchActionRequest: {
      description: '';
      properties: {
        action: {
          description: 'The action to apply. Valid values:\n\n* `Resend`\n* `Correct`\n* `Void`\n\nThis property is required and case-sensitive. The value must correspond to the `bulkAction` query parameter.\n';
          type: 'string';
        };
        notification: {
          $ref: '#/components/schemas/notification';
        };
        voidReason: {
          description: 'A string explaining why the envelope is voided. This value is shown in a message to the recipients.\n\nThis property is required if `action` is `Void`.\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchActionRequest';
      'x-ms-summary': '';
    };
    bulkSendBatchError: {
      description: '';
      properties: {
        error: {
          description: 'The server error associated with the Connect post failure.';
          type: 'string';
        };
        errorDetail: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchError';
      'x-ms-summary': '';
    };
    bulkSendBatchRequest: {
      description: '';
      properties: {
        batchName: {
          description: 'The new name of the bulk send batch.\n\nThis property is required. The maximum length of the string is 500 characters.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchRequest';
      'x-ms-summary': '';
    };
    bulkSendBatchStatus: {
      description: 'Result of `getBulkSendBatchStatus`';
      properties: {
        action: {
          description: '';
          type: 'string';
        };
        actionStatus: {
          description: '';
          type: 'string';
        };
        batchId: {
          description: 'The batch ID.';
          type: 'string';
        };
        batchName: {
          description: 'The batch name.';
          type: 'string';
        };
        batchSize: {
          description: 'The number of of bulk envelopes submitted in the current batch\n';
          type: 'string';
        };
        bulkErrors: {
          description: 'An array of error statuses.';
          items: {
            $ref: '#/components/schemas/bulkSendErrorStatus';
          };
          type: 'array';
        };
        envelopeIdOrTemplateId: {
          description: 'The ID of the draft envelope or template that was used to create the batch.\n';
          type: 'string';
        };
        envelopesInfo: {
          $ref: '#/components/schemas/bulkSendEnvelopesInfo';
        };
        envelopesUri: {
          description: 'The URI to get all envelopes sent in the batch.\n';
          type: 'string';
        };
        failed: {
          description: 'The number of envelopes that failed to process or send.\n';
          type: 'string';
        };
        mailingListId: {
          description: 'The ID of the mailing list used to create the batch.';
          type: 'string';
        };
        mailingListName: {
          description: '';
          type: 'string';
        };
        ownerUserId: {
          description: '';
          type: 'string';
        };
        queued: {
          description: 'The number of envelopes waiting in pending queue\n';
          type: 'string';
        };
        resendsRemaining: {
          description: '';
          type: 'string';
        };
        senderUserId: {
          description: 'The ID of the sender.';
          type: 'string';
        };
        sent: {
          description: 'The number of envelopes sent successfully.';
          type: 'string';
        };
        submittedDate: {
          description: 'The timestamp of  when the batch was submitted in ISO 8601 format.\n\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchStatus';
      'x-ms-summary': 'Result of `getBulkSendBatchStatus`';
    };
    bulkSendBatchSummaries: {
      description: 'A list of bulk send batch summaries. ';
      properties: {
        batchSizeLimit: {
          description: 'The maximum number of envelopes the account is permitted to submit in a given batch.';
          type: 'string';
        };
        bulkBatchSummaries: {
          description: 'An array of batch summaries.';
          items: {
            $ref: '#/components/schemas/bulkSendBatchSummary';
          };
          type: 'array';
        };
        bulkProcessQueueLimit: {
          description: '';
          type: 'string';
        };
        bulkProcessTotalQueued: {
          description: '';
          type: 'string';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        queueLimit: {
          description: 'Maximum number of envelopes an account is permitted to have in the queue at any one time.';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalQueued: {
          description: 'The number of envelopes currently pending processing for the entire account.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchSummaries';
      'x-ms-summary': 'A list of bulk send batch summaries. ';
    };
    bulkSendBatchSummary: {
      description: 'Summary status of a single batch.';
      properties: {
        batchId: {
          description: 'The batch ID.';
          type: 'string';
        };
        batchName: {
          description: 'The name of the batch.';
          type: 'string';
        };
        batchSize: {
          description: 'The number of envelopes in the batch.';
          type: 'string';
        };
        batchUri: {
          description: 'The batch details URI.';
          type: 'string';
        };
        failed: {
          description: 'Number of envelopes that failed to send.';
          type: 'string';
        };
        queued: {
          description: 'Number of envelopes peding processing.\n';
          type: 'string';
        };
        sent: {
          description: 'Number of envelopes that have been sent.';
          type: 'string';
        };
        submittedDate: {
          description: 'The time stamp of when the batch was created in ISO 8601 format.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendBatchSummary';
      'x-ms-summary': 'Summary status of a single batch.';
    };
    bulkSendEnvelopesInfo: {
      description: '';
      properties: {
        authoritativeCopy: {
          description: 'When **true,** marks all of the documents in the envelope as authoritative copies.\n\n**Note:** You can override this value for a specific document. For example, you can set the `authoritativeCopy` property to **true** at the envelope level, but turn it off for a single document by setting the `authoritativeCopy` property for the document to **false.**';
          type: 'string';
        };
        completed: {
          description: '';
          type: 'string';
        };
        correct: {
          description: '';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the workspace user authorization was created.';
          type: 'string';
        };
        declined: {
          description: '';
          type: 'string';
        };
        deleted: {
          description: '';
          type: 'string';
        };
        delivered: {
          description: '';
          type: 'string';
        };
        digitalSignaturesPending: {
          description: '';
          type: 'string';
        };
        sent: {
          description: 'The number of entries with a status of `sent`.';
          type: 'string';
        };
        signed: {
          description: '';
          type: 'string';
        };
        timedOut: {
          description: '';
          type: 'string';
        };
        transferCompleted: {
          description: '';
          type: 'string';
        };
        voided: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendEnvelopesInfo';
      'x-ms-summary': '';
    };
    bulkSendErrorStatus: {
      description: 'A single bulk send error report.';
      properties: {
        created: {
          description: 'The timestamp of when the error occurred in ISO 8601 format.';
          type: 'string';
        };
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        errorMessage: {
          description: 'The error message generated during processing, if any.\n';
          type: 'string';
        };
        recipientEmails: {
          description: 'An array of email addresses for the failed bulk envelope.\n\nRecipient email/info of the failed bulk envelope.\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendErrorStatus';
      'x-ms-summary': 'A single bulk send error report.';
    };
    bulkSendRequest: {
      description: 'This object contains information about the envelope or template that you want to send in bulk.';
      properties: {
        batchName: {
          description: 'The human-readable name of the batch. If you do not set this value, it defaults to the `name` property of the `bulkSendingList` object.\n';
          type: 'string';
        };
        envelopeOrTemplateId: {
          description: 'The GUID of the envelope or template that you want to send in bulk.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendRequest';
      'x-ms-summary': 'This object contains information about the envelope or template that you want to send in bulk.';
    };
    bulkSendResponse: {
      description: 'The object contains the response to a bulk send request.';
      properties: {
        batchId: {
          description: 'A batch identifier that you can use to get the status of the batch.';
          type: 'string';
        };
        batchName: {
          description: '';
          type: 'string';
        };
        batchSize: {
          description: 'The total number of items in the batch being queried.';
          type: 'string';
        };
        envelopeOrTemplateId: {
          description: 'The GUID of the envelope or template that was sent.';
          type: 'string';
        };
        errorDetails: {
          description: 'A human-readable object that describes errors that occur. It is only valid for responses and ignored in requests.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        errors: {
          description: 'A list of errors that occurred. This information is intended to be parsed by machine.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        queueLimit: {
          description: '';
          type: 'string';
        };
        totalQueued: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendResponse';
      'x-ms-summary': 'The object contains the response to a bulk send request.';
    };
    bulkSendTestResponse: {
      description: 'This object contains the results of a bulk send test.';
      properties: {
        canBeSent: {
          description: 'When **true,** the envelope or template is compatible with the bulk send list and can be sent by using the [BulkSend: createBulkSendRequest][BulkSendRequest] method.\n\n**Note:** This property is only returned in responses and ignored in requests.\n\n[BulkSendRequest]:  /docs/esign-rest-api/reference/bulkenvelopes/bulksend/createbulksendrequest/\n';
          type: 'boolean';
        };
        validationErrorDetails: {
          description: 'Human-readable details about any validation errors that occurred.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        validationErrors: {
          description: 'A list of validation errors that were encountered during the bulk send test.\n\n**Note:** This information is intended to be parsed by machine.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendTestResponse';
      'x-ms-summary': 'This object contains the results of a bulk send test.';
    };
    bulkSendingCopy: {
      description: 'This object contains the details to use for a specific copy, or instance, of the envelope. When you send an envelope by using a bulk send list, you can customize these properties for each instance.';
      properties: {
        customFields: {
          description: 'The custom fields for this copy of the envelope.\n\n**Note:** These custom fields must also be included in the original envelope or template that you want to send.';
          items: {
            $ref: '#/components/schemas/bulkSendingCopyCustomField';
          };
          type: 'array';
        };
        docGenFormFields: {
          description: '';
          items: {
            $ref: '#/components/schemas/bulksendingCopyDocGenFormField';
          };
          type: 'array';
        };
        emailBlurb: {
          description: 'The email body for this copy of the envelope.';
          type: 'string';
        };
        emailSubject: {
          description: 'The email subject line for this copy of the envelope.\n\nFor information about adding merge field information to the email subject,\nsee [Template Email Subject Merge Fields](/docs/esign-rest-api/reference/templates/templates/create/).\n\n**Note:** The subject line is limited to 100 characters, including any merged fields.It is not truncated. It is an error if the text is longer than 100 characters.';
          type: 'string';
        };
        recipients: {
          description: 'Information about the recipients associated with this copy of the envelope.';
          items: {
            $ref: '#/components/schemas/bulkSendingCopyRecipient';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingCopy';
      'x-ms-summary': 'This object contains the details to use for a specific copy, or instance, of the envelope. When you send an envelope by using a bulk send list, you can customize these properties for each instance.';
    };
    bulkSendingCopyCustomField: {
      description: 'This object contains details about a custom field for a bulk send copy. In a bulk send request, each custom field in the bulk send list must match a custom field in the envelope or template that you want to send.';
      properties: {
        name: {
          description: 'The name of the custom field.';
          type: 'string';
        };
        value: {
          description: 'The value of the custom field.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingCopyCustomField';
      'x-ms-summary': 'This object contains details about a custom field for a bulk send copy. In a bulk send request, each custom field in the bulk send list must match a custom field in the envelope or template that you want to send.';
    };
    bulkSendingCopyRecipient: {
      description: 'This object contains details about a bulk send recipient.';
      properties: {
        accessCode: {
          description: "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and it must conform to the account's access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then the access code is not required.";
          type: 'string';
        };
        clientUserId: {
          description: 'Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Use this field to associate the signer with their userId in your app. Authenticating the user is the responsibility of your app when you use embedded signing.\n\nIf the `clientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true,** an error is generated on sending.\n\n**Note:** This property is not returned by the [listStatusChanges](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/) endpoint.\n\nMaximum length: 100 characters. \n';
          type: 'string';
        };
        customFields: {
          description: 'An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        deliveryMethod: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        email: {
          description: "The recipient's email address.";
          type: 'string';
        };
        emailNotification: {
          $ref: '#/components/schemas/recipientEmailNotification';
        };
        embeddedRecipientStartURL: {
          description: "Specifies a sender-provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nWhen `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation launched by a partner.\n\nIt is important to understand that in a typical embedded workflow, the authentication of an embedded recipient is the responsibility of the sending application. DocuSign expects that senders will follow their own processes for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process is initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process, bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: `envelopeId`, `recipientId`, `recipientName`, `recipientEmail`, and `customFields`. The `customFields` property must be set for the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ";
          type: 'string';
        };
        faxNumber: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        hostEmail: {
          description: 'The email address of the signing host.\nThis is the DocuSign user that is hosting the in-person signing session.\n\nRequired when `inPersonSigningType` is `inPersonSigner`.\nFor eNotary flow, use `email` instead.\n\nMaximum Length: 100 characters.\n';
          type: 'string';
        };
        hostName: {
          description: 'The name of the signing host.\nThis is the DocuSign user that is hosting the in-person signing session.\n\nRequired when `inPersonSigningType` is `inPersonSigner`.\nFor eNotary flow, use `name` instead.\n\nMaximum Length: 100 characters.\n';
          type: 'string';
        };
        idCheckConfigurationName: {
          description: 'The name of the authentication check to use. This value must match one of the authentication types that the account uses. The names of these authentication types appear in the web console sending interface in the Identify list for a recipient. This setting overrides any default authentication setting. Valid values are:\n\n- `Phone Auth $`: The recipient must authenticate by using two-factor authentication (2FA). You provide the phone number to use for 2FA in the `phoneAuthentication` object.\n- `SMS Auth $`: The recipient must authenticate via SMS. You provide the phone number to use in the `smsAuthentication` object.\n- `ID Check $`: The  recipient must answer detailed security questions. \n\n**Example:** Your account has ID Check and SMS Authentication available. In the web console Identify list, these appear as ID Check $ and SMS Auth $. To use ID Check in an envelope, the idCheckConfigurationName should be ID Check $. For SMS, you would use SMS Auth $, and you would also need to add a phone number to the smsAuthentication node.';
          type: 'string';
        };
        idCheckInformationInput: {
          $ref: '#/components/schemas/idCheckInformationInput';
        };
        identificationMethod: {
          description: '';
          type: 'string';
        };
        identityVerification: {
          $ref: '#/components/schemas/recipientIdentityVerification';
        };
        name: {
          description: '';
          type: 'string';
        };
        note: {
          description: 'A note sent to the recipient in the signing email.\nThis note is unique to this recipient.\nIn the user interface,\nit appears near the upper left corner\nof the document\non the signing screen.\n\nMaximum Length: 1000 characters.\n';
          type: 'string';
        };
        phoneAuthentication: {
          $ref: '#/components/schemas/recipientPhoneAuthentication';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.\n\n**Note:** Every recipient must be assigned either a `recipientId` or a `roleName` but not both. You cannot use `roleName` and `recipientId` in the same list.';
          type: 'string';
        };
        recipientSignatureProviders: {
          description: 'The default signature provider is the DocuSign Electronic signature system. This parameter is used to specify one or more Standards Based Signature (digital signature) providers for the signer to use. [More information.](/docs/esign-rest-api/esign101/concepts/standards-based-signatures/)';
          items: {
            $ref: '#/components/schemas/recipientSignatureProvider';
          };
          type: 'array';
        };
        roleName: {
          description: 'The name of the role associated with the recipient.\n\n**Note:** Every recipient must be assigned either a `recipientId` or a `roleName` but not both. You cannot use `roleName` and `recipientId` in the same list.';
          type: 'string';
        };
        signerName: {
          description: "The in-person signer's full legal name.\n\nRequired when `inPersonSigningType` is `inPersonSigner`.\nFor eNotary flow, use `name` instead.\n\nMaximum Length: 100 characters.\n";
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        smsAuthentication: {
          $ref: '#/components/schemas/recipientSMSAuthentication';
        };
        socialAuthentications: {
          description: 'Deprecated.';
          items: {
            $ref: '#/components/schemas/socialAuthentication';
          };
          type: 'array';
        };
        tabs: {
          description: 'A list of tabs associated with the recipient. In a bulk send request, each of these recipient tabs must match a recipient tab on the envelope or template that you want to send. To match up, the `tabLabel` for this tab and the `tabLabel` for the corresponding tab on the envelope or template must be the same.\n\nFor example, if the envelope has a placeholder text tab with the `tabLabel` `childName`, you must assign the same `tabLabel` `childName` to the tab here that you are populating with that information.\n\n You can use the following types of tabs to match bulk send recipients to an envelope:\n\n- Text tabs\n- Radio group tabs (where the name of the `radioGroup` on the envelope is used as the `tabLabel` in the bulk send list)\n- List tabs';
          items: {
            $ref: '#/components/schemas/bulkSendingCopyTab';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingCopyRecipient';
      'x-ms-summary': 'This object contains details about a bulk send recipient.';
    };
    bulkSendingCopyTab: {
      description: 'A tab associated with the bulk send recipient. In a bulk send request, each recipient tab must match a recipient tab on the envelope or template that you want to send. To match up, the `tabLabel` for this tab and the `tabLabel` for the corresponding tab on the envelope or template must be the same.\n\nFor example, if the envelope has a placeholder text tab with the `tabLabel` `childName`, you must assign the same `tabLabel` `childName` to the tab here that you are populating with that information.';
      properties: {
        initialValue: {
          description: 'The initial value that you want to assign to the tab.';
          type: 'string';
        };
        tabLabel: {
          description: 'The label associated with the recipient tab. In a bulk send request, the `tabLabel` for this tab and the `tabLabel` for the corresponding tab on the envelope or template must be the same.\n\nMaximum Length: 500 characters.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingCopyTab';
      'x-ms-summary': 'A tab associated with the bulk send recipient. In a bulk send request, each recipient tab must match a recipient tab on the envelope or template that you want to send. To match up, the `tabLabel` for this tab and the `tabLabel` for the corresponding tab on the envelope or template must be the same.\n\nFor example, if the envelope has a placeholder text tab with the `tabLabel` `childName`, you must assign the same `tabLabel` `childName` to the tab here that you are populating with that information.';
    };
    bulkSendingList: {
      description: 'This object contains the details for the bulk send list.';
      properties: {
        bulkCopies: {
          description: 'An array of `bulkCopy` objects. Each object represents an instance or copy of an envelope and contains details such as the recipient, custom fields, tabs, and other information.';
          items: {
            $ref: '#/components/schemas/bulkSendingCopy';
          };
          type: 'array';
        };
        listId: {
          description: 'The GUID of the bulk send list.';
          type: 'string';
        };
        name: {
          description: 'The name of the bulk send list.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingList';
      'x-ms-summary': 'This object contains the details for the bulk send list.';
    };
    bulkSendingListSummaries: {
      description: 'This complex type contains summaries that provide basic information about the bulk send lists that belong to the current user.';
      properties: {
        bulkListSummaries: {
          description: 'An array of `bulkSendingListSummary` objects where each summary provides basic information about a bulk send list that belongs to the current user.';
          items: {
            $ref: '#/components/schemas/bulkSendingListSummary';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingListSummaries';
      'x-ms-summary': 'This complex type contains summaries that provide basic information about the bulk send lists that belong to the current user.';
    };
    bulkSendingListSummary: {
      description: 'This object contains basic information about a bulk send list.';
      properties: {
        bulkSendListId: {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          type: 'string';
        };
        createdByUser: {
          description: 'The GUID of the user who created the bulk send list.';
          type: 'string';
        };
        createdDate: {
          description: 'The UTC DateTime that the bulk send list was created.';
          type: 'string';
        };
        name: {
          description: 'The name of the bulk send list.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulkSendingListSummary';
      'x-ms-summary': 'This object contains basic information about a bulk send list.';
    };
    bulksendingCopyDocGenFormField: {
      description: '';
      properties: {
        name: {
          description: '';
          type: 'string';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'bulksendingCopyDocGenFormField';
      'x-ms-summary': '';
    };
    captiveRecipient: {
      description: 'This object contains details about a captive (embedded) recipient.';
      properties: {
        clientUserId: {
          description: 'Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Use this field to associate the signer with their userId in your app. Authenticating the user is the responsibility of your app when you use embedded signing.\n\nIf the `clientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true,** an error is generated on sending.\n\n**Note:** This property is not returned by the [listStatusChanges](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/) endpoint.\n\nMaximum length: 100 characters. \n';
          type: 'string';
        };
        email: {
          description: 'The email address associated with the captive recipient.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        userName: {
          description: 'The username associated with the captive recipient.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'captiveRecipient';
      'x-ms-summary': 'This object contains details about a captive (embedded) recipient.';
    };
    captiveRecipientInformation: {
      description: 'Contains information about captive (embedded) recipients.';
      properties: {
        captiveRecipients: {
          description: 'A complex type containing information about one or more captive recipients.';
          items: {
            $ref: '#/components/schemas/captiveRecipient';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'captiveRecipientInformation';
      'x-ms-summary': 'Contains information about captive (embedded) recipients.';
    };
    carbonCopy: {
      description: "Contains information about a carbon copy recipient. Carbon copy recipients get a copy of the envelope but don't need to sign, initial, date or add information to any of the documents. ";
      properties: {
        accessCode: {
          description: "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and it must conform to the account's access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then the access code is not required.";
          type: 'string';
        };
        accessCodeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        addAccessCodeToEmail: {
          description: 'Optional. When **true,** the access code will be added to the email sent to the recipient. This nullifies the security measure of `accessCode` on the recipient.';
          type: 'string';
        };
        additionalNotifications: {
          description: 'An array of additional notification objects.';
          items: {
            $ref: '#/components/schemas/recipientAdditionalNotification';
          };
          type: 'array';
        };
        agentCanEditEmail: {
          description: "Optional element. When **true,** the agents recipient associated with this recipient can change the recipient's pre-populated email address. This element is only active if enabled for the account.";
          type: 'string';
        };
        agentCanEditName: {
          description: "Optional element. When **true,** the agents recipient associated with this recipient can change the recipient's pre-populated name. This element is only active if enabled for the account.";
          type: 'string';
        };
        allowSystemOverrideForLockedRecipient: {
          description: 'When **true,** if the recipient is locked on a template, advanced recipient routing can override the lock.';
          type: 'string';
        };
        autoRespondedReason: {
          description: 'Error message provided by the destination email system. This field is only provided if the email notification to the recipient fails to send. This property is read-only.\n';
          type: 'string';
        };
        bulkSendV2Recipient: {
          description: '';
          type: 'string';
        };
        clientUserId: {
          description: 'Not applicable for Carbon Copy recipients.';
          type: 'string';
        };
        completedCount: {
          description: 'Indicates the number of times that the recipient has been through a signing completion for the envelope. If this number is greater than 0 for a signing group, only the user who previously completed may sign again. This property is read-only.';
          type: 'string';
        };
        consentDetailsList: {
          description: '';
          items: {
            $ref: '#/components/schemas/consentDetails';
          };
          type: 'array';
        };
        customFields: {
          description: 'An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        declinedDateTime: {
          description: 'The date and time the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        declinedReason: {
          description: 'The reason the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        deliveredDateTime: {
          description: 'The date and time that the envelope was delivered to the recipient. This property is read-only.';
          type: 'string';
        };
        deliveryMethod: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        deliveryMethodMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        designatorId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        designatorIdGuid: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        documentVisibility: {
          description: 'A list of `documentVisibility` objects. Each object in the list specifies whether a document in the envelope is visible to this recipient. For the envelope to use this functionality, Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true.**';
          items: {
            $ref: '#/components/schemas/documentVisibility';
          };
          type: 'array';
        };
        email: {
          description: "The recipient's email address. Notification of the document to sign is sent to this email address. \n\nMaximum length: 100 characters. ";
          type: 'string';
        };
        emailMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        emailNotification: {
          $ref: '#/components/schemas/recipientEmailNotification';
        };
        emailRecipientPostSigningURL: {
          description: '';
          type: 'string';
        };
        embeddedRecipientStartURL: {
          description: "Specifies a sender-provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nWhen `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation launched by a partner.\n\nIt is important to understand that in a typical embedded workflow, the authentication of an embedded recipient is the responsibility of the sending application. DocuSign expects that senders will follow their own processes for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process is initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process, bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: `envelopeId`, `recipientId`, `recipientName`, `recipientEmail`, and `customFields`. The `customFields` property must be set for the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ";
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        excludedDocuments: {
          description: 'Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.\n\nWhen enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        faxNumber: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        faxNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        firstName: {
          description: "The recipient's first name. Maximum Length: 50 characters.";
          type: 'string';
        };
        firstNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fullName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        fullNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckConfigurationName: {
          description: 'The name of the authentication check to use. This value must match one of the authentication types that the account uses. The names of these authentication types appear in the web console sending interface in the Identify list for a recipient. This setting overrides any default authentication setting. Valid values are:\n\n- `Phone Auth $`: The recipient must authenticate by using two-factor authentication (2FA). You provide the phone number to use for 2FA in the `phoneAuthentication` object.\n- `SMS Auth $`: The recipient must authenticate via SMS. You provide the phone number to use in the `smsAuthentication` object.\n- `ID Check $`: The  recipient must answer detailed security questions. \n\n**Example:** Your account has ID Check and SMS Authentication available. In the web console Identify list, these appear as ID Check $ and SMS Auth $. To use ID Check in an envelope, the idCheckConfigurationName should be ID Check $. For SMS, you would use SMS Auth $, and you would also need to add a phone number to the smsAuthentication node.';
          type: 'string';
        };
        idCheckConfigurationNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckInformationInput: {
          $ref: '#/components/schemas/idCheckInformationInput';
        };
        identityVerification: {
          $ref: '#/components/schemas/recipientIdentityVerification';
        };
        inheritEmailNotificationConfiguration: {
          description: "When **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ";
          type: 'string';
        };
        lastName: {
          description: "The recipient's last name.";
          type: 'string';
        };
        lastNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        linkedAccountConfigurationId: {
          description: '';
          type: 'string';
        };
        lockedRecipientPhoneAuthEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lockedRecipientSmsEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The full legal name of the recipient. Maximum Length: 100 characters.\n\n**Note:** You must always set a value for this property in requests, even if `firstName` and `lastName` are set.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        note: {
          description: 'A note sent to the recipient in the signing email.\nThis note is unique to this recipient.\nIn the user interface,\nit appears near the upper left corner\nof the document\non the signing screen.\n\nMaximum Length: 1000 characters.\n';
          type: 'string';
        };
        noteMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        phoneAuthentication: {
          $ref: '#/components/schemas/recipientPhoneAuthentication';
        };
        phoneNumber: {
          $ref: '#/components/schemas/recipientPhoneNumber';
        };
        proofFile: {
          $ref: '#/components/schemas/recipientProofFile';
        };
        recipientAttachments: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/recipientAttachment';
          };
          type: 'array';
        };
        recipientAuthenticationStatus: {
          $ref: '#/components/schemas/authenticationStatus';
        };
        recipientFeatureMetadata: {
          description: 'Metadata about the features that are supported for the recipient type. This property is read-only.';
          items: {
            $ref: '#/components/schemas/featureAvailableMetadata';
          };
          type: 'array';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientType: {
          description: "The recipient type, as specified by the following values:\n- `agent`: Agent recipients can add name and email information for recipients that appear after the agent in routing order.\n- `carbonCopy`: Carbon copy recipients get a copy of the envelope but don't need to sign, initial, date, or add information to any of the documents. This type of recipient can be used in any routing order.\n- `certifiedDelivery`: Certified delivery recipients must receive the completed documents for the envelope to be completed. They don't need to sign, initial, date, or add information to any of the documents.\n- `editor`: Editors have the same management and access rights for the envelope as the sender. Editors can add name and email information, add or change the routing order, set authentication options, and can edit signature/initial tabs and data fields for the remaining recipients.\n- `inPersonSigner`: In-person recipients are DocuSign users who act as signing hosts in the same physical location as the signer.\n- `intermediaries`: Intermediary recipients can optionally add name and email information for recipients at the same or subsequent level in the routing order.\n- `seal`: Electronic seal recipients represent legal entities.\n- `signer`: Signers are recipients who must sign, initial, date, or add data to form fields on the documents in the envelope.\n- `witness`: Witnesses are recipients whose signatures affirm that the identified signers have signed the documents in the envelope.";
          type: 'string';
        };
        recipientTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireIdLookup: {
          description: 'When **true,** the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ';
          type: 'string';
        };
        requireIdLookupMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        roleName: {
          description: 'Optional element. Specifies the role name associated with the recipient.<br/><br/>This property is required when you are working with template recipients.';
          type: 'string';
        };
        routingOrder: {
          description: 'Specifies the routing order of the recipient in the envelope. ';
          type: 'string';
        };
        routingOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        signedDateTime: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        signingGroupIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
        signingGroupUsers: {
          description: 'A complex type that contains information about users in the signing group.';
          items: {
            $ref: '#/components/schemas/userInfo';
          };
          type: 'array';
        };
        smsAuthentication: {
          $ref: '#/components/schemas/recipientSMSAuthentication';
        };
        socialAuthentications: {
          description: 'Deprecated.';
          items: {
            $ref: '#/components/schemas/socialAuthentication';
          };
          type: 'array';
        };
        status: {
          description: "The recipient's status. This property is read-only. \n\nValid values:\n\n- `autoresponded`: The recipient's email system auto-responded to the email from DocuSign. This status is used in the web console to inform senders about the bounced-back email. This recipient status is only used if **Send-on-behalf-of** is turned off for the account.\n- `completed`: The recipient has completed their actions (signing or other required actions if not a signer) for an envelope.\n- `created`: The recipient is in a draft state. This value is only associated with draft envelopes (envelopes that have a status of `created`).\n- `declined`: The recipient declined to sign the documents in the envelope.\n- `delivered`: The recipient has viewed the documents in an envelope through the DocuSign signing website. This is not an email delivery of the documents in an envelope.\n- `faxPending`: The recipient has finished signing and the system is waiting for a fax attachment from the recipient before completing their signing step.\n- `sent`: The recipient has been sent an email notification that it is their turn to sign an envelope.\n- `signed`: The recipient has completed (signed) all required tags in an envelope. This is a temporary state during processing, after which the recipient's status automatically switches to `completed`.";
          type: 'string';
        };
        statusCode: {
          description: "The code associated with the recipient's status. This property is read-only.";
          type: 'string';
        };
        suppressEmails: {
          description: 'When **true,** email notifications are suppressed for the recipient, and they must access envelopes and documents from their DocuSign inbox.';
          type: 'string';
        };
        tabs: {
          $ref: '#/components/schemas/EnvelopeRecipientTabs';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        totalTabCount: {
          description: 'The total number of tabs in the documents. This property is read-only.';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'carbonCopy';
      'x-ms-summary': "Contains information about a carbon copy recipient. Carbon copy recipients get a copy of the envelope but don't need to sign, initial, date or add information to any of the documents. ";
    };
    certifiedDelivery: {
      description: "Contains information about a certified delivery recipient. Certified delivery recipients must receive the completed documents for the envelope to be completed. However, they don't need to sign, initial, date or add information to any of the documents.";
      properties: {
        accessCode: {
          description: "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope. \n\nMaximum Length: 50 characters and it must conform to the account's access code format setting.\n\nIf blank, but the signer `accessCode` property is set in the envelope, then that value is used.\n\nIf blank and the signer `accessCode` property is not set, then the access code is not required.";
          type: 'string';
        };
        accessCodeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        addAccessCodeToEmail: {
          description: 'Optional. When **true,** the access code will be added to the email sent to the recipient. This nullifies the security measure of `accessCode` on the recipient.';
          type: 'string';
        };
        additionalNotifications: {
          description: 'An array of additional notification objects.';
          items: {
            $ref: '#/components/schemas/recipientAdditionalNotification';
          };
          type: 'array';
        };
        agentCanEditEmail: {
          description: "Optional element. When **true,** the agents recipient associated with this recipient can change the recipient's pre-populated email address. This element is only active if enabled for the account.";
          type: 'string';
        };
        agentCanEditName: {
          description: "Optional element. When **true,** the agents recipient associated with this recipient can change the recipient's pre-populated name. This element is only active if enabled for the account.";
          type: 'string';
        };
        allowSystemOverrideForLockedRecipient: {
          description: 'When **true,** if the recipient is locked on a template, advanced recipient routing can override the lock.';
          type: 'string';
        };
        autoRespondedReason: {
          description: 'Error message provided by the destination email system. This field is only provided if the email notification to the recipient fails to send. This property is read-only.\n';
          type: 'string';
        };
        bulkSendV2Recipient: {
          description: '';
          type: 'string';
        };
        clientUserId: {
          description: 'Specifies whether the recipient is embedded or remote. \n\nIf the `clientUserId` property is not null then the recipient is embedded. Use this field to associate the signer with their userId in your app. Authenticating the user is the responsibility of your app when you use embedded signing.\n\nIf the `clientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true,** an error is generated on sending.\n\n**Note:** This property is not returned by the [listStatusChanges](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/) endpoint.\n\nMaximum length: 100 characters. \n';
          type: 'string';
        };
        completedCount: {
          description: 'Indicates the number of times that the recipient has been through a signing completion for the envelope. If this number is greater than 0 for a signing group, only the user who previously completed may sign again. This property is read-only.';
          type: 'string';
        };
        consentDetailsList: {
          description: '';
          items: {
            $ref: '#/components/schemas/consentDetails';
          };
          type: 'array';
        };
        customFields: {
          description: 'An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        declinedDateTime: {
          description: 'The date and time the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        declinedReason: {
          description: 'The reason the recipient declined the document. This property is read-only.';
          type: 'string';
        };
        deliveredDateTime: {
          description: 'The date and time that the envelope was delivered to the recipient. This property is read-only.';
          type: 'string';
        };
        deliveryMethod: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        deliveryMethodMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        designatorId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        designatorIdGuid: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        documentVisibility: {
          description: 'A list of `documentVisibility` objects. Each object in the list specifies whether a document in the envelope is visible to this recipient. For the envelope to use this functionality, Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true.**';
          items: {
            $ref: '#/components/schemas/documentVisibility';
          };
          type: 'array';
        };
        email: {
          description: "The recipient's email address.";
          type: 'string';
        };
        emailMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        emailNotification: {
          $ref: '#/components/schemas/recipientEmailNotification';
        };
        emailRecipientPostSigningURL: {
          description: '';
          type: 'string';
        };
        embeddedRecipientStartURL: {
          description: "Specifies a sender-provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session. \n\nWhen `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation launched by a partner.\n\nIt is important to understand that in a typical embedded workflow, the authentication of an embedded recipient is the responsibility of the sending application. DocuSign expects that senders will follow their own processes for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process is initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process, bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.\n\nIf the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: `envelopeId`, `recipientId`, `recipientName`, `recipientEmail`, and `customFields`. The `customFields` property must be set for the recipient or envelope. The merge fields are enclosed in double brackets. \n\n*Example*: \n\n`http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ";
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        excludedDocuments: {
          description: 'Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.\n\nWhen enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        faxNumber: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        faxNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        firstName: {
          description: "The recipient's first name. Maximum Length: 50 characters.";
          type: 'string';
        };
        firstNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fullName: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        fullNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckConfigurationName: {
          description: 'The name of the authentication check to use. This value must match one of the authentication types that the account uses. The names of these authentication types appear in the web console sending interface in the Identify list for a recipient. This setting overrides any default authentication setting. Valid values are:\n\n- `Phone Auth $`: The recipient must authenticate by using two-factor authentication (2FA). You provide the phone number to use for 2FA in the `phoneAuthentication` object.\n- `SMS Auth $`: The recipient must authenticate via SMS. You provide the phone number to use in the `smsAuthentication` object.\n- `ID Check $`: The  recipient must answer detailed security questions. \n\n**Example:** Your account has ID Check and SMS Authentication available. In the web console Identify list, these appear as ID Check $ and SMS Auth $. To use ID Check in an envelope, the idCheckConfigurationName should be ID Check $. For SMS, you would use SMS Auth $, and you would also need to add a phone number to the smsAuthentication node.';
          type: 'string';
        };
        idCheckConfigurationNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        idCheckInformationInput: {
          $ref: '#/components/schemas/idCheckInformationInput';
        };
        identityVerification: {
          $ref: '#/components/schemas/recipientIdentityVerification';
        };
        inheritEmailNotificationConfiguration: {
          description: "When **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ";
          type: 'string';
        };
        lastName: {
          description: "The recipient's last name.";
          type: 'string';
        };
        lastNameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        lockedRecipientPhoneAuthEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        lockedRecipientSmsEditable: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The full legal name of the recipient. Maximum Length: 100 characters.\n\n**Note:** You must always set a value for this property in requests, even if `firstName` and `lastName` are set.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        note: {
          description: 'A note sent to the recipient in the signing email.\nThis note is unique to this recipient.\nIn the user interface,\nit appears near the upper left corner\nof the document\non the signing screen.\n\nMaximum Length: 1000 characters.\n';
          type: 'string';
        };
        noteMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        phoneAuthentication: {
          $ref: '#/components/schemas/recipientPhoneAuthentication';
        };
        phoneNumber: {
          $ref: '#/components/schemas/recipientPhoneNumber';
        };
        proofFile: {
          $ref: '#/components/schemas/recipientProofFile';
        };
        recipientAttachments: {
          description: 'Reserved for DocuSign.';
          items: {
            $ref: '#/components/schemas/recipientAttachment';
          };
          type: 'array';
        };
        recipientAuthenticationStatus: {
          $ref: '#/components/schemas/authenticationStatus';
        };
        recipientFeatureMetadata: {
          description: 'Metadata about the features that are supported for the recipient type. This property is read-only.';
          items: {
            $ref: '#/components/schemas/featureAvailableMetadata';
          };
          type: 'array';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientType: {
          description: "The recipient type, as specified by the following values:\n- `agent`: Agent recipients can add name and email information for recipients that appear after the agent in routing order.\n- `carbonCopy`: Carbon copy recipients get a copy of the envelope but don't need to sign, initial, date, or add information to any of the documents. This type of recipient can be used in any routing order.\n- `certifiedDelivery`: Certified delivery recipients must receive the completed documents for the envelope to be completed. They don't need to sign, initial, date, or add information to any of the documents.\n- `editor`: Editors have the same management and access rights for the envelope as the sender. Editors can add name and email information, add or change the routing order, set authentication options, and can edit signature/initial tabs and data fields for the remaining recipients.\n- `inPersonSigner`: In-person recipients are DocuSign users who act as signing hosts in the same physical location as the signer.\n- `intermediaries`: Intermediary recipients can optionally add name and email information for recipients at the same or subsequent level in the routing order.\n- `seal`: Electronic seal recipients represent legal entities.\n- `signer`: Signers are recipients who must sign, initial, date, or add data to form fields on the documents in the envelope.\n- `witness`: Witnesses are recipients whose signatures affirm that the identified signers have signed the documents in the envelope.";
          type: 'string';
        };
        recipientTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireIdLookup: {
          description: 'When **true,** the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ';
          type: 'string';
        };
        requireIdLookupMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        roleName: {
          description: 'Optional element. Specifies the role name associated with the recipient.<br/><br/>This property is required when you are working with template recipients.';
          type: 'string';
        };
        routingOrder: {
          description: 'Specifies the routing order of the recipient in the envelope. ';
          type: 'string';
        };
        routingOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        sentDateTime: {
          description: 'The UTC DateTime when the envelope was sent. This property is read-only.';
          type: 'string';
        };
        signedDateTime: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          type: 'string';
        };
        signingGroupIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
        signingGroupUsers: {
          description: 'A complex type that contains information about users in the signing group.';
          items: {
            $ref: '#/components/schemas/userInfo';
          };
          type: 'array';
        };
        smsAuthentication: {
          $ref: '#/components/schemas/recipientSMSAuthentication';
        };
        socialAuthentications: {
          description: 'Deprecated.';
          items: {
            $ref: '#/components/schemas/socialAuthentication';
          };
          type: 'array';
        };
        status: {
          description: "The status of the recipient. This property is read-only. \n\nValid values:\n\n- `autoresponded`: The recipient's email system auto-responded to the email from DocuSign. This status is used in the web console to inform senders about the bounced-back email. This recipient status is only used if **Send-on-behalf-of** is turned off for the account.\n- `completed`: The recipient has completed their actions (signing or other required actions if not a signer) for an envelope.\n- `created`: The recipient is in a draft state. This value is only associated with draft envelopes (envelopes that have a status of `created`).\n- `declined`: The recipient declined to sign the documents in the envelope.\n- `delivered`: The recipient has viewed the documents in an envelope through the DocuSign signing website. This is not an email delivery of the documents in an envelope.\n- `faxPending`: The recipient has finished signing and the system is waiting for a fax attachment from the recipient before completing their signing step.\n- `sent`: The recipient has been sent an email notification that it is their turn to sign an envelope.\n- `signed`: The recipient has completed (signed) all required tags in an envelope. This is a temporary state during processing, after which the recipient's status automatically switches to `completed`.";
          type: 'string';
        };
        statusCode: {
          description: "The code associated with the recipient's status. This property is read-only.";
          type: 'string';
        };
        suppressEmails: {
          description: 'When **true,** email notifications are suppressed for the recipient, and they must access envelopes and documents from their DocuSign inbox.';
          type: 'string';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        totalTabCount: {
          description: 'The total number of tabs in the documents. This property is read-only.';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'certifiedDelivery';
      'x-ms-summary': "Contains information about a certified delivery recipient. Certified delivery recipients must receive the completed documents for the envelope to be completed. However, they don't need to sign, initial, date or add information to any of the documents.";
    };
    checkbox: {
      description: 'A tab that allows the recipient to select a yes/no (on/off) option.\n';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign-generated custom tab ID for the custom tab to apply. This property can only be used when adding new tabs for a recipient. When used, the new tab inherits all custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The name of the tab. For example, `Sign Here` or `Initial Here`.\n\nIf the `tooltip` attribute is not set, this value will be displayed as the custom tooltip text.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'The page number on which the tab is located.\nFor supplemental documents, this value must be `1`.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireInitialOnSharedChange: {
          description: 'Optional element for field markup. When **true,** the signer is required to initial when they modify a shared field.';
          type: 'string';
        };
        requireInitialOnSharedChangeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'This property does not apply to `checkbox` tabs.\n\nTo require users to check\nat least one, or at most some number\nof checkboxes,\nassociate the checkbox tabs\nwith a [`tabGroup`][tabGroup].\nThen set the following `tabGroup` properties:\n\n- [`maximumAllowed`][maximumAllowed]\n- [`minimumRequired`][minimumRequired]\n- [`groupRule`][groupRule] specifies how the other two properties are interpreted.\n\nYou can find an example\nat [Stack Overflow][so].\n\n[so]:               https://stackoverflow.com/questions/58209376/checkbox-validation-using-docusign-rest-api/58210277#58210277\n[tabGroup]:         /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#definition__enveloperecipienttabs_tabgroups\n[groupRule]:        /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#definition__enveloperecipienttabs_tabgroups_grouprule\n[maximumAllowed]:   /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#definition__enveloperecipienttabs_tabgroups_maximumallowed\n[minimumRequired]:  /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/#definition__enveloperecipienttabs_tabgroups_minimumrequired\n';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        selected: {
          description: 'When **true,** the checkbox is selected.';
          type: 'string';
        };
        selectedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        selectedOriginal: {
          description: '';
          type: 'string';
        };
        selectedOriginalMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        shareToRecipients: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        shareToRecipientsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        shared: {
          description: 'When **true,** this tab is shared.';
          type: 'string';
        };
        sharedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-7, -6)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-7, -6)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'checkbox';
      'x-ms-summary': 'A tab that allows the recipient to select a yes/no (on/off) option.\n';
    };
    chunkedUploadPart: {
      description: 'An object that contains information about the chunked upload part.';
      properties: {
        sequence: {
          description: 'The order of the part in the chunked upload.';
          type: 'string';
        };
        size: {
          description: 'The size of the part in bytes. \n\nDocuSign recommends that a chunked upload part is no larger than a few MB in size.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'chunkedUploadPart';
      'x-ms-summary': 'An object that contains information about the chunked upload part.';
    };
    chunkedUploadRequest: {
      description: 'This is the request object for uploading a chunked upload.';
      properties: {
        chunkedUploadId: {
          description: 'The ID of the chunked upload.\n\n**Note:** This property is ignored in requests, and overridden with an auto-generated value in responses.';
          type: 'string';
        };
        data: {
          description: 'A base64-encoded representation of the content that is used to upload the file. \n\nMaximum size: 50 MB. However, data is also subject to REST API limits regarding request sizes, and Internet Information Systems (IIS) might place further constraints on file size.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'chunkedUploadRequest';
      'x-ms-summary': 'This is the request object for uploading a chunked upload.';
    };
    chunkedUploadResponse: {
      description: 'This response object is returned after you upload a chunked upload.';
      properties: {
        checksum: {
          description: 'A 64-byte, Secure Hash Algorithm 256 (SHA256) checksum that the caller computes across the entirety of the original content that has been uploaded to the chunked upload. DocuSign compares this value to its own computation. If the two values are not equal, the original content and received content are not the same and the commit action is refused.';
          type: 'string';
        };
        chunkedUploadId: {
          description: 'The ID of the chunked upload. ';
          type: 'string';
        };
        chunkedUploadParts: {
          description: 'A list of the parts that compose the chunked upload, including their byte sizes. The list must be contiguous before you can commit the chunked upload.';
          items: {
            $ref: '#/components/schemas/chunkedUploadPart';
          };
          type: 'array';
        };
        chunkedUploadUri: {
          description: 'The URI that you use to reference the chunked upload in other API requests, such as envelope document and envelope attachment requests. ';
          type: 'string';
        };
        committed: {
          description: 'When **true,** the chunked upload has been committed. A committed chunked upload can no longer receive any additional parts and is ready for use within other API requests. ';
          type: 'string';
        };
        expirationDateTime: {
          description: 'The UTC time at which the chunked upload expires and is no longer addressable. \n\n**Note:** You must fully upload and use a chunked upload within 20 minutes of initializing it.\n';
          type: 'string';
        };
        maxChunkedUploadParts: {
          description: 'The maximum number of parts allowed for a chunked upload. This value is configurable per DocuSign environment, account, or integrator. The default value is 128. The maximum possible value is 256.  ';
          type: 'string';
        };
        maxTotalSize: {
          description: 'The maximum total size allowed for a chunked upload. This value is configured per DocuSign environment, account, or integrator. The default value is 50 MB.';
          type: 'string';
        };
        totalSize: {
          description: 'The total size of the parts of the chunked upload.\n\n**Note:** When a chunked upload is used as an envelope document, it is subject to the PDF size limit (25 MB) and page count limit that apply to all envelope documents.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'chunkedUploadResponse';
      'x-ms-summary': 'This response object is returned after you upload a chunked upload.';
    };
    cloudStorageProvider: {
      description: 'Contains details about a specific cloud storage provider.';
      properties: {
        authenticationUrl: {
          description: 'The authentication URL used for the cloud storage provider. This information is only included in the response if the user has not passed authentication for the cloud storage provider. If the redirectUrl query string is provided, the returnUrl is appended to the authenticationUrl. ';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        redirectUrl: {
          description: 'The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.\n\nThe redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.';
          type: 'string';
        };
        service: {
          description: 'The service name for the cloud storage provider.';
          type: 'string';
        };
        serviceId: {
          description: 'The DocuSign-generated ID for the cloud storage provider.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'cloudStorageProvider';
      'x-ms-summary': 'Contains details about a specific cloud storage provider.';
    };
    cloudStorageProviders: {
      description: '';
      properties: {
        storageProviders: {
          description: 'An Array containing the storage providers associated with the user.';
          items: {
            $ref: '#/components/schemas/cloudStorageProvider';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'cloudStorageProviders';
      'x-ms-summary': '';
    };
    comment: {
      description: '';
      properties: {
        envelopeId: {
          description: 'The Guid of the envelope the comment thread belongs to.';
          type: 'string';
        };
        hmac: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        id: {
          description: 'The unique identifier for the comment.';
          type: 'string';
        };
        mentions: {
          description: 'An array of userIds that are mentioned directly in the body of a comment.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        read: {
          description: 'When **true,** indicates that the comment was read.';
          type: 'boolean';
        };
        sentByEmail: {
          description: 'The email address of the user who created the comment.';
          type: 'string';
        };
        sentByFullName: {
          description: 'The full name of the user who created the comment.';
          type: 'string';
        };
        sentByImageId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        sentByInitials: {
          description: 'The initials of the user who created the comment.';
          type: 'string';
        };
        sentByRecipientId: {
          description: 'The recipient ID of the user who created the comment.';
          type: 'string';
        };
        sentByUserId: {
          description: 'The user ID of the user who created the comment.';
          type: 'string';
        };
        signingGroupId: {
          description: 'The ID of the signing group that can view the comment or that created the comment.';
          type: 'string';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
        subject: {
          description: 'The subject of the envelope.';
          type: 'string';
        };
        tabId: {
          description: 'The unique identifier for the tab that represents the comment thread.';
          type: 'string';
        };
        text: {
          description: 'The content of the comment, as UTF-8 text. \n\nMaximum Length: 500 characters.\n\n**Note:** The maximum size allowed for the entire message body is 32 KB. ';
          type: 'string';
        };
        threadId: {
          description: 'The unique identifier for the comment thread.';
          type: 'string';
        };
        threadOriginatorId: {
          description: 'The userId of the user who created the thread.';
          type: 'string';
        };
        timeStampFormatted: {
          description: 'The time the comment was created, formatted according to the format of the user who created the comment.';
          type: 'string';
        };
        timestamp: {
          description: 'The time the comment was created.';
          type: 'string';
        };
        visibleTo: {
          description: 'The user IDs of the users that the comment is visible to.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'comment';
      'x-ms-summary': '';
    };
    commentHistoryResult: {
      description: '';
      properties: {
        comments: {
          description: "An array of comment tabs that contain information about users' comments on documents.";
          items: {
            $ref: '#/components/schemas/comment';
          };
          type: 'array';
        };
        count: {
          description: 'The maximum number of results to return.';
          format: 'int32';
          type: 'integer';
        };
        endTimetoken: {
          description: '';
          type: 'string';
        };
        startTimetoken: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commentHistoryResult';
      'x-ms-summary': '';
    };
    commentPublish: {
      description: '';
      properties: {
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        mentions: {
          description: 'An array of userIds that are mentioned directly in the body of a comment.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        text: {
          description: 'Specifies the text that is shown in the dropdown list. ';
          type: 'string';
        };
        threadAnchorKeys: {
          additionalProperties: {
            type: 'string';
          };
          description: '';
          type: 'object';
        };
        threadId: {
          description: 'The unique identifier for the comment thread.';
          type: 'string';
        };
        visibleTo: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commentPublish';
      'x-ms-summary': '';
    };
    commentThread: {
      description: '';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        comments: {
          description: "An array of comment tabs that contain information about users' comments on documents.";
          items: {
            $ref: '#/components/schemas/comment';
          };
          type: 'array';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        threadId: {
          description: 'The unique identifier for the comment thread.';
          type: 'string';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: 'This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: 'This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commentThread';
      'x-ms-summary': '';
    };
    commentsPublish: {
      description: '';
      properties: {
        commentsToPublish: {
          description: '';
          items: {
            $ref: '#/components/schemas/commentPublish';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commentsPublish';
      'x-ms-summary': '';
    };
    commissionCounty: {
      description: "A Commission County tab displays the county of a notary's commission. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary](/docs/notary-api/).\n";
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: 'This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: 'This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commissionCounty';
      'x-ms-summary': "A Commission County tab displays the county of a notary's commission. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary](/docs/notary-api/).\n";
    };
    commissionExpiration: {
      description: "A Commission Expiration tab displays the expiration date of a notary's commission. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary](/docs/notary-api/).\n";
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: 'This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: 'This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commissionExpiration';
      'x-ms-summary': "A Commission Expiration tab displays the expiration date of a notary's commission. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary](/docs/notary-api/).\n";
    };
    commissionNumber: {
      description: "A Commission Number tab displays a notary's commission number. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/\n";
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: 'This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: 'This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commissionNumber';
      'x-ms-summary': "A Commission Number tab displays a notary's commission number. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/\n";
    };
    commissionState: {
      description: "A Commission State tab displays the state in which a notary's commission was granted. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/\n";
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'Specifies the page number on which the tab is located.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'Indicates the envelope status. Valid values are:\n\n* sent - The envelope is sent to the recipients. \n* created - The envelope is saved as a draft and can be modified and sent later.';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: 'This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: 'This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n';
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'commissionState';
      'x-ms-summary': "A Commission State tab displays the state in which a notary's commission was granted. The tab is populated with the notary's commission information, but the recipient can also edit the value when notarizing. This tab can only be assigned to a remote notary recipient using [DocuSign Notary][notary].\n\n[notary]: /docs/notary-api/\n";
    };
    company: {
      description: "A tab that displays the recipient's company name.\n";
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The name of the tab. For example, `Sign Here` or `Initial Here`.\n\nIf the `tooltip` attribute is not set, this value will be displayed as the custom tooltip text.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'The page number on which the tab is located.\nFor supplemental documents, this value must be `1`.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).\n';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'company';
      'x-ms-summary': "A tab that displays the recipient's company name.\n";
    };
    compositeTemplate: {
      description: 'This object contains information about a [composite template][composite], which you can use to to apply multiple templates to a single envelope, combine templates with PDF forms, and combine templates with documents from cloud sources.\n\n[composite]: /docs/esign-rest-api/esign101/concepts/templates/composite/';
      properties: {
        compositeTemplateId: {
          description: "The ID of this composite template. This ID is used as a reference when adding document object information. If used, the document's `content-disposition` must include the composite template ID to which the document should be added. If a composite template ID is not specified in the content-disposition, the document is applied based on the value of the `documentId` property only. If no document object is specified, the composite template inherits the first document.";
          type: 'string';
        };
        document: {
          $ref: '#/components/schemas/document';
        };
        inlineTemplates: {
          description: ' Zero or more inline templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value.';
          items: {
            $ref: '#/components/schemas/inlineTemplate';
          };
          type: 'array';
        };
        pdfMetaDataTemplateSequence: {
          description: 'A number representing the sequence in which to apply the template that contains the PDF metadata.\n\nExample: `4`';
          type: 'string';
        };
        serverTemplates: {
          description: 'Zero or more server-side templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value.';
          items: {
            $ref: '#/components/schemas/serverTemplate';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'compositeTemplate';
      'x-ms-summary': 'This object contains information about a [composite template][composite], which you can use to to apply multiple templates to a single envelope, combine templates with PDF forms, and combine templates with documents from cloud sources.\n\n[composite]: /docs/esign-rest-api/esign101/concepts/templates/composite/';
    };
    conditionalRecipientRule: {
      description: 'A rule that defines a set of recipients and the conditions under which they will be used for the envelope.';
      properties: {
        conditions: {
          description: 'An array of conditions that define when the recipients will be used.';
          items: {
            $ref: '#/components/schemas/conditionalRecipientRuleCondition';
          };
          type: 'array';
        };
        order: {
          description: 'An integer that specifies the order in which rules are processed.\nLower values are processed before higher values.';
          type: 'string';
        };
        recipientGroup: {
          $ref: '#/components/schemas/recipientGroup';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'conditionalRecipientRule';
      'x-ms-summary': 'A rule that defines a set of recipients and the conditions under which they will be used for the envelope.';
    };
    conditionalRecipientRuleCondition: {
      description: '';
      properties: {
        filters: {
          description: '';
          items: {
            $ref: '#/components/schemas/conditionalRecipientRuleFilter';
          };
          type: 'array';
        };
        order: {
          description: 'An integer that specifies the order in which rules are processed.\nLower values are processed before higher values.';
          type: 'string';
        };
        recipientLabel: {
          description: 'An identifier for the recipient. After assigning this value in a `recipient` object, you can reference it in the `conditions` object to set the recipient as a conditional recipient. For an example, see [How to use conditional recipients](/docs/esign-rest-api/how-to/use-conditional-recipients/).\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'conditionalRecipientRuleCondition';
      'x-ms-summary': '';
    };
    conditionalRecipientRuleFilter: {
      description: '';
      properties: {
        operator: {
          description: 'How the tab value is compared to the `value` property. Valid values:\n\n* `equals`\n* `greaterThan`\n* `greaterThanEquals`\n* `lessThan`\n* `lessThanEquals`\n* `filled`\n* `selected`';
          type: 'string';
        };
        recipientId: {
          description: 'The ID of the recipient (as specified in the `recipients` object).';
          type: 'string';
        };
        scope: {
          description: 'The scope under which the condition is evaluated. Valid values:\n\n* `tabs`';
          type: 'string';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        value: {
          description: "A set value to which the tab's actual value is compared.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'conditionalRecipientRuleFilter';
      'x-ms-summary': '';
    };
    connectConfigResults: {
      description: 'This object contains the results of a ConnectConfigurations::GET method.';
      properties: {
        configurations: {
          description: 'An array of DocuSign Connect configurations.';
          items: {
            $ref: '#/components/schemas/connectCustomConfiguration';
          };
          type: 'array';
        };
        totalRecords: {
          description: 'The number of results.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectConfigResults';
      'x-ms-summary': 'This object contains the results of a ConnectConfigurations::GET method.';
    };
    connectCustomConfiguration: {
      description: 'The `connectCustomConfiguration` object describes a Connect configuration for your account.';
      properties: {
        allUsers: {
          description: 'When **true,** the tracked envelope and recipient events for all users, including users that are added a later time, are sent through Connect. The default value is **false.**\n\n**Note:** If this property is **false,** make sure you set the `userIds` property to a non-empty array of user IDs.';
          type: 'string';
        };
        allUsersExcept: {
          description: 'This flag allows you to toggle between including and excluding specified users from the configuration. When **false,** the users corresponding to the IDs in `userIds` will be included in the configuration. Conversely, when **true,** the users will be excluded from the configuration. The default value is **false.**';
          type: 'string';
        };
        allowEnvelopePublish: {
          description: 'Set this value to **true** to enable the webhook. The default property is **false.**';
          type: 'string';
        };
        allowSalesforcePublish: {
          description: 'When **true,** DocuSign sends data to the designated Salesforce account through Connect. The default value is **true.**';
          type: 'string';
        };
        configurationType: {
          description: 'The type of the configuration. Valid values:\n\n* `custom`: Creates an account-level configuration\n* `customrecipient`: Creates a Recipient Connect configuration\n* `salesforce`\n* `eOriginal`\n\nThis property is required.';
          type: 'string';
        };
        connectId: {
          description: 'The DocuSign-generated ID for the Connect configuration.\n\nThis property is read-only.';
          type: 'string';
        };
        deliveryMode: {
          description: 'The delivery mode of the configuration. Valid values:\n\n* `SIM`\n* `Aggregate`';
          type: 'string';
        };
        disabledBy: {
          description: '';
          type: 'string';
        };
        enableLog: {
          description: 'When **true,** Connect logging is turned on. DocuSign recommends that you enable this functionality to help troubleshoot any issues. \n\nYou can have a maximum of 100 active logs in your account. You can view the entries in active logs in the **Logs** tab in the Connect console.';
          type: 'string';
        };
        envelopeEvents: {
          description: 'A list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `url` property.\n\nWhen using any of [the legacy event message formats](/platform/webhooks/connect/legacy-message-formats/), you must include either the `envelopeEvents` property or the `recipientEvents` property. If you are instead using the [JSON SIM event model](]/platform/webhooks/connect/improved-json-sim-event-model/), use the `events` property.\n\nThe [possible event statuses](/platform/webhooks/connect/event-triggers/) are:\n\n* `Sent`\n* `Delivered`\n* `Completed`\n* `Declined`\n* `Voided`\n\n**Note:** These values are case-sensitive.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        eventData: {
          $ref: '#/components/schemas/connectEventData';
        };
        events: {
          description: 'A comma-separated list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `urlToPublishTo` property.\n\nSet this property when you are using the [JSON SIM event model](/platform/webhooks/connect/improved-json-sim-event-model/). If you are instead using any of [the legacy event message formats](/platform/webhooks/connect/legacy-message-formats/), set either the `envelopeEvents` property or the `recipientEvents` property.\n\nThe [possible event statuses](/platform/webhooks/connect/improved-json-sim-event-model/#eventreference) are:\n\n* `envelope-created`\n* `envelope-sent`\n* `envelope-resent`\n* `envelope-delivered`\n* `envelope-completed`\n* `envelope-declined`\n* `envelope-voided`\n* `recipient-authenticationfailed`\n* `recipient-autoresponded`\n* `recipient-declined`\n* `recipient-delivered`\n* `recipient-completed`\n* `recipient-sent`\n* `recipient-resent`\n* `template-created`\n* `template-modified`\n* `template-deleted`\n* `envelope-corrected`\n* `envelope-purge`\n* `envelope-deleted`\n* `envelope-discard`\n* `recipient-reassign`\n* `recipient-delegate`\n* `recipient-finish-later`\n* `click-agreed`\n* `click-declined`\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        externalFolderId: {
          description: 'The ID of an external folder.';
          type: 'string';
        };
        externalFolderLabel: {
          description: 'The label for an external folder.';
          type: 'string';
        };
        groupIds: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        includeCertSoapHeader: {
          description: '';
          type: 'string';
        };
        includeCertificateOfCompletion: {
          description: 'When **true,** the Connect Service includes the Certificate of Completion with completed envelopes. ';
          type: 'string';
        };
        includeDocumentFields: {
          description: "When **true,** the Document Fields associated with the envelope's documents are included in the notification messages. Document Fields are optional custom name-value pairs added to documents using the API. ";
          type: 'string';
        };
        includeDocuments: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        includeEnvelopeVoidReason: {
          description: 'When **true,** if the envelope is voided, the Connect Service notification will include the void reason, as entered by the person that voided the envelope. ';
          type: 'string';
        };
        includeHMAC: {
          description: '';
          type: 'string';
        };
        includeOAuth: {
          description: '';
          type: 'string';
        };
        includeSenderAccountasCustomField: {
          description: 'When **true,** Connect will include the sender account as Custom Field in the data.';
          type: 'string';
        };
        includeTimeZoneInformation: {
          description: 'When **true,** Connect will include the envelope time zone information.';
          type: 'string';
        };
        integratorManaged: {
          description: '';
          type: 'string';
        };
        name: {
          description: 'The name of the Connect configuration.\n\nThis property is required.';
          type: 'string';
        };
        password: {
          description: 'The password for the Connect configuration.\n\nThis property is not used for the `createHistoricalEnvelopePublishTransaction` endpoint.\n';
          type: 'string';
        };
        recipientEvents: {
          description: 'An array of recipient event statuses that will trigger Connect to send notifications to your webhook listener at the URL endpoint specified in the `url` property. \n\nWhen using any of [the legacy event message formats](/platform/webhooks/connect/legacy-message-formats/), you must include either the `envelopeEvents` property or the `recipientEvents` property. If you are instead using the [JSON SIM event model](/platform/webhooks/connect/improved-json-sim-event-model/), use the `events` property.\n\nThe [possible event statuses](/platform/webhooks/connect/event-triggers/) are:\n\n* `Sent`\n* `AutoResponded`\n* `Delivered`\n* `Completed`\n* `Declined`\n* `AuthenticationFailed`\n\n**Note:** These values are case-sensitive.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        requireMutualTls: {
          description: 'When **true,** [Mutual TLS](/platform/webhooks/mutual-tls/) authentication is enabled.';
          type: 'string';
        };
        requiresAcknowledgement: {
          description: 'When **true,** event delivery acknowledgements are enabled for your Connect configuration.\n\nDocuSign Connect awaits a valid 200 response from your application acknowledging that it received a message. If you do not acknowledge receiving an event notification message within 100 seconds, DocuSign treats the message as a failure and places it into a failure queue. It is imperative that you acknowledge successful receipt of Connect events as they occur by sending a 200 event back.\n\n#### When **true** and Send Individual Messages (SIM) mode is activated\n\nIf the HTTP status response to a notification message is not in the range of 200-299,\nthen the message delivery failed, and the configuration is marked as down.\n\nThe message will be queued and retried once per day.\nWhile a Connect configuration is marked down, subsequent notifications will not be tried. Instead they will be immediately queued with the reason `Pending`.\nWhen a message succeeds, all queued messages for the configuration will be tried immediately, in order.\n\nThere is a maximum of ten retries. Alternately, you can use **Republish Connect Information** to manually republish the notification.\n\n#### When **true** and SIM mode is not activated\n\nIf the HTTP Status response to a notification message is not in the range of 200-299,  then the message delivery failed, and the message is queued.\n\nThe message will be retried after at least a day the next time a subsequent message is successfully sent to this configuration (subscription).  Subsequent notifications will be tried when they occur.\nThere is a maximum of ten retries. Alternately, you can use **Republish Connect Information** to manually republish the notification.\n\n#### When **false**\n\nWhen `requiresAcknowledgement` is set to **false** and you do not acknowledge receiving an event notification message within 100 seconds, DocuSign treats the message as a failure and determines that the server is unavailable. It does not retry to send the notification message, and you must handle the failure manually.\n\n';
          type: 'string';
        };
        salesforceApiVersion: {
          description: 'The version of the Salesforce API that you are using.';
          type: 'string';
        };
        salesforceAuthcode: {
          description: '';
          type: 'string';
        };
        salesforceCallBackUrl: {
          description: '';
          type: 'string';
        };
        salesforceDocumentsAsContentFiles: {
          description: 'When **true,** DocuSign can use documents in your Salesforce account for sending and signing.';
          type: 'string';
        };
        senderOverride: {
          description: '';
          type: 'string';
        };
        senderSelectableItems: {
          description: 'This property sets the items that are available for selection when adding or editing Connect objects. ';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        sfObjects: {
          description: 'An array of Salesforce objects.';
          items: {
            $ref: '#/components/schemas/connectSalesforceObject';
          };
          type: 'array';
        };
        signMessageWithX509Certificate: {
          description: "When **true,** Mutual TLS will be enabled for notifications. Mutual TLS must be initiated by the listener (the customer's web server) during the TLS handshake protocol. ";
          type: 'string';
        };
        soapNamespace: {
          description: 'The namespace of the SOAP interface.\n\n**Note:** If `useSoapInterface` is set to **true,** you must set this value.';
          type: 'string';
        };
        urlToPublishTo: {
          description: 'The web address of the listener or retrieving service endpoint. It must be an HTTPS URL.';
          type: 'string';
        };
        useSoapInterface: {
          description: 'When **true,** the notifications are sent to your endpoint as SOAP requests. ';
          type: 'string';
        };
        userIds: {
          description: 'A comma-separated list of user IDs. This sets the users associated with the tracked envelope and recipient events. When a tracked event occurs for a set user, the a notification message is sent to your Connect listener.\n\nBy default, the users will be included in the configuration. If you want to exclude the users, set the `allUsersExcept` property to **true.**\n\n**Note:** If `allUsers` is set to `false`, then you must provide a list of user IDs.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        userName: {
          description: 'The name of the user.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectCustomConfiguration';
      'x-ms-summary': 'The `connectCustomConfiguration` object describes a Connect configuration for your account.';
    };
    connectDebugLog: {
      description: '';
      properties: {
        connectConfig: {
          description: 'The name of the Connect configuration.';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        eventDateTime: {
          description: 'The UTC date and time of the event.';
          type: 'string';
        };
        eventDescription: {
          description: 'A description of the event.';
          type: 'string';
        };
        payload: {
          description: 'Log output.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectDebugLog';
      'x-ms-summary': '';
    };
    connectDeleteFailureResult: {
      description: '';
      type: 'object';
      'x-ds-definition-name': 'connectDeleteFailureResult';
      'x-ms-summary': '';
    };
    connectEventData: {
      description: 'This object lets you choose the data format of your Connect response.';
      properties: {
        format: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        includeData: {
          description: 'A string array of the data to be included.\nThe default is the empty array `[]`.\n\n- `attachments`: Include attachments associated with the envelope.\n- `custom_fields`: Include the custom fields associated with the envelope.\n- `documents`: Include the documents associated with the envelope.\n- `extensions`: Include information about the email settings associated with the envelope.\n- `folders`: Include the folder where the envelope exists.\n- `payment_tabs`: Include the payment tabs associated with the envelope.\n- `powerform`: Include the PowerForms associated with the envelope.\n- `prefill_tabs`: Include the [pre-filled tabs](/docs/esign-rest-api/esign101/concepts/tabs/prefilled-tabs/) associated with the envelope.\n- `recipients`: Include the recipients associated with the envelope.\n- `tabs`: Include the tabs associated with the envelope.\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        version: {
          description: 'Set this property to `restv2.1` to return event data in JSON. If the property is not set, the event data will be returned in XML by default.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectEventData';
      'x-ms-summary': 'This object lets you choose the data format of your Connect response.';
    };
    connectFailureFilter: {
      description: 'A list of failed envelope IDs to retry.';
      properties: {
        envelopeIds: {
          description: 'An array of envelope GUIDs.\n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        synchronous: {
          description: 'Must be **false.** Setting this property to any other value will result in errors.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectFailureFilter';
      'x-ms-summary': 'A list of failed envelope IDs to retry.';
    };
    connectFailureResult: {
      description: 'This object contains details about a Connect failure result.';
      properties: {
        configId: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        configUrl: {
          description: 'Reserved for DocuSign.\n';
          type: 'string';
        };
        envelopeId: {
          description: 'The envelope ID of the envelope status that failed to post.';
          type: 'string';
        };
        status: {
          description: 'The connection status.';
          type: 'string';
        };
        statusMessage: {
          description: 'A human-readable message describing the connection status.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectFailureResult';
      'x-ms-summary': 'This object contains details about a Connect failure result.';
    };
    connectFailureResults: {
      description: '';
      properties: {
        retryQueue: {
          description: 'Details about a Connect failure result.';
          items: {
            $ref: '#/components/schemas/connectFailureResult';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectFailureResults';
      'x-ms-summary': '';
    };
    connectHistoricalEnvelopeRepublish: {
      description: 'The request body for the `createHistoricalEnvelopePublishTransaction` endpoint.';
      properties: {
        config: {
          $ref: '#/components/schemas/connectCustomConfiguration';
        };
        envelopes: {
          description: 'An array of envelope IDs as comma-separated strings. This property is required.\n\nFor example: `["4280f274-xxxx-xxxx-xxxx-b218b7eeda08","9586h293-xxxx-xxxx-xxxx-m923b8opre71","2347w948-xxxx-xxxx-xxxx-t096b8krno89"]`';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectHistoricalEnvelopeRepublish';
      'x-ms-summary': 'The request body for the `createHistoricalEnvelopePublishTransaction` endpoint.';
    };
    connectLog: {
      description: 'Contains information about a Connect log entry.';
      properties: {
        accountId: {
          description: 'The account ID associated with the envelope.';
          type: 'string';
        };
        configUrl: {
          description: 'The web address of the listener or retrieving service endpoint for Connect.';
          type: 'string';
        };
        connectDebugLog: {
          description: 'A complex element containing information about the Connect configuration, error details, date/time, description and payload.\nThis information is included in the response only when the `additional_info` query is set to **true.**\nThis additional information is only available when retrieving general logs with [ConnectEvents:get](/docs/esign-rest-api/reference/connect/connectevents/get/), but not when retrieving failure logs with [ConnectEvents:listFailures](/docs/esign-rest-api/reference/connect/connectevents/listfailures/).';
          items: {
            $ref: '#/components/schemas/connectDebugLog';
          };
          type: 'array';
        };
        connectId: {
          description: 'The ID of the Connect configuration that failed. If an account has multiple Connect configurations, this value is used to look up the Connect configuration for the failed post.';
          type: 'string';
        };
        created: {
          description: 'The UTC DateTime when the Connect post was created.';
          type: 'string';
        };
        email: {
          description: 'The email address of the envelope sender.';
          type: 'string';
        };
        envelopeId: {
          description: 'The ID of the envelope that failed to post.';
          type: 'string';
        };
        error: {
          description: 'The error that caused the Connect post to fail.';
          type: 'string';
        };
        failureId: {
          description: 'The failure log ID for the failure.';
          type: 'string';
        };
        failureUri: {
          description: 'The URI for the Connect post failure.';
          type: 'string';
        };
        lastTry: {
          description: 'The UTC DateTime of the last attempt to post.';
          type: 'string';
        };
        logId: {
          description: 'The Connect log ID for the entry.';
          type: 'string';
        };
        logUri: {
          description: 'The URI for the Connect log entry.';
          type: 'string';
        };
        retryCount: {
          description: 'The number of times the Connect post has been retried.';
          type: 'string';
        };
        retryUri: {
          description: 'A URI that you can use to retry to publish the Connect post.';
          type: 'string';
        };
        status: {
          description: 'The envelope status for the Connect post. Possible values are:\n- `Any`\n- `Voided`\n- `Created`\n- `Deleted`\n- `Sent`\n- `Delivered`\n- `Signed`\n- `Completed`\n- `Declined`\n- `TimedOut`\n- `Template`\n- `Processing`\n\nFor details about these statuses, see [Envelope Status Code Descriptions](/docs/esign-rest-api/esign101/rules-and-limits/responses/).';
          type: 'string';
        };
        subject: {
          description: 'The subject of the envelope.';
          type: 'string';
        };
        userName: {
          description: 'The name of the sender of the envelope.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectLog';
      'x-ms-summary': 'Contains information about a Connect log entry.';
    };
    connectLogs: {
      description: '';
      properties: {
        failures: {
          description: 'An array of containing failure information from the Connect failure log.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        logs: {
          description: 'A list of Connect general logs.';
          items: {
            $ref: '#/components/schemas/connectLog';
          };
          type: 'array';
        };
        totalRecords: {
          description: 'The count of records in the log list.';
          type: 'string';
        };
        type: {
          description: 'The type of this tab. Values are:\n\n- Approve\n- CheckBox\n- Company\n- Date\n- DateSigned,\tDecline\n- Email,\tEmailAddress\n- EnvelopeId\n- FirstName\n- Formula\n- FullName,\tInitialHere\n- InitialHereOptional\n- LastName\n- List\n- Note\n- Number\n- Radio\n- SignerAttachment\n- SignHere\n- SignHereOptional\n- Ssn\n- Text\n- Title\n- Zip5\n- Zip5Dash4\n';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectLogs';
      'x-ms-summary': '';
    };
    connectOAuthConfig: {
      description: 'A complex object describing a Connect OAuth configuration.';
      properties: {
        authorizationServerUrl: {
          description: 'The token URL for your authorization server or OAuth service.\n\nThis property is required.';
          type: 'string';
        };
        clientId: {
          description: 'The client ID assigned to your app by your authorization server or OAuth service.\n\nThis property is required.';
          type: 'string';
        };
        clientSecret: {
          description: 'The secret value provided by your authorization server.\n\nThis property is required.';
          type: 'string';
        };
        customParameters: {
          additionalProperties: {
            type: 'string';
          };
          description: '';
          type: 'string';
        };
        scope: {
          description: 'The scopes that your app will request from the authorization server.\n\nThis property is optional.\n\n**Note:** If you are using Azure, this value is the application ID URI of the secified resource affixed with the `.default`. For example: `api://{{clientId}}/.default`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectOAuthConfig';
      'x-ms-summary': 'A complex object describing a Connect OAuth configuration.';
    };
    connectSalesforceField: {
      description: 'This object is used to match a DocuSign field to a Salesforce field so that DocuSign can send information to your Salesforce account.';
      properties: {
        dsAttribute: {
          description: '';
          type: 'string';
        };
        dsLink: {
          description: 'A URL that links to the information in the DocuSign field.';
          type: 'string';
        };
        dsNode: {
          description: '';
          type: 'string';
        };
        id: {
          description: 'A unique ID for the Salesforce object.';
          type: 'string';
        };
        sfField: {
          description: '';
          type: 'string';
        };
        sfFieldName: {
          description: 'The name of the Salesforce field.';
          type: 'string';
        };
        sfFolder: {
          description: 'The name of the Salesforce folder.';
          type: 'string';
        };
        sfLockedValue: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectSalesforceField';
      'x-ms-summary': 'This object is used to match a DocuSign field to a Salesforce field so that DocuSign can send information to your Salesforce account.';
    };
    connectSalesforceObject: {
      description: 'A `connectSalesforceObject` is an object that updates envelope and document status or recipient status in your Salesforce account.\n\nWhen you install DocuSign Connect for Salesforce, the service automatically sets up two Connect objects: one that updates envelope status and documents and one that updates recipient status. You can also customize DocuSign Connect for Salesforce by associating DocuSign objects with Salesforce objects so that DocuSign Connect for Salesforce updates or inserts the information into the Salesforce object. For more information, see \n[DocuSign for Salesforce - Adding Completed Documents to the Notes and Attachments](https://support.docusign.com/articles/DocuSign-for-Salesforce-Adding-Completed-Documents-to-the-Notes-and-Attachments-New).';
      properties: {
        active: {
          description: 'When **true,** the `connectSalesforceObject` is active.';
          type: 'string';
        };
        description: {
          description: 'A description of the `connectSalesforceObject`.';
          type: 'string';
        };
        id: {
          description: 'The ID of the `connectSalesforceObject`.';
          type: 'string';
        };
        insert: {
          description: '';
          type: 'string';
        };
        onCompleteOnly: {
          description: 'When **true,** Salesforce is updated only when the envelope is complete.';
          type: 'string';
        };
        selectFields: {
          description: 'The DocuSign and Salesforce fields that you want to use to match a Salesforce object with DocuSign information. This information tells Connect when to send updates to Salesforce.';
          items: {
            $ref: '#/components/schemas/connectSalesforceField';
          };
          type: 'array';
        };
        sfObject: {
          description: 'The Salesforce.com object type, such as `case`, `contact`, or `opportunity`.';
          type: 'string';
        };
        sfObjectName: {
          description: 'A name for the Salesforce object.\n\n**Note:** You can enter any name for the object. It does not have to match the `sfObject` property.';
          type: 'string';
        };
        updateFields: {
          description: 'The DocuSign and Salesforce fields that you want to update. \n\n**Note:** You can choose to update SalesForce (with information from DocuSign) only, update DocuSign only, or both.';
          items: {
            $ref: '#/components/schemas/connectSalesforceField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectSalesforceObject';
      'x-ms-summary': 'A `connectSalesforceObject` is an object that updates envelope and document status or recipient status in your Salesforce account.\n\nWhen you install DocuSign Connect for Salesforce, the service automatically sets up two Connect objects: one that updates envelope status and documents and one that updates recipient status. You can also customize DocuSign Connect for Salesforce by associating DocuSign objects with Salesforce objects so that DocuSign Connect for Salesforce updates or inserts the information into the Salesforce object. For more information, see \n[DocuSign for Salesforce - Adding Completed Documents to the Notes and Attachments](https://support.docusign.com/articles/DocuSign-for-Salesforce-Adding-Completed-Documents-to-the-Notes-and-Attachments-New).';
    };
    connectUserInfo: {
      description: '';
      properties: {
        email: {
          description: '';
          type: 'string';
        };
        isIncluded: {
          description: '';
          type: 'string';
        };
        userId: {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          type: 'string';
        };
        userName: {
          description: 'The name of the user.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectUserInfo';
      'x-ms-summary': '';
    };
    connectUserObject: {
      description: '';
      properties: {
        configurationtype: {
          description: 'The type of custom Connect configuration being accessed.';
          type: 'string';
        };
        connectId: {
          description: 'The ID of the custom Connect configuration being accessed.';
          type: 'string';
        };
        enabled: {
          description: 'Boolean value that indicates whether the custom Connect configuration is enabled or not.';
          type: 'string';
        };
        hasAccess: {
          description: '';
          type: 'string';
        };
        senderSearchableItems: {
          description: '';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'connectUserObject';
      'x-ms-summary': '';
    };
    consentDetails: {
      description: '';
      properties: {
        consentKey: {
          description: '';
          type: 'string';
        };
        deliveryMethod: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        signerConsentStatus: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'consentDetails';
      'x-ms-summary': '';
    };
    consoleViewRequest: {
      description: 'The request object for the [EnvelopeViews: createConsole](/docs/esign-rest-api/reference/envelopes/envelopeviews/createconsole/) method.';
      properties: {
        envelopeId: {
          description: 'The ID of an envelope. If the envelope has been sent, the endpoint returns a URL for a view of the documents. If the envelope has not yet been sent, the endpoint returns a URL for the sender view.\n\nThis property is optional. If no value is provided, the endpoint returns a URL for the front page of the demo UI.';
          type: 'string';
        };
        returnUrl: {
          description: 'The URL to which the user should be redirected. This is only used when the `envelopeId` is specified as a draft envelope. In this case, the endpoint returns a URL for the sender view. When the user exits the sender view, they will be redirected to the `returnUrl` value. If no value is provided, there is no option to leave the sender view.\n\nIn other cases, the user is not redirected out of the console view.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'consoleViewRequest';
      'x-ms-summary': 'The request object for the [EnvelopeViews: createConsole](/docs/esign-rest-api/reference/envelopes/envelopeviews/createconsole/) method.';
    };
    consumerDisclosure: {
      description: 'Details about consumer disclosures.';
      properties: {
        accountEsignId: {
          description: 'The GUID of the account associated with the consumer disclosure.';
          type: 'string';
        };
        allowCDWithdraw: {
          description: 'When **true,** indicates that the customer can withdraw their consent to the consumer disclosure when they decline to sign documents. If these recipients sign documents sent to them from your account in the future, they will be required to agree to the terms in the disclosure. The default value is **false.**\n**Note:** Only Admin users can change this setting.';
          type: 'string';
        };
        allowCDWithdrawMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        changeEmail: {
          description: 'If the customer needs to change their email address, this is the email address to which they should the change request.\n\nMaximum length: 100 characters.';
          type: 'string';
        };
        changeEmailOther: {
          description: 'Other information about the requirements for the user to change their email address.\n\nMaximum length: 255 characters.\n\nExample: \n\n`We do not require any other information from you to change your email address.`';
          type: 'string';
        };
        companyName: {
          description: "Specifies the company name used in the disclosure. The default value is the account name.\n\nHowever, if your account uses signing brands that specify a company name, you can substitute the brand's company name by setting the `useBrand` property to **true.** Whenever an envelope is sent from the account that uses a signing brand with a specified `companyName`, that value is used in email notifications and in the signing experience.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. You must also set the value of the `useBrand` property to **true.**";
          type: 'string';
        };
        companyPhone: {
          description: 'The phone number of the company associated with the consumer disclosure, as a free-formatted string.';
          type: 'string';
        };
        copyCostPerPage: {
          description: 'The cost per page if the customer requests paper copies.\n\nExample: \n\n`0.0000`';
          type: 'string';
        };
        copyFeeCollectionMethod: {
          description: 'Specifies the fee collection method for cases in which the customer requires paper copies of the document.\n\nMaximum length: 255 characters.\n\nExample: \n\n`We will bill you for any fees at that time, if any.`';
          type: 'string';
        };
        copyRequestEmail: {
          description: 'The email address to which the customer should send a request for copies of a document.\n\nMaximum length: 100 characters.';
          type: 'string';
        };
        custom: {
          description: 'When **true,** indicates that the consumer disclosure is a custom disclosure. The default is **false.**';
          type: 'string';
        };
        enableEsign: {
          description: 'When **true** (default), indicates that eSign is enabled.';
          type: 'string';
        };
        esignAgreement: {
          description: 'The final, assembled text of the Electronic Record and Signature Disclosure that includes the appropriate `companyName` and other specifics. It also includes the HTML tags used for formatting.';
          type: 'string';
        };
        esignText: {
          description: 'The template for the Electronic Record and Signature Disclosure, which contains placeholders for information such as the `companyName`. It also includes the HTML tags used for formatting.\n\n**Note:** If you are switching to or updating a custom disclosure, you can edit both the text and the HTML formatting.';
          type: 'string';
        };
        languageCode: {
          description: 'The code for the language version of the disclosure. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          type: 'string';
        };
        mustAgreeToEsign: {
          description: "When **true,** the  recipient must agree to the consumer disclosure. The value of this property is read-only. It is calculated based on the account setting `consumerDisclosureFrequency` and the user's actions.";
          type: 'string';
        };
        pdfId: {
          description: '**Deprecated.** \n\nThe `pdfId` property in the consumer_disclosure PUT request is deprecated. For security reasons going forward, any value provided in the request packet must be ignored. ';
          type: 'string';
        };
        useBrand: {
          description: 'When **true,** specifies that the company name in the signing brand is used for the disclosure. Whenever an envelope is sent from the account that uses a signing brand with a specified company name, that value is used in email notifications and in the signing experience.  \n\nWhen **false** (default), or if the signing brand does not specify a company name, the account name is used instead.\n\n**Note:** This substitution only works if you use the default legal disclosure or if you apply the `companyName` to the merge fields in a custom ERSD. ';
          type: 'string';
        };
        useConsumerDisclosureWithinAccount: {
          description: 'When **true,** specifies that recipients in the same account as the sender must agree to eSign an Electronic Record and Signature Disclosure Statement.';
          type: 'string';
        };
        useConsumerDisclosureWithinAccountMetadata: {
          $ref: '#/components/schemas/settingsMetadata';
        };
        withdrawAddressLine1: {
          description: 'Contains the first address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawAddressLine2: {
          description: 'Contains the second address line of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawByEmail: {
          description: 'When **true** (default), indicates that the customer can withdraw consent by email.';
          type: 'string';
        };
        withdrawByMail: {
          description: 'When **true,** indicates that the customer can withdraw consent by postal mail. The default is **false.**';
          type: 'string';
        };
        withdrawByPhone: {
          description: 'When **true,** indicates that the customer can withdraw consent by phone. The default is **false.**';
          type: 'string';
        };
        withdrawCity: {
          description: 'Contains the city of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 50 characters. ';
          type: 'string';
        };
        withdrawConsequences: {
          description: 'Text indicating the consequences of withdrawing consent.\n\nMaximum length: 255 characters.';
          type: 'string';
        };
        withdrawEmail: {
          description: 'Contains the email address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 100 characters. ';
          type: 'string';
        };
        withdrawOther: {
          description: 'Contains any other information needed to withdraw consent.\n\nMaximum length: 255 characters.\n\nExample:\n\n`We do not need any other information from you to withdraw consent.`';
          type: 'string';
        };
        withdrawPhone: {
          description: 'Contains the phone number that a customer can call to register consent withdrawal notification as a free-formatted string.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawPostalCode: {
          description: 'Contains the postal code of the postal address to which a customer can send a consent withdrawal notification.\n\nMaximum length: 20 characters. ';
          type: 'string';
        };
        withdrawState: {
          description: 'Contains the state of the postal address to which a customer can send a consent withdrawal notification.\n\nExample: `PA`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'consumerDisclosure';
      'x-ms-summary': 'Details about consumer disclosures.';
    };
    contact: {
      description: '';
      properties: {
        cloudProvider: {
          description: 'The cloud service that provided the contact. Valid values are:\n\n- `rooms`\n- `docusignCore` (default)\n\n<!-- Future:\n\n- `Box`\n- `GoogleDrive`\n- `Dropbox`\n- `SalesForce`\n- `SkyDrive`\n\n-->';
          type: 'string';
        };
        cloudProviderContainerId: {
          description: 'The ID of the container at the cloud provider. For example, this might be the room ID for a DocuSign Transaction Room.';
          type: 'string';
        };
        contactId: {
          description: "The ID of a contact person in the account's address book.";
          type: 'string';
        };
        contactPhoneNumbers: {
          description: "A list of the contact's phone numbers.\n\n**Note:** The phone numbers associated with shared contacts do not display to users other than the user who added the contact. Additionally, in the following scenarios, the phone number of a shared contact does not populate automatically for anyone other than the user who added the contact:\n\n- Sending an envelope by using SMS\n- Using phone authentication\n\nYou must ask the user who added the contact for the phone number and then manually enter it into the authentication box.";
          items: {
            $ref: '#/components/schemas/contactPhoneNumber';
          };
          type: 'array';
        };
        contactUri: {
          description: 'The URI for retrieving information about the contact.';
          type: 'string';
        };
        emails: {
          description: 'An array of email addresses.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        isOwner: {
          description: '';
          type: 'boolean';
        };
        name: {
          description: 'The name of the contact.';
          type: 'string';
        };
        notaryContactDetails: {
          $ref: '#/components/schemas/notaryContactDetails';
        };
        organization: {
          description: '';
          type: 'string';
        };
        roomContactType: {
          description: '';
          type: 'string';
        };
        shared: {
          description: 'When **true,** this contact is shared.';
          type: 'string';
        };
        signingGroup: {
          description: 'The ID of the signing group.';
          type: 'string';
        };
        signingGroupName: {
          description: 'Optional. The name of the signing group. \n\nMaximum Length: 100 characters. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'contact';
      'x-ms-summary': '';
    };
    contactGetResponse: {
      description: 'This response object contains information about the contacts associated with an account.';
      properties: {
        contacts: {
          description: 'A list of contacts.';
          items: {
            $ref: '#/components/schemas/contact';
          };
          type: 'array';
        };
        endPosition: {
          description: 'The last index position in the result set. ';
          type: 'string';
        };
        nextUri: {
          description: 'The URI for the next chunk of records based on the search request. It is `null` if this is the last set of results for the search. ';
          type: 'string';
        };
        previousUri: {
          description: 'The URI for the prior chunk of records based on the search request. It is `null` if this is the first set of results for the search. ';
          type: 'string';
        };
        resultSetSize: {
          description: 'The number of results in this response. Because you can filter which entries are included in the response, this value is always less than or equal to the `totalSetSize`.';
          type: 'string';
        };
        startPosition: {
          description: 'The starting index position of the current result set.';
          type: 'string';
        };
        totalSetSize: {
          description: 'The total number of items in the result set. This value is always greater than or equal to the value of `resultSetSize`.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'contactGetResponse';
      'x-ms-summary': 'This response object contains information about the contacts associated with an account.';
    };
    contactModRequest: {
      description: 'The request object containing the new information for the contacts.';
      properties: {
        contactList: {
          description: 'A list of contacts.';
          items: {
            $ref: '#/components/schemas/contact';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'contactModRequest';
      'x-ms-summary': 'The request object containing the new information for the contacts.';
    };
    contactPhoneNumber: {
      description: 'Details about the phone numbers associated with a specific contact.';
      properties: {
        phoneNumber: {
          description: "The contact's phone number.\n\nExample: `+12223334444`";
          type: 'string';
        };
        phoneType: {
          description: 'The type of phone number. Valid values are:\n\n- `home`\n- `mobile`\n- `work`\n- `other`\n- `fax`';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'contactPhoneNumber';
      'x-ms-summary': 'Details about the phone numbers associated with a specific contact.';
    };
    contactUpdateResponse: {
      description: 'This response objects shows the updated details for the contacts.';
      properties: {
        contacts: {
          description: 'A list of contacts.';
          items: {
            $ref: '#/components/schemas/contact';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'contactUpdateResponse';
      'x-ms-summary': 'This response objects shows the updated details for the contacts.';
    };
    correctViewRequest: {
      description: 'The request body for the [EnvelopeViews: createCorrect](/docs/esign-rest-api/reference/envelopes/envelopeviews/createcorrect/) method.';
      properties: {
        beginOnTagger: {
          description: '';
          type: 'string';
        };
        returnUrl: {
          description: '(Required) The URL to which the user should be redirected after\nthe view session has ended.\n\nMaximum Length: 470 characters. If the `returnUrl` exceeds this\nlimit, the user is redirected to a truncated URL\nBe sure to include `https://` in the URL\nor redirecting might fail on some browsers.\n\nWhen DocuSign redirects to\nthis URL, it will include an `event` query parameter that your app can use:\n\n* `send`: User corrected and sent the envelope.\n* `save`: User saved the envelope.\n* `cancel`: User canceled the transaction.\n* `error`: There was an error when performing the correct or send.\n* `sessionEnd`: The session ended before the user completed a different action.\n';
          type: 'string';
        };
        suppressNavigation: {
          description: 'Specifies whether the window is displayed with or without dressing.';
          type: 'string';
        };
        viewUrl: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'correctViewRequest';
      'x-ms-summary': 'The request body for the [EnvelopeViews: createCorrect](/docs/esign-rest-api/reference/envelopes/envelopeviews/createcorrect/) method.';
    };
    country: {
      description: '';
      properties: {
        isoCode: {
          description: '';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        provinceValidated: {
          description: '';
          type: 'string';
        };
        provinces: {
          description: '';
          items: {
            $ref: '#/components/schemas/province';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'country';
      'x-ms-summary': '';
    };
    creditCardInformation: {
      description: 'This object contains information about a credit card that is associated with an account.';
      properties: {
        address: {
          $ref: '#/components/schemas/addressInformation';
        };
        cardLastDigits: {
          description: '';
          type: 'string';
        };
        cardNumber: {
          description: 'The credit card number.';
          type: 'string';
        };
        cardType: {
          description: 'The type of credit card. Valid values are: \n\n- `visa` \n- `mastercard` \n- `amex`';
          type: 'string';
        };
        cvNumber: {
          description: 'The 3 or 4-digit card verification value (CVV) number associated with the credit card. CVV numbers are also referred to as card security codes (CSCs).';
          type: 'string';
        };
        expirationMonth: {
          description: 'The month that the credit card expires, expressed as a number from 1 to 12.';
          type: 'string';
        };
        expirationYear: {
          description: 'The year in which the credit card expires, in 4-digit format.';
          type: 'string';
        };
        nameOnCard: {
          description: 'The exact name as it appears on the credit card.';
          type: 'string';
        };
        tokenizedCard: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'creditCardInformation';
      'x-ms-summary': 'This object contains information about a credit card that is associated with an account.';
    };
    creditCardTypes: {
      description: '';
      properties: {
        cardTypes: {
          description: 'An array containing supported credit card types.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'creditCardTypes';
      'x-ms-summary': '';
    };
    currencyFeatureSetPrice: {
      description: 'Information about the price and currency associated with the feature set. Reserved for internal DocuSign use only.';
      properties: {
        currencyCode: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        currencySymbol: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        envelopeFee: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        fixedFee: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        seatFee: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'currencyFeatureSetPrice';
      'x-ms-summary': 'Information about the price and currency associated with the feature set. Reserved for internal DocuSign use only.';
    };
    currencyPlanPrice: {
      description: '';
      properties: {
        currencyCode: {
          description: 'Specifies the ISO currency code for the account.';
          type: 'string';
        };
        currencySymbol: {
          description: 'Specifies the currency symbol for the account.';
          type: 'string';
        };
        perSeatPrice: {
          description: 'The per-seat price associated with the plan.\n\nExample: `"456.0000"`';
          type: 'string';
        };
        supportIncidentFee: {
          description: 'The support incident fee charged for each support incident.\n\nExample: `"$0.00"`';
          type: 'string';
        };
        supportPlanFee: {
          description: 'The support plan fee charged for this plan.\n\nExample: `"$0.00"`';
          type: 'string';
        };
        supportedCardTypes: {
          $ref: '#/components/schemas/creditCardTypes';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'currencyPlanPrice';
      'x-ms-summary': '';
    };
    customField: {
      description: 'This object provides details about a custom field.';
      properties: {
        customFieldType: {
          description: 'The type of custom field. Valid values are:\n\n- `text` (default)\n- `list`';
          type: 'string';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        fieldId: {
          description: 'The ID of the custom field.';
          type: 'string';
        };
        listItems: {
          description: 'For a list custom field, this is an array of strings that represent the items in a list. \n\nMaximum Length: 2,000 characters.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
        name: {
          description: 'The name of the custom field.';
          type: 'string';
        };
        required: {
          description: 'When **true,** the signer must complete the custom field.';
          type: 'string';
        };
        show: {
          description: 'When **true,** the custom field displays at the top of the Certificate of Completion.';
          type: 'string';
        };
        value: {
          description: 'Specifies the value of the custom field. \n\nMaximum Length: 2,000 characters.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'customField';
      'x-ms-summary': 'This object provides details about a custom field.';
    };
    customFields: {
      description: 'Contains information about custom fields.';
      properties: {
        listCustomFields: {
          description: 'An array of list custom fields.';
          items: {
            $ref: '#/components/schemas/listCustomField';
          };
          type: 'array';
        };
        textCustomFields: {
          description: 'An array of text custom fields.';
          items: {
            $ref: '#/components/schemas/textCustomField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'customFields';
      'x-ms-summary': 'Contains information about custom fields.';
    };
    customFieldsEnvelope: {
      description: '';
      properties: {
        listCustomFields: {
          description: 'An array of list custom fields.';
          items: {
            $ref: '#/components/schemas/listCustomField';
          };
          type: 'array';
        };
        textCustomFields: {
          description: 'An array of text custom fields.';
          items: {
            $ref: '#/components/schemas/textCustomField';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'customFieldsEnvelope';
      'x-ms-summary': '';
    };
    customSettingsInformation: {
      description: '';
      properties: {
        customSettings: {
          description: 'The name/value pair information for the user custom setting.';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'customSettingsInformation';
      'x-ms-summary': '';
    };
    date: {
      description: 'A tab that allows the recipient to enter a date. Date tabs\nare one-line fields that allow date information to be\nentered in any format. The tooltip for this tab recommends\nentering the date as MM/DD/YYYY, but this is not enforced.\nThe format entered by the signer is retained. If you need a\nparticular date format enforced, DocuSign recommends using a\nText tab with a validation pattern and a validation message\nto enforce the format.\n';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        concealValueOnDocument: {
          description: 'When **true,** the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.\n\nWhen an envelope is completed the information is only available to the sender through the Form Data link in the DocuSign Console. The information on the downloaded document remains masked by asterisks.\n\nThis setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.';
          type: 'string';
        };
        concealValueOnDocumentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        disableAutoSize: {
          description: 'When **true,** disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.';
          type: 'string';
        };
        disableAutoSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        locked: {
          description: 'When **true,** the signer cannot change the data of the custom tab.';
          type: 'string';
        };
        lockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        maxLength: {
          description: 'An optional value that describes the maximum length of the property when the property is a string.';
          type: 'string';
        };
        maxLengthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The name of the tab. For example, `Sign Here` or `Initial Here`.\n\nIf the `tooltip` attribute is not set, this value will be displayed as the custom tooltip text.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        originalValue: {
          description: 'The initial value of the tab when it was sent to the recipient. ';
          type: 'string';
        };
        originalValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'The page number on which the tab is located.\nFor supplemental documents, this value must be `1`.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireAll: {
          description: 'When **true** and shared is true, information must be entered in this field to complete the envelope. ';
          type: 'string';
        };
        requireAllMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        requireInitialOnSharedChange: {
          description: 'Optional element for field markup. When **true,** the signer is required to initial when they modify a shared field.';
          type: 'string';
        };
        requireInitialOnSharedChangeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        requiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        senderRequired: {
          description: 'When **true,** the sender must populate the tab before an envelope can be sent using the template. \n\nThis value tab can only be changed by modifying (PUT) the template. \n\nTabs with a `senderRequired` value of true cannot be deleted from an envelope.';
          type: 'string';
        };
        senderRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        shareToRecipients: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        shareToRecipientsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        shared: {
          description: 'When **true,** this custom tab is shared.';
          type: 'string';
        };
        sharedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).\n';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: 'The text of a tooltip that appears when a user hovers over a form field or tab.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        validationMessage: {
          description: 'The message displayed if the custom tab fails input validation (either custom of embedded).';
          type: 'string';
        };
        validationMessageMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        validationPattern: {
          description: 'A regular expression used to validate input for the tab.';
          type: 'string';
        };
        validationPatternMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'date';
      'x-ms-summary': 'A tab that allows the recipient to enter a date. Date tabs\nare one-line fields that allow date information to be\nentered in any format. The tooltip for this tab recommends\nentering the date as MM/DD/YYYY, but this is not enforced.\nThe format entered by the signer is retained. If you need a\nparticular date format enforced, DocuSign recommends using a\nText tab with a validation pattern and a validation message\nto enforce the format.\n';
    };
    dateSigned: {
      description: 'A tab that displays the date that the recipient signed the\ndocument.\n';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        name: {
          description: 'The name of the tab. For example, `Sign Here` or `Initial Here`.\n\nIf the `tooltip` attribute is not set, this value will be displayed as the custom tooltip text.';
          type: 'string';
        };
        nameMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        pageNumber: {
          description: 'The page number on which the tab is located.\nFor supplemental documents, this value must be `1`.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: '**Note:** Date Signed tabs never display this tooltip in the signing interface.\n\nAlthough you can technically set a value via the API for this tab,\nit will not be displayed to the recipient.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
        valueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'dateSigned';
      'x-ms-summary': 'A tab that displays the date that the recipient signed the\ndocument.\n';
    };
    dateStampProperties: {
      description: 'Specifies the area in which a date stamp is placed. This parameter uses pixel positioning to draw a rectangle at the center of the stamp area. The stamp is superimposed on top of this central area.\n\nThis property contains the following information about the central rectangle:\n\n- `DateAreaX`: The X axis position of the top-left corner.\n- `DateAreaY`: The Y axis position of the top-left corner.\n- `DateAreaWidth`: The width of the rectangle.\n- `DateAreaHeight`: The height of the rectangle.';
      properties: {
        dateAreaHeight: {
          description: 'The height of the rectangle.';
          type: 'string';
        };
        dateAreaWidth: {
          description: 'The width of the rectangle.';
          type: 'string';
        };
        dateAreaX: {
          description: 'The X axis position of the top-left corner.';
          type: 'string';
        };
        dateAreaY: {
          description: 'The Y axis position of the top-left corner.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'dateStampProperties';
      'x-ms-summary': 'Specifies the area in which a date stamp is placed. This parameter uses pixel positioning to draw a rectangle at the center of the stamp area. The stamp is superimposed on top of this central area.\n\nThis property contains the following information about the central rectangle:\n\n- `DateAreaX`: The X axis position of the top-left corner.\n- `DateAreaY`: The Y axis position of the top-left corner.\n- `DateAreaWidth`: The width of the rectangle.\n- `DateAreaHeight`: The height of the rectangle.';
    };
    decline: {
      description: 'A tab that allows the recipient the option of declining an\nenvelope. If the recipient clicks the tab during the signing\nprocess, the envelope is voided.\n';
      properties: {
        anchorAllowWhiteSpaceInCharacters: {
          description: 'When **true,** the text string in the document may have extra whitespace and still match the anchor string. This occurs in two cases.\n\nFirst, it matches if the document string has a single extra whitespace character following a non-whitespace character in the anchor string. For example, if the anchor string is `DocuSign`, then `Docu Sign` will match. However, <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will not match.\n\nSecond, it matches if the document string has one or more extra whitespace characters following a whitespace character in the anchor string. For example, if the anchor string is `Docu Sign`, then <code>Docu&nbsp;&nbsp;&nbsp;Sign</code> will match.\n\nThe default value is **true.**\n';
          type: 'string';
        };
        anchorAllowWhiteSpaceInCharactersMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorCaseSensitive: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are placed. When **true,** the text string in a document must match the case of the `anchorString` property for an anchor tab to be created. The default value is **false.**\n\nFor example, when set to **true,** if the anchor string is `DocuSign`, then `DocuSign` will match but `Docusign`, `docusign`, `DoCuSiGn`, etc. will not match. When **false,** `DocuSign`, `Docusign`, `docusign`, `DoCuSiGn`, etc. will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/';
          type: 'string';
        };
        anchorCaseSensitiveMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorHorizontalAlignment: {
          description: 'This property controls how [anchor tabs][AnchorTabs] are aligned in relation to the anchor text. Possible values are :\n\n- `left`: Aligns the left side of the tab with the beginning of the first character of the matching anchor word. This is the default value.\n- `right`: Aligns the tab’s left side with the last character of the matching anchor word.\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTabs]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorHorizontalAlignmentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorIgnoreIfNotPresent: {
          description: 'When **true,** this tab is ignored if the `anchorString` is not found in the document.';
          type: 'string';
        };
        anchorIgnoreIfNotPresentMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorMatchWholeWord: {
          description: 'When **true,** the text string in a document must match the value of the `anchorString` property in its entirety for an [anchor tab][AnchorTab] to be created. The default value is **false.**\n\nFor example, when set to **true,** if the input is `man` then `man` will match but `manpower`, `fireman`, and `penmanship` will not. When **false,** if the input is `man` then `man`, `manpower`, `fireman`, and `penmanship` will all match.\n\nThis functionality uses the following rules:\n\n- Unless punctuation is specified in the `anchorString`, this functionality ignores punctuation and the following characters:\n\n  $~><|^+=\n\n  For example, the `anchorString` `water` will match on the string `Fetch a pail of water.`\n\n- Strings embedded in other strings are ignored during the matching process.\n\n- In words that have dashes, the parts separated by dashes are treated as distinct words.\n\n  Example: If the anchor string is `forget`, then an anchor tab is placed on the `forget` in `forget-me-not`, even when `anchorMatchWholeWord` is set to **true.**\n\n- Letters with accent marks are treated as distinct characters from their unaccented counterparts.\n\n- For single-character anchor strings, if the two characters appear right next to each other in the document, a single anchor tab is placed for both of them.\n\n  Example: If the anchor string is `i`, then only one anchor tab is placed in `skiing`.\n\n- Unlike punctuation, numbers are not ignored when finding anchor words.\n\n  Example: If the anchor string is `cat`, then `-cat-` is matched but `1cat2` is not when `anchorMatchWholeWord` is set to **true** (its default value).\n\n\n**Note:** You can only specify the value of this property in POST requests.\n\n[AnchorTab]: /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n';
          type: 'string';
        };
        anchorMatchWholeWordMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorString: {
          description: 'Specifies the string to find in the document and use as the basis for tab placement.';
          type: 'string';
        };
        anchorStringMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorTabProcessorVersion: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        anchorTabProcessorVersionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorUnits: {
          description: 'Specifies units of the `anchorXOffset` and `anchorYOffset`. Valid units are:\n\n- `pixels` (default)\n- `inches`\n- `mms`\n- `cms`\n';
          type: 'string';
        };
        anchorUnitsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorXOffset: {
          description: 'Specifies the X axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorXOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        anchorYOffset: {
          description: 'Specifies the Y axis location of the tab in `anchorUnits` relative to the `anchorString`.\n';
          type: 'string';
        };
        anchorYOffsetMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        bold: {
          description: 'When **true,** the information in the tab is bold.';
          type: 'string';
        };
        boldMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        buttonText: {
          description: ' Specifies the decline text displayed in the tab.';
          type: 'string';
        };
        buttonTextMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        caption: {
          description: '';
          type: 'string';
        };
        captionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentLabel: {
          description: "For conditional fields this is the `tabLabel` of the parent tab that controls this tab's visibility.";
          type: 'string';
        };
        conditionalParentLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        conditionalParentValue: {
          description: 'For conditional fields, this is the value of the parent tab that controls the tab\'s visibility.\n\nIf the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use "on" as the value to show that the parent tab is active.\n';
          type: 'string';
        };
        conditionalParentValueMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        customTabId: {
          description: 'The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          type: 'string';
        };
        customTabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        declineReason: {
          description: 'The reason the recipient declined the document.';
          type: 'string';
        };
        declineReasonMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
        font: {
          description: 'The font to be used for the tab value. Supported fonts include:\n\n- Default\n- Arial\n- ArialNarrow\n- Calibri\n- CourierNew\n- Garamond\n- Georgia\n- Helvetica\n- LucidaConsole\n- MSGothic\n- MSMincho\n- OCR-A\n- Tahoma\n- TimesNewRoman\n- Trebuchet\n- Verdana\n';
          type: 'string';
        };
        fontColor: {
          description: 'The font color to use for the information in the tab. Possible values are: \n\n- Black\n- BrightBlue\n- BrightRed\n- DarkGreen\n- DarkRed\n- Gold\n- Green\n- NavyBlue\n- Purple\n- White\n';
          type: 'string';
        };
        fontColorMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        fontSize: {
          description: 'The font size used for the information in the tab. Possible values are:\n\n- Size7\n- Size8\n- Size9\n- Size10\n- Size11\n- Size12\n- Size14\n- Size16\n- Size18\n- Size20\n- Size22\n- Size24\n- Size26\n- Size28\n- Size36\n- Size48\n- Size72';
          type: 'string';
        };
        fontSizeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formOrder: {
          description: 'An integer specifying the order in which the guided form HTML should render. The order is relative to the `formPageLabel`, the group by which to place the guided form HTML block.';
          type: 'string';
        };
        formOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageLabel: {
          description: 'A string specifying the group in which to place the guided form HTML. Each group displays as a separate guided forms page in the signing experience.';
          type: 'string';
        };
        formPageLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        formPageNumber: {
          description: 'An integer specifying the order in which to present the guided form pages.';
          type: 'string';
        };
        formPageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        height: {
          description: 'The height of the tab in pixels.';
          type: 'string';
        };
        heightMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        italic: {
          description: 'When **true,** the information in the tab is italic.';
          type: 'string';
        };
        italicMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        localePolicy: {
          $ref: '#/components/schemas/localePolicyTab';
        };
        mergeField: {
          $ref: '#/components/schemas/mergeField';
        };
        mergeFieldXml: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        pageNumber: {
          description: 'The page number on which the tab is located.\nFor supplemental documents, this value must be `1`.';
          type: 'string';
        };
        pageNumberMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientId: {
          description: 'Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.';
          type: 'string';
        };
        recipientIdGuid: {
          description: 'The globally-unique identifier (GUID) for a specific recipient on a specific envelope. If the same recipient is associated with multiple envelopes, they will have a different GUID for each one. This property is read-only.';
          type: 'string';
        };
        recipientIdGuidMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        recipientIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        smartContractInformation: {
          $ref: '#/components/schemas/smartContractInformation';
        };
        source: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        status: {
          description: 'The status of the tab. Possible values are:\n\n- `active`: The tab is active, but the recipient has not yet interacted with it.\n- `signed`: The recipient signed the tab.\n- `declined`: The recipient declined the envelope.\n- `na`: Used when the `status` property is not applicable to the tab type. (For example, a tab that has the `tabType` `SignerAttachmentOptional`).';
          type: 'string';
        };
        statusMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabGroupLabels: {
          description: "An array of tab groups that this tab belongs to. Tab groups are identified by their `groupLabel` property.\n\nTo associate this tab with a tab group, add the tab group's `groupLabel` to this array.";
          items: {
            type: 'string';
          };
          type: 'array';
        };
        tabGroupLabelsMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabId: {
          description: 'The unique identifier for the tab.';
          type: 'string';
        };
        tabIdMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabLabel: {
          description: 'The label associated with the tab. This value may be an empty string.\nIf no value is provided, the tab type is used as the value.\n\nMaximum Length: 500 characters.\n';
          type: 'string';
        };
        tabLabelMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabOrder: {
          description: 'A positive integer that sets the order the tab is navigated to during signing.\n\nTabs on a page are navigated to in ascending order, starting with the lowest number and moving to the highest. If two or more tabs have the same `tabOrder` value, the normal auto-navigation setting behavior for the envelope is used.';
          type: 'string';
        };
        tabOrderMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tabType: {
          description: 'Indicates the type of tab (for example, `signHere` or `initialHere`).';
          type: 'string';
        };
        tabTypeMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateLockedMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        templateRequiredMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        toolTipMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        tooltip: {
          description: '**Note:** Decline tabs never display this tooltip in the signing interface.\n\nAlthough you can technically set a value via the API for this tab,\nit will not be displayed to the recipient.\n';
          type: 'string';
        };
        underline: {
          description: 'When **true,** the information in the tab is underlined.';
          type: 'string';
        };
        underlineMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        width: {
          description: 'The width of the tab in pixels.';
          type: 'string';
        };
        widthMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        xPosition: {
          description: "This property indicates the horizontal offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        xPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
        yPosition: {
          description: "This property indicates the vertical offset of the object on the page.\nDocuSign uses 72 DPI when determining position.\nRequired. May be zero.\n\nTo improve the tab's position on the document,\nDocuSign recommends\nadjusting `xPosition`\nand `yPosition`\ncoordinates\nby (-3, -2)\n";
          type: 'string';
        };
        yPositionMetadata: {
          $ref: '#/components/schemas/propertyMetadata';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'decline';
      'x-ms-summary': 'A tab that allows the recipient the option of declining an\nenvelope. If the recipient clicks the tab during the signing\nprocess, the envelope is voided.\n';
    };
    delayedRouting: {
      description: 'A complex element that specifies the delayed routing settings for the workflow step.';
      properties: {
        resumeDate: {
          description: 'The ISO 8601 timestamp of when the envelope is scheduled to be sent to the recipients associated with the workflow step. This property is `null` if the workflow step has not been initiated.\n\nThis property is read-only.\n';
          type: 'string';
        };
        rules: {
          description: 'User-specified rules indicating how and when the envelope should sent for the workflow step and its associated recipients. Only one rule may be specified.';
          items: {
            $ref: '#/components/schemas/envelopeDelayRule';
          };
          type: 'array';
        };
        status: {
          description: "Status of the delayed routing step. Valid values:\n\n* `pending`: The workflow step has not been reached and the delay has not been initiated.\n* `started`: The workflow step has begun and the delay is in progress. The envelope has not yet been sent to the workflow step's recipients.\n* `completed`: The delay has elapsed and the envelope has been sent to the workflow step's recipients.\n\nThis property is read-only.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'delayedRouting';
      'x-ms-summary': 'A complex element that specifies the delayed routing settings for the workflow step.';
    };
    delegationInfo: {
      description: '';
      properties: {
        Email: {
          description: '';
          type: 'string';
        };
        Name: {
          description: '';
          type: 'string';
        };
        UserAuthorizationId: {
          description: '';
          type: 'string';
        };
        UserId: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'delegationInfo';
      'x-ms-summary': '';
    };
    diagnosticsSettingsInformation: {
      description: '';
      properties: {
        apiRequestLogMaxEntries: {
          description: 'Specifies the maximum number of API requests to log.';
          type: 'string';
        };
        apiRequestLogRemainingEntries: {
          description: 'Indicates the remaining number of API requests that can be logged.';
          type: 'string';
        };
        apiRequestLogging: {
          description: ' When **true,** enables API request logging for the user. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'diagnosticsSettingsInformation';
      'x-ms-summary': '';
    };
    directDebitProcessorInformation: {
      description: "Contains information about a bank that processes a customer's direct debit payments.";
      properties: {
        bankBranchCode: {
          description: 'The branch code of the bank used for direct debit.\n\nMaximum Length: 10 characters.';
          type: 'string';
        };
        bankCheckDigit: {
          description: 'The check digit or digits in the international bank account number. These digits are used to confirm the validity of the account.\n\nMaximum Length: 4 characters.';
          type: 'string';
        };
        bankCode: {
          description: 'The code or number that identifies the bank. This is also known as the sort code.\n\nExample: `200000`\n\nMaximum Length: 18 characters.';
          type: 'string';
        };
        bankName: {
          description: 'The name of the direct debit bank.\n\nMaximum Length: 80 characters.';
          type: 'string';
        };
        bankTransferAccountName: {
          description: 'The name on the direct debit bank account. This field is required for POST and PUT requests.\n\nMaximum Length: 60 characters.';
          type: 'string';
        };
        bankTransferAccountNumber: {
          description: "The customer's bank account number. This value will be obfuscated. This field is required for POST and PUT requests.\n\nMaximum Length: 30 characters.";
          type: 'string';
        };
        bankTransferType: {
          description: "Specifies the type of direct debit transfer. The value of this field is dependent on the user's country. This field is required for POST and PUT requests. Possible values are:\n\n- `DirectDebitUK`\n- `DirectEntryAU`\n- `SEPA`";
          type: 'string';
        };
        country: {
          description: "The user's country. The system populates this value automatically.\n\n";
          type: 'string';
        };
        email: {
          description: 'The email address of the user who is associated with the payment method. This field is required for POST and PUT requests.\n\nMaximum Length: 80 characters.';
          type: 'string';
        };
        firstName: {
          description: "The user's first name. This field is required for POST and PUT requests.\n\nMaximum Length: 30 characters.";
          type: 'string';
        };
        iBAN: {
          description: "The International Bank Account Number (IBAN). \n\nExample: `DE89370400440532013000`\n\nFor more information, see [PeopleSoft's guide to Setting Up Banks](https://docs.oracle.com/cd/E16365_01/fscm91pbr0/eng/psbooks/fsbk/chapter.htm?File=fsbk/htm/fsbk03.htm).\n\n**Note:** This number will be obfuscated.";
          type: 'string';
        };
        lastName: {
          description: "The user's last name. This field is required for POST and PUT requests.\n\nMaximum Length: 70 characters.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'directDebitProcessorInformation';
      'x-ms-summary': "Contains information about a bank that processes a customer's direct debit payments.";
    };
    dobInformationInput: {
      description: 'Complex type containing:\n\n* dateOfBirth\n* displayLevelCode\n* receiveInResponse';
      properties: {
        dateOfBirth: {
          description: "Specifies the recipient's date, month, and year of birth.";
          type: 'string';
        };
        displayLevelCode: {
          description: 'Specifies the display level for the recipient. Valid values are:\n* `ReadOnly`\n* `Editable`\n* `DoNotDisplay`';
          type: 'string';
        };
        receiveInResponse: {
          description: 'A Boolean value that specifies whether the information must be returned in the response.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'dobInformationInput';
      'x-ms-summary': 'Complex type containing:\n\n* dateOfBirth\n* displayLevelCode\n* receiveInResponse';
    };
    docGenFormField: {
      description: '';
      properties: {
        label: {
          description: '';
          type: 'string';
        };
        name: {
          description: '';
          type: 'string';
        };
        required: {
          description: 'When **true,** the signer is required to fill out this tab.';
          type: 'string';
        };
        type: {
          description: 'The type of this tab. Values are:\n\n- Approve\n- CheckBox\n- Company\n- Date\n- DateSigned,\tDecline\n- Email,\tEmailAddress\n- EnvelopeId\n- FirstName\n- Formula\n- FullName,\tInitialHere\n- InitialHereOptional\n- LastName\n- List\n- Note\n- Number\n- Radio\n- SignerAttachment\n- SignHere\n- SignHereOptional\n- Ssn\n- Text\n- Title\n- Zip5\n- Zip5Dash4\n';
          type: 'string';
        };
        value: {
          description: 'Specifies the value of the tab. ';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'docGenFormField';
      'x-ms-summary': '';
    };
    docGenFormFieldRequest: {
      description: '';
      properties: {
        docGenFormFields: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenFormFields';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'docGenFormFieldRequest';
      'x-ms-summary': '';
    };
    docGenFormFieldResponse: {
      description: '';
      properties: {
        docGenFormFields: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenFormFields';
          };
          type: 'array';
        };
        errorDetails: {
          $ref: '#/components/schemas/errorDetails';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'docGenFormFieldResponse';
      'x-ms-summary': '';
    };
    docGenFormFields: {
      description: '';
      properties: {
        docGenDocumentStatus: {
          description: '';
          type: 'string';
        };
        docGenErrors: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenSyntaxError';
          };
          type: 'array';
        };
        docGenFormFieldList: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenFormField';
          };
          type: 'array';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'docGenFormFields';
      'x-ms-summary': '';
    };
    docGenSyntaxError: {
      description: '';
      properties: {
        errorCode: {
          description: 'A code associated with the error condition.';
          type: 'string';
        };
        message: {
          description: '';
          type: 'string';
        };
        tagIdentifier: {
          description: '';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'docGenSyntaxError';
      'x-ms-summary': '';
    };
    document: {
      description: 'A document object.';
      properties: {
        applyAnchorTabs: {
          description: 'Reserved for DocuSign.';
          type: 'string';
        };
        assignTabsToRecipientId: {
          description: '';
          type: 'string';
        };
        display: {
          description: 'This string sets the display and behavior properties of\nthe document during signing. Valid values:\n\n* `modal`<br>\n  The document is shown as a supplement action strip\n  and can be viewed, downloaded, or printed in a modal window.\n  This is the recommended value for supplemental documents. \n\n* `inline`<br>\n  The document is shown in the normal signing window.\n  This value is not used with supplemental documents,\n  but is the default value for all other documents.\n';
          type: 'string';
        };
        docGenFormFields: {
          description: '';
          items: {
            $ref: '#/components/schemas/docGenFormField';
          };
          type: 'array';
        };
        documentBase64: {
          description: "The document's bytes. This field can be used to include a base64 version of the document bytes within an envelope definition instead of sending the document using a multi-part HTTP request. The maximum document size is smaller if this field is used due to the overhead of the base64 encoding.";
          type: 'string';
        };
        documentFields: {
          description: 'The array of name/value custom data strings to be added to a document. Custom document field information is returned in the status, but otherwise is not used by DocuSign. The array contains the elements: \n\n* `name`: A string that can be a maximum of 50 characters. \n* `value`: A string that can be a maximum of 200 characters.\n\nIf you are using XML, the name/value pair is contained in a `nameValue` element. \n';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
        documentId: {
          description: 'Specifies the document ID of this document. This value is used by tabs to determine which document they appear in.';
          type: 'string';
        };
        encryptedWithKeyManager: {
          description: 'When **true,** the document has been encrypted by the sender for use with the DocuSign Key Manager Security Appliance.\n ';
          type: 'string';
        };
        fileExtension: {
          description: 'The file extension type of the document. Non-PDF documents are converted to PDF.\n\nIf the document is not a PDF, `fileExtension` is required.\n\nIf you try to upload a non-PDF document without a `fileExtension`, you will receive an "unable to load document" error message.  \n ';
          type: 'string';
        };
        fileFormatHint: {
          description: '';
          type: 'string';
        };
        htmlDefinition: {
          $ref: '#/components/schemas/documentHtmlDefinition';
        };
        includeInDownload: {
          description: 'When **true,**\nthe document is included in the combined document download (`documentsCombinedUri`). \nThe default value is **true.**\n';
          type: 'string';
        };
        isDocGenDocument: {
          description: '';
          type: 'string';
        };
        matchBoxes: {
          description: 'Matchboxes define areas in a document for document matching when you are creating envelopes.\nThey are only used when you upload and edit a template.\n\n';
          items: {
            $ref: '#/components/schemas/matchBox';
          };
          type: 'array';
        };
        name: {
          description: 'The name of the document.';
          type: 'string';
        };
        order: {
          description: 'The order in which to sort the results.\n\nValid values are: \n\n\n* `asc`: Ascending order.\n* `desc`: Descending order. ';
          type: 'string';
        };
        pages: {
          description: 'The number of pages in the document. This property is read-only.';
          type: 'string';
        };
        password: {
          description: "The user's encrypted password hash.";
          type: 'string';
        };
        pdfFormFieldOption: {
          description: '';
          type: 'string';
        };
        remoteUrl: {
          description: 'The file ID from the cloud storage service where\nthe document is located. This information is\nreturned using\n[CloudStorage: listFolders](/docs/esign-rest-api/reference/cloudstorage/cloudstorage/listfolders/) or\n[CloudStorage: list](/docs/esign-rest-api/reference/cloudstorage/cloudstorage/list/).\n';
          type: 'string';
        };
        signerMustAcknowledge: {
          description: 'Sets how the signer interacts with the supplemental document.\nValid values: \n\n*\t`no_interaction`<br>\n  No recipient action is required. \n\n*\t`view`<br>\n  The recipient is required to view the document. \n\n*\t`accept`<br>\n  The recipient is required to accept the document by selecting accept during signing, but is not required to view the document. \n\n*\t`view_accept`<br>\n  The recipient is required to view and accept the document.  \n\n';
          type: 'string';
        };
        signerMustAcknowledgeUseAccountDefault: {
          description: 'When **true,** the account default setting for the required recipient option is used. If this property is set, `signerMustAcknowledge` cannot be set (and vice versa).';
          type: 'boolean';
        };
        tabs: {
          $ref: '#/components/schemas/EnvelopeRecipientTabs';
        };
        templateLocked: {
          description: 'When **true,** the sender cannot change any attributes of the recipient. Used only when working with template recipients. ';
          type: 'string';
        };
        templateRequired: {
          description: 'When **true,** the sender may not remove the recipient. Used only when working with template recipients.';
          type: 'string';
        };
        transformPdfFields: {
          description: 'When **true,** PDF form field data is transformed into document tab values when the PDF form field name matches the DocuSign custom tab tabLabel. The resulting PDF form data is also returned in the PDF meta data when requesting the document PDF.\n';
          type: 'string';
        };
        uri: {
          description: 'A URI containing the user ID.';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'document';
      'x-ms-summary': 'A document object.';
    };
    documentFieldsInformation: {
      description: '';
      properties: {
        documentFields: {
          description: 'The array of name/value custom data strings to be added to a document. Custom document field information is returned in the status, but otherwise is not used by DocuSign. The array contains the elements: \n\n* `name`: A string that can be a maximum of 50 characters. \n* `value`: A string that can be a maximum of 200 characters.\n\nIf you are using XML, the name/value pair is contained in a `nameValue` element. \n';
          items: {
            $ref: '#/components/schemas/nameValue';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentFieldsInformation';
      'x-ms-summary': '';
    };
    documentHtmlCollapsibleDisplaySettings: {
      description: 'Display settings for collapsible section.';
      properties: {
        arrowClosed: {
          description: 'Indicates the direction of the disclosure arrow\nwhen the collapsible section is in the closed state.\n\nOne of the following:\n\n- `up`: In the closed state, the disclosure arrow points up.\n- `down`: In the closed state, the disclosure arrow points down.\n- `left`: In the closed state, the disclosure arrow points left.\n- `right`: In the closed state, the disclosure arrow points right.\n';
          type: 'string';
        };
        arrowColor: {
          description: 'A CSS color value (such as `#DCF851`) that indicates the color of the arrow.\n';
          type: 'string';
        };
        arrowLocation: {
          description: "The location of the arrow relative to the collapsible section's label. Possible values are:\n\n- `right` (default)\n- `left`\n";
          type: 'string';
        };
        arrowOpen: {
          description: 'Indicates the direction of the disclosure arrow\nwhen the collapsible section is in the open state.\n\nOne of the following:\n\n- `up`: In the open state, the disclosure arrow points up.\n- `down`: In the open state, the disclosure arrow points down.\n- `left`: In the open state, the disclosure arrow points left.\n- `right`: In the open state, the disclosure arrow points right.\n';
          type: 'string';
        };
        arrowSize: {
          description: 'Indicates the size of the collapsible arrows. Possible values are:\n\n- `small`\n- `large` (default)\n';
          type: 'string';
        };
        arrowStyle: {
          description: 'The name of the CSS style to be used on collapsible arrow section.\n';
          type: 'string';
        };
        containerStyle: {
          description: 'The name of the CSS style to be used for the collapsible container.\n';
          type: 'string';
        };
        labelStyle: {
          description: "The name of the CSS style to be used for the collapsible container's label.";
          type: 'string';
        };
        onlyArrowIsClickable: {
          description: 'When **true,** only the arrow is clickable to expand or collapse the section.\nWhen **false** (the default), both the label and the arrow are clickable.\n\nIf no arrow is used, this setting is ignored.\n';
          type: 'boolean';
        };
        outerLabelAndArrowStyle: {
          description: "The name of the CSS style to be used for the collapsible container's outer label and arrow style.";
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentHtmlCollapsibleDisplaySettings';
      'x-ms-summary': 'Display settings for collapsible section.';
    };
    documentHtmlDefinition: {
      description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.\nSee [Responsive signing](/docs/esign-rest-api/esign101/concepts/responsive/)\nin the [eSignature concepts guide](/docs/esign-rest-api/esign101/concepts/).';
      properties: {
        displayAnchorPrefix: {
          description: 'Contains text that all display anchors must start with. Using at least four characters will improve anchor processing performance.';
          type: 'string';
        };
        displayAnchors: {
          description: 'An object that defines how to handle a section of the HTML in signing. This property enables an incoming request to make a section of the HTML collapsible and expandable or hidden from view.\n\nA start anchor, end anchor, or both are required.\nIf the anchors are not found, the display anchor will be ignored.\n\nFor a list of the available types, see the\n[`display` property](/docs/esign-rest-api/reference/envelopes/envelopes/create/#schema__envelopedefinition_documents_htmldefinition_displayanchors_displaysettings_display)\nof the\n[`displaySettings` object.](/docs/esign-rest-api/reference/envelopes/envelopes/create/#schema__envelopedefinition_documents_htmldefinition_displayanchors_displaysettings)';
          items: {
            $ref: '#/components/schemas/documentHtmlDisplayAnchor';
          };
          type: 'array';
        };
        displayOrder: {
          description: 'The position on the page where the display section appears.';
          type: 'string';
        };
        displayPageNumber: {
          description: 'The number of the page on which the display section appears.';
          type: 'string';
        };
        documentGuid: {
          description: 'The GUID of the document.';
          type: 'string';
        };
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        headerLabel: {
          description: 'Header text or an HTML tag to place above the responsive HTML block.';
          type: 'string';
        };
        maxScreenWidth: {
          description: 'If set, the responsive HTML version of the signing document will only display on screens with the specified pixel width or less. If the screen is larger than the value that you specify, the default PDF version of the content displays instead.\n\nThis setting can also be configured at the account level.\n';
          type: 'string';
        };
        removeEmptyTags: {
          description: 'Holds a comma-separated list of HTML tags to remove if they have no text within their node (including child nodes).';
          type: 'string';
        };
        showMobileOptimizedToggle: {
          description: "When **true** (the default), the **Mobile-Friendly** toggle displays at the top of the screen on the user's mobile device. When **false,** the toggle will not be displayed.\n\nthe **Mobile-Friendly** toggle lets the user switch between the mobile-friendly and the PDF versions of a document. For example, the recipient can use this toggle to review the document using the PDF view before they finish signing.\n";
          type: 'string';
        };
        source: {
          description: 'Specifies the type of responsive signing that will be used with the document.\n\nIf the value of this property is valid HTML,\nand the [smart sections feature][] is enabled,\nthe HTML code is used to display the signing page:\n\n```\nsource: "<html> ... <body><p>hello world</p></body></html>"\n```\n\nIf the value of this property is the string `document`,\nthe HTML signing page is generated from the provided document.\n\n```\nsource: "document"\n```\n\n**Related topics**\n\n- [How to create a signable HTML document](/docs/esign-rest-api/how-to/creating-signable-html/)\n- [How to convert a PDF file into a signable HTML document](/docs/esign-rest-api/how-to/converting-pdf/)\n- [Responsive signing](/docs/esign-rest-api/esign101/concepts/responsive/)\n\n\n[smart sections feature]: https://support.docusign.com/s/document-item?language=en_US&bundleId=gbo1643332197980&topicId=qlx1578456478178.html&_LANG=enus';
          type: 'string';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentHtmlDefinition';
      'x-ms-summary': 'Holds the properties that define how to generate the responsive-formatted HTML for the document.\nSee [Responsive signing](/docs/esign-rest-api/esign101/concepts/responsive/)\nin the [eSignature concepts guide](/docs/esign-rest-api/esign101/concepts/).';
    };
    documentHtmlDefinitionOriginal: {
      description: '';
      properties: {
        documentId: {
          description: "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.";
          type: 'string';
        };
        documentIdGuid: {
          description: 'The GUID of the document.';
          type: 'string';
        };
        htmlDefinition: {
          $ref: '#/components/schemas/documentHtmlDefinition';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginal';
      'x-ms-summary': '';
    };
    documentHtmlDefinitionOriginals: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            $ref: '#/components/schemas/documentHtmlDefinitionOriginal';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentHtmlDefinitionOriginals';
      'x-ms-summary': '';
    };
    documentHtmlDefinitions: {
      description: '';
      properties: {
        htmlDefinitions: {
          description: 'Holds the properties that define how to generate the responsive-formatted HTML for the document.';
          items: {
            type: 'string';
          };
          type: 'array';
        };
      };
      type: 'object';
      'x-ds-definition-name': 'documentHtmlDefinitions';
      'x-ms-summary': '';
    };
    documentHtmlDisplayAnchor: {
      description: '';
      properties: {
      