// Generated by ts-to-zod
import { z } from 'zod';

import { type ErrorDetails } from './types.gen';

export const accountResponseSchema = z.object({
  id: z.string(),
  name: z.string().optional().nullable(),
});

export const mentionableSelectSchema = z.object({
  type: z.literal(7),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  default_values: z.array(z.unknown()).optional().nullable(),
});

export const typeSchema = z.literal(1);

export const afkTimeoutsSchema = z.union([
  z.literal(60),
  z.literal(300),
  z.literal(900),
  z.literal(1800),
  z.literal(3600),
]);

export const allowedMentionTypesSchema = z.union([z.literal('users'), z.literal('roles'), z.literal('everyone')]);

export const applicationCommandAttachmentOptionSchema = z.object({
  type: z.literal(11),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const type2Schema = z.literal(11);

export const applicationCommandAttachmentOptionResponseSchema = z.object({
  type: z.literal(11),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const type3Schema = z.literal(8);

export const applicationCommandBooleanOptionSchema = z.object({
  type: z.literal(5),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const type4Schema = z.literal(5);

export const applicationCommandBooleanOptionResponseSchema = z.object({
  type: z.literal(5),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const channelTypesSchema = z.union([
  z.literal(1),
  z.literal(3),
  z.literal(0),
  z.literal(2),
  z.literal(4),
  z.literal(5),
  z.literal(10),
  z.literal(11),
  z.literal(12),
  z.literal(13),
  z.literal(14),
  z.literal(15),
]);

export const type5Schema = z.literal(7);

export const applicationCommandChannelOptionResponseSchema = z.object({
  type: z.literal(7),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  channel_types: z.array(channelTypesSchema).optional().nullable(),
});

export const applicationCommandChannelOptionSchema = z.object({
  type: z.literal(7),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  channel_types: z.array(channelTypesSchema).optional().nullable(),
});

export const applicationCommandMentionableOptionSchema = z.object({
  type: z.literal(9),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const applicationCommandRoleOptionSchema = z.object({
  type: z.literal(8),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const applicationCommandUserOptionSchema = z.object({
  type: z.literal(6),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const applicationCommandTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const int53TypeSchema = z.number();

export const type6Schema = z.literal(4);

export const applicationCommandOptionIntegerChoiceResponseSchema = z.object({
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: int53TypeSchema,
});

export const type7Schema = z.literal(9);

export const applicationCommandMentionableOptionResponseSchema = z.object({
  type: z.literal(9),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const applicationCommandOptionNumberChoiceSchema = z.object({
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: z.number(),
});

export const type8Schema = z.literal(10);

export const applicationCommandOptionNumberChoiceResponseSchema = z.object({
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: z.number(),
});

export const applicationCommandOptionIntegerChoiceSchema = z.object({
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: int53TypeSchema,
});

export const applicationCommandOptionStringChoiceSchema = z.object({
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: z.string(),
});

export const applicationCommandOptionStringChoiceResponseSchema = z.object({
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  value: z.string(),
});

export const applicationCommandOptionTypeSchema = z.union([
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
  z.literal(9),
  z.literal(10),
  z.literal(11),
]);

export const applicationCommandIntegerOptionSchema = z.object({
  type: z.literal(4),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  choices: z.array(applicationCommandOptionIntegerChoiceSchema).optional().nullable(),
  min_value: int53TypeSchema.optional().nullable(),
  max_value: int53TypeSchema.optional().nullable(),
});

export const applicationCommandNumberOptionSchema = z.object({
  type: z.literal(10),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  choices: z.array(applicationCommandOptionNumberChoiceSchema).optional().nullable(),
  min_value: z.number().optional().nullable(),
  max_value: z.number().optional().nullable(),
});

export const applicationCommandStringOptionSchema = z.object({
  type: z.literal(3),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  min_length: z.number().optional().nullable(),
  max_length: z.number().optional().nullable(),
  choices: z.array(applicationCommandOptionStringChoiceSchema).optional().nullable(),
});

export const applicationCommandSubcommandOptionSchema = z.object({
  type: z.literal(1),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionSchema,
        applicationCommandBooleanOptionSchema,
        applicationCommandChannelOptionSchema,
        applicationCommandIntegerOptionSchema,
        applicationCommandMentionableOptionSchema,
        applicationCommandNumberOptionSchema,
        applicationCommandRoleOptionSchema,
        applicationCommandStringOptionSchema,
        applicationCommandUserOptionSchema,
      ]),
    )
    .optional()
    .nullable(),
});

export const snowflakeTypeSchema = z.string();

export const applicationCommandPermissionTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const applicationCommandIntegerOptionResponseSchema = z.object({
  type: z.literal(4),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  choices: z.array(applicationCommandOptionIntegerChoiceResponseSchema).optional().nullable(),
  min_value: int53TypeSchema.optional().nullable(),
  max_value: int53TypeSchema.optional().nullable(),
});

export const applicationCommandNumberOptionResponseSchema = z.object({
  type: z.literal(10),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  choices: z.array(applicationCommandOptionNumberChoiceResponseSchema).optional().nullable(),
  min_value: z.number().optional().nullable(),
  max_value: z.number().optional().nullable(),
});

export const applicationCommandRoleOptionResponseSchema = z.object({
  type: z.literal(8),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const applicationCommandStringOptionResponseSchema = z.object({
  type: z.literal(3),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  autocomplete: z.boolean().optional().nullable(),
  choices: z.array(applicationCommandOptionStringChoiceResponseSchema).optional().nullable(),
  min_length: z.number().optional().nullable(),
  max_length: z.number().optional().nullable(),
});

export const applicationCommandUserOptionResponseSchema = z.object({
  type: z.literal(6),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
});

export const type9Schema = z.literal(3);

export const applicationCommandSubcommandGroupOptionSchema = z.object({
  type: z.literal(2),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  options: z.array(applicationCommandSubcommandOptionSchema).optional().nullable(),
});

export const type10Schema = z.literal(2);

export const applicationCommandSubcommandOptionResponseSchema = z.object({
  type: z.literal(1),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionResponseSchema,
        applicationCommandBooleanOptionResponseSchema,
        applicationCommandChannelOptionResponseSchema,
        applicationCommandIntegerOptionResponseSchema,
        applicationCommandMentionableOptionResponseSchema,
        applicationCommandNumberOptionResponseSchema,
        applicationCommandRoleOptionResponseSchema,
        applicationCommandStringOptionResponseSchema,
        applicationCommandUserOptionResponseSchema,
      ]),
    )
    .optional()
    .nullable(),
});

export const applicationCommandUpdateRequestSchema = z.object({
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionSchema,
        applicationCommandBooleanOptionSchema,
        applicationCommandChannelOptionSchema,
        applicationCommandIntegerOptionSchema,
        applicationCommandMentionableOptionSchema,
        applicationCommandNumberOptionSchema,
        applicationCommandRoleOptionSchema,
        applicationCommandStringOptionSchema,
        applicationCommandSubcommandGroupOptionSchema,
        applicationCommandSubcommandOptionSchema,
        applicationCommandUserOptionSchema,
      ]),
    )
    .optional()
    .nullable(),
  default_member_permissions: z.number().optional().nullable(),
  dm_permission: z.boolean().optional().nullable(),
  type: applicationCommandTypeSchema.optional().nullable(),
  id: snowflakeTypeSchema.optional().nullable(),
});

export const type11Schema = z.literal(6);

export const applicationTypesSchema = z.literal(4);

export const applicationOAuth2ParamsSchema = z.object({
  scopes: z
    .array(z.union([z.literal('applications.commands'), z.literal('bot')]))
    .optional()
    .nullable(),
  permissions: z.number().optional().nullable(),
});

export const applicationOAuth2ParamsResponseSchema = z.object({
  scopes: z.array(z.union([z.literal('applications.commands'), z.literal('bot')])),
  permissions: z.string(),
});

export const metadataItemTypesSchema = z.union([
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
]);

export const applicationRoleConnectionsMetadataItemResponseSchema = z.object({
  type: metadataItemTypesSchema,
  key: z.string(),
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string()).optional().nullable(),
});

export const applicationUserRoleConnectionResponseSchema = z.object({
  platform_name: z.string().optional().nullable(),
  platform_username: z.string().optional().nullable(),
  metadata: z.record(z.string()).optional().nullable(),
});

export const auditLogActionTypesSchema = z.union([
  z.literal(1),
  z.literal(10),
  z.literal(11),
  z.literal(12),
  z.literal(13),
  z.literal(14),
  z.literal(15),
  z.literal(20),
  z.literal(21),
  z.literal(22),
  z.literal(23),
  z.literal(24),
  z.literal(25),
  z.literal(26),
  z.literal(27),
  z.literal(28),
  z.literal(30),
  z.literal(31),
  z.literal(32),
  z.literal(40),
  z.literal(41),
  z.literal(42),
  z.literal(50),
  z.literal(51),
  z.literal(52),
  z.literal(60),
  z.literal(61),
  z.literal(62),
  z.literal(72),
  z.literal(73),
  z.literal(74),
  z.literal(75),
  z.literal(80),
  z.literal(81),
  z.literal(82),
  z.literal(83),
  z.literal(84),
  z.literal(85),
  z.literal(90),
  z.literal(91),
  z.literal(92),
  z.literal(100),
  z.literal(101),
  z.literal(102),
  z.literal(110),
  z.literal(111),
  z.literal(112),
  z.literal(121),
  z.literal(130),
  z.literal(131),
  z.literal(132),
  z.literal(140),
  z.literal(141),
  z.literal(142),
  z.literal(143),
  z.literal(144),
  z.literal(145),
  z.literal(146),
  z.literal(150),
  z.literal(151),
  z.literal(163),
  z.literal(164),
  z.literal(165),
  z.literal(166),
  z.literal(167),
  z.literal(171),
  z.literal(172),
  z.literal(180),
  z.literal(190),
  z.literal(191),
  z.literal(192),
  z.literal(193),
]);

export const auditLogObjectChangeResponseSchema = z.object({
  key: z.string().optional().nullable(),
  new_value: z.unknown().optional(),
  old_value: z.unknown().optional(),
});

export const automodActionTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4)]);

export const automodEventTypeSchema = z.union([z.literal(1), z.literal(2)]);

export const automodKeywordPresetTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const automodTriggerTypeSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5)]);

export const availableLocalesEnumSchema = z.union([
  z.literal('ar'),
  z.literal('bg'),
  z.literal('cs'),
  z.literal('da'),
  z.literal('de'),
  z.literal('el'),
  z.literal('en-GB'),
  z.literal('en-US'),
  z.literal('es-419'),
  z.literal('es-ES'),
  z.literal('fi'),
  z.literal('fr'),
  z.literal('he'),
  z.literal('hi'),
  z.literal('hr'),
  z.literal('hu'),
  z.literal('id'),
  z.literal('it'),
  z.literal('ja'),
  z.literal('ko'),
  z.literal('lt'),
  z.literal('nl'),
  z.literal('no'),
  z.literal('pl'),
  z.literal('pt-BR'),
  z.literal('ro'),
  z.literal('ru'),
  z.literal('sv-SE'),
  z.literal('th'),
  z.literal('tr'),
  z.literal('uk'),
  z.literal('vi'),
  z.literal('zh-CN'),
  z.literal('zh-TW'),
]);

export const messageAllowedMentionsRequestSchema = z.object({
  parse: z.array(allowedMentionTypesSchema.nullable()).optional().nullable(),
  users: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
  roles: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
  replied_user: z.boolean().optional().nullable(),
});

export const messageAttachmentRequestSchema = z.object({
  id: snowflakeTypeSchema,
  filename: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  is_remix: z.boolean().optional().nullable(),
});

export const messageTypeSchema = z.union([
  z.literal(0),
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
  z.literal(9),
  z.literal(10),
  z.literal(11),
  z.literal(12),
  z.literal(14),
  z.literal(15),
  z.literal(16),
  z.literal(17),
  z.literal(18),
  z.literal(19),
  z.literal(20),
  z.literal(21),
  z.literal(22),
  z.literal(23),
  z.literal(24),
  z.literal(25),
  z.literal(26),
  z.literal(27),
  z.literal(28),
  z.literal(29),
  z.literal(31),
  z.literal(32),
]);

export const messageComponentChannelSelectResponseSchema = z.object({
  type: z.literal(8),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  channel_types: z.array(channelTypesSchema).optional().nullable(),
});

export const messageComponentMentionableSelectResponseSchema = z.object({
  type: z.literal(7),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
});

export const messageComponentRoleSelectResponseSchema = z.object({
  type: z.literal(6),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
});

export const messageComponentUserSelectResponseSchema = z.object({
  type: z.literal(5),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
});

export const messageActivityResponseSchema = z.record(z.unknown());

export const messageReferenceResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
  message_id: snowflakeTypeSchema.optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
});

export const messageMentionChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  type: channelTypesSchema,
  guild_id: snowflakeTypeSchema,
});

export const messageRoleSubscriptionDataResponseSchema = z.object({
  role_subscription_listing_id: snowflakeTypeSchema,
  tier_name: z.string(),
  total_months_subscribed: z.number(),
  is_renewal: z.boolean(),
});

export const blockMessageActionMetadataSchema = z.object({
  custom_message: z.string().optional().nullable(),
});

export const blockMessageActionMetadataResponseSchema = z.object({
  custom_message: z.string().optional().nullable(),
});

export const blockMessageActionResponseSchema = z.object({
  type: z.literal(1),
  metadata: blockMessageActionMetadataResponseSchema,
});

export const botAccountPatchRequestSchema = z.object({
  username: z.string(),
  avatar: z.string().optional().nullable(),
});

export const buttonStyleTypesSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5)]);

export const emojiSchema = z.object({
  id: snowflakeTypeSchema.optional().nullable(),
  name: z.string(),
  animated: z.boolean().optional().nullable(),
});

export const channelFollowerResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
  webhook_id: snowflakeTypeSchema,
});

export const webhookSourceGuildResponseSchema = z.object({
  id: snowflakeTypeSchema,
  icon: z.string().optional().nullable(),
  name: z.string(),
});

export const webhookSourceChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
});

export const channelPermissionOverwritesSchema = z.union([z.literal(0), z.literal(1)]);

export const channelPermissionOverwriteResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: channelPermissionOverwritesSchema,
  allow: z.string(),
  deny: z.string(),
});

export const snowflakeSelectDefaultValueTypesSchema = z.string();

export const commandPermissionResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: applicationCommandPermissionTypeSchema,
  permission: z.boolean(),
});

export const commandPermissionsResponseSchema = z.object({
  id: snowflakeTypeSchema,
  application_id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  permissions: z.array(commandPermissionResponseSchema),
});

export const connectedAccountGuildResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
});

export const integrationTypesSchema = z.union([
  z.literal('discord'),
  z.literal('twitch'),
  z.literal('youtube'),
  z.literal('guild_subscription'),
]);

export const connectedAccountProvidersSchema = z.union([
  z.literal('battlenet'),
  z.literal('ebay'),
  z.literal('epicgames'),
  z.literal('facebook'),
  z.literal('github'),
  z.literal('instagram'),
  z.literal('leagueoflegends'),
  z.literal('paypal'),
  z.literal('playstation'),
  z.literal('reddit'),
  z.literal('riotgames'),
  z.literal('skype'),
  z.literal('spotify'),
  z.literal('steam'),
  z.literal('tiktok'),
  z.literal('twitch'),
  z.literal('twitter'),
  z.literal('xbox'),
  z.literal('youtube'),
]);

export const connectedAccountIntegrationResponseSchema = z.object({
  id: z.string(),
  type: integrationTypesSchema,
  account: accountResponseSchema,
  guild: connectedAccountGuildResponseSchema,
});

export const connectedAccountVisibilitySchema = z.union([z.literal(0), z.literal(1)]);

export const threadAutoArchiveDurationSchema = z.union([
  z.literal(60),
  z.literal(1440),
  z.literal(4320),
  z.literal(10080),
]);

export const createGroupDMInviteRequestSchema = z.object({
  max_age: z.number().optional().nullable(),
});

export const channelPermissionOverwriteRequestSchema = z.object({
  id: snowflakeTypeSchema,
  type: channelPermissionOverwritesSchema.optional().nullable(),
  allow: z.number().optional().nullable(),
  deny: z.number().optional().nullable(),
});

export const videoQualityModesSchema = z.union([z.literal(1), z.literal(2)]);

export const updateDefaultReactionEmojiRequestSchema = z.object({
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
});

export const threadSortOrderSchema = z.union([z.literal(0), z.literal(1)]);

export const forumLayoutSchema = z.union([z.literal(0), z.literal(1), z.literal(2)]);

export const createOrUpdateThreadTagRequestSchema = z.object({
  name: z.string(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
  moderated: z.boolean().optional().nullable(),
});

export const createGuildInviteRequestSchema = z.object({
  max_age: z.number().optional().nullable(),
  temporary: z.boolean().optional().nullable(),
  max_uses: z.number().optional().nullable(),
  unique: z.boolean().optional().nullable(),
  target_user_id: snowflakeTypeSchema.optional().nullable(),
  target_application_id: snowflakeTypeSchema.optional().nullable(),
  target_type: z
    .union([z.literal(1), z.literal(2)])
    .optional()
    .nullable(),
});

export const createGuildRequestChannelItemSchema = z.object({
  type: z
    .union([z.literal(0), z.literal(2), z.literal(4)])
    .optional()
    .nullable(),
  name: z.string(),
  position: z.number().optional().nullable(),
  topic: z.string().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  nsfw: z.boolean().optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  permission_overwrites: z.array(channelPermissionOverwriteRequestSchema).optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  default_auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  default_reaction_emoji: updateDefaultReactionEmojiRequestSchema.optional().nullable(),
  default_thread_rate_limit_per_user: z.number().optional().nullable(),
  default_sort_order: threadSortOrderSchema.optional().nullable(),
  default_forum_layout: forumLayoutSchema.optional().nullable(),
  id: snowflakeTypeSchema.optional().nullable(),
  available_tags: z.array(createOrUpdateThreadTagRequestSchema).optional().nullable(),
});

export const createGuildRequestRoleItemSchema = z.object({
  id: z.number(),
  name: z.string().optional().nullable(),
  permissions: z.number().optional().nullable(),
  color: z.number().optional().nullable(),
  hoist: z.boolean().optional().nullable(),
  mentionable: z.boolean().optional().nullable(),
  unicode_emoji: z.string().optional().nullable(),
});

export const type12Schema = z.union([z.literal(4), z.literal(5)]);

export const createPrivateChannelRequestSchema = z.object({
  recipient_id: snowflakeTypeSchema.optional().nullable(),
  access_tokens: z.array(z.string()).optional().nullable(),
  nicks: z.record(z.string().nullable()).optional().nullable(),
});

export const createTextThreadWithMessageRequestSchema = z.object({
  name: z.string(),
  auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
});

export const createTextThreadWithoutMessageRequestSchema = z.object({
  name: z.string(),
  auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  type: z
    .union([z.literal(10), z.literal(11), z.literal(12)])
    .optional()
    .nullable(),
  invitable: z.boolean().optional().nullable(),
});

export const threadMetadataResponseSchema = z.object({
  archived: z.boolean(),
  archive_timestamp: z.string().optional().nullable(),
  auto_archive_duration: threadAutoArchiveDurationSchema,
  locked: z.boolean(),
  create_timestamp: z.string().optional().nullable(),
  invitable: z.boolean().optional().nullable(),
});

export const type13Schema = z.union([z.literal(10), z.literal(11), z.literal(12)]);

export const defaultKeywordListTriggerMetadataSchema = z.object({
  allow_list: z.array(z.string()).optional().nullable(),
  presets: z.array(automodKeywordPresetTypeSchema).optional().nullable(),
});

export const defaultKeywordListTriggerMetadataResponseSchema = z.object({
  allow_list: z.array(z.string()),
  presets: z.array(automodKeywordPresetTypeSchema),
});

export const blockMessageActionSchema = z.object({
  type: z.literal(1),
  metadata: blockMessageActionMetadataSchema.optional().nullable(),
});

export const triggerTypeSchema = z.literal(4);

export const defaultReactionEmojiResponseSchema = z.object({
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
});

export const type14Schema = z.literal('discord');

export const entityMetadataExternalSchema = z.object({
  location: z.string(),
});

export const entityMetadataExternalResponseSchema = z.object({
  location: z.string(),
});

export const entityMetadataStageInstanceSchema = z.record(z.unknown());

export const entityMetadataStageInstanceResponseSchema = z.record(z.unknown());

export const entityMetadataVoiceSchema = z.record(z.unknown());

export const entityMetadataVoiceResponseSchema = z.record(z.unknown());

export const integrationExpireBehaviorTypesSchema = z.union([z.literal(0), z.literal(1)]);

export const integrationExpireGracePeriodTypesSchema = z.union([
  z.literal(1),
  z.literal(3),
  z.literal(7),
  z.literal(14),
  z.literal(30),
]);

export const type15Schema = z.union([z.literal('twitch'), z.literal('youtube')]);

export const guildScheduledEventPrivacyLevelsSchema = z.literal(2);

export const entityTypeSchema = z.literal(3);

export const guildScheduledEventStatusesSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4)]);

export const flagToChannelActionMetadataSchema = z.object({
  channel_id: snowflakeTypeSchema,
});

export const flagToChannelActionMetadataResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
});

export const flagToChannelActionResponseSchema = z.object({
  type: z.literal(2),
  metadata: flagToChannelActionMetadataResponseSchema,
});

export const forumTagResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  moderated: z.boolean(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
});

export const gatewayBotSessionStartLimitResponseSchema = z.object({
  max_concurrency: z.number(),
  remaining: z.number(),
  reset_after: z.number(),
  total: z.number(),
});

export const gatewayResponseSchema = z.object({
  url: z.string(),
});

export const githubAuthorSchema = z.object({
  username: z.string().optional().nullable(),
  name: z.string(),
});

export const githubCheckAppSchema = z.object({
  name: z.string(),
});

export const githubCheckPullRequestSchema = z.object({
  number: z.number(),
});

export const githubCheckSuiteSchema = z.object({
  conclusion: z.string().optional().nullable(),
  head_branch: z.string().optional().nullable(),
  head_sha: z.string(),
  pull_requests: z.array(githubCheckPullRequestSchema).optional().nullable(),
  app: githubCheckAppSchema,
});

export const githubCheckRunOutputSchema = z.object({
  title: z.string().optional().nullable(),
  summary: z.string().optional().nullable(),
});

export const githubUserSchema = z.object({
  id: z.number(),
  login: z.string(),
  html_url: z.string(),
  avatar_url: z.string(),
});

export const githubCommitSchema = z.object({
  id: z.string(),
  url: z.string(),
  message: z.string(),
  author: githubAuthorSchema,
});

export const githubDiscussionSchema = z.object({
  title: z.string(),
  number: z.number(),
  html_url: z.string(),
  answer_html_url: z.string().optional().nullable(),
  body: z.string().optional().nullable(),
  user: githubUserSchema,
});

export const githubIssueSchema = z.object({
  id: z.number(),
  number: z.number(),
  html_url: z.string(),
  user: githubUserSchema,
  title: z.string(),
  body: z.string().optional().nullable(),
  pull_request: z.unknown().optional(),
});

export const githubReleaseSchema = z.object({
  id: z.number(),
  tag_name: z.string(),
  html_url: z.string(),
  author: githubUserSchema,
});

export const githubRepositorySchema = z.object({
  id: z.number(),
  html_url: z.string(),
  name: z.string(),
  full_name: z.string(),
});

export const githubReviewSchema = z.object({
  user: githubUserSchema,
  body: z.string().optional().nullable(),
  html_url: z.string(),
  state: z.string(),
});

export const githubCommentSchema = z.object({
  id: z.number(),
  html_url: z.string(),
  user: githubUserSchema,
  commit_id: z.string().optional().nullable(),
  body: z.string(),
});

export const githubCheckRunSchema = z.object({
  conclusion: z.string().optional().nullable(),
  name: z.string(),
  html_url: z.string(),
  check_suite: githubCheckSuiteSchema,
  details_url: z.string().optional().nullable(),
  output: githubCheckRunOutputSchema.optional().nullable(),
  pull_requests: z.array(githubCheckPullRequestSchema).optional().nullable(),
});

export const auditLogEntryResponseSchema = z.object({
  id: snowflakeTypeSchema,
  action_type: auditLogActionTypesSchema,
  user_id: snowflakeTypeSchema.optional().nullable(),
  target_id: snowflakeTypeSchema.optional().nullable(),
  changes: z.array(auditLogObjectChangeResponseSchema).optional().nullable(),
  options: z.record(z.string()).optional().nullable(),
  reason: z.string().optional().nullable(),
});

export const partialDiscordIntegrationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.literal('discord'),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
  application_id: snowflakeTypeSchema,
});

export const partialExternalConnectionIntegrationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.union([z.literal('twitch'), z.literal('youtube')]),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
});

export const partialGuildSubscriptionIntegrationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.literal('guild_subscription'),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
});

export const guildChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.union([z.literal(0), z.literal(2), z.literal(4), z.literal(5), z.literal(13), z.literal(14), z.literal(15)]),
  last_message_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number(),
  last_pin_timestamp: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  permissions: z.string().optional().nullable(),
  topic: z.string().optional().nullable(),
  default_auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  default_thread_rate_limit_per_user: z.number().optional().nullable(),
  position: z.number(),
  permission_overwrites: z.array(channelPermissionOverwriteResponseSchema).optional().nullable(),
  nsfw: z.boolean().optional().nullable(),
  available_tags: z.array(forumTagResponseSchema).optional().nullable(),
  default_reaction_emoji: defaultReactionEmojiResponseSchema.optional().nullable(),
  default_sort_order: threadSortOrderSchema.optional().nullable(),
  default_forum_layout: forumLayoutSchema.optional().nullable(),
});

export const type16Schema = z.union([
  z.literal(0),
  z.literal(2),
  z.literal(4),
  z.literal(5),
  z.literal(13),
  z.literal(14),
  z.literal(15),
]);

export const verificationLevelsSchema = z.union([z.literal(0), z.literal(1), z.literal(2), z.literal(3), z.literal(4)]);

export const userNotificationSettingsSchema = z.union([z.literal(0), z.literal(1)]);

export const guildExplicitContentFilterTypesSchema = z.union([z.literal(0), z.literal(1), z.literal(2)]);

export const guildFeaturesSchema = z.union([
  z.literal('ANIMATED_BANNER'),
  z.literal('ANIMATED_ICON'),
  z.literal('APPLICATION_COMMAND_PERMISSIONS_V2'),
  z.literal('AUTO_MODERATION'),
  z.literal('BANNER'),
  z.literal('COMMUNITY'),
  z.literal('CREATOR_MONETIZABLE_PROVISIONAL'),
  z.literal('CREATOR_STORE_PAGE'),
  z.literal('DEVELOPER_SUPPORT_SERVER'),
  z.literal('DISCOVERABLE'),
  z.literal('FEATURABLE'),
  z.literal('INVITES_DISABLED'),
  z.literal('INVITE_SPLASH'),
  z.literal('MEMBER_VERIFICATION_GATE_ENABLED'),
  z.literal('MORE_STICKERS'),
  z.literal('NEWS'),
  z.literal('PARTNERED'),
  z.literal('PREVIEW_ENABLED'),
  z.literal('RAID_ALERTS_DISABLED'),
  z.literal('ROLE_ICONS'),
  z.literal('ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE'),
  z.literal('ROLE_SUBSCRIPTIONS_ENABLED'),
  z.literal('TICKETED_EVENTS_ENABLED'),
  z.literal('VANITY_URL'),
  z.literal('VERIFIED'),
  z.literal('VIP_REGIONS'),
  z.literal('WELCOME_SCREEN_ENABLED'),
]);

export const welcomeMessageResponseSchema = z.object({
  author_ids: z.array(snowflakeTypeSchema),
  message: z.string(),
});

export const inviteTargetTypesSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const guildMFALevelSchema = z.union([z.literal(0), z.literal(1)]);

export const guildMFALevelResponseSchema = z.object({
  level: guildMFALevelSchema,
});

export const guildNSFWContentLevelSchema = z.union([z.literal(0), z.literal(1), z.literal(2), z.literal(3)]);

export const guildOnboardingModeSchema = z.union([z.literal(0), z.literal(1)]);

export const guildPatchRequestPartialSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  verification_level: verificationLevelsSchema.optional().nullable(),
  default_message_notifications: userNotificationSettingsSchema.optional().nullable(),
  explicit_content_filter: guildExplicitContentFilterTypesSchema.optional().nullable(),
  preferred_locale: availableLocalesEnumSchema.optional().nullable(),
  afk_timeout: afkTimeoutsSchema.optional().nullable(),
  afk_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_id: snowflakeTypeSchema.optional().nullable(),
  owner_id: snowflakeTypeSchema.optional(),
  splash: z.string().optional().nullable(),
  banner: z.string().optional().nullable(),
  system_channel_flags: z.number().optional().nullable(),
  features: z.array(z.string().nullable()).optional().nullable(),
  discovery_splash: z.string().optional().nullable(),
  home_header: z.string().optional().nullable(),
  rules_channel_id: snowflakeTypeSchema.optional().nullable(),
  safety_alerts_channel_id: snowflakeTypeSchema.optional().nullable(),
  public_updates_channel_id: snowflakeTypeSchema.optional().nullable(),
  premium_progress_bar_enabled: z.boolean().optional().nullable(),
});

export const guildProductPurchaseResponseSchema = z.object({
  listing_id: snowflakeTypeSchema,
  product_name: z.string(),
});

export const guildPruneResponseSchema = z.object({
  pruned: z.number().optional().nullable(),
});

export const premiumGuildTiersSchema = z.union([z.literal(0), z.literal(1), z.literal(2), z.literal(3)]);

export const guildRoleTagsResponseSchema = z.object({
  premium_subscriber: z.null().optional(),
  bot_id: snowflakeTypeSchema.optional().nullable(),
  integration_id: snowflakeTypeSchema.optional().nullable(),
  subscription_listing_id: snowflakeTypeSchema.optional().nullable(),
  available_for_purchase: z.null().optional(),
  guild_connections: z.null().optional(),
});

export const guildScheduledEventEntityTypesSchema = z.union([z.literal(0), z.literal(1), z.literal(2), z.literal(3)]);

export const stickerFormatTypesSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4)]);

export const guildSubscriptionIntegrationResponseSchema = z.object({
  type: z.literal('guild_subscription'),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
  enabled: z.boolean().optional().nullable(),
  id: snowflakeTypeSchema,
});

export const type17Schema = z.literal('guild_subscription');

export const guildTemplateChannelTagsSchema = z.object({
  name: z.string(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
  moderated: z.boolean().optional().nullable(),
});

export const iconEmojiResponseSchema = z.record(z.unknown());

export const type18Schema = z.union([z.literal(0), z.literal(2), z.literal(4)]);

export const guildTemplateRoleResponseSchema = z.object({
  id: z.number(),
  name: z.string(),
  permissions: z.string(),
  color: z.number(),
  hoist: z.boolean(),
  mentionable: z.boolean(),
  icon: z.string().optional().nullable(),
  unicode_emoji: z.string().optional().nullable(),
});

export const guildTemplateChannelResponseSchema = z.object({
  id: z.number().optional().nullable(),
  type: z.union([z.literal(0), z.literal(2), z.literal(4)]),
  name: z.string().optional().nullable(),
  position: z.number().optional().nullable(),
  topic: z.string().optional().nullable(),
  bitrate: z.number(),
  user_limit: z.number(),
  nsfw: z.boolean(),
  rate_limit_per_user: z.number(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  default_auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  permission_overwrites: z.array(channelPermissionOverwriteResponseSchema.nullable()),
  available_tags: z.array(guildTemplateChannelTagsSchema).optional().nullable(),
  template: z.string(),
  default_reaction_emoji: defaultReactionEmojiResponseSchema.optional().nullable(),
  default_thread_rate_limit_per_user: z.number().optional().nullable(),
  default_sort_order: threadSortOrderSchema.optional().nullable(),
  default_forum_layout: forumLayoutSchema.optional().nullable(),
  icon_emoji: iconEmojiResponseSchema.optional().nullable(),
  theme_color: z.number().optional().nullable(),
});

export const guildWelcomeChannelSchema = z.object({
  channel_id: snowflakeTypeSchema,
  description: z.string(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
});

export const guildWelcomeScreenChannelResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
  description: z.string(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
});

export const guildWelcomeScreenResponseSchema = z.object({
  description: z.string().optional().nullable(),
  welcome_channels: z.array(guildWelcomeScreenChannelResponseSchema),
});

export const guildRoleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  permissions: z.string(),
  position: z.number(),
  color: z.number(),
  hoist: z.boolean(),
  managed: z.boolean(),
  mentionable: z.boolean(),
  icon: z.string().optional().nullable(),
  unicode_emoji: z.string().optional().nullable(),
  tags: guildRoleTagsResponseSchema.optional().nullable(),
});

export const buttonSchema = z.object({
  type: z.literal(2),
  custom_id: z.string().optional().nullable(),
  style: buttonStyleTypesSchema,
  label: z.string().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  emoji: emojiSchema.optional().nullable(),
  url: z.string().optional().nullable(),
});

export const textStyleTypesSchema = z.union([z.literal(1), z.literal(2)]);

export const interactionApplicationCommandAutocompleteCallbackIntegerDataSchema = z.object({
  choices: z.array(applicationCommandOptionIntegerChoiceSchema.nullable()).optional().nullable(),
});

export const interactionApplicationCommandAutocompleteCallbackNumberDataSchema = z.object({
  choices: z.array(applicationCommandOptionNumberChoiceSchema.nullable()).optional().nullable(),
});

export const interactionApplicationCommandAutocompleteCallbackStringDataSchema = z.object({
  choices: z.array(applicationCommandOptionStringChoiceSchema.nullable()).optional().nullable(),
});

export const interactionCallbackTypesSchema = z.union([
  z.literal(1),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
  z.literal(9),
]);

export const interactionTypesSchema = z.union([z.literal(1), z.literal(2), z.literal(3), z.literal(4), z.literal(5)]);

export const inviteChannelRecipientResponseSchema = z.object({
  username: z.string(),
});

export const inviteChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: channelTypesSchema,
  name: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  recipients: z.array(inviteChannelRecipientResponseSchema).optional().nullable(),
});

export const inviteGuildResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  splash: z.string().optional().nullable(),
  banner: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  features: z.array(guildFeaturesSchema),
  verification_level: verificationLevelsSchema.optional().nullable(),
  vanity_url_code: z.string().optional().nullable(),
  nsfw_level: guildNSFWContentLevelSchema.optional().nullable(),
  nsfw: z.boolean().optional().nullable(),
  premium_subscription_count: z.number().optional().nullable(),
});

export const inviteTypesSchema = z.union([z.literal(0), z.literal(1), z.literal(2)]);

export const keywordTriggerMetadataResponseSchema = z.object({
  keyword_filter: z.array(z.string()),
  regex_patterns: z.array(z.string()),
  allow_list: z.array(z.string()),
});

export const triggerType2Schema = z.literal(1);

export const keywordTriggerMetadataSchema = z.object({
  keyword_filter: z.array(z.string()).optional().nullable(),
  regex_patterns: z.array(z.string()).optional().nullable(),
  allow_list: z.array(z.string()).optional().nullable(),
});

export const flagToChannelActionSchema = z.object({
  type: z.literal(2),
  metadata: flagToChannelActionMetadataSchema,
});

export const mLSpamTriggerMetadataResponseSchema = z.record(z.unknown());

export const triggerType3Schema = z.literal(3);

export const mLSpamTriggerMetadataSchema = z.record(z.unknown());

export const mentionSpamTriggerMetadataResponseSchema = z.object({
  mention_total_limit: z.number(),
});

export const triggerType4Schema = z.literal(5);

export const mentionSpamTriggerMetadataSchema = z.object({
  mention_total_limit: z.number(),
  mention_raid_protection_enabled: z.boolean().optional().nullable(),
});

export const messageComponentInputTextResponseSchema = z.object({
  type: z.literal(4),
  custom_id: z.string(),
  style: textStyleTypesSchema,
  label: z.string().optional().nullable(),
  value: z.string().optional().nullable(),
  placeholder: z.string().optional().nullable(),
  required: z.boolean().optional().nullable(),
  min_length: z.number().optional().nullable(),
  max_length: z.number().optional().nullable(),
});

export const messageComponentEmojiResponseSchema = z.object({
  id: snowflakeTypeSchema.optional().nullable(),
  name: z.string(),
  animated: z.boolean().optional().nullable(),
});

export const selectOptionResponseSchema = z.object({
  label: z.string(),
  value: z.string(),
  description: z.string().optional().nullable(),
  emoji: messageComponentEmojiResponseSchema.optional().nullable(),
  default: z.boolean().optional().nullable(),
});

export const messageComponentTypesSchema = z.union([
  z.literal(1),
  z.literal(2),
  z.literal(3),
  z.literal(4),
  z.literal(5),
  z.literal(6),
  z.literal(7),
  z.literal(8),
]);

export const replyMessageReferenceRequestSchema = z.object({
  guild_id: snowflakeTypeSchema.optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  message_id: snowflakeTypeSchema,
  fail_if_not_exists: z.boolean().optional().nullable(),
});

export const messageEmbedAuthorResponseSchema = z.object({
  name: z.string(),
  url: z.string().optional().nullable(),
  icon_url: z.string().optional().nullable(),
  proxy_icon_url: z.string().optional().nullable(),
});

export const messageEmbedFieldResponseSchema = z.object({
  name: z.string(),
  value: z.string(),
  inline: z.boolean(),
});

export const messageEmbedFooterResponseSchema = z.object({
  text: z.string(),
  icon_url: z.string().optional().nullable(),
  proxy_icon_url: z.string().optional().nullable(),
});

export const uInt32TypeSchema = z.number();

export const messageEmbedProviderResponseSchema = z.object({
  name: z.string(),
  url: z.string().optional().nullable(),
});

export const messageEmbedImageResponseSchema = z.object({
  url: z.string().optional().nullable(),
  proxy_url: z.string().optional().nullable(),
  width: uInt32TypeSchema.optional().nullable(),
  height: uInt32TypeSchema.optional().nullable(),
  placeholder: z.string().optional().nullable(),
  placeholder_version: uInt32TypeSchema.optional().nullable(),
});

export const messageEmbedVideoResponseSchema = z.object({
  url: z.string().optional().nullable(),
  proxy_url: z.string().optional().nullable(),
  width: uInt32TypeSchema.optional().nullable(),
  height: uInt32TypeSchema.optional().nullable(),
  placeholder: z.string().optional().nullable(),
  placeholder_version: uInt32TypeSchema.optional().nullable(),
});

export const messageReactionCountDetailsResponseSchema = z.object({
  burst: z.number(),
  normal: z.number(),
});

export const messageReactionEmojiResponseSchema = z.object({
  id: snowflakeTypeSchema.optional().nullable(),
  name: z.string().optional().nullable(),
  animated: z.boolean().optional().nullable(),
});

export const messageReactionResponseSchema = z.object({
  emoji: messageReactionEmojiResponseSchema,
  count: z.number(),
  count_details: messageReactionCountDetailsResponseSchema,
  burst_colors: z.array(z.string()),
  me_burst: z.boolean(),
  me: z.boolean(),
});

export const messageEmbedResponseSchema = z.object({
  type: z.string(),
  url: z.string().optional().nullable(),
  title: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  color: z.number().optional().nullable(),
  timestamp: z.string().optional().nullable(),
  fields: z.array(messageEmbedFieldResponseSchema).optional().nullable(),
  author: messageEmbedAuthorResponseSchema.optional().nullable(),
  provider: messageEmbedProviderResponseSchema.optional().nullable(),
  image: messageEmbedImageResponseSchema.optional().nullable(),
  thumbnail: messageEmbedImageResponseSchema.optional().nullable(),
  video: messageEmbedVideoResponseSchema.optional().nullable(),
  footer: messageEmbedFooterResponseSchema.optional().nullable(),
});

export const messageComponentButtonResponseSchema = z.object({
  type: z.literal(2),
  custom_id: z.string().optional().nullable(),
  style: buttonStyleTypesSchema,
  label: z.string().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  emoji: messageComponentEmojiResponseSchema.optional().nullable(),
  url: z.string().optional().nullable(),
});

export const messageComponentStringSelectResponseSchema = z.object({
  type: z.literal(3),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  options: z.array(selectOptionResponseSchema.nullable()).optional().nullable(),
});

export const standardStickerResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  tags: z.string(),
  type: z.literal(1),
  format_type: stickerFormatTypesSchema.optional().nullable(),
  description: z.string().optional().nullable(),
  pack_id: snowflakeTypeSchema,
  sort_value: z.number(),
});

export const messageStickerItemResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  format_type: stickerFormatTypesSchema,
});

export const inputTextSchema = z.object({
  type: z.literal(4),
  custom_id: z.string(),
  style: textStyleTypesSchema,
  label: z.string(),
  value: z.string().optional().nullable(),
  placeholder: z.string().optional().nullable(),
  required: z.boolean().optional().nullable(),
  min_length: z.number().optional().nullable(),
  max_length: z.number().optional().nullable(),
});

export const myGuildResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  owner: z.boolean(),
  permissions: z.string(),
  features: z.array(guildFeaturesSchema),
  approximate_member_count: z.number().optional().nullable(),
  approximate_presence_count: z.number().optional().nullable(),
});

export const newMemberActionTypeSchema = z.union([z.literal(0), z.literal(1)]);

export const settingsEmojiResponseSchema = z.object({
  id: snowflakeTypeSchema.optional().nullable(),
  name: z.string().optional().nullable(),
  animated: z.boolean().optional().nullable(),
});

export const oAuth2ScopesSchema = z.union([
  z.literal('identify'),
  z.literal('email'),
  z.literal('connections'),
  z.literal('guilds'),
  z.literal('guilds.join'),
  z.literal('guilds.members.read'),
  z.literal('gdm.join'),
  z.literal('bot'),
  z.literal('rpc'),
  z.literal('rpc.notifications.read'),
  z.literal('rpc.voice.read'),
  z.literal('rpc.voice.write'),
  z.literal('rpc.video.read'),
  z.literal('rpc.video.write'),
  z.literal('rpc.screenshare.read'),
  z.literal('rpc.screenshare.write'),
  z.literal('rpc.activities.write'),
  z.literal('webhook.incoming'),
  z.literal('messages.read'),
  z.literal('applications.builds.upload'),
  z.literal('applications.builds.read'),
  z.literal('applications.commands'),
  z.literal('applications.commands.permissions.update'),
  z.literal('applications.commands.update'),
  z.literal('applications.store.update'),
  z.literal('applications.entitlements'),
  z.literal('activities.read'),
  z.literal('activities.write'),
  z.literal('relationships.read'),
  z.literal('voice'),
  z.literal('dm_channels.read'),
  z.literal('role_connections.write'),
]);

export const onboardingPromptOptionRequestSchema = z.object({
  id: snowflakeTypeSchema.optional().nullable(),
  title: z.string(),
  description: z.string().optional().nullable(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
  emoji_animated: z.boolean().optional().nullable(),
  role_ids: z.array(snowflakeTypeSchema).optional().nullable(),
  channel_ids: z.array(snowflakeTypeSchema).optional().nullable(),
});

export const onboardingPromptOptionResponseSchema = z.object({
  id: snowflakeTypeSchema,
  title: z.string(),
  description: z.string(),
  emoji: settingsEmojiResponseSchema,
  role_ids: z.array(snowflakeTypeSchema),
  channel_ids: z.array(snowflakeTypeSchema),
});

export const onboardingPromptTypeSchema = z.union([z.literal(0), z.literal(1)]);

export const pongInteractionCallbackRequestSchema = z.object({
  type: z.literal(1),
});

export const premiumTypesSchema = z.union([z.literal(0), z.literal(1), z.literal(2), z.literal(3)]);

export const userResponseSchema = z.object({
  id: snowflakeTypeSchema,
  username: z.string(),
  avatar: z.string().optional().nullable(),
  discriminator: z.string(),
  public_flags: z.number(),
  premium_type: premiumTypesSchema.optional().nullable(),
  flags: int53TypeSchema,
  bot: z.boolean().optional().nullable(),
  system: z.boolean().optional().nullable(),
  banner: z.string().optional().nullable(),
  accent_color: z.number().optional().nullable(),
  global_name: z.string().optional().nullable(),
});

export const privateChannelRequestPartialSchema = z.object({
  name: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
});

export const privateChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.literal(1),
  last_message_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number(),
  last_pin_timestamp: z.string().optional().nullable(),
  recipients: z.array(userResponseSchema),
});

export const privateGroupChannelResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.literal(3),
  last_message_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number(),
  last_pin_timestamp: z.string().optional().nullable(),
  recipients: z.array(userResponseSchema),
  name: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  owner_id: snowflakeTypeSchema.optional().nullable(),
  managed: z.boolean().optional().nullable(),
  application_id: snowflakeTypeSchema.optional().nullable(),
});

export const privateGuildMemberResponseSchema = z.object({
  avatar: z.string().optional().nullable(),
  communication_disabled_until: z.string().optional().nullable(),
  flags: z.number(),
  joined_at: z.string(),
  nick: z.string().optional().nullable(),
  pending: z.boolean(),
  premium_since: z.string().optional().nullable(),
  roles: z.array(snowflakeTypeSchema),
  user: userResponseSchema,
  mute: z.boolean(),
  deaf: z.boolean(),
  banner: z.string().optional().nullable(),
});

export const purchaseTypeSchema = z.number();

export const quarantineUserActionMetadataSchema = z.record(z.unknown());

export const quarantineUserActionMetadataResponseSchema = z.record(z.unknown());

export const quarantineUserActionResponseSchema = z.object({
  type: z.literal(4),
  metadata: quarantineUserActionMetadataResponseSchema,
});

export const resourceChannelResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
  title: z.string(),
  emoji: settingsEmojiResponseSchema.optional().nullable(),
  icon: z.string().optional().nullable(),
  description: z.string(),
});

export const richEmbedAuthorSchema = z.object({
  name: z.string().optional().nullable(),
  url: z.string().optional().nullable(),
  icon_url: z.string().optional().nullable(),
});

export const richEmbedImageSchema = z.object({
  url: z.string().optional().nullable(),
  width: z.number().optional().nullable(),
  height: z.number().optional().nullable(),
  placeholder: z.string().optional().nullable(),
  placeholder_version: z.number().optional().nullable(),
});

export const richEmbedThumbnailSchema = z.object({
  url: z.string().optional().nullable(),
  width: z.number().optional().nullable(),
  height: z.number().optional().nullable(),
  placeholder: z.string().optional().nullable(),
  placeholder_version: z.number().optional().nullable(),
});

export const richEmbedFooterSchema = z.object({
  text: z.string().optional().nullable(),
  icon_url: z.string().optional().nullable(),
});

export const richEmbedFieldSchema = z.object({
  name: z.string(),
  value: z.string(),
  inline: z.boolean().optional().nullable(),
});

export const richEmbedProviderSchema = z.object({
  name: z.string().optional().nullable(),
  url: z.string().optional().nullable(),
});

export const richEmbedVideoSchema = z.object({
  url: z.string().optional().nullable(),
  width: z.number().optional().nullable(),
  height: z.number().optional().nullable(),
  placeholder: z.string().optional().nullable(),
  placeholder_version: z.number().optional().nullable(),
});

export const roleSelectDefaultValueSchema = z.object({
  type: snowflakeSelectDefaultValueTypesSchema,
  id: snowflakeTypeSchema,
});

export const guildMemberResponseSchema = z.object({
  avatar: z.string().optional().nullable(),
  communication_disabled_until: z.string().optional().nullable(),
  flags: z.number(),
  joined_at: z.string(),
  nick: z.string().optional().nullable(),
  pending: z.boolean(),
  premium_since: z.string().optional().nullable(),
  roles: z.array(snowflakeTypeSchema),
  user: userResponseSchema,
  mute: z.boolean(),
  deaf: z.boolean(),
});

export const selectOptionSchema = z.object({
  label: z.string(),
  value: z.string(),
  description: z.string().optional().nullable(),
  emoji: emojiSchema.optional().nullable(),
  default: z.boolean().optional().nullable(),
});

export const spamLinkTriggerMetadataResponseSchema = z.record(z.unknown());

export const triggerType5Schema = z.literal(2);

export const stageInstancesPrivacyLevelsSchema = z.union([z.literal(1), z.literal(2)]);

export const stageScheduledEventCreateRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  entity_type: z.literal(1),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataStageInstanceSchema.optional().nullable(),
});

export const entityType2Schema = z.literal(1);

export const stageScheduledEventPatchRequestPartialSchema = z.object({
  status: guildScheduledEventStatusesSchema.optional().nullable(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string().optional(),
  scheduled_end_time: z.string().optional().nullable(),
  entity_type: z.literal(1).optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema.optional(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataStageInstanceSchema.optional().nullable(),
});

export const scheduledEventUserResponseSchema = z.object({
  guild_scheduled_event_id: snowflakeTypeSchema,
  user_id: snowflakeTypeSchema,
  user: userResponseSchema.optional().nullable(),
  member: guildMemberResponseSchema.optional().nullable(),
});

export const stickerPackResponseSchema = z.object({
  id: snowflakeTypeSchema,
  sku_id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  stickers: z.array(standardStickerResponseSchema),
  cover_sticker_id: snowflakeTypeSchema.optional().nullable(),
  banner_asset_id: snowflakeTypeSchema.optional().nullable(),
});

export const stickerTypesSchema = z.union([z.literal(1), z.literal(2)]);

export const stringSelectSchema = z.object({
  type: z.literal(3),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  options: z.array(selectOptionSchema),
});

export const teamMembershipStatesSchema = z.union([z.literal(1), z.literal(2)]);

export const teamMemberResponseSchema = z.object({
  user: userResponseSchema,
  team_id: snowflakeTypeSchema,
  membership_state: teamMembershipStatesSchema,
});

export const threadMemberResponseSchema = z.object({
  id: snowflakeTypeSchema,
  user_id: snowflakeTypeSchema,
  join_timestamp: z.string(),
  flags: z.number(),
  member: guildMemberResponseSchema.optional().nullable(),
});

export const threadResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.union([z.literal(10), z.literal(11), z.literal(12)]),
  last_message_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number(),
  last_pin_timestamp: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  permissions: z.string().optional().nullable(),
  owner_id: snowflakeTypeSchema,
  thread_metadata: threadMetadataResponseSchema.optional().nullable(),
  message_count: z.number(),
  member_count: z.number(),
  total_message_sent: z.number(),
  applied_tags: z.array(snowflakeTypeSchema).optional().nullable(),
  member: threadMemberResponseSchema.optional().nullable(),
});

export const threadsResponseSchema = z.object({
  threads: z.array(threadResponseSchema),
  members: z.array(threadMemberResponseSchema),
  has_more: z.boolean().optional().nullable(),
});

export const typingIndicatorResponseSchema = z.record(z.unknown());

export const updateThreadTagRequestSchema = z.object({
  name: z.string(),
  emoji_id: snowflakeTypeSchema.optional().nullable(),
  emoji_name: z.string().optional().nullable(),
  moderated: z.boolean().optional().nullable(),
  id: snowflakeTypeSchema.optional().nullable(),
});

export const updateOnboardingPromptRequestSchema = z.object({
  title: z.string(),
  options: z.array(onboardingPromptOptionRequestSchema),
  single_select: z.boolean().optional().nullable(),
  required: z.boolean().optional().nullable(),
  in_onboarding: z.boolean().optional().nullable(),
  type: onboardingPromptTypeSchema.optional().nullable(),
  id: snowflakeTypeSchema,
});

export const type19Schema = z.union([z.literal(6), z.literal(7)]);

export const updateThreadRequestPartialSchema = z.object({
  name: z.string().optional().nullable(),
  archived: z.boolean().optional().nullable(),
  locked: z.boolean().optional().nullable(),
  invitable: z.boolean().optional().nullable(),
  auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  flags: z.number().optional().nullable(),
  applied_tags: z.array(snowflakeTypeSchema).optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
});

export const userCommunicationDisabledActionMetadataSchema = z.object({
  duration_seconds: z.number(),
});

export const userCommunicationDisabledActionMetadataResponseSchema = z.object({
  duration_seconds: z.number(),
});

export const userCommunicationDisabledActionResponseSchema = z.object({
  type: z.literal(3),
  metadata: userCommunicationDisabledActionMetadataResponseSchema,
});

export const onboardingPromptResponseSchema = z.object({
  id: snowflakeTypeSchema,
  title: z.string(),
  options: z.array(onboardingPromptOptionResponseSchema),
  single_select: z.boolean(),
  required: z.boolean(),
  in_onboarding: z.boolean(),
  type: onboardingPromptTypeSchema,
});

export const userPIIResponseSchema = z.object({
  id: snowflakeTypeSchema,
  username: z.string(),
  avatar: z.string().optional().nullable(),
  discriminator: z.string(),
  public_flags: z.number(),
  premium_type: premiumTypesSchema.optional().nullable(),
  flags: int53TypeSchema,
  bot: z.boolean().optional().nullable(),
  system: z.boolean().optional().nullable(),
  banner: z.string().optional().nullable(),
  accent_color: z.number().optional().nullable(),
  global_name: z.string().optional().nullable(),
  mfa_enabled: z.boolean(),
  locale: availableLocalesEnumSchema,
  email: z.string().optional().nullable(),
  verified: z.boolean().optional().nullable(),
});

export const userSelectDefaultValueSchema = z.object({
  type: snowflakeSelectDefaultValueTypesSchema,
  id: snowflakeTypeSchema,
});

export const vanityURLErrorResponseSchema = z.object({
  message: z.string(),
  code: z.number(),
});

export const vanityURLResponseSchema = z.object({
  code: z.string().optional().nullable(),
  uses: z.number(),
  error: vanityURLErrorResponseSchema.optional().nullable(),
});

export const voiceRegionResponseSchema = z.object({
  id: z.string(),
  name: z.string(),
  custom: z.boolean(),
  deprecated: z.boolean(),
  optimal: z.boolean(),
});

export const voiceScheduledEventCreateRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  entity_type: z.literal(2),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataVoiceSchema.optional().nullable(),
});

export const entityType3Schema = z.literal(2);

export const voiceScheduledEventPatchRequestPartialSchema = z.object({
  status: guildScheduledEventStatusesSchema.optional().nullable(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string().optional(),
  scheduled_end_time: z.string().optional().nullable(),
  entity_type: z.literal(2).optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema.optional(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataVoiceSchema.optional().nullable(),
});

export const voiceScheduledEventResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  creator_id: snowflakeTypeSchema.optional().nullable(),
  creator: userResponseSchema.optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  status: guildScheduledEventStatusesSchema,
  entity_type: z.literal(2),
  entity_id: snowflakeTypeSchema.optional().nullable(),
  user_count: z.number().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  user_rsvp: scheduledEventUserResponseSchema.optional().nullable(),
  entity_metadata: entityMetadataVoiceResponseSchema.optional().nullable(),
});

export const webhookSlackEmbedFieldSchema = z.object({
  name: z.string().optional().nullable(),
  value: z.string().optional().nullable(),
  inline: z.boolean().optional().nullable(),
});

export const webhookTypesSchema = z.union([z.literal(1), z.literal(2), z.literal(3)]);

export const welcomeScreenPatchRequestPartialSchema = z.object({
  description: z.string().optional().nullable(),
  welcome_channels: z.array(guildWelcomeChannelSchema).optional().nullable(),
  enabled: z.boolean().optional().nullable(),
});

export const widgetActivitySchema = z.object({
  name: z.string(),
});

export const widgetChannelSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  position: z.number(),
});

export const widgetImageStylesSchema = z.union([
  z.literal('shield'),
  z.literal('banner1'),
  z.literal('banner2'),
  z.literal('banner3'),
  z.literal('banner4'),
]);

export const widgetUserDiscriminatorSchema = z.literal('0000');

export const widgetMemberSchema = z.object({
  id: z.string(),
  username: z.string(),
  discriminator: widgetUserDiscriminatorSchema,
  avatar: z.null().optional(),
  status: z.string(),
  avatar_url: z.string(),
  activity: widgetActivitySchema.optional().nullable(),
  deaf: z.boolean().optional().nullable(),
  mute: z.boolean().optional().nullable(),
  self_deaf: z.boolean().optional().nullable(),
  self_mute: z.boolean().optional().nullable(),
  suppress: z.boolean().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
});

export const widgetSettingsResponseSchema = z.object({
  enabled: z.boolean(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
});

export const errorSchema = z.object({
  code: z.number(),
  message: z.string(),
});

export const innerErrorsSchema = z.object({
  _errors: z.array(errorSchema),
});

export const errorDetailsSchema: z.ZodSchema<ErrorDetails> = z.lazy(() =>
  z.union([z.record(errorDetailsSchema), innerErrorsSchema]),
);

export const errorResponseSchema = errorSchema.and(
  z.object({
    errors: errorDetailsSchema.optional(),
  }),
);

export const getMyOauth2ApplicationErrorSchema = errorResponseSchema;

export const connectedAccountResponseSchema = z.object({
  id: z.string(),
  name: z.string().optional().nullable(),
  type: connectedAccountProvidersSchema,
  friend_sync: z.boolean(),
  integrations: z.array(connectedAccountIntegrationResponseSchema).optional().nullable(),
  show_activity: z.boolean(),
  two_way_link: z.boolean(),
  verified: z.boolean(),
  visibility: connectedAccountVisibilitySchema,
  revoked: z.boolean().optional().nullable(),
});

export const listMyConnectionsErrorSchema = errorResponseSchema;

export const createDmDataSchema = z.object({
  body: createPrivateChannelRequestSchema,
});

export const createDmResponseSchema = z.union([privateChannelResponseSchema, privateGroupChannelResponseSchema]);

export const createDmErrorSchema = errorResponseSchema;

export const listMyGuildsDataSchema = z.object({
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
      with_counts: z.boolean().optional(),
    })
    .optional(),
});

export const listMyGuildsResponseSchema = z.array(myGuildResponseSchema).nullable();

export const listMyGuildsErrorSchema = errorResponseSchema;

export const getMyApplicationErrorSchema = errorResponseSchema;

export const applicationFormPartialSchema = z.object({
  description: z
    .object({
      default: z.string(),
      localizations: z.record(z.string()).optional().nullable(),
    })
    .optional()
    .nullable(),
  icon: z.string().optional().nullable(),
  cover_image: z.string().optional().nullable(),
  team_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number().optional().nullable(),
  interactions_endpoint_url: z.string().optional().nullable(),
  max_participants: z.number().optional().nullable(),
  type: applicationTypesSchema.optional().nullable(),
  tags: z.array(z.string()).optional().nullable(),
  custom_install_url: z.string().optional().nullable(),
  install_params: applicationOAuth2ParamsSchema.optional().nullable(),
  role_connections_verification_url: z.string().optional().nullable(),
});

export const updateMyApplicationErrorSchema = errorResponseSchema;

export const gatewayBotResponseSchema = z.object({
  url: z.string(),
  session_start_limit: gatewayBotSessionStartLimitResponseSchema,
  shards: z.number(),
});

export const getBotGatewayErrorSchema = errorResponseSchema;

export const getMyOauth2AuthorizationErrorSchema = errorResponseSchema;

export const listVoiceRegionsResponseSchema = z.array(voiceRegionResponseSchema).nullable();

export const listVoiceRegionsErrorSchema = errorResponseSchema;

export const getMyUserResponseSchema = userPIIResponseSchema;

export const getMyUserErrorSchema = errorResponseSchema;

export const updateMyUserDataSchema = z.object({
  body: botAccountPatchRequestSchema,
});

export const updateMyUserResponseSchema = userPIIResponseSchema;

export const updateMyUserErrorSchema = errorResponseSchema;

export const createStageInstanceDataSchema = z.object({
  body: z.object({
    topic: z.string(),
    channel_id: snowflakeTypeSchema,
    privacy_level: stageInstancesPrivacyLevelsSchema.optional().nullable(),
    guild_scheduled_event_id: snowflakeTypeSchema.optional().nullable(),
    send_start_notification: z.boolean().optional().nullable(),
  }),
});

export const stageInstanceResponseSchema = z.object({
  guild_id: snowflakeTypeSchema,
  channel_id: snowflakeTypeSchema,
  topic: z.string(),
  privacy_level: stageInstancesPrivacyLevelsSchema,
  id: snowflakeTypeSchema,
  discoverable_disabled: z.boolean().optional().nullable(),
  guild_scheduled_event_id: snowflakeTypeSchema.optional().nullable(),
});

export const createStageInstanceErrorSchema = errorResponseSchema;

export const stickerPackCollectionResponseSchema = z.object({
  sticker_packs: z.array(stickerPackResponseSchema),
});

export const listStickerPacksErrorSchema = errorResponseSchema;

export const getGatewayResponseSchema = gatewayResponseSchema;

export const getGatewayErrorSchema = errorResponseSchema;

export const guildCreateRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  verification_level: verificationLevelsSchema.optional().nullable(),
  default_message_notifications: userNotificationSettingsSchema.optional().nullable(),
  explicit_content_filter: guildExplicitContentFilterTypesSchema.optional().nullable(),
  preferred_locale: availableLocalesEnumSchema.optional().nullable(),
  afk_timeout: afkTimeoutsSchema.optional().nullable(),
  roles: z.array(createGuildRequestRoleItemSchema).optional().nullable(),
  channels: z.array(createGuildRequestChannelItemSchema).optional().nullable(),
  afk_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_flags: z.number().optional().nullable(),
});

export const createGuildErrorSchema = errorResponseSchema;

export const listMyPrivateArchivedThreadsDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listMyPrivateArchivedThreadsResponseSchema = threadsResponseSchema;

export const listMyPrivateArchivedThreadsErrorSchema = errorResponseSchema;

export const listGuildApplicationCommandPermissionsDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildApplicationCommandPermissionsResponseSchema = z.array(commandPermissionsResponseSchema);

export const listGuildApplicationCommandPermissionsErrorSchema = errorResponseSchema;

export const getGuildApplicationCommandPermissionsDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildApplicationCommandPermissionsResponseSchema = commandPermissionsResponseSchema;

export const getGuildApplicationCommandPermissionsErrorSchema = errorResponseSchema;

export const applicationCommandPermissionSchema = z.object({
  id: snowflakeTypeSchema,
  type: applicationCommandPermissionTypeSchema,
  permission: z.boolean(),
});

export const setGuildApplicationCommandPermissionsResponseSchema = commandPermissionsResponseSchema;

export const setGuildApplicationCommandPermissionsErrorSchema = errorResponseSchema;

export const addMyMessageReactionDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    emoji_name: z.string(),
    message_id: snowflakeTypeSchema,
  }),
});

export const addMyMessageReactionResponseSchema = z.any();

export const addMyMessageReactionErrorSchema = errorResponseSchema;

export const deleteMyMessageReactionDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    emoji_name: z.string(),
    message_id: snowflakeTypeSchema,
  }),
});

export const deleteMyMessageReactionResponseSchema = z.any();

export const deleteMyMessageReactionErrorSchema = errorResponseSchema;

export const listPrivateArchivedThreadsDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      before: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listPrivateArchivedThreadsResponseSchema = threadsResponseSchema;

export const listPrivateArchivedThreadsErrorSchema = errorResponseSchema;

export const listPublicArchivedThreadsDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      before: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listPublicArchivedThreadsResponseSchema = threadsResponseSchema;

export const listPublicArchivedThreadsErrorSchema = errorResponseSchema;

export const getApplicationUserRoleConnectionDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const getApplicationUserRoleConnectionResponseSchema = applicationUserRoleConnectionResponseSchema;

export const getApplicationUserRoleConnectionErrorSchema = errorResponseSchema;

export const updateApplicationUserRoleConnectionDataSchema = z.object({
  body: z.object({
    platform_name: z.string().optional().nullable(),
    platform_username: z.string().optional().nullable(),
    metadata: z.record(z.string()).optional().nullable(),
  }),
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const updateApplicationUserRoleConnectionResponseSchema = applicationUserRoleConnectionResponseSchema;

export const updateApplicationUserRoleConnectionErrorSchema = errorResponseSchema;

export const getMyGuildMemberDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getMyGuildMemberResponseSchema = privateGuildMemberResponseSchema;

export const getMyGuildMemberErrorSchema = errorResponseSchema;

export const getApplicationRoleConnectionsMetadataDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const getApplicationRoleConnectionsMetadataResponseSchema = z
  .array(applicationRoleConnectionsMetadataItemResponseSchema)
  .nullable();

export const getApplicationRoleConnectionsMetadataErrorSchema = errorResponseSchema;

export const applicationRoleConnectionsMetadataItemRequestSchema = z.object({
  type: metadataItemTypesSchema,
  key: z.string(),
  name: z.string(),
  name_localizations: z.record(z.string().nullable()).optional().nullable(),
  description: z.string(),
  description_localizations: z.record(z.string().nullable()).optional().nullable(),
});

export const updateApplicationRoleConnectionsMetadataResponseSchema = z
  .array(applicationRoleConnectionsMetadataItemResponseSchema)
  .nullable();

export const updateApplicationRoleConnectionsMetadataErrorSchema = errorResponseSchema;

export const getGuildApplicationCommandDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildApplicationCommandErrorSchema = errorResponseSchema;

export const deleteGuildApplicationCommandDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildApplicationCommandResponseSchema = z.any();

export const deleteGuildApplicationCommandErrorSchema = errorResponseSchema;

export const applicationCommandPatchRequestPartialSchema = z.object({
  name: z.string().optional(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionSchema,
        applicationCommandBooleanOptionSchema,
        applicationCommandChannelOptionSchema,
        applicationCommandIntegerOptionSchema,
        applicationCommandMentionableOptionSchema,
        applicationCommandNumberOptionSchema,
        applicationCommandRoleOptionSchema,
        applicationCommandStringOptionSchema,
        applicationCommandSubcommandGroupOptionSchema,
        applicationCommandSubcommandOptionSchema,
        applicationCommandUserOptionSchema,
      ]),
    )
    .optional()
    .nullable(),
  default_member_permissions: z.number().optional().nullable(),
  dm_permission: z.boolean().optional().nullable(),
});

export const updateGuildApplicationCommandErrorSchema = errorResponseSchema;

export const listGuildApplicationCommandsDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_localizations: z.boolean().optional(),
    })
    .optional(),
});

export const listGuildApplicationCommandsErrorSchema = errorResponseSchema;

export const bulkSetGuildApplicationCommandsDataSchema = z.object({
  body: z.array(applicationCommandUpdateRequestSchema).nullable(),
  path: z.object({
    application_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const bulkSetGuildApplicationCommandsErrorSchema = errorResponseSchema;

export const applicationCommandCreateRequestSchema = z.object({
  name: z.string(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionSchema,
        applicationCommandBooleanOptionSchema,
        applicationCommandChannelOptionSchema,
        applicationCommandIntegerOptionSchema,
        applicationCommandMentionableOptionSchema,
        applicationCommandNumberOptionSchema,
        applicationCommandRoleOptionSchema,
        applicationCommandStringOptionSchema,
        applicationCommandSubcommandGroupOptionSchema,
        applicationCommandSubcommandOptionSchema,
        applicationCommandUserOptionSchema,
      ]),
    )
    .optional()
    .nullable(),
  default_member_permissions: z.number().optional().nullable(),
  dm_permission: z.boolean().optional().nullable(),
  type: applicationCommandTypeSchema.optional().nullable(),
});

export const createGuildApplicationCommandErrorSchema = errorResponseSchema;

export const joinThreadDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const joinThreadResponseSchema = z.any();

export const joinThreadErrorSchema = errorResponseSchema;

export const leaveThreadDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const leaveThreadResponseSchema = z.any();

export const leaveThreadErrorSchema = errorResponseSchema;

export const bulkDeleteMessagesDataSchema = z.object({
  body: z.object({
    messages: z.array(snowflakeTypeSchema),
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const bulkDeleteMessagesResponseSchema = z.any();

export const bulkDeleteMessagesErrorSchema = errorResponseSchema;

export const deleteUserMessageReactionDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    emoji_name: z.string(),
    message_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const deleteUserMessageReactionResponseSchema = z.any();

export const deleteUserMessageReactionErrorSchema = errorResponseSchema;

export const listMessageReactionsByEmojiDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    emoji_name: z.string(),
    message_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listMessageReactionsByEmojiResponseSchema = z.array(userResponseSchema);

export const listMessageReactionsByEmojiErrorSchema = errorResponseSchema;

export const deleteAllMessageReactionsByEmojiDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    emoji_name: z.string(),
    message_id: snowflakeTypeSchema,
  }),
});

export const deleteAllMessageReactionsByEmojiResponseSchema = z.any();

export const deleteAllMessageReactionsByEmojiErrorSchema = errorResponseSchema;

export const deleteAllMessageReactionsDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const deleteAllMessageReactionsResponseSchema = z.any();

export const deleteAllMessageReactionsErrorSchema = errorResponseSchema;

export const crosspostMessageDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const crosspostMessageErrorSchema = errorResponseSchema;

export const createThreadFromMessageDataSchema = z.object({
  body: createTextThreadWithMessageRequestSchema,
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const createThreadFromMessageResponseSchema = threadResponseSchema;

export const createThreadFromMessageErrorSchema = errorResponseSchema;

export const getOriginalWebhookMessageDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const getOriginalWebhookMessageErrorSchema = errorResponseSchema;

export const deleteOriginalWebhookMessageDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const deleteOriginalWebhookMessageResponseSchema = z.any();

export const deleteOriginalWebhookMessageErrorSchema = errorResponseSchema;

export const updateOriginalWebhookMessageErrorSchema = errorResponseSchema;

export const listGuildScheduledEventUsersDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    guild_scheduled_event_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
      with_member: z.boolean().optional(),
    })
    .optional(),
});

export const listGuildScheduledEventUsersResponseSchema = z.array(scheduledEventUserResponseSchema).nullable();

export const listGuildScheduledEventUsersErrorSchema = errorResponseSchema;

export const getAutoModerationRuleDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    rule_id: snowflakeTypeSchema,
  }),
});

export const getAutoModerationRuleErrorSchema = errorResponseSchema;

export const deleteAutoModerationRuleDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    rule_id: snowflakeTypeSchema,
  }),
});

export const deleteAutoModerationRuleResponseSchema = z.any();

export const deleteAutoModerationRuleErrorSchema = errorResponseSchema;

export const updateAutoModerationRuleErrorSchema = errorResponseSchema;

export const listAutoModerationRulesDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const defaultKeywordRuleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  creator_id: snowflakeTypeSchema,
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z.array(
    z.union([
      blockMessageActionResponseSchema,
      flagToChannelActionResponseSchema,
      quarantineUserActionResponseSchema,
      userCommunicationDisabledActionResponseSchema,
    ]),
  ),
  trigger_type: z.literal(4),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_metadata: defaultKeywordListTriggerMetadataResponseSchema,
});

export const keywordRuleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  creator_id: snowflakeTypeSchema,
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z.array(
    z.union([
      blockMessageActionResponseSchema,
      flagToChannelActionResponseSchema,
      quarantineUserActionResponseSchema,
      userCommunicationDisabledActionResponseSchema,
    ]),
  ),
  trigger_type: z.literal(1),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_metadata: keywordTriggerMetadataResponseSchema,
});

export const mLSpamRuleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  creator_id: snowflakeTypeSchema,
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z.array(
    z.union([
      blockMessageActionResponseSchema,
      flagToChannelActionResponseSchema,
      quarantineUserActionResponseSchema,
      userCommunicationDisabledActionResponseSchema,
    ]),
  ),
  trigger_type: z.literal(3),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_metadata: mLSpamTriggerMetadataResponseSchema,
});

export const mentionSpamRuleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  creator_id: snowflakeTypeSchema,
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z.array(
    z.union([
      blockMessageActionResponseSchema,
      flagToChannelActionResponseSchema,
      quarantineUserActionResponseSchema,
      userCommunicationDisabledActionResponseSchema,
    ]),
  ),
  trigger_type: z.literal(5),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_metadata: mentionSpamTriggerMetadataResponseSchema,
});

export const spamLinkRuleResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  creator_id: snowflakeTypeSchema,
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z.array(
    z.union([
      blockMessageActionResponseSchema,
      flagToChannelActionResponseSchema,
      quarantineUserActionResponseSchema,
      userCommunicationDisabledActionResponseSchema,
    ]),
  ),
  trigger_type: z.literal(2),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_metadata: spamLinkTriggerMetadataResponseSchema,
});

export const listAutoModerationRulesErrorSchema = errorResponseSchema;

export const createAutoModerationRuleResponseSchema = z.union([
  defaultKeywordRuleResponseSchema,
  keywordRuleResponseSchema,
  mLSpamRuleResponseSchema,
  mentionSpamRuleResponseSchema,
  spamLinkRuleResponseSchema,
]);

export const createAutoModerationRuleErrorSchema = errorResponseSchema;

export const updateSelfVoiceStateDataSchema = z.object({
  body: z.object({
    request_to_speak_timestamp: z.string().optional().nullable(),
    suppress: z.boolean().optional().nullable(),
    channel_id: snowflakeTypeSchema.optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateSelfVoiceStateResponseSchema = z.any();

export const updateSelfVoiceStateErrorSchema = errorResponseSchema;

export const searchGuildMembersDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z.object({
    limit: z.number(),
    query: z.string(),
  }),
});

export const searchGuildMembersResponseSchema = z.array(guildMemberResponseSchema);

export const searchGuildMembersErrorSchema = errorResponseSchema;

export const getActiveGuildThreadsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getActiveGuildThreadsResponseSchema = threadsResponseSchema;

export const getActiveGuildThreadsErrorSchema = errorResponseSchema;

export const updateMyGuildMemberDataSchema = z.object({
  body: z.object({
    nick: z.string().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateMyGuildMemberResponseSchema = privateGuildMemberResponseSchema;

export const updateMyGuildMemberErrorSchema = errorResponseSchema;

export const addGuildMemberRoleDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    role_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const addGuildMemberRoleResponseSchema = z.any();

export const addGuildMemberRoleErrorSchema = errorResponseSchema;

export const deleteGuildMemberRoleDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    role_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildMemberRoleResponseSchema = z.any();

export const deleteGuildMemberRoleErrorSchema = errorResponseSchema;

export const leaveGuildDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const leaveGuildResponseSchema = z.any();

export const leaveGuildErrorSchema = errorResponseSchema;

export const getApplicationCommandDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
  }),
});

export const getApplicationCommandErrorSchema = errorResponseSchema;

export const deleteApplicationCommandDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
  }),
});

export const deleteApplicationCommandResponseSchema = z.any();

export const deleteApplicationCommandErrorSchema = errorResponseSchema;

export const updateApplicationCommandDataSchema = z.object({
  body: applicationCommandPatchRequestPartialSchema,
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
  }),
});

export const updateApplicationCommandErrorSchema = errorResponseSchema;

export const listApplicationCommandsDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_localizations: z.boolean().optional(),
    })
    .optional(),
});

export const listApplicationCommandsErrorSchema = errorResponseSchema;

export const bulkSetApplicationCommandsDataSchema = z.object({
  body: z.array(applicationCommandUpdateRequestSchema).nullable(),
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const bulkSetApplicationCommandsErrorSchema = errorResponseSchema;

export const createApplicationCommandDataSchema = z.object({
  body: applicationCommandCreateRequestSchema,
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const createApplicationCommandErrorSchema = errorResponseSchema;

export const applicationCommandAutocompleteCallbackRequestSchema = z.object({
  type: z.literal(8),
  data: z.union([
    interactionApplicationCommandAutocompleteCallbackIntegerDataSchema,
    interactionApplicationCommandAutocompleteCallbackNumberDataSchema,
    interactionApplicationCommandAutocompleteCallbackStringDataSchema,
  ]),
});

export const createInteractionResponseResponseSchema = z.any();

export const createInteractionResponseErrorSchema = errorResponseSchema;

export const getThreadMemberDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_member: z.boolean().optional(),
    })
    .optional(),
});

export const getThreadMemberResponseSchema = threadMemberResponseSchema;

export const getThreadMemberErrorSchema = errorResponseSchema;

export const addThreadMemberDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const addThreadMemberResponseSchema = z.any();

export const addThreadMemberErrorSchema = errorResponseSchema;

export const deleteThreadMemberDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const deleteThreadMemberResponseSchema = z.any();

export const deleteThreadMemberErrorSchema = errorResponseSchema;

export const listThreadMembersDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
      with_member: z.boolean().optional(),
    })
    .optional(),
});

export const listThreadMembersResponseSchema = z.array(threadMemberResponseSchema);

export const listThreadMembersErrorSchema = errorResponseSchema;

export const setChannelPermissionOverwriteDataSchema = z.object({
  body: z.object({
    type: channelPermissionOverwritesSchema.optional().nullable(),
    allow: z.number().optional().nullable(),
    deny: z.number().optional().nullable(),
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
    overwrite_id: snowflakeTypeSchema,
  }),
});

export const setChannelPermissionOverwriteResponseSchema = z.any();

export const setChannelPermissionOverwriteErrorSchema = errorResponseSchema;

export const deleteChannelPermissionOverwriteDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    overwrite_id: snowflakeTypeSchema,
  }),
});

export const deleteChannelPermissionOverwriteResponseSchema = z.any();

export const deleteChannelPermissionOverwriteErrorSchema = errorResponseSchema;

export const addGroupDmUserDataSchema = z.object({
  body: z.object({
    access_token: z.string().optional().nullable(),
    nick: z.string().optional().nullable(),
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const addGroupDmUserResponseSchema = z.union([
  z.union([privateChannelResponseSchema, privateGroupChannelResponseSchema]),
  z.any(),
]);

export const addGroupDmUserErrorSchema = errorResponseSchema;

export const deleteGroupDmUserDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const deleteGroupDmUserResponseSchema = z.any();

export const deleteGroupDmUserErrorSchema = errorResponseSchema;

export const followChannelDataSchema = z.object({
  body: z.object({
    webhook_channel_id: snowflakeTypeSchema,
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const followChannelResponseSchema = channelFollowerResponseSchema;

export const followChannelErrorSchema = errorResponseSchema;

export const getMessageDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const getMessageErrorSchema = errorResponseSchema;

export const deleteMessageDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const deleteMessageResponseSchema = z.any();

export const deleteMessageErrorSchema = errorResponseSchema;

export const updateMessageErrorSchema = errorResponseSchema;

export const listMessagesDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      around: snowflakeTypeSchema.optional(),
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listMessagesErrorSchema = errorResponseSchema;

export const createMessageErrorSchema = errorResponseSchema;

export const listChannelWebhooksDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const applicationIncomingWebhookResponseSchema = z.object({
  application_id: snowflakeTypeSchema.optional().nullable(),
  avatar: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  id: snowflakeTypeSchema,
  name: z.string(),
  type: z.literal(3),
  user: userResponseSchema.optional().nullable(),
});

export const channelFollowerWebhookResponseSchema = z.object({
  application_id: snowflakeTypeSchema.optional().nullable(),
  avatar: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  id: snowflakeTypeSchema,
  name: z.string(),
  type: z.literal(2),
  user: userResponseSchema.optional().nullable(),
  source_guild: webhookSourceGuildResponseSchema.optional().nullable(),
  source_channel: webhookSourceChannelResponseSchema.optional().nullable(),
});

export const guildIncomingWebhookResponseSchema = z.object({
  application_id: snowflakeTypeSchema.optional().nullable(),
  avatar: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  id: snowflakeTypeSchema,
  name: z.string(),
  type: z.literal(1),
  user: userResponseSchema.optional().nullable(),
  token: z.string().optional().nullable(),
  url: z.string().optional().nullable(),
});

export const listChannelWebhooksErrorSchema = errorResponseSchema;

export const createWebhookDataSchema = z.object({
  body: z.object({
    name: z.string(),
    avatar: z.string().optional().nullable(),
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const createWebhookResponseSchema = guildIncomingWebhookResponseSchema;

export const createWebhookErrorSchema = errorResponseSchema;

export const listChannelInvitesDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const friendInviteResponseSchema = z.object({
  type: z.literal(2).optional().nullable(),
  code: z.string(),
  inviter: userResponseSchema.optional().nullable(),
  max_age: z.number().optional().nullable(),
  created_at: z.string().optional().nullable(),
  expires_at: z.string().optional().nullable(),
  friends_count: z.number().optional().nullable(),
  channel: inviteChannelResponseSchema.optional().nullable(),
  is_contact: z.boolean().optional().nullable(),
  uses: z.number().optional().nullable(),
  max_uses: z.number().optional().nullable(),
  flags: z.number().optional().nullable(),
});

export const groupDMInviteResponseSchema = z.object({
  type: z.literal(1).optional().nullable(),
  code: z.string(),
  inviter: userResponseSchema.optional().nullable(),
  max_age: z.number().optional().nullable(),
  created_at: z.string().optional().nullable(),
  expires_at: z.string().optional().nullable(),
  channel: inviteChannelResponseSchema.optional().nullable(),
  approximate_member_count: z.number().optional().nullable(),
});

export const listChannelInvitesErrorSchema = errorResponseSchema;

export const createChannelInviteDataSchema = z.object({
  body: z.union([createGroupDMInviteRequestSchema, createGuildInviteRequestSchema]),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const createChannelInviteErrorSchema = errorResponseSchema;

export const createdThreadResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: z.union([z.literal(10), z.literal(11), z.literal(12)]),
  last_message_id: snowflakeTypeSchema.optional().nullable(),
  flags: z.number(),
  last_pin_timestamp: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  permissions: z.string().optional().nullable(),
  owner_id: snowflakeTypeSchema,
  thread_metadata: threadMetadataResponseSchema.optional().nullable(),
  message_count: z.number(),
  member_count: z.number(),
  total_message_sent: z.number(),
  applied_tags: z.array(snowflakeTypeSchema).optional().nullable(),
  member: threadMemberResponseSchema.optional().nullable(),
});

export const createThreadErrorSchema = errorResponseSchema;

export const triggerTypingIndicatorDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const triggerTypingIndicatorResponseSchema = z.union([typingIndicatorResponseSchema, z.any()]);

export const triggerTypingIndicatorErrorSchema = errorResponseSchema;

export const pinMessageDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const pinMessageResponseSchema = z.any();

export const pinMessageErrorSchema = errorResponseSchema;

export const unpinMessageDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const unpinMessageResponseSchema = z.any();

export const unpinMessageErrorSchema = errorResponseSchema;

export const listPinnedMessagesDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const listPinnedMessagesErrorSchema = errorResponseSchema;

export const getWebhookMessageDataSchema = z.object({
  path: z.object({
    message_id: snowflakeTypeSchema,
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const getWebhookMessageErrorSchema = errorResponseSchema;

export const deleteWebhookMessageDataSchema = z.object({
  path: z.object({
    message_id: snowflakeTypeSchema,
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const deleteWebhookMessageResponseSchema = z.any();

export const deleteWebhookMessageErrorSchema = errorResponseSchema;

export const updateWebhookMessageErrorSchema = errorResponseSchema;

export const githubWebhookSchema = z.object({
  action: z.string().optional().nullable(),
  ref: z.string().optional().nullable(),
  ref_type: z.string().optional().nullable(),
  comment: githubCommentSchema.optional().nullable(),
  issue: githubIssueSchema.optional().nullable(),
  pull_request: githubIssueSchema.optional().nullable(),
  repository: githubRepositorySchema.optional().nullable(),
  forkee: githubRepositorySchema.optional().nullable(),
  sender: githubUserSchema,
  member: githubUserSchema.optional().nullable(),
  release: githubReleaseSchema.optional().nullable(),
  head_commit: githubCommitSchema.optional().nullable(),
  commits: z.array(githubCommitSchema).optional().nullable(),
  forced: z.boolean().optional().nullable(),
  compare: z.string().optional().nullable(),
  review: githubReviewSchema.optional().nullable(),
  check_run: githubCheckRunSchema.optional().nullable(),
  check_suite: githubCheckSuiteSchema.optional().nullable(),
  discussion: githubDiscussionSchema.optional().nullable(),
  answer: githubCommentSchema.optional().nullable(),
});

export const executeGithubCompatibleWebhookResponseSchema = z.any();

export const executeGithubCompatibleWebhookErrorSchema = errorResponseSchema;

export const executeSlackCompatibleWebhookResponseSchema = z.string().nullable();

export const executeSlackCompatibleWebhookErrorSchema = errorResponseSchema;

export const getGuildTemplateDataSchema = z.object({
  path: z.object({
    code: z.string(),
  }),
});

export const getGuildTemplateErrorSchema = errorResponseSchema;

export const createGuildFromTemplateDataSchema = z.object({
  body: z.object({
    name: z.string(),
    icon: z.string().optional().nullable(),
  }),
  path: z.object({
    code: z.string(),
  }),
});

export const createGuildFromTemplateErrorSchema = errorResponseSchema;

export const getGuildNewMemberWelcomeDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildNewMemberWelcomeErrorSchema = errorResponseSchema;

export const getGuildScheduledEventDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    guild_scheduled_event_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_user_count: z.boolean().optional(),
    })
    .optional(),
});

export const getGuildScheduledEventErrorSchema = errorResponseSchema;

export const deleteGuildScheduledEventDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    guild_scheduled_event_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildScheduledEventResponseSchema = z.any();

export const deleteGuildScheduledEventErrorSchema = errorResponseSchema;

export const externalScheduledEventPatchRequestPartialSchema = z.object({
  status: guildScheduledEventStatusesSchema.optional().nullable(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string().optional(),
  scheduled_end_time: z.string().optional().nullable(),
  entity_type: z.literal(3).optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema.optional(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataExternalSchema.optional(),
});

export const updateGuildScheduledEventErrorSchema = errorResponseSchema;

export const listGuildScheduledEventsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_user_count: z.boolean().optional(),
    })
    .optional(),
});

export const externalScheduledEventResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  creator_id: snowflakeTypeSchema.optional().nullable(),
  creator: userResponseSchema.optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  status: guildScheduledEventStatusesSchema,
  entity_type: z.literal(3),
  entity_id: snowflakeTypeSchema.optional().nullable(),
  user_count: z.number().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  user_rsvp: scheduledEventUserResponseSchema.optional().nullable(),
  entity_metadata: entityMetadataExternalResponseSchema,
});

export const stageScheduledEventResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  creator_id: snowflakeTypeSchema.optional().nullable(),
  creator: userResponseSchema.optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  status: guildScheduledEventStatusesSchema,
  entity_type: z.literal(1),
  entity_id: snowflakeTypeSchema.optional().nullable(),
  user_count: z.number().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  user_rsvp: scheduledEventUserResponseSchema.optional().nullable(),
  entity_metadata: entityMetadataStageInstanceResponseSchema.optional().nullable(),
});

export const listGuildScheduledEventsErrorSchema = errorResponseSchema;

export const externalScheduledEventCreateRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  entity_type: z.literal(3),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  entity_metadata: entityMetadataExternalSchema,
});

export const createGuildScheduledEventResponseSchema = z.union([
  externalScheduledEventResponseSchema,
  stageScheduledEventResponseSchema,
  voiceScheduledEventResponseSchema,
]);

export const createGuildScheduledEventErrorSchema = errorResponseSchema;

export const getGuildWelcomeScreenDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildWelcomeScreenResponseSchema = guildWelcomeScreenResponseSchema;

export const getGuildWelcomeScreenErrorSchema = errorResponseSchema;

export const updateGuildWelcomeScreenDataSchema = z.object({
  body: welcomeScreenPatchRequestPartialSchema,
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateGuildWelcomeScreenResponseSchema = guildWelcomeScreenResponseSchema;

export const updateGuildWelcomeScreenErrorSchema = errorResponseSchema;

export const updateVoiceStateDataSchema = z.object({
  body: z.object({
    suppress: z.boolean().optional().nullable(),
    channel_id: snowflakeTypeSchema.optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const updateVoiceStateResponseSchema = z.any();

export const updateVoiceStateErrorSchema = errorResponseSchema;

export const deleteGuildIntegrationDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    integration_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildIntegrationResponseSchema = z.any();

export const deleteGuildIntegrationErrorSchema = errorResponseSchema;

export const listGuildIntegrationsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const externalConnectionIntegrationResponseSchema = z.object({
  type: z.union([z.literal('twitch'), z.literal('youtube')]),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
  enabled: z.boolean().optional().nullable(),
  id: z.string(),
  user: userResponseSchema,
  revoked: z.boolean().optional().nullable(),
  expire_behavior: integrationExpireBehaviorTypesSchema.optional().nullable(),
  expire_grace_period: integrationExpireGracePeriodTypesSchema.optional().nullable(),
  subscriber_count: z.number().optional().nullable(),
  synced_at: z.string().optional().nullable(),
  role_id: snowflakeTypeSchema.optional().nullable(),
  syncing: z.boolean().optional().nullable(),
  enable_emoticons: z.boolean().optional().nullable(),
});

export const listGuildIntegrationsErrorSchema = errorResponseSchema;

export const getGuildWidgetDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const widgetResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  instant_invite: z.string().optional().nullable(),
  channels: z.array(widgetChannelSchema),
  members: z.array(widgetMemberSchema),
  presence_count: z.number(),
});

export const getGuildWidgetErrorSchema = errorResponseSchema;

export const getGuildsOnboardingDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const userGuildOnboardingResponseSchema = z.object({
  guild_id: snowflakeTypeSchema,
  prompts: z.array(onboardingPromptResponseSchema),
  default_channel_ids: z.array(snowflakeTypeSchema),
  enabled: z.boolean(),
});

export const getGuildsOnboardingErrorSchema = errorResponseSchema;

export const updateGuildOnboardingRequestSchema = z.object({
  prompts: z.array(updateOnboardingPromptRequestSchema).optional().nullable(),
  enabled: z.boolean().optional().nullable(),
  default_channel_ids: z.array(snowflakeTypeSchema).optional().nullable(),
  mode: guildOnboardingModeSchema.optional().nullable(),
});

export const guildOnboardingResponseSchema = z.object({
  guild_id: snowflakeTypeSchema,
  prompts: z.array(onboardingPromptResponseSchema),
  default_channel_ids: z.array(snowflakeTypeSchema),
  enabled: z.boolean(),
});

export const putGuildsOnboardingErrorSchema = errorResponseSchema;

export const getGuildVanityUrlDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildVanityUrlResponseSchema = vanityURLResponseSchema;

export const getGuildVanityUrlErrorSchema = errorResponseSchema;

export const listGuildAuditLogEntriesDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      action_type: z.number().optional(),
      after: snowflakeTypeSchema.optional(),
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
      user_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const listGuildAuditLogEntriesErrorSchema = errorResponseSchema;

export const getGuildWidgetPngDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      style: widgetImageStylesSchema.optional(),
    })
    .optional(),
});

export const getGuildWidgetPngResponseSchema = z.string();

export const getGuildWidgetPngErrorSchema = errorResponseSchema;

export const syncGuildTemplateDataSchema = z.object({
  path: z.object({
    code: z.string(),
    guild_id: snowflakeTypeSchema,
  }),
});

export const syncGuildTemplateErrorSchema = errorResponseSchema;

export const deleteGuildTemplateDataSchema = z.object({
  path: z.object({
    code: z.string(),
    guild_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildTemplateErrorSchema = errorResponseSchema;

export const updateGuildTemplateDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    description: z.string().optional().nullable(),
  }),
  path: z.object({
    code: z.string(),
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateGuildTemplateErrorSchema = errorResponseSchema;

export const listGuildTemplatesDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildTemplatesErrorSchema = errorResponseSchema;

export const createGuildTemplateDataSchema = z.object({
  body: z.object({
    name: z.string(),
    description: z.string().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const createGuildTemplateErrorSchema = errorResponseSchema;

export const getGuildStickerDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    sticker_id: snowflakeTypeSchema,
  }),
});

export const guildStickerResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  tags: z.string(),
  type: z.literal(2),
  format_type: stickerFormatTypesSchema.optional().nullable(),
  description: z.string().optional().nullable(),
  available: z.boolean(),
  guild_id: snowflakeTypeSchema,
  user: userResponseSchema.optional().nullable(),
});

export const getGuildStickerErrorSchema = errorResponseSchema;

export const deleteGuildStickerDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    sticker_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildStickerResponseSchema = z.any();

export const deleteGuildStickerErrorSchema = errorResponseSchema;

export const updateGuildStickerDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    tags: z.string().optional(),
    description: z.string().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    sticker_id: snowflakeTypeSchema,
  }),
});

export const updateGuildStickerResponseSchema = guildStickerResponseSchema;

export const updateGuildStickerErrorSchema = errorResponseSchema;

export const listGuildStickersDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildStickersResponseSchema = z.array(guildStickerResponseSchema);

export const listGuildStickersErrorSchema = errorResponseSchema;

export const createGuildStickerDataSchema = z.object({
  body: z.object({
    name: z.string(),
    tags: z.string(),
    description: z.string().optional().nullable(),
    file: z.string(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const createGuildStickerResponseSchema = guildStickerResponseSchema;

export const createGuildStickerErrorSchema = errorResponseSchema;

export const getGuildWebhooksDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildWebhooksResponseSchema = z
  .array(
    z.union([
      applicationIncomingWebhookResponseSchema,
      channelFollowerWebhookResponseSchema,
      guildIncomingWebhookResponseSchema,
    ]),
  )
  .nullable();

export const getGuildWebhooksErrorSchema = errorResponseSchema;

export const listGuildChannelsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildChannelsResponseSchema = z
  .array(
    z.union([
      guildChannelResponseSchema,
      privateChannelResponseSchema,
      privateGroupChannelResponseSchema,
      threadResponseSchema,
    ]),
  )
  .nullable();

export const listGuildChannelsErrorSchema = errorResponseSchema;

export const createGuildChannelRequestSchema = z.object({
  type: z
    .union([z.literal(0), z.literal(2), z.literal(4), z.literal(5), z.literal(13), z.literal(14), z.literal(15)])
    .optional()
    .nullable(),
  name: z.string(),
  position: z.number().optional().nullable(),
  topic: z.string().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  nsfw: z.boolean().optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  permission_overwrites: z.array(channelPermissionOverwriteRequestSchema).optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  default_auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  default_reaction_emoji: updateDefaultReactionEmojiRequestSchema.optional().nullable(),
  default_thread_rate_limit_per_user: z.number().optional().nullable(),
  default_sort_order: threadSortOrderSchema.optional().nullable(),
  default_forum_layout: forumLayoutSchema.optional().nullable(),
  available_tags: z.array(createOrUpdateThreadTagRequestSchema.nullable()).optional().nullable(),
});

export const createGuildChannelResponseSchema = guildChannelResponseSchema;

export const createGuildChannelErrorSchema = errorResponseSchema;

export const bulkUpdateGuildChannelsDataSchema = z.object({
  body: z.array(
    z.object({
      id: snowflakeTypeSchema.optional(),
      position: z.number().optional().nullable(),
      parent_id: snowflakeTypeSchema.optional().nullable(),
      lock_permissions: z.boolean().optional().nullable(),
    }),
  ),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const bulkUpdateGuildChannelsResponseSchema = z.any();

export const bulkUpdateGuildChannelsErrorSchema = errorResponseSchema;

export const getGuildMemberDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const getGuildMemberResponseSchema = guildMemberResponseSchema;

export const getGuildMemberErrorSchema = errorResponseSchema;

export const addGuildMemberDataSchema = z.object({
  body: z.object({
    nick: z.string().optional().nullable(),
    roles: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
    mute: z.boolean().optional().nullable(),
    deaf: z.boolean().optional().nullable(),
    access_token: z.string(),
    flags: z.number().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const addGuildMemberResponseSchema = z.union([guildMemberResponseSchema, z.any()]);

export const addGuildMemberErrorSchema = errorResponseSchema;

export const deleteGuildMemberDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildMemberResponseSchema = z.any();

export const deleteGuildMemberErrorSchema = errorResponseSchema;

export const updateGuildMemberDataSchema = z.object({
  body: z.object({
    nick: z.string().optional().nullable(),
    roles: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
    mute: z.boolean().optional().nullable(),
    deaf: z.boolean().optional().nullable(),
    channel_id: snowflakeTypeSchema.optional().nullable(),
    communication_disabled_until: z.string().optional().nullable(),
    flags: z.number().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const updateGuildMemberResponseSchema = z.union([guildMemberResponseSchema, z.any()]);

export const updateGuildMemberErrorSchema = errorResponseSchema;

export const listGuildMembersDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: z.number().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listGuildMembersResponseSchema = z.array(guildMemberResponseSchema);

export const listGuildMembersErrorSchema = errorResponseSchema;

export const getGuildPreviewDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildPreviewErrorSchema = errorResponseSchema;

export const listGuildInvitesDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildInvitesErrorSchema = errorResponseSchema;

export const listGuildVoiceRegionsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildVoiceRegionsResponseSchema = z.array(voiceRegionResponseSchema).nullable();

export const listGuildVoiceRegionsErrorSchema = errorResponseSchema;

export const getGuildEmojiDataSchema = z.object({
  path: z.object({
    emoji_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const emojiResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  user: userResponseSchema.optional().nullable(),
  roles: z.array(snowflakeTypeSchema),
  require_colons: z.boolean(),
  managed: z.boolean(),
  animated: z.boolean(),
  available: z.boolean(),
});

export const getGuildEmojiErrorSchema = errorResponseSchema;

export const deleteGuildEmojiDataSchema = z.object({
  path: z.object({
    emoji_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildEmojiResponseSchema = z.any();

export const deleteGuildEmojiErrorSchema = errorResponseSchema;

export const updateGuildEmojiDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    roles: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
  }),
  path: z.object({
    emoji_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateGuildEmojiResponseSchema = emojiResponseSchema;

export const updateGuildEmojiErrorSchema = errorResponseSchema;

export const listGuildEmojisDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildEmojisResponseSchema = z.array(emojiResponseSchema).nullable();

export const listGuildEmojisErrorSchema = errorResponseSchema;

export const createGuildEmojiDataSchema = z.object({
  body: z.object({
    name: z.string(),
    image: z.string(),
    roles: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const createGuildEmojiResponseSchema = emojiResponseSchema;

export const createGuildEmojiErrorSchema = errorResponseSchema;

export const getGuildWidgetSettingsDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildWidgetSettingsResponseSchema = widgetSettingsResponseSchema;

export const getGuildWidgetSettingsErrorSchema = errorResponseSchema;

export const updateGuildWidgetSettingsDataSchema = z.object({
  body: z.object({
    channel_id: snowflakeTypeSchema.optional().nullable(),
    enabled: z.boolean().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateGuildWidgetSettingsResponseSchema = widgetSettingsResponseSchema;

export const updateGuildWidgetSettingsErrorSchema = errorResponseSchema;

export const deleteGuildRoleDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    role_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildRoleResponseSchema = z.any();

export const deleteGuildRoleErrorSchema = errorResponseSchema;

export const updateGuildRoleDataSchema = z.object({
  body: z.object({
    name: z.string().optional().nullable(),
    permissions: z.number().optional().nullable(),
    color: z.number().optional().nullable(),
    hoist: z.boolean().optional().nullable(),
    mentionable: z.boolean().optional().nullable(),
    icon: z.string().optional().nullable(),
    unicode_emoji: z.string().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    role_id: snowflakeTypeSchema,
  }),
});

export const updateGuildRoleResponseSchema = guildRoleResponseSchema;

export const updateGuildRoleErrorSchema = errorResponseSchema;

export const listGuildRolesDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const listGuildRolesResponseSchema = z.array(guildRoleResponseSchema);

export const listGuildRolesErrorSchema = errorResponseSchema;

export const createGuildRoleDataSchema = z.object({
  body: z.object({
    name: z.string().optional().nullable(),
    permissions: z.number().optional().nullable(),
    color: z.number().optional().nullable(),
    hoist: z.boolean().optional().nullable(),
    mentionable: z.boolean().optional().nullable(),
    icon: z.string().optional().nullable(),
    unicode_emoji: z.string().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const createGuildRoleResponseSchema = guildRoleResponseSchema;

export const createGuildRoleErrorSchema = errorResponseSchema;

export const bulkUpdateGuildRolesDataSchema = z.object({
  body: z.array(
    z.object({
      id: snowflakeTypeSchema.optional().nullable(),
      position: z.number().optional().nullable(),
    }),
  ),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const bulkUpdateGuildRolesResponseSchema = z.array(guildRoleResponseSchema);

export const bulkUpdateGuildRolesErrorSchema = errorResponseSchema;

export const previewPruneGuildDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      days: z.number().optional(),
      include_roles: z.union([z.string(), z.array(snowflakeTypeSchema.nullable())]).optional(),
    })
    .optional(),
});

export const previewPruneGuildResponseSchema = guildPruneResponseSchema;

export const previewPruneGuildErrorSchema = errorResponseSchema;

export const pruneGuildDataSchema = z.object({
  body: z.object({
    days: z.number().optional().nullable(),
    compute_prune_count: z.boolean().optional().nullable(),
    include_roles: z
      .union([z.string(), z.array(snowflakeTypeSchema.nullable())])
      .optional()
      .nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const pruneGuildResponseSchema = guildPruneResponseSchema;

export const pruneGuildErrorSchema = errorResponseSchema;

export const getGuildBanDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const guildBanResponseSchema = z.object({
  user: userResponseSchema,
  reason: z.string().optional().nullable(),
});

export const getGuildBanErrorSchema = errorResponseSchema;

export const banUserFromGuildDataSchema = z.object({
  body: z.object({
    delete_message_seconds: z.number().optional().nullable(),
    delete_message_days: z.number().optional().nullable(),
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const banUserFromGuildResponseSchema = z.any();

export const banUserFromGuildErrorSchema = errorResponseSchema;

export const unbanUserFromGuildDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
    user_id: snowflakeTypeSchema,
  }),
});

export const unbanUserFromGuildResponseSchema = z.any();

export const unbanUserFromGuildErrorSchema = errorResponseSchema;

export const listGuildBansDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      after: snowflakeTypeSchema.optional(),
      before: snowflakeTypeSchema.optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listGuildBansResponseSchema = z.array(guildBanResponseSchema).nullable();

export const listGuildBansErrorSchema = errorResponseSchema;

export const setGuildMfaLevelDataSchema = z.object({
  body: z.object({
    level: guildMFALevelSchema,
  }),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const setGuildMfaLevelResponseSchema = guildMFALevelResponseSchema;

export const setGuildMfaLevelErrorSchema = errorResponseSchema;

export const getStageInstanceDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const getStageInstanceResponseSchema = stageInstanceResponseSchema;

export const getStageInstanceErrorSchema = errorResponseSchema;

export const deleteStageInstanceDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const deleteStageInstanceResponseSchema = z.any();

export const deleteStageInstanceErrorSchema = errorResponseSchema;

export const updateStageInstanceDataSchema = z.object({
  body: z.object({
    topic: z.string().optional(),
    privacy_level: stageInstancesPrivacyLevelsSchema.optional(),
  }),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const updateStageInstanceResponseSchema = stageInstanceResponseSchema;

export const updateStageInstanceErrorSchema = errorResponseSchema;

export const getApplicationDataSchema = z.object({
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const getApplicationErrorSchema = errorResponseSchema;

export const updateApplicationDataSchema = z.object({
  body: applicationFormPartialSchema,
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const updateApplicationErrorSchema = errorResponseSchema;

export const getWebhookByTokenDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
});

export const getWebhookByTokenResponseSchema = z.union([
  applicationIncomingWebhookResponseSchema,
  channelFollowerWebhookResponseSchema,
  guildIncomingWebhookResponseSchema,
]);

export const getWebhookByTokenErrorSchema = errorResponseSchema;

export const executeWebhookErrorSchema = errorResponseSchema;

export const deleteWebhookByTokenDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
});

export const deleteWebhookByTokenResponseSchema = z.any();

export const deleteWebhookByTokenErrorSchema = errorResponseSchema;

export const updateWebhookByTokenDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    avatar: z.string().optional().nullable(),
  }),
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
});

export const updateWebhookByTokenResponseSchema = z.union([
  applicationIncomingWebhookResponseSchema,
  channelFollowerWebhookResponseSchema,
  guildIncomingWebhookResponseSchema,
]);

export const updateWebhookByTokenErrorSchema = errorResponseSchema;

export const getStickerDataSchema = z.object({
  path: z.object({
    sticker_id: snowflakeTypeSchema,
  }),
});

export const getStickerResponseSchema = z.union([guildStickerResponseSchema, standardStickerResponseSchema]);

export const getStickerErrorSchema = errorResponseSchema;

export const getWebhookDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
  }),
});

export const getWebhookResponseSchema = z.union([
  applicationIncomingWebhookResponseSchema,
  channelFollowerWebhookResponseSchema,
  guildIncomingWebhookResponseSchema,
]);

export const getWebhookErrorSchema = errorResponseSchema;

export const deleteWebhookDataSchema = z.object({
  path: z.object({
    webhook_id: snowflakeTypeSchema,
  }),
});

export const deleteWebhookResponseSchema = z.any();

export const deleteWebhookErrorSchema = errorResponseSchema;

export const updateWebhookDataSchema = z.object({
  body: z.object({
    name: z.string().optional(),
    avatar: z.string().optional().nullable(),
    channel_id: snowflakeTypeSchema.optional().nullable(),
  }),
  path: z.object({
    webhook_id: snowflakeTypeSchema,
  }),
});

export const updateWebhookResponseSchema = z.union([
  applicationIncomingWebhookResponseSchema,
  channelFollowerWebhookResponseSchema,
  guildIncomingWebhookResponseSchema,
]);

export const updateWebhookErrorSchema = errorResponseSchema;

export const getChannelDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const getChannelResponseSchema = z.union([
  guildChannelResponseSchema,
  privateChannelResponseSchema,
  privateGroupChannelResponseSchema,
  threadResponseSchema,
]);

export const getChannelErrorSchema = errorResponseSchema;

export const deleteChannelDataSchema = z.object({
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const deleteChannelResponseSchema = z.union([
  guildChannelResponseSchema,
  privateChannelResponseSchema,
  privateGroupChannelResponseSchema,
  threadResponseSchema,
]);

export const deleteChannelErrorSchema = errorResponseSchema;

export const updateGuildChannelRequestPartialSchema = z.object({
  type: z
    .union([z.literal(0), z.literal(2), z.literal(4), z.literal(5), z.literal(13), z.literal(14), z.literal(15)])
    .optional()
    .nullable(),
  name: z.string().optional(),
  position: z.number().optional().nullable(),
  topic: z.string().optional().nullable(),
  bitrate: z.number().optional().nullable(),
  user_limit: z.number().optional().nullable(),
  nsfw: z.boolean().optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  parent_id: snowflakeTypeSchema.optional().nullable(),
  permission_overwrites: z.array(channelPermissionOverwriteRequestSchema).optional().nullable(),
  rtc_region: z.string().optional().nullable(),
  video_quality_mode: videoQualityModesSchema.optional().nullable(),
  default_auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  default_reaction_emoji: updateDefaultReactionEmojiRequestSchema.optional().nullable(),
  default_thread_rate_limit_per_user: z.number().optional().nullable(),
  default_sort_order: threadSortOrderSchema.optional().nullable(),
  default_forum_layout: forumLayoutSchema.optional().nullable(),
  flags: z.number().optional().nullable(),
  available_tags: z.array(updateThreadTagRequestSchema).optional().nullable(),
});

export const updateChannelResponseSchema = z.union([
  guildChannelResponseSchema,
  privateChannelResponseSchema,
  privateGroupChannelResponseSchema,
  threadResponseSchema,
]);

export const updateChannelErrorSchema = errorResponseSchema;

export const inviteResolveDataSchema = z.object({
  path: z.object({
    code: z.string(),
  }),
  query: z
    .object({
      guild_scheduled_event_id: snowflakeTypeSchema.optional(),
      with_counts: z.boolean().optional(),
    })
    .optional(),
});

export const inviteResolveErrorSchema = errorResponseSchema;

export const inviteRevokeDataSchema = z.object({
  path: z.object({
    code: z.string(),
  }),
});

export const inviteRevokeErrorSchema = errorResponseSchema;

export const getGuildDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
  query: z
    .object({
      with_counts: z.boolean().optional(),
    })
    .optional(),
});

export const guildWithCountsResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  home_header: z.string().optional().nullable(),
  splash: z.string().optional().nullable(),
  discovery_splash: z.string().optional().nullable(),
  features: z.array(guildFeaturesSchema),
  banner: z.string().optional().nullable(),
  owner_id: snowflakeTypeSchema,
  application_id: snowflakeTypeSchema.optional().nullable(),
  region: z.string(),
  afk_channel_id: snowflakeTypeSchema.optional().nullable(),
  afk_timeout: afkTimeoutsSchema,
  system_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_flags: z.number(),
  widget_enabled: z.boolean(),
  widget_channel_id: snowflakeTypeSchema.optional().nullable(),
  verification_level: verificationLevelsSchema,
  roles: z.array(guildRoleResponseSchema),
  default_message_notifications: userNotificationSettingsSchema,
  mfa_level: guildMFALevelSchema,
  explicit_content_filter: guildExplicitContentFilterTypesSchema,
  max_presences: z.number().optional().nullable(),
  max_members: z.number().optional().nullable(),
  max_stage_video_channel_users: z.number().optional().nullable(),
  max_video_channel_users: z.number().optional().nullable(),
  vanity_url_code: z.string().optional().nullable(),
  premium_tier: premiumGuildTiersSchema,
  premium_subscription_count: z.number(),
  preferred_locale: availableLocalesEnumSchema,
  rules_channel_id: snowflakeTypeSchema.optional().nullable(),
  safety_alerts_channel_id: snowflakeTypeSchema.optional().nullable(),
  public_updates_channel_id: snowflakeTypeSchema.optional().nullable(),
  premium_progress_bar_enabled: z.boolean(),
  nsfw: z.boolean(),
  nsfw_level: guildNSFWContentLevelSchema,
  emojis: z.array(emojiResponseSchema),
  stickers: z.array(guildStickerResponseSchema),
  approximate_member_count: z.number().optional().nullable(),
  approximate_presence_count: z.number().optional().nullable(),
});

export const getGuildErrorSchema = errorResponseSchema;

export const deleteGuildDataSchema = z.object({
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const deleteGuildResponseSchema = z.any();

export const deleteGuildErrorSchema = errorResponseSchema;

export const updateGuildDataSchema = z.object({
  body: guildPatchRequestPartialSchema,
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const guildResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  home_header: z.string().optional().nullable(),
  splash: z.string().optional().nullable(),
  discovery_splash: z.string().optional().nullable(),
  features: z.array(guildFeaturesSchema),
  banner: z.string().optional().nullable(),
  owner_id: snowflakeTypeSchema,
  application_id: snowflakeTypeSchema.optional().nullable(),
  region: z.string(),
  afk_channel_id: snowflakeTypeSchema.optional().nullable(),
  afk_timeout: afkTimeoutsSchema,
  system_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_flags: z.number(),
  widget_enabled: z.boolean(),
  widget_channel_id: snowflakeTypeSchema.optional().nullable(),
  verification_level: verificationLevelsSchema,
  roles: z.array(guildRoleResponseSchema),
  default_message_notifications: userNotificationSettingsSchema,
  mfa_level: guildMFALevelSchema,
  explicit_content_filter: guildExplicitContentFilterTypesSchema,
  max_presences: z.number().optional().nullable(),
  max_members: z.number().optional().nullable(),
  max_stage_video_channel_users: z.number().optional().nullable(),
  max_video_channel_users: z.number().optional().nullable(),
  vanity_url_code: z.string().optional().nullable(),
  premium_tier: premiumGuildTiersSchema,
  premium_subscription_count: z.number(),
  preferred_locale: availableLocalesEnumSchema,
  rules_channel_id: snowflakeTypeSchema.optional().nullable(),
  safety_alerts_channel_id: snowflakeTypeSchema.optional().nullable(),
  public_updates_channel_id: snowflakeTypeSchema.optional().nullable(),
  premium_progress_bar_enabled: z.boolean(),
  nsfw: z.boolean(),
  nsfw_level: guildNSFWContentLevelSchema,
  emojis: z.array(emojiResponseSchema),
  stickers: z.array(guildStickerResponseSchema),
});

export const updateGuildErrorSchema = errorResponseSchema;

export const getUserDataSchema = z.object({
  path: z.object({
    user_id: snowflakeTypeSchema,
  }),
});

export const getUserResponseSchema = userResponseSchema;

export const getUserErrorSchema = errorResponseSchema;

export const roleSelectSchema = z.object({
  type: z.literal(6),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  default_values: z.array(roleSelectDefaultValueSchema).optional().nullable(),
});

export const userSelectSchema = z.object({
  type: z.literal(5),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  default_values: z.array(userSelectDefaultValueSchema).optional().nullable(),
});

export const applicationCommandSubcommandGroupOptionResponseSchema = z.object({
  type: z.literal(2),
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  required: z.boolean().optional().nullable(),
  options: z.array(applicationCommandSubcommandOptionResponseSchema).optional().nullable(),
});

export const applicationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string(),
  type: applicationTypesSchema.optional().nullable(),
  cover_image: z.string().optional().nullable(),
  primary_sku_id: snowflakeTypeSchema.optional().nullable(),
  bot: userResponseSchema.optional().nullable(),
  slug: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  rpc_origins: z.array(z.string().nullable()).optional().nullable(),
  bot_public: z.boolean().optional().nullable(),
  bot_require_code_grant: z.boolean().optional().nullable(),
  terms_of_service_url: z.string().optional().nullable(),
  privacy_policy_url: z.string().optional().nullable(),
  custom_install_url: z.string().optional().nullable(),
  install_params: applicationOAuth2ParamsResponseSchema.optional().nullable(),
  verify_key: z.string(),
  flags: z.number(),
  max_participants: z.number().optional().nullable(),
  tags: z.array(z.string()).optional().nullable(),
});

export const richEmbedSchema = z.object({
  type: z.string().optional().nullable(),
  url: z.string().optional().nullable(),
  title: z.string().optional().nullable(),
  color: z.number().optional().nullable(),
  timestamp: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  author: richEmbedAuthorSchema.optional().nullable(),
  image: richEmbedImageSchema.optional().nullable(),
  thumbnail: richEmbedThumbnailSchema.optional().nullable(),
  footer: richEmbedFooterSchema.optional().nullable(),
  fields: z.array(richEmbedFieldSchema).optional().nullable(),
  provider: richEmbedProviderSchema.optional().nullable(),
  video: richEmbedVideoSchema.optional().nullable(),
});

export const basicApplicationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string(),
  type: applicationTypesSchema.optional().nullable(),
  cover_image: z.string().optional().nullable(),
  primary_sku_id: snowflakeTypeSchema.optional().nullable(),
  bot: userResponseSchema.optional().nullable(),
});

export const messageAttachmentResponseSchema = z.object({
  id: snowflakeTypeSchema,
  filename: z.string(),
  size: z.number(),
  url: z.string(),
  proxy_url: z.string(),
  width: z.number().optional().nullable(),
  height: z.number().optional().nullable(),
  duration_secs: z.number().optional().nullable(),
  waveform: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  content_type: z.string().optional().nullable(),
  ephemeral: z.boolean().optional().nullable(),
  title: z.string().optional().nullable(),
  application: applicationResponseSchema.optional().nullable(),
  clip_created_at: z.string().optional().nullable(),
  clip_participants: z.array(userResponseSchema).optional().nullable(),
});

export const messageComponentActionRowResponseSchema = z.object({
  type: z.literal(1),
  components: z
    .array(
      z.union([
        messageComponentButtonResponseSchema,
        messageComponentChannelSelectResponseSchema,
        messageComponentInputTextResponseSchema,
        messageComponentMentionableSelectResponseSchema,
        messageComponentRoleSelectResponseSchema,
        messageComponentStringSelectResponseSchema,
        messageComponentUserSelectResponseSchema,
      ]),
    )
    .optional()
    .nullable(),
});

export const messageInteractionResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: interactionTypesSchema,
  name: z.string(),
  user: userResponseSchema.optional().nullable(),
  name_localized: z.string().optional().nullable(),
});

export const purchaseNotificationResponseSchema = z.object({
  type: purchaseTypeSchema,
  guild_product_purchase: guildProductPurchaseResponseSchema.optional().nullable(),
});

export const resolvedObjectsResponseSchema = z.object({
  users: z.record(userResponseSchema),
  members: z.record(guildMemberResponseSchema),
  channels: z.record(
    z.union([
      guildChannelResponseSchema,
      privateChannelResponseSchema,
      privateGroupChannelResponseSchema,
      threadResponseSchema,
    ]),
  ),
  roles: z.record(guildRoleResponseSchema),
});

export const channelSelectDefaultValueSchema = z.object({
  type: snowflakeSelectDefaultValueTypesSchema,
  id: snowflakeTypeSchema,
});

export const quarantineUserActionSchema = z.object({
  type: z.literal(4),
  metadata: quarantineUserActionMetadataSchema.optional().nullable(),
});

export const userCommunicationDisabledActionSchema = z.object({
  type: z.literal(3),
  metadata: userCommunicationDisabledActionMetadataSchema,
});

export const defaultKeywordListUpsertRequestPartialSchema = z.object({
  name: z.string().optional(),
  event_type: automodEventTypeSchema.optional(),
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(4).optional(),
  trigger_metadata: defaultKeywordListTriggerMetadataSchema.optional(),
});

export const integrationApplicationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string(),
  type: applicationTypesSchema.optional().nullable(),
  cover_image: z.string().optional().nullable(),
  primary_sku_id: snowflakeTypeSchema.optional().nullable(),
  bot: userResponseSchema.optional().nullable(),
});

export const applicationCommandResponseSchema = z.object({
  id: snowflakeTypeSchema,
  application_id: snowflakeTypeSchema,
  version: snowflakeTypeSchema,
  default_member_permissions: z.string().optional().nullable(),
  type: applicationCommandTypeSchema,
  name: z.string(),
  name_localized: z.string().optional().nullable(),
  name_localizations: z.record(z.string()).optional().nullable(),
  description: z.string(),
  description_localized: z.string().optional().nullable(),
  description_localizations: z.record(z.string()).optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  dm_permission: z.boolean().optional().nullable(),
  options: z
    .array(
      z.union([
        applicationCommandAttachmentOptionResponseSchema,
        applicationCommandBooleanOptionResponseSchema,
        applicationCommandChannelOptionResponseSchema,
        applicationCommandIntegerOptionResponseSchema,
        applicationCommandMentionableOptionResponseSchema,
        applicationCommandNumberOptionResponseSchema,
        applicationCommandRoleOptionResponseSchema,
        applicationCommandStringOptionResponseSchema,
        applicationCommandSubcommandGroupOptionResponseSchema,
        applicationCommandSubcommandOptionResponseSchema,
        applicationCommandUserOptionResponseSchema,
      ]),
    )
    .optional()
    .nullable(),
  nsfw: z.boolean().optional().nullable(),
});

export const newMemberActionResponseSchema = z.object({
  channel_id: snowflakeTypeSchema,
  action_type: newMemberActionTypeSchema,
  title: z.string(),
  description: z.string(),
  emoji: settingsEmojiResponseSchema.optional().nullable(),
  icon: z.string().optional().nullable(),
});

export const inviteStageInstanceResponseSchema = z.object({
  topic: z.string(),
  participant_count: z.number().optional().nullable(),
  speaker_count: z.number().optional().nullable(),
  members: z.array(guildMemberResponseSchema).optional().nullable(),
});

export const inviteApplicationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string(),
  type: applicationTypesSchema.optional().nullable(),
  cover_image: z.string().optional().nullable(),
  primary_sku_id: snowflakeTypeSchema.optional().nullable(),
  bot: userResponseSchema.optional().nullable(),
  slug: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  rpc_origins: z.array(z.string().nullable()).optional().nullable(),
  bot_public: z.boolean().optional().nullable(),
  bot_require_code_grant: z.boolean().optional().nullable(),
  terms_of_service_url: z.string().optional().nullable(),
  privacy_policy_url: z.string().optional().nullable(),
  custom_install_url: z.string().optional().nullable(),
  install_params: applicationOAuth2ParamsResponseSchema.optional().nullable(),
  verify_key: z.string(),
  flags: z.number(),
  max_participants: z.number().optional().nullable(),
  tags: z.array(z.string()).optional().nullable(),
});

export const scheduledEventResponseSchema = z.object({
  id: snowflakeTypeSchema,
  guild_id: snowflakeTypeSchema,
  name: z.string(),
  description: z.string().optional().nullable(),
  channel_id: snowflakeTypeSchema.optional().nullable(),
  creator_id: snowflakeTypeSchema.optional().nullable(),
  creator: userResponseSchema.optional().nullable(),
  image: z.string().optional().nullable(),
  scheduled_start_time: z.string(),
  scheduled_end_time: z.string().optional().nullable(),
  status: guildScheduledEventStatusesSchema,
  entity_type: guildScheduledEventEntityTypesSchema,
  entity_id: snowflakeTypeSchema.optional().nullable(),
  user_count: z.number().optional().nullable(),
  privacy_level: guildScheduledEventPrivacyLevelsSchema,
  user_rsvp: scheduledEventUserResponseSchema.optional().nullable(),
});

export const guildPreviewResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  home_header: z.string().optional().nullable(),
  splash: z.string().optional().nullable(),
  discovery_splash: z.string().optional().nullable(),
  features: z.array(guildFeaturesSchema),
  approximate_member_count: z.number(),
  approximate_presence_count: z.number(),
  emojis: z.array(emojiResponseSchema),
  stickers: z.array(guildStickerResponseSchema),
});

export const guildTemplateSnapshotResponseSchema = z.object({
  name: z.string(),
  description: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
  verification_level: verificationLevelsSchema,
  default_message_notifications: userNotificationSettingsSchema,
  explicit_content_filter: guildExplicitContentFilterTypesSchema,
  preferred_locale: availableLocalesEnumSchema,
  afk_channel_id: snowflakeTypeSchema.optional().nullable(),
  afk_timeout: afkTimeoutsSchema,
  system_channel_id: snowflakeTypeSchema.optional().nullable(),
  system_channel_flags: z.number(),
  roles: z.array(guildTemplateRoleResponseSchema),
  channels: z.array(guildTemplateChannelResponseSchema),
});

export const channelSelectSchema = z.object({
  type: z.literal(8),
  custom_id: z.string(),
  placeholder: z.string().optional().nullable(),
  min_values: z.number().optional().nullable(),
  max_values: z.number().optional().nullable(),
  disabled: z.boolean().optional().nullable(),
  default_values: z.array(channelSelectDefaultValueSchema).optional().nullable(),
  channel_types: z.array(channelTypesSchema).optional().nullable(),
});

export const actionRowSchema = z.object({
  type: z.literal(1),
  components: z.array(
    z.union([
      buttonSchema,
      channelSelectSchema,
      inputTextSchema,
      mentionableSelectSchema,
      roleSelectSchema,
      stringSelectSchema,
      userSelectSchema,
    ]),
  ),
});

export const incomingWebhookUpdateForInteractionCallbackRequestPartialSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
  flags: z.number().optional().nullable(),
});

export const incomingWebhookUpdateRequestPartialSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
  flags: z.number().optional().nullable(),
});

export const keywordUpsertRequestSchema = z.object({
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(1),
  trigger_metadata: keywordTriggerMetadataSchema.optional().nullable(),
});

export const keywordUpsertRequestPartialSchema = z.object({
  name: z.string().optional(),
  event_type: automodEventTypeSchema.optional(),
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(1).optional(),
  trigger_metadata: keywordTriggerMetadataSchema.optional().nullable(),
});

export const mLSpamUpsertRequestSchema = z.object({
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(3),
  trigger_metadata: mLSpamTriggerMetadataSchema.optional().nullable(),
});

export const mLSpamUpsertRequestPartialSchema = z.object({
  name: z.string().optional(),
  event_type: automodEventTypeSchema.optional(),
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(3).optional(),
  trigger_metadata: mLSpamTriggerMetadataSchema.optional().nullable(),
});

export const mentionSpamUpsertRequestSchema = z.object({
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(5),
  trigger_metadata: mentionSpamTriggerMetadataSchema.optional().nullable(),
});

export const mentionSpamUpsertRequestPartialSchema = z.object({
  name: z.string().optional(),
  event_type: automodEventTypeSchema.optional(),
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(5).optional(),
  trigger_metadata: mentionSpamTriggerMetadataSchema.optional().nullable(),
});

export const messageCreateRequestSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  sticker_ids: z.array(snowflakeTypeSchema).optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  flags: z.number().optional().nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
  message_reference: replyMessageReferenceRequestSchema.optional().nullable(),
  nonce: z.union([z.number(), z.string()]).optional().nullable(),
  tts: z.boolean().optional().nullable(),
});

export const messageEditRequestPartialSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  flags: z.number().optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  sticker_ids: z.array(snowflakeTypeSchema.nullable()).optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
});

export const basicMessageResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: messageTypeSchema,
  content: z.string(),
  channel_id: snowflakeTypeSchema,
  author: userResponseSchema,
  attachments: z.array(messageAttachmentResponseSchema),
  embeds: z.array(messageEmbedResponseSchema),
  mentions: z.array(userResponseSchema),
  mention_roles: z.array(snowflakeTypeSchema),
  pinned: z.boolean(),
  mention_everyone: z.boolean(),
  tts: z.boolean(),
  timestamp: z.string(),
  edited_timestamp: z.string().optional().nullable(),
  flags: z.number(),
  components: z.array(
    z.union([
      messageComponentActionRowResponseSchema,
      messageComponentButtonResponseSchema,
      messageComponentChannelSelectResponseSchema,
      messageComponentInputTextResponseSchema,
      messageComponentMentionableSelectResponseSchema,
      messageComponentRoleSelectResponseSchema,
      messageComponentStringSelectResponseSchema,
      messageComponentUserSelectResponseSchema,
    ]),
  ),
  activity: messageActivityResponseSchema.optional().nullable(),
  application: basicApplicationResponseSchema.optional().nullable(),
  application_id: snowflakeTypeSchema.optional().nullable(),
  interaction: messageInteractionResponseSchema.optional().nullable(),
  nonce: z.union([z.number(), z.string()]).optional().nullable(),
  webhook_id: snowflakeTypeSchema.optional().nullable(),
  message_reference: messageReferenceResponseSchema.optional().nullable(),
  thread: threadResponseSchema.optional().nullable(),
  mention_channels: z.array(messageMentionChannelResponseSchema.nullable()).optional().nullable(),
  stickers: z
    .array(z.union([guildStickerResponseSchema, standardStickerResponseSchema]))
    .optional()
    .nullable(),
  sticker_items: z.array(messageStickerItemResponseSchema).optional().nullable(),
  role_subscription_data: messageRoleSubscriptionDataResponseSchema.optional().nullable(),
  purchase_notification: purchaseNotificationResponseSchema.optional().nullable(),
  position: z.number().optional().nullable(),
  resolved: resolvedObjectsResponseSchema.optional().nullable(),
});

export const modalInteractionCallbackDataSchema = z.object({
  custom_id: z.string(),
  title: z.string(),
  components: z.array(z.union([actionRowSchema, inputTextSchema])),
});

export const modalInteractionCallbackRequestSchema = z.object({
  type: z.literal(9),
  data: modalInteractionCallbackDataSchema,
});

export const oAuth2GetAuthorizationResponseSchema = z.object({
  application: applicationResponseSchema,
  expires: z.string(),
  scopes: z.array(oAuth2ScopesSchema),
  user: userResponseSchema.optional().nullable(),
});

export const teamResponseSchema = z.object({
  id: snowflakeTypeSchema,
  icon: z.string().optional().nullable(),
  name: z.string(),
  owner_user_id: snowflakeTypeSchema,
  members: z.array(teamMemberResponseSchema),
});

export const webhookSlackEmbedSchema = z.object({
  title: z.string().optional().nullable(),
  title_link: z.string().optional().nullable(),
  text: z.string().optional().nullable(),
  color: z.string().optional().nullable(),
  ts: z.number().optional().nullable(),
  pretext: z.string().optional().nullable(),
  footer: z.string().optional().nullable(),
  footer_icon: z.string().optional().nullable(),
  author_name: z.string().optional().nullable(),
  author_link: z.string().optional().nullable(),
  author_icon: z.string().optional().nullable(),
  image_url: z.string().optional().nullable(),
  thumb_url: z.string().optional().nullable(),
  fields: z.array(webhookSlackEmbedFieldSchema).optional().nullable(),
});

export const updateMessageInteractionCallbackRequestSchema = z.object({
  type: z.union([z.literal(6), z.literal(7)]),
  data: incomingWebhookUpdateForInteractionCallbackRequestPartialSchema.optional().nullable(),
});

export const privateApplicationResponseSchema = z.object({
  id: snowflakeTypeSchema,
  name: z.string(),
  icon: z.string().optional().nullable(),
  description: z.string(),
  type: applicationTypesSchema.optional().nullable(),
  cover_image: z.string().optional().nullable(),
  primary_sku_id: snowflakeTypeSchema.optional().nullable(),
  bot: userResponseSchema.optional().nullable(),
  slug: z.string().optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  rpc_origins: z.array(z.string().nullable()).optional().nullable(),
  bot_public: z.boolean().optional().nullable(),
  bot_require_code_grant: z.boolean().optional().nullable(),
  terms_of_service_url: z.string().optional().nullable(),
  privacy_policy_url: z.string().optional().nullable(),
  custom_install_url: z.string().optional().nullable(),
  install_params: applicationOAuth2ParamsResponseSchema.optional().nullable(),
  verify_key: z.string(),
  flags: z.number(),
  max_participants: z.number().optional().nullable(),
  tags: z.array(z.string()).optional().nullable(),
  redirect_uris: z.array(z.string().nullable()),
  interactions_endpoint_url: z.string().optional().nullable(),
  role_connections_verification_url: z.string().optional().nullable(),
  owner: userResponseSchema,
  approximate_guild_count: z.number().optional().nullable(),
  team: teamResponseSchema.optional().nullable(),
});

export const listMyConnectionsResponseSchema = z.array(connectedAccountResponseSchema).nullable();

export const getMyApplicationResponseSchema = privateApplicationResponseSchema;

export const updateMyApplicationDataSchema = z.object({
  body: applicationFormPartialSchema,
});

export const updateMyApplicationResponseSchema = privateApplicationResponseSchema;

export const getBotGatewayResponseSchema = gatewayBotResponseSchema;

export const getMyOauth2AuthorizationResponseSchema = oAuth2GetAuthorizationResponseSchema;

export const createStageInstanceResponseSchema = stageInstanceResponseSchema;

export const listStickerPacksResponseSchema = stickerPackCollectionResponseSchema;

export const createGuildDataSchema = z.object({
  body: guildCreateRequestSchema,
});

export const createGuildResponseSchema = guildResponseSchema;

export const setGuildApplicationCommandPermissionsDataSchema = z.object({
  body: z.object({
    permissions: z.array(applicationCommandPermissionSchema).optional().nullable(),
  }),
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateApplicationRoleConnectionsMetadataDataSchema = z.object({
  body: z.array(applicationRoleConnectionsMetadataItemRequestSchema).nullable(),
  path: z.object({
    application_id: snowflakeTypeSchema,
  }),
});

export const getGuildApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const updateGuildApplicationCommandDataSchema = z.object({
  body: applicationCommandPatchRequestPartialSchema,
  path: z.object({
    application_id: snowflakeTypeSchema,
    command_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const updateGuildApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const listGuildApplicationCommandsResponseSchema = z.array(applicationCommandResponseSchema).nullable();

export const bulkSetGuildApplicationCommandsResponseSchema = z.array(applicationCommandResponseSchema).nullable();

export const createGuildApplicationCommandDataSchema = z.object({
  body: applicationCommandCreateRequestSchema,
  path: z.object({
    application_id: snowflakeTypeSchema,
    guild_id: snowflakeTypeSchema,
  }),
});

export const createGuildApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const messageResponseSchema = z.object({
  id: snowflakeTypeSchema,
  type: messageTypeSchema,
  content: z.string(),
  channel_id: snowflakeTypeSchema,
  author: userResponseSchema,
  attachments: z.array(messageAttachmentResponseSchema),
  embeds: z.array(messageEmbedResponseSchema),
  mentions: z.array(userResponseSchema),
  mention_roles: z.array(snowflakeTypeSchema),
  pinned: z.boolean(),
  mention_everyone: z.boolean(),
  tts: z.boolean(),
  timestamp: z.string(),
  edited_timestamp: z.string().optional().nullable(),
  flags: z.number(),
  components: z.array(
    z.union([
      messageComponentActionRowResponseSchema,
      messageComponentButtonResponseSchema,
      messageComponentChannelSelectResponseSchema,
      messageComponentInputTextResponseSchema,
      messageComponentMentionableSelectResponseSchema,
      messageComponentRoleSelectResponseSchema,
      messageComponentStringSelectResponseSchema,
      messageComponentUserSelectResponseSchema,
    ]),
  ),
  activity: messageActivityResponseSchema.optional().nullable(),
  application: basicApplicationResponseSchema.optional().nullable(),
  application_id: snowflakeTypeSchema.optional().nullable(),
  interaction: messageInteractionResponseSchema.optional().nullable(),
  nonce: z.union([z.number(), z.string()]).optional().nullable(),
  webhook_id: snowflakeTypeSchema.optional().nullable(),
  message_reference: messageReferenceResponseSchema.optional().nullable(),
  thread: threadResponseSchema.optional().nullable(),
  mention_channels: z.array(messageMentionChannelResponseSchema.nullable()).optional().nullable(),
  stickers: z
    .array(z.union([guildStickerResponseSchema, standardStickerResponseSchema]))
    .optional()
    .nullable(),
  sticker_items: z.array(messageStickerItemResponseSchema).optional().nullable(),
  role_subscription_data: messageRoleSubscriptionDataResponseSchema.optional().nullable(),
  purchase_notification: purchaseNotificationResponseSchema.optional().nullable(),
  position: z.number().optional().nullable(),
  resolved: resolvedObjectsResponseSchema.optional().nullable(),
  reactions: z.array(messageReactionResponseSchema).optional().nullable(),
  referenced_message: basicMessageResponseSchema.optional().nullable(),
});

export const getOriginalWebhookMessageResponseSchema = messageResponseSchema;

export const updateOriginalWebhookMessageDataSchema = z.object({
  body: incomingWebhookUpdateRequestPartialSchema,
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const updateOriginalWebhookMessageResponseSchema = messageResponseSchema;

export const getAutoModerationRuleResponseSchema = z.union([
  defaultKeywordRuleResponseSchema,
  keywordRuleResponseSchema,
  mLSpamRuleResponseSchema,
  mentionSpamRuleResponseSchema,
  spamLinkRuleResponseSchema,
]);

export const updateAutoModerationRuleDataSchema = z.object({
  body: z.union([
    defaultKeywordListUpsertRequestPartialSchema,
    keywordUpsertRequestPartialSchema,
    mLSpamUpsertRequestPartialSchema,
    mentionSpamUpsertRequestPartialSchema,
  ]),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    rule_id: snowflakeTypeSchema,
  }),
});

export const updateAutoModerationRuleResponseSchema = z.union([
  defaultKeywordRuleResponseSchema,
  keywordRuleResponseSchema,
  mLSpamRuleResponseSchema,
  mentionSpamRuleResponseSchema,
  spamLinkRuleResponseSchema,
]);

export const listAutoModerationRulesResponseSchema = z
  .array(
    z
      .union([
        defaultKeywordRuleResponseSchema,
        keywordRuleResponseSchema,
        mLSpamRuleResponseSchema,
        mentionSpamRuleResponseSchema,
        spamLinkRuleResponseSchema,
      ])
      .nullable(),
  )
  .nullable();

export const defaultKeywordListUpsertRequestSchema = z.object({
  name: z.string(),
  event_type: automodEventTypeSchema,
  actions: z
    .array(
      z.union([
        blockMessageActionSchema,
        flagToChannelActionSchema,
        quarantineUserActionSchema,
        userCommunicationDisabledActionSchema,
      ]),
    )
    .optional()
    .nullable(),
  enabled: z.boolean().optional().nullable(),
  exempt_roles: z.array(snowflakeTypeSchema).optional().nullable(),
  exempt_channels: z.array(snowflakeTypeSchema).optional().nullable(),
  trigger_type: z.literal(4),
  trigger_metadata: defaultKeywordListTriggerMetadataSchema,
});

export const getApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const updateApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const listApplicationCommandsResponseSchema = z.array(applicationCommandResponseSchema).nullable();

export const bulkSetApplicationCommandsResponseSchema = z.array(applicationCommandResponseSchema).nullable();

export const createApplicationCommandResponseSchema = applicationCommandResponseSchema;

export const getMessageResponseSchema = messageResponseSchema;

export const updateMessageDataSchema = z.object({
  body: messageEditRequestPartialSchema,
  path: z.object({
    channel_id: snowflakeTypeSchema,
    message_id: snowflakeTypeSchema,
  }),
});

export const updateMessageResponseSchema = messageResponseSchema;

export const listMessagesResponseSchema = z.array(messageResponseSchema).nullable();

export const createMessageDataSchema = z.object({
  body: messageCreateRequestSchema,
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const createMessageResponseSchema = messageResponseSchema;

export const listChannelWebhooksResponseSchema = z
  .array(
    z.union([
      applicationIncomingWebhookResponseSchema,
      channelFollowerWebhookResponseSchema,
      guildIncomingWebhookResponseSchema,
    ]),
  )
  .nullable();

export const guildInviteResponseSchema = z.object({
  type: z.literal(0).optional().nullable(),
  code: z.string(),
  inviter: userResponseSchema.optional().nullable(),
  max_age: z.number().optional().nullable(),
  created_at: z.string().optional().nullable(),
  expires_at: z.string().optional().nullable(),
  is_contact: z.boolean().optional().nullable(),
  flags: z.number().optional().nullable(),
  guild: inviteGuildResponseSchema.optional().nullable(),
  guild_id: snowflakeTypeSchema.optional().nullable(),
  channel: inviteChannelResponseSchema.optional().nullable(),
  stage_instance: inviteStageInstanceResponseSchema.optional().nullable(),
  target_type: inviteTargetTypesSchema.optional().nullable(),
  target_user: userResponseSchema.optional().nullable(),
  target_application: inviteApplicationResponseSchema.optional().nullable(),
  guild_scheduled_event: scheduledEventResponseSchema.optional().nullable(),
  uses: z.number().optional().nullable(),
  max_uses: z.number().optional().nullable(),
  temporary: z.boolean().optional().nullable(),
  approximate_member_count: z.number().optional().nullable(),
  approximate_presence_count: z.number().optional().nullable(),
});

export const createChannelInviteResponseSchema = z.union([
  z.union([friendInviteResponseSchema, groupDMInviteResponseSchema, guildInviteResponseSchema]),
  z.any(),
]);

export const createThreadResponseSchema = createdThreadResponseSchema;

export const listPinnedMessagesResponseSchema = z.array(messageResponseSchema).nullable();

export const getWebhookMessageResponseSchema = messageResponseSchema;

export const updateWebhookMessageDataSchema = z.object({
  body: incomingWebhookUpdateRequestPartialSchema,
  path: z.object({
    message_id: snowflakeTypeSchema,
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
    })
    .optional(),
});

export const updateWebhookMessageResponseSchema = messageResponseSchema;

export const executeGithubCompatibleWebhookDataSchema = z.object({
  body: githubWebhookSchema,
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
      wait: z.boolean().optional(),
    })
    .optional(),
});

export const slackWebhookSchema = z.object({
  text: z.string().optional().nullable(),
  username: z.string().optional().nullable(),
  icon_url: z.string().optional().nullable(),
  attachments: z.array(webhookSlackEmbedSchema).optional().nullable(),
});

export const guildTemplateResponseSchema = z.object({
  code: z.string(),
  name: z.string(),
  description: z.string().optional().nullable(),
  usage_count: z.number(),
  creator_id: snowflakeTypeSchema,
  creator: userResponseSchema.optional().nullable(),
  created_at: z.string(),
  updated_at: z.string(),
  source_guild_id: snowflakeTypeSchema,
  serialized_source_guild: guildTemplateSnapshotResponseSchema,
  is_dirty: z.boolean().optional().nullable(),
});

export const createGuildFromTemplateResponseSchema = guildResponseSchema;

export const guildHomeSettingsResponseSchema = z.object({
  guild_id: snowflakeTypeSchema,
  enabled: z.boolean(),
  welcome_message: welcomeMessageResponseSchema.optional().nullable(),
  new_member_actions: z.array(newMemberActionResponseSchema.nullable()).optional().nullable(),
  resource_channels: z.array(resourceChannelResponseSchema.nullable()).optional().nullable(),
});

export const getGuildScheduledEventResponseSchema = z.union([
  externalScheduledEventResponseSchema,
  stageScheduledEventResponseSchema,
  voiceScheduledEventResponseSchema,
]);

export const updateGuildScheduledEventDataSchema = z.object({
  body: z.union([
    externalScheduledEventPatchRequestPartialSchema,
    stageScheduledEventPatchRequestPartialSchema,
    voiceScheduledEventPatchRequestPartialSchema,
  ]),
  path: z.object({
    guild_id: snowflakeTypeSchema,
    guild_scheduled_event_id: snowflakeTypeSchema,
  }),
});

export const updateGuildScheduledEventResponseSchema = z.union([
  externalScheduledEventResponseSchema,
  stageScheduledEventResponseSchema,
  voiceScheduledEventResponseSchema,
]);

export const listGuildScheduledEventsResponseSchema = z
  .array(
    z.union([
      externalScheduledEventResponseSchema,
      stageScheduledEventResponseSchema,
      voiceScheduledEventResponseSchema,
    ]),
  )
  .nullable();

export const createGuildScheduledEventDataSchema = z.object({
  body: z.union([
    externalScheduledEventCreateRequestSchema,
    stageScheduledEventCreateRequestSchema,
    voiceScheduledEventCreateRequestSchema,
  ]),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const discordIntegrationResponseSchema = z.object({
  type: z.literal('discord'),
  name: z.string().optional().nullable(),
  account: accountResponseSchema.optional().nullable(),
  enabled: z.boolean().optional().nullable(),
  id: snowflakeTypeSchema,
  application: integrationApplicationResponseSchema,
  scopes: z.array(z.union([z.literal('applications.commands'), z.literal('bot'), z.literal('webhook.incoming')])),
  user: userResponseSchema.optional().nullable(),
});

export const getGuildWidgetResponseSchema = widgetResponseSchema;

export const getGuildsOnboardingResponseSchema = userGuildOnboardingResponseSchema;

export const putGuildsOnboardingDataSchema = z.object({
  body: updateGuildOnboardingRequestSchema,
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const putGuildsOnboardingResponseSchema = guildOnboardingResponseSchema;

export const guildAuditLogResponseSchema = z.object({
  audit_log_entries: z.array(auditLogEntryResponseSchema),
  users: z.array(userResponseSchema),
  integrations: z.array(
    z.union([
      partialDiscordIntegrationResponseSchema,
      partialExternalConnectionIntegrationResponseSchema,
      partialGuildSubscriptionIntegrationResponseSchema,
    ]),
  ),
  webhooks: z.array(
    z.union([
      applicationIncomingWebhookResponseSchema,
      channelFollowerWebhookResponseSchema,
      guildIncomingWebhookResponseSchema,
    ]),
  ),
  guild_scheduled_events: z.array(
    z.union([
      externalScheduledEventResponseSchema,
      stageScheduledEventResponseSchema,
      voiceScheduledEventResponseSchema,
    ]),
  ),
  threads: z.array(threadResponseSchema),
  application_commands: z.array(applicationCommandResponseSchema),
  auto_moderation_rules: z.array(
    z
      .union([
        defaultKeywordRuleResponseSchema,
        keywordRuleResponseSchema,
        mLSpamRuleResponseSchema,
        mentionSpamRuleResponseSchema,
        spamLinkRuleResponseSchema,
      ])
      .nullable(),
  ),
});

export const syncGuildTemplateResponseSchema = guildTemplateResponseSchema;

export const deleteGuildTemplateResponseSchema = guildTemplateResponseSchema;

export const updateGuildTemplateResponseSchema = guildTemplateResponseSchema;

export const listGuildTemplatesResponseSchema = z.array(guildTemplateResponseSchema).nullable();

export const createGuildTemplateResponseSchema = guildTemplateResponseSchema;

export const getGuildStickerResponseSchema = guildStickerResponseSchema;

export const createGuildChannelDataSchema = z.object({
  body: createGuildChannelRequestSchema,
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const getGuildPreviewResponseSchema = guildPreviewResponseSchema;

export const listGuildInvitesResponseSchema = z
  .array(z.union([friendInviteResponseSchema, groupDMInviteResponseSchema, guildInviteResponseSchema]))
  .nullable();

export const getGuildEmojiResponseSchema = emojiResponseSchema;

export const getGuildBanResponseSchema = guildBanResponseSchema;

export const getApplicationResponseSchema = privateApplicationResponseSchema;

export const updateApplicationResponseSchema = privateApplicationResponseSchema;

export const incomingWebhookRequestPartialSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
  tts: z.boolean().optional().nullable(),
  flags: z.number().optional().nullable(),
  username: z.string().optional().nullable(),
  avatar_url: z.string().optional().nullable(),
  thread_name: z.string().optional().nullable(),
  applied_tags: z.array(snowflakeTypeSchema).optional().nullable(),
});

export const executeWebhookResponseSchema = z.union([messageResponseSchema, z.any()]);

export const updateChannelDataSchema = z.object({
  body: z.union([
    privateChannelRequestPartialSchema,
    updateGuildChannelRequestPartialSchema,
    updateThreadRequestPartialSchema,
  ]),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const inviteResolveResponseSchema = z.union([
  friendInviteResponseSchema,
  groupDMInviteResponseSchema,
  guildInviteResponseSchema,
]);

export const inviteRevokeResponseSchema = z.union([
  friendInviteResponseSchema,
  groupDMInviteResponseSchema,
  guildInviteResponseSchema,
]);

export const getGuildResponseSchema = guildWithCountsResponseSchema;

export const updateGuildResponseSchema = guildResponseSchema;

export const baseCreateMessageCreateRequestSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  sticker_ids: z.array(snowflakeTypeSchema).optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  flags: z.number().optional().nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
});

export const createForumThreadRequestSchema = z.object({
  name: z.string(),
  auto_archive_duration: threadAutoArchiveDurationSchema.optional().nullable(),
  rate_limit_per_user: z.number().optional().nullable(),
  applied_tags: z.array(snowflakeTypeSchema).optional().nullable(),
  message: baseCreateMessageCreateRequestSchema,
});

export const incomingWebhookInteractionRequestSchema = z.object({
  content: z.string().optional().nullable(),
  embeds: z.array(richEmbedSchema).optional().nullable(),
  allowed_mentions: messageAllowedMentionsRequestSchema.optional().nullable(),
  components: z
    .array(
      z.union([
        actionRowSchema,
        buttonSchema,
        channelSelectSchema,
        mentionableSelectSchema,
        roleSelectSchema,
        stringSelectSchema,
        userSelectSchema,
      ]),
    )
    .optional()
    .nullable(),
  attachments: z.array(messageAttachmentRequestSchema).optional().nullable(),
  tts: z.boolean().optional().nullable(),
  flags: z.number().optional().nullable(),
});

export const getMyOauth2ApplicationResponseSchema = privateApplicationResponseSchema;

export const crosspostMessageResponseSchema = messageResponseSchema;

export const createAutoModerationRuleDataSchema = z.object({
  body: z.union([
    defaultKeywordListUpsertRequestSchema,
    keywordUpsertRequestSchema,
    mLSpamUpsertRequestSchema,
    mentionSpamUpsertRequestSchema,
  ]),
  path: z.object({
    guild_id: snowflakeTypeSchema,
  }),
});

export const createMessageInteractionCallbackRequestSchema = z.object({
  type: z.union([z.literal(4), z.literal(5)]),
  data: incomingWebhookInteractionRequestSchema.optional().nullable(),
});

export const listChannelInvitesResponseSchema = z
  .array(z.union([friendInviteResponseSchema, groupDMInviteResponseSchema, guildInviteResponseSchema]))
  .nullable();

export const createThreadDataSchema = z.object({
  body: z.union([createForumThreadRequestSchema, createTextThreadWithoutMessageRequestSchema]),
  path: z.object({
    channel_id: snowflakeTypeSchema,
  }),
});

export const executeSlackCompatibleWebhookDataSchema = z.object({
  body: slackWebhookSchema,
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
      wait: z.boolean().optional(),
    })
    .optional(),
});

export const getGuildTemplateResponseSchema = guildTemplateResponseSchema;

export const getGuildNewMemberWelcomeResponseSchema = z.union([guildHomeSettingsResponseSchema, z.any()]);

export const listGuildIntegrationsResponseSchema = z
  .array(
    z.union([
      discordIntegrationResponseSchema,
      externalConnectionIntegrationResponseSchema,
      guildSubscriptionIntegrationResponseSchema,
    ]),
  )
  .nullable();

export const listGuildAuditLogEntriesResponseSchema = guildAuditLogResponseSchema;

export const executeWebhookDataSchema = z.object({
  body: z.union([incomingWebhookRequestPartialSchema, incomingWebhookUpdateRequestPartialSchema]),
  path: z.object({
    webhook_id: snowflakeTypeSchema,
    webhook_token: z.string(),
  }),
  query: z
    .object({
      thread_id: snowflakeTypeSchema.optional(),
      wait: z.boolean().optional(),
    })
    .optional(),
});

export const createInteractionResponseDataSchema = z.object({
  body: z.union([
    applicationCommandAutocompleteCallbackRequestSchema,
    createMessageInteractionCallbackRequestSchema,
    modalInteractionCallbackRequestSchema,
    pongInteractionCallbackRequestSchema,
    updateMessageInteractionCallbackRequestSchema,
  ]),
  path: z.object({
    interaction_id: snowflakeTypeSchema,
    interaction_token: z.string(),
  }),
});
