// This file is auto-generated by @hey-api/openapi-ts

export type AccountResponse = {
  id: string;
  name?: string | null;
};

export type ActionRow = {
  type: 1;
  components: Array<Button | ChannelSelect | InputText | MentionableSelect | RoleSelect | StringSelect | UserSelect>;
};

export type type = 1;

export type AfkTimeouts = 60 | 300 | 900 | 1800 | 3600;

export type AllowedMentionTypes = 'users' | 'roles' | 'everyone';

export type ApplicationCommandAttachmentOption = {
  type: 11;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type type2 = 11;

export type ApplicationCommandAttachmentOptionResponse = {
  type: 11;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationCommandAutocompleteCallbackRequest = {
  type: 8;
  data:
    | InteractionApplicationCommandAutocompleteCallbackIntegerData
    | InteractionApplicationCommandAutocompleteCallbackNumberData
    | InteractionApplicationCommandAutocompleteCallbackStringData;
};

export type type3 = 8;

export type ApplicationCommandBooleanOption = {
  type: 5;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type type4 = 5;

export type ApplicationCommandBooleanOptionResponse = {
  type: 5;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationCommandChannelOption = {
  type: 7;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  channel_types?: Array<ChannelTypes> | null;
};

export type type5 = 7;

export type ApplicationCommandChannelOptionResponse = {
  type: 7;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  channel_types?: Array<ChannelTypes> | null;
};

export type ApplicationCommandCreateRequest = {
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  options?: Array<
    | ApplicationCommandAttachmentOption
    | ApplicationCommandBooleanOption
    | ApplicationCommandChannelOption
    | ApplicationCommandIntegerOption
    | ApplicationCommandMentionableOption
    | ApplicationCommandNumberOption
    | ApplicationCommandRoleOption
    | ApplicationCommandStringOption
    | ApplicationCommandSubcommandGroupOption
    | ApplicationCommandSubcommandOption
    | ApplicationCommandUserOption
  > | null;
  default_member_permissions?: number | null;
  dm_permission?: boolean | null;
  type?: null | ApplicationCommandType;
};

export type ApplicationCommandIntegerOption = {
  type: 4;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  choices?: Array<ApplicationCommandOptionIntegerChoice> | null;
  min_value?: null | Int53Type;
  max_value?: null | Int53Type;
};

export type type6 = 4;

export type ApplicationCommandIntegerOptionResponse = {
  type: 4;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  choices?: Array<ApplicationCommandOptionIntegerChoiceResponse> | null;
  min_value?: null | Int53Type;
  max_value?: null | Int53Type;
};

export type ApplicationCommandMentionableOption = {
  type: 9;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type type7 = 9;

export type ApplicationCommandMentionableOptionResponse = {
  type: 9;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationCommandNumberOption = {
  type: 10;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  choices?: Array<ApplicationCommandOptionNumberChoice> | null;
  min_value?: number | null;
  max_value?: number | null;
};

export type type8 = 10;

export type ApplicationCommandNumberOptionResponse = {
  type: 10;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  choices?: Array<ApplicationCommandOptionNumberChoiceResponse> | null;
  min_value?: number | null;
  max_value?: number | null;
};

export type ApplicationCommandOptionIntegerChoice = {
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: Int53Type;
};

export type ApplicationCommandOptionIntegerChoiceResponse = {
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: Int53Type;
};

export type ApplicationCommandOptionNumberChoice = {
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: number;
};

export type ApplicationCommandOptionNumberChoiceResponse = {
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: number;
};

export type ApplicationCommandOptionStringChoice = {
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: string;
};

export type ApplicationCommandOptionStringChoiceResponse = {
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  value: string;
};

export type ApplicationCommandOptionType = 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11;

export type ApplicationCommandPatchRequestPartial = {
  name?: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  options?: Array<
    | ApplicationCommandAttachmentOption
    | ApplicationCommandBooleanOption
    | ApplicationCommandChannelOption
    | ApplicationCommandIntegerOption
    | ApplicationCommandMentionableOption
    | ApplicationCommandNumberOption
    | ApplicationCommandRoleOption
    | ApplicationCommandStringOption
    | ApplicationCommandSubcommandGroupOption
    | ApplicationCommandSubcommandOption
    | ApplicationCommandUserOption
  > | null;
  default_member_permissions?: number | null;
  dm_permission?: boolean | null;
};

export type ApplicationCommandPermission = {
  id: SnowflakeType;
  type: ApplicationCommandPermissionType;
  permission: boolean;
};

export type ApplicationCommandPermissionType = 1 | 2 | 3;

export type ApplicationCommandResponse = {
  id: SnowflakeType;
  application_id: SnowflakeType;
  version: SnowflakeType;
  default_member_permissions?: string | null;
  type: ApplicationCommandType;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  guild_id?: null | SnowflakeType;
  dm_permission?: boolean | null;
  options?: Array<
    | ApplicationCommandAttachmentOptionResponse
    | ApplicationCommandBooleanOptionResponse
    | ApplicationCommandChannelOptionResponse
    | ApplicationCommandIntegerOptionResponse
    | ApplicationCommandMentionableOptionResponse
    | ApplicationCommandNumberOptionResponse
    | ApplicationCommandRoleOptionResponse
    | ApplicationCommandStringOptionResponse
    | ApplicationCommandSubcommandGroupOptionResponse
    | ApplicationCommandSubcommandOptionResponse
    | ApplicationCommandUserOptionResponse
  > | null;
  nsfw?: boolean | null;
};

export type ApplicationCommandRoleOption = {
  type: 8;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationCommandRoleOptionResponse = {
  type: 8;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationCommandStringOption = {
  type: 3;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  min_length?: number | null;
  max_length?: number | null;
  choices?: Array<ApplicationCommandOptionStringChoice> | null;
};

export type type9 = 3;

export type ApplicationCommandStringOptionResponse = {
  type: 3;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  autocomplete?: boolean | null;
  choices?: Array<ApplicationCommandOptionStringChoiceResponse> | null;
  min_length?: number | null;
  max_length?: number | null;
};

export type ApplicationCommandSubcommandGroupOption = {
  type: 2;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  options?: Array<ApplicationCommandSubcommandOption> | null;
};

export type type10 = 2;

export type ApplicationCommandSubcommandGroupOptionResponse = {
  type: 2;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  options?: Array<ApplicationCommandSubcommandOptionResponse> | null;
};

export type ApplicationCommandSubcommandOption = {
  type: 1;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  options?: Array<
    | ApplicationCommandAttachmentOption
    | ApplicationCommandBooleanOption
    | ApplicationCommandChannelOption
    | ApplicationCommandIntegerOption
    | ApplicationCommandMentionableOption
    | ApplicationCommandNumberOption
    | ApplicationCommandRoleOption
    | ApplicationCommandStringOption
    | ApplicationCommandUserOption
  > | null;
};

export type ApplicationCommandSubcommandOptionResponse = {
  type: 1;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
  options?: Array<
    | ApplicationCommandAttachmentOptionResponse
    | ApplicationCommandBooleanOptionResponse
    | ApplicationCommandChannelOptionResponse
    | ApplicationCommandIntegerOptionResponse
    | ApplicationCommandMentionableOptionResponse
    | ApplicationCommandNumberOptionResponse
    | ApplicationCommandRoleOptionResponse
    | ApplicationCommandStringOptionResponse
    | ApplicationCommandUserOptionResponse
  > | null;
};

export type ApplicationCommandType = 1 | 2 | 3;

export type ApplicationCommandUpdateRequest = {
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  options?: Array<
    | ApplicationCommandAttachmentOption
    | ApplicationCommandBooleanOption
    | ApplicationCommandChannelOption
    | ApplicationCommandIntegerOption
    | ApplicationCommandMentionableOption
    | ApplicationCommandNumberOption
    | ApplicationCommandRoleOption
    | ApplicationCommandStringOption
    | ApplicationCommandSubcommandGroupOption
    | ApplicationCommandSubcommandOption
    | ApplicationCommandUserOption
  > | null;
  default_member_permissions?: number | null;
  dm_permission?: boolean | null;
  type?: null | ApplicationCommandType;
  id?: null | SnowflakeType;
};

export type ApplicationCommandUserOption = {
  type: 6;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type type11 = 6;

export type ApplicationCommandUserOptionResponse = {
  type: 6;
  name: string;
  name_localized?: string | null;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localized?: string | null;
  description_localizations?: {
    [key: string]: string;
  } | null;
  required?: boolean | null;
};

export type ApplicationFormPartial = {
  description?: {
    default: string;
    localizations?: {
      [key: string]: string;
    } | null;
  } | null;
  icon?: string | null;
  cover_image?: string | null;
  team_id?: null | SnowflakeType;
  flags?: number | null;
  interactions_endpoint_url?: string | null;
  max_participants?: number | null;
  type?: null | ApplicationTypes;
  tags?: Array<string> | null;
  custom_install_url?: string | null;
  install_params?: null | ApplicationOAuth2Params;
  role_connections_verification_url?: string | null;
};

export type ApplicationIncomingWebhookResponse = {
  application_id?: null | SnowflakeType;
  avatar?: string | null;
  channel_id?: null | SnowflakeType;
  guild_id?: null | SnowflakeType;
  id: SnowflakeType;
  name: string;
  type: 3;
  user?: null | UserResponse;
};

export type ApplicationOAuth2Params = {
  scopes?: Array<'applications.commands' | 'bot'> | null;
  permissions?: number | null;
};

export type ApplicationOAuth2ParamsResponse = {
  scopes: Array<'applications.commands' | 'bot'>;
  permissions: string;
};

export type ApplicationResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description: string;
  type?: null | ApplicationTypes;
  cover_image?: string | null;
  primary_sku_id?: null | SnowflakeType;
  bot?: null | UserResponse;
  slug?: string | null;
  guild_id?: null | SnowflakeType;
  rpc_origins?: Array<string | null> | null;
  bot_public?: boolean | null;
  bot_require_code_grant?: boolean | null;
  terms_of_service_url?: string | null;
  privacy_policy_url?: string | null;
  custom_install_url?: string | null;
  install_params?: null | ApplicationOAuth2ParamsResponse;
  verify_key: string;
  flags: number;
  max_participants?: number | null;
  tags?: Array<string> | null;
};

export type ApplicationRoleConnectionsMetadataItemRequest = {
  type: MetadataItemTypes;
  key: string;
  name: string;
  name_localizations?: {
    [key: string]: string | null;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string | null;
  } | null;
};

export type ApplicationRoleConnectionsMetadataItemResponse = {
  type: MetadataItemTypes;
  key: string;
  name: string;
  name_localizations?: {
    [key: string]: string;
  } | null;
  description: string;
  description_localizations?: {
    [key: string]: string;
  } | null;
};

export type ApplicationTypes = 4;

export type ApplicationUserRoleConnectionResponse = {
  platform_name?: string | null;
  platform_username?: string | null;
  metadata?: {
    [key: string]: string;
  } | null;
};

export type AuditLogActionTypes =
  | 1
  | 10
  | 11
  | 12
  | 13
  | 14
  | 15
  | 20
  | 21
  | 22
  | 23
  | 24
  | 25
  | 26
  | 27
  | 28
  | 30
  | 31
  | 32
  | 40
  | 41
  | 42
  | 50
  | 51
  | 52
  | 60
  | 61
  | 62
  | 72
  | 73
  | 74
  | 75
  | 80
  | 81
  | 82
  | 83
  | 84
  | 85
  | 90
  | 91
  | 92
  | 100
  | 101
  | 102
  | 110
  | 111
  | 112
  | 121
  | 130
  | 131
  | 132
  | 140
  | 141
  | 142
  | 143
  | 144
  | 145
  | 146
  | 150
  | 151
  | 163
  | 164
  | 165
  | 166
  | 167
  | 171
  | 172
  | 180
  | 190
  | 191
  | 192
  | 193;

export type AuditLogEntryResponse = {
  id: SnowflakeType;
  action_type: AuditLogActionTypes;
  user_id?: null | SnowflakeType;
  target_id?: null | SnowflakeType;
  changes?: Array<AuditLogObjectChangeResponse> | null;
  options?: {
    [key: string]: string;
  } | null;
  reason?: string | null;
};

export type AuditLogObjectChangeResponse = {
  key?: string | null;
  new_value?: unknown;
  old_value?: unknown;
};

export type AutomodActionType = 1 | 2 | 3 | 4;

export type AutomodEventType = 1 | 2;

export type AutomodKeywordPresetType = 1 | 2 | 3;

export type AutomodTriggerType = 1 | 2 | 3 | 4 | 5;

export type AvailableLocalesEnum =
  | 'ar'
  | 'bg'
  | 'cs'
  | 'da'
  | 'de'
  | 'el'
  | 'en-GB'
  | 'en-US'
  | 'es-419'
  | 'es-ES'
  | 'fi'
  | 'fr'
  | 'he'
  | 'hi'
  | 'hr'
  | 'hu'
  | 'id'
  | 'it'
  | 'ja'
  | 'ko'
  | 'lt'
  | 'nl'
  | 'no'
  | 'pl'
  | 'pt-BR'
  | 'ro'
  | 'ru'
  | 'sv-SE'
  | 'th'
  | 'tr'
  | 'uk'
  | 'vi'
  | 'zh-CN'
  | 'zh-TW';

export type BaseCreateMessageCreateRequest = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  sticker_ids?: Array<SnowflakeType> | null;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  flags?: number | null;
  attachments?: Array<MessageAttachmentRequest> | null;
};

export type BasicApplicationResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description: string;
  type?: null | ApplicationTypes;
  cover_image?: string | null;
  primary_sku_id?: null | SnowflakeType;
  bot?: null | UserResponse;
};

export type BasicMessageResponse = {
  id: SnowflakeType;
  type: MessageType;
  content: string;
  channel_id: SnowflakeType;
  author: UserResponse;
  attachments: Array<MessageAttachmentResponse>;
  embeds: Array<MessageEmbedResponse>;
  mentions: Array<UserResponse>;
  mention_roles: Array<SnowflakeType>;
  pinned: boolean;
  mention_everyone: boolean;
  tts: boolean;
  timestamp: string;
  edited_timestamp?: string | null;
  flags: number;
  components: Array<
    | MessageComponentActionRowResponse
    | MessageComponentButtonResponse
    | MessageComponentChannelSelectResponse
    | MessageComponentInputTextResponse
    | MessageComponentMentionableSelectResponse
    | MessageComponentRoleSelectResponse
    | MessageComponentStringSelectResponse
    | MessageComponentUserSelectResponse
  >;
  activity?: null | MessageActivityResponse;
  application?: null | BasicApplicationResponse;
  application_id?: null | SnowflakeType;
  interaction?: null | MessageInteractionResponse;
  nonce?: number | string | null;
  webhook_id?: null | SnowflakeType;
  message_reference?: null | MessageReferenceResponse;
  thread?: null | ThreadResponse;
  mention_channels?: Array<null | MessageMentionChannelResponse> | null;
  stickers?: Array<GuildStickerResponse | StandardStickerResponse> | null;
  sticker_items?: Array<MessageStickerItemResponse> | null;
  role_subscription_data?: null | MessageRoleSubscriptionDataResponse;
  purchase_notification?: null | PurchaseNotificationResponse;
  position?: number | null;
  resolved?: null | ResolvedObjectsResponse;
};

export type BlockMessageAction = {
  type: 1;
  metadata?: null | BlockMessageActionMetadata;
};

export type BlockMessageActionMetadata = {
  custom_message?: string | null;
};

export type BlockMessageActionMetadataResponse = {
  custom_message?: string | null;
};

export type BlockMessageActionResponse = {
  type: 1;
  metadata: BlockMessageActionMetadataResponse;
};

export type BotAccountPatchRequest = {
  username: string;
  avatar?: string | null;
};

export type Button = {
  type: 2;
  custom_id?: string | null;
  style: ButtonStyleTypes;
  label?: string | null;
  disabled?: boolean | null;
  emoji?: null | Emoji;
  url?: string | null;
};

export type ButtonStyleTypes = 1 | 2 | 3 | 4 | 5;

export type ChannelFollowerResponse = {
  channel_id: SnowflakeType;
  webhook_id: SnowflakeType;
};

export type ChannelFollowerWebhookResponse = {
  application_id?: null | SnowflakeType;
  avatar?: string | null;
  channel_id?: null | SnowflakeType;
  guild_id?: null | SnowflakeType;
  id: SnowflakeType;
  name: string;
  type: 2;
  user?: null | UserResponse;
  source_guild?: null | WebhookSourceGuildResponse;
  source_channel?: null | WebhookSourceChannelResponse;
};

export type ChannelPermissionOverwriteRequest = {
  id: SnowflakeType;
  type?: null | ChannelPermissionOverwrites;
  allow?: number | null;
  deny?: number | null;
};

export type ChannelPermissionOverwriteResponse = {
  id: SnowflakeType;
  type: ChannelPermissionOverwrites;
  allow: string;
  deny: string;
};

export type ChannelPermissionOverwrites = 0 | 1;

export type ChannelSelect = {
  type: 8;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  default_values?: Array<ChannelSelectDefaultValue> | null;
  channel_types?: Array<ChannelTypes> | null;
};

export type ChannelSelectDefaultValue = {
  type: SnowflakeSelectDefaultValueTypes;
  id: SnowflakeType;
};

export type ChannelTypes = 1 | 3 | 0 | 2 | 4 | 5 | 10 | 11 | 12 | 13 | 14 | 15;

export type CommandPermissionResponse = {
  id: SnowflakeType;
  type: ApplicationCommandPermissionType;
  permission: boolean;
};

export type CommandPermissionsResponse = {
  id: SnowflakeType;
  application_id: SnowflakeType;
  guild_id: SnowflakeType;
  permissions: Array<CommandPermissionResponse>;
};

export type ConnectedAccountGuildResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
};

export type ConnectedAccountIntegrationResponse = {
  id: string;
  type: IntegrationTypes;
  account: AccountResponse;
  guild: ConnectedAccountGuildResponse;
};

export type ConnectedAccountProviders =
  | 'battlenet'
  | 'ebay'
  | 'epicgames'
  | 'facebook'
  | 'github'
  | 'instagram'
  | 'leagueoflegends'
  | 'paypal'
  | 'playstation'
  | 'reddit'
  | 'riotgames'
  | 'skype'
  | 'spotify'
  | 'steam'
  | 'tiktok'
  | 'twitch'
  | 'twitter'
  | 'xbox'
  | 'youtube';

export type ConnectedAccountResponse = {
  id: string;
  name?: string | null;
  type: ConnectedAccountProviders;
  friend_sync: boolean;
  integrations?: Array<ConnectedAccountIntegrationResponse> | null;
  show_activity: boolean;
  two_way_link: boolean;
  verified: boolean;
  visibility: ConnectedAccountVisibility;
  revoked?: boolean | null;
};

export type ConnectedAccountVisibility = 0 | 1;

export type CreateForumThreadRequest = {
  name: string;
  auto_archive_duration?: null | ThreadAutoArchiveDuration;
  rate_limit_per_user?: number | null;
  applied_tags?: Array<SnowflakeType> | null;
  message: BaseCreateMessageCreateRequest;
};

export type CreateGroupDMInviteRequest = {
  max_age?: number | null;
};

export type CreateGuildChannelRequest = {
  type?: null | 0 | 2 | 4 | 5 | 13 | 14 | 15;
  name: string;
  position?: number | null;
  topic?: string | null;
  bitrate?: number | null;
  user_limit?: number | null;
  nsfw?: boolean | null;
  rate_limit_per_user?: number | null;
  parent_id?: null | SnowflakeType;
  permission_overwrites?: Array<ChannelPermissionOverwriteRequest> | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  default_auto_archive_duration?: null | ThreadAutoArchiveDuration;
  default_reaction_emoji?: null | UpdateDefaultReactionEmojiRequest;
  default_thread_rate_limit_per_user?: number | null;
  default_sort_order?: null | ThreadSortOrder;
  default_forum_layout?: null | ForumLayout;
  available_tags?: Array<null | CreateOrUpdateThreadTagRequest> | null;
};

export type CreateGuildInviteRequest = {
  max_age?: number | null;
  temporary?: boolean | null;
  max_uses?: number | null;
  unique?: boolean | null;
  target_user_id?: null | SnowflakeType;
  target_application_id?: null | SnowflakeType;
  target_type?: null | 1 | 2;
};

export type CreateGuildRequestChannelItem = {
  type?: null | 0 | 2 | 4;
  name: string;
  position?: number | null;
  topic?: string | null;
  bitrate?: number | null;
  user_limit?: number | null;
  nsfw?: boolean | null;
  rate_limit_per_user?: number | null;
  parent_id?: null | SnowflakeType;
  permission_overwrites?: Array<ChannelPermissionOverwriteRequest> | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  default_auto_archive_duration?: null | ThreadAutoArchiveDuration;
  default_reaction_emoji?: null | UpdateDefaultReactionEmojiRequest;
  default_thread_rate_limit_per_user?: number | null;
  default_sort_order?: null | ThreadSortOrder;
  default_forum_layout?: null | ForumLayout;
  id?: null | SnowflakeType;
  available_tags?: Array<CreateOrUpdateThreadTagRequest> | null;
};

export type CreateGuildRequestRoleItem = {
  id: number;
  name?: string | null;
  permissions?: number | null;
  color?: number | null;
  hoist?: boolean | null;
  mentionable?: boolean | null;
  unicode_emoji?: string | null;
};

export type CreateMessageInteractionCallbackRequest = {
  type: 4 | 5;
  data?: null | IncomingWebhookInteractionRequest;
};

export type type12 = 4 | 5;

export type CreateOrUpdateThreadTagRequest = {
  name: string;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
  moderated?: boolean | null;
};

export type CreatePrivateChannelRequest = {
  recipient_id?: null | SnowflakeType;
  access_tokens?: Array<string> | null;
  nicks?: {
    [key: string]: string | null;
  } | null;
};

export type CreateTextThreadWithMessageRequest = {
  name: string;
  auto_archive_duration?: null | ThreadAutoArchiveDuration;
  rate_limit_per_user?: number | null;
};

export type CreateTextThreadWithoutMessageRequest = {
  name: string;
  auto_archive_duration?: null | ThreadAutoArchiveDuration;
  rate_limit_per_user?: number | null;
  type?: null | 10 | 11 | 12;
  invitable?: boolean | null;
};

export type CreatedThreadResponse = {
  id: SnowflakeType;
  type: 10 | 11 | 12;
  last_message_id?: null | SnowflakeType;
  flags: number;
  last_pin_timestamp?: string | null;
  guild_id: SnowflakeType;
  name: string;
  parent_id?: null | SnowflakeType;
  rate_limit_per_user?: number | null;
  bitrate?: number | null;
  user_limit?: number | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  permissions?: string | null;
  owner_id: SnowflakeType;
  thread_metadata?: null | ThreadMetadataResponse;
  message_count: number;
  member_count: number;
  total_message_sent: number;
  applied_tags?: Array<SnowflakeType> | null;
  member?: null | ThreadMemberResponse;
};

export type type13 = 10 | 11 | 12;

export type DefaultKeywordListTriggerMetadata = {
  allow_list?: Array<string> | null;
  presets?: Array<AutomodKeywordPresetType> | null;
};

export type DefaultKeywordListTriggerMetadataResponse = {
  allow_list: Array<string>;
  presets: Array<AutomodKeywordPresetType>;
};

export type DefaultKeywordListUpsertRequest = {
  name: string;
  event_type: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type: 4;
  trigger_metadata: DefaultKeywordListTriggerMetadata;
};

export type trigger_type = 4;

export type DefaultKeywordListUpsertRequestPartial = {
  name?: string;
  event_type?: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type?: 4;
  trigger_metadata?: DefaultKeywordListTriggerMetadata;
};

export type DefaultKeywordRuleResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  creator_id: SnowflakeType;
  name: string;
  event_type: AutomodEventType;
  actions: Array<
    | BlockMessageActionResponse
    | FlagToChannelActionResponse
    | QuarantineUserActionResponse
    | UserCommunicationDisabledActionResponse
  >;
  trigger_type: 4;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_metadata: DefaultKeywordListTriggerMetadataResponse;
};

export type DefaultReactionEmojiResponse = {
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
};

export type DiscordIntegrationResponse = {
  type: 'discord';
  name?: string | null;
  account?: null | AccountResponse;
  enabled?: boolean | null;
  id: SnowflakeType;
  application: IntegrationApplicationResponse;
  scopes: Array<'applications.commands' | 'bot' | 'webhook.incoming'>;
  user?: null | UserResponse;
};

export type type14 = 'discord';

export type Emoji = {
  id?: null | SnowflakeType;
  name: string;
  animated?: boolean | null;
};

export type EmojiResponse = {
  id: SnowflakeType;
  name: string;
  user?: null | UserResponse;
  roles: Array<SnowflakeType>;
  require_colons: boolean;
  managed: boolean;
  animated: boolean;
  available: boolean;
};

export type EntityMetadataExternal = {
  location: string;
};

export type EntityMetadataExternalResponse = {
  location: string;
};

export type EntityMetadataStageInstance = {
  [key: string]: unknown;
};

export type EntityMetadataStageInstanceResponse = {
  [key: string]: unknown;
};

export type EntityMetadataVoice = {
  [key: string]: unknown;
};

export type EntityMetadataVoiceResponse = {
  [key: string]: unknown;
};

export type ExternalConnectionIntegrationResponse = {
  type: 'twitch' | 'youtube';
  name?: string | null;
  account?: null | AccountResponse;
  enabled?: boolean | null;
  id: string;
  user: UserResponse;
  revoked?: boolean | null;
  expire_behavior?: null | IntegrationExpireBehaviorTypes;
  expire_grace_period?: null | IntegrationExpireGracePeriodTypes;
  subscriber_count?: number | null;
  synced_at?: string | null;
  role_id?: null | SnowflakeType;
  syncing?: boolean | null;
  enable_emoticons?: boolean | null;
};

export type type15 = 'twitch' | 'youtube';

export type ExternalScheduledEventCreateRequest = {
  name: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  entity_type: 3;
  channel_id?: null | SnowflakeType;
  entity_metadata: EntityMetadataExternal;
};

export type entity_type = 3;

export type ExternalScheduledEventPatchRequestPartial = {
  status?: null | GuildScheduledEventStatuses;
  name?: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time?: string;
  scheduled_end_time?: string | null;
  entity_type?: null | 3;
  privacy_level?: GuildScheduledEventPrivacyLevels;
  channel_id?: null | SnowflakeType;
  entity_metadata?: EntityMetadataExternal;
};

export type ExternalScheduledEventResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  name: string;
  description?: string | null;
  channel_id?: null | SnowflakeType;
  creator_id?: null | SnowflakeType;
  creator?: null | UserResponse;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  status: GuildScheduledEventStatuses;
  entity_type: 3;
  entity_id?: null | SnowflakeType;
  user_count?: number | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  user_rsvp?: null | ScheduledEventUserResponse;
  entity_metadata: EntityMetadataExternalResponse;
};

export type FlagToChannelAction = {
  type: 2;
  metadata: FlagToChannelActionMetadata;
};

export type FlagToChannelActionMetadata = {
  channel_id: SnowflakeType;
};

export type FlagToChannelActionMetadataResponse = {
  channel_id: SnowflakeType;
};

export type FlagToChannelActionResponse = {
  type: 2;
  metadata: FlagToChannelActionMetadataResponse;
};

export type ForumLayout = 0 | 1 | 2;

export type ForumTagResponse = {
  id: SnowflakeType;
  name: string;
  moderated: boolean;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
};

export type FriendInviteResponse = {
  type?: null | 2;
  code: string;
  inviter?: null | UserResponse;
  max_age?: number | null;
  created_at?: string | null;
  expires_at?: string | null;
  friends_count?: number | null;
  channel?: null | InviteChannelResponse;
  is_contact?: boolean | null;
  uses?: number | null;
  max_uses?: number | null;
  flags?: number | null;
};

export type GatewayBotResponse = {
  url: string;
  session_start_limit: GatewayBotSessionStartLimitResponse;
  shards: number;
};

export type GatewayBotSessionStartLimitResponse = {
  max_concurrency: number;
  remaining: number;
  reset_after: number;
  total: number;
};

export type GatewayResponse = {
  url: string;
};

export type GithubAuthor = {
  username?: string | null;
  name: string;
};

export type GithubCheckApp = {
  name: string;
};

export type GithubCheckPullRequest = {
  number: number;
};

export type GithubCheckRun = {
  conclusion?: string | null;
  name: string;
  html_url: string;
  check_suite: GithubCheckSuite;
  details_url?: string | null;
  output?: null | GithubCheckRunOutput;
  pull_requests?: Array<GithubCheckPullRequest> | null;
};

export type GithubCheckRunOutput = {
  title?: string | null;
  summary?: string | null;
};

export type GithubCheckSuite = {
  conclusion?: string | null;
  head_branch?: string | null;
  head_sha: string;
  pull_requests?: Array<GithubCheckPullRequest> | null;
  app: GithubCheckApp;
};

export type GithubComment = {
  id: number;
  html_url: string;
  user: GithubUser;
  commit_id?: string | null;
  body: string;
};

export type GithubCommit = {
  id: string;
  url: string;
  message: string;
  author: GithubAuthor;
};

export type GithubDiscussion = {
  title: string;
  number: number;
  html_url: string;
  answer_html_url?: string | null;
  body?: string | null;
  user: GithubUser;
};

export type GithubIssue = {
  id: number;
  number: number;
  html_url: string;
  user: GithubUser;
  title: string;
  body?: string | null;
  pull_request?: unknown;
};

export type GithubRelease = {
  id: number;
  tag_name: string;
  html_url: string;
  author: GithubUser;
};

export type GithubRepository = {
  id: number;
  html_url: string;
  name: string;
  full_name: string;
};

export type GithubReview = {
  user: GithubUser;
  body?: string | null;
  html_url: string;
  state: string;
};

export type GithubUser = {
  id: number;
  login: string;
  html_url: string;
  avatar_url: string;
};

export type GithubWebhook = {
  action?: string | null;
  ref?: string | null;
  ref_type?: string | null;
  comment?: null | GithubComment;
  issue?: null | GithubIssue;
  pull_request?: null | GithubIssue;
  repository?: null | GithubRepository;
  forkee?: null | GithubRepository;
  sender: GithubUser;
  member?: null | GithubUser;
  release?: null | GithubRelease;
  head_commit?: null | GithubCommit;
  commits?: Array<GithubCommit> | null;
  forced?: boolean | null;
  compare?: string | null;
  review?: null | GithubReview;
  check_run?: null | GithubCheckRun;
  check_suite?: null | GithubCheckSuite;
  discussion?: null | GithubDiscussion;
  answer?: null | GithubComment;
};

export type GroupDMInviteResponse = {
  type?: null | 1;
  code: string;
  inviter?: null | UserResponse;
  max_age?: number | null;
  created_at?: string | null;
  expires_at?: string | null;
  channel?: null | InviteChannelResponse;
  approximate_member_count?: number | null;
};

export type GuildAuditLogResponse = {
  audit_log_entries: Array<AuditLogEntryResponse>;
  users: Array<UserResponse>;
  integrations: Array<
    | PartialDiscordIntegrationResponse
    | PartialExternalConnectionIntegrationResponse
    | PartialGuildSubscriptionIntegrationResponse
  >;
  webhooks: Array<ApplicationIncomingWebhookResponse | ChannelFollowerWebhookResponse | GuildIncomingWebhookResponse>;
  guild_scheduled_events: Array<
    ExternalScheduledEventResponse | StageScheduledEventResponse | VoiceScheduledEventResponse
  >;
  threads: Array<ThreadResponse>;
  application_commands: Array<ApplicationCommandResponse>;
  auto_moderation_rules: Array<
    | DefaultKeywordRuleResponse
    | KeywordRuleResponse
    | MLSpamRuleResponse
    | MentionSpamRuleResponse
    | SpamLinkRuleResponse
    | null
  >;
};

export type GuildBanResponse = {
  user: UserResponse;
  reason?: string | null;
};

export type GuildChannelResponse = {
  id: SnowflakeType;
  type: 0 | 2 | 4 | 5 | 13 | 14 | 15;
  last_message_id?: null | SnowflakeType;
  flags: number;
  last_pin_timestamp?: string | null;
  guild_id: SnowflakeType;
  name: string;
  parent_id?: null | SnowflakeType;
  rate_limit_per_user?: number | null;
  bitrate?: number | null;
  user_limit?: number | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  permissions?: string | null;
  topic?: string | null;
  default_auto_archive_duration?: null | ThreadAutoArchiveDuration;
  default_thread_rate_limit_per_user?: number | null;
  position: number;
  permission_overwrites?: Array<ChannelPermissionOverwriteResponse> | null;
  nsfw?: boolean | null;
  available_tags?: Array<ForumTagResponse> | null;
  default_reaction_emoji?: null | DefaultReactionEmojiResponse;
  default_sort_order?: null | ThreadSortOrder;
  default_forum_layout?: null | ForumLayout;
};

export type type16 = 0 | 2 | 4 | 5 | 13 | 14 | 15;

export type GuildCreateRequest = {
  name: string;
  description?: string | null;
  region?: string | null;
  icon?: string | null;
  verification_level?: null | VerificationLevels;
  default_message_notifications?: null | UserNotificationSettings;
  explicit_content_filter?: null | GuildExplicitContentFilterTypes;
  preferred_locale?: null | AvailableLocalesEnum;
  afk_timeout?: null | AfkTimeouts;
  roles?: Array<CreateGuildRequestRoleItem> | null;
  channels?: Array<CreateGuildRequestChannelItem> | null;
  afk_channel_id?: null | SnowflakeType;
  system_channel_id?: null | SnowflakeType;
  system_channel_flags?: number | null;
};

export type GuildExplicitContentFilterTypes = 0 | 1 | 2;

export type GuildFeatures =
  | 'ANIMATED_BANNER'
  | 'ANIMATED_ICON'
  | 'APPLICATION_COMMAND_PERMISSIONS_V2'
  | 'AUTO_MODERATION'
  | 'BANNER'
  | 'COMMUNITY'
  | 'CREATOR_MONETIZABLE_PROVISIONAL'
  | 'CREATOR_STORE_PAGE'
  | 'DEVELOPER_SUPPORT_SERVER'
  | 'DISCOVERABLE'
  | 'FEATURABLE'
  | 'INVITES_DISABLED'
  | 'INVITE_SPLASH'
  | 'MEMBER_VERIFICATION_GATE_ENABLED'
  | 'MORE_STICKERS'
  | 'NEWS'
  | 'PARTNERED'
  | 'PREVIEW_ENABLED'
  | 'RAID_ALERTS_DISABLED'
  | 'ROLE_ICONS'
  | 'ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE'
  | 'ROLE_SUBSCRIPTIONS_ENABLED'
  | 'TICKETED_EVENTS_ENABLED'
  | 'VANITY_URL'
  | 'VERIFIED'
  | 'VIP_REGIONS'
  | 'WELCOME_SCREEN_ENABLED';

export type GuildHomeSettingsResponse = {
  guild_id: SnowflakeType;
  enabled: boolean;
  welcome_message?: null | WelcomeMessageResponse;
  new_member_actions?: Array<null | NewMemberActionResponse> | null;
  resource_channels?: Array<null | ResourceChannelResponse> | null;
};

export type GuildIncomingWebhookResponse = {
  application_id?: null | SnowflakeType;
  avatar?: string | null;
  channel_id?: null | SnowflakeType;
  guild_id?: null | SnowflakeType;
  id: SnowflakeType;
  name: string;
  type: 1;
  user?: null | UserResponse;
  token?: string | null;
  url?: string | null;
};

export type GuildInviteResponse = {
  type?: null | 0;
  code: string;
  inviter?: null | UserResponse;
  max_age?: number | null;
  created_at?: string | null;
  expires_at?: string | null;
  is_contact?: boolean | null;
  flags?: number | null;
  guild?: null | InviteGuildResponse;
  guild_id?: null | SnowflakeType;
  channel?: null | InviteChannelResponse;
  stage_instance?: null | InviteStageInstanceResponse;
  target_type?: null | InviteTargetTypes;
  target_user?: null | UserResponse;
  target_application?: null | InviteApplicationResponse;
  guild_scheduled_event?: null | ScheduledEventResponse;
  uses?: number | null;
  max_uses?: number | null;
  temporary?: boolean | null;
  approximate_member_count?: number | null;
  approximate_presence_count?: number | null;
};

export type GuildMFALevel = 0 | 1;

export type GuildMFALevelResponse = {
  level: GuildMFALevel;
};

export type GuildMemberResponse = {
  avatar?: string | null;
  communication_disabled_until?: string | null;
  flags: number;
  joined_at: string;
  nick?: string | null;
  pending: boolean;
  premium_since?: string | null;
  roles: Array<SnowflakeType>;
  user: UserResponse;
  mute: boolean;
  deaf: boolean;
};

export type GuildNSFWContentLevel = 0 | 1 | 2 | 3;

export type GuildOnboardingMode = 0 | 1;

export type GuildOnboardingResponse = {
  guild_id: SnowflakeType;
  prompts: Array<OnboardingPromptResponse>;
  default_channel_ids: Array<SnowflakeType>;
  enabled: boolean;
};

export type GuildPatchRequestPartial = {
  name?: string;
  description?: string | null;
  region?: string | null;
  icon?: string | null;
  verification_level?: null | VerificationLevels;
  default_message_notifications?: null | UserNotificationSettings;
  explicit_content_filter?: null | GuildExplicitContentFilterTypes;
  preferred_locale?: null | AvailableLocalesEnum;
  afk_timeout?: null | AfkTimeouts;
  afk_channel_id?: null | SnowflakeType;
  system_channel_id?: null | SnowflakeType;
  owner_id?: SnowflakeType;
  splash?: string | null;
  banner?: string | null;
  system_channel_flags?: number | null;
  features?: Array<string | null> | null;
  discovery_splash?: string | null;
  home_header?: string | null;
  rules_channel_id?: null | SnowflakeType;
  safety_alerts_channel_id?: null | SnowflakeType;
  public_updates_channel_id?: null | SnowflakeType;
  premium_progress_bar_enabled?: boolean | null;
};

export type GuildPreviewResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description?: string | null;
  home_header?: string | null;
  splash?: string | null;
  discovery_splash?: string | null;
  features: Array<GuildFeatures>;
  approximate_member_count: number;
  approximate_presence_count: number;
  emojis: Array<EmojiResponse>;
  stickers: Array<GuildStickerResponse>;
};

export type GuildProductPurchaseResponse = {
  listing_id: SnowflakeType;
  product_name: string;
};

export type GuildPruneResponse = {
  pruned?: number | null;
};

export type GuildResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description?: string | null;
  home_header?: string | null;
  splash?: string | null;
  discovery_splash?: string | null;
  features: Array<GuildFeatures>;
  banner?: string | null;
  owner_id: SnowflakeType;
  application_id?: null | SnowflakeType;
  region: string;
  afk_channel_id?: null | SnowflakeType;
  afk_timeout: AfkTimeouts;
  system_channel_id?: null | SnowflakeType;
  system_channel_flags: number;
  widget_enabled: boolean;
  widget_channel_id?: null | SnowflakeType;
  verification_level: VerificationLevels;
  roles: Array<GuildRoleResponse>;
  default_message_notifications: UserNotificationSettings;
  mfa_level: GuildMFALevel;
  explicit_content_filter: GuildExplicitContentFilterTypes;
  max_presences?: number | null;
  max_members?: number | null;
  max_stage_video_channel_users?: number | null;
  max_video_channel_users?: number | null;
  vanity_url_code?: string | null;
  premium_tier: PremiumGuildTiers;
  premium_subscription_count: number;
  preferred_locale: AvailableLocalesEnum;
  rules_channel_id?: null | SnowflakeType;
  safety_alerts_channel_id?: null | SnowflakeType;
  public_updates_channel_id?: null | SnowflakeType;
  premium_progress_bar_enabled: boolean;
  nsfw: boolean;
  nsfw_level: GuildNSFWContentLevel;
  emojis: Array<EmojiResponse>;
  stickers: Array<GuildStickerResponse>;
};

export type GuildRoleResponse = {
  id: SnowflakeType;
  name: string;
  description?: string | null;
  permissions: string;
  position: number;
  color: number;
  hoist: boolean;
  managed: boolean;
  mentionable: boolean;
  icon?: string | null;
  unicode_emoji?: string | null;
  tags?: null | GuildRoleTagsResponse;
};

export type GuildRoleTagsResponse = {
  premium_subscriber?: null;
  bot_id?: null | SnowflakeType;
  integration_id?: null | SnowflakeType;
  subscription_listing_id?: null | SnowflakeType;
  available_for_purchase?: null;
  guild_connections?: null;
};

export type GuildScheduledEventEntityTypes = 0 | 1 | 2 | 3;

export type GuildScheduledEventPrivacyLevels = 2;

export type GuildScheduledEventStatuses = 1 | 2 | 3 | 4;

export type GuildStickerResponse = {
  id: SnowflakeType;
  name: string;
  tags: string;
  type: 2;
  format_type?: null | StickerFormatTypes;
  description?: string | null;
  available: boolean;
  guild_id: SnowflakeType;
  user?: null | UserResponse;
};

export type GuildSubscriptionIntegrationResponse = {
  type: 'guild_subscription';
  name?: string | null;
  account?: null | AccountResponse;
  enabled?: boolean | null;
  id: SnowflakeType;
};

export type type17 = 'guild_subscription';

export type GuildTemplateChannelResponse = {
  id?: number | null;
  type: 0 | 2 | 4;
  name?: string | null;
  position?: number | null;
  topic?: string | null;
  bitrate: number;
  user_limit: number;
  nsfw: boolean;
  rate_limit_per_user: number;
  parent_id?: null | SnowflakeType;
  default_auto_archive_duration?: null | ThreadAutoArchiveDuration;
  permission_overwrites: Array<null | ChannelPermissionOverwriteResponse>;
  available_tags?: Array<GuildTemplateChannelTags> | null;
  template: string;
  default_reaction_emoji?: null | DefaultReactionEmojiResponse;
  default_thread_rate_limit_per_user?: number | null;
  default_sort_order?: null | ThreadSortOrder;
  default_forum_layout?: null | ForumLayout;
  icon_emoji?: null | IconEmojiResponse;
  theme_color?: number | null;
};

export type type18 = 0 | 2 | 4;

export type GuildTemplateChannelTags = {
  name: string;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
  moderated?: boolean | null;
};

export type GuildTemplateResponse = {
  code: string;
  name: string;
  description?: string | null;
  usage_count: number;
  creator_id: SnowflakeType;
  creator?: null | UserResponse;
  created_at: string;
  updated_at: string;
  source_guild_id: SnowflakeType;
  serialized_source_guild: GuildTemplateSnapshotResponse;
  is_dirty?: boolean | null;
};

export type GuildTemplateRoleResponse = {
  id: number;
  name: string;
  permissions: string;
  color: number;
  hoist: boolean;
  mentionable: boolean;
  icon?: string | null;
  unicode_emoji?: string | null;
};

export type GuildTemplateSnapshotResponse = {
  name: string;
  description?: string | null;
  region?: string | null;
  verification_level: VerificationLevels;
  default_message_notifications: UserNotificationSettings;
  explicit_content_filter: GuildExplicitContentFilterTypes;
  preferred_locale: AvailableLocalesEnum;
  afk_channel_id?: null | SnowflakeType;
  afk_timeout: AfkTimeouts;
  system_channel_id?: null | SnowflakeType;
  system_channel_flags: number;
  roles: Array<GuildTemplateRoleResponse>;
  channels: Array<GuildTemplateChannelResponse>;
};

export type GuildWelcomeChannel = {
  channel_id: SnowflakeType;
  description: string;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
};

export type GuildWelcomeScreenChannelResponse = {
  channel_id: SnowflakeType;
  description: string;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
};

export type GuildWelcomeScreenResponse = {
  description?: string | null;
  welcome_channels: Array<GuildWelcomeScreenChannelResponse>;
};

export type GuildWithCountsResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description?: string | null;
  home_header?: string | null;
  splash?: string | null;
  discovery_splash?: string | null;
  features: Array<GuildFeatures>;
  banner?: string | null;
  owner_id: SnowflakeType;
  application_id?: null | SnowflakeType;
  region: string;
  afk_channel_id?: null | SnowflakeType;
  afk_timeout: AfkTimeouts;
  system_channel_id?: null | SnowflakeType;
  system_channel_flags: number;
  widget_enabled: boolean;
  widget_channel_id?: null | SnowflakeType;
  verification_level: VerificationLevels;
  roles: Array<GuildRoleResponse>;
  default_message_notifications: UserNotificationSettings;
  mfa_level: GuildMFALevel;
  explicit_content_filter: GuildExplicitContentFilterTypes;
  max_presences?: number | null;
  max_members?: number | null;
  max_stage_video_channel_users?: number | null;
  max_video_channel_users?: number | null;
  vanity_url_code?: string | null;
  premium_tier: PremiumGuildTiers;
  premium_subscription_count: number;
  preferred_locale: AvailableLocalesEnum;
  rules_channel_id?: null | SnowflakeType;
  safety_alerts_channel_id?: null | SnowflakeType;
  public_updates_channel_id?: null | SnowflakeType;
  premium_progress_bar_enabled: boolean;
  nsfw: boolean;
  nsfw_level: GuildNSFWContentLevel;
  emojis: Array<EmojiResponse>;
  stickers: Array<GuildStickerResponse>;
  approximate_member_count?: number | null;
  approximate_presence_count?: number | null;
};

export type IconEmojiResponse = {
  [key: string]: unknown;
};

export type IncomingWebhookInteractionRequest = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  attachments?: Array<MessageAttachmentRequest> | null;
  tts?: boolean | null;
  flags?: number | null;
};

export type IncomingWebhookRequestPartial = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  attachments?: Array<MessageAttachmentRequest> | null;
  tts?: boolean | null;
  flags?: number | null;
  username?: string | null;
  avatar_url?: string | null;
  thread_name?: string | null;
  applied_tags?: Array<SnowflakeType> | null;
};

export type IncomingWebhookUpdateForInteractionCallbackRequestPartial = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  attachments?: Array<MessageAttachmentRequest> | null;
  flags?: number | null;
};

export type IncomingWebhookUpdateRequestPartial = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  attachments?: Array<MessageAttachmentRequest> | null;
  flags?: number | null;
};

export type InputText = {
  type: 4;
  custom_id: string;
  style: TextStyleTypes;
  label: string;
  value?: string | null;
  placeholder?: string | null;
  required?: boolean | null;
  min_length?: number | null;
  max_length?: number | null;
};

export type Int53Type = number;

export type IntegrationApplicationResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description: string;
  type?: null | ApplicationTypes;
  cover_image?: string | null;
  primary_sku_id?: null | SnowflakeType;
  bot?: null | UserResponse;
};

export type IntegrationExpireBehaviorTypes = 0 | 1;

export type IntegrationExpireGracePeriodTypes = 1 | 3 | 7 | 14 | 30;

export type IntegrationTypes = 'discord' | 'twitch' | 'youtube' | 'guild_subscription';

export type InteractionApplicationCommandAutocompleteCallbackIntegerData = {
  choices?: Array<null | ApplicationCommandOptionIntegerChoice> | null;
};

export type InteractionApplicationCommandAutocompleteCallbackNumberData = {
  choices?: Array<null | ApplicationCommandOptionNumberChoice> | null;
};

export type InteractionApplicationCommandAutocompleteCallbackStringData = {
  choices?: Array<null | ApplicationCommandOptionStringChoice> | null;
};

export type InteractionCallbackTypes = 1 | 4 | 5 | 6 | 7 | 8 | 9;

export type InteractionTypes = 1 | 2 | 3 | 4 | 5;

export type InviteApplicationResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description: string;
  type?: null | ApplicationTypes;
  cover_image?: string | null;
  primary_sku_id?: null | SnowflakeType;
  bot?: null | UserResponse;
  slug?: string | null;
  guild_id?: null | SnowflakeType;
  rpc_origins?: Array<string | null> | null;
  bot_public?: boolean | null;
  bot_require_code_grant?: boolean | null;
  terms_of_service_url?: string | null;
  privacy_policy_url?: string | null;
  custom_install_url?: string | null;
  install_params?: null | ApplicationOAuth2ParamsResponse;
  verify_key: string;
  flags: number;
  max_participants?: number | null;
  tags?: Array<string> | null;
};

export type InviteChannelRecipientResponse = {
  username: string;
};

export type InviteChannelResponse = {
  id: SnowflakeType;
  type: ChannelTypes;
  name?: string | null;
  icon?: string | null;
  recipients?: Array<InviteChannelRecipientResponse> | null;
};

export type InviteGuildResponse = {
  id: SnowflakeType;
  name: string;
  splash?: string | null;
  banner?: string | null;
  description?: string | null;
  icon?: string | null;
  features: Array<GuildFeatures>;
  verification_level?: null | VerificationLevels;
  vanity_url_code?: string | null;
  nsfw_level?: null | GuildNSFWContentLevel;
  nsfw?: boolean | null;
  premium_subscription_count?: number | null;
};

export type InviteStageInstanceResponse = {
  topic: string;
  participant_count?: number | null;
  speaker_count?: number | null;
  members?: Array<GuildMemberResponse> | null;
};

export type InviteTargetTypes = 1 | 2 | 3;

export type InviteTypes = 0 | 1 | 2;

export type KeywordRuleResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  creator_id: SnowflakeType;
  name: string;
  event_type: AutomodEventType;
  actions: Array<
    | BlockMessageActionResponse
    | FlagToChannelActionResponse
    | QuarantineUserActionResponse
    | UserCommunicationDisabledActionResponse
  >;
  trigger_type: 1;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_metadata: KeywordTriggerMetadataResponse;
};

export type trigger_type2 = 1;

export type KeywordTriggerMetadata = {
  keyword_filter?: Array<string> | null;
  regex_patterns?: Array<string> | null;
  allow_list?: Array<string> | null;
};

export type KeywordTriggerMetadataResponse = {
  keyword_filter: Array<string>;
  regex_patterns: Array<string>;
  allow_list: Array<string>;
};

export type KeywordUpsertRequest = {
  name: string;
  event_type: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type: 1;
  trigger_metadata?: null | KeywordTriggerMetadata;
};

export type KeywordUpsertRequestPartial = {
  name?: string;
  event_type?: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type?: 1;
  trigger_metadata?: null | KeywordTriggerMetadata;
};

export type MLSpamRuleResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  creator_id: SnowflakeType;
  name: string;
  event_type: AutomodEventType;
  actions: Array<
    | BlockMessageActionResponse
    | FlagToChannelActionResponse
    | QuarantineUserActionResponse
    | UserCommunicationDisabledActionResponse
  >;
  trigger_type: 3;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_metadata: MLSpamTriggerMetadataResponse;
};

export type trigger_type3 = 3;

export type MLSpamTriggerMetadata = {
  [key: string]: unknown;
};

export type MLSpamTriggerMetadataResponse = {
  [key: string]: unknown;
};

export type MLSpamUpsertRequest = {
  name: string;
  event_type: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type: 3;
  trigger_metadata?: null | MLSpamTriggerMetadata;
};

export type MLSpamUpsertRequestPartial = {
  name?: string;
  event_type?: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type?: 3;
  trigger_metadata?: null | MLSpamTriggerMetadata;
};

export type MentionSpamRuleResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  creator_id: SnowflakeType;
  name: string;
  event_type: AutomodEventType;
  actions: Array<
    | BlockMessageActionResponse
    | FlagToChannelActionResponse
    | QuarantineUserActionResponse
    | UserCommunicationDisabledActionResponse
  >;
  trigger_type: 5;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_metadata: MentionSpamTriggerMetadataResponse;
};

export type trigger_type4 = 5;

export type MentionSpamTriggerMetadata = {
  mention_total_limit: number;
  mention_raid_protection_enabled?: boolean | null;
};

export type MentionSpamTriggerMetadataResponse = {
  mention_total_limit: number;
};

export type MentionSpamUpsertRequest = {
  name: string;
  event_type: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type: 5;
  trigger_metadata?: null | MentionSpamTriggerMetadata;
};

export type MentionSpamUpsertRequestPartial = {
  name?: string;
  event_type?: AutomodEventType;
  actions?: Array<
    BlockMessageAction | FlagToChannelAction | QuarantineUserAction | UserCommunicationDisabledAction
  > | null;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_type?: 5;
  trigger_metadata?: null | MentionSpamTriggerMetadata;
};

export type MentionableSelect = {
  type: 7;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  default_values?: Array<unknown> | null;
};

export type MessageActivityResponse = {
  [key: string]: unknown;
};

export type MessageAllowedMentionsRequest = {
  parse?: Array<null | AllowedMentionTypes> | null;
  users?: Array<null | SnowflakeType> | null;
  roles?: Array<null | SnowflakeType> | null;
  replied_user?: boolean | null;
};

export type MessageAttachmentRequest = {
  id: SnowflakeType;
  filename?: string | null;
  description?: string | null;
  is_remix?: boolean | null;
};

export type MessageAttachmentResponse = {
  id: SnowflakeType;
  filename: string;
  size: number;
  url: string;
  proxy_url: string;
  width?: number | null;
  height?: number | null;
  duration_secs?: number | null;
  waveform?: string | null;
  description?: string | null;
  content_type?: string | null;
  ephemeral?: boolean | null;
  title?: string | null;
  application?: null | ApplicationResponse;
  clip_created_at?: string | null;
  clip_participants?: Array<UserResponse> | null;
};

export type MessageComponentActionRowResponse = {
  type: 1;
  components?: Array<
    | MessageComponentButtonResponse
    | MessageComponentChannelSelectResponse
    | MessageComponentInputTextResponse
    | MessageComponentMentionableSelectResponse
    | MessageComponentRoleSelectResponse
    | MessageComponentStringSelectResponse
    | MessageComponentUserSelectResponse
  > | null;
};

export type MessageComponentButtonResponse = {
  type: 2;
  custom_id?: string | null;
  style: ButtonStyleTypes;
  label?: string | null;
  disabled?: boolean | null;
  emoji?: null | MessageComponentEmojiResponse;
  url?: string | null;
};

export type MessageComponentChannelSelectResponse = {
  type: 8;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  channel_types?: Array<ChannelTypes> | null;
};

export type MessageComponentEmojiResponse = {
  id?: null | SnowflakeType;
  name: string;
  animated?: boolean | null;
};

export type MessageComponentInputTextResponse = {
  type: 4;
  custom_id: string;
  style: TextStyleTypes;
  label?: string | null;
  value?: string | null;
  placeholder?: string | null;
  required?: boolean | null;
  min_length?: number | null;
  max_length?: number | null;
};

export type MessageComponentMentionableSelectResponse = {
  type: 7;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
};

export type MessageComponentRoleSelectResponse = {
  type: 6;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
};

export type MessageComponentStringSelectResponse = {
  type: 3;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  options?: Array<null | SelectOptionResponse> | null;
};

export type MessageComponentTypes = 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8;

export type MessageComponentUserSelectResponse = {
  type: 5;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
};

export type MessageCreateRequest = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  sticker_ids?: Array<SnowflakeType> | null;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  flags?: number | null;
  attachments?: Array<MessageAttachmentRequest> | null;
  message_reference?: null | ReplyMessageReferenceRequest;
  nonce?: number | string | null;
  tts?: boolean | null;
};

export type MessageEditRequestPartial = {
  content?: string | null;
  embeds?: Array<RichEmbed> | null;
  flags?: number | null;
  allowed_mentions?: null | MessageAllowedMentionsRequest;
  sticker_ids?: Array<null | SnowflakeType> | null;
  components?: Array<
    ActionRow | Button | ChannelSelect | MentionableSelect | RoleSelect | StringSelect | UserSelect
  > | null;
  attachments?: Array<MessageAttachmentRequest> | null;
};

export type MessageEmbedAuthorResponse = {
  name: string;
  url?: string | null;
  icon_url?: string | null;
  proxy_icon_url?: string | null;
};

export type MessageEmbedFieldResponse = {
  name: string;
  value: string;
  inline: boolean;
};

export type MessageEmbedFooterResponse = {
  text: string;
  icon_url?: string | null;
  proxy_icon_url?: string | null;
};

export type MessageEmbedImageResponse = {
  url?: string | null;
  proxy_url?: string | null;
  width?: null | UInt32Type;
  height?: null | UInt32Type;
  placeholder?: string | null;
  placeholder_version?: null | UInt32Type;
};

export type MessageEmbedProviderResponse = {
  name: string;
  url?: string | null;
};

export type MessageEmbedResponse = {
  type: string;
  url?: string | null;
  title?: string | null;
  description?: string | null;
  color?: number | null;
  timestamp?: string | null;
  fields?: Array<MessageEmbedFieldResponse> | null;
  author?: null | MessageEmbedAuthorResponse;
  provider?: null | MessageEmbedProviderResponse;
  image?: null | MessageEmbedImageResponse;
  thumbnail?: null | MessageEmbedImageResponse;
  video?: null | MessageEmbedVideoResponse;
  footer?: null | MessageEmbedFooterResponse;
};

export type MessageEmbedVideoResponse = {
  url?: string | null;
  proxy_url?: string | null;
  width?: null | UInt32Type;
  height?: null | UInt32Type;
  placeholder?: string | null;
  placeholder_version?: null | UInt32Type;
};

export type MessageInteractionResponse = {
  id: SnowflakeType;
  type: InteractionTypes;
  name: string;
  user?: null | UserResponse;
  name_localized?: string | null;
};

export type MessageMentionChannelResponse = {
  id: SnowflakeType;
  name: string;
  type: ChannelTypes;
  guild_id: SnowflakeType;
};

export type MessageReactionCountDetailsResponse = {
  burst: number;
  normal: number;
};

export type MessageReactionEmojiResponse = {
  id?: null | SnowflakeType;
  name?: string | null;
  animated?: boolean | null;
};

export type MessageReactionResponse = {
  emoji: MessageReactionEmojiResponse;
  count: number;
  count_details: MessageReactionCountDetailsResponse;
  burst_colors: Array<string>;
  me_burst: boolean;
  me: boolean;
};

export type MessageReferenceResponse = {
  channel_id: SnowflakeType;
  message_id?: null | SnowflakeType;
  guild_id?: null | SnowflakeType;
};

export type MessageResponse = {
  id: SnowflakeType;
  type: MessageType;
  content: string;
  channel_id: SnowflakeType;
  author: UserResponse;
  attachments: Array<MessageAttachmentResponse>;
  embeds: Array<MessageEmbedResponse>;
  mentions: Array<UserResponse>;
  mention_roles: Array<SnowflakeType>;
  pinned: boolean;
  mention_everyone: boolean;
  tts: boolean;
  timestamp: string;
  edited_timestamp?: string | null;
  flags: number;
  components: Array<
    | MessageComponentActionRowResponse
    | MessageComponentButtonResponse
    | MessageComponentChannelSelectResponse
    | MessageComponentInputTextResponse
    | MessageComponentMentionableSelectResponse
    | MessageComponentRoleSelectResponse
    | MessageComponentStringSelectResponse
    | MessageComponentUserSelectResponse
  >;
  activity?: null | MessageActivityResponse;
  application?: null | BasicApplicationResponse;
  application_id?: null | SnowflakeType;
  interaction?: null | MessageInteractionResponse;
  nonce?: number | string | null;
  webhook_id?: null | SnowflakeType;
  message_reference?: null | MessageReferenceResponse;
  thread?: null | ThreadResponse;
  mention_channels?: Array<null | MessageMentionChannelResponse> | null;
  stickers?: Array<GuildStickerResponse | StandardStickerResponse> | null;
  sticker_items?: Array<MessageStickerItemResponse> | null;
  role_subscription_data?: null | MessageRoleSubscriptionDataResponse;
  purchase_notification?: null | PurchaseNotificationResponse;
  position?: number | null;
  resolved?: null | ResolvedObjectsResponse;
  reactions?: Array<MessageReactionResponse> | null;
  referenced_message?: null | BasicMessageResponse;
};

export type MessageRoleSubscriptionDataResponse = {
  role_subscription_listing_id: SnowflakeType;
  tier_name: string;
  total_months_subscribed: number;
  is_renewal: boolean;
};

export type MessageStickerItemResponse = {
  id: SnowflakeType;
  name: string;
  format_type: StickerFormatTypes;
};

export type MessageType =
  | 0
  | 1
  | 2
  | 3
  | 4
  | 5
  | 6
  | 7
  | 8
  | 9
  | 10
  | 11
  | 12
  | 14
  | 15
  | 16
  | 17
  | 18
  | 19
  | 20
  | 21
  | 22
  | 23
  | 24
  | 25
  | 26
  | 27
  | 28
  | 29
  | 31
  | 32;

export type MetadataItemTypes = 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8;

export type ModalInteractionCallbackData = {
  custom_id: string;
  title: string;
  components: Array<ActionRow | InputText>;
};

export type ModalInteractionCallbackRequest = {
  type: 9;
  data: ModalInteractionCallbackData;
};

export type MyGuildResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  owner: boolean;
  permissions: string;
  features: Array<GuildFeatures>;
  approximate_member_count?: number | null;
  approximate_presence_count?: number | null;
};

export type NewMemberActionResponse = {
  channel_id: SnowflakeType;
  action_type: NewMemberActionType;
  title: string;
  description: string;
  emoji?: null | SettingsEmojiResponse;
  icon?: string | null;
};

export type NewMemberActionType = 0 | 1;

export type OAuth2GetAuthorizationResponse = {
  application: ApplicationResponse;
  expires: string;
  scopes: Array<OAuth2Scopes>;
  user?: null | UserResponse;
};

export type OAuth2Scopes =
  | 'identify'
  | 'email'
  | 'connections'
  | 'guilds'
  | 'guilds.join'
  | 'guilds.members.read'
  | 'gdm.join'
  | 'bot'
  | 'rpc'
  | 'rpc.notifications.read'
  | 'rpc.voice.read'
  | 'rpc.voice.write'
  | 'rpc.video.read'
  | 'rpc.video.write'
  | 'rpc.screenshare.read'
  | 'rpc.screenshare.write'
  | 'rpc.activities.write'
  | 'webhook.incoming'
  | 'messages.read'
  | 'applications.builds.upload'
  | 'applications.builds.read'
  | 'applications.commands'
  | 'applications.commands.permissions.update'
  | 'applications.commands.update'
  | 'applications.store.update'
  | 'applications.entitlements'
  | 'activities.read'
  | 'activities.write'
  | 'relationships.read'
  | 'voice'
  | 'dm_channels.read'
  | 'role_connections.write';

export type OnboardingPromptOptionRequest = {
  id?: null | SnowflakeType;
  title: string;
  description?: string | null;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
  emoji_animated?: boolean | null;
  role_ids?: Array<SnowflakeType> | null;
  channel_ids?: Array<SnowflakeType> | null;
};

export type OnboardingPromptOptionResponse = {
  id: SnowflakeType;
  title: string;
  description: string;
  emoji: SettingsEmojiResponse;
  role_ids: Array<SnowflakeType>;
  channel_ids: Array<SnowflakeType>;
};

export type OnboardingPromptResponse = {
  id: SnowflakeType;
  title: string;
  options: Array<OnboardingPromptOptionResponse>;
  single_select: boolean;
  required: boolean;
  in_onboarding: boolean;
  type: OnboardingPromptType;
};

export type OnboardingPromptType = 0 | 1;

export type PartialDiscordIntegrationResponse = {
  id: SnowflakeType;
  type: 'discord';
  name?: string | null;
  account?: null | AccountResponse;
  application_id: SnowflakeType;
};

export type PartialExternalConnectionIntegrationResponse = {
  id: SnowflakeType;
  type: 'twitch' | 'youtube';
  name?: string | null;
  account?: null | AccountResponse;
};

export type PartialGuildSubscriptionIntegrationResponse = {
  id: SnowflakeType;
  type: 'guild_subscription';
  name?: string | null;
  account?: null | AccountResponse;
};

export type PongInteractionCallbackRequest = {
  type: 1;
};

export type PremiumGuildTiers = 0 | 1 | 2 | 3;

export type PremiumTypes = 0 | 1 | 2 | 3;

export type PrivateApplicationResponse = {
  id: SnowflakeType;
  name: string;
  icon?: string | null;
  description: string;
  type?: null | ApplicationTypes;
  cover_image?: string | null;
  primary_sku_id?: null | SnowflakeType;
  bot?: null | UserResponse;
  slug?: string | null;
  guild_id?: null | SnowflakeType;
  rpc_origins?: Array<string | null> | null;
  bot_public?: boolean | null;
  bot_require_code_grant?: boolean | null;
  terms_of_service_url?: string | null;
  privacy_policy_url?: string | null;
  custom_install_url?: string | null;
  install_params?: null | ApplicationOAuth2ParamsResponse;
  verify_key: string;
  flags: number;
  max_participants?: number | null;
  tags?: Array<string> | null;
  redirect_uris: Array<string | null>;
  interactions_endpoint_url?: string | null;
  role_connections_verification_url?: string | null;
  owner: UserResponse;
  approximate_guild_count?: number | null;
  team?: null | TeamResponse;
};

export type PrivateChannelRequestPartial = {
  name?: string | null;
  icon?: string | null;
};

export type PrivateChannelResponse = {
  id: SnowflakeType;
  type: 1;
  last_message_id?: null | SnowflakeType;
  flags: number;
  last_pin_timestamp?: string | null;
  recipients: Array<UserResponse>;
};

export type PrivateGroupChannelResponse = {
  id: SnowflakeType;
  type: 3;
  last_message_id?: null | SnowflakeType;
  flags: number;
  last_pin_timestamp?: string | null;
  recipients: Array<UserResponse>;
  name?: string | null;
  icon?: string | null;
  owner_id?: null | SnowflakeType;
  managed?: boolean | null;
  application_id?: null | SnowflakeType;
};

export type PrivateGuildMemberResponse = {
  avatar?: string | null;
  communication_disabled_until?: string | null;
  flags: number;
  joined_at: string;
  nick?: string | null;
  pending: boolean;
  premium_since?: string | null;
  roles: Array<SnowflakeType>;
  user: UserResponse;
  mute: boolean;
  deaf: boolean;
  banner?: string | null;
};

export type PurchaseNotificationResponse = {
  type: PurchaseType;
  guild_product_purchase?: null | GuildProductPurchaseResponse;
};

export type PurchaseType = number;

export type QuarantineUserAction = {
  type: 4;
  metadata?: null | QuarantineUserActionMetadata;
};

export type QuarantineUserActionMetadata = {
  [key: string]: unknown;
};

export type QuarantineUserActionMetadataResponse = {
  [key: string]: unknown;
};

export type QuarantineUserActionResponse = {
  type: 4;
  metadata: QuarantineUserActionMetadataResponse;
};

export type ReplyMessageReferenceRequest = {
  guild_id?: null | SnowflakeType;
  channel_id?: null | SnowflakeType;
  message_id: SnowflakeType;
  fail_if_not_exists?: boolean | null;
};

export type ResolvedObjectsResponse = {
  users: {
    [key: string]: UserResponse;
  };
  members: {
    [key: string]: GuildMemberResponse;
  };
  channels: {
    [key: string]: GuildChannelResponse | PrivateChannelResponse | PrivateGroupChannelResponse | ThreadResponse;
  };
  roles: {
    [key: string]: GuildRoleResponse;
  };
};

export type ResourceChannelResponse = {
  channel_id: SnowflakeType;
  title: string;
  emoji?: null | SettingsEmojiResponse;
  icon?: string | null;
  description: string;
};

export type RichEmbed = {
  type?: string | null;
  url?: string | null;
  title?: string | null;
  color?: number | null;
  timestamp?: string | null;
  description?: string | null;
  author?: null | RichEmbedAuthor;
  image?: null | RichEmbedImage;
  thumbnail?: null | RichEmbedThumbnail;
  footer?: null | RichEmbedFooter;
  fields?: Array<RichEmbedField> | null;
  provider?: null | RichEmbedProvider;
  video?: null | RichEmbedVideo;
};

export type RichEmbedAuthor = {
  name?: string | null;
  url?: string | null;
  icon_url?: string | null;
};

export type RichEmbedField = {
  name: string;
  value: string;
  inline?: boolean | null;
};

export type RichEmbedFooter = {
  text?: string | null;
  icon_url?: string | null;
};

export type RichEmbedImage = {
  url?: string | null;
  width?: number | null;
  height?: number | null;
  placeholder?: string | null;
  placeholder_version?: number | null;
};

export type RichEmbedProvider = {
  name?: string | null;
  url?: string | null;
};

export type RichEmbedThumbnail = {
  url?: string | null;
  width?: number | null;
  height?: number | null;
  placeholder?: string | null;
  placeholder_version?: number | null;
};

export type RichEmbedVideo = {
  url?: string | null;
  width?: number | null;
  height?: number | null;
  placeholder?: string | null;
  placeholder_version?: number | null;
};

export type RoleSelect = {
  type: 6;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  default_values?: Array<RoleSelectDefaultValue> | null;
};

export type RoleSelectDefaultValue = {
  type: SnowflakeSelectDefaultValueTypes;
  id: SnowflakeType;
};

export type ScheduledEventResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  name: string;
  description?: string | null;
  channel_id?: null | SnowflakeType;
  creator_id?: null | SnowflakeType;
  creator?: null | UserResponse;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  status: GuildScheduledEventStatuses;
  entity_type: GuildScheduledEventEntityTypes;
  entity_id?: null | SnowflakeType;
  user_count?: number | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  user_rsvp?: null | ScheduledEventUserResponse;
};

export type ScheduledEventUserResponse = {
  guild_scheduled_event_id: SnowflakeType;
  user_id: SnowflakeType;
  user?: null | UserResponse;
  member?: null | GuildMemberResponse;
};

export type SelectOption = {
  label: string;
  value: string;
  description?: string | null;
  emoji?: null | Emoji;
  default?: boolean | null;
};

export type SelectOptionResponse = {
  label: string;
  value: string;
  description?: string | null;
  emoji?: null | MessageComponentEmojiResponse;
  default?: boolean | null;
};

export type SettingsEmojiResponse = {
  id?: null | SnowflakeType;
  name?: string | null;
  animated?: boolean | null;
};

export type SlackWebhook = {
  text?: string | null;
  username?: string | null;
  icon_url?: string | null;
  attachments?: Array<WebhookSlackEmbed> | null;
};

export type SnowflakeSelectDefaultValueTypes = string;

export type SnowflakeType = string;

export type SpamLinkRuleResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  creator_id: SnowflakeType;
  name: string;
  event_type: AutomodEventType;
  actions: Array<
    | BlockMessageActionResponse
    | FlagToChannelActionResponse
    | QuarantineUserActionResponse
    | UserCommunicationDisabledActionResponse
  >;
  trigger_type: 2;
  enabled?: boolean | null;
  exempt_roles?: Array<SnowflakeType> | null;
  exempt_channels?: Array<SnowflakeType> | null;
  trigger_metadata: SpamLinkTriggerMetadataResponse;
};

export type trigger_type5 = 2;

export type SpamLinkTriggerMetadataResponse = {
  [key: string]: unknown;
};

export type StageInstanceResponse = {
  guild_id: SnowflakeType;
  channel_id: SnowflakeType;
  topic: string;
  privacy_level: StageInstancesPrivacyLevels;
  id: SnowflakeType;
  discoverable_disabled?: boolean | null;
  guild_scheduled_event_id?: null | SnowflakeType;
};

export type StageInstancesPrivacyLevels = 1 | 2;

export type StageScheduledEventCreateRequest = {
  name: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  entity_type: 1;
  channel_id?: null | SnowflakeType;
  entity_metadata?: null | EntityMetadataStageInstance;
};

export type entity_type2 = 1;

export type StageScheduledEventPatchRequestPartial = {
  status?: null | GuildScheduledEventStatuses;
  name?: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time?: string;
  scheduled_end_time?: string | null;
  entity_type?: null | 1;
  privacy_level?: GuildScheduledEventPrivacyLevels;
  channel_id?: null | SnowflakeType;
  entity_metadata?: null | EntityMetadataStageInstance;
};

export type StageScheduledEventResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  name: string;
  description?: string | null;
  channel_id?: null | SnowflakeType;
  creator_id?: null | SnowflakeType;
  creator?: null | UserResponse;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  status: GuildScheduledEventStatuses;
  entity_type: 1;
  entity_id?: null | SnowflakeType;
  user_count?: number | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  user_rsvp?: null | ScheduledEventUserResponse;
  entity_metadata?: null | EntityMetadataStageInstanceResponse;
};

export type StandardStickerResponse = {
  id: SnowflakeType;
  name: string;
  tags: string;
  type: 1;
  format_type?: null | StickerFormatTypes;
  description?: string | null;
  pack_id: SnowflakeType;
  sort_value: number;
};

export type StickerFormatTypes = 1 | 2 | 3 | 4;

export type StickerPackCollectionResponse = {
  sticker_packs: Array<StickerPackResponse>;
};

export type StickerPackResponse = {
  id: SnowflakeType;
  sku_id: SnowflakeType;
  name: string;
  description?: string | null;
  stickers: Array<StandardStickerResponse>;
  cover_sticker_id?: null | SnowflakeType;
  banner_asset_id?: null | SnowflakeType;
};

export type StickerTypes = 1 | 2;

export type StringSelect = {
  type: 3;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  options: Array<SelectOption>;
};

export type TeamMemberResponse = {
  user: UserResponse;
  team_id: SnowflakeType;
  membership_state: TeamMembershipStates;
};

export type TeamMembershipStates = 1 | 2;

export type TeamResponse = {
  id: SnowflakeType;
  icon?: string | null;
  name: string;
  owner_user_id: SnowflakeType;
  members: Array<TeamMemberResponse>;
};

export type TextStyleTypes = 1 | 2;

export type ThreadAutoArchiveDuration = 60 | 1440 | 4320 | 10080;

export type ThreadMemberResponse = {
  id: SnowflakeType;
  user_id: SnowflakeType;
  join_timestamp: string;
  flags: number;
  member?: null | GuildMemberResponse;
};

export type ThreadMetadataResponse = {
  archived: boolean;
  archive_timestamp?: string | null;
  auto_archive_duration: ThreadAutoArchiveDuration;
  locked: boolean;
  create_timestamp?: string | null;
  invitable?: boolean | null;
};

export type ThreadResponse = {
  id: SnowflakeType;
  type: 10 | 11 | 12;
  last_message_id?: null | SnowflakeType;
  flags: number;
  last_pin_timestamp?: string | null;
  guild_id: SnowflakeType;
  name: string;
  parent_id?: null | SnowflakeType;
  rate_limit_per_user?: number | null;
  bitrate?: number | null;
  user_limit?: number | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  permissions?: string | null;
  owner_id: SnowflakeType;
  thread_metadata?: null | ThreadMetadataResponse;
  message_count: number;
  member_count: number;
  total_message_sent: number;
  applied_tags?: Array<SnowflakeType> | null;
  member?: null | ThreadMemberResponse;
};

export type ThreadSortOrder = 0 | 1;

export type ThreadsResponse = {
  threads: Array<ThreadResponse>;
  members: Array<ThreadMemberResponse>;
  has_more?: boolean | null;
};

export type TypingIndicatorResponse = {
  [key: string]: unknown;
};

export type UInt32Type = number;

export type UpdateDefaultReactionEmojiRequest = {
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
};

export type UpdateGuildChannelRequestPartial = {
  type?: null | 0 | 2 | 4 | 5 | 13 | 14 | 15;
  name?: string;
  position?: number | null;
  topic?: string | null;
  bitrate?: number | null;
  user_limit?: number | null;
  nsfw?: boolean | null;
  rate_limit_per_user?: number | null;
  parent_id?: null | SnowflakeType;
  permission_overwrites?: Array<ChannelPermissionOverwriteRequest> | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
  default_auto_archive_duration?: null | ThreadAutoArchiveDuration;
  default_reaction_emoji?: null | UpdateDefaultReactionEmojiRequest;
  default_thread_rate_limit_per_user?: number | null;
  default_sort_order?: null | ThreadSortOrder;
  default_forum_layout?: null | ForumLayout;
  flags?: number | null;
  available_tags?: Array<UpdateThreadTagRequest> | null;
};

export type UpdateGuildOnboardingRequest = {
  prompts?: Array<UpdateOnboardingPromptRequest> | null;
  enabled?: boolean | null;
  default_channel_ids?: Array<SnowflakeType> | null;
  mode?: null | GuildOnboardingMode;
};

export type UpdateMessageInteractionCallbackRequest = {
  type: 6 | 7;
  data?: null | IncomingWebhookUpdateForInteractionCallbackRequestPartial;
};

export type type19 = 6 | 7;

export type UpdateOnboardingPromptRequest = {
  title: string;
  options: Array<OnboardingPromptOptionRequest>;
  single_select?: boolean | null;
  required?: boolean | null;
  in_onboarding?: boolean | null;
  type?: null | OnboardingPromptType;
  id: SnowflakeType;
};

export type UpdateThreadRequestPartial = {
  name?: string | null;
  archived?: boolean | null;
  locked?: boolean | null;
  invitable?: boolean | null;
  auto_archive_duration?: null | ThreadAutoArchiveDuration;
  rate_limit_per_user?: number | null;
  flags?: number | null;
  applied_tags?: Array<SnowflakeType> | null;
  bitrate?: number | null;
  user_limit?: number | null;
  rtc_region?: string | null;
  video_quality_mode?: null | VideoQualityModes;
};

export type UpdateThreadTagRequest = {
  name: string;
  emoji_id?: null | SnowflakeType;
  emoji_name?: string | null;
  moderated?: boolean | null;
  id?: null | SnowflakeType;
};

export type UserCommunicationDisabledAction = {
  type: 3;
  metadata: UserCommunicationDisabledActionMetadata;
};

export type UserCommunicationDisabledActionMetadata = {
  duration_seconds: number;
};

export type UserCommunicationDisabledActionMetadataResponse = {
  duration_seconds: number;
};

export type UserCommunicationDisabledActionResponse = {
  type: 3;
  metadata: UserCommunicationDisabledActionMetadataResponse;
};

export type UserGuildOnboardingResponse = {
  guild_id: SnowflakeType;
  prompts: Array<OnboardingPromptResponse>;
  default_channel_ids: Array<SnowflakeType>;
  enabled: boolean;
};

export type UserNotificationSettings = 0 | 1;

export type UserPIIResponse = {
  id: SnowflakeType;
  username: string;
  avatar?: string | null;
  discriminator: string;
  public_flags: number;
  premium_type?: null | PremiumTypes;
  flags: Int53Type;
  bot?: boolean | null;
  system?: boolean | null;
  banner?: string | null;
  accent_color?: number | null;
  global_name?: string | null;
  mfa_enabled: boolean;
  locale: AvailableLocalesEnum;
  email?: string | null;
  verified?: boolean | null;
};

export type UserResponse = {
  id: SnowflakeType;
  username: string;
  avatar?: string | null;
  discriminator: string;
  public_flags: number;
  premium_type?: null | PremiumTypes;
  flags: Int53Type;
  bot?: boolean | null;
  system?: boolean | null;
  banner?: string | null;
  accent_color?: number | null;
  global_name?: string | null;
};

export type UserSelect = {
  type: 5;
  custom_id: string;
  placeholder?: string | null;
  min_values?: number | null;
  max_values?: number | null;
  disabled?: boolean | null;
  default_values?: Array<UserSelectDefaultValue> | null;
};

export type UserSelectDefaultValue = {
  type: SnowflakeSelectDefaultValueTypes;
  id: SnowflakeType;
};

export type VanityURLErrorResponse = {
  message: string;
  code: number;
};

export type VanityURLResponse = {
  code?: string | null;
  uses: number;
  error?: null | VanityURLErrorResponse;
};

export type VerificationLevels = 0 | 1 | 2 | 3 | 4;

export type VideoQualityModes = 1 | 2;

export type VoiceRegionResponse = {
  id: string;
  name: string;
  custom: boolean;
  deprecated: boolean;
  optimal: boolean;
};

export type VoiceScheduledEventCreateRequest = {
  name: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  entity_type: 2;
  channel_id?: null | SnowflakeType;
  entity_metadata?: null | EntityMetadataVoice;
};

export type entity_type3 = 2;

export type VoiceScheduledEventPatchRequestPartial = {
  status?: null | GuildScheduledEventStatuses;
  name?: string;
  description?: string | null;
  image?: string | null;
  scheduled_start_time?: string;
  scheduled_end_time?: string | null;
  entity_type?: null | 2;
  privacy_level?: GuildScheduledEventPrivacyLevels;
  channel_id?: null | SnowflakeType;
  entity_metadata?: null | EntityMetadataVoice;
};

export type VoiceScheduledEventResponse = {
  id: SnowflakeType;
  guild_id: SnowflakeType;
  name: string;
  description?: string | null;
  channel_id?: null | SnowflakeType;
  creator_id?: null | SnowflakeType;
  creator?: null | UserResponse;
  image?: string | null;
  scheduled_start_time: string;
  scheduled_end_time?: string | null;
  status: GuildScheduledEventStatuses;
  entity_type: 2;
  entity_id?: null | SnowflakeType;
  user_count?: number | null;
  privacy_level: GuildScheduledEventPrivacyLevels;
  user_rsvp?: null | ScheduledEventUserResponse;
  entity_metadata?: null | EntityMetadataVoiceResponse;
};

export type WebhookSlackEmbed = {
  title?: string | null;
  title_link?: string | null;
  text?: string | null;
  color?: string | null;
  ts?: number | null;
  pretext?: string | null;
  footer?: string | null;
  footer_icon?: string | null;
  author_name?: string | null;
  author_link?: string | null;
  author_icon?: string | null;
  image_url?: string | null;
  thumb_url?: string | null;
  fields?: Array<WebhookSlackEmbedField> | null;
};

export type WebhookSlackEmbedField = {
  name?: string | null;
  value?: string | null;
  inline?: boolean | null;
};

export type WebhookSourceChannelResponse = {
  id: SnowflakeType;
  name: string;
};

export type WebhookSourceGuildResponse = {
  id: SnowflakeType;
  icon?: string | null;
  name: string;
};

export type WebhookTypes = 1 | 2 | 3;

export type WelcomeMessageResponse = {
  author_ids: Array<SnowflakeType>;
  message: string;
};

export type WelcomeScreenPatchRequestPartial = {
  description?: string | null;
  welcome_channels?: Array<GuildWelcomeChannel> | null;
  enabled?: boolean | null;
};

export type WidgetActivity = {
  name: string;
};

export type WidgetChannel = {
  id: SnowflakeType;
  name: string;
  position: number;
};

export type WidgetImageStyles = 'shield' | 'banner1' | 'banner2' | 'banner3' | 'banner4';

export type WidgetMember = {
  id: string;
  username: string;
  discriminator: WidgetUserDiscriminator;
  avatar?: null;
  status: string;
  avatar_url: string;
  activity?: null | WidgetActivity;
  deaf?: boolean | null;
  mute?: boolean | null;
  self_deaf?: boolean | null;
  self_mute?: boolean | null;
  suppress?: boolean | null;
  channel_id?: null | SnowflakeType;
};

export type WidgetResponse = {
  id: SnowflakeType;
  name: string;
  instant_invite?: string | null;
  channels: Array<WidgetChannel>;
  members: Array<WidgetMember>;
  presence_count: number;
};

export type WidgetSettingsResponse = {
  enabled: boolean;
  channel_id?: null | SnowflakeType;
};

export type WidgetUserDiscriminator = '0000';

/**
 * A single error, either for an API response or a specific field.
 */
export type Error = {
  /**
   * Discord internal error code. See error code reference
   */
  code: number;
  /**
   * Human-readable error message
   */
  message: string;
};

export type InnerErrors = {
  /**
   * The list of errors for this field
   */
  _errors: Array<Error>;
};

export type ErrorDetails =
  | {
      [key: string]: ErrorDetails;
    }
  | InnerErrors;

/**
 * Errors object returned by the Discord API
 */
export type ErrorResponse = Error & {
  errors?: ErrorDetails;
};

export type GetMyOauth2ApplicationResponse = PrivateApplicationResponse;

export type GetMyOauth2ApplicationError = ErrorResponse;

export type ListMyConnectionsResponse = Array<ConnectedAccountResponse> | null;

export type ListMyConnectionsError = ErrorResponse;

export type CreateDmData = {
  body: CreatePrivateChannelRequest;
};

export type CreateDmResponse = PrivateChannelResponse | PrivateGroupChannelResponse;

export type CreateDmError = ErrorResponse;

export type ListMyGuildsData = {
  query?: {
    after?: SnowflakeType;
    before?: SnowflakeType;
    limit?: number;
    with_counts?: boolean;
  };
};

export type ListMyGuildsResponse = Array<MyGuildResponse> | null;

export type ListMyGuildsError = ErrorResponse;

export type GetMyApplicationResponse = PrivateApplicationResponse;

export type GetMyApplicationError = ErrorResponse;

export type UpdateMyApplicationData = {
  body: ApplicationFormPartial;
};

export type UpdateMyApplicationResponse = PrivateApplicationResponse;

export type UpdateMyApplicationError = ErrorResponse;

export type GetBotGatewayResponse = GatewayBotResponse;

export type GetBotGatewayError = ErrorResponse;

export type GetMyOauth2AuthorizationResponse = OAuth2GetAuthorizationResponse;

export type GetMyOauth2AuthorizationError = ErrorResponse;

export type ListVoiceRegionsResponse = Array<VoiceRegionResponse> | null;

export type ListVoiceRegionsError = ErrorResponse;

export type GetMyUserResponse = UserPIIResponse;

export type GetMyUserError = ErrorResponse;

export type UpdateMyUserData = {
  body: BotAccountPatchRequest;
};

export type UpdateMyUserResponse = UserPIIResponse;

export type UpdateMyUserError = ErrorResponse;

export type CreateStageInstanceData = {
  body: {
    topic: string;
    channel_id: SnowflakeType;
    privacy_level?: null | StageInstancesPrivacyLevels;
    guild_scheduled_event_id?: null | SnowflakeType;
    send_start_notification?: boolean | null;
  };
};

export type CreateStageInstanceResponse = StageInstanceResponse;

export type CreateStageInstanceError = ErrorResponse;

export type ListStickerPacksResponse = StickerPackCollectionResponse;

export type ListStickerPacksError = ErrorResponse;

export type GetGatewayResponse = GatewayResponse;

export type GetGatewayError = ErrorResponse;

export type CreateGuildData = {
  body: GuildCreateRequest;
};

export type CreateGuildResponse = GuildResponse;

export type CreateGuildError = ErrorResponse;

export type ListMyPrivateArchivedThreadsData = {
  path: {
    channel_id: SnowflakeType;
  };
  query?: {
    before?: SnowflakeType;
    limit?: number;
  };
};

export type ListMyPrivateArchivedThreadsResponse = ThreadsResponse;

export type ListMyPrivateArchivedThreadsError = ErrorResponse;

export type ListGuildApplicationCommandPermissionsData = {
  path: {
    application_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type ListGuildApplicationCommandPermissionsResponse = Array<CommandPermissionsResponse>;

export type ListGuildApplicationCommandPermissionsError = ErrorResponse;

export type GetGuildApplicationCommandPermissionsData = {
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type GetGuildApplicationCommandPermissionsResponse = CommandPermissionsResponse;

export type GetGuildApplicationCommandPermissionsError = ErrorResponse;

export type SetGuildApplicationCommandPermissionsData = {
  body: {
    permissions?: Array<ApplicationCommandPermission> | null;
  };
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type SetGuildApplicationCommandPermissionsResponse = CommandPermissionsResponse;

export type SetGuildApplicationCommandPermissionsError = ErrorResponse;

export type AddMyMessageReactionData = {
  path: {
    channel_id: SnowflakeType;
    emoji_name: string;
    message_id: SnowflakeType;
  };
};

export type AddMyMessageReactionResponse = any;

export type AddMyMessageReactionError = ErrorResponse;

export type DeleteMyMessageReactionData = {
  path: {
    channel_id: SnowflakeType;
    emoji_name: string;
    message_id: SnowflakeType;
  };
};

export type DeleteMyMessageReactionResponse = any;

export type DeleteMyMessageReactionError = ErrorResponse;

export type ListPrivateArchivedThreadsData = {
  path: {
    channel_id: SnowflakeType;
  };
  query?: {
    before?: string;
    limit?: number;
  };
};

export type ListPrivateArchivedThreadsResponse = ThreadsResponse;

export type ListPrivateArchivedThreadsError = ErrorResponse;

export type ListPublicArchivedThreadsData = {
  path: {
    channel_id: SnowflakeType;
  };
  query?: {
    before?: string;
    limit?: number;
  };
};

export type ListPublicArchivedThreadsResponse = ThreadsResponse;

export type ListPublicArchivedThreadsError = ErrorResponse;

export type GetApplicationUserRoleConnectionData = {
  path: {
    application_id: SnowflakeType;
  };
};

export type GetApplicationUserRoleConnectionResponse = ApplicationUserRoleConnectionResponse;

export type GetApplicationUserRoleConnectionError = ErrorResponse;

export type UpdateApplicationUserRoleConnectionData = {
  body: {
    platform_name?: string | null;
    platform_username?: string | null;
    metadata?: {
      [key: string]: string;
    } | null;
  };
  path: {
    application_id: SnowflakeType;
  };
};

export type UpdateApplicationUserRoleConnectionResponse = ApplicationUserRoleConnectionResponse;

export type UpdateApplicationUserRoleConnectionError = ErrorResponse;

export type GetMyGuildMemberData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetMyGuildMemberResponse = PrivateGuildMemberResponse;

export type GetMyGuildMemberError = ErrorResponse;

export type GetApplicationRoleConnectionsMetadataData = {
  path: {
    application_id: SnowflakeType;
  };
};

export type GetApplicationRoleConnectionsMetadataResponse =
  Array<ApplicationRoleConnectionsMetadataItemResponse> | null;

export type GetApplicationRoleConnectionsMetadataError = ErrorResponse;

export type UpdateApplicationRoleConnectionsMetadataData = {
  body: Array<ApplicationRoleConnectionsMetadataItemRequest> | null;
  path: {
    application_id: SnowflakeType;
  };
};

export type UpdateApplicationRoleConnectionsMetadataResponse =
  Array<ApplicationRoleConnectionsMetadataItemResponse> | null;

export type UpdateApplicationRoleConnectionsMetadataError = ErrorResponse;

export type GetGuildApplicationCommandData = {
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type GetGuildApplicationCommandResponse = ApplicationCommandResponse;

export type GetGuildApplicationCommandError = ErrorResponse;

export type DeleteGuildApplicationCommandData = {
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type DeleteGuildApplicationCommandResponse = any;

export type DeleteGuildApplicationCommandError = ErrorResponse;

export type UpdateGuildApplicationCommandData = {
  body: ApplicationCommandPatchRequestPartial;
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildApplicationCommandResponse = ApplicationCommandResponse;

export type UpdateGuildApplicationCommandError = ErrorResponse;

export type ListGuildApplicationCommandsData = {
  path: {
    application_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
  query?: {
    with_localizations?: boolean;
  };
};

export type ListGuildApplicationCommandsResponse = Array<ApplicationCommandResponse> | null;

export type ListGuildApplicationCommandsError = ErrorResponse;

export type BulkSetGuildApplicationCommandsData = {
  body: Array<ApplicationCommandUpdateRequest> | null;
  path: {
    application_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type BulkSetGuildApplicationCommandsResponse = Array<ApplicationCommandResponse> | null;

export type BulkSetGuildApplicationCommandsError = ErrorResponse;

export type CreateGuildApplicationCommandData = {
  body: ApplicationCommandCreateRequest;
  path: {
    application_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type CreateGuildApplicationCommandResponse = ApplicationCommandResponse;

export type CreateGuildApplicationCommandError = ErrorResponse;

export type JoinThreadData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type JoinThreadResponse = any;

export type JoinThreadError = ErrorResponse;

export type LeaveThreadData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type LeaveThreadResponse = any;

export type LeaveThreadError = ErrorResponse;

export type BulkDeleteMessagesData = {
  body: {
    messages: Array<SnowflakeType>;
  };
  path: {
    channel_id: SnowflakeType;
  };
};

export type BulkDeleteMessagesResponse = any;

export type BulkDeleteMessagesError = ErrorResponse;

export type DeleteUserMessageReactionData = {
  path: {
    channel_id: SnowflakeType;
    emoji_name: string;
    message_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type DeleteUserMessageReactionResponse = any;

export type DeleteUserMessageReactionError = ErrorResponse;

export type ListMessageReactionsByEmojiData = {
  path: {
    channel_id: SnowflakeType;
    emoji_name: string;
    message_id: SnowflakeType;
  };
  query?: {
    after?: SnowflakeType;
    limit?: number;
  };
};

export type ListMessageReactionsByEmojiResponse = Array<UserResponse>;

export type ListMessageReactionsByEmojiError = ErrorResponse;

export type DeleteAllMessageReactionsByEmojiData = {
  path: {
    channel_id: SnowflakeType;
    emoji_name: string;
    message_id: SnowflakeType;
  };
};

export type DeleteAllMessageReactionsByEmojiResponse = any;

export type DeleteAllMessageReactionsByEmojiError = ErrorResponse;

export type DeleteAllMessageReactionsData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type DeleteAllMessageReactionsResponse = any;

export type DeleteAllMessageReactionsError = ErrorResponse;

export type CrosspostMessageData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type CrosspostMessageResponse = MessageResponse;

export type CrosspostMessageError = ErrorResponse;

export type CreateThreadFromMessageData = {
  body: CreateTextThreadWithMessageRequest;
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type CreateThreadFromMessageResponse = ThreadResponse;

export type CreateThreadFromMessageError = ErrorResponse;

export type GetOriginalWebhookMessageData = {
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type GetOriginalWebhookMessageResponse = MessageResponse;

export type GetOriginalWebhookMessageError = ErrorResponse;

export type DeleteOriginalWebhookMessageData = {
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type DeleteOriginalWebhookMessageResponse = any;

export type DeleteOriginalWebhookMessageError = ErrorResponse;

export type UpdateOriginalWebhookMessageData = {
  body: IncomingWebhookUpdateRequestPartial;
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type UpdateOriginalWebhookMessageResponse = MessageResponse;

export type UpdateOriginalWebhookMessageError = ErrorResponse;

export type ListGuildScheduledEventUsersData = {
  path: {
    guild_id: SnowflakeType;
    guild_scheduled_event_id: SnowflakeType;
  };
  query?: {
    after?: SnowflakeType;
    before?: SnowflakeType;
    limit?: number;
    with_member?: boolean;
  };
};

export type ListGuildScheduledEventUsersResponse = Array<ScheduledEventUserResponse> | null;

export type ListGuildScheduledEventUsersError = ErrorResponse;

export type GetAutoModerationRuleData = {
  path: {
    guild_id: SnowflakeType;
    rule_id: SnowflakeType;
  };
};

export type GetAutoModerationRuleResponse =
  | DefaultKeywordRuleResponse
  | KeywordRuleResponse
  | MLSpamRuleResponse
  | MentionSpamRuleResponse
  | SpamLinkRuleResponse;

export type GetAutoModerationRuleError = ErrorResponse;

export type DeleteAutoModerationRuleData = {
  path: {
    guild_id: SnowflakeType;
    rule_id: SnowflakeType;
  };
};

export type DeleteAutoModerationRuleResponse = any;

export type DeleteAutoModerationRuleError = ErrorResponse;

export type UpdateAutoModerationRuleData = {
  body:
    | DefaultKeywordListUpsertRequestPartial
    | KeywordUpsertRequestPartial
    | MLSpamUpsertRequestPartial
    | MentionSpamUpsertRequestPartial;
  path: {
    guild_id: SnowflakeType;
    rule_id: SnowflakeType;
  };
};

export type UpdateAutoModerationRuleResponse =
  | DefaultKeywordRuleResponse
  | KeywordRuleResponse
  | MLSpamRuleResponse
  | MentionSpamRuleResponse
  | SpamLinkRuleResponse;

export type UpdateAutoModerationRuleError = ErrorResponse;

export type ListAutoModerationRulesData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListAutoModerationRulesResponse = Array<
  | DefaultKeywordRuleResponse
  | KeywordRuleResponse
  | MLSpamRuleResponse
  | MentionSpamRuleResponse
  | SpamLinkRuleResponse
  | null
> | null;

export type ListAutoModerationRulesError = ErrorResponse;

export type CreateAutoModerationRuleData = {
  body: DefaultKeywordListUpsertRequest | KeywordUpsertRequest | MLSpamUpsertRequest | MentionSpamUpsertRequest;
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateAutoModerationRuleResponse =
  | DefaultKeywordRuleResponse
  | KeywordRuleResponse
  | MLSpamRuleResponse
  | MentionSpamRuleResponse
  | SpamLinkRuleResponse;

export type CreateAutoModerationRuleError = ErrorResponse;

export type UpdateSelfVoiceStateData = {
  body: {
    request_to_speak_timestamp?: string | null;
    suppress?: boolean | null;
    channel_id?: null | SnowflakeType;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type UpdateSelfVoiceStateResponse = any;

export type UpdateSelfVoiceStateError = ErrorResponse;

export type SearchGuildMembersData = {
  path: {
    guild_id: SnowflakeType;
  };
  query: {
    limit: number;
    query: string;
  };
};

export type SearchGuildMembersResponse = Array<GuildMemberResponse>;

export type SearchGuildMembersError = ErrorResponse;

export type GetActiveGuildThreadsData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetActiveGuildThreadsResponse = ThreadsResponse;

export type GetActiveGuildThreadsError = ErrorResponse;

export type UpdateMyGuildMemberData = {
  body: {
    nick?: string | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type UpdateMyGuildMemberResponse = PrivateGuildMemberResponse;

export type UpdateMyGuildMemberError = ErrorResponse;

export type AddGuildMemberRoleData = {
  path: {
    guild_id: SnowflakeType;
    role_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type AddGuildMemberRoleResponse = any;

export type AddGuildMemberRoleError = ErrorResponse;

export type DeleteGuildMemberRoleData = {
  path: {
    guild_id: SnowflakeType;
    role_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type DeleteGuildMemberRoleResponse = any;

export type DeleteGuildMemberRoleError = ErrorResponse;

export type LeaveGuildData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type LeaveGuildResponse = any;

export type LeaveGuildError = ErrorResponse;

export type GetApplicationCommandData = {
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
  };
};

export type GetApplicationCommandResponse = ApplicationCommandResponse;

export type GetApplicationCommandError = ErrorResponse;

export type DeleteApplicationCommandData = {
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
  };
};

export type DeleteApplicationCommandResponse = any;

export type DeleteApplicationCommandError = ErrorResponse;

export type UpdateApplicationCommandData = {
  body: ApplicationCommandPatchRequestPartial;
  path: {
    application_id: SnowflakeType;
    command_id: SnowflakeType;
  };
};

export type UpdateApplicationCommandResponse = ApplicationCommandResponse;

export type UpdateApplicationCommandError = ErrorResponse;

export type ListApplicationCommandsData = {
  path: {
    application_id: SnowflakeType;
  };
  query?: {
    with_localizations?: boolean;
  };
};

export type ListApplicationCommandsResponse = Array<ApplicationCommandResponse> | null;

export type ListApplicationCommandsError = ErrorResponse;

export type BulkSetApplicationCommandsData = {
  body: Array<ApplicationCommandUpdateRequest> | null;
  path: {
    application_id: SnowflakeType;
  };
};

export type BulkSetApplicationCommandsResponse = Array<ApplicationCommandResponse> | null;

export type BulkSetApplicationCommandsError = ErrorResponse;

export type CreateApplicationCommandData = {
  body: ApplicationCommandCreateRequest;
  path: {
    application_id: SnowflakeType;
  };
};

export type CreateApplicationCommandResponse = ApplicationCommandResponse;

export type CreateApplicationCommandError = ErrorResponse;

export type CreateInteractionResponseData = {
  body:
    | ApplicationCommandAutocompleteCallbackRequest
    | CreateMessageInteractionCallbackRequest
    | ModalInteractionCallbackRequest
    | PongInteractionCallbackRequest
    | UpdateMessageInteractionCallbackRequest;
  path: {
    interaction_id: SnowflakeType;
    interaction_token: string;
  };
};

export type CreateInteractionResponseResponse = any;

export type CreateInteractionResponseError = ErrorResponse;

export type GetThreadMemberData = {
  path: {
    channel_id: SnowflakeType;
    user_id: SnowflakeType;
  };
  query?: {
    with_member?: boolean;
  };
};

export type GetThreadMemberResponse = ThreadMemberResponse;

export type GetThreadMemberError = ErrorResponse;

export type AddThreadMemberData = {
  path: {
    channel_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type AddThreadMemberResponse = any;

export type AddThreadMemberError = ErrorResponse;

export type DeleteThreadMemberData = {
  path: {
    channel_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type DeleteThreadMemberResponse = any;

export type DeleteThreadMemberError = ErrorResponse;

export type ListThreadMembersData = {
  path: {
    channel_id: SnowflakeType;
  };
  query?: {
    after?: SnowflakeType;
    limit?: number;
    with_member?: boolean;
  };
};

export type ListThreadMembersResponse = Array<ThreadMemberResponse>;

export type ListThreadMembersError = ErrorResponse;

export type SetChannelPermissionOverwriteData = {
  body: {
    type?: null | ChannelPermissionOverwrites;
    allow?: number | null;
    deny?: number | null;
  };
  path: {
    channel_id: SnowflakeType;
    overwrite_id: SnowflakeType;
  };
};

export type SetChannelPermissionOverwriteResponse = any;

export type SetChannelPermissionOverwriteError = ErrorResponse;

export type DeleteChannelPermissionOverwriteData = {
  path: {
    channel_id: SnowflakeType;
    overwrite_id: SnowflakeType;
  };
};

export type DeleteChannelPermissionOverwriteResponse = any;

export type DeleteChannelPermissionOverwriteError = ErrorResponse;

export type AddGroupDmUserData = {
  body: {
    access_token?: string | null;
    nick?: string | null;
  };
  path: {
    channel_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type AddGroupDmUserResponse = (PrivateChannelResponse | PrivateGroupChannelResponse) | any;

export type AddGroupDmUserError = ErrorResponse;

export type DeleteGroupDmUserData = {
  path: {
    channel_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type DeleteGroupDmUserResponse = any;

export type DeleteGroupDmUserError = ErrorResponse;

export type FollowChannelData = {
  body: {
    webhook_channel_id: SnowflakeType;
  };
  path: {
    channel_id: SnowflakeType;
  };
};

export type FollowChannelResponse = ChannelFollowerResponse;

export type FollowChannelError = ErrorResponse;

export type GetMessageData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type GetMessageResponse = MessageResponse;

export type GetMessageError = ErrorResponse;

export type DeleteMessageData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type DeleteMessageResponse = any;

export type DeleteMessageError = ErrorResponse;

export type UpdateMessageData = {
  body: MessageEditRequestPartial;
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type UpdateMessageResponse = MessageResponse;

export type UpdateMessageError = ErrorResponse;

export type ListMessagesData = {
  path: {
    channel_id: SnowflakeType;
  };
  query?: {
    after?: SnowflakeType;
    around?: SnowflakeType;
    before?: SnowflakeType;
    limit?: number;
  };
};

export type ListMessagesResponse = Array<MessageResponse> | null;

export type ListMessagesError = ErrorResponse;

export type CreateMessageData = {
  body: MessageCreateRequest;
  path: {
    channel_id: SnowflakeType;
  };
};

export type CreateMessageResponse = MessageResponse;

export type CreateMessageError = ErrorResponse;

export type ListChannelWebhooksData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type ListChannelWebhooksResponse = Array<
  ApplicationIncomingWebhookResponse | ChannelFollowerWebhookResponse | GuildIncomingWebhookResponse
> | null;

export type ListChannelWebhooksError = ErrorResponse;

export type CreateWebhookData = {
  body: {
    name: string;
    avatar?: string | null;
  };
  path: {
    channel_id: SnowflakeType;
  };
};

export type CreateWebhookResponse = GuildIncomingWebhookResponse;

export type CreateWebhookError = ErrorResponse;

export type ListChannelInvitesData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type ListChannelInvitesResponse = Array<
  FriendInviteResponse | GroupDMInviteResponse | GuildInviteResponse
> | null;

export type ListChannelInvitesError = ErrorResponse;

export type CreateChannelInviteData = {
  body: CreateGroupDMInviteRequest | CreateGuildInviteRequest;
  path: {
    channel_id: SnowflakeType;
  };
};

export type CreateChannelInviteResponse = (FriendInviteResponse | GroupDMInviteResponse | GuildInviteResponse) | any;

export type CreateChannelInviteError = ErrorResponse;

export type CreateThreadData = {
  body: CreateForumThreadRequest | CreateTextThreadWithoutMessageRequest;
  path: {
    channel_id: SnowflakeType;
  };
};

export type CreateThreadResponse = CreatedThreadResponse;

export type CreateThreadError = ErrorResponse;

export type TriggerTypingIndicatorData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type TriggerTypingIndicatorResponse = TypingIndicatorResponse | any;

export type TriggerTypingIndicatorError = ErrorResponse;

export type PinMessageData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type PinMessageResponse = any;

export type PinMessageError = ErrorResponse;

export type UnpinMessageData = {
  path: {
    channel_id: SnowflakeType;
    message_id: SnowflakeType;
  };
};

export type UnpinMessageResponse = any;

export type UnpinMessageError = ErrorResponse;

export type ListPinnedMessagesData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type ListPinnedMessagesResponse = Array<MessageResponse> | null;

export type ListPinnedMessagesError = ErrorResponse;

export type GetWebhookMessageData = {
  path: {
    message_id: SnowflakeType;
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type GetWebhookMessageResponse = MessageResponse;

export type GetWebhookMessageError = ErrorResponse;

export type DeleteWebhookMessageData = {
  path: {
    message_id: SnowflakeType;
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type DeleteWebhookMessageResponse = any;

export type DeleteWebhookMessageError = ErrorResponse;

export type UpdateWebhookMessageData = {
  body: IncomingWebhookUpdateRequestPartial;
  path: {
    message_id: SnowflakeType;
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
  };
};

export type UpdateWebhookMessageResponse = MessageResponse;

export type UpdateWebhookMessageError = ErrorResponse;

export type ExecuteGithubCompatibleWebhookData = {
  body: GithubWebhook;
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
    wait?: boolean;
  };
};

export type ExecuteGithubCompatibleWebhookResponse = any;

export type ExecuteGithubCompatibleWebhookError = ErrorResponse;

export type ExecuteSlackCompatibleWebhookData = {
  body: SlackWebhook;
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
    wait?: boolean;
  };
};

export type ExecuteSlackCompatibleWebhookResponse = string | null;

export type ExecuteSlackCompatibleWebhookError = ErrorResponse;

export type GetGuildTemplateData = {
  path: {
    code: string;
  };
};

export type GetGuildTemplateResponse = GuildTemplateResponse;

export type GetGuildTemplateError = ErrorResponse;

export type CreateGuildFromTemplateData = {
  body: {
    name: string;
    icon?: string | null;
  };
  path: {
    code: string;
  };
};

export type CreateGuildFromTemplateResponse = GuildResponse;

export type CreateGuildFromTemplateError = ErrorResponse;

export type GetGuildNewMemberWelcomeData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildNewMemberWelcomeResponse = GuildHomeSettingsResponse | any;

export type GetGuildNewMemberWelcomeError = ErrorResponse;

export type GetGuildScheduledEventData = {
  path: {
    guild_id: SnowflakeType;
    guild_scheduled_event_id: SnowflakeType;
  };
  query?: {
    with_user_count?: boolean;
  };
};

export type GetGuildScheduledEventResponse =
  | ExternalScheduledEventResponse
  | StageScheduledEventResponse
  | VoiceScheduledEventResponse;

export type GetGuildScheduledEventError = ErrorResponse;

export type DeleteGuildScheduledEventData = {
  path: {
    guild_id: SnowflakeType;
    guild_scheduled_event_id: SnowflakeType;
  };
};

export type DeleteGuildScheduledEventResponse = any;

export type DeleteGuildScheduledEventError = ErrorResponse;

export type UpdateGuildScheduledEventData = {
  body:
    | ExternalScheduledEventPatchRequestPartial
    | StageScheduledEventPatchRequestPartial
    | VoiceScheduledEventPatchRequestPartial;
  path: {
    guild_id: SnowflakeType;
    guild_scheduled_event_id: SnowflakeType;
  };
};

export type UpdateGuildScheduledEventResponse =
  | ExternalScheduledEventResponse
  | StageScheduledEventResponse
  | VoiceScheduledEventResponse;

export type UpdateGuildScheduledEventError = ErrorResponse;

export type ListGuildScheduledEventsData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    with_user_count?: boolean;
  };
};

export type ListGuildScheduledEventsResponse = Array<
  ExternalScheduledEventResponse | StageScheduledEventResponse | VoiceScheduledEventResponse
> | null;

export type ListGuildScheduledEventsError = ErrorResponse;

export type CreateGuildScheduledEventData = {
  body: ExternalScheduledEventCreateRequest | StageScheduledEventCreateRequest | VoiceScheduledEventCreateRequest;
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildScheduledEventResponse =
  | ExternalScheduledEventResponse
  | StageScheduledEventResponse
  | VoiceScheduledEventResponse;

export type CreateGuildScheduledEventError = ErrorResponse;

export type GetGuildWelcomeScreenData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildWelcomeScreenResponse = GuildWelcomeScreenResponse;

export type GetGuildWelcomeScreenError = ErrorResponse;

export type UpdateGuildWelcomeScreenData = {
  body: WelcomeScreenPatchRequestPartial;
  path: {
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildWelcomeScreenResponse = GuildWelcomeScreenResponse;

export type UpdateGuildWelcomeScreenError = ErrorResponse;

export type UpdateVoiceStateData = {
  body: {
    suppress?: boolean | null;
    channel_id?: null | SnowflakeType;
  };
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type UpdateVoiceStateResponse = any;

export type UpdateVoiceStateError = ErrorResponse;

export type DeleteGuildIntegrationData = {
  path: {
    guild_id: SnowflakeType;
    integration_id: SnowflakeType;
  };
};

export type DeleteGuildIntegrationResponse = any;

export type DeleteGuildIntegrationError = ErrorResponse;

export type ListGuildIntegrationsData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildIntegrationsResponse = Array<
  DiscordIntegrationResponse | ExternalConnectionIntegrationResponse | GuildSubscriptionIntegrationResponse
> | null;

export type ListGuildIntegrationsError = ErrorResponse;

export type GetGuildWidgetData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildWidgetResponse = WidgetResponse;

export type GetGuildWidgetError = ErrorResponse;

export type GetGuildsOnboardingData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildsOnboardingResponse = UserGuildOnboardingResponse;

export type GetGuildsOnboardingError = ErrorResponse;

export type PutGuildsOnboardingData = {
  body: UpdateGuildOnboardingRequest;
  path: {
    guild_id: SnowflakeType;
  };
};

export type PutGuildsOnboardingResponse = GuildOnboardingResponse;

export type PutGuildsOnboardingError = ErrorResponse;

export type GetGuildVanityUrlData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildVanityUrlResponse = VanityURLResponse;

export type GetGuildVanityUrlError = ErrorResponse;

export type ListGuildAuditLogEntriesData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    action_type?: number;
    after?: SnowflakeType;
    before?: SnowflakeType;
    limit?: number;
    user_id?: SnowflakeType;
  };
};

export type ListGuildAuditLogEntriesResponse = GuildAuditLogResponse;

export type ListGuildAuditLogEntriesError = ErrorResponse;

export type GetGuildWidgetPngData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    style?: WidgetImageStyles;
  };
};

export type GetGuildWidgetPngResponse = string;

export type GetGuildWidgetPngError = ErrorResponse;

export type SyncGuildTemplateData = {
  path: {
    code: string;
    guild_id: SnowflakeType;
  };
};

export type SyncGuildTemplateResponse = GuildTemplateResponse;

export type SyncGuildTemplateError = ErrorResponse;

export type DeleteGuildTemplateData = {
  path: {
    code: string;
    guild_id: SnowflakeType;
  };
};

export type DeleteGuildTemplateResponse = GuildTemplateResponse;

export type DeleteGuildTemplateError = ErrorResponse;

export type UpdateGuildTemplateData = {
  body: {
    name?: string;
    description?: string | null;
  };
  path: {
    code: string;
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildTemplateResponse = GuildTemplateResponse;

export type UpdateGuildTemplateError = ErrorResponse;

export type ListGuildTemplatesData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildTemplatesResponse = Array<GuildTemplateResponse> | null;

export type ListGuildTemplatesError = ErrorResponse;

export type CreateGuildTemplateData = {
  body: {
    name: string;
    description?: string | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildTemplateResponse = GuildTemplateResponse;

export type CreateGuildTemplateError = ErrorResponse;

export type GetGuildStickerData = {
  path: {
    guild_id: SnowflakeType;
    sticker_id: SnowflakeType;
  };
};

export type GetGuildStickerResponse = GuildStickerResponse;

export type GetGuildStickerError = ErrorResponse;

export type DeleteGuildStickerData = {
  path: {
    guild_id: SnowflakeType;
    sticker_id: SnowflakeType;
  };
};

export type DeleteGuildStickerResponse = any;

export type DeleteGuildStickerError = ErrorResponse;

export type UpdateGuildStickerData = {
  body: {
    name?: string;
    tags?: string;
    description?: string | null;
  };
  path: {
    guild_id: SnowflakeType;
    sticker_id: SnowflakeType;
  };
};

export type UpdateGuildStickerResponse = GuildStickerResponse;

export type UpdateGuildStickerError = ErrorResponse;

export type ListGuildStickersData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildStickersResponse = Array<GuildStickerResponse>;

export type ListGuildStickersError = ErrorResponse;

export type CreateGuildStickerData = {
  body: {
    name: string;
    tags: string;
    description?: string | null;
    file: string;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildStickerResponse = GuildStickerResponse;

export type CreateGuildStickerError = ErrorResponse;

export type GetGuildWebhooksData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildWebhooksResponse = Array<
  ApplicationIncomingWebhookResponse | ChannelFollowerWebhookResponse | GuildIncomingWebhookResponse
> | null;

export type GetGuildWebhooksError = ErrorResponse;

export type ListGuildChannelsData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildChannelsResponse = Array<
  GuildChannelResponse | PrivateChannelResponse | PrivateGroupChannelResponse | ThreadResponse
> | null;

export type ListGuildChannelsError = ErrorResponse;

export type CreateGuildChannelData = {
  body: CreateGuildChannelRequest;
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildChannelResponse = GuildChannelResponse;

export type CreateGuildChannelError = ErrorResponse;

export type BulkUpdateGuildChannelsData = {
  body: Array<{
    id?: SnowflakeType;
    position?: number | null;
    parent_id?: null | SnowflakeType;
    lock_permissions?: boolean | null;
  }>;
  path: {
    guild_id: SnowflakeType;
  };
};

export type BulkUpdateGuildChannelsResponse = any;

export type BulkUpdateGuildChannelsError = ErrorResponse;

export type GetGuildMemberData = {
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type GetGuildMemberResponse = GuildMemberResponse;

export type GetGuildMemberError = ErrorResponse;

export type AddGuildMemberData = {
  body: {
    nick?: string | null;
    roles?: Array<null | SnowflakeType> | null;
    mute?: boolean | null;
    deaf?: boolean | null;
    access_token: string;
    flags?: number | null;
  };
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type AddGuildMemberResponse = GuildMemberResponse | any;

export type AddGuildMemberError = ErrorResponse;

export type DeleteGuildMemberData = {
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type DeleteGuildMemberResponse = any;

export type DeleteGuildMemberError = ErrorResponse;

export type UpdateGuildMemberData = {
  body: {
    nick?: string | null;
    roles?: Array<null | SnowflakeType> | null;
    mute?: boolean | null;
    deaf?: boolean | null;
    channel_id?: null | SnowflakeType;
    communication_disabled_until?: string | null;
    flags?: number | null;
  };
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type UpdateGuildMemberResponse = GuildMemberResponse | any;

export type UpdateGuildMemberError = ErrorResponse;

export type ListGuildMembersData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    after?: number;
    limit?: number;
  };
};

export type ListGuildMembersResponse = Array<GuildMemberResponse>;

export type ListGuildMembersError = ErrorResponse;

export type GetGuildPreviewData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildPreviewResponse = GuildPreviewResponse;

export type GetGuildPreviewError = ErrorResponse;

export type ListGuildInvitesData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildInvitesResponse = Array<FriendInviteResponse | GroupDMInviteResponse | GuildInviteResponse> | null;

export type ListGuildInvitesError = ErrorResponse;

export type ListGuildVoiceRegionsData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildVoiceRegionsResponse = Array<VoiceRegionResponse> | null;

export type ListGuildVoiceRegionsError = ErrorResponse;

export type GetGuildEmojiData = {
  path: {
    emoji_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type GetGuildEmojiResponse = EmojiResponse;

export type GetGuildEmojiError = ErrorResponse;

export type DeleteGuildEmojiData = {
  path: {
    emoji_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type DeleteGuildEmojiResponse = any;

export type DeleteGuildEmojiError = ErrorResponse;

export type UpdateGuildEmojiData = {
  body: {
    name?: string;
    roles?: Array<null | SnowflakeType> | null;
  };
  path: {
    emoji_id: SnowflakeType;
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildEmojiResponse = EmojiResponse;

export type UpdateGuildEmojiError = ErrorResponse;

export type ListGuildEmojisData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildEmojisResponse = Array<EmojiResponse> | null;

export type ListGuildEmojisError = ErrorResponse;

export type CreateGuildEmojiData = {
  body: {
    name: string;
    image: string;
    roles?: Array<null | SnowflakeType> | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildEmojiResponse = EmojiResponse;

export type CreateGuildEmojiError = ErrorResponse;

export type GetGuildWidgetSettingsData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type GetGuildWidgetSettingsResponse = WidgetSettingsResponse;

export type GetGuildWidgetSettingsError = ErrorResponse;

export type UpdateGuildWidgetSettingsData = {
  body: {
    channel_id?: null | SnowflakeType;
    enabled?: boolean | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildWidgetSettingsResponse = WidgetSettingsResponse;

export type UpdateGuildWidgetSettingsError = ErrorResponse;

export type DeleteGuildRoleData = {
  path: {
    guild_id: SnowflakeType;
    role_id: SnowflakeType;
  };
};

export type DeleteGuildRoleResponse = any;

export type DeleteGuildRoleError = ErrorResponse;

export type UpdateGuildRoleData = {
  body: {
    name?: string | null;
    permissions?: number | null;
    color?: number | null;
    hoist?: boolean | null;
    mentionable?: boolean | null;
    icon?: string | null;
    unicode_emoji?: string | null;
  };
  path: {
    guild_id: SnowflakeType;
    role_id: SnowflakeType;
  };
};

export type UpdateGuildRoleResponse = GuildRoleResponse;

export type UpdateGuildRoleError = ErrorResponse;

export type ListGuildRolesData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type ListGuildRolesResponse = Array<GuildRoleResponse>;

export type ListGuildRolesError = ErrorResponse;

export type CreateGuildRoleData = {
  body: {
    name?: string | null;
    permissions?: number | null;
    color?: number | null;
    hoist?: boolean | null;
    mentionable?: boolean | null;
    icon?: string | null;
    unicode_emoji?: string | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type CreateGuildRoleResponse = GuildRoleResponse;

export type CreateGuildRoleError = ErrorResponse;

export type BulkUpdateGuildRolesData = {
  body: Array<{
    id?: null | SnowflakeType;
    position?: number | null;
  }>;
  path: {
    guild_id: SnowflakeType;
  };
};

export type BulkUpdateGuildRolesResponse = Array<GuildRoleResponse>;

export type BulkUpdateGuildRolesError = ErrorResponse;

export type PreviewPruneGuildData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    days?: number;
    include_roles?: string | Array<null | SnowflakeType>;
  };
};

export type PreviewPruneGuildResponse = GuildPruneResponse;

export type PreviewPruneGuildError = ErrorResponse;

export type PruneGuildData = {
  body: {
    days?: number | null;
    compute_prune_count?: boolean | null;
    include_roles?: string | Array<null | SnowflakeType> | null;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type PruneGuildResponse = GuildPruneResponse;

export type PruneGuildError = ErrorResponse;

export type GetGuildBanData = {
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type GetGuildBanResponse = GuildBanResponse;

export type GetGuildBanError = ErrorResponse;

export type BanUserFromGuildData = {
  body: {
    delete_message_seconds?: number | null;
    delete_message_days?: number | null;
  };
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type BanUserFromGuildResponse = any;

export type BanUserFromGuildError = ErrorResponse;

export type UnbanUserFromGuildData = {
  path: {
    guild_id: SnowflakeType;
    user_id: SnowflakeType;
  };
};

export type UnbanUserFromGuildResponse = any;

export type UnbanUserFromGuildError = ErrorResponse;

export type ListGuildBansData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    after?: SnowflakeType;
    before?: SnowflakeType;
    limit?: number;
  };
};

export type ListGuildBansResponse = Array<GuildBanResponse> | null;

export type ListGuildBansError = ErrorResponse;

export type SetGuildMfaLevelData = {
  body: {
    level: GuildMFALevel;
  };
  path: {
    guild_id: SnowflakeType;
  };
};

export type SetGuildMfaLevelResponse = GuildMFALevelResponse;

export type SetGuildMfaLevelError = ErrorResponse;

export type GetStageInstanceData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type GetStageInstanceResponse = StageInstanceResponse;

export type GetStageInstanceError = ErrorResponse;

export type DeleteStageInstanceData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type DeleteStageInstanceResponse = any;

export type DeleteStageInstanceError = ErrorResponse;

export type UpdateStageInstanceData = {
  body: {
    topic?: string;
    privacy_level?: StageInstancesPrivacyLevels;
  };
  path: {
    channel_id: SnowflakeType;
  };
};

export type UpdateStageInstanceResponse = StageInstanceResponse;

export type UpdateStageInstanceError = ErrorResponse;

export type GetApplicationData = {
  path: {
    application_id: SnowflakeType;
  };
};

export type GetApplicationResponse = PrivateApplicationResponse;

export type GetApplicationError = ErrorResponse;

export type UpdateApplicationData = {
  body: ApplicationFormPartial;
  path: {
    application_id: SnowflakeType;
  };
};

export type UpdateApplicationResponse = PrivateApplicationResponse;

export type UpdateApplicationError = ErrorResponse;

export type GetWebhookByTokenData = {
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
};

export type GetWebhookByTokenResponse =
  | ApplicationIncomingWebhookResponse
  | ChannelFollowerWebhookResponse
  | GuildIncomingWebhookResponse;

export type GetWebhookByTokenError = ErrorResponse;

export type ExecuteWebhookData = {
  body: IncomingWebhookRequestPartial | IncomingWebhookUpdateRequestPartial;
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
  query?: {
    thread_id?: SnowflakeType;
    wait?: boolean;
  };
};

export type ExecuteWebhookResponse = MessageResponse | any;

export type ExecuteWebhookError = ErrorResponse;

export type DeleteWebhookByTokenData = {
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
};

export type DeleteWebhookByTokenResponse = any;

export type DeleteWebhookByTokenError = ErrorResponse;

export type UpdateWebhookByTokenData = {
  body: {
    name?: string;
    avatar?: string | null;
  };
  path: {
    webhook_id: SnowflakeType;
    webhook_token: string;
  };
};

export type UpdateWebhookByTokenResponse =
  | ApplicationIncomingWebhookResponse
  | ChannelFollowerWebhookResponse
  | GuildIncomingWebhookResponse;

export type UpdateWebhookByTokenError = ErrorResponse;

export type GetStickerData = {
  path: {
    sticker_id: SnowflakeType;
  };
};

export type GetStickerResponse = GuildStickerResponse | StandardStickerResponse;

export type GetStickerError = ErrorResponse;

export type GetWebhookData = {
  path: {
    webhook_id: SnowflakeType;
  };
};

export type GetWebhookResponse =
  | ApplicationIncomingWebhookResponse
  | ChannelFollowerWebhookResponse
  | GuildIncomingWebhookResponse;

export type GetWebhookError = ErrorResponse;

export type DeleteWebhookData = {
  path: {
    webhook_id: SnowflakeType;
  };
};

export type DeleteWebhookResponse = any;

export type DeleteWebhookError = ErrorResponse;

export type UpdateWebhookData = {
  body: {
    name?: string;
    avatar?: string | null;
    channel_id?: null | SnowflakeType;
  };
  path: {
    webhook_id: SnowflakeType;
  };
};

export type UpdateWebhookResponse =
  | ApplicationIncomingWebhookResponse
  | ChannelFollowerWebhookResponse
  | GuildIncomingWebhookResponse;

export type UpdateWebhookError = ErrorResponse;

export type GetChannelData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type GetChannelResponse =
  | GuildChannelResponse
  | PrivateChannelResponse
  | PrivateGroupChannelResponse
  | ThreadResponse;

export type GetChannelError = ErrorResponse;

export type DeleteChannelData = {
  path: {
    channel_id: SnowflakeType;
  };
};

export type DeleteChannelResponse =
  | GuildChannelResponse
  | PrivateChannelResponse
  | PrivateGroupChannelResponse
  | ThreadResponse;

export type DeleteChannelError = ErrorResponse;

export type UpdateChannelData = {
  body: PrivateChannelRequestPartial | UpdateGuildChannelRequestPartial | UpdateThreadRequestPartial;
  path: {
    channel_id: SnowflakeType;
  };
};

export type UpdateChannelResponse =
  | GuildChannelResponse
  | PrivateChannelResponse
  | PrivateGroupChannelResponse
  | ThreadResponse;

export type UpdateChannelError = ErrorResponse;

export type InviteResolveData = {
  path: {
    code: string;
  };
  query?: {
    guild_scheduled_event_id?: SnowflakeType;
    with_counts?: boolean;
  };
};

export type InviteResolveResponse = FriendInviteResponse | GroupDMInviteResponse | GuildInviteResponse;

export type InviteResolveError = ErrorResponse;

export type InviteRevokeData = {
  path: {
    code: string;
  };
};

export type InviteRevokeResponse = FriendInviteResponse | GroupDMInviteResponse | GuildInviteResponse;

export type InviteRevokeError = ErrorResponse;

export type GetGuildData = {
  path: {
    guild_id: SnowflakeType;
  };
  query?: {
    with_counts?: boolean;
  };
};

export type GetGuildResponse = GuildWithCountsResponse;

export type GetGuildError = ErrorResponse;

export type DeleteGuildData = {
  path: {
    guild_id: SnowflakeType;
  };
};

export type DeleteGuildResponse = any;

export type DeleteGuildError = ErrorResponse;

export type UpdateGuildData = {
  body: GuildPatchRequestPartial;
  path: {
    guild_id: SnowflakeType;
  };
};

export type UpdateGuildResponse = GuildResponse;

export type UpdateGuildError = ErrorResponse;

export type GetUserData = {
  path: {
    user_id: SnowflakeType;
  };
};

export type GetUserResponse = UserResponse;

export type GetUserError = ErrorResponse;
