// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  GetMyOauth2ApplicationError,
  GetMyOauth2ApplicationResponse,
  ListMyConnectionsError,
  ListMyConnectionsResponse,
  CreateDmData,
  CreateDmError,
  CreateDmResponse,
  ListMyGuildsData,
  ListMyGuildsError,
  ListMyGuildsResponse,
  GetMyApplicationError,
  GetMyApplicationResponse,
  UpdateMyApplicationData,
  UpdateMyApplicationError,
  UpdateMyApplicationResponse,
  GetBotGatewayError,
  GetBotGatewayResponse,
  GetMyOauth2AuthorizationError,
  GetMyOauth2AuthorizationResponse,
  ListVoiceRegionsError,
  ListVoiceRegionsResponse,
  GetMyUserError,
  GetMyUserResponse,
  UpdateMyUserData,
  UpdateMyUserError,
  UpdateMyUserResponse,
  CreateStageInstanceData,
  CreateStageInstanceError,
  CreateStageInstanceResponse,
  ListStickerPacksError,
  ListStickerPacksResponse,
  GetGatewayError,
  GetGatewayResponse,
  CreateGuildData,
  CreateGuildError,
  CreateGuildResponse,
  ListMyPrivateArchivedThreadsData,
  ListMyPrivateArchivedThreadsError,
  ListMyPrivateArchivedThreadsResponse,
  ListGuildApplicationCommandPermissionsData,
  ListGuildApplicationCommandPermissionsError,
  ListGuildApplicationCommandPermissionsResponse,
  GetGuildApplicationCommandPermissionsData,
  GetGuildApplicationCommandPermissionsError,
  GetGuildApplicationCommandPermissionsResponse,
  SetGuildApplicationCommandPermissionsData,
  SetGuildApplicationCommandPermissionsError,
  SetGuildApplicationCommandPermissionsResponse,
  AddMyMessageReactionData,
  AddMyMessageReactionError,
  AddMyMessageReactionResponse,
  DeleteMyMessageReactionData,
  DeleteMyMessageReactionError,
  DeleteMyMessageReactionResponse,
  ListPrivateArchivedThreadsData,
  ListPrivateArchivedThreadsError,
  ListPrivateArchivedThreadsResponse,
  ListPublicArchivedThreadsData,
  ListPublicArchivedThreadsError,
  ListPublicArchivedThreadsResponse,
  GetApplicationUserRoleConnectionData,
  GetApplicationUserRoleConnectionError,
  GetApplicationUserRoleConnectionResponse,
  UpdateApplicationUserRoleConnectionData,
  UpdateApplicationUserRoleConnectionError,
  UpdateApplicationUserRoleConnectionResponse,
  GetMyGuildMemberData,
  GetMyGuildMemberError,
  GetMyGuildMemberResponse,
  GetApplicationRoleConnectionsMetadataData,
  GetApplicationRoleConnectionsMetadataError,
  GetApplicationRoleConnectionsMetadataResponse,
  UpdateApplicationRoleConnectionsMetadataData,
  UpdateApplicationRoleConnectionsMetadataError,
  UpdateApplicationRoleConnectionsMetadataResponse,
  GetGuildApplicationCommandData,
  GetGuildApplicationCommandError,
  GetGuildApplicationCommandResponse,
  DeleteGuildApplicationCommandData,
  DeleteGuildApplicationCommandError,
  DeleteGuildApplicationCommandResponse,
  UpdateGuildApplicationCommandData,
  UpdateGuildApplicationCommandError,
  UpdateGuildApplicationCommandResponse,
  ListGuildApplicationCommandsData,
  ListGuildApplicationCommandsError,
  ListGuildApplicationCommandsResponse,
  BulkSetGuildApplicationCommandsData,
  BulkSetGuildApplicationCommandsError,
  BulkSetGuildApplicationCommandsResponse,
  CreateGuildApplicationCommandData,
  CreateGuildApplicationCommandError,
  CreateGuildApplicationCommandResponse,
  JoinThreadData,
  JoinThreadError,
  JoinThreadResponse,
  LeaveThreadData,
  LeaveThreadError,
  LeaveThreadResponse,
  BulkDeleteMessagesData,
  BulkDeleteMessagesError,
  BulkDeleteMessagesResponse,
  DeleteUserMessageReactionData,
  DeleteUserMessageReactionError,
  DeleteUserMessageReactionResponse,
  ListMessageReactionsByEmojiData,
  ListMessageReactionsByEmojiError,
  ListMessageReactionsByEmojiResponse,
  DeleteAllMessageReactionsByEmojiData,
  DeleteAllMessageReactionsByEmojiError,
  DeleteAllMessageReactionsByEmojiResponse,
  DeleteAllMessageReactionsData,
  DeleteAllMessageReactionsError,
  DeleteAllMessageReactionsResponse,
  CrosspostMessageData,
  CrosspostMessageError,
  CrosspostMessageResponse,
  CreateThreadFromMessageData,
  CreateThreadFromMessageError,
  CreateThreadFromMessageResponse,
  GetOriginalWebhookMessageData,
  GetOriginalWebhookMessageError,
  GetOriginalWebhookMessageResponse,
  DeleteOriginalWebhookMessageData,
  DeleteOriginalWebhookMessageError,
  DeleteOriginalWebhookMessageResponse,
  UpdateOriginalWebhookMessageData,
  UpdateOriginalWebhookMessageError,
  UpdateOriginalWebhookMessageResponse,
  ListGuildScheduledEventUsersData,
  ListGuildScheduledEventUsersError,
  ListGuildScheduledEventUsersResponse,
  GetAutoModerationRuleData,
  GetAutoModerationRuleError,
  GetAutoModerationRuleResponse,
  DeleteAutoModerationRuleData,
  DeleteAutoModerationRuleError,
  DeleteAutoModerationRuleResponse,
  UpdateAutoModerationRuleData,
  UpdateAutoModerationRuleError,
  UpdateAutoModerationRuleResponse,
  ListAutoModerationRulesData,
  ListAutoModerationRulesError,
  ListAutoModerationRulesResponse,
  CreateAutoModerationRuleData,
  CreateAutoModerationRuleError,
  CreateAutoModerationRuleResponse,
  UpdateSelfVoiceStateData,
  UpdateSelfVoiceStateError,
  UpdateSelfVoiceStateResponse,
  SearchGuildMembersData,
  SearchGuildMembersError,
  SearchGuildMembersResponse,
  GetActiveGuildThreadsData,
  GetActiveGuildThreadsError,
  GetActiveGuildThreadsResponse,
  UpdateMyGuildMemberData,
  UpdateMyGuildMemberError,
  UpdateMyGuildMemberResponse,
  AddGuildMemberRoleData,
  AddGuildMemberRoleError,
  AddGuildMemberRoleResponse,
  DeleteGuildMemberRoleData,
  DeleteGuildMemberRoleError,
  DeleteGuildMemberRoleResponse,
  LeaveGuildData,
  LeaveGuildError,
  LeaveGuildResponse,
  GetApplicationCommandData,
  GetApplicationCommandError,
  GetApplicationCommandResponse,
  DeleteApplicationCommandData,
  DeleteApplicationCommandError,
  DeleteApplicationCommandResponse,
  UpdateApplicationCommandData,
  UpdateApplicationCommandError,
  UpdateApplicationCommandResponse,
  ListApplicationCommandsData,
  ListApplicationCommandsError,
  ListApplicationCommandsResponse,
  BulkSetApplicationCommandsData,
  BulkSetApplicationCommandsError,
  BulkSetApplicationCommandsResponse,
  CreateApplicationCommandData,
  CreateApplicationCommandError,
  CreateApplicationCommandResponse,
  CreateInteractionResponseData,
  CreateInteractionResponseError,
  CreateInteractionResponseResponse,
  GetThreadMemberData,
  GetThreadMemberError,
  GetThreadMemberResponse,
  AddThreadMemberData,
  AddThreadMemberError,
  AddThreadMemberResponse,
  DeleteThreadMemberData,
  DeleteThreadMemberError,
  DeleteThreadMemberResponse,
  ListThreadMembersData,
  ListThreadMembersError,
  ListThreadMembersResponse,
  SetChannelPermissionOverwriteData,
  SetChannelPermissionOverwriteError,
  SetChannelPermissionOverwriteResponse,
  DeleteChannelPermissionOverwriteData,
  DeleteChannelPermissionOverwriteError,
  DeleteChannelPermissionOverwriteResponse,
  AddGroupDmUserData,
  AddGroupDmUserError,
  AddGroupDmUserResponse,
  DeleteGroupDmUserData,
  DeleteGroupDmUserError,
  DeleteGroupDmUserResponse,
  FollowChannelData,
  FollowChannelError,
  FollowChannelResponse,
  GetMessageData,
  GetMessageError,
  GetMessageResponse,
  DeleteMessageData,
  DeleteMessageError,
  DeleteMessageResponse,
  UpdateMessageData,
  UpdateMessageError,
  UpdateMessageResponse,
  ListMessagesData,
  ListMessagesError,
  ListMessagesResponse,
  CreateMessageData,
  CreateMessageError,
  CreateMessageResponse,
  ListChannelWebhooksData,
  ListChannelWebhooksError,
  ListChannelWebhooksResponse,
  CreateWebhookData,
  CreateWebhookError,
  CreateWebhookResponse,
  ListChannelInvitesData,
  ListChannelInvitesError,
  ListChannelInvitesResponse,
  CreateChannelInviteData,
  CreateChannelInviteError,
  CreateChannelInviteResponse,
  CreateThreadData,
  CreateThreadError,
  CreateThreadResponse,
  TriggerTypingIndicatorData,
  TriggerTypingIndicatorError,
  TriggerTypingIndicatorResponse,
  PinMessageData,
  PinMessageError,
  PinMessageResponse,
  UnpinMessageData,
  UnpinMessageError,
  UnpinMessageResponse,
  ListPinnedMessagesData,
  ListPinnedMessagesError,
  ListPinnedMessagesResponse,
  GetWebhookMessageData,
  GetWebhookMessageError,
  GetWebhookMessageResponse,
  DeleteWebhookMessageData,
  DeleteWebhookMessageError,
  DeleteWebhookMessageResponse,
  UpdateWebhookMessageData,
  UpdateWebhookMessageError,
  UpdateWebhookMessageResponse,
  ExecuteGithubCompatibleWebhookData,
  ExecuteGithubCompatibleWebhookError,
  ExecuteGithubCompatibleWebhookResponse,
  ExecuteSlackCompatibleWebhookData,
  ExecuteSlackCompatibleWebhookError,
  ExecuteSlackCompatibleWebhookResponse,
  GetGuildTemplateData,
  GetGuildTemplateError,
  GetGuildTemplateResponse,
  CreateGuildFromTemplateData,
  CreateGuildFromTemplateError,
  CreateGuildFromTemplateResponse,
  GetGuildNewMemberWelcomeData,
  GetGuildNewMemberWelcomeError,
  GetGuildNewMemberWelcomeResponse,
  GetGuildScheduledEventData,
  GetGuildScheduledEventError,
  GetGuildScheduledEventResponse,
  DeleteGuildScheduledEventData,
  DeleteGuildScheduledEventError,
  DeleteGuildScheduledEventResponse,
  UpdateGuildScheduledEventData,
  UpdateGuildScheduledEventError,
  UpdateGuildScheduledEventResponse,
  ListGuildScheduledEventsData,
  ListGuildScheduledEventsError,
  ListGuildScheduledEventsResponse,
  CreateGuildScheduledEventData,
  CreateGuildScheduledEventError,
  CreateGuildScheduledEventResponse,
  GetGuildWelcomeScreenData,
  GetGuildWelcomeScreenError,
  GetGuildWelcomeScreenResponse,
  UpdateGuildWelcomeScreenData,
  UpdateGuildWelcomeScreenError,
  UpdateGuildWelcomeScreenResponse,
  UpdateVoiceStateData,
  UpdateVoiceStateError,
  UpdateVoiceStateResponse,
  DeleteGuildIntegrationData,
  DeleteGuildIntegrationError,
  DeleteGuildIntegrationResponse,
  ListGuildIntegrationsData,
  ListGuildIntegrationsError,
  ListGuildIntegrationsResponse,
  GetGuildWidgetData,
  GetGuildWidgetError,
  GetGuildWidgetResponse,
  GetGuildsOnboardingData,
  GetGuildsOnboardingError,
  GetGuildsOnboardingResponse,
  PutGuildsOnboardingData,
  PutGuildsOnboardingError,
  PutGuildsOnboardingResponse,
  GetGuildVanityUrlData,
  GetGuildVanityUrlError,
  GetGuildVanityUrlResponse,
  ListGuildAuditLogEntriesData,
  ListGuildAuditLogEntriesError,
  ListGuildAuditLogEntriesResponse,
  GetGuildWidgetPngData,
  GetGuildWidgetPngError,
  GetGuildWidgetPngResponse,
  SyncGuildTemplateData,
  SyncGuildTemplateError,
  SyncGuildTemplateResponse,
  DeleteGuildTemplateData,
  DeleteGuildTemplateError,
  DeleteGuildTemplateResponse,
  UpdateGuildTemplateData,
  UpdateGuildTemplateError,
  UpdateGuildTemplateResponse,
  ListGuildTemplatesData,
  ListGuildTemplatesError,
  ListGuildTemplatesResponse,
  CreateGuildTemplateData,
  CreateGuildTemplateError,
  CreateGuildTemplateResponse,
  GetGuildStickerData,
  GetGuildStickerError,
  GetGuildStickerResponse,
  DeleteGuildStickerData,
  DeleteGuildStickerError,
  DeleteGuildStickerResponse,
  UpdateGuildStickerData,
  UpdateGuildStickerError,
  UpdateGuildStickerResponse,
  ListGuildStickersData,
  ListGuildStickersError,
  ListGuildStickersResponse,
  CreateGuildStickerData,
  CreateGuildStickerError,
  CreateGuildStickerResponse,
  GetGuildWebhooksData,
  GetGuildWebhooksError,
  GetGuildWebhooksResponse,
  ListGuildChannelsData,
  ListGuildChannelsError,
  ListGuildChannelsResponse,
  CreateGuildChannelData,
  CreateGuildChannelError,
  CreateGuildChannelResponse,
  BulkUpdateGuildChannelsData,
  BulkUpdateGuildChannelsError,
  BulkUpdateGuildChannelsResponse,
  GetGuildMemberData,
  GetGuildMemberError,
  GetGuildMemberResponse,
  AddGuildMemberData,
  AddGuildMemberError,
  AddGuildMemberResponse,
  DeleteGuildMemberData,
  DeleteGuildMemberError,
  DeleteGuildMemberResponse,
  UpdateGuildMemberData,
  UpdateGuildMemberError,
  UpdateGuildMemberResponse,
  ListGuildMembersData,
  ListGuildMembersError,
  ListGuildMembersResponse,
  GetGuildPreviewData,
  GetGuildPreviewError,
  GetGuildPreviewResponse,
  ListGuildInvitesData,
  ListGuildInvitesError,
  ListGuildInvitesResponse,
  ListGuildVoiceRegionsData,
  ListGuildVoiceRegionsError,
  ListGuildVoiceRegionsResponse,
  GetGuildEmojiData,
  GetGuildEmojiError,
  GetGuildEmojiResponse,
  DeleteGuildEmojiData,
  DeleteGuildEmojiError,
  DeleteGuildEmojiResponse,
  UpdateGuildEmojiData,
  UpdateGuildEmojiError,
  UpdateGuildEmojiResponse,
  ListGuildEmojisData,
  ListGuildEmojisError,
  ListGuildEmojisResponse,
  CreateGuildEmojiData,
  CreateGuildEmojiError,
  CreateGuildEmojiResponse,
  GetGuildWidgetSettingsData,
  GetGuildWidgetSettingsError,
  GetGuildWidgetSettingsResponse,
  UpdateGuildWidgetSettingsData,
  UpdateGuildWidgetSettingsError,
  UpdateGuildWidgetSettingsResponse,
  DeleteGuildRoleData,
  DeleteGuildRoleError,
  DeleteGuildRoleResponse,
  UpdateGuildRoleData,
  UpdateGuildRoleError,
  UpdateGuildRoleResponse,
  ListGuildRolesData,
  ListGuildRolesError,
  ListGuildRolesResponse,
  CreateGuildRoleData,
  CreateGuildRoleError,
  CreateGuildRoleResponse,
  BulkUpdateGuildRolesData,
  BulkUpdateGuildRolesError,
  BulkUpdateGuildRolesResponse,
  PreviewPruneGuildData,
  PreviewPruneGuildError,
  PreviewPruneGuildResponse,
  PruneGuildData,
  PruneGuildError,
  PruneGuildResponse,
  GetGuildBanData,
  GetGuildBanError,
  GetGuildBanResponse,
  BanUserFromGuildData,
  BanUserFromGuildError,
  BanUserFromGuildResponse,
  UnbanUserFromGuildData,
  UnbanUserFromGuildError,
  UnbanUserFromGuildResponse,
  ListGuildBansData,
  ListGuildBansError,
  ListGuildBansResponse,
  SetGuildMfaLevelData,
  SetGuildMfaLevelError,
  SetGuildMfaLevelResponse,
  GetStageInstanceData,
  GetStageInstanceError,
  GetStageInstanceResponse,
  DeleteStageInstanceData,
  DeleteStageInstanceError,
  DeleteStageInstanceResponse,
  UpdateStageInstanceData,
  UpdateStageInstanceError,
  UpdateStageInstanceResponse,
  GetApplicationData,
  GetApplicationError,
  GetApplicationResponse,
  UpdateApplicationData,
  UpdateApplicationError,
  UpdateApplicationResponse,
  GetWebhookByTokenData,
  GetWebhookByTokenError,
  GetWebhookByTokenResponse,
  ExecuteWebhookData,
  ExecuteWebhookError,
  ExecuteWebhookResponse,
  DeleteWebhookByTokenData,
  DeleteWebhookByTokenError,
  DeleteWebhookByTokenResponse,
  UpdateWebhookByTokenData,
  UpdateWebhookByTokenError,
  UpdateWebhookByTokenResponse,
  GetStickerData,
  GetStickerError,
  GetStickerResponse,
  GetWebhookData,
  GetWebhookError,
  GetWebhookResponse,
  DeleteWebhookData,
  DeleteWebhookError,
  DeleteWebhookResponse,
  UpdateWebhookData,
  UpdateWebhookError,
  UpdateWebhookResponse,
  GetChannelData,
  GetChannelError,
  GetChannelResponse,
  DeleteChannelData,
  DeleteChannelError,
  DeleteChannelResponse,
  UpdateChannelData,
  UpdateChannelError,
  UpdateChannelResponse,
  InviteResolveData,
  InviteResolveError,
  InviteResolveResponse,
  InviteRevokeData,
  InviteRevokeError,
  InviteRevokeResponse,
  GetGuildData,
  GetGuildError,
  GetGuildResponse,
  DeleteGuildData,
  DeleteGuildError,
  DeleteGuildResponse,
  UpdateGuildData,
  UpdateGuildError,
  UpdateGuildResponse,
  GetUserData,
  GetUserError,
  GetUserResponse,
} from './types.gen';

export const client = createClient(createConfig());

export const getMyOauth2Application = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMyOauth2ApplicationResponse, GetMyOauth2ApplicationError, ThrowOnError>({
    ...options,
    url: '/oauth2/applications/@me',
  });
};

export const listMyConnections = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListMyConnectionsResponse, ListMyConnectionsError, ThrowOnError>({
    ...options,
    url: '/users/@me/connections',
  });
};

export const createDm = <ThrowOnError extends boolean = false>(options: Options<CreateDmData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateDmResponse, CreateDmError, ThrowOnError>({
    ...options,
    url: '/users/@me/channels',
  });
};

export const listMyGuilds = <ThrowOnError extends boolean = false>(
  options?: Options<ListMyGuildsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListMyGuildsResponse, ListMyGuildsError, ThrowOnError>({
    ...options,
    url: '/users/@me/guilds',
  });
};

export const getMyApplication = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetMyApplicationResponse, GetMyApplicationError, ThrowOnError>({
    ...options,
    url: '/applications/@me',
  });
};

export const updateMyApplication = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMyApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateMyApplicationResponse, UpdateMyApplicationError, ThrowOnError>({
    ...options,
    url: '/applications/@me',
  });
};

export const getBotGateway = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetBotGatewayResponse, GetBotGatewayError, ThrowOnError>({
    ...options,
    url: '/gateway/bot',
  });
};

export const getMyOauth2Authorization = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMyOauth2AuthorizationResponse, GetMyOauth2AuthorizationError, ThrowOnError>(
    {
      ...options,
      url: '/oauth2/@me',
    },
  );
};

export const listVoiceRegions = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListVoiceRegionsResponse, ListVoiceRegionsError, ThrowOnError>({
    ...options,
    url: '/voice/regions',
  });
};

export const getMyUser = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetMyUserResponse, GetMyUserError, ThrowOnError>({
    ...options,
    url: '/users/@me',
  });
};

export const updateMyUser = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMyUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateMyUserResponse, UpdateMyUserError, ThrowOnError>({
    ...options,
    url: '/users/@me',
  });
};

export const createStageInstance = <ThrowOnError extends boolean = false>(
  options: Options<CreateStageInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateStageInstanceResponse, CreateStageInstanceError, ThrowOnError>({
    ...options,
    url: '/stage-instances',
  });
};

export const listStickerPacks = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListStickerPacksResponse, ListStickerPacksError, ThrowOnError>({
    ...options,
    url: '/sticker-packs',
  });
};

export const getGateway = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetGatewayResponse, GetGatewayError, ThrowOnError>({
    ...options,
    url: '/gateway',
  });
};

export const createGuild = <ThrowOnError extends boolean = false>(options: Options<CreateGuildData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateGuildResponse, CreateGuildError, ThrowOnError>({
    ...options,
    url: '/guilds',
  });
};

export const listMyPrivateArchivedThreads = <ThrowOnError extends boolean = false>(
  options: Options<ListMyPrivateArchivedThreadsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListMyPrivateArchivedThreadsResponse,
    ListMyPrivateArchivedThreadsError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/users/@me/threads/archived/private',
  });
};

export const listGuildApplicationCommandPermissions = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildApplicationCommandPermissionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListGuildApplicationCommandPermissionsResponse,
    ListGuildApplicationCommandPermissionsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/permissions',
  });
};

export const getGuildApplicationCommandPermissions = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildApplicationCommandPermissionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetGuildApplicationCommandPermissionsResponse,
    GetGuildApplicationCommandPermissionsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/{command_id}/permissions',
  });
};

export const setGuildApplicationCommandPermissions = <ThrowOnError extends boolean = false>(
  options: Options<SetGuildApplicationCommandPermissionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SetGuildApplicationCommandPermissionsResponse,
    SetGuildApplicationCommandPermissionsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/{command_id}/permissions',
  });
};

export const addMyMessageReaction = <ThrowOnError extends boolean = false>(
  options: Options<AddMyMessageReactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AddMyMessageReactionResponse, AddMyMessageReactionError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions/{emoji_name}/@me',
  });
};

export const deleteMyMessageReaction = <ThrowOnError extends boolean = false>(
  options: Options<DeleteMyMessageReactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteMyMessageReactionResponse,
    DeleteMyMessageReactionError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions/{emoji_name}/@me',
  });
};

export const listPrivateArchivedThreads = <ThrowOnError extends boolean = false>(
  options: Options<ListPrivateArchivedThreadsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListPrivateArchivedThreadsResponse,
    ListPrivateArchivedThreadsError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/threads/archived/private',
  });
};

export const listPublicArchivedThreads = <ThrowOnError extends boolean = false>(
  options: Options<ListPublicArchivedThreadsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListPublicArchivedThreadsResponse,
    ListPublicArchivedThreadsError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/threads/archived/public',
  });
};

export const getApplicationUserRoleConnection = <ThrowOnError extends boolean = false>(
  options: Options<GetApplicationUserRoleConnectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetApplicationUserRoleConnectionResponse,
    GetApplicationUserRoleConnectionError,
    ThrowOnError
  >({
    ...options,
    url: '/users/@me/applications/{application_id}/role-connection',
  });
};

export const updateApplicationUserRoleConnection = <ThrowOnError extends boolean = false>(
  options: Options<UpdateApplicationUserRoleConnectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    UpdateApplicationUserRoleConnectionResponse,
    UpdateApplicationUserRoleConnectionError,
    ThrowOnError
  >({
    ...options,
    url: '/users/@me/applications/{application_id}/role-connection',
  });
};

export const getMyGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<GetMyGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMyGuildMemberResponse, GetMyGuildMemberError, ThrowOnError>({
    ...options,
    url: '/users/@me/guilds/{guild_id}/member',
  });
};

export const getApplicationRoleConnectionsMetadata = <ThrowOnError extends boolean = false>(
  options: Options<GetApplicationRoleConnectionsMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetApplicationRoleConnectionsMetadataResponse,
    GetApplicationRoleConnectionsMetadataError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/role-connections/metadata',
  });
};

export const updateApplicationRoleConnectionsMetadata = <ThrowOnError extends boolean = false>(
  options: Options<UpdateApplicationRoleConnectionsMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    UpdateApplicationRoleConnectionsMetadataResponse,
    UpdateApplicationRoleConnectionsMetadataError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/role-connections/metadata',
  });
};

export const getGuildApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetGuildApplicationCommandResponse,
    GetGuildApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/{command_id}',
  });
};

export const deleteGuildApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteGuildApplicationCommandResponse,
    DeleteGuildApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/{command_id}',
  });
};

export const updateGuildApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateGuildApplicationCommandResponse,
    UpdateGuildApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands/{command_id}',
  });
};

export const listGuildApplicationCommands = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildApplicationCommandsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListGuildApplicationCommandsResponse,
    ListGuildApplicationCommandsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands',
  });
};

export const bulkSetGuildApplicationCommands = <ThrowOnError extends boolean = false>(
  options: Options<BulkSetGuildApplicationCommandsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    BulkSetGuildApplicationCommandsResponse,
    BulkSetGuildApplicationCommandsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands',
  });
};

export const createGuildApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateGuildApplicationCommandResponse,
    CreateGuildApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/guilds/{guild_id}/commands',
  });
};

export const joinThread = <ThrowOnError extends boolean = false>(options: Options<JoinThreadData, ThrowOnError>) => {
  return (options?.client ?? client).put<JoinThreadResponse, JoinThreadError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members/@me',
  });
};

export const leaveThread = <ThrowOnError extends boolean = false>(options: Options<LeaveThreadData, ThrowOnError>) => {
  return (options?.client ?? client).delete<LeaveThreadResponse, LeaveThreadError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members/@me',
  });
};

export const bulkDeleteMessages = <ThrowOnError extends boolean = false>(
  options: Options<BulkDeleteMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BulkDeleteMessagesResponse, BulkDeleteMessagesError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/bulk-delete',
  });
};

export const deleteUserMessageReaction = <ThrowOnError extends boolean = false>(
  options: Options<DeleteUserMessageReactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteUserMessageReactionResponse,
    DeleteUserMessageReactionError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions/{emoji_name}/{user_id}',
  });
};

export const listMessageReactionsByEmoji = <ThrowOnError extends boolean = false>(
  options: Options<ListMessageReactionsByEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListMessageReactionsByEmojiResponse,
    ListMessageReactionsByEmojiError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions/{emoji_name}',
  });
};

export const deleteAllMessageReactionsByEmoji = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAllMessageReactionsByEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAllMessageReactionsByEmojiResponse,
    DeleteAllMessageReactionsByEmojiError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions/{emoji_name}',
  });
};

export const deleteAllMessageReactions = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAllMessageReactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAllMessageReactionsResponse,
    DeleteAllMessageReactionsError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/reactions',
  });
};

export const crosspostMessage = <ThrowOnError extends boolean = false>(
  options: Options<CrosspostMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CrosspostMessageResponse, CrosspostMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/crosspost',
  });
};

export const createThreadFromMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateThreadFromMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateThreadFromMessageResponse, CreateThreadFromMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}/threads',
  });
};

export const getOriginalWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<GetOriginalWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetOriginalWebhookMessageResponse,
    GetOriginalWebhookMessageError,
    ThrowOnError
  >({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/@original',
  });
};

export const deleteOriginalWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteOriginalWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteOriginalWebhookMessageResponse,
    DeleteOriginalWebhookMessageError,
    ThrowOnError
  >({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/@original',
  });
};

export const updateOriginalWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOriginalWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateOriginalWebhookMessageResponse,
    UpdateOriginalWebhookMessageError,
    ThrowOnError
  >({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/@original',
  });
};

export const listGuildScheduledEventUsers = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildScheduledEventUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListGuildScheduledEventUsersResponse,
    ListGuildScheduledEventUsersError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/scheduled-events/{guild_scheduled_event_id}/users',
  });
};

export const getAutoModerationRule = <ThrowOnError extends boolean = false>(
  options: Options<GetAutoModerationRuleData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAutoModerationRuleResponse, GetAutoModerationRuleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/auto-moderation/rules/{rule_id}',
  });
};

export const deleteAutoModerationRule = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAutoModerationRuleData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAutoModerationRuleResponse,
    DeleteAutoModerationRuleError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/auto-moderation/rules/{rule_id}',
  });
};

export const updateAutoModerationRule = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAutoModerationRuleData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateAutoModerationRuleResponse,
    UpdateAutoModerationRuleError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/auto-moderation/rules/{rule_id}',
  });
};

export const listAutoModerationRules = <ThrowOnError extends boolean = false>(
  options: Options<ListAutoModerationRulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAutoModerationRulesResponse, ListAutoModerationRulesError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/auto-moderation/rules',
  });
};

export const createAutoModerationRule = <ThrowOnError extends boolean = false>(
  options: Options<CreateAutoModerationRuleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateAutoModerationRuleResponse,
    CreateAutoModerationRuleError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/auto-moderation/rules',
  });
};

export const updateSelfVoiceState = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSelfVoiceStateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateSelfVoiceStateResponse, UpdateSelfVoiceStateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/voice-states/@me',
  });
};

export const searchGuildMembers = <ThrowOnError extends boolean = false>(
  options: Options<SearchGuildMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchGuildMembersResponse, SearchGuildMembersError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/search',
  });
};

export const getActiveGuildThreads = <ThrowOnError extends boolean = false>(
  options: Options<GetActiveGuildThreadsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetActiveGuildThreadsResponse, GetActiveGuildThreadsError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/threads/active',
  });
};

export const updateMyGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMyGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateMyGuildMemberResponse, UpdateMyGuildMemberError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/@me',
  });
};

export const addGuildMemberRole = <ThrowOnError extends boolean = false>(
  options: Options<AddGuildMemberRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AddGuildMemberRoleResponse, AddGuildMemberRoleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}/roles/{role_id}',
  });
};

export const deleteGuildMemberRole = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildMemberRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildMemberRoleResponse, DeleteGuildMemberRoleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}/roles/{role_id}',
  });
};

export const leaveGuild = <ThrowOnError extends boolean = false>(options: Options<LeaveGuildData, ThrowOnError>) => {
  return (options?.client ?? client).delete<LeaveGuildResponse, LeaveGuildError, ThrowOnError>({
    ...options,
    url: '/users/@me/guilds/{guild_id}',
  });
};

export const getApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<GetApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetApplicationCommandResponse, GetApplicationCommandError, ThrowOnError>({
    ...options,
    url: '/applications/{application_id}/commands/{command_id}',
  });
};

export const deleteApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<DeleteApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteApplicationCommandResponse,
    DeleteApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/commands/{command_id}',
  });
};

export const updateApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<UpdateApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateApplicationCommandResponse,
    UpdateApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/commands/{command_id}',
  });
};

export const listApplicationCommands = <ThrowOnError extends boolean = false>(
  options: Options<ListApplicationCommandsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListApplicationCommandsResponse, ListApplicationCommandsError, ThrowOnError>({
    ...options,
    url: '/applications/{application_id}/commands',
  });
};

export const bulkSetApplicationCommands = <ThrowOnError extends boolean = false>(
  options: Options<BulkSetApplicationCommandsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    BulkSetApplicationCommandsResponse,
    BulkSetApplicationCommandsError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/commands',
  });
};

export const createApplicationCommand = <ThrowOnError extends boolean = false>(
  options: Options<CreateApplicationCommandData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateApplicationCommandResponse,
    CreateApplicationCommandError,
    ThrowOnError
  >({
    ...options,
    url: '/applications/{application_id}/commands',
  });
};

export const createInteractionResponse = <ThrowOnError extends boolean = false>(
  options: Options<CreateInteractionResponseData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateInteractionResponseResponse,
    CreateInteractionResponseError,
    ThrowOnError
  >({
    ...options,
    url: '/interactions/{interaction_id}/{interaction_token}/callback',
  });
};

export const getThreadMember = <ThrowOnError extends boolean = false>(
  options: Options<GetThreadMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetThreadMemberResponse, GetThreadMemberError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members/{user_id}',
  });
};

export const addThreadMember = <ThrowOnError extends boolean = false>(
  options: Options<AddThreadMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AddThreadMemberResponse, AddThreadMemberError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members/{user_id}',
  });
};

export const deleteThreadMember = <ThrowOnError extends boolean = false>(
  options: Options<DeleteThreadMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteThreadMemberResponse, DeleteThreadMemberError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members/{user_id}',
  });
};

export const listThreadMembers = <ThrowOnError extends boolean = false>(
  options: Options<ListThreadMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListThreadMembersResponse, ListThreadMembersError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/thread-members',
  });
};

export const setChannelPermissionOverwrite = <ThrowOnError extends boolean = false>(
  options: Options<SetChannelPermissionOverwriteData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SetChannelPermissionOverwriteResponse,
    SetChannelPermissionOverwriteError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/permissions/{overwrite_id}',
  });
};

export const deleteChannelPermissionOverwrite = <ThrowOnError extends boolean = false>(
  options: Options<DeleteChannelPermissionOverwriteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteChannelPermissionOverwriteResponse,
    DeleteChannelPermissionOverwriteError,
    ThrowOnError
  >({
    ...options,
    url: '/channels/{channel_id}/permissions/{overwrite_id}',
  });
};

export const addGroupDmUser = <ThrowOnError extends boolean = false>(
  options: Options<AddGroupDmUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AddGroupDmUserResponse, AddGroupDmUserError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/recipients/{user_id}',
  });
};

export const deleteGroupDmUser = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGroupDmUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGroupDmUserResponse, DeleteGroupDmUserError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/recipients/{user_id}',
  });
};

export const followChannel = <ThrowOnError extends boolean = false>(
  options: Options<FollowChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<FollowChannelResponse, FollowChannelError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/followers',
  });
};

export const getMessage = <ThrowOnError extends boolean = false>(options: Options<GetMessageData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetMessageResponse, GetMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}',
  });
};

export const deleteMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteMessageResponse, DeleteMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}',
  });
};

export const updateMessage = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateMessageResponse, UpdateMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages/{message_id}',
  });
};

export const listMessages = <ThrowOnError extends boolean = false>(
  options: Options<ListMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListMessagesResponse, ListMessagesError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages',
  });
};

export const createMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageResponse, CreateMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/messages',
  });
};

export const listChannelWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<ListChannelWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListChannelWebhooksResponse, ListChannelWebhooksError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/webhooks',
  });
};

export const createWebhook = <ThrowOnError extends boolean = false>(
  options: Options<CreateWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateWebhookResponse, CreateWebhookError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/webhooks',
  });
};

export const listChannelInvites = <ThrowOnError extends boolean = false>(
  options: Options<ListChannelInvitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListChannelInvitesResponse, ListChannelInvitesError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/invites',
  });
};

export const createChannelInvite = <ThrowOnError extends boolean = false>(
  options: Options<CreateChannelInviteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateChannelInviteResponse, CreateChannelInviteError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/invites',
  });
};

export const createThread = <ThrowOnError extends boolean = false>(
  options: Options<CreateThreadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateThreadResponse, CreateThreadError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/threads',
  });
};

export const triggerTypingIndicator = <ThrowOnError extends boolean = false>(
  options: Options<TriggerTypingIndicatorData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<TriggerTypingIndicatorResponse, TriggerTypingIndicatorError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/typing',
  });
};

export const pinMessage = <ThrowOnError extends boolean = false>(options: Options<PinMessageData, ThrowOnError>) => {
  return (options?.client ?? client).put<PinMessageResponse, PinMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/pins/{message_id}',
  });
};

export const unpinMessage = <ThrowOnError extends boolean = false>(
  options: Options<UnpinMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnpinMessageResponse, UnpinMessageError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/pins/{message_id}',
  });
};

export const listPinnedMessages = <ThrowOnError extends boolean = false>(
  options: Options<ListPinnedMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPinnedMessagesResponse, ListPinnedMessagesError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}/pins',
  });
};

export const getWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<GetWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWebhookMessageResponse, GetWebhookMessageError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/{message_id}',
  });
};

export const deleteWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookMessageResponse, DeleteWebhookMessageError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/{message_id}',
  });
};

export const updateWebhookMessage = <ThrowOnError extends boolean = false>(
  options: Options<UpdateWebhookMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateWebhookMessageResponse, UpdateWebhookMessageError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/messages/{message_id}',
  });
};

export const executeGithubCompatibleWebhook = <ThrowOnError extends boolean = false>(
  options: Options<ExecuteGithubCompatibleWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ExecuteGithubCompatibleWebhookResponse,
    ExecuteGithubCompatibleWebhookError,
    ThrowOnError
  >({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/github',
  });
};

export const executeSlackCompatibleWebhook = <ThrowOnError extends boolean = false>(
  options: Options<ExecuteSlackCompatibleWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ExecuteSlackCompatibleWebhookResponse,
    ExecuteSlackCompatibleWebhookError,
    ThrowOnError
  >({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}/slack',
  });
};

export const getGuildTemplate = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildTemplateResponse, GetGuildTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/templates/{code}',
  });
};

export const createGuildFromTemplate = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildFromTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildFromTemplateResponse, CreateGuildFromTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/templates/{code}',
  });
};

export const getGuildNewMemberWelcome = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildNewMemberWelcomeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildNewMemberWelcomeResponse, GetGuildNewMemberWelcomeError, ThrowOnError>(
    {
      ...options,
      url: '/guilds/{guild_id}/new-member-welcome',
    },
  );
};

export const getGuildScheduledEvent = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildScheduledEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildScheduledEventResponse, GetGuildScheduledEventError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/scheduled-events/{guild_scheduled_event_id}',
  });
};

export const deleteGuildScheduledEvent = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildScheduledEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteGuildScheduledEventResponse,
    DeleteGuildScheduledEventError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/scheduled-events/{guild_scheduled_event_id}',
  });
};

export const updateGuildScheduledEvent = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildScheduledEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateGuildScheduledEventResponse,
    UpdateGuildScheduledEventError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/scheduled-events/{guild_scheduled_event_id}',
  });
};

export const listGuildScheduledEvents = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildScheduledEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildScheduledEventsResponse, ListGuildScheduledEventsError, ThrowOnError>(
    {
      ...options,
      url: '/guilds/{guild_id}/scheduled-events',
    },
  );
};

export const createGuildScheduledEvent = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildScheduledEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateGuildScheduledEventResponse,
    CreateGuildScheduledEventError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/scheduled-events',
  });
};

export const getGuildWelcomeScreen = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildWelcomeScreenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildWelcomeScreenResponse, GetGuildWelcomeScreenError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/welcome-screen',
  });
};

export const updateGuildWelcomeScreen = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildWelcomeScreenData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateGuildWelcomeScreenResponse,
    UpdateGuildWelcomeScreenError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/welcome-screen',
  });
};

export const updateVoiceState = <ThrowOnError extends boolean = false>(
  options: Options<UpdateVoiceStateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateVoiceStateResponse, UpdateVoiceStateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/voice-states/{user_id}',
  });
};

export const deleteGuildIntegration = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildIntegrationData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildIntegrationResponse, DeleteGuildIntegrationError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/integrations/{integration_id}',
  });
};

export const listGuildIntegrations = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildIntegrationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildIntegrationsResponse, ListGuildIntegrationsError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/integrations',
  });
};

export const getGuildWidget = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildWidgetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildWidgetResponse, GetGuildWidgetError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/widget.json',
  });
};

export const getGuildsOnboarding = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildsOnboardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildsOnboardingResponse, GetGuildsOnboardingError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/onboarding',
  });
};

export const putGuildsOnboarding = <ThrowOnError extends boolean = false>(
  options: Options<PutGuildsOnboardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutGuildsOnboardingResponse, PutGuildsOnboardingError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/onboarding',
  });
};

export const getGuildVanityUrl = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildVanityUrlData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildVanityUrlResponse, GetGuildVanityUrlError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/vanity-url',
  });
};

export const listGuildAuditLogEntries = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildAuditLogEntriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildAuditLogEntriesResponse, ListGuildAuditLogEntriesError, ThrowOnError>(
    {
      ...options,
      url: '/guilds/{guild_id}/audit-logs',
    },
  );
};

export const getGuildWidgetPng = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildWidgetPngData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildWidgetPngResponse, GetGuildWidgetPngError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/widget.png',
  });
};

export const syncGuildTemplate = <ThrowOnError extends boolean = false>(
  options: Options<SyncGuildTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SyncGuildTemplateResponse, SyncGuildTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/templates/{code}',
  });
};

export const deleteGuildTemplate = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildTemplateResponse, DeleteGuildTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/templates/{code}',
  });
};

export const updateGuildTemplate = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGuildTemplateResponse, UpdateGuildTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/templates/{code}',
  });
};

export const listGuildTemplates = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildTemplatesResponse, ListGuildTemplatesError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/templates',
  });
};

export const createGuildTemplate = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildTemplateResponse, CreateGuildTemplateError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/templates',
  });
};

export const getGuildSticker = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildStickerData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildStickerResponse, GetGuildStickerError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/stickers/{sticker_id}',
  });
};

export const deleteGuildSticker = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildStickerData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildStickerResponse, DeleteGuildStickerError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/stickers/{sticker_id}',
  });
};

export const updateGuildSticker = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildStickerData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGuildStickerResponse, UpdateGuildStickerError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/stickers/{sticker_id}',
  });
};

export const listGuildStickers = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildStickersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildStickersResponse, ListGuildStickersError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/stickers',
  });
};

export const createGuildSticker = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildStickerData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildStickerResponse, CreateGuildStickerError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/guilds/{guild_id}/stickers',
  });
};

export const getGuildWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildWebhooksResponse, GetGuildWebhooksError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/webhooks',
  });
};

export const listGuildChannels = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildChannelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildChannelsResponse, ListGuildChannelsError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/channels',
  });
};

export const createGuildChannel = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildChannelResponse, CreateGuildChannelError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/channels',
  });
};

export const bulkUpdateGuildChannels = <ThrowOnError extends boolean = false>(
  options: Options<BulkUpdateGuildChannelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<BulkUpdateGuildChannelsResponse, BulkUpdateGuildChannelsError, ThrowOnError>(
    {
      ...options,
      url: '/guilds/{guild_id}/channels',
    },
  );
};

export const getGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildMemberResponse, GetGuildMemberError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}',
  });
};

export const addGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<AddGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<AddGuildMemberResponse, AddGuildMemberError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}',
  });
};

export const deleteGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildMemberResponse, DeleteGuildMemberError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}',
  });
};

export const updateGuildMember = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGuildMemberResponse, UpdateGuildMemberError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members/{user_id}',
  });
};

export const listGuildMembers = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildMembersResponse, ListGuildMembersError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/members',
  });
};

export const getGuildPreview = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildPreviewData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildPreviewResponse, GetGuildPreviewError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/preview',
  });
};

export const listGuildInvites = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildInvitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildInvitesResponse, ListGuildInvitesError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/invites',
  });
};

export const listGuildVoiceRegions = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildVoiceRegionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildVoiceRegionsResponse, ListGuildVoiceRegionsError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/regions',
  });
};

export const getGuildEmoji = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildEmojiResponse, GetGuildEmojiError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/emojis/{emoji_id}',
  });
};

export const deleteGuildEmoji = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildEmojiResponse, DeleteGuildEmojiError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/emojis/{emoji_id}',
  });
};

export const updateGuildEmoji = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGuildEmojiResponse, UpdateGuildEmojiError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/emojis/{emoji_id}',
  });
};

export const listGuildEmojis = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildEmojisData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildEmojisResponse, ListGuildEmojisError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/emojis',
  });
};

export const createGuildEmoji = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildEmojiData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildEmojiResponse, CreateGuildEmojiError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/emojis',
  });
};

export const getGuildWidgetSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetGuildWidgetSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGuildWidgetSettingsResponse, GetGuildWidgetSettingsError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/widget',
  });
};

export const updateGuildWidgetSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildWidgetSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateGuildWidgetSettingsResponse,
    UpdateGuildWidgetSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/guilds/{guild_id}/widget',
  });
};

export const deleteGuildRole = <ThrowOnError extends boolean = false>(
  options: Options<DeleteGuildRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteGuildRoleResponse, DeleteGuildRoleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/roles/{role_id}',
  });
};

export const updateGuildRole = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGuildRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateGuildRoleResponse, UpdateGuildRoleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/roles/{role_id}',
  });
};

export const listGuildRoles = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildRolesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildRolesResponse, ListGuildRolesError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/roles',
  });
};

export const createGuildRole = <ThrowOnError extends boolean = false>(
  options: Options<CreateGuildRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGuildRoleResponse, CreateGuildRoleError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/roles',
  });
};

export const bulkUpdateGuildRoles = <ThrowOnError extends boolean = false>(
  options: Options<BulkUpdateGuildRolesData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<BulkUpdateGuildRolesResponse, BulkUpdateGuildRolesError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/roles',
  });
};

export const previewPruneGuild = <ThrowOnError extends boolean = false>(
  options: Options<PreviewPruneGuildData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PreviewPruneGuildResponse, PreviewPruneGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/prune',
  });
};

export const pruneGuild = <ThrowOnError extends boolean = false>(options: Options<PruneGuildData, ThrowOnError>) => {
  return (options?.client ?? client).post<PruneGuildResponse, PruneGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/prune',
  });
};

export const getGuildBan = <ThrowOnError extends boolean = false>(options: Options<GetGuildBanData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetGuildBanResponse, GetGuildBanError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/bans/{user_id}',
  });
};

export const banUserFromGuild = <ThrowOnError extends boolean = false>(
  options: Options<BanUserFromGuildData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<BanUserFromGuildResponse, BanUserFromGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/bans/{user_id}',
  });
};

export const unbanUserFromGuild = <ThrowOnError extends boolean = false>(
  options: Options<UnbanUserFromGuildData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnbanUserFromGuildResponse, UnbanUserFromGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/bans/{user_id}',
  });
};

export const listGuildBans = <ThrowOnError extends boolean = false>(
  options: Options<ListGuildBansData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGuildBansResponse, ListGuildBansError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/bans',
  });
};

export const setGuildMfaLevel = <ThrowOnError extends boolean = false>(
  options: Options<SetGuildMfaLevelData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SetGuildMfaLevelResponse, SetGuildMfaLevelError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}/mfa',
  });
};

export const getStageInstance = <ThrowOnError extends boolean = false>(
  options: Options<GetStageInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetStageInstanceResponse, GetStageInstanceError, ThrowOnError>({
    ...options,
    url: '/stage-instances/{channel_id}',
  });
};

export const deleteStageInstance = <ThrowOnError extends boolean = false>(
  options: Options<DeleteStageInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteStageInstanceResponse, DeleteStageInstanceError, ThrowOnError>({
    ...options,
    url: '/stage-instances/{channel_id}',
  });
};

export const updateStageInstance = <ThrowOnError extends boolean = false>(
  options: Options<UpdateStageInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateStageInstanceResponse, UpdateStageInstanceError, ThrowOnError>({
    ...options,
    url: '/stage-instances/{channel_id}',
  });
};

export const getApplication = <ThrowOnError extends boolean = false>(
  options: Options<GetApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetApplicationResponse, GetApplicationError, ThrowOnError>({
    ...options,
    url: '/applications/{application_id}',
  });
};

export const updateApplication = <ThrowOnError extends boolean = false>(
  options: Options<UpdateApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateApplicationResponse, UpdateApplicationError, ThrowOnError>({
    ...options,
    url: '/applications/{application_id}',
  });
};

export const getWebhookByToken = <ThrowOnError extends boolean = false>(
  options: Options<GetWebhookByTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWebhookByTokenResponse, GetWebhookByTokenError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}',
  });
};

export const executeWebhook = <ThrowOnError extends boolean = false>(
  options: Options<ExecuteWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ExecuteWebhookResponse, ExecuteWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}',
  });
};

export const deleteWebhookByToken = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookByTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookByTokenResponse, DeleteWebhookByTokenError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}',
  });
};

export const updateWebhookByToken = <ThrowOnError extends boolean = false>(
  options: Options<UpdateWebhookByTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateWebhookByTokenResponse, UpdateWebhookByTokenError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}/{webhook_token}',
  });
};

export const getSticker = <ThrowOnError extends boolean = false>(options: Options<GetStickerData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetStickerResponse, GetStickerError, ThrowOnError>({
    ...options,
    url: '/stickers/{sticker_id}',
  });
};

export const getWebhook = <ThrowOnError extends boolean = false>(options: Options<GetWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhookResponse, GetWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}',
  });
};

export const deleteWebhook = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookResponse, DeleteWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}',
  });
};

export const updateWebhook = <ThrowOnError extends boolean = false>(
  options: Options<UpdateWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateWebhookResponse, UpdateWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_id}',
  });
};

export const getChannel = <ThrowOnError extends boolean = false>(options: Options<GetChannelData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetChannelResponse, GetChannelError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}',
  });
};

export const deleteChannel = <ThrowOnError extends boolean = false>(
  options: Options<DeleteChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteChannelResponse, DeleteChannelError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}',
  });
};

export const updateChannel = <ThrowOnError extends boolean = false>(
  options: Options<UpdateChannelData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateChannelResponse, UpdateChannelError, ThrowOnError>({
    ...options,
    url: '/channels/{channel_id}',
  });
};

export const inviteResolve = <ThrowOnError extends boolean = false>(
  options: Options<InviteResolveData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<InviteResolveResponse, InviteResolveError, ThrowOnError>({
    ...options,
    url: '/invites/{code}',
  });
};

export const inviteRevoke = <ThrowOnError extends boolean = false>(
  options: Options<InviteRevokeData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<InviteRevokeResponse, InviteRevokeError, ThrowOnError>({
    ...options,
    url: '/invites/{code}',
  });
};

export const getGuild = <ThrowOnError extends boolean = false>(options: Options<GetGuildData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetGuildResponse, GetGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}',
  });
};

export const deleteGuild = <ThrowOnError extends boolean = false>(options: Options<DeleteGuildData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteGuildResponse, DeleteGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}',
  });
};

export const updateGuild = <ThrowOnError extends boolean = false>(options: Options<UpdateGuildData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UpdateGuildResponse, UpdateGuildError, ThrowOnError>({
    ...options,
    url: '/guilds/{guild_id}',
  });
};

export const getUser = <ThrowOnError extends boolean = false>(options: Options<GetUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUserResponse, GetUserError, ThrowOnError>({
    ...options,
    url: '/users/{user_id}',
  });
};
