// This file is auto-generated by @hey-api/openapi-ts

export const AccountResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    name: {
      type: ['string', 'null'],
    },
  },
  required: ['id'],
} as const;

export const ActionRowSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    components: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/InputText',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
  },
  required: ['type', 'components'],
} as const;

export const AfkTimeoutsSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ONE_MINUTE',
      const: 60,
    },
    {
      title: 'FIVE_MINUTES',
      const: 300,
    },
    {
      title: 'FIFTEEN_MINUTES',
      const: 900,
    },
    {
      title: 'THIRTY_MINUTES',
      const: 1800,
    },
    {
      title: 'ONE_HOUR',
      const: 3600,
    },
  ],
  format: 'int32',
} as const;

export const AllowedMentionTypesSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'USERS',
      description: 'Controls role mentions',
      const: 'users',
    },
    {
      title: 'ROLES',
      description: 'Controls user mentions',
      const: 'roles',
    },
    {
      title: 'EVERYONE',
      description: 'Controls @everyone and @here mentions',
      const: 'everyone',
    },
  ],
} as const;

export const ApplicationCommandAttachmentOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [11],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandAttachmentOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [11],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandAutocompleteCallbackRequestSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [8],
      allOf: [
        {
          $ref: '#/components/schemas/InteractionCallbackTypes',
        },
      ],
      format: 'int32',
    },
    data: {
      anyOf: [
        {
          $ref: '#/components/schemas/InteractionApplicationCommandAutocompleteCallbackIntegerData',
        },
        {
          $ref: '#/components/schemas/InteractionApplicationCommandAutocompleteCallbackNumberData',
        },
        {
          $ref: '#/components/schemas/InteractionApplicationCommandAutocompleteCallbackStringData',
        },
      ],
      'x-discord-union': 'oneOf',
    },
  },
  required: ['type', 'data'],
} as const;

export const ApplicationCommandBooleanOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandBooleanOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandChannelOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [7],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    channel_types: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelTypes',
      },
      uniqueItems: true,
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandChannelOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [7],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    channel_types: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelTypes',
      },
      uniqueItems: true,
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandCreateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandGroupOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOption',
          },
        ],
      },
      maxItems: 25,
    },
    default_member_permissions: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 562949953421311,
    },
    dm_permission: {
      type: ['boolean', 'null'],
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationCommandType',
        },
      ],
    },
  },
  required: ['name'],
} as const;

export const ApplicationCommandIntegerOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionIntegerChoice',
      },
      maxItems: 25,
    },
    min_value: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Int53Type',
        },
      ],
    },
    max_value: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Int53Type',
        },
      ],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandIntegerOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionIntegerChoiceResponse',
      },
    },
    min_value: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Int53Type',
        },
      ],
    },
    max_value: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Int53Type',
        },
      ],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandMentionableOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [9],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandMentionableOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [9],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandNumberOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [10],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionNumberChoice',
      },
      maxItems: 25,
    },
    min_value: {
      type: ['number', 'null'],
      format: 'double',
    },
    max_value: {
      type: ['number', 'null'],
      format: 'double',
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandNumberOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [10],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionNumberChoiceResponse',
      },
    },
    min_value: {
      type: ['number', 'null'],
      format: 'double',
    },
    max_value: {
      type: ['number', 'null'],
      format: 'double',
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandOptionIntegerChoiceSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    value: {
      $ref: '#/components/schemas/Int53Type',
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionIntegerChoiceResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    value: {
      $ref: '#/components/schemas/Int53Type',
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionNumberChoiceSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    value: {
      type: 'number',
      format: 'double',
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionNumberChoiceResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    value: {
      type: 'number',
      format: 'double',
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionStringChoiceSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    value: {
      type: 'string',
      maxLength: 6000,
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionStringChoiceResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    value: {
      type: 'string',
    },
  },
  required: ['name', 'value'],
} as const;

export const ApplicationCommandOptionTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'SUB_COMMAND',
      description: 'A sub-action within a command or group',
      const: 1,
    },
    {
      title: 'SUB_COMMAND_GROUP',
      description: 'A group of subcommands',
      const: 2,
    },
    {
      title: 'STRING',
      description: 'A string option',
      const: 3,
    },
    {
      title: 'INTEGER',
      description: 'An integer option. Any integer between -2^53 and 2^53 is a valid value',
      const: 4,
    },
    {
      title: 'BOOLEAN',
      description: 'A boolean option',
      const: 5,
    },
    {
      title: 'USER',
      description: 'A snowflake option that represents a User',
      const: 6,
    },
    {
      title: 'CHANNEL',
      description: 'A snowflake option that represents a Channel. Includes all channel types and categories',
      const: 7,
    },
    {
      title: 'ROLE',
      description: 'A snowflake option that represents a Role',
      const: 8,
    },
    {
      title: 'MENTIONABLE',
      description: 'A snowflake option that represents anything you can mention',
      const: 9,
    },
    {
      title: 'NUMBER',
      description: 'A number option. Any double between -2^53 and 2^53 is a valid value',
      const: 10,
    },
    {
      title: 'ATTACHMENT',
      description: 'An attachment option',
      const: 11,
    },
  ],
  format: 'int32',
} as const;

export const ApplicationCommandPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandGroupOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOption',
          },
        ],
      },
      maxItems: 25,
    },
    default_member_permissions: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 562949953421311,
    },
    dm_permission: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const ApplicationCommandPermissionSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/ApplicationCommandPermissionType',
    },
    permission: {
      type: 'boolean',
    },
  },
  required: ['id', 'type', 'permission'],
} as const;

export const ApplicationCommandPermissionTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ROLE',
      description: 'This permission is for a role.',
      const: 1,
    },
    {
      title: 'USER',
      description: 'This permission is for a user.',
      const: 2,
    },
    {
      title: 'CHANNEL',
      description: 'This permission is for a channel.',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const ApplicationCommandResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    application_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    version: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    default_member_permissions: {
      type: ['string', 'null'],
    },
    type: {
      $ref: '#/components/schemas/ApplicationCommandType',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    dm_permission: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandGroupOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOptionResponse',
          },
        ],
      },
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
  },
  required: ['id', 'application_id', 'version', 'type', 'name', 'description'],
} as const;

export const ApplicationCommandRoleOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [8],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandRoleOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [8],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandStringOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    min_length: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 6000,
    },
    max_length: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 6000,
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionStringChoice',
      },
      maxItems: 25,
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandStringOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    autocomplete: {
      type: ['boolean', 'null'],
    },
    choices: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandOptionStringChoiceResponse',
      },
    },
    min_length: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_length: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandSubcommandGroupOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandSubcommandOption',
      },
      maxItems: 25,
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandSubcommandGroupOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ApplicationCommandSubcommandOptionResponse',
      },
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandSubcommandOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOption',
          },
        ],
      },
      maxItems: 25,
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandSubcommandOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOptionResponse',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOptionResponse',
          },
        ],
      },
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'CHAT',
      description: 'Slash commands; a text-based command that shows up when a user types /',
      const: 1,
    },
    {
      title: 'USER',
      description: 'A UI-based command that shows up when you right click or tap on a user',
      const: 2,
    },
    {
      title: 'MESSAGE',
      description: 'A UI-based command that shows up when you right click or tap on a message',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const ApplicationCommandUpdateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationCommandAttachmentOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandBooleanOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandChannelOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandIntegerOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandMentionableOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandNumberOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandRoleOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandStringOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandGroupOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandSubcommandOption',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandUserOption',
          },
        ],
      },
      maxItems: 25,
    },
    default_member_permissions: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 562949953421311,
    },
    dm_permission: {
      type: ['boolean', 'null'],
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationCommandType',
        },
      ],
    },
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['name'],
} as const;

export const ApplicationCommandUserOptionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [6],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 32,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 32,
      },
      maxProperties: 34,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 34,
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationCommandUserOptionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [6],
      allOf: [
        {
          $ref: '#/components/schemas/ApplicationCommandOptionType',
        },
      ],
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    name_localized: {
      type: ['string', 'null'],
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localized: {
      type: ['string', 'null'],
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    required: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'name', 'description'],
} as const;

export const ApplicationFormPartialSchema = {
  type: 'object',
  properties: {
    description: {
      type: ['object', 'null'],
      properties: {
        default: {
          type: 'string',
          maxLength: 2048,
        },
        localizations: {
          type: ['object', 'null'],
          additionalProperties: {
            type: 'string',
            maxLength: 2048,
          },
        },
      },
      required: ['default'],
    },
    icon: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    cover_image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    team_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: ['integer', 'null'],
    },
    interactions_endpoint_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    max_participants: {
      type: ['integer', 'null'],
      minimum: -1,
      format: 'int32',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    tags: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        maxLength: 20,
      },
      maxItems: 5,
      uniqueItems: true,
    },
    custom_install_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    install_params: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationOAuth2Params',
        },
      ],
    },
    role_connections_verification_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
  },
} as const;

export const ApplicationIncomingWebhookResponseSchema = {
  type: 'object',
  properties: {
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    avatar: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/WebhookTypes',
        },
      ],
      format: 'int32',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'type'],
} as const;

export const ApplicationOAuth2ParamsSchema = {
  type: 'object',
  properties: {
    scopes: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        enum: ['applications.commands', 'bot'],
        allOf: [
          {
            $ref: '#/components/schemas/OAuth2Scopes',
          },
        ],
      },
      minItems: 1,
      uniqueItems: true,
    },
    permissions: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 562949953421311,
    },
  },
} as const;

export const ApplicationOAuth2ParamsResponseSchema = {
  type: 'object',
  properties: {
    scopes: {
      type: 'array',
      items: {
        type: 'string',
        enum: ['applications.commands', 'bot'],
        allOf: [
          {
            $ref: '#/components/schemas/OAuth2Scopes',
          },
        ],
      },
      uniqueItems: true,
    },
    permissions: {
      type: 'string',
    },
  },
  required: ['scopes', 'permissions'],
} as const;

export const ApplicationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    cover_image: {
      type: ['string', 'null'],
    },
    primary_sku_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    bot: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    slug: {
      type: ['string', 'null'],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rpc_origins: {
      type: ['array', 'null'],
      items: {
        type: ['string', 'null'],
      },
    },
    bot_public: {
      type: ['boolean', 'null'],
    },
    bot_require_code_grant: {
      type: ['boolean', 'null'],
    },
    terms_of_service_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    privacy_policy_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    custom_install_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    install_params: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationOAuth2ParamsResponse',
        },
      ],
    },
    verify_key: {
      type: 'string',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    max_participants: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    tags: {
      type: ['array', 'null'],
      items: {
        type: 'string',
      },
      uniqueItems: true,
    },
  },
  required: ['id', 'name', 'description', 'verify_key', 'flags'],
} as const;

export const ApplicationRoleConnectionsMetadataItemRequestSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/MetadataItemTypes',
    },
    key: {
      type: 'string',
      minLength: 1,
      maxLength: 50,
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: ['string', 'null'],
        minLength: 1,
        maxLength: 100,
      },
      maxProperties: 1521,
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 200,
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: ['string', 'null'],
        minLength: 1,
        maxLength: 200,
      },
      maxProperties: 1521,
    },
  },
  required: ['type', 'key', 'name', 'description'],
} as const;

export const ApplicationRoleConnectionsMetadataItemResponseSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/MetadataItemTypes',
    },
    key: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    name_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    description: {
      type: 'string',
    },
    description_localizations: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
  },
  required: ['type', 'key', 'name', 'description'],
} as const;

export const ApplicationTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'GUILD_ROLE_SUBSCRIPTIONS',
      const: 4,
    },
  ],
  format: 'int32',
} as const;

export const ApplicationUserRoleConnectionResponseSchema = {
  type: 'object',
  properties: {
    platform_name: {
      type: ['string', 'null'],
    },
    platform_username: {
      type: ['string', 'null'],
    },
    metadata: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
  },
} as const;

export const AuditLogActionTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'GUILD_UPDATE',
      const: 1,
    },
    {
      title: 'CHANNEL_CREATE',
      const: 10,
    },
    {
      title: 'CHANNEL_UPDATE',
      const: 11,
    },
    {
      title: 'CHANNEL_DELETE',
      const: 12,
    },
    {
      title: 'CHANNEL_OVERWRITE_CREATE',
      const: 13,
    },
    {
      title: 'CHANNEL_OVERWRITE_UPDATE',
      const: 14,
    },
    {
      title: 'CHANNEL_OVERWRITE_DELETE',
      const: 15,
    },
    {
      title: 'MEMBER_KICK',
      const: 20,
    },
    {
      title: 'MEMBER_PRUNE',
      const: 21,
    },
    {
      title: 'MEMBER_BAN_ADD',
      const: 22,
    },
    {
      title: 'MEMBER_BAN_REMOVE',
      const: 23,
    },
    {
      title: 'MEMBER_UPDATE',
      const: 24,
    },
    {
      title: 'MEMBER_ROLE_UPDATE',
      const: 25,
    },
    {
      title: 'MEMBER_MOVE',
      const: 26,
    },
    {
      title: 'MEMBER_DISCONNECT',
      const: 27,
    },
    {
      title: 'BOT_ADD',
      const: 28,
    },
    {
      title: 'ROLE_CREATE',
      const: 30,
    },
    {
      title: 'ROLE_UPDATE',
      const: 31,
    },
    {
      title: 'ROLE_DELETE',
      const: 32,
    },
    {
      title: 'INVITE_CREATE',
      const: 40,
    },
    {
      title: 'INVITE_UPDATE',
      const: 41,
    },
    {
      title: 'INVITE_DELETE',
      const: 42,
    },
    {
      title: 'WEBHOOK_CREATE',
      const: 50,
    },
    {
      title: 'WEBHOOK_UPDATE',
      const: 51,
    },
    {
      title: 'WEBHOOK_DELETE',
      const: 52,
    },
    {
      title: 'EMOJI_CREATE',
      const: 60,
    },
    {
      title: 'EMOJI_UPDATE',
      const: 61,
    },
    {
      title: 'EMOJI_DELETE',
      const: 62,
    },
    {
      title: 'MESSAGE_DELETE',
      const: 72,
    },
    {
      title: 'MESSAGE_BULK_DELETE',
      const: 73,
    },
    {
      title: 'MESSAGE_PIN',
      const: 74,
    },
    {
      title: 'MESSAGE_UNPIN',
      const: 75,
    },
    {
      title: 'INTEGRATION_CREATE',
      const: 80,
    },
    {
      title: 'INTEGRATION_UPDATE',
      const: 81,
    },
    {
      title: 'INTEGRATION_DELETE',
      const: 82,
    },
    {
      title: 'STAGE_INSTANCE_CREATE',
      const: 83,
    },
    {
      title: 'STAGE_INSTANCE_UPDATE',
      const: 84,
    },
    {
      title: 'STAGE_INSTANCE_DELETE',
      const: 85,
    },
    {
      title: 'STICKER_CREATE',
      const: 90,
    },
    {
      title: 'STICKER_UPDATE',
      const: 91,
    },
    {
      title: 'STICKER_DELETE',
      const: 92,
    },
    {
      title: 'GUILD_SCHEDULED_EVENT_CREATE',
      const: 100,
    },
    {
      title: 'GUILD_SCHEDULED_EVENT_UPDATE',
      const: 101,
    },
    {
      title: 'GUILD_SCHEDULED_EVENT_DELETE',
      const: 102,
    },
    {
      title: 'THREAD_CREATE',
      const: 110,
    },
    {
      title: 'THREAD_UPDATE',
      const: 111,
    },
    {
      title: 'THREAD_DELETE',
      const: 112,
    },
    {
      title: 'APPLICATION_COMMAND_PERMISSION_UPDATE',
      const: 121,
    },
    {
      title: 'SOUNDBOARD_SOUND_CREATE',
      const: 130,
    },
    {
      title: 'SOUNDBOARD_SOUND_UPDATE',
      const: 131,
    },
    {
      title: 'SOUNDBOARD_SOUND_DELETE',
      const: 132,
    },
    {
      title: 'AUTO_MODERATION_RULE_CREATE',
      const: 140,
    },
    {
      title: 'AUTO_MODERATION_RULE_UPDATE',
      const: 141,
    },
    {
      title: 'AUTO_MODERATION_RULE_DELETE',
      const: 142,
    },
    {
      title: 'AUTO_MODERATION_BLOCK_MESSAGE',
      const: 143,
    },
    {
      title: 'AUTO_MODERATION_FLAG_TO_CHANNEL',
      const: 144,
    },
    {
      title: 'AUTO_MODERATION_USER_COMM_DISABLED',
      const: 145,
    },
    {
      title: 'AUTO_MODERATION_QUARANTINE_USER',
      const: 146,
    },
    {
      title: 'CREATOR_MONETIZATION_REQUEST_CREATED',
      const: 150,
    },
    {
      title: 'CREATOR_MONETIZATION_TERMS_ACCEPTED',
      const: 151,
    },
    {
      title: 'ONBOARDING_PROMPT_CREATE',
      const: 163,
    },
    {
      title: 'ONBOARDING_PROMPT_UPDATE',
      const: 164,
    },
    {
      title: 'ONBOARDING_PROMPT_DELETE',
      const: 165,
    },
    {
      title: 'ONBOARDING_CREATE',
      const: 166,
    },
    {
      title: 'ONBOARDING_UPDATE',
      const: 167,
    },
    {
      title: 'GUILD_HOME_FEATURE_ITEM',
      const: 171,
    },
    {
      title: 'GUILD_HOME_REMOVE_ITEM',
      const: 172,
    },
    {
      title: 'HARMFUL_LINKS_BLOCKED_MESSAGE',
      const: 180,
    },
    {
      title: 'HOME_SETTINGS_CREATE',
      const: 190,
    },
    {
      title: 'HOME_SETTINGS_UPDATE',
      const: 191,
    },
    {
      title: 'VOICE_CHANNEL_STATUS_CREATE',
      const: 192,
    },
    {
      title: 'VOICE_CHANNEL_STATUS_DELETE',
      const: 193,
    },
  ],
  format: 'int32',
} as const;

export const AuditLogEntryResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    action_type: {
      $ref: '#/components/schemas/AuditLogActionTypes',
    },
    user_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    target_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    changes: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/AuditLogObjectChangeResponse',
      },
    },
    options: {
      type: ['object', 'null'],
      additionalProperties: {
        type: 'string',
      },
    },
    reason: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'action_type'],
} as const;

export const AuditLogObjectChangeResponseSchema = {
  type: 'object',
  properties: {
    key: {
      type: ['string', 'null'],
    },
    new_value: {},
    old_value: {},
  },
} as const;

export const AutomodActionTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'BLOCK_MESSAGE',
      description:
        "Block a user's message and prevent it from being posted. A custom explanation can be specified and shown to members whenever their message is blocked",
      const: 1,
    },
    {
      title: 'FLAG_TO_CHANNEL',
      description: 'Send a system message to a channel in order to log the user message that triggered the rule',
      const: 2,
    },
    {
      title: 'USER_COMMUNICATION_DISABLED',
      description: "Temporarily disable a user's ability to communicate in the server (timeout)",
      const: 3,
    },
    {
      title: 'QUARANTINE_USER',
      description: 'Prevent a user from interacting in the server',
      const: 4,
    },
  ],
  format: 'int32',
} as const;

export const AutomodEventTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'MESSAGE_SEND',
      description: 'A user submitted a message to a channel',
      const: 1,
    },
    {
      title: 'GUILD_MEMBER_JOIN_OR_UPDATE',
      description: "A user is attempting to join the server or a member's properties were updated.",
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const AutomodKeywordPresetTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PROFANITY',
      description: 'Words and phrases that may be considered profanity',
      const: 1,
    },
    {
      title: 'SEXUAL_CONTENT',
      description: 'Words and phrases that may be considered as sexual content',
      const: 2,
    },
    {
      title: 'SLURS',
      description: 'Words and phrases that may be considered slurs and hate speech',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const AutomodTriggerTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'KEYWORD',
      description: 'Check if content contains words from a list of keywords or matches regex',
      const: 1,
    },
    {
      title: 'SPAM_LINK',
      description: 'DEPRECATED',
      const: 2,
    },
    {
      title: 'ML_SPAM',
      description: 'Check if content represents generic spam',
      const: 3,
    },
    {
      title: 'DEFAULT_KEYWORD_LIST',
      description: 'Check if content contains words from internal pre-defined wordsets',
      const: 4,
    },
    {
      title: 'MENTION_SPAM',
      description: 'Check if content contains more unique mentions than allowed',
      const: 5,
    },
  ],
  format: 'int32',
} as const;

export const AvailableLocalesEnumSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'ar',
      description: 'The ar locale',
      const: 'ar',
    },
    {
      title: 'bg',
      description: 'The bg locale',
      const: 'bg',
    },
    {
      title: 'cs',
      description: 'The cs locale',
      const: 'cs',
    },
    {
      title: 'da',
      description: 'The da locale',
      const: 'da',
    },
    {
      title: 'de',
      description: 'The de locale',
      const: 'de',
    },
    {
      title: 'el',
      description: 'The el locale',
      const: 'el',
    },
    {
      title: 'en-GB',
      description: 'The en-GB locale',
      const: 'en-GB',
    },
    {
      title: 'en-US',
      description: 'The en-US locale',
      const: 'en-US',
    },
    {
      title: 'es-419',
      description: 'The es-419 locale',
      const: 'es-419',
    },
    {
      title: 'es-ES',
      description: 'The es-ES locale',
      const: 'es-ES',
    },
    {
      title: 'fi',
      description: 'The fi locale',
      const: 'fi',
    },
    {
      title: 'fr',
      description: 'The fr locale',
      const: 'fr',
    },
    {
      title: 'he',
      description: 'The he locale',
      const: 'he',
    },
    {
      title: 'hi',
      description: 'The hi locale',
      const: 'hi',
    },
    {
      title: 'hr',
      description: 'The hr locale',
      const: 'hr',
    },
    {
      title: 'hu',
      description: 'The hu locale',
      const: 'hu',
    },
    {
      title: 'id',
      description: 'The id locale',
      const: 'id',
    },
    {
      title: 'it',
      description: 'The it locale',
      const: 'it',
    },
    {
      title: 'ja',
      description: 'The ja locale',
      const: 'ja',
    },
    {
      title: 'ko',
      description: 'The ko locale',
      const: 'ko',
    },
    {
      title: 'lt',
      description: 'The lt locale',
      const: 'lt',
    },
    {
      title: 'nl',
      description: 'The nl locale',
      const: 'nl',
    },
    {
      title: 'no',
      description: 'The no locale',
      const: 'no',
    },
    {
      title: 'pl',
      description: 'The pl locale',
      const: 'pl',
    },
    {
      title: 'pt-BR',
      description: 'The pt-BR locale',
      const: 'pt-BR',
    },
    {
      title: 'ro',
      description: 'The ro locale',
      const: 'ro',
    },
    {
      title: 'ru',
      description: 'The ru locale',
      const: 'ru',
    },
    {
      title: 'sv-SE',
      description: 'The sv-SE locale',
      const: 'sv-SE',
    },
    {
      title: 'th',
      description: 'The th locale',
      const: 'th',
    },
    {
      title: 'tr',
      description: 'The tr locale',
      const: 'tr',
    },
    {
      title: 'uk',
      description: 'The uk locale',
      const: 'uk',
    },
    {
      title: 'vi',
      description: 'The vi locale',
      const: 'vi',
    },
    {
      title: 'zh-CN',
      description: 'The zh-CN locale',
      const: 'zh-CN',
    },
    {
      title: 'zh-TW',
      description: 'The zh-TW locale',
      const: 'zh-TW',
    },
  ],
} as const;

export const BaseCreateMessageCreateRequestSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 4000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    sticker_ids: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 3,
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    flags: {
      type: ['integer', 'null'],
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
  },
} as const;

export const BasicApplicationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    cover_image: {
      type: ['string', 'null'],
    },
    primary_sku_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    bot: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'description'],
} as const;

export const BasicMessageResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/MessageType',
    },
    content: {
      type: 'string',
    },
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    author: {
      $ref: '#/components/schemas/UserResponse',
    },
    attachments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MessageAttachmentResponse',
      },
    },
    embeds: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MessageEmbedResponse',
      },
    },
    mentions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
    mention_roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    pinned: {
      type: 'boolean',
    },
    mention_everyone: {
      type: 'boolean',
    },
    tts: {
      type: 'boolean',
    },
    timestamp: {
      type: 'string',
      format: 'date-time',
    },
    edited_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    components: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/MessageComponentActionRowResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentButtonResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentChannelSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentInputTextResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentMentionableSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentRoleSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentStringSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentUserSelectResponse',
          },
        ],
      },
    },
    activity: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageActivityResponse',
        },
      ],
    },
    application: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/BasicApplicationResponse',
        },
      ],
    },
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    interaction: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageInteractionResponse',
        },
      ],
    },
    nonce: {
      oneOf: [
        {
          type: 'integer',
          minimum: -9223372036854776000,
          maximum: 9223372036854776000,
          format: 'int64',
        },
        {
          type: 'string',
          maxLength: 25,
          format: 'nonce',
        },
        {
          type: 'null',
        },
      ],
    },
    webhook_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    message_reference: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageReferenceResponse',
        },
      ],
    },
    thread: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadResponse',
        },
      ],
    },
    mention_channels: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/MessageMentionChannelResponse',
          },
        ],
      },
    },
    stickers: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/GuildStickerResponse',
          },
          {
            $ref: '#/components/schemas/StandardStickerResponse',
          },
        ],
      },
    },
    sticker_items: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageStickerItemResponse',
      },
    },
    role_subscription_data: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageRoleSubscriptionDataResponse',
        },
      ],
    },
    purchase_notification: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/PurchaseNotificationResponse',
        },
      ],
    },
    position: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    resolved: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ResolvedObjectsResponse',
        },
      ],
    },
  },
  required: [
    'id',
    'type',
    'content',
    'channel_id',
    'author',
    'attachments',
    'embeds',
    'mentions',
    'mention_roles',
    'pinned',
    'mention_everyone',
    'tts',
    'timestamp',
    'flags',
    'components',
  ],
} as const;

export const BlockMessageActionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/BlockMessageActionMetadata',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const BlockMessageActionMetadataSchema = {
  type: 'object',
  properties: {
    custom_message: {
      type: ['string', 'null'],
      maxLength: 150,
    },
  },
} as const;

export const BlockMessageActionMetadataResponseSchema = {
  type: 'object',
  properties: {
    custom_message: {
      type: ['string', 'null'],
    },
  },
} as const;

export const BlockMessageActionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/BlockMessageActionMetadataResponse',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const BotAccountPatchRequestSchema = {
  type: 'object',
  properties: {
    username: {
      type: 'string',
      minLength: 2,
      maxLength: 32,
    },
    avatar: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
  },
  required: ['username'],
} as const;

export const ButtonSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    style: {
      $ref: '#/components/schemas/ButtonStyleTypes',
    },
    label: {
      type: ['string', 'null'],
      maxLength: 80,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Emoji',
        },
      ],
    },
    url: {
      type: ['string', 'null'],
      maxLength: 512,
      format: 'uri',
    },
  },
  required: ['type', 'style'],
} as const;

export const ButtonStyleTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PRIMARY',
      const: 1,
    },
    {
      title: 'SECONDARY',
      const: 2,
    },
    {
      title: 'SUCCESS',
      const: 3,
    },
    {
      title: 'DANGER',
      const: 4,
    },
    {
      title: 'LINK',
      const: 5,
    },
  ],
  format: 'int32',
} as const;

export const ChannelFollowerResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    webhook_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['channel_id', 'webhook_id'],
} as const;

export const ChannelFollowerWebhookResponseSchema = {
  type: 'object',
  properties: {
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    avatar: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/WebhookTypes',
        },
      ],
      format: 'int32',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    source_guild: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/WebhookSourceGuildResponse',
        },
      ],
    },
    source_channel: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/WebhookSourceChannelResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'type'],
} as const;

export const ChannelPermissionOverwriteRequestSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ChannelPermissionOverwrites',
        },
      ],
    },
    allow: {
      type: ['integer', 'null'],
    },
    deny: {
      type: ['integer', 'null'],
    },
  },
  required: ['id'],
} as const;

export const ChannelPermissionOverwriteResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/ChannelPermissionOverwrites',
    },
    allow: {
      type: 'string',
    },
    deny: {
      type: 'string',
    },
  },
  required: ['id', 'type', 'allow', 'deny'],
} as const;

export const ChannelPermissionOverwritesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ROLE',
      const: 0,
    },
    {
      title: 'MEMBER',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const ChannelSelectSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [8],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 150,
    },
    min_values: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 25,
    },
    max_values: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 25,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    default_values: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelSelectDefaultValue',
      },
      maxItems: 25,
    },
    channel_types: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelTypes',
      },
      uniqueItems: true,
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const ChannelSelectDefaultValueSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/SnowflakeSelectDefaultValueTypes',
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['type', 'id'],
} as const;

export const ChannelTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'DM',
      description: 'A direct message between users',
      const: 1,
    },
    {
      title: 'GROUP_DM',
      description: 'A direct message between multiple users',
      const: 3,
    },
    {
      title: 'GUILD_TEXT',
      description: 'A text channel within a server',
      const: 0,
    },
    {
      title: 'GUILD_VOICE',
      description: 'A voice channel within a server',
      const: 2,
    },
    {
      title: 'GUILD_CATEGORY',
      description: 'An organizational category that contains up to 50 channels',
      const: 4,
    },
    {
      title: 'GUILD_ANNOUNCEMENT',
      description: 'A channel that users can follow and crosspost into their own server (formerly news channels)',
      const: 5,
    },
    {
      title: 'ANNOUNCEMENT_THREAD',
      description: 'A temporary sub-channel within a GUILD_ANNOUNCEMENT channel',
      const: 10,
    },
    {
      title: 'PUBLIC_THREAD',
      description: 'A temporary sub-channel within a GUILD_TEXT or GUILD_THREADS_ONLY channel type set',
      const: 11,
    },
    {
      title: 'PRIVATE_THREAD',
      description:
        'A temporary sub-channel within a GUILD_TEXT channel that is only viewable by those invited and those with the MANAGE_THREADS permission',
      const: 12,
    },
    {
      title: 'GUILD_STAGE_VOICE',
      description: 'A voice channel for hosting events with an audience',
      const: 13,
    },
    {
      title: 'GUILD_DIRECTORY',
      description: 'The channel in a hub containing the listed servers',
      const: 14,
    },
    {
      title: 'GUILD_FORUM',
      description: 'Channel that can only contain threads',
      const: 15,
    },
  ],
  format: 'int32',
} as const;

export const CommandPermissionResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/ApplicationCommandPermissionType',
    },
    permission: {
      type: 'boolean',
    },
  },
  required: ['id', 'type', 'permission'],
} as const;

export const CommandPermissionsResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    application_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    permissions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CommandPermissionResponse',
      },
    },
  },
  required: ['id', 'application_id', 'guild_id', 'permissions'],
} as const;

export const ConnectedAccountGuildResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'name'],
} as const;

export const ConnectedAccountIntegrationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    type: {
      $ref: '#/components/schemas/IntegrationTypes',
    },
    account: {
      $ref: '#/components/schemas/AccountResponse',
    },
    guild: {
      $ref: '#/components/schemas/ConnectedAccountGuildResponse',
    },
  },
  required: ['id', 'type', 'account', 'guild'],
} as const;

export const ConnectedAccountProvidersSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'BATTLENET',
      const: 'battlenet',
    },
    {
      title: 'EBAY',
      const: 'ebay',
    },
    {
      title: 'EPIC_GAMES',
      const: 'epicgames',
    },
    {
      title: 'FACEBOOK',
      const: 'facebook',
    },
    {
      title: 'GITHUB',
      const: 'github',
    },
    {
      title: 'INSTAGRAM',
      const: 'instagram',
    },
    {
      title: 'LEAGUE_OF_LEGENDS',
      const: 'leagueoflegends',
    },
    {
      title: 'PAYPAL',
      const: 'paypal',
    },
    {
      title: 'PLAYSTATION',
      const: 'playstation',
    },
    {
      title: 'REDDIT',
      const: 'reddit',
    },
    {
      title: 'RIOT_GAMES',
      const: 'riotgames',
    },
    {
      title: 'SKYPE',
      const: 'skype',
    },
    {
      title: 'SPOTIFY',
      const: 'spotify',
    },
    {
      title: 'STEAM',
      const: 'steam',
    },
    {
      title: 'TIKTOK',
      const: 'tiktok',
    },
    {
      title: 'TWITCH',
      const: 'twitch',
    },
    {
      title: 'TWITTER',
      const: 'twitter',
    },
    {
      title: 'XBOX',
      const: 'xbox',
    },
    {
      title: 'YOUTUBE',
      const: 'youtube',
    },
  ],
} as const;

export const ConnectedAccountResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    name: {
      type: ['string', 'null'],
    },
    type: {
      $ref: '#/components/schemas/ConnectedAccountProviders',
    },
    friend_sync: {
      type: 'boolean',
    },
    integrations: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ConnectedAccountIntegrationResponse',
      },
    },
    show_activity: {
      type: 'boolean',
    },
    two_way_link: {
      type: 'boolean',
    },
    verified: {
      type: 'boolean',
    },
    visibility: {
      $ref: '#/components/schemas/ConnectedAccountVisibility',
    },
    revoked: {
      type: ['boolean', 'null'],
    },
  },
  required: ['id', 'type', 'friend_sync', 'show_activity', 'two_way_link', 'verified', 'visibility'],
} as const;

export const ConnectedAccountVisibilitySchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      const: 0,
    },
    {
      title: 'EVERYONE',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const CreateForumThreadRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    applied_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 5,
    },
    message: {
      $ref: '#/components/schemas/BaseCreateMessageCreateRequest',
    },
  },
  required: ['name', 'message'],
} as const;

export const CreateGroupDMInviteRequestSchema = {
  type: 'object',
  properties: {
    max_age: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 604800,
    },
  },
} as const;

export const CreateGuildChannelRequestSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [0, 2, 4, 5, 13, 14, 15],
          allOf: [
            {
              $ref: '#/components/schemas/ChannelTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    position: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    topic: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 4096,
    },
    bitrate: {
      type: ['integer', 'null'],
      minimum: 8000,
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    permission_overwrites: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelPermissionOverwriteRequest',
      },
      maxItems: 100,
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    default_auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    default_reaction_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UpdateDefaultReactionEmojiRequest',
        },
      ],
    },
    default_thread_rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    default_sort_order: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadSortOrder',
        },
      ],
    },
    default_forum_layout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ForumLayout',
        },
      ],
    },
    available_tags: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/CreateOrUpdateThreadTagRequest',
          },
        ],
      },
      maxItems: 20,
    },
  },
  required: ['name'],
} as const;

export const CreateGuildInviteRequestSchema = {
  type: 'object',
  properties: {
    max_age: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 2592000,
    },
    temporary: {
      type: ['boolean', 'null'],
    },
    max_uses: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 100,
    },
    unique: {
      type: ['boolean', 'null'],
    },
    target_user_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    target_application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    target_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [1, 2],
          allOf: [
            {
              $ref: '#/components/schemas/InviteTargetTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
  },
} as const;

export const CreateGuildRequestChannelItemSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [0, 2, 4],
          allOf: [
            {
              $ref: '#/components/schemas/ChannelTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    position: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    topic: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 4096,
    },
    bitrate: {
      type: ['integer', 'null'],
      minimum: 8000,
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    permission_overwrites: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelPermissionOverwriteRequest',
      },
      maxItems: 100,
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    default_auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    default_reaction_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UpdateDefaultReactionEmojiRequest',
        },
      ],
    },
    default_thread_rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    default_sort_order: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadSortOrder',
        },
      ],
    },
    default_forum_layout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ForumLayout',
        },
      ],
    },
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    available_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/CreateOrUpdateThreadTagRequest',
      },
      maxItems: 20,
    },
  },
  required: ['name'],
} as const;

export const CreateGuildRequestRoleItemSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    name: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    permissions: {
      type: ['integer', 'null'],
    },
    color: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 16777215,
    },
    hoist: {
      type: ['boolean', 'null'],
    },
    mentionable: {
      type: ['boolean', 'null'],
    },
    unicode_emoji: {
      type: ['string', 'null'],
      maxLength: 100,
    },
  },
  required: ['id'],
} as const;

export const CreateMessageInteractionCallbackRequestSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4, 5],
      allOf: [
        {
          $ref: '#/components/schemas/InteractionCallbackTypes',
        },
      ],
      format: 'int32',
    },
    data: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/IncomingWebhookInteractionRequest',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const CreateOrUpdateThreadTagRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 0,
      maxLength: 20,
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    moderated: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name'],
} as const;

export const CreatePrivateChannelRequestSchema = {
  type: 'object',
  properties: {
    recipient_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    access_tokens: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        maxLength: 152133,
      },
      maxItems: 1521,
      uniqueItems: true,
    },
    nicks: {
      type: ['object', 'null'],
      additionalProperties: {
        type: ['string', 'null'],
        maxLength: 152133,
      },
      maxProperties: 1521,
    },
  },
} as const;

export const CreateTextThreadWithMessageRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
  },
  required: ['name'],
} as const;

export const CreateTextThreadWithoutMessageRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [10, 11, 12],
          allOf: [
            {
              $ref: '#/components/schemas/ChannelTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    invitable: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name'],
} as const;

export const CreatedThreadResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'integer',
      enum: [10, 11, 12],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    last_message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    last_pin_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    bitrate: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    permissions: {
      type: ['string', 'null'],
    },
    owner_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    thread_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadMetadataResponse',
        },
      ],
    },
    message_count: {
      type: 'integer',
      format: 'int32',
    },
    member_count: {
      type: 'integer',
      format: 'int32',
    },
    total_message_sent: {
      type: 'integer',
      format: 'int32',
    },
    applied_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
    },
    member: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadMemberResponse',
        },
      ],
    },
  },
  required: [
    'id',
    'type',
    'flags',
    'guild_id',
    'name',
    'owner_id',
    'message_count',
    'member_count',
    'total_message_sent',
  ],
} as const;

export const DefaultKeywordListTriggerMetadataSchema = {
  type: 'object',
  properties: {
    allow_list: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        minLength: 1,
        maxLength: 60,
      },
      maxItems: 1000,
    },
    presets: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/AutomodKeywordPresetType',
      },
      uniqueItems: true,
    },
  },
} as const;

export const DefaultKeywordListTriggerMetadataResponseSchema = {
  type: 'object',
  properties: {
    allow_list: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    presets: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AutomodKeywordPresetType',
      },
      uniqueItems: true,
    },
  },
  required: ['allow_list', 'presets'],
} as const;

export const DefaultKeywordListUpsertRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      $ref: '#/components/schemas/DefaultKeywordListTriggerMetadata',
    },
  },
  required: ['name', 'event_type', 'trigger_type', 'trigger_metadata'],
} as const;

export const DefaultKeywordListUpsertRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      $ref: '#/components/schemas/DefaultKeywordListTriggerMetadata',
    },
  },
} as const;

export const DefaultKeywordRuleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageActionResponse',
          },
          {
            $ref: '#/components/schemas/FlagToChannelActionResponse',
          },
          {
            $ref: '#/components/schemas/QuarantineUserActionResponse',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledActionResponse',
          },
        ],
      },
    },
    trigger_type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    trigger_metadata: {
      $ref: '#/components/schemas/DefaultKeywordListTriggerMetadataResponse',
    },
  },
  required: ['id', 'guild_id', 'creator_id', 'name', 'event_type', 'actions', 'trigger_type', 'trigger_metadata'],
} as const;

export const DefaultReactionEmojiResponseSchema = {
  type: 'object',
  properties: {
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
    },
  },
} as const;

export const DiscordIntegrationResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
      enum: ['discord'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    application: {
      $ref: '#/components/schemas/IntegrationApplicationResponse',
    },
    scopes: {
      type: 'array',
      items: {
        type: 'string',
        enum: ['applications.commands', 'bot', 'webhook.incoming'],
        allOf: [
          {
            $ref: '#/components/schemas/OAuth2Scopes',
          },
        ],
      },
      uniqueItems: true,
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['type', 'id', 'application', 'scopes'],
} as const;

export const EmojiSchema = {
  type: 'object',
  properties: {
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    name: {
      type: 'string',
      maxLength: 32,
    },
    animated: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name'],
} as const;

export const EmojiResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
    },
    require_colons: {
      type: 'boolean',
    },
    managed: {
      type: 'boolean',
    },
    animated: {
      type: 'boolean',
    },
    available: {
      type: 'boolean',
    },
  },
  required: ['id', 'name', 'roles', 'require_colons', 'managed', 'animated', 'available'],
} as const;

export const EntityMetadataExternalSchema = {
  type: 'object',
  properties: {
    location: {
      type: 'string',
      maxLength: 100,
    },
  },
  required: ['location'],
} as const;

export const EntityMetadataExternalResponseSchema = {
  type: 'object',
  properties: {
    location: {
      type: 'string',
    },
  },
  required: ['location'],
} as const;

export const EntityMetadataStageInstanceSchema = {
  type: 'object',
  properties: {},
} as const;

export const EntityMetadataStageInstanceResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const EntityMetadataVoiceSchema = {
  type: 'object',
  properties: {},
} as const;

export const EntityMetadataVoiceResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const ExternalConnectionIntegrationResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
      enum: ['twitch', 'youtube'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    id: {
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/UserResponse',
    },
    revoked: {
      type: ['boolean', 'null'],
    },
    expire_behavior: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/IntegrationExpireBehaviorTypes',
        },
      ],
    },
    expire_grace_period: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/IntegrationExpireGracePeriodTypes',
        },
      ],
    },
    subscriber_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    synced_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    role_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    syncing: {
      type: ['boolean', 'null'],
    },
    enable_emoticons: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'id', 'user'],
} as const;

export const ExternalScheduledEventCreateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    entity_type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      $ref: '#/components/schemas/EntityMetadataExternal',
    },
  },
  required: ['name', 'scheduled_start_time', 'privacy_level', 'entity_type', 'entity_metadata'],
} as const;

export const ExternalScheduledEventPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    status: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildScheduledEventStatuses',
        },
      ],
    },
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    entity_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [3],
          allOf: [
            {
              $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      $ref: '#/components/schemas/EntityMetadataExternal',
    },
  },
} as const;

export const ExternalScheduledEventResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    image: {
      type: ['string', 'null'],
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    status: {
      $ref: '#/components/schemas/GuildScheduledEventStatuses',
    },
    entity_type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    entity_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    user_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    user_rsvp: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ScheduledEventUserResponse',
        },
      ],
    },
    entity_metadata: {
      $ref: '#/components/schemas/EntityMetadataExternalResponse',
    },
  },
  required: [
    'id',
    'guild_id',
    'name',
    'scheduled_start_time',
    'status',
    'entity_type',
    'privacy_level',
    'entity_metadata',
  ],
} as const;

export const FlagToChannelActionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/FlagToChannelActionMetadata',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const FlagToChannelActionMetadataSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['channel_id'],
} as const;

export const FlagToChannelActionMetadataResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['channel_id'],
} as const;

export const FlagToChannelActionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/FlagToChannelActionMetadataResponse',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const ForumLayoutSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'DEFAULT',
      description: 'No default has been set for forum channel',
      const: 0,
    },
    {
      title: 'LIST',
      description: 'Display posts as a list',
      const: 1,
    },
    {
      title: 'GRID',
      description: 'Display posts as a collection of tiles',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const ForumTagResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    moderated: {
      type: 'boolean',
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'name', 'moderated'],
} as const;

export const FriendInviteResponseSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [2],
          allOf: [
            {
              $ref: '#/components/schemas/InviteTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    code: {
      type: 'string',
    },
    inviter: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    max_age: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    created_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    expires_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    friends_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    channel: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteChannelResponse',
        },
      ],
    },
    is_contact: {
      type: ['boolean', 'null'],
    },
    uses: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_uses: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    flags: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['code'],
} as const;

export const GatewayBotResponseSchema = {
  type: 'object',
  properties: {
    url: {
      type: 'string',
      format: 'uri',
    },
    session_start_limit: {
      $ref: '#/components/schemas/GatewayBotSessionStartLimitResponse',
    },
    shards: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['url', 'session_start_limit', 'shards'],
} as const;

export const GatewayBotSessionStartLimitResponseSchema = {
  type: 'object',
  properties: {
    max_concurrency: {
      type: 'integer',
      format: 'int32',
    },
    remaining: {
      type: 'integer',
      format: 'int32',
    },
    reset_after: {
      type: 'integer',
      format: 'int32',
    },
    total: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['max_concurrency', 'remaining', 'reset_after', 'total'],
} as const;

export const GatewayResponseSchema = {
  type: 'object',
  properties: {
    url: {
      type: 'string',
      format: 'uri',
    },
  },
  required: ['url'],
} as const;

export const GithubAuthorSchema = {
  type: 'object',
  properties: {
    username: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    name: {
      type: 'string',
      maxLength: 152133,
    },
  },
  required: ['name'],
} as const;

export const GithubCheckAppSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 152133,
    },
  },
  required: ['name'],
} as const;

export const GithubCheckPullRequestSchema = {
  type: 'object',
  properties: {
    number: {
      type: 'integer',
    },
  },
  required: ['number'],
} as const;

export const GithubCheckRunSchema = {
  type: 'object',
  properties: {
    conclusion: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    name: {
      type: 'string',
      maxLength: 152133,
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    check_suite: {
      $ref: '#/components/schemas/GithubCheckSuite',
    },
    details_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    output: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubCheckRunOutput',
        },
      ],
    },
    pull_requests: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GithubCheckPullRequest',
      },
      maxItems: 1521,
    },
  },
  required: ['name', 'html_url', 'check_suite'],
} as const;

export const GithubCheckRunOutputSchema = {
  type: 'object',
  properties: {
    title: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    summary: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
  },
} as const;

export const GithubCheckSuiteSchema = {
  type: 'object',
  properties: {
    conclusion: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    head_branch: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    head_sha: {
      type: 'string',
      maxLength: 152133,
    },
    pull_requests: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GithubCheckPullRequest',
      },
      maxItems: 1521,
    },
    app: {
      $ref: '#/components/schemas/GithubCheckApp',
    },
  },
  required: ['head_sha', 'app'],
} as const;

export const GithubCommentSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    user: {
      $ref: '#/components/schemas/GithubUser',
    },
    commit_id: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    body: {
      type: 'string',
      maxLength: 152133,
    },
  },
  required: ['id', 'html_url', 'user', 'body'],
} as const;

export const GithubCommitSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      maxLength: 152133,
    },
    url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    message: {
      type: 'string',
      maxLength: 152133,
    },
    author: {
      $ref: '#/components/schemas/GithubAuthor',
    },
  },
  required: ['id', 'url', 'message', 'author'],
} as const;

export const GithubDiscussionSchema = {
  type: 'object',
  properties: {
    title: {
      type: 'string',
      maxLength: 152133,
    },
    number: {
      type: 'integer',
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    answer_html_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    body: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    user: {
      $ref: '#/components/schemas/GithubUser',
    },
  },
  required: ['title', 'number', 'html_url', 'user'],
} as const;

export const GithubIssueSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    number: {
      type: 'integer',
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    user: {
      $ref: '#/components/schemas/GithubUser',
    },
    title: {
      type: 'string',
      maxLength: 152133,
    },
    body: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    pull_request: {},
  },
  required: ['id', 'number', 'html_url', 'user', 'title'],
} as const;

export const GithubReleaseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    tag_name: {
      type: 'string',
      maxLength: 152133,
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    author: {
      $ref: '#/components/schemas/GithubUser',
    },
  },
  required: ['id', 'tag_name', 'html_url', 'author'],
} as const;

export const GithubRepositorySchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    name: {
      type: 'string',
      maxLength: 152133,
    },
    full_name: {
      type: 'string',
      maxLength: 152133,
    },
  },
  required: ['id', 'html_url', 'name', 'full_name'],
} as const;

export const GithubReviewSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/GithubUser',
    },
    body: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    state: {
      type: 'string',
      maxLength: 152133,
    },
  },
  required: ['user', 'html_url', 'state'],
} as const;

export const GithubUserSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
    },
    login: {
      type: 'string',
      maxLength: 152133,
    },
    html_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
    avatar_url: {
      type: 'string',
      maxLength: 2048,
      format: 'uri',
    },
  },
  required: ['id', 'login', 'html_url', 'avatar_url'],
} as const;

export const GithubWebhookSchema = {
  type: 'object',
  properties: {
    action: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    ref: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    ref_type: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    comment: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubComment',
        },
      ],
    },
    issue: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubIssue',
        },
      ],
    },
    pull_request: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubIssue',
        },
      ],
    },
    repository: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubRepository',
        },
      ],
    },
    forkee: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubRepository',
        },
      ],
    },
    sender: {
      $ref: '#/components/schemas/GithubUser',
    },
    member: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubUser',
        },
      ],
    },
    release: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubRelease',
        },
      ],
    },
    head_commit: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubCommit',
        },
      ],
    },
    commits: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GithubCommit',
      },
      maxItems: 1521,
    },
    forced: {
      type: ['boolean', 'null'],
    },
    compare: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    review: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubReview',
        },
      ],
    },
    check_run: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubCheckRun',
        },
      ],
    },
    check_suite: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubCheckSuite',
        },
      ],
    },
    discussion: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubDiscussion',
        },
      ],
    },
    answer: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GithubComment',
        },
      ],
    },
  },
  required: ['sender'],
} as const;

export const GroupDMInviteResponseSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [1],
          allOf: [
            {
              $ref: '#/components/schemas/InviteTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    code: {
      type: 'string',
    },
    inviter: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    max_age: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    created_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    expires_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    channel: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteChannelResponse',
        },
      ],
    },
    approximate_member_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['code'],
} as const;

export const GuildAuditLogResponseSchema = {
  type: 'object',
  properties: {
    audit_log_entries: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AuditLogEntryResponse',
      },
    },
    users: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
    integrations: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/PartialDiscordIntegrationResponse',
          },
          {
            $ref: '#/components/schemas/PartialExternalConnectionIntegrationResponse',
          },
          {
            $ref: '#/components/schemas/PartialGuildSubscriptionIntegrationResponse',
          },
        ],
      },
    },
    webhooks: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ApplicationIncomingWebhookResponse',
          },
          {
            $ref: '#/components/schemas/ChannelFollowerWebhookResponse',
          },
          {
            $ref: '#/components/schemas/GuildIncomingWebhookResponse',
          },
        ],
      },
    },
    guild_scheduled_events: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ExternalScheduledEventResponse',
          },
          {
            $ref: '#/components/schemas/StageScheduledEventResponse',
          },
          {
            $ref: '#/components/schemas/VoiceScheduledEventResponse',
          },
        ],
      },
    },
    threads: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ThreadResponse',
      },
    },
    application_commands: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ApplicationCommandResponse',
      },
    },
    auto_moderation_rules: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/DefaultKeywordRuleResponse',
          },
          {
            $ref: '#/components/schemas/KeywordRuleResponse',
          },
          {
            $ref: '#/components/schemas/MLSpamRuleResponse',
          },
          {
            $ref: '#/components/schemas/MentionSpamRuleResponse',
          },
          {
            $ref: '#/components/schemas/SpamLinkRuleResponse',
          },
          {
            type: 'null',
          },
        ],
      },
    },
  },
  required: [
    'audit_log_entries',
    'users',
    'integrations',
    'webhooks',
    'guild_scheduled_events',
    'threads',
    'application_commands',
    'auto_moderation_rules',
  ],
} as const;

export const GuildBanResponseSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/UserResponse',
    },
    reason: {
      type: ['string', 'null'],
    },
  },
  required: ['user'],
} as const;

export const GuildChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'integer',
      enum: [0, 2, 4, 5, 13, 14, 15],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    last_message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    last_pin_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    bitrate: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    permissions: {
      type: ['string', 'null'],
    },
    topic: {
      type: ['string', 'null'],
    },
    default_auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    default_thread_rate_limit_per_user: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    position: {
      type: 'integer',
      format: 'int32',
    },
    permission_overwrites: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelPermissionOverwriteResponse',
      },
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
    available_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ForumTagResponse',
      },
    },
    default_reaction_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/DefaultReactionEmojiResponse',
        },
      ],
    },
    default_sort_order: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadSortOrder',
        },
      ],
    },
    default_forum_layout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ForumLayout',
        },
      ],
    },
  },
  required: ['id', 'type', 'flags', 'guild_id', 'name', 'position'],
} as const;

export const GuildCreateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 2,
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 1024,
    },
    region: {
      type: ['string', 'null'],
    },
    icon: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    verification_level: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VerificationLevels',
        },
      ],
    },
    default_message_notifications: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserNotificationSettings',
        },
      ],
    },
    explicit_content_filter: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildExplicitContentFilterTypes',
        },
      ],
    },
    preferred_locale: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AvailableLocalesEnum',
        },
      ],
    },
    afk_timeout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AfkTimeouts',
        },
      ],
    },
    roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/CreateGuildRequestRoleItem',
      },
      maxItems: 1521,
    },
    channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/CreateGuildRequestChannelItem',
      },
      maxItems: 1521,
    },
    afk_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_flags: {
      type: ['integer', 'null'],
    },
  },
  required: ['name'],
} as const;

export const GuildExplicitContentFilterTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'DISABLED',
      description: 'media content will not be scanned',
      const: 0,
    },
    {
      title: 'MEMBERS_WITHOUT_ROLES',
      description: 'media content sent by members without roles will be scanned',
      const: 1,
    },
    {
      title: 'ALL_MEMBERS',
      description: 'media content sent by all members will be scanned',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const GuildFeaturesSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'ANIMATED_BANNER',
      description: 'guild has access to set an animated guild banner image',
      const: 'ANIMATED_BANNER',
    },
    {
      title: 'ANIMATED_ICON',
      description: 'guild has access to set an animated guild icon',
      const: 'ANIMATED_ICON',
    },
    {
      title: 'APPLICATION_COMMAND_PERMISSIONS_V2',
      description: 'guild is using the old permissions configuration behavior',
      const: 'APPLICATION_COMMAND_PERMISSIONS_V2',
    },
    {
      title: 'AUTO_MODERATION',
      description: 'guild has set up auto moderation rules',
      const: 'AUTO_MODERATION',
    },
    {
      title: 'BANNER',
      description: 'guild has access to set a guild banner image',
      const: 'BANNER',
    },
    {
      title: 'COMMUNITY',
      description:
        'guild can enable welcome screen, Membership Screening, stage channels and discovery, and             receives community updates',
      const: 'COMMUNITY',
    },
    {
      title: 'CREATOR_MONETIZABLE_PROVISIONAL',
      description: 'guild has enabled monetization',
      const: 'CREATOR_MONETIZABLE_PROVISIONAL',
    },
    {
      title: 'CREATOR_STORE_PAGE',
      description: 'guild has enabled the role subscription promo page',
      const: 'CREATOR_STORE_PAGE',
    },
    {
      title: 'DEVELOPER_SUPPORT_SERVER',
      description: 'guild has been set as a support server on the App Directory',
      const: 'DEVELOPER_SUPPORT_SERVER',
    },
    {
      title: 'DISCOVERABLE',
      description: 'guild is able to be discovered in the directory',
      const: 'DISCOVERABLE',
    },
    {
      title: 'FEATURABLE',
      description: 'guild is able to be featured in the directory',
      const: 'FEATURABLE',
    },
    {
      title: 'INVITES_DISABLED',
      description: 'guild has paused invites, preventing new users from joining',
      const: 'INVITES_DISABLED',
    },
    {
      title: 'INVITE_SPLASH',
      description: 'guild has access to set an invite splash background',
      const: 'INVITE_SPLASH',
    },
    {
      title: 'MEMBER_VERIFICATION_GATE_ENABLED',
      description: 'guild has enabled Membership Screening',
      const: 'MEMBER_VERIFICATION_GATE_ENABLED',
    },
    {
      title: 'MORE_STICKERS',
      description: 'guild has increased custom sticker slots',
      const: 'MORE_STICKERS',
    },
    {
      title: 'NEWS',
      description: 'guild has access to create announcement channels',
      const: 'NEWS',
    },
    {
      title: 'PARTNERED',
      description: 'guild is partnered',
      const: 'PARTNERED',
    },
    {
      title: 'PREVIEW_ENABLED',
      description: 'guild can be previewed before joining via Membership Screening or the directory',
      const: 'PREVIEW_ENABLED',
    },
    {
      title: 'RAID_ALERTS_DISABLED',
      description: 'guild has disabled activity alerts in the configured safety alerts channel',
      const: 'RAID_ALERTS_DISABLED',
    },
    {
      title: 'ROLE_ICONS',
      description: 'guild is able to set role icons',
      const: 'ROLE_ICONS',
    },
    {
      title: 'ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE',
      description: 'guild has role subscriptions that can be purchased',
      const: 'ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE',
    },
    {
      title: 'ROLE_SUBSCRIPTIONS_ENABLED',
      description: 'guild has enabled role subscriptions',
      const: 'ROLE_SUBSCRIPTIONS_ENABLED',
    },
    {
      title: 'TICKETED_EVENTS_ENABLED',
      description: 'guild has enabled ticketed events',
      const: 'TICKETED_EVENTS_ENABLED',
    },
    {
      title: 'VANITY_URL',
      description: 'guild has access to set a vanity URL',
      const: 'VANITY_URL',
    },
    {
      title: 'VERIFIED',
      description: 'guild is verified',
      const: 'VERIFIED',
    },
    {
      title: 'VIP_REGIONS',
      description: 'guild has access to set 384kbps bitrate in voice (previously VIP voice servers)',
      const: 'VIP_REGIONS',
    },
    {
      title: 'WELCOME_SCREEN_ENABLED',
      description: 'guild has enabled the welcome screen',
      const: 'WELCOME_SCREEN_ENABLED',
    },
  ],
} as const;

export const GuildHomeSettingsResponseSchema = {
  type: 'object',
  properties: {
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    enabled: {
      type: 'boolean',
    },
    welcome_message: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/WelcomeMessageResponse',
        },
      ],
    },
    new_member_actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/NewMemberActionResponse',
          },
        ],
      },
    },
    resource_channels: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/ResourceChannelResponse',
          },
        ],
      },
    },
  },
  required: ['guild_id', 'enabled'],
} as const;

export const GuildIncomingWebhookResponseSchema = {
  type: 'object',
  properties: {
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    avatar: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/WebhookTypes',
        },
      ],
      format: 'int32',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    token: {
      type: ['string', 'null'],
    },
    url: {
      type: ['string', 'null'],
      format: 'uri',
    },
  },
  required: ['id', 'name', 'type'],
} as const;

export const GuildInviteResponseSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [0],
          allOf: [
            {
              $ref: '#/components/schemas/InviteTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    code: {
      type: 'string',
    },
    inviter: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    max_age: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    created_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    expires_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    is_contact: {
      type: ['boolean', 'null'],
    },
    flags: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    guild: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteGuildResponse',
        },
      ],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    channel: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteChannelResponse',
        },
      ],
    },
    stage_instance: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteStageInstanceResponse',
        },
      ],
    },
    target_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteTargetTypes',
        },
      ],
    },
    target_user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    target_application: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/InviteApplicationResponse',
        },
      ],
    },
    guild_scheduled_event: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ScheduledEventResponse',
        },
      ],
    },
    uses: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_uses: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    temporary: {
      type: ['boolean', 'null'],
    },
    approximate_member_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    approximate_presence_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['code'],
} as const;

export const GuildMFALevelSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      description: 'Guild has no MFA/2FA requirement for moderation actions',
      const: 0,
    },
    {
      title: 'ELEVATED',
      description: 'Guild has a 2FA requirement for moderation actions',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const GuildMFALevelResponseSchema = {
  type: 'object',
  properties: {
    level: {
      $ref: '#/components/schemas/GuildMFALevel',
    },
  },
  required: ['level'],
} as const;

export const GuildMemberResponseSchema = {
  type: 'object',
  properties: {
    avatar: {
      type: ['string', 'null'],
    },
    communication_disabled_until: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    joined_at: {
      type: 'string',
      format: 'date-time',
    },
    nick: {
      type: ['string', 'null'],
    },
    pending: {
      type: 'boolean',
    },
    premium_since: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    user: {
      $ref: '#/components/schemas/UserResponse',
    },
    mute: {
      type: 'boolean',
    },
    deaf: {
      type: 'boolean',
    },
  },
  required: ['flags', 'joined_at', 'pending', 'roles', 'user', 'mute', 'deaf'],
} as const;

export const GuildNSFWContentLevelSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'DEFAULT',
      const: 0,
    },
    {
      title: 'EXPLICIT',
      const: 1,
    },
    {
      title: 'SAFE',
      const: 2,
    },
    {
      title: 'AGE_RESTRICTED',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const GuildOnboardingModeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ONBOARDING_DEFAULT',
      description: 'Only Default Channels considered in constraints',
      const: 0,
    },
    {
      title: 'ONBOARDING_ADVANCED',
      description: 'Default Channels and Onboarding Prompts considered in constraints',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const GuildOnboardingResponseSchema = {
  type: 'object',
  properties: {
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    prompts: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OnboardingPromptResponse',
      },
    },
    default_channel_ids: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    enabled: {
      type: 'boolean',
    },
  },
  required: ['guild_id', 'prompts', 'default_channel_ids', 'enabled'],
} as const;

export const GuildPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 2,
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 1024,
    },
    region: {
      type: ['string', 'null'],
    },
    icon: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    verification_level: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VerificationLevels',
        },
      ],
    },
    default_message_notifications: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserNotificationSettings',
        },
      ],
    },
    explicit_content_filter: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildExplicitContentFilterTypes',
        },
      ],
    },
    preferred_locale: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AvailableLocalesEnum',
        },
      ],
    },
    afk_timeout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AfkTimeouts',
        },
      ],
    },
    afk_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    owner_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    splash: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    banner: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    system_channel_flags: {
      type: ['integer', 'null'],
    },
    features: {
      type: ['array', 'null'],
      items: {
        type: ['string', 'null'],
        maxLength: 152133,
      },
      maxItems: 1521,
      uniqueItems: true,
    },
    discovery_splash: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    home_header: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    rules_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    safety_alerts_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    public_updates_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    premium_progress_bar_enabled: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const GuildPreviewResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    home_header: {
      type: ['string', 'null'],
    },
    splash: {
      type: ['string', 'null'],
    },
    discovery_splash: {
      type: ['string', 'null'],
    },
    features: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildFeatures',
      },
      uniqueItems: true,
    },
    approximate_member_count: {
      type: 'integer',
      format: 'int32',
    },
    approximate_presence_count: {
      type: 'integer',
      format: 'int32',
    },
    emojis: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/EmojiResponse',
      },
    },
    stickers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildStickerResponse',
      },
    },
  },
  required: ['id', 'name', 'features', 'approximate_member_count', 'approximate_presence_count', 'emojis', 'stickers'],
} as const;

export const GuildProductPurchaseResponseSchema = {
  type: 'object',
  properties: {
    listing_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    product_name: {
      type: 'string',
    },
  },
  required: ['listing_id', 'product_name'],
} as const;

export const GuildPruneResponseSchema = {
  type: 'object',
  properties: {
    pruned: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
} as const;

export const GuildResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    home_header: {
      type: ['string', 'null'],
    },
    splash: {
      type: ['string', 'null'],
    },
    discovery_splash: {
      type: ['string', 'null'],
    },
    features: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildFeatures',
      },
      uniqueItems: true,
    },
    banner: {
      type: ['string', 'null'],
    },
    owner_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    region: {
      type: 'string',
    },
    afk_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    afk_timeout: {
      $ref: '#/components/schemas/AfkTimeouts',
    },
    system_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_flags: {
      type: 'integer',
      format: 'int32',
    },
    widget_enabled: {
      type: 'boolean',
    },
    widget_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    verification_level: {
      $ref: '#/components/schemas/VerificationLevels',
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildRoleResponse',
      },
    },
    default_message_notifications: {
      $ref: '#/components/schemas/UserNotificationSettings',
    },
    mfa_level: {
      $ref: '#/components/schemas/GuildMFALevel',
    },
    explicit_content_filter: {
      $ref: '#/components/schemas/GuildExplicitContentFilterTypes',
    },
    max_presences: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_members: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_stage_video_channel_users: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_video_channel_users: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    vanity_url_code: {
      type: ['string', 'null'],
    },
    premium_tier: {
      $ref: '#/components/schemas/PremiumGuildTiers',
    },
    premium_subscription_count: {
      type: 'integer',
      format: 'int32',
    },
    preferred_locale: {
      $ref: '#/components/schemas/AvailableLocalesEnum',
    },
    rules_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    safety_alerts_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    public_updates_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    premium_progress_bar_enabled: {
      type: 'boolean',
    },
    nsfw: {
      type: 'boolean',
    },
    nsfw_level: {
      $ref: '#/components/schemas/GuildNSFWContentLevel',
    },
    emojis: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/EmojiResponse',
      },
    },
    stickers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildStickerResponse',
      },
    },
  },
  required: [
    'id',
    'name',
    'features',
    'owner_id',
    'region',
    'afk_timeout',
    'system_channel_flags',
    'widget_enabled',
    'verification_level',
    'roles',
    'default_message_notifications',
    'mfa_level',
    'explicit_content_filter',
    'premium_tier',
    'premium_subscription_count',
    'preferred_locale',
    'premium_progress_bar_enabled',
    'nsfw',
    'nsfw_level',
    'emojis',
    'stickers',
  ],
} as const;

export const GuildRoleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    permissions: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int32',
    },
    color: {
      type: 'integer',
      format: 'int32',
    },
    hoist: {
      type: 'boolean',
    },
    managed: {
      type: 'boolean',
    },
    mentionable: {
      type: 'boolean',
    },
    icon: {
      type: ['string', 'null'],
    },
    unicode_emoji: {
      type: ['string', 'null'],
    },
    tags: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildRoleTagsResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'permissions', 'position', 'color', 'hoist', 'managed', 'mentionable'],
} as const;

export const GuildRoleTagsResponseSchema = {
  type: 'object',
  properties: {
    premium_subscriber: {
      type: 'null',
    },
    bot_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    integration_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    subscription_listing_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    available_for_purchase: {
      type: 'null',
    },
    guild_connections: {
      type: 'null',
    },
  },
} as const;

export const GuildScheduledEventEntityTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      const: 0,
    },
    {
      title: 'STAGE_INSTANCE',
      const: 1,
    },
    {
      title: 'VOICE',
      const: 2,
    },
    {
      title: 'EXTERNAL',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const GuildScheduledEventPrivacyLevelsSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'GUILD_ONLY',
      description: 'the scheduled event is only accessible to guild members',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const GuildScheduledEventStatusesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'SCHEDULED',
      const: 1,
    },
    {
      title: 'ACTIVE',
      const: 2,
    },
    {
      title: 'COMPLETED',
      const: 3,
    },
    {
      title: 'CANCELED',
      const: 4,
    },
  ],
  format: 'int32',
} as const;

export const GuildStickerResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    tags: {
      type: 'string',
    },
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/StickerTypes',
        },
      ],
      format: 'int32',
    },
    format_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/StickerFormatTypes',
        },
      ],
    },
    description: {
      type: ['string', 'null'],
    },
    available: {
      type: 'boolean',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'tags', 'type', 'available', 'guild_id'],
} as const;

export const GuildSubscriptionIntegrationResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
      enum: ['guild_subscription'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['type', 'id'],
} as const;

export const GuildTemplateChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    type: {
      type: 'integer',
      enum: [0, 2, 4],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    name: {
      type: ['string', 'null'],
    },
    position: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    topic: {
      type: ['string', 'null'],
    },
    bitrate: {
      type: 'integer',
      format: 'int32',
    },
    user_limit: {
      type: 'integer',
      format: 'int32',
    },
    nsfw: {
      type: 'boolean',
    },
    rate_limit_per_user: {
      type: 'integer',
      format: 'int32',
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    default_auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    permission_overwrites: {
      type: 'array',
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/ChannelPermissionOverwriteResponse',
          },
        ],
      },
    },
    available_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GuildTemplateChannelTags',
      },
    },
    template: {
      type: 'string',
    },
    default_reaction_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/DefaultReactionEmojiResponse',
        },
      ],
    },
    default_thread_rate_limit_per_user: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    default_sort_order: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadSortOrder',
        },
      ],
    },
    default_forum_layout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ForumLayout',
        },
      ],
    },
    icon_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/IconEmojiResponse',
        },
      ],
    },
    theme_color: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['type', 'bitrate', 'user_limit', 'nsfw', 'rate_limit_per_user', 'permission_overwrites', 'template'],
} as const;

export const GuildTemplateChannelTagsSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
    },
    moderated: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name'],
} as const;

export const GuildTemplateResponseSchema = {
  type: 'object',
  properties: {
    code: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    usage_count: {
      type: 'integer',
      format: 'int32',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    created_at: {
      type: 'string',
      format: 'date-time',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
    },
    source_guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    serialized_source_guild: {
      $ref: '#/components/schemas/GuildTemplateSnapshotResponse',
    },
    is_dirty: {
      type: ['boolean', 'null'],
    },
  },
  required: [
    'code',
    'name',
    'usage_count',
    'creator_id',
    'created_at',
    'updated_at',
    'source_guild_id',
    'serialized_source_guild',
  ],
} as const;

export const GuildTemplateRoleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      format: 'int32',
    },
    name: {
      type: 'string',
    },
    permissions: {
      type: 'string',
    },
    color: {
      type: 'integer',
      format: 'int32',
    },
    hoist: {
      type: 'boolean',
    },
    mentionable: {
      type: 'boolean',
    },
    icon: {
      type: ['string', 'null'],
    },
    unicode_emoji: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'name', 'permissions', 'color', 'hoist', 'mentionable'],
} as const;

export const GuildTemplateSnapshotResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    region: {
      type: ['string', 'null'],
    },
    verification_level: {
      $ref: '#/components/schemas/VerificationLevels',
    },
    default_message_notifications: {
      $ref: '#/components/schemas/UserNotificationSettings',
    },
    explicit_content_filter: {
      $ref: '#/components/schemas/GuildExplicitContentFilterTypes',
    },
    preferred_locale: {
      $ref: '#/components/schemas/AvailableLocalesEnum',
    },
    afk_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    afk_timeout: {
      $ref: '#/components/schemas/AfkTimeouts',
    },
    system_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_flags: {
      type: 'integer',
      format: 'int32',
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildTemplateRoleResponse',
      },
    },
    channels: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildTemplateChannelResponse',
      },
    },
  },
  required: [
    'name',
    'verification_level',
    'default_message_notifications',
    'explicit_content_filter',
    'preferred_locale',
    'afk_timeout',
    'system_channel_flags',
    'roles',
    'channels',
  ],
} as const;

export const GuildWelcomeChannelSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    description: {
      type: 'string',
      minLength: 1,
      maxLength: 50,
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
  },
  required: ['channel_id', 'description'],
} as const;

export const GuildWelcomeScreenChannelResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    description: {
      type: 'string',
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
    },
  },
  required: ['channel_id', 'description'],
} as const;

export const GuildWelcomeScreenResponseSchema = {
  type: 'object',
  properties: {
    description: {
      type: ['string', 'null'],
    },
    welcome_channels: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildWelcomeScreenChannelResponse',
      },
    },
  },
  required: ['welcome_channels'],
} as const;

export const GuildWithCountsResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    home_header: {
      type: ['string', 'null'],
    },
    splash: {
      type: ['string', 'null'],
    },
    discovery_splash: {
      type: ['string', 'null'],
    },
    features: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildFeatures',
      },
      uniqueItems: true,
    },
    banner: {
      type: ['string', 'null'],
    },
    owner_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    region: {
      type: 'string',
    },
    afk_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    afk_timeout: {
      $ref: '#/components/schemas/AfkTimeouts',
    },
    system_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    system_channel_flags: {
      type: 'integer',
      format: 'int32',
    },
    widget_enabled: {
      type: 'boolean',
    },
    widget_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    verification_level: {
      $ref: '#/components/schemas/VerificationLevels',
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildRoleResponse',
      },
    },
    default_message_notifications: {
      $ref: '#/components/schemas/UserNotificationSettings',
    },
    mfa_level: {
      $ref: '#/components/schemas/GuildMFALevel',
    },
    explicit_content_filter: {
      $ref: '#/components/schemas/GuildExplicitContentFilterTypes',
    },
    max_presences: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_members: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_stage_video_channel_users: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_video_channel_users: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    vanity_url_code: {
      type: ['string', 'null'],
    },
    premium_tier: {
      $ref: '#/components/schemas/PremiumGuildTiers',
    },
    premium_subscription_count: {
      type: 'integer',
      format: 'int32',
    },
    preferred_locale: {
      $ref: '#/components/schemas/AvailableLocalesEnum',
    },
    rules_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    safety_alerts_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    public_updates_channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    premium_progress_bar_enabled: {
      type: 'boolean',
    },
    nsfw: {
      type: 'boolean',
    },
    nsfw_level: {
      $ref: '#/components/schemas/GuildNSFWContentLevel',
    },
    emojis: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/EmojiResponse',
      },
    },
    stickers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildStickerResponse',
      },
    },
    approximate_member_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    approximate_presence_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: [
    'id',
    'name',
    'features',
    'owner_id',
    'region',
    'afk_timeout',
    'system_channel_flags',
    'widget_enabled',
    'verification_level',
    'roles',
    'default_message_notifications',
    'mfa_level',
    'explicit_content_filter',
    'premium_tier',
    'premium_subscription_count',
    'preferred_locale',
    'premium_progress_bar_enabled',
    'nsfw',
    'nsfw_level',
    'emojis',
    'stickers',
  ],
} as const;

export const IconEmojiResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const IncomingWebhookInteractionRequestSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 2000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
    tts: {
      type: ['boolean', 'null'],
    },
    flags: {
      type: ['integer', 'null'],
    },
  },
} as const;

export const IncomingWebhookRequestPartialSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 2000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
    tts: {
      type: ['boolean', 'null'],
    },
    flags: {
      type: ['integer', 'null'],
    },
    username: {
      type: ['string', 'null'],
      minLength: 1,
      maxLength: 80,
    },
    avatar_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    thread_name: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 100,
    },
    applied_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 5,
    },
  },
} as const;

export const IncomingWebhookUpdateForInteractionCallbackRequestPartialSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 2000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
    flags: {
      type: ['integer', 'null'],
    },
  },
} as const;

export const IncomingWebhookUpdateRequestPartialSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 2000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
    flags: {
      type: ['integer', 'null'],
    },
  },
} as const;

export const InputTextSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    style: {
      $ref: '#/components/schemas/TextStyleTypes',
    },
    label: {
      type: 'string',
      maxLength: 45,
    },
    value: {
      type: ['string', 'null'],
      maxLength: 4000,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    required: {
      type: ['boolean', 'null'],
    },
    min_length: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 4000,
    },
    max_length: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 4000,
    },
  },
  required: ['type', 'custom_id', 'style', 'label'],
} as const;

export const Int53TypeSchema = {
  type: 'integer',
  minimum: -9007199254740991,
  maximum: 9007199254740991,
  format: 'int64',
} as const;

export const IntegrationApplicationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    cover_image: {
      type: ['string', 'null'],
    },
    primary_sku_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    bot: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'description'],
} as const;

export const IntegrationExpireBehaviorTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'REMOVE_ROLE',
      description: 'Remove role',
      const: 0,
    },
    {
      title: 'KICK',
      description: 'Kick',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const IntegrationExpireGracePeriodTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ONE_DAY',
      description: '1 day',
      const: 1,
    },
    {
      title: 'THREE_DAYS',
      description: '3 days',
      const: 3,
    },
    {
      title: 'SEVEN_DAYS',
      description: '7 days',
      const: 7,
    },
    {
      title: 'FOURTEEN_DAYS',
      description: '14 days',
      const: 14,
    },
    {
      title: 'THIRTY_DAYS',
      description: '30 days',
      const: 30,
    },
  ],
  format: 'int32',
} as const;

export const IntegrationTypesSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'DISCORD',
      const: 'discord',
    },
    {
      title: 'TWITCH',
      const: 'twitch',
    },
    {
      title: 'YOUTUBE',
      const: 'youtube',
    },
    {
      title: 'GUILD_SUBSCRIPTION',
      const: 'guild_subscription',
    },
  ],
} as const;

export const InteractionApplicationCommandAutocompleteCallbackIntegerDataSchema = {
  type: 'object',
  properties: {
    choices: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandOptionIntegerChoice',
          },
        ],
      },
      maxItems: 25,
    },
  },
} as const;

export const InteractionApplicationCommandAutocompleteCallbackNumberDataSchema = {
  type: 'object',
  properties: {
    choices: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandOptionNumberChoice',
          },
        ],
      },
      maxItems: 25,
    },
  },
} as const;

export const InteractionApplicationCommandAutocompleteCallbackStringDataSchema = {
  type: 'object',
  properties: {
    choices: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/ApplicationCommandOptionStringChoice',
          },
        ],
      },
      maxItems: 25,
    },
  },
} as const;

export const InteractionCallbackTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PONG',
      const: 1,
    },
    {
      title: 'CHANNEL_MESSAGE_WITH_SOURCE',
      const: 4,
    },
    {
      title: 'DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE',
      const: 5,
    },
    {
      title: 'DEFERRED_UPDATE_MESSAGE',
      const: 6,
    },
    {
      title: 'UPDATE_MESSAGE',
      const: 7,
    },
    {
      title: 'APPLICATION_COMMAND_AUTOCOMPLETE_RESULT',
      const: 8,
    },
    {
      title: 'MODAL',
      const: 9,
    },
  ],
  format: 'int32',
} as const;

export const InteractionTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PING',
      description: "Sent by Discord to validate your application's interaction handler",
      const: 1,
    },
    {
      title: 'APPLICATION_COMMAND',
      description: 'Sent when a user uses an application command',
      const: 2,
    },
    {
      title: 'MESSAGE_COMPONENT',
      description: 'Sent when a user interacts with a message component previously sent by your application',
      const: 3,
    },
    {
      title: 'APPLICATION_COMMAND_AUTOCOMPLETE',
      description: 'Sent when a user is filling in an autocomplete option in a chat command',
      const: 4,
    },
    {
      title: 'MODAL_SUBMIT',
      description: 'Sent when a user submits a modal previously sent by your application',
      const: 5,
    },
  ],
  format: 'int32',
} as const;

export const InviteApplicationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    cover_image: {
      type: ['string', 'null'],
    },
    primary_sku_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    bot: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    slug: {
      type: ['string', 'null'],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rpc_origins: {
      type: ['array', 'null'],
      items: {
        type: ['string', 'null'],
      },
    },
    bot_public: {
      type: ['boolean', 'null'],
    },
    bot_require_code_grant: {
      type: ['boolean', 'null'],
    },
    terms_of_service_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    privacy_policy_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    custom_install_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    install_params: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationOAuth2ParamsResponse',
        },
      ],
    },
    verify_key: {
      type: 'string',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    max_participants: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    tags: {
      type: ['array', 'null'],
      items: {
        type: 'string',
      },
      uniqueItems: true,
    },
  },
  required: ['id', 'name', 'description', 'verify_key', 'flags'],
} as const;

export const InviteChannelRecipientResponseSchema = {
  type: 'object',
  properties: {
    username: {
      type: 'string',
    },
  },
  required: ['username'],
} as const;

export const InviteChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/ChannelTypes',
    },
    name: {
      type: ['string', 'null'],
    },
    icon: {
      type: ['string', 'null'],
    },
    recipients: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/InviteChannelRecipientResponse',
      },
    },
  },
  required: ['id', 'type'],
} as const;

export const InviteGuildResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    splash: {
      type: ['string', 'null'],
    },
    banner: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    icon: {
      type: ['string', 'null'],
    },
    features: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildFeatures',
      },
      uniqueItems: true,
    },
    verification_level: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VerificationLevels',
        },
      ],
    },
    vanity_url_code: {
      type: ['string', 'null'],
    },
    nsfw_level: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildNSFWContentLevel',
        },
      ],
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
    premium_subscription_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['id', 'name', 'features'],
} as const;

export const InviteStageInstanceResponseSchema = {
  type: 'object',
  properties: {
    topic: {
      type: 'string',
    },
    participant_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    speaker_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    members: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GuildMemberResponse',
      },
    },
  },
  required: ['topic'],
} as const;

export const InviteTargetTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'STREAM',
      const: 1,
    },
    {
      title: 'EMBEDDED_APPLICATION',
      const: 2,
    },
    {
      title: 'ROLE_SUBSCRIPTIONS_PURCHASE',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const InviteTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'GUILD',
      const: 0,
    },
    {
      title: 'GROUP_DM',
      const: 1,
    },
    {
      title: 'FRIEND',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const KeywordRuleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageActionResponse',
          },
          {
            $ref: '#/components/schemas/FlagToChannelActionResponse',
          },
          {
            $ref: '#/components/schemas/QuarantineUserActionResponse',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledActionResponse',
          },
        ],
      },
    },
    trigger_type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    trigger_metadata: {
      $ref: '#/components/schemas/KeywordTriggerMetadataResponse',
    },
  },
  required: ['id', 'guild_id', 'creator_id', 'name', 'event_type', 'actions', 'trigger_type', 'trigger_metadata'],
} as const;

export const KeywordTriggerMetadataSchema = {
  type: 'object',
  properties: {
    keyword_filter: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        minLength: 1,
        maxLength: 60,
      },
      maxItems: 1000,
    },
    regex_patterns: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        minLength: 1,
        maxLength: 260,
      },
      maxItems: 10,
    },
    allow_list: {
      type: ['array', 'null'],
      items: {
        type: 'string',
        minLength: 1,
        maxLength: 60,
      },
      maxItems: 100,
    },
  },
} as const;

export const KeywordTriggerMetadataResponseSchema = {
  type: 'object',
  properties: {
    keyword_filter: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    regex_patterns: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    allow_list: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
  required: ['keyword_filter', 'regex_patterns', 'allow_list'],
} as const;

export const KeywordUpsertRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/KeywordTriggerMetadata',
        },
      ],
    },
  },
  required: ['name', 'event_type', 'trigger_type'],
} as const;

export const KeywordUpsertRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/KeywordTriggerMetadata',
        },
      ],
    },
  },
} as const;

export const MLSpamRuleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageActionResponse',
          },
          {
            $ref: '#/components/schemas/FlagToChannelActionResponse',
          },
          {
            $ref: '#/components/schemas/QuarantineUserActionResponse',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledActionResponse',
          },
        ],
      },
    },
    trigger_type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    trigger_metadata: {
      $ref: '#/components/schemas/MLSpamTriggerMetadataResponse',
    },
  },
  required: ['id', 'guild_id', 'creator_id', 'name', 'event_type', 'actions', 'trigger_type', 'trigger_metadata'],
} as const;

export const MLSpamTriggerMetadataSchema = {
  type: 'object',
  properties: {},
} as const;

export const MLSpamTriggerMetadataResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const MLSpamUpsertRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MLSpamTriggerMetadata',
        },
      ],
    },
  },
  required: ['name', 'event_type', 'trigger_type'],
} as const;

export const MLSpamUpsertRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MLSpamTriggerMetadata',
        },
      ],
    },
  },
} as const;

export const MentionSpamRuleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageActionResponse',
          },
          {
            $ref: '#/components/schemas/FlagToChannelActionResponse',
          },
          {
            $ref: '#/components/schemas/QuarantineUserActionResponse',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledActionResponse',
          },
        ],
      },
    },
    trigger_type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    trigger_metadata: {
      $ref: '#/components/schemas/MentionSpamTriggerMetadataResponse',
    },
  },
  required: ['id', 'guild_id', 'creator_id', 'name', 'event_type', 'actions', 'trigger_type', 'trigger_metadata'],
} as const;

export const MentionSpamTriggerMetadataSchema = {
  type: 'object',
  properties: {
    mention_total_limit: {
      type: 'integer',
      minimum: 0,
      maximum: 50,
    },
    mention_raid_protection_enabled: {
      type: ['boolean', 'null'],
    },
  },
  required: ['mention_total_limit'],
} as const;

export const MentionSpamTriggerMetadataResponseSchema = {
  type: 'object',
  properties: {
    mention_total_limit: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['mention_total_limit'],
} as const;

export const MentionSpamUpsertRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MentionSpamTriggerMetadata',
        },
      ],
    },
  },
  required: ['name', 'event_type', 'trigger_type'],
} as const;

export const MentionSpamUpsertRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageAction',
          },
          {
            $ref: '#/components/schemas/FlagToChannelAction',
          },
          {
            $ref: '#/components/schemas/QuarantineUserAction',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledAction',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 20,
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    trigger_type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    trigger_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MentionSpamTriggerMetadata',
        },
      ],
    },
  },
} as const;

export const MentionableSelectSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [7],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 150,
    },
    min_values: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 25,
    },
    max_values: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 25,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    default_values: {
      type: ['array', 'null'],
      items: {},
      maxItems: 25,
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageActivityResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const MessageAllowedMentionsRequestSchema = {
  type: 'object',
  properties: {
    parse: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/AllowedMentionTypes',
          },
        ],
      },
      maxItems: 1521,
      uniqueItems: true,
    },
    users: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/SnowflakeType',
          },
        ],
      },
      maxItems: 100,
      uniqueItems: true,
    },
    roles: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/SnowflakeType',
          },
        ],
      },
      maxItems: 100,
      uniqueItems: true,
    },
    replied_user: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const MessageAttachmentRequestSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    filename: {
      type: ['string', 'null'],
      maxLength: 1024,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1024,
    },
    is_remix: {
      type: ['boolean', 'null'],
    },
  },
  required: ['id'],
} as const;

export const MessageAttachmentResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    filename: {
      type: 'string',
    },
    size: {
      type: 'integer',
      format: 'int32',
    },
    url: {
      type: 'string',
      format: 'uri',
    },
    proxy_url: {
      type: 'string',
      format: 'uri',
    },
    width: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    height: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    duration_secs: {
      type: ['number', 'null'],
      format: 'double',
    },
    waveform: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    content_type: {
      type: ['string', 'null'],
    },
    ephemeral: {
      type: ['boolean', 'null'],
    },
    title: {
      type: ['string', 'null'],
    },
    application: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationResponse',
        },
      ],
    },
    clip_created_at: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    clip_participants: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
  },
  required: ['id', 'filename', 'size', 'url', 'proxy_url'],
} as const;

export const MessageComponentActionRowResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/MessageComponentButtonResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentChannelSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentInputTextResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentMentionableSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentRoleSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentStringSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentUserSelectResponse',
          },
        ],
      },
    },
  },
  required: ['type'],
} as const;

export const MessageComponentButtonResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: ['string', 'null'],
    },
    style: {
      $ref: '#/components/schemas/ButtonStyleTypes',
    },
    label: {
      type: ['string', 'null'],
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageComponentEmojiResponse',
        },
      ],
    },
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
  },
  required: ['type', 'style'],
} as const;

export const MessageComponentChannelSelectResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [8],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    placeholder: {
      type: ['string', 'null'],
    },
    min_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    channel_types: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelTypes',
      },
      uniqueItems: true,
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageComponentEmojiResponseSchema = {
  type: 'object',
  properties: {
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    name: {
      type: 'string',
    },
    animated: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name'],
} as const;

export const MessageComponentInputTextResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    style: {
      $ref: '#/components/schemas/TextStyleTypes',
    },
    label: {
      type: ['string', 'null'],
    },
    value: {
      type: ['string', 'null'],
    },
    placeholder: {
      type: ['string', 'null'],
    },
    required: {
      type: ['boolean', 'null'],
    },
    min_length: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_length: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['type', 'custom_id', 'style'],
} as const;

export const MessageComponentMentionableSelectResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [7],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    placeholder: {
      type: ['string', 'null'],
    },
    min_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    disabled: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageComponentRoleSelectResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [6],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    placeholder: {
      type: ['string', 'null'],
    },
    min_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    disabled: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageComponentStringSelectResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    placeholder: {
      type: ['string', 'null'],
    },
    min_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    options: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/SelectOptionResponse',
          },
        ],
      },
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageComponentTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ACTION_ROW',
      description: 'Container for other components',
      const: 1,
    },
    {
      title: 'BUTTON',
      description: 'Button object',
      const: 2,
    },
    {
      title: 'STRING_SELECT',
      description: 'Select menu for picking from defined text options',
      const: 3,
    },
    {
      title: 'INPUT_TEXT',
      description: 'Text input object',
      const: 4,
    },
    {
      title: 'USER_SELECT',
      description: 'Select menu for users',
      const: 5,
    },
    {
      title: 'ROLE_SELECT',
      description: 'Select menu for roles',
      const: 6,
    },
    {
      title: 'MENTIONABLE_SELECT',
      description: 'Select menu for mentionables (users and roles)',
      const: 7,
    },
    {
      title: 'CHANNEL_SELECT',
      description: 'Select menu for channels',
      const: 8,
    },
  ],
  format: 'int32',
} as const;

export const MessageComponentUserSelectResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
    },
    placeholder: {
      type: ['string', 'null'],
    },
    min_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    max_values: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    disabled: {
      type: ['boolean', 'null'],
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const MessageCreateRequestSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 4000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    sticker_ids: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 3,
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    flags: {
      type: ['integer', 'null'],
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
    message_reference: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ReplyMessageReferenceRequest',
        },
      ],
    },
    nonce: {
      oneOf: [
        {
          type: 'integer',
          minimum: -9223372036854776000,
          maximum: 9223372036854776000,
          format: 'int64',
        },
        {
          type: 'string',
          maxLength: 25,
          format: 'nonce',
        },
        {
          type: 'null',
        },
      ],
    },
    tts: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const MessageEditRequestPartialSchema = {
  type: 'object',
  properties: {
    content: {
      type: ['string', 'null'],
      maxLength: 4000,
    },
    embeds: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbed',
      },
      maxItems: 10,
    },
    flags: {
      type: ['integer', 'null'],
    },
    allowed_mentions: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageAllowedMentionsRequest',
        },
      ],
    },
    sticker_ids: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/SnowflakeType',
          },
        ],
      },
      maxItems: 1521,
    },
    components: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/Button',
          },
          {
            $ref: '#/components/schemas/ChannelSelect',
          },
          {
            $ref: '#/components/schemas/MentionableSelect',
          },
          {
            $ref: '#/components/schemas/RoleSelect',
          },
          {
            $ref: '#/components/schemas/StringSelect',
          },
          {
            $ref: '#/components/schemas/UserSelect',
          },
        ],
      },
      maxItems: 5,
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageAttachmentRequest',
      },
      maxItems: 10,
    },
  },
} as const;

export const MessageEmbedAuthorResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    url: {
      type: ['string', 'null'],
    },
    icon_url: {
      type: ['string', 'null'],
    },
    proxy_icon_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
  },
  required: ['name'],
} as const;

export const MessageEmbedFieldResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    value: {
      type: 'string',
    },
    inline: {
      type: 'boolean',
    },
  },
  required: ['name', 'value', 'inline'],
} as const;

export const MessageEmbedFooterResponseSchema = {
  type: 'object',
  properties: {
    text: {
      type: 'string',
    },
    icon_url: {
      type: ['string', 'null'],
    },
    proxy_icon_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
  },
  required: ['text'],
} as const;

export const MessageEmbedImageResponseSchema = {
  type: 'object',
  properties: {
    url: {
      type: ['string', 'null'],
    },
    proxy_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    width: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
    height: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
    placeholder: {
      type: ['string', 'null'],
    },
    placeholder_version: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
  },
} as const;

export const MessageEmbedProviderResponseSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
    url: {
      type: ['string', 'null'],
      format: 'uri',
    },
  },
  required: ['name'],
} as const;

export const MessageEmbedResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
    },
    url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    title: {
      type: ['string', 'null'],
    },
    description: {
      type: ['string', 'null'],
    },
    color: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    fields: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageEmbedFieldResponse',
      },
    },
    author: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedAuthorResponse',
        },
      ],
    },
    provider: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedProviderResponse',
        },
      ],
    },
    image: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedImageResponse',
        },
      ],
    },
    thumbnail: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedImageResponse',
        },
      ],
    },
    video: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedVideoResponse',
        },
      ],
    },
    footer: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageEmbedFooterResponse',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const MessageEmbedVideoResponseSchema = {
  type: 'object',
  properties: {
    url: {
      type: ['string', 'null'],
    },
    proxy_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    width: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
    height: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
    placeholder: {
      type: ['string', 'null'],
    },
    placeholder_version: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UInt32Type',
        },
      ],
    },
  },
} as const;

export const MessageInteractionResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/InteractionTypes',
    },
    name: {
      type: 'string',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    name_localized: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'type', 'name'],
} as const;

export const MessageMentionChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    type: {
      $ref: '#/components/schemas/ChannelTypes',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['id', 'name', 'type', 'guild_id'],
} as const;

export const MessageReactionCountDetailsResponseSchema = {
  type: 'object',
  properties: {
    burst: {
      type: 'integer',
      format: 'int32',
    },
    normal: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['burst', 'normal'],
} as const;

export const MessageReactionEmojiResponseSchema = {
  type: 'object',
  properties: {
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    animated: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const MessageReactionResponseSchema = {
  type: 'object',
  properties: {
    emoji: {
      $ref: '#/components/schemas/MessageReactionEmojiResponse',
    },
    count: {
      type: 'integer',
      format: 'int32',
    },
    count_details: {
      $ref: '#/components/schemas/MessageReactionCountDetailsResponse',
    },
    burst_colors: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    me_burst: {
      type: 'boolean',
    },
    me: {
      type: 'boolean',
    },
  },
  required: ['emoji', 'count', 'count_details', 'burst_colors', 'me_burst', 'me'],
} as const;

export const MessageReferenceResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['channel_id'],
} as const;

export const MessageResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      $ref: '#/components/schemas/MessageType',
    },
    content: {
      type: 'string',
    },
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    author: {
      $ref: '#/components/schemas/UserResponse',
    },
    attachments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MessageAttachmentResponse',
      },
    },
    embeds: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MessageEmbedResponse',
      },
    },
    mentions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
    mention_roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    pinned: {
      type: 'boolean',
    },
    mention_everyone: {
      type: 'boolean',
    },
    tts: {
      type: 'boolean',
    },
    timestamp: {
      type: 'string',
      format: 'date-time',
    },
    edited_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    components: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/MessageComponentActionRowResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentButtonResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentChannelSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentInputTextResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentMentionableSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentRoleSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentStringSelectResponse',
          },
          {
            $ref: '#/components/schemas/MessageComponentUserSelectResponse',
          },
        ],
      },
    },
    activity: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageActivityResponse',
        },
      ],
    },
    application: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/BasicApplicationResponse',
        },
      ],
    },
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    interaction: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageInteractionResponse',
        },
      ],
    },
    nonce: {
      oneOf: [
        {
          type: 'integer',
          minimum: -9223372036854776000,
          maximum: 9223372036854776000,
          format: 'int64',
        },
        {
          type: 'string',
          maxLength: 25,
          format: 'nonce',
        },
        {
          type: 'null',
        },
      ],
    },
    webhook_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    message_reference: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageReferenceResponse',
        },
      ],
    },
    thread: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadResponse',
        },
      ],
    },
    mention_channels: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            type: 'null',
          },
          {
            $ref: '#/components/schemas/MessageMentionChannelResponse',
          },
        ],
      },
    },
    stickers: {
      type: ['array', 'null'],
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/GuildStickerResponse',
          },
          {
            $ref: '#/components/schemas/StandardStickerResponse',
          },
        ],
      },
    },
    sticker_items: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageStickerItemResponse',
      },
    },
    role_subscription_data: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageRoleSubscriptionDataResponse',
        },
      ],
    },
    purchase_notification: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/PurchaseNotificationResponse',
        },
      ],
    },
    position: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    resolved: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ResolvedObjectsResponse',
        },
      ],
    },
    reactions: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/MessageReactionResponse',
      },
    },
    referenced_message: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/BasicMessageResponse',
        },
      ],
    },
  },
  required: [
    'id',
    'type',
    'content',
    'channel_id',
    'author',
    'attachments',
    'embeds',
    'mentions',
    'mention_roles',
    'pinned',
    'mention_everyone',
    'tts',
    'timestamp',
    'flags',
    'components',
  ],
} as const;

export const MessageRoleSubscriptionDataResponseSchema = {
  type: 'object',
  properties: {
    role_subscription_listing_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    tier_name: {
      type: 'string',
    },
    total_months_subscribed: {
      type: 'integer',
      format: 'int32',
    },
    is_renewal: {
      type: 'boolean',
    },
  },
  required: ['role_subscription_listing_id', 'tier_name', 'total_months_subscribed', 'is_renewal'],
} as const;

export const MessageStickerItemResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    format_type: {
      $ref: '#/components/schemas/StickerFormatTypes',
    },
  },
  required: ['id', 'name', 'format_type'],
} as const;

export const MessageTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'DEFAULT',
      description: '',
      const: 0,
    },
    {
      title: 'RECIPIENT_ADD',
      description: '',
      const: 1,
    },
    {
      title: 'RECIPIENT_REMOVE',
      description: '',
      const: 2,
    },
    {
      title: 'CALL',
      description: '',
      const: 3,
    },
    {
      title: 'CHANNEL_NAME_CHANGE',
      description: '',
      const: 4,
    },
    {
      title: 'CHANNEL_ICON_CHANGE',
      description: '',
      const: 5,
    },
    {
      title: 'CHANNEL_PINNED_MESSAGE',
      description: '',
      const: 6,
    },
    {
      title: 'USER_JOIN',
      description: '',
      const: 7,
    },
    {
      title: 'GUILD_BOOST',
      description: '',
      const: 8,
    },
    {
      title: 'GUILD_BOOST_TIER_1',
      description: '',
      const: 9,
    },
    {
      title: 'GUILD_BOOST_TIER_2',
      description: '',
      const: 10,
    },
    {
      title: 'GUILD_BOOST_TIER_3',
      description: '',
      const: 11,
    },
    {
      title: 'CHANNEL_FOLLOW_ADD',
      description: '',
      const: 12,
    },
    {
      title: 'GUILD_DISCOVERY_DISQUALIFIED',
      description: '',
      const: 14,
    },
    {
      title: 'GUILD_DISCOVERY_REQUALIFIED',
      description: '',
      const: 15,
    },
    {
      title: 'GUILD_DISCOVERY_GRACE_PERIOD_INITIAL_WARNING',
      description: '',
      const: 16,
    },
    {
      title: 'GUILD_DISCOVERY_GRACE_PERIOD_FINAL_WARNING',
      description: '',
      const: 17,
    },
    {
      title: 'THREAD_CREATED',
      description: '',
      const: 18,
    },
    {
      title: 'REPLY',
      description: '',
      const: 19,
    },
    {
      title: 'CHAT_INPUT_COMMAND',
      description: '',
      const: 20,
    },
    {
      title: 'THREAD_STARTER_MESSAGE',
      description: '',
      const: 21,
    },
    {
      title: 'GUILD_INVITE_REMINDER',
      description: '',
      const: 22,
    },
    {
      title: 'CONTEXT_MENU_COMMAND',
      description: '',
      const: 23,
    },
    {
      title: 'AUTO_MODERATION_ACTION',
      description: '',
      const: 24,
    },
    {
      title: 'ROLE_SUBSCRIPTION_PURCHASE',
      description: '',
      const: 25,
    },
    {
      title: 'INTERACTION_PREMIUM_UPSELL',
      description: '',
      const: 26,
    },
    {
      title: 'STAGE_START',
      description: '',
      const: 27,
    },
    {
      title: 'STAGE_END',
      description: '',
      const: 28,
    },
    {
      title: 'STAGE_SPEAKER',
      description: '',
      const: 29,
    },
    {
      title: 'STAGE_TOPIC',
      description: '',
      const: 31,
    },
    {
      title: 'GUILD_APPLICATION_PREMIUM_SUBSCRIPTION',
      description: '',
      const: 32,
    },
  ],
  format: 'int32',
} as const;

export const MetadataItemTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'INTEGER_LESS_THAN_EQUAL',
      description: "the metadata value (integer) is less than or equal to the guild's configured value (integer)",
      const: 1,
    },
    {
      title: 'INTEGER_GREATER_THAN_EQUAL',
      description: "the metadata value (integer) is greater than or equal to the guild's configured value (integer)",
      const: 2,
    },
    {
      title: 'INTEGER_EQUAL',
      description: "the metadata value (integer) is equal to the guild's configured value (integer)",
      const: 3,
    },
    {
      title: 'INTEGER_NOT_EQUAL',
      description: "the metadata value (integer) is not equal to the guild's configured value (integer)",
      const: 4,
    },
    {
      title: 'DATETIME_LESS_THAN_EQUAL',
      description:
        "the metadata value (ISO8601 string) is less than or equal to the guild's configured value (integer; days before current date)",
      const: 5,
    },
    {
      title: 'DATETIME_GREATER_THAN_EQUAL',
      description:
        "the metadata value (ISO8601 string) is greater than or equal to the guild's configured value (integer; days before current date)",
      const: 6,
    },
    {
      title: 'BOOLEAN_EQUAL',
      description: "the metadata value (integer) is equal to the guild's configured value (integer; 1)",
      const: 7,
    },
    {
      title: 'BOOLEAN_NOT_EQUAL',
      description: "the metadata value (integer) is not equal to the guild's configured value (integer; 1)",
      const: 8,
    },
  ],
  format: 'int32',
} as const;

export const ModalInteractionCallbackDataSchema = {
  type: 'object',
  properties: {
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    title: {
      type: 'string',
      maxLength: 45,
    },
    components: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ActionRow',
          },
          {
            $ref: '#/components/schemas/InputText',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
    },
  },
  required: ['custom_id', 'title', 'components'],
} as const;

export const ModalInteractionCallbackRequestSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [9],
      allOf: [
        {
          $ref: '#/components/schemas/InteractionCallbackTypes',
        },
      ],
      format: 'int32',
    },
    data: {
      $ref: '#/components/schemas/ModalInteractionCallbackData',
    },
  },
  required: ['type', 'data'],
} as const;

export const MyGuildResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    owner: {
      type: 'boolean',
    },
    permissions: {
      type: 'string',
    },
    features: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/GuildFeatures',
      },
      uniqueItems: true,
    },
    approximate_member_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    approximate_presence_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
  },
  required: ['id', 'name', 'owner', 'permissions', 'features'],
} as const;

export const NewMemberActionResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    action_type: {
      $ref: '#/components/schemas/NewMemberActionType',
    },
    title: {
      type: 'string',
    },
    description: {
      type: 'string',
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SettingsEmojiResponse',
        },
      ],
    },
    icon: {
      type: ['string', 'null'],
    },
  },
  required: ['channel_id', 'action_type', 'title', 'description'],
} as const;

export const NewMemberActionTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'VIEW',
      const: 0,
    },
    {
      title: 'TALK',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const OAuth2GetAuthorizationResponseSchema = {
  type: 'object',
  properties: {
    application: {
      $ref: '#/components/schemas/ApplicationResponse',
    },
    expires: {
      type: 'string',
      format: 'date-time',
    },
    scopes: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OAuth2Scopes',
      },
      uniqueItems: true,
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
  },
  required: ['application', 'expires', 'scopes'],
} as const;

export const OAuth2ScopesSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'IDENTIFY',
      description: 'allows /users/@me without email',
      const: 'identify',
    },
    {
      title: 'EMAIL',
      description: 'enables /users/@me to return an email',
      const: 'email',
    },
    {
      title: 'CONNECTIONS',
      description: 'allows /users/@me/connections to return linked third-party accounts',
      const: 'connections',
    },
    {
      title: 'GUILDS',
      description: "allows /users/@me/guilds to return basic information about all of a user's guilds",
      const: 'guilds',
    },
    {
      title: 'GUILDS_JOIN',
      description: 'allows /guilds/{guild.id}/members/{user.id} to be used for joining users to a guild',
      const: 'guilds.join',
    },
    {
      title: 'GUILDS_MEMBERS_READ',
      description: "allows /users/@me/guilds/{guild.id}/member to return a user's member information in a guild",
      const: 'guilds.members.read',
    },
    {
      title: 'GDM_JOIN',
      description: 'allows your app to join users to a group dm',
      const: 'gdm.join',
    },
    {
      title: 'BOT',
      description: "for oauth2 bots, this puts the bot in the user's selected guild by default",
      const: 'bot',
    },
    {
      title: 'RPC',
      description:
        "for local rpc server access, this allows you to control a user's local Discord client - requires Discord approval",
      const: 'rpc',
    },
    {
      title: 'RPC_NOTIFICATIONS_READ',
      description:
        'for local rpc server access, this allows you to receive notifications pushed out to the user - requires Discord approval',
      const: 'rpc.notifications.read',
    },
    {
      title: 'RPC_VOICE_READ',
      description:
        "for local rpc server access, this allows you to read a user's voice settings and listen for voice events - requires Discord approval",
      const: 'rpc.voice.read',
    },
    {
      title: 'RPC_VOICE_WRITE',
      description:
        "for local rpc server access, this allows you to update a user's voice settings - requires Discord approval",
      const: 'rpc.voice.write',
    },
    {
      title: 'RPC_VIDEO_READ',
      description:
        "for local rpc server access, this allows you to read a user's video status - requires Discord approval",
      const: 'rpc.video.read',
    },
    {
      title: 'RPC_VIDEO_WRITE',
      description:
        "for local rpc server access, this allows you to update a user's video settings - requires Discord approval",
      const: 'rpc.video.write',
    },
    {
      title: 'RPC_SCREENSHARE_READ',
      description:
        "for local rpc server access, this allows you to read a user's screenshare status- requires Discord approval",
      const: 'rpc.screenshare.read',
    },
    {
      title: 'RPC_SCREENSHARE_WRITE',
      description:
        "for local rpc server access, this allows you to update a user's screenshare settings- requires Discord approval",
      const: 'rpc.screenshare.write',
    },
    {
      title: 'RPC_ACTIVITIES_WRITE',
      description:
        "for local rpc server access, this allows you to update a user's activity - requires Discord approval",
      const: 'rpc.activities.write',
    },
    {
      title: 'WEBHOOK_INCOMING',
      description:
        'this generates a webhook that is returned in the oauth token response for authorization code grants',
      const: 'webhook.incoming',
    },
    {
      title: 'MESSAGES_READ',
      description:
        'for local rpc server api access, this allows you to read messages from all client channels (otherwise restricted to channels/guilds your app creates)',
      const: 'messages.read',
    },
    {
      title: 'APPLICATIONS_BUILDS_UPLOAD',
      description: "allows your app to upload/update builds for a user's applications - requires Discord approval",
      const: 'applications.builds.upload',
    },
    {
      title: 'APPLICATIONS_BUILDS_READ',
      description: "allows your app to read build data for a user's applications",
      const: 'applications.builds.read',
    },
    {
      title: 'APPLICATIONS_COMMANDS',
      description: 'allows your app to use commands in a guild',
      const: 'applications.commands',
    },
    {
      title: 'APPLICATIONS_COMMANDS_PERMISSIONS_UPDATE',
      description: 'allows your app to update permissions for its commands in a guild a user has permissions to',
      const: 'applications.commands.permissions.update',
    },
    {
      title: 'APPLICATIONS_COMMANDS_UPDATE',
      description: 'allows your app to update its commands using a Bearer token - client credentials grant only',
      const: 'applications.commands.update',
    },
    {
      title: 'APPLICATIONS_STORE_UPDATE',
      description:
        "allows your app to read and update store data (SKUs, store listings, achievements, etc.) for a user's applications",
      const: 'applications.store.update',
    },
    {
      title: 'APPLICATIONS_ENTITLEMENTS',
      description: "allows your app to read entitlements for a user's applications",
      const: 'applications.entitlements',
    },
    {
      title: 'ACTIVITIES_READ',
      description: `allows your app to fetch data from a user's "Now Playing/Recently Played" list - requires Discord approval`,
      const: 'activities.read',
    },
    {
      title: 'ACTIVITIES_WRITE',
      description:
        "allows your app to update a user's activity - requires Discord approval (NOT REQUIRED FOR GAMESDK ACTIVITY MANAGER)",
      const: 'activities.write',
    },
    {
      title: 'RELATIONSHIPS_READ',
      description: "allows your app to know a user's friends and implicit relationships - requires Discord approval",
      const: 'relationships.read',
    },
    {
      title: 'VOICE',
      description:
        "allows your app to connect to voice on user's behalf and see all the voice members - requires Discord approval",
      const: 'voice',
    },
    {
      title: 'DM_CHANNELS_READ',
      description: "allows your app to see information about the user's DMs and group DMs - requires Discord approval",
      const: 'dm_channels.read',
    },
    {
      title: 'ROLE_CONNECTIONS_WRITE',
      description: "allows your app to update a user's connection and metadata for the app",
      const: 'role_connections.write',
    },
  ],
} as const;

export const OnboardingPromptOptionRequestSchema = {
  type: 'object',
  properties: {
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    title: {
      type: 'string',
      minLength: 1,
      maxLength: 50,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    emoji_animated: {
      type: ['boolean', 'null'],
    },
    role_ids: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
    channel_ids: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 50,
      uniqueItems: true,
    },
  },
  required: ['title'],
} as const;

export const OnboardingPromptOptionResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    title: {
      type: 'string',
    },
    description: {
      type: 'string',
    },
    emoji: {
      $ref: '#/components/schemas/SettingsEmojiResponse',
    },
    role_ids: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    channel_ids: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
  },
  required: ['id', 'title', 'description', 'emoji', 'role_ids', 'channel_ids'],
} as const;

export const OnboardingPromptResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    title: {
      type: 'string',
    },
    options: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OnboardingPromptOptionResponse',
      },
    },
    single_select: {
      type: 'boolean',
    },
    required: {
      type: 'boolean',
    },
    in_onboarding: {
      type: 'boolean',
    },
    type: {
      $ref: '#/components/schemas/OnboardingPromptType',
    },
  },
  required: ['id', 'title', 'options', 'single_select', 'required', 'in_onboarding', 'type'],
} as const;

export const OnboardingPromptTypeSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'MULTIPLE_CHOICE',
      description: 'Multiple choice options',
      const: 0,
    },
    {
      title: 'DROPDOWN',
      description: 'Many options shown as a dropdown',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const PartialDiscordIntegrationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'string',
      enum: ['discord'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
    application_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['id', 'type', 'application_id'],
} as const;

export const PartialExternalConnectionIntegrationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'string',
      enum: ['twitch', 'youtube'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
  },
  required: ['id', 'type'],
} as const;

export const PartialGuildSubscriptionIntegrationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'string',
      enum: ['guild_subscription'],
      allOf: [
        {
          $ref: '#/components/schemas/IntegrationTypes',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    account: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/AccountResponse',
        },
      ],
    },
  },
  required: ['id', 'type'],
} as const;

export const PongInteractionCallbackRequestSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/InteractionCallbackTypes',
        },
      ],
      format: 'int32',
    },
  },
  required: ['type'],
} as const;

export const PremiumGuildTiersSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      description: 'Guild has not unlocked any Server Boost perks',
      const: 0,
    },
    {
      title: 'TIER_1',
      description: 'Guild has unlocked Server Boost level 1 perks',
      const: 1,
    },
    {
      title: 'TIER_2',
      description: 'Guild has unlocked Server Boost level 2 perks',
      const: 2,
    },
    {
      title: 'TIER_3',
      description: 'Guild has unlocked Server Boost level 3 perks',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const PremiumTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      description: 'None',
      const: 0,
    },
    {
      title: 'TIER_1',
      description: 'Nitro Classic',
      const: 1,
    },
    {
      title: 'TIER_2',
      description: 'Nitro Standard',
      const: 2,
    },
    {
      title: 'TIER_0',
      description: 'Nitro Basic',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const PrivateApplicationResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationTypes',
        },
      ],
    },
    cover_image: {
      type: ['string', 'null'],
    },
    primary_sku_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    bot: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    slug: {
      type: ['string', 'null'],
    },
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rpc_origins: {
      type: ['array', 'null'],
      items: {
        type: ['string', 'null'],
      },
    },
    bot_public: {
      type: ['boolean', 'null'],
    },
    bot_require_code_grant: {
      type: ['boolean', 'null'],
    },
    terms_of_service_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    privacy_policy_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    custom_install_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    install_params: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ApplicationOAuth2ParamsResponse',
        },
      ],
    },
    verify_key: {
      type: 'string',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    max_participants: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    tags: {
      type: ['array', 'null'],
      items: {
        type: 'string',
      },
      uniqueItems: true,
    },
    redirect_uris: {
      type: 'array',
      items: {
        type: ['string', 'null'],
        format: 'uri',
      },
    },
    interactions_endpoint_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    role_connections_verification_url: {
      type: ['string', 'null'],
      format: 'uri',
    },
    owner: {
      $ref: '#/components/schemas/UserResponse',
    },
    approximate_guild_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    team: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/TeamResponse',
        },
      ],
    },
  },
  required: ['id', 'name', 'description', 'verify_key', 'flags', 'redirect_uris', 'owner'],
} as const;

export const PrivateChannelRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 100,
    },
    icon: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
  },
} as const;

export const PrivateChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    last_message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    last_pin_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    recipients: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
  },
  required: ['id', 'type', 'flags', 'recipients'],
} as const;

export const PrivateGroupChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    last_message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    last_pin_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    recipients: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
    name: {
      type: ['string', 'null'],
    },
    icon: {
      type: ['string', 'null'],
    },
    owner_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    managed: {
      type: ['boolean', 'null'],
    },
    application_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['id', 'type', 'flags', 'recipients'],
} as const;

export const PrivateGuildMemberResponseSchema = {
  type: 'object',
  properties: {
    avatar: {
      type: ['string', 'null'],
    },
    communication_disabled_until: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    joined_at: {
      type: 'string',
      format: 'date-time',
    },
    nick: {
      type: ['string', 'null'],
    },
    pending: {
      type: 'boolean',
    },
    premium_since: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    roles: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    user: {
      $ref: '#/components/schemas/UserResponse',
    },
    mute: {
      type: 'boolean',
    },
    deaf: {
      type: 'boolean',
    },
    banner: {
      type: ['string', 'null'],
    },
  },
  required: ['flags', 'joined_at', 'pending', 'roles', 'user', 'mute', 'deaf'],
} as const;

export const PurchaseNotificationResponseSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/PurchaseType',
    },
    guild_product_purchase: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildProductPurchaseResponse',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const PurchaseTypeSchema = {
  type: 'integer',
  oneOf: [],
  format: 'int32',
} as const;

export const QuarantineUserActionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/QuarantineUserActionMetadata',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const QuarantineUserActionMetadataSchema = {
  type: 'object',
  properties: {},
} as const;

export const QuarantineUserActionMetadataResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const QuarantineUserActionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [4],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/QuarantineUserActionMetadataResponse',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const ReplyMessageReferenceRequestSchema = {
  type: 'object',
  properties: {
    guild_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    message_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    fail_if_not_exists: {
      type: ['boolean', 'null'],
    },
  },
  required: ['message_id'],
} as const;

export const ResolvedObjectsResponseSchema = {
  type: 'object',
  properties: {
    users: {
      type: 'object',
      additionalProperties: {
        $ref: '#/components/schemas/UserResponse',
      },
    },
    members: {
      type: 'object',
      additionalProperties: {
        $ref: '#/components/schemas/GuildMemberResponse',
      },
    },
    channels: {
      type: 'object',
      additionalProperties: {
        oneOf: [
          {
            $ref: '#/components/schemas/GuildChannelResponse',
          },
          {
            $ref: '#/components/schemas/PrivateChannelResponse',
          },
          {
            $ref: '#/components/schemas/PrivateGroupChannelResponse',
          },
          {
            $ref: '#/components/schemas/ThreadResponse',
          },
        ],
      },
    },
    roles: {
      type: 'object',
      additionalProperties: {
        $ref: '#/components/schemas/GuildRoleResponse',
      },
    },
  },
  required: ['users', 'members', 'channels', 'roles'],
} as const;

export const ResourceChannelResponseSchema = {
  type: 'object',
  properties: {
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    title: {
      type: 'string',
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SettingsEmojiResponse',
        },
      ],
    },
    icon: {
      type: ['string', 'null'],
    },
    description: {
      type: 'string',
    },
  },
  required: ['channel_id', 'title', 'description'],
} as const;

export const RichEmbedSchema = {
  type: 'object',
  properties: {
    type: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    title: {
      type: ['string', 'null'],
      maxLength: 256,
    },
    color: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 16777215,
    },
    timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    description: {
      type: ['string', 'null'],
      maxLength: 4096,
    },
    author: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedAuthor',
        },
      ],
    },
    image: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedImage',
        },
      ],
    },
    thumbnail: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedThumbnail',
        },
      ],
    },
    footer: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedFooter',
        },
      ],
    },
    fields: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RichEmbedField',
      },
      maxItems: 25,
    },
    provider: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedProvider',
        },
      ],
    },
    video: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/RichEmbedVideo',
        },
      ],
    },
  },
} as const;

export const RichEmbedAuthorSchema = {
  type: 'object',
  properties: {
    name: {
      type: ['string', 'null'],
      maxLength: 256,
    },
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    icon_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
  },
} as const;

export const RichEmbedFieldSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 256,
    },
    value: {
      type: 'string',
      maxLength: 1024,
    },
    inline: {
      type: ['boolean', 'null'],
    },
  },
  required: ['name', 'value'],
} as const;

export const RichEmbedFooterSchema = {
  type: 'object',
  properties: {
    text: {
      type: ['string', 'null'],
      maxLength: 2048,
    },
    icon_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
  },
} as const;

export const RichEmbedImageSchema = {
  type: 'object',
  properties: {
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    width: {
      type: ['integer', 'null'],
    },
    height: {
      type: ['integer', 'null'],
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 64,
    },
    placeholder_version: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 2147483647,
    },
  },
} as const;

export const RichEmbedProviderSchema = {
  type: 'object',
  properties: {
    name: {
      type: ['string', 'null'],
      maxLength: 256,
    },
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
  },
} as const;

export const RichEmbedThumbnailSchema = {
  type: 'object',
  properties: {
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    width: {
      type: ['integer', 'null'],
    },
    height: {
      type: ['integer', 'null'],
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 64,
    },
    placeholder_version: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 2147483647,
    },
  },
} as const;

export const RichEmbedVideoSchema = {
  type: 'object',
  properties: {
    url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    width: {
      type: ['integer', 'null'],
    },
    height: {
      type: ['integer', 'null'],
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 64,
    },
    placeholder_version: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 2147483647,
    },
  },
} as const;

export const RoleSelectSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [6],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 150,
    },
    min_values: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 25,
    },
    max_values: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 25,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    default_values: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/RoleSelectDefaultValue',
      },
      maxItems: 25,
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const RoleSelectDefaultValueSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/SnowflakeSelectDefaultValueTypes',
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['type', 'id'],
} as const;

export const ScheduledEventResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    image: {
      type: ['string', 'null'],
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    status: {
      $ref: '#/components/schemas/GuildScheduledEventStatuses',
    },
    entity_type: {
      $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
    },
    entity_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    user_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    user_rsvp: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ScheduledEventUserResponse',
        },
      ],
    },
  },
  required: ['id', 'guild_id', 'name', 'scheduled_start_time', 'status', 'entity_type', 'privacy_level'],
} as const;

export const ScheduledEventUserResponseSchema = {
  type: 'object',
  properties: {
    guild_scheduled_event_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    user_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    user: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    member: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildMemberResponse',
        },
      ],
    },
  },
  required: ['guild_scheduled_event_id', 'user_id'],
} as const;

export const SelectOptionSchema = {
  type: 'object',
  properties: {
    label: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    value: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/Emoji',
        },
      ],
    },
    default: {
      type: ['boolean', 'null'],
    },
  },
  required: ['label', 'value'],
} as const;

export const SelectOptionResponseSchema = {
  type: 'object',
  properties: {
    label: {
      type: 'string',
    },
    value: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/MessageComponentEmojiResponse',
        },
      ],
    },
    default: {
      type: ['boolean', 'null'],
    },
  },
  required: ['label', 'value'],
} as const;

export const SettingsEmojiResponseSchema = {
  type: 'object',
  properties: {
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    name: {
      type: ['string', 'null'],
    },
    animated: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const SlackWebhookSchema = {
  type: 'object',
  properties: {
    text: {
      type: ['string', 'null'],
      maxLength: 2000,
    },
    username: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    icon_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    attachments: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/WebhookSlackEmbed',
      },
      maxItems: 1521,
    },
  },
} as const;

export const SnowflakeSelectDefaultValueTypesSchema = {
  type: 'string',
  oneOf: [],
} as const;

export const SnowflakeTypeSchema = {
  type: 'string',
  pattern: '^(0|[1-9][0-9]*)$',
  format: 'snowflake',
} as const;

export const SpamLinkRuleResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    creator_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    event_type: {
      $ref: '#/components/schemas/AutomodEventType',
    },
    actions: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/BlockMessageActionResponse',
          },
          {
            $ref: '#/components/schemas/FlagToChannelActionResponse',
          },
          {
            $ref: '#/components/schemas/QuarantineUserActionResponse',
          },
          {
            $ref: '#/components/schemas/UserCommunicationDisabledActionResponse',
          },
        ],
      },
    },
    trigger_type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodTriggerType',
        },
      ],
      format: 'int32',
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    exempt_roles: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    exempt_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    trigger_metadata: {
      $ref: '#/components/schemas/SpamLinkTriggerMetadataResponse',
    },
  },
  required: ['id', 'guild_id', 'creator_id', 'name', 'event_type', 'actions', 'trigger_type', 'trigger_metadata'],
} as const;

export const SpamLinkTriggerMetadataResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const StageInstanceResponseSchema = {
  type: 'object',
  properties: {
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    channel_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    topic: {
      type: 'string',
    },
    privacy_level: {
      $ref: '#/components/schemas/StageInstancesPrivacyLevels',
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    discoverable_disabled: {
      type: ['boolean', 'null'],
    },
    guild_scheduled_event_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['guild_id', 'channel_id', 'topic', 'privacy_level', 'id'],
} as const;

export const StageInstancesPrivacyLevelsSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PUBLIC',
      description: 'The Stage instance is visible publicly. (deprecated)',
      const: 1,
    },
    {
      title: 'GUILD_ONLY',
      description: 'The Stage instance is visible publicly. (deprecated)',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const StageScheduledEventCreateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    entity_type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataStageInstance',
        },
      ],
    },
  },
  required: ['name', 'scheduled_start_time', 'privacy_level', 'entity_type'],
} as const;

export const StageScheduledEventPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    status: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildScheduledEventStatuses',
        },
      ],
    },
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    entity_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [1],
          allOf: [
            {
              $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataStageInstance',
        },
      ],
    },
  },
} as const;

export const StageScheduledEventResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    image: {
      type: ['string', 'null'],
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    status: {
      $ref: '#/components/schemas/GuildScheduledEventStatuses',
    },
    entity_type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    entity_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    user_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    user_rsvp: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ScheduledEventUserResponse',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataStageInstanceResponse',
        },
      ],
    },
  },
  required: ['id', 'guild_id', 'name', 'scheduled_start_time', 'status', 'entity_type', 'privacy_level'],
} as const;

export const StandardStickerResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    tags: {
      type: 'string',
    },
    type: {
      type: 'integer',
      enum: [1],
      allOf: [
        {
          $ref: '#/components/schemas/StickerTypes',
        },
      ],
      format: 'int32',
    },
    format_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/StickerFormatTypes',
        },
      ],
    },
    description: {
      type: ['string', 'null'],
    },
    pack_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    sort_value: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['id', 'name', 'tags', 'type', 'pack_id', 'sort_value'],
} as const;

export const StickerFormatTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'PNG',
      const: 1,
    },
    {
      title: 'APNG',
      const: 2,
    },
    {
      title: 'LOTTIE',
      const: 3,
    },
    {
      title: 'GIF',
      const: 4,
    },
  ],
  format: 'int32',
} as const;

export const StickerPackCollectionResponseSchema = {
  type: 'object',
  properties: {
    sticker_packs: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/StickerPackResponse',
      },
    },
  },
  required: ['sticker_packs'],
} as const;

export const StickerPackResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    sku_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    stickers: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/StandardStickerResponse',
      },
    },
    cover_sticker_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    banner_asset_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['id', 'sku_id', 'name', 'stickers'],
} as const;

export const StickerTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'STANDARD',
      description: 'an official sticker in a pack, part of Nitro or in a removed purchasable pack',
      const: 1,
    },
    {
      title: 'GUILD',
      description: "a sticker uploaded to a guild for the guild's members",
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const StringSelectSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 150,
    },
    min_values: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 25,
    },
    max_values: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 25,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    options: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SelectOption',
      },
      minItems: 1,
      maxItems: 25,
    },
  },
  required: ['type', 'custom_id', 'options'],
} as const;

export const TeamMemberResponseSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/UserResponse',
    },
    team_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    membership_state: {
      $ref: '#/components/schemas/TeamMembershipStates',
    },
  },
  required: ['user', 'team_id', 'membership_state'],
} as const;

export const TeamMembershipStatesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'INVITED',
      description: 'User has been invited to the team.',
      const: 1,
    },
    {
      title: 'ACCEPTED',
      description: 'User has accepted the team invitation.',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const TeamResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    icon: {
      type: ['string', 'null'],
    },
    name: {
      type: 'string',
    },
    owner_user_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    members: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TeamMemberResponse',
      },
    },
  },
  required: ['id', 'name', 'owner_user_id', 'members'],
} as const;

export const TextStyleTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'SHORT',
      description: 'Single-line input',
      const: 1,
    },
    {
      title: 'PARAGRAPH',
      description: 'Multi-line input',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const ThreadAutoArchiveDurationSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ONE_HOUR',
      description: 'One hour',
      const: 60,
    },
    {
      title: 'ONE_DAY',
      description: 'One day',
      const: 1440,
    },
    {
      title: 'THREE_DAY',
      description: 'Three days',
      const: 4320,
    },
    {
      title: 'SEVEN_DAY',
      description: 'Seven days',
      const: 10080,
    },
  ],
  format: 'int32',
} as const;

export const ThreadMemberResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    user_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    join_timestamp: {
      type: 'string',
      format: 'date-time',
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    member: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildMemberResponse',
        },
      ],
    },
  },
  required: ['id', 'user_id', 'join_timestamp', 'flags'],
} as const;

export const ThreadMetadataResponseSchema = {
  type: 'object',
  properties: {
    archived: {
      type: 'boolean',
    },
    archive_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    auto_archive_duration: {
      $ref: '#/components/schemas/ThreadAutoArchiveDuration',
    },
    locked: {
      type: 'boolean',
    },
    create_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    invitable: {
      type: ['boolean', 'null'],
    },
  },
  required: ['archived', 'auto_archive_duration', 'locked'],
} as const;

export const ThreadResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    type: {
      type: 'integer',
      enum: [10, 11, 12],
      allOf: [
        {
          $ref: '#/components/schemas/ChannelTypes',
        },
      ],
      format: 'int32',
    },
    last_message_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    flags: {
      type: 'integer',
      format: 'int32',
    },
    last_pin_timestamp: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    bitrate: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    permissions: {
      type: ['string', 'null'],
    },
    owner_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    thread_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadMetadataResponse',
        },
      ],
    },
    message_count: {
      type: 'integer',
      format: 'int32',
    },
    member_count: {
      type: 'integer',
      format: 'int32',
    },
    total_message_sent: {
      type: 'integer',
      format: 'int32',
    },
    applied_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
    },
    member: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadMemberResponse',
        },
      ],
    },
  },
  required: [
    'id',
    'type',
    'flags',
    'guild_id',
    'name',
    'owner_id',
    'message_count',
    'member_count',
    'total_message_sent',
  ],
} as const;

export const ThreadSortOrderSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'LATEST_ACTIVITY',
      description: 'Sort forum posts by activity',
      const: 0,
    },
    {
      title: 'CREATION_DATE',
      description: 'Sort forum posts by creation time (from most recent to oldest)',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const ThreadsResponseSchema = {
  type: 'object',
  properties: {
    threads: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ThreadResponse',
      },
    },
    members: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ThreadMemberResponse',
      },
    },
    has_more: {
      type: ['boolean', 'null'],
    },
  },
  required: ['threads', 'members'],
} as const;

export const TypingIndicatorResponseSchema = {
  type: 'object',
  properties: {},
} as const;

export const UInt32TypeSchema = {
  type: 'integer',
  minimum: 0,
  maximum: 4294967295,
  format: 'int64',
} as const;

export const UpdateDefaultReactionEmojiRequestSchema = {
  type: 'object',
  properties: {
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
      maxLength: 100,
    },
  },
} as const;

export const UpdateGuildChannelRequestPartialSchema = {
  type: 'object',
  properties: {
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [0, 2, 4, 5, 13, 14, 15],
          allOf: [
            {
              $ref: '#/components/schemas/ChannelTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    name: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    position: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    topic: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 4096,
    },
    bitrate: {
      type: ['integer', 'null'],
      minimum: 8000,
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      minimum: 0,
      format: 'int32',
    },
    nsfw: {
      type: ['boolean', 'null'],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    parent_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    permission_overwrites: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/ChannelPermissionOverwriteRequest',
      },
      maxItems: 100,
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
    default_auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    default_reaction_emoji: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UpdateDefaultReactionEmojiRequest',
        },
      ],
    },
    default_thread_rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    default_sort_order: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadSortOrder',
        },
      ],
    },
    default_forum_layout: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ForumLayout',
        },
      ],
    },
    flags: {
      type: ['integer', 'null'],
    },
    available_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/UpdateThreadTagRequest',
      },
      maxItems: 20,
    },
  },
} as const;

export const UpdateGuildOnboardingRequestSchema = {
  type: 'object',
  properties: {
    prompts: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/UpdateOnboardingPromptRequest',
      },
      maxItems: 15,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
    default_channel_ids: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 500,
      uniqueItems: true,
    },
    mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildOnboardingMode',
        },
      ],
    },
  },
} as const;

export const UpdateMessageInteractionCallbackRequestSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [6, 7],
      allOf: [
        {
          $ref: '#/components/schemas/InteractionCallbackTypes',
        },
      ],
      format: 'int32',
    },
    data: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/IncomingWebhookUpdateForInteractionCallbackRequestPartial',
        },
      ],
    },
  },
  required: ['type'],
} as const;

export const UpdateOnboardingPromptRequestSchema = {
  type: 'object',
  properties: {
    title: {
      type: 'string',
      minLength: 1,
      maxLength: 100,
    },
    options: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OnboardingPromptOptionRequest',
      },
      minItems: 1,
      maxItems: 50,
    },
    single_select: {
      type: ['boolean', 'null'],
    },
    required: {
      type: ['boolean', 'null'],
    },
    in_onboarding: {
      type: ['boolean', 'null'],
    },
    type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/OnboardingPromptType',
        },
      ],
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['title', 'options', 'id'],
} as const;

export const UpdateThreadRequestPartialSchema = {
  type: 'object',
  properties: {
    name: {
      type: ['string', 'null'],
      minLength: 0,
      maxLength: 100,
    },
    archived: {
      type: ['boolean', 'null'],
    },
    locked: {
      type: ['boolean', 'null'],
    },
    invitable: {
      type: ['boolean', 'null'],
    },
    auto_archive_duration: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ThreadAutoArchiveDuration',
        },
      ],
    },
    rate_limit_per_user: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 21600,
    },
    flags: {
      type: ['integer', 'null'],
    },
    applied_tags: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      maxItems: 5,
    },
    bitrate: {
      type: ['integer', 'null'],
      minimum: 8000,
      format: 'int32',
    },
    user_limit: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 99,
    },
    rtc_region: {
      type: ['string', 'null'],
    },
    video_quality_mode: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VideoQualityModes',
        },
      ],
    },
  },
} as const;

export const UpdateThreadTagRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      minLength: 0,
      maxLength: 20,
    },
    emoji_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    emoji_name: {
      type: ['string', 'null'],
      maxLength: 100,
    },
    moderated: {
      type: ['boolean', 'null'],
    },
    id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['name'],
} as const;

export const UserCommunicationDisabledActionSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/UserCommunicationDisabledActionMetadata',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const UserCommunicationDisabledActionMetadataSchema = {
  type: 'object',
  properties: {
    duration_seconds: {
      type: 'integer',
      minimum: 0,
      maximum: 2419200,
    },
  },
  required: ['duration_seconds'],
} as const;

export const UserCommunicationDisabledActionMetadataResponseSchema = {
  type: 'object',
  properties: {
    duration_seconds: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['duration_seconds'],
} as const;

export const UserCommunicationDisabledActionResponseSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [3],
      allOf: [
        {
          $ref: '#/components/schemas/AutomodActionType',
        },
      ],
      format: 'int32',
    },
    metadata: {
      $ref: '#/components/schemas/UserCommunicationDisabledActionMetadataResponse',
    },
  },
  required: ['type', 'metadata'],
} as const;

export const UserGuildOnboardingResponseSchema = {
  type: 'object',
  properties: {
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    prompts: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OnboardingPromptResponse',
      },
    },
    default_channel_ids: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
      uniqueItems: true,
    },
    enabled: {
      type: 'boolean',
    },
  },
  required: ['guild_id', 'prompts', 'default_channel_ids', 'enabled'],
} as const;

export const UserNotificationSettingsSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'ALL_MESSAGES',
      description: 'members will receive notifications for all messages by default',
      const: 0,
    },
    {
      title: 'ONLY_MENTIONS',
      description: 'members will receive notifications only for messages that @mention them by default',
      const: 1,
    },
  ],
  format: 'int32',
} as const;

export const UserPIIResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    username: {
      type: 'string',
    },
    avatar: {
      type: ['string', 'null'],
    },
    discriminator: {
      type: 'string',
    },
    public_flags: {
      type: 'integer',
      format: 'int32',
    },
    premium_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/PremiumTypes',
        },
      ],
    },
    flags: {
      $ref: '#/components/schemas/Int53Type',
    },
    bot: {
      type: ['boolean', 'null'],
    },
    system: {
      type: ['boolean', 'null'],
    },
    banner: {
      type: ['string', 'null'],
    },
    accent_color: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    global_name: {
      type: ['string', 'null'],
    },
    mfa_enabled: {
      type: 'boolean',
    },
    locale: {
      $ref: '#/components/schemas/AvailableLocalesEnum',
    },
    email: {
      type: ['string', 'null'],
    },
    verified: {
      type: ['boolean', 'null'],
    },
  },
  required: ['id', 'username', 'discriminator', 'public_flags', 'flags', 'mfa_enabled', 'locale'],
} as const;

export const UserResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    username: {
      type: 'string',
    },
    avatar: {
      type: ['string', 'null'],
    },
    discriminator: {
      type: 'string',
    },
    public_flags: {
      type: 'integer',
      format: 'int32',
    },
    premium_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/PremiumTypes',
        },
      ],
    },
    flags: {
      $ref: '#/components/schemas/Int53Type',
    },
    bot: {
      type: ['boolean', 'null'],
    },
    system: {
      type: ['boolean', 'null'],
    },
    banner: {
      type: ['string', 'null'],
    },
    accent_color: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    global_name: {
      type: ['string', 'null'],
    },
  },
  required: ['id', 'username', 'discriminator', 'public_flags', 'flags'],
} as const;

export const UserSelectSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'integer',
      enum: [5],
      allOf: [
        {
          $ref: '#/components/schemas/MessageComponentTypes',
        },
      ],
      format: 'int32',
    },
    custom_id: {
      type: 'string',
      maxLength: 100,
    },
    placeholder: {
      type: ['string', 'null'],
      maxLength: 150,
    },
    min_values: {
      type: ['integer', 'null'],
      minimum: 0,
      maximum: 25,
    },
    max_values: {
      type: ['integer', 'null'],
      minimum: 1,
      maximum: 25,
    },
    disabled: {
      type: ['boolean', 'null'],
    },
    default_values: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/UserSelectDefaultValue',
      },
      maxItems: 25,
    },
  },
  required: ['type', 'custom_id'],
} as const;

export const UserSelectDefaultValueSchema = {
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/SnowflakeSelectDefaultValueTypes',
    },
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
  },
  required: ['type', 'id'],
} as const;

export const VanityURLErrorResponseSchema = {
  type: 'object',
  properties: {
    message: {
      type: 'string',
    },
    code: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['message', 'code'],
} as const;

export const VanityURLResponseSchema = {
  type: 'object',
  properties: {
    code: {
      type: ['string', 'null'],
    },
    uses: {
      type: 'integer',
      format: 'int32',
    },
    error: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/VanityURLErrorResponse',
        },
      ],
    },
  },
  required: ['uses'],
} as const;

export const VerificationLevelsSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'NONE',
      description: 'unrestricted',
      const: 0,
    },
    {
      title: 'LOW',
      description: 'must have verified email on account',
      const: 1,
    },
    {
      title: 'MEDIUM',
      description: 'must be registered on Discord for longer than 5 minutes',
      const: 2,
    },
    {
      title: 'HIGH',
      description: 'must be a member of the server for longer than 10 minutes',
      const: 3,
    },
    {
      title: 'VERY_HIGH',
      description: 'must have a verified phone number',
      const: 4,
    },
  ],
  format: 'int32',
} as const;

export const VideoQualityModesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'AUTO',
      description: 'Discord chooses the quality for optimal performance',
      const: 1,
    },
    {
      title: 'FULL',
      description: '720p',
      const: 2,
    },
  ],
  format: 'int32',
} as const;

export const VoiceRegionResponseSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    custom: {
      type: 'boolean',
    },
    deprecated: {
      type: 'boolean',
    },
    optimal: {
      type: 'boolean',
    },
  },
  required: ['id', 'name', 'custom', 'deprecated', 'optimal'],
} as const;

export const VoiceScheduledEventCreateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    entity_type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataVoice',
        },
      ],
    },
  },
  required: ['name', 'scheduled_start_time', 'privacy_level', 'entity_type'],
} as const;

export const VoiceScheduledEventPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    status: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/GuildScheduledEventStatuses',
        },
      ],
    },
    name: {
      type: 'string',
      maxLength: 100,
    },
    description: {
      type: ['string', 'null'],
      maxLength: 1000,
    },
    image: {
      type: ['string', 'null'],
      contentEncoding: 'base64',
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    entity_type: {
      oneOf: [
        {
          type: 'null',
        },
        {
          type: 'integer',
          enum: [2],
          allOf: [
            {
              $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
            },
          ],
          format: 'int32',
        },
      ],
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataVoice',
        },
      ],
    },
  },
} as const;

export const VoiceScheduledEventResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    guild_id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    description: {
      type: ['string', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    creator: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/UserResponse',
        },
      ],
    },
    image: {
      type: ['string', 'null'],
    },
    scheduled_start_time: {
      type: 'string',
      format: 'date-time',
    },
    scheduled_end_time: {
      type: ['string', 'null'],
      format: 'date-time',
    },
    status: {
      $ref: '#/components/schemas/GuildScheduledEventStatuses',
    },
    entity_type: {
      type: 'integer',
      enum: [2],
      allOf: [
        {
          $ref: '#/components/schemas/GuildScheduledEventEntityTypes',
        },
      ],
      format: 'int32',
    },
    entity_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
    user_count: {
      type: ['integer', 'null'],
      format: 'int32',
    },
    privacy_level: {
      $ref: '#/components/schemas/GuildScheduledEventPrivacyLevels',
    },
    user_rsvp: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/ScheduledEventUserResponse',
        },
      ],
    },
    entity_metadata: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/EntityMetadataVoiceResponse',
        },
      ],
    },
  },
  required: ['id', 'guild_id', 'name', 'scheduled_start_time', 'status', 'entity_type', 'privacy_level'],
} as const;

export const WebhookSlackEmbedSchema = {
  type: 'object',
  properties: {
    title: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    title_link: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    text: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    color: {
      type: ['string', 'null'],
      maxLength: 7,
      pattern: '^#(([0-9a-fA-F]{2}){3}|([0-9a-fA-F]){3})$',
    },
    ts: {
      type: ['integer', 'null'],
    },
    pretext: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    footer: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    footer_icon: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    author_name: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    author_link: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    author_icon: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    image_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    thumb_url: {
      type: ['string', 'null'],
      maxLength: 2048,
      format: 'uri',
    },
    fields: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/WebhookSlackEmbedField',
      },
      maxItems: 1521,
    },
  },
} as const;

export const WebhookSlackEmbedFieldSchema = {
  type: 'object',
  properties: {
    name: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    value: {
      type: ['string', 'null'],
      maxLength: 152133,
    },
    inline: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const WebhookSourceChannelResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
  },
  required: ['id', 'name'],
} as const;

export const WebhookSourceGuildResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    icon: {
      type: ['string', 'null'],
    },
    name: {
      type: 'string',
    },
  },
  required: ['id', 'name'],
} as const;

export const WebhookTypesSchema = {
  type: 'integer',
  oneOf: [
    {
      title: 'GUILD_INCOMING',
      description: 'Incoming Webhooks can post messages to channels with a generated token',
      const: 1,
    },
    {
      title: 'CHANNEL_FOLLOWER',
      description:
        'Channel Follower Webhooks are internal webhooks used with Channel Following to post new messages into channels',
      const: 2,
    },
    {
      title: 'APPLICATION_INCOMING',
      description: 'Application webhooks are webhooks used with Interactions',
      const: 3,
    },
  ],
  format: 'int32',
} as const;

export const WelcomeMessageResponseSchema = {
  type: 'object',
  properties: {
    author_ids: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SnowflakeType',
      },
    },
    message: {
      type: 'string',
    },
  },
  required: ['author_ids', 'message'],
} as const;

export const WelcomeScreenPatchRequestPartialSchema = {
  type: 'object',
  properties: {
    description: {
      type: ['string', 'null'],
      maxLength: 140,
    },
    welcome_channels: {
      type: ['array', 'null'],
      items: {
        $ref: '#/components/schemas/GuildWelcomeChannel',
      },
      maxItems: 5,
    },
    enabled: {
      type: ['boolean', 'null'],
    },
  },
} as const;

export const WidgetActivitySchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
    },
  },
  required: ['name'],
} as const;

export const WidgetChannelSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    position: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['id', 'name', 'position'],
} as const;

export const WidgetImageStylesSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'SHIELD',
      description: 'shield style widget with Discord icon and guild members online count',
      const: 'shield',
    },
    {
      title: 'BANNER1',
      description:
        'large image with guild icon, name and online count. "POWERED BY DISCORD" as the footer of the widget',
      const: 'banner1',
    },
    {
      title: 'BANNER2',
      description: 'smaller widget style with guild icon, name and online count. Split on the right with Discord logo',
      const: 'banner2',
    },
    {
      title: 'BANNER3',
      description:
        'large image with guild icon, name and online count. In the footer, Discord logo on the left and "Chat Now" on the right',
      const: 'banner3',
    },
    {
      title: 'BANNER4',
      description:
        'large Discord logo at the top of the widget. Guild icon, name and online count in the middle portion of the widget and a "JOIN MY SERVER" button at the bottom',
      const: 'banner4',
    },
  ],
} as const;

export const WidgetMemberSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
    discriminator: {
      $ref: '#/components/schemas/WidgetUserDiscriminator',
    },
    avatar: {
      type: 'null',
    },
    status: {
      type: 'string',
    },
    avatar_url: {
      type: 'string',
      format: 'uri',
    },
    activity: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/WidgetActivity',
        },
      ],
    },
    deaf: {
      type: ['boolean', 'null'],
    },
    mute: {
      type: ['boolean', 'null'],
    },
    self_deaf: {
      type: ['boolean', 'null'],
    },
    self_mute: {
      type: ['boolean', 'null'],
    },
    suppress: {
      type: ['boolean', 'null'],
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['id', 'username', 'discriminator', 'status', 'avatar_url'],
} as const;

export const WidgetResponseSchema = {
  type: 'object',
  properties: {
    id: {
      $ref: '#/components/schemas/SnowflakeType',
    },
    name: {
      type: 'string',
    },
    instant_invite: {
      type: ['string', 'null'],
    },
    channels: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/WidgetChannel',
      },
    },
    members: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/WidgetMember',
      },
    },
    presence_count: {
      type: 'integer',
      format: 'int32',
    },
  },
  required: ['id', 'name', 'channels', 'members', 'presence_count'],
} as const;

export const WidgetSettingsResponseSchema = {
  type: 'object',
  properties: {
    enabled: {
      type: 'boolean',
    },
    channel_id: {
      oneOf: [
        {
          type: 'null',
        },
        {
          $ref: '#/components/schemas/SnowflakeType',
        },
      ],
    },
  },
  required: ['enabled'],
} as const;

export const WidgetUserDiscriminatorSchema = {
  type: 'string',
  oneOf: [
    {
      title: 'ZEROES',
      const: '0000',
    },
  ],
} as const;

export const ErrorSchema = {
  type: 'object',
  description: 'A single error, either for an API response or a specific field.',
  properties: {
    code: {
      type: 'integer',
      description: 'Discord internal error code. See error code reference',
    },
    message: {
      type: 'string',
      description: 'Human-readable error message',
    },
  },
  required: ['code', 'message'],
} as const;

export const InnerErrorsSchema = {
  type: 'object',
  properties: {
    _errors: {
      type: 'array',
      description: 'The list of errors for this field',
      items: {
        $ref: '#/components/schemas/Error',
      },
    },
  },
  additionalProperties: false,
  required: ['_errors'],
} as const;

export const ErrorDetailsSchema = {
  oneOf: [
    {
      type: 'object',
      additionalProperties: {
        $ref: '#/components/schemas/ErrorDetails',
      },
    },
    {
      $ref: '#/components/schemas/InnerErrors',
    },
  ],
} as const;

export const ErrorResponseSchema = {
  type: 'object',
  description: 'Errors object returned by the Discord API',
  allOf: [
    {
      $ref: '#/components/schemas/Error',
    },
    {
      type: 'object',
      properties: {
        errors: {
          $ref: '#/components/schemas/ErrorDetails',
        },
      },
    },
  ],
} as const;
