// Generated by ts-to-zod
import { z } from 'zod';

export const statusSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    object_id: z.string(),
    attribute_id: z.string(),
    status_id: z.string(),
  }),
  title: z.string(),
  is_archived: z.boolean(),
  celebration_enabled: z.boolean(),
  target_time_in_status: z.string().nullable(),
});

export const selectOptionSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    object_id: z.string(),
    attribute_id: z.string(),
    option_id: z.string(),
  }),
  title: z.string(),
  is_archived: z.boolean(),
});

export const inputValueSchema = z.union([
  z.object({
    referenced_actor_type: z.literal('workspace-member'),
    referenced_actor_id: z.string(),
  }),
  z.object({
    workspace_member_email_address: z.string(),
  }),
  z.object({
    value: z.boolean(),
  }),
  z.object({
    currency_value: z.number(),
  }),
  z.object({
    value: z.string(),
  }),
  z.object({
    domain: z.string().optional(),
  }),
  z.object({
    email_address: z.string().optional(),
  }),
  z.object({
    target_object: z.string(),
    target_record_id: z.string(),
  }),
  z.object({
    target_object: z.string(),
    '[slug_or_id_of_matching_attribute]': z.array(
      z.union([
        z.object({
          domain: z.string().optional(),
        }),
        z.object({
          email_address: z.string().optional(),
        }),
        z.object({
          value: z.number().optional(),
        }),
        z.object({
          original_phone_number: z.string().optional(),
          country_code: z
            .union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ])
            .optional()
            .nullable(),
        }),
        z.object({
          value: z.string().optional(),
        }),
      ]),
    ),
  }),
  z.object({
    interaction_type: z.union([
      z.literal('calendar-event'),
      z.literal('call'),
      z.literal('chat-thread'),
      z.literal('email'),
      z.literal('in-person-meeting'),
    ]),
    interacted_at: z.string(),
    owner_actor: z.object({
      id: z.string().optional().nullable(),
      type: z
        .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
        .optional()
        .nullable(),
    }),
  }),
  z.object({
    line_1: z.string().nullable(),
    line_2: z.string().nullable(),
    line_3: z.string().nullable(),
    line_4: z.string().nullable(),
    locality: z.string().nullable(),
    region: z.string().nullable(),
    postcode: z.string().nullable(),
    country_code: z
      .union([
        z.literal('AF'),
        z.literal('AX'),
        z.literal('AL'),
        z.literal('DZ'),
        z.literal('AS'),
        z.literal('AD'),
        z.literal('AO'),
        z.literal('AI'),
        z.literal('AQ'),
        z.literal('AG'),
        z.literal('AR'),
        z.literal('AM'),
        z.literal('AW'),
        z.literal('AU'),
        z.literal('AT'),
        z.literal('AZ'),
        z.literal('BS'),
        z.literal('BH'),
        z.literal('BD'),
        z.literal('BB'),
        z.literal('BY'),
        z.literal('BE'),
        z.literal('BZ'),
        z.literal('BJ'),
        z.literal('BM'),
        z.literal('BT'),
        z.literal('BO'),
        z.literal('BA'),
        z.literal('BW'),
        z.literal('BV'),
        z.literal('BR'),
        z.literal('IO'),
        z.literal('BN'),
        z.literal('BG'),
        z.literal('BF'),
        z.literal('BI'),
        z.literal('KH'),
        z.literal('CM'),
        z.literal('CA'),
        z.literal('CV'),
        z.literal('KY'),
        z.literal('CF'),
        z.literal('TD'),
        z.literal('CL'),
        z.literal('CN'),
        z.literal('CX'),
        z.literal('CC'),
        z.literal('CO'),
        z.literal('KM'),
        z.literal('CG'),
        z.literal('CD'),
        z.literal('CK'),
        z.literal('CR'),
        z.literal('CI'),
        z.literal('HR'),
        z.literal('CU'),
        z.literal('CW'),
        z.literal('CY'),
        z.literal('CZ'),
        z.literal('DK'),
        z.literal('DJ'),
        z.literal('DM'),
        z.literal('DO'),
        z.literal('EC'),
        z.literal('EG'),
        z.literal('SV'),
        z.literal('GQ'),
        z.literal('ER'),
        z.literal('EE'),
        z.literal('ET'),
        z.literal('FK'),
        z.literal('FO'),
        z.literal('FJ'),
        z.literal('FI'),
        z.literal('FR'),
        z.literal('GF'),
        z.literal('PF'),
        z.literal('TF'),
        z.literal('GA'),
        z.literal('GM'),
        z.literal('GE'),
        z.literal('DE'),
        z.literal('GH'),
        z.literal('GI'),
        z.literal('GR'),
        z.literal('GL'),
        z.literal('GD'),
        z.literal('GP'),
        z.literal('GU'),
        z.literal('GT'),
        z.literal('GG'),
        z.literal('GN'),
        z.literal('GW'),
        z.literal('GY'),
        z.literal('HT'),
        z.literal('HM'),
        z.literal('VA'),
        z.literal('HN'),
        z.literal('HK'),
        z.literal('HU'),
        z.literal('IS'),
        z.literal('IN'),
        z.literal('ID'),
        z.literal('IR'),
        z.literal('IQ'),
        z.literal('IE'),
        z.literal('IM'),
        z.literal('IL'),
        z.literal('IT'),
        z.literal('JM'),
        z.literal('JP'),
        z.literal('JE'),
        z.literal('JO'),
        z.literal('KZ'),
        z.literal('KE'),
        z.literal('KI'),
        z.literal('KR'),
        z.literal('KW'),
        z.literal('KG'),
        z.literal('LA'),
        z.literal('LV'),
        z.literal('LB'),
        z.literal('LS'),
        z.literal('LR'),
        z.literal('LY'),
        z.literal('LI'),
        z.literal('LT'),
        z.literal('LU'),
        z.literal('MO'),
        z.literal('MK'),
        z.literal('MG'),
        z.literal('MW'),
        z.literal('MY'),
        z.literal('MV'),
        z.literal('ML'),
        z.literal('MT'),
        z.literal('MH'),
        z.literal('MQ'),
        z.literal('MR'),
        z.literal('MU'),
        z.literal('YT'),
        z.literal('MX'),
        z.literal('FM'),
        z.literal('MD'),
        z.literal('MC'),
        z.literal('MN'),
        z.literal('ME'),
        z.literal('MS'),
        z.literal('MA'),
        z.literal('MZ'),
        z.literal('MM'),
        z.literal('NA'),
        z.literal('NR'),
        z.literal('NP'),
        z.literal('NL'),
        z.literal('AN'),
        z.literal('NC'),
        z.literal('NZ'),
        z.literal('NI'),
        z.literal('NE'),
        z.literal('NG'),
        z.literal('NU'),
        z.literal('NF'),
        z.literal('MP'),
        z.literal('NO'),
        z.literal('OM'),
        z.literal('PK'),
        z.literal('PW'),
        z.literal('PS'),
        z.literal('PA'),
        z.literal('PG'),
        z.literal('PY'),
        z.literal('PE'),
        z.literal('PH'),
        z.literal('PN'),
        z.literal('PL'),
        z.literal('PT'),
        z.literal('PR'),
        z.literal('QA'),
        z.literal('RE'),
        z.literal('RO'),
        z.literal('RU'),
        z.literal('RW'),
        z.literal('BL'),
        z.literal('SH'),
        z.literal('KN'),
        z.literal('LC'),
        z.literal('MF'),
        z.literal('PM'),
        z.literal('VC'),
        z.literal('WS'),
        z.literal('SM'),
        z.literal('ST'),
        z.literal('SA'),
        z.literal('SN'),
        z.literal('RS'),
        z.literal('SC'),
        z.literal('SL'),
        z.literal('SG'),
        z.literal('SK'),
        z.literal('SI'),
        z.literal('SB'),
        z.literal('SO'),
        z.literal('ZA'),
        z.literal('GS'),
        z.literal('ES'),
        z.literal('LK'),
        z.literal('SD'),
        z.literal('SR'),
        z.literal('SJ'),
        z.literal('SZ'),
        z.literal('SE'),
        z.literal('CH'),
        z.literal('SY'),
        z.literal('TW'),
        z.literal('TJ'),
        z.literal('TZ'),
        z.literal('TH'),
        z.literal('TL'),
        z.literal('TG'),
        z.literal('TK'),
        z.literal('TO'),
        z.literal('TT'),
        z.literal('TN'),
        z.literal('TR'),
        z.literal('TM'),
        z.literal('TC'),
        z.literal('TV'),
        z.literal('UG'),
        z.literal('UA'),
        z.literal('AE'),
        z.literal('GB'),
        z.literal('US'),
        z.literal('UM'),
        z.literal('UY'),
        z.literal('UZ'),
        z.literal('VU'),
        z.literal('VE'),
        z.literal('VN'),
        z.literal('VG'),
        z.literal('VI'),
        z.literal('WF'),
        z.literal('EH'),
        z.literal('YE'),
        z.literal('ZM'),
        z.literal('ZW'),
      ])
      .nullable(),
    latitude: z.string().nullable(),
    longitude: z.string().nullable(),
  }),
  z.object({
    value: z.number(),
  }),
  z.object({
    first_name: z.string().optional(),
    last_name: z.string().optional(),
    full_name: z.string().optional(),
  }),
  z.object({
    original_phone_number: z.string(),
    country_code: z
      .union([
        z.literal('AF'),
        z.literal('AX'),
        z.literal('AL'),
        z.literal('DZ'),
        z.literal('AS'),
        z.literal('AD'),
        z.literal('AO'),
        z.literal('AI'),
        z.literal('AQ'),
        z.literal('AG'),
        z.literal('AR'),
        z.literal('AM'),
        z.literal('AW'),
        z.literal('AU'),
        z.literal('AT'),
        z.literal('AZ'),
        z.literal('BS'),
        z.literal('BH'),
        z.literal('BD'),
        z.literal('BB'),
        z.literal('BY'),
        z.literal('BE'),
        z.literal('BZ'),
        z.literal('BJ'),
        z.literal('BM'),
        z.literal('BT'),
        z.literal('BO'),
        z.literal('BA'),
        z.literal('BW'),
        z.literal('BV'),
        z.literal('BR'),
        z.literal('IO'),
        z.literal('BN'),
        z.literal('BG'),
        z.literal('BF'),
        z.literal('BI'),
        z.literal('KH'),
        z.literal('CM'),
        z.literal('CA'),
        z.literal('CV'),
        z.literal('KY'),
        z.literal('CF'),
        z.literal('TD'),
        z.literal('CL'),
        z.literal('CN'),
        z.literal('CX'),
        z.literal('CC'),
        z.literal('CO'),
        z.literal('KM'),
        z.literal('CG'),
        z.literal('CD'),
        z.literal('CK'),
        z.literal('CR'),
        z.literal('CI'),
        z.literal('HR'),
        z.literal('CU'),
        z.literal('CW'),
        z.literal('CY'),
        z.literal('CZ'),
        z.literal('DK'),
        z.literal('DJ'),
        z.literal('DM'),
        z.literal('DO'),
        z.literal('EC'),
        z.literal('EG'),
        z.literal('SV'),
        z.literal('GQ'),
        z.literal('ER'),
        z.literal('EE'),
        z.literal('ET'),
        z.literal('FK'),
        z.literal('FO'),
        z.literal('FJ'),
        z.literal('FI'),
        z.literal('FR'),
        z.literal('GF'),
        z.literal('PF'),
        z.literal('TF'),
        z.literal('GA'),
        z.literal('GM'),
        z.literal('GE'),
        z.literal('DE'),
        z.literal('GH'),
        z.literal('GI'),
        z.literal('GR'),
        z.literal('GL'),
        z.literal('GD'),
        z.literal('GP'),
        z.literal('GU'),
        z.literal('GT'),
        z.literal('GG'),
        z.literal('GN'),
        z.literal('GW'),
        z.literal('GY'),
        z.literal('HT'),
        z.literal('HM'),
        z.literal('VA'),
        z.literal('HN'),
        z.literal('HK'),
        z.literal('HU'),
        z.literal('IS'),
        z.literal('IN'),
        z.literal('ID'),
        z.literal('IR'),
        z.literal('IQ'),
        z.literal('IE'),
        z.literal('IM'),
        z.literal('IL'),
        z.literal('IT'),
        z.literal('JM'),
        z.literal('JP'),
        z.literal('JE'),
        z.literal('JO'),
        z.literal('KZ'),
        z.literal('KE'),
        z.literal('KI'),
        z.literal('KR'),
        z.literal('KW'),
        z.literal('KG'),
        z.literal('LA'),
        z.literal('LV'),
        z.literal('LB'),
        z.literal('LS'),
        z.literal('LR'),
        z.literal('LY'),
        z.literal('LI'),
        z.literal('LT'),
        z.literal('LU'),
        z.literal('MO'),
        z.literal('MK'),
        z.literal('MG'),
        z.literal('MW'),
        z.literal('MY'),
        z.literal('MV'),
        z.literal('ML'),
        z.literal('MT'),
        z.literal('MH'),
        z.literal('MQ'),
        z.literal('MR'),
        z.literal('MU'),
        z.literal('YT'),
        z.literal('MX'),
        z.literal('FM'),
        z.literal('MD'),
        z.literal('MC'),
        z.literal('MN'),
        z.literal('ME'),
        z.literal('MS'),
        z.literal('MA'),
        z.literal('MZ'),
        z.literal('MM'),
        z.literal('NA'),
        z.literal('NR'),
        z.literal('NP'),
        z.literal('NL'),
        z.literal('AN'),
        z.literal('NC'),
        z.literal('NZ'),
        z.literal('NI'),
        z.literal('NE'),
        z.literal('NG'),
        z.literal('NU'),
        z.literal('NF'),
        z.literal('MP'),
        z.literal('NO'),
        z.literal('OM'),
        z.literal('PK'),
        z.literal('PW'),
        z.literal('PS'),
        z.literal('PA'),
        z.literal('PG'),
        z.literal('PY'),
        z.literal('PE'),
        z.literal('PH'),
        z.literal('PN'),
        z.literal('PL'),
        z.literal('PT'),
        z.literal('PR'),
        z.literal('QA'),
        z.literal('RE'),
        z.literal('RO'),
        z.literal('RU'),
        z.literal('RW'),
        z.literal('BL'),
        z.literal('SH'),
        z.literal('KN'),
        z.literal('LC'),
        z.literal('MF'),
        z.literal('PM'),
        z.literal('VC'),
        z.literal('WS'),
        z.literal('SM'),
        z.literal('ST'),
        z.literal('SA'),
        z.literal('SN'),
        z.literal('RS'),
        z.literal('SC'),
        z.literal('SL'),
        z.literal('SG'),
        z.literal('SK'),
        z.literal('SI'),
        z.literal('SB'),
        z.literal('SO'),
        z.literal('ZA'),
        z.literal('GS'),
        z.literal('ES'),
        z.literal('LK'),
        z.literal('SD'),
        z.literal('SR'),
        z.literal('SJ'),
        z.literal('SZ'),
        z.literal('SE'),
        z.literal('CH'),
        z.literal('SY'),
        z.literal('TW'),
        z.literal('TJ'),
        z.literal('TZ'),
        z.literal('TH'),
        z.literal('TL'),
        z.literal('TG'),
        z.literal('TK'),
        z.literal('TO'),
        z.literal('TT'),
        z.literal('TN'),
        z.literal('TR'),
        z.literal('TM'),
        z.literal('TC'),
        z.literal('TV'),
        z.literal('UG'),
        z.literal('UA'),
        z.literal('AE'),
        z.literal('GB'),
        z.literal('US'),
        z.literal('UM'),
        z.literal('UY'),
        z.literal('UZ'),
        z.literal('VU'),
        z.literal('VE'),
        z.literal('VN'),
        z.literal('VG'),
        z.literal('VI'),
        z.literal('WF'),
        z.literal('EH'),
        z.literal('YE'),
        z.literal('ZM'),
        z.literal('ZW'),
      ])
      .optional()
      .nullable(),
  }),
  z.object({
    status: z.string(),
  }),
  z.object({
    value: z.number(),
  }),
  z.object({
    option: z.string(),
  }),
  z.object({
    value: z.string(),
  }),
  z.object({
    value: z.string(),
  }),
]);

export const referencedActorTypeSchema = z.literal('workspace-member');

export const interactionTypeSchema = z.union([
  z.literal('calendar-event'),
  z.literal('call'),
  z.literal('chat-thread'),
  z.literal('email'),
  z.literal('in-person-meeting'),
]);

export const typeSchema = z.union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')]);

export const countryCodeSchema = z.union([
  z.literal('AF'),
  z.literal('AX'),
  z.literal('AL'),
  z.literal('DZ'),
  z.literal('AS'),
  z.literal('AD'),
  z.literal('AO'),
  z.literal('AI'),
  z.literal('AQ'),
  z.literal('AG'),
  z.literal('AR'),
  z.literal('AM'),
  z.literal('AW'),
  z.literal('AU'),
  z.literal('AT'),
  z.literal('AZ'),
  z.literal('BS'),
  z.literal('BH'),
  z.literal('BD'),
  z.literal('BB'),
  z.literal('BY'),
  z.literal('BE'),
  z.literal('BZ'),
  z.literal('BJ'),
  z.literal('BM'),
  z.literal('BT'),
  z.literal('BO'),
  z.literal('BA'),
  z.literal('BW'),
  z.literal('BV'),
  z.literal('BR'),
  z.literal('IO'),
  z.literal('BN'),
  z.literal('BG'),
  z.literal('BF'),
  z.literal('BI'),
  z.literal('KH'),
  z.literal('CM'),
  z.literal('CA'),
  z.literal('CV'),
  z.literal('KY'),
  z.literal('CF'),
  z.literal('TD'),
  z.literal('CL'),
  z.literal('CN'),
  z.literal('CX'),
  z.literal('CC'),
  z.literal('CO'),
  z.literal('KM'),
  z.literal('CG'),
  z.literal('CD'),
  z.literal('CK'),
  z.literal('CR'),
  z.literal('CI'),
  z.literal('HR'),
  z.literal('CU'),
  z.literal('CW'),
  z.literal('CY'),
  z.literal('CZ'),
  z.literal('DK'),
  z.literal('DJ'),
  z.literal('DM'),
  z.literal('DO'),
  z.literal('EC'),
  z.literal('EG'),
  z.literal('SV'),
  z.literal('GQ'),
  z.literal('ER'),
  z.literal('EE'),
  z.literal('ET'),
  z.literal('FK'),
  z.literal('FO'),
  z.literal('FJ'),
  z.literal('FI'),
  z.literal('FR'),
  z.literal('GF'),
  z.literal('PF'),
  z.literal('TF'),
  z.literal('GA'),
  z.literal('GM'),
  z.literal('GE'),
  z.literal('DE'),
  z.literal('GH'),
  z.literal('GI'),
  z.literal('GR'),
  z.literal('GL'),
  z.literal('GD'),
  z.literal('GP'),
  z.literal('GU'),
  z.literal('GT'),
  z.literal('GG'),
  z.literal('GN'),
  z.literal('GW'),
  z.literal('GY'),
  z.literal('HT'),
  z.literal('HM'),
  z.literal('VA'),
  z.literal('HN'),
  z.literal('HK'),
  z.literal('HU'),
  z.literal('IS'),
  z.literal('IN'),
  z.literal('ID'),
  z.literal('IR'),
  z.literal('IQ'),
  z.literal('IE'),
  z.literal('IM'),
  z.literal('IL'),
  z.literal('IT'),
  z.literal('JM'),
  z.literal('JP'),
  z.literal('JE'),
  z.literal('JO'),
  z.literal('KZ'),
  z.literal('KE'),
  z.literal('KI'),
  z.literal('KR'),
  z.literal('KW'),
  z.literal('KG'),
  z.literal('LA'),
  z.literal('LV'),
  z.literal('LB'),
  z.literal('LS'),
  z.literal('LR'),
  z.literal('LY'),
  z.literal('LI'),
  z.literal('LT'),
  z.literal('LU'),
  z.literal('MO'),
  z.literal('MK'),
  z.literal('MG'),
  z.literal('MW'),
  z.literal('MY'),
  z.literal('MV'),
  z.literal('ML'),
  z.literal('MT'),
  z.literal('MH'),
  z.literal('MQ'),
  z.literal('MR'),
  z.literal('MU'),
  z.literal('YT'),
  z.literal('MX'),
  z.literal('FM'),
  z.literal('MD'),
  z.literal('MC'),
  z.literal('MN'),
  z.literal('ME'),
  z.literal('MS'),
  z.literal('MA'),
  z.literal('MZ'),
  z.literal('MM'),
  z.literal('NA'),
  z.literal('NR'),
  z.literal('NP'),
  z.literal('NL'),
  z.literal('AN'),
  z.literal('NC'),
  z.literal('NZ'),
  z.literal('NI'),
  z.literal('NE'),
  z.literal('NG'),
  z.literal('NU'),
  z.literal('NF'),
  z.literal('MP'),
  z.literal('NO'),
  z.literal('OM'),
  z.literal('PK'),
  z.literal('PW'),
  z.literal('PS'),
  z.literal('PA'),
  z.literal('PG'),
  z.literal('PY'),
  z.literal('PE'),
  z.literal('PH'),
  z.literal('PN'),
  z.literal('PL'),
  z.literal('PT'),
  z.literal('PR'),
  z.literal('QA'),
  z.literal('RE'),
  z.literal('RO'),
  z.literal('RU'),
  z.literal('RW'),
  z.literal('BL'),
  z.literal('SH'),
  z.literal('KN'),
  z.literal('LC'),
  z.literal('MF'),
  z.literal('PM'),
  z.literal('VC'),
  z.literal('WS'),
  z.literal('SM'),
  z.literal('ST'),
  z.literal('SA'),
  z.literal('SN'),
  z.literal('RS'),
  z.literal('SC'),
  z.literal('SL'),
  z.literal('SG'),
  z.literal('SK'),
  z.literal('SI'),
  z.literal('SB'),
  z.literal('SO'),
  z.literal('ZA'),
  z.literal('GS'),
  z.literal('ES'),
  z.literal('LK'),
  z.literal('SD'),
  z.literal('SR'),
  z.literal('SJ'),
  z.literal('SZ'),
  z.literal('SE'),
  z.literal('CH'),
  z.literal('SY'),
  z.literal('TW'),
  z.literal('TJ'),
  z.literal('TZ'),
  z.literal('TH'),
  z.literal('TL'),
  z.literal('TG'),
  z.literal('TK'),
  z.literal('TO'),
  z.literal('TT'),
  z.literal('TN'),
  z.literal('TR'),
  z.literal('TM'),
  z.literal('TC'),
  z.literal('TV'),
  z.literal('UG'),
  z.literal('UA'),
  z.literal('AE'),
  z.literal('GB'),
  z.literal('US'),
  z.literal('UM'),
  z.literal('UY'),
  z.literal('UZ'),
  z.literal('VU'),
  z.literal('VE'),
  z.literal('VN'),
  z.literal('VG'),
  z.literal('VI'),
  z.literal('WF'),
  z.literal('EH'),
  z.literal('YE'),
  z.literal('ZM'),
  z.literal('ZW'),
]);

export const outputValueSchema = z.union([
  z.object({
    referenced_actor_type: z.union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')]),
    referenced_actor_id: z.string().nullable(),
    attribute_type: z.literal('actor-reference'),
  }),
  z.object({
    value: z.boolean(),
    attribute_type: z.literal('checkbox'),
  }),
  z.object({
    currency_value: z.number(),
    currency_code: z
      .union([
        z.literal('EUR'),
        z.literal('GBP'),
        z.literal('USD'),
        z.literal('CAD'),
        z.literal('AUD'),
        z.literal('NZD'),
        z.literal('AED'),
        z.literal('INR'),
        z.literal('CHF'),
        z.literal('JPY'),
        z.literal('CNY'),
        z.literal('PHP'),
        z.literal('ILS'),
        z.literal('SGD'),
        z.literal('HKD'),
        z.literal('MYR'),
        z.literal('NTD'),
        z.literal('NOK'),
        z.literal('SEK'),
        z.literal('ISK'),
        z.literal('BEL'),
        z.literal('PLN'),
        z.literal('KRW'),
        z.literal('DKK'),
        z.literal('BRL'),
      ])
      .optional()
      .nullable(),
    attribute_type: z.literal('currency'),
  }),
  z.object({
    attribute_type: z.literal('date'),
    value: z.string(),
  }),
  z.object({
    domain: z.string(),
    root_domain: z.string(),
    attribute_type: z.literal('domain'),
  }),
  z.object({
    original_email_address: z.string(),
    email_address: z.string(),
    email_domain: z.string(),
    email_root_domain: z.string(),
    email_local_specifier: z.string(),
    attribute_type: z.literal('email-address'),
  }),
  z.object({
    target_object: z.string(),
    target_record_id: z.string(),
    attribute_type: z.literal('record-reference'),
  }),
  z.object({
    interaction_type: z.union([
      z.literal('calendar-event'),
      z.literal('call'),
      z.literal('chat-thread'),
      z.literal('email'),
      z.literal('in-person-meeting'),
    ]),
    interacted_at: z.string(),
    owner_actor: z.object({
      id: z.string().optional().nullable(),
      type: z
        .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
        .optional()
        .nullable(),
    }),
    attribute_type: z.literal('interaction'),
  }),
  z.object({
    line_1: z.string().nullable(),
    line_2: z.string().nullable(),
    line_3: z.string().nullable(),
    line_4: z.string().nullable(),
    locality: z.string().nullable(),
    region: z.string().nullable(),
    postcode: z.string().nullable(),
    country_code: z
      .union([
        z.literal('AF'),
        z.literal('AX'),
        z.literal('AL'),
        z.literal('DZ'),
        z.literal('AS'),
        z.literal('AD'),
        z.literal('AO'),
        z.literal('AI'),
        z.literal('AQ'),
        z.literal('AG'),
        z.literal('AR'),
        z.literal('AM'),
        z.literal('AW'),
        z.literal('AU'),
        z.literal('AT'),
        z.literal('AZ'),
        z.literal('BS'),
        z.literal('BH'),
        z.literal('BD'),
        z.literal('BB'),
        z.literal('BY'),
        z.literal('BE'),
        z.literal('BZ'),
        z.literal('BJ'),
        z.literal('BM'),
        z.literal('BT'),
        z.literal('BO'),
        z.literal('BA'),
        z.literal('BW'),
        z.literal('BV'),
        z.literal('BR'),
        z.literal('IO'),
        z.literal('BN'),
        z.literal('BG'),
        z.literal('BF'),
        z.literal('BI'),
        z.literal('KH'),
        z.literal('CM'),
        z.literal('CA'),
        z.literal('CV'),
        z.literal('KY'),
        z.literal('CF'),
        z.literal('TD'),
        z.literal('CL'),
        z.literal('CN'),
        z.literal('CX'),
        z.literal('CC'),
        z.literal('CO'),
        z.literal('KM'),
        z.literal('CG'),
        z.literal('CD'),
        z.literal('CK'),
        z.literal('CR'),
        z.literal('CI'),
        z.literal('HR'),
        z.literal('CU'),
        z.literal('CW'),
        z.literal('CY'),
        z.literal('CZ'),
        z.literal('DK'),
        z.literal('DJ'),
        z.literal('DM'),
        z.literal('DO'),
        z.literal('EC'),
        z.literal('EG'),
        z.literal('SV'),
        z.literal('GQ'),
        z.literal('ER'),
        z.literal('EE'),
        z.literal('ET'),
        z.literal('FK'),
        z.literal('FO'),
        z.literal('FJ'),
        z.literal('FI'),
        z.literal('FR'),
        z.literal('GF'),
        z.literal('PF'),
        z.literal('TF'),
        z.literal('GA'),
        z.literal('GM'),
        z.literal('GE'),
        z.literal('DE'),
        z.literal('GH'),
        z.literal('GI'),
        z.literal('GR'),
        z.literal('GL'),
        z.literal('GD'),
        z.literal('GP'),
        z.literal('GU'),
        z.literal('GT'),
        z.literal('GG'),
        z.literal('GN'),
        z.literal('GW'),
        z.literal('GY'),
        z.literal('HT'),
        z.literal('HM'),
        z.literal('VA'),
        z.literal('HN'),
        z.literal('HK'),
        z.literal('HU'),
        z.literal('IS'),
        z.literal('IN'),
        z.literal('ID'),
        z.literal('IR'),
        z.literal('IQ'),
        z.literal('IE'),
        z.literal('IM'),
        z.literal('IL'),
        z.literal('IT'),
        z.literal('JM'),
        z.literal('JP'),
        z.literal('JE'),
        z.literal('JO'),
        z.literal('KZ'),
        z.literal('KE'),
        z.literal('KI'),
        z.literal('KR'),
        z.literal('KW'),
        z.literal('KG'),
        z.literal('LA'),
        z.literal('LV'),
        z.literal('LB'),
        z.literal('LS'),
        z.literal('LR'),
        z.literal('LY'),
        z.literal('LI'),
        z.literal('LT'),
        z.literal('LU'),
        z.literal('MO'),
        z.literal('MK'),
        z.literal('MG'),
        z.literal('MW'),
        z.literal('MY'),
        z.literal('MV'),
        z.literal('ML'),
        z.literal('MT'),
        z.literal('MH'),
        z.literal('MQ'),
        z.literal('MR'),
        z.literal('MU'),
        z.literal('YT'),
        z.literal('MX'),
        z.literal('FM'),
        z.literal('MD'),
        z.literal('MC'),
        z.literal('MN'),
        z.literal('ME'),
        z.literal('MS'),
        z.literal('MA'),
        z.literal('MZ'),
        z.literal('MM'),
        z.literal('NA'),
        z.literal('NR'),
        z.literal('NP'),
        z.literal('NL'),
        z.literal('AN'),
        z.literal('NC'),
        z.literal('NZ'),
        z.literal('NI'),
        z.literal('NE'),
        z.literal('NG'),
        z.literal('NU'),
        z.literal('NF'),
        z.literal('MP'),
        z.literal('NO'),
        z.literal('OM'),
        z.literal('PK'),
        z.literal('PW'),
        z.literal('PS'),
        z.literal('PA'),
        z.literal('PG'),
        z.literal('PY'),
        z.literal('PE'),
        z.literal('PH'),
        z.literal('PN'),
        z.literal('PL'),
        z.literal('PT'),
        z.literal('PR'),
        z.literal('QA'),
        z.literal('RE'),
        z.literal('RO'),
        z.literal('RU'),
        z.literal('RW'),
        z.literal('BL'),
        z.literal('SH'),
        z.literal('KN'),
        z.literal('LC'),
        z.literal('MF'),
        z.literal('PM'),
        z.literal('VC'),
        z.literal('WS'),
        z.literal('SM'),
        z.literal('ST'),
        z.literal('SA'),
        z.literal('SN'),
        z.literal('RS'),
        z.literal('SC'),
        z.literal('SL'),
        z.literal('SG'),
        z.literal('SK'),
        z.literal('SI'),
        z.literal('SB'),
        z.literal('SO'),
        z.literal('ZA'),
        z.literal('GS'),
        z.literal('ES'),
        z.literal('LK'),
        z.literal('SD'),
        z.literal('SR'),
        z.literal('SJ'),
        z.literal('SZ'),
        z.literal('SE'),
        z.literal('CH'),
        z.literal('SY'),
        z.literal('TW'),
        z.literal('TJ'),
        z.literal('TZ'),
        z.literal('TH'),
        z.literal('TL'),
        z.literal('TG'),
        z.literal('TK'),
        z.literal('TO'),
        z.literal('TT'),
        z.literal('TN'),
        z.literal('TR'),
        z.literal('TM'),
        z.literal('TC'),
        z.literal('TV'),
        z.literal('UG'),
        z.literal('UA'),
        z.literal('AE'),
        z.literal('GB'),
        z.literal('US'),
        z.literal('UM'),
        z.literal('UY'),
        z.literal('UZ'),
        z.literal('VU'),
        z.literal('VE'),
        z.literal('VN'),
        z.literal('VG'),
        z.literal('VI'),
        z.literal('WF'),
        z.literal('EH'),
        z.literal('YE'),
        z.literal('ZM'),
        z.literal('ZW'),
      ])
      .nullable(),
    latitude: z.string().nullable(),
    longitude: z.string().nullable(),
    attribute_type: z.literal('location'),
  }),
  z.object({
    value: z.number(),
    attribute_type: z.literal('number'),
  }),
  z.object({
    first_name: z.string(),
    last_name: z.string(),
    full_name: z.string(),
    attribute_type: z.literal('personal-name'),
  }),
  z.object({
    original_phone_number: z.string(),
    country_code: z.union([
      z.literal('AF'),
      z.literal('AX'),
      z.literal('AL'),
      z.literal('DZ'),
      z.literal('AS'),
      z.literal('AD'),
      z.literal('AO'),
      z.literal('AI'),
      z.literal('AQ'),
      z.literal('AG'),
      z.literal('AR'),
      z.literal('AM'),
      z.literal('AW'),
      z.literal('AU'),
      z.literal('AT'),
      z.literal('AZ'),
      z.literal('BS'),
      z.literal('BH'),
      z.literal('BD'),
      z.literal('BB'),
      z.literal('BY'),
      z.literal('BE'),
      z.literal('BZ'),
      z.literal('BJ'),
      z.literal('BM'),
      z.literal('BT'),
      z.literal('BO'),
      z.literal('BA'),
      z.literal('BW'),
      z.literal('BV'),
      z.literal('BR'),
      z.literal('IO'),
      z.literal('BN'),
      z.literal('BG'),
      z.literal('BF'),
      z.literal('BI'),
      z.literal('KH'),
      z.literal('CM'),
      z.literal('CA'),
      z.literal('CV'),
      z.literal('KY'),
      z.literal('CF'),
      z.literal('TD'),
      z.literal('CL'),
      z.literal('CN'),
      z.literal('CX'),
      z.literal('CC'),
      z.literal('CO'),
      z.literal('KM'),
      z.literal('CG'),
      z.literal('CD'),
      z.literal('CK'),
      z.literal('CR'),
      z.literal('CI'),
      z.literal('HR'),
      z.literal('CU'),
      z.literal('CW'),
      z.literal('CY'),
      z.literal('CZ'),
      z.literal('DK'),
      z.literal('DJ'),
      z.literal('DM'),
      z.literal('DO'),
      z.literal('EC'),
      z.literal('EG'),
      z.literal('SV'),
      z.literal('GQ'),
      z.literal('ER'),
      z.literal('EE'),
      z.literal('ET'),
      z.literal('FK'),
      z.literal('FO'),
      z.literal('FJ'),
      z.literal('FI'),
      z.literal('FR'),
      z.literal('GF'),
      z.literal('PF'),
      z.literal('TF'),
      z.literal('GA'),
      z.literal('GM'),
      z.literal('GE'),
      z.literal('DE'),
      z.literal('GH'),
      z.literal('GI'),
      z.literal('GR'),
      z.literal('GL'),
      z.literal('GD'),
      z.literal('GP'),
      z.literal('GU'),
      z.literal('GT'),
      z.literal('GG'),
      z.literal('GN'),
      z.literal('GW'),
      z.literal('GY'),
      z.literal('HT'),
      z.literal('HM'),
      z.literal('VA'),
      z.literal('HN'),
      z.literal('HK'),
      z.literal('HU'),
      z.literal('IS'),
      z.literal('IN'),
      z.literal('ID'),
      z.literal('IR'),
      z.literal('IQ'),
      z.literal('IE'),
      z.literal('IM'),
      z.literal('IL'),
      z.literal('IT'),
      z.literal('JM'),
      z.literal('JP'),
      z.literal('JE'),
      z.literal('JO'),
      z.literal('KZ'),
      z.literal('KE'),
      z.literal('KI'),
      z.literal('KR'),
      z.literal('KW'),
      z.literal('KG'),
      z.literal('LA'),
      z.literal('LV'),
      z.literal('LB'),
      z.literal('LS'),
      z.literal('LR'),
      z.literal('LY'),
      z.literal('LI'),
      z.literal('LT'),
      z.literal('LU'),
      z.literal('MO'),
      z.literal('MK'),
      z.literal('MG'),
      z.literal('MW'),
      z.literal('MY'),
      z.literal('MV'),
      z.literal('ML'),
      z.literal('MT'),
      z.literal('MH'),
      z.literal('MQ'),
      z.literal('MR'),
      z.literal('MU'),
      z.literal('YT'),
      z.literal('MX'),
      z.literal('FM'),
      z.literal('MD'),
      z.literal('MC'),
      z.literal('MN'),
      z.literal('ME'),
      z.literal('MS'),
      z.literal('MA'),
      z.literal('MZ'),
      z.literal('MM'),
      z.literal('NA'),
      z.literal('NR'),
      z.literal('NP'),
      z.literal('NL'),
      z.literal('AN'),
      z.literal('NC'),
      z.literal('NZ'),
      z.literal('NI'),
      z.literal('NE'),
      z.literal('NG'),
      z.literal('NU'),
      z.literal('NF'),
      z.literal('MP'),
      z.literal('NO'),
      z.literal('OM'),
      z.literal('PK'),
      z.literal('PW'),
      z.literal('PS'),
      z.literal('PA'),
      z.literal('PG'),
      z.literal('PY'),
      z.literal('PE'),
      z.literal('PH'),
      z.literal('PN'),
      z.literal('PL'),
      z.literal('PT'),
      z.literal('PR'),
      z.literal('QA'),
      z.literal('RE'),
      z.literal('RO'),
      z.literal('RU'),
      z.literal('RW'),
      z.literal('BL'),
      z.literal('SH'),
      z.literal('KN'),
      z.literal('LC'),
      z.literal('MF'),
      z.literal('PM'),
      z.literal('VC'),
      z.literal('WS'),
      z.literal('SM'),
      z.literal('ST'),
      z.literal('SA'),
      z.literal('SN'),
      z.literal('RS'),
      z.literal('SC'),
      z.literal('SL'),
      z.literal('SG'),
      z.literal('SK'),
      z.literal('SI'),
      z.literal('SB'),
      z.literal('SO'),
      z.literal('ZA'),
      z.literal('GS'),
      z.literal('ES'),
      z.literal('LK'),
      z.literal('SD'),
      z.literal('SR'),
      z.literal('SJ'),
      z.literal('SZ'),
      z.literal('SE'),
      z.literal('CH'),
      z.literal('SY'),
      z.literal('TW'),
      z.literal('TJ'),
      z.literal('TZ'),
      z.literal('TH'),
      z.literal('TL'),
      z.literal('TG'),
      z.literal('TK'),
      z.literal('TO'),
      z.literal('TT'),
      z.literal('TN'),
      z.literal('TR'),
      z.literal('TM'),
      z.literal('TC'),
      z.literal('TV'),
      z.literal('UG'),
      z.literal('UA'),
      z.literal('AE'),
      z.literal('GB'),
      z.literal('US'),
      z.literal('UM'),
      z.literal('UY'),
      z.literal('UZ'),
      z.literal('VU'),
      z.literal('VE'),
      z.literal('VN'),
      z.literal('VG'),
      z.literal('VI'),
      z.literal('WF'),
      z.literal('EH'),
      z.literal('YE'),
      z.literal('ZM'),
      z.literal('ZW'),
    ]),
    phone_number: z.string(),
    attribute_type: z.literal('phone-number'),
  }),
  z.object({
    status: z.string(),
    attribute_type: z.literal('status'),
  }),
  z.object({
    status: statusSchema,
    attribute_type: z.literal('status'),
  }),
  z.object({
    value: z.number(),
    attribute_type: z.literal('rating'),
  }),
  z.object({
    option: z.string(),
    attribute_type: z.literal('select'),
  }),
  z.object({
    option: selectOptionSchema,
    attribute_type: z.literal('select'),
  }),
  z.object({
    value: z.string(),
    attribute_type: z.literal('text'),
  }),
  z.object({
    attribute_type: z.literal('timestamp'),
    value: z.string(),
  }),
]);

export const referencedActorType2Schema = z.union([
  z.literal('api-token'),
  z.literal('workspace-member'),
  z.literal('system'),
]);

export const attributeTypeSchema = z.literal('actor-reference');

export const currencyCodeSchema = z.union([
  z.literal('EUR'),
  z.literal('GBP'),
  z.literal('USD'),
  z.literal('CAD'),
  z.literal('AUD'),
  z.literal('NZD'),
  z.literal('AED'),
  z.literal('INR'),
  z.literal('CHF'),
  z.literal('JPY'),
  z.literal('CNY'),
  z.literal('PHP'),
  z.literal('ILS'),
  z.literal('SGD'),
  z.literal('HKD'),
  z.literal('MYR'),
  z.literal('NTD'),
  z.literal('NOK'),
  z.literal('SEK'),
  z.literal('ISK'),
  z.literal('BEL'),
  z.literal('PLN'),
  z.literal('KRW'),
  z.literal('DKK'),
  z.literal('BRL'),
]);

export const attributeSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    object_id: z.string(),
    attribute_id: z.string(),
  }),
  title: z.string(),
  description: z.string().nullable(),
  api_slug: z.string(),
  type: z.union([
    z.literal('text'),
    z.literal('number'),
    z.literal('checkbox'),
    z.literal('currency'),
    z.literal('date'),
    z.literal('timestamp'),
    z.literal('rating'),
    z.literal('status'),
    z.literal('select'),
    z.literal('record-reference'),
    z.literal('actor-reference'),
    z.literal('location'),
    z.literal('domain'),
    z.literal('email-address'),
    z.literal('phone-number'),
    z.literal('interaction'),
    z.literal('personal-name'),
  ]),
  is_system_attribute: z.boolean(),
  is_writable: z.boolean(),
  is_required: z.boolean(),
  is_unique: z.boolean(),
  is_multiselect: z.boolean(),
  is_default_value_enabled: z.boolean(),
  is_archived: z.boolean(),
  default_value: z
    .union([
      z.object({
        type: z.literal('dynamic'),
        template: z.union([z.literal('current-user'), z.string()]),
      }),
      z.object({
        type: z.literal('static'),
        template: z.array(outputValueSchema),
      }),
    ])
    .nullable(),
  relationship: z
    .object({
      id: z.object({
        workspace_id: z.string(),
        object_id: z.string(),
        attribute_id: z.string(),
      }),
    })
    .nullable(),
  created_at: z.string(),
  config: z.object({
    currency: z.object({
      default_currency_code: z
        .union([
          z.literal('EUR'),
          z.literal('GBP'),
          z.literal('USD'),
          z.literal('CAD'),
          z.literal('AUD'),
          z.literal('NZD'),
          z.literal('AED'),
          z.literal('INR'),
          z.literal('CHF'),
          z.literal('JPY'),
          z.literal('CNY'),
          z.literal('PHP'),
          z.literal('ILS'),
          z.literal('SGD'),
          z.literal('HKD'),
          z.literal('MYR'),
          z.literal('NTD'),
          z.literal('NOK'),
          z.literal('SEK'),
          z.literal('ISK'),
          z.literal('BEL'),
          z.literal('PLN'),
          z.literal('KRW'),
          z.literal('DKK'),
          z.literal('BRL'),
        ])
        .nullable(),
      display_type: z
        .union([z.literal('code'), z.literal('name'), z.literal('narrowSymbol'), z.literal('symbol')])
        .nullable(),
    }),
    record_reference: z.object({
      allowed_object_ids: z.array(z.string()).nullable(),
    }),
  }),
});

export const type2Schema = z.union([
  z.literal('text'),
  z.literal('number'),
  z.literal('checkbox'),
  z.literal('currency'),
  z.literal('date'),
  z.literal('timestamp'),
  z.literal('rating'),
  z.literal('status'),
  z.literal('select'),
  z.literal('record-reference'),
  z.literal('actor-reference'),
  z.literal('location'),
  z.literal('domain'),
  z.literal('email-address'),
  z.literal('phone-number'),
  z.literal('interaction'),
  z.literal('personal-name'),
]);

export const defaultCurrencyCodeSchema = z.union([
  z.literal('EUR'),
  z.literal('GBP'),
  z.literal('USD'),
  z.literal('CAD'),
  z.literal('AUD'),
  z.literal('NZD'),
  z.literal('AED'),
  z.literal('INR'),
  z.literal('CHF'),
  z.literal('JPY'),
  z.literal('CNY'),
  z.literal('PHP'),
  z.literal('ILS'),
  z.literal('SGD'),
  z.literal('HKD'),
  z.literal('MYR'),
  z.literal('NTD'),
  z.literal('NOK'),
  z.literal('SEK'),
  z.literal('ISK'),
  z.literal('BEL'),
  z.literal('PLN'),
  z.literal('KRW'),
  z.literal('DKK'),
  z.literal('BRL'),
]);

export const displayTypeSchema = z.union([
  z.literal('code'),
  z.literal('name'),
  z.literal('narrowSymbol'),
  z.literal('symbol'),
]);

export const listSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    list_id: z.string(),
  }),
  api_slug: z.string(),
  name: z.string(),
  parent_object: z.array(z.string()),
  workspace_access: z.union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')]).nullable(),
  workspace_member_access: z.array(
    z.object({
      workspace_member_id: z.string(),
      level: z.union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')]),
    }),
  ),
  created_by_actor: z.object({
    id: z.string().optional().nullable(),
    type: z
      .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
      .optional()
      .nullable(),
  }),
  created_at: z.string(),
});

export const workspaceAccessSchema = z.union([
  z.literal('full-access'),
  z.literal('read-and-write'),
  z.literal('read-only'),
]);

export const attioObjectSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    object_id: z.string(),
  }),
  api_slug: z.string().nullable(),
  singular_noun: z.string().nullable(),
  plural_noun: z.string().nullable(),
  created_at: z.string(),
});

export const workspaceMemberSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    workspace_member_id: z.string(),
  }),
  first_name: z.string(),
  last_name: z.string(),
  avatar_url: z.string().nullable(),
  email_address: z.string(),
  created_at: z.string(),
  access_level: z.union([z.literal('admin'), z.literal('member'), z.literal('suspended')]),
});

export const accessLevelSchema = z.union([z.literal('admin'), z.literal('member'), z.literal('suspended')]);

export const commentSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    comment_id: z.string(),
  }),
  thread_id: z.string(),
  content_plaintext: z.string(),
  entry: z
    .object({
      entry_id: z.string(),
      list_id: z.string(),
    })
    .nullable(),
  record: z.object({
    record_id: z.string(),
    object_id: z.string(),
  }),
  resolved_at: z.string().nullable(),
  resolved_by: z.object({
    id: z.string().optional().nullable(),
    type: z
      .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
      .optional()
      .nullable(),
  }),
  created_at: z.string(),
  author: z.object({
    id: z.string().optional().nullable(),
    type: z
      .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
      .optional()
      .nullable(),
  }),
});

export const noteSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    note_id: z.string(),
  }),
  parent_object: z.string(),
  parent_record_id: z.string(),
  title: z.string(),
  content_plaintext: z.string(),
  created_by_actor: z.object({
    id: z.string().optional().nullable(),
    type: z
      .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
      .optional()
      .nullable(),
  }),
  created_at: z.string(),
});

export const taskSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    task_id: z.string(),
  }),
  content_plaintext: z.string(),
  deadline_at: z.string().nullable(),
  is_completed: z.boolean(),
  linked_records: z.array(
    z.object({
      target_object_id: z.string(),
      target_record_id: z.string(),
    }),
  ),
  assignees: z.array(
    z.object({
      referenced_actor_type: z.union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')]),
      referenced_actor_id: z.string(),
    }),
  ),
  created_by_actor: z.object({
    id: z.string().optional().nullable(),
    type: z
      .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
      .optional()
      .nullable(),
  }),
  created_at: z.string(),
});

export const threadSchema = z.object({
  id: z.object({
    workspace_id: z.string(),
    thread_id: z.string(),
  }),
  comments: z.array(commentSchema),
  created_at: z.string(),
});

export const getV2ObjectsResponseSchema = z.object({
  data: z.array(z.any()),
});

export const getV2ObjectsErrorSchema = z.unknown();

export const postV2ObjectsDataSchema = z.object({
  body: z.object({
    data: z.object({
      api_slug: z.string(),
      singular_noun: z.string(),
      plural_noun: z.string(),
    }),
  }),
});

export const postV2ObjectsResponseSchema = z.object({
  data: attioObjectSchema,
});

export const postV2ObjectsErrorSchema = z.object({
  status_code: z.literal(409),
  type: z.literal('invalid_request_error'),
  code: z.literal('slug_conflict'),
  message: z.string(),
});

export const getV2ObjectsByObjectDataSchema = z.object({
  path: z.object({
    object: z.string(),
  }),
});

export const getV2ObjectsByObjectResponseSchema = z.object({
  data: attioObjectSchema,
});

export const getV2ObjectsByObjectErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2ObjectsByObjectDataSchema = z.object({
  body: z.object({
    data: z.object({
      api_slug: z.string().optional(),
      singular_noun: z.string().optional(),
      plural_noun: z.string().optional(),
    }),
  }),
  path: z.object({
    object: z.string(),
  }),
});

export const patchV2ObjectsByObjectResponseSchema = z.object({
  data: attioObjectSchema,
});

export const patchV2ObjectsByObjectErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const getV2ByTargetByIdentifierAttributesDataSchema = z.object({
  path: z.object({
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      show_archived: z.boolean().optional(),
    })
    .optional(),
});

export const getV2ByTargetByIdentifierAttributesResponseSchema = z.object({
  data: z.array(attributeSchema),
});

export const getV2ByTargetByIdentifierAttributesErrorSchema = z.unknown();

export const postV2ByTargetByIdentifierAttributesDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string(),
      description: z.string().nullable(),
      api_slug: z.string(),
      type: z.union([
        z.literal('text'),
        z.literal('number'),
        z.literal('checkbox'),
        z.literal('currency'),
        z.literal('date'),
        z.literal('timestamp'),
        z.literal('rating'),
        z.literal('status'),
        z.literal('select'),
        z.literal('record-reference'),
        z.literal('actor-reference'),
        z.literal('location'),
        z.literal('domain'),
        z.literal('email-address'),
        z.literal('phone-number'),
      ]),
      is_required: z.boolean(),
      is_unique: z.boolean(),
      is_multiselect: z.boolean(),
      default_value: z
        .union([
          z.object({
            type: z.literal('dynamic'),
            template: z.union([z.literal('current-user'), z.string()]),
          }),
          z.object({
            type: z.literal('static'),
            template: z.array(inputValueSchema),
          }),
        ])
        .optional()
        .nullable(),
      config: z.object({
        currency: z
          .object({
            default_currency_code: z.union([
              z.literal('EUR'),
              z.literal('GBP'),
              z.literal('USD'),
              z.literal('CAD'),
              z.literal('AUD'),
              z.literal('NZD'),
              z.literal('AED'),
              z.literal('INR'),
              z.literal('CHF'),
              z.literal('JPY'),
              z.literal('CNY'),
              z.literal('PHP'),
              z.literal('ILS'),
              z.literal('SGD'),
              z.literal('HKD'),
              z.literal('MYR'),
              z.literal('NTD'),
              z.literal('NOK'),
              z.literal('SEK'),
              z.literal('ISK'),
              z.literal('BEL'),
              z.literal('PLN'),
              z.literal('KRW'),
              z.literal('DKK'),
              z.literal('BRL'),
            ]),
            display_type: z.union([
              z.literal('code'),
              z.literal('name'),
              z.literal('narrowSymbol'),
              z.literal('symbol'),
            ]),
          })
          .optional(),
        record_reference: z
          .object({
            allowed_objects: z.array(z.string()),
          })
          .optional(),
      }),
    }),
  }),
  path: z.object({
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
});

export const postV2ByTargetByIdentifierAttributesResponseSchema = z.object({
  data: attributeSchema,
});

export const postV2ByTargetByIdentifierAttributesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const getV2ByTargetByIdentifierAttributesByAttributeDataSchema = z.object({
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
});

export const getV2ByTargetByIdentifierAttributesByAttributeResponseSchema = z.object({
  data: attributeSchema,
});

export const getV2ByTargetByIdentifierAttributesByAttributeErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2ByTargetByIdentifierAttributesByAttributeDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string().optional(),
      description: z.string().optional().nullable(),
      api_slug: z.string().optional(),
      is_required: z.boolean().optional(),
      is_unique: z.boolean().optional(),
      default_value: z
        .union([
          z.object({
            type: z.literal('dynamic'),
            template: z.union([z.literal('current-user'), z.string()]),
          }),
          z.object({
            type: z.literal('static'),
            template: z.array(inputValueSchema),
          }),
        ])
        .optional()
        .nullable(),
      config: z
        .object({
          currency: z
            .object({
              default_currency_code: z.union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ]),
              display_type: z.union([
                z.literal('code'),
                z.literal('name'),
                z.literal('narrowSymbol'),
                z.literal('symbol'),
              ]),
            })
            .optional(),
          record_reference: z
            .object({
              allowed_objects: z.array(z.string()),
            })
            .optional(),
        })
        .optional(),
      is_archived: z.boolean().optional(),
    }),
  }),
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
});

export const patchV2ByTargetByIdentifierAttributesByAttributeResponseSchema = z.object({
  data: attributeSchema,
});

export const patchV2ByTargetByIdentifierAttributesByAttributeErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('system_edit_unauthorized'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2ByTargetByIdentifierAttributesByAttributeOptionsDataSchema = z.object({
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
  query: z
    .object({
      show_archived: z.boolean().optional(),
    })
    .optional(),
});

export const getV2ByTargetByIdentifierAttributesByAttributeOptionsResponseSchema = z.object({
  data: z.array(selectOptionSchema),
});

export const getV2ByTargetByIdentifierAttributesByAttributeOptionsErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const postV2ByTargetByIdentifierAttributesByAttributeOptionsDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string(),
    }),
  }),
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
});

export const postV2ByTargetByIdentifierAttributesByAttributeOptionsResponseSchema = z.object({
  data: selectOptionSchema,
});

export const postV2ByTargetByIdentifierAttributesByAttributeOptionsErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const patchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string().optional(),
      is_archived: z.boolean().optional(),
    }),
  }),
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    option: z.string(),
    target: z.union([z.literal('objects'), z.literal('lists')]),
  }),
});

export const patchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionResponseSchema = z.object({
  data: selectOptionSchema,
});

export const patchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const getV2ByTargetByIdentifierAttributesByAttributeStatusesDataSchema = z.object({
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('lists'), z.literal('objects')]),
  }),
  query: z
    .object({
      show_archived: z.boolean().optional(),
    })
    .optional(),
});

export const getV2ByTargetByIdentifierAttributesByAttributeStatusesResponseSchema = z.object({
  data: z.array(statusSchema),
});

export const getV2ByTargetByIdentifierAttributesByAttributeStatusesErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const postV2ByTargetByIdentifierAttributesByAttributeStatusesDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string(),
      celebration_enabled: z.boolean().optional(),
      target_time_in_status: z.string().optional().nullable(),
    }),
  }),
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    target: z.union([z.literal('lists'), z.literal('objects')]),
  }),
});

export const postV2ByTargetByIdentifierAttributesByAttributeStatusesResponseSchema = z.object({
  data: statusSchema,
});

export const postV2ByTargetByIdentifierAttributesByAttributeStatusesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const patchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusDataSchema = z.object({
  body: z.object({
    data: z.object({
      title: z.string().optional(),
      celebration_enabled: z.boolean().optional(),
      target_time_in_status: z.string().optional().nullable(),
      is_archived: z.boolean().optional(),
    }),
  }),
  path: z.object({
    attribute: z.string(),
    identifier: z.string(),
    status: z.string(),
    target: z.union([z.literal('lists'), z.literal('objects')]),
  }),
});

export const patchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusResponseSchema = z.object({
  data: statusSchema,
});

export const patchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(409),
    type: z.literal('invalid_request_error'),
    code: z.literal('slug_conflict'),
    message: z.string(),
  }),
]);

export const postV2ObjectsByObjectRecordsQueryDataSchema = z.object({
  body: z.object({
    filter: z.record(z.unknown()).optional(),
    sorts: z
      .array(
        z.union([
          z.object({
            direction: z.union([z.literal('asc'), z.literal('desc')]),
            attribute: z.string(),
            field: z.string().optional(),
          }),
          z.object({
            direction: z.union([z.literal('asc'), z.literal('desc')]),
            path: z.array(z.tuple([z.string(), z.string()])),
            field: z.string().optional(),
          }),
        ]),
      )
      .optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
  }),
  path: z.object({
    object: z.string(),
  }),
});

export const postV2ObjectsByObjectRecordsQueryResponseSchema = z.object({
  data: z.array(
    z.object({
      id: z.object({
        workspace_id: z.string(),
        object_id: z.string(),
        record_id: z.string(),
      }),
      created_at: z.string(),
      values: z.record(
        z.array(
          z.union([
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              referenced_actor_type: z.union([
                z.literal('api-token'),
                z.literal('workspace-member'),
                z.literal('system'),
              ]),
              referenced_actor_id: z.string().nullable(),
              attribute_type: z.literal('actor-reference'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.boolean(),
              attribute_type: z.literal('checkbox'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              currency_value: z.number(),
              currency_code: z
                .union([
                  z.literal('EUR'),
                  z.literal('GBP'),
                  z.literal('USD'),
                  z.literal('CAD'),
                  z.literal('AUD'),
                  z.literal('NZD'),
                  z.literal('AED'),
                  z.literal('INR'),
                  z.literal('CHF'),
                  z.literal('JPY'),
                  z.literal('CNY'),
                  z.literal('PHP'),
                  z.literal('ILS'),
                  z.literal('SGD'),
                  z.literal('HKD'),
                  z.literal('MYR'),
                  z.literal('NTD'),
                  z.literal('NOK'),
                  z.literal('SEK'),
                  z.literal('ISK'),
                  z.literal('BEL'),
                  z.literal('PLN'),
                  z.literal('KRW'),
                  z.literal('DKK'),
                  z.literal('BRL'),
                ])
                .optional()
                .nullable(),
              attribute_type: z.literal('currency'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('date'),
              value: z.string(),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              domain: z.string(),
              root_domain: z.string(),
              attribute_type: z.literal('domain'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              original_email_address: z.string(),
              email_address: z.string(),
              email_domain: z.string(),
              email_root_domain: z.string(),
              email_local_specifier: z.string(),
              attribute_type: z.literal('email-address'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              target_object: z.string(),
              target_record_id: z.string(),
              attribute_type: z.literal('record-reference'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              interaction_type: z.union([
                z.literal('calendar-event'),
                z.literal('call'),
                z.literal('chat-thread'),
                z.literal('email'),
                z.literal('in-person-meeting'),
              ]),
              interacted_at: z.string(),
              owner_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('interaction'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              line_1: z.string().nullable(),
              line_2: z.string().nullable(),
              line_3: z.string().nullable(),
              line_4: z.string().nullable(),
              locality: z.string().nullable(),
              region: z.string().nullable(),
              postcode: z.string().nullable(),
              country_code: z
                .union([
                  z.literal('AF'),
                  z.literal('AX'),
                  z.literal('AL'),
                  z.literal('DZ'),
                  z.literal('AS'),
                  z.literal('AD'),
                  z.literal('AO'),
                  z.literal('AI'),
                  z.literal('AQ'),
                  z.literal('AG'),
                  z.literal('AR'),
                  z.literal('AM'),
                  z.literal('AW'),
                  z.literal('AU'),
                  z.literal('AT'),
                  z.literal('AZ'),
                  z.literal('BS'),
                  z.literal('BH'),
                  z.literal('BD'),
                  z.literal('BB'),
                  z.literal('BY'),
                  z.literal('BE'),
                  z.literal('BZ'),
                  z.literal('BJ'),
                  z.literal('BM'),
                  z.literal('BT'),
                  z.literal('BO'),
                  z.literal('BA'),
                  z.literal('BW'),
                  z.literal('BV'),
                  z.literal('BR'),
                  z.literal('IO'),
                  z.literal('BN'),
                  z.literal('BG'),
                  z.literal('BF'),
                  z.literal('BI'),
                  z.literal('KH'),
                  z.literal('CM'),
                  z.literal('CA'),
                  z.literal('CV'),
                  z.literal('KY'),
                  z.literal('CF'),
                  z.literal('TD'),
                  z.literal('CL'),
                  z.literal('CN'),
                  z.literal('CX'),
                  z.literal('CC'),
                  z.literal('CO'),
                  z.literal('KM'),
                  z.literal('CG'),
                  z.literal('CD'),
                  z.literal('CK'),
                  z.literal('CR'),
                  z.literal('CI'),
                  z.literal('HR'),
                  z.literal('CU'),
                  z.literal('CW'),
                  z.literal('CY'),
                  z.literal('CZ'),
                  z.literal('DK'),
                  z.literal('DJ'),
                  z.literal('DM'),
                  z.literal('DO'),
                  z.literal('EC'),
                  z.literal('EG'),
                  z.literal('SV'),
                  z.literal('GQ'),
                  z.literal('ER'),
                  z.literal('EE'),
                  z.literal('ET'),
                  z.literal('FK'),
                  z.literal('FO'),
                  z.literal('FJ'),
                  z.literal('FI'),
                  z.literal('FR'),
                  z.literal('GF'),
                  z.literal('PF'),
                  z.literal('TF'),
                  z.literal('GA'),
                  z.literal('GM'),
                  z.literal('GE'),
                  z.literal('DE'),
                  z.literal('GH'),
                  z.literal('GI'),
                  z.literal('GR'),
                  z.literal('GL'),
                  z.literal('GD'),
                  z.literal('GP'),
                  z.literal('GU'),
                  z.literal('GT'),
                  z.literal('GG'),
                  z.literal('GN'),
                  z.literal('GW'),
                  z.literal('GY'),
                  z.literal('HT'),
                  z.literal('HM'),
                  z.literal('VA'),
                  z.literal('HN'),
                  z.literal('HK'),
                  z.literal('HU'),
                  z.literal('IS'),
                  z.literal('IN'),
                  z.literal('ID'),
                  z.literal('IR'),
                  z.literal('IQ'),
                  z.literal('IE'),
                  z.literal('IM'),
                  z.literal('IL'),
                  z.literal('IT'),
                  z.literal('JM'),
                  z.literal('JP'),
                  z.literal('JE'),
                  z.literal('JO'),
                  z.literal('KZ'),
                  z.literal('KE'),
                  z.literal('KI'),
                  z.literal('KR'),
                  z.literal('KW'),
                  z.literal('KG'),
                  z.literal('LA'),
                  z.literal('LV'),
                  z.literal('LB'),
                  z.literal('LS'),
                  z.literal('LR'),
                  z.literal('LY'),
                  z.literal('LI'),
                  z.literal('LT'),
                  z.literal('LU'),
                  z.literal('MO'),
                  z.literal('MK'),
                  z.literal('MG'),
                  z.literal('MW'),
                  z.literal('MY'),
                  z.literal('MV'),
                  z.literal('ML'),
                  z.literal('MT'),
                  z.literal('MH'),
                  z.literal('MQ'),
                  z.literal('MR'),
                  z.literal('MU'),
                  z.literal('YT'),
                  z.literal('MX'),
                  z.literal('FM'),
                  z.literal('MD'),
                  z.literal('MC'),
                  z.literal('MN'),
                  z.literal('ME'),
                  z.literal('MS'),
                  z.literal('MA'),
                  z.literal('MZ'),
                  z.literal('MM'),
                  z.literal('NA'),
                  z.literal('NR'),
                  z.literal('NP'),
                  z.literal('NL'),
                  z.literal('AN'),
                  z.literal('NC'),
                  z.literal('NZ'),
                  z.literal('NI'),
                  z.literal('NE'),
                  z.literal('NG'),
                  z.literal('NU'),
                  z.literal('NF'),
                  z.literal('MP'),
                  z.literal('NO'),
                  z.literal('OM'),
                  z.literal('PK'),
                  z.literal('PW'),
                  z.literal('PS'),
                  z.literal('PA'),
                  z.literal('PG'),
                  z.literal('PY'),
                  z.literal('PE'),
                  z.literal('PH'),
                  z.literal('PN'),
                  z.literal('PL'),
                  z.literal('PT'),
                  z.literal('PR'),
                  z.literal('QA'),
                  z.literal('RE'),
                  z.literal('RO'),
                  z.literal('RU'),
                  z.literal('RW'),
                  z.literal('BL'),
                  z.literal('SH'),
                  z.literal('KN'),
                  z.literal('LC'),
                  z.literal('MF'),
                  z.literal('PM'),
                  z.literal('VC'),
                  z.literal('WS'),
                  z.literal('SM'),
                  z.literal('ST'),
                  z.literal('SA'),
                  z.literal('SN'),
                  z.literal('RS'),
                  z.literal('SC'),
                  z.literal('SL'),
                  z.literal('SG'),
                  z.literal('SK'),
                  z.literal('SI'),
                  z.literal('SB'),
                  z.literal('SO'),
                  z.literal('ZA'),
                  z.literal('GS'),
                  z.literal('ES'),
                  z.literal('LK'),
                  z.literal('SD'),
                  z.literal('SR'),
                  z.literal('SJ'),
                  z.literal('SZ'),
                  z.literal('SE'),
                  z.literal('CH'),
                  z.literal('SY'),
                  z.literal('TW'),
                  z.literal('TJ'),
                  z.literal('TZ'),
                  z.literal('TH'),
                  z.literal('TL'),
                  z.literal('TG'),
                  z.literal('TK'),
                  z.literal('TO'),
                  z.literal('TT'),
                  z.literal('TN'),
                  z.literal('TR'),
                  z.literal('TM'),
                  z.literal('TC'),
                  z.literal('TV'),
                  z.literal('UG'),
                  z.literal('UA'),
                  z.literal('AE'),
                  z.literal('GB'),
                  z.literal('US'),
                  z.literal('UM'),
                  z.literal('UY'),
                  z.literal('UZ'),
                  z.literal('VU'),
                  z.literal('VE'),
                  z.literal('VN'),
                  z.literal('VG'),
                  z.literal('VI'),
                  z.literal('WF'),
                  z.literal('EH'),
                  z.literal('YE'),
                  z.literal('ZM'),
                  z.literal('ZW'),
                ])
                .nullable(),
              latitude: z.string().nullable(),
              longitude: z.string().nullable(),
              attribute_type: z.literal('location'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.number(),
              attribute_type: z.literal('number'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              first_name: z.string(),
              last_name: z.string(),
              full_name: z.string(),
              attribute_type: z.literal('personal-name'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              original_phone_number: z.string(),
              country_code: z.union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ]),
              phone_number: z.string(),
              attribute_type: z.literal('phone-number'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              status: statusSchema,
              attribute_type: z.literal('status'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.number(),
              attribute_type: z.literal('rating'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              option: selectOptionSchema,
              attribute_type: z.literal('select'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.string(),
              attribute_type: z.literal('text'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('timestamp'),
              value: z.string(),
            }),
          ]),
        ),
      ),
    }),
  ),
});

export const postV2ObjectsByObjectRecordsQueryErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('filter_error'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const postV2ObjectsByObjectRecordsDataSchema = z.object({
  body: z.object({
    data: z.object({
      values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    object: z.string(),
  }),
});

export const postV2ObjectsByObjectRecordsResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      object_id: z.string(),
      record_id: z.string(),
    }),
    created_at: z.string(),
    values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const postV2ObjectsByObjectRecordsErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const putV2ObjectsByObjectRecordsDataSchema = z.object({
  body: z.object({
    data: z.object({
      values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    object: z.string(),
  }),
  query: z.object({
    matching_attribute: z.string(),
  }),
});

export const putV2ObjectsByObjectRecordsResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      object_id: z.string(),
      record_id: z.string(),
    }),
    created_at: z.string(),
    values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const putV2ObjectsByObjectRecordsErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2ObjectsByObjectRecordsByRecordIdDataSchema = z.object({
  path: z.object({
    object: z.string(),
    record_id: z.string(),
  }),
});

export const getV2ObjectsByObjectRecordsByRecordIdResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      object_id: z.string(),
      record_id: z.string(),
    }),
    created_at: z.string(),
    values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const getV2ObjectsByObjectRecordsByRecordIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2ObjectsByObjectRecordsByRecordIdDataSchema = z.object({
  body: z.object({
    data: z.object({
      values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    object: z.string(),
    record_id: z.string(),
  }),
});

export const patchV2ObjectsByObjectRecordsByRecordIdResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      object_id: z.string(),
      record_id: z.string(),
    }),
    created_at: z.string(),
    values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const patchV2ObjectsByObjectRecordsByRecordIdErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('missing_value'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const deleteV2ObjectsByObjectRecordsByRecordIdDataSchema = z.object({
  path: z.object({
    object: z.string(),
    record_id: z.string(),
  }),
});

export const deleteV2ObjectsByObjectRecordsByRecordIdResponseSchema = z.record(z.unknown());

export const deleteV2ObjectsByObjectRecordsByRecordIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesDataSchema = z.object({
  path: z.object({
    attribute: z.string(),
    object: z.string(),
    record_id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      show_historic: z.boolean().optional(),
    })
    .optional(),
});

export const getV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesResponseSchema = z.object({
  data: z.array(
    z.union([
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        referenced_actor_type: z.union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')]),
        referenced_actor_id: z.string().nullable(),
        attribute_type: z.literal('actor-reference'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.boolean(),
        attribute_type: z.literal('checkbox'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        currency_value: z.number(),
        currency_code: z
          .union([
            z.literal('EUR'),
            z.literal('GBP'),
            z.literal('USD'),
            z.literal('CAD'),
            z.literal('AUD'),
            z.literal('NZD'),
            z.literal('AED'),
            z.literal('INR'),
            z.literal('CHF'),
            z.literal('JPY'),
            z.literal('CNY'),
            z.literal('PHP'),
            z.literal('ILS'),
            z.literal('SGD'),
            z.literal('HKD'),
            z.literal('MYR'),
            z.literal('NTD'),
            z.literal('NOK'),
            z.literal('SEK'),
            z.literal('ISK'),
            z.literal('BEL'),
            z.literal('PLN'),
            z.literal('KRW'),
            z.literal('DKK'),
            z.literal('BRL'),
          ])
          .optional()
          .nullable(),
        attribute_type: z.literal('currency'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('date'),
        value: z.string(),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        domain: z.string(),
        root_domain: z.string(),
        attribute_type: z.literal('domain'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        original_email_address: z.string(),
        email_address: z.string(),
        email_domain: z.string(),
        email_root_domain: z.string(),
        email_local_specifier: z.string(),
        attribute_type: z.literal('email-address'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        target_object: z.string(),
        target_record_id: z.string(),
        attribute_type: z.literal('record-reference'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        interaction_type: z.union([
          z.literal('calendar-event'),
          z.literal('call'),
          z.literal('chat-thread'),
          z.literal('email'),
          z.literal('in-person-meeting'),
        ]),
        interacted_at: z.string(),
        owner_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('interaction'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        line_1: z.string().nullable(),
        line_2: z.string().nullable(),
        line_3: z.string().nullable(),
        line_4: z.string().nullable(),
        locality: z.string().nullable(),
        region: z.string().nullable(),
        postcode: z.string().nullable(),
        country_code: z
          .union([
            z.literal('AF'),
            z.literal('AX'),
            z.literal('AL'),
            z.literal('DZ'),
            z.literal('AS'),
            z.literal('AD'),
            z.literal('AO'),
            z.literal('AI'),
            z.literal('AQ'),
            z.literal('AG'),
            z.literal('AR'),
            z.literal('AM'),
            z.literal('AW'),
            z.literal('AU'),
            z.literal('AT'),
            z.literal('AZ'),
            z.literal('BS'),
            z.literal('BH'),
            z.literal('BD'),
            z.literal('BB'),
            z.literal('BY'),
            z.literal('BE'),
            z.literal('BZ'),
            z.literal('BJ'),
            z.literal('BM'),
            z.literal('BT'),
            z.literal('BO'),
            z.literal('BA'),
            z.literal('BW'),
            z.literal('BV'),
            z.literal('BR'),
            z.literal('IO'),
            z.literal('BN'),
            z.literal('BG'),
            z.literal('BF'),
            z.literal('BI'),
            z.literal('KH'),
            z.literal('CM'),
            z.literal('CA'),
            z.literal('CV'),
            z.literal('KY'),
            z.literal('CF'),
            z.literal('TD'),
            z.literal('CL'),
            z.literal('CN'),
            z.literal('CX'),
            z.literal('CC'),
            z.literal('CO'),
            z.literal('KM'),
            z.literal('CG'),
            z.literal('CD'),
            z.literal('CK'),
            z.literal('CR'),
            z.literal('CI'),
            z.literal('HR'),
            z.literal('CU'),
            z.literal('CW'),
            z.literal('CY'),
            z.literal('CZ'),
            z.literal('DK'),
            z.literal('DJ'),
            z.literal('DM'),
            z.literal('DO'),
            z.literal('EC'),
            z.literal('EG'),
            z.literal('SV'),
            z.literal('GQ'),
            z.literal('ER'),
            z.literal('EE'),
            z.literal('ET'),
            z.literal('FK'),
            z.literal('FO'),
            z.literal('FJ'),
            z.literal('FI'),
            z.literal('FR'),
            z.literal('GF'),
            z.literal('PF'),
            z.literal('TF'),
            z.literal('GA'),
            z.literal('GM'),
            z.literal('GE'),
            z.literal('DE'),
            z.literal('GH'),
            z.literal('GI'),
            z.literal('GR'),
            z.literal('GL'),
            z.literal('GD'),
            z.literal('GP'),
            z.literal('GU'),
            z.literal('GT'),
            z.literal('GG'),
            z.literal('GN'),
            z.literal('GW'),
            z.literal('GY'),
            z.literal('HT'),
            z.literal('HM'),
            z.literal('VA'),
            z.literal('HN'),
            z.literal('HK'),
            z.literal('HU'),
            z.literal('IS'),
            z.literal('IN'),
            z.literal('ID'),
            z.literal('IR'),
            z.literal('IQ'),
            z.literal('IE'),
            z.literal('IM'),
            z.literal('IL'),
            z.literal('IT'),
            z.literal('JM'),
            z.literal('JP'),
            z.literal('JE'),
            z.literal('JO'),
            z.literal('KZ'),
            z.literal('KE'),
            z.literal('KI'),
            z.literal('KR'),
            z.literal('KW'),
            z.literal('KG'),
            z.literal('LA'),
            z.literal('LV'),
            z.literal('LB'),
            z.literal('LS'),
            z.literal('LR'),
            z.literal('LY'),
            z.literal('LI'),
            z.literal('LT'),
            z.literal('LU'),
            z.literal('MO'),
            z.literal('MK'),
            z.literal('MG'),
            z.literal('MW'),
            z.literal('MY'),
            z.literal('MV'),
            z.literal('ML'),
            z.literal('MT'),
            z.literal('MH'),
            z.literal('MQ'),
            z.literal('MR'),
            z.literal('MU'),
            z.literal('YT'),
            z.literal('MX'),
            z.literal('FM'),
            z.literal('MD'),
            z.literal('MC'),
            z.literal('MN'),
            z.literal('ME'),
            z.literal('MS'),
            z.literal('MA'),
            z.literal('MZ'),
            z.literal('MM'),
            z.literal('NA'),
            z.literal('NR'),
            z.literal('NP'),
            z.literal('NL'),
            z.literal('AN'),
            z.literal('NC'),
            z.literal('NZ'),
            z.literal('NI'),
            z.literal('NE'),
            z.literal('NG'),
            z.literal('NU'),
            z.literal('NF'),
            z.literal('MP'),
            z.literal('NO'),
            z.literal('OM'),
            z.literal('PK'),
            z.literal('PW'),
            z.literal('PS'),
            z.literal('PA'),
            z.literal('PG'),
            z.literal('PY'),
            z.literal('PE'),
            z.literal('PH'),
            z.literal('PN'),
            z.literal('PL'),
            z.literal('PT'),
            z.literal('PR'),
            z.literal('QA'),
            z.literal('RE'),
            z.literal('RO'),
            z.literal('RU'),
            z.literal('RW'),
            z.literal('BL'),
            z.literal('SH'),
            z.literal('KN'),
            z.literal('LC'),
            z.literal('MF'),
            z.literal('PM'),
            z.literal('VC'),
            z.literal('WS'),
            z.literal('SM'),
            z.literal('ST'),
            z.literal('SA'),
            z.literal('SN'),
            z.literal('RS'),
            z.literal('SC'),
            z.literal('SL'),
            z.literal('SG'),
            z.literal('SK'),
            z.literal('SI'),
            z.literal('SB'),
            z.literal('SO'),
            z.literal('ZA'),
            z.literal('GS'),
            z.literal('ES'),
            z.literal('LK'),
            z.literal('SD'),
            z.literal('SR'),
            z.literal('SJ'),
            z.literal('SZ'),
            z.literal('SE'),
            z.literal('CH'),
            z.literal('SY'),
            z.literal('TW'),
            z.literal('TJ'),
            z.literal('TZ'),
            z.literal('TH'),
            z.literal('TL'),
            z.literal('TG'),
            z.literal('TK'),
            z.literal('TO'),
            z.literal('TT'),
            z.literal('TN'),
            z.literal('TR'),
            z.literal('TM'),
            z.literal('TC'),
            z.literal('TV'),
            z.literal('UG'),
            z.literal('UA'),
            z.literal('AE'),
            z.literal('GB'),
            z.literal('US'),
            z.literal('UM'),
            z.literal('UY'),
            z.literal('UZ'),
            z.literal('VU'),
            z.literal('VE'),
            z.literal('VN'),
            z.literal('VG'),
            z.literal('VI'),
            z.literal('WF'),
            z.literal('EH'),
            z.literal('YE'),
            z.literal('ZM'),
            z.literal('ZW'),
          ])
          .nullable(),
        latitude: z.string().nullable(),
        longitude: z.string().nullable(),
        attribute_type: z.literal('location'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.number(),
        attribute_type: z.literal('number'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        first_name: z.string(),
        last_name: z.string(),
        full_name: z.string(),
        attribute_type: z.literal('personal-name'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        original_phone_number: z.string(),
        country_code: z.union([
          z.literal('AF'),
          z.literal('AX'),
          z.literal('AL'),
          z.literal('DZ'),
          z.literal('AS'),
          z.literal('AD'),
          z.literal('AO'),
          z.literal('AI'),
          z.literal('AQ'),
          z.literal('AG'),
          z.literal('AR'),
          z.literal('AM'),
          z.literal('AW'),
          z.literal('AU'),
          z.literal('AT'),
          z.literal('AZ'),
          z.literal('BS'),
          z.literal('BH'),
          z.literal('BD'),
          z.literal('BB'),
          z.literal('BY'),
          z.literal('BE'),
          z.literal('BZ'),
          z.literal('BJ'),
          z.literal('BM'),
          z.literal('BT'),
          z.literal('BO'),
          z.literal('BA'),
          z.literal('BW'),
          z.literal('BV'),
          z.literal('BR'),
          z.literal('IO'),
          z.literal('BN'),
          z.literal('BG'),
          z.literal('BF'),
          z.literal('BI'),
          z.literal('KH'),
          z.literal('CM'),
          z.literal('CA'),
          z.literal('CV'),
          z.literal('KY'),
          z.literal('CF'),
          z.literal('TD'),
          z.literal('CL'),
          z.literal('CN'),
          z.literal('CX'),
          z.literal('CC'),
          z.literal('CO'),
          z.literal('KM'),
          z.literal('CG'),
          z.literal('CD'),
          z.literal('CK'),
          z.literal('CR'),
          z.literal('CI'),
          z.literal('HR'),
          z.literal('CU'),
          z.literal('CW'),
          z.literal('CY'),
          z.literal('CZ'),
          z.literal('DK'),
          z.literal('DJ'),
          z.literal('DM'),
          z.literal('DO'),
          z.literal('EC'),
          z.literal('EG'),
          z.literal('SV'),
          z.literal('GQ'),
          z.literal('ER'),
          z.literal('EE'),
          z.literal('ET'),
          z.literal('FK'),
          z.literal('FO'),
          z.literal('FJ'),
          z.literal('FI'),
          z.literal('FR'),
          z.literal('GF'),
          z.literal('PF'),
          z.literal('TF'),
          z.literal('GA'),
          z.literal('GM'),
          z.literal('GE'),
          z.literal('DE'),
          z.literal('GH'),
          z.literal('GI'),
          z.literal('GR'),
          z.literal('GL'),
          z.literal('GD'),
          z.literal('GP'),
          z.literal('GU'),
          z.literal('GT'),
          z.literal('GG'),
          z.literal('GN'),
          z.literal('GW'),
          z.literal('GY'),
          z.literal('HT'),
          z.literal('HM'),
          z.literal('VA'),
          z.literal('HN'),
          z.literal('HK'),
          z.literal('HU'),
          z.literal('IS'),
          z.literal('IN'),
          z.literal('ID'),
          z.literal('IR'),
          z.literal('IQ'),
          z.literal('IE'),
          z.literal('IM'),
          z.literal('IL'),
          z.literal('IT'),
          z.literal('JM'),
          z.literal('JP'),
          z.literal('JE'),
          z.literal('JO'),
          z.literal('KZ'),
          z.literal('KE'),
          z.literal('KI'),
          z.literal('KR'),
          z.literal('KW'),
          z.literal('KG'),
          z.literal('LA'),
          z.literal('LV'),
          z.literal('LB'),
          z.literal('LS'),
          z.literal('LR'),
          z.literal('LY'),
          z.literal('LI'),
          z.literal('LT'),
          z.literal('LU'),
          z.literal('MO'),
          z.literal('MK'),
          z.literal('MG'),
          z.literal('MW'),
          z.literal('MY'),
          z.literal('MV'),
          z.literal('ML'),
          z.literal('MT'),
          z.literal('MH'),
          z.literal('MQ'),
          z.literal('MR'),
          z.literal('MU'),
          z.literal('YT'),
          z.literal('MX'),
          z.literal('FM'),
          z.literal('MD'),
          z.literal('MC'),
          z.literal('MN'),
          z.literal('ME'),
          z.literal('MS'),
          z.literal('MA'),
          z.literal('MZ'),
          z.literal('MM'),
          z.literal('NA'),
          z.literal('NR'),
          z.literal('NP'),
          z.literal('NL'),
          z.literal('AN'),
          z.literal('NC'),
          z.literal('NZ'),
          z.literal('NI'),
          z.literal('NE'),
          z.literal('NG'),
          z.literal('NU'),
          z.literal('NF'),
          z.literal('MP'),
          z.literal('NO'),
          z.literal('OM'),
          z.literal('PK'),
          z.literal('PW'),
          z.literal('PS'),
          z.literal('PA'),
          z.literal('PG'),
          z.literal('PY'),
          z.literal('PE'),
          z.literal('PH'),
          z.literal('PN'),
          z.literal('PL'),
          z.literal('PT'),
          z.literal('PR'),
          z.literal('QA'),
          z.literal('RE'),
          z.literal('RO'),
          z.literal('RU'),
          z.literal('RW'),
          z.literal('BL'),
          z.literal('SH'),
          z.literal('KN'),
          z.literal('LC'),
          z.literal('MF'),
          z.literal('PM'),
          z.literal('VC'),
          z.literal('WS'),
          z.literal('SM'),
          z.literal('ST'),
          z.literal('SA'),
          z.literal('SN'),
          z.literal('RS'),
          z.literal('SC'),
          z.literal('SL'),
          z.literal('SG'),
          z.literal('SK'),
          z.literal('SI'),
          z.literal('SB'),
          z.literal('SO'),
          z.literal('ZA'),
          z.literal('GS'),
          z.literal('ES'),
          z.literal('LK'),
          z.literal('SD'),
          z.literal('SR'),
          z.literal('SJ'),
          z.literal('SZ'),
          z.literal('SE'),
          z.literal('CH'),
          z.literal('SY'),
          z.literal('TW'),
          z.literal('TJ'),
          z.literal('TZ'),
          z.literal('TH'),
          z.literal('TL'),
          z.literal('TG'),
          z.literal('TK'),
          z.literal('TO'),
          z.literal('TT'),
          z.literal('TN'),
          z.literal('TR'),
          z.literal('TM'),
          z.literal('TC'),
          z.literal('TV'),
          z.literal('UG'),
          z.literal('UA'),
          z.literal('AE'),
          z.literal('GB'),
          z.literal('US'),
          z.literal('UM'),
          z.literal('UY'),
          z.literal('UZ'),
          z.literal('VU'),
          z.literal('VE'),
          z.literal('VN'),
          z.literal('VG'),
          z.literal('VI'),
          z.literal('WF'),
          z.literal('EH'),
          z.literal('YE'),
          z.literal('ZM'),
          z.literal('ZW'),
        ]),
        phone_number: z.string(),
        attribute_type: z.literal('phone-number'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        status: statusSchema,
        attribute_type: z.literal('status'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.number(),
        attribute_type: z.literal('rating'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        option: selectOptionSchema,
        attribute_type: z.literal('select'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.string(),
        attribute_type: z.literal('text'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('timestamp'),
        value: z.string(),
      }),
    ]),
  ),
});

export const getV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2ObjectsByObjectRecordsByRecordIdEntriesDataSchema = z.object({
  path: z.object({
    object: z.string(),
    record_id: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getV2ObjectsByObjectRecordsByRecordIdEntriesResponseSchema = z.object({
  data: z.array(
    z.object({
      list_id: z.string(),
      list_api_slug: z.string(),
      entry_id: z.string(),
      created_at: z.string(),
    }),
  ),
});

export const getV2ObjectsByObjectRecordsByRecordIdEntriesErrorSchema = z.unknown();

export const getV2ListsResponseSchema = z.object({
  data: z.array(listSchema),
});

export const getV2ListsErrorSchema = z.unknown();

export const postV2ListsDataSchema = z.object({
  body: z.object({
    data: z.object({
      name: z.string(),
      api_slug: z.string(),
      parent_object: z.string(),
      workspace_access: z
        .union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')])
        .nullable(),
      workspace_member_access: z.array(
        z.object({
          workspace_member_id: z.string(),
          level: z.union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')]),
        }),
      ),
    }),
  }),
});

export const postV2ListsResponseSchema = z.object({
  data: listSchema,
});

export const postV2ListsErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(403),
    type: z.literal('auth_error'),
    code: z.literal('billing_error'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2ListsByListDataSchema = z.object({
  path: z.object({
    list: z.string(),
  }),
});

export const getV2ListsByListResponseSchema = z.object({
  data: listSchema,
});

export const getV2ListsByListErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2ListsByListDataSchema = z.object({
  body: z.object({
    data: z.object({
      name: z.string().optional(),
      api_slug: z.string().optional(),
      workspace_access: z
        .union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')])
        .optional()
        .nullable(),
      workspace_member_access: z
        .array(
          z.object({
            workspace_member_id: z.string(),
            level: z.union([z.literal('full-access'), z.literal('read-and-write'), z.literal('read-only')]),
          }),
        )
        .optional(),
    }),
  }),
  path: z.object({
    list: z.string(),
  }),
});

export const patchV2ListsByListResponseSchema = z.object({
  data: listSchema,
});

export const patchV2ListsByListErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const postV2ListsByListEntriesQueryDataSchema = z.object({
  body: z.object({
    filter: z.record(z.unknown()).optional(),
    sorts: z
      .array(
        z.union([
          z.object({
            direction: z.union([z.literal('asc'), z.literal('desc')]),
            attribute: z.string(),
            field: z.string().optional(),
          }),
          z.object({
            direction: z.union([z.literal('asc'), z.literal('desc')]),
            path: z.array(z.tuple([z.string(), z.string()])),
            field: z.string().optional(),
          }),
        ]),
      )
      .optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
  }),
  path: z.object({
    list: z.string(),
  }),
});

export const postV2ListsByListEntriesQueryResponseSchema = z.object({
  data: z.array(
    z.object({
      id: z.object({
        workspace_id: z.string(),
        list_id: z.string(),
        entry_id: z.string(),
      }),
      parent_record_id: z.string(),
      parent_object: z.string(),
      created_at: z.string(),
      entry_values: z.record(
        z.array(
          z.union([
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              referenced_actor_type: z.union([
                z.literal('api-token'),
                z.literal('workspace-member'),
                z.literal('system'),
              ]),
              referenced_actor_id: z.string().nullable(),
              attribute_type: z.literal('actor-reference'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.boolean(),
              attribute_type: z.literal('checkbox'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              currency_value: z.number(),
              currency_code: z
                .union([
                  z.literal('EUR'),
                  z.literal('GBP'),
                  z.literal('USD'),
                  z.literal('CAD'),
                  z.literal('AUD'),
                  z.literal('NZD'),
                  z.literal('AED'),
                  z.literal('INR'),
                  z.literal('CHF'),
                  z.literal('JPY'),
                  z.literal('CNY'),
                  z.literal('PHP'),
                  z.literal('ILS'),
                  z.literal('SGD'),
                  z.literal('HKD'),
                  z.literal('MYR'),
                  z.literal('NTD'),
                  z.literal('NOK'),
                  z.literal('SEK'),
                  z.literal('ISK'),
                  z.literal('BEL'),
                  z.literal('PLN'),
                  z.literal('KRW'),
                  z.literal('DKK'),
                  z.literal('BRL'),
                ])
                .optional()
                .nullable(),
              attribute_type: z.literal('currency'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('date'),
              value: z.string(),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              domain: z.string(),
              root_domain: z.string(),
              attribute_type: z.literal('domain'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              original_email_address: z.string(),
              email_address: z.string(),
              email_domain: z.string(),
              email_root_domain: z.string(),
              email_local_specifier: z.string(),
              attribute_type: z.literal('email-address'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              target_object: z.string(),
              target_record_id: z.string(),
              attribute_type: z.literal('record-reference'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              interaction_type: z.union([
                z.literal('calendar-event'),
                z.literal('call'),
                z.literal('chat-thread'),
                z.literal('email'),
                z.literal('in-person-meeting'),
              ]),
              interacted_at: z.string(),
              owner_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('interaction'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              line_1: z.string().nullable(),
              line_2: z.string().nullable(),
              line_3: z.string().nullable(),
              line_4: z.string().nullable(),
              locality: z.string().nullable(),
              region: z.string().nullable(),
              postcode: z.string().nullable(),
              country_code: z
                .union([
                  z.literal('AF'),
                  z.literal('AX'),
                  z.literal('AL'),
                  z.literal('DZ'),
                  z.literal('AS'),
                  z.literal('AD'),
                  z.literal('AO'),
                  z.literal('AI'),
                  z.literal('AQ'),
                  z.literal('AG'),
                  z.literal('AR'),
                  z.literal('AM'),
                  z.literal('AW'),
                  z.literal('AU'),
                  z.literal('AT'),
                  z.literal('AZ'),
                  z.literal('BS'),
                  z.literal('BH'),
                  z.literal('BD'),
                  z.literal('BB'),
                  z.literal('BY'),
                  z.literal('BE'),
                  z.literal('BZ'),
                  z.literal('BJ'),
                  z.literal('BM'),
                  z.literal('BT'),
                  z.literal('BO'),
                  z.literal('BA'),
                  z.literal('BW'),
                  z.literal('BV'),
                  z.literal('BR'),
                  z.literal('IO'),
                  z.literal('BN'),
                  z.literal('BG'),
                  z.literal('BF'),
                  z.literal('BI'),
                  z.literal('KH'),
                  z.literal('CM'),
                  z.literal('CA'),
                  z.literal('CV'),
                  z.literal('KY'),
                  z.literal('CF'),
                  z.literal('TD'),
                  z.literal('CL'),
                  z.literal('CN'),
                  z.literal('CX'),
                  z.literal('CC'),
                  z.literal('CO'),
                  z.literal('KM'),
                  z.literal('CG'),
                  z.literal('CD'),
                  z.literal('CK'),
                  z.literal('CR'),
                  z.literal('CI'),
                  z.literal('HR'),
                  z.literal('CU'),
                  z.literal('CW'),
                  z.literal('CY'),
                  z.literal('CZ'),
                  z.literal('DK'),
                  z.literal('DJ'),
                  z.literal('DM'),
                  z.literal('DO'),
                  z.literal('EC'),
                  z.literal('EG'),
                  z.literal('SV'),
                  z.literal('GQ'),
                  z.literal('ER'),
                  z.literal('EE'),
                  z.literal('ET'),
                  z.literal('FK'),
                  z.literal('FO'),
                  z.literal('FJ'),
                  z.literal('FI'),
                  z.literal('FR'),
                  z.literal('GF'),
                  z.literal('PF'),
                  z.literal('TF'),
                  z.literal('GA'),
                  z.literal('GM'),
                  z.literal('GE'),
                  z.literal('DE'),
                  z.literal('GH'),
                  z.literal('GI'),
                  z.literal('GR'),
                  z.literal('GL'),
                  z.literal('GD'),
                  z.literal('GP'),
                  z.literal('GU'),
                  z.literal('GT'),
                  z.literal('GG'),
                  z.literal('GN'),
                  z.literal('GW'),
                  z.literal('GY'),
                  z.literal('HT'),
                  z.literal('HM'),
                  z.literal('VA'),
                  z.literal('HN'),
                  z.literal('HK'),
                  z.literal('HU'),
                  z.literal('IS'),
                  z.literal('IN'),
                  z.literal('ID'),
                  z.literal('IR'),
                  z.literal('IQ'),
                  z.literal('IE'),
                  z.literal('IM'),
                  z.literal('IL'),
                  z.literal('IT'),
                  z.literal('JM'),
                  z.literal('JP'),
                  z.literal('JE'),
                  z.literal('JO'),
                  z.literal('KZ'),
                  z.literal('KE'),
                  z.literal('KI'),
                  z.literal('KR'),
                  z.literal('KW'),
                  z.literal('KG'),
                  z.literal('LA'),
                  z.literal('LV'),
                  z.literal('LB'),
                  z.literal('LS'),
                  z.literal('LR'),
                  z.literal('LY'),
                  z.literal('LI'),
                  z.literal('LT'),
                  z.literal('LU'),
                  z.literal('MO'),
                  z.literal('MK'),
                  z.literal('MG'),
                  z.literal('MW'),
                  z.literal('MY'),
                  z.literal('MV'),
                  z.literal('ML'),
                  z.literal('MT'),
                  z.literal('MH'),
                  z.literal('MQ'),
                  z.literal('MR'),
                  z.literal('MU'),
                  z.literal('YT'),
                  z.literal('MX'),
                  z.literal('FM'),
                  z.literal('MD'),
                  z.literal('MC'),
                  z.literal('MN'),
                  z.literal('ME'),
                  z.literal('MS'),
                  z.literal('MA'),
                  z.literal('MZ'),
                  z.literal('MM'),
                  z.literal('NA'),
                  z.literal('NR'),
                  z.literal('NP'),
                  z.literal('NL'),
                  z.literal('AN'),
                  z.literal('NC'),
                  z.literal('NZ'),
                  z.literal('NI'),
                  z.literal('NE'),
                  z.literal('NG'),
                  z.literal('NU'),
                  z.literal('NF'),
                  z.literal('MP'),
                  z.literal('NO'),
                  z.literal('OM'),
                  z.literal('PK'),
                  z.literal('PW'),
                  z.literal('PS'),
                  z.literal('PA'),
                  z.literal('PG'),
                  z.literal('PY'),
                  z.literal('PE'),
                  z.literal('PH'),
                  z.literal('PN'),
                  z.literal('PL'),
                  z.literal('PT'),
                  z.literal('PR'),
                  z.literal('QA'),
                  z.literal('RE'),
                  z.literal('RO'),
                  z.literal('RU'),
                  z.literal('RW'),
                  z.literal('BL'),
                  z.literal('SH'),
                  z.literal('KN'),
                  z.literal('LC'),
                  z.literal('MF'),
                  z.literal('PM'),
                  z.literal('VC'),
                  z.literal('WS'),
                  z.literal('SM'),
                  z.literal('ST'),
                  z.literal('SA'),
                  z.literal('SN'),
                  z.literal('RS'),
                  z.literal('SC'),
                  z.literal('SL'),
                  z.literal('SG'),
                  z.literal('SK'),
                  z.literal('SI'),
                  z.literal('SB'),
                  z.literal('SO'),
                  z.literal('ZA'),
                  z.literal('GS'),
                  z.literal('ES'),
                  z.literal('LK'),
                  z.literal('SD'),
                  z.literal('SR'),
                  z.literal('SJ'),
                  z.literal('SZ'),
                  z.literal('SE'),
                  z.literal('CH'),
                  z.literal('SY'),
                  z.literal('TW'),
                  z.literal('TJ'),
                  z.literal('TZ'),
                  z.literal('TH'),
                  z.literal('TL'),
                  z.literal('TG'),
                  z.literal('TK'),
                  z.literal('TO'),
                  z.literal('TT'),
                  z.literal('TN'),
                  z.literal('TR'),
                  z.literal('TM'),
                  z.literal('TC'),
                  z.literal('TV'),
                  z.literal('UG'),
                  z.literal('UA'),
                  z.literal('AE'),
                  z.literal('GB'),
                  z.literal('US'),
                  z.literal('UM'),
                  z.literal('UY'),
                  z.literal('UZ'),
                  z.literal('VU'),
                  z.literal('VE'),
                  z.literal('VN'),
                  z.literal('VG'),
                  z.literal('VI'),
                  z.literal('WF'),
                  z.literal('EH'),
                  z.literal('YE'),
                  z.literal('ZM'),
                  z.literal('ZW'),
                ])
                .nullable(),
              latitude: z.string().nullable(),
              longitude: z.string().nullable(),
              attribute_type: z.literal('location'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.number(),
              attribute_type: z.literal('number'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              first_name: z.string(),
              last_name: z.string(),
              full_name: z.string(),
              attribute_type: z.literal('personal-name'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              original_phone_number: z.string(),
              country_code: z.union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ]),
              phone_number: z.string(),
              attribute_type: z.literal('phone-number'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              status: statusSchema,
              attribute_type: z.literal('status'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.number(),
              attribute_type: z.literal('rating'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              option: selectOptionSchema,
              attribute_type: z.literal('select'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              value: z.string(),
              attribute_type: z.literal('text'),
            }),
            z.object({
              active_from: z.string(),
              active_until: z.string().nullable(),
              created_by_actor: z.object({
                id: z.string().optional().nullable(),
                type: z
                  .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                  .optional()
                  .nullable(),
              }),
              attribute_type: z.literal('timestamp'),
              value: z.string(),
            }),
          ]),
        ),
      ),
    }),
  ),
});

export const postV2ListsByListEntriesQueryErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const postV2ListsByListEntriesDataSchema = z.object({
  body: z.object({
    data: z.object({
      parent_record_id: z.string(),
      parent_object: z.string(),
      entry_values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    list: z.string(),
  }),
});

export const postV2ListsByListEntriesResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      list_id: z.string(),
      entry_id: z.string(),
    }),
    parent_record_id: z.string(),
    parent_object: z.string(),
    created_at: z.string(),
    entry_values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const postV2ListsByListEntriesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('value_not_found'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const putV2ListsByListEntriesDataSchema = z.object({
  body: z.object({
    data: z.object({
      parent_record_id: z.string(),
      parent_object: z.string(),
      entry_values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    list: z.string(),
  }),
});

export const putV2ListsByListEntriesResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      list_id: z.string(),
      entry_id: z.string(),
    }),
    parent_record_id: z.string(),
    parent_object: z.string(),
    created_at: z.string(),
    entry_values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const putV2ListsByListEntriesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('multiple_match_results'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2ListsByListEntriesByEntryIdDataSchema = z.object({
  path: z.object({
    entry_id: z.string(),
    list: z.string(),
  }),
});

export const getV2ListsByListEntriesByEntryIdResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      list_id: z.string(),
      entry_id: z.string(),
    }),
    parent_record_id: z.string(),
    parent_object: z.string(),
    created_at: z.string(),
    entry_values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const getV2ListsByListEntriesByEntryIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2ListsByListEntriesByEntryIdDataSchema = z.object({
  body: z.object({
    data: z.object({
      entry_values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    entry_id: z.string(),
    list: z.string(),
  }),
});

export const patchV2ListsByListEntriesByEntryIdResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      list_id: z.string(),
      entry_id: z.string(),
    }),
    parent_record_id: z.string(),
    parent_object: z.string(),
    created_at: z.string(),
    entry_values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const patchV2ListsByListEntriesByEntryIdErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('immutable_value'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const putV2ListsByListEntriesByEntryIdDataSchema = z.object({
  body: z.object({
    data: z.object({
      entry_values: z.record(z.array(z.unknown())),
    }),
  }),
  path: z.object({
    entry_id: z.string(),
    list: z.string(),
  }),
});

export const putV2ListsByListEntriesByEntryIdResponseSchema = z.object({
  data: z.object({
    id: z.object({
      workspace_id: z.string(),
      list_id: z.string(),
      entry_id: z.string(),
    }),
    parent_record_id: z.string(),
    parent_object: z.string(),
    created_at: z.string(),
    entry_values: z.record(
      z.array(
        z.union([
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            referenced_actor_type: z.union([
              z.literal('api-token'),
              z.literal('workspace-member'),
              z.literal('system'),
            ]),
            referenced_actor_id: z.string().nullable(),
            attribute_type: z.literal('actor-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.boolean(),
            attribute_type: z.literal('checkbox'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            currency_value: z.number(),
            currency_code: z
              .union([
                z.literal('EUR'),
                z.literal('GBP'),
                z.literal('USD'),
                z.literal('CAD'),
                z.literal('AUD'),
                z.literal('NZD'),
                z.literal('AED'),
                z.literal('INR'),
                z.literal('CHF'),
                z.literal('JPY'),
                z.literal('CNY'),
                z.literal('PHP'),
                z.literal('ILS'),
                z.literal('SGD'),
                z.literal('HKD'),
                z.literal('MYR'),
                z.literal('NTD'),
                z.literal('NOK'),
                z.literal('SEK'),
                z.literal('ISK'),
                z.literal('BEL'),
                z.literal('PLN'),
                z.literal('KRW'),
                z.literal('DKK'),
                z.literal('BRL'),
              ])
              .optional()
              .nullable(),
            attribute_type: z.literal('currency'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('date'),
            value: z.string(),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            domain: z.string(),
            root_domain: z.string(),
            attribute_type: z.literal('domain'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_email_address: z.string(),
            email_address: z.string(),
            email_domain: z.string(),
            email_root_domain: z.string(),
            email_local_specifier: z.string(),
            attribute_type: z.literal('email-address'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            target_object: z.string(),
            target_record_id: z.string(),
            attribute_type: z.literal('record-reference'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            interaction_type: z.union([
              z.literal('calendar-event'),
              z.literal('call'),
              z.literal('chat-thread'),
              z.literal('email'),
              z.literal('in-person-meeting'),
            ]),
            interacted_at: z.string(),
            owner_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('interaction'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            line_1: z.string().nullable(),
            line_2: z.string().nullable(),
            line_3: z.string().nullable(),
            line_4: z.string().nullable(),
            locality: z.string().nullable(),
            region: z.string().nullable(),
            postcode: z.string().nullable(),
            country_code: z
              .union([
                z.literal('AF'),
                z.literal('AX'),
                z.literal('AL'),
                z.literal('DZ'),
                z.literal('AS'),
                z.literal('AD'),
                z.literal('AO'),
                z.literal('AI'),
                z.literal('AQ'),
                z.literal('AG'),
                z.literal('AR'),
                z.literal('AM'),
                z.literal('AW'),
                z.literal('AU'),
                z.literal('AT'),
                z.literal('AZ'),
                z.literal('BS'),
                z.literal('BH'),
                z.literal('BD'),
                z.literal('BB'),
                z.literal('BY'),
                z.literal('BE'),
                z.literal('BZ'),
                z.literal('BJ'),
                z.literal('BM'),
                z.literal('BT'),
                z.literal('BO'),
                z.literal('BA'),
                z.literal('BW'),
                z.literal('BV'),
                z.literal('BR'),
                z.literal('IO'),
                z.literal('BN'),
                z.literal('BG'),
                z.literal('BF'),
                z.literal('BI'),
                z.literal('KH'),
                z.literal('CM'),
                z.literal('CA'),
                z.literal('CV'),
                z.literal('KY'),
                z.literal('CF'),
                z.literal('TD'),
                z.literal('CL'),
                z.literal('CN'),
                z.literal('CX'),
                z.literal('CC'),
                z.literal('CO'),
                z.literal('KM'),
                z.literal('CG'),
                z.literal('CD'),
                z.literal('CK'),
                z.literal('CR'),
                z.literal('CI'),
                z.literal('HR'),
                z.literal('CU'),
                z.literal('CW'),
                z.literal('CY'),
                z.literal('CZ'),
                z.literal('DK'),
                z.literal('DJ'),
                z.literal('DM'),
                z.literal('DO'),
                z.literal('EC'),
                z.literal('EG'),
                z.literal('SV'),
                z.literal('GQ'),
                z.literal('ER'),
                z.literal('EE'),
                z.literal('ET'),
                z.literal('FK'),
                z.literal('FO'),
                z.literal('FJ'),
                z.literal('FI'),
                z.literal('FR'),
                z.literal('GF'),
                z.literal('PF'),
                z.literal('TF'),
                z.literal('GA'),
                z.literal('GM'),
                z.literal('GE'),
                z.literal('DE'),
                z.literal('GH'),
                z.literal('GI'),
                z.literal('GR'),
                z.literal('GL'),
                z.literal('GD'),
                z.literal('GP'),
                z.literal('GU'),
                z.literal('GT'),
                z.literal('GG'),
                z.literal('GN'),
                z.literal('GW'),
                z.literal('GY'),
                z.literal('HT'),
                z.literal('HM'),
                z.literal('VA'),
                z.literal('HN'),
                z.literal('HK'),
                z.literal('HU'),
                z.literal('IS'),
                z.literal('IN'),
                z.literal('ID'),
                z.literal('IR'),
                z.literal('IQ'),
                z.literal('IE'),
                z.literal('IM'),
                z.literal('IL'),
                z.literal('IT'),
                z.literal('JM'),
                z.literal('JP'),
                z.literal('JE'),
                z.literal('JO'),
                z.literal('KZ'),
                z.literal('KE'),
                z.literal('KI'),
                z.literal('KR'),
                z.literal('KW'),
                z.literal('KG'),
                z.literal('LA'),
                z.literal('LV'),
                z.literal('LB'),
                z.literal('LS'),
                z.literal('LR'),
                z.literal('LY'),
                z.literal('LI'),
                z.literal('LT'),
                z.literal('LU'),
                z.literal('MO'),
                z.literal('MK'),
                z.literal('MG'),
                z.literal('MW'),
                z.literal('MY'),
                z.literal('MV'),
                z.literal('ML'),
                z.literal('MT'),
                z.literal('MH'),
                z.literal('MQ'),
                z.literal('MR'),
                z.literal('MU'),
                z.literal('YT'),
                z.literal('MX'),
                z.literal('FM'),
                z.literal('MD'),
                z.literal('MC'),
                z.literal('MN'),
                z.literal('ME'),
                z.literal('MS'),
                z.literal('MA'),
                z.literal('MZ'),
                z.literal('MM'),
                z.literal('NA'),
                z.literal('NR'),
                z.literal('NP'),
                z.literal('NL'),
                z.literal('AN'),
                z.literal('NC'),
                z.literal('NZ'),
                z.literal('NI'),
                z.literal('NE'),
                z.literal('NG'),
                z.literal('NU'),
                z.literal('NF'),
                z.literal('MP'),
                z.literal('NO'),
                z.literal('OM'),
                z.literal('PK'),
                z.literal('PW'),
                z.literal('PS'),
                z.literal('PA'),
                z.literal('PG'),
                z.literal('PY'),
                z.literal('PE'),
                z.literal('PH'),
                z.literal('PN'),
                z.literal('PL'),
                z.literal('PT'),
                z.literal('PR'),
                z.literal('QA'),
                z.literal('RE'),
                z.literal('RO'),
                z.literal('RU'),
                z.literal('RW'),
                z.literal('BL'),
                z.literal('SH'),
                z.literal('KN'),
                z.literal('LC'),
                z.literal('MF'),
                z.literal('PM'),
                z.literal('VC'),
                z.literal('WS'),
                z.literal('SM'),
                z.literal('ST'),
                z.literal('SA'),
                z.literal('SN'),
                z.literal('RS'),
                z.literal('SC'),
                z.literal('SL'),
                z.literal('SG'),
                z.literal('SK'),
                z.literal('SI'),
                z.literal('SB'),
                z.literal('SO'),
                z.literal('ZA'),
                z.literal('GS'),
                z.literal('ES'),
                z.literal('LK'),
                z.literal('SD'),
                z.literal('SR'),
                z.literal('SJ'),
                z.literal('SZ'),
                z.literal('SE'),
                z.literal('CH'),
                z.literal('SY'),
                z.literal('TW'),
                z.literal('TJ'),
                z.literal('TZ'),
                z.literal('TH'),
                z.literal('TL'),
                z.literal('TG'),
                z.literal('TK'),
                z.literal('TO'),
                z.literal('TT'),
                z.literal('TN'),
                z.literal('TR'),
                z.literal('TM'),
                z.literal('TC'),
                z.literal('TV'),
                z.literal('UG'),
                z.literal('UA'),
                z.literal('AE'),
                z.literal('GB'),
                z.literal('US'),
                z.literal('UM'),
                z.literal('UY'),
                z.literal('UZ'),
                z.literal('VU'),
                z.literal('VE'),
                z.literal('VN'),
                z.literal('VG'),
                z.literal('VI'),
                z.literal('WF'),
                z.literal('EH'),
                z.literal('YE'),
                z.literal('ZM'),
                z.literal('ZW'),
              ])
              .nullable(),
            latitude: z.string().nullable(),
            longitude: z.string().nullable(),
            attribute_type: z.literal('location'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            first_name: z.string(),
            last_name: z.string(),
            full_name: z.string(),
            attribute_type: z.literal('personal-name'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            original_phone_number: z.string(),
            country_code: z.union([
              z.literal('AF'),
              z.literal('AX'),
              z.literal('AL'),
              z.literal('DZ'),
              z.literal('AS'),
              z.literal('AD'),
              z.literal('AO'),
              z.literal('AI'),
              z.literal('AQ'),
              z.literal('AG'),
              z.literal('AR'),
              z.literal('AM'),
              z.literal('AW'),
              z.literal('AU'),
              z.literal('AT'),
              z.literal('AZ'),
              z.literal('BS'),
              z.literal('BH'),
              z.literal('BD'),
              z.literal('BB'),
              z.literal('BY'),
              z.literal('BE'),
              z.literal('BZ'),
              z.literal('BJ'),
              z.literal('BM'),
              z.literal('BT'),
              z.literal('BO'),
              z.literal('BA'),
              z.literal('BW'),
              z.literal('BV'),
              z.literal('BR'),
              z.literal('IO'),
              z.literal('BN'),
              z.literal('BG'),
              z.literal('BF'),
              z.literal('BI'),
              z.literal('KH'),
              z.literal('CM'),
              z.literal('CA'),
              z.literal('CV'),
              z.literal('KY'),
              z.literal('CF'),
              z.literal('TD'),
              z.literal('CL'),
              z.literal('CN'),
              z.literal('CX'),
              z.literal('CC'),
              z.literal('CO'),
              z.literal('KM'),
              z.literal('CG'),
              z.literal('CD'),
              z.literal('CK'),
              z.literal('CR'),
              z.literal('CI'),
              z.literal('HR'),
              z.literal('CU'),
              z.literal('CW'),
              z.literal('CY'),
              z.literal('CZ'),
              z.literal('DK'),
              z.literal('DJ'),
              z.literal('DM'),
              z.literal('DO'),
              z.literal('EC'),
              z.literal('EG'),
              z.literal('SV'),
              z.literal('GQ'),
              z.literal('ER'),
              z.literal('EE'),
              z.literal('ET'),
              z.literal('FK'),
              z.literal('FO'),
              z.literal('FJ'),
              z.literal('FI'),
              z.literal('FR'),
              z.literal('GF'),
              z.literal('PF'),
              z.literal('TF'),
              z.literal('GA'),
              z.literal('GM'),
              z.literal('GE'),
              z.literal('DE'),
              z.literal('GH'),
              z.literal('GI'),
              z.literal('GR'),
              z.literal('GL'),
              z.literal('GD'),
              z.literal('GP'),
              z.literal('GU'),
              z.literal('GT'),
              z.literal('GG'),
              z.literal('GN'),
              z.literal('GW'),
              z.literal('GY'),
              z.literal('HT'),
              z.literal('HM'),
              z.literal('VA'),
              z.literal('HN'),
              z.literal('HK'),
              z.literal('HU'),
              z.literal('IS'),
              z.literal('IN'),
              z.literal('ID'),
              z.literal('IR'),
              z.literal('IQ'),
              z.literal('IE'),
              z.literal('IM'),
              z.literal('IL'),
              z.literal('IT'),
              z.literal('JM'),
              z.literal('JP'),
              z.literal('JE'),
              z.literal('JO'),
              z.literal('KZ'),
              z.literal('KE'),
              z.literal('KI'),
              z.literal('KR'),
              z.literal('KW'),
              z.literal('KG'),
              z.literal('LA'),
              z.literal('LV'),
              z.literal('LB'),
              z.literal('LS'),
              z.literal('LR'),
              z.literal('LY'),
              z.literal('LI'),
              z.literal('LT'),
              z.literal('LU'),
              z.literal('MO'),
              z.literal('MK'),
              z.literal('MG'),
              z.literal('MW'),
              z.literal('MY'),
              z.literal('MV'),
              z.literal('ML'),
              z.literal('MT'),
              z.literal('MH'),
              z.literal('MQ'),
              z.literal('MR'),
              z.literal('MU'),
              z.literal('YT'),
              z.literal('MX'),
              z.literal('FM'),
              z.literal('MD'),
              z.literal('MC'),
              z.literal('MN'),
              z.literal('ME'),
              z.literal('MS'),
              z.literal('MA'),
              z.literal('MZ'),
              z.literal('MM'),
              z.literal('NA'),
              z.literal('NR'),
              z.literal('NP'),
              z.literal('NL'),
              z.literal('AN'),
              z.literal('NC'),
              z.literal('NZ'),
              z.literal('NI'),
              z.literal('NE'),
              z.literal('NG'),
              z.literal('NU'),
              z.literal('NF'),
              z.literal('MP'),
              z.literal('NO'),
              z.literal('OM'),
              z.literal('PK'),
              z.literal('PW'),
              z.literal('PS'),
              z.literal('PA'),
              z.literal('PG'),
              z.literal('PY'),
              z.literal('PE'),
              z.literal('PH'),
              z.literal('PN'),
              z.literal('PL'),
              z.literal('PT'),
              z.literal('PR'),
              z.literal('QA'),
              z.literal('RE'),
              z.literal('RO'),
              z.literal('RU'),
              z.literal('RW'),
              z.literal('BL'),
              z.literal('SH'),
              z.literal('KN'),
              z.literal('LC'),
              z.literal('MF'),
              z.literal('PM'),
              z.literal('VC'),
              z.literal('WS'),
              z.literal('SM'),
              z.literal('ST'),
              z.literal('SA'),
              z.literal('SN'),
              z.literal('RS'),
              z.literal('SC'),
              z.literal('SL'),
              z.literal('SG'),
              z.literal('SK'),
              z.literal('SI'),
              z.literal('SB'),
              z.literal('SO'),
              z.literal('ZA'),
              z.literal('GS'),
              z.literal('ES'),
              z.literal('LK'),
              z.literal('SD'),
              z.literal('SR'),
              z.literal('SJ'),
              z.literal('SZ'),
              z.literal('SE'),
              z.literal('CH'),
              z.literal('SY'),
              z.literal('TW'),
              z.literal('TJ'),
              z.literal('TZ'),
              z.literal('TH'),
              z.literal('TL'),
              z.literal('TG'),
              z.literal('TK'),
              z.literal('TO'),
              z.literal('TT'),
              z.literal('TN'),
              z.literal('TR'),
              z.literal('TM'),
              z.literal('TC'),
              z.literal('TV'),
              z.literal('UG'),
              z.literal('UA'),
              z.literal('AE'),
              z.literal('GB'),
              z.literal('US'),
              z.literal('UM'),
              z.literal('UY'),
              z.literal('UZ'),
              z.literal('VU'),
              z.literal('VE'),
              z.literal('VN'),
              z.literal('VG'),
              z.literal('VI'),
              z.literal('WF'),
              z.literal('EH'),
              z.literal('YE'),
              z.literal('ZM'),
              z.literal('ZW'),
            ]),
            phone_number: z.string(),
            attribute_type: z.literal('phone-number'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            status: statusSchema,
            attribute_type: z.literal('status'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.number(),
            attribute_type: z.literal('rating'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            option: selectOptionSchema,
            attribute_type: z.literal('select'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            value: z.string(),
            attribute_type: z.literal('text'),
          }),
          z.object({
            active_from: z.string(),
            active_until: z.string().nullable(),
            created_by_actor: z.object({
              id: z.string().optional().nullable(),
              type: z
                .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
                .optional()
                .nullable(),
            }),
            attribute_type: z.literal('timestamp'),
            value: z.string(),
          }),
        ]),
      ),
    ),
  }),
});

export const putV2ListsByListEntriesByEntryIdErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('immutable_value'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const deleteV2ListsByListEntriesByEntryIdDataSchema = z.object({
  path: z.object({
    entry_id: z.string(),
    list: z.string(),
  }),
});

export const deleteV2ListsByListEntriesByEntryIdResponseSchema = z.record(z.unknown());

export const deleteV2ListsByListEntriesByEntryIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2ListsByListEntriesByEntryIdAttributesByAttributeValuesDataSchema = z.object({
  path: z.object({
    attribute: z.string(),
    entry_id: z.string(),
    list: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      show_historic: z.boolean().optional(),
    })
    .optional(),
});

export const getV2ListsByListEntriesByEntryIdAttributesByAttributeValuesResponseSchema = z.object({
  data: z.array(
    z.union([
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        referenced_actor_type: z.union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')]),
        referenced_actor_id: z.string().nullable(),
        attribute_type: z.literal('actor-reference'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.boolean(),
        attribute_type: z.literal('checkbox'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        currency_value: z.number(),
        currency_code: z
          .union([
            z.literal('EUR'),
            z.literal('GBP'),
            z.literal('USD'),
            z.literal('CAD'),
            z.literal('AUD'),
            z.literal('NZD'),
            z.literal('AED'),
            z.literal('INR'),
            z.literal('CHF'),
            z.literal('JPY'),
            z.literal('CNY'),
            z.literal('PHP'),
            z.literal('ILS'),
            z.literal('SGD'),
            z.literal('HKD'),
            z.literal('MYR'),
            z.literal('NTD'),
            z.literal('NOK'),
            z.literal('SEK'),
            z.literal('ISK'),
            z.literal('BEL'),
            z.literal('PLN'),
            z.literal('KRW'),
            z.literal('DKK'),
            z.literal('BRL'),
          ])
          .optional()
          .nullable(),
        attribute_type: z.literal('currency'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('date'),
        value: z.string(),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        domain: z.string(),
        root_domain: z.string(),
        attribute_type: z.literal('domain'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        original_email_address: z.string(),
        email_address: z.string(),
        email_domain: z.string(),
        email_root_domain: z.string(),
        email_local_specifier: z.string(),
        attribute_type: z.literal('email-address'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        target_object: z.string(),
        target_record_id: z.string(),
        attribute_type: z.literal('record-reference'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        interaction_type: z.union([
          z.literal('calendar-event'),
          z.literal('call'),
          z.literal('chat-thread'),
          z.literal('email'),
          z.literal('in-person-meeting'),
        ]),
        interacted_at: z.string(),
        owner_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('interaction'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        line_1: z.string().nullable(),
        line_2: z.string().nullable(),
        line_3: z.string().nullable(),
        line_4: z.string().nullable(),
        locality: z.string().nullable(),
        region: z.string().nullable(),
        postcode: z.string().nullable(),
        country_code: z
          .union([
            z.literal('AF'),
            z.literal('AX'),
            z.literal('AL'),
            z.literal('DZ'),
            z.literal('AS'),
            z.literal('AD'),
            z.literal('AO'),
            z.literal('AI'),
            z.literal('AQ'),
            z.literal('AG'),
            z.literal('AR'),
            z.literal('AM'),
            z.literal('AW'),
            z.literal('AU'),
            z.literal('AT'),
            z.literal('AZ'),
            z.literal('BS'),
            z.literal('BH'),
            z.literal('BD'),
            z.literal('BB'),
            z.literal('BY'),
            z.literal('BE'),
            z.literal('BZ'),
            z.literal('BJ'),
            z.literal('BM'),
            z.literal('BT'),
            z.literal('BO'),
            z.literal('BA'),
            z.literal('BW'),
            z.literal('BV'),
            z.literal('BR'),
            z.literal('IO'),
            z.literal('BN'),
            z.literal('BG'),
            z.literal('BF'),
            z.literal('BI'),
            z.literal('KH'),
            z.literal('CM'),
            z.literal('CA'),
            z.literal('CV'),
            z.literal('KY'),
            z.literal('CF'),
            z.literal('TD'),
            z.literal('CL'),
            z.literal('CN'),
            z.literal('CX'),
            z.literal('CC'),
            z.literal('CO'),
            z.literal('KM'),
            z.literal('CG'),
            z.literal('CD'),
            z.literal('CK'),
            z.literal('CR'),
            z.literal('CI'),
            z.literal('HR'),
            z.literal('CU'),
            z.literal('CW'),
            z.literal('CY'),
            z.literal('CZ'),
            z.literal('DK'),
            z.literal('DJ'),
            z.literal('DM'),
            z.literal('DO'),
            z.literal('EC'),
            z.literal('EG'),
            z.literal('SV'),
            z.literal('GQ'),
            z.literal('ER'),
            z.literal('EE'),
            z.literal('ET'),
            z.literal('FK'),
            z.literal('FO'),
            z.literal('FJ'),
            z.literal('FI'),
            z.literal('FR'),
            z.literal('GF'),
            z.literal('PF'),
            z.literal('TF'),
            z.literal('GA'),
            z.literal('GM'),
            z.literal('GE'),
            z.literal('DE'),
            z.literal('GH'),
            z.literal('GI'),
            z.literal('GR'),
            z.literal('GL'),
            z.literal('GD'),
            z.literal('GP'),
            z.literal('GU'),
            z.literal('GT'),
            z.literal('GG'),
            z.literal('GN'),
            z.literal('GW'),
            z.literal('GY'),
            z.literal('HT'),
            z.literal('HM'),
            z.literal('VA'),
            z.literal('HN'),
            z.literal('HK'),
            z.literal('HU'),
            z.literal('IS'),
            z.literal('IN'),
            z.literal('ID'),
            z.literal('IR'),
            z.literal('IQ'),
            z.literal('IE'),
            z.literal('IM'),
            z.literal('IL'),
            z.literal('IT'),
            z.literal('JM'),
            z.literal('JP'),
            z.literal('JE'),
            z.literal('JO'),
            z.literal('KZ'),
            z.literal('KE'),
            z.literal('KI'),
            z.literal('KR'),
            z.literal('KW'),
            z.literal('KG'),
            z.literal('LA'),
            z.literal('LV'),
            z.literal('LB'),
            z.literal('LS'),
            z.literal('LR'),
            z.literal('LY'),
            z.literal('LI'),
            z.literal('LT'),
            z.literal('LU'),
            z.literal('MO'),
            z.literal('MK'),
            z.literal('MG'),
            z.literal('MW'),
            z.literal('MY'),
            z.literal('MV'),
            z.literal('ML'),
            z.literal('MT'),
            z.literal('MH'),
            z.literal('MQ'),
            z.literal('MR'),
            z.literal('MU'),
            z.literal('YT'),
            z.literal('MX'),
            z.literal('FM'),
            z.literal('MD'),
            z.literal('MC'),
            z.literal('MN'),
            z.literal('ME'),
            z.literal('MS'),
            z.literal('MA'),
            z.literal('MZ'),
            z.literal('MM'),
            z.literal('NA'),
            z.literal('NR'),
            z.literal('NP'),
            z.literal('NL'),
            z.literal('AN'),
            z.literal('NC'),
            z.literal('NZ'),
            z.literal('NI'),
            z.literal('NE'),
            z.literal('NG'),
            z.literal('NU'),
            z.literal('NF'),
            z.literal('MP'),
            z.literal('NO'),
            z.literal('OM'),
            z.literal('PK'),
            z.literal('PW'),
            z.literal('PS'),
            z.literal('PA'),
            z.literal('PG'),
            z.literal('PY'),
            z.literal('PE'),
            z.literal('PH'),
            z.literal('PN'),
            z.literal('PL'),
            z.literal('PT'),
            z.literal('PR'),
            z.literal('QA'),
            z.literal('RE'),
            z.literal('RO'),
            z.literal('RU'),
            z.literal('RW'),
            z.literal('BL'),
            z.literal('SH'),
            z.literal('KN'),
            z.literal('LC'),
            z.literal('MF'),
            z.literal('PM'),
            z.literal('VC'),
            z.literal('WS'),
            z.literal('SM'),
            z.literal('ST'),
            z.literal('SA'),
            z.literal('SN'),
            z.literal('RS'),
            z.literal('SC'),
            z.literal('SL'),
            z.literal('SG'),
            z.literal('SK'),
            z.literal('SI'),
            z.literal('SB'),
            z.literal('SO'),
            z.literal('ZA'),
            z.literal('GS'),
            z.literal('ES'),
            z.literal('LK'),
            z.literal('SD'),
            z.literal('SR'),
            z.literal('SJ'),
            z.literal('SZ'),
            z.literal('SE'),
            z.literal('CH'),
            z.literal('SY'),
            z.literal('TW'),
            z.literal('TJ'),
            z.literal('TZ'),
            z.literal('TH'),
            z.literal('TL'),
            z.literal('TG'),
            z.literal('TK'),
            z.literal('TO'),
            z.literal('TT'),
            z.literal('TN'),
            z.literal('TR'),
            z.literal('TM'),
            z.literal('TC'),
            z.literal('TV'),
            z.literal('UG'),
            z.literal('UA'),
            z.literal('AE'),
            z.literal('GB'),
            z.literal('US'),
            z.literal('UM'),
            z.literal('UY'),
            z.literal('UZ'),
            z.literal('VU'),
            z.literal('VE'),
            z.literal('VN'),
            z.literal('VG'),
            z.literal('VI'),
            z.literal('WF'),
            z.literal('EH'),
            z.literal('YE'),
            z.literal('ZM'),
            z.literal('ZW'),
          ])
          .nullable(),
        latitude: z.string().nullable(),
        longitude: z.string().nullable(),
        attribute_type: z.literal('location'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.number(),
        attribute_type: z.literal('number'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        first_name: z.string(),
        last_name: z.string(),
        full_name: z.string(),
        attribute_type: z.literal('personal-name'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        original_phone_number: z.string(),
        country_code: z.union([
          z.literal('AF'),
          z.literal('AX'),
          z.literal('AL'),
          z.literal('DZ'),
          z.literal('AS'),
          z.literal('AD'),
          z.literal('AO'),
          z.literal('AI'),
          z.literal('AQ'),
          z.literal('AG'),
          z.literal('AR'),
          z.literal('AM'),
          z.literal('AW'),
          z.literal('AU'),
          z.literal('AT'),
          z.literal('AZ'),
          z.literal('BS'),
          z.literal('BH'),
          z.literal('BD'),
          z.literal('BB'),
          z.literal('BY'),
          z.literal('BE'),
          z.literal('BZ'),
          z.literal('BJ'),
          z.literal('BM'),
          z.literal('BT'),
          z.literal('BO'),
          z.literal('BA'),
          z.literal('BW'),
          z.literal('BV'),
          z.literal('BR'),
          z.literal('IO'),
          z.literal('BN'),
          z.literal('BG'),
          z.literal('BF'),
          z.literal('BI'),
          z.literal('KH'),
          z.literal('CM'),
          z.literal('CA'),
          z.literal('CV'),
          z.literal('KY'),
          z.literal('CF'),
          z.literal('TD'),
          z.literal('CL'),
          z.literal('CN'),
          z.literal('CX'),
          z.literal('CC'),
          z.literal('CO'),
          z.literal('KM'),
          z.literal('CG'),
          z.literal('CD'),
          z.literal('CK'),
          z.literal('CR'),
          z.literal('CI'),
          z.literal('HR'),
          z.literal('CU'),
          z.literal('CW'),
          z.literal('CY'),
          z.literal('CZ'),
          z.literal('DK'),
          z.literal('DJ'),
          z.literal('DM'),
          z.literal('DO'),
          z.literal('EC'),
          z.literal('EG'),
          z.literal('SV'),
          z.literal('GQ'),
          z.literal('ER'),
          z.literal('EE'),
          z.literal('ET'),
          z.literal('FK'),
          z.literal('FO'),
          z.literal('FJ'),
          z.literal('FI'),
          z.literal('FR'),
          z.literal('GF'),
          z.literal('PF'),
          z.literal('TF'),
          z.literal('GA'),
          z.literal('GM'),
          z.literal('GE'),
          z.literal('DE'),
          z.literal('GH'),
          z.literal('GI'),
          z.literal('GR'),
          z.literal('GL'),
          z.literal('GD'),
          z.literal('GP'),
          z.literal('GU'),
          z.literal('GT'),
          z.literal('GG'),
          z.literal('GN'),
          z.literal('GW'),
          z.literal('GY'),
          z.literal('HT'),
          z.literal('HM'),
          z.literal('VA'),
          z.literal('HN'),
          z.literal('HK'),
          z.literal('HU'),
          z.literal('IS'),
          z.literal('IN'),
          z.literal('ID'),
          z.literal('IR'),
          z.literal('IQ'),
          z.literal('IE'),
          z.literal('IM'),
          z.literal('IL'),
          z.literal('IT'),
          z.literal('JM'),
          z.literal('JP'),
          z.literal('JE'),
          z.literal('JO'),
          z.literal('KZ'),
          z.literal('KE'),
          z.literal('KI'),
          z.literal('KR'),
          z.literal('KW'),
          z.literal('KG'),
          z.literal('LA'),
          z.literal('LV'),
          z.literal('LB'),
          z.literal('LS'),
          z.literal('LR'),
          z.literal('LY'),
          z.literal('LI'),
          z.literal('LT'),
          z.literal('LU'),
          z.literal('MO'),
          z.literal('MK'),
          z.literal('MG'),
          z.literal('MW'),
          z.literal('MY'),
          z.literal('MV'),
          z.literal('ML'),
          z.literal('MT'),
          z.literal('MH'),
          z.literal('MQ'),
          z.literal('MR'),
          z.literal('MU'),
          z.literal('YT'),
          z.literal('MX'),
          z.literal('FM'),
          z.literal('MD'),
          z.literal('MC'),
          z.literal('MN'),
          z.literal('ME'),
          z.literal('MS'),
          z.literal('MA'),
          z.literal('MZ'),
          z.literal('MM'),
          z.literal('NA'),
          z.literal('NR'),
          z.literal('NP'),
          z.literal('NL'),
          z.literal('AN'),
          z.literal('NC'),
          z.literal('NZ'),
          z.literal('NI'),
          z.literal('NE'),
          z.literal('NG'),
          z.literal('NU'),
          z.literal('NF'),
          z.literal('MP'),
          z.literal('NO'),
          z.literal('OM'),
          z.literal('PK'),
          z.literal('PW'),
          z.literal('PS'),
          z.literal('PA'),
          z.literal('PG'),
          z.literal('PY'),
          z.literal('PE'),
          z.literal('PH'),
          z.literal('PN'),
          z.literal('PL'),
          z.literal('PT'),
          z.literal('PR'),
          z.literal('QA'),
          z.literal('RE'),
          z.literal('RO'),
          z.literal('RU'),
          z.literal('RW'),
          z.literal('BL'),
          z.literal('SH'),
          z.literal('KN'),
          z.literal('LC'),
          z.literal('MF'),
          z.literal('PM'),
          z.literal('VC'),
          z.literal('WS'),
          z.literal('SM'),
          z.literal('ST'),
          z.literal('SA'),
          z.literal('SN'),
          z.literal('RS'),
          z.literal('SC'),
          z.literal('SL'),
          z.literal('SG'),
          z.literal('SK'),
          z.literal('SI'),
          z.literal('SB'),
          z.literal('SO'),
          z.literal('ZA'),
          z.literal('GS'),
          z.literal('ES'),
          z.literal('LK'),
          z.literal('SD'),
          z.literal('SR'),
          z.literal('SJ'),
          z.literal('SZ'),
          z.literal('SE'),
          z.literal('CH'),
          z.literal('SY'),
          z.literal('TW'),
          z.literal('TJ'),
          z.literal('TZ'),
          z.literal('TH'),
          z.literal('TL'),
          z.literal('TG'),
          z.literal('TK'),
          z.literal('TO'),
          z.literal('TT'),
          z.literal('TN'),
          z.literal('TR'),
          z.literal('TM'),
          z.literal('TC'),
          z.literal('TV'),
          z.literal('UG'),
          z.literal('UA'),
          z.literal('AE'),
          z.literal('GB'),
          z.literal('US'),
          z.literal('UM'),
          z.literal('UY'),
          z.literal('UZ'),
          z.literal('VU'),
          z.literal('VE'),
          z.literal('VN'),
          z.literal('VG'),
          z.literal('VI'),
          z.literal('WF'),
          z.literal('EH'),
          z.literal('YE'),
          z.literal('ZM'),
          z.literal('ZW'),
        ]),
        phone_number: z.string(),
        attribute_type: z.literal('phone-number'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        status: statusSchema,
        attribute_type: z.literal('status'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.number(),
        attribute_type: z.literal('rating'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        option: selectOptionSchema,
        attribute_type: z.literal('select'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        value: z.string(),
        attribute_type: z.literal('text'),
      }),
      z.object({
        active_from: z.string(),
        active_until: z.string().nullable(),
        created_by_actor: z.object({
          id: z.string().optional().nullable(),
          type: z
            .union([z.literal('api-token'), z.literal('workspace-member'), z.literal('system')])
            .optional()
            .nullable(),
        }),
        attribute_type: z.literal('timestamp'),
        value: z.string(),
      }),
    ]),
  ),
});

export const getV2ListsByListEntriesByEntryIdAttributesByAttributeValuesErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2WorkspaceMembersResponseSchema = z.object({
  data: z.array(workspaceMemberSchema),
});

export const getV2WorkspaceMembersErrorSchema = z.unknown();

export const getV2WorkspaceMembersByWorkspaceMemberIdDataSchema = z.object({
  path: z.object({
    workspace_member_id: z.string(),
  }),
});

export const getV2WorkspaceMembersByWorkspaceMemberIdResponseSchema = z.object({
  data: workspaceMemberSchema,
});

export const getV2WorkspaceMembersByWorkspaceMemberIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2NotesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      parent_object: z.string().optional(),
      parent_record_id: z.string().optional(),
    })
    .optional(),
});

export const getV2NotesResponseSchema = z.object({
  data: z.array(noteSchema),
});

export const getV2NotesErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const postV2NotesDataSchema = z.object({
  body: z.object({
    data: z.object({
      parent_object: z.string(),
      parent_record_id: z.string(),
      title: z.string(),
      format: z.literal('plaintext'),
      content: z.string(),
      created_at: z.string().optional(),
    }),
  }),
});

export const postV2NotesResponseSchema = z.object({
  data: noteSchema,
});

export const postV2NotesErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2NotesByNoteIdDataSchema = z.object({
  path: z.object({
    note_id: z.string(),
  }),
});

export const getV2NotesByNoteIdResponseSchema = z.object({
  data: noteSchema,
});

export const getV2NotesByNoteIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const deleteV2NotesByNoteIdDataSchema = z.object({
  path: z.object({
    note_id: z.string(),
  }),
});

export const deleteV2NotesByNoteIdResponseSchema = z.record(z.unknown());

export const deleteV2NotesByNoteIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2TasksDataSchema = z.object({
  query: z
    .object({
      assignee: z.string().optional().nullable(),
      is_completed: z.boolean().optional(),
      limit: z.number().optional(),
      linked_object: z.string().optional(),
      linked_record_id: z.string().optional(),
      offset: z.number().optional(),
      sort: z.union([z.literal('created_at:asc'), z.literal('created_at:desc')]).optional(),
    })
    .optional(),
});

export const getV2TasksResponseSchema = z.object({
  data: z.array(taskSchema),
});

export const getV2TasksErrorSchema = z.unknown();

export const postV2TasksDataSchema = z.object({
  body: z.object({
    data: z.object({
      content: z.string(),
      format: z.literal('plaintext'),
      deadline_at: z.string().nullable(),
      is_completed: z.boolean(),
      linked_records: z.array(
        z.union([
          z.object({
            target_object: z.string(),
            target_record_id: z.string(),
          }),
          z.object({
            target_object: z.string(),
            '[slug_or_id_of_matching_attribute]': z.array(
              z.union([
                z.object({
                  domain: z.string().optional(),
                }),
                z.object({
                  email_address: z.string().optional(),
                }),
                z.object({
                  value: z.number().optional(),
                }),
                z.object({
                  original_phone_number: z.string().optional(),
                  country_code: z
                    .union([
                      z.literal('AF'),
                      z.literal('AX'),
                      z.literal('AL'),
                      z.literal('DZ'),
                      z.literal('AS'),
                      z.literal('AD'),
                      z.literal('AO'),
                      z.literal('AI'),
                      z.literal('AQ'),
                      z.literal('AG'),
                      z.literal('AR'),
                      z.literal('AM'),
                      z.literal('AW'),
                      z.literal('AU'),
                      z.literal('AT'),
                      z.literal('AZ'),
                      z.literal('BS'),
                      z.literal('BH'),
                      z.literal('BD'),
                      z.literal('BB'),
                      z.literal('BY'),
                      z.literal('BE'),
                      z.literal('BZ'),
                      z.literal('BJ'),
                      z.literal('BM'),
                      z.literal('BT'),
                      z.literal('BO'),
                      z.literal('BA'),
                      z.literal('BW'),
                      z.literal('BV'),
                      z.literal('BR'),
                      z.literal('IO'),
                      z.literal('BN'),
                      z.literal('BG'),
                      z.literal('BF'),
                      z.literal('BI'),
                      z.literal('KH'),
                      z.literal('CM'),
                      z.literal('CA'),
                      z.literal('CV'),
                      z.literal('KY'),
                      z.literal('CF'),
                      z.literal('TD'),
                      z.literal('CL'),
                      z.literal('CN'),
                      z.literal('CX'),
                      z.literal('CC'),
                      z.literal('CO'),
                      z.literal('KM'),
                      z.literal('CG'),
                      z.literal('CD'),
                      z.literal('CK'),
                      z.literal('CR'),
                      z.literal('CI'),
                      z.literal('HR'),
                      z.literal('CU'),
                      z.literal('CW'),
                      z.literal('CY'),
                      z.literal('CZ'),
                      z.literal('DK'),
                      z.literal('DJ'),
                      z.literal('DM'),
                      z.literal('DO'),
                      z.literal('EC'),
                      z.literal('EG'),
                      z.literal('SV'),
                      z.literal('GQ'),
                      z.literal('ER'),
                      z.literal('EE'),
                      z.literal('ET'),
                      z.literal('FK'),
                      z.literal('FO'),
                      z.literal('FJ'),
                      z.literal('FI'),
                      z.literal('FR'),
                      z.literal('GF'),
                      z.literal('PF'),
                      z.literal('TF'),
                      z.literal('GA'),
                      z.literal('GM'),
                      z.literal('GE'),
                      z.literal('DE'),
                      z.literal('GH'),
                      z.literal('GI'),
                      z.literal('GR'),
                      z.literal('GL'),
                      z.literal('GD'),
                      z.literal('GP'),
                      z.literal('GU'),
                      z.literal('GT'),
                      z.literal('GG'),
                      z.literal('GN'),
                      z.literal('GW'),
                      z.literal('GY'),
                      z.literal('HT'),
                      z.literal('HM'),
                      z.literal('VA'),
                      z.literal('HN'),
                      z.literal('HK'),
                      z.literal('HU'),
                      z.literal('IS'),
                      z.literal('IN'),
                      z.literal('ID'),
                      z.literal('IR'),
                      z.literal('IQ'),
                      z.literal('IE'),
                      z.literal('IM'),
                      z.literal('IL'),
                      z.literal('IT'),
                      z.literal('JM'),
                      z.literal('JP'),
                      z.literal('JE'),
                      z.literal('JO'),
                      z.literal('KZ'),
                      z.literal('KE'),
                      z.literal('KI'),
                      z.literal('KR'),
                      z.literal('KW'),
                      z.literal('KG'),
                      z.literal('LA'),
                      z.literal('LV'),
                      z.literal('LB'),
                      z.literal('LS'),
                      z.literal('LR'),
                      z.literal('LY'),
                      z.literal('LI'),
                      z.literal('LT'),
                      z.literal('LU'),
                      z.literal('MO'),
                      z.literal('MK'),
                      z.literal('MG'),
                      z.literal('MW'),
                      z.literal('MY'),
                      z.literal('MV'),
                      z.literal('ML'),
                      z.literal('MT'),
                      z.literal('MH'),
                      z.literal('MQ'),
                      z.literal('MR'),
                      z.literal('MU'),
                      z.literal('YT'),
                      z.literal('MX'),
                      z.literal('FM'),
                      z.literal('MD'),
                      z.literal('MC'),
                      z.literal('MN'),
                      z.literal('ME'),
                      z.literal('MS'),
                      z.literal('MA'),
                      z.literal('MZ'),
                      z.literal('MM'),
                      z.literal('NA'),
                      z.literal('NR'),
                      z.literal('NP'),
                      z.literal('NL'),
                      z.literal('AN'),
                      z.literal('NC'),
                      z.literal('NZ'),
                      z.literal('NI'),
                      z.literal('NE'),
                      z.literal('NG'),
                      z.literal('NU'),
                      z.literal('NF'),
                      z.literal('MP'),
                      z.literal('NO'),
                      z.literal('OM'),
                      z.literal('PK'),
                      z.literal('PW'),
                      z.literal('PS'),
                      z.literal('PA'),
                      z.literal('PG'),
                      z.literal('PY'),
                      z.literal('PE'),
                      z.literal('PH'),
                      z.literal('PN'),
                      z.literal('PL'),
                      z.literal('PT'),
                      z.literal('PR'),
                      z.literal('QA'),
                      z.literal('RE'),
                      z.literal('RO'),
                      z.literal('RU'),
                      z.literal('RW'),
                      z.literal('BL'),
                      z.literal('SH'),
                      z.literal('KN'),
                      z.literal('LC'),
                      z.literal('MF'),
                      z.literal('PM'),
                      z.literal('VC'),
                      z.literal('WS'),
                      z.literal('SM'),
                      z.literal('ST'),
                      z.literal('SA'),
                      z.literal('SN'),
                      z.literal('RS'),
                      z.literal('SC'),
                      z.literal('SL'),
                      z.literal('SG'),
                      z.literal('SK'),
                      z.literal('SI'),
                      z.literal('SB'),
                      z.literal('SO'),
                      z.literal('ZA'),
                      z.literal('GS'),
                      z.literal('ES'),
                      z.literal('LK'),
                      z.literal('SD'),
                      z.literal('SR'),
                      z.literal('SJ'),
                      z.literal('SZ'),
                      z.literal('SE'),
                      z.literal('CH'),
                      z.literal('SY'),
                      z.literal('TW'),
                      z.literal('TJ'),
                      z.literal('TZ'),
                      z.literal('TH'),
                      z.literal('TL'),
                      z.literal('TG'),
                      z.literal('TK'),
                      z.literal('TO'),
                      z.literal('TT'),
                      z.literal('TN'),
                      z.literal('TR'),
                      z.literal('TM'),
                      z.literal('TC'),
                      z.literal('TV'),
                      z.literal('UG'),
                      z.literal('UA'),
                      z.literal('AE'),
                      z.literal('GB'),
                      z.literal('US'),
                      z.literal('UM'),
                      z.literal('UY'),
                      z.literal('UZ'),
                      z.literal('VU'),
                      z.literal('VE'),
                      z.literal('VN'),
                      z.literal('VG'),
                      z.literal('VI'),
                      z.literal('WF'),
                      z.literal('EH'),
                      z.literal('YE'),
                      z.literal('ZM'),
                      z.literal('ZW'),
                    ])
                    .optional()
                    .nullable(),
                }),
                z.object({
                  value: z.string().optional(),
                }),
              ]),
            ),
          }),
        ]),
      ),
      assignees: z.array(
        z.union([
          z.object({
            referenced_actor_type: z.literal('workspace-member'),
            referenced_actor_id: z.string(),
          }),
          z.object({
            workspace_member_email_address: z.string(),
          }),
        ]),
      ),
    }),
  }),
});

export const postV2TasksResponseSchema = z.object({
  data: taskSchema,
});

export const postV2TasksErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const getV2TasksByTaskIdDataSchema = z.object({
  path: z.object({
    task_id: z.string(),
  }),
});

export const getV2TasksByTaskIdResponseSchema = z.object({
  data: taskSchema,
});

export const getV2TasksByTaskIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2TasksByTaskIdDataSchema = z.object({
  body: z.object({
    data: z.object({
      deadline_at: z.string().optional().nullable(),
      is_completed: z.boolean().optional(),
      linked_records: z
        .array(
          z.union([
            z.object({
              target_object: z.string(),
              target_record_id: z.string(),
            }),
            z.object({
              target_object: z.string(),
              '[slug_or_id_of_matching_attribute]': z.array(
                z.union([
                  z.object({
                    domain: z.string().optional(),
                  }),
                  z.object({
                    email_address: z.string().optional(),
                  }),
                  z.object({
                    value: z.number().optional(),
                  }),
                  z.object({
                    original_phone_number: z.string().optional(),
                    country_code: z
                      .union([
                        z.literal('AF'),
                        z.literal('AX'),
                        z.literal('AL'),
                        z.literal('DZ'),
                        z.literal('AS'),
                        z.literal('AD'),
                        z.literal('AO'),
                        z.literal('AI'),
                        z.literal('AQ'),
                        z.literal('AG'),
                        z.literal('AR'),
                        z.literal('AM'),
                        z.literal('AW'),
                        z.literal('AU'),
                        z.literal('AT'),
                        z.literal('AZ'),
                        z.literal('BS'),
                        z.literal('BH'),
                        z.literal('BD'),
                        z.literal('BB'),
                        z.literal('BY'),
                        z.literal('BE'),
                        z.literal('BZ'),
                        z.literal('BJ'),
                        z.literal('BM'),
                        z.literal('BT'),
                        z.literal('BO'),
                        z.literal('BA'),
                        z.literal('BW'),
                        z.literal('BV'),
                        z.literal('BR'),
                        z.literal('IO'),
                        z.literal('BN'),
                        z.literal('BG'),
                        z.literal('BF'),
                        z.literal('BI'),
                        z.literal('KH'),
                        z.literal('CM'),
                        z.literal('CA'),
                        z.literal('CV'),
                        z.literal('KY'),
                        z.literal('CF'),
                        z.literal('TD'),
                        z.literal('CL'),
                        z.literal('CN'),
                        z.literal('CX'),
                        z.literal('CC'),
                        z.literal('CO'),
                        z.literal('KM'),
                        z.literal('CG'),
                        z.literal('CD'),
                        z.literal('CK'),
                        z.literal('CR'),
                        z.literal('CI'),
                        z.literal('HR'),
                        z.literal('CU'),
                        z.literal('CW'),
                        z.literal('CY'),
                        z.literal('CZ'),
                        z.literal('DK'),
                        z.literal('DJ'),
                        z.literal('DM'),
                        z.literal('DO'),
                        z.literal('EC'),
                        z.literal('EG'),
                        z.literal('SV'),
                        z.literal('GQ'),
                        z.literal('ER'),
                        z.literal('EE'),
                        z.literal('ET'),
                        z.literal('FK'),
                        z.literal('FO'),
                        z.literal('FJ'),
                        z.literal('FI'),
                        z.literal('FR'),
                        z.literal('GF'),
                        z.literal('PF'),
                        z.literal('TF'),
                        z.literal('GA'),
                        z.literal('GM'),
                        z.literal('GE'),
                        z.literal('DE'),
                        z.literal('GH'),
                        z.literal('GI'),
                        z.literal('GR'),
                        z.literal('GL'),
                        z.literal('GD'),
                        z.literal('GP'),
                        z.literal('GU'),
                        z.literal('GT'),
                        z.literal('GG'),
                        z.literal('GN'),
                        z.literal('GW'),
                        z.literal('GY'),
                        z.literal('HT'),
                        z.literal('HM'),
                        z.literal('VA'),
                        z.literal('HN'),
                        z.literal('HK'),
                        z.literal('HU'),
                        z.literal('IS'),
                        z.literal('IN'),
                        z.literal('ID'),
                        z.literal('IR'),
                        z.literal('IQ'),
                        z.literal('IE'),
                        z.literal('IM'),
                        z.literal('IL'),
                        z.literal('IT'),
                        z.literal('JM'),
                        z.literal('JP'),
                        z.literal('JE'),
                        z.literal('JO'),
                        z.literal('KZ'),
                        z.literal('KE'),
                        z.literal('KI'),
                        z.literal('KR'),
                        z.literal('KW'),
                        z.literal('KG'),
                        z.literal('LA'),
                        z.literal('LV'),
                        z.literal('LB'),
                        z.literal('LS'),
                        z.literal('LR'),
                        z.literal('LY'),
                        z.literal('LI'),
                        z.literal('LT'),
                        z.literal('LU'),
                        z.literal('MO'),
                        z.literal('MK'),
                        z.literal('MG'),
                        z.literal('MW'),
                        z.literal('MY'),
                        z.literal('MV'),
                        z.literal('ML'),
                        z.literal('MT'),
                        z.literal('MH'),
                        z.literal('MQ'),
                        z.literal('MR'),
                        z.literal('MU'),
                        z.literal('YT'),
                        z.literal('MX'),
                        z.literal('FM'),
                        z.literal('MD'),
                        z.literal('MC'),
                        z.literal('MN'),
                        z.literal('ME'),
                        z.literal('MS'),
                        z.literal('MA'),
                        z.literal('MZ'),
                        z.literal('MM'),
                        z.literal('NA'),
                        z.literal('NR'),
                        z.literal('NP'),
                        z.literal('NL'),
                        z.literal('AN'),
                        z.literal('NC'),
                        z.literal('NZ'),
                        z.literal('NI'),
                        z.literal('NE'),
                        z.literal('NG'),
                        z.literal('NU'),
                        z.literal('NF'),
                        z.literal('MP'),
                        z.literal('NO'),
                        z.literal('OM'),
                        z.literal('PK'),
                        z.literal('PW'),
                        z.literal('PS'),
                        z.literal('PA'),
                        z.literal('PG'),
                        z.literal('PY'),
                        z.literal('PE'),
                        z.literal('PH'),
                        z.literal('PN'),
                        z.literal('PL'),
                        z.literal('PT'),
                        z.literal('PR'),
                        z.literal('QA'),
                        z.literal('RE'),
                        z.literal('RO'),
                        z.literal('RU'),
                        z.literal('RW'),
                        z.literal('BL'),
                        z.literal('SH'),
                        z.literal('KN'),
                        z.literal('LC'),
                        z.literal('MF'),
                        z.literal('PM'),
                        z.literal('VC'),
                        z.literal('WS'),
                        z.literal('SM'),
                        z.literal('ST'),
                        z.literal('SA'),
                        z.literal('SN'),
                        z.literal('RS'),
                        z.literal('SC'),
                        z.literal('SL'),
                        z.literal('SG'),
                        z.literal('SK'),
                        z.literal('SI'),
                        z.literal('SB'),
                        z.literal('SO'),
                        z.literal('ZA'),
                        z.literal('GS'),
                        z.literal('ES'),
                        z.literal('LK'),
                        z.literal('SD'),
                        z.literal('SR'),
                        z.literal('SJ'),
                        z.literal('SZ'),
                        z.literal('SE'),
                        z.literal('CH'),
                        z.literal('SY'),
                        z.literal('TW'),
                        z.literal('TJ'),
                        z.literal('TZ'),
                        z.literal('TH'),
                        z.literal('TL'),
                        z.literal('TG'),
                        z.literal('TK'),
                        z.literal('TO'),
                        z.literal('TT'),
                        z.literal('TN'),
                        z.literal('TR'),
                        z.literal('TM'),
                        z.literal('TC'),
                        z.literal('TV'),
                        z.literal('UG'),
                        z.literal('UA'),
                        z.literal('AE'),
                        z.literal('GB'),
                        z.literal('US'),
                        z.literal('UM'),
                        z.literal('UY'),
                        z.literal('UZ'),
                        z.literal('VU'),
                        z.literal('VE'),
                        z.literal('VN'),
                        z.literal('VG'),
                        z.literal('VI'),
                        z.literal('WF'),
                        z.literal('EH'),
                        z.literal('YE'),
                        z.literal('ZM'),
                        z.literal('ZW'),
                      ])
                      .optional()
                      .nullable(),
                  }),
                  z.object({
                    value: z.string().optional(),
                  }),
                ]),
              ),
            }),
          ]),
        )
        .optional(),
      assignees: z
        .array(
          z.union([
            z.object({
              referenced_actor_type: z.literal('workspace-member'),
              referenced_actor_id: z.string(),
            }),
            z.object({
              workspace_member_email_address: z.string(),
            }),
          ]),
        )
        .optional(),
    }),
  }),
  path: z.object({
    task_id: z.string(),
  }),
});

export const patchV2TasksByTaskIdResponseSchema = z.object({
  data: taskSchema,
});

export const patchV2TasksByTaskIdErrorSchema = z.union([
  z.object({
    status_code: z.literal(400),
    type: z.literal('invalid_request_error'),
    code: z.literal('validation_type'),
    message: z.string(),
  }),
  z.object({
    status_code: z.literal(404),
    type: z.literal('invalid_request_error'),
    code: z.literal('not_found'),
    message: z.string(),
  }),
]);

export const deleteV2TasksByTaskIdDataSchema = z.object({
  path: z.object({
    task_id: z.string(),
  }),
});

export const deleteV2TasksByTaskIdResponseSchema = z.record(z.unknown());

export const deleteV2TasksByTaskIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2ThreadsDataSchema = z.object({
  query: z
    .object({
      entry_id: z.string().optional(),
      limit: z.number().optional(),
      list: z.string().optional(),
      object: z.string().optional(),
      offset: z.number().optional(),
      record_id: z.string().optional(),
    })
    .optional(),
});

export const getV2ThreadsResponseSchema = z.object({
  data: z.array(threadSchema),
});

export const getV2ThreadsErrorSchema = z.unknown();

export const getV2ThreadsByThreadIdDataSchema = z.object({
  path: z.object({
    thread_id: z.string(),
  }),
});

export const getV2ThreadsByThreadIdResponseSchema = z.object({
  data: threadSchema,
});

export const getV2ThreadsByThreadIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const postV2CommentsDataSchema = z.object({
  body: z.object({
    data: z.union([
      z.object({
        format: z.literal('plaintext'),
        content: z.string(),
        author: z.object({
          type: z.literal('workspace-member'),
          id: z.string(),
        }),
        created_at: z.string().optional(),
        thread_id: z.string(),
      }),
      z.object({
        format: z.literal('plaintext'),
        content: z.string(),
        author: z.object({
          type: z.literal('workspace-member'),
          id: z.string(),
        }),
        created_at: z.string().optional(),
        record: z.object({
          object: z.string(),
          record_id: z.string(),
        }),
      }),
      z.object({
        format: z.literal('plaintext'),
        content: z.string(),
        author: z.object({
          type: z.literal('workspace-member'),
          id: z.string(),
        }),
        created_at: z.string().optional(),
        entry: z.object({
          list: z.string(),
          entry_id: z.string(),
        }),
      }),
    ]),
  }),
});

export const postV2CommentsResponseSchema = z.object({
  data: commentSchema,
});

export const postV2CommentsErrorSchema = z.object({
  statusCode: z.literal(400),
  type: z.literal('invalid_request_error'),
  code: z.literal('value_not_found'),
  message: z.string(),
});

export const getV2CommentsByCommentIdDataSchema = z.object({
  path: z.object({
    comment_id: z.string(),
  }),
});

export const getV2CommentsByCommentIdResponseSchema = z.object({
  data: commentSchema,
});

export const getV2CommentsByCommentIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const deleteV2CommentsByCommentIdDataSchema = z.object({
  path: z.object({
    comment_id: z.string(),
  }),
});

export const deleteV2CommentsByCommentIdResponseSchema = z.record(z.unknown());

export const deleteV2CommentsByCommentIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2WebhooksDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getV2WebhooksResponseSchema = z.object({
  data: z.array(
    z.object({
      target_url: z.string(),
      subscriptions: z.array(
        z.object({
          event_type: z.union([
            z.literal('comment.created'),
            z.literal('comment.resolved'),
            z.literal('comment.unresolved'),
            z.literal('comment.deleted'),
            z.literal('list.created'),
            z.literal('list.updated'),
            z.literal('list.deleted'),
            z.literal('list-attribute.created'),
            z.literal('list-attribute.updated'),
            z.literal('list-entry.created'),
            z.literal('list-entry.updated'),
            z.literal('list-entry.deleted'),
            z.literal('object-attribute.created'),
            z.literal('object-attribute.updated'),
            z.literal('note.created'),
            z.literal('note.updated'),
            z.literal('note.deleted'),
            z.literal('record.created'),
            z.literal('record.merged'),
            z.literal('record.updated'),
            z.literal('record.deleted'),
            z.literal('task.created'),
            z.literal('task.updated'),
            z.literal('task.deleted'),
            z.literal('workspace-member.created'),
          ]),
          filter: z
            .union([
              z.object({
                $or: z.array(
                  z.union([
                    z.object({
                      field: z.string(),
                      operator: z.literal('equals'),
                      value: z.string(),
                    }),
                    z.object({
                      field: z.string(),
                      operator: z.literal('not_equals'),
                      value: z.string(),
                    }),
                  ]),
                ),
              }),
              z.object({
                $and: z.array(
                  z.union([
                    z.object({
                      field: z.string(),
                      operator: z.literal('equals'),
                      value: z.string(),
                    }),
                    z.object({
                      field: z.string(),
                      operator: z.literal('not_equals'),
                      value: z.string(),
                    }),
                  ]),
                ),
              }),
            ])
            .nullable(),
        }),
      ),
      id: z.object({
        workspace_id: z.string(),
        webhook_id: z.string(),
      }),
      status: z.union([z.literal('active'), z.literal('degraded'), z.literal('inactive')]),
      created_at: z.string(),
    }),
  ),
});

export const getV2WebhooksErrorSchema = z.unknown();

export const postV2WebhooksDataSchema = z.object({
  body: z.object({
    data: z.object({
      target_url: z.string(),
      subscriptions: z.array(
        z.object({
          event_type: z.union([
            z.literal('comment.created'),
            z.literal('comment.resolved'),
            z.literal('comment.unresolved'),
            z.literal('comment.deleted'),
            z.literal('list.created'),
            z.literal('list.updated'),
            z.literal('list.deleted'),
            z.literal('list-attribute.created'),
            z.literal('list-attribute.updated'),
            z.literal('list-entry.created'),
            z.literal('list-entry.updated'),
            z.literal('list-entry.deleted'),
            z.literal('object-attribute.created'),
            z.literal('object-attribute.updated'),
            z.literal('note.created'),
            z.literal('note.updated'),
            z.literal('note.deleted'),
            z.literal('record.created'),
            z.literal('record.merged'),
            z.literal('record.updated'),
            z.literal('record.deleted'),
            z.literal('task.created'),
            z.literal('task.updated'),
            z.literal('task.deleted'),
            z.literal('workspace-member.created'),
          ]),
          filter: z
            .union([
              z.object({
                $or: z.array(
                  z.union([
                    z.object({
                      field: z.string(),
                      operator: z.literal('equals'),
                      value: z.string(),
                    }),
                    z.object({
                      field: z.string(),
                      operator: z.literal('not_equals'),
                      value: z.string(),
                    }),
                  ]),
                ),
              }),
              z.object({
                $and: z.array(
                  z.union([
                    z.object({
                      field: z.string(),
                      operator: z.literal('equals'),
                      value: z.string(),
                    }),
                    z.object({
                      field: z.string(),
                      operator: z.literal('not_equals'),
                      value: z.string(),
                    }),
                  ]),
                ),
              }),
            ])
            .nullable(),
        }),
      ),
    }),
  }),
});

export const postV2WebhooksResponseSchema = z.object({
  data: z.object({
    target_url: z.string(),
    subscriptions: z.array(
      z.object({
        event_type: z.union([
          z.literal('comment.created'),
          z.literal('comment.resolved'),
          z.literal('comment.unresolved'),
          z.literal('comment.deleted'),
          z.literal('list.created'),
          z.literal('list.updated'),
          z.literal('list.deleted'),
          z.literal('list-attribute.created'),
          z.literal('list-attribute.updated'),
          z.literal('list-entry.created'),
          z.literal('list-entry.updated'),
          z.literal('list-entry.deleted'),
          z.literal('object-attribute.created'),
          z.literal('object-attribute.updated'),
          z.literal('note.created'),
          z.literal('note.updated'),
          z.literal('note.deleted'),
          z.literal('record.created'),
          z.literal('record.merged'),
          z.literal('record.updated'),
          z.literal('record.deleted'),
          z.literal('task.created'),
          z.literal('task.updated'),
          z.literal('task.deleted'),
          z.literal('workspace-member.created'),
        ]),
        filter: z
          .union([
            z.object({
              $or: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
            z.object({
              $and: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
          ])
          .nullable(),
      }),
    ),
    id: z.object({
      workspace_id: z.string(),
      webhook_id: z.string(),
    }),
    status: z.union([z.literal('active'), z.literal('degraded'), z.literal('inactive')]),
    created_at: z.string(),
    secret: z.string(),
  }),
});

export const postV2WebhooksErrorSchema = z.object({
  status_code: z.literal(400),
  type: z.literal('invalid_request_error'),
  code: z.literal('validation_type'),
  message: z.string(),
});

export const getV2WebhooksByWebhookIdDataSchema = z.object({
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const getV2WebhooksByWebhookIdResponseSchema = z.object({
  data: z.object({
    target_url: z.string(),
    subscriptions: z.array(
      z.object({
        event_type: z.union([
          z.literal('comment.created'),
          z.literal('comment.resolved'),
          z.literal('comment.unresolved'),
          z.literal('comment.deleted'),
          z.literal('list.created'),
          z.literal('list.updated'),
          z.literal('list.deleted'),
          z.literal('list-attribute.created'),
          z.literal('list-attribute.updated'),
          z.literal('list-entry.created'),
          z.literal('list-entry.updated'),
          z.literal('list-entry.deleted'),
          z.literal('object-attribute.created'),
          z.literal('object-attribute.updated'),
          z.literal('note.created'),
          z.literal('note.updated'),
          z.literal('note.deleted'),
          z.literal('record.created'),
          z.literal('record.merged'),
          z.literal('record.updated'),
          z.literal('record.deleted'),
          z.literal('task.created'),
          z.literal('task.updated'),
          z.literal('task.deleted'),
          z.literal('workspace-member.created'),
        ]),
        filter: z
          .union([
            z.object({
              $or: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
            z.object({
              $and: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
          ])
          .nullable(),
      }),
    ),
    id: z.object({
      workspace_id: z.string(),
      webhook_id: z.string(),
    }),
    status: z.union([z.literal('active'), z.literal('degraded'), z.literal('inactive')]),
    created_at: z.string(),
  }),
});

export const getV2WebhooksByWebhookIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const patchV2WebhooksByWebhookIdDataSchema = z.object({
  body: z.object({
    data: z.object({
      target_url: z.string().optional(),
      subscriptions: z
        .array(
          z.object({
            event_type: z.union([
              z.literal('comment.created'),
              z.literal('comment.resolved'),
              z.literal('comment.unresolved'),
              z.literal('comment.deleted'),
              z.literal('list.created'),
              z.literal('list.updated'),
              z.literal('list.deleted'),
              z.literal('list-attribute.created'),
              z.literal('list-attribute.updated'),
              z.literal('list-entry.created'),
              z.literal('list-entry.updated'),
              z.literal('list-entry.deleted'),
              z.literal('object-attribute.created'),
              z.literal('object-attribute.updated'),
              z.literal('note.created'),
              z.literal('note.updated'),
              z.literal('note.deleted'),
              z.literal('record.created'),
              z.literal('record.merged'),
              z.literal('record.updated'),
              z.literal('record.deleted'),
              z.literal('task.created'),
              z.literal('task.updated'),
              z.literal('task.deleted'),
              z.literal('workspace-member.created'),
            ]),
            filter: z
              .union([
                z.object({
                  $or: z.array(
                    z.union([
                      z.object({
                        field: z.string(),
                        operator: z.literal('equals'),
                        value: z.string(),
                      }),
                      z.object({
                        field: z.string(),
                        operator: z.literal('not_equals'),
                        value: z.string(),
                      }),
                    ]),
                  ),
                }),
                z.object({
                  $and: z.array(
                    z.union([
                      z.object({
                        field: z.string(),
                        operator: z.literal('equals'),
                        value: z.string(),
                      }),
                      z.object({
                        field: z.string(),
                        operator: z.literal('not_equals'),
                        value: z.string(),
                      }),
                    ]),
                  ),
                }),
              ])
              .nullable(),
          }),
        )
        .optional(),
    }),
  }),
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const patchV2WebhooksByWebhookIdResponseSchema = z.object({
  data: z.object({
    target_url: z.string(),
    subscriptions: z.array(
      z.object({
        event_type: z.union([
          z.literal('comment.created'),
          z.literal('comment.resolved'),
          z.literal('comment.unresolved'),
          z.literal('comment.deleted'),
          z.literal('list.created'),
          z.literal('list.updated'),
          z.literal('list.deleted'),
          z.literal('list-attribute.created'),
          z.literal('list-attribute.updated'),
          z.literal('list-entry.created'),
          z.literal('list-entry.updated'),
          z.literal('list-entry.deleted'),
          z.literal('object-attribute.created'),
          z.literal('object-attribute.updated'),
          z.literal('note.created'),
          z.literal('note.updated'),
          z.literal('note.deleted'),
          z.literal('record.created'),
          z.literal('record.merged'),
          z.literal('record.updated'),
          z.literal('record.deleted'),
          z.literal('task.created'),
          z.literal('task.updated'),
          z.literal('task.deleted'),
          z.literal('workspace-member.created'),
        ]),
        filter: z
          .union([
            z.object({
              $or: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
            z.object({
              $and: z.array(
                z.union([
                  z.object({
                    field: z.string(),
                    operator: z.literal('equals'),
                    value: z.string(),
                  }),
                  z.object({
                    field: z.string(),
                    operator: z.literal('not_equals'),
                    value: z.string(),
                  }),
                ]),
              ),
            }),
          ])
          .nullable(),
      }),
    ),
    id: z.object({
      workspace_id: z.string(),
      webhook_id: z.string(),
    }),
    status: z.union([z.literal('active'), z.literal('degraded'), z.literal('inactive')]),
    created_at: z.string(),
  }),
});

export const patchV2WebhooksByWebhookIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const deleteV2WebhooksByWebhookIdDataSchema = z.object({
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const deleteV2WebhooksByWebhookIdResponseSchema = z.record(z.unknown());

export const deleteV2WebhooksByWebhookIdErrorSchema = z.object({
  status_code: z.literal(404),
  type: z.literal('invalid_request_error'),
  code: z.literal('not_found'),
  message: z.string(),
});

export const getV2SelfResponseSchema = z.union([
  z.object({
    active: z.boolean(),
  }),
  z.object({
    active: z.boolean(),
    scope: z.string(),
    client_id: z.string(),
    token_type: z.literal('Bearer'),
    exp: z.number().nullable(),
    iat: z.number(),
    sub: z.string(),
    aud: z.string(),
    iss: z.literal('attio.com'),
    authorized_by_workspace_member_id: z.string().nullable(),
    workspace_id: z.string(),
    workspace_name: z.string(),
    workspace_slug: z.string(),
    workspace_logo_url: z.string().nullable(),
  }),
]);

export const getV2SelfErrorSchema = z.unknown();
