// This file is auto-generated by @hey-api/openapi-ts

export type status = {
  id: {
    /**
     * The ID of the workspace
     */
    workspace_id: string;
    /**
     * The ID of the object
     */
    object_id: string;
    /**
     * The ID of the attribute
     */
    attribute_id: string;
    /**
     * The ID of the status
     */
    status_id: string;
  };
  /**
   * The title of the status
   */
  title: string;
  /**
   * Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving.
   */
  is_archived: boolean;
  /**
   * Whether arriving at this status triggers a celebration effect in the UI
   */
  celebration_enabled: boolean;
  /**
   * Target time for a record to spend in given status expressed as a ISO-8601 duration string
   */
  target_time_in_status: string | null;
};

export type select_option = {
  id: {
    /**
     * The ID of the workspace
     */
    workspace_id: string;
    /**
     * The ID of the object
     */
    object_id: string;
    /**
     * The ID of the attribute
     */
    attribute_id: string;
    /**
     * The ID of the select option
     */
    option_id: string;
  };
  /**
   * The title of the select option
   */
  title: string;
  /**
   * Whether or not to archive the select option. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving.
   */
  is_archived: boolean;
};

/**
 * A union of possible value types, as required in request bodies.
 */
export type input_value =
  | {
      /**
       * The type of the referenced actor. Currently, only workspace members can be written into actor reference attributes. [Read more information on actor types here](/docs/actors).
       */
      referenced_actor_type: 'workspace-member';
      /**
       * The ID of the referenced Actor.
       */
      referenced_actor_id: string;
    }
  | {
      /**
       * Workspace member actors can be referenced by email address as well as actor ID.
       */
      workspace_member_email_address: string;
    }
  | {
      /**
       * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
       */
      value: boolean;
    }
  | {
      /**
       * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
       */
      currency_value: number;
    }
  | {
      /**
       * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
       */
      value: string;
    }
  | {
      /**
       * The full domain of the website.
       */
      domain?: string;
    }
  | {
      /**
       * An email address string
       */
      email_address?: string;
    }
  | {
      /**
       * A UUID or slug to identify the object that the referenced record belongs to.
       */
      target_object: string;
      /**
       * A UUID to identify the referenced record.
       */
      target_record_id: string;
    }
  | {
      /**
       * A UUID or slug to identify the object that the referenced record belongs to.
       */
      target_object: string;
      /**
       * In addition to referencing records directly by record ID, you may also reference by a matching attribute of your choice. For example, if you want to add a reference to the person record with email "alice@website.com", you should pass a value with `target_object` set to `"people"` and `email_addresses` set to `[{email_address:"alice@website.com"}]`. The key should be the slug or ID of the matching attribute you would like to use and the value should be an array containing a single value of the appropriate attribute type (as specified below). Matching on multiple values is not currently supported. Matching attributes must be unique. This process is similar to how you use the `matching_attribute` query param in Attio's [assert endpoints](/reference/put_v2-objects-object-records).
       */
      '[slug_or_id_of_matching_attribute]': Array<
        | {
            /**
             * The full domain of the website.
             */
            domain?: string;
          }
        | {
            /**
             * An email address string
             */
            email_address?: string;
          }
        | {
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value?: number;
          }
        | {
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number?: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code?:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
          }
        | {
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value?: string;
          }
      >;
    }
  | {
      /**
       * The type of interaction e.g. calendar or email.
       */
      interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
      /**
       * When the interaction occurred.
       */
      interacted_at: string;
      /**
       * The actor that created this value.
       */
      owner_actor: {
        /**
         * An ID to identify the actor.
         */
        id?: string | null;
        /**
         * The type of actor. [Read more information on actor types here](/docs/actors).
         */
        type?: ('api-token' | 'workspace-member' | 'system') | null;
      };
    }
  | {
      /**
       * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_1: string | null;
      /**
       * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_2: string | null;
      /**
       * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_3: string | null;
      /**
       * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_4: string | null;
      /**
       * The town, neighborhood or area the location is in.
       */
      locality: string | null;
      /**
       * The state, county, province or region that the location is in.
       */
      region: string | null;
      /**
       * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
       */
      postcode: string | null;
      /**
       * The ISO 3166-1 alpha-2 country code for the country this location is in.
       */
      country_code:
        | (
            | 'AF'
            | 'AX'
            | 'AL'
            | 'DZ'
            | 'AS'
            | 'AD'
            | 'AO'
            | 'AI'
            | 'AQ'
            | 'AG'
            | 'AR'
            | 'AM'
            | 'AW'
            | 'AU'
            | 'AT'
            | 'AZ'
            | 'BS'
            | 'BH'
            | 'BD'
            | 'BB'
            | 'BY'
            | 'BE'
            | 'BZ'
            | 'BJ'
            | 'BM'
            | 'BT'
            | 'BO'
            | 'BA'
            | 'BW'
            | 'BV'
            | 'BR'
            | 'IO'
            | 'BN'
            | 'BG'
            | 'BF'
            | 'BI'
            | 'KH'
            | 'CM'
            | 'CA'
            | 'CV'
            | 'KY'
            | 'CF'
            | 'TD'
            | 'CL'
            | 'CN'
            | 'CX'
            | 'CC'
            | 'CO'
            | 'KM'
            | 'CG'
            | 'CD'
            | 'CK'
            | 'CR'
            | 'CI'
            | 'HR'
            | 'CU'
            | 'CW'
            | 'CY'
            | 'CZ'
            | 'DK'
            | 'DJ'
            | 'DM'
            | 'DO'
            | 'EC'
            | 'EG'
            | 'SV'
            | 'GQ'
            | 'ER'
            | 'EE'
            | 'ET'
            | 'FK'
            | 'FO'
            | 'FJ'
            | 'FI'
            | 'FR'
            | 'GF'
            | 'PF'
            | 'TF'
            | 'GA'
            | 'GM'
            | 'GE'
            | 'DE'
            | 'GH'
            | 'GI'
            | 'GR'
            | 'GL'
            | 'GD'
            | 'GP'
            | 'GU'
            | 'GT'
            | 'GG'
            | 'GN'
            | 'GW'
            | 'GY'
            | 'HT'
            | 'HM'
            | 'VA'
            | 'HN'
            | 'HK'
            | 'HU'
            | 'IS'
            | 'IN'
            | 'ID'
            | 'IR'
            | 'IQ'
            | 'IE'
            | 'IM'
            | 'IL'
            | 'IT'
            | 'JM'
            | 'JP'
            | 'JE'
            | 'JO'
            | 'KZ'
            | 'KE'
            | 'KI'
            | 'KR'
            | 'KW'
            | 'KG'
            | 'LA'
            | 'LV'
            | 'LB'
            | 'LS'
            | 'LR'
            | 'LY'
            | 'LI'
            | 'LT'
            | 'LU'
            | 'MO'
            | 'MK'
            | 'MG'
            | 'MW'
            | 'MY'
            | 'MV'
            | 'ML'
            | 'MT'
            | 'MH'
            | 'MQ'
            | 'MR'
            | 'MU'
            | 'YT'
            | 'MX'
            | 'FM'
            | 'MD'
            | 'MC'
            | 'MN'
            | 'ME'
            | 'MS'
            | 'MA'
            | 'MZ'
            | 'MM'
            | 'NA'
            | 'NR'
            | 'NP'
            | 'NL'
            | 'AN'
            | 'NC'
            | 'NZ'
            | 'NI'
            | 'NE'
            | 'NG'
            | 'NU'
            | 'NF'
            | 'MP'
            | 'NO'
            | 'OM'
            | 'PK'
            | 'PW'
            | 'PS'
            | 'PA'
            | 'PG'
            | 'PY'
            | 'PE'
            | 'PH'
            | 'PN'
            | 'PL'
            | 'PT'
            | 'PR'
            | 'QA'
            | 'RE'
            | 'RO'
            | 'RU'
            | 'RW'
            | 'BL'
            | 'SH'
            | 'KN'
            | 'LC'
            | 'MF'
            | 'PM'
            | 'VC'
            | 'WS'
            | 'SM'
            | 'ST'
            | 'SA'
            | 'SN'
            | 'RS'
            | 'SC'
            | 'SL'
            | 'SG'
            | 'SK'
            | 'SI'
            | 'SB'
            | 'SO'
            | 'ZA'
            | 'GS'
            | 'ES'
            | 'LK'
            | 'SD'
            | 'SR'
            | 'SJ'
            | 'SZ'
            | 'SE'
            | 'CH'
            | 'SY'
            | 'TW'
            | 'TJ'
            | 'TZ'
            | 'TH'
            | 'TL'
            | 'TG'
            | 'TK'
            | 'TO'
            | 'TT'
            | 'TN'
            | 'TR'
            | 'TM'
            | 'TC'
            | 'TV'
            | 'UG'
            | 'UA'
            | 'AE'
            | 'GB'
            | 'US'
            | 'UM'
            | 'UY'
            | 'UZ'
            | 'VU'
            | 'VE'
            | 'VN'
            | 'VG'
            | 'VI'
            | 'WF'
            | 'EH'
            | 'YE'
            | 'ZM'
            | 'ZW'
          )
        | null;
      /**
       * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
       */
      latitude: string | null;
      /**
       * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
       */
      longitude: string | null;
    }
  | {
      /**
       * Numbers are persisted as 64 bit floats.
       */
      value: number;
    }
  | {
      /**
       * The first name.
       */
      first_name?: string;
      /**
       * The last name.
       */
      last_name?: string;
      /**
       * The full name.
       */
      full_name?: string;
    }
  | {
      /**
       * A phone number which is either a) prefixed with a country code (e.g. `+44....`) or b) a local number, where `country_code` is specified in addition.
       */
      original_phone_number: string;
      /**
       * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to. Optional if `original_phone_number` includes a country code prefix.
       */
      country_code?:
        | (
            | 'AF'
            | 'AX'
            | 'AL'
            | 'DZ'
            | 'AS'
            | 'AD'
            | 'AO'
            | 'AI'
            | 'AQ'
            | 'AG'
            | 'AR'
            | 'AM'
            | 'AW'
            | 'AU'
            | 'AT'
            | 'AZ'
            | 'BS'
            | 'BH'
            | 'BD'
            | 'BB'
            | 'BY'
            | 'BE'
            | 'BZ'
            | 'BJ'
            | 'BM'
            | 'BT'
            | 'BO'
            | 'BA'
            | 'BW'
            | 'BV'
            | 'BR'
            | 'IO'
            | 'BN'
            | 'BG'
            | 'BF'
            | 'BI'
            | 'KH'
            | 'CM'
            | 'CA'
            | 'CV'
            | 'KY'
            | 'CF'
            | 'TD'
            | 'CL'
            | 'CN'
            | 'CX'
            | 'CC'
            | 'CO'
            | 'KM'
            | 'CG'
            | 'CD'
            | 'CK'
            | 'CR'
            | 'CI'
            | 'HR'
            | 'CU'
            | 'CW'
            | 'CY'
            | 'CZ'
            | 'DK'
            | 'DJ'
            | 'DM'
            | 'DO'
            | 'EC'
            | 'EG'
            | 'SV'
            | 'GQ'
            | 'ER'
            | 'EE'
            | 'ET'
            | 'FK'
            | 'FO'
            | 'FJ'
            | 'FI'
            | 'FR'
            | 'GF'
            | 'PF'
            | 'TF'
            | 'GA'
            | 'GM'
            | 'GE'
            | 'DE'
            | 'GH'
            | 'GI'
            | 'GR'
            | 'GL'
            | 'GD'
            | 'GP'
            | 'GU'
            | 'GT'
            | 'GG'
            | 'GN'
            | 'GW'
            | 'GY'
            | 'HT'
            | 'HM'
            | 'VA'
            | 'HN'
            | 'HK'
            | 'HU'
            | 'IS'
            | 'IN'
            | 'ID'
            | 'IR'
            | 'IQ'
            | 'IE'
            | 'IM'
            | 'IL'
            | 'IT'
            | 'JM'
            | 'JP'
            | 'JE'
            | 'JO'
            | 'KZ'
            | 'KE'
            | 'KI'
            | 'KR'
            | 'KW'
            | 'KG'
            | 'LA'
            | 'LV'
            | 'LB'
            | 'LS'
            | 'LR'
            | 'LY'
            | 'LI'
            | 'LT'
            | 'LU'
            | 'MO'
            | 'MK'
            | 'MG'
            | 'MW'
            | 'MY'
            | 'MV'
            | 'ML'
            | 'MT'
            | 'MH'
            | 'MQ'
            | 'MR'
            | 'MU'
            | 'YT'
            | 'MX'
            | 'FM'
            | 'MD'
            | 'MC'
            | 'MN'
            | 'ME'
            | 'MS'
            | 'MA'
            | 'MZ'
            | 'MM'
            | 'NA'
            | 'NR'
            | 'NP'
            | 'NL'
            | 'AN'
            | 'NC'
            | 'NZ'
            | 'NI'
            | 'NE'
            | 'NG'
            | 'NU'
            | 'NF'
            | 'MP'
            | 'NO'
            | 'OM'
            | 'PK'
            | 'PW'
            | 'PS'
            | 'PA'
            | 'PG'
            | 'PY'
            | 'PE'
            | 'PH'
            | 'PN'
            | 'PL'
            | 'PT'
            | 'PR'
            | 'QA'
            | 'RE'
            | 'RO'
            | 'RU'
            | 'RW'
            | 'BL'
            | 'SH'
            | 'KN'
            | 'LC'
            | 'MF'
            | 'PM'
            | 'VC'
            | 'WS'
            | 'SM'
            | 'ST'
            | 'SA'
            | 'SN'
            | 'RS'
            | 'SC'
            | 'SL'
            | 'SG'
            | 'SK'
            | 'SI'
            | 'SB'
            | 'SO'
            | 'ZA'
            | 'GS'
            | 'ES'
            | 'LK'
            | 'SD'
            | 'SR'
            | 'SJ'
            | 'SZ'
            | 'SE'
            | 'CH'
            | 'SY'
            | 'TW'
            | 'TJ'
            | 'TZ'
            | 'TH'
            | 'TL'
            | 'TG'
            | 'TK'
            | 'TO'
            | 'TT'
            | 'TN'
            | 'TR'
            | 'TM'
            | 'TC'
            | 'TV'
            | 'UG'
            | 'UA'
            | 'AE'
            | 'GB'
            | 'US'
            | 'UM'
            | 'UY'
            | 'UZ'
            | 'VU'
            | 'VE'
            | 'VN'
            | 'VG'
            | 'VI'
            | 'WF'
            | 'EH'
            | 'YE'
            | 'ZM'
            | 'ZW'
          )
        | null;
    }
  | {
      /**
       * The UUID or status title identifying the selected status.
       */
      status: string;
    }
  | {
      /**
       * A number between 0 and 5 (inclusive) to represent a star rating.
       */
      value: number;
    }
  | {
      /**
       * The UUID or select option title identifying the selected select option.
       */
      option: string;
    }
  | {
      /**
       * A raw text field. Values are limited to 10MB.
       */
      value: string;
    }
  | {
      /**
       * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
       */
      value: string;
    };

/**
 * The type of the referenced actor. Currently, only workspace members can be written into actor reference attributes. [Read more information on actor types here](/docs/actors).
 */
export type referenced_actor_type = 'workspace-member';

/**
 * The type of interaction e.g. calendar or email.
 */
export type interaction_type = 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';

/**
 * The type of actor. [Read more information on actor types here](/docs/actors).
 */
export type type = 'api-token' | 'workspace-member' | 'system';

/**
 * The ISO 3166-1 alpha-2 country code for the country this location is in.
 */
export type country_code =
  | 'AF'
  | 'AX'
  | 'AL'
  | 'DZ'
  | 'AS'
  | 'AD'
  | 'AO'
  | 'AI'
  | 'AQ'
  | 'AG'
  | 'AR'
  | 'AM'
  | 'AW'
  | 'AU'
  | 'AT'
  | 'AZ'
  | 'BS'
  | 'BH'
  | 'BD'
  | 'BB'
  | 'BY'
  | 'BE'
  | 'BZ'
  | 'BJ'
  | 'BM'
  | 'BT'
  | 'BO'
  | 'BA'
  | 'BW'
  | 'BV'
  | 'BR'
  | 'IO'
  | 'BN'
  | 'BG'
  | 'BF'
  | 'BI'
  | 'KH'
  | 'CM'
  | 'CA'
  | 'CV'
  | 'KY'
  | 'CF'
  | 'TD'
  | 'CL'
  | 'CN'
  | 'CX'
  | 'CC'
  | 'CO'
  | 'KM'
  | 'CG'
  | 'CD'
  | 'CK'
  | 'CR'
  | 'CI'
  | 'HR'
  | 'CU'
  | 'CW'
  | 'CY'
  | 'CZ'
  | 'DK'
  | 'DJ'
  | 'DM'
  | 'DO'
  | 'EC'
  | 'EG'
  | 'SV'
  | 'GQ'
  | 'ER'
  | 'EE'
  | 'ET'
  | 'FK'
  | 'FO'
  | 'FJ'
  | 'FI'
  | 'FR'
  | 'GF'
  | 'PF'
  | 'TF'
  | 'GA'
  | 'GM'
  | 'GE'
  | 'DE'
  | 'GH'
  | 'GI'
  | 'GR'
  | 'GL'
  | 'GD'
  | 'GP'
  | 'GU'
  | 'GT'
  | 'GG'
  | 'GN'
  | 'GW'
  | 'GY'
  | 'HT'
  | 'HM'
  | 'VA'
  | 'HN'
  | 'HK'
  | 'HU'
  | 'IS'
  | 'IN'
  | 'ID'
  | 'IR'
  | 'IQ'
  | 'IE'
  | 'IM'
  | 'IL'
  | 'IT'
  | 'JM'
  | 'JP'
  | 'JE'
  | 'JO'
  | 'KZ'
  | 'KE'
  | 'KI'
  | 'KR'
  | 'KW'
  | 'KG'
  | 'LA'
  | 'LV'
  | 'LB'
  | 'LS'
  | 'LR'
  | 'LY'
  | 'LI'
  | 'LT'
  | 'LU'
  | 'MO'
  | 'MK'
  | 'MG'
  | 'MW'
  | 'MY'
  | 'MV'
  | 'ML'
  | 'MT'
  | 'MH'
  | 'MQ'
  | 'MR'
  | 'MU'
  | 'YT'
  | 'MX'
  | 'FM'
  | 'MD'
  | 'MC'
  | 'MN'
  | 'ME'
  | 'MS'
  | 'MA'
  | 'MZ'
  | 'MM'
  | 'NA'
  | 'NR'
  | 'NP'
  | 'NL'
  | 'AN'
  | 'NC'
  | 'NZ'
  | 'NI'
  | 'NE'
  | 'NG'
  | 'NU'
  | 'NF'
  | 'MP'
  | 'NO'
  | 'OM'
  | 'PK'
  | 'PW'
  | 'PS'
  | 'PA'
  | 'PG'
  | 'PY'
  | 'PE'
  | 'PH'
  | 'PN'
  | 'PL'
  | 'PT'
  | 'PR'
  | 'QA'
  | 'RE'
  | 'RO'
  | 'RU'
  | 'RW'
  | 'BL'
  | 'SH'
  | 'KN'
  | 'LC'
  | 'MF'
  | 'PM'
  | 'VC'
  | 'WS'
  | 'SM'
  | 'ST'
  | 'SA'
  | 'SN'
  | 'RS'
  | 'SC'
  | 'SL'
  | 'SG'
  | 'SK'
  | 'SI'
  | 'SB'
  | 'SO'
  | 'ZA'
  | 'GS'
  | 'ES'
  | 'LK'
  | 'SD'
  | 'SR'
  | 'SJ'
  | 'SZ'
  | 'SE'
  | 'CH'
  | 'SY'
  | 'TW'
  | 'TJ'
  | 'TZ'
  | 'TH'
  | 'TL'
  | 'TG'
  | 'TK'
  | 'TO'
  | 'TT'
  | 'TN'
  | 'TR'
  | 'TM'
  | 'TC'
  | 'TV'
  | 'UG'
  | 'UA'
  | 'AE'
  | 'GB'
  | 'US'
  | 'UM'
  | 'UY'
  | 'UZ'
  | 'VU'
  | 'VE'
  | 'VN'
  | 'VG'
  | 'VI'
  | 'WF'
  | 'EH'
  | 'YE'
  | 'ZM'
  | 'ZW';

/**
 * A union of possible value types, as returned in response bodies.
 */
export type output_value =
  | {
      /**
       * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
       */
      referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
      /**
       * The ID of the referenced actor.
       */
      referenced_actor_id: string | null;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'actor-reference';
    }
  | {
      /**
       * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
       */
      value: boolean;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'checkbox';
    }
  | {
      /**
       * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
       */
      currency_value: number;
      /**
       * The ISO4217 currency code representing the currency that the value is stored in.
       */
      currency_code?:
        | (
            | 'EUR'
            | 'GBP'
            | 'USD'
            | 'CAD'
            | 'AUD'
            | 'NZD'
            | 'AED'
            | 'INR'
            | 'CHF'
            | 'JPY'
            | 'CNY'
            | 'PHP'
            | 'ILS'
            | 'SGD'
            | 'HKD'
            | 'MYR'
            | 'NTD'
            | 'NOK'
            | 'SEK'
            | 'ISK'
            | 'BEL'
            | 'PLN'
            | 'KRW'
            | 'DKK'
            | 'BRL'
          )
        | null;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'currency';
    }
  | {
      /**
       * The attribute type of the value.
       */
      attribute_type: 'date';
      /**
       * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
       */
      value: string;
    }
  | {
      domain: string;
      root_domain: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'domain';
    }
  | {
      original_email_address: string;
      email_address: string;
      email_domain: string;
      email_root_domain: string;
      email_local_specifier: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'email-address';
    }
  | {
      /**
       * A slug identifying the object that the referenced record belongs to.
       */
      target_object: string;
      /**
       * A UUID to identify the referenced record.
       */
      target_record_id: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'record-reference';
    }
  | {
      /**
       * The type of interaction e.g. calendar or email.
       */
      interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
      /**
       * When the interaction occurred.
       */
      interacted_at: string;
      /**
       * The actor that created this value.
       */
      owner_actor: {
        /**
         * An ID to identify the actor.
         */
        id?: string | null;
        /**
         * The type of actor. [Read more information on actor types here](/docs/actors).
         */
        type?: ('api-token' | 'workspace-member' | 'system') | null;
      };
      /**
       * The attribute type of the value.
       */
      attribute_type: 'interaction';
    }
  | {
      /**
       * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_1: string | null;
      /**
       * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_2: string | null;
      /**
       * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_3: string | null;
      /**
       * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
       */
      line_4: string | null;
      /**
       * The town, neighborhood or area the location is in.
       */
      locality: string | null;
      /**
       * The state, county, province or region that the location is in.
       */
      region: string | null;
      /**
       * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
       */
      postcode: string | null;
      /**
       * The ISO 3166-1 alpha-2 country code for the country this location is in.
       */
      country_code:
        | (
            | 'AF'
            | 'AX'
            | 'AL'
            | 'DZ'
            | 'AS'
            | 'AD'
            | 'AO'
            | 'AI'
            | 'AQ'
            | 'AG'
            | 'AR'
            | 'AM'
            | 'AW'
            | 'AU'
            | 'AT'
            | 'AZ'
            | 'BS'
            | 'BH'
            | 'BD'
            | 'BB'
            | 'BY'
            | 'BE'
            | 'BZ'
            | 'BJ'
            | 'BM'
            | 'BT'
            | 'BO'
            | 'BA'
            | 'BW'
            | 'BV'
            | 'BR'
            | 'IO'
            | 'BN'
            | 'BG'
            | 'BF'
            | 'BI'
            | 'KH'
            | 'CM'
            | 'CA'
            | 'CV'
            | 'KY'
            | 'CF'
            | 'TD'
            | 'CL'
            | 'CN'
            | 'CX'
            | 'CC'
            | 'CO'
            | 'KM'
            | 'CG'
            | 'CD'
            | 'CK'
            | 'CR'
            | 'CI'
            | 'HR'
            | 'CU'
            | 'CW'
            | 'CY'
            | 'CZ'
            | 'DK'
            | 'DJ'
            | 'DM'
            | 'DO'
            | 'EC'
            | 'EG'
            | 'SV'
            | 'GQ'
            | 'ER'
            | 'EE'
            | 'ET'
            | 'FK'
            | 'FO'
            | 'FJ'
            | 'FI'
            | 'FR'
            | 'GF'
            | 'PF'
            | 'TF'
            | 'GA'
            | 'GM'
            | 'GE'
            | 'DE'
            | 'GH'
            | 'GI'
            | 'GR'
            | 'GL'
            | 'GD'
            | 'GP'
            | 'GU'
            | 'GT'
            | 'GG'
            | 'GN'
            | 'GW'
            | 'GY'
            | 'HT'
            | 'HM'
            | 'VA'
            | 'HN'
            | 'HK'
            | 'HU'
            | 'IS'
            | 'IN'
            | 'ID'
            | 'IR'
            | 'IQ'
            | 'IE'
            | 'IM'
            | 'IL'
            | 'IT'
            | 'JM'
            | 'JP'
            | 'JE'
            | 'JO'
            | 'KZ'
            | 'KE'
            | 'KI'
            | 'KR'
            | 'KW'
            | 'KG'
            | 'LA'
            | 'LV'
            | 'LB'
            | 'LS'
            | 'LR'
            | 'LY'
            | 'LI'
            | 'LT'
            | 'LU'
            | 'MO'
            | 'MK'
            | 'MG'
            | 'MW'
            | 'MY'
            | 'MV'
            | 'ML'
            | 'MT'
            | 'MH'
            | 'MQ'
            | 'MR'
            | 'MU'
            | 'YT'
            | 'MX'
            | 'FM'
            | 'MD'
            | 'MC'
            | 'MN'
            | 'ME'
            | 'MS'
            | 'MA'
            | 'MZ'
            | 'MM'
            | 'NA'
            | 'NR'
            | 'NP'
            | 'NL'
            | 'AN'
            | 'NC'
            | 'NZ'
            | 'NI'
            | 'NE'
            | 'NG'
            | 'NU'
            | 'NF'
            | 'MP'
            | 'NO'
            | 'OM'
            | 'PK'
            | 'PW'
            | 'PS'
            | 'PA'
            | 'PG'
            | 'PY'
            | 'PE'
            | 'PH'
            | 'PN'
            | 'PL'
            | 'PT'
            | 'PR'
            | 'QA'
            | 'RE'
            | 'RO'
            | 'RU'
            | 'RW'
            | 'BL'
            | 'SH'
            | 'KN'
            | 'LC'
            | 'MF'
            | 'PM'
            | 'VC'
            | 'WS'
            | 'SM'
            | 'ST'
            | 'SA'
            | 'SN'
            | 'RS'
            | 'SC'
            | 'SL'
            | 'SG'
            | 'SK'
            | 'SI'
            | 'SB'
            | 'SO'
            | 'ZA'
            | 'GS'
            | 'ES'
            | 'LK'
            | 'SD'
            | 'SR'
            | 'SJ'
            | 'SZ'
            | 'SE'
            | 'CH'
            | 'SY'
            | 'TW'
            | 'TJ'
            | 'TZ'
            | 'TH'
            | 'TL'
            | 'TG'
            | 'TK'
            | 'TO'
            | 'TT'
            | 'TN'
            | 'TR'
            | 'TM'
            | 'TC'
            | 'TV'
            | 'UG'
            | 'UA'
            | 'AE'
            | 'GB'
            | 'US'
            | 'UM'
            | 'UY'
            | 'UZ'
            | 'VU'
            | 'VE'
            | 'VN'
            | 'VG'
            | 'VI'
            | 'WF'
            | 'EH'
            | 'YE'
            | 'ZM'
            | 'ZW'
          )
        | null;
      /**
       * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
       */
      latitude: string | null;
      /**
       * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
       */
      longitude: string | null;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'location';
    }
  | {
      /**
       * Numbers are persisted as 64 bit floats.
       */
      value: number;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'number';
    }
  | {
      /**
       * The first name.
       */
      first_name: string;
      /**
       * The last name.
       */
      last_name: string;
      /**
       * The full name.
       */
      full_name: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'personal-name';
    }
  | {
      /**
       * The raw, original phone number, as inputted.
       */
      original_phone_number: string;
      /**
       * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
       */
      country_code:
        | 'AF'
        | 'AX'
        | 'AL'
        | 'DZ'
        | 'AS'
        | 'AD'
        | 'AO'
        | 'AI'
        | 'AQ'
        | 'AG'
        | 'AR'
        | 'AM'
        | 'AW'
        | 'AU'
        | 'AT'
        | 'AZ'
        | 'BS'
        | 'BH'
        | 'BD'
        | 'BB'
        | 'BY'
        | 'BE'
        | 'BZ'
        | 'BJ'
        | 'BM'
        | 'BT'
        | 'BO'
        | 'BA'
        | 'BW'
        | 'BV'
        | 'BR'
        | 'IO'
        | 'BN'
        | 'BG'
        | 'BF'
        | 'BI'
        | 'KH'
        | 'CM'
        | 'CA'
        | 'CV'
        | 'KY'
        | 'CF'
        | 'TD'
        | 'CL'
        | 'CN'
        | 'CX'
        | 'CC'
        | 'CO'
        | 'KM'
        | 'CG'
        | 'CD'
        | 'CK'
        | 'CR'
        | 'CI'
        | 'HR'
        | 'CU'
        | 'CW'
        | 'CY'
        | 'CZ'
        | 'DK'
        | 'DJ'
        | 'DM'
        | 'DO'
        | 'EC'
        | 'EG'
        | 'SV'
        | 'GQ'
        | 'ER'
        | 'EE'
        | 'ET'
        | 'FK'
        | 'FO'
        | 'FJ'
        | 'FI'
        | 'FR'
        | 'GF'
        | 'PF'
        | 'TF'
        | 'GA'
        | 'GM'
        | 'GE'
        | 'DE'
        | 'GH'
        | 'GI'
        | 'GR'
        | 'GL'
        | 'GD'
        | 'GP'
        | 'GU'
        | 'GT'
        | 'GG'
        | 'GN'
        | 'GW'
        | 'GY'
        | 'HT'
        | 'HM'
        | 'VA'
        | 'HN'
        | 'HK'
        | 'HU'
        | 'IS'
        | 'IN'
        | 'ID'
        | 'IR'
        | 'IQ'
        | 'IE'
        | 'IM'
        | 'IL'
        | 'IT'
        | 'JM'
        | 'JP'
        | 'JE'
        | 'JO'
        | 'KZ'
        | 'KE'
        | 'KI'
        | 'KR'
        | 'KW'
        | 'KG'
        | 'LA'
        | 'LV'
        | 'LB'
        | 'LS'
        | 'LR'
        | 'LY'
        | 'LI'
        | 'LT'
        | 'LU'
        | 'MO'
        | 'MK'
        | 'MG'
        | 'MW'
        | 'MY'
        | 'MV'
        | 'ML'
        | 'MT'
        | 'MH'
        | 'MQ'
        | 'MR'
        | 'MU'
        | 'YT'
        | 'MX'
        | 'FM'
        | 'MD'
        | 'MC'
        | 'MN'
        | 'ME'
        | 'MS'
        | 'MA'
        | 'MZ'
        | 'MM'
        | 'NA'
        | 'NR'
        | 'NP'
        | 'NL'
        | 'AN'
        | 'NC'
        | 'NZ'
        | 'NI'
        | 'NE'
        | 'NG'
        | 'NU'
        | 'NF'
        | 'MP'
        | 'NO'
        | 'OM'
        | 'PK'
        | 'PW'
        | 'PS'
        | 'PA'
        | 'PG'
        | 'PY'
        | 'PE'
        | 'PH'
        | 'PN'
        | 'PL'
        | 'PT'
        | 'PR'
        | 'QA'
        | 'RE'
        | 'RO'
        | 'RU'
        | 'RW'
        | 'BL'
        | 'SH'
        | 'KN'
        | 'LC'
        | 'MF'
        | 'PM'
        | 'VC'
        | 'WS'
        | 'SM'
        | 'ST'
        | 'SA'
        | 'SN'
        | 'RS'
        | 'SC'
        | 'SL'
        | 'SG'
        | 'SK'
        | 'SI'
        | 'SB'
        | 'SO'
        | 'ZA'
        | 'GS'
        | 'ES'
        | 'LK'
        | 'SD'
        | 'SR'
        | 'SJ'
        | 'SZ'
        | 'SE'
        | 'CH'
        | 'SY'
        | 'TW'
        | 'TJ'
        | 'TZ'
        | 'TH'
        | 'TL'
        | 'TG'
        | 'TK'
        | 'TO'
        | 'TT'
        | 'TN'
        | 'TR'
        | 'TM'
        | 'TC'
        | 'TV'
        | 'UG'
        | 'UA'
        | 'AE'
        | 'GB'
        | 'US'
        | 'UM'
        | 'UY'
        | 'UZ'
        | 'VU'
        | 'VE'
        | 'VN'
        | 'VG'
        | 'VI'
        | 'WF'
        | 'EH'
        | 'YE'
        | 'ZM'
        | 'ZW';
      phone_number: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'phone-number';
    }
  | {
      /**
       * The UUID identifying the selected status.
       */
      status: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'status';
    }
  | {
      status: status;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'status';
    }
  | {
      /**
       * A number between 0 and 5 (inclusive) to represent a star rating.
       */
      value: number;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'rating';
    }
  | {
      /**
       * The UUID identifying the selected select option.
       */
      option: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'select';
    }
  | {
      option: select_option;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'select';
    }
  | {
      /**
       * A raw text field. Values are limited to 10MB.
       */
      value: string;
      /**
       * The attribute type of the value.
       */
      attribute_type: 'text';
    }
  | {
      /**
       * The attribute type of the value.
       */
      attribute_type: 'timestamp';
      /**
       * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
       */
      value: string;
    };

/**
 * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
 */
export type referenced_actor_type2 = 'api-token' | 'workspace-member' | 'system';

/**
 * The attribute type of the value.
 */
export type attribute_type = 'actor-reference';

/**
 * The ISO4217 currency code representing the currency that the value is stored in.
 */
export type currency_code =
  | 'EUR'
  | 'GBP'
  | 'USD'
  | 'CAD'
  | 'AUD'
  | 'NZD'
  | 'AED'
  | 'INR'
  | 'CHF'
  | 'JPY'
  | 'CNY'
  | 'PHP'
  | 'ILS'
  | 'SGD'
  | 'HKD'
  | 'MYR'
  | 'NTD'
  | 'NOK'
  | 'SEK'
  | 'ISK'
  | 'BEL'
  | 'PLN'
  | 'KRW'
  | 'DKK'
  | 'BRL';

export type attribute = {
  id: {
    /**
     * A UUID representing the workspace this attribute belongs to.
     */
    workspace_id: string;
    /**
     * A UUID to identify the object or list that this attribute belongs to
     */
    object_id: string;
    /**
     * A UUID to identify this attribute.
     */
    attribute_id: string;
  };
  /**
   * A title for the attribute, to be displayed across the app.
   */
  title: string;
  /**
   * A text description of the attribute.
   */
  description: string | null;
  /**
   * A unique slug for the attribute for use in API responses and URLs. Formatted in snake case.
   */
  api_slug: string;
  /**
   * The type of the attribute.
   */
  type:
    | 'text'
    | 'number'
    | 'checkbox'
    | 'currency'
    | 'date'
    | 'timestamp'
    | 'rating'
    | 'status'
    | 'select'
    | 'record-reference'
    | 'actor-reference'
    | 'location'
    | 'domain'
    | 'email-address'
    | 'phone-number'
    | 'interaction'
    | 'personal-name';
  /**
   * `true` if this is an Attio system-defined attribute, `false` if defined by a user or non-Attio system.
   */
  is_system_attribute: boolean;
  /**
   * Whether or not this attribute can be written to. Can only be false when `is_system_attribute` is `true` (user-defined attributes are always writeable). If `false`, this usually means the attribute is enriched by Attio.
   */
  is_writable: boolean;
  /**
   * When `is_required` is `true`, new records/entries must have a value for this attribute. If `false`, values may be `null`. This value does not affect existing data and you do not need to backfill `null` values if changing `is_required` from `false` to `true`.
   */
  is_required: boolean;
  /**
   * Whether or not new values for this attribute must be unique. Uniqueness restrictions are only applied to new data and do not apply retroactively to previously created data.
   */
  is_unique: boolean;
  /**
   * Whether or not this attribute can have multiple values. Multiselect is only available on some value types.
   */
  is_multiselect: boolean;
  /**
   * Whether this attribute has a default value enabled. Must be `true` when `is_required` is `true`.
   */
  is_default_value_enabled: boolean;
  /**
   * Whether this attribute has been archived. Archived attributes are hidden from most UI, but can be restored either over the API or in workspace settings. See the [guide on archiving and deleting](/docs/archiving-vs-deleting)for more information.
   */
  is_archived: boolean;
  /**
   * The default value for this attribute. Static values are used to directly populate values using their contents. Dynamic values are used to lookup data at the point of creation. For example, you could use a dynamic value to insert a value for the currently logged in user. Which default values are available is dependent on the type of the attribute.
   */
  default_value:
    | {
        type: 'dynamic';
        template: 'current-user' | string;
      }
    | {
        type: 'static';
        template: Array<output_value>;
      }
    | null;
  /**
   * If this attribute is related to another attribute, this is an object that includes an `id` property that identifies the other attribute. `null` means no relationship exists. See [the help center](https://attio.com/help/reference/managing-your-data/attributes#relationship-attributes) for more details about relationship attributes.
   */
  relationship: {
    id: {
      /**
       * A UUID representing the workspace this attribute belongs to.
       */
      workspace_id: string;
      /**
       * A UUID to identify the object or list that this attribute belongs to
       */
      object_id: string;
      /**
       * A UUID to identify this attribute.
       */
      attribute_id: string;
    };
  } | null;
  /**
   * When this attribute was created.
   */
  created_at: string;
  /**
   * Additional, type-dependent configuration for the attribute.
   */
  config: {
    /**
     * Configuration available for attributes of type "currency".
     */
    currency: {
      /**
       * The ISO4217 code representing the currency that values for this attribute should be stored in.
       */
      default_currency_code:
        | (
            | 'EUR'
            | 'GBP'
            | 'USD'
            | 'CAD'
            | 'AUD'
            | 'NZD'
            | 'AED'
            | 'INR'
            | 'CHF'
            | 'JPY'
            | 'CNY'
            | 'PHP'
            | 'ILS'
            | 'SGD'
            | 'HKD'
            | 'MYR'
            | 'NTD'
            | 'NOK'
            | 'SEK'
            | 'ISK'
            | 'BEL'
            | 'PLN'
            | 'KRW'
            | 'DKK'
            | 'BRL'
          )
        | null;
      /**
       * How the currency should be displayed across the app. "code" will display the ISO currency code e.g. "USD", "name" will display the localized currency name e.g. "British pound", "narrowSymbol" will display "$1" instead of "US$1" and "symbol" will display a localized currency symbol such as "$".
       */
      display_type: ('code' | 'name' | 'narrowSymbol' | 'symbol') | null;
    };
    /**
     * Configuration available for attributes of type "record-reference".
     */
    record_reference: {
      /**
       * A list of UUIDs to indicate which objects records are allowed to belong to. Leave empty to to allow records from all object types.
       */
      allowed_object_ids: Array<string> | null;
    };
  };
};

/**
 * The type of the attribute.
 */
export type type2 =
  | 'text'
  | 'number'
  | 'checkbox'
  | 'currency'
  | 'date'
  | 'timestamp'
  | 'rating'
  | 'status'
  | 'select'
  | 'record-reference'
  | 'actor-reference'
  | 'location'
  | 'domain'
  | 'email-address'
  | 'phone-number'
  | 'interaction'
  | 'personal-name';

/**
 * The ISO4217 code representing the currency that values for this attribute should be stored in.
 */
export type default_currency_code =
  | 'EUR'
  | 'GBP'
  | 'USD'
  | 'CAD'
  | 'AUD'
  | 'NZD'
  | 'AED'
  | 'INR'
  | 'CHF'
  | 'JPY'
  | 'CNY'
  | 'PHP'
  | 'ILS'
  | 'SGD'
  | 'HKD'
  | 'MYR'
  | 'NTD'
  | 'NOK'
  | 'SEK'
  | 'ISK'
  | 'BEL'
  | 'PLN'
  | 'KRW'
  | 'DKK'
  | 'BRL';

/**
 * How the currency should be displayed across the app. "code" will display the ISO currency code e.g. "USD", "name" will display the localized currency name e.g. "British pound", "narrowSymbol" will display "$1" instead of "US$1" and "symbol" will display a localized currency symbol such as "$".
 */
export type display_type = 'code' | 'name' | 'narrowSymbol' | 'symbol';

export type list = {
  id: {
    /**
     * A UUID to identify the workspace this list belongs to.
     */
    workspace_id: string;
    /**
     * A UUID to identify this list.
     */
    list_id: string;
  };
  /**
   * A human-readable slug for use in URLs and responses.
   */
  api_slug: string;
  /**
   * The name of the list, as viewed in the UI.
   */
  name: string;
  /**
   * A UUID or slug to identify the allowed object type for records added to this list. All new Lists are expected to have exactly one parent object. However, some legacy lists may have multiple allowed parents so the return type of this field is an array.
   */
  parent_object: Array<string>;
  /**
   * The level of access granted to all members of the workspace for this list. `null` values represent a private list that only grants access to specific workspace members via the `workspace_member_access` property.
   */
  workspace_access: ('full-access' | 'read-and-write' | 'read-only') | null;
  /**
   * The level of access granted to specific workspace members for this list. An empty array represents a list that has granted access to no workspace members.
   */
  workspace_member_access: Array<{
    /**
     * A UUID to identify the workspace member to grant access to.
     */
    workspace_member_id: string;
    /**
     * The level of access to the list.
     */
    level: 'full-access' | 'read-and-write' | 'read-only';
  }>;
  /**
   * The actor which created this list.
   */
  created_by_actor: {
    /**
     * An ID to identify the actor.
     */
    id?: string | null;
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    type?: ('api-token' | 'workspace-member' | 'system') | null;
  };
  /**
   * When the list was created.
   */
  created_at: string;
};

/**
 * The level of access granted to all members of the workspace for this list. `null` values represent a private list that only grants access to specific workspace members via the `workspace_member_access` property.
 */
export type workspace_access = 'full-access' | 'read-and-write' | 'read-only';

export type attioObject = {
  id: {
    /**
     * A UUID to identify the workspace this object belongs to.
     */
    workspace_id: string;
    /**
     * A UUID to identify the object.
     */
    object_id: string;
  };
  /**
   * A unique, human-readable slug to access the object through URLs and API calls. Formatted in snake case.
   */
  api_slug: string | null;
  /**
   * The singular form of the object's name.
   */
  singular_noun: string | null;
  /**
   * The plural form of the object's name.
   */
  plural_noun: string | null;
  /**
   * When the object was created.
   */
  created_at: string;
};

export type workspace_member = {
  id: {
    /**
     * The ID of the workspace the workspace member belongs to.
     */
    workspace_id: string;
    /**
     * The ID of the workspace member.
     */
    workspace_member_id: string;
  };
  /**
   * The first name of the user.
   */
  first_name: string;
  /**
   * The last name of the user.
   */
  last_name: string;
  /**
   * A URL to the user's avatar image.
   */
  avatar_url: string | null;
  /**
   * The user's email address.
   */
  email_address: string;
  /**
   * When the workspace member was created.
   */
  created_at: string;
  /**
   * Whether the workspace member is suspended or not and what level of privileges they have inside the workspace. We do not delete workspace members so that you can successfully attribute past actions to suspended workspace members.
   */
  access_level: 'admin' | 'member' | 'suspended';
};

/**
 * Whether the workspace member is suspended or not and what level of privileges they have inside the workspace. We do not delete workspace members so that you can successfully attribute past actions to suspended workspace members.
 */
export type access_level = 'admin' | 'member' | 'suspended';

export type comment = {
  id: {
    /**
     * The ID of the workspace the comment belongs to.
     */
    workspace_id: string;
    /**
     * The ID of the comment.
     */
    comment_id: string;
  };
  /**
   * The ID of the thread the comment belongs to.
   */
  thread_id: string;
  /**
   * A plaintext representation of the content of the comment. References to workspace members are cast into email addresses, all other stylistic elements are removed.
   */
  content_plaintext: string;
  /**
   * The entry the comment belongs to, `null` for comments on records.
   */
  entry: {
    /**
     * The ID of the entry the comment belongs to.
     */
    entry_id: string;
    /**
     * The ID of the list the entry belongs to.
     */
    list_id: string;
  } | null;
  /**
   * The record the comment belongs to.
   */
  record: {
    /**
     * The ID of the record the comment belongs to.
     */
    record_id: string;
    /**
     * The ID of the object the record belongs to.
     */
    object_id: string;
  };
  /**
   * Whether the comment is resolved.
   */
  resolved_at: string | null;
  /**
   * The actor that resolved this comment.
   */
  resolved_by: {
    /**
     * An ID to identify the actor.
     */
    id?: string | null;
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    type?: ('api-token' | 'workspace-member' | 'system') | null;
  };
  /**
   * When the note was created.
   */
  created_at: string;
  /**
   * Who wrote this comment. Note that the API provides the ability for API tokens to write comments on behalf of other actors.
   */
  author: {
    /**
     * An ID to identify the actor.
     */
    id?: string | null;
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    type?: ('api-token' | 'workspace-member' | 'system') | null;
  };
};

export type note = {
  id: {
    /**
     * The ID of the workspace the note belongs to.
     */
    workspace_id: string;
    /**
     * The ID of the note.
     */
    note_id: string;
  };
  /**
   * The slug or ID of the parent object the note belongs to.
   */
  parent_object: string;
  /**
   * The ID of the parent record the note belongs to.
   */
  parent_record_id: string;
  /**
   * The note title. The title is plaintext only and has no formatting.
   */
  title: string;
  /**
   * The plaintext representation of the note content. The line feed character `\n` represents new lines within the note content.
   */
  content_plaintext: string;
  /**
   * The actor that created this note.
   */
  created_by_actor: {
    /**
     * An ID to identify the actor.
     */
    id?: string | null;
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    type?: ('api-token' | 'workspace-member' | 'system') | null;
  };
  /**
   * When the note was created.
   */
  created_at: string;
};

export type task = {
  id: {
    /**
     * The ID of the workspace the task belongs to.
     */
    workspace_id: string;
    /**
     * The ID of the task.
     */
    task_id: string;
  };
  /**
   * The plaintext representation of the task content. Inline linked records will appear as "@record name" and are returned in the `linked_records` property.
   */
  content_plaintext: string;
  /**
   * The deadline date of the task. Returned as an ISO 8601 timestamp.
   */
  deadline_at: string | null;
  /**
   * Whether the task has been completed.
   */
  is_completed: boolean;
  /**
   * Records linked to the task. Creating record links within task content text is not possible via the API at present.
   */
  linked_records: Array<{
    /**
     * The ID of the parent object the task refers to. At present, only `people` and `companies` are supported.
     */
    target_object_id: string;
    /**
     * The ID of the parent record the task refers to.
     */
    target_record_id: string;
  }>;
  /**
   * Workspace members assigned to this task.
   */
  assignees: Array<{
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
    /**
     * The ID of the workspace member actor assigned to this task.
     */
    referenced_actor_id: string;
  }>;
  /**
   * The actor that created this task.
   */
  created_by_actor: {
    /**
     * An ID to identify the actor.
     */
    id?: string | null;
    /**
     * The type of actor. [Read more information on actor types here](/docs/actors).
     */
    type?: ('api-token' | 'workspace-member' | 'system') | null;
  };
  /**
   * When the task was created.
   */
  created_at: string;
};

export type thread = {
  id: {
    /**
     * The ID of the workspace the thread belongs to.
     */
    workspace_id: string;
    /**
     * The ID of the thread.
     */
    thread_id: string;
  };
  /**
   * An array of comments in the thread, sorted by `created_at`.
   */
  comments: Array<comment>;
  /**
   * When the thread was created.
   */
  created_at: string;
};

export type GetV2ObjectsResponse = {
  data: Array<object>;
};

export type GetV2ObjectsError = unknown;

export type PostV2ObjectsData = {
  body: {
    data: {
      /**
       * A unique, human-readable slug to access the object through URLs and API calls. Should be formatted in snake case.
       */
      api_slug: string;
      /**
       * The singular form of the object's name.
       */
      singular_noun: string;
      /**
       * The plural form of the object's name.
       */
      plural_noun: string;
    };
  };
};

export type PostV2ObjectsResponse = {
  data: attioObject;
};

export type PostV2ObjectsError = {
  status_code: 409;
  type: 'invalid_request_error';
  code: 'slug_conflict';
  message: string;
};

export type GetV2ObjectsByObjectData = {
  path: {
    object: string;
  };
};

export type GetV2ObjectsByObjectResponse = {
  data: attioObject;
};

export type GetV2ObjectsByObjectError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2ObjectsByObjectData = {
  body: {
    data: {
      /**
       * A unique, human-readable slug to access the object through URLs and API calls. Should be formatted in snake case.
       */
      api_slug?: string;
      /**
       * The singular form of the object's name.
       */
      singular_noun?: string;
      /**
       * The plural form of the object's name.
       */
      plural_noun?: string;
    };
  };
  path: {
    object: string;
  };
};

export type PatchV2ObjectsByObjectResponse = {
  data: attioObject;
};

export type PatchV2ObjectsByObjectError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type GetV2ByTargetByIdentifierAttributesData = {
  path: {
    identifier: string;
    target: 'objects' | 'lists';
  };
  query?: {
    limit?: number;
    offset?: number;
    show_archived?: boolean;
  };
};

export type GetV2ByTargetByIdentifierAttributesResponse = {
  data: Array<attribute>;
};

export type GetV2ByTargetByIdentifierAttributesError = unknown;

export type PostV2ByTargetByIdentifierAttributesData = {
  body: {
    data: {
      /**
       * The name of the attribute. The title will be visible across Attio's UI.
       */
      title: string;
      /**
       * A text description for the attribute.
       */
      description: string | null;
      /**
       * A unique, human-readable slug to access the attribute through URLs and API calls. Formatted in snake case.
       */
      api_slug: string;
      /**
       * The type of the attribute. This value affects the possible `config` values. Attributes of type "status" are not supported on objects.
       */
      type:
        | 'text'
        | 'number'
        | 'checkbox'
        | 'currency'
        | 'date'
        | 'timestamp'
        | 'rating'
        | 'status'
        | 'select'
        | 'record-reference'
        | 'actor-reference'
        | 'location'
        | 'domain'
        | 'email-address'
        | 'phone-number';
      /**
       * When `is_required` is `true`, new records/entries must have a value for this attribute. If `false`, values may be `null`. This value does not affect existing data and you do not need to backfill `null` values if changing `is_required` from `false` to `true`.
       */
      is_required: boolean;
      /**
       * Whether or not new values for this attribute must be unique. Uniqueness restrictions are only applied to new data and do not apply retroactively to previously created data.
       */
      is_unique: boolean;
      /**
       * Whether or not this attribute can have multiple values. Multiselect is only available on some value types.
       */
      is_multiselect: boolean;
      /**
       * The default value for this attribute. Static values are used to directly populate values using their contents. Dynamic values are used to lookup data at the point of creation. For example, you could use a dynamic value to insert a value for the currently logged in user. Which default values are available is dependent on the type of the attribute. Default values are not currently supported on people or company objects.
       */
      default_value?:
        | {
            type: 'dynamic';
            template: 'current-user' | string;
          }
        | {
            type: 'static';
            template: Array<input_value>;
          }
        | null;
      config: {
        /**
         * Configuration available for attributes of type "currency".
         */
        currency?: {
          /**
           * The ISO4217 code representing the currency that values for this attribute should be stored in.
           */
          default_currency_code:
            | 'EUR'
            | 'GBP'
            | 'USD'
            | 'CAD'
            | 'AUD'
            | 'NZD'
            | 'AED'
            | 'INR'
            | 'CHF'
            | 'JPY'
            | 'CNY'
            | 'PHP'
            | 'ILS'
            | 'SGD'
            | 'HKD'
            | 'MYR'
            | 'NTD'
            | 'NOK'
            | 'SEK'
            | 'ISK'
            | 'BEL'
            | 'PLN'
            | 'KRW'
            | 'DKK'
            | 'BRL';
          /**
           * How the currency should be displayed across the app. "code" will display the ISO currency code e.g. "USD", "name" will display the localized currency name e.g. "British pound", "narrowSymbol" will display "$1" instead of "US$1" and "symbol" will display a localized currency symbol such as "$".
           */
          display_type: 'code' | 'name' | 'narrowSymbol' | 'symbol';
        };
        /**
         * Configuration available for attributes of type "record-reference".
         */
        record_reference?: {
          /**
           * A list of slugs or UUIDs to indicate which objects records are allowed to belong to. Leave empty to to allow records from all object types.
           */
          allowed_objects: Array<string>;
        };
      };
    };
  };
  path: {
    identifier: string;
    target: 'objects' | 'lists';
  };
};

export type PostV2ByTargetByIdentifierAttributesResponse = {
  data: attribute;
};

export type PostV2ByTargetByIdentifierAttributesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type GetV2ByTargetByIdentifierAttributesByAttributeData = {
  path: {
    attribute: string;
    identifier: string;
    target: 'objects' | 'lists';
  };
};

export type GetV2ByTargetByIdentifierAttributesByAttributeResponse = {
  data: attribute;
};

export type GetV2ByTargetByIdentifierAttributesByAttributeError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeData = {
  body: {
    data: {
      /**
       * The name of the attribute. The title will be visible across Attio's UI.
       */
      title?: string;
      /**
       * A text description for the attribute.
       */
      description?: string | null;
      /**
       * A unique, human-readable slug to access the attribute through URLs and API calls. Formatted in snake case.
       */
      api_slug?: string;
      /**
       * When `is_required` is `true`, new records/entries must have a value for this attribute. If `false`, values may be `null`. This value does not affect existing data and you do not need to backfill `null` values if changing `is_required` from `false` to `true`.
       */
      is_required?: boolean;
      /**
       * Whether or not new values for this attribute must be unique. Uniqueness restrictions are only applied to new data and do not apply retroactively to previously created data.
       */
      is_unique?: boolean;
      /**
       * The default value for this attribute. Static values are used to directly populate values using their contents. Dynamic values are used to lookup data at the point of creation. For example, you could use a dynamic value to insert a value for the currently logged in user. Which default values are available is dependent on the type of the attribute. Default values are not currently supported on people or company objects.
       */
      default_value?:
        | {
            type: 'dynamic';
            template: 'current-user' | string;
          }
        | {
            type: 'static';
            template: Array<input_value>;
          }
        | null;
      /**
       * Additional, type-dependent configuration for the attribute.
       */
      config?: {
        /**
         * Configuration available for attributes of type "currency".
         */
        currency?: {
          /**
           * The ISO4217 code representing the currency that values for this attribute should be stored in.
           */
          default_currency_code:
            | 'EUR'
            | 'GBP'
            | 'USD'
            | 'CAD'
            | 'AUD'
            | 'NZD'
            | 'AED'
            | 'INR'
            | 'CHF'
            | 'JPY'
            | 'CNY'
            | 'PHP'
            | 'ILS'
            | 'SGD'
            | 'HKD'
            | 'MYR'
            | 'NTD'
            | 'NOK'
            | 'SEK'
            | 'ISK'
            | 'BEL'
            | 'PLN'
            | 'KRW'
            | 'DKK'
            | 'BRL';
          /**
           * How the currency should be displayed across the app. "code" will display the ISO currency code e.g. "USD", "name" will display the localized currency name e.g. "British pound", "narrowSymbol" will display "$1" instead of "US$1" and "symbol" will display a localized currency symbol such as "$".
           */
          display_type: 'code' | 'name' | 'narrowSymbol' | 'symbol';
        };
        /**
         * Configuration available for attributes of type "record-reference".
         */
        record_reference?: {
          /**
           * A list of slugs or UUIDs to indicate which objects records are allowed to belong to. Leave empty to to allow records from all object types.
           */
          allowed_objects: Array<string>;
        };
      };
      /**
       * Whether the attribute has been archived or not. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving.
       */
      is_archived?: boolean;
    };
  };
  path: {
    attribute: string;
    identifier: string;
    target: 'objects' | 'lists';
  };
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeResponse = {
  data: attribute;
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'system_edit_unauthorized';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2ByTargetByIdentifierAttributesByAttributeOptionsData = {
  path: {
    attribute: string;
    identifier: string;
    target: 'objects' | 'lists';
  };
  query?: {
    show_archived?: boolean;
  };
};

export type GetV2ByTargetByIdentifierAttributesByAttributeOptionsResponse = {
  data: Array<select_option>;
};

export type GetV2ByTargetByIdentifierAttributesByAttributeOptionsError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PostV2ByTargetByIdentifierAttributesByAttributeOptionsData = {
  body: {
    data: {
      /**
       * The Title of the select option
       */
      title: string;
    };
  };
  path: {
    attribute: string;
    identifier: string;
    target: 'objects' | 'lists';
  };
};

export type PostV2ByTargetByIdentifierAttributesByAttributeOptionsResponse = {
  data: select_option;
};

export type PostV2ByTargetByIdentifierAttributesByAttributeOptionsError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionData = {
  body: {
    data: {
      /**
       * The Title of the select option
       */
      title?: string;
      /**
       * Whether or not to archive the select option. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving.
       */
      is_archived?: boolean;
    };
  };
  path: {
    attribute: string;
    identifier: string;
    option: string;
    target: 'objects' | 'lists';
  };
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionResponse = {
  data: select_option;
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type GetV2ByTargetByIdentifierAttributesByAttributeStatusesData = {
  path: {
    attribute: string;
    identifier: string;
    target: 'lists' | 'objects';
  };
  query?: {
    show_archived?: boolean;
  };
};

export type GetV2ByTargetByIdentifierAttributesByAttributeStatusesResponse = {
  data: Array<status>;
};

export type GetV2ByTargetByIdentifierAttributesByAttributeStatusesError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PostV2ByTargetByIdentifierAttributesByAttributeStatusesData = {
  body: {
    data: {
      /**
       * The Title of the status
       */
      title: string;
      /**
       * Whether arriving at this status triggers a celebration effect
       */
      celebration_enabled?: boolean;
      /**
       * Target time for a record to spend in given status expressed as a ISO-8601 duration string
       */
      target_time_in_status?: string | null;
    };
  };
  path: {
    attribute: string;
    identifier: string;
    target: 'lists' | 'objects';
  };
};

export type PostV2ByTargetByIdentifierAttributesByAttributeStatusesResponse = {
  data: status;
};

export type PostV2ByTargetByIdentifierAttributesByAttributeStatusesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusData = {
  body: {
    data: {
      /**
       * The Title of the status
       */
      title?: string;
      /**
       * Whether arriving at this status triggers a celebration effect
       */
      celebration_enabled?: boolean;
      /**
       * Target time for a record to spend in given status expressed as a ISO-8601 duration string
       */
      target_time_in_status?: string | null;
      /**
       * Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving.
       */
      is_archived?: boolean;
    };
  };
  path: {
    attribute: string;
    identifier: string;
    status: string;
    target: 'lists' | 'objects';
  };
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusResponse = {
  data: status;
};

export type PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    }
  | {
      status_code: 409;
      type: 'invalid_request_error';
      code: 'slug_conflict';
      message: string;
    };

export type PostV2ObjectsByObjectRecordsQueryData = {
  body: {
    /**
     * An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/docs/filtering-and-sorting).
     */
    filter?: {
      [key: string]: unknown;
    };
    /**
     * An object used to sort results. See the [full guide to filtering and sorting here](/docs/filtering-and-sorting).
     */
    sorts?: Array<
      | {
          /**
           * The direction to sort the results by.
           */
          direction: 'asc' | 'desc';
          /**
           * A slug or ID to identify the attribute to sort by.
           */
          attribute: string;
          /**
           * Which field on the value to sort by e.g. "last_name" on a name value.
           */
          field?: string;
        }
      | {
          /**
           * The direction to sort the results by.
           */
          direction: 'asc' | 'desc';
          /**
           * You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug "sales", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`.
           */
          path: Array<[string, string]>;
          /**
           * Which field on the value to sort by e.g. "last_name" on a name value.
           */
          field?: string;
        }
    >;
    /**
     * The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/docs/pagination).
     */
    limit?: number;
    /**
     * The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/docs/pagination).
     */
    offset?: number;
  };
  path: {
    object: string;
  };
};

export type PostV2ObjectsByObjectRecordsQueryResponse = {
  data: Array<{
    id: {
      /**
       * A UUID identifying the workspace this record belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the object this record belongs to.
       */
      object_id: string;
      /**
       * A UUID identifying this record.
       */
      record_id: string;
    };
    /**
     * When this record was created.
     */
    created_at: string;
    /**
     * A record type with an attribute `api_slug` as the key, and an array of value objects as the values.
     */
    values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  }>;
};

export type PostV2ObjectsByObjectRecordsQueryError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'filter_error';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type PostV2ObjectsByObjectRecordsData = {
  body: {
    data: {
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    object: string;
  };
};

export type PostV2ObjectsByObjectRecordsResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this record belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the object this record belongs to.
       */
      object_id: string;
      /**
       * A UUID identifying this record.
       */
      record_id: string;
    };
    /**
     * When this record was created.
     */
    created_at: string;
    /**
     * A record type with an attribute `api_slug` as the key, and an array of value objects as the values.
     */
    values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PostV2ObjectsByObjectRecordsError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type PutV2ObjectsByObjectRecordsData = {
  body: {
    data: {
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    object: string;
  };
  query: {
    matching_attribute: string;
  };
};

export type PutV2ObjectsByObjectRecordsResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this record belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the object this record belongs to.
       */
      object_id: string;
      /**
       * A UUID identifying this record.
       */
      record_id: string;
    };
    /**
     * When this record was created.
     */
    created_at: string;
    /**
     * A record type with an attribute `api_slug` as the key, and an array of value objects as the values.
     */
    values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PutV2ObjectsByObjectRecordsError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2ObjectsByObjectRecordsByRecordIdData = {
  path: {
    object: string;
    record_id: string;
  };
};

export type GetV2ObjectsByObjectRecordsByRecordIdResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this record belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the object this record belongs to.
       */
      object_id: string;
      /**
       * A UUID identifying this record.
       */
      record_id: string;
    };
    /**
     * When this record was created.
     */
    created_at: string;
    /**
     * A record type with an attribute `api_slug` as the key, and an array of value objects as the values.
     */
    values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type GetV2ObjectsByObjectRecordsByRecordIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2ObjectsByObjectRecordsByRecordIdData = {
  body: {
    data: {
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    object: string;
    record_id: string;
  };
};

export type PatchV2ObjectsByObjectRecordsByRecordIdResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this record belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the object this record belongs to.
       */
      object_id: string;
      /**
       * A UUID identifying this record.
       */
      record_id: string;
    };
    /**
     * When this record was created.
     */
    created_at: string;
    /**
     * A record type with an attribute `api_slug` as the key, and an array of value objects as the values.
     */
    values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PatchV2ObjectsByObjectRecordsByRecordIdError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'missing_value';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type DeleteV2ObjectsByObjectRecordsByRecordIdData = {
  path: {
    object: string;
    record_id: string;
  };
};

export type DeleteV2ObjectsByObjectRecordsByRecordIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2ObjectsByObjectRecordsByRecordIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesData = {
  path: {
    attribute: string;
    object: string;
    record_id: string;
  };
  query?: {
    limit?: number;
    offset?: number;
    show_historic?: boolean;
  };
};

export type GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesResponse = {
  data: Array<
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
         */
        referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
        /**
         * The ID of the referenced actor.
         */
        referenced_actor_id: string | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'actor-reference';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
         */
        value: boolean;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'checkbox';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
         */
        currency_value: number;
        /**
         * The ISO4217 currency code representing the currency that the value is stored in.
         */
        currency_code?:
          | (
              | 'EUR'
              | 'GBP'
              | 'USD'
              | 'CAD'
              | 'AUD'
              | 'NZD'
              | 'AED'
              | 'INR'
              | 'CHF'
              | 'JPY'
              | 'CNY'
              | 'PHP'
              | 'ILS'
              | 'SGD'
              | 'HKD'
              | 'MYR'
              | 'NTD'
              | 'NOK'
              | 'SEK'
              | 'ISK'
              | 'BEL'
              | 'PLN'
              | 'KRW'
              | 'DKK'
              | 'BRL'
            )
          | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'currency';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'date';
        /**
         * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
         */
        value: string;
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        domain: string;
        root_domain: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'domain';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        original_email_address: string;
        email_address: string;
        email_domain: string;
        email_root_domain: string;
        email_local_specifier: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'email-address';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A slug identifying the object that the referenced record belongs to.
         */
        target_object: string;
        /**
         * A UUID to identify the referenced record.
         */
        target_record_id: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'record-reference';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The type of interaction e.g. calendar or email.
         */
        interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
        /**
         * When the interaction occurred.
         */
        interacted_at: string;
        /**
         * The actor that created this value.
         */
        owner_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'interaction';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_1: string | null;
        /**
         * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_2: string | null;
        /**
         * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_3: string | null;
        /**
         * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_4: string | null;
        /**
         * The town, neighborhood or area the location is in.
         */
        locality: string | null;
        /**
         * The state, county, province or region that the location is in.
         */
        region: string | null;
        /**
         * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
         */
        postcode: string | null;
        /**
         * The ISO 3166-1 alpha-2 country code for the country this location is in.
         */
        country_code:
          | (
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW'
            )
          | null;
        /**
         * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
         */
        latitude: string | null;
        /**
         * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
         */
        longitude: string | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'location';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * Numbers are persisted as 64 bit floats.
         */
        value: number;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'number';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The first name.
         */
        first_name: string;
        /**
         * The last name.
         */
        last_name: string;
        /**
         * The full name.
         */
        full_name: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'personal-name';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The raw, original phone number, as inputted.
         */
        original_phone_number: string;
        /**
         * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
         */
        country_code:
          | 'AF'
          | 'AX'
          | 'AL'
          | 'DZ'
          | 'AS'
          | 'AD'
          | 'AO'
          | 'AI'
          | 'AQ'
          | 'AG'
          | 'AR'
          | 'AM'
          | 'AW'
          | 'AU'
          | 'AT'
          | 'AZ'
          | 'BS'
          | 'BH'
          | 'BD'
          | 'BB'
          | 'BY'
          | 'BE'
          | 'BZ'
          | 'BJ'
          | 'BM'
          | 'BT'
          | 'BO'
          | 'BA'
          | 'BW'
          | 'BV'
          | 'BR'
          | 'IO'
          | 'BN'
          | 'BG'
          | 'BF'
          | 'BI'
          | 'KH'
          | 'CM'
          | 'CA'
          | 'CV'
          | 'KY'
          | 'CF'
          | 'TD'
          | 'CL'
          | 'CN'
          | 'CX'
          | 'CC'
          | 'CO'
          | 'KM'
          | 'CG'
          | 'CD'
          | 'CK'
          | 'CR'
          | 'CI'
          | 'HR'
          | 'CU'
          | 'CW'
          | 'CY'
          | 'CZ'
          | 'DK'
          | 'DJ'
          | 'DM'
          | 'DO'
          | 'EC'
          | 'EG'
          | 'SV'
          | 'GQ'
          | 'ER'
          | 'EE'
          | 'ET'
          | 'FK'
          | 'FO'
          | 'FJ'
          | 'FI'
          | 'FR'
          | 'GF'
          | 'PF'
          | 'TF'
          | 'GA'
          | 'GM'
          | 'GE'
          | 'DE'
          | 'GH'
          | 'GI'
          | 'GR'
          | 'GL'
          | 'GD'
          | 'GP'
          | 'GU'
          | 'GT'
          | 'GG'
          | 'GN'
          | 'GW'
          | 'GY'
          | 'HT'
          | 'HM'
          | 'VA'
          | 'HN'
          | 'HK'
          | 'HU'
          | 'IS'
          | 'IN'
          | 'ID'
          | 'IR'
          | 'IQ'
          | 'IE'
          | 'IM'
          | 'IL'
          | 'IT'
          | 'JM'
          | 'JP'
          | 'JE'
          | 'JO'
          | 'KZ'
          | 'KE'
          | 'KI'
          | 'KR'
          | 'KW'
          | 'KG'
          | 'LA'
          | 'LV'
          | 'LB'
          | 'LS'
          | 'LR'
          | 'LY'
          | 'LI'
          | 'LT'
          | 'LU'
          | 'MO'
          | 'MK'
          | 'MG'
          | 'MW'
          | 'MY'
          | 'MV'
          | 'ML'
          | 'MT'
          | 'MH'
          | 'MQ'
          | 'MR'
          | 'MU'
          | 'YT'
          | 'MX'
          | 'FM'
          | 'MD'
          | 'MC'
          | 'MN'
          | 'ME'
          | 'MS'
          | 'MA'
          | 'MZ'
          | 'MM'
          | 'NA'
          | 'NR'
          | 'NP'
          | 'NL'
          | 'AN'
          | 'NC'
          | 'NZ'
          | 'NI'
          | 'NE'
          | 'NG'
          | 'NU'
          | 'NF'
          | 'MP'
          | 'NO'
          | 'OM'
          | 'PK'
          | 'PW'
          | 'PS'
          | 'PA'
          | 'PG'
          | 'PY'
          | 'PE'
          | 'PH'
          | 'PN'
          | 'PL'
          | 'PT'
          | 'PR'
          | 'QA'
          | 'RE'
          | 'RO'
          | 'RU'
          | 'RW'
          | 'BL'
          | 'SH'
          | 'KN'
          | 'LC'
          | 'MF'
          | 'PM'
          | 'VC'
          | 'WS'
          | 'SM'
          | 'ST'
          | 'SA'
          | 'SN'
          | 'RS'
          | 'SC'
          | 'SL'
          | 'SG'
          | 'SK'
          | 'SI'
          | 'SB'
          | 'SO'
          | 'ZA'
          | 'GS'
          | 'ES'
          | 'LK'
          | 'SD'
          | 'SR'
          | 'SJ'
          | 'SZ'
          | 'SE'
          | 'CH'
          | 'SY'
          | 'TW'
          | 'TJ'
          | 'TZ'
          | 'TH'
          | 'TL'
          | 'TG'
          | 'TK'
          | 'TO'
          | 'TT'
          | 'TN'
          | 'TR'
          | 'TM'
          | 'TC'
          | 'TV'
          | 'UG'
          | 'UA'
          | 'AE'
          | 'GB'
          | 'US'
          | 'UM'
          | 'UY'
          | 'UZ'
          | 'VU'
          | 'VE'
          | 'VN'
          | 'VG'
          | 'VI'
          | 'WF'
          | 'EH'
          | 'YE'
          | 'ZM'
          | 'ZW';
        phone_number: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'phone-number';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        status: status;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'status';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A number between 0 and 5 (inclusive) to represent a star rating.
         */
        value: number;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'rating';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        option: select_option;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'select';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A raw text field. Values are limited to 10MB.
         */
        value: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'text';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'timestamp';
        /**
         * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
         */
        value: string;
      }
  >;
};

export type GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2ObjectsByObjectRecordsByRecordIdEntriesData = {
  path: {
    object: string;
    record_id: string;
  };
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetV2ObjectsByObjectRecordsByRecordIdEntriesResponse = {
  data: Array<{
    /**
     * A UUID identifying the list that this record is in.
     */
    list_id: string;
    /**
     * A human-readable slug for the list for use in URLs and responses.
     */
    list_api_slug: string;
    /**
     * A UUID identifying this entry on the list.
     */
    entry_id: string;
    /**
     * When this entry was created.
     */
    created_at: string;
  }>;
};

export type GetV2ObjectsByObjectRecordsByRecordIdEntriesError = unknown;

export type GetV2ListsResponse = {
  data: Array<list>;
};

export type GetV2ListsError = unknown;

export type PostV2ListsData = {
  body: {
    data: {
      /**
       * The human-readable name of the list.
       */
      name: string;
      /**
       * A unique, human-readable slug to access the list through API calls. Should be formatted in snake case.
       */
      api_slug: string;
      /**
       * A UUID or slug to identify the allowed object type for records added to this list.
       */
      parent_object: string;
      /**
       * The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members.
       */
      workspace_access: ('full-access' | 'read-and-write' | 'read-only') | null;
      /**
       * The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members.
       */
      workspace_member_access: Array<{
        /**
         * A UUID to identify the workspace member to grant access to.
         */
        workspace_member_id: string;
        /**
         * The level of access to the list.
         */
        level: 'full-access' | 'read-and-write' | 'read-only';
      }>;
    };
  };
};

export type PostV2ListsResponse = {
  data: list;
};

export type PostV2ListsError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 403;
      type: 'auth_error';
      code: 'billing_error';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2ListsByListData = {
  path: {
    list: string;
  };
};

export type GetV2ListsByListResponse = {
  data: list;
};

export type GetV2ListsByListError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2ListsByListData = {
  body: {
    data: {
      /**
       * The human-readable name of the list.
       */
      name?: string;
      /**
       * A unique, human-readable slug to access the list through API calls. Should be formatted in snake case.
       */
      api_slug?: string;
      /**
       * The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members.
       */
      workspace_access?: ('full-access' | 'read-and-write' | 'read-only') | null;
      /**
       * The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members.
       */
      workspace_member_access?: Array<{
        /**
         * A UUID to identify the workspace member to grant access to.
         */
        workspace_member_id: string;
        /**
         * The level of access to the list.
         */
        level: 'full-access' | 'read-and-write' | 'read-only';
      }>;
    };
  };
  path: {
    list: string;
  };
};

export type PatchV2ListsByListResponse = {
  data: list;
};

export type PatchV2ListsByListError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type PostV2ListsByListEntriesQueryData = {
  body: {
    /**
     * An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/docs/filtering-and-sorting).
     */
    filter?: {
      [key: string]: unknown;
    };
    /**
     * An object used to sort results. See the [full guide to filtering and sorting here](/docs/filtering-and-sorting).
     */
    sorts?: Array<
      | {
          /**
           * The direction to sort the results by.
           */
          direction: 'asc' | 'desc';
          /**
           * A slug or ID to identify the attribute to sort by.
           */
          attribute: string;
          /**
           * Which field on the value to sort by e.g. "last_name" on a name value.
           */
          field?: string;
        }
      | {
          /**
           * The direction to sort the results by.
           */
          direction: 'asc' | 'desc';
          /**
           * You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug "sales", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`.
           */
          path: Array<[string, string]>;
          /**
           * Which field on the value to sort by e.g. "last_name" on a name value.
           */
          field?: string;
        }
    >;
    /**
     * The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/docs/pagination).
     */
    limit?: number;
    /**
     * The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/docs/pagination).
     */
    offset?: number;
  };
  path: {
    list: string;
  };
};

export type PostV2ListsByListEntriesQueryResponse = {
  data: Array<{
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  }>;
};

export type PostV2ListsByListEntriesQueryError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PostV2ListsByListEntriesData = {
  body: {
    data: {
      /**
       * A UUID identifying the record you want to add to the list. The record will become the 'parent' of the created list entry.
       */
      parent_record_id: string;
      /**
       * A UUID or slug identifying the object that the added parent record belongs to.
       */
      parent_object: string;
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      entry_values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    list: string;
  };
};

export type PostV2ListsByListEntriesResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PostV2ListsByListEntriesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'value_not_found';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type PutV2ListsByListEntriesData = {
  body: {
    data: {
      /**
       * A UUID identifying the record you want to add to the list. The record will become the 'parent' of the created list entry.
       */
      parent_record_id: string;
      /**
       * A UUID or slug identifying the object that the added parent record belongs to.
       */
      parent_object: string;
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      entry_values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    list: string;
  };
};

export type PutV2ListsByListEntriesResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PutV2ListsByListEntriesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'multiple_match_results';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2ListsByListEntriesByEntryIdData = {
  path: {
    entry_id: string;
    list: string;
  };
};

export type GetV2ListsByListEntriesByEntryIdResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type GetV2ListsByListEntriesByEntryIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2ListsByListEntriesByEntryIdData = {
  body: {
    data: {
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      entry_values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    entry_id: string;
    list: string;
  };
};

export type PatchV2ListsByListEntriesByEntryIdResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PatchV2ListsByListEntriesByEntryIdError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'immutable_value';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type PutV2ListsByListEntriesByEntryIdData = {
  body: {
    data: {
      /**
       * An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types).
       */
      entry_values: {
        [key: string]: unknown[];
      };
    };
  };
  path: {
    entry_id: string;
    list: string;
  };
};

export type PutV2ListsByListEntriesByEntryIdResponse = {
  data: {
    id: {
      /**
       * A UUID identifying the workspace this entry belongs to.
       */
      workspace_id: string;
      /**
       * A UUID identifying the list this entry is in.
       */
      list_id: string;
      /**
       * A UUID identifying this entry.
       */
      entry_id: string;
    };
    /**
     * A UUID identifying the record that is parent of the list entry.
     */
    parent_record_id: string;
    /**
     * A UUID or slug identifying the object that the parent record belongs to.
     */
    parent_object: string;
    /**
     * When this entry was created.
     */
    created_at: string;
    /**
     * A list of attribute values for the list entry (not attribute values for its parent record).
     */
    entry_values: {
      [key: string]: Array<
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
            /**
             * The ID of the referenced actor.
             */
            referenced_actor_id: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'actor-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
             */
            value: boolean;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'checkbox';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
             */
            currency_value: number;
            /**
             * The ISO4217 currency code representing the currency that the value is stored in.
             */
            currency_code?:
              | (
                  | 'EUR'
                  | 'GBP'
                  | 'USD'
                  | 'CAD'
                  | 'AUD'
                  | 'NZD'
                  | 'AED'
                  | 'INR'
                  | 'CHF'
                  | 'JPY'
                  | 'CNY'
                  | 'PHP'
                  | 'ILS'
                  | 'SGD'
                  | 'HKD'
                  | 'MYR'
                  | 'NTD'
                  | 'NOK'
                  | 'SEK'
                  | 'ISK'
                  | 'BEL'
                  | 'PLN'
                  | 'KRW'
                  | 'DKK'
                  | 'BRL'
                )
              | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'currency';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'date';
            /**
             * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
             */
            value: string;
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            domain: string;
            root_domain: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'domain';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            original_email_address: string;
            email_address: string;
            email_domain: string;
            email_root_domain: string;
            email_local_specifier: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'email-address';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A slug identifying the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * A UUID to identify the referenced record.
             */
            target_record_id: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'record-reference';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The type of interaction e.g. calendar or email.
             */
            interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
            /**
             * When the interaction occurred.
             */
            interacted_at: string;
            /**
             * The actor that created this value.
             */
            owner_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'interaction';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_1: string | null;
            /**
             * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_2: string | null;
            /**
             * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_3: string | null;
            /**
             * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
             */
            line_4: string | null;
            /**
             * The town, neighborhood or area the location is in.
             */
            locality: string | null;
            /**
             * The state, county, province or region that the location is in.
             */
            region: string | null;
            /**
             * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            postcode: string | null;
            /**
             * The ISO 3166-1 alpha-2 country code for the country this location is in.
             */
            country_code:
              | (
                  | 'AF'
                  | 'AX'
                  | 'AL'
                  | 'DZ'
                  | 'AS'
                  | 'AD'
                  | 'AO'
                  | 'AI'
                  | 'AQ'
                  | 'AG'
                  | 'AR'
                  | 'AM'
                  | 'AW'
                  | 'AU'
                  | 'AT'
                  | 'AZ'
                  | 'BS'
                  | 'BH'
                  | 'BD'
                  | 'BB'
                  | 'BY'
                  | 'BE'
                  | 'BZ'
                  | 'BJ'
                  | 'BM'
                  | 'BT'
                  | 'BO'
                  | 'BA'
                  | 'BW'
                  | 'BV'
                  | 'BR'
                  | 'IO'
                  | 'BN'
                  | 'BG'
                  | 'BF'
                  | 'BI'
                  | 'KH'
                  | 'CM'
                  | 'CA'
                  | 'CV'
                  | 'KY'
                  | 'CF'
                  | 'TD'
                  | 'CL'
                  | 'CN'
                  | 'CX'
                  | 'CC'
                  | 'CO'
                  | 'KM'
                  | 'CG'
                  | 'CD'
                  | 'CK'
                  | 'CR'
                  | 'CI'
                  | 'HR'
                  | 'CU'
                  | 'CW'
                  | 'CY'
                  | 'CZ'
                  | 'DK'
                  | 'DJ'
                  | 'DM'
                  | 'DO'
                  | 'EC'
                  | 'EG'
                  | 'SV'
                  | 'GQ'
                  | 'ER'
                  | 'EE'
                  | 'ET'
                  | 'FK'
                  | 'FO'
                  | 'FJ'
                  | 'FI'
                  | 'FR'
                  | 'GF'
                  | 'PF'
                  | 'TF'
                  | 'GA'
                  | 'GM'
                  | 'GE'
                  | 'DE'
                  | 'GH'
                  | 'GI'
                  | 'GR'
                  | 'GL'
                  | 'GD'
                  | 'GP'
                  | 'GU'
                  | 'GT'
                  | 'GG'
                  | 'GN'
                  | 'GW'
                  | 'GY'
                  | 'HT'
                  | 'HM'
                  | 'VA'
                  | 'HN'
                  | 'HK'
                  | 'HU'
                  | 'IS'
                  | 'IN'
                  | 'ID'
                  | 'IR'
                  | 'IQ'
                  | 'IE'
                  | 'IM'
                  | 'IL'
                  | 'IT'
                  | 'JM'
                  | 'JP'
                  | 'JE'
                  | 'JO'
                  | 'KZ'
                  | 'KE'
                  | 'KI'
                  | 'KR'
                  | 'KW'
                  | 'KG'
                  | 'LA'
                  | 'LV'
                  | 'LB'
                  | 'LS'
                  | 'LR'
                  | 'LY'
                  | 'LI'
                  | 'LT'
                  | 'LU'
                  | 'MO'
                  | 'MK'
                  | 'MG'
                  | 'MW'
                  | 'MY'
                  | 'MV'
                  | 'ML'
                  | 'MT'
                  | 'MH'
                  | 'MQ'
                  | 'MR'
                  | 'MU'
                  | 'YT'
                  | 'MX'
                  | 'FM'
                  | 'MD'
                  | 'MC'
                  | 'MN'
                  | 'ME'
                  | 'MS'
                  | 'MA'
                  | 'MZ'
                  | 'MM'
                  | 'NA'
                  | 'NR'
                  | 'NP'
                  | 'NL'
                  | 'AN'
                  | 'NC'
                  | 'NZ'
                  | 'NI'
                  | 'NE'
                  | 'NG'
                  | 'NU'
                  | 'NF'
                  | 'MP'
                  | 'NO'
                  | 'OM'
                  | 'PK'
                  | 'PW'
                  | 'PS'
                  | 'PA'
                  | 'PG'
                  | 'PY'
                  | 'PE'
                  | 'PH'
                  | 'PN'
                  | 'PL'
                  | 'PT'
                  | 'PR'
                  | 'QA'
                  | 'RE'
                  | 'RO'
                  | 'RU'
                  | 'RW'
                  | 'BL'
                  | 'SH'
                  | 'KN'
                  | 'LC'
                  | 'MF'
                  | 'PM'
                  | 'VC'
                  | 'WS'
                  | 'SM'
                  | 'ST'
                  | 'SA'
                  | 'SN'
                  | 'RS'
                  | 'SC'
                  | 'SL'
                  | 'SG'
                  | 'SK'
                  | 'SI'
                  | 'SB'
                  | 'SO'
                  | 'ZA'
                  | 'GS'
                  | 'ES'
                  | 'LK'
                  | 'SD'
                  | 'SR'
                  | 'SJ'
                  | 'SZ'
                  | 'SE'
                  | 'CH'
                  | 'SY'
                  | 'TW'
                  | 'TJ'
                  | 'TZ'
                  | 'TH'
                  | 'TL'
                  | 'TG'
                  | 'TK'
                  | 'TO'
                  | 'TT'
                  | 'TN'
                  | 'TR'
                  | 'TM'
                  | 'TC'
                  | 'TV'
                  | 'UG'
                  | 'UA'
                  | 'AE'
                  | 'GB'
                  | 'US'
                  | 'UM'
                  | 'UY'
                  | 'UZ'
                  | 'VU'
                  | 'VE'
                  | 'VN'
                  | 'VG'
                  | 'VI'
                  | 'WF'
                  | 'EH'
                  | 'YE'
                  | 'ZM'
                  | 'ZW'
                )
              | null;
            /**
             * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
             */
            latitude: string | null;
            /**
             * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
             */
            longitude: string | null;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'location';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * Numbers are persisted as 64 bit floats.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The first name.
             */
            first_name: string;
            /**
             * The last name.
             */
            last_name: string;
            /**
             * The full name.
             */
            full_name: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'personal-name';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The raw, original phone number, as inputted.
             */
            original_phone_number: string;
            /**
             * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
             */
            country_code:
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW';
            phone_number: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'phone-number';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            status: status;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'status';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A number between 0 and 5 (inclusive) to represent a star rating.
             */
            value: number;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'rating';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            option: select_option;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'select';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * A raw text field. Values are limited to 10MB.
             */
            value: string;
            /**
             * The attribute type of the value.
             */
            attribute_type: 'text';
          }
        | {
            /**
             * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
             */
            active_from: string;
            /**
             * The point in time at which this value was deactivated. If `null`, the value is active.
             */
            active_until: string | null;
            /**
             * The actor that created this value.
             */
            created_by_actor: {
              /**
               * An ID to identify the actor.
               */
              id?: string | null;
              /**
               * The type of actor. [Read more information on actor types here](/docs/actors).
               */
              type?: ('api-token' | 'workspace-member' | 'system') | null;
            };
            /**
             * The attribute type of the value.
             */
            attribute_type: 'timestamp';
            /**
             * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
             */
            value: string;
          }
      >;
    };
  };
};

export type PutV2ListsByListEntriesByEntryIdError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'immutable_value';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type DeleteV2ListsByListEntriesByEntryIdData = {
  path: {
    entry_id: string;
    list: string;
  };
};

export type DeleteV2ListsByListEntriesByEntryIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2ListsByListEntriesByEntryIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesData = {
  path: {
    attribute: string;
    entry_id: string;
    list: string;
  };
  query?: {
    limit?: number;
    offset?: number;
    show_historic?: boolean;
  };
};

export type GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesResponse = {
  data: Array<
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The type of the referenced actor. [Read more information on actor types here](/docs/actors).
         */
        referenced_actor_type: 'api-token' | 'workspace-member' | 'system';
        /**
         * The ID of the referenced actor.
         */
        referenced_actor_id: string | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'actor-reference';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted.
         */
        value: boolean;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'checkbox';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A numerical representation of the currency value. A decimal with a max of 4 decimal places.
         */
        currency_value: number;
        /**
         * The ISO4217 currency code representing the currency that the value is stored in.
         */
        currency_code?:
          | (
              | 'EUR'
              | 'GBP'
              | 'USD'
              | 'CAD'
              | 'AUD'
              | 'NZD'
              | 'AED'
              | 'INR'
              | 'CHF'
              | 'JPY'
              | 'CNY'
              | 'PHP'
              | 'ILS'
              | 'SGD'
              | 'HKD'
              | 'MYR'
              | 'NTD'
              | 'NOK'
              | 'SEK'
              | 'ISK'
              | 'BEL'
              | 'PLN'
              | 'KRW'
              | 'DKK'
              | 'BRL'
            )
          | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'currency';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'date';
        /**
         * A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, "2023" and "2023-01" will be coerced into "2023-01-01", and "2023-01-02", "2023-01-02T13:00", "2023-01-02T14:00:00", "2023-01-02T15:00:00.000000000", and "2023-01-02T15:00:00.000000000+02:00" will all be coerced to "2023-01-02". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value "2023-01-02T23:00:00-10:00" will be returned as "2023-01-03". The maximum date is "9999-12-31".
         */
        value: string;
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        domain: string;
        root_domain: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'domain';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        original_email_address: string;
        email_address: string;
        email_domain: string;
        email_root_domain: string;
        email_local_specifier: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'email-address';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A slug identifying the object that the referenced record belongs to.
         */
        target_object: string;
        /**
         * A UUID to identify the referenced record.
         */
        target_record_id: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'record-reference';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The type of interaction e.g. calendar or email.
         */
        interaction_type: 'calendar-event' | 'call' | 'chat-thread' | 'email' | 'in-person-meeting';
        /**
         * When the interaction occurred.
         */
        interacted_at: string;
        /**
         * The actor that created this value.
         */
        owner_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'interaction';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_1: string | null;
        /**
         * The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_2: string | null;
        /**
         * The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_3: string | null;
        /**
         * The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.
         */
        line_4: string | null;
        /**
         * The town, neighborhood or area the location is in.
         */
        locality: string | null;
        /**
         * The state, county, province or region that the location is in.
         */
        region: string | null;
        /**
         * The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
         */
        postcode: string | null;
        /**
         * The ISO 3166-1 alpha-2 country code for the country this location is in.
         */
        country_code:
          | (
              | 'AF'
              | 'AX'
              | 'AL'
              | 'DZ'
              | 'AS'
              | 'AD'
              | 'AO'
              | 'AI'
              | 'AQ'
              | 'AG'
              | 'AR'
              | 'AM'
              | 'AW'
              | 'AU'
              | 'AT'
              | 'AZ'
              | 'BS'
              | 'BH'
              | 'BD'
              | 'BB'
              | 'BY'
              | 'BE'
              | 'BZ'
              | 'BJ'
              | 'BM'
              | 'BT'
              | 'BO'
              | 'BA'
              | 'BW'
              | 'BV'
              | 'BR'
              | 'IO'
              | 'BN'
              | 'BG'
              | 'BF'
              | 'BI'
              | 'KH'
              | 'CM'
              | 'CA'
              | 'CV'
              | 'KY'
              | 'CF'
              | 'TD'
              | 'CL'
              | 'CN'
              | 'CX'
              | 'CC'
              | 'CO'
              | 'KM'
              | 'CG'
              | 'CD'
              | 'CK'
              | 'CR'
              | 'CI'
              | 'HR'
              | 'CU'
              | 'CW'
              | 'CY'
              | 'CZ'
              | 'DK'
              | 'DJ'
              | 'DM'
              | 'DO'
              | 'EC'
              | 'EG'
              | 'SV'
              | 'GQ'
              | 'ER'
              | 'EE'
              | 'ET'
              | 'FK'
              | 'FO'
              | 'FJ'
              | 'FI'
              | 'FR'
              | 'GF'
              | 'PF'
              | 'TF'
              | 'GA'
              | 'GM'
              | 'GE'
              | 'DE'
              | 'GH'
              | 'GI'
              | 'GR'
              | 'GL'
              | 'GD'
              | 'GP'
              | 'GU'
              | 'GT'
              | 'GG'
              | 'GN'
              | 'GW'
              | 'GY'
              | 'HT'
              | 'HM'
              | 'VA'
              | 'HN'
              | 'HK'
              | 'HU'
              | 'IS'
              | 'IN'
              | 'ID'
              | 'IR'
              | 'IQ'
              | 'IE'
              | 'IM'
              | 'IL'
              | 'IT'
              | 'JM'
              | 'JP'
              | 'JE'
              | 'JO'
              | 'KZ'
              | 'KE'
              | 'KI'
              | 'KR'
              | 'KW'
              | 'KG'
              | 'LA'
              | 'LV'
              | 'LB'
              | 'LS'
              | 'LR'
              | 'LY'
              | 'LI'
              | 'LT'
              | 'LU'
              | 'MO'
              | 'MK'
              | 'MG'
              | 'MW'
              | 'MY'
              | 'MV'
              | 'ML'
              | 'MT'
              | 'MH'
              | 'MQ'
              | 'MR'
              | 'MU'
              | 'YT'
              | 'MX'
              | 'FM'
              | 'MD'
              | 'MC'
              | 'MN'
              | 'ME'
              | 'MS'
              | 'MA'
              | 'MZ'
              | 'MM'
              | 'NA'
              | 'NR'
              | 'NP'
              | 'NL'
              | 'AN'
              | 'NC'
              | 'NZ'
              | 'NI'
              | 'NE'
              | 'NG'
              | 'NU'
              | 'NF'
              | 'MP'
              | 'NO'
              | 'OM'
              | 'PK'
              | 'PW'
              | 'PS'
              | 'PA'
              | 'PG'
              | 'PY'
              | 'PE'
              | 'PH'
              | 'PN'
              | 'PL'
              | 'PT'
              | 'PR'
              | 'QA'
              | 'RE'
              | 'RO'
              | 'RU'
              | 'RW'
              | 'BL'
              | 'SH'
              | 'KN'
              | 'LC'
              | 'MF'
              | 'PM'
              | 'VC'
              | 'WS'
              | 'SM'
              | 'ST'
              | 'SA'
              | 'SN'
              | 'RS'
              | 'SC'
              | 'SL'
              | 'SG'
              | 'SK'
              | 'SI'
              | 'SB'
              | 'SO'
              | 'ZA'
              | 'GS'
              | 'ES'
              | 'LK'
              | 'SD'
              | 'SR'
              | 'SJ'
              | 'SZ'
              | 'SE'
              | 'CH'
              | 'SY'
              | 'TW'
              | 'TJ'
              | 'TZ'
              | 'TH'
              | 'TL'
              | 'TG'
              | 'TK'
              | 'TO'
              | 'TT'
              | 'TN'
              | 'TR'
              | 'TM'
              | 'TC'
              | 'TV'
              | 'UG'
              | 'UA'
              | 'AE'
              | 'GB'
              | 'US'
              | 'UM'
              | 'UY'
              | 'UZ'
              | 'VU'
              | 'VE'
              | 'VN'
              | 'VG'
              | 'VI'
              | 'WF'
              | 'EH'
              | 'YE'
              | 'ZM'
              | 'ZW'
            )
          | null;
        /**
         * The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}
         */
        latitude: string | null;
        /**
         * The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`
         */
        longitude: string | null;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'location';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * Numbers are persisted as 64 bit floats.
         */
        value: number;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'number';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The first name.
         */
        first_name: string;
        /**
         * The last name.
         */
        last_name: string;
        /**
         * The full name.
         */
        full_name: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'personal-name';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The raw, original phone number, as inputted.
         */
        original_phone_number: string;
        /**
         * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
         */
        country_code:
          | 'AF'
          | 'AX'
          | 'AL'
          | 'DZ'
          | 'AS'
          | 'AD'
          | 'AO'
          | 'AI'
          | 'AQ'
          | 'AG'
          | 'AR'
          | 'AM'
          | 'AW'
          | 'AU'
          | 'AT'
          | 'AZ'
          | 'BS'
          | 'BH'
          | 'BD'
          | 'BB'
          | 'BY'
          | 'BE'
          | 'BZ'
          | 'BJ'
          | 'BM'
          | 'BT'
          | 'BO'
          | 'BA'
          | 'BW'
          | 'BV'
          | 'BR'
          | 'IO'
          | 'BN'
          | 'BG'
          | 'BF'
          | 'BI'
          | 'KH'
          | 'CM'
          | 'CA'
          | 'CV'
          | 'KY'
          | 'CF'
          | 'TD'
          | 'CL'
          | 'CN'
          | 'CX'
          | 'CC'
          | 'CO'
          | 'KM'
          | 'CG'
          | 'CD'
          | 'CK'
          | 'CR'
          | 'CI'
          | 'HR'
          | 'CU'
          | 'CW'
          | 'CY'
          | 'CZ'
          | 'DK'
          | 'DJ'
          | 'DM'
          | 'DO'
          | 'EC'
          | 'EG'
          | 'SV'
          | 'GQ'
          | 'ER'
          | 'EE'
          | 'ET'
          | 'FK'
          | 'FO'
          | 'FJ'
          | 'FI'
          | 'FR'
          | 'GF'
          | 'PF'
          | 'TF'
          | 'GA'
          | 'GM'
          | 'GE'
          | 'DE'
          | 'GH'
          | 'GI'
          | 'GR'
          | 'GL'
          | 'GD'
          | 'GP'
          | 'GU'
          | 'GT'
          | 'GG'
          | 'GN'
          | 'GW'
          | 'GY'
          | 'HT'
          | 'HM'
          | 'VA'
          | 'HN'
          | 'HK'
          | 'HU'
          | 'IS'
          | 'IN'
          | 'ID'
          | 'IR'
          | 'IQ'
          | 'IE'
          | 'IM'
          | 'IL'
          | 'IT'
          | 'JM'
          | 'JP'
          | 'JE'
          | 'JO'
          | 'KZ'
          | 'KE'
          | 'KI'
          | 'KR'
          | 'KW'
          | 'KG'
          | 'LA'
          | 'LV'
          | 'LB'
          | 'LS'
          | 'LR'
          | 'LY'
          | 'LI'
          | 'LT'
          | 'LU'
          | 'MO'
          | 'MK'
          | 'MG'
          | 'MW'
          | 'MY'
          | 'MV'
          | 'ML'
          | 'MT'
          | 'MH'
          | 'MQ'
          | 'MR'
          | 'MU'
          | 'YT'
          | 'MX'
          | 'FM'
          | 'MD'
          | 'MC'
          | 'MN'
          | 'ME'
          | 'MS'
          | 'MA'
          | 'MZ'
          | 'MM'
          | 'NA'
          | 'NR'
          | 'NP'
          | 'NL'
          | 'AN'
          | 'NC'
          | 'NZ'
          | 'NI'
          | 'NE'
          | 'NG'
          | 'NU'
          | 'NF'
          | 'MP'
          | 'NO'
          | 'OM'
          | 'PK'
          | 'PW'
          | 'PS'
          | 'PA'
          | 'PG'
          | 'PY'
          | 'PE'
          | 'PH'
          | 'PN'
          | 'PL'
          | 'PT'
          | 'PR'
          | 'QA'
          | 'RE'
          | 'RO'
          | 'RU'
          | 'RW'
          | 'BL'
          | 'SH'
          | 'KN'
          | 'LC'
          | 'MF'
          | 'PM'
          | 'VC'
          | 'WS'
          | 'SM'
          | 'ST'
          | 'SA'
          | 'SN'
          | 'RS'
          | 'SC'
          | 'SL'
          | 'SG'
          | 'SK'
          | 'SI'
          | 'SB'
          | 'SO'
          | 'ZA'
          | 'GS'
          | 'ES'
          | 'LK'
          | 'SD'
          | 'SR'
          | 'SJ'
          | 'SZ'
          | 'SE'
          | 'CH'
          | 'SY'
          | 'TW'
          | 'TJ'
          | 'TZ'
          | 'TH'
          | 'TL'
          | 'TG'
          | 'TK'
          | 'TO'
          | 'TT'
          | 'TN'
          | 'TR'
          | 'TM'
          | 'TC'
          | 'TV'
          | 'UG'
          | 'UA'
          | 'AE'
          | 'GB'
          | 'US'
          | 'UM'
          | 'UY'
          | 'UZ'
          | 'VU'
          | 'VE'
          | 'VN'
          | 'VG'
          | 'VI'
          | 'WF'
          | 'EH'
          | 'YE'
          | 'ZM'
          | 'ZW';
        phone_number: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'phone-number';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        status: status;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'status';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A number between 0 and 5 (inclusive) to represent a star rating.
         */
        value: number;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'rating';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        option: select_option;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'select';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * A raw text field. Values are limited to 10MB.
         */
        value: string;
        /**
         * The attribute type of the value.
         */
        attribute_type: 'text';
      }
    | {
        /**
         * The point in time at which this value was made "active". `active_from` can be considered roughly analogous to `created_at`.
         */
        active_from: string;
        /**
         * The point in time at which this value was deactivated. If `null`, the value is active.
         */
        active_until: string | null;
        /**
         * The actor that created this value.
         */
        created_by_actor: {
          /**
           * An ID to identify the actor.
           */
          id?: string | null;
          /**
           * The type of actor. [Read more information on actor types here](/docs/actors).
           */
          type?: ('api-token' | 'workspace-member' | 'system') | null;
        };
        /**
         * The attribute type of the value.
         */
        attribute_type: 'timestamp';
        /**
         * A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, "2023", "2023-01", "2023-01-02", "2023-01-02T13:00", "2023-01-02T13:00:00", and "2023-01-02T13:00:00.000000000" will all be coerced to "2023-01-02T13:00:00.000000000Z". Timestamps are always returned in UTC. For example, writing a timestamp value using the string "2023-01-02T13:00:00.000000000+02:00" will result in the value "2023-01-02T11:00:00.000000000Z" being returned. The maximum date is "9999-12-31T23:59:59.999999999Z".
         */
        value: string;
      }
  >;
};

export type GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2WorkspaceMembersResponse = {
  data: Array<workspace_member>;
};

export type GetV2WorkspaceMembersError = unknown;

export type GetV2WorkspaceMembersByWorkspaceMemberIdData = {
  path: {
    workspace_member_id: string;
  };
};

export type GetV2WorkspaceMembersByWorkspaceMemberIdResponse = {
  data: workspace_member;
};

export type GetV2WorkspaceMembersByWorkspaceMemberIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2NotesData = {
  query?: {
    limit?: number;
    offset?: number;
    parent_object?: string;
    parent_record_id?: string;
  };
};

export type GetV2NotesResponse = {
  data: Array<note>;
};

export type GetV2NotesError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PostV2NotesData = {
  body: {
    data: {
      /**
       * The ID or slug of the parent object the note belongs to.
       */
      parent_object: string;
      /**
       * The ID of the parent record the note belongs to.
       */
      parent_record_id: string;
      /**
       * The note title. The title is plaintext only and has no formatting.
       */
      title: string;
      /**
       * The format of the note content to be created. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting, links and @references are not supported.
       */
      format: 'plaintext';
      /**
       * The representation of the note content in the specified format.
       */
      content: string;
      /**
       * `created_at` will default to the current time. However, if you wish to backdate a note for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed.
       */
      created_at?: string;
    };
  };
};

export type PostV2NotesResponse = {
  data: note;
};

export type PostV2NotesError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2NotesByNoteIdData = {
  path: {
    note_id: string;
  };
};

export type GetV2NotesByNoteIdResponse = {
  data: note;
};

export type GetV2NotesByNoteIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type DeleteV2NotesByNoteIdData = {
  path: {
    note_id: string;
  };
};

export type DeleteV2NotesByNoteIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2NotesByNoteIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2TasksData = {
  query?: {
    assignee?: string | null;
    is_completed?: boolean;
    limit?: number;
    linked_object?: string;
    linked_record_id?: string;
    offset?: number;
    sort?: 'created_at:asc' | 'created_at:desc';
  };
};

export type GetV2TasksResponse = {
  data: Array<task>;
};

export type GetV2TasksError = unknown;

export type PostV2TasksData = {
  body: {
    data: {
      /**
       * The text content of the task, in the format specified by the `format` property.
       */
      content: string;
      /**
       * The format of the task content to be created. Rich text formatting, links and @references are not supported.
       */
      format: 'plaintext';
      /**
       * The deadline of the task, in ISO 8601 format.
       */
      deadline_at: string | null;
      /**
       * Whether the task has been completed.
       */
      is_completed: boolean;
      /**
       * Records linked to the task. Creating record links within task content text is not possible via the API at present.
       */
      linked_records: Array<
        | {
            /**
             * The ID or slug of the parent object the tasks refers to. This can reference both standard and custom objects.`
             */
            target_object: string;
            /**
             * The ID of the parent record the task refers to.
             */
            target_record_id: string;
          }
        | {
            /**
             * A UUID or slug to identify the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * In addition to referencing records directly by record ID, you may also reference by a matching attribute of your choice. For example, if you want to add a reference to the person record with email "alice@website.com", you should pass a value with `target_object` set to `"people"` and `email_addresses` set to `[{email_address:"alice@website.com"}]`. The key should be the slug or ID of the matching attribute you would like to use and the value should be an array containing a single value of the appropriate attribute type (as specified below). Matching on multiple values is not currently supported. Matching attributes must be unique. This process is similar to how you use the `matching_attribute` query param in Attio's [assert endpoints](/reference/put_v2-objects-object-records).
             */
            '[slug_or_id_of_matching_attribute]': Array<
              | {
                  /**
                   * The full domain of the website.
                   */
                  domain?: string;
                }
              | {
                  /**
                   * An email address string
                   */
                  email_address?: string;
                }
              | {
                  /**
                   * Numbers are persisted as 64 bit floats.
                   */
                  value?: number;
                }
              | {
                  /**
                   * The raw, original phone number, as inputted.
                   */
                  original_phone_number?: string;
                  /**
                   * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
                   */
                  country_code?:
                    | (
                        | 'AF'
                        | 'AX'
                        | 'AL'
                        | 'DZ'
                        | 'AS'
                        | 'AD'
                        | 'AO'
                        | 'AI'
                        | 'AQ'
                        | 'AG'
                        | 'AR'
                        | 'AM'
                        | 'AW'
                        | 'AU'
                        | 'AT'
                        | 'AZ'
                        | 'BS'
                        | 'BH'
                        | 'BD'
                        | 'BB'
                        | 'BY'
                        | 'BE'
                        | 'BZ'
                        | 'BJ'
                        | 'BM'
                        | 'BT'
                        | 'BO'
                        | 'BA'
                        | 'BW'
                        | 'BV'
                        | 'BR'
                        | 'IO'
                        | 'BN'
                        | 'BG'
                        | 'BF'
                        | 'BI'
                        | 'KH'
                        | 'CM'
                        | 'CA'
                        | 'CV'
                        | 'KY'
                        | 'CF'
                        | 'TD'
                        | 'CL'
                        | 'CN'
                        | 'CX'
                        | 'CC'
                        | 'CO'
                        | 'KM'
                        | 'CG'
                        | 'CD'
                        | 'CK'
                        | 'CR'
                        | 'CI'
                        | 'HR'
                        | 'CU'
                        | 'CW'
                        | 'CY'
                        | 'CZ'
                        | 'DK'
                        | 'DJ'
                        | 'DM'
                        | 'DO'
                        | 'EC'
                        | 'EG'
                        | 'SV'
                        | 'GQ'
                        | 'ER'
                        | 'EE'
                        | 'ET'
                        | 'FK'
                        | 'FO'
                        | 'FJ'
                        | 'FI'
                        | 'FR'
                        | 'GF'
                        | 'PF'
                        | 'TF'
                        | 'GA'
                        | 'GM'
                        | 'GE'
                        | 'DE'
                        | 'GH'
                        | 'GI'
                        | 'GR'
                        | 'GL'
                        | 'GD'
                        | 'GP'
                        | 'GU'
                        | 'GT'
                        | 'GG'
                        | 'GN'
                        | 'GW'
                        | 'GY'
                        | 'HT'
                        | 'HM'
                        | 'VA'
                        | 'HN'
                        | 'HK'
                        | 'HU'
                        | 'IS'
                        | 'IN'
                        | 'ID'
                        | 'IR'
                        | 'IQ'
                        | 'IE'
                        | 'IM'
                        | 'IL'
                        | 'IT'
                        | 'JM'
                        | 'JP'
                        | 'JE'
                        | 'JO'
                        | 'KZ'
                        | 'KE'
                        | 'KI'
                        | 'KR'
                        | 'KW'
                        | 'KG'
                        | 'LA'
                        | 'LV'
                        | 'LB'
                        | 'LS'
                        | 'LR'
                        | 'LY'
                        | 'LI'
                        | 'LT'
                        | 'LU'
                        | 'MO'
                        | 'MK'
                        | 'MG'
                        | 'MW'
                        | 'MY'
                        | 'MV'
                        | 'ML'
                        | 'MT'
                        | 'MH'
                        | 'MQ'
                        | 'MR'
                        | 'MU'
                        | 'YT'
                        | 'MX'
                        | 'FM'
                        | 'MD'
                        | 'MC'
                        | 'MN'
                        | 'ME'
                        | 'MS'
                        | 'MA'
                        | 'MZ'
                        | 'MM'
                        | 'NA'
                        | 'NR'
                        | 'NP'
                        | 'NL'
                        | 'AN'
                        | 'NC'
                        | 'NZ'
                        | 'NI'
                        | 'NE'
                        | 'NG'
                        | 'NU'
                        | 'NF'
                        | 'MP'
                        | 'NO'
                        | 'OM'
                        | 'PK'
                        | 'PW'
                        | 'PS'
                        | 'PA'
                        | 'PG'
                        | 'PY'
                        | 'PE'
                        | 'PH'
                        | 'PN'
                        | 'PL'
                        | 'PT'
                        | 'PR'
                        | 'QA'
                        | 'RE'
                        | 'RO'
                        | 'RU'
                        | 'RW'
                        | 'BL'
                        | 'SH'
                        | 'KN'
                        | 'LC'
                        | 'MF'
                        | 'PM'
                        | 'VC'
                        | 'WS'
                        | 'SM'
                        | 'ST'
                        | 'SA'
                        | 'SN'
                        | 'RS'
                        | 'SC'
                        | 'SL'
                        | 'SG'
                        | 'SK'
                        | 'SI'
                        | 'SB'
                        | 'SO'
                        | 'ZA'
                        | 'GS'
                        | 'ES'
                        | 'LK'
                        | 'SD'
                        | 'SR'
                        | 'SJ'
                        | 'SZ'
                        | 'SE'
                        | 'CH'
                        | 'SY'
                        | 'TW'
                        | 'TJ'
                        | 'TZ'
                        | 'TH'
                        | 'TL'
                        | 'TG'
                        | 'TK'
                        | 'TO'
                        | 'TT'
                        | 'TN'
                        | 'TR'
                        | 'TM'
                        | 'TC'
                        | 'TV'
                        | 'UG'
                        | 'UA'
                        | 'AE'
                        | 'GB'
                        | 'US'
                        | 'UM'
                        | 'UY'
                        | 'UZ'
                        | 'VU'
                        | 'VE'
                        | 'VN'
                        | 'VG'
                        | 'VI'
                        | 'WF'
                        | 'EH'
                        | 'YE'
                        | 'ZM'
                        | 'ZW'
                      )
                    | null;
                }
              | {
                  /**
                   * A raw text field. Values are limited to 10MB.
                   */
                  value?: string;
                }
            >;
          }
      >;
      /**
       * Workspace members assigned to this task.
       */
      assignees: Array<
        | {
            /**
             * The actor type of the task assignee. Only `workspace-member` actors can be assigned to tasks. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'workspace-member';
            /**
             * The ID of the actor assigned to this task.
             */
            referenced_actor_id: string;
          }
        | {
            /**
             * Workspace member actors can be referenced by email address as well as actor ID.
             */
            workspace_member_email_address: string;
          }
      >;
    };
  };
};

export type PostV2TasksResponse = {
  data: task;
};

export type PostV2TasksError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type GetV2TasksByTaskIdData = {
  path: {
    task_id: string;
  };
};

export type GetV2TasksByTaskIdResponse = {
  data: task;
};

export type GetV2TasksByTaskIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2TasksByTaskIdData = {
  body: {
    data: {
      /**
       * The deadline of the task, in ISO 8601 format.
       */
      deadline_at?: string | null;
      /**
       * Whether the task has been completed.
       */
      is_completed?: boolean;
      /**
       * Records linked to the task. Creating record links within task content text is not possible via the API at present.
       */
      linked_records?: Array<
        | {
            /**
             * The ID or slug of the parent object the tasks refers to. This can reference both standard and custom objects.`
             */
            target_object: string;
            /**
             * The ID of the parent record the task refers to.
             */
            target_record_id: string;
          }
        | {
            /**
             * A UUID or slug to identify the object that the referenced record belongs to.
             */
            target_object: string;
            /**
             * In addition to referencing records directly by record ID, you may also reference by a matching attribute of your choice. For example, if you want to add a reference to the person record with email "alice@website.com", you should pass a value with `target_object` set to `"people"` and `email_addresses` set to `[{email_address:"alice@website.com"}]`. The key should be the slug or ID of the matching attribute you would like to use and the value should be an array containing a single value of the appropriate attribute type (as specified below). Matching on multiple values is not currently supported. Matching attributes must be unique. This process is similar to how you use the `matching_attribute` query param in Attio's [assert endpoints](/reference/put_v2-objects-object-records).
             */
            '[slug_or_id_of_matching_attribute]': Array<
              | {
                  /**
                   * The full domain of the website.
                   */
                  domain?: string;
                }
              | {
                  /**
                   * An email address string
                   */
                  email_address?: string;
                }
              | {
                  /**
                   * Numbers are persisted as 64 bit floats.
                   */
                  value?: number;
                }
              | {
                  /**
                   * The raw, original phone number, as inputted.
                   */
                  original_phone_number?: string;
                  /**
                   * The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to.
                   */
                  country_code?:
                    | (
                        | 'AF'
                        | 'AX'
                        | 'AL'
                        | 'DZ'
                        | 'AS'
                        | 'AD'
                        | 'AO'
                        | 'AI'
                        | 'AQ'
                        | 'AG'
                        | 'AR'
                        | 'AM'
                        | 'AW'
                        | 'AU'
                        | 'AT'
                        | 'AZ'
                        | 'BS'
                        | 'BH'
                        | 'BD'
                        | 'BB'
                        | 'BY'
                        | 'BE'
                        | 'BZ'
                        | 'BJ'
                        | 'BM'
                        | 'BT'
                        | 'BO'
                        | 'BA'
                        | 'BW'
                        | 'BV'
                        | 'BR'
                        | 'IO'
                        | 'BN'
                        | 'BG'
                        | 'BF'
                        | 'BI'
                        | 'KH'
                        | 'CM'
                        | 'CA'
                        | 'CV'
                        | 'KY'
                        | 'CF'
                        | 'TD'
                        | 'CL'
                        | 'CN'
                        | 'CX'
                        | 'CC'
                        | 'CO'
                        | 'KM'
                        | 'CG'
                        | 'CD'
                        | 'CK'
                        | 'CR'
                        | 'CI'
                        | 'HR'
                        | 'CU'
                        | 'CW'
                        | 'CY'
                        | 'CZ'
                        | 'DK'
                        | 'DJ'
                        | 'DM'
                        | 'DO'
                        | 'EC'
                        | 'EG'
                        | 'SV'
                        | 'GQ'
                        | 'ER'
                        | 'EE'
                        | 'ET'
                        | 'FK'
                        | 'FO'
                        | 'FJ'
                        | 'FI'
                        | 'FR'
                        | 'GF'
                        | 'PF'
                        | 'TF'
                        | 'GA'
                        | 'GM'
                        | 'GE'
                        | 'DE'
                        | 'GH'
                        | 'GI'
                        | 'GR'
                        | 'GL'
                        | 'GD'
                        | 'GP'
                        | 'GU'
                        | 'GT'
                        | 'GG'
                        | 'GN'
                        | 'GW'
                        | 'GY'
                        | 'HT'
                        | 'HM'
                        | 'VA'
                        | 'HN'
                        | 'HK'
                        | 'HU'
                        | 'IS'
                        | 'IN'
                        | 'ID'
                        | 'IR'
                        | 'IQ'
                        | 'IE'
                        | 'IM'
                        | 'IL'
                        | 'IT'
                        | 'JM'
                        | 'JP'
                        | 'JE'
                        | 'JO'
                        | 'KZ'
                        | 'KE'
                        | 'KI'
                        | 'KR'
                        | 'KW'
                        | 'KG'
                        | 'LA'
                        | 'LV'
                        | 'LB'
                        | 'LS'
                        | 'LR'
                        | 'LY'
                        | 'LI'
                        | 'LT'
                        | 'LU'
                        | 'MO'
                        | 'MK'
                        | 'MG'
                        | 'MW'
                        | 'MY'
                        | 'MV'
                        | 'ML'
                        | 'MT'
                        | 'MH'
                        | 'MQ'
                        | 'MR'
                        | 'MU'
                        | 'YT'
                        | 'MX'
                        | 'FM'
                        | 'MD'
                        | 'MC'
                        | 'MN'
                        | 'ME'
                        | 'MS'
                        | 'MA'
                        | 'MZ'
                        | 'MM'
                        | 'NA'
                        | 'NR'
                        | 'NP'
                        | 'NL'
                        | 'AN'
                        | 'NC'
                        | 'NZ'
                        | 'NI'
                        | 'NE'
                        | 'NG'
                        | 'NU'
                        | 'NF'
                        | 'MP'
                        | 'NO'
                        | 'OM'
                        | 'PK'
                        | 'PW'
                        | 'PS'
                        | 'PA'
                        | 'PG'
                        | 'PY'
                        | 'PE'
                        | 'PH'
                        | 'PN'
                        | 'PL'
                        | 'PT'
                        | 'PR'
                        | 'QA'
                        | 'RE'
                        | 'RO'
                        | 'RU'
                        | 'RW'
                        | 'BL'
                        | 'SH'
                        | 'KN'
                        | 'LC'
                        | 'MF'
                        | 'PM'
                        | 'VC'
                        | 'WS'
                        | 'SM'
                        | 'ST'
                        | 'SA'
                        | 'SN'
                        | 'RS'
                        | 'SC'
                        | 'SL'
                        | 'SG'
                        | 'SK'
                        | 'SI'
                        | 'SB'
                        | 'SO'
                        | 'ZA'
                        | 'GS'
                        | 'ES'
                        | 'LK'
                        | 'SD'
                        | 'SR'
                        | 'SJ'
                        | 'SZ'
                        | 'SE'
                        | 'CH'
                        | 'SY'
                        | 'TW'
                        | 'TJ'
                        | 'TZ'
                        | 'TH'
                        | 'TL'
                        | 'TG'
                        | 'TK'
                        | 'TO'
                        | 'TT'
                        | 'TN'
                        | 'TR'
                        | 'TM'
                        | 'TC'
                        | 'TV'
                        | 'UG'
                        | 'UA'
                        | 'AE'
                        | 'GB'
                        | 'US'
                        | 'UM'
                        | 'UY'
                        | 'UZ'
                        | 'VU'
                        | 'VE'
                        | 'VN'
                        | 'VG'
                        | 'VI'
                        | 'WF'
                        | 'EH'
                        | 'YE'
                        | 'ZM'
                        | 'ZW'
                      )
                    | null;
                }
              | {
                  /**
                   * A raw text field. Values are limited to 10MB.
                   */
                  value?: string;
                }
            >;
          }
      >;
      /**
       * Workspace members assigned to this task.
       */
      assignees?: Array<
        | {
            /**
             * The actor type of the task assignee. Only `workspace-member` actors can be assigned to tasks. [Read more information on actor types here](/docs/actors).
             */
            referenced_actor_type: 'workspace-member';
            /**
             * The ID of the actor assigned to this task.
             */
            referenced_actor_id: string;
          }
        | {
            /**
             * Workspace member actors can be referenced by email address as well as actor ID.
             */
            workspace_member_email_address: string;
          }
      >;
    };
  };
  path: {
    task_id: string;
  };
};

export type PatchV2TasksByTaskIdResponse = {
  data: task;
};

export type PatchV2TasksByTaskIdError =
  | {
      status_code: 400;
      type: 'invalid_request_error';
      code: 'validation_type';
      message: string;
    }
  | {
      status_code: 404;
      type: 'invalid_request_error';
      code: 'not_found';
      message: string;
    };

export type DeleteV2TasksByTaskIdData = {
  path: {
    task_id: string;
  };
};

export type DeleteV2TasksByTaskIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2TasksByTaskIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2ThreadsData = {
  query?: {
    entry_id?: string;
    limit?: number;
    list?: string;
    object?: string;
    offset?: number;
    record_id?: string;
  };
};

export type GetV2ThreadsResponse = {
  data: Array<thread>;
};

export type GetV2ThreadsError = unknown;

export type GetV2ThreadsByThreadIdData = {
  path: {
    thread_id: string;
  };
};

export type GetV2ThreadsByThreadIdResponse = {
  data: thread;
};

export type GetV2ThreadsByThreadIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PostV2CommentsData = {
  body: {
    data:
      | {
          /**
           * The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported.
           */
          format: 'plaintext';
          /**
           * The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links.
           */
          content: string;
          /**
           * The workspace member who wrote this comment. Note that other types of actors are not currently supported.
           */
          author: {
            type: 'workspace-member';
            id: string;
          };
          /**
           * `created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed.
           */
          created_at?: string;
          /**
           * If responding to an existing thread, this would be the ID of that thread.
           */
          thread_id: string;
        }
      | {
          /**
           * The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported.
           */
          format: 'plaintext';
          /**
           * The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links.
           */
          content: string;
          /**
           * The workspace member who wrote this comment. Note that other types of actors are not currently supported.
           */
          author: {
            type: 'workspace-member';
            id: string;
          };
          /**
           * `created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed.
           */
          created_at?: string;
          record: {
            /**
             * If creating a top-level comment on a record, this is the slug or ID of that object.
             */
            object: string;
            /**
             * If creating a top-level comment on a record, this is the ID of that record.
             */
            record_id: string;
          };
        }
      | {
          /**
           * The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported.
           */
          format: 'plaintext';
          /**
           * The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links.
           */
          content: string;
          /**
           * The workspace member who wrote this comment. Note that other types of actors are not currently supported.
           */
          author: {
            type: 'workspace-member';
            id: string;
          };
          /**
           * `created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed.
           */
          created_at?: string;
          entry: {
            /**
             * If creating a top-level comment on a list entry, this is the slug or ID of that list.
             */
            list: string;
            /**
             * If creating a top-level comment on a list entry, this is the ID of that entry.
             */
            entry_id: string;
          };
        };
  };
};

export type PostV2CommentsResponse = {
  data: comment;
};

export type PostV2CommentsError = {
  statusCode: 400;
  type: 'invalid_request_error';
  code: 'value_not_found';
  message: string;
};

export type GetV2CommentsByCommentIdData = {
  path: {
    comment_id: string;
  };
};

export type GetV2CommentsByCommentIdResponse = {
  data: comment;
};

export type GetV2CommentsByCommentIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type DeleteV2CommentsByCommentIdData = {
  path: {
    comment_id: string;
  };
};

export type DeleteV2CommentsByCommentIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2CommentsByCommentIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2WebhooksData = {
  query?: {
    limit?: number;
    offset?: number;
  };
};

export type GetV2WebhooksResponse = {
  data: Array<{
    /**
     * URL where the webhook events will be delivered to.
     */
    target_url: string;
    /**
     * One or more events the webhook is subscribed to.
     */
    subscriptions: Array<{
      /**
       * Type of event the webhook is subscribed to.
       */
      event_type:
        | 'comment.created'
        | 'comment.resolved'
        | 'comment.unresolved'
        | 'comment.deleted'
        | 'list.created'
        | 'list.updated'
        | 'list.deleted'
        | 'list-attribute.created'
        | 'list-attribute.updated'
        | 'list-entry.created'
        | 'list-entry.updated'
        | 'list-entry.deleted'
        | 'object-attribute.created'
        | 'object-attribute.updated'
        | 'note.created'
        | 'note.updated'
        | 'note.deleted'
        | 'record.created'
        | 'record.merged'
        | 'record.updated'
        | 'record.deleted'
        | 'task.created'
        | 'task.updated'
        | 'task.deleted'
        | 'workspace-member.created';
      /**
       * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
       */
      filter:
        | {
            $or: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | {
            $and: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | null;
    }>;
    id: {
      /**
       * The ID of the workspace the webhook belongs to.
       */
      workspace_id: string;
      /**
       * The ID of the webhook.
       */
      webhook_id: string;
    };
    /**
     * The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive.
     */
    status: 'active' | 'degraded' | 'inactive';
    /**
     * When the webhook was created.
     */
    created_at: string;
  }>;
};

export type GetV2WebhooksError = unknown;

export type PostV2WebhooksData = {
  body: {
    data: {
      /**
       * URL where the webhook events will be delivered to.
       */
      target_url: string;
      /**
       * One or more events the webhook is subscribed to.
       */
      subscriptions: Array<{
        /**
         * Type of event the webhook is subscribed to.
         */
        event_type:
          | 'comment.created'
          | 'comment.resolved'
          | 'comment.unresolved'
          | 'comment.deleted'
          | 'list.created'
          | 'list.updated'
          | 'list.deleted'
          | 'list-attribute.created'
          | 'list-attribute.updated'
          | 'list-entry.created'
          | 'list-entry.updated'
          | 'list-entry.deleted'
          | 'object-attribute.created'
          | 'object-attribute.updated'
          | 'note.created'
          | 'note.updated'
          | 'note.deleted'
          | 'record.created'
          | 'record.merged'
          | 'record.updated'
          | 'record.deleted'
          | 'task.created'
          | 'task.updated'
          | 'task.deleted'
          | 'workspace-member.created';
        /**
         * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
         */
        filter:
          | {
              $or: Array<
                | {
                    field: string;
                    operator: 'equals';
                    value: string;
                  }
                | {
                    field: string;
                    operator: 'not_equals';
                    value: string;
                  }
              >;
            }
          | {
              $and: Array<
                | {
                    field: string;
                    operator: 'equals';
                    value: string;
                  }
                | {
                    field: string;
                    operator: 'not_equals';
                    value: string;
                  }
              >;
            }
          | null;
      }>;
    };
  };
};

export type PostV2WebhooksResponse = {
  data: {
    /**
     * URL where the webhook events will be delivered to.
     */
    target_url: string;
    /**
     * One or more events the webhook is subscribed to.
     */
    subscriptions: Array<{
      /**
       * Type of event the webhook is subscribed to.
       */
      event_type:
        | 'comment.created'
        | 'comment.resolved'
        | 'comment.unresolved'
        | 'comment.deleted'
        | 'list.created'
        | 'list.updated'
        | 'list.deleted'
        | 'list-attribute.created'
        | 'list-attribute.updated'
        | 'list-entry.created'
        | 'list-entry.updated'
        | 'list-entry.deleted'
        | 'object-attribute.created'
        | 'object-attribute.updated'
        | 'note.created'
        | 'note.updated'
        | 'note.deleted'
        | 'record.created'
        | 'record.merged'
        | 'record.updated'
        | 'record.deleted'
        | 'task.created'
        | 'task.updated'
        | 'task.deleted'
        | 'workspace-member.created';
      /**
       * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
       */
      filter:
        | {
            $or: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | {
            $and: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | null;
    }>;
    id: {
      /**
       * The ID of the workspace the webhook belongs to.
       */
      workspace_id: string;
      /**
       * The ID of the webhook.
       */
      webhook_id: string;
    };
    /**
     * The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive.
     */
    status: 'active' | 'degraded' | 'inactive';
    /**
     * When the webhook was created.
     */
    created_at: string;
    /**
     * The key which is used to sign the webhook events. This is only shown when setting up the webhook initially.
     */
    secret: string;
  };
};

export type PostV2WebhooksError = {
  status_code: 400;
  type: 'invalid_request_error';
  code: 'validation_type';
  message: string;
};

export type GetV2WebhooksByWebhookIdData = {
  path: {
    webhook_id: string;
  };
};

export type GetV2WebhooksByWebhookIdResponse = {
  data: {
    /**
     * URL where the webhook events will be delivered to.
     */
    target_url: string;
    /**
     * One or more events the webhook is subscribed to.
     */
    subscriptions: Array<{
      /**
       * Type of event the webhook is subscribed to.
       */
      event_type:
        | 'comment.created'
        | 'comment.resolved'
        | 'comment.unresolved'
        | 'comment.deleted'
        | 'list.created'
        | 'list.updated'
        | 'list.deleted'
        | 'list-attribute.created'
        | 'list-attribute.updated'
        | 'list-entry.created'
        | 'list-entry.updated'
        | 'list-entry.deleted'
        | 'object-attribute.created'
        | 'object-attribute.updated'
        | 'note.created'
        | 'note.updated'
        | 'note.deleted'
        | 'record.created'
        | 'record.merged'
        | 'record.updated'
        | 'record.deleted'
        | 'task.created'
        | 'task.updated'
        | 'task.deleted'
        | 'workspace-member.created';
      /**
       * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
       */
      filter:
        | {
            $or: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | {
            $and: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | null;
    }>;
    id: {
      /**
       * The ID of the workspace the webhook belongs to.
       */
      workspace_id: string;
      /**
       * The ID of the webhook.
       */
      webhook_id: string;
    };
    /**
     * The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive.
     */
    status: 'active' | 'degraded' | 'inactive';
    /**
     * When the webhook was created.
     */
    created_at: string;
  };
};

export type GetV2WebhooksByWebhookIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type PatchV2WebhooksByWebhookIdData = {
  body: {
    data: {
      /**
       * URL where the webhook events will be delivered to.
       */
      target_url?: string;
      /**
       * One or more events the webhook is subscribed to.
       */
      subscriptions?: Array<{
        /**
         * Type of event the webhook is subscribed to.
         */
        event_type:
          | 'comment.created'
          | 'comment.resolved'
          | 'comment.unresolved'
          | 'comment.deleted'
          | 'list.created'
          | 'list.updated'
          | 'list.deleted'
          | 'list-attribute.created'
          | 'list-attribute.updated'
          | 'list-entry.created'
          | 'list-entry.updated'
          | 'list-entry.deleted'
          | 'object-attribute.created'
          | 'object-attribute.updated'
          | 'note.created'
          | 'note.updated'
          | 'note.deleted'
          | 'record.created'
          | 'record.merged'
          | 'record.updated'
          | 'record.deleted'
          | 'task.created'
          | 'task.updated'
          | 'task.deleted'
          | 'workspace-member.created';
        /**
         * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
         */
        filter:
          | {
              $or: Array<
                | {
                    field: string;
                    operator: 'equals';
                    value: string;
                  }
                | {
                    field: string;
                    operator: 'not_equals';
                    value: string;
                  }
              >;
            }
          | {
              $and: Array<
                | {
                    field: string;
                    operator: 'equals';
                    value: string;
                  }
                | {
                    field: string;
                    operator: 'not_equals';
                    value: string;
                  }
              >;
            }
          | null;
      }>;
    };
  };
  path: {
    webhook_id: string;
  };
};

export type PatchV2WebhooksByWebhookIdResponse = {
  data: {
    /**
     * URL where the webhook events will be delivered to.
     */
    target_url: string;
    /**
     * One or more events the webhook is subscribed to.
     */
    subscriptions: Array<{
      /**
       * Type of event the webhook is subscribed to.
       */
      event_type:
        | 'comment.created'
        | 'comment.resolved'
        | 'comment.unresolved'
        | 'comment.deleted'
        | 'list.created'
        | 'list.updated'
        | 'list.deleted'
        | 'list-attribute.created'
        | 'list-attribute.updated'
        | 'list-entry.created'
        | 'list-entry.updated'
        | 'list-entry.deleted'
        | 'object-attribute.created'
        | 'object-attribute.updated'
        | 'note.created'
        | 'note.updated'
        | 'note.deleted'
        | 'record.created'
        | 'record.merged'
        | 'record.updated'
        | 'record.deleted'
        | 'task.created'
        | 'task.updated'
        | 'task.deleted'
        | 'workspace-member.created';
      /**
       * Filters to determine whether the webhook event should be sent. If null, the filter always passes.
       */
      filter:
        | {
            $or: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | {
            $and: Array<
              | {
                  field: string;
                  operator: 'equals';
                  value: string;
                }
              | {
                  field: string;
                  operator: 'not_equals';
                  value: string;
                }
            >;
          }
        | null;
    }>;
    id: {
      /**
       * The ID of the workspace the webhook belongs to.
       */
      workspace_id: string;
      /**
       * The ID of the webhook.
       */
      webhook_id: string;
    };
    /**
     * The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive.
     */
    status: 'active' | 'degraded' | 'inactive';
    /**
     * When the webhook was created.
     */
    created_at: string;
  };
};

export type PatchV2WebhooksByWebhookIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type DeleteV2WebhooksByWebhookIdData = {
  path: {
    webhook_id: string;
  };
};

export type DeleteV2WebhooksByWebhookIdResponse = {
  [key: string]: unknown;
};

export type DeleteV2WebhooksByWebhookIdError = {
  status_code: 404;
  type: 'invalid_request_error';
  code: 'not_found';
  message: string;
};

export type GetV2SelfResponse =
  | {
      active: boolean;
    }
  | {
      /**
       * Whether the token is currently active and usable.
       */
      active: boolean;
      /**
       * A space-separated list of scopes associated with this token
       */
      scope: string;
      /**
       * The app ID of the OAuth application that requested this token
       */
      client_id: string;
      /**
       * The type of token, always Bearer for tokens acquired via the OAuth 2.0 flow.
       */
      token_type: 'Bearer';
      /**
       * The time at which this token will expire, if set, as a number of seconds since January 1 1970 UTC.
       */
      exp: number | null;
      /**
       * The time at which this token was issued, as a number of seconds since January 1 1970 UTC.
       */
      iat: number;
      /**
       * Since Bearer tokens grant Workspace-level permissions, this property contains the workspace_id.
       */
      sub: string;
      /**
       * The intended audience for this token, for Bearer tokens this is the same as the client_id.
       */
      aud: string;
      /**
       * The issuer of the token. Always attio.com
       */
      iss: 'attio.com';
      /**
       * The ID of the workspace member who authorised this token initially, if known
       */
      authorized_by_workspace_member_id: string | null;
      /**
       * The ID of the workspace the token is scoped to.
       */
      workspace_id: string;
      /**
       * The name of the workspace the token is scoped to.
       */
      workspace_name: string;
      /**
       * The slug of the workspace the token is scoped to.
       */
      workspace_slug: string;
      /**
       * The logo URL of the workspace the token is scoped to.
       */
      workspace_logo_url: string | null;
    };

export type GetV2SelfError = unknown;
