// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetV2ObjectsError,
  GetV2ObjectsResponse,
  PostV2ObjectsData,
  PostV2ObjectsError,
  PostV2ObjectsResponse,
  GetV2ObjectsByObjectData,
  GetV2ObjectsByObjectError,
  GetV2ObjectsByObjectResponse,
  PatchV2ObjectsByObjectData,
  PatchV2ObjectsByObjectError,
  PatchV2ObjectsByObjectResponse,
  GetV2ByTargetByIdentifierAttributesData,
  GetV2ByTargetByIdentifierAttributesError,
  GetV2ByTargetByIdentifierAttributesResponse,
  PostV2ByTargetByIdentifierAttributesData,
  PostV2ByTargetByIdentifierAttributesError,
  PostV2ByTargetByIdentifierAttributesResponse,
  GetV2ByTargetByIdentifierAttributesByAttributeData,
  GetV2ByTargetByIdentifierAttributesByAttributeError,
  GetV2ByTargetByIdentifierAttributesByAttributeResponse,
  PatchV2ByTargetByIdentifierAttributesByAttributeData,
  PatchV2ByTargetByIdentifierAttributesByAttributeError,
  PatchV2ByTargetByIdentifierAttributesByAttributeResponse,
  GetV2ByTargetByIdentifierAttributesByAttributeOptionsData,
  GetV2ByTargetByIdentifierAttributesByAttributeOptionsError,
  GetV2ByTargetByIdentifierAttributesByAttributeOptionsResponse,
  PostV2ByTargetByIdentifierAttributesByAttributeOptionsData,
  PostV2ByTargetByIdentifierAttributesByAttributeOptionsError,
  PostV2ByTargetByIdentifierAttributesByAttributeOptionsResponse,
  PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionData,
  PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionError,
  PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionResponse,
  GetV2ByTargetByIdentifierAttributesByAttributeStatusesData,
  GetV2ByTargetByIdentifierAttributesByAttributeStatusesError,
  GetV2ByTargetByIdentifierAttributesByAttributeStatusesResponse,
  PostV2ByTargetByIdentifierAttributesByAttributeStatusesData,
  PostV2ByTargetByIdentifierAttributesByAttributeStatusesError,
  PostV2ByTargetByIdentifierAttributesByAttributeStatusesResponse,
  PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusData,
  PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusError,
  PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusResponse,
  PostV2ObjectsByObjectRecordsQueryData,
  PostV2ObjectsByObjectRecordsQueryError,
  PostV2ObjectsByObjectRecordsQueryResponse,
  PostV2ObjectsByObjectRecordsData,
  PostV2ObjectsByObjectRecordsError,
  PostV2ObjectsByObjectRecordsResponse,
  PutV2ObjectsByObjectRecordsData,
  PutV2ObjectsByObjectRecordsError,
  PutV2ObjectsByObjectRecordsResponse,
  GetV2ObjectsByObjectRecordsByRecordIdData,
  GetV2ObjectsByObjectRecordsByRecordIdError,
  GetV2ObjectsByObjectRecordsByRecordIdResponse,
  PatchV2ObjectsByObjectRecordsByRecordIdData,
  PatchV2ObjectsByObjectRecordsByRecordIdError,
  PatchV2ObjectsByObjectRecordsByRecordIdResponse,
  DeleteV2ObjectsByObjectRecordsByRecordIdData,
  DeleteV2ObjectsByObjectRecordsByRecordIdError,
  DeleteV2ObjectsByObjectRecordsByRecordIdResponse,
  GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesData,
  GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesError,
  GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesResponse,
  GetV2ObjectsByObjectRecordsByRecordIdEntriesData,
  GetV2ObjectsByObjectRecordsByRecordIdEntriesError,
  GetV2ObjectsByObjectRecordsByRecordIdEntriesResponse,
  GetV2ListsError,
  GetV2ListsResponse,
  PostV2ListsData,
  PostV2ListsError,
  PostV2ListsResponse,
  GetV2ListsByListData,
  GetV2ListsByListError,
  GetV2ListsByListResponse,
  PatchV2ListsByListData,
  PatchV2ListsByListError,
  PatchV2ListsByListResponse,
  PostV2ListsByListEntriesQueryData,
  PostV2ListsByListEntriesQueryError,
  PostV2ListsByListEntriesQueryResponse,
  PostV2ListsByListEntriesData,
  PostV2ListsByListEntriesError,
  PostV2ListsByListEntriesResponse,
  PutV2ListsByListEntriesData,
  PutV2ListsByListEntriesError,
  PutV2ListsByListEntriesResponse,
  GetV2ListsByListEntriesByEntryIdData,
  GetV2ListsByListEntriesByEntryIdError,
  GetV2ListsByListEntriesByEntryIdResponse,
  PatchV2ListsByListEntriesByEntryIdData,
  PatchV2ListsByListEntriesByEntryIdError,
  PatchV2ListsByListEntriesByEntryIdResponse,
  PutV2ListsByListEntriesByEntryIdData,
  PutV2ListsByListEntriesByEntryIdError,
  PutV2ListsByListEntriesByEntryIdResponse,
  DeleteV2ListsByListEntriesByEntryIdData,
  DeleteV2ListsByListEntriesByEntryIdError,
  DeleteV2ListsByListEntriesByEntryIdResponse,
  GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesData,
  GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesError,
  GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesResponse,
  GetV2WorkspaceMembersError,
  GetV2WorkspaceMembersResponse,
  GetV2WorkspaceMembersByWorkspaceMemberIdData,
  GetV2WorkspaceMembersByWorkspaceMemberIdError,
  GetV2WorkspaceMembersByWorkspaceMemberIdResponse,
  GetV2NotesData,
  GetV2NotesError,
  GetV2NotesResponse,
  PostV2NotesData,
  PostV2NotesError,
  PostV2NotesResponse,
  GetV2NotesByNoteIdData,
  GetV2NotesByNoteIdError,
  GetV2NotesByNoteIdResponse,
  DeleteV2NotesByNoteIdData,
  DeleteV2NotesByNoteIdError,
  DeleteV2NotesByNoteIdResponse,
  GetV2TasksData,
  GetV2TasksError,
  GetV2TasksResponse,
  PostV2TasksData,
  PostV2TasksError,
  PostV2TasksResponse,
  GetV2TasksByTaskIdData,
  GetV2TasksByTaskIdError,
  GetV2TasksByTaskIdResponse,
  PatchV2TasksByTaskIdData,
  PatchV2TasksByTaskIdError,
  PatchV2TasksByTaskIdResponse,
  DeleteV2TasksByTaskIdData,
  DeleteV2TasksByTaskIdError,
  DeleteV2TasksByTaskIdResponse,
  GetV2ThreadsData,
  GetV2ThreadsError,
  GetV2ThreadsResponse,
  GetV2ThreadsByThreadIdData,
  GetV2ThreadsByThreadIdError,
  GetV2ThreadsByThreadIdResponse,
  PostV2CommentsData,
  PostV2CommentsError,
  PostV2CommentsResponse,
  GetV2CommentsByCommentIdData,
  GetV2CommentsByCommentIdError,
  GetV2CommentsByCommentIdResponse,
  DeleteV2CommentsByCommentIdData,
  DeleteV2CommentsByCommentIdError,
  DeleteV2CommentsByCommentIdResponse,
  GetV2WebhooksData,
  GetV2WebhooksError,
  GetV2WebhooksResponse,
  PostV2WebhooksData,
  PostV2WebhooksError,
  PostV2WebhooksResponse,
  GetV2WebhooksByWebhookIdData,
  GetV2WebhooksByWebhookIdError,
  GetV2WebhooksByWebhookIdResponse,
  PatchV2WebhooksByWebhookIdData,
  PatchV2WebhooksByWebhookIdError,
  PatchV2WebhooksByWebhookIdResponse,
  DeleteV2WebhooksByWebhookIdData,
  DeleteV2WebhooksByWebhookIdError,
  DeleteV2WebhooksByWebhookIdResponse,
  GetV2SelfError,
  GetV2SelfResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List objects
 * Lists all system-defined and user-defined objects in your workspace.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2Objects = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2ObjectsResponse, GetV2ObjectsError, ThrowOnError>({
    ...options,
    url: '/v2/objects',
  });
};

/**
 * Create an object
 * Creates a new custom object in your workspace.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const postV2Objects = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ObjectsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2ObjectsResponse, PostV2ObjectsError, ThrowOnError>({
    ...options,
    url: '/v2/objects',
  });
};

/**
 * Get an object
 * Gets a single object by its `object_id` or slug.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2ObjectsByObject = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ObjectsByObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ObjectsByObjectResponse, GetV2ObjectsByObjectError, ThrowOnError>({
    ...options,
    url: '/v2/objects/{object}',
  });
};

/**
 * Update an object
 * Updates a single object. The object to be updated is identified by its `object_id`.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const patchV2ObjectsByObject = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ObjectsByObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchV2ObjectsByObjectResponse, PatchV2ObjectsByObjectError, ThrowOnError>({
    ...options,
    url: '/v2/objects/{object}',
  });
};

/**
 * List attributes
 * Lists all attributes defined on a specific object or list. Attributes are returned in the order that they are sorted by in the UI.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2ByTargetByIdentifierAttributes = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ByTargetByIdentifierAttributesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ByTargetByIdentifierAttributesResponse,
    GetV2ByTargetByIdentifierAttributesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes',
  });
};

/**
 * Create an attribute
 * Creates a new attribute on either an object or a list.
 *
 * To create an attribute on an object, you must also have the `object_configuration:read-write` scope.
 *
 * To create an attribute on a list, you must also have the `list_configuration:read-write` scope.
 */
export const postV2ByTargetByIdentifierAttributes = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ByTargetByIdentifierAttributesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ByTargetByIdentifierAttributesResponse,
    PostV2ByTargetByIdentifierAttributesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes',
  });
};

/**
 * Get an attribute
 * Gets information about a single attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2ByTargetByIdentifierAttributesByAttribute = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ByTargetByIdentifierAttributesByAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ByTargetByIdentifierAttributesByAttributeResponse,
    GetV2ByTargetByIdentifierAttributesByAttributeError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}',
  });
};

/**
 * Update an attribute
 * Updates a single attribute on a given object or list.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const patchV2ByTargetByIdentifierAttributesByAttribute = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ByTargetByIdentifierAttributesByAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2ByTargetByIdentifierAttributesByAttributeResponse,
    PatchV2ByTargetByIdentifierAttributesByAttributeError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}',
  });
};

/**
 * List select options
 * Lists all select options for a particular attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2ByTargetByIdentifierAttributesByAttributeOptions = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ByTargetByIdentifierAttributesByAttributeOptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ByTargetByIdentifierAttributesByAttributeOptionsResponse,
    GetV2ByTargetByIdentifierAttributesByAttributeOptionsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/options',
  });
};

/**
 * Create a select option
 * Adds a select option to a select attribute on an object or a list.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const postV2ByTargetByIdentifierAttributesByAttributeOptions = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ByTargetByIdentifierAttributesByAttributeOptionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ByTargetByIdentifierAttributesByAttributeOptionsResponse,
    PostV2ByTargetByIdentifierAttributesByAttributeOptionsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/options',
  });
};

/**
 * Update a select option
 * Updates a select option on an attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const patchV2ByTargetByIdentifierAttributesByAttributeOptionsByOption = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionResponse,
    PatchV2ByTargetByIdentifierAttributesByAttributeOptionsByOptionError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/options/{option}',
  });
};

/**
 * List statuses
 * Lists all statuses for a particular status attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read`.
 */
export const getV2ByTargetByIdentifierAttributesByAttributeStatuses = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ByTargetByIdentifierAttributesByAttributeStatusesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ByTargetByIdentifierAttributesByAttributeStatusesResponse,
    GetV2ByTargetByIdentifierAttributesByAttributeStatusesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/statuses',
  });
};

/**
 * Create a status
 * Add a new status to a status attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const postV2ByTargetByIdentifierAttributesByAttributeStatuses = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ByTargetByIdentifierAttributesByAttributeStatusesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ByTargetByIdentifierAttributesByAttributeStatusesResponse,
    PostV2ByTargetByIdentifierAttributesByAttributeStatusesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/statuses',
  });
};

/**
 * Update a status
 * Update a status on an status attribute on either an object or a list.
 *
 * Required scopes: `object_configuration:read-write`.
 */
export const patchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatus = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusResponse,
    PatchV2ByTargetByIdentifierAttributesByAttributeStatusesByStatusError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{target}/{identifier}/attributes/{attribute}/statuses/{status}',
  });
};

/**
 * List records
 * Lists people, company or other records, with the option to filter and sort results.
 *
 * Required scopes: `record_permission:read`, `object_configuration:read`.
 */
export const postV2ObjectsByObjectRecordsQuery = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ObjectsByObjectRecordsQueryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ObjectsByObjectRecordsQueryResponse,
    PostV2ObjectsByObjectRecordsQueryError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/query',
  });
};

/**
 * Create a record
 * Creates a new person, company or other record. This endpoint will throw on conflicts of unique attributes. If you would prefer to update records on conflicts, please use the [Assert record endpoint](/reference/put_v2-objects-object-records) instead.
 *
 * Required scopes: `record_permission:read-write`, `object_configuration:read`.
 */
export const postV2ObjectsByObjectRecords = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ObjectsByObjectRecordsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ObjectsByObjectRecordsResponse,
    PostV2ObjectsByObjectRecordsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records',
  });
};

/**
 * Assert a record
 * Use this endpoint to create or update people, companies and other records. A matching attribute is used to search for existing records. If a record is found with the same value for the matching attribute, that record will be updated. If no record with the same value for the matching attribute is found, a new record will be created instead. If you would like to avoid matching, please use the [Create record endpoint](/reference/post_v2-objects-object-records).
 *
 * If the matching attribute is a multiselect attribute, new values will be added and existing values will not be deleted. For any other multiselect attribute, all values will be either created or deleted as necessary to match the list of supplied values.
 *
 * Required scopes: `record_permission:read-write`, `object_configuration:read`.
 */
export const putV2ObjectsByObjectRecords = <ThrowOnError extends boolean = false>(
  options: Options<PutV2ObjectsByObjectRecordsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2ObjectsByObjectRecordsResponse,
    PutV2ObjectsByObjectRecordsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records',
  });
};

/**
 * Get a record
 * Gets a single person, company or other record by its `record_id`.
 *
 * Required scopes: `record_permission:read`, `object_configuration:read`.
 */
export const getV2ObjectsByObjectRecordsByRecordId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ObjectsByObjectRecordsByRecordIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ObjectsByObjectRecordsByRecordIdResponse,
    GetV2ObjectsByObjectRecordsByRecordIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/{record_id}',
  });
};

/**
 * Update a record
 * Use this endpoint to update people, companies and other records by `record_id`. If the update payload includes multiselect attributes, the values supplied will be created and prepended to the list of values that already exist (if any). Use the [Assert record endpoint](/reference/put_v2-objects-object-records) to overwrite or remove multiselect attribute values.
 *
 * Required scopes: `record_permission:read-write`, `object_configuration:read`.
 */
export const patchV2ObjectsByObjectRecordsByRecordId = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ObjectsByObjectRecordsByRecordIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2ObjectsByObjectRecordsByRecordIdResponse,
    PatchV2ObjectsByObjectRecordsByRecordIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/{record_id}',
  });
};

/**
 * Delete a record
 * Deletes a single record (e.g. a company or person) by ID.
 *
 * Required scopes: `object_configuration:read`, `record_permission:read-write`.
 */
export const deleteV2ObjectsByObjectRecordsByRecordId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2ObjectsByObjectRecordsByRecordIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2ObjectsByObjectRecordsByRecordIdResponse,
    DeleteV2ObjectsByObjectRecordsByRecordIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/{record_id}',
  });
};

/**
 * List record attribute values
 * Gets all values for a given attribute on a record. If the attribute is historic, this endpoint has the ability to return all historic values using the `show_historic` query param.
 *
 * Required scopes: `record_permission:read`, `object_configuration:read`.
 */
export const getV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValues = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesResponse,
    GetV2ObjectsByObjectRecordsByRecordIdAttributesByAttributeValuesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/{record_id}/attributes/{attribute}/values',
  });
};

/**
 * List record entries
 * List all entries, across all lists, for which this record is the parent.
 *
 * Required scopes: `record_permission:read`, `object_configuration:read`, `list_entry:read`.
 */
export const getV2ObjectsByObjectRecordsByRecordIdEntries = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ObjectsByObjectRecordsByRecordIdEntriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ObjectsByObjectRecordsByRecordIdEntriesResponse,
    GetV2ObjectsByObjectRecordsByRecordIdEntriesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/objects/{object}/records/{record_id}/entries',
  });
};

/**
 * List all lists
 * List all lists that your access token has access to. lists are returned in the order that they are sorted in the sidebar.
 *
 * Required scopes: `list_configuration:read`.
 */
export const getV2Lists = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2ListsResponse, GetV2ListsError, ThrowOnError>({
    ...options,
    url: '/v2/lists',
  });
};

/**
 * Create a list
 * Creates a new list.
 *
 * Once you have your list, add attributes to it using the [Create attribute](/reference/post_v2-target-identifier-attributes) API, and add records to it using the [Add records to list](/reference/post_v2-lists-list-entries) API.
 *
 * New lists must specify which records can be added with the `parent_object` parameter which accepts either an object slug or an object ID. Permissions for the list are controlled with the `workspace_access` and `workspace_member_access` parameters.
 *
 * Please note that new lists must have either `workspace_access` set to `"full-access"` or one or more element of `workspace_member_access` with a `"full-access"` level. It is also possible to receive a `403` billing error if your workspace is not on a plan that supports either advanced workspace or workspace member-level access for lists.
 *
 * Required scopes: `list_configuration:read-write`.
 */
export const postV2Lists = <ThrowOnError extends boolean = false>(options: Options<PostV2ListsData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostV2ListsResponse, PostV2ListsError, ThrowOnError>({
    ...options,
    url: '/v2/lists',
  });
};

/**
 * Get a list
 * Gets a single list in your workspace that your access token has access to.
 *
 * Required scopes: `list_configuration:read`.
 */
export const getV2ListsByList = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ListsByListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ListsByListResponse, GetV2ListsByListError, ThrowOnError>({
    ...options,
    url: '/v2/lists/{list}',
  });
};

/**
 * Update a list
 * Updates an existing list. Permissions for the list are controlled with the `workspace_access` and `workspace_member_access` parameters. Please note that lists must have either `workspace_access` set to `"full-access"` or one or more element of `workspace_member_access` with a `"full-access"` level. It is also possible to receive a `403` billing error if your workspace is not on a plan that supports either advanced workspace or workspace member level access for lists. Changing the parent object of a list is not possible through the API as it can have unintended side-effects that should be considered carefully. If you wish to carry out a parent object change you should do so through the UI.
 *
 * Required scopes: `list_configuration:read-write`.
 */
export const patchV2ListsByList = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ListsByListData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchV2ListsByListResponse, PatchV2ListsByListError, ThrowOnError>({
    ...options,
    url: '/v2/lists/{list}',
  });
};

/**
 * List entries
 * Lists entries in a given list, with the option to filter and sort results.
 *
 * Required scopes: `list_entry:read`, `list_configuration:read`.
 */
export const postV2ListsByListEntriesQuery = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ListsByListEntriesQueryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ListsByListEntriesQueryResponse,
    PostV2ListsByListEntriesQueryError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/query',
  });
};

/**
 * Create an entry (add record to list)
 * Adds a record to a list as a new list entry. This endpoint will throw on conflicts of unique attributes. Multiple list entries are allowed for the same parent record
 *
 * Required scopes: `list_entry:read-write`, `list_configuration:read`.
 */
export const postV2ListsByListEntries = <ThrowOnError extends boolean = false>(
  options: Options<PostV2ListsByListEntriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV2ListsByListEntriesResponse,
    PostV2ListsByListEntriesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries',
  });
};

/**
 * Assert a list entry by parent
 * Use this endpoint to create or update a list entry for a given parent record. If an entry with the specified parent record is found, that entry will be updated. If no such entry is found, a new entry will be created instead. If there are multiple entries with the same parent record, this endpoint with return the "MULTIPLE_MATCH_RESULTS" error. When writing to multi-select attributes, all values will be either created or deleted as necessary to match the list of values supplied in the request body.
 *
 * Required scopes: `list_entry:read-write`, `list_configuration:read`.
 */
export const putV2ListsByListEntries = <ThrowOnError extends boolean = false>(
  options: Options<PutV2ListsByListEntriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV2ListsByListEntriesResponse, PutV2ListsByListEntriesError, ThrowOnError>({
    ...options,
    url: '/v2/lists/{list}/entries',
  });
};

/**
 * Get a list entry
 * Gets a single list entry by its `entry_id`.
 *
 * Required scopes: `list_entry:read`, `list_configuration:read`.
 */
export const getV2ListsByListEntriesByEntryId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ListsByListEntriesByEntryIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ListsByListEntriesByEntryIdResponse,
    GetV2ListsByListEntriesByEntryIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/{entry_id}',
  });
};

/**
 * Update a list entry (append multiselect values)
 * Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will be created and prepended to the list of values that already exist (if any). Use the `PUT` endpoint to overwrite or remove multiselect attribute values.
 *
 * Required scopes: `list_entry:read-write`, `list_configuration:read`.
 */
export const patchV2ListsByListEntriesByEntryId = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2ListsByListEntriesByEntryIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2ListsByListEntriesByEntryIdResponse,
    PatchV2ListsByListEntriesByEntryIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/{entry_id}',
  });
};

/**
 * Update a list entry (overwrite multiselect values)
 * Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will overwrite/remove the list of values that already exist (if any). Use the `PATCH` endpoint to add multiselect attribute values without removing those value that already exist.
 *
 * Required scopes: `list_entry:read-write`, `list_configuration:read`.
 */
export const putV2ListsByListEntriesByEntryId = <ThrowOnError extends boolean = false>(
  options: Options<PutV2ListsByListEntriesByEntryIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV2ListsByListEntriesByEntryIdResponse,
    PutV2ListsByListEntriesByEntryIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/{entry_id}',
  });
};

/**
 * Delete a list entry
 * Deletes a single list entry by its `entry_id`.
 *
 * Required scopes: `list_entry:read-write`, `list_configuration:read`.
 */
export const deleteV2ListsByListEntriesByEntryId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2ListsByListEntriesByEntryIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2ListsByListEntriesByEntryIdResponse,
    DeleteV2ListsByListEntriesByEntryIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/{entry_id}',
  });
};

/**
 * List attribute values for a list entry
 * Gets all values for a given attribute on a list entry. If the attribute is historic, this endpoint has the ability to return all historic values using the `show_historic` query param.
 *
 * Required scopes: `list_entry:read`, `list_configuration:read`.
 */
export const getV2ListsByListEntriesByEntryIdAttributesByAttributeValues = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesResponse,
    GetV2ListsByListEntriesByEntryIdAttributesByAttributeValuesError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/lists/{list}/entries/{entry_id}/attributes/{attribute}/values',
  });
};

/**
 * List workspace members
 * Lists all workspace members in the workspace.
 *
 * Required scopes: `user_management:read`.
 */
export const getV2WorkspaceMembers = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2WorkspaceMembersResponse, GetV2WorkspaceMembersError, ThrowOnError>({
    ...options,
    url: '/v2/workspace_members',
  });
};

/**
 * Get a workspace member
 * Gets a single workspace member by ID.
 *
 * Required scopes: `user_management:read`.
 */
export const getV2WorkspaceMembersByWorkspaceMemberId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2WorkspaceMembersByWorkspaceMemberIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV2WorkspaceMembersByWorkspaceMemberIdResponse,
    GetV2WorkspaceMembersByWorkspaceMemberIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/workspace_members/{workspace_member_id}',
  });
};

/**
 * List notes
 * List notes for all records or for a specific record.
 *
 * Required scopes: `note:read`, `object_configuration:read`, `record_permission:read`.
 */
export const getV2Notes = <ThrowOnError extends boolean = false>(options?: Options<GetV2NotesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2NotesResponse, GetV2NotesError, ThrowOnError>({
    ...options,
    url: '/v2/notes',
  });
};

/**
 * Create a note
 * Creates a new note for a given record.
 *
 * At present, notes can only be created from plaintext without formatting.
 *
 * Required scopes: `note:read-write`, `object_configuration:read`, `record_permission:read`.
 */
export const postV2Notes = <ThrowOnError extends boolean = false>(options: Options<PostV2NotesData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostV2NotesResponse, PostV2NotesError, ThrowOnError>({
    ...options,
    url: '/v2/notes',
  });
};

/**
 * Get a note
 * Get a single note by ID.
 *
 * Required scopes: `note:read`, `object_configuration:read`, `record_permission:read`.
 */
export const getV2NotesByNoteId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2NotesByNoteIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2NotesByNoteIdResponse, GetV2NotesByNoteIdError, ThrowOnError>({
    ...options,
    url: '/v2/notes/{note_id}',
  });
};

/**
 * Delete a note
 * Delete a single note by ID.
 *
 * Required scopes: `note:read-write`.
 */
export const deleteV2NotesByNoteId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2NotesByNoteIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV2NotesByNoteIdResponse, DeleteV2NotesByNoteIdError, ThrowOnError>({
    ...options,
    url: '/v2/notes/{note_id}',
  });
};

/**
 * List tasks
 * List all tasks. Results are sorted by creation date, from oldest to newest.
 *
 * Required scopes: `task:read`, `object_configuration:read`, `record_permission:read`, `user_management:read`.
 */
export const getV2Tasks = <ThrowOnError extends boolean = false>(options?: Options<GetV2TasksData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2TasksResponse, GetV2TasksError, ThrowOnError>({
    ...options,
    url: '/v2/tasks',
  });
};

/**
 * Create a task
 * Creates a new task.
 *
 * At present, tasks can only be created from plaintext without record reference formatting.
 *
 * Required scopes: `task:read-write`, `object_configuration:read`, `record_permission:read`, `user_management:read`.
 */
export const postV2Tasks = <ThrowOnError extends boolean = false>(options: Options<PostV2TasksData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostV2TasksResponse, PostV2TasksError, ThrowOnError>({
    ...options,
    url: '/v2/tasks',
  });
};

/**
 * Get a task
 * Get a single task by ID.
 *
 * Required scopes: `task:read`, `object_configuration:read`, `record_permission:read`, `user_management:read`.
 */
export const getV2TasksByTaskId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2TasksByTaskIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2TasksByTaskIdResponse, GetV2TasksByTaskIdError, ThrowOnError>({
    ...options,
    url: '/v2/tasks/{task_id}',
  });
};

/**
 * Update a task
 * Updates an existing task by `task_id`. At present, only the `deadline_at`, `is_completed`, `linked_records`, and `assignees` fields can be updated.
 *
 * Required scopes: `task:read-write`, `object_configuration:read`, `record_permission:read`, `user_management:read`.
 */
export const patchV2TasksByTaskId = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2TasksByTaskIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchV2TasksByTaskIdResponse, PatchV2TasksByTaskIdError, ThrowOnError>({
    ...options,
    url: '/v2/tasks/{task_id}',
  });
};

/**
 * Delete a task
 * Delete a task by ID.
 *
 * Required scopes: `task:read-write`.
 */
export const deleteV2TasksByTaskId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2TasksByTaskIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV2TasksByTaskIdResponse, DeleteV2TasksByTaskIdError, ThrowOnError>({
    ...options,
    url: '/v2/tasks/{task_id}',
  });
};

/**
 * List threads
 * List threads of comments on a record or list entry.
 *
 * To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.
 *
 * To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.
 *
 * Required scopes: `comment:read`.
 */
export const getV2Threads = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2ThreadsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ThreadsResponse, GetV2ThreadsError, ThrowOnError>({
    ...options,
    url: '/v2/threads',
  });
};

/**
 * Get a thread
 * Get all comments in a thread.
 *
 * To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.
 *
 * To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.
 *
 * Required scopes: `comment:read`.
 */
export const getV2ThreadsByThreadId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2ThreadsByThreadIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2ThreadsByThreadIdResponse, GetV2ThreadsByThreadIdError, ThrowOnError>({
    ...options,
    url: '/v2/threads/{thread_id}',
  });
};

/**
 * Create a comment
 * Creates a new comment related to an existing thread, record or entry.
 *
 * To create comments on records, you will need the `object_configuration:read` and `record_permission:read` scopes.
 *
 * To create comments on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.
 *
 * Required scopes: `comment:read-write`.
 */
export const postV2Comments = <ThrowOnError extends boolean = false>(
  options: Options<PostV2CommentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2CommentsResponse, PostV2CommentsError, ThrowOnError>({
    ...options,
    url: '/v2/comments',
  });
};

/**
 * Get a comment
 * Get a single comment by ID.
 *
 * To view comments on records, you will need the `object_configuration:read` and `record_permission:read` scopes.
 *
 * To view comments on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.
 *
 * Required scopes: `comment:read`.
 */
export const getV2CommentsByCommentId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2CommentsByCommentIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2CommentsByCommentIdResponse, GetV2CommentsByCommentIdError, ThrowOnError>(
    {
      ...options,
      url: '/v2/comments/{comment_id}',
    },
  );
};

/**
 * Delete a comment
 * Deletes a comment by ID. If deleting a comment at the head of a thread, all messages in the thread are also deleted.
 *
 * Required scopes: `comment:read-write`.
 */
export const deleteV2CommentsByCommentId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2CommentsByCommentIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2CommentsByCommentIdResponse,
    DeleteV2CommentsByCommentIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/comments/{comment_id}',
  });
};

/**
 * List webhooks
 * Get all of the webhooks in your workspace.
 *
 * Required scopes: `webhook:read`.
 */
export const getV2Webhooks = <ThrowOnError extends boolean = false>(
  options?: Options<GetV2WebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2WebhooksResponse, GetV2WebhooksError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks',
  });
};

/**
 * Create a webhook
 * Create a webhook and associated subscriptions.
 *
 * Required scopes: `webhook:read-write`.
 */
export const postV2Webhooks = <ThrowOnError extends boolean = false>(
  options: Options<PostV2WebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV2WebhooksResponse, PostV2WebhooksError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks',
  });
};

/**
 * Get a webhook
 * Get a single webhook.
 *
 * Required scopes: `webhook:read`.
 */
export const getV2WebhooksByWebhookId = <ThrowOnError extends boolean = false>(
  options: Options<GetV2WebhooksByWebhookIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV2WebhooksByWebhookIdResponse, GetV2WebhooksByWebhookIdError, ThrowOnError>(
    {
      ...options,
      url: '/v2/webhooks/{webhook_id}',
    },
  );
};

/**
 * Update a webhook
 * Update a webhook and associated subscriptions.
 *
 * Required scopes: `webhook:read-write`.
 */
export const patchV2WebhooksByWebhookId = <ThrowOnError extends boolean = false>(
  options: Options<PatchV2WebhooksByWebhookIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchV2WebhooksByWebhookIdResponse,
    PatchV2WebhooksByWebhookIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/webhooks/{webhook_id}',
  });
};

/**
 * Delete a webhook
 * Delete a webhook by ID.
 *
 * Required scopes: `webhook:read-write`.
 */
export const deleteV2WebhooksByWebhookId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV2WebhooksByWebhookIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV2WebhooksByWebhookIdResponse,
    DeleteV2WebhooksByWebhookIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/webhooks/{webhook_id}',
  });
};

/**
 * Identify
 * Identify the current access token, the workspace it is linked to, and any permissions it has.
 */
export const getV2Self = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV2SelfResponse, GetV2SelfError, ThrowOnError>({
    ...options,
    url: '/v2/self',
  });
};
