// Generated by ts-to-zod
import { z } from 'zod';

export const addCustomFieldSettingRequestSchema = z.object({
  custom_field: z.string(),
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  is_important: z.boolean().optional(),
});

export const addFollowersRequestSchema = z.object({
  followers: z.string(),
});

export const addMembersRequestSchema = z.object({
  members: z.string(),
});

export const asanaResourceSchema = z.object({
  gid: z.string().optional(),
  resource_type: z.string().optional(),
});

export const attachmentCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
    resource_subtype: z.string().optional(),
  }),
);

export const resourceSubtypeSchema = z.union([
  z.literal('asana'),
  z.literal('dropbox'),
  z.literal('gdrive'),
  z.literal('onedrive'),
  z.literal('box'),
  z.literal('vimeo'),
  z.literal('external'),
]);

export const taskCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
    resource_subtype: z
      .union([z.literal('default_task'), z.literal('milestone'), z.literal('section'), z.literal('approval')])
      .optional(),
  }),
);

export const auditLogEventActorSchema = z.object({
  actor_type: z
    .union([
      z.literal('user'),
      z.literal('asana'),
      z.literal('asana_support'),
      z.literal('anonymous'),
      z.literal('external_administrator'),
    ])
    .optional(),
  email: z.string().optional(),
  gid: z.string().optional(),
  name: z.string().optional(),
});

export const auditLogEventContextSchema = z.object({
  api_authentication_method: z
    .union([z.literal('cookie'), z.literal('oauth'), z.literal('personal_access_token'), z.literal('service_account')])
    .optional(),
  client_ip_address: z.string().optional(),
  context_type: z
    .union([
      z.literal('web'),
      z.literal('desktop'),
      z.literal('mobile'),
      z.literal('asana_support'),
      z.literal('asana'),
      z.literal('email'),
      z.literal('api'),
    ])
    .optional(),
  oauth_app_name: z.string().optional(),
  user_agent: z.string().optional(),
});

export const auditLogEventDetailsSchema = z.record(z.unknown());

export const auditLogEventResourceSchema = z.object({
  email: z.string().optional(),
  gid: z.string().optional(),
  name: z.string().optional(),
  resource_subtype: z.string().optional(),
  resource_type: z.string().optional(),
});

export const actorTypeSchema = z.union([
  z.literal('user'),
  z.literal('asana'),
  z.literal('asana_support'),
  z.literal('anonymous'),
  z.literal('external_administrator'),
]);

export const apiAuthenticationMethodSchema = z.union([
  z.literal('cookie'),
  z.literal('oauth'),
  z.literal('personal_access_token'),
  z.literal('service_account'),
]);

export const contextTypeSchema = z.union([
  z.literal('web'),
  z.literal('desktop'),
  z.literal('mobile'),
  z.literal('asana_support'),
  z.literal('asana'),
  z.literal('email'),
  z.literal('api'),
]);

export const batchRequestActionSchema = z.object({
  data: z.record(z.unknown()).optional(),
  method: z.union([
    z.literal('get'),
    z.literal('post'),
    z.literal('put'),
    z.literal('delete'),
    z.literal('patch'),
    z.literal('head'),
  ]),
  options: z
    .object({
      fields: z.array(z.string()).optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
  relative_path: z.string(),
});

export const methodSchema = z.union([
  z.literal('get'),
  z.literal('post'),
  z.literal('put'),
  z.literal('delete'),
  z.literal('patch'),
  z.literal('head'),
]);

export const batchResponseSchema = z.object({
  body: z.record(z.unknown()).optional(),
  headers: z.record(z.unknown()).optional(),
  status_code: z.number().optional(),
});

export const enumOptionSchema = asanaResourceSchema.and(
  z.object({
    color: z.string().optional(),
    enabled: z.boolean().optional(),
    name: z.string().optional(),
  }),
);

export const asanaCreatedFieldSchema = z.union([
  z.literal('a_v_requirements'),
  z.literal('account_name'),
  z.literal('actionable'),
  z.literal('align_shipping_link'),
  z.literal('align_status'),
  z.literal('allotted_time'),
  z.literal('appointment'),
  z.literal('approval_stage'),
  z.literal('approved'),
  z.literal('article_series'),
  z.literal('board_committee'),
  z.literal('browser'),
  z.literal('campaign_audience'),
  z.literal('campaign_project_status'),
  z.literal('campaign_regions'),
  z.literal('channel_primary'),
  z.literal('client_topic_type'),
  z.literal('complete_by'),
  z.literal('contact'),
  z.literal('contact_email_address'),
  z.literal('content_channels'),
  z.literal('content_channels_needed'),
  z.literal('content_stage'),
  z.literal('content_type'),
  z.literal('contract'),
  z.literal('contract_status'),
  z.literal('cost'),
  z.literal('creation_stage'),
  z.literal('creative_channel'),
  z.literal('creative_needed'),
  z.literal('creative_needs'),
  z.literal('data_sensitivity'),
  z.literal('deal_size'),
  z.literal('delivery_appt'),
  z.literal('delivery_appt_date'),
  z.literal('department'),
  z.literal('department_responsible'),
  z.literal('design_request_needed'),
  z.literal('design_request_type'),
  z.literal('discussion_category'),
  z.literal('do_this_task'),
  z.literal('editorial_content_status'),
  z.literal('editorial_content_tag'),
  z.literal('editorial_content_type'),
  z.literal('effort'),
  z.literal('effort_level'),
  z.literal('est_completion_date'),
  z.literal('estimated_time'),
  z.literal('estimated_value'),
  z.literal('expected_cost'),
  z.literal('external_steps_needed'),
  z.literal('favorite_idea'),
  z.literal('feedback_type'),
  z.literal('financial'),
  z.literal('funding_amount'),
  z.literal('grant_application_process'),
  z.literal('hiring_candidate_status'),
  z.literal('idea_status'),
  z.literal('ids_link'),
  z.literal('ids_patient_link'),
  z.literal('implementation_stage'),
  z.literal('insurance'),
  z.literal('interview_area'),
  z.literal('interview_question_score'),
  z.literal('itero_scan_link'),
  z.literal('job_s_applied_to'),
  z.literal('lab'),
  z.literal('launch_status'),
  z.literal('lead_status'),
  z.literal('localization_language'),
  z.literal('localization_market_team'),
  z.literal('localization_status'),
  z.literal('meeting_minutes'),
  z.literal('meeting_needed'),
  z.literal('minutes'),
  z.literal('mrr'),
  z.literal('must_localize'),
  z.literal('name_of_foundation'),
  z.literal('need_to_follow_up'),
  z.literal('next_appointment'),
  z.literal('next_steps_sales'),
  z.literal('num_people'),
  z.literal('number_of_user_reports'),
  z.literal('office_location'),
  z.literal('onboarding_activity'),
  z.literal('owner'),
  z.literal('participants_needed'),
  z.literal('patient_date_of_birth'),
  z.literal('patient_email'),
  z.literal('patient_phone'),
  z.literal('patient_status'),
  z.literal('phone_number'),
  z.literal('planning_category'),
  z.literal('point_of_contact'),
  z.literal('position'),
  z.literal('post_format'),
  z.literal('prescription'),
  z.literal('priority'),
  z.literal('priority_level'),
  z.literal('product'),
  z.literal('product_stage'),
  z.literal('progress'),
  z.literal('project_size'),
  z.literal('project_status'),
  z.literal('proposed_budget'),
  z.literal('publish_status'),
  z.literal('reason_for_scan'),
  z.literal('referral'),
  z.literal('request_type'),
  z.literal('research_status'),
  z.literal('responsible_department'),
  z.literal('responsible_team'),
  z.literal('risk_assessment_status'),
  z.literal('room_name'),
  z.literal('sales_counterpart'),
  z.literal('sentiment'),
  z.literal('shipping_link'),
  z.literal('social_channels'),
  z.literal('stage'),
  z.literal('status'),
  z.literal('status_design'),
  z.literal('status_of_initiative'),
  z.literal('system_setup'),
  z.literal('task_progress'),
  z.literal('team'),
  z.literal('team_marketing'),
  z.literal('team_responsible'),
  z.literal('time_it_takes_to_complete_tasks'),
  z.literal('timeframe'),
  z.literal('treatment_type'),
  z.literal('type_work_requests_it'),
  z.literal('use_agency'),
  z.literal('user_name'),
  z.literal('vendor_category'),
  z.literal('vendor_type'),
  z.literal('word_count'),
]);

export const customLabelPositionSchema = z.union([z.literal('prefix'), z.literal('suffix')]);

export const formatSchema = z.union([
  z.literal('currency'),
  z.literal('identifier'),
  z.literal('percentage'),
  z.literal('custom'),
  z.literal('none'),
]);

export const customFieldCompactSchema = asanaResourceSchema.and(
  z.object({
    date_value: z
      .object({
        date: z.string().optional(),
        date_time: z.string().optional(),
      })
      .optional(),
    display_value: z.string().optional().nullable(),
    enabled: z.boolean().optional(),
    enum_options: z.array(enumOptionSchema).optional(),
    enum_value: enumOptionSchema.and(z.record(z.unknown())).optional(),
    multi_enum_values: z.array(enumOptionSchema).optional(),
    name: z.string().optional(),
    number_value: z.number().optional(),
    resource_subtype: z
      .union([
        z.literal('text'),
        z.literal('enum'),
        z.literal('multi_enum'),
        z.literal('number'),
        z.literal('date'),
        z.literal('people'),
      ])
      .optional(),
    text_value: z.string().optional(),
    type: z.union([z.literal('text'), z.literal('enum'), z.literal('multi_enum'), z.literal('number')]).optional(),
  }),
);

export const resourceSubtype2Schema = z.union([
  z.literal('text'),
  z.literal('enum'),
  z.literal('multi_enum'),
  z.literal('number'),
  z.literal('date'),
  z.literal('people'),
]);

export const typeSchema = z.union([z.literal('text'), z.literal('enum'), z.literal('multi_enum'), z.literal('number')]);

export const customFieldBaseSchema = customFieldCompactSchema.and(
  z.object({
    asana_created_field: z
      .union([
        z.literal('a_v_requirements'),
        z.literal('account_name'),
        z.literal('actionable'),
        z.literal('align_shipping_link'),
        z.literal('align_status'),
        z.literal('allotted_time'),
        z.literal('appointment'),
        z.literal('approval_stage'),
        z.literal('approved'),
        z.literal('article_series'),
        z.literal('board_committee'),
        z.literal('browser'),
        z.literal('campaign_audience'),
        z.literal('campaign_project_status'),
        z.literal('campaign_regions'),
        z.literal('channel_primary'),
        z.literal('client_topic_type'),
        z.literal('complete_by'),
        z.literal('contact'),
        z.literal('contact_email_address'),
        z.literal('content_channels'),
        z.literal('content_channels_needed'),
        z.literal('content_stage'),
        z.literal('content_type'),
        z.literal('contract'),
        z.literal('contract_status'),
        z.literal('cost'),
        z.literal('creation_stage'),
        z.literal('creative_channel'),
        z.literal('creative_needed'),
        z.literal('creative_needs'),
        z.literal('data_sensitivity'),
        z.literal('deal_size'),
        z.literal('delivery_appt'),
        z.literal('delivery_appt_date'),
        z.literal('department'),
        z.literal('department_responsible'),
        z.literal('design_request_needed'),
        z.literal('design_request_type'),
        z.literal('discussion_category'),
        z.literal('do_this_task'),
        z.literal('editorial_content_status'),
        z.literal('editorial_content_tag'),
        z.literal('editorial_content_type'),
        z.literal('effort'),
        z.literal('effort_level'),
        z.literal('est_completion_date'),
        z.literal('estimated_time'),
        z.literal('estimated_value'),
        z.literal('expected_cost'),
        z.literal('external_steps_needed'),
        z.literal('favorite_idea'),
        z.literal('feedback_type'),
        z.literal('financial'),
        z.literal('funding_amount'),
        z.literal('grant_application_process'),
        z.literal('hiring_candidate_status'),
        z.literal('idea_status'),
        z.literal('ids_link'),
        z.literal('ids_patient_link'),
        z.literal('implementation_stage'),
        z.literal('insurance'),
        z.literal('interview_area'),
        z.literal('interview_question_score'),
        z.literal('itero_scan_link'),
        z.literal('job_s_applied_to'),
        z.literal('lab'),
        z.literal('launch_status'),
        z.literal('lead_status'),
        z.literal('localization_language'),
        z.literal('localization_market_team'),
        z.literal('localization_status'),
        z.literal('meeting_minutes'),
        z.literal('meeting_needed'),
        z.literal('minutes'),
        z.literal('mrr'),
        z.literal('must_localize'),
        z.literal('name_of_foundation'),
        z.literal('need_to_follow_up'),
        z.literal('next_appointment'),
        z.literal('next_steps_sales'),
        z.literal('num_people'),
        z.literal('number_of_user_reports'),
        z.literal('office_location'),
        z.literal('onboarding_activity'),
        z.literal('owner'),
        z.literal('participants_needed'),
        z.literal('patient_date_of_birth'),
        z.literal('patient_email'),
        z.literal('patient_phone'),
        z.literal('patient_status'),
        z.literal('phone_number'),
        z.literal('planning_category'),
        z.literal('point_of_contact'),
        z.literal('position'),
        z.literal('post_format'),
        z.literal('prescription'),
        z.literal('priority'),
        z.literal('priority_level'),
        z.literal('product'),
        z.literal('product_stage'),
        z.literal('progress'),
        z.literal('project_size'),
        z.literal('project_status'),
        z.literal('proposed_budget'),
        z.literal('publish_status'),
        z.literal('reason_for_scan'),
        z.literal('referral'),
        z.literal('request_type'),
        z.literal('research_status'),
        z.literal('responsible_department'),
        z.literal('responsible_team'),
        z.literal('risk_assessment_status'),
        z.literal('room_name'),
        z.literal('sales_counterpart'),
        z.literal('sentiment'),
        z.literal('shipping_link'),
        z.literal('social_channels'),
        z.literal('stage'),
        z.literal('status'),
        z.literal('status_design'),
        z.literal('status_of_initiative'),
        z.literal('system_setup'),
        z.literal('task_progress'),
        z.literal('team'),
        z.literal('team_marketing'),
        z.literal('team_responsible'),
        z.literal('time_it_takes_to_complete_tasks'),
        z.literal('timeframe'),
        z.literal('treatment_type'),
        z.literal('type_work_requests_it'),
        z.literal('use_agency'),
        z.literal('user_name'),
        z.literal('vendor_category'),
        z.literal('vendor_type'),
        z.literal('word_count'),
      ])
      .optional()
      .nullable(),
    currency_code: z.string().optional().nullable(),
    custom_label: z.string().optional().nullable(),
    custom_label_position: z.union([z.literal('prefix'), z.literal('suffix')]).optional(),
    description: z.string().optional(),
    enum_options: z.array(enumOptionSchema).optional(),
    format: z
      .union([
        z.literal('currency'),
        z.literal('identifier'),
        z.literal('percentage'),
        z.literal('custom'),
        z.literal('none'),
      ])
      .optional(),
    has_notifications_enabled: z.boolean().optional(),
    is_global_to_workspace: z.boolean().optional(),
    precision: z.number().optional(),
  }),
);

export const userCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const customFieldSettingCompactSchema = asanaResourceSchema.and(z.record(z.unknown()));

export const customFieldResponseSchema = customFieldBaseSchema.and(
  z.object({
    created_by: userCompactSchema.optional().nullable(),
    people_value: z.array(userCompactSchema).optional(),
  }),
);

export const projectCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const dateVariableCompactSchema = z.object({
  description: z.string().optional(),
  gid: z.string().optional(),
  name: z.string().optional(),
});

export const dateVariableRequestSchema = z.object({
  gid: z.string().optional(),
  value: z.string().optional().nullable(),
});

export const emptyResponseSchema = z.record(z.unknown());

export const enumOptionBaseSchema = enumOptionSchema;

export const enumOptionInsertRequestSchema = z.object({
  after_enum_option: z.string().optional(),
  before_enum_option: z.string().optional(),
  enum_option: z.string(),
});

export const enumOptionRequestSchema = enumOptionSchema.and(
  z.object({
    insert_after: z.string().optional(),
    insert_before: z.string().optional(),
  }),
);

export const errorSchema = z.object({
  help: z.string().optional(),
  message: z.string().optional(),
  phrase: z.string().optional(),
});

export const errorResponseSchema = z.object({
  errors: z.array(errorSchema).optional(),
});

export const asanaNamedResourceSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const goalAddSubgoalRequestSchema = z.object({
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  subgoal: z.string(),
});

export const goalAddSupportingRelationshipRequestSchema = z.object({
  contribution_weight: z.number().optional(),
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  supporting_resource: z.string(),
});

export const goalAddSupportingWorkRequestSchema = z.object({
  supporting_work: z.string(),
});

export const goalBaseSchema = asanaResourceSchema.and(
  z.object({
    due_on: z.string().optional().nullable(),
    html_notes: z.string().optional(),
    is_workspace_level: z.boolean().optional(),
    liked: z.boolean().optional(),
    name: z.string().optional(),
    notes: z.string().optional(),
    start_on: z.string().optional().nullable(),
    status: z.string().optional().nullable(),
  }),
);

export const goalCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
    owner: userCompactSchema.and(z.record(z.unknown())).optional().nullable(),
  }),
);

export const goalMembershipCompactSchema = asanaResourceSchema.and(
  z.object({
    is_commenter: z.boolean().optional(),
    is_editor: z.boolean().optional(),
    member: userCompactSchema.optional(),
  }),
);

export const goalMembershipResponseSchema = goalMembershipCompactSchema;

export const goalMetricBaseSchema = asanaResourceSchema.and(
  z.object({
    currency_code: z.string().optional().nullable(),
    current_display_value: z.string().optional(),
    current_number_value: z.number().optional(),
    initial_number_value: z.number().optional(),
    precision: z.number().optional(),
    progress_source: z
      .union([
        z.literal('manual'),
        z.literal('subgoal_progress'),
        z.literal('project_task_completion'),
        z.literal('project_milestone_completion'),
        z.literal('external'),
      ])
      .optional(),
    resource_subtype: z.literal('number').optional(),
    target_number_value: z.number().optional(),
    unit: z.union([z.literal('none'), z.literal('currency'), z.literal('percentage')]).optional(),
  }),
);

export const progressSourceSchema = z.union([
  z.literal('manual'),
  z.literal('subgoal_progress'),
  z.literal('project_task_completion'),
  z.literal('project_milestone_completion'),
  z.literal('external'),
]);

export const resourceSubtype3Schema = z.literal('number');

export const unitSchema = z.union([z.literal('none'), z.literal('currency'), z.literal('percentage')]);

export const goalMetricCurrentValueRequestSchema = asanaResourceSchema.and(
  z.object({
    current_number_value: z.number().optional(),
  }),
);

export const goalMetricRequestSchema = goalMetricBaseSchema;

export const goalRelationshipCompactSchema = asanaResourceSchema.and(
  z.object({
    contribution_weight: z.number().optional(),
    resource_subtype: z.union([z.literal('subgoal'), z.literal('supporting_work')]).optional(),
    supporting_resource: projectCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const resourceSubtype4Schema = z.union([z.literal('subgoal'), z.literal('supporting_work')]);

export const goalRelationshipBaseSchema = goalRelationshipCompactSchema.and(
  z.object({
    supported_goal: goalCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const goalRelationshipResponseSchema = goalRelationshipBaseSchema.and(z.record(z.unknown()));

export const goalRemoveSubgoalRequestSchema = z.object({
  subgoal: z.string(),
});

export const goalRemoveSupportingRelationshipRequestSchema = z.object({
  supporting_resource: z.string(),
});

export const goalRequestSchema = goalBaseSchema.and(
  z.object({
    followers: z.array(z.string()).optional(),
    owner: z.string().optional().nullable(),
    team: z.string().optional().nullable(),
    time_period: z.string().optional().nullable(),
    workspace: z.string().optional(),
  }),
);

export const statusUpdateCompactSchema = asanaResourceSchema.and(
  z.object({
    resource_subtype: z
      .union([
        z.literal('project_status_update'),
        z.literal('portfolio_status_update'),
        z.literal('goal_status_update'),
      ])
      .optional(),
    title: z.string().optional(),
  }),
);

export const likeSchema = z.object({
  gid: z.string().optional(),
  user: userCompactSchema.optional(),
});

export const teamCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const timePeriodCompactSchema = asanaResourceSchema.and(
  z.object({
    display_name: z.string().optional(),
    end_on: z.string().optional(),
    period: z
      .union([
        z.literal('FY'),
        z.literal('H1'),
        z.literal('H2'),
        z.literal('Q1'),
        z.literal('Q2'),
        z.literal('Q3'),
        z.literal('Q4'),
      ])
      .optional(),
    start_on: z.string().optional(),
  }),
);

export const workspaceCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const projectTemplateCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const statusSchema = z.union([
  z.literal('not_started'),
  z.literal('in_progress'),
  z.literal('succeeded'),
  z.literal('failed'),
]);

export const jobCompactSchema = asanaResourceSchema.and(
  z.object({
    new_project: projectCompactSchema.optional(),
    new_project_template: projectTemplateCompactSchema.optional(),
    new_task: taskCompactSchema.optional(),
    resource_subtype: z.string().optional(),
    status: z
      .union([z.literal('not_started'), z.literal('in_progress'), z.literal('succeeded'), z.literal('failed')])
      .optional(),
  }),
);

export const modifyDependenciesRequestSchema = z.object({
  dependencies: z.array(z.string()).optional(),
});

export const modifyDependentsRequestSchema = z.object({
  dependents: z.array(z.string()).optional(),
});

export const organizationExportCompactSchema = asanaResourceSchema.and(
  z.object({
    created_at: z.string().optional(),
    download_url: z.string().optional().nullable(),
    organization: workspaceCompactSchema.optional(),
    state: z.union([z.literal('pending'), z.literal('started'), z.literal('finished'), z.literal('error')]).optional(),
  }),
);

export const stateSchema = z.union([
  z.literal('pending'),
  z.literal('started'),
  z.literal('finished'),
  z.literal('error'),
]);

export const organizationExportRequestSchema = z.object({
  organization: z.string().optional(),
});

export const organizationExportResponseSchema = organizationExportCompactSchema;

export const portfolioAddItemRequestSchema = z.object({
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  item: z.string(),
});

export const portfolioCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const colorSchema = z.union([
  z.literal('dark-pink'),
  z.literal('dark-green'),
  z.literal('dark-blue'),
  z.literal('dark-red'),
  z.literal('dark-teal'),
  z.literal('dark-brown'),
  z.literal('dark-orange'),
  z.literal('dark-purple'),
  z.literal('dark-warm-gray'),
  z.literal('light-pink'),
  z.literal('light-green'),
  z.literal('light-blue'),
  z.literal('light-red'),
  z.literal('light-teal'),
  z.literal('light-brown'),
  z.literal('light-orange'),
  z.literal('light-purple'),
  z.literal('light-warm-gray'),
]);

export const portfolioMembershipCompactSchema = asanaResourceSchema.and(
  z.object({
    portfolio: portfolioCompactSchema.optional(),
    user: userCompactSchema.optional(),
  }),
);

export const portfolioMembershipResponseSchema = portfolioMembershipCompactSchema;

export const portfolioRemoveItemRequestSchema = z.object({
  item: z.string(),
});

export const portfolioBaseSchema = portfolioCompactSchema.and(
  z.object({
    color: z
      .union([
        z.literal('dark-pink'),
        z.literal('dark-green'),
        z.literal('dark-blue'),
        z.literal('dark-red'),
        z.literal('dark-teal'),
        z.literal('dark-brown'),
        z.literal('dark-orange'),
        z.literal('dark-purple'),
        z.literal('dark-warm-gray'),
        z.literal('light-pink'),
        z.literal('light-green'),
        z.literal('light-blue'),
        z.literal('light-red'),
        z.literal('light-teal'),
        z.literal('light-brown'),
        z.literal('light-orange'),
        z.literal('light-purple'),
        z.literal('light-warm-gray'),
      ])
      .optional(),
  }),
);

export const customFieldSettingResponseSchema = customFieldSettingCompactSchema.and(
  z.object({
    custom_field: customFieldResponseSchema.and(z.record(z.unknown())).optional(),
    is_important: z.boolean().optional(),
    parent: projectCompactSchema.and(z.record(z.unknown())).optional(),
    project: projectCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const previewSchema = z.object({
  fallback: z.string().optional(),
  footer: z.string().optional(),
  header: z.string().optional(),
  header_link: z.string().optional(),
  html_text: z.string().optional(),
  text: z.string().optional(),
  title: z.string().optional(),
  title_link: z.string().optional(),
});

export const defaultViewSchema = z.union([
  z.literal('list'),
  z.literal('board'),
  z.literal('calendar'),
  z.literal('timeline'),
]);

export const projectBriefCompactSchema = asanaResourceSchema.and(z.record(z.unknown()));

export const projectBriefBaseSchema = projectBriefCompactSchema.and(
  z.object({
    html_text: z.string().optional(),
    title: z.string().optional(),
  }),
);

export const projectBriefResponseSchema = projectBriefBaseSchema.and(
  z.object({
    permalink_url: z.string().optional(),
    project: projectCompactSchema.and(z.record(z.unknown())).optional(),
    text: z.string().optional(),
  }),
);

export const projectDuplicateRequestSchema = z.object({
  include: z
    .union([
      z.literal('members'),
      z.literal('notes'),
      z.literal('forms'),
      z.literal('task_notes'),
      z.literal('task_assignee'),
      z.literal('task_subtasks'),
      z.literal('task_attachments'),
      z.literal('task_dates'),
      z.literal('task_dependencies'),
      z.literal('task_followers'),
      z.literal('task_tags'),
      z.literal('task_projects'),
    ])
    .optional(),
  name: z.string(),
  schedule_dates: z
    .object({
      due_on: z.string().optional(),
      should_skip_weekends: z.boolean(),
      start_on: z.string().optional(),
    })
    .optional(),
  team: z.string().optional(),
});

export const includeSchema = z.union([
  z.literal('members'),
  z.literal('notes'),
  z.literal('forms'),
  z.literal('task_notes'),
  z.literal('task_assignee'),
  z.literal('task_subtasks'),
  z.literal('task_attachments'),
  z.literal('task_dates'),
  z.literal('task_dependencies'),
  z.literal('task_followers'),
  z.literal('task_tags'),
  z.literal('task_projects'),
]);

export const projectMembershipCompactSchema = asanaResourceSchema.and(
  z.object({
    user: userCompactSchema.optional(),
  }),
);

export const projectMembershipResponseSchema = projectMembershipCompactSchema.and(
  z.object({
    project: projectCompactSchema.optional(),
    write_access: z.union([z.literal('full_write'), z.literal('comment_only')]).optional(),
  }),
);

export const writeAccessSchema = z.union([z.literal('full_write'), z.literal('comment_only')]);

export const iconSchema = z.union([
  z.literal('list'),
  z.literal('board'),
  z.literal('timeline'),
  z.literal('calendar'),
  z.literal('rocket'),
  z.literal('people'),
  z.literal('graph'),
  z.literal('star'),
  z.literal('bug'),
  z.literal('light_bulb'),
  z.literal('globe'),
  z.literal('gear'),
  z.literal('notebook'),
  z.literal('computer'),
  z.literal('check'),
  z.literal('target'),
  z.literal('html'),
  z.literal('megaphone'),
  z.literal('chat_bubbles'),
  z.literal('briefcase'),
  z.literal('page_layout'),
  z.literal('mountain_flag'),
  z.literal('puzzle'),
  z.literal('presentation'),
  z.literal('line_and_symbols'),
  z.literal('speed_dial'),
  z.literal('ribbon'),
  z.literal('shoe'),
  z.literal('shopping_basket'),
  z.literal('map'),
  z.literal('ticket'),
  z.literal('coins'),
]);

export const projectSaveAsTemplateRequestSchema = z.object({
  name: z.string(),
  public: z.boolean(),
  team: z.string().optional(),
  workspace: z.string().optional(),
});

export const projectSectionInsertRequestSchema = z.object({
  after_section: z.string().optional(),
  before_section: z.string().optional(),
  project: z.string(),
  section: z.string(),
});

export const projectStatusCompactSchema = asanaResourceSchema.and(
  z.object({
    title: z.string().optional(),
  }),
);

export const color2Schema = z.union([z.literal('green'), z.literal('yellow'), z.literal('red'), z.literal('blue')]);

export const projectStatusBaseSchema = projectStatusCompactSchema.and(
  z.object({
    color: z.union([z.literal('green'), z.literal('yellow'), z.literal('red'), z.literal('blue')]),
    html_text: z.string().optional(),
    text: z.string(),
  }),
);

export const projectStatusResponseSchema = projectStatusBaseSchema.and(
  z.object({
    author: userCompactSchema.optional(),
    created_at: z.string().optional(),
    created_by: userCompactSchema.optional(),
    modified_at: z.string().optional(),
  }),
);

export const projectTemplateBaseSchema = projectTemplateCompactSchema.and(
  z.object({
    color: z
      .union([
        z.literal('dark-pink'),
        z.literal('dark-green'),
        z.literal('dark-blue'),
        z.literal('dark-red'),
        z.literal('dark-teal'),
        z.literal('dark-brown'),
        z.literal('dark-orange'),
        z.literal('dark-purple'),
        z.literal('dark-warm-gray'),
        z.literal('light-pink'),
        z.literal('light-green'),
        z.literal('light-blue'),
        z.literal('light-red'),
        z.literal('light-teal'),
        z.literal('light-brown'),
        z.literal('light-orange'),
        z.literal('light-purple'),
        z.literal('light-warm-gray'),
      ])
      .optional()
      .nullable(),
    description: z.string().optional(),
    html_description: z.string().optional(),
    owner: userCompactSchema.optional().nullable(),
    public: z.boolean().optional(),
    requested_dates: z.array(dateVariableCompactSchema).optional(),
    team: teamCompactSchema.optional(),
  }),
);

export const projectTemplateInstantiateProjectRequestSchema = z.object({
  is_strict: z.boolean().optional(),
  name: z.string(),
  public: z.boolean(),
  requested_dates: z.array(dateVariableRequestSchema).optional(),
  team: z.string().optional(),
  workspace: z.string().optional(),
});

export const projectTemplateResponseSchema = projectTemplateBaseSchema;

export const removeCustomFieldSettingRequestSchema = z.object({
  custom_field: z.string(),
});

export const removeFollowersRequestSchema = z.object({
  followers: z.string(),
});

export const removeMembersRequestSchema = z.object({
  members: z.string(),
});

export const sectionCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const sectionRequestSchema = z.object({
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  name: z.string(),
});

export const sectionResponseSchema = sectionCompactSchema.and(
  z.object({
    created_at: z.string().optional(),
    project: projectCompactSchema.optional(),
    projects: z.array(projectCompactSchema).optional(),
  }),
);

export const sectionTaskInsertRequestSchema = z.object({
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  task: z.string(),
});

export const statusUpdateBaseSchema = statusUpdateCompactSchema.and(
  z.object({
    html_text: z.string().optional(),
    status_type: z.union([
      z.literal('on_track'),
      z.literal('at_risk'),
      z.literal('off_track'),
      z.literal('on_hold'),
      z.literal('complete'),
      z.literal('achieved'),
      z.literal('partial'),
      z.literal('missed'),
      z.literal('dropped'),
    ]),
    text: z.string(),
  }),
);

export const statusTypeSchema = z.union([
  z.literal('on_track'),
  z.literal('at_risk'),
  z.literal('off_track'),
  z.literal('on_hold'),
  z.literal('complete'),
  z.literal('achieved'),
  z.literal('partial'),
  z.literal('missed'),
  z.literal('dropped'),
]);

export const resourceSubtype5Schema = z.union([
  z.literal('project_status_update'),
  z.literal('portfolio_status_update'),
  z.literal('goal_status_update'),
]);

export const statusUpdateRequestSchema = statusUpdateBaseSchema.and(
  z.object({
    parent: z.string(),
  }),
);

export const statusUpdateResponseSchema = statusUpdateBaseSchema.and(
  z.object({
    author: userCompactSchema.optional(),
    created_at: z.string().optional(),
    created_by: userCompactSchema.optional(),
    hearted: z.boolean().optional(),
    hearts: z.array(likeSchema).optional(),
    liked: z.boolean().optional(),
    likes: z.array(likeSchema).optional(),
    modified_at: z.string().optional(),
    num_hearts: z.number().optional(),
    num_likes: z.number().optional(),
    parent: projectCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const storyBaseSchema = asanaResourceSchema.and(
  z.object({
    created_at: z.string().optional(),
    html_text: z.string().optional(),
    is_pinned: z.boolean().optional(),
    resource_subtype: z.string().optional(),
    sticker_name: z
      .union([
        z.literal('green_checkmark'),
        z.literal('people_dancing'),
        z.literal('dancing_unicorn'),
        z.literal('heart'),
        z.literal('party_popper'),
        z.literal('people_waving_flags'),
        z.literal('splashing_narwhal'),
        z.literal('trophy'),
        z.literal('yeti_riding_unicorn'),
        z.literal('celebrating_people'),
        z.literal('determined_climbers'),
        z.literal('phoenix_spreading_love'),
      ])
      .optional(),
    text: z.string().optional(),
  }),
);

export const stickerNameSchema = z.union([
  z.literal('green_checkmark'),
  z.literal('people_dancing'),
  z.literal('dancing_unicorn'),
  z.literal('heart'),
  z.literal('party_popper'),
  z.literal('people_waving_flags'),
  z.literal('splashing_narwhal'),
  z.literal('trophy'),
  z.literal('yeti_riding_unicorn'),
  z.literal('celebrating_people'),
  z.literal('determined_climbers'),
  z.literal('phoenix_spreading_love'),
]);

export const storyCompactSchema = asanaResourceSchema.and(
  z.object({
    created_at: z.string().optional(),
    created_by: userCompactSchema.optional(),
    resource_subtype: z.string().optional(),
    text: z.string().optional(),
  }),
);

export const storyRequestSchema = storyBaseSchema;

export const storyResponseDatesSchema = z.object({
  due_at: z.string().optional().nullable(),
  due_on: z.string().optional(),
  start_on: z.string().optional().nullable(),
});

export const tagCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
  }),
);

export const sourceSchema = z.union([
  z.literal('web'),
  z.literal('email'),
  z.literal('mobile'),
  z.literal('api'),
  z.literal('unknown'),
]);

export const type2Schema = z.union([z.literal('comment'), z.literal('system')]);

export const tagBaseSchema = tagCompactSchema.and(
  z.object({
    color: z
      .union([
        z.literal('dark-pink'),
        z.literal('dark-green'),
        z.literal('dark-blue'),
        z.literal('dark-red'),
        z.literal('dark-teal'),
        z.literal('dark-brown'),
        z.literal('dark-orange'),
        z.literal('dark-purple'),
        z.literal('dark-warm-gray'),
        z.literal('light-pink'),
        z.literal('light-green'),
        z.literal('light-blue'),
        z.literal('light-red'),
        z.literal('light-teal'),
        z.literal('light-brown'),
        z.literal('light-orange'),
        z.literal('light-purple'),
        z.literal('light-warm-gray'),
      ])
      .optional()
      .nullable(),
    notes: z.string().optional(),
  }),
);

export const tagRequestSchema = tagBaseSchema.and(
  z.object({
    followers: z.array(z.string()).optional(),
    workspace: z.string().optional(),
  }),
);

export const tagResponseSchema = tagBaseSchema.and(
  z.object({
    created_at: z.string().optional(),
    followers: z.array(userCompactSchema).optional(),
    permalink_url: z.string().optional(),
    workspace: workspaceCompactSchema.optional(),
  }),
);

export const taskAddFollowersRequestSchema = z.object({
  followers: z.array(z.string()),
});

export const taskAddProjectRequestSchema = z.object({
  insert_after: z.string().optional().nullable(),
  insert_before: z.string().optional().nullable(),
  project: z.string(),
  section: z.string().optional().nullable(),
});

export const taskAddTagRequestSchema = z.object({
  tag: z.string(),
});

export const taskBaseSchema = taskCompactSchema.and(
  z.object({
    actual_time_minutes: z.number().optional().nullable(),
    approval_status: z
      .union([z.literal('pending'), z.literal('approved'), z.literal('rejected'), z.literal('changes_requested')])
      .optional(),
    assignee_status: z
      .union([z.literal('today'), z.literal('upcoming'), z.literal('later'), z.literal('new'), z.literal('inbox')])
      .optional(),
    completed: z.boolean().optional(),
    completed_at: z.string().optional().nullable(),
    completed_by: userCompactSchema.optional(),
    created_at: z.string().optional(),
    dependencies: z.array(asanaResourceSchema).optional(),
    dependents: z.array(asanaResourceSchema).optional(),
    due_at: z.string().optional().nullable(),
    due_on: z.string().optional().nullable(),
    external: z
      .object({
        data: z.string().optional(),
        gid: z.string().optional(),
      })
      .optional(),
    hearted: z.boolean().optional(),
    hearts: z.array(likeSchema).optional(),
    html_notes: z.string().optional(),
    is_rendered_as_separator: z.boolean().optional(),
    liked: z.boolean().optional(),
    likes: z.array(likeSchema).optional(),
    memberships: z
      .array(
        z.object({
          project: projectCompactSchema.optional(),
          section: sectionCompactSchema.optional(),
        }),
      )
      .optional(),
    modified_at: z.string().optional(),
    name: z.string().optional(),
    notes: z.string().optional(),
    num_hearts: z.number().optional(),
    num_likes: z.number().optional(),
    num_subtasks: z.number().optional(),
    start_at: z.string().optional().nullable(),
    start_on: z.string().optional().nullable(),
  }),
);

export const approvalStatusSchema = z.union([
  z.literal('pending'),
  z.literal('approved'),
  z.literal('rejected'),
  z.literal('changes_requested'),
]);

export const assigneeStatusSchema = z.union([
  z.literal('today'),
  z.literal('upcoming'),
  z.literal('later'),
  z.literal('new'),
  z.literal('inbox'),
]);

export const resourceSubtype6Schema = z.union([
  z.literal('default_task'),
  z.literal('milestone'),
  z.literal('section'),
  z.literal('approval'),
]);

export const taskCountResponseSchema = z.object({
  num_completed_milestones: z.number().optional(),
  num_completed_tasks: z.number().optional(),
  num_incomplete_milestones: z.number().optional(),
  num_incomplete_tasks: z.number().optional(),
  num_milestones: z.number().optional(),
  num_tasks: z.number().optional(),
});

export const taskDuplicateRequestSchema = z.object({
  include: z
    .union([
      z.literal('notes'),
      z.literal('assignee'),
      z.literal('subtasks'),
      z.literal('attachments'),
      z.literal('tags'),
      z.literal('followers'),
      z.literal('projects'),
      z.literal('dates'),
      z.literal('dependencies'),
      z.literal('parent'),
    ])
    .optional(),
  name: z.string().optional(),
});

export const include2Schema = z.union([
  z.literal('notes'),
  z.literal('assignee'),
  z.literal('subtasks'),
  z.literal('attachments'),
  z.literal('tags'),
  z.literal('followers'),
  z.literal('projects'),
  z.literal('dates'),
  z.literal('dependencies'),
  z.literal('parent'),
]);

export const taskRemoveFollowersRequestSchema = z.object({
  followers: z.array(z.string()),
});

export const taskRemoveProjectRequestSchema = z.object({
  project: z.string(),
});

export const taskRemoveTagRequestSchema = z.object({
  tag: z.string(),
});

export const taskRequestSchema = taskBaseSchema.and(
  z.object({
    assignee: z.string().optional().nullable(),
    assignee_section: z.string().optional().nullable(),
    custom_fields: z.record(z.string()).optional(),
    followers: z.array(z.string()).optional(),
    parent: z.string().optional().nullable(),
    projects: z.array(z.string()).optional(),
    tags: z.array(z.string()).optional(),
    workspace: z.string().optional(),
  }),
);

export const taskResponseSchema = taskBaseSchema.and(
  z.object({
    assignee: userCompactSchema.optional().nullable(),
    assignee_section: sectionCompactSchema.and(z.unknown()).optional().nullable(),
    custom_fields: z.array(customFieldResponseSchema).optional(),
    followers: z.array(userCompactSchema).optional(),
    parent: taskCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    permalink_url: z.string().optional(),
    projects: z.array(projectCompactSchema).optional(),
    tags: z.array(tagCompactSchema).optional(),
    workspace: workspaceCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const taskSetParentRequestSchema = z.object({
  insert_after: z.string().optional(),
  insert_before: z.string().optional(),
  parent: z.string(),
});

export const teamAddUserRequestSchema = z.object({
  user: z.string().optional(),
});

export const teamBaseSchema = teamCompactSchema;

export const teamMembershipCompactSchema = asanaResourceSchema.and(
  z.object({
    is_guest: z.boolean().optional(),
    team: teamCompactSchema.optional(),
    user: userCompactSchema.optional(),
  }),
);

export const teamMembershipResponseSchema = teamMembershipCompactSchema;

export const teamRemoveUserRequestSchema = z.object({
  user: z.string().optional(),
});

export const teamRequestSchema = teamCompactSchema.and(
  z.object({
    description: z.string().optional(),
    html_description: z.string().optional(),
    organization: z.string().optional(),
    visibility: z.union([z.literal('secret'), z.literal('request_to_join'), z.literal('public')]).optional(),
  }),
);

export const visibilitySchema = z.union([z.literal('secret'), z.literal('request_to_join'), z.literal('public')]);

export const teamResponseSchema = teamCompactSchema.and(
  z.object({
    description: z.string().optional(),
    html_description: z.string().optional(),
    organization: workspaceCompactSchema.and(z.record(z.unknown())).optional(),
    permalink_url: z.string().optional(),
    visibility: z.union([z.literal('secret'), z.literal('request_to_join'), z.literal('public')]).optional(),
  }),
);

export const timePeriodBaseSchema = timePeriodCompactSchema.and(
  z.object({
    parent: timePeriodCompactSchema.optional(),
  }),
);

export const periodSchema = z.union([
  z.literal('FY'),
  z.literal('H1'),
  z.literal('H2'),
  z.literal('Q1'),
  z.literal('Q2'),
  z.literal('Q3'),
  z.literal('Q4'),
]);

export const timePeriodResponseSchema = timePeriodBaseSchema.and(z.record(z.unknown()));

export const userBaseSchema = userCompactSchema;

export const userBaseResponseSchema = userCompactSchema.and(
  z.object({
    email: z.string().optional(),
    photo: z
      .object({
        image_1024x1024: z.string().optional(),
        image_128x128: z.string().optional(),
        image_21x21: z.string().optional(),
        image_27x27: z.string().optional(),
        image_36x36: z.string().optional(),
        image_60x60: z.string().optional(),
      })
      .optional()
      .nullable(),
  }),
);

export const userRequestSchema = userCompactSchema;

export const userResponseSchema = userBaseResponseSchema.and(
  z.object({
    workspaces: z.array(workspaceCompactSchema).optional(),
  }),
);

export const userTaskListCompactSchema = asanaResourceSchema.and(
  z.object({
    name: z.string().optional(),
    owner: userCompactSchema.optional(),
    workspace: workspaceCompactSchema.optional(),
  }),
);

export const userTaskListRequestSchema = userTaskListCompactSchema;

export const userTaskListResponseSchema = userTaskListCompactSchema;

export const webhookCompactSchema = asanaResourceSchema.and(
  z.object({
    active: z.boolean().optional(),
    resource: asanaNamedResourceSchema.optional(),
    target: z.string().optional(),
  }),
);

export const webhookFilterSchema = z.object({
  action: z.string().optional(),
  fields: z.array(z.string()).optional(),
  resource_subtype: z.string().optional(),
  resource_type: z.string().optional(),
});

export const webhookRequestSchema = z.object({
  filters: z.array(webhookFilterSchema.and(z.unknown()).and(z.record(z.unknown()))).optional(),
  resource: z.string(),
  target: z.string(),
});

export const webhookResponseSchema = webhookCompactSchema.and(
  z.object({
    created_at: z.string().optional(),
    filters: z.array(webhookFilterSchema.and(z.unknown()).and(z.record(z.unknown()))).optional(),
    last_failure_at: z.string().optional(),
    last_failure_content: z.string().optional(),
    last_success_at: z.string().optional(),
  }),
);

export const webhookUpdateRequestSchema = z.object({
  filters: z.array(webhookFilterSchema.and(z.unknown()).and(z.record(z.unknown()))).optional(),
});

export const workspaceAddUserRequestSchema = z.object({
  user: z.string().optional(),
});

export const workspaceBaseSchema = workspaceCompactSchema;

export const workspaceMembershipCompactSchema = asanaResourceSchema.and(
  z.object({
    user: userCompactSchema.optional(),
    workspace: workspaceCompactSchema.optional(),
  }),
);

export const workspaceMembershipRequestSchema = workspaceMembershipCompactSchema;

export const workspaceMembershipResponseSchema = workspaceMembershipCompactSchema.and(
  z.object({
    is_active: z.boolean().optional(),
    is_admin: z.boolean().optional(),
    is_guest: z.boolean().optional(),
    user_task_list: userTaskListCompactSchema.optional(),
    vacation_dates: z
      .object({
        end_on: z.string().optional().nullable(),
        start_on: z.string().optional(),
      })
      .optional()
      .nullable(),
  }),
);

export const workspaceRemoveUserRequestSchema = z.object({
  user: z.string().optional(),
});

export const workspaceRequestSchema = workspaceCompactSchema;

export const workspaceResponseSchema = workspaceCompactSchema.and(
  z.object({
    email_domains: z.array(z.string()).optional(),
    is_organization: z.boolean().optional(),
  }),
);

export const parameterarchivedQueryParamSchema = z.boolean();

export const parameterattachmentPathGidSchema = z.string();

export const parameterauditLogActorGidSchema = z.string();

export const parameterauditLogActorTypeSchema = z.union([
  z.literal('user'),
  z.literal('asana'),
  z.literal('asana_support'),
  z.literal('anonymous'),
  z.literal('external_administrator'),
]);

export const parameterauditLogEndAtSchema = z.string();

export const parameterauditLogEventTypeSchema = z.string();

export const parameterauditLogResourceGidSchema = z.string();

export const parameterauditLogStartAtSchema = z.string();

export const parametercompletedSinceSchema = z.string();

export const parametercustomFieldPathGidSchema = z.string();

export const parameterfieldsSchema = z.array(z.string());

export const parametergoalPathGidSchema = z.string();

export const parametergoalRelationshipPathGidSchema = z.string();

export const parameterjobPathGidSchema = z.string();

export const parameterlimitSchema = z.number();

export const parametermemberSchema = z.string();

export const parametermessagePathGidSchema = z.string();

export const parameteroffsetSchema = z.string();

export const parameterorganizationExportPathGidSchema = z.string();

export const parameterparentSchema = z.string();

export const parameterportfolioMembershipPathGidSchema = z.string();

export const parameterportfolioPathGidSchema = z.string();

export const parameterportfolioQueryParamSchema = z.string();

export const parameterprettySchema = z.boolean();

export const parameterprojectBriefPathGidSchema = z.string();

export const parameterprojectMembershipPathGidSchema = z.string();

export const parameterprojectPathGidSchema = z.string();

export const parameterprojectStatusPathGidSchema = z.string();

export const parameterprojectTemplatePathGidSchema = z.string();

export const parametersectionPathGidSchema = z.string();

export const parameterstatusPathGidSchema = z.string();

export const parameterstoryPathGidSchema = z.string();

export const parametertagPathGidSchema = z.string();

export const parametertaskPathGidSchema = z.string();

export const parameterteamMembershipPathGidSchema = z.string();

export const parameterteamPathGidSchema = z.string();

export const parameterteamQueryParamSchema = z.string();

export const parametertimePeriodPathGidSchema = z.string();

export const parameteruserPathGidSchema = z.string();

export const parameteruserQueryParamSchema = z.string();

export const parameteruserTaskListPathGidSchema = z.string();

export const parameterwebhookPathGidSchema = z.string();

export const parameterworkspaceMembershipPathGidSchema = z.string();

export const parameterworkspacePathGidSchema = z.string();

export const parameterworkspaceQueryParamSchema = z.string();

export const getAttachmentsForObjectDataSchema = z.object({
  query: z.object({
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    parent: z.string(),
  }),
});

export const getAttachmentsForObjectResponseSchema = z.object({
  data: z.array(attachmentCompactSchema).optional(),
});

export const getAttachmentsForObjectErrorSchema = errorResponseSchema;

export const attachmentResponseSchema = attachmentCompactSchema.and(
  z.object({
    connected_to_app: z.boolean().optional(),
    created_at: z.string().optional(),
    download_url: z.string().optional().nullable(),
    host: z.string().optional(),
    parent: taskCompactSchema
      .and(
        z.object({
          resource_subtype: z.string().optional().nullable(),
        }),
      )
      .optional(),
    permanent_url: z.string().optional().nullable(),
    size: z.number().optional(),
    view_url: z.string().optional().nullable(),
  }),
);

export const createAttachmentForObjectErrorSchema = errorResponseSchema;

export const deleteAttachmentDataSchema = z.object({
  path: z.object({
    attachment_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteAttachmentResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteAttachmentErrorSchema = errorResponseSchema;

export const getAttachmentDataSchema = z.object({
  path: z.object({
    attachment_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getAttachmentResponseSchema = z.object({
  data: attachmentResponseSchema.optional(),
});

export const getAttachmentErrorSchema = errorResponseSchema;

export const batchRequestSchema = z.object({
  actions: z.array(batchRequestActionSchema).optional(),
});

export const createBatchRequestResponseSchema = z.object({
  data: z.array(batchResponseSchema).optional(),
});

export const createBatchRequestErrorSchema = errorResponseSchema;

export const customFieldRequestSchema = customFieldBaseSchema.and(
  z.object({
    people_value: z.array(z.string()).optional(),
    workspace: z.string(),
  }),
);

export const createCustomFieldResponseSchema = z.object({
  data: customFieldResponseSchema.optional(),
});

export const createCustomFieldErrorSchema = errorResponseSchema;

export const deleteCustomFieldDataSchema = z.object({
  path: z.object({
    custom_field_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteCustomFieldResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteCustomFieldErrorSchema = errorResponseSchema;

export const getCustomFieldDataSchema = z.object({
  path: z.object({
    custom_field_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getCustomFieldResponseSchema = z.object({
  data: customFieldResponseSchema.optional(),
});

export const getCustomFieldErrorSchema = errorResponseSchema;

export const updateCustomFieldDataSchema = z.object({
  body: z
    .object({
      data: customFieldRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    custom_field_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateCustomFieldResponseSchema = z.object({
  data: customFieldResponseSchema.optional(),
});

export const updateCustomFieldErrorSchema = errorResponseSchema;

export const createEnumOptionForCustomFieldDataSchema = z.object({
  body: z
    .object({
      data: enumOptionRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    custom_field_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createEnumOptionForCustomFieldResponseSchema = z.object({
  data: enumOptionSchema.optional(),
});

export const createEnumOptionForCustomFieldErrorSchema = errorResponseSchema;

export const insertEnumOptionForCustomFieldDataSchema = z.object({
  body: z
    .object({
      data: enumOptionInsertRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    custom_field_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const insertEnumOptionForCustomFieldResponseSchema = z.object({
  data: enumOptionSchema.optional(),
});

export const insertEnumOptionForCustomFieldErrorSchema = errorResponseSchema;

export const updateEnumOptionDataSchema = z.object({
  body: z
    .object({
      data: enumOptionRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    enum_option_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateEnumOptionResponseSchema = z.object({
  data: enumOptionSchema.optional(),
});

export const updateEnumOptionErrorSchema = errorResponseSchema;

export const getEventsDataSchema = z.object({
  query: z.object({
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    resource: z.string(),
    sync: z.string().optional(),
  }),
});

export const eventResponseSchema = z.object({
  action: z.string().optional(),
  change: z
    .object({
      action: z.string().optional(),
      added_value: z.unknown().optional(),
      field: z.string().optional(),
      new_value: z.unknown().optional(),
      removed_value: z.unknown().optional(),
    })
    .optional(),
  created_at: z.string().optional(),
  parent: asanaNamedResourceSchema.and(z.unknown()).optional(),
  resource: asanaNamedResourceSchema.and(z.unknown()).optional(),
  type: z.string().optional(),
  user: userCompactSchema.and(z.unknown()).optional(),
});

export const getEventsErrorSchema = errorResponseSchema;

export const getGoalRelationshipsDataSchema = z.object({
  query: z.object({
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    resource_subtype: z.string().optional(),
    supported_goal: z.string(),
  }),
});

export const getGoalRelationshipsResponseSchema = z.object({
  data: z.array(goalRelationshipCompactSchema).optional(),
});

export const getGoalRelationshipsErrorSchema = errorResponseSchema;

export const getGoalRelationshipDataSchema = z.object({
  path: z.object({
    goal_relationship_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getGoalRelationshipResponseSchema = z.object({
  data: goalRelationshipResponseSchema.optional(),
});

export const getGoalRelationshipErrorSchema = errorResponseSchema;

export const goalRelationshipRequestSchema = goalRelationshipBaseSchema.and(z.record(z.unknown()));

export const updateGoalRelationshipResponseSchema = z.object({
  data: goalRelationshipResponseSchema.optional(),
});

export const updateGoalRelationshipErrorSchema = errorResponseSchema;

export const getGoalsDataSchema = z.object({
  query: z
    .object({
      is_workspace_level: z.boolean().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      portfolio: z.string().optional(),
      project: z.string().optional(),
      team: z.string().optional(),
      time_periods: z.array(z.string()).optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getGoalsResponseSchema = z.object({
  data: z.array(goalCompactSchema).optional(),
});

export const getGoalsErrorSchema = errorResponseSchema;

export const createGoalDataSchema = z.object({
  body: z.object({
    data: goalRequestSchema.optional(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const goalResponseSchema = goalBaseSchema.and(
  z.object({
    current_status_update: statusUpdateCompactSchema.optional().nullable(),
    followers: z.array(userCompactSchema).optional(),
    likes: z.array(likeSchema).optional(),
    metric: goalMetricBaseSchema
      .and(
        z.object({
          can_manage: z.boolean().optional(),
        }),
      )
      .optional()
      .nullable(),
    num_likes: z.number().optional(),
    owner: userCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    team: teamCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    time_period: timePeriodCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    workspace: workspaceCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const createGoalErrorSchema = errorResponseSchema;

export const deleteGoalDataSchema = z.object({
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteGoalResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteGoalErrorSchema = errorResponseSchema;

export const getGoalDataSchema = z.object({
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getGoalResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const getGoalErrorSchema = errorResponseSchema;

export const updateGoalDataSchema = z.object({
  body: z.object({
    data: goalRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateGoalResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const updateGoalErrorSchema = errorResponseSchema;

export const addFollowersDataSchema = z.object({
  body: z.object({
    data: taskAddFollowersRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addFollowersResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const addFollowersErrorSchema = errorResponseSchema;

export const addSupportingRelationshipDataSchema = z.object({
  body: z.object({
    data: goalAddSupportingRelationshipRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addSupportingRelationshipResponseSchema = z.object({
  data: goalRelationshipResponseSchema.optional(),
});

export const addSupportingRelationshipErrorSchema = errorResponseSchema;

export const getParentGoalsForGoalDataSchema = z.object({
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getParentGoalsForGoalResponseSchema = z.object({
  data: z.array(goalCompactSchema).optional(),
});

export const getParentGoalsForGoalErrorSchema = errorResponseSchema;

export const removeFollowersDataSchema = z.object({
  body: z.object({
    data: taskAddFollowersRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeFollowersResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const removeFollowersErrorSchema = errorResponseSchema;

export const removeSupportingRelationshipDataSchema = z.object({
  body: z.object({
    data: goalRemoveSupportingRelationshipRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeSupportingRelationshipResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeSupportingRelationshipErrorSchema = errorResponseSchema;

export const createGoalMetricDataSchema = z.object({
  body: z.object({
    data: goalMetricBaseSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createGoalMetricResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const createGoalMetricErrorSchema = errorResponseSchema;

export const updateGoalMetricDataSchema = z.object({
  body: z.object({
    data: goalMetricCurrentValueRequestSchema.optional(),
  }),
  path: z.object({
    goal_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateGoalMetricResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const updateGoalMetricErrorSchema = errorResponseSchema;

export const getJobDataSchema = z.object({
  path: z.object({
    job_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getJobResponseSchema = z.object({
  data: jobCompactSchema.optional(),
});

export const getJobErrorSchema = errorResponseSchema;

export const createOrganizationExportDataSchema = z.object({
  body: z.object({
    data: organizationExportRequestSchema.optional(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createOrganizationExportResponseSchema = z.object({
  data: organizationExportCompactSchema.optional(),
});

export const createOrganizationExportErrorSchema = errorResponseSchema;

export const getOrganizationExportDataSchema = z.object({
  path: z.object({
    organization_export_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getOrganizationExportResponseSchema = z.object({
  data: organizationExportCompactSchema.optional(),
});

export const getOrganizationExportErrorSchema = errorResponseSchema;

export const getPortfolioMembershipsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      portfolio: z.string().optional(),
      user: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getPortfolioMembershipsResponseSchema = z.object({
  data: z.array(portfolioMembershipCompactSchema).optional(),
});

export const getPortfolioMembershipsErrorSchema = errorResponseSchema;

export const getPortfolioMembershipDataSchema = z.object({
  path: z.object({
    portfolio_membership_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getPortfolioMembershipResponseSchema = z.object({
  data: portfolioMembershipCompactSchema.optional(),
});

export const getPortfolioMembershipErrorSchema = errorResponseSchema;

export const getPortfoliosDataSchema = z.object({
  query: z.object({
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    owner: z.string(),
    workspace: z.string(),
  }),
});

export const getPortfoliosResponseSchema = z.object({
  data: z.array(portfolioCompactSchema).optional(),
});

export const getPortfoliosErrorSchema = errorResponseSchema;

export const portfolioRequestSchema = portfolioBaseSchema.and(
  z.object({
    members: z.array(z.string()).optional(),
    public: z.boolean().optional(),
    workspace: z.string().optional(),
  }),
);

export const portfolioResponseSchema = portfolioBaseSchema.and(
  z.object({
    created_at: z.string().optional(),
    created_by: userCompactSchema.optional(),
    current_status_update: statusUpdateCompactSchema.optional().nullable(),
    custom_field_settings: z.array(customFieldSettingResponseSchema).optional(),
    custom_fields: z.array(customFieldCompactSchema).optional(),
    due_on: z.string().optional().nullable(),
    members: z.array(userCompactSchema).optional(),
    owner: userCompactSchema.optional(),
    permalink_url: z.string().optional(),
    public: z.boolean().optional(),
    start_on: z.string().optional().nullable(),
    workspace: workspaceCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const createPortfolioErrorSchema = errorResponseSchema;

export const deletePortfolioDataSchema = z.object({
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deletePortfolioResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deletePortfolioErrorSchema = errorResponseSchema;

export const getPortfolioDataSchema = z.object({
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getPortfolioResponseSchema = z.object({
  data: portfolioResponseSchema.optional(),
});

export const getPortfolioErrorSchema = errorResponseSchema;

export const updatePortfolioDataSchema = z.object({
  body: z.object({
    data: portfolioRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updatePortfolioResponseSchema = z.object({
  data: portfolioResponseSchema.optional(),
});

export const updatePortfolioErrorSchema = errorResponseSchema;

export const addCustomFieldSettingForPortfolioDataSchema = z.object({
  body: z.object({
    data: addCustomFieldSettingRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addCustomFieldSettingForPortfolioResponseSchema = z.object({
  data: customFieldSettingResponseSchema.optional(),
});

export const addCustomFieldSettingForPortfolioErrorSchema = errorResponseSchema;

export const addItemForPortfolioDataSchema = z.object({
  body: z.object({
    data: portfolioAddItemRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addItemForPortfolioResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addItemForPortfolioErrorSchema = errorResponseSchema;

export const addMembersForPortfolioDataSchema = z.object({
  body: z.object({
    data: addMembersRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addMembersForPortfolioResponseSchema = z.object({
  data: portfolioResponseSchema.optional(),
});

export const addMembersForPortfolioErrorSchema = errorResponseSchema;

export const getCustomFieldSettingsForPortfolioDataSchema = z.object({
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getCustomFieldSettingsForPortfolioResponseSchema = z.object({
  data: z.array(customFieldSettingResponseSchema).optional(),
});

export const getCustomFieldSettingsForPortfolioErrorSchema = errorResponseSchema;

export const getItemsForPortfolioDataSchema = z.object({
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getItemsForPortfolioResponseSchema = z.object({
  data: z.array(projectCompactSchema).optional(),
});

export const getItemsForPortfolioErrorSchema = errorResponseSchema;

export const getPortfolioMembershipsForPortfolioDataSchema = z.object({
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const getPortfolioMembershipsForPortfolioResponseSchema = z.object({
  data: z.array(portfolioMembershipCompactSchema).optional(),
});

export const getPortfolioMembershipsForPortfolioErrorSchema = errorResponseSchema;

export const removeCustomFieldSettingForPortfolioDataSchema = z.object({
  body: z.object({
    data: removeCustomFieldSettingRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeCustomFieldSettingForPortfolioResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeCustomFieldSettingForPortfolioErrorSchema = errorResponseSchema;

export const removeItemForPortfolioDataSchema = z.object({
  body: z.object({
    data: portfolioRemoveItemRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeItemForPortfolioResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeItemForPortfolioErrorSchema = errorResponseSchema;

export const removeMembersForPortfolioDataSchema = z.object({
  body: z.object({
    data: removeMembersRequestSchema.optional(),
  }),
  path: z.object({
    portfolio_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeMembersForPortfolioResponseSchema = z.object({
  data: portfolioResponseSchema.optional(),
});

export const removeMembersForPortfolioErrorSchema = errorResponseSchema;

export const deleteProjectBriefDataSchema = z.object({
  path: z.object({
    project_brief_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteProjectBriefResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteProjectBriefErrorSchema = errorResponseSchema;

export const getProjectBriefDataSchema = z.object({
  path: z.object({
    project_brief_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectBriefResponseSchema = z.object({
  data: projectBriefResponseSchema.optional(),
});

export const getProjectBriefErrorSchema = errorResponseSchema;

export const projectBriefRequestSchema = projectBriefBaseSchema.and(
  z.object({
    text: z.string().optional(),
  }),
);

export const updateProjectBriefResponseSchema = z.object({
  data: projectBriefResponseSchema.optional(),
});

export const updateProjectBriefErrorSchema = errorResponseSchema;

export const getProjectMembershipDataSchema = z.object({
  path: z.object({
    project_membership_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectMembershipResponseSchema = z.object({
  data: projectMembershipResponseSchema.optional(),
});

export const getProjectMembershipErrorSchema = errorResponseSchema;

export const deleteProjectStatusDataSchema = z.object({
  path: z.object({
    project_status_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteProjectStatusResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteProjectStatusErrorSchema = errorResponseSchema;

export const getProjectStatusDataSchema = z.object({
  path: z.object({
    project_status_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectStatusResponseSchema = z.object({
  data: projectStatusResponseSchema.optional(),
});

export const getProjectStatusErrorSchema = errorResponseSchema;

export const getProjectTemplatesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      team: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getProjectTemplatesResponseSchema = z.object({
  data: z.array(projectTemplateCompactSchema).optional(),
});

export const getProjectTemplatesErrorSchema = errorResponseSchema;

export const getProjectTemplateDataSchema = z.object({
  path: z.object({
    project_template_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectTemplateResponseSchema = z.object({
  data: projectTemplateResponseSchema.optional(),
});

export const getProjectTemplateErrorSchema = errorResponseSchema;

export const instantiateProjectDataSchema = z.object({
  body: z
    .object({
      data: projectTemplateInstantiateProjectRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    project_template_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const instantiateProjectResponseSchema = z.object({
  data: jobCompactSchema.optional(),
});

export const instantiateProjectErrorSchema = errorResponseSchema;

export const getProjectsDataSchema = z.object({
  query: z
    .object({
      archived: z.boolean().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      team: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getProjectsResponseSchema = z.object({
  data: z.array(projectCompactSchema).optional(),
});

export const getProjectsErrorSchema = errorResponseSchema;

export const createProjectErrorSchema = errorResponseSchema;

export const deleteProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteProjectResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteProjectErrorSchema = errorResponseSchema;

export const getProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectErrorSchema = errorResponseSchema;

export const updateProjectErrorSchema = errorResponseSchema;

export const addCustomFieldSettingForProjectDataSchema = z.object({
  body: z.object({
    data: addCustomFieldSettingRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addCustomFieldSettingForProjectResponseSchema = z.object({
  data: customFieldSettingResponseSchema.optional(),
});

export const addCustomFieldSettingForProjectErrorSchema = errorResponseSchema;

export const addFollowersForProjectDataSchema = z.object({
  body: z.object({
    data: addFollowersRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addFollowersForProjectErrorSchema = errorResponseSchema;

export const addMembersForProjectDataSchema = z.object({
  body: z.object({
    data: addMembersRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addMembersForProjectErrorSchema = errorResponseSchema;

export const getCustomFieldSettingsForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getCustomFieldSettingsForProjectResponseSchema = z.object({
  data: z.array(customFieldSettingResponseSchema).optional(),
});

export const getCustomFieldSettingsForProjectErrorSchema = errorResponseSchema;

export const duplicateProjectDataSchema = z.object({
  body: z
    .object({
      data: projectDuplicateRequestSchema.optional(),
    })
    .optional(),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const duplicateProjectResponseSchema = z.object({
  data: jobCompactSchema.optional(),
});

export const duplicateProjectErrorSchema = errorResponseSchema;

export const createProjectBriefDataSchema = z.object({
  body: z.object({
    data: projectBriefRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectBriefResponseSchema = z.object({
  data: projectBriefResponseSchema.optional(),
});

export const createProjectBriefErrorSchema = errorResponseSchema;

export const getProjectMembershipsForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const getProjectMembershipsForProjectResponseSchema = z.object({
  data: z.array(projectMembershipCompactSchema).optional(),
});

export const getProjectMembershipsForProjectErrorSchema = errorResponseSchema;

export const getProjectStatusesForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectStatusesForProjectResponseSchema = z.object({
  data: z.array(projectStatusCompactSchema).optional(),
});

export const getProjectStatusesForProjectErrorSchema = errorResponseSchema;

export const createProjectStatusForProjectDataSchema = z.object({
  body: z.object({
    data: projectStatusBaseSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectStatusForProjectResponseSchema = z.object({
  data: projectStatusResponseSchema.optional(),
});

export const createProjectStatusForProjectErrorSchema = errorResponseSchema;

export const removeCustomFieldSettingForProjectDataSchema = z.object({
  body: z.object({
    data: removeCustomFieldSettingRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeCustomFieldSettingForProjectResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeCustomFieldSettingForProjectErrorSchema = errorResponseSchema;

export const removeFollowersForProjectDataSchema = z.object({
  body: z.object({
    data: removeFollowersRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeFollowersForProjectErrorSchema = errorResponseSchema;

export const removeMembersForProjectDataSchema = z.object({
  body: z.object({
    data: removeMembersRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeMembersForProjectErrorSchema = errorResponseSchema;

export const projectSaveAsTemplateDataSchema = z.object({
  body: z.object({
    data: projectSaveAsTemplateRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const projectSaveAsTemplateResponseSchema = z.object({
  data: jobCompactSchema.optional(),
});

export const projectSaveAsTemplateErrorSchema = errorResponseSchema;

export const getSectionsForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getSectionsForProjectResponseSchema = z.object({
  data: z.array(sectionCompactSchema).optional(),
});

export const getSectionsForProjectErrorSchema = errorResponseSchema;

export const createSectionForProjectDataSchema = z.object({
  body: z.object({
    data: sectionRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createSectionForProjectResponseSchema = z.object({
  data: sectionResponseSchema.optional(),
});

export const createSectionForProjectErrorSchema = errorResponseSchema;

export const insertSectionForProjectDataSchema = z.object({
  body: z.object({
    data: projectSectionInsertRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const insertSectionForProjectResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const insertSectionForProjectErrorSchema = errorResponseSchema;

export const getTaskCountsForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTaskCountsForProjectResponseSchema = z.object({
  data: taskCountResponseSchema.optional(),
});

export const getTaskCountsForProjectErrorSchema = errorResponseSchema;

export const getTasksForProjectDataSchema = z.object({
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      completed_since: z.string().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTasksForProjectResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getTasksForProjectErrorSchema = errorResponseSchema;

export const deleteSectionDataSchema = z.object({
  path: z.object({
    section_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteSectionResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteSectionErrorSchema = errorResponseSchema;

export const getSectionDataSchema = z.object({
  path: z.object({
    section_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getSectionResponseSchema = z.object({
  data: sectionResponseSchema.optional(),
});

export const getSectionErrorSchema = errorResponseSchema;

export const updateSectionDataSchema = z.object({
  body: z.object({
    data: sectionRequestSchema.optional(),
  }),
  path: z.object({
    section_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateSectionResponseSchema = z.object({
  data: sectionResponseSchema.optional(),
});

export const updateSectionErrorSchema = errorResponseSchema;

export const addTaskForSectionDataSchema = z.object({
  body: z.object({
    data: sectionTaskInsertRequestSchema.optional(),
  }),
  path: z.object({
    section_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addTaskForSectionResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addTaskForSectionErrorSchema = errorResponseSchema;

export const getTasksForSectionDataSchema = z.object({
  path: z.object({
    section_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTasksForSectionResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getTasksForSectionErrorSchema = errorResponseSchema;

export const getStatusesForObjectDataSchema = z.object({
  query: z.object({
    created_since: z.string().optional(),
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    parent: z.string(),
  }),
});

export const getStatusesForObjectResponseSchema = z.object({
  data: z.array(statusUpdateCompactSchema).optional(),
});

export const getStatusesForObjectErrorSchema = errorResponseSchema;

export const createStatusForObjectDataSchema = z.object({
  body: z.object({
    data: statusUpdateRequestSchema.optional(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createStatusForObjectResponseSchema = z.object({
  data: statusUpdateResponseSchema.optional(),
});

export const createStatusForObjectErrorSchema = errorResponseSchema;

export const deleteStatusDataSchema = z.object({
  path: z.object({
    status_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteStatusResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteStatusErrorSchema = errorResponseSchema;

export const getStatusDataSchema = z.object({
  path: z.object({
    status_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getStatusResponseSchema = z.object({
  data: statusUpdateResponseSchema.optional(),
});

export const getStatusErrorSchema = errorResponseSchema;

export const deleteStoryDataSchema = z.object({
  path: z.object({
    story_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteStoryResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteStoryErrorSchema = errorResponseSchema;

export const getStoryDataSchema = z.object({
  path: z.object({
    story_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const storyResponseSchema = storyBaseSchema.and(
  z.object({
    assignee: userCompactSchema.optional(),
    created_by: userCompactSchema.optional(),
    custom_field: customFieldCompactSchema.optional(),
    dependency: taskCompactSchema.optional(),
    duplicate_of: taskCompactSchema.optional(),
    duplicated_from: taskCompactSchema.optional(),
    follower: userCompactSchema.optional(),
    hearted: z.boolean().optional(),
    hearts: z.array(likeSchema).optional(),
    is_editable: z.boolean().optional(),
    is_edited: z.boolean().optional(),
    liked: z.boolean().optional(),
    likes: z.array(likeSchema).optional(),
    new_approval_status: z.string().optional(),
    new_date_value: storyResponseDatesSchema.and(z.unknown()).optional(),
    new_dates: storyResponseDatesSchema.optional(),
    new_enum_value: enumOptionSchema.optional(),
    new_multi_enum_values: z.array(enumOptionSchema).optional(),
    new_name: z.string().optional(),
    new_number_value: z.number().optional(),
    new_people_value: z.array(userCompactSchema).optional(),
    new_resource_subtype: z.string().optional(),
    new_section: sectionCompactSchema.optional(),
    new_text_value: z.string().optional(),
    num_hearts: z.number().optional(),
    num_likes: z.number().optional(),
    old_approval_status: z.string().optional(),
    old_date_value: storyResponseDatesSchema.and(z.unknown()).optional(),
    old_dates: storyResponseDatesSchema.optional(),
    old_enum_value: enumOptionSchema.optional(),
    old_multi_enum_values: z.array(enumOptionSchema).optional(),
    old_name: z.string().optional(),
    old_number_value: z.number().optional(),
    old_people_value: z.array(userCompactSchema).optional(),
    old_resource_subtype: z.string().optional(),
    old_section: sectionCompactSchema.optional(),
    old_text_value: z.string().optional(),
    previews: z.array(previewSchema).optional(),
    project: projectCompactSchema.optional(),
    source: z
      .union([z.literal('web'), z.literal('email'), z.literal('mobile'), z.literal('api'), z.literal('unknown')])
      .optional(),
    story: storyCompactSchema.optional(),
    tag: tagCompactSchema.optional(),
    target: taskCompactSchema.and(z.record(z.unknown())).optional(),
    task: taskCompactSchema.optional(),
    type: z.union([z.literal('comment'), z.literal('system')]).optional(),
  }),
);

export const getStoryErrorSchema = errorResponseSchema;

export const updateStoryDataSchema = z.object({
  body: z.object({
    data: storyBaseSchema.optional(),
  }),
  path: z.object({
    story_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateStoryResponseSchema = z.object({
  data: storyResponseSchema.optional(),
});

export const updateStoryErrorSchema = errorResponseSchema;

export const getTagsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getTagsResponseSchema = z.object({
  data: z.array(tagCompactSchema).optional(),
});

export const getTagsErrorSchema = errorResponseSchema;

export const createTagDataSchema = z.object({
  body: z.object({
    data: tagRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createTagResponseSchema = z.object({
  data: tagResponseSchema.optional(),
});

export const createTagErrorSchema = errorResponseSchema;

export const deleteTagDataSchema = z.object({
  path: z.object({
    tag_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteTagResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteTagErrorSchema = errorResponseSchema;

export const getTagDataSchema = z.object({
  path: z.object({
    tag_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTagResponseSchema = z.object({
  data: tagResponseSchema.optional(),
});

export const getTagErrorSchema = errorResponseSchema;

export const updateTagDataSchema = z.object({
  path: z.object({
    tag_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateTagResponseSchema = z.object({
  data: tagResponseSchema.optional(),
});

export const updateTagErrorSchema = errorResponseSchema;

export const getTasksForTagDataSchema = z.object({
  path: z.object({
    tag_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTasksForTagResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getTasksForTagErrorSchema = errorResponseSchema;

export const getTasksDataSchema = z.object({
  query: z
    .object({
      assignee: z.string().optional(),
      completed_since: z.string().optional(),
      limit: z.number().optional(),
      modified_since: z.string().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      project: z.string().optional(),
      section: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getTasksResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getTasksErrorSchema = errorResponseSchema;

export const createTaskDataSchema = z.object({
  body: z.object({
    data: taskRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const createTaskErrorSchema = errorResponseSchema;

export const deleteTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteTaskErrorSchema = errorResponseSchema;

export const getTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const getTaskErrorSchema = errorResponseSchema;

export const updateTaskDataSchema = z.object({
  body: z.object({
    data: taskRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const updateTaskErrorSchema = errorResponseSchema;

export const addDependenciesForTaskDataSchema = z.object({
  body: z.object({
    data: modifyDependenciesRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addDependenciesForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addDependenciesForTaskErrorSchema = errorResponseSchema;

export const addDependentsForTaskDataSchema = z.object({
  body: z.object({
    data: modifyDependentsRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addDependentsForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addDependentsForTaskErrorSchema = errorResponseSchema;

export const addFollowersForTaskDataSchema = z.object({
  body: z.object({
    data: taskAddFollowersRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addFollowersForTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const addFollowersForTaskErrorSchema = errorResponseSchema;

export const addProjectForTaskDataSchema = z.object({
  body: z.object({
    data: taskAddProjectRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addProjectForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addProjectForTaskErrorSchema = errorResponseSchema;

export const addTagForTaskDataSchema = z.object({
  body: z.object({
    data: taskAddTagRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addTagForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const addTagForTaskErrorSchema = errorResponseSchema;

export const getDependenciesForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getDependenciesForTaskResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getDependenciesForTaskErrorSchema = errorResponseSchema;

export const getDependentsForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getDependentsForTaskResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getDependentsForTaskErrorSchema = errorResponseSchema;

export const duplicateTaskDataSchema = z.object({
  body: z.object({
    data: taskDuplicateRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const duplicateTaskResponseSchema = z.object({
  data: jobCompactSchema.optional(),
});

export const duplicateTaskErrorSchema = errorResponseSchema;

export const getProjectsForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectsForTaskResponseSchema = z.object({
  data: z.array(projectCompactSchema).optional(),
});

export const getProjectsForTaskErrorSchema = errorResponseSchema;

export const removeDependenciesForTaskDataSchema = z.object({
  body: z.object({
    data: modifyDependenciesRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeDependenciesForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeDependenciesForTaskErrorSchema = errorResponseSchema;

export const removeDependentsForTaskDataSchema = z.object({
  body: z.object({
    data: modifyDependentsRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeDependentsForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeDependentsForTaskErrorSchema = errorResponseSchema;

export const removeFollowerForTaskDataSchema = z.object({
  body: z.object({
    data: taskRemoveFollowersRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeFollowerForTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const removeFollowerForTaskErrorSchema = errorResponseSchema;

export const removeProjectForTaskDataSchema = z.object({
  body: z.object({
    data: taskRemoveProjectRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeProjectForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeProjectForTaskErrorSchema = errorResponseSchema;

export const removeTagForTaskDataSchema = z.object({
  body: z.object({
    data: taskRemoveTagRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeTagForTaskResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeTagForTaskErrorSchema = errorResponseSchema;

export const setParentForTaskDataSchema = z.object({
  body: z.object({
    data: taskSetParentRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const setParentForTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const setParentForTaskErrorSchema = errorResponseSchema;

export const getStoriesForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getStoriesForTaskResponseSchema = z.object({
  data: z.unknown().optional(),
});

export const getStoriesForTaskErrorSchema = errorResponseSchema;

export const createStoryForTaskDataSchema = z.object({
  body: z.object({
    data: storyBaseSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createStoryForTaskResponseSchema = z.object({
  data: storyResponseSchema.optional(),
});

export const createStoryForTaskErrorSchema = errorResponseSchema;

export const getSubtasksForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getSubtasksForTaskResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getSubtasksForTaskErrorSchema = errorResponseSchema;

export const createSubtaskForTaskDataSchema = z.object({
  body: z.object({
    data: taskRequestSchema.optional(),
  }),
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createSubtaskForTaskResponseSchema = z.object({
  data: taskResponseSchema.optional(),
});

export const createSubtaskForTaskErrorSchema = errorResponseSchema;

export const getTagsForTaskDataSchema = z.object({
  path: z.object({
    task_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTagsForTaskResponseSchema = z.object({
  data: z.array(tagCompactSchema).optional(),
});

export const getTagsForTaskErrorSchema = errorResponseSchema;

export const getTeamMembershipsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      team: z.string().optional(),
      user: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getTeamMembershipsResponseSchema = z.object({
  data: z.array(teamMembershipCompactSchema).optional(),
});

export const getTeamMembershipsErrorSchema = errorResponseSchema;

export const getTeamMembershipDataSchema = z.object({
  path: z.object({
    team_membership_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTeamMembershipResponseSchema = z.object({
  data: teamMembershipCompactSchema.optional(),
});

export const getTeamMembershipErrorSchema = errorResponseSchema;

export const createTeamDataSchema = z.object({
  body: z.object({
    data: teamRequestSchema.optional(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createTeamResponseSchema = z.object({
  data: teamResponseSchema.optional(),
});

export const createTeamErrorSchema = errorResponseSchema;

export const updateTeamDataSchema = z.object({
  body: z.object({
    data: teamRequestSchema.optional(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateTeamResponseSchema = z.object({
  data: teamResponseSchema.optional(),
});

export const updateTeamErrorSchema = errorResponseSchema;

export const getTeamDataSchema = z.object({
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTeamResponseSchema = z.object({
  data: teamResponseSchema.optional(),
});

export const getTeamErrorSchema = errorResponseSchema;

export const addUserForTeamDataSchema = z.object({
  body: z.object({
    data: teamAddUserRequestSchema.optional(),
  }),
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addUserForTeamResponseSchema = z.object({
  data: teamMembershipCompactSchema.optional(),
});

export const addUserForTeamErrorSchema = errorResponseSchema;

export const getProjectTemplatesForTeamDataSchema = z.object({
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectTemplatesForTeamResponseSchema = z.object({
  data: z.array(projectTemplateCompactSchema).optional(),
});

export const getProjectTemplatesForTeamErrorSchema = errorResponseSchema;

export const getProjectsForTeamDataSchema = z.object({
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      archived: z.boolean().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectsForTeamResponseSchema = z.object({
  data: z.array(projectCompactSchema).optional(),
});

export const getProjectsForTeamErrorSchema = errorResponseSchema;

export const createProjectForTeamErrorSchema = errorResponseSchema;

export const removeUserForTeamDataSchema = z.object({
  body: z.object({
    data: teamRemoveUserRequestSchema.optional(),
  }),
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeUserForTeamResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeUserForTeamErrorSchema = errorResponseSchema;

export const getTeamMembershipsForTeamDataSchema = z.object({
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTeamMembershipsForTeamResponseSchema = z.object({
  data: z.array(teamMembershipCompactSchema).optional(),
});

export const getTeamMembershipsForTeamErrorSchema = errorResponseSchema;

export const getUsersForTeamDataSchema = z.object({
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getUsersForTeamResponseSchema = z.object({
  data: z.array(userCompactSchema).optional(),
});

export const getUsersForTeamErrorSchema = errorResponseSchema;

export const getTimePeriodsDataSchema = z.object({
  query: z.object({
    end_on: z.string().optional(),
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    start_on: z.string().optional(),
    workspace: z.string(),
  }),
});

export const getTimePeriodsResponseSchema = z.object({
  data: z.array(timePeriodCompactSchema).optional(),
});

export const getTimePeriodsErrorSchema = errorResponseSchema;

export const getTimePeriodDataSchema = z.object({
  path: z.object({
    time_period_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTimePeriodResponseSchema = z.object({
  data: timePeriodResponseSchema.optional(),
});

export const getTimePeriodErrorSchema = errorResponseSchema;

export const getUserTaskListDataSchema = z.object({
  path: z.object({
    user_task_list_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getUserTaskListResponseSchema = z.object({
  data: userTaskListCompactSchema.optional(),
});

export const getUserTaskListErrorSchema = errorResponseSchema;

export const getTasksForUserTaskListDataSchema = z.object({
  path: z.object({
    user_task_list_gid: z.string(),
  }),
  query: z
    .object({
      completed_since: z.string().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTasksForUserTaskListResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const getTasksForUserTaskListErrorSchema = errorResponseSchema;

export const getUsersDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      team: z.string().optional(),
      workspace: z.string().optional(),
    })
    .optional(),
});

export const getUsersResponseSchema = z.object({
  data: z.array(userCompactSchema).optional(),
});

export const getUsersErrorSchema = errorResponseSchema;

export const getUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getUserResponseSchema = z.object({
  data: userResponseSchema.optional(),
});

export const getUserErrorSchema = errorResponseSchema;

export const getFavoritesForUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z.object({
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    resource_type: z.union([
      z.literal('portfolio'),
      z.literal('project'),
      z.literal('tag'),
      z.literal('task'),
      z.literal('user'),
      z.literal('project_template'),
    ]),
    workspace: z.string(),
  }),
});

export const getFavoritesForUserResponseSchema = z.object({
  data: z.array(asanaNamedResourceSchema).optional(),
});

export const getFavoritesForUserErrorSchema = errorResponseSchema;

export const getTeamMembershipsForUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z.object({
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    workspace: z.string(),
  }),
});

export const getTeamMembershipsForUserResponseSchema = z.object({
  data: z.array(teamMembershipCompactSchema).optional(),
});

export const getTeamMembershipsForUserErrorSchema = errorResponseSchema;

export const getTeamsForUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z.object({
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    organization: z.string(),
  }),
});

export const getTeamsForUserResponseSchema = z.object({
  data: z.array(teamCompactSchema).optional(),
});

export const getTeamsForUserErrorSchema = errorResponseSchema;

export const getUserTaskListForUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z.object({
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    workspace: z.string(),
  }),
});

export const getUserTaskListForUserResponseSchema = z.object({
  data: userTaskListCompactSchema.optional(),
});

export const getUserTaskListForUserErrorSchema = errorResponseSchema;

export const getWorkspaceMembershipsForUserDataSchema = z.object({
  path: z.object({
    user_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkspaceMembershipsForUserResponseSchema = z.object({
  data: z.array(workspaceMembershipCompactSchema).optional(),
});

export const getWorkspaceMembershipsForUserErrorSchema = errorResponseSchema;

export const getWebhooksDataSchema = z.object({
  query: z.object({
    limit: z.number().optional(),
    offset: z.string().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    resource: z.string().optional(),
    workspace: z.string(),
  }),
});

export const getWebhooksResponseSchema = z.object({
  data: z.array(webhookResponseSchema).optional(),
});

export const getWebhooksErrorSchema = errorResponseSchema;

export const createWebhookDataSchema = z.object({
  body: z.object({
    data: webhookRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createWebhookResponseSchema = z.object({
  data: webhookResponseSchema.optional(),
});

export const createWebhookErrorSchema = errorResponseSchema;

export const deleteWebhookDataSchema = z.object({
  path: z.object({
    webhook_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const deleteWebhookResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const deleteWebhookErrorSchema = errorResponseSchema;

export const getWebhookDataSchema = z.object({
  path: z.object({
    webhook_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getWebhookResponseSchema = z.object({
  data: webhookResponseSchema.optional(),
});

export const getWebhookErrorSchema = errorResponseSchema;

export const updateWebhookDataSchema = z.object({
  body: z.object({
    data: webhookUpdateRequestSchema.optional(),
  }),
  path: z.object({
    webhook_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateWebhookResponseSchema = z.object({
  data: webhookResponseSchema.optional(),
});

export const updateWebhookErrorSchema = errorResponseSchema;

export const getWorkspaceMembershipDataSchema = z.object({
  path: z.object({
    workspace_membership_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkspaceMembershipResponseSchema = z.object({
  data: workspaceMembershipResponseSchema.optional(),
});

export const getWorkspaceMembershipErrorSchema = errorResponseSchema;

export const getWorkspacesDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkspacesResponseSchema = z.object({
  data: z.array(workspaceCompactSchema).optional(),
});

export const getWorkspacesErrorSchema = errorResponseSchema;

export const getWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkspaceResponseSchema = z.object({
  data: workspaceResponseSchema.optional(),
});

export const getWorkspaceErrorSchema = errorResponseSchema;

export const updateWorkspaceDataSchema = z.object({
  body: z.object({
    data: workspaceCompactSchema.optional(),
  }),
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateWorkspaceResponseSchema = z.object({
  data: workspaceResponseSchema.optional(),
});

export const updateWorkspaceErrorSchema = errorResponseSchema;

export const addUserForWorkspaceDataSchema = z.object({
  body: z.object({
    data: workspaceAddUserRequestSchema.optional(),
  }),
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const addUserForWorkspaceResponseSchema = z.object({
  data: userBaseResponseSchema.optional(),
});

export const addUserForWorkspaceErrorSchema = errorResponseSchema;

export const getAuditLogEventsDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      actor_gid: z.string().optional(),
      actor_type: z
        .union([
          z.literal('user'),
          z.literal('asana'),
          z.literal('asana_support'),
          z.literal('anonymous'),
          z.literal('external_administrator'),
        ])
        .optional(),
      end_at: z.string().optional(),
      event_type: z.string().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      resource_gid: z.string().optional(),
      start_at: z.string().optional(),
    })
    .optional(),
});

export const auditLogEventSchema = z.object({
  actor: auditLogEventActorSchema.optional(),
  context: auditLogEventContextSchema.optional(),
  created_at: z.string().optional(),
  details: auditLogEventDetailsSchema.optional(),
  event_category: z.string().optional(),
  event_type: z.string().optional(),
  gid: z.string().optional(),
  resource: auditLogEventResourceSchema.optional(),
});

export const getAuditLogEventsErrorSchema = errorResponseSchema;

export const getCustomFieldsForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getCustomFieldsForWorkspaceResponseSchema = z.object({
  data: z.array(customFieldResponseSchema).optional(),
});

export const getCustomFieldsForWorkspaceErrorSchema = errorResponseSchema;

export const getProjectsForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      archived: z.boolean().optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectsForWorkspaceResponseSchema = z.object({
  data: z.array(projectCompactSchema).optional(),
});

export const getProjectsForWorkspaceErrorSchema = errorResponseSchema;

export const createProjectForWorkspaceErrorSchema = errorResponseSchema;

export const removeUserForWorkspaceDataSchema = z.object({
  body: z.object({
    data: workspaceRemoveUserRequestSchema.optional(),
  }),
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const removeUserForWorkspaceResponseSchema = z.object({
  data: emptyResponseSchema.optional(),
});

export const removeUserForWorkspaceErrorSchema = errorResponseSchema;

export const getTagsForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTagsForWorkspaceResponseSchema = z.object({
  data: z.array(tagCompactSchema).optional(),
});

export const getTagsForWorkspaceErrorSchema = errorResponseSchema;

export const createTagForWorkspaceDataSchema = z.object({
  body: z.object({
    data: tagResponseSchema.optional(),
  }),
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createTagForWorkspaceResponseSchema = z.object({
  data: tagResponseSchema.optional(),
});

export const createTagForWorkspaceErrorSchema = errorResponseSchema;

export const searchTasksForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      'assigned_by.any': z.string().optional(),
      'assigned_by.not': z.string().optional(),
      'assignee.any': z.string().optional(),
      'assignee.not': z.string().optional(),
      'commented_on_by.not': z.string().optional(),
      completed: z.boolean().optional(),
      'completed_at.after': z.string().optional(),
      'completed_at.before': z.string().optional(),
      completed_on: z.string().optional().nullable(),
      'completed_on.after': z.string().optional(),
      'completed_on.before': z.string().optional(),
      'created_at.after': z.string().optional(),
      'created_at.before': z.string().optional(),
      'created_by.any': z.string().optional(),
      'created_by.not': z.string().optional(),
      created_on: z.string().optional().nullable(),
      'created_on.after': z.string().optional(),
      'created_on.before': z.string().optional(),
      'due_at.after': z.string().optional(),
      'due_at.before': z.string().optional(),
      due_on: z.string().optional().nullable(),
      'due_on.after': z.string().optional(),
      'due_on.before': z.string().optional(),
      'followers.not': z.string().optional(),
      has_attachment: z.boolean().optional(),
      is_blocked: z.boolean().optional(),
      is_blocking: z.boolean().optional(),
      is_subtask: z.boolean().optional(),
      'liked_by.not': z.string().optional(),
      'modified_at.after': z.string().optional(),
      'modified_at.before': z.string().optional(),
      modified_on: z.string().optional().nullable(),
      'modified_on.after': z.string().optional(),
      'modified_on.before': z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      'portfolios.any': z.string().optional(),
      'projects.all': z.string().optional(),
      'projects.any': z.string().optional(),
      'projects.not': z.string().optional(),
      resource_subtype: z.union([z.literal('default_task'), z.literal('milestone')]).optional(),
      'sections.all': z.string().optional(),
      'sections.any': z.string().optional(),
      'sections.not': z.string().optional(),
      sort_ascending: z.boolean().optional(),
      sort_by: z
        .union([
          z.literal('due_date'),
          z.literal('created_at'),
          z.literal('completed_at'),
          z.literal('likes'),
          z.literal('modified_at'),
        ])
        .optional(),
      start_on: z.string().optional().nullable(),
      'start_on.after': z.string().optional(),
      'start_on.before': z.string().optional(),
      'tags.all': z.string().optional(),
      'tags.any': z.string().optional(),
      'tags.not': z.string().optional(),
      'teams.any': z.string().optional(),
      text: z.string().optional(),
    })
    .optional(),
});

export const searchTasksForWorkspaceResponseSchema = z.object({
  data: z.array(taskCompactSchema).optional(),
});

export const searchTasksForWorkspaceErrorSchema = errorResponseSchema;

export const getTeamsForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getTeamsForWorkspaceResponseSchema = z.object({
  data: z.array(teamCompactSchema).optional(),
});

export const getTeamsForWorkspaceErrorSchema = errorResponseSchema;

export const typeaheadForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z.object({
    count: z.number().optional(),
    opt_fields: z.array(z.string()).optional(),
    opt_pretty: z.boolean().optional(),
    query: z.string().optional(),
    resource_type: z.union([
      z.literal('custom_field'),
      z.literal('project'),
      z.literal('project_template'),
      z.literal('portfolio'),
      z.literal('tag'),
      z.literal('task'),
      z.literal('user'),
    ]),
    type: z
      .union([
        z.literal('custom_field'),
        z.literal('portfolio'),
        z.literal('project'),
        z.literal('tag'),
        z.literal('task'),
        z.literal('user'),
      ])
      .optional(),
  }),
});

export const typeaheadForWorkspaceResponseSchema = z.object({
  data: z.array(asanaNamedResourceSchema).optional(),
});

export const typeaheadForWorkspaceErrorSchema = errorResponseSchema;

export const getUsersForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getUsersForWorkspaceResponseSchema = z.object({
  data: z.array(userCompactSchema).optional(),
});

export const getUsersForWorkspaceErrorSchema = errorResponseSchema;

export const getWorkspaceMembershipsForWorkspaceDataSchema = z.object({
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const getWorkspaceMembershipsForWorkspaceResponseSchema = z.object({
  data: z.array(workspaceMembershipCompactSchema).optional(),
});

export const getWorkspaceMembershipsForWorkspaceErrorSchema = z.unknown();

export const attachmentBaseSchema = attachmentCompactSchema;

export const customFieldSettingBaseSchema = customFieldSettingCompactSchema;

export const goalMembershipBaseSchema = goalMembershipCompactSchema;

export const jobBaseSchema = jobCompactSchema;

export const jobResponseSchema = jobCompactSchema;

export const organizationExportBaseSchema = organizationExportCompactSchema;

export const portfolioMembershipBaseSchema = portfolioMembershipCompactSchema;

export const projectBaseSchema = projectCompactSchema.and(
  z.object({
    archived: z.boolean().optional(),
    color: z
      .union([
        z.literal('dark-pink'),
        z.literal('dark-green'),
        z.literal('dark-blue'),
        z.literal('dark-red'),
        z.literal('dark-teal'),
        z.literal('dark-brown'),
        z.literal('dark-orange'),
        z.literal('dark-purple'),
        z.literal('dark-warm-gray'),
        z.literal('light-pink'),
        z.literal('light-green'),
        z.literal('light-blue'),
        z.literal('light-red'),
        z.literal('light-teal'),
        z.literal('light-brown'),
        z.literal('light-orange'),
        z.literal('light-purple'),
        z.literal('light-warm-gray'),
      ])
      .optional()
      .nullable(),
    created_at: z.string().optional(),
    current_status: projectStatusResponseSchema.optional().nullable(),
    current_status_update: statusUpdateCompactSchema.optional().nullable(),
    custom_field_settings: z.array(customFieldSettingResponseSchema).optional(),
    default_view: z
      .union([z.literal('list'), z.literal('board'), z.literal('calendar'), z.literal('timeline')])
      .optional(),
    due_date: z.string().optional().nullable(),
    due_on: z.string().optional().nullable(),
    html_notes: z.string().optional(),
    is_template: z.boolean().optional(),
    members: z.array(userCompactSchema).optional(),
    modified_at: z.string().optional(),
    notes: z.string().optional(),
    public: z.boolean().optional(),
    start_on: z.string().optional().nullable(),
    workspace: workspaceCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const projectMembershipBaseSchema = projectMembershipCompactSchema;

export const projectRequestSchema = projectBaseSchema.and(
  z.object({
    custom_fields: z.record(z.string()).optional(),
    followers: z.string().optional(),
    owner: z.string().optional().nullable(),
    team: z.string().optional(),
  }),
);

export const projectResponseSchema = projectBaseSchema.and(
  z.object({
    completed: z.boolean().optional(),
    completed_at: z.string().optional().nullable(),
    completed_by: userCompactSchema.optional().nullable(),
    created_from_template: projectTemplateCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    custom_fields: z.array(customFieldCompactSchema).optional(),
    followers: z.array(userCompactSchema).optional(),
    icon: z
      .union([
        z.literal('list'),
        z.literal('board'),
        z.literal('timeline'),
        z.literal('calendar'),
        z.literal('rocket'),
        z.literal('people'),
        z.literal('graph'),
        z.literal('star'),
        z.literal('bug'),
        z.literal('light_bulb'),
        z.literal('globe'),
        z.literal('gear'),
        z.literal('notebook'),
        z.literal('computer'),
        z.literal('check'),
        z.literal('target'),
        z.literal('html'),
        z.literal('megaphone'),
        z.literal('chat_bubbles'),
        z.literal('briefcase'),
        z.literal('page_layout'),
        z.literal('mountain_flag'),
        z.literal('puzzle'),
        z.literal('presentation'),
        z.literal('line_and_symbols'),
        z.literal('speed_dial'),
        z.literal('ribbon'),
        z.literal('shoe'),
        z.literal('shopping_basket'),
        z.literal('map'),
        z.literal('ticket'),
        z.literal('coins'),
      ])
      .optional()
      .nullable(),
    owner: userCompactSchema.optional().nullable(),
    permalink_url: z.string().optional(),
    project_brief: projectBriefCompactSchema.and(z.record(z.unknown())).optional().nullable(),
    team: teamCompactSchema.and(z.record(z.unknown())).optional(),
  }),
);

export const projectStatusRequestSchema = projectStatusBaseSchema;

export const sectionBaseSchema = sectionCompactSchema;

export const teamMembershipBaseSchema = teamMembershipCompactSchema;

export const userTaskListBaseSchema = userTaskListCompactSchema;

export const workspaceMembershipBaseSchema = workspaceMembershipCompactSchema;

export const createAttachmentForObjectResponseSchema = z.object({
  data: attachmentResponseSchema.optional(),
});

export const createBatchRequestDataSchema = z.object({
  body: z.object({
    data: batchRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createCustomFieldDataSchema = z.object({
  body: z
    .object({
      data: customFieldRequestSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const getEventsResponseSchema = z.object({
  data: z.array(eventResponseSchema).optional(),
  has_more: z.boolean().optional(),
  sync: z.string().optional(),
});

export const updateGoalRelationshipDataSchema = z.object({
  body: z.object({
    data: goalRelationshipRequestSchema.optional(),
  }),
  path: z.object({
    goal_relationship_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createGoalResponseSchema = z.object({
  data: goalResponseSchema.optional(),
});

export const createPortfolioDataSchema = z.object({
  body: z.object({
    data: portfolioRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createPortfolioResponseSchema = z.object({
  data: portfolioResponseSchema.optional(),
});

export const updateProjectBriefDataSchema = z.object({
  body: z.object({
    data: projectBriefRequestSchema.optional(),
  }),
  path: z.object({
    project_brief_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectDataSchema = z.object({
  body: z.object({
    data: projectRequestSchema.optional(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const getProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const updateProjectDataSchema = z.object({
  body: z.object({
    data: projectRequestSchema.optional(),
  }),
  path: z.object({
    project_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const updateProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const addFollowersForProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const addMembersForProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const removeFollowersForProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const removeMembersForProjectResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const getStoryResponseSchema = z.object({
  data: storyResponseSchema.optional(),
});

export const createProjectForTeamDataSchema = z.object({
  body: z.object({
    data: projectRequestSchema.optional(),
  }),
  path: z.object({
    team_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectForTeamResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});

export const getAuditLogEventsResponseSchema = z.object({
  data: z.array(auditLogEventSchema).optional(),
});

export const createProjectForWorkspaceDataSchema = z.object({
  body: z.object({
    data: projectRequestSchema.optional(),
  }),
  path: z.object({
    workspace_gid: z.string(),
  }),
  query: z
    .object({
      opt_fields: z.array(z.string()).optional(),
      opt_pretty: z.boolean().optional(),
    })
    .optional(),
});

export const createProjectForWorkspaceResponseSchema = z.object({
  data: projectResponseSchema.optional(),
});
