// This file is auto-generated by @hey-api/openapi-ts

export type AddCustomFieldSettingRequest = {
  /**
   * The custom field to associate with this container.
   */
  custom_field: string;
  /**
   * A gid of a Custom Field Setting on this container, after which the new Custom Field Setting will be added.  `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_after?: string;
  /**
   * A gid of a Custom Field Setting on this container, before which the new Custom Field Setting will be added.  `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_before?: string;
  /**
   * Whether this field should be considered important to this container (for instance, to display in the list view of items in the container).
   */
  is_important?: boolean;
};

export type AddFollowersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  followers: string;
};

export type AddMembersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  members: string;
};

export type AsanaNamedResource = AsanaResource & {
  /**
   * The name of the object.
   */
  name?: string;
};

/**
 * A generic Asana Resource, containing a globally unique identifier.
 */
export type AsanaResource = {
  /**
   * Globally unique identifier of the resource, as a string.
   */
  readonly gid?: string;
  /**
   * The base type of this resource.
   */
  readonly resource_type?: string;
};

export type AttachmentBase = AttachmentCompact;

export type AttachmentCompact = AsanaResource & {
  /**
   * The name of the file.
   */
  readonly name?: string;
  /**
   * The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `onedrive`, `box`, `vimeo`, and `external`.
   */
  resource_subtype?: string;
};

export type AttachmentRequest = {
  /**
   * *Optional*. Only relevant for external attachments with a parent task. A boolean indicating whether the current app should be connected with the attachment for the purposes of showing an app components widget. Requires the app to have been added to a project the parent task is in.
   *
   */
  connect_to_app?: boolean;
  /**
   * Required for `asana` attachments.
   *
   */
  file?: Blob | File;
  /**
   * The name of the external resource being attached. Required for attachments of type `external`.
   *
   */
  name?: string;
  /**
   * Required identifier of the parent task, project, or project_brief, as a string.
   *
   */
  parent?: string;
  /**
   * The type of the attachment. Must be one of the given values. If not specified, a file attachment of type `asana` will be assumed. Note that if the value of `resource_subtype` is `external`, a `parent`, `name`, and `url` must also be provided.
   *
   */
  resource_subtype?: 'asana' | 'dropbox' | 'gdrive' | 'onedrive' | 'box' | 'vimeo' | 'external';
  /**
   * The URL of the external resource being attached. Required for attachments of type `external`.
   *
   */
  url?: string;
};

/**
 * The type of the attachment. Must be one of the given values. If not specified, a file attachment of type `asana` will be assumed. Note that if the value of `resource_subtype` is `external`, a `parent`, `name`, and `url` must also be provided.
 *
 */
export type resource_subtype = 'asana' | 'dropbox' | 'gdrive' | 'onedrive' | 'box' | 'vimeo' | 'external';

export type AttachmentResponse = AttachmentCompact & {
  /**
   * Whether the attachment is connected to the app making the request for the purposes of showing an app components widget. Only present when the `resource_subtype` is `external` or `gdrive`.
   */
  readonly connected_to_app?: boolean;
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * The URL containing the content of the attachment.
   * *Note:* May be null if the attachment is hosted by [Box](https://www.box.com/) and will be null if the attachment is a Video Message hosted by [Vimeo](https://vimeo.com/). If present, this URL may only be valid for two minutes from the time of retrieval. You should avoid persisting this URL somewhere and just refresh it on demand to ensure you do not keep stale URLs.
   */
  readonly download_url?: string | null;
  /**
   * The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `box`, and `vimeo`.
   */
  readonly host?: string;
  parent?: TaskCompact & {
    /**
     * The resource subtype of the parent resource that the filter applies to.
     */
    resource_subtype?: string | null;
  };
  readonly permanent_url?: string | null;
  /**
   * The size of the attachment in bytes. Only present when the `resource_subtype` is `asana`.
   */
  readonly size?: number;
  /**
   * The URL where the attachment can be viewed, which may be friendlier to users in a browser than just directing them to a raw file. May be null if no view URL exists for the service.
   */
  readonly view_url?: string | null;
};

/**
 * An object representing a single event within an Asana domain.
 *
 * Every audit log event is comprised of an `event_type`, `actor`, `resource`, and `context`. Some events will include additional metadata about the event under `details`. See our [currently supported list of events](/docs/supported-auditlogevents) for more details.
 */
export type AuditLogEvent = {
  actor?: AuditLogEventActor;
  context?: AuditLogEventContext;
  /**
   * The time the event was created.
   */
  created_at?: string;
  details?: AuditLogEventDetails;
  /**
   * The category that this `event_type` belongs to.
   */
  event_category?: string;
  /**
   * The type of the event.
   */
  event_type?: string;
  /**
   * Globally unique identifier of the `AuditLogEvent`, as a string.
   */
  gid?: string;
  resource?: AuditLogEventResource;
};

/**
 * The entity that triggered the event. Will typically be a user.
 */
export type AuditLogEventActor = {
  /**
   * The type of actor.
   * Can be one of `user`, `asana`, `asana_support`, `anonymous`, or `external_administrator`.
   */
  actor_type?: 'user' | 'asana' | 'asana_support' | 'anonymous' | 'external_administrator';
  /**
   * The email of the actor, if it is a user.
   */
  email?: string;
  /**
   * Globally unique identifier of the actor, if it is a user.
   */
  gid?: string;
  /**
   * The name of the actor, if it is a user.
   */
  name?: string;
};

/**
 * The type of actor.
 * Can be one of `user`, `asana`, `asana_support`, `anonymous`, or `external_administrator`.
 */
export type actor_type = 'user' | 'asana' | 'asana_support' | 'anonymous' | 'external_administrator';

/**
 * The context from which this event originated.
 */
export type AuditLogEventContext = {
  /**
   * The authentication method used in the context of an API request.
   * Only present if the `context_type` is `api`. Can be one of `cookie`, `oauth`, `personal_access_token`, or `service_account`.
   */
  api_authentication_method?: 'cookie' | 'oauth' | 'personal_access_token' | 'service_account';
  /**
   * The IP address of the client that initiated the event, if applicable.
   */
  client_ip_address?: string;
  /**
   * The type of context.
   * Can be one of `web`, `desktop`, `mobile`, `asana_support`, `asana`, `email`, or `api`.
   */
  context_type?: 'web' | 'desktop' | 'mobile' | 'asana_support' | 'asana' | 'email' | 'api';
  /**
   * The name of the OAuth App that initiated the event.
   * Only present if the `api_authentication_method` is `oauth`.
   */
  oauth_app_name?: string;
  /**
   * The user agent of the client that initiated the event, if applicable.
   */
  user_agent?: string;
};

/**
 * The authentication method used in the context of an API request.
 * Only present if the `context_type` is `api`. Can be one of `cookie`, `oauth`, `personal_access_token`, or `service_account`.
 */
export type api_authentication_method = 'cookie' | 'oauth' | 'personal_access_token' | 'service_account';

/**
 * The type of context.
 * Can be one of `web`, `desktop`, `mobile`, `asana_support`, `asana`, `email`, or `api`.
 */
export type context_type = 'web' | 'desktop' | 'mobile' | 'asana_support' | 'asana' | 'email' | 'api';

/**
 * Event specific details. The schema will vary depending on the `event_type`.
 */
export type AuditLogEventDetails = {
  [key: string]: unknown;
};

/**
 * The primary object that was affected by this event.
 */
export type AuditLogEventResource = {
  /**
   * The email of the resource, if applicable.
   */
  email?: string;
  /**
   * Globally unique identifier of the resource.
   */
  gid?: string;
  /**
   * The name of the resource.
   */
  name?: string;
  /**
   * The subtype of resource. Most resources will not have a subtype.
   */
  resource_subtype?: string;
  /**
   * The type of resource.
   */
  resource_type?: string;
};

/**
 * A request object for use in a batch request.
 */
export type BatchRequest = {
  actions?: Array<BatchRequestAction>;
};

/**
 * An action object for use in a batch request.
 */
export type BatchRequestAction = {
  /**
   * For `GET` requests, this should be a map of query parameters you would have normally passed in the URL. Options and pagination are not accepted here; put them in `options` instead. For `POST`, `PATCH`, and `PUT` methods, this should be the content you would have normally put in the data field of the body.
   */
  data?: {
    [key: string]: unknown;
  };
  /**
   * The HTTP method you wish to emulate for the action.
   */
  method: 'get' | 'post' | 'put' | 'delete' | 'patch' | 'head';
  /**
   * Pagination (`limit` and `offset`) and output options (`fields` or `expand`) for the action. “Pretty” JSON output is not an available option on individual actions; if you want pretty output, specify that option on the parent request.
   */
  options?: {
    /**
     * The fields to retrieve in the request.
     */
    fields?: Array<string>;
    /**
     * Pagination limit for the request.
     */
    limit?: number;
    /**
     * Pagination offset for the request.
     */
    offset?: number;
  };
  /**
   * The path of the desired endpoint relative to the API’s base URL. Query parameters are not accepted here; put them in `data` instead.
   */
  relative_path: string;
};

/**
 * The HTTP method you wish to emulate for the action.
 */
export type method = 'get' | 'post' | 'put' | 'delete' | 'patch' | 'head';

/**
 * A response object returned from a batch request.
 */
export type BatchResponse = {
  /**
   * The JSON body that the invoked endpoint returned.
   */
  body?: {
    [key: string]: unknown;
  };
  /**
   * A map of HTTP headers specific to this result. This is primarily used for returning a `Location` header to accompany a `201 Created` result.  The parent HTTP response will contain all common headers.
   */
  headers?: {
    [key: string]: unknown;
  };
  /**
   * The HTTP status code that the invoked endpoint returned.
   */
  status_code?: number;
};

export type CustomFieldBase = CustomFieldCompact & {
  /**
   * *Conditional*. A unique identifier to associate this field with the template source of truth.
   */
  readonly asana_created_field?:
    | (
        | 'a_v_requirements'
        | 'account_name'
        | 'actionable'
        | 'align_shipping_link'
        | 'align_status'
        | 'allotted_time'
        | 'appointment'
        | 'approval_stage'
        | 'approved'
        | 'article_series'
        | 'board_committee'
        | 'browser'
        | 'campaign_audience'
        | 'campaign_project_status'
        | 'campaign_regions'
        | 'channel_primary'
        | 'client_topic_type'
        | 'complete_by'
        | 'contact'
        | 'contact_email_address'
        | 'content_channels'
        | 'content_channels_needed'
        | 'content_stage'
        | 'content_type'
        | 'contract'
        | 'contract_status'
        | 'cost'
        | 'creation_stage'
        | 'creative_channel'
        | 'creative_needed'
        | 'creative_needs'
        | 'data_sensitivity'
        | 'deal_size'
        | 'delivery_appt'
        | 'delivery_appt_date'
        | 'department'
        | 'department_responsible'
        | 'design_request_needed'
        | 'design_request_type'
        | 'discussion_category'
        | 'do_this_task'
        | 'editorial_content_status'
        | 'editorial_content_tag'
        | 'editorial_content_type'
        | 'effort'
        | 'effort_level'
        | 'est_completion_date'
        | 'estimated_time'
        | 'estimated_value'
        | 'expected_cost'
        | 'external_steps_needed'
        | 'favorite_idea'
        | 'feedback_type'
        | 'financial'
        | 'funding_amount'
        | 'grant_application_process'
        | 'hiring_candidate_status'
        | 'idea_status'
        | 'ids_link'
        | 'ids_patient_link'
        | 'implementation_stage'
        | 'insurance'
        | 'interview_area'
        | 'interview_question_score'
        | 'itero_scan_link'
        | 'job_s_applied_to'
        | 'lab'
        | 'launch_status'
        | 'lead_status'
        | 'localization_language'
        | 'localization_market_team'
        | 'localization_status'
        | 'meeting_minutes'
        | 'meeting_needed'
        | 'minutes'
        | 'mrr'
        | 'must_localize'
        | 'name_of_foundation'
        | 'need_to_follow_up'
        | 'next_appointment'
        | 'next_steps_sales'
        | 'num_people'
        | 'number_of_user_reports'
        | 'office_location'
        | 'onboarding_activity'
        | 'owner'
        | 'participants_needed'
        | 'patient_date_of_birth'
        | 'patient_email'
        | 'patient_phone'
        | 'patient_status'
        | 'phone_number'
        | 'planning_category'
        | 'point_of_contact'
        | 'position'
        | 'post_format'
        | 'prescription'
        | 'priority'
        | 'priority_level'
        | 'product'
        | 'product_stage'
        | 'progress'
        | 'project_size'
        | 'project_status'
        | 'proposed_budget'
        | 'publish_status'
        | 'reason_for_scan'
        | 'referral'
        | 'request_type'
        | 'research_status'
        | 'responsible_department'
        | 'responsible_team'
        | 'risk_assessment_status'
        | 'room_name'
        | 'sales_counterpart'
        | 'sentiment'
        | 'shipping_link'
        | 'social_channels'
        | 'stage'
        | 'status'
        | 'status_design'
        | 'status_of_initiative'
        | 'system_setup'
        | 'task_progress'
        | 'team'
        | 'team_marketing'
        | 'team_responsible'
        | 'time_it_takes_to_complete_tasks'
        | 'timeframe'
        | 'treatment_type'
        | 'type_work_requests_it'
        | 'use_agency'
        | 'user_name'
        | 'vendor_category'
        | 'vendor_type'
        | 'word_count'
      )
    | null;
  /**
   * ISO 4217 currency code to format this custom field. This will be null if the `format` is not `currency`.
   */
  currency_code?: string | null;
  /**
   * This is the string that appears next to the custom field value. This will be null if the `format` is not `custom`.
   */
  custom_label?: string | null;
  /**
   * Only relevant for custom fields with `custom` format. This depicts where to place the custom label. This will be null if the `format` is not `custom`.
   */
  custom_label_position?: 'prefix' | 'suffix';
  /**
   * [Opt In](/docs/input-output-options). The description of the custom field.
   */
  description?: string;
  /**
   * *Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/docs/create-an-enum-option).
   */
  enum_options?: Array<EnumOption>;
  /**
   * The format of this custom field.
   */
  format?: 'currency' | 'identifier' | 'percentage' | 'custom' | 'none';
  /**
   * *Conditional*. This flag describes whether a follower of a task with this field should receive inbox notifications from changes to this field.
   */
  has_notifications_enabled?: boolean;
  /**
   * This flag describes whether this custom field is available to every container in the workspace. Before project-specific custom fields, this field was always true.
   */
  readonly is_global_to_workspace?: boolean;
  /**
   * Only relevant for custom fields of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive.
   * For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.
   * The identifier format will always have a precision of 0.
   */
  precision?: number;
};

/**
 * *Conditional*. A unique identifier to associate this field with the template source of truth.
 */
export type asana_created_field =
  | 'a_v_requirements'
  | 'account_name'
  | 'actionable'
  | 'align_shipping_link'
  | 'align_status'
  | 'allotted_time'
  | 'appointment'
  | 'approval_stage'
  | 'approved'
  | 'article_series'
  | 'board_committee'
  | 'browser'
  | 'campaign_audience'
  | 'campaign_project_status'
  | 'campaign_regions'
  | 'channel_primary'
  | 'client_topic_type'
  | 'complete_by'
  | 'contact'
  | 'contact_email_address'
  | 'content_channels'
  | 'content_channels_needed'
  | 'content_stage'
  | 'content_type'
  | 'contract'
  | 'contract_status'
  | 'cost'
  | 'creation_stage'
  | 'creative_channel'
  | 'creative_needed'
  | 'creative_needs'
  | 'data_sensitivity'
  | 'deal_size'
  | 'delivery_appt'
  | 'delivery_appt_date'
  | 'department'
  | 'department_responsible'
  | 'design_request_needed'
  | 'design_request_type'
  | 'discussion_category'
  | 'do_this_task'
  | 'editorial_content_status'
  | 'editorial_content_tag'
  | 'editorial_content_type'
  | 'effort'
  | 'effort_level'
  | 'est_completion_date'
  | 'estimated_time'
  | 'estimated_value'
  | 'expected_cost'
  | 'external_steps_needed'
  | 'favorite_idea'
  | 'feedback_type'
  | 'financial'
  | 'funding_amount'
  | 'grant_application_process'
  | 'hiring_candidate_status'
  | 'idea_status'
  | 'ids_link'
  | 'ids_patient_link'
  | 'implementation_stage'
  | 'insurance'
  | 'interview_area'
  | 'interview_question_score'
  | 'itero_scan_link'
  | 'job_s_applied_to'
  | 'lab'
  | 'launch_status'
  | 'lead_status'
  | 'localization_language'
  | 'localization_market_team'
  | 'localization_status'
  | 'meeting_minutes'
  | 'meeting_needed'
  | 'minutes'
  | 'mrr'
  | 'must_localize'
  | 'name_of_foundation'
  | 'need_to_follow_up'
  | 'next_appointment'
  | 'next_steps_sales'
  | 'num_people'
  | 'number_of_user_reports'
  | 'office_location'
  | 'onboarding_activity'
  | 'owner'
  | 'participants_needed'
  | 'patient_date_of_birth'
  | 'patient_email'
  | 'patient_phone'
  | 'patient_status'
  | 'phone_number'
  | 'planning_category'
  | 'point_of_contact'
  | 'position'
  | 'post_format'
  | 'prescription'
  | 'priority'
  | 'priority_level'
  | 'product'
  | 'product_stage'
  | 'progress'
  | 'project_size'
  | 'project_status'
  | 'proposed_budget'
  | 'publish_status'
  | 'reason_for_scan'
  | 'referral'
  | 'request_type'
  | 'research_status'
  | 'responsible_department'
  | 'responsible_team'
  | 'risk_assessment_status'
  | 'room_name'
  | 'sales_counterpart'
  | 'sentiment'
  | 'shipping_link'
  | 'social_channels'
  | 'stage'
  | 'status'
  | 'status_design'
  | 'status_of_initiative'
  | 'system_setup'
  | 'task_progress'
  | 'team'
  | 'team_marketing'
  | 'team_responsible'
  | 'time_it_takes_to_complete_tasks'
  | 'timeframe'
  | 'treatment_type'
  | 'type_work_requests_it'
  | 'use_agency'
  | 'user_name'
  | 'vendor_category'
  | 'vendor_type'
  | 'word_count';

/**
 * Only relevant for custom fields with `custom` format. This depicts where to place the custom label. This will be null if the `format` is not `custom`.
 */
export type custom_label_position = 'prefix' | 'suffix';

/**
 * The format of this custom field.
 */
export type format = 'currency' | 'identifier' | 'percentage' | 'custom' | 'none';

export type CustomFieldCompact = AsanaResource & {
  /**
   * *Conditional*. Only relevant for custom fields of type `date`. This object reflects the chosen date (and optionally, time) value of a `date` custom field. If no date is selected, the value of `date_value` will be `null`.
   */
  date_value?: {
    /**
     * A string representing the date in YYYY-MM-DD format.
     */
    date?: string;
    /**
     * A string representing the date in ISO 8601 format. If no time value is selected, the value of `date-time` will be `null`.
     */
    date_time?: string;
  };
  /**
   * A string representation for the value of the custom field. Integrations that don't require the underlying type should use this field to read values. Using this field will future-proof an app against new custom field types.
   */
  readonly display_value?: string | null;
  /**
   * *Conditional*. Determines if the custom field is enabled or not.
   */
  enabled?: boolean;
  /**
   * *Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/docs/create-an-enum-option).
   */
  enum_options?: Array<EnumOption>;
  enum_value?: EnumOption & {
    [key: string]: unknown;
  };
  /**
   * *Conditional*. Only relevant for custom fields of type `multi_enum`. This object is the chosen values of a `multi_enum` custom field.
   */
  multi_enum_values?: Array<EnumOption>;
  /**
   * The name of the custom field.
   */
  name?: string;
  /**
   * *Conditional*. This number is the value of a `number` custom field.
   */
  number_value?: number;
  /**
   * The type of the custom field. Must be one of the given values.
   *
   */
  resource_subtype?: 'text' | 'enum' | 'multi_enum' | 'number' | 'date' | 'people';
  /**
   * *Conditional*. This string is the value of a `text` custom field.
   */
  text_value?: string;
  /**
   * *Deprecated: new integrations should prefer the resource_subtype field.* The type of the custom field. Must be one of the given values.
   *
   */
  readonly type?: 'text' | 'enum' | 'multi_enum' | 'number';
};

/**
 * The type of the custom field. Must be one of the given values.
 *
 */
export type resource_subtype2 = 'text' | 'enum' | 'multi_enum' | 'number' | 'date' | 'people';

/**
 * *Deprecated: new integrations should prefer the resource_subtype field.* The type of the custom field. Must be one of the given values.
 *
 */
export type type = 'text' | 'enum' | 'multi_enum' | 'number';

export type CustomFieldRequest = CustomFieldBase & {
  /**
   * *Conditional*. Only relevant for custom fields of type `people`. This array of user GIDs reflects the users to be written to a `people` custom field. Note that *write* operations will replace existing users (if any) in the custom field with the users specified in this array.
   */
  people_value?: Array<string>;
  /**
   * *Create-Only* The workspace to create a custom field in.
   */
  workspace: string;
};

export type CustomFieldResponse = CustomFieldBase & {
  created_by?: UserCompact | null;
  /**
   * *Conditional*. Only relevant for custom fields of type `people`. This array of [compact user](/docs/user-compact) objects reflects the values of a `people` custom field.
   */
  people_value?: Array<UserCompact>;
};

export type CustomFieldSettingBase = CustomFieldSettingCompact;

export type CustomFieldSettingCompact = AsanaResource & {
  [key: string]: unknown;
};

export type CustomFieldSettingResponse = CustomFieldSettingCompact & {
  custom_field?: CustomFieldResponse & {
    [key: string]: unknown;
  };
  /**
   * `is_important` is used in the Asana web application to determine if this custom field is displayed in the list/grid view of a project or portfolio.
   */
  readonly is_important?: boolean;
  parent?: ProjectCompact & {
    [key: string]: unknown;
  };
  project?: ProjectCompact & {
    [key: string]: unknown;
  };
};

export type DateVariableCompact = {
  /**
   * The description of what the date variable is used for when instantiating a project.
   */
  readonly description?: string;
  /**
   * Globally unique identifier of the date field in the project template. A value of `1` refers to the project start date, while `2` refers to the project due date.
   */
  readonly gid?: string;
  /**
   * The name of the date variable.
   */
  readonly name?: string;
};

export type DateVariableRequest = {
  /**
   * Globally unique identifier of the date field in the project template. A value of `1` refers to the project start date, while `2` refers to the project due date.
   */
  gid?: string;
  /**
   * The date with which the date variable should be replaced when instantiating a project. This takes a date with `YYYY-MM-DD` format.
   */
  value?: string | null;
};

/**
 * An empty object. Some endpoints do not return an object on success. The success is conveyed through a 2-- status code and returning an empty object.
 */
export type EmptyResponse = {
  [key: string]: unknown;
};

export type EnumOption = AsanaResource & {
  /**
   * The color of the enum option. Defaults to ‘none’.
   */
  color?: string;
  /**
   * Whether or not the enum option is a selectable value for the custom field.
   */
  enabled?: boolean;
  /**
   * The name of the enum option.
   */
  name?: string;
};

export type EnumOptionBase = EnumOption;

export type EnumOptionInsertRequest = {
  /**
   * An existing enum option within this custom field after which the new enum option should be inserted. Cannot be provided together with before_enum_option.
   */
  after_enum_option?: string;
  /**
   * An existing enum option within this custom field before which the new enum option should be inserted. Cannot be provided together with after_enum_option.
   */
  before_enum_option?: string;
  /**
   * The gid of the enum option to relocate.
   */
  enum_option: string;
};

export type EnumOptionRequest = EnumOption & {
  /**
   * An existing enum option within this custom field after which the new enum option should be inserted. Cannot be provided together with before_enum_option.
   */
  insert_after?: string;
  /**
   * An existing enum option within this custom field before which the new enum option should be inserted. Cannot be provided together with after_enum_option.
   */
  insert_before?: string;
};

export type Error = {
  /**
   * Additional information directing developers to resources on how to address and fix the problem, if available.
   */
  readonly help?: string;
  /**
   * Message providing more detail about the error that occurred, if available.
   */
  readonly message?: string;
  /**
   * *500 errors only*. A unique error phrase which can be used when contacting developer support to help identify the exact occurrence of the problem in Asana’s logs.
   */
  readonly phrase?: string;
};

/**
 * Sadly, sometimes requests to the API are not successful. Failures can
 * occur for a wide range of reasons. In all cases, the API should return
 * an HTTP Status Code that indicates the nature of the failure,
 * with a response body in JSON format containing additional information.
 *
 *
 * In the event of a server error the response body will contain an error
 * phrase. These phrases are automatically generated using the
 * [node-asana-phrase
 * library](https://github.com/Asana/node-asana-phrase) and can be used by
 * Asana support to quickly look up the incident that caused the server
 * error.
 */
export type ErrorResponse = {
  errors?: Array<Error>;
};

/**
 * An *event* is an object representing a change to a resource that was
 * observed by an event subscription or delivered asynchronously to
 * the target location of an active webhook.
 *
 * The event may be triggered by a different `user` than the
 * subscriber. For example, if user A subscribes to a task and user B
 * modified it, the event’s user will be user B. Note: Some events
 * are generated by the system, and will have `null` as the user. API
 * consumers should make sure to handle this case.
 *
 * The `resource` that triggered the event may be different from the one
 * that the events were requested for or the webhook is subscribed to. For
 * example, a subscription to a project will contain events for tasks
 * contained within the project.
 *
 * **Note:** pay close attention to the relationship between the fields
 * `Event.action` and `Event.change.action`.
 * `Event.action` represents the action taken on the resource
 * itself, and `Event.change.action` represents how the information
 * within the resource's fields have been modified.
 *
 * For instance, consider these scenarios:
 *
 *
 * * When at task is added to a project, `Event.action` will be
 * `added`, `Event.parent` will be an object with the `id` and
 * `type` of the project, and there will be no `change` field.
 *
 *
 * * When an assignee is set on the task, `Event.parent` will be
 * `null`, `Event.action` will be `changed`,
 * `Event.change.action` will be `changed`, and `new_value` will
 * be an object with the user's `id` and `type`.
 *
 *
 * * When a collaborator is added to the task, `Event.parent` will
 * be `null`, `Event.action` will be `changed`,
 * `Event.change.action` will be `added`, and `added_value` will be
 * an object with the user's `id` and `type`.
 */
export type EventResponse = {
  /**
   * The type of action taken on the **resource** that triggered the event.  This can be one of `changed`, `added`, `removed`, `deleted`, or `undeleted` depending on the nature of the event.
   */
  readonly action?: string;
  /**
   * Information about the type of change that has occurred. This field is only present when the value of the property `action`, describing the action taken on the **resource**, is `changed`.
   */
  readonly change?: {
    /**
     * The type of action taken on the **field** which has been changed.  This can be one of `changed`, `added`, or `removed` depending on the nature of the change.
     */
    readonly action?: string;
    /**
     * *Conditional.* This property is only present when the **field's** `action` is `added` _and_ the `added_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.
     */
    added_value?: unknown;
    /**
     * The name of the field that has changed in the resource.
     */
    readonly field?: string;
    /**
     * *Conditional.* This property is only present when the **field's** `action` is `changed` _and_ the `new_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.
     */
    new_value?: unknown;
    /**
     * *Conditional.* This property is only present when the **field's** `action` is `removed` _and_ the `removed_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.
     */
    removed_value?: unknown;
  };
  /**
   * The timestamp when the event occurred.
   */
  readonly created_at?: string;
  parent?: AsanaNamedResource & unknown;
  resource?: AsanaNamedResource & unknown;
  /**
   * *Deprecated: Refer to the resource_type of the resource.* The type of the resource that generated the event.
   */
  readonly type?: string;
  user?: UserCompact & unknown;
};

export type GoalAddSubgoalRequest = {
  /**
   * An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_after?: string;
  /**
   * An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_before?: string;
  /**
   * The goal gid to add as subgoal to a parent goal
   */
  subgoal: string;
};

export type GoalAddSupportingRelationshipRequest = {
  /**
   * The weight that the supporting resource's progress will contribute to the supported goal's progress. This can only be 0 or 1.
   */
  contribution_weight?: number;
  /**
   * An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.
   */
  insert_after?: string;
  /**
   * An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.
   */
  insert_before?: string;
  /**
   * The gid of the supporting resource to add to the parent goal. Must be the gid of a goal, project, or portfolio.
   */
  supporting_resource: string;
};

export type GoalAddSupportingWorkRequest = {
  /**
   * The project/portfolio gid to add as supporting work for a goal
   */
  supporting_work: string;
};

export type GoalBase = AsanaResource & {
  /**
   * The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.
   */
  due_on?: string | null;
  /**
   * The notes of the goal with formatting as HTML.
   */
  html_notes?: string;
  /**
   * *Conditional*. This property is only present when the `workspace` provided is an organization. Whether the goal belongs to the `workspace` (and is listed as part of the workspace’s goals) or not. If it isn’t a workspace-level goal, it is a team-level goal, and is associated with the goal’s team.
   */
  is_workspace_level?: boolean;
  /**
   * True if the goal is liked by the authorized user, false if not.
   */
  liked?: boolean;
  /**
   * The name of the goal.
   */
  name?: string;
  /**
   * Free-form textual information associated with the goal (i.e. its description).
   */
  notes?: string;
  /**
   * The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.
   */
  start_on?: string | null;
  /**
   * The current status of this goal. When the goal is open, its status can be `green`, `yellow`, and `red` to reflect "On Track", "At Risk", and "Off Track", respectively. When the goal is closed, the value can be `missed`, `achieved`, `partial`, or `dropped`.
   * *Note* you can only write to this property if `metric` is set.
   */
  status?: string | null;
};

export type GoalCompact = AsanaResource & {
  /**
   * The name of the goal.
   */
  name?: string;
  owner?:
    | (UserCompact & {
        [key: string]: unknown;
      })
    | null;
};

export type GoalMembershipBase = GoalMembershipCompact;

export type GoalMembershipCompact = AsanaResource & {
  /**
   * Describes if the user is comment only in goal.
   */
  is_commenter?: boolean;
  /**
   * Describes if the user is editor in goal.
   */
  is_editor?: boolean;
  member?: UserCompact;
};

export type GoalMembershipResponse = GoalMembershipCompact;

export type GoalMetricBase = AsanaResource & {
  /**
   * ISO 4217 currency code to format this custom field. This will be null if the `unit` is not `currency`.
   */
  currency_code?: string | null;
  /**
   * This string is the current value of a goal metric of type string.
   */
  readonly current_display_value?: string;
  /**
   * This number is the current value of a goal metric of type number.
   */
  current_number_value?: number;
  /**
   * This number is the start value of a goal metric of type number.
   */
  initial_number_value?: number;
  /**
   * *Conditional*. Only relevant for goal metrics of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive.
   * For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.
   */
  precision?: number;
  /**
   * This field defines how the progress value of a goal metric is being calculated. A goal's progress can be provided manually by the user, calculated automatically from contributing subgoals or projects, or managed by an integration with an external data source, such as Salesforce.
   */
  progress_source?:
    | 'manual'
    | 'subgoal_progress'
    | 'project_task_completion'
    | 'project_milestone_completion'
    | 'external';
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   */
  readonly resource_subtype?: 'number';
  /**
   * This number is the end value of a goal metric of type number. This number cannot equal `initial_number_value`.
   */
  target_number_value?: number;
  /**
   * A supported unit of measure for the goal metric, or none.
   */
  unit?: 'none' | 'currency' | 'percentage';
};

/**
 * This field defines how the progress value of a goal metric is being calculated. A goal's progress can be provided manually by the user, calculated automatically from contributing subgoals or projects, or managed by an integration with an external data source, such as Salesforce.
 */
export type progress_source =
  | 'manual'
  | 'subgoal_progress'
  | 'project_task_completion'
  | 'project_milestone_completion'
  | 'external';

/**
 * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
 */
export type resource_subtype3 = 'number';

/**
 * A supported unit of measure for the goal metric, or none.
 */
export type unit = 'none' | 'currency' | 'percentage';

export type GoalMetricCurrentValueRequest = AsanaResource & {
  /**
   * *Conditional*. This number is the current value of a goal metric of type number.
   */
  current_number_value?: number;
};

export type GoalMetricRequest = GoalMetricBase;

export type GoalRelationshipBase = GoalRelationshipCompact & {
  supported_goal?: GoalCompact & {
    [key: string]: unknown;
  };
};

export type GoalRelationshipCompact = AsanaResource & {
  /**
   * The weight that the supporting resource's progress contributes to the supported goal's progress. This can only be 0 or 1.
   */
  contribution_weight?: number;
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   */
  readonly resource_subtype?: 'subgoal' | 'supporting_work';
  supporting_resource?: ProjectCompact & {
    [key: string]: unknown;
  };
};

/**
 * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
 */
export type resource_subtype4 = 'subgoal' | 'supporting_work';

export type GoalRelationshipRequest = GoalRelationshipBase & {
  [key: string]: unknown;
};

export type GoalRelationshipResponse = GoalRelationshipBase & {
  [key: string]: unknown;
};

export type GoalRemoveSubgoalRequest = {
  /**
   * The goal gid to remove as subgoal from the parent goal
   */
  subgoal: string;
};

export type GoalRemoveSupportingRelationshipRequest = {
  /**
   * The gid of the supporting resource to remove from the parent goal. Must be the gid of a goal, project, or portfolio.
   */
  supporting_resource: string;
};

export type GoalRequest = GoalBase & {
  followers?: Array<string>;
  /**
   * The `gid` of a user.
   */
  owner?: string | null;
  /**
   * *Conditional*. This property is only present when the `workspace` provided is an organization.
   */
  team?: string | null;
  /**
   * The `gid` of a time period.
   */
  time_period?: string | null;
  /**
   * The `gid` of a workspace.
   */
  workspace?: string;
};

export type GoalResponse = GoalBase & {
  /**
   * The latest `status_update` posted to this goal.
   */
  current_status_update?: StatusUpdateCompact | null;
  /**
   * Array of users who are members of this goal.
   */
  followers?: Array<UserCompact>;
  /**
   * Array of likes for users who have liked this goal.
   */
  readonly likes?: Array<Like>;
  metric?:
    | (GoalMetricBase & {
        /**
         * *Conditional*. Only relevant for `progress_source` of type `external`. This boolean indicates whether the requester has the ability to update the current value of this metric. This returns `true` if the external metric was created by the requester, `false` otherwise.
         */
        readonly can_manage?: boolean;
      })
    | null;
  /**
   * The number of users who have liked this goal.
   */
  readonly num_likes?: number;
  owner?:
    | (UserCompact & {
        [key: string]: unknown;
      })
    | null;
  /**
   * *Conditional*. This property is only present when the `workspace` provided is an organization.
   */
  team?:
    | (TeamCompact & {
        [key: string]: unknown;
      })
    | null;
  time_period?:
    | (TimePeriodCompact & {
        [key: string]: unknown;
      })
    | null;
  workspace?: WorkspaceCompact & {
    [key: string]: unknown;
  };
};

export type JobBase = JobCompact;

export type JobCompact = AsanaResource & {
  new_project?: ProjectCompact;
  new_project_template?: ProjectTemplateCompact;
  new_task?: TaskCompact;
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   */
  readonly resource_subtype?: string;
  /**
   * The current status of this job. The value is one of: `not_started`, `in_progress`, `succeeded`, or `failed`.
   */
  readonly status?: 'not_started' | 'in_progress' | 'succeeded' | 'failed';
};

/**
 * The current status of this job. The value is one of: `not_started`, `in_progress`, `succeeded`, or `failed`.
 */
export type status = 'not_started' | 'in_progress' | 'succeeded' | 'failed';

export type JobResponse = JobCompact;

/**
 * An object to represent a user's like.
 */
export type Like = {
  /**
   * Globally unique identifier of the object, as a string.
   */
  readonly gid?: string;
  user?: UserCompact;
};

export type ModifyDependenciesRequest = {
  /**
   * An array of task gids that a task depends on.
   */
  dependencies?: Array<string>;
};

/**
 * A set of dependent tasks.
 */
export type ModifyDependentsRequest = {
  /**
   * An array of task gids that are dependents of the given task.
   */
  dependents?: Array<string>;
};

export type OrganizationExportBase = OrganizationExportCompact;

export type OrganizationExportCompact = AsanaResource & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * Download this URL to retreive the full export of the organization
   * in JSON format. It will be compressed in a gzip (.gz) container.
   *
   * *Note: May be null if the export is still in progress or
   * failed.  If present, this URL may only be valid for 1 hour from
   * the time of retrieval. You should avoid persisting this URL
   * somewhere and rather refresh on demand to ensure you do not keep
   * stale URLs.*
   */
  readonly download_url?: string | null;
  organization?: WorkspaceCompact;
  /**
   * The current state of the export.
   */
  readonly state?: 'pending' | 'started' | 'finished' | 'error';
};

/**
 * The current state of the export.
 */
export type state = 'pending' | 'started' | 'finished' | 'error';

/**
 * An *organization_export* request starts a job to export the complete data of the given Organization.
 */
export type OrganizationExportRequest = {
  /**
   * Globally unique identifier for the workspace or organization.
   */
  organization?: string;
};

export type OrganizationExportResponse = OrganizationExportCompact;

export type PortfolioAddItemRequest = {
  /**
   * An id of an item in this portfolio. The new item will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_after?: string;
  /**
   * An id of an item in this portfolio. The new item will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.
   */
  insert_before?: string;
  /**
   * The item to add to the portfolio.
   */
  item: string;
};

export type PortfolioBase = PortfolioCompact & {
  /**
   * Color of the portfolio.
   */
  color?:
    | 'dark-pink'
    | 'dark-green'
    | 'dark-blue'
    | 'dark-red'
    | 'dark-teal'
    | 'dark-brown'
    | 'dark-orange'
    | 'dark-purple'
    | 'dark-warm-gray'
    | 'light-pink'
    | 'light-green'
    | 'light-blue'
    | 'light-red'
    | 'light-teal'
    | 'light-brown'
    | 'light-orange'
    | 'light-purple'
    | 'light-warm-gray';
};

/**
 * Color of the portfolio.
 */
export type color =
  | 'dark-pink'
  | 'dark-green'
  | 'dark-blue'
  | 'dark-red'
  | 'dark-teal'
  | 'dark-brown'
  | 'dark-orange'
  | 'dark-purple'
  | 'dark-warm-gray'
  | 'light-pink'
  | 'light-green'
  | 'light-blue'
  | 'light-red'
  | 'light-teal'
  | 'light-brown'
  | 'light-orange'
  | 'light-purple'
  | 'light-warm-gray';

export type PortfolioCompact = AsanaResource & {
  /**
   * The name of the portfolio.
   */
  name?: string;
};

export type PortfolioMembershipBase = PortfolioMembershipCompact;

export type PortfolioMembershipCompact = AsanaResource & {
  /**
   * [Opt In](/docs/input-output-options). The portfolio the user is a member of.
   */
  portfolio?: PortfolioCompact;
  user?: UserCompact;
};

export type PortfolioMembershipResponse = PortfolioMembershipCompact;

export type PortfolioRemoveItemRequest = {
  /**
   * The item to remove from the portfolio.
   */
  item: string;
};

export type PortfolioRequest = PortfolioBase & {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  readonly members?: Array<string>;
  /**
   * True if the portfolio is public to its workspace members.
   */
  public?: boolean;
  /**
   * Gid of an object.
   */
  workspace?: string;
};

export type PortfolioResponse = PortfolioBase & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  created_by?: UserCompact;
  /**
   * The latest `status_update` posted to this portfolio.
   */
  current_status_update?: StatusUpdateCompact | null;
  /**
   * Array of custom field settings applied to the portfolio.
   */
  custom_field_settings?: Array<CustomFieldSettingResponse>;
  /**
   * Array of Custom Fields.
   */
  custom_fields?: Array<CustomFieldCompact>;
  /**
   * The localized day on which this portfolio is due. This takes a date with format YYYY-MM-DD.
   */
  due_on?: string | null;
  readonly members?: Array<UserCompact>;
  owner?: UserCompact;
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  /**
   * True if the portfolio is public to its workspace members.
   */
  public?: boolean;
  /**
   * The day on which work for this portfolio begins, or null if the portfolio has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*
   */
  start_on?: string | null;
  workspace?: WorkspaceCompact & {
    [key: string]: unknown;
  };
};

/**
 * A collection of rich text that will be displayed as a preview to another app.
 *
 * This is read-only except for a small group of whitelisted apps.
 */
export type Preview = {
  /**
   * Some fallback text to display if unable to display the full preview.
   */
  fallback?: string;
  /**
   * Text to display in the footer.
   */
  footer?: string;
  /**
   * Text to display in the header.
   */
  header?: string;
  /**
   * Where the header will link to.
   */
  header_link?: string;
  /**
   * HTML formatted text for the body of the preview.
   */
  html_text?: string;
  /**
   * Text for the body of the preview.
   */
  text?: string;
  /**
   * Text to display as the title.
   */
  title?: string;
  /**
   * Where to title will link to.
   */
  title_link?: string;
};

export type ProjectBase = ProjectCompact & {
  /**
   * True if the project is archived, false if not. Archived projects do not show in the UI by default and may be treated differently for queries.
   */
  archived?: boolean;
  /**
   * Color of the project.
   */
  color?:
    | (
        | 'dark-pink'
        | 'dark-green'
        | 'dark-blue'
        | 'dark-red'
        | 'dark-teal'
        | 'dark-brown'
        | 'dark-orange'
        | 'dark-purple'
        | 'dark-warm-gray'
        | 'light-pink'
        | 'light-green'
        | 'light-blue'
        | 'light-red'
        | 'light-teal'
        | 'light-brown'
        | 'light-orange'
        | 'light-purple'
        | 'light-warm-gray'
      )
    | null;
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * *Deprecated: new integrations should prefer the `current_status_update` resource.*
   */
  current_status?: ProjectStatusResponse | null;
  /**
   * The latest `status_update` posted to this project.
   */
  current_status_update?: StatusUpdateCompact | null;
  /**
   * Array of Custom Field Settings (in compact form).
   */
  readonly custom_field_settings?: Array<CustomFieldSettingResponse>;
  /**
   * The default view (list, board, calendar, or timeline) of a project.
   */
  default_view?: 'list' | 'board' | 'calendar' | 'timeline';
  /**
   * *Deprecated: new integrations should prefer the `due_on` field.*
   */
  due_date?: string | null;
  /**
   * The day on which this project is due. This takes a date with format YYYY-MM-DD.
   */
  due_on?: string | null;
  /**
   * [Opt In](/docs/input-output-options). The notes of the project with formatting as HTML.
   */
  html_notes?: string;
  /**
   * [Opt In](/docs/input-output-options). *Deprecated - please use a project template endpoint instead (more in [this forum post](https://forum.asana.com/t/a-new-api-for-project-templates/156432)).* Determines if the project is a template.
   */
  is_template?: boolean;
  /**
   * Array of users who are members of this project.
   */
  readonly members?: Array<UserCompact>;
  /**
   * The time at which this project was last modified.
   * *Note: This does not currently reflect any changes in associations such as tasks or comments that may have been added or removed from the project.*
   */
  readonly modified_at?: string;
  /**
   * Free-form textual information associated with the project (ie., its description).
   */
  notes?: string;
  /**
   * True if the project is public to its team.
   */
  public?: boolean;
  /**
   * The day on which work for this project begins, or null if the project has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` or `due_at` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*
   */
  start_on?: string | null;
  workspace?: WorkspaceCompact & {
    [key: string]: unknown;
  };
};

/**
 * The default view (list, board, calendar, or timeline) of a project.
 */
export type default_view = 'list' | 'board' | 'calendar' | 'timeline';

export type ProjectBriefBase = ProjectBriefCompact & {
  /**
   * HTML formatted text for the project brief.
   */
  html_text?: string;
  /**
   * The title of the project brief.
   */
  title?: string;
};

export type ProjectBriefCompact = AsanaResource & {
  [key: string]: unknown;
};

export type ProjectBriefRequest = ProjectBriefBase & {
  /**
   * The plain text of the project brief. When writing to a project brief, you can specify either `html_text` (preferred) or `text`, but not both.
   */
  text?: string;
};

export type ProjectBriefResponse = ProjectBriefBase & {
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  project?: ProjectCompact & {
    [key: string]: unknown;
  };
  /**
   * [Opt In](/docs/input-output-options). The plain text of the project brief.
   */
  text?: string;
};

export type ProjectCompact = AsanaResource & {
  /**
   * Name of the project. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.
   */
  name?: string;
};

export type ProjectDuplicateRequest = {
  /**
   * The elements that will be duplicated to the new project. Tasks are always included.
   */
  include?:
    | 'members'
    | 'notes'
    | 'forms'
    | 'task_notes'
    | 'task_assignee'
    | 'task_subtasks'
    | 'task_attachments'
    | 'task_dates'
    | 'task_dependencies'
    | 'task_followers'
    | 'task_tags'
    | 'task_projects';
  /**
   * The name of the new project.
   */
  name: string;
  /**
   * A dictionary of options to auto-shift dates. `task_dates` must be included to use this option. Requires either `start_on` or `due_on`, but not both.
   */
  schedule_dates?: {
    /**
     * Sets the last due date in the duplicated project to the given date. The rest of the due dates will be offset by the same amount as the due dates in the original project.
     */
    due_on?: string;
    /**
     * Determines if the auto-shifted dates should skip weekends.
     */
    should_skip_weekends: boolean;
    /**
     * Sets the first start date in the duplicated project to the given date. The rest of the start dates will be offset by the same amount as the start dates in the original project.
     */
    start_on?: string;
  };
  /**
   * Sets the team of the new project. If team is not defined, the new project will be in the same team as the the original project.
   */
  team?: string;
};

/**
 * The elements that will be duplicated to the new project. Tasks are always included.
 */
export type include =
  | 'members'
  | 'notes'
  | 'forms'
  | 'task_notes'
  | 'task_assignee'
  | 'task_subtasks'
  | 'task_attachments'
  | 'task_dates'
  | 'task_dependencies'
  | 'task_followers'
  | 'task_tags'
  | 'task_projects';

export type ProjectMembershipBase = ProjectMembershipCompact;

export type ProjectMembershipCompact = AsanaResource & {
  user?: UserCompact;
};

export type ProjectMembershipResponse = ProjectMembershipCompact & {
  /**
   * [Opt In](/docs/input-output-options). The project the user is a member of.
   */
  project?: ProjectCompact;
  /**
   * Whether the user has full access to the project or has comment-only access.
   */
  readonly write_access?: 'full_write' | 'comment_only';
};

/**
 * Whether the user has full access to the project or has comment-only access.
 */
export type write_access = 'full_write' | 'comment_only';

export type ProjectRequest = ProjectBase & {
  /**
   * An object where each key is a Custom Field GID and each value is an enum GID, string, number, or object.
   */
  custom_fields?: {
    [key: string]: string;
  };
  /**
   * *Create-only*. Comma separated string of users. Followers are a subset of members who have opted in to receive "tasks added" notifications for a project.
   */
  followers?: string;
  /**
   * The current owner of the project, may be null.
   */
  owner?: string | null;
  /**
   * The team that this project is shared with.
   */
  team?: string;
};

export type ProjectResponse = ProjectBase & {
  /**
   * True if the project is currently marked complete, false if not.
   */
  readonly completed?: boolean;
  /**
   * The time at which this project was completed, or null if the project is not completed.
   */
  readonly completed_at?: string | null;
  /**
   * The user that marked this project complete, or null if the project is not completed.
   */
  readonly completed_by?: UserCompact | null;
  created_from_template?:
    | (ProjectTemplateCompact & {
        [key: string]: unknown;
      })
    | null;
  /**
   * Array of Custom Fields.
   */
  readonly custom_fields?: Array<CustomFieldCompact>;
  /**
   * Array of users following this project. Followers are a subset of members who have opted in to receive "tasks added" notifications for a project.
   */
  readonly followers?: Array<UserCompact>;
  /**
   * The icon for a project.
   */
  icon?:
    | (
        | 'list'
        | 'board'
        | 'timeline'
        | 'calendar'
        | 'rocket'
        | 'people'
        | 'graph'
        | 'star'
        | 'bug'
        | 'light_bulb'
        | 'globe'
        | 'gear'
        | 'notebook'
        | 'computer'
        | 'check'
        | 'target'
        | 'html'
        | 'megaphone'
        | 'chat_bubbles'
        | 'briefcase'
        | 'page_layout'
        | 'mountain_flag'
        | 'puzzle'
        | 'presentation'
        | 'line_and_symbols'
        | 'speed_dial'
        | 'ribbon'
        | 'shoe'
        | 'shopping_basket'
        | 'map'
        | 'ticket'
        | 'coins'
      )
    | null;
  /**
   * The current owner of the project, may be null.
   */
  owner?: UserCompact | null;
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  project_brief?:
    | (ProjectBriefCompact & {
        [key: string]: unknown;
      })
    | null;
  team?: TeamCompact & {
    [key: string]: unknown;
  };
};

/**
 * The icon for a project.
 */
export type icon =
  | 'list'
  | 'board'
  | 'timeline'
  | 'calendar'
  | 'rocket'
  | 'people'
  | 'graph'
  | 'star'
  | 'bug'
  | 'light_bulb'
  | 'globe'
  | 'gear'
  | 'notebook'
  | 'computer'
  | 'check'
  | 'target'
  | 'html'
  | 'megaphone'
  | 'chat_bubbles'
  | 'briefcase'
  | 'page_layout'
  | 'mountain_flag'
  | 'puzzle'
  | 'presentation'
  | 'line_and_symbols'
  | 'speed_dial'
  | 'ribbon'
  | 'shoe'
  | 'shopping_basket'
  | 'map'
  | 'ticket'
  | 'coins';

export type ProjectSaveAsTemplateRequest = {
  /**
   * The name of the new project template.
   */
  name: string;
  /**
   * Sets the project template to public to its team.
   */
  public: boolean;
  /**
   * Sets the team of the new project template. If the project exists in an organization, specify team and not workspace.
   */
  team?: string;
  /**
   * Sets the workspace of the new project template. Only specify workspace if the project exists in a workspace.
   */
  workspace?: string;
};

export type ProjectSectionInsertRequest = {
  /**
   * Insert the given section immediately after the section specified by this parameter.
   */
  after_section?: string;
  /**
   * Insert the given section immediately before the section specified by this parameter.
   */
  before_section?: string;
  /**
   * The project in which to reorder the given section.
   */
  project: string;
  /**
   * The section to reorder.
   */
  section: string;
};

export type ProjectStatusBase = ProjectStatusCompact & {
  /**
   * The color associated with the status update.
   */
  color: 'green' | 'yellow' | 'red' | 'blue';
  /**
   * [Opt In](/docs/input-output-options). The text content of the status update with formatting as HTML.
   */
  html_text?: string;
  /**
   * The text content of the status update.
   */
  text: string;
};

/**
 * The color associated with the status update.
 */
export type color2 = 'green' | 'yellow' | 'red' | 'blue';

export type ProjectStatusCompact = AsanaResource & {
  /**
   * The title of the project status update.
   */
  title?: string;
};

export type ProjectStatusRequest = ProjectStatusBase;

export type ProjectStatusResponse = ProjectStatusBase & {
  author?: UserCompact;
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  created_by?: UserCompact;
  /**
   * The time at which this project status was last modified.
   * *Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the project status.*
   */
  readonly modified_at?: string;
};

export type ProjectTemplateBase = ProjectTemplateCompact & {
  /**
   * Color of the project template.
   */
  color?:
    | (
        | 'dark-pink'
        | 'dark-green'
        | 'dark-blue'
        | 'dark-red'
        | 'dark-teal'
        | 'dark-brown'
        | 'dark-orange'
        | 'dark-purple'
        | 'dark-warm-gray'
        | 'light-pink'
        | 'light-green'
        | 'light-blue'
        | 'light-red'
        | 'light-teal'
        | 'light-brown'
        | 'light-orange'
        | 'light-purple'
        | 'light-warm-gray'
      )
    | null;
  /**
   * Free-form textual information associated with the project template
   */
  description?: string;
  /**
   * The description of the project template with formatting as HTML.
   */
  html_description?: string;
  /**
   * The current owner of the project template, may be null.
   */
  owner?: UserCompact | null;
  /**
   * True if the project template is public to its team.
   */
  public?: boolean;
  /**
   * Array of date variables in this project template. Calendar dates must be provided for these variables when instantiating a project.
   */
  readonly requested_dates?: Array<DateVariableCompact>;
  team?: TeamCompact;
};

export type ProjectTemplateCompact = AsanaResource & {
  /**
   * Name of the project template.
   */
  name?: string;
};

export type ProjectTemplateInstantiateProjectRequest = {
  /**
   * *Optional*. If set to `true`, the endpoint returns an "Unprocessable Entity" error if you fail to provide a calendar date value for any date variable. If set to `false`, a default date is used for each unfulfilled date variable (e.g., the current date is used as the Start Date of a project).
   */
  is_strict?: boolean;
  /**
   * The name of the new project.
   */
  name: string;
  /**
   * Sets the project to public to its team.
   */
  public: boolean;
  /**
   * Array of mappings of date variables to calendar dates.
   */
  requested_dates?: Array<DateVariableRequest>;
  /**
   * *Conditional*. Sets the team of the new project. If the project template exists in an _organization_, you must specify a value for `team` and not `workspace`.
   */
  team?: string;
  /**
   * *Conditional*. Sets the workspace of the new project. If the project template exists in a _workspace_, you must specify a value for `workspace` and not `team`.
   */
  workspace?: string;
};

export type ProjectTemplateResponse = ProjectTemplateBase;

export type RemoveCustomFieldSettingRequest = {
  /**
   * The custom field to remove from this portfolio.
   */
  custom_field: string;
};

export type RemoveFollowersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  followers: string;
};

export type RemoveMembersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  members: string;
};

export type SectionBase = SectionCompact;

export type SectionCompact = AsanaResource & {
  /**
   * The name of the section (i.e. the text displayed as the section header).
   */
  name?: string;
};

export type SectionRequest = {
  /**
   * An existing section within this project after which the added section should be inserted. Cannot be provided together with insert_before.
   */
  insert_after?: string;
  /**
   * An existing section within this project before which the added section should be inserted. Cannot be provided together with insert_after.
   */
  insert_before?: string;
  /**
   * The text to be displayed as the section name. This cannot be an empty string.
   */
  name: string;
};

export type SectionResponse = SectionCompact & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  project?: ProjectCompact;
  /**
   * *Deprecated - please use project instead*
   */
  readonly projects?: Array<ProjectCompact>;
};

export type SectionTaskInsertRequest = {
  /**
   * An existing task within this section after which the added task should be inserted. Cannot be provided together with insert_before.
   */
  insert_after?: string;
  /**
   * An existing task within this section before which the added task should be inserted. Cannot be provided together with insert_after.
   */
  insert_before?: string;
  /**
   * The task to add to this section.
   */
  task: string;
};

export type StatusUpdateBase = StatusUpdateCompact & {
  /**
   * [Opt In](/docs/input-output-options). The text content of the status update with formatting as HTML.
   */
  html_text?: string;
  /**
   * The type associated with the status update. This represents the current state of the object this object is on.
   */
  status_type:
    | 'on_track'
    | 'at_risk'
    | 'off_track'
    | 'on_hold'
    | 'complete'
    | 'achieved'
    | 'partial'
    | 'missed'
    | 'dropped';
  /**
   * The text content of the status update.
   */
  text: string;
};

/**
 * The type associated with the status update. This represents the current state of the object this object is on.
 */
export type status_type =
  | 'on_track'
  | 'at_risk'
  | 'off_track'
  | 'on_hold'
  | 'complete'
  | 'achieved'
  | 'partial'
  | 'missed'
  | 'dropped';

export type StatusUpdateCompact = AsanaResource & {
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   * The `resource_subtype`s for `status` objects represent the type of their parent.
   */
  readonly resource_subtype?: 'project_status_update' | 'portfolio_status_update' | 'goal_status_update';
  /**
   * The title of the status update.
   */
  title?: string;
};

/**
 * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
 * The `resource_subtype`s for `status` objects represent the type of their parent.
 */
export type resource_subtype5 = 'project_status_update' | 'portfolio_status_update' | 'goal_status_update';

export type StatusUpdateRequest = StatusUpdateBase & {
  parent: string;
};

export type StatusUpdateResponse = StatusUpdateBase & {
  author?: UserCompact;
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  created_by?: UserCompact;
  /**
   * *Deprecated - please use liked instead* True if the status is hearted by the authorized user, false if not.
   */
  readonly hearted?: boolean;
  /**
   * *Deprecated - please use likes instead* Array of likes for users who have hearted this status.
   */
  readonly hearts?: Array<Like>;
  /**
   * True if the status is liked by the authorized user, false if not.
   */
  liked?: boolean;
  /**
   * Array of likes for users who have liked this status.
   */
  readonly likes?: Array<Like>;
  /**
   * The time at which this project status was last modified.
   * *Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the status.*
   */
  readonly modified_at?: string;
  /**
   * *Deprecated - please use likes instead* The number of users who have hearted this status.
   */
  readonly num_hearts?: number;
  /**
   * The number of users who have liked this status.
   */
  readonly num_likes?: number;
  parent?: ProjectCompact & {
    [key: string]: unknown;
  };
};

export type StoryBase = AsanaResource & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * [Opt In](/docs/input-output-options). HTML formatted text for a comment. This will not include the name of the creator.
   */
  html_text?: string;
  /**
   * *Conditional*. Whether the story should be pinned on the resource.
   */
  is_pinned?: boolean;
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   */
  readonly resource_subtype?: string;
  /**
   * The name of the sticker in this story. `null` if there is no sticker.
   */
  sticker_name?:
    | 'green_checkmark'
    | 'people_dancing'
    | 'dancing_unicorn'
    | 'heart'
    | 'party_popper'
    | 'people_waving_flags'
    | 'splashing_narwhal'
    | 'trophy'
    | 'yeti_riding_unicorn'
    | 'celebrating_people'
    | 'determined_climbers'
    | 'phoenix_spreading_love';
  /**
   * The plain text of the comment to add. Cannot be used with html_text.
   */
  text?: string;
};

/**
 * The name of the sticker in this story. `null` if there is no sticker.
 */
export type sticker_name =
  | 'green_checkmark'
  | 'people_dancing'
  | 'dancing_unicorn'
  | 'heart'
  | 'party_popper'
  | 'people_waving_flags'
  | 'splashing_narwhal'
  | 'trophy'
  | 'yeti_riding_unicorn'
  | 'celebrating_people'
  | 'determined_climbers'
  | 'phoenix_spreading_love';

export type StoryCompact = AsanaResource & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  created_by?: UserCompact;
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   */
  readonly resource_subtype?: string;
  /**
   * *Create-only*. Human-readable text for the story or comment.
   * This will not include the name of the creator.
   * *Note: This is not guaranteed to be stable for a given type of story. For example, text for a reassignment may not always say “assigned to …” as the text for a story can both be edited and change based on the language settings of the user making the request.*
   * Use the `resource_subtype` property to discover the action that created the story.
   */
  text?: string;
};

export type StoryRequest = StoryBase;

export type StoryResponse = StoryBase & {
  /**
   * *Conditional*
   */
  readonly assignee?: UserCompact;
  created_by?: UserCompact;
  /**
   * *Conditional*
   */
  readonly custom_field?: CustomFieldCompact;
  /**
   * *Conditional*
   */
  readonly dependency?: TaskCompact;
  /**
   * *Conditional*
   */
  readonly duplicate_of?: TaskCompact;
  /**
   * *Conditional*
   */
  readonly duplicated_from?: TaskCompact;
  /**
   * *Conditional*
   */
  readonly follower?: UserCompact;
  /**
   * *Deprecated - please use likes instead*
   * *Conditional*. True if the story is hearted by the authorized user, false if not.
   */
  readonly hearted?: boolean;
  /**
   * *Deprecated - please use likes instead*
   *
   * *Conditional*. Array of likes for users who have hearted this story.
   */
  readonly hearts?: Array<Like>;
  /**
   * *Conditional*. Whether the text of the story can be edited after creation.
   */
  readonly is_editable?: boolean;
  /**
   * *Conditional*. Whether the text of the story has been edited after creation.
   */
  readonly is_edited?: boolean;
  /**
   * *Conditional*. True if the story is liked by the authorized user, false if not.
   */
  readonly liked?: boolean;
  /**
   * *Conditional*. Array of likes for users who have liked this story.
   */
  readonly likes?: Array<Like>;
  /**
   * *Conditional*. The new value of approval status.
   */
  readonly new_approval_status?: string;
  readonly new_date_value?: StoryResponseDates & unknown;
  new_dates?: StoryResponseDates;
  /**
   * *Conditional*
   */
  readonly new_enum_value?: EnumOption;
  /**
   * *Conditional*. The new value of a multi-enum custom field story.
   */
  readonly new_multi_enum_values?: Array<EnumOption>;
  /**
   * *Conditional*
   */
  readonly new_name?: string;
  /**
   * *Conditional*
   */
  readonly new_number_value?: number;
  /**
   * *Conditional*. The new value of a people custom field story.
   */
  readonly new_people_value?: Array<UserCompact>;
  /**
   * *Conditional*
   */
  readonly new_resource_subtype?: string;
  /**
   * *Conditional*
   */
  readonly new_section?: SectionCompact;
  /**
   * *Conditional*
   */
  readonly new_text_value?: string;
  /**
   * *Deprecated - please use likes instead*
   *
   * *Conditional*. The number of users who have hearted this story.
   */
  readonly num_hearts?: number;
  /**
   * *Conditional*. The number of users who have liked this story.
   */
  readonly num_likes?: number;
  /**
   * *Conditional*. The old value of approval status.
   */
  readonly old_approval_status?: string;
  readonly old_date_value?: StoryResponseDates & unknown;
  old_dates?: StoryResponseDates;
  /**
   * *Conditional*
   */
  readonly old_enum_value?: EnumOption;
  /**
   * *Conditional*. The old value of a multi-enum custom field story.
   */
  readonly old_multi_enum_values?: Array<EnumOption>;
  /**
   * *Conditional*'
   */
  old_name?: string;
  /**
   * *Conditional*
   */
  readonly old_number_value?: number;
  /**
   * *Conditional*. The old value of a people custom field story.
   */
  readonly old_people_value?: Array<UserCompact>;
  /**
   * *Conditional*
   */
  readonly old_resource_subtype?: string;
  /**
   * *Conditional*
   */
  readonly old_section?: SectionCompact;
  /**
   * *Conditional*
   */
  readonly old_text_value?: string;
  /**
   * *Conditional*. A collection of previews to be displayed in the story.
   *
   * *Note: This property only exists for comment stories.*
   */
  readonly previews?: Array<Preview>;
  /**
   * *Conditional*
   */
  readonly project?: ProjectCompact;
  /**
   * The component of the Asana product the user used to trigger the story.
   */
  readonly source?: 'web' | 'email' | 'mobile' | 'api' | 'unknown';
  /**
   * *Conditional*
   */
  readonly story?: StoryCompact;
  /**
   * *Conditional*
   */
  readonly tag?: TagCompact;
  target?: TaskCompact & {
    [key: string]: unknown;
  };
  /**
   * *Conditional*
   */
  readonly task?: TaskCompact;
  readonly type?: 'comment' | 'system';
};

/**
 * The component of the Asana product the user used to trigger the story.
 */
export type source = 'web' | 'email' | 'mobile' | 'api' | 'unknown';

export type type2 = 'comment' | 'system';

/**
 * *Conditional*
 */
export type StoryResponseDates = {
  /**
   * The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.
   */
  due_at?: string | null;
  /**
   * The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.
   */
  due_on?: string;
  /**
   * The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.
   */
  start_on?: string | null;
};

export type TagBase = TagCompact & {
  /**
   * Color of the tag.
   */
  color?:
    | (
        | 'dark-pink'
        | 'dark-green'
        | 'dark-blue'
        | 'dark-red'
        | 'dark-teal'
        | 'dark-brown'
        | 'dark-orange'
        | 'dark-purple'
        | 'dark-warm-gray'
        | 'light-pink'
        | 'light-green'
        | 'light-blue'
        | 'light-red'
        | 'light-teal'
        | 'light-brown'
        | 'light-orange'
        | 'light-purple'
        | 'light-warm-gray'
      )
    | null;
  /**
   * Free-form textual information associated with the tag (i.e. its description).
   */
  notes?: string;
};

export type TagCompact = AsanaResource & {
  /**
   * Name of the tag. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.
   */
  name?: string;
};

export type TagRequest = TagBase & {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  followers?: Array<string>;
  /**
   * Gid of an object.
   */
  workspace?: string;
};

export type TagResponse = TagBase & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * Array of users following this tag.
   */
  readonly followers?: Array<UserCompact>;
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  workspace?: WorkspaceCompact;
};

export type TaskAddFollowersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  followers: Array<string>;
};

export type TaskAddProjectRequest = {
  /**
   * A task in the project to insert the task after, or `null` to insert at the beginning of the list.
   */
  insert_after?: string | null;
  /**
   * A task in the project to insert the task before, or `null` to insert at the end of the list.
   */
  insert_before?: string | null;
  /**
   * The project to add the task to.
   */
  project: string;
  /**
   * A section in the project to insert the task into. The task will be inserted at the bottom of the section.
   */
  section?: string | null;
};

export type TaskAddTagRequest = {
  /**
   * The tag to add to the task.
   */
  tag: string;
};

export type TaskBase = TaskCompact & {
  /**
   * This value represents the sum of all the Time Tracking entries in the Actual Time field on a given Task. It is represented as a nullable long value.
   */
  readonly actual_time_minutes?: number | null;
  /**
   * *Conditional* Reflects the approval status of this task. This field is kept in sync with `completed`, meaning `pending` translates to false while `approved`, `rejected`, and `changes_requested` translate to true. If you set completed to true, this field will be set to `approved`.
   */
  approval_status?: 'pending' | 'approved' | 'rejected' | 'changes_requested';
  /**
   * *Deprecated* Scheduling status of this task for the user it is assigned to. This field can only be set if the assignee is non-null. Setting this field to "inbox" or "upcoming" inserts it at the top of the section, while the other options will insert at the bottom.
   */
  assignee_status?: 'today' | 'upcoming' | 'later' | 'new' | 'inbox';
  /**
   * True if the task is currently marked complete, false if not.
   */
  completed?: boolean;
  /**
   * The time at which this task was completed, or null if the task is incomplete.
   */
  readonly completed_at?: string | null;
  readonly completed_by?: UserCompact;
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * [Opt In](/docs/input-output-options). Array of resources referencing tasks that this task depends on. The objects contain only the gid of the dependency.
   */
  readonly dependencies?: Array<AsanaResource>;
  /**
   * [Opt In](/docs/input-output-options). Array of resources referencing tasks that depend on this task. The objects contain only the ID of the dependent.
   */
  readonly dependents?: Array<AsanaResource>;
  /**
   * The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.
   */
  due_at?: string | null;
  /**
   * The localized date on which this task is due, or null if the task has no due date. This takes a date with `YYYY-MM-DD` format and should not be used together with `due_at`.
   */
  due_on?: string | null;
  /**
   * *OAuth Required*. *Conditional*. This field is returned only if external values are set or included by using [Opt In] (/docs/input-output-options).
   * The external field allows you to store app-specific metadata on tasks, including a gid that can be used to retrieve tasks and a data blob that can store app-specific character strings. Note that you will need to authenticate with Oauth to access or modify this data. Once an external gid is set, you can use the notation `external:custom_gid` to reference your object anywhere in the API where you may use the original object gid. See the page on Custom External Data for more details.
   */
  external?: {
    data?: string;
    gid?: string;
  };
  /**
   * *Deprecated - please use liked instead* True if the task is hearted by the authorized user, false if not.
   */
  readonly hearted?: boolean;
  /**
   * *Deprecated - please use likes instead* Array of likes for users who have hearted this task.
   */
  readonly hearts?: Array<Like>;
  /**
   * [Opt In](/docs/input-output-options). The notes of the text with formatting as HTML.
   */
  html_notes?: string;
  /**
   * [Opt In](/docs/input-output-options). In some contexts tasks can be rendered as a visual separator; for instance, subtasks can appear similar to [sections](/docs/asana-sections) without being true `section` objects. If a `task` object is rendered this way in any context it will have the property `is_rendered_as_separator` set to `true`.
   */
  readonly is_rendered_as_separator?: boolean;
  /**
   * True if the task is liked by the authorized user, false if not.
   */
  liked?: boolean;
  /**
   * Array of likes for users who have liked this task.
   */
  readonly likes?: Array<Like>;
  /**
   * *Create-only*. Array of projects this task is associated with and the section it is in. At task creation time, this array can be used to add the task to specific sections. After task creation, these associations can be modified using the `addProject` and `removeProject` endpoints. Note that over time, more types of memberships may be added to this property.
   */
  readonly memberships?: Array<{
    project?: ProjectCompact;
    section?: SectionCompact;
  }>;
  /**
   * The time at which this task was last modified.
   *
   * *Note: This does not currently reflect any changes in
   * associations such as projects or comments that may have been
   * added or removed from the task.*
   */
  readonly modified_at?: string;
  /**
   * Name of the task. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.
   */
  name?: string;
  /**
   * Free-form textual information associated with the task (i.e. its description).
   */
  notes?: string;
  /**
   * *Deprecated - please use likes instead* The number of users who have hearted this task.
   */
  readonly num_hearts?: number;
  /**
   * The number of users who have liked this task.
   */
  readonly num_likes?: number;
  /**
   * [Opt In](/docs/input-output-options). The number of subtasks on this task.
   *
   */
  readonly num_subtasks?: number;
  /**
   * Date and time on which work begins for the task, or null if the task has no start time. This takes an ISO 8601 date string in UTC and should not be used together with `start_on`.
   * *Note: `due_at` must be present in the request when setting or unsetting the `start_at` parameter.*
   */
  start_at?: string | null;
  /**
   * The day on which work begins for the task , or null if the task has no start date. This takes a date with `YYYY-MM-DD` format and should not be used together with `start_at`.
   * *Note: `due_on` or `due_at` must be present in the request when setting or unsetting the `start_on` parameter.*
   */
  start_on?: string | null;
};

/**
 * *Conditional* Reflects the approval status of this task. This field is kept in sync with `completed`, meaning `pending` translates to false while `approved`, `rejected`, and `changes_requested` translate to true. If you set completed to true, this field will be set to `approved`.
 */
export type approval_status = 'pending' | 'approved' | 'rejected' | 'changes_requested';

/**
 * *Deprecated* Scheduling status of this task for the user it is assigned to. This field can only be set if the assignee is non-null. Setting this field to "inbox" or "upcoming" inserts it at the top of the section, while the other options will insert at the bottom.
 */
export type assignee_status = 'today' | 'upcoming' | 'later' | 'new' | 'inbox';

export type TaskCompact = AsanaResource & {
  /**
   * The name of the task.
   */
  name?: string;
  /**
   * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
   * The resource_subtype `milestone` represent a single moment in time. This means tasks with this subtype cannot have a start_date.
   */
  resource_subtype?: 'default_task' | 'milestone' | 'section' | 'approval';
};

/**
 * The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
 * The resource_subtype `milestone` represent a single moment in time. This means tasks with this subtype cannot have a start_date.
 */
export type resource_subtype6 = 'default_task' | 'milestone' | 'section' | 'approval';

/**
 * A response object returned from the task count endpoint.
 */
export type TaskCountResponse = {
  /**
   * The number of completed milestones in a project.
   */
  num_completed_milestones?: number;
  /**
   * The number of completed tasks in a project.
   */
  num_completed_tasks?: number;
  /**
   * The number of incomplete milestones in a project.
   */
  num_incomplete_milestones?: number;
  /**
   * The number of incomplete tasks in a project.
   */
  num_incomplete_tasks?: number;
  /**
   * The number of milestones in a project.
   */
  num_milestones?: number;
  /**
   * The number of tasks in a project.
   */
  num_tasks?: number;
};

export type TaskDuplicateRequest = {
  /**
   * The fields that will be duplicated to the new task.
   */
  include?:
    | 'notes'
    | 'assignee'
    | 'subtasks'
    | 'attachments'
    | 'tags'
    | 'followers'
    | 'projects'
    | 'dates'
    | 'dependencies'
    | 'parent';
  /**
   * The name of the new task.
   */
  name?: string;
};

/**
 * The fields that will be duplicated to the new task.
 */
export type include2 =
  | 'notes'
  | 'assignee'
  | 'subtasks'
  | 'attachments'
  | 'tags'
  | 'followers'
  | 'projects'
  | 'dates'
  | 'dependencies'
  | 'parent';

export type TaskRemoveFollowersRequest = {
  /**
   * An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.
   */
  followers: Array<string>;
};

export type TaskRemoveProjectRequest = {
  /**
   * The project to remove the task from.
   */
  project: string;
};

export type TaskRemoveTagRequest = {
  /**
   * The tag to remove from the task.
   */
  tag: string;
};

export type TaskRequest = TaskBase & {
  /**
   * Gid of a user.
   */
  assignee?: string | null;
  /**
   * The *assignee section* is a subdivision of a project that groups tasks together in the assignee's "My Tasks" list. It can either be a header above a list of tasks in a list view or a column in a board view of "My Tasks."
   * The `assignee_section` property will be returned in the response only if the request was sent by the user who is the assignee of the task. Note that you can only write to `assignee_section` with the gid of an existing section visible in the user's "My Tasks" list.
   */
  assignee_section?: string | null;
  /**
   * An object where each key is a Custom Field GID and each value is an enum GID, string, number, object, or array.
   */
  custom_fields?: {
    [key: string]: string;
  };
  /**
   * *Create-Only* An array of strings identifying users. These can either be the string "me", an email, or the gid of a user. In order to change followers on an existing task use `addFollowers` and `removeFollowers`.
   */
  followers?: Array<string>;
  /**
   * Gid of a task.
   */
  parent?: string | null;
  /**
   * *Create-Only* Array of project gids. In order to change projects on an existing task use `addProject` and `removeProject`.
   */
  projects?: Array<string>;
  /**
   * *Create-Only* Array of tag gids. In order to change tags on an existing task use `addTag` and `removeTag`.
   */
  tags?: Array<string>;
  /**
   * Gid of a workspace.
   */
  workspace?: string;
};

export type TaskResponse = TaskBase & {
  assignee?: UserCompact | null;
  assignee_section?: (SectionCompact & unknown) | null;
  /**
   * Array of custom field values applied to the task. These represent the custom field values recorded on this project for a particular custom field. For example, these custom field values will contain an `enum_value` property for custom fields of type `enum`, a `text_value` property for custom fields of type `text`, and so on. Please note that the `gid` returned on each custom field value *is identical* to the `gid` of the custom field, which allows referencing the custom field metadata through the `/custom_fields/custom_field-gid` endpoint.
   */
  readonly custom_fields?: Array<CustomFieldResponse>;
  /**
   * Array of users following this task.
   */
  readonly followers?: Array<UserCompact>;
  parent?:
    | (TaskCompact & {
        [key: string]: unknown;
      })
    | null;
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  /**
   * *Create-only.* Array of projects this task is associated with. At task creation time, this array can be used to add the task to many projects at once. After task creation, these associations can be modified using the addProject and removeProject endpoints.
   */
  readonly projects?: Array<ProjectCompact>;
  /**
   * Array of tags associated with this task. In order to change tags on an existing task use `addTag` and `removeTag`.
   */
  readonly tags?: Array<TagCompact>;
  workspace?: WorkspaceCompact & {
    [key: string]: unknown;
  };
};

export type TaskSetParentRequest = {
  /**
   * A subtask of the parent to insert the task after, or `null` to insert at the beginning of the list.
   */
  insert_after?: string;
  /**
   * A subtask of the parent to insert the task before, or `null` to insert at the end of the list.
   */
  insert_before?: string;
  /**
   * The new parent of the task, or `null` for no parent.
   */
  parent: string;
};

/**
 * A user identification object for specification with the addUser/removeUser endpoints.
 */
export type TeamAddUserRequest = {
  /**
   * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
   */
  user?: string;
};

export type TeamBase = TeamCompact;

export type TeamCompact = AsanaResource & {
  /**
   * The name of the team.
   */
  name?: string;
};

export type TeamMembershipBase = TeamMembershipCompact;

export type TeamMembershipCompact = AsanaResource & {
  /**
   * Describes if the user is a guest in the team.
   */
  is_guest?: boolean;
  team?: TeamCompact;
  user?: UserCompact;
};

export type TeamMembershipResponse = TeamMembershipCompact;

/**
 * A user identification object for specification with the addUser/removeUser endpoints.
 */
export type TeamRemoveUserRequest = {
  /**
   * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
   */
  user?: string;
};

export type TeamRequest = TeamCompact & {
  /**
   * The description of the team.
   *
   */
  description?: string;
  /**
   * The description of the team with formatting as HTML.
   *
   */
  html_description?: string;
  /**
   * The organization/workspace the team belongs to. This must be the same organization you are in and cannot be changed once set.
   *
   */
  organization?: string;
  /**
   * The visibility of the team to users in the same organization
   *
   */
  visibility?: 'secret' | 'request_to_join' | 'public';
};

/**
 * The visibility of the team to users in the same organization
 *
 */
export type visibility = 'secret' | 'request_to_join' | 'public';

export type TeamResponse = TeamCompact & {
  /**
   * [Opt In](/docs/input-output-options). The description of the team.
   *
   */
  description?: string;
  /**
   * [Opt In](/docs/input-output-options). The description of the team with formatting as HTML.
   *
   */
  html_description?: string;
  organization?: WorkspaceCompact & {
    [key: string]: unknown;
  };
  /**
   * A url that points directly to the object within Asana.
   */
  readonly permalink_url?: string;
  /**
   * The visibility of the team to users in the same organization
   *
   */
  visibility?: 'secret' | 'request_to_join' | 'public';
};

export type TimePeriodBase = TimePeriodCompact & {
  parent?: TimePeriodCompact;
};

export type TimePeriodCompact = AsanaResource & {
  /**
   * A string representing the cadence code and the fiscal year.
   */
  display_name?: string;
  /**
   * The localized end date of the time period in `YYYY-MM-DD` format.
   */
  end_on?: string;
  /**
   * The cadence and index of the time period. The value is one of: `FY`, `H1`, `H2`, `Q1`, `Q2`, `Q3`, or `Q4`.
   */
  period?: 'FY' | 'H1' | 'H2' | 'Q1' | 'Q2' | 'Q3' | 'Q4';
  /**
   * The localized start date of the time period in `YYYY-MM-DD` format.
   */
  start_on?: string;
};

/**
 * The cadence and index of the time period. The value is one of: `FY`, `H1`, `H2`, `Q1`, `Q2`, `Q3`, or `Q4`.
 */
export type period = 'FY' | 'H1' | 'H2' | 'Q1' | 'Q2' | 'Q3' | 'Q4';

export type TimePeriodResponse = TimePeriodBase & {
  [key: string]: unknown;
};

export type UserBase = UserCompact;

export type UserBaseResponse = UserCompact & {
  /**
   * The user's email address.
   */
  readonly email?: string;
  /**
   * A map of the user’s profile photo in various sizes, or null if no photo is set. Sizes provided are 21, 27, 36, 60, 128, and 1024. All images are in PNG format, except for 1024 (which is in JPEG format).
   */
  readonly photo?: {
    image_1024x1024?: string;
    image_128x128?: string;
    image_21x21?: string;
    image_27x27?: string;
    image_36x36?: string;
    image_60x60?: string;
  } | null;
};

export type UserCompact = AsanaResource & {
  /**
   * *Read-only except when same user as requester*. The user’s name.
   */
  name?: string;
};

export type UserRequest = UserCompact;

export type UserResponse = UserBaseResponse & {
  /**
   * Workspaces and organizations this user may access.
   * Note\: The API will only return workspaces and organizations that also contain the authenticated user.
   */
  readonly workspaces?: Array<WorkspaceCompact>;
};

export type UserTaskListBase = UserTaskListCompact;

export type UserTaskListCompact = AsanaResource & {
  /**
   * The name of the user task list.
   */
  name?: string;
  /**
   * The owner of the user task list, i.e. the person whose My Tasks is represented by this resource.
   */
  readonly owner?: UserCompact;
  /**
   * The workspace in which the user task list is located.
   */
  readonly workspace?: WorkspaceCompact;
};

export type UserTaskListRequest = UserTaskListCompact;

export type UserTaskListResponse = UserTaskListCompact;

export type WebhookCompact = AsanaResource & {
  /**
   * If true, the webhook will send events - if false it is considered inactive and will not generate events.
   */
  readonly active?: boolean;
  resource?: AsanaNamedResource;
  /**
   * The URL to receive the HTTP POST.
   */
  readonly target?: string;
};

/**
 * A WebhookFilter can be passed on creation of a webhook in order to filter the types of actions that trigger delivery of an [Event](/docs/tocS_Event)
 */
export type WebhookFilter = {
  /**
   * The type of change on the **resource** to pass through the filter. For more information refer to `Event.action` in the [Event](/docs/tocS_Event) schema. This can be one of `changed`, `added`, `removed`, `deleted`, and `undeleted` depending on the nature of what has occurred on the resource.
   */
  action?: string;
  /**
   * *Conditional.* A whitelist of fields for events which will pass the filter when the resource is changed. These can be any combination of the fields on the resources themselves. This field is only valid for `action` of type `changed`
   */
  fields?: Array<string>;
  /**
   * The resource subtype of the resource that the filter applies to. This should be set to the same value as is returned on the `resource_subtype` field on the resources themselves.
   */
  resource_subtype?: string;
  /**
   * The type of the resource which created the event when modified; for example, to filter to changes on regular tasks this field should be set to `task`.
   */
  resource_type?: string;
};

export type WebhookRequest = {
  /**
   * An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.
   */
  filters?: Array<
    WebhookFilter &
      unknown & {
        [key: string]: unknown;
      }
  >;
  /**
   * A resource ID to subscribe to. Many Asana resources are valid to create webhooks on, but higher-level resources require filters.
   */
  resource: string;
  /**
   * The URL to receive the HTTP POST. The full URL will be used to deliver events from this webhook (including parameters) which allows encoding of application-specific state when the webhook is created.
   */
  target: string;
};

export type WebhookResponse = WebhookCompact & {
  /**
   * The time at which this resource was created.
   */
  readonly created_at?: string;
  /**
   * Whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.
   */
  filters?: Array<
    WebhookFilter &
      unknown & {
        [key: string]: unknown;
      }
  >;
  /**
   * The timestamp when the webhook last received an error when sending an event to the target.
   */
  readonly last_failure_at?: string;
  /**
   * The contents of the last error response sent to the webhook when attempting to deliver events to the target.
   */
  readonly last_failure_content?: string;
  /**
   * The timestamp when the webhook last successfully sent an event to the target.
   */
  readonly last_success_at?: string;
};

export type WebhookUpdateRequest = {
  /**
   * An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.
   */
  filters?: Array<
    WebhookFilter &
      unknown & {
        [key: string]: unknown;
      }
  >;
};

/**
 * A user identification object for specification with the addUser/removeUser endpoints.
 */
export type WorkspaceAddUserRequest = {
  /**
   * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
   */
  user?: string;
};

export type WorkspaceBase = WorkspaceCompact;

export type WorkspaceCompact = AsanaResource & {
  /**
   * The name of the workspace.
   */
  name?: string;
};

export type WorkspaceMembershipBase = WorkspaceMembershipCompact;

export type WorkspaceMembershipCompact = AsanaResource & {
  user?: UserCompact;
  workspace?: WorkspaceCompact;
};

export type WorkspaceMembershipRequest = WorkspaceMembershipCompact;

export type WorkspaceMembershipResponse = WorkspaceMembershipCompact & {
  /**
   * Reflects if this user still a member of the workspace.
   */
  readonly is_active?: boolean;
  /**
   * Reflects if this user is an admin of the workspace.
   */
  readonly is_admin?: boolean;
  /**
   * Reflects if this user is a guest of the workspace.
   */
  readonly is_guest?: boolean;
  /**
   * The user's "My Tasks" in the workspace.
   */
  readonly user_task_list?: UserTaskListCompact;
  /**
   * Contains keys `start_on` and `end_on` for the vacation dates for the user in this workspace. If `start_on` is null, the entire `vacation_dates` object will be null. If `end_on` is before today, the entire `vacation_dates` object will be null.
   */
  readonly vacation_dates?: {
    /**
     * The day on which the user's vacation in this workspace ends, or null if there is no end date. This is a date with `YYYY-MM-DD` format.
     */
    end_on?: string | null;
    /**
     * The day on which the user's vacation in this workspace starts. This is a date with `YYYY-MM-DD` format.
     */
    start_on?: string;
  } | null;
};

/**
 * A user identification object for specification with the addUser/removeUser endpoints.
 */
export type WorkspaceRemoveUserRequest = {
  /**
   * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
   */
  user?: string;
};

export type WorkspaceRequest = WorkspaceCompact;

export type WorkspaceResponse = WorkspaceCompact & {
  /**
   * The email domains that are associated with this workspace.
   */
  email_domains?: Array<string>;
  /**
   * Whether the workspace is an *organization*.
   */
  is_organization?: boolean;
};

/**
 * Only return projects whose `archived` field takes on the value of this parameter.
 */
export type Parameterarchived_query_param = boolean;

/**
 * Globally unique identifier for the attachment.
 */
export type Parameterattachment_path_gid = string;

/**
 * Filter to events triggered by the actor with this ID.
 */
export type Parameteraudit_log_actor_gid = string;

/**
 * Filter to events with an actor of this type.
 * This only needs to be included if querying for actor types without an ID. If `actor_gid` is included, this should be excluded.
 */
export type Parameteraudit_log_actor_type = 'user' | 'asana' | 'asana_support' | 'anonymous' | 'external_administrator';

/**
 * Filter to events created before this time (exclusive).
 */
export type Parameteraudit_log_end_at = string;

/**
 * Filter to events of this type.
 * Refer to the [Supported AuditLogEvents](/docs/supported-auditlogevents) for a full list of values.
 */
export type Parameteraudit_log_event_type = string;

/**
 * Filter to events with this resource ID.
 */
export type Parameteraudit_log_resource_gid = string;

/**
 * Filter to events created after this time (inclusive).
 */
export type Parameteraudit_log_start_at = string;

/**
 * Only return tasks that are either incomplete or that have been completed since this time. Accepts a date-time string or the keyword *now*.
 *
 */
export type Parametercompleted_since = string;

/**
 * Globally unique identifier for the custom field.
 */
export type Parametercustom_field_path_gid = string;

/**
 * Defines fields to return.
 * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
 * The id of included objects will always be returned, regardless of the field options.
 */
export type Parameterfields = Array<string>;

/**
 * Globally unique identifier for the goal.
 */
export type Parametergoal_path_gid = string;

/**
 * Globally unique identifier for the goal relationship.
 */
export type Parametergoal_relationship_path_gid = string;

/**
 * Globally unique identifier for the job.
 */
export type Parameterjob_path_gid = string;

/**
 * Results per page.
 * The number of objects to return per page. The value must be between 1 and 100.
 */
export type Parameterlimit = number;

/**
 * Member object gid can be user or team.
 *
 */
export type Parametermember = string;

/**
 * The message to get.
 */
export type Parametermessage_path_gid = string;

/**
 * Offset token.
 * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
 * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
 */
export type Parameteroffset = string;

/**
 * Globally unique identifier for the organization export.
 */
export type Parameterorganization_export_path_gid = string;

/**
 * Membership parent object gid.
 *
 */
export type Parameterparent = string;

export type Parameterportfolio_membership_path_gid = string;

/**
 * Globally unique identifier for the portfolio.
 */
export type Parameterportfolio_path_gid = string;

/**
 * The portfolio to filter results on.
 */
export type Parameterportfolio_query_param = string;

/**
 * Provides “pretty” output.
 * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
 */
export type Parameterpretty = boolean;

/**
 * Globally unique identifier for the project brief.
 */
export type Parameterproject_brief_path_gid = string;

export type Parameterproject_membership_path_gid = string;

/**
 * Globally unique identifier for the project.
 */
export type Parameterproject_path_gid = string;

/**
 * The project status update to get.
 */
export type Parameterproject_status_path_gid = string;

/**
 * Globally unique identifier for the project template.
 */
export type Parameterproject_template_path_gid = string;

/**
 * The globally unique identifier for the section.
 */
export type Parametersection_path_gid = string;

/**
 * The status update to get.
 */
export type Parameterstatus_path_gid = string;

/**
 * Globally unique identifier for the story.
 */
export type Parameterstory_path_gid = string;

/**
 * Globally unique identifier for the tag.
 */
export type Parametertag_path_gid = string;

/**
 * The task to operate on.
 */
export type Parametertask_path_gid = string;

export type Parameterteam_membership_path_gid = string;

/**
 * Globally unique identifier for the team.
 */
export type Parameterteam_path_gid = string;

/**
 * The team to filter projects on.
 */
export type Parameterteam_query_param = string;

/**
 * Globally unique identifier for the time period.
 */
export type Parametertime_period_path_gid = string;

/**
 * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
 */
export type Parameteruser_path_gid = string;

/**
 * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
 */
export type Parameteruser_query_param = string;

/**
 * Globally unique identifier for the user task list.
 */
export type Parameteruser_task_list_path_gid = string;

/**
 * Globally unique identifier for the webhook.
 */
export type Parameterwebhook_path_gid = string;

export type Parameterworkspace_membership_path_gid = string;

/**
 * Globally unique identifier for the workspace or organization.
 */
export type Parameterworkspace_path_gid = string;

/**
 * The workspace to filter results on.
 */
export type Parameterworkspace_query_param = string;

export type GetAttachmentsForObjectData = {
  query: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Globally unique identifier for object to fetch statuses from. Must be a GID for a `project`, `project_brief`, or `task`.
     */
    parent: string;
  };
};

export type GetAttachmentsForObjectResponse = {
  data?: Array<AttachmentCompact>;
};

export type GetAttachmentsForObjectError = ErrorResponse;

export type CreateAttachmentForObjectData = {
  /**
   * The file you want to upload.
   *
   * *Note when using curl:*
   *
   * Be sure to add an `‘@’` before the file path, and use the `--form`
   * option instead of the `-d` option.
   *
   * When uploading PDFs with curl, force the content-type to be pdf by
   * appending the content type to the file path: `--form
   * "file=@file.pdf;type=application/pdf"`.
   */
  body: AttachmentRequest;
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateAttachmentForObjectResponse = {
  data?: AttachmentResponse;
};

export type CreateAttachmentForObjectError = ErrorResponse;

export type DeleteAttachmentData = {
  path: {
    /**
     * Globally unique identifier for the attachment.
     */
    attachment_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteAttachmentResponse = {
  data?: EmptyResponse;
};

export type DeleteAttachmentError = ErrorResponse;

export type GetAttachmentData = {
  path: {
    /**
     * Globally unique identifier for the attachment.
     */
    attachment_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetAttachmentResponse = {
  data?: AttachmentResponse;
};

export type GetAttachmentError = ErrorResponse;

export type CreateBatchRequestData = {
  /**
   * The requests to batch together via the Batch API.
   */
  body: {
    data?: BatchRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateBatchRequestResponse = {
  data?: Array<BatchResponse>;
};

export type CreateBatchRequestError = ErrorResponse;

export type CreateCustomFieldData = {
  /**
   * The custom field object to create.
   */
  body?: {
    data?: CustomFieldRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateCustomFieldResponse = {
  data?: CustomFieldResponse;
};

export type CreateCustomFieldError = ErrorResponse;

export type DeleteCustomFieldData = {
  path: {
    /**
     * Globally unique identifier for the custom field.
     */
    custom_field_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteCustomFieldResponse = {
  data?: EmptyResponse;
};

export type DeleteCustomFieldError = ErrorResponse;

export type GetCustomFieldData = {
  path: {
    /**
     * Globally unique identifier for the custom field.
     */
    custom_field_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetCustomFieldResponse = {
  data?: CustomFieldResponse;
};

export type GetCustomFieldError = ErrorResponse;

export type UpdateCustomFieldData = {
  /**
   * The custom field object with all updated properties.
   */
  body?: {
    data?: CustomFieldRequest;
  };
  path: {
    /**
     * Globally unique identifier for the custom field.
     */
    custom_field_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateCustomFieldResponse = {
  data?: CustomFieldResponse;
};

export type UpdateCustomFieldError = ErrorResponse;

export type CreateEnumOptionForCustomFieldData = {
  /**
   * The enum option object to create.
   */
  body?: {
    data?: EnumOptionRequest;
  };
  path: {
    /**
     * Globally unique identifier for the custom field.
     */
    custom_field_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateEnumOptionForCustomFieldResponse = {
  data?: EnumOption;
};

export type CreateEnumOptionForCustomFieldError = ErrorResponse;

export type InsertEnumOptionForCustomFieldData = {
  /**
   * The enum option object to create.
   */
  body?: {
    data?: EnumOptionInsertRequest;
  };
  path: {
    /**
     * Globally unique identifier for the custom field.
     */
    custom_field_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type InsertEnumOptionForCustomFieldResponse = {
  data?: EnumOption;
};

export type InsertEnumOptionForCustomFieldError = ErrorResponse;

export type UpdateEnumOptionData = {
  /**
   * The enum option object to update
   */
  body?: {
    data?: EnumOptionRequest;
  };
  path: {
    /**
     * Globally unique identifier for the enum option.
     */
    enum_option_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateEnumOptionResponse = {
  data?: EnumOption;
};

export type UpdateEnumOptionError = ErrorResponse;

export type GetEventsData = {
  query: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * A resource ID to subscribe to. The resource can be a task or project.
     */
    resource: string;
    /**
     * A sync token received from the last request, or none on first sync. Events will be returned from the point in time that the sync token was generated.
     * *Note: On your first request, omit the sync token. The response will be the same as for an expired sync token, and will include a new valid sync token.If the sync token is too old (which may happen from time to time) the API will return a `412 Precondition Failed` error, and include a fresh sync token in the response.*
     */
    sync?: string;
  };
};

export type GetEventsResponse = {
  data?: Array<EventResponse>;
  /**
   * Indicates whether there are more events to pull.
   */
  has_more?: boolean;
  /**
   * A sync token to be used with the next call to the /events endpoint.
   */
  sync?: string;
};

export type GetEventsError = ErrorResponse;

export type GetGoalRelationshipsData = {
  query: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * If provided, filter to goal relationships with a given resource_subtype.
     */
    resource_subtype?: string;
    /**
     * Globally unique identifier for the supported goal in the goal relationship.
     */
    supported_goal: string;
  };
};

export type GetGoalRelationshipsResponse = {
  data?: Array<GoalRelationshipCompact>;
};

export type GetGoalRelationshipsError = ErrorResponse;

export type GetGoalRelationshipData = {
  path: {
    /**
     * Globally unique identifier for the goal relationship.
     */
    goal_relationship_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetGoalRelationshipResponse = {
  data?: GoalRelationshipResponse;
};

export type GetGoalRelationshipError = ErrorResponse;

export type UpdateGoalRelationshipData = {
  /**
   * The updated fields for the goal relationship.
   */
  body: {
    data?: GoalRelationshipRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal relationship.
     */
    goal_relationship_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateGoalRelationshipResponse = {
  data?: GoalRelationshipResponse;
};

export type UpdateGoalRelationshipError = ErrorResponse;

export type GetGoalsData = {
  query?: {
    /**
     * Filter to goals with is_workspace_level set to query value. Must be used with the workspace parameter.
     */
    is_workspace_level?: boolean;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Globally unique identifier for supporting portfolio.
     */
    portfolio?: string;
    /**
     * Globally unique identifier for supporting project.
     */
    project?: string;
    /**
     * Globally unique identifier for the team.
     */
    team?: string;
    /**
     * Globally unique identifiers for the time periods.
     */
    time_periods?: Array<string>;
    /**
     * Globally unique identifier for the workspace.
     */
    workspace?: string;
  };
};

export type GetGoalsResponse = {
  data?: Array<GoalCompact>;
};

export type GetGoalsError = ErrorResponse;

export type CreateGoalData = {
  /**
   * The goal to create.
   */
  body: {
    data?: GoalRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateGoalResponse = {
  data?: GoalResponse;
};

export type CreateGoalError = ErrorResponse;

export type DeleteGoalData = {
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteGoalResponse = {
  data?: EmptyResponse;
};

export type DeleteGoalError = ErrorResponse;

export type GetGoalData = {
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetGoalResponse = {
  data?: GoalResponse;
};

export type GetGoalError = ErrorResponse;

export type UpdateGoalData = {
  /**
   * The updated fields for the goal.
   */
  body: {
    data?: GoalRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateGoalResponse = {
  data?: GoalResponse;
};

export type UpdateGoalError = ErrorResponse;

export type AddFollowersData = {
  /**
   * The followers to be added as collaborators
   */
  body: {
    data?: TaskAddFollowersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddFollowersResponse = {
  data?: GoalResponse;
};

export type AddFollowersError = ErrorResponse;

export type AddSupportingRelationshipData = {
  /**
   * The supporting resource to be added to the goal
   */
  body: {
    data?: GoalAddSupportingRelationshipRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddSupportingRelationshipResponse = {
  data?: GoalRelationshipResponse;
};

export type AddSupportingRelationshipError = ErrorResponse;

export type GetParentGoalsForGoalData = {
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetParentGoalsForGoalResponse = {
  data?: Array<GoalCompact>;
};

export type GetParentGoalsForGoalError = ErrorResponse;

export type RemoveFollowersData = {
  /**
   * The followers to be removed as collaborators
   */
  body: {
    data?: TaskAddFollowersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveFollowersResponse = {
  data?: GoalResponse;
};

export type RemoveFollowersError = ErrorResponse;

export type RemoveSupportingRelationshipData = {
  /**
   * The supporting resource to be removed from the goal
   */
  body: {
    data?: GoalRemoveSupportingRelationshipRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveSupportingRelationshipResponse = {
  data?: EmptyResponse;
};

export type RemoveSupportingRelationshipError = ErrorResponse;

export type CreateGoalMetricData = {
  /**
   * The goal metric to create.
   */
  body: {
    data?: GoalMetricBase;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateGoalMetricResponse = {
  data?: GoalResponse;
};

export type CreateGoalMetricError = ErrorResponse;

export type UpdateGoalMetricData = {
  /**
   * The updated fields for the goal metric.
   */
  body: {
    data?: GoalMetricCurrentValueRequest;
  };
  path: {
    /**
     * Globally unique identifier for the goal.
     */
    goal_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateGoalMetricResponse = {
  data?: GoalResponse;
};

export type UpdateGoalMetricError = ErrorResponse;

export type GetJobData = {
  path: {
    /**
     * Globally unique identifier for the job.
     */
    job_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetJobResponse = {
  data?: JobCompact;
};

export type GetJobError = ErrorResponse;

export type CreateOrganizationExportData = {
  /**
   * The organization to export.
   */
  body: {
    data?: OrganizationExportRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateOrganizationExportResponse = {
  data?: OrganizationExportCompact;
};

export type CreateOrganizationExportError = ErrorResponse;

export type GetOrganizationExportData = {
  path: {
    /**
     * Globally unique identifier for the organization export.
     */
    organization_export_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetOrganizationExportResponse = {
  data?: OrganizationExportCompact;
};

export type GetOrganizationExportError = ErrorResponse;

export type GetPortfolioMembershipsData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The portfolio to filter results on.
     */
    portfolio?: string;
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user?: string;
    /**
     * The workspace to filter results on.
     */
    workspace?: string;
  };
};

export type GetPortfolioMembershipsResponse = {
  data?: Array<PortfolioMembershipCompact>;
};

export type GetPortfolioMembershipsError = ErrorResponse;

export type GetPortfolioMembershipData = {
  path: {
    portfolio_membership_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetPortfolioMembershipResponse = {
  data?: PortfolioMembershipCompact;
};

export type GetPortfolioMembershipError = ErrorResponse;

export type GetPortfoliosData = {
  query: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The user who owns the portfolio. Currently, API users can only get a list of portfolios that they themselves own.
     */
    owner: string;
    /**
     * The workspace or organization to filter portfolios on.
     */
    workspace: string;
  };
};

export type GetPortfoliosResponse = {
  data?: Array<PortfolioCompact>;
};

export type GetPortfoliosError = ErrorResponse;

export type CreatePortfolioData = {
  /**
   * The portfolio to create.
   */
  body: {
    data?: PortfolioRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreatePortfolioResponse = {
  data?: PortfolioResponse;
};

export type CreatePortfolioError = ErrorResponse;

export type DeletePortfolioData = {
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeletePortfolioResponse = {
  data?: EmptyResponse;
};

export type DeletePortfolioError = ErrorResponse;

export type GetPortfolioData = {
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetPortfolioResponse = {
  data?: PortfolioResponse;
};

export type GetPortfolioError = ErrorResponse;

export type UpdatePortfolioData = {
  /**
   * The updated fields for the portfolio.
   */
  body: {
    data?: PortfolioRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdatePortfolioResponse = {
  data?: PortfolioResponse;
};

export type UpdatePortfolioError = ErrorResponse;

export type AddCustomFieldSettingForPortfolioData = {
  /**
   * Information about the custom field setting.
   */
  body: {
    data?: AddCustomFieldSettingRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddCustomFieldSettingForPortfolioResponse = {
  data?: CustomFieldSettingResponse;
};

export type AddCustomFieldSettingForPortfolioError = ErrorResponse;

export type AddItemForPortfolioData = {
  /**
   * Information about the item being inserted.
   */
  body: {
    data?: PortfolioAddItemRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddItemForPortfolioResponse = {
  data?: EmptyResponse;
};

export type AddItemForPortfolioError = ErrorResponse;

export type AddMembersForPortfolioData = {
  /**
   * Information about the members being added.
   */
  body: {
    data?: AddMembersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddMembersForPortfolioResponse = {
  data?: PortfolioResponse;
};

export type AddMembersForPortfolioError = ErrorResponse;

export type GetCustomFieldSettingsForPortfolioData = {
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetCustomFieldSettingsForPortfolioResponse = {
  data?: Array<CustomFieldSettingResponse>;
};

export type GetCustomFieldSettingsForPortfolioError = ErrorResponse;

export type GetItemsForPortfolioData = {
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetItemsForPortfolioResponse = {
  data?: Array<ProjectCompact>;
};

export type GetItemsForPortfolioError = ErrorResponse;

export type GetPortfolioMembershipsForPortfolioData = {
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user?: string;
  };
};

export type GetPortfolioMembershipsForPortfolioResponse = {
  data?: Array<PortfolioMembershipCompact>;
};

export type GetPortfolioMembershipsForPortfolioError = ErrorResponse;

export type RemoveCustomFieldSettingForPortfolioData = {
  /**
   * Information about the custom field setting being removed.
   */
  body: {
    data?: RemoveCustomFieldSettingRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveCustomFieldSettingForPortfolioResponse = {
  data?: EmptyResponse;
};

export type RemoveCustomFieldSettingForPortfolioError = ErrorResponse;

export type RemoveItemForPortfolioData = {
  /**
   * Information about the item being removed.
   */
  body: {
    data?: PortfolioRemoveItemRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveItemForPortfolioResponse = {
  data?: EmptyResponse;
};

export type RemoveItemForPortfolioError = ErrorResponse;

export type RemoveMembersForPortfolioData = {
  /**
   * Information about the members being removed.
   */
  body: {
    data?: RemoveMembersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the portfolio.
     */
    portfolio_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveMembersForPortfolioResponse = {
  data?: PortfolioResponse;
};

export type RemoveMembersForPortfolioError = ErrorResponse;

export type DeleteProjectBriefData = {
  path: {
    /**
     * Globally unique identifier for the project brief.
     */
    project_brief_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteProjectBriefResponse = {
  data?: EmptyResponse;
};

export type DeleteProjectBriefError = ErrorResponse;

export type GetProjectBriefData = {
  path: {
    /**
     * Globally unique identifier for the project brief.
     */
    project_brief_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectBriefResponse = {
  data?: ProjectBriefResponse;
};

export type GetProjectBriefError = ErrorResponse;

export type UpdateProjectBriefData = {
  /**
   * The updated fields for the project brief.
   */
  body: {
    data?: ProjectBriefRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project brief.
     */
    project_brief_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateProjectBriefResponse = {
  data?: ProjectBriefResponse;
};

export type UpdateProjectBriefError = ErrorResponse;

export type GetProjectMembershipData = {
  path: {
    project_membership_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectMembershipResponse = {
  data?: ProjectMembershipResponse;
};

export type GetProjectMembershipError = ErrorResponse;

export type DeleteProjectStatusData = {
  path: {
    /**
     * The project status update to get.
     */
    project_status_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteProjectStatusResponse = {
  data?: EmptyResponse;
};

export type DeleteProjectStatusError = ErrorResponse;

export type GetProjectStatusData = {
  path: {
    /**
     * The project status update to get.
     */
    project_status_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectStatusResponse = {
  data?: ProjectStatusResponse;
};

export type GetProjectStatusError = ErrorResponse;

export type GetProjectTemplatesData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The team to filter projects on.
     */
    team?: string;
    /**
     * The workspace to filter results on.
     */
    workspace?: string;
  };
};

export type GetProjectTemplatesResponse = {
  data?: Array<ProjectTemplateCompact>;
};

export type GetProjectTemplatesError = ErrorResponse;

export type GetProjectTemplateData = {
  path: {
    /**
     * Globally unique identifier for the project template.
     */
    project_template_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectTemplateResponse = {
  data?: ProjectTemplateResponse;
};

export type GetProjectTemplateError = ErrorResponse;

export type InstantiateProjectData = {
  /**
   * Describes the inputs used for instantiating a project, such as the resulting project's name, which team it should be created in, and values for date variables.
   */
  body?: {
    data?: ProjectTemplateInstantiateProjectRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project template.
     */
    project_template_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type InstantiateProjectResponse = {
  data?: JobCompact;
};

export type InstantiateProjectError = ErrorResponse;

export type GetProjectsData = {
  query?: {
    /**
     * Only return projects whose `archived` field takes on the value of this parameter.
     */
    archived?: boolean;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The team to filter projects on.
     */
    team?: string;
    /**
     * The workspace or organization to filter projects on.
     */
    workspace?: string;
  };
};

export type GetProjectsResponse = {
  data?: Array<ProjectCompact>;
};

export type GetProjectsError = ErrorResponse;

export type CreateProjectData = {
  /**
   * The project to create.
   */
  body: {
    data?: ProjectRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateProjectResponse = {
  data?: ProjectResponse;
};

export type CreateProjectError = ErrorResponse;

export type DeleteProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteProjectResponse = {
  data?: EmptyResponse;
};

export type DeleteProjectError = ErrorResponse;

export type GetProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectResponse = {
  data?: ProjectResponse;
};

export type GetProjectError = ErrorResponse;

export type UpdateProjectData = {
  /**
   * The updated fields for the project.
   */
  body: {
    data?: ProjectRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateProjectResponse = {
  data?: ProjectResponse;
};

export type UpdateProjectError = ErrorResponse;

export type AddCustomFieldSettingForProjectData = {
  /**
   * Information about the custom field setting.
   */
  body: {
    data?: AddCustomFieldSettingRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddCustomFieldSettingForProjectResponse = {
  data?: CustomFieldSettingResponse;
};

export type AddCustomFieldSettingForProjectError = ErrorResponse;

export type AddFollowersForProjectData = {
  /**
   * Information about the followers being added.
   */
  body: {
    data?: AddFollowersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddFollowersForProjectResponse = {
  data?: ProjectResponse;
};

export type AddFollowersForProjectError = ErrorResponse;

export type AddMembersForProjectData = {
  /**
   * Information about the members being added.
   */
  body: {
    data?: AddMembersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddMembersForProjectResponse = {
  data?: ProjectResponse;
};

export type AddMembersForProjectError = ErrorResponse;

export type GetCustomFieldSettingsForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetCustomFieldSettingsForProjectResponse = {
  data?: Array<CustomFieldSettingResponse>;
};

export type GetCustomFieldSettingsForProjectError = ErrorResponse;

export type DuplicateProjectData = {
  /**
   * Describes the duplicate's name and the elements that will be duplicated.
   */
  body?: {
    data?: ProjectDuplicateRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DuplicateProjectResponse = {
  data?: JobCompact;
};

export type DuplicateProjectError = ErrorResponse;

export type CreateProjectBriefData = {
  /**
   * The project brief to create.
   */
  body: {
    data?: ProjectBriefRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateProjectBriefResponse = {
  data?: ProjectBriefResponse;
};

export type CreateProjectBriefError = ErrorResponse;

export type GetProjectMembershipsForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user?: string;
  };
};

export type GetProjectMembershipsForProjectResponse = {
  data?: Array<ProjectMembershipCompact>;
};

export type GetProjectMembershipsForProjectError = ErrorResponse;

export type GetProjectStatusesForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectStatusesForProjectResponse = {
  data?: Array<ProjectStatusCompact>;
};

export type GetProjectStatusesForProjectError = ErrorResponse;

export type CreateProjectStatusForProjectData = {
  /**
   * The project status to create.
   */
  body: {
    data?: ProjectStatusBase;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateProjectStatusForProjectResponse = {
  data?: ProjectStatusResponse;
};

export type CreateProjectStatusForProjectError = ErrorResponse;

export type RemoveCustomFieldSettingForProjectData = {
  /**
   * Information about the custom field setting being removed.
   */
  body: {
    data?: RemoveCustomFieldSettingRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveCustomFieldSettingForProjectResponse = {
  data?: EmptyResponse;
};

export type RemoveCustomFieldSettingForProjectError = ErrorResponse;

export type RemoveFollowersForProjectData = {
  /**
   * Information about the followers being removed.
   */
  body: {
    data?: RemoveFollowersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveFollowersForProjectResponse = {
  data?: ProjectResponse;
};

export type RemoveFollowersForProjectError = ErrorResponse;

export type RemoveMembersForProjectData = {
  /**
   * Information about the members being removed.
   */
  body: {
    data?: RemoveMembersRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveMembersForProjectResponse = {
  data?: ProjectResponse;
};

export type RemoveMembersForProjectError = ErrorResponse;

export type ProjectSaveAsTemplateData = {
  /**
   * Describes the inputs used for creating a project template, such as the resulting project template's name, which team it should be created in.
   */
  body: {
    data?: ProjectSaveAsTemplateRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type ProjectSaveAsTemplateResponse = {
  data?: JobCompact;
};

export type ProjectSaveAsTemplateError = ErrorResponse;

export type GetSectionsForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetSectionsForProjectResponse = {
  data?: Array<SectionCompact>;
};

export type GetSectionsForProjectError = ErrorResponse;

export type CreateSectionForProjectData = {
  /**
   * The section to create.
   */
  body: {
    data?: SectionRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateSectionForProjectResponse = {
  data?: SectionResponse;
};

export type CreateSectionForProjectError = ErrorResponse;

export type InsertSectionForProjectData = {
  /**
   * The section's move action.
   */
  body: {
    data?: ProjectSectionInsertRequest;
  };
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type InsertSectionForProjectResponse = {
  data?: EmptyResponse;
};

export type InsertSectionForProjectError = ErrorResponse;

export type GetTaskCountsForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTaskCountsForProjectResponse = {
  data?: TaskCountResponse;
};

export type GetTaskCountsForProjectError = ErrorResponse;

export type GetTasksForProjectData = {
  path: {
    /**
     * Globally unique identifier for the project.
     */
    project_gid: string;
  };
  query?: {
    /**
     * Only return tasks that are either incomplete or that have been completed since this time. Accepts a date-time string or the keyword *now*.
     *
     */
    completed_since?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTasksForProjectResponse = {
  data?: Array<TaskCompact>;
};

export type GetTasksForProjectError = ErrorResponse;

export type DeleteSectionData = {
  path: {
    /**
     * The globally unique identifier for the section.
     */
    section_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteSectionResponse = {
  data?: EmptyResponse;
};

export type DeleteSectionError = ErrorResponse;

export type GetSectionData = {
  path: {
    /**
     * The globally unique identifier for the section.
     */
    section_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetSectionResponse = {
  data?: SectionResponse;
};

export type GetSectionError = ErrorResponse;

export type UpdateSectionData = {
  /**
   * The section to create.
   */
  body: {
    data?: SectionRequest;
  };
  path: {
    /**
     * The globally unique identifier for the section.
     */
    section_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateSectionResponse = {
  data?: SectionResponse;
};

export type UpdateSectionError = ErrorResponse;

export type AddTaskForSectionData = {
  /**
   * The task and optionally the insert location.
   */
  body: {
    data?: SectionTaskInsertRequest;
  };
  path: {
    /**
     * The globally unique identifier for the section.
     */
    section_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddTaskForSectionResponse = {
  data?: EmptyResponse;
};

export type AddTaskForSectionError = ErrorResponse;

export type GetTasksForSectionData = {
  path: {
    /**
     * The globally unique identifier for the section.
     */
    section_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTasksForSectionResponse = {
  data?: Array<TaskCompact>;
};

export type GetTasksForSectionError = ErrorResponse;

export type GetStatusesForObjectData = {
  query: {
    /**
     * Only return statuses that have been created since the given time.
     */
    created_since?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Globally unique identifier for object to fetch statuses from. Must be a GID for a project, portfolio, or goal.
     */
    parent: string;
  };
};

export type GetStatusesForObjectResponse = {
  data?: Array<StatusUpdateCompact>;
};

export type GetStatusesForObjectError = ErrorResponse;

export type CreateStatusForObjectData = {
  /**
   * The status update to create.
   */
  body: {
    data?: StatusUpdateRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateStatusForObjectResponse = {
  data?: StatusUpdateResponse;
};

export type CreateStatusForObjectError = ErrorResponse;

export type DeleteStatusData = {
  path: {
    /**
     * The status update to get.
     */
    status_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteStatusResponse = {
  data?: EmptyResponse;
};

export type DeleteStatusError = ErrorResponse;

export type GetStatusData = {
  path: {
    /**
     * The status update to get.
     */
    status_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetStatusResponse = {
  data?: StatusUpdateResponse;
};

export type GetStatusError = ErrorResponse;

export type DeleteStoryData = {
  path: {
    /**
     * Globally unique identifier for the story.
     */
    story_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteStoryResponse = {
  data?: EmptyResponse;
};

export type DeleteStoryError = ErrorResponse;

export type GetStoryData = {
  path: {
    /**
     * Globally unique identifier for the story.
     */
    story_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetStoryResponse = {
  data?: StoryResponse;
};

export type GetStoryError = ErrorResponse;

export type UpdateStoryData = {
  /**
   * The comment story to update.
   */
  body: {
    data?: StoryBase;
  };
  path: {
    /**
     * Globally unique identifier for the story.
     */
    story_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateStoryResponse = {
  data?: StoryResponse;
};

export type UpdateStoryError = ErrorResponse;

export type GetTagsData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The workspace to filter tags on.
     */
    workspace?: string;
  };
};

export type GetTagsResponse = {
  data?: Array<TagCompact>;
};

export type GetTagsError = ErrorResponse;

export type CreateTagData = {
  /**
   * The tag to create.
   */
  body: {
    data?: TagRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateTagResponse = {
  data?: TagResponse;
};

export type CreateTagError = ErrorResponse;

export type DeleteTagData = {
  path: {
    /**
     * Globally unique identifier for the tag.
     */
    tag_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteTagResponse = {
  data?: EmptyResponse;
};

export type DeleteTagError = ErrorResponse;

export type GetTagData = {
  path: {
    /**
     * Globally unique identifier for the tag.
     */
    tag_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTagResponse = {
  data?: TagResponse;
};

export type GetTagError = ErrorResponse;

export type UpdateTagData = {
  path: {
    /**
     * Globally unique identifier for the tag.
     */
    tag_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateTagResponse = {
  data?: TagResponse;
};

export type UpdateTagError = ErrorResponse;

export type GetTasksForTagData = {
  path: {
    /**
     * Globally unique identifier for the tag.
     */
    tag_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTasksForTagResponse = {
  data?: Array<TaskCompact>;
};

export type GetTasksForTagError = ErrorResponse;

export type GetTasksData = {
  query?: {
    /**
     * The assignee to filter tasks on. If searching for unassigned tasks, assignee.any = null can be specified.
     * *Note: If you specify `assignee`, you must also specify the `workspace` to filter on.*
     */
    assignee?: string;
    /**
     * Only return tasks that are either incomplete or that have been completed since this time.
     */
    completed_since?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Only return tasks that have been modified since the given time.
     *
     * *Note: A task is considered “modified” if any of its properties
     * change, or associations between it and other objects are modified
     * (e.g.  a task being added to a project). A task is not considered
     * modified just because another object it is associated with (e.g. a
     * subtask) is modified. Actions that count as modifying the task
     * include assigning, renaming, completing, and adding stories.*
     */
    modified_since?: string;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The project to filter tasks on.
     */
    project?: string;
    /**
     * The section to filter tasks on.
     * *Note: Currently, this is only supported in board views.*
     */
    section?: string;
    /**
     * The workspace to filter tasks on.
     * *Note: If you specify `workspace`, you must also specify the `assignee` to filter on.*
     */
    workspace?: string;
  };
};

export type GetTasksResponse = {
  data?: Array<TaskCompact>;
};

export type GetTasksError = ErrorResponse;

export type CreateTaskData = {
  /**
   * The task to create.
   */
  body: {
    data?: TaskRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateTaskResponse = {
  data?: TaskResponse;
};

export type CreateTaskError = ErrorResponse;

export type DeleteTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteTaskResponse = {
  data?: EmptyResponse;
};

export type DeleteTaskError = ErrorResponse;

export type GetTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTaskResponse = {
  data?: TaskResponse;
};

export type GetTaskError = ErrorResponse;

export type UpdateTaskData = {
  /**
   * The task to update.
   */
  body: {
    data?: TaskRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateTaskResponse = {
  data?: TaskResponse;
};

export type UpdateTaskError = ErrorResponse;

export type AddDependenciesForTaskData = {
  /**
   * The list of tasks to set as dependencies.
   */
  body: {
    data?: ModifyDependenciesRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddDependenciesForTaskResponse = {
  data?: EmptyResponse;
};

export type AddDependenciesForTaskError = ErrorResponse;

export type AddDependentsForTaskData = {
  /**
   * The list of tasks to add as dependents.
   */
  body: {
    data?: ModifyDependentsRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddDependentsForTaskResponse = {
  data?: EmptyResponse;
};

export type AddDependentsForTaskError = ErrorResponse;

export type AddFollowersForTaskData = {
  /**
   * The followers to add to the task.
   */
  body: {
    data?: TaskAddFollowersRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddFollowersForTaskResponse = {
  data?: TaskResponse;
};

export type AddFollowersForTaskError = ErrorResponse;

export type AddProjectForTaskData = {
  /**
   * The project to add the task to.
   */
  body: {
    data?: TaskAddProjectRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddProjectForTaskResponse = {
  data?: EmptyResponse;
};

export type AddProjectForTaskError = ErrorResponse;

export type AddTagForTaskData = {
  /**
   * The tag to add to the task.
   */
  body: {
    data?: TaskAddTagRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddTagForTaskResponse = {
  data?: EmptyResponse;
};

export type AddTagForTaskError = ErrorResponse;

export type GetDependenciesForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetDependenciesForTaskResponse = {
  data?: Array<TaskCompact>;
};

export type GetDependenciesForTaskError = ErrorResponse;

export type GetDependentsForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetDependentsForTaskResponse = {
  data?: Array<TaskCompact>;
};

export type GetDependentsForTaskError = ErrorResponse;

export type DuplicateTaskData = {
  /**
   * Describes the duplicate's name and the fields that will be duplicated.
   */
  body: {
    data?: TaskDuplicateRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DuplicateTaskResponse = {
  data?: JobCompact;
};

export type DuplicateTaskError = ErrorResponse;

export type GetProjectsForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectsForTaskResponse = {
  data?: Array<ProjectCompact>;
};

export type GetProjectsForTaskError = ErrorResponse;

export type RemoveDependenciesForTaskData = {
  /**
   * The list of tasks to unlink as dependencies.
   */
  body: {
    data?: ModifyDependenciesRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveDependenciesForTaskResponse = {
  data?: EmptyResponse;
};

export type RemoveDependenciesForTaskError = ErrorResponse;

export type RemoveDependentsForTaskData = {
  /**
   * The list of tasks to remove as dependents.
   */
  body: {
    data?: ModifyDependentsRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveDependentsForTaskResponse = {
  data?: EmptyResponse;
};

export type RemoveDependentsForTaskError = ErrorResponse;

export type RemoveFollowerForTaskData = {
  /**
   * The followers to remove from the task.
   */
  body: {
    data?: TaskRemoveFollowersRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveFollowerForTaskResponse = {
  data?: TaskResponse;
};

export type RemoveFollowerForTaskError = ErrorResponse;

export type RemoveProjectForTaskData = {
  /**
   * The project to remove the task from.
   */
  body: {
    data?: TaskRemoveProjectRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveProjectForTaskResponse = {
  data?: EmptyResponse;
};

export type RemoveProjectForTaskError = ErrorResponse;

export type RemoveTagForTaskData = {
  /**
   * The tag to remove from the task.
   */
  body: {
    data?: TaskRemoveTagRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveTagForTaskResponse = {
  data?: EmptyResponse;
};

export type RemoveTagForTaskError = ErrorResponse;

export type SetParentForTaskData = {
  /**
   * The new parent of the subtask.
   */
  body: {
    data?: TaskSetParentRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type SetParentForTaskResponse = {
  data?: TaskResponse;
};

export type SetParentForTaskError = ErrorResponse;

export type GetStoriesForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetStoriesForTaskResponse = {
  data?: unknown;
};

export type GetStoriesForTaskError = ErrorResponse;

export type CreateStoryForTaskData = {
  /**
   * The story to create.
   */
  body: {
    data?: StoryBase;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateStoryForTaskResponse = {
  data?: StoryResponse;
};

export type CreateStoryForTaskError = ErrorResponse;

export type GetSubtasksForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetSubtasksForTaskResponse = {
  data?: Array<TaskCompact>;
};

export type GetSubtasksForTaskError = ErrorResponse;

export type CreateSubtaskForTaskData = {
  /**
   * The new subtask to create.
   */
  body: {
    data?: TaskRequest;
  };
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateSubtaskForTaskResponse = {
  data?: TaskResponse;
};

export type CreateSubtaskForTaskError = ErrorResponse;

export type GetTagsForTaskData = {
  path: {
    /**
     * The task to operate on.
     */
    task_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTagsForTaskResponse = {
  data?: Array<TagCompact>;
};

export type GetTagsForTaskError = ErrorResponse;

export type GetTeamMembershipsData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Globally unique identifier for the team.
     */
    team?: string;
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user. This parameter must be used with the workspace parameter.
     */
    user?: string;
    /**
     * Globally unique identifier for the workspace. This parameter must be used with the user parameter.
     */
    workspace?: string;
  };
};

export type GetTeamMembershipsResponse = {
  data?: Array<TeamMembershipCompact>;
};

export type GetTeamMembershipsError = ErrorResponse;

export type GetTeamMembershipData = {
  path: {
    team_membership_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTeamMembershipResponse = {
  data?: TeamMembershipCompact;
};

export type GetTeamMembershipError = ErrorResponse;

export type CreateTeamData = {
  /**
   * The team to create.
   */
  body: {
    data?: TeamRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateTeamResponse = {
  data?: TeamResponse;
};

export type CreateTeamError = ErrorResponse;

export type UpdateTeamData = {
  /**
   * The team to update.
   */
  body: {
    data?: TeamRequest;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateTeamResponse = {
  data?: TeamResponse;
};

export type UpdateTeamError = ErrorResponse;

export type GetTeamData = {
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTeamResponse = {
  data?: TeamResponse;
};

export type GetTeamError = ErrorResponse;

export type AddUserForTeamData = {
  /**
   * The user to add to the team.
   */
  body: {
    data?: TeamAddUserRequest;
  };
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddUserForTeamResponse = {
  data?: TeamMembershipCompact;
};

export type AddUserForTeamError = ErrorResponse;

export type GetProjectTemplatesForTeamData = {
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectTemplatesForTeamResponse = {
  data?: Array<ProjectTemplateCompact>;
};

export type GetProjectTemplatesForTeamError = ErrorResponse;

export type GetProjectsForTeamData = {
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Only return projects whose `archived` field takes on the value of this parameter.
     */
    archived?: boolean;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectsForTeamResponse = {
  data?: Array<ProjectCompact>;
};

export type GetProjectsForTeamError = ErrorResponse;

export type CreateProjectForTeamData = {
  /**
   * The new project to create.
   */
  body: {
    data?: ProjectRequest;
  };
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateProjectForTeamResponse = {
  data?: ProjectResponse;
};

export type CreateProjectForTeamError = ErrorResponse;

export type RemoveUserForTeamData = {
  /**
   * The user to remove from the team.
   */
  body: {
    data?: TeamRemoveUserRequest;
  };
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveUserForTeamResponse = {
  data?: EmptyResponse;
};

export type RemoveUserForTeamError = ErrorResponse;

export type GetTeamMembershipsForTeamData = {
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTeamMembershipsForTeamResponse = {
  data?: Array<TeamMembershipCompact>;
};

export type GetTeamMembershipsForTeamError = ErrorResponse;

export type GetUsersForTeamData = {
  path: {
    /**
     * Globally unique identifier for the team.
     */
    team_gid: string;
  };
  query?: {
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetUsersForTeamResponse = {
  data?: Array<UserCompact>;
};

export type GetUsersForTeamError = ErrorResponse;

export type GetTimePeriodsData = {
  query: {
    /**
     * ISO 8601 date string
     */
    end_on?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * ISO 8601 date string
     */
    start_on?: string;
    /**
     * Globally unique identifier for the workspace.
     */
    workspace: string;
  };
};

export type GetTimePeriodsResponse = {
  data?: Array<TimePeriodCompact>;
};

export type GetTimePeriodsError = ErrorResponse;

export type GetTimePeriodData = {
  path: {
    /**
     * Globally unique identifier for the time period.
     */
    time_period_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTimePeriodResponse = {
  data?: TimePeriodResponse;
};

export type GetTimePeriodError = ErrorResponse;

export type GetUserTaskListData = {
  path: {
    /**
     * Globally unique identifier for the user task list.
     */
    user_task_list_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetUserTaskListResponse = {
  data?: UserTaskListCompact;
};

export type GetUserTaskListError = ErrorResponse;

export type GetTasksForUserTaskListData = {
  path: {
    /**
     * Globally unique identifier for the user task list.
     */
    user_task_list_gid: string;
  };
  query?: {
    /**
     * Only return tasks that are either incomplete or that have been completed since this time. Accepts a date-time string or the keyword *now*.
     *
     */
    completed_since?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTasksForUserTaskListResponse = {
  data?: Array<TaskCompact>;
};

export type GetTasksForUserTaskListError = ErrorResponse;

export type GetUsersData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The team ID to filter users on.
     */
    team?: string;
    /**
     * The workspace or organization ID to filter users on.
     */
    workspace?: string;
  };
};

export type GetUsersResponse = {
  data?: Array<UserCompact>;
};

export type GetUsersError = ErrorResponse;

export type GetUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetUserResponse = {
  data?: UserResponse;
};

export type GetUserError = ErrorResponse;

export type GetFavoritesForUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The resource type of favorites to be returned.
     */
    resource_type: 'portfolio' | 'project' | 'tag' | 'task' | 'user' | 'project_template';
    /**
     * The workspace in which to get favorites.
     */
    workspace: string;
  };
};

export type GetFavoritesForUserResponse = {
  data?: Array<AsanaNamedResource>;
};

export type GetFavoritesForUserError = ErrorResponse;

export type GetTeamMembershipsForUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Globally unique identifier for the workspace.
     */
    workspace: string;
  };
};

export type GetTeamMembershipsForUserResponse = {
  data?: Array<TeamMembershipCompact>;
};

export type GetTeamMembershipsForUserError = ErrorResponse;

export type GetTeamsForUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The workspace or organization to filter teams on.
     */
    organization: string;
  };
};

export type GetTeamsForUserResponse = {
  data?: Array<TeamCompact>;
};

export type GetTeamsForUserError = ErrorResponse;

export type GetUserTaskListForUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The workspace in which to get the user task list.
     */
    workspace: string;
  };
};

export type GetUserTaskListForUserResponse = {
  data?: UserTaskListCompact;
};

export type GetUserTaskListForUserError = ErrorResponse;

export type GetWorkspaceMembershipsForUserData = {
  path: {
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetWorkspaceMembershipsForUserResponse = {
  data?: Array<WorkspaceMembershipCompact>;
};

export type GetWorkspaceMembershipsForUserError = ErrorResponse;

export type GetWebhooksData = {
  query: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Only return webhooks for the given resource.
     */
    resource?: string;
    /**
     * The workspace to query for webhooks in.
     */
    workspace: string;
  };
};

export type GetWebhooksResponse = {
  data?: Array<WebhookResponse>;
};

export type GetWebhooksError = ErrorResponse;

export type CreateWebhookData = {
  /**
   * The webhook workspace and target.
   */
  body: {
    data?: WebhookRequest;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateWebhookResponse = {
  data?: WebhookResponse;
};

export type CreateWebhookError = ErrorResponse;

export type DeleteWebhookData = {
  path: {
    /**
     * Globally unique identifier for the webhook.
     */
    webhook_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type DeleteWebhookResponse = {
  data?: EmptyResponse;
};

export type DeleteWebhookError = ErrorResponse;

export type GetWebhookData = {
  path: {
    /**
     * Globally unique identifier for the webhook.
     */
    webhook_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetWebhookResponse = {
  data?: WebhookResponse;
};

export type GetWebhookError = ErrorResponse;

export type UpdateWebhookData = {
  /**
   * The updated filters for the webhook.
   */
  body: {
    data?: WebhookUpdateRequest;
  };
  path: {
    /**
     * Globally unique identifier for the webhook.
     */
    webhook_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateWebhookResponse = {
  data?: WebhookResponse;
};

export type UpdateWebhookError = ErrorResponse;

export type GetWorkspaceMembershipData = {
  path: {
    workspace_membership_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetWorkspaceMembershipResponse = {
  data?: WorkspaceMembershipResponse;
};

export type GetWorkspaceMembershipError = ErrorResponse;

export type GetWorkspacesData = {
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetWorkspacesResponse = {
  data?: Array<WorkspaceCompact>;
};

export type GetWorkspacesError = ErrorResponse;

export type GetWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetWorkspaceResponse = {
  data?: WorkspaceResponse;
};

export type GetWorkspaceError = ErrorResponse;

export type UpdateWorkspaceData = {
  /**
   * The workspace object with all updated properties.
   */
  body: {
    data?: WorkspaceCompact;
  };
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type UpdateWorkspaceResponse = {
  data?: WorkspaceResponse;
};

export type UpdateWorkspaceError = ErrorResponse;

export type AddUserForWorkspaceData = {
  /**
   * The user to add to the workspace.
   */
  body: {
    data?: WorkspaceAddUserRequest;
  };
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type AddUserForWorkspaceResponse = {
  data?: UserBaseResponse;
};

export type AddUserForWorkspaceError = ErrorResponse;

export type GetAuditLogEventsData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Filter to events triggered by the actor with this ID.
     */
    actor_gid?: string;
    /**
     * Filter to events with an actor of this type.
     * This only needs to be included if querying for actor types without an ID. If `actor_gid` is included, this should be excluded.
     */
    actor_type?: 'user' | 'asana' | 'asana_support' | 'anonymous' | 'external_administrator';
    /**
     * Filter to events created before this time (exclusive).
     */
    end_at?: string;
    /**
     * Filter to events of this type.
     * Refer to the [Supported AuditLogEvents](/docs/supported-auditlogevents) for a full list of values.
     */
    event_type?: string;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Filter to events with this resource ID.
     */
    resource_gid?: string;
    /**
     * Filter to events created after this time (inclusive).
     */
    start_at?: string;
  };
};

export type GetAuditLogEventsResponse = {
  data?: Array<AuditLogEvent>;
};

export type GetAuditLogEventsError = ErrorResponse;

export type GetCustomFieldsForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetCustomFieldsForWorkspaceResponse = {
  data?: Array<CustomFieldResponse>;
};

export type GetCustomFieldsForWorkspaceError = ErrorResponse;

export type GetProjectsForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Only return projects whose `archived` field takes on the value of this parameter.
     */
    archived?: boolean;
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetProjectsForWorkspaceResponse = {
  data?: Array<ProjectCompact>;
};

export type GetProjectsForWorkspaceError = ErrorResponse;

export type CreateProjectForWorkspaceData = {
  /**
   * The new project to create.
   */
  body: {
    data?: ProjectRequest;
  };
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateProjectForWorkspaceResponse = {
  data?: ProjectResponse;
};

export type CreateProjectForWorkspaceError = ErrorResponse;

export type RemoveUserForWorkspaceData = {
  /**
   * The user to remove from the workspace.
   */
  body: {
    data?: WorkspaceRemoveUserRequest;
  };
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type RemoveUserForWorkspaceResponse = {
  data?: EmptyResponse;
};

export type RemoveUserForWorkspaceError = ErrorResponse;

export type GetTagsForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTagsForWorkspaceResponse = {
  data?: Array<TagCompact>;
};

export type GetTagsForWorkspaceError = ErrorResponse;

export type CreateTagForWorkspaceData = {
  /**
   * The tag to create.
   */
  body: {
    data?: TagResponse;
  };
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type CreateTagForWorkspaceResponse = {
  data?: TagResponse;
};

export type CreateTagForWorkspaceError = ErrorResponse;

export type SearchTasksForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Comma-separated list of user identifiers
     */
    'assigned_by.any'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'assigned_by.not'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'assignee.any'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'assignee.not'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'commented_on_by.not'?: string;
    /**
     * Filter to completed tasks
     */
    completed?: boolean;
    /**
     * ISO 8601 datetime string
     */
    'completed_at.after'?: string;
    /**
     * ISO 8601 datetime string
     */
    'completed_at.before'?: string;
    /**
     * ISO 8601 date string or `null`
     */
    completed_on?: string | null;
    /**
     * ISO 8601 date string
     */
    'completed_on.after'?: string;
    /**
     * ISO 8601 date string
     */
    'completed_on.before'?: string;
    /**
     * ISO 8601 datetime string
     */
    'created_at.after'?: string;
    /**
     * ISO 8601 datetime string
     */
    'created_at.before'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'created_by.any'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'created_by.not'?: string;
    /**
     * ISO 8601 date string or `null`
     */
    created_on?: string | null;
    /**
     * ISO 8601 date string
     */
    'created_on.after'?: string;
    /**
     * ISO 8601 date string
     */
    'created_on.before'?: string;
    /**
     * ISO 8601 datetime string
     */
    'due_at.after'?: string;
    /**
     * ISO 8601 datetime string
     */
    'due_at.before'?: string;
    /**
     * ISO 8601 date string or `null`
     */
    due_on?: string | null;
    /**
     * ISO 8601 date string
     */
    'due_on.after'?: string;
    /**
     * ISO 8601 date string
     */
    'due_on.before'?: string;
    /**
     * Comma-separated list of user identifiers
     */
    'followers.not'?: string;
    /**
     * Filter to tasks with attachments
     */
    has_attachment?: boolean;
    /**
     * Filter to tasks with incomplete dependencies
     */
    is_blocked?: boolean;
    /**
     * Filter to incomplete tasks with dependents
     */
    is_blocking?: boolean;
    /**
     * Filter to subtasks
     */
    is_subtask?: boolean;
    /**
     * Comma-separated list of user identifiers
     */
    'liked_by.not'?: string;
    /**
     * ISO 8601 datetime string
     */
    'modified_at.after'?: string;
    /**
     * ISO 8601 datetime string
     */
    'modified_at.before'?: string;
    /**
     * ISO 8601 date string or `null`
     */
    modified_on?: string | null;
    /**
     * ISO 8601 date string
     */
    'modified_on.after'?: string;
    /**
     * ISO 8601 date string
     */
    'modified_on.before'?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * Comma-separated list of portfolio IDs
     */
    'portfolios.any'?: string;
    /**
     * Comma-separated list of project IDs
     */
    'projects.all'?: string;
    /**
     * Comma-separated list of project IDs
     */
    'projects.any'?: string;
    /**
     * Comma-separated list of project IDs
     */
    'projects.not'?: string;
    /**
     * Filters results by the task's resource_subtype
     */
    resource_subtype?: 'default_task' | 'milestone';
    /**
     * Comma-separated list of section or column IDs
     */
    'sections.all'?: string;
    /**
     * Comma-separated list of section or column IDs
     */
    'sections.any'?: string;
    /**
     * Comma-separated list of section or column IDs
     */
    'sections.not'?: string;
    /**
     * Default `false`
     */
    sort_ascending?: boolean;
    /**
     * One of `due_date`, `created_at`, `completed_at`, `likes`, or `modified_at`, defaults to `modified_at`
     */
    sort_by?: 'due_date' | 'created_at' | 'completed_at' | 'likes' | 'modified_at';
    /**
     * ISO 8601 date string or `null`
     */
    start_on?: string | null;
    /**
     * ISO 8601 date string
     */
    'start_on.after'?: string;
    /**
     * ISO 8601 date string
     */
    'start_on.before'?: string;
    /**
     * Comma-separated list of tag IDs
     */
    'tags.all'?: string;
    /**
     * Comma-separated list of tag IDs
     */
    'tags.any'?: string;
    /**
     * Comma-separated list of tag IDs
     */
    'tags.not'?: string;
    /**
     * Comma-separated list of team IDs
     */
    'teams.any'?: string;
    /**
     * Performs full-text search on both task name and description
     */
    text?: string;
  };
};

export type SearchTasksForWorkspaceResponse = {
  data?: Array<TaskCompact>;
};

export type SearchTasksForWorkspaceError = ErrorResponse;

export type GetTeamsForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetTeamsForWorkspaceResponse = {
  data?: Array<TeamCompact>;
};

export type GetTeamsForWorkspaceError = ErrorResponse;

export type TypeaheadForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query: {
    /**
     * The number of results to return. The default is 20 if this parameter is omitted, with a minimum of 1 and a maximum of 100. If there are fewer results found than requested, all will be returned.
     */
    count?: number;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * The string that will be used to search for relevant objects. If an empty string is passed in, the API will return results.
     */
    query?: string;
    /**
     * The type of values the typeahead should return. You can choose from one of the following: `custom_field`, `project`, `project_template`, `portfolio`, `tag`, `task`, and `user`. Note that unlike in the names of endpoints, the types listed here are in singular form (e.g. `task`). Using multiple types is not yet supported.
     */
    resource_type: 'custom_field' | 'project' | 'project_template' | 'portfolio' | 'tag' | 'task' | 'user';
    /**
     * *Deprecated: new integrations should prefer the resource_type field.*
     */
    type?: 'custom_field' | 'portfolio' | 'project' | 'tag' | 'task' | 'user';
  };
};

export type TypeaheadForWorkspaceResponse = {
  data?: Array<AsanaNamedResource>;
};

export type TypeaheadForWorkspaceError = ErrorResponse;

export type GetUsersForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
  };
};

export type GetUsersForWorkspaceResponse = {
  data?: Array<UserCompact>;
};

export type GetUsersForWorkspaceError = ErrorResponse;

export type GetWorkspaceMembershipsForWorkspaceData = {
  path: {
    /**
     * Globally unique identifier for the workspace or organization.
     */
    workspace_gid: string;
  };
  query?: {
    /**
     * Results per page.
     * The number of objects to return per page. The value must be between 1 and 100.
     */
    limit?: number;
    /**
     * Offset token.
     * An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results.
     * 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
     */
    offset?: string;
    /**
     * Defines fields to return.
     * Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below.
     * The id of included objects will always be returned, regardless of the field options.
     */
    opt_fields?: Array<string>;
    /**
     * Provides “pretty” output.
     * Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
     */
    opt_pretty?: boolean;
    /**
     * A string identifying a user. This can either be the string "me", an email, or the gid of a user.
     */
    user?: string;
  };
};

export type GetWorkspaceMembershipsForWorkspaceResponse = {
  data?: Array<WorkspaceMembershipCompact>;
};

export type GetWorkspaceMembershipsForWorkspaceError = unknown;
