// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  GetAttachmentsForObjectData,
  GetAttachmentsForObjectError,
  GetAttachmentsForObjectResponse,
  CreateAttachmentForObjectData,
  CreateAttachmentForObjectError,
  CreateAttachmentForObjectResponse,
  DeleteAttachmentData,
  DeleteAttachmentError,
  DeleteAttachmentResponse,
  GetAttachmentData,
  GetAttachmentError,
  GetAttachmentResponse,
  CreateBatchRequestData,
  CreateBatchRequestError,
  CreateBatchRequestResponse,
  CreateCustomFieldData,
  CreateCustomFieldError,
  CreateCustomFieldResponse,
  DeleteCustomFieldData,
  DeleteCustomFieldError,
  DeleteCustomFieldResponse,
  GetCustomFieldData,
  GetCustomFieldError,
  GetCustomFieldResponse,
  UpdateCustomFieldData,
  UpdateCustomFieldError,
  UpdateCustomFieldResponse,
  CreateEnumOptionForCustomFieldData,
  CreateEnumOptionForCustomFieldError,
  CreateEnumOptionForCustomFieldResponse,
  InsertEnumOptionForCustomFieldData,
  InsertEnumOptionForCustomFieldError,
  InsertEnumOptionForCustomFieldResponse,
  UpdateEnumOptionData,
  UpdateEnumOptionError,
  UpdateEnumOptionResponse,
  GetEventsData,
  GetEventsError,
  GetEventsResponse,
  GetGoalRelationshipsData,
  GetGoalRelationshipsError,
  GetGoalRelationshipsResponse,
  GetGoalRelationshipData,
  GetGoalRelationshipError,
  GetGoalRelationshipResponse,
  UpdateGoalRelationshipData,
  UpdateGoalRelationshipError,
  UpdateGoalRelationshipResponse,
  GetGoalsData,
  GetGoalsError,
  GetGoalsResponse,
  CreateGoalData,
  CreateGoalError,
  CreateGoalResponse,
  DeleteGoalData,
  DeleteGoalError,
  DeleteGoalResponse,
  GetGoalData,
  GetGoalError,
  GetGoalResponse,
  UpdateGoalData,
  UpdateGoalError,
  UpdateGoalResponse,
  AddFollowersData,
  AddFollowersError,
  AddFollowersResponse,
  AddSupportingRelationshipData,
  AddSupportingRelationshipError,
  AddSupportingRelationshipResponse,
  GetParentGoalsForGoalData,
  GetParentGoalsForGoalError,
  GetParentGoalsForGoalResponse,
  RemoveFollowersData,
  RemoveFollowersError,
  RemoveFollowersResponse,
  RemoveSupportingRelationshipData,
  RemoveSupportingRelationshipError,
  RemoveSupportingRelationshipResponse,
  CreateGoalMetricData,
  CreateGoalMetricError,
  CreateGoalMetricResponse,
  UpdateGoalMetricData,
  UpdateGoalMetricError,
  UpdateGoalMetricResponse,
  GetJobData,
  GetJobError,
  GetJobResponse,
  CreateOrganizationExportData,
  CreateOrganizationExportError,
  CreateOrganizationExportResponse,
  GetOrganizationExportData,
  GetOrganizationExportError,
  GetOrganizationExportResponse,
  GetPortfolioMembershipsData,
  GetPortfolioMembershipsError,
  GetPortfolioMembershipsResponse,
  GetPortfolioMembershipData,
  GetPortfolioMembershipError,
  GetPortfolioMembershipResponse,
  GetPortfoliosData,
  GetPortfoliosError,
  GetPortfoliosResponse,
  CreatePortfolioData,
  CreatePortfolioError,
  CreatePortfolioResponse,
  DeletePortfolioData,
  DeletePortfolioError,
  DeletePortfolioResponse,
  GetPortfolioData,
  GetPortfolioError,
  GetPortfolioResponse,
  UpdatePortfolioData,
  UpdatePortfolioError,
  UpdatePortfolioResponse,
  AddCustomFieldSettingForPortfolioData,
  AddCustomFieldSettingForPortfolioError,
  AddCustomFieldSettingForPortfolioResponse,
  AddItemForPortfolioData,
  AddItemForPortfolioError,
  AddItemForPortfolioResponse,
  AddMembersForPortfolioData,
  AddMembersForPortfolioError,
  AddMembersForPortfolioResponse,
  GetCustomFieldSettingsForPortfolioData,
  GetCustomFieldSettingsForPortfolioError,
  GetCustomFieldSettingsForPortfolioResponse,
  GetItemsForPortfolioData,
  GetItemsForPortfolioError,
  GetItemsForPortfolioResponse,
  GetPortfolioMembershipsForPortfolioData,
  GetPortfolioMembershipsForPortfolioError,
  GetPortfolioMembershipsForPortfolioResponse,
  RemoveCustomFieldSettingForPortfolioData,
  RemoveCustomFieldSettingForPortfolioError,
  RemoveCustomFieldSettingForPortfolioResponse,
  RemoveItemForPortfolioData,
  RemoveItemForPortfolioError,
  RemoveItemForPortfolioResponse,
  RemoveMembersForPortfolioData,
  RemoveMembersForPortfolioError,
  RemoveMembersForPortfolioResponse,
  DeleteProjectBriefData,
  DeleteProjectBriefError,
  DeleteProjectBriefResponse,
  GetProjectBriefData,
  GetProjectBriefError,
  GetProjectBriefResponse,
  UpdateProjectBriefData,
  UpdateProjectBriefError,
  UpdateProjectBriefResponse,
  GetProjectMembershipData,
  GetProjectMembershipError,
  GetProjectMembershipResponse,
  DeleteProjectStatusData,
  DeleteProjectStatusError,
  DeleteProjectStatusResponse,
  GetProjectStatusData,
  GetProjectStatusError,
  GetProjectStatusResponse,
  GetProjectTemplatesData,
  GetProjectTemplatesError,
  GetProjectTemplatesResponse,
  GetProjectTemplateData,
  GetProjectTemplateError,
  GetProjectTemplateResponse,
  InstantiateProjectData,
  InstantiateProjectError,
  InstantiateProjectResponse,
  GetProjectsData,
  GetProjectsError,
  GetProjectsResponse,
  CreateProjectData,
  CreateProjectError,
  CreateProjectResponse,
  DeleteProjectData,
  DeleteProjectError,
  DeleteProjectResponse,
  GetProjectData,
  GetProjectError,
  GetProjectResponse,
  UpdateProjectData,
  UpdateProjectError,
  UpdateProjectResponse,
  AddCustomFieldSettingForProjectData,
  AddCustomFieldSettingForProjectError,
  AddCustomFieldSettingForProjectResponse,
  AddFollowersForProjectData,
  AddFollowersForProjectError,
  AddFollowersForProjectResponse,
  AddMembersForProjectData,
  AddMembersForProjectError,
  AddMembersForProjectResponse,
  GetCustomFieldSettingsForProjectData,
  GetCustomFieldSettingsForProjectError,
  GetCustomFieldSettingsForProjectResponse,
  DuplicateProjectData,
  DuplicateProjectError,
  DuplicateProjectResponse,
  CreateProjectBriefData,
  CreateProjectBriefError,
  CreateProjectBriefResponse,
  GetProjectMembershipsForProjectData,
  GetProjectMembershipsForProjectError,
  GetProjectMembershipsForProjectResponse,
  GetProjectStatusesForProjectData,
  GetProjectStatusesForProjectError,
  GetProjectStatusesForProjectResponse,
  CreateProjectStatusForProjectData,
  CreateProjectStatusForProjectError,
  CreateProjectStatusForProjectResponse,
  RemoveCustomFieldSettingForProjectData,
  RemoveCustomFieldSettingForProjectError,
  RemoveCustomFieldSettingForProjectResponse,
  RemoveFollowersForProjectData,
  RemoveFollowersForProjectError,
  RemoveFollowersForProjectResponse,
  RemoveMembersForProjectData,
  RemoveMembersForProjectError,
  RemoveMembersForProjectResponse,
  ProjectSaveAsTemplateData,
  ProjectSaveAsTemplateError,
  ProjectSaveAsTemplateResponse,
  GetSectionsForProjectData,
  GetSectionsForProjectError,
  GetSectionsForProjectResponse,
  CreateSectionForProjectData,
  CreateSectionForProjectError,
  CreateSectionForProjectResponse,
  InsertSectionForProjectData,
  InsertSectionForProjectError,
  InsertSectionForProjectResponse,
  GetTaskCountsForProjectData,
  GetTaskCountsForProjectError,
  GetTaskCountsForProjectResponse,
  GetTasksForProjectData,
  GetTasksForProjectError,
  GetTasksForProjectResponse,
  DeleteSectionData,
  DeleteSectionError,
  DeleteSectionResponse,
  GetSectionData,
  GetSectionError,
  GetSectionResponse,
  UpdateSectionData,
  UpdateSectionError,
  UpdateSectionResponse,
  AddTaskForSectionData,
  AddTaskForSectionError,
  AddTaskForSectionResponse,
  GetTasksForSectionData,
  GetTasksForSectionError,
  GetTasksForSectionResponse,
  GetStatusesForObjectData,
  GetStatusesForObjectError,
  GetStatusesForObjectResponse,
  CreateStatusForObjectData,
  CreateStatusForObjectError,
  CreateStatusForObjectResponse,
  DeleteStatusData,
  DeleteStatusError,
  DeleteStatusResponse,
  GetStatusData,
  GetStatusError,
  GetStatusResponse,
  DeleteStoryData,
  DeleteStoryError,
  DeleteStoryResponse,
  GetStoryData,
  GetStoryError,
  GetStoryResponse,
  UpdateStoryData,
  UpdateStoryError,
  UpdateStoryResponse,
  GetTagsData,
  GetTagsError,
  GetTagsResponse,
  CreateTagData,
  CreateTagError,
  CreateTagResponse,
  DeleteTagData,
  DeleteTagError,
  DeleteTagResponse,
  GetTagData,
  GetTagError,
  GetTagResponse,
  UpdateTagData,
  UpdateTagError,
  UpdateTagResponse,
  GetTasksForTagData,
  GetTasksForTagError,
  GetTasksForTagResponse,
  GetTasksData,
  GetTasksError,
  GetTasksResponse,
  CreateTaskData,
  CreateTaskError,
  CreateTaskResponse,
  DeleteTaskData,
  DeleteTaskError,
  DeleteTaskResponse,
  GetTaskData,
  GetTaskError,
  GetTaskResponse,
  UpdateTaskData,
  UpdateTaskError,
  UpdateTaskResponse,
  AddDependenciesForTaskData,
  AddDependenciesForTaskError,
  AddDependenciesForTaskResponse,
  AddDependentsForTaskData,
  AddDependentsForTaskError,
  AddDependentsForTaskResponse,
  AddFollowersForTaskData,
  AddFollowersForTaskError,
  AddFollowersForTaskResponse,
  AddProjectForTaskData,
  AddProjectForTaskError,
  AddProjectForTaskResponse,
  AddTagForTaskData,
  AddTagForTaskError,
  AddTagForTaskResponse,
  GetDependenciesForTaskData,
  GetDependenciesForTaskError,
  GetDependenciesForTaskResponse,
  GetDependentsForTaskData,
  GetDependentsForTaskError,
  GetDependentsForTaskResponse,
  DuplicateTaskData,
  DuplicateTaskError,
  DuplicateTaskResponse,
  GetProjectsForTaskData,
  GetProjectsForTaskError,
  GetProjectsForTaskResponse,
  RemoveDependenciesForTaskData,
  RemoveDependenciesForTaskError,
  RemoveDependenciesForTaskResponse,
  RemoveDependentsForTaskData,
  RemoveDependentsForTaskError,
  RemoveDependentsForTaskResponse,
  RemoveFollowerForTaskData,
  RemoveFollowerForTaskError,
  RemoveFollowerForTaskResponse,
  RemoveProjectForTaskData,
  RemoveProjectForTaskError,
  RemoveProjectForTaskResponse,
  RemoveTagForTaskData,
  RemoveTagForTaskError,
  RemoveTagForTaskResponse,
  SetParentForTaskData,
  SetParentForTaskError,
  SetParentForTaskResponse,
  GetStoriesForTaskData,
  GetStoriesForTaskError,
  GetStoriesForTaskResponse,
  CreateStoryForTaskData,
  CreateStoryForTaskError,
  CreateStoryForTaskResponse,
  GetSubtasksForTaskData,
  GetSubtasksForTaskError,
  GetSubtasksForTaskResponse,
  CreateSubtaskForTaskData,
  CreateSubtaskForTaskError,
  CreateSubtaskForTaskResponse,
  GetTagsForTaskData,
  GetTagsForTaskError,
  GetTagsForTaskResponse,
  GetTeamMembershipsData,
  GetTeamMembershipsError,
  GetTeamMembershipsResponse,
  GetTeamMembershipData,
  GetTeamMembershipError,
  GetTeamMembershipResponse,
  CreateTeamData,
  CreateTeamError,
  CreateTeamResponse,
  UpdateTeamData,
  UpdateTeamError,
  UpdateTeamResponse,
  GetTeamData,
  GetTeamError,
  GetTeamResponse,
  AddUserForTeamData,
  AddUserForTeamError,
  AddUserForTeamResponse,
  GetProjectTemplatesForTeamData,
  GetProjectTemplatesForTeamError,
  GetProjectTemplatesForTeamResponse,
  GetProjectsForTeamData,
  GetProjectsForTeamError,
  GetProjectsForTeamResponse,
  CreateProjectForTeamData,
  CreateProjectForTeamError,
  CreateProjectForTeamResponse,
  RemoveUserForTeamData,
  RemoveUserForTeamError,
  RemoveUserForTeamResponse,
  GetTeamMembershipsForTeamData,
  GetTeamMembershipsForTeamError,
  GetTeamMembershipsForTeamResponse,
  GetUsersForTeamData,
  GetUsersForTeamError,
  GetUsersForTeamResponse,
  GetTimePeriodsData,
  GetTimePeriodsError,
  GetTimePeriodsResponse,
  GetTimePeriodData,
  GetTimePeriodError,
  GetTimePeriodResponse,
  GetUserTaskListData,
  GetUserTaskListError,
  GetUserTaskListResponse,
  GetTasksForUserTaskListData,
  GetTasksForUserTaskListError,
  GetTasksForUserTaskListResponse,
  GetUsersData,
  GetUsersError,
  GetUsersResponse,
  GetUserData,
  GetUserError,
  GetUserResponse,
  GetFavoritesForUserData,
  GetFavoritesForUserError,
  GetFavoritesForUserResponse,
  GetTeamMembershipsForUserData,
  GetTeamMembershipsForUserError,
  GetTeamMembershipsForUserResponse,
  GetTeamsForUserData,
  GetTeamsForUserError,
  GetTeamsForUserResponse,
  GetUserTaskListForUserData,
  GetUserTaskListForUserError,
  GetUserTaskListForUserResponse,
  GetWorkspaceMembershipsForUserData,
  GetWorkspaceMembershipsForUserError,
  GetWorkspaceMembershipsForUserResponse,
  GetWebhooksData,
  GetWebhooksError,
  GetWebhooksResponse,
  CreateWebhookData,
  CreateWebhookError,
  CreateWebhookResponse,
  DeleteWebhookData,
  DeleteWebhookError,
  DeleteWebhookResponse,
  GetWebhookData,
  GetWebhookError,
  GetWebhookResponse,
  UpdateWebhookData,
  UpdateWebhookError,
  UpdateWebhookResponse,
  GetWorkspaceMembershipData,
  GetWorkspaceMembershipError,
  GetWorkspaceMembershipResponse,
  GetWorkspacesData,
  GetWorkspacesError,
  GetWorkspacesResponse,
  GetWorkspaceData,
  GetWorkspaceError,
  GetWorkspaceResponse,
  UpdateWorkspaceData,
  UpdateWorkspaceError,
  UpdateWorkspaceResponse,
  AddUserForWorkspaceData,
  AddUserForWorkspaceError,
  AddUserForWorkspaceResponse,
  GetAuditLogEventsData,
  GetAuditLogEventsError,
  GetAuditLogEventsResponse,
  GetCustomFieldsForWorkspaceData,
  GetCustomFieldsForWorkspaceError,
  GetCustomFieldsForWorkspaceResponse,
  GetProjectsForWorkspaceData,
  GetProjectsForWorkspaceError,
  GetProjectsForWorkspaceResponse,
  CreateProjectForWorkspaceData,
  CreateProjectForWorkspaceError,
  CreateProjectForWorkspaceResponse,
  RemoveUserForWorkspaceData,
  RemoveUserForWorkspaceError,
  RemoveUserForWorkspaceResponse,
  GetTagsForWorkspaceData,
  GetTagsForWorkspaceError,
  GetTagsForWorkspaceResponse,
  CreateTagForWorkspaceData,
  CreateTagForWorkspaceError,
  CreateTagForWorkspaceResponse,
  SearchTasksForWorkspaceData,
  SearchTasksForWorkspaceError,
  SearchTasksForWorkspaceResponse,
  GetTeamsForWorkspaceData,
  GetTeamsForWorkspaceError,
  GetTeamsForWorkspaceResponse,
  TypeaheadForWorkspaceData,
  TypeaheadForWorkspaceError,
  TypeaheadForWorkspaceResponse,
  GetUsersForWorkspaceData,
  GetUsersForWorkspaceError,
  GetUsersForWorkspaceResponse,
  GetWorkspaceMembershipsForWorkspaceData,
  GetWorkspaceMembershipsForWorkspaceError,
  GetWorkspaceMembershipsForWorkspaceResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get attachments from an object
 * Returns the compact records for all attachments on the object.
 *
 * There are three possible `parent` values for this request: `project`, `project_brief`, and `task`. For a project, an attachment refers to a file uploaded to the "Key resources" section in the project Overview. For a project brief, an attachment refers to inline files in the project brief itself. For a task, an attachment refers to a file directly associated to that task.
 */
export const getAttachmentsForObject = <ThrowOnError extends boolean = false>(
  options: Options<GetAttachmentsForObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAttachmentsForObjectResponse, GetAttachmentsForObjectError, ThrowOnError>({
    ...options,
    url: '/attachments',
  });
};

/**
 * Upload an attachment
 * Upload an attachment.
 *
 * This method uploads an attachment on an object and returns the compact
 * record for the created attachment object. This is possible by either:
 *
 * - Providing the URL of the external resource being attached, or
 * - Downloading the file content first and then uploading it as any other attachment. Note that it is not possible to attach
 * files from third party services such as Dropbox, Box, Vimeo & Google Drive via the API
 *
 * The 100MB size limit on attachments in Asana is enforced on this endpoint.
 *
 * This endpoint expects a multipart/form-data encoded request containing the full contents of the file to be uploaded.
 *
 * Requests made should follow the HTTP/1.1 specification that line
 * terminators are of the form `CRLF` or `\r\n` outlined
 * [here](http://www.w3.org/Protocols/HTTP/1.1/draft-ietf-http-v11-spec-01#Basic-Rules) in order for the server to reliably and properly handle the request.
 */
export const createAttachmentForObject = <ThrowOnError extends boolean = false>(
  options: Options<CreateAttachmentForObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateAttachmentForObjectResponse,
    CreateAttachmentForObjectError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/attachments',
  });
};

/**
 * Delete an attachment
 * Deletes a specific, existing attachment.
 *
 * Returns an empty data record.
 */
export const deleteAttachment = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAttachmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAttachmentResponse, DeleteAttachmentError, ThrowOnError>({
    ...options,
    url: '/attachments/{attachment_gid}',
  });
};

/**
 * Get an attachment
 * Get the full record for a single attachment.
 */
export const getAttachment = <ThrowOnError extends boolean = false>(
  options: Options<GetAttachmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAttachmentResponse, GetAttachmentError, ThrowOnError>({
    ...options,
    url: '/attachments/{attachment_gid}',
  });
};

/**
 * Submit parallel requests
 * Make multiple requests in parallel to Asana's API.
 */
export const createBatchRequest = <ThrowOnError extends boolean = false>(
  options: Options<CreateBatchRequestData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateBatchRequestResponse, CreateBatchRequestError, ThrowOnError>({
    ...options,
    url: '/batch',
  });
};

/**
 * Create a custom field
 * Creates a new custom field in a workspace. Every custom field is required
 * to be created in a specific workspace, and this workspace cannot be
 * changed once set.
 *
 * A custom field’s name must be unique within a workspace and not conflict
 * with names of existing task properties such as `Due Date` or `Assignee`.
 * A custom field’s type must be one of `text`, `enum`, `multi_enum`, `number`,
 * `date`, or `people`.
 *
 * Returns the full record of the newly created custom field.
 */
export const createCustomField = <ThrowOnError extends boolean = false>(
  options?: Options<CreateCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateCustomFieldResponse, CreateCustomFieldError, ThrowOnError>({
    ...options,
    url: '/custom_fields',
  });
};

/**
 * Delete a custom field
 * A specific, existing custom field can be deleted by making a DELETE request on the URL for that custom field.
 * Locked custom fields can only be deleted by the user who locked the field.
 * Returns an empty data record.
 */
export const deleteCustomField = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCustomFieldResponse, DeleteCustomFieldError, ThrowOnError>({
    ...options,
    url: '/custom_fields/{custom_field_gid}',
  });
};

/**
 * Get a custom field
 * Get the complete definition of a custom field’s metadata.
 *
 * Since custom fields can be defined for one of a number of types, and
 * these types have different data and behaviors, there are fields that are
 * relevant to a particular type. For instance, as noted above, enum_options
 * is only relevant for the enum type and defines the set of choices that
 * the enum could represent. The examples below show some of these
 * type-specific custom field definitions.
 */
export const getCustomField = <ThrowOnError extends boolean = false>(
  options: Options<GetCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCustomFieldResponse, GetCustomFieldError, ThrowOnError>({
    ...options,
    url: '/custom_fields/{custom_field_gid}',
  });
};

/**
 * Update a custom field
 * A specific, existing custom field can be updated by making a PUT request on the URL for that custom field. Only the fields provided in the `data` block will be updated; any unspecified fields will remain unchanged
 * When using this method, it is best to specify only those fields you wish to change, or else you may overwrite changes made by another user since you last retrieved the custom field.
 * A custom field’s `type` cannot be updated.
 * An enum custom field’s `enum_options` cannot be updated with this endpoint. Instead see “Work With Enum Options” for information on how to update `enum_options`.
 * Locked custom fields can only be updated by the user who locked the field.
 * Returns the complete updated custom field record.
 */
export const updateCustomField = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateCustomFieldResponse, UpdateCustomFieldError, ThrowOnError>({
    ...options,
    url: '/custom_fields/{custom_field_gid}',
  });
};

/**
 * Create an enum option
 * Creates an enum option and adds it to this custom field’s list of enum options. A custom field can have at most 500 enum options (including disabled options). By default new enum options are inserted at the end of a custom field’s list.
 * Locked custom fields can only have enum options added by the user who locked the field.
 * Returns the full record of the newly created enum option.
 */
export const createEnumOptionForCustomField = <ThrowOnError extends boolean = false>(
  options: Options<CreateEnumOptionForCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateEnumOptionForCustomFieldResponse,
    CreateEnumOptionForCustomFieldError,
    ThrowOnError
  >({
    ...options,
    url: '/custom_fields/{custom_field_gid}/enum_options',
  });
};

/**
 * Reorder a custom field's enum
 * Moves a particular enum option to be either before or after another specified enum option in the custom field.
 * Locked custom fields can only be reordered by the user who locked the field.
 */
export const insertEnumOptionForCustomField = <ThrowOnError extends boolean = false>(
  options: Options<InsertEnumOptionForCustomFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InsertEnumOptionForCustomFieldResponse,
    InsertEnumOptionForCustomFieldError,
    ThrowOnError
  >({
    ...options,
    url: '/custom_fields/{custom_field_gid}/enum_options/insert',
  });
};

/**
 * Update an enum option
 * Updates an existing enum option. Enum custom fields require at least one enabled enum option.
 * Locked custom fields can only be updated by the user who locked the field.
 * Returns the full record of the updated enum option.
 */
export const updateEnumOption = <ThrowOnError extends boolean = false>(
  options: Options<UpdateEnumOptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateEnumOptionResponse, UpdateEnumOptionError, ThrowOnError>({
    ...options,
    url: '/enum_options/{enum_option_gid}',
  });
};

/**
 * Get events on a resource
 * Returns the full record for all events that have occurred since the sync
 * token was created.
 *
 * A `GET` request to the endpoint `/[path_to_resource]/events` can be made in
 * lieu of including the resource ID in the data for the request.
 *
 * Asana limits a single sync token to 100 events. If more than 100 events exist
 * for a given resource, `has_more: true` will be returned in the response, indicating
 * that there are more events to pull.
 *
 * *Note: The resource returned will be the resource that triggered the
 * event. This may be different from the one that the events were requested
 * for. For example, a subscription to a project will contain events for
 * tasks contained within the project.*
 */
export const getEvents = <ThrowOnError extends boolean = false>(options: Options<GetEventsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetEventsResponse, GetEventsError, ThrowOnError>({
    ...options,
    url: '/events',
  });
};

/**
 * Get goal relationships
 * Returns compact goal relationship records.
 */
export const getGoalRelationships = <ThrowOnError extends boolean = false>(
  options: Options<GetGoalRelationshipsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGoalRelationshipsResponse, GetGoalRelationshipsError, ThrowOnError>({
    ...options,
    url: '/goal_relationships',
  });
};

/**
 * Get a goal relationship
 * Returns the complete updated goal relationship record for a single goal relationship.
 */
export const getGoalRelationship = <ThrowOnError extends boolean = false>(
  options: Options<GetGoalRelationshipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetGoalRelationshipResponse, GetGoalRelationshipError, ThrowOnError>({
    ...options,
    url: '/goal_relationships/{goal_relationship_gid}',
  });
};

/**
 * Update a goal relationship
 * An existing goal relationship can be updated by making a PUT request on the URL for
 * that goal relationship. Only the fields provided in the `data` block will be updated;
 * any unspecified fields will remain unchanged.
 *
 * Returns the complete updated goal relationship record.
 */
export const updateGoalRelationship = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGoalRelationshipData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateGoalRelationshipResponse, UpdateGoalRelationshipError, ThrowOnError>({
    ...options,
    url: '/goal_relationships/{goal_relationship_gid}',
  });
};

/**
 * Get goals
 * Returns compact goal records.
 */
export const getGoals = <ThrowOnError extends boolean = false>(options?: Options<GetGoalsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetGoalsResponse, GetGoalsError, ThrowOnError>({
    ...options,
    url: '/goals',
  });
};

/**
 * Create a goal
 * Creates a new goal in a workspace or team.
 *
 * Returns the full record of the newly created goal.
 */
export const createGoal = <ThrowOnError extends boolean = false>(options: Options<CreateGoalData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateGoalResponse, CreateGoalError, ThrowOnError>({
    ...options,
    url: '/goals',
  });
};

/**
 * Delete a goal
 * A specific, existing goal can be deleted by making a DELETE request on the URL for that goal.
 *
 * Returns an empty data record.
 */
export const deleteGoal = <ThrowOnError extends boolean = false>(options: Options<DeleteGoalData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteGoalResponse, DeleteGoalError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}',
  });
};

/**
 * Get a goal
 * Returns the complete goal record for a single goal.
 */
export const getGoal = <ThrowOnError extends boolean = false>(options: Options<GetGoalData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetGoalResponse, GetGoalError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}',
  });
};

/**
 * Update a goal
 * An existing goal can be updated by making a PUT request on the URL for
 * that goal. Only the fields provided in the `data` block will be updated;
 * any unspecified fields will remain unchanged.
 *
 * Returns the complete updated goal record.
 */
export const updateGoal = <ThrowOnError extends boolean = false>(options: Options<UpdateGoalData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateGoalResponse, UpdateGoalError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}',
  });
};

/**
 * Add a collaborator to a goal
 * Adds followers to a goal. Returns the goal the followers were added to.
 * Each goal can be associated with zero or more followers in the system.
 * Requests to add/remove followers, if successful, will return the complete updated goal record, described above.
 */
export const addFollowers = <ThrowOnError extends boolean = false>(
  options: Options<AddFollowersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddFollowersResponse, AddFollowersError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}/addFollowers',
  });
};

/**
 * Add a supporting goal relationship
 * Creates a goal relationship by adding a supporting resource to a given goal.
 *
 * Returns the newly created goal relationship record.
 */
export const addSupportingRelationship = <ThrowOnError extends boolean = false>(
  options: Options<AddSupportingRelationshipData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddSupportingRelationshipResponse,
    AddSupportingRelationshipError,
    ThrowOnError
  >({
    ...options,
    url: '/goals/{goal_gid}/addSupportingRelationship',
  });
};

/**
 * Get parent goals from a goal
 * Returns a compact representation of all of the parent goals of a goal.
 */
export const getParentGoalsForGoal = <ThrowOnError extends boolean = false>(
  options: Options<GetParentGoalsForGoalData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetParentGoalsForGoalResponse, GetParentGoalsForGoalError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}/parentGoals',
  });
};

/**
 * Remove a collaborator from a goal
 * Removes followers from a goal. Returns the goal the followers were removed from.
 * Each goal can be associated with zero or more followers in the system.
 * Requests to add/remove followers, if successful, will return the complete updated goal record, described above.
 */
export const removeFollowers = <ThrowOnError extends boolean = false>(
  options: Options<RemoveFollowersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveFollowersResponse, RemoveFollowersError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}/removeFollowers',
  });
};

/**
 * Removes a supporting goal relationship
 * Removes a goal relationship for a given parent goal.
 */
export const removeSupportingRelationship = <ThrowOnError extends boolean = false>(
  options: Options<RemoveSupportingRelationshipData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveSupportingRelationshipResponse,
    RemoveSupportingRelationshipError,
    ThrowOnError
  >({
    ...options,
    url: '/goals/{goal_gid}/removeSupportingRelationship',
  });
};

/**
 * Create a goal metric
 * Creates and adds a goal metric to a specified goal. Note that this replaces an existing goal metric if one already exists.
 */
export const createGoalMetric = <ThrowOnError extends boolean = false>(
  options: Options<CreateGoalMetricData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateGoalMetricResponse, CreateGoalMetricError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}/setMetric',
  });
};

/**
 * Update a goal metric
 * Updates a goal's existing metric's `current_number_value` if one exists,
 * otherwise responds with a 400 status code.
 *
 * Returns the complete updated goal metric record.
 */
export const updateGoalMetric = <ThrowOnError extends boolean = false>(
  options: Options<UpdateGoalMetricData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateGoalMetricResponse, UpdateGoalMetricError, ThrowOnError>({
    ...options,
    url: '/goals/{goal_gid}/setMetricCurrentValue',
  });
};

/**
 * Get a job by id
 * Returns the full record for a job.
 */
export const getJob = <ThrowOnError extends boolean = false>(options: Options<GetJobData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetJobResponse, GetJobError, ThrowOnError>({
    ...options,
    url: '/jobs/{job_gid}',
  });
};

/**
 * Create an organization export request
 * This method creates a request to export an Organization. Asana will complete the export at some point after you create the request.
 */
export const createOrganizationExport = <ThrowOnError extends boolean = false>(
  options: Options<CreateOrganizationExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateOrganizationExportResponse,
    CreateOrganizationExportError,
    ThrowOnError
  >({
    ...options,
    url: '/organization_exports',
  });
};

/**
 * Get details on an org export request
 * Returns details of a previously-requested Organization export.
 */
export const getOrganizationExport = <ThrowOnError extends boolean = false>(
  options: Options<GetOrganizationExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOrganizationExportResponse, GetOrganizationExportError, ThrowOnError>({
    ...options,
    url: '/organization_exports/{organization_export_gid}',
  });
};

/**
 * Get multiple portfolio memberships
 * Returns a list of portfolio memberships in compact representation. You must specify `portfolio`, `portfolio` and `user`, or `workspace` and `user`.
 */
export const getPortfolioMemberships = <ThrowOnError extends boolean = false>(
  options?: Options<GetPortfolioMembershipsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPortfolioMembershipsResponse, GetPortfolioMembershipsError, ThrowOnError>({
    ...options,
    url: '/portfolio_memberships',
  });
};

/**
 * Get a portfolio membership
 * Returns the complete portfolio record for a single portfolio membership.
 */
export const getPortfolioMembership = <ThrowOnError extends boolean = false>(
  options: Options<GetPortfolioMembershipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPortfolioMembershipResponse, GetPortfolioMembershipError, ThrowOnError>({
    ...options,
    url: '/portfolio_memberships/{portfolio_membership_gid}',
  });
};

/**
 * Get multiple portfolios
 * Returns a list of the portfolios in compact representation that are owned by the current API user.
 */
export const getPortfolios = <ThrowOnError extends boolean = false>(
  options: Options<GetPortfoliosData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPortfoliosResponse, GetPortfoliosError, ThrowOnError>({
    ...options,
    url: '/portfolios',
  });
};

/**
 * Create a portfolio
 * Creates a new portfolio in the given workspace with the supplied name.
 *
 * Note that portfolios created in the Asana UI may have some state
 * (like the “Priority” custom field) which is automatically added
 * to the portfolio when it is created. Portfolios created via our
 * API will *not* be created with the same initial state to allow
 * integrations to create their own starting state on a portfolio.
 */
export const createPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<CreatePortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePortfolioResponse, CreatePortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios',
  });
};

/**
 * Delete a portfolio
 * An existing portfolio can be deleted by making a DELETE request on
 * the URL for that portfolio.
 *
 * Returns an empty data record.
 */
export const deletePortfolio = <ThrowOnError extends boolean = false>(
  options: Options<DeletePortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePortfolioResponse, DeletePortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}',
  });
};

/**
 * Get a portfolio
 * Returns the complete portfolio record for a single portfolio.
 */
export const getPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<GetPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPortfolioResponse, GetPortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}',
  });
};

/**
 * Update a portfolio
 * An existing portfolio can be updated by making a PUT request on the URL for
 * that portfolio. Only the fields provided in the `data` block will be updated;
 * any unspecified fields will remain unchanged.
 *
 * Returns the complete updated portfolio record.
 */
export const updatePortfolio = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdatePortfolioResponse, UpdatePortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}',
  });
};

/**
 * Add a custom field to a portfolio
 * Custom fields are associated with portfolios by way of custom field settings.  This method creates a setting for the portfolio.
 */
export const addCustomFieldSettingForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<AddCustomFieldSettingForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddCustomFieldSettingForPortfolioResponse,
    AddCustomFieldSettingForPortfolioError,
    ThrowOnError
  >({
    ...options,
    url: '/portfolios/{portfolio_gid}/addCustomFieldSetting',
  });
};

/**
 * Add a portfolio item
 * Add an item to a portfolio.
 * Returns an empty data block.
 */
export const addItemForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<AddItemForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddItemForPortfolioResponse, AddItemForPortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}/addItem',
  });
};

/**
 * Add users to a portfolio
 * Adds the specified list of users as members of the portfolio.
 * Returns the updated portfolio record.
 */
export const addMembersForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<AddMembersForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddMembersForPortfolioResponse, AddMembersForPortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}/addMembers',
  });
};

/**
 * Get a portfolio's custom fields
 * Returns a list of all of the custom fields settings on a portfolio, in compact form.
 */
export const getCustomFieldSettingsForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<GetCustomFieldSettingsForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCustomFieldSettingsForPortfolioResponse,
    GetCustomFieldSettingsForPortfolioError,
    ThrowOnError
  >({
    ...options,
    url: '/portfolios/{portfolio_gid}/custom_field_settings',
  });
};

/**
 * Get portfolio items
 * Get a list of the items in compact form in a portfolio.
 */
export const getItemsForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<GetItemsForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetItemsForPortfolioResponse, GetItemsForPortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}/items',
  });
};

/**
 * Get memberships from a portfolio
 * Returns the compact portfolio membership records for the portfolio.
 */
export const getPortfolioMembershipsForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<GetPortfolioMembershipsForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPortfolioMembershipsForPortfolioResponse,
    GetPortfolioMembershipsForPortfolioError,
    ThrowOnError
  >({
    ...options,
    url: '/portfolios/{portfolio_gid}/portfolio_memberships',
  });
};

/**
 * Remove a custom field from a portfolio
 * Removes a custom field setting from a portfolio.
 */
export const removeCustomFieldSettingForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<RemoveCustomFieldSettingForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveCustomFieldSettingForPortfolioResponse,
    RemoveCustomFieldSettingForPortfolioError,
    ThrowOnError
  >({
    ...options,
    url: '/portfolios/{portfolio_gid}/removeCustomFieldSetting',
  });
};

/**
 * Remove a portfolio item
 * Remove an item from a portfolio.
 * Returns an empty data block.
 */
export const removeItemForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<RemoveItemForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveItemForPortfolioResponse, RemoveItemForPortfolioError, ThrowOnError>({
    ...options,
    url: '/portfolios/{portfolio_gid}/removeItem',
  });
};

/**
 * Remove users from a portfolio
 * Removes the specified list of users from members of the portfolio.
 * Returns the updated portfolio record.
 */
export const removeMembersForPortfolio = <ThrowOnError extends boolean = false>(
  options: Options<RemoveMembersForPortfolioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveMembersForPortfolioResponse,
    RemoveMembersForPortfolioError,
    ThrowOnError
  >({
    ...options,
    url: '/portfolios/{portfolio_gid}/removeMembers',
  });
};

/**
 * Delete a project brief
 * Deletes a specific, existing project brief.
 *
 * Returns an empty data record.
 */
export const deleteProjectBrief = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectBriefData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectBriefResponse, DeleteProjectBriefError, ThrowOnError>({
    ...options,
    url: '/project_briefs/{project_brief_gid}',
  });
};

/**
 * Get a project brief
 * Get the full record for a project brief.
 */
export const getProjectBrief = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectBriefData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectBriefResponse, GetProjectBriefError, ThrowOnError>({
    ...options,
    url: '/project_briefs/{project_brief_gid}',
  });
};

/**
 * Update a project brief
 * An existing project brief can be updated by making a PUT request on the URL for
 * that project brief. Only the fields provided in the `data` block will be updated;
 * any unspecified fields will remain unchanged.
 *
 * Returns the complete updated project brief record.
 */
export const updateProjectBrief = <ThrowOnError extends boolean = false>(
  options: Options<UpdateProjectBriefData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateProjectBriefResponse, UpdateProjectBriefError, ThrowOnError>({
    ...options,
    url: '/project_briefs/{project_brief_gid}',
  });
};

/**
 * Get a project membership
 * Returns the complete project record for a single project membership.
 */
export const getProjectMembership = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectMembershipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectMembershipResponse, GetProjectMembershipError, ThrowOnError>({
    ...options,
    url: '/project_memberships/{project_membership_gid}',
  });
};

/**
 * Delete a project status
 * *Deprecated: new integrations should prefer the `/status_updates/{status_gid}` route.*
 *
 * Deletes a specific, existing project status update.
 *
 * Returns an empty data record.
 */
export const deleteProjectStatus = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectStatusResponse, DeleteProjectStatusError, ThrowOnError>({
    ...options,
    url: '/project_statuses/{project_status_gid}',
  });
};

/**
 * Get a project status
 * *Deprecated: new integrations should prefer the `/status_updates/{status_gid}` route.*
 *
 * Returns the complete record for a single status update.
 */
export const getProjectStatus = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectStatusResponse, GetProjectStatusError, ThrowOnError>({
    ...options,
    url: '/project_statuses/{project_status_gid}',
  });
};

/**
 * Get multiple project templates
 * Returns the compact project template records for all project templates in the given team or workspace.
 */
export const getProjectTemplates = <ThrowOnError extends boolean = false>(
  options?: Options<GetProjectTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectTemplatesResponse, GetProjectTemplatesError, ThrowOnError>({
    ...options,
    url: '/project_templates',
  });
};

/**
 * Get a project template
 * Returns the complete project template record for a single project template.
 */
export const getProjectTemplate = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectTemplateResponse, GetProjectTemplateError, ThrowOnError>({
    ...options,
    url: '/project_templates/{project_template_gid}',
  });
};

/**
 * Instantiate a project from a project template
 * Creates and returns a job that will asynchronously handle the project instantiation.
 *
 * To form this request, it is recommended to first make a request to [get a project template](/docs/get-a-project-template). Then, from the response, copy the `gid` from the object in the `requested_dates` array. This `gid` should be used in `requested_dates` to instantiate a project.
 *
 * _Note: The body of this request will differ if your workspace is an organization. To determine if your workspace is an organization, use the [is_organization](/docs/workspace) parameter._
 */
export const instantiateProject = <ThrowOnError extends boolean = false>(
  options: Options<InstantiateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InstantiateProjectResponse, InstantiateProjectError, ThrowOnError>({
    ...options,
    url: '/project_templates/{project_template_gid}/instantiateProject',
  });
};

/**
 * Get multiple projects
 * Returns the compact project records for some filtered set of projects. Use one or more of the parameters provided to filter the projects returned.
 * *Note: This endpoint may timeout for large domains. Try filtering by team!*
 */
export const getProjects = <ThrowOnError extends boolean = false>(options?: Options<GetProjectsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetProjectsResponse, GetProjectsError, ThrowOnError>({
    ...options,
    url: '/projects',
  });
};

/**
 * Create a project
 * Create a new project in a workspace or team.
 *
 * Every project is required to be created in a specific workspace or
 * organization, and this cannot be changed once set. Note that you can use
 * the `workspace` parameter regardless of whether or not it is an
 * organization.
 *
 * If the workspace for your project is an organization, you must also
 * supply a `team` to share the project with.
 *
 * Returns the full record of the newly created project.
 */
export const createProject = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectResponse, CreateProjectError, ThrowOnError>({
    ...options,
    url: '/projects',
  });
};

/**
 * Delete a project
 * A specific, existing project can be deleted by making a DELETE request on
 * the URL for that project.
 *
 * Returns an empty data record.
 */
export const deleteProject = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectResponse, DeleteProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}',
  });
};

/**
 * Get a project
 * Returns the complete project record for a single project.
 */
export const getProject = <ThrowOnError extends boolean = false>(options: Options<GetProjectData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetProjectResponse, GetProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}',
  });
};

/**
 * Update a project
 * A specific, existing project can be updated by making a PUT request on
 * the URL for that project. Only the fields provided in the `data` block
 * will be updated; any unspecified fields will remain unchanged.
 *
 * When using this method, it is best to specify only those fields you wish
 * to change, or else you may overwrite changes made by another user since
 * you last retrieved the task.
 *
 * Returns the complete updated project record.
 */
export const updateProject = <ThrowOnError extends boolean = false>(
  options: Options<UpdateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateProjectResponse, UpdateProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}',
  });
};

/**
 * Add a custom field to a project
 * Custom fields are associated with projects by way of custom field settings.  This method creates a setting for the project.
 */
export const addCustomFieldSettingForProject = <ThrowOnError extends boolean = false>(
  options: Options<AddCustomFieldSettingForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddCustomFieldSettingForProjectResponse,
    AddCustomFieldSettingForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/addCustomFieldSetting',
  });
};

/**
 * Add followers to a project
 * Adds the specified list of users as followers to the project. Followers are a subset of members who have opted in to receive "tasks added" notifications for a project. Therefore, if the users are not already members of the project, they will also become members as a result of this operation.
 * Returns the updated project record.
 */
export const addFollowersForProject = <ThrowOnError extends boolean = false>(
  options: Options<AddFollowersForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddFollowersForProjectResponse, AddFollowersForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/addFollowers',
  });
};

/**
 * Add users to a project
 * Adds the specified list of users as members of the project. Note that a user being added as a member may also be added as a *follower* as a result of this operation. This is because the user's default notification settings (i.e., in the "Notifcations" tab of "My Profile Settings") will override this endpoint's default behavior of setting "Tasks added" notifications to `false`.
 * Returns the updated project record.
 */
export const addMembersForProject = <ThrowOnError extends boolean = false>(
  options: Options<AddMembersForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddMembersForProjectResponse, AddMembersForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/addMembers',
  });
};

/**
 * Get a project's custom fields
 * Returns a list of all of the custom fields settings on a project, in compact form. Note that, as in all queries to collections which return compact representation, `opt_fields` can be used to include more data than is returned in the compact representation. See the [getting started guide on input/output options](https://developers.asana.com/docs/#input-output-options) for more information.
 */
export const getCustomFieldSettingsForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetCustomFieldSettingsForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCustomFieldSettingsForProjectResponse,
    GetCustomFieldSettingsForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/custom_field_settings',
  });
};

/**
 * Duplicate a project
 * Creates and returns a job that will asynchronously handle the duplication.
 */
export const duplicateProject = <ThrowOnError extends boolean = false>(
  options: Options<DuplicateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DuplicateProjectResponse, DuplicateProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/duplicate',
  });
};

/**
 * Create a project brief
 * Creates a new project brief.
 *
 * Returns the full record of the newly created project brief.
 */
export const createProjectBrief = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectBriefData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectBriefResponse, CreateProjectBriefError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/project_briefs',
  });
};

/**
 * Get memberships from a project
 * Returns the compact project membership records for the project.
 */
export const getProjectMembershipsForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectMembershipsForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetProjectMembershipsForProjectResponse,
    GetProjectMembershipsForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/project_memberships',
  });
};

/**
 * Get statuses from a project
 * *Deprecated: new integrations should prefer the `/status_updates` route.*
 *
 * Returns the compact project status update records for all updates on the project.
 */
export const getProjectStatusesForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectStatusesForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetProjectStatusesForProjectResponse,
    GetProjectStatusesForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/project_statuses',
  });
};

/**
 * Create a project status
 * *Deprecated: new integrations should prefer the `/status_updates` route.*
 *
 * Creates a new status update on the project.
 *
 * Returns the full record of the newly created project status update.
 */
export const createProjectStatusForProject = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectStatusForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateProjectStatusForProjectResponse,
    CreateProjectStatusForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/project_statuses',
  });
};

/**
 * Remove a custom field from a project
 * Removes a custom field setting from a project.
 */
export const removeCustomFieldSettingForProject = <ThrowOnError extends boolean = false>(
  options: Options<RemoveCustomFieldSettingForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveCustomFieldSettingForProjectResponse,
    RemoveCustomFieldSettingForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/removeCustomFieldSetting',
  });
};

/**
 * Remove followers from a project
 * Removes the specified list of users from following the project, this will not affect project membership status.
 * Returns the updated project record.
 */
export const removeFollowersForProject = <ThrowOnError extends boolean = false>(
  options: Options<RemoveFollowersForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveFollowersForProjectResponse,
    RemoveFollowersForProjectError,
    ThrowOnError
  >({
    ...options,
    url: '/projects/{project_gid}/removeFollowers',
  });
};

/**
 * Remove users from a project
 * Removes the specified list of users from members of the project.
 * Returns the updated project record.
 */
export const removeMembersForProject = <ThrowOnError extends boolean = false>(
  options: Options<RemoveMembersForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveMembersForProjectResponse, RemoveMembersForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/removeMembers',
  });
};

/**
 * Create a project template from a project
 * Creates and returns a job that will asynchronously handle the project template creation. Note that
 * while the resulting project template can be accessed with the API, it won't be visible in the Asana
 * UI until Project Templates 2.0 is launched in the app. See more in [this forum post](https://forum.asana.com/t/a-new-api-for-project-templates/156432).
 */
export const projectSaveAsTemplate = <ThrowOnError extends boolean = false>(
  options: Options<ProjectSaveAsTemplateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ProjectSaveAsTemplateResponse, ProjectSaveAsTemplateError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/saveAsTemplate',
  });
};

/**
 * Get sections in a project
 * Returns the compact records for all sections in the specified project.
 */
export const getSectionsForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetSectionsForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSectionsForProjectResponse, GetSectionsForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/sections',
  });
};

/**
 * Create a section in a project
 * Creates a new section in a project.
 * Returns the full record of the newly created section.
 */
export const createSectionForProject = <ThrowOnError extends boolean = false>(
  options: Options<CreateSectionForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSectionForProjectResponse, CreateSectionForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/sections',
  });
};

/**
 * Move or Insert sections
 * Move sections relative to each other. One of
 * `before_section` or `after_section` is required.
 *
 * Sections cannot be moved between projects.
 *
 * Returns an empty data block.
 */
export const insertSectionForProject = <ThrowOnError extends boolean = false>(
  options: Options<InsertSectionForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InsertSectionForProjectResponse, InsertSectionForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/sections/insert',
  });
};

/**
 * Get task count of a project
 * Get an object that holds task count fields. **All fields are excluded by default**. You must [opt in](/docs/input-output-options) using `opt_fields` to get any information from this endpoint.
 *
 * This endpoint has an additional [rate limit](/docs/standard-rate-limits) and each field counts especially high against our [cost limits](/docs/cost-limits).
 *
 * Milestones are just tasks, so they are included in the `num_tasks`, `num_incomplete_tasks`, and `num_completed_tasks` counts.
 */
export const getTaskCountsForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetTaskCountsForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTaskCountsForProjectResponse, GetTaskCountsForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/task_counts',
  });
};

/**
 * Get tasks from a project
 * Returns the compact task records for all tasks within the given project, ordered by their priority within the project. Tasks can exist in more than one project at a time.
 */
export const getTasksForProject = <ThrowOnError extends boolean = false>(
  options: Options<GetTasksForProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTasksForProjectResponse, GetTasksForProjectError, ThrowOnError>({
    ...options,
    url: '/projects/{project_gid}/tasks',
  });
};

/**
 * Delete a section
 * A specific, existing section can be deleted by making a DELETE request on
 * the URL for that section.
 *
 * Note that sections must be empty to be deleted.
 *
 * The last remaining section cannot be deleted.
 *
 * Returns an empty data block.
 */
export const deleteSection = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSectionResponse, DeleteSectionError, ThrowOnError>({
    ...options,
    url: '/sections/{section_gid}',
  });
};

/**
 * Get a section
 * Returns the complete record for a single section.
 */
export const getSection = <ThrowOnError extends boolean = false>(options: Options<GetSectionData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetSectionResponse, GetSectionError, ThrowOnError>({
    ...options,
    url: '/sections/{section_gid}',
  });
};

/**
 * Update a section
 * A specific, existing section can be updated by making a PUT request on
 * the URL for that project. Only the fields provided in the `data` block
 * will be updated; any unspecified fields will remain unchanged. (note that
 * at this time, the only field that can be updated is the `name` field.)
 *
 * When using this method, it is best to specify only those fields you wish
 * to change, or else you may overwrite changes made by another user since
 * you last retrieved the task.
 *
 * Returns the complete updated section record.
 */
export const updateSection = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateSectionResponse, UpdateSectionError, ThrowOnError>({
    ...options,
    url: '/sections/{section_gid}',
  });
};

/**
 * Add task to section
 * Add a task to a specific, existing section. This will remove the task from other sections of the project.
 *
 * The task will be inserted at the top of a section unless an insert_before or insert_after parameter is declared.
 *
 * This does not work for separators (tasks with the resource_subtype of section).
 */
export const addTaskForSection = <ThrowOnError extends boolean = false>(
  options: Options<AddTaskForSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddTaskForSectionResponse, AddTaskForSectionError, ThrowOnError>({
    ...options,
    url: '/sections/{section_gid}/addTask',
  });
};

/**
 * Get tasks from a section
 * *Board view only*: Returns the compact section records for all tasks within the given section.
 */
export const getTasksForSection = <ThrowOnError extends boolean = false>(
  options: Options<GetTasksForSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTasksForSectionResponse, GetTasksForSectionError, ThrowOnError>({
    ...options,
    url: '/sections/{section_gid}/tasks',
  });
};

/**
 * Get status updates from an object
 * Returns the compact status update records for all updates on the object.
 */
export const getStatusesForObject = <ThrowOnError extends boolean = false>(
  options: Options<GetStatusesForObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetStatusesForObjectResponse, GetStatusesForObjectError, ThrowOnError>({
    ...options,
    url: '/status_updates',
  });
};

/**
 * Create a status update
 * Creates a new status update on an object.
 * Returns the full record of the newly created status update.
 */
export const createStatusForObject = <ThrowOnError extends boolean = false>(
  options: Options<CreateStatusForObjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateStatusForObjectResponse, CreateStatusForObjectError, ThrowOnError>({
    ...options,
    url: '/status_updates',
  });
};

/**
 * Delete a status update
 * Deletes a specific, existing status update.
 *
 * Returns an empty data record.
 */
export const deleteStatus = <ThrowOnError extends boolean = false>(
  options: Options<DeleteStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteStatusResponse, DeleteStatusError, ThrowOnError>({
    ...options,
    url: '/status_updates/{status_gid}',
  });
};

/**
 * Get a status update
 * Returns the complete record for a single status update.
 */
export const getStatus = <ThrowOnError extends boolean = false>(options: Options<GetStatusData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetStatusResponse, GetStatusError, ThrowOnError>({
    ...options,
    url: '/status_updates/{status_gid}',
  });
};

/**
 * Delete a story
 * Deletes a story. A user can only delete stories they have created.
 *
 * Returns an empty data record.
 */
export const deleteStory = <ThrowOnError extends boolean = false>(options: Options<DeleteStoryData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteStoryResponse, DeleteStoryError, ThrowOnError>({
    ...options,
    url: '/stories/{story_gid}',
  });
};

/**
 * Get a story
 * Returns the full record for a single story.
 */
export const getStory = <ThrowOnError extends boolean = false>(options: Options<GetStoryData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetStoryResponse, GetStoryError, ThrowOnError>({
    ...options,
    url: '/stories/{story_gid}',
  });
};

/**
 * Update a story
 * Updates the story and returns the full record for the updated story. Only comment stories can have their text updated, and only comment stories and attachment stories can be pinned. Only one of `text` and `html_text` can be specified.
 */
export const updateStory = <ThrowOnError extends boolean = false>(options: Options<UpdateStoryData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateStoryResponse, UpdateStoryError, ThrowOnError>({
    ...options,
    url: '/stories/{story_gid}',
  });
};

/**
 * Get multiple tags
 * Returns the compact tag records for some filtered set of tags. Use one or more of the parameters provided to filter the tags returned.
 */
export const getTags = <ThrowOnError extends boolean = false>(options?: Options<GetTagsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTagsResponse, GetTagsError, ThrowOnError>({
    ...options,
    url: '/tags',
  });
};

/**
 * Create a tag
 * Creates a new tag in a workspace or organization.
 *
 * Every tag is required to be created in a specific workspace or
 * organization, and this cannot be changed once set. Note that you can use
 * the workspace parameter regardless of whether or not it is an
 * organization.
 *
 * Returns the full record of the newly created tag.
 */
export const createTag = <ThrowOnError extends boolean = false>(options: Options<CreateTagData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTagResponse, CreateTagError, ThrowOnError>({
    ...options,
    url: '/tags',
  });
};

/**
 * Delete a tag
 * A specific, existing tag can be deleted by making a DELETE request on
 * the URL for that tag.
 *
 * Returns an empty data record.
 */
export const deleteTag = <ThrowOnError extends boolean = false>(options: Options<DeleteTagData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteTagResponse, DeleteTagError, ThrowOnError>({
    ...options,
    url: '/tags/{tag_gid}',
  });
};

/**
 * Get a tag
 * Returns the complete tag record for a single tag.
 */
export const getTag = <ThrowOnError extends boolean = false>(options: Options<GetTagData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTagResponse, GetTagError, ThrowOnError>({
    ...options,
    url: '/tags/{tag_gid}',
  });
};

/**
 * Update a tag
 * Updates the properties of a tag. Only the fields provided in the `data`
 * block will be updated; any unspecified fields will remain unchanged.
 *
 * When using this method, it is best to specify only those fields you wish
 * to change, or else you may overwrite changes made by another user since
 * you last retrieved the tag.
 *
 * Returns the complete updated tag record.
 */
export const updateTag = <ThrowOnError extends boolean = false>(options: Options<UpdateTagData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateTagResponse, UpdateTagError, ThrowOnError>({
    ...options,
    url: '/tags/{tag_gid}',
  });
};

/**
 * Get tasks from a tag
 * Returns the compact task records for all tasks with the given tag. Tasks can have more than one tag at a time.
 */
export const getTasksForTag = <ThrowOnError extends boolean = false>(
  options: Options<GetTasksForTagData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTasksForTagResponse, GetTasksForTagError, ThrowOnError>({
    ...options,
    url: '/tags/{tag_gid}/tasks',
  });
};

/**
 * Get multiple tasks
 * Returns the compact task records for some filtered set of tasks. Use one or more of the parameters provided to filter the tasks returned. You must specify a `project` or `tag` if you do not specify `assignee` and `workspace`.
 *
 * For more complex task retrieval, use [workspaces/{workspace_gid}/tasks/search](/docs/search-tasks-in-a-workspace).
 */
export const getTasks = <ThrowOnError extends boolean = false>(options?: Options<GetTasksData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTasksResponse, GetTasksError, ThrowOnError>({
    ...options,
    url: '/tasks',
  });
};

/**
 * Create a task
 * Creating a new task is as easy as POSTing to the `/tasks` endpoint with a
 * data block containing the fields you’d like to set on the task. Any
 * unspecified fields will take on default values.
 *
 * Every task is required to be created in a specific workspace, and this
 * workspace cannot be changed once set. The workspace need not be set
 * explicitly if you specify `projects` or a `parent` task instead.
 */
export const createTask = <ThrowOnError extends boolean = false>(options: Options<CreateTaskData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTaskResponse, CreateTaskError, ThrowOnError>({
    ...options,
    url: '/tasks',
  });
};

/**
 * Delete a task
 * A specific, existing task can be deleted by making a DELETE request on
 * the URL for that task. Deleted tasks go into the “trash” of the user
 * making the delete request. Tasks can be recovered from the trash within a
 * period of 30 days; afterward they are completely removed from the system.
 *
 * Returns an empty data record.
 */
export const deleteTask = <ThrowOnError extends boolean = false>(options: Options<DeleteTaskData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteTaskResponse, DeleteTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}',
  });
};

/**
 * Get a task
 * Returns the complete task record for a single task.
 */
export const getTask = <ThrowOnError extends boolean = false>(options: Options<GetTaskData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTaskResponse, GetTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}',
  });
};

/**
 * Update a task
 * A specific, existing task can be updated by making a PUT request on the
 * URL for that task. Only the fields provided in the `data` block will be
 * updated; any unspecified fields will remain unchanged.
 *
 * When using this method, it is best to specify only those fields you wish
 * to change, or else you may overwrite changes made by another user since
 * you last retrieved the task.
 *
 * Returns the complete updated task record.
 */
export const updateTask = <ThrowOnError extends boolean = false>(options: Options<UpdateTaskData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateTaskResponse, UpdateTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}',
  });
};

/**
 * Set dependencies for a task
 * Marks a set of tasks as dependencies of this task, if they are not already dependencies. *A task can have at most 30 dependents and dependencies combined*.
 */
export const addDependenciesForTask = <ThrowOnError extends boolean = false>(
  options: Options<AddDependenciesForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddDependenciesForTaskResponse, AddDependenciesForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/addDependencies',
  });
};

/**
 * Set dependents for a task
 * Marks a set of tasks as dependents of this task, if they are not already dependents. *A task can have at most 30 dependents and dependencies combined*.
 */
export const addDependentsForTask = <ThrowOnError extends boolean = false>(
  options: Options<AddDependentsForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddDependentsForTaskResponse, AddDependentsForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/addDependents',
  });
};

/**
 * Add followers to a task
 * Adds followers to a task. Returns an empty data block.
 * Each task can be associated with zero or more followers in the system.
 * Requests to add/remove followers, if successful, will return the complete updated task record, described above.
 */
export const addFollowersForTask = <ThrowOnError extends boolean = false>(
  options: Options<AddFollowersForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddFollowersForTaskResponse, AddFollowersForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/addFollowers',
  });
};

/**
 * Add a project to a task
 * Adds the task to the specified project, in the optional location
 * specified. If no location arguments are given, the task will be added to
 * the end of the project.
 *
 * `addProject` can also be used to reorder a task within a project or
 * section that already contains it.
 *
 * At most one of `insert_before`, `insert_after`, or `section` should be
 * specified. Inserting into a section in an non-order-dependent way can be
 * done by specifying section, otherwise, to insert within a section in a
 * particular place, specify `insert_before` or `insert_after` and a task
 * within the section to anchor the position of this task.
 *
 * Returns an empty data block.
 */
export const addProjectForTask = <ThrowOnError extends boolean = false>(
  options: Options<AddProjectForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddProjectForTaskResponse, AddProjectForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/addProject',
  });
};

/**
 * Add a tag to a task
 * Adds a tag to a task. Returns an empty data block.
 */
export const addTagForTask = <ThrowOnError extends boolean = false>(
  options: Options<AddTagForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddTagForTaskResponse, AddTagForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/addTag',
  });
};

/**
 * Get dependencies from a task
 * Returns the compact representations of all of the dependencies of a task.
 */
export const getDependenciesForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetDependenciesForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDependenciesForTaskResponse, GetDependenciesForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/dependencies',
  });
};

/**
 * Get dependents from a task
 * Returns the compact representations of all of the dependents of a task.
 */
export const getDependentsForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetDependentsForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDependentsForTaskResponse, GetDependentsForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/dependents',
  });
};

/**
 * Duplicate a task
 * Creates and returns a job that will asynchronously handle the duplication.
 */
export const duplicateTask = <ThrowOnError extends boolean = false>(
  options: Options<DuplicateTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DuplicateTaskResponse, DuplicateTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/duplicate',
  });
};

/**
 * Get projects a task is in
 * Returns a compact representation of all of the projects the task is in.
 */
export const getProjectsForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectsForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectsForTaskResponse, GetProjectsForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/projects',
  });
};

/**
 * Unlink dependencies from a task
 * Unlinks a set of dependencies from this task.
 */
export const removeDependenciesForTask = <ThrowOnError extends boolean = false>(
  options: Options<RemoveDependenciesForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    RemoveDependenciesForTaskResponse,
    RemoveDependenciesForTaskError,
    ThrowOnError
  >({
    ...options,
    url: '/tasks/{task_gid}/removeDependencies',
  });
};

/**
 * Unlink dependents from a task
 * Unlinks a set of dependents from this task.
 */
export const removeDependentsForTask = <ThrowOnError extends boolean = false>(
  options: Options<RemoveDependentsForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveDependentsForTaskResponse, RemoveDependentsForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/removeDependents',
  });
};

/**
 * Remove followers from a task
 * Removes each of the specified followers from the task if they are following. Returns the complete, updated record for the affected task.
 */
export const removeFollowerForTask = <ThrowOnError extends boolean = false>(
  options: Options<RemoveFollowerForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveFollowerForTaskResponse, RemoveFollowerForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/removeFollowers',
  });
};

/**
 * Remove a project from a task
 * Removes the task from the specified project. The task will still exist in
 * the system, but it will not be in the project anymore.
 *
 * Returns an empty data block.
 */
export const removeProjectForTask = <ThrowOnError extends boolean = false>(
  options: Options<RemoveProjectForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveProjectForTaskResponse, RemoveProjectForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/removeProject',
  });
};

/**
 * Remove a tag from a task
 * Removes a tag from a task. Returns an empty data block.
 */
export const removeTagForTask = <ThrowOnError extends boolean = false>(
  options: Options<RemoveTagForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveTagForTaskResponse, RemoveTagForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/removeTag',
  });
};

/**
 * Set the parent of a task
 * parent, or no parent task at all. Returns an empty data block. When using `insert_before` and `insert_after`, at most one of those two options can be specified, and they must already be subtasks of the parent.
 */
export const setParentForTask = <ThrowOnError extends boolean = false>(
  options: Options<SetParentForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SetParentForTaskResponse, SetParentForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/setParent',
  });
};

/**
 * Get stories from a task
 * Returns the compact records for all stories on the task.
 */
export const getStoriesForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetStoriesForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetStoriesForTaskResponse, GetStoriesForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/stories',
  });
};

/**
 * Create a story on a task
 * Adds a story to a task. This endpoint currently only allows for comment
 * stories to be created. The comment will be authored by the currently
 * authenticated user, and timestamped when the server receives the request.
 *
 * Returns the full record for the new story added to the task.
 */
export const createStoryForTask = <ThrowOnError extends boolean = false>(
  options: Options<CreateStoryForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateStoryForTaskResponse, CreateStoryForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/stories',
  });
};

/**
 * Get subtasks from a task
 * Returns a compact representation of all of the subtasks of a task.
 */
export const getSubtasksForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetSubtasksForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSubtasksForTaskResponse, GetSubtasksForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/subtasks',
  });
};

/**
 * Create a subtask
 * Creates a new subtask and adds it to the parent task. Returns the full record for the newly created subtask.
 */
export const createSubtaskForTask = <ThrowOnError extends boolean = false>(
  options: Options<CreateSubtaskForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSubtaskForTaskResponse, CreateSubtaskForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/subtasks',
  });
};

/**
 * Get a task's tags
 * Get a compact representation of all of the tags the task has.
 */
export const getTagsForTask = <ThrowOnError extends boolean = false>(
  options: Options<GetTagsForTaskData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTagsForTaskResponse, GetTagsForTaskError, ThrowOnError>({
    ...options,
    url: '/tasks/{task_gid}/tags',
  });
};

/**
 * Get team memberships
 * Returns compact team membership records.
 */
export const getTeamMemberships = <ThrowOnError extends boolean = false>(
  options?: Options<GetTeamMembershipsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamMembershipsResponse, GetTeamMembershipsError, ThrowOnError>({
    ...options,
    url: '/team_memberships',
  });
};

/**
 * Get a team membership
 * Returns the complete team membership record for a single team membership.
 */
export const getTeamMembership = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamMembershipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamMembershipResponse, GetTeamMembershipError, ThrowOnError>({
    ...options,
    url: '/team_memberships/{team_membership_gid}',
  });
};

/**
 * Create a team
 * Creates a team within the current workspace.
 */
export const createTeam = <ThrowOnError extends boolean = false>(options: Options<CreateTeamData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTeamResponse, CreateTeamError, ThrowOnError>({
    ...options,
    url: '/teams',
  });
};

/**
 * Update a team
 * Updates a team within the current workspace.
 */
export const updateTeam = <ThrowOnError extends boolean = false>(options: Options<UpdateTeamData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateTeamResponse, UpdateTeamError, ThrowOnError>({
    ...options,
    url: '/teams',
  });
};

/**
 * Get a team
 * Returns the full record for a single team.
 */
export const getTeam = <ThrowOnError extends boolean = false>(options: Options<GetTeamData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTeamResponse, GetTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}',
  });
};

/**
 * Add a user to a team
 * The user making this call must be a member of the team in order to add others. The user being added must exist in the same organization as the team.
 *
 * Returns the complete team membership record for the newly added user.
 */
export const addUserForTeam = <ThrowOnError extends boolean = false>(
  options: Options<AddUserForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddUserForTeamResponse, AddUserForTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}/addUser',
  });
};

/**
 * Get a team's project templates
 * Returns the compact project template records for all project templates in the team.
 */
export const getProjectTemplatesForTeam = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectTemplatesForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetProjectTemplatesForTeamResponse,
    GetProjectTemplatesForTeamError,
    ThrowOnError
  >({
    ...options,
    url: '/teams/{team_gid}/project_templates',
  });
};

/**
 * Get a team's projects
 * Returns the compact project records for all projects in the team.
 */
export const getProjectsForTeam = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectsForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectsForTeamResponse, GetProjectsForTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}/projects',
  });
};

/**
 * Create a project in a team
 * Creates a project shared with the given team.
 *
 * Returns the full record of the newly created project.
 */
export const createProjectForTeam = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectForTeamResponse, CreateProjectForTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}/projects',
  });
};

/**
 * Remove a user from a team
 * The user making this call must be a member of the team in order to remove themselves or others.
 */
export const removeUserForTeam = <ThrowOnError extends boolean = false>(
  options: Options<RemoveUserForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveUserForTeamResponse, RemoveUserForTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}/removeUser',
  });
};

/**
 * Get memberships from a team
 * Returns the compact team memberships for the team.
 */
export const getTeamMembershipsForTeam = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamMembershipsForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTeamMembershipsForTeamResponse,
    GetTeamMembershipsForTeamError,
    ThrowOnError
  >({
    ...options,
    url: '/teams/{team_gid}/team_memberships',
  });
};

/**
 * Get users in a team
 * Returns the compact records for all users that are members of the team.
 * Results are sorted alphabetically and limited to 2000. For more results use the `/users` endpoint.
 */
export const getUsersForTeam = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersForTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersForTeamResponse, GetUsersForTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{team_gid}/users',
  });
};

/**
 * Get time periods
 * Returns compact time period records.
 */
export const getTimePeriods = <ThrowOnError extends boolean = false>(
  options: Options<GetTimePeriodsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTimePeriodsResponse, GetTimePeriodsError, ThrowOnError>({
    ...options,
    url: '/time_periods',
  });
};

/**
 * Get a time period
 * Returns the full record for a single time period.
 */
export const getTimePeriod = <ThrowOnError extends boolean = false>(
  options: Options<GetTimePeriodData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTimePeriodResponse, GetTimePeriodError, ThrowOnError>({
    ...options,
    url: '/time_periods/{time_period_gid}',
  });
};

/**
 * Get a user task list
 * Returns the full record for a user task list.
 */
export const getUserTaskList = <ThrowOnError extends boolean = false>(
  options: Options<GetUserTaskListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserTaskListResponse, GetUserTaskListError, ThrowOnError>({
    ...options,
    url: '/user_task_lists/{user_task_list_gid}',
  });
};

/**
 * Get tasks from a user task list
 * Returns the compact list of tasks in a user’s My Tasks list.
 * *Note: Access control is enforced for this endpoint as with all Asana API endpoints, meaning a user’s private tasks will be filtered out if the API-authenticated user does not have access to them.*
 * *Note: Both complete and incomplete tasks are returned by default unless they are filtered out (for example, setting `completed_since=now` will return only incomplete tasks, which is the default view for “My Tasks” in Asana.)*
 */
export const getTasksForUserTaskList = <ThrowOnError extends boolean = false>(
  options: Options<GetTasksForUserTaskListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTasksForUserTaskListResponse, GetTasksForUserTaskListError, ThrowOnError>({
    ...options,
    url: '/user_task_lists/{user_task_list_gid}/tasks',
  });
};

/**
 * Get multiple users
 * Returns the user records for all users in all workspaces and organizations accessible to the authenticated user. Accepts an optional workspace ID parameter.
 * Results are sorted by user ID.
 */
export const getUsers = <ThrowOnError extends boolean = false>(options?: Options<GetUsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUsersResponse, GetUsersError, ThrowOnError>({
    ...options,
    url: '/users',
  });
};

/**
 * Get a user
 * Returns the full user record for the single user with the provided ID.
 */
export const getUser = <ThrowOnError extends boolean = false>(options: Options<GetUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUserResponse, GetUserError, ThrowOnError>({
    ...options,
    url: '/users/{user_gid}',
  });
};

/**
 * Get a user's favorites
 * Returns all of a user's favorites in the given workspace, of the given type.
 * Results are given in order (The same order as Asana's sidebar).
 */
export const getFavoritesForUser = <ThrowOnError extends boolean = false>(
  options: Options<GetFavoritesForUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFavoritesForUserResponse, GetFavoritesForUserError, ThrowOnError>({
    ...options,
    url: '/users/{user_gid}/favorites',
  });
};

/**
 * Get memberships from a user
 * Returns the compact team membership records for the user.
 */
export const getTeamMembershipsForUser = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamMembershipsForUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTeamMembershipsForUserResponse,
    GetTeamMembershipsForUserError,
    ThrowOnError
  >({
    ...options,
    url: '/users/{user_gid}/team_memberships',
  });
};

/**
 * Get teams for a user
 * Returns the compact records for all teams to which the given user is assigned.
 */
export const getTeamsForUser = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamsForUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamsForUserResponse, GetTeamsForUserError, ThrowOnError>({
    ...options,
    url: '/users/{user_gid}/teams',
  });
};

/**
 * Get a user's task list
 * Returns the full record for a user's task list.
 */
export const getUserTaskListForUser = <ThrowOnError extends boolean = false>(
  options: Options<GetUserTaskListForUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUserTaskListForUserResponse, GetUserTaskListForUserError, ThrowOnError>({
    ...options,
    url: '/users/{user_gid}/user_task_list',
  });
};

/**
 * Get workspace memberships for a user
 * Returns the compact workspace membership records for the user.
 */
export const getWorkspaceMembershipsForUser = <ThrowOnError extends boolean = false>(
  options: Options<GetWorkspaceMembershipsForUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetWorkspaceMembershipsForUserResponse,
    GetWorkspaceMembershipsForUserError,
    ThrowOnError
  >({
    ...options,
    url: '/users/{user_gid}/workspace_memberships',
  });
};

/**
 * Get multiple webhooks
 * Get the compact representation of all webhooks your app has registered for the authenticated user in the given workspace.
 */
export const getWebhooks = <ThrowOnError extends boolean = false>(options: Options<GetWebhooksData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhooksResponse, GetWebhooksError, ThrowOnError>({
    ...options,
    url: '/webhooks',
  });
};

/**
 * Establish a webhook
 * Establishing a webhook is a two-part process. First, a simple HTTP POST
 * request initiates the creation similar to creating any other resource.
 *
 * Next, in the middle of this request comes the confirmation handshake.
 * When a webhook is created, we will send a test POST to the target with an
 * `X-Hook-Secret` header. The target must respond with a `200 OK` or `204
 * No Content` and a matching `X-Hook-Secret` header to confirm that this
 * webhook subscription is indeed expected. We strongly recommend storing
 * this secret to be used to verify future webhook event signatures.
 *
 * The POST request to create the webhook will then return with the status
 * of the request. If you do not acknowledge the webhook’s confirmation
 * handshake it will fail to setup, and you will receive an error in
 * response to your attempt to create it. This means you need to be able to
 * receive and complete the webhook *while* the POST request is in-flight
 * (in other words, have a server that can handle requests asynchronously).
 *
 * Invalid hostnames like localhost will recieve a 403 Forbidden status code.
 *
 * ```
 * # Request
 * curl -H "Authorization: Bearer <personal_access_token>" \
 * -X POST https://app.asana.com/api/1.0/webhooks \
 * -d "resource=8675309" \
 * -d "target=https://example.com/receive-webhook/7654"
 * ```
 *
 * ```
 * # Handshake sent to https://example.com/
 * POST /receive-webhook/7654
 * X-Hook-Secret: b537207f20cbfa02357cf448134da559e8bd39d61597dcd5631b8012eae53e81
 * ```
 *
 * ```
 * # Handshake response sent by example.com
 * HTTP/1.1 200
 * X-Hook-Secret: b537207f20cbfa02357cf448134da559e8bd39d61597dcd5631b8012eae53e81
 * ```
 *
 * ```
 * # Response
 * HTTP/1.1 201
 * {
 * "data": {
 * "gid": "43214",
 * "resource": {
 * "gid": "8675309",
 * "name": "Bugs"
 * },
 * "target": "https://example.com/receive-webhook/7654",
 * "active": false,
 * "last_success_at": null,
 * "last_failure_at": null,
 * "last_failure_content": null
 * }
 * }
 * ```
 */
export const createWebhook = <ThrowOnError extends boolean = false>(
  options: Options<CreateWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateWebhookResponse, CreateWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks',
  });
};

/**
 * Delete a webhook
 * This method *permanently* removes a webhook. Note that it may be possible to receive a request that was already in flight after deleting the webhook, but no further requests will be issued.
 */
export const deleteWebhook = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookResponse, DeleteWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_gid}',
  });
};

/**
 * Get a webhook
 * Returns the full record for the given webhook.
 */
export const getWebhook = <ThrowOnError extends boolean = false>(options: Options<GetWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhookResponse, GetWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_gid}',
  });
};

/**
 * Update a webhook
 * An existing webhook's filters can be updated by making a PUT request on the URL for that webhook. Note that the webhook's previous `filters` array will be completely overwritten by the `filters` sent in the PUT request.
 */
export const updateWebhook = <ThrowOnError extends boolean = false>(
  options: Options<UpdateWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateWebhookResponse, UpdateWebhookError, ThrowOnError>({
    ...options,
    url: '/webhooks/{webhook_gid}',
  });
};

/**
 * Get a workspace membership
 * Returns the complete workspace record for a single workspace membership.
 */
export const getWorkspaceMembership = <ThrowOnError extends boolean = false>(
  options: Options<GetWorkspaceMembershipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWorkspaceMembershipResponse, GetWorkspaceMembershipError, ThrowOnError>({
    ...options,
    url: '/workspace_memberships/{workspace_membership_gid}',
  });
};

/**
 * Get multiple workspaces
 * Returns the compact records for all workspaces visible to the authorized user.
 */
export const getWorkspaces = <ThrowOnError extends boolean = false>(
  options?: Options<GetWorkspacesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWorkspacesResponse, GetWorkspacesError, ThrowOnError>({
    ...options,
    url: '/workspaces',
  });
};

/**
 * Get a workspace
 * Returns the full workspace record for a single workspace.
 */
export const getWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWorkspaceResponse, GetWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}',
  });
};

/**
 * Update a workspace
 * A specific, existing workspace can be updated by making a PUT request on the URL for that workspace. Only the fields provided in the data block will be updated; any unspecified fields will remain unchanged.
 * Currently the only field that can be modified for a workspace is its name.
 * Returns the complete, updated workspace record.
 */
export const updateWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<UpdateWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateWorkspaceResponse, UpdateWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}',
  });
};

/**
 * Add a user to a workspace or organization
 * Add a user to a workspace or organization.
 * The user can be referenced by their globally unique user ID or their email address. Returns the full user record for the invited user.
 */
export const addUserForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<AddUserForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddUserForWorkspaceResponse, AddUserForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/addUser',
  });
};

/**
 * Get audit log events
 * Retrieve the audit log events that have been captured in your domain.
 *
 * This endpoint will return a list of [AuditLogEvent](/docs/audit-log-event) objects, sorted by creation time in ascending order. Note that the Audit Log API captures events from October 8th, 2021 and later. Queries for events before this date will not return results.
 *
 * There are a number of query parameters (below) that can be used to filter the set of [AuditLogEvent](/docs/audit-log-event) objects that are returned in the response. Any combination of query parameters is valid. When no filters are provided, all of the events that have been captured in your domain will match.
 *
 * The list of events will always be [paginated](/docs/pagination). The default limit is 1000 events. The next set of events can be retrieved using the `offset` from the previous response. If there are no events that match the provided filters in your domain, the endpoint will return `null` for the `next_page` field. Querying again with the same filters may return new events if they were captured after the last request. Once a response includes a `next_page` with an `offset`, subsequent requests can be made with the latest `offset` to poll for new events that match the provided filters.
 *
 * When no `offset` is provided, the response will begin with the oldest events that match the provided filters. It is important to note that [AuditLogEvent](/docs/audit-log-event) objects will be permanently deleted from our systems after 90 days. If you wish to keep a permanent record of these events, we recommend using a SIEM tool to ingest and store these logs.
 */
export const getAuditLogEvents = <ThrowOnError extends boolean = false>(
  options: Options<GetAuditLogEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAuditLogEventsResponse, GetAuditLogEventsError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/audit_log_events',
  });
};

/**
 * Get a workspace's custom fields
 * Returns a list of the compact representation of all of the custom fields in a workspace.
 */
export const getCustomFieldsForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetCustomFieldsForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCustomFieldsForWorkspaceResponse,
    GetCustomFieldsForWorkspaceError,
    ThrowOnError
  >({
    ...options,
    url: '/workspaces/{workspace_gid}/custom_fields',
  });
};

/**
 * Get all projects in a workspace
 * Returns the compact project records for all projects in the workspace.
 * *Note: This endpoint may timeout for large domains. Prefer the `/teams/{team_gid}/projects` endpoint.*
 */
export const getProjectsForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectsForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectsForWorkspaceResponse, GetProjectsForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/projects',
  });
};

/**
 * Create a project in a workspace
 * Returns the compact project records for all projects in the workspace.
 *
 * If the workspace for your project is an organization, you must also
 * supply a team to share the project with.
 *
 * Returns the full record of the newly created project.
 */
export const createProjectForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateProjectForWorkspaceResponse,
    CreateProjectForWorkspaceError,
    ThrowOnError
  >({
    ...options,
    url: '/workspaces/{workspace_gid}/projects',
  });
};

/**
 * Remove a user from a workspace or organization
 * Remove a user from a workspace or organization.
 * The user making this call must be an admin in the workspace. The user can be referenced by their globally unique user ID or their email address.
 * Returns an empty data record.
 */
export const removeUserForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<RemoveUserForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RemoveUserForWorkspaceResponse, RemoveUserForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/removeUser',
  });
};

/**
 * Get tags in a workspace
 * Returns the compact tag records for some filtered set of tags. Use one or more of the parameters provided to filter the tags returned.
 */
export const getTagsForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetTagsForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTagsForWorkspaceResponse, GetTagsForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/tags',
  });
};

/**
 * Create a tag in a workspace
 * Creates a new tag in a workspace or organization.
 *
 * Every tag is required to be created in a specific workspace or
 * organization, and this cannot be changed once set. Note that you can use
 * the workspace parameter regardless of whether or not it is an
 * organization.
 *
 * Returns the full record of the newly created tag.
 */
export const createTagForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<CreateTagForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTagForWorkspaceResponse, CreateTagForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/tags',
  });
};

/**
 * Search tasks in a workspace
 * To mirror the functionality of the Asana web app's advanced search feature, the Asana API has a task search endpoint that allows you to build complex filters to find and retrieve the exact data you need.
 * #### Premium access
 * Like the Asana web product's advance search feature, this search endpoint will only be available to premium Asana users. A user is premium if any of the following is true:
 *
 * - The workspace in which the search is being performed is a premium workspace - The user is a member of a premium team inside the workspace
 *
 * Even if a user is only a member of a premium team inside a non-premium workspace, search will allow them to find data anywhere in the workspace, not just inside the premium team. Making a search request using credentials of a non-premium user will result in a `402 Payment Required` error.
 * #### Pagination
 * Search results are not stable; repeating the same query multiple times may return the data in a different order, even if the data do not change. Because of this, the traditional [pagination](https://developers.asana.com/docs/#pagination) available elsewhere in the Asana API is not available here. However, you can paginate manually by sorting the search results by their creation time and then modifying each subsequent query to exclude data you have already seen. Page sizes are limited to a maximum of 100 items, and can be specified by the `limit` query parameter.
 * #### Eventual consistency
 * Changes in Asana (regardless of whether they’re made though the web product or the API) are forwarded to our search infrastructure to be indexed. This process can take between 10 and 60 seconds to complete under normal operation, and longer during some production incidents. Making a change to a task that would alter its presence in a particular search query will not be reflected immediately. This is also true of the advanced search feature in the web product.
 * #### Rate limits
 * You may receive a `429 Too Many Requests` response if you hit any of our [rate limits](https://developers.asana.com/docs/#rate-limits).
 * #### Custom field parameters
 * | Parameter name | Custom field type | Accepted type |
 * |---|---|---|
 * | custom_fields.{gid}.is_set | All | Boolean |
 * | custom_fields.{gid}.value | Text | String |
 * | custom_fields.{gid}.value | Number | Number |
 * | custom_fields.{gid}.value | Enum | Enum option ID |
 * | custom_fields.{gid}.starts_with | Text only | String |
 * | custom_fields.{gid}.ends_with | Text only | String |
 * | custom_fields.{gid}.contains | Text only | String |
 * | custom_fields.{gid}.less_than | Number only | Number |
 * | custom_fields.{gid}.greater_than | Number only | Number |
 *
 *
 * For example, if the gid of the custom field is 12345, these query parameter to find tasks where it is set would be `custom_fields.12345.is_set=true`. To match an exact value for an enum custom field, use the gid of the desired enum option and not the name of the enum option: `custom_fields.12345.value=67890`.
 *
 * **Not Supported**: searching for multiple exact matches of a custom field, searching for multi-enum custom field
 *
 * *Note: If you specify `projects.any` and `sections.any`, you will receive tasks for the project **and** tasks for the section. If you're looking for only tasks in a section, omit the `projects.any` from the request.*
 */
export const searchTasksForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<SearchTasksForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchTasksForWorkspaceResponse, SearchTasksForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/tasks/search',
  });
};

/**
 * Get teams in a workspace
 * Returns the compact records for all teams in the workspace visible to the authorized user.
 */
export const getTeamsForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamsForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamsForWorkspaceResponse, GetTeamsForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/teams',
  });
};

/**
 * Get objects via typeahead
 * Retrieves objects in the workspace based via an auto-completion/typeahead
 * search algorithm. This feature is meant to provide results quickly, so do
 * not rely on this API to provide extremely accurate search results. The
 * result set is limited to a single page of results with a maximum size, so
 * you won’t be able to fetch large numbers of results.
 *
 * The typeahead search API provides search for objects from a single
 * workspace. This endpoint should be used to query for objects when
 * creating an auto-completion/typeahead search feature. This API is meant
 * to provide results quickly and should not be relied upon for accurate or
 * exhaustive search results. The results sets are limited in size and
 * cannot be paginated.
 *
 * Queries return a compact representation of each object which is typically
 * the gid and name fields. Interested in a specific set of fields or all of
 * the fields?! Of course you are. Use field selectors to manipulate what
 * data is included in a response.
 *
 * Resources with type `user` are returned in order of most contacted to
 * least contacted. This is determined by task assignments, adding the user
 * to projects, and adding the user as a follower to tasks, messages,
 * etc.
 *
 * Resources with type `project` are returned in order of recency. This is
 * determined when the user visits the project, is added to the project, and
 * completes tasks in the project.
 *
 * Resources with type `task` are returned with priority placed on tasks
 * the user is following, but no guarantee on the order of those tasks.
 *
 * Resources with type `project_template` are returned with priority
 * placed on favorited project templates.
 *
 * Leaving the `query` string empty or omitted will give you results, still
 * following the resource ordering above. This could be used to list users or
 * projects that are relevant for the requesting user's api token.
 */
export const typeaheadForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<TypeaheadForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TypeaheadForWorkspaceResponse, TypeaheadForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/typeahead',
  });
};

/**
 * Get users in a workspace or organization
 * Returns the compact records for all users in the specified workspace or organization.
 * Results are sorted alphabetically and limited to 2000. For more results use the `/users` endpoint.
 */
export const getUsersForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetUsersForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetUsersForWorkspaceResponse, GetUsersForWorkspaceError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspace_gid}/users',
  });
};

/**
 * Get the workspace memberships for a workspace
 * Returns the compact workspace membership records for the workspace.
 */
export const getWorkspaceMembershipsForWorkspace = <ThrowOnError extends boolean = false>(
  options: Options<GetWorkspaceMembershipsForWorkspaceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetWorkspaceMembershipsForWorkspaceResponse,
    GetWorkspaceMembershipsForWorkspaceError,
    ThrowOnError
  >({
    ...options,
    url: '/workspaces/{workspace_gid}/workspace_memberships',
  });
};
