// This file is auto-generated by @hey-api/openapi-ts

export const AddCustomFieldSettingRequestSchema = {
  properties: {
    custom_field: {
      description: 'The custom field to associate with this container.',
      example: '14916',
      type: 'string',
    },
    insert_after: {
      description:
        'A gid of a Custom Field Setting on this container, after which the new Custom Field Setting will be added.  `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    insert_before: {
      description:
        'A gid of a Custom Field Setting on this container, before which the new Custom Field Setting will be added.  `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    is_important: {
      description:
        'Whether this field should be considered important to this container (for instance, to display in the list view of items in the container).',
      example: true,
      type: 'boolean',
    },
  },
  required: ['custom_field'],
  type: 'object',
} as const;

export const AddFollowersRequestSchema = {
  properties: {
    followers: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: '521621,621373',
      type: 'string',
    },
  },
  required: ['followers'],
  type: 'object',
} as const;

export const AddMembersRequestSchema = {
  properties: {
    members: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: '521621,621373',
      type: 'string',
    },
  },
  required: ['members'],
  type: 'object',
} as const;

export const AsanaNamedResourceSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        name: {
          description: 'The name of the object.',
          example: 'Bug Task',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const AsanaResourceSchema = {
  description: 'A generic Asana Resource, containing a globally unique identifier.',
  properties: {
    gid: {
      description: 'Globally unique identifier of the resource, as a string.',
      example: '12345',
      readOnly: true,
      type: 'string',
      'x-insert-after': false,
    },
    resource_type: {
      description: 'The base type of this resource.',
      example: 'task',
      readOnly: true,
      type: 'string',
      'x-insert-after': 'gid',
    },
  },
  type: 'object',
} as const;

export const AttachmentBaseSchema = {
  $ref: '#/components/schemas/AttachmentCompact',
} as const;

export const AttachmentCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'An *attachment* object represents any file attached to a task in Asana, whether it’s an uploaded file or one associated via a third-party service such as Dropbox or Google Drive.',
      properties: {
        name: {
          description: 'The name of the file.',
          example: 'Screenshot.png',
          readOnly: true,
          type: 'string',
        },
        resource_subtype: {
          description:
            'The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `onedrive`, `box`, `vimeo`, and `external`.',
          example: 'dropbox',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'attachment',
      },
    },
  ],
} as const;

export const AttachmentRequestSchema = {
  properties: {
    connect_to_app: {
      description: `*Optional*. Only relevant for external attachments with a parent task. A boolean indicating whether the current app should be connected with the attachment for the purposes of showing an app components widget. Requires the app to have been added to a project the parent task is in.
`,
      type: 'boolean',
    },
    file: {
      description: `Required for \`asana\` attachments.
`,
      format: 'binary',
      type: 'string',
    },
    name: {
      description: `The name of the external resource being attached. Required for attachments of type \`external\`.
`,
      type: 'string',
    },
    parent: {
      description: `Required identifier of the parent task, project, or project_brief, as a string.
`,
      type: 'string',
    },
    resource_subtype: {
      description: `The type of the attachment. Must be one of the given values. If not specified, a file attachment of type \`asana\` will be assumed. Note that if the value of \`resource_subtype\` is \`external\`, a \`parent\`, \`name\`, and \`url\` must also be provided.
`,
      enum: ['asana', 'dropbox', 'gdrive', 'onedrive', 'box', 'vimeo', 'external'],
      example: 'external',
      type: 'string',
    },
    url: {
      description: `The URL of the external resource being attached. Required for attachments of type \`external\`.
`,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const AttachmentResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AttachmentCompact',
    },
    {
      properties: {
        connected_to_app: {
          description:
            'Whether the attachment is connected to the app making the request for the purposes of showing an app components widget. Only present when the `resource_subtype` is `external` or `gdrive`.',
          readOnly: true,
          type: 'boolean',
        },
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        download_url: {
          description: `The URL containing the content of the attachment.
*Note:* May be null if the attachment is hosted by [Box](https://www.box.com/) and will be null if the attachment is a Video Message hosted by [Vimeo](https://vimeo.com/). If present, this URL may only be valid for two minutes from the time of retrieval. You should avoid persisting this URL somewhere and just refresh it on demand to ensure you do not keep stale URLs.`,
          example: 'https://s3.amazonaws.com/assets/123/Screenshot.png',
          format: 'uri',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        host: {
          description:
            'The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `box`, and `vimeo`.',
          example: 'dropbox',
          readOnly: true,
          type: 'string',
        },
        parent: {
          allOf: [
            {
              $ref: '#/components/schemas/TaskCompact',
            },
            {
              description: 'The task this attachment is attached to.',
              properties: {
                resource_subtype: {
                  description: 'The resource subtype of the parent resource that the filter applies to.',
                  example: 'default_task',
                  nullable: true,
                  type: 'string',
                },
              },
              readOnly: true,
              type: 'object',
            },
          ],
        },
        permanent_url: {
          description: '',
          example: 'https://s3.amazonaws.com/assets/123/Screenshot.png',
          format: 'uri',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        size: {
          description: 'The size of the attachment in bytes. Only present when the `resource_subtype` is `asana`.',
          example: 12345,
          readOnly: true,
          type: 'integer',
        },
        view_url: {
          description:
            'The URL where the attachment can be viewed, which may be friendlier to users in a browser than just directing them to a raw file. May be null if no view URL exists for the service.',
          example: 'https://www.dropbox.com/s/123/Screenshot.png',
          format: 'uri',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const AuditLogEventSchema = {
  description: `An object representing a single event within an Asana domain.

Every audit log event is comprised of an \`event_type\`, \`actor\`, \`resource\`, and \`context\`. Some events will include additional metadata about the event under \`details\`. See our [currently supported list of events](/docs/supported-auditlogevents) for more details.`,
  properties: {
    actor: {
      allOf: [
        {
          $ref: '#/components/schemas/AuditLogEventActor',
        },
      ],
    },
    context: {
      allOf: [
        {
          $ref: '#/components/schemas/AuditLogEventContext',
        },
      ],
    },
    created_at: {
      description: 'The time the event was created.',
      example: '2021-01-01T00:00:00.000Z',
      format: 'date-time',
      type: 'string',
    },
    details: {
      allOf: [
        {
          $ref: '#/components/schemas/AuditLogEventDetails',
        },
      ],
    },
    event_category: {
      description: 'The category that this `event_type` belongs to.',
      example: 'deletion',
      type: 'string',
    },
    event_type: {
      description: 'The type of the event.',
      example: 'task_deleted',
      type: 'string',
    },
    gid: {
      description: 'Globally unique identifier of the `AuditLogEvent`, as a string.',
      example: '12345',
      type: 'string',
      'x-insert-after': false,
    },
    resource: {
      allOf: [
        {
          $ref: '#/components/schemas/AuditLogEventResource',
        },
      ],
    },
  },
  type: 'object',
} as const;

export const AuditLogEventActorSchema = {
  description: 'The entity that triggered the event. Will typically be a user.',
  properties: {
    actor_type: {
      description: `The type of actor.
Can be one of \`user\`, \`asana\`, \`asana_support\`, \`anonymous\`, or \`external_administrator\`.`,
      enum: ['user', 'asana', 'asana_support', 'anonymous', 'external_administrator'],
      example: 'user',
      type: 'string',
    },
    email: {
      description: 'The email of the actor, if it is a user.',
      example: 'gregsanchez@example.com',
      type: 'string',
    },
    gid: {
      description: 'Globally unique identifier of the actor, if it is a user.',
      example: '1111',
      type: 'string',
    },
    name: {
      description: 'The name of the actor, if it is a user.',
      example: 'Greg Sanchez',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const AuditLogEventContextSchema = {
  description: 'The context from which this event originated.',
  properties: {
    api_authentication_method: {
      description: `The authentication method used in the context of an API request.
Only present if the \`context_type\` is \`api\`. Can be one of \`cookie\`, \`oauth\`, \`personal_access_token\`, or \`service_account\`.`,
      enum: ['cookie', 'oauth', 'personal_access_token', 'service_account'],
      type: 'string',
    },
    client_ip_address: {
      description: 'The IP address of the client that initiated the event, if applicable.',
      example: '1.1.1.1',
      type: 'string',
    },
    context_type: {
      description: `The type of context.
Can be one of \`web\`, \`desktop\`, \`mobile\`, \`asana_support\`, \`asana\`, \`email\`, or \`api\`.`,
      enum: ['web', 'desktop', 'mobile', 'asana_support', 'asana', 'email', 'api'],
      example: 'web',
      type: 'string',
    },
    oauth_app_name: {
      description: `The name of the OAuth App that initiated the event.
Only present if the \`api_authentication_method\` is \`oauth\`.`,
      type: 'string',
    },
    user_agent: {
      description: 'The user agent of the client that initiated the event, if applicable.',
      example:
        'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const AuditLogEventDetailsSchema = {
  description: 'Event specific details. The schema will vary depending on the `event_type`.',
  type: 'object',
} as const;

export const AuditLogEventResourceSchema = {
  description: 'The primary object that was affected by this event.',
  properties: {
    email: {
      description: 'The email of the resource, if applicable.',
      type: 'string',
    },
    gid: {
      description: 'Globally unique identifier of the resource.',
      example: '1111',
      type: 'string',
    },
    name: {
      description: 'The name of the resource.',
      example: 'Example Task',
      type: 'string',
    },
    resource_subtype: {
      description: 'The subtype of resource. Most resources will not have a subtype.',
      example: 'milestone',
      type: 'string',
    },
    resource_type: {
      description: 'The type of resource.',
      example: 'task',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const BatchRequestSchema = {
  description: 'A request object for use in a batch request.',
  properties: {
    actions: {
      items: {
        $ref: '#/components/schemas/BatchRequestAction',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const BatchRequestActionSchema = {
  description: 'An action object for use in a batch request.',
  properties: {
    data: {
      description:
        'For `GET` requests, this should be a map of query parameters you would have normally passed in the URL. Options and pagination are not accepted here; put them in `options` instead. For `POST`, `PATCH`, and `PUT` methods, this should be the content you would have normally put in the data field of the body.',
      example: {
        assignee: 'me',
        workspace: '1337',
      },
      type: 'object',
    },
    method: {
      description: 'The HTTP method you wish to emulate for the action.',
      enum: ['get', 'post', 'put', 'delete', 'patch', 'head'],
      example: 'get',
      type: 'string',
    },
    options: {
      description:
        'Pagination (`limit` and `offset`) and output options (`fields` or `expand`) for the action. “Pretty” JSON output is not an available option on individual actions; if you want pretty output, specify that option on the parent request.',
      example: {
        fields: ['name', 'notes', 'completed'],
        limit: 3,
      },
      properties: {
        fields: {
          description: 'The fields to retrieve in the request.',
          example: ['name', 'gid', 'notes', 'completed'],
          items: {
            type: 'string',
          },
          type: 'array',
        },
        limit: {
          description: 'Pagination limit for the request.',
          example: 50,
          type: 'integer',
        },
        offset: {
          description: 'Pagination offset for the request.',
          example: 'eyJ0eXAiOJiKV1iQLCJhbGciOiJIUzI1NiJ9',
          type: 'integer',
        },
      },
      type: 'object',
    },
    relative_path: {
      description:
        'The path of the desired endpoint relative to the API’s base URL. Query parameters are not accepted here; put them in `data` instead.',
      example: '/tasks/123',
      type: 'string',
    },
  },
  required: ['relative_path', 'method'],
  type: 'object',
} as const;

export const BatchResponseSchema = {
  description: 'A response object returned from a batch request.',
  properties: {
    body: {
      description: 'The JSON body that the invoked endpoint returned.',
      example: {
        data: {
          completed: false,
          gid: '1967',
          name: 'Hello, world!',
          notes: 'How are you today?',
        },
      },
      type: 'object',
    },
    headers: {
      description:
        'A map of HTTP headers specific to this result. This is primarily used for returning a `Location` header to accompany a `201 Created` result.  The parent HTTP response will contain all common headers.',
      example: {
        location: '/tasks/1234',
      },
      type: 'object',
    },
    status_code: {
      description: 'The HTTP status code that the invoked endpoint returned.',
      example: 200,
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const CustomFieldBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldCompact',
    },
    {
      properties: {
        asana_created_field: {
          description: '*Conditional*. A unique identifier to associate this field with the template source of truth.',
          enum: [
            'a_v_requirements',
            'account_name',
            'actionable',
            'align_shipping_link',
            'align_status',
            'allotted_time',
            'appointment',
            'approval_stage',
            'approved',
            'article_series',
            'board_committee',
            'browser',
            'campaign_audience',
            'campaign_project_status',
            'campaign_regions',
            'channel_primary',
            'client_topic_type',
            'complete_by',
            'contact',
            'contact_email_address',
            'content_channels',
            'content_channels_needed',
            'content_stage',
            'content_type',
            'contract',
            'contract_status',
            'cost',
            'creation_stage',
            'creative_channel',
            'creative_needed',
            'creative_needs',
            'data_sensitivity',
            'deal_size',
            'delivery_appt',
            'delivery_appt_date',
            'department',
            'department_responsible',
            'design_request_needed',
            'design_request_type',
            'discussion_category',
            'do_this_task',
            'editorial_content_status',
            'editorial_content_tag',
            'editorial_content_type',
            'effort',
            'effort_level',
            'est_completion_date',
            'estimated_time',
            'estimated_value',
            'expected_cost',
            'external_steps_needed',
            'favorite_idea',
            'feedback_type',
            'financial',
            'funding_amount',
            'grant_application_process',
            'hiring_candidate_status',
            'idea_status',
            'ids_link',
            'ids_patient_link',
            'implementation_stage',
            'insurance',
            'interview_area',
            'interview_question_score',
            'itero_scan_link',
            'job_s_applied_to',
            'lab',
            'launch_status',
            'lead_status',
            'localization_language',
            'localization_market_team',
            'localization_status',
            'meeting_minutes',
            'meeting_needed',
            'minutes',
            'mrr',
            'must_localize',
            'name_of_foundation',
            'need_to_follow_up',
            'next_appointment',
            'next_steps_sales',
            'num_people',
            'number_of_user_reports',
            'office_location',
            'onboarding_activity',
            'owner',
            'participants_needed',
            'patient_date_of_birth',
            'patient_email',
            'patient_phone',
            'patient_status',
            'phone_number',
            'planning_category',
            'point_of_contact',
            'position',
            'post_format',
            'prescription',
            'priority',
            'priority_level',
            'product',
            'product_stage',
            'progress',
            'project_size',
            'project_status',
            'proposed_budget',
            'publish_status',
            'reason_for_scan',
            'referral',
            'request_type',
            'research_status',
            'responsible_department',
            'responsible_team',
            'risk_assessment_status',
            'room_name',
            'sales_counterpart',
            'sentiment',
            'shipping_link',
            'social_channels',
            'stage',
            'status',
            'status_design',
            'status_of_initiative',
            'system_setup',
            'task_progress',
            'team',
            'team_marketing',
            'team_responsible',
            'time_it_takes_to_complete_tasks',
            'timeframe',
            'treatment_type',
            'type_work_requests_it',
            'use_agency',
            'user_name',
            'vendor_category',
            'vendor_type',
            'word_count',
          ],
          example: 'priority',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        currency_code: {
          description:
            'ISO 4217 currency code to format this custom field. This will be null if the `format` is not `currency`.',
          example: 'EUR',
          nullable: true,
          type: 'string',
        },
        custom_label: {
          description:
            'This is the string that appears next to the custom field value. This will be null if the `format` is not `custom`.',
          example: 'gold pieces',
          nullable: true,
          type: 'string',
        },
        custom_label_position: {
          description:
            'Only relevant for custom fields with `custom` format. This depicts where to place the custom label. This will be null if the `format` is not `custom`.',
          enum: ['prefix', 'suffix'],
          example: 'suffix',
          type: 'string',
        },
        description: {
          description: '[Opt In](/docs/input-output-options). The description of the custom field.',
          example: 'Development team priority',
          type: 'string',
        },
        enum_options: {
          description:
            '*Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/docs/create-an-enum-option).',
          items: {
            $ref: '#/components/schemas/EnumOption',
          },
          type: 'array',
        },
        format: {
          description: 'The format of this custom field.',
          enum: ['currency', 'identifier', 'percentage', 'custom', 'none'],
          example: 'custom',
          type: 'string',
        },
        has_notifications_enabled: {
          description:
            '*Conditional*. This flag describes whether a follower of a task with this field should receive inbox notifications from changes to this field.',
          example: true,
          type: 'boolean',
        },
        is_global_to_workspace: {
          description:
            'This flag describes whether this custom field is available to every container in the workspace. Before project-specific custom fields, this field was always true.',
          example: true,
          readOnly: true,
          type: 'boolean',
        },
        precision: {
          description: `Only relevant for custom fields of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive.
For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.
The identifier format will always have a precision of 0.`,
          example: 2,
          type: 'integer',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const CustomFieldCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: `Custom Fields store the metadata that is used in order to add user-specified information to tasks in Asana. Be sure to reference the [Custom Fields](/docs/asana-custom-fields) developer documentation for more information about how custom fields relate to various resources in Asana.

Users in Asana can [lock custom fields](https://asana.com/guide/help/premium/custom-fields#gl-lock-fields), which will make them read-only when accessed by other users. Attempting to edit a locked custom field will return HTTP error code \`403 Forbidden\`.`,
      properties: {
        date_value: {
          description:
            '*Conditional*. Only relevant for custom fields of type `date`. This object reflects the chosen date (and optionally, time) value of a `date` custom field. If no date is selected, the value of `date_value` will be `null`.',
          properties: {
            date: {
              description: 'A string representing the date in YYYY-MM-DD format.',
              example: '2024-08-23',
              type: 'string',
            },
            date_time: {
              description:
                'A string representing the date in ISO 8601 format. If no time value is selected, the value of `date-time` will be `null`.',
              example: '2024-08-23T22:00:00.000Z',
              type: 'string',
            },
          },
          type: 'object',
        },
        display_value: {
          description:
            "A string representation for the value of the custom field. Integrations that don't require the underlying type should use this field to read values. Using this field will future-proof an app against new custom field types.",
          example: 'blue',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        enabled: {
          description: '*Conditional*. Determines if the custom field is enabled or not.',
          example: true,
          type: 'boolean',
        },
        enum_options: {
          description:
            '*Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/docs/create-an-enum-option).',
          items: {
            $ref: '#/components/schemas/EnumOption',
          },
          type: 'array',
        },
        enum_value: {
          allOf: [
            {
              $ref: '#/components/schemas/EnumOption',
            },
            {
              description:
                '*Conditional*. Only relevant for custom fields of type `enum`. This object is the chosen value of an `enum` custom field.',
              type: 'object',
            },
          ],
        },
        multi_enum_values: {
          description:
            '*Conditional*. Only relevant for custom fields of type `multi_enum`. This object is the chosen values of a `multi_enum` custom field.',
          items: {
            $ref: '#/components/schemas/EnumOption',
          },
          type: 'array',
        },
        name: {
          description: 'The name of the custom field.',
          example: 'Status',
          type: 'string',
        },
        number_value: {
          description: '*Conditional*. This number is the value of a `number` custom field.',
          example: 5.2,
          type: 'number',
        },
        resource_subtype: {
          description: `The type of the custom field. Must be one of the given values.
`,
          enum: ['text', 'enum', 'multi_enum', 'number', 'date', 'people'],
          example: 'text',
          type: 'string',
        },
        text_value: {
          description: '*Conditional*. This string is the value of a `text` custom field.',
          example: 'Some Value',
          type: 'string',
        },
        type: {
          description: `*Deprecated: new integrations should prefer the resource_subtype field.* The type of the custom field. Must be one of the given values.
`,
          enum: ['text', 'enum', 'multi_enum', 'number'],
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'custom_field',
      },
    },
  ],
} as const;

export const CustomFieldRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldBase',
    },
    {
      properties: {
        people_value: {
          description:
            '*Conditional*. Only relevant for custom fields of type `people`. This array of user GIDs reflects the users to be written to a `people` custom field. Note that *write* operations will replace existing users (if any) in the custom field with the users specified in this array.',
          example: ['12345'],
          items: {
            description: 'The GID of a user.',
            type: 'string',
          },
          type: 'array',
        },
        workspace: {
          description: '*Create-Only* The workspace to create a custom field in.',
          example: '1331',
          type: 'string',
        },
      },
      required: ['workspace'],
      type: 'object',
    },
  ],
} as const;

export const CustomFieldResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldBase',
    },
    {
      properties: {
        created_by: {
          $ref: '#/components/schemas/UserCompact',
          nullable: true,
        },
        people_value: {
          description:
            '*Conditional*. Only relevant for custom fields of type `people`. This array of [compact user](/docs/user-compact) objects reflects the values of a `people` custom field.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const CustomFieldSettingBaseSchema = {
  $ref: '#/components/schemas/CustomFieldSettingCompact',
} as const;

export const CustomFieldSettingCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'Custom Fields Settings objects represent the many-to-many join of the Custom Field and Project as well as stores information that is relevant to that particular pairing.',
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'custom_field_setting',
      },
    },
  ],
} as const;

export const CustomFieldSettingResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CustomFieldSettingCompact',
    },
    {
      properties: {
        custom_field: {
          allOf: [
            {
              $ref: '#/components/schemas/CustomFieldResponse',
            },
            {
              description: 'The custom field that is applied to the `parent`.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
        is_important: {
          description: `\`is_important\` is used in the Asana web application to determine if this custom field is displayed in the list/grid view of a project or portfolio.`,
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        parent: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectCompact',
            },
            {
              description:
                'The parent to which the custom field is applied. This can be a project or portfolio and indicates that the tasks or projects that the parent contains may be given custom field values for this custom field.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
        project: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectCompact',
            },
            {
              description:
                '*Deprecated: new integrations should prefer the `parent` field.* The id of the project that this custom field settings refers to.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const DateVariableCompactSchema = {
  properties: {
    description: {
      description: 'The description of what the date variable is used for when instantiating a project.',
      example: 'Choose a start date for your project.',
      readOnly: true,
      type: 'string',
    },
    gid: {
      description:
        'Globally unique identifier of the date field in the project template. A value of `1` refers to the project start date, while `2` refers to the project due date.',
      example: '1',
      readOnly: true,
      type: 'string',
    },
    name: {
      description: 'The name of the date variable.',
      example: 'Start Date',
      readOnly: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const DateVariableRequestSchema = {
  properties: {
    gid: {
      description:
        'Globally unique identifier of the date field in the project template. A value of `1` refers to the project start date, while `2` refers to the project due date.',
      example: '1',
      type: 'string',
    },
    value: {
      description:
        'The date with which the date variable should be replaced when instantiating a project. This takes a date with `YYYY-MM-DD` format.',
      example: '2022-01-01',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const EmptyResponseSchema = {
  description:
    'An empty object. Some endpoints do not return an object on success. The success is conveyed through a 2-- status code and returning an empty object.',
  type: 'object',
} as const;

export const EnumOptionSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: `Enum options are the possible values which an enum custom field can adopt. An enum custom field must contain at least 1 enum option but no more than 500.

You can add enum options to a custom field by using the \`POST /custom_fields/custom_field_gid/enum_options\` endpoint.

**It is not possible to remove or delete an enum option**. Instead, enum options can be disabled by updating the \`enabled\` field to false with the \`PUT /enum_options/enum_option_gid\` endpoint. Other attributes can be updated similarly.

On creation of an enum option, \`enabled\` is always set to \`true\`, meaning the enum option is a selectable value for the custom field. Setting \`enabled=false\` is equivalent to “trashing” the enum option in the Asana web app within the “Edit Fields” dialog. The enum option will no longer be selectable but, if the enum option value was previously set within a task, the task will retain the value.

Enum options are an ordered list and by default new enum options are inserted at the end. Ordering in relation to existing enum options can be specified on creation by using \`insert_before\` or \`insert_after\` to reference an existing enum option. Only one of \`insert_before\` and \`insert_after\` can be provided when creating a new enum option.

An enum options list can be reordered with the \`POST /custom_fields/custom_field_gid/enum_options/insert\` endpoint.`,
      properties: {
        color: {
          description: 'The color of the enum option. Defaults to ‘none’.',
          example: 'blue',
          type: 'string',
        },
        enabled: {
          description: 'Whether or not the enum option is a selectable value for the custom field.',
          example: true,
          type: 'boolean',
        },
        name: {
          description: 'The name of the enum option.',
          example: 'Low',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'enum_option',
      },
    },
  ],
} as const;

export const EnumOptionBaseSchema = {
  $ref: '#/components/schemas/EnumOption',
} as const;

export const EnumOptionInsertRequestSchema = {
  properties: {
    after_enum_option: {
      description:
        'An existing enum option within this custom field after which the new enum option should be inserted. Cannot be provided together with before_enum_option.',
      example: '12345',
      type: 'string',
    },
    before_enum_option: {
      description:
        'An existing enum option within this custom field before which the new enum option should be inserted. Cannot be provided together with after_enum_option.',
      example: '12345',
      type: 'string',
    },
    enum_option: {
      description: 'The gid of the enum option to relocate.',
      example: '97285',
      type: 'string',
    },
  },
  required: ['enum_option'],
  type: 'object',
} as const;

export const EnumOptionRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/EnumOption',
    },
    {
      properties: {
        insert_after: {
          description:
            'An existing enum option within this custom field after which the new enum option should be inserted. Cannot be provided together with before_enum_option.',
          example: '12345',
          type: 'string',
        },
        insert_before: {
          description:
            'An existing enum option within this custom field before which the new enum option should be inserted. Cannot be provided together with after_enum_option.',
          example: '12345',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ErrorSchema = {
  properties: {
    help: {
      description:
        'Additional information directing developers to resources on how to address and fix the problem, if available.',
      example:
        "For more information on API status codes and how to handle them, read the docs on errors: https://asana.github.io/developer-docs/#errors'",
      readOnly: true,
      type: 'string',
    },
    message: {
      description: 'Message providing more detail about the error that occurred, if available.',
      example: 'project: Missing input',
      readOnly: true,
      type: 'string',
    },
    phrase: {
      description:
        '*500 errors only*. A unique error phrase which can be used when contacting developer support to help identify the exact occurrence of the problem in Asana’s logs.',
      example: '6 sad squid snuggle softly',
      readOnly: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ErrorResponseSchema = {
  description: `Sadly, sometimes requests to the API are not successful. Failures can
occur for a wide range of reasons. In all cases, the API should return
an HTTP Status Code that indicates the nature of the failure,
with a response body in JSON format containing additional information.


In the event of a server error the response body will contain an error
phrase. These phrases are automatically generated using the
[node-asana-phrase
library](https://github.com/Asana/node-asana-phrase) and can be used by
Asana support to quickly look up the incident that caused the server
error.`,
  properties: {
    errors: {
      items: {
        $ref: '#/components/schemas/Error',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const EventResponseSchema = {
  description: `An *event* is an object representing a change to a resource that was
observed by an event subscription or delivered asynchronously to
the target location of an active webhook.

The event may be triggered by a different \`user\` than the
subscriber. For example, if user A subscribes to a task and user B
modified it, the event’s user will be user B. Note: Some events
are generated by the system, and will have \`null\` as the user. API
consumers should make sure to handle this case.

The \`resource\` that triggered the event may be different from the one
that the events were requested for or the webhook is subscribed to. For
example, a subscription to a project will contain events for tasks
contained within the project.

**Note:** pay close attention to the relationship between the fields
\`Event.action\` and \`Event.change.action\`.
\`Event.action\` represents the action taken on the resource
itself, and \`Event.change.action\` represents how the information
within the resource's fields have been modified.

For instance, consider these scenarios:


* When at task is added to a project, \`Event.action\` will be
\`added\`, \`Event.parent\` will be an object with the \`id\` and
\`type\` of the project, and there will be no \`change\` field.


* When an assignee is set on the task, \`Event.parent\` will be
\`null\`, \`Event.action\` will be \`changed\`,
\`Event.change.action\` will be \`changed\`, and \`new_value\` will
be an object with the user's \`id\` and \`type\`.


* When a collaborator is added to the task, \`Event.parent\` will
be \`null\`, \`Event.action\` will be \`changed\`,
\`Event.change.action\` will be \`added\`, and \`added_value\` will be
an object with the user's \`id\` and \`type\`.`,
  properties: {
    action: {
      description:
        'The type of action taken on the **resource** that triggered the event.  This can be one of `changed`, `added`, `removed`, `deleted`, or `undeleted` depending on the nature of the event.',
      example: 'changed',
      readOnly: true,
      type: 'string',
    },
    change: {
      description:
        'Information about the type of change that has occurred. This field is only present when the value of the property `action`, describing the action taken on the **resource**, is `changed`.',
      properties: {
        action: {
          description:
            'The type of action taken on the **field** which has been changed.  This can be one of `changed`, `added`, or `removed` depending on the nature of the change.',
          example: 'changed',
          readOnly: true,
          type: 'string',
        },
        added_value: {
          description:
            "*Conditional.* This property is only present when the **field's** `action` is `added` _and_ the `added_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.",
          example: {
            gid: '12345',
            resource_type: 'user',
          },
        },
        field: {
          description: 'The name of the field that has changed in the resource.',
          example: 'assignee',
          readOnly: true,
          type: 'string',
        },
        new_value: {
          description:
            "*Conditional.* This property is only present when the **field's** `action` is `changed` _and_ the `new_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.",
          example: {
            gid: '12345',
            resource_type: 'user',
          },
        },
        removed_value: {
          description:
            "*Conditional.* This property is only present when the **field's** `action` is `removed` _and_ the `removed_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/input-output-options)) when using the [Events](/docs/asana-events) endpoint.",
          example: {
            gid: '12345',
            resource_type: 'user',
          },
        },
      },
      readOnly: true,
      type: 'object',
    },
    created_at: {
      description: 'The timestamp when the event occurred.',
      example: '2012-02-22T02:06:58.147Z',
      format: 'date-time',
      readOnly: true,
      type: 'string',
    },
    parent: {
      allOf: [
        {
          $ref: '#/components/schemas/AsanaNamedResource',
        },
        {
          description:
            'For added/removed events, the parent object that resource was added to or removed from. The parent will be `null` for other event types.',
        },
      ],
    },
    resource: {
      allOf: [
        {
          $ref: '#/components/schemas/AsanaNamedResource',
        },
        {
          description: 'The resource which has triggered the event by being modified in some way.',
        },
      ],
    },
    type: {
      description:
        '*Deprecated: Refer to the resource_type of the resource.* The type of the resource that generated the event.',
      example: 'task',
      readOnly: true,
      type: 'string',
    },
    user: {
      allOf: [
        {
          $ref: '#/components/schemas/UserCompact',
        },
        {
          description: 'The user who triggered the event.',
        },
      ],
    },
  },
  type: 'object',
} as const;

export const GoalAddSubgoalRequestSchema = {
  properties: {
    insert_after: {
      description:
        'An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    insert_before: {
      description:
        'An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    subgoal: {
      description: 'The goal gid to add as subgoal to a parent goal',
      example: '1331',
      type: 'string',
    },
  },
  required: ['subgoal'],
  type: 'object',
} as const;

export const GoalAddSupportingRelationshipRequestSchema = {
  properties: {
    contribution_weight: {
      description:
        "The weight that the supporting resource's progress will contribute to the supported goal's progress. This can only be 0 or 1.",
      example: 1,
      type: 'number',
    },
    insert_after: {
      description:
        'An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.',
      example: '1331',
      type: 'string',
    },
    insert_before: {
      description:
        'An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.',
      example: '1331',
      type: 'string',
    },
    supporting_resource: {
      description:
        'The gid of the supporting resource to add to the parent goal. Must be the gid of a goal, project, or portfolio.',
      example: '12345',
      type: 'string',
    },
  },
  required: ['supporting_resource'],
  type: 'object',
} as const;

export const GoalAddSupportingWorkRequestSchema = {
  properties: {
    supporting_work: {
      description: 'The project/portfolio gid to add as supporting work for a goal',
      example: '1331',
      type: 'string',
    },
  },
  required: ['supporting_work'],
  type: 'object',
} as const;

export const GoalBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        due_on: {
          description: 'The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.',
          example: '2019-09-15',
          nullable: true,
          type: 'string',
        },
        html_notes: {
          description: 'The notes of the goal with formatting as HTML.',
          example: '<body>Start building brand awareness.</body>',
          type: 'string',
        },
        is_workspace_level: {
          description:
            '*Conditional*. This property is only present when the `workspace` provided is an organization. Whether the goal belongs to the `workspace` (and is listed as part of the workspace’s goals) or not. If it isn’t a workspace-level goal, it is a team-level goal, and is associated with the goal’s team.',
          example: true,
          type: 'boolean',
        },
        liked: {
          description: 'True if the goal is liked by the authorized user, false if not.',
          example: false,
          type: 'boolean',
        },
        name: {
          description: 'The name of the goal.',
          example: 'Grow web traffic by 30%',
          type: 'string',
        },
        notes: {
          description: 'Free-form textual information associated with the goal (i.e. its description).',
          example: 'Start building brand awareness.',
          type: 'string',
        },
        start_on: {
          description:
            'The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.',
          example: '2019-09-14',
          nullable: true,
          type: 'string',
        },
        status: {
          description: `The current status of this goal. When the goal is open, its status can be \`green\`, \`yellow\`, and \`red\` to reflect "On Track", "At Risk", and "Off Track", respectively. When the goal is closed, the value can be \`missed\`, \`achieved\`, \`partial\`, or \`dropped\`.
*Note* you can only write to this property if \`metric\` is set.`,
          example: 'green',
          nullable: true,
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'goal',
      },
    },
  ],
} as const;

export const GoalCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        name: {
          description: 'The name of the goal.',
          example: 'Grow web traffic by 30%',
          type: 'string',
        },
        owner: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
            {
              nullable: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'goal',
      },
    },
  ],
} as const;

export const GoalMembershipBaseSchema = {
  $ref: '#/components/schemas/GoalMembershipCompact',
} as const;

export const GoalMembershipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: "This object represents a user's connection to a goal.",
      properties: {
        is_commenter: {
          description: 'Describes if the user is comment only in goal.',
          example: false,
          type: 'boolean',
        },
        is_editor: {
          description: 'Describes if the user is editor in goal.',
          example: false,
          type: 'boolean',
        },
        member: {
          $ref: '#/components/schemas/UserCompact',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'goal_membership',
      },
    },
  ],
} as const;

export const GoalMembershipResponseSchema = {
  $ref: '#/components/schemas/GoalMembershipCompact',
} as const;

export const GoalMetricBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        currency_code: {
          description:
            'ISO 4217 currency code to format this custom field. This will be null if the `unit` is not `currency`.',
          example: 'EUR',
          nullable: true,
          type: 'string',
        },
        current_display_value: {
          description: 'This string is the current value of a goal metric of type string.',
          example: '8.12',
          readOnly: true,
          type: 'string',
        },
        current_number_value: {
          description: 'This number is the current value of a goal metric of type number.',
          example: 8.12,
          type: 'number',
        },
        initial_number_value: {
          description: 'This number is the start value of a goal metric of type number.',
          example: 5.2,
          type: 'number',
        },
        precision: {
          description: `*Conditional*. Only relevant for goal metrics of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive.
For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.`,
          example: 2,
          type: 'integer',
        },
        progress_source: {
          description:
            "This field defines how the progress value of a goal metric is being calculated. A goal's progress can be provided manually by the user, calculated automatically from contributing subgoals or projects, or managed by an integration with an external data source, such as Salesforce.",
          enum: ['manual', 'subgoal_progress', 'project_task_completion', 'project_milestone_completion', 'external'],
          example: 'manual',
          type: 'string',
        },
        resource_subtype: {
          description:
            'The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.',
          enum: ['number'],
          example: 'number',
          readOnly: true,
          type: 'string',
        },
        target_number_value: {
          description:
            'This number is the end value of a goal metric of type number. This number cannot equal `initial_number_value`.',
          example: 10.2,
          type: 'number',
        },
        unit: {
          description: 'A supported unit of measure for the goal metric, or none.',
          enum: ['none', 'currency', 'percentage'],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const GoalMetricCurrentValueRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        current_number_value: {
          description: '*Conditional*. This number is the current value of a goal metric of type number.',
          example: 8.12,
          type: 'number',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const GoalMetricRequestSchema = {
  $ref: '#/components/schemas/GoalMetricBase',
} as const;

export const GoalRelationshipBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/GoalRelationshipCompact',
    },
    {
      properties: {
        supported_goal: {
          allOf: [
            {
              $ref: '#/components/schemas/GoalCompact',
            },
            {
              description: 'The goal that the supporting resource supports.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const GoalRelationshipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *goal relationship* is an object representing the relationship between a goal and another goal, a project, or a portfolio.',
      properties: {
        contribution_weight: {
          description:
            "The weight that the supporting resource's progress contributes to the supported goal's progress. This can only be 0 or 1.",
          example: 1,
          type: 'number',
        },
        resource_subtype: {
          description:
            'The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.',
          enum: ['subgoal', 'supporting_work'],
          example: 'subgoal',
          readOnly: true,
          type: 'string',
        },
        supporting_resource: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectCompact',
            },
            {
              description:
                'The supporting resource that supports the goal. This can be either a project, portfolio, or goal.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'goal_relationship',
      },
    },
  ],
} as const;

export const GoalRelationshipRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/GoalRelationshipBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const GoalRelationshipResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/GoalRelationshipBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const GoalRemoveSubgoalRequestSchema = {
  properties: {
    subgoal: {
      description: 'The goal gid to remove as subgoal from the parent goal',
      example: '1331',
      type: 'string',
    },
  },
  required: ['subgoal'],
  type: 'object',
} as const;

export const GoalRemoveSupportingRelationshipRequestSchema = {
  properties: {
    supporting_resource: {
      description:
        'The gid of the supporting resource to remove from the parent goal. Must be the gid of a goal, project, or portfolio.',
      example: '12345',
      type: 'string',
    },
  },
  required: ['supporting_resource'],
  type: 'object',
} as const;

export const GoalRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/GoalBase',
    },
    {
      properties: {
        followers: {
          example: ['12345'],
          items: {
            description: 'The `gid` of a user.',
            type: 'string',
          },
          type: 'array',
        },
        owner: {
          description: 'The `gid` of a user.',
          example: '12345',
          nullable: true,
          type: 'string',
        },
        team: {
          description: '*Conditional*. This property is only present when the `workspace` provided is an organization.',
          example: '12345',
          nullable: true,
          type: 'string',
        },
        time_period: {
          description: 'The `gid` of a time period.',
          example: '12345',
          nullable: true,
          type: 'string',
        },
        workspace: {
          description: 'The `gid` of a workspace.',
          example: '12345',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const GoalResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/GoalBase',
    },
    {
      properties: {
        current_status_update: {
          allOf: [
            {
              $ref: '#/components/schemas/StatusUpdateCompact',
            },
          ],
          description: 'The latest `status_update` posted to this goal.',
          nullable: true,
        },
        followers: {
          description: 'Array of users who are members of this goal.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          type: 'array',
        },
        likes: {
          description: 'Array of likes for users who have liked this goal.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        metric: {
          allOf: [
            {
              $ref: '#/components/schemas/GoalMetricBase',
            },
            {
              nullable: true,
              properties: {
                can_manage: {
                  description:
                    '*Conditional*. Only relevant for `progress_source` of type `external`. This boolean indicates whether the requester has the ability to update the current value of this metric. This returns `true` if the external metric was created by the requester, `false` otherwise.',
                  example: true,
                  readOnly: true,
                  type: 'boolean',
                },
              },
              type: 'object',
            },
          ],
        },
        num_likes: {
          description: 'The number of users who have liked this goal.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        owner: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
            {
              nullable: true,
              type: 'object',
            },
          ],
        },
        team: {
          allOf: [
            {
              $ref: '#/components/schemas/TeamCompact',
            },
            {
              nullable: true,
              type: 'object',
            },
          ],
          description: '*Conditional*. This property is only present when the `workspace` provided is an organization.',
        },
        time_period: {
          allOf: [
            {
              $ref: '#/components/schemas/TimePeriodCompact',
            },
            {
              nullable: true,
              type: 'object',
            },
          ],
        },
        workspace: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
            {
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const JobBaseSchema = {
  $ref: '#/components/schemas/JobCompact',
} as const;

export const JobCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'A *job* is an object representing a process that handles asynchronous work.',
      properties: {
        new_project: {
          $ref: '#/components/schemas/ProjectCompact',
        },
        new_project_template: {
          $ref: '#/components/schemas/ProjectTemplateCompact',
        },
        new_task: {
          $ref: '#/components/schemas/TaskCompact',
        },
        resource_subtype: {
          description:
            'The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.',
          example: 'duplicate_task',
          readOnly: true,
          type: 'string',
        },
        status: {
          description:
            'The current status of this job. The value is one of: `not_started`, `in_progress`, `succeeded`, or `failed`.',
          enum: ['not_started', 'in_progress', 'succeeded', 'failed'],
          example: 'in_progress',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'job',
      },
    },
  ],
} as const;

export const JobResponseSchema = {
  $ref: '#/components/schemas/JobCompact',
} as const;

export const LikeSchema = {
  description: "An object to represent a user's like.",
  properties: {
    gid: {
      description: 'Globally unique identifier of the object, as a string.',
      example: '12345',
      readOnly: true,
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/UserCompact',
    },
  },
  type: 'object',
} as const;

export const ModifyDependenciesRequestSchema = {
  example: {
    dependencies: ['133713', '184253'],
  },
  properties: {
    dependencies: {
      description: 'An array of task gids that a task depends on.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ModifyDependentsRequestSchema = {
  description: 'A set of dependent tasks.',
  example: {
    dependents: ['133713', '184253'],
  },
  properties: {
    dependents: {
      description: 'An array of task gids that are dependents of the given task.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const OrganizationExportBaseSchema = {
  $ref: '#/components/schemas/OrganizationExportCompact',
} as const;

export const OrganizationExportCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'An *organization_export* object represents a request to export the complete data of an Organization in JSON format.',
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        download_url: {
          description: `Download this URL to retreive the full export of the organization
in JSON format. It will be compressed in a gzip (.gz) container.

*Note: May be null if the export is still in progress or
failed.  If present, this URL may only be valid for 1 hour from
the time of retrieval. You should avoid persisting this URL
somewhere and rather refresh on demand to ensure you do not keep
stale URLs.*`,
          example:
            'https://asana-export.s3.amazonaws.com/export-4632784536274-20170127-43246.json.gz?AWSAccessKeyId=xxxxxxxx',
          format: 'uri',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        organization: {
          $ref: '#/components/schemas/WorkspaceCompact',
        },
        state: {
          description: 'The current state of the export.',
          enum: ['pending', 'started', 'finished', 'error'],
          example: 'started',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'organization_export',
      },
    },
  ],
} as const;

export const OrganizationExportRequestSchema = {
  description: 'An *organization_export* request starts a job to export the complete data of the given Organization.',
  properties: {
    organization: {
      description: 'Globally unique identifier for the workspace or organization.',
      example: '1331',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const OrganizationExportResponseSchema = {
  $ref: '#/components/schemas/OrganizationExportCompact',
} as const;

export const PortfolioAddItemRequestSchema = {
  properties: {
    insert_after: {
      description:
        'An id of an item in this portfolio. The new item will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    insert_before: {
      description:
        'An id of an item in this portfolio. The new item will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.',
      example: '1331',
      type: 'string',
    },
    item: {
      description: 'The item to add to the portfolio.',
      example: '1331',
      type: 'string',
    },
  },
  required: ['item'],
  type: 'object',
} as const;

export const PortfolioBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/PortfolioCompact',
    },
    {
      properties: {
        color: {
          description: 'Color of the portfolio.',
          enum: [
            'dark-pink',
            'dark-green',
            'dark-blue',
            'dark-red',
            'dark-teal',
            'dark-brown',
            'dark-orange',
            'dark-purple',
            'dark-warm-gray',
            'light-pink',
            'light-green',
            'light-blue',
            'light-red',
            'light-teal',
            'light-brown',
            'light-orange',
            'light-purple',
            'light-warm-gray',
          ],
          example: 'light-green',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const PortfolioCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: `A *portfolio* gives a high-level overview of the status of multiple initiatives in Asana. Portfolios provide a dashboard overview of the state of multiple projects, including a progress report and the most recent [project status](/docs/asana-project-statuses) update.
Portfolios have some restrictions on size. Each portfolio has a max of 500 items and, like projects, a max of 20 custom fields.`,
      properties: {
        name: {
          description: 'The name of the portfolio.',
          example: 'Bug Portfolio',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'portfolio',
      },
    },
  ],
} as const;

export const PortfolioMembershipBaseSchema = {
  $ref: '#/components/schemas/PortfolioMembershipCompact',
} as const;

export const PortfolioMembershipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'This object determines if a user is a member of a portfolio.',
      properties: {
        portfolio: {
          $ref: '#/components/schemas/PortfolioCompact',
          description: '[Opt In](/docs/input-output-options). The portfolio the user is a member of.',
        },
        user: {
          $ref: '#/components/schemas/UserCompact',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'portfolio_membership',
      },
    },
  ],
} as const;

export const PortfolioMembershipResponseSchema = {
  $ref: '#/components/schemas/PortfolioMembershipCompact',
} as const;

export const PortfolioRemoveItemRequestSchema = {
  properties: {
    item: {
      description: 'The item to remove from the portfolio.',
      example: '1331',
      type: 'string',
    },
  },
  required: ['item'],
  type: 'object',
} as const;

export const PortfolioRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/PortfolioBase',
    },
    {
      properties: {
        members: {
          description:
            'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
          example: ['52164', '15363'],
          items: {
            description: 'Gid of an object.',
            type: 'string',
          },
          readOnly: true,
          type: 'array',
        },
        public: {
          description: 'True if the portfolio is public to its workspace members.',
          example: false,
          type: 'boolean',
        },
        workspace: {
          description: 'Gid of an object.',
          example: '167589',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const PortfolioResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/PortfolioBase',
    },
    {
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        created_by: {
          $ref: '#/components/schemas/UserCompact',
        },
        current_status_update: {
          allOf: [
            {
              $ref: '#/components/schemas/StatusUpdateCompact',
            },
          ],
          description: 'The latest `status_update` posted to this portfolio.',
          nullable: true,
        },
        custom_field_settings: {
          description: 'Array of custom field settings applied to the portfolio.',
          items: {
            $ref: '#/components/schemas/CustomFieldSettingResponse',
          },
          type: 'array',
        },
        custom_fields: {
          description: 'Array of Custom Fields.',
          items: {
            $ref: '#/components/schemas/CustomFieldCompact',
          },
          type: 'array',
        },
        due_on: {
          description: 'The localized day on which this portfolio is due. This takes a date with format YYYY-MM-DD.',
          example: '2019-09-15',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        members: {
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        owner: {
          $ref: '#/components/schemas/UserCompact',
        },
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/resource/123456789/list',
          readOnly: true,
          type: 'string',
        },
        public: {
          description: 'True if the portfolio is public to its workspace members.',
          example: false,
          type: 'boolean',
        },
        start_on: {
          description:
            'The day on which work for this portfolio begins, or null if the portfolio has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*',
          example: '2019-09-14',
          format: 'date',
          nullable: true,
          type: 'string',
        },
        workspace: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
            {
              description: '*Create-only*. The workspace or organization that the portfolio belongs to.',
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const PreviewSchema = {
  description: `A collection of rich text that will be displayed as a preview to another app.

This is read-only except for a small group of whitelisted apps.`,
  properties: {
    fallback: {
      description: 'Some fallback text to display if unable to display the full preview.',
      example: 'Greg: Great! I like this idea.\\n\\nhttps//a_company.slack.com/archives/ABCDEFG/12345678',
      type: 'string',
    },
    footer: {
      description: 'Text to display in the footer.',
      example: 'Mar 17, 2019 1:25 PM',
      type: 'string',
    },
    header: {
      description: 'Text to display in the header.',
      example: 'Asana for Slack',
      type: 'string',
    },
    header_link: {
      description: 'Where the header will link to.',
      example: 'https://asana.comn/apps/slack',
      type: 'string',
    },
    html_text: {
      description: 'HTML formatted text for the body of the preview.',
      example: '<body>Great! I like this idea.</body>',
      type: 'string',
    },
    text: {
      description: 'Text for the body of the preview.',
      example: 'Great! I like this idea.',
      type: 'string',
    },
    title: {
      description: 'Text to display as the title.',
      example: 'Greg',
      type: 'string',
    },
    title_link: {
      description: 'Where to title will link to.',
      example: 'https://asana.slack.com/archives/ABCDEFG/12345678',
      type: 'string',
    },
  },
  readOnly: true,
  type: 'object',
} as const;

export const ProjectBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectCompact',
    },
    {
      properties: {
        archived: {
          description:
            'True if the project is archived, false if not. Archived projects do not show in the UI by default and may be treated differently for queries.',
          example: false,
          type: 'boolean',
        },
        color: {
          description: 'Color of the project.',
          enum: [
            'dark-pink',
            'dark-green',
            'dark-blue',
            'dark-red',
            'dark-teal',
            'dark-brown',
            'dark-orange',
            'dark-purple',
            'dark-warm-gray',
            'light-pink',
            'light-green',
            'light-blue',
            'light-red',
            'light-teal',
            'light-brown',
            'light-orange',
            'light-purple',
            'light-warm-gray',
          ],
          example: 'light-green',
          nullable: true,
          type: 'string',
        },
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        current_status: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectStatusResponse',
            },
          ],
          description: '*Deprecated: new integrations should prefer the `current_status_update` resource.*',
          nullable: true,
        },
        current_status_update: {
          allOf: [
            {
              $ref: '#/components/schemas/StatusUpdateCompact',
            },
          ],
          description: 'The latest `status_update` posted to this project.',
          nullable: true,
        },
        custom_field_settings: {
          description: 'Array of Custom Field Settings (in compact form).',
          items: {
            $ref: '#/components/schemas/CustomFieldSettingResponse',
          },
          readOnly: true,
          type: 'array',
        },
        default_view: {
          description: 'The default view (list, board, calendar, or timeline) of a project.',
          enum: ['list', 'board', 'calendar', 'timeline'],
          example: 'calendar',
          type: 'string',
        },
        due_date: {
          description: '*Deprecated: new integrations should prefer the `due_on` field.*',
          example: '2019-09-15',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        due_on: {
          description: 'The day on which this project is due. This takes a date with format YYYY-MM-DD.',
          example: '2019-09-15',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        html_notes: {
          description: '[Opt In](/docs/input-output-options). The notes of the project with formatting as HTML.',
          example: '<body>These are things we need to purchase.</body>',
          type: 'string',
        },
        is_template: {
          description:
            '[Opt In](/docs/input-output-options). *Deprecated - please use a project template endpoint instead (more in [this forum post](https://forum.asana.com/t/a-new-api-for-project-templates/156432)).* Determines if the project is a template.',
          example: false,
          type: 'boolean',
        },
        members: {
          description: 'Array of users who are members of this project.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        modified_at: {
          description: `The time at which this project was last modified.
*Note: This does not currently reflect any changes in associations such as tasks or comments that may have been added or removed from the project.*`,
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        notes: {
          description: 'Free-form textual information associated with the project (ie., its description).',
          example: 'These are things we need to purchase.',
          type: 'string',
        },
        public: {
          description: 'True if the project is public to its team.',
          example: false,
          type: 'boolean',
        },
        start_on: {
          description:
            'The day on which work for this project begins, or null if the project has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` or `due_at` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*',
          example: '2019-09-14',
          format: 'date',
          nullable: true,
          type: 'string',
        },
        workspace: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
            {
              description:
                '*Create-only*. The workspace or organization this project is associated with. Once created, projects cannot be moved to a different workspace. This attribute can only be specified at creation time.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectBriefBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectBriefCompact',
    },
    {
      properties: {
        html_text: {
          description: 'HTML formatted text for the project brief.',
          example: '<body>This is a <strong>project brief</strong>.</body>',
          type: 'string',
        },
        title: {
          description: 'The title of the project brief.',
          example: 'Stuff to buy — Project Brief',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectBriefCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'A *Project Brief* allows you to explain the what and why of the project to your team.',
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'project_brief',
      },
    },
  ],
} as const;

export const ProjectBriefRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectBriefBase',
    },
    {
      properties: {
        text: {
          description:
            'The plain text of the project brief. When writing to a project brief, you can specify either `html_text` (preferred) or `text`, but not both.',
          example: 'This is a project brief.',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectBriefResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectBriefBase',
    },
    {
      properties: {
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/11111111/22222222',
          readOnly: true,
          type: 'string',
        },
        project: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectCompact',
            },
            {
              description: 'The project with which this project brief is associated.',
              type: 'object',
            },
          ],
        },
        text: {
          description: '[Opt In](/docs/input-output-options). The plain text of the project brief.',
          example: 'This is a project brief.',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *project* represents a prioritized list of tasks in Asana or a board with columns of tasks represented as cards. It exists in a single workspace or organization and is accessible to a subset of users in that workspace or organization, depending on its permissions.',
      properties: {
        name: {
          description:
            'Name of the project. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.',
          example: 'Stuff to buy',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'project',
      },
    },
  ],
} as const;

export const ProjectDuplicateRequestSchema = {
  properties: {
    include: {
      description: 'The elements that will be duplicated to the new project. Tasks are always included.',
      enum: [
        'members',
        'notes',
        'forms',
        'task_notes',
        'task_assignee',
        'task_subtasks',
        'task_attachments',
        'task_dates',
        'task_dependencies',
        'task_followers',
        'task_tags',
        'task_projects',
      ],
      example: ['members', 'task_notes'],
      type: 'string',
    },
    name: {
      description: 'The name of the new project.',
      example: 'New Project Name',
      type: 'string',
    },
    schedule_dates: {
      description:
        'A dictionary of options to auto-shift dates. `task_dates` must be included to use this option. Requires either `start_on` or `due_on`, but not both.',
      properties: {
        due_on: {
          description:
            'Sets the last due date in the duplicated project to the given date. The rest of the due dates will be offset by the same amount as the due dates in the original project.',
          example: '2019-05-21',
          type: 'string',
        },
        should_skip_weekends: {
          description: 'Determines if the auto-shifted dates should skip weekends.',
          example: true,
          type: 'boolean',
        },
        start_on: {
          description:
            'Sets the first start date in the duplicated project to the given date. The rest of the start dates will be offset by the same amount as the start dates in the original project.',
          example: '2019-05-21',
          type: 'string',
        },
      },
      required: ['should_skip_weekends'],
      type: 'object',
    },
    team: {
      description:
        'Sets the team of the new project. If team is not defined, the new project will be in the same team as the the original project.',
      example: '12345',
      type: 'string',
    },
  },
  required: ['name'],
  type: 'object',
} as const;

export const ProjectMembershipBaseSchema = {
  $ref: '#/components/schemas/ProjectMembershipCompact',
} as const;

export const ProjectMembershipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'With the introduction of “comment-only” projects in Asana, a user’s membership in a project comes with associated permissions. These permissions (whether a user has full access to the project or comment-only access) are accessible through the project memberships endpoints described here.',
      properties: {
        user: {
          $ref: '#/components/schemas/UserCompact',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'project_membership',
      },
    },
  ],
} as const;

export const ProjectMembershipResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectMembershipCompact',
    },
    {
      properties: {
        project: {
          $ref: '#/components/schemas/ProjectCompact',
          description: '[Opt In](/docs/input-output-options). The project the user is a member of.',
        },
        write_access: {
          description: 'Whether the user has full access to the project or has comment-only access.',
          enum: ['full_write', 'comment_only'],
          example: 'full_write',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectBase',
    },
    {
      properties: {
        custom_fields: {
          additionalProperties: {
            description: '"{custom_field_gid}" => Value (Can be text, number, etc.)',
            type: 'string',
          },
          description:
            'An object where each key is a Custom Field GID and each value is an enum GID, string, number, or object.',
          example: {
            4578152156: 'Not Started',
            5678904321: 'On Hold',
          },
          type: 'object',
        },
        followers: {
          description:
            '*Create-only*. Comma separated string of users. Followers are a subset of members who have opted in to receive "tasks added" notifications for a project.',
          example: '12345,23456',
          type: 'string',
        },
        owner: {
          description: 'The current owner of the project, may be null.',
          example: '12345',
          nullable: true,
          type: 'string',
        },
        team: {
          description: 'The team that this project is shared with.',
          example: '12345',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectBase',
    },
    {
      properties: {
        completed: {
          description: 'True if the project is currently marked complete, false if not.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        completed_at: {
          description: 'The time at which this project was completed, or null if the project is not completed.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        completed_by: {
          $ref: '#/components/schemas/UserCompact',
          description: 'The user that marked this project complete, or null if the project is not completed.',
          nullable: true,
          readOnly: true,
        },
        created_from_template: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectTemplateCompact',
            },
            {
              description:
                '[Opt In](/docs/input-output-options). The project template from which this project was created. If the project was not created from a template, this field will be null.',
              nullable: true,
              type: 'object',
            },
          ],
        },
        custom_fields: {
          description: 'Array of Custom Fields.',
          items: {
            $ref: '#/components/schemas/CustomFieldCompact',
          },
          readOnly: true,
          type: 'array',
        },
        followers: {
          description:
            'Array of users following this project. Followers are a subset of members who have opted in to receive "tasks added" notifications for a project.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        icon: {
          description: 'The icon for a project.',
          enum: [
            'list',
            'board',
            'timeline',
            'calendar',
            'rocket',
            'people',
            'graph',
            'star',
            'bug',
            'light_bulb',
            'globe',
            'gear',
            'notebook',
            'computer',
            'check',
            'target',
            'html',
            'megaphone',
            'chat_bubbles',
            'briefcase',
            'page_layout',
            'mountain_flag',
            'puzzle',
            'presentation',
            'line_and_symbols',
            'speed_dial',
            'ribbon',
            'shoe',
            'shopping_basket',
            'map',
            'ticket',
            'coins',
          ],
          example: 'chat_bubbles',
          nullable: true,
          type: 'string',
        },
        owner: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
          ],
          description: 'The current owner of the project, may be null.',
          nullable: true,
        },
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/resource/123456789/list',
          readOnly: true,
          type: 'string',
        },
        project_brief: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectBriefCompact',
            },
            {
              description: '[Opt In](/docs/input-output-options). The project brief associated with this project.',
              nullable: true,
              type: 'object',
            },
          ],
        },
        team: {
          allOf: [
            {
              $ref: '#/components/schemas/TeamCompact',
            },
            {
              description: 'The team that this project is shared with.',
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectSaveAsTemplateRequestSchema = {
  properties: {
    name: {
      description: 'The name of the new project template.',
      example: 'New Project Template',
      type: 'string',
    },
    public: {
      description: 'Sets the project template to public to its team.',
      example: true,
      type: 'boolean',
    },
    team: {
      description:
        'Sets the team of the new project template. If the project exists in an organization, specify team and not workspace.',
      example: '12345',
      type: 'string',
    },
    workspace: {
      description:
        'Sets the workspace of the new project template. Only specify workspace if the project exists in a workspace.',
      example: '12345',
      type: 'string',
    },
  },
  required: ['name', 'public'],
  type: 'object',
} as const;

export const ProjectSectionInsertRequestSchema = {
  properties: {
    after_section: {
      description: 'Insert the given section immediately after the section specified by this parameter.',
      example: '987654',
      type: 'string',
    },
    before_section: {
      description: 'Insert the given section immediately before the section specified by this parameter.',
      example: '86420',
      type: 'string',
    },
    project: {
      description: 'The project in which to reorder the given section.',
      example: '123456',
      type: 'string',
    },
    section: {
      description: 'The section to reorder.',
      example: '321654',
      type: 'string',
    },
  },
  required: ['project', 'section'],
  type: 'object',
} as const;

export const ProjectStatusBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectStatusCompact',
    },
    {
      properties: {
        color: {
          description: 'The color associated with the status update.',
          enum: ['green', 'yellow', 'red', 'blue'],
          type: 'string',
        },
        html_text: {
          description:
            '[Opt In](/docs/input-output-options). The text content of the status update with formatting as HTML.',
          example: '<body>The project <strong>is</strong> moving forward according to plan...</body>',
          type: 'string',
        },
        text: {
          description: 'The text content of the status update.',
          example: 'The project is moving forward according to plan...',
          type: 'string',
        },
      },
      required: ['text', 'color'],
      type: 'object',
    },
  ],
} as const;

export const ProjectStatusCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: `*Deprecated: new integrations should prefer the \`status_update\` resource.*
A *project status* is an update on the progress of a particular project, and is sent out to all project followers when created. These updates include both text describing the update and a color code intended to represent the overall state of the project: "green" for projects that are on track, "yellow" for projects at risk, and "red" for projects that are behind.`,
      properties: {
        title: {
          description: 'The title of the project status update.',
          example: 'Status Update - Jun 15',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'project_status',
      },
    },
  ],
} as const;

export const ProjectStatusRequestSchema = {
  $ref: '#/components/schemas/ProjectStatusBase',
} as const;

export const ProjectStatusResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectStatusBase',
    },
    {
      properties: {
        author: {
          $ref: '#/components/schemas/UserCompact',
        },
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        created_by: {
          $ref: '#/components/schemas/UserCompact',
        },
        modified_at: {
          description: `The time at which this project status was last modified.
*Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the project status.*`,
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectTemplateBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectTemplateCompact',
    },
    {
      properties: {
        color: {
          description: 'Color of the project template.',
          enum: [
            'dark-pink',
            'dark-green',
            'dark-blue',
            'dark-red',
            'dark-teal',
            'dark-brown',
            'dark-orange',
            'dark-purple',
            'dark-warm-gray',
            'light-pink',
            'light-green',
            'light-blue',
            'light-red',
            'light-teal',
            'light-brown',
            'light-orange',
            'light-purple',
            'light-warm-gray',
          ],
          example: 'light-green',
          nullable: true,
          type: 'string',
        },
        description: {
          description: 'Free-form textual information associated with the project template',
          example: 'These are things we need to pack for a trip.',
          type: 'string',
        },
        html_description: {
          description: 'The description of the project template with formatting as HTML.',
          example: '<body>These are things we need to pack for a trip.</body>',
          type: 'string',
        },
        owner: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
          ],
          description: 'The current owner of the project template, may be null.',
          nullable: true,
        },
        public: {
          description: 'True if the project template is public to its team.',
          example: false,
          type: 'boolean',
        },
        requested_dates: {
          description:
            'Array of date variables in this project template. Calendar dates must be provided for these variables when instantiating a project.',
          items: {
            $ref: '#/components/schemas/DateVariableCompact',
          },
          readOnly: true,
          type: 'array',
        },
        team: {
          allOf: [
            {
              $ref: '#/components/schemas/TeamCompact',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const ProjectTemplateCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *project template* is an object that allows new projects to be created with a predefined setup, which may include tasks, sections, Rules, etc. It simplifies the process of running a workflow that involves a similar set of work every time.',
      properties: {
        name: {
          description: 'Name of the project template.',
          example: 'Packing list',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'project_template',
      },
    },
  ],
} as const;

export const ProjectTemplateInstantiateProjectRequestSchema = {
  properties: {
    is_strict: {
      description:
        '*Optional*. If set to `true`, the endpoint returns an "Unprocessable Entity" error if you fail to provide a calendar date value for any date variable. If set to `false`, a default date is used for each unfulfilled date variable (e.g., the current date is used as the Start Date of a project).',
      example: true,
      type: 'boolean',
    },
    name: {
      description: 'The name of the new project.',
      example: 'New Project Name',
      type: 'string',
    },
    public: {
      description: 'Sets the project to public to its team.',
      example: true,
      type: 'boolean',
    },
    requested_dates: {
      description: 'Array of mappings of date variables to calendar dates.',
      items: {
        $ref: '#/components/schemas/DateVariableRequest',
      },
      type: 'array',
    },
    team: {
      description:
        '*Conditional*. Sets the team of the new project. If the project template exists in an _organization_, you must specify a value for `team` and not `workspace`.',
      example: '12345',
      type: 'string',
    },
    workspace: {
      description:
        '*Conditional*. Sets the workspace of the new project. If the project template exists in a _workspace_, you must specify a value for `workspace` and not `team`.',
      example: '12345',
      type: 'string',
    },
  },
  required: ['name', 'public'],
  type: 'object',
} as const;

export const ProjectTemplateResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ProjectTemplateBase',
    },
  ],
} as const;

export const RemoveCustomFieldSettingRequestSchema = {
  properties: {
    custom_field: {
      description: 'The custom field to remove from this portfolio.',
      example: '14916',
      type: 'string',
    },
  },
  required: ['custom_field'],
  type: 'object',
} as const;

export const RemoveFollowersRequestSchema = {
  properties: {
    followers: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: '521621,621373',
      type: 'string',
    },
  },
  required: ['followers'],
  type: 'object',
} as const;

export const RemoveMembersRequestSchema = {
  properties: {
    members: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: '521621,621373',
      type: 'string',
    },
  },
  required: ['members'],
  type: 'object',
} as const;

export const SectionBaseSchema = {
  $ref: '#/components/schemas/SectionCompact',
} as const;

export const SectionCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *section* is a subdivision of a project that groups tasks together. It can either be a header above a list of tasks in a list view or a column in a board view of a project.',
      properties: {
        name: {
          description: 'The name of the section (i.e. the text displayed as the section header).',
          example: 'Next Actions',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'section',
      },
    },
  ],
} as const;

export const SectionRequestSchema = {
  properties: {
    insert_after: {
      description:
        'An existing section within this project after which the added section should be inserted. Cannot be provided together with insert_before.',
      example: '987654',
      type: 'string',
    },
    insert_before: {
      description:
        'An existing section within this project before which the added section should be inserted. Cannot be provided together with insert_after.',
      example: '86420',
      type: 'string',
    },
    name: {
      description: 'The text to be displayed as the section name. This cannot be an empty string.',
      example: 'Next Actions',
      type: 'string',
    },
  },
  required: ['project', 'name'],
  type: 'object',
} as const;

export const SectionResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/SectionCompact',
    },
    {
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        project: {
          $ref: '#/components/schemas/ProjectCompact',
        },
        projects: {
          description: '*Deprecated - please use project instead*',
          items: {
            $ref: '#/components/schemas/ProjectCompact',
          },
          readOnly: true,
          type: 'array',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const SectionTaskInsertRequestSchema = {
  properties: {
    insert_after: {
      description:
        'An existing task within this section after which the added task should be inserted. Cannot be provided together with insert_before.',
      example: '987654',
      type: 'string',
    },
    insert_before: {
      description:
        'An existing task within this section before which the added task should be inserted. Cannot be provided together with insert_after.',
      example: '86420',
      type: 'string',
    },
    task: {
      description: 'The task to add to this section.',
      example: '123456',
      type: 'string',
    },
  },
  required: ['task'],
  type: 'object',
} as const;

export const StatusUpdateBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/StatusUpdateCompact',
    },
    {
      properties: {
        html_text: {
          description:
            '[Opt In](/docs/input-output-options). The text content of the status update with formatting as HTML.',
          example: '<body>The project <strong>is</strong> moving forward according to plan...</body>',
          type: 'string',
        },
        status_type: {
          description:
            'The type associated with the status update. This represents the current state of the object this object is on.',
          enum: ['on_track', 'at_risk', 'off_track', 'on_hold', 'complete', 'achieved', 'partial', 'missed', 'dropped'],
          type: 'string',
        },
        text: {
          description: 'The text content of the status update.',
          example: 'The project is moving forward according to plan...',
          type: 'string',
        },
      },
      required: ['text', 'status_type'],
      type: 'object',
    },
  ],
} as const;

export const StatusUpdateCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        "A *status update* is an update on the progress of a particular project, portfolio, or goal, and is sent out to all of its parent's followers when created. These updates include both text describing the update and a `status_type` intended to represent the overall state of the project.",
      properties: {
        resource_subtype: {
          description: `The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
The \`resource_subtype\`s for \`status\` objects represent the type of their parent.`,
          enum: ['project_status_update', 'portfolio_status_update', 'goal_status_update'],
          example: 'project_status_update',
          readOnly: true,
          type: 'string',
        },
        title: {
          description: 'The title of the status update.',
          example: 'Status Update - Jun 15',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'status_update',
      },
    },
  ],
} as const;

export const StatusUpdateRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/StatusUpdateBase',
    },
    {
      properties: {
        parent: {
          allOf: [
            {
              description: 'The id of parent to send this status update to. This can be a project, goal or portfolio.',
              type: 'string',
            },
          ],
        },
      },
      required: ['parent'],
      type: 'object',
    },
  ],
} as const;

export const StatusUpdateResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/StatusUpdateBase',
    },
    {
      properties: {
        author: {
          $ref: '#/components/schemas/UserCompact',
        },
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        created_by: {
          $ref: '#/components/schemas/UserCompact',
        },
        hearted: {
          description:
            '*Deprecated - please use liked instead* True if the status is hearted by the authorized user, false if not.',
          example: true,
          readOnly: true,
          type: 'boolean',
        },
        hearts: {
          description: '*Deprecated - please use likes instead* Array of likes for users who have hearted this status.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        liked: {
          description: 'True if the status is liked by the authorized user, false if not.',
          example: true,
          type: 'boolean',
        },
        likes: {
          description: 'Array of likes for users who have liked this status.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        modified_at: {
          description: `The time at which this project status was last modified.
*Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the status.*`,
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        num_hearts: {
          description: '*Deprecated - please use likes instead* The number of users who have hearted this status.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        num_likes: {
          description: 'The number of users who have liked this status.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        parent: {
          allOf: [
            {
              $ref: '#/components/schemas/ProjectCompact',
            },
            {
              description:
                'The parent of the status update. This can be a project, goal or portfolio, and indicates that this status was sent on that object.',
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const StoryBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'A story represents an activity associated with an object in the Asana system.',
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        html_text: {
          description:
            '[Opt In](/docs/input-output-options). HTML formatted text for a comment. This will not include the name of the creator.',
          example: '<body>This is a comment.</body>',
          type: 'string',
        },
        is_pinned: {
          description: '*Conditional*. Whether the story should be pinned on the resource.',
          example: false,
          type: 'boolean',
        },
        resource_subtype: {
          description:
            'The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.',
          example: 'comment_added',
          readOnly: true,
          type: 'string',
        },
        sticker_name: {
          description: 'The name of the sticker in this story. `null` if there is no sticker.',
          enum: [
            'green_checkmark',
            'people_dancing',
            'dancing_unicorn',
            'heart',
            'party_popper',
            'people_waving_flags',
            'splashing_narwhal',
            'trophy',
            'yeti_riding_unicorn',
            'celebrating_people',
            'determined_climbers',
            'phoenix_spreading_love',
          ],
          example: 'dancing_unicorn',
          type: 'string',
        },
        text: {
          description: 'The plain text of the comment to add. Cannot be used with html_text.',
          example: 'This is a comment.',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'story',
      },
    },
  ],
} as const;

export const StoryCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'A story represents an activity associated with an object in the Asana system.',
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        created_by: {
          $ref: '#/components/schemas/UserCompact',
        },
        resource_subtype: {
          description:
            'The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.',
          example: 'comment_added',
          readOnly: true,
          type: 'string',
        },
        text: {
          description: `*Create-only*. Human-readable text for the story or comment.
This will not include the name of the creator.
*Note: This is not guaranteed to be stable for a given type of story. For example, text for a reassignment may not always say “assigned to …” as the text for a story can both be edited and change based on the language settings of the user making the request.*
Use the \`resource_subtype\` property to discover the action that created the story.`,
          example: 'marked today',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'story',
      },
    },
  ],
} as const;

export const StoryRequestSchema = {
  $ref: '#/components/schemas/StoryBase',
} as const;

export const StoryResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/StoryBase',
    },
    {
      properties: {
        assignee: {
          $ref: '#/components/schemas/UserCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        created_by: {
          $ref: '#/components/schemas/UserCompact',
        },
        custom_field: {
          $ref: '#/components/schemas/CustomFieldCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        dependency: {
          $ref: '#/components/schemas/TaskCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        duplicate_of: {
          $ref: '#/components/schemas/TaskCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        duplicated_from: {
          $ref: '#/components/schemas/TaskCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        follower: {
          $ref: '#/components/schemas/UserCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        hearted: {
          description: `*Deprecated - please use likes instead*
*Conditional*. True if the story is hearted by the authorized user, false if not.`,
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        hearts: {
          description: `*Deprecated - please use likes instead*

*Conditional*. Array of likes for users who have hearted this story.`,
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        is_editable: {
          description: '*Conditional*. Whether the text of the story can be edited after creation.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        is_edited: {
          description: '*Conditional*. Whether the text of the story has been edited after creation.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        liked: {
          description: '*Conditional*. True if the story is liked by the authorized user, false if not.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        likes: {
          description: '*Conditional*. Array of likes for users who have liked this story.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        new_approval_status: {
          description: '*Conditional*. The new value of approval status.',
          example: 'approved',
          readOnly: true,
          type: 'string',
        },
        new_date_value: {
          allOf: [
            {
              $ref: '#/components/schemas/StoryResponseDates',
            },
            {
              description: '*Conditional* The new value of a date custom field story.',
            },
          ],
          readOnly: true,
        },
        new_dates: {
          $ref: '#/components/schemas/StoryResponseDates',
        },
        new_enum_value: {
          $ref: '#/components/schemas/EnumOption',
          description: '*Conditional*',
          readOnly: true,
        },
        new_multi_enum_values: {
          description: '*Conditional*. The new value of a multi-enum custom field story.',
          items: {
            $ref: '#/components/schemas/EnumOption',
          },
          readOnly: true,
          type: 'array',
        },
        new_name: {
          description: '*Conditional*',
          example: 'This is the New Name',
          readOnly: true,
          type: 'string',
        },
        new_number_value: {
          description: '*Conditional*',
          example: 2,
          readOnly: true,
          type: 'integer',
        },
        new_people_value: {
          description: '*Conditional*. The new value of a people custom field story.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        new_resource_subtype: {
          description: '*Conditional*',
          example: 'milestone',
          readOnly: true,
          type: 'string',
        },
        new_section: {
          $ref: '#/components/schemas/SectionCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        new_text_value: {
          description: '*Conditional*',
          example: 'This is the New Text',
          readOnly: true,
          type: 'string',
        },
        num_hearts: {
          description: `*Deprecated - please use likes instead*

*Conditional*. The number of users who have hearted this story.`,
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        num_likes: {
          description: '*Conditional*. The number of users who have liked this story.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        old_approval_status: {
          description: '*Conditional*. The old value of approval status.',
          example: 'pending',
          readOnly: true,
          type: 'string',
        },
        old_date_value: {
          allOf: [
            {
              $ref: '#/components/schemas/StoryResponseDates',
            },
            {
              description: '*Conditional*. The old value of a date custom field story.',
            },
          ],
          readOnly: true,
        },
        old_dates: {
          $ref: '#/components/schemas/StoryResponseDates',
        },
        old_enum_value: {
          $ref: '#/components/schemas/EnumOption',
          description: '*Conditional*',
          readOnly: true,
        },
        old_multi_enum_values: {
          description: '*Conditional*. The old value of a multi-enum custom field story.',
          items: {
            $ref: '#/components/schemas/EnumOption',
          },
          readOnly: true,
          type: 'array',
        },
        old_name: {
          description: "*Conditional*'",
          example: 'This was the Old Name',
          type: 'string',
        },
        old_number_value: {
          description: '*Conditional*',
          example: 1,
          readOnly: true,
          type: 'integer',
        },
        old_people_value: {
          description: '*Conditional*. The old value of a people custom field story.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        old_resource_subtype: {
          description: '*Conditional*',
          example: 'default_task',
          readOnly: true,
          type: 'string',
        },
        old_section: {
          $ref: '#/components/schemas/SectionCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        old_text_value: {
          description: '*Conditional*',
          example: 'This was the Old Text',
          readOnly: true,
          type: 'string',
        },
        previews: {
          description: `*Conditional*. A collection of previews to be displayed in the story.

*Note: This property only exists for comment stories.*`,
          items: {
            $ref: '#/components/schemas/Preview',
          },
          readOnly: true,
          type: 'array',
        },
        project: {
          $ref: '#/components/schemas/ProjectCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        source: {
          description: 'The component of the Asana product the user used to trigger the story.',
          enum: ['web', 'email', 'mobile', 'api', 'unknown'],
          example: 'web',
          readOnly: true,
          type: 'string',
        },
        story: {
          $ref: '#/components/schemas/StoryCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        tag: {
          $ref: '#/components/schemas/TagCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        target: {
          allOf: [
            {
              $ref: '#/components/schemas/TaskCompact',
            },
            {
              description: 'The object this story is associated with. Currently may only be a task.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
        task: {
          $ref: '#/components/schemas/TaskCompact',
          description: '*Conditional*',
          readOnly: true,
        },
        type: {
          enum: ['comment', 'system'],
          example: 'comment',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const StoryResponseDatesSchema = {
  description: '*Conditional*',
  properties: {
    due_at: {
      description:
        'The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.',
      example: '2019-09-15T02:06:58.158Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    due_on: {
      description: 'The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.',
      example: '2019-09-15',
      format: 'date',
      type: 'string',
    },
    start_on: {
      description:
        'The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.',
      example: '2019-09-14',
      format: 'date',
      nullable: true,
      type: 'string',
    },
  },
  readOnly: true,
  type: 'object',
} as const;

export const TagBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TagCompact',
    },
    {
      properties: {
        color: {
          description: 'Color of the tag.',
          enum: [
            'dark-pink',
            'dark-green',
            'dark-blue',
            'dark-red',
            'dark-teal',
            'dark-brown',
            'dark-orange',
            'dark-purple',
            'dark-warm-gray',
            'light-pink',
            'light-green',
            'light-blue',
            'light-red',
            'light-teal',
            'light-brown',
            'light-orange',
            'light-purple',
            'light-warm-gray',
          ],
          example: 'light-green',
          nullable: true,
          type: 'string',
        },
        notes: {
          description: 'Free-form textual information associated with the tag (i.e. its description).',
          example: 'Mittens really likes the stuff from Humboldt.',
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TagCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *tag* is a label that can be attached to any task in Asana. It exists in a single workspace or organization.',
      properties: {
        name: {
          description:
            'Name of the tag. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.',
          example: 'Stuff to buy',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'tag',
      },
    },
  ],
} as const;

export const TagRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TagBase',
    },
    {
      properties: {
        followers: {
          description:
            'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
          example: ['12345', '42563'],
          items: {
            type: 'string',
          },
          type: 'array',
        },
        workspace: {
          description: 'Gid of an object.',
          example: '12345',
          type: 'string',
          'x-env-variable': true,
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TagResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TagBase',
    },
    {
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        followers: {
          description: 'Array of users following this tag.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/resource/123456789/list',
          readOnly: true,
          type: 'string',
        },
        workspace: {
          $ref: '#/components/schemas/WorkspaceCompact',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TaskAddFollowersRequestSchema = {
  properties: {
    followers: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: ['13579', '321654'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['followers'],
  type: 'object',
} as const;

export const TaskAddProjectRequestSchema = {
  properties: {
    insert_after: {
      description: 'A task in the project to insert the task after, or `null` to insert at the beginning of the list.',
      example: '124816',
      nullable: true,
      type: 'string',
    },
    insert_before: {
      description: 'A task in the project to insert the task before, or `null` to insert at the end of the list.',
      example: '432134',
      nullable: true,
      type: 'string',
    },
    project: {
      description: 'The project to add the task to.',
      example: '13579',
      type: 'string',
    },
    section: {
      description:
        'A section in the project to insert the task into. The task will be inserted at the bottom of the section.',
      example: '987654',
      nullable: true,
      type: 'string',
    },
  },
  required: ['project'],
  type: 'object',
} as const;

export const TaskAddTagRequestSchema = {
  properties: {
    tag: {
      description: 'The tag to add to the task.',
      example: '13579',
      type: 'string',
    },
  },
  required: ['tag'],
  type: 'object',
} as const;

export const TaskBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TaskCompact',
    },
    {
      properties: {
        actual_time_minutes: {
          description:
            'This value represents the sum of all the Time Tracking entries in the Actual Time field on a given Task. It is represented as a nullable long value.',
          example: 200,
          nullable: true,
          readOnly: true,
          type: 'number',
        },
        approval_status: {
          description:
            '*Conditional* Reflects the approval status of this task. This field is kept in sync with `completed`, meaning `pending` translates to false while `approved`, `rejected`, and `changes_requested` translate to true. If you set completed to true, this field will be set to `approved`.',
          enum: ['pending', 'approved', 'rejected', 'changes_requested'],
          example: 'pending',
          type: 'string',
        },
        assignee_status: {
          description:
            '*Deprecated* Scheduling status of this task for the user it is assigned to. This field can only be set if the assignee is non-null. Setting this field to "inbox" or "upcoming" inserts it at the top of the section, while the other options will insert at the bottom.',
          enum: ['today', 'upcoming', 'later', 'new', 'inbox'],
          example: 'upcoming',
          type: 'string',
        },
        completed: {
          description: 'True if the task is currently marked complete, false if not.',
          example: false,
          type: 'boolean',
        },
        completed_at: {
          description: 'The time at which this task was completed, or null if the task is incomplete.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
        completed_by: {
          $ref: '#/components/schemas/UserCompact',
          readOnly: true,
        },
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        dependencies: {
          description:
            '[Opt In](/docs/input-output-options). Array of resources referencing tasks that this task depends on. The objects contain only the gid of the dependency.',
          items: {
            $ref: '#/components/schemas/AsanaResource',
          },
          readOnly: true,
          type: 'array',
        },
        dependents: {
          description:
            '[Opt In](/docs/input-output-options). Array of resources referencing tasks that depend on this task. The objects contain only the ID of the dependent.',
          items: {
            $ref: '#/components/schemas/AsanaResource',
          },
          readOnly: true,
          type: 'array',
        },
        due_at: {
          description:
            'The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.',
          example: '2019-09-15T02:06:58.147Z',
          format: 'date',
          nullable: true,
          type: 'string',
        },
        due_on: {
          description:
            'The localized date on which this task is due, or null if the task has no due date. This takes a date with `YYYY-MM-DD` format and should not be used together with `due_at`.',
          example: '2019-09-15',
          format: 'date',
          nullable: true,
          type: 'string',
        },
        external: {
          description: `*OAuth Required*. *Conditional*. This field is returned only if external values are set or included by using [Opt In] (/docs/input-output-options).
The external field allows you to store app-specific metadata on tasks, including a gid that can be used to retrieve tasks and a data blob that can store app-specific character strings. Note that you will need to authenticate with Oauth to access or modify this data. Once an external gid is set, you can use the notation \`external:custom_gid\` to reference your object anywhere in the API where you may use the original object gid. See the page on Custom External Data for more details.`,
          example: {
            data: 'A blob of information',
            gid: 'my_gid',
          },
          properties: {
            data: {
              example: 'A blob of information.',
              type: 'string',
            },
            gid: {
              example: '1234',
              type: 'string',
            },
          },
          type: 'object',
        },
        hearted: {
          description:
            '*Deprecated - please use liked instead* True if the task is hearted by the authorized user, false if not.',
          example: true,
          readOnly: true,
          type: 'boolean',
        },
        hearts: {
          description: '*Deprecated - please use likes instead* Array of likes for users who have hearted this task.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        html_notes: {
          description: '[Opt In](/docs/input-output-options). The notes of the text with formatting as HTML.',
          example: '<body>Mittens <em>really</em> likes the stuff from Humboldt.</body>',
          type: 'string',
        },
        is_rendered_as_separator: {
          description:
            '[Opt In](/docs/input-output-options). In some contexts tasks can be rendered as a visual separator; for instance, subtasks can appear similar to [sections](/docs/asana-sections) without being true `section` objects. If a `task` object is rendered this way in any context it will have the property `is_rendered_as_separator` set to `true`.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        liked: {
          description: 'True if the task is liked by the authorized user, false if not.',
          example: true,
          type: 'boolean',
        },
        likes: {
          description: 'Array of likes for users who have liked this task.',
          items: {
            $ref: '#/components/schemas/Like',
          },
          readOnly: true,
          type: 'array',
        },
        memberships: {
          description:
            '*Create-only*. Array of projects this task is associated with and the section it is in. At task creation time, this array can be used to add the task to specific sections. After task creation, these associations can be modified using the `addProject` and `removeProject` endpoints. Note that over time, more types of memberships may be added to this property.',
          items: {
            properties: {
              project: {
                $ref: '#/components/schemas/ProjectCompact',
              },
              section: {
                $ref: '#/components/schemas/SectionCompact',
              },
            },
            type: 'object',
          },
          readOnly: true,
          type: 'array',
        },
        modified_at: {
          description: `The time at which this task was last modified.

*Note: This does not currently reflect any changes in
associations such as projects or comments that may have been
added or removed from the task.*`,
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        name: {
          description:
            'Name of the task. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.',
          example: 'Buy catnip',
          type: 'string',
        },
        notes: {
          description: 'Free-form textual information associated with the task (i.e. its description).',
          example: 'Mittens really likes the stuff from Humboldt.',
          type: 'string',
        },
        num_hearts: {
          description: '*Deprecated - please use likes instead* The number of users who have hearted this task.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        num_likes: {
          description: 'The number of users who have liked this task.',
          example: 5,
          readOnly: true,
          type: 'integer',
        },
        num_subtasks: {
          description: `[Opt In](/docs/input-output-options). The number of subtasks on this task.
`,
          example: 3,
          readOnly: true,
          type: 'integer',
        },
        start_at: {
          description: `Date and time on which work begins for the task, or null if the task has no start time. This takes an ISO 8601 date string in UTC and should not be used together with \`start_on\`.
*Note: \`due_at\` must be present in the request when setting or unsetting the \`start_at\` parameter.*`,
          example: '2019-09-14T02:06:58.147Z',
          format: 'date',
          nullable: true,
          type: 'string',
        },
        start_on: {
          description: `The day on which work begins for the task , or null if the task has no start date. This takes a date with \`YYYY-MM-DD\` format and should not be used together with \`start_at\`.
*Note: \`due_on\` or \`due_at\` must be present in the request when setting or unsetting the \`start_on\` parameter.*`,
          example: '2019-09-14',
          format: 'date',
          nullable: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TaskCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'The *task* is the basic object around which many operations in Asana are centered.',
      properties: {
        name: {
          description: 'The name of the task.',
          example: 'Bug Task',
          type: 'string',
        },
        resource_subtype: {
          description: `The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.
The resource_subtype \`milestone\` represent a single moment in time. This means tasks with this subtype cannot have a start_date.`,
          enum: ['default_task', 'milestone', 'section', 'approval'],
          example: 'default_task',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'task',
      },
    },
  ],
} as const;

export const TaskCountResponseSchema = {
  description: 'A response object returned from the task count endpoint.',
  properties: {
    num_completed_milestones: {
      description: 'The number of completed milestones in a project.',
      example: 3,
      type: 'integer',
    },
    num_completed_tasks: {
      description: 'The number of completed tasks in a project.',
      example: 150,
      type: 'integer',
    },
    num_incomplete_milestones: {
      description: 'The number of incomplete milestones in a project.',
      example: 7,
      type: 'integer',
    },
    num_incomplete_tasks: {
      description: 'The number of incomplete tasks in a project.',
      example: 50,
      type: 'integer',
    },
    num_milestones: {
      description: 'The number of milestones in a project.',
      example: 10,
      type: 'integer',
    },
    num_tasks: {
      description: 'The number of tasks in a project.',
      example: 200,
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const TaskDuplicateRequestSchema = {
  properties: {
    include: {
      description: 'The fields that will be duplicated to the new task.',
      enum: [
        'notes',
        'assignee',
        'subtasks',
        'attachments',
        'tags',
        'followers',
        'projects',
        'dates',
        'dependencies',
        'parent',
      ],
      example: ['notes', 'assignee'],
      type: 'string',
    },
    name: {
      description: 'The name of the new task.',
      example: 'New Task Name',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const TaskRemoveFollowersRequestSchema = {
  properties: {
    followers: {
      description:
        'An array of strings identifying users. These can either be the string "me", an email, or the gid of a user.',
      example: ['13579', '321654'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['followers'],
  type: 'object',
} as const;

export const TaskRemoveProjectRequestSchema = {
  properties: {
    project: {
      description: 'The project to remove the task from.',
      example: '13579',
      type: 'string',
    },
  },
  required: ['project'],
  type: 'object',
} as const;

export const TaskRemoveTagRequestSchema = {
  properties: {
    tag: {
      description: 'The tag to remove from the task.',
      example: '13579',
      type: 'string',
    },
  },
  required: ['tag'],
  type: 'object',
} as const;

export const TaskRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TaskBase',
    },
    {
      properties: {
        assignee: {
          description: 'Gid of a user.',
          example: '12345',
          nullable: true,
          readOnly: false,
          type: 'string',
          'x-env-variable': true,
        },
        assignee_section: {
          description: `The *assignee section* is a subdivision of a project that groups tasks together in the assignee's "My Tasks" list. It can either be a header above a list of tasks in a list view or a column in a board view of "My Tasks."
The \`assignee_section\` property will be returned in the response only if the request was sent by the user who is the assignee of the task. Note that you can only write to \`assignee_section\` with the gid of an existing section visible in the user's "My Tasks" list.`,
          example: '12345',
          nullable: true,
          type: 'string',
        },
        custom_fields: {
          additionalProperties: {
            description: '"{custom_field_gid}" => Value (Can be text, number, etc.)',
            type: 'string',
          },
          description:
            'An object where each key is a Custom Field GID and each value is an enum GID, string, number, object, or array.',
          example: {
            4578152156: 'Not Started',
            5678904321: 'On Hold',
          },
          type: 'object',
        },
        followers: {
          description:
            '*Create-Only* An array of strings identifying users. These can either be the string "me", an email, or the gid of a user. In order to change followers on an existing task use `addFollowers` and `removeFollowers`.',
          example: ['12345'],
          items: {
            description: 'Gid of a user.',
            type: 'string',
          },
          type: 'array',
        },
        parent: {
          description: 'Gid of a task.',
          example: '12345',
          nullable: true,
          readOnly: false,
          type: 'string',
          'x-env-variable': true,
        },
        projects: {
          description:
            '*Create-Only* Array of project gids. In order to change projects on an existing task use `addProject` and `removeProject`.',
          example: ['12345'],
          items: {
            description: 'Gid of a project.',
            type: 'string',
          },
          type: 'array',
        },
        tags: {
          description:
            '*Create-Only* Array of tag gids. In order to change tags on an existing task use `addTag` and `removeTag`.',
          example: ['12345'],
          items: {
            description: 'Gid of a tag.',
            type: 'string',
          },
          type: 'array',
        },
        workspace: {
          description: 'Gid of a workspace.',
          example: '12345',
          readOnly: false,
          type: 'string',
          'x-env-variable': true,
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TaskResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TaskBase',
    },
    {
      properties: {
        assignee: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
          ],
          nullable: true,
        },
        assignee_section: {
          allOf: [
            {
              $ref: '#/components/schemas/SectionCompact',
            },
            {
              description: `The *assignee section* is a subdivision of a project that groups tasks together in the assignee's "My Tasks" list. It can either be a header above a list of tasks in a list view or a column in a board view of "My Tasks."
The \`assignee_section\` property will be returned in the response only if the request was sent by the user who is the assignee of the task. Note that you can only write to \`assignee_section\` with the gid of an existing section visible in the user's "My Tasks" list.`,
            },
          ],
          nullable: true,
        },
        custom_fields: {
          description:
            'Array of custom field values applied to the task. These represent the custom field values recorded on this project for a particular custom field. For example, these custom field values will contain an `enum_value` property for custom fields of type `enum`, a `text_value` property for custom fields of type `text`, and so on. Please note that the `gid` returned on each custom field value *is identical* to the `gid` of the custom field, which allows referencing the custom field metadata through the `/custom_fields/custom_field-gid` endpoint.',
          items: {
            $ref: '#/components/schemas/CustomFieldResponse',
          },
          readOnly: true,
          type: 'array',
        },
        followers: {
          description: 'Array of users following this task.',
          items: {
            $ref: '#/components/schemas/UserCompact',
          },
          readOnly: true,
          type: 'array',
        },
        parent: {
          allOf: [
            {
              $ref: '#/components/schemas/TaskCompact',
            },
            {
              description:
                'The parent of this task, or `null` if this is not a subtask. This property cannot be modified using a PUT request but you can change it with the `setParent` endpoint. You can create subtasks by using the subtasks endpoint.',
              nullable: true,
              readOnly: true,
              type: 'object',
            },
          ],
        },
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/resource/123456789/list',
          readOnly: true,
          type: 'string',
        },
        projects: {
          description:
            '*Create-only.* Array of projects this task is associated with. At task creation time, this array can be used to add the task to many projects at once. After task creation, these associations can be modified using the addProject and removeProject endpoints.',
          items: {
            $ref: '#/components/schemas/ProjectCompact',
          },
          readOnly: true,
          type: 'array',
        },
        tags: {
          description:
            'Array of tags associated with this task. In order to change tags on an existing task use `addTag` and `removeTag`.',
          example: [
            {
              gid: '59746',
              name: 'Grade A',
            },
          ],
          items: {
            $ref: '#/components/schemas/TagCompact',
          },
          readOnly: true,
          type: 'array',
        },
        workspace: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
            {
              description:
                '*Create-only*. The workspace this task is associated with. Once created, task cannot be moved to a different workspace. This attribute can only be specified at creation time.',
              readOnly: true,
              type: 'object',
            },
          ],
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TaskSetParentRequestSchema = {
  properties: {
    insert_after: {
      description:
        'A subtask of the parent to insert the task after, or `null` to insert at the beginning of the list.',
      example: 'null',
      type: 'string',
    },
    insert_before: {
      description: 'A subtask of the parent to insert the task before, or `null` to insert at the end of the list.',
      example: '124816',
      type: 'string',
    },
    parent: {
      description: 'The new parent of the task, or `null` for no parent.',
      example: '987654',
      type: 'string',
    },
  },
  required: ['parent'],
  type: 'object',
} as const;

export const TeamAddUserRequestSchema = {
  description: 'A user identification object for specification with the addUser/removeUser endpoints.',
  properties: {
    user: {
      description: 'A string identifying a user. This can either be the string "me", an email, or the gid of a user.',
      example: '12345',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const TeamBaseSchema = {
  $ref: '#/components/schemas/TeamCompact',
} as const;

export const TeamCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *team* is used to group related projects and people together within an organization. Each project in an organization is associated with a team.',
      properties: {
        name: {
          description: 'The name of the team.',
          example: 'Marketing',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'team',
      },
    },
  ],
} as const;

export const TeamMembershipBaseSchema = {
  $ref: '#/components/schemas/TeamMembershipCompact',
} as const;

export const TeamMembershipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: "This object represents a user's connection to a team.",
      properties: {
        is_guest: {
          description: 'Describes if the user is a guest in the team.',
          example: false,
          type: 'boolean',
        },
        team: {
          $ref: '#/components/schemas/TeamCompact',
        },
        user: {
          $ref: '#/components/schemas/UserCompact',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'team_membership',
      },
    },
  ],
} as const;

export const TeamMembershipResponseSchema = {
  $ref: '#/components/schemas/TeamMembershipCompact',
} as const;

export const TeamRemoveUserRequestSchema = {
  description: 'A user identification object for specification with the addUser/removeUser endpoints.',
  properties: {
    user: {
      description: 'A string identifying a user. This can either be the string "me", an email, or the gid of a user.',
      example: '12345',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const TeamRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TeamCompact',
    },
    {
      properties: {
        description: {
          description: `The description of the team.
`,
          example: 'All developers should be members of this team.',
          type: 'string',
        },
        html_description: {
          description: `The description of the team with formatting as HTML.
`,
          example: '<body><em>All</em> developers should be members of this team.</body>',
          type: 'string',
        },
        organization: {
          description: `The organization/workspace the team belongs to. This must be the same organization you are in and cannot be changed once set.
`,
          example: '123456789',
          type: 'string',
        },
        visibility: {
          description: `The visibility of the team to users in the same organization
`,
          enum: ['secret', 'request_to_join', 'public'],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TeamResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TeamCompact',
    },
    {
      properties: {
        description: {
          description: `[Opt In](/docs/input-output-options). The description of the team.
`,
          example: 'All developers should be members of this team.',
          type: 'string',
        },
        html_description: {
          description: `[Opt In](/docs/input-output-options). The description of the team with formatting as HTML.
`,
          example: '<body><em>All</em> developers should be members of this team.</body>',
          type: 'string',
        },
        organization: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
            {
              description: `The organization/workspace the team belongs to.
`,
              type: 'object',
            },
          ],
        },
        permalink_url: {
          description: 'A url that points directly to the object within Asana.',
          example: 'https://app.asana.com/0/resource/123456789/list',
          readOnly: true,
          type: 'string',
        },
        visibility: {
          description: `The visibility of the team to users in the same organization
`,
          enum: ['secret', 'request_to_join', 'public'],
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TimePeriodBaseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TimePeriodCompact',
    },
    {
      properties: {
        parent: {
          $ref: '#/components/schemas/TimePeriodCompact',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const TimePeriodCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      properties: {
        display_name: {
          description: 'A string representing the cadence code and the fiscal year.',
          example: 'Q1 FY22',
          type: 'string',
        },
        end_on: {
          description: 'The localized end date of the time period in `YYYY-MM-DD` format.',
          example: '2019-09-14',
          type: 'string',
        },
        period: {
          description:
            'The cadence and index of the time period. The value is one of: `FY`, `H1`, `H2`, `Q1`, `Q2`, `Q3`, or `Q4`.',
          enum: ['FY', 'H1', 'H2', 'Q1', 'Q2', 'Q3', 'Q4'],
          example: 'Q1',
          type: 'string',
        },
        start_on: {
          description: 'The localized start date of the time period in `YYYY-MM-DD` format.',
          example: '2019-09-13',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'time_period',
      },
    },
  ],
} as const;

export const TimePeriodResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/TimePeriodBase',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const UserBaseSchema = {
  $ref: '#/components/schemas/UserCompact',
} as const;

export const UserBaseResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/UserCompact',
    },
    {
      properties: {
        email: {
          description: "The user's email address.",
          example: 'gsanchez@example.com',
          format: 'email',
          readOnly: true,
          type: 'string',
        },
        photo: {
          description:
            'A map of the user’s profile photo in various sizes, or null if no photo is set. Sizes provided are 21, 27, 36, 60, 128, and 1024. All images are in PNG format, except for 1024 (which is in JPEG format).',
          example: {
            image_1024x1024: 'https://...',
            image_128x128: 'https://...',
            image_21x21: 'https://...',
            image_27x27: 'https://...',
            image_36x36: 'https://...',
            image_60x60: 'https://...',
          },
          nullable: true,
          properties: {
            image_1024x1024: {
              format: 'uri',
              type: 'string',
            },
            image_128x128: {
              format: 'uri',
              type: 'string',
            },
            image_21x21: {
              format: 'uri',
              type: 'string',
            },
            image_27x27: {
              format: 'uri',
              type: 'string',
            },
            image_36x36: {
              format: 'uri',
              type: 'string',
            },
            image_60x60: {
              format: 'uri',
              type: 'string',
            },
          },
          readOnly: true,
          type: 'object',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const UserCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *user* object represents an account in Asana that can be given access to various workspaces, projects, and tasks.',
      properties: {
        name: {
          description: '*Read-only except when same user as requester*. The user’s name.',
          example: 'Greg Sanchez',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'user',
      },
    },
  ],
} as const;

export const UserRequestSchema = {
  $ref: '#/components/schemas/UserCompact',
} as const;

export const UserResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/UserBaseResponse',
    },
    {
      properties: {
        workspaces: {
          description: `Workspaces and organizations this user may access.
Note\: The API will only return workspaces and organizations that also contain the authenticated user.`,
          items: {
            $ref: '#/components/schemas/WorkspaceCompact',
          },
          readOnly: true,
          type: 'array',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const UserTaskListBaseSchema = {
  $ref: '#/components/schemas/UserTaskListCompact',
} as const;

export const UserTaskListCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A user task list represents the tasks assigned to a particular user. It provides API access to a user’s [My Tasks](https://asana.com/guide/help/fundamentals/my-tasks) view in Asana.',
      properties: {
        name: {
          description: 'The name of the user task list.',
          example: 'My Tasks in My Workspace',
          type: 'string',
        },
        owner: {
          allOf: [
            {
              $ref: '#/components/schemas/UserCompact',
            },
          ],
          description:
            'The owner of the user task list, i.e. the person whose My Tasks is represented by this resource.',
          readOnly: true,
        },
        workspace: {
          allOf: [
            {
              $ref: '#/components/schemas/WorkspaceCompact',
            },
          ],
          description: 'The workspace in which the user task list is located.',
          readOnly: true,
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'user_task_list',
      },
    },
  ],
} as const;

export const UserTaskListRequestSchema = {
  $ref: '#/components/schemas/UserTaskListCompact',
} as const;

export const UserTaskListResponseSchema = {
  $ref: '#/components/schemas/UserTaskListCompact',
} as const;

export const WebhookCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'Webhook objects represent the state of an active subscription for a server to be updated with information from Asana. This schema represents the subscription itself, not the objects that are sent to the server. For information on those please refer to the [Event](/docs/tocS_Event) schema.',
      properties: {
        active: {
          description:
            'If true, the webhook will send events - if false it is considered inactive and will not generate events.',
          example: false,
          readOnly: true,
          type: 'boolean',
        },
        resource: {
          $ref: '#/components/schemas/AsanaNamedResource',
        },
        target: {
          description: 'The URL to receive the HTTP POST.',
          example: 'https://example.com/receive-webhook/7654',
          format: 'uri',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'webhook',
      },
    },
  ],
} as const;

export const WebhookFilterSchema = {
  description:
    'A WebhookFilter can be passed on creation of a webhook in order to filter the types of actions that trigger delivery of an [Event](/docs/tocS_Event)',
  properties: {
    action: {
      description:
        'The type of change on the **resource** to pass through the filter. For more information refer to `Event.action` in the [Event](/docs/tocS_Event) schema. This can be one of `changed`, `added`, `removed`, `deleted`, and `undeleted` depending on the nature of what has occurred on the resource.',
      example: 'changed',
      type: 'string',
    },
    fields: {
      description:
        '*Conditional.* A whitelist of fields for events which will pass the filter when the resource is changed. These can be any combination of the fields on the resources themselves. This field is only valid for `action` of type `changed`',
      example: ['due_at', 'due_on', 'dependencies'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    resource_subtype: {
      description:
        'The resource subtype of the resource that the filter applies to. This should be set to the same value as is returned on the `resource_subtype` field on the resources themselves.',
      example: 'milestone',
      type: 'string',
    },
    resource_type: {
      description:
        'The type of the resource which created the event when modified; for example, to filter to changes on regular tasks this field should be set to `task`.',
      example: 'task',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const WebhookRequestSchema = {
  properties: {
    filters: {
      description:
        'An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.',
      items: {
        allOf: [
          {
            $ref: '#/components/schemas/WebhookFilter',
          },
          {
            description: 'A set of filters to specify a whitelist for what types of events will be delivered.',
          },
          {
            type: 'object',
          },
        ],
      },
      type: 'array',
    },
    resource: {
      description:
        'A resource ID to subscribe to. Many Asana resources are valid to create webhooks on, but higher-level resources require filters.',
      example: '12345',
      type: 'string',
    },
    target: {
      description:
        'The URL to receive the HTTP POST. The full URL will be used to deliver events from this webhook (including parameters) which allows encoding of application-specific state when the webhook is created.',
      example: 'https://example.com/receive-webhook/7654?app_specific_param=app_specific_value',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['resource', 'target'],
  type: 'object',
} as const;

export const WebhookResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/WebhookCompact',
    },
    {
      properties: {
        created_at: {
          description: 'The time at which this resource was created.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        filters: {
          description:
            'Whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.',
          items: {
            allOf: [
              {
                $ref: '#/components/schemas/WebhookFilter',
              },
              {
                description: 'A set of filters to specify a whitelist for what types of events will be delivered.',
              },
              {
                type: 'object',
              },
            ],
          },
          type: 'array',
        },
        last_failure_at: {
          description: 'The timestamp when the webhook last received an error when sending an event to the target.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
        last_failure_content: {
          description:
            'The contents of the last error response sent to the webhook when attempting to deliver events to the target.',
          example: '500 Server Error\\n\\nCould not complete the request',
          readOnly: true,
          type: 'string',
        },
        last_success_at: {
          description: 'The timestamp when the webhook last successfully sent an event to the target.',
          example: '2012-02-22T02:06:58.147Z',
          format: 'date-time',
          readOnly: true,
          type: 'string',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const WebhookUpdateRequestSchema = {
  properties: {
    filters: {
      description:
        'An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.',
      items: {
        allOf: [
          {
            $ref: '#/components/schemas/WebhookFilter',
          },
          {
            description: 'A set of filters to specify a whitelist for what types of events will be delivered.',
          },
          {
            type: 'object',
          },
        ],
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const WorkspaceAddUserRequestSchema = {
  description: 'A user identification object for specification with the addUser/removeUser endpoints.',
  properties: {
    user: {
      description: 'A string identifying a user. This can either be the string "me", an email, or the gid of a user.',
      example: '12345',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const WorkspaceBaseSchema = {
  $ref: '#/components/schemas/WorkspaceCompact',
} as const;

export const WorkspaceCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description:
        'A *workspace* is the highest-level organizational unit in Asana. All projects and tasks have an associated workspace.',
      properties: {
        name: {
          description: 'The name of the workspace.',
          example: 'My Company Workspace',
          type: 'string',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'workspace',
      },
    },
  ],
} as const;

export const WorkspaceMembershipBaseSchema = {
  $ref: '#/components/schemas/WorkspaceMembershipCompact',
} as const;

export const WorkspaceMembershipCompactSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/AsanaResource',
    },
    {
      description: 'This object determines if a user is a member of a workspace.',
      properties: {
        user: {
          $ref: '#/components/schemas/UserCompact',
        },
        workspace: {
          $ref: '#/components/schemas/WorkspaceCompact',
        },
      },
      type: 'object',
      'x-docs-overrides': {
        'properties.resource_type.example': 'workspace_membership',
      },
    },
  ],
} as const;

export const WorkspaceMembershipRequestSchema = {
  $ref: '#/components/schemas/WorkspaceMembershipCompact',
} as const;

export const WorkspaceMembershipResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/WorkspaceMembershipCompact',
    },
    {
      properties: {
        is_active: {
          description: 'Reflects if this user still a member of the workspace.',
          readOnly: true,
          type: 'boolean',
        },
        is_admin: {
          description: 'Reflects if this user is an admin of the workspace.',
          readOnly: true,
          type: 'boolean',
        },
        is_guest: {
          description: 'Reflects if this user is a guest of the workspace.',
          readOnly: true,
          type: 'boolean',
        },
        user_task_list: {
          $ref: '#/components/schemas/UserTaskListCompact',
          description: `The user's "My Tasks" in the workspace.`,
          readOnly: true,
        },
        vacation_dates: {
          description:
            'Contains keys `start_on` and `end_on` for the vacation dates for the user in this workspace. If `start_on` is null, the entire `vacation_dates` object will be null. If `end_on` is before today, the entire `vacation_dates` object will be null.',
          nullable: true,
          properties: {
            end_on: {
              description:
                "The day on which the user's vacation in this workspace ends, or null if there is no end date. This is a date with `YYYY-MM-DD` format.",
              example: '2022-11-07',
              nullable: true,
              type: 'string',
            },
            start_on: {
              description:
                "The day on which the user's vacation in this workspace starts. This is a date with `YYYY-MM-DD` format.",
              example: '2022-11-05',
              type: 'string',
            },
          },
          readOnly: true,
          type: 'object',
        },
      },
      type: 'object',
    },
  ],
} as const;

export const WorkspaceRemoveUserRequestSchema = {
  description: 'A user identification object for specification with the addUser/removeUser endpoints.',
  properties: {
    user: {
      description: 'A string identifying a user. This can either be the string "me", an email, or the gid of a user.',
      example: '12345',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const WorkspaceRequestSchema = {
  $ref: '#/components/schemas/WorkspaceCompact',
} as const;

export const WorkspaceResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/WorkspaceCompact',
    },
    {
      properties: {
        email_domains: {
          description: 'The email domains that are associated with this workspace.',
          example: ['asana.com'],
          items: {
            format: 'uri',
            type: 'string',
          },
          type: 'array',
        },
        is_organization: {
          description: 'Whether the workspace is an *organization*.',
          example: false,
          type: 'boolean',
        },
      },
      type: 'object',
    },
  ],
} as const;
