// Generated by ts-to-zod
import { z } from 'zod';

export const accountEnumStatusSchema = z.union([z.literal('active'), z.literal('suspended'), z.literal('closed')]);

export const accountEnumTypeSchema = z.union([z.literal('Trial'), z.literal('Full')]);

export const apiV2010AccountSchema = z.object({
  auth_token: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  owner_account_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: accountEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  type: accountEnumTypeSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountAddressSchema = z.object({
  account_sid: z.string().optional().nullable(),
  city: z.string().optional().nullable(),
  customer_name: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_enabled: z.boolean().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  street: z.string().optional().nullable(),
  street_secondary: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  validated: z.boolean().optional().nullable(),
  verified: z.boolean().optional().nullable(),
});

export const dependentPhoneNumberEnumAddressRequirementSchema = z.union([
  z.literal('none'),
  z.literal('any'),
  z.literal('local'),
  z.literal('foreign'),
]);

export const dependentPhoneNumberEnumEmergencyStatusSchema = z.union([z.literal('Active'), z.literal('Inactive')]);

export const smsFallbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const smsMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const statusCallbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const voiceFallbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const voiceMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const apiV2010AccountApplicationSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  message_status_callback: z.string().optional().nullable(),
  public_application_connect_enabled: z.boolean().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_status_callback: z.string().optional().nullable(),
  sms_url: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  uri: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_url: z.string().optional().nullable(),
});

export const authorizedConnectAppEnumPermissionSchema = z.union([z.literal('get-all'), z.literal('post-all')]);

export const apiV2010AccountAvailablePhoneNumberCountrySchema = z.object({
  beta: z.boolean().optional().nullable(),
  country: z.string().optional().nullable(),
  country_code: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberLocalSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberMachineToMachineSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberMobileSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberNationalSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberSharedCostSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberTollFreeSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberVoipSchema = z.object({
  address_requirements: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  friendly_name: z.string().optional().nullable(),
  iso_country: z.string().optional().nullable(),
  lata: z.string().optional().nullable(),
  latitude: z.number().optional().nullable(),
  locality: z.string().optional().nullable(),
  longitude: z.number().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  postal_code: z.string().optional().nullable(),
  rate_center: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
});

export const apiV2010AccountBalanceSchema = z.object({
  account_sid: z.string().optional().nullable(),
  balance: z.string().optional().nullable(),
  currency: z.string().optional().nullable(),
});

export const callEnumStatusSchema = z.union([
  z.literal('queued'),
  z.literal('ringing'),
  z.literal('in-progress'),
  z.literal('completed'),
  z.literal('busy'),
  z.literal('failed'),
  z.literal('no-answer'),
  z.literal('canceled'),
]);

export const apiV2010AccountCallCallEventSchema = z.object({
  request: z.unknown().optional(),
  response: z.unknown().optional(),
});

export const apiV2010AccountCallCallNotificationSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  error_code: z.string().optional().nullable(),
  log: z.string().optional().nullable(),
  message_date: z.string().optional().nullable(),
  message_text: z.string().optional().nullable(),
  more_info: z.string().optional().nullable(),
  request_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  request_url: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const requestMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const apiV2010AccountCallCallNotificationInstanceSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  error_code: z.string().optional().nullable(),
  log: z.string().optional().nullable(),
  message_date: z.string().optional().nullable(),
  message_text: z.string().optional().nullable(),
  more_info: z.string().optional().nullable(),
  request_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  request_url: z.string().optional().nullable(),
  request_variables: z.string().optional().nullable(),
  response_body: z.string().optional().nullable(),
  response_headers: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const callRecordingEnumSourceSchema = z.union([
  z.literal('DialVerb'),
  z.literal('Conference'),
  z.literal('OutboundAPI'),
  z.literal('Trunking'),
  z.literal('RecordVerb'),
  z.literal('StartCallRecordingAPI'),
  z.literal('StartConferenceRecordingAPI'),
]);

export const callRecordingEnumStatusSchema = z.union([
  z.literal('in-progress'),
  z.literal('paused'),
  z.literal('stopped'),
  z.literal('processing'),
  z.literal('completed'),
  z.literal('absent'),
]);

export const apiV2010AccountCallPaymentsSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const siprecEnumStatusSchema = z.union([z.literal('in-progress'), z.literal('stopped')]);

export const streamEnumStatusSchema = z.union([z.literal('in-progress'), z.literal('stopped')]);

export const apiV2010AccountCallUserDefinedMessageSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountCallUserDefinedMessageSubscriptionSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const conferenceEnumReasonConferenceEndedSchema = z.union([
  z.literal('conference-ended-via-api'),
  z.literal('participant-with-end-conference-on-exit-left'),
  z.literal('participant-with-end-conference-on-exit-kicked'),
  z.literal('last-participant-kicked'),
  z.literal('last-participant-left'),
]);

export const conferenceEnumStatusSchema = z.union([
  z.literal('init'),
  z.literal('in-progress'),
  z.literal('completed'),
]);

export const conferenceRecordingEnumSourceSchema = z.union([
  z.literal('DialVerb'),
  z.literal('Conference'),
  z.literal('OutboundAPI'),
  z.literal('Trunking'),
  z.literal('RecordVerb'),
  z.literal('StartCallRecordingAPI'),
  z.literal('StartConferenceRecordingAPI'),
]);

export const conferenceRecordingEnumStatusSchema = z.union([
  z.literal('in-progress'),
  z.literal('paused'),
  z.literal('stopped'),
  z.literal('processing'),
  z.literal('completed'),
  z.literal('absent'),
]);

export const participantEnumStatusSchema = z.union([
  z.literal('queued'),
  z.literal('connecting'),
  z.literal('ringing'),
  z.literal('connected'),
  z.literal('complete'),
  z.literal('failed'),
]);

export const connectAppEnumPermissionSchema = z.union([z.literal('get-all'), z.literal('post-all')]);

export const deauthorizeCallbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const incomingPhoneNumberEnumAddressRequirementSchema = z.union([
  z.literal('none'),
  z.literal('any'),
  z.literal('local'),
  z.literal('foreign'),
]);

export const incomingPhoneNumberEnumEmergencyAddressStatusSchema = z.union([
  z.literal('registered'),
  z.literal('unregistered'),
  z.literal('pending-registration'),
  z.literal('registration-failure'),
  z.literal('pending-unregistration'),
  z.literal('unregistration-failure'),
]);

export const incomingPhoneNumberEnumEmergencyStatusSchema = z.union([z.literal('Active'), z.literal('Inactive')]);

export const incomingPhoneNumberEnumVoiceReceiveModeSchema = z.union([z.literal('voice'), z.literal('fax')]);

export const apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnSchema = z.object({
  account_sid: z.string().optional().nullable(),
  configuration: z.unknown().optional(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  resource_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  unique_name: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnIncomingPhoneNumberAssignedAddOnExtensionSchema =
  z.object({
    account_sid: z.string().optional().nullable(),
    assigned_add_on_sid: z.string().optional().nullable(),
    enabled: z.boolean().optional().nullable(),
    friendly_name: z.string().optional().nullable(),
    product_name: z.string().optional().nullable(),
    resource_sid: z.string().optional().nullable(),
    sid: z.string().optional().nullable(),
    unique_name: z.string().optional().nullable(),
    uri: z.string().optional().nullable(),
  });

export const incomingPhoneNumberLocalEnumAddressRequirementSchema = z.union([
  z.literal('none'),
  z.literal('any'),
  z.literal('local'),
  z.literal('foreign'),
]);

export const incomingPhoneNumberLocalEnumEmergencyAddressStatusSchema = z.union([
  z.literal('registered'),
  z.literal('unregistered'),
  z.literal('pending-registration'),
  z.literal('registration-failure'),
  z.literal('pending-unregistration'),
  z.literal('unregistration-failure'),
]);

export const incomingPhoneNumberLocalEnumEmergencyStatusSchema = z.union([z.literal('Active'), z.literal('Inactive')]);

export const incomingPhoneNumberLocalEnumVoiceReceiveModeSchema = z.union([z.literal('voice'), z.literal('fax')]);

export const incomingPhoneNumberMobileEnumAddressRequirementSchema = z.union([
  z.literal('none'),
  z.literal('any'),
  z.literal('local'),
  z.literal('foreign'),
]);

export const incomingPhoneNumberMobileEnumEmergencyAddressStatusSchema = z.union([
  z.literal('registered'),
  z.literal('unregistered'),
  z.literal('pending-registration'),
  z.literal('registration-failure'),
  z.literal('pending-unregistration'),
  z.literal('unregistration-failure'),
]);

export const incomingPhoneNumberMobileEnumEmergencyStatusSchema = z.union([z.literal('Active'), z.literal('Inactive')]);

export const incomingPhoneNumberMobileEnumVoiceReceiveModeSchema = z.union([z.literal('voice'), z.literal('fax')]);

export const incomingPhoneNumberTollFreeEnumAddressRequirementSchema = z.union([
  z.literal('none'),
  z.literal('any'),
  z.literal('local'),
  z.literal('foreign'),
]);

export const incomingPhoneNumberTollFreeEnumEmergencyAddressStatusSchema = z.union([
  z.literal('registered'),
  z.literal('unregistered'),
  z.literal('pending-registration'),
  z.literal('registration-failure'),
  z.literal('pending-unregistration'),
  z.literal('unregistration-failure'),
]);

export const incomingPhoneNumberTollFreeEnumEmergencyStatusSchema = z.union([
  z.literal('Active'),
  z.literal('Inactive'),
]);

export const incomingPhoneNumberTollFreeEnumVoiceReceiveModeSchema = z.union([z.literal('voice'), z.literal('fax')]);

export const apiV2010AccountKeySchema = z.object({
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const messageEnumDirectionSchema = z.union([
  z.literal('inbound'),
  z.literal('outbound-api'),
  z.literal('outbound-call'),
  z.literal('outbound-reply'),
]);

export const messageEnumStatusSchema = z.union([
  z.literal('queued'),
  z.literal('sending'),
  z.literal('sent'),
  z.literal('failed'),
  z.literal('delivered'),
  z.literal('undelivered'),
  z.literal('receiving'),
  z.literal('received'),
  z.literal('accepted'),
  z.literal('scheduled'),
  z.literal('read'),
  z.literal('partially_delivered'),
  z.literal('canceled'),
]);

export const apiV2010AccountMessageMediaSchema = z.object({
  account_sid: z.string().optional().nullable(),
  content_type: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  parent_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const messageFeedbackEnumOutcomeSchema = z.union([z.literal('confirmed'), z.literal('unconfirmed')]);

export const apiV2010AccountNewKeySchema = z.object({
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  secret: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountNewSigningKeySchema = z.object({
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  secret: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountNotificationSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  error_code: z.string().optional().nullable(),
  log: z.string().optional().nullable(),
  message_date: z.string().optional().nullable(),
  message_text: z.string().optional().nullable(),
  more_info: z.string().optional().nullable(),
  request_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  request_url: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountNotificationInstanceSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  error_code: z.string().optional().nullable(),
  log: z.string().optional().nullable(),
  message_date: z.string().optional().nullable(),
  message_text: z.string().optional().nullable(),
  more_info: z.string().optional().nullable(),
  request_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  request_url: z.string().optional().nullable(),
  request_variables: z.string().optional().nullable(),
  response_body: z.string().optional().nullable(),
  response_headers: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountOutgoingCallerIdSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountQueueSchema = z.object({
  account_sid: z.string().optional().nullable(),
  average_wait_time: z.number().optional().nullable(),
  current_size: z.number().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  max_size: z.number().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountQueueMemberSchema = z.object({
  call_sid: z.string().optional().nullable(),
  date_enqueued: z.string().optional().nullable(),
  position: z.number().optional().nullable(),
  queue_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  wait_time: z.number().optional().nullable(),
});

export const recordingEnumSourceSchema = z.union([
  z.literal('DialVerb'),
  z.literal('Conference'),
  z.literal('OutboundAPI'),
  z.literal('Trunking'),
  z.literal('RecordVerb'),
  z.literal('StartCallRecordingAPI'),
  z.literal('StartConferenceRecordingAPI'),
]);

export const recordingEnumStatusSchema = z.union([
  z.literal('in-progress'),
  z.literal('paused'),
  z.literal('stopped'),
  z.literal('processing'),
  z.literal('completed'),
  z.literal('absent'),
  z.literal('deleted'),
]);

export const recordingAddOnResultEnumStatusSchema = z.union([
  z.literal('canceled'),
  z.literal('completed'),
  z.literal('deleted'),
  z.literal('failed'),
  z.literal('in-progress'),
  z.literal('init'),
  z.literal('processing'),
  z.literal('queued'),
]);

export const apiV2010AccountRecordingRecordingAddOnResultRecordingAddOnResultPayloadSchema = z.object({
  account_sid: z.string().optional().nullable(),
  add_on_configuration_sid: z.string().optional().nullable(),
  add_on_result_sid: z.string().optional().nullable(),
  add_on_sid: z.string().optional().nullable(),
  content_type: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  label: z.string().optional().nullable(),
  reference_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
});

export const recordingTranscriptionEnumStatusSchema = z.union([
  z.literal('in-progress'),
  z.literal('completed'),
  z.literal('failed'),
]);

export const apiV2010AccountShortCodeSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  short_code: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountSigningKeySchema = z.object({
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountSipSchema = z.record(z.unknown());

export const apiV2010AccountSipSipCredentialListSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipCredentialListSipCredentialSchema = z.object({
  account_sid: z.string().optional().nullable(),
  credential_list_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  username: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipDomainSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  auth_type: z.string().optional().nullable(),
  byoc_trunk_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  domain_name: z.string().optional().nullable(),
  emergency_caller_sid: z.string().optional().nullable(),
  emergency_calling_enabled: z.boolean().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  secure: z.boolean().optional().nullable(),
  sid: z.string().optional().nullable(),
  sip_registration: z.boolean().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_status_callback_url: z.string().optional().nullable(),
  voice_url: z.string().optional().nullable(),
});

export const voiceStatusCallbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const apiV2010AccountSipSipDomainSipAuthSchema = z.record(z.unknown());

export const apiV2010AccountSipSipDomainSipAuthSipAuthCallsSchema = z.record(z.unknown());

export const apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsCredentialListMappingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsIpAccessControlListMappingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipDomainSipAuthSipAuthRegistrationsSchema = z.record(z.unknown());

export const apiV2010AccountSipSipDomainSipAuthSipAuthRegistrationsSipAuthRegistrationsCredentialListMappingSchema =
  z.object({
    account_sid: z.string().optional().nullable(),
    date_created: z.string().optional().nullable(),
    date_updated: z.string().optional().nullable(),
    friendly_name: z.string().optional().nullable(),
    sid: z.string().optional().nullable(),
  });

export const apiV2010AccountSipSipDomainSipCredentialListMappingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  domain_sid: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipDomainSipIpAccessControlListMappingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  domain_sid: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipIpAccessControlListSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountSipSipIpAccessControlListSipIpAddressSchema = z.object({
  account_sid: z.string().optional().nullable(),
  cidr_prefix_length: z.number().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  ip_access_control_list_sid: z.string().optional().nullable(),
  ip_address: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const apiV2010AccountTokenSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  ice_servers: z
    .array(
      z.object({
        credential: z.string().optional(),
        url: z.string().optional(),
        urls: z.string().optional(),
        username: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
  password: z.string().optional().nullable(),
  ttl: z.string().optional().nullable(),
  username: z.string().optional().nullable(),
});

export const transcriptionEnumStatusSchema = z.union([
  z.literal('in-progress'),
  z.literal('completed'),
  z.literal('failed'),
]);

export const apiV2010AccountUsageSchema = z.record(z.unknown());

export const usageRecordEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordAllTimeEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordDailyEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordLastMonthEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordMonthlyEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordThisMonthEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordTodayEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordYearlyEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageRecordYesterdayEnumCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const usageTriggerEnumRecurringSchema = z.union([
  z.literal('daily'),
  z.literal('monthly'),
  z.literal('yearly'),
  z.literal('alltime'),
]);

export const usageTriggerEnumTriggerFieldSchema = z.union([z.literal('count'), z.literal('usage'), z.literal('price')]);

export const usageTriggerEnumUsageCategorySchema = z.union([
  z.literal('a2p-registration-fees'),
  z.literal('agent-conference'),
  z.literal('amazon-polly'),
  z.literal('answering-machine-detection'),
  z.literal('authy-authentications'),
  z.literal('authy-calls-outbound'),
  z.literal('authy-monthly-fees'),
  z.literal('authy-phone-intelligence'),
  z.literal('authy-phone-verifications'),
  z.literal('authy-sms-outbound'),
  z.literal('call-progess-events'),
  z.literal('calleridlookups'),
  z.literal('calls'),
  z.literal('calls-client'),
  z.literal('calls-globalconference'),
  z.literal('calls-inbound'),
  z.literal('calls-inbound-local'),
  z.literal('calls-inbound-mobile'),
  z.literal('calls-inbound-tollfree'),
  z.literal('calls-outbound'),
  z.literal('calls-pay-verb-transactions'),
  z.literal('calls-recordings'),
  z.literal('calls-sip'),
  z.literal('calls-sip-inbound'),
  z.literal('calls-sip-outbound'),
  z.literal('calls-transfers'),
  z.literal('carrier-lookups'),
  z.literal('conversations'),
  z.literal('conversations-api-requests'),
  z.literal('conversations-conversation-events'),
  z.literal('conversations-endpoint-connectivity'),
  z.literal('conversations-events'),
  z.literal('conversations-participant-events'),
  z.literal('conversations-participants'),
  z.literal('cps'),
  z.literal('flex-usage'),
  z.literal('fraud-lookups'),
  z.literal('group-rooms'),
  z.literal('group-rooms-data-track'),
  z.literal('group-rooms-encrypted-media-recorded'),
  z.literal('group-rooms-media-downloaded'),
  z.literal('group-rooms-media-recorded'),
  z.literal('group-rooms-media-routed'),
  z.literal('group-rooms-media-stored'),
  z.literal('group-rooms-participant-minutes'),
  z.literal('group-rooms-recorded-minutes'),
  z.literal('imp-v1-usage'),
  z.literal('lookups'),
  z.literal('marketplace'),
  z.literal('marketplace-algorithmia-named-entity-recognition'),
  z.literal('marketplace-cadence-transcription'),
  z.literal('marketplace-cadence-translation'),
  z.literal('marketplace-capio-speech-to-text'),
  z.literal('marketplace-convriza-ababa'),
  z.literal('marketplace-deepgram-phrase-detector'),
  z.literal('marketplace-digital-segment-business-info'),
  z.literal('marketplace-facebook-offline-conversions'),
  z.literal('marketplace-google-speech-to-text'),
  z.literal('marketplace-ibm-watson-message-insights'),
  z.literal('marketplace-ibm-watson-message-sentiment'),
  z.literal('marketplace-ibm-watson-recording-analysis'),
  z.literal('marketplace-ibm-watson-tone-analyzer'),
  z.literal('marketplace-icehook-systems-scout'),
  z.literal('marketplace-infogroup-dataaxle-bizinfo'),
  z.literal('marketplace-keen-io-contact-center-analytics'),
  z.literal('marketplace-marchex-cleancall'),
  z.literal('marketplace-marchex-sentiment-analysis-for-sms'),
  z.literal('marketplace-marketplace-nextcaller-social-id'),
  z.literal('marketplace-mobile-commons-opt-out-classifier'),
  z.literal('marketplace-nexiwave-voicemail-to-text'),
  z.literal('marketplace-nextcaller-advanced-caller-identification'),
  z.literal('marketplace-nomorobo-spam-score'),
  z.literal('marketplace-payfone-tcpa-compliance'),
  z.literal('marketplace-remeeting-automatic-speech-recognition'),
  z.literal('marketplace-tcpa-defense-solutions-blacklist-feed'),
  z.literal('marketplace-telo-opencnam'),
  z.literal('marketplace-truecnam-true-spam'),
  z.literal('marketplace-twilio-caller-name-lookup-us'),
  z.literal('marketplace-twilio-carrier-information-lookup'),
  z.literal('marketplace-voicebase-pci'),
  z.literal('marketplace-voicebase-transcription'),
  z.literal('marketplace-voicebase-transcription-custom-vocabulary'),
  z.literal('marketplace-whitepages-pro-caller-identification'),
  z.literal('marketplace-whitepages-pro-phone-intelligence'),
  z.literal('marketplace-whitepages-pro-phone-reputation'),
  z.literal('marketplace-wolfarm-spoken-results'),
  z.literal('marketplace-wolfram-short-answer'),
  z.literal('marketplace-ytica-contact-center-reporting-analytics'),
  z.literal('mediastorage'),
  z.literal('mms'),
  z.literal('mms-inbound'),
  z.literal('mms-inbound-longcode'),
  z.literal('mms-inbound-shortcode'),
  z.literal('mms-messages-carrierfees'),
  z.literal('mms-outbound'),
  z.literal('mms-outbound-longcode'),
  z.literal('mms-outbound-shortcode'),
  z.literal('monitor-reads'),
  z.literal('monitor-storage'),
  z.literal('monitor-writes'),
  z.literal('notify'),
  z.literal('notify-actions-attempts'),
  z.literal('notify-channels'),
  z.literal('number-format-lookups'),
  z.literal('pchat'),
  z.literal('pchat-users'),
  z.literal('peer-to-peer-rooms-participant-minutes'),
  z.literal('pfax'),
  z.literal('pfax-minutes'),
  z.literal('pfax-minutes-inbound'),
  z.literal('pfax-minutes-outbound'),
  z.literal('pfax-pages'),
  z.literal('phonenumbers'),
  z.literal('phonenumbers-cps'),
  z.literal('phonenumbers-emergency'),
  z.literal('phonenumbers-local'),
  z.literal('phonenumbers-mobile'),
  z.literal('phonenumbers-setups'),
  z.literal('phonenumbers-tollfree'),
  z.literal('premiumsupport'),
  z.literal('proxy'),
  z.literal('proxy-active-sessions'),
  z.literal('pstnconnectivity'),
  z.literal('pv'),
  z.literal('pv-composition-media-downloaded'),
  z.literal('pv-composition-media-encrypted'),
  z.literal('pv-composition-media-stored'),
  z.literal('pv-composition-minutes'),
  z.literal('pv-recording-compositions'),
  z.literal('pv-room-participants'),
  z.literal('pv-room-participants-au1'),
  z.literal('pv-room-participants-br1'),
  z.literal('pv-room-participants-ie1'),
  z.literal('pv-room-participants-jp1'),
  z.literal('pv-room-participants-sg1'),
  z.literal('pv-room-participants-us1'),
  z.literal('pv-room-participants-us2'),
  z.literal('pv-rooms'),
  z.literal('pv-sip-endpoint-registrations'),
  z.literal('recordings'),
  z.literal('recordingstorage'),
  z.literal('rooms-group-bandwidth'),
  z.literal('rooms-group-minutes'),
  z.literal('rooms-peer-to-peer-minutes'),
  z.literal('shortcodes'),
  z.literal('shortcodes-customerowned'),
  z.literal('shortcodes-mms-enablement'),
  z.literal('shortcodes-mps'),
  z.literal('shortcodes-random'),
  z.literal('shortcodes-uk'),
  z.literal('shortcodes-vanity'),
  z.literal('small-group-rooms'),
  z.literal('small-group-rooms-data-track'),
  z.literal('small-group-rooms-participant-minutes'),
  z.literal('sms'),
  z.literal('sms-inbound'),
  z.literal('sms-inbound-longcode'),
  z.literal('sms-inbound-shortcode'),
  z.literal('sms-messages-carrierfees'),
  z.literal('sms-messages-features'),
  z.literal('sms-messages-features-senderid'),
  z.literal('sms-outbound'),
  z.literal('sms-outbound-content-inspection'),
  z.literal('sms-outbound-longcode'),
  z.literal('sms-outbound-shortcode'),
  z.literal('speech-recognition'),
  z.literal('studio-engagements'),
  z.literal('sync'),
  z.literal('sync-actions'),
  z.literal('sync-endpoint-hours'),
  z.literal('sync-endpoint-hours-above-daily-cap'),
  z.literal('taskrouter-tasks'),
  z.literal('totalprice'),
  z.literal('transcriptions'),
  z.literal('trunking-cps'),
  z.literal('trunking-emergency-calls'),
  z.literal('trunking-origination'),
  z.literal('trunking-origination-local'),
  z.literal('trunking-origination-mobile'),
  z.literal('trunking-origination-tollfree'),
  z.literal('trunking-recordings'),
  z.literal('trunking-secure'),
  z.literal('trunking-termination'),
  z.literal('tts-google'),
  z.literal('turnmegabytes'),
  z.literal('turnmegabytes-australia'),
  z.literal('turnmegabytes-brasil'),
  z.literal('turnmegabytes-germany'),
  z.literal('turnmegabytes-india'),
  z.literal('turnmegabytes-ireland'),
  z.literal('turnmegabytes-japan'),
  z.literal('turnmegabytes-singapore'),
  z.literal('turnmegabytes-useast'),
  z.literal('turnmegabytes-uswest'),
  z.literal('twilio-interconnect'),
  z.literal('verify-push'),
  z.literal('verify-totp'),
  z.literal('verify-whatsapp-conversations-business-initiated'),
  z.literal('video-recordings'),
  z.literal('virtual-agent'),
  z.literal('voice-insights'),
  z.literal('voice-insights-client-insights-on-demand-minute'),
  z.literal('voice-insights-ptsn-insights-on-demand-minute'),
  z.literal('voice-insights-sip-interface-insights-on-demand-minute'),
  z.literal('voice-insights-sip-trunking-insights-on-demand-minute'),
  z.literal('voice-intelligence'),
  z.literal('voice-intelligence-transcription'),
  z.literal('voice-intelligence-operators'),
  z.literal('wireless'),
  z.literal('wireless-orders'),
  z.literal('wireless-orders-artwork'),
  z.literal('wireless-orders-bulk'),
  z.literal('wireless-orders-esim'),
  z.literal('wireless-orders-starter'),
  z.literal('wireless-usage'),
  z.literal('wireless-usage-commands'),
  z.literal('wireless-usage-commands-africa'),
  z.literal('wireless-usage-commands-asia'),
  z.literal('wireless-usage-commands-centralandsouthamerica'),
  z.literal('wireless-usage-commands-europe'),
  z.literal('wireless-usage-commands-home'),
  z.literal('wireless-usage-commands-northamerica'),
  z.literal('wireless-usage-commands-oceania'),
  z.literal('wireless-usage-commands-roaming'),
  z.literal('wireless-usage-data'),
  z.literal('wireless-usage-data-africa'),
  z.literal('wireless-usage-data-asia'),
  z.literal('wireless-usage-data-centralandsouthamerica'),
  z.literal('wireless-usage-data-custom-additionalmb'),
  z.literal('wireless-usage-data-custom-first5mb'),
  z.literal('wireless-usage-data-domestic-roaming'),
  z.literal('wireless-usage-data-europe'),
  z.literal('wireless-usage-data-individual-additionalgb'),
  z.literal('wireless-usage-data-individual-firstgb'),
  z.literal('wireless-usage-data-international-roaming-canada'),
  z.literal('wireless-usage-data-international-roaming-india'),
  z.literal('wireless-usage-data-international-roaming-mexico'),
  z.literal('wireless-usage-data-northamerica'),
  z.literal('wireless-usage-data-oceania'),
  z.literal('wireless-usage-data-pooled'),
  z.literal('wireless-usage-data-pooled-downlink'),
  z.literal('wireless-usage-data-pooled-uplink'),
  z.literal('wireless-usage-mrc'),
  z.literal('wireless-usage-mrc-custom'),
  z.literal('wireless-usage-mrc-individual'),
  z.literal('wireless-usage-mrc-pooled'),
  z.literal('wireless-usage-mrc-suspended'),
  z.literal('wireless-usage-sms'),
  z.literal('wireless-usage-voice'),
]);

export const callbackMethodSchema = z.union([
  z.literal('HEAD'),
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PATCH'),
  z.literal('PUT'),
  z.literal('DELETE'),
]);

export const apiV2010AccountValidationRequestSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  validation_code: z.string().optional().nullable(),
});

export const callEnumEventSchema = z.union([
  z.literal('initiated'),
  z.literal('ringing'),
  z.literal('answered'),
  z.literal('completed'),
]);

export const callEnumUpdateStatusSchema = z.union([z.literal('canceled'), z.literal('completed')]);

export const conferenceEnumUpdateStatusSchema = z.literal('completed');

export const messageEnumAddressRetentionSchema = z.union([z.literal('retain'), z.literal('obfuscate')]);

export const messageEnumContentRetentionSchema = z.union([z.literal('retain'), z.literal('discard')]);

export const messageEnumRiskCheckSchema = z.union([z.literal('enable'), z.literal('disable')]);

export const messageEnumScheduleTypeSchema = z.literal('fixed');

export const messageEnumTrafficTypeSchema = z.literal('free');

export const messageEnumUpdateStatusSchema = z.literal('canceled');

export const paymentsEnumBankAccountTypeSchema = z.union([
  z.literal('consumer-checking'),
  z.literal('consumer-savings'),
  z.literal('commercial-checking'),
]);

export const paymentsEnumCaptureSchema = z.union([
  z.literal('payment-card-number'),
  z.literal('expiration-date'),
  z.literal('security-code'),
  z.literal('postal-code'),
  z.literal('bank-routing-number'),
  z.literal('bank-account-number'),
]);

export const paymentsEnumPaymentMethodSchema = z.union([z.literal('credit-card'), z.literal('ach-debit')]);

export const paymentsEnumStatusSchema = z.union([z.literal('complete'), z.literal('cancel')]);

export const paymentsEnumTokenTypeSchema = z.union([z.literal('one-time'), z.literal('reusable')]);

export const siprecEnumTrackSchema = z.union([
  z.literal('inbound_track'),
  z.literal('outbound_track'),
  z.literal('both_tracks'),
]);

export const siprecEnumUpdateStatusSchema = z.literal('stopped');

export const streamEnumTrackSchema = z.union([
  z.literal('inbound_track'),
  z.literal('outbound_track'),
  z.literal('both_tracks'),
]);

export const streamEnumUpdateStatusSchema = z.literal('stopped');

export const listAccountDataSchema = z.object({
  query: z
    .object({
      FriendlyName: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      Status: accountEnumStatusSchema.optional(),
    })
    .optional(),
});

export const listAccountResponseSchema = z.object({
  accounts: z.array(apiV2010AccountSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAccountErrorSchema = z.unknown();

export const createAccountDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
});

export const createAccountResponseSchema = apiV2010AccountSchema;

export const createAccountErrorSchema = z.unknown();

export const listAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      CustomerName: z.string().optional(),
      FriendlyName: z.string().optional(),
      IsoCountry: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listAddressResponseSchema = z.object({
  addresses: z.array(apiV2010AccountAddressSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAddressErrorSchema = z.unknown();

export const createAddressDataSchema = z.object({
  body: z
    .object({
      AutoCorrectAddress: z.boolean().optional(),
      City: z.string(),
      CustomerName: z.string(),
      EmergencyEnabled: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      IsoCountry: z.string(),
      PostalCode: z.string(),
      Region: z.string(),
      Street: z.string(),
      StreetSecondary: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createAddressResponseSchema = apiV2010AccountAddressSchema;

export const createAddressErrorSchema = z.unknown();

export const listDependentPhoneNumberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AddressSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountAddressDependentPhoneNumberSchema = z.object({
  account_sid: z.string().optional().nullable(),
  address_requirements: dependentPhoneNumberEnumAddressRequirementSchema.optional().nullable(),
  api_version: z.string().optional().nullable(),
  capabilities: z.unknown().optional(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_address_sid: z.string().optional().nullable(),
  emergency_status: dependentPhoneNumberEnumEmergencyStatusSchema.optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_application_sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_application_sid: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_url: z.string().optional().nullable(),
});

export const listDependentPhoneNumberErrorSchema = z.unknown();

export const deleteAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteAddressResponseSchema = z.any();

export const deleteAddressErrorSchema = z.unknown();

export const fetchAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchAddressResponseSchema = apiV2010AccountAddressSchema;

export const fetchAddressErrorSchema = z.unknown();

export const updateAddressDataSchema = z.object({
  body: z
    .object({
      AutoCorrectAddress: z.boolean().optional(),
      City: z.string().optional(),
      CustomerName: z.string().optional(),
      EmergencyEnabled: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      PostalCode: z.string().optional(),
      Region: z.string().optional(),
      Street: z.string().optional(),
      StreetSecondary: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateAddressResponseSchema = apiV2010AccountAddressSchema;

export const updateAddressErrorSchema = z.unknown();

export const listApplicationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      FriendlyName: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listApplicationResponseSchema = z.object({
  applications: z.array(apiV2010AccountApplicationSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listApplicationErrorSchema = z.unknown();

export const createApplicationDataSchema = z.object({
  body: z
    .object({
      ApiVersion: z.string().optional(),
      FriendlyName: z.string().optional(),
      MessageStatusCallback: z.string().optional(),
      PublicApplicationConnectEnabled: z.boolean().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsStatusCallback: z.string().optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createApplicationResponseSchema = apiV2010AccountApplicationSchema;

export const createApplicationErrorSchema = z.unknown();

export const deleteApplicationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteApplicationResponseSchema = z.any();

export const deleteApplicationErrorSchema = z.unknown();

export const fetchApplicationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchApplicationResponseSchema = apiV2010AccountApplicationSchema;

export const fetchApplicationErrorSchema = z.unknown();

export const updateApplicationDataSchema = z.object({
  body: z
    .object({
      ApiVersion: z.string().optional(),
      FriendlyName: z.string().optional(),
      MessageStatusCallback: z.string().optional(),
      PublicApplicationConnectEnabled: z.boolean().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsStatusCallback: z.string().optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateApplicationResponseSchema = apiV2010AccountApplicationSchema;

export const updateApplicationErrorSchema = z.unknown();

export const listAuthorizedConnectAppDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountAuthorizedConnectAppSchema = z.object({
  account_sid: z.string().optional().nullable(),
  connect_app_company_name: z.string().optional().nullable(),
  connect_app_description: z.string().optional().nullable(),
  connect_app_friendly_name: z.string().optional().nullable(),
  connect_app_homepage_url: z.string().optional().nullable(),
  connect_app_sid: z.string().optional().nullable(),
  permissions: z.array(authorizedConnectAppEnumPermissionSchema).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listAuthorizedConnectAppErrorSchema = z.unknown();

export const fetchAuthorizedConnectAppDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ConnectAppSid: z.string(),
  }),
});

export const fetchAuthorizedConnectAppResponseSchema = apiV2010AccountAuthorizedConnectAppSchema;

export const fetchAuthorizedConnectAppErrorSchema = z.unknown();

export const listAvailablePhoneNumberCountryDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberCountryResponseSchema = z.object({
  countries: z.array(apiV2010AccountAvailablePhoneNumberCountrySchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberCountryErrorSchema = z.unknown();

export const fetchAvailablePhoneNumberCountryDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
});

export const fetchAvailablePhoneNumberCountryResponseSchema = apiV2010AccountAvailablePhoneNumberCountrySchema;

export const fetchAvailablePhoneNumberCountryErrorSchema = z.unknown();

export const listAvailablePhoneNumberLocalDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberLocalResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberLocalSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberLocalErrorSchema = z.unknown();

export const listAvailablePhoneNumberMachineToMachineDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberMachineToMachineResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberMachineToMachineSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberMachineToMachineErrorSchema = z.unknown();

export const listAvailablePhoneNumberMobileDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberMobileResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberMobileSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberMobileErrorSchema = z.unknown();

export const listAvailablePhoneNumberNationalDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberNationalResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberNationalSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberNationalErrorSchema = z.unknown();

export const listAvailablePhoneNumberSharedCostDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberSharedCostResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberSharedCostSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberSharedCostErrorSchema = z.unknown();

export const listAvailablePhoneNumberTollFreeDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberTollFreeResponseSchema = z.object({
  available_phone_numbers: z
    .array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberTollFreeSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberTollFreeErrorSchema = z.unknown();

export const listAvailablePhoneNumberVoipDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CountryCode: z.string(),
  }),
  query: z
    .object({
      AreaCode: z.number().optional(),
      Beta: z.boolean().optional(),
      Contains: z.string().optional(),
      Distance: z.number().optional(),
      ExcludeAllAddressRequired: z.boolean().optional(),
      ExcludeForeignAddressRequired: z.boolean().optional(),
      ExcludeLocalAddressRequired: z.boolean().optional(),
      FaxEnabled: z.boolean().optional(),
      InLata: z.string().optional(),
      InLocality: z.string().optional(),
      InPostalCode: z.string().optional(),
      InRateCenter: z.string().optional(),
      InRegion: z.string().optional(),
      MmsEnabled: z.boolean().optional(),
      NearLatLong: z.string().optional(),
      NearNumber: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      SmsEnabled: z.boolean().optional(),
      VoiceEnabled: z.boolean().optional(),
    })
    .optional(),
});

export const listAvailablePhoneNumberVoipResponseSchema = z.object({
  available_phone_numbers: z.array(apiV2010AccountAvailablePhoneNumberCountryAvailablePhoneNumberVoipSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAvailablePhoneNumberVoipErrorSchema = z.unknown();

export const fetchBalanceDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const fetchBalanceResponseSchema = apiV2010AccountBalanceSchema;

export const fetchBalanceErrorSchema = z.unknown();

export const listCallDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      EndTime: z.string().optional(),
      'EndTime<': z.string().optional(),
      'EndTime>': z.string().optional(),
      From: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      ParentCallSid: z.string().optional(),
      StartTime: z.string().optional(),
      'StartTime<': z.string().optional(),
      'StartTime>': z.string().optional(),
      Status: callEnumStatusSchema.optional(),
      To: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountCallSchema = z.object({
  account_sid: z.string().optional().nullable(),
  answered_by: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  caller_name: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  direction: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  end_time: z.string().optional().nullable(),
  forwarded_from: z.string().optional().nullable(),
  from: z.string().optional().nullable(),
  from_formatted: z.string().optional().nullable(),
  group_sid: z.string().optional().nullable(),
  parent_call_sid: z.string().optional().nullable(),
  phone_number_sid: z.string().optional().nullable(),
  price: z.string().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  queue_time: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  start_time: z.string().optional().nullable(),
  status: callEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  to: z.string().optional().nullable(),
  to_formatted: z.string().optional().nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listCallErrorSchema = z.unknown();

export const createCallDataSchema = z.object({
  body: z
    .object({
      ApplicationSid: z.string().optional(),
      AsyncAmd: z.string().optional(),
      AsyncAmdStatusCallback: z.string().optional(),
      AsyncAmdStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Byoc: z.string().optional(),
      CallReason: z.string().optional(),
      CallToken: z.string().optional(),
      CallerId: z.string().optional(),
      FallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      FallbackUrl: z.string().optional(),
      From: z.string(),
      MachineDetection: z.string().optional(),
      MachineDetectionSilenceTimeout: z.number().optional(),
      MachineDetectionSpeechEndThreshold: z.number().optional(),
      MachineDetectionSpeechThreshold: z.number().optional(),
      MachineDetectionTimeout: z.number().optional(),
      Method: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Record: z.boolean().optional(),
      RecordingChannels: z.string().optional(),
      RecordingStatusCallback: z.string().optional(),
      RecordingStatusCallbackEvent: z.array(z.string()).optional(),
      RecordingStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      RecordingTrack: z.string().optional(),
      SendDigits: z.string().optional(),
      SipAuthPassword: z.string().optional(),
      SipAuthUsername: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackEvent: z.array(z.string()).optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TimeLimit: z.number().optional(),
      Timeout: z.number().optional(),
      To: z.string(),
      Trim: z.string().optional(),
      Twiml: z.string().optional(),
      Url: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createCallResponseSchema = apiV2010AccountCallSchema;

export const createCallErrorSchema = z.unknown();

export const listCallEventDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listCallEventResponseSchema = z.object({
  end: z.number().optional(),
  events: z.array(apiV2010AccountCallCallEventSchema).optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listCallEventErrorSchema = z.unknown();

export const listCallNotificationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
  query: z
    .object({
      Log: z.number().optional(),
      MessageDate: z.string().optional(),
      'MessageDate<': z.string().optional(),
      'MessageDate>': z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listCallNotificationResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  notifications: z.array(apiV2010AccountCallCallNotificationSchema).optional(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listCallNotificationErrorSchema = z.unknown();

export const fetchCallNotificationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchCallNotificationResponseSchema = apiV2010AccountCallCallNotificationInstanceSchema;

export const fetchCallNotificationErrorSchema = z.unknown();

export const createPaymentsDataSchema = z.object({
  body: z
    .object({
      BankAccountType: paymentsEnumBankAccountTypeSchema.optional(),
      ChargeAmount: z.number().optional(),
      Currency: z.string().optional(),
      Description: z.string().optional(),
      IdempotencyKey: z.string(),
      Input: z.string().optional(),
      MinPostalCodeLength: z.number().optional(),
      Parameter: z.unknown().optional(),
      PaymentConnector: z.string().optional(),
      PaymentMethod: paymentsEnumPaymentMethodSchema.optional(),
      PostalCode: z.boolean().optional(),
      SecurityCode: z.boolean().optional(),
      StatusCallback: z.string(),
      Timeout: z.number().optional(),
      TokenType: paymentsEnumTokenTypeSchema.optional(),
      ValidCardTypes: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const createPaymentsResponseSchema = apiV2010AccountCallPaymentsSchema;

export const createPaymentsErrorSchema = z.unknown();

export const updatePaymentsDataSchema = z.object({
  body: z
    .object({
      Capture: paymentsEnumCaptureSchema.optional(),
      IdempotencyKey: z.string(),
      Status: paymentsEnumStatusSchema.optional(),
      StatusCallback: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const updatePaymentsResponseSchema = apiV2010AccountCallPaymentsSchema;

export const updatePaymentsErrorSchema = z.unknown();

export const listCallRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
  query: z
    .object({
      DateCreated: z.string().optional(),
      'DateCreated<': z.string().optional(),
      'DateCreated>': z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountCallCallRecordingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  channels: z.number().optional().nullable(),
  conference_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  encryption_details: z.unknown().optional(),
  error_code: z.number().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  source: callRecordingEnumSourceSchema.optional().nullable(),
  start_time: z.string().optional().nullable(),
  status: callRecordingEnumStatusSchema.optional().nullable(),
  track: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listCallRecordingErrorSchema = z.unknown();

export const createCallRecordingDataSchema = z.object({
  body: z
    .object({
      RecordingChannels: z.string().optional(),
      RecordingStatusCallback: z.string().optional(),
      RecordingStatusCallbackEvent: z.array(z.string()).optional(),
      RecordingStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      RecordingTrack: z.string().optional(),
      Trim: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const createCallRecordingResponseSchema = apiV2010AccountCallCallRecordingSchema;

export const createCallRecordingErrorSchema = z.unknown();

export const deleteCallRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteCallRecordingResponseSchema = z.any();

export const deleteCallRecordingErrorSchema = z.unknown();

export const fetchCallRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchCallRecordingResponseSchema = apiV2010AccountCallCallRecordingSchema;

export const fetchCallRecordingErrorSchema = z.unknown();

export const updateCallRecordingDataSchema = z.object({
  body: z
    .object({
      PauseBehavior: z.string().optional(),
      Status: callRecordingEnumStatusSchema,
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateCallRecordingResponseSchema = apiV2010AccountCallCallRecordingSchema;

export const updateCallRecordingErrorSchema = z.unknown();

export const createSiprecDataSchema = z.object({
  body: z
    .object({
      ConnectorName: z.string().optional(),
      Name: z.string().optional(),
      'Parameter1.Name': z.string().optional(),
      'Parameter1.Value': z.string().optional(),
      'Parameter10.Name': z.string().optional(),
      'Parameter10.Value': z.string().optional(),
      'Parameter11.Name': z.string().optional(),
      'Parameter11.Value': z.string().optional(),
      'Parameter12.Name': z.string().optional(),
      'Parameter12.Value': z.string().optional(),
      'Parameter13.Name': z.string().optional(),
      'Parameter13.Value': z.string().optional(),
      'Parameter14.Name': z.string().optional(),
      'Parameter14.Value': z.string().optional(),
      'Parameter15.Name': z.string().optional(),
      'Parameter15.Value': z.string().optional(),
      'Parameter16.Name': z.string().optional(),
      'Parameter16.Value': z.string().optional(),
      'Parameter17.Name': z.string().optional(),
      'Parameter17.Value': z.string().optional(),
      'Parameter18.Name': z.string().optional(),
      'Parameter18.Value': z.string().optional(),
      'Parameter19.Name': z.string().optional(),
      'Parameter19.Value': z.string().optional(),
      'Parameter2.Name': z.string().optional(),
      'Parameter2.Value': z.string().optional(),
      'Parameter20.Name': z.string().optional(),
      'Parameter20.Value': z.string().optional(),
      'Parameter21.Name': z.string().optional(),
      'Parameter21.Value': z.string().optional(),
      'Parameter22.Name': z.string().optional(),
      'Parameter22.Value': z.string().optional(),
      'Parameter23.Name': z.string().optional(),
      'Parameter23.Value': z.string().optional(),
      'Parameter24.Name': z.string().optional(),
      'Parameter24.Value': z.string().optional(),
      'Parameter25.Name': z.string().optional(),
      'Parameter25.Value': z.string().optional(),
      'Parameter26.Name': z.string().optional(),
      'Parameter26.Value': z.string().optional(),
      'Parameter27.Name': z.string().optional(),
      'Parameter27.Value': z.string().optional(),
      'Parameter28.Name': z.string().optional(),
      'Parameter28.Value': z.string().optional(),
      'Parameter29.Name': z.string().optional(),
      'Parameter29.Value': z.string().optional(),
      'Parameter3.Name': z.string().optional(),
      'Parameter3.Value': z.string().optional(),
      'Parameter30.Name': z.string().optional(),
      'Parameter30.Value': z.string().optional(),
      'Parameter31.Name': z.string().optional(),
      'Parameter31.Value': z.string().optional(),
      'Parameter32.Name': z.string().optional(),
      'Parameter32.Value': z.string().optional(),
      'Parameter33.Name': z.string().optional(),
      'Parameter33.Value': z.string().optional(),
      'Parameter34.Name': z.string().optional(),
      'Parameter34.Value': z.string().optional(),
      'Parameter35.Name': z.string().optional(),
      'Parameter35.Value': z.string().optional(),
      'Parameter36.Name': z.string().optional(),
      'Parameter36.Value': z.string().optional(),
      'Parameter37.Name': z.string().optional(),
      'Parameter37.Value': z.string().optional(),
      'Parameter38.Name': z.string().optional(),
      'Parameter38.Value': z.string().optional(),
      'Parameter39.Name': z.string().optional(),
      'Parameter39.Value': z.string().optional(),
      'Parameter4.Name': z.string().optional(),
      'Parameter4.Value': z.string().optional(),
      'Parameter40.Name': z.string().optional(),
      'Parameter40.Value': z.string().optional(),
      'Parameter41.Name': z.string().optional(),
      'Parameter41.Value': z.string().optional(),
      'Parameter42.Name': z.string().optional(),
      'Parameter42.Value': z.string().optional(),
      'Parameter43.Name': z.string().optional(),
      'Parameter43.Value': z.string().optional(),
      'Parameter44.Name': z.string().optional(),
      'Parameter44.Value': z.string().optional(),
      'Parameter45.Name': z.string().optional(),
      'Parameter45.Value': z.string().optional(),
      'Parameter46.Name': z.string().optional(),
      'Parameter46.Value': z.string().optional(),
      'Parameter47.Name': z.string().optional(),
      'Parameter47.Value': z.string().optional(),
      'Parameter48.Name': z.string().optional(),
      'Parameter48.Value': z.string().optional(),
      'Parameter49.Name': z.string().optional(),
      'Parameter49.Value': z.string().optional(),
      'Parameter5.Name': z.string().optional(),
      'Parameter5.Value': z.string().optional(),
      'Parameter50.Name': z.string().optional(),
      'Parameter50.Value': z.string().optional(),
      'Parameter51.Name': z.string().optional(),
      'Parameter51.Value': z.string().optional(),
      'Parameter52.Name': z.string().optional(),
      'Parameter52.Value': z.string().optional(),
      'Parameter53.Name': z.string().optional(),
      'Parameter53.Value': z.string().optional(),
      'Parameter54.Name': z.string().optional(),
      'Parameter54.Value': z.string().optional(),
      'Parameter55.Name': z.string().optional(),
      'Parameter55.Value': z.string().optional(),
      'Parameter56.Name': z.string().optional(),
      'Parameter56.Value': z.string().optional(),
      'Parameter57.Name': z.string().optional(),
      'Parameter57.Value': z.string().optional(),
      'Parameter58.Name': z.string().optional(),
      'Parameter58.Value': z.string().optional(),
      'Parameter59.Name': z.string().optional(),
      'Parameter59.Value': z.string().optional(),
      'Parameter6.Name': z.string().optional(),
      'Parameter6.Value': z.string().optional(),
      'Parameter60.Name': z.string().optional(),
      'Parameter60.Value': z.string().optional(),
      'Parameter61.Name': z.string().optional(),
      'Parameter61.Value': z.string().optional(),
      'Parameter62.Name': z.string().optional(),
      'Parameter62.Value': z.string().optional(),
      'Parameter63.Name': z.string().optional(),
      'Parameter63.Value': z.string().optional(),
      'Parameter64.Name': z.string().optional(),
      'Parameter64.Value': z.string().optional(),
      'Parameter65.Name': z.string().optional(),
      'Parameter65.Value': z.string().optional(),
      'Parameter66.Name': z.string().optional(),
      'Parameter66.Value': z.string().optional(),
      'Parameter67.Name': z.string().optional(),
      'Parameter67.Value': z.string().optional(),
      'Parameter68.Name': z.string().optional(),
      'Parameter68.Value': z.string().optional(),
      'Parameter69.Name': z.string().optional(),
      'Parameter69.Value': z.string().optional(),
      'Parameter7.Name': z.string().optional(),
      'Parameter7.Value': z.string().optional(),
      'Parameter70.Name': z.string().optional(),
      'Parameter70.Value': z.string().optional(),
      'Parameter71.Name': z.string().optional(),
      'Parameter71.Value': z.string().optional(),
      'Parameter72.Name': z.string().optional(),
      'Parameter72.Value': z.string().optional(),
      'Parameter73.Name': z.string().optional(),
      'Parameter73.Value': z.string().optional(),
      'Parameter74.Name': z.string().optional(),
      'Parameter74.Value': z.string().optional(),
      'Parameter75.Name': z.string().optional(),
      'Parameter75.Value': z.string().optional(),
      'Parameter76.Name': z.string().optional(),
      'Parameter76.Value': z.string().optional(),
      'Parameter77.Name': z.string().optional(),
      'Parameter77.Value': z.string().optional(),
      'Parameter78.Name': z.string().optional(),
      'Parameter78.Value': z.string().optional(),
      'Parameter79.Name': z.string().optional(),
      'Parameter79.Value': z.string().optional(),
      'Parameter8.Name': z.string().optional(),
      'Parameter8.Value': z.string().optional(),
      'Parameter80.Name': z.string().optional(),
      'Parameter80.Value': z.string().optional(),
      'Parameter81.Name': z.string().optional(),
      'Parameter81.Value': z.string().optional(),
      'Parameter82.Name': z.string().optional(),
      'Parameter82.Value': z.string().optional(),
      'Parameter83.Name': z.string().optional(),
      'Parameter83.Value': z.string().optional(),
      'Parameter84.Name': z.string().optional(),
      'Parameter84.Value': z.string().optional(),
      'Parameter85.Name': z.string().optional(),
      'Parameter85.Value': z.string().optional(),
      'Parameter86.Name': z.string().optional(),
      'Parameter86.Value': z.string().optional(),
      'Parameter87.Name': z.string().optional(),
      'Parameter87.Value': z.string().optional(),
      'Parameter88.Name': z.string().optional(),
      'Parameter88.Value': z.string().optional(),
      'Parameter89.Name': z.string().optional(),
      'Parameter89.Value': z.string().optional(),
      'Parameter9.Name': z.string().optional(),
      'Parameter9.Value': z.string().optional(),
      'Parameter90.Name': z.string().optional(),
      'Parameter90.Value': z.string().optional(),
      'Parameter91.Name': z.string().optional(),
      'Parameter91.Value': z.string().optional(),
      'Parameter92.Name': z.string().optional(),
      'Parameter92.Value': z.string().optional(),
      'Parameter93.Name': z.string().optional(),
      'Parameter93.Value': z.string().optional(),
      'Parameter94.Name': z.string().optional(),
      'Parameter94.Value': z.string().optional(),
      'Parameter95.Name': z.string().optional(),
      'Parameter95.Value': z.string().optional(),
      'Parameter96.Name': z.string().optional(),
      'Parameter96.Value': z.string().optional(),
      'Parameter97.Name': z.string().optional(),
      'Parameter97.Value': z.string().optional(),
      'Parameter98.Name': z.string().optional(),
      'Parameter98.Value': z.string().optional(),
      'Parameter99.Name': z.string().optional(),
      'Parameter99.Value': z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Track: siprecEnumTrackSchema.optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const apiV2010AccountCallSiprecSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: siprecEnumStatusSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const createSiprecErrorSchema = z.unknown();

export const updateSiprecDataSchema = z.object({
  body: z
    .object({
      Status: siprecEnumUpdateStatusSchema,
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSiprecResponseSchema = apiV2010AccountCallSiprecSchema;

export const updateSiprecErrorSchema = z.unknown();

export const createStreamDataSchema = z.object({
  body: z
    .object({
      Name: z.string().optional(),
      'Parameter1.Name': z.string().optional(),
      'Parameter1.Value': z.string().optional(),
      'Parameter10.Name': z.string().optional(),
      'Parameter10.Value': z.string().optional(),
      'Parameter11.Name': z.string().optional(),
      'Parameter11.Value': z.string().optional(),
      'Parameter12.Name': z.string().optional(),
      'Parameter12.Value': z.string().optional(),
      'Parameter13.Name': z.string().optional(),
      'Parameter13.Value': z.string().optional(),
      'Parameter14.Name': z.string().optional(),
      'Parameter14.Value': z.string().optional(),
      'Parameter15.Name': z.string().optional(),
      'Parameter15.Value': z.string().optional(),
      'Parameter16.Name': z.string().optional(),
      'Parameter16.Value': z.string().optional(),
      'Parameter17.Name': z.string().optional(),
      'Parameter17.Value': z.string().optional(),
      'Parameter18.Name': z.string().optional(),
      'Parameter18.Value': z.string().optional(),
      'Parameter19.Name': z.string().optional(),
      'Parameter19.Value': z.string().optional(),
      'Parameter2.Name': z.string().optional(),
      'Parameter2.Value': z.string().optional(),
      'Parameter20.Name': z.string().optional(),
      'Parameter20.Value': z.string().optional(),
      'Parameter21.Name': z.string().optional(),
      'Parameter21.Value': z.string().optional(),
      'Parameter22.Name': z.string().optional(),
      'Parameter22.Value': z.string().optional(),
      'Parameter23.Name': z.string().optional(),
      'Parameter23.Value': z.string().optional(),
      'Parameter24.Name': z.string().optional(),
      'Parameter24.Value': z.string().optional(),
      'Parameter25.Name': z.string().optional(),
      'Parameter25.Value': z.string().optional(),
      'Parameter26.Name': z.string().optional(),
      'Parameter26.Value': z.string().optional(),
      'Parameter27.Name': z.string().optional(),
      'Parameter27.Value': z.string().optional(),
      'Parameter28.Name': z.string().optional(),
      'Parameter28.Value': z.string().optional(),
      'Parameter29.Name': z.string().optional(),
      'Parameter29.Value': z.string().optional(),
      'Parameter3.Name': z.string().optional(),
      'Parameter3.Value': z.string().optional(),
      'Parameter30.Name': z.string().optional(),
      'Parameter30.Value': z.string().optional(),
      'Parameter31.Name': z.string().optional(),
      'Parameter31.Value': z.string().optional(),
      'Parameter32.Name': z.string().optional(),
      'Parameter32.Value': z.string().optional(),
      'Parameter33.Name': z.string().optional(),
      'Parameter33.Value': z.string().optional(),
      'Parameter34.Name': z.string().optional(),
      'Parameter34.Value': z.string().optional(),
      'Parameter35.Name': z.string().optional(),
      'Parameter35.Value': z.string().optional(),
      'Parameter36.Name': z.string().optional(),
      'Parameter36.Value': z.string().optional(),
      'Parameter37.Name': z.string().optional(),
      'Parameter37.Value': z.string().optional(),
      'Parameter38.Name': z.string().optional(),
      'Parameter38.Value': z.string().optional(),
      'Parameter39.Name': z.string().optional(),
      'Parameter39.Value': z.string().optional(),
      'Parameter4.Name': z.string().optional(),
      'Parameter4.Value': z.string().optional(),
      'Parameter40.Name': z.string().optional(),
      'Parameter40.Value': z.string().optional(),
      'Parameter41.Name': z.string().optional(),
      'Parameter41.Value': z.string().optional(),
      'Parameter42.Name': z.string().optional(),
      'Parameter42.Value': z.string().optional(),
      'Parameter43.Name': z.string().optional(),
      'Parameter43.Value': z.string().optional(),
      'Parameter44.Name': z.string().optional(),
      'Parameter44.Value': z.string().optional(),
      'Parameter45.Name': z.string().optional(),
      'Parameter45.Value': z.string().optional(),
      'Parameter46.Name': z.string().optional(),
      'Parameter46.Value': z.string().optional(),
      'Parameter47.Name': z.string().optional(),
      'Parameter47.Value': z.string().optional(),
      'Parameter48.Name': z.string().optional(),
      'Parameter48.Value': z.string().optional(),
      'Parameter49.Name': z.string().optional(),
      'Parameter49.Value': z.string().optional(),
      'Parameter5.Name': z.string().optional(),
      'Parameter5.Value': z.string().optional(),
      'Parameter50.Name': z.string().optional(),
      'Parameter50.Value': z.string().optional(),
      'Parameter51.Name': z.string().optional(),
      'Parameter51.Value': z.string().optional(),
      'Parameter52.Name': z.string().optional(),
      'Parameter52.Value': z.string().optional(),
      'Parameter53.Name': z.string().optional(),
      'Parameter53.Value': z.string().optional(),
      'Parameter54.Name': z.string().optional(),
      'Parameter54.Value': z.string().optional(),
      'Parameter55.Name': z.string().optional(),
      'Parameter55.Value': z.string().optional(),
      'Parameter56.Name': z.string().optional(),
      'Parameter56.Value': z.string().optional(),
      'Parameter57.Name': z.string().optional(),
      'Parameter57.Value': z.string().optional(),
      'Parameter58.Name': z.string().optional(),
      'Parameter58.Value': z.string().optional(),
      'Parameter59.Name': z.string().optional(),
      'Parameter59.Value': z.string().optional(),
      'Parameter6.Name': z.string().optional(),
      'Parameter6.Value': z.string().optional(),
      'Parameter60.Name': z.string().optional(),
      'Parameter60.Value': z.string().optional(),
      'Parameter61.Name': z.string().optional(),
      'Parameter61.Value': z.string().optional(),
      'Parameter62.Name': z.string().optional(),
      'Parameter62.Value': z.string().optional(),
      'Parameter63.Name': z.string().optional(),
      'Parameter63.Value': z.string().optional(),
      'Parameter64.Name': z.string().optional(),
      'Parameter64.Value': z.string().optional(),
      'Parameter65.Name': z.string().optional(),
      'Parameter65.Value': z.string().optional(),
      'Parameter66.Name': z.string().optional(),
      'Parameter66.Value': z.string().optional(),
      'Parameter67.Name': z.string().optional(),
      'Parameter67.Value': z.string().optional(),
      'Parameter68.Name': z.string().optional(),
      'Parameter68.Value': z.string().optional(),
      'Parameter69.Name': z.string().optional(),
      'Parameter69.Value': z.string().optional(),
      'Parameter7.Name': z.string().optional(),
      'Parameter7.Value': z.string().optional(),
      'Parameter70.Name': z.string().optional(),
      'Parameter70.Value': z.string().optional(),
      'Parameter71.Name': z.string().optional(),
      'Parameter71.Value': z.string().optional(),
      'Parameter72.Name': z.string().optional(),
      'Parameter72.Value': z.string().optional(),
      'Parameter73.Name': z.string().optional(),
      'Parameter73.Value': z.string().optional(),
      'Parameter74.Name': z.string().optional(),
      'Parameter74.Value': z.string().optional(),
      'Parameter75.Name': z.string().optional(),
      'Parameter75.Value': z.string().optional(),
      'Parameter76.Name': z.string().optional(),
      'Parameter76.Value': z.string().optional(),
      'Parameter77.Name': z.string().optional(),
      'Parameter77.Value': z.string().optional(),
      'Parameter78.Name': z.string().optional(),
      'Parameter78.Value': z.string().optional(),
      'Parameter79.Name': z.string().optional(),
      'Parameter79.Value': z.string().optional(),
      'Parameter8.Name': z.string().optional(),
      'Parameter8.Value': z.string().optional(),
      'Parameter80.Name': z.string().optional(),
      'Parameter80.Value': z.string().optional(),
      'Parameter81.Name': z.string().optional(),
      'Parameter81.Value': z.string().optional(),
      'Parameter82.Name': z.string().optional(),
      'Parameter82.Value': z.string().optional(),
      'Parameter83.Name': z.string().optional(),
      'Parameter83.Value': z.string().optional(),
      'Parameter84.Name': z.string().optional(),
      'Parameter84.Value': z.string().optional(),
      'Parameter85.Name': z.string().optional(),
      'Parameter85.Value': z.string().optional(),
      'Parameter86.Name': z.string().optional(),
      'Parameter86.Value': z.string().optional(),
      'Parameter87.Name': z.string().optional(),
      'Parameter87.Value': z.string().optional(),
      'Parameter88.Name': z.string().optional(),
      'Parameter88.Value': z.string().optional(),
      'Parameter89.Name': z.string().optional(),
      'Parameter89.Value': z.string().optional(),
      'Parameter9.Name': z.string().optional(),
      'Parameter9.Value': z.string().optional(),
      'Parameter90.Name': z.string().optional(),
      'Parameter90.Value': z.string().optional(),
      'Parameter91.Name': z.string().optional(),
      'Parameter91.Value': z.string().optional(),
      'Parameter92.Name': z.string().optional(),
      'Parameter92.Value': z.string().optional(),
      'Parameter93.Name': z.string().optional(),
      'Parameter93.Value': z.string().optional(),
      'Parameter94.Name': z.string().optional(),
      'Parameter94.Value': z.string().optional(),
      'Parameter95.Name': z.string().optional(),
      'Parameter95.Value': z.string().optional(),
      'Parameter96.Name': z.string().optional(),
      'Parameter96.Value': z.string().optional(),
      'Parameter97.Name': z.string().optional(),
      'Parameter97.Value': z.string().optional(),
      'Parameter98.Name': z.string().optional(),
      'Parameter98.Value': z.string().optional(),
      'Parameter99.Name': z.string().optional(),
      'Parameter99.Value': z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Track: streamEnumTrackSchema.optional(),
      Url: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const apiV2010AccountCallStreamSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  name: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: streamEnumStatusSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const createStreamErrorSchema = z.unknown();

export const updateStreamDataSchema = z.object({
  body: z
    .object({
      Status: streamEnumUpdateStatusSchema,
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateStreamResponseSchema = apiV2010AccountCallStreamSchema;

export const updateStreamErrorSchema = z.unknown();

export const createUserDefinedMessageSubscriptionDataSchema = z.object({
  body: z
    .object({
      Callback: z.string(),
      IdempotencyKey: z.string().optional(),
      Method: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const createUserDefinedMessageSubscriptionResponseSchema =
  apiV2010AccountCallUserDefinedMessageSubscriptionSchema;

export const createUserDefinedMessageSubscriptionErrorSchema = z.unknown();

export const deleteUserDefinedMessageSubscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteUserDefinedMessageSubscriptionResponseSchema = z.any();

export const deleteUserDefinedMessageSubscriptionErrorSchema = z.unknown();

export const createUserDefinedMessageDataSchema = z.object({
  body: z
    .object({
      Content: z.string(),
      IdempotencyKey: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
  }),
});

export const createUserDefinedMessageResponseSchema = apiV2010AccountCallUserDefinedMessageSchema;

export const createUserDefinedMessageErrorSchema = z.unknown();

export const deleteCallDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteCallResponseSchema = z.any();

export const deleteCallErrorSchema = z.unknown();

export const fetchCallDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchCallResponseSchema = apiV2010AccountCallSchema;

export const fetchCallErrorSchema = z.unknown();

export const updateCallDataSchema = z.object({
  body: z
    .object({
      FallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      FallbackUrl: z.string().optional(),
      Method: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Status: callEnumUpdateStatusSchema.optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TimeLimit: z.number().optional(),
      Twiml: z.string().optional(),
      Url: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateCallResponseSchema = apiV2010AccountCallSchema;

export const updateCallErrorSchema = z.unknown();

export const listConferenceDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      DateCreated: z.string().optional(),
      'DateCreated<': z.string().optional(),
      'DateCreated>': z.string().optional(),
      DateUpdated: z.string().optional(),
      'DateUpdated<': z.string().optional(),
      'DateUpdated>': z.string().optional(),
      FriendlyName: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      Status: conferenceEnumStatusSchema.optional(),
    })
    .optional(),
});

export const apiV2010AccountConferenceSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid_ending_conference: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  reason_conference_ended: conferenceEnumReasonConferenceEndedSchema.optional().nullable(),
  region: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: conferenceEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listConferenceErrorSchema = z.unknown();

export const listParticipantDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
  }),
  query: z
    .object({
      Coaching: z.boolean().optional(),
      Hold: z.boolean().optional(),
      Muted: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountConferenceParticipantSchema = z.object({
  account_sid: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  call_sid_to_coach: z.string().optional().nullable(),
  coaching: z.boolean().optional().nullable(),
  conference_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  end_conference_on_exit: z.boolean().optional().nullable(),
  hold: z.boolean().optional().nullable(),
  label: z.string().optional().nullable(),
  muted: z.boolean().optional().nullable(),
  start_conference_on_enter: z.boolean().optional().nullable(),
  status: participantEnumStatusSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listParticipantErrorSchema = z.unknown();

export const createParticipantDataSchema = z.object({
  body: z
    .object({
      AmdStatusCallback: z.string().optional(),
      AmdStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Beep: z.string().optional(),
      Byoc: z.string().optional(),
      CallReason: z.string().optional(),
      CallSidToCoach: z.string().optional(),
      CallToken: z.string().optional(),
      CallerId: z.string().optional(),
      Coaching: z.boolean().optional(),
      ConferenceRecord: z.string().optional(),
      ConferenceRecordingStatusCallback: z.string().optional(),
      ConferenceRecordingStatusCallbackEvent: z.array(z.string()).optional(),
      ConferenceRecordingStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      ConferenceStatusCallback: z.string().optional(),
      ConferenceStatusCallbackEvent: z.array(z.string()).optional(),
      ConferenceStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      ConferenceTrim: z.string().optional(),
      EarlyMedia: z.boolean().optional(),
      EndConferenceOnExit: z.boolean().optional(),
      From: z.string(),
      JitterBufferSize: z.string().optional(),
      Label: z.string().optional(),
      MachineDetection: z.string().optional(),
      MachineDetectionSilenceTimeout: z.number().optional(),
      MachineDetectionSpeechEndThreshold: z.number().optional(),
      MachineDetectionSpeechThreshold: z.number().optional(),
      MachineDetectionTimeout: z.number().optional(),
      MaxParticipants: z.number().optional(),
      Muted: z.boolean().optional(),
      Record: z.boolean().optional(),
      RecordingChannels: z.string().optional(),
      RecordingStatusCallback: z.string().optional(),
      RecordingStatusCallbackEvent: z.array(z.string()).optional(),
      RecordingStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      RecordingTrack: z.string().optional(),
      Region: z.string().optional(),
      SipAuthPassword: z.string().optional(),
      SipAuthUsername: z.string().optional(),
      StartConferenceOnEnter: z.boolean().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackEvent: z.array(z.string()).optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TimeLimit: z.number().optional(),
      Timeout: z.number().optional(),
      To: z.string(),
      Trim: z.string().optional(),
      WaitMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      WaitUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
  }),
});

export const createParticipantResponseSchema = apiV2010AccountConferenceParticipantSchema;

export const createParticipantErrorSchema = z.unknown();

export const deleteParticipantDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    ConferenceSid: z.string(),
  }),
});

export const deleteParticipantResponseSchema = z.any();

export const deleteParticipantErrorSchema = z.unknown();

export const fetchParticipantDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    ConferenceSid: z.string(),
  }),
});

export const fetchParticipantResponseSchema = apiV2010AccountConferenceParticipantSchema;

export const fetchParticipantErrorSchema = z.unknown();

export const updateParticipantDataSchema = z.object({
  body: z
    .object({
      AnnounceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      AnnounceUrl: z.string().optional(),
      BeepOnExit: z.boolean().optional(),
      CallSidToCoach: z.string().optional(),
      Coaching: z.boolean().optional(),
      EndConferenceOnExit: z.boolean().optional(),
      Hold: z.boolean().optional(),
      HoldMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      HoldUrl: z.string().optional(),
      Muted: z.boolean().optional(),
      WaitMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      WaitUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    ConferenceSid: z.string(),
  }),
});

export const updateParticipantResponseSchema = apiV2010AccountConferenceParticipantSchema;

export const updateParticipantErrorSchema = z.unknown();

export const listConferenceRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
  }),
  query: z
    .object({
      DateCreated: z.string().optional(),
      'DateCreated<': z.string().optional(),
      'DateCreated>': z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountConferenceConferenceRecordingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  channels: z.number().optional().nullable(),
  conference_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  encryption_details: z.unknown().optional(),
  error_code: z.number().optional().nullable(),
  price: z.string().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  source: conferenceRecordingEnumSourceSchema.optional().nullable(),
  start_time: z.string().optional().nullable(),
  status: conferenceRecordingEnumStatusSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listConferenceRecordingErrorSchema = z.unknown();

export const deleteConferenceRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteConferenceRecordingResponseSchema = z.any();

export const deleteConferenceRecordingErrorSchema = z.unknown();

export const fetchConferenceRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchConferenceRecordingResponseSchema = apiV2010AccountConferenceConferenceRecordingSchema;

export const fetchConferenceRecordingErrorSchema = z.unknown();

export const updateConferenceRecordingDataSchema = z.object({
  body: z
    .object({
      PauseBehavior: z.string().optional(),
      Status: conferenceRecordingEnumStatusSchema,
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    ConferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateConferenceRecordingResponseSchema = apiV2010AccountConferenceConferenceRecordingSchema;

export const updateConferenceRecordingErrorSchema = z.unknown();

export const fetchConferenceDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchConferenceResponseSchema = apiV2010AccountConferenceSchema;

export const fetchConferenceErrorSchema = z.unknown();

export const updateConferenceDataSchema = z.object({
  body: z
    .object({
      AnnounceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      AnnounceUrl: z.string().optional(),
      Status: conferenceEnumUpdateStatusSchema.optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateConferenceResponseSchema = apiV2010AccountConferenceSchema;

export const updateConferenceErrorSchema = z.unknown();

export const listConnectAppDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountConnectAppSchema = z.object({
  account_sid: z.string().optional().nullable(),
  authorize_redirect_url: z.string().optional().nullable(),
  company_name: z.string().optional().nullable(),
  deauthorize_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  deauthorize_callback_url: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  homepage_url: z.string().optional().nullable(),
  permissions: z.array(connectAppEnumPermissionSchema).optional().nullable(),
  sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listConnectAppErrorSchema = z.unknown();

export const deleteConnectAppDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteConnectAppResponseSchema = z.any();

export const deleteConnectAppErrorSchema = z.unknown();

export const fetchConnectAppDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchConnectAppResponseSchema = apiV2010AccountConnectAppSchema;

export const fetchConnectAppErrorSchema = z.unknown();

export const updateConnectAppDataSchema = z.object({
  body: z
    .object({
      AuthorizeRedirectUrl: z.string().optional(),
      CompanyName: z.string().optional(),
      DeauthorizeCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      DeauthorizeCallbackUrl: z.string().optional(),
      Description: z.string().optional(),
      FriendlyName: z.string().optional(),
      HomepageUrl: z.string().optional(),
      Permissions: z.array(connectAppEnumPermissionSchema).optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateConnectAppResponseSchema = apiV2010AccountConnectAppSchema;

export const updateConnectAppErrorSchema = z.unknown();

export const listIncomingPhoneNumberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Beta: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Origin: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      PhoneNumber: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountIncomingPhoneNumberSchema = z.object({
  account_sid: z.string().optional().nullable(),
  address_requirements: incomingPhoneNumberEnumAddressRequirementSchema.optional().nullable(),
  address_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  bundle_sid: z.string().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_address_sid: z.string().optional().nullable(),
  emergency_address_status: incomingPhoneNumberEnumEmergencyAddressStatusSchema.optional().nullable(),
  emergency_status: incomingPhoneNumberEnumEmergencyStatusSchema.optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  identity_sid: z.string().optional().nullable(),
  origin: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_application_sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  status: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_application_sid: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_receive_mode: incomingPhoneNumberEnumVoiceReceiveModeSchema.optional().nullable(),
  voice_url: z.string().optional().nullable(),
});

export const listIncomingPhoneNumberErrorSchema = z.unknown();

export const createIncomingPhoneNumberDataSchema = z.object({
  body: z
    .object({
      AddressSid: z.string().optional(),
      ApiVersion: z.string().optional(),
      AreaCode: z.string().optional(),
      BundleSid: z.string().optional(),
      EmergencyAddressSid: z.string().optional(),
      EmergencyStatus: incomingPhoneNumberEnumEmergencyStatusSchema.optional(),
      FriendlyName: z.string().optional(),
      IdentitySid: z.string().optional(),
      PhoneNumber: z.string().optional(),
      SmsApplicationSid: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TrunkSid: z.string().optional(),
      VoiceApplicationSid: z.string().optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceReceiveMode: incomingPhoneNumberEnumVoiceReceiveModeSchema.optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createIncomingPhoneNumberResponseSchema = apiV2010AccountIncomingPhoneNumberSchema;

export const createIncomingPhoneNumberErrorSchema = z.unknown();

export const listIncomingPhoneNumberLocalDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Beta: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Origin: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      PhoneNumber: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberLocalSchema = z.object({
  account_sid: z.string().optional().nullable(),
  address_requirements: incomingPhoneNumberLocalEnumAddressRequirementSchema.optional().nullable(),
  address_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  bundle_sid: z.string().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_address_sid: z.string().optional().nullable(),
  emergency_address_status: incomingPhoneNumberLocalEnumEmergencyAddressStatusSchema.optional().nullable(),
  emergency_status: incomingPhoneNumberLocalEnumEmergencyStatusSchema.optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  identity_sid: z.string().optional().nullable(),
  origin: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_application_sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  status: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_application_sid: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_receive_mode: incomingPhoneNumberLocalEnumVoiceReceiveModeSchema.optional().nullable(),
  voice_url: z.string().optional().nullable(),
});

export const listIncomingPhoneNumberLocalErrorSchema = z.unknown();

export const createIncomingPhoneNumberLocalDataSchema = z.object({
  body: z
    .object({
      AddressSid: z.string().optional(),
      ApiVersion: z.string().optional(),
      BundleSid: z.string().optional(),
      EmergencyAddressSid: z.string().optional(),
      EmergencyStatus: incomingPhoneNumberLocalEnumEmergencyStatusSchema.optional(),
      FriendlyName: z.string().optional(),
      IdentitySid: z.string().optional(),
      PhoneNumber: z.string(),
      SmsApplicationSid: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TrunkSid: z.string().optional(),
      VoiceApplicationSid: z.string().optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceReceiveMode: incomingPhoneNumberLocalEnumVoiceReceiveModeSchema.optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createIncomingPhoneNumberLocalResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberLocalSchema;

export const createIncomingPhoneNumberLocalErrorSchema = z.unknown();

export const listIncomingPhoneNumberMobileDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Beta: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Origin: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      PhoneNumber: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberMobileSchema = z.object({
  account_sid: z.string().optional().nullable(),
  address_requirements: incomingPhoneNumberMobileEnumAddressRequirementSchema.optional().nullable(),
  address_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  bundle_sid: z.string().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_address_sid: z.string().optional().nullable(),
  emergency_address_status: incomingPhoneNumberMobileEnumEmergencyAddressStatusSchema.optional().nullable(),
  emergency_status: incomingPhoneNumberMobileEnumEmergencyStatusSchema.optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  identity_sid: z.string().optional().nullable(),
  origin: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_application_sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  status: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_application_sid: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_receive_mode: incomingPhoneNumberMobileEnumVoiceReceiveModeSchema.optional().nullable(),
  voice_url: z.string().optional().nullable(),
});

export const listIncomingPhoneNumberMobileErrorSchema = z.unknown();

export const createIncomingPhoneNumberMobileDataSchema = z.object({
  body: z
    .object({
      AddressSid: z.string().optional(),
      ApiVersion: z.string().optional(),
      BundleSid: z.string().optional(),
      EmergencyAddressSid: z.string().optional(),
      EmergencyStatus: incomingPhoneNumberMobileEnumEmergencyStatusSchema.optional(),
      FriendlyName: z.string().optional(),
      IdentitySid: z.string().optional(),
      PhoneNumber: z.string(),
      SmsApplicationSid: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TrunkSid: z.string().optional(),
      VoiceApplicationSid: z.string().optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceReceiveMode: incomingPhoneNumberMobileEnumVoiceReceiveModeSchema.optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createIncomingPhoneNumberMobileResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberMobileSchema;

export const createIncomingPhoneNumberMobileErrorSchema = z.unknown();

export const listIncomingPhoneNumberTollFreeDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Beta: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Origin: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      PhoneNumber: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberTollFreeSchema = z.object({
  account_sid: z.string().optional().nullable(),
  address_requirements: incomingPhoneNumberTollFreeEnumAddressRequirementSchema.optional().nullable(),
  address_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  beta: z.boolean().optional().nullable(),
  bundle_sid: z.string().optional().nullable(),
  capabilities: z
    .object({
      fax: z.boolean().optional(),
      mms: z.boolean().optional(),
      sms: z.boolean().optional(),
      voice: z.boolean().optional(),
    })
    .optional()
    .nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  emergency_address_sid: z.string().optional().nullable(),
  emergency_address_status: incomingPhoneNumberTollFreeEnumEmergencyAddressStatusSchema.optional().nullable(),
  emergency_status: incomingPhoneNumberTollFreeEnumEmergencyStatusSchema.optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  identity_sid: z.string().optional().nullable(),
  origin: z.string().optional().nullable(),
  phone_number: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  sms_application_sid: z.string().optional().nullable(),
  sms_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_fallback_url: z.string().optional().nullable(),
  sms_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  sms_url: z.string().optional().nullable(),
  status: z.string().optional().nullable(),
  status_callback: z.string().optional().nullable(),
  status_callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  trunk_sid: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  voice_application_sid: z.string().optional().nullable(),
  voice_caller_id_lookup: z.boolean().optional().nullable(),
  voice_fallback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_fallback_url: z.string().optional().nullable(),
  voice_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  voice_receive_mode: incomingPhoneNumberTollFreeEnumVoiceReceiveModeSchema.optional().nullable(),
  voice_url: z.string().optional().nullable(),
});

export const listIncomingPhoneNumberTollFreeErrorSchema = z.unknown();

export const createIncomingPhoneNumberTollFreeDataSchema = z.object({
  body: z
    .object({
      AddressSid: z.string().optional(),
      ApiVersion: z.string().optional(),
      BundleSid: z.string().optional(),
      EmergencyAddressSid: z.string().optional(),
      EmergencyStatus: incomingPhoneNumberTollFreeEnumEmergencyStatusSchema.optional(),
      FriendlyName: z.string().optional(),
      IdentitySid: z.string().optional(),
      PhoneNumber: z.string(),
      SmsApplicationSid: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TrunkSid: z.string().optional(),
      VoiceApplicationSid: z.string().optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceReceiveMode: incomingPhoneNumberTollFreeEnumVoiceReceiveModeSchema.optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createIncomingPhoneNumberTollFreeResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberTollFreeSchema;

export const createIncomingPhoneNumberTollFreeErrorSchema = z.unknown();

export const listIncomingPhoneNumberAssignedAddOnDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ResourceSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listIncomingPhoneNumberAssignedAddOnResponseSchema = z.object({
  assigned_add_ons: z.array(apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberAssignedAddOnErrorSchema = z.unknown();

export const createIncomingPhoneNumberAssignedAddOnDataSchema = z.object({
  body: z
    .object({
      InstalledAddOnSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    ResourceSid: z.string(),
  }),
});

export const createIncomingPhoneNumberAssignedAddOnResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnSchema;

export const createIncomingPhoneNumberAssignedAddOnErrorSchema = z.unknown();

export const listIncomingPhoneNumberAssignedAddOnExtensionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AssignedAddOnSid: z.string(),
    ResourceSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listIncomingPhoneNumberAssignedAddOnExtensionResponseSchema = z.object({
  end: z.number().optional(),
  extensions: z
    .array(
      apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnIncomingPhoneNumberAssignedAddOnExtensionSchema,
    )
    .optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberAssignedAddOnExtensionErrorSchema = z.unknown();

export const fetchIncomingPhoneNumberAssignedAddOnExtensionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AssignedAddOnSid: z.string(),
    ResourceSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchIncomingPhoneNumberAssignedAddOnExtensionResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnIncomingPhoneNumberAssignedAddOnExtensionSchema;

export const fetchIncomingPhoneNumberAssignedAddOnExtensionErrorSchema = z.unknown();

export const deleteIncomingPhoneNumberAssignedAddOnDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ResourceSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteIncomingPhoneNumberAssignedAddOnResponseSchema = z.any();

export const deleteIncomingPhoneNumberAssignedAddOnErrorSchema = z.unknown();

export const fetchIncomingPhoneNumberAssignedAddOnDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ResourceSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchIncomingPhoneNumberAssignedAddOnResponseSchema =
  apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberAssignedAddOnSchema;

export const fetchIncomingPhoneNumberAssignedAddOnErrorSchema = z.unknown();

export const deleteIncomingPhoneNumberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteIncomingPhoneNumberResponseSchema = z.any();

export const deleteIncomingPhoneNumberErrorSchema = z.unknown();

export const fetchIncomingPhoneNumberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchIncomingPhoneNumberResponseSchema = apiV2010AccountIncomingPhoneNumberSchema;

export const fetchIncomingPhoneNumberErrorSchema = z.unknown();

export const updateIncomingPhoneNumberDataSchema = z.object({
  body: z
    .object({
      AccountSid: z.string().optional(),
      AddressSid: z.string().optional(),
      ApiVersion: z.string().optional(),
      BundleSid: z.string().optional(),
      EmergencyAddressSid: z.string().optional(),
      EmergencyStatus: incomingPhoneNumberEnumEmergencyStatusSchema.optional(),
      FriendlyName: z.string().optional(),
      IdentitySid: z.string().optional(),
      SmsApplicationSid: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      TrunkSid: z.string().optional(),
      VoiceApplicationSid: z.string().optional(),
      VoiceCallerIdLookup: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceReceiveMode: incomingPhoneNumberEnumVoiceReceiveModeSchema.optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateIncomingPhoneNumberResponseSchema = apiV2010AccountIncomingPhoneNumberSchema;

export const updateIncomingPhoneNumberErrorSchema = z.unknown();

export const listKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listKeyResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  keys: z.array(apiV2010AccountKeySchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listKeyErrorSchema = z.unknown();

export const createNewKeyDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createNewKeyResponseSchema = apiV2010AccountNewKeySchema;

export const createNewKeyErrorSchema = z.unknown();

export const deleteKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteKeyResponseSchema = z.any();

export const deleteKeyErrorSchema = z.unknown();

export const fetchKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchKeyResponseSchema = apiV2010AccountKeySchema;

export const fetchKeyErrorSchema = z.unknown();

export const updateKeyDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateKeyResponseSchema = apiV2010AccountKeySchema;

export const updateKeyErrorSchema = z.unknown();

export const listMessageDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      DateSent: z.string().optional(),
      'DateSent<': z.string().optional(),
      'DateSent>': z.string().optional(),
      From: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      To: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountMessageSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  body: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_sent: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  direction: messageEnumDirectionSchema.optional().nullable(),
  error_code: z.number().optional().nullable(),
  error_message: z.string().optional().nullable(),
  from: z.string().optional().nullable(),
  messaging_service_sid: z.string().optional().nullable(),
  num_media: z.string().optional().nullable(),
  num_segments: z.string().optional().nullable(),
  price: z.string().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: messageEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  to: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listMessageErrorSchema = z.unknown();

export const createMessageDataSchema = z.object({
  body: z
    .object({
      AddressRetention: messageEnumAddressRetentionSchema.optional(),
      ApplicationSid: z.string().optional(),
      Attempt: z.number().optional(),
      Body: z.string().optional(),
      ContentRetention: messageEnumContentRetentionSchema.optional(),
      ContentSid: z.string().optional(),
      ContentVariables: z.string().optional(),
      ForceDelivery: z.boolean().optional(),
      From: z.string().optional(),
      MaxPrice: z.number().optional(),
      MediaUrl: z.array(z.string()).optional(),
      MessagingServiceSid: z.string().optional(),
      PersistentAction: z.array(z.string()).optional(),
      ProvideFeedback: z.boolean().optional(),
      RiskCheck: messageEnumRiskCheckSchema.optional(),
      ScheduleType: messageEnumScheduleTypeSchema.optional(),
      SendAsMms: z.boolean().optional(),
      SendAt: z.string().optional(),
      ShortenUrls: z.boolean().optional(),
      SmartEncoded: z.boolean().optional(),
      StatusCallback: z.string().optional(),
      To: z.string(),
      ValidityPeriod: z.number().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createMessageResponseSchema = apiV2010AccountMessageSchema;

export const createMessageErrorSchema = z.unknown();

export const createMessageFeedbackDataSchema = z.object({
  body: z
    .object({
      Outcome: messageFeedbackEnumOutcomeSchema.optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    MessageSid: z.string(),
  }),
});

export const apiV2010AccountMessageMessageFeedbackSchema = z.object({
  account_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  message_sid: z.string().optional().nullable(),
  outcome: messageFeedbackEnumOutcomeSchema.optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const createMessageFeedbackErrorSchema = z.unknown();

export const listMediaDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    MessageSid: z.string(),
  }),
  query: z
    .object({
      DateCreated: z.string().optional(),
      'DateCreated<': z.string().optional(),
      'DateCreated>': z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listMediaResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  media_list: z.array(apiV2010AccountMessageMediaSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listMediaErrorSchema = z.unknown();

export const deleteMediaDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    MessageSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteMediaResponseSchema = z.any();

export const deleteMediaErrorSchema = z.unknown();

export const fetchMediaDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    MessageSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchMediaResponseSchema = apiV2010AccountMessageMediaSchema;

export const fetchMediaErrorSchema = z.unknown();

export const deleteMessageDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteMessageResponseSchema = z.any();

export const deleteMessageErrorSchema = z.unknown();

export const fetchMessageDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchMessageResponseSchema = apiV2010AccountMessageSchema;

export const fetchMessageErrorSchema = z.unknown();

export const updateMessageDataSchema = z.object({
  body: z
    .object({
      Body: z.string().optional(),
      Status: messageEnumUpdateStatusSchema.optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateMessageResponseSchema = apiV2010AccountMessageSchema;

export const updateMessageErrorSchema = z.unknown();

export const listNotificationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Log: z.number().optional(),
      MessageDate: z.string().optional(),
      'MessageDate<': z.string().optional(),
      'MessageDate>': z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listNotificationResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  notifications: z.array(apiV2010AccountNotificationSchema).optional(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listNotificationErrorSchema = z.unknown();

export const fetchNotificationDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchNotificationResponseSchema = apiV2010AccountNotificationInstanceSchema;

export const fetchNotificationErrorSchema = z.unknown();

export const listOutgoingCallerIdDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      FriendlyName: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      PhoneNumber: z.string().optional(),
    })
    .optional(),
});

export const listOutgoingCallerIdResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  outgoing_caller_ids: z.array(apiV2010AccountOutgoingCallerIdSchema).optional(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listOutgoingCallerIdErrorSchema = z.unknown();

export const createValidationRequestDataSchema = z.object({
  body: z
    .object({
      CallDelay: z.number().optional(),
      Extension: z.string().optional(),
      FriendlyName: z.string().optional(),
      PhoneNumber: z.string(),
      StatusCallback: z.string().optional(),
      StatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createValidationRequestResponseSchema = apiV2010AccountValidationRequestSchema;

export const createValidationRequestErrorSchema = z.unknown();

export const deleteOutgoingCallerIdDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteOutgoingCallerIdResponseSchema = z.any();

export const deleteOutgoingCallerIdErrorSchema = z.unknown();

export const fetchOutgoingCallerIdDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchOutgoingCallerIdResponseSchema = apiV2010AccountOutgoingCallerIdSchema;

export const fetchOutgoingCallerIdErrorSchema = z.unknown();

export const updateOutgoingCallerIdDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateOutgoingCallerIdResponseSchema = apiV2010AccountOutgoingCallerIdSchema;

export const updateOutgoingCallerIdErrorSchema = z.unknown();

export const listQueueDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listQueueResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  queues: z.array(apiV2010AccountQueueSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listQueueErrorSchema = z.unknown();

export const createQueueDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string(),
      MaxSize: z.number().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createQueueResponseSchema = apiV2010AccountQueueSchema;

export const createQueueErrorSchema = z.unknown();

export const listMemberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    QueueSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listMemberResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  queue_members: z.array(apiV2010AccountQueueMemberSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listMemberErrorSchema = z.unknown();

export const fetchMemberDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    QueueSid: z.string(),
  }),
});

export const fetchMemberResponseSchema = apiV2010AccountQueueMemberSchema;

export const fetchMemberErrorSchema = z.unknown();

export const updateMemberDataSchema = z.object({
  body: z
    .object({
      Method: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      Url: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CallSid: z.string(),
    QueueSid: z.string(),
  }),
});

export const updateMemberResponseSchema = apiV2010AccountQueueMemberSchema;

export const updateMemberErrorSchema = z.unknown();

export const deleteQueueDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteQueueResponseSchema = z.any();

export const deleteQueueErrorSchema = z.unknown();

export const fetchQueueDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchQueueResponseSchema = apiV2010AccountQueueSchema;

export const fetchQueueErrorSchema = z.unknown();

export const updateQueueDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
      MaxSize: z.number().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateQueueResponseSchema = apiV2010AccountQueueSchema;

export const updateQueueErrorSchema = z.unknown();

export const listRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      CallSid: z.string().optional(),
      ConferenceSid: z.string().optional(),
      DateCreated: z.string().optional(),
      'DateCreated<': z.string().optional(),
      'DateCreated>': z.string().optional(),
      IncludeSoftDeleted: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountRecordingSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  call_sid: z.string().optional().nullable(),
  channels: z.number().optional().nullable(),
  conference_sid: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  encryption_details: z.unknown().optional(),
  error_code: z.number().optional().nullable(),
  media_url: z.string().optional().nullable(),
  price: z.string().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  source: recordingEnumSourceSchema.optional().nullable(),
  start_time: z.string().optional().nullable(),
  status: recordingEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listRecordingErrorSchema = z.unknown();

export const listRecordingTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    RecordingSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountRecordingRecordingTranscriptionSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  recording_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: recordingTranscriptionEnumStatusSchema.optional().nullable(),
  transcription_text: z.string().optional().nullable(),
  type: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listRecordingTranscriptionErrorSchema = z.unknown();

export const deleteRecordingTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    RecordingSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteRecordingTranscriptionResponseSchema = z.any();

export const deleteRecordingTranscriptionErrorSchema = z.unknown();

export const fetchRecordingTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    RecordingSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchRecordingTranscriptionResponseSchema = apiV2010AccountRecordingRecordingTranscriptionSchema;

export const fetchRecordingTranscriptionErrorSchema = z.unknown();

export const listRecordingAddOnResultDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ReferenceSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountRecordingRecordingAddOnResultSchema = z.object({
  account_sid: z.string().optional().nullable(),
  add_on_configuration_sid: z.string().optional().nullable(),
  add_on_sid: z.string().optional().nullable(),
  date_completed: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  reference_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: recordingAddOnResultEnumStatusSchema.optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
});

export const listRecordingAddOnResultErrorSchema = z.unknown();

export const listRecordingAddOnResultPayloadDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AddOnResultSid: z.string(),
    ReferenceSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listRecordingAddOnResultPayloadResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  payloads: z.array(apiV2010AccountRecordingRecordingAddOnResultRecordingAddOnResultPayloadSchema).optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listRecordingAddOnResultPayloadErrorSchema = z.unknown();

export const deleteRecordingAddOnResultPayloadDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AddOnResultSid: z.string(),
    ReferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteRecordingAddOnResultPayloadResponseSchema = z.any();

export const deleteRecordingAddOnResultPayloadErrorSchema = z.unknown();

export const fetchRecordingAddOnResultPayloadDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    AddOnResultSid: z.string(),
    ReferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchRecordingAddOnResultPayloadResponseSchema =
  apiV2010AccountRecordingRecordingAddOnResultRecordingAddOnResultPayloadSchema;

export const fetchRecordingAddOnResultPayloadErrorSchema = z.unknown();

export const deleteRecordingAddOnResultDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ReferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteRecordingAddOnResultResponseSchema = z.any();

export const deleteRecordingAddOnResultErrorSchema = z.unknown();

export const fetchRecordingAddOnResultDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    ReferenceSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchRecordingAddOnResultResponseSchema = apiV2010AccountRecordingRecordingAddOnResultSchema;

export const fetchRecordingAddOnResultErrorSchema = z.unknown();

export const deleteRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteRecordingResponseSchema = z.any();

export const deleteRecordingErrorSchema = z.unknown();

export const fetchRecordingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
  query: z
    .object({
      IncludeSoftDeleted: z.boolean().optional(),
    })
    .optional(),
});

export const fetchRecordingResponseSchema = apiV2010AccountRecordingSchema;

export const fetchRecordingErrorSchema = z.unknown();

export const listSipCredentialListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipCredentialListResponseSchema = z.object({
  credential_lists: z.array(apiV2010AccountSipSipCredentialListSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipCredentialListErrorSchema = z.unknown();

export const createSipCredentialListDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createSipCredentialListResponseSchema = apiV2010AccountSipSipCredentialListSchema;

export const createSipCredentialListErrorSchema = z.unknown();

export const listSipCredentialDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CredentialListSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipCredentialResponseSchema = z.object({
  credentials: z.array(apiV2010AccountSipSipCredentialListSipCredentialSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipCredentialErrorSchema = z.unknown();

export const createSipCredentialDataSchema = z.object({
  body: z
    .object({
      Password: z.string(),
      Username: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CredentialListSid: z.string(),
  }),
});

export const createSipCredentialResponseSchema = apiV2010AccountSipSipCredentialListSipCredentialSchema;

export const createSipCredentialErrorSchema = z.unknown();

export const deleteSipCredentialDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CredentialListSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipCredentialResponseSchema = z.any();

export const deleteSipCredentialErrorSchema = z.unknown();

export const fetchSipCredentialDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    CredentialListSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipCredentialResponseSchema = apiV2010AccountSipSipCredentialListSipCredentialSchema;

export const fetchSipCredentialErrorSchema = z.unknown();

export const updateSipCredentialDataSchema = z.object({
  body: z
    .object({
      Password: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    CredentialListSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSipCredentialResponseSchema = apiV2010AccountSipSipCredentialListSipCredentialSchema;

export const updateSipCredentialErrorSchema = z.unknown();

export const deleteSipCredentialListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipCredentialListResponseSchema = z.any();

export const deleteSipCredentialListErrorSchema = z.unknown();

export const fetchSipCredentialListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipCredentialListResponseSchema = apiV2010AccountSipSipCredentialListSchema;

export const fetchSipCredentialListErrorSchema = z.unknown();

export const updateSipCredentialListDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSipCredentialListResponseSchema = apiV2010AccountSipSipCredentialListSchema;

export const updateSipCredentialListErrorSchema = z.unknown();

export const listSipDomainDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipDomainResponseSchema = z.object({
  domains: z.array(apiV2010AccountSipSipDomainSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipDomainErrorSchema = z.unknown();

export const createSipDomainDataSchema = z.object({
  body: z
    .object({
      ByocTrunkSid: z.string().optional(),
      DomainName: z.string(),
      EmergencyCallerSid: z.string().optional(),
      EmergencyCallingEnabled: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Secure: z.boolean().optional(),
      SipRegistration: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceStatusCallbackUrl: z.string().optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createSipDomainResponseSchema = apiV2010AccountSipSipDomainSchema;

export const createSipDomainErrorSchema = z.unknown();

export const listSipAuthCallsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipAuthCallsCredentialListMappingResponseSchema = z.object({
  contents: z.array(apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsCredentialListMappingSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipAuthCallsCredentialListMappingErrorSchema = z.unknown();

export const createSipAuthCallsCredentialListMappingDataSchema = z.object({
  body: z
    .object({
      CredentialListSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
});

export const createSipAuthCallsCredentialListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsCredentialListMappingSchema;

export const createSipAuthCallsCredentialListMappingErrorSchema = z.unknown();

export const deleteSipAuthCallsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipAuthCallsCredentialListMappingResponseSchema = z.any();

export const deleteSipAuthCallsCredentialListMappingErrorSchema = z.unknown();

export const fetchSipAuthCallsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipAuthCallsCredentialListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsCredentialListMappingSchema;

export const fetchSipAuthCallsCredentialListMappingErrorSchema = z.unknown();

export const listSipAuthCallsIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipAuthCallsIpAccessControlListMappingResponseSchema = z.object({
  contents: z
    .array(apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsIpAccessControlListMappingSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipAuthCallsIpAccessControlListMappingErrorSchema = z.unknown();

export const createSipAuthCallsIpAccessControlListMappingDataSchema = z.object({
  body: z
    .object({
      IpAccessControlListSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
});

export const createSipAuthCallsIpAccessControlListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsIpAccessControlListMappingSchema;

export const createSipAuthCallsIpAccessControlListMappingErrorSchema = z.unknown();

export const deleteSipAuthCallsIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipAuthCallsIpAccessControlListMappingResponseSchema = z.any();

export const deleteSipAuthCallsIpAccessControlListMappingErrorSchema = z.unknown();

export const fetchSipAuthCallsIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipAuthCallsIpAccessControlListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthCallsSipAuthCallsIpAccessControlListMappingSchema;

export const fetchSipAuthCallsIpAccessControlListMappingErrorSchema = z.unknown();

export const listSipAuthRegistrationsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipAuthRegistrationsCredentialListMappingResponseSchema = z.object({
  contents: z
    .array(apiV2010AccountSipSipDomainSipAuthSipAuthRegistrationsSipAuthRegistrationsCredentialListMappingSchema)
    .optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipAuthRegistrationsCredentialListMappingErrorSchema = z.unknown();

export const createSipAuthRegistrationsCredentialListMappingDataSchema = z.object({
  body: z
    .object({
      CredentialListSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
});

export const createSipAuthRegistrationsCredentialListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthRegistrationsSipAuthRegistrationsCredentialListMappingSchema;

export const createSipAuthRegistrationsCredentialListMappingErrorSchema = z.unknown();

export const deleteSipAuthRegistrationsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipAuthRegistrationsCredentialListMappingResponseSchema = z.any();

export const deleteSipAuthRegistrationsCredentialListMappingErrorSchema = z.unknown();

export const fetchSipAuthRegistrationsCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipAuthRegistrationsCredentialListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipAuthSipAuthRegistrationsSipAuthRegistrationsCredentialListMappingSchema;

export const fetchSipAuthRegistrationsCredentialListMappingErrorSchema = z.unknown();

export const listSipCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipCredentialListMappingResponseSchema = z.object({
  credential_list_mappings: z.array(apiV2010AccountSipSipDomainSipCredentialListMappingSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipCredentialListMappingErrorSchema = z.unknown();

export const createSipCredentialListMappingDataSchema = z.object({
  body: z
    .object({
      CredentialListSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
});

export const createSipCredentialListMappingResponseSchema = apiV2010AccountSipSipDomainSipCredentialListMappingSchema;

export const createSipCredentialListMappingErrorSchema = z.unknown();

export const deleteSipCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipCredentialListMappingResponseSchema = z.any();

export const deleteSipCredentialListMappingErrorSchema = z.unknown();

export const fetchSipCredentialListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipCredentialListMappingResponseSchema = apiV2010AccountSipSipDomainSipCredentialListMappingSchema;

export const fetchSipCredentialListMappingErrorSchema = z.unknown();

export const listSipIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipIpAccessControlListMappingResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  ip_access_control_list_mappings: z.array(apiV2010AccountSipSipDomainSipIpAccessControlListMappingSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipIpAccessControlListMappingErrorSchema = z.unknown();

export const createSipIpAccessControlListMappingDataSchema = z.object({
  body: z
    .object({
      IpAccessControlListSid: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
  }),
});

export const createSipIpAccessControlListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipIpAccessControlListMappingSchema;

export const createSipIpAccessControlListMappingErrorSchema = z.unknown();

export const deleteSipIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipIpAccessControlListMappingResponseSchema = z.any();

export const deleteSipIpAccessControlListMappingErrorSchema = z.unknown();

export const fetchSipIpAccessControlListMappingDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    DomainSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipIpAccessControlListMappingResponseSchema =
  apiV2010AccountSipSipDomainSipIpAccessControlListMappingSchema;

export const fetchSipIpAccessControlListMappingErrorSchema = z.unknown();

export const deleteSipDomainDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipDomainResponseSchema = z.any();

export const deleteSipDomainErrorSchema = z.unknown();

export const fetchSipDomainDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipDomainResponseSchema = apiV2010AccountSipSipDomainSchema;

export const fetchSipDomainErrorSchema = z.unknown();

export const updateSipDomainDataSchema = z.object({
  body: z
    .object({
      ByocTrunkSid: z.string().optional(),
      DomainName: z.string().optional(),
      EmergencyCallerSid: z.string().optional(),
      EmergencyCallingEnabled: z.boolean().optional(),
      FriendlyName: z.string().optional(),
      Secure: z.boolean().optional(),
      SipRegistration: z.boolean().optional(),
      VoiceFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceFallbackUrl: z.string().optional(),
      VoiceMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceStatusCallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      VoiceStatusCallbackUrl: z.string().optional(),
      VoiceUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSipDomainResponseSchema = apiV2010AccountSipSipDomainSchema;

export const updateSipDomainErrorSchema = z.unknown();

export const listSipIpAccessControlListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipIpAccessControlListResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  ip_access_control_lists: z.array(apiV2010AccountSipSipIpAccessControlListSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipIpAccessControlListErrorSchema = z.unknown();

export const createSipIpAccessControlListDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createSipIpAccessControlListResponseSchema = apiV2010AccountSipSipIpAccessControlListSchema;

export const createSipIpAccessControlListErrorSchema = z.unknown();

export const listSipIpAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    IpAccessControlListSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSipIpAddressResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  ip_addresses: z.array(apiV2010AccountSipSipIpAccessControlListSipIpAddressSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSipIpAddressErrorSchema = z.unknown();

export const createSipIpAddressDataSchema = z.object({
  body: z
    .object({
      CidrPrefixLength: z.number().optional(),
      FriendlyName: z.string(),
      IpAddress: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    IpAccessControlListSid: z.string(),
  }),
});

export const createSipIpAddressResponseSchema = apiV2010AccountSipSipIpAccessControlListSipIpAddressSchema;

export const createSipIpAddressErrorSchema = z.unknown();

export const deleteSipIpAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    IpAccessControlListSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipIpAddressResponseSchema = z.any();

export const deleteSipIpAddressErrorSchema = z.unknown();

export const fetchSipIpAddressDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    IpAccessControlListSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipIpAddressResponseSchema = apiV2010AccountSipSipIpAccessControlListSipIpAddressSchema;

export const fetchSipIpAddressErrorSchema = z.unknown();

export const updateSipIpAddressDataSchema = z.object({
  body: z
    .object({
      CidrPrefixLength: z.number().optional(),
      FriendlyName: z.string().optional(),
      IpAddress: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    IpAccessControlListSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSipIpAddressResponseSchema = apiV2010AccountSipSipIpAccessControlListSipIpAddressSchema;

export const updateSipIpAddressErrorSchema = z.unknown();

export const deleteSipIpAccessControlListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSipIpAccessControlListResponseSchema = z.any();

export const deleteSipIpAccessControlListErrorSchema = z.unknown();

export const fetchSipIpAccessControlListDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSipIpAccessControlListResponseSchema = apiV2010AccountSipSipIpAccessControlListSchema;

export const fetchSipIpAccessControlListErrorSchema = z.unknown();

export const updateSipIpAccessControlListDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSipIpAccessControlListResponseSchema = apiV2010AccountSipSipIpAccessControlListSchema;

export const updateSipIpAccessControlListErrorSchema = z.unknown();

export const listShortCodeDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      FriendlyName: z.string().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      ShortCode: z.string().optional(),
    })
    .optional(),
});

export const listShortCodeResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  short_codes: z.array(apiV2010AccountShortCodeSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listShortCodeErrorSchema = z.unknown();

export const fetchShortCodeDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchShortCodeResponseSchema = apiV2010AccountShortCodeSchema;

export const fetchShortCodeErrorSchema = z.unknown();

export const updateShortCodeDataSchema = z.object({
  body: z
    .object({
      ApiVersion: z.string().optional(),
      FriendlyName: z.string().optional(),
      SmsFallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsFallbackUrl: z.string().optional(),
      SmsMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      SmsUrl: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateShortCodeResponseSchema = apiV2010AccountShortCodeSchema;

export const updateShortCodeErrorSchema = z.unknown();

export const listSigningKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const listSigningKeyResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  signing_keys: z.array(apiV2010AccountSigningKeySchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listSigningKeyErrorSchema = z.unknown();

export const createNewSigningKeyDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createNewSigningKeyResponseSchema = apiV2010AccountNewSigningKeySchema;

export const createNewSigningKeyErrorSchema = z.unknown();

export const deleteSigningKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteSigningKeyResponseSchema = z.any();

export const deleteSigningKeyErrorSchema = z.unknown();

export const fetchSigningKeyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchSigningKeyResponseSchema = apiV2010AccountSigningKeySchema;

export const fetchSigningKeyErrorSchema = z.unknown();

export const updateSigningKeyDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateSigningKeyResponseSchema = apiV2010AccountSigningKeySchema;

export const updateSigningKeyErrorSchema = z.unknown();

export const createTokenDataSchema = z.object({
  body: z
    .object({
      Ttl: z.number().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createTokenResponseSchema = apiV2010AccountTokenSchema;

export const createTokenErrorSchema = z.unknown();

export const listTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountTranscriptionSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  duration: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  recording_sid: z.string().optional().nullable(),
  sid: z.string().optional().nullable(),
  status: transcriptionEnumStatusSchema.optional().nullable(),
  transcription_text: z.string().optional().nullable(),
  type: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
});

export const listTranscriptionErrorSchema = z.unknown();

export const deleteTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteTranscriptionResponseSchema = z.any();

export const deleteTranscriptionErrorSchema = z.unknown();

export const fetchTranscriptionDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchTranscriptionResponseSchema = apiV2010AccountTranscriptionSchema;

export const fetchTranscriptionErrorSchema = z.unknown();

export const listUsageRecordDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordErrorSchema = z.unknown();

export const listUsageRecordAllTimeDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordAllTimeEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordAllTimeSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordAllTimeEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordAllTimeErrorSchema = z.unknown();

export const listUsageRecordDailyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordDailyEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordDailySchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordDailyEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordDailyErrorSchema = z.unknown();

export const listUsageRecordLastMonthDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordLastMonthEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordLastMonthSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordLastMonthEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordLastMonthErrorSchema = z.unknown();

export const listUsageRecordMonthlyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordMonthlyEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordMonthlySchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordMonthlyEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordMonthlyErrorSchema = z.unknown();

export const listUsageRecordThisMonthDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordThisMonthEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordThisMonthSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordThisMonthEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordThisMonthErrorSchema = z.unknown();

export const listUsageRecordTodayDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordTodayEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordTodaySchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordTodayEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordTodayErrorSchema = z.unknown();

export const listUsageRecordYearlyDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordYearlyEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordYearlySchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordYearlyEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordYearlyErrorSchema = z.unknown();

export const listUsageRecordYesterdayDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Category: usageRecordYesterdayEnumCategorySchema.optional(),
      EndDate: z.string().optional(),
      IncludeSubaccounts: z.boolean().optional(),
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      StartDate: z.string().optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageRecordUsageRecordYesterdaySchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  as_of: z.string().optional().nullable(),
  category: usageRecordYesterdayEnumCategorySchema.optional().nullable(),
  count: z.string().optional().nullable(),
  count_unit: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  end_date: z.string().optional().nullable(),
  price: z.number().optional().nullable(),
  price_unit: z.string().optional().nullable(),
  start_date: z.string().optional().nullable(),
  subresource_uris: z.record(z.unknown()).optional().nullable(),
  uri: z.string().optional().nullable(),
  usage: z.string().optional().nullable(),
  usage_unit: z.string().optional().nullable(),
});

export const listUsageRecordYesterdayErrorSchema = z.unknown();

export const listUsageTriggerDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
  }),
  query: z
    .object({
      Page: z.number().optional(),
      PageSize: z.number().optional(),
      PageToken: z.string().optional(),
      Recurring: usageTriggerEnumRecurringSchema.optional(),
      TriggerBy: usageTriggerEnumTriggerFieldSchema.optional(),
      UsageCategory: usageTriggerEnumUsageCategorySchema.optional(),
    })
    .optional(),
});

export const apiV2010AccountUsageUsageTriggerSchema = z.object({
  account_sid: z.string().optional().nullable(),
  api_version: z.string().optional().nullable(),
  callback_method: z
    .union([
      z.literal('HEAD'),
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PATCH'),
      z.literal('PUT'),
      z.literal('DELETE'),
    ])
    .optional()
    .nullable(),
  callback_url: z.string().optional().nullable(),
  current_value: z.string().optional().nullable(),
  date_created: z.string().optional().nullable(),
  date_fired: z.string().optional().nullable(),
  date_updated: z.string().optional().nullable(),
  friendly_name: z.string().optional().nullable(),
  recurring: usageTriggerEnumRecurringSchema.optional().nullable(),
  sid: z.string().optional().nullable(),
  trigger_by: usageTriggerEnumTriggerFieldSchema.optional().nullable(),
  trigger_value: z.string().optional().nullable(),
  uri: z.string().optional().nullable(),
  usage_category: usageTriggerEnumUsageCategorySchema.optional().nullable(),
  usage_record_uri: z.string().optional().nullable(),
});

export const listUsageTriggerErrorSchema = z.unknown();

export const createUsageTriggerDataSchema = z.object({
  body: z
    .object({
      CallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      CallbackUrl: z.string(),
      FriendlyName: z.string().optional(),
      Recurring: usageTriggerEnumRecurringSchema.optional(),
      TriggerBy: usageTriggerEnumTriggerFieldSchema.optional(),
      TriggerValue: z.string(),
      UsageCategory: usageTriggerEnumUsageCategorySchema,
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
  }),
});

export const createUsageTriggerResponseSchema = apiV2010AccountUsageUsageTriggerSchema;

export const createUsageTriggerErrorSchema = z.unknown();

export const deleteUsageTriggerDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const deleteUsageTriggerResponseSchema = z.any();

export const deleteUsageTriggerErrorSchema = z.unknown();

export const fetchUsageTriggerDataSchema = z.object({
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const fetchUsageTriggerResponseSchema = apiV2010AccountUsageUsageTriggerSchema;

export const fetchUsageTriggerErrorSchema = z.unknown();

export const updateUsageTriggerDataSchema = z.object({
  body: z
    .object({
      CallbackMethod: z
        .union([
          z.literal('HEAD'),
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PATCH'),
          z.literal('PUT'),
          z.literal('DELETE'),
        ])
        .optional(),
      CallbackUrl: z.string().optional(),
      FriendlyName: z.string().optional(),
    })
    .optional(),
  path: z.object({
    AccountSid: z.string(),
    Sid: z.string(),
  }),
});

export const updateUsageTriggerResponseSchema = apiV2010AccountUsageUsageTriggerSchema;

export const updateUsageTriggerErrorSchema = z.unknown();

export const fetchAccountDataSchema = z.object({
  path: z.object({
    Sid: z.string(),
  }),
});

export const fetchAccountResponseSchema = apiV2010AccountSchema;

export const fetchAccountErrorSchema = z.unknown();

export const updateAccountDataSchema = z.object({
  body: z
    .object({
      FriendlyName: z.string().optional(),
      Status: accountEnumStatusSchema.optional(),
    })
    .optional(),
  path: z.object({
    Sid: z.string(),
  }),
});

export const updateAccountResponseSchema = apiV2010AccountSchema;

export const updateAccountErrorSchema = z.unknown();

export const fetchHealthCheckResponseSchema = z.object({
  status: z.string().optional(),
});

export const fetchHealthCheckErrorSchema = z.unknown();

export const listDependentPhoneNumberResponseSchema = z.object({
  dependent_phone_numbers: z.array(apiV2010AccountAddressDependentPhoneNumberSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listAuthorizedConnectAppResponseSchema = z.object({
  authorized_connect_apps: z.array(apiV2010AccountAuthorizedConnectAppSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listCallResponseSchema = z.object({
  calls: z.array(apiV2010AccountCallSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listCallRecordingResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  recordings: z.array(apiV2010AccountCallCallRecordingSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const createSiprecResponseSchema = apiV2010AccountCallSiprecSchema;

export const createStreamResponseSchema = apiV2010AccountCallStreamSchema;

export const listConferenceResponseSchema = z.object({
  conferences: z.array(apiV2010AccountConferenceSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listParticipantResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  participants: z.array(apiV2010AccountConferenceParticipantSchema).optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listConferenceRecordingResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  recordings: z.array(apiV2010AccountConferenceConferenceRecordingSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listConnectAppResponseSchema = z.object({
  connect_apps: z.array(apiV2010AccountConnectAppSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  incoming_phone_numbers: z.array(apiV2010AccountIncomingPhoneNumberSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberLocalResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  incoming_phone_numbers: z.array(apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberLocalSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberMobileResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  incoming_phone_numbers: z.array(apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberMobileSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listIncomingPhoneNumberTollFreeResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  incoming_phone_numbers: z.array(apiV2010AccountIncomingPhoneNumberIncomingPhoneNumberTollFreeSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listMessageResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  messages: z.array(apiV2010AccountMessageSchema).optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const createMessageFeedbackResponseSchema = apiV2010AccountMessageMessageFeedbackSchema;

export const listRecordingResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  recordings: z.array(apiV2010AccountRecordingSchema).optional(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listRecordingTranscriptionResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  transcriptions: z.array(apiV2010AccountRecordingRecordingTranscriptionSchema).optional(),
  uri: z.string().optional(),
});

export const listRecordingAddOnResultResponseSchema = z.object({
  add_on_results: z.array(apiV2010AccountRecordingRecordingAddOnResultSchema).optional(),
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
});

export const listTranscriptionResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  transcriptions: z.array(apiV2010AccountTranscriptionSchema).optional(),
  uri: z.string().optional(),
});

export const listUsageRecordResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordSchema).optional(),
});

export const listUsageRecordAllTimeResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordAllTimeSchema).optional(),
});

export const listUsageRecordDailyResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordDailySchema).optional(),
});

export const listUsageRecordLastMonthResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordLastMonthSchema).optional(),
});

export const listUsageRecordMonthlyResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordMonthlySchema).optional(),
});

export const listUsageRecordThisMonthResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordThisMonthSchema).optional(),
});

export const listUsageRecordTodayResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordTodaySchema).optional(),
});

export const listUsageRecordYearlyResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordYearlySchema).optional(),
});

export const listUsageRecordYesterdayResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_records: z.array(apiV2010AccountUsageUsageRecordUsageRecordYesterdaySchema).optional(),
});

export const listUsageTriggerResponseSchema = z.object({
  end: z.number().optional(),
  first_page_uri: z.string().optional(),
  next_page_uri: z.string().optional().nullable(),
  page: z.number().optional(),
  page_size: z.number().optional(),
  previous_page_uri: z.string().optional().nullable(),
  start: z.number().optional(),
  uri: z.string().optional(),
  usage_triggers: z.array(apiV2010AccountUsageUsageTriggerSchema).optional(),
});
