// This file is auto-generated by @hey-api/openapi-ts

export type account_enum_status = 'active' | 'suspended' | 'closed';

export type account_enum_type = 'Trial' | 'Full';

export type api_v2010_account = {
  /**
   * The authorization token for this account. This token should be kept a secret, so no sharing.
   */
  auth_token?: string | null;
  /**
   * The date that this account was created, in GMT in RFC 2822 format
   */
  date_created?: string | null;
  /**
   * The date that this account was last updated, in GMT in RFC 2822 format.
   */
  date_updated?: string | null;
  /**
   * A human readable description of this account, up to 64 characters long. By default the FriendlyName is your email address.
   */
  friendly_name?: string | null;
  /**
   * The unique 34 character id that represents the parent of this account. The OwnerAccountSid of a parent account is it's own sid.
   */
  owner_account_sid?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * The status of this account. Usually `active`, but can be `suspended` or `closed`.
   */
  status?: account_enum_status | null;
  /**
   * A Map of various subresources available for the given Account Instance
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The type of this account. Either `Trial` or `Full` if it's been upgraded
   */
  type?: account_enum_type | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
};

export type api_v2010_account_address = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource.
   */
  account_sid?: string | null;
  /**
   * The city in which the address is located.
   */
  city?: string | null;
  /**
   * The name associated with the address.This property has a maximum length of 16 4-byte characters, or 21 3-byte characters.
   */
  customer_name?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * Whether emergency calling has been enabled on this number.
   */
  emergency_enabled?: boolean | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The ISO country code of the address.
   */
  iso_country?: string | null;
  /**
   * The postal code of the address.
   */
  postal_code?: string | null;
  /**
   * The state or region of the address.
   */
  region?: string | null;
  /**
   * The unique string that that we created to identify the Address resource.
   */
  sid?: string | null;
  /**
   * The number and street address of the address.
   */
  street?: string | null;
  /**
   * The additional number and street address of the address.
   */
  street_secondary?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * Whether the address has been validated to comply with local regulation. In countries that require valid addresses, an invalid address will not be accepted. `true` indicates the Address has been validated. `false` indicate the country doesn't require validation or the Address is not valid.
   */
  validated?: boolean | null;
  /**
   * Whether the address has been verified to comply with regulation. In countries that require valid addresses, an invalid address will not be accepted. `true` indicates the Address has been verified. `false` indicate the country doesn't require verified or the Address is not valid.
   */
  verified?: boolean | null;
};

export type api_v2010_account_address_dependent_phone_number = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the DependentPhoneNumber resource.
   */
  account_sid?: string | null;
  /**
   * Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.
   */
  address_requirements?: dependent_phone_number_enum_address_requirement | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * The set of Boolean properties that indicates whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: unknown;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the emergency address configuration that we use for emergency calling from the phone number.
   */
  emergency_address_sid?: string | null;
  /**
   * Whether the phone number is enabled for emergency calling.
   */
  emergency_status?: dependent_phone_number_enum_emergency_status | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify the DependentPhoneNumber resource.
   */
  sid?: string | null;
  /**
   * The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
   */
  sms_application_sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
   */
  trunk_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
   */
  voice_application_sid?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database. Can be: `true` or `false`. Caller ID lookups can cost $0.01 each.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.
   */
  voice_url?: string | null;
};

/**
 * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
 */
export type sms_fallback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

/**
 * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
 */
export type sms_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

/**
 * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
 */
export type status_callback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

/**
 * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
 */
export type voice_fallback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

/**
 * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
 */
export type voice_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

export type api_v2010_account_application = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The URL we call using a POST method to send message status information to your application.
   */
  message_status_callback?: string | null;
  /**
   * Whether to allow other Twilio accounts to dial this applicaton using Dial verb. Can be: `true` or `false`.
   */
  public_application_connect_enabled?: boolean | null;
  /**
   * The unique string that that we created to identify the Application resource.
   */
  sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call using a POST method to send status information to your application about SMS messages that refer to the application.
   */
  sms_status_callback?: string | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database (additional charges apply). Can be: `true` or `false`.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number assigned to this application receives a call.
   */
  voice_url?: string | null;
};

export type api_v2010_account_authorized_connect_app = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the AuthorizedConnectApp resource.
   */
  account_sid?: string | null;
  /**
   * The company name set for the Connect App.
   */
  connect_app_company_name?: string | null;
  /**
   * A detailed description of the Connect App.
   */
  connect_app_description?: string | null;
  /**
   * The name of the Connect App.
   */
  connect_app_friendly_name?: string | null;
  /**
   * The public URL for the Connect App.
   */
  connect_app_homepage_url?: string | null;
  /**
   * The SID that we assigned to the Connect App.
   */
  connect_app_sid?: string | null;
  /**
   * The set of permissions that you authorized for the Connect App.  Can be: `get-all` or `post-all`.
   */
  permissions?: Array<authorized_connect_app_enum_permission> | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_available_phone_number_country = {
  /**
   * Whether all phone numbers available in the country are new to the Twilio platform. `true` if they are and `false` if all numbers are not in the Twilio Phone Number Beta program.
   */
  beta?: boolean | null;
  /**
   * The name of the country.
   */
  country?: string | null;
  /**
   * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country.
   */
  country_code?: string | null;
  /**
   * A list of related AvailablePhoneNumber resources identified by their URIs relative to `https://api.twilio.com`.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the Country resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_local = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_machine_to_machine = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_mobile = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_national = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_shared_cost = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_toll_free = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_available_phone_number_country_available_phone_number_voip = {
  /**
   * The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.
   */
  address_requirements?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * A formatted version of the phone number.
   */
  friendly_name?: string | null;
  /**
   * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.
   */
  iso_country?: string | null;
  /**
   * The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.
   */
  lata?: string | null;
  /**
   * The latitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  latitude?: number | null;
  /**
   * The locality or city of this phone number's location.
   */
  locality?: string | null;
  /**
   * The longitude of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  longitude?: number | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  postal_code?: string | null;
  /**
   * The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.
   */
  rate_center?: string | null;
  /**
   * The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.
   */
  region?: string | null;
};

export type api_v2010_account_balance = {
  /**
   * The unique SID identifier of the Account.
   */
  account_sid?: string | null;
  /**
   * The balance of the Account, in units specified by the unit parameter. Balance changes may not be reflected immediately. Child accounts do not contain balance information
   */
  balance?: string | null;
  /**
   * The units of currency for the account balance
   */
  currency?: string | null;
};

export type api_v2010_account_call = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Call resource.
   */
  account_sid?: string | null;
  /**
   * Either `human` or `machine` if this call was initiated with answering machine detection. Empty otherwise.
   */
  answered_by?: string | null;
  /**
   * The API version used to create the call.
   */
  api_version?: string | null;
  /**
   * The caller's name if this call was an incoming call to a phone number with caller ID Lookup enabled. Otherwise, empty.
   */
  caller_name?: string | null;
  /**
   * The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A string describing the direction of the call. Can be: `inbound` for inbound calls, `outbound-api` for calls initiated via the REST API or `outbound-dial` for calls initiated by a `<Dial>` verb. Using [Elastic SIP Trunking](https://www.twilio.com/docs/sip-trunking), the values can be [`trunking-terminating`](https://www.twilio.com/docs/sip-trunking#termination) for outgoing calls from your communications infrastructure to the PSTN or [`trunking-originating`](https://www.twilio.com/docs/sip-trunking#origination) for incoming calls to your communications infrastructure from the PSTN.
   */
  direction?: string | null;
  /**
   * The length of the call in seconds. This value is empty for busy, failed, unanswered, or ongoing calls.
   */
  duration?: string | null;
  /**
   * The time the call ended, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format. Empty if the call did not complete successfully.
   */
  end_time?: string | null;
  /**
   * The forwarding phone number if this call was an incoming call forwarded from another number (depends on carrier supporting forwarding). Otherwise, empty.
   */
  forwarded_from?: string | null;
  /**
   * The phone number, SIP address, Client identifier or SIM SID that made this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). SIP addresses are formatted as `name@company.com`. Client identifiers are formatted `client:name`. SIM SIDs are formatted as `sim:sid`.
   */
  from?: string | null;
  /**
   * The calling phone number, SIP address, or Client identifier formatted for display. Non-North American phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +442071838750).
   */
  from_formatted?: string | null;
  /**
   * The Group SID associated with this call. If no Group is associated with the call, the field is empty.
   */
  group_sid?: string | null;
  /**
   * The SID that identifies the call that created this leg.
   */
  parent_call_sid?: string | null;
  /**
   * If the call was inbound, this is the SID of the IncomingPhoneNumber resource that received the call. If the call was outbound, it is the SID of the OutgoingCallerId resource from which the call was placed.
   */
  phone_number_sid?: string | null;
  /**
   * The charge for this call, in the currency associated with the account. Populated after the call is completed. May not be immediately available.
   */
  price?: string | null;
  /**
   * The currency in which `Price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g., `USD`, `EUR`, `JPY`). Always capitalized for calls.
   */
  price_unit?: string | null;
  /**
   * The wait time in milliseconds before the call is placed.
   */
  queue_time?: string | null;
  /**
   * The unique string that we created to identify this Call resource.
   */
  sid?: string | null;
  /**
   * The start time of the call, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format. Empty if the call has not yet been dialed.
   */
  start_time?: string | null;
  /**
   * The status of this call. Can be: `queued`, `ringing`, `in-progress`, `canceled`, `completed`, `failed`, `busy` or `no-answer`. See [Call Status Values](https://www.twilio.com/docs/voice/api/call-resource#call-status-values) below for more information.
   */
  status?: call_enum_status | null;
  /**
   * A list of subresources available to this call, identified by their URIs relative to `https://api.twilio.com`.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The phone number, SIP address, Client identifier or SIM SID that received this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). SIP addresses are formatted as `name@company.com`. Client identifiers are formatted `client:name`. SIM SIDs are formatted as `sim:sid`.
   */
  to?: string | null;
  /**
   * The phone number, SIP address or Client identifier that received this call. Formatted for display. Non-North American phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +442071838750).
   */
  to_formatted?: string | null;
  /**
   * The unique identifier of the trunk resource that was used for this call. The field is empty if the call was not made using a SIP trunk or if the call is not terminated.
   */
  trunk_sid?: string | null;
  /**
   * The URI of this resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_call_event = {
  /**
   * Contains a dictionary representing the request of the call.
   */
  request?: unknown;
  /**
   * Contains a dictionary representing the call response, including a list of the call events.
   */
  response?: unknown;
};

export type api_v2010_account_call_call_notification = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the Call Notification resource.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Call Notification resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  error_code?: string | null;
  /**
   * An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.
   */
  log?: string | null;
  /**
   * The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.
   */
  message_date?: string | null;
  /**
   * The text of the notification.
   */
  message_text?: string | null;
  /**
   * The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  more_info?: string | null;
  /**
   * The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.
   */
  request_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.
   */
  request_url?: string | null;
  /**
   * The unique string that that we created to identify the Call Notification resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

/**
 * The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.
 */
export type request_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

export type api_v2010_account_call_call_notification_instance = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the Call Notification resource.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Call Notification resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  error_code?: string | null;
  /**
   * An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.
   */
  log?: string | null;
  /**
   * The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.
   */
  message_date?: string | null;
  /**
   * The text of the notification.
   */
  message_text?: string | null;
  /**
   * The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  more_info?: string | null;
  /**
   * The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.
   */
  request_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.
   */
  request_url?: string | null;
  /**
   * The HTTP GET or POST variables we sent to your server. However, if the notification was generated by our REST API, this contains the HTTP POST or PUT variables you sent to our API.
   */
  request_variables?: string | null;
  /**
   * The HTTP body returned by your server.
   */
  response_body?: string | null;
  /**
   * The HTTP headers returned by your server.
   */
  response_headers?: string | null;
  /**
   * The unique string that that we created to identify the Call Notification resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_call_recording = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to make the recording.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Recording resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The number of channels in the final recording file.  Can be: `1`, or `2`. Separating a two leg call into two separate channels of the recording file is supported in [Dial](https://www.twilio.com/docs/voice/twiml/dial#attributes-record) and [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls) record options.
   */
  channels?: number | null;
  /**
   * The Conference SID that identifies the conference associated with the recording, if a conference recording.
   */
  conference_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The length of the recording in seconds.
   */
  duration?: string | null;
  /**
   * How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.
   */
  encryption_details?: unknown;
  /**
   * The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.
   */
  error_code?: number | null;
  /**
   * The one-time cost of creating the recording in the `price_unit` currency.
   */
  price?: number | null;
  /**
   * The currency used in the `price` property. Example: `USD`.
   */
  price_unit?: string | null;
  /**
   * The unique string that that we created to identify the Recording resource.
   */
  sid?: string | null;
  /**
   * How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, and `StartConferenceRecordingAPI`.
   */
  source?: call_recording_enum_source | null;
  /**
   * The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  start_time?: string | null;
  /**
   * The status of the recording. Can be: `processing`, `completed` and `absent`. For more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).
   */
  status?: call_recording_enum_status | null;
  /**
   * The recorded track. Can be: `inbound`, `outbound`, or `both`.
   */
  track?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_payments = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Payments resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Payments resource is associated with. This will refer to the call sid that is producing the payment card (credit/ACH) information thru DTMF.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the Payments resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_siprec = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Siprec resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Siprec resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The user-specified name of this Siprec, if one was given when the Siprec was created. This may be used to stop the Siprec.
   */
  name?: string | null;
  /**
   * The SID of the Siprec resource.
   */
  sid?: string | null;
  /**
   * The status - one of `stopped`, `in-progress`
   */
  status?: siprec_enum_status | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_stream = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Stream resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Stream resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The user-specified name of this Stream, if one was given when the Stream was created. This may be used to stop the Stream.
   */
  name?: string | null;
  /**
   * The SID of the Stream resource.
   */
  sid?: string | null;
  /**
   * The status - one of `stopped`, `in-progress`
   */
  status?: stream_enum_status | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_call_user_defined_message = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created User Defined Message.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message is associated with.
   */
  call_sid?: string | null;
  /**
   * The date that this User Defined Message was created, given in RFC 2822 format.
   */
  date_created?: string | null;
  /**
   * The SID that uniquely identifies this User Defined Message.
   */
  sid?: string | null;
};

export type api_v2010_account_call_user_defined_message_subscription = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that subscribed to the User Defined Messages.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message Subscription is associated with. This refers to the Call SID that is producing the User Defined Messages.
   */
  call_sid?: string | null;
  /**
   * The date that this User Defined Message Subscription was created, given in RFC 2822 format.
   */
  date_created?: string | null;
  /**
   * The SID that uniquely identifies this User Defined Message Subscription.
   */
  sid?: string | null;
  /**
   * The URI of the User Defined Message Subscription Resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_conference = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Conference resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create this conference.
   */
  api_version?: string | null;
  /**
   * The call SID that caused the conference to end.
   */
  call_sid_ending_conference?: string | null;
  /**
   * The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A string that you assigned to describe this conference room. Maxiumum length is 128 characters.
   */
  friendly_name?: string | null;
  /**
   * The reason why a conference ended. When a conference is in progress, will be `null`. When conference is completed, can be: `conference-ended-via-api`, `participant-with-end-conference-on-exit-left`, `participant-with-end-conference-on-exit-kicked`, `last-participant-kicked`, or `last-participant-left`.
   */
  reason_conference_ended?: conference_enum_reason_conference_ended | null;
  /**
   * A string that represents the Twilio Region where the conference audio was mixed. May be `us1`, `ie1`,  `de1`, `sg1`, `br1`, `au1`, and `jp1`. Basic conference audio will always be mixed in `us1`. Global Conference audio will be mixed nearest to the majority of participants.
   */
  region?: string | null;
  /**
   * The unique string that that we created to identify this Conference resource.
   */
  sid?: string | null;
  /**
   * The status of this conference. Can be: `init`, `in-progress`, or `completed`.
   */
  status?: conference_enum_status | null;
  /**
   * A list of related resources identified by their URIs relative to `https://api.twilio.com`.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of this resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_conference_conference_recording = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the recording.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Conference Recording resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The number of channels in the final recording file.  Can be: `1`, or `2`. Separating a two leg call into two separate channels of the recording file is supported in [Dial](https://www.twilio.com/docs/voice/twiml/dial#attributes-record) and [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls) record options.
   */
  channels?: number | null;
  /**
   * The Conference SID that identifies the conference associated with the recording.
   */
  conference_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The length of the recording in seconds.
   */
  duration?: string | null;
  /**
   * How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.
   */
  encryption_details?: unknown;
  /**
   * The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.
   */
  error_code?: number | null;
  /**
   * The one-time cost of creating the recording in the `price_unit` currency.
   */
  price?: string | null;
  /**
   * The currency used in the `price` property. Example: `USD`.
   */
  price_unit?: string | null;
  /**
   * The unique string that that we created to identify the Conference Recording resource.
   */
  sid?: string | null;
  /**
   * How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, `StartConferenceRecordingAPI`.
   */
  source?: conference_recording_enum_source | null;
  /**
   * The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  start_time?: string | null;
  /**
   * The status of the recording. Can be: `processing`, `completed` and `absent`. For more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).
   */
  status?: conference_recording_enum_status | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_conference_participant = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Participant resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The SID of the participant who is being `coached`. The participant being coached is the only participant who can hear the participant who is `coaching`.
   */
  call_sid_to_coach?: string | null;
  /**
   * Whether the participant is coaching another call. Can be: `true` or `false`. If not present, defaults to `false` unless `call_sid_to_coach` is defined. If `true`, `call_sid_to_coach` must be defined.
   */
  coaching?: boolean | null;
  /**
   * The SID of the conference the participant is in.
   */
  conference_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * Whether the conference ends when the participant leaves. Can be: `true` or `false` and the default is `false`. If `true`, the conference ends and all other participants drop out when the participant leaves.
   */
  end_conference_on_exit?: boolean | null;
  /**
   * Whether the participant is on hold. Can be `true` or `false`.
   */
  hold?: boolean | null;
  /**
   * The user-specified label of this participant, if one was given when the participant was created. This may be used to fetch, update or delete the participant.
   */
  label?: string | null;
  /**
   * Whether the participant is muted. Can be `true` or `false`.
   */
  muted?: boolean | null;
  /**
   * Whether the conference starts when the participant joins the conference, if it has not already started. Can be: `true` or `false` and the default is `true`. If `false` and the conference has not started, the participant is muted and hears background music until another participant starts the conference.
   */
  start_conference_on_enter?: boolean | null;
  /**
   * The status of the participant's call in a session. Can be: `queued`, `connecting`, `ringing`, `connected`, `complete`, or `failed`.
   */
  status?: participant_enum_status | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_connect_app = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resource.
   */
  account_sid?: string | null;
  /**
   * The URL we redirect the user to after we authenticate the user and obtain authorization to access the Connect App.
   */
  authorize_redirect_url?: string | null;
  /**
   * The company name set for the Connect App.
   */
  company_name?: string | null;
  /**
   * The HTTP method we use to call `deauthorize_callback_url`.
   */
  deauthorize_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call using the `deauthorize_callback_method` to de-authorize the Connect App.
   */
  deauthorize_callback_url?: string | null;
  /**
   * The description of the Connect App.
   */
  description?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The public URL where users can obtain more information about this Connect App.
   */
  homepage_url?: string | null;
  /**
   * The set of permissions that your ConnectApp requests.
   */
  permissions?: Array<connect_app_enum_permission> | null;
  /**
   * The unique string that that we created to identify the ConnectApp resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

/**
 * The HTTP method we use to call `deauthorize_callback_url`.
 */
export type deauthorize_callback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

export type api_v2010_account_incoming_phone_number = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this IncomingPhoneNumber resource.
   */
  account_sid?: string | null;
  /**
   * Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.
   */
  address_requirements?: incoming_phone_number_enum_address_requirement | null;
  /**
   * The SID of the Address resource associated with the phone number.
   */
  address_sid?: string | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
   */
  bundle_sid?: string | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the emergency address configuration that we use for emergency calling from this phone number.
   */
  emergency_address_sid?: string | null;
  /**
   * The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.
   */
  emergency_address_status?: incoming_phone_number_enum_emergency_address_status | null;
  /**
   * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
   */
  emergency_status?: incoming_phone_number_enum_emergency_status | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.
   */
  identity_sid?: string | null;
  /**
   * The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.
   */
  origin?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify this IncomingPhoneNumber resource.
   */
  sid?: string | null;
  /**
   * The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
   */
  sms_application_sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  status?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
   */
  trunk_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
   */
  voice_application_sid?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  voice_receive_mode?: incoming_phone_number_enum_voice_receive_mode | null;
  /**
   * The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.
   */
  voice_url?: string | null;
};

export type api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.
   */
  account_sid?: string | null;
  /**
   * A JSON string that represents the current configuration of this Add-on installation.
   */
  configuration?: unknown;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A short description of the functionality that the Add-on provides.
   */
  description?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The SID of the Phone Number to which the Add-on is assigned.
   */
  resource_sid?: string | null;
  /**
   * The unique string that that we created to identify the resource.
   */
  sid?: string | null;
  /**
   * A list of related resources identified by their relative URIs.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.
   */
  unique_name?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on_incoming_phone_number_assigned_add_on_extension =
  {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.
     */
    account_sid?: string | null;
    /**
     * The SID that uniquely identifies the assigned Add-on installation.
     */
    assigned_add_on_sid?: string | null;
    /**
     * Whether the Extension will be invoked.
     */
    enabled?: boolean | null;
    /**
     * The string that you assigned to describe the resource.
     */
    friendly_name?: string | null;
    /**
     * A string that you assigned to describe the Product this Extension is used within.
     */
    product_name?: string | null;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    resource_sid?: string | null;
    /**
     * The unique string that that we created to identify the resource.
     */
    sid?: string | null;
    /**
     * An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.
     */
    unique_name?: string | null;
    /**
     * The URI of the resource, relative to `https://api.twilio.com`.
     */
    uri?: string | null;
  };

export type api_v2010_account_incoming_phone_number_incoming_phone_number_local = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.
   */
  account_sid?: string | null;
  /**
   * Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.
   */
  address_requirements?: incoming_phone_number_local_enum_address_requirement | null;
  /**
   * The SID of the Address resource associated with the phone number.
   */
  address_sid?: string | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
   */
  bundle_sid?: string | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the emergency address configuration that we use for emergency calling from this phone number.
   */
  emergency_address_sid?: string | null;
  /**
   * The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.
   */
  emergency_address_status?: incoming_phone_number_local_enum_emergency_address_status | null;
  /**
   * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
   */
  emergency_status?: incoming_phone_number_local_enum_emergency_status | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.
   */
  identity_sid?: string | null;
  /**
   * The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.
   */
  origin?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify the resource.
   */
  sid?: string | null;
  /**
   * The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
   */
  sms_application_sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  status?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
   */
  trunk_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
   */
  voice_application_sid?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  voice_receive_mode?: incoming_phone_number_local_enum_voice_receive_mode | null;
  /**
   * The URL we call when this phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.
   */
  voice_url?: string | null;
};

export type api_v2010_account_incoming_phone_number_incoming_phone_number_mobile = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.
   */
  account_sid?: string | null;
  /**
   * Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.
   */
  address_requirements?: incoming_phone_number_mobile_enum_address_requirement | null;
  /**
   * The SID of the Address resource associated with the phone number.
   */
  address_sid?: string | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
   */
  bundle_sid?: string | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the emergency address configuration that we use for emergency calling from this phone number.
   */
  emergency_address_sid?: string | null;
  /**
   * The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.
   */
  emergency_address_status?: incoming_phone_number_mobile_enum_emergency_address_status | null;
  /**
   * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
   */
  emergency_status?: incoming_phone_number_mobile_enum_emergency_status | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.
   */
  identity_sid?: string | null;
  /**
   * The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.
   */
  origin?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify the resource.
   */
  sid?: string | null;
  /**
   * The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
   */
  sms_application_sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  status?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
   */
  trunk_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
   */
  voice_application_sid?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  voice_receive_mode?: incoming_phone_number_mobile_enum_voice_receive_mode | null;
  /**
   * The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.
   */
  voice_url?: string | null;
};

export type api_v2010_account_incoming_phone_number_incoming_phone_number_toll_free = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.
   */
  account_sid?: string | null;
  /**
   * Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.
   */
  address_requirements?: incoming_phone_number_toll_free_enum_address_requirement | null;
  /**
   * The SID of the Address resource associated with the phone number.
   */
  address_sid?: string | null;
  /**
   * The API version used to start a new TwiML session.
   */
  api_version?: string | null;
  /**
   * Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.
   */
  beta?: boolean | null;
  /**
   * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
   */
  bundle_sid?: string | null;
  /**
   * The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.
   */
  capabilities?: {
    fax?: boolean;
    mms?: boolean;
    sms?: boolean;
    voice?: boolean;
  } | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the emergency address configuration that we use for emergency calling from this phone number.
   */
  emergency_address_sid?: string | null;
  /**
   * The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.
   */
  emergency_address_status?: incoming_phone_number_toll_free_enum_emergency_address_status | null;
  /**
   * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
   */
  emergency_status?: incoming_phone_number_toll_free_enum_emergency_status | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.
   */
  identity_sid?: string | null;
  /**
   * The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.
   */
  origin?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify the resource.
   */
  sid?: string | null;
  /**
   * The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
   */
  sms_application_sid?: string | null;
  /**
   * The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when the phone number receives an incoming SMS message.
   */
  sms_url?: string | null;
  status?: string | null;
  /**
   * The URL we call using the `status_callback_method` to send status information to your application.
   */
  status_callback?: string | null;
  /**
   * The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.
   */
  status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
   */
  trunk_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
   */
  voice_application_sid?: string | null;
  /**
   * Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.
   */
  voice_caller_id_lookup?: boolean | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  voice_receive_mode?: incoming_phone_number_toll_free_enum_voice_receive_mode | null;
  /**
   * The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.
   */
  voice_url?: string | null;
};

export type api_v2010_account_key = {
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The unique string that that we created to identify the Key resource.
   */
  sid?: string | null;
};

export type api_v2010_account_message = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resource
   */
  account_sid?: string | null;
  /**
   * The API version used to process the Message
   */
  api_version?: string | null;
  /**
   * The text content of the message
   */
  body?: string | null;
  /**
   * The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message resource was created
   */
  date_created?: string | null;
  /**
   * The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message was sent. For an outgoing message, this is when Twilio sent the message. For an incoming message, this is when Twilio sent the HTTP request to your incoming message webhook URL.
   */
  date_sent?: string | null;
  /**
   * The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message resource was last updated
   */
  date_updated?: string | null;
  /**
   * The direction of the message. Can be: `inbound` for incoming messages, `outbound-api` for messages created by the REST API, `outbound-call` for messages created during a call, or `outbound-reply` for messages created in response to an incoming message.
   */
  direction?: message_enum_direction | null;
  /**
   * The [error code](https://www.twilio.com/docs/api/errors) returned if the Message `status` is `failed` or `undelivered`. If no error was encountered, the value is `null`.
   */
  error_code?: number | null;
  /**
   * The description of the `error_code` if the Message `status` is `failed` or `undelivered`. If no error was encountered, the value is `null`.
   */
  error_message?: string | null;
  /**
   * The sender's phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format), [alphanumeric sender ID](https://www.twilio.com/docs/sms/quickstart), [Wireless SIM](https://www.twilio.com/docs/iot/wireless/programmable-wireless-send-machine-machine-sms-commands), [short code](https://www.twilio.com/en-us/messaging/channels/sms/short-codes), or  [channel address](https://www.twilio.com/docs/messaging/channels) (e.g., `whatsapp:+15554449999`). For incoming messages, this is the number or channel address of the sender. For outgoing messages, this value is a Twilio phone number, alphanumeric sender ID, short code, or channel address from which the message is sent.
   */
  from?: string | null;
  /**
   * The SID of the [Messaging Service](https://www.twilio.com/docs/messaging/api/service-resource) associated with the Message resource. The value is `null` if a Messaging Service was not used.
   */
  messaging_service_sid?: string | null;
  /**
   * The number of media files associated with the Message resource.
   */
  num_media?: string | null;
  /**
   * The number of segments that make up the complete message. SMS message bodies that exceed the [character limit](https://www.twilio.com/docs/glossary/what-sms-character-limit) are segmented and charged as multiple messages. Note: For messages sent via a Messaging Service, `num_segments` is initially `0`, since a sender hasn't yet been assigned.
   */
  num_segments?: string | null;
  /**
   * The amount billed for the message in the currency specified by `price_unit`. The `price` is populated after the message has been sent/received, and may not be immediately availalble. View the [Pricing page](https://www.twilio.com/en-us/pricing) for more details.
   */
  price?: string | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).
   */
  price_unit?: string | null;
  /**
   * The unique, Twilio-provided string that identifies the Message resource.
   */
  sid?: string | null;
  /**
   * The status of the Message. Possible values: `accepted`, `scheduled`, `canceled`, `queued`, `sending`, `sent`, `failed`, `delivered`, `undelivered`, `receiving`, `received`, or `read` (WhatsApp only). For more information, See [detailed descriptions](https://www.twilio.com/docs/sms/api/message-resource#message-status-values).
   */
  status?: message_enum_status | null;
  /**
   * A list of related resources identified by their URIs relative to `https://api.twilio.com`
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The recipient's phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format) or [channel address](https://www.twilio.com/docs/messaging/channels) (e.g. `whatsapp:+15552229999`)
   */
  to?: string | null;
  /**
   * The URI of the Message resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_message_media = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with this Media resource.
   */
  account_sid?: string | null;
  /**
   * The default [MIME type](https://en.wikipedia.org/wiki/Internet_media_type) of the media, for example `image/jpeg`, `image/png`, or `image/gif`.
   */
  content_type?: string | null;
  /**
   * The date and time in GMT when this Media resource was created, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT when this Media resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the Message resource that is associated with this Media resource.
   */
  parent_sid?: string | null;
  /**
   * The unique string that identifies this Media resource.
   */
  sid?: string | null;
  /**
   * The URI of this Media resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_message_message_feedback = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with this MessageFeedback resource.
   */
  account_sid?: string | null;
  /**
   * The date and time in GMT when this MessageFeedback resource was created, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT when this MessageFeedback resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the Message resource associated with this MessageFeedback resource.
   */
  message_sid?: string | null;
  /**
   * Reported outcome indicating whether there is confirmation that the Message recipient performed a tracked user action. Can be: `unconfirmed` or `confirmed`. For more details see [How to Optimize Message Deliverability with Message Feedback](https://www.twilio.com/docs/messaging/guides/send-message-feedback-to-twilio).
   */
  outcome?: message_feedback_enum_outcome | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_new_key = {
  /**
   * The date and time in GMT that the API Key was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the new API Key was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The secret your application uses to sign Access Tokens and to authenticate to the REST API (you will use this as the basic-auth `password`).  **Note that for security reasons, this field is ONLY returned when the API Key is first created.**
   */
  secret?: string | null;
  /**
   * The unique string that that we created to identify the NewKey resource. You will use this as the basic-auth `user` when authenticating to the API.
   */
  sid?: string | null;
};

export type api_v2010_account_new_signing_key = {
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The secret your application uses to sign Access Tokens and to authenticate to the REST API (you will use this as the basic-auth `password`).  **Note that for security reasons, this field is ONLY returned when the API Key is first created.**
   */
  secret?: string | null;
  /**
   * The unique string that that we created to identify the NewSigningKey resource.
   */
  sid?: string | null;
};

export type api_v2010_account_notification = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to generate the notification. Can be empty for events that don't have a specific API version, such as incoming phone calls.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Notification resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  error_code?: string | null;
  /**
   * An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.
   */
  log?: string | null;
  /**
   * The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.
   */
  message_date?: string | null;
  /**
   * The text of the notification.
   */
  message_text?: string | null;
  /**
   * The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  more_info?: string | null;
  /**
   * The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.
   */
  request_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.
   */
  request_url?: string | null;
  /**
   * The unique string that that we created to identify the Notification resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_notification_instance = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to generate the notification. Can be empty for events that don't have a specific API version, such as incoming phone calls.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Notification resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  error_code?: string | null;
  /**
   * An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.
   */
  log?: string | null;
  /**
   * The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.
   */
  message_date?: string | null;
  /**
   * The text of the notification.
   */
  message_text?: string | null;
  /**
   * The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).
   */
  more_info?: string | null;
  /**
   * The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.
   */
  request_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.
   */
  request_url?: string | null;
  /**
   * The HTTP GET or POST variables we sent to your server. However, if the notification was generated by our REST API, this contains the HTTP POST or PUT variables you sent to our API.
   */
  request_variables?: string | null;
  /**
   * The HTTP body returned by your server.
   */
  response_body?: string | null;
  /**
   * The HTTP headers returned by your server.
   */
  response_headers?: string | null;
  /**
   * The unique string that that we created to identify the Notification resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_outgoing_caller_id = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resource.
   */
  account_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The unique string that that we created to identify the OutgoingCallerId resource.
   */
  sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_queue = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Queue resource.
   */
  account_sid?: string | null;
  /**
   *  The average wait time in seconds of the members in this queue. This is calculated at the time of the request.
   */
  average_wait_time?: number | null;
  /**
   * The number of calls currently in the queue.
   */
  current_size?: number | null;
  /**
   * The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A string that you assigned to describe this resource.
   */
  friendly_name?: string | null;
  /**
   *  The maximum number of calls that can be in the queue. The default is 1000 and the maximum is 5000.
   */
  max_size?: number | null;
  /**
   * The unique string that that we created to identify this Queue resource.
   */
  sid?: string | null;
  /**
   * The URI of this resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_queue_member = {
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Member resource is associated with.
   */
  call_sid?: string | null;
  /**
   * The date that the member was enqueued, given in RFC 2822 format.
   */
  date_enqueued?: string | null;
  /**
   * This member's current position in the queue.
   */
  position?: number | null;
  /**
   * The SID of the Queue the member is in.
   */
  queue_sid?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The number of seconds the member has been in the queue.
   */
  wait_time?: number | null;
};

export type api_v2010_account_recording = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource.
   */
  account_sid?: string | null;
  /**
   * The API version used during the recording.
   */
  api_version?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Recording resource is associated with. This will always refer to the parent leg of a two-leg call.
   */
  call_sid?: string | null;
  /**
   * The number of channels in the final recording file. Can be: `1` or `2`. You can split a call with two legs into two separate recording channels if you record using [TwiML Dial](https://www.twilio.com/docs/voice/twiml/dial#record) or the [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls#manage-your-outbound-call).
   */
  channels?: number | null;
  /**
   * The Conference SID that identifies the conference associated with the recording, if a conference recording.
   */
  conference_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The length of the recording in seconds.
   */
  duration?: string | null;
  /**
   * How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.
   */
  encryption_details?: unknown;
  /**
   * The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.
   */
  error_code?: number | null;
  /**
   * The URL of the media file associated with this recording resource. When stored externally, this is the full URL location of the media file.
   */
  media_url?: string | null;
  /**
   * The one-time cost of creating the recording in the `price_unit` currency.
   */
  price?: string | null;
  /**
   * The currency used in the `price` property. Example: `USD`.
   */
  price_unit?: string | null;
  /**
   * The unique string that that we created to identify the Recording resource.
   */
  sid?: string | null;
  /**
   * How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, and `StartConferenceRecordingAPI`.
   */
  source?: recording_enum_source | null;
  /**
   * The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  start_time?: string | null;
  /**
   * The status of the recording. Can be: `processing`, `completed`, `absent` or `deleted`. For information about more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).
   */
  status?: recording_enum_status | null;
  /**
   * A list of related resources identified by their relative URIs.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_recording_recording_add_on_result = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the Add-on configuration.
   */
  add_on_configuration_sid?: string | null;
  /**
   * The SID of the Add-on to which the result belongs.
   */
  add_on_sid?: string | null;
  /**
   * The date and time in GMT that the result was completed specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_completed?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The SID of the recording to which the AddOnResult resource belongs.
   */
  reference_sid?: string | null;
  /**
   * The unique string that that we created to identify the Recording AddOnResult resource.
   */
  sid?: string | null;
  /**
   * The status of the result. Can be: `canceled`, `completed`, `deleted`, `failed`, `in-progress`, `init`, `processing`, `queued`.
   */
  status?: recording_add_on_result_enum_status | null;
  /**
   * A list of related resources identified by their relative URIs.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
};

export type api_v2010_account_recording_recording_add_on_result_recording_add_on_result_payload = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult Payload resource.
   */
  account_sid?: string | null;
  /**
   * The SID of the Add-on configuration.
   */
  add_on_configuration_sid?: string | null;
  /**
   * The SID of the AddOnResult to which the payload belongs.
   */
  add_on_result_sid?: string | null;
  /**
   * The SID of the Add-on to which the result belongs.
   */
  add_on_sid?: string | null;
  /**
   * The MIME type of the payload.
   */
  content_type?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string provided by the vendor that describes the payload.
   */
  label?: string | null;
  /**
   * The SID of the recording to which the AddOnResult resource that contains the payload belongs.
   */
  reference_sid?: string | null;
  /**
   * The unique string that that we created to identify the Recording AddOnResult Payload resource.
   */
  sid?: string | null;
  /**
   * A list of related resources identified by their relative URIs.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
};

export type api_v2010_account_recording_recording_transcription = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the transcription.
   */
  api_version?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The duration of the transcribed audio in seconds.
   */
  duration?: string | null;
  /**
   * The charge for the transcript in the currency associated with the account. This value is populated after the transcript is complete so it may not be available immediately.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).
   */
  price_unit?: string | null;
  /**
   * The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) from which the transcription was created.
   */
  recording_sid?: string | null;
  /**
   * The unique string that that we created to identify the Transcription resource.
   */
  sid?: string | null;
  /**
   * The status of the transcription. Can be: `in-progress`, `completed`, `failed`.
   */
  status?: recording_transcription_enum_status | null;
  /**
   * The text content of the transcription.
   */
  transcription_text?: string | null;
  /**
   * The transcription type.
   */
  type?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_short_code = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this ShortCode resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to start a new TwiML session when an SMS message is sent to this short code.
   */
  api_version?: string | null;
  /**
   * The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * A string that you assigned to describe this resource. By default, the `FriendlyName` is the short code.
   */
  friendly_name?: string | null;
  /**
   * The short code. e.g., 894546.
   */
  short_code?: string | null;
  /**
   * The unique string that that we created to identify this ShortCode resource.
   */
  sid?: string | null;
  /**
   * The HTTP method we use to call the `sms_fallback_url`. Can be: `GET` or `POST`.
   */
  sms_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call if an error occurs while retrieving or executing the TwiML from `sms_url`.
   */
  sms_fallback_url?: string | null;
  /**
   * The HTTP method we use to call the `sms_url`. Can be: `GET` or `POST`.
   */
  sms_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call when receiving an incoming SMS message to this short code.
   */
  sms_url?: string | null;
  /**
   * The URI of this resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_signing_key = {
  date_created?: string | null;
  date_updated?: string | null;
  friendly_name?: string | null;
  sid?: string | null;
};

export type api_v2010_account_sip = {
  [key: string]: unknown;
};

export type api_v2010_account_sip_sip_credential_list = {
  /**
   * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) that owns this resource.
   */
  account_sid?: string | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * A human readable descriptive text that describes the CredentialList, up to 64 characters long.
   */
  friendly_name?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * A list of credentials associated with this credential list.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_sip_sip_credential_list_sip_credential = {
  /**
   * The unique id of the Account that is responsible for this resource.
   */
  account_sid?: string | null;
  /**
   * The unique id that identifies the credential list that includes this credential.
   */
  credential_list_sid?: string | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
  /**
   * The username for this credential.
   */
  username?: string | null;
};

export type api_v2010_account_sip_sip_domain = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to process the call.
   */
  api_version?: string | null;
  /**
   * The types of authentication you have mapped to your domain. Can be: `IP_ACL` and `CREDENTIAL_LIST`. If you have both defined for your domain, both will be returned in a comma delimited string. If `auth_type` is not defined, the domain will not be able to receive any traffic.
   */
  auth_type?: string | null;
  /**
   * The SID of the BYOC Trunk(Bring Your Own Carrier) resource that the Sip Domain will be associated with.
   */
  byoc_trunk_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The unique address you reserve on Twilio to which you route your SIP traffic. Domain names can contain letters, digits, and "-" and must end with `sip.twilio.com`.
   */
  domain_name?: string | null;
  /**
   * Whether an emergency caller sid is configured for the domain. If present, this phone number will be used as the callback for the emergency call.
   */
  emergency_caller_sid?: string | null;
  /**
   * Whether emergency calling is enabled for the domain. If enabled, allows emergency calls on the domain from phone numbers with validated addresses.
   */
  emergency_calling_enabled?: boolean | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * Whether secure SIP is enabled for the domain. If enabled, TLS will be enforced and SRTP will be negotiated on all incoming calls to this sip domain.
   */
  secure?: boolean | null;
  /**
   * The unique string that that we created to identify the SipDomain resource.
   */
  sid?: string | null;
  /**
   * Whether to allow SIP Endpoints to register with the domain to receive calls.
   */
  sip_registration?: boolean | null;
  /**
   * A list of mapping resources associated with the SIP Domain resource identified by their relative URIs.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.
   */
  voice_fallback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call when an error occurs while retrieving or executing the TwiML requested from `voice_url`.
   */
  voice_fallback_url?: string | null;
  /**
   * The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.
   */
  voice_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The HTTP method we use to call `voice_status_callback_url`. Either `GET` or `POST`.
   */
  voice_status_callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL that we call to pass status parameters (such as call ended) to your application.
   */
  voice_status_callback_url?: string | null;
  /**
   * The URL we call using the `voice_method` when the domain receives a call.
   */
  voice_url?: string | null;
};

/**
 * The HTTP method we use to call `voice_status_callback_url`. Either `GET` or `POST`.
 */
export type voice_status_callback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

export type api_v2010_account_sip_sip_domain_sip_auth = {
  [key: string]: unknown;
};

export type api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls = {
  [key: string]: unknown;
};

export type api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_credential_list_mapping = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource.
   */
  account_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The unique string that that we created to identify the CredentialListMapping resource.
   */
  sid?: string | null;
};

export type api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_ip_access_control_list_mapping = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IpAccessControlListMapping resource.
   */
  account_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The unique string that that we created to identify the IpAccessControlListMapping resource.
   */
  sid?: string | null;
};

export type api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations = {
  [key: string]: unknown;
};

export type api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations_sip_auth_registrations_credential_list_mapping =
  {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource.
     */
    account_sid?: string | null;
    /**
     * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
     */
    date_created?: string | null;
    /**
     * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
     */
    date_updated?: string | null;
    /**
     * The string that you assigned to describe the resource.
     */
    friendly_name?: string | null;
    /**
     * The unique string that that we created to identify the CredentialListMapping resource.
     */
    sid?: string | null;
  };

export type api_v2010_account_sip_sip_domain_sip_credential_list_mapping = {
  /**
   * The unique id of the Account that is responsible for this resource.
   */
  account_sid?: string | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * The unique string that is created to identify the SipDomain resource.
   */
  domain_sid?: string | null;
  /**
   * A human readable descriptive text for this resource, up to 64 characters long.
   */
  friendly_name?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
};

export type api_v2010_account_sip_sip_domain_sip_ip_access_control_list_mapping = {
  /**
   * The unique id of the Account that is responsible for this resource.
   */
  account_sid?: string | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * The unique string that is created to identify the SipDomain resource.
   */
  domain_sid?: string | null;
  /**
   * A human readable descriptive text for this resource, up to 64 characters long.
   */
  friendly_name?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
};

export type api_v2010_account_sip_sip_ip_access_control_list = {
  /**
   * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) that owns this resource.
   */
  account_sid?: string | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * A human readable descriptive text, up to 255 characters long.
   */
  friendly_name?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * A list of the IpAddress resources associated with this IP access control list resource.
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
};

export type api_v2010_account_sip_sip_ip_access_control_list_sip_ip_address = {
  /**
   * The unique id of the Account that is responsible for this resource.
   */
  account_sid?: string | null;
  /**
   * An integer representing the length of the CIDR prefix to use with this IP address when accepting traffic. By default the entire IP address is used.
   */
  cidr_prefix_length?: number | null;
  /**
   * The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_created?: string | null;
  /**
   * The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
   */
  date_updated?: string | null;
  /**
   * A human readable descriptive text for this resource, up to 255 characters long.
   */
  friendly_name?: string | null;
  /**
   * The unique id of the IpAccessControlList resource that includes this resource.
   */
  ip_access_control_list_sid?: string | null;
  /**
   * An IP address in dotted decimal notation from which you want to accept traffic. Any SIP requests from this IP address will be allowed by Twilio. IPv4 only supported today.
   */
  ip_address?: string | null;
  /**
   * A 34 character string that uniquely identifies this resource.
   */
  sid?: string | null;
  /**
   * The URI for this resource, relative to `https://api.twilio.com`
   */
  uri?: string | null;
};

export type api_v2010_account_token = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Token resource.
   */
  account_sid?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * An array representing the ephemeral credentials and the STUN and TURN server URIs.
   */
  ice_servers?: Array<{
    credential?: string;
    url?: string;
    urls?: string;
    username?: string;
  }> | null;
  /**
   * The temporary password that the username will use when authenticating with Twilio.
   */
  password?: string | null;
  /**
   * The duration in seconds for which the username and password are valid.
   */
  ttl?: string | null;
  /**
   * The temporary username that uniquely identifies a Token.
   */
  username?: string | null;
};

export type api_v2010_account_transcription = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the transcription.
   */
  api_version?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The duration of the transcribed audio in seconds.
   */
  duration?: string | null;
  /**
   * The charge for the transcript in the currency associated with the account. This value is populated after the transcript is complete so it may not be available immediately.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).
   */
  price_unit?: string | null;
  /**
   * The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) from which the transcription was created.
   */
  recording_sid?: string | null;
  /**
   * The unique string that that we created to identify the Transcription resource.
   */
  sid?: string | null;
  /**
   * The status of the transcription. Can be: `in-progress`, `completed`, `failed`.
   */
  status?: transcription_enum_status | null;
  /**
   * The text content of the transcription.
   */
  transcription_text?: string | null;
  /**
   * The transcription type. Can only be: `fast`.
   */
  type?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
};

export type api_v2010_account_usage = {
  [key: string]: unknown;
};

export type api_v2010_account_usage_usage_record = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_all_time = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_all_time_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_daily = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_daily_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_last_month = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_last_month_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_monthly = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_monthly_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_this_month = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_this_month_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_today = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_today_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_yearly = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_yearly_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_record_usage_record_yesterday = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT
   */
  as_of?: string | null;
  /**
   * The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  category?: usage_record_yesterday_enum_category | null;
  /**
   * The number of usage events, such as the number of calls.
   */
  count?: string | null;
  /**
   * The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.
   */
  count_unit?: string | null;
  /**
   * A plain-language description of the usage category.
   */
  description?: string | null;
  /**
   * The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  end_date?: string | null;
  /**
   * The total price of the usage in the currency specified in `price_unit` and associated with the account.
   */
  price?: number | null;
  /**
   * The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.
   */
  price_unit?: string | null;
  /**
   * The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.
   */
  start_date?: string | null;
  /**
   * A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).
   */
  subresource_uris?: {
    [key: string]: unknown;
  } | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The amount used to bill usage and measured in units described in `usage_unit`.
   */
  usage?: string | null;
  /**
   * The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.
   */
  usage_unit?: string | null;
};

export type api_v2010_account_usage_usage_trigger = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that the trigger monitors.
   */
  account_sid?: string | null;
  /**
   * The API version used to create the resource.
   */
  api_version?: string | null;
  /**
   * The HTTP method we use to call `callback_url`. Can be: `GET` or `POST`.
   */
  callback_method?: ('HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE') | null;
  /**
   * The URL we call using the `callback_method` when the trigger fires.
   */
  callback_url?: string | null;
  /**
   * The current value of the field the trigger is watching.
   */
  current_value?: string | null;
  /**
   * The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_created?: string | null;
  /**
   * The date and time in GMT that the trigger was last fired specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_fired?: string | null;
  /**
   * The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
   */
  date_updated?: string | null;
  /**
   * The string that you assigned to describe the trigger.
   */
  friendly_name?: string | null;
  /**
   * The frequency of a recurring UsageTrigger.  Can be: `daily`, `monthly`, or `yearly` for recurring triggers or empty for non-recurring triggers. A trigger will only fire once during each period. Recurring times are in GMT.
   */
  recurring?: usage_trigger_enum_recurring | null;
  /**
   * The unique string that that we created to identify the UsageTrigger resource.
   */
  sid?: string | null;
  /**
   * The field in the [UsageRecord](https://www.twilio.com/docs/usage/api/usage-record) resource that fires the trigger.  Can be: `count`, `usage`, or `price`, as described in the [UsageRecords documentation](https://www.twilio.com/docs/usage/api/usage-record#usage-count-price).
   */
  trigger_by?: usage_trigger_enum_trigger_field | null;
  /**
   * The value at which the trigger will fire.  Must be a positive, numeric value.
   */
  trigger_value?: string | null;
  /**
   * The URI of the resource, relative to `https://api.twilio.com`.
   */
  uri?: string | null;
  /**
   * The usage category the trigger watches. Must be one of the supported [usage categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
   */
  usage_category?: usage_trigger_enum_usage_category | null;
  /**
   * The URI of the [UsageRecord](https://www.twilio.com/docs/usage/api/usage-record) resource this trigger watches, relative to `https://api.twilio.com`.
   */
  usage_record_uri?: string | null;
};

/**
 * The HTTP method we use to call `callback_url`. Can be: `GET` or `POST`.
 */
export type callback_method = 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';

export type api_v2010_account_validation_request = {
  /**
   * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for the Caller ID.
   */
  account_sid?: string | null;
  /**
   * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Caller ID is associated with.
   */
  call_sid?: string | null;
  /**
   * The string that you assigned to describe the resource.
   */
  friendly_name?: string | null;
  /**
   * The phone number to verify in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
   */
  phone_number?: string | null;
  /**
   * The 6 digit validation code that someone must enter to validate the Caller ID  when `phone_number` is called.
   */
  validation_code?: string | null;
};

export type authorized_connect_app_enum_permission = 'get-all' | 'post-all';

export type call_enum_event = 'initiated' | 'ringing' | 'answered' | 'completed';

export type call_enum_status =
  | 'queued'
  | 'ringing'
  | 'in-progress'
  | 'completed'
  | 'busy'
  | 'failed'
  | 'no-answer'
  | 'canceled';

export type call_enum_update_status = 'canceled' | 'completed';

export type call_recording_enum_source =
  | 'DialVerb'
  | 'Conference'
  | 'OutboundAPI'
  | 'Trunking'
  | 'RecordVerb'
  | 'StartCallRecordingAPI'
  | 'StartConferenceRecordingAPI';

export type call_recording_enum_status = 'in-progress' | 'paused' | 'stopped' | 'processing' | 'completed' | 'absent';

export type conference_enum_reason_conference_ended =
  | 'conference-ended-via-api'
  | 'participant-with-end-conference-on-exit-left'
  | 'participant-with-end-conference-on-exit-kicked'
  | 'last-participant-kicked'
  | 'last-participant-left';

export type conference_enum_status = 'init' | 'in-progress' | 'completed';

export type conference_enum_update_status = 'completed';

export type conference_recording_enum_source =
  | 'DialVerb'
  | 'Conference'
  | 'OutboundAPI'
  | 'Trunking'
  | 'RecordVerb'
  | 'StartCallRecordingAPI'
  | 'StartConferenceRecordingAPI';

export type conference_recording_enum_status =
  | 'in-progress'
  | 'paused'
  | 'stopped'
  | 'processing'
  | 'completed'
  | 'absent';

export type connect_app_enum_permission = 'get-all' | 'post-all';

export type dependent_phone_number_enum_address_requirement = 'none' | 'any' | 'local' | 'foreign';

export type dependent_phone_number_enum_emergency_status = 'Active' | 'Inactive';

export type incoming_phone_number_enum_address_requirement = 'none' | 'any' | 'local' | 'foreign';

export type incoming_phone_number_enum_emergency_address_status =
  | 'registered'
  | 'unregistered'
  | 'pending-registration'
  | 'registration-failure'
  | 'pending-unregistration'
  | 'unregistration-failure';

export type incoming_phone_number_enum_emergency_status = 'Active' | 'Inactive';

export type incoming_phone_number_enum_voice_receive_mode = 'voice' | 'fax';

export type incoming_phone_number_local_enum_address_requirement = 'none' | 'any' | 'local' | 'foreign';

export type incoming_phone_number_local_enum_emergency_address_status =
  | 'registered'
  | 'unregistered'
  | 'pending-registration'
  | 'registration-failure'
  | 'pending-unregistration'
  | 'unregistration-failure';

export type incoming_phone_number_local_enum_emergency_status = 'Active' | 'Inactive';

export type incoming_phone_number_local_enum_voice_receive_mode = 'voice' | 'fax';

export type incoming_phone_number_mobile_enum_address_requirement = 'none' | 'any' | 'local' | 'foreign';

export type incoming_phone_number_mobile_enum_emergency_address_status =
  | 'registered'
  | 'unregistered'
  | 'pending-registration'
  | 'registration-failure'
  | 'pending-unregistration'
  | 'unregistration-failure';

export type incoming_phone_number_mobile_enum_emergency_status = 'Active' | 'Inactive';

export type incoming_phone_number_mobile_enum_voice_receive_mode = 'voice' | 'fax';

export type incoming_phone_number_toll_free_enum_address_requirement = 'none' | 'any' | 'local' | 'foreign';

export type incoming_phone_number_toll_free_enum_emergency_address_status =
  | 'registered'
  | 'unregistered'
  | 'pending-registration'
  | 'registration-failure'
  | 'pending-unregistration'
  | 'unregistration-failure';

export type incoming_phone_number_toll_free_enum_emergency_status = 'Active' | 'Inactive';

export type incoming_phone_number_toll_free_enum_voice_receive_mode = 'voice' | 'fax';

export type message_enum_address_retention = 'retain' | 'obfuscate';

export type message_enum_content_retention = 'retain' | 'discard';

export type message_enum_direction = 'inbound' | 'outbound-api' | 'outbound-call' | 'outbound-reply';

export type message_enum_risk_check = 'enable' | 'disable';

export type message_enum_schedule_type = 'fixed';

export type message_enum_status =
  | 'queued'
  | 'sending'
  | 'sent'
  | 'failed'
  | 'delivered'
  | 'undelivered'
  | 'receiving'
  | 'received'
  | 'accepted'
  | 'scheduled'
  | 'read'
  | 'partially_delivered'
  | 'canceled';

export type message_enum_traffic_type = 'free';

export type message_enum_update_status = 'canceled';

export type message_feedback_enum_outcome = 'confirmed' | 'unconfirmed';

export type participant_enum_status = 'queued' | 'connecting' | 'ringing' | 'connected' | 'complete' | 'failed';

export type payments_enum_bank_account_type = 'consumer-checking' | 'consumer-savings' | 'commercial-checking';

export type payments_enum_capture =
  | 'payment-card-number'
  | 'expiration-date'
  | 'security-code'
  | 'postal-code'
  | 'bank-routing-number'
  | 'bank-account-number';

export type payments_enum_payment_method = 'credit-card' | 'ach-debit';

export type payments_enum_status = 'complete' | 'cancel';

export type payments_enum_token_type = 'one-time' | 'reusable';

export type recording_add_on_result_enum_status =
  | 'canceled'
  | 'completed'
  | 'deleted'
  | 'failed'
  | 'in-progress'
  | 'init'
  | 'processing'
  | 'queued';

export type recording_enum_source =
  | 'DialVerb'
  | 'Conference'
  | 'OutboundAPI'
  | 'Trunking'
  | 'RecordVerb'
  | 'StartCallRecordingAPI'
  | 'StartConferenceRecordingAPI';

export type recording_enum_status =
  | 'in-progress'
  | 'paused'
  | 'stopped'
  | 'processing'
  | 'completed'
  | 'absent'
  | 'deleted';

export type recording_transcription_enum_status = 'in-progress' | 'completed' | 'failed';

export type siprec_enum_status = 'in-progress' | 'stopped';

export type siprec_enum_track = 'inbound_track' | 'outbound_track' | 'both_tracks';

export type siprec_enum_update_status = 'stopped';

export type stream_enum_status = 'in-progress' | 'stopped';

export type stream_enum_track = 'inbound_track' | 'outbound_track' | 'both_tracks';

export type stream_enum_update_status = 'stopped';

export type transcription_enum_status = 'in-progress' | 'completed' | 'failed';

export type usage_record_all_time_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_daily_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_last_month_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_monthly_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_this_month_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_today_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_yearly_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_record_yesterday_enum_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type usage_trigger_enum_recurring = 'daily' | 'monthly' | 'yearly' | 'alltime';

export type usage_trigger_enum_trigger_field = 'count' | 'usage' | 'price';

export type usage_trigger_enum_usage_category =
  | 'a2p-registration-fees'
  | 'agent-conference'
  | 'amazon-polly'
  | 'answering-machine-detection'
  | 'authy-authentications'
  | 'authy-calls-outbound'
  | 'authy-monthly-fees'
  | 'authy-phone-intelligence'
  | 'authy-phone-verifications'
  | 'authy-sms-outbound'
  | 'call-progess-events'
  | 'calleridlookups'
  | 'calls'
  | 'calls-client'
  | 'calls-globalconference'
  | 'calls-inbound'
  | 'calls-inbound-local'
  | 'calls-inbound-mobile'
  | 'calls-inbound-tollfree'
  | 'calls-outbound'
  | 'calls-pay-verb-transactions'
  | 'calls-recordings'
  | 'calls-sip'
  | 'calls-sip-inbound'
  | 'calls-sip-outbound'
  | 'calls-transfers'
  | 'carrier-lookups'
  | 'conversations'
  | 'conversations-api-requests'
  | 'conversations-conversation-events'
  | 'conversations-endpoint-connectivity'
  | 'conversations-events'
  | 'conversations-participant-events'
  | 'conversations-participants'
  | 'cps'
  | 'flex-usage'
  | 'fraud-lookups'
  | 'group-rooms'
  | 'group-rooms-data-track'
  | 'group-rooms-encrypted-media-recorded'
  | 'group-rooms-media-downloaded'
  | 'group-rooms-media-recorded'
  | 'group-rooms-media-routed'
  | 'group-rooms-media-stored'
  | 'group-rooms-participant-minutes'
  | 'group-rooms-recorded-minutes'
  | 'imp-v1-usage'
  | 'lookups'
  | 'marketplace'
  | 'marketplace-algorithmia-named-entity-recognition'
  | 'marketplace-cadence-transcription'
  | 'marketplace-cadence-translation'
  | 'marketplace-capio-speech-to-text'
  | 'marketplace-convriza-ababa'
  | 'marketplace-deepgram-phrase-detector'
  | 'marketplace-digital-segment-business-info'
  | 'marketplace-facebook-offline-conversions'
  | 'marketplace-google-speech-to-text'
  | 'marketplace-ibm-watson-message-insights'
  | 'marketplace-ibm-watson-message-sentiment'
  | 'marketplace-ibm-watson-recording-analysis'
  | 'marketplace-ibm-watson-tone-analyzer'
  | 'marketplace-icehook-systems-scout'
  | 'marketplace-infogroup-dataaxle-bizinfo'
  | 'marketplace-keen-io-contact-center-analytics'
  | 'marketplace-marchex-cleancall'
  | 'marketplace-marchex-sentiment-analysis-for-sms'
  | 'marketplace-marketplace-nextcaller-social-id'
  | 'marketplace-mobile-commons-opt-out-classifier'
  | 'marketplace-nexiwave-voicemail-to-text'
  | 'marketplace-nextcaller-advanced-caller-identification'
  | 'marketplace-nomorobo-spam-score'
  | 'marketplace-payfone-tcpa-compliance'
  | 'marketplace-remeeting-automatic-speech-recognition'
  | 'marketplace-tcpa-defense-solutions-blacklist-feed'
  | 'marketplace-telo-opencnam'
  | 'marketplace-truecnam-true-spam'
  | 'marketplace-twilio-caller-name-lookup-us'
  | 'marketplace-twilio-carrier-information-lookup'
  | 'marketplace-voicebase-pci'
  | 'marketplace-voicebase-transcription'
  | 'marketplace-voicebase-transcription-custom-vocabulary'
  | 'marketplace-whitepages-pro-caller-identification'
  | 'marketplace-whitepages-pro-phone-intelligence'
  | 'marketplace-whitepages-pro-phone-reputation'
  | 'marketplace-wolfarm-spoken-results'
  | 'marketplace-wolfram-short-answer'
  | 'marketplace-ytica-contact-center-reporting-analytics'
  | 'mediastorage'
  | 'mms'
  | 'mms-inbound'
  | 'mms-inbound-longcode'
  | 'mms-inbound-shortcode'
  | 'mms-messages-carrierfees'
  | 'mms-outbound'
  | 'mms-outbound-longcode'
  | 'mms-outbound-shortcode'
  | 'monitor-reads'
  | 'monitor-storage'
  | 'monitor-writes'
  | 'notify'
  | 'notify-actions-attempts'
  | 'notify-channels'
  | 'number-format-lookups'
  | 'pchat'
  | 'pchat-users'
  | 'peer-to-peer-rooms-participant-minutes'
  | 'pfax'
  | 'pfax-minutes'
  | 'pfax-minutes-inbound'
  | 'pfax-minutes-outbound'
  | 'pfax-pages'
  | 'phonenumbers'
  | 'phonenumbers-cps'
  | 'phonenumbers-emergency'
  | 'phonenumbers-local'
  | 'phonenumbers-mobile'
  | 'phonenumbers-setups'
  | 'phonenumbers-tollfree'
  | 'premiumsupport'
  | 'proxy'
  | 'proxy-active-sessions'
  | 'pstnconnectivity'
  | 'pv'
  | 'pv-composition-media-downloaded'
  | 'pv-composition-media-encrypted'
  | 'pv-composition-media-stored'
  | 'pv-composition-minutes'
  | 'pv-recording-compositions'
  | 'pv-room-participants'
  | 'pv-room-participants-au1'
  | 'pv-room-participants-br1'
  | 'pv-room-participants-ie1'
  | 'pv-room-participants-jp1'
  | 'pv-room-participants-sg1'
  | 'pv-room-participants-us1'
  | 'pv-room-participants-us2'
  | 'pv-rooms'
  | 'pv-sip-endpoint-registrations'
  | 'recordings'
  | 'recordingstorage'
  | 'rooms-group-bandwidth'
  | 'rooms-group-minutes'
  | 'rooms-peer-to-peer-minutes'
  | 'shortcodes'
  | 'shortcodes-customerowned'
  | 'shortcodes-mms-enablement'
  | 'shortcodes-mps'
  | 'shortcodes-random'
  | 'shortcodes-uk'
  | 'shortcodes-vanity'
  | 'small-group-rooms'
  | 'small-group-rooms-data-track'
  | 'small-group-rooms-participant-minutes'
  | 'sms'
  | 'sms-inbound'
  | 'sms-inbound-longcode'
  | 'sms-inbound-shortcode'
  | 'sms-messages-carrierfees'
  | 'sms-messages-features'
  | 'sms-messages-features-senderid'
  | 'sms-outbound'
  | 'sms-outbound-content-inspection'
  | 'sms-outbound-longcode'
  | 'sms-outbound-shortcode'
  | 'speech-recognition'
  | 'studio-engagements'
  | 'sync'
  | 'sync-actions'
  | 'sync-endpoint-hours'
  | 'sync-endpoint-hours-above-daily-cap'
  | 'taskrouter-tasks'
  | 'totalprice'
  | 'transcriptions'
  | 'trunking-cps'
  | 'trunking-emergency-calls'
  | 'trunking-origination'
  | 'trunking-origination-local'
  | 'trunking-origination-mobile'
  | 'trunking-origination-tollfree'
  | 'trunking-recordings'
  | 'trunking-secure'
  | 'trunking-termination'
  | 'tts-google'
  | 'turnmegabytes'
  | 'turnmegabytes-australia'
  | 'turnmegabytes-brasil'
  | 'turnmegabytes-germany'
  | 'turnmegabytes-india'
  | 'turnmegabytes-ireland'
  | 'turnmegabytes-japan'
  | 'turnmegabytes-singapore'
  | 'turnmegabytes-useast'
  | 'turnmegabytes-uswest'
  | 'twilio-interconnect'
  | 'verify-push'
  | 'verify-totp'
  | 'verify-whatsapp-conversations-business-initiated'
  | 'video-recordings'
  | 'virtual-agent'
  | 'voice-insights'
  | 'voice-insights-client-insights-on-demand-minute'
  | 'voice-insights-ptsn-insights-on-demand-minute'
  | 'voice-insights-sip-interface-insights-on-demand-minute'
  | 'voice-insights-sip-trunking-insights-on-demand-minute'
  | 'voice-intelligence'
  | 'voice-intelligence-transcription'
  | 'voice-intelligence-operators'
  | 'wireless'
  | 'wireless-orders'
  | 'wireless-orders-artwork'
  | 'wireless-orders-bulk'
  | 'wireless-orders-esim'
  | 'wireless-orders-starter'
  | 'wireless-usage'
  | 'wireless-usage-commands'
  | 'wireless-usage-commands-africa'
  | 'wireless-usage-commands-asia'
  | 'wireless-usage-commands-centralandsouthamerica'
  | 'wireless-usage-commands-europe'
  | 'wireless-usage-commands-home'
  | 'wireless-usage-commands-northamerica'
  | 'wireless-usage-commands-oceania'
  | 'wireless-usage-commands-roaming'
  | 'wireless-usage-data'
  | 'wireless-usage-data-africa'
  | 'wireless-usage-data-asia'
  | 'wireless-usage-data-centralandsouthamerica'
  | 'wireless-usage-data-custom-additionalmb'
  | 'wireless-usage-data-custom-first5mb'
  | 'wireless-usage-data-domestic-roaming'
  | 'wireless-usage-data-europe'
  | 'wireless-usage-data-individual-additionalgb'
  | 'wireless-usage-data-individual-firstgb'
  | 'wireless-usage-data-international-roaming-canada'
  | 'wireless-usage-data-international-roaming-india'
  | 'wireless-usage-data-international-roaming-mexico'
  | 'wireless-usage-data-northamerica'
  | 'wireless-usage-data-oceania'
  | 'wireless-usage-data-pooled'
  | 'wireless-usage-data-pooled-downlink'
  | 'wireless-usage-data-pooled-uplink'
  | 'wireless-usage-mrc'
  | 'wireless-usage-mrc-custom'
  | 'wireless-usage-mrc-individual'
  | 'wireless-usage-mrc-pooled'
  | 'wireless-usage-mrc-suspended'
  | 'wireless-usage-sms'
  | 'wireless-usage-voice';

export type ListAccountData = {
  query?: {
    /**
     * Only return the Account resources with friendly names that exactly match this name.
     */
    FriendlyName?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only return Account resources with the given status. Can be `closed`, `suspended` or `active`.
     */
    Status?: account_enum_status;
  };
};

export type ListAccountResponse = {
  accounts?: Array<api_v2010_account>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAccountError = unknown;

export type CreateAccountData = {
  body?: {
    /**
     * A human readable description of the account to create, defaults to `SubAccount Created at {YYYY-MM-DD HH:MM meridian}`
     */
    FriendlyName?: string;
  };
};

export type CreateAccountResponse = api_v2010_account;

export type CreateAccountError = unknown;

export type ListAddressData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The `customer_name` of the Address resources to read.
     */
    CustomerName?: string;
    /**
     * The string that identifies the Address resources to read.
     */
    FriendlyName?: string;
    /**
     * The ISO country code of the Address resources to read.
     */
    IsoCountry?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListAddressResponse = {
  addresses?: Array<api_v2010_account_address>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAddressError = unknown;

export type CreateAddressData = {
  body?: {
    /**
     * Whether we should automatically correct the address. Can be: `true` or `false` and the default is `true`. If empty or `true`, we will correct the address you provide if necessary. If `false`, we won't alter the address you provide.
     */
    AutoCorrectAddress?: boolean;
    /**
     * The city of the new address.
     */
    City: string;
    /**
     * The name to associate with the new address.
     */
    CustomerName: string;
    /**
     * Whether to enable emergency calling on the new address. Can be: `true` or `false`.
     */
    EmergencyEnabled?: boolean;
    /**
     * A descriptive string that you create to describe the new address. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The ISO country code of the new address.
     */
    IsoCountry: string;
    /**
     * The postal code of the new address.
     */
    PostalCode: string;
    /**
     * The state or region of the new address.
     */
    Region: string;
    /**
     * The number and street address of the new address.
     */
    Street: string;
    /**
     * The additional number and street address of the address.
     */
    StreetSecondary?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will be responsible for the new Address resource.
     */
    AccountSid: string;
  };
};

export type CreateAddressResponse = api_v2010_account_address;

export type CreateAddressError = unknown;

export type ListDependentPhoneNumberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the DependentPhoneNumber resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the Address resource associated with the phone number.
     */
    AddressSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListDependentPhoneNumberResponse = {
  dependent_phone_numbers?: Array<api_v2010_account_address_dependent_phone_number>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListDependentPhoneNumberError = unknown;

export type DeleteAddressData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Address resource to delete.
     */
    Sid: string;
  };
};

export type DeleteAddressResponse = any;

export type DeleteAddressError = unknown;

export type FetchAddressData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Address resource to fetch.
     */
    Sid: string;
  };
};

export type FetchAddressResponse = api_v2010_account_address;

export type FetchAddressError = unknown;

export type UpdateAddressData = {
  body?: {
    /**
     * Whether we should automatically correct the address. Can be: `true` or `false` and the default is `true`. If empty or `true`, we will correct the address you provide if necessary. If `false`, we won't alter the address you provide.
     */
    AutoCorrectAddress?: boolean;
    /**
     * The city of the address.
     */
    City?: string;
    /**
     * The name to associate with the address.
     */
    CustomerName?: string;
    /**
     * Whether to enable emergency calling on the address. Can be: `true` or `false`.
     */
    EmergencyEnabled?: boolean;
    /**
     * A descriptive string that you create to describe the address. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The postal code of the address.
     */
    PostalCode?: string;
    /**
     * The state or region of the address.
     */
    Region?: string;
    /**
     * The number and street address of the address.
     */
    Street?: string;
    /**
     * The additional number and street address of the address.
     */
    StreetSecondary?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Address resource to update.
     */
    Sid: string;
  };
};

export type UpdateAddressResponse = api_v2010_account_address;

export type UpdateAddressError = unknown;

export type ListApplicationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The string that identifies the Application resources to read.
     */
    FriendlyName?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListApplicationResponse = {
  applications?: Array<api_v2010_account_application>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListApplicationError = unknown;

export type CreateApplicationData = {
  body?: {
    /**
     * The API version to use to start a new TwiML session. Can be: `2010-04-01` or `2008-08-01`. The default value is the account's default API version.
     */
    ApiVersion?: string;
    /**
     * A descriptive string that you create to describe the new application. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The URL we should call using a POST method to send message status information to your application.
     */
    MessageStatusCallback?: string;
    /**
     * Whether to allow other Twilio accounts to dial this applicaton using Dial verb. Can be: `true` or `false`.
     */
    PublicApplicationConnectEnabled?: boolean;
    /**
     * The HTTP method we should use to call `sms_fallback_url`. Can be: `GET` or `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while retrieving or executing the TwiML from `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `sms_url`. Can be: `GET` or `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call using a POST method to send status information about SMS messages sent by the application.
     */
    SmsStatusCallback?: string;
    /**
     * The URL we should call when the phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Whether we should look up the caller's caller-ID name from the CNAM database (additional charges apply). Can be: `true` or `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method we should use to call `voice_fallback_url`. Can be: `GET` or `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `voice_url`. Can be: `GET` or `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the phone number assigned to this application receives a call.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateApplicationResponse = api_v2010_account_application;

export type CreateApplicationError = unknown;

export type DeleteApplicationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Application resource to delete.
     */
    Sid: string;
  };
};

export type DeleteApplicationResponse = any;

export type DeleteApplicationError = unknown;

export type FetchApplicationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Application resource to fetch.
     */
    Sid: string;
  };
};

export type FetchApplicationResponse = api_v2010_account_application;

export type FetchApplicationError = unknown;

export type UpdateApplicationData = {
  body?: {
    /**
     * The API version to use to start a new TwiML session. Can be: `2010-04-01` or `2008-08-01`. The default value is your account's default API version.
     */
    ApiVersion?: string;
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The URL we should call using a POST method to send message status information to your application.
     */
    MessageStatusCallback?: string;
    /**
     * Whether to allow other Twilio accounts to dial this applicaton using Dial verb. Can be: `true` or `false`.
     */
    PublicApplicationConnectEnabled?: boolean;
    /**
     * The HTTP method we should use to call `sms_fallback_url`. Can be: `GET` or `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while retrieving or executing the TwiML from `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `sms_url`. Can be: `GET` or `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Same as message_status_callback: The URL we should call using a POST method to send status information about SMS messages sent by the application. Deprecated, included for backwards compatibility.
     */
    SmsStatusCallback?: string;
    /**
     * The URL we should call when the phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Whether we should look up the caller's caller-ID name from the CNAM database (additional charges apply). Can be: `true` or `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method we should use to call `voice_fallback_url`. Can be: `GET` or `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `voice_url`. Can be: `GET` or `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the phone number assigned to this application receives a call.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resources to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Application resource to update.
     */
    Sid: string;
  };
};

export type UpdateApplicationResponse = api_v2010_account_application;

export type UpdateApplicationError = unknown;

export type ListAuthorizedConnectAppData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the AuthorizedConnectApp resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListAuthorizedConnectAppResponse = {
  authorized_connect_apps?: Array<api_v2010_account_authorized_connect_app>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAuthorizedConnectAppError = unknown;

export type FetchAuthorizedConnectAppData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the AuthorizedConnectApp resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the Connect App to fetch.
     */
    ConnectAppSid: string;
  };
};

export type FetchAuthorizedConnectAppResponse = api_v2010_account_authorized_connect_app;

export type FetchAuthorizedConnectAppError = unknown;

export type ListAvailablePhoneNumberCountryData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the available phone number Country resources.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListAvailablePhoneNumberCountryResponse = {
  countries?: Array<api_v2010_account_available_phone_number_country>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberCountryError = unknown;

export type FetchAvailablePhoneNumberCountryData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the available phone number Country resource.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country to fetch available phone number information about.
     */
    CountryCode: string;
  };
};

export type FetchAvailablePhoneNumberCountryResponse = api_v2010_account_available_phone_number_country;

export type FetchAvailablePhoneNumberCountryError = unknown;

export type ListAvailablePhoneNumberLocalData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumberlocal-resource?code-sample=code-find-phone-numbers-by-number-pattern) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumberlocal-resource?code-sample=code-find-phone-numbers-by-character-pattern). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberLocalResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_local>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberLocalError = unknown;

export type ListAvailablePhoneNumberMachineToMachineData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberMachineToMachineResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_machine_to_machine>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberMachineToMachineError = unknown;

export type ListAvailablePhoneNumberMobileData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberMobileResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_mobile>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberMobileError = unknown;

export type ListAvailablePhoneNumberNationalData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberNationalResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_national>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberNationalError = unknown;

export type ListAvailablePhoneNumberSharedCostData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberSharedCostResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_shared_cost>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberSharedCostError = unknown;

export type ListAvailablePhoneNumberTollFreeData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberTollFreeResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_toll_free>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberTollFreeError = unknown;

export type ListAvailablePhoneNumberVoipData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) requesting the AvailablePhoneNumber resources.
     */
    AccountSid: string;
    /**
     * The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country from which to read phone numbers.
     */
    CountryCode: string;
  };
  query?: {
    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in the US and Canada.
     */
    AreaCode?: number;
    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`, `a-z`, and `A-Z`. The `*` character matches any single digit. For examples, see [Example 2](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-2) and [Example 3](https://www.twilio.com/docs/phone-numbers/api/availablephonenumber-resource#local-get-basic-example-3). If specified, this value must have at least two characters.
     */
    Contains?: string;
    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the default is `25`. Applies to only phone numbers in the US and Canada.
     */
    Distance?: number;
    /**
     * Whether to exclude phone numbers that require an [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeAllAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a foreign [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeForeignAddressRequired?: boolean;
    /**
     * Whether to exclude phone numbers that require a local [Address](https://www.twilio.com/docs/usage/api/address). Can be: `true` or `false` and the default is `false`.
     */
    ExcludeLocalAddressRequired?: boolean;
    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`.
     */
    FaxEnabled?: boolean;
    /**
     * Limit results to a specific local access and transport area ([LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area)). Given a phone number, search within the same [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) as that number. Applies to only phone numbers in the US and Canada.
     */
    InLata?: string;
    /**
     * Limit results to a particular locality or city. Given a phone number, search within the same Locality as that number.
     */
    InLocality?: string;
    /**
     * Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. Applies to only phone numbers in the US and Canada.
     */
    InPostalCode?: string;
    /**
     * Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires `in_lata` to be set as well. Applies to only phone numbers in the US and Canada.
     */
    InRateCenter?: string;
    /**
     * Limit results to a particular region, state, or province. Given a phone number, search within the same region as that number. Applies to only phone numbers in the US and Canada.
     */
    InRegion?: string;
    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or `false`.
     */
    MmsEnabled?: boolean;
    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers within `distance` miles. Applies to only phone numbers in the US and Canada.
     */
    NearLatLong?: string;
    /**
     * Given a phone number, find a geographically close number within `distance` miles. Distance defaults to 25 miles. Applies to only phone numbers in the US and Canada.
     */
    NearNumber?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or `false`.
     */
    SmsEnabled?: boolean;
    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`.
     */
    VoiceEnabled?: boolean;
  };
};

export type ListAvailablePhoneNumberVoipResponse = {
  available_phone_numbers?: Array<api_v2010_account_available_phone_number_country_available_phone_number_voip>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListAvailablePhoneNumberVoipError = unknown;

export type FetchBalanceData = {
  path: {
    /**
     * The unique SID identifier of the Account.
     */
    AccountSid: string;
  };
};

export type FetchBalanceResponse = api_v2010_account_balance;

export type FetchBalanceError = unknown;

export type ListCallData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call resource(s) to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Only include calls that ended on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that ended on this date. You can also specify an inequality, such as `EndTime<=YYYY-MM-DD`, to read calls that ended on or before midnight of this date, and `EndTime>=YYYY-MM-DD` to read calls that ended on or after midnight of this date.
     */
    EndTime?: string;
    /**
     * Only include calls that ended on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that ended on this date. You can also specify an inequality, such as `EndTime<=YYYY-MM-DD`, to read calls that ended on or before midnight of this date, and `EndTime>=YYYY-MM-DD` to read calls that ended on or after midnight of this date.
     */
    'EndTime<'?: string;
    /**
     * Only include calls that ended on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that ended on this date. You can also specify an inequality, such as `EndTime<=YYYY-MM-DD`, to read calls that ended on or before midnight of this date, and `EndTime>=YYYY-MM-DD` to read calls that ended on or after midnight of this date.
     */
    'EndTime>'?: string;
    /**
     * Only include calls from this phone number, SIP address, Client identifier or SIM SID.
     */
    From?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include calls spawned by calls with this SID.
     */
    ParentCallSid?: string;
    /**
     * Only include calls that started on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that started on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read calls that started on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read calls that started on or after midnight of this date.
     */
    StartTime?: string;
    /**
     * Only include calls that started on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that started on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read calls that started on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read calls that started on or after midnight of this date.
     */
    'StartTime<'?: string;
    /**
     * Only include calls that started on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read only calls that started on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read calls that started on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read calls that started on or after midnight of this date.
     */
    'StartTime>'?: string;
    /**
     * The status of the calls to include. Can be: `queued`, `ringing`, `in-progress`, `canceled`, `completed`, `failed`, `busy`, or `no-answer`.
     */
    Status?: call_enum_status;
    /**
     * Only show calls made to this phone number, SIP address, Client identifier or SIM SID.
     */
    To?: string;
  };
};

export type ListCallResponse = {
  calls?: Array<api_v2010_account_call>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListCallError = unknown;

export type CreateCallData = {
  body?: {
    /**
     * The SID of the Application resource that will handle the call, if the call will be handled by an application.
     */
    ApplicationSid?: string;
    /**
     * Select whether to perform answering machine detection in the background. Default, blocks the execution of the call until Answering Machine Detection is completed. Can be: `true` or `false`.
     */
    AsyncAmd?: string;
    /**
     * The URL that we should call using the `async_amd_status_callback_method` to notify customer application whether the call was answered by human, machine or fax.
     */
    AsyncAmdStatusCallback?: string;
    /**
     * The HTTP method we should use when calling the `async_amd_status_callback` URL. Can be: `GET` or `POST` and the default is `POST`.
     */
    AsyncAmdStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of a BYOC (Bring Your Own Carrier) trunk to route this call with. Note that `byoc` is only meaningful when `to` is a phone number; it will otherwise be ignored. (Beta)
     */
    Byoc?: string;
    /**
     * The Reason for the outgoing call. Use it to specify the purpose of the call that is presented on the called party's phone. (Branded Calls Beta)
     */
    CallReason?: string;
    /**
     * A token string needed to invoke a forwarded call. A call_token is generated when an incoming call is received on a Twilio number. Pass an incoming call's call_token value to a forwarded call via the call_token parameter when creating a new call. A forwarded call should bear the same CallerID of the original incoming call.
     */
    CallToken?: string;
    /**
     * The phone number, SIP address, or Client identifier that made this call. Phone numbers are in [E.164 format](https://wwnw.twilio.com/docs/glossary/what-e164) (e.g., +16175551212). SIP addresses are formatted as `name@company.com`.
     */
    CallerId?: string;
    /**
     * The HTTP method that we should use to request the `fallback_url`. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    FallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we call using the `fallback_method` if an error occurs when requesting or executing the TwiML at `url`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    FallbackUrl?: string;
    /**
     * The phone number or client identifier to use as the caller id. If using a phone number, it must be a Twilio number or a Verified [outgoing caller id](https://www.twilio.com/docs/voice/api/outgoing-caller-ids) for your account. If the `to` parameter is a phone number, `From` must also be a phone number.
     */
    From: string;
    /**
     * Whether to detect if a human, answering machine, or fax has picked up the call. Can be: `Enable` or `DetectMessageEnd`. Use `Enable` if you would like us to return `AnsweredBy` as soon as the called party is identified. Use `DetectMessageEnd`, if you would like to leave a message on an answering machine. If `send_digits` is provided, this parameter is ignored. For more information, see [Answering Machine Detection](https://www.twilio.com/docs/voice/answering-machine-detection).
     */
    MachineDetection?: string;
    /**
     * The number of milliseconds of initial silence after which an `unknown` AnsweredBy result will be returned. Possible Values: 2000-10000. Default: 5000.
     */
    MachineDetectionSilenceTimeout?: number;
    /**
     * The number of milliseconds of silence after speech activity at which point the speech activity is considered complete. Possible Values: 500-5000. Default: 1200.
     */
    MachineDetectionSpeechEndThreshold?: number;
    /**
     * The number of milliseconds that is used as the measuring stick for the length of the speech activity, where durations lower than this value will be interpreted as a human and longer than this value as a machine. Possible Values: 1000-6000. Default: 2400.
     */
    MachineDetectionSpeechThreshold?: number;
    /**
     * The number of seconds that we should attempt to detect an answering machine before timing out and sending a voice request with `AnsweredBy` of `unknown`. The default timeout is 30 seconds.
     */
    MachineDetectionTimeout?: number;
    /**
     * The HTTP method we should use when calling the `url` parameter's value. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    Method?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Whether to record the call. Can be `true` to record the phone call, or `false` to not. The default is `false`. The `recording_url` is sent to the `status_callback` URL.
     */
    Record?: boolean;
    /**
     * The number of channels in the final recording. Can be: `mono` or `dual`. The default is `mono`. `mono` records both legs of the call in a single channel of the recording file. `dual` records each leg to a separate channel of the recording file. The first channel of a dual-channel recording contains the parent call and the second channel contains the child call.
     */
    RecordingChannels?: string;
    /**
     * The URL that we call when the recording is available to be accessed.
     */
    RecordingStatusCallback?: string;
    /**
     * The recording status events that will trigger calls to the URL specified in `recording_status_callback`. Can be: `in-progress`, `completed` and `absent`. Defaults to `completed`. Separate  multiple values with a space.
     */
    RecordingStatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use when calling the `recording_status_callback` URL. Can be: `GET` or `POST` and the default is `POST`.
     */
    RecordingStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The audio track to record for the call. Can be: `inbound`, `outbound` or `both`. The default is `both`. `inbound` records the audio that is received by Twilio. `outbound` records the audio that is generated from Twilio. `both` records the audio that is received and generated by Twilio.
     */
    RecordingTrack?: string;
    /**
     * A string of keys to dial after connecting to the number, maximum of 32 digits. Valid digits in the string include: any digit (`0`-`9`), '`#`', '`*`' and '`w`', to insert a half second pause. For example, if you connected to a company phone number and wanted to pause for one second, and then dial extension 1234 followed by the pound key, the value of this parameter would be `ww1234#`. Remember to URL-encode this string, since the '`#`' character has special meaning in a URL. If both `SendDigits` and `MachineDetection` parameters are provided, then `MachineDetection` will be ignored.
     */
    SendDigits?: string;
    /**
     * The password required to authenticate the user account specified in `sip_auth_username`.
     */
    SipAuthPassword?: string;
    /**
     * The username used to authenticate the caller making a SIP call.
     */
    SipAuthUsername?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application. If no `status_callback_event` is specified, we will send the `completed` status. If an `application_sid` parameter is present, this parameter is ignored. URLs must contain a valid hostname (underscores are not permitted).
     */
    StatusCallback?: string;
    /**
     * The call progress events that we will send to the `status_callback` URL. Can be: `initiated`, `ringing`, `answered`, and `completed`. If no event is specified, we send the `completed` status. If you want to receive multiple events, specify each one in a separate `status_callback_event` parameter. See the code sample for [monitoring call progress](https://www.twilio.com/docs/voice/api/call-resource?code-sample=code-create-a-call-resource-and-specify-a-statuscallbackevent&code-sdk-version=json). If an `application_sid` is present, this parameter is ignored.
     */
    StatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use when calling the `status_callback` URL. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The maximum duration of the call in seconds. Constraints depend on account and configuration.
     */
    TimeLimit?: number;
    /**
     * The integer number of seconds that we should allow the phone to ring before assuming there is no answer. The default is `60` seconds and the maximum is `600` seconds. For some call flows, we will add a 5-second buffer to the timeout value you provide. For this reason, a timeout value of 10 seconds could result in an actual timeout closer to 15 seconds. You can set this to a short time, such as `15` seconds, to hang up before reaching an answering machine or voicemail.
     */
    Timeout?: number;
    /**
     * The phone number, SIP address, or client identifier to call.
     */
    To: string;
    /**
     * Whether to trim any leading and trailing silence from the recording. Can be: `trim-silence` or `do-not-trim` and the default is `trim-silence`.
     */
    Trim?: string;
    /**
     * TwiML instructions for the call Twilio will use without fetching Twiml from url parameter. If both `twiml` and `url` are provided then `twiml` parameter will be ignored. Max 4000 characters.
     */
    Twiml?: string;
    /**
     * The absolute URL that returns the TwiML instructions for the call. We will call this URL using the `method` when the call connects. For more information, see the [Url Parameter](https://www.twilio.com/docs/voice/make-calls#specify-a-url-parameter) section in [Making Calls](https://www.twilio.com/docs/voice/make-calls).
     */
    Url?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateCallResponse = api_v2010_account_call;

export type CreateCallError = unknown;

export type ListCallEventData = {
  path: {
    /**
     * The unique SID identifier of the Account.
     */
    AccountSid: string;
    /**
     * The unique SID identifier of the Call.
     */
    CallSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListCallEventResponse = {
  end?: number;
  events?: Array<api_v2010_account_call_call_event>;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListCallEventError = unknown;

export type ListCallNotificationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resources to read.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the Call Notification resources to read.
     */
    CallSid: string;
  };
  query?: {
    /**
     * Only read notifications of the specified log level. Can be:  `0` to read only ERROR notifications or `1` to read only WARNING notifications. By default, all notifications are read.
     */
    Log?: number;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    MessageDate?: string;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    'MessageDate<'?: string;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    'MessageDate>'?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListCallNotificationResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  notifications?: Array<api_v2010_account_call_call_notification>;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListCallNotificationError = unknown;

export type FetchCallNotificationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resource to fetch.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the Call Notification resource to fetch.
     */
    CallSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Call Notification resource to fetch.
     */
    Sid: string;
  };
};

export type FetchCallNotificationResponse = api_v2010_account_call_call_notification_instance;

export type FetchCallNotificationError = unknown;

export type CreatePaymentsData = {
  body?: {
    /**
     * Type of bank account if payment source is ACH. One of `consumer-checking`, `consumer-savings`, or `commercial-checking`. The default value is `consumer-checking`.
     */
    BankAccountType?: payments_enum_bank_account_type;
    /**
     * A positive decimal value less than 1,000,000 to charge against the credit card or bank account. Default currency can be overwritten with `currency` field. Leave blank or set to 0 to tokenize.
     */
    ChargeAmount?: number;
    /**
     * The currency of the `charge_amount`, formatted as [ISO 4127](http://www.iso.org/iso/home/standards/currency_codes.htm) format. The default value is `USD` and all values allowed from the Pay Connector are accepted.
     */
    Currency?: string;
    /**
     * The description can be used to provide more details regarding the transaction. This information is submitted along with the payment details to the Payment Connector which are then posted on the transactions.
     */
    Description?: string;
    /**
     * A unique token that will be used to ensure that multiple API calls with the same information do not result in multiple transactions. This should be a unique string value per API call and can be a randomly generated.
     */
    IdempotencyKey: string;
    /**
     * A list of inputs that should be accepted. Currently only `dtmf` is supported. All digits captured during a pay session are redacted from the logs.
     */
    Input?: string;
    /**
     * A positive integer that is used to validate the length of the `PostalCode` inputted by the user. User must enter this many digits.
     */
    MinPostalCodeLength?: number;
    /**
     * A single-level JSON object used to pass custom parameters to payment processors. (Required for ACH payments). The information that has to be included here depends on the <Pay> Connector. [Read more](https://www.twilio.com/console/voice/pay-connectors).
     */
    Parameter?: unknown;
    /**
     * This is the unique name corresponding to the Pay Connector installed in the Twilio Add-ons. Learn more about [<Pay> Connectors](https://www.twilio.com/console/voice/pay-connectors). The default value is `Default`.
     */
    PaymentConnector?: string;
    /**
     * Type of payment being captured. One of `credit-card` or `ach-debit`. The default value is `credit-card`.
     */
    PaymentMethod?: payments_enum_payment_method;
    /**
     * Indicates whether the credit card postal code (zip code) is a required piece of payment information that must be provided by the caller. The default is `true`.
     */
    PostalCode?: boolean;
    /**
     * Indicates whether the credit card security code is a required piece of payment information that must be provided by the caller. The default is `true`.
     */
    SecurityCode?: boolean;
    /**
     * Provide an absolute or relative URL to receive status updates regarding your Pay session. Read more about the [expected StatusCallback values](https://www.twilio.com/docs/voice/api/payment-resource#statuscallback)
     */
    StatusCallback: string;
    /**
     * The number of seconds that <Pay> should wait for the caller to press a digit between each subsequent digit, after the first one, before moving on to validate the digits captured. The default is `5`, maximum is `600`.
     */
    Timeout?: number;
    /**
     * Indicates whether the payment method should be tokenized as a `one-time` or `reusable` token. The default value is `reusable`. Do not enter a charge amount when tokenizing. If a charge amount is entered, the payment method will be charged and not tokenized.
     */
    TokenType?: payments_enum_token_type;
    /**
     * Credit card types separated by space that Pay should accept. The default value is `visa mastercard amex`
     */
    ValidCardTypes?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the call that will create the resource. Call leg associated with this sid is expected to provide payment information thru DTMF.
     */
    CallSid: string;
  };
};

export type CreatePaymentsResponse = api_v2010_account_call_payments;

export type CreatePaymentsError = unknown;

export type UpdatePaymentsData = {
  body?: {
    /**
     * The piece of payment information that you wish the caller to enter. Must be one of `payment-card-number`, `expiration-date`, `security-code`, `postal-code`, `bank-routing-number`, or `bank-account-number`.
     */
    Capture?: payments_enum_capture;
    /**
     * A unique token that will be used to ensure that multiple API calls with the same information do not result in multiple transactions. This should be a unique string value per API call and can be a randomly generated.
     */
    IdempotencyKey: string;
    /**
     * Indicates whether the current payment session should be cancelled or completed. When `cancel` the payment session is cancelled. When `complete`, Twilio sends the payment information to the selected Pay Connector for processing.
     */
    Status?: payments_enum_status;
    /**
     * Provide an absolute or relative URL to receive status updates regarding your Pay session. Read more about the [Update](https://www.twilio.com/docs/voice/api/payment-resource#statuscallback-update) and [Complete/Cancel](https://www.twilio.com/docs/voice/api/payment-resource#statuscallback-cancelcomplete) POST requests.
     */
    StatusCallback: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will update the resource.
     */
    AccountSid: string;
    /**
     * The SID of the call that will update the resource. This should be the same call sid that was used to create payments resource.
     */
    CallSid: string;
    /**
     * The SID of Payments session that needs to be updated.
     */
    Sid: string;
  };
};

export type UpdatePaymentsResponse = api_v2010_account_call_payments;

export type UpdatePaymentsError = unknown;

export type ListCallRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resources to read.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resources to read.
     */
    CallSid: string;
  };
  query?: {
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    DateCreated?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    'DateCreated<'?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    'DateCreated>'?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListCallRecordingResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  recordings?: Array<api_v2010_account_call_call_recording>;
  start?: number;
  uri?: string;
};

export type ListCallRecordingError = unknown;

export type CreateCallRecordingData = {
  body?: {
    /**
     * The number of channels used in the recording. Can be: `mono` or `dual` and the default is `mono`. `mono` records all parties of the call into one channel. `dual` records each party of a 2-party call into separate channels.
     */
    RecordingChannels?: string;
    /**
     * The URL we should call using the `recording_status_callback_method` on each recording event specified in  `recording_status_callback_event`. For more information, see [RecordingStatusCallback parameters](https://www.twilio.com/docs/voice/api/recording#recordingstatuscallback).
     */
    RecordingStatusCallback?: string;
    /**
     * The recording status events on which we should call the `recording_status_callback` URL. Can be: `in-progress`, `completed` and `absent` and the default is `completed`. Separate multiple event values with a space.
     */
    RecordingStatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use to call `recording_status_callback`. Can be: `GET` or `POST` and the default is `POST`.
     */
    RecordingStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The audio track to record for the call. Can be: `inbound`, `outbound` or `both`. The default is `both`. `inbound` records the audio that is received by Twilio. `outbound` records the audio that is generated from Twilio. `both` records the audio that is received and generated by Twilio.
     */
    RecordingTrack?: string;
    /**
     * Whether to trim any leading and trailing silence in the recording. Can be: `trim-silence` or `do-not-trim` and the default is `do-not-trim`. `trim-silence` trims the silence from the beginning and end of the recording and `do-not-trim` does not.
     */
    Trim?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) to associate the resource with.
     */
    CallSid: string;
  };
};

export type CreateCallRecordingResponse = api_v2010_account_call_call_recording;

export type CreateCallRecordingError = unknown;

export type DeleteCallRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resources to delete.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resources to delete.
     */
    CallSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording resource to delete.
     */
    Sid: string;
  };
};

export type DeleteCallRecordingResponse = any;

export type DeleteCallRecordingError = unknown;

export type FetchCallRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource to fetch.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resource to fetch.
     */
    CallSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording resource to fetch.
     */
    Sid: string;
  };
};

export type FetchCallRecordingResponse = api_v2010_account_call_call_recording;

export type FetchCallRecordingError = unknown;

export type UpdateCallRecordingData = {
  body?: {
    /**
     * Whether to record during a pause. Can be: `skip` or `silence` and the default is `silence`. `skip` does not record during the pause period, while `silence` will replace the actual audio of the call with silence during the pause period. This parameter only applies when setting `status` is set to `paused`.
     */
    PauseBehavior?: string;
    /**
     * The new status of the recording. Can be: `stopped`, `paused`, `in-progress`.
     */
    Status: call_recording_enum_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource to update.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resource to update.
     */
    CallSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording resource to update.
     */
    Sid: string;
  };
};

export type UpdateCallRecordingResponse = api_v2010_account_call_call_recording;

export type UpdateCallRecordingError = unknown;

export type CreateSiprecData = {
  body?: {
    /**
     * Unique name used when configuring the connector via Marketplace Add-on.
     */
    ConnectorName?: string;
    /**
     * The user-specified name of this Siprec, if one was given when the Siprec was created. This may be used to stop the Siprec.
     */
    Name?: string;
    /**
     * Parameter name
     */
    'Parameter1.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter1.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter10.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter10.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter11.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter11.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter12.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter12.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter13.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter13.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter14.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter14.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter15.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter15.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter16.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter16.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter17.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter17.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter18.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter18.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter19.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter19.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter2.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter2.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter20.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter20.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter21.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter21.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter22.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter22.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter23.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter23.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter24.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter24.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter25.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter25.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter26.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter26.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter27.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter27.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter28.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter28.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter29.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter29.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter3.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter3.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter30.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter30.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter31.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter31.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter32.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter32.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter33.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter33.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter34.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter34.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter35.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter35.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter36.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter36.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter37.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter37.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter38.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter38.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter39.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter39.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter4.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter4.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter40.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter40.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter41.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter41.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter42.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter42.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter43.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter43.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter44.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter44.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter45.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter45.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter46.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter46.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter47.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter47.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter48.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter48.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter49.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter49.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter5.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter5.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter50.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter50.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter51.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter51.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter52.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter52.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter53.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter53.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter54.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter54.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter55.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter55.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter56.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter56.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter57.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter57.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter58.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter58.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter59.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter59.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter6.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter6.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter60.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter60.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter61.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter61.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter62.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter62.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter63.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter63.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter64.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter64.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter65.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter65.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter66.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter66.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter67.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter67.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter68.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter68.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter69.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter69.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter7.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter7.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter70.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter70.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter71.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter71.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter72.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter72.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter73.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter73.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter74.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter74.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter75.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter75.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter76.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter76.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter77.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter77.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter78.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter78.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter79.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter79.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter8.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter8.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter80.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter80.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter81.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter81.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter82.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter82.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter83.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter83.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter84.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter84.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter85.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter85.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter86.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter86.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter87.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter87.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter88.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter88.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter89.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter89.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter9.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter9.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter90.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter90.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter91.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter91.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter92.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter92.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter93.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter93.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter94.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter94.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter95.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter95.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter96.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter96.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter97.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter97.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter98.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter98.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter99.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter99.Value'?: string;
    /**
     * Absolute URL of the status callback.
     */
    StatusCallback?: string;
    /**
     * The http method for the status_callback (one of GET, POST).
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * One of `inbound_track`, `outbound_track`, `both_tracks`.
     */
    Track?: siprec_enum_track;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Siprec resource.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Siprec resource is associated with.
     */
    CallSid: string;
  };
};

export type CreateSiprecResponse = api_v2010_account_call_siprec;

export type CreateSiprecError = unknown;

export type UpdateSiprecData = {
  body?: {
    /**
     * The status. Must have the value `stopped`
     */
    Status: siprec_enum_update_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Siprec resource.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Siprec resource is associated with.
     */
    CallSid: string;
    /**
     * The SID of the Siprec resource, or the `name` used when creating the resource
     */
    Sid: string;
  };
};

export type UpdateSiprecResponse = api_v2010_account_call_siprec;

export type UpdateSiprecError = unknown;

export type CreateStreamData = {
  body?: {
    /**
     * The user-specified name of this Stream, if one was given when the Stream was created. This may be used to stop the Stream.
     */
    Name?: string;
    /**
     * Parameter name
     */
    'Parameter1.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter1.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter10.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter10.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter11.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter11.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter12.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter12.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter13.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter13.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter14.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter14.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter15.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter15.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter16.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter16.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter17.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter17.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter18.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter18.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter19.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter19.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter2.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter2.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter20.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter20.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter21.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter21.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter22.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter22.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter23.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter23.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter24.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter24.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter25.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter25.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter26.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter26.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter27.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter27.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter28.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter28.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter29.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter29.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter3.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter3.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter30.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter30.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter31.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter31.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter32.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter32.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter33.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter33.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter34.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter34.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter35.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter35.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter36.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter36.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter37.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter37.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter38.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter38.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter39.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter39.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter4.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter4.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter40.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter40.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter41.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter41.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter42.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter42.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter43.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter43.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter44.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter44.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter45.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter45.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter46.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter46.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter47.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter47.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter48.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter48.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter49.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter49.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter5.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter5.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter50.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter50.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter51.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter51.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter52.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter52.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter53.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter53.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter54.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter54.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter55.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter55.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter56.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter56.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter57.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter57.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter58.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter58.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter59.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter59.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter6.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter6.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter60.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter60.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter61.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter61.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter62.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter62.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter63.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter63.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter64.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter64.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter65.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter65.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter66.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter66.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter67.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter67.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter68.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter68.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter69.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter69.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter7.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter7.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter70.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter70.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter71.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter71.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter72.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter72.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter73.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter73.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter74.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter74.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter75.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter75.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter76.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter76.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter77.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter77.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter78.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter78.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter79.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter79.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter8.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter8.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter80.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter80.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter81.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter81.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter82.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter82.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter83.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter83.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter84.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter84.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter85.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter85.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter86.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter86.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter87.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter87.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter88.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter88.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter89.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter89.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter9.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter9.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter90.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter90.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter91.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter91.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter92.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter92.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter93.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter93.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter94.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter94.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter95.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter95.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter96.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter96.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter97.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter97.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter98.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter98.Value'?: string;
    /**
     * Parameter name
     */
    'Parameter99.Name'?: string;
    /**
     * Parameter value
     */
    'Parameter99.Value'?: string;
    /**
     * Absolute URL of the status callback.
     */
    StatusCallback?: string;
    /**
     * The http method for the status_callback (one of GET, POST).
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * One of `inbound_track`, `outbound_track`, `both_tracks`.
     */
    Track?: stream_enum_track;
    /**
     * Relative or absolute url where WebSocket connection will be established.
     */
    Url: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Stream resource.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Stream resource is associated with.
     */
    CallSid: string;
  };
};

export type CreateStreamResponse = api_v2010_account_call_stream;

export type CreateStreamError = unknown;

export type UpdateStreamData = {
  body?: {
    /**
     * The status. Must have the value `stopped`
     */
    Status: stream_enum_update_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Stream resource.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Stream resource is associated with.
     */
    CallSid: string;
    /**
     * The SID of the Stream resource, or the `name` used when creating the resource
     */
    Sid: string;
  };
};

export type UpdateStreamResponse = api_v2010_account_call_stream;

export type UpdateStreamError = unknown;

export type CreateUserDefinedMessageSubscriptionData = {
  body?: {
    /**
     * The URL we should call using the `method` to send user defined events to your application. URLs must contain a valid hostname (underscores are not permitted).
     */
    Callback: string;
    /**
     * A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.
     */
    IdempotencyKey?: string;
    /**
     * The HTTP method Twilio will use when requesting the above `Url`. Either `GET` or `POST`. Default is `POST`.
     */
    Method?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that subscribed to the User Defined Messages.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Messages subscription is associated with. This refers to the Call SID that is producing the user defined messages.
     */
    CallSid: string;
  };
};

export type CreateUserDefinedMessageSubscriptionResponse = api_v2010_account_call_user_defined_message_subscription;

export type CreateUserDefinedMessageSubscriptionError = unknown;

export type DeleteUserDefinedMessageSubscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that subscribed to the User Defined Messages.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message Subscription is associated with. This refers to the Call SID that is producing the User Defined Messages.
     */
    CallSid: string;
    /**
     * The SID that uniquely identifies this User Defined Message Subscription.
     */
    Sid: string;
  };
};

export type DeleteUserDefinedMessageSubscriptionResponse = any;

export type DeleteUserDefinedMessageSubscriptionError = unknown;

export type CreateUserDefinedMessageData = {
  body?: {
    /**
     * The User Defined Message in the form of URL-encoded JSON string.
     */
    Content: string;
    /**
     * A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.
     */
    IdempotencyKey?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created User Defined Message.
     */
    AccountSid: string;
    /**
     * The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message is associated with.
     */
    CallSid: string;
  };
};

export type CreateUserDefinedMessageResponse = api_v2010_account_call_user_defined_message;

export type CreateUserDefinedMessageError = unknown;

export type DeleteCallData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call resource(s) to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided Call SID that uniquely identifies the Call resource to delete
     */
    Sid: string;
  };
};

export type DeleteCallResponse = any;

export type DeleteCallError = unknown;

export type FetchCallData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call resource(s) to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the Call resource to fetch.
     */
    Sid: string;
  };
};

export type FetchCallResponse = api_v2010_account_call;

export type FetchCallError = unknown;

export type UpdateCallData = {
  body?: {
    /**
     * The HTTP method that we should use to request the `fallback_url`. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    FallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we call using the `fallback_method` if an error occurs when requesting or executing the TwiML at `url`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    FallbackUrl?: string;
    /**
     * The HTTP method we should use when calling the `url`. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    Method?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The new status of the resource. Can be: `canceled` or `completed`. Specifying `canceled` will attempt to hang up calls that are queued or ringing; however, it will not affect calls already in progress. Specifying `completed` will attempt to hang up a call even if it's already in progress.
     */
    Status?: call_enum_update_status;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application. If no `status_callback_event` is specified, we will send the `completed` status. If an `application_sid` parameter is present, this parameter is ignored. URLs must contain a valid hostname (underscores are not permitted).
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use when requesting the `status_callback` URL. Can be: `GET` or `POST` and the default is `POST`. If an `application_sid` parameter is present, this parameter is ignored.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The maximum duration of the call in seconds. Constraints depend on account and configuration.
     */
    TimeLimit?: number;
    /**
     * TwiML instructions for the call Twilio will use without fetching Twiml from url. Twiml and url parameters are mutually exclusive
     */
    Twiml?: string;
    /**
     * The absolute URL that returns the TwiML instructions for the call. We will call this URL using the `method` when the call connects. For more information, see the [Url Parameter](https://www.twilio.com/docs/voice/make-calls#specify-a-url-parameter) section in [Making Calls](https://www.twilio.com/docs/voice/make-calls).
     */
    Url?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call resource(s) to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Call resource to update
     */
    Sid: string;
  };
};

export type UpdateCallResponse = api_v2010_account_call;

export type UpdateCallError = unknown;

export type ListConferenceData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference resource(s) to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that started on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify  conferences that started on or after midnight on a date, use `>=YYYY-MM-DD`.
     */
    DateCreated?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that started on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify  conferences that started on or after midnight on a date, use `>=YYYY-MM-DD`.
     */
    'DateCreated<'?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that started on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify  conferences that started on or after midnight on a date, use `>=YYYY-MM-DD`.
     */
    'DateCreated>'?: string;
    /**
     * The `date_updated` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that were last updated on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify conferences that were last updated on or after midnight on a given date, use  `>=YYYY-MM-DD`.
     */
    DateUpdated?: string;
    /**
     * The `date_updated` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that were last updated on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify conferences that were last updated on or after midnight on a given date, use  `>=YYYY-MM-DD`.
     */
    'DateUpdated<'?: string;
    /**
     * The `date_updated` value, specified as `YYYY-MM-DD`, of the resources to read. To read conferences that were last updated on or before midnight on a date, use `<=YYYY-MM-DD`, and to specify conferences that were last updated on or after midnight on a given date, use  `>=YYYY-MM-DD`.
     */
    'DateUpdated>'?: string;
    /**
     * The string that identifies the Conference resources to read.
     */
    FriendlyName?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The status of the resources to read. Can be: `init`, `in-progress`, or `completed`.
     */
    Status?: conference_enum_status;
  };
};

export type ListConferenceResponse = {
  conferences?: Array<api_v2010_account_conference>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListConferenceError = unknown;

export type ListParticipantData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the conference with the participants to read.
     */
    ConferenceSid: string;
  };
  query?: {
    /**
     * Whether to return only participants who are coaching another call. Can be: `true` or `false`.
     */
    Coaching?: boolean;
    /**
     * Whether to return only participants that are on hold. Can be: `true` or `false`.
     */
    Hold?: boolean;
    /**
     * Whether to return only participants that are muted. Can be: `true` or `false`.
     */
    Muted?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListParticipantResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  participants?: Array<api_v2010_account_conference_participant>;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListParticipantError = unknown;

export type CreateParticipantData = {
  body?: {
    /**
     * The URL that we should call using the `amd_status_callback_method` to notify customer application whether the call was answered by human, machine or fax.
     */
    AmdStatusCallback?: string;
    /**
     * The HTTP method we should use when calling the `amd_status_callback` URL. Can be: `GET` or `POST` and the default is `POST`.
     */
    AmdStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Whether to play a notification beep to the conference when the participant joins. Can be: `true`, `false`, `onEnter`, or `onExit`. The default value is `true`.
     */
    Beep?: string;
    /**
     * The SID of a BYOC (Bring Your Own Carrier) trunk to route this call with. Note that `byoc` is only meaningful when `to` is a phone number; it will otherwise be ignored. (Beta)
     */
    Byoc?: string;
    /**
     * The Reason for the outgoing call. Use it to specify the purpose of the call that is presented on the called party's phone. (Branded Calls Beta)
     */
    CallReason?: string;
    /**
     * The SID of the participant who is being `coached`. The participant being coached is the only participant who can hear the participant who is `coaching`.
     */
    CallSidToCoach?: string;
    /**
     * A token string needed to invoke a forwarded call. A call_token is generated when an incoming call is received on a Twilio number. Pass an incoming call's call_token value to a forwarded call via the call_token parameter when creating a new call. A forwarded call should bear the same CallerID of the original incoming call.
     */
    CallToken?: string;
    /**
     * The phone number, Client identifier, or username portion of SIP address that made this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). Client identifiers are formatted `client:name`. If using a phone number, it must be a Twilio number or a Verified [outgoing caller id](https://www.twilio.com/docs/voice/api/outgoing-caller-ids) for your account. If the `to` parameter is a phone number, `callerId` must also be a phone number. If `to` is sip address, this value of `callerId` should be a username portion to be used to populate the From header that is passed to the SIP endpoint.
     */
    CallerId?: string;
    /**
     * Whether the participant is coaching another call. Can be: `true` or `false`. If not present, defaults to `false` unless `call_sid_to_coach` is defined. If `true`, `call_sid_to_coach` must be defined.
     */
    Coaching?: boolean;
    /**
     * Whether to record the conference the participant is joining. Can be: `true`, `false`, `record-from-start`, and `do-not-record`. The default value is `false`.
     */
    ConferenceRecord?: string;
    /**
     * The URL we should call using the `conference_recording_status_callback_method` when the conference recording is available.
     */
    ConferenceRecordingStatusCallback?: string;
    /**
     * The conference recording state changes that generate a call to `conference_recording_status_callback`. Can be: `in-progress`, `completed`, `failed`, and `absent`. Separate multiple values with a space, ex: `'in-progress completed failed'`
     */
    ConferenceRecordingStatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use to call `conference_recording_status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    ConferenceRecordingStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call using the `conference_status_callback_method` when the conference events in `conference_status_callback_event` occur. Only the value set by the first participant to join the conference is used. Subsequent `conference_status_callback` values are ignored.
     */
    ConferenceStatusCallback?: string;
    /**
     * The conference state changes that should generate a call to `conference_status_callback`. Can be: `start`, `end`, `join`, `leave`, `mute`, `hold`, `modify`, `speaker`, and `announcement`. Separate multiple values with a space. Defaults to `start end`.
     */
    ConferenceStatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use to call `conference_status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    ConferenceStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * Whether to trim leading and trailing silence from the conference recording. Can be: `trim-silence` or `do-not-trim` and defaults to `trim-silence`.
     */
    ConferenceTrim?: string;
    /**
     * Whether to allow an agent to hear the state of the outbound call, including ringing or disconnect messages. Can be: `true` or `false` and defaults to `true`.
     */
    EarlyMedia?: boolean;
    /**
     * Whether to end the conference when the participant leaves. Can be: `true` or `false` and defaults to `false`.
     */
    EndConferenceOnExit?: boolean;
    /**
     * The phone number, Client identifier, or username portion of SIP address that made this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). Client identifiers are formatted `client:name`. If using a phone number, it must be a Twilio number or a Verified [outgoing caller id](https://www.twilio.com/docs/voice/api/outgoing-caller-ids) for your account. If the `to` parameter is a phone number, `from` must also be a phone number. If `to` is sip address, this value of `from` should be a username portion to be used to populate the P-Asserted-Identity header that is passed to the SIP endpoint.
     */
    From: string;
    /**
     * Jitter buffer size for the connecting participant. Twilio will use this setting to apply Jitter Buffer before participant's audio is mixed into the conference. Can be: `off`, `small`, `medium`, and `large`. Default to `large`.
     */
    JitterBufferSize?: string;
    /**
     * A label for this participant. If one is supplied, it may subsequently be used to fetch, update or delete the participant.
     */
    Label?: string;
    /**
     * Whether to detect if a human, answering machine, or fax has picked up the call. Can be: `Enable` or `DetectMessageEnd`. Use `Enable` if you would like us to return `AnsweredBy` as soon as the called party is identified. Use `DetectMessageEnd`, if you would like to leave a message on an answering machine. For more information, see [Answering Machine Detection](https://www.twilio.com/docs/voice/answering-machine-detection).
     */
    MachineDetection?: string;
    /**
     * The number of milliseconds of initial silence after which an `unknown` AnsweredBy result will be returned. Possible Values: 2000-10000. Default: 5000.
     */
    MachineDetectionSilenceTimeout?: number;
    /**
     * The number of milliseconds of silence after speech activity at which point the speech activity is considered complete. Possible Values: 500-5000. Default: 1200.
     */
    MachineDetectionSpeechEndThreshold?: number;
    /**
     * The number of milliseconds that is used as the measuring stick for the length of the speech activity, where durations lower than this value will be interpreted as a human and longer than this value as a machine. Possible Values: 1000-6000. Default: 2400.
     */
    MachineDetectionSpeechThreshold?: number;
    /**
     * The number of seconds that we should attempt to detect an answering machine before timing out and sending a voice request with `AnsweredBy` of `unknown`. The default timeout is 30 seconds.
     */
    MachineDetectionTimeout?: number;
    /**
     * The maximum number of participants in the conference. Can be a positive integer from `2` to `250`. The default value is `250`.
     */
    MaxParticipants?: number;
    /**
     * Whether the agent is muted in the conference. Can be `true` or `false` and the default is `false`.
     */
    Muted?: boolean;
    /**
     * Whether to record the participant and their conferences, including the time between conferences. Can be `true` or `false` and the default is `false`.
     */
    Record?: boolean;
    /**
     * The recording channels for the final recording. Can be: `mono` or `dual` and the default is `mono`.
     */
    RecordingChannels?: string;
    /**
     * The URL that we should call using the `recording_status_callback_method` when the recording status changes.
     */
    RecordingStatusCallback?: string;
    /**
     * The recording state changes that should generate a call to `recording_status_callback`. Can be: `started`, `in-progress`, `paused`, `resumed`, `stopped`, `completed`, `failed`, and `absent`. Separate multiple values with a space, ex: `'in-progress completed failed'`.
     */
    RecordingStatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use when we call `recording_status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    RecordingStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The audio track to record for the call. Can be: `inbound`, `outbound` or `both`. The default is `both`. `inbound` records the audio that is received by Twilio. `outbound` records the audio that is sent from Twilio. `both` records the audio that is received and sent by Twilio.
     */
    RecordingTrack?: string;
    /**
     * The [region](https://support.twilio.com/hc/en-us/articles/223132167-How-global-low-latency-routing-and-region-selection-work-for-conferences-and-Client-calls) where we should mix the recorded audio. Can be:`us1`, `ie1`, `de1`, `sg1`, `br1`, `au1`, or `jp1`.
     */
    Region?: string;
    /**
     * The SIP password for authentication.
     */
    SipAuthPassword?: string;
    /**
     * The SIP username used for authentication.
     */
    SipAuthUsername?: string;
    /**
     * Whether to start the conference when the participant joins, if it has not already started. Can be: `true` or `false` and the default is `true`. If `false` and the conference has not started, the participant is muted and hears background music until another participant starts the conference.
     */
    StartConferenceOnEnter?: boolean;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The conference state changes that should generate a call to `status_callback`. Can be: `initiated`, `ringing`, `answered`, and `completed`. Separate multiple values with a space. The default value is `completed`.
     */
    StatusCallbackEvent?: Array<string>;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` and `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The maximum duration of the call in seconds. Constraints depend on account and configuration.
     */
    TimeLimit?: number;
    /**
     * The number of seconds that we should allow the phone to ring before assuming there is no answer. Can be an integer between `5` and `600`, inclusive. The default value is `60`. We always add a 5-second timeout buffer to outgoing calls, so  value of 10 would result in an actual timeout that was closer to 15 seconds.
     */
    Timeout?: number;
    /**
     * The phone number, SIP address, or Client identifier that received this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). SIP addresses are formatted as `sip:name@company.com`. Client identifiers are formatted `client:name`. [Custom parameters](https://www.twilio.com/docs/voice/api/conference-participant-resource#custom-parameters) may also be specified.
     */
    To: string;
    /**
     * Whether to trim any leading and trailing silence from the participant recording. Can be: `trim-silence` or `do-not-trim` and the default is `trim-silence`.
     */
    Trim?: string;
    /**
     * The HTTP method we should use to call `wait_url`. Can be `GET` or `POST` and the default is `POST`. When using a static audio file, this should be `GET` so that we can cache the file.
     */
    WaitMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call using the `wait_method` for the music to play while participants are waiting for the conference to start. The default value is the URL of our standard hold music. [Learn more about hold music](https://www.twilio.com/labs/twimlets/holdmusic).
     */
    WaitUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the participant's conference.
     */
    ConferenceSid: string;
  };
};

export type CreateParticipantResponse = api_v2010_account_conference_participant;

export type CreateParticipantError = unknown;

export type DeleteParticipantData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resources to delete.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID or label of the participant to delete. Non URL safe characters in a label must be percent encoded, for example, a space character is represented as %20.
     */
    CallSid: string;
    /**
     * The SID of the conference with the participants to delete.
     */
    ConferenceSid: string;
  };
};

export type DeleteParticipantResponse = any;

export type DeleteParticipantError = unknown;

export type FetchParticipantData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resource to fetch.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID or label of the participant to fetch. Non URL safe characters in a label must be percent encoded, for example, a space character is represented as %20.
     */
    CallSid: string;
    /**
     * The SID of the conference with the participant to fetch.
     */
    ConferenceSid: string;
  };
};

export type FetchParticipantResponse = api_v2010_account_conference_participant;

export type FetchParticipantError = unknown;

export type UpdateParticipantData = {
  body?: {
    /**
     * The HTTP method we should use to call `announce_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    AnnounceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we call using the `announce_method` for an announcement to the participant. The URL may return an MP3 file, a WAV file, or a TwiML document that contains `<Play>`, `<Say>`, `<Pause>`, or `<Redirect>` verbs.
     */
    AnnounceUrl?: string;
    /**
     * Whether to play a notification beep to the conference when the participant exits. Can be: `true` or `false`.
     */
    BeepOnExit?: boolean;
    /**
     * The SID of the participant who is being `coached`. The participant being coached is the only participant who can hear the participant who is `coaching`.
     */
    CallSidToCoach?: string;
    /**
     * Whether the participant is coaching another call. Can be: `true` or `false`. If not present, defaults to `false` unless `call_sid_to_coach` is defined. If `true`, `call_sid_to_coach` must be defined.
     */
    Coaching?: boolean;
    /**
     * Whether to end the conference when the participant leaves. Can be: `true` or `false` and defaults to `false`.
     */
    EndConferenceOnExit?: boolean;
    /**
     * Whether the participant should be on hold. Can be: `true` or `false`. `true` puts the participant on hold, and `false` lets them rejoin the conference.
     */
    Hold?: boolean;
    /**
     * The HTTP method we should use to call `hold_url`. Can be: `GET` or `POST` and the default is `GET`.
     */
    HoldMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we call using the `hold_method` for music that plays when the participant is on hold. The URL may return an MP3 file, a WAV file, or a TwiML document that contains `<Play>`, `<Say>`, `<Pause>`, or `<Redirect>` verbs.
     */
    HoldUrl?: string;
    /**
     * Whether the participant should be muted. Can be `true` or `false`. `true` will mute the participant, and `false` will un-mute them. Anything value other than `true` or `false` is interpreted as `false`.
     */
    Muted?: boolean;
    /**
     * The HTTP method we should use to call `wait_url`. Can be `GET` or `POST` and the default is `POST`. When using a static audio file, this should be `GET` so that we can cache the file.
     */
    WaitMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we call using the `wait_method` for the music to play while participants are waiting for the conference to start. The URL may return an MP3 file, a WAV file, or a TwiML document that contains `<Play>`, `<Say>`, `<Pause>`, or `<Redirect>` verbs. The default value is the URL of our standard hold music. [Learn more about hold music](https://www.twilio.com/labs/twimlets/holdmusic).
     */
    WaitUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resources to update.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID or label of the participant to update. Non URL safe characters in a label must be percent encoded, for example, a space character is represented as %20.
     */
    CallSid: string;
    /**
     * The SID of the conference with the participant to update.
     */
    ConferenceSid: string;
  };
};

export type UpdateParticipantResponse = api_v2010_account_conference_participant;

export type UpdateParticipantError = unknown;

export type ListConferenceRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resources to read.
     */
    AccountSid: string;
    /**
     * The Conference SID that identifies the conference associated with the recording to read.
     */
    ConferenceSid: string;
  };
  query?: {
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    DateCreated?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    'DateCreated<'?: string;
    /**
     * The `date_created` value, specified as `YYYY-MM-DD`, of the resources to read. You can also specify inequality: `DateCreated<=YYYY-MM-DD` will return recordings generated at or before midnight on a given date, and `DateCreated>=YYYY-MM-DD` returns recordings generated at or after midnight on a date.
     */
    'DateCreated>'?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListConferenceRecordingResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  recordings?: Array<api_v2010_account_conference_conference_recording>;
  start?: number;
  uri?: string;
};

export type ListConferenceRecordingError = unknown;

export type DeleteConferenceRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resources to delete.
     */
    AccountSid: string;
    /**
     * The Conference SID that identifies the conference associated with the recording to delete.
     */
    ConferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Conference Recording resource to delete.
     */
    Sid: string;
  };
};

export type DeleteConferenceRecordingResponse = any;

export type DeleteConferenceRecordingError = unknown;

export type FetchConferenceRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resource to fetch.
     */
    AccountSid: string;
    /**
     * The Conference SID that identifies the conference associated with the recording to fetch.
     */
    ConferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Conference Recording resource to fetch.
     */
    Sid: string;
  };
};

export type FetchConferenceRecordingResponse = api_v2010_account_conference_conference_recording;

export type FetchConferenceRecordingError = unknown;

export type UpdateConferenceRecordingData = {
  body?: {
    /**
     * Whether to record during a pause. Can be: `skip` or `silence` and the default is `silence`. `skip` does not record during the pause period, while `silence` will replace the actual audio of the call with silence during the pause period. This parameter only applies when setting `status` is set to `paused`.
     */
    PauseBehavior?: string;
    /**
     * The new status of the recording. Can be: `stopped`, `paused`, `in-progress`.
     */
    Status: conference_recording_enum_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resource to update.
     */
    AccountSid: string;
    /**
     * The Conference SID that identifies the conference associated with the recording to update.
     */
    ConferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Conference Recording resource to update. Use `Twilio.CURRENT` to reference the current active recording.
     */
    Sid: string;
  };
};

export type UpdateConferenceRecordingResponse = api_v2010_account_conference_conference_recording;

export type UpdateConferenceRecordingError = unknown;

export type FetchConferenceData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference resource(s) to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Conference resource to fetch
     */
    Sid: string;
  };
};

export type FetchConferenceResponse = api_v2010_account_conference;

export type FetchConferenceError = unknown;

export type UpdateConferenceData = {
  body?: {
    /**
     * The HTTP method used to call `announce_url`. Can be: `GET` or `POST` and the default is `POST`
     */
    AnnounceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call to announce something into the conference. The URL may return an MP3 file, a WAV file, or a TwiML document that contains `<Play>`, `<Say>`, `<Pause>`, or `<Redirect>` verbs.
     */
    AnnounceUrl?: string;
    /**
     * The new status of the resource. Can be:  Can be: `init`, `in-progress`, or `completed`. Specifying `completed` will end the conference and hang up all participants
     */
    Status?: conference_enum_update_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference resource(s) to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Conference resource to update
     */
    Sid: string;
  };
};

export type UpdateConferenceResponse = api_v2010_account_conference;

export type UpdateConferenceError = unknown;

export type ListConnectAppData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListConnectAppResponse = {
  connect_apps?: Array<api_v2010_account_connect_app>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListConnectAppError = unknown;

export type DeleteConnectAppData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the ConnectApp resource to fetch.
     */
    Sid: string;
  };
};

export type DeleteConnectAppResponse = any;

export type DeleteConnectAppError = unknown;

export type FetchConnectAppData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the ConnectApp resource to fetch.
     */
    Sid: string;
  };
};

export type FetchConnectAppResponse = api_v2010_account_connect_app;

export type FetchConnectAppError = unknown;

export type UpdateConnectAppData = {
  body?: {
    /**
     * The URL to redirect the user to after we authenticate the user and obtain authorization to access the Connect App.
     */
    AuthorizeRedirectUrl?: string;
    /**
     * The company name to set for the Connect App.
     */
    CompanyName?: string;
    /**
     * The HTTP method to use when calling `deauthorize_callback_url`.
     */
    DeauthorizeCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL to call using the `deauthorize_callback_method` to de-authorize the Connect App.
     */
    DeauthorizeCallbackUrl?: string;
    /**
     * A description of the Connect App.
     */
    Description?: string;
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * A public URL where users can obtain more information about this Connect App.
     */
    HomepageUrl?: string;
    /**
     * A comma-separated list of the permissions you will request from the users of this ConnectApp.  Can include: `get-all` and `post-all`.
     */
    Permissions?: Array<connect_app_enum_permission>;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resources to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the ConnectApp resource to update.
     */
    Sid: string;
  };
};

export type UpdateConnectAppResponse = api_v2010_account_connect_app;

export type UpdateConnectAppError = unknown;

export type ListIncomingPhoneNumberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IncomingPhoneNumber resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Whether to include phone numbers new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * A string that identifies the IncomingPhoneNumber resources to read.
     */
    FriendlyName?: string;
    /**
     * Whether to include phone numbers based on their origin. Can be: `twilio` or `hosted`. By default, phone numbers of all origin are included.
     */
    Origin?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The phone numbers of the IncomingPhoneNumber resources to read. You can specify partial numbers and use '*' as a wildcard for any digit.
     */
    PhoneNumber?: string;
  };
};

export type ListIncomingPhoneNumberResponse = {
  end?: number;
  first_page_uri?: string;
  incoming_phone_numbers?: Array<api_v2010_account_incoming_phone_number>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberError = unknown;

export type CreateIncomingPhoneNumberData = {
  body?: {
    /**
     * The SID of the Address resource we should associate with the new phone number. Some regions require addresses to meet local regulations.
     */
    AddressSid?: string;
    /**
     * The API version to use for incoming calls made to the new phone number. The default is `2010-04-01`.
     */
    ApiVersion?: string;
    /**
     * The desired area code for your new incoming phone number. Can be any three-digit, US or Canada area code. We will provision an available phone number within this area code for you. **You must provide an `area_code` or a `phone_number`.** (US and Canada only).
     */
    AreaCode?: string;
    /**
     * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
     */
    BundleSid?: string;
    /**
     * The SID of the emergency address configuration to use for emergency calling from the new phone number.
     */
    EmergencyAddressSid?: string;
    /**
     * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
     */
    EmergencyStatus?: incoming_phone_number_enum_emergency_status;
    /**
     * A descriptive string that you created to describe the new phone number. It can be up to 64 characters long. By default, this is a formatted version of the new phone number.
     */
    FriendlyName?: string;
    /**
     * The SID of the Identity resource that we should associate with the new phone number. Some regions require an identity to meet local regulations.
     */
    IdentitySid?: string;
    /**
     * The phone number to purchase specified in [E.164](https://www.twilio.com/docs/glossary/what-e164) format.  E.164 phone numbers consist of a + followed by the country code and subscriber number without punctuation characters. For example, +14155551234.
     */
    PhoneNumber?: string;
    /**
     * The SID of the application that should handle SMS messages sent to the new phone number. If an `sms_application_sid` is present, we ignore all of the `sms_*_url` urls and use those set on the application.
     */
    SmsApplicationSid?: string;
    /**
     * The HTTP method that we should use to call `sms_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while requesting or executing the TwiML defined by `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `sms_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the new phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of the Trunk we should use to handle calls to the new phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use only those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
     */
    TrunkSid?: string;
    /**
     * The SID of the application we should use to handle calls to the new phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use only those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
     */
    VoiceApplicationSid?: string;
    /**
     * Whether to lookup the caller's name from the CNAM database and post it to your app. Can be: `true` or `false` and defaults to `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method that we should use to call `voice_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `voice_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The configuration parameter for the new phone number to receive incoming voice calls or faxes. Can be: `fax` or `voice` and defaults to `voice`.
     */
    VoiceReceiveMode?: incoming_phone_number_enum_voice_receive_mode;
    /**
     * The URL that we should call to answer a call to the new phone number. The `voice_url` will not be called if a `voice_application_sid` or a `trunk_sid` is set.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateIncomingPhoneNumberResponse = api_v2010_account_incoming_phone_number;

export type CreateIncomingPhoneNumberError = unknown;

export type ListIncomingPhoneNumberLocalData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Whether to include phone numbers new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * A string that identifies the resources to read.
     */
    FriendlyName?: string;
    /**
     * Whether to include phone numbers based on their origin. Can be: `twilio` or `hosted`. By default, phone numbers of all origin are included.
     */
    Origin?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The phone numbers of the IncomingPhoneNumber resources to read. You can specify partial numbers and use '*' as a wildcard for any digit.
     */
    PhoneNumber?: string;
  };
};

export type ListIncomingPhoneNumberLocalResponse = {
  end?: number;
  first_page_uri?: string;
  incoming_phone_numbers?: Array<api_v2010_account_incoming_phone_number_incoming_phone_number_local>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberLocalError = unknown;

export type CreateIncomingPhoneNumberLocalData = {
  body?: {
    /**
     * The SID of the Address resource we should associate with the new phone number. Some regions require addresses to meet local regulations.
     */
    AddressSid?: string;
    /**
     * The API version to use for incoming calls made to the new phone number. The default is `2010-04-01`.
     */
    ApiVersion?: string;
    /**
     * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
     */
    BundleSid?: string;
    /**
     * The SID of the emergency address configuration to use for emergency calling from the new phone number.
     */
    EmergencyAddressSid?: string;
    /**
     * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
     */
    EmergencyStatus?: incoming_phone_number_local_enum_emergency_status;
    /**
     * A descriptive string that you created to describe the new phone number. It can be up to 64 characters long. By default, this is a formatted version of the phone number.
     */
    FriendlyName?: string;
    /**
     * The SID of the Identity resource that we should associate with the new phone number. Some regions require an identity to meet local regulations.
     */
    IdentitySid?: string;
    /**
     * The phone number to purchase specified in [E.164](https://www.twilio.com/docs/glossary/what-e164) format.  E.164 phone numbers consist of a + followed by the country code and subscriber number without punctuation characters. For example, +14155551234.
     */
    PhoneNumber: string;
    /**
     * The SID of the application that should handle SMS messages sent to the new phone number. If an `sms_application_sid` is present, we ignore all of the `sms_*_url` urls and use those set on the application.
     */
    SmsApplicationSid?: string;
    /**
     * The HTTP method that we should use to call `sms_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while requesting or executing the TwiML defined by `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `sms_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the new phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of the Trunk we should use to handle calls to the new phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use only those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
     */
    TrunkSid?: string;
    /**
     * The SID of the application we should use to handle calls to the new phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use only those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
     */
    VoiceApplicationSid?: string;
    /**
     * Whether to lookup the caller's name from the CNAM database and post it to your app. Can be: `true` or `false` and defaults to `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method that we should use to call `voice_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `voice_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The configuration parameter for the new phone number to receive incoming voice calls or faxes. Can be: `fax` or `voice` and defaults to `voice`.
     */
    VoiceReceiveMode?: incoming_phone_number_local_enum_voice_receive_mode;
    /**
     * The URL that we should call to answer a call to the new phone number. The `voice_url` will not be called if a `voice_application_sid` or a `trunk_sid` is set.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateIncomingPhoneNumberLocalResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_local;

export type CreateIncomingPhoneNumberLocalError = unknown;

export type ListIncomingPhoneNumberMobileData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Whether to include phone numbers new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * A string that identifies the resources to read.
     */
    FriendlyName?: string;
    /**
     * Whether to include phone numbers based on their origin. Can be: `twilio` or `hosted`. By default, phone numbers of all origin are included.
     */
    Origin?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The phone numbers of the IncomingPhoneNumber resources to read. You can specify partial numbers and use '*' as a wildcard for any digit.
     */
    PhoneNumber?: string;
  };
};

export type ListIncomingPhoneNumberMobileResponse = {
  end?: number;
  first_page_uri?: string;
  incoming_phone_numbers?: Array<api_v2010_account_incoming_phone_number_incoming_phone_number_mobile>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberMobileError = unknown;

export type CreateIncomingPhoneNumberMobileData = {
  body?: {
    /**
     * The SID of the Address resource we should associate with the new phone number. Some regions require addresses to meet local regulations.
     */
    AddressSid?: string;
    /**
     * The API version to use for incoming calls made to the new phone number. The default is `2010-04-01`.
     */
    ApiVersion?: string;
    /**
     * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
     */
    BundleSid?: string;
    /**
     * The SID of the emergency address configuration to use for emergency calling from the new phone number.
     */
    EmergencyAddressSid?: string;
    /**
     * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
     */
    EmergencyStatus?: incoming_phone_number_mobile_enum_emergency_status;
    /**
     * A descriptive string that you created to describe the new phone number. It can be up to 64 characters long. By default, the is a formatted version of the phone number.
     */
    FriendlyName?: string;
    /**
     * The SID of the Identity resource that we should associate with the new phone number. Some regions require an identity to meet local regulations.
     */
    IdentitySid?: string;
    /**
     * The phone number to purchase specified in [E.164](https://www.twilio.com/docs/glossary/what-e164) format.  E.164 phone numbers consist of a + followed by the country code and subscriber number without punctuation characters. For example, +14155551234.
     */
    PhoneNumber: string;
    /**
     * The SID of the application that should handle SMS messages sent to the new phone number. If an `sms_application_sid` is present, we ignore all of the `sms_*_url` urls and use those of the application.
     */
    SmsApplicationSid?: string;
    /**
     * The HTTP method that we should use to call `sms_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while requesting or executing the TwiML defined by `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `sms_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the new phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of the Trunk we should use to handle calls to the new phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use only those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
     */
    TrunkSid?: string;
    /**
     * The SID of the application we should use to handle calls to the new phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use only those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
     */
    VoiceApplicationSid?: string;
    /**
     * Whether to lookup the caller's name from the CNAM database and post it to your app. Can be: `true` or `false` and defaults to `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method that we should use to call `voice_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `voice_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The configuration parameter for the new phone number to receive incoming voice calls or faxes. Can be: `fax` or `voice` and defaults to `voice`.
     */
    VoiceReceiveMode?: incoming_phone_number_mobile_enum_voice_receive_mode;
    /**
     * The URL that we should call to answer a call to the new phone number. The `voice_url` will not be called if a `voice_application_sid` or a `trunk_sid` is set.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateIncomingPhoneNumberMobileResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_mobile;

export type CreateIncomingPhoneNumberMobileError = unknown;

export type ListIncomingPhoneNumberTollFreeData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Whether to include phone numbers new to the Twilio platform. Can be: `true` or `false` and the default is `true`.
     */
    Beta?: boolean;
    /**
     * A string that identifies the resources to read.
     */
    FriendlyName?: string;
    /**
     * Whether to include phone numbers based on their origin. Can be: `twilio` or `hosted`. By default, phone numbers of all origin are included.
     */
    Origin?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The phone numbers of the IncomingPhoneNumber resources to read. You can specify partial numbers and use '*' as a wildcard for any digit.
     */
    PhoneNumber?: string;
  };
};

export type ListIncomingPhoneNumberTollFreeResponse = {
  end?: number;
  first_page_uri?: string;
  incoming_phone_numbers?: Array<api_v2010_account_incoming_phone_number_incoming_phone_number_toll_free>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberTollFreeError = unknown;

export type CreateIncomingPhoneNumberTollFreeData = {
  body?: {
    /**
     * The SID of the Address resource we should associate with the new phone number. Some regions require addresses to meet local regulations.
     */
    AddressSid?: string;
    /**
     * The API version to use for incoming calls made to the new phone number. The default is `2010-04-01`.
     */
    ApiVersion?: string;
    /**
     * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
     */
    BundleSid?: string;
    /**
     * The SID of the emergency address configuration to use for emergency calling from the new phone number.
     */
    EmergencyAddressSid?: string;
    /**
     * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
     */
    EmergencyStatus?: incoming_phone_number_toll_free_enum_emergency_status;
    /**
     * A descriptive string that you created to describe the new phone number. It can be up to 64 characters long. By default, this is a formatted version of the phone number.
     */
    FriendlyName?: string;
    /**
     * The SID of the Identity resource that we should associate with the new phone number. Some regions require an Identity to meet local regulations.
     */
    IdentitySid?: string;
    /**
     * The phone number to purchase specified in [E.164](https://www.twilio.com/docs/glossary/what-e164) format.  E.164 phone numbers consist of a + followed by the country code and subscriber number without punctuation characters. For example, +14155551234.
     */
    PhoneNumber: string;
    /**
     * The SID of the application that should handle SMS messages sent to the new phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.
     */
    SmsApplicationSid?: string;
    /**
     * The HTTP method that we should use to call `sms_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while requesting or executing the TwiML defined by `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `sms_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the new phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of the Trunk we should use to handle calls to the new phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use only those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
     */
    TrunkSid?: string;
    /**
     * The SID of the application we should use to handle calls to the new phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
     */
    VoiceApplicationSid?: string;
    /**
     * Whether to lookup the caller's name from the CNAM database and post it to your app. Can be: `true` or `false` and defaults to `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method that we should use to call `voice_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `voice_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The configuration parameter for the new phone number to receive incoming voice calls or faxes. Can be: `fax` or `voice` and defaults to `voice`.
     */
    VoiceReceiveMode?: incoming_phone_number_toll_free_enum_voice_receive_mode;
    /**
     * The URL that we should call to answer a call to the new phone number. The `voice_url` will not be called if a `voice_application_sid` or a `trunk_sid` is set.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateIncomingPhoneNumberTollFreeResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_toll_free;

export type CreateIncomingPhoneNumberTollFreeError = unknown;

export type ListIncomingPhoneNumberAssignedAddOnData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    ResourceSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListIncomingPhoneNumberAssignedAddOnResponse = {
  assigned_add_ons?: Array<api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberAssignedAddOnError = unknown;

export type CreateIncomingPhoneNumberAssignedAddOnData = {
  body?: {
    /**
     * The SID that identifies the Add-on installation.
     */
    InstalledAddOnSid: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the Phone Number to assign the Add-on.
     */
    ResourceSid: string;
  };
};

export type CreateIncomingPhoneNumberAssignedAddOnResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on;

export type CreateIncomingPhoneNumberAssignedAddOnError = unknown;

export type ListIncomingPhoneNumberAssignedAddOnExtensionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to read.
     */
    AccountSid: string;
    /**
     * The SID that uniquely identifies the assigned Add-on installation.
     */
    AssignedAddOnSid: string;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    ResourceSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListIncomingPhoneNumberAssignedAddOnExtensionResponse = {
  end?: number;
  extensions?: Array<api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on_incoming_phone_number_assigned_add_on_extension>;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListIncomingPhoneNumberAssignedAddOnExtensionError = unknown;

export type FetchIncomingPhoneNumberAssignedAddOnExtensionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID that uniquely identifies the assigned Add-on installation.
     */
    AssignedAddOnSid: string;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    ResourceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchIncomingPhoneNumberAssignedAddOnExtensionResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on_incoming_phone_number_assigned_add_on_extension;

export type FetchIncomingPhoneNumberAssignedAddOnExtensionError = unknown;

export type DeleteIncomingPhoneNumberAssignedAddOnData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    ResourceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteIncomingPhoneNumberAssignedAddOnResponse = any;

export type DeleteIncomingPhoneNumberAssignedAddOnError = unknown;

export type FetchIncomingPhoneNumberAssignedAddOnData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the Phone Number to which the Add-on is assigned.
     */
    ResourceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchIncomingPhoneNumberAssignedAddOnResponse =
  api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on;

export type FetchIncomingPhoneNumberAssignedAddOnError = unknown;

export type DeleteIncomingPhoneNumberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IncomingPhoneNumber resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the IncomingPhoneNumber resource to delete.
     */
    Sid: string;
  };
};

export type DeleteIncomingPhoneNumberResponse = any;

export type DeleteIncomingPhoneNumberError = unknown;

export type FetchIncomingPhoneNumberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IncomingPhoneNumber resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the IncomingPhoneNumber resource to fetch.
     */
    Sid: string;
  };
};

export type FetchIncomingPhoneNumberResponse = api_v2010_account_incoming_phone_number;

export type FetchIncomingPhoneNumberError = unknown;

export type UpdateIncomingPhoneNumberData = {
  body?: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IncomingPhoneNumber resource to update.  For more information, see [Exchanging Numbers Between Subaccounts](https://www.twilio.com/docs/iam/api/subaccounts#exchanging-numbers).
     */
    AccountSid?: string;
    /**
     * The SID of the Address resource we should associate with the phone number. Some regions require addresses to meet local regulations.
     */
    AddressSid?: string;
    /**
     * The API version to use for incoming calls made to the phone number. The default is `2010-04-01`.
     */
    ApiVersion?: string;
    /**
     * The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.
     */
    BundleSid?: string;
    /**
     * The SID of the emergency address configuration to use for emergency calling from this phone number.
     */
    EmergencyAddressSid?: string;
    /**
     * The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.
     */
    EmergencyStatus?: incoming_phone_number_enum_emergency_status;
    /**
     * A descriptive string that you created to describe this phone number. It can be up to 64 characters long. By default, this is a formatted version of the phone number.
     */
    FriendlyName?: string;
    /**
     * The SID of the Identity resource that we should associate with the phone number. Some regions require an identity to meet local regulations.
     */
    IdentitySid?: string;
    /**
     * The SID of the application that should handle SMS messages sent to the number. If an `sms_application_sid` is present, we ignore all of the `sms_*_url` urls and use those set on the application.
     */
    SmsApplicationSid?: string;
    /**
     * The HTTP method that we should use to call `sms_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while requesting or executing the TwiML defined by `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `sms_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when the phone number receives an incoming SMS message.
     */
    SmsUrl?: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The SID of the Trunk we should use to handle phone calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use only those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.
     */
    TrunkSid?: string;
    /**
     * The SID of the application we should use to handle phone calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use only those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.
     */
    VoiceApplicationSid?: string;
    /**
     * Whether to lookup the caller's name from the CNAM database and post it to your app. Can be: `true` or `false` and defaults to `false`.
     */
    VoiceCallerIdLookup?: boolean;
    /**
     * The HTTP method that we should use to call `voice_fallback_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs retrieving or executing the TwiML requested by `url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method that we should use to call `voice_url`. Can be: `GET` or `POST` and defaults to `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The configuration parameter for the phone number to receive incoming voice calls or faxes. Can be: `fax` or `voice` and defaults to `voice`.
     */
    VoiceReceiveMode?: incoming_phone_number_enum_voice_receive_mode;
    /**
     * The URL that we should call to answer a call to the phone number. The `voice_url` will not be called if a `voice_application_sid` or a `trunk_sid` is set.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IncomingPhoneNumber resource to update.  For more information, see [Exchanging Numbers Between Subaccounts](https://www.twilio.com/docs/iam/api/subaccounts#exchanging-numbers).
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the IncomingPhoneNumber resource to update.
     */
    Sid: string;
  };
};

export type UpdateIncomingPhoneNumberResponse = api_v2010_account_incoming_phone_number;

export type UpdateIncomingPhoneNumberError = unknown;

export type ListKeyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Key resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListKeyResponse = {
  end?: number;
  first_page_uri?: string;
  keys?: Array<api_v2010_account_key>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListKeyError = unknown;

export type CreateNewKeyData = {
  body?: {
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will be responsible for the new Key resource.
     */
    AccountSid: string;
  };
};

export type CreateNewKeyResponse = api_v2010_account_new_key;

export type CreateNewKeyError = unknown;

export type DeleteKeyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Key resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Key resource to delete.
     */
    Sid: string;
  };
};

export type DeleteKeyResponse = any;

export type DeleteKeyError = unknown;

export type FetchKeyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Key resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Key resource to fetch.
     */
    Sid: string;
  };
};

export type FetchKeyResponse = api_v2010_account_key;

export type FetchKeyError = unknown;

export type UpdateKeyData = {
  body?: {
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Key resources to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Key resource to update.
     */
    Sid: string;
  };
};

export type UpdateKeyResponse = api_v2010_account_key;

export type UpdateKeyError = unknown;

export type ListMessageData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resources.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Filter by Message `sent_date`. Accepts GMT dates in the following formats: `YYYY-MM-DD` (to find Messages with a specific `sent_date`), `<=YYYY-MM-DD` (to find Messages with `sent_date`s on and before a specific date), and `>=YYYY-MM-DD` (to find Messages with `sent_dates` on and after a specific date).
     */
    DateSent?: string;
    /**
     * Filter by Message `sent_date`. Accepts GMT dates in the following formats: `YYYY-MM-DD` (to find Messages with a specific `sent_date`), `<=YYYY-MM-DD` (to find Messages with `sent_date`s on and before a specific date), and `>=YYYY-MM-DD` (to find Messages with `sent_dates` on and after a specific date).
     */
    'DateSent<'?: string;
    /**
     * Filter by Message `sent_date`. Accepts GMT dates in the following formats: `YYYY-MM-DD` (to find Messages with a specific `sent_date`), `<=YYYY-MM-DD` (to find Messages with `sent_date`s on and before a specific date), and `>=YYYY-MM-DD` (to find Messages with `sent_dates` on and after a specific date).
     */
    'DateSent>'?: string;
    /**
     * Filter by sender. For example: Set this `from` parameter to `+15552229999` to retrieve a list of Message resources with `from` properties of `+15552229999`
     */
    From?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Filter by recipient. For example: Set this `to` parameter to `+15558881111` to retrieve a list of Message resources with `to` properties of `+15558881111`
     */
    To?: string;
  };
};

export type ListMessageResponse = {
  end?: number;
  first_page_uri?: string;
  messages?: Array<api_v2010_account_message>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListMessageError = unknown;

export type CreateMessageData = {
  body?: {
    /**
     * Determines if the address can be stored or obfuscated based on privacy settings
     */
    AddressRetention?: message_enum_address_retention;
    /**
     * The SID of the associated [TwiML Application](https://www.twilio.com/docs/usage/api/applications). If this parameter is provided, the `status_callback` parameter of this request is ignored; [Message status callback requests](https://www.twilio.com/docs/sms/api/message-resource#twilios-request-to-the-statuscallback-url) are sent to the TwiML App's `message_status_callback` URL.
     */
    ApplicationSid?: string;
    /**
     * Total number of attempts made (including this request) to send the message regardless of the provider used
     */
    Attempt?: number;
    /**
     * The text content of the outgoing message. Can be up to 1,600 characters in length. SMS only: If the `body` contains more than 160 [GSM-7](https://www.twilio.com/docs/glossary/what-is-gsm-7-character-encoding) characters (or 70 [UCS-2](https://www.twilio.com/docs/glossary/what-is-ucs-2-character-encoding) characters), the message is segmented and charged accordingly. For long `body` text, consider using the [send_as_mms parameter](https://www.twilio.com/blog/mms-for-long-text-messages).
     */
    Body?: string;
    /**
     * Determines if the message content can be stored or redacted based on privacy settings
     */
    ContentRetention?: message_enum_content_retention;
    /**
     * For [Content Editor/API](https://www.twilio.com/docs/content) only: The SID of the Content Template to be used with the Message, e.g., `HXXXXXXXXXXXXXXXXXXXXXXXXXXXXX`. If this parameter is not provided, a Content Template is not used. Find the SID in the Console on the Content Editor page. For Content API users, the SID is found in Twilio's response when [creating the Template](https://www.twilio.com/docs/content/content-api-resources#create-templates) or by [fetching your Templates](https://www.twilio.com/docs/content/content-api-resources#fetch-all-content-resources).
     */
    ContentSid?: string;
    /**
     * For [Content Editor/API](https://www.twilio.com/docs/content) only: Key-value pairs of [Template variables](https://www.twilio.com/docs/content/using-variables-with-content-api) and their substitution values. `content_sid` parameter must also be provided. If values are not defined in the `content_variables` parameter, the [Template's default placeholder values](https://www.twilio.com/docs/content/content-api-resources#create-templates) are used.
     */
    ContentVariables?: string;
    /**
     * Reserved
     */
    ForceDelivery?: boolean;
    /**
     * The sender's Twilio phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format), [alphanumeric sender ID](https://www.twilio.com/docs/sms/quickstart), [Wireless SIM](https://www.twilio.com/docs/iot/wireless/programmable-wireless-send-machine-machine-sms-commands), [short code](https://www.twilio.com/en-us/messaging/channels/sms/short-codes), or [channel address](https://www.twilio.com/docs/messaging/channels) (e.g., `whatsapp:+15554449999`). The value of the `from` parameter must be a sender that is hosted within Twilio and belongs to the Account creating the Message. If you are using `messaging_service_sid`, this parameter can be empty (Twilio assigns a `from` value from the Messaging Service's Sender Pool) or you can provide a specific sender from your Sender Pool.
     */
    From?: string;
    /**
     * The maximum price in US dollars that you are willing to pay for this Message's delivery. The value can have up to four decimal places. When the `max_price` parameter is provided, the cost of a message is checked before it is sent. If the cost exceeds `max_price`, the message is not sent and the Message `status` is `failed`.
     */
    MaxPrice?: number;
    /**
     * The URL of media to include in the Message content. `jpeg`, `jpg`, `gif`, and `png` file types are fully supported by Twilio and content is formatted for delivery on destination devices. The media size limit is 5 MB for supported file types (`jpeg`, `jpg`, `png`, `gif`) and 500 KB for [other types](https://www.twilio.com/docs/messaging/guides/accepted-mime-types) of accepted media. To send more than one image in the message, provide multiple `media_url` parameters in the POST request. You can include up to ten `media_url` parameters per message. [International](https://support.twilio.com/hc/en-us/articles/223179808-Sending-and-receiving-MMS-messages) and [carrier](https://support.twilio.com/hc/en-us/articles/223133707-Is-MMS-supported-for-all-carriers-in-US-and-Canada-) limits apply.
     */
    MediaUrl?: Array<string>;
    /**
     * The SID of the [Messaging Service](https://www.twilio.com/docs/messaging/services) you want to associate with the Message. When this parameter is provided and the `from` parameter is omitted, Twilio selects the optimal sender from the Messaging Service's Sender Pool. You may also provide a `from` parameter if you want to use a specific Sender from the Sender Pool.
     */
    MessagingServiceSid?: string;
    /**
     * Rich actions for non-SMS/MMS channels. Used for [sending location in WhatsApp messages](https://www.twilio.com/docs/whatsapp/message-features#location-messages-with-whatsapp).
     */
    PersistentAction?: Array<string>;
    /**
     * Boolean indicating whether or not you intend to provide delivery confirmation feedback to Twilio (used in conjunction with the [Message Feedback subresource](https://www.twilio.com/docs/sms/api/message-feedback-resource)). Default value is `false`.
     */
    ProvideFeedback?: boolean;
    /**
     * For SMS pumping protection feature only: Include this parameter with a value of `disable` to skip any kind of risk check on the respective message request.
     */
    RiskCheck?: message_enum_risk_check;
    /**
     * For Messaging Services only: Include this parameter with a value of `fixed` in conjuction with the `send_time` parameter in order to [schedule a Message](https://www.twilio.com/docs/messaging/features/message-scheduling).
     */
    ScheduleType?: message_enum_schedule_type;
    /**
     * If set to `true`, Twilio delivers the message as a single MMS message, regardless of the presence of media.
     */
    SendAsMms?: boolean;
    /**
     * The time that Twilio will send the message. Must be in ISO 8601 format.
     */
    SendAt?: string;
    /**
     * For Messaging Services with [Link Shortening configured](https://www.twilio.com/docs/messaging/features/link-shortening) only: A Boolean indicating whether or not Twilio should shorten links in the `body` of the Message. Default value is `false`. If `true`, the `messaging_service_sid` parameter must also be provided.
     */
    ShortenUrls?: boolean;
    /**
     * Whether to detect Unicode characters that have a similar GSM-7 character and replace them. Can be: `true` or `false`.
     */
    SmartEncoded?: boolean;
    /**
     * The URL of the endpoint to which Twilio sends [Message status callback requests](https://www.twilio.com/docs/sms/api/message-resource#twilios-request-to-the-statuscallback-url). URL must contain a valid hostname and underscores are not allowed. If you include this parameter with the `messaging_service_sid`, Twilio uses this URL instead of the Status Callback URL of the [Messaging Service](https://www.twilio.com/docs/messaging/api/service-resource).
     */
    StatusCallback?: string;
    /**
     * The recipient's phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (for SMS/MMS) or [channel address](https://www.twilio.com/docs/messaging/channels), e.g. `whatsapp:+15552229999`.
     */
    To: string;
    /**
     * The maximum length in seconds that the Message can remain in Twilio's outgoing message queue. If a queued Message exceeds the `validity_period`, the Message is not sent. Accepted values are integers from `1` to `14400`. Default value is `14400`. A `validity_period` greater than `5` is recommended. [Learn more about the validity period](https://www.twilio.com/blog/take-more-control-of-outbound-messages-using-validity-period-html)
     */
    ValidityPeriod?: number;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) creating the Message resource.
     */
    AccountSid: string;
  };
};

export type CreateMessageResponse = api_v2010_account_message;

export type CreateMessageError = unknown;

export type CreateMessageFeedbackData = {
  body?: {
    /**
     * The outcome to report. Use `confirmed` to indicate that the Message recipient performed the tracked user action. Set `ProvideFeedback`=`true` when [creating a new Message](https://www.twilio.com/docs/sms/api/message-resource#create-a-message-resource) to track Message Feedback. Do not pass `unconfirmed` as the value of the `Outcome` parameter, since it is already the initial value for the MessageFeedback of a newly created Message.
     */
    Outcome?: message_feedback_enum_outcome;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resource for which to create MessageFeedback.
     */
    AccountSid: string;
    /**
     * The SID of the Message resource for which to create MessageFeedback.
     */
    MessageSid: string;
  };
};

export type CreateMessageFeedbackResponse = api_v2010_account_message_message_feedback;

export type CreateMessageFeedbackError = unknown;

export type ListMediaData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is associated with the Media resources.
     */
    AccountSid: string;
    /**
     * The SID of the Message resource that is associated with the Media resources.
     */
    MessageSid: string;
  };
  query?: {
    /**
     * Only include Media resources that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read Media that were created on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read Media that were created on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read Media that were created on or after midnight of this date.
     */
    DateCreated?: string;
    /**
     * Only include Media resources that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read Media that were created on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read Media that were created on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read Media that were created on or after midnight of this date.
     */
    'DateCreated<'?: string;
    /**
     * Only include Media resources that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read Media that were created on this date. You can also specify an inequality, such as `StartTime<=YYYY-MM-DD`, to read Media that were created on or before midnight of this date, and `StartTime>=YYYY-MM-DD` to read Media that were created on or after midnight of this date.
     */
    'DateCreated>'?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListMediaResponse = {
  end?: number;
  first_page_uri?: string;
  media_list?: Array<api_v2010_account_message_media>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListMediaError = unknown;

export type DeleteMediaData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is associated with the Media resource.
     */
    AccountSid: string;
    /**
     * The SID of the Message resource that is associated with the Media resource.
     */
    MessageSid: string;
    /**
     * The unique identifier of the to-be-deleted Media resource.
     */
    Sid: string;
  };
};

export type DeleteMediaResponse = any;

export type DeleteMediaError = unknown;

export type FetchMediaData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Media resource.
     */
    AccountSid: string;
    /**
     * The SID of the Message resource that is associated with the Media resource.
     */
    MessageSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Media resource to fetch.
     */
    Sid: string;
  };
};

export type FetchMediaResponse = api_v2010_account_message_media;

export type FetchMediaError = unknown;

export type DeleteMessageData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resource
     */
    AccountSid: string;
    /**
     * The SID of the Message resource you wish to delete
     */
    Sid: string;
  };
};

export type DeleteMessageResponse = any;

export type DeleteMessageError = unknown;

export type FetchMessageData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resource
     */
    AccountSid: string;
    /**
     * The SID of the Message resource to be fetched
     */
    Sid: string;
  };
};

export type FetchMessageResponse = api_v2010_account_message;

export type FetchMessageError = unknown;

export type UpdateMessageData = {
  body?: {
    /**
     * The new `body` of the Message resource. To redact the text content of a Message, this parameter's value must be an empty string
     */
    Body?: string;
    /**
     * Set as `canceled` to prevent a not-yet-sent Message from being sent. Can be used to cancel sending a [scheduled Message](https://www.twilio.com/docs/messaging/features/message-scheduling) (Messaging Services only).
     */
    Status?: message_enum_update_status;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Message resources to update.
     */
    AccountSid: string;
    /**
     * The SID of the Message resource to be updated
     */
    Sid: string;
  };
};

export type UpdateMessageResponse = api_v2010_account_message;

export type UpdateMessageError = unknown;

export type ListNotificationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * Only read notifications of the specified log level. Can be:  `0` to read only ERROR notifications or `1` to read only WARNING notifications. By default, all notifications are read.
     */
    Log?: number;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    MessageDate?: string;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    'MessageDate<'?: string;
    /**
     * Only show notifications for the specified date, formatted as `YYYY-MM-DD`. You can also specify an inequality, such as `<=YYYY-MM-DD` for messages logged at or before midnight on a date, or `>=YYYY-MM-DD` for messages logged at or after midnight on a date.
     */
    'MessageDate>'?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListNotificationResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  notifications?: Array<api_v2010_account_notification>;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListNotificationError = unknown;

export type FetchNotificationData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Notification resource to fetch.
     */
    Sid: string;
  };
};

export type FetchNotificationResponse = api_v2010_account_notification_instance;

export type FetchNotificationError = unknown;

export type ListOutgoingCallerIdData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The string that identifies the OutgoingCallerId resources to read.
     */
    FriendlyName?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The phone number of the OutgoingCallerId resources to read.
     */
    PhoneNumber?: string;
  };
};

export type ListOutgoingCallerIdResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  outgoing_caller_ids?: Array<api_v2010_account_outgoing_caller_id>;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListOutgoingCallerIdError = unknown;

export type CreateValidationRequestData = {
  body?: {
    /**
     * The number of seconds to delay before initiating the verification call. Can be an integer between `0` and `60`, inclusive. The default is `0`.
     */
    CallDelay?: number;
    /**
     * The digits to dial after connecting the verification call.
     */
    Extension?: string;
    /**
     * A descriptive string that you create to describe the new caller ID resource. It can be up to 64 characters long. The default value is a formatted version of the phone number.
     */
    FriendlyName?: string;
    /**
     * The phone number to verify in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.
     */
    PhoneNumber: string;
    /**
     * The URL we should call using the `status_callback_method` to send status information about the verification process to your application.
     */
    StatusCallback?: string;
    /**
     * The HTTP method we should use to call `status_callback`. Can be: `GET` or `POST`, and the default is `POST`.
     */
    StatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for the new caller ID resource.
     */
    AccountSid: string;
  };
};

export type CreateValidationRequestResponse = api_v2010_account_validation_request;

export type CreateValidationRequestError = unknown;

export type DeleteOutgoingCallerIdData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the OutgoingCallerId resource to delete.
     */
    Sid: string;
  };
};

export type DeleteOutgoingCallerIdResponse = any;

export type DeleteOutgoingCallerIdError = unknown;

export type FetchOutgoingCallerIdData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the OutgoingCallerId resource to fetch.
     */
    Sid: string;
  };
};

export type FetchOutgoingCallerIdResponse = api_v2010_account_outgoing_caller_id;

export type FetchOutgoingCallerIdError = unknown;

export type UpdateOutgoingCallerIdData = {
  body?: {
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resources to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the OutgoingCallerId resource to update.
     */
    Sid: string;
  };
};

export type UpdateOutgoingCallerIdResponse = api_v2010_account_outgoing_caller_id;

export type UpdateOutgoingCallerIdError = unknown;

export type ListQueueData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Queue resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListQueueResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  queues?: Array<api_v2010_account_queue>;
  start?: number;
  uri?: string;
};

export type ListQueueError = unknown;

export type CreateQueueData = {
  body?: {
    /**
     * A descriptive string that you created to describe this resource. It can be up to 64 characters long.
     */
    FriendlyName: string;
    /**
     * The maximum number of calls allowed to be in the queue. The default is 1000. The maximum is 5000.
     */
    MaxSize?: number;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateQueueResponse = api_v2010_account_queue;

export type CreateQueueError = unknown;

export type ListMemberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Member resource(s) to read.
     */
    AccountSid: string;
    /**
     * The SID of the Queue in which to find the members
     */
    QueueSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListMemberResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  queue_members?: Array<api_v2010_account_queue_member>;
  start?: number;
  uri?: string;
};

export type ListMemberError = unknown;

export type FetchMemberData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Member resource(s) to fetch.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resource(s) to fetch.
     */
    CallSid: string;
    /**
     * The SID of the Queue in which to find the members to fetch.
     */
    QueueSid: string;
  };
};

export type FetchMemberResponse = api_v2010_account_queue_member;

export type FetchMemberError = unknown;

export type UpdateMemberData = {
  body?: {
    /**
     * How to pass the update request data. Can be `GET` or `POST` and the default is `POST`. `POST` sends the data as encoded form data and `GET` sends the data as query parameters.
     */
    Method?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The absolute URL of the Queue resource.
     */
    Url: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Member resource(s) to update.
     */
    AccountSid: string;
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resource(s) to update.
     */
    CallSid: string;
    /**
     * The SID of the Queue in which to find the members to update.
     */
    QueueSid: string;
  };
};

export type UpdateMemberResponse = api_v2010_account_queue_member;

export type UpdateMemberError = unknown;

export type DeleteQueueData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Queue resource to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Queue resource to delete
     */
    Sid: string;
  };
};

export type DeleteQueueResponse = any;

export type DeleteQueueError = unknown;

export type FetchQueueData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Queue resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Queue resource to fetch
     */
    Sid: string;
  };
};

export type FetchQueueResponse = api_v2010_account_queue;

export type FetchQueueError = unknown;

export type UpdateQueueData = {
  body?: {
    /**
     * A descriptive string that you created to describe this resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The maximum number of calls allowed to be in the queue. The default is 1000. The maximum is 5000.
     */
    MaxSize?: number;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Queue resource to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Queue resource to update
     */
    Sid: string;
  };
};

export type UpdateQueueResponse = api_v2010_account_queue;

export type UpdateQueueError = unknown;

export type ListRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [Call](https://www.twilio.com/docs/voice/api/call-resource) SID of the resources to read.
     */
    CallSid?: string;
    /**
     * The Conference SID that identifies the conference associated with the recording to read.
     */
    ConferenceSid?: string;
    /**
     * Only include recordings that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read recordings that were created on this date. You can also specify an inequality, such as `DateCreated<=YYYY-MM-DD`, to read recordings that were created on or before midnight of this date, and `DateCreated>=YYYY-MM-DD` to read recordings that were created on or after midnight of this date.
     */
    DateCreated?: string;
    /**
     * Only include recordings that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read recordings that were created on this date. You can also specify an inequality, such as `DateCreated<=YYYY-MM-DD`, to read recordings that were created on or before midnight of this date, and `DateCreated>=YYYY-MM-DD` to read recordings that were created on or after midnight of this date.
     */
    'DateCreated<'?: string;
    /**
     * Only include recordings that were created on this date. Specify a date as `YYYY-MM-DD` in GMT, for example: `2009-07-06`, to read recordings that were created on this date. You can also specify an inequality, such as `DateCreated<=YYYY-MM-DD`, to read recordings that were created on or before midnight of this date, and `DateCreated>=YYYY-MM-DD` to read recordings that were created on or after midnight of this date.
     */
    'DateCreated>'?: string;
    /**
     * A boolean parameter indicating whether to retrieve soft deleted recordings or not. Recordings metadata are kept after deletion for a retention period of 40 days.
     */
    IncludeSoftDeleted?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListRecordingResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  recordings?: Array<api_v2010_account_recording>;
  start?: number;
  uri?: string;
};

export type ListRecordingError = unknown;

export type ListRecordingTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) that created the transcriptions to read.
     */
    RecordingSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListRecordingTranscriptionResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  transcriptions?: Array<api_v2010_account_recording_recording_transcription>;
  uri?: string;
};

export type ListRecordingTranscriptionError = unknown;

export type DeleteRecordingTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) that created the transcription to delete.
     */
    RecordingSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Transcription resource to delete.
     */
    Sid: string;
  };
};

export type DeleteRecordingTranscriptionResponse = any;

export type DeleteRecordingTranscriptionError = unknown;

export type FetchRecordingTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) that created the transcription to fetch.
     */
    RecordingSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Transcription resource to fetch.
     */
    Sid: string;
  };
};

export type FetchRecordingTranscriptionResponse = api_v2010_account_recording_recording_transcription;

export type FetchRecordingTranscriptionError = unknown;

export type ListRecordingAddOnResultData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the recording to which the result to read belongs.
     */
    ReferenceSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListRecordingAddOnResultResponse = {
  add_on_results?: Array<api_v2010_account_recording_recording_add_on_result>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListRecordingAddOnResultError = unknown;

export type ListRecordingAddOnResultPayloadData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult Payload resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the AddOnResult to which the payloads to read belongs.
     */
    AddOnResultSid: string;
    /**
     * The SID of the recording to which the AddOnResult resource that contains the payloads to read belongs.
     */
    ReferenceSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListRecordingAddOnResultPayloadResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  payloads?: Array<api_v2010_account_recording_recording_add_on_result_recording_add_on_result_payload>;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListRecordingAddOnResultPayloadError = unknown;

export type DeleteRecordingAddOnResultPayloadData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult Payload resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the AddOnResult to which the payloads to delete belongs.
     */
    AddOnResultSid: string;
    /**
     * The SID of the recording to which the AddOnResult resource that contains the payloads to delete belongs.
     */
    ReferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording AddOnResult Payload resource to delete.
     */
    Sid: string;
  };
};

export type DeleteRecordingAddOnResultPayloadResponse = any;

export type DeleteRecordingAddOnResultPayloadError = unknown;

export type FetchRecordingAddOnResultPayloadData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult Payload resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the AddOnResult to which the payload to fetch belongs.
     */
    AddOnResultSid: string;
    /**
     * The SID of the recording to which the AddOnResult resource that contains the payload to fetch belongs.
     */
    ReferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording AddOnResult Payload resource to fetch.
     */
    Sid: string;
  };
};

export type FetchRecordingAddOnResultPayloadResponse =
  api_v2010_account_recording_recording_add_on_result_recording_add_on_result_payload;

export type FetchRecordingAddOnResultPayloadError = unknown;

export type DeleteRecordingAddOnResultData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the recording to which the result to delete belongs.
     */
    ReferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording AddOnResult resource to delete.
     */
    Sid: string;
  };
};

export type DeleteRecordingAddOnResultResponse = any;

export type DeleteRecordingAddOnResultError = unknown;

export type FetchRecordingAddOnResultData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the recording to which the result to fetch belongs.
     */
    ReferenceSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording AddOnResult resource to fetch.
     */
    Sid: string;
  };
};

export type FetchRecordingAddOnResultResponse = api_v2010_account_recording_recording_add_on_result;

export type FetchRecordingAddOnResultError = unknown;

export type DeleteRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording resource to delete.
     */
    Sid: string;
  };
};

export type DeleteRecordingResponse = any;

export type DeleteRecordingError = unknown;

export type FetchRecordingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Recording resource to fetch.
     */
    Sid: string;
  };
  query?: {
    /**
     * A boolean parameter indicating whether to retrieve soft deleted recordings or not. Recordings metadata are kept after deletion for a retention period of 40 days.
     */
    IncludeSoftDeleted?: boolean;
  };
};

export type FetchRecordingResponse = api_v2010_account_recording;

export type FetchRecordingError = unknown;

export type ListSipCredentialListData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipCredentialListResponse = {
  credential_lists?: Array<api_v2010_account_sip_sip_credential_list>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipCredentialListError = unknown;

export type CreateSipCredentialListData = {
  body?: {
    /**
     * A human readable descriptive text that describes the CredentialList, up to 64 characters long.
     */
    FriendlyName: string;
  };
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
  };
};

export type CreateSipCredentialListResponse = api_v2010_account_sip_sip_credential_list;

export type CreateSipCredentialListError = unknown;

export type ListSipCredentialData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The unique id that identifies the credential list that contains the desired credentials.
     */
    CredentialListSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipCredentialResponse = {
  credentials?: Array<api_v2010_account_sip_sip_credential_list_sip_credential>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipCredentialError = unknown;

export type CreateSipCredentialData = {
  body?: {
    /**
     * The password that the username will use when authenticating SIP requests. The password must be a minimum of 12 characters, contain at least 1 digit, and have mixed case. (eg `IWasAtSignal2018`)
     */
    Password: string;
    /**
     * The username that will be passed when authenticating SIP requests. The username should be sent in response to Twilio's challenge of the initial INVITE. It can be up to 32 characters long.
     */
    Username: string;
  };
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The unique id that identifies the credential list to include the created credential.
     */
    CredentialListSid: string;
  };
};

export type CreateSipCredentialResponse = api_v2010_account_sip_sip_credential_list_sip_credential;

export type CreateSipCredentialError = unknown;

export type DeleteSipCredentialData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The unique id that identifies the credential list that contains the desired credentials.
     */
    CredentialListSid: string;
    /**
     * The unique id that identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipCredentialResponse = any;

export type DeleteSipCredentialError = unknown;

export type FetchSipCredentialData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The unique id that identifies the credential list that contains the desired credential.
     */
    CredentialListSid: string;
    /**
     * The unique id that identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipCredentialResponse = api_v2010_account_sip_sip_credential_list_sip_credential;

export type FetchSipCredentialError = unknown;

export type UpdateSipCredentialData = {
  body?: {
    /**
     * The password that the username will use when authenticating SIP requests. The password must be a minimum of 12 characters, contain at least 1 digit, and have mixed case. (eg `IWasAtSignal2018`)
     */
    Password?: string;
  };
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The unique id that identifies the credential list that includes this credential.
     */
    CredentialListSid: string;
    /**
     * The unique id that identifies the resource to update.
     */
    Sid: string;
  };
};

export type UpdateSipCredentialResponse = api_v2010_account_sip_sip_credential_list_sip_credential;

export type UpdateSipCredentialError = unknown;

export type DeleteSipCredentialListData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The credential list Sid that uniquely identifies this resource
     */
    Sid: string;
  };
};

export type DeleteSipCredentialListResponse = any;

export type DeleteSipCredentialListError = unknown;

export type FetchSipCredentialListData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The credential list Sid that uniquely identifies this resource
     */
    Sid: string;
  };
};

export type FetchSipCredentialListResponse = api_v2010_account_sip_sip_credential_list;

export type FetchSipCredentialListError = unknown;

export type UpdateSipCredentialListData = {
  body?: {
    /**
     * A human readable descriptive text for a CredentialList, up to 64 characters long.
     */
    FriendlyName: string;
  };
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * The credential list Sid that uniquely identifies this resource
     */
    Sid: string;
  };
};

export type UpdateSipCredentialListResponse = api_v2010_account_sip_sip_credential_list;

export type UpdateSipCredentialListError = unknown;

export type ListSipDomainData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipDomainResponse = {
  domains?: Array<api_v2010_account_sip_sip_domain>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipDomainError = unknown;

export type CreateSipDomainData = {
  body?: {
    /**
     * The SID of the BYOC Trunk(Bring Your Own Carrier) resource that the Sip Domain will be associated with.
     */
    ByocTrunkSid?: string;
    /**
     * The unique address you reserve on Twilio to which you route your SIP traffic. Domain names can contain letters, digits, and "-" and must end with `sip.twilio.com`.
     */
    DomainName: string;
    /**
     * Whether an emergency caller sid is configured for the domain. If present, this phone number will be used as the callback for the emergency call.
     */
    EmergencyCallerSid?: string;
    /**
     * Whether emergency calling is enabled for the domain. If enabled, allows emergency calls on the domain from phone numbers with validated addresses.
     */
    EmergencyCallingEnabled?: boolean;
    /**
     * A descriptive string that you created to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * Whether secure SIP is enabled for the domain. If enabled, TLS will be enforced and SRTP will be negotiated on all incoming calls to this sip domain.
     */
    Secure?: boolean;
    /**
     * Whether to allow SIP Endpoints to register with the domain to receive calls. Can be `true` or `false`. `true` allows SIP Endpoints to register with the domain to receive calls, `false` does not.
     */
    SipRegistration?: boolean;
    /**
     * The HTTP method we should use to call `voice_fallback_url`. Can be: `GET` or `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while retrieving or executing the TwiML from `voice_url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `voice_url`. Can be: `GET` or `POST`.
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The HTTP method we should use to call `voice_status_callback_url`. Can be: `GET` or `POST`.
     */
    VoiceStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call to pass status parameters (such as call ended) to your application.
     */
    VoiceStatusCallbackUrl?: string;
    /**
     * The URL we should when the domain receives a call.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateSipDomainResponse = api_v2010_account_sip_sip_domain;

export type CreateSipDomainError = unknown;

export type ListSipAuthCallsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resources to read.
     */
    DomainSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipAuthCallsCredentialListMappingResponse = {
  contents?: Array<api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_credential_list_mapping>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipAuthCallsCredentialListMappingError = unknown;

export type CreateSipAuthCallsCredentialListMappingData = {
  body?: {
    /**
     * The SID of the CredentialList resource to map to the SIP domain.
     */
    CredentialListSid: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that will contain the new resource.
     */
    DomainSid: string;
  };
};

export type CreateSipAuthCallsCredentialListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_credential_list_mapping;

export type CreateSipAuthCallsCredentialListMappingError = unknown;

export type DeleteSipAuthCallsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resource to delete.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the CredentialListMapping resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipAuthCallsCredentialListMappingResponse = any;

export type DeleteSipAuthCallsCredentialListMappingError = unknown;

export type FetchSipAuthCallsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resource to fetch.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the CredentialListMapping resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipAuthCallsCredentialListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_credential_list_mapping;

export type FetchSipAuthCallsCredentialListMappingError = unknown;

export type ListSipAuthCallsIpAccessControlListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IpAccessControlListMapping resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resources to read.
     */
    DomainSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipAuthCallsIpAccessControlListMappingResponse = {
  contents?: Array<api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_ip_access_control_list_mapping>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipAuthCallsIpAccessControlListMappingError = unknown;

export type CreateSipAuthCallsIpAccessControlListMappingData = {
  body?: {
    /**
     * The SID of the IpAccessControlList resource to map to the SIP domain.
     */
    IpAccessControlListSid: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that will contain the new resource.
     */
    DomainSid: string;
  };
};

export type CreateSipAuthCallsIpAccessControlListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_ip_access_control_list_mapping;

export type CreateSipAuthCallsIpAccessControlListMappingError = unknown;

export type DeleteSipAuthCallsIpAccessControlListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IpAccessControlListMapping resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resources to delete.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the IpAccessControlListMapping resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipAuthCallsIpAccessControlListMappingResponse = any;

export type DeleteSipAuthCallsIpAccessControlListMappingError = unknown;

export type FetchSipAuthCallsIpAccessControlListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IpAccessControlListMapping resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resource to fetch.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the IpAccessControlListMapping resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipAuthCallsIpAccessControlListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_ip_access_control_list_mapping;

export type FetchSipAuthCallsIpAccessControlListMappingError = unknown;

export type ListSipAuthRegistrationsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resources to read.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resources to read.
     */
    DomainSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipAuthRegistrationsCredentialListMappingResponse = {
  contents?: Array<api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations_sip_auth_registrations_credential_list_mapping>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipAuthRegistrationsCredentialListMappingError = unknown;

export type CreateSipAuthRegistrationsCredentialListMappingData = {
  body?: {
    /**
     * The SID of the CredentialList resource to map to the SIP domain.
     */
    CredentialListSid: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that will contain the new resource.
     */
    DomainSid: string;
  };
};

export type CreateSipAuthRegistrationsCredentialListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations_sip_auth_registrations_credential_list_mapping;

export type CreateSipAuthRegistrationsCredentialListMappingError = unknown;

export type DeleteSipAuthRegistrationsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resources to delete.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resources to delete.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the CredentialListMapping resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipAuthRegistrationsCredentialListMappingResponse = any;

export type DeleteSipAuthRegistrationsCredentialListMappingError = unknown;

export type FetchSipAuthRegistrationsCredentialListMappingData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource to fetch.
     */
    AccountSid: string;
    /**
     * The SID of the SIP domain that contains the resource to fetch.
     */
    DomainSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the CredentialListMapping resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipAuthRegistrationsCredentialListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations_sip_auth_registrations_credential_list_mapping;

export type FetchSipAuthRegistrationsCredentialListMappingError = unknown;

export type ListSipCredentialListMappingData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP Domain that includes the resource to read.
     */
    DomainSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipCredentialListMappingResponse = {
  credential_list_mappings?: Array<api_v2010_account_sip_sip_domain_sip_credential_list_mapping>;
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipCredentialListMappingError = unknown;

export type CreateSipCredentialListMappingData = {
  body?: {
    /**
     * A 34 character string that uniquely identifies the CredentialList resource to map to the SIP domain.
     */
    CredentialListSid: string;
  };
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP Domain for which the CredentialList resource will be mapped.
     */
    DomainSid: string;
  };
};

export type CreateSipCredentialListMappingResponse = api_v2010_account_sip_sip_domain_sip_credential_list_mapping;

export type CreateSipCredentialListMappingError = unknown;

export type DeleteSipCredentialListMappingData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP Domain that includes the resource to delete.
     */
    DomainSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipCredentialListMappingResponse = any;

export type DeleteSipCredentialListMappingError = unknown;

export type FetchSipCredentialListMappingData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP Domain that includes the resource to fetch.
     */
    DomainSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipCredentialListMappingResponse = api_v2010_account_sip_sip_domain_sip_credential_list_mapping;

export type FetchSipCredentialListMappingError = unknown;

export type ListSipIpAccessControlListMappingData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP domain.
     */
    DomainSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipIpAccessControlListMappingResponse = {
  end?: number;
  first_page_uri?: string;
  ip_access_control_list_mappings?: Array<api_v2010_account_sip_sip_domain_sip_ip_access_control_list_mapping>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipIpAccessControlListMappingError = unknown;

export type CreateSipIpAccessControlListMappingData = {
  body?: {
    /**
     * The unique id of the IP access control list to map to the SIP domain.
     */
    IpAccessControlListSid: string;
  };
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP domain.
     */
    DomainSid: string;
  };
};

export type CreateSipIpAccessControlListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_ip_access_control_list_mapping;

export type CreateSipIpAccessControlListMappingError = unknown;

export type DeleteSipIpAccessControlListMappingData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP domain.
     */
    DomainSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipIpAccessControlListMappingResponse = any;

export type DeleteSipIpAccessControlListMappingError = unknown;

export type FetchSipIpAccessControlListMappingData = {
  path: {
    /**
     * The unique id of the Account that is responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the SIP domain.
     */
    DomainSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipIpAccessControlListMappingResponse =
  api_v2010_account_sip_sip_domain_sip_ip_access_control_list_mapping;

export type FetchSipIpAccessControlListMappingError = unknown;

export type DeleteSipDomainData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the SipDomain resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipDomainResponse = any;

export type DeleteSipDomainError = unknown;

export type FetchSipDomainData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the SipDomain resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipDomainResponse = api_v2010_account_sip_sip_domain;

export type FetchSipDomainError = unknown;

export type UpdateSipDomainData = {
  body?: {
    /**
     * The SID of the BYOC Trunk(Bring Your Own Carrier) resource that the Sip Domain will be associated with.
     */
    ByocTrunkSid?: string;
    /**
     * The unique address you reserve on Twilio to which you route your SIP traffic. Domain names can contain letters, digits, and "-" and must end with `sip.twilio.com`.
     */
    DomainName?: string;
    /**
     * Whether an emergency caller sid is configured for the domain. If present, this phone number will be used as the callback for the emergency call.
     */
    EmergencyCallerSid?: string;
    /**
     * Whether emergency calling is enabled for the domain. If enabled, allows emergency calls on the domain from phone numbers with validated addresses.
     */
    EmergencyCallingEnabled?: boolean;
    /**
     * A descriptive string that you created to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * Whether secure SIP is enabled for the domain. If enabled, TLS will be enforced and SRTP will be negotiated on all incoming calls to this sip domain.
     */
    Secure?: boolean;
    /**
     * Whether to allow SIP Endpoints to register with the domain to receive calls. Can be `true` or `false`. `true` allows SIP Endpoints to register with the domain to receive calls, `false` does not.
     */
    SipRegistration?: boolean;
    /**
     * The HTTP method we should use to call `voice_fallback_url`. Can be: `GET` or `POST`.
     */
    VoiceFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call when an error occurs while retrieving or executing the TwiML requested by `voice_url`.
     */
    VoiceFallbackUrl?: string;
    /**
     * The HTTP method we should use to call `voice_url`
     */
    VoiceMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The HTTP method we should use to call `voice_status_callback_url`. Can be: `GET` or `POST`.
     */
    VoiceStatusCallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call to pass status parameters (such as call ended) to your application.
     */
    VoiceStatusCallbackUrl?: string;
    /**
     * The URL we should call when the domain receives a call.
     */
    VoiceUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resource to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the SipDomain resource to update.
     */
    Sid: string;
  };
};

export type UpdateSipDomainResponse = api_v2010_account_sip_sip_domain;

export type UpdateSipDomainError = unknown;

export type ListSipIpAccessControlListData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipIpAccessControlListResponse = {
  end?: number;
  first_page_uri?: string;
  ip_access_control_lists?: Array<api_v2010_account_sip_sip_ip_access_control_list>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipIpAccessControlListError = unknown;

export type CreateSipIpAccessControlListData = {
  body?: {
    /**
     * A human readable descriptive text that describes the IpAccessControlList, up to 255 characters long.
     */
    FriendlyName: string;
  };
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
  };
};

export type CreateSipIpAccessControlListResponse = api_v2010_account_sip_sip_ip_access_control_list;

export type CreateSipIpAccessControlListError = unknown;

export type ListSipIpAddressData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * The IpAccessControlList Sid that identifies the IpAddress resources to read.
     */
    IpAccessControlListSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSipIpAddressResponse = {
  end?: number;
  first_page_uri?: string;
  ip_addresses?: Array<api_v2010_account_sip_sip_ip_access_control_list_sip_ip_address>;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
};

export type ListSipIpAddressError = unknown;

export type CreateSipIpAddressData = {
  body?: {
    /**
     * An integer representing the length of the CIDR prefix to use with this IP address when accepting traffic. By default the entire IP address is used.
     */
    CidrPrefixLength?: number;
    /**
     * A human readable descriptive text for this resource, up to 255 characters long.
     */
    FriendlyName: string;
    /**
     * An IP address in dotted decimal notation from which you want to accept traffic. Any SIP requests from this IP address will be allowed by Twilio. IPv4 only supported today.
     */
    IpAddress: string;
  };
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * The IpAccessControlList Sid with which to associate the created IpAddress resource.
     */
    IpAccessControlListSid: string;
  };
};

export type CreateSipIpAddressResponse = api_v2010_account_sip_sip_ip_access_control_list_sip_ip_address;

export type CreateSipIpAddressError = unknown;

export type DeleteSipIpAddressData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * The IpAccessControlList Sid that identifies the IpAddress resources to delete.
     */
    IpAccessControlListSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipIpAddressResponse = any;

export type DeleteSipIpAddressError = unknown;

export type FetchSipIpAddressData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * The IpAccessControlList Sid that identifies the IpAddress resources to fetch.
     */
    IpAccessControlListSid: string;
    /**
     * A 34 character string that uniquely identifies the IpAddress resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipIpAddressResponse = api_v2010_account_sip_sip_ip_access_control_list_sip_ip_address;

export type FetchSipIpAddressError = unknown;

export type UpdateSipIpAddressData = {
  body?: {
    /**
     * An integer representing the length of the CIDR prefix to use with this IP address when accepting traffic. By default the entire IP address is used.
     */
    CidrPrefixLength?: number;
    /**
     * A human readable descriptive text for this resource, up to 255 characters long.
     */
    FriendlyName?: string;
    /**
     * An IP address in dotted decimal notation from which you want to accept traffic. Any SIP requests from this IP address will be allowed by Twilio. IPv4 only supported today.
     */
    IpAddress?: string;
  };
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * The IpAccessControlList Sid that identifies the IpAddress resources to update.
     */
    IpAccessControlListSid: string;
    /**
     * A 34 character string that identifies the IpAddress resource to update.
     */
    Sid: string;
  };
};

export type UpdateSipIpAddressResponse = api_v2010_account_sip_sip_ip_access_control_list_sip_ip_address;

export type UpdateSipIpAddressError = unknown;

export type DeleteSipIpAccessControlListData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to delete.
     */
    Sid: string;
  };
};

export type DeleteSipIpAccessControlListResponse = any;

export type DeleteSipIpAccessControlListError = unknown;

export type FetchSipIpAccessControlListData = {
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to fetch.
     */
    Sid: string;
  };
};

export type FetchSipIpAccessControlListResponse = api_v2010_account_sip_sip_ip_access_control_list;

export type FetchSipIpAccessControlListError = unknown;

export type UpdateSipIpAccessControlListData = {
  body?: {
    /**
     * A human readable descriptive text, up to 255 characters long.
     */
    FriendlyName: string;
  };
  path: {
    /**
     * The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
     */
    AccountSid: string;
    /**
     * A 34 character string that uniquely identifies the resource to udpate.
     */
    Sid: string;
  };
};

export type UpdateSipIpAccessControlListResponse = api_v2010_account_sip_sip_ip_access_control_list;

export type UpdateSipIpAccessControlListError = unknown;

export type ListShortCodeData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ShortCode resource(s) to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The string that identifies the ShortCode resources to read.
     */
    FriendlyName?: string;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only show the ShortCode resources that match this pattern. You can specify partial numbers and use '*' as a wildcard for any digit.
     */
    ShortCode?: string;
  };
};

export type ListShortCodeResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  short_codes?: Array<api_v2010_account_short_code>;
  start?: number;
  uri?: string;
};

export type ListShortCodeError = unknown;

export type FetchShortCodeData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ShortCode resource(s) to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the ShortCode resource to fetch
     */
    Sid: string;
  };
};

export type FetchShortCodeResponse = api_v2010_account_short_code;

export type FetchShortCodeError = unknown;

export type UpdateShortCodeData = {
  body?: {
    /**
     * The API version to use to start a new TwiML session. Can be: `2010-04-01` or `2008-08-01`.
     */
    ApiVersion?: string;
    /**
     * A descriptive string that you created to describe this resource. It can be up to 64 characters long. By default, the `FriendlyName` is the short code.
     */
    FriendlyName?: string;
    /**
     * The HTTP method that we should use to call the `sms_fallback_url`. Can be: `GET` or `POST`.
     */
    SmsFallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL that we should call if an error occurs while retrieving or executing the TwiML from `sms_url`.
     */
    SmsFallbackUrl?: string;
    /**
     * The HTTP method we should use when calling the `sms_url`. Can be: `GET` or `POST`.
     */
    SmsMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call when receiving an incoming SMS message to this short code.
     */
    SmsUrl?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ShortCode resource(s) to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the ShortCode resource to update
     */
    Sid: string;
  };
};

export type UpdateShortCodeResponse = api_v2010_account_short_code;

export type UpdateShortCodeError = unknown;

export type ListSigningKeyData = {
  path: {
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListSigningKeyResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  signing_keys?: Array<api_v2010_account_signing_key>;
  start?: number;
  uri?: string;
};

export type ListSigningKeyError = unknown;

export type CreateNewSigningKeyData = {
  body?: {
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will be responsible for the new Key resource.
     */
    AccountSid: string;
  };
};

export type CreateNewSigningKeyResponse = api_v2010_account_new_signing_key;

export type CreateNewSigningKeyError = unknown;

export type DeleteSigningKeyData = {
  path: {
    AccountSid: string;
    Sid: string;
  };
};

export type DeleteSigningKeyResponse = any;

export type DeleteSigningKeyError = unknown;

export type FetchSigningKeyData = {
  path: {
    AccountSid: string;
    Sid: string;
  };
};

export type FetchSigningKeyResponse = api_v2010_account_signing_key;

export type FetchSigningKeyError = unknown;

export type UpdateSigningKeyData = {
  body?: {
    FriendlyName?: string;
  };
  path: {
    AccountSid: string;
    Sid: string;
  };
};

export type UpdateSigningKeyResponse = api_v2010_account_signing_key;

export type UpdateSigningKeyError = unknown;

export type CreateTokenData = {
  body?: {
    /**
     * The duration in seconds for which the generated credentials are valid. The default value is 86400 (24 hours).
     */
    Ttl?: number;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateTokenResponse = api_v2010_account_token;

export type CreateTokenError = unknown;

export type ListTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
  };
};

export type ListTranscriptionResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  transcriptions?: Array<api_v2010_account_transcription>;
  uri?: string;
};

export type ListTranscriptionError = unknown;

export type DeleteTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Transcription resource to delete.
     */
    Sid: string;
  };
};

export type DeleteTranscriptionResponse = any;

export type DeleteTranscriptionError = unknown;

export type FetchTranscriptionData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the Transcription resource to fetch.
     */
    Sid: string;
  };
};

export type FetchTranscriptionResponse = api_v2010_account_transcription;

export type FetchTranscriptionError = unknown;

export type ListUsageRecordData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record>;
};

export type ListUsageRecordError = unknown;

export type ListUsageRecordAllTimeData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_all_time_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordAllTimeResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_all_time>;
};

export type ListUsageRecordAllTimeError = unknown;

export type ListUsageRecordDailyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_daily_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordDailyResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_daily>;
};

export type ListUsageRecordDailyError = unknown;

export type ListUsageRecordLastMonthData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_last_month_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordLastMonthResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_last_month>;
};

export type ListUsageRecordLastMonthError = unknown;

export type ListUsageRecordMonthlyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_monthly_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordMonthlyResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_monthly>;
};

export type ListUsageRecordMonthlyError = unknown;

export type ListUsageRecordThisMonthData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_this_month_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordThisMonthResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_this_month>;
};

export type ListUsageRecordThisMonthError = unknown;

export type ListUsageRecordTodayData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_today_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordTodayResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_today>;
};

export type ListUsageRecordTodayError = unknown;

export type ListUsageRecordYearlyData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_yearly_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordYearlyResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_yearly>;
};

export type ListUsageRecordYearlyError = unknown;

export type ListUsageRecordYesterdayData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageRecord resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The [usage category](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) of the UsageRecord resources to read. Only UsageRecord resources in the specified category are retrieved.
     */
    Category?: usage_record_yesterday_enum_category;
    /**
     * Only include usage that occurred on or before this date. Specify the date in GMT and format as `YYYY-MM-DD`.  You can also specify offsets from the current date, such as: `+30days`, which will set the end date to 30 days from the current date.
     */
    EndDate?: string;
    /**
     * Whether to include usage from the master account and all its subaccounts. Can be: `true` (the default) to include usage from the master account and all subaccounts or `false` to retrieve usage from only the specified account.
     */
    IncludeSubaccounts?: boolean;
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * Only include usage that has occurred on or after this date. Specify the date in GMT and format as `YYYY-MM-DD`. You can also specify offsets from the current date, such as: `-30days`, which will set the start date to be 30 days before the current date.
     */
    StartDate?: string;
  };
};

export type ListUsageRecordYesterdayResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_records?: Array<api_v2010_account_usage_usage_record_usage_record_yesterday>;
};

export type ListUsageRecordYesterdayError = unknown;

export type ListUsageTriggerData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageTrigger resources to read.
     */
    AccountSid: string;
  };
  query?: {
    /**
     * The page index. This value is simply for client state.
     */
    Page?: number;
    /**
     * How many resources to return in each list page. The default is 50, and the maximum is 1000.
     */
    PageSize?: number;
    /**
     * The page token. This is provided by the API.
     */
    PageToken?: string;
    /**
     * The frequency of recurring UsageTriggers to read. Can be: `daily`, `monthly`, or `yearly` to read recurring UsageTriggers. An empty value or a value of `alltime` reads non-recurring UsageTriggers.
     */
    Recurring?: usage_trigger_enum_recurring;
    /**
     * The trigger field of the UsageTriggers to read.  Can be: `count`, `usage`, or `price` as described in the [UsageRecords documentation](https://www.twilio.com/docs/usage/api/usage-record#usage-count-price).
     */
    TriggerBy?: usage_trigger_enum_trigger_field;
    /**
     * The usage category of the UsageTriggers to read. Must be a supported [usage categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).
     */
    UsageCategory?: usage_trigger_enum_usage_category;
  };
};

export type ListUsageTriggerResponse = {
  end?: number;
  first_page_uri?: string;
  next_page_uri?: string | null;
  page?: number;
  page_size?: number;
  previous_page_uri?: string | null;
  start?: number;
  uri?: string;
  usage_triggers?: Array<api_v2010_account_usage_usage_trigger>;
};

export type ListUsageTriggerError = unknown;

export type CreateUsageTriggerData = {
  body?: {
    /**
     * The HTTP method we should use to call `callback_url`. Can be: `GET` or `POST` and the default is `POST`.
     */
    CallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call using `callback_method` when the trigger fires.
     */
    CallbackUrl: string;
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
    /**
     * The frequency of a recurring UsageTrigger.  Can be: `daily`, `monthly`, or `yearly` for recurring triggers or empty for non-recurring triggers. A trigger will only fire once during each period. Recurring times are in GMT.
     */
    Recurring?: usage_trigger_enum_recurring;
    /**
     * The field in the [UsageRecord](https://www.twilio.com/docs/usage/api/usage-record) resource that should fire the trigger.  Can be: `count`, `usage`, or `price` as described in the [UsageRecords documentation](https://www.twilio.com/docs/usage/api/usage-record#usage-count-price).  The default is `usage`.
     */
    TriggerBy?: usage_trigger_enum_trigger_field;
    /**
     * The usage value at which the trigger should fire.  For convenience, you can use an offset value such as `+30` to specify a trigger_value that is 30 units more than the current usage value. Be sure to urlencode a `+` as `%2B`.
     */
    TriggerValue: string;
    /**
     * The usage category that the trigger should watch.  Use one of the supported [usage categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories) for this value.
     */
    UsageCategory: usage_trigger_enum_usage_category;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that will create the resource.
     */
    AccountSid: string;
  };
};

export type CreateUsageTriggerResponse = api_v2010_account_usage_usage_trigger;

export type CreateUsageTriggerError = unknown;

export type DeleteUsageTriggerData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageTrigger resources to delete.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the UsageTrigger resource to delete.
     */
    Sid: string;
  };
};

export type DeleteUsageTriggerResponse = any;

export type DeleteUsageTriggerError = unknown;

export type FetchUsageTriggerData = {
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageTrigger resource to fetch.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the UsageTrigger resource to fetch.
     */
    Sid: string;
  };
};

export type FetchUsageTriggerResponse = api_v2010_account_usage_usage_trigger;

export type FetchUsageTriggerError = unknown;

export type UpdateUsageTriggerData = {
  body?: {
    /**
     * The HTTP method we should use to call `callback_url`. Can be: `GET` or `POST` and the default is `POST`.
     */
    CallbackMethod?: 'HEAD' | 'GET' | 'POST' | 'PATCH' | 'PUT' | 'DELETE';
    /**
     * The URL we should call using `callback_method` when the trigger fires.
     */
    CallbackUrl?: string;
    /**
     * A descriptive string that you create to describe the resource. It can be up to 64 characters long.
     */
    FriendlyName?: string;
  };
  path: {
    /**
     * The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the UsageTrigger resources to update.
     */
    AccountSid: string;
    /**
     * The Twilio-provided string that uniquely identifies the UsageTrigger resource to update.
     */
    Sid: string;
  };
};

export type UpdateUsageTriggerResponse = api_v2010_account_usage_usage_trigger;

export type UpdateUsageTriggerError = unknown;

export type FetchAccountData = {
  path: {
    /**
     * The Account Sid that uniquely identifies the account to fetch
     */
    Sid: string;
  };
};

export type FetchAccountResponse = api_v2010_account;

export type FetchAccountError = unknown;

export type UpdateAccountData = {
  body?: {
    /**
     * Update the human-readable description of this Account
     */
    FriendlyName?: string;
    /**
     * Alter the status of this account: use `closed` to irreversibly close this account, `suspended` to temporarily suspend it, or `active` to reactivate it.
     */
    Status?: account_enum_status;
  };
  path: {
    /**
     * The Account Sid that uniquely identifies the account to update
     */
    Sid: string;
  };
};

export type UpdateAccountResponse = api_v2010_account;

export type UpdateAccountError = unknown;

export type FetchHealthCheckResponse = {
  /**
   * HealthCheck status
   */
  status?: string;
};

export type FetchHealthCheckError = unknown;
