// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, urlSearchParamsBodySerializer } from '@hey-api/client-fetch';

import type {
  ListAccountData,
  ListAccountError,
  ListAccountResponse,
  CreateAccountData,
  CreateAccountError,
  CreateAccountResponse,
  ListAddressData,
  ListAddressError,
  ListAddressResponse,
  CreateAddressData,
  CreateAddressError,
  CreateAddressResponse,
  ListDependentPhoneNumberData,
  ListDependentPhoneNumberError,
  ListDependentPhoneNumberResponse,
  DeleteAddressData,
  DeleteAddressError,
  DeleteAddressResponse,
  FetchAddressData,
  FetchAddressError,
  FetchAddressResponse,
  UpdateAddressData,
  UpdateAddressError,
  UpdateAddressResponse,
  ListApplicationData,
  ListApplicationError,
  ListApplicationResponse,
  CreateApplicationData,
  CreateApplicationError,
  CreateApplicationResponse,
  DeleteApplicationData,
  DeleteApplicationError,
  DeleteApplicationResponse,
  FetchApplicationData,
  FetchApplicationError,
  FetchApplicationResponse,
  UpdateApplicationData,
  UpdateApplicationError,
  UpdateApplicationResponse,
  ListAuthorizedConnectAppData,
  ListAuthorizedConnectAppError,
  ListAuthorizedConnectAppResponse,
  FetchAuthorizedConnectAppData,
  FetchAuthorizedConnectAppError,
  FetchAuthorizedConnectAppResponse,
  ListAvailablePhoneNumberCountryData,
  ListAvailablePhoneNumberCountryError,
  ListAvailablePhoneNumberCountryResponse,
  FetchAvailablePhoneNumberCountryData,
  FetchAvailablePhoneNumberCountryError,
  FetchAvailablePhoneNumberCountryResponse,
  ListAvailablePhoneNumberLocalData,
  ListAvailablePhoneNumberLocalError,
  ListAvailablePhoneNumberLocalResponse,
  ListAvailablePhoneNumberMachineToMachineData,
  ListAvailablePhoneNumberMachineToMachineError,
  ListAvailablePhoneNumberMachineToMachineResponse,
  ListAvailablePhoneNumberMobileData,
  ListAvailablePhoneNumberMobileError,
  ListAvailablePhoneNumberMobileResponse,
  ListAvailablePhoneNumberNationalData,
  ListAvailablePhoneNumberNationalError,
  ListAvailablePhoneNumberNationalResponse,
  ListAvailablePhoneNumberSharedCostData,
  ListAvailablePhoneNumberSharedCostError,
  ListAvailablePhoneNumberSharedCostResponse,
  ListAvailablePhoneNumberTollFreeData,
  ListAvailablePhoneNumberTollFreeError,
  ListAvailablePhoneNumberTollFreeResponse,
  ListAvailablePhoneNumberVoipData,
  ListAvailablePhoneNumberVoipError,
  ListAvailablePhoneNumberVoipResponse,
  FetchBalanceData,
  FetchBalanceError,
  FetchBalanceResponse,
  ListCallData,
  ListCallError,
  ListCallResponse,
  CreateCallData,
  CreateCallError,
  CreateCallResponse,
  ListCallEventData,
  ListCallEventError,
  ListCallEventResponse,
  ListCallNotificationData,
  ListCallNotificationError,
  ListCallNotificationResponse,
  FetchCallNotificationData,
  FetchCallNotificationError,
  FetchCallNotificationResponse,
  CreatePaymentsData,
  CreatePaymentsError,
  CreatePaymentsResponse,
  UpdatePaymentsData,
  UpdatePaymentsError,
  UpdatePaymentsResponse,
  ListCallRecordingData,
  ListCallRecordingError,
  ListCallRecordingResponse,
  CreateCallRecordingData,
  CreateCallRecordingError,
  CreateCallRecordingResponse,
  DeleteCallRecordingData,
  DeleteCallRecordingError,
  DeleteCallRecordingResponse,
  FetchCallRecordingData,
  FetchCallRecordingError,
  FetchCallRecordingResponse,
  UpdateCallRecordingData,
  UpdateCallRecordingError,
  UpdateCallRecordingResponse,
  CreateSiprecData,
  CreateSiprecError,
  CreateSiprecResponse,
  UpdateSiprecData,
  UpdateSiprecError,
  UpdateSiprecResponse,
  CreateStreamData,
  CreateStreamError,
  CreateStreamResponse,
  UpdateStreamData,
  UpdateStreamError,
  UpdateStreamResponse,
  CreateUserDefinedMessageSubscriptionData,
  CreateUserDefinedMessageSubscriptionError,
  CreateUserDefinedMessageSubscriptionResponse,
  DeleteUserDefinedMessageSubscriptionData,
  DeleteUserDefinedMessageSubscriptionError,
  DeleteUserDefinedMessageSubscriptionResponse,
  CreateUserDefinedMessageData,
  CreateUserDefinedMessageError,
  CreateUserDefinedMessageResponse,
  DeleteCallData,
  DeleteCallError,
  DeleteCallResponse,
  FetchCallData,
  FetchCallError,
  FetchCallResponse,
  UpdateCallData,
  UpdateCallError,
  UpdateCallResponse,
  ListConferenceData,
  ListConferenceError,
  ListConferenceResponse,
  ListParticipantData,
  ListParticipantError,
  ListParticipantResponse,
  CreateParticipantData,
  CreateParticipantError,
  CreateParticipantResponse,
  DeleteParticipantData,
  DeleteParticipantError,
  DeleteParticipantResponse,
  FetchParticipantData,
  FetchParticipantError,
  FetchParticipantResponse,
  UpdateParticipantData,
  UpdateParticipantError,
  UpdateParticipantResponse,
  ListConferenceRecordingData,
  ListConferenceRecordingError,
  ListConferenceRecordingResponse,
  DeleteConferenceRecordingData,
  DeleteConferenceRecordingError,
  DeleteConferenceRecordingResponse,
  FetchConferenceRecordingData,
  FetchConferenceRecordingError,
  FetchConferenceRecordingResponse,
  UpdateConferenceRecordingData,
  UpdateConferenceRecordingError,
  UpdateConferenceRecordingResponse,
  FetchConferenceData,
  FetchConferenceError,
  FetchConferenceResponse,
  UpdateConferenceData,
  UpdateConferenceError,
  UpdateConferenceResponse,
  ListConnectAppData,
  ListConnectAppError,
  ListConnectAppResponse,
  DeleteConnectAppData,
  DeleteConnectAppError,
  DeleteConnectAppResponse,
  FetchConnectAppData,
  FetchConnectAppError,
  FetchConnectAppResponse,
  UpdateConnectAppData,
  UpdateConnectAppError,
  UpdateConnectAppResponse,
  ListIncomingPhoneNumberData,
  ListIncomingPhoneNumberError,
  ListIncomingPhoneNumberResponse,
  CreateIncomingPhoneNumberData,
  CreateIncomingPhoneNumberError,
  CreateIncomingPhoneNumberResponse,
  ListIncomingPhoneNumberLocalData,
  ListIncomingPhoneNumberLocalError,
  ListIncomingPhoneNumberLocalResponse,
  CreateIncomingPhoneNumberLocalData,
  CreateIncomingPhoneNumberLocalError,
  CreateIncomingPhoneNumberLocalResponse,
  ListIncomingPhoneNumberMobileData,
  ListIncomingPhoneNumberMobileError,
  ListIncomingPhoneNumberMobileResponse,
  CreateIncomingPhoneNumberMobileData,
  CreateIncomingPhoneNumberMobileError,
  CreateIncomingPhoneNumberMobileResponse,
  ListIncomingPhoneNumberTollFreeData,
  ListIncomingPhoneNumberTollFreeError,
  ListIncomingPhoneNumberTollFreeResponse,
  CreateIncomingPhoneNumberTollFreeData,
  CreateIncomingPhoneNumberTollFreeError,
  CreateIncomingPhoneNumberTollFreeResponse,
  ListIncomingPhoneNumberAssignedAddOnData,
  ListIncomingPhoneNumberAssignedAddOnError,
  ListIncomingPhoneNumberAssignedAddOnResponse,
  CreateIncomingPhoneNumberAssignedAddOnData,
  CreateIncomingPhoneNumberAssignedAddOnError,
  CreateIncomingPhoneNumberAssignedAddOnResponse,
  ListIncomingPhoneNumberAssignedAddOnExtensionData,
  ListIncomingPhoneNumberAssignedAddOnExtensionError,
  ListIncomingPhoneNumberAssignedAddOnExtensionResponse,
  FetchIncomingPhoneNumberAssignedAddOnExtensionData,
  FetchIncomingPhoneNumberAssignedAddOnExtensionError,
  FetchIncomingPhoneNumberAssignedAddOnExtensionResponse,
  DeleteIncomingPhoneNumberAssignedAddOnData,
  DeleteIncomingPhoneNumberAssignedAddOnError,
  DeleteIncomingPhoneNumberAssignedAddOnResponse,
  FetchIncomingPhoneNumberAssignedAddOnData,
  FetchIncomingPhoneNumberAssignedAddOnError,
  FetchIncomingPhoneNumberAssignedAddOnResponse,
  DeleteIncomingPhoneNumberData,
  DeleteIncomingPhoneNumberError,
  DeleteIncomingPhoneNumberResponse,
  FetchIncomingPhoneNumberData,
  FetchIncomingPhoneNumberError,
  FetchIncomingPhoneNumberResponse,
  UpdateIncomingPhoneNumberData,
  UpdateIncomingPhoneNumberError,
  UpdateIncomingPhoneNumberResponse,
  ListKeyData,
  ListKeyError,
  ListKeyResponse,
  CreateNewKeyData,
  CreateNewKeyError,
  CreateNewKeyResponse,
  DeleteKeyData,
  DeleteKeyError,
  DeleteKeyResponse,
  FetchKeyData,
  FetchKeyError,
  FetchKeyResponse,
  UpdateKeyData,
  UpdateKeyError,
  UpdateKeyResponse,
  ListMessageData,
  ListMessageError,
  ListMessageResponse,
  CreateMessageData,
  CreateMessageError,
  CreateMessageResponse,
  CreateMessageFeedbackData,
  CreateMessageFeedbackError,
  CreateMessageFeedbackResponse,
  ListMediaData,
  ListMediaError,
  ListMediaResponse,
  DeleteMediaData,
  DeleteMediaError,
  DeleteMediaResponse,
  FetchMediaData,
  FetchMediaError,
  FetchMediaResponse,
  DeleteMessageData,
  DeleteMessageError,
  DeleteMessageResponse,
  FetchMessageData,
  FetchMessageError,
  FetchMessageResponse,
  UpdateMessageData,
  UpdateMessageError,
  UpdateMessageResponse,
  ListNotificationData,
  ListNotificationError,
  ListNotificationResponse,
  FetchNotificationData,
  FetchNotificationError,
  FetchNotificationResponse,
  ListOutgoingCallerIdData,
  ListOutgoingCallerIdError,
  ListOutgoingCallerIdResponse,
  CreateValidationRequestData,
  CreateValidationRequestError,
  CreateValidationRequestResponse,
  DeleteOutgoingCallerIdData,
  DeleteOutgoingCallerIdError,
  DeleteOutgoingCallerIdResponse,
  FetchOutgoingCallerIdData,
  FetchOutgoingCallerIdError,
  FetchOutgoingCallerIdResponse,
  UpdateOutgoingCallerIdData,
  UpdateOutgoingCallerIdError,
  UpdateOutgoingCallerIdResponse,
  ListQueueData,
  ListQueueError,
  ListQueueResponse,
  CreateQueueData,
  CreateQueueError,
  CreateQueueResponse,
  ListMemberData,
  ListMemberError,
  ListMemberResponse,
  FetchMemberData,
  FetchMemberError,
  FetchMemberResponse,
  UpdateMemberData,
  UpdateMemberError,
  UpdateMemberResponse,
  DeleteQueueData,
  DeleteQueueError,
  DeleteQueueResponse,
  FetchQueueData,
  FetchQueueError,
  FetchQueueResponse,
  UpdateQueueData,
  UpdateQueueError,
  UpdateQueueResponse,
  ListRecordingData,
  ListRecordingError,
  ListRecordingResponse,
  ListRecordingTranscriptionData,
  ListRecordingTranscriptionError,
  ListRecordingTranscriptionResponse,
  DeleteRecordingTranscriptionData,
  DeleteRecordingTranscriptionError,
  DeleteRecordingTranscriptionResponse,
  FetchRecordingTranscriptionData,
  FetchRecordingTranscriptionError,
  FetchRecordingTranscriptionResponse,
  ListRecordingAddOnResultData,
  ListRecordingAddOnResultError,
  ListRecordingAddOnResultResponse,
  ListRecordingAddOnResultPayloadData,
  ListRecordingAddOnResultPayloadError,
  ListRecordingAddOnResultPayloadResponse,
  DeleteRecordingAddOnResultPayloadData,
  DeleteRecordingAddOnResultPayloadError,
  DeleteRecordingAddOnResultPayloadResponse,
  FetchRecordingAddOnResultPayloadData,
  FetchRecordingAddOnResultPayloadError,
  FetchRecordingAddOnResultPayloadResponse,
  DeleteRecordingAddOnResultData,
  DeleteRecordingAddOnResultError,
  DeleteRecordingAddOnResultResponse,
  FetchRecordingAddOnResultData,
  FetchRecordingAddOnResultError,
  FetchRecordingAddOnResultResponse,
  DeleteRecordingData,
  DeleteRecordingError,
  DeleteRecordingResponse,
  FetchRecordingData,
  FetchRecordingError,
  FetchRecordingResponse,
  ListSipCredentialListData,
  ListSipCredentialListError,
  ListSipCredentialListResponse,
  CreateSipCredentialListData,
  CreateSipCredentialListError,
  CreateSipCredentialListResponse,
  ListSipCredentialData,
  ListSipCredentialError,
  ListSipCredentialResponse,
  CreateSipCredentialData,
  CreateSipCredentialError,
  CreateSipCredentialResponse,
  DeleteSipCredentialData,
  DeleteSipCredentialError,
  DeleteSipCredentialResponse,
  FetchSipCredentialData,
  FetchSipCredentialError,
  FetchSipCredentialResponse,
  UpdateSipCredentialData,
  UpdateSipCredentialError,
  UpdateSipCredentialResponse,
  DeleteSipCredentialListData,
  DeleteSipCredentialListError,
  DeleteSipCredentialListResponse,
  FetchSipCredentialListData,
  FetchSipCredentialListError,
  FetchSipCredentialListResponse,
  UpdateSipCredentialListData,
  UpdateSipCredentialListError,
  UpdateSipCredentialListResponse,
  ListSipDomainData,
  ListSipDomainError,
  ListSipDomainResponse,
  CreateSipDomainData,
  CreateSipDomainError,
  CreateSipDomainResponse,
  ListSipAuthCallsCredentialListMappingData,
  ListSipAuthCallsCredentialListMappingError,
  ListSipAuthCallsCredentialListMappingResponse,
  CreateSipAuthCallsCredentialListMappingData,
  CreateSipAuthCallsCredentialListMappingError,
  CreateSipAuthCallsCredentialListMappingResponse,
  DeleteSipAuthCallsCredentialListMappingData,
  DeleteSipAuthCallsCredentialListMappingError,
  DeleteSipAuthCallsCredentialListMappingResponse,
  FetchSipAuthCallsCredentialListMappingData,
  FetchSipAuthCallsCredentialListMappingError,
  FetchSipAuthCallsCredentialListMappingResponse,
  ListSipAuthCallsIpAccessControlListMappingData,
  ListSipAuthCallsIpAccessControlListMappingError,
  ListSipAuthCallsIpAccessControlListMappingResponse,
  CreateSipAuthCallsIpAccessControlListMappingData,
  CreateSipAuthCallsIpAccessControlListMappingError,
  CreateSipAuthCallsIpAccessControlListMappingResponse,
  DeleteSipAuthCallsIpAccessControlListMappingData,
  DeleteSipAuthCallsIpAccessControlListMappingError,
  DeleteSipAuthCallsIpAccessControlListMappingResponse,
  FetchSipAuthCallsIpAccessControlListMappingData,
  FetchSipAuthCallsIpAccessControlListMappingError,
  FetchSipAuthCallsIpAccessControlListMappingResponse,
  ListSipAuthRegistrationsCredentialListMappingData,
  ListSipAuthRegistrationsCredentialListMappingError,
  ListSipAuthRegistrationsCredentialListMappingResponse,
  CreateSipAuthRegistrationsCredentialListMappingData,
  CreateSipAuthRegistrationsCredentialListMappingError,
  CreateSipAuthRegistrationsCredentialListMappingResponse,
  DeleteSipAuthRegistrationsCredentialListMappingData,
  DeleteSipAuthRegistrationsCredentialListMappingError,
  DeleteSipAuthRegistrationsCredentialListMappingResponse,
  FetchSipAuthRegistrationsCredentialListMappingData,
  FetchSipAuthRegistrationsCredentialListMappingError,
  FetchSipAuthRegistrationsCredentialListMappingResponse,
  ListSipCredentialListMappingData,
  ListSipCredentialListMappingError,
  ListSipCredentialListMappingResponse,
  CreateSipCredentialListMappingData,
  CreateSipCredentialListMappingError,
  CreateSipCredentialListMappingResponse,
  DeleteSipCredentialListMappingData,
  DeleteSipCredentialListMappingError,
  DeleteSipCredentialListMappingResponse,
  FetchSipCredentialListMappingData,
  FetchSipCredentialListMappingError,
  FetchSipCredentialListMappingResponse,
  ListSipIpAccessControlListMappingData,
  ListSipIpAccessControlListMappingError,
  ListSipIpAccessControlListMappingResponse,
  CreateSipIpAccessControlListMappingData,
  CreateSipIpAccessControlListMappingError,
  CreateSipIpAccessControlListMappingResponse,
  DeleteSipIpAccessControlListMappingData,
  DeleteSipIpAccessControlListMappingError,
  DeleteSipIpAccessControlListMappingResponse,
  FetchSipIpAccessControlListMappingData,
  FetchSipIpAccessControlListMappingError,
  FetchSipIpAccessControlListMappingResponse,
  DeleteSipDomainData,
  DeleteSipDomainError,
  DeleteSipDomainResponse,
  FetchSipDomainData,
  FetchSipDomainError,
  FetchSipDomainResponse,
  UpdateSipDomainData,
  UpdateSipDomainError,
  UpdateSipDomainResponse,
  ListSipIpAccessControlListData,
  ListSipIpAccessControlListError,
  ListSipIpAccessControlListResponse,
  CreateSipIpAccessControlListData,
  CreateSipIpAccessControlListError,
  CreateSipIpAccessControlListResponse,
  ListSipIpAddressData,
  ListSipIpAddressError,
  ListSipIpAddressResponse,
  CreateSipIpAddressData,
  CreateSipIpAddressError,
  CreateSipIpAddressResponse,
  DeleteSipIpAddressData,
  DeleteSipIpAddressError,
  DeleteSipIpAddressResponse,
  FetchSipIpAddressData,
  FetchSipIpAddressError,
  FetchSipIpAddressResponse,
  UpdateSipIpAddressData,
  UpdateSipIpAddressError,
  UpdateSipIpAddressResponse,
  DeleteSipIpAccessControlListData,
  DeleteSipIpAccessControlListError,
  DeleteSipIpAccessControlListResponse,
  FetchSipIpAccessControlListData,
  FetchSipIpAccessControlListError,
  FetchSipIpAccessControlListResponse,
  UpdateSipIpAccessControlListData,
  UpdateSipIpAccessControlListError,
  UpdateSipIpAccessControlListResponse,
  ListShortCodeData,
  ListShortCodeError,
  ListShortCodeResponse,
  FetchShortCodeData,
  FetchShortCodeError,
  FetchShortCodeResponse,
  UpdateShortCodeData,
  UpdateShortCodeError,
  UpdateShortCodeResponse,
  ListSigningKeyData,
  ListSigningKeyError,
  ListSigningKeyResponse,
  CreateNewSigningKeyData,
  CreateNewSigningKeyError,
  CreateNewSigningKeyResponse,
  DeleteSigningKeyData,
  DeleteSigningKeyError,
  DeleteSigningKeyResponse,
  FetchSigningKeyData,
  FetchSigningKeyError,
  FetchSigningKeyResponse,
  UpdateSigningKeyData,
  UpdateSigningKeyError,
  UpdateSigningKeyResponse,
  CreateTokenData,
  CreateTokenError,
  CreateTokenResponse,
  ListTranscriptionData,
  ListTranscriptionError,
  ListTranscriptionResponse,
  DeleteTranscriptionData,
  DeleteTranscriptionError,
  DeleteTranscriptionResponse,
  FetchTranscriptionData,
  FetchTranscriptionError,
  FetchTranscriptionResponse,
  ListUsageRecordData,
  ListUsageRecordError,
  ListUsageRecordResponse,
  ListUsageRecordAllTimeData,
  ListUsageRecordAllTimeError,
  ListUsageRecordAllTimeResponse,
  ListUsageRecordDailyData,
  ListUsageRecordDailyError,
  ListUsageRecordDailyResponse,
  ListUsageRecordLastMonthData,
  ListUsageRecordLastMonthError,
  ListUsageRecordLastMonthResponse,
  ListUsageRecordMonthlyData,
  ListUsageRecordMonthlyError,
  ListUsageRecordMonthlyResponse,
  ListUsageRecordThisMonthData,
  ListUsageRecordThisMonthError,
  ListUsageRecordThisMonthResponse,
  ListUsageRecordTodayData,
  ListUsageRecordTodayError,
  ListUsageRecordTodayResponse,
  ListUsageRecordYearlyData,
  ListUsageRecordYearlyError,
  ListUsageRecordYearlyResponse,
  ListUsageRecordYesterdayData,
  ListUsageRecordYesterdayError,
  ListUsageRecordYesterdayResponse,
  ListUsageTriggerData,
  ListUsageTriggerError,
  ListUsageTriggerResponse,
  CreateUsageTriggerData,
  CreateUsageTriggerError,
  CreateUsageTriggerResponse,
  DeleteUsageTriggerData,
  DeleteUsageTriggerError,
  DeleteUsageTriggerResponse,
  FetchUsageTriggerData,
  FetchUsageTriggerError,
  FetchUsageTriggerResponse,
  UpdateUsageTriggerData,
  UpdateUsageTriggerError,
  UpdateUsageTriggerResponse,
  FetchAccountData,
  FetchAccountError,
  FetchAccountResponse,
  UpdateAccountData,
  UpdateAccountError,
  UpdateAccountResponse,
  FetchHealthCheckError,
  FetchHealthCheckResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Retrieves a collection of Accounts belonging to the account used to make the request
 */
export const listAccount = <ThrowOnError extends boolean = false>(options?: Options<ListAccountData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListAccountResponse, ListAccountError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts.json',
  });
};

/**
 * Create a new Twilio Subaccount from the account making the request
 */
export const createAccount = <ThrowOnError extends boolean = false>(
  options?: Options<CreateAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAccountResponse, CreateAccountError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts.json',
  });
};

export const listAddress = <ThrowOnError extends boolean = false>(options: Options<ListAddressData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListAddressResponse, ListAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Addresses.json',
  });
};

export const createAddress = <ThrowOnError extends boolean = false>(
  options: Options<CreateAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAddressResponse, CreateAddressError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Addresses.json',
  });
};

export const listDependentPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<ListDependentPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDependentPhoneNumberResponse, ListDependentPhoneNumberError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Addresses/{AddressSid}/DependentPhoneNumbers.json',
    },
  );
};

export const deleteAddress = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAddressResponse, DeleteAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Addresses/{Sid}.json',
  });
};

export const fetchAddress = <ThrowOnError extends boolean = false>(
  options: Options<FetchAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchAddressResponse, FetchAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Addresses/{Sid}.json',
  });
};

export const updateAddress = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateAddressResponse, UpdateAddressError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Addresses/{Sid}.json',
  });
};

/**
 * Retrieve a list of applications representing an application within the requesting account
 */
export const listApplication = <ThrowOnError extends boolean = false>(
  options: Options<ListApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListApplicationResponse, ListApplicationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Applications.json',
  });
};

/**
 * Create a new application within your account
 */
export const createApplication = <ThrowOnError extends boolean = false>(
  options: Options<CreateApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateApplicationResponse, CreateApplicationError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Applications.json',
  });
};

/**
 * Delete the application by the specified application sid
 */
export const deleteApplication = <ThrowOnError extends boolean = false>(
  options: Options<DeleteApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteApplicationResponse, DeleteApplicationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Applications/{Sid}.json',
  });
};

/**
 * Fetch the application specified by the provided sid
 */
export const fetchApplication = <ThrowOnError extends boolean = false>(
  options: Options<FetchApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchApplicationResponse, FetchApplicationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Applications/{Sid}.json',
  });
};

/**
 * Updates the application's properties
 */
export const updateApplication = <ThrowOnError extends boolean = false>(
  options: Options<UpdateApplicationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateApplicationResponse, UpdateApplicationError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Applications/{Sid}.json',
  });
};

/**
 * Retrieve a list of authorized-connect-apps belonging to the account used to make the request
 */
export const listAuthorizedConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<ListAuthorizedConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAuthorizedConnectAppResponse, ListAuthorizedConnectAppError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/AuthorizedConnectApps.json',
    },
  );
};

/**
 * Fetch an instance of an authorized-connect-app
 */
export const fetchAuthorizedConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<FetchAuthorizedConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchAuthorizedConnectAppResponse,
    FetchAuthorizedConnectAppError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AuthorizedConnectApps/{ConnectAppSid}.json',
  });
};

export const listAvailablePhoneNumberCountry = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberCountryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberCountryResponse,
    ListAvailablePhoneNumberCountryError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers.json',
  });
};

export const fetchAvailablePhoneNumberCountry = <ThrowOnError extends boolean = false>(
  options: Options<FetchAvailablePhoneNumberCountryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchAvailablePhoneNumberCountryResponse,
    FetchAvailablePhoneNumberCountryError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}.json',
  });
};

export const listAvailablePhoneNumberLocal = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberLocalData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberLocalResponse,
    ListAvailablePhoneNumberLocalError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/Local.json',
  });
};

export const listAvailablePhoneNumberMachineToMachine = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberMachineToMachineData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberMachineToMachineResponse,
    ListAvailablePhoneNumberMachineToMachineError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/MachineToMachine.json',
  });
};

export const listAvailablePhoneNumberMobile = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberMobileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberMobileResponse,
    ListAvailablePhoneNumberMobileError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/Mobile.json',
  });
};

export const listAvailablePhoneNumberNational = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberNationalData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberNationalResponse,
    ListAvailablePhoneNumberNationalError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/National.json',
  });
};

export const listAvailablePhoneNumberSharedCost = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberSharedCostData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberSharedCostResponse,
    ListAvailablePhoneNumberSharedCostError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/SharedCost.json',
  });
};

export const listAvailablePhoneNumberTollFree = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberTollFreeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberTollFreeResponse,
    ListAvailablePhoneNumberTollFreeError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/TollFree.json',
  });
};

export const listAvailablePhoneNumberVoip = <ThrowOnError extends boolean = false>(
  options: Options<ListAvailablePhoneNumberVoipData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAvailablePhoneNumberVoipResponse,
    ListAvailablePhoneNumberVoipError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/AvailablePhoneNumbers/{CountryCode}/Voip.json',
  });
};

/**
 * Fetch the balance for an Account based on Account Sid. Balance changes may not be reflected immediately. Child accounts do not contain balance information
 */
export const fetchBalance = <ThrowOnError extends boolean = false>(
  options: Options<FetchBalanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchBalanceResponse, FetchBalanceError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Balance.json',
  });
};

/**
 * Retrieves a collection of calls made to and from your account
 */
export const listCall = <ThrowOnError extends boolean = false>(options: Options<ListCallData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListCallResponse, ListCallError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls.json',
  });
};

/**
 * Create a new outgoing call to phones, SIP-enabled endpoints or Twilio Client connections
 */
export const createCall = <ThrowOnError extends boolean = false>(options: Options<CreateCallData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateCallResponse, CreateCallError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls.json',
  });
};

/**
 * Retrieve a list of all events for a call.
 */
export const listCallEvent = <ThrowOnError extends boolean = false>(
  options: Options<ListCallEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCallEventResponse, ListCallEventError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Events.json',
  });
};

export const listCallNotification = <ThrowOnError extends boolean = false>(
  options: Options<ListCallNotificationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCallNotificationResponse, ListCallNotificationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Notifications.json',
  });
};

export const fetchCallNotification = <ThrowOnError extends boolean = false>(
  options: Options<FetchCallNotificationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchCallNotificationResponse, FetchCallNotificationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Notifications/{Sid}.json',
  });
};

/**
 * create an instance of payments. This will start a new payments session
 */
export const createPayments = <ThrowOnError extends boolean = false>(
  options: Options<CreatePaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePaymentsResponse, CreatePaymentsError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Payments.json',
  });
};

/**
 * update an instance of payments with different phases of payment flows.
 */
export const updatePayments = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdatePaymentsResponse, UpdatePaymentsError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Payments/{Sid}.json',
  });
};

/**
 * Retrieve a list of recordings belonging to the call used to make the request
 */
export const listCallRecording = <ThrowOnError extends boolean = false>(
  options: Options<ListCallRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCallRecordingResponse, ListCallRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Recordings.json',
  });
};

/**
 * Create a recording for the call
 */
export const createCallRecording = <ThrowOnError extends boolean = false>(
  options: Options<CreateCallRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateCallRecordingResponse, CreateCallRecordingError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Recordings.json',
  });
};

/**
 * Delete a recording from your account
 */
export const deleteCallRecording = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCallRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCallRecordingResponse, DeleteCallRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Recordings/{Sid}.json',
  });
};

/**
 * Fetch an instance of a recording for a call
 */
export const fetchCallRecording = <ThrowOnError extends boolean = false>(
  options: Options<FetchCallRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchCallRecordingResponse, FetchCallRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Recordings/{Sid}.json',
  });
};

/**
 * Changes the status of the recording to paused, stopped, or in-progress. Note: Pass `Twilio.CURRENT` instead of recording sid to reference current active recording.
 */
export const updateCallRecording = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCallRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateCallRecordingResponse, UpdateCallRecordingError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Recordings/{Sid}.json',
  });
};

/**
 * Create a Siprec
 */
export const createSiprec = <ThrowOnError extends boolean = false>(
  options: Options<CreateSiprecData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSiprecResponse, CreateSiprecError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Siprec.json',
  });
};

/**
 * Stop a Siprec using either the SID of the Siprec resource or the `name` used when creating the resource
 */
export const updateSiprec = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSiprecData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSiprecResponse, UpdateSiprecError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Siprec/{Sid}.json',
  });
};

/**
 * Create a Stream
 */
export const createStream = <ThrowOnError extends boolean = false>(
  options: Options<CreateStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateStreamResponse, CreateStreamError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Streams.json',
  });
};

/**
 * Stop a Stream using either the SID of the Stream resource or the `name` used when creating the resource
 */
export const updateStream = <ThrowOnError extends boolean = false>(
  options: Options<UpdateStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateStreamResponse, UpdateStreamError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Streams/{Sid}.json',
  });
};

/**
 * Subscribe to User Defined Messages for a given Call SID.
 */
export const createUserDefinedMessageSubscription = <ThrowOnError extends boolean = false>(
  options: Options<CreateUserDefinedMessageSubscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateUserDefinedMessageSubscriptionResponse,
    CreateUserDefinedMessageSubscriptionError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/UserDefinedMessageSubscriptions.json',
  });
};

/**
 * Delete a specific User Defined Message Subscription.
 */
export const deleteUserDefinedMessageSubscription = <ThrowOnError extends boolean = false>(
  options: Options<DeleteUserDefinedMessageSubscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteUserDefinedMessageSubscriptionResponse,
    DeleteUserDefinedMessageSubscriptionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/UserDefinedMessageSubscriptions/{Sid}.json',
  });
};

/**
 * Create a new User Defined Message for the given Call SID.
 */
export const createUserDefinedMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateUserDefinedMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateUserDefinedMessageResponse,
    CreateUserDefinedMessageError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/UserDefinedMessages.json',
  });
};

/**
 * Delete a Call record from your account. Once the record is deleted, it will no longer appear in the API and Account Portal logs.
 */
export const deleteCall = <ThrowOnError extends boolean = false>(options: Options<DeleteCallData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteCallResponse, DeleteCallError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{Sid}.json',
  });
};

/**
 * Fetch the call specified by the provided Call SID
 */
export const fetchCall = <ThrowOnError extends boolean = false>(options: Options<FetchCallData, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchCallResponse, FetchCallError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{Sid}.json',
  });
};

/**
 * Initiates a call redirect or terminates a call
 */
export const updateCall = <ThrowOnError extends boolean = false>(options: Options<UpdateCallData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpdateCallResponse, UpdateCallError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Calls/{Sid}.json',
  });
};

/**
 * Retrieve a list of conferences belonging to the account used to make the request
 */
export const listConference = <ThrowOnError extends boolean = false>(
  options: Options<ListConferenceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListConferenceResponse, ListConferenceError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences.json',
  });
};

/**
 * Retrieve a list of participants belonging to the account used to make the request
 */
export const listParticipant = <ThrowOnError extends boolean = false>(
  options: Options<ListParticipantData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListParticipantResponse, ListParticipantError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants.json',
  });
};

export const createParticipant = <ThrowOnError extends boolean = false>(
  options: Options<CreateParticipantData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateParticipantResponse, CreateParticipantError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants.json',
  });
};

/**
 * Kick a participant from a given conference
 */
export const deleteParticipant = <ThrowOnError extends boolean = false>(
  options: Options<DeleteParticipantData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteParticipantResponse, DeleteParticipantError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants/{CallSid}.json',
  });
};

/**
 * Fetch an instance of a participant
 */
export const fetchParticipant = <ThrowOnError extends boolean = false>(
  options: Options<FetchParticipantData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchParticipantResponse, FetchParticipantError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants/{CallSid}.json',
  });
};

/**
 * Update the properties of the participant
 */
export const updateParticipant = <ThrowOnError extends boolean = false>(
  options: Options<UpdateParticipantData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateParticipantResponse, UpdateParticipantError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants/{CallSid}.json',
  });
};

/**
 * Retrieve a list of recordings belonging to the call used to make the request
 */
export const listConferenceRecording = <ThrowOnError extends boolean = false>(
  options: Options<ListConferenceRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListConferenceRecordingResponse, ListConferenceRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Recordings.json',
  });
};

/**
 * Delete a recording from your account
 */
export const deleteConferenceRecording = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConferenceRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteConferenceRecordingResponse,
    DeleteConferenceRecordingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Recordings/{Sid}.json',
  });
};

/**
 * Fetch an instance of a recording for a call
 */
export const fetchConferenceRecording = <ThrowOnError extends boolean = false>(
  options: Options<FetchConferenceRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchConferenceRecordingResponse, FetchConferenceRecordingError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Recordings/{Sid}.json',
    },
  );
};

/**
 * Changes the status of the recording to paused, stopped, or in-progress. Note: To use `Twilio.CURRENT`, pass it as recording sid.
 */
export const updateConferenceRecording = <ThrowOnError extends boolean = false>(
  options: Options<UpdateConferenceRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateConferenceRecordingResponse,
    UpdateConferenceRecordingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Recordings/{Sid}.json',
  });
};

/**
 * Fetch an instance of a conference
 */
export const fetchConference = <ThrowOnError extends boolean = false>(
  options: Options<FetchConferenceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchConferenceResponse, FetchConferenceError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{Sid}.json',
  });
};

export const updateConference = <ThrowOnError extends boolean = false>(
  options: Options<UpdateConferenceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateConferenceResponse, UpdateConferenceError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Conferences/{Sid}.json',
  });
};

/**
 * Retrieve a list of connect-apps belonging to the account used to make the request
 */
export const listConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<ListConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListConnectAppResponse, ListConnectAppError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/ConnectApps.json',
  });
};

/**
 * Delete an instance of a connect-app
 */
export const deleteConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteConnectAppResponse, DeleteConnectAppError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/ConnectApps/{Sid}.json',
  });
};

/**
 * Fetch an instance of a connect-app
 */
export const fetchConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<FetchConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchConnectAppResponse, FetchConnectAppError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/ConnectApps/{Sid}.json',
  });
};

/**
 * Update a connect-app with the specified parameters
 */
export const updateConnectApp = <ThrowOnError extends boolean = false>(
  options: Options<UpdateConnectAppData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateConnectAppResponse, UpdateConnectAppError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/ConnectApps/{Sid}.json',
  });
};

/**
 * Retrieve a list of incoming-phone-numbers belonging to the account used to make the request.
 */
export const listIncomingPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListIncomingPhoneNumberResponse, ListIncomingPhoneNumberError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers.json',
  });
};

/**
 * Purchase a phone-number for the account.
 */
export const createIncomingPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<CreateIncomingPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateIncomingPhoneNumberResponse,
    CreateIncomingPhoneNumberError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers.json',
  });
};

export const listIncomingPhoneNumberLocal = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberLocalData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListIncomingPhoneNumberLocalResponse,
    ListIncomingPhoneNumberLocalError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/Local.json',
  });
};

export const createIncomingPhoneNumberLocal = <ThrowOnError extends boolean = false>(
  options: Options<CreateIncomingPhoneNumberLocalData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateIncomingPhoneNumberLocalResponse,
    CreateIncomingPhoneNumberLocalError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/Local.json',
  });
};

export const listIncomingPhoneNumberMobile = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberMobileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListIncomingPhoneNumberMobileResponse,
    ListIncomingPhoneNumberMobileError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/Mobile.json',
  });
};

export const createIncomingPhoneNumberMobile = <ThrowOnError extends boolean = false>(
  options: Options<CreateIncomingPhoneNumberMobileData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateIncomingPhoneNumberMobileResponse,
    CreateIncomingPhoneNumberMobileError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/Mobile.json',
  });
};

export const listIncomingPhoneNumberTollFree = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberTollFreeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListIncomingPhoneNumberTollFreeResponse,
    ListIncomingPhoneNumberTollFreeError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/TollFree.json',
  });
};

export const createIncomingPhoneNumberTollFree = <ThrowOnError extends boolean = false>(
  options: Options<CreateIncomingPhoneNumberTollFreeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateIncomingPhoneNumberTollFreeResponse,
    CreateIncomingPhoneNumberTollFreeError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/TollFree.json',
  });
};

/**
 * Retrieve a list of Add-on installations currently assigned to this Number.
 */
export const listIncomingPhoneNumberAssignedAddOn = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberAssignedAddOnData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListIncomingPhoneNumberAssignedAddOnResponse,
    ListIncomingPhoneNumberAssignedAddOnError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns.json',
  });
};

/**
 * Assign an Add-on installation to the Number specified.
 */
export const createIncomingPhoneNumberAssignedAddOn = <ThrowOnError extends boolean = false>(
  options: Options<CreateIncomingPhoneNumberAssignedAddOnData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateIncomingPhoneNumberAssignedAddOnResponse,
    CreateIncomingPhoneNumberAssignedAddOnError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns.json',
  });
};

/**
 * Retrieve a list of Extensions for the Assigned Add-on.
 */
export const listIncomingPhoneNumberAssignedAddOnExtension = <ThrowOnError extends boolean = false>(
  options: Options<ListIncomingPhoneNumberAssignedAddOnExtensionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListIncomingPhoneNumberAssignedAddOnExtensionResponse,
    ListIncomingPhoneNumberAssignedAddOnExtensionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns/{AssignedAddOnSid}/Extensions.json',
  });
};

/**
 * Fetch an instance of an Extension for the Assigned Add-on.
 */
export const fetchIncomingPhoneNumberAssignedAddOnExtension = <ThrowOnError extends boolean = false>(
  options: Options<FetchIncomingPhoneNumberAssignedAddOnExtensionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchIncomingPhoneNumberAssignedAddOnExtensionResponse,
    FetchIncomingPhoneNumberAssignedAddOnExtensionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns/{AssignedAddOnSid}/Extensions/{Sid}.json',
  });
};

/**
 * Remove the assignment of an Add-on installation from the Number specified.
 */
export const deleteIncomingPhoneNumberAssignedAddOn = <ThrowOnError extends boolean = false>(
  options: Options<DeleteIncomingPhoneNumberAssignedAddOnData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteIncomingPhoneNumberAssignedAddOnResponse,
    DeleteIncomingPhoneNumberAssignedAddOnError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns/{Sid}.json',
  });
};

/**
 * Fetch an instance of an Add-on installation currently assigned to this Number.
 */
export const fetchIncomingPhoneNumberAssignedAddOn = <ThrowOnError extends boolean = false>(
  options: Options<FetchIncomingPhoneNumberAssignedAddOnData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchIncomingPhoneNumberAssignedAddOnResponse,
    FetchIncomingPhoneNumberAssignedAddOnError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns/{Sid}.json',
  });
};

/**
 * Delete a phone-numbers belonging to the account used to make the request.
 */
export const deleteIncomingPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<DeleteIncomingPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteIncomingPhoneNumberResponse,
    DeleteIncomingPhoneNumberError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{Sid}.json',
  });
};

/**
 * Fetch an incoming-phone-number belonging to the account used to make the request.
 */
export const fetchIncomingPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<FetchIncomingPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchIncomingPhoneNumberResponse, FetchIncomingPhoneNumberError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{Sid}.json',
    },
  );
};

/**
 * Update an incoming-phone-number instance.
 */
export const updateIncomingPhoneNumber = <ThrowOnError extends boolean = false>(
  options: Options<UpdateIncomingPhoneNumberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateIncomingPhoneNumberResponse,
    UpdateIncomingPhoneNumberError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{Sid}.json',
  });
};

export const listKey = <ThrowOnError extends boolean = false>(options: Options<ListKeyData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListKeyResponse, ListKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Keys.json',
  });
};

export const createNewKey = <ThrowOnError extends boolean = false>(
  options: Options<CreateNewKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateNewKeyResponse, CreateNewKeyError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Keys.json',
  });
};

export const deleteKey = <ThrowOnError extends boolean = false>(options: Options<DeleteKeyData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteKeyResponse, DeleteKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Keys/{Sid}.json',
  });
};

export const fetchKey = <ThrowOnError extends boolean = false>(options: Options<FetchKeyData, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchKeyResponse, FetchKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Keys/{Sid}.json',
  });
};

export const updateKey = <ThrowOnError extends boolean = false>(options: Options<UpdateKeyData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpdateKeyResponse, UpdateKeyError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Keys/{Sid}.json',
  });
};

/**
 * Retrieve a list of Message resources associated with a Twilio Account
 */
export const listMessage = <ThrowOnError extends boolean = false>(options: Options<ListMessageData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListMessageResponse, ListMessageError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages.json',
  });
};

/**
 * Send a message
 */
export const createMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageResponse, CreateMessageError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Messages.json',
  });
};

/**
 * Create Message Feedback to confirm a tracked user action was performed by the recipient of the associated Message
 */
export const createMessageFeedback = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageFeedbackResponse, CreateMessageFeedbackError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{MessageSid}/Feedback.json',
  });
};

/**
 * Read a list of Media resources associated with a specific Message resource
 */
export const listMedia = <ThrowOnError extends boolean = false>(options: Options<ListMediaData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListMediaResponse, ListMediaError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{MessageSid}/Media.json',
  });
};

/**
 * Delete the Media resource.
 */
export const deleteMedia = <ThrowOnError extends boolean = false>(options: Options<DeleteMediaData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteMediaResponse, DeleteMediaError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{MessageSid}/Media/{Sid}.json',
  });
};

/**
 * Fetch a single Media resource associated with a specific Message resource
 */
export const fetchMedia = <ThrowOnError extends boolean = false>(options: Options<FetchMediaData, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchMediaResponse, FetchMediaError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{MessageSid}/Media/{Sid}.json',
  });
};

/**
 * Deletes a Message resource from your account
 */
export const deleteMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteMessageResponse, DeleteMessageError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{Sid}.json',
  });
};

/**
 * Fetch a specific Message
 */
export const fetchMessage = <ThrowOnError extends boolean = false>(
  options: Options<FetchMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchMessageResponse, FetchMessageError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{Sid}.json',
  });
};

/**
 * Update a Message resource (used to redact Message `body` text and to cancel not-yet-sent messages)
 */
export const updateMessage = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateMessageResponse, UpdateMessageError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Messages/{Sid}.json',
  });
};

/**
 * Retrieve a list of notifications belonging to the account used to make the request
 */
export const listNotification = <ThrowOnError extends boolean = false>(
  options: Options<ListNotificationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListNotificationResponse, ListNotificationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Notifications.json',
  });
};

/**
 * Fetch a notification belonging to the account used to make the request
 */
export const fetchNotification = <ThrowOnError extends boolean = false>(
  options: Options<FetchNotificationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchNotificationResponse, FetchNotificationError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Notifications/{Sid}.json',
  });
};

/**
 * Retrieve a list of outgoing-caller-ids belonging to the account used to make the request
 */
export const listOutgoingCallerId = <ThrowOnError extends boolean = false>(
  options: Options<ListOutgoingCallerIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListOutgoingCallerIdResponse, ListOutgoingCallerIdError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/OutgoingCallerIds.json',
  });
};

export const createValidationRequest = <ThrowOnError extends boolean = false>(
  options: Options<CreateValidationRequestData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateValidationRequestResponse, CreateValidationRequestError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/OutgoingCallerIds.json',
  });
};

/**
 * Delete the caller-id specified from the account
 */
export const deleteOutgoingCallerId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteOutgoingCallerIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteOutgoingCallerIdResponse, DeleteOutgoingCallerIdError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/OutgoingCallerIds/{Sid}.json',
  });
};

/**
 * Fetch an outgoing-caller-id belonging to the account used to make the request
 */
export const fetchOutgoingCallerId = <ThrowOnError extends boolean = false>(
  options: Options<FetchOutgoingCallerIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchOutgoingCallerIdResponse, FetchOutgoingCallerIdError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/OutgoingCallerIds/{Sid}.json',
  });
};

/**
 * Updates the caller-id
 */
export const updateOutgoingCallerId = <ThrowOnError extends boolean = false>(
  options: Options<UpdateOutgoingCallerIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateOutgoingCallerIdResponse, UpdateOutgoingCallerIdError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/OutgoingCallerIds/{Sid}.json',
  });
};

/**
 * Retrieve a list of queues belonging to the account used to make the request
 */
export const listQueue = <ThrowOnError extends boolean = false>(options: Options<ListQueueData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListQueueResponse, ListQueueError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Queues.json',
  });
};

/**
 * Create a queue
 */
export const createQueue = <ThrowOnError extends boolean = false>(options: Options<CreateQueueData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateQueueResponse, CreateQueueError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Queues.json',
  });
};

/**
 * Retrieve the members of the queue
 */
export const listMember = <ThrowOnError extends boolean = false>(options: Options<ListMemberData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListMemberResponse, ListMemberError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{QueueSid}/Members.json',
  });
};

/**
 * Fetch a specific member from the queue
 */
export const fetchMember = <ThrowOnError extends boolean = false>(options: Options<FetchMemberData, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchMemberResponse, FetchMemberError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{QueueSid}/Members/{CallSid}.json',
  });
};

/**
 * Dequeue a member from a queue and have the member's call begin executing the TwiML document at that URL
 */
export const updateMember = <ThrowOnError extends boolean = false>(
  options: Options<UpdateMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateMemberResponse, UpdateMemberError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{QueueSid}/Members/{CallSid}.json',
  });
};

/**
 * Remove an empty queue
 */
export const deleteQueue = <ThrowOnError extends boolean = false>(options: Options<DeleteQueueData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteQueueResponse, DeleteQueueError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{Sid}.json',
  });
};

/**
 * Fetch an instance of a queue identified by the QueueSid
 */
export const fetchQueue = <ThrowOnError extends boolean = false>(options: Options<FetchQueueData, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchQueueResponse, FetchQueueError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{Sid}.json',
  });
};

/**
 * Update the queue with the new parameters
 */
export const updateQueue = <ThrowOnError extends boolean = false>(options: Options<UpdateQueueData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpdateQueueResponse, UpdateQueueError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Queues/{Sid}.json',
  });
};

/**
 * Retrieve a list of recordings belonging to the account used to make the request
 */
export const listRecording = <ThrowOnError extends boolean = false>(
  options: Options<ListRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListRecordingResponse, ListRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings.json',
  });
};

export const listRecordingTranscription = <ThrowOnError extends boolean = false>(
  options: Options<ListRecordingTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListRecordingTranscriptionResponse,
    ListRecordingTranscriptionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{RecordingSid}/Transcriptions.json',
  });
};

export const deleteRecordingTranscription = <ThrowOnError extends boolean = false>(
  options: Options<DeleteRecordingTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteRecordingTranscriptionResponse,
    DeleteRecordingTranscriptionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{RecordingSid}/Transcriptions/{Sid}.json',
  });
};

export const fetchRecordingTranscription = <ThrowOnError extends boolean = false>(
  options: Options<FetchRecordingTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchRecordingTranscriptionResponse,
    FetchRecordingTranscriptionError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{RecordingSid}/Transcriptions/{Sid}.json',
  });
};

/**
 * Retrieve a list of results belonging to the recording
 */
export const listRecordingAddOnResult = <ThrowOnError extends boolean = false>(
  options: Options<ListRecordingAddOnResultData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListRecordingAddOnResultResponse, ListRecordingAddOnResultError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults.json',
    },
  );
};

/**
 * Retrieve a list of payloads belonging to the AddOnResult
 */
export const listRecordingAddOnResultPayload = <ThrowOnError extends boolean = false>(
  options: Options<ListRecordingAddOnResultPayloadData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListRecordingAddOnResultPayloadResponse,
    ListRecordingAddOnResultPayloadError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{AddOnResultSid}/Payloads.json',
  });
};

/**
 * Delete a payload from the result along with all associated Data
 */
export const deleteRecordingAddOnResultPayload = <ThrowOnError extends boolean = false>(
  options: Options<DeleteRecordingAddOnResultPayloadData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteRecordingAddOnResultPayloadResponse,
    DeleteRecordingAddOnResultPayloadError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{AddOnResultSid}/Payloads/{Sid}.json',
  });
};

/**
 * Fetch an instance of a result payload
 */
export const fetchRecordingAddOnResultPayload = <ThrowOnError extends boolean = false>(
  options: Options<FetchRecordingAddOnResultPayloadData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchRecordingAddOnResultPayloadResponse,
    FetchRecordingAddOnResultPayloadError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{AddOnResultSid}/Payloads/{Sid}.json',
  });
};

/**
 * Delete a result and purge all associated Payloads
 */
export const deleteRecordingAddOnResult = <ThrowOnError extends boolean = false>(
  options: Options<DeleteRecordingAddOnResultData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteRecordingAddOnResultResponse,
    DeleteRecordingAddOnResultError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{Sid}.json',
  });
};

/**
 * Fetch an instance of an AddOnResult
 */
export const fetchRecordingAddOnResult = <ThrowOnError extends boolean = false>(
  options: Options<FetchRecordingAddOnResultData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchRecordingAddOnResultResponse,
    FetchRecordingAddOnResultError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{Sid}.json',
  });
};

/**
 * Delete a recording from your account
 */
export const deleteRecording = <ThrowOnError extends boolean = false>(
  options: Options<DeleteRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteRecordingResponse, DeleteRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{Sid}.json',
  });
};

/**
 * Fetch an instance of a recording
 */
export const fetchRecording = <ThrowOnError extends boolean = false>(
  options: Options<FetchRecordingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchRecordingResponse, FetchRecordingError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Recordings/{Sid}.json',
  });
};

/**
 * Get All Credential Lists
 */
export const listSipCredentialList = <ThrowOnError extends boolean = false>(
  options: Options<ListSipCredentialListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipCredentialListResponse, ListSipCredentialListError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists.json',
  });
};

/**
 * Create a Credential List
 */
export const createSipCredentialList = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipCredentialListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSipCredentialListResponse, CreateSipCredentialListError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists.json',
  });
};

/**
 * Retrieve a list of credentials.
 */
export const listSipCredential = <ThrowOnError extends boolean = false>(
  options: Options<ListSipCredentialData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipCredentialResponse, ListSipCredentialError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials.json',
  });
};

/**
 * Create a new credential resource.
 */
export const createSipCredential = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipCredentialData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSipCredentialResponse, CreateSipCredentialError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials.json',
  });
};

/**
 * Delete a credential resource.
 */
export const deleteSipCredential = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipCredentialData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSipCredentialResponse, DeleteSipCredentialError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials/{Sid}.json',
  });
};

/**
 * Fetch a single credential.
 */
export const fetchSipCredential = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipCredentialData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchSipCredentialResponse, FetchSipCredentialError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials/{Sid}.json',
  });
};

/**
 * Update a credential resource.
 */
export const updateSipCredential = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipCredentialData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSipCredentialResponse, UpdateSipCredentialError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials/{Sid}.json',
  });
};

/**
 * Delete a Credential List
 */
export const deleteSipCredentialList = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipCredentialListData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipCredentialListResponse,
    DeleteSipCredentialListError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{Sid}.json',
  });
};

/**
 * Get a Credential List
 */
export const fetchSipCredentialList = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipCredentialListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchSipCredentialListResponse, FetchSipCredentialListError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{Sid}.json',
  });
};

/**
 * Update a Credential List
 */
export const updateSipCredentialList = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipCredentialListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSipCredentialListResponse, UpdateSipCredentialListError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{Sid}.json',
  });
};

/**
 * Retrieve a list of domains belonging to the account used to make the request
 */
export const listSipDomain = <ThrowOnError extends boolean = false>(
  options: Options<ListSipDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipDomainResponse, ListSipDomainError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains.json',
  });
};

/**
 * Create a new Domain
 */
export const createSipDomain = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSipDomainResponse, CreateSipDomainError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains.json',
  });
};

/**
 * Retrieve a list of credential list mappings belonging to the domain used in the request
 */
export const listSipAuthCallsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<ListSipAuthCallsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipAuthCallsCredentialListMappingResponse,
    ListSipAuthCallsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/CredentialListMappings.json',
  });
};

/**
 * Create a new credential list mapping resource
 */
export const createSipAuthCallsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipAuthCallsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipAuthCallsCredentialListMappingResponse,
    CreateSipAuthCallsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/CredentialListMappings.json',
  });
};

/**
 * Delete a credential list mapping from the requested domain
 */
export const deleteSipAuthCallsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipAuthCallsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipAuthCallsCredentialListMappingResponse,
    DeleteSipAuthCallsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Fetch a specific instance of a credential list mapping
 */
export const fetchSipAuthCallsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipAuthCallsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipAuthCallsCredentialListMappingResponse,
    FetchSipAuthCallsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Retrieve a list of IP Access Control List mappings belonging to the domain used in the request
 */
export const listSipAuthCallsIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<ListSipAuthCallsIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipAuthCallsIpAccessControlListMappingResponse,
    ListSipAuthCallsIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/IpAccessControlListMappings.json',
  });
};

/**
 * Create a new IP Access Control List mapping
 */
export const createSipAuthCallsIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipAuthCallsIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipAuthCallsIpAccessControlListMappingResponse,
    CreateSipAuthCallsIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/IpAccessControlListMappings.json',
  });
};

/**
 * Delete an IP Access Control List mapping from the requested domain
 */
export const deleteSipAuthCallsIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipAuthCallsIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipAuthCallsIpAccessControlListMappingResponse,
    DeleteSipAuthCallsIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/IpAccessControlListMappings/{Sid}.json',
  });
};

/**
 * Fetch a specific instance of an IP Access Control List mapping
 */
export const fetchSipAuthCallsIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipAuthCallsIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipAuthCallsIpAccessControlListMappingResponse,
    FetchSipAuthCallsIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Calls/IpAccessControlListMappings/{Sid}.json',
  });
};

/**
 * Retrieve a list of credential list mappings belonging to the domain used in the request
 */
export const listSipAuthRegistrationsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<ListSipAuthRegistrationsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipAuthRegistrationsCredentialListMappingResponse,
    ListSipAuthRegistrationsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Registrations/CredentialListMappings.json',
  });
};

/**
 * Create a new credential list mapping resource
 */
export const createSipAuthRegistrationsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipAuthRegistrationsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipAuthRegistrationsCredentialListMappingResponse,
    CreateSipAuthRegistrationsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Registrations/CredentialListMappings.json',
  });
};

/**
 * Delete a credential list mapping from the requested domain
 */
export const deleteSipAuthRegistrationsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipAuthRegistrationsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipAuthRegistrationsCredentialListMappingResponse,
    DeleteSipAuthRegistrationsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Registrations/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Fetch a specific instance of a credential list mapping
 */
export const fetchSipAuthRegistrationsCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipAuthRegistrationsCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipAuthRegistrationsCredentialListMappingResponse,
    FetchSipAuthRegistrationsCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/Auth/Registrations/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Read multiple CredentialListMapping resources from an account.
 */
export const listSipCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<ListSipCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipCredentialListMappingResponse,
    ListSipCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings.json',
  });
};

/**
 * Create a CredentialListMapping resource for an account.
 */
export const createSipCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipCredentialListMappingResponse,
    CreateSipCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings.json',
  });
};

/**
 * Delete a CredentialListMapping resource from an account.
 */
export const deleteSipCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipCredentialListMappingResponse,
    DeleteSipCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Fetch a single CredentialListMapping resource from an account.
 */
export const fetchSipCredentialListMapping = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipCredentialListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipCredentialListMappingResponse,
    FetchSipCredentialListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings/{Sid}.json',
  });
};

/**
 * Retrieve a list of IpAccessControlListMapping resources.
 */
export const listSipIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<ListSipIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipIpAccessControlListMappingResponse,
    ListSipIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/IpAccessControlListMappings.json',
  });
};

/**
 * Create a new IpAccessControlListMapping resource.
 */
export const createSipIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipIpAccessControlListMappingResponse,
    CreateSipIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/IpAccessControlListMappings.json',
  });
};

/**
 * Delete an IpAccessControlListMapping resource.
 */
export const deleteSipIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipIpAccessControlListMappingResponse,
    DeleteSipIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/IpAccessControlListMappings/{Sid}.json',
  });
};

/**
 * Fetch an IpAccessControlListMapping resource.
 */
export const fetchSipIpAccessControlListMapping = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipIpAccessControlListMappingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipIpAccessControlListMappingResponse,
    FetchSipIpAccessControlListMappingError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/IpAccessControlListMappings/{Sid}.json',
  });
};

/**
 * Delete an instance of a Domain
 */
export const deleteSipDomain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSipDomainResponse, DeleteSipDomainError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{Sid}.json',
  });
};

/**
 * Fetch an instance of a Domain
 */
export const fetchSipDomain = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchSipDomainResponse, FetchSipDomainError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{Sid}.json',
  });
};

/**
 * Update the attributes of a domain
 */
export const updateSipDomain = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSipDomainResponse, UpdateSipDomainError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{Sid}.json',
  });
};

/**
 * Retrieve a list of IpAccessControlLists that belong to the account used to make the request
 */
export const listSipIpAccessControlList = <ThrowOnError extends boolean = false>(
  options: Options<ListSipIpAccessControlListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSipIpAccessControlListResponse,
    ListSipIpAccessControlListError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists.json',
  });
};

/**
 * Create a new IpAccessControlList resource
 */
export const createSipIpAccessControlList = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipIpAccessControlListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateSipIpAccessControlListResponse,
    CreateSipIpAccessControlListError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists.json',
  });
};

/**
 * Read multiple IpAddress resources.
 */
export const listSipIpAddress = <ThrowOnError extends boolean = false>(
  options: Options<ListSipIpAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSipIpAddressResponse, ListSipIpAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses.json',
  });
};

/**
 * Create a new IpAddress resource.
 */
export const createSipIpAddress = <ThrowOnError extends boolean = false>(
  options: Options<CreateSipIpAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSipIpAddressResponse, CreateSipIpAddressError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses.json',
  });
};

/**
 * Delete an IpAddress resource.
 */
export const deleteSipIpAddress = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipIpAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSipIpAddressResponse, DeleteSipIpAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses/{Sid}.json',
  });
};

/**
 * Read one IpAddress resource.
 */
export const fetchSipIpAddress = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipIpAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchSipIpAddressResponse, FetchSipIpAddressError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses/{Sid}.json',
  });
};

/**
 * Update an IpAddress resource.
 */
export const updateSipIpAddress = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipIpAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSipIpAddressResponse, UpdateSipIpAddressError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses/{Sid}.json',
  });
};

/**
 * Delete an IpAccessControlList from the requested account
 */
export const deleteSipIpAccessControlList = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSipIpAccessControlListData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteSipIpAccessControlListResponse,
    DeleteSipIpAccessControlListError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{Sid}.json',
  });
};

/**
 * Fetch a specific instance of an IpAccessControlList
 */
export const fetchSipIpAccessControlList = <ThrowOnError extends boolean = false>(
  options: Options<FetchSipIpAccessControlListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FetchSipIpAccessControlListResponse,
    FetchSipIpAccessControlListError,
    ThrowOnError
  >({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{Sid}.json',
  });
};

/**
 * Rename an IpAccessControlList
 */
export const updateSipIpAccessControlList = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSipIpAccessControlListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    UpdateSipIpAccessControlListResponse,
    UpdateSipIpAccessControlListError,
    ThrowOnError
  >({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{Sid}.json',
  });
};

/**
 * Retrieve a list of short-codes belonging to the account used to make the request
 */
export const listShortCode = <ThrowOnError extends boolean = false>(
  options: Options<ListShortCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListShortCodeResponse, ListShortCodeError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SMS/ShortCodes.json',
  });
};

/**
 * Fetch an instance of a short code
 */
export const fetchShortCode = <ThrowOnError extends boolean = false>(
  options: Options<FetchShortCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchShortCodeResponse, FetchShortCodeError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SMS/ShortCodes/{Sid}.json',
  });
};

/**
 * Update a short code with the following parameters
 */
export const updateShortCode = <ThrowOnError extends boolean = false>(
  options: Options<UpdateShortCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateShortCodeResponse, UpdateShortCodeError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SMS/ShortCodes/{Sid}.json',
  });
};

export const listSigningKey = <ThrowOnError extends boolean = false>(
  options: Options<ListSigningKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSigningKeyResponse, ListSigningKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SigningKeys.json',
  });
};

/**
 * Create a new Signing Key for the account making the request.
 */
export const createNewSigningKey = <ThrowOnError extends boolean = false>(
  options: Options<CreateNewSigningKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateNewSigningKeyResponse, CreateNewSigningKeyError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SigningKeys.json',
  });
};

export const deleteSigningKey = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSigningKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSigningKeyResponse, DeleteSigningKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SigningKeys/{Sid}.json',
  });
};

export const fetchSigningKey = <ThrowOnError extends boolean = false>(
  options: Options<FetchSigningKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchSigningKeyResponse, FetchSigningKeyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/SigningKeys/{Sid}.json',
  });
};

export const updateSigningKey = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSigningKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateSigningKeyResponse, UpdateSigningKeyError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/SigningKeys/{Sid}.json',
  });
};

/**
 * Create a new token for ICE servers
 */
export const createToken = <ThrowOnError extends boolean = false>(options: Options<CreateTokenData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTokenResponse, CreateTokenError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Tokens.json',
  });
};

/**
 * Retrieve a list of transcriptions belonging to the account used to make the request
 */
export const listTranscription = <ThrowOnError extends boolean = false>(
  options: Options<ListTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListTranscriptionResponse, ListTranscriptionError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Transcriptions.json',
  });
};

/**
 * Delete a transcription from the account used to make the request
 */
export const deleteTranscription = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTranscriptionResponse, DeleteTranscriptionError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Transcriptions/{Sid}.json',
  });
};

/**
 * Fetch an instance of a Transcription
 */
export const fetchTranscription = <ThrowOnError extends boolean = false>(
  options: Options<FetchTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchTranscriptionResponse, FetchTranscriptionError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Transcriptions/{Sid}.json',
  });
};

/**
 * Retrieve a list of usage-records belonging to the account used to make the request
 */
export const listUsageRecord = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordResponse, ListUsageRecordError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records.json',
  });
};

export const listUsageRecordAllTime = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordAllTimeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordAllTimeResponse, ListUsageRecordAllTimeError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/AllTime.json',
  });
};

export const listUsageRecordDaily = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordDailyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordDailyResponse, ListUsageRecordDailyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/Daily.json',
  });
};

export const listUsageRecordLastMonth = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordLastMonthData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordLastMonthResponse, ListUsageRecordLastMonthError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/LastMonth.json',
    },
  );
};

export const listUsageRecordMonthly = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordMonthlyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordMonthlyResponse, ListUsageRecordMonthlyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/Monthly.json',
  });
};

export const listUsageRecordThisMonth = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordThisMonthData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordThisMonthResponse, ListUsageRecordThisMonthError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/ThisMonth.json',
    },
  );
};

export const listUsageRecordToday = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordTodayData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordTodayResponse, ListUsageRecordTodayError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/Today.json',
  });
};

export const listUsageRecordYearly = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordYearlyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordYearlyResponse, ListUsageRecordYearlyError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/Yearly.json',
  });
};

export const listUsageRecordYesterday = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageRecordYesterdayData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageRecordYesterdayResponse, ListUsageRecordYesterdayError, ThrowOnError>(
    {
      ...options,
      url: '/2010-04-01/Accounts/{AccountSid}/Usage/Records/Yesterday.json',
    },
  );
};

/**
 * Retrieve a list of usage-triggers belonging to the account used to make the request
 */
export const listUsageTrigger = <ThrowOnError extends boolean = false>(
  options: Options<ListUsageTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListUsageTriggerResponse, ListUsageTriggerError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Triggers.json',
  });
};

/**
 * Create a new UsageTrigger
 */
export const createUsageTrigger = <ThrowOnError extends boolean = false>(
  options: Options<CreateUsageTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateUsageTriggerResponse, CreateUsageTriggerError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Triggers.json',
  });
};

export const deleteUsageTrigger = <ThrowOnError extends boolean = false>(
  options: Options<DeleteUsageTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteUsageTriggerResponse, DeleteUsageTriggerError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Triggers/{Sid}.json',
  });
};

/**
 * Fetch and instance of a usage-trigger
 */
export const fetchUsageTrigger = <ThrowOnError extends boolean = false>(
  options: Options<FetchUsageTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchUsageTriggerResponse, FetchUsageTriggerError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Triggers/{Sid}.json',
  });
};

/**
 * Update an instance of a usage trigger
 */
export const updateUsageTrigger = <ThrowOnError extends boolean = false>(
  options: Options<UpdateUsageTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateUsageTriggerResponse, UpdateUsageTriggerError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{AccountSid}/Usage/Triggers/{Sid}.json',
  });
};

/**
 * Fetch the account specified by the provided Account Sid
 */
export const fetchAccount = <ThrowOnError extends boolean = false>(
  options: Options<FetchAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FetchAccountResponse, FetchAccountError, ThrowOnError>({
    ...options,
    url: '/2010-04-01/Accounts/{Sid}.json',
  });
};

/**
 * Modify the properties of a given Account
 */
export const updateAccount = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UpdateAccountResponse, UpdateAccountError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/2010-04-01/Accounts/{Sid}.json',
  });
};

/**
 * API HealthCheck
 */
export const fetchHealthCheck = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<FetchHealthCheckResponse, FetchHealthCheckError, ThrowOnError>({
    ...options,
    url: '/healthcheck',
  });
};
