// This file is auto-generated by @hey-api/openapi-ts

export const account_enum_statusSchema = {
  enum: ['active', 'suspended', 'closed'],
  type: 'string',
} as const;

export const account_enum_typeSchema = {
  enum: ['Trial', 'Full'],
  type: 'string',
} as const;

export const api_v2010_accountSchema = {
  properties: {
    auth_token: {
      description: 'The authorization token for this account. This token should be kept a secret, so no sharing.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'sensitive',
        },
      },
    },
    date_created: {
      description: 'The date that this account was created, in GMT in RFC 2822 format',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description: 'The date that this account was last updated, in GMT in RFC 2822 format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description:
        'A human readable description of this account, up to 64 characters long. By default the FriendlyName is your email address.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    owner_account_sid: {
      description:
        "The unique 34 character id that represents the parent of this account. The OwnerAccountSid of a parent account is it's own sid.",
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/account_enum_status',
      description: 'The status of this account. Usually `active`, but can be `suspended` or `closed`.',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description: 'A Map of various subresources available for the given Account Instance',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    type: {
      $ref: '#/components/schemas/account_enum_type',
      description: "The type of this account. Either `Trial` or `Full` if it's been upgraded",
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_addressSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that is responsible for the Address resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    city: {
      description: 'The city in which the address is located.',
      nullable: true,
      type: 'string',
    },
    customer_name: {
      description:
        'The name associated with the address.This property has a maximum length of 16 4-byte characters, or 21 3-byte characters.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_enabled: {
      description: 'Whether emergency calling has been enabled on this number.',
      nullable: true,
      type: 'boolean',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    iso_country: {
      description: 'The ISO country code of the address.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description: 'The postal code of the address.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    region: {
      description: 'The state or region of the address.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Address resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    street: {
      description: 'The number and street address of the address.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    street_secondary: {
      description: 'The additional number and street address of the address.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    validated: {
      description:
        "Whether the address has been validated to comply with local regulation. In countries that require valid addresses, an invalid address will not be accepted. `true` indicates the Address has been validated. `false` indicate the country doesn't require validation or the Address is not valid.",
      nullable: true,
      type: 'boolean',
    },
    verified: {
      description:
        "Whether the address has been verified to comply with regulation. In countries that require valid addresses, an invalid address will not be accepted. `true` indicates the Address has been verified. `false` indicate the country doesn't require verified or the Address is not valid.",
      nullable: true,
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_address_dependent_phone_numberSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the DependentPhoneNumber resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    address_requirements: {
      $ref: '#/components/schemas/dependent_phone_number_enum_address_requirement',
      description:
        'Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.',
      nullable: true,
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicates whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      nullable: true,
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_address_sid: {
      description:
        'The SID of the emergency address configuration that we use for emergency calling from the phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_status: {
      $ref: '#/components/schemas/dependent_phone_number_enum_emergency_status',
      description: 'Whether the phone number is enabled for emergency calling.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the DependentPhoneNumber resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_application_sid: {
      description:
        'The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    trunk_sid: {
      description:
        'The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_application_sid: {
      description:
        'The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database. Can be: `true` or `false`. Caller ID lookups can cost $0.01 each.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description:
        'The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_applicationSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Application resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
    },
    message_status_callback: {
      description: 'The URL we call using a POST method to send message status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    public_application_connect_enabled: {
      description:
        'Whether to allow other Twilio accounts to dial this applicaton using Dial verb. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    sid: {
      description: 'The unique string that that we created to identify the Application resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_status_callback: {
      description:
        'The URL we call using a POST method to send status information to your application about SMS messages that refer to the application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database (additional charges apply). Can be: `true` or `false`.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description: 'The URL we call when the phone number assigned to this application receives a call.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_authorized_connect_appSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the AuthorizedConnectApp resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    connect_app_company_name: {
      description: 'The company name set for the Connect App.',
      nullable: true,
      type: 'string',
    },
    connect_app_description: {
      description: 'A detailed description of the Connect App.',
      nullable: true,
      type: 'string',
    },
    connect_app_friendly_name: {
      description: 'The name of the Connect App.',
      nullable: true,
      type: 'string',
    },
    connect_app_homepage_url: {
      description: 'The public URL for the Connect App.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    connect_app_sid: {
      description: 'The SID that we assigned to the Connect App.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    permissions: {
      description: 'The set of permissions that you authorized for the Connect App.  Can be: `get-all` or `post-all`.',
      items: {
        $ref: '#/components/schemas/authorized_connect_app_enum_permission',
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_countrySchema = {
  properties: {
    beta: {
      description:
        'Whether all phone numbers available in the country are new to the Twilio platform. `true` if they are and `false` if all numbers are not in the Twilio Phone Number Beta program.',
      nullable: true,
      type: 'boolean',
    },
    country: {
      description: 'The name of the country.',
      nullable: true,
      type: 'string',
    },
    country_code: {
      description: 'The [ISO-3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the country.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related AvailablePhoneNumber resources identified by their URIs relative to `https://api.twilio.com`.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the Country resource, relative to `https://api.twilio.com`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_localSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_machine_to_machineSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_mobileSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_nationalSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_shared_costSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_toll_freeSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_available_phone_number_country_available_phone_number_voipSchema = {
  properties: {
    address_requirements: {
      description:
        "The type of [Address](https://www.twilio.com/docs/usage/api/address) resource the phone number requires. Can be: `none`, `any`, `local`, or `foreign`. `none` means no address is required. `any` means an address is required, but it can be anywhere in the world. `local` means an address in the phone number's country is required. `foreign` means an address outside of the phone number's country is required.",
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are: `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    friendly_name: {
      description: 'A formatted version of the phone number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    iso_country: {
      description: 'The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of this phone number.',
      format: 'iso-country-code',
      nullable: true,
      type: 'string',
    },
    lata: {
      description:
        'The [LATA](https://en.wikipedia.org/wiki/Local_access_and_transport_area) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    latitude: {
      description:
        "The latitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    locality: {
      description: "The locality or city of this phone number's location.",
      nullable: true,
      type: 'string',
    },
    longitude: {
      description:
        "The longitude of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'number',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description:
        "The postal or ZIP code of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
    rate_center: {
      description:
        'The [rate center](https://en.wikipedia.org/wiki/Telephone_exchange) of this phone number. Available for only phone numbers from the US and Canada.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        "The two-letter state or province abbreviation of this phone number's location. Available for only phone numbers from the US and Canada.",
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_balanceSchema = {
  properties: {
    account_sid: {
      description: 'The unique SID identifier of the Account.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    balance: {
      description:
        'The balance of the Account, in units specified by the unit parameter. Balance changes may not be reflected immediately. Child accounts do not contain balance information',
      nullable: true,
      type: 'string',
    },
    currency: {
      description: 'The units of currency for the account balance',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_callSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Call resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    answered_by: {
      description:
        'Either `human` or `machine` if this call was initiated with answering machine detection. Empty otherwise.',
      nullable: true,
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the call.',
      nullable: true,
      type: 'string',
    },
    caller_name: {
      description:
        "The caller's name if this call was an incoming call to a phone number with caller ID Lookup enabled. Otherwise, empty.",
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    date_created: {
      description:
        'The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    direction: {
      description:
        'A string describing the direction of the call. Can be: `inbound` for inbound calls, `outbound-api` for calls initiated via the REST API or `outbound-dial` for calls initiated by a `<Dial>` verb. Using [Elastic SIP Trunking](https://www.twilio.com/docs/sip-trunking), the values can be [`trunking-terminating`](https://www.twilio.com/docs/sip-trunking#termination) for outgoing calls from your communications infrastructure to the PSTN or [`trunking-originating`](https://www.twilio.com/docs/sip-trunking#origination) for incoming calls to your communications infrastructure from the PSTN.',
      nullable: true,
      type: 'string',
    },
    duration: {
      description:
        'The length of the call in seconds. This value is empty for busy, failed, unanswered, or ongoing calls.',
      nullable: true,
      type: 'string',
    },
    end_time: {
      description:
        'The time the call ended, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format. Empty if the call did not complete successfully.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    forwarded_from: {
      description:
        'The forwarding phone number if this call was an incoming call forwarded from another number (depends on carrier supporting forwarding). Otherwise, empty.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    from: {
      description:
        'The phone number, SIP address, Client identifier or SIM SID that made this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). SIP addresses are formatted as `name@company.com`. Client identifiers are formatted `client:name`. SIM SIDs are formatted as `sim:sid`.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    from_formatted: {
      description:
        'The calling phone number, SIP address, or Client identifier formatted for display. Non-North American phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +442071838750).',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    group_sid: {
      description:
        'The Group SID associated with this call. If no Group is associated with the call, the field is empty.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^GP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    parent_call_sid: {
      description: 'The SID that identifies the call that created this leg.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    phone_number_sid: {
      description:
        'If the call was inbound, this is the SID of the IncomingPhoneNumber resource that received the call. If the call was outbound, it is the SID of the OutgoingCallerId resource from which the call was placed.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    price: {
      description:
        'The charge for this call, in the currency associated with the account. Populated after the call is completed. May not be immediately available.',
      nullable: true,
      type: 'string',
    },
    price_unit: {
      description:
        'The currency in which `Price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g., `USD`, `EUR`, `JPY`). Always capitalized for calls.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    queue_time: {
      description: 'The wait time in milliseconds before the call is placed.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that we created to identify this Call resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    start_time: {
      description:
        'The start time of the call, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format. Empty if the call has not yet been dialed.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/call_enum_status',
      description:
        'The status of this call. Can be: `queued`, `ringing`, `in-progress`, `canceled`, `completed`, `failed`, `busy` or `no-answer`. See [Call Status Values](https://www.twilio.com/docs/voice/api/call-resource#call-status-values) below for more information.',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of subresources available to this call, identified by their URIs relative to `https://api.twilio.com`.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    to: {
      description:
        'The phone number, SIP address, Client identifier or SIM SID that received this call. Phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +16175551212). SIP addresses are formatted as `name@company.com`. Client identifiers are formatted `client:name`. SIM SIDs are formatted as `sim:sid`.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    to_formatted: {
      description:
        'The phone number, SIP address or Client identifier that received this call. Formatted for display. Non-North American phone numbers are in [E.164](https://www.twilio.com/docs/glossary/what-e164) format (e.g., +442071838750).',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    trunk_sid: {
      description:
        'The unique identifier of the trunk resource that was used for this call. The field is empty if the call was not made using a SIP trunk or if the call is not terminated.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of this resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_call_eventSchema = {
  properties: {
    request: {
      description: 'Contains a dictionary representing the request of the call.',
      nullable: true,
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'sensitive',
        },
      },
    },
    response: {
      description: 'Contains a dictionary representing the call response, including a list of the call events.',
      nullable: true,
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'sensitive',
        },
      },
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_call_notificationSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the Call Notification resource.',
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Call Notification resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    error_code: {
      description:
        'A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      nullable: true,
      type: 'string',
    },
    log: {
      description: 'An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.',
      nullable: true,
      type: 'string',
    },
    message_date: {
      description:
        'The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    message_text: {
      description: 'The text of the notification.',
      nullable: true,
      type: 'string',
    },
    more_info: {
      description:
        'The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_method: {
      description:
        'The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    request_url: {
      description:
        'The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Call Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^NO[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_call_notification_instanceSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Call Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the Call Notification resource.',
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Call Notification resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    error_code: {
      description:
        'A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      nullable: true,
      type: 'string',
    },
    log: {
      description: 'An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.',
      nullable: true,
      type: 'string',
    },
    message_date: {
      description:
        'The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    message_text: {
      description: 'The text of the notification.',
      nullable: true,
      type: 'string',
    },
    more_info: {
      description:
        'The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_method: {
      description:
        'The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    request_url: {
      description:
        'The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_variables: {
      description:
        'The HTTP GET or POST variables we sent to your server. However, if the notification was generated by our REST API, this contains the HTTP POST or PUT variables you sent to our API.',
      nullable: true,
      type: 'string',
    },
    response_body: {
      description: 'The HTTP body returned by your server.',
      nullable: true,
      type: 'string',
    },
    response_headers: {
      description: 'The HTTP headers returned by your server.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Call Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^NO[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_call_recordingSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to make the recording.',
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Recording resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    channels: {
      description:
        'The number of channels in the final recording file.  Can be: `1`, or `2`. Separating a two leg call into two separate channels of the recording file is supported in [Dial](https://www.twilio.com/docs/voice/twiml/dial#attributes-record) and [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls) record options.',
      nullable: true,
      type: 'integer',
    },
    conference_sid: {
      description:
        'The Conference SID that identifies the conference associated with the recording, if a conference recording.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CF[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    duration: {
      description: 'The length of the recording in seconds.',
      nullable: true,
      type: 'string',
    },
    encryption_details: {
      description:
        'How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.',
      nullable: true,
    },
    error_code: {
      description:
        'The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.',
      nullable: true,
      type: 'integer',
    },
    price: {
      description: 'The one-time cost of creating the recording in the `price_unit` currency.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description: 'The currency used in the `price` property. Example: `USD`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    source: {
      $ref: '#/components/schemas/call_recording_enum_source',
      description:
        'How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, and `StartConferenceRecordingAPI`.',
      nullable: true,
      type: 'string',
    },
    start_time: {
      description:
        'The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/call_recording_enum_status',
      description:
        'The status of the recording. Can be: `processing`, `completed` and `absent`. For more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).',
      nullable: true,
      type: 'string',
    },
    track: {
      description: 'The recorded track. Can be: `inbound`, `outbound`, or `both`.',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_paymentsSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Payments resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Payments resource is associated with. This will refer to the call sid that is producing the payment card (credit/ACH) information thru DTMF.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The SID of the Payments resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_siprecSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Siprec resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Siprec resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        'The user-specified name of this Siprec, if one was given when the Siprec was created. This may be used to stop the Siprec.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The SID of the Siprec resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/siprec_enum_status',
      description: 'The status - one of `stopped`, `in-progress`',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_streamSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Stream resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Stream resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        'The user-specified name of this Stream, if one was given when the Stream was created. This may be used to stop the Stream.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The SID of the Stream resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^MZ[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/stream_enum_status',
      description: 'The status - one of `stopped`, `in-progress`',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_user_defined_messageSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created User Defined Message.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description: 'The date that this User Defined Message was created, given in RFC 2822 format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The SID that uniquely identifies this User Defined Message.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^KX[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_call_user_defined_message_subscriptionSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that subscribed to the User Defined Messages.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message Subscription is associated with. This refers to the Call SID that is producing the User Defined Messages.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description: 'The date that this User Defined Message Subscription was created, given in RFC 2822 format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The SID that uniquely identifies this User Defined Message Subscription.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^ZY[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the User Defined Message Subscription Resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_conferenceSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Conference resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create this conference.',
      nullable: true,
      type: 'string',
    },
    call_sid_ending_conference: {
      description: 'The call SID that caused the conference to end.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'A string that you assigned to describe this conference room. Maxiumum length is 128 characters.',
      nullable: true,
      type: 'string',
    },
    reason_conference_ended: {
      $ref: '#/components/schemas/conference_enum_reason_conference_ended',
      description:
        'The reason why a conference ended. When a conference is in progress, will be `null`. When conference is completed, can be: `conference-ended-via-api`, `participant-with-end-conference-on-exit-left`, `participant-with-end-conference-on-exit-kicked`, `last-participant-kicked`, or `last-participant-left`.',
      nullable: true,
      type: 'string',
    },
    region: {
      description:
        'A string that represents the Twilio Region where the conference audio was mixed. May be `us1`, `ie1`,  `de1`, `sg1`, `br1`, `au1`, and `jp1`. Basic conference audio will always be mixed in `us1`. Global Conference audio will be mixed nearest to the majority of participants.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify this Conference resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CF[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/conference_enum_status',
      description: 'The status of this conference. Can be: `init`, `in-progress`, or `completed`.',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their URIs relative to `https://api.twilio.com`.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of this resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_conference_conference_recordingSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Conference Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the recording.',
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Conference Recording resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    channels: {
      description:
        'The number of channels in the final recording file.  Can be: `1`, or `2`. Separating a two leg call into two separate channels of the recording file is supported in [Dial](https://www.twilio.com/docs/voice/twiml/dial#attributes-record) and [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls) record options.',
      nullable: true,
      type: 'integer',
    },
    conference_sid: {
      description: 'The Conference SID that identifies the conference associated with the recording.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CF[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    duration: {
      description: 'The length of the recording in seconds.',
      nullable: true,
      type: 'string',
    },
    encryption_details: {
      description:
        'How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.',
      nullable: true,
    },
    error_code: {
      description:
        'The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.',
      nullable: true,
      type: 'integer',
    },
    price: {
      description: 'The one-time cost of creating the recording in the `price_unit` currency.',
      nullable: true,
      type: 'string',
    },
    price_unit: {
      description: 'The currency used in the `price` property. Example: `USD`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Conference Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    source: {
      $ref: '#/components/schemas/conference_recording_enum_source',
      description:
        'How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, `StartConferenceRecordingAPI`.',
      nullable: true,
      type: 'string',
    },
    start_time: {
      description:
        'The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/conference_recording_enum_status',
      description:
        'The status of the recording. Can be: `processing`, `completed` and `absent`. For more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_conference_participantSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Participant resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Participant resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid_to_coach: {
      description:
        'The SID of the participant who is being `coached`. The participant being coached is the only participant who can hear the participant who is `coaching`.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    coaching: {
      description:
        'Whether the participant is coaching another call. Can be: `true` or `false`. If not present, defaults to `false` unless `call_sid_to_coach` is defined. If `true`, `call_sid_to_coach` must be defined.',
      nullable: true,
      type: 'boolean',
    },
    conference_sid: {
      description: 'The SID of the conference the participant is in.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CF[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    end_conference_on_exit: {
      description:
        'Whether the conference ends when the participant leaves. Can be: `true` or `false` and the default is `false`. If `true`, the conference ends and all other participants drop out when the participant leaves.',
      nullable: true,
      type: 'boolean',
    },
    hold: {
      description: 'Whether the participant is on hold. Can be `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    label: {
      description:
        'The user-specified label of this participant, if one was given when the participant was created. This may be used to fetch, update or delete the participant.',
      nullable: true,
      type: 'string',
    },
    muted: {
      description: 'Whether the participant is muted. Can be `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    start_conference_on_enter: {
      description:
        'Whether the conference starts when the participant joins the conference, if it has not already started. Can be: `true` or `false` and the default is `true`. If `false` and the conference has not started, the participant is muted and hears background music until another participant starts the conference.',
      nullable: true,
      type: 'boolean',
    },
    status: {
      $ref: '#/components/schemas/participant_enum_status',
      description:
        "The status of the participant's call in a session. Can be: `queued`, `connecting`, `ringing`, `connected`, `complete`, or `failed`.",
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_connect_appSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the ConnectApp resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    authorize_redirect_url: {
      description:
        'The URL we redirect the user to after we authenticate the user and obtain authorization to access the Connect App.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    company_name: {
      description: 'The company name set for the Connect App.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    deauthorize_callback_method: {
      description: 'The HTTP method we use to call `deauthorize_callback_url`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    deauthorize_callback_url: {
      description: 'The URL we call using the `deauthorize_callback_method` to de-authorize the Connect App.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    description: {
      description: 'The description of the Connect App.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    homepage_url: {
      description: 'The public URL where users can obtain more information about this Connect App.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    permissions: {
      description: 'The set of permissions that your ConnectApp requests.',
      items: {
        $ref: '#/components/schemas/connect_app_enum_permission',
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    sid: {
      description: 'The unique string that that we created to identify the ConnectApp resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_incoming_phone_numberSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this IncomingPhoneNumber resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    address_requirements: {
      $ref: '#/components/schemas/incoming_phone_number_enum_address_requirement',
      description:
        'Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.',
      nullable: true,
      type: 'string',
    },
    address_sid: {
      description: 'The SID of the Address resource associated with the phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    bundle_sid: {
      description:
        'The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^BU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_address_sid: {
      description:
        'The SID of the emergency address configuration that we use for emergency calling from this phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_address_status: {
      $ref: '#/components/schemas/incoming_phone_number_enum_emergency_address_status',
      description:
        'The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.',
      nullable: true,
      type: 'string',
    },
    emergency_status: {
      $ref: '#/components/schemas/incoming_phone_number_enum_emergency_status',
      description:
        'The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    identity_sid: {
      description:
        'The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RI[0-9a-fA-F]{32}$',
      type: 'string',
    },
    origin: {
      description:
        "The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.",
      nullable: true,
      type: 'string',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify this IncomingPhoneNumber resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_application_sid: {
      description:
        'The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status: {
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    trunk_sid: {
      description:
        'The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_application_sid: {
      description:
        'The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_receive_mode: {
      $ref: '#/components/schemas/incoming_phone_number_enum_voice_receive_mode',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description:
        'The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_onSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    configuration: {
      description: 'A JSON string that represents the current configuration of this Add-on installation.',
      nullable: true,
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A short description of the functionality that the Add-on provides.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    resource_sid: {
      description: 'The SID of the Phone Number to which the Add-on is assigned.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their relative URIs.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    unique_name: {
      description:
        "An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.",
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_incoming_phone_number_incoming_phone_number_assigned_add_on_incoming_phone_number_assigned_add_on_extensionSchema =
  {
    properties: {
      account_sid: {
        description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^AC[0-9a-fA-F]{32}$',
        type: 'string',
      },
      assigned_add_on_sid: {
        description: 'The SID that uniquely identifies the assigned Add-on installation.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^XE[0-9a-fA-F]{32}$',
        type: 'string',
      },
      enabled: {
        description: 'Whether the Extension will be invoked.',
        nullable: true,
        type: 'boolean',
      },
      friendly_name: {
        description: 'The string that you assigned to describe the resource.',
        nullable: true,
        type: 'string',
        'x-twilio': {
          pii: {
            deleteSla: 30,
            handling: 'standard',
          },
        },
      },
      product_name: {
        description: 'A string that you assigned to describe the Product this Extension is used within.',
        nullable: true,
        type: 'string',
      },
      resource_sid: {
        description: 'The SID of the Phone Number to which the Add-on is assigned.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^PN[0-9a-fA-F]{32}$',
        type: 'string',
      },
      sid: {
        description: 'The unique string that that we created to identify the resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^XF[0-9a-fA-F]{32}$',
        type: 'string',
      },
      unique_name: {
        description:
          "An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource.",
        nullable: true,
        type: 'string',
      },
      uri: {
        description: 'The URI of the resource, relative to `https://api.twilio.com`.',
        nullable: true,
        type: 'string',
      },
    },
    type: 'object',
  } as const;

export const api_v2010_account_incoming_phone_number_incoming_phone_number_localSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    address_requirements: {
      $ref: '#/components/schemas/incoming_phone_number_local_enum_address_requirement',
      description:
        'Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.',
      nullable: true,
      type: 'string',
    },
    address_sid: {
      description: 'The SID of the Address resource associated with the phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    bundle_sid: {
      description:
        'The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^BU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_address_sid: {
      description:
        'The SID of the emergency address configuration that we use for emergency calling from this phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_address_status: {
      $ref: '#/components/schemas/incoming_phone_number_local_enum_emergency_address_status',
      description:
        'The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.',
      nullable: true,
      type: 'string',
    },
    emergency_status: {
      $ref: '#/components/schemas/incoming_phone_number_local_enum_emergency_status',
      description:
        'The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    identity_sid: {
      description:
        'The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RI[0-9a-fA-F]{32}$',
      type: 'string',
    },
    origin: {
      description:
        "The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.",
      nullable: true,
      type: 'string',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_application_sid: {
      description:
        'The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status: {
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    trunk_sid: {
      description:
        'The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_application_sid: {
      description:
        'The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_receive_mode: {
      $ref: '#/components/schemas/incoming_phone_number_local_enum_voice_receive_mode',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description:
        'The URL we call when this phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_incoming_phone_number_incoming_phone_number_mobileSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    address_requirements: {
      $ref: '#/components/schemas/incoming_phone_number_mobile_enum_address_requirement',
      description:
        'Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.',
      nullable: true,
      type: 'string',
    },
    address_sid: {
      description: 'The SID of the Address resource associated with the phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    bundle_sid: {
      description:
        'The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^BU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_address_sid: {
      description:
        'The SID of the emergency address configuration that we use for emergency calling from this phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_address_status: {
      $ref: '#/components/schemas/incoming_phone_number_mobile_enum_emergency_address_status',
      description:
        'The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.',
      nullable: true,
      type: 'string',
    },
    emergency_status: {
      $ref: '#/components/schemas/incoming_phone_number_mobile_enum_emergency_status',
      description:
        'The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    identity_sid: {
      description:
        'The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RI[0-9a-fA-F]{32}$',
      type: 'string',
    },
    origin: {
      description:
        "The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.",
      nullable: true,
      type: 'string',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_application_sid: {
      description:
        'The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status: {
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    trunk_sid: {
      description:
        'The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_application_sid: {
      description:
        'The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_receive_mode: {
      $ref: '#/components/schemas/incoming_phone_number_mobile_enum_voice_receive_mode',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description:
        'The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_incoming_phone_number_incoming_phone_number_toll_freeSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    address_requirements: {
      $ref: '#/components/schemas/incoming_phone_number_toll_free_enum_address_requirement',
      description:
        'Whether the phone number requires an [Address](https://www.twilio.com/docs/usage/api/address) registered with Twilio. Can be: `none`, `any`, `local`, or `foreign`.',
      nullable: true,
      type: 'string',
    },
    address_sid: {
      description: 'The SID of the Address resource associated with the phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session.',
      nullable: true,
      type: 'string',
    },
    beta: {
      description: 'Whether the phone number is new to the Twilio platform. Can be: `true` or `false`.',
      nullable: true,
      type: 'boolean',
    },
    bundle_sid: {
      description:
        'The SID of the Bundle resource that you associate with the phone number. Some regions require a Bundle to meet local Regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^BU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    capabilities: {
      description:
        'The set of Boolean properties that indicate whether a phone number can receive calls or messages.  Capabilities are  `Voice`, `SMS`, and `MMS` and each capability can be: `true` or `false`.',
      format: 'phone-number-capabilities',
      nullable: true,
      properties: {
        fax: {
          type: 'boolean',
        },
        mms: {
          type: 'boolean',
        },
        sms: {
          type: 'boolean',
        },
        voice: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    emergency_address_sid: {
      description:
        'The SID of the emergency address configuration that we use for emergency calling from this phone number.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_address_status: {
      $ref: '#/components/schemas/incoming_phone_number_toll_free_enum_emergency_address_status',
      description:
        'The status of address registration with emergency services. A registered emergency address will be used during handling of emergency calls from this number.',
      nullable: true,
      type: 'string',
    },
    emergency_status: {
      $ref: '#/components/schemas/incoming_phone_number_toll_free_enum_emergency_status',
      description:
        'The parameter displays if emergency calling is enabled for this number. Active numbers may place emergency calls by dialing valid emergency numbers for the country.',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    identity_sid: {
      description:
        'The SID of the Identity resource that we associate with the phone number. Some regions require an Identity to meet local regulations.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RI[0-9a-fA-F]{32}$',
      type: 'string',
    },
    origin: {
      description:
        "The phone number's origin. `twilio` identifies Twilio-owned phone numbers and `hosted` identifies hosted phone numbers.",
      nullable: true,
      type: 'string',
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_application_sid: {
      description:
        'The SID of the application that handles SMS messages sent to the phone number. If an `sms_application_sid` is present, we ignore all `sms_*_url` values and use those of the application.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call when an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when the phone number receives an incoming SMS message.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status: {
      nullable: true,
      type: 'string',
    },
    status_callback: {
      description: 'The URL we call using the `status_callback_method` to send status information to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    status_callback_method: {
      description: 'The HTTP method we use to call `status_callback`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    trunk_sid: {
      description:
        'The SID of the Trunk that handles calls to the phone number. If a `trunk_sid` is present, we ignore all of the voice urls and voice applications and use those set on the Trunk. Setting a `trunk_sid` will automatically delete your `voice_application_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TK[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_application_sid: {
      description:
        'The SID of the application that handles calls to the phone number. If a `voice_application_sid` is present, we ignore all of the voice urls and use those set on the application. Setting a `voice_application_sid` will automatically delete your `trunk_sid` and vice versa.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    voice_caller_id_lookup: {
      description:
        "Whether we look up the caller's caller-ID name from the CNAM database ($0.01 per look up). Can be: `true` or `false`.",
      nullable: true,
      type: 'boolean',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description: 'The URL that we call when an error occurs retrieving or executing the TwiML requested by `url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_receive_mode: {
      $ref: '#/components/schemas/incoming_phone_number_toll_free_enum_voice_receive_mode',
      nullable: true,
      type: 'string',
    },
    voice_url: {
      description:
        'The URL we call when the phone number receives a call. The `voice_url` will not be used if a `voice_application_sid` or a `trunk_sid` is set.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_keySchema = {
  properties: {
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    sid: {
      description: 'The unique string that that we created to identify the Key resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SK[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_messageSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with the Message resource',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to process the Message',
      nullable: true,
      type: 'string',
    },
    body: {
      description: 'The text content of the message',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    date_created: {
      description:
        'The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message resource was created',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_sent: {
      description:
        'The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message was sent. For an outgoing message, this is when Twilio sent the message. For an incoming message, this is when Twilio sent the HTTP request to your incoming message webhook URL.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The [RFC 2822](https://datatracker.ietf.org/doc/html/rfc2822#section-3.3) timestamp (in GMT) of when the Message resource was last updated',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    direction: {
      $ref: '#/components/schemas/message_enum_direction',
      description:
        'The direction of the message. Can be: `inbound` for incoming messages, `outbound-api` for messages created by the REST API, `outbound-call` for messages created during a call, or `outbound-reply` for messages created in response to an incoming message.',
      nullable: true,
      type: 'string',
    },
    error_code: {
      description:
        'The [error code](https://www.twilio.com/docs/api/errors) returned if the Message `status` is `failed` or `undelivered`. If no error was encountered, the value is `null`.',
      nullable: true,
      type: 'integer',
    },
    error_message: {
      description:
        'The description of the `error_code` if the Message `status` is `failed` or `undelivered`. If no error was encountered, the value is `null`.',
      nullable: true,
      type: 'string',
    },
    from: {
      description:
        "The sender's phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format), [alphanumeric sender ID](https://www.twilio.com/docs/sms/quickstart), [Wireless SIM](https://www.twilio.com/docs/iot/wireless/programmable-wireless-send-machine-machine-sms-commands), [short code](https://www.twilio.com/en-us/messaging/channels/sms/short-codes), or  [channel address](https://www.twilio.com/docs/messaging/channels) (e.g., `whatsapp:+15554449999`). For incoming messages, this is the number or channel address of the sender. For outgoing messages, this value is a Twilio phone number, alphanumeric sender ID, short code, or channel address from which the message is sent.",
      format: 'phone-number',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    messaging_service_sid: {
      description:
        'The SID of the [Messaging Service](https://www.twilio.com/docs/messaging/api/service-resource) associated with the Message resource. The value is `null` if a Messaging Service was not used.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^MG[0-9a-fA-F]{32}$',
      type: 'string',
    },
    num_media: {
      description: 'The number of media files associated with the Message resource.',
      nullable: true,
      type: 'string',
    },
    num_segments: {
      description:
        "The number of segments that make up the complete message. SMS message bodies that exceed the [character limit](https://www.twilio.com/docs/glossary/what-sms-character-limit) are segmented and charged as multiple messages. Note: For messages sent via a Messaging Service, `num_segments` is initially `0`, since a sender hasn't yet been assigned.",
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The amount billed for the message in the currency specified by `price_unit`. The `price` is populated after the message has been sent/received, and may not be immediately availalble. View the [Pricing page](https://www.twilio.com/en-us/pricing) for more details.',
      nullable: true,
      type: 'string',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique, Twilio-provided string that identifies the Message resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^(SM|MM)[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/message_enum_status',
      description:
        'The status of the Message. Possible values: `accepted`, `scheduled`, `canceled`, `queued`, `sending`, `sent`, `failed`, `delivered`, `undelivered`, `receiving`, `received`, or `read` (WhatsApp only). For more information, See [detailed descriptions](https://www.twilio.com/docs/sms/api/message-resource#message-status-values).',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their URIs relative to `https://api.twilio.com`',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    to: {
      description:
        "The recipient's phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format) or [channel address](https://www.twilio.com/docs/messaging/channels) (e.g. `whatsapp:+15552229999`)",
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 120,
          handling: 'standard',
        },
      },
    },
    uri: {
      description: 'The URI of the Message resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_message_mediaSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with this Media resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    content_type: {
      description:
        'The default [MIME type](https://en.wikipedia.org/wiki/Internet_media_type) of the media, for example `image/jpeg`, `image/png`, or `image/gif`.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT when this Media resource was created, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT when this Media resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    parent_sid: {
      description: 'The SID of the Message resource that is associated with this Media resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^(SM|MM)[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that identifies this Media resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^ME[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of this Media resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_message_message_feedbackSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) associated with this MessageFeedback resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT when this MessageFeedback resource was created, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT when this MessageFeedback resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    message_sid: {
      description: 'The SID of the Message resource associated with this MessageFeedback resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^(SM|MM)[0-9a-fA-F]{32}$',
      type: 'string',
    },
    outcome: {
      $ref: '#/components/schemas/message_feedback_enum_outcome',
      description:
        'Reported outcome indicating whether there is confirmation that the Message recipient performed a tracked user action. Can be: `unconfirmed` or `confirmed`. For more details see [How to Optimize Message Deliverability with Message Feedback](https://www.twilio.com/docs/messaging/guides/send-message-feedback-to-twilio).',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_new_keySchema = {
  properties: {
    date_created: {
      description:
        'The date and time in GMT that the API Key was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the new API Key was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    secret: {
      description:
        'The secret your application uses to sign Access Tokens and to authenticate to the REST API (you will use this as the basic-auth `password`).  **Note that for security reasons, this field is ONLY returned when the API Key is first created.**',
      nullable: true,
      type: 'string',
    },
    sid: {
      description:
        'The unique string that that we created to identify the NewKey resource. You will use this as the basic-auth `user` when authenticating to the API.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SK[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_new_signing_keySchema = {
  properties: {
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    secret: {
      description:
        'The secret your application uses to sign Access Tokens and to authenticate to the REST API (you will use this as the basic-auth `password`).  **Note that for security reasons, this field is ONLY returned when the API Key is first created.**',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the NewSigningKey resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SK[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_notificationSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description:
        "The API version used to generate the notification. Can be empty for events that don't have a specific API version, such as incoming phone calls.",
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Notification resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    error_code: {
      description:
        'A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      nullable: true,
      type: 'string',
    },
    log: {
      description: 'An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.',
      nullable: true,
      type: 'string',
    },
    message_date: {
      description:
        'The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    message_text: {
      description: 'The text of the notification.',
      nullable: true,
      type: 'string',
    },
    more_info: {
      description:
        'The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_method: {
      description:
        'The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    request_url: {
      description:
        'The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^NO[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_notification_instanceSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description:
        "The API version used to generate the notification. Can be empty for events that don't have a specific API version, such as incoming phone calls.",
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Notification resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    error_code: {
      description:
        'A unique error code for the error condition that is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      nullable: true,
      type: 'string',
    },
    log: {
      description: 'An integer log level that corresponds to the type of notification: `0` is ERROR, `1` is WARNING.',
      nullable: true,
      type: 'string',
    },
    message_date: {
      description:
        'The date the notification was actually generated in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. Message buffering can cause this value to differ from `date_created`.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    message_text: {
      description: 'The text of the notification.',
      nullable: true,
      type: 'string',
    },
    more_info: {
      description:
        'The URL for more information about the error condition. This value is a page in our [Error Dictionary](https://www.twilio.com/docs/api/errors).',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_method: {
      description:
        'The HTTP method used to generate the notification. If the notification was generated during a phone call, this is the HTTP Method used to request the resource on your server. If the notification was generated by your use of our REST API, this is the HTTP method used to call the resource on our servers.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    request_url: {
      description:
        'The URL of the resource that generated the notification. If the notification was generated during a phone call, this is the URL of the resource on your server that caused the notification. If the notification was generated by your use of our REST API, this is the URL of the resource you called.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    request_variables: {
      description:
        'The HTTP GET or POST variables we sent to your server. However, if the notification was generated by our REST API, this contains the HTTP POST or PUT variables you sent to our API.',
      nullable: true,
      type: 'string',
    },
    response_body: {
      description: 'The HTTP body returned by your server.',
      nullable: true,
      type: 'string',
    },
    response_headers: {
      description: 'The HTTP headers returned by your server.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Notification resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^NO[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_outgoing_caller_idSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the OutgoingCallerId resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    phone_number: {
      description:
        'The phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    sid: {
      description: 'The unique string that that we created to identify the OutgoingCallerId resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_queueSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this Queue resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    average_wait_time: {
      description:
        ' The average wait time in seconds of the members in this queue. This is calculated at the time of the request.',
      nullable: true,
      type: 'integer',
    },
    current_size: {
      description: 'The number of calls currently in the queue.',
      nullable: true,
      type: 'integer',
    },
    date_created: {
      description:
        'The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'A string that you assigned to describe this resource.',
      nullable: true,
      type: 'string',
    },
    max_size: {
      description:
        ' The maximum number of calls that can be in the queue. The default is 1000 and the maximum is 5000.',
      nullable: true,
      type: 'integer',
    },
    sid: {
      description: 'The unique string that that we created to identify this Queue resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^QU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of this resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_queue_memberSchema = {
  properties: {
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Member resource is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_enqueued: {
      description: 'The date that the member was enqueued, given in RFC 2822 format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    position: {
      description: "This member's current position in the queue.",
      nullable: true,
      type: 'integer',
    },
    queue_sid: {
      description: 'The SID of the Queue the member is in.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^QU[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    wait_time: {
      description: 'The number of seconds the member has been in the queue.',
      nullable: true,
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_recordingSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used during the recording.',
      nullable: true,
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Recording resource is associated with. This will always refer to the parent leg of a two-leg call.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    channels: {
      description:
        'The number of channels in the final recording file. Can be: `1` or `2`. You can split a call with two legs into two separate recording channels if you record using [TwiML Dial](https://www.twilio.com/docs/voice/twiml/dial#record) or the [Outbound Rest API](https://www.twilio.com/docs/voice/make-calls#manage-your-outbound-call).',
      nullable: true,
      type: 'integer',
    },
    conference_sid: {
      description:
        'The Conference SID that identifies the conference associated with the recording, if a conference recording.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CF[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    duration: {
      description: 'The length of the recording in seconds.',
      nullable: true,
      type: 'string',
    },
    encryption_details: {
      description:
        'How to decrypt the recording if it was encrypted using [Call Recording Encryption](https://www.twilio.com/docs/voice/tutorials/voice-recording-encryption) feature.',
      nullable: true,
    },
    error_code: {
      description:
        'The error code that describes why the recording is `absent`. The error code is described in our [Error Dictionary](https://www.twilio.com/docs/api/errors). This value is null if the recording `status` is not `absent`.',
      nullable: true,
      type: 'integer',
    },
    media_url: {
      description:
        'The URL of the media file associated with this recording resource. When stored externally, this is the full URL location of the media file.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    price: {
      description: 'The one-time cost of creating the recording in the `price_unit` currency.',
      nullable: true,
      type: 'string',
    },
    price_unit: {
      description: 'The currency used in the `price` property. Example: `USD`.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Recording resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    source: {
      $ref: '#/components/schemas/recording_enum_source',
      description:
        'How the recording was created. Can be: `DialVerb`, `Conference`, `OutboundAPI`, `Trunking`, `RecordVerb`, `StartCallRecordingAPI`, and `StartConferenceRecordingAPI`.',
      nullable: true,
      type: 'string',
    },
    start_time: {
      description:
        'The start time of the recording in GMT and in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/recording_enum_status',
      description:
        'The status of the recording. Can be: `processing`, `completed`, `absent` or `deleted`. For information about more detailed statuses on in-progress recordings, check out how to [Update a Recording Resource](https://www.twilio.com/docs/voice/api/recording#update-a-recording-resource).',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their relative URIs.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_recording_recording_add_on_resultSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    add_on_configuration_sid: {
      description: 'The SID of the Add-on configuration.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    add_on_sid: {
      description: 'The SID of the Add-on to which the result belongs.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XB[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_completed: {
      description:
        'The date and time in GMT that the result was completed specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    reference_sid: {
      description: 'The SID of the recording to which the AddOnResult resource belongs.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Recording AddOnResult resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/recording_add_on_result_enum_status',
      description:
        'The status of the result. Can be: `canceled`, `completed`, `deleted`, `failed`, `in-progress`, `init`, `processing`, `queued`.',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their relative URIs.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_recording_recording_add_on_result_recording_add_on_result_payloadSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Recording AddOnResult Payload resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    add_on_configuration_sid: {
      description: 'The SID of the Add-on configuration.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    add_on_result_sid: {
      description: 'The SID of the AddOnResult to which the payload belongs.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    add_on_sid: {
      description: 'The SID of the Add-on to which the result belongs.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XB[0-9a-fA-F]{32}$',
      type: 'string',
    },
    content_type: {
      description: 'The MIME type of the payload.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    label: {
      description: 'The string provided by the vendor that describes the payload.',
      nullable: true,
      type: 'string',
    },
    reference_sid: {
      description: 'The SID of the recording to which the AddOnResult resource that contains the payload belongs.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Recording AddOnResult Payload resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^XH[0-9a-fA-F]{32}$',
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of related resources identified by their relative URIs.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_recording_recording_transcriptionSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the transcription.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    duration: {
      description: 'The duration of the transcribed audio in seconds.',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The charge for the transcript in the currency associated with the account. This value is populated after the transcript is complete so it may not be available immediately.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    recording_sid: {
      description:
        'The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) from which the transcription was created.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Transcription resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/recording_transcription_enum_status',
      description: 'The status of the transcription. Can be: `in-progress`, `completed`, `failed`.',
      nullable: true,
      type: 'string',
    },
    transcription_text: {
      description: 'The text content of the transcription.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'sensitive',
        },
      },
    },
    type: {
      description: 'The transcription type.',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_short_codeSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created this ShortCode resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to start a new TwiML session when an SMS message is sent to this short code.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that this resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that this resource was last updated, specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description:
        'A string that you assigned to describe this resource. By default, the `FriendlyName` is the short code.',
      nullable: true,
      type: 'string',
    },
    short_code: {
      description: 'The short code. e.g., 894546.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify this ShortCode resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sms_fallback_method: {
      description: 'The HTTP method we use to call the `sms_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_fallback_url: {
      description: 'The URL that we call if an error occurs while retrieving or executing the TwiML from `sms_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    sms_method: {
      description: 'The HTTP method we use to call the `sms_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    sms_url: {
      description: 'The URL we call when receiving an incoming SMS message to this short code.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of this resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_signing_keySchema = {
  properties: {
    date_created: {
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      nullable: true,
      type: 'string',
    },
    sid: {
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SK[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sipSchema = {
  properties: {},
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_credential_listSchema = {
  properties: {
    account_sid: {
      description:
        'The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) that owns this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'A human readable descriptive text that describes the CredentialList, up to 64 characters long.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of credentials associated with this credential list.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_credential_list_sip_credentialSchema = {
  properties: {
    account_sid: {
      description: 'The unique id of the Account that is responsible for this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    credential_list_sid: {
      description: 'The unique id that identifies the credential list that includes this credential.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
    username: {
      description: 'The username for this credential.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domainSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the SipDomain resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to process the call.',
      nullable: true,
      type: 'string',
    },
    auth_type: {
      description:
        'The types of authentication you have mapped to your domain. Can be: `IP_ACL` and `CREDENTIAL_LIST`. If you have both defined for your domain, both will be returned in a comma delimited string. If `auth_type` is not defined, the domain will not be able to receive any traffic.',
      nullable: true,
      type: 'string',
    },
    byoc_trunk_sid: {
      description:
        'The SID of the BYOC Trunk(Bring Your Own Carrier) resource that the Sip Domain will be associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^BY[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    domain_name: {
      description:
        'The unique address you reserve on Twilio to which you route your SIP traffic. Domain names can contain letters, digits, and "-" and must end with `sip.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    emergency_caller_sid: {
      description:
        'Whether an emergency caller sid is configured for the domain. If present, this phone number will be used as the callback for the emergency call.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^PN[0-9a-fA-F]{32}$',
      type: 'string',
    },
    emergency_calling_enabled: {
      description:
        'Whether emergency calling is enabled for the domain. If enabled, allows emergency calls on the domain from phone numbers with validated addresses.',
      nullable: true,
      type: 'boolean',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
    },
    secure: {
      description:
        'Whether secure SIP is enabled for the domain. If enabled, TLS will be enforced and SRTP will be negotiated on all incoming calls to this sip domain.',
      nullable: true,
      type: 'boolean',
    },
    sid: {
      description: 'The unique string that that we created to identify the SipDomain resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sip_registration: {
      description: 'Whether to allow SIP Endpoints to register with the domain to receive calls.',
      nullable: true,
      type: 'boolean',
    },
    subresource_uris: {
      description:
        'A list of mapping resources associated with the SIP Domain resource identified by their relative URIs.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    voice_fallback_method: {
      description: 'The HTTP method we use to call `voice_fallback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_fallback_url: {
      description:
        'The URL that we call when an error occurs while retrieving or executing the TwiML requested from `voice_url`.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    voice_method: {
      description: 'The HTTP method we use to call `voice_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_status_callback_method: {
      description: 'The HTTP method we use to call `voice_status_callback_url`. Either `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    voice_status_callback_url: {
      description: 'The URL that we call to pass status parameters (such as call ended) to your application.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    voice_url: {
      description: 'The URL we call using the `voice_method` when the domain receives a call.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_authSchema = {
  properties: {},
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_auth_sip_auth_callsSchema = {
  properties: {},
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_credential_list_mappingSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 0,
          handling: 'standard',
        },
      },
    },
    sid: {
      description: 'The unique string that that we created to identify the CredentialListMapping resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CL[0-9a-fA-F]{32}$',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_auth_sip_auth_calls_sip_auth_calls_ip_access_control_list_mappingSchema =
  {
    properties: {
      account_sid: {
        description:
          'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the IpAccessControlListMapping resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^AC[0-9a-fA-F]{32}$',
        type: 'string',
      },
      date_created: {
        description:
          'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
        format: 'date-time-rfc-2822',
        nullable: true,
        type: 'string',
      },
      date_updated: {
        description:
          'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
        format: 'date-time-rfc-2822',
        nullable: true,
        type: 'string',
      },
      friendly_name: {
        description: 'The string that you assigned to describe the resource.',
        nullable: true,
        type: 'string',
        'x-twilio': {
          pii: {
            deleteSla: 0,
            handling: 'standard',
          },
        },
      },
      sid: {
        description: 'The unique string that that we created to identify the IpAccessControlListMapping resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^AL[0-9a-fA-F]{32}$',
        type: 'string',
      },
    },
    type: 'object',
  } as const;

export const api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrationsSchema = {
  properties: {},
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_auth_sip_auth_registrations_sip_auth_registrations_credential_list_mappingSchema =
  {
    properties: {
      account_sid: {
        description:
          'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the CredentialListMapping resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^AC[0-9a-fA-F]{32}$',
        type: 'string',
      },
      date_created: {
        description:
          'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
        format: 'date-time-rfc-2822',
        nullable: true,
        type: 'string',
      },
      date_updated: {
        description:
          'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
        format: 'date-time-rfc-2822',
        nullable: true,
        type: 'string',
      },
      friendly_name: {
        description: 'The string that you assigned to describe the resource.',
        nullable: true,
        type: 'string',
        'x-twilio': {
          pii: {
            deleteSla: 0,
            handling: 'standard',
          },
        },
      },
      sid: {
        description: 'The unique string that that we created to identify the CredentialListMapping resource.',
        maxLength: 34,
        minLength: 34,
        nullable: true,
        pattern: '^CL[0-9a-fA-F]{32}$',
        type: 'string',
      },
    },
    type: 'object',
  } as const;

export const api_v2010_account_sip_sip_domain_sip_credential_list_mappingSchema = {
  properties: {
    account_sid: {
      description: 'The unique id of the Account that is responsible for this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    domain_sid: {
      description: 'The unique string that is created to identify the SipDomain resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    friendly_name: {
      description: 'A human readable descriptive text for this resource, up to 64 characters long.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_domain_sip_ip_access_control_list_mappingSchema = {
  properties: {
    account_sid: {
      description: 'The unique id of the Account that is responsible for this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    domain_sid: {
      description: 'The unique string that is created to identify the SipDomain resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^SD[0-9a-fA-F]{32}$',
      type: 'string',
    },
    friendly_name: {
      description: 'A human readable descriptive text for this resource, up to 64 characters long.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_ip_access_control_listSchema = {
  properties: {
    account_sid: {
      description:
        'The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) that owns this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'A human readable descriptive text, up to 255 characters long.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    subresource_uris: {
      description: 'A list of the IpAddress resources associated with this IP access control list resource.',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_sip_sip_ip_access_control_list_sip_ip_addressSchema = {
  properties: {
    account_sid: {
      description: 'The unique id of the Account that is responsible for this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    cidr_prefix_length: {
      description:
        'An integer representing the length of the CIDR prefix to use with this IP address when accepting traffic. By default the entire IP address is used.',
      nullable: true,
      type: 'integer',
    },
    date_created: {
      description:
        'The date that this resource was created, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date that this resource was last updated, given as GMT in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'A human readable descriptive text for this resource, up to 255 characters long.',
      nullable: true,
      type: 'string',
    },
    ip_access_control_list_sid: {
      description: 'The unique id of the IpAccessControlList resource that includes this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AL[0-9a-fA-F]{32}$',
      type: 'string',
    },
    ip_address: {
      description:
        'An IP address in dotted decimal notation from which you want to accept traffic. Any SIP requests from this IP address will be allowed by Twilio. IPv4 only supported today.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'A 34 character string that uniquely identifies this resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^IP[0-9a-fA-F]{32}$',
      type: 'string',
    },
    uri: {
      description: 'The URI for this resource, relative to `https://api.twilio.com`',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_tokenSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Token resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    ice_servers: {
      description: 'An array representing the ephemeral credentials and the STUN and TURN server URIs.',
      items: {
        format: 'ice-server',
        properties: {
          credential: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
          urls: {
            type: 'string',
          },
          username: {
            type: 'string',
          },
        },
        type: 'object',
      },
      nullable: true,
      type: 'array',
    },
    password: {
      description: 'The temporary password that the username will use when authenticating with Twilio.',
      nullable: true,
      type: 'string',
    },
    ttl: {
      description: 'The duration in seconds for which the username and password are valid.',
      nullable: true,
      type: 'string',
    },
    username: {
      description: 'The temporary username that uniquely identifies a Token.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_transcriptionSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Transcription resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the transcription.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    duration: {
      description: 'The duration of the transcribed audio in seconds.',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The charge for the transcript in the currency associated with the account. This value is populated after the transcript is complete so it may not be available immediately.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`).',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    recording_sid: {
      description:
        'The SID of the [Recording](https://www.twilio.com/docs/voice/api/recording) from which the transcription was created.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^RE[0-9a-fA-F]{32}$',
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the Transcription resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^TR[0-9a-fA-F]{32}$',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/transcription_enum_status',
      description: 'The status of the transcription. Can be: `in-progress`, `completed`, `failed`.',
      nullable: true,
      type: 'string',
    },
    transcription_text: {
      description: 'The text content of the transcription.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'sensitive',
        },
      },
    },
    type: {
      description: 'The transcription type. Can only be: `fast`.',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usageSchema = {
  properties: {},
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_recordSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_all_timeSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_all_time_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_dailySchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_daily_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_last_monthSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_last_month_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_monthlySchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_monthly_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_this_monthSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_this_month_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_todaySchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_today_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_yearlySchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_yearly_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_record_usage_record_yesterdaySchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that accrued the usage.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    as_of: {
      description:
        'Usage records up to date as of this timestamp, formatted as YYYY-MM-DDTHH:MM:SS+00:00. All timestamps are in GMT',
      nullable: true,
      type: 'string',
    },
    category: {
      $ref: '#/components/schemas/usage_record_yesterday_enum_category',
      description:
        'The category of usage. For more information, see [Usage Categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    count: {
      description: 'The number of usage events, such as the number of calls.',
      nullable: true,
      type: 'string',
    },
    count_unit: {
      description: 'The units in which `count` is measured, such as `calls` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A plain-language description of the usage category.',
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'The last date for which usage is included in the UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    price: {
      description:
        'The total price of the usage in the currency specified in `price_unit` and associated with the account.',
      nullable: true,
      type: 'number',
    },
    price_unit: {
      description:
        'The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format, such as `usd`, `eur`, and `jpy`.',
      format: 'currency',
      nullable: true,
      type: 'string',
    },
    start_date: {
      description:
        'The first date for which usage is included in this UsageRecord. The date is specified in GMT and formatted as `YYYY-MM-DD`.',
      format: 'date',
      nullable: true,
      type: 'string',
    },
    subresource_uris: {
      description:
        'A list of related resources identified by their URIs. For more information, see [List Subresources](https://www.twilio.com/docs/usage/api/usage-record#list-subresources).',
      format: 'uri-map',
      nullable: true,
      type: 'object',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage: {
      description: 'The amount used to bill usage and measured in units described in `usage_unit`.',
      nullable: true,
      type: 'string',
    },
    usage_unit: {
      description: 'The units in which `usage` is measured, such as `minutes` for calls or `messages` for SMS.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_usage_usage_triggerSchema = {
  properties: {
    account_sid: {
      description: 'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that the trigger monitors.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    api_version: {
      description: 'The API version used to create the resource.',
      nullable: true,
      type: 'string',
    },
    callback_method: {
      description: 'The HTTP method we use to call `callback_url`. Can be: `GET` or `POST`.',
      enum: ['HEAD', 'GET', 'POST', 'PATCH', 'PUT', 'DELETE'],
      format: 'http-method',
      nullable: true,
      type: 'string',
    },
    callback_url: {
      description: 'The URL we call using the `callback_method` when the trigger fires.',
      format: 'uri',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 60,
          handling: 'sensitive',
        },
      },
    },
    current_value: {
      description: 'The current value of the field the trigger is watching.',
      nullable: true,
      type: 'string',
    },
    date_created: {
      description:
        'The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_fired: {
      description:
        'The date and time in GMT that the trigger was last fired specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    date_updated: {
      description:
        'The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.',
      format: 'date-time-rfc-2822',
      nullable: true,
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the trigger.',
      nullable: true,
      type: 'string',
    },
    recurring: {
      $ref: '#/components/schemas/usage_trigger_enum_recurring',
      description:
        'The frequency of a recurring UsageTrigger.  Can be: `daily`, `monthly`, or `yearly` for recurring triggers or empty for non-recurring triggers. A trigger will only fire once during each period. Recurring times are in GMT.',
      nullable: true,
      type: 'string',
    },
    sid: {
      description: 'The unique string that that we created to identify the UsageTrigger resource.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^UT[0-9a-fA-F]{32}$',
      type: 'string',
    },
    trigger_by: {
      $ref: '#/components/schemas/usage_trigger_enum_trigger_field',
      description:
        'The field in the [UsageRecord](https://www.twilio.com/docs/usage/api/usage-record) resource that fires the trigger.  Can be: `count`, `usage`, or `price`, as described in the [UsageRecords documentation](https://www.twilio.com/docs/usage/api/usage-record#usage-count-price).',
      nullable: true,
      type: 'string',
    },
    trigger_value: {
      description: 'The value at which the trigger will fire.  Must be a positive, numeric value.',
      nullable: true,
      type: 'string',
    },
    uri: {
      description: 'The URI of the resource, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
    usage_category: {
      $ref: '#/components/schemas/usage_trigger_enum_usage_category',
      description:
        'The usage category the trigger watches. Must be one of the supported [usage categories](https://www.twilio.com/docs/usage/api/usage-record#usage-categories).',
      nullable: true,
      type: 'string',
    },
    usage_record_uri: {
      description:
        'The URI of the [UsageRecord](https://www.twilio.com/docs/usage/api/usage-record) resource this trigger watches, relative to `https://api.twilio.com`.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const api_v2010_account_validation_requestSchema = {
  properties: {
    account_sid: {
      description:
        'The SID of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for the Caller ID.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^AC[0-9a-fA-F]{32}$',
      type: 'string',
    },
    call_sid: {
      description:
        'The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the Caller ID is associated with.',
      maxLength: 34,
      minLength: 34,
      nullable: true,
      pattern: '^CA[0-9a-fA-F]{32}$',
      type: 'string',
    },
    friendly_name: {
      description: 'The string that you assigned to describe the resource.',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    phone_number: {
      description:
        'The phone number to verify in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, which consists of a + followed by the country code and subscriber number.',
      format: 'phone-number',
      nullable: true,
      type: 'string',
      'x-twilio': {
        pii: {
          deleteSla: 30,
          handling: 'standard',
        },
      },
    },
    validation_code: {
      description:
        'The 6 digit validation code that someone must enter to validate the Caller ID  when `phone_number` is called.',
      nullable: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const authorized_connect_app_enum_permissionSchema = {
  enum: ['get-all', 'post-all'],
  type: 'string',
} as const;

export const call_enum_eventSchema = {
  enum: ['initiated', 'ringing', 'answered', 'completed'],
  type: 'string',
} as const;

export const call_enum_statusSchema = {
  enum: ['queued', 'ringing', 'in-progress', 'completed', 'busy', 'failed', 'no-answer', 'canceled'],
  type: 'string',
} as const;

export const call_enum_update_statusSchema = {
  enum: ['canceled', 'completed'],
  type: 'string',
} as const;

export const call_recording_enum_sourceSchema = {
  enum: [
    'DialVerb',
    'Conference',
    'OutboundAPI',
    'Trunking',
    'RecordVerb',
    'StartCallRecordingAPI',
    'StartConferenceRecordingAPI',
  ],
  type: 'string',
} as const;

export const call_recording_enum_statusSchema = {
  enum: ['in-progress', 'paused', 'stopped', 'processing', 'completed', 'absent'],
  type: 'string',
} as const;

export const conference_enum_reason_conference_endedSchema = {
  enum: [
    'conference-ended-via-api',
    'participant-with-end-conference-on-exit-left',
    'participant-with-end-conference-on-exit-kicked',
    'last-participant-kicked',
    'last-participant-left',
  ],
  type: 'string',
} as const;

export const conference_enum_statusSchema = {
  enum: ['init', 'in-progress', 'completed'],
  type: 'string',
} as const;

export const conference_enum_update_statusSchema = {
  enum: ['completed'],
  type: 'string',
} as const;

export const conference_recording_enum_sourceSchema = {
  enum: [
    'DialVerb',
    'Conference',
    'OutboundAPI',
    'Trunking',
    'RecordVerb',
    'StartCallRecordingAPI',
    'StartConferenceRecordingAPI',
  ],
  type: 'string',
} as const;

export const conference_recording_enum_statusSchema = {
  enum: ['in-progress', 'paused', 'stopped', 'processing', 'completed', 'absent'],
  type: 'string',
} as const;

export const connect_app_enum_permissionSchema = {
  enum: ['get-all', 'post-all'],
  type: 'string',
} as const;

export const dependent_phone_number_enum_address_requirementSchema = {
  enum: ['none', 'any', 'local', 'foreign'],
  type: 'string',
} as const;

export const dependent_phone_number_enum_emergency_statusSchema = {
  enum: ['Active', 'Inactive'],
  type: 'string',
} as const;

export const incoming_phone_number_enum_address_requirementSchema = {
  enum: ['none', 'any', 'local', 'foreign'],
  type: 'string',
} as const;

export const incoming_phone_number_enum_emergency_address_statusSchema = {
  enum: [
    'registered',
    'unregistered',
    'pending-registration',
    'registration-failure',
    'pending-unregistration',
    'unregistration-failure',
  ],
  type: 'string',
} as const;

export const incoming_phone_number_enum_emergency_statusSchema = {
  enum: ['Active', 'Inactive'],
  type: 'string',
} as const;

export const incoming_phone_number_enum_voice_receive_modeSchema = {
  enum: ['voice', 'fax'],
  type: 'string',
} as const;

export const incoming_phone_number_local_enum_address_requirementSchema = {
  enum: ['none', 'any', 'local', 'foreign'],
  type: 'string',
} as const;

export const incoming_phone_number_local_enum_emergency_address_statusSchema = {
  enum: [
    'registered',
    'unregistered',
    'pending-registration',
    'registration-failure',
    'pending-unregistration',
    'unregistration-failure',
  ],
  type: 'string',
} as const;

export const incoming_phone_number_local_enum_emergency_statusSchema = {
  enum: ['Active', 'Inactive'],
  type: 'string',
} as const;

export const incoming_phone_number_local_enum_voice_receive_modeSchema = {
  enum: ['voice', 'fax'],
  type: 'string',
} as const;

export const incoming_phone_number_mobile_enum_address_requirementSchema = {
  enum: ['none', 'any', 'local', 'foreign'],
  type: 'string',
} as const;

export const incoming_phone_number_mobile_enum_emergency_address_statusSchema = {
  enum: [
    'registered',
    'unregistered',
    'pending-registration',
    'registration-failure',
    'pending-unregistration',
    'unregistration-failure',
  ],
  type: 'string',
} as const;

export const incoming_phone_number_mobile_enum_emergency_statusSchema = {
  enum: ['Active', 'Inactive'],
  type: 'string',
} as const;

export const incoming_phone_number_mobile_enum_voice_receive_modeSchema = {
  enum: ['voice', 'fax'],
  type: 'string',
} as const;

export const incoming_phone_number_toll_free_enum_address_requirementSchema = {
  enum: ['none', 'any', 'local', 'foreign'],
  type: 'string',
} as const;

export const incoming_phone_number_toll_free_enum_emergency_address_statusSchema = {
  enum: [
    'registered',
    'unregistered',
    'pending-registration',
    'registration-failure',
    'pending-unregistration',
    'unregistration-failure',
  ],
  type: 'string',
} as const;

export const incoming_phone_number_toll_free_enum_emergency_statusSchema = {
  enum: ['Active', 'Inactive'],
  type: 'string',
} as const;

export const incoming_phone_number_toll_free_enum_voice_receive_modeSchema = {
  enum: ['voice', 'fax'],
  type: 'string',
} as const;

export const message_enum_address_retentionSchema = {
  enum: ['retain', 'obfuscate'],
  type: 'string',
} as const;

export const message_enum_content_retentionSchema = {
  enum: ['retain', 'discard'],
  type: 'string',
} as const;

export const message_enum_directionSchema = {
  enum: ['inbound', 'outbound-api', 'outbound-call', 'outbound-reply'],
  type: 'string',
} as const;

export const message_enum_risk_checkSchema = {
  enum: ['enable', 'disable'],
  type: 'string',
} as const;

export const message_enum_schedule_typeSchema = {
  enum: ['fixed'],
  type: 'string',
} as const;

export const message_enum_statusSchema = {
  enum: [
    'queued',
    'sending',
    'sent',
    'failed',
    'delivered',
    'undelivered',
    'receiving',
    'received',
    'accepted',
    'scheduled',
    'read',
    'partially_delivered',
    'canceled',
  ],
  type: 'string',
} as const;

export const message_enum_traffic_typeSchema = {
  enum: ['free'],
  type: 'string',
} as const;

export const message_enum_update_statusSchema = {
  enum: ['canceled'],
  type: 'string',
} as const;

export const message_feedback_enum_outcomeSchema = {
  enum: ['confirmed', 'unconfirmed'],
  type: 'string',
} as const;

export const participant_enum_statusSchema = {
  enum: ['queued', 'connecting', 'ringing', 'connected', 'complete', 'failed'],
  type: 'string',
} as const;

export const payments_enum_bank_account_typeSchema = {
  enum: ['consumer-checking', 'consumer-savings', 'commercial-checking'],
  type: 'string',
} as const;

export const payments_enum_captureSchema = {
  enum: [
    'payment-card-number',
    'expiration-date',
    'security-code',
    'postal-code',
    'bank-routing-number',
    'bank-account-number',
  ],
  type: 'string',
} as const;

export const payments_enum_payment_methodSchema = {
  enum: ['credit-card', 'ach-debit'],
  type: 'string',
} as const;

export const payments_enum_statusSchema = {
  enum: ['complete', 'cancel'],
  type: 'string',
} as const;

export const payments_enum_token_typeSchema = {
  enum: ['one-time', 'reusable'],
  type: 'string',
} as const;

export const recording_add_on_result_enum_statusSchema = {
  enum: ['canceled', 'completed', 'deleted', 'failed', 'in-progress', 'init', 'processing', 'queued'],
  type: 'string',
} as const;

export const recording_enum_sourceSchema = {
  enum: [
    'DialVerb',
    'Conference',
    'OutboundAPI',
    'Trunking',
    'RecordVerb',
    'StartCallRecordingAPI',
    'StartConferenceRecordingAPI',
  ],
  type: 'string',
} as const;

export const recording_enum_statusSchema = {
  enum: ['in-progress', 'paused', 'stopped', 'processing', 'completed', 'absent', 'deleted'],
  type: 'string',
} as const;

export const recording_transcription_enum_statusSchema = {
  enum: ['in-progress', 'completed', 'failed'],
  type: 'string',
} as const;

export const siprec_enum_statusSchema = {
  enum: ['in-progress', 'stopped'],
  type: 'string',
} as const;

export const siprec_enum_trackSchema = {
  enum: ['inbound_track', 'outbound_track', 'both_tracks'],
  type: 'string',
} as const;

export const siprec_enum_update_statusSchema = {
  enum: ['stopped'],
  type: 'string',
} as const;

export const stream_enum_statusSchema = {
  enum: ['in-progress', 'stopped'],
  type: 'string',
} as const;

export const stream_enum_trackSchema = {
  enum: ['inbound_track', 'outbound_track', 'both_tracks'],
  type: 'string',
} as const;

export const stream_enum_update_statusSchema = {
  enum: ['stopped'],
  type: 'string',
} as const;

export const transcription_enum_statusSchema = {
  enum: ['in-progress', 'completed', 'failed'],
  type: 'string',
} as const;

export const usage_record_all_time_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_daily_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_last_month_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_monthly_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_this_month_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_today_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_yearly_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_record_yesterday_enum_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;

export const usage_trigger_enum_recurringSchema = {
  enum: ['daily', 'monthly', 'yearly', 'alltime'],
  type: 'string',
} as const;

export const usage_trigger_enum_trigger_fieldSchema = {
  enum: ['count', 'usage', 'price'],
  type: 'string',
} as const;

export const usage_trigger_enum_usage_categorySchema = {
  enum: [
    'a2p-registration-fees',
    'agent-conference',
    'amazon-polly',
    'answering-machine-detection',
    'authy-authentications',
    'authy-calls-outbound',
    'authy-monthly-fees',
    'authy-phone-intelligence',
    'authy-phone-verifications',
    'authy-sms-outbound',
    'call-progess-events',
    'calleridlookups',
    'calls',
    'calls-client',
    'calls-globalconference',
    'calls-inbound',
    'calls-inbound-local',
    'calls-inbound-mobile',
    'calls-inbound-tollfree',
    'calls-outbound',
    'calls-pay-verb-transactions',
    'calls-recordings',
    'calls-sip',
    'calls-sip-inbound',
    'calls-sip-outbound',
    'calls-transfers',
    'carrier-lookups',
    'conversations',
    'conversations-api-requests',
    'conversations-conversation-events',
    'conversations-endpoint-connectivity',
    'conversations-events',
    'conversations-participant-events',
    'conversations-participants',
    'cps',
    'flex-usage',
    'fraud-lookups',
    'group-rooms',
    'group-rooms-data-track',
    'group-rooms-encrypted-media-recorded',
    'group-rooms-media-downloaded',
    'group-rooms-media-recorded',
    'group-rooms-media-routed',
    'group-rooms-media-stored',
    'group-rooms-participant-minutes',
    'group-rooms-recorded-minutes',
    'imp-v1-usage',
    'lookups',
    'marketplace',
    'marketplace-algorithmia-named-entity-recognition',
    'marketplace-cadence-transcription',
    'marketplace-cadence-translation',
    'marketplace-capio-speech-to-text',
    'marketplace-convriza-ababa',
    'marketplace-deepgram-phrase-detector',
    'marketplace-digital-segment-business-info',
    'marketplace-facebook-offline-conversions',
    'marketplace-google-speech-to-text',
    'marketplace-ibm-watson-message-insights',
    'marketplace-ibm-watson-message-sentiment',
    'marketplace-ibm-watson-recording-analysis',
    'marketplace-ibm-watson-tone-analyzer',
    'marketplace-icehook-systems-scout',
    'marketplace-infogroup-dataaxle-bizinfo',
    'marketplace-keen-io-contact-center-analytics',
    'marketplace-marchex-cleancall',
    'marketplace-marchex-sentiment-analysis-for-sms',
    'marketplace-marketplace-nextcaller-social-id',
    'marketplace-mobile-commons-opt-out-classifier',
    'marketplace-nexiwave-voicemail-to-text',
    'marketplace-nextcaller-advanced-caller-identification',
    'marketplace-nomorobo-spam-score',
    'marketplace-payfone-tcpa-compliance',
    'marketplace-remeeting-automatic-speech-recognition',
    'marketplace-tcpa-defense-solutions-blacklist-feed',
    'marketplace-telo-opencnam',
    'marketplace-truecnam-true-spam',
    'marketplace-twilio-caller-name-lookup-us',
    'marketplace-twilio-carrier-information-lookup',
    'marketplace-voicebase-pci',
    'marketplace-voicebase-transcription',
    'marketplace-voicebase-transcription-custom-vocabulary',
    'marketplace-whitepages-pro-caller-identification',
    'marketplace-whitepages-pro-phone-intelligence',
    'marketplace-whitepages-pro-phone-reputation',
    'marketplace-wolfarm-spoken-results',
    'marketplace-wolfram-short-answer',
    'marketplace-ytica-contact-center-reporting-analytics',
    'mediastorage',
    'mms',
    'mms-inbound',
    'mms-inbound-longcode',
    'mms-inbound-shortcode',
    'mms-messages-carrierfees',
    'mms-outbound',
    'mms-outbound-longcode',
    'mms-outbound-shortcode',
    'monitor-reads',
    'monitor-storage',
    'monitor-writes',
    'notify',
    'notify-actions-attempts',
    'notify-channels',
    'number-format-lookups',
    'pchat',
    'pchat-users',
    'peer-to-peer-rooms-participant-minutes',
    'pfax',
    'pfax-minutes',
    'pfax-minutes-inbound',
    'pfax-minutes-outbound',
    'pfax-pages',
    'phonenumbers',
    'phonenumbers-cps',
    'phonenumbers-emergency',
    'phonenumbers-local',
    'phonenumbers-mobile',
    'phonenumbers-setups',
    'phonenumbers-tollfree',
    'premiumsupport',
    'proxy',
    'proxy-active-sessions',
    'pstnconnectivity',
    'pv',
    'pv-composition-media-downloaded',
    'pv-composition-media-encrypted',
    'pv-composition-media-stored',
    'pv-composition-minutes',
    'pv-recording-compositions',
    'pv-room-participants',
    'pv-room-participants-au1',
    'pv-room-participants-br1',
    'pv-room-participants-ie1',
    'pv-room-participants-jp1',
    'pv-room-participants-sg1',
    'pv-room-participants-us1',
    'pv-room-participants-us2',
    'pv-rooms',
    'pv-sip-endpoint-registrations',
    'recordings',
    'recordingstorage',
    'rooms-group-bandwidth',
    'rooms-group-minutes',
    'rooms-peer-to-peer-minutes',
    'shortcodes',
    'shortcodes-customerowned',
    'shortcodes-mms-enablement',
    'shortcodes-mps',
    'shortcodes-random',
    'shortcodes-uk',
    'shortcodes-vanity',
    'small-group-rooms',
    'small-group-rooms-data-track',
    'small-group-rooms-participant-minutes',
    'sms',
    'sms-inbound',
    'sms-inbound-longcode',
    'sms-inbound-shortcode',
    'sms-messages-carrierfees',
    'sms-messages-features',
    'sms-messages-features-senderid',
    'sms-outbound',
    'sms-outbound-content-inspection',
    'sms-outbound-longcode',
    'sms-outbound-shortcode',
    'speech-recognition',
    'studio-engagements',
    'sync',
    'sync-actions',
    'sync-endpoint-hours',
    'sync-endpoint-hours-above-daily-cap',
    'taskrouter-tasks',
    'totalprice',
    'transcriptions',
    'trunking-cps',
    'trunking-emergency-calls',
    'trunking-origination',
    'trunking-origination-local',
    'trunking-origination-mobile',
    'trunking-origination-tollfree',
    'trunking-recordings',
    'trunking-secure',
    'trunking-termination',
    'tts-google',
    'turnmegabytes',
    'turnmegabytes-australia',
    'turnmegabytes-brasil',
    'turnmegabytes-germany',
    'turnmegabytes-india',
    'turnmegabytes-ireland',
    'turnmegabytes-japan',
    'turnmegabytes-singapore',
    'turnmegabytes-useast',
    'turnmegabytes-uswest',
    'twilio-interconnect',
    'verify-push',
    'verify-totp',
    'verify-whatsapp-conversations-business-initiated',
    'video-recordings',
    'virtual-agent',
    'voice-insights',
    'voice-insights-client-insights-on-demand-minute',
    'voice-insights-ptsn-insights-on-demand-minute',
    'voice-insights-sip-interface-insights-on-demand-minute',
    'voice-insights-sip-trunking-insights-on-demand-minute',
    'voice-intelligence',
    'voice-intelligence-transcription',
    'voice-intelligence-operators',
    'wireless',
    'wireless-orders',
    'wireless-orders-artwork',
    'wireless-orders-bulk',
    'wireless-orders-esim',
    'wireless-orders-starter',
    'wireless-usage',
    'wireless-usage-commands',
    'wireless-usage-commands-africa',
    'wireless-usage-commands-asia',
    'wireless-usage-commands-centralandsouthamerica',
    'wireless-usage-commands-europe',
    'wireless-usage-commands-home',
    'wireless-usage-commands-northamerica',
    'wireless-usage-commands-oceania',
    'wireless-usage-commands-roaming',
    'wireless-usage-data',
    'wireless-usage-data-africa',
    'wireless-usage-data-asia',
    'wireless-usage-data-centralandsouthamerica',
    'wireless-usage-data-custom-additionalmb',
    'wireless-usage-data-custom-first5mb',
    'wireless-usage-data-domestic-roaming',
    'wireless-usage-data-europe',
    'wireless-usage-data-individual-additionalgb',
    'wireless-usage-data-individual-firstgb',
    'wireless-usage-data-international-roaming-canada',
    'wireless-usage-data-international-roaming-india',
    'wireless-usage-data-international-roaming-mexico',
    'wireless-usage-data-northamerica',
    'wireless-usage-data-oceania',
    'wireless-usage-data-pooled',
    'wireless-usage-data-pooled-downlink',
    'wireless-usage-data-pooled-uplink',
    'wireless-usage-mrc',
    'wireless-usage-mrc-custom',
    'wireless-usage-mrc-individual',
    'wireless-usage-mrc-pooled',
    'wireless-usage-mrc-suspended',
    'wireless-usage-sms',
    'wireless-usage-voice',
  ],
  type: 'string',
} as const;
