// This file is auto-generated by @hey-api/openapi-ts

/**
 * This is an object representing a Stripe account. You can retrieve it to see
 * properties on the account like its current requirements or if the account is
 * enabled to make live charges or receive payouts.
 *
 * For accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection)
 * is `application`, which includes Custom accounts, the properties below are always
 * returned.
 *
 * For accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection)
 * is `stripe`, which includes Standard and Express accounts, some properties are only returned
 * until you create an [Account Link](/api/account_links) or [Account Session](/api/account_sessions)
 * to start Connect Onboarding. Learn about the [differences between accounts](/connect/accounts).
 */
export type account = {
  /**
   * Business information about the account.
   */
  business_profile?: account_business_profile | null;
  /**
   * The business type. After you create an [Account Link](/api/account_links) or [Account Session](/api/account_sessions), this property is only returned for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.
   */
  business_type?: ('company' | 'government_entity' | 'individual' | 'non_profit') | null;
  capabilities?: account_capabilities;
  /**
   * Whether the account can create live charges.
   */
  charges_enabled?: boolean;
  company?: legal_entity_company;
  controller?: account_unification_account_controller;
  /**
   * The account's country.
   */
  country?: string;
  /**
   * Time at which the account was connected. Measured in seconds since the Unix epoch.
   */
  created?: number;
  /**
   * Three-letter ISO currency code representing the default currency for the account. This must be a currency that [Stripe supports in the account's country](https://stripe.com/docs/payouts).
   */
  default_currency?: string;
  /**
   * Whether account details have been submitted. Accounts with Stripe Dashboard access, which includes Standard accounts, cannot receive payouts before this is true. Accounts where this is false should be directed to [an onboarding flow](/connect/onboarding) to finish submitting account details.
   */
  details_submitted?: boolean;
  /**
   * An email address associated with the account. It's not used for authentication and Stripe doesn't market to this field without explicit approval from the platform.
   */
  email?: string | null;
  /**
   * External accounts (bank accounts and debit cards) currently attached to this account. External accounts are only returned for requests where `controller[is_controller]` is true.
   */
  external_accounts?: {
    /**
     * The list contains all external accounts that have been attached to the Stripe account. These may be bank accounts or cards.
     */
    data: Array<bank_account | card>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  future_requirements?: account_future_requirements;
  /**
   * Unique identifier for the object.
   */
  id: string;
  individual?: person;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'account';
  /**
   * Whether Stripe can send payouts to this account.
   */
  payouts_enabled?: boolean;
  requirements?: account_requirements;
  /**
   * Options for customizing how the account functions within Stripe.
   */
  settings?: account_settings | null;
  tos_acceptance?: account_tos_acceptance;
  /**
   * The Stripe account type. Can be `standard`, `express`, `custom`, or `none`.
   */
  type?: 'custom' | 'express' | 'none' | 'standard';
};

/**
 * The business type. After you create an [Account Link](/api/account_links) or [Account Session](/api/account_sessions), this property is only returned for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.
 */
export type business_type = 'company' | 'government_entity' | 'individual' | 'non_profit';

/**
 * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
 */
export type stripe_object = 'list';

/**
 * The Stripe account type. Can be `standard`, `express`, `custom`, or `none`.
 */
export type type = 'custom' | 'express' | 'none' | 'standard';

export type account_annual_revenue = {
  /**
   * A non-negative integer representing the amount in the [smallest currency unit](https://docs.stripe.com/currencies#zero-decimal).
   */
  amount?: number | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency?: string | null;
  /**
   * The close-out date of the preceding fiscal year in ISO 8601 format. E.g. 2023-12-31 for the 31st of December, 2023.
   */
  fiscal_year_end?: string | null;
};

export type account_bacs_debit_payments_settings = {
  /**
   * The Bacs Direct Debit display name for this account. For payments made with Bacs Direct Debit, this name appears on the mandate as the statement descriptor. Mobile banking apps display it as the name of the business. To use custom branding, set the Bacs Direct Debit Display Name during or right after creation. Custom branding incurs an additional monthly fee for the platform. The fee appears 5 business days after requesting Bacs. If you don't set the display name before requesting Bacs capability, it's automatically set as "Stripe" and the account is onboarded to Stripe branding, which is free.
   */
  display_name?: string | null;
  /**
   * The Bacs Direct Debit Service user number for this account. For payments made with Bacs Direct Debit, this number is a unique identifier of the account with our banking partners.
   */
  service_user_number?: string | null;
};

export type account_branding_settings = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) An icon for the account. Must be square and at least 128px x 128px.
   */
  icon?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) A logo for the account that will be used in Checkout instead of the icon and without the account's name next to it if provided. Must be at least 128px x 128px.
   */
  logo?: (string | file) | null;
  /**
   * A CSS hex color value representing the primary branding color for this account
   */
  primary_color?: string | null;
  /**
   * A CSS hex color value representing the secondary branding color for this account
   */
  secondary_color?: string | null;
};

export type account_business_profile = {
  /**
   * The applicant's gross annual revenue for its preceding fiscal year.
   */
  annual_revenue?: account_annual_revenue | null;
  /**
   * An estimated upper bound of employees, contractors, vendors, etc. currently working for the business.
   */
  estimated_worker_count?: number | null;
  /**
   * [The merchant category code for the account](https://stripe.com/docs/connect/setting-mcc). MCCs are used to classify businesses based on the goods or services they provide.
   */
  mcc?: string | null;
  monthly_estimated_revenue?: account_monthly_estimated_revenue;
  /**
   * The customer-facing business name.
   */
  name?: string | null;
  /**
   * Internal-only description of the product sold or service provided by the business. It's used by Stripe for risk and underwriting purposes.
   */
  product_description?: string | null;
  /**
   * A publicly available mailing address for sending support issues to.
   */
  support_address?: address | null;
  /**
   * A publicly available email address for sending support issues to.
   */
  support_email?: string | null;
  /**
   * A publicly available phone number to call with support issues.
   */
  support_phone?: string | null;
  /**
   * A publicly available website for handling support issues.
   */
  support_url?: string | null;
  /**
   * The business's publicly available website.
   */
  url?: string | null;
};

export type account_capabilities = {
  /**
   * The status of the Canadian pre-authorized debits payments capability of the account, or whether the account can directly process Canadian pre-authorized debits charges.
   */
  acss_debit_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Affirm capability of the account, or whether the account can directly process Affirm charges.
   */
  affirm_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Afterpay Clearpay capability of the account, or whether the account can directly process Afterpay Clearpay charges.
   */
  afterpay_clearpay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the AmazonPay capability of the account, or whether the account can directly process AmazonPay payments.
   */
  amazon_pay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the BECS Direct Debit (AU) payments capability of the account, or whether the account can directly process BECS Direct Debit (AU) charges.
   */
  au_becs_debit_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Bacs Direct Debits payments capability of the account, or whether the account can directly process Bacs Direct Debits charges.
   */
  bacs_debit_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Bancontact payments capability of the account, or whether the account can directly process Bancontact charges.
   */
  bancontact_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the customer_balance payments capability of the account, or whether the account can directly process customer_balance charges.
   */
  bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the blik payments capability of the account, or whether the account can directly process blik charges.
   */
  blik_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the boleto payments capability of the account, or whether the account can directly process boleto charges.
   */
  boleto_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the card issuing capability of the account, or whether you can use Issuing to distribute funds on cards
   */
  card_issuing?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the card payments capability of the account, or whether the account can directly process credit and debit card charges.
   */
  card_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Cartes Bancaires payments capability of the account, or whether the account can directly process Cartes Bancaires card charges in EUR currency.
   */
  cartes_bancaires_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Cash App Pay capability of the account, or whether the account can directly process Cash App Pay payments.
   */
  cashapp_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the EPS payments capability of the account, or whether the account can directly process EPS charges.
   */
  eps_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the FPX payments capability of the account, or whether the account can directly process FPX charges.
   */
  fpx_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the GB customer_balance payments (GBP currency) capability of the account, or whether the account can directly process GB customer_balance charges.
   */
  gb_bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the giropay payments capability of the account, or whether the account can directly process giropay charges.
   */
  giropay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the GrabPay payments capability of the account, or whether the account can directly process GrabPay charges.
   */
  grabpay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the iDEAL payments capability of the account, or whether the account can directly process iDEAL charges.
   */
  ideal_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the india_international_payments capability of the account, or whether the account can process international charges (non INR) in India.
   */
  india_international_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the JCB payments capability of the account, or whether the account (Japan only) can directly process JCB credit card charges in JPY currency.
   */
  jcb_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Japanese customer_balance payments (JPY currency) capability of the account, or whether the account can directly process Japanese customer_balance charges.
   */
  jp_bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Klarna payments capability of the account, or whether the account can directly process Klarna charges.
   */
  klarna_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the konbini payments capability of the account, or whether the account can directly process konbini charges.
   */
  konbini_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the legacy payments capability of the account.
   */
  legacy_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the link_payments capability of the account, or whether the account can directly process Link charges.
   */
  link_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the MobilePay capability of the account, or whether the account can directly process MobilePay charges.
   */
  mobilepay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Multibanco payments capability of the account, or whether the account can directly process Multibanco charges.
   */
  multibanco_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Mexican customer_balance payments (MXN currency) capability of the account, or whether the account can directly process Mexican customer_balance charges.
   */
  mx_bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the OXXO payments capability of the account, or whether the account can directly process OXXO charges.
   */
  oxxo_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the P24 payments capability of the account, or whether the account can directly process P24 charges.
   */
  p24_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the paynow payments capability of the account, or whether the account can directly process paynow charges.
   */
  paynow_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the promptpay payments capability of the account, or whether the account can directly process promptpay charges.
   */
  promptpay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the RevolutPay capability of the account, or whether the account can directly process RevolutPay payments.
   */
  revolut_pay_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the SEPA customer_balance payments (EUR currency) capability of the account, or whether the account can directly process SEPA customer_balance charges.
   */
  sepa_bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the SEPA Direct Debits payments capability of the account, or whether the account can directly process SEPA Direct Debits charges.
   */
  sepa_debit_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Sofort payments capability of the account, or whether the account can directly process Sofort charges.
   */
  sofort_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Swish capability of the account, or whether the account can directly process Swish payments.
   */
  swish_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the tax reporting 1099-K (US) capability of the account.
   */
  tax_reporting_us_1099_k?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the tax reporting 1099-MISC (US) capability of the account.
   */
  tax_reporting_us_1099_misc?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the transfers capability of the account, or whether your platform can transfer funds to the account.
   */
  transfers?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the banking capability, or whether the account can have bank accounts.
   */
  treasury?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the TWINT capability of the account, or whether the account can directly process TWINT charges.
   */
  twint_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the US bank account ACH payments capability of the account, or whether the account can directly process US bank account charges.
   */
  us_bank_account_ach_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the US customer_balance payments (USD currency) capability of the account, or whether the account can directly process US customer_balance charges.
   */
  us_bank_transfer_payments?: 'active' | 'inactive' | 'pending';
  /**
   * The status of the Zip capability of the account, or whether the account can directly process Zip charges.
   */
  zip_payments?: 'active' | 'inactive' | 'pending';
};

/**
 * The status of the Canadian pre-authorized debits payments capability of the account, or whether the account can directly process Canadian pre-authorized debits charges.
 */
export type acss_debit_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Affirm capability of the account, or whether the account can directly process Affirm charges.
 */
export type affirm_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Afterpay Clearpay capability of the account, or whether the account can directly process Afterpay Clearpay charges.
 */
export type afterpay_clearpay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the AmazonPay capability of the account, or whether the account can directly process AmazonPay payments.
 */
export type amazon_pay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the BECS Direct Debit (AU) payments capability of the account, or whether the account can directly process BECS Direct Debit (AU) charges.
 */
export type au_becs_debit_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Bacs Direct Debits payments capability of the account, or whether the account can directly process Bacs Direct Debits charges.
 */
export type bacs_debit_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Bancontact payments capability of the account, or whether the account can directly process Bancontact charges.
 */
export type bancontact_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the customer_balance payments capability of the account, or whether the account can directly process customer_balance charges.
 */
export type bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the blik payments capability of the account, or whether the account can directly process blik charges.
 */
export type blik_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the boleto payments capability of the account, or whether the account can directly process boleto charges.
 */
export type boleto_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the card issuing capability of the account, or whether you can use Issuing to distribute funds on cards
 */
export type card_issuing = 'active' | 'inactive' | 'pending';

/**
 * The status of the card payments capability of the account, or whether the account can directly process credit and debit card charges.
 */
export type card_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Cartes Bancaires payments capability of the account, or whether the account can directly process Cartes Bancaires card charges in EUR currency.
 */
export type cartes_bancaires_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Cash App Pay capability of the account, or whether the account can directly process Cash App Pay payments.
 */
export type cashapp_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the EPS payments capability of the account, or whether the account can directly process EPS charges.
 */
export type eps_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the FPX payments capability of the account, or whether the account can directly process FPX charges.
 */
export type fpx_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the GB customer_balance payments (GBP currency) capability of the account, or whether the account can directly process GB customer_balance charges.
 */
export type gb_bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the giropay payments capability of the account, or whether the account can directly process giropay charges.
 */
export type giropay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the GrabPay payments capability of the account, or whether the account can directly process GrabPay charges.
 */
export type grabpay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the iDEAL payments capability of the account, or whether the account can directly process iDEAL charges.
 */
export type ideal_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the india_international_payments capability of the account, or whether the account can process international charges (non INR) in India.
 */
export type india_international_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the JCB payments capability of the account, or whether the account (Japan only) can directly process JCB credit card charges in JPY currency.
 */
export type jcb_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Japanese customer_balance payments (JPY currency) capability of the account, or whether the account can directly process Japanese customer_balance charges.
 */
export type jp_bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Klarna payments capability of the account, or whether the account can directly process Klarna charges.
 */
export type klarna_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the konbini payments capability of the account, or whether the account can directly process konbini charges.
 */
export type konbini_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the legacy payments capability of the account.
 */
export type legacy_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the link_payments capability of the account, or whether the account can directly process Link charges.
 */
export type link_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the MobilePay capability of the account, or whether the account can directly process MobilePay charges.
 */
export type mobilepay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Multibanco payments capability of the account, or whether the account can directly process Multibanco charges.
 */
export type multibanco_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Mexican customer_balance payments (MXN currency) capability of the account, or whether the account can directly process Mexican customer_balance charges.
 */
export type mx_bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the OXXO payments capability of the account, or whether the account can directly process OXXO charges.
 */
export type oxxo_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the P24 payments capability of the account, or whether the account can directly process P24 charges.
 */
export type p24_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the paynow payments capability of the account, or whether the account can directly process paynow charges.
 */
export type paynow_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the promptpay payments capability of the account, or whether the account can directly process promptpay charges.
 */
export type promptpay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the RevolutPay capability of the account, or whether the account can directly process RevolutPay payments.
 */
export type revolut_pay_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the SEPA customer_balance payments (EUR currency) capability of the account, or whether the account can directly process SEPA customer_balance charges.
 */
export type sepa_bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the SEPA Direct Debits payments capability of the account, or whether the account can directly process SEPA Direct Debits charges.
 */
export type sepa_debit_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Sofort payments capability of the account, or whether the account can directly process Sofort charges.
 */
export type sofort_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Swish capability of the account, or whether the account can directly process Swish payments.
 */
export type swish_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the tax reporting 1099-K (US) capability of the account.
 */
export type tax_reporting_us_1099_k = 'active' | 'inactive' | 'pending';

/**
 * The status of the tax reporting 1099-MISC (US) capability of the account.
 */
export type tax_reporting_us_1099_misc = 'active' | 'inactive' | 'pending';

/**
 * The status of the transfers capability of the account, or whether your platform can transfer funds to the account.
 */
export type transfers = 'active' | 'inactive' | 'pending';

/**
 * The status of the banking capability, or whether the account can have bank accounts.
 */
export type treasury = 'active' | 'inactive' | 'pending';

/**
 * The status of the TWINT capability of the account, or whether the account can directly process TWINT charges.
 */
export type twint_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the US bank account ACH payments capability of the account, or whether the account can directly process US bank account charges.
 */
export type us_bank_account_ach_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the US customer_balance payments (USD currency) capability of the account, or whether the account can directly process US customer_balance charges.
 */
export type us_bank_transfer_payments = 'active' | 'inactive' | 'pending';

/**
 * The status of the Zip capability of the account, or whether the account can directly process Zip charges.
 */
export type zip_payments = 'active' | 'inactive' | 'pending';

export type account_capability_future_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Date on which `future_requirements` merges with the main `requirements` hash and `future_requirements` becomes empty. After the transition, `currently_due` requirements may immediately become `past_due`, but the account may also be given a grace period depending on the capability's enablement state prior to transitioning.
   */
  current_deadline?: number | null;
  /**
   * Fields that need to be collected to keep the capability enabled. If not collected by `future_requirements[current_deadline]`, these fields will transition to the main `requirements` hash.
   */
  currently_due: Array<string>;
  /**
   * This is typed as a string for consistency with `requirements.disabled_reason`, but it safe to assume `future_requirements.disabled_reason` is empty because fields in `future_requirements` will never disable the account.
   */
  disabled_reason?: string | null;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors: Array<account_requirements_error>;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well.
   */
  eventually_due: Array<string>;
  /**
   * Fields that weren't collected by `requirements.current_deadline`. These fields need to be collected to enable the capability on the account. New fields will never appear here; `future_requirements.past_due` will always be a subset of `requirements.past_due`.
   */
  past_due: Array<string>;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due` or `currently_due`. Fields might appear in `eventually_due` or `currently_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification: Array<string>;
};

export type account_capability_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Date by which the fields in `currently_due` must be collected to keep the capability enabled for the account. These fields may disable the capability sooner if the next threshold is reached before they are collected.
   */
  current_deadline?: number | null;
  /**
   * Fields that need to be collected to keep the capability enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the capability is disabled.
   */
  currently_due: Array<string>;
  /**
   * If the capability is disabled, this string describes why. [Learn more about handling verification issues](https://stripe.com/docs/connect/handling-api-verification). Can be `requirements.fields_needed`, `pending.onboarding`, `pending.review`, `rejected.other`, `platform_paused`, `rejected.inactivty`, or `rejected.unsupported_business`.
   *
   * `rejected.unsupported_business` means that the account's business is not supported by the capability. For example, payment methods may restrict the businesses they support in their terms of service, such as in [Afterpay Clearpay's terms of service](/afterpay-clearpay/legal#restricted-businesses).
   *
   * `rejected.inactivity` means that the capability has been paused for inactivity. This disabled reason currently only applies to the Issuing capability. See [Issuing: Managing Inactive Connects](https://support.stripe.com/questions/issuing-managing-inactive-connect-accounts) for more details.
   */
  disabled_reason?: string | null;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors: Array<account_requirements_error>;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and `current_deadline` becomes set.
   */
  eventually_due: Array<string>;
  /**
   * Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the capability on the account.
   */
  past_due: Array<string>;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification: Array<string>;
};

export type account_card_issuing_settings = {
  tos_acceptance?: card_issuing_account_terms_of_service;
};

export type account_card_payments_settings = {
  decline_on?: account_decline_charge_on;
  /**
   * The default text that appears on credit card statements when a charge is made. This field prefixes any dynamic `statement_descriptor` specified on the charge. `statement_descriptor_prefix` is useful for maximizing descriptor space for the dynamic portion.
   */
  statement_descriptor_prefix?: string | null;
  /**
   * The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kana` specified on the charge. `statement_descriptor_prefix_kana` is useful for maximizing descriptor space for the dynamic portion.
   */
  statement_descriptor_prefix_kana?: string | null;
  /**
   * The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kanji` specified on the charge. `statement_descriptor_prefix_kanji` is useful for maximizing descriptor space for the dynamic portion.
   */
  statement_descriptor_prefix_kanji?: string | null;
};

export type account_dashboard_settings = {
  /**
   * The display name for this account. This is used on the Stripe Dashboard to differentiate between accounts.
   */
  display_name?: string | null;
  /**
   * The timezone used in the Stripe Dashboard for this account. A list of possible time zone values is maintained at the [IANA Time Zone Database](http://www.iana.org/time-zones).
   */
  timezone?: string | null;
};

export type account_decline_charge_on = {
  /**
   * Whether Stripe automatically declines charges with an incorrect ZIP or postal code. This setting only applies when a ZIP or postal code is provided and they fail bank verification.
   */
  avs_failure: boolean;
  /**
   * Whether Stripe automatically declines charges with an incorrect CVC. This setting only applies when a CVC is provided and it fails bank verification.
   */
  cvc_failure: boolean;
};

export type account_future_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Date on which `future_requirements` merges with the main `requirements` hash and `future_requirements` becomes empty. After the transition, `currently_due` requirements may immediately become `past_due`, but the account may also be given a grace period depending on its enablement state prior to transitioning.
   */
  current_deadline?: number | null;
  /**
   * Fields that need to be collected to keep the account enabled. If not collected by `future_requirements[current_deadline]`, these fields will transition to the main `requirements` hash.
   */
  currently_due?: Array<string> | null;
  /**
   * This is typed as a string for consistency with `requirements.disabled_reason`.
   */
  disabled_reason?: string | null;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors?: Array<account_requirements_error> | null;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well.
   */
  eventually_due?: Array<string> | null;
  /**
   * Fields that weren't collected by `requirements.current_deadline`. These fields need to be collected to enable the capability on the account. New fields will never appear here; `future_requirements.past_due` will always be a subset of `requirements.past_due`.
   */
  past_due?: Array<string> | null;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due` or `currently_due`. Fields might appear in `eventually_due` or `currently_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification?: Array<string> | null;
};

export type account_invoices_settings = {
  /**
   * The list of default Account Tax IDs to automatically include on invoices. Account Tax IDs get added when an invoice is finalized.
   */
  default_account_tax_ids?: Array<string | tax_id> | null;
};

/**
 * Account Links are the means by which a Connect platform grants a connected account permission to access
 * Stripe-hosted applications, such as Connect Onboarding.
 *
 * Related guide: [Connect Onboarding](https://stripe.com/docs/connect/custom/hosted-onboarding)
 */
export type account_link = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The timestamp at which this account link will expire.
   */
  expires_at: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'account_link';
  /**
   * The URL for the account link.
   */
  url: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object2 = 'account_link';

export type account_monthly_estimated_revenue = {
  /**
   * A non-negative integer representing how much to charge in the [smallest currency unit](https://docs.stripe.com/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
};

export type account_payments_settings = {
  /**
   * The default text that appears on credit card statements when a charge is made. This field prefixes any dynamic `statement_descriptor` specified on the charge.
   */
  statement_descriptor?: string | null;
  /**
   * The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only)
   */
  statement_descriptor_kana?: string | null;
  /**
   * The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only)
   */
  statement_descriptor_kanji?: string | null;
  /**
   * The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kana` specified on the charge. `statement_descriptor_prefix_kana` is useful for maximizing descriptor space for the dynamic portion.
   */
  statement_descriptor_prefix_kana?: string | null;
  /**
   * The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kanji` specified on the charge. `statement_descriptor_prefix_kanji` is useful for maximizing descriptor space for the dynamic portion.
   */
  statement_descriptor_prefix_kanji?: string | null;
};

export type account_payout_settings = {
  /**
   * A Boolean indicating if Stripe should try to reclaim negative balances from an attached bank account. See [Understanding Connect account balances](/connect/account-balances) for details. The default value is `false` when [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts, otherwise `true`.
   */
  debit_negative_balances: boolean;
  schedule: transfer_schedule;
  /**
   * The text that appears on the bank account statement for payouts. If not set, this defaults to the platform's bank descriptor as set in the Dashboard.
   */
  statement_descriptor?: string | null;
};

export type account_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Date by which the fields in `currently_due` must be collected to keep the account enabled. These fields may disable the account sooner if the next threshold is reached before they are collected.
   */
  current_deadline?: number | null;
  /**
   * Fields that need to be collected to keep the account enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the account is disabled.
   */
  currently_due?: Array<string> | null;
  /**
   * If the account is disabled, this string describes why. [Learn more about handling verification issues](https://stripe.com/docs/connect/handling-api-verification). Can be `action_required.requested_capabilities`, `requirements.past_due`, `requirements.pending_verification`, `listed`, `platform_paused`, `rejected.fraud`, `rejected.incomplete_verification`, `rejected.listed`, `rejected.other`, `rejected.terms_of_service`, `under_review`, or `other`.
   */
  disabled_reason?: string | null;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors?: Array<account_requirements_error> | null;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and `current_deadline` becomes set.
   */
  eventually_due?: Array<string> | null;
  /**
   * Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the account.
   */
  past_due?: Array<string> | null;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification?: Array<string> | null;
};

export type account_requirements_alternative = {
  /**
   * Fields that can be provided to satisfy all fields in `original_fields_due`.
   */
  alternative_fields_due: Array<string>;
  /**
   * Fields that are due and can be satisfied by providing all fields in `alternative_fields_due`.
   */
  original_fields_due: Array<string>;
};

export type account_requirements_error = {
  /**
   * The code for the type of error.
   */
  code:
    | 'invalid_address_city_state_postal_code'
    | 'invalid_address_highway_contract_box'
    | 'invalid_address_private_mailbox'
    | 'invalid_business_profile_name'
    | 'invalid_business_profile_name_denylisted'
    | 'invalid_company_name_denylisted'
    | 'invalid_dob_age_over_maximum'
    | 'invalid_dob_age_under_18'
    | 'invalid_dob_age_under_minimum'
    | 'invalid_product_description_length'
    | 'invalid_product_description_url_match'
    | 'invalid_representative_country'
    | 'invalid_statement_descriptor_business_mismatch'
    | 'invalid_statement_descriptor_denylisted'
    | 'invalid_statement_descriptor_length'
    | 'invalid_statement_descriptor_prefix_denylisted'
    | 'invalid_statement_descriptor_prefix_mismatch'
    | 'invalid_street_address'
    | 'invalid_tax_id'
    | 'invalid_tax_id_format'
    | 'invalid_tos_acceptance'
    | 'invalid_url_denylisted'
    | 'invalid_url_format'
    | 'invalid_url_web_presence_detected'
    | 'invalid_url_website_business_information_mismatch'
    | 'invalid_url_website_empty'
    | 'invalid_url_website_inaccessible'
    | 'invalid_url_website_inaccessible_geoblocked'
    | 'invalid_url_website_inaccessible_password_protected'
    | 'invalid_url_website_incomplete'
    | 'invalid_url_website_incomplete_cancellation_policy'
    | 'invalid_url_website_incomplete_customer_service_details'
    | 'invalid_url_website_incomplete_legal_restrictions'
    | 'invalid_url_website_incomplete_refund_policy'
    | 'invalid_url_website_incomplete_return_policy'
    | 'invalid_url_website_incomplete_terms_and_conditions'
    | 'invalid_url_website_incomplete_under_construction'
    | 'invalid_url_website_other'
    | 'invalid_value_other'
    | 'verification_directors_mismatch'
    | 'verification_document_address_mismatch'
    | 'verification_document_address_missing'
    | 'verification_document_corrupt'
    | 'verification_document_country_not_supported'
    | 'verification_document_directors_mismatch'
    | 'verification_document_dob_mismatch'
    | 'verification_document_duplicate_type'
    | 'verification_document_expired'
    | 'verification_document_failed_copy'
    | 'verification_document_failed_greyscale'
    | 'verification_document_failed_other'
    | 'verification_document_failed_test_mode'
    | 'verification_document_fraudulent'
    | 'verification_document_id_number_mismatch'
    | 'verification_document_id_number_missing'
    | 'verification_document_incomplete'
    | 'verification_document_invalid'
    | 'verification_document_issue_or_expiry_date_missing'
    | 'verification_document_manipulated'
    | 'verification_document_missing_back'
    | 'verification_document_missing_front'
    | 'verification_document_name_mismatch'
    | 'verification_document_name_missing'
    | 'verification_document_nationality_mismatch'
    | 'verification_document_not_readable'
    | 'verification_document_not_signed'
    | 'verification_document_not_uploaded'
    | 'verification_document_photo_mismatch'
    | 'verification_document_too_large'
    | 'verification_document_type_not_supported'
    | 'verification_extraneous_directors'
    | 'verification_failed_address_match'
    | 'verification_failed_business_iec_number'
    | 'verification_failed_document_match'
    | 'verification_failed_id_number_match'
    | 'verification_failed_keyed_identity'
    | 'verification_failed_keyed_match'
    | 'verification_failed_name_match'
    | 'verification_failed_other'
    | 'verification_failed_representative_authority'
    | 'verification_failed_residential_address'
    | 'verification_failed_tax_id_match'
    | 'verification_failed_tax_id_not_issued'
    | 'verification_missing_directors'
    | 'verification_missing_executives'
    | 'verification_missing_owners'
    | 'verification_requires_additional_memorandum_of_associations'
    | 'verification_requires_additional_proof_of_registration';
  /**
   * An informative message that indicates the error type and provides additional details about the error.
   */
  reason: string;
  /**
   * The specific user onboarding requirement field (in the requirements hash) that needs to be resolved.
   */
  requirement: string;
};

/**
 * The code for the type of error.
 */
export type code =
  | 'invalid_address_city_state_postal_code'
  | 'invalid_address_highway_contract_box'
  | 'invalid_address_private_mailbox'
  | 'invalid_business_profile_name'
  | 'invalid_business_profile_name_denylisted'
  | 'invalid_company_name_denylisted'
  | 'invalid_dob_age_over_maximum'
  | 'invalid_dob_age_under_18'
  | 'invalid_dob_age_under_minimum'
  | 'invalid_product_description_length'
  | 'invalid_product_description_url_match'
  | 'invalid_representative_country'
  | 'invalid_statement_descriptor_business_mismatch'
  | 'invalid_statement_descriptor_denylisted'
  | 'invalid_statement_descriptor_length'
  | 'invalid_statement_descriptor_prefix_denylisted'
  | 'invalid_statement_descriptor_prefix_mismatch'
  | 'invalid_street_address'
  | 'invalid_tax_id'
  | 'invalid_tax_id_format'
  | 'invalid_tos_acceptance'
  | 'invalid_url_denylisted'
  | 'invalid_url_format'
  | 'invalid_url_web_presence_detected'
  | 'invalid_url_website_business_information_mismatch'
  | 'invalid_url_website_empty'
  | 'invalid_url_website_inaccessible'
  | 'invalid_url_website_inaccessible_geoblocked'
  | 'invalid_url_website_inaccessible_password_protected'
  | 'invalid_url_website_incomplete'
  | 'invalid_url_website_incomplete_cancellation_policy'
  | 'invalid_url_website_incomplete_customer_service_details'
  | 'invalid_url_website_incomplete_legal_restrictions'
  | 'invalid_url_website_incomplete_refund_policy'
  | 'invalid_url_website_incomplete_return_policy'
  | 'invalid_url_website_incomplete_terms_and_conditions'
  | 'invalid_url_website_incomplete_under_construction'
  | 'invalid_url_website_other'
  | 'invalid_value_other'
  | 'verification_directors_mismatch'
  | 'verification_document_address_mismatch'
  | 'verification_document_address_missing'
  | 'verification_document_corrupt'
  | 'verification_document_country_not_supported'
  | 'verification_document_directors_mismatch'
  | 'verification_document_dob_mismatch'
  | 'verification_document_duplicate_type'
  | 'verification_document_expired'
  | 'verification_document_failed_copy'
  | 'verification_document_failed_greyscale'
  | 'verification_document_failed_other'
  | 'verification_document_failed_test_mode'
  | 'verification_document_fraudulent'
  | 'verification_document_id_number_mismatch'
  | 'verification_document_id_number_missing'
  | 'verification_document_incomplete'
  | 'verification_document_invalid'
  | 'verification_document_issue_or_expiry_date_missing'
  | 'verification_document_manipulated'
  | 'verification_document_missing_back'
  | 'verification_document_missing_front'
  | 'verification_document_name_mismatch'
  | 'verification_document_name_missing'
  | 'verification_document_nationality_mismatch'
  | 'verification_document_not_readable'
  | 'verification_document_not_signed'
  | 'verification_document_not_uploaded'
  | 'verification_document_photo_mismatch'
  | 'verification_document_too_large'
  | 'verification_document_type_not_supported'
  | 'verification_extraneous_directors'
  | 'verification_failed_address_match'
  | 'verification_failed_business_iec_number'
  | 'verification_failed_document_match'
  | 'verification_failed_id_number_match'
  | 'verification_failed_keyed_identity'
  | 'verification_failed_keyed_match'
  | 'verification_failed_name_match'
  | 'verification_failed_other'
  | 'verification_failed_representative_authority'
  | 'verification_failed_residential_address'
  | 'verification_failed_tax_id_match'
  | 'verification_failed_tax_id_not_issued'
  | 'verification_missing_directors'
  | 'verification_missing_executives'
  | 'verification_missing_owners'
  | 'verification_requires_additional_memorandum_of_associations'
  | 'verification_requires_additional_proof_of_registration';

export type account_sepa_debit_payments_settings = {
  /**
   * SEPA creditor identifier that identifies the company making the payment.
   */
  creditor_id?: string;
};

/**
 * An AccountSession allows a Connect platform to grant access to a connected account in Connect embedded components.
 *
 * We recommend that you create an AccountSession each time you need to display an embedded component
 * to your user. Do not save AccountSessions to your database as they expire relatively
 * quickly, and cannot be used more than once.
 *
 * Related guide: [Connect embedded components](https://stripe.com/docs/connect/get-started-connect-embedded-components)
 */
export type account_session = {
  /**
   * The ID of the account the AccountSession was created for
   */
  account: string;
  /**
   * The client secret of this AccountSession. Used on the client to set up secure access to the given `account`.
   *
   * The client secret can be used to provide access to `account` from your frontend. It should not be stored, logged, or exposed to anyone other than the connected account. Make sure that you have TLS enabled on any page that includes the client secret.
   *
   * Refer to our docs to [setup Connect embedded components](https://stripe.com/docs/connect/get-started-connect-embedded-components) and learn about how `client_secret` should be handled.
   */
  client_secret: string;
  components: connect_embedded_account_session_create_components;
  /**
   * The timestamp at which this AccountSession will expire.
   */
  expires_at: number;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'account_session';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object3 = 'account_session';

export type account_settings = {
  bacs_debit_payments?: account_bacs_debit_payments_settings;
  branding: account_branding_settings;
  card_issuing?: account_card_issuing_settings;
  card_payments: account_card_payments_settings;
  dashboard: account_dashboard_settings;
  invoices?: account_invoices_settings;
  payments: account_payments_settings;
  payouts?: account_payout_settings;
  sepa_debit_payments?: account_sepa_debit_payments_settings;
  treasury?: account_treasury_settings;
};

export type account_terms_of_service = {
  /**
   * The Unix timestamp marking when the account representative accepted the service agreement.
   */
  date?: number | null;
  /**
   * The IP address from which the account representative accepted the service agreement.
   */
  ip?: string | null;
  /**
   * The user agent of the browser from which the account representative accepted the service agreement.
   */
  user_agent?: string;
};

export type account_tos_acceptance = {
  /**
   * The Unix timestamp marking when the account representative accepted their service agreement
   */
  date?: number | null;
  /**
   * The IP address from which the account representative accepted their service agreement
   */
  ip?: string | null;
  /**
   * The user's service agreement type
   */
  service_agreement?: string;
  /**
   * The user agent of the browser from which the account representative accepted their service agreement
   */
  user_agent?: string | null;
};

export type account_treasury_settings = {
  tos_acceptance?: account_terms_of_service;
};

export type account_unification_account_controller = {
  fees?: account_unification_account_controller_fees;
  /**
   * `true` if the Connect application retrieving the resource controls the account and can therefore exercise [platform controls](https://stripe.com/docs/connect/platform-controls-for-standard-accounts). Otherwise, this field is null.
   */
  is_controller?: boolean;
  losses?: account_unification_account_controller_losses;
  /**
   * A value indicating responsibility for collecting requirements on this account. Only returned when the Connect application retrieving the resource controls the account.
   */
  requirement_collection?: 'application' | 'stripe';
  stripe_dashboard?: account_unification_account_controller_stripe_dashboard;
  /**
   * The controller type. Can be `application`, if a Connect application controls the account, or `account`, if the account controls itself.
   */
  type: 'account' | 'application';
};

/**
 * A value indicating responsibility for collecting requirements on this account. Only returned when the Connect application retrieving the resource controls the account.
 */
export type requirement_collection = 'application' | 'stripe';

/**
 * The controller type. Can be `application`, if a Connect application controls the account, or `account`, if the account controls itself.
 */
export type type2 = 'account' | 'application';

export type account_unification_account_controller_fees = {
  /**
   * A value indicating the responsible payer of a bundle of Stripe fees for pricing-control eligible products on this account. Learn more about [fee behavior on connected accounts](https://docs.stripe.com/connect/direct-charges-fee-payer-behavior).
   */
  payer: 'account' | 'application' | 'application_custom' | 'application_express';
};

/**
 * A value indicating the responsible payer of a bundle of Stripe fees for pricing-control eligible products on this account. Learn more about [fee behavior on connected accounts](https://docs.stripe.com/connect/direct-charges-fee-payer-behavior).
 */
export type payer = 'account' | 'application' | 'application_custom' | 'application_express';

export type account_unification_account_controller_losses = {
  /**
   * A value indicating who is liable when this account can't pay back negative balances from payments.
   */
  payments: 'application' | 'stripe';
};

/**
 * A value indicating who is liable when this account can't pay back negative balances from payments.
 */
export type payments = 'application' | 'stripe';

export type account_unification_account_controller_stripe_dashboard = {
  /**
   * A value indicating the Stripe dashboard this account has access to independent of the Connect application.
   */
  type: 'express' | 'full' | 'none';
};

/**
 * A value indicating the Stripe dashboard this account has access to independent of the Connect application.
 */
export type type3 = 'express' | 'full' | 'none';

export type address = {
  /**
   * City, district, suburb, town, or village.
   */
  city?: string | null;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country?: string | null;
  /**
   * Address line 1 (e.g., street, PO Box, or company name).
   */
  line1?: string | null;
  /**
   * Address line 2 (e.g., apartment, suite, unit, or building).
   */
  line2?: string | null;
  /**
   * ZIP or postal code.
   */
  postal_code?: string | null;
  /**
   * State, county, province, or region.
   */
  state?: string | null;
};

export type api_errors = {
  /**
   * For card errors, the ID of the failed charge.
   */
  charge?: string;
  /**
   * For some errors that could be handled programmatically, a short string indicating the [error code](https://stripe.com/docs/error-codes) reported.
   */
  code?: string;
  /**
   * For card errors resulting from a card issuer decline, a short string indicating the [card issuer's reason for the decline](https://stripe.com/docs/declines#issuer-declines) if they provide one.
   */
  decline_code?: string;
  /**
   * A URL to more information about the [error code](https://stripe.com/docs/error-codes) reported.
   */
  doc_url?: string;
  /**
   * A human-readable message providing more details about the error. For card errors, these messages can be shown to your users.
   */
  message?: string;
  /**
   * If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field.
   */
  param?: string;
  payment_intent?: payment_intent;
  payment_method?: payment_method;
  /**
   * If the error is specific to the type of payment method, the payment method type that had a problem. This field is only populated for invoice-related errors.
   */
  payment_method_type?: string;
  /**
   * A URL to the request log entry in your dashboard.
   */
  request_log_url?: string;
  setup_intent?: setup_intent;
  /**
   * The [source object](https://stripe.com/docs/api/sources/object) for errors returned on a request involving a source.
   */
  source?: bank_account | card | source;
  /**
   * The type of error returned. One of `api_error`, `card_error`, `idempotency_error`, or `invalid_request_error`
   */
  type: 'api_error' | 'card_error' | 'idempotency_error' | 'invalid_request_error';
};

/**
 * The type of error returned. One of `api_error`, `card_error`, `idempotency_error`, or `invalid_request_error`
 */
export type type4 = 'api_error' | 'card_error' | 'idempotency_error' | 'invalid_request_error';

export type apple_pay_domain = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  domain_name: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'apple_pay_domain';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object4 = 'apple_pay_domain';

export type application = {
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The name of the application.
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'application';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object5 = 'application';

export type application_fee = {
  /**
   * ID of the Stripe account this fee was taken from.
   */
  account: string | account;
  /**
   * Amount earned, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Amount in cents (or local equivalent) refunded (can be less than the amount attribute on the fee if a partial refund was issued)
   */
  amount_refunded: number;
  /**
   * ID of the Connect application that earned the fee.
   */
  application: string | application;
  /**
   * Balance transaction that describes the impact of this collected application fee on your account balance (not including refunds).
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * ID of the charge that the application fee was taken from.
   */
  charge: string | charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Polymorphic source of the application fee. Includes the ID of the object the application fee was created from.
   */
  fee_source?: platform_earning_fee_source | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'application_fee';
  /**
   * ID of the corresponding charge on the platform account, if this fee was the result of a charge using the `destination` parameter.
   */
  originating_transaction?: (string | charge) | null;
  /**
   * Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute will still be false.
   */
  refunded: boolean;
  /**
   * A list of refunds that have been applied to the fee.
   */
  refunds: {
    /**
     * Details about each object.
     */
    data: Array<fee_refund>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object6 = 'application_fee';

/**
 * Secret Store is an API that allows Stripe Apps developers to securely persist secrets for use by UI Extensions and app backends.
 *
 * The primary resource in Secret Store is a `secret`. Other apps can't view secrets created by an app. Additionally, secrets are scoped to provide further permission control.
 *
 * All Dashboard users and the app backend share `account` scoped secrets. Use the `account` scope for secrets that don't change per-user, like a third-party API key.
 *
 * A `user` scoped secret is accessible by the app backend and one specific Dashboard user. Use the `user` scope for per-user secrets like per-user OAuth tokens, where different users might have different permissions.
 *
 * Related guide: [Store data between page reloads](https://stripe.com/docs/stripe-apps/store-auth-data-custom-objects)
 */
export type apps_secret = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * If true, indicates that this secret has been deleted
   */
  deleted?: boolean;
  /**
   * The Unix timestamp for the expiry time of the secret, after which the secret deletes.
   */
  expires_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A name for the secret that's unique within the scope.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'apps.secret';
  /**
   * The plaintext secret value to be stored.
   */
  payload?: string | null;
  scope: secret_service_resource_scope;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object7 = 'apps.secret';

export type automatic_tax = {
  /**
   * Whether Stripe automatically computes tax on this invoice. Note that incompatible invoice items (invoice items with manually specified [tax rates](https://stripe.com/docs/api/tax_rates), negative amounts, or `tax_behavior=unspecified`) cannot be added to automatic tax invoices.
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
  /**
   * The status of the most recent automated tax calculation for this invoice.
   */
  status?: ('complete' | 'failed' | 'requires_location_inputs') | null;
};

/**
 * The status of the most recent automated tax calculation for this invoice.
 */
export type status = 'complete' | 'failed' | 'requires_location_inputs';

/**
 * This is an object representing your Stripe balance. You can retrieve it to see
 * the balance currently on your Stripe account.
 *
 * You can also retrieve the balance history, which contains a list of
 * [transactions](https://stripe.com/docs/reporting/balance-transaction-types) that contributed to the balance
 * (charges, payouts, and so forth).
 *
 * The available and pending amounts for each currency are broken down further by
 * payment source types.
 *
 * Related guide: [Understanding Connect account balances](https://stripe.com/docs/connect/account-balances)
 */
export type balance = {
  /**
   * Available funds that you can transfer or pay out automatically by Stripe or explicitly through the [Transfers API](https://stripe.com/docs/api#transfers) or [Payouts API](https://stripe.com/docs/api#payouts). You can find the available balance for each currency and payment type in the `source_types` property.
   */
  available: Array<balance_amount>;
  /**
   * Funds held due to negative balances on connected accounts where [account.controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts. You can find the connect reserve balance for each currency and payment type in the `source_types` property.
   */
  connect_reserved?: Array<balance_amount>;
  /**
   * Funds that you can pay out using Instant Payouts.
   */
  instant_available?: Array<balance_amount_net>;
  issuing?: balance_detail;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'balance';
  /**
   * Funds that aren't available in the balance yet. You can find the pending balance for each currency and each payment type in the `source_types` property.
   */
  pending: Array<balance_amount>;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object8 = 'balance';

export type balance_amount = {
  /**
   * Balance amount.
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  source_types?: balance_amount_by_source_type;
};

export type balance_amount_by_source_type = {
  /**
   * Amount for bank account.
   */
  bank_account?: number;
  /**
   * Amount for card.
   */
  card?: number;
  /**
   * Amount for FPX.
   */
  fpx?: number;
};

export type balance_amount_net = {
  /**
   * Balance amount.
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Breakdown of balance by destination.
   */
  net_available?: Array<balance_net_available>;
  source_types?: balance_amount_by_source_type;
};

export type balance_detail = {
  /**
   * Funds that are available for use.
   */
  available: Array<balance_amount>;
};

export type balance_net_available = {
  /**
   * Net balance amount, subtracting fees from platform-set pricing.
   */
  amount: number;
  /**
   * ID of the external account for this net balance (not expandable).
   */
  destination: string;
  source_types?: balance_amount_by_source_type;
};

/**
 * Balance transactions represent funds moving through your Stripe account.
 * Stripe creates them for every type of transaction that enters or leaves your Stripe account balance.
 *
 * Related guide: [Balance transaction types](https://stripe.com/docs/reports/balance-transaction-types)
 */
export type balance_transaction = {
  /**
   * Gross amount of this transaction (in cents (or local equivalent)). A positive value represents funds charged to another party, and a negative value represents funds sent to another party.
   */
  amount: number;
  /**
   * The date that the transaction's net funds become available in the Stripe balance.
   */
  available_on: number;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * If applicable, this transaction uses an exchange rate. If money converts from currency A to currency B, then the `amount` in currency A, multipled by the `exchange_rate`, equals the `amount` in currency B. For example, if you charge a customer 10.00 EUR, the PaymentIntent's `amount` is `1000` and `currency` is `eur`. If this converts to 12.34 USD in your Stripe account, the BalanceTransaction's `amount` is `1234`, its `currency` is `usd`, and the `exchange_rate` is `1.234`.
   */
  exchange_rate?: number | null;
  /**
   * Fees (in cents (or local equivalent)) paid for this transaction. Represented as a positive integer when assessed.
   */
  fee: number;
  /**
   * Detailed breakdown of fees (in cents (or local equivalent)) paid for this transaction.
   */
  fee_details: Array<fee>;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Net impact to a Stripe balance (in cents (or local equivalent)). A positive value represents incrementing a Stripe balance, and a negative value decrementing a Stripe balance. You can calculate the net impact of a transaction on a balance by `amount` - `fee`
   */
  net: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'balance_transaction';
  /**
   * Learn more about how [reporting categories](https://stripe.com/docs/reports/reporting-categories) can help you understand balance transactions from an accounting perspective.
   */
  reporting_category: string;
  /**
   * This transaction relates to the Stripe object.
   */
  source?:
    | (
        | string
        | application_fee
        | charge
        | connect_collection_transfer
        | customer_cash_balance_transaction
        | dispute
        | fee_refund
        | issuing_authorization
        | issuing_dispute
        | issuing_transaction
        | payout
        | refund
        | reserve_transaction
        | tax_deducted_at_source
        | topup
        | transfer
        | transfer_reversal
      )
    | null;
  /**
   * The transaction's net funds status in the Stripe balance, which are either `available` or `pending`.
   */
  status: string;
  /**
   * Transaction type: `adjustment`, `advance`, `advance_funding`, `anticipation_repayment`, `application_fee`, `application_fee_refund`, `charge`, `climate_order_purchase`, `climate_order_refund`, `connect_collection_transfer`, `contribution`, `issuing_authorization_hold`, `issuing_authorization_release`, `issuing_dispute`, `issuing_transaction`, `obligation_outbound`, `obligation_reversal_inbound`, `payment`, `payment_failure_refund`, `payment_network_reserve_hold`, `payment_network_reserve_release`, `payment_refund`, `payment_reversal`, `payment_unreconciled`, `payout`, `payout_cancel`, `payout_failure`, `refund`, `refund_failure`, `reserve_transaction`, `reserved_funds`, `stripe_fee`, `stripe_fx_fee`, `tax_fee`, `topup`, `topup_reversal`, `transfer`, `transfer_cancel`, `transfer_failure`, or `transfer_refund`. Learn more about [balance transaction types and what they represent](https://stripe.com/docs/reports/balance-transaction-types). To classify transactions for accounting purposes, consider `reporting_category` instead.
   */
  type:
    | 'adjustment'
    | 'advance'
    | 'advance_funding'
    | 'anticipation_repayment'
    | 'application_fee'
    | 'application_fee_refund'
    | 'charge'
    | 'climate_order_purchase'
    | 'climate_order_refund'
    | 'connect_collection_transfer'
    | 'contribution'
    | 'issuing_authorization_hold'
    | 'issuing_authorization_release'
    | 'issuing_dispute'
    | 'issuing_transaction'
    | 'obligation_outbound'
    | 'obligation_reversal_inbound'
    | 'payment'
    | 'payment_failure_refund'
    | 'payment_network_reserve_hold'
    | 'payment_network_reserve_release'
    | 'payment_refund'
    | 'payment_reversal'
    | 'payment_unreconciled'
    | 'payout'
    | 'payout_cancel'
    | 'payout_failure'
    | 'refund'
    | 'refund_failure'
    | 'reserve_transaction'
    | 'reserved_funds'
    | 'stripe_fee'
    | 'stripe_fx_fee'
    | 'tax_fee'
    | 'topup'
    | 'topup_reversal'
    | 'transfer'
    | 'transfer_cancel'
    | 'transfer_failure'
    | 'transfer_refund';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object9 = 'balance_transaction';

/**
 * Transaction type: `adjustment`, `advance`, `advance_funding`, `anticipation_repayment`, `application_fee`, `application_fee_refund`, `charge`, `climate_order_purchase`, `climate_order_refund`, `connect_collection_transfer`, `contribution`, `issuing_authorization_hold`, `issuing_authorization_release`, `issuing_dispute`, `issuing_transaction`, `obligation_outbound`, `obligation_reversal_inbound`, `payment`, `payment_failure_refund`, `payment_network_reserve_hold`, `payment_network_reserve_release`, `payment_refund`, `payment_reversal`, `payment_unreconciled`, `payout`, `payout_cancel`, `payout_failure`, `refund`, `refund_failure`, `reserve_transaction`, `reserved_funds`, `stripe_fee`, `stripe_fx_fee`, `tax_fee`, `topup`, `topup_reversal`, `transfer`, `transfer_cancel`, `transfer_failure`, or `transfer_refund`. Learn more about [balance transaction types and what they represent](https://stripe.com/docs/reports/balance-transaction-types). To classify transactions for accounting purposes, consider `reporting_category` instead.
 */
export type type5 =
  | 'adjustment'
  | 'advance'
  | 'advance_funding'
  | 'anticipation_repayment'
  | 'application_fee'
  | 'application_fee_refund'
  | 'charge'
  | 'climate_order_purchase'
  | 'climate_order_refund'
  | 'connect_collection_transfer'
  | 'contribution'
  | 'issuing_authorization_hold'
  | 'issuing_authorization_release'
  | 'issuing_dispute'
  | 'issuing_transaction'
  | 'obligation_outbound'
  | 'obligation_reversal_inbound'
  | 'payment'
  | 'payment_failure_refund'
  | 'payment_network_reserve_hold'
  | 'payment_network_reserve_release'
  | 'payment_refund'
  | 'payment_reversal'
  | 'payment_unreconciled'
  | 'payout'
  | 'payout_cancel'
  | 'payout_failure'
  | 'refund'
  | 'refund_failure'
  | 'reserve_transaction'
  | 'reserved_funds'
  | 'stripe_fee'
  | 'stripe_fx_fee'
  | 'tax_fee'
  | 'topup'
  | 'topup_reversal'
  | 'transfer'
  | 'transfer_cancel'
  | 'transfer_failure'
  | 'transfer_refund';

/**
 * These bank accounts are payment methods on `Customer` objects.
 *
 * On the other hand [External Accounts](/api#external_accounts) are transfer
 * destinations on `Account` objects for connected accounts.
 * They can be bank accounts or debit cards as well, and are documented in the links above.
 *
 * Related guide: [Bank debits and transfers](/payments/bank-debits-transfers)
 */
export type bank_account = {
  /**
   * The ID of the account that the bank account is associated with.
   */
  account?: (string | account) | null;
  /**
   * The name of the person or business that owns the bank account.
   */
  account_holder_name?: string | null;
  /**
   * The type of entity that holds the account. This can be either `individual` or `company`.
   */
  account_holder_type?: string | null;
  /**
   * The bank account type. This can only be `checking` or `savings` in most countries. In Japan, this can only be `futsu` or `toza`.
   */
  account_type?: string | null;
  /**
   * A set of available payout methods for this bank account. Only values from this set should be passed as the `method` when creating a payout.
   */
  available_payout_methods?: Array<'instant' | 'standard'> | null;
  /**
   * Name of the bank associated with the routing number (e.g., `WELLS FARGO`).
   */
  bank_name?: string | null;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country: string;
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.
   */
  currency: string;
  /**
   * The ID of the customer that the bank account is associated with.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * Whether this bank account is the default external account for its currency.
   */
  default_for_currency?: boolean | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Information about the [upcoming new requirements for the bank account](https://stripe.com/docs/connect/custom-accounts/future-requirements), including what information needs to be collected, and by when.
   */
  future_requirements?: external_account_requirements | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The last four digits of the bank account number.
   */
  last4: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'bank_account';
  /**
   * Information about the requirements for the bank account, including what information needs to be collected.
   */
  requirements?: external_account_requirements | null;
  /**
   * The routing transit number for the bank account.
   */
  routing_number?: string | null;
  /**
   * For bank accounts, possible values are `new`, `validated`, `verified`, `verification_failed`, or `errored`. A bank account that hasn't had any activity or validation performed is `new`. If Stripe can determine that the bank account exists, its status will be `validated`. Note that there often isn’t enough information to know (e.g., for smaller credit unions), and the validation is not always run. If customer bank account verification has succeeded, the bank account status will be `verified`. If the verification failed for any reason, such as microdeposit failure, the status will be `verification_failed`. If a payout sent to this bank account fails, we'll set the status to `errored` and will not continue to send [scheduled payouts](https://stripe.com/docs/payouts#payout-schedule) until the bank details are updated.
   *
   * For external accounts, possible values are `new`, `errored` and `verification_failed`. If a payout fails, the status is set to `errored` and scheduled payouts are stopped until account details are updated. In the US and India, if we can't [verify the owner of the bank account](https://support.stripe.com/questions/bank-account-ownership-verification), we'll set the status to `verification_failed`. Other validations aren't run against external accounts because they're only used for payouts. This means the other statuses don't apply.
   */
  status: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object10 = 'bank_account';

export type bank_connections_resource_accountholder = {
  /**
   * The ID of the Stripe account this account belongs to. Should only be present if `account_holder.type` is `account`.
   */
  account?: string | account;
  /**
   * ID of the Stripe customer this account belongs to. Present if and only if `account_holder.type` is `customer`.
   */
  customer?: string | customer;
  /**
   * Type of account holder that this account belongs to.
   */
  type: 'account' | 'customer';
};

/**
 * Type of account holder that this account belongs to.
 */
export type type6 = 'account' | 'customer';

export type bank_connections_resource_balance = {
  /**
   * The time that the external institution calculated this balance. Measured in seconds since the Unix epoch.
   */
  as_of: number;
  cash?: bank_connections_resource_balance_api_resource_cash_balance;
  credit?: bank_connections_resource_balance_api_resource_credit_balance;
  /**
   * The balances owed to (or by) the account holder.
   *
   * Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
   *
   * Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.
   */
  current: {
    [key: string]: number;
  };
  /**
   * The `type` of the balance. An additional hash is included on the balance with a name matching this value.
   */
  type: 'cash' | 'credit';
};

/**
 * The `type` of the balance. An additional hash is included on the balance with a name matching this value.
 */
export type type7 = 'cash' | 'credit';

export type bank_connections_resource_balance_api_resource_cash_balance = {
  /**
   * The funds available to the account holder. Typically this is the current balance less any holds.
   *
   * Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
   *
   * Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.
   */
  available?: {
    [key: string]: number;
  } | null;
};

export type bank_connections_resource_balance_api_resource_credit_balance = {
  /**
   * The credit that has been used by the account holder.
   *
   * Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.
   *
   * Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.
   */
  used?: {
    [key: string]: number;
  } | null;
};

export type bank_connections_resource_balance_refresh = {
  /**
   * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.
   */
  last_attempted_at: number;
  /**
   * Time at which the next balance refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.
   */
  next_refresh_available_at?: number | null;
  /**
   * The status of the last refresh attempt.
   */
  status: 'failed' | 'pending' | 'succeeded';
};

/**
 * The status of the last refresh attempt.
 */
export type status2 = 'failed' | 'pending' | 'succeeded';

export type bank_connections_resource_link_account_session_filters = {
  /**
   * List of countries from which to filter accounts.
   */
  countries?: Array<string> | null;
};

export type bank_connections_resource_ownership_refresh = {
  /**
   * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.
   */
  last_attempted_at: number;
  /**
   * Time at which the next ownership refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.
   */
  next_refresh_available_at?: number | null;
  /**
   * The status of the last refresh attempt.
   */
  status: 'failed' | 'pending' | 'succeeded';
};

export type bank_connections_resource_transaction_refresh = {
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.
   */
  last_attempted_at: number;
  /**
   * Time at which the next transaction refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.
   */
  next_refresh_available_at?: number | null;
  /**
   * The status of the last refresh attempt.
   */
  status: 'failed' | 'pending' | 'succeeded';
};

export type bank_connections_resource_transaction_resource_status_transitions = {
  /**
   * Time at which this transaction posted. Measured in seconds since the Unix epoch.
   */
  posted_at?: number | null;
  /**
   * Time at which this transaction was voided. Measured in seconds since the Unix epoch.
   */
  void_at?: number | null;
};

export type billing_details = {
  /**
   * Billing address.
   */
  address?: address | null;
  /**
   * Email address.
   */
  email?: string | null;
  /**
   * Full name.
   */
  name?: string | null;
  /**
   * Billing phone number (including extension).
   */
  phone?: string | null;
};

/**
 * A billing meter is a resource that allows you to track usage of a particular event. For example, you might create a billing meter to track the number of API calls made by a particular user. You can then attach the billing meter to a price and attach the price to a subscription to charge the user for the number of API calls they make.
 */
export type billing_meter = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  customer_mapping: billing_meter_resource_customer_mapping_settings;
  default_aggregation: billing_meter_resource_aggregation_settings;
  /**
   * The meter's name.
   */
  display_name: string;
  /**
   * The name of the meter event to record usage for. Corresponds with the `event_name` field on meter events.
   */
  event_name: string;
  /**
   * The time window to pre-aggregate meter events for, if any.
   */
  event_time_window?: ('day' | 'hour') | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing.meter';
  /**
   * The meter's status.
   */
  status: 'active' | 'inactive';
  status_transitions: billing_meter_resource_billing_meter_status_transitions;
  /**
   * Time at which the object was last updated. Measured in seconds since the Unix epoch.
   */
  updated: number;
  value_settings: billing_meter_resource_billing_meter_value;
};

/**
 * The time window to pre-aggregate meter events for, if any.
 */
export type event_time_window = 'day' | 'hour';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object11 = 'billing.meter';

/**
 * The meter's status.
 */
export type status3 = 'active' | 'inactive';

/**
 * A billing meter event represents a customer's usage of a product. Meter events are used to bill a customer based on their usage.
 * Meter events are associated with billing meters, which define the shape of the event's payload and how those events are aggregated for billing.
 */
export type billing_meter_event = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The name of the meter event. Corresponds with the `event_name` field on a meter.
   */
  event_name: string;
  /**
   * A unique identifier for the event.
   */
  identifier: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing.meter_event';
  /**
   * The payload of the event. This contains the fields corresponding to a meter's `customer_mapping.event_payload_key` (default is `stripe_customer_id`) and `value_settings.event_payload_key` (default is `value`). Read more about the [payload](https://stripe.com/docs/billing/subscriptions/usage-based/recording-usage#payload-key-overrides).
   */
  payload: {
    [key: string]: string;
  };
  /**
   * The timestamp passed in when creating the event. Measured in seconds since the Unix epoch.
   */
  timestamp: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object12 = 'billing.meter_event';

/**
 * A billing meter event adjustment is a resource that allows you to cancel a meter event. For example, you might create a billing meter event adjustment to cancel a meter event that was created in error or attached to the wrong customer.
 */
export type billing_meter_event_adjustment = {
  /**
   * Specifies which event to cancel.
   */
  cancel?: billing_meter_resource_billing_meter_event_adjustment_cancel | null;
  /**
   * The name of the meter event. Corresponds with the `event_name` field on a meter.
   */
  event_name: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing.meter_event_adjustment';
  /**
   * The meter event adjustment's status.
   */
  status: 'complete' | 'pending';
  /**
   * Specifies whether to cancel a single event or a range of events for a time period. Time period cancellation is not supported yet.
   */
  type: 'cancel';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object13 = 'billing.meter_event_adjustment';

/**
 * The meter event adjustment's status.
 */
export type status4 = 'complete' | 'pending';

/**
 * Specifies whether to cancel a single event or a range of events for a time period. Time period cancellation is not supported yet.
 */
export type type8 = 'cancel';

/**
 * A billing meter event summary represents an aggregated view of a customer's billing meter events within a specified timeframe. It indicates how much
 * usage was accrued by a customer for that period.
 */
export type billing_meter_event_summary = {
  /**
   * Aggregated value of all the events within `start_time` (inclusive) and `end_time` (inclusive). The aggregation strategy is defined on meter via `default_aggregation`.
   */
  aggregated_value: number;
  /**
   * End timestamp for this event summary (inclusive).
   */
  end_time: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The meter associated with this event summary.
   */
  meter: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing.meter_event_summary';
  /**
   * Start timestamp for this event summary (inclusive).
   */
  start_time: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object14 = 'billing.meter_event_summary';

export type billing_meter_resource_aggregation_settings = {
  /**
   * Specifies how events are aggregated.
   */
  formula: 'count' | 'sum';
};

/**
 * Specifies how events are aggregated.
 */
export type formula = 'count' | 'sum';

export type billing_meter_resource_billing_meter_event_adjustment_cancel = {
  /**
   * Unique identifier for the event.
   */
  identifier?: string | null;
};

export type billing_meter_resource_billing_meter_status_transitions = {
  /**
   * The time the meter was deactivated, if any. Measured in seconds since Unix epoch.
   */
  deactivated_at?: number | null;
};

export type billing_meter_resource_billing_meter_value = {
  /**
   * The key in the meter event payload to use as the value for this meter.
   */
  event_payload_key: string;
};

export type billing_meter_resource_customer_mapping_settings = {
  /**
   * The key in the meter event payload to use for mapping the event to a customer.
   */
  event_payload_key: string;
  /**
   * The method for mapping a meter event to a customer.
   */
  type: 'by_id';
};

/**
 * The method for mapping a meter event to a customer.
 */
export type type9 = 'by_id';

/**
 * A portal configuration describes the functionality and behavior of a portal session.
 */
export type billing_portal_configuration = {
  /**
   * Whether the configuration is active and can be used to create portal sessions.
   */
  active: boolean;
  /**
   * ID of the Connect Application that created the configuration.
   */
  application?: (string | application | deleted_application) | null;
  business_profile: portal_business_profile;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The default URL to redirect customers to when they click on the portal's link to return to your website. This can be [overriden](https://stripe.com/docs/api/customer_portal/sessions/create#create_portal_session-return_url) when creating the session.
   */
  default_return_url?: string | null;
  features: portal_features;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Whether the configuration is the default. If `true`, this configuration can be managed in the Dashboard and portal sessions will use this configuration unless it is overriden when creating the session.
   */
  is_default: boolean;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  login_page: portal_login_page;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing_portal.configuration';
  /**
   * Time at which the object was last updated. Measured in seconds since the Unix epoch.
   */
  updated: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object15 = 'billing_portal.configuration';

/**
 * The Billing customer portal is a Stripe-hosted UI for subscription and
 * billing management.
 *
 * A portal configuration describes the functionality and features that you
 * want to provide to your customers through the portal.
 *
 * A portal session describes the instantiation of the customer portal for
 * a particular customer. By visiting the session's URL, the customer
 * can manage their subscriptions and billing details. For security reasons,
 * sessions are short-lived and will expire if the customer does not visit the URL.
 * Create sessions on-demand when customers intend to manage their subscriptions
 * and billing details.
 *
 * Learn more in the [integration guide](https://stripe.com/docs/billing/subscriptions/integrating-customer-portal).
 */
export type billing_portal_session = {
  /**
   * The configuration used by this session, describing the features available.
   */
  configuration: string | billing_portal_configuration;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The ID of the customer for this session.
   */
  customer: string;
  /**
   * Information about a specific flow for the customer to go through. See the [docs](https://stripe.com/docs/customer-management/portal-deep-links) to learn more about using customer portal deep links and flows.
   */
  flow?: portal_flows_flow | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the customer’s `preferred_locales` or browser’s locale is used.
   */
  locale?:
    | (
        | 'auto'
        | 'bg'
        | 'cs'
        | 'da'
        | 'de'
        | 'el'
        | 'en'
        | 'en-AU'
        | 'en-CA'
        | 'en-GB'
        | 'en-IE'
        | 'en-IN'
        | 'en-NZ'
        | 'en-SG'
        | 'es'
        | 'es-419'
        | 'et'
        | 'fi'
        | 'fil'
        | 'fr'
        | 'fr-CA'
        | 'hr'
        | 'hu'
        | 'id'
        | 'it'
        | 'ja'
        | 'ko'
        | 'lt'
        | 'lv'
        | 'ms'
        | 'mt'
        | 'nb'
        | 'nl'
        | 'pl'
        | 'pt'
        | 'pt-BR'
        | 'ro'
        | 'ru'
        | 'sk'
        | 'sl'
        | 'sv'
        | 'th'
        | 'tr'
        | 'vi'
        | 'zh'
        | 'zh-HK'
        | 'zh-TW'
      )
    | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'billing_portal.session';
  /**
   * The account for which the session was created on behalf of. When specified, only subscriptions and invoices with this `on_behalf_of` account appear in the portal. For more information, see the [docs](https://stripe.com/docs/connect/separate-charges-and-transfers#settlement-merchant). Use the [Accounts API](https://stripe.com/docs/api/accounts/object#account_object-settings-branding) to modify the `on_behalf_of` account's branding settings, which the portal displays.
   */
  on_behalf_of?: string | null;
  /**
   * The URL to redirect customers to when they click on the portal's link to return to your website.
   */
  return_url?: string | null;
  /**
   * The short-lived URL of the session that gives customers access to the customer portal.
   */
  url: string;
};

/**
 * The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the customer’s `preferred_locales` or browser’s locale is used.
 */
export type locale =
  | 'auto'
  | 'bg'
  | 'cs'
  | 'da'
  | 'de'
  | 'el'
  | 'en'
  | 'en-AU'
  | 'en-CA'
  | 'en-GB'
  | 'en-IE'
  | 'en-IN'
  | 'en-NZ'
  | 'en-SG'
  | 'es'
  | 'es-419'
  | 'et'
  | 'fi'
  | 'fil'
  | 'fr'
  | 'fr-CA'
  | 'hr'
  | 'hu'
  | 'id'
  | 'it'
  | 'ja'
  | 'ko'
  | 'lt'
  | 'lv'
  | 'ms'
  | 'mt'
  | 'nb'
  | 'nl'
  | 'pl'
  | 'pt'
  | 'pt-BR'
  | 'ro'
  | 'ru'
  | 'sk'
  | 'sl'
  | 'sv'
  | 'th'
  | 'tr'
  | 'vi'
  | 'zh'
  | 'zh-HK'
  | 'zh-TW';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object16 = 'billing_portal.session';

export type cancellation_details = {
  /**
   * Additional comments about why the user canceled the subscription, if the subscription was canceled explicitly by the user.
   */
  comment?: string | null;
  /**
   * The customer submitted reason for why they canceled, if the subscription was canceled explicitly by the user.
   */
  feedback?:
    | (
        | 'customer_service'
        | 'low_quality'
        | 'missing_features'
        | 'other'
        | 'switched_service'
        | 'too_complex'
        | 'too_expensive'
        | 'unused'
      )
    | null;
  /**
   * Why this subscription was canceled.
   */
  reason?: ('cancellation_requested' | 'payment_disputed' | 'payment_failed') | null;
};

/**
 * The customer submitted reason for why they canceled, if the subscription was canceled explicitly by the user.
 */
export type feedback =
  | 'customer_service'
  | 'low_quality'
  | 'missing_features'
  | 'other'
  | 'switched_service'
  | 'too_complex'
  | 'too_expensive'
  | 'unused';

/**
 * Why this subscription was canceled.
 */
export type reason = 'cancellation_requested' | 'payment_disputed' | 'payment_failed';

/**
 * This is an object representing a capability for a Stripe account.
 *
 * Related guide: [Account capabilities](https://stripe.com/docs/connect/account-capabilities)
 */
export type capability = {
  /**
   * The account for which the capability enables functionality.
   */
  account: string | account;
  future_requirements?: account_capability_future_requirements;
  /**
   * The identifier for the capability.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'capability';
  /**
   * Whether the capability has been requested.
   */
  requested: boolean;
  /**
   * Time at which the capability was requested. Measured in seconds since the Unix epoch.
   */
  requested_at?: number | null;
  requirements?: account_capability_requirements;
  /**
   * The status of the capability. Can be `active`, `inactive`, `pending`, or `unrequested`.
   */
  status: 'active' | 'disabled' | 'inactive' | 'pending' | 'unrequested';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object17 = 'capability';

/**
 * The status of the capability. Can be `active`, `inactive`, `pending`, or `unrequested`.
 */
export type status5 = 'active' | 'disabled' | 'inactive' | 'pending' | 'unrequested';

/**
 * You can store multiple cards on a customer in order to charge the customer
 * later. You can also store multiple debit cards on a recipient in order to
 * transfer to those cards later.
 *
 * Related guide: [Card payments with Sources](https://stripe.com/docs/sources/cards)
 */
export type card = {
  /**
   * The account this card belongs to. This attribute will not be in the card object if the card belongs to a customer or recipient instead. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.
   */
  account?: (string | account) | null;
  /**
   * City/District/Suburb/Town/Village.
   */
  address_city?: string | null;
  /**
   * Billing address country, if provided when creating card.
   */
  address_country?: string | null;
  /**
   * Address line 1 (Street address/PO Box/Company name).
   */
  address_line1?: string | null;
  /**
   * If `address_line1` was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_line1_check?: string | null;
  /**
   * Address line 2 (Apartment/Suite/Unit/Building).
   */
  address_line2?: string | null;
  /**
   * State/County/Province/Region.
   */
  address_state?: string | null;
  /**
   * ZIP or postal code.
   */
  address_zip?: string | null;
  /**
   * If `address_zip` was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_zip_check?: string | null;
  /**
   * A set of available payout methods for this card. Only values from this set should be passed as the `method` when creating a payout.
   */
  available_payout_methods?: Array<'instant' | 'standard'> | null;
  /**
   * Card brand. Can be `American Express`, `Diners Club`, `Discover`, `Eftpos Australia`, `JCB`, `MasterCard`, `UnionPay`, `Visa`, or `Unknown`.
   */
  brand: string;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Three-letter [ISO code for currency](https://stripe.com/docs/payouts). Only applicable on accounts (not customers or recipients). The card can be used as a transfer destination for funds in this currency. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.
   */
  currency?: string | null;
  /**
   * The customer that this card belongs to. This attribute will not be in the card object if the card belongs to an account or recipient instead.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * If a CVC was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`. A result of unchecked indicates that CVC was provided but hasn't been checked yet. Checks are typically performed when attaching a card to a Customer object, or when creating a charge. For more details, see [Check if a card is valid without a charge](https://support.stripe.com/questions/check-if-a-card-is-valid-without-a-charge).
   */
  cvc_check?: string | null;
  /**
   * Whether this card is the default external account for its currency. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.
   */
  default_for_currency?: boolean | null;
  /**
   * (For tokenized numbers only.) The last four digits of the device account number.
   */
  dynamic_last4?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The last four digits of the card.
   */
  last4: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * Cardholder name.
   */
  name?: string | null;
  networks?: token_card_networks;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'card';
  /**
   * For external accounts that are cards, possible values are `new` and `errored`. If a payout fails, the status is set to `errored` and [scheduled payouts](https://stripe.com/docs/payouts#payout-schedule) are stopped until account details are updated.
   */
  status?: string | null;
  /**
   * If the card number is tokenized, this is the method that was used. Can be `android_pay` (includes Google Pay), `apple_pay`, `masterpass`, `visa_checkout`, or null.
   */
  tokenization_method?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object18 = 'card';

export type card_generated_from_payment_method_details = {
  card_present?: payment_method_details_card_present;
  /**
   * The type of payment method transaction-specific details from the transaction that generated this `card` payment method. Always `card_present`.
   */
  type: string;
};

export type card_issuing_account_terms_of_service = {
  /**
   * The Unix timestamp marking when the account representative accepted the service agreement.
   */
  date?: number | null;
  /**
   * The IP address from which the account representative accepted the service agreement.
   */
  ip?: string | null;
  /**
   * The user agent of the browser from which the account representative accepted the service agreement.
   */
  user_agent?: string;
};

export type card_mandate_payment_method_details = {
  [key: string]: unknown;
};

/**
 * A customer's `Cash balance` represents real funds. Customers can add funds to their cash balance by sending a bank transfer. These funds can be used for payment and can eventually be paid out to your bank account.
 */
export type cash_balance = {
  /**
   * A hash of all cash balances available to this customer. You cannot delete a customer with any cash balances, even if the balance is 0. Amounts are represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  available?: {
    [key: string]: number;
  } | null;
  /**
   * The ID of the customer whose cash balance this object represents.
   */
  customer: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'cash_balance';
  settings: customer_balance_customer_balance_settings;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object19 = 'cash_balance';

/**
 * The `Charge` object represents a single attempt to move money into your Stripe account.
 * PaymentIntent confirmation is the most common way to create Charges, but transferring
 * money to a different Stripe account through Connect also creates Charges.
 * Some legacy payment flows create Charges directly, which is not recommended for new integrations.
 */
export type charge = {
  /**
   * Amount intended to be collected by this payment. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
   */
  amount: number;
  /**
   * Amount in cents (or local equivalent) captured (can be less than the amount attribute on the charge if a partial capture was made).
   */
  amount_captured: number;
  /**
   * Amount in cents (or local equivalent) refunded (can be less than the amount attribute on the charge if a partial refund was issued).
   */
  amount_refunded: number;
  /**
   * ID of the Connect application that created the charge.
   */
  application?: (string | application) | null;
  /**
   * The application fee (if any) for the charge. [See the Connect documentation](https://stripe.com/docs/connect/direct-charges#collect-fees) for details.
   */
  application_fee?: (string | application_fee) | null;
  /**
   * The amount of the application fee (if any) requested for the charge. [See the Connect documentation](https://stripe.com/docs/connect/direct-charges#collect-fees) for details.
   */
  application_fee_amount?: number | null;
  /**
   * ID of the balance transaction that describes the impact of this charge on your account balance (not including refunds or disputes).
   */
  balance_transaction?: (string | balance_transaction) | null;
  billing_details: billing_details;
  /**
   * The full statement descriptor that is passed to card networks, and that is displayed on your customers' credit card and bank statements. Allows you to see what the statement descriptor looks like after the static and dynamic portions are combined.
   */
  calculated_statement_descriptor?: string | null;
  /**
   * If the charge was created without capturing, this Boolean represents whether it is still uncaptured or has since been captured.
   */
  captured: boolean;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the customer this charge is for if one exists.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Whether the charge has been disputed.
   */
  disputed: boolean;
  /**
   * ID of the balance transaction that describes the reversal of the balance on your account due to payment failure.
   */
  failure_balance_transaction?: (string | balance_transaction) | null;
  /**
   * Error code explaining reason for charge failure if available (see [the errors section](https://stripe.com/docs/error-codes) for a list of codes).
   */
  failure_code?: string | null;
  /**
   * Message to user further explaining reason for charge failure if available.
   */
  failure_message?: string | null;
  /**
   * Information on fraud assessments for the charge.
   */
  fraud_details?: charge_fraud_details | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * ID of the invoice this charge is for if one exists.
   */
  invoice?: (string | invoice) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'charge';
  /**
   * The account (if any) the charge was made on behalf of without triggering an automatic transfer. See the [Connect documentation](https://stripe.com/docs/connect/separate-charges-and-transfers) for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * Details about whether the payment was accepted, and why. See [understanding declines](https://stripe.com/docs/declines) for details.
   */
  outcome?: charge_outcome | null;
  /**
   * `true` if the charge succeeded, or was successfully authorized for later capture.
   */
  paid: boolean;
  /**
   * ID of the PaymentIntent associated with this charge, if one exists.
   */
  payment_intent?: (string | payment_intent) | null;
  /**
   * ID of the payment method used in this charge.
   */
  payment_method?: string | null;
  /**
   * Details about the payment method at the time of the transaction.
   */
  payment_method_details?: payment_method_details | null;
  radar_options?: radar_radar_options;
  /**
   * This is the email address that the receipt for this charge was sent to.
   */
  receipt_email?: string | null;
  /**
   * This is the transaction number that appears on email receipts sent for this charge. This attribute will be `null` until a receipt has been sent.
   */
  receipt_number?: string | null;
  /**
   * This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt will be stylized as an Invoice receipt.
   */
  receipt_url?: string | null;
  /**
   * Whether the charge has been fully refunded. If the charge is only partially refunded, this attribute will still be false.
   */
  refunded: boolean;
  /**
   * A list of refunds that have been applied to the charge.
   */
  refunds?: {
    /**
     * Details about each object.
     */
    data: Array<refund>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  } | null;
  /**
   * ID of the review associated with this charge if one exists.
   */
  review?: (string | review) | null;
  /**
   * Shipping information for the charge.
   */
  shipping?: shipping | null;
  /**
   * The transfer ID which created this charge. Only present if the charge came from another Stripe account. [See the Connect documentation](https://stripe.com/docs/connect/destination-charges) for details.
   */
  source_transfer?: (string | transfer) | null;
  /**
   * For card charges, use `statement_descriptor_suffix` instead. Otherwise, you can use this value as the complete description of a charge on your customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  statement_descriptor?: string | null;
  /**
   * Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  statement_descriptor_suffix?: string | null;
  /**
   * The status of the payment is either `succeeded`, `pending`, or `failed`.
   */
  status: 'failed' | 'pending' | 'succeeded';
  /**
   * ID of the transfer to the `destination` account (only applicable if the charge was created using the `destination` parameter).
   */
  transfer?: string | transfer;
  /**
   * An optional dictionary including the account to automatically transfer to as part of a destination charge. [See the Connect documentation](https://stripe.com/docs/connect/destination-charges) for details.
   */
  transfer_data?: charge_transfer_data | null;
  /**
   * A string that identifies this transaction as part of a group. See the [Connect documentation](https://stripe.com/docs/connect/separate-charges-and-transfers#transfer-options) for details.
   */
  transfer_group?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object20 = 'charge';

export type charge_fraud_details = {
  /**
   * Assessments from Stripe. If set, the value is `fraudulent`.
   */
  stripe_report?: string;
  /**
   * Assessments reported by you. If set, possible values of are `safe` and `fraudulent`.
   */
  user_report?: string;
};

export type charge_outcome = {
  /**
   * Possible values are `approved_by_network`, `declined_by_network`, `not_sent_to_network`, and `reversed_after_approval`. The value `reversed_after_approval` indicates the payment was [blocked by Stripe](https://stripe.com/docs/declines#blocked-payments) after bank authorization, and may temporarily appear as "pending" on a cardholder's statement.
   */
  network_status?: string | null;
  /**
   * An enumerated value providing a more detailed explanation of the outcome's `type`. Charges blocked by Radar's default block rule have the value `highest_risk_level`. Charges placed in review by Radar's default review rule have the value `elevated_risk_level`. Charges authorized, blocked, or placed in review by custom rules have the value `rule`. See [understanding declines](https://stripe.com/docs/declines) for more details.
   */
  reason?: string | null;
  /**
   * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated payments are `normal`, `elevated`, `highest`. For non-card payments, and card-based payments predating the public assignment of risk levels, this field will have the value `not_assessed`. In the event of an error in the evaluation, this field will have the value `unknown`. This field is only available with Radar.
   */
  risk_level?: string;
  /**
   * Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated payments are between 0 and 100. For non-card payments, card-based payments predating the public assignment of risk scores, or in the event of an error during evaluation, this field will not be present. This field is only available with Radar for Fraud Teams.
   */
  risk_score?: number;
  /**
   * The ID of the Radar rule that matched the payment, if applicable.
   */
  rule?: string | rule;
  /**
   * A human-readable description of the outcome type and reason, designed for you (the recipient of the payment), not your customer.
   */
  seller_message?: string | null;
  /**
   * Possible values are `authorized`, `manual_review`, `issuer_declined`, `blocked`, and `invalid`. See [understanding declines](https://stripe.com/docs/declines) and [Radar reviews](https://stripe.com/docs/radar/reviews) for details.
   */
  type: string;
};

export type charge_transfer_data = {
  /**
   * The amount transferred to the destination account, if specified. By default, the entire charge amount is transferred to the destination account.
   */
  amount?: number | null;
  /**
   * ID of an existing, connected Stripe account to transfer funds to if `transfer_data` was specified in the charge request.
   */
  destination: string | account;
};

export type checkout_acss_debit_mandate_options = {
  /**
   * A URL for custom mandate text
   */
  custom_mandate_url?: string;
  /**
   * List of Stripe products where this mandate can be selected automatically. Returned when the Session is in `setup` mode.
   */
  default_for?: Array<'invoice' | 'subscription'>;
  /**
   * Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
   */
  interval_description?: string | null;
  /**
   * Payment schedule for the mandate.
   */
  payment_schedule?: ('combined' | 'interval' | 'sporadic') | null;
  /**
   * Transaction type of the mandate.
   */
  transaction_type?: ('business' | 'personal') | null;
};

/**
 * Payment schedule for the mandate.
 */
export type payment_schedule = 'combined' | 'interval' | 'sporadic';

/**
 * Transaction type of the mandate.
 */
export type transaction_type = 'business' | 'personal';

export type checkout_acss_debit_payment_method_options = {
  /**
   * Currency supported by the bank account. Returned when the Session is in `setup` mode.
   */
  currency?: 'cad' | 'usd';
  mandate_options?: checkout_acss_debit_mandate_options;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

/**
 * Currency supported by the bank account. Returned when the Session is in `setup` mode.
 */
export type currency = 'cad' | 'usd';

/**
 * Indicates that you intend to make future payments with this PaymentIntent's payment method.
 *
 * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
 *
 * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
 */
export type setup_future_usage = 'none' | 'off_session' | 'on_session';

/**
 * Bank account verification method.
 */
export type verification_method = 'automatic' | 'instant' | 'microdeposits';

export type checkout_affirm_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

/**
 * Indicates that you intend to make future payments with this PaymentIntent's payment method.
 *
 * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
 *
 * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
 */
export type setup_future_usage2 = 'none';

export type checkout_afterpay_clearpay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_alipay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_amazon_pay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

/**
 * Indicates that you intend to make future payments with this PaymentIntent's payment method.
 *
 * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
 *
 * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
 */
export type setup_future_usage3 = 'none' | 'off_session';

export type checkout_au_becs_debit_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_bacs_debit_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type checkout_bancontact_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_boleto_payment_method_options = {
  /**
   * The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.
   */
  expires_after_days: number;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type checkout_card_installments_options = {
  /**
   * Indicates if installments are enabled
   */
  enabled?: boolean;
};

export type checkout_card_payment_method_options = {
  installments?: checkout_card_installments_options;
  /**
   * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
   */
  request_three_d_secure: 'any' | 'automatic' | 'challenge';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.
   */
  statement_descriptor_suffix_kana?: string;
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.
   */
  statement_descriptor_suffix_kanji?: string;
};

/**
 * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
 */
export type request_three_d_secure = 'any' | 'automatic' | 'challenge';

export type checkout_cashapp_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_customer_balance_bank_transfer_payment_method_options = {
  eu_bank_transfer?: payment_method_options_customer_balance_eu_bank_account;
  /**
   * List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.
   *
   * Permitted values include: `sort_code`, `zengin`, `iban`, or `spei`.
   */
  requested_address_types?: Array<'aba' | 'iban' | 'sepa' | 'sort_code' | 'spei' | 'swift' | 'zengin'>;
  /**
   * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
   */
  type?:
    | ('eu_bank_transfer' | 'gb_bank_transfer' | 'jp_bank_transfer' | 'mx_bank_transfer' | 'us_bank_transfer')
    | null;
};

/**
 * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
 */
export type type10 =
  | 'eu_bank_transfer'
  | 'gb_bank_transfer'
  | 'jp_bank_transfer'
  | 'mx_bank_transfer'
  | 'us_bank_transfer';

export type checkout_customer_balance_payment_method_options = {
  bank_transfer?: checkout_customer_balance_bank_transfer_payment_method_options;
  /**
   * The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
   */
  funding_type?: 'bank_transfer' | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

/**
 * The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
 */
export type funding_type = 'bank_transfer';

export type checkout_eps_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_fpx_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_giropay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_grab_pay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_ideal_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_klarna_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type checkout_konbini_payment_method_options = {
  /**
   * The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire. For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST.
   */
  expires_after_days?: number | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_link_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type checkout_mobilepay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_multibanco_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_oxxo_payment_method_options = {
  /**
   * The number of calendar days before an OXXO invoice expires. For example, if you create an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.
   */
  expires_after_days: number;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_p24_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_paynow_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_paypal_payment_method_options = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Preferred locale of the PayPal checkout page that the customer is redirected to.
   */
  preferred_locale?: string | null;
  /**
   * A reference of the PayPal transaction visible to customer which is mapped to PayPal's invoice ID. This must be a globally unique ID if you have configured in your PayPal settings to block multiple payments per invoice ID.
   */
  reference?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

/**
 * Controls when the funds will be captured from the customer's account.
 */
export type capture_method = 'manual';

export type checkout_pix_payment_method_options = {
  /**
   * The number of seconds after which Pix payment will expire.
   */
  expires_after_seconds?: number | null;
};

export type checkout_revolut_pay_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type checkout_sepa_debit_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

/**
 * A Checkout Session represents your customer's session as they pay for
 * one-time purchases or subscriptions through [Checkout](https://stripe.com/docs/payments/checkout)
 * or [Payment Links](https://stripe.com/docs/payments/payment-links). We recommend creating a
 * new Session each time your customer attempts to pay.
 *
 * Once payment is successful, the Checkout Session will contain a reference
 * to the [Customer](https://stripe.com/docs/api/customers), and either the successful
 * [PaymentIntent](https://stripe.com/docs/api/payment_intents) or an active
 * [Subscription](https://stripe.com/docs/api/subscriptions).
 *
 * You can create a Checkout Session on your server and redirect to its URL
 * to begin Checkout.
 *
 * Related guide: [Checkout quickstart](https://stripe.com/docs/checkout/quickstart)
 */
export type checkout_session = {
  /**
   * When set, provides configuration for actions to take if this Checkout Session expires.
   */
  after_expiration?: payment_pages_checkout_session_after_expiration | null;
  /**
   * Enables user redeemable promotion codes.
   */
  allow_promotion_codes?: boolean | null;
  /**
   * Total of all items before discounts or taxes are applied.
   */
  amount_subtotal?: number | null;
  /**
   * Total of all items after discounts and taxes are applied.
   */
  amount_total?: number | null;
  automatic_tax: payment_pages_checkout_session_automatic_tax;
  /**
   * Describes whether Checkout should collect the customer's billing address. Defaults to `auto`.
   */
  billing_address_collection?: ('auto' | 'required') | null;
  /**
   * If set, Checkout displays a back button and customers will be directed to this URL if they decide to cancel payment and return to your website.
   */
  cancel_url?: string | null;
  /**
   * A unique string to reference the Checkout Session. This can be a
   * customer ID, a cart ID, or similar, and can be used to reconcile the
   * Session with your internal systems.
   */
  client_reference_id?: string | null;
  /**
   * Client secret to be used when initializing Stripe.js embedded checkout.
   */
  client_secret?: string | null;
  /**
   * Results of `consent_collection` for this session.
   */
  consent?: payment_pages_checkout_session_consent | null;
  /**
   * When set, provides configuration for the Checkout Session to gather active consent from customers.
   */
  consent_collection?: payment_pages_checkout_session_consent_collection | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency?: string | null;
  /**
   * Currency conversion details for automatic currency conversion sessions
   */
  currency_conversion?: payment_pages_checkout_session_currency_conversion | null;
  /**
   * Collect additional information from your customer using custom fields. Up to 3 fields are supported.
   */
  custom_fields: Array<payment_pages_checkout_session_custom_fields>;
  custom_text: payment_pages_checkout_session_custom_text;
  /**
   * The ID of the customer for this Session.
   * For Checkout Sessions in `subscription` mode or Checkout Sessions with `customer_creation` set as `always` in `payment` mode, Checkout
   * will create a new customer object based on information provided
   * during the payment flow unless an existing customer was provided when
   * the Session was created.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * Configure whether a Checkout Session creates a Customer when the Checkout Session completes.
   */
  customer_creation?: ('always' | 'if_required') | null;
  /**
   * The customer details including the customer's tax exempt status and the customer's tax IDs. Customer's address details are not present on Sessions in `setup` mode.
   */
  customer_details?: payment_pages_checkout_session_customer_details | null;
  /**
   * If provided, this value will be used when the Customer object is created.
   * If not provided, customers will be asked to enter their email address.
   * Use this parameter to prefill customer data if you already have an email
   * on file. To access information about the customer once the payment flow is
   * complete, use the `customer` attribute.
   */
  customer_email?: string | null;
  /**
   * The timestamp at which the Checkout Session will expire.
   */
  expires_at: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * ID of the invoice created by the Checkout Session, if it exists.
   */
  invoice?: (string | invoice) | null;
  /**
   * Details on the state of invoice creation for the Checkout Session.
   */
  invoice_creation?: payment_pages_checkout_session_invoice_creation | null;
  /**
   * The line items purchased by the customer.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The IETF language tag of the locale Checkout is displayed in. If blank or `auto`, the browser's locale is used.
   */
  locale?:
    | (
        | 'auto'
        | 'bg'
        | 'cs'
        | 'da'
        | 'de'
        | 'el'
        | 'en'
        | 'en-GB'
        | 'es'
        | 'es-419'
        | 'et'
        | 'fi'
        | 'fil'
        | 'fr'
        | 'fr-CA'
        | 'hr'
        | 'hu'
        | 'id'
        | 'it'
        | 'ja'
        | 'ko'
        | 'lt'
        | 'lv'
        | 'ms'
        | 'mt'
        | 'nb'
        | 'nl'
        | 'pl'
        | 'pt'
        | 'pt-BR'
        | 'ro'
        | 'ru'
        | 'sk'
        | 'sl'
        | 'sv'
        | 'th'
        | 'tr'
        | 'vi'
        | 'zh'
        | 'zh-HK'
        | 'zh-TW'
      )
    | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * The mode of the Checkout Session.
   */
  mode: 'payment' | 'setup' | 'subscription';
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'checkout.session';
  /**
   * The ID of the PaymentIntent for Checkout Sessions in `payment` mode. You can't confirm or cancel the PaymentIntent for a Checkout Session. To cancel, [expire the Checkout Session](https://stripe.com/docs/api/checkout/sessions/expire) instead.
   */
  payment_intent?: (string | payment_intent) | null;
  /**
   * The ID of the Payment Link that created this Session.
   */
  payment_link?: (string | payment_link) | null;
  /**
   * Configure whether a Checkout Session should collect a payment method. Defaults to `always`.
   */
  payment_method_collection?: ('always' | 'if_required') | null;
  /**
   * Information about the payment method configuration used for this Checkout session if using dynamic payment methods.
   */
  payment_method_configuration_details?: payment_method_config_biz_payment_method_configuration_details | null;
  /**
   * Payment-method-specific configuration for the PaymentIntent or SetupIntent of this CheckoutSession.
   */
  payment_method_options?: checkout_session_payment_method_options | null;
  /**
   * A list of the types of payment methods (e.g. card) this Checkout
   * Session is allowed to accept.
   */
  payment_method_types: Array<string>;
  /**
   * The payment status of the Checkout Session, one of `paid`, `unpaid`, or `no_payment_required`.
   * You can use this value to decide when to fulfill your customer's order.
   */
  payment_status: 'no_payment_required' | 'paid' | 'unpaid';
  phone_number_collection?: payment_pages_checkout_session_phone_number_collection;
  /**
   * The ID of the original expired Checkout Session that triggered the recovery flow.
   */
  recovered_from?: string | null;
  /**
   * This parameter applies to `ui_mode: embedded`. Learn more about the [redirect behavior](https://stripe.com/docs/payments/checkout/custom-redirect-behavior) of embedded sessions. Defaults to `always`.
   */
  redirect_on_completion?: 'always' | 'if_required' | 'never';
  /**
   * Applies to Checkout Sessions with `ui_mode: embedded`. The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site.
   */
  return_url?: string;
  /**
   * Controls saved payment method settings for the session. Only available in `payment` and `subscription` mode.
   */
  saved_payment_method_options?: payment_pages_checkout_session_saved_payment_method_options | null;
  /**
   * The ID of the SetupIntent for Checkout Sessions in `setup` mode. You can't confirm or cancel the SetupIntent for a Checkout Session. To cancel, [expire the Checkout Session](https://stripe.com/docs/api/checkout/sessions/expire) instead.
   */
  setup_intent?: (string | setup_intent) | null;
  /**
   * When set, provides configuration for Checkout to collect a shipping address from a customer.
   */
  shipping_address_collection?: payment_pages_checkout_session_shipping_address_collection | null;
  /**
   * The details of the customer cost of shipping, including the customer chosen ShippingRate.
   */
  shipping_cost?: payment_pages_checkout_session_shipping_cost | null;
  /**
   * Shipping information for this Checkout Session.
   */
  shipping_details?: shipping | null;
  /**
   * The shipping rate options applied to this Session.
   */
  shipping_options: Array<payment_pages_checkout_session_shipping_option>;
  /**
   * The status of the Checkout Session, one of `open`, `complete`, or `expired`.
   */
  status?: ('complete' | 'expired' | 'open') | null;
  /**
   * Describes the type of transaction being performed by Checkout in order to customize
   * relevant text on the page, such as the submit button. `submit_type` can only be
   * specified on Checkout Sessions in `payment` mode. If blank or `auto`, `pay` is used.
   */
  submit_type?: ('auto' | 'book' | 'donate' | 'pay') | null;
  /**
   * The ID of the subscription for Checkout Sessions in `subscription` mode.
   */
  subscription?: (string | subscription) | null;
  /**
   * The URL the customer will be directed to after the payment or
   * subscription creation is successful.
   */
  success_url?: string | null;
  tax_id_collection?: payment_pages_checkout_session_tax_id_collection;
  /**
   * Tax and discount details for the computed total amount.
   */
  total_details?: payment_pages_checkout_session_total_details | null;
  /**
   * The UI mode of the Session. Defaults to `hosted`.
   */
  ui_mode?: ('embedded' | 'hosted') | null;
  /**
   * The URL to the Checkout Session. Redirect customers to this URL to take them to Checkout. If you’re using [Custom Domains](https://stripe.com/docs/payments/checkout/custom-domains), the URL will use your subdomain. Otherwise, it’ll use `checkout.stripe.com.`
   * This value is only present when the session is active.
   */
  url?: string | null;
};

/**
 * Describes whether Checkout should collect the customer's billing address. Defaults to `auto`.
 */
export type billing_address_collection = 'auto' | 'required';

/**
 * Configure whether a Checkout Session creates a Customer when the Checkout Session completes.
 */
export type customer_creation = 'always' | 'if_required';

/**
 * The IETF language tag of the locale Checkout is displayed in. If blank or `auto`, the browser's locale is used.
 */
export type locale2 =
  | 'auto'
  | 'bg'
  | 'cs'
  | 'da'
  | 'de'
  | 'el'
  | 'en'
  | 'en-GB'
  | 'es'
  | 'es-419'
  | 'et'
  | 'fi'
  | 'fil'
  | 'fr'
  | 'fr-CA'
  | 'hr'
  | 'hu'
  | 'id'
  | 'it'
  | 'ja'
  | 'ko'
  | 'lt'
  | 'lv'
  | 'ms'
  | 'mt'
  | 'nb'
  | 'nl'
  | 'pl'
  | 'pt'
  | 'pt-BR'
  | 'ro'
  | 'ru'
  | 'sk'
  | 'sl'
  | 'sv'
  | 'th'
  | 'tr'
  | 'vi'
  | 'zh'
  | 'zh-HK'
  | 'zh-TW';

/**
 * The mode of the Checkout Session.
 */
export type mode = 'payment' | 'setup' | 'subscription';

/**
 * Configure whether a Checkout Session should collect a payment method. Defaults to `always`.
 */
export type payment_method_collection = 'always' | 'if_required';

/**
 * The payment status of the Checkout Session, one of `paid`, `unpaid`, or `no_payment_required`.
 * You can use this value to decide when to fulfill your customer's order.
 */
export type payment_status = 'no_payment_required' | 'paid' | 'unpaid';

/**
 * This parameter applies to `ui_mode: embedded`. Learn more about the [redirect behavior](https://stripe.com/docs/payments/checkout/custom-redirect-behavior) of embedded sessions. Defaults to `always`.
 */
export type redirect_on_completion = 'always' | 'if_required' | 'never';

/**
 * The status of the Checkout Session, one of `open`, `complete`, or `expired`.
 */
export type status6 = 'complete' | 'expired' | 'open';

/**
 * Describes the type of transaction being performed by Checkout in order to customize
 * relevant text on the page, such as the submit button. `submit_type` can only be
 * specified on Checkout Sessions in `payment` mode. If blank or `auto`, `pay` is used.
 */
export type submit_type = 'auto' | 'book' | 'donate' | 'pay';

/**
 * The UI mode of the Session. Defaults to `hosted`.
 */
export type ui_mode = 'embedded' | 'hosted';

export type checkout_session_payment_method_options = {
  acss_debit?: checkout_acss_debit_payment_method_options;
  affirm?: checkout_affirm_payment_method_options;
  afterpay_clearpay?: checkout_afterpay_clearpay_payment_method_options;
  alipay?: checkout_alipay_payment_method_options;
  amazon_pay?: checkout_amazon_pay_payment_method_options;
  au_becs_debit?: checkout_au_becs_debit_payment_method_options;
  bacs_debit?: checkout_bacs_debit_payment_method_options;
  bancontact?: checkout_bancontact_payment_method_options;
  boleto?: checkout_boleto_payment_method_options;
  card?: checkout_card_payment_method_options;
  cashapp?: checkout_cashapp_payment_method_options;
  customer_balance?: checkout_customer_balance_payment_method_options;
  eps?: checkout_eps_payment_method_options;
  fpx?: checkout_fpx_payment_method_options;
  giropay?: checkout_giropay_payment_method_options;
  grabpay?: checkout_grab_pay_payment_method_options;
  ideal?: checkout_ideal_payment_method_options;
  klarna?: checkout_klarna_payment_method_options;
  konbini?: checkout_konbini_payment_method_options;
  link?: checkout_link_payment_method_options;
  mobilepay?: checkout_mobilepay_payment_method_options;
  multibanco?: checkout_multibanco_payment_method_options;
  oxxo?: checkout_oxxo_payment_method_options;
  p24?: checkout_p24_payment_method_options;
  paynow?: checkout_paynow_payment_method_options;
  paypal?: checkout_paypal_payment_method_options;
  pix?: checkout_pix_payment_method_options;
  revolut_pay?: checkout_revolut_pay_payment_method_options;
  sepa_debit?: checkout_sepa_debit_payment_method_options;
  sofort?: checkout_sofort_payment_method_options;
  swish?: checkout_swish_payment_method_options;
  us_bank_account?: checkout_us_bank_account_payment_method_options;
};

export type checkout_sofort_payment_method_options = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type checkout_swish_payment_method_options = {
  /**
   * The order reference that will be displayed to customers in the Swish application. Defaults to the `id` of the Payment Intent.
   */
  reference?: string | null;
};

export type checkout_us_bank_account_payment_method_options = {
  financial_connections?: linked_account_options_us_bank_account;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant';
};

/**
 * Bank account verification method.
 */
export type verification_method2 = 'automatic' | 'instant';

/**
 * Orders represent your intent to purchase a particular Climate product. When you create an order, the
 * payment is deducted from your merchant balance.
 */
export type climate_order = {
  /**
   * Total amount of [Frontier](https://frontierclimate.com/)'s service fees in the currency's smallest unit.
   */
  amount_fees: number;
  /**
   * Total amount of the carbon removal in the currency's smallest unit.
   */
  amount_subtotal: number;
  /**
   * Total amount of the order including fees in the currency's smallest unit.
   */
  amount_total: number;
  beneficiary?: climate_removals_beneficiary;
  /**
   * Time at which the order was canceled. Measured in seconds since the Unix epoch.
   */
  canceled_at?: number | null;
  /**
   * Reason for the cancellation of this order.
   */
  cancellation_reason?: ('expired' | 'product_unavailable' | 'requested') | null;
  /**
   * For delivered orders, a URL to a delivery certificate for the order.
   */
  certificate?: string | null;
  /**
   * Time at which the order was confirmed. Measured in seconds since the Unix epoch.
   */
  confirmed_at?: number | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase, representing the currency for this order.
   */
  currency: string;
  /**
   * Time at which the order's expected_delivery_year was delayed. Measured in seconds since the Unix epoch.
   */
  delayed_at?: number | null;
  /**
   * Time at which the order was delivered. Measured in seconds since the Unix epoch.
   */
  delivered_at?: number | null;
  /**
   * Details about the delivery of carbon removal for this order.
   */
  delivery_details: Array<climate_removals_order_deliveries>;
  /**
   * The year this order is expected to be delivered.
   */
  expected_delivery_year: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Quantity of carbon removal that is included in this order.
   */
  metric_tons: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'climate.order';
  /**
   * Unique ID for the Climate `Product` this order is purchasing.
   */
  product: string | climate_product;
  /**
   * Time at which the order's product was substituted for a different product. Measured in seconds since the Unix epoch.
   */
  product_substituted_at?: number | null;
  /**
   * The current status of this order.
   */
  status: 'awaiting_funds' | 'canceled' | 'confirmed' | 'delivered' | 'open';
};

/**
 * Reason for the cancellation of this order.
 */
export type cancellation_reason = 'expired' | 'product_unavailable' | 'requested';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object21 = 'climate.order';

/**
 * The current status of this order.
 */
export type status7 = 'awaiting_funds' | 'canceled' | 'confirmed' | 'delivered' | 'open';

/**
 * A Climate product represents a type of carbon removal unit available for reservation.
 * You can retrieve it to see the current price and availability.
 */
export type climate_product = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Current prices for a metric ton of carbon removal in a currency's smallest unit.
   */
  current_prices_per_metric_ton: {
    [key: string]: climate_removals_products_price;
  };
  /**
   * The year in which the carbon removal is expected to be delivered.
   */
  delivery_year?: number | null;
  /**
   * Unique identifier for the object. For convenience, Climate product IDs are human-readable strings
   * that start with `climsku_`. See [carbon removal inventory](https://stripe.com/docs/climate/orders/carbon-removal-inventory)
   * for a list of available carbon removal products.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The quantity of metric tons available for reservation.
   */
  metric_tons_available: string;
  /**
   * The Climate product's name.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'climate.product';
  /**
   * The carbon removal suppliers that fulfill orders for this Climate product.
   */
  suppliers: Array<climate_supplier>;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object22 = 'climate.product';

export type climate_removals_beneficiary = {
  /**
   * Publicly displayable name for the end beneficiary of carbon removal.
   */
  public_name: string;
};

export type climate_removals_location = {
  /**
   * The city where the supplier is located.
   */
  city?: string | null;
  /**
   * Two-letter ISO code representing the country where the supplier is located.
   */
  country: string;
  /**
   * The geographic latitude where the supplier is located.
   */
  latitude?: number | null;
  /**
   * The geographic longitude where the supplier is located.
   */
  longitude?: number | null;
  /**
   * The state/county/province/region where the supplier is located.
   */
  region?: string | null;
};

/**
 * The delivery of a specified quantity of carbon for an order.
 */
export type climate_removals_order_deliveries = {
  /**
   * Time at which the delivery occurred. Measured in seconds since the Unix epoch.
   */
  delivered_at: number;
  /**
   * Specific location of this delivery.
   */
  location?: climate_removals_location | null;
  /**
   * Quantity of carbon removal supplied by this delivery.
   */
  metric_tons: string;
  /**
   * Once retired, a URL to the registry entry for the tons from this delivery.
   */
  registry_url?: string | null;
  supplier: climate_supplier;
};

export type climate_removals_products_price = {
  /**
   * Fees for one metric ton of carbon removal in the currency's smallest unit.
   */
  amount_fees: number;
  /**
   * Subtotal for one metric ton of carbon removal (excluding fees) in the currency's smallest unit.
   */
  amount_subtotal: number;
  /**
   * Total for one metric ton of carbon removal (including fees) in the currency's smallest unit.
   */
  amount_total: number;
};

/**
 * A supplier of carbon removal.
 */
export type climate_supplier = {
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Link to a webpage to learn more about the supplier.
   */
  info_url: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The locations in which this supplier operates.
   */
  locations: Array<climate_removals_location>;
  /**
   * Name of this carbon removal supplier.
   */
  name: string;
  /**
   * String representing the object’s type. Objects of the same type share the same value.
   */
  object: 'climate.supplier';
  /**
   * The scientific pathway used for carbon removal.
   */
  removal_pathway: 'biomass_carbon_removal_and_storage' | 'direct_air_capture' | 'enhanced_weathering';
};

/**
 * String representing the object’s type. Objects of the same type share the same value.
 */
export type object23 = 'climate.supplier';

/**
 * The scientific pathway used for carbon removal.
 */
export type removal_pathway = 'biomass_carbon_removal_and_storage' | 'direct_air_capture' | 'enhanced_weathering';

/**
 * ConfirmationTokens help transport client side data collected by Stripe JS over
 * to your server for confirming a PaymentIntent or SetupIntent. If the confirmation
 * is successful, values present on the ConfirmationToken are written onto the Intent.
 *
 * To learn more about how to use ConfirmationToken, visit the related guides:
 * - [Finalize payments on the server](https://stripe.com/docs/payments/finalize-payments-on-the-server)
 * - [Build two-step confirmation](https://stripe.com/docs/payments/build-a-two-step-confirmation).
 */
export type confirmation_token = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Time at which this ConfirmationToken expires and can no longer be used to confirm a PaymentIntent or SetupIntent.
   */
  expires_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Data used for generating a Mandate.
   */
  mandate_data?: confirmation_tokens_resource_mandate_data | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'confirmation_token';
  /**
   * ID of the PaymentIntent that this ConfirmationToken was used to confirm, or null if this ConfirmationToken has not yet been used.
   */
  payment_intent?: string | null;
  /**
   * Payment details collected by the Payment Element, used to create a PaymentMethod when a PaymentIntent or SetupIntent is confirmed with this ConfirmationToken.
   */
  payment_method_preview?: confirmation_tokens_resource_payment_method_preview | null;
  /**
   * Return URL used to confirm the Intent.
   */
  return_url?: string | null;
  /**
   * Indicates that you intend to make future payments with this ConfirmationToken's payment method.
   *
   * The presence of this property will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
   */
  setup_future_usage?: ('off_session' | 'on_session') | null;
  /**
   * ID of the SetupIntent that this ConfirmationToken was used to confirm, or null if this ConfirmationToken has not yet been used.
   */
  setup_intent?: string | null;
  /**
   * Shipping information collected on this ConfirmationToken.
   */
  shipping?: confirmation_tokens_resource_shipping | null;
  /**
   * Indicates whether the Stripe SDK is used to handle confirmation flow. Defaults to `true` on ConfirmationToken.
   */
  use_stripe_sdk: boolean;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object24 = 'confirmation_token';

/**
 * Indicates that you intend to make future payments with this ConfirmationToken's payment method.
 *
 * The presence of this property will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.
 */
export type setup_future_usage4 = 'off_session' | 'on_session';

/**
 * Data used for generating a Mandate.
 */
export type confirmation_tokens_resource_mandate_data = {
  customer_acceptance: confirmation_tokens_resource_mandate_data_resource_customer_acceptance;
};

/**
 * This hash contains details about the customer acceptance of the Mandate.
 */
export type confirmation_tokens_resource_mandate_data_resource_customer_acceptance = {
  /**
   * If this is a Mandate accepted online, this hash contains details about the online acceptance.
   */
  online?: confirmation_tokens_resource_mandate_data_resource_customer_acceptance_resource_online | null;
  /**
   * The type of customer acceptance information included with the Mandate.
   */
  type: string;
};

/**
 * This hash contains details about the online acceptance.
 */
export type confirmation_tokens_resource_mandate_data_resource_customer_acceptance_resource_online = {
  /**
   * The IP address from which the Mandate was accepted by the customer.
   */
  ip_address?: string | null;
  /**
   * The user agent of the browser from which the Mandate was accepted by the customer.
   */
  user_agent?: string | null;
};

/**
 * Details of the PaymentMethod collected by Payment Element
 */
export type confirmation_tokens_resource_payment_method_preview = {
  acss_debit?: payment_method_acss_debit;
  affirm?: payment_method_affirm;
  afterpay_clearpay?: payment_method_afterpay_clearpay;
  alipay?: payment_flows_private_payment_methods_alipay;
  /**
   * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow. The field defaults to “unspecified”.
   */
  allow_redisplay?: 'always' | 'limited' | 'unspecified';
  amazon_pay?: payment_method_amazon_pay;
  au_becs_debit?: payment_method_au_becs_debit;
  bacs_debit?: payment_method_bacs_debit;
  bancontact?: payment_method_bancontact;
  billing_details: billing_details;
  blik?: payment_method_blik;
  boleto?: payment_method_boleto;
  card?: payment_method_card;
  card_present?: payment_method_card_present;
  cashapp?: payment_method_cashapp;
  customer_balance?: payment_method_customer_balance;
  eps?: payment_method_eps;
  fpx?: payment_method_fpx;
  giropay?: payment_method_giropay;
  grabpay?: payment_method_grabpay;
  ideal?: payment_method_ideal;
  interac_present?: payment_method_interac_present;
  klarna?: payment_method_klarna;
  konbini?: payment_method_konbini;
  link?: payment_method_link;
  mobilepay?: payment_method_mobilepay;
  multibanco?: payment_method_multibanco;
  oxxo?: payment_method_oxxo;
  p24?: payment_method_p24;
  paynow?: payment_method_paynow;
  paypal?: payment_method_paypal;
  pix?: payment_method_pix;
  promptpay?: payment_method_promptpay;
  revolut_pay?: payment_method_revolut_pay;
  sepa_debit?: payment_method_sepa_debit;
  sofort?: payment_method_sofort;
  swish?: payment_method_swish;
  twint?: payment_method_twint;
  /**
   * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.
   */
  type:
    | 'acss_debit'
    | 'affirm'
    | 'afterpay_clearpay'
    | 'alipay'
    | 'amazon_pay'
    | 'au_becs_debit'
    | 'bacs_debit'
    | 'bancontact'
    | 'blik'
    | 'boleto'
    | 'card'
    | 'card_present'
    | 'cashapp'
    | 'customer_balance'
    | 'eps'
    | 'fpx'
    | 'giropay'
    | 'grabpay'
    | 'ideal'
    | 'interac_present'
    | 'klarna'
    | 'konbini'
    | 'link'
    | 'mobilepay'
    | 'multibanco'
    | 'oxxo'
    | 'p24'
    | 'paynow'
    | 'paypal'
    | 'pix'
    | 'promptpay'
    | 'revolut_pay'
    | 'sepa_debit'
    | 'sofort'
    | 'swish'
    | 'twint'
    | 'us_bank_account'
    | 'wechat_pay'
    | 'zip';
  us_bank_account?: payment_method_us_bank_account;
  wechat_pay?: payment_method_wechat_pay;
  zip?: payment_method_zip;
};

/**
 * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow. The field defaults to “unspecified”.
 */
export type allow_redisplay = 'always' | 'limited' | 'unspecified';

/**
 * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.
 */
export type type11 =
  | 'acss_debit'
  | 'affirm'
  | 'afterpay_clearpay'
  | 'alipay'
  | 'amazon_pay'
  | 'au_becs_debit'
  | 'bacs_debit'
  | 'bancontact'
  | 'blik'
  | 'boleto'
  | 'card'
  | 'card_present'
  | 'cashapp'
  | 'customer_balance'
  | 'eps'
  | 'fpx'
  | 'giropay'
  | 'grabpay'
  | 'ideal'
  | 'interac_present'
  | 'klarna'
  | 'konbini'
  | 'link'
  | 'mobilepay'
  | 'multibanco'
  | 'oxxo'
  | 'p24'
  | 'paynow'
  | 'paypal'
  | 'pix'
  | 'promptpay'
  | 'revolut_pay'
  | 'sepa_debit'
  | 'sofort'
  | 'swish'
  | 'twint'
  | 'us_bank_account'
  | 'wechat_pay'
  | 'zip';

export type confirmation_tokens_resource_shipping = {
  address: address;
  /**
   * Recipient name.
   */
  name: string;
  /**
   * Recipient phone (including extension).
   */
  phone?: string | null;
};

export type connect_account_reference = {
  /**
   * The connected account being referenced when `type` is `account`.
   */
  account?: string | account;
  /**
   * Type of the account referenced.
   */
  type: 'account' | 'self';
};

/**
 * Type of the account referenced.
 */
export type type12 = 'account' | 'self';

export type connect_collection_transfer = {
  /**
   * Amount transferred, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the account that funds are being collected for.
   */
  destination: string | account;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'connect_collection_transfer';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object25 = 'connect_collection_transfer';

export type connect_embedded_account_config_claim = {
  /**
   * Whether the embedded component is enabled.
   */
  enabled: boolean;
  features: connect_embedded_account_features_claim;
};

export type connect_embedded_account_features_claim = {
  /**
   * Whether to allow platforms to control bank account collection for their connected accounts. This feature can only be false for custom accounts (or accounts where the platform is compliance owner). Otherwise, bank account collection is determined by compliance requirements.
   */
  external_account_collection: boolean;
};

export type connect_embedded_account_session_create_components = {
  account_management: connect_embedded_account_config_claim;
  account_onboarding: connect_embedded_account_config_claim;
  balances: connect_embedded_payouts_config_claim;
  documents: connect_embedded_base_config_claim;
  notification_banner: connect_embedded_account_config_claim;
  payment_details: connect_embedded_payments_config_claim;
  payments: connect_embedded_payments_config_claim;
  payouts: connect_embedded_payouts_config_claim;
  payouts_list: connect_embedded_base_config_claim;
};

export type connect_embedded_base_config_claim = {
  /**
   * Whether the embedded component is enabled.
   */
  enabled: boolean;
  features: connect_embedded_base_features;
};

export type connect_embedded_base_features = {
  [key: string]: unknown;
};

export type connect_embedded_payments_config_claim = {
  /**
   * Whether the embedded component is enabled.
   */
  enabled: boolean;
  features: connect_embedded_payments_features;
};

export type connect_embedded_payments_features = {
  /**
   * Whether to allow capturing and cancelling payment intents. This is `true` by default.
   */
  capture_payments: boolean;
  /**
   * Whether to allow connected accounts to manage destination charges that are created on behalf of them. This is `false` by default.
   */
  destination_on_behalf_of_charge_management: boolean;
  /**
   * Whether to allow responding to disputes, including submitting evidence and accepting disputes. This is `true` by default.
   */
  dispute_management: boolean;
  /**
   * Whether to allow sending refunds. This is `true` by default.
   */
  refund_management: boolean;
};

export type connect_embedded_payouts_config_claim = {
  /**
   * Whether the embedded component is enabled.
   */
  enabled: boolean;
  features: connect_embedded_payouts_features;
};

export type connect_embedded_payouts_features = {
  /**
   * Whether to allow payout schedule to be changed. Default `true` when Stripe owns Loss Liability, default `false` otherwise.
   */
  edit_payout_schedule: boolean;
  /**
   * Whether to allow platforms to control bank account collection for their connected accounts. This feature can only be false for custom accounts (or accounts where the platform is compliance owner). Otherwise, bank account collection is determined by compliance requirements.
   */
  external_account_collection: boolean;
  /**
   * Whether to allow creation of instant payouts. Default `true` when Stripe owns Loss Liability, default `false` otherwise.
   */
  instant_payouts: boolean;
  /**
   * Whether to allow creation of standard payouts. Default `true` when Stripe owns Loss Liability, default `false` otherwise.
   */
  standard_payouts: boolean;
};

/**
 * Stripe needs to collect certain pieces of information about each account
 * created. These requirements can differ depending on the account's country. The
 * Country Specs API makes these rules available to your integration.
 *
 * You can also view the information from this API call as [an online
 * guide](/docs/connect/required-verification-information).
 */
export type country_spec = {
  /**
   * The default currency for this country. This applies to both payment methods and bank accounts.
   */
  default_currency: string;
  /**
   * Unique identifier for the object. Represented as the ISO country code for this country.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'country_spec';
  /**
   * Currencies that can be accepted in the specific country (for transfers).
   */
  supported_bank_account_currencies: {
    [key: string]: Array<string>;
  };
  /**
   * Currencies that can be accepted in the specified country (for payments).
   */
  supported_payment_currencies: Array<string>;
  /**
   * Payment methods available in the specified country. You may need to enable some payment methods (e.g., [ACH](https://stripe.com/docs/ach)) on your account before they appear in this list. The `stripe` payment method refers to [charging through your platform](https://stripe.com/docs/connect/destination-charges).
   */
  supported_payment_methods: Array<string>;
  /**
   * Countries that can accept transfers from the specified country.
   */
  supported_transfer_countries: Array<string>;
  verification_fields: country_spec_verification_fields;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object26 = 'country_spec';

export type country_spec_verification_field_details = {
  /**
   * Additional fields which are only required for some users.
   */
  additional: Array<string>;
  /**
   * Fields which every account must eventually provide.
   */
  minimum: Array<string>;
};

export type country_spec_verification_fields = {
  company: country_spec_verification_field_details;
  individual: country_spec_verification_field_details;
};

/**
 * A coupon contains information about a percent-off or amount-off discount you
 * might want to apply to a customer. Coupons may be applied to [subscriptions](https://stripe.com/docs/api#subscriptions), [invoices](https://stripe.com/docs/api#invoices),
 * [checkout sessions](https://stripe.com/docs/api/checkout/sessions), [quotes](https://stripe.com/docs/api#quotes), and more. Coupons do not work with conventional one-off [charges](https://stripe.com/docs/api#create_charge) or [payment intents](https://stripe.com/docs/api/payment_intents).
 */
export type coupon = {
  /**
   * Amount (in the `currency` specified) that will be taken off the subtotal of any invoices for this customer.
   */
  amount_off?: number | null;
  applies_to?: coupon_applies_to;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * If `amount_off` has been set, the three-letter [ISO code for the currency](https://stripe.com/docs/currencies) of the amount to take off.
   */
  currency?: string | null;
  /**
   * Coupons defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).
   */
  currency_options?: {
    [key: string]: coupon_currency_option;
  };
  /**
   * One of `forever`, `once`, and `repeating`. Describes how long a customer who applies this coupon will get the discount.
   */
  duration: 'forever' | 'once' | 'repeating';
  /**
   * If `duration` is `repeating`, the number of months the coupon applies. Null if coupon `duration` is `forever` or `once`.
   */
  duration_in_months?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Maximum number of times this coupon can be redeemed, in total, across all customers, before it is no longer valid.
   */
  max_redemptions?: number | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * Name of the coupon displayed to customers on for instance invoices or receipts.
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'coupon';
  /**
   * Percent that will be taken off the subtotal of any invoices for this customer for the duration of the coupon. For example, a coupon with percent_off of 50 will make a $ (or local equivalent)100 invoice $ (or local equivalent)50 instead.
   */
  percent_off?: number | null;
  /**
   * Date after which the coupon can no longer be redeemed.
   */
  redeem_by?: number | null;
  /**
   * Number of times this coupon has been applied to a customer.
   */
  times_redeemed: number;
  /**
   * Taking account of the above properties, whether this coupon can still be applied to a customer.
   */
  valid: boolean;
};

/**
 * One of `forever`, `once`, and `repeating`. Describes how long a customer who applies this coupon will get the discount.
 */
export type duration = 'forever' | 'once' | 'repeating';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object27 = 'coupon';

export type coupon_applies_to = {
  /**
   * A list of product IDs this coupon applies to
   */
  products: Array<string>;
};

export type coupon_currency_option = {
  /**
   * Amount (in the `currency` specified) that will be taken off the subtotal of any invoices for this customer.
   */
  amount_off: number;
};

/**
 * Issue a credit note to adjust an invoice's amount after the invoice is finalized.
 *
 * Related guide: [Credit notes](https://stripe.com/docs/billing/invoices/credit-notes)
 */
export type credit_note = {
  /**
   * The integer amount in cents (or local equivalent) representing the total amount of the credit note, including tax.
   */
  amount: number;
  /**
   * This is the sum of all the shipping amounts.
   */
  amount_shipping: number;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the customer.
   */
  customer: string | customer | deleted_customer;
  /**
   * Customer balance transaction related to this credit note.
   */
  customer_balance_transaction?: (string | customer_balance_transaction) | null;
  /**
   * The integer amount in cents (or local equivalent) representing the total amount of discount that was credited.
   */
  discount_amount: number;
  /**
   * The aggregate amounts calculated per discount for all line items.
   */
  discount_amounts: Array<discounts_resource_discount_amount>;
  /**
   * The date when this credit note is in effect. Same as `created` unless overwritten. When defined, this value replaces the system-generated 'Date of issue' printed on the credit note PDF.
   */
  effective_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * ID of the invoice.
   */
  invoice: string | invoice;
  /**
   * Line items that make up the credit note
   */
  lines: {
    /**
     * Details about each object.
     */
    data: Array<credit_note_line_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Customer-facing text that appears on the credit note PDF.
   */
  memo?: string | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * A unique number that identifies this particular credit note and appears on the PDF of the credit note and its associated invoice.
   */
  number: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'credit_note';
  /**
   * Amount that was credited outside of Stripe.
   */
  out_of_band_amount?: number | null;
  /**
   * The link to download the PDF of the credit note.
   */
  pdf: string;
  /**
   * Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or `product_unsatisfactory`
   */
  reason?: ('duplicate' | 'fraudulent' | 'order_change' | 'product_unsatisfactory') | null;
  /**
   * Refund related to this credit note.
   */
  refund?: (string | refund) | null;
  /**
   * The details of the cost of shipping, including the ShippingRate applied to the invoice.
   */
  shipping_cost?: invoices_resource_shipping_cost | null;
  /**
   * Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).
   */
  status: 'issued' | 'void';
  /**
   * The integer amount in cents (or local equivalent) representing the amount of the credit note, excluding exclusive tax and invoice level discounts.
   */
  subtotal: number;
  /**
   * The integer amount in cents (or local equivalent) representing the amount of the credit note, excluding all tax and invoice level discounts.
   */
  subtotal_excluding_tax?: number | null;
  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  tax_amounts: Array<credit_note_tax_amount>;
  /**
   * The integer amount in cents (or local equivalent) representing the total amount of the credit note, including tax and all discount.
   */
  total: number;
  /**
   * The integer amount in cents (or local equivalent) representing the total amount of the credit note, excluding tax, but including discounts.
   */
  total_excluding_tax?: number | null;
  /**
   * Type of this credit note, one of `pre_payment` or `post_payment`. A `pre_payment` credit note means it was issued when the invoice was open. A `post_payment` credit note means it was issued when the invoice was paid.
   */
  type: 'post_payment' | 'pre_payment';
  /**
   * The time that the credit note was voided.
   */
  voided_at?: number | null;
};

/**
 * Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or `product_unsatisfactory`
 */
export type reason2 = 'duplicate' | 'fraudulent' | 'order_change' | 'product_unsatisfactory';

/**
 * Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).
 */
export type status8 = 'issued' | 'void';

/**
 * Type of this credit note, one of `pre_payment` or `post_payment`. A `pre_payment` credit note means it was issued when the invoice was open. A `post_payment` credit note means it was issued when the invoice was paid.
 */
export type type13 = 'post_payment' | 'pre_payment';

/**
 * The credit note line item object
 */
export type credit_note_line_item = {
  /**
   * The integer amount in cents (or local equivalent) representing the gross amount being credited for this line item, excluding (exclusive) tax and discounts.
   */
  amount: number;
  /**
   * The integer amount in cents (or local equivalent) representing the amount being credited for this line item, excluding all tax and discounts.
   */
  amount_excluding_tax?: number | null;
  /**
   * Description of the item being credited.
   */
  description?: string | null;
  /**
   * The integer amount in cents (or local equivalent) representing the discount being credited for this line item.
   */
  discount_amount: number;
  /**
   * The amount of discount calculated per discount for this line item
   */
  discount_amounts: Array<discounts_resource_discount_amount>;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * ID of the invoice line item being credited
   */
  invoice_line_item?: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'credit_note_line_item';
  /**
   * The number of units of product being credited.
   */
  quantity?: number | null;
  /**
   * The amount of tax calculated per tax rate for this line item
   */
  tax_amounts: Array<credit_note_tax_amount>;
  /**
   * The tax rates which apply to the line item.
   */
  tax_rates: Array<tax_rate>;
  /**
   * The type of the credit note line item, one of `invoice_line_item` or `custom_line_item`. When the type is `invoice_line_item` there is an additional `invoice_line_item` property on the resource the value of which is the id of the credited line item on the invoice.
   */
  type: 'custom_line_item' | 'invoice_line_item';
  /**
   * The cost of each unit of product being credited.
   */
  unit_amount?: number | null;
  /**
   * Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.
   */
  unit_amount_decimal?: string | null;
  /**
   * The amount in cents (or local equivalent) representing the unit amount being credited for this line item, excluding all tax and discounts.
   */
  unit_amount_excluding_tax?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object28 = 'credit_note_line_item';

/**
 * The type of the credit note line item, one of `invoice_line_item` or `custom_line_item`. When the type is `invoice_line_item` there is an additional `invoice_line_item` property on the resource the value of which is the id of the credited line item on the invoice.
 */
export type type14 = 'custom_line_item' | 'invoice_line_item';

export type credit_note_tax_amount = {
  /**
   * The amount, in cents (or local equivalent), of the tax.
   */
  amount: number;
  /**
   * Whether this tax amount is inclusive or exclusive.
   */
  inclusive: boolean;
  /**
   * The tax rate that was applied to get this tax amount.
   */
  tax_rate: string | tax_rate;
  /**
   * The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.
   */
  taxability_reason?:
    | (
        | 'customer_exempt'
        | 'not_collecting'
        | 'not_subject_to_tax'
        | 'not_supported'
        | 'portion_product_exempt'
        | 'portion_reduced_rated'
        | 'portion_standard_rated'
        | 'product_exempt'
        | 'product_exempt_holiday'
        | 'proportionally_rated'
        | 'reduced_rated'
        | 'reverse_charge'
        | 'standard_rated'
        | 'taxable_basis_reduced'
        | 'zero_rated'
      )
    | null;
  /**
   * The amount on which tax is calculated, in cents (or local equivalent).
   */
  taxable_amount?: number | null;
};

/**
 * The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.
 */
export type taxability_reason =
  | 'customer_exempt'
  | 'not_collecting'
  | 'not_subject_to_tax'
  | 'not_supported'
  | 'portion_product_exempt'
  | 'portion_reduced_rated'
  | 'portion_standard_rated'
  | 'product_exempt'
  | 'product_exempt_holiday'
  | 'proportionally_rated'
  | 'reduced_rated'
  | 'reverse_charge'
  | 'standard_rated'
  | 'taxable_basis_reduced'
  | 'zero_rated';

export type currency_option = {
  /**
   * When set, provides configuration for the amount to be adjusted by the customer during Checkout Sessions and Payment Links.
   */
  custom_unit_amount?: custom_unit_amount | null;
  /**
   * Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
   */
  tax_behavior?: ('exclusive' | 'inclusive' | 'unspecified') | null;
  /**
   * Each element represents a pricing tier. This parameter requires `billing_scheme` to be set to `tiered`. See also the documentation for `billing_scheme`.
   */
  tiers?: Array<price_tier>;
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a whole integer if possible. Only set if `billing_scheme=per_unit`.
   */
  unit_amount?: number | null;
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a decimal string with at most 12 decimal places. Only set if `billing_scheme=per_unit`.
   */
  unit_amount_decimal?: string | null;
};

/**
 * Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
 */
export type tax_behavior = 'exclusive' | 'inclusive' | 'unspecified';

export type custom_unit_amount = {
  /**
   * The maximum unit amount the customer can specify for this item.
   */
  maximum?: number | null;
  /**
   * The minimum unit amount the customer can specify for this item. Must be at least the minimum charge amount.
   */
  minimum?: number | null;
  /**
   * The starting unit amount which can be updated by the customer.
   */
  preset?: number | null;
};

/**
 * This object represents a customer of your business. Use it to create recurring charges and track payments that belong to the same customer.
 *
 * Related guide: [Save a card during payment](https://stripe.com/docs/payments/save-during-payment)
 */
export type customer = {
  /**
   * The customer's address.
   */
  address?: address | null;
  /**
   * The current balance, if any, that's stored on the customer. If negative, the customer has credit to apply to their next invoice. If positive, the customer has an amount owed that's added to their next invoice. The balance only considers amounts that Stripe hasn't successfully applied to any invoice. It doesn't reflect unpaid invoices. This balance is only taken into account after invoices finalize.
   */
  balance?: number;
  /**
   * The current funds being held by Stripe on behalf of the customer. You can apply these funds towards payment intents when the source is "cash_balance". The `settings[reconciliation_mode]` field describes if these funds apply to these payment intents manually or automatically.
   */
  cash_balance?: cash_balance | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) the customer can be charged in for recurring billing purposes.
   */
  currency?: string | null;
  /**
   * ID of the default payment source for the customer.
   *
   * If you use payment methods created through the PaymentMethods API, see the [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) field instead.
   */
  default_source?: (string | bank_account | card | source) | null;
  /**
   * Tracks the most recent state change on any invoice belonging to the customer. Paying an invoice or marking it uncollectible via the API will set this field to false. An automatic payment failure or passing the `invoice.due_date` will set this field to `true`.
   *
   * If an invoice becomes uncollectible by [dunning](https://stripe.com/docs/billing/automatic-collection), `delinquent` doesn't reset to `false`.
   *
   * If you care whether the customer has paid their most recent subscription invoice, use `subscription.status` instead. Paying or marking uncollectible any customer invoice regardless of whether it is the latest invoice for a subscription will always set this field to `false`.
   */
  delinquent?: boolean | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Describes the current discount active on the customer, if there is one.
   */
  discount?: discount | null;
  /**
   * The customer's email address.
   */
  email?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The current multi-currency balances, if any, that's stored on the customer. If positive in a currency, the customer has a credit to apply to their next invoice denominated in that currency. If negative, the customer has an amount owed that's added to their next invoice denominated in that currency. These balances don't apply to unpaid invoices. They solely track amounts that Stripe hasn't successfully applied to any invoice. Stripe only applies a balance in a specific currency to an invoice after that invoice (which is in the same currency) finalizes.
   */
  invoice_credit_balance?: {
    [key: string]: number;
  };
  /**
   * The prefix for the customer used to generate unique invoice numbers.
   */
  invoice_prefix?: string | null;
  invoice_settings?: invoice_setting_customer_setting;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  };
  /**
   * The customer's full name or business name.
   */
  name?: string | null;
  /**
   * The suffix of the customer's next invoice number (for example, 0001).
   */
  next_invoice_sequence?: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'customer';
  /**
   * The customer's phone number.
   */
  phone?: string | null;
  /**
   * The customer's preferred locales (languages), ordered by preference.
   */
  preferred_locales?: Array<string> | null;
  /**
   * Mailing and shipping address for the customer. Appears on invoices emailed to this customer.
   */
  shipping?: shipping | null;
  /**
   * The customer's payment sources, if any.
   */
  sources?: {
    /**
     * Details about each object.
     */
    data: Array<bank_account | card | source>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * The customer's current subscriptions, if any.
   */
  subscriptions?: {
    /**
     * Details about each object.
     */
    data: Array<subscription>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  tax?: customer_tax;
  /**
   * Describes the customer's tax exemption status, which is `none`, `exempt`, or `reverse`. When set to `reverse`, invoice and receipt PDFs include the following text: **"Reverse charge"**.
   */
  tax_exempt?: ('exempt' | 'none' | 'reverse') | null;
  /**
   * The customer's tax IDs.
   */
  tax_ids?: {
    /**
     * Details about each object.
     */
    data: Array<tax_id>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * ID of the test clock that this customer belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object29 = 'customer';

/**
 * Describes the customer's tax exemption status, which is `none`, `exempt`, or `reverse`. When set to `reverse`, invoice and receipt PDFs include the following text: **"Reverse charge"**.
 */
export type tax_exempt = 'exempt' | 'none' | 'reverse';

export type customer_acceptance = {
  /**
   * The time that the customer accepts the mandate.
   */
  accepted_at?: number | null;
  offline?: offline_acceptance;
  online?: online_acceptance;
  /**
   * The mandate includes the type of customer acceptance information, such as: `online` or `offline`.
   */
  type: 'offline' | 'online';
};

/**
 * The mandate includes the type of customer acceptance information, such as: `online` or `offline`.
 */
export type type15 = 'offline' | 'online';

export type customer_balance_customer_balance_settings = {
  /**
   * The configuration for how funds that land in the customer cash balance are reconciled.
   */
  reconciliation_mode: 'automatic' | 'manual';
  /**
   * A flag to indicate if reconciliation mode returned is the user's default or is specific to this customer cash balance
   */
  using_merchant_default: boolean;
};

/**
 * The configuration for how funds that land in the customer cash balance are reconciled.
 */
export type reconciliation_mode = 'automatic' | 'manual';

export type customer_balance_resource_cash_balance_transaction_resource_adjusted_for_overdraft = {
  /**
   * The [Balance Transaction](https://stripe.com/docs/api/balance_transactions/object) that corresponds to funds taken out of your Stripe balance.
   */
  balance_transaction: string | balance_transaction;
  /**
   * The [Cash Balance Transaction](https://stripe.com/docs/api/cash_balance_transactions/object) that brought the customer balance negative, triggering the clawback of funds.
   */
  linked_transaction: string | customer_cash_balance_transaction;
};

export type customer_balance_resource_cash_balance_transaction_resource_applied_to_payment_transaction = {
  /**
   * The [Payment Intent](https://stripe.com/docs/api/payment_intents/object) that funds were applied to.
   */
  payment_intent: string | payment_intent;
};

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction = {
  bank_transfer: customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer;
};

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer = {
  eu_bank_transfer?: customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_eu_bank_transfer;
  gb_bank_transfer?: customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_gb_bank_transfer;
  jp_bank_transfer?: customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_jp_bank_transfer;
  /**
   * The user-supplied reference field on the bank transfer.
   */
  reference?: string | null;
  /**
   * The funding method type used to fund the customer balance. Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
   */
  type: 'eu_bank_transfer' | 'gb_bank_transfer' | 'jp_bank_transfer' | 'mx_bank_transfer' | 'us_bank_transfer';
  us_bank_transfer?: customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_us_bank_transfer;
};

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_eu_bank_transfer =
  {
    /**
     * The BIC of the bank of the sender of the funding.
     */
    bic?: string | null;
    /**
     * The last 4 digits of the IBAN of the sender of the funding.
     */
    iban_last4?: string | null;
    /**
     * The full name of the sender, as supplied by the sending bank.
     */
    sender_name?: string | null;
  };

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_gb_bank_transfer =
  {
    /**
     * The last 4 digits of the account number of the sender of the funding.
     */
    account_number_last4?: string | null;
    /**
     * The full name of the sender, as supplied by the sending bank.
     */
    sender_name?: string | null;
    /**
     * The sort code of the bank of the sender of the funding
     */
    sort_code?: string | null;
  };

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_jp_bank_transfer =
  {
    /**
     * The name of the bank of the sender of the funding.
     */
    sender_bank?: string | null;
    /**
     * The name of the bank branch of the sender of the funding.
     */
    sender_branch?: string | null;
    /**
     * The full name of the sender, as supplied by the sending bank.
     */
    sender_name?: string | null;
  };

export type customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_us_bank_transfer =
  {
    /**
     * The banking network used for this funding.
     */
    network?: 'ach' | 'domestic_wire_us' | 'swift';
    /**
     * The full name of the sender, as supplied by the sending bank.
     */
    sender_name?: string | null;
  };

/**
 * The banking network used for this funding.
 */
export type network = 'ach' | 'domestic_wire_us' | 'swift';

export type customer_balance_resource_cash_balance_transaction_resource_refunded_from_payment_transaction = {
  /**
   * The [Refund](https://stripe.com/docs/api/refunds/object) that moved these funds into the customer's cash balance.
   */
  refund: string | refund;
};

export type customer_balance_resource_cash_balance_transaction_resource_transferred_to_balance = {
  /**
   * The [Balance Transaction](https://stripe.com/docs/api/balance_transactions/object) that corresponds to funds transferred to your Stripe balance.
   */
  balance_transaction: string | balance_transaction;
};

export type customer_balance_resource_cash_balance_transaction_resource_unapplied_from_payment_transaction = {
  /**
   * The [Payment Intent](https://stripe.com/docs/api/payment_intents/object) that funds were unapplied from.
   */
  payment_intent: string | payment_intent;
};

/**
 * Each customer has a [Balance](https://stripe.com/docs/api/customers/object#customer_object-balance) value,
 * which denotes a debit or credit that's automatically applied to their next invoice upon finalization.
 * You may modify the value directly by using the [update customer API](https://stripe.com/docs/api/customers/update),
 * or by creating a Customer Balance Transaction, which increments or decrements the customer's `balance` by the specified `amount`.
 *
 * Related guide: [Customer balance](https://stripe.com/docs/billing/customer/balance)
 */
export type customer_balance_transaction = {
  /**
   * The amount of the transaction. A negative value is a credit for the customer's balance, and a positive value is a debit to the customer's `balance`.
   */
  amount: number;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The ID of the credit note (if any) related to the transaction.
   */
  credit_note?: (string | credit_note) | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The ID of the customer the transaction belongs to.
   */
  customer: string | customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * The customer's `balance` after the transaction was applied. A negative value decreases the amount due on the customer's next invoice. A positive value increases the amount due on the customer's next invoice.
   */
  ending_balance: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The ID of the invoice (if any) related to the transaction.
   */
  invoice?: (string | invoice) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'customer_balance_transaction';
  /**
   * Transaction type: `adjustment`, `applied_to_invoice`, `credit_note`, `initial`, `invoice_overpaid`, `invoice_too_large`, `invoice_too_small`, `unspent_receiver_credit`, or `unapplied_from_invoice`. See the [Customer Balance page](https://stripe.com/docs/billing/customer/balance#types) to learn more about transaction types.
   */
  type:
    | 'adjustment'
    | 'applied_to_invoice'
    | 'credit_note'
    | 'initial'
    | 'invoice_overpaid'
    | 'invoice_too_large'
    | 'invoice_too_small'
    | 'migration'
    | 'unapplied_from_invoice'
    | 'unspent_receiver_credit';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object30 = 'customer_balance_transaction';

/**
 * Transaction type: `adjustment`, `applied_to_invoice`, `credit_note`, `initial`, `invoice_overpaid`, `invoice_too_large`, `invoice_too_small`, `unspent_receiver_credit`, or `unapplied_from_invoice`. See the [Customer Balance page](https://stripe.com/docs/billing/customer/balance#types) to learn more about transaction types.
 */
export type type16 =
  | 'adjustment'
  | 'applied_to_invoice'
  | 'credit_note'
  | 'initial'
  | 'invoice_overpaid'
  | 'invoice_too_large'
  | 'invoice_too_small'
  | 'migration'
  | 'unapplied_from_invoice'
  | 'unspent_receiver_credit';

/**
 * Customers with certain payments enabled have a cash balance, representing funds that were paid
 * by the customer to a merchant, but have not yet been allocated to a payment. Cash Balance Transactions
 * represent when funds are moved into or out of this balance. This includes funding by the customer, allocation
 * to payments, and refunds to the customer.
 */
export type customer_cash_balance_transaction = {
  adjusted_for_overdraft?: customer_balance_resource_cash_balance_transaction_resource_adjusted_for_overdraft;
  applied_to_payment?: customer_balance_resource_cash_balance_transaction_resource_applied_to_payment_transaction;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The customer whose available cash balance changed as a result of this transaction.
   */
  customer: string | customer;
  /**
   * The total available cash balance for the specified currency after this transaction was applied. Represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  ending_balance: number;
  funded?: customer_balance_resource_cash_balance_transaction_resource_funded_transaction;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The amount by which the cash balance changed, represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). A positive value represents funds being added to the cash balance, a negative value represents funds being removed from the cash balance.
   */
  net_amount: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'customer_cash_balance_transaction';
  refunded_from_payment?: customer_balance_resource_cash_balance_transaction_resource_refunded_from_payment_transaction;
  transferred_to_balance?: customer_balance_resource_cash_balance_transaction_resource_transferred_to_balance;
  /**
   * The type of the cash balance transaction. New types may be added in future. See [Customer Balance](https://stripe.com/docs/payments/customer-balance#types) to learn more about these types.
   */
  type:
    | 'adjusted_for_overdraft'
    | 'applied_to_payment'
    | 'funded'
    | 'funding_reversed'
    | 'refunded_from_payment'
    | 'return_canceled'
    | 'return_initiated'
    | 'transferred_to_balance'
    | 'unapplied_from_payment';
  unapplied_from_payment?: customer_balance_resource_cash_balance_transaction_resource_unapplied_from_payment_transaction;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object31 = 'customer_cash_balance_transaction';

/**
 * The type of the cash balance transaction. New types may be added in future. See [Customer Balance](https://stripe.com/docs/payments/customer-balance#types) to learn more about these types.
 */
export type type17 =
  | 'adjusted_for_overdraft'
  | 'applied_to_payment'
  | 'funded'
  | 'funding_reversed'
  | 'refunded_from_payment'
  | 'return_canceled'
  | 'return_initiated'
  | 'transferred_to_balance'
  | 'unapplied_from_payment';

/**
 * A customer session allows you to grant client access to Stripe's frontend SDKs (like StripeJs)
 * control over a customer.
 */
export type customer_session = {
  /**
   * The client secret of this customer session. Used on the client to set up secure access to the given `customer`.
   *
   * The client secret can be used to provide access to `customer` from your frontend. It should not be stored, logged, or exposed to anyone other than the relevant customer. Make sure that you have TLS enabled on any page that includes the client secret.
   */
  client_secret: string;
  components?: customer_session_resource_components;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The customer the customer session was created for.
   */
  customer: string | customer;
  /**
   * The timestamp at which this customer session will expire.
   */
  expires_at: number;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'customer_session';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object32 = 'customer_session';

/**
 * Configuration for the components supported by this customer session.
 */
export type customer_session_resource_components = {
  buy_button: customer_session_resource_components_resource_buy_button;
  pricing_table: customer_session_resource_components_resource_pricing_table;
};

/**
 * This hash contains whether the buy button is enabled.
 */
export type customer_session_resource_components_resource_buy_button = {
  /**
   * Whether the buy button is enabled.
   */
  enabled: boolean;
};

/**
 * This hash contains whether the pricing table is enabled.
 */
export type customer_session_resource_components_resource_pricing_table = {
  /**
   * Whether the pricing table is enabled.
   */
  enabled: boolean;
};

export type customer_tax = {
  /**
   * Surfaces if automatic tax computation is possible given the current customer location information.
   */
  automatic_tax: 'failed' | 'not_collecting' | 'supported' | 'unrecognized_location';
  /**
   * A recent IP address of the customer used for tax reporting and tax location inference.
   */
  ip_address?: string | null;
  /**
   * The customer's location as identified by Stripe Tax.
   */
  location?: customer_tax_location | null;
};

/**
 * Surfaces if automatic tax computation is possible given the current customer location information.
 */
export type automatic_tax2 = 'failed' | 'not_collecting' | 'supported' | 'unrecognized_location';

export type customer_tax_location = {
  /**
   * The customer's country as identified by Stripe Tax.
   */
  country: string;
  /**
   * The data source used to infer the customer's location.
   */
  source: 'billing_address' | 'ip_address' | 'payment_method' | 'shipping_destination';
  /**
   * The customer's state, county, province, or region as identified by Stripe Tax.
   */
  state?: string | null;
};

/**
 * The data source used to infer the customer's location.
 */
export type source = 'billing_address' | 'ip_address' | 'payment_method' | 'shipping_destination';

export type deleted_account = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'account';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object33 = 'account';

export type deleted_apple_pay_domain = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'apple_pay_domain';
};

export type deleted_application = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The name of the application.
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'application';
};

export type deleted_bank_account = {
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.
   */
  currency?: string | null;
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'bank_account';
};

export type deleted_card = {
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.
   */
  currency?: string | null;
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'card';
};

export type deleted_coupon = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'coupon';
};

export type deleted_customer = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'customer';
};

export type deleted_discount = {
  /**
   * The Checkout session that this coupon is applied to, if it is applied to a particular session in payment mode. Will not be present for subscription mode.
   */
  checkout_session?: string | null;
  coupon: coupon;
  /**
   * The ID of the customer associated with this discount.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * The ID of the discount object. Discounts cannot be fetched by ID. Use `expand[]=discounts` in API calls to expand discount IDs in an array.
   */
  id: string;
  /**
   * The invoice that the discount's coupon was applied to, if it was applied directly to a particular invoice.
   */
  invoice?: string | null;
  /**
   * The invoice item `id` (or invoice line item `id` for invoice line items of type='subscription') that the discount's coupon was applied to, if it was applied directly to a particular invoice item or invoice line item.
   */
  invoice_item?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'discount';
  /**
   * The promotion code applied to create this discount.
   */
  promotion_code?: (string | promotion_code) | null;
  /**
   * Date that the coupon was applied.
   */
  start: number;
  /**
   * The subscription that this coupon is applied to, if it is applied to a particular subscription.
   */
  subscription?: string | null;
  /**
   * The subscription item that this coupon is applied to, if it is applied to a particular subscription item.
   */
  subscription_item?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object34 = 'discount';

export type deleted_external_account = deleted_bank_account | deleted_card;

export type deleted_invoice = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'invoice';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object35 = 'invoice';

export type deleted_invoiceitem = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'invoiceitem';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object36 = 'invoiceitem';

export type deleted_payment_source = deleted_bank_account | deleted_card;

export type deleted_person = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'person';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object37 = 'person';

export type deleted_plan = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'plan';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object38 = 'plan';

export type deleted_price = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'price';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object39 = 'price';

export type deleted_product = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'product';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object40 = 'product';

export type deleted_product_feature = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'product_feature';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object41 = 'product_feature';

export type deleted_radar_value_list = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'radar.value_list';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object42 = 'radar.value_list';

export type deleted_radar_value_list_item = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'radar.value_list_item';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object43 = 'radar.value_list_item';

export type deleted_subscription_item = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'subscription_item';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object44 = 'subscription_item';

export type deleted_tax_id = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax_id';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object45 = 'tax_id';

export type deleted_terminal_configuration = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.configuration';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object46 = 'terminal.configuration';

export type deleted_terminal_location = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.location';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object47 = 'terminal.location';

export type deleted_terminal_reader = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.reader';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object48 = 'terminal.reader';

export type deleted_test_helpers_test_clock = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'test_helpers.test_clock';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object49 = 'test_helpers.test_clock';

export type deleted_webhook_endpoint = {
  /**
   * Always true for a deleted object
   */
  deleted: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'webhook_endpoint';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object50 = 'webhook_endpoint';

export type destination_details_unimplemented = {
  [key: string]: unknown;
};

/**
 * A discount represents the actual application of a [coupon](https://stripe.com/docs/api#coupons) or [promotion code](https://stripe.com/docs/api#promotion_codes).
 * It contains information about when the discount began, when it will end, and what it is applied to.
 *
 * Related guide: [Applying discounts to subscriptions](https://stripe.com/docs/billing/subscriptions/discounts)
 */
export type discount = {
  /**
   * The Checkout session that this coupon is applied to, if it is applied to a particular session in payment mode. Will not be present for subscription mode.
   */
  checkout_session?: string | null;
  coupon: coupon;
  /**
   * The ID of the customer associated with this discount.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * If the coupon has a duration of `repeating`, the date that this discount will end. If the coupon has a duration of `once` or `forever`, this attribute will be null.
   */
  end?: number | null;
  /**
   * The ID of the discount object. Discounts cannot be fetched by ID. Use `expand[]=discounts` in API calls to expand discount IDs in an array.
   */
  id: string;
  /**
   * The invoice that the discount's coupon was applied to, if it was applied directly to a particular invoice.
   */
  invoice?: string | null;
  /**
   * The invoice item `id` (or invoice line item `id` for invoice line items of type='subscription') that the discount's coupon was applied to, if it was applied directly to a particular invoice item or invoice line item.
   */
  invoice_item?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'discount';
  /**
   * The promotion code applied to create this discount.
   */
  promotion_code?: (string | promotion_code) | null;
  /**
   * Date that the coupon was applied.
   */
  start: number;
  /**
   * The subscription that this coupon is applied to, if it is applied to a particular subscription.
   */
  subscription?: string | null;
  /**
   * The subscription item that this coupon is applied to, if it is applied to a particular subscription item.
   */
  subscription_item?: string | null;
};

export type discounts_resource_discount_amount = {
  /**
   * The amount, in cents (or local equivalent), of the discount.
   */
  amount: number;
  /**
   * The discount that was applied to get this discount amount.
   */
  discount: string | discount | deleted_discount;
};

export type discounts_resource_stackable_discount = {
  /**
   * ID of the coupon to create a new discount for.
   */
  coupon?: (string | coupon) | null;
  /**
   * ID of an existing discount on the object (or one of its ancestors) to reuse.
   */
  discount?: (string | discount) | null;
  /**
   * ID of the promotion code to create a new discount for.
   */
  promotion_code?: (string | promotion_code) | null;
};

/**
 * A dispute occurs when a customer questions your charge with their card issuer.
 * When this happens, you have the opportunity to respond to the dispute with
 * evidence that shows that the charge is legitimate.
 *
 * Related guide: [Disputes and fraud](https://stripe.com/docs/disputes)
 */
export type dispute = {
  /**
   * Disputed amount. Usually the amount of the charge, but it can differ (usually because of currency fluctuation or because only part of the order is disputed).
   */
  amount: number;
  /**
   * List of zero, one, or two balance transactions that show funds withdrawn and reinstated to your Stripe account as a result of this dispute.
   */
  balance_transactions: Array<balance_transaction>;
  /**
   * ID of the charge that's disputed.
   */
  charge: string | charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  evidence: dispute_evidence;
  evidence_details: dispute_evidence_details;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * If true, it's still possible to refund the disputed payment. After the payment has been fully refunded, no further funds are withdrawn from your Stripe account as a result of this dispute.
   */
  is_charge_refundable: boolean;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'dispute';
  /**
   * ID of the PaymentIntent that's disputed.
   */
  payment_intent?: (string | payment_intent) | null;
  payment_method_details?: dispute_payment_method_details;
  /**
   * Reason given by cardholder for dispute. Possible values are `bank_cannot_process`, `check_returned`, `credit_not_processed`, `customer_initiated`, `debit_not_authorized`, `duplicate`, `fraudulent`, `general`, `incorrect_account_details`, `insufficient_funds`, `product_not_received`, `product_unacceptable`, `subscription_canceled`, or `unrecognized`. Learn more about [dispute reasons](https://stripe.com/docs/disputes/categories).
   */
  reason: string;
  /**
   * Current status of dispute. Possible values are `warning_needs_response`, `warning_under_review`, `warning_closed`, `needs_response`, `under_review`, `won`, or `lost`.
   */
  status:
    | 'lost'
    | 'needs_response'
    | 'under_review'
    | 'warning_closed'
    | 'warning_needs_response'
    | 'warning_under_review'
    | 'won';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object51 = 'dispute';

/**
 * Current status of dispute. Possible values are `warning_needs_response`, `warning_under_review`, `warning_closed`, `needs_response`, `under_review`, `won`, or `lost`.
 */
export type status9 =
  | 'lost'
  | 'needs_response'
  | 'under_review'
  | 'warning_closed'
  | 'warning_needs_response'
  | 'warning_under_review'
  | 'won';

export type dispute_evidence = {
  /**
   * Any server or activity logs showing proof that the customer accessed or downloaded the purchased digital product. This information should include IP addresses, corresponding timestamps, and any detailed recorded activity.
   */
  access_activity_log?: string | null;
  /**
   * The billing address provided by the customer.
   */
  billing_address?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Your subscription cancellation policy, as shown to the customer.
   */
  cancellation_policy?: (string | file) | null;
  /**
   * An explanation of how and when the customer was shown your refund policy prior to purchase.
   */
  cancellation_policy_disclosure?: string | null;
  /**
   * A justification for why the customer's subscription was not canceled.
   */
  cancellation_rebuttal?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any communication with the customer that you feel is relevant to your case. Examples include emails proving that the customer received the product or service, or demonstrating their use of or satisfaction with the product or service.
   */
  customer_communication?: (string | file) | null;
  /**
   * The email address of the customer.
   */
  customer_email_address?: string | null;
  /**
   * The name of the customer.
   */
  customer_name?: string | null;
  /**
   * The IP address that the customer used when making the purchase.
   */
  customer_purchase_ip?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) A relevant document or contract showing the customer's signature.
   */
  customer_signature?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation for the prior charge that can uniquely identify the charge, such as a receipt, shipping label, work order, etc. This document should be paired with a similar document from the disputed payment that proves the two payments are separate.
   */
  duplicate_charge_documentation?: (string | file) | null;
  /**
   * An explanation of the difference between the disputed charge versus the prior charge that appears to be a duplicate.
   */
  duplicate_charge_explanation?: string | null;
  /**
   * The Stripe ID for the prior charge which appears to be a duplicate of the disputed charge.
   */
  duplicate_charge_id?: string | null;
  /**
   * A description of the product or service that was sold.
   */
  product_description?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any receipt or message sent to the customer notifying them of the charge.
   */
  receipt?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Your refund policy, as shown to the customer.
   */
  refund_policy?: (string | file) | null;
  /**
   * Documentation demonstrating that the customer was shown your refund policy prior to purchase.
   */
  refund_policy_disclosure?: string | null;
  /**
   * A justification for why the customer is not entitled to a refund.
   */
  refund_refusal_explanation?: string | null;
  /**
   * The date on which the customer received or began receiving the purchased service, in a clear human-readable format.
   */
  service_date?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation showing proof that a service was provided to the customer. This could include a copy of a signed contract, work order, or other form of written agreement.
   */
  service_documentation?: (string | file) | null;
  /**
   * The address to which a physical product was shipped. You should try to include as complete address information as possible.
   */
  shipping_address?: string | null;
  /**
   * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc. If multiple carriers were used for this purchase, please separate them with commas.
   */
  shipping_carrier?: string | null;
  /**
   * The date on which a physical product began its route to the shipping address, in a clear human-readable format.
   */
  shipping_date?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation showing proof that a product was shipped to the customer at the same address the customer provided to you. This could include a copy of the shipment receipt, shipping label, etc. It should show the customer's full shipping address, if possible.
   */
  shipping_documentation?: (string | file) | null;
  /**
   * The tracking number for a physical product, obtained from the delivery service. If multiple tracking numbers were generated for this purchase, please separate them with commas.
   */
  shipping_tracking_number?: string | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any additional evidence or statements.
   */
  uncategorized_file?: (string | file) | null;
  /**
   * Any additional evidence or statements.
   */
  uncategorized_text?: string | null;
};

export type dispute_evidence_details = {
  /**
   * Date by which evidence must be submitted in order to successfully challenge dispute. Will be 0 if the customer's bank or credit card company doesn't allow a response for this particular dispute.
   */
  due_by?: number | null;
  /**
   * Whether evidence has been staged for this dispute.
   */
  has_evidence: boolean;
  /**
   * Whether the last evidence submission was submitted past the due date. Defaults to `false` if no evidence submissions have occurred. If `true`, then delivery of the latest evidence is *not* guaranteed.
   */
  past_due: boolean;
  /**
   * The number of times evidence has been submitted. Typically, you may only submit evidence once.
   */
  submission_count: number;
};

export type dispute_payment_method_details = {
  card?: dispute_payment_method_details_card;
  klarna?: dispute_payment_method_details_klarna;
  paypal?: dispute_payment_method_details_paypal;
  /**
   * Payment method type.
   */
  type: 'card' | 'klarna' | 'paypal';
};

/**
 * Payment method type.
 */
export type type18 = 'card' | 'klarna' | 'paypal';

export type dispute_payment_method_details_card = {
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand: string;
  /**
   * The card network's specific dispute reason code, which maps to one of Stripe's primary dispute categories to simplify response guidance. The [Network code map](https://stripe.com/docs/disputes/categories#network-code-map) lists all available dispute reason codes by network.
   */
  network_reason_code?: string | null;
};

export type dispute_payment_method_details_klarna = {
  /**
   * The reason for the dispute as defined by Klarna
   */
  reason_code?: string | null;
};

export type dispute_payment_method_details_paypal = {
  /**
   * The ID of the dispute in PayPal.
   */
  case_id?: string | null;
  /**
   * The reason for the dispute as defined by PayPal
   */
  reason_code?: string | null;
};

export type email_sent = {
  /**
   * The timestamp when the email was sent.
   */
  email_sent_at: number;
  /**
   * The recipient's email address.
   */
  email_sent_to: string;
};

/**
 * An active entitlement describes access to a feature for a customer.
 */
export type entitlements_active_entitlement = {
  /**
   * The [Feature](https://stripe.com/docs/api/entitlements/feature) that the customer is entitled to.
   */
  feature: string | entitlements_feature;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A unique key you provide as your own system identifier. This may be up to 80 characters.
   */
  lookup_key: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'entitlements.active_entitlement';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object52 = 'entitlements.active_entitlement';

/**
 * A feature represents a monetizable ability or functionality in your system.
 * Features can be assigned to products, and when those products are purchased, Stripe will create an entitlement to the feature for the purchasing customer.
 */
export type entitlements_feature = {
  /**
   * Inactive features cannot be attached to new products and will not be returned from the features list endpoint.
   */
  active: boolean;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A unique key you provide as your own system identifier. This may be up to 80 characters.
   */
  lookup_key: string;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The feature's name, for your own purpose, not meant to be displayable to the customer.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'entitlements.feature';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object53 = 'entitlements.feature';

export type ephemeral_key = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  expires: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'ephemeral_key';
  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  secret?: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object54 = 'ephemeral_key';

/**
 * An error response from the Stripe API
 */
export type error = {
  error: api_errors;
};

/**
 * Events are our way of letting you know when something interesting happens in
 * your account. When an interesting event occurs, we create a new `Event`
 * object. For example, when a charge succeeds, we create a `charge.succeeded`
 * event, and when an invoice payment attempt fails, we create an
 * `invoice.payment_failed` event. Certain API requests might create multiple
 * events. For example, if you create a new subscription for a
 * customer, you receive both a `customer.subscription.created` event and a
 * `charge.succeeded` event.
 *
 * Events occur when the state of another API resource changes. The event's data
 * field embeds the resource's state at the time of the change. For
 * example, a `charge.succeeded` event contains a charge, and an
 * `invoice.payment_failed` event contains an invoice.
 *
 * As with other API resources, you can use endpoints to retrieve an
 * [individual event](https://stripe.com/docs/api#retrieve_event) or a [list of events](https://stripe.com/docs/api#list_events)
 * from the API. We also have a separate
 * [webhooks](http://en.wikipedia.org/wiki/Webhook) system for sending the
 * `Event` objects directly to an endpoint on your server. You can manage
 * webhooks in your
 * [account settings](https://dashboard.stripe.com/account/webhooks). Learn how
 * to [listen for events](https://docs.stripe.com/webhooks)
 * so that your integration can automatically trigger reactions.
 *
 * When using [Connect](https://docs.stripe.com/connect), you can also receive event notifications
 * that occur in connected accounts. For these events, there's an
 * additional `account` attribute in the received `Event` object.
 *
 * We only guarantee access to events through the [Retrieve Event API](https://stripe.com/docs/api#retrieve_event)
 * for 30 days.
 */
export type event = {
  /**
   * The connected account that originates the event.
   */
  account?: string;
  /**
   * The Stripe API version used to render `data`. This property is populated only for events on or after October 31, 2014.
   */
  api_version?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  data: notification_event_data;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'event';
  /**
   * Number of webhooks that haven't been successfully delivered (for example, to return a 20x response) to the URLs you specify.
   */
  pending_webhooks: number;
  /**
   * Information on the API request that triggers the event.
   */
  request?: notification_event_request | null;
  /**
   * Description of the event (for example, `invoice.created` or `charge.refunded`).
   */
  type: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object55 = 'event';

/**
 * `ExchangeRate` objects allow you to determine the rates that Stripe is currently
 * using to convert from one currency to another. Since this number is variable
 * throughout the day, there are various reasons why you might want to know the current
 * rate (for example, to dynamically price an item for a user with a default
 * payment in a foreign currency).
 *
 * Please refer to our [Exchange Rates API](https://stripe.com/docs/fx-rates) guide for more details.
 *
 * *[Note: this integration path is supported but no longer recommended]* Additionally,
 * you can guarantee that a charge is made with an exchange rate that you expect is
 * current. To do so, you must pass in the exchange_rate to charges endpoints. If the
 * value is no longer up to date, the charge won't go through. Please refer to our
 * [Using with charges](https://stripe.com/docs/exchange-rates) guide for more details.
 *
 * -----
 *
 * &nbsp;
 *
 * *This Exchange Rates API is a Beta Service and is subject to Stripe's terms of service. You may use the API solely for the purpose of transacting on Stripe. For example, the API may be queried in order to:*
 *
 * - *localize prices for processing payments on Stripe*
 * - *reconcile Stripe transactions*
 * - *determine how much money to send to a connected account*
 * - *determine app fees to charge a connected account*
 *
 * *Using this Exchange Rates API beta for any purpose other than to transact on Stripe is strictly prohibited and constitutes a violation of Stripe's terms of service.*
 */
export type exchange_rate = {
  /**
   * Unique identifier for the object. Represented as the three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) in lowercase.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'exchange_rate';
  /**
   * Hash where the keys are supported currencies and the values are the exchange rate at which the base id currency converts to the key currency.
   */
  rates: {
    [key: string]: number;
  };
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object56 = 'exchange_rate';

export type external_account = bank_account | card;

export type external_account_requirements = {
  /**
   * Fields that need to be collected to keep the external account enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the account is disabled.
   */
  currently_due?: Array<string> | null;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors?: Array<account_requirements_error> | null;
  /**
   * Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the external account.
   */
  past_due?: Array<string> | null;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification?: Array<string> | null;
};

export type fee = {
  /**
   * Amount of the fee, in cents.
   */
  amount: number;
  /**
   * ID of the Connect application that earned the fee.
   */
  application?: string | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Type of the fee, one of: `application_fee`, `payment_method_passthrough_fee`, `stripe_fee` or `tax`.
   */
  type: string;
};

/**
 * `Application Fee Refund` objects allow you to refund an application fee that
 * has previously been created but not yet refunded. Funds will be refunded to
 * the Stripe account from which the fee was originally collected.
 *
 * Related guide: [Refunding application fees](https://stripe.com/docs/connect/destination-charges#refunding-app-fee)
 */
export type fee_refund = {
  /**
   * Amount, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Balance transaction that describes the impact on your account balance.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the application fee that was refunded.
   */
  fee: string | application_fee;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'fee_refund';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object57 = 'fee_refund';

/**
 * This object represents files hosted on Stripe's servers. You can upload
 * files with the [create file](https://stripe.com/docs/api#create_file) request
 * (for example, when uploading dispute evidence). Stripe also
 * creates files independently (for example, the results of a [Sigma scheduled
 * query](#scheduled_queries)).
 *
 * Related guide: [File upload guide](https://stripe.com/docs/file-upload)
 */
export type file = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The file expires and isn't available at this time in epoch seconds.
   */
  expires_at?: number | null;
  /**
   * The suitable name for saving the file to a filesystem.
   */
  filename?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * A list of [file links](https://stripe.com/docs/api#file_links) that point at this file.
   */
  links?: {
    /**
     * Details about each object.
     */
    data: Array<file_link>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'file';
  /**
   * The [purpose](https://stripe.com/docs/file-upload#uploading-a-file) of the uploaded file.
   */
  purpose:
    | 'account_requirement'
    | 'additional_verification'
    | 'business_icon'
    | 'business_logo'
    | 'customer_signature'
    | 'dispute_evidence'
    | 'document_provider_identity_document'
    | 'finance_report_run'
    | 'identity_document'
    | 'identity_document_downloadable'
    | 'pci_document'
    | 'selfie'
    | 'sigma_scheduled_query'
    | 'tax_document_user_upload'
    | 'terminal_reader_splashscreen';
  /**
   * The size of the file object in bytes.
   */
  size: number;
  /**
   * A suitable title for the document.
   */
  title?: string | null;
  /**
   * The returned file type (for example, `csv`, `pdf`, `jpg`, or `png`).
   */
  type?: string | null;
  /**
   * Use your live secret API key to download the file from this URL.
   */
  url?: string | null;
};

/**
 * The [purpose](https://stripe.com/docs/file-upload#uploading-a-file) of the uploaded file.
 */
export type purpose =
  | 'account_requirement'
  | 'additional_verification'
  | 'business_icon'
  | 'business_logo'
  | 'customer_signature'
  | 'dispute_evidence'
  | 'document_provider_identity_document'
  | 'finance_report_run'
  | 'identity_document'
  | 'identity_document_downloadable'
  | 'pci_document'
  | 'selfie'
  | 'sigma_scheduled_query'
  | 'tax_document_user_upload'
  | 'terminal_reader_splashscreen';

/**
 * To share the contents of a `File` object with non-Stripe users, you can
 * create a `FileLink`. `FileLink`s contain a URL that you can use to
 * retrieve the contents of the file without authentication.
 */
export type file_link = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Returns if the link is already expired.
   */
  expired: boolean;
  /**
   * Time that the link expires.
   */
  expires_at?: number | null;
  /**
   * The file object this link points to.
   */
  file: string | file;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'file_link';
  /**
   * The publicly accessible URL to download the file.
   */
  url?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object58 = 'file_link';

/**
 * A Financial Connections Account represents an account that exists outside of Stripe, to which you have been granted some degree of access.
 */
export type financial_connections_account = {
  /**
   * The account holder that this account belongs to.
   */
  account_holder?: bank_connections_resource_accountholder | null;
  /**
   * The most recent information about the account's balance.
   */
  balance?: bank_connections_resource_balance | null;
  /**
   * The state of the most recent attempt to refresh the account balance.
   */
  balance_refresh?: bank_connections_resource_balance_refresh | null;
  /**
   * The type of the account. Account category is further divided in `subcategory`.
   */
  category: 'cash' | 'credit' | 'investment' | 'other';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * A human-readable name that has been assigned to this account, either by the account holder or by the institution.
   */
  display_name?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The name of the institution that holds this account.
   */
  institution_name: string;
  /**
   * The last 4 digits of the account number. If present, this will be 4 numeric characters.
   */
  last4?: string | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'financial_connections.account';
  /**
   * The most recent information about the account's owners.
   */
  ownership?: (string | financial_connections_account_ownership) | null;
  /**
   * The state of the most recent attempt to refresh the account owners.
   */
  ownership_refresh?: bank_connections_resource_ownership_refresh | null;
  /**
   * The list of permissions granted by this account.
   */
  permissions?: Array<'balances' | 'ownership' | 'payment_method' | 'transactions'> | null;
  /**
   * The status of the link to the account.
   */
  status: 'active' | 'disconnected' | 'inactive';
  /**
   * If `category` is `cash`, one of:
   *
   * - `checking`
   * - `savings`
   * - `other`
   *
   * If `category` is `credit`, one of:
   *
   * - `mortgage`
   * - `line_of_credit`
   * - `credit_card`
   * - `other`
   *
   * If `category` is `investment` or `other`, this will be `other`.
   */
  subcategory: 'checking' | 'credit_card' | 'line_of_credit' | 'mortgage' | 'other' | 'savings';
  /**
   * The list of data refresh subscriptions requested on this account.
   */
  subscriptions?: Array<'transactions'> | null;
  /**
   * The [PaymentMethod type](https://stripe.com/docs/api/payment_methods/object#payment_method_object-type)(s) that can be created from this account.
   */
  supported_payment_method_types: Array<'link' | 'us_bank_account'>;
  /**
   * The state of the most recent attempt to refresh the account transactions.
   */
  transaction_refresh?: bank_connections_resource_transaction_refresh | null;
};

/**
 * The type of the account. Account category is further divided in `subcategory`.
 */
export type category = 'cash' | 'credit' | 'investment' | 'other';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object59 = 'financial_connections.account';

/**
 * The status of the link to the account.
 */
export type status10 = 'active' | 'disconnected' | 'inactive';

/**
 * If `category` is `cash`, one of:
 *
 * - `checking`
 * - `savings`
 * - `other`
 *
 * If `category` is `credit`, one of:
 *
 * - `mortgage`
 * - `line_of_credit`
 * - `credit_card`
 * - `other`
 *
 * If `category` is `investment` or `other`, this will be `other`.
 */
export type subcategory = 'checking' | 'credit_card' | 'line_of_credit' | 'mortgage' | 'other' | 'savings';

/**
 * Describes an owner of an account.
 */
export type financial_connections_account_owner = {
  /**
   * The email address of the owner.
   */
  email?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The full name of the owner.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'financial_connections.account_owner';
  /**
   * The ownership object that this owner belongs to.
   */
  ownership: string;
  /**
   * The raw phone number of the owner.
   */
  phone?: string | null;
  /**
   * The raw physical address of the owner.
   */
  raw_address?: string | null;
  /**
   * The timestamp of the refresh that updated this owner.
   */
  refreshed_at?: number | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object60 = 'financial_connections.account_owner';

/**
 * Describes a snapshot of the owners of an account at a particular point in time.
 */
export type financial_connections_account_ownership = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'financial_connections.account_ownership';
  /**
   * A paginated list of owners for this account.
   */
  owners: {
    /**
     * Details about each object.
     */
    data: Array<financial_connections_account_owner>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object61 = 'financial_connections.account_ownership';

/**
 * A Financial Connections Session is the secure way to programmatically launch the client-side Stripe.js modal that lets your users link their accounts.
 */
export type financial_connections_session = {
  /**
   * The account holder for whom accounts are collected in this session.
   */
  account_holder?: bank_connections_resource_accountholder | null;
  /**
   * The accounts that were collected as part of this Session.
   */
  accounts: {
    /**
     * Details about each object.
     */
    data: Array<financial_connections_account>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * A value that will be passed to the client to launch the authentication flow.
   */
  client_secret: string;
  filters?: bank_connections_resource_link_account_session_filters;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'financial_connections.session';
  /**
   * Permissions requested for accounts collected during this session.
   */
  permissions: Array<'balances' | 'ownership' | 'payment_method' | 'transactions'>;
  /**
   * Data features requested to be retrieved upon account creation.
   */
  prefetch?: Array<'balances' | 'ownership' | 'transactions'> | null;
  /**
   * For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.
   */
  return_url?: string;
};

/**
 * A Transaction represents a real transaction that affects a Financial Connections Account balance.
 */
export type financial_connections_transaction = {
  /**
   * The ID of the Financial Connections Account this transaction belongs to.
   */
  account: string;
  /**
   * The amount of this transaction, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The description of this transaction.
   */
  description: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'financial_connections.transaction';
  /**
   * The status of the transaction.
   */
  status: 'pending' | 'posted' | 'void';
  status_transitions: bank_connections_resource_transaction_resource_status_transitions;
  /**
   * Time at which the transaction was transacted. Measured in seconds since the Unix epoch.
   */
  transacted_at: number;
  /**
   * The token of the transaction refresh that last updated or created this transaction.
   */
  transaction_refresh: string;
  /**
   * Time at which the object was last updated. Measured in seconds since the Unix epoch.
   */
  updated: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object62 = 'financial_connections.transaction';

/**
 * The status of the transaction.
 */
export type status11 = 'pending' | 'posted' | 'void';

export type financial_reporting_finance_report_run_run_parameters = {
  /**
   * The set of output columns requested for inclusion in the report run.
   */
  columns?: Array<string>;
  /**
   * Connected account ID by which to filter the report run.
   */
  connected_account?: string;
  /**
   * Currency of objects to be included in the report run.
   */
  currency?: string;
  /**
   * Ending timestamp of data to be included in the report run. Can be any UTC timestamp between 1 second after the user specified `interval_start` and 1 second before this report's last `data_available_end` value.
   */
  interval_end?: number;
  /**
   * Starting timestamp of data to be included in the report run. Can be any UTC timestamp between 1 second after this report's `data_available_start` and 1 second before the user specified `interval_end` value.
   */
  interval_start?: number;
  /**
   * Payout ID by which to filter the report run.
   */
  payout?: string;
  /**
   * Category of balance transactions to be included in the report run.
   */
  reporting_category?: string;
  /**
   * Defaults to `Etc/UTC`. The output timezone for all timestamps in the report. A list of possible time zone values is maintained at the [IANA Time Zone Database](http://www.iana.org/time-zones). Has no effect on `interval_start` or `interval_end`.
   */
  timezone?: string;
};

/**
 * Metadata about the forwarded request.
 */
export type forwarded_request_context = {
  /**
   * The time it took in milliseconds for the destination endpoint to respond.
   */
  destination_duration: number;
  /**
   * The IP address of the destination.
   */
  destination_ip_address: string;
};

/**
 * Details about the request forwarded to the destination endpoint.
 */
export type forwarded_request_details = {
  /**
   * The body payload to send to the destination endpoint.
   */
  body: string;
  /**
   * The headers to include in the forwarded request. Can be omitted if no additional headers (excluding Stripe-generated ones such as the Content-Type header) should be included.
   */
  headers: Array<forwarded_request_header>;
  /**
   * The HTTP method used to call the destination endpoint.
   */
  http_method: 'POST';
};

/**
 * The HTTP method used to call the destination endpoint.
 */
export type http_method = 'POST';

/**
 * Header data.
 */
export type forwarded_request_header = {
  /**
   * The header name.
   */
  name: string;
  /**
   * The header value.
   */
  value: string;
};

/**
 * Details about the response from the destination endpoint.
 */
export type forwarded_response_details = {
  /**
   * The response body from the destination endpoint to Stripe.
   */
  body: string;
  /**
   * HTTP headers that the destination endpoint returned.
   */
  headers: Array<forwarded_request_header>;
  /**
   * The HTTP status code that the destination endpoint returned.
   */
  status: number;
};

/**
 * Instructs Stripe to make a request on your behalf using the destination URL. The destination URL
 * is activated by Stripe at the time of onboarding. Stripe verifies requests with your credentials
 * provided during onboarding, and injects card details from the payment_method into the request.
 *
 * Stripe redacts all sensitive fields and headers, including authentication credentials and card numbers,
 * before storing the request and response data in the forwarding Request object, which are subject to a
 * 30-day retention period.
 *
 * You can provide a Stripe idempotency key to make sure that requests with the same key result in only one
 * outbound request. The Stripe idempotency key provided should be unique and different from any idempotency
 * keys provided on the underlying third-party request.
 *
 * Forwarding Requests are synchronous requests that return a response or time out according to
 * Stripe’s limits.
 *
 * Related guide: [Forward card details to third-party API endpoints](https://docs.stripe.com/payments/forwarding).
 */
export type forwarding_request = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'forwarding.request';
  /**
   * The PaymentMethod to insert into the forwarded request. Forwarding previously consumed PaymentMethods is allowed.
   */
  payment_method: string;
  /**
   * The field kinds to be replaced in the forwarded request.
   */
  replacements: Array<'card_cvc' | 'card_expiry' | 'card_number' | 'cardholder_name'>;
  /**
   * Context about the request from Stripe's servers to the destination endpoint.
   */
  request_context?: forwarded_request_context | null;
  /**
   * The request that was sent to the destination endpoint. We redact any sensitive fields.
   */
  request_details?: forwarded_request_details | null;
  /**
   * The response that the destination endpoint returned to us. We redact any sensitive fields.
   */
  response_details?: forwarded_response_details | null;
  /**
   * The destination URL for the forwarded request. Must be supported by the config.
   */
  url?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object63 = 'forwarding.request';

/**
 * Each customer has a [`balance`](https://stripe.com/docs/api/customers/object#customer_object-balance) that is
 * automatically applied to future invoices and payments using the `customer_balance` payment method.
 * Customers can fund this balance by initiating a bank transfer to any account in the
 * `financial_addresses` field.
 * Related guide: [Customer balance funding instructions](https://stripe.com/docs/payments/customer-balance/funding-instructions)
 */
export type funding_instructions = {
  bank_transfer: funding_instructions_bank_transfer;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The `funding_type` of the returned instructions
   */
  funding_type: 'bank_transfer';
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'funding_instructions';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object64 = 'funding_instructions';

export type funding_instructions_bank_transfer = {
  /**
   * The country of the bank account to fund
   */
  country: string;
  /**
   * A list of financial addresses that can be used to fund a particular balance
   */
  financial_addresses: Array<funding_instructions_bank_transfer_financial_address>;
  /**
   * The bank_transfer type
   */
  type: 'eu_bank_transfer' | 'jp_bank_transfer';
};

/**
 * The bank_transfer type
 */
export type type19 = 'eu_bank_transfer' | 'jp_bank_transfer';

/**
 * ABA Records contain U.S. bank account details per the ABA format.
 */
export type funding_instructions_bank_transfer_aba_record = {
  /**
   * The ABA account number
   */
  account_number: string;
  /**
   * The bank name
   */
  bank_name: string;
  /**
   * The ABA routing number
   */
  routing_number: string;
};

/**
 * FinancialAddresses contain identifying information that resolves to a FinancialAccount.
 */
export type funding_instructions_bank_transfer_financial_address = {
  aba?: funding_instructions_bank_transfer_aba_record;
  iban?: funding_instructions_bank_transfer_iban_record;
  sort_code?: funding_instructions_bank_transfer_sort_code_record;
  spei?: funding_instructions_bank_transfer_spei_record;
  /**
   * The payment networks supported by this FinancialAddress
   */
  supported_networks?: Array<'ach' | 'bacs' | 'domestic_wire_us' | 'fps' | 'sepa' | 'spei' | 'swift' | 'zengin'>;
  swift?: funding_instructions_bank_transfer_swift_record;
  /**
   * The type of financial address
   */
  type: 'aba' | 'iban' | 'sort_code' | 'spei' | 'swift' | 'zengin';
  zengin?: funding_instructions_bank_transfer_zengin_record;
};

/**
 * The type of financial address
 */
export type type20 = 'aba' | 'iban' | 'sort_code' | 'spei' | 'swift' | 'zengin';

/**
 * Iban Records contain E.U. bank account details per the SEPA format.
 */
export type funding_instructions_bank_transfer_iban_record = {
  /**
   * The name of the person or business that owns the bank account
   */
  account_holder_name: string;
  /**
   * The BIC/SWIFT code of the account.
   */
  bic: string;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country: string;
  /**
   * The IBAN of the account.
   */
  iban: string;
};

/**
 * Sort Code Records contain U.K. bank account details per the sort code format.
 */
export type funding_instructions_bank_transfer_sort_code_record = {
  /**
   * The name of the person or business that owns the bank account
   */
  account_holder_name: string;
  /**
   * The account number
   */
  account_number: string;
  /**
   * The six-digit sort code
   */
  sort_code: string;
};

/**
 * SPEI Records contain Mexico bank account details per the SPEI format.
 */
export type funding_instructions_bank_transfer_spei_record = {
  /**
   * The three-digit bank code
   */
  bank_code: string;
  /**
   * The short banking institution name
   */
  bank_name: string;
  /**
   * The CLABE number
   */
  clabe: string;
};

/**
 * SWIFT Records contain U.S. bank account details per the SWIFT format.
 */
export type funding_instructions_bank_transfer_swift_record = {
  /**
   * The account number
   */
  account_number: string;
  /**
   * The bank name
   */
  bank_name: string;
  /**
   * The SWIFT code
   */
  swift_code: string;
};

/**
 * Zengin Records contain Japan bank account details per the Zengin format.
 */
export type funding_instructions_bank_transfer_zengin_record = {
  /**
   * The account holder name
   */
  account_holder_name?: string | null;
  /**
   * The account number
   */
  account_number?: string | null;
  /**
   * The bank account type. In Japan, this can only be `futsu` or `toza`.
   */
  account_type?: string | null;
  /**
   * The bank code of the account
   */
  bank_code?: string | null;
  /**
   * The bank name of the account
   */
  bank_name?: string | null;
  /**
   * The branch code of the account
   */
  branch_code?: string | null;
  /**
   * The branch name of the account
   */
  branch_name?: string | null;
};

/**
 * Point in Time
 */
export type gelato_data_document_report_date_of_birth = {
  /**
   * Numerical day between 1 and 31.
   */
  day?: number | null;
  /**
   * Numerical month between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year.
   */
  year?: number | null;
};

/**
 * Point in Time
 */
export type gelato_data_document_report_expiration_date = {
  /**
   * Numerical day between 1 and 31.
   */
  day?: number | null;
  /**
   * Numerical month between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year.
   */
  year?: number | null;
};

/**
 * Point in Time
 */
export type gelato_data_document_report_issued_date = {
  /**
   * Numerical day between 1 and 31.
   */
  day?: number | null;
  /**
   * Numerical month between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year.
   */
  year?: number | null;
};

/**
 * Point in Time
 */
export type gelato_data_id_number_report_date = {
  /**
   * Numerical day between 1 and 31.
   */
  day?: number | null;
  /**
   * Numerical month between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year.
   */
  year?: number | null;
};

/**
 * Point in Time
 */
export type gelato_data_verified_outputs_date = {
  /**
   * Numerical day between 1 and 31.
   */
  day?: number | null;
  /**
   * Numerical month between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year.
   */
  year?: number | null;
};

/**
 * Result from a document check
 */
export type gelato_document_report = {
  /**
   * Address as it appears in the document.
   */
  address?: address | null;
  /**
   * Date of birth as it appears in the document.
   */
  dob?: gelato_data_document_report_date_of_birth | null;
  /**
   * Details on the verification error. Present when status is `unverified`.
   */
  error?: gelato_document_report_error | null;
  /**
   * Expiration date of the document.
   */
  expiration_date?: gelato_data_document_report_expiration_date | null;
  /**
   * Array of [File](https://stripe.com/docs/api/files) ids containing images for this document.
   */
  files?: Array<string> | null;
  /**
   * First name as it appears in the document.
   */
  first_name?: string | null;
  /**
   * Issued date of the document.
   */
  issued_date?: gelato_data_document_report_issued_date | null;
  /**
   * Issuing country of the document.
   */
  issuing_country?: string | null;
  /**
   * Last name as it appears in the document.
   */
  last_name?: string | null;
  /**
   * Document ID number.
   */
  number?: string | null;
  /**
   * Status of this `document` check.
   */
  status: 'unverified' | 'verified';
  /**
   * Type of the document.
   */
  type?: ('driving_license' | 'id_card' | 'passport') | null;
};

/**
 * Status of this `document` check.
 */
export type status12 = 'unverified' | 'verified';

/**
 * Type of the document.
 */
export type type21 = 'driving_license' | 'id_card' | 'passport';

export type gelato_document_report_error = {
  /**
   * A short machine-readable string giving the reason for the verification failure.
   */
  code?: ('document_expired' | 'document_type_not_supported' | 'document_unverified_other') | null;
  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to your users.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification failure.
 */
export type code2 = 'document_expired' | 'document_type_not_supported' | 'document_unverified_other';

/**
 * Result from a email check
 */
export type gelato_email_report = {
  /**
   * Email to be verified.
   */
  email?: string | null;
  /**
   * Details on the verification error. Present when status is `unverified`.
   */
  error?: gelato_email_report_error | null;
  /**
   * Status of this `email` check.
   */
  status: 'unverified' | 'verified';
};

export type gelato_email_report_error = {
  /**
   * A short machine-readable string giving the reason for the verification failure.
   */
  code?: ('email_unverified_other' | 'email_verification_declined') | null;
  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to your users.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification failure.
 */
export type code3 = 'email_unverified_other' | 'email_verification_declined';

/**
 * Result from an id_number check
 */
export type gelato_id_number_report = {
  /**
   * Date of birth.
   */
  dob?: gelato_data_id_number_report_date | null;
  /**
   * Details on the verification error. Present when status is `unverified`.
   */
  error?: gelato_id_number_report_error | null;
  /**
   * First name.
   */
  first_name?: string | null;
  /**
   * ID number. When `id_number_type` is `us_ssn`, only the last 4 digits are present.
   */
  id_number?: string | null;
  /**
   * Type of ID number.
   */
  id_number_type?: ('br_cpf' | 'sg_nric' | 'us_ssn') | null;
  /**
   * Last name.
   */
  last_name?: string | null;
  /**
   * Status of this `id_number` check.
   */
  status: 'unverified' | 'verified';
};

/**
 * Type of ID number.
 */
export type id_number_type = 'br_cpf' | 'sg_nric' | 'us_ssn';

export type gelato_id_number_report_error = {
  /**
   * A short machine-readable string giving the reason for the verification failure.
   */
  code?: ('id_number_insufficient_document_data' | 'id_number_mismatch' | 'id_number_unverified_other') | null;
  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to your users.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification failure.
 */
export type code4 = 'id_number_insufficient_document_data' | 'id_number_mismatch' | 'id_number_unverified_other';

/**
 * Result from a phone check
 */
export type gelato_phone_report = {
  /**
   * Details on the verification error. Present when status is `unverified`.
   */
  error?: gelato_phone_report_error | null;
  /**
   * Phone to be verified.
   */
  phone?: string | null;
  /**
   * Status of this `phone` check.
   */
  status: 'unverified' | 'verified';
};

export type gelato_phone_report_error = {
  /**
   * A short machine-readable string giving the reason for the verification failure.
   */
  code?: ('phone_unverified_other' | 'phone_verification_declined') | null;
  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to your users.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification failure.
 */
export type code5 = 'phone_unverified_other' | 'phone_verification_declined';

export type gelato_provided_details = {
  /**
   * Email of user being verified
   */
  email?: string;
  /**
   * Phone number of user being verified
   */
  phone?: string;
};

export type gelato_report_document_options = {
  /**
   * Array of strings of allowed identity document types. If the provided identity document isn’t one of the allowed types, the verification check will fail with a document_type_not_allowed error code.
   */
  allowed_types?: Array<'driving_license' | 'id_card' | 'passport'>;
  /**
   * Collect an ID number and perform an [ID number check](https://stripe.com/docs/identity/verification-checks?type=id-number) with the document’s extracted name and date of birth.
   */
  require_id_number?: boolean;
  /**
   * Disable image uploads, identity document images have to be captured using the device’s camera.
   */
  require_live_capture?: boolean;
  /**
   * Capture a face image and perform a [selfie check](https://stripe.com/docs/identity/verification-checks?type=selfie) comparing a photo ID and a picture of your user’s face. [Learn more](https://stripe.com/docs/identity/selfie).
   */
  require_matching_selfie?: boolean;
};

export type gelato_report_id_number_options = {
  [key: string]: unknown;
};

/**
 * Result from a selfie check
 */
export type gelato_selfie_report = {
  /**
   * ID of the [File](https://stripe.com/docs/api/files) holding the image of the identity document used in this check.
   */
  document?: string | null;
  /**
   * Details on the verification error. Present when status is `unverified`.
   */
  error?: gelato_selfie_report_error | null;
  /**
   * ID of the [File](https://stripe.com/docs/api/files) holding the image of the selfie used in this check.
   */
  selfie?: string | null;
  /**
   * Status of this `selfie` check.
   */
  status: 'unverified' | 'verified';
};

export type gelato_selfie_report_error = {
  /**
   * A short machine-readable string giving the reason for the verification failure.
   */
  code?:
    | ('selfie_document_missing_photo' | 'selfie_face_mismatch' | 'selfie_manipulated' | 'selfie_unverified_other')
    | null;
  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to your users.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification failure.
 */
export type code6 =
  | 'selfie_document_missing_photo'
  | 'selfie_face_mismatch'
  | 'selfie_manipulated'
  | 'selfie_unverified_other';

export type gelato_session_document_options = {
  /**
   * Array of strings of allowed identity document types. If the provided identity document isn’t one of the allowed types, the verification check will fail with a document_type_not_allowed error code.
   */
  allowed_types?: Array<'driving_license' | 'id_card' | 'passport'>;
  /**
   * Collect an ID number and perform an [ID number check](https://stripe.com/docs/identity/verification-checks?type=id-number) with the document’s extracted name and date of birth.
   */
  require_id_number?: boolean;
  /**
   * Disable image uploads, identity document images have to be captured using the device’s camera.
   */
  require_live_capture?: boolean;
  /**
   * Capture a face image and perform a [selfie check](https://stripe.com/docs/identity/verification-checks?type=selfie) comparing a photo ID and a picture of your user’s face. [Learn more](https://stripe.com/docs/identity/selfie).
   */
  require_matching_selfie?: boolean;
};

export type gelato_session_email_options = {
  /**
   * Request one time password verification of `provided_details.email`.
   */
  require_verification?: boolean;
};

export type gelato_session_id_number_options = {
  [key: string]: unknown;
};

/**
 * Shows last VerificationSession error
 */
export type gelato_session_last_error = {
  /**
   * A short machine-readable string giving the reason for the verification or user-session failure.
   */
  code?:
    | (
        | 'abandoned'
        | 'consent_declined'
        | 'country_not_supported'
        | 'device_not_supported'
        | 'document_expired'
        | 'document_type_not_supported'
        | 'document_unverified_other'
        | 'email_unverified_other'
        | 'email_verification_declined'
        | 'id_number_insufficient_document_data'
        | 'id_number_mismatch'
        | 'id_number_unverified_other'
        | 'phone_unverified_other'
        | 'phone_verification_declined'
        | 'selfie_document_missing_photo'
        | 'selfie_face_mismatch'
        | 'selfie_manipulated'
        | 'selfie_unverified_other'
        | 'under_supported_age'
      )
    | null;
  /**
   * A message that explains the reason for verification or user-session failure.
   */
  reason?: string | null;
};

/**
 * A short machine-readable string giving the reason for the verification or user-session failure.
 */
export type code7 =
  | 'abandoned'
  | 'consent_declined'
  | 'country_not_supported'
  | 'device_not_supported'
  | 'document_expired'
  | 'document_type_not_supported'
  | 'document_unverified_other'
  | 'email_unverified_other'
  | 'email_verification_declined'
  | 'id_number_insufficient_document_data'
  | 'id_number_mismatch'
  | 'id_number_unverified_other'
  | 'phone_unverified_other'
  | 'phone_verification_declined'
  | 'selfie_document_missing_photo'
  | 'selfie_face_mismatch'
  | 'selfie_manipulated'
  | 'selfie_unverified_other'
  | 'under_supported_age';

export type gelato_session_phone_options = {
  /**
   * Request one time password verification of `provided_details.phone`.
   */
  require_verification?: boolean;
};

export type gelato_verification_report_options = {
  document?: gelato_report_document_options;
  id_number?: gelato_report_id_number_options;
};

export type gelato_verification_session_options = {
  document?: gelato_session_document_options;
  email?: gelato_session_email_options;
  id_number?: gelato_session_id_number_options;
  phone?: gelato_session_phone_options;
};

export type gelato_verified_outputs = {
  /**
   * The user's verified address.
   */
  address?: address | null;
  /**
   * The user’s verified date of birth.
   */
  dob?: gelato_data_verified_outputs_date | null;
  /**
   * The user's verified email address
   */
  email?: string | null;
  /**
   * The user's verified first name.
   */
  first_name?: string | null;
  /**
   * The user's verified id number.
   */
  id_number?: string | null;
  /**
   * The user's verified id number type.
   */
  id_number_type?: ('br_cpf' | 'sg_nric' | 'us_ssn') | null;
  /**
   * The user's verified last name.
   */
  last_name?: string | null;
  /**
   * The user's verified phone number
   */
  phone?: string | null;
};

/**
 * A VerificationReport is the result of an attempt to collect and verify data from a user.
 * The collection of verification checks performed is determined from the `type` and `options`
 * parameters used. You can find the result of each verification check performed in the
 * appropriate sub-resource: `document`, `id_number`, `selfie`.
 *
 * Each VerificationReport contains a copy of any data collected by the user as well as
 * reference IDs which can be used to access collected images through the [FileUpload](https://stripe.com/docs/api/files)
 * API. To configure and create VerificationReports, use the
 * [VerificationSession](https://stripe.com/docs/api/identity/verification_sessions) API.
 *
 * Related guides: [Accessing verification results](https://stripe.com/docs/identity/verification-sessions#results).
 */
export type identity_verification_report = {
  /**
   * A string to reference this user. This can be a customer ID, a session ID, or similar, and can be used to reconcile this verification with your internal systems.
   */
  client_reference_id?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  document?: gelato_document_report;
  email?: gelato_email_report;
  /**
   * Unique identifier for the object.
   */
  id: string;
  id_number?: gelato_id_number_report;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'identity.verification_report';
  options?: gelato_verification_report_options;
  phone?: gelato_phone_report;
  selfie?: gelato_selfie_report;
  /**
   * Type of report.
   */
  type: 'document' | 'id_number' | 'verification_flow';
  /**
   * The configuration token of a Verification Flow from the dashboard.
   */
  verification_flow?: string;
  /**
   * ID of the VerificationSession that created this report.
   */
  verification_session?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object65 = 'identity.verification_report';

/**
 * Type of report.
 */
export type type22 = 'document' | 'id_number' | 'verification_flow';

/**
 * A VerificationSession guides you through the process of collecting and verifying the identities
 * of your users. It contains details about the type of verification, such as what [verification
 * check](/docs/identity/verification-checks) to perform. Only create one VerificationSession for
 * each verification in your system.
 *
 * A VerificationSession transitions through [multiple
 * statuses](/docs/identity/how-sessions-work) throughout its lifetime as it progresses through
 * the verification flow. The VerificationSession contains the user's verified data after
 * verification checks are complete.
 *
 * Related guide: [The Verification Sessions API](https://stripe.com/docs/identity/verification-sessions)
 */
export type identity_verification_session = {
  /**
   * A string to reference this user. This can be a customer ID, a session ID, or similar, and can be used to reconcile this verification with your internal systems.
   */
  client_reference_id?: string | null;
  /**
   * The short-lived client secret used by Stripe.js to [show a verification modal](https://stripe.com/docs/js/identity/modal) inside your app. This client secret expires after 24 hours and can only be used once. Don’t store it, log it, embed it in a URL, or expose it to anyone other than the user. Make sure that you have TLS enabled on any page that includes the client secret. Refer to our docs on [passing the client secret to the frontend](https://stripe.com/docs/identity/verification-sessions#client-secret) to learn more.
   */
  client_secret?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * If present, this property tells you the last error encountered when processing the verification.
   */
  last_error?: gelato_session_last_error | null;
  /**
   * ID of the most recent VerificationReport. [Learn more about accessing detailed verification results.](https://stripe.com/docs/identity/verification-sessions#results)
   */
  last_verification_report?: (string | identity_verification_report) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'identity.verification_session';
  /**
   * A set of options for the session’s verification checks.
   */
  options?: gelato_verification_session_options | null;
  /**
   * Details provided about the user being verified. These details may be shown to the user.
   */
  provided_details?: gelato_provided_details | null;
  /**
   * Redaction status of this VerificationSession. If the VerificationSession is not redacted, this field will be null.
   */
  redaction?: verification_session_redaction | null;
  /**
   * Status of this VerificationSession. [Learn more about the lifecycle of sessions](https://stripe.com/docs/identity/how-sessions-work).
   */
  status: 'canceled' | 'processing' | 'requires_input' | 'verified';
  /**
   * The type of [verification check](https://stripe.com/docs/identity/verification-checks) to be performed.
   */
  type: 'document' | 'id_number' | 'verification_flow';
  /**
   * The short-lived URL that you use to redirect a user to Stripe to submit their identity information. This URL expires after 48 hours and can only be used once. Don’t store it, log it, send it in emails or expose it to anyone other than the user. Refer to our docs on [verifying identity documents](https://stripe.com/docs/identity/verify-identity-documents?platform=web&type=redirect) to learn how to redirect users to Stripe.
   */
  url?: string | null;
  /**
   * The configuration token of a Verification Flow from the dashboard.
   */
  verification_flow?: string;
  /**
   * The user’s verified data.
   */
  verified_outputs?: gelato_verified_outputs | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object66 = 'identity.verification_session';

/**
 * Status of this VerificationSession. [Learn more about the lifecycle of sessions](https://stripe.com/docs/identity/how-sessions-work).
 */
export type status13 = 'canceled' | 'processing' | 'requires_input' | 'verified';

export type inbound_transfers = {
  billing_details: treasury_shared_resource_billing_details;
  /**
   * The type of the payment method used in the InboundTransfer.
   */
  type: 'us_bank_account';
  us_bank_account?: inbound_transfers_payment_method_details_us_bank_account;
};

/**
 * The type of the payment method used in the InboundTransfer.
 */
export type type23 = 'us_bank_account';

export type inbound_transfers_payment_method_details_us_bank_account = {
  /**
   * Account holder type: individual or company.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Account type: checkings or savings. Defaults to checking if omitted.
   */
  account_type?: ('checking' | 'savings') | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string | mandate;
  /**
   * The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.
   */
  network: 'ach';
  /**
   * Routing number of the bank account.
   */
  routing_number?: string | null;
};

/**
 * Account holder type: individual or company.
 */
export type account_holder_type = 'company' | 'individual';

/**
 * Account type: checkings or savings. Defaults to checking if omitted.
 */
export type account_type = 'checking' | 'savings';

/**
 * The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.
 */
export type network2 = 'ach';

export type internal_card = {
  /**
   * Brand of the card used in the transaction
   */
  brand?: string | null;
  /**
   * Two-letter ISO code representing the country of the card
   */
  country?: string | null;
  /**
   * Two digit number representing the card's expiration month
   */
  exp_month?: number | null;
  /**
   * Two digit number representing the card's expiration year
   */
  exp_year?: number | null;
  /**
   * The last 4 digits of the card
   */
  last4?: string | null;
};

/**
 * Invoices are statements of amounts owed by a customer, and are either
 * generated one-off, or generated periodically from a subscription.
 *
 * They contain [invoice items](https://stripe.com/docs/api#invoiceitems), and proration adjustments
 * that may be caused by subscription upgrades/downgrades (if necessary).
 *
 * If your invoice is configured to be billed through automatic charges,
 * Stripe automatically finalizes your invoice and attempts payment. Note
 * that finalizing the invoice,
 * [when automatic](https://stripe.com/docs/invoicing/integration/automatic-advancement-collection), does
 * not happen immediately as the invoice is created. Stripe waits
 * until one hour after the last webhook was successfully sent (or the last
 * webhook timed out after failing). If you (and the platforms you may have
 * connected to) have no webhooks configured, Stripe waits one hour after
 * creation to finalize the invoice.
 *
 * If your invoice is configured to be billed by sending an email, then based on your
 * [email settings](https://dashboard.stripe.com/account/billing/automatic),
 * Stripe will email the invoice to your customer and await payment. These
 * emails can contain a link to a hosted page to pay the invoice.
 *
 * Stripe applies any customer credit on the account before determining the
 * amount due for the invoice (i.e., the amount that will be actually
 * charged). If the amount due for the invoice is less than Stripe's [minimum allowed charge
 * per currency](/docs/currencies#minimum-and-maximum-charge-amounts), the
 * invoice is automatically marked paid, and we add the amount due to the
 * customer's credit balance which is applied to the next invoice.
 *
 * More details on the customer's credit balance are
 * [here](https://stripe.com/docs/billing/customer/balance).
 *
 * Related guide: [Send invoices to customers](https://stripe.com/docs/billing/invoices/sending)
 */
export type invoice = {
  /**
   * The country of the business associated with this invoice, most often the business creating the invoice.
   */
  account_country?: string | null;
  /**
   * The public name of the business associated with this invoice, most often the business creating the invoice.
   */
  account_name?: string | null;
  /**
   * The account tax IDs associated with the invoice. Only editable when the invoice is a draft.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  /**
   * Final amount due at this time for this invoice. If the invoice's total is smaller than the minimum charge amount, for example, or if there is account credit that can be applied to the invoice, the `amount_due` may be 0. If there is a positive `starting_balance` for the invoice (the customer owes money), the `amount_due` will also take that into account. The charge that gets generated for the invoice will be for the amount specified in `amount_due`.
   */
  amount_due: number;
  /**
   * The amount, in cents (or local equivalent), that was paid.
   */
  amount_paid: number;
  /**
   * The difference between amount_due and amount_paid, in cents (or local equivalent).
   */
  amount_remaining: number;
  /**
   * This is the sum of all the shipping amounts.
   */
  amount_shipping: number;
  /**
   * ID of the Connect Application that created the invoice.
   */
  application?: (string | application | deleted_application) | null;
  /**
   * The fee in cents (or local equivalent) that will be applied to the invoice and transferred to the application owner's Stripe account when the invoice is paid.
   */
  application_fee_amount?: number | null;
  /**
   * Number of payment attempts made for this invoice, from the perspective of the payment retry schedule. Any payment attempt counts as the first attempt, and subsequently only automatic retries increment the attempt count. In other words, manual payment attempts after the first attempt do not affect the retry schedule. If a failure is returned with a non-retryable return code, the invoice can no longer be retried unless a new payment method is obtained. Retries will continue to be scheduled, and attempt_count will continue to increment, but retries will only be executed if a new payment method is obtained.
   */
  attempt_count: number;
  /**
   * Whether an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour after the `invoice.created` webhook, for example, so you might not want to display that invoice as unpaid to your users.
   */
  attempted: boolean;
  /**
   * Controls whether Stripe performs [automatic collection](https://stripe.com/docs/invoicing/integration/automatic-advancement-collection) of the invoice. If `false`, the invoice's state doesn't automatically advance without an explicit action.
   */
  auto_advance?: boolean;
  automatic_tax: automatic_tax;
  /**
   * Indicates the reason why the invoice was created.
   *
   * * `manual`: Unrelated to a subscription, for example, created via the invoice editor.
   * * `subscription`: No longer in use. Applies to subscriptions from before May 2018 where no distinction was made between updates, cycles, and thresholds.
   * * `subscription_create`: A new subscription was created.
   * * `subscription_cycle`: A subscription advanced into a new period.
   * * `subscription_threshold`: A subscription reached a billing threshold.
   * * `subscription_update`: A subscription was updated.
   * * `upcoming`: Reserved for simulated invoices, per the upcoming invoice endpoint.
   */
  billing_reason?:
    | (
        | 'automatic_pending_invoice_item_invoice'
        | 'manual'
        | 'quote_accept'
        | 'subscription'
        | 'subscription_create'
        | 'subscription_cycle'
        | 'subscription_threshold'
        | 'subscription_update'
        | 'upcoming'
      )
    | null;
  /**
   * ID of the latest charge generated for this invoice, if any.
   */
  charge?: (string | charge) | null;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this invoice using the default source attached to the customer. When sending an invoice, Stripe will email this invoice to the customer with payment instructions.
   */
  collection_method: 'charge_automatically' | 'send_invoice';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Custom fields displayed on the invoice.
   */
  custom_fields?: Array<invoice_setting_custom_field> | null;
  /**
   * The ID of the customer who will be billed.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * The customer's address. Until the invoice is finalized, this field will equal `customer.address`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_address?: address | null;
  /**
   * The customer's email. Until the invoice is finalized, this field will equal `customer.email`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_email?: string | null;
  /**
   * The customer's name. Until the invoice is finalized, this field will equal `customer.name`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_name?: string | null;
  /**
   * The customer's phone number. Until the invoice is finalized, this field will equal `customer.phone`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_phone?: string | null;
  /**
   * The customer's shipping information. Until the invoice is finalized, this field will equal `customer.shipping`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_shipping?: shipping | null;
  /**
   * The customer's tax exempt status. Until the invoice is finalized, this field will equal `customer.tax_exempt`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_tax_exempt?: ('exempt' | 'none' | 'reverse') | null;
  /**
   * The customer's tax IDs. Until the invoice is finalized, this field will contain the same tax IDs as `customer.tax_ids`. Once the invoice is finalized, this field will no longer be updated.
   */
  customer_tax_ids?: Array<invoices_resource_invoice_tax_id> | null;
  /**
   * ID of the default payment method for the invoice. It must belong to the customer associated with the invoice. If not set, defaults to the subscription's default payment method, if any, or to the default payment method in the customer's invoice settings.
   */
  default_payment_method?: (string | payment_method) | null;
  /**
   * ID of the default payment source for the invoice. It must belong to the customer associated with the invoice and be in a chargeable state. If not set, defaults to the subscription's default source, if any, or to the customer's default source.
   */
  default_source?: (string | bank_account | card | source) | null;
  /**
   * The tax rates applied to this invoice, if any.
   */
  default_tax_rates: Array<tax_rate>;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users. Referenced as 'memo' in the Dashboard.
   */
  description?: string | null;
  /**
   * Describes the current discount applied to this invoice, if there is one. Not populated if there are multiple discounts.
   */
  discount?: discount | null;
  /**
   * The discounts applied to the invoice. Line item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts: Array<string | discount | deleted_discount>;
  /**
   * The date on which payment for this invoice is due. This value will be `null` for invoices where `collection_method=charge_automatically`.
   */
  due_date?: number | null;
  /**
   * The date when this invoice is in effect. Same as `finalized_at` unless overwritten. When defined, this value replaces the system-generated 'Date of issue' printed on the invoice PDF and receipt.
   */
  effective_at?: number | null;
  /**
   * Ending customer balance after the invoice is finalized. Invoices are finalized approximately an hour after successful webhook delivery or when payment collection is attempted for the invoice. If the invoice has not been finalized yet, this will be null.
   */
  ending_balance?: number | null;
  /**
   * Footer displayed on the invoice.
   */
  footer?: string | null;
  /**
   * Details of the invoice that was cloned. See the [revision documentation](https://stripe.com/docs/invoicing/invoice-revisions) for more details.
   */
  from_invoice?: invoices_resource_from_invoice | null;
  /**
   * The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the invoice has not been finalized yet, this will be null.
   */
  hosted_invoice_url?: string | null;
  /**
   * Unique identifier for the object. This property is always present unless the invoice is an upcoming invoice. See [Retrieve an upcoming invoice](https://stripe.com/docs/api/invoices/upcoming) for more details.
   */
  id?: string;
  /**
   * The link to download the PDF for the invoice. If the invoice has not been finalized yet, this will be null.
   */
  invoice_pdf?: string | null;
  issuer: connect_account_reference;
  /**
   * The error encountered during the previous attempt to finalize the invoice. This field is cleared when the invoice is successfully finalized.
   */
  last_finalization_error?: api_errors | null;
  /**
   * The ID of the most recent non-draft revision of this invoice
   */
  latest_revision?: (string | invoice) | null;
  /**
   * The individual line items that make up the invoice. `lines` is sorted as follows: (1) pending invoice items (including prorations) in reverse chronological order, (2) subscription items in reverse chronological order, and (3) invoice items added after invoice creation in chronological order.
   */
  lines: {
    /**
     * Details about each object.
     */
    data: Array<line_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * The time at which payment will next be attempted. This value will be `null` for invoices where `collection_method=send_invoice`.
   */
  next_payment_attempt?: number | null;
  /**
   * A unique, identifying string that appears on emails sent to the customer for this invoice. This starts with the customer's unique invoice_prefix if it is specified.
   */
  number?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'invoice';
  /**
   * The account (if any) for which the funds of the invoice payment are intended. If set, the invoice will be presented with the branding and support information of the specified account. See the [Invoices with Connect](https://stripe.com/docs/billing/invoices/connect) documentation for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * Whether payment was successfully collected for this invoice. An invoice can be paid (most commonly) with a charge or with credit from the customer's account balance.
   */
  paid: boolean;
  /**
   * Returns true if the invoice was manually marked paid, returns false if the invoice hasn't been paid yet or was paid on Stripe.
   */
  paid_out_of_band: boolean;
  /**
   * The PaymentIntent associated with this invoice. The PaymentIntent is generated when the invoice is finalized, and can then be used to pay the invoice. Note that voiding an invoice will cancel the PaymentIntent.
   */
  payment_intent?: (string | payment_intent) | null;
  payment_settings: invoices_payment_settings;
  /**
   * End of the usage period during which invoice items were added to this invoice. This looks back one period for a subscription invoice. Use the [line item period](/api/invoices/line_item#invoice_line_item_object-period) to get the service period for each price.
   */
  period_end: number;
  /**
   * Start of the usage period during which invoice items were added to this invoice. This looks back one period for a subscription invoice. Use the [line item period](/api/invoices/line_item#invoice_line_item_object-period) to get the service period for each price.
   */
  period_start: number;
  /**
   * Total amount of all post-payment credit notes issued for this invoice.
   */
  post_payment_credit_notes_amount: number;
  /**
   * Total amount of all pre-payment credit notes issued for this invoice.
   */
  pre_payment_credit_notes_amount: number;
  /**
   * The quote this invoice was generated from.
   */
  quote?: (string | quote) | null;
  /**
   * This is the transaction number that appears on email receipts sent for this invoice.
   */
  receipt_number?: string | null;
  /**
   * The rendering-related settings that control how the invoice is displayed on customer-facing surfaces such as PDF and Hosted Invoice Page.
   */
  rendering?: invoices_resource_invoice_rendering | null;
  /**
   * The details of the cost of shipping, including the ShippingRate applied on the invoice.
   */
  shipping_cost?: invoices_resource_shipping_cost | null;
  /**
   * Shipping details for the invoice. The Invoice PDF will use the `shipping_details` value if it is set, otherwise the PDF will render the shipping address from the customer.
   */
  shipping_details?: shipping | null;
  /**
   * Starting customer balance before the invoice is finalized. If the invoice has not been finalized yet, this will be the current customer balance. For revision invoices, this also includes any customer balance that was applied to the original invoice.
   */
  starting_balance: number;
  /**
   * Extra information about an invoice for the customer's credit card statement.
   */
  statement_descriptor?: string | null;
  /**
   * The status of the invoice, one of `draft`, `open`, `paid`, `uncollectible`, or `void`. [Learn more](https://stripe.com/docs/billing/invoices/workflow#workflow-overview)
   */
  status?: ('draft' | 'open' | 'paid' | 'uncollectible' | 'void') | null;
  status_transitions: invoices_resource_status_transitions;
  /**
   * The subscription that this invoice was prepared for, if any.
   */
  subscription?: (string | subscription) | null;
  /**
   * Details about the subscription that created this invoice.
   */
  subscription_details?: subscription_details_data | null;
  /**
   * Only set for upcoming invoices that preview prorations. The time used to calculate prorations.
   */
  subscription_proration_date?: number;
  /**
   * Total of all subscriptions, invoice items, and prorations on the invoice before any invoice level discount or exclusive tax is applied. Item discounts are already incorporated
   */
  subtotal: number;
  /**
   * The integer amount in cents (or local equivalent) representing the subtotal of the invoice before any invoice level discount or tax is applied. Item discounts are already incorporated
   */
  subtotal_excluding_tax?: number | null;
  /**
   * The amount of tax on this invoice. This is the sum of all the tax amounts on this invoice.
   */
  tax?: number | null;
  /**
   * ID of the test clock this invoice belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
  threshold_reason?: invoice_threshold_reason;
  /**
   * Total after discounts and taxes.
   */
  total: number;
  /**
   * The aggregate amounts calculated per discount across all line items.
   */
  total_discount_amounts?: Array<discounts_resource_discount_amount> | null;
  /**
   * The integer amount in cents (or local equivalent) representing the total amount of the invoice including all discounts but excluding all tax.
   */
  total_excluding_tax?: number | null;
  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  total_tax_amounts: Array<invoice_tax_amount>;
  /**
   * The account (if any) the payment will be attributed to for tax reporting, and where funds from the payment will be transferred to for the invoice.
   */
  transfer_data?: invoice_transfer_data | null;
  /**
   * Invoices are automatically paid or sent 1 hour after webhooks are delivered, or until all webhook delivery attempts have [been exhausted](https://stripe.com/docs/billing/webhooks#understand). This field tracks the time when webhooks for this invoice were successfully delivered. If the invoice had no webhooks to deliver, this will be set while the invoice is being created.
   */
  webhooks_delivered_at?: number | null;
};

/**
 * Indicates the reason why the invoice was created.
 *
 * * `manual`: Unrelated to a subscription, for example, created via the invoice editor.
 * * `subscription`: No longer in use. Applies to subscriptions from before May 2018 where no distinction was made between updates, cycles, and thresholds.
 * * `subscription_create`: A new subscription was created.
 * * `subscription_cycle`: A subscription advanced into a new period.
 * * `subscription_threshold`: A subscription reached a billing threshold.
 * * `subscription_update`: A subscription was updated.
 * * `upcoming`: Reserved for simulated invoices, per the upcoming invoice endpoint.
 */
export type billing_reason =
  | 'automatic_pending_invoice_item_invoice'
  | 'manual'
  | 'quote_accept'
  | 'subscription'
  | 'subscription_create'
  | 'subscription_cycle'
  | 'subscription_threshold'
  | 'subscription_update'
  | 'upcoming';

/**
 * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this invoice using the default source attached to the customer. When sending an invoice, Stripe will email this invoice to the customer with payment instructions.
 */
export type collection_method = 'charge_automatically' | 'send_invoice';

/**
 * The customer's tax exempt status. Until the invoice is finalized, this field will equal `customer.tax_exempt`. Once the invoice is finalized, this field will no longer be updated.
 */
export type customer_tax_exempt = 'exempt' | 'none' | 'reverse';

/**
 * The status of the invoice, one of `draft`, `open`, `paid`, `uncollectible`, or `void`. [Learn more](https://stripe.com/docs/billing/invoices/workflow#workflow-overview)
 */
export type status14 = 'draft' | 'open' | 'paid' | 'uncollectible' | 'void';

export type invoice_installments_card = {
  /**
   * Whether Installments are enabled for this Invoice.
   */
  enabled?: boolean | null;
};

export type invoice_item_threshold_reason = {
  /**
   * The IDs of the line items that triggered the threshold invoice.
   */
  line_item_ids: Array<string>;
  /**
   * The quantity threshold boundary that applied to the given line item.
   */
  usage_gte: number;
};

export type invoice_line_item_period = {
  /**
   * The end of the period, which must be greater than or equal to the start. This value is inclusive.
   */
  end: number;
  /**
   * The start of the period. This value is inclusive.
   */
  start: number;
};

export type invoice_mandate_options_card = {
  /**
   * Amount to be charged for future payments.
   */
  amount?: number | null;
  /**
   * One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
   */
  amount_type?: ('fixed' | 'maximum') | null;
  /**
   * A description of the mandate or subscription that is meant to be displayed to the customer.
   */
  description?: string | null;
};

/**
 * One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
 */
export type amount_type = 'fixed' | 'maximum';

export type invoice_payment_method_options_acss_debit = {
  mandate_options?: invoice_payment_method_options_acss_debit_mandate_options;
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type invoice_payment_method_options_acss_debit_mandate_options = {
  /**
   * Transaction type of the mandate.
   */
  transaction_type?: ('business' | 'personal') | null;
};

export type invoice_payment_method_options_bancontact = {
  /**
   * Preferred language of the Bancontact authorization page that the customer is redirected to.
   */
  preferred_language: 'de' | 'en' | 'fr' | 'nl';
};

/**
 * Preferred language of the Bancontact authorization page that the customer is redirected to.
 */
export type preferred_language = 'de' | 'en' | 'fr' | 'nl';

export type invoice_payment_method_options_card = {
  installments?: invoice_installments_card;
  /**
   * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
   */
  request_three_d_secure?: ('any' | 'automatic' | 'challenge') | null;
};

export type invoice_payment_method_options_customer_balance = {
  bank_transfer?: invoice_payment_method_options_customer_balance_bank_transfer;
  /**
   * The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
   */
  funding_type?: 'bank_transfer' | null;
};

export type invoice_payment_method_options_customer_balance_bank_transfer = {
  eu_bank_transfer?: invoice_payment_method_options_customer_balance_bank_transfer_eu_bank_transfer;
  /**
   * The bank transfer type that can be used for funding. Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
   */
  type?: string | null;
};

export type invoice_payment_method_options_customer_balance_bank_transfer_eu_bank_transfer = {
  /**
   * The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
   */
  country: 'BE' | 'DE' | 'ES' | 'FR' | 'IE' | 'NL';
};

/**
 * The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
 */
export type country = 'BE' | 'DE' | 'ES' | 'FR' | 'IE' | 'NL';

export type invoice_payment_method_options_konbini = {
  [key: string]: unknown;
};

export type invoice_payment_method_options_sepa_debit = {
  [key: string]: unknown;
};

export type invoice_payment_method_options_us_bank_account = {
  financial_connections?: invoice_payment_method_options_us_bank_account_linked_account_options;
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type invoice_payment_method_options_us_bank_account_linked_account_options = {
  /**
   * The list of permissions to request. The `payment_method` permission must be included.
   */
  permissions?: Array<'balances' | 'ownership' | 'payment_method' | 'transactions'>;
  /**
   * Data features requested to be retrieved upon account creation.
   */
  prefetch?: Array<'balances' | 'ownership' | 'transactions'> | null;
};

export type invoice_rendering_pdf = {
  /**
   * Page size of invoice pdf. Options include a4, letter, and auto. If set to auto, page size will be switched to a4 or letter based on customer locale.
   */
  page_size?: ('a4' | 'auto' | 'letter') | null;
};

/**
 * Page size of invoice pdf. Options include a4, letter, and auto. If set to auto, page size will be switched to a4 or letter based on customer locale.
 */
export type page_size = 'a4' | 'auto' | 'letter';

export type invoice_setting_custom_field = {
  /**
   * The name of the custom field.
   */
  name: string;
  /**
   * The value of the custom field.
   */
  value: string;
};

export type invoice_setting_customer_rendering_options = {
  /**
   * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
   */
  amount_tax_display?: string | null;
};

export type invoice_setting_customer_setting = {
  /**
   * Default custom fields to be displayed on invoices for this customer.
   */
  custom_fields?: Array<invoice_setting_custom_field> | null;
  /**
   * ID of a payment method that's attached to the customer, to be used as the customer's default payment method for subscriptions and invoices.
   */
  default_payment_method?: (string | payment_method) | null;
  /**
   * Default footer to be displayed on invoices for this customer.
   */
  footer?: string | null;
  /**
   * Default options for invoice PDF rendering for this customer.
   */
  rendering_options?: invoice_setting_customer_rendering_options | null;
};

export type invoice_setting_quote_setting = {
  /**
   * Number of days within which a customer must pay invoices generated by this quote. This value will be `null` for quotes where `collection_method=charge_automatically`.
   */
  days_until_due?: number | null;
  issuer: connect_account_reference;
};

export type invoice_setting_rendering_options = {
  /**
   * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
   */
  amount_tax_display?: string | null;
};

export type invoice_setting_subscription_schedule_phase_setting = {
  /**
   * The account tax IDs associated with this phase of the subscription schedule. Will be set on invoices generated by this phase of the subscription schedule.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  /**
   * Number of days within which a customer must pay invoices generated by this subscription schedule. This value will be `null` for subscription schedules where `billing=charge_automatically`.
   */
  days_until_due?: number | null;
  /**
   * The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.
   */
  issuer?: connect_account_reference | null;
};

export type invoice_setting_subscription_schedule_setting = {
  /**
   * The account tax IDs associated with the subscription schedule. Will be set on invoices generated by the subscription schedule.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  /**
   * Number of days within which a customer must pay invoices generated by this subscription schedule. This value will be `null` for subscription schedules where `billing=charge_automatically`.
   */
  days_until_due?: number | null;
  issuer: connect_account_reference;
};

export type invoice_tax_amount = {
  /**
   * The amount, in cents (or local equivalent), of the tax.
   */
  amount: number;
  /**
   * Whether this tax amount is inclusive or exclusive.
   */
  inclusive: boolean;
  /**
   * The tax rate that was applied to get this tax amount.
   */
  tax_rate: string | tax_rate;
  /**
   * The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.
   */
  taxability_reason?:
    | (
        | 'customer_exempt'
        | 'not_collecting'
        | 'not_subject_to_tax'
        | 'not_supported'
        | 'portion_product_exempt'
        | 'portion_reduced_rated'
        | 'portion_standard_rated'
        | 'product_exempt'
        | 'product_exempt_holiday'
        | 'proportionally_rated'
        | 'reduced_rated'
        | 'reverse_charge'
        | 'standard_rated'
        | 'taxable_basis_reduced'
        | 'zero_rated'
      )
    | null;
  /**
   * The amount on which tax is calculated, in cents (or local equivalent).
   */
  taxable_amount?: number | null;
};

export type invoice_threshold_reason = {
  /**
   * The total invoice amount threshold boundary if it triggered the threshold invoice.
   */
  amount_gte?: number | null;
  /**
   * Indicates which line items triggered a threshold invoice.
   */
  item_reasons: Array<invoice_item_threshold_reason>;
};

export type invoice_transfer_data = {
  /**
   * The amount in cents (or local equivalent) that will be transferred to the destination account when the invoice is paid. By default, the entire amount is transferred to the destination.
   */
  amount?: number | null;
  /**
   * The account where funds from the payment will be transferred to upon payment success.
   */
  destination: string | account;
};

/**
 * Invoice Items represent the component lines of an [invoice](https://stripe.com/docs/api/invoices). An invoice item is added to an
 * invoice by creating or updating it with an `invoice` field, at which point it will be included as
 * [an invoice line item](https://stripe.com/docs/api/invoices/line_item) within
 * [invoice.lines](https://stripe.com/docs/api/invoices/object#invoice_object-lines).
 *
 * Invoice Items can be created before you are ready to actually send the invoice. This can be particularly useful when combined
 * with a [subscription](https://stripe.com/docs/api/subscriptions). Sometimes you want to add a charge or credit to a customer, but actually charge
 * or credit the customer’s card only at the end of a regular billing cycle. This is useful for combining several charges
 * (to minimize per-transaction fees), or for having Stripe tabulate your usage-based billing totals.
 *
 * Related guides: [Integrate with the Invoicing API](https://stripe.com/docs/invoicing/integration), [Subscription Invoices](https://stripe.com/docs/billing/invoices/subscription#adding-upcoming-invoice-items).
 */
export type invoiceitem = {
  /**
   * Amount (in the `currency` specified) of the invoice item. This should always be equal to `unit_amount * quantity`.
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The ID of the customer who will be billed when this invoice item is billed.
   */
  customer: string | customer | deleted_customer;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  date: number;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * If true, discounts will apply to this invoice item. Always false for prorations.
   */
  discountable: boolean;
  /**
   * The discounts which apply to the invoice item. Item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts?: Array<string | discount> | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The ID of the invoice this invoice item belongs to.
   */
  invoice?: (string | invoice) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'invoiceitem';
  period: invoice_line_item_period;
  /**
   * The price of the invoice item.
   */
  price?: price | null;
  /**
   * Whether the invoice item was created automatically as a proration adjustment when the customer switched plans.
   */
  proration: boolean;
  /**
   * Quantity of units for the invoice item. If the invoice item is a proration, the quantity of the subscription that the proration was computed for.
   */
  quantity: number;
  /**
   * The subscription that this invoice item has been created for, if any.
   */
  subscription?: (string | subscription) | null;
  /**
   * The subscription item that this invoice item has been created for, if any.
   */
  subscription_item?: string;
  /**
   * The tax rates which apply to the invoice item. When set, the `default_tax_rates` on the invoice do not apply to this invoice item.
   */
  tax_rates?: Array<tax_rate> | null;
  /**
   * ID of the test clock this invoice item belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
  /**
   * Unit amount (in the `currency` specified) of the invoice item.
   */
  unit_amount?: number | null;
  /**
   * Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.
   */
  unit_amount_decimal?: string | null;
};

export type invoices_payment_method_options = {
  /**
   * If paying by `acss_debit`, this sub-hash contains details about the Canadian pre-authorized debit payment method options to pass to the invoice’s PaymentIntent.
   */
  acss_debit?: invoice_payment_method_options_acss_debit | null;
  /**
   * If paying by `bancontact`, this sub-hash contains details about the Bancontact payment method options to pass to the invoice’s PaymentIntent.
   */
  bancontact?: invoice_payment_method_options_bancontact | null;
  /**
   * If paying by `card`, this sub-hash contains details about the Card payment method options to pass to the invoice’s PaymentIntent.
   */
  card?: invoice_payment_method_options_card | null;
  /**
   * If paying by `customer_balance`, this sub-hash contains details about the Bank transfer payment method options to pass to the invoice’s PaymentIntent.
   */
  customer_balance?: invoice_payment_method_options_customer_balance | null;
  /**
   * If paying by `konbini`, this sub-hash contains details about the Konbini payment method options to pass to the invoice’s PaymentIntent.
   */
  konbini?: invoice_payment_method_options_konbini | null;
  /**
   * If paying by `sepa_debit`, this sub-hash contains details about the SEPA Direct Debit payment method options to pass to the invoice’s PaymentIntent.
   */
  sepa_debit?: invoice_payment_method_options_sepa_debit | null;
  /**
   * If paying by `us_bank_account`, this sub-hash contains details about the ACH direct debit payment method options to pass to the invoice’s PaymentIntent.
   */
  us_bank_account?: invoice_payment_method_options_us_bank_account | null;
};

export type invoices_payment_settings = {
  /**
   * ID of the mandate to be used for this invoice. It must correspond to the payment method used to pay the invoice, including the invoice's default_payment_method or default_source, if set.
   */
  default_mandate?: string | null;
  /**
   * Payment-method-specific configuration to provide to the invoice’s PaymentIntent.
   */
  payment_method_options?: invoices_payment_method_options | null;
  /**
   * The list of payment method types (e.g. card) to provide to the invoice’s PaymentIntent. If not set, Stripe attempts to automatically determine the types to use by looking at the invoice’s default payment method, the subscription’s default payment method, the customer’s default payment method, and your [invoice template settings](https://dashboard.stripe.com/settings/billing/invoice).
   */
  payment_method_types?: Array<
    | 'ach_credit_transfer'
    | 'ach_debit'
    | 'acss_debit'
    | 'amazon_pay'
    | 'au_becs_debit'
    | 'bacs_debit'
    | 'bancontact'
    | 'boleto'
    | 'card'
    | 'cashapp'
    | 'customer_balance'
    | 'eps'
    | 'fpx'
    | 'giropay'
    | 'grabpay'
    | 'ideal'
    | 'konbini'
    | 'link'
    | 'p24'
    | 'paynow'
    | 'paypal'
    | 'promptpay'
    | 'revolut_pay'
    | 'sepa_debit'
    | 'sofort'
    | 'swish'
    | 'us_bank_account'
    | 'wechat_pay'
  > | null;
};

export type invoices_resource_from_invoice = {
  /**
   * The relation between this invoice and the cloned invoice
   */
  action: string;
  /**
   * The invoice that was cloned.
   */
  invoice: string | invoice;
};

export type invoices_resource_invoice_rendering = {
  /**
   * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
   */
  amount_tax_display?: string | null;
  /**
   * Invoice pdf rendering options
   */
  pdf?: invoice_rendering_pdf | null;
};

export type invoices_resource_invoice_tax_id = {
  /**
   * The type of the tax ID, one of `ad_nrt`, `ar_cuit`, `eu_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `cn_tin`, `co_nit`, `cr_tin`, `do_rcn`, `ec_ruc`, `eu_oss_vat`, `pe_ruc`, `ro_tin`, `rs_pib`, `sv_nit`, `uy_ruc`, `ve_rif`, `vn_tin`, `gb_vat`, `nz_gst`, `au_abn`, `au_arn`, `in_gst`, `no_vat`, `no_voec`, `za_vat`, `ch_vat`, `mx_rfc`, `sg_uen`, `ru_inn`, `ru_kpp`, `ca_bn`, `hk_br`, `es_cif`, `tw_vat`, `th_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `li_uid`, `my_itn`, `us_ein`, `kr_brn`, `ca_qst`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `my_sst`, `sg_gst`, `ae_trn`, `cl_tin`, `sa_vat`, `id_npwp`, `my_frp`, `il_vat`, `ge_vat`, `ua_vat`, `is_vat`, `bg_uic`, `hu_tin`, `si_tin`, `ke_pin`, `tr_tin`, `eg_tin`, `ph_tin`, `bh_vat`, `kz_bin`, `ng_tin`, `om_vat`, `de_stn`, or `unknown`
   */
  type:
    | 'ad_nrt'
    | 'ae_trn'
    | 'ar_cuit'
    | 'au_abn'
    | 'au_arn'
    | 'bg_uic'
    | 'bh_vat'
    | 'bo_tin'
    | 'br_cnpj'
    | 'br_cpf'
    | 'ca_bn'
    | 'ca_gst_hst'
    | 'ca_pst_bc'
    | 'ca_pst_mb'
    | 'ca_pst_sk'
    | 'ca_qst'
    | 'ch_vat'
    | 'cl_tin'
    | 'cn_tin'
    | 'co_nit'
    | 'cr_tin'
    | 'de_stn'
    | 'do_rcn'
    | 'ec_ruc'
    | 'eg_tin'
    | 'es_cif'
    | 'eu_oss_vat'
    | 'eu_vat'
    | 'gb_vat'
    | 'ge_vat'
    | 'hk_br'
    | 'hu_tin'
    | 'id_npwp'
    | 'il_vat'
    | 'in_gst'
    | 'is_vat'
    | 'jp_cn'
    | 'jp_rn'
    | 'jp_trn'
    | 'ke_pin'
    | 'kr_brn'
    | 'kz_bin'
    | 'li_uid'
    | 'mx_rfc'
    | 'my_frp'
    | 'my_itn'
    | 'my_sst'
    | 'ng_tin'
    | 'no_vat'
    | 'no_voec'
    | 'nz_gst'
    | 'om_vat'
    | 'pe_ruc'
    | 'ph_tin'
    | 'ro_tin'
    | 'rs_pib'
    | 'ru_inn'
    | 'ru_kpp'
    | 'sa_vat'
    | 'sg_gst'
    | 'sg_uen'
    | 'si_tin'
    | 'sv_nit'
    | 'th_vat'
    | 'tr_tin'
    | 'tw_vat'
    | 'ua_vat'
    | 'unknown'
    | 'us_ein'
    | 'uy_ruc'
    | 've_rif'
    | 'vn_tin'
    | 'za_vat';
  /**
   * The value of the tax ID.
   */
  value?: string | null;
};

/**
 * The type of the tax ID, one of `ad_nrt`, `ar_cuit`, `eu_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `cn_tin`, `co_nit`, `cr_tin`, `do_rcn`, `ec_ruc`, `eu_oss_vat`, `pe_ruc`, `ro_tin`, `rs_pib`, `sv_nit`, `uy_ruc`, `ve_rif`, `vn_tin`, `gb_vat`, `nz_gst`, `au_abn`, `au_arn`, `in_gst`, `no_vat`, `no_voec`, `za_vat`, `ch_vat`, `mx_rfc`, `sg_uen`, `ru_inn`, `ru_kpp`, `ca_bn`, `hk_br`, `es_cif`, `tw_vat`, `th_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `li_uid`, `my_itn`, `us_ein`, `kr_brn`, `ca_qst`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `my_sst`, `sg_gst`, `ae_trn`, `cl_tin`, `sa_vat`, `id_npwp`, `my_frp`, `il_vat`, `ge_vat`, `ua_vat`, `is_vat`, `bg_uic`, `hu_tin`, `si_tin`, `ke_pin`, `tr_tin`, `eg_tin`, `ph_tin`, `bh_vat`, `kz_bin`, `ng_tin`, `om_vat`, `de_stn`, or `unknown`
 */
export type type24 =
  | 'ad_nrt'
  | 'ae_trn'
  | 'ar_cuit'
  | 'au_abn'
  | 'au_arn'
  | 'bg_uic'
  | 'bh_vat'
  | 'bo_tin'
  | 'br_cnpj'
  | 'br_cpf'
  | 'ca_bn'
  | 'ca_gst_hst'
  | 'ca_pst_bc'
  | 'ca_pst_mb'
  | 'ca_pst_sk'
  | 'ca_qst'
  | 'ch_vat'
  | 'cl_tin'
  | 'cn_tin'
  | 'co_nit'
  | 'cr_tin'
  | 'de_stn'
  | 'do_rcn'
  | 'ec_ruc'
  | 'eg_tin'
  | 'es_cif'
  | 'eu_oss_vat'
  | 'eu_vat'
  | 'gb_vat'
  | 'ge_vat'
  | 'hk_br'
  | 'hu_tin'
  | 'id_npwp'
  | 'il_vat'
  | 'in_gst'
  | 'is_vat'
  | 'jp_cn'
  | 'jp_rn'
  | 'jp_trn'
  | 'ke_pin'
  | 'kr_brn'
  | 'kz_bin'
  | 'li_uid'
  | 'mx_rfc'
  | 'my_frp'
  | 'my_itn'
  | 'my_sst'
  | 'ng_tin'
  | 'no_vat'
  | 'no_voec'
  | 'nz_gst'
  | 'om_vat'
  | 'pe_ruc'
  | 'ph_tin'
  | 'ro_tin'
  | 'rs_pib'
  | 'ru_inn'
  | 'ru_kpp'
  | 'sa_vat'
  | 'sg_gst'
  | 'sg_uen'
  | 'si_tin'
  | 'sv_nit'
  | 'th_vat'
  | 'tr_tin'
  | 'tw_vat'
  | 'ua_vat'
  | 'unknown'
  | 'us_ein'
  | 'uy_ruc'
  | 've_rif'
  | 'vn_tin'
  | 'za_vat';

export type invoices_resource_line_items_credited_items = {
  /**
   * Invoice containing the credited invoice line items
   */
  invoice: string;
  /**
   * Credited invoice line items
   */
  invoice_line_items: Array<string>;
};

export type invoices_resource_line_items_proration_details = {
  /**
   * For a credit proration `line_item`, the original debit line_items to which the credit proration applies.
   */
  credited_items?: invoices_resource_line_items_credited_items | null;
};

export type invoices_resource_shipping_cost = {
  /**
   * Total shipping cost before any taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.
   */
  amount_tax: number;
  /**
   * Total shipping cost after taxes are applied.
   */
  amount_total: number;
  /**
   * The ID of the ShippingRate for this invoice.
   */
  shipping_rate?: (string | shipping_rate) | null;
  /**
   * The taxes applied to the shipping rate.
   */
  taxes?: Array<line_items_tax_amount>;
};

export type invoices_resource_status_transitions = {
  /**
   * The time that the invoice draft was finalized.
   */
  finalized_at?: number | null;
  /**
   * The time that the invoice was marked uncollectible.
   */
  marked_uncollectible_at?: number | null;
  /**
   * The time that the invoice was paid.
   */
  paid_at?: number | null;
  /**
   * The time that the invoice was voided.
   */
  voided_at?: number | null;
};

/**
 * When an [issued card](https://stripe.com/docs/issuing) is used to make a purchase, an Issuing `Authorization`
 * object is created. [Authorizations](https://stripe.com/docs/issuing/purchases/authorizations) must be approved for the
 * purchase to be completed successfully.
 *
 * Related guide: [Issued card authorizations](https://stripe.com/docs/issuing/purchases/authorizations)
 */
export type issuing_authorization = {
  /**
   * The total amount that was authorized or rejected. This amount is in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). `amount` should be the same as `merchant_amount`, unless `currency` and `merchant_currency` are different.
   */
  amount: number;
  /**
   * Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_details?: issuing_authorization_amount_details | null;
  /**
   * Whether the authorization has been approved.
   */
  approved: boolean;
  /**
   * How the card details were provided.
   */
  authorization_method: 'chip' | 'contactless' | 'keyed_in' | 'online' | 'swipe';
  /**
   * List of balance transactions associated with this authorization.
   */
  balance_transactions: Array<balance_transaction>;
  card: issuing_card;
  /**
   * The cardholder to whom this authorization belongs.
   */
  cardholder?: (string | issuing_cardholder) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The currency of the cardholder. This currency can be different from the currency presented at authorization and the `merchant_currency` field on this authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The total amount that was authorized or rejected. This amount is in the `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). `merchant_amount` should be the same as `amount`, unless `merchant_currency` and `currency` are different.
   */
  merchant_amount: number;
  /**
   * The local currency that was presented to the cardholder for the authorization. This currency can be different from the cardholder currency and the `currency` field on this authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  merchant_currency: string;
  merchant_data: issuing_authorization_merchant_data;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Details about the authorization, such as identifiers, set by the card network.
   */
  network_data?: issuing_authorization_network_data | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.authorization';
  /**
   * The pending authorization request. This field will only be non-null during an `issuing_authorization.request` webhook.
   */
  pending_request?: issuing_authorization_pending_request | null;
  /**
   * History of every time a `pending_request` authorization was approved/declined, either by you directly or by Stripe (e.g. based on your spending_controls). If the merchant changes the authorization by performing an incremental authorization, you can look at this field to see the previous requests for the authorization. This field can be helpful in determining why a given authorization was approved/declined.
   */
  request_history: Array<issuing_authorization_request>;
  /**
   * The current status of the authorization in its lifecycle.
   */
  status: 'closed' | 'pending' | 'reversed';
  /**
   * [Token](https://stripe.com/docs/api/issuing/tokens/object) object used for this authorization. If a network token was not used for this authorization, this field will be null.
   */
  token?: (string | issuing_token) | null;
  /**
   * List of [transactions](https://stripe.com/docs/api/issuing/transactions) associated with this authorization.
   */
  transactions: Array<issuing_transaction>;
  /**
   * [Treasury](https://stripe.com/docs/api/treasury) details related to this authorization if it was created on a [FinancialAccount](https://stripe.com/docs/api/treasury/financial_accounts).
   */
  treasury?: issuing_authorization_treasury | null;
  verification_data: issuing_authorization_verification_data;
  /**
   * The digital wallet used for this transaction. One of `apple_pay`, `google_pay`, or `samsung_pay`. Will populate as `null` when no digital wallet was utilized.
   */
  wallet?: string | null;
};

/**
 * How the card details were provided.
 */
export type authorization_method = 'chip' | 'contactless' | 'keyed_in' | 'online' | 'swipe';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object67 = 'issuing.authorization';

/**
 * The current status of the authorization in its lifecycle.
 */
export type status15 = 'closed' | 'pending' | 'reversed';

export type issuing_authorization_amount_details = {
  /**
   * The fee charged by the ATM for the cash withdrawal.
   */
  atm_fee?: number | null;
  /**
   * The amount of cash requested by the cardholder.
   */
  cashback_amount?: number | null;
};

export type issuing_authorization_authentication_exemption = {
  /**
   * The entity that requested the exemption, either the acquiring merchant or the Issuing user.
   */
  claimed_by: 'acquirer' | 'issuer';
  /**
   * The specific exemption claimed for this authorization.
   */
  type: 'low_value_transaction' | 'transaction_risk_analysis' | 'unknown';
};

/**
 * The entity that requested the exemption, either the acquiring merchant or the Issuing user.
 */
export type claimed_by = 'acquirer' | 'issuer';

/**
 * The specific exemption claimed for this authorization.
 */
export type type25 = 'low_value_transaction' | 'transaction_risk_analysis' | 'unknown';

export type issuing_authorization_merchant_data = {
  /**
   * A categorization of the seller's type of business. See our [merchant categories guide](https://stripe.com/docs/issuing/merchant-categories) for a list of possible values.
   */
  category: string;
  /**
   * The merchant category code for the seller’s business
   */
  category_code: string;
  /**
   * City where the seller is located
   */
  city?: string | null;
  /**
   * Country where the seller is located
   */
  country?: string | null;
  /**
   * Name of the seller
   */
  name?: string | null;
  /**
   * Identifier assigned to the seller by the card network. Different card networks may assign different network_id fields to the same merchant.
   */
  network_id: string;
  /**
   * Postal code where the seller is located
   */
  postal_code?: string | null;
  /**
   * State where the seller is located
   */
  state?: string | null;
  /**
   * An ID assigned by the seller to the location of the sale.
   */
  terminal_id?: string | null;
  /**
   * URL provided by the merchant on a 3DS request
   */
  url?: string | null;
};

export type issuing_authorization_network_data = {
  /**
   * Identifier assigned to the acquirer by the card network. Sometimes this value is not provided by the network; in this case, the value will be `null`.
   */
  acquiring_institution_id?: string | null;
  /**
   * The System Trace Audit Number (STAN) is a 6-digit identifier assigned by the acquirer. Prefer `network_data.transaction_id` if present, unless you have special requirements.
   */
  system_trace_audit_number?: string | null;
  /**
   * Unique identifier for the authorization assigned by the card network used to match subsequent messages, disputes, and transactions.
   */
  transaction_id?: string | null;
};

export type issuing_authorization_pending_request = {
  /**
   * The additional amount Stripe will hold if the authorization is approved, in the card's [currency](https://stripe.com/docs/api#issuing_authorization_object-pending-request-currency) and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_details?: issuing_authorization_amount_details | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * If set `true`, you may provide [amount](https://stripe.com/docs/api/issuing/authorizations/approve#approve_issuing_authorization-amount) to control how much to hold for the authorization.
   */
  is_amount_controllable: boolean;
  /**
   * The amount the merchant is requesting to be authorized in the `merchant_currency`. The amount is in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  merchant_amount: number;
  /**
   * The local currency the merchant is requesting to authorize.
   */
  merchant_currency: string;
  /**
   * The card network's estimate of the likelihood that an authorization is fraudulent. Takes on values between 1 and 99.
   */
  network_risk_score?: number | null;
};

export type issuing_authorization_request = {
  /**
   * The `pending_request.amount` at the time of the request, presented in your card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). Stripe held this amount from your account to fund the authorization if the request was approved.
   */
  amount: number;
  /**
   * Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_details?: issuing_authorization_amount_details | null;
  /**
   * Whether this request was approved.
   */
  approved: boolean;
  /**
   * A code created by Stripe which is shared with the merchant to validate the authorization. This field will be populated if the authorization message was approved. The code typically starts with the letter "S", followed by a six-digit number. For example, "S498162". Please note that the code is not guaranteed to be unique across authorizations.
   */
  authorization_code?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The `pending_request.merchant_amount` at the time of the request, presented in the `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  merchant_amount: number;
  /**
   * The currency that was collected by the merchant and presented to the cardholder for the authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  merchant_currency: string;
  /**
   * The card network's estimate of the likelihood that an authorization is fraudulent. Takes on values between 1 and 99.
   */
  network_risk_score?: number | null;
  /**
   * When an authorization is approved or declined by you or by Stripe, this field provides additional detail on the reason for the outcome.
   */
  reason:
    | 'account_disabled'
    | 'card_active'
    | 'card_inactive'
    | 'cardholder_inactive'
    | 'cardholder_verification_required'
    | 'insufficient_funds'
    | 'not_allowed'
    | 'spending_controls'
    | 'suspected_fraud'
    | 'verification_failed'
    | 'webhook_approved'
    | 'webhook_declined'
    | 'webhook_error'
    | 'webhook_timeout';
  /**
   * If the `request_history.reason` is `webhook_error` because the direct webhook response is invalid (for example, parsing errors or missing parameters), we surface a more detailed error message via this field.
   */
  reason_message?: string | null;
  /**
   * Time when the card network received an authorization request from the acquirer in UTC. Referred to by networks as transmission time.
   */
  requested_at?: number | null;
};

/**
 * When an authorization is approved or declined by you or by Stripe, this field provides additional detail on the reason for the outcome.
 */
export type reason3 =
  | 'account_disabled'
  | 'card_active'
  | 'card_inactive'
  | 'cardholder_inactive'
  | 'cardholder_verification_required'
  | 'insufficient_funds'
  | 'not_allowed'
  | 'spending_controls'
  | 'suspected_fraud'
  | 'verification_failed'
  | 'webhook_approved'
  | 'webhook_declined'
  | 'webhook_error'
  | 'webhook_timeout';

export type issuing_authorization_three_d_secure = {
  /**
   * The outcome of the 3D Secure authentication request.
   */
  result: 'attempt_acknowledged' | 'authenticated' | 'failed' | 'required';
};

/**
 * The outcome of the 3D Secure authentication request.
 */
export type result = 'attempt_acknowledged' | 'authenticated' | 'failed' | 'required';

export type issuing_authorization_treasury = {
  /**
   * The array of [ReceivedCredits](https://stripe.com/docs/api/treasury/received_credits) associated with this authorization
   */
  received_credits: Array<string>;
  /**
   * The array of [ReceivedDebits](https://stripe.com/docs/api/treasury/received_debits) associated with this authorization
   */
  received_debits: Array<string>;
  /**
   * The Treasury [Transaction](https://stripe.com/docs/api/treasury/transactions) associated with this authorization
   */
  transaction?: string | null;
};

export type issuing_authorization_verification_data = {
  /**
   * Whether the cardholder provided an address first line and if it matched the cardholder’s `billing.address.line1`.
   */
  address_line1_check: 'match' | 'mismatch' | 'not_provided';
  /**
   * Whether the cardholder provided a postal code and if it matched the cardholder’s `billing.address.postal_code`.
   */
  address_postal_code_check: 'match' | 'mismatch' | 'not_provided';
  /**
   * The exemption applied to this authorization.
   */
  authentication_exemption?: issuing_authorization_authentication_exemption | null;
  /**
   * Whether the cardholder provided a CVC and if it matched Stripe’s record.
   */
  cvc_check: 'match' | 'mismatch' | 'not_provided';
  /**
   * Whether the cardholder provided an expiry date and if it matched Stripe’s record.
   */
  expiry_check: 'match' | 'mismatch' | 'not_provided';
  /**
   * The postal code submitted as part of the authorization used for postal code verification.
   */
  postal_code?: string | null;
  /**
   * 3D Secure details.
   */
  three_d_secure?: issuing_authorization_three_d_secure | null;
};

/**
 * Whether the cardholder provided an address first line and if it matched the cardholder’s `billing.address.line1`.
 */
export type address_line1_check = 'match' | 'mismatch' | 'not_provided';

/**
 * Whether the cardholder provided a postal code and if it matched the cardholder’s `billing.address.postal_code`.
 */
export type address_postal_code_check = 'match' | 'mismatch' | 'not_provided';

/**
 * Whether the cardholder provided a CVC and if it matched Stripe’s record.
 */
export type cvc_check = 'match' | 'mismatch' | 'not_provided';

/**
 * Whether the cardholder provided an expiry date and if it matched Stripe’s record.
 */
export type expiry_check = 'match' | 'mismatch' | 'not_provided';

/**
 * You can [create physical or virtual cards](https://stripe.com/docs/issuing/cards) that are issued to cardholders.
 */
export type issuing_card = {
  /**
   * The brand of the card.
   */
  brand: string;
  /**
   * The reason why the card was canceled.
   */
  cancellation_reason?: ('design_rejected' | 'lost' | 'stolen') | null;
  cardholder: issuing_cardholder;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Supported currencies are `usd` in the US, `eur` in the EU, and `gbp` in the UK.
   */
  currency: string;
  /**
   * The card's CVC. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with [the `expand` parameter](https://stripe.com/docs/api/expanding_objects). Additionally, it's only available via the ["Retrieve a card" endpoint](https://stripe.com/docs/api/issuing/cards/retrieve), not via "List all cards" or any other endpoint.
   */
  cvc?: string;
  /**
   * The expiration month of the card.
   */
  exp_month: number;
  /**
   * The expiration year of the card.
   */
  exp_year: number;
  /**
   * The financial account this card is attached to.
   */
  financial_account?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The last 4 digits of the card number.
   */
  last4: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The full unredacted card number. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with [the `expand` parameter](https://stripe.com/docs/api/expanding_objects). Additionally, it's only available via the ["Retrieve a card" endpoint](https://stripe.com/docs/api/issuing/cards/retrieve), not via "List all cards" or any other endpoint.
   */
  number?: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.card';
  /**
   * The personalization design object belonging to this card.
   */
  personalization_design?: (string | issuing_personalization_design) | null;
  /**
   * The latest card that replaces this card, if any.
   */
  replaced_by?: (string | issuing_card) | null;
  /**
   * The card this card replaces, if any.
   */
  replacement_for?: (string | issuing_card) | null;
  /**
   * The reason why the previous card needed to be replaced.
   */
  replacement_reason?: ('damaged' | 'expired' | 'lost' | 'stolen') | null;
  /**
   * Where and how the card will be shipped.
   */
  shipping?: issuing_card_shipping | null;
  spending_controls: issuing_card_authorization_controls;
  /**
   * Whether authorizations can be approved on this card. May be blocked from activating cards depending on past-due Cardholder requirements. Defaults to `inactive`.
   */
  status: 'active' | 'canceled' | 'inactive';
  /**
   * The type of the card.
   */
  type: 'physical' | 'virtual';
  /**
   * Information relating to digital wallets (like Apple Pay and Google Pay).
   */
  wallets?: issuing_card_wallets | null;
};

/**
 * The reason why the card was canceled.
 */
export type cancellation_reason2 = 'design_rejected' | 'lost' | 'stolen';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object68 = 'issuing.card';

/**
 * The reason why the previous card needed to be replaced.
 */
export type replacement_reason = 'damaged' | 'expired' | 'lost' | 'stolen';

/**
 * Whether authorizations can be approved on this card. May be blocked from activating cards depending on past-due Cardholder requirements. Defaults to `inactive`.
 */
export type status16 = 'active' | 'canceled' | 'inactive';

/**
 * The type of the card.
 */
export type type26 = 'physical' | 'virtual';

export type issuing_card_apple_pay = {
  /**
   * Apple Pay Eligibility
   */
  eligible: boolean;
  /**
   * Reason the card is ineligible for Apple Pay
   */
  ineligible_reason?: ('missing_agreement' | 'missing_cardholder_contact' | 'unsupported_region') | null;
};

/**
 * Reason the card is ineligible for Apple Pay
 */
export type ineligible_reason = 'missing_agreement' | 'missing_cardholder_contact' | 'unsupported_region';

export type issuing_card_authorization_controls = {
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to allow. All other categories will be blocked. Cannot be set with `blocked_categories`.
   */
  allowed_categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Array of strings containing representing countries from which authorizations will be allowed. Authorizations from merchants in all other countries will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `blocked_merchant_countries`. Provide an empty value to unset this control.
   */
  allowed_merchant_countries?: Array<string> | null;
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to decline. All other categories will be allowed. Cannot be set with `allowed_categories`.
   */
  blocked_categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Array of strings containing representing countries from which authorizations will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `allowed_merchant_countries`. Provide an empty value to unset this control.
   */
  blocked_merchant_countries?: Array<string> | null;
  /**
   * Limit spending with amount-based rules that apply across any cards this card replaced (i.e., its `replacement_for` card and _that_ card's `replacement_for` card, up the chain).
   */
  spending_limits?: Array<issuing_card_spending_limit> | null;
  /**
   * Currency of the amounts within `spending_limits`. Always the same as the currency of the card.
   */
  spending_limits_currency?: string | null;
};

export type issuing_card_google_pay = {
  /**
   * Google Pay Eligibility
   */
  eligible: boolean;
  /**
   * Reason the card is ineligible for Google Pay
   */
  ineligible_reason?: ('missing_agreement' | 'missing_cardholder_contact' | 'unsupported_region') | null;
};

export type issuing_card_shipping = {
  address: address;
  /**
   * The delivery company that shipped a card.
   */
  carrier?: ('dhl' | 'fedex' | 'royal_mail' | 'usps') | null;
  /**
   * Additional information that may be required for clearing customs.
   */
  customs?: issuing_card_shipping_customs | null;
  /**
   * A unix timestamp representing a best estimate of when the card will be delivered.
   */
  eta?: number | null;
  /**
   * Recipient name.
   */
  name: string;
  /**
   * The phone number of the receiver of the shipment. Our courier partners will use this number to contact you in the event of card delivery issues. For individual shipments to the EU/UK, if this field is empty, we will provide them with the phone number provided when the cardholder was initially created.
   */
  phone_number?: string | null;
  /**
   * Whether a signature is required for card delivery. This feature is only supported for US users. Standard shipping service does not support signature on delivery. The default value for standard shipping service is false and for express and priority services is true.
   */
  require_signature?: boolean | null;
  /**
   * Shipment service, such as `standard` or `express`.
   */
  service: 'express' | 'priority' | 'standard';
  /**
   * The delivery status of the card.
   */
  status?: ('canceled' | 'delivered' | 'failure' | 'pending' | 'returned' | 'shipped') | null;
  /**
   * A tracking number for a card shipment.
   */
  tracking_number?: string | null;
  /**
   * A link to the shipping carrier's site where you can view detailed information about a card shipment.
   */
  tracking_url?: string | null;
  /**
   * Packaging options.
   */
  type: 'bulk' | 'individual';
};

/**
 * The delivery company that shipped a card.
 */
export type carrier = 'dhl' | 'fedex' | 'royal_mail' | 'usps';

/**
 * Shipment service, such as `standard` or `express`.
 */
export type service = 'express' | 'priority' | 'standard';

/**
 * The delivery status of the card.
 */
export type status17 = 'canceled' | 'delivered' | 'failure' | 'pending' | 'returned' | 'shipped';

/**
 * Packaging options.
 */
export type type27 = 'bulk' | 'individual';

export type issuing_card_shipping_customs = {
  /**
   * A registration number used for customs in Europe. See [https://www.gov.uk/eori](https://www.gov.uk/eori) for the UK and [https://ec.europa.eu/taxation_customs/business/customs-procedures-import-and-export/customs-procedures/economic-operators-registration-and-identification-number-eori_en](https://ec.europa.eu/taxation_customs/business/customs-procedures-import-and-export/customs-procedures/economic-operators-registration-and-identification-number-eori_en) for the EU.
   */
  eori_number?: string | null;
};

export type issuing_card_spending_limit = {
  /**
   * Maximum amount allowed to spend per interval. This amount is in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) this limit applies to. Omitting this field will apply the limit to all categories.
   */
  categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Interval (or event) to which the amount applies.
   */
  interval: 'all_time' | 'daily' | 'monthly' | 'per_authorization' | 'weekly' | 'yearly';
};

/**
 * Interval (or event) to which the amount applies.
 */
export type interval = 'all_time' | 'daily' | 'monthly' | 'per_authorization' | 'weekly' | 'yearly';

export type issuing_card_wallets = {
  apple_pay: issuing_card_apple_pay;
  google_pay: issuing_card_google_pay;
  /**
   * Unique identifier for a card used with digital wallets
   */
  primary_account_identifier?: string | null;
};

/**
 * An Issuing `Cardholder` object represents an individual or business entity who is [issued](https://stripe.com/docs/issuing) cards.
 *
 * Related guide: [How to create a cardholder](https://stripe.com/docs/issuing/cards#create-cardholder)
 */
export type issuing_cardholder = {
  billing: issuing_cardholder_address;
  /**
   * Additional information about a `company` cardholder.
   */
  company?: issuing_cardholder_company | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The cardholder's email address.
   */
  email?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Additional information about an `individual` cardholder.
   */
  individual?: issuing_cardholder_individual | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The cardholder's name. This will be printed on cards issued to them.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.cardholder';
  /**
   * The cardholder's phone number. This is required for all cardholders who will be creating EU cards. See the [3D Secure documentation](https://stripe.com/docs/issuing/3d-secure#when-is-3d-secure-applied) for more details.
   */
  phone_number?: string | null;
  /**
   * The cardholder’s preferred locales (languages), ordered by preference. Locales can be `de`, `en`, `es`, `fr`, or `it`.
   * This changes the language of the [3D Secure flow](https://stripe.com/docs/issuing/3d-secure) and one-time password messages sent to the cardholder.
   */
  preferred_locales?: Array<'de' | 'en' | 'es' | 'fr' | 'it'> | null;
  requirements: issuing_cardholder_requirements;
  /**
   * Rules that control spending across this cardholder's cards. Refer to our [documentation](https://stripe.com/docs/issuing/controls/spending-controls) for more details.
   */
  spending_controls?: issuing_cardholder_authorization_controls | null;
  /**
   * Specifies whether to permit authorizations on this cardholder's cards.
   */
  status: 'active' | 'blocked' | 'inactive';
  /**
   * One of `individual` or `company`. See [Choose a cardholder type](https://stripe.com/docs/issuing/other/choose-cardholder) for more details.
   */
  type: 'company' | 'individual';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object69 = 'issuing.cardholder';

/**
 * Specifies whether to permit authorizations on this cardholder's cards.
 */
export type status18 = 'active' | 'blocked' | 'inactive';

/**
 * One of `individual` or `company`. See [Choose a cardholder type](https://stripe.com/docs/issuing/other/choose-cardholder) for more details.
 */
export type type28 = 'company' | 'individual';

export type issuing_cardholder_address = {
  address: address;
};

export type issuing_cardholder_authorization_controls = {
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to allow. All other categories will be blocked. Cannot be set with `blocked_categories`.
   */
  allowed_categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Array of strings containing representing countries from which authorizations will be allowed. Authorizations from merchants in all other countries will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `blocked_merchant_countries`. Provide an empty value to unset this control.
   */
  allowed_merchant_countries?: Array<string> | null;
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to decline. All other categories will be allowed. Cannot be set with `allowed_categories`.
   */
  blocked_categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Array of strings containing representing countries from which authorizations will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `allowed_merchant_countries`. Provide an empty value to unset this control.
   */
  blocked_merchant_countries?: Array<string> | null;
  /**
   * Limit spending with amount-based rules that apply across this cardholder's cards.
   */
  spending_limits?: Array<issuing_cardholder_spending_limit> | null;
  /**
   * Currency of the amounts within `spending_limits`.
   */
  spending_limits_currency?: string | null;
};

export type issuing_cardholder_card_issuing = {
  /**
   * Information about cardholder acceptance of Celtic [Authorized User Terms](https://stripe.com/docs/issuing/cards#accept-authorized-user-terms). Required for cards backed by a Celtic program.
   */
  user_terms_acceptance?: issuing_cardholder_user_terms_acceptance | null;
};

export type issuing_cardholder_company = {
  /**
   * Whether the company's business ID number was provided.
   */
  tax_id_provided: boolean;
};

export type issuing_cardholder_id_document = {
  /**
   * The back of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.
   */
  back?: (string | file) | null;
  /**
   * The front of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.
   */
  front?: (string | file) | null;
};

export type issuing_cardholder_individual = {
  /**
   * Information related to the card_issuing program for this cardholder.
   */
  card_issuing?: issuing_cardholder_card_issuing | null;
  /**
   * The date of birth of this cardholder.
   */
  dob?: issuing_cardholder_individual_dob | null;
  /**
   * The first name of this cardholder. Required before activating Cards. This field cannot contain any numbers, special characters (except periods, commas, hyphens, spaces and apostrophes) or non-latin letters.
   */
  first_name?: string | null;
  /**
   * The last name of this cardholder. Required before activating Cards. This field cannot contain any numbers, special characters (except periods, commas, hyphens, spaces and apostrophes) or non-latin letters.
   */
  last_name?: string | null;
  /**
   * Government-issued ID document for this cardholder.
   */
  verification?: issuing_cardholder_verification | null;
};

export type issuing_cardholder_individual_dob = {
  /**
   * The day of birth, between 1 and 31.
   */
  day?: number | null;
  /**
   * The month of birth, between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year of birth.
   */
  year?: number | null;
};

export type issuing_cardholder_requirements = {
  /**
   * If `disabled_reason` is present, all cards will decline authorizations with `cardholder_verification_required` reason.
   */
  disabled_reason?: ('listed' | 'rejected.listed' | 'requirements.past_due' | 'under_review') | null;
  /**
   * Array of fields that need to be collected in order to verify and re-enable the cardholder.
   */
  past_due?: Array<
    | 'company.tax_id'
    | 'individual.card_issuing.user_terms_acceptance.date'
    | 'individual.card_issuing.user_terms_acceptance.ip'
    | 'individual.dob.day'
    | 'individual.dob.month'
    | 'individual.dob.year'
    | 'individual.first_name'
    | 'individual.last_name'
    | 'individual.verification.document'
  > | null;
};

/**
 * If `disabled_reason` is present, all cards will decline authorizations with `cardholder_verification_required` reason.
 */
export type disabled_reason = 'listed' | 'rejected.listed' | 'requirements.past_due' | 'under_review';

export type issuing_cardholder_spending_limit = {
  /**
   * Maximum amount allowed to spend per interval. This amount is in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) this limit applies to. Omitting this field will apply the limit to all categories.
   */
  categories?: Array<
    | 'ac_refrigeration_repair'
    | 'accounting_bookkeeping_services'
    | 'advertising_services'
    | 'agricultural_cooperative'
    | 'airlines_air_carriers'
    | 'airports_flying_fields'
    | 'ambulance_services'
    | 'amusement_parks_carnivals'
    | 'antique_reproductions'
    | 'antique_shops'
    | 'aquariums'
    | 'architectural_surveying_services'
    | 'art_dealers_and_galleries'
    | 'artists_supply_and_craft_shops'
    | 'auto_and_home_supply_stores'
    | 'auto_body_repair_shops'
    | 'auto_paint_shops'
    | 'auto_service_shops'
    | 'automated_cash_disburse'
    | 'automated_fuel_dispensers'
    | 'automobile_associations'
    | 'automotive_parts_and_accessories_stores'
    | 'automotive_tire_stores'
    | 'bail_and_bond_payments'
    | 'bakeries'
    | 'bands_orchestras'
    | 'barber_and_beauty_shops'
    | 'betting_casino_gambling'
    | 'bicycle_shops'
    | 'billiard_pool_establishments'
    | 'boat_dealers'
    | 'boat_rentals_and_leases'
    | 'book_stores'
    | 'books_periodicals_and_newspapers'
    | 'bowling_alleys'
    | 'bus_lines'
    | 'business_secretarial_schools'
    | 'buying_shopping_services'
    | 'cable_satellite_and_other_pay_television_and_radio'
    | 'camera_and_photographic_supply_stores'
    | 'candy_nut_and_confectionery_stores'
    | 'car_and_truck_dealers_new_used'
    | 'car_and_truck_dealers_used_only'
    | 'car_rental_agencies'
    | 'car_washes'
    | 'carpentry_services'
    | 'carpet_upholstery_cleaning'
    | 'caterers'
    | 'charitable_and_social_service_organizations_fundraising'
    | 'chemicals_and_allied_products'
    | 'child_care_services'
    | 'childrens_and_infants_wear_stores'
    | 'chiropodists_podiatrists'
    | 'chiropractors'
    | 'cigar_stores_and_stands'
    | 'civic_social_fraternal_associations'
    | 'cleaning_and_maintenance'
    | 'clothing_rental'
    | 'colleges_universities'
    | 'commercial_equipment'
    | 'commercial_footwear'
    | 'commercial_photography_art_and_graphics'
    | 'commuter_transport_and_ferries'
    | 'computer_network_services'
    | 'computer_programming'
    | 'computer_repair'
    | 'computer_software_stores'
    | 'computers_peripherals_and_software'
    | 'concrete_work_services'
    | 'construction_materials'
    | 'consulting_public_relations'
    | 'correspondence_schools'
    | 'cosmetic_stores'
    | 'counseling_services'
    | 'country_clubs'
    | 'courier_services'
    | 'court_costs'
    | 'credit_reporting_agencies'
    | 'cruise_lines'
    | 'dairy_products_stores'
    | 'dance_hall_studios_schools'
    | 'dating_escort_services'
    | 'dentists_orthodontists'
    | 'department_stores'
    | 'detective_agencies'
    | 'digital_goods_applications'
    | 'digital_goods_games'
    | 'digital_goods_large_volume'
    | 'digital_goods_media'
    | 'direct_marketing_catalog_merchant'
    | 'direct_marketing_combination_catalog_and_retail_merchant'
    | 'direct_marketing_inbound_telemarketing'
    | 'direct_marketing_insurance_services'
    | 'direct_marketing_other'
    | 'direct_marketing_outbound_telemarketing'
    | 'direct_marketing_subscription'
    | 'direct_marketing_travel'
    | 'discount_stores'
    | 'doctors'
    | 'door_to_door_sales'
    | 'drapery_window_covering_and_upholstery_stores'
    | 'drinking_places'
    | 'drug_stores_and_pharmacies'
    | 'drugs_drug_proprietaries_and_druggist_sundries'
    | 'dry_cleaners'
    | 'durable_goods'
    | 'duty_free_stores'
    | 'eating_places_restaurants'
    | 'educational_services'
    | 'electric_razor_stores'
    | 'electric_vehicle_charging'
    | 'electrical_parts_and_equipment'
    | 'electrical_services'
    | 'electronics_repair_shops'
    | 'electronics_stores'
    | 'elementary_secondary_schools'
    | 'emergency_services_gcas_visa_use_only'
    | 'employment_temp_agencies'
    | 'equipment_rental'
    | 'exterminating_services'
    | 'family_clothing_stores'
    | 'fast_food_restaurants'
    | 'financial_institutions'
    | 'fines_government_administrative_entities'
    | 'fireplace_fireplace_screens_and_accessories_stores'
    | 'floor_covering_stores'
    | 'florists'
    | 'florists_supplies_nursery_stock_and_flowers'
    | 'freezer_and_locker_meat_provisioners'
    | 'fuel_dealers_non_automotive'
    | 'funeral_services_crematories'
    | 'furniture_home_furnishings_and_equipment_stores_except_appliances'
    | 'furniture_repair_refinishing'
    | 'furriers_and_fur_shops'
    | 'general_services'
    | 'gift_card_novelty_and_souvenir_shops'
    | 'glass_paint_and_wallpaper_stores'
    | 'glassware_crystal_stores'
    | 'golf_courses_public'
    | 'government_licensed_horse_dog_racing_us_region_only'
    | 'government_licensed_online_casions_online_gambling_us_region_only'
    | 'government_owned_lotteries_non_us_region'
    | 'government_owned_lotteries_us_region_only'
    | 'government_services'
    | 'grocery_stores_supermarkets'
    | 'hardware_equipment_and_supplies'
    | 'hardware_stores'
    | 'health_and_beauty_spas'
    | 'hearing_aids_sales_and_supplies'
    | 'heating_plumbing_a_c'
    | 'hobby_toy_and_game_shops'
    | 'home_supply_warehouse_stores'
    | 'hospitals'
    | 'hotels_motels_and_resorts'
    | 'household_appliance_stores'
    | 'industrial_supplies'
    | 'information_retrieval_services'
    | 'insurance_default'
    | 'insurance_underwriting_premiums'
    | 'intra_company_purchases'
    | 'jewelry_stores_watches_clocks_and_silverware_stores'
    | 'landscaping_services'
    | 'laundries'
    | 'laundry_cleaning_services'
    | 'legal_services_attorneys'
    | 'luggage_and_leather_goods_stores'
    | 'lumber_building_materials_stores'
    | 'manual_cash_disburse'
    | 'marinas_service_and_supplies'
    | 'marketplaces'
    | 'masonry_stonework_and_plaster'
    | 'massage_parlors'
    | 'medical_and_dental_labs'
    | 'medical_dental_ophthalmic_and_hospital_equipment_and_supplies'
    | 'medical_services'
    | 'membership_organizations'
    | 'mens_and_boys_clothing_and_accessories_stores'
    | 'mens_womens_clothing_stores'
    | 'metal_service_centers'
    | 'miscellaneous'
    | 'miscellaneous_apparel_and_accessory_shops'
    | 'miscellaneous_auto_dealers'
    | 'miscellaneous_business_services'
    | 'miscellaneous_food_stores'
    | 'miscellaneous_general_merchandise'
    | 'miscellaneous_general_services'
    | 'miscellaneous_home_furnishing_specialty_stores'
    | 'miscellaneous_publishing_and_printing'
    | 'miscellaneous_recreation_services'
    | 'miscellaneous_repair_shops'
    | 'miscellaneous_specialty_retail'
    | 'mobile_home_dealers'
    | 'motion_picture_theaters'
    | 'motor_freight_carriers_and_trucking'
    | 'motor_homes_dealers'
    | 'motor_vehicle_supplies_and_new_parts'
    | 'motorcycle_shops_and_dealers'
    | 'motorcycle_shops_dealers'
    | 'music_stores_musical_instruments_pianos_and_sheet_music'
    | 'news_dealers_and_newsstands'
    | 'non_fi_money_orders'
    | 'non_fi_stored_value_card_purchase_load'
    | 'nondurable_goods'
    | 'nurseries_lawn_and_garden_supply_stores'
    | 'nursing_personal_care'
    | 'office_and_commercial_furniture'
    | 'opticians_eyeglasses'
    | 'optometrists_ophthalmologist'
    | 'orthopedic_goods_prosthetic_devices'
    | 'osteopaths'
    | 'package_stores_beer_wine_and_liquor'
    | 'paints_varnishes_and_supplies'
    | 'parking_lots_garages'
    | 'passenger_railways'
    | 'pawn_shops'
    | 'pet_shops_pet_food_and_supplies'
    | 'petroleum_and_petroleum_products'
    | 'photo_developing'
    | 'photographic_photocopy_microfilm_equipment_and_supplies'
    | 'photographic_studios'
    | 'picture_video_production'
    | 'piece_goods_notions_and_other_dry_goods'
    | 'plumbing_heating_equipment_and_supplies'
    | 'political_organizations'
    | 'postal_services_government_only'
    | 'precious_stones_and_metals_watches_and_jewelry'
    | 'professional_services'
    | 'public_warehousing_and_storage'
    | 'quick_copy_repro_and_blueprint'
    | 'railroads'
    | 'real_estate_agents_and_managers_rentals'
    | 'record_stores'
    | 'recreational_vehicle_rentals'
    | 'religious_goods_stores'
    | 'religious_organizations'
    | 'roofing_siding_sheet_metal'
    | 'secretarial_support_services'
    | 'security_brokers_dealers'
    | 'service_stations'
    | 'sewing_needlework_fabric_and_piece_goods_stores'
    | 'shoe_repair_hat_cleaning'
    | 'shoe_stores'
    | 'small_appliance_repair'
    | 'snowmobile_dealers'
    | 'special_trade_services'
    | 'specialty_cleaning'
    | 'sporting_goods_stores'
    | 'sporting_recreation_camps'
    | 'sports_and_riding_apparel_stores'
    | 'sports_clubs_fields'
    | 'stamp_and_coin_stores'
    | 'stationary_office_supplies_printing_and_writing_paper'
    | 'stationery_stores_office_and_school_supply_stores'
    | 'swimming_pools_sales'
    | 't_ui_travel_germany'
    | 'tailors_alterations'
    | 'tax_payments_government_agencies'
    | 'tax_preparation_services'
    | 'taxicabs_limousines'
    | 'telecommunication_equipment_and_telephone_sales'
    | 'telecommunication_services'
    | 'telegraph_services'
    | 'tent_and_awning_shops'
    | 'testing_laboratories'
    | 'theatrical_ticket_agencies'
    | 'timeshares'
    | 'tire_retreading_and_repair'
    | 'tolls_bridge_fees'
    | 'tourist_attractions_and_exhibits'
    | 'towing_services'
    | 'trailer_parks_campgrounds'
    | 'transportation_services'
    | 'travel_agencies_tour_operators'
    | 'truck_stop_iteration'
    | 'truck_utility_trailer_rentals'
    | 'typesetting_plate_making_and_related_services'
    | 'typewriter_stores'
    | 'u_s_federal_government_agencies_or_departments'
    | 'uniforms_commercial_clothing'
    | 'used_merchandise_and_secondhand_stores'
    | 'utilities'
    | 'variety_stores'
    | 'veterinary_services'
    | 'video_amusement_game_supplies'
    | 'video_game_arcades'
    | 'video_tape_rental_stores'
    | 'vocational_trade_schools'
    | 'watch_jewelry_repair'
    | 'welding_repair'
    | 'wholesale_clubs'
    | 'wig_and_toupee_stores'
    | 'wires_money_orders'
    | 'womens_accessory_and_specialty_shops'
    | 'womens_ready_to_wear_stores'
    | 'wrecking_and_salvage_yards'
  > | null;
  /**
   * Interval (or event) to which the amount applies.
   */
  interval: 'all_time' | 'daily' | 'monthly' | 'per_authorization' | 'weekly' | 'yearly';
};

export type issuing_cardholder_user_terms_acceptance = {
  /**
   * The Unix timestamp marking when the cardholder accepted the Authorized User Terms.
   */
  date?: number | null;
  /**
   * The IP address from which the cardholder accepted the Authorized User Terms.
   */
  ip?: string | null;
  /**
   * The user agent of the browser from which the cardholder accepted the Authorized User Terms.
   */
  user_agent?: string | null;
};

export type issuing_cardholder_verification = {
  /**
   * An identifying document, either a passport or local ID card.
   */
  document?: issuing_cardholder_id_document | null;
};

/**
 * As a [card issuer](https://stripe.com/docs/issuing), you can dispute transactions that the cardholder does not recognize, suspects to be fraudulent, or has other issues with.
 *
 * Related guide: [Issuing disputes](https://stripe.com/docs/issuing/purchases/disputes)
 */
export type issuing_dispute = {
  /**
   * Disputed amount in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). Usually the amount of the `transaction`, but can differ (usually because of currency fluctuation).
   */
  amount: number;
  /**
   * List of balance transactions associated with the dispute.
   */
  balance_transactions?: Array<balance_transaction> | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The currency the `transaction` was made in.
   */
  currency: string;
  evidence: issuing_dispute_evidence;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The enum that describes the dispute loss outcome. If the dispute is not lost, this field will be absent. New enum values may be added in the future, so be sure to handle unknown values.
   */
  loss_reason?:
    | 'cardholder_authentication_issuer_liability'
    | 'eci5_token_transaction_with_tavv'
    | 'excess_disputes_in_timeframe'
    | 'has_not_met_the_minimum_dispute_amount_requirements'
    | 'invalid_duplicate_dispute'
    | 'invalid_incorrect_amount_dispute'
    | 'invalid_no_authorization'
    | 'invalid_use_of_disputes'
    | 'merchandise_delivered_or_shipped'
    | 'merchandise_or_service_as_described'
    | 'not_cancelled'
    | 'other'
    | 'refund_issued'
    | 'submitted_beyond_allowable_time_limit'
    | 'transaction_3ds_required'
    | 'transaction_approved_after_prior_fraud_dispute'
    | 'transaction_authorized'
    | 'transaction_electronically_read'
    | 'transaction_qualifies_for_visa_easy_payment_service'
    | 'transaction_unattended';
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.dispute';
  /**
   * Current status of the dispute.
   */
  status: 'expired' | 'lost' | 'submitted' | 'unsubmitted' | 'won';
  /**
   * The transaction being disputed.
   */
  transaction: string | issuing_transaction;
  /**
   * [Treasury](https://stripe.com/docs/api/treasury) details related to this dispute if it was created on a [FinancialAccount](/docs/api/treasury/financial_accounts
   */
  treasury?: issuing_dispute_treasury | null;
};

/**
 * The enum that describes the dispute loss outcome. If the dispute is not lost, this field will be absent. New enum values may be added in the future, so be sure to handle unknown values.
 */
export type loss_reason =
  | 'cardholder_authentication_issuer_liability'
  | 'eci5_token_transaction_with_tavv'
  | 'excess_disputes_in_timeframe'
  | 'has_not_met_the_minimum_dispute_amount_requirements'
  | 'invalid_duplicate_dispute'
  | 'invalid_incorrect_amount_dispute'
  | 'invalid_no_authorization'
  | 'invalid_use_of_disputes'
  | 'merchandise_delivered_or_shipped'
  | 'merchandise_or_service_as_described'
  | 'not_cancelled'
  | 'other'
  | 'refund_issued'
  | 'submitted_beyond_allowable_time_limit'
  | 'transaction_3ds_required'
  | 'transaction_approved_after_prior_fraud_dispute'
  | 'transaction_authorized'
  | 'transaction_electronically_read'
  | 'transaction_qualifies_for_visa_easy_payment_service'
  | 'transaction_unattended';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object70 = 'issuing.dispute';

/**
 * Current status of the dispute.
 */
export type status19 = 'expired' | 'lost' | 'submitted' | 'unsubmitted' | 'won';

export type issuing_dispute_canceled_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Date when order was canceled.
   */
  canceled_at?: number | null;
  /**
   * Whether the cardholder was provided with a cancellation policy.
   */
  cancellation_policy_provided?: boolean | null;
  /**
   * Reason for canceling the order.
   */
  cancellation_reason?: string | null;
  /**
   * Date when the cardholder expected to receive the product.
   */
  expected_at?: number | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Description of the merchandise or service that was purchased.
   */
  product_description?: string | null;
  /**
   * Whether the product was a merchandise or service.
   */
  product_type?: ('merchandise' | 'service') | null;
  /**
   * Result of cardholder's attempt to return the product.
   */
  return_status?: ('merchant_rejected' | 'successful') | null;
  /**
   * Date when the product was returned or attempted to be returned.
   */
  returned_at?: number | null;
};

/**
 * Whether the product was a merchandise or service.
 */
export type product_type = 'merchandise' | 'service';

/**
 * Result of cardholder's attempt to return the product.
 */
export type return_status = 'merchant_rejected' | 'successful';

export type issuing_dispute_duplicate_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Copy of the card statement showing that the product had already been paid for.
   */
  card_statement?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Copy of the receipt showing that the product had been paid for in cash.
   */
  cash_receipt?: (string | file) | null;
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Image of the front and back of the check that was used to pay for the product.
   */
  check_image?: (string | file) | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Transaction (e.g., ipi_...) that the disputed transaction is a duplicate of. Of the two or more transactions that are copies of each other, this is original undisputed one.
   */
  original_transaction?: string | null;
};

export type issuing_dispute_evidence = {
  canceled?: issuing_dispute_canceled_evidence;
  duplicate?: issuing_dispute_duplicate_evidence;
  fraudulent?: issuing_dispute_fraudulent_evidence;
  merchandise_not_as_described?: issuing_dispute_merchandise_not_as_described_evidence;
  no_valid_authorization?: issuing_dispute_no_valid_authorization_evidence;
  not_received?: issuing_dispute_not_received_evidence;
  other?: issuing_dispute_other_evidence;
  /**
   * The reason for filing the dispute. Its value will match the field containing the evidence.
   */
  reason:
    | 'canceled'
    | 'duplicate'
    | 'fraudulent'
    | 'merchandise_not_as_described'
    | 'no_valid_authorization'
    | 'not_received'
    | 'other'
    | 'service_not_as_described';
  service_not_as_described?: issuing_dispute_service_not_as_described_evidence;
};

/**
 * The reason for filing the dispute. Its value will match the field containing the evidence.
 */
export type reason4 =
  | 'canceled'
  | 'duplicate'
  | 'fraudulent'
  | 'merchandise_not_as_described'
  | 'no_valid_authorization'
  | 'not_received'
  | 'other'
  | 'service_not_as_described';

export type issuing_dispute_fraudulent_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
};

export type issuing_dispute_merchandise_not_as_described_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Date when the product was received.
   */
  received_at?: number | null;
  /**
   * Description of the cardholder's attempt to return the product.
   */
  return_description?: string | null;
  /**
   * Result of cardholder's attempt to return the product.
   */
  return_status?: ('merchant_rejected' | 'successful') | null;
  /**
   * Date when the product was returned or attempted to be returned.
   */
  returned_at?: number | null;
};

export type issuing_dispute_no_valid_authorization_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
};

export type issuing_dispute_not_received_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Date when the cardholder expected to receive the product.
   */
  expected_at?: number | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Description of the merchandise or service that was purchased.
   */
  product_description?: string | null;
  /**
   * Whether the product was a merchandise or service.
   */
  product_type?: ('merchandise' | 'service') | null;
};

export type issuing_dispute_other_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Description of the merchandise or service that was purchased.
   */
  product_description?: string | null;
  /**
   * Whether the product was a merchandise or service.
   */
  product_type?: ('merchandise' | 'service') | null;
};

export type issuing_dispute_service_not_as_described_evidence = {
  /**
   * (ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.
   */
  additional_documentation?: (string | file) | null;
  /**
   * Date when order was canceled.
   */
  canceled_at?: number | null;
  /**
   * Reason for canceling the order.
   */
  cancellation_reason?: string | null;
  /**
   * Explanation of why the cardholder is disputing this transaction.
   */
  explanation?: string | null;
  /**
   * Date when the product was received.
   */
  received_at?: number | null;
};

export type issuing_dispute_treasury = {
  /**
   * The Treasury [DebitReversal](https://stripe.com/docs/api/treasury/debit_reversals) representing this Issuing dispute
   */
  debit_reversal?: string | null;
  /**
   * The Treasury [ReceivedDebit](https://stripe.com/docs/api/treasury/received_debits) that is being disputed.
   */
  received_debit: string;
};

export type issuing_network_token_address = {
  /**
   * The street address of the cardholder tokenizing the card.
   */
  line1: string;
  /**
   * The postal code of the cardholder tokenizing the card.
   */
  postal_code: string;
};

export type issuing_network_token_device = {
  /**
   * An obfuscated ID derived from the device ID.
   */
  device_fingerprint?: string;
  /**
   * The IP address of the device at provisioning time.
   */
  ip_address?: string;
  /**
   * The geographic latitude/longitude coordinates of the device at provisioning time. The format is [+-]decimal/[+-]decimal.
   */
  location?: string;
  /**
   * The name of the device used for tokenization.
   */
  name?: string;
  /**
   * The phone number of the device used for tokenization.
   */
  phone_number?: string;
  /**
   * The type of device used for tokenization.
   */
  type?: 'other' | 'phone' | 'watch';
};

/**
 * The type of device used for tokenization.
 */
export type type29 = 'other' | 'phone' | 'watch';

export type issuing_network_token_mastercard = {
  /**
   * A unique reference ID from MasterCard to represent the card account number.
   */
  card_reference_id?: string;
  /**
   * The network-unique identifier for the token.
   */
  token_reference_id: string;
  /**
   * The ID of the entity requesting tokenization, specific to MasterCard.
   */
  token_requestor_id: string;
  /**
   * The name of the entity requesting tokenization, if known. This is directly provided from MasterCard.
   */
  token_requestor_name?: string;
};

export type issuing_network_token_network_data = {
  device?: issuing_network_token_device;
  mastercard?: issuing_network_token_mastercard;
  /**
   * The network that the token is associated with. An additional hash is included with a name matching this value, containing tokenization data specific to the card network.
   */
  type: 'mastercard' | 'visa';
  visa?: issuing_network_token_visa;
  wallet_provider?: issuing_network_token_wallet_provider;
};

/**
 * The network that the token is associated with. An additional hash is included with a name matching this value, containing tokenization data specific to the card network.
 */
export type type30 = 'mastercard' | 'visa';

export type issuing_network_token_visa = {
  /**
   * A unique reference ID from Visa to represent the card account number.
   */
  card_reference_id: string;
  /**
   * The network-unique identifier for the token.
   */
  token_reference_id: string;
  /**
   * The ID of the entity requesting tokenization, specific to Visa.
   */
  token_requestor_id: string;
  /**
   * Degree of risk associated with the token between `01` and `99`, with higher number indicating higher risk. A `00` value indicates the token was not scored by Visa.
   */
  token_risk_score?: string;
};

export type issuing_network_token_wallet_provider = {
  /**
   * The wallet provider-given account ID of the digital wallet the token belongs to.
   */
  account_id?: string;
  /**
   * An evaluation on the trustworthiness of the wallet account between 1 and 5. A higher score indicates more trustworthy.
   */
  account_trust_score?: number;
  /**
   * The method used for tokenizing a card.
   */
  card_number_source?: 'app' | 'manual' | 'on_file' | 'other';
  cardholder_address?: issuing_network_token_address;
  /**
   * The name of the cardholder tokenizing the card.
   */
  cardholder_name?: string;
  /**
   * An evaluation on the trustworthiness of the device. A higher score indicates more trustworthy.
   */
  device_trust_score?: number;
  /**
   * The hashed email address of the cardholder's account with the wallet provider.
   */
  hashed_account_email_address?: string;
  /**
   * The reasons for suggested tokenization given by the card network.
   */
  reason_codes?: Array<
    | 'account_card_too_new'
    | 'account_recently_changed'
    | 'account_too_new'
    | 'account_too_new_since_launch'
    | 'additional_device'
    | 'data_expired'
    | 'defer_id_v_decision'
    | 'device_recently_lost'
    | 'good_activity_history'
    | 'has_suspended_tokens'
    | 'high_risk'
    | 'inactive_account'
    | 'long_account_tenure'
    | 'low_account_score'
    | 'low_device_score'
    | 'low_phone_number_score'
    | 'network_service_error'
    | 'outside_home_territory'
    | 'provisioning_cardholder_mismatch'
    | 'provisioning_device_and_cardholder_mismatch'
    | 'provisioning_device_mismatch'
    | 'same_device_no_prior_authentication'
    | 'same_device_successful_prior_authentication'
    | 'software_update'
    | 'suspicious_activity'
    | 'too_many_different_cardholders'
    | 'too_many_recent_attempts'
    | 'too_many_recent_tokens'
  >;
  /**
   * The recommendation on responding to the tokenization request.
   */
  suggested_decision?: 'approve' | 'decline' | 'require_auth';
  /**
   * The version of the standard for mapping reason codes followed by the wallet provider.
   */
  suggested_decision_version?: string;
};

/**
 * The method used for tokenizing a card.
 */
export type card_number_source = 'app' | 'manual' | 'on_file' | 'other';

/**
 * The recommendation on responding to the tokenization request.
 */
export type suggested_decision = 'approve' | 'decline' | 'require_auth';

/**
 * A Personalization Design is a logical grouping of a Physical Bundle, card logo, and carrier text that represents a product line.
 */
export type issuing_personalization_design = {
  /**
   * The file for the card logo to use with physical bundles that support card logos. Must have a `purpose` value of `issuing_logo`.
   */
  card_logo?: (string | file) | null;
  /**
   * Hash containing carrier text, for use with physical bundles that support carrier text.
   */
  carrier_text?: issuing_personalization_design_carrier_text | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A lookup key used to retrieve personalization designs dynamically from a static string. This may be up to 200 characters.
   */
  lookup_key?: string | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Friendly display name.
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.personalization_design';
  /**
   * The physical bundle object belonging to this personalization design.
   */
  physical_bundle: string | issuing_physical_bundle;
  preferences: issuing_personalization_design_preferences;
  rejection_reasons: issuing_personalization_design_rejection_reasons;
  /**
   * Whether this personalization design can be used to create cards.
   */
  status: 'active' | 'inactive' | 'rejected' | 'review';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object71 = 'issuing.personalization_design';

/**
 * Whether this personalization design can be used to create cards.
 */
export type status20 = 'active' | 'inactive' | 'rejected' | 'review';

export type issuing_personalization_design_carrier_text = {
  /**
   * The footer body text of the carrier letter.
   */
  footer_body?: string | null;
  /**
   * The footer title text of the carrier letter.
   */
  footer_title?: string | null;
  /**
   * The header body text of the carrier letter.
   */
  header_body?: string | null;
  /**
   * The header title text of the carrier letter.
   */
  header_title?: string | null;
};

export type issuing_personalization_design_preferences = {
  /**
   * Whether we use this personalization design to create cards when one isn't specified. A connected account uses the Connect platform's default design if no personalization design is set as the default design.
   */
  is_default: boolean;
  /**
   * Whether this personalization design is used to create cards when one is not specified and a default for this connected account does not exist.
   */
  is_platform_default?: boolean | null;
};

export type issuing_personalization_design_rejection_reasons = {
  /**
   * The reason(s) the card logo was rejected.
   */
  card_logo?: Array<
    | 'geographic_location'
    | 'inappropriate'
    | 'network_name'
    | 'non_binary_image'
    | 'non_fiat_currency'
    | 'other'
    | 'other_entity'
    | 'promotional_material'
  > | null;
  /**
   * The reason(s) the carrier text was rejected.
   */
  carrier_text?: Array<
    | 'geographic_location'
    | 'inappropriate'
    | 'network_name'
    | 'non_fiat_currency'
    | 'other'
    | 'other_entity'
    | 'promotional_material'
  > | null;
};

/**
 * A Physical Bundle represents the bundle of physical items - card stock, carrier letter, and envelope - that is shipped to a cardholder when you create a physical card.
 */
export type issuing_physical_bundle = {
  features: issuing_physical_bundle_features;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Friendly display name.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.physical_bundle';
  /**
   * Whether this physical bundle can be used to create cards.
   */
  status: 'active' | 'inactive' | 'review';
  /**
   * Whether this physical bundle is a standard Stripe offering or custom-made for you.
   */
  type: 'custom' | 'standard';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object72 = 'issuing.physical_bundle';

/**
 * Whether this physical bundle can be used to create cards.
 */
export type status21 = 'active' | 'inactive' | 'review';

/**
 * Whether this physical bundle is a standard Stripe offering or custom-made for you.
 */
export type type31 = 'custom' | 'standard';

export type issuing_physical_bundle_features = {
  /**
   * The policy for how to use card logo images in a card design with this physical bundle.
   */
  card_logo: 'optional' | 'required' | 'unsupported';
  /**
   * The policy for how to use carrier letter text in a card design with this physical bundle.
   */
  carrier_text: 'optional' | 'required' | 'unsupported';
  /**
   * The policy for how to use a second line on a card with this physical bundle.
   */
  second_line: 'optional' | 'required' | 'unsupported';
};

/**
 * The policy for how to use card logo images in a card design with this physical bundle.
 */
export type card_logo = 'optional' | 'required' | 'unsupported';

/**
 * The policy for how to use carrier letter text in a card design with this physical bundle.
 */
export type carrier_text = 'optional' | 'required' | 'unsupported';

/**
 * The policy for how to use a second line on a card with this physical bundle.
 */
export type second_line = 'optional' | 'required' | 'unsupported';

/**
 * When a non-stripe BIN is used, any use of an [issued card](https://stripe.com/docs/issuing) must be settled directly with the card network. The net amount owed is represented by an Issuing `Settlement` object.
 */
export type issuing_settlement = {
  /**
   * The Bank Identification Number reflecting this settlement record.
   */
  bin: string;
  /**
   * The date that the transactions are cleared and posted to user's accounts.
   */
  clearing_date: number;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The total interchange received as reimbursement for the transactions.
   */
  interchange_fees: number;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The total net amount required to settle with the network.
   */
  net_total: number;
  /**
   * The card network for this settlement report. One of ["visa"]
   */
  network: 'visa';
  /**
   * The total amount of fees owed to the network.
   */
  network_fees: number;
  /**
   * The Settlement Identification Number assigned by the network.
   */
  network_settlement_identifier: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.settlement';
  /**
   * One of `international` or `uk_national_net`.
   */
  settlement_service: string;
  /**
   * The total number of transactions reflected in this settlement.
   */
  transaction_count: number;
  /**
   * The total transaction amount reflected in this settlement.
   */
  transaction_volume: number;
};

/**
 * The card network for this settlement report. One of ["visa"]
 */
export type network3 = 'visa';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object73 = 'issuing.settlement';

/**
 * An issuing token object is created when an issued card is added to a digital wallet. As a [card issuer](https://stripe.com/docs/issuing), you can [view and manage these tokens](https://stripe.com/docs/issuing/controls/token-management) through Stripe.
 */
export type issuing_token = {
  /**
   * Card associated with this token.
   */
  card: string | issuing_card;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The hashed ID derived from the device ID from the card network associated with the token.
   */
  device_fingerprint?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The last four digits of the token.
   */
  last4?: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The token service provider / card network associated with the token.
   */
  network: 'mastercard' | 'visa';
  network_data?: issuing_network_token_network_data;
  /**
   * Time at which the token was last updated by the card network. Measured in seconds since the Unix epoch.
   */
  network_updated_at: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.token';
  /**
   * The usage state of the token.
   */
  status: 'active' | 'deleted' | 'requested' | 'suspended';
  /**
   * The digital wallet for this token, if one was used.
   */
  wallet_provider?: 'apple_pay' | 'google_pay' | 'samsung_pay';
};

/**
 * The token service provider / card network associated with the token.
 */
export type network4 = 'mastercard' | 'visa';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object74 = 'issuing.token';

/**
 * The usage state of the token.
 */
export type status22 = 'active' | 'deleted' | 'requested' | 'suspended';

/**
 * The digital wallet for this token, if one was used.
 */
export type wallet_provider = 'apple_pay' | 'google_pay' | 'samsung_pay';

/**
 * Any use of an [issued card](https://stripe.com/docs/issuing) that results in funds entering or leaving
 * your Stripe account, such as a completed purchase or refund, is represented by an Issuing
 * `Transaction` object.
 *
 * Related guide: [Issued card transactions](https://stripe.com/docs/issuing/purchases/transactions)
 */
export type issuing_transaction = {
  /**
   * The transaction amount, which will be reflected in your balance. This amount is in your currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_details?: issuing_transaction_amount_details | null;
  /**
   * The `Authorization` object that led to this transaction.
   */
  authorization?: (string | issuing_authorization) | null;
  /**
   * ID of the [balance transaction](https://stripe.com/docs/api/balance_transactions) associated with this transaction.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * The card used to make this transaction.
   */
  card: string | issuing_card;
  /**
   * The cardholder to whom this transaction belongs.
   */
  cardholder?: (string | issuing_cardholder) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * If you've disputed the transaction, the ID of the dispute.
   */
  dispute?: (string | issuing_dispute) | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The amount that the merchant will receive, denominated in `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). It will be different from `amount` if the merchant is taking payment in a different currency.
   */
  merchant_amount: number;
  /**
   * The currency with which the merchant is taking payment.
   */
  merchant_currency: string;
  merchant_data: issuing_authorization_merchant_data;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Details about the transaction, such as processing dates, set by the card network.
   */
  network_data?: issuing_transaction_network_data | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'issuing.transaction';
  /**
   * Additional purchase information that is optionally provided by the merchant.
   */
  purchase_details?: issuing_transaction_purchase_details | null;
  /**
   * [Token](https://stripe.com/docs/api/issuing/tokens/object) object used for this transaction. If a network token was not used for this transaction, this field will be null.
   */
  token?: (string | issuing_token) | null;
  /**
   * [Treasury](https://stripe.com/docs/api/treasury) details related to this transaction if it was created on a [FinancialAccount](/docs/api/treasury/financial_accounts
   */
  treasury?: issuing_transaction_treasury | null;
  /**
   * The nature of the transaction.
   */
  type: 'capture' | 'refund';
  /**
   * The digital wallet used for this transaction. One of `apple_pay`, `google_pay`, or `samsung_pay`.
   */
  wallet?: ('apple_pay' | 'google_pay' | 'samsung_pay') | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object75 = 'issuing.transaction';

/**
 * The nature of the transaction.
 */
export type type32 = 'capture' | 'refund';

/**
 * The digital wallet used for this transaction. One of `apple_pay`, `google_pay`, or `samsung_pay`.
 */
export type wallet = 'apple_pay' | 'google_pay' | 'samsung_pay';

export type issuing_transaction_amount_details = {
  /**
   * The fee charged by the ATM for the cash withdrawal.
   */
  atm_fee?: number | null;
  /**
   * The amount of cash requested by the cardholder.
   */
  cashback_amount?: number | null;
};

export type issuing_transaction_flight_data = {
  /**
   * The time that the flight departed.
   */
  departure_at?: number | null;
  /**
   * The name of the passenger.
   */
  passenger_name?: string | null;
  /**
   * Whether the ticket is refundable.
   */
  refundable?: boolean | null;
  /**
   * The legs of the trip.
   */
  segments?: Array<issuing_transaction_flight_data_leg> | null;
  /**
   * The travel agency that issued the ticket.
   */
  travel_agency?: string | null;
};

export type issuing_transaction_flight_data_leg = {
  /**
   * The three-letter IATA airport code of the flight's destination.
   */
  arrival_airport_code?: string | null;
  /**
   * The airline carrier code.
   */
  carrier?: string | null;
  /**
   * The three-letter IATA airport code that the flight departed from.
   */
  departure_airport_code?: string | null;
  /**
   * The flight number.
   */
  flight_number?: string | null;
  /**
   * The flight's service class.
   */
  service_class?: string | null;
  /**
   * Whether a stopover is allowed on this flight.
   */
  stopover_allowed?: boolean | null;
};

export type issuing_transaction_fuel_data = {
  /**
   * The type of fuel that was purchased. One of `diesel`, `unleaded_plus`, `unleaded_regular`, `unleaded_super`, or `other`.
   */
  type: string;
  /**
   * The units for `volume_decimal`. One of `liter`, `us_gallon`, or `other`.
   */
  unit: string;
  /**
   * The cost in cents per each unit of fuel, represented as a decimal string with at most 12 decimal places.
   */
  unit_cost_decimal: string;
  /**
   * The volume of the fuel that was pumped, represented as a decimal string with at most 12 decimal places.
   */
  volume_decimal?: string | null;
};

export type issuing_transaction_lodging_data = {
  /**
   * The time of checking into the lodging.
   */
  check_in_at?: number | null;
  /**
   * The number of nights stayed at the lodging.
   */
  nights?: number | null;
};

export type issuing_transaction_network_data = {
  /**
   * A code created by Stripe which is shared with the merchant to validate the authorization. This field will be populated if the authorization message was approved. The code typically starts with the letter "S", followed by a six-digit number. For example, "S498162". Please note that the code is not guaranteed to be unique across authorizations.
   */
  authorization_code?: string | null;
  /**
   * The date the transaction was processed by the card network. This can be different from the date the seller recorded the transaction depending on when the acquirer submits the transaction to the network.
   */
  processing_date?: string | null;
  /**
   * Unique identifier for the authorization assigned by the card network used to match subsequent messages, disputes, and transactions.
   */
  transaction_id?: string | null;
};

export type issuing_transaction_purchase_details = {
  /**
   * Information about the flight that was purchased with this transaction.
   */
  flight?: issuing_transaction_flight_data | null;
  /**
   * Information about fuel that was purchased with this transaction.
   */
  fuel?: issuing_transaction_fuel_data | null;
  /**
   * Information about lodging that was purchased with this transaction.
   */
  lodging?: issuing_transaction_lodging_data | null;
  /**
   * The line items in the purchase.
   */
  receipt?: Array<issuing_transaction_receipt_data> | null;
  /**
   * A merchant-specific order number.
   */
  reference?: string | null;
};

export type issuing_transaction_receipt_data = {
  /**
   * The description of the item. The maximum length of this field is 26 characters.
   */
  description?: string | null;
  /**
   * The quantity of the item.
   */
  quantity?: number | null;
  /**
   * The total for this line item in cents.
   */
  total?: number | null;
  /**
   * The unit cost of the item in cents.
   */
  unit_cost?: number | null;
};

export type issuing_transaction_treasury = {
  /**
   * The Treasury [ReceivedCredit](https://stripe.com/docs/api/treasury/received_credits) representing this Issuing transaction if it is a refund
   */
  received_credit?: string | null;
  /**
   * The Treasury [ReceivedDebit](https://stripe.com/docs/api/treasury/received_debits) representing this Issuing transaction if it is a capture
   */
  received_debit?: string | null;
};

/**
 * A line item.
 */
export type item = {
  /**
   * Total discount amount applied. If no discounts were applied, defaults to 0.
   */
  amount_discount: number;
  /**
   * Total before any discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total tax amount applied. If no tax was applied, defaults to 0.
   */
  amount_tax: number;
  /**
   * Total after discounts and taxes.
   */
  amount_total: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users. Defaults to product name.
   */
  description: string;
  /**
   * The discounts applied to the line item.
   */
  discounts?: Array<line_items_discount_amount>;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'item';
  /**
   * The price used to generate the line item.
   */
  price?: price | null;
  /**
   * The quantity of products being purchased.
   */
  quantity?: number | null;
  /**
   * The taxes applied to the line item.
   */
  taxes?: Array<line_items_tax_amount>;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object76 = 'item';

export type legal_entity_company = {
  address?: address;
  /**
   * The Kana variation of the company's primary address (Japan only).
   */
  address_kana?: legal_entity_japan_address | null;
  /**
   * The Kanji variation of the company's primary address (Japan only).
   */
  address_kanji?: legal_entity_japan_address | null;
  /**
   * Whether the company's directors have been provided. This Boolean will be `true` if you've manually indicated that all directors are provided via [the `directors_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-directors_provided).
   */
  directors_provided?: boolean;
  /**
   * Whether the company's executives have been provided. This Boolean will be `true` if you've manually indicated that all executives are provided via [the `executives_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-executives_provided), or if Stripe determined that sufficient executives were provided.
   */
  executives_provided?: boolean;
  /**
   * The export license ID number of the company, also referred as Import Export Code (India only).
   */
  export_license_id?: string;
  /**
   * The purpose code to use for export transactions (India only).
   */
  export_purpose_code?: string;
  /**
   * The company's legal name.
   */
  name?: string | null;
  /**
   * The Kana variation of the company's legal name (Japan only).
   */
  name_kana?: string | null;
  /**
   * The Kanji variation of the company's legal name (Japan only).
   */
  name_kanji?: string | null;
  /**
   * Whether the company's owners have been provided. This Boolean will be `true` if you've manually indicated that all owners are provided via [the `owners_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-owners_provided), or if Stripe determined that sufficient owners were provided. Stripe determines ownership requirements using both the number of owners provided and their total percent ownership (calculated by adding the `percent_ownership` of each owner together).
   */
  owners_provided?: boolean;
  /**
   * This hash is used to attest that the beneficial owner information provided to Stripe is both current and correct.
   */
  ownership_declaration?: legal_entity_ubo_declaration | null;
  /**
   * The company's phone number (used for verification).
   */
  phone?: string | null;
  /**
   * The category identifying the legal structure of the company or legal entity. See [Business structure](https://stripe.com/docs/connect/identity-verification#business-structure) for more details.
   */
  structure?:
    | 'free_zone_establishment'
    | 'free_zone_llc'
    | 'government_instrumentality'
    | 'governmental_unit'
    | 'incorporated_non_profit'
    | 'incorporated_partnership'
    | 'limited_liability_partnership'
    | 'llc'
    | 'multi_member_llc'
    | 'private_company'
    | 'private_corporation'
    | 'private_partnership'
    | 'public_company'
    | 'public_corporation'
    | 'public_partnership'
    | 'registered_charity'
    | 'single_member_llc'
    | 'sole_establishment'
    | 'sole_proprietorship'
    | 'tax_exempt_government_instrumentality'
    | 'unincorporated_association'
    | 'unincorporated_non_profit'
    | 'unincorporated_partnership';
  /**
   * Whether the company's business ID number was provided.
   */
  tax_id_provided?: boolean;
  /**
   * The jurisdiction in which the `tax_id` is registered (Germany-based companies only).
   */
  tax_id_registrar?: string;
  /**
   * Whether the company's business VAT number was provided.
   */
  vat_id_provided?: boolean;
  /**
   * Information on the verification state of the company.
   */
  verification?: legal_entity_company_verification | null;
};

/**
 * The category identifying the legal structure of the company or legal entity. See [Business structure](https://stripe.com/docs/connect/identity-verification#business-structure) for more details.
 */
export type structure =
  | 'free_zone_establishment'
  | 'free_zone_llc'
  | 'government_instrumentality'
  | 'governmental_unit'
  | 'incorporated_non_profit'
  | 'incorporated_partnership'
  | 'limited_liability_partnership'
  | 'llc'
  | 'multi_member_llc'
  | 'private_company'
  | 'private_corporation'
  | 'private_partnership'
  | 'public_company'
  | 'public_corporation'
  | 'public_partnership'
  | 'registered_charity'
  | 'single_member_llc'
  | 'sole_establishment'
  | 'sole_proprietorship'
  | 'tax_exempt_government_instrumentality'
  | 'unincorporated_association'
  | 'unincorporated_non_profit'
  | 'unincorporated_partnership';

export type legal_entity_company_verification = {
  document: legal_entity_company_verification_document;
};

export type legal_entity_company_verification_document = {
  /**
   * The back of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `additional_verification`.
   */
  back?: (string | file) | null;
  /**
   * A user-displayable string describing the verification state of this document.
   */
  details?: string | null;
  /**
   * One of `document_corrupt`, `document_expired`, `document_failed_copy`, `document_failed_greyscale`, `document_failed_other`, `document_failed_test_mode`, `document_fraudulent`, `document_incomplete`, `document_invalid`, `document_manipulated`, `document_not_readable`, `document_not_uploaded`, `document_type_not_supported`, or `document_too_large`. A machine-readable code specifying the verification state for this document.
   */
  details_code?: string | null;
  /**
   * The front of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `additional_verification`.
   */
  front?: (string | file) | null;
};

export type legal_entity_dob = {
  /**
   * The day of birth, between 1 and 31.
   */
  day?: number | null;
  /**
   * The month of birth, between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year of birth.
   */
  year?: number | null;
};

export type legal_entity_japan_address = {
  /**
   * City/Ward.
   */
  city?: string | null;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country?: string | null;
  /**
   * Block/Building number.
   */
  line1?: string | null;
  /**
   * Building details.
   */
  line2?: string | null;
  /**
   * ZIP or postal code.
   */
  postal_code?: string | null;
  /**
   * Prefecture.
   */
  state?: string | null;
  /**
   * Town/cho-me.
   */
  town?: string | null;
};

export type legal_entity_person_verification = {
  /**
   * A document showing address, either a passport, local ID card, or utility bill from a well-known utility company.
   */
  additional_document?: legal_entity_person_verification_document | null;
  /**
   * A user-displayable string describing the verification state for the person. For example, this may say "Provided identity information could not be verified".
   */
  details?: string | null;
  /**
   * One of `document_address_mismatch`, `document_dob_mismatch`, `document_duplicate_type`, `document_id_number_mismatch`, `document_name_mismatch`, `document_nationality_mismatch`, `failed_keyed_identity`, or `failed_other`. A machine-readable code specifying the verification state for the person.
   */
  details_code?: string | null;
  document?: legal_entity_person_verification_document;
  /**
   * The state of verification for the person. Possible values are `unverified`, `pending`, or `verified`.
   */
  status: string;
};

export type legal_entity_person_verification_document = {
  /**
   * The back of an ID returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.
   */
  back?: (string | file) | null;
  /**
   * A user-displayable string describing the verification state of this document. For example, if a document is uploaded and the picture is too fuzzy, this may say "Identity document is too unclear to read".
   */
  details?: string | null;
  /**
   * One of `document_corrupt`, `document_country_not_supported`, `document_expired`, `document_failed_copy`, `document_failed_other`, `document_failed_test_mode`, `document_fraudulent`, `document_failed_greyscale`, `document_incomplete`, `document_invalid`, `document_manipulated`, `document_missing_back`, `document_missing_front`, `document_not_readable`, `document_not_uploaded`, `document_photo_mismatch`, `document_too_large`, or `document_type_not_supported`. A machine-readable code specifying the verification state for this document.
   */
  details_code?: string | null;
  /**
   * The front of an ID returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.
   */
  front?: (string | file) | null;
};

export type legal_entity_ubo_declaration = {
  /**
   * The Unix timestamp marking when the beneficial owner attestation was made.
   */
  date?: number | null;
  /**
   * The IP address from which the beneficial owner attestation was made.
   */
  ip?: string | null;
  /**
   * The user-agent string from the browser where the beneficial owner attestation was made.
   */
  user_agent?: string | null;
};

export type line_item = {
  /**
   * The amount, in cents (or local equivalent).
   */
  amount: number;
  /**
   * The integer amount in cents (or local equivalent) representing the amount for this line item, excluding all tax and discounts.
   */
  amount_excluding_tax?: number | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * The amount of discount calculated per discount for this line item.
   */
  discount_amounts?: Array<discounts_resource_discount_amount> | null;
  /**
   * If true, discounts will apply to this line item. Always false for prorations.
   */
  discountable: boolean;
  /**
   * The discounts applied to the invoice line item. Line item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts: Array<string | discount>;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The ID of the invoice that contains this line item.
   */
  invoice?: string | null;
  /**
   * The ID of the [invoice item](https://stripe.com/docs/api/invoiceitems) associated with this line item if any.
   */
  invoice_item?: string | invoiceitem;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Note that for line items with `type=subscription`, `metadata` reflects the current metadata from the subscription associated with the line item, unless the invoice line was directly updated with different metadata after creation.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'line_item';
  period: invoice_line_item_period;
  /**
   * The price of the line item.
   */
  price?: price | null;
  /**
   * Whether this is a proration.
   */
  proration: boolean;
  /**
   * Additional details for proration line items
   */
  proration_details?: invoices_resource_line_items_proration_details | null;
  /**
   * The quantity of the subscription, if the line item is a subscription or a proration.
   */
  quantity?: number | null;
  /**
   * The subscription that the invoice item pertains to, if any.
   */
  subscription?: (string | subscription) | null;
  /**
   * The subscription item that generated this line item. Left empty if the line item is not an explicit result of a subscription.
   */
  subscription_item?: string | subscription_item;
  /**
   * The amount of tax calculated per tax rate for this line item
   */
  tax_amounts?: Array<invoice_tax_amount>;
  /**
   * The tax rates which apply to the line item.
   */
  tax_rates?: Array<tax_rate>;
  /**
   * A string identifying the type of the source of this line item, either an `invoiceitem` or a `subscription`.
   */
  type: 'invoiceitem' | 'subscription';
  /**
   * The amount in cents (or local equivalent) representing the unit amount for this line item, excluding all tax and discounts.
   */
  unit_amount_excluding_tax?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object77 = 'line_item';

/**
 * A string identifying the type of the source of this line item, either an `invoiceitem` or a `subscription`.
 */
export type type33 = 'invoiceitem' | 'subscription';

export type line_items_discount_amount = {
  /**
   * The amount discounted.
   */
  amount: number;
  discount: discount;
};

export type line_items_tax_amount = {
  /**
   * Amount of tax applied for this rate.
   */
  amount: number;
  rate: tax_rate;
  /**
   * The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.
   */
  taxability_reason?:
    | (
        | 'customer_exempt'
        | 'not_collecting'
        | 'not_subject_to_tax'
        | 'not_supported'
        | 'portion_product_exempt'
        | 'portion_reduced_rated'
        | 'portion_standard_rated'
        | 'product_exempt'
        | 'product_exempt_holiday'
        | 'proportionally_rated'
        | 'reduced_rated'
        | 'reverse_charge'
        | 'standard_rated'
        | 'taxable_basis_reduced'
        | 'zero_rated'
      )
    | null;
  /**
   * The amount on which tax is calculated, in cents (or local equivalent).
   */
  taxable_amount?: number | null;
};

export type linked_account_options_us_bank_account = {
  /**
   * The list of permissions to request. The `payment_method` permission must be included.
   */
  permissions?: Array<'balances' | 'ownership' | 'payment_method' | 'transactions'>;
  /**
   * Data features requested to be retrieved upon account creation.
   */
  prefetch?: Array<'balances' | 'ownership' | 'transactions'> | null;
  /**
   * For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.
   */
  return_url?: string;
};

/**
 * Login Links are single-use URLs for a connected account to access the Express Dashboard. The connected account's [account.controller.stripe_dashboard.type](/api/accounts/object#account_object-controller-stripe_dashboard-type) must be `express` to have access to the Express Dashboard.
 */
export type login_link = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'login_link';
  /**
   * The URL for the login link.
   */
  url: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object78 = 'login_link';

/**
 * A Mandate is a record of the permission that your customer gives you to debit their payment method.
 */
export type mandate = {
  customer_acceptance: customer_acceptance;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  multi_use?: mandate_multi_use;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'mandate';
  /**
   * The account (if any) that the mandate is intended for.
   */
  on_behalf_of?: string;
  /**
   * ID of the payment method associated with this mandate.
   */
  payment_method: string | payment_method;
  payment_method_details: mandate_payment_method_details;
  single_use?: mandate_single_use;
  /**
   * The mandate status indicates whether or not you can use it to initiate a payment.
   */
  status: 'active' | 'inactive' | 'pending';
  /**
   * The type of the mandate.
   */
  type: 'multi_use' | 'single_use';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object79 = 'mandate';

/**
 * The mandate status indicates whether or not you can use it to initiate a payment.
 */
export type status23 = 'active' | 'inactive' | 'pending';

/**
 * The type of the mandate.
 */
export type type34 = 'multi_use' | 'single_use';

export type mandate_acss_debit = {
  /**
   * List of Stripe products where this mandate can be selected automatically.
   */
  default_for?: Array<'invoice' | 'subscription'>;
  /**
   * Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
   */
  interval_description?: string | null;
  /**
   * Payment schedule for the mandate.
   */
  payment_schedule: 'combined' | 'interval' | 'sporadic';
  /**
   * Transaction type of the mandate.
   */
  transaction_type: 'business' | 'personal';
};

export type mandate_amazon_pay = {
  [key: string]: unknown;
};

export type mandate_au_becs_debit = {
  /**
   * The URL of the mandate. This URL generally contains sensitive information about the customer and should be shared with them exclusively.
   */
  url: string;
};

export type mandate_bacs_debit = {
  /**
   * The status of the mandate on the Bacs network. Can be one of `pending`, `revoked`, `refused`, or `accepted`.
   */
  network_status: 'accepted' | 'pending' | 'refused' | 'revoked';
  /**
   * The unique reference identifying the mandate on the Bacs network.
   */
  reference: string;
  /**
   * When the mandate is revoked on the Bacs network this field displays the reason for the revocation.
   */
  revocation_reason?:
    | (
        | 'account_closed'
        | 'bank_account_restricted'
        | 'bank_ownership_changed'
        | 'could_not_process'
        | 'debit_not_authorized'
      )
    | null;
  /**
   * The URL that will contain the mandate that the customer has signed.
   */
  url: string;
};

/**
 * The status of the mandate on the Bacs network. Can be one of `pending`, `revoked`, `refused`, or `accepted`.
 */
export type network_status = 'accepted' | 'pending' | 'refused' | 'revoked';

/**
 * When the mandate is revoked on the Bacs network this field displays the reason for the revocation.
 */
export type revocation_reason =
  | 'account_closed'
  | 'bank_account_restricted'
  | 'bank_ownership_changed'
  | 'could_not_process'
  | 'debit_not_authorized';

export type mandate_cashapp = {
  [key: string]: unknown;
};

export type mandate_link = {
  [key: string]: unknown;
};

export type mandate_multi_use = {
  [key: string]: unknown;
};

export type mandate_payment_method_details = {
  acss_debit?: mandate_acss_debit;
  amazon_pay?: mandate_amazon_pay;
  au_becs_debit?: mandate_au_becs_debit;
  bacs_debit?: mandate_bacs_debit;
  card?: card_mandate_payment_method_details;
  cashapp?: mandate_cashapp;
  link?: mandate_link;
  paypal?: mandate_paypal;
  revolut_pay?: mandate_revolut_pay;
  sepa_debit?: mandate_sepa_debit;
  /**
   * This mandate corresponds with a specific payment method type. The `payment_method_details` includes an additional hash with the same name and contains mandate information that's specific to that payment method.
   */
  type: string;
  us_bank_account?: mandate_us_bank_account;
};

export type mandate_paypal = {
  /**
   * The PayPal Billing Agreement ID (BAID). This is an ID generated by PayPal which represents the mandate between the merchant and the customer.
   */
  billing_agreement_id?: string | null;
  /**
   * PayPal account PayerID. This identifier uniquely identifies the PayPal customer.
   */
  payer_id?: string | null;
};

export type mandate_revolut_pay = {
  [key: string]: unknown;
};

export type mandate_sepa_debit = {
  /**
   * The unique reference of the mandate.
   */
  reference: string;
  /**
   * The URL of the mandate. This URL generally contains sensitive information about the customer and should be shared with them exclusively.
   */
  url: string;
};

export type mandate_single_use = {
  /**
   * The amount of the payment on a single use mandate.
   */
  amount: number;
  /**
   * The currency of the payment on a single use mandate.
   */
  currency: string;
};

export type mandate_us_bank_account = {
  /**
   * Mandate collection method
   */
  collection_method?: 'paper';
};

/**
 * Mandate collection method
 */
export type collection_method2 = 'paper';

export type networks = {
  /**
   * All available networks for the card.
   */
  available: Array<string>;
  /**
   * The preferred network for co-branded cards. Can be `cartes_bancaires`, `mastercard`, `visa` or `invalid_preference` if requested network is not valid for the card.
   */
  preferred?: string | null;
};

export type notification_event_data = {
  /**
   * Object containing the API resource relevant to the event. For example, an `invoice.created` event will have a full [invoice object](https://stripe.com/docs/api#invoice_object) as the value of the object key.
   */
  object: {
    [key: string]: unknown;
  };
  /**
   * Object containing the names of the updated attributes and their values prior to the event (only included in events of type `*.updated`). If an array attribute has any updated elements, this object contains the entire array. In Stripe API versions 2017-04-06 or earlier, an updated array attribute in this object includes only the updated array elements.
   */
  previous_attributes?: {
    [key: string]: unknown;
  };
};

export type notification_event_request = {
  /**
   * ID of the API request that caused the event. If null, the event was automatic (e.g., Stripe's automatic subscription handling). Request logs are available in the [dashboard](https://dashboard.stripe.com/logs), but currently not in the API.
   */
  id?: string | null;
  /**
   * The idempotency key transmitted during the request, if any. *Note: This property is populated only for events on or after May 23, 2017*.
   */
  idempotency_key?: string | null;
};

export type offline_acceptance = {
  [key: string]: unknown;
};

export type online_acceptance = {
  /**
   * The customer accepts the mandate from this IP address.
   */
  ip_address?: string | null;
  /**
   * The customer accepts the mandate using the user agent of the browser.
   */
  user_agent?: string | null;
};

export type outbound_payments_payment_method_details = {
  billing_details: treasury_shared_resource_billing_details;
  financial_account?: outbound_payments_payment_method_details_financial_account;
  /**
   * The type of the payment method used in the OutboundPayment.
   */
  type: 'financial_account' | 'us_bank_account';
  us_bank_account?: outbound_payments_payment_method_details_us_bank_account;
};

/**
 * The type of the payment method used in the OutboundPayment.
 */
export type type35 = 'financial_account' | 'us_bank_account';

export type outbound_payments_payment_method_details_financial_account = {
  /**
   * Token of the FinancialAccount.
   */
  id: string;
  /**
   * The rails used to send funds.
   */
  network: 'stripe';
};

/**
 * The rails used to send funds.
 */
export type network5 = 'stripe';

export type outbound_payments_payment_method_details_us_bank_account = {
  /**
   * Account holder type: individual or company.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Account type: checkings or savings. Defaults to checking if omitted.
   */
  account_type?: ('checking' | 'savings') | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string | mandate;
  /**
   * The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.
   */
  network: 'ach' | 'us_domestic_wire';
  /**
   * Routing number of the bank account.
   */
  routing_number?: string | null;
};

/**
 * The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.
 */
export type network6 = 'ach' | 'us_domestic_wire';

export type outbound_transfers_payment_method_details = {
  billing_details: treasury_shared_resource_billing_details;
  /**
   * The type of the payment method used in the OutboundTransfer.
   */
  type: 'us_bank_account';
  us_bank_account?: outbound_transfers_payment_method_details_us_bank_account;
};

export type outbound_transfers_payment_method_details_us_bank_account = {
  /**
   * Account holder type: individual or company.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Account type: checkings or savings. Defaults to checking if omitted.
   */
  account_type?: ('checking' | 'savings') | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string | mandate;
  /**
   * The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.
   */
  network: 'ach' | 'us_domestic_wire';
  /**
   * Routing number of the bank account.
   */
  routing_number?: string | null;
};

export type package_dimensions = {
  /**
   * Height, in inches.
   */
  height: number;
  /**
   * Length, in inches.
   */
  length: number;
  /**
   * Weight, in ounces.
   */
  weight: number;
  /**
   * Width, in inches.
   */
  width: number;
};

export type payment_flows_amount_details = {
  tip?: payment_flows_amount_details_resource_tip;
};

export type payment_flows_amount_details_resource_tip = {
  /**
   * Portion of the amount that corresponds to a tip.
   */
  amount?: number;
};

export type payment_flows_automatic_payment_methods_payment_intent = {
  /**
   * Controls whether this PaymentIntent will accept redirect-based payment methods.
   *
   * Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the payment.
   */
  allow_redirects?: 'always' | 'never';
  /**
   * Automatically calculates compatible payment methods
   */
  enabled: boolean;
};

/**
 * Controls whether this PaymentIntent will accept redirect-based payment methods.
 *
 * Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the payment.
 */
export type allow_redirects = 'always' | 'never';

export type payment_flows_automatic_payment_methods_setup_intent = {
  /**
   * Controls whether this SetupIntent will accept redirect-based payment methods.
   *
   * Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/setup_intents/confirm) this SetupIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the setup.
   */
  allow_redirects?: 'always' | 'never';
  /**
   * Automatically calculates compatible payment methods
   */
  enabled?: boolean | null;
};

export type payment_flows_installment_options = {
  enabled: boolean;
  plan?: payment_method_details_card_installments_plan;
};

export type payment_flows_private_payment_methods_alipay = {
  [key: string]: unknown;
};

export type payment_flows_private_payment_methods_alipay_details = {
  /**
   * Uniquely identifies this particular Alipay account. You can use this attribute to check whether two Alipay accounts are the same.
   */
  buyer_id?: string;
  /**
   * Uniquely identifies this particular Alipay account. You can use this attribute to check whether two Alipay accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Transaction ID of this particular Alipay transaction.
   */
  transaction_id?: string | null;
};

export type payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_extended_authorization_extended_authorization =
  {
    /**
     * Indicates whether or not the capture window is extended beyond the standard authorization.
     */
    status: 'disabled' | 'enabled';
  };

/**
 * Indicates whether or not the capture window is extended beyond the standard authorization.
 */
export type status24 = 'disabled' | 'enabled';

export type payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_incremental_authorization_incremental_authorization =
  {
    /**
     * Indicates whether or not the incremental authorization feature is supported.
     */
    status: 'available' | 'unavailable';
  };

/**
 * Indicates whether or not the incremental authorization feature is supported.
 */
export type status25 = 'available' | 'unavailable';

export type payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_overcapture_overcapture =
  {
    /**
     * The maximum amount that can be captured.
     */
    maximum_amount_capturable: number;
    /**
     * Indicates whether or not the authorized amount can be over-captured.
     */
    status: 'available' | 'unavailable';
  };

export type payment_flows_private_payment_methods_card_details_api_resource_multicapture = {
  /**
   * Indicates whether or not multiple captures are supported.
   */
  status: 'available' | 'unavailable';
};

export type payment_flows_private_payment_methods_klarna_dob = {
  /**
   * The day of birth, between 1 and 31.
   */
  day?: number | null;
  /**
   * The month of birth, between 1 and 12.
   */
  month?: number | null;
  /**
   * The four-digit year of birth.
   */
  year?: number | null;
};

/**
 * A PaymentIntent guides you through the process of collecting a payment from your customer.
 * We recommend that you create exactly one PaymentIntent for each order or
 * customer session in your system. You can reference the PaymentIntent later to
 * see the history of payment attempts for a particular session.
 *
 * A PaymentIntent transitions through
 * [multiple statuses](https://stripe.com/docs/payments/intents#intent-statuses)
 * throughout its lifetime as it interfaces with Stripe.js to perform
 * authentication flows and ultimately creates at most one successful charge.
 *
 * Related guide: [Payment Intents API](https://stripe.com/docs/payments/payment-intents)
 */
export type payment_intent = {
  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
   */
  amount: number;
  /**
   * Amount that can be captured from this PaymentIntent.
   */
  amount_capturable?: number;
  amount_details?: payment_flows_amount_details;
  /**
   * Amount that this PaymentIntent collects.
   */
  amount_received?: number;
  /**
   * ID of the Connect application that created the PaymentIntent.
   */
  application?: (string | application) | null;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
   */
  application_fee_amount?: number | null;
  /**
   * Settings to configure compatible payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods)
   */
  automatic_payment_methods?: payment_flows_automatic_payment_methods_payment_intent | null;
  /**
   * Populated when `status` is `canceled`, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.
   */
  canceled_at?: number | null;
  /**
   * Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).
   */
  cancellation_reason?:
    | (
        | 'abandoned'
        | 'automatic'
        | 'duplicate'
        | 'failed_invoice'
        | 'fraudulent'
        | 'requested_by_customer'
        | 'void_invoice'
      )
    | null;
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method: 'automatic' | 'automatic_async' | 'manual';
  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key.
   *
   * The client secret can be used to complete a payment from your frontend. It should not be stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.
   *
   * Refer to our docs to [accept a payment](https://stripe.com/docs/payments/accept-a-payment?ui=elements) and learn about how `client_secret` should be handled.
   */
  client_secret?: string | null;
  /**
   * Describes whether we can confirm this PaymentIntent automatically, or if it requires customer action to confirm the payment.
   */
  confirmation_method: 'automatic' | 'manual';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the Customer this PaymentIntent belongs to, if one exists.
   *
   * Payment methods attached to other Customers cannot be used with this PaymentIntent.
   *
   * If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * ID of the invoice that created this PaymentIntent, if it exists.
   */
  invoice?: (string | invoice) | null;
  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason.
   */
  last_payment_error?: api_errors | null;
  /**
   * The latest charge created by this PaymentIntent.
   */
  latest_charge?: (string | charge) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Learn more about [storing information in metadata](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
   */
  metadata?: {
    [key: string]: string;
  };
  /**
   * If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.
   */
  next_action?: payment_intent_next_action | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payment_intent';
  /**
   * The account (if any) for which the funds of the PaymentIntent are intended. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * ID of the payment method used in this PaymentIntent.
   */
  payment_method?: (string | payment_method) | null;
  /**
   * Information about the payment method configuration used for this PaymentIntent.
   */
  payment_method_configuration_details?: payment_method_config_biz_payment_method_configuration_details | null;
  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  payment_method_options?: payment_intent_payment_method_options | null;
  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  payment_method_types: Array<string>;
  /**
   * If present, this property tells you about the processing state of the payment.
   */
  processing?: payment_intent_processing | null;
  /**
   * Email address that the receipt for the resulting payment will be sent to. If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
   */
  receipt_email?: string | null;
  /**
   * ID of the review associated with this PaymentIntent, if any.
   */
  review?: (string | review) | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: ('off_session' | 'on_session') | null;
  /**
   * Shipping information for this PaymentIntent.
   */
  shipping?: shipping | null;
  /**
   * For card charges, use [statement_descriptor_suffix](https://stripe.com/docs/payments/account/statement-descriptors#dynamic). Otherwise, you can use this value as the complete description of a charge on your customers' statements. It must contain at least one letter and be 1–22 characters long.
   */
  statement_descriptor?: string | null;
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  statement_descriptor_suffix?: string | null;
  /**
   * Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).
   */
  status:
    | 'canceled'
    | 'processing'
    | 'requires_action'
    | 'requires_capture'
    | 'requires_confirmation'
    | 'requires_payment_method'
    | 'succeeded';
  /**
   * The data that automatically creates a Transfer after the payment finalizes. Learn more about the [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
   */
  transfer_data?: transfer_data | null;
  /**
   * A string that identifies the resulting payment as part of a group. Learn more about the [use case for connected accounts](https://stripe.com/docs/connect/separate-charges-and-transfers).
   */
  transfer_group?: string | null;
};

/**
 * Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).
 */
export type cancellation_reason3 =
  | 'abandoned'
  | 'automatic'
  | 'duplicate'
  | 'failed_invoice'
  | 'fraudulent'
  | 'requested_by_customer'
  | 'void_invoice';

/**
 * Controls when the funds will be captured from the customer's account.
 */
export type capture_method2 = 'automatic' | 'automatic_async' | 'manual';

/**
 * Describes whether we can confirm this PaymentIntent automatically, or if it requires customer action to confirm the payment.
 */
export type confirmation_method = 'automatic' | 'manual';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object80 = 'payment_intent';

/**
 * Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).
 */
export type status26 =
  | 'canceled'
  | 'processing'
  | 'requires_action'
  | 'requires_capture'
  | 'requires_confirmation'
  | 'requires_payment_method'
  | 'succeeded';

export type payment_intent_card_processing = {
  customer_notification?: payment_intent_processing_customer_notification;
};

export type payment_intent_next_action = {
  alipay_handle_redirect?: payment_intent_next_action_alipay_handle_redirect;
  boleto_display_details?: payment_intent_next_action_boleto;
  card_await_notification?: payment_intent_next_action_card_await_notification;
  cashapp_handle_redirect_or_display_qr_code?: payment_intent_next_action_cashapp_handle_redirect_or_display_qr_code;
  display_bank_transfer_instructions?: payment_intent_next_action_display_bank_transfer_instructions;
  konbini_display_details?: payment_intent_next_action_konbini;
  multibanco_display_details?: payment_intent_next_action_display_multibanco_details;
  oxxo_display_details?: payment_intent_next_action_display_oxxo_details;
  paynow_display_qr_code?: payment_intent_next_action_paynow_display_qr_code;
  pix_display_qr_code?: payment_intent_next_action_pix_display_qr_code;
  promptpay_display_qr_code?: payment_intent_next_action_promptpay_display_qr_code;
  redirect_to_url?: payment_intent_next_action_redirect_to_url;
  swish_handle_redirect_or_display_qr_code?: payment_intent_next_action_swish_handle_redirect_or_display_qr_code;
  /**
   * Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.
   */
  type: string;
  /**
   * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.
   */
  use_stripe_sdk?: {
    [key: string]: unknown;
  };
  verify_with_microdeposits?: payment_intent_next_action_verify_with_microdeposits;
  wechat_pay_display_qr_code?: payment_intent_next_action_wechat_pay_display_qr_code;
  wechat_pay_redirect_to_android_app?: payment_intent_next_action_wechat_pay_redirect_to_android_app;
  wechat_pay_redirect_to_ios_app?: payment_intent_next_action_wechat_pay_redirect_to_ios_app;
};

export type payment_intent_next_action_alipay_handle_redirect = {
  /**
   * The native data to be used with Alipay SDK you must redirect your customer to in order to authenticate the payment in an Android App.
   */
  native_data?: string | null;
  /**
   * The native URL you must redirect your customer to in order to authenticate the payment in an iOS App.
   */
  native_url?: string | null;
  /**
   * If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
   */
  return_url?: string | null;
  /**
   * The URL you must redirect your customer to in order to authenticate the payment.
   */
  url?: string | null;
};

export type payment_intent_next_action_boleto = {
  /**
   * The timestamp after which the boleto expires.
   */
  expires_at?: number | null;
  /**
   * The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
   */
  hosted_voucher_url?: string | null;
  /**
   * The boleto number.
   */
  number?: string | null;
  /**
   * The URL to the downloadable boleto voucher PDF.
   */
  pdf?: string | null;
};

export type payment_intent_next_action_card_await_notification = {
  /**
   * The time that payment will be attempted. If customer approval is required, they need to provide approval before this time.
   */
  charge_attempt_at?: number | null;
  /**
   * For payments greater than INR 15000, the customer must provide explicit approval of the payment with their bank. For payments of lower amount, no customer action is required.
   */
  customer_approval_required?: boolean | null;
};

export type payment_intent_next_action_cashapp_handle_redirect_or_display_qr_code = {
  /**
   * The URL to the hosted Cash App Pay instructions page, which allows customers to view the QR code, and supports QR code refreshing on expiration.
   */
  hosted_instructions_url: string;
  /**
   * The url for mobile redirect based auth
   */
  mobile_auth_url: string;
  qr_code: payment_intent_next_action_cashapp_qr_code;
};

export type payment_intent_next_action_cashapp_qr_code = {
  /**
   * The date (unix timestamp) when the QR code expires.
   */
  expires_at: number;
  /**
   * The image_url_png string used to render QR code
   */
  image_url_png: string;
  /**
   * The image_url_svg string used to render QR code
   */
  image_url_svg: string;
};

export type payment_intent_next_action_display_bank_transfer_instructions = {
  /**
   * The remaining amount that needs to be transferred to complete the payment.
   */
  amount_remaining?: number | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency?: string | null;
  /**
   * A list of financial addresses that can be used to fund the customer balance
   */
  financial_addresses?: Array<funding_instructions_bank_transfer_financial_address>;
  /**
   * A link to a hosted page that guides your customer through completing the transfer.
   */
  hosted_instructions_url?: string | null;
  /**
   * A string identifying this payment. Instruct your customer to include this code in the reference or memo field of their bank transfer.
   */
  reference?: string | null;
  /**
   * Type of bank transfer
   */
  type: 'eu_bank_transfer' | 'gb_bank_transfer' | 'jp_bank_transfer' | 'mx_bank_transfer' | 'us_bank_transfer';
};

export type payment_intent_next_action_display_multibanco_details = {
  /**
   * Entity number associated with this Multibanco payment.
   */
  entity?: string | null;
  /**
   * The timestamp at which the Multibanco voucher expires.
   */
  expires_at?: number | null;
  /**
   * The URL for the hosted Multibanco voucher page, which allows customers to view a Multibanco voucher.
   */
  hosted_voucher_url?: string | null;
  /**
   * Reference number associated with this Multibanco payment.
   */
  reference?: string | null;
};

export type payment_intent_next_action_display_oxxo_details = {
  /**
   * The timestamp after which the OXXO voucher expires.
   */
  expires_after?: number | null;
  /**
   * The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO voucher.
   */
  hosted_voucher_url?: string | null;
  /**
   * OXXO reference number.
   */
  number?: string | null;
};

export type payment_intent_next_action_konbini = {
  /**
   * The timestamp at which the pending Konbini payment expires.
   */
  expires_at: number;
  /**
   * The URL for the Konbini payment instructions page, which allows customers to view and print a Konbini voucher.
   */
  hosted_voucher_url?: string | null;
  stores: payment_intent_next_action_konbini_stores;
};

export type payment_intent_next_action_konbini_familymart = {
  /**
   * The confirmation number.
   */
  confirmation_number?: string;
  /**
   * The payment code.
   */
  payment_code: string;
};

export type payment_intent_next_action_konbini_lawson = {
  /**
   * The confirmation number.
   */
  confirmation_number?: string;
  /**
   * The payment code.
   */
  payment_code: string;
};

export type payment_intent_next_action_konbini_ministop = {
  /**
   * The confirmation number.
   */
  confirmation_number?: string;
  /**
   * The payment code.
   */
  payment_code: string;
};

export type payment_intent_next_action_konbini_seicomart = {
  /**
   * The confirmation number.
   */
  confirmation_number?: string;
  /**
   * The payment code.
   */
  payment_code: string;
};

export type payment_intent_next_action_konbini_stores = {
  /**
   * FamilyMart instruction details.
   */
  familymart?: payment_intent_next_action_konbini_familymart | null;
  /**
   * Lawson instruction details.
   */
  lawson?: payment_intent_next_action_konbini_lawson | null;
  /**
   * Ministop instruction details.
   */
  ministop?: payment_intent_next_action_konbini_ministop | null;
  /**
   * Seicomart instruction details.
   */
  seicomart?: payment_intent_next_action_konbini_seicomart | null;
};

export type payment_intent_next_action_paynow_display_qr_code = {
  /**
   * The raw data string used to generate QR code, it should be used together with QR code library.
   */
  data: string;
  /**
   * The URL to the hosted PayNow instructions page, which allows customers to view the PayNow QR code.
   */
  hosted_instructions_url?: string | null;
  /**
   * The image_url_png string used to render QR code
   */
  image_url_png: string;
  /**
   * The image_url_svg string used to render QR code
   */
  image_url_svg: string;
};

export type payment_intent_next_action_pix_display_qr_code = {
  /**
   * The raw data string used to generate QR code, it should be used together with QR code library.
   */
  data?: string;
  /**
   * The date (unix timestamp) when the PIX expires.
   */
  expires_at?: number;
  /**
   * The URL to the hosted pix instructions page, which allows customers to view the pix QR code.
   */
  hosted_instructions_url?: string;
  /**
   * The image_url_png string used to render png QR code
   */
  image_url_png?: string;
  /**
   * The image_url_svg string used to render svg QR code
   */
  image_url_svg?: string;
};

export type payment_intent_next_action_promptpay_display_qr_code = {
  /**
   * The raw data string used to generate QR code, it should be used together with QR code library.
   */
  data: string;
  /**
   * The URL to the hosted PromptPay instructions page, which allows customers to view the PromptPay QR code.
   */
  hosted_instructions_url: string;
  /**
   * The PNG path used to render the QR code, can be used as the source in an HTML img tag
   */
  image_url_png: string;
  /**
   * The SVG path used to render the QR code, can be used as the source in an HTML img tag
   */
  image_url_svg: string;
};

export type payment_intent_next_action_redirect_to_url = {
  /**
   * If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
   */
  return_url?: string | null;
  /**
   * The URL you must redirect your customer to in order to authenticate the payment.
   */
  url?: string | null;
};

export type payment_intent_next_action_swish_handle_redirect_or_display_qr_code = {
  /**
   * The URL to the hosted Swish instructions page, which allows customers to view the QR code.
   */
  hosted_instructions_url: string;
  qr_code: payment_intent_next_action_swish_qr_code;
};

export type payment_intent_next_action_swish_qr_code = {
  /**
   * The raw data string used to generate QR code, it should be used together with QR code library.
   */
  data: string;
  /**
   * The image_url_png string used to render QR code
   */
  image_url_png: string;
  /**
   * The image_url_svg string used to render QR code
   */
  image_url_svg: string;
};

export type payment_intent_next_action_verify_with_microdeposits = {
  /**
   * The timestamp when the microdeposits are expected to land.
   */
  arrival_date: number;
  /**
   * The URL for the hosted verification page, which allows customers to verify their bank account.
   */
  hosted_verification_url: string;
  /**
   * The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.
   */
  microdeposit_type?: ('amounts' | 'descriptor_code') | null;
};

/**
 * The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.
 */
export type microdeposit_type = 'amounts' | 'descriptor_code';

export type payment_intent_next_action_wechat_pay_display_qr_code = {
  /**
   * The data being used to generate QR code
   */
  data: string;
  /**
   * The URL to the hosted WeChat Pay instructions page, which allows customers to view the WeChat Pay QR code.
   */
  hosted_instructions_url: string;
  /**
   * The base64 image data for a pre-generated QR code
   */
  image_data_url: string;
  /**
   * The image_url_png string used to render QR code
   */
  image_url_png: string;
  /**
   * The image_url_svg string used to render QR code
   */
  image_url_svg: string;
};

export type payment_intent_next_action_wechat_pay_redirect_to_android_app = {
  /**
   * app_id is the APP ID registered on WeChat open platform
   */
  app_id: string;
  /**
   * nonce_str is a random string
   */
  nonce_str: string;
  /**
   * package is static value
   */
  package: string;
  /**
   * an unique merchant ID assigned by WeChat Pay
   */
  partner_id: string;
  /**
   * an unique trading ID assigned by WeChat Pay
   */
  prepay_id: string;
  /**
   * A signature
   */
  sign: string;
  /**
   * Specifies the current time in epoch format
   */
  timestamp: string;
};

export type payment_intent_next_action_wechat_pay_redirect_to_ios_app = {
  /**
   * An universal link that redirect to WeChat Pay app
   */
  native_url: string;
};

export type payment_intent_payment_method_options = {
  acss_debit?:
    | payment_intent_payment_method_options_acss_debit
    | payment_intent_type_specific_payment_method_options_client;
  affirm?: payment_method_options_affirm | payment_intent_type_specific_payment_method_options_client;
  afterpay_clearpay?:
    | payment_method_options_afterpay_clearpay
    | payment_intent_type_specific_payment_method_options_client;
  alipay?: payment_method_options_alipay | payment_intent_type_specific_payment_method_options_client;
  amazon_pay?: payment_method_options_amazon_pay | payment_intent_type_specific_payment_method_options_client;
  au_becs_debit?:
    | payment_intent_payment_method_options_au_becs_debit
    | payment_intent_type_specific_payment_method_options_client;
  bacs_debit?: payment_method_options_bacs_debit | payment_intent_type_specific_payment_method_options_client;
  bancontact?: payment_method_options_bancontact | payment_intent_type_specific_payment_method_options_client;
  blik?: payment_intent_payment_method_options_blik | payment_intent_type_specific_payment_method_options_client;
  boleto?: payment_method_options_boleto | payment_intent_type_specific_payment_method_options_client;
  card?: payment_intent_payment_method_options_card | payment_intent_type_specific_payment_method_options_client;
  card_present?: payment_method_options_card_present | payment_intent_type_specific_payment_method_options_client;
  cashapp?: payment_method_options_cashapp | payment_intent_type_specific_payment_method_options_client;
  customer_balance?:
    | payment_method_options_customer_balance
    | payment_intent_type_specific_payment_method_options_client;
  eps?: payment_intent_payment_method_options_eps | payment_intent_type_specific_payment_method_options_client;
  fpx?: payment_method_options_fpx | payment_intent_type_specific_payment_method_options_client;
  giropay?: payment_method_options_giropay | payment_intent_type_specific_payment_method_options_client;
  grabpay?: payment_method_options_grabpay | payment_intent_type_specific_payment_method_options_client;
  ideal?: payment_method_options_ideal | payment_intent_type_specific_payment_method_options_client;
  interac_present?: payment_method_options_interac_present | payment_intent_type_specific_payment_method_options_client;
  klarna?: payment_method_options_klarna | payment_intent_type_specific_payment_method_options_client;
  konbini?: payment_method_options_konbini | payment_intent_type_specific_payment_method_options_client;
  link?: payment_intent_payment_method_options_link | payment_intent_type_specific_payment_method_options_client;
  mobilepay?:
    | payment_intent_payment_method_options_mobilepay
    | payment_intent_type_specific_payment_method_options_client;
  multibanco?: payment_method_options_multibanco | payment_intent_type_specific_payment_method_options_client;
  oxxo?: payment_method_options_oxxo | payment_intent_type_specific_payment_method_options_client;
  p24?: payment_method_options_p24 | payment_intent_type_specific_payment_method_options_client;
  paynow?: payment_method_options_paynow | payment_intent_type_specific_payment_method_options_client;
  paypal?: payment_method_options_paypal | payment_intent_type_specific_payment_method_options_client;
  pix?: payment_method_options_pix | payment_intent_type_specific_payment_method_options_client;
  promptpay?: payment_method_options_promptpay | payment_intent_type_specific_payment_method_options_client;
  revolut_pay?: payment_method_options_revolut_pay | payment_intent_type_specific_payment_method_options_client;
  sepa_debit?:
    | payment_intent_payment_method_options_sepa_debit
    | payment_intent_type_specific_payment_method_options_client;
  sofort?: payment_method_options_sofort | payment_intent_type_specific_payment_method_options_client;
  swish?: payment_intent_payment_method_options_swish | payment_intent_type_specific_payment_method_options_client;
  twint?: payment_method_options_twint | payment_intent_type_specific_payment_method_options_client;
  us_bank_account?:
    | payment_intent_payment_method_options_us_bank_account
    | payment_intent_type_specific_payment_method_options_client;
  wechat_pay?: payment_method_options_wechat_pay | payment_intent_type_specific_payment_method_options_client;
  zip?: payment_method_options_zip | payment_intent_type_specific_payment_method_options_client;
};

export type payment_intent_payment_method_options_acss_debit = {
  mandate_options?: payment_intent_payment_method_options_mandate_options_acss_debit;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type payment_intent_payment_method_options_au_becs_debit = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type payment_intent_payment_method_options_blik = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_intent_payment_method_options_card = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Installment details for this payment (Mexico only).
   *
   * For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
   */
  installments?: payment_method_options_card_installments | null;
  /**
   * Configuration options for setting up an eMandate for cards issued in India.
   */
  mandate_options?: payment_method_options_card_mandate_options | null;
  /**
   * Selected network to process this payment intent on. Depends on the available networks of the card attached to the payment intent. Can be only set confirm-time.
   */
  network?:
    | (
        | 'amex'
        | 'cartes_bancaires'
        | 'diners'
        | 'discover'
        | 'eftpos_au'
        | 'interac'
        | 'jcb'
        | 'mastercard'
        | 'unionpay'
        | 'unknown'
        | 'visa'
      )
    | null;
  /**
   * Request ability to [capture beyond the standard authorization validity window](https://stripe.com/docs/payments/extended-authorization) for this PaymentIntent.
   */
  request_extended_authorization?: 'if_available' | 'never';
  /**
   * Request ability to [increment the authorization](https://stripe.com/docs/payments/incremental-authorization) for this PaymentIntent.
   */
  request_incremental_authorization?: 'if_available' | 'never';
  /**
   * Request ability to make [multiple captures](https://stripe.com/docs/payments/multicapture) for this PaymentIntent.
   */
  request_multicapture?: 'if_available' | 'never';
  /**
   * Request ability to [overcapture](https://stripe.com/docs/payments/overcapture) for this PaymentIntent.
   */
  request_overcapture?: 'if_available' | 'never';
  /**
   * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
   */
  request_three_d_secure?: ('any' | 'automatic' | 'challenge') | null;
  /**
   * When enabled, using a card that is attached to a customer will require the CVC to be provided again (i.e. using the cvc_token parameter).
   */
  require_cvc_recollection?: boolean;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.
   */
  statement_descriptor_suffix_kana?: string;
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.
   */
  statement_descriptor_suffix_kanji?: string;
};

/**
 * Selected network to process this payment intent on. Depends on the available networks of the card attached to the payment intent. Can be only set confirm-time.
 */
export type network7 =
  | 'amex'
  | 'cartes_bancaires'
  | 'diners'
  | 'discover'
  | 'eftpos_au'
  | 'interac'
  | 'jcb'
  | 'mastercard'
  | 'unionpay'
  | 'unknown'
  | 'visa';

/**
 * Request ability to [capture beyond the standard authorization validity window](https://stripe.com/docs/payments/extended-authorization) for this PaymentIntent.
 */
export type request_extended_authorization = 'if_available' | 'never';

/**
 * Request ability to [increment the authorization](https://stripe.com/docs/payments/incremental-authorization) for this PaymentIntent.
 */
export type request_incremental_authorization = 'if_available' | 'never';

/**
 * Request ability to make [multiple captures](https://stripe.com/docs/payments/multicapture) for this PaymentIntent.
 */
export type request_multicapture = 'if_available' | 'never';

/**
 * Request ability to [overcapture](https://stripe.com/docs/payments/overcapture) for this PaymentIntent.
 */
export type request_overcapture = 'if_available' | 'never';

export type payment_intent_payment_method_options_eps = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_intent_payment_method_options_link = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_intent_payment_method_options_mandate_options_acss_debit = {
  /**
   * A URL for custom mandate text
   */
  custom_mandate_url?: string;
  /**
   * Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
   */
  interval_description?: string | null;
  /**
   * Payment schedule for the mandate.
   */
  payment_schedule?: ('combined' | 'interval' | 'sporadic') | null;
  /**
   * Transaction type of the mandate.
   */
  transaction_type?: ('business' | 'personal') | null;
};

export type payment_intent_payment_method_options_mandate_options_sepa_debit = {
  [key: string]: unknown;
};

export type payment_intent_payment_method_options_mobilepay = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_intent_payment_method_options_sepa_debit = {
  mandate_options?: payment_intent_payment_method_options_mandate_options_sepa_debit;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type payment_intent_payment_method_options_swish = {
  /**
   * The order ID displayed in the Swish app after the payment is authorized.
   */
  reference?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_intent_payment_method_options_us_bank_account = {
  financial_connections?: linked_account_options_us_bank_account;
  mandate_options?: payment_method_options_us_bank_account_mandate_options;
  /**
   * Preferred transaction settlement speed
   */
  preferred_settlement_speed?: 'fastest' | 'standard';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

/**
 * Preferred transaction settlement speed
 */
export type preferred_settlement_speed = 'fastest' | 'standard';

export type payment_intent_processing = {
  card?: payment_intent_card_processing;
  /**
   * Type of the payment method for which payment is in `processing` state, one of `card`.
   */
  type: 'card';
};

/**
 * Type of the payment method for which payment is in `processing` state, one of `card`.
 */
export type type36 = 'card';

export type payment_intent_processing_customer_notification = {
  /**
   * Whether customer approval has been requested for this payment. For payments greater than INR 15000 or mandate amount, the customer must provide explicit approval of the payment with their bank.
   */
  approval_requested?: boolean | null;
  /**
   * If customer approval is required, they need to provide approval before this time.
   */
  completes_at?: number | null;
};

export type payment_intent_type_specific_payment_method_options_client = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual' | 'manual_preferred';
  installments?: payment_flows_installment_options;
  /**
   * When enabled, using a card that is attached to a customer will require the CVC to be provided again (i.e. using the cvc_token parameter).
   */
  require_cvc_recollection?: boolean;
  routing?: payment_method_options_card_present_routing;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

/**
 * Controls when the funds will be captured from the customer's account.
 */
export type capture_method3 = 'manual' | 'manual_preferred';

/**
 * A payment link is a shareable URL that will take your customers to a hosted payment page. A payment link can be shared and used multiple times.
 *
 * When a customer opens a payment link it will open a new [checkout session](https://stripe.com/docs/api/checkout/sessions) to render the payment page. You can use [checkout session events](https://stripe.com/docs/api/events/types#event_types-checkout.session.completed) to track payments through payment links.
 *
 * Related guide: [Payment Links API](https://stripe.com/docs/payment-links)
 */
export type payment_link = {
  /**
   * Whether the payment link's `url` is active. If `false`, customers visiting the URL will be shown a page saying that the link has been deactivated.
   */
  active: boolean;
  after_completion: payment_links_resource_after_completion;
  /**
   * Whether user redeemable promotion codes are enabled.
   */
  allow_promotion_codes: boolean;
  /**
   * The ID of the Connect application that created the Payment Link.
   */
  application?: (string | application | deleted_application) | null;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account.
   */
  application_fee_amount?: number | null;
  /**
   * This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account.
   */
  application_fee_percent?: number | null;
  automatic_tax: payment_links_resource_automatic_tax;
  /**
   * Configuration for collecting the customer's billing address. Defaults to `auto`.
   */
  billing_address_collection: 'auto' | 'required';
  /**
   * When set, provides configuration to gather active consent from customers.
   */
  consent_collection?: payment_links_resource_consent_collection | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Collect additional information from your customer using custom fields. Up to 3 fields are supported.
   */
  custom_fields: Array<payment_links_resource_custom_fields>;
  custom_text: payment_links_resource_custom_text;
  /**
   * Configuration for Customer creation during checkout.
   */
  customer_creation: 'always' | 'if_required';
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The custom message to be displayed to a customer when a payment link is no longer active.
   */
  inactive_message?: string | null;
  /**
   * Configuration for creating invoice for payment mode payment links.
   */
  invoice_creation?: payment_links_resource_invoice_creation | null;
  /**
   * The line items representing what is being sold.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payment_link';
  /**
   * The account on behalf of which to charge. See the [Connect documentation](https://support.stripe.com/questions/sending-invoices-on-behalf-of-connected-accounts) for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * Indicates the parameters to be passed to PaymentIntent creation during checkout.
   */
  payment_intent_data?: payment_links_resource_payment_intent_data | null;
  /**
   * Configuration for collecting a payment method during checkout. Defaults to `always`.
   */
  payment_method_collection: 'always' | 'if_required';
  /**
   * The list of payment method types that customers can use. When `null`, Stripe will dynamically show relevant payment methods you've enabled in your [payment method settings](https://dashboard.stripe.com/settings/payment_methods).
   */
  payment_method_types?: Array<
    | 'affirm'
    | 'afterpay_clearpay'
    | 'alipay'
    | 'au_becs_debit'
    | 'bacs_debit'
    | 'bancontact'
    | 'blik'
    | 'boleto'
    | 'card'
    | 'cashapp'
    | 'eps'
    | 'fpx'
    | 'giropay'
    | 'grabpay'
    | 'ideal'
    | 'klarna'
    | 'konbini'
    | 'link'
    | 'oxxo'
    | 'p24'
    | 'paynow'
    | 'paypal'
    | 'pix'
    | 'promptpay'
    | 'sepa_debit'
    | 'sofort'
    | 'swish'
    | 'us_bank_account'
    | 'wechat_pay'
  > | null;
  phone_number_collection: payment_links_resource_phone_number_collection;
  /**
   * Settings that restrict the usage of a payment link.
   */
  restrictions?: payment_links_resource_restrictions | null;
  /**
   * Configuration for collecting the customer's shipping address.
   */
  shipping_address_collection?: payment_links_resource_shipping_address_collection | null;
  /**
   * The shipping rate options applied to the session.
   */
  shipping_options: Array<payment_links_resource_shipping_option>;
  /**
   * Indicates the type of transaction being performed which customizes relevant text on the page, such as the submit button.
   */
  submit_type: 'auto' | 'book' | 'donate' | 'pay';
  /**
   * When creating a subscription, the specified configuration data will be used. There must be at least one line item with a recurring price to use `subscription_data`.
   */
  subscription_data?: payment_links_resource_subscription_data | null;
  tax_id_collection: payment_links_resource_tax_id_collection;
  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from each payment will be transferred to.
   */
  transfer_data?: payment_links_resource_transfer_data | null;
  /**
   * The public URL that can be shared with customers.
   */
  url: string;
};

export type payment_links_resource_after_completion = {
  hosted_confirmation?: payment_links_resource_completion_behavior_confirmation_page;
  redirect?: payment_links_resource_completion_behavior_redirect;
  /**
   * The specified behavior after the purchase is complete.
   */
  type: 'hosted_confirmation' | 'redirect';
};

/**
 * The specified behavior after the purchase is complete.
 */
export type type37 = 'hosted_confirmation' | 'redirect';

export type payment_links_resource_automatic_tax = {
  /**
   * If `true`, tax will be calculated automatically using the customer's location.
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
};

export type payment_links_resource_completed_sessions = {
  /**
   * The current number of checkout sessions that have been completed on the payment link which count towards the `completed_sessions` restriction to be met.
   */
  count: number;
  /**
   * The maximum number of checkout sessions that can be completed for the `completed_sessions` restriction to be met.
   */
  limit: number;
};

export type payment_links_resource_completion_behavior_confirmation_page = {
  /**
   * The custom message that is displayed to the customer after the purchase is complete.
   */
  custom_message?: string | null;
};

export type payment_links_resource_completion_behavior_redirect = {
  /**
   * The URL the customer will be redirected to after the purchase is complete.
   */
  url: string;
};

export type payment_links_resource_consent_collection = {
  /**
   * Settings related to the payment method reuse text shown in the Checkout UI.
   */
  payment_method_reuse_agreement?: payment_links_resource_payment_method_reuse_agreement | null;
  /**
   * If set to `auto`, enables the collection of customer consent for promotional communications.
   */
  promotions?: ('auto' | 'none') | null;
  /**
   * If set to `required`, it requires cutomers to accept the terms of service before being able to pay. If set to `none`, customers won't be shown a checkbox to accept the terms of service.
   */
  terms_of_service?: ('none' | 'required') | null;
};

/**
 * If set to `auto`, enables the collection of customer consent for promotional communications.
 */
export type promotions = 'auto' | 'none';

/**
 * If set to `required`, it requires cutomers to accept the terms of service before being able to pay. If set to `none`, customers won't be shown a checkbox to accept the terms of service.
 */
export type terms_of_service = 'none' | 'required';

export type payment_links_resource_custom_fields = {
  dropdown?: payment_links_resource_custom_fields_dropdown;
  /**
   * String of your choice that your integration can use to reconcile this field. Must be unique to this field, alphanumeric, and up to 200 characters.
   */
  key: string;
  label: payment_links_resource_custom_fields_label;
  numeric?: payment_links_resource_custom_fields_numeric;
  /**
   * Whether the customer is required to complete the field before completing the Checkout Session. Defaults to `false`.
   */
  optional: boolean;
  text?: payment_links_resource_custom_fields_text;
  /**
   * The type of the field.
   */
  type: 'dropdown' | 'numeric' | 'text';
};

/**
 * The type of the field.
 */
export type type38 = 'dropdown' | 'numeric' | 'text';

export type payment_links_resource_custom_fields_dropdown = {
  /**
   * The options available for the customer to select. Up to 200 options allowed.
   */
  options: Array<payment_links_resource_custom_fields_dropdown_option>;
};

export type payment_links_resource_custom_fields_dropdown_option = {
  /**
   * The label for the option, displayed to the customer. Up to 100 characters.
   */
  label: string;
  /**
   * The value for this option, not displayed to the customer, used by your integration to reconcile the option selected by the customer. Must be unique to this option, alphanumeric, and up to 100 characters.
   */
  value: string;
};

export type payment_links_resource_custom_fields_label = {
  /**
   * Custom text for the label, displayed to the customer. Up to 50 characters.
   */
  custom?: string | null;
  /**
   * The type of the label.
   */
  type: 'custom';
};

/**
 * The type of the label.
 */
export type type39 = 'custom';

export type payment_links_resource_custom_fields_numeric = {
  /**
   * The maximum character length constraint for the customer's input.
   */
  maximum_length?: number | null;
  /**
   * The minimum character length requirement for the customer's input.
   */
  minimum_length?: number | null;
};

export type payment_links_resource_custom_fields_text = {
  /**
   * The maximum character length constraint for the customer's input.
   */
  maximum_length?: number | null;
  /**
   * The minimum character length requirement for the customer's input.
   */
  minimum_length?: number | null;
};

export type payment_links_resource_custom_text = {
  /**
   * Custom text that should be displayed after the payment confirmation button.
   */
  after_submit?: payment_links_resource_custom_text_position | null;
  /**
   * Custom text that should be displayed alongside shipping address collection.
   */
  shipping_address?: payment_links_resource_custom_text_position | null;
  /**
   * Custom text that should be displayed alongside the payment confirmation button.
   */
  submit?: payment_links_resource_custom_text_position | null;
  /**
   * Custom text that should be displayed in place of the default terms of service agreement text.
   */
  terms_of_service_acceptance?: payment_links_resource_custom_text_position | null;
};

export type payment_links_resource_custom_text_position = {
  /**
   * Text may be up to 1200 characters in length.
   */
  message: string;
};

export type payment_links_resource_invoice_creation = {
  /**
   * Enable creating an invoice on successful payment.
   */
  enabled: boolean;
  /**
   * Configuration for the invoice. Default invoice values will be used if unspecified.
   */
  invoice_data?: payment_links_resource_invoice_settings | null;
};

export type payment_links_resource_invoice_settings = {
  /**
   * The account tax IDs associated with the invoice.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  /**
   * A list of up to 4 custom fields to be displayed on the invoice.
   */
  custom_fields?: Array<invoice_setting_custom_field> | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Footer to be displayed on the invoice.
   */
  footer?: string | null;
  /**
   * The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.
   */
  issuer?: connect_account_reference | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * Options for invoice PDF rendering.
   */
  rendering_options?: invoice_setting_rendering_options | null;
};

export type payment_links_resource_payment_intent_data = {
  /**
   * Indicates when the funds will be captured from the customer's account.
   */
  capture_method?: ('automatic' | 'automatic_async' | 'manual') | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that will set metadata on [Payment Intents](https://stripe.com/docs/api/payment_intents) generated from this payment link.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Indicates that you intend to make future payments with the payment method collected during checkout.
   */
  setup_future_usage?: ('off_session' | 'on_session') | null;
  /**
   * Extra information about the payment. This will appear on your customer's statement when this payment succeeds in creating a charge.
   */
  statement_descriptor?: string | null;
  /**
   * Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  statement_descriptor_suffix?: string | null;
  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/connect/separate-charges-and-transfers) for details.
   */
  transfer_group?: string | null;
};

export type payment_links_resource_payment_method_reuse_agreement = {
  /**
   * Determines the position and visibility of the payment method reuse agreement in the UI. When set to `auto`, Stripe's defaults will be used.
   *
   * When set to `hidden`, the payment method reuse agreement text will always be hidden in the UI.
   */
  position: 'auto' | 'hidden';
};

/**
 * Determines the position and visibility of the payment method reuse agreement in the UI. When set to `auto`, Stripe's defaults will be used.
 *
 * When set to `hidden`, the payment method reuse agreement text will always be hidden in the UI.
 */
export type position = 'auto' | 'hidden';

export type payment_links_resource_phone_number_collection = {
  /**
   * If `true`, a phone number will be collected during checkout.
   */
  enabled: boolean;
};

export type payment_links_resource_restrictions = {
  completed_sessions: payment_links_resource_completed_sessions;
};

export type payment_links_resource_shipping_address_collection = {
  /**
   * An array of two-letter ISO country codes representing which countries Checkout should provide as options for shipping locations. Unsupported country codes: `AS, CX, CC, CU, HM, IR, KP, MH, FM, NF, MP, PW, SD, SY, UM, VI`.
   */
  allowed_countries: Array<
    | 'AC'
    | 'AD'
    | 'AE'
    | 'AF'
    | 'AG'
    | 'AI'
    | 'AL'
    | 'AM'
    | 'AO'
    | 'AQ'
    | 'AR'
    | 'AT'
    | 'AU'
    | 'AW'
    | 'AX'
    | 'AZ'
    | 'BA'
    | 'BB'
    | 'BD'
    | 'BE'
    | 'BF'
    | 'BG'
    | 'BH'
    | 'BI'
    | 'BJ'
    | 'BL'
    | 'BM'
    | 'BN'
    | 'BO'
    | 'BQ'
    | 'BR'
    | 'BS'
    | 'BT'
    | 'BV'
    | 'BW'
    | 'BY'
    | 'BZ'
    | 'CA'
    | 'CD'
    | 'CF'
    | 'CG'
    | 'CH'
    | 'CI'
    | 'CK'
    | 'CL'
    | 'CM'
    | 'CN'
    | 'CO'
    | 'CR'
    | 'CV'
    | 'CW'
    | 'CY'
    | 'CZ'
    | 'DE'
    | 'DJ'
    | 'DK'
    | 'DM'
    | 'DO'
    | 'DZ'
    | 'EC'
    | 'EE'
    | 'EG'
    | 'EH'
    | 'ER'
    | 'ES'
    | 'ET'
    | 'FI'
    | 'FJ'
    | 'FK'
    | 'FO'
    | 'FR'
    | 'GA'
    | 'GB'
    | 'GD'
    | 'GE'
    | 'GF'
    | 'GG'
    | 'GH'
    | 'GI'
    | 'GL'
    | 'GM'
    | 'GN'
    | 'GP'
    | 'GQ'
    | 'GR'
    | 'GS'
    | 'GT'
    | 'GU'
    | 'GW'
    | 'GY'
    | 'HK'
    | 'HN'
    | 'HR'
    | 'HT'
    | 'HU'
    | 'ID'
    | 'IE'
    | 'IL'
    | 'IM'
    | 'IN'
    | 'IO'
    | 'IQ'
    | 'IS'
    | 'IT'
    | 'JE'
    | 'JM'
    | 'JO'
    | 'JP'
    | 'KE'
    | 'KG'
    | 'KH'
    | 'KI'
    | 'KM'
    | 'KN'
    | 'KR'
    | 'KW'
    | 'KY'
    | 'KZ'
    | 'LA'
    | 'LB'
    | 'LC'
    | 'LI'
    | 'LK'
    | 'LR'
    | 'LS'
    | 'LT'
    | 'LU'
    | 'LV'
    | 'LY'
    | 'MA'
    | 'MC'
    | 'MD'
    | 'ME'
    | 'MF'
    | 'MG'
    | 'MK'
    | 'ML'
    | 'MM'
    | 'MN'
    | 'MO'
    | 'MQ'
    | 'MR'
    | 'MS'
    | 'MT'
    | 'MU'
    | 'MV'
    | 'MW'
    | 'MX'
    | 'MY'
    | 'MZ'
    | 'NA'
    | 'NC'
    | 'NE'
    | 'NG'
    | 'NI'
    | 'NL'
    | 'NO'
    | 'NP'
    | 'NR'
    | 'NU'
    | 'NZ'
    | 'OM'
    | 'PA'
    | 'PE'
    | 'PF'
    | 'PG'
    | 'PH'
    | 'PK'
    | 'PL'
    | 'PM'
    | 'PN'
    | 'PR'
    | 'PS'
    | 'PT'
    | 'PY'
    | 'QA'
    | 'RE'
    | 'RO'
    | 'RS'
    | 'RU'
    | 'RW'
    | 'SA'
    | 'SB'
    | 'SC'
    | 'SE'
    | 'SG'
    | 'SH'
    | 'SI'
    | 'SJ'
    | 'SK'
    | 'SL'
    | 'SM'
    | 'SN'
    | 'SO'
    | 'SR'
    | 'SS'
    | 'ST'
    | 'SV'
    | 'SX'
    | 'SZ'
    | 'TA'
    | 'TC'
    | 'TD'
    | 'TF'
    | 'TG'
    | 'TH'
    | 'TJ'
    | 'TK'
    | 'TL'
    | 'TM'
    | 'TN'
    | 'TO'
    | 'TR'
    | 'TT'
    | 'TV'
    | 'TW'
    | 'TZ'
    | 'UA'
    | 'UG'
    | 'US'
    | 'UY'
    | 'UZ'
    | 'VA'
    | 'VC'
    | 'VE'
    | 'VG'
    | 'VN'
    | 'VU'
    | 'WF'
    | 'WS'
    | 'XK'
    | 'YE'
    | 'YT'
    | 'ZA'
    | 'ZM'
    | 'ZW'
    | 'ZZ'
  >;
};

export type payment_links_resource_shipping_option = {
  /**
   * A non-negative integer in cents representing how much to charge.
   */
  shipping_amount: number;
  /**
   * The ID of the Shipping Rate to use for this shipping option.
   */
  shipping_rate: string | shipping_rate;
};

export type payment_links_resource_subscription_data = {
  /**
   * The subscription's description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
   */
  description?: string | null;
  invoice_settings: payment_links_resource_subscription_data_invoice_settings;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that will set metadata on [Subscriptions](https://stripe.com/docs/api/subscriptions) generated from this payment link.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Integer representing the number of trial period days before the customer is charged for the first time.
   */
  trial_period_days?: number | null;
  /**
   * Settings related to subscription trials.
   */
  trial_settings?: subscriptions_trials_resource_trial_settings | null;
};

export type payment_links_resource_subscription_data_invoice_settings = {
  issuer: connect_account_reference;
};

export type payment_links_resource_tax_id_collection = {
  /**
   * Indicates whether tax ID collection is enabled for the session.
   */
  enabled: boolean;
};

export type payment_links_resource_transfer_data = {
  /**
   * The amount in cents (or local equivalent) that will be transferred to the destination account. By default, the entire amount is transferred to the destination.
   */
  amount?: number | null;
  /**
   * The connected account receiving the transfer.
   */
  destination: string | account;
};

/**
 * PaymentMethod objects represent your customer's payment instruments.
 * You can use them with [PaymentIntents](https://stripe.com/docs/payments/payment-intents) to collect payments or save them to
 * Customer objects to store instrument details for future payments.
 *
 * Related guides: [Payment Methods](https://stripe.com/docs/payments/payment-methods) and [More Payment Scenarios](https://stripe.com/docs/payments/more-payment-scenarios).
 */
export type payment_method = {
  acss_debit?: payment_method_acss_debit;
  affirm?: payment_method_affirm;
  afterpay_clearpay?: payment_method_afterpay_clearpay;
  alipay?: payment_flows_private_payment_methods_alipay;
  /**
   * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow. The field defaults to “unspecified”.
   */
  allow_redisplay?: 'always' | 'limited' | 'unspecified';
  amazon_pay?: payment_method_amazon_pay;
  au_becs_debit?: payment_method_au_becs_debit;
  bacs_debit?: payment_method_bacs_debit;
  bancontact?: payment_method_bancontact;
  billing_details: billing_details;
  blik?: payment_method_blik;
  boleto?: payment_method_boleto;
  card?: payment_method_card;
  card_present?: payment_method_card_present;
  cashapp?: payment_method_cashapp;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer.
   */
  customer?: (string | customer) | null;
  customer_balance?: payment_method_customer_balance;
  eps?: payment_method_eps;
  fpx?: payment_method_fpx;
  giropay?: payment_method_giropay;
  grabpay?: payment_method_grabpay;
  /**
   * Unique identifier for the object.
   */
  id: string;
  ideal?: payment_method_ideal;
  interac_present?: payment_method_interac_present;
  klarna?: payment_method_klarna;
  konbini?: payment_method_konbini;
  link?: payment_method_link;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  mobilepay?: payment_method_mobilepay;
  multibanco?: payment_method_multibanco;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payment_method';
  oxxo?: payment_method_oxxo;
  p24?: payment_method_p24;
  paynow?: payment_method_paynow;
  paypal?: payment_method_paypal;
  pix?: payment_method_pix;
  promptpay?: payment_method_promptpay;
  radar_options?: radar_radar_options;
  revolut_pay?: payment_method_revolut_pay;
  sepa_debit?: payment_method_sepa_debit;
  sofort?: payment_method_sofort;
  swish?: payment_method_swish;
  twint?: payment_method_twint;
  /**
   * The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.
   */
  type:
    | 'acss_debit'
    | 'affirm'
    | 'afterpay_clearpay'
    | 'alipay'
    | 'amazon_pay'
    | 'au_becs_debit'
    | 'bacs_debit'
    | 'bancontact'
    | 'blik'
    | 'boleto'
    | 'card'
    | 'card_present'
    | 'cashapp'
    | 'customer_balance'
    | 'eps'
    | 'fpx'
    | 'giropay'
    | 'grabpay'
    | 'ideal'
    | 'interac_present'
    | 'klarna'
    | 'konbini'
    | 'link'
    | 'mobilepay'
    | 'multibanco'
    | 'oxxo'
    | 'p24'
    | 'paynow'
    | 'paypal'
    | 'pix'
    | 'promptpay'
    | 'revolut_pay'
    | 'sepa_debit'
    | 'sofort'
    | 'swish'
    | 'twint'
    | 'us_bank_account'
    | 'wechat_pay'
    | 'zip';
  us_bank_account?: payment_method_us_bank_account;
  wechat_pay?: payment_method_wechat_pay;
  zip?: payment_method_zip;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object81 = 'payment_method';

export type payment_method_acss_debit = {
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Institution number of the bank account.
   */
  institution_number?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * Transit number of the bank account.
   */
  transit_number?: string | null;
};

export type payment_method_affirm = {
  [key: string]: unknown;
};

export type payment_method_afterpay_clearpay = {
  [key: string]: unknown;
};

export type payment_method_amazon_pay = {
  [key: string]: unknown;
};

export type payment_method_au_becs_debit = {
  /**
   * Six-digit number identifying bank and branch associated with this bank account.
   */
  bsb_number?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
};

export type payment_method_bacs_debit = {
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * Sort code of the bank account. (e.g., `10-20-30`)
   */
  sort_code?: string | null;
};

export type payment_method_bancontact = {
  [key: string]: unknown;
};

export type payment_method_blik = {
  [key: string]: unknown;
};

export type payment_method_boleto = {
  /**
   * Uniquely identifies the customer tax id (CNPJ or CPF)
   */
  tax_id: string;
};

export type payment_method_card = {
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand: string;
  /**
   * Checks on Card address and CVC if provided.
   */
  checks?: payment_method_card_checks | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * The brand to use when displaying the card, this accounts for customer's brand choice on dual-branded cards. Can be `american_express`, `cartes_bancaires`, `diners_club`, `discover`, `eftpos_australia`, `interac`, `jcb`, `mastercard`, `union_pay`, `visa`, or `other` and may contain more values in the future.
   */
  display_brand?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding: string;
  /**
   * Details of the original PaymentMethod that created this object.
   */
  generated_from?: payment_method_card_generated_card | null;
  /**
   * The last four digits of the card.
   */
  last4: string;
  /**
   * Contains information about card networks that can be used to process the payment.
   */
  networks?: networks | null;
  /**
   * Contains details on how this Card may be used for 3D Secure authentication.
   */
  three_d_secure_usage?: three_d_secure_usage | null;
  /**
   * If this Card is part of a card wallet, this contains the details of the card wallet.
   */
  wallet?: payment_method_card_wallet | null;
};

export type payment_method_card_checks = {
  /**
   * If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_line1_check?: string | null;
  /**
   * If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_postal_code_check?: string | null;
  /**
   * If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  cvc_check?: string | null;
};

export type payment_method_card_generated_card = {
  /**
   * The charge that created this object.
   */
  charge?: string | null;
  /**
   * Transaction-specific details of the payment method used in the payment.
   */
  payment_method_details?: card_generated_from_payment_method_details | null;
  /**
   * The ID of the SetupAttempt that generated this PaymentMethod, if any.
   */
  setup_attempt?: (string | setup_attempt) | null;
};

export type payment_method_card_present = {
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand?: string | null;
  /**
   * The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.
   */
  cardholder_name?: string | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * Contains information about card networks that can be used to process the payment.
   */
  networks?: payment_method_card_present_networks | null;
  /**
   * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
   */
  preferred_locales?: Array<string> | null;
  /**
   * How card details were read in this transaction.
   */
  read_method?:
    | (
        | 'contact_emv'
        | 'contactless_emv'
        | 'contactless_magstripe_mode'
        | 'magnetic_stripe_fallback'
        | 'magnetic_stripe_track2'
      )
    | null;
};

/**
 * How card details were read in this transaction.
 */
export type read_method =
  | 'contact_emv'
  | 'contactless_emv'
  | 'contactless_magstripe_mode'
  | 'magnetic_stripe_fallback'
  | 'magnetic_stripe_track2';

export type payment_method_card_present_networks = {
  /**
   * All available networks for the card.
   */
  available: Array<string>;
  /**
   * The preferred network for the card.
   */
  preferred?: string | null;
};

export type payment_method_card_wallet = {
  amex_express_checkout?: payment_method_card_wallet_amex_express_checkout;
  apple_pay?: payment_method_card_wallet_apple_pay;
  /**
   * (For tokenized numbers only.) The last four digits of the device account number.
   */
  dynamic_last4?: string | null;
  google_pay?: payment_method_card_wallet_google_pay;
  link?: payment_method_card_wallet_link;
  masterpass?: payment_method_card_wallet_masterpass;
  samsung_pay?: payment_method_card_wallet_samsung_pay;
  /**
   * The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, `visa_checkout`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.
   */
  type: 'amex_express_checkout' | 'apple_pay' | 'google_pay' | 'link' | 'masterpass' | 'samsung_pay' | 'visa_checkout';
  visa_checkout?: payment_method_card_wallet_visa_checkout;
};

/**
 * The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, `visa_checkout`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.
 */
export type type40 =
  | 'amex_express_checkout'
  | 'apple_pay'
  | 'google_pay'
  | 'link'
  | 'masterpass'
  | 'samsung_pay'
  | 'visa_checkout';

export type payment_method_card_wallet_amex_express_checkout = {
  [key: string]: unknown;
};

export type payment_method_card_wallet_apple_pay = {
  [key: string]: unknown;
};

export type payment_method_card_wallet_google_pay = {
  [key: string]: unknown;
};

export type payment_method_card_wallet_link = {
  [key: string]: unknown;
};

export type payment_method_card_wallet_masterpass = {
  /**
   * Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  billing_address?: address | null;
  /**
   * Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  email?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  name?: string | null;
  /**
   * Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  shipping_address?: address | null;
};

export type payment_method_card_wallet_samsung_pay = {
  [key: string]: unknown;
};

export type payment_method_card_wallet_visa_checkout = {
  /**
   * Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  billing_address?: address | null;
  /**
   * Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  email?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  name?: string | null;
  /**
   * Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  shipping_address?: address | null;
};

export type payment_method_cashapp = {
  /**
   * A unique and immutable identifier assigned by Cash App to every buyer.
   */
  buyer_id?: string | null;
  /**
   * A public identifier for buyers using Cash App.
   */
  cashtag?: string | null;
};

export type payment_method_config_biz_payment_method_configuration_details = {
  /**
   * ID of the payment method configuration used.
   */
  id: string;
  /**
   * ID of the parent payment method configuration used.
   */
  parent?: string | null;
};

export type payment_method_config_resource_display_preference = {
  /**
   * For child configs, whether or not the account's preference will be observed. If `false`, the parent configuration's default is used.
   */
  overridable?: boolean | null;
  /**
   * The account's display preference.
   */
  preference: 'none' | 'off' | 'on';
  /**
   * The effective display preference value.
   */
  value: 'off' | 'on';
};

/**
 * The account's display preference.
 */
export type preference = 'none' | 'off' | 'on';

/**
 * The effective display preference value.
 */
export type value = 'off' | 'on';

export type payment_method_config_resource_payment_method_properties = {
  /**
   * Whether this payment method may be offered at checkout. True if `display_preference` is `on` and the payment method's capability is active.
   */
  available: boolean;
  display_preference: payment_method_config_resource_display_preference;
};

/**
 * PaymentMethodConfigurations control which payment methods are displayed to your customers when you don't explicitly specify payment method types. You can have multiple configurations with different sets of payment methods for different scenarios.
 *
 * There are two types of PaymentMethodConfigurations. Which is used depends on the [charge type](https://stripe.com/docs/connect/charges):
 *
 * **Direct** configurations apply to payments created on your account, including Connect destination charges, Connect separate charges and transfers, and payments not involving Connect.
 *
 * **Child** configurations apply to payments created on your connected accounts using direct charges, and charges with the on_behalf_of parameter.
 *
 * Child configurations have a `parent` that sets default values and controls which settings connected accounts may override. You can specify a parent ID at payment time, and Stripe will automatically resolve the connected account’s associated child configuration. Parent configurations are [managed in the dashboard](https://dashboard.stripe.com/settings/payment_methods/connected_accounts) and are not available in this API.
 *
 * Related guides:
 * - [Payment Method Configurations API](https://stripe.com/docs/connect/payment-method-configurations)
 * - [Multiple configurations on dynamic payment methods](https://stripe.com/docs/payments/multiple-payment-method-configs)
 * - [Multiple configurations for your Connect accounts](https://stripe.com/docs/connect/multiple-payment-method-configurations)
 */
export type payment_method_configuration = {
  acss_debit?: payment_method_config_resource_payment_method_properties;
  /**
   * Whether the configuration can be used for new payments.
   */
  active: boolean;
  affirm?: payment_method_config_resource_payment_method_properties;
  afterpay_clearpay?: payment_method_config_resource_payment_method_properties;
  alipay?: payment_method_config_resource_payment_method_properties;
  amazon_pay?: payment_method_config_resource_payment_method_properties;
  apple_pay?: payment_method_config_resource_payment_method_properties;
  /**
   * For child configs, the Connect application associated with the configuration.
   */
  application?: string | null;
  au_becs_debit?: payment_method_config_resource_payment_method_properties;
  bacs_debit?: payment_method_config_resource_payment_method_properties;
  bancontact?: payment_method_config_resource_payment_method_properties;
  blik?: payment_method_config_resource_payment_method_properties;
  boleto?: payment_method_config_resource_payment_method_properties;
  card?: payment_method_config_resource_payment_method_properties;
  cartes_bancaires?: payment_method_config_resource_payment_method_properties;
  cashapp?: payment_method_config_resource_payment_method_properties;
  customer_balance?: payment_method_config_resource_payment_method_properties;
  eps?: payment_method_config_resource_payment_method_properties;
  fpx?: payment_method_config_resource_payment_method_properties;
  giropay?: payment_method_config_resource_payment_method_properties;
  google_pay?: payment_method_config_resource_payment_method_properties;
  grabpay?: payment_method_config_resource_payment_method_properties;
  /**
   * Unique identifier for the object.
   */
  id: string;
  ideal?: payment_method_config_resource_payment_method_properties;
  /**
   * The default configuration is used whenever a payment method configuration is not specified.
   */
  is_default: boolean;
  jcb?: payment_method_config_resource_payment_method_properties;
  klarna?: payment_method_config_resource_payment_method_properties;
  konbini?: payment_method_config_resource_payment_method_properties;
  link?: payment_method_config_resource_payment_method_properties;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  mobilepay?: payment_method_config_resource_payment_method_properties;
  multibanco?: payment_method_config_resource_payment_method_properties;
  /**
   * The configuration's name.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payment_method_configuration';
  oxxo?: payment_method_config_resource_payment_method_properties;
  p24?: payment_method_config_resource_payment_method_properties;
  /**
   * For child configs, the configuration's parent configuration.
   */
  parent?: string | null;
  paynow?: payment_method_config_resource_payment_method_properties;
  paypal?: payment_method_config_resource_payment_method_properties;
  promptpay?: payment_method_config_resource_payment_method_properties;
  revolut_pay?: payment_method_config_resource_payment_method_properties;
  sepa_debit?: payment_method_config_resource_payment_method_properties;
  sofort?: payment_method_config_resource_payment_method_properties;
  swish?: payment_method_config_resource_payment_method_properties;
  us_bank_account?: payment_method_config_resource_payment_method_properties;
  wechat_pay?: payment_method_config_resource_payment_method_properties;
  zip?: payment_method_config_resource_payment_method_properties;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object82 = 'payment_method_configuration';

export type payment_method_customer_balance = {
  [key: string]: unknown;
};

export type payment_method_details = {
  ach_credit_transfer?: payment_method_details_ach_credit_transfer;
  ach_debit?: payment_method_details_ach_debit;
  acss_debit?: payment_method_details_acss_debit;
  affirm?: payment_method_details_affirm;
  afterpay_clearpay?: payment_method_details_afterpay_clearpay;
  alipay?: payment_flows_private_payment_methods_alipay_details;
  amazon_pay?: payment_method_details_amazon_pay;
  au_becs_debit?: payment_method_details_au_becs_debit;
  bacs_debit?: payment_method_details_bacs_debit;
  bancontact?: payment_method_details_bancontact;
  blik?: payment_method_details_blik;
  boleto?: payment_method_details_boleto;
  card?: payment_method_details_card;
  card_present?: payment_method_details_card_present;
  cashapp?: payment_method_details_cashapp;
  customer_balance?: payment_method_details_customer_balance;
  eps?: payment_method_details_eps;
  fpx?: payment_method_details_fpx;
  giropay?: payment_method_details_giropay;
  grabpay?: payment_method_details_grabpay;
  ideal?: payment_method_details_ideal;
  interac_present?: payment_method_details_interac_present;
  klarna?: payment_method_details_klarna;
  konbini?: payment_method_details_konbini;
  link?: payment_method_details_link;
  mobilepay?: payment_method_details_mobilepay;
  multibanco?: payment_method_details_multibanco;
  oxxo?: payment_method_details_oxxo;
  p24?: payment_method_details_p24;
  paynow?: payment_method_details_paynow;
  paypal?: payment_method_details_paypal;
  pix?: payment_method_details_pix;
  promptpay?: payment_method_details_promptpay;
  revolut_pay?: payment_method_details_revolut_pay;
  sepa_debit?: payment_method_details_sepa_debit;
  sofort?: payment_method_details_sofort;
  stripe_account?: payment_method_details_stripe_account;
  swish?: payment_method_details_swish;
  twint?: payment_method_details_twint;
  /**
   * The type of transaction-specific details of the payment method used in the payment, one of `ach_credit_transfer`, `ach_debit`, `acss_debit`, `alipay`, `au_becs_debit`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `klarna`, `multibanco`, `p24`, `sepa_debit`, `sofort`, `stripe_account`, or `wechat`.
   * An additional hash is included on `payment_method_details` with a name matching this value.
   * It contains information specific to the payment method.
   */
  type: string;
  us_bank_account?: payment_method_details_us_bank_account;
  wechat?: payment_method_details_wechat;
  wechat_pay?: payment_method_details_wechat_pay;
  zip?: payment_method_details_zip;
};

export type payment_method_details_ach_credit_transfer = {
  /**
   * Account number to transfer funds to.
   */
  account_number?: string | null;
  /**
   * Name of the bank associated with the routing number.
   */
  bank_name?: string | null;
  /**
   * Routing transit number for the bank account to transfer funds to.
   */
  routing_number?: string | null;
  /**
   * SWIFT code of the bank associated with the routing number.
   */
  swift_code?: string | null;
};

export type payment_method_details_ach_debit = {
  /**
   * Type of entity that holds the account. This can be either `individual` or `company`.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * Routing transit number of the bank account.
   */
  routing_number?: string | null;
};

export type payment_method_details_acss_debit = {
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Institution number of the bank account
   */
  institution_number?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string;
  /**
   * Transit number of the bank account.
   */
  transit_number?: string | null;
};

export type payment_method_details_affirm = {
  [key: string]: unknown;
};

export type payment_method_details_afterpay_clearpay = {
  /**
   * The Afterpay order ID associated with this payment intent.
   */
  order_id?: string | null;
  /**
   * Order identifier shown to the merchant in Afterpay’s online portal.
   */
  reference?: string | null;
};

export type payment_method_details_amazon_pay = {
  [key: string]: unknown;
};

export type payment_method_details_au_becs_debit = {
  /**
   * Bank-State-Branch number of the bank account.
   */
  bsb_number?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string;
};

export type payment_method_details_bacs_debit = {
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string | null;
  /**
   * Sort code of the bank account. (e.g., `10-20-30`)
   */
  sort_code?: string | null;
};

export type payment_method_details_bancontact = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Bank Identifier Code of the bank associated with the bank account.
   */
  bic?: string | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Preferred language of the Bancontact authorization page that the customer is redirected to.
   * Can be one of `en`, `de`, `fr`, or `nl`
   */
  preferred_language?: ('de' | 'en' | 'fr' | 'nl') | null;
  /**
   * Owner's verified full name. Values are verified or provided by Bancontact directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

export type payment_method_details_blik = {
  [key: string]: unknown;
};

export type payment_method_details_boleto = {
  /**
   * The tax ID of the customer (CPF for individuals consumers or CNPJ for businesses consumers)
   */
  tax_id: string;
};

export type payment_method_details_card = {
  /**
   * The authorized amount.
   */
  amount_authorized?: number | null;
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand?: string | null;
  /**
   * When using manual capture, a future timestamp at which the charge will be automatically refunded if uncaptured.
   */
  capture_before?: number;
  /**
   * Check results by Card networks on Card address and CVC at time of payment.
   */
  checks?: payment_method_details_card_checks | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  extended_authorization?: payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_extended_authorization_extended_authorization;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  incremental_authorization?: payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_incremental_authorization_incremental_authorization;
  /**
   * Installment details for this payment (Mexico only).
   *
   * For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
   */
  installments?: payment_method_details_card_installments | null;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment or created by it.
   */
  mandate?: string | null;
  multicapture?: payment_flows_private_payment_methods_card_details_api_resource_multicapture;
  /**
   * Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  network?: string | null;
  /**
   * If this card has network token credentials, this contains the details of the network token credentials.
   */
  network_token?: payment_method_details_card_network_token | null;
  overcapture?: payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_overcapture_overcapture;
  /**
   * Populated if this transaction used 3D Secure authentication.
   */
  three_d_secure?: three_d_secure_details_charge | null;
  /**
   * If this Card is part of a card wallet, this contains the details of the card wallet.
   */
  wallet?: payment_method_details_card_wallet | null;
};

export type payment_method_details_card_checks = {
  /**
   * If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_line1_check?: string | null;
  /**
   * If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_postal_code_check?: string | null;
  /**
   * If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  cvc_check?: string | null;
};

export type payment_method_details_card_installments = {
  /**
   * Installment plan selected for the payment.
   */
  plan?: payment_method_details_card_installments_plan | null;
};

export type payment_method_details_card_installments_plan = {
  /**
   * For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.
   */
  count?: number | null;
  /**
   * For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.
   * One of `month`.
   */
  interval?: 'month' | null;
  /**
   * Type of installment plan, one of `fixed_count`.
   */
  type: 'fixed_count';
};

/**
 * For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.
 * One of `month`.
 */
export type interval2 = 'month';

/**
 * Type of installment plan, one of `fixed_count`.
 */
export type type41 = 'fixed_count';

export type payment_method_details_card_network_token = {
  /**
   * Indicates if Stripe used a network token, either user provided or Stripe managed when processing the transaction.
   */
  used: boolean;
};

export type payment_method_details_card_present = {
  /**
   * The authorized amount
   */
  amount_authorized?: number | null;
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand?: string | null;
  /**
   * When using manual capture, a future timestamp after which the charge will be automatically refunded if uncaptured.
   */
  capture_before?: number;
  /**
   * The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.
   */
  cardholder_name?: string | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Authorization response cryptogram.
   */
  emv_auth_data?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  /**
   * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.
   */
  generated_card?: string | null;
  /**
   * Whether this [PaymentIntent](https://stripe.com/docs/api/payment_intents) is eligible for incremental authorizations. Request support using [request_incremental_authorization_support](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-payment_method_options-card_present-request_incremental_authorization_support).
   */
  incremental_authorization_supported: boolean;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  network?: string | null;
  /**
   * Details about payments collected offline.
   */
  offline?: payment_method_details_card_present_offline | null;
  /**
   * Defines whether the authorized amount can be over-captured or not
   */
  overcapture_supported: boolean;
  /**
   * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
   */
  preferred_locales?: Array<string> | null;
  /**
   * How card details were read in this transaction.
   */
  read_method?:
    | (
        | 'contact_emv'
        | 'contactless_emv'
        | 'contactless_magstripe_mode'
        | 'magnetic_stripe_fallback'
        | 'magnetic_stripe_track2'
      )
    | null;
  /**
   * A collection of fields required to be displayed on receipts. Only required for EMV transactions.
   */
  receipt?: payment_method_details_card_present_receipt | null;
};

export type payment_method_details_card_present_offline = {
  /**
   * Time at which the payment was collected while offline
   */
  stored_at?: number | null;
};

export type payment_method_details_card_present_receipt = {
  /**
   * The type of account being debited or credited
   */
  account_type?: 'checking' | 'credit' | 'prepaid' | 'unknown';
  /**
   * EMV tag 9F26, cryptogram generated by the integrated circuit chip.
   */
  application_cryptogram?: string | null;
  /**
   * Mnenomic of the Application Identifier.
   */
  application_preferred_name?: string | null;
  /**
   * Identifier for this transaction.
   */
  authorization_code?: string | null;
  /**
   * EMV tag 8A. A code returned by the card issuer.
   */
  authorization_response_code?: string | null;
  /**
   * Describes the method used by the cardholder to verify ownership of the card. One of the following: `approval`, `failure`, `none`, `offline_pin`, `offline_pin_and_signature`, `online_pin`, or `signature`.
   */
  cardholder_verification_method?: string | null;
  /**
   * EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.
   */
  dedicated_file_name?: string | null;
  /**
   * The outcome of a series of EMV functions performed by the card reader.
   */
  terminal_verification_results?: string | null;
  /**
   * An indication of various EMV functions performed during the transaction.
   */
  transaction_status_information?: string | null;
};

/**
 * The type of account being debited or credited
 */
export type account_type2 = 'checking' | 'credit' | 'prepaid' | 'unknown';

export type payment_method_details_card_wallet = {
  amex_express_checkout?: payment_method_details_card_wallet_amex_express_checkout;
  apple_pay?: payment_method_details_card_wallet_apple_pay;
  /**
   * (For tokenized numbers only.) The last four digits of the device account number.
   */
  dynamic_last4?: string | null;
  google_pay?: payment_method_details_card_wallet_google_pay;
  link?: payment_method_details_card_wallet_link;
  masterpass?: payment_method_details_card_wallet_masterpass;
  samsung_pay?: payment_method_details_card_wallet_samsung_pay;
  /**
   * The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, `visa_checkout`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.
   */
  type: 'amex_express_checkout' | 'apple_pay' | 'google_pay' | 'link' | 'masterpass' | 'samsung_pay' | 'visa_checkout';
  visa_checkout?: payment_method_details_card_wallet_visa_checkout;
};

export type payment_method_details_card_wallet_amex_express_checkout = {
  [key: string]: unknown;
};

export type payment_method_details_card_wallet_apple_pay = {
  [key: string]: unknown;
};

export type payment_method_details_card_wallet_google_pay = {
  [key: string]: unknown;
};

export type payment_method_details_card_wallet_link = {
  [key: string]: unknown;
};

export type payment_method_details_card_wallet_masterpass = {
  /**
   * Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  billing_address?: address | null;
  /**
   * Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  email?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  name?: string | null;
  /**
   * Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  shipping_address?: address | null;
};

export type payment_method_details_card_wallet_samsung_pay = {
  [key: string]: unknown;
};

export type payment_method_details_card_wallet_visa_checkout = {
  /**
   * Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  billing_address?: address | null;
  /**
   * Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  email?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  name?: string | null;
  /**
   * Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  shipping_address?: address | null;
};

export type payment_method_details_cashapp = {
  /**
   * A unique and immutable identifier assigned by Cash App to every buyer.
   */
  buyer_id?: string | null;
  /**
   * A public identifier for buyers using Cash App.
   */
  cashtag?: string | null;
};

export type payment_method_details_customer_balance = {
  [key: string]: unknown;
};

export type payment_method_details_eps = {
  /**
   * The customer's bank. Should be one of `arzte_und_apotheker_bank`, `austrian_anadi_bank_ag`, `bank_austria`, `bankhaus_carl_spangler`, `bankhaus_schelhammer_und_schattera_ag`, `bawag_psk_ag`, `bks_bank_ag`, `brull_kallmus_bank_ag`, `btv_vier_lander_bank`, `capital_bank_grawe_gruppe_ag`, `deutsche_bank_ag`, `dolomitenbank`, `easybank_ag`, `erste_bank_und_sparkassen`, `hypo_alpeadriabank_international_ag`, `hypo_noe_lb_fur_niederosterreich_u_wien`, `hypo_oberosterreich_salzburg_steiermark`, `hypo_tirol_bank_ag`, `hypo_vorarlberg_bank_ag`, `hypo_bank_burgenland_aktiengesellschaft`, `marchfelder_bank`, `oberbank_ag`, `raiffeisen_bankengruppe_osterreich`, `schoellerbank_ag`, `sparda_bank_wien`, `volksbank_gruppe`, `volkskreditbank_ag`, or `vr_bank_braunau`.
   */
  bank?:
    | (
        | 'arzte_und_apotheker_bank'
        | 'austrian_anadi_bank_ag'
        | 'bank_austria'
        | 'bankhaus_carl_spangler'
        | 'bankhaus_schelhammer_und_schattera_ag'
        | 'bawag_psk_ag'
        | 'bks_bank_ag'
        | 'brull_kallmus_bank_ag'
        | 'btv_vier_lander_bank'
        | 'capital_bank_grawe_gruppe_ag'
        | 'deutsche_bank_ag'
        | 'dolomitenbank'
        | 'easybank_ag'
        | 'erste_bank_und_sparkassen'
        | 'hypo_alpeadriabank_international_ag'
        | 'hypo_bank_burgenland_aktiengesellschaft'
        | 'hypo_noe_lb_fur_niederosterreich_u_wien'
        | 'hypo_oberosterreich_salzburg_steiermark'
        | 'hypo_tirol_bank_ag'
        | 'hypo_vorarlberg_bank_ag'
        | 'marchfelder_bank'
        | 'oberbank_ag'
        | 'raiffeisen_bankengruppe_osterreich'
        | 'schoellerbank_ag'
        | 'sparda_bank_wien'
        | 'volksbank_gruppe'
        | 'volkskreditbank_ag'
        | 'vr_bank_braunau'
      )
    | null;
  /**
   * Owner's verified full name. Values are verified or provided by EPS directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   * EPS rarely provides this information so the attribute is usually empty.
   */
  verified_name?: string | null;
};

/**
 * The customer's bank. Should be one of `arzte_und_apotheker_bank`, `austrian_anadi_bank_ag`, `bank_austria`, `bankhaus_carl_spangler`, `bankhaus_schelhammer_und_schattera_ag`, `bawag_psk_ag`, `bks_bank_ag`, `brull_kallmus_bank_ag`, `btv_vier_lander_bank`, `capital_bank_grawe_gruppe_ag`, `deutsche_bank_ag`, `dolomitenbank`, `easybank_ag`, `erste_bank_und_sparkassen`, `hypo_alpeadriabank_international_ag`, `hypo_noe_lb_fur_niederosterreich_u_wien`, `hypo_oberosterreich_salzburg_steiermark`, `hypo_tirol_bank_ag`, `hypo_vorarlberg_bank_ag`, `hypo_bank_burgenland_aktiengesellschaft`, `marchfelder_bank`, `oberbank_ag`, `raiffeisen_bankengruppe_osterreich`, `schoellerbank_ag`, `sparda_bank_wien`, `volksbank_gruppe`, `volkskreditbank_ag`, or `vr_bank_braunau`.
 */
export type bank =
  | 'arzte_und_apotheker_bank'
  | 'austrian_anadi_bank_ag'
  | 'bank_austria'
  | 'bankhaus_carl_spangler'
  | 'bankhaus_schelhammer_und_schattera_ag'
  | 'bawag_psk_ag'
  | 'bks_bank_ag'
  | 'brull_kallmus_bank_ag'
  | 'btv_vier_lander_bank'
  | 'capital_bank_grawe_gruppe_ag'
  | 'deutsche_bank_ag'
  | 'dolomitenbank'
  | 'easybank_ag'
  | 'erste_bank_und_sparkassen'
  | 'hypo_alpeadriabank_international_ag'
  | 'hypo_bank_burgenland_aktiengesellschaft'
  | 'hypo_noe_lb_fur_niederosterreich_u_wien'
  | 'hypo_oberosterreich_salzburg_steiermark'
  | 'hypo_tirol_bank_ag'
  | 'hypo_vorarlberg_bank_ag'
  | 'marchfelder_bank'
  | 'oberbank_ag'
  | 'raiffeisen_bankengruppe_osterreich'
  | 'schoellerbank_ag'
  | 'sparda_bank_wien'
  | 'volksbank_gruppe'
  | 'volkskreditbank_ag'
  | 'vr_bank_braunau';

export type payment_method_details_fpx = {
  /**
   * The customer's bank. Can be one of `affin_bank`, `agrobank`, `alliance_bank`, `ambank`, `bank_islam`, `bank_muamalat`, `bank_rakyat`, `bsn`, `cimb`, `hong_leong_bank`, `hsbc`, `kfh`, `maybank2u`, `ocbc`, `public_bank`, `rhb`, `standard_chartered`, `uob`, `deutsche_bank`, `maybank2e`, `pb_enterprise`, or `bank_of_china`.
   */
  bank:
    | 'affin_bank'
    | 'agrobank'
    | 'alliance_bank'
    | 'ambank'
    | 'bank_islam'
    | 'bank_muamalat'
    | 'bank_of_china'
    | 'bank_rakyat'
    | 'bsn'
    | 'cimb'
    | 'deutsche_bank'
    | 'hong_leong_bank'
    | 'hsbc'
    | 'kfh'
    | 'maybank2e'
    | 'maybank2u'
    | 'ocbc'
    | 'pb_enterprise'
    | 'public_bank'
    | 'rhb'
    | 'standard_chartered'
    | 'uob';
  /**
   * Unique transaction id generated by FPX for every request from the merchant
   */
  transaction_id?: string | null;
};

/**
 * The customer's bank. Can be one of `affin_bank`, `agrobank`, `alliance_bank`, `ambank`, `bank_islam`, `bank_muamalat`, `bank_rakyat`, `bsn`, `cimb`, `hong_leong_bank`, `hsbc`, `kfh`, `maybank2u`, `ocbc`, `public_bank`, `rhb`, `standard_chartered`, `uob`, `deutsche_bank`, `maybank2e`, `pb_enterprise`, or `bank_of_china`.
 */
export type bank2 =
  | 'affin_bank'
  | 'agrobank'
  | 'alliance_bank'
  | 'ambank'
  | 'bank_islam'
  | 'bank_muamalat'
  | 'bank_of_china'
  | 'bank_rakyat'
  | 'bsn'
  | 'cimb'
  | 'deutsche_bank'
  | 'hong_leong_bank'
  | 'hsbc'
  | 'kfh'
  | 'maybank2e'
  | 'maybank2u'
  | 'ocbc'
  | 'pb_enterprise'
  | 'public_bank'
  | 'rhb'
  | 'standard_chartered'
  | 'uob';

export type payment_method_details_giropay = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Bank Identifier Code of the bank associated with the bank account.
   */
  bic?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by Giropay directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   * Giropay rarely provides this information so the attribute is usually empty.
   */
  verified_name?: string | null;
};

export type payment_method_details_grabpay = {
  /**
   * Unique transaction id generated by GrabPay
   */
  transaction_id?: string | null;
};

export type payment_method_details_ideal = {
  /**
   * The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.
   */
  bank?:
    | (
        | 'abn_amro'
        | 'asn_bank'
        | 'bunq'
        | 'handelsbanken'
        | 'ing'
        | 'knab'
        | 'moneyou'
        | 'n26'
        | 'nn'
        | 'rabobank'
        | 'regiobank'
        | 'revolut'
        | 'sns_bank'
        | 'triodos_bank'
        | 'van_lanschot'
        | 'yoursafe'
      )
    | null;
  /**
   * The Bank Identifier Code of the customer's bank.
   */
  bic?:
    | (
        | 'ABNANL2A'
        | 'ASNBNL21'
        | 'BITSNL2A'
        | 'BUNQNL2A'
        | 'FVLBNL22'
        | 'HANDNL2A'
        | 'INGBNL2A'
        | 'KNABNL2H'
        | 'MOYONL21'
        | 'NNBANL2G'
        | 'NTSBDEB1'
        | 'RABONL2U'
        | 'RBRBNL21'
        | 'REVOIE23'
        | 'REVOLT21'
        | 'SNSBNL2A'
        | 'TRIONL2U'
      )
    | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by iDEAL directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

/**
 * The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.
 */
export type bank3 =
  | 'abn_amro'
  | 'asn_bank'
  | 'bunq'
  | 'handelsbanken'
  | 'ing'
  | 'knab'
  | 'moneyou'
  | 'n26'
  | 'nn'
  | 'rabobank'
  | 'regiobank'
  | 'revolut'
  | 'sns_bank'
  | 'triodos_bank'
  | 'van_lanschot'
  | 'yoursafe';

/**
 * The Bank Identifier Code of the customer's bank.
 */
export type bic =
  | 'ABNANL2A'
  | 'ASNBNL21'
  | 'BITSNL2A'
  | 'BUNQNL2A'
  | 'FVLBNL22'
  | 'HANDNL2A'
  | 'INGBNL2A'
  | 'KNABNL2H'
  | 'MOYONL21'
  | 'NNBANL2G'
  | 'NTSBDEB1'
  | 'RABONL2U'
  | 'RBRBNL21'
  | 'REVOIE23'
  | 'REVOLT21'
  | 'SNSBNL2A'
  | 'TRIONL2U';

export type payment_method_details_interac_present = {
  /**
   * Card brand. Can be `interac`, `mastercard` or `visa`.
   */
  brand?: string | null;
  /**
   * The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.
   */
  cardholder_name?: string | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Authorization response cryptogram.
   */
  emv_auth_data?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  /**
   * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.
   */
  generated_card?: string | null;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  network?: string | null;
  /**
   * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
   */
  preferred_locales?: Array<string> | null;
  /**
   * How card details were read in this transaction.
   */
  read_method?:
    | (
        | 'contact_emv'
        | 'contactless_emv'
        | 'contactless_magstripe_mode'
        | 'magnetic_stripe_fallback'
        | 'magnetic_stripe_track2'
      )
    | null;
  /**
   * A collection of fields required to be displayed on receipts. Only required for EMV transactions.
   */
  receipt?: payment_method_details_interac_present_receipt | null;
};

export type payment_method_details_interac_present_receipt = {
  /**
   * The type of account being debited or credited
   */
  account_type?: 'checking' | 'savings' | 'unknown';
  /**
   * EMV tag 9F26, cryptogram generated by the integrated circuit chip.
   */
  application_cryptogram?: string | null;
  /**
   * Mnenomic of the Application Identifier.
   */
  application_preferred_name?: string | null;
  /**
   * Identifier for this transaction.
   */
  authorization_code?: string | null;
  /**
   * EMV tag 8A. A code returned by the card issuer.
   */
  authorization_response_code?: string | null;
  /**
   * Describes the method used by the cardholder to verify ownership of the card. One of the following: `approval`, `failure`, `none`, `offline_pin`, `offline_pin_and_signature`, `online_pin`, or `signature`.
   */
  cardholder_verification_method?: string | null;
  /**
   * EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.
   */
  dedicated_file_name?: string | null;
  /**
   * The outcome of a series of EMV functions performed by the card reader.
   */
  terminal_verification_results?: string | null;
  /**
   * An indication of various EMV functions performed during the transaction.
   */
  transaction_status_information?: string | null;
};

/**
 * The type of account being debited or credited
 */
export type account_type3 = 'checking' | 'savings' | 'unknown';

export type payment_method_details_klarna = {
  /**
   * The Klarna payment method used for this transaction.
   * Can be one of `pay_later`, `pay_now`, `pay_with_financing`, or `pay_in_installments`
   */
  payment_method_category?: string | null;
  /**
   * Preferred language of the Klarna authorization page that the customer is redirected to.
   * Can be one of `de-AT`, `en-AT`, `nl-BE`, `fr-BE`, `en-BE`, `de-DE`, `en-DE`, `da-DK`, `en-DK`, `es-ES`, `en-ES`, `fi-FI`, `sv-FI`, `en-FI`, `en-GB`, `en-IE`, `it-IT`, `en-IT`, `nl-NL`, `en-NL`, `nb-NO`, `en-NO`, `sv-SE`, `en-SE`, `en-US`, `es-US`, `fr-FR`, `en-FR`, `cs-CZ`, `en-CZ`, `ro-RO`, `en-RO`, `el-GR`, `en-GR`, `en-AU`, `en-NZ`, `en-CA`, `fr-CA`, `pl-PL`, `en-PL`, `pt-PT`, `en-PT`, `de-CH`, `fr-CH`, `it-CH`, or `en-CH`
   */
  preferred_locale?: string | null;
};

export type payment_method_details_konbini = {
  /**
   * If the payment succeeded, this contains the details of the convenience store where the payment was completed.
   */
  store?: payment_method_details_konbini_store | null;
};

export type payment_method_details_konbini_store = {
  /**
   * The name of the convenience store chain where the payment was completed.
   */
  chain?: ('familymart' | 'lawson' | 'ministop' | 'seicomart') | null;
};

/**
 * The name of the convenience store chain where the payment was completed.
 */
export type chain = 'familymart' | 'lawson' | 'ministop' | 'seicomart';

export type payment_method_details_link = {
  /**
   * Two-letter ISO code representing the funding source country beneath the Link payment.
   * You could use this attribute to get a sense of international fees.
   */
  country?: string | null;
};

export type payment_method_details_mobilepay = {
  /**
   * Internal card details
   */
  card?: internal_card | null;
};

export type payment_method_details_multibanco = {
  /**
   * Entity number associated with this Multibanco payment.
   */
  entity?: string | null;
  /**
   * Reference number associated with this Multibanco payment.
   */
  reference?: string | null;
};

export type payment_method_details_oxxo = {
  /**
   * OXXO reference number
   */
  number?: string | null;
};

export type payment_method_details_p24 = {
  /**
   * The customer's bank. Can be one of `ing`, `citi_handlowy`, `tmobile_usbugi_bankowe`, `plus_bank`, `etransfer_pocztowy24`, `banki_spbdzielcze`, `bank_nowy_bfg_sa`, `getin_bank`, `velobank`, `blik`, `noble_pay`, `ideabank`, `envelobank`, `santander_przelew24`, `nest_przelew`, `mbank_mtransfer`, `inteligo`, `pbac_z_ipko`, `bnp_paribas`, `credit_agricole`, `toyota_bank`, `bank_pekao_sa`, `volkswagen_bank`, `bank_millennium`, `alior_bank`, or `boz`.
   */
  bank?:
    | (
        | 'alior_bank'
        | 'bank_millennium'
        | 'bank_nowy_bfg_sa'
        | 'bank_pekao_sa'
        | 'banki_spbdzielcze'
        | 'blik'
        | 'bnp_paribas'
        | 'boz'
        | 'citi_handlowy'
        | 'credit_agricole'
        | 'envelobank'
        | 'etransfer_pocztowy24'
        | 'getin_bank'
        | 'ideabank'
        | 'ing'
        | 'inteligo'
        | 'mbank_mtransfer'
        | 'nest_przelew'
        | 'noble_pay'
        | 'pbac_z_ipko'
        | 'plus_bank'
        | 'santander_przelew24'
        | 'tmobile_usbugi_bankowe'
        | 'toyota_bank'
        | 'velobank'
        | 'volkswagen_bank'
      )
    | null;
  /**
   * Unique reference for this Przelewy24 payment.
   */
  reference?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by Przelewy24 directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   * Przelewy24 rarely provides this information so the attribute is usually empty.
   */
  verified_name?: string | null;
};

/**
 * The customer's bank. Can be one of `ing`, `citi_handlowy`, `tmobile_usbugi_bankowe`, `plus_bank`, `etransfer_pocztowy24`, `banki_spbdzielcze`, `bank_nowy_bfg_sa`, `getin_bank`, `velobank`, `blik`, `noble_pay`, `ideabank`, `envelobank`, `santander_przelew24`, `nest_przelew`, `mbank_mtransfer`, `inteligo`, `pbac_z_ipko`, `bnp_paribas`, `credit_agricole`, `toyota_bank`, `bank_pekao_sa`, `volkswagen_bank`, `bank_millennium`, `alior_bank`, or `boz`.
 */
export type bank4 =
  | 'alior_bank'
  | 'bank_millennium'
  | 'bank_nowy_bfg_sa'
  | 'bank_pekao_sa'
  | 'banki_spbdzielcze'
  | 'blik'
  | 'bnp_paribas'
  | 'boz'
  | 'citi_handlowy'
  | 'credit_agricole'
  | 'envelobank'
  | 'etransfer_pocztowy24'
  | 'getin_bank'
  | 'ideabank'
  | 'ing'
  | 'inteligo'
  | 'mbank_mtransfer'
  | 'nest_przelew'
  | 'noble_pay'
  | 'pbac_z_ipko'
  | 'plus_bank'
  | 'santander_przelew24'
  | 'tmobile_usbugi_bankowe'
  | 'toyota_bank'
  | 'velobank'
  | 'volkswagen_bank';

export type payment_method_details_paynow = {
  /**
   * Reference number associated with this PayNow payment
   */
  reference?: string | null;
};

export type payment_method_details_paypal = {
  /**
   * Owner's email. Values are provided by PayPal directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  payer_email?: string | null;
  /**
   * PayPal account PayerID. This identifier uniquely identifies the PayPal customer.
   */
  payer_id?: string | null;
  /**
   * Owner's full name. Values provided by PayPal directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  payer_name?: string | null;
  /**
   * The level of protection offered as defined by PayPal Seller Protection for Merchants, for this transaction.
   */
  seller_protection?: paypal_seller_protection | null;
  /**
   * A unique ID generated by PayPal for this transaction.
   */
  transaction_id?: string | null;
};

export type payment_method_details_pix = {
  /**
   * Unique transaction id generated by BCB
   */
  bank_transaction_id?: string | null;
};

export type payment_method_details_promptpay = {
  /**
   * Bill reference generated by PromptPay
   */
  reference?: string | null;
};

export type payment_method_details_revolut_pay = {
  [key: string]: unknown;
};

export type payment_method_details_sepa_debit = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Branch code of bank associated with the bank account.
   */
  branch_code?: string | null;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four characters of the IBAN.
   */
  last4?: string | null;
  /**
   * Find the ID of the mandate used for this payment under the [payment_method_details.sepa_debit.mandate](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-sepa_debit-mandate) property on the Charge. Use this mandate ID to [retrieve the Mandate](https://stripe.com/docs/api/mandates/retrieve).
   */
  mandate?: string | null;
};

export type payment_method_details_sofort = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Bank Identifier Code of the bank associated with the bank account.
   */
  bic?: string | null;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country?: string | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Preferred language of the SOFORT authorization page that the customer is redirected to.
   * Can be one of `de`, `en`, `es`, `fr`, `it`, `nl`, or `pl`
   */
  preferred_language?: ('de' | 'en' | 'es' | 'fr' | 'it' | 'nl' | 'pl') | null;
  /**
   * Owner's verified full name. Values are verified or provided by SOFORT directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

/**
 * Preferred language of the SOFORT authorization page that the customer is redirected to.
 * Can be one of `de`, `en`, `es`, `fr`, `it`, `nl`, or `pl`
 */
export type preferred_language2 = 'de' | 'en' | 'es' | 'fr' | 'it' | 'nl' | 'pl';

export type payment_method_details_stripe_account = {
  [key: string]: unknown;
};

export type payment_method_details_swish = {
  /**
   * Uniquely identifies the payer's Swish account. You can use this attribute to check whether two Swish transactions were paid for by the same payer
   */
  fingerprint?: string | null;
  /**
   * Payer bank reference number for the payment
   */
  payment_reference?: string | null;
  /**
   * The last four digits of the Swish account phone number
   */
  verified_phone_last4?: string | null;
};

export type payment_method_details_twint = {
  [key: string]: unknown;
};

export type payment_method_details_us_bank_account = {
  /**
   * Account holder type: individual or company.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Account type: checkings or savings. Defaults to checking if omitted.
   */
  account_type?: ('checking' | 'savings') | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * ID of the mandate used to make this payment.
   */
  mandate?: string | mandate;
  /**
   * Reference number to locate ACH payments with customer's bank.
   */
  payment_reference?: string | null;
  /**
   * Routing number of the bank account.
   */
  routing_number?: string | null;
};

export type payment_method_details_wechat = {
  [key: string]: unknown;
};

export type payment_method_details_wechat_pay = {
  /**
   * Uniquely identifies this particular WeChat Pay account. You can use this attribute to check whether two WeChat accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Transaction ID of this particular WeChat Pay transaction.
   */
  transaction_id?: string | null;
};

export type payment_method_details_zip = {
  [key: string]: unknown;
};

/**
 * A payment method domain represents a web domain that you have registered with Stripe.
 * Stripe Elements use registered payment method domains to control where certain payment methods are shown.
 *
 * Related guides: [Payment method domains](https://stripe.com/docs/payments/payment-methods/pmd-registration).
 */
export type payment_method_domain = {
  apple_pay: payment_method_domain_resource_payment_method_status;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The domain name that this payment method domain object represents.
   */
  domain_name: string;
  /**
   * Whether this payment method domain is enabled. If the domain is not enabled, payment methods that require a payment method domain will not appear in Elements.
   */
  enabled: boolean;
  google_pay: payment_method_domain_resource_payment_method_status;
  /**
   * Unique identifier for the object.
   */
  id: string;
  link: payment_method_domain_resource_payment_method_status;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payment_method_domain';
  paypal: payment_method_domain_resource_payment_method_status;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object83 = 'payment_method_domain';

/**
 * Indicates the status of a specific payment method on a payment method domain.
 */
export type payment_method_domain_resource_payment_method_status = {
  /**
   * The status of the payment method on the domain.
   */
  status: 'active' | 'inactive';
  status_details?: payment_method_domain_resource_payment_method_status_details;
};

/**
 * Contains additional details about the status of a payment method for a specific payment method domain.
 */
export type payment_method_domain_resource_payment_method_status_details = {
  /**
   * The error message associated with the status of the payment method on the domain.
   */
  error_message: string;
};

export type payment_method_eps = {
  /**
   * The customer's bank. Should be one of `arzte_und_apotheker_bank`, `austrian_anadi_bank_ag`, `bank_austria`, `bankhaus_carl_spangler`, `bankhaus_schelhammer_und_schattera_ag`, `bawag_psk_ag`, `bks_bank_ag`, `brull_kallmus_bank_ag`, `btv_vier_lander_bank`, `capital_bank_grawe_gruppe_ag`, `deutsche_bank_ag`, `dolomitenbank`, `easybank_ag`, `erste_bank_und_sparkassen`, `hypo_alpeadriabank_international_ag`, `hypo_noe_lb_fur_niederosterreich_u_wien`, `hypo_oberosterreich_salzburg_steiermark`, `hypo_tirol_bank_ag`, `hypo_vorarlberg_bank_ag`, `hypo_bank_burgenland_aktiengesellschaft`, `marchfelder_bank`, `oberbank_ag`, `raiffeisen_bankengruppe_osterreich`, `schoellerbank_ag`, `sparda_bank_wien`, `volksbank_gruppe`, `volkskreditbank_ag`, or `vr_bank_braunau`.
   */
  bank?:
    | (
        | 'arzte_und_apotheker_bank'
        | 'austrian_anadi_bank_ag'
        | 'bank_austria'
        | 'bankhaus_carl_spangler'
        | 'bankhaus_schelhammer_und_schattera_ag'
        | 'bawag_psk_ag'
        | 'bks_bank_ag'
        | 'brull_kallmus_bank_ag'
        | 'btv_vier_lander_bank'
        | 'capital_bank_grawe_gruppe_ag'
        | 'deutsche_bank_ag'
        | 'dolomitenbank'
        | 'easybank_ag'
        | 'erste_bank_und_sparkassen'
        | 'hypo_alpeadriabank_international_ag'
        | 'hypo_bank_burgenland_aktiengesellschaft'
        | 'hypo_noe_lb_fur_niederosterreich_u_wien'
        | 'hypo_oberosterreich_salzburg_steiermark'
        | 'hypo_tirol_bank_ag'
        | 'hypo_vorarlberg_bank_ag'
        | 'marchfelder_bank'
        | 'oberbank_ag'
        | 'raiffeisen_bankengruppe_osterreich'
        | 'schoellerbank_ag'
        | 'sparda_bank_wien'
        | 'volksbank_gruppe'
        | 'volkskreditbank_ag'
        | 'vr_bank_braunau'
      )
    | null;
};

export type payment_method_fpx = {
  /**
   * The customer's bank, if provided. Can be one of `affin_bank`, `agrobank`, `alliance_bank`, `ambank`, `bank_islam`, `bank_muamalat`, `bank_rakyat`, `bsn`, `cimb`, `hong_leong_bank`, `hsbc`, `kfh`, `maybank2u`, `ocbc`, `public_bank`, `rhb`, `standard_chartered`, `uob`, `deutsche_bank`, `maybank2e`, `pb_enterprise`, or `bank_of_china`.
   */
  bank:
    | 'affin_bank'
    | 'agrobank'
    | 'alliance_bank'
    | 'ambank'
    | 'bank_islam'
    | 'bank_muamalat'
    | 'bank_of_china'
    | 'bank_rakyat'
    | 'bsn'
    | 'cimb'
    | 'deutsche_bank'
    | 'hong_leong_bank'
    | 'hsbc'
    | 'kfh'
    | 'maybank2e'
    | 'maybank2u'
    | 'ocbc'
    | 'pb_enterprise'
    | 'public_bank'
    | 'rhb'
    | 'standard_chartered'
    | 'uob';
};

export type payment_method_giropay = {
  [key: string]: unknown;
};

export type payment_method_grabpay = {
  [key: string]: unknown;
};

export type payment_method_ideal = {
  /**
   * The customer's bank, if provided. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.
   */
  bank?:
    | (
        | 'abn_amro'
        | 'asn_bank'
        | 'bunq'
        | 'handelsbanken'
        | 'ing'
        | 'knab'
        | 'moneyou'
        | 'n26'
        | 'nn'
        | 'rabobank'
        | 'regiobank'
        | 'revolut'
        | 'sns_bank'
        | 'triodos_bank'
        | 'van_lanschot'
        | 'yoursafe'
      )
    | null;
  /**
   * The Bank Identifier Code of the customer's bank, if the bank was provided.
   */
  bic?:
    | (
        | 'ABNANL2A'
        | 'ASNBNL21'
        | 'BITSNL2A'
        | 'BUNQNL2A'
        | 'FVLBNL22'
        | 'HANDNL2A'
        | 'INGBNL2A'
        | 'KNABNL2H'
        | 'MOYONL21'
        | 'NNBANL2G'
        | 'NTSBDEB1'
        | 'RABONL2U'
        | 'RBRBNL21'
        | 'REVOIE23'
        | 'REVOLT21'
        | 'SNSBNL2A'
        | 'TRIONL2U'
      )
    | null;
};

export type payment_method_interac_present = {
  /**
   * Card brand. Can be `interac`, `mastercard` or `visa`.
   */
  brand?: string | null;
  /**
   * The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.
   */
  cardholder_name?: string | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month: number;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year: number;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * Contains information about card networks that can be used to process the payment.
   */
  networks?: payment_method_card_present_networks | null;
  /**
   * EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.
   */
  preferred_locales?: Array<string> | null;
  /**
   * How card details were read in this transaction.
   */
  read_method?:
    | (
        | 'contact_emv'
        | 'contactless_emv'
        | 'contactless_magstripe_mode'
        | 'magnetic_stripe_fallback'
        | 'magnetic_stripe_track2'
      )
    | null;
};

export type payment_method_klarna = {
  /**
   * The customer's date of birth, if provided.
   */
  dob?: payment_flows_private_payment_methods_klarna_dob | null;
};

export type payment_method_konbini = {
  [key: string]: unknown;
};

export type payment_method_link = {
  /**
   * Account owner's email address.
   */
  email?: string | null;
};

export type payment_method_mobilepay = {
  [key: string]: unknown;
};

export type payment_method_multibanco = {
  [key: string]: unknown;
};

export type payment_method_options_affirm = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Preferred language of the Affirm authorization page that the customer is redirected to.
   */
  preferred_locale?: string;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_afterpay_clearpay = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * An internal identifier or reference that this payment corresponds to. You must limit the identifier to 128 characters, and it can only contain letters, numbers, underscores, backslashes, and dashes.
   * This field differs from the statement descriptor and item name.
   */
  reference?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_alipay = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_amazon_pay = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_bacs_debit = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type payment_method_options_bancontact = {
  /**
   * Preferred language of the Bancontact authorization page that the customer is redirected to.
   */
  preferred_language: 'de' | 'en' | 'fr' | 'nl';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_boleto = {
  /**
   * The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.
   */
  expires_after_days: number;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type payment_method_options_card_installments = {
  /**
   * Installment plans that may be selected for this PaymentIntent.
   */
  available_plans?: Array<payment_method_details_card_installments_plan> | null;
  /**
   * Whether Installments are enabled for this PaymentIntent.
   */
  enabled: boolean;
  /**
   * Installment plan selected for this PaymentIntent.
   */
  plan?: payment_method_details_card_installments_plan | null;
};

export type payment_method_options_card_mandate_options = {
  /**
   * Amount to be charged for future payments.
   */
  amount: number;
  /**
   * One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
   */
  amount_type: 'fixed' | 'maximum';
  /**
   * A description of the mandate or subscription that is meant to be displayed to the customer.
   */
  description?: string | null;
  /**
   * End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.
   */
  end_date?: number | null;
  /**
   * Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
   */
  interval: 'day' | 'month' | 'sporadic' | 'week' | 'year';
  /**
   * The number of intervals between payments. For example, `interval=month` and `interval_count=3` indicates one payment every three months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks). This parameter is optional when `interval=sporadic`.
   */
  interval_count?: number | null;
  /**
   * Unique identifier for the mandate or subscription.
   */
  reference: string;
  /**
   * Start date of the mandate or subscription. Start date should not be lesser than yesterday.
   */
  start_date: number;
  /**
   * Specifies the type of mandates supported. Possible values are `india`.
   */
  supported_types?: Array<'india'> | null;
};

/**
 * Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
 */
export type interval3 = 'day' | 'month' | 'sporadic' | 'week' | 'year';

export type payment_method_options_card_present = {
  /**
   * Request ability to capture this payment beyond the standard [authorization validity window](https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity)
   */
  request_extended_authorization?: boolean | null;
  /**
   * Request ability to [increment](https://stripe.com/docs/terminal/features/incremental-authorizations) this PaymentIntent if the combination of MCC and card brand is eligible. Check [incremental_authorization_supported](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported) in the [Confirm](https://stripe.com/docs/api/payment_intents/confirm) response to verify support.
   */
  request_incremental_authorization_support?: boolean | null;
  routing?: payment_method_options_card_present_routing;
};

export type payment_method_options_card_present_routing = {
  /**
   * Requested routing priority
   */
  requested_priority?: ('domestic' | 'international') | null;
};

/**
 * Requested routing priority
 */
export type requested_priority = 'domestic' | 'international';

export type payment_method_options_cashapp = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session' | 'on_session';
};

export type payment_method_options_customer_balance = {
  bank_transfer?: payment_method_options_customer_balance_bank_transfer;
  /**
   * The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
   */
  funding_type?: 'bank_transfer' | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_customer_balance_bank_transfer = {
  eu_bank_transfer?: payment_method_options_customer_balance_eu_bank_account;
  /**
   * List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.
   *
   * Permitted values include: `sort_code`, `zengin`, `iban`, or `spei`.
   */
  requested_address_types?: Array<'aba' | 'iban' | 'sepa' | 'sort_code' | 'spei' | 'swift' | 'zengin'>;
  /**
   * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
   */
  type?:
    | ('eu_bank_transfer' | 'gb_bank_transfer' | 'jp_bank_transfer' | 'mx_bank_transfer' | 'us_bank_transfer')
    | null;
};

export type payment_method_options_customer_balance_eu_bank_account = {
  /**
   * The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
   */
  country: 'BE' | 'DE' | 'ES' | 'FR' | 'IE' | 'NL';
};

export type payment_method_options_fpx = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_giropay = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_grabpay = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_ideal = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_interac_present = {
  [key: string]: unknown;
};

export type payment_method_options_klarna = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Preferred locale of the Klarna checkout page that the customer is redirected to.
   */
  preferred_locale?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_konbini = {
  /**
   * An optional 10 to 11 digit numeric-only string determining the confirmation code at applicable convenience stores.
   */
  confirmation_number?: string | null;
  /**
   * The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire. For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST.
   */
  expires_after_days?: number | null;
  /**
   * The timestamp at which the Konbini payment instructions will expire. Only one of `expires_after_days` or `expires_at` may be set.
   */
  expires_at?: number | null;
  /**
   * A product descriptor of up to 22 characters, which will appear to customers at the convenience store.
   */
  product_description?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_multibanco = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_oxxo = {
  /**
   * The number of calendar days before an OXXO invoice expires. For example, if you create an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.
   */
  expires_after_days: number;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_p24 = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_paynow = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_paypal = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Preferred locale of the PayPal checkout page that the customer is redirected to.
   */
  preferred_locale?: string | null;
  /**
   * A reference of the PayPal transaction visible to customer which is mapped to PayPal's invoice ID. This must be a globally unique ID if you have configured in your PayPal settings to block multiple payments per invoice ID.
   */
  reference?: string | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_pix = {
  /**
   * The number of seconds (between 10 and 1209600) after which Pix payment will expire.
   */
  expires_after_seconds?: number | null;
  /**
   * The timestamp at which the Pix expires.
   */
  expires_at?: number | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_promptpay = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_revolut_pay = {
  /**
   * Controls when the funds will be captured from the customer's account.
   */
  capture_method?: 'manual';
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_sofort = {
  /**
   * Preferred language of the SOFORT authorization page that the customer is redirected to.
   */
  preferred_language?: ('de' | 'en' | 'es' | 'fr' | 'it' | 'nl' | 'pl') | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none' | 'off_session';
};

export type payment_method_options_twint = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_options_us_bank_account_mandate_options = {
  /**
   * Mandate collection method
   */
  collection_method?: 'paper';
};

export type payment_method_options_wechat_pay = {
  /**
   * The app ID registered with WeChat Pay. Only required when client is ios or android.
   */
  app_id?: string | null;
  /**
   * The client type that the end customer will pay from
   */
  client?: ('android' | 'ios' | 'web') | null;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

/**
 * The client type that the end customer will pay from
 */
export type stripe_client = 'android' | 'ios' | 'web';

export type payment_method_options_zip = {
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
   *
   * When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
   */
  setup_future_usage?: 'none';
};

export type payment_method_oxxo = {
  [key: string]: unknown;
};

export type payment_method_p24 = {
  /**
   * The customer's bank, if provided.
   */
  bank?:
    | (
        | 'alior_bank'
        | 'bank_millennium'
        | 'bank_nowy_bfg_sa'
        | 'bank_pekao_sa'
        | 'banki_spbdzielcze'
        | 'blik'
        | 'bnp_paribas'
        | 'boz'
        | 'citi_handlowy'
        | 'credit_agricole'
        | 'envelobank'
        | 'etransfer_pocztowy24'
        | 'getin_bank'
        | 'ideabank'
        | 'ing'
        | 'inteligo'
        | 'mbank_mtransfer'
        | 'nest_przelew'
        | 'noble_pay'
        | 'pbac_z_ipko'
        | 'plus_bank'
        | 'santander_przelew24'
        | 'tmobile_usbugi_bankowe'
        | 'toyota_bank'
        | 'velobank'
        | 'volkswagen_bank'
      )
    | null;
};

export type payment_method_paynow = {
  [key: string]: unknown;
};

export type payment_method_paypal = {
  /**
   * Owner's email. Values are provided by PayPal directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  payer_email?: string | null;
  /**
   * PayPal account PayerID. This identifier uniquely identifies the PayPal customer.
   */
  payer_id?: string | null;
};

export type payment_method_pix = {
  [key: string]: unknown;
};

export type payment_method_promptpay = {
  [key: string]: unknown;
};

export type payment_method_revolut_pay = {
  [key: string]: unknown;
};

export type payment_method_sepa_debit = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Branch code of bank associated with the bank account.
   */
  branch_code?: string | null;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Information about the object that generated this PaymentMethod.
   */
  generated_from?: sepa_debit_generated_from | null;
  /**
   * Last four characters of the IBAN.
   */
  last4?: string | null;
};

export type payment_method_sofort = {
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  country?: string | null;
};

export type payment_method_swish = {
  [key: string]: unknown;
};

export type payment_method_twint = {
  [key: string]: unknown;
};

export type payment_method_us_bank_account = {
  /**
   * Account holder type: individual or company.
   */
  account_holder_type?: ('company' | 'individual') | null;
  /**
   * Account type: checkings or savings. Defaults to checking if omitted.
   */
  account_type?: ('checking' | 'savings') | null;
  /**
   * The name of the bank.
   */
  bank_name?: string | null;
  /**
   * The ID of the Financial Connections Account used to create the payment method.
   */
  financial_connections_account?: string | null;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.
   */
  fingerprint?: string | null;
  /**
   * Last four digits of the bank account number.
   */
  last4?: string | null;
  /**
   * Contains information about US bank account networks that can be used.
   */
  networks?: us_bank_account_networks | null;
  /**
   * Routing number of the bank account.
   */
  routing_number?: string | null;
  /**
   * Contains information about the future reusability of this PaymentMethod.
   */
  status_details?: payment_method_us_bank_account_status_details | null;
};

export type payment_method_us_bank_account_blocked = {
  /**
   * The ACH network code that resulted in this block.
   */
  network_code?: ('R02' | 'R03' | 'R04' | 'R05' | 'R07' | 'R08' | 'R10' | 'R11' | 'R16' | 'R20' | 'R29' | 'R31') | null;
  /**
   * The reason why this PaymentMethod's fingerprint has been blocked
   */
  reason?:
    | (
        | 'bank_account_closed'
        | 'bank_account_frozen'
        | 'bank_account_invalid_details'
        | 'bank_account_restricted'
        | 'bank_account_unusable'
        | 'debit_not_authorized'
      )
    | null;
};

/**
 * The ACH network code that resulted in this block.
 */
export type network_code =
  | 'R02'
  | 'R03'
  | 'R04'
  | 'R05'
  | 'R07'
  | 'R08'
  | 'R10'
  | 'R11'
  | 'R16'
  | 'R20'
  | 'R29'
  | 'R31';

/**
 * The reason why this PaymentMethod's fingerprint has been blocked
 */
export type reason5 =
  | 'bank_account_closed'
  | 'bank_account_frozen'
  | 'bank_account_invalid_details'
  | 'bank_account_restricted'
  | 'bank_account_unusable'
  | 'debit_not_authorized';

export type payment_method_us_bank_account_status_details = {
  blocked?: payment_method_us_bank_account_blocked;
};

export type payment_method_wechat_pay = {
  [key: string]: unknown;
};

export type payment_method_zip = {
  [key: string]: unknown;
};

export type payment_pages_checkout_session_after_expiration = {
  /**
   * When set, configuration used to recover the Checkout Session on expiry.
   */
  recovery?: payment_pages_checkout_session_after_expiration_recovery | null;
};

export type payment_pages_checkout_session_after_expiration_recovery = {
  /**
   * Enables user redeemable promotion codes on the recovered Checkout Sessions. Defaults to `false`
   */
  allow_promotion_codes: boolean;
  /**
   * If `true`, a recovery url will be generated to recover this Checkout Session if it
   * expires before a transaction is completed. It will be attached to the
   * Checkout Session object upon expiration.
   */
  enabled: boolean;
  /**
   * The timestamp at which the recovery URL will expire.
   */
  expires_at?: number | null;
  /**
   * URL that creates a new Checkout Session when clicked that is a copy of this expired Checkout Session
   */
  url?: string | null;
};

export type payment_pages_checkout_session_automatic_tax = {
  /**
   * Indicates whether automatic tax is enabled for the session
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
  /**
   * The status of the most recent automated tax calculation for this session.
   */
  status?: ('complete' | 'failed' | 'requires_location_inputs') | null;
};

export type payment_pages_checkout_session_consent = {
  /**
   * If `opt_in`, the customer consents to receiving promotional communications
   * from the merchant about this Checkout Session.
   */
  promotions?: ('opt_in' | 'opt_out') | null;
  /**
   * If `accepted`, the customer in this Checkout Session has agreed to the merchant's terms of service.
   */
  terms_of_service?: 'accepted' | null;
};

/**
 * If `opt_in`, the customer consents to receiving promotional communications
 * from the merchant about this Checkout Session.
 */
export type promotions2 = 'opt_in' | 'opt_out';

/**
 * If `accepted`, the customer in this Checkout Session has agreed to the merchant's terms of service.
 */
export type terms_of_service2 = 'accepted';

export type payment_pages_checkout_session_consent_collection = {
  /**
   * If set to `hidden`, it will hide legal text related to the reuse of a payment method.
   */
  payment_method_reuse_agreement?: payment_pages_checkout_session_payment_method_reuse_agreement | null;
  /**
   * If set to `auto`, enables the collection of customer consent for promotional communications. The Checkout
   * Session will determine whether to display an option to opt into promotional communication
   * from the merchant depending on the customer's locale. Only available to US merchants.
   */
  promotions?: ('auto' | 'none') | null;
  /**
   * If set to `required`, it requires customers to accept the terms of service before being able to pay.
   */
  terms_of_service?: ('none' | 'required') | null;
};

export type payment_pages_checkout_session_currency_conversion = {
  /**
   * Total of all items in source currency before discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total of all items in source currency after discounts and taxes are applied.
   */
  amount_total: number;
  /**
   * Exchange rate used to convert source currency amounts to customer currency amounts
   */
  fx_rate: string;
  /**
   * Creation currency of the CheckoutSession before localization
   */
  source_currency: string;
};

export type payment_pages_checkout_session_custom_fields = {
  dropdown?: payment_pages_checkout_session_custom_fields_dropdown;
  /**
   * String of your choice that your integration can use to reconcile this field. Must be unique to this field, alphanumeric, and up to 200 characters.
   */
  key: string;
  label: payment_pages_checkout_session_custom_fields_label;
  numeric?: payment_pages_checkout_session_custom_fields_numeric;
  /**
   * Whether the customer is required to complete the field before completing the Checkout Session. Defaults to `false`.
   */
  optional: boolean;
  text?: payment_pages_checkout_session_custom_fields_text;
  /**
   * The type of the field.
   */
  type: 'dropdown' | 'numeric' | 'text';
};

export type payment_pages_checkout_session_custom_fields_dropdown = {
  /**
   * The value that will pre-fill on the payment page.
   */
  default_value?: string | null;
  /**
   * The options available for the customer to select. Up to 200 options allowed.
   */
  options: Array<payment_pages_checkout_session_custom_fields_option>;
  /**
   * The option selected by the customer. This will be the `value` for the option.
   */
  value?: string | null;
};

export type payment_pages_checkout_session_custom_fields_label = {
  /**
   * Custom text for the label, displayed to the customer. Up to 50 characters.
   */
  custom?: string | null;
  /**
   * The type of the label.
   */
  type: 'custom';
};

export type payment_pages_checkout_session_custom_fields_numeric = {
  /**
   * The value that will pre-fill the field on the payment page.
   */
  default_value?: string | null;
  /**
   * The maximum character length constraint for the customer's input.
   */
  maximum_length?: number | null;
  /**
   * The minimum character length requirement for the customer's input.
   */
  minimum_length?: number | null;
  /**
   * The value entered by the customer, containing only digits.
   */
  value?: string | null;
};

export type payment_pages_checkout_session_custom_fields_option = {
  /**
   * The label for the option, displayed to the customer. Up to 100 characters.
   */
  label: string;
  /**
   * The value for this option, not displayed to the customer, used by your integration to reconcile the option selected by the customer. Must be unique to this option, alphanumeric, and up to 100 characters.
   */
  value: string;
};

export type payment_pages_checkout_session_custom_fields_text = {
  /**
   * The value that will pre-fill the field on the payment page.
   */
  default_value?: string | null;
  /**
   * The maximum character length constraint for the customer's input.
   */
  maximum_length?: number | null;
  /**
   * The minimum character length requirement for the customer's input.
   */
  minimum_length?: number | null;
  /**
   * The value entered by the customer.
   */
  value?: string | null;
};

export type payment_pages_checkout_session_custom_text = {
  /**
   * Custom text that should be displayed after the payment confirmation button.
   */
  after_submit?: payment_pages_checkout_session_custom_text_position | null;
  /**
   * Custom text that should be displayed alongside shipping address collection.
   */
  shipping_address?: payment_pages_checkout_session_custom_text_position | null;
  /**
   * Custom text that should be displayed alongside the payment confirmation button.
   */
  submit?: payment_pages_checkout_session_custom_text_position | null;
  /**
   * Custom text that should be displayed in place of the default terms of service agreement text.
   */
  terms_of_service_acceptance?: payment_pages_checkout_session_custom_text_position | null;
};

export type payment_pages_checkout_session_custom_text_position = {
  /**
   * Text may be up to 1200 characters in length.
   */
  message: string;
};

export type payment_pages_checkout_session_customer_details = {
  /**
   * The customer's address after a completed Checkout Session. Note: This property is populated only for sessions on or after March 30, 2022.
   */
  address?: address | null;
  /**
   * The email associated with the Customer, if one exists, on the Checkout Session after a completed Checkout Session or at time of session expiry.
   * Otherwise, if the customer has consented to promotional content, this value is the most recent valid email provided by the customer on the Checkout form.
   */
  email?: string | null;
  /**
   * The customer's name after a completed Checkout Session. Note: This property is populated only for sessions on or after March 30, 2022.
   */
  name?: string | null;
  /**
   * The customer's phone number after a completed Checkout Session.
   */
  phone?: string | null;
  /**
   * The customer’s tax exempt status after a completed Checkout Session.
   */
  tax_exempt?: ('exempt' | 'none' | 'reverse') | null;
  /**
   * The customer’s tax IDs after a completed Checkout Session.
   */
  tax_ids?: Array<payment_pages_checkout_session_tax_id> | null;
};

export type payment_pages_checkout_session_invoice_creation = {
  /**
   * Indicates whether invoice creation is enabled for the Checkout Session.
   */
  enabled: boolean;
  invoice_data: payment_pages_checkout_session_invoice_settings;
};

export type payment_pages_checkout_session_invoice_settings = {
  /**
   * The account tax IDs associated with the invoice.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  /**
   * Custom fields displayed on the invoice.
   */
  custom_fields?: Array<invoice_setting_custom_field> | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Footer displayed on the invoice.
   */
  footer?: string | null;
  /**
   * The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.
   */
  issuer?: connect_account_reference | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * Options for invoice PDF rendering.
   */
  rendering_options?: invoice_setting_rendering_options | null;
};

export type payment_pages_checkout_session_payment_method_reuse_agreement = {
  /**
   * Determines the position and visibility of the payment method reuse agreement in the UI. When set to `auto`, Stripe's defaults will be used.
   *
   * When set to `hidden`, the payment method reuse agreement text will always be hidden in the UI.
   */
  position: 'auto' | 'hidden';
};

export type payment_pages_checkout_session_phone_number_collection = {
  /**
   * Indicates whether phone number collection is enabled for the session
   */
  enabled: boolean;
};

export type payment_pages_checkout_session_saved_payment_method_options = {
  /**
   * Uses the `allow_redisplay` value of each saved payment method to filter the set presented to a returning customer. By default, only saved payment methods with ’allow_redisplay: ‘always’ are shown in Checkout.
   */
  allow_redisplay_filters?: Array<'always' | 'limited' | 'unspecified'> | null;
  /**
   * Enable customers to choose if they wish to remove their saved payment methods. Disabled by default.
   */
  payment_method_remove?: ('disabled' | 'enabled') | null;
  /**
   * Enable customers to choose if they wish to save their payment method for future use. Disabled by default.
   */
  payment_method_save?: ('disabled' | 'enabled') | null;
};

/**
 * Enable customers to choose if they wish to remove their saved payment methods. Disabled by default.
 */
export type payment_method_remove = 'disabled' | 'enabled';

/**
 * Enable customers to choose if they wish to save their payment method for future use. Disabled by default.
 */
export type payment_method_save = 'disabled' | 'enabled';

export type payment_pages_checkout_session_shipping_address_collection = {
  /**
   * An array of two-letter ISO country codes representing which countries Checkout should provide as options for
   * shipping locations. Unsupported country codes: `AS, CX, CC, CU, HM, IR, KP, MH, FM, NF, MP, PW, SD, SY, UM, VI`.
   */
  allowed_countries: Array<
    | 'AC'
    | 'AD'
    | 'AE'
    | 'AF'
    | 'AG'
    | 'AI'
    | 'AL'
    | 'AM'
    | 'AO'
    | 'AQ'
    | 'AR'
    | 'AT'
    | 'AU'
    | 'AW'
    | 'AX'
    | 'AZ'
    | 'BA'
    | 'BB'
    | 'BD'
    | 'BE'
    | 'BF'
    | 'BG'
    | 'BH'
    | 'BI'
    | 'BJ'
    | 'BL'
    | 'BM'
    | 'BN'
    | 'BO'
    | 'BQ'
    | 'BR'
    | 'BS'
    | 'BT'
    | 'BV'
    | 'BW'
    | 'BY'
    | 'BZ'
    | 'CA'
    | 'CD'
    | 'CF'
    | 'CG'
    | 'CH'
    | 'CI'
    | 'CK'
    | 'CL'
    | 'CM'
    | 'CN'
    | 'CO'
    | 'CR'
    | 'CV'
    | 'CW'
    | 'CY'
    | 'CZ'
    | 'DE'
    | 'DJ'
    | 'DK'
    | 'DM'
    | 'DO'
    | 'DZ'
    | 'EC'
    | 'EE'
    | 'EG'
    | 'EH'
    | 'ER'
    | 'ES'
    | 'ET'
    | 'FI'
    | 'FJ'
    | 'FK'
    | 'FO'
    | 'FR'
    | 'GA'
    | 'GB'
    | 'GD'
    | 'GE'
    | 'GF'
    | 'GG'
    | 'GH'
    | 'GI'
    | 'GL'
    | 'GM'
    | 'GN'
    | 'GP'
    | 'GQ'
    | 'GR'
    | 'GS'
    | 'GT'
    | 'GU'
    | 'GW'
    | 'GY'
    | 'HK'
    | 'HN'
    | 'HR'
    | 'HT'
    | 'HU'
    | 'ID'
    | 'IE'
    | 'IL'
    | 'IM'
    | 'IN'
    | 'IO'
    | 'IQ'
    | 'IS'
    | 'IT'
    | 'JE'
    | 'JM'
    | 'JO'
    | 'JP'
    | 'KE'
    | 'KG'
    | 'KH'
    | 'KI'
    | 'KM'
    | 'KN'
    | 'KR'
    | 'KW'
    | 'KY'
    | 'KZ'
    | 'LA'
    | 'LB'
    | 'LC'
    | 'LI'
    | 'LK'
    | 'LR'
    | 'LS'
    | 'LT'
    | 'LU'
    | 'LV'
    | 'LY'
    | 'MA'
    | 'MC'
    | 'MD'
    | 'ME'
    | 'MF'
    | 'MG'
    | 'MK'
    | 'ML'
    | 'MM'
    | 'MN'
    | 'MO'
    | 'MQ'
    | 'MR'
    | 'MS'
    | 'MT'
    | 'MU'
    | 'MV'
    | 'MW'
    | 'MX'
    | 'MY'
    | 'MZ'
    | 'NA'
    | 'NC'
    | 'NE'
    | 'NG'
    | 'NI'
    | 'NL'
    | 'NO'
    | 'NP'
    | 'NR'
    | 'NU'
    | 'NZ'
    | 'OM'
    | 'PA'
    | 'PE'
    | 'PF'
    | 'PG'
    | 'PH'
    | 'PK'
    | 'PL'
    | 'PM'
    | 'PN'
    | 'PR'
    | 'PS'
    | 'PT'
    | 'PY'
    | 'QA'
    | 'RE'
    | 'RO'
    | 'RS'
    | 'RU'
    | 'RW'
    | 'SA'
    | 'SB'
    | 'SC'
    | 'SE'
    | 'SG'
    | 'SH'
    | 'SI'
    | 'SJ'
    | 'SK'
    | 'SL'
    | 'SM'
    | 'SN'
    | 'SO'
    | 'SR'
    | 'SS'
    | 'ST'
    | 'SV'
    | 'SX'
    | 'SZ'
    | 'TA'
    | 'TC'
    | 'TD'
    | 'TF'
    | 'TG'
    | 'TH'
    | 'TJ'
    | 'TK'
    | 'TL'
    | 'TM'
    | 'TN'
    | 'TO'
    | 'TR'
    | 'TT'
    | 'TV'
    | 'TW'
    | 'TZ'
    | 'UA'
    | 'UG'
    | 'US'
    | 'UY'
    | 'UZ'
    | 'VA'
    | 'VC'
    | 'VE'
    | 'VG'
    | 'VN'
    | 'VU'
    | 'WF'
    | 'WS'
    | 'XK'
    | 'YE'
    | 'YT'
    | 'ZA'
    | 'ZM'
    | 'ZW'
    | 'ZZ'
  >;
};

export type payment_pages_checkout_session_shipping_cost = {
  /**
   * Total shipping cost before any discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.
   */
  amount_tax: number;
  /**
   * Total shipping cost after discounts and taxes are applied.
   */
  amount_total: number;
  /**
   * The ID of the ShippingRate for this order.
   */
  shipping_rate?: (string | shipping_rate) | null;
  /**
   * The taxes applied to the shipping rate.
   */
  taxes?: Array<line_items_tax_amount>;
};

export type payment_pages_checkout_session_shipping_option = {
  /**
   * A non-negative integer in cents representing how much to charge.
   */
  shipping_amount: number;
  /**
   * The shipping rate.
   */
  shipping_rate: string | shipping_rate;
};

export type payment_pages_checkout_session_tax_id = {
  /**
   * The type of the tax ID, one of `ad_nrt`, `ar_cuit`, `eu_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `cn_tin`, `co_nit`, `cr_tin`, `do_rcn`, `ec_ruc`, `eu_oss_vat`, `pe_ruc`, `ro_tin`, `rs_pib`, `sv_nit`, `uy_ruc`, `ve_rif`, `vn_tin`, `gb_vat`, `nz_gst`, `au_abn`, `au_arn`, `in_gst`, `no_vat`, `no_voec`, `za_vat`, `ch_vat`, `mx_rfc`, `sg_uen`, `ru_inn`, `ru_kpp`, `ca_bn`, `hk_br`, `es_cif`, `tw_vat`, `th_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `li_uid`, `my_itn`, `us_ein`, `kr_brn`, `ca_qst`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `my_sst`, `sg_gst`, `ae_trn`, `cl_tin`, `sa_vat`, `id_npwp`, `my_frp`, `il_vat`, `ge_vat`, `ua_vat`, `is_vat`, `bg_uic`, `hu_tin`, `si_tin`, `ke_pin`, `tr_tin`, `eg_tin`, `ph_tin`, `bh_vat`, `kz_bin`, `ng_tin`, `om_vat`, `de_stn`, or `unknown`
   */
  type:
    | 'ad_nrt'
    | 'ae_trn'
    | 'ar_cuit'
    | 'au_abn'
    | 'au_arn'
    | 'bg_uic'
    | 'bh_vat'
    | 'bo_tin'
    | 'br_cnpj'
    | 'br_cpf'
    | 'ca_bn'
    | 'ca_gst_hst'
    | 'ca_pst_bc'
    | 'ca_pst_mb'
    | 'ca_pst_sk'
    | 'ca_qst'
    | 'ch_vat'
    | 'cl_tin'
    | 'cn_tin'
    | 'co_nit'
    | 'cr_tin'
    | 'de_stn'
    | 'do_rcn'
    | 'ec_ruc'
    | 'eg_tin'
    | 'es_cif'
    | 'eu_oss_vat'
    | 'eu_vat'
    | 'gb_vat'
    | 'ge_vat'
    | 'hk_br'
    | 'hu_tin'
    | 'id_npwp'
    | 'il_vat'
    | 'in_gst'
    | 'is_vat'
    | 'jp_cn'
    | 'jp_rn'
    | 'jp_trn'
    | 'ke_pin'
    | 'kr_brn'
    | 'kz_bin'
    | 'li_uid'
    | 'mx_rfc'
    | 'my_frp'
    | 'my_itn'
    | 'my_sst'
    | 'ng_tin'
    | 'no_vat'
    | 'no_voec'
    | 'nz_gst'
    | 'om_vat'
    | 'pe_ruc'
    | 'ph_tin'
    | 'ro_tin'
    | 'rs_pib'
    | 'ru_inn'
    | 'ru_kpp'
    | 'sa_vat'
    | 'sg_gst'
    | 'sg_uen'
    | 'si_tin'
    | 'sv_nit'
    | 'th_vat'
    | 'tr_tin'
    | 'tw_vat'
    | 'ua_vat'
    | 'unknown'
    | 'us_ein'
    | 'uy_ruc'
    | 've_rif'
    | 'vn_tin'
    | 'za_vat';
  /**
   * The value of the tax ID.
   */
  value?: string | null;
};

export type payment_pages_checkout_session_tax_id_collection = {
  /**
   * Indicates whether tax ID collection is enabled for the session
   */
  enabled: boolean;
};

export type payment_pages_checkout_session_total_details = {
  /**
   * This is the sum of all the discounts.
   */
  amount_discount: number;
  /**
   * This is the sum of all the shipping amounts.
   */
  amount_shipping?: number | null;
  /**
   * This is the sum of all the tax amounts.
   */
  amount_tax: number;
  breakdown?: payment_pages_checkout_session_total_details_resource_breakdown;
};

export type payment_pages_checkout_session_total_details_resource_breakdown = {
  /**
   * The aggregated discounts.
   */
  discounts: Array<line_items_discount_amount>;
  /**
   * The aggregated tax amounts by rate.
   */
  taxes: Array<line_items_tax_amount>;
};

export type payment_source = account | bank_account | card | source;

/**
 * A `Payout` object is created when you receive funds from Stripe, or when you
 * initiate a payout to either a bank account or debit card of a [connected
 * Stripe account](/docs/connect/bank-debit-card-payouts). You can retrieve individual payouts,
 * and list all payouts. Payouts are made on [varying
 * schedules](/docs/connect/manage-payout-schedule), depending on your country and
 * industry.
 *
 * Related guide: [Receiving payouts](https://stripe.com/docs/payouts)
 */
export type payout = {
  /**
   * The amount (in cents (or local equivalent)) that transfers to your bank account or debit card.
   */
  amount: number;
  /**
   * The application fee (if any) for the payout. [See the Connect documentation](https://stripe.com/docs/connect/instant-payouts#monetization-and-fees) for details.
   */
  application_fee?: (string | application_fee) | null;
  /**
   * The amount of the application fee (if any) requested for the payout. [See the Connect documentation](https://stripe.com/docs/connect/instant-payouts#monetization-and-fees) for details.
   */
  application_fee_amount?: number | null;
  /**
   * Date that you can expect the payout to arrive in the bank. This factors in delays to account for weekends or bank holidays.
   */
  arrival_date: number;
  /**
   * Returns `true` if the payout is created by an [automated payout schedule](https://stripe.com/docs/payouts#payout-schedule) and `false` if it's [requested manually](https://stripe.com/docs/payouts#manual-payouts).
   */
  automatic: boolean;
  /**
   * ID of the balance transaction that describes the impact of this payout on your account balance.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * ID of the bank account or card the payout is sent to.
   */
  destination?: (string | bank_account | card | deleted_bank_account | deleted_card) | null;
  /**
   * If the payout fails or cancels, this is the ID of the balance transaction that reverses the initial balance transaction and returns the funds from the failed payout back in your balance.
   */
  failure_balance_transaction?: (string | balance_transaction) | null;
  /**
   * Error code that provides a reason for a payout failure, if available. View our [list of failure codes](https://stripe.com/docs/api#payout_failures).
   */
  failure_code?: string | null;
  /**
   * Message that provides the reason for a payout failure, if available.
   */
  failure_message?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * The method used to send this payout, which can be `standard` or `instant`. `instant` is supported for payouts to debit cards and bank accounts in certain countries. Learn more about [bank support for Instant Payouts](https://stripe.com/docs/payouts/instant-payouts-banks).
   */
  method: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'payout';
  /**
   * If the payout reverses another, this is the ID of the original payout.
   */
  original_payout?: (string | payout) | null;
  /**
   * If `completed`, you can use the [Balance Transactions API](https://stripe.com/docs/api/balance_transactions/list#balance_transaction_list-payout) to list all balance transactions that are paid out in this payout.
   */
  reconciliation_status: 'completed' | 'in_progress' | 'not_applicable';
  /**
   * If the payout reverses, this is the ID of the payout that reverses this payout.
   */
  reversed_by?: (string | payout) | null;
  /**
   * The source balance this payout came from, which can be one of the following: `card`, `fpx`, or `bank_account`.
   */
  source_type: string;
  /**
   * Extra information about a payout that displays on the user's bank statement.
   */
  statement_descriptor?: string | null;
  /**
   * Current status of the payout: `paid`, `pending`, `in_transit`, `canceled` or `failed`. A payout is `pending` until it's submitted to the bank, when it becomes `in_transit`. The status changes to `paid` if the transaction succeeds, or to `failed` or `canceled` (within 5 business days). Some payouts that fail might initially show as `paid`, then change to `failed`.
   */
  status: string;
  /**
   * Can be `bank_account` or `card`.
   */
  type: 'bank_account' | 'card';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object84 = 'payout';

/**
 * If `completed`, you can use the [Balance Transactions API](https://stripe.com/docs/api/balance_transactions/list#balance_transaction_list-payout) to list all balance transactions that are paid out in this payout.
 */
export type reconciliation_status = 'completed' | 'in_progress' | 'not_applicable';

/**
 * Can be `bank_account` or `card`.
 */
export type type42 = 'bank_account' | 'card';

export type paypal_seller_protection = {
  /**
   * An array of conditions that are covered for the transaction, if applicable.
   */
  dispute_categories?: Array<'fraudulent' | 'product_not_received'> | null;
  /**
   * Indicates whether the transaction is eligible for PayPal's seller protection.
   */
  status: 'eligible' | 'not_eligible' | 'partially_eligible';
};

/**
 * Indicates whether the transaction is eligible for PayPal's seller protection.
 */
export type status27 = 'eligible' | 'not_eligible' | 'partially_eligible';

export type period = {
  /**
   * The end date of this usage period. All usage up to and including this point in time is included.
   */
  end?: number | null;
  /**
   * The start date of this usage period. All usage after this point in time is included.
   */
  start?: number | null;
};

/**
 * This is an object representing a person associated with a Stripe account.
 *
 * A platform cannot access a person for an account where [account.controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `stripe`, which includes Standard and Express accounts, after creating an Account Link or Account Session to start Connect onboarding.
 *
 * See the [Standard onboarding](/connect/standard-accounts) or [Express onboarding](/connect/express-accounts) documentation for information about prefilling information and account onboarding steps. Learn more about [handling identity verification with the API](/connect/handling-api-verification#person-information).
 */
export type person = {
  /**
   * The account the person is associated with.
   */
  account: string;
  additional_tos_acceptances?: person_additional_tos_acceptances;
  address?: address;
  address_kana?: legal_entity_japan_address | null;
  address_kanji?: legal_entity_japan_address | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  dob?: legal_entity_dob;
  /**
   * The person's email address.
   */
  email?: string | null;
  /**
   * The person's first name.
   */
  first_name?: string | null;
  /**
   * The Kana variation of the person's first name (Japan only).
   */
  first_name_kana?: string | null;
  /**
   * The Kanji variation of the person's first name (Japan only).
   */
  first_name_kanji?: string | null;
  /**
   * A list of alternate names or aliases that the person is known by.
   */
  full_name_aliases?: Array<string>;
  future_requirements?: person_future_requirements | null;
  /**
   * The person's gender (International regulations require either "male" or "female").
   */
  gender?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Whether the person's `id_number` was provided. True if either the full ID number was provided or if only the required part of the ID number was provided (ex. last four of an individual's SSN for the US indicated by `ssn_last_4_provided`).
   */
  id_number_provided?: boolean;
  /**
   * Whether the person's `id_number_secondary` was provided.
   */
  id_number_secondary_provided?: boolean;
  /**
   * The person's last name.
   */
  last_name?: string | null;
  /**
   * The Kana variation of the person's last name (Japan only).
   */
  last_name_kana?: string | null;
  /**
   * The Kanji variation of the person's last name (Japan only).
   */
  last_name_kanji?: string | null;
  /**
   * The person's maiden name.
   */
  maiden_name?: string | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  };
  /**
   * The country where the person is a national.
   */
  nationality?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'person';
  /**
   * The person's phone number.
   */
  phone?: string | null;
  /**
   * Indicates if the person or any of their representatives, family members, or other closely related persons, declares that they hold or have held an important public job or function, in any jurisdiction.
   */
  political_exposure?: 'existing' | 'none';
  registered_address?: address;
  relationship?: person_relationship;
  requirements?: person_requirements | null;
  /**
   * Whether the last four digits of the person's Social Security number have been provided (U.S. only).
   */
  ssn_last_4_provided?: boolean;
  verification?: legal_entity_person_verification;
};

/**
 * Indicates if the person or any of their representatives, family members, or other closely related persons, declares that they hold or have held an important public job or function, in any jurisdiction.
 */
export type political_exposure = 'existing' | 'none';

export type person_additional_tos_acceptance = {
  /**
   * The Unix timestamp marking when the legal guardian accepted the service agreement.
   */
  date?: number | null;
  /**
   * The IP address from which the legal guardian accepted the service agreement.
   */
  ip?: string | null;
  /**
   * The user agent of the browser from which the legal guardian accepted the service agreement.
   */
  user_agent?: string | null;
};

export type person_additional_tos_acceptances = {
  account: person_additional_tos_acceptance;
};

export type person_future_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Fields that need to be collected to keep the person's account enabled. If not collected by the account's `future_requirements[current_deadline]`, these fields will transition to the main `requirements` hash, and may immediately become `past_due`, but the account may also be given a grace period depending on the account's enablement state prior to transition.
   */
  currently_due: Array<string>;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors: Array<account_requirements_error>;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and the account's `future_requirements[current_deadline]` becomes set.
   */
  eventually_due: Array<string>;
  /**
   * Fields that weren't collected by the account's `requirements.current_deadline`. These fields need to be collected to enable the person's account. New fields will never appear here; `future_requirements.past_due` will always be a subset of `requirements.past_due`.
   */
  past_due: Array<string>;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due` or `currently_due`. Fields might appear in `eventually_due` or `currently_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification: Array<string>;
};

export type person_relationship = {
  /**
   * Whether the person is a director of the account's legal entity. Directors are typically members of the governing board of the company, or responsible for ensuring the company meets its regulatory obligations.
   */
  director?: boolean | null;
  /**
   * Whether the person has significant responsibility to control, manage, or direct the organization.
   */
  executive?: boolean | null;
  /**
   * Whether the person is the legal guardian of the account's representative.
   */
  legal_guardian?: boolean | null;
  /**
   * Whether the person is an owner of the account’s legal entity.
   */
  owner?: boolean | null;
  /**
   * The percent owned by the person of the account's legal entity.
   */
  percent_ownership?: number | null;
  /**
   * Whether the person is authorized as the primary representative of the account. This is the person nominated by the business to provide information about themselves, and general information about the account. There can only be one representative at any given time. At the time the account is created, this person should be set to the person responsible for opening the account.
   */
  representative?: boolean | null;
  /**
   * The person's title (e.g., CEO, Support Engineer).
   */
  title?: string | null;
};

export type person_requirements = {
  /**
   * Fields that are due and can be satisfied by providing the corresponding alternative fields instead.
   */
  alternatives?: Array<account_requirements_alternative> | null;
  /**
   * Fields that need to be collected to keep the person's account enabled. If not collected by the account's `current_deadline`, these fields appear in `past_due` as well, and the account is disabled.
   */
  currently_due: Array<string>;
  /**
   * Fields that are `currently_due` and need to be collected again because validation or verification failed.
   */
  errors: Array<account_requirements_error>;
  /**
   * Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and the account's `current_deadline` becomes set.
   */
  eventually_due: Array<string>;
  /**
   * Fields that weren't collected by the account's `current_deadline`. These fields need to be collected to enable the person's account.
   */
  past_due: Array<string>;
  /**
   * Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.
   */
  pending_verification: Array<string>;
};

/**
 * You can now model subscriptions more flexibly using the [Prices API](https://stripe.com/docs/api#prices). It replaces the Plans API and is backwards compatible to simplify your migration.
 *
 * Plans define the base price, currency, and billing cycle for recurring purchases of products.
 * [Products](https://stripe.com/docs/api#products) help you track inventory or provisioning, and plans help you track pricing. Different physical goods or levels of service should be represented by products, and pricing options should be represented by plans. This approach lets you change prices without having to change your provisioning scheme.
 *
 * For example, you might have a single "gold" product that has plans for $10/month, $100/year, €9/month, and €90/year.
 *
 * Related guides: [Set up a subscription](https://stripe.com/docs/billing/subscriptions/set-up-subscription) and more about [products and prices](https://stripe.com/docs/products-prices/overview).
 */
export type plan = {
  /**
   * Whether the plan can be used for new purchases.
   */
  active: boolean;
  /**
   * Specifies a usage aggregation strategy for plans of `usage_type=metered`. Allowed values are `sum` for summing up all usage during a period, `last_during_period` for using the last usage record reported within a period, `last_ever` for using the last usage record ever (across period bounds) or `max` which uses the usage record with the maximum reported usage during a period. Defaults to `sum`.
   */
  aggregate_usage?: ('last_during_period' | 'last_ever' | 'max' | 'sum') | null;
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a whole integer if possible. Only set if `billing_scheme=per_unit`.
   */
  amount?: number | null;
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a decimal string with at most 12 decimal places. Only set if `billing_scheme=per_unit`.
   */
  amount_decimal?: string | null;
  /**
   * Describes how to compute the price per period. Either `per_unit` or `tiered`. `per_unit` indicates that the fixed amount (specified in `amount`) will be charged per unit in `quantity` (for plans with `usage_type=licensed`), or per unit of total usage (for plans with `usage_type=metered`). `tiered` indicates that the unit pricing will be computed using a tiering strategy as defined using the `tiers` and `tiers_mode` attributes.
   */
  billing_scheme: 'per_unit' | 'tiered';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The frequency at which a subscription is billed. One of `day`, `week`, `month` or `year`.
   */
  interval: 'day' | 'month' | 'week' | 'year';
  /**
   * The number of intervals (specified in the `interval` attribute) between subscription billings. For example, `interval=month` and `interval_count=3` bills every 3 months.
   */
  interval_count: number;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * The meter tracking the usage of a metered price
   */
  meter?: string | null;
  /**
   * A brief description of the plan, hidden from customers.
   */
  nickname?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'plan';
  /**
   * The product whose pricing this plan determines.
   */
  product?: (string | product | deleted_product) | null;
  /**
   * Each element represents a pricing tier. This parameter requires `billing_scheme` to be set to `tiered`. See also the documentation for `billing_scheme`.
   */
  tiers?: Array<plan_tier>;
  /**
   * Defines if the tiering price should be `graduated` or `volume` based. In `volume`-based tiering, the maximum quantity within a period determines the per unit price. In `graduated` tiering, pricing can change as the quantity grows.
   */
  tiers_mode?: ('graduated' | 'volume') | null;
  /**
   * Apply a transformation to the reported usage or set quantity before computing the amount billed. Cannot be combined with `tiers`.
   */
  transform_usage?: transform_usage | null;
  /**
   * Default number of trial days when subscribing a customer to this plan using [`trial_from_plan=true`](https://stripe.com/docs/api#create_subscription-trial_from_plan).
   */
  trial_period_days?: number | null;
  /**
   * Configures how the quantity per period should be determined. Can be either `metered` or `licensed`. `licensed` automatically bills the `quantity` set when adding it to a subscription. `metered` aggregates the total usage based on usage records. Defaults to `licensed`.
   */
  usage_type: 'licensed' | 'metered';
};

/**
 * Specifies a usage aggregation strategy for plans of `usage_type=metered`. Allowed values are `sum` for summing up all usage during a period, `last_during_period` for using the last usage record reported within a period, `last_ever` for using the last usage record ever (across period bounds) or `max` which uses the usage record with the maximum reported usage during a period. Defaults to `sum`.
 */
export type aggregate_usage = 'last_during_period' | 'last_ever' | 'max' | 'sum';

/**
 * Describes how to compute the price per period. Either `per_unit` or `tiered`. `per_unit` indicates that the fixed amount (specified in `amount`) will be charged per unit in `quantity` (for plans with `usage_type=licensed`), or per unit of total usage (for plans with `usage_type=metered`). `tiered` indicates that the unit pricing will be computed using a tiering strategy as defined using the `tiers` and `tiers_mode` attributes.
 */
export type billing_scheme = 'per_unit' | 'tiered';

/**
 * The frequency at which a subscription is billed. One of `day`, `week`, `month` or `year`.
 */
export type interval4 = 'day' | 'month' | 'week' | 'year';

/**
 * Defines if the tiering price should be `graduated` or `volume` based. In `volume`-based tiering, the maximum quantity within a period determines the per unit price. In `graduated` tiering, pricing can change as the quantity grows.
 */
export type tiers_mode = 'graduated' | 'volume';

/**
 * Configures how the quantity per period should be determined. Can be either `metered` or `licensed`. `licensed` automatically bills the `quantity` set when adding it to a subscription. `metered` aggregates the total usage based on usage records. Defaults to `licensed`.
 */
export type usage_type = 'licensed' | 'metered';

export type plan_tier = {
  /**
   * Price for the entire tier.
   */
  flat_amount?: number | null;
  /**
   * Same as `flat_amount`, but contains a decimal value with at most 12 decimal places.
   */
  flat_amount_decimal?: string | null;
  /**
   * Per unit price for units relevant to the tier.
   */
  unit_amount?: number | null;
  /**
   * Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.
   */
  unit_amount_decimal?: string | null;
  /**
   * Up to and including to this quantity will be contained in the tier.
   */
  up_to?: number | null;
};

export type platform_earning_fee_source = {
  /**
   * Charge ID that created this application fee.
   */
  charge?: string;
  /**
   * Payout ID that created this application fee.
   */
  payout?: string;
  /**
   * Type of object that created the application fee, either `charge` or `payout`.
   */
  type: 'charge' | 'payout';
};

/**
 * Type of object that created the application fee, either `charge` or `payout`.
 */
export type type43 = 'charge' | 'payout';

export type portal_business_profile = {
  /**
   * The messaging shown to customers in the portal.
   */
  headline?: string | null;
  /**
   * A link to the business’s publicly available privacy policy.
   */
  privacy_policy_url?: string | null;
  /**
   * A link to the business’s publicly available terms of service.
   */
  terms_of_service_url?: string | null;
};

export type portal_customer_update = {
  /**
   * The types of customer updates that are supported. When empty, customers are not updateable.
   */
  allowed_updates: Array<'address' | 'email' | 'name' | 'phone' | 'shipping' | 'tax_id'>;
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
};

export type portal_features = {
  customer_update: portal_customer_update;
  invoice_history: portal_invoice_list;
  payment_method_update: portal_payment_method_update;
  subscription_cancel: portal_subscription_cancel;
  subscription_update: portal_subscription_update;
};

export type portal_flows_after_completion_hosted_confirmation = {
  /**
   * A custom message to display to the customer after the flow is completed.
   */
  custom_message?: string | null;
};

export type portal_flows_after_completion_redirect = {
  /**
   * The URL the customer will be redirected to after the flow is completed.
   */
  return_url: string;
};

export type portal_flows_coupon_offer = {
  /**
   * The ID of the coupon to be offered.
   */
  coupon: string;
};

export type portal_flows_flow = {
  after_completion: portal_flows_flow_after_completion;
  /**
   * Configuration when `flow.type=subscription_cancel`.
   */
  subscription_cancel?: portal_flows_flow_subscription_cancel | null;
  /**
   * Configuration when `flow.type=subscription_update`.
   */
  subscription_update?: portal_flows_flow_subscription_update | null;
  /**
   * Configuration when `flow.type=subscription_update_confirm`.
   */
  subscription_update_confirm?: portal_flows_flow_subscription_update_confirm | null;
  /**
   * Type of flow that the customer will go through.
   */
  type: 'payment_method_update' | 'subscription_cancel' | 'subscription_update' | 'subscription_update_confirm';
};

/**
 * Type of flow that the customer will go through.
 */
export type type44 =
  | 'payment_method_update'
  | 'subscription_cancel'
  | 'subscription_update'
  | 'subscription_update_confirm';

export type portal_flows_flow_after_completion = {
  /**
   * Configuration when `after_completion.type=hosted_confirmation`.
   */
  hosted_confirmation?: portal_flows_after_completion_hosted_confirmation | null;
  /**
   * Configuration when `after_completion.type=redirect`.
   */
  redirect?: portal_flows_after_completion_redirect | null;
  /**
   * The specified type of behavior after the flow is completed.
   */
  type: 'hosted_confirmation' | 'portal_homepage' | 'redirect';
};

/**
 * The specified type of behavior after the flow is completed.
 */
export type type45 = 'hosted_confirmation' | 'portal_homepage' | 'redirect';

export type portal_flows_flow_subscription_cancel = {
  /**
   * Specify a retention strategy to be used in the cancellation flow.
   */
  retention?: portal_flows_retention | null;
  /**
   * The ID of the subscription to be canceled.
   */
  subscription: string;
};

export type portal_flows_flow_subscription_update = {
  /**
   * The ID of the subscription to be updated.
   */
  subscription: string;
};

export type portal_flows_flow_subscription_update_confirm = {
  /**
   * The coupon or promotion code to apply to this subscription update. Currently, only up to one may be specified.
   */
  discounts?: Array<portal_flows_subscription_update_confirm_discount> | null;
  /**
   * The [subscription item](https://stripe.com/docs/api/subscription_items) to be updated through this flow. Currently, only up to one may be specified and subscriptions with multiple items are not updatable.
   */
  items: Array<portal_flows_subscription_update_confirm_item>;
  /**
   * The ID of the subscription to be updated.
   */
  subscription: string;
};

export type portal_flows_retention = {
  /**
   * Configuration when `retention.type=coupon_offer`.
   */
  coupon_offer?: portal_flows_coupon_offer | null;
  /**
   * Type of retention strategy that will be used.
   */
  type: 'coupon_offer';
};

/**
 * Type of retention strategy that will be used.
 */
export type type46 = 'coupon_offer';

export type portal_flows_subscription_update_confirm_discount = {
  /**
   * The ID of the coupon to apply to this subscription update.
   */
  coupon?: string | null;
  /**
   * The ID of a promotion code to apply to this subscription update.
   */
  promotion_code?: string | null;
};

export type portal_flows_subscription_update_confirm_item = {
  /**
   * The ID of the [subscription item](https://stripe.com/docs/api/subscriptions/object#subscription_object-items-data-id) to be updated.
   */
  id?: string | null;
  /**
   * The price the customer should subscribe to through this flow. The price must also be included in the configuration's [`features.subscription_update.products`](https://stripe.com/docs/api/customer_portal/configuration#portal_configuration_object-features-subscription_update-products).
   */
  price?: string | null;
  /**
   * [Quantity](https://stripe.com/docs/subscriptions/quantities) for this item that the customer should subscribe to through this flow.
   */
  quantity?: number;
};

export type portal_invoice_list = {
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
};

export type portal_login_page = {
  /**
   * If `true`, a shareable `url` will be generated that will take your customers to a hosted login page for the customer portal.
   *
   * If `false`, the previously generated `url`, if any, will be deactivated.
   */
  enabled: boolean;
  /**
   * A shareable URL to the hosted portal login page. Your customers will be able to log in with their [email](https://stripe.com/docs/api/customers/object#customer_object-email) and receive a link to their customer portal.
   */
  url?: string | null;
};

export type portal_payment_method_update = {
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
};

export type portal_subscription_cancel = {
  cancellation_reason: portal_subscription_cancellation_reason;
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
  /**
   * Whether to cancel subscriptions immediately or at the end of the billing period.
   */
  mode: 'at_period_end' | 'immediately';
  /**
   * Whether to create prorations when canceling subscriptions. Possible values are `none` and `create_prorations`.
   */
  proration_behavior: 'always_invoice' | 'create_prorations' | 'none';
};

/**
 * Whether to cancel subscriptions immediately or at the end of the billing period.
 */
export type mode2 = 'at_period_end' | 'immediately';

/**
 * Whether to create prorations when canceling subscriptions. Possible values are `none` and `create_prorations`.
 */
export type proration_behavior = 'always_invoice' | 'create_prorations' | 'none';

export type portal_subscription_cancellation_reason = {
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
  /**
   * Which cancellation reasons will be given as options to the customer.
   */
  options: Array<
    | 'customer_service'
    | 'low_quality'
    | 'missing_features'
    | 'other'
    | 'switched_service'
    | 'too_complex'
    | 'too_expensive'
    | 'unused'
  >;
};

export type portal_subscription_update = {
  /**
   * The types of subscription updates that are supported for items listed in the `products` attribute. When empty, subscriptions are not updateable.
   */
  default_allowed_updates: Array<'price' | 'promotion_code' | 'quantity'>;
  /**
   * Whether the feature is enabled.
   */
  enabled: boolean;
  /**
   * The list of up to 10 products that support subscription updates.
   */
  products?: Array<portal_subscription_update_product> | null;
  /**
   * Determines how to handle prorations resulting from subscription updates. Valid values are `none`, `create_prorations`, and `always_invoice`. Defaults to a value of `none` if you don't set it during creation.
   */
  proration_behavior: 'always_invoice' | 'create_prorations' | 'none';
};

export type portal_subscription_update_product = {
  /**
   * The list of price IDs which, when subscribed to, a subscription can be updated.
   */
  prices: Array<string>;
  /**
   * The product ID.
   */
  product: string;
};

/**
 * Prices define the unit cost, currency, and (optional) billing cycle for both recurring and one-time purchases of products.
 * [Products](https://stripe.com/docs/api#products) help you track inventory or provisioning, and prices help you track payment terms. Different physical goods or levels of service should be represented by products, and pricing options should be represented by prices. This approach lets you change prices without having to change your provisioning scheme.
 *
 * For example, you might have a single "gold" product that has prices for $10/month, $100/year, and €9 once.
 *
 * Related guides: [Set up a subscription](https://stripe.com/docs/billing/subscriptions/set-up-subscription), [create an invoice](https://stripe.com/docs/billing/invoices/create), and more about [products and prices](https://stripe.com/docs/products-prices/overview).
 */
export type price = {
  /**
   * Whether the price can be used for new purchases.
   */
  active: boolean;
  /**
   * Describes how to compute the price per period. Either `per_unit` or `tiered`. `per_unit` indicates that the fixed amount (specified in `unit_amount` or `unit_amount_decimal`) will be charged per unit in `quantity` (for prices with `usage_type=licensed`), or per unit of total usage (for prices with `usage_type=metered`). `tiered` indicates that the unit pricing will be computed using a tiering strategy as defined using the `tiers` and `tiers_mode` attributes.
   */
  billing_scheme: 'per_unit' | 'tiered';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Prices defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).
   */
  currency_options?: {
    [key: string]: currency_option;
  };
  /**
   * When set, provides configuration for the amount to be adjusted by the customer during Checkout Sessions and Payment Links.
   */
  custom_unit_amount?: custom_unit_amount | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A lookup key used to retrieve prices dynamically from a static string. This may be up to 200 characters.
   */
  lookup_key?: string | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * A brief description of the price, hidden from customers.
   */
  nickname?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'price';
  /**
   * The ID of the product this price is associated with.
   */
  product: string | product | deleted_product;
  /**
   * The recurring components of a price such as `interval` and `usage_type`.
   */
  recurring?: recurring | null;
  /**
   * Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
   */
  tax_behavior?: ('exclusive' | 'inclusive' | 'unspecified') | null;
  /**
   * Each element represents a pricing tier. This parameter requires `billing_scheme` to be set to `tiered`. See also the documentation for `billing_scheme`.
   */
  tiers?: Array<price_tier>;
  /**
   * Defines if the tiering price should be `graduated` or `volume` based. In `volume`-based tiering, the maximum quantity within a period determines the per unit price. In `graduated` tiering, pricing can change as the quantity grows.
   */
  tiers_mode?: ('graduated' | 'volume') | null;
  /**
   * Apply a transformation to the reported usage or set quantity before computing the amount billed. Cannot be combined with `tiers`.
   */
  transform_quantity?: transform_quantity | null;
  /**
   * One of `one_time` or `recurring` depending on whether the price is for a one-time purchase or a recurring (subscription) purchase.
   */
  type: 'one_time' | 'recurring';
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a whole integer if possible. Only set if `billing_scheme=per_unit`.
   */
  unit_amount?: number | null;
  /**
   * The unit amount in cents (or local equivalent) to be charged, represented as a decimal string with at most 12 decimal places. Only set if `billing_scheme=per_unit`.
   */
  unit_amount_decimal?: string | null;
};

/**
 * One of `one_time` or `recurring` depending on whether the price is for a one-time purchase or a recurring (subscription) purchase.
 */
export type type47 = 'one_time' | 'recurring';

export type price_tier = {
  /**
   * Price for the entire tier.
   */
  flat_amount?: number | null;
  /**
   * Same as `flat_amount`, but contains a decimal value with at most 12 decimal places.
   */
  flat_amount_decimal?: string | null;
  /**
   * Per unit price for units relevant to the tier.
   */
  unit_amount?: number | null;
  /**
   * Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.
   */
  unit_amount_decimal?: string | null;
  /**
   * Up to and including to this quantity will be contained in the tier.
   */
  up_to?: number | null;
};

/**
 * Products describe the specific goods or services you offer to your customers.
 * For example, you might offer a Standard and Premium version of your goods or service; each version would be a separate Product.
 * They can be used in conjunction with [Prices](https://stripe.com/docs/api#prices) to configure pricing in Payment Links, Checkout, and Subscriptions.
 *
 * Related guides: [Set up a subscription](https://stripe.com/docs/billing/subscriptions/set-up-subscription),
 * [share a Payment Link](https://stripe.com/docs/payment-links),
 * [accept payments with Checkout](https://stripe.com/docs/payments/accept-a-payment#create-product-prices-upfront),
 * and more about [Products and Prices](https://stripe.com/docs/products-prices/overview)
 */
export type product = {
  /**
   * Whether the product is currently available for purchase.
   */
  active: boolean;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The ID of the [Price](https://stripe.com/docs/api/prices) object that is the default price for this product.
   */
  default_price?: (string | price) | null;
  /**
   * The product's description, meant to be displayable to the customer. Use this field to optionally store a long form explanation of the product being sold for your own rendering purposes.
   */
  description?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * A list of up to 8 URLs of images for this product, meant to be displayable to the customer.
   */
  images: Array<string>;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * A list of up to 15 marketing features for this product. These are displayed in [pricing tables](https://stripe.com/docs/payments/checkout/pricing-table).
   */
  marketing_features: Array<product_marketing_feature>;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The product's name, meant to be displayable to the customer.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'product';
  /**
   * The dimensions of this product for shipping purposes.
   */
  package_dimensions?: package_dimensions | null;
  /**
   * Whether this product is shipped (i.e., physical goods).
   */
  shippable?: boolean | null;
  /**
   * Extra information about a product which will appear on your customer's credit card statement. In the case that multiple products are billed at once, the first statement descriptor will be used. Only used for subscription payments.
   */
  statement_descriptor?: string | null;
  /**
   * A [tax code](https://stripe.com/docs/tax/tax-categories) ID.
   */
  tax_code?: (string | tax_code) | null;
  /**
   * A label that represents units of this product. When set, this will be included in customers' receipts, invoices, Checkout, and the customer portal.
   */
  unit_label?: string | null;
  /**
   * Time at which the object was last updated. Measured in seconds since the Unix epoch.
   */
  updated: number;
  /**
   * A URL of a publicly-accessible webpage for this product.
   */
  url?: string | null;
};

/**
 * A product_feature represents an attachment between a feature and a product.
 * When a product is purchased that has a feature attached, Stripe will create an entitlement to the feature for the purchasing customer.
 */
export type product_feature = {
  entitlement_feature: entitlements_feature;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'product_feature';
};

export type product_marketing_feature = {
  /**
   * The marketing feature name. Up to 80 characters long.
   */
  name?: string;
};

/**
 * A Promotion Code represents a customer-redeemable code for a [coupon](https://stripe.com/docs/api#coupons). It can be used to
 * create multiple codes for a single coupon.
 */
export type promotion_code = {
  /**
   * Whether the promotion code is currently active. A promotion code is only active if the coupon is also valid.
   */
  active: boolean;
  /**
   * The customer-facing code. Regardless of case, this code must be unique across all active promotion codes for each customer.
   */
  code: string;
  coupon: coupon;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The customer that this promotion code can be used by.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * Date at which the promotion code can no longer be redeemed.
   */
  expires_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Maximum number of times this promotion code can be redeemed.
   */
  max_redemptions?: number | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'promotion_code';
  restrictions: promotion_codes_resource_restrictions;
  /**
   * Number of times this promotion code has been used.
   */
  times_redeemed: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object85 = 'promotion_code';

export type promotion_code_currency_option = {
  /**
   * Minimum amount required to redeem this Promotion Code into a Coupon (e.g., a purchase must be $100 or more to work).
   */
  minimum_amount: number;
};

export type promotion_codes_resource_restrictions = {
  /**
   * Promotion code restrictions defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).
   */
  currency_options?: {
    [key: string]: promotion_code_currency_option;
  };
  /**
   * A Boolean indicating if the Promotion Code should only be redeemed for Customers without any successful payments or invoices
   */
  first_time_transaction: boolean;
  /**
   * Minimum amount required to redeem this Promotion Code into a Coupon (e.g., a purchase must be $100 or more to work).
   */
  minimum_amount?: number | null;
  /**
   * Three-letter [ISO code](https://stripe.com/docs/currencies) for minimum_amount
   */
  minimum_amount_currency?: string | null;
};

/**
 * A Quote is a way to model prices that you'd like to provide to a customer.
 * Once accepted, it will automatically create an invoice, subscription or subscription schedule.
 */
export type quote = {
  /**
   * Total before any discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total after discounts and taxes are applied.
   */
  amount_total: number;
  /**
   * ID of the Connect Application that created the quote.
   */
  application?: (string | application | deleted_application) | null;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. Only applicable if there are no line items with recurring prices on the quote.
   */
  application_fee_amount?: number | null;
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account. Only applicable if there are line items with recurring prices on the quote.
   */
  application_fee_percent?: number | null;
  automatic_tax: quotes_resource_automatic_tax;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay invoices at the end of the subscription cycle or on finalization using the default payment method attached to the subscription or customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions and mark the subscription as `active`. Defaults to `charge_automatically`.
   */
  collection_method: 'charge_automatically' | 'send_invoice';
  computed: quotes_resource_computed;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency?: string | null;
  /**
   * The customer which this quote belongs to. A customer is required before finalizing the quote. Once specified, it cannot be changed.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * The tax rates applied to this quote.
   */
  default_tax_rates?: Array<string | tax_rate>;
  /**
   * A description that will be displayed on the quote PDF.
   */
  description?: string | null;
  /**
   * The discounts applied to this quote.
   */
  discounts: Array<string | discount>;
  /**
   * The date on which the quote will be canceled if in `open` or `draft` status. Measured in seconds since the Unix epoch.
   */
  expires_at: number;
  /**
   * A footer that will be displayed on the quote PDF.
   */
  footer?: string | null;
  /**
   * Details of the quote that was cloned. See the [cloning documentation](https://stripe.com/docs/quotes/clone) for more details.
   */
  from_quote?: quotes_resource_from_quote | null;
  /**
   * A header that will be displayed on the quote PDF.
   */
  header?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The invoice that was created from this quote.
   */
  invoice?: (string | invoice | deleted_invoice) | null;
  invoice_settings: invoice_setting_quote_setting;
  /**
   * A list of items the customer is being quoted for.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * A unique number that identifies this particular quote. This number is assigned once the quote is [finalized](https://stripe.com/docs/quotes/overview#finalize).
   */
  number?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'quote';
  /**
   * The account on behalf of which to charge. See the [Connect documentation](https://support.stripe.com/questions/sending-invoices-on-behalf-of-connected-accounts) for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * The status of the quote.
   */
  status: 'accepted' | 'canceled' | 'draft' | 'open';
  status_transitions: quotes_resource_status_transitions;
  /**
   * The subscription that was created or updated from this quote.
   */
  subscription?: (string | subscription) | null;
  subscription_data: quotes_resource_subscription_data_subscription_data;
  /**
   * The subscription schedule that was created or updated from this quote.
   */
  subscription_schedule?: (string | subscription_schedule) | null;
  /**
   * ID of the test clock this quote belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
  total_details: quotes_resource_total_details;
  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from each payment will be transferred to for each of the invoices.
   */
  transfer_data?: quotes_resource_transfer_data | null;
};

/**
 * The status of the quote.
 */
export type status28 = 'accepted' | 'canceled' | 'draft' | 'open';

export type quotes_resource_automatic_tax = {
  /**
   * Automatically calculate taxes
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
  /**
   * The status of the most recent automated tax calculation for this quote.
   */
  status?: ('complete' | 'failed' | 'requires_location_inputs') | null;
};

export type quotes_resource_computed = {
  /**
   * The definitive totals and line items the customer will be charged on a recurring basis. Takes into account the line items with recurring prices and discounts with `duration=forever` coupons only. Defaults to `null` if no inputted line items with recurring prices.
   */
  recurring?: quotes_resource_recurring | null;
  upfront: quotes_resource_upfront;
};

export type quotes_resource_from_quote = {
  /**
   * Whether this quote is a revision of a different quote.
   */
  is_revision: boolean;
  /**
   * The quote that was cloned.
   */
  quote: string | quote;
};

export type quotes_resource_recurring = {
  /**
   * Total before any discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total after discounts and taxes are applied.
   */
  amount_total: number;
  /**
   * The frequency at which a subscription is billed. One of `day`, `week`, `month` or `year`.
   */
  interval: 'day' | 'month' | 'week' | 'year';
  /**
   * The number of intervals (specified in the `interval` attribute) between subscription billings. For example, `interval=month` and `interval_count=3` bills every 3 months.
   */
  interval_count: number;
  total_details: quotes_resource_total_details;
};

export type quotes_resource_status_transitions = {
  /**
   * The time that the quote was accepted. Measured in seconds since Unix epoch.
   */
  accepted_at?: number | null;
  /**
   * The time that the quote was canceled. Measured in seconds since Unix epoch.
   */
  canceled_at?: number | null;
  /**
   * The time that the quote was finalized. Measured in seconds since Unix epoch.
   */
  finalized_at?: number | null;
};

export type quotes_resource_subscription_data_subscription_data = {
  /**
   * The subscription's description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
   */
  description?: string | null;
  /**
   * When creating a new subscription, the date of which the subscription schedule will start after the quote is accepted. This date is ignored if it is in the past when the quote is accepted. Measured in seconds since the Unix epoch.
   */
  effective_date?: number | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that will set metadata on the subscription or subscription schedule when the quote is accepted. If a recurring price is included in `line_items`, this field will be passed to the resulting subscription's `metadata` field. If `subscription_data.effective_date` is used, this field will be passed to the resulting subscription schedule's `phases.metadata` field. Unlike object-level metadata, this field is declarative. Updates will clear prior values.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * Integer representing the number of trial period days before the customer is charged for the first time.
   */
  trial_period_days?: number | null;
};

export type quotes_resource_total_details = {
  /**
   * This is the sum of all the discounts.
   */
  amount_discount: number;
  /**
   * This is the sum of all the shipping amounts.
   */
  amount_shipping?: number | null;
  /**
   * This is the sum of all the tax amounts.
   */
  amount_tax: number;
  breakdown?: quotes_resource_total_details_resource_breakdown;
};

export type quotes_resource_total_details_resource_breakdown = {
  /**
   * The aggregated discounts.
   */
  discounts: Array<line_items_discount_amount>;
  /**
   * The aggregated tax amounts by rate.
   */
  taxes: Array<line_items_tax_amount>;
};

export type quotes_resource_transfer_data = {
  /**
   * The amount in cents (or local equivalent) that will be transferred to the destination account when the invoice is paid. By default, the entire amount is transferred to the destination.
   */
  amount?: number | null;
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the destination account. By default, the entire amount will be transferred to the destination.
   */
  amount_percent?: number | null;
  /**
   * The account where funds from the payment will be transferred to upon payment success.
   */
  destination: string | account;
};

export type quotes_resource_upfront = {
  /**
   * Total before any discounts or taxes are applied.
   */
  amount_subtotal: number;
  /**
   * Total after discounts and taxes are applied.
   */
  amount_total: number;
  /**
   * The line items that will appear on the next invoice after this quote is accepted. This does not include pending invoice items that exist on the customer but may still be included in the next invoice.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  total_details: quotes_resource_total_details;
};

/**
 * An early fraud warning indicates that the card issuer has notified us that a
 * charge may be fraudulent.
 *
 * Related guide: [Early fraud warnings](https://stripe.com/docs/disputes/measuring#early-fraud-warnings)
 */
export type radar_early_fraud_warning = {
  /**
   * An EFW is actionable if it has not received a dispute and has not been fully refunded. You may wish to proactively refund a charge that receives an EFW, in order to avoid receiving a dispute later.
   */
  actionable: boolean;
  /**
   * ID of the charge this early fraud warning is for, optionally expanded.
   */
  charge: string | charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The type of fraud labelled by the issuer. One of `card_never_received`, `fraudulent_card_application`, `made_with_counterfeit_card`, `made_with_lost_card`, `made_with_stolen_card`, `misc`, `unauthorized_use_of_card`.
   */
  fraud_type: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'radar.early_fraud_warning';
  /**
   * ID of the Payment Intent this early fraud warning is for, optionally expanded.
   */
  payment_intent?: string | payment_intent;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object86 = 'radar.early_fraud_warning';

/**
 * Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
 */
export type radar_radar_options = {
  /**
   * A [Radar Session](https://stripe.com/docs/radar/radar-session) is a snapshot of the browser metadata and device details that help Radar make more accurate predictions on your payments.
   */
  session?: string;
};

export type radar_review_resource_location = {
  /**
   * The city where the payment originated.
   */
  city?: string | null;
  /**
   * Two-letter ISO code representing the country where the payment originated.
   */
  country?: string | null;
  /**
   * The geographic latitude where the payment originated.
   */
  latitude?: number | null;
  /**
   * The geographic longitude where the payment originated.
   */
  longitude?: number | null;
  /**
   * The state/county/province/region where the payment originated.
   */
  region?: string | null;
};

export type radar_review_resource_session = {
  /**
   * The browser used in this browser session (e.g., `Chrome`).
   */
  browser?: string | null;
  /**
   * Information about the device used for the browser session (e.g., `Samsung SM-G930T`).
   */
  device?: string | null;
  /**
   * The platform for the browser session (e.g., `Macintosh`).
   */
  platform?: string | null;
  /**
   * The version for the browser session (e.g., `61.0.3163.100`).
   */
  version?: string | null;
};

/**
 * Value lists allow you to group values together which can then be referenced in rules.
 *
 * Related guide: [Default Stripe lists](https://stripe.com/docs/radar/lists#managing-list-items)
 */
export type radar_value_list = {
  /**
   * The name of the value list for use in rules.
   */
  alias: string;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The name or email address of the user who created this value list.
   */
  created_by: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The type of items in the value list. One of `card_fingerprint`, `us_bank_account_fingerprint`, `sepa_debit_fingerprint`, `card_bin`, `email`, `ip_address`, `country`, `string`, `case_sensitive_string`, or `customer_id`.
   */
  item_type:
    | 'card_bin'
    | 'card_fingerprint'
    | 'case_sensitive_string'
    | 'country'
    | 'customer_id'
    | 'email'
    | 'ip_address'
    | 'sepa_debit_fingerprint'
    | 'string'
    | 'us_bank_account_fingerprint';
  /**
   * List of items contained within this value list.
   */
  list_items: {
    /**
     * Details about each object.
     */
    data: Array<radar_value_list_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * The name of the value list.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'radar.value_list';
};

/**
 * The type of items in the value list. One of `card_fingerprint`, `us_bank_account_fingerprint`, `sepa_debit_fingerprint`, `card_bin`, `email`, `ip_address`, `country`, `string`, `case_sensitive_string`, or `customer_id`.
 */
export type item_type =
  | 'card_bin'
  | 'card_fingerprint'
  | 'case_sensitive_string'
  | 'country'
  | 'customer_id'
  | 'email'
  | 'ip_address'
  | 'sepa_debit_fingerprint'
  | 'string'
  | 'us_bank_account_fingerprint';

/**
 * Value list items allow you to add specific values to a given Radar value list, which can then be used in rules.
 *
 * Related guide: [Managing list items](https://stripe.com/docs/radar/lists#managing-list-items)
 */
export type radar_value_list_item = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The name or email address of the user who added this item to the value list.
   */
  created_by: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'radar.value_list_item';
  /**
   * The value of the item.
   */
  value: string;
  /**
   * The identifier of the value list this item belongs to.
   */
  value_list: string;
};

export type received_payment_method_details_financial_account = {
  /**
   * The FinancialAccount ID.
   */
  id: string;
  /**
   * The rails the ReceivedCredit was sent over. A FinancialAccount can only send funds over `stripe`.
   */
  network: 'stripe';
};

export type recurring = {
  /**
   * Specifies a usage aggregation strategy for prices of `usage_type=metered`. Defaults to `sum`.
   */
  aggregate_usage?: ('last_during_period' | 'last_ever' | 'max' | 'sum') | null;
  /**
   * The frequency at which a subscription is billed. One of `day`, `week`, `month` or `year`.
   */
  interval: 'day' | 'month' | 'week' | 'year';
  /**
   * The number of intervals (specified in the `interval` attribute) between subscription billings. For example, `interval=month` and `interval_count=3` bills every 3 months.
   */
  interval_count: number;
  /**
   * The meter tracking the usage of a metered price
   */
  meter?: string | null;
  /**
   * Configures how the quantity per period should be determined. Can be either `metered` or `licensed`. `licensed` automatically bills the `quantity` set when adding it to a subscription. `metered` aggregates the total usage based on usage records. Defaults to `licensed`.
   */
  usage_type: 'licensed' | 'metered';
};

/**
 * Refund objects allow you to refund a previously created charge that isn't
 * refunded yet. Funds are refunded to the credit or debit card that's
 * initially charged.
 *
 * Related guide: [Refunds](https://stripe.com/docs/refunds)
 */
export type refund = {
  /**
   * Amount, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Balance transaction that describes the impact on your account balance.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * ID of the charge that's refunded.
   */
  charge?: (string | charge) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. You can use this for displaying to users (available on non-card refunds only).
   */
  description?: string;
  destination_details?: refund_destination_details;
  /**
   * After the refund fails, this balance transaction describes the adjustment made on your account balance that reverses the initial balance transaction.
   */
  failure_balance_transaction?: string | balance_transaction;
  /**
   * Provides the reason for the refund failure. Possible values are: `lost_or_stolen_card`, `expired_or_canceled_card`, `charge_for_pending_refund_disputed`, `insufficient_funds`, `declined`, `merchant_request`, or `unknown`.
   */
  failure_reason?: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * For payment methods without native refund support (for example, Konbini, PromptPay), provide an email address for the customer to receive refund instructions.
   */
  instructions_email?: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  next_action?: refund_next_action;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'refund';
  /**
   * ID of the PaymentIntent that's refunded.
   */
  payment_intent?: (string | payment_intent) | null;
  /**
   * Reason for the refund, which is either user-provided (`duplicate`, `fraudulent`, or `requested_by_customer`) or generated by Stripe internally (`expired_uncaptured_charge`).
   */
  reason?: ('duplicate' | 'expired_uncaptured_charge' | 'fraudulent' | 'requested_by_customer') | null;
  /**
   * This is the transaction number that appears on email receipts sent for this refund.
   */
  receipt_number?: string | null;
  /**
   * The transfer reversal that's associated with the refund. Only present if the charge came from another Stripe account.
   */
  source_transfer_reversal?: (string | transfer_reversal) | null;
  /**
   * Status of the refund. This can be `pending`, `requires_action`, `succeeded`, `failed`, or `canceled`. Learn more about [failed refunds](https://stripe.com/docs/refunds#failed-refunds).
   */
  status?: string | null;
  /**
   * This refers to the transfer reversal object if the accompanying transfer reverses. This is only applicable if the charge was created using the destination parameter.
   */
  transfer_reversal?: (string | transfer_reversal) | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object87 = 'refund';

/**
 * Reason for the refund, which is either user-provided (`duplicate`, `fraudulent`, or `requested_by_customer`) or generated by Stripe internally (`expired_uncaptured_charge`).
 */
export type reason6 = 'duplicate' | 'expired_uncaptured_charge' | 'fraudulent' | 'requested_by_customer';

export type refund_destination_details = {
  affirm?: destination_details_unimplemented;
  afterpay_clearpay?: destination_details_unimplemented;
  alipay?: destination_details_unimplemented;
  amazon_pay?: destination_details_unimplemented;
  au_bank_transfer?: destination_details_unimplemented;
  blik?: refund_destination_details_generic;
  br_bank_transfer?: refund_destination_details_generic;
  card?: refund_destination_details_card;
  cashapp?: destination_details_unimplemented;
  customer_cash_balance?: destination_details_unimplemented;
  eps?: destination_details_unimplemented;
  eu_bank_transfer?: refund_destination_details_generic;
  gb_bank_transfer?: refund_destination_details_generic;
  giropay?: destination_details_unimplemented;
  grabpay?: destination_details_unimplemented;
  jp_bank_transfer?: refund_destination_details_generic;
  klarna?: destination_details_unimplemented;
  multibanco?: refund_destination_details_generic;
  mx_bank_transfer?: refund_destination_details_generic;
  p24?: refund_destination_details_generic;
  paynow?: destination_details_unimplemented;
  paypal?: destination_details_unimplemented;
  pix?: destination_details_unimplemented;
  revolut?: destination_details_unimplemented;
  sofort?: destination_details_unimplemented;
  swish?: refund_destination_details_generic;
  th_bank_transfer?: refund_destination_details_generic;
  /**
   * The type of transaction-specific details of the payment method used in the refund (e.g., `card`). An additional hash is included on `destination_details` with a name matching this value. It contains information specific to the refund transaction.
   */
  type: string;
  us_bank_transfer?: refund_destination_details_generic;
  wechat_pay?: destination_details_unimplemented;
  zip?: destination_details_unimplemented;
};

export type refund_destination_details_card = {
  /**
   * Value of the reference number assigned to the refund.
   */
  reference?: string;
  /**
   * Status of the reference number on the refund. This can be `pending`, `available` or `unavailable`.
   */
  reference_status?: string;
  /**
   * Type of the reference number assigned to the refund.
   */
  reference_type?: string;
  /**
   * The type of refund. This can be `refund`, `reversal`, or `pending`.
   */
  type: 'pending' | 'refund' | 'reversal';
};

/**
 * The type of refund. This can be `refund`, `reversal`, or `pending`.
 */
export type type48 = 'pending' | 'refund' | 'reversal';

export type refund_destination_details_generic = {
  /**
   * The reference assigned to the refund.
   */
  reference?: string | null;
  /**
   * Status of the reference on the refund. This can be `pending`, `available` or `unavailable`.
   */
  reference_status?: string | null;
};

export type refund_next_action = {
  /**
   * Contains the refund details.
   */
  display_details?: refund_next_action_display_details | null;
  /**
   * Type of the next action to perform.
   */
  type: string;
};

export type refund_next_action_display_details = {
  email_sent: email_sent;
  /**
   * The expiry timestamp.
   */
  expires_at: number;
};

/**
 * The Report Run object represents an instance of a report type generated with
 * specific run parameters. Once the object is created, Stripe begins processing the report.
 * When the report has finished running, it will give you a reference to a file
 * where you can retrieve your results. For an overview, see
 * [API Access to Reports](https://stripe.com/docs/reporting/statements/api).
 *
 * Note that certain report types can only be run based on your live-mode data (not test-mode
 * data), and will error when queried without a [live-mode API key](https://stripe.com/docs/keys#test-live-modes).
 */
export type reporting_report_run = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * If something should go wrong during the run, a message about the failure (populated when
   * `status=failed`).
   */
  error?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * `true` if the report is run on live mode data and `false` if it is run on test mode data.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'reporting.report_run';
  parameters: financial_reporting_finance_report_run_run_parameters;
  /**
   * The ID of the [report type](https://stripe.com/docs/reports/report-types) to run, such as `"balance.summary.1"`.
   */
  report_type: string;
  /**
   * The file object representing the result of the report run (populated when
   * `status=succeeded`).
   */
  result?: file | null;
  /**
   * Status of this report run. This will be `pending` when the run is initially created.
   * When the run finishes, this will be set to `succeeded` and the `result` field will be populated.
   * Rarely, we may encounter an error, at which point this will be set to `failed` and the `error` field will be populated.
   */
  status: string;
  /**
   * Timestamp at which this run successfully finished (populated when
   * `status=succeeded`). Measured in seconds since the Unix epoch.
   */
  succeeded_at?: number | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object88 = 'reporting.report_run';

/**
 * The Report Type resource corresponds to a particular type of report, such as
 * the "Activity summary" or "Itemized payouts" reports. These objects are
 * identified by an ID belonging to a set of enumerated values. See
 * [API Access to Reports documentation](https://stripe.com/docs/reporting/statements/api)
 * for those Report Type IDs, along with required and optional parameters.
 *
 * Note that certain report types can only be run based on your live-mode data (not test-mode
 * data), and will error when queried without a [live-mode API key](https://stripe.com/docs/keys#test-live-modes).
 */
export type reporting_report_type = {
  /**
   * Most recent time for which this Report Type is available. Measured in seconds since the Unix epoch.
   */
  data_available_end: number;
  /**
   * Earliest time for which this Report Type is available. Measured in seconds since the Unix epoch.
   */
  data_available_start: number;
  /**
   * List of column names that are included by default when this Report Type gets run. (If the Report Type doesn't support the `columns` parameter, this will be null.)
   */
  default_columns?: Array<string> | null;
  /**
   * The [ID of the Report Type](https://stripe.com/docs/reporting/statements/api#available-report-types), such as `balance.summary.1`.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Human-readable name of the Report Type
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'reporting.report_type';
  /**
   * When this Report Type was latest updated. Measured in seconds since the Unix epoch.
   */
  updated: number;
  /**
   * Version of the Report Type. Different versions report with the same ID will have the same purpose, but may take different run parameters or have different result schemas.
   */
  version: number;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object89 = 'reporting.report_type';

export type reserve_transaction = {
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'reserve_transaction';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object90 = 'reserve_transaction';

/**
 * Reviews can be used to supplement automated fraud detection with human expertise.
 *
 * Learn more about [Radar](/radar) and reviewing payments
 * [here](https://stripe.com/docs/radar/reviews).
 */
export type review = {
  /**
   * The ZIP or postal code of the card used, if applicable.
   */
  billing_zip?: string | null;
  /**
   * The charge associated with this review.
   */
  charge?: (string | charge) | null;
  /**
   * The reason the review was closed, or null if it has not yet been closed. One of `approved`, `refunded`, `refunded_as_fraud`, `disputed`, or `redacted`.
   */
  closed_reason?: ('approved' | 'disputed' | 'redacted' | 'refunded' | 'refunded_as_fraud') | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The IP address where the payment originated.
   */
  ip_address?: string | null;
  /**
   * Information related to the location of the payment. Note that this information is an approximation and attempts to locate the nearest population center - it should not be used to determine a specific address.
   */
  ip_address_location?: radar_review_resource_location | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'review';
  /**
   * If `true`, the review needs action.
   */
  open: boolean;
  /**
   * The reason the review was opened. One of `rule` or `manual`.
   */
  opened_reason: 'manual' | 'rule';
  /**
   * The PaymentIntent ID associated with this review, if one exists.
   */
  payment_intent?: string | payment_intent;
  /**
   * The reason the review is currently open or closed. One of `rule`, `manual`, `approved`, `refunded`, `refunded_as_fraud`, `disputed`, or `redacted`.
   */
  reason: string;
  /**
   * Information related to the browsing session of the user who initiated the payment.
   */
  session?: radar_review_resource_session | null;
};

/**
 * The reason the review was closed, or null if it has not yet been closed. One of `approved`, `refunded`, `refunded_as_fraud`, `disputed`, or `redacted`.
 */
export type closed_reason = 'approved' | 'disputed' | 'redacted' | 'refunded' | 'refunded_as_fraud';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object91 = 'review';

/**
 * The reason the review was opened. One of `rule` or `manual`.
 */
export type opened_reason = 'manual' | 'rule';

export type rule = {
  /**
   * The action taken on the payment.
   */
  action: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The predicate to evaluate the payment against.
   */
  predicate: string;
};

/**
 * If you have [scheduled a Sigma query](https://stripe.com/docs/sigma/scheduled-queries), you'll
 * receive a `sigma.scheduled_query_run.created` webhook each time the query
 * runs. The webhook contains a `ScheduledQueryRun` object, which you can use to
 * retrieve the query results.
 */
export type scheduled_query_run = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * When the query was run, Sigma contained a snapshot of your Stripe data at this time.
   */
  data_load_time: number;
  error?: sigma_scheduled_query_run_error;
  /**
   * The file object representing the results of the query.
   */
  file?: file | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'scheduled_query_run';
  /**
   * Time at which the result expires and is no longer available for download.
   */
  result_available_until: number;
  /**
   * SQL for the query.
   */
  sql: string;
  /**
   * The query's execution status, which will be `completed` for successful runs, and `canceled`, `failed`, or `timed_out` otherwise.
   */
  status: string;
  /**
   * Title of the query.
   */
  title: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object92 = 'scheduled_query_run';

export type schedules_phase_automatic_tax = {
  /**
   * Whether Stripe automatically computes tax on invoices created during this phase.
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
};

export type secret_service_resource_scope = {
  /**
   * The secret scope type.
   */
  type: 'account' | 'user';
  /**
   * The user ID, if type is set to "user"
   */
  user?: string;
};

/**
 * The secret scope type.
 */
export type type49 = 'account' | 'user';

export type sepa_debit_generated_from = {
  /**
   * The ID of the Charge that generated this PaymentMethod, if any.
   */
  charge?: (string | charge) | null;
  /**
   * The ID of the SetupAttempt that generated this PaymentMethod, if any.
   */
  setup_attempt?: (string | setup_attempt) | null;
};

/**
 * A SetupAttempt describes one attempted confirmation of a SetupIntent,
 * whether that confirmation is successful or unsuccessful. You can use
 * SetupAttempts to inspect details of a specific attempt at setting up a
 * payment method using a SetupIntent.
 */
export type setup_attempt = {
  /**
   * The value of [application](https://stripe.com/docs/api/setup_intents/object#setup_intent_object-application) on the SetupIntent at the time of this confirmation.
   */
  application?: (string | application) | null;
  /**
   * If present, the SetupIntent's payment method will be attached to the in-context Stripe Account.
   *
   * It can only be used for this Stripe Account’s own money movement flows like InboundTransfer and OutboundTransfers. It cannot be set to true when setting up a PaymentMethod for a Customer, and defaults to false when attaching a PaymentMethod to a Customer.
   */
  attach_to_self?: boolean;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The value of [customer](https://stripe.com/docs/api/setup_intents/object#setup_intent_object-customer) on the SetupIntent at the time of this confirmation.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * Indicates the directions of money movement for which this payment method is intended to be used.
   *
   * Include `inbound` if you intend to use the payment method as the origin to pull funds from. Include `outbound` if you intend to use the payment method as the destination to send funds to. You can include both if you intend to use the payment method for both purposes.
   */
  flow_directions?: Array<'inbound' | 'outbound'> | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'setup_attempt';
  /**
   * The value of [on_behalf_of](https://stripe.com/docs/api/setup_intents/object#setup_intent_object-on_behalf_of) on the SetupIntent at the time of this confirmation.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * ID of the payment method used with this SetupAttempt.
   */
  payment_method: string | payment_method;
  payment_method_details: setup_attempt_payment_method_details;
  /**
   * The error encountered during this attempt to confirm the SetupIntent, if any.
   */
  setup_error?: api_errors | null;
  /**
   * ID of the SetupIntent that this attempt belongs to.
   */
  setup_intent: string | setup_intent;
  /**
   * Status of this SetupAttempt, one of `requires_confirmation`, `requires_action`, `processing`, `succeeded`, `failed`, or `abandoned`.
   */
  status: string;
  /**
   * The value of [usage](https://stripe.com/docs/api/setup_intents/object#setup_intent_object-usage) on the SetupIntent at the time of this confirmation, one of `off_session` or `on_session`.
   */
  usage: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object93 = 'setup_attempt';

export type setup_attempt_payment_method_details = {
  acss_debit?: setup_attempt_payment_method_details_acss_debit;
  amazon_pay?: setup_attempt_payment_method_details_amazon_pay;
  au_becs_debit?: setup_attempt_payment_method_details_au_becs_debit;
  bacs_debit?: setup_attempt_payment_method_details_bacs_debit;
  bancontact?: setup_attempt_payment_method_details_bancontact;
  boleto?: setup_attempt_payment_method_details_boleto;
  card?: setup_attempt_payment_method_details_card;
  card_present?: setup_attempt_payment_method_details_card_present;
  cashapp?: setup_attempt_payment_method_details_cashapp;
  ideal?: setup_attempt_payment_method_details_ideal;
  klarna?: setup_attempt_payment_method_details_klarna;
  link?: setup_attempt_payment_method_details_link;
  paypal?: setup_attempt_payment_method_details_paypal;
  revolut_pay?: setup_attempt_payment_method_details_revolut_pay;
  sepa_debit?: setup_attempt_payment_method_details_sepa_debit;
  sofort?: setup_attempt_payment_method_details_sofort;
  /**
   * The type of the payment method used in the SetupIntent (e.g., `card`). An additional hash is included on `payment_method_details` with a name matching this value. It contains confirmation-specific information for the payment method.
   */
  type: string;
  us_bank_account?: setup_attempt_payment_method_details_us_bank_account;
};

export type setup_attempt_payment_method_details_acss_debit = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_amazon_pay = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_au_becs_debit = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_bacs_debit = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_bancontact = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Bank Identifier Code of the bank associated with the bank account.
   */
  bic?: string | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Preferred language of the Bancontact authorization page that the customer is redirected to.
   * Can be one of `en`, `de`, `fr`, or `nl`
   */
  preferred_language?: ('de' | 'en' | 'fr' | 'nl') | null;
  /**
   * Owner's verified full name. Values are verified or provided by Bancontact directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

export type setup_attempt_payment_method_details_boleto = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_card = {
  /**
   * Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  brand?: string | null;
  /**
   * Check results by Card networks on Card address and CVC at the time of authorization
   */
  checks?: setup_attempt_payment_method_details_card_checks | null;
  /**
   * Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.
   */
  country?: string | null;
  /**
   * Two-digit number representing the card's expiration month.
   */
  exp_month?: number | null;
  /**
   * Four-digit number representing the card's expiration year.
   */
  exp_year?: number | null;
  /**
   * Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.
   *
   * *As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*
   */
  fingerprint?: string | null;
  /**
   * Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.
   */
  funding?: string | null;
  /**
   * The last four digits of the card.
   */
  last4?: string | null;
  /**
   * Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.
   */
  network?: string | null;
  /**
   * Populated if this authorization used 3D Secure authentication.
   */
  three_d_secure?: three_d_secure_details | null;
  /**
   * If this Card is part of a card wallet, this contains the details of the card wallet.
   */
  wallet?: setup_attempt_payment_method_details_card_wallet | null;
};

export type setup_attempt_payment_method_details_card_checks = {
  /**
   * If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_line1_check?: string | null;
  /**
   * If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  address_postal_code_check?: string | null;
  /**
   * If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.
   */
  cvc_check?: string | null;
};

export type setup_attempt_payment_method_details_card_present = {
  /**
   * The ID of the Card PaymentMethod which was generated by this SetupAttempt.
   */
  generated_card?: (string | payment_method) | null;
  /**
   * Details about payments collected offline.
   */
  offline?: payment_method_details_card_present_offline | null;
};

export type setup_attempt_payment_method_details_card_wallet = {
  apple_pay?: payment_method_details_card_wallet_apple_pay;
  google_pay?: payment_method_details_card_wallet_google_pay;
  /**
   * The type of the card wallet, one of `apple_pay`, `google_pay`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.
   */
  type: 'apple_pay' | 'google_pay' | 'link';
};

/**
 * The type of the card wallet, one of `apple_pay`, `google_pay`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.
 */
export type type50 = 'apple_pay' | 'google_pay' | 'link';

export type setup_attempt_payment_method_details_cashapp = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_ideal = {
  /**
   * The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.
   */
  bank?:
    | (
        | 'abn_amro'
        | 'asn_bank'
        | 'bunq'
        | 'handelsbanken'
        | 'ing'
        | 'knab'
        | 'moneyou'
        | 'n26'
        | 'nn'
        | 'rabobank'
        | 'regiobank'
        | 'revolut'
        | 'sns_bank'
        | 'triodos_bank'
        | 'van_lanschot'
        | 'yoursafe'
      )
    | null;
  /**
   * The Bank Identifier Code of the customer's bank.
   */
  bic?:
    | (
        | 'ABNANL2A'
        | 'ASNBNL21'
        | 'BITSNL2A'
        | 'BUNQNL2A'
        | 'FVLBNL22'
        | 'HANDNL2A'
        | 'INGBNL2A'
        | 'KNABNL2H'
        | 'MOYONL21'
        | 'NNBANL2G'
        | 'NTSBDEB1'
        | 'RABONL2U'
        | 'RBRBNL21'
        | 'REVOIE23'
        | 'REVOLT21'
        | 'SNSBNL2A'
        | 'TRIONL2U'
      )
    | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Owner's verified full name. Values are verified or provided by iDEAL directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

export type setup_attempt_payment_method_details_klarna = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_link = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_paypal = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_revolut_pay = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_sepa_debit = {
  [key: string]: unknown;
};

export type setup_attempt_payment_method_details_sofort = {
  /**
   * Bank code of bank associated with the bank account.
   */
  bank_code?: string | null;
  /**
   * Name of the bank associated with the bank account.
   */
  bank_name?: string | null;
  /**
   * Bank Identifier Code of the bank associated with the bank account.
   */
  bic?: string | null;
  /**
   * The ID of the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit?: (string | payment_method) | null;
  /**
   * The mandate for the SEPA Direct Debit PaymentMethod which was generated by this SetupAttempt.
   */
  generated_sepa_debit_mandate?: (string | mandate) | null;
  /**
   * Last four characters of the IBAN.
   */
  iban_last4?: string | null;
  /**
   * Preferred language of the Sofort authorization page that the customer is redirected to.
   * Can be one of `en`, `de`, `fr`, or `nl`
   */
  preferred_language?: ('de' | 'en' | 'fr' | 'nl') | null;
  /**
   * Owner's verified full name. Values are verified or provided by Sofort directly
   * (if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
};

export type setup_attempt_payment_method_details_us_bank_account = {
  [key: string]: unknown;
};

/**
 * A SetupIntent guides you through the process of setting up and saving a customer's payment credentials for future payments.
 * For example, you can use a SetupIntent to set up and save your customer's card without immediately collecting a payment.
 * Later, you can use [PaymentIntents](https://stripe.com/docs/api#payment_intents) to drive the payment flow.
 *
 * Create a SetupIntent when you're ready to collect your customer's payment credentials.
 * Don't maintain long-lived, unconfirmed SetupIntents because they might not be valid.
 * The SetupIntent transitions through multiple [statuses](https://docs.stripe.com/payments/intents#intent-statuses) as it guides
 * you through the setup process.
 *
 * Successful SetupIntents result in payment credentials that are optimized for future payments.
 * For example, cardholders in [certain regions](https://stripe.com/guides/strong-customer-authentication) might need to be run through
 * [Strong Customer Authentication](https://docs.stripe.com/strong-customer-authentication) during payment method collection
 * to streamline later [off-session payments](https://docs.stripe.com/payments/setup-intents).
 * If you use the SetupIntent with a [Customer](https://stripe.com/docs/api#setup_intent_object-customer),
 * it automatically attaches the resulting payment method to that Customer after successful setup.
 * We recommend using SetupIntents or [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage) on
 * PaymentIntents to save payment methods to prevent saving invalid or unoptimized payment methods.
 *
 * By using SetupIntents, you can reduce friction for your customers, even as regulations change over time.
 *
 * Related guide: [Setup Intents API](https://docs.stripe.com/payments/setup-intents)
 */
export type setup_intent = {
  /**
   * ID of the Connect application that created the SetupIntent.
   */
  application?: (string | application) | null;
  /**
   * If present, the SetupIntent's payment method will be attached to the in-context Stripe Account.
   *
   * It can only be used for this Stripe Account’s own money movement flows like InboundTransfer and OutboundTransfers. It cannot be set to true when setting up a PaymentMethod for a Customer, and defaults to false when attaching a PaymentMethod to a Customer.
   */
  attach_to_self?: boolean;
  /**
   * Settings for dynamic payment methods compatible with this Setup Intent
   */
  automatic_payment_methods?: payment_flows_automatic_payment_methods_setup_intent | null;
  /**
   * Reason for cancellation of this SetupIntent, one of `abandoned`, `requested_by_customer`, or `duplicate`.
   */
  cancellation_reason?: ('abandoned' | 'duplicate' | 'requested_by_customer') | null;
  /**
   * The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.
   *
   * The client secret can be used to complete payment setup from your frontend. It should not be stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.
   */
  client_secret?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * ID of the Customer this SetupIntent belongs to, if one exists.
   *
   * If present, the SetupIntent's payment method will be attached to the Customer on successful setup. Payment methods attached to other Customers cannot be used with this SetupIntent.
   */
  customer?: (string | customer | deleted_customer) | null;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Indicates the directions of money movement for which this payment method is intended to be used.
   *
   * Include `inbound` if you intend to use the payment method as the origin to pull funds from. Include `outbound` if you intend to use the payment method as the destination to send funds to. You can include both if you intend to use the payment method for both purposes.
   */
  flow_directions?: Array<'inbound' | 'outbound'> | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The error encountered in the previous SetupIntent confirmation.
   */
  last_setup_error?: api_errors | null;
  /**
   * The most recent SetupAttempt for this SetupIntent.
   */
  latest_attempt?: (string | setup_attempt) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * ID of the multi use Mandate generated by the SetupIntent.
   */
  mandate?: (string | mandate) | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * If present, this property tells you what actions you need to take in order for your customer to continue payment setup.
   */
  next_action?: setup_intent_next_action | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'setup_intent';
  /**
   * The account (if any) for which the setup is intended.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * ID of the payment method used with this SetupIntent.
   */
  payment_method?: (string | payment_method) | null;
  /**
   * Information about the payment method configuration used for this Setup Intent.
   */
  payment_method_configuration_details?: payment_method_config_biz_payment_method_configuration_details | null;
  /**
   * Payment method-specific configuration for this SetupIntent.
   */
  payment_method_options?: setup_intent_payment_method_options | null;
  /**
   * The list of payment method types (e.g. card) that this SetupIntent is allowed to set up.
   */
  payment_method_types: Array<string>;
  /**
   * ID of the single_use Mandate generated by the SetupIntent.
   */
  single_use_mandate?: (string | mandate) | null;
  /**
   * [Status](https://stripe.com/docs/payments/intents#intent-statuses) of this SetupIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `canceled`, or `succeeded`.
   */
  status:
    | 'canceled'
    | 'processing'
    | 'requires_action'
    | 'requires_confirmation'
    | 'requires_payment_method'
    | 'succeeded';
  /**
   * Indicates how the payment method is intended to be used in the future.
   *
   * Use `on_session` if you intend to only reuse the payment method when the customer is in your checkout flow. Use `off_session` if your customer may or may not be in your checkout flow. If not provided, this value defaults to `off_session`.
   */
  usage: string;
};

/**
 * Reason for cancellation of this SetupIntent, one of `abandoned`, `requested_by_customer`, or `duplicate`.
 */
export type cancellation_reason4 = 'abandoned' | 'duplicate' | 'requested_by_customer';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object94 = 'setup_intent';

/**
 * [Status](https://stripe.com/docs/payments/intents#intent-statuses) of this SetupIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `canceled`, or `succeeded`.
 */
export type status29 =
  | 'canceled'
  | 'processing'
  | 'requires_action'
  | 'requires_confirmation'
  | 'requires_payment_method'
  | 'succeeded';

export type setup_intent_next_action = {
  cashapp_handle_redirect_or_display_qr_code?: payment_intent_next_action_cashapp_handle_redirect_or_display_qr_code;
  redirect_to_url?: setup_intent_next_action_redirect_to_url;
  /**
   * Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.
   */
  type: string;
  /**
   * When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.
   */
  use_stripe_sdk?: {
    [key: string]: unknown;
  };
  verify_with_microdeposits?: setup_intent_next_action_verify_with_microdeposits;
};

export type setup_intent_next_action_redirect_to_url = {
  /**
   * If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
   */
  return_url?: string | null;
  /**
   * The URL you must redirect your customer to in order to authenticate.
   */
  url?: string | null;
};

export type setup_intent_next_action_verify_with_microdeposits = {
  /**
   * The timestamp when the microdeposits are expected to land.
   */
  arrival_date: number;
  /**
   * The URL for the hosted verification page, which allows customers to verify their bank account.
   */
  hosted_verification_url: string;
  /**
   * The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.
   */
  microdeposit_type?: ('amounts' | 'descriptor_code') | null;
};

export type setup_intent_payment_method_options = {
  acss_debit?:
    | setup_intent_payment_method_options_acss_debit
    | setup_intent_type_specific_payment_method_options_client;
  amazon_pay?:
    | setup_intent_payment_method_options_amazon_pay
    | setup_intent_type_specific_payment_method_options_client;
  card?: setup_intent_payment_method_options_card;
  card_present?:
    | setup_intent_payment_method_options_card_present
    | setup_intent_type_specific_payment_method_options_client;
  link?: setup_intent_payment_method_options_link | setup_intent_type_specific_payment_method_options_client;
  paypal?: setup_intent_payment_method_options_paypal | setup_intent_type_specific_payment_method_options_client;
  sepa_debit?:
    | setup_intent_payment_method_options_sepa_debit
    | setup_intent_type_specific_payment_method_options_client;
  us_bank_account?:
    | setup_intent_payment_method_options_us_bank_account
    | setup_intent_type_specific_payment_method_options_client;
};

export type setup_intent_payment_method_options_acss_debit = {
  /**
   * Currency supported by the bank account
   */
  currency?: ('cad' | 'usd') | null;
  mandate_options?: setup_intent_payment_method_options_mandate_options_acss_debit;
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type setup_intent_payment_method_options_amazon_pay = {
  [key: string]: unknown;
};

export type setup_intent_payment_method_options_card = {
  /**
   * Configuration options for setting up an eMandate for cards issued in India.
   */
  mandate_options?: setup_intent_payment_method_options_card_mandate_options | null;
  /**
   * Selected network to process this SetupIntent on. Depends on the available networks of the card attached to the setup intent. Can be only set confirm-time.
   */
  network?:
    | (
        | 'amex'
        | 'cartes_bancaires'
        | 'diners'
        | 'discover'
        | 'eftpos_au'
        | 'interac'
        | 'jcb'
        | 'mastercard'
        | 'unionpay'
        | 'unknown'
        | 'visa'
      )
    | null;
  /**
   * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
   */
  request_three_d_secure?: ('any' | 'automatic' | 'challenge') | null;
};

export type setup_intent_payment_method_options_card_mandate_options = {
  /**
   * Amount to be charged for future payments.
   */
  amount: number;
  /**
   * One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
   */
  amount_type: 'fixed' | 'maximum';
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * A description of the mandate or subscription that is meant to be displayed to the customer.
   */
  description?: string | null;
  /**
   * End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.
   */
  end_date?: number | null;
  /**
   * Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
   */
  interval: 'day' | 'month' | 'sporadic' | 'week' | 'year';
  /**
   * The number of intervals between payments. For example, `interval=month` and `interval_count=3` indicates one payment every three months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks). This parameter is optional when `interval=sporadic`.
   */
  interval_count?: number | null;
  /**
   * Unique identifier for the mandate or subscription.
   */
  reference: string;
  /**
   * Start date of the mandate or subscription. Start date should not be lesser than yesterday.
   */
  start_date: number;
  /**
   * Specifies the type of mandates supported. Possible values are `india`.
   */
  supported_types?: Array<'india'> | null;
};

export type setup_intent_payment_method_options_card_present = {
  [key: string]: unknown;
};

export type setup_intent_payment_method_options_link = {
  [key: string]: unknown;
};

export type setup_intent_payment_method_options_mandate_options_acss_debit = {
  /**
   * A URL for custom mandate text
   */
  custom_mandate_url?: string;
  /**
   * List of Stripe products where this mandate can be selected automatically.
   */
  default_for?: Array<'invoice' | 'subscription'>;
  /**
   * Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
   */
  interval_description?: string | null;
  /**
   * Payment schedule for the mandate.
   */
  payment_schedule?: ('combined' | 'interval' | 'sporadic') | null;
  /**
   * Transaction type of the mandate.
   */
  transaction_type?: ('business' | 'personal') | null;
};

export type setup_intent_payment_method_options_mandate_options_sepa_debit = {
  [key: string]: unknown;
};

export type setup_intent_payment_method_options_paypal = {
  /**
   * The PayPal Billing Agreement ID (BAID). This is an ID generated by PayPal which represents the mandate between the merchant and the customer.
   */
  billing_agreement_id?: string | null;
};

export type setup_intent_payment_method_options_sepa_debit = {
  mandate_options?: setup_intent_payment_method_options_mandate_options_sepa_debit;
};

export type setup_intent_payment_method_options_us_bank_account = {
  financial_connections?: linked_account_options_us_bank_account;
  mandate_options?: payment_method_options_us_bank_account_mandate_options;
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type setup_intent_type_specific_payment_method_options_client = {
  /**
   * Bank account verification method.
   */
  verification_method?: 'automatic' | 'instant' | 'microdeposits';
};

export type shipping = {
  address?: address;
  /**
   * The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc.
   */
  carrier?: string | null;
  /**
   * Recipient name.
   */
  name?: string;
  /**
   * Recipient phone (including extension).
   */
  phone?: string | null;
  /**
   * The tracking number for a physical product, obtained from the delivery service. If multiple tracking numbers were generated for this purchase, please separate them with commas.
   */
  tracking_number?: string | null;
};

/**
 * Shipping rates describe the price of shipping presented to your customers and
 * applied to a purchase. For more information, see [Charge for shipping](https://stripe.com/docs/payments/during-payment/charge-shipping).
 */
export type shipping_rate = {
  /**
   * Whether the shipping rate can be used for new purchases. Defaults to `true`.
   */
  active: boolean;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The estimated range for how long shipping will take, meant to be displayable to the customer. This will appear on CheckoutSessions.
   */
  delivery_estimate?: shipping_rate_delivery_estimate | null;
  /**
   * The name of the shipping rate, meant to be displayable to the customer. This will appear on CheckoutSessions.
   */
  display_name?: string | null;
  fixed_amount?: shipping_rate_fixed_amount;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'shipping_rate';
  /**
   * Specifies whether the rate is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`.
   */
  tax_behavior?: ('exclusive' | 'inclusive' | 'unspecified') | null;
  /**
   * A [tax code](https://stripe.com/docs/tax/tax-categories) ID. The Shipping tax code is `txcd_92010001`.
   */
  tax_code?: (string | tax_code) | null;
  /**
   * The type of calculation to use on the shipping rate.
   */
  type: 'fixed_amount';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object95 = 'shipping_rate';

/**
 * The type of calculation to use on the shipping rate.
 */
export type type51 = 'fixed_amount';

export type shipping_rate_currency_option = {
  /**
   * A non-negative integer in cents representing how much to charge.
   */
  amount: number;
  /**
   * Specifies whether the rate is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`.
   */
  tax_behavior: 'exclusive' | 'inclusive' | 'unspecified';
};

export type shipping_rate_delivery_estimate = {
  /**
   * The upper bound of the estimated range. If empty, represents no upper bound i.e., infinite.
   */
  maximum?: shipping_rate_delivery_estimate_bound | null;
  /**
   * The lower bound of the estimated range. If empty, represents no lower bound.
   */
  minimum?: shipping_rate_delivery_estimate_bound | null;
};

export type shipping_rate_delivery_estimate_bound = {
  /**
   * A unit of time.
   */
  unit: 'business_day' | 'day' | 'hour' | 'month' | 'week';
  /**
   * Must be greater than 0.
   */
  value: number;
};

/**
 * A unit of time.
 */
export type unit = 'business_day' | 'day' | 'hour' | 'month' | 'week';

export type shipping_rate_fixed_amount = {
  /**
   * A non-negative integer in cents representing how much to charge.
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Shipping rates defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).
   */
  currency_options?: {
    [key: string]: shipping_rate_currency_option;
  };
};

export type sigma_scheduled_query_run_error = {
  /**
   * Information about the run failure.
   */
  message: string;
};

/**
 * `Source` objects allow you to accept a variety of payment methods. They
 * represent a customer's payment instrument, and can be used with the Stripe API
 * just like a `Card` object: once chargeable, they can be charged, or can be
 * attached to customers.
 *
 * Stripe doesn't recommend using the deprecated [Sources API](https://stripe.com/docs/api/sources).
 * We recommend that you adopt the [PaymentMethods API](https://stripe.com/docs/api/payment_methods).
 * This newer API provides access to our latest features and payment method types.
 *
 * Related guides: [Sources API](https://stripe.com/docs/sources) and [Sources & Customers](https://stripe.com/docs/sources/customers).
 */
export type source2 = {
  ach_credit_transfer?: source_type_ach_credit_transfer;
  ach_debit?: source_type_ach_debit;
  acss_debit?: source_type_acss_debit;
  alipay?: source_type_alipay;
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1, Japanese Yen being a zero-decimal currency) representing the total amount associated with the source. This is the amount for which the source will be chargeable once ready. Required for `single_use` sources.
   */
  amount?: number | null;
  au_becs_debit?: source_type_au_becs_debit;
  bancontact?: source_type_bancontact;
  card?: source_type_card;
  card_present?: source_type_card_present;
  /**
   * The client secret of the source. Used for client-side retrieval using a publishable key.
   */
  client_secret: string;
  code_verification?: source_code_verification_flow;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) associated with the source. This is the currency for which the source will be chargeable once ready. Required for `single_use` sources.
   */
  currency?: string | null;
  /**
   * The ID of the customer to which this source is attached. This will not be present when the source has not been attached to a customer.
   */
  customer?: string;
  eps?: source_type_eps;
  /**
   * The authentication `flow` of the source. `flow` is one of `redirect`, `receiver`, `code_verification`, `none`.
   */
  flow: string;
  giropay?: source_type_giropay;
  /**
   * Unique identifier for the object.
   */
  id: string;
  ideal?: source_type_ideal;
  klarna?: source_type_klarna;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  multibanco?: source_type_multibanco;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'source';
  /**
   * Information about the owner of the payment instrument that may be used or required by particular source types.
   */
  owner?: source_owner | null;
  p24?: source_type_p24;
  receiver?: source_receiver_flow;
  redirect?: source_redirect_flow;
  sepa_debit?: source_type_sepa_debit;
  sofort?: source_type_sofort;
  source_order?: source_order;
  /**
   * Extra information about a source. This will appear on your customer's statement every time you charge the source.
   */
  statement_descriptor?: string | null;
  /**
   * The status of the source, one of `canceled`, `chargeable`, `consumed`, `failed`, or `pending`. Only `chargeable` sources can be used to create a charge.
   */
  status: string;
  three_d_secure?: source_type_three_d_secure;
  /**
   * The `type` of the source. The `type` is a payment method, one of `ach_credit_transfer`, `ach_debit`, `alipay`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `multibanco`, `klarna`, `p24`, `sepa_debit`, `sofort`, `three_d_secure`, or `wechat`. An additional hash is included on the source with a name matching this value. It contains additional information specific to the [payment method](https://stripe.com/docs/sources) used.
   */
  type:
    | 'ach_credit_transfer'
    | 'ach_debit'
    | 'acss_debit'
    | 'alipay'
    | 'au_becs_debit'
    | 'bancontact'
    | 'card'
    | 'card_present'
    | 'eps'
    | 'giropay'
    | 'ideal'
    | 'klarna'
    | 'multibanco'
    | 'p24'
    | 'sepa_debit'
    | 'sofort'
    | 'three_d_secure'
    | 'wechat';
  /**
   * Either `reusable` or `single_use`. Whether this source should be reusable or not. Some source types may or may not be reusable by construction, while others may leave the option at creation. If an incompatible value is passed, an error will be returned.
   */
  usage?: string | null;
  wechat?: source_type_wechat;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object96 = 'source';

/**
 * The `type` of the source. The `type` is a payment method, one of `ach_credit_transfer`, `ach_debit`, `alipay`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `multibanco`, `klarna`, `p24`, `sepa_debit`, `sofort`, `three_d_secure`, or `wechat`. An additional hash is included on the source with a name matching this value. It contains additional information specific to the [payment method](https://stripe.com/docs/sources) used.
 */
export type type52 =
  | 'ach_credit_transfer'
  | 'ach_debit'
  | 'acss_debit'
  | 'alipay'
  | 'au_becs_debit'
  | 'bancontact'
  | 'card'
  | 'card_present'
  | 'eps'
  | 'giropay'
  | 'ideal'
  | 'klarna'
  | 'multibanco'
  | 'p24'
  | 'sepa_debit'
  | 'sofort'
  | 'three_d_secure'
  | 'wechat';

export type source_code_verification_flow = {
  /**
   * The number of attempts remaining to authenticate the source object with a verification code.
   */
  attempts_remaining: number;
  /**
   * The status of the code verification, either `pending` (awaiting verification, `attempts_remaining` should be greater than 0), `succeeded` (successful verification) or `failed` (failed verification, cannot be verified anymore as `attempts_remaining` should be 0).
   */
  status: string;
};

/**
 * Source mandate notifications should be created when a notification related to
 * a source mandate must be sent to the payer. They will trigger a webhook or
 * deliver an email to the customer.
 */
export type source_mandate_notification = {
  acss_debit?: source_mandate_notification_acss_debit_data;
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1, Japanese Yen being a zero-decimal currency) representing the amount associated with the mandate notification. The amount is expressed in the currency of the underlying source. Required if the notification type is `debit_initiated`.
   */
  amount?: number | null;
  bacs_debit?: source_mandate_notification_bacs_debit_data;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'source_mandate_notification';
  /**
   * The reason of the mandate notification. Valid reasons are `mandate_confirmed` or `debit_initiated`.
   */
  reason: string;
  sepa_debit?: source_mandate_notification_sepa_debit_data;
  source: source;
  /**
   * The status of the mandate notification. Valid statuses are `pending` or `submitted`.
   */
  status: string;
  /**
   * The type of source this mandate notification is attached to. Should be the source type identifier code for the payment method, such as `three_d_secure`.
   */
  type: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object97 = 'source_mandate_notification';

export type source_mandate_notification_acss_debit_data = {
  /**
   * The statement descriptor associate with the debit.
   */
  statement_descriptor?: string;
};

export type source_mandate_notification_bacs_debit_data = {
  /**
   * Last 4 digits of the account number associated with the debit.
   */
  last4?: string;
};

export type source_mandate_notification_sepa_debit_data = {
  /**
   * SEPA creditor ID.
   */
  creditor_identifier?: string;
  /**
   * Last 4 digits of the account number associated with the debit.
   */
  last4?: string;
  /**
   * Mandate reference associated with the debit.
   */
  mandate_reference?: string;
};

export type source_order = {
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1, Japanese Yen being a zero-decimal currency) representing the total amount for the order.
   */
  amount: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The email address of the customer placing the order.
   */
  email?: string;
  /**
   * List of items constituting the order.
   */
  items?: Array<source_order_item> | null;
  shipping?: shipping;
};

export type source_order_item = {
  /**
   * The amount (price) for this order item.
   */
  amount?: number | null;
  /**
   * This currency of this order item. Required when `amount` is present.
   */
  currency?: string | null;
  /**
   * Human-readable description for this order item.
   */
  description?: string | null;
  /**
   * The ID of the associated object for this line item. Expandable if not null (e.g., expandable to a SKU).
   */
  parent?: string | null;
  /**
   * The quantity of this order item. When type is `sku`, this is the number of instances of the SKU to be ordered.
   */
  quantity?: number;
  /**
   * The type of this order item. Must be `sku`, `tax`, or `shipping`.
   */
  type?: string | null;
};

export type source_owner = {
  /**
   * Owner's address.
   */
  address?: address | null;
  /**
   * Owner's email address.
   */
  email?: string | null;
  /**
   * Owner's full name.
   */
  name?: string | null;
  /**
   * Owner's phone number (including extension).
   */
  phone?: string | null;
  /**
   * Verified owner's address. Verified values are verified or provided by the payment method directly (and if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_address?: address | null;
  /**
   * Verified owner's email address. Verified values are verified or provided by the payment method directly (and if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_email?: string | null;
  /**
   * Verified owner's full name. Verified values are verified or provided by the payment method directly (and if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_name?: string | null;
  /**
   * Verified owner's phone number (including extension). Verified values are verified or provided by the payment method directly (and if supported) at the time of authorization or settlement. They cannot be set or mutated.
   */
  verified_phone?: string | null;
};

export type source_receiver_flow = {
  /**
   * The address of the receiver source. This is the value that should be communicated to the customer to send their funds to.
   */
  address?: string | null;
  /**
   * The total amount that was moved to your balance. This is almost always equal to the amount charged. In rare cases when customers deposit excess funds and we are unable to refund those, those funds get moved to your balance and show up in amount_charged as well. The amount charged is expressed in the source's currency.
   */
  amount_charged: number;
  /**
   * The total amount received by the receiver source. `amount_received = amount_returned + amount_charged` should be true for consumed sources unless customers deposit excess funds. The amount received is expressed in the source's currency.
   */
  amount_received: number;
  /**
   * The total amount that was returned to the customer. The amount returned is expressed in the source's currency.
   */
  amount_returned: number;
  /**
   * Type of refund attribute method, one of `email`, `manual`, or `none`.
   */
  refund_attributes_method: string;
  /**
   * Type of refund attribute status, one of `missing`, `requested`, or `available`.
   */
  refund_attributes_status: string;
};

export type source_redirect_flow = {
  /**
   * The failure reason for the redirect, either `user_abort` (the customer aborted or dropped out of the redirect flow), `declined` (the authentication failed or the transaction was declined), or `processing_error` (the redirect failed due to a technical error). Present only if the redirect status is `failed`.
   */
  failure_reason?: string | null;
  /**
   * The URL you provide to redirect the customer to after they authenticated their payment.
   */
  return_url: string;
  /**
   * The status of the redirect, either `pending` (ready to be used by your customer to authenticate the transaction), `succeeded` (succesful authentication, cannot be reused) or `not_required` (redirect should not be used) or `failed` (failed authentication, cannot be reused).
   */
  status: string;
  /**
   * The URL provided to you to redirect a customer to as part of a `redirect` authentication flow.
   */
  url: string;
};

/**
 * Some payment methods have no required amount that a customer must send.
 * Customers can be instructed to send any amount, and it can be made up of
 * multiple transactions. As such, sources can have multiple associated
 * transactions.
 */
export type source_transaction = {
  ach_credit_transfer?: source_transaction_ach_credit_transfer_data;
  /**
   * A positive integer in the smallest currency unit (that is, 100 cents for $1.00, or 1 for ¥1, Japanese Yen being a zero-decimal currency) representing the amount your customer has pushed to the receiver.
   */
  amount: number;
  chf_credit_transfer?: source_transaction_chf_credit_transfer_data;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  gbp_credit_transfer?: source_transaction_gbp_credit_transfer_data;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'source_transaction';
  paper_check?: source_transaction_paper_check_data;
  sepa_credit_transfer?: source_transaction_sepa_credit_transfer_data;
  /**
   * The ID of the source this transaction is attached to.
   */
  source: string;
  /**
   * The status of the transaction, one of `succeeded`, `pending`, or `failed`.
   */
  status: string;
  /**
   * The type of source this transaction is attached to.
   */
  type:
    | 'ach_credit_transfer'
    | 'ach_debit'
    | 'alipay'
    | 'bancontact'
    | 'card'
    | 'card_present'
    | 'eps'
    | 'giropay'
    | 'ideal'
    | 'klarna'
    | 'multibanco'
    | 'p24'
    | 'sepa_debit'
    | 'sofort'
    | 'three_d_secure'
    | 'wechat';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object98 = 'source_transaction';

/**
 * The type of source this transaction is attached to.
 */
export type type53 =
  | 'ach_credit_transfer'
  | 'ach_debit'
  | 'alipay'
  | 'bancontact'
  | 'card'
  | 'card_present'
  | 'eps'
  | 'giropay'
  | 'ideal'
  | 'klarna'
  | 'multibanco'
  | 'p24'
  | 'sepa_debit'
  | 'sofort'
  | 'three_d_secure'
  | 'wechat';

export type source_transaction_ach_credit_transfer_data = {
  /**
   * Customer data associated with the transfer.
   */
  customer_data?: string;
  /**
   * Bank account fingerprint associated with the transfer.
   */
  fingerprint?: string;
  /**
   * Last 4 digits of the account number associated with the transfer.
   */
  last4?: string;
  /**
   * Routing number associated with the transfer.
   */
  routing_number?: string;
};

export type source_transaction_chf_credit_transfer_data = {
  /**
   * Reference associated with the transfer.
   */
  reference?: string;
  /**
   * Sender's country address.
   */
  sender_address_country?: string;
  /**
   * Sender's line 1 address.
   */
  sender_address_line1?: string;
  /**
   * Sender's bank account IBAN.
   */
  sender_iban?: string;
  /**
   * Sender's name.
   */
  sender_name?: string;
};

export type source_transaction_gbp_credit_transfer_data = {
  /**
   * Bank account fingerprint associated with the Stripe owned bank account receiving the transfer.
   */
  fingerprint?: string;
  /**
   * The credit transfer rails the sender used to push this transfer. The possible rails are: Faster Payments, BACS, CHAPS, and wire transfers. Currently only Faster Payments is supported.
   */
  funding_method?: string;
  /**
   * Last 4 digits of sender account number associated with the transfer.
   */
  last4?: string;
  /**
   * Sender entered arbitrary information about the transfer.
   */
  reference?: string;
  /**
   * Sender account number associated with the transfer.
   */
  sender_account_number?: string;
  /**
   * Sender name associated with the transfer.
   */
  sender_name?: string;
  /**
   * Sender sort code associated with the transfer.
   */
  sender_sort_code?: string;
};

export type source_transaction_paper_check_data = {
  /**
   * Time at which the deposited funds will be available for use. Measured in seconds since the Unix epoch.
   */
  available_at?: string;
  /**
   * Comma-separated list of invoice IDs associated with the paper check.
   */
  invoices?: string;
};

export type source_transaction_sepa_credit_transfer_data = {
  /**
   * Reference associated with the transfer.
   */
  reference?: string;
  /**
   * Sender's bank account IBAN.
   */
  sender_iban?: string;
  /**
   * Sender's name.
   */
  sender_name?: string;
};

export type source_type_ach_credit_transfer = {
  account_number?: string | null;
  bank_name?: string | null;
  fingerprint?: string | null;
  refund_account_holder_name?: string | null;
  refund_account_holder_type?: string | null;
  refund_routing_number?: string | null;
  routing_number?: string | null;
  swift_code?: string | null;
};

export type source_type_ach_debit = {
  bank_name?: string | null;
  country?: string | null;
  fingerprint?: string | null;
  last4?: string | null;
  routing_number?: string | null;
  type?: string | null;
};

export type source_type_acss_debit = {
  bank_address_city?: string | null;
  bank_address_line_1?: string | null;
  bank_address_line_2?: string | null;
  bank_address_postal_code?: string | null;
  bank_name?: string | null;
  category?: string | null;
  country?: string | null;
  fingerprint?: string | null;
  last4?: string | null;
  routing_number?: string | null;
};

export type source_type_alipay = {
  data_string?: string | null;
  native_url?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_au_becs_debit = {
  bsb_number?: string | null;
  fingerprint?: string | null;
  last4?: string | null;
};

export type source_type_bancontact = {
  bank_code?: string | null;
  bank_name?: string | null;
  bic?: string | null;
  iban_last4?: string | null;
  preferred_language?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_card = {
  address_line1_check?: string | null;
  address_zip_check?: string | null;
  brand?: string | null;
  country?: string | null;
  cvc_check?: string | null;
  dynamic_last4?: string | null;
  exp_month?: number | null;
  exp_year?: number | null;
  fingerprint?: string;
  funding?: string | null;
  last4?: string | null;
  name?: string | null;
  three_d_secure?: string;
  tokenization_method?: string | null;
};

export type source_type_card_present = {
  application_cryptogram?: string;
  application_preferred_name?: string;
  authorization_code?: string | null;
  authorization_response_code?: string;
  brand?: string | null;
  country?: string | null;
  cvm_type?: string;
  data_type?: string | null;
  dedicated_file_name?: string;
  emv_auth_data?: string;
  evidence_customer_signature?: string | null;
  evidence_transaction_certificate?: string | null;
  exp_month?: number | null;
  exp_year?: number | null;
  fingerprint?: string;
  funding?: string | null;
  last4?: string | null;
  pos_device_id?: string | null;
  pos_entry_mode?: string;
  read_method?: string | null;
  reader?: string | null;
  terminal_verification_results?: string;
  transaction_status_information?: string;
};

export type source_type_eps = {
  reference?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_giropay = {
  bank_code?: string | null;
  bank_name?: string | null;
  bic?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_ideal = {
  bank?: string | null;
  bic?: string | null;
  iban_last4?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_klarna = {
  background_image_url?: string;
  client_token?: string | null;
  first_name?: string;
  last_name?: string;
  locale?: string;
  logo_url?: string;
  page_title?: string;
  pay_later_asset_urls_descriptive?: string;
  pay_later_asset_urls_standard?: string;
  pay_later_name?: string;
  pay_later_redirect_url?: string;
  pay_now_asset_urls_descriptive?: string;
  pay_now_asset_urls_standard?: string;
  pay_now_name?: string;
  pay_now_redirect_url?: string;
  pay_over_time_asset_urls_descriptive?: string;
  pay_over_time_asset_urls_standard?: string;
  pay_over_time_name?: string;
  pay_over_time_redirect_url?: string;
  payment_method_categories?: string;
  purchase_country?: string;
  purchase_type?: string;
  redirect_url?: string;
  shipping_delay?: number;
  shipping_first_name?: string;
  shipping_last_name?: string;
};

export type source_type_multibanco = {
  entity?: string | null;
  reference?: string | null;
  refund_account_holder_address_city?: string | null;
  refund_account_holder_address_country?: string | null;
  refund_account_holder_address_line1?: string | null;
  refund_account_holder_address_line2?: string | null;
  refund_account_holder_address_postal_code?: string | null;
  refund_account_holder_address_state?: string | null;
  refund_account_holder_name?: string | null;
  refund_iban?: string | null;
};

export type source_type_p24 = {
  reference?: string | null;
};

export type source_type_sepa_debit = {
  bank_code?: string | null;
  branch_code?: string | null;
  country?: string | null;
  fingerprint?: string | null;
  last4?: string | null;
  mandate_reference?: string | null;
  mandate_url?: string | null;
};

export type source_type_sofort = {
  bank_code?: string | null;
  bank_name?: string | null;
  bic?: string | null;
  country?: string | null;
  iban_last4?: string | null;
  preferred_language?: string | null;
  statement_descriptor?: string | null;
};

export type source_type_three_d_secure = {
  address_line1_check?: string | null;
  address_zip_check?: string | null;
  authenticated?: boolean | null;
  brand?: string | null;
  card?: string | null;
  country?: string | null;
  customer?: string | null;
  cvc_check?: string | null;
  dynamic_last4?: string | null;
  exp_month?: number | null;
  exp_year?: number | null;
  fingerprint?: string;
  funding?: string | null;
  last4?: string | null;
  name?: string | null;
  three_d_secure?: string;
  tokenization_method?: string | null;
};

export type source_type_wechat = {
  prepay_id?: string;
  qr_code_url?: string | null;
  statement_descriptor?: string;
};

/**
 * Subscriptions allow you to charge a customer on a recurring basis.
 *
 * Related guide: [Creating subscriptions](https://stripe.com/docs/billing/subscriptions/creating)
 */
export type subscription = {
  /**
   * ID of the Connect Application that created the subscription.
   */
  application?: (string | application | deleted_application) | null;
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account.
   */
  application_fee_percent?: number | null;
  automatic_tax: subscription_automatic_tax;
  /**
   * The reference point that aligns future [billing cycle](https://stripe.com/docs/subscriptions/billing-cycle) dates. It sets the day of week for `week` intervals, the day of month for `month` and `year` intervals, and the month of year for `year` intervals. The timestamp is in UTC format.
   */
  billing_cycle_anchor: number;
  /**
   * The fixed values used to calculate the `billing_cycle_anchor`.
   */
  billing_cycle_anchor_config?: subscriptions_resource_billing_cycle_anchor_config | null;
  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period
   */
  billing_thresholds?: subscription_billing_thresholds | null;
  /**
   * A date in the future at which the subscription will automatically get canceled
   */
  cancel_at?: number | null;
  /**
   * If the subscription has been canceled with the `at_period_end` flag set to `true`, `cancel_at_period_end` on the subscription will be true. You can use this attribute to determine whether a subscription that has a status of active is scheduled to be canceled at the end of the current period.
   */
  cancel_at_period_end: boolean;
  /**
   * If the subscription has been canceled, the date of that cancellation. If the subscription was canceled with `cancel_at_period_end`, `canceled_at` will reflect the time of the most recent update request, not the end of the subscription period when the subscription is automatically moved to a canceled state.
   */
  canceled_at?: number | null;
  /**
   * Details about why this subscription was cancelled
   */
  cancellation_details?: cancellation_details | null;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this subscription at the end of the cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions and mark the subscription as `active`.
   */
  collection_method: 'charge_automatically' | 'send_invoice';
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * End of the current period that the subscription has been invoiced for. At the end of this period, a new invoice will be created.
   */
  current_period_end: number;
  /**
   * Start of the current period that the subscription has been invoiced for.
   */
  current_period_start: number;
  /**
   * ID of the customer who owns the subscription.
   */
  customer: string | customer | deleted_customer;
  /**
   * Number of days a customer has to pay invoices generated by this subscription. This value will be `null` for subscriptions where `collection_method=charge_automatically`.
   */
  days_until_due?: number | null;
  /**
   * ID of the default payment method for the subscription. It must belong to the customer associated with the subscription. This takes precedence over `default_source`. If neither are set, invoices will use the customer's [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) or [default_source](https://stripe.com/docs/api/customers/object#customer_object-default_source).
   */
  default_payment_method?: (string | payment_method) | null;
  /**
   * ID of the default payment source for the subscription. It must belong to the customer associated with the subscription and be in a chargeable state. If `default_payment_method` is also set, `default_payment_method` will take precedence. If neither are set, invoices will use the customer's [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) or [default_source](https://stripe.com/docs/api/customers/object#customer_object-default_source).
   */
  default_source?: (string | bank_account | card | source) | null;
  /**
   * The tax rates that will apply to any subscription item that does not have `tax_rates` set. Invoices created will have their `default_tax_rates` populated from the subscription.
   */
  default_tax_rates?: Array<tax_rate> | null;
  /**
   * The subscription's description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
   */
  description?: string | null;
  /**
   * Describes the current discount applied to this subscription, if there is one. When billing, a discount applied to a subscription overrides a discount applied on a customer-wide basis. This field has been deprecated and will be removed in a future API version. Use `discounts` instead.
   */
  discount?: discount | null;
  /**
   * The discounts applied to the subscription. Subscription item discounts are applied before subscription discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts: Array<string | discount>;
  /**
   * If the subscription has ended, the date the subscription ended.
   */
  ended_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  invoice_settings: subscriptions_resource_subscription_invoice_settings;
  /**
   * List of subscription items, each with an attached price.
   */
  items: {
    /**
     * Details about each object.
     */
    data: Array<subscription_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * The most recent invoice this subscription has generated.
   */
  latest_invoice?: (string | invoice) | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * Specifies the approximate timestamp on which any pending invoice items will be billed according to the schedule provided at `pending_invoice_item_interval`.
   */
  next_pending_invoice_item_invoice?: number | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'subscription';
  /**
   * The account (if any) the charge was made on behalf of for charges associated with this subscription. See the Connect documentation for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * If specified, payment collection for this subscription will be paused. Note that the subscription status will be unchanged and will not be updated to `paused`. Learn more about [pausing collection](/billing/subscriptions/pause-payment).
   */
  pause_collection?: subscriptions_resource_pause_collection | null;
  /**
   * Payment settings passed on to invoices created by the subscription.
   */
  payment_settings?: subscriptions_resource_payment_settings | null;
  /**
   * Specifies an interval for how often to bill for any pending invoice items. It is analogous to calling [Create an invoice](https://stripe.com/docs/api#create_invoice) for the given subscription at the specified interval.
   */
  pending_invoice_item_interval?: subscription_pending_invoice_item_interval | null;
  /**
   * You can use this [SetupIntent](https://stripe.com/docs/api/setup_intents) to collect user authentication when creating a subscription without immediate payment or updating a subscription's payment method, allowing you to optimize for off-session payments. Learn more in the [SCA Migration Guide](https://stripe.com/docs/billing/migration/strong-customer-authentication#scenario-2).
   */
  pending_setup_intent?: (string | setup_intent) | null;
  /**
   * If specified, [pending updates](https://stripe.com/docs/billing/subscriptions/pending-updates) that will be applied to the subscription once the `latest_invoice` has been paid.
   */
  pending_update?: subscriptions_resource_pending_update | null;
  /**
   * The schedule attached to the subscription
   */
  schedule?: (string | subscription_schedule) | null;
  /**
   * Date when the subscription was first created. The date might differ from the `created` date due to backdating.
   */
  start_date: number;
  /**
   * Possible values are `incomplete`, `incomplete_expired`, `trialing`, `active`, `past_due`, `canceled`, `unpaid`, or `paused`.
   *
   * For `collection_method=charge_automatically` a subscription moves into `incomplete` if the initial payment attempt fails. A subscription in this status can only have metadata and default_source updated. Once the first invoice is paid, the subscription moves into an `active` status. If the first invoice is not paid within 23 hours, the subscription transitions to `incomplete_expired`. This is a terminal status, the open invoice will be voided and no further invoices will be generated.
   *
   * A subscription that is currently in a trial period is `trialing` and moves to `active` when the trial period is over.
   *
   * A subscription can only enter a `paused` status [when a trial ends without a payment method](/billing/subscriptions/trials#create-free-trials-without-payment). A `paused` subscription doesn't generate invoices and can be resumed after your customer adds their payment method. The `paused` status is different from [pausing collection](/billing/subscriptions/pause-payment), which still generates invoices and leaves the subscription's status unchanged.
   *
   * If subscription `collection_method=charge_automatically`, it becomes `past_due` when payment is required but cannot be paid (due to failed payment or awaiting additional user actions). Once Stripe has exhausted all payment retry attempts, the subscription will become `canceled` or `unpaid` (depending on your subscriptions settings).
   *
   * If subscription `collection_method=send_invoice` it becomes `past_due` when its invoice is not paid by the due date, and `canceled` or `unpaid` if it is still not paid by an additional deadline after that. Note that when a subscription has a status of `unpaid`, no subsequent invoices will be attempted (invoices will be created, but then immediately automatically closed). After receiving updated payment information from a customer, you may choose to reopen and pay their closed invoices.
   */
  status: 'active' | 'canceled' | 'incomplete' | 'incomplete_expired' | 'past_due' | 'paused' | 'trialing' | 'unpaid';
  /**
   * ID of the test clock this subscription belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
  /**
   * The account (if any) the subscription's payments will be attributed to for tax reporting, and where funds from each payment will be transferred to for each of the subscription's invoices.
   */
  transfer_data?: subscription_transfer_data | null;
  /**
   * If the subscription has a trial, the end of that trial.
   */
  trial_end?: number | null;
  /**
   * Settings related to subscription trials.
   */
  trial_settings?: subscriptions_trials_resource_trial_settings | null;
  /**
   * If the subscription has a trial, the beginning of that trial.
   */
  trial_start?: number | null;
};

/**
 * Possible values are `incomplete`, `incomplete_expired`, `trialing`, `active`, `past_due`, `canceled`, `unpaid`, or `paused`.
 *
 * For `collection_method=charge_automatically` a subscription moves into `incomplete` if the initial payment attempt fails. A subscription in this status can only have metadata and default_source updated. Once the first invoice is paid, the subscription moves into an `active` status. If the first invoice is not paid within 23 hours, the subscription transitions to `incomplete_expired`. This is a terminal status, the open invoice will be voided and no further invoices will be generated.
 *
 * A subscription that is currently in a trial period is `trialing` and moves to `active` when the trial period is over.
 *
 * A subscription can only enter a `paused` status [when a trial ends without a payment method](/billing/subscriptions/trials#create-free-trials-without-payment). A `paused` subscription doesn't generate invoices and can be resumed after your customer adds their payment method. The `paused` status is different from [pausing collection](/billing/subscriptions/pause-payment), which still generates invoices and leaves the subscription's status unchanged.
 *
 * If subscription `collection_method=charge_automatically`, it becomes `past_due` when payment is required but cannot be paid (due to failed payment or awaiting additional user actions). Once Stripe has exhausted all payment retry attempts, the subscription will become `canceled` or `unpaid` (depending on your subscriptions settings).
 *
 * If subscription `collection_method=send_invoice` it becomes `past_due` when its invoice is not paid by the due date, and `canceled` or `unpaid` if it is still not paid by an additional deadline after that. Note that when a subscription has a status of `unpaid`, no subsequent invoices will be attempted (invoices will be created, but then immediately automatically closed). After receiving updated payment information from a customer, you may choose to reopen and pay their closed invoices.
 */
export type status30 =
  | 'active'
  | 'canceled'
  | 'incomplete'
  | 'incomplete_expired'
  | 'past_due'
  | 'paused'
  | 'trialing'
  | 'unpaid';

export type subscription_automatic_tax = {
  /**
   * Whether Stripe automatically computes tax on this subscription.
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
};

export type subscription_billing_thresholds = {
  /**
   * Monetary threshold that triggers the subscription to create an invoice
   */
  amount_gte?: number | null;
  /**
   * Indicates if the `billing_cycle_anchor` should be reset when a threshold is reached. If true, `billing_cycle_anchor` will be updated to the date/time the threshold was last reached; otherwise, the value will remain unchanged. This value may not be `true` if the subscription contains items with plans that have `aggregate_usage=last_ever`.
   */
  reset_billing_cycle_anchor?: boolean | null;
};

export type subscription_details_data = {
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) defined as subscription metadata when an invoice is created. Becomes an immutable snapshot of the subscription metadata at the time of invoice finalization.
   * *Note: This attribute is populated only for invoices created on or after June 29, 2023.*
   */
  metadata?: {
    [key: string]: string;
  } | null;
};

/**
 * Subscription items allow you to create customer subscriptions with more than
 * one plan, making it easy to represent complex billing relationships.
 */
export type subscription_item = {
  /**
   * Define thresholds at which an invoice will be sent, and the related subscription advanced to a new billing period
   */
  billing_thresholds?: subscription_item_billing_thresholds | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * The discounts applied to the subscription item. Subscription item discounts are applied before subscription discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts: Array<string | discount>;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'subscription_item';
  price: price;
  /**
   * The [quantity](https://stripe.com/docs/subscriptions/quantities) of the plan to which the customer should be subscribed.
   */
  quantity?: number;
  /**
   * The `subscription` this `subscription_item` belongs to.
   */
  subscription: string;
  /**
   * The tax rates which apply to this `subscription_item`. When set, the `default_tax_rates` on the subscription do not apply to this `subscription_item`.
   */
  tax_rates?: Array<tax_rate> | null;
};

export type subscription_item_billing_thresholds = {
  /**
   * Usage threshold that triggers the subscription to create an invoice
   */
  usage_gte?: number | null;
};

export type subscription_payment_method_options_card = {
  mandate_options?: invoice_mandate_options_card;
  /**
   * Selected network to process this Subscription on. Depends on the available networks of the card attached to the Subscription. Can be only set confirm-time.
   */
  network?:
    | (
        | 'amex'
        | 'cartes_bancaires'
        | 'diners'
        | 'discover'
        | 'eftpos_au'
        | 'interac'
        | 'jcb'
        | 'mastercard'
        | 'unionpay'
        | 'unknown'
        | 'visa'
      )
    | null;
  /**
   * We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
   */
  request_three_d_secure?: ('any' | 'automatic' | 'challenge') | null;
};

export type subscription_pending_invoice_item_interval = {
  /**
   * Specifies invoicing frequency. Either `day`, `week`, `month` or `year`.
   */
  interval: 'day' | 'month' | 'week' | 'year';
  /**
   * The number of intervals between invoices. For example, `interval=month` and `interval_count=3` bills every 3 months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks).
   */
  interval_count: number;
};

/**
 * A subscription schedule allows you to create and manage the lifecycle of a subscription by predefining expected changes.
 *
 * Related guide: [Subscription schedules](https://stripe.com/docs/billing/subscriptions/subscription-schedules)
 */
export type subscription_schedule = {
  /**
   * ID of the Connect Application that created the schedule.
   */
  application?: (string | application | deleted_application) | null;
  /**
   * Time at which the subscription schedule was canceled. Measured in seconds since the Unix epoch.
   */
  canceled_at?: number | null;
  /**
   * Time at which the subscription schedule was completed. Measured in seconds since the Unix epoch.
   */
  completed_at?: number | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Object representing the start and end dates for the current phase of the subscription schedule, if it is `active`.
   */
  current_phase?: subscription_schedule_current_phase | null;
  /**
   * ID of the customer who owns the subscription schedule.
   */
  customer: string | customer | deleted_customer;
  default_settings: subscription_schedules_resource_default_settings;
  /**
   * Behavior of the subscription schedule and underlying subscription when it ends. Possible values are `release` or `cancel` with the default being `release`. `release` will end the subscription schedule and keep the underlying subscription running. `cancel` will end the subscription schedule and cancel the underlying subscription.
   */
  end_behavior: 'cancel' | 'none' | 'release' | 'renew';
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'subscription_schedule';
  /**
   * Configuration for the subscription schedule's phases.
   */
  phases: Array<subscription_schedule_phase_configuration>;
  /**
   * Time at which the subscription schedule was released. Measured in seconds since the Unix epoch.
   */
  released_at?: number | null;
  /**
   * ID of the subscription once managed by the subscription schedule (if it is released).
   */
  released_subscription?: string | null;
  /**
   * The present status of the subscription schedule. Possible values are `not_started`, `active`, `completed`, `released`, and `canceled`. You can read more about the different states in our [behavior guide](https://stripe.com/docs/billing/subscriptions/subscription-schedules).
   */
  status: 'active' | 'canceled' | 'completed' | 'not_started' | 'released';
  /**
   * ID of the subscription managed by the subscription schedule.
   */
  subscription?: (string | subscription) | null;
  /**
   * ID of the test clock this subscription schedule belongs to.
   */
  test_clock?: (string | test_helpers_test_clock) | null;
};

/**
 * Behavior of the subscription schedule and underlying subscription when it ends. Possible values are `release` or `cancel` with the default being `release`. `release` will end the subscription schedule and keep the underlying subscription running. `cancel` will end the subscription schedule and cancel the underlying subscription.
 */
export type end_behavior = 'cancel' | 'none' | 'release' | 'renew';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object99 = 'subscription_schedule';

/**
 * The present status of the subscription schedule. Possible values are `not_started`, `active`, `completed`, `released`, and `canceled`. You can read more about the different states in our [behavior guide](https://stripe.com/docs/billing/subscriptions/subscription-schedules).
 */
export type status31 = 'active' | 'canceled' | 'completed' | 'not_started' | 'released';

/**
 * An Add Invoice Item describes the prices and quantities that will be added as pending invoice items when entering a phase.
 */
export type subscription_schedule_add_invoice_item = {
  /**
   * The stackable discounts that will be applied to the item.
   */
  discounts: Array<discounts_resource_stackable_discount>;
  /**
   * ID of the price used to generate the invoice item.
   */
  price: string | price | deleted_price;
  /**
   * The quantity of the invoice item.
   */
  quantity?: number | null;
  /**
   * The tax rates which apply to the item. When set, the `default_tax_rates` do not apply to this item.
   */
  tax_rates?: Array<tax_rate> | null;
};

/**
 * A phase item describes the price and quantity of a phase.
 */
export type subscription_schedule_configuration_item = {
  /**
   * Define thresholds at which an invoice will be sent, and the related subscription advanced to a new billing period
   */
  billing_thresholds?: subscription_item_billing_thresholds | null;
  /**
   * The discounts applied to the subscription item. Subscription item discounts are applied before subscription discounts. Use `expand[]=discounts` to expand each discount.
   */
  discounts: Array<discounts_resource_stackable_discount>;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an item. Metadata on this item will update the underlying subscription item's `metadata` when the phase is entered.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * ID of the price to which the customer should be subscribed.
   */
  price: string | price | deleted_price;
  /**
   * Quantity of the plan to which the customer should be subscribed.
   */
  quantity?: number;
  /**
   * The tax rates which apply to this `phase_item`. When set, the `default_tax_rates` on the phase do not apply to this `phase_item`.
   */
  tax_rates?: Array<tax_rate> | null;
};

export type subscription_schedule_current_phase = {
  /**
   * The end of this phase of the subscription schedule.
   */
  end_date: number;
  /**
   * The start of this phase of the subscription schedule.
   */
  start_date: number;
};

/**
 * A phase describes the plans, coupon, and trialing status of a subscription for a predefined time period.
 */
export type subscription_schedule_phase_configuration = {
  /**
   * A list of prices and quantities that will generate invoice items appended to the next invoice for this phase.
   */
  add_invoice_items: Array<subscription_schedule_add_invoice_item>;
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account during this phase of the schedule.
   */
  application_fee_percent?: number | null;
  automatic_tax?: schedules_phase_automatic_tax;
  /**
   * Possible values are `phase_start` or `automatic`. If `phase_start` then billing cycle anchor of the subscription is set to the start of the phase when entering the phase. If `automatic` then the billing cycle anchor is automatically modified as needed when entering the phase. For more information, see the billing cycle [documentation](https://stripe.com/docs/billing/subscriptions/billing-cycle).
   */
  billing_cycle_anchor?: ('automatic' | 'phase_start') | null;
  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period
   */
  billing_thresholds?: subscription_billing_thresholds | null;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay the underlying subscription at the end of each billing cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions and mark the subscription as `active`.
   */
  collection_method?: ('charge_automatically' | 'send_invoice') | null;
  /**
   * ID of the coupon to use during this phase of the subscription schedule.
   */
  coupon?: (string | coupon | deleted_coupon) | null;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * ID of the default payment method for the subscription schedule. It must belong to the customer associated with the subscription schedule. If not set, invoices will use the default payment method in the customer's invoice settings.
   */
  default_payment_method?: (string | payment_method) | null;
  /**
   * The default tax rates to apply to the subscription during this phase of the subscription schedule.
   */
  default_tax_rates?: Array<tax_rate> | null;
  /**
   * Subscription description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
   */
  description?: string | null;
  /**
   * The stackable discounts that will be applied to the subscription on this phase. Subscription item discounts are applied before subscription discounts.
   */
  discounts: Array<discounts_resource_stackable_discount>;
  /**
   * The end of this phase of the subscription schedule.
   */
  end_date: number;
  /**
   * The invoice settings applicable during this phase.
   */
  invoice_settings?: invoice_setting_subscription_schedule_phase_setting | null;
  /**
   * Subscription items to configure the subscription to during this phase of the subscription schedule.
   */
  items: Array<subscription_schedule_configuration_item>;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to a phase. Metadata on a schedule's phase will update the underlying subscription's `metadata` when the phase is entered. Updating the underlying subscription's `metadata` directly will not affect the current phase's `metadata`.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * The account (if any) the charge was made on behalf of for charges associated with the schedule's subscription. See the Connect documentation for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * If the subscription schedule will prorate when transitioning to this phase. Possible values are `create_prorations` and `none`.
   */
  proration_behavior: 'always_invoice' | 'create_prorations' | 'none';
  /**
   * The start of this phase of the subscription schedule.
   */
  start_date: number;
  /**
   * The account (if any) the associated subscription's payments will be attributed to for tax reporting, and where funds from each payment will be transferred to for each of the subscription's invoices.
   */
  transfer_data?: subscription_transfer_data | null;
  /**
   * When the trial ends within the phase.
   */
  trial_end?: number | null;
};

/**
 * Possible values are `phase_start` or `automatic`. If `phase_start` then billing cycle anchor of the subscription is set to the start of the phase when entering the phase. If `automatic` then the billing cycle anchor is automatically modified as needed when entering the phase. For more information, see the billing cycle [documentation](https://stripe.com/docs/billing/subscriptions/billing-cycle).
 */
export type billing_cycle_anchor = 'automatic' | 'phase_start';

export type subscription_schedules_resource_default_settings = {
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account during this phase of the schedule.
   */
  application_fee_percent?: number | null;
  automatic_tax?: subscription_schedules_resource_default_settings_automatic_tax;
  /**
   * Possible values are `phase_start` or `automatic`. If `phase_start` then billing cycle anchor of the subscription is set to the start of the phase when entering the phase. If `automatic` then the billing cycle anchor is automatically modified as needed when entering the phase. For more information, see the billing cycle [documentation](https://stripe.com/docs/billing/subscriptions/billing-cycle).
   */
  billing_cycle_anchor: 'automatic' | 'phase_start';
  /**
   * Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period
   */
  billing_thresholds?: subscription_billing_thresholds | null;
  /**
   * Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay the underlying subscription at the end of each billing cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions and mark the subscription as `active`.
   */
  collection_method?: ('charge_automatically' | 'send_invoice') | null;
  /**
   * ID of the default payment method for the subscription schedule. If not set, invoices will use the default payment method in the customer's invoice settings.
   */
  default_payment_method?: (string | payment_method) | null;
  /**
   * Subscription description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.
   */
  description?: string | null;
  invoice_settings: invoice_setting_subscription_schedule_setting;
  /**
   * The account (if any) the charge was made on behalf of for charges associated with the schedule's subscription. See the Connect documentation for details.
   */
  on_behalf_of?: (string | account) | null;
  /**
   * The account (if any) the associated subscription's payments will be attributed to for tax reporting, and where funds from each payment will be transferred to for each of the subscription's invoices.
   */
  transfer_data?: subscription_transfer_data | null;
};

export type subscription_schedules_resource_default_settings_automatic_tax = {
  /**
   * Whether Stripe automatically computes tax on invoices created during this phase.
   */
  enabled: boolean;
  /**
   * The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.
   */
  liability?: connect_account_reference | null;
};

export type subscription_transfer_data = {
  /**
   * A non-negative decimal between 0 and 100, with at most two decimal places. This represents the percentage of the subscription invoice total that will be transferred to the destination account. By default, the entire amount is transferred to the destination.
   */
  amount_percent?: number | null;
  /**
   * The account where funds from the payment will be transferred to upon payment success.
   */
  destination: string | account;
};

export type subscriptions_resource_billing_cycle_anchor_config = {
  /**
   * The day of the month of the billing_cycle_anchor.
   */
  day_of_month: number;
  /**
   * The hour of the day of the billing_cycle_anchor.
   */
  hour?: number | null;
  /**
   * The minute of the hour of the billing_cycle_anchor.
   */
  minute?: number | null;
  /**
   * The month to start full cycle billing periods.
   */
  month?: number | null;
  /**
   * The second of the minute of the billing_cycle_anchor.
   */
  second?: number | null;
};

/**
 * The Pause Collection settings determine how we will pause collection for this subscription and for how long the subscription
 * should be paused.
 */
export type subscriptions_resource_pause_collection = {
  /**
   * The payment collection behavior for this subscription while paused. One of `keep_as_draft`, `mark_uncollectible`, or `void`.
   */
  behavior: 'keep_as_draft' | 'mark_uncollectible' | 'void';
  /**
   * The time after which the subscription will resume collecting payments.
   */
  resumes_at?: number | null;
};

/**
 * The payment collection behavior for this subscription while paused. One of `keep_as_draft`, `mark_uncollectible`, or `void`.
 */
export type behavior = 'keep_as_draft' | 'mark_uncollectible' | 'void';

export type subscriptions_resource_payment_method_options = {
  /**
   * This sub-hash contains details about the Canadian pre-authorized debit payment method options to pass to invoices created by the subscription.
   */
  acss_debit?: invoice_payment_method_options_acss_debit | null;
  /**
   * This sub-hash contains details about the Bancontact payment method options to pass to invoices created by the subscription.
   */
  bancontact?: invoice_payment_method_options_bancontact | null;
  /**
   * This sub-hash contains details about the Card payment method options to pass to invoices created by the subscription.
   */
  card?: subscription_payment_method_options_card | null;
  /**
   * This sub-hash contains details about the Bank transfer payment method options to pass to invoices created by the subscription.
   */
  customer_balance?: invoice_payment_method_options_customer_balance | null;
  /**
   * This sub-hash contains details about the Konbini payment method options to pass to invoices created by the subscription.
   */
  konbini?: invoice_payment_method_options_konbini | null;
  /**
   * This sub-hash contains details about the SEPA Direct Debit payment method options to pass to invoices created by the subscription.
   */
  sepa_debit?: invoice_payment_method_options_sepa_debit | null;
  /**
   * This sub-hash contains details about the ACH direct debit payment method options to pass to invoices created by the subscription.
   */
  us_bank_account?: invoice_payment_method_options_us_bank_account | null;
};

export type subscriptions_resource_payment_settings = {
  /**
   * Payment-method-specific configuration to provide to invoices created by the subscription.
   */
  payment_method_options?: subscriptions_resource_payment_method_options | null;
  /**
   * The list of payment method types to provide to every invoice created by the subscription. If not set, Stripe attempts to automatically determine the types to use by looking at the invoice’s default payment method, the subscription’s default payment method, the customer’s default payment method, and your [invoice template settings](https://dashboard.stripe.com/settings/billing/invoice).
   */
  payment_method_types?: Array<
    | 'ach_credit_transfer'
    | 'ach_debit'
    | 'acss_debit'
    | 'amazon_pay'
    | 'au_becs_debit'
    | 'bacs_debit'
    | 'bancontact'
    | 'boleto'
    | 'card'
    | 'cashapp'
    | 'customer_balance'
    | 'eps'
    | 'fpx'
    | 'giropay'
    | 'grabpay'
    | 'ideal'
    | 'konbini'
    | 'link'
    | 'p24'
    | 'paynow'
    | 'paypal'
    | 'promptpay'
    | 'revolut_pay'
    | 'sepa_debit'
    | 'sofort'
    | 'swish'
    | 'us_bank_account'
    | 'wechat_pay'
  > | null;
  /**
   * Either `off`, or `on_subscription`. With `on_subscription` Stripe updates `subscription.default_payment_method` when a subscription payment succeeds.
   */
  save_default_payment_method?: ('off' | 'on_subscription') | null;
};

/**
 * Either `off`, or `on_subscription`. With `on_subscription` Stripe updates `subscription.default_payment_method` when a subscription payment succeeds.
 */
export type save_default_payment_method = 'off' | 'on_subscription';

/**
 * Pending Updates store the changes pending from a previous update that will be applied
 * to the Subscription upon successful payment.
 */
export type subscriptions_resource_pending_update = {
  /**
   * If the update is applied, determines the date of the first full invoice, and, for plans with `month` or `year` intervals, the day of the month for subsequent invoices. The timestamp is in UTC format.
   */
  billing_cycle_anchor?: number | null;
  /**
   * The point after which the changes reflected by this update will be discarded and no longer applied.
   */
  expires_at: number;
  /**
   * List of subscription items, each with an attached plan, that will be set if the update is applied.
   */
  subscription_items?: Array<subscription_item> | null;
  /**
   * Unix timestamp representing the end of the trial period the customer will get before being charged for the first time, if the update is applied.
   */
  trial_end?: number | null;
  /**
   * Indicates if a plan's `trial_period_days` should be applied to the subscription. Setting `trial_end` per subscription is preferred, and this defaults to `false`. Setting this flag to `true` together with `trial_end` is not allowed. See [Using trial periods on subscriptions](https://stripe.com/docs/billing/subscriptions/trials) to learn more.
   */
  trial_from_plan?: boolean | null;
};

export type subscriptions_resource_subscription_invoice_settings = {
  /**
   * The account tax IDs associated with the subscription. Will be set on invoices generated by the subscription.
   */
  account_tax_ids?: Array<string | tax_id | deleted_tax_id> | null;
  issuer: connect_account_reference;
};

/**
 * Defines how a subscription behaves when a free trial ends.
 */
export type subscriptions_trials_resource_end_behavior = {
  /**
   * Indicates how the subscription should change when the trial ends if the user did not provide a payment method.
   */
  missing_payment_method: 'cancel' | 'create_invoice' | 'pause';
};

/**
 * Indicates how the subscription should change when the trial ends if the user did not provide a payment method.
 */
export type missing_payment_method = 'cancel' | 'create_invoice' | 'pause';

/**
 * Configures how this subscription behaves during the trial period.
 */
export type subscriptions_trials_resource_trial_settings = {
  end_behavior: subscriptions_trials_resource_end_behavior;
};

/**
 * A Tax Calculation allows you to calculate the tax to collect from your customer.
 *
 * Related guide: [Calculate tax in your custom payment flow](https://stripe.com/docs/tax/custom)
 */
export type tax_calculation = {
  /**
   * Total after taxes.
   */
  amount_total: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The ID of an existing [Customer](https://stripe.com/docs/api/customers/object) used for the resource.
   */
  customer?: string | null;
  customer_details: tax_product_resource_customer_details;
  /**
   * Timestamp of date at which the tax calculation will expire.
   */
  expires_at?: number | null;
  /**
   * Unique identifier for the calculation.
   */
  id?: string | null;
  /**
   * The list of items the customer is purchasing.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<tax_calculation_line_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  } | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.calculation';
  /**
   * The details of the ship from location, such as the address.
   */
  ship_from_details?: tax_product_resource_ship_from_details | null;
  /**
   * The shipping cost details for the calculation.
   */
  shipping_cost?: tax_product_resource_tax_calculation_shipping_cost | null;
  /**
   * The amount of tax to be collected on top of the line item prices.
   */
  tax_amount_exclusive: number;
  /**
   * The amount of tax already included in the line item prices.
   */
  tax_amount_inclusive: number;
  /**
   * Breakdown of individual tax amounts that add up to the total.
   */
  tax_breakdown: Array<tax_product_resource_tax_breakdown>;
  /**
   * Timestamp of date at which the tax rules and rates in effect applies for the calculation.
   */
  tax_date: number;
};

export type tax_calculation_line_item = {
  /**
   * The line item amount in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). If `tax_behavior=inclusive`, then this amount includes taxes. Otherwise, taxes were calculated on top of this amount.
   */
  amount: number;
  /**
   * The amount of tax calculated for this line item, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_tax: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.calculation_line_item';
  /**
   * The ID of an existing [Product](https://stripe.com/docs/api/products/object).
   */
  product?: string | null;
  /**
   * The number of units of the item being purchased. For reversals, this is the quantity reversed.
   */
  quantity: number;
  /**
   * A custom identifier for this line item.
   */
  reference?: string | null;
  /**
   * Specifies whether the `amount` includes taxes. If `tax_behavior=inclusive`, then the amount includes taxes.
   */
  tax_behavior: 'exclusive' | 'inclusive';
  /**
   * Detailed account of taxes relevant to this line item.
   */
  tax_breakdown?: Array<tax_product_resource_line_item_tax_breakdown> | null;
  /**
   * The [tax code](https://stripe.com/docs/tax/tax-categories) ID used for this resource.
   */
  tax_code: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object100 = 'tax.calculation_line_item';

/**
 * Specifies whether the `amount` includes taxes. If `tax_behavior=inclusive`, then the amount includes taxes.
 */
export type tax_behavior2 = 'exclusive' | 'inclusive';

/**
 * [Tax codes](https://stripe.com/docs/tax/tax-categories) classify goods and services for tax purposes.
 */
export type tax_code = {
  /**
   * A detailed description of which types of products the tax code represents.
   */
  description: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * A short name for the tax code.
   */
  name: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax_code';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object101 = 'tax_code';

export type tax_deducted_at_source = {
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax_deducted_at_source';
  /**
   * The end of the invoicing period. This TDS applies to Stripe fees collected during this invoicing period.
   */
  period_end: number;
  /**
   * The start of the invoicing period. This TDS applies to Stripe fees collected during this invoicing period.
   */
  period_start: number;
  /**
   * The TAN that was supplied to Stripe when TDS was assessed
   */
  tax_deduction_account_number: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object102 = 'tax_deducted_at_source';

export type tax_i_ds_owner = {
  /**
   * The account being referenced when `type` is `account`.
   */
  account?: string | account;
  /**
   * The Connect Application being referenced when `type` is `application`.
   */
  application?: string | application;
  /**
   * The customer being referenced when `type` is `customer`.
   */
  customer?: string | customer;
  /**
   * Type of owner referenced.
   */
  type: 'account' | 'application' | 'customer' | 'self';
};

/**
 * Type of owner referenced.
 */
export type type54 = 'account' | 'application' | 'customer' | 'self';

/**
 * You can add one or multiple tax IDs to a [customer](https://stripe.com/docs/api/customers) or account.
 * Customer and account tax IDs get displayed on related invoices and credit notes.
 *
 * Related guides: [Customer tax identification numbers](https://stripe.com/docs/billing/taxes/tax-ids), [Account tax IDs](https://stripe.com/docs/invoicing/connect#account-tax-ids)
 */
export type tax_id = {
  /**
   * Two-letter ISO code representing the country of the tax ID.
   */
  country?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * ID of the customer.
   */
  customer?: (string | customer) | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax_id';
  /**
   * The account or customer the tax ID belongs to.
   */
  owner?: tax_i_ds_owner | null;
  /**
   * Type of the tax ID, one of `ad_nrt`, `ae_trn`, `ar_cuit`, `au_abn`, `au_arn`, `bg_uic`, `bh_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `ca_bn`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `ca_qst`, `ch_vat`, `cl_tin`, `cn_tin`, `co_nit`, `cr_tin`, `de_stn`, `do_rcn`, `ec_ruc`, `eg_tin`, `es_cif`, `eu_oss_vat`, `eu_vat`, `gb_vat`, `ge_vat`, `hk_br`, `hu_tin`, `id_npwp`, `il_vat`, `in_gst`, `is_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `ke_pin`, `kr_brn`, `kz_bin`, `li_uid`, `mx_rfc`, `my_frp`, `my_itn`, `my_sst`, `ng_tin`, `no_vat`, `no_voec`, `nz_gst`, `om_vat`, `pe_ruc`, `ph_tin`, `ro_tin`, `rs_pib`, `ru_inn`, `ru_kpp`, `sa_vat`, `sg_gst`, `sg_uen`, `si_tin`, `sv_nit`, `th_vat`, `tr_tin`, `tw_vat`, `ua_vat`, `us_ein`, `uy_ruc`, `ve_rif`, `vn_tin`, or `za_vat`. Note that some legacy tax IDs have type `unknown`
   */
  type:
    | 'ad_nrt'
    | 'ae_trn'
    | 'ar_cuit'
    | 'au_abn'
    | 'au_arn'
    | 'bg_uic'
    | 'bh_vat'
    | 'bo_tin'
    | 'br_cnpj'
    | 'br_cpf'
    | 'ca_bn'
    | 'ca_gst_hst'
    | 'ca_pst_bc'
    | 'ca_pst_mb'
    | 'ca_pst_sk'
    | 'ca_qst'
    | 'ch_vat'
    | 'cl_tin'
    | 'cn_tin'
    | 'co_nit'
    | 'cr_tin'
    | 'de_stn'
    | 'do_rcn'
    | 'ec_ruc'
    | 'eg_tin'
    | 'es_cif'
    | 'eu_oss_vat'
    | 'eu_vat'
    | 'gb_vat'
    | 'ge_vat'
    | 'hk_br'
    | 'hu_tin'
    | 'id_npwp'
    | 'il_vat'
    | 'in_gst'
    | 'is_vat'
    | 'jp_cn'
    | 'jp_rn'
    | 'jp_trn'
    | 'ke_pin'
    | 'kr_brn'
    | 'kz_bin'
    | 'li_uid'
    | 'mx_rfc'
    | 'my_frp'
    | 'my_itn'
    | 'my_sst'
    | 'ng_tin'
    | 'no_vat'
    | 'no_voec'
    | 'nz_gst'
    | 'om_vat'
    | 'pe_ruc'
    | 'ph_tin'
    | 'ro_tin'
    | 'rs_pib'
    | 'ru_inn'
    | 'ru_kpp'
    | 'sa_vat'
    | 'sg_gst'
    | 'sg_uen'
    | 'si_tin'
    | 'sv_nit'
    | 'th_vat'
    | 'tr_tin'
    | 'tw_vat'
    | 'ua_vat'
    | 'unknown'
    | 'us_ein'
    | 'uy_ruc'
    | 've_rif'
    | 'vn_tin'
    | 'za_vat';
  /**
   * Value of the tax ID.
   */
  value: string;
  /**
   * Tax ID verification information.
   */
  verification?: tax_id_verification | null;
};

export type tax_id_verification = {
  /**
   * Verification status, one of `pending`, `verified`, `unverified`, or `unavailable`.
   */
  status: 'pending' | 'unavailable' | 'unverified' | 'verified';
  /**
   * Verified address.
   */
  verified_address?: string | null;
  /**
   * Verified name.
   */
  verified_name?: string | null;
};

/**
 * Verification status, one of `pending`, `verified`, `unverified`, or `unavailable`.
 */
export type status32 = 'pending' | 'unavailable' | 'unverified' | 'verified';

export type tax_product_registrations_resource_country_options = {
  ae?: tax_product_registrations_resource_country_options_default;
  at?: tax_product_registrations_resource_country_options_europe;
  au?: tax_product_registrations_resource_country_options_default;
  be?: tax_product_registrations_resource_country_options_europe;
  bg?: tax_product_registrations_resource_country_options_europe;
  bh?: tax_product_registrations_resource_country_options_default;
  ca?: tax_product_registrations_resource_country_options_canada;
  ch?: tax_product_registrations_resource_country_options_default;
  cl?: tax_product_registrations_resource_country_options_simplified;
  co?: tax_product_registrations_resource_country_options_simplified;
  cy?: tax_product_registrations_resource_country_options_europe;
  cz?: tax_product_registrations_resource_country_options_europe;
  de?: tax_product_registrations_resource_country_options_europe;
  dk?: tax_product_registrations_resource_country_options_europe;
  ee?: tax_product_registrations_resource_country_options_europe;
  eg?: tax_product_registrations_resource_country_options_simplified;
  es?: tax_product_registrations_resource_country_options_europe;
  fi?: tax_product_registrations_resource_country_options_europe;
  fr?: tax_product_registrations_resource_country_options_europe;
  gb?: tax_product_registrations_resource_country_options_default;
  ge?: tax_product_registrations_resource_country_options_simplified;
  gr?: tax_product_registrations_resource_country_options_europe;
  hr?: tax_product_registrations_resource_country_options_europe;
  hu?: tax_product_registrations_resource_country_options_europe;
  id?: tax_product_registrations_resource_country_options_simplified;
  ie?: tax_product_registrations_resource_country_options_europe;
  is?: tax_product_registrations_resource_country_options_default;
  it?: tax_product_registrations_resource_country_options_europe;
  jp?: tax_product_registrations_resource_country_options_default;
  ke?: tax_product_registrations_resource_country_options_simplified;
  kr?: tax_product_registrations_resource_country_options_simplified;
  kz?: tax_product_registrations_resource_country_options_simplified;
  lt?: tax_product_registrations_resource_country_options_europe;
  lu?: tax_product_registrations_resource_country_options_europe;
  lv?: tax_product_registrations_resource_country_options_europe;
  mt?: tax_product_registrations_resource_country_options_europe;
  mx?: tax_product_registrations_resource_country_options_simplified;
  my?: tax_product_registrations_resource_country_options_simplified;
  ng?: tax_product_registrations_resource_country_options_simplified;
  nl?: tax_product_registrations_resource_country_options_europe;
  no?: tax_product_registrations_resource_country_options_default;
  nz?: tax_product_registrations_resource_country_options_default;
  om?: tax_product_registrations_resource_country_options_default;
  pl?: tax_product_registrations_resource_country_options_europe;
  pt?: tax_product_registrations_resource_country_options_europe;
  ro?: tax_product_registrations_resource_country_options_europe;
  sa?: tax_product_registrations_resource_country_options_simplified;
  se?: tax_product_registrations_resource_country_options_europe;
  sg?: tax_product_registrations_resource_country_options_default;
  si?: tax_product_registrations_resource_country_options_europe;
  sk?: tax_product_registrations_resource_country_options_europe;
  th?: tax_product_registrations_resource_country_options_simplified;
  tr?: tax_product_registrations_resource_country_options_simplified;
  us?: tax_product_registrations_resource_country_options_united_states;
  vn?: tax_product_registrations_resource_country_options_simplified;
  za?: tax_product_registrations_resource_country_options_default;
};

export type tax_product_registrations_resource_country_options_ca_province_standard = {
  /**
   * Two-letter CA province code ([ISO 3166-2](https://en.wikipedia.org/wiki/ISO_3166-2)).
   */
  province: string;
};

export type tax_product_registrations_resource_country_options_canada = {
  province_standard?: tax_product_registrations_resource_country_options_ca_province_standard;
  /**
   * Type of registration in Canada.
   */
  type: 'province_standard' | 'simplified' | 'standard';
};

/**
 * Type of registration in Canada.
 */
export type type55 = 'province_standard' | 'simplified' | 'standard';

export type tax_product_registrations_resource_country_options_default = {
  /**
   * Type of registration in `country`.
   */
  type: 'standard';
};

/**
 * Type of registration in `country`.
 */
export type type56 = 'standard';

export type tax_product_registrations_resource_country_options_eu_standard = {
  /**
   * Place of supply scheme used in an EU standard registration.
   */
  place_of_supply_scheme: 'small_seller' | 'standard';
};

/**
 * Place of supply scheme used in an EU standard registration.
 */
export type place_of_supply_scheme = 'small_seller' | 'standard';

export type tax_product_registrations_resource_country_options_europe = {
  standard?: tax_product_registrations_resource_country_options_eu_standard;
  /**
   * Type of registration in an EU country.
   */
  type: 'ioss' | 'oss_non_union' | 'oss_union' | 'standard';
};

/**
 * Type of registration in an EU country.
 */
export type type57 = 'ioss' | 'oss_non_union' | 'oss_union' | 'standard';

export type tax_product_registrations_resource_country_options_simplified = {
  /**
   * Type of registration in `country`.
   */
  type: 'simplified';
};

/**
 * Type of registration in `country`.
 */
export type type58 = 'simplified';

export type tax_product_registrations_resource_country_options_united_states = {
  local_amusement_tax?: tax_product_registrations_resource_country_options_us_local_amusement_tax;
  local_lease_tax?: tax_product_registrations_resource_country_options_us_local_lease_tax;
  /**
   * Two-letter US state code ([ISO 3166-2](https://en.wikipedia.org/wiki/ISO_3166-2)).
   */
  state: string;
  /**
   * Type of registration in the US.
   */
  type: 'local_amusement_tax' | 'local_lease_tax' | 'state_communications_tax' | 'state_sales_tax';
};

/**
 * Type of registration in the US.
 */
export type type59 = 'local_amusement_tax' | 'local_lease_tax' | 'state_communications_tax' | 'state_sales_tax';

export type tax_product_registrations_resource_country_options_us_local_amusement_tax = {
  /**
   * A [FIPS code](https://www.census.gov/library/reference/code-lists/ansi.html) representing the local jurisdiction.
   */
  jurisdiction: string;
};

export type tax_product_registrations_resource_country_options_us_local_lease_tax = {
  /**
   * A [FIPS code](https://www.census.gov/library/reference/code-lists/ansi.html) representing the local jurisdiction.
   */
  jurisdiction: string;
};

export type tax_product_resource_customer_details = {
  /**
   * The customer's postal address (for example, home or business location).
   */
  address?: tax_product_resource_postal_address | null;
  /**
   * The type of customer address provided.
   */
  address_source?: ('billing' | 'shipping') | null;
  /**
   * The customer's IP address (IPv4 or IPv6).
   */
  ip_address?: string | null;
  /**
   * The customer's tax IDs (for example, EU VAT numbers).
   */
  tax_ids: Array<tax_product_resource_customer_details_resource_tax_id>;
  /**
   * The taxability override used for taxation.
   */
  taxability_override: 'customer_exempt' | 'none' | 'reverse_charge';
};

/**
 * The type of customer address provided.
 */
export type address_source = 'billing' | 'shipping';

/**
 * The taxability override used for taxation.
 */
export type taxability_override = 'customer_exempt' | 'none' | 'reverse_charge';

export type tax_product_resource_customer_details_resource_tax_id = {
  /**
   * The type of the tax ID, one of `ad_nrt`, `ar_cuit`, `eu_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `cn_tin`, `co_nit`, `cr_tin`, `do_rcn`, `ec_ruc`, `eu_oss_vat`, `pe_ruc`, `ro_tin`, `rs_pib`, `sv_nit`, `uy_ruc`, `ve_rif`, `vn_tin`, `gb_vat`, `nz_gst`, `au_abn`, `au_arn`, `in_gst`, `no_vat`, `no_voec`, `za_vat`, `ch_vat`, `mx_rfc`, `sg_uen`, `ru_inn`, `ru_kpp`, `ca_bn`, `hk_br`, `es_cif`, `tw_vat`, `th_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `li_uid`, `my_itn`, `us_ein`, `kr_brn`, `ca_qst`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `my_sst`, `sg_gst`, `ae_trn`, `cl_tin`, `sa_vat`, `id_npwp`, `my_frp`, `il_vat`, `ge_vat`, `ua_vat`, `is_vat`, `bg_uic`, `hu_tin`, `si_tin`, `ke_pin`, `tr_tin`, `eg_tin`, `ph_tin`, `bh_vat`, `kz_bin`, `ng_tin`, `om_vat`, `de_stn`, or `unknown`
   */
  type:
    | 'ad_nrt'
    | 'ae_trn'
    | 'ar_cuit'
    | 'au_abn'
    | 'au_arn'
    | 'bg_uic'
    | 'bh_vat'
    | 'bo_tin'
    | 'br_cnpj'
    | 'br_cpf'
    | 'ca_bn'
    | 'ca_gst_hst'
    | 'ca_pst_bc'
    | 'ca_pst_mb'
    | 'ca_pst_sk'
    | 'ca_qst'
    | 'ch_vat'
    | 'cl_tin'
    | 'cn_tin'
    | 'co_nit'
    | 'cr_tin'
    | 'de_stn'
    | 'do_rcn'
    | 'ec_ruc'
    | 'eg_tin'
    | 'es_cif'
    | 'eu_oss_vat'
    | 'eu_vat'
    | 'gb_vat'
    | 'ge_vat'
    | 'hk_br'
    | 'hu_tin'
    | 'id_npwp'
    | 'il_vat'
    | 'in_gst'
    | 'is_vat'
    | 'jp_cn'
    | 'jp_rn'
    | 'jp_trn'
    | 'ke_pin'
    | 'kr_brn'
    | 'kz_bin'
    | 'li_uid'
    | 'mx_rfc'
    | 'my_frp'
    | 'my_itn'
    | 'my_sst'
    | 'ng_tin'
    | 'no_vat'
    | 'no_voec'
    | 'nz_gst'
    | 'om_vat'
    | 'pe_ruc'
    | 'ph_tin'
    | 'ro_tin'
    | 'rs_pib'
    | 'ru_inn'
    | 'ru_kpp'
    | 'sa_vat'
    | 'sg_gst'
    | 'sg_uen'
    | 'si_tin'
    | 'sv_nit'
    | 'th_vat'
    | 'tr_tin'
    | 'tw_vat'
    | 'ua_vat'
    | 'unknown'
    | 'us_ein'
    | 'uy_ruc'
    | 've_rif'
    | 'vn_tin'
    | 'za_vat';
  /**
   * The value of the tax ID.
   */
  value: string;
};

export type tax_product_resource_jurisdiction = {
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country: string;
  /**
   * A human-readable name for the jurisdiction imposing the tax.
   */
  display_name: string;
  /**
   * Indicates the level of the jurisdiction imposing the tax.
   */
  level: 'city' | 'country' | 'county' | 'district' | 'state';
  /**
   * [ISO 3166-2 subdivision code](https://en.wikipedia.org/wiki/ISO_3166-2:US), without country prefix. For example, "NY" for New York, United States.
   */
  state?: string | null;
};

/**
 * Indicates the level of the jurisdiction imposing the tax.
 */
export type level = 'city' | 'country' | 'county' | 'district' | 'state';

export type tax_product_resource_line_item_tax_breakdown = {
  /**
   * The amount of tax, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  jurisdiction: tax_product_resource_jurisdiction;
  /**
   * Indicates whether the jurisdiction was determined by the origin (merchant's address) or destination (customer's address).
   */
  sourcing: 'destination' | 'origin';
  /**
   * Details regarding the rate for this tax. This field will be `null` when the tax is not imposed, for example if the product is exempt from tax.
   */
  tax_rate_details?: tax_product_resource_line_item_tax_rate_details | null;
  /**
   * The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.
   */
  taxability_reason:
    | 'customer_exempt'
    | 'not_collecting'
    | 'not_subject_to_tax'
    | 'not_supported'
    | 'portion_product_exempt'
    | 'portion_reduced_rated'
    | 'portion_standard_rated'
    | 'product_exempt'
    | 'product_exempt_holiday'
    | 'proportionally_rated'
    | 'reduced_rated'
    | 'reverse_charge'
    | 'standard_rated'
    | 'taxable_basis_reduced'
    | 'zero_rated';
  /**
   * The amount on which tax is calculated, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  taxable_amount: number;
};

/**
 * Indicates whether the jurisdiction was determined by the origin (merchant's address) or destination (customer's address).
 */
export type sourcing = 'destination' | 'origin';

export type tax_product_resource_line_item_tax_rate_details = {
  /**
   * A localized display name for tax type, intended to be human-readable. For example, "Local Sales and Use Tax", "Value-added tax (VAT)", or "Umsatzsteuer (USt.)".
   */
  display_name: string;
  /**
   * The tax rate percentage as a string. For example, 8.5% is represented as "8.5".
   */
  percentage_decimal: string;
  /**
   * The tax type, such as `vat` or `sales_tax`.
   */
  tax_type:
    | 'amusement_tax'
    | 'communications_tax'
    | 'gst'
    | 'hst'
    | 'igst'
    | 'jct'
    | 'lease_tax'
    | 'pst'
    | 'qst'
    | 'rst'
    | 'sales_tax'
    | 'vat';
};

/**
 * The tax type, such as `vat` or `sales_tax`.
 */
export type tax_type =
  | 'amusement_tax'
  | 'communications_tax'
  | 'gst'
  | 'hst'
  | 'igst'
  | 'jct'
  | 'lease_tax'
  | 'pst'
  | 'qst'
  | 'rst'
  | 'sales_tax'
  | 'vat';

export type tax_product_resource_postal_address = {
  /**
   * City, district, suburb, town, or village.
   */
  city?: string | null;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country: string;
  /**
   * Address line 1 (e.g., street, PO Box, or company name).
   */
  line1?: string | null;
  /**
   * Address line 2 (e.g., apartment, suite, unit, or building).
   */
  line2?: string | null;
  /**
   * ZIP or postal code.
   */
  postal_code?: string | null;
  /**
   * State/province as an [ISO 3166-2](https://en.wikipedia.org/wiki/ISO_3166-2) subdivision code, without country prefix. Example: "NY" or "TX".
   */
  state?: string | null;
};

export type tax_product_resource_ship_from_details = {
  address: tax_product_resource_postal_address;
};

export type tax_product_resource_tax_breakdown = {
  /**
   * The amount of tax, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Specifies whether the tax amount is included in the line item amount.
   */
  inclusive: boolean;
  tax_rate_details: tax_product_resource_tax_rate_details;
  /**
   * The reasoning behind this tax, for example, if the product is tax exempt. We might extend the possible values for this field to support new tax rules.
   */
  taxability_reason:
    | 'customer_exempt'
    | 'not_collecting'
    | 'not_subject_to_tax'
    | 'not_supported'
    | 'portion_product_exempt'
    | 'portion_reduced_rated'
    | 'portion_standard_rated'
    | 'product_exempt'
    | 'product_exempt_holiday'
    | 'proportionally_rated'
    | 'reduced_rated'
    | 'reverse_charge'
    | 'standard_rated'
    | 'taxable_basis_reduced'
    | 'zero_rated';
  /**
   * The amount on which tax is calculated, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  taxable_amount: number;
};

export type tax_product_resource_tax_calculation_shipping_cost = {
  /**
   * The shipping amount in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). If `tax_behavior=inclusive`, then this amount includes taxes. Otherwise, taxes were calculated on top of this amount.
   */
  amount: number;
  /**
   * The amount of tax calculated for shipping, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_tax: number;
  /**
   * The ID of an existing [ShippingRate](https://stripe.com/docs/api/shipping_rates/object).
   */
  shipping_rate?: string;
  /**
   * Specifies whether the `amount` includes taxes. If `tax_behavior=inclusive`, then the amount includes taxes.
   */
  tax_behavior: 'exclusive' | 'inclusive';
  /**
   * Detailed account of taxes relevant to shipping cost.
   */
  tax_breakdown?: Array<tax_product_resource_line_item_tax_breakdown>;
  /**
   * The [tax code](https://stripe.com/docs/tax/tax-categories) ID used for shipping.
   */
  tax_code: string;
};

export type tax_product_resource_tax_rate_details = {
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country?: string | null;
  /**
   * The tax rate percentage as a string. For example, 8.5% is represented as `"8.5"`.
   */
  percentage_decimal: string;
  /**
   * State, county, province, or region.
   */
  state?: string | null;
  /**
   * The tax type, such as `vat` or `sales_tax`.
   */
  tax_type?:
    | (
        | 'amusement_tax'
        | 'communications_tax'
        | 'gst'
        | 'hst'
        | 'igst'
        | 'jct'
        | 'lease_tax'
        | 'pst'
        | 'qst'
        | 'rst'
        | 'sales_tax'
        | 'vat'
      )
    | null;
};

export type tax_product_resource_tax_settings_defaults = {
  /**
   * Default [tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#tax-behavior) used to specify whether the price is considered inclusive of taxes or exclusive of taxes. If the item's price has a tax behavior set, it will take precedence over the default tax behavior.
   */
  tax_behavior?: ('exclusive' | 'inclusive' | 'inferred_by_currency') | null;
  /**
   * Default [tax code](https://stripe.com/docs/tax/tax-categories) used to classify your products and prices.
   */
  tax_code?: string | null;
};

/**
 * Default [tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#tax-behavior) used to specify whether the price is considered inclusive of taxes or exclusive of taxes. If the item's price has a tax behavior set, it will take precedence over the default tax behavior.
 */
export type tax_behavior3 = 'exclusive' | 'inclusive' | 'inferred_by_currency';

export type tax_product_resource_tax_settings_head_office = {
  address: address;
};

export type tax_product_resource_tax_settings_status_details = {
  active?: tax_product_resource_tax_settings_status_details_resource_active;
  pending?: tax_product_resource_tax_settings_status_details_resource_pending;
};

export type tax_product_resource_tax_settings_status_details_resource_active = {
  [key: string]: unknown;
};

export type tax_product_resource_tax_settings_status_details_resource_pending = {
  /**
   * The list of missing fields that are required to perform calculations. It includes the entry `head_office` when the status is `pending`. It is recommended to set the optional values even if they aren't listed as required for calculating taxes. Calculations can fail if missing fields aren't explicitly provided on every call.
   */
  missing_fields?: Array<string> | null;
};

export type tax_product_resource_tax_transaction_line_item_resource_reversal = {
  /**
   * The `id` of the line item to reverse in the original transaction.
   */
  original_line_item: string;
};

export type tax_product_resource_tax_transaction_resource_reversal = {
  /**
   * The `id` of the reversed `Transaction` object.
   */
  original_transaction?: string | null;
};

export type tax_product_resource_tax_transaction_shipping_cost = {
  /**
   * The shipping amount in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). If `tax_behavior=inclusive`, then this amount includes taxes. Otherwise, taxes were calculated on top of this amount.
   */
  amount: number;
  /**
   * The amount of tax calculated for shipping, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_tax: number;
  /**
   * The ID of an existing [ShippingRate](https://stripe.com/docs/api/shipping_rates/object).
   */
  shipping_rate?: string;
  /**
   * Specifies whether the `amount` includes taxes. If `tax_behavior=inclusive`, then the amount includes taxes.
   */
  tax_behavior: 'exclusive' | 'inclusive';
  /**
   * The [tax code](https://stripe.com/docs/tax/tax-categories) ID used for shipping.
   */
  tax_code: string;
};

/**
 * Tax rates can be applied to [invoices](https://stripe.com/docs/billing/invoices/tax-rates), [subscriptions](https://stripe.com/docs/billing/subscriptions/taxes) and [Checkout Sessions](https://stripe.com/docs/payments/checkout/set-up-a-subscription#tax-rates) to collect tax.
 *
 * Related guide: [Tax rates](https://stripe.com/docs/billing/taxes/tax-rates)
 */
export type tax_rate = {
  /**
   * Defaults to `true`. When set to `false`, this tax rate cannot be used with new applications or Checkout Sessions, but will still work for subscriptions and invoices that already have it set.
   */
  active: boolean;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * An arbitrary string attached to the tax rate for your internal use only. It will not be visible to your customers.
   */
  description?: string | null;
  /**
   * The display name of the tax rates as it will appear to your customer on their receipt email, PDF, and the hosted invoice page.
   */
  display_name: string;
  /**
   * Actual/effective tax rate percentage out of 100. For tax calculations with automatic_tax[enabled]=true,
   * this percentage reflects the rate actually used to calculate tax based on the product's taxability
   * and whether the user is registered to collect taxes in the corresponding jurisdiction.
   */
  effective_percentage?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * This specifies if the tax rate is inclusive or exclusive.
   */
  inclusive: boolean;
  /**
   * The jurisdiction for the tax rate. You can use this label field for tax reporting purposes. It also appears on your customer’s invoice.
   */
  jurisdiction?: string | null;
  /**
   * The level of the jurisdiction that imposes this tax rate. Will be `null` for manually defined tax rates.
   */
  jurisdiction_level?: ('city' | 'country' | 'county' | 'district' | 'multiple' | 'state') | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax_rate';
  /**
   * Tax rate percentage out of 100. For tax calculations with automatic_tax[enabled]=true, this percentage includes the statutory tax rate of non-taxable jurisdictions.
   */
  percentage: number;
  /**
   * [ISO 3166-2 subdivision code](https://en.wikipedia.org/wiki/ISO_3166-2:US), without country prefix. For example, "NY" for New York, United States.
   */
  state?: string | null;
  /**
   * The high-level tax type, such as `vat` or `sales_tax`.
   */
  tax_type?:
    | (
        | 'amusement_tax'
        | 'communications_tax'
        | 'gst'
        | 'hst'
        | 'igst'
        | 'jct'
        | 'lease_tax'
        | 'pst'
        | 'qst'
        | 'rst'
        | 'sales_tax'
        | 'vat'
      )
    | null;
};

/**
 * The level of the jurisdiction that imposes this tax rate. Will be `null` for manually defined tax rates.
 */
export type jurisdiction_level = 'city' | 'country' | 'county' | 'district' | 'multiple' | 'state';

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object103 = 'tax_rate';

/**
 * A Tax `Registration` lets us know that your business is registered to collect tax on payments within a region, enabling you to [automatically collect tax](https://stripe.com/docs/tax).
 *
 * Stripe doesn't register on your behalf with the relevant authorities when you create a Tax `Registration` object. For more information on how to register to collect tax, see [our guide](https://stripe.com/docs/tax/registering).
 *
 * Related guide: [Using the Registrations API](https://stripe.com/docs/tax/registrations-api)
 */
export type tax_registration = {
  /**
   * Time at which the registration becomes active. Measured in seconds since the Unix epoch.
   */
  active_from: number;
  /**
   * Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
   */
  country: string;
  country_options: tax_product_registrations_resource_country_options;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * If set, the registration stops being active at this time. If not set, the registration will be active indefinitely. Measured in seconds since the Unix epoch.
   */
  expires_at?: number | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.registration';
  /**
   * The status of the registration. This field is present for convenience and can be deduced from `active_from` and `expires_at`.
   */
  status: 'active' | 'expired' | 'scheduled';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object104 = 'tax.registration';

/**
 * The status of the registration. This field is present for convenience and can be deduced from `active_from` and `expires_at`.
 */
export type status33 = 'active' | 'expired' | 'scheduled';

/**
 * You can use Tax `Settings` to manage configurations used by Stripe Tax calculations.
 *
 * Related guide: [Using the Settings API](https://stripe.com/docs/tax/settings-api)
 */
export type tax_settings = {
  defaults: tax_product_resource_tax_settings_defaults;
  /**
   * The place where your business is located.
   */
  head_office?: tax_product_resource_tax_settings_head_office | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.settings';
  /**
   * The `active` status indicates you have all required settings to calculate tax. A status can transition out of `active` when new required settings are introduced.
   */
  status: 'active' | 'pending';
  status_details: tax_product_resource_tax_settings_status_details;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object105 = 'tax.settings';

/**
 * The `active` status indicates you have all required settings to calculate tax. A status can transition out of `active` when new required settings are introduced.
 */
export type status34 = 'active' | 'pending';

/**
 * A Tax Transaction records the tax collected from or refunded to your customer.
 *
 * Related guide: [Calculate tax in your custom payment flow](https://stripe.com/docs/tax/custom#tax-transaction)
 */
export type tax_transaction = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * The ID of an existing [Customer](https://stripe.com/docs/api/customers/object) used for the resource.
   */
  customer?: string | null;
  customer_details: tax_product_resource_customer_details;
  /**
   * Unique identifier for the transaction.
   */
  id: string;
  /**
   * The tax collected or refunded, by line item.
   */
  line_items?: {
    /**
     * Details about each object.
     */
    data: Array<tax_transaction_line_item>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  } | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.transaction';
  /**
   * A custom unique identifier, such as 'myOrder_123'.
   */
  reference: string;
  /**
   * If `type=reversal`, contains information about what was reversed.
   */
  reversal?: tax_product_resource_tax_transaction_resource_reversal | null;
  /**
   * The details of the ship from location, such as the address.
   */
  ship_from_details?: tax_product_resource_ship_from_details | null;
  /**
   * The shipping cost details for the transaction.
   */
  shipping_cost?: tax_product_resource_tax_transaction_shipping_cost | null;
  /**
   * Timestamp of date at which the tax rules and rates in effect applies for the calculation.
   */
  tax_date: number;
  /**
   * If `reversal`, this transaction reverses an earlier transaction.
   */
  type: 'reversal' | 'transaction';
};

/**
 * If `reversal`, this transaction reverses an earlier transaction.
 */
export type type60 = 'reversal' | 'transaction';

export type tax_transaction_line_item = {
  /**
   * The line item amount in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). If `tax_behavior=inclusive`, then this amount includes taxes. Otherwise, taxes were calculated on top of this amount.
   */
  amount: number;
  /**
   * The amount of tax calculated for this line item, in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount_tax: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'tax.transaction_line_item';
  /**
   * The ID of an existing [Product](https://stripe.com/docs/api/products/object).
   */
  product?: string | null;
  /**
   * The number of units of the item being purchased. For reversals, this is the quantity reversed.
   */
  quantity: number;
  /**
   * A custom identifier for this line item in the transaction.
   */
  reference: string;
  /**
   * If `type=reversal`, contains information about what was reversed.
   */
  reversal?: tax_product_resource_tax_transaction_line_item_resource_reversal | null;
  /**
   * Specifies whether the `amount` includes taxes. If `tax_behavior=inclusive`, then the amount includes taxes.
   */
  tax_behavior: 'exclusive' | 'inclusive';
  /**
   * The [tax code](https://stripe.com/docs/tax/tax-categories) ID used for this resource.
   */
  tax_code: string;
  /**
   * If `reversal`, this line item reverses an earlier transaction.
   */
  type: 'reversal' | 'transaction';
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object106 = 'tax.transaction_line_item';

/**
 * A Configurations object represents how features should be configured for terminal readers.
 */
export type terminal_configuration = {
  bbpos_wisepos_e?: terminal_configuration_configuration_resource_device_type_specific_config;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Whether this Configuration is the default for your account
   */
  is_account_default?: boolean | null;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String indicating the name of the Configuration object, set by the user
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.configuration';
  offline?: terminal_configuration_configuration_resource_offline_config;
  stripe_s700?: terminal_configuration_configuration_resource_device_type_specific_config;
  tipping?: terminal_configuration_configuration_resource_tipping;
  verifone_p400?: terminal_configuration_configuration_resource_device_type_specific_config;
};

export type terminal_configuration_configuration_resource_currency_specific_config = {
  /**
   * Fixed amounts displayed when collecting a tip
   */
  fixed_amounts?: Array<number> | null;
  /**
   * Percentages displayed when collecting a tip
   */
  percentages?: Array<number> | null;
  /**
   * Below this amount, fixed amounts will be displayed; above it, percentages will be displayed
   */
  smart_tip_threshold?: number;
};

export type terminal_configuration_configuration_resource_device_type_specific_config = {
  /**
   * A File ID representing an image you would like displayed on the reader.
   */
  splashscreen?: string | file;
};

export type terminal_configuration_configuration_resource_offline_config = {
  /**
   * Determines whether to allow transactions to be collected while reader is offline. Defaults to false.
   */
  enabled?: boolean | null;
};

export type terminal_configuration_configuration_resource_tipping = {
  aud?: terminal_configuration_configuration_resource_currency_specific_config;
  cad?: terminal_configuration_configuration_resource_currency_specific_config;
  chf?: terminal_configuration_configuration_resource_currency_specific_config;
  czk?: terminal_configuration_configuration_resource_currency_specific_config;
  dkk?: terminal_configuration_configuration_resource_currency_specific_config;
  eur?: terminal_configuration_configuration_resource_currency_specific_config;
  gbp?: terminal_configuration_configuration_resource_currency_specific_config;
  hkd?: terminal_configuration_configuration_resource_currency_specific_config;
  myr?: terminal_configuration_configuration_resource_currency_specific_config;
  nok?: terminal_configuration_configuration_resource_currency_specific_config;
  nzd?: terminal_configuration_configuration_resource_currency_specific_config;
  sek?: terminal_configuration_configuration_resource_currency_specific_config;
  sgd?: terminal_configuration_configuration_resource_currency_specific_config;
  usd?: terminal_configuration_configuration_resource_currency_specific_config;
};

/**
 * A Connection Token is used by the Stripe Terminal SDK to connect to a reader.
 *
 * Related guide: [Fleet management](https://stripe.com/docs/terminal/fleet/locations)
 */
export type terminal_connection_token = {
  /**
   * The id of the location that this connection token is scoped to. Note that location scoping only applies to internet-connected readers. For more details, see [the docs on scoping connection tokens](https://docs.stripe.com/terminal/fleet/locations-and-zones?dashboard-or-api=api#connection-tokens).
   */
  location?: string;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.connection_token';
  /**
   * Your application should pass this token to the Stripe Terminal SDK.
   */
  secret: string;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object107 = 'terminal.connection_token';

/**
 * A Location represents a grouping of readers.
 *
 * Related guide: [Fleet management](https://stripe.com/docs/terminal/fleet/locations)
 */
export type terminal_location = {
  address: address;
  /**
   * The ID of a configuration that will be used to customize all readers in this location.
   */
  configuration_overrides?: string;
  /**
   * The display name of the location.
   */
  display_name: string;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.location';
};

/**
 * A Reader represents a physical device for accepting payment details.
 *
 * Related guide: [Connecting to a reader](https://stripe.com/docs/terminal/payments/connect-reader)
 */
export type terminal_reader = {
  /**
   * The most recent action performed by the reader.
   */
  action?: terminal_reader_reader_resource_reader_action | null;
  /**
   * The current software version of the reader.
   */
  device_sw_version?: string | null;
  /**
   * Type of reader, one of `bbpos_wisepad3`, `stripe_m2`, `bbpos_chipper2x`, `bbpos_wisepos_e`, `verifone_P400`, `simulated_wisepos_e`, or `mobile_phone_reader`.
   */
  device_type:
    | 'bbpos_chipper2x'
    | 'bbpos_wisepad3'
    | 'bbpos_wisepos_e'
    | 'mobile_phone_reader'
    | 'simulated_wisepos_e'
    | 'stripe_m2'
    | 'verifone_P400';
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * The local IP address of the reader.
   */
  ip_address?: string | null;
  /**
   * Custom label given to the reader for easier identification.
   */
  label: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The location identifier of the reader.
   */
  location?: (string | terminal_location) | null;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'terminal.reader';
  /**
   * Serial number of the reader.
   */
  serial_number: string;
  /**
   * The networking status of the reader.
   */
  status?: ('offline' | 'online') | null;
};

/**
 * Type of reader, one of `bbpos_wisepad3`, `stripe_m2`, `bbpos_chipper2x`, `bbpos_wisepos_e`, `verifone_P400`, `simulated_wisepos_e`, or `mobile_phone_reader`.
 */
export type device_type =
  | 'bbpos_chipper2x'
  | 'bbpos_wisepad3'
  | 'bbpos_wisepos_e'
  | 'mobile_phone_reader'
  | 'simulated_wisepos_e'
  | 'stripe_m2'
  | 'verifone_P400';

/**
 * The networking status of the reader.
 */
export type status35 = 'offline' | 'online';

/**
 * Represents a cart to be displayed on the reader
 */
export type terminal_reader_reader_resource_cart = {
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * List of line items in the cart.
   */
  line_items: Array<terminal_reader_reader_resource_line_item>;
  /**
   * Tax amount for the entire cart. A positive integer in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  tax?: number | null;
  /**
   * Total amount for the entire cart, including tax. A positive integer in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  total: number;
};

/**
 * Represents a line item to be displayed on the reader
 */
export type terminal_reader_reader_resource_line_item = {
  /**
   * The amount of the line item. A positive integer in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
   */
  amount: number;
  /**
   * Description of the line item.
   */
  description: string;
  /**
   * The quantity of the line item.
   */
  quantity: number;
};

/**
 * Represents a per-transaction override of a reader configuration
 */
export type terminal_reader_reader_resource_process_config = {
  /**
   * Enable customer initiated cancellation when processing this payment.
   */
  enable_customer_cancellation?: boolean;
  /**
   * Override showing a tipping selection screen on this transaction.
   */
  skip_tipping?: boolean;
  tipping?: terminal_reader_reader_resource_tipping_config;
};

/**
 * Represents a reader action to process a payment intent
 */
export type terminal_reader_reader_resource_process_payment_intent_action = {
  /**
   * Most recent PaymentIntent processed by the reader.
   */
  payment_intent: string | payment_intent;
  process_config?: terminal_reader_reader_resource_process_config;
};

/**
 * Represents a per-setup override of a reader configuration
 */
export type terminal_reader_reader_resource_process_setup_config = {
  /**
   * Enable customer initiated cancellation when processing this SetupIntent.
   */
  enable_customer_cancellation?: boolean;
};

/**
 * Represents a reader action to process a setup intent
 */
export type terminal_reader_reader_resource_process_setup_intent_action = {
  /**
   * ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.
   */
  generated_card?: string;
  process_config?: terminal_reader_reader_resource_process_setup_config;
  /**
   * Most recent SetupIntent processed by the reader.
   */
  setup_intent: string | setup_intent;
};

/**
 * Represents an action performed by the reader
 */
export type terminal_reader_reader_resource_reader_action = {
  /**
   * Failure code, only set if status is `failed`.
   */
  failure_code?: string | null;
  /**
   * Detailed failure message, only set if status is `failed`.
   */
  failure_message?: string | null;
  process_payment_intent?: terminal_reader_reader_resource_process_payment_intent_action;
  process_setup_intent?: terminal_reader_reader_resource_process_setup_intent_action;
  refund_payment?: terminal_reader_reader_resource_refund_payment_action;
  set_reader_display?: terminal_reader_reader_resource_set_reader_display_action;
  /**
   * Status of the action performed by the reader.
   */
  status: 'failed' | 'in_progress' | 'succeeded';
  /**
   * Type of action performed by the reader.
   */
  type: 'process_payment_intent' | 'process_setup_intent' | 'refund_payment' | 'set_reader_display';
};

/**
 * Status of the action performed by the reader.
 */
export type status36 = 'failed' | 'in_progress' | 'succeeded';

/**
 * Type of action performed by the reader.
 */
export type type61 = 'process_payment_intent' | 'process_setup_intent' | 'refund_payment' | 'set_reader_display';

/**
 * Represents a reader action to refund a payment
 */
export type terminal_reader_reader_resource_refund_payment_action = {
  /**
   * The amount being refunded.
   */
  amount?: number;
  /**
   * Charge that is being refunded.
   */
  charge?: string | charge;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  };
  /**
   * Payment intent that is being refunded.
   */
  payment_intent?: string | payment_intent;
  /**
   * The reason for the refund.
   */
  reason?: 'duplicate' | 'fraudulent' | 'requested_by_customer';
  /**
   * Unique identifier for the refund object.
   */
  refund?: string | refund;
  /**
   * Boolean indicating whether the application fee should be refunded when refunding this charge. If a full charge refund is given, the full application fee will be refunded. Otherwise, the application fee will be refunded in an amount proportional to the amount of the charge refunded. An application fee can be refunded only by the application that created the charge.
   */
  refund_application_fee?: boolean;
  refund_payment_config?: terminal_reader_reader_resource_refund_payment_config;
  /**
   * Boolean indicating whether the transfer should be reversed when refunding this charge. The transfer will be reversed proportionally to the amount being refunded (either the entire or partial amount). A transfer can be reversed only by the application that created the charge.
   */
  reverse_transfer?: boolean;
};

/**
 * The reason for the refund.
 */
export type reason7 = 'duplicate' | 'fraudulent' | 'requested_by_customer';

/**
 * Represents a per-transaction override of a reader configuration
 */
export type terminal_reader_reader_resource_refund_payment_config = {
  /**
   * Enable customer initiated cancellation when refunding this payment.
   */
  enable_customer_cancellation?: boolean;
};

/**
 * Represents a reader action to set the reader display
 */
export type terminal_reader_reader_resource_set_reader_display_action = {
  /**
   * Cart object to be displayed by the reader.
   */
  cart?: terminal_reader_reader_resource_cart | null;
  /**
   * Type of information to be displayed by the reader.
   */
  type: 'cart';
};

/**
 * Type of information to be displayed by the reader.
 */
export type type62 = 'cart';

/**
 * Represents a per-transaction tipping configuration
 */
export type terminal_reader_reader_resource_tipping_config = {
  /**
   * Amount used to calculate tip suggestions on tipping selection screen for this transaction. Must be a positive integer in the smallest currency unit (e.g., 100 cents to represent $1.00 or 100 to represent ¥100, a zero-decimal currency).
   */
  amount_eligible?: number;
};

/**
 * A test clock enables deterministic control over objects in testmode. With a test clock, you can create
 * objects at a frozen time in the past or future, and advance to a specific future time to observe webhooks and state changes. After the clock advances,
 * you can either validate the current state of your scenario (and test your assumptions), change the current state of your scenario (and test more complex scenarios), or keep advancing forward in time.
 */
export type test_helpers_test_clock = {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Time at which this clock is scheduled to auto delete.
   */
  deletes_after: number;
  /**
   * Time at which all objects belonging to this clock are frozen.
   */
  frozen_time: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * The custom name supplied at creation.
   */
  name?: string | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'test_helpers.test_clock';
  /**
   * The status of the Test Clock.
   */
  status: 'advancing' | 'internal_failure' | 'ready';
};

/**
 * The status of the Test Clock.
 */
export type status37 = 'advancing' | 'internal_failure' | 'ready';

export type three_d_secure_details = {
  /**
   * For authenticated transactions: how the customer was authenticated by
   * the issuing bank.
   */
  authentication_flow?: ('challenge' | 'frictionless') | null;
  /**
   * The Electronic Commerce Indicator (ECI). A protocol-level field
   * indicating what degree of authentication was performed.
   */
  electronic_commerce_indicator?: ('01' | '02' | '05' | '06' | '07') | null;
  /**
   * Indicates the outcome of 3D Secure authentication.
   */
  result?:
    | ('attempt_acknowledged' | 'authenticated' | 'exempted' | 'failed' | 'not_supported' | 'processing_error')
    | null;
  /**
   * Additional information about why 3D Secure succeeded or failed based
   * on the `result`.
   */
  result_reason?:
    | (
        | 'abandoned'
        | 'bypassed'
        | 'canceled'
        | 'card_not_enrolled'
        | 'network_not_supported'
        | 'protocol_error'
        | 'rejected'
      )
    | null;
  /**
   * The 3D Secure 1 XID or 3D Secure 2 Directory Server Transaction ID
   * (dsTransId) for this payment.
   */
  transaction_id?: string | null;
  /**
   * The version of 3D Secure that was used.
   */
  version?: ('1.0.2' | '2.1.0' | '2.2.0') | null;
};

/**
 * For authenticated transactions: how the customer was authenticated by
 * the issuing bank.
 */
export type authentication_flow = 'challenge' | 'frictionless';

/**
 * The Electronic Commerce Indicator (ECI). A protocol-level field
 * indicating what degree of authentication was performed.
 */
export type electronic_commerce_indicator = '01' | '02' | '05' | '06' | '07';

/**
 * Indicates the outcome of 3D Secure authentication.
 */
export type result2 =
  | 'attempt_acknowledged'
  | 'authenticated'
  | 'exempted'
  | 'failed'
  | 'not_supported'
  | 'processing_error';

/**
 * Additional information about why 3D Secure succeeded or failed based
 * on the `result`.
 */
export type result_reason =
  | 'abandoned'
  | 'bypassed'
  | 'canceled'
  | 'card_not_enrolled'
  | 'network_not_supported'
  | 'protocol_error'
  | 'rejected';

/**
 * The version of 3D Secure that was used.
 */
export type version = '1.0.2' | '2.1.0' | '2.2.0';

export type three_d_secure_details_charge = {
  /**
   * For authenticated transactions: how the customer was authenticated by
   * the issuing bank.
   */
  authentication_flow?: ('challenge' | 'frictionless') | null;
  /**
   * The Electronic Commerce Indicator (ECI). A protocol-level field
   * indicating what degree of authentication was performed.
   */
  electronic_commerce_indicator?: ('01' | '02' | '05' | '06' | '07') | null;
  /**
   * The exemption requested via 3DS and accepted by the issuer at authentication time.
   */
  exemption_indicator?: ('low_risk' | 'none') | null;
  /**
   * Whether Stripe requested the value of `exemption_indicator` in the transaction. This will depend on
   * the outcome of Stripe's internal risk assessment.
   */
  exemption_indicator_applied?: boolean;
  /**
   * Indicates the outcome of 3D Secure authentication.
   */
  result?:
    | ('attempt_acknowledged' | 'authenticated' | 'exempted' | 'failed' | 'not_supported' | 'processing_error')
    | null;
  /**
   * Additional information about why 3D Secure succeeded or failed based
   * on the `result`.
   */
  result_reason?:
    | (
        | 'abandoned'
        | 'bypassed'
        | 'canceled'
        | 'card_not_enrolled'
        | 'network_not_supported'
        | 'protocol_error'
        | 'rejected'
      )
    | null;
  /**
   * The 3D Secure 1 XID or 3D Secure 2 Directory Server Transaction ID
   * (dsTransId) for this payment.
   */
  transaction_id?: string | null;
  /**
   * The version of 3D Secure that was used.
   */
  version?: ('1.0.2' | '2.1.0' | '2.2.0') | null;
};

/**
 * The exemption requested via 3DS and accepted by the issuer at authentication time.
 */
export type exemption_indicator = 'low_risk' | 'none';

export type three_d_secure_usage = {
  /**
   * Whether 3D Secure is supported on this card.
   */
  supported: boolean;
};

/**
 * Tokenization is the process Stripe uses to collect sensitive card or bank
 * account details, or personally identifiable information (PII), directly from
 * your customers in a secure manner. A token representing this information is
 * returned to your server to use. Use our
 * [recommended payments integrations](https://stripe.com/docs/payments) to perform this process
 * on the client-side. This guarantees that no sensitive card data touches your server,
 * and allows your integration to operate in a PCI-compliant way.
 *
 * If you can't use client-side tokenization, you can also create tokens using
 * the API with either your publishable or secret API key. If
 * your integration uses this method, you're responsible for any PCI compliance
 * that it might require, and you must keep your secret API key safe. Unlike with
 * client-side tokenization, your customer's information isn't sent directly to
 * Stripe, so we can't determine how it's handled or stored.
 *
 * You can't store or use tokens more than once. To store card or bank account
 * information for later use, create [Customer](https://stripe.com/docs/api#customers)
 * objects or [External accounts](/api#external_accounts).
 * [Radar](https://stripe.com/docs/radar), our integrated solution for automatic fraud protection,
 * performs best with integrations that use client-side tokenization.
 */
export type token = {
  bank_account?: bank_account;
  card?: card;
  /**
   * IP address of the client that generates the token.
   */
  client_ip?: string | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'token';
  /**
   * Type of the token: `account`, `bank_account`, `card`, or `pii`.
   */
  type: string;
  /**
   * Determines if you have already used this token (you can only use tokens once).
   */
  used: boolean;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object108 = 'token';

export type token_card_networks = {
  /**
   * The preferred network for co-branded cards. Can be `cartes_bancaires`, `mastercard`, `visa` or `invalid_preference` if requested network is not valid for the card.
   */
  preferred?: string | null;
};

/**
 * To top up your Stripe balance, you create a top-up object. You can retrieve
 * individual top-ups, as well as list all top-ups. Top-ups are identified by a
 * unique, random ID.
 *
 * Related guide: [Topping up your platform account](https://stripe.com/docs/connect/top-ups)
 */
export type topup = {
  /**
   * Amount transferred.
   */
  amount: number;
  /**
   * ID of the balance transaction that describes the impact of this top-up on your account balance. May not be specified depending on status of top-up.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * Date the funds are expected to arrive in your Stripe account for payouts. This factors in delays like weekends or bank holidays. May not be specified depending on status of top-up.
   */
  expected_availability_date?: number | null;
  /**
   * Error code explaining reason for top-up failure if available (see [the errors section](https://stripe.com/docs/api#errors) for a list of codes).
   */
  failure_code?: string | null;
  /**
   * Message to user further explaining reason for top-up failure if available.
   */
  failure_message?: string | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'topup';
  /**
   * The source field is deprecated. It might not always be present in the API response.
   */
  source?: source | null;
  /**
   * Extra information about a top-up. This will appear on your source's bank statement. It must contain at least one letter.
   */
  statement_descriptor?: string | null;
  /**
   * The status of the top-up is either `canceled`, `failed`, `pending`, `reversed`, or `succeeded`.
   */
  status: 'canceled' | 'failed' | 'pending' | 'reversed' | 'succeeded';
  /**
   * A string that identifies this top-up as part of a group.
   */
  transfer_group?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object109 = 'topup';

/**
 * The status of the top-up is either `canceled`, `failed`, `pending`, `reversed`, or `succeeded`.
 */
export type status38 = 'canceled' | 'failed' | 'pending' | 'reversed' | 'succeeded';

/**
 * A `Transfer` object is created when you move funds between Stripe accounts as
 * part of Connect.
 *
 * Before April 6, 2017, transfers also represented movement of funds from a
 * Stripe account to a card or bank account. This behavior has since been split
 * out into a [Payout](https://stripe.com/docs/api#payout_object) object, with corresponding payout endpoints. For more
 * information, read about the
 * [transfer/payout split](https://stripe.com/docs/transfer-payout-split).
 *
 * Related guide: [Creating separate charges and transfers](https://stripe.com/docs/connect/separate-charges-and-transfers)
 */
export type transfer = {
  /**
   * Amount in cents (or local equivalent) to be transferred.
   */
  amount: number;
  /**
   * Amount in cents (or local equivalent) reversed (can be less than the amount attribute on the transfer if a partial reversal was issued).
   */
  amount_reversed: number;
  /**
   * Balance transaction that describes the impact of this transfer on your account balance.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * Time that this record of the transfer was first created.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  description?: string | null;
  /**
   * ID of the Stripe account the transfer was sent to.
   */
  destination?: (string | account) | null;
  /**
   * If the destination is a Stripe account, this will be the ID of the payment that the destination account received for the transfer.
   */
  destination_payment?: string | charge;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
   */
  livemode: boolean;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata: {
    [key: string]: string;
  };
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'transfer';
  /**
   * A list of reversals that have been applied to the transfer.
   */
  reversals: {
    /**
     * Details about each object.
     */
    data: Array<transfer_reversal>;
    /**
     * True if this list has another page of items after this one that can be fetched.
     */
    has_more: boolean;
    /**
     * String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
     */
    object: 'list';
    /**
     * The URL where this list can be accessed.
     */
    url: string;
  };
  /**
   * Whether the transfer has been fully reversed. If the transfer is only partially reversed, this attribute will still be false.
   */
  reversed: boolean;
  /**
   * ID of the charge or payment that was used to fund the transfer. If null, the transfer was funded from the available balance.
   */
  source_transaction?: (string | charge) | null;
  /**
   * The source balance this transfer came from. One of `card`, `fpx`, or `bank_account`.
   */
  source_type?: string;
  /**
   * A string that identifies this transaction as part of a group. See the [Connect documentation](https://stripe.com/docs/connect/separate-charges-and-transfers#transfer-options) for details.
   */
  transfer_group?: string | null;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object110 = 'transfer';

export type transfer_data = {
  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
   */
  amount?: number;
  /**
   * The account (if any) that the payment is attributed to for tax
   * reporting, and where funds from the payment are transferred to after
   * payment success.
   */
  destination: string | account;
};

/**
 * [Stripe Connect](https://stripe.com/docs/connect) platforms can reverse transfers made to a
 * connected account, either entirely or partially, and can also specify whether
 * to refund any related application fees. Transfer reversals add to the
 * platform's balance and subtract from the destination account's balance.
 *
 * Reversing a transfer that was made for a [destination
 * charge](/docs/connect/destination-charges) is allowed only up to the amount of
 * the charge. It is possible to reverse a
 * [transfer_group](https://stripe.com/docs/connect/separate-charges-and-transfers#transfer-options)
 * transfer only if the destination account has enough balance to cover the
 * reversal.
 *
 * Related guide: [Reverse transfers](https://stripe.com/docs/connect/separate-charges-and-transfers#reverse-transfers)
 */
export type transfer_reversal = {
  /**
   * Amount, in cents (or local equivalent).
   */
  amount: number;
  /**
   * Balance transaction that describes the impact on your account balance.
   */
  balance_transaction?: (string | balance_transaction) | null;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  created: number;
  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  currency: string;
  /**
   * Linked payment refund for the transfer reversal.
   */
  destination_payment_refund?: (string | refund) | null;
  /**
   * Unique identifier for the object.
   */
  id: string;
  /**
   * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
   */
  metadata?: {
    [key: string]: string;
  } | null;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  object: 'transfer_reversal';
  /**
   * ID of the refund responsible for the transfer reversal.
   */
  source_refund?: (string | refund) | null;
  /**
   * ID of the transfer that was reversed.
   */
  transfer: string | transfer;
};

/**
 * String representing the object's type. Objects of the same type share the same value.
 */
export type object111 = 'transfer_reversal';

export type transfer_schedule = {
  /**
   * The number of days charges for the account will be held before being paid out.
   */
  delay_days: number;
  /**
   * How frequently funds will be paid out. One of `manual` (payouts only created via API call), `daily`, `weekly`, or `monthly`.
   */
  interval: string;
  /**
   * The day of the month funds will be paid out. Only shown if `interval` is monthly. Payouts scheduled between the 29th and 31st of the month are sent on the last day of shorter months.
   */
  monthly_anchor?: number;
  /**
   * The day of the week funds will be paid out, of the style 'monday', 'tuesday', etc. Only shown if `interval` is weekly.
   */
  weekly_anchor?: string;
};

export type transform_quantity = {
  /**
   * Divide usage by this number.
   */
  divide_by: number;
  /**
   * After division, either round the result `up` or `down`.
   */
  round: 'down' | 'up';
};

/**
 * After division, either round the result `up` or `down`.
 */
export type round = 'down' | 'up';

export type transform_usage = {
  /**
   * Divide usage by this number.
   */
  divide_by: number;
  /**
   * After division, either round the result `up` or `down`.
   */
  round: 'down' | 'up';
};

/**
 * You can reverse some [ReceivedCredits](https://stripe.com/docs/api#received_credits) depending on their network and source flow. Reversing a ReceivedCredit leads to the creation of a new object known as a CreditReversal.
 */
export type treasury_credit_reversal = {
  /**
   * Amount (in cents) transferred.
   */
  amount: number;
  /**
   * Time at which the object was created. Measured in se