// This file is auto-generated by @hey-api/openapi-ts

export const accountSchema = {
  description: `This is an object representing a Stripe account. You can retrieve it to see
properties on the account like its current requirements or if the account is
enabled to make live charges or receive payouts.

For accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection)
is \`application\`, which includes Custom accounts, the properties below are always
returned.

For accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection)
is \`stripe\`, which includes Standard and Express accounts, some properties are only returned
until you create an [Account Link](/api/account_links) or [Account Session](/api/account_sessions)
to start Connect Onboarding. Learn about the [differences between accounts](/connect/accounts).`,
  properties: {
    business_profile: {
      anyOf: [
        {
          $ref: '#/components/schemas/account_business_profile',
        },
      ],
      description: 'Business information about the account.',
      nullable: true,
    },
    business_type: {
      description:
        'The business type. After you create an [Account Link](/api/account_links) or [Account Session](/api/account_sessions), this property is only returned for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.',
      enum: ['company', 'government_entity', 'individual', 'non_profit'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    capabilities: {
      $ref: '#/components/schemas/account_capabilities',
    },
    charges_enabled: {
      description: 'Whether the account can create live charges.',
      type: 'boolean',
    },
    company: {
      $ref: '#/components/schemas/legal_entity_company',
    },
    controller: {
      $ref: '#/components/schemas/account_unification_account_controller',
    },
    country: {
      description: "The account's country.",
      maxLength: 5000,
      type: 'string',
    },
    created: {
      description: 'Time at which the account was connected. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    default_currency: {
      description:
        "Three-letter ISO currency code representing the default currency for the account. This must be a currency that [Stripe supports in the account's country](https://stripe.com/docs/payouts).",
      maxLength: 5000,
      type: 'string',
    },
    details_submitted: {
      description:
        'Whether account details have been submitted. Accounts with Stripe Dashboard access, which includes Standard accounts, cannot receive payouts before this is true. Accounts where this is false should be directed to [an onboarding flow](/connect/onboarding) to finish submitting account details.',
      type: 'boolean',
    },
    email: {
      description:
        "An email address associated with the account. It's not used for authentication and Stripe doesn't market to this field without explicit approval from the platform.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    external_accounts: {
      description:
        'External accounts (bank accounts and debit cards) currently attached to this account. External accounts are only returned for requests where `controller[is_controller]` is true.',
      properties: {
        data: {
          description:
            'The list contains all external accounts that have been attached to the Stripe account. These may be bank accounts or cards.',
          items: {
            anyOf: [
              {
                $ref: '#/components/schemas/bank_account',
              },
              {
                $ref: '#/components/schemas/card',
              },
            ],
            title: 'Polymorphic',
            'x-stripeBypassValidation': true,
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'ExternalAccountList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    future_requirements: {
      $ref: '#/components/schemas/account_future_requirements',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    individual: {
      $ref: '#/components/schemas/person',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['account'],
      type: 'string',
    },
    payouts_enabled: {
      description: 'Whether Stripe can send payouts to this account.',
      type: 'boolean',
    },
    requirements: {
      $ref: '#/components/schemas/account_requirements',
    },
    settings: {
      anyOf: [
        {
          $ref: '#/components/schemas/account_settings',
        },
      ],
      description: 'Options for customizing how the account functions within Stripe.',
      nullable: true,
    },
    tos_acceptance: {
      $ref: '#/components/schemas/account_tos_acceptance',
    },
    type: {
      description: 'The Stripe account type. Can be `standard`, `express`, `custom`, or `none`.',
      enum: ['custom', 'express', 'none', 'standard'],
      type: 'string',
    },
  },
  required: ['id', 'object'],
  title: 'Account',
  type: 'object',
  'x-expandableFields': [
    'business_profile',
    'capabilities',
    'company',
    'controller',
    'external_accounts',
    'future_requirements',
    'individual',
    'requirements',
    'settings',
    'tos_acceptance',
  ],
  'x-resourceId': 'account',
} as const;

export const account_annual_revenueSchema = {
  description: '',
  properties: {
    amount: {
      description:
        'A non-negative integer representing the amount in the [smallest currency unit](https://docs.stripe.com/currencies#zero-decimal).',
      nullable: true,
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      nullable: true,
      type: 'string',
    },
    fiscal_year_end: {
      description:
        'The close-out date of the preceding fiscal year in ISO 8601 format. E.g. 2023-12-31 for the 31st of December, 2023.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountAnnualRevenue',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_bacs_debit_payments_settingsSchema = {
  description: '',
  properties: {
    display_name: {
      description: `The Bacs Direct Debit display name for this account. For payments made with Bacs Direct Debit, this name appears on the mandate as the statement descriptor. Mobile banking apps display it as the name of the business. To use custom branding, set the Bacs Direct Debit Display Name during or right after creation. Custom branding incurs an additional monthly fee for the platform. The fee appears 5 business days after requesting Bacs. If you don't set the display name before requesting Bacs capability, it's automatically set as "Stripe" and the account is onboarded to Stripe branding, which is free.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    service_user_number: {
      description:
        'The Bacs Direct Debit Service user number for this account. For payments made with Bacs Direct Debit, this number is a unique identifier of the account with our banking partners.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountBacsDebitPaymentsSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_branding_settingsSchema = {
  description: '',
  properties: {
    icon: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) An icon for the account. Must be square and at least 128px x 128px.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    logo: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        "(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) A logo for the account that will be used in Checkout instead of the icon and without the account's name next to it if provided. Must be at least 128px x 128px.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    primary_color: {
      description: 'A CSS hex color value representing the primary branding color for this account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    secondary_color: {
      description: 'A CSS hex color value representing the secondary branding color for this account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountBrandingSettings',
  type: 'object',
  'x-expandableFields': ['icon', 'logo'],
} as const;

export const account_business_profileSchema = {
  description: '',
  properties: {
    annual_revenue: {
      anyOf: [
        {
          $ref: '#/components/schemas/account_annual_revenue',
        },
      ],
      description: "The applicant's gross annual revenue for its preceding fiscal year.",
      nullable: true,
    },
    estimated_worker_count: {
      description:
        'An estimated upper bound of employees, contractors, vendors, etc. currently working for the business.',
      nullable: true,
      type: 'integer',
    },
    mcc: {
      description:
        '[The merchant category code for the account](https://stripe.com/docs/connect/setting-mcc). MCCs are used to classify businesses based on the goods or services they provide.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    monthly_estimated_revenue: {
      $ref: '#/components/schemas/account_monthly_estimated_revenue',
    },
    name: {
      description: 'The customer-facing business name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_description: {
      description:
        "Internal-only description of the product sold or service provided by the business. It's used by Stripe for risk and underwriting purposes.",
      maxLength: 40000,
      nullable: true,
      type: 'string',
    },
    support_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description: 'A publicly available mailing address for sending support issues to.',
      nullable: true,
    },
    support_email: {
      description: 'A publicly available email address for sending support issues to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    support_phone: {
      description: 'A publicly available phone number to call with support issues.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    support_url: {
      description: 'A publicly available website for handling support issues.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: "The business's publicly available website.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountBusinessProfile',
  type: 'object',
  'x-expandableFields': ['annual_revenue', 'monthly_estimated_revenue', 'support_address'],
} as const;

export const account_capabilitiesSchema = {
  description: '',
  properties: {
    acss_debit_payments: {
      description:
        'The status of the Canadian pre-authorized debits payments capability of the account, or whether the account can directly process Canadian pre-authorized debits charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    affirm_payments: {
      description:
        'The status of the Affirm capability of the account, or whether the account can directly process Affirm charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    afterpay_clearpay_payments: {
      description:
        'The status of the Afterpay Clearpay capability of the account, or whether the account can directly process Afterpay Clearpay charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    amazon_pay_payments: {
      description:
        'The status of the AmazonPay capability of the account, or whether the account can directly process AmazonPay payments.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    au_becs_debit_payments: {
      description:
        'The status of the BECS Direct Debit (AU) payments capability of the account, or whether the account can directly process BECS Direct Debit (AU) charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    bacs_debit_payments: {
      description:
        'The status of the Bacs Direct Debits payments capability of the account, or whether the account can directly process Bacs Direct Debits charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    bancontact_payments: {
      description:
        'The status of the Bancontact payments capability of the account, or whether the account can directly process Bancontact charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    bank_transfer_payments: {
      description:
        'The status of the customer_balance payments capability of the account, or whether the account can directly process customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    blik_payments: {
      description:
        'The status of the blik payments capability of the account, or whether the account can directly process blik charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    boleto_payments: {
      description:
        'The status of the boleto payments capability of the account, or whether the account can directly process boleto charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    card_issuing: {
      description:
        'The status of the card issuing capability of the account, or whether you can use Issuing to distribute funds on cards',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    card_payments: {
      description:
        'The status of the card payments capability of the account, or whether the account can directly process credit and debit card charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    cartes_bancaires_payments: {
      description:
        'The status of the Cartes Bancaires payments capability of the account, or whether the account can directly process Cartes Bancaires card charges in EUR currency.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    cashapp_payments: {
      description:
        'The status of the Cash App Pay capability of the account, or whether the account can directly process Cash App Pay payments.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    eps_payments: {
      description:
        'The status of the EPS payments capability of the account, or whether the account can directly process EPS charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    fpx_payments: {
      description:
        'The status of the FPX payments capability of the account, or whether the account can directly process FPX charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    gb_bank_transfer_payments: {
      description:
        'The status of the GB customer_balance payments (GBP currency) capability of the account, or whether the account can directly process GB customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    giropay_payments: {
      description:
        'The status of the giropay payments capability of the account, or whether the account can directly process giropay charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    grabpay_payments: {
      description:
        'The status of the GrabPay payments capability of the account, or whether the account can directly process GrabPay charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    ideal_payments: {
      description:
        'The status of the iDEAL payments capability of the account, or whether the account can directly process iDEAL charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    india_international_payments: {
      description:
        'The status of the india_international_payments capability of the account, or whether the account can process international charges (non INR) in India.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    jcb_payments: {
      description:
        'The status of the JCB payments capability of the account, or whether the account (Japan only) can directly process JCB credit card charges in JPY currency.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    jp_bank_transfer_payments: {
      description:
        'The status of the Japanese customer_balance payments (JPY currency) capability of the account, or whether the account can directly process Japanese customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    klarna_payments: {
      description:
        'The status of the Klarna payments capability of the account, or whether the account can directly process Klarna charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    konbini_payments: {
      description:
        'The status of the konbini payments capability of the account, or whether the account can directly process konbini charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    legacy_payments: {
      description: 'The status of the legacy payments capability of the account.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    link_payments: {
      description:
        'The status of the link_payments capability of the account, or whether the account can directly process Link charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    mobilepay_payments: {
      description:
        'The status of the MobilePay capability of the account, or whether the account can directly process MobilePay charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    multibanco_payments: {
      description:
        'The status of the Multibanco payments capability of the account, or whether the account can directly process Multibanco charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    mx_bank_transfer_payments: {
      description:
        'The status of the Mexican customer_balance payments (MXN currency) capability of the account, or whether the account can directly process Mexican customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    oxxo_payments: {
      description:
        'The status of the OXXO payments capability of the account, or whether the account can directly process OXXO charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    p24_payments: {
      description:
        'The status of the P24 payments capability of the account, or whether the account can directly process P24 charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    paynow_payments: {
      description:
        'The status of the paynow payments capability of the account, or whether the account can directly process paynow charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    promptpay_payments: {
      description:
        'The status of the promptpay payments capability of the account, or whether the account can directly process promptpay charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    revolut_pay_payments: {
      description:
        'The status of the RevolutPay capability of the account, or whether the account can directly process RevolutPay payments.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    sepa_bank_transfer_payments: {
      description:
        'The status of the SEPA customer_balance payments (EUR currency) capability of the account, or whether the account can directly process SEPA customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    sepa_debit_payments: {
      description:
        'The status of the SEPA Direct Debits payments capability of the account, or whether the account can directly process SEPA Direct Debits charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    sofort_payments: {
      description:
        'The status of the Sofort payments capability of the account, or whether the account can directly process Sofort charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    swish_payments: {
      description:
        'The status of the Swish capability of the account, or whether the account can directly process Swish payments.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    tax_reporting_us_1099_k: {
      description: 'The status of the tax reporting 1099-K (US) capability of the account.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    tax_reporting_us_1099_misc: {
      description: 'The status of the tax reporting 1099-MISC (US) capability of the account.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    transfers: {
      description:
        'The status of the transfers capability of the account, or whether your platform can transfer funds to the account.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    treasury: {
      description: 'The status of the banking capability, or whether the account can have bank accounts.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    twint_payments: {
      description:
        'The status of the TWINT capability of the account, or whether the account can directly process TWINT charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    us_bank_account_ach_payments: {
      description:
        'The status of the US bank account ACH payments capability of the account, or whether the account can directly process US bank account charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    us_bank_transfer_payments: {
      description:
        'The status of the US customer_balance payments (USD currency) capability of the account, or whether the account can directly process US customer_balance charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    zip_payments: {
      description:
        'The status of the Zip capability of the account, or whether the account can directly process Zip charges.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
  },
  title: 'AccountCapabilities',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_capability_future_requirementsSchema = {
  description: '',
  properties: {
    alternatives: {
      description:
        'Fields that are due and can be satisfied by providing the corresponding alternative fields instead.',
      items: {
        $ref: '#/components/schemas/account_requirements_alternative',
      },
      nullable: true,
      type: 'array',
    },
    current_deadline: {
      description:
        "Date on which `future_requirements` merges with the main `requirements` hash and `future_requirements` becomes empty. After the transition, `currently_due` requirements may immediately become `past_due`, but the account may also be given a grace period depending on the capability's enablement state prior to transitioning.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    currently_due: {
      description:
        'Fields that need to be collected to keep the capability enabled. If not collected by `future_requirements[current_deadline]`, these fields will transition to the main `requirements` hash.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    disabled_reason: {
      description:
        'This is typed as a string for consistency with `requirements.disabled_reason`, but it safe to assume `future_requirements.disabled_reason` is empty because fields in `future_requirements` will never disable the account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    errors: {
      description:
        'Fields that are `currently_due` and need to be collected again because validation or verification failed.',
      items: {
        $ref: '#/components/schemas/account_requirements_error',
      },
      type: 'array',
    },
    eventually_due: {
      description:
        'Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    past_due: {
      description:
        "Fields that weren't collected by `requirements.current_deadline`. These fields need to be collected to enable the capability on the account. New fields will never appear here; `future_requirements.past_due` will always be a subset of `requirements.past_due`.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    pending_verification: {
      description:
        "Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due` or `currently_due`. Fields might appear in `eventually_due` or `currently_due` and in `pending_verification` if verification fails but another verification is still pending.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['currently_due', 'errors', 'eventually_due', 'past_due', 'pending_verification'],
  title: 'AccountCapabilityFutureRequirements',
  type: 'object',
  'x-expandableFields': ['alternatives', 'errors'],
} as const;

export const account_capability_requirementsSchema = {
  description: '',
  properties: {
    alternatives: {
      description:
        'Fields that are due and can be satisfied by providing the corresponding alternative fields instead.',
      items: {
        $ref: '#/components/schemas/account_requirements_alternative',
      },
      nullable: true,
      type: 'array',
    },
    current_deadline: {
      description:
        'Date by which the fields in `currently_due` must be collected to keep the capability enabled for the account. These fields may disable the capability sooner if the next threshold is reached before they are collected.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    currently_due: {
      description:
        'Fields that need to be collected to keep the capability enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the capability is disabled.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    disabled_reason: {
      description: `If the capability is disabled, this string describes why. [Learn more about handling verification issues](https://stripe.com/docs/connect/handling-api-verification). Can be \`requirements.fields_needed\`, \`pending.onboarding\`, \`pending.review\`, \`rejected.other\`, \`platform_paused\`, \`rejected.inactivty\`, or \`rejected.unsupported_business\`.

\`rejected.unsupported_business\` means that the account's business is not supported by the capability. For example, payment methods may restrict the businesses they support in their terms of service, such as in [Afterpay Clearpay's terms of service](/afterpay-clearpay/legal#restricted-businesses).

\`rejected.inactivity\` means that the capability has been paused for inactivity. This disabled reason currently only applies to the Issuing capability. See [Issuing: Managing Inactive Connects](https://support.stripe.com/questions/issuing-managing-inactive-connect-accounts) for more details.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    errors: {
      description:
        'Fields that are `currently_due` and need to be collected again because validation or verification failed.',
      items: {
        $ref: '#/components/schemas/account_requirements_error',
      },
      type: 'array',
    },
    eventually_due: {
      description:
        'Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and `current_deadline` becomes set.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    past_due: {
      description:
        "Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the capability on the account.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    pending_verification: {
      description:
        "Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['currently_due', 'errors', 'eventually_due', 'past_due', 'pending_verification'],
  title: 'AccountCapabilityRequirements',
  type: 'object',
  'x-expandableFields': ['alternatives', 'errors'],
} as const;

export const account_card_issuing_settingsSchema = {
  description: '',
  properties: {
    tos_acceptance: {
      $ref: '#/components/schemas/card_issuing_account_terms_of_service',
    },
  },
  title: 'AccountCardIssuingSettings',
  type: 'object',
  'x-expandableFields': ['tos_acceptance'],
} as const;

export const account_card_payments_settingsSchema = {
  description: '',
  properties: {
    decline_on: {
      $ref: '#/components/schemas/account_decline_charge_on',
    },
    statement_descriptor_prefix: {
      description:
        'The default text that appears on credit card statements when a charge is made. This field prefixes any dynamic `statement_descriptor` specified on the charge. `statement_descriptor_prefix` is useful for maximizing descriptor space for the dynamic portion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_prefix_kana: {
      description:
        'The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kana` specified on the charge. `statement_descriptor_prefix_kana` is useful for maximizing descriptor space for the dynamic portion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_prefix_kanji: {
      description:
        'The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kanji` specified on the charge. `statement_descriptor_prefix_kanji` is useful for maximizing descriptor space for the dynamic portion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountCardPaymentsSettings',
  type: 'object',
  'x-expandableFields': ['decline_on'],
} as const;

export const account_dashboard_settingsSchema = {
  description: '',
  properties: {
    display_name: {
      description:
        'The display name for this account. This is used on the Stripe Dashboard to differentiate between accounts.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    timezone: {
      description:
        'The timezone used in the Stripe Dashboard for this account. A list of possible time zone values is maintained at the [IANA Time Zone Database](http://www.iana.org/time-zones).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountDashboardSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_decline_charge_onSchema = {
  description: '',
  properties: {
    avs_failure: {
      description:
        'Whether Stripe automatically declines charges with an incorrect ZIP or postal code. This setting only applies when a ZIP or postal code is provided and they fail bank verification.',
      type: 'boolean',
    },
    cvc_failure: {
      description:
        'Whether Stripe automatically declines charges with an incorrect CVC. This setting only applies when a CVC is provided and it fails bank verification.',
      type: 'boolean',
    },
  },
  required: ['avs_failure', 'cvc_failure'],
  title: 'AccountDeclineChargeOn',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_future_requirementsSchema = {
  description: '',
  properties: {
    alternatives: {
      description:
        'Fields that are due and can be satisfied by providing the corresponding alternative fields instead.',
      items: {
        $ref: '#/components/schemas/account_requirements_alternative',
      },
      nullable: true,
      type: 'array',
    },
    current_deadline: {
      description:
        'Date on which `future_requirements` merges with the main `requirements` hash and `future_requirements` becomes empty. After the transition, `currently_due` requirements may immediately become `past_due`, but the account may also be given a grace period depending on its enablement state prior to transitioning.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    currently_due: {
      description:
        'Fields that need to be collected to keep the account enabled. If not collected by `future_requirements[current_deadline]`, these fields will transition to the main `requirements` hash.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    disabled_reason: {
      description: 'This is typed as a string for consistency with `requirements.disabled_reason`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    errors: {
      description:
        'Fields that are `currently_due` and need to be collected again because validation or verification failed.',
      items: {
        $ref: '#/components/schemas/account_requirements_error',
      },
      nullable: true,
      type: 'array',
    },
    eventually_due: {
      description:
        'Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    past_due: {
      description:
        "Fields that weren't collected by `requirements.current_deadline`. These fields need to be collected to enable the capability on the account. New fields will never appear here; `future_requirements.past_due` will always be a subset of `requirements.past_due`.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    pending_verification: {
      description:
        "Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due` or `currently_due`. Fields might appear in `eventually_due` or `currently_due` and in `pending_verification` if verification fails but another verification is still pending.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'AccountFutureRequirements',
  type: 'object',
  'x-expandableFields': ['alternatives', 'errors'],
} as const;

export const account_invoices_settingsSchema = {
  description: '',
  properties: {
    default_account_tax_ids: {
      description:
        'The list of default Account Tax IDs to automatically include on invoices. Account Tax IDs get added when an invoice is finalized.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/tax_id',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/tax_id',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'AccountInvoicesSettings',
  type: 'object',
  'x-expandableFields': ['default_account_tax_ids'],
} as const;

export const account_linkSchema = {
  description: `Account Links are the means by which a Connect platform grants a connected account permission to access
Stripe-hosted applications, such as Connect Onboarding.

Related guide: [Connect Onboarding](https://stripe.com/docs/connect/custom/hosted-onboarding)`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    expires_at: {
      description: 'The timestamp at which this account link will expire.',
      format: 'unix-time',
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['account_link'],
      type: 'string',
    },
    url: {
      description: 'The URL for the account link.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['created', 'expires_at', 'object', 'url'],
  title: 'AccountLink',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'account_link',
} as const;

export const account_monthly_estimated_revenueSchema = {
  description: '',
  properties: {
    amount: {
      description:
        'A non-negative integer representing how much to charge in the [smallest currency unit](https://docs.stripe.com/currencies#zero-decimal).',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
  },
  required: ['amount', 'currency'],
  title: 'AccountMonthlyEstimatedRevenue',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_payments_settingsSchema = {
  description: '',
  properties: {
    statement_descriptor: {
      description:
        'The default text that appears on credit card statements when a charge is made. This field prefixes any dynamic `statement_descriptor` specified on the charge.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_kana: {
      description:
        'The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only)',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_kanji: {
      description:
        'The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only)',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_prefix_kana: {
      description:
        'The Kana variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kana` specified on the charge. `statement_descriptor_prefix_kana` is useful for maximizing descriptor space for the dynamic portion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_prefix_kanji: {
      description:
        'The Kanji variation of the default text that appears on credit card statements when a charge is made (Japan only). This field prefixes any dynamic `statement_descriptor_suffix_kanji` specified on the charge. `statement_descriptor_prefix_kanji` is useful for maximizing descriptor space for the dynamic portion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountPaymentsSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_payout_settingsSchema = {
  description: '',
  properties: {
    debit_negative_balances: {
      description:
        'A Boolean indicating if Stripe should try to reclaim negative balances from an attached bank account. See [Understanding Connect account balances](/connect/account-balances) for details. The default value is `false` when [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts, otherwise `true`.',
      type: 'boolean',
    },
    schedule: {
      $ref: '#/components/schemas/transfer_schedule',
    },
    statement_descriptor: {
      description:
        "The text that appears on the bank account statement for payouts. If not set, this defaults to the platform's bank descriptor as set in the Dashboard.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['debit_negative_balances', 'schedule'],
  title: 'AccountPayoutSettings',
  type: 'object',
  'x-expandableFields': ['schedule'],
} as const;

export const account_requirementsSchema = {
  description: '',
  properties: {
    alternatives: {
      description:
        'Fields that are due and can be satisfied by providing the corresponding alternative fields instead.',
      items: {
        $ref: '#/components/schemas/account_requirements_alternative',
      },
      nullable: true,
      type: 'array',
    },
    current_deadline: {
      description:
        'Date by which the fields in `currently_due` must be collected to keep the account enabled. These fields may disable the account sooner if the next threshold is reached before they are collected.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    currently_due: {
      description:
        'Fields that need to be collected to keep the account enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the account is disabled.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    disabled_reason: {
      description:
        'If the account is disabled, this string describes why. [Learn more about handling verification issues](https://stripe.com/docs/connect/handling-api-verification). Can be `action_required.requested_capabilities`, `requirements.past_due`, `requirements.pending_verification`, `listed`, `platform_paused`, `rejected.fraud`, `rejected.incomplete_verification`, `rejected.listed`, `rejected.other`, `rejected.terms_of_service`, `under_review`, or `other`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    errors: {
      description:
        'Fields that are `currently_due` and need to be collected again because validation or verification failed.',
      items: {
        $ref: '#/components/schemas/account_requirements_error',
      },
      nullable: true,
      type: 'array',
    },
    eventually_due: {
      description:
        'Fields that need to be collected assuming all volume thresholds are reached. As they become required, they appear in `currently_due` as well, and `current_deadline` becomes set.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    past_due: {
      description:
        "Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the account.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    pending_verification: {
      description:
        "Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'AccountRequirements',
  type: 'object',
  'x-expandableFields': ['alternatives', 'errors'],
} as const;

export const account_requirements_alternativeSchema = {
  description: '',
  properties: {
    alternative_fields_due: {
      description: 'Fields that can be provided to satisfy all fields in `original_fields_due`.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    original_fields_due: {
      description: 'Fields that are due and can be satisfied by providing all fields in `alternative_fields_due`.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['alternative_fields_due', 'original_fields_due'],
  title: 'AccountRequirementsAlternative',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_requirements_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'The code for the type of error.',
      enum: [
        'invalid_address_city_state_postal_code',
        'invalid_address_highway_contract_box',
        'invalid_address_private_mailbox',
        'invalid_business_profile_name',
        'invalid_business_profile_name_denylisted',
        'invalid_company_name_denylisted',
        'invalid_dob_age_over_maximum',
        'invalid_dob_age_under_18',
        'invalid_dob_age_under_minimum',
        'invalid_product_description_length',
        'invalid_product_description_url_match',
        'invalid_representative_country',
        'invalid_statement_descriptor_business_mismatch',
        'invalid_statement_descriptor_denylisted',
        'invalid_statement_descriptor_length',
        'invalid_statement_descriptor_prefix_denylisted',
        'invalid_statement_descriptor_prefix_mismatch',
        'invalid_street_address',
        'invalid_tax_id',
        'invalid_tax_id_format',
        'invalid_tos_acceptance',
        'invalid_url_denylisted',
        'invalid_url_format',
        'invalid_url_web_presence_detected',
        'invalid_url_website_business_information_mismatch',
        'invalid_url_website_empty',
        'invalid_url_website_inaccessible',
        'invalid_url_website_inaccessible_geoblocked',
        'invalid_url_website_inaccessible_password_protected',
        'invalid_url_website_incomplete',
        'invalid_url_website_incomplete_cancellation_policy',
        'invalid_url_website_incomplete_customer_service_details',
        'invalid_url_website_incomplete_legal_restrictions',
        'invalid_url_website_incomplete_refund_policy',
        'invalid_url_website_incomplete_return_policy',
        'invalid_url_website_incomplete_terms_and_conditions',
        'invalid_url_website_incomplete_under_construction',
        'invalid_url_website_other',
        'invalid_value_other',
        'verification_directors_mismatch',
        'verification_document_address_mismatch',
        'verification_document_address_missing',
        'verification_document_corrupt',
        'verification_document_country_not_supported',
        'verification_document_directors_mismatch',
        'verification_document_dob_mismatch',
        'verification_document_duplicate_type',
        'verification_document_expired',
        'verification_document_failed_copy',
        'verification_document_failed_greyscale',
        'verification_document_failed_other',
        'verification_document_failed_test_mode',
        'verification_document_fraudulent',
        'verification_document_id_number_mismatch',
        'verification_document_id_number_missing',
        'verification_document_incomplete',
        'verification_document_invalid',
        'verification_document_issue_or_expiry_date_missing',
        'verification_document_manipulated',
        'verification_document_missing_back',
        'verification_document_missing_front',
        'verification_document_name_mismatch',
        'verification_document_name_missing',
        'verification_document_nationality_mismatch',
        'verification_document_not_readable',
        'verification_document_not_signed',
        'verification_document_not_uploaded',
        'verification_document_photo_mismatch',
        'verification_document_too_large',
        'verification_document_type_not_supported',
        'verification_extraneous_directors',
        'verification_failed_address_match',
        'verification_failed_business_iec_number',
        'verification_failed_document_match',
        'verification_failed_id_number_match',
        'verification_failed_keyed_identity',
        'verification_failed_keyed_match',
        'verification_failed_name_match',
        'verification_failed_other',
        'verification_failed_representative_authority',
        'verification_failed_residential_address',
        'verification_failed_tax_id_match',
        'verification_failed_tax_id_not_issued',
        'verification_missing_directors',
        'verification_missing_executives',
        'verification_missing_owners',
        'verification_requires_additional_memorandum_of_associations',
        'verification_requires_additional_proof_of_registration',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    reason: {
      description:
        'An informative message that indicates the error type and provides additional details about the error.',
      maxLength: 5000,
      type: 'string',
    },
    requirement: {
      description:
        'The specific user onboarding requirement field (in the requirements hash) that needs to be resolved.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['code', 'reason', 'requirement'],
  title: 'AccountRequirementsError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_sepa_debit_payments_settingsSchema = {
  description: '',
  properties: {
    creditor_id: {
      description: 'SEPA creditor identifier that identifies the company making the payment.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'AccountSepaDebitPaymentsSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_sessionSchema = {
  description: `An AccountSession allows a Connect platform to grant access to a connected account in Connect embedded components.

We recommend that you create an AccountSession each time you need to display an embedded component
to your user. Do not save AccountSessions to your database as they expire relatively
quickly, and cannot be used more than once.

Related guide: [Connect embedded components](https://stripe.com/docs/connect/get-started-connect-embedded-components)`,
  properties: {
    account: {
      description: 'The ID of the account the AccountSession was created for',
      maxLength: 5000,
      type: 'string',
    },
    client_secret: {
      description: `The client secret of this AccountSession. Used on the client to set up secure access to the given \`account\`.

The client secret can be used to provide access to \`account\` from your frontend. It should not be stored, logged, or exposed to anyone other than the connected account. Make sure that you have TLS enabled on any page that includes the client secret.

Refer to our docs to [setup Connect embedded components](https://stripe.com/docs/connect/get-started-connect-embedded-components) and learn about how \`client_secret\` should be handled.`,
      maxLength: 5000,
      type: 'string',
    },
    components: {
      $ref: '#/components/schemas/connect_embedded_account_session_create_components',
    },
    expires_at: {
      description: 'The timestamp at which this AccountSession will expire.',
      format: 'unix-time',
      type: 'integer',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['account_session'],
      type: 'string',
    },
  },
  required: ['account', 'client_secret', 'components', 'expires_at', 'livemode', 'object'],
  title: 'ConnectEmbeddedMethodAccountSessionCreateMethodAccountSession',
  type: 'object',
  'x-expandableFields': ['components'],
  'x-resourceId': 'account_session',
} as const;

export const account_settingsSchema = {
  description: '',
  properties: {
    bacs_debit_payments: {
      $ref: '#/components/schemas/account_bacs_debit_payments_settings',
    },
    branding: {
      $ref: '#/components/schemas/account_branding_settings',
    },
    card_issuing: {
      $ref: '#/components/schemas/account_card_issuing_settings',
    },
    card_payments: {
      $ref: '#/components/schemas/account_card_payments_settings',
    },
    dashboard: {
      $ref: '#/components/schemas/account_dashboard_settings',
    },
    invoices: {
      $ref: '#/components/schemas/account_invoices_settings',
    },
    payments: {
      $ref: '#/components/schemas/account_payments_settings',
    },
    payouts: {
      $ref: '#/components/schemas/account_payout_settings',
    },
    sepa_debit_payments: {
      $ref: '#/components/schemas/account_sepa_debit_payments_settings',
    },
    treasury: {
      $ref: '#/components/schemas/account_treasury_settings',
    },
  },
  required: ['branding', 'card_payments', 'dashboard', 'payments'],
  title: 'AccountSettings',
  type: 'object',
  'x-expandableFields': [
    'bacs_debit_payments',
    'branding',
    'card_issuing',
    'card_payments',
    'dashboard',
    'invoices',
    'payments',
    'payouts',
    'sepa_debit_payments',
    'treasury',
  ],
} as const;

export const account_terms_of_serviceSchema = {
  description: '',
  properties: {
    date: {
      description: 'The Unix timestamp marking when the account representative accepted the service agreement.',
      nullable: true,
      type: 'integer',
    },
    ip: {
      description: 'The IP address from which the account representative accepted the service agreement.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description:
        'The user agent of the browser from which the account representative accepted the service agreement.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'AccountTermsOfService',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_tos_acceptanceSchema = {
  description: '',
  properties: {
    date: {
      description: 'The Unix timestamp marking when the account representative accepted their service agreement',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    ip: {
      description: 'The IP address from which the account representative accepted their service agreement',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    service_agreement: {
      description: "The user's service agreement type",
      maxLength: 5000,
      type: 'string',
    },
    user_agent: {
      description:
        'The user agent of the browser from which the account representative accepted their service agreement',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'AccountTOSAcceptance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_treasury_settingsSchema = {
  description: '',
  properties: {
    tos_acceptance: {
      $ref: '#/components/schemas/account_terms_of_service',
    },
  },
  title: 'AccountTreasurySettings',
  type: 'object',
  'x-expandableFields': ['tos_acceptance'],
} as const;

export const account_unification_account_controllerSchema = {
  description: '',
  properties: {
    fees: {
      $ref: '#/components/schemas/account_unification_account_controller_fees',
    },
    is_controller: {
      description: `\`true\` if the Connect application retrieving the resource controls the account and can therefore exercise [platform controls](https://stripe.com/docs/connect/platform-controls-for-standard-accounts). Otherwise, this field is null.`,
      type: 'boolean',
    },
    losses: {
      $ref: '#/components/schemas/account_unification_account_controller_losses',
    },
    requirement_collection: {
      description:
        'A value indicating responsibility for collecting requirements on this account. Only returned when the Connect application retrieving the resource controls the account.',
      enum: ['application', 'stripe'],
      type: 'string',
    },
    stripe_dashboard: {
      $ref: '#/components/schemas/account_unification_account_controller_stripe_dashboard',
    },
    type: {
      description:
        'The controller type. Can be `application`, if a Connect application controls the account, or `account`, if the account controls itself.',
      enum: ['account', 'application'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'AccountUnificationAccountController',
  type: 'object',
  'x-expandableFields': ['fees', 'losses', 'stripe_dashboard'],
} as const;

export const account_unification_account_controller_feesSchema = {
  description: '',
  properties: {
    payer: {
      description:
        'A value indicating the responsible payer of a bundle of Stripe fees for pricing-control eligible products on this account. Learn more about [fee behavior on connected accounts](https://docs.stripe.com/connect/direct-charges-fee-payer-behavior).',
      enum: ['account', 'application', 'application_custom', 'application_express'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['payer'],
  title: 'AccountUnificationAccountControllerFees',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_unification_account_controller_lossesSchema = {
  description: '',
  properties: {
    payments: {
      description: "A value indicating who is liable when this account can't pay back negative balances from payments.",
      enum: ['application', 'stripe'],
      type: 'string',
    },
  },
  required: ['payments'],
  title: 'AccountUnificationAccountControllerLosses',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const account_unification_account_controller_stripe_dashboardSchema = {
  description: '',
  properties: {
    type: {
      description:
        'A value indicating the Stripe dashboard this account has access to independent of the Connect application.',
      enum: ['express', 'full', 'none'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'AccountUnificationAccountControllerStripeDashboard',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const addressSchema = {
  description: '',
  properties: {
    city: {
      description: 'City, district, suburb, town, or village.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    line1: {
      description: 'Address line 1 (e.g., street, PO Box, or company name).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    line2: {
      description: 'Address line 2 (e.g., apartment, suite, unit, or building).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description: 'ZIP or postal code.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    state: {
      description: 'State, county, province, or region.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'Address',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const api_errorsSchema = {
  description: '',
  properties: {
    charge: {
      description: 'For card errors, the ID of the failed charge.',
      maxLength: 5000,
      type: 'string',
    },
    code: {
      description:
        'For some errors that could be handled programmatically, a short string indicating the [error code](https://stripe.com/docs/error-codes) reported.',
      maxLength: 5000,
      type: 'string',
    },
    decline_code: {
      description:
        "For card errors resulting from a card issuer decline, a short string indicating the [card issuer's reason for the decline](https://stripe.com/docs/declines#issuer-declines) if they provide one.",
      maxLength: 5000,
      type: 'string',
    },
    doc_url: {
      description: 'A URL to more information about the [error code](https://stripe.com/docs/error-codes) reported.',
      maxLength: 5000,
      type: 'string',
    },
    message: {
      description:
        'A human-readable message providing more details about the error. For card errors, these messages can be shown to your users.',
      maxLength: 40000,
      type: 'string',
    },
    param: {
      description:
        'If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field.',
      maxLength: 5000,
      type: 'string',
    },
    payment_intent: {
      $ref: '#/components/schemas/payment_intent',
    },
    payment_method: {
      $ref: '#/components/schemas/payment_method',
    },
    payment_method_type: {
      description:
        'If the error is specific to the type of payment method, the payment method type that had a problem. This field is only populated for invoice-related errors.',
      maxLength: 5000,
      type: 'string',
    },
    request_log_url: {
      description: 'A URL to the request log entry in your dashboard.',
      maxLength: 5000,
      type: 'string',
    },
    setup_intent: {
      $ref: '#/components/schemas/setup_intent',
    },
    source: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_account',
        },
        {
          $ref: '#/components/schemas/card',
        },
        {
          $ref: '#/components/schemas/source',
        },
      ],
      description:
        'The [source object](https://stripe.com/docs/api/sources/object) for errors returned on a request involving a source.',
    },
    type: {
      description:
        'The type of error returned. One of `api_error`, `card_error`, `idempotency_error`, or `invalid_request_error`',
      enum: ['api_error', 'card_error', 'idempotency_error', 'invalid_request_error'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'APIErrors',
  type: 'object',
  'x-expandableFields': ['payment_intent', 'payment_method', 'setup_intent', 'source'],
} as const;

export const apple_pay_domainSchema = {
  description: '',
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    domain_name: {
      maxLength: 5000,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['apple_pay_domain'],
      type: 'string',
    },
  },
  required: ['created', 'domain_name', 'id', 'livemode', 'object'],
  title: 'ApplePayDomain',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'apple_pay_domain',
} as const;

export const applicationSchema = {
  description: '',
  properties: {
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    name: {
      description: 'The name of the application.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['application'],
      type: 'string',
    },
  },
  required: ['id', 'object'],
  title: 'Application',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const application_feeSchema = {
  description: '',
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'ID of the Stripe account this fee was taken from.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    amount: {
      description: 'Amount earned, in cents (or local equivalent).',
      type: 'integer',
    },
    amount_refunded: {
      description:
        'Amount in cents (or local equivalent) refunded (can be less than the amount attribute on the fee if a partial refund was issued)',
      type: 'integer',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
      ],
      description: 'ID of the Connect application that earned the fee.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
        ],
      },
    },
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'Balance transaction that describes the impact of this collected application fee on your account balance (not including refunds).',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    charge: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/charge',
        },
      ],
      description: 'ID of the charge that the application fee was taken from.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/charge',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    fee_source: {
      anyOf: [
        {
          $ref: '#/components/schemas/platform_earning_fee_source',
        },
      ],
      description:
        'Polymorphic source of the application fee. Includes the ID of the object the application fee was created from.',
      nullable: true,
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['application_fee'],
      type: 'string',
    },
    originating_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/charge',
        },
      ],
      description:
        'ID of the corresponding charge on the platform account, if this fee was the result of a charge using the `destination` parameter.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/charge',
          },
        ],
      },
    },
    refunded: {
      description:
        'Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute will still be false.',
      type: 'boolean',
    },
    refunds: {
      description: 'A list of refunds that have been applied to the fee.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/fee_refund',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'FeeRefundList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
  },
  required: [
    'account',
    'amount',
    'amount_refunded',
    'application',
    'charge',
    'created',
    'currency',
    'id',
    'livemode',
    'object',
    'refunded',
    'refunds',
  ],
  title: 'PlatformFee',
  type: 'object',
  'x-expandableFields': [
    'account',
    'application',
    'balance_transaction',
    'charge',
    'fee_source',
    'originating_transaction',
    'refunds',
  ],
  'x-resourceId': 'application_fee',
} as const;

export const apps_secretSchema = {
  description: `Secret Store is an API that allows Stripe Apps developers to securely persist secrets for use by UI Extensions and app backends.

The primary resource in Secret Store is a \`secret\`. Other apps can't view secrets created by an app. Additionally, secrets are scoped to provide further permission control.

All Dashboard users and the app backend share \`account\` scoped secrets. Use the \`account\` scope for secrets that don't change per-user, like a third-party API key.

A \`user\` scoped secret is accessible by the app backend and one specific Dashboard user. Use the \`user\` scope for per-user secrets like per-user OAuth tokens, where different users might have different permissions.

Related guide: [Store data between page reloads](https://stripe.com/docs/stripe-apps/store-auth-data-custom-objects)`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    deleted: {
      description: 'If true, indicates that this secret has been deleted',
      type: 'boolean',
    },
    expires_at: {
      description: 'The Unix timestamp for the expiry time of the secret, after which the secret deletes.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    name: {
      description: "A name for the secret that's unique within the scope.",
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['apps.secret'],
      type: 'string',
    },
    payload: {
      description: 'The plaintext secret value to be stored.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    scope: {
      $ref: '#/components/schemas/secret_service_resource_scope',
    },
  },
  required: ['created', 'id', 'livemode', 'name', 'object', 'scope'],
  title: 'SecretServiceResourceSecret',
  type: 'object',
  'x-expandableFields': ['scope'],
  'x-resourceId': 'apps.secret',
} as const;

export const automatic_taxSchema = {
  description: '',
  properties: {
    enabled: {
      description:
        'Whether Stripe automatically computes tax on this invoice. Note that incompatible invoice items (invoice items with manually specified [tax rates](https://stripe.com/docs/api/tax_rates), negative amounts, or `tax_behavior=unspecified`) cannot be added to automatic tax invoices.',
      type: 'boolean',
    },
    liability: {
      anyOf: [
        {
          $ref: '#/components/schemas/connect_account_reference',
        },
      ],
      description:
        "The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.",
      nullable: true,
    },
    status: {
      description: 'The status of the most recent automated tax calculation for this invoice.',
      enum: ['complete', 'failed', 'requires_location_inputs'],
      nullable: true,
      type: 'string',
    },
  },
  required: ['enabled'],
  title: 'AutomaticTax',
  type: 'object',
  'x-expandableFields': ['liability'],
} as const;

export const balanceSchema = {
  description: `This is an object representing your Stripe balance. You can retrieve it to see
the balance currently on your Stripe account.

You can also retrieve the balance history, which contains a list of
[transactions](https://stripe.com/docs/reporting/balance-transaction-types) that contributed to the balance
(charges, payouts, and so forth).

The available and pending amounts for each currency are broken down further by
payment source types.

Related guide: [Understanding Connect account balances](https://stripe.com/docs/connect/account-balances)`,
  properties: {
    available: {
      description:
        'Available funds that you can transfer or pay out automatically by Stripe or explicitly through the [Transfers API](https://stripe.com/docs/api#transfers) or [Payouts API](https://stripe.com/docs/api#payouts). You can find the available balance for each currency and payment type in the `source_types` property.',
      items: {
        $ref: '#/components/schemas/balance_amount',
      },
      type: 'array',
    },
    connect_reserved: {
      description:
        'Funds held due to negative balances on connected accounts where [account.controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts. You can find the connect reserve balance for each currency and payment type in the `source_types` property.',
      items: {
        $ref: '#/components/schemas/balance_amount',
      },
      type: 'array',
    },
    instant_available: {
      description: 'Funds that you can pay out using Instant Payouts.',
      items: {
        $ref: '#/components/schemas/balance_amount_net',
      },
      type: 'array',
    },
    issuing: {
      $ref: '#/components/schemas/balance_detail',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['balance'],
      type: 'string',
    },
    pending: {
      description:
        "Funds that aren't available in the balance yet. You can find the pending balance for each currency and each payment type in the `source_types` property.",
      items: {
        $ref: '#/components/schemas/balance_amount',
      },
      type: 'array',
    },
  },
  required: ['available', 'livemode', 'object', 'pending'],
  title: 'Balance',
  type: 'object',
  'x-expandableFields': ['available', 'connect_reserved', 'instant_available', 'issuing', 'pending'],
  'x-resourceId': 'balance',
} as const;

export const balance_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Balance amount.',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    source_types: {
      $ref: '#/components/schemas/balance_amount_by_source_type',
    },
  },
  required: ['amount', 'currency'],
  title: 'BalanceAmount',
  type: 'object',
  'x-expandableFields': ['source_types'],
} as const;

export const balance_amount_by_source_typeSchema = {
  description: '',
  properties: {
    bank_account: {
      description: 'Amount for bank account.',
      type: 'integer',
    },
    card: {
      description: 'Amount for card.',
      type: 'integer',
    },
    fpx: {
      description: 'Amount for FPX.',
      type: 'integer',
    },
  },
  title: 'BalanceAmountBySourceType',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const balance_amount_netSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Balance amount.',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    net_available: {
      description: 'Breakdown of balance by destination.',
      items: {
        $ref: '#/components/schemas/balance_net_available',
      },
      type: 'array',
    },
    source_types: {
      $ref: '#/components/schemas/balance_amount_by_source_type',
    },
  },
  required: ['amount', 'currency'],
  title: 'BalanceAmountNet',
  type: 'object',
  'x-expandableFields': ['net_available', 'source_types'],
} as const;

export const balance_detailSchema = {
  description: '',
  properties: {
    available: {
      description: 'Funds that are available for use.',
      items: {
        $ref: '#/components/schemas/balance_amount',
      },
      type: 'array',
    },
  },
  required: ['available'],
  title: 'BalanceDetail',
  type: 'object',
  'x-expandableFields': ['available'],
} as const;

export const balance_net_availableSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Net balance amount, subtracting fees from platform-set pricing.',
      type: 'integer',
    },
    destination: {
      description: 'ID of the external account for this net balance (not expandable).',
      maxLength: 5000,
      type: 'string',
    },
    source_types: {
      $ref: '#/components/schemas/balance_amount_by_source_type',
    },
  },
  required: ['amount', 'destination'],
  title: 'BalanceNetAvailable',
  type: 'object',
  'x-expandableFields': ['source_types'],
} as const;

export const balance_transactionSchema = {
  description: `Balance transactions represent funds moving through your Stripe account.
Stripe creates them for every type of transaction that enters or leaves your Stripe account balance.

Related guide: [Balance transaction types](https://stripe.com/docs/reports/balance-transaction-types)`,
  properties: {
    amount: {
      description:
        'Gross amount of this transaction (in cents (or local equivalent)). A positive value represents funds charged to another party, and a negative value represents funds sent to another party.',
      type: 'integer',
    },
    available_on: {
      description: "The date that the transaction's net funds become available in the Stripe balance.",
      format: 'unix-time',
      type: 'integer',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exchange_rate: {
      description:
        "If applicable, this transaction uses an exchange rate. If money converts from currency A to currency B, then the `amount` in currency A, multipled by the `exchange_rate`, equals the `amount` in currency B. For example, if you charge a customer 10.00 EUR, the PaymentIntent's `amount` is `1000` and `currency` is `eur`. If this converts to 12.34 USD in your Stripe account, the BalanceTransaction's `amount` is `1234`, its `currency` is `usd`, and the `exchange_rate` is `1.234`.",
      nullable: true,
      type: 'number',
    },
    fee: {
      description:
        'Fees (in cents (or local equivalent)) paid for this transaction. Represented as a positive integer when assessed.',
      type: 'integer',
    },
    fee_details: {
      description: 'Detailed breakdown of fees (in cents (or local equivalent)) paid for this transaction.',
      items: {
        $ref: '#/components/schemas/fee',
      },
      type: 'array',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    net: {
      description:
        'Net impact to a Stripe balance (in cents (or local equivalent)). A positive value represents incrementing a Stripe balance, and a negative value decrementing a Stripe balance. You can calculate the net impact of a transaction on a balance by `amount` - `fee`',
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['balance_transaction'],
      type: 'string',
    },
    reporting_category: {
      description:
        'Learn more about how [reporting categories](https://stripe.com/docs/reports/reporting-categories) can help you understand balance transactions from an accounting perspective.',
      maxLength: 5000,
      type: 'string',
    },
    source: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application_fee',
        },
        {
          $ref: '#/components/schemas/charge',
        },
        {
          $ref: '#/components/schemas/connect_collection_transfer',
        },
        {
          $ref: '#/components/schemas/customer_cash_balance_transaction',
        },
        {
          $ref: '#/components/schemas/dispute',
        },
        {
          $ref: '#/components/schemas/fee_refund',
        },
        {
          $ref: '#/components/schemas/issuing.authorization',
        },
        {
          $ref: '#/components/schemas/issuing.dispute',
        },
        {
          $ref: '#/components/schemas/issuing.transaction',
        },
        {
          $ref: '#/components/schemas/payout',
        },
        {
          $ref: '#/components/schemas/refund',
        },
        {
          $ref: '#/components/schemas/reserve_transaction',
        },
        {
          $ref: '#/components/schemas/tax_deducted_at_source',
        },
        {
          $ref: '#/components/schemas/topup',
        },
        {
          $ref: '#/components/schemas/transfer',
        },
        {
          $ref: '#/components/schemas/transfer_reversal',
        },
      ],
      description: 'This transaction relates to the Stripe object.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application_fee',
          },
          {
            $ref: '#/components/schemas/charge',
          },
          {
            $ref: '#/components/schemas/connect_collection_transfer',
          },
          {
            $ref: '#/components/schemas/customer_cash_balance_transaction',
          },
          {
            $ref: '#/components/schemas/dispute',
          },
          {
            $ref: '#/components/schemas/fee_refund',
          },
          {
            $ref: '#/components/schemas/issuing.authorization',
          },
          {
            $ref: '#/components/schemas/issuing.dispute',
          },
          {
            $ref: '#/components/schemas/issuing.transaction',
          },
          {
            $ref: '#/components/schemas/payout',
          },
          {
            $ref: '#/components/schemas/refund',
          },
          {
            $ref: '#/components/schemas/reserve_transaction',
          },
          {
            $ref: '#/components/schemas/tax_deducted_at_source',
          },
          {
            $ref: '#/components/schemas/topup',
          },
          {
            $ref: '#/components/schemas/transfer',
          },
          {
            $ref: '#/components/schemas/transfer_reversal',
          },
        ],
      },
      'x-stripeBypassValidation': true,
    },
    status: {
      description:
        "The transaction's net funds status in the Stripe balance, which are either `available` or `pending`.",
      maxLength: 5000,
      type: 'string',
    },
    type: {
      description:
        'Transaction type: `adjustment`, `advance`, `advance_funding`, `anticipation_repayment`, `application_fee`, `application_fee_refund`, `charge`, `climate_order_purchase`, `climate_order_refund`, `connect_collection_transfer`, `contribution`, `issuing_authorization_hold`, `issuing_authorization_release`, `issuing_dispute`, `issuing_transaction`, `obligation_outbound`, `obligation_reversal_inbound`, `payment`, `payment_failure_refund`, `payment_network_reserve_hold`, `payment_network_reserve_release`, `payment_refund`, `payment_reversal`, `payment_unreconciled`, `payout`, `payout_cancel`, `payout_failure`, `refund`, `refund_failure`, `reserve_transaction`, `reserved_funds`, `stripe_fee`, `stripe_fx_fee`, `tax_fee`, `topup`, `topup_reversal`, `transfer`, `transfer_cancel`, `transfer_failure`, or `transfer_refund`. Learn more about [balance transaction types and what they represent](https://stripe.com/docs/reports/balance-transaction-types). To classify transactions for accounting purposes, consider `reporting_category` instead.',
      enum: [
        'adjustment',
        'advance',
        'advance_funding',
        'anticipation_repayment',
        'application_fee',
        'application_fee_refund',
        'charge',
        'climate_order_purchase',
        'climate_order_refund',
        'connect_collection_transfer',
        'contribution',
        'issuing_authorization_hold',
        'issuing_authorization_release',
        'issuing_dispute',
        'issuing_transaction',
        'obligation_outbound',
        'obligation_reversal_inbound',
        'payment',
        'payment_failure_refund',
        'payment_network_reserve_hold',
        'payment_network_reserve_release',
        'payment_refund',
        'payment_reversal',
        'payment_unreconciled',
        'payout',
        'payout_cancel',
        'payout_failure',
        'refund',
        'refund_failure',
        'reserve_transaction',
        'reserved_funds',
        'stripe_fee',
        'stripe_fx_fee',
        'tax_fee',
        'topup',
        'topup_reversal',
        'transfer',
        'transfer_cancel',
        'transfer_failure',
        'transfer_refund',
      ],
      type: 'string',
    },
  },
  required: [
    'amount',
    'available_on',
    'created',
    'currency',
    'fee',
    'fee_details',
    'id',
    'net',
    'object',
    'reporting_category',
    'status',
    'type',
  ],
  title: 'BalanceTransaction',
  type: 'object',
  'x-expandableFields': ['fee_details', 'source'],
  'x-resourceId': 'balance_transaction',
} as const;

export const bank_accountSchema = {
  description: `These bank accounts are payment methods on \`Customer\` objects.

On the other hand [External Accounts](/api#external_accounts) are transfer
destinations on \`Account\` objects for connected accounts.
They can be bank accounts or debit cards as well, and are documented in the links above.

Related guide: [Bank debits and transfers](/payments/bank-debits-transfers)`,
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'The ID of the account that the bank account is associated with.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    account_holder_name: {
      description: 'The name of the person or business that owns the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_holder_type: {
      description: 'The type of entity that holds the account. This can be either `individual` or `company`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_type: {
      description:
        'The bank account type. This can only be `checking` or `savings` in most countries. In Japan, this can only be `futsu` or `toza`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    available_payout_methods: {
      description:
        'A set of available payout methods for this bank account. Only values from this set should be passed as the `method` when creating a payout.',
      items: {
        enum: ['instant', 'standard'],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    bank_name: {
      description: 'Name of the bank associated with the routing number (e.g., `WELLS FARGO`).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country the bank account is located in.',
      maxLength: 5000,
      type: 'string',
    },
    currency: {
      description:
        'Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'The ID of the customer that the bank account is associated with.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    default_for_currency: {
      description: 'Whether this bank account is the default external account for its currency.',
      nullable: true,
      type: 'boolean',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    future_requirements: {
      anyOf: [
        {
          $ref: '#/components/schemas/external_account_requirements',
        },
      ],
      description:
        'Information about the [upcoming new requirements for the bank account](https://stripe.com/docs/connect/custom-accounts/future-requirements), including what information needs to be collected, and by when.',
      nullable: true,
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the bank account number.',
      maxLength: 5000,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['bank_account'],
      type: 'string',
    },
    requirements: {
      anyOf: [
        {
          $ref: '#/components/schemas/external_account_requirements',
        },
      ],
      description:
        'Information about the requirements for the bank account, including what information needs to be collected.',
      nullable: true,
    },
    routing_number: {
      description: 'The routing transit number for the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: `For bank accounts, possible values are \`new\`, \`validated\`, \`verified\`, \`verification_failed\`, or \`errored\`. A bank account that hasn't had any activity or validation performed is \`new\`. If Stripe can determine that the bank account exists, its status will be \`validated\`. Note that there often isn’t enough information to know (e.g., for smaller credit unions), and the validation is not always run. If customer bank account verification has succeeded, the bank account status will be \`verified\`. If the verification failed for any reason, such as microdeposit failure, the status will be \`verification_failed\`. If a payout sent to this bank account fails, we'll set the status to \`errored\` and will not continue to send [scheduled payouts](https://stripe.com/docs/payouts#payout-schedule) until the bank details are updated.

For external accounts, possible values are \`new\`, \`errored\` and \`verification_failed\`. If a payout fails, the status is set to \`errored\` and scheduled payouts are stopped until account details are updated. In the US and India, if we can't [verify the owner of the bank account](https://support.stripe.com/questions/bank-account-ownership-verification), we'll set the status to \`verification_failed\`. Other validations aren't run against external accounts because they're only used for payouts. This means the other statuses don't apply.`,
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['country', 'currency', 'id', 'last4', 'object', 'status'],
  title: 'BankAccount',
  type: 'object',
  'x-expandableFields': ['account', 'customer', 'future_requirements', 'requirements'],
  'x-resourceId': 'bank_account',
} as const;

export const bank_connections_resource_accountholderSchema = {
  description: '',
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The ID of the Stripe account this account belongs to. Should only be present if `account_holder.type` is `account`.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
      ],
      description:
        'ID of the Stripe customer this account belongs to. Present if and only if `account_holder.type` is `customer`.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
        ],
      },
    },
    type: {
      description: 'Type of account holder that this account belongs to.',
      enum: ['account', 'customer'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'BankConnectionsResourceAccountholder',
  type: 'object',
  'x-expandableFields': ['account', 'customer'],
} as const;

export const bank_connections_resource_balanceSchema = {
  description: '',
  properties: {
    as_of: {
      description:
        'The time that the external institution calculated this balance. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    cash: {
      $ref: '#/components/schemas/bank_connections_resource_balance_api_resource_cash_balance',
    },
    credit: {
      $ref: '#/components/schemas/bank_connections_resource_balance_api_resource_credit_balance',
    },
    current: {
      additionalProperties: {
        type: 'integer',
      },
      description: `The balances owed to (or by) the account holder.

Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.

Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.`,
      type: 'object',
    },
    type: {
      description:
        'The `type` of the balance. An additional hash is included on the balance with a name matching this value.',
      enum: ['cash', 'credit'],
      type: 'string',
    },
  },
  required: ['as_of', 'current', 'type'],
  title: 'BankConnectionsResourceBalance',
  type: 'object',
  'x-expandableFields': ['cash', 'credit'],
} as const;

export const bank_connections_resource_balance_api_resource_cash_balanceSchema = {
  description: '',
  properties: {
    available: {
      additionalProperties: {
        type: 'integer',
      },
      description: `The funds available to the account holder. Typically this is the current balance less any holds.

Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.

Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.`,
      nullable: true,
      type: 'object',
    },
  },
  title: 'BankConnectionsResourceBalanceAPIResourceCashBalance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_balance_api_resource_credit_balanceSchema = {
  description: '',
  properties: {
    used: {
      additionalProperties: {
        type: 'integer',
      },
      description: `The credit that has been used by the account holder.

Each key is a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase.

Each value is a integer amount. A positive amount indicates money owed to the account holder. A negative amount indicates money owed by the account holder.`,
      nullable: true,
      type: 'object',
    },
  },
  title: 'BankConnectionsResourceBalanceAPIResourceCreditBalance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_balance_refreshSchema = {
  description: '',
  properties: {
    last_attempted_at: {
      description:
        'The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    next_refresh_available_at: {
      description:
        'Time at which the next balance refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    status: {
      description: 'The status of the last refresh attempt.',
      enum: ['failed', 'pending', 'succeeded'],
      type: 'string',
    },
  },
  required: ['last_attempted_at', 'status'],
  title: 'BankConnectionsResourceBalanceRefresh',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_link_account_session_filtersSchema = {
  description: '',
  properties: {
    countries: {
      description: 'List of countries from which to filter accounts.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'BankConnectionsResourceLinkAccountSessionFilters',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_ownership_refreshSchema = {
  description: '',
  properties: {
    last_attempted_at: {
      description:
        'The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    next_refresh_available_at: {
      description:
        'Time at which the next ownership refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    status: {
      description: 'The status of the last refresh attempt.',
      enum: ['failed', 'pending', 'succeeded'],
      type: 'string',
    },
  },
  required: ['last_attempted_at', 'status'],
  title: 'BankConnectionsResourceOwnershipRefresh',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_transaction_refreshSchema = {
  description: '',
  properties: {
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last_attempted_at: {
      description:
        'The time at which the last refresh attempt was initiated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    next_refresh_available_at: {
      description:
        'Time at which the next transaction refresh can be initiated. This value will be `null` when `status` is `pending`. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    status: {
      description: 'The status of the last refresh attempt.',
      enum: ['failed', 'pending', 'succeeded'],
      type: 'string',
    },
  },
  required: ['id', 'last_attempted_at', 'status'],
  title: 'BankConnectionsResourceTransactionRefresh',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const bank_connections_resource_transaction_resource_status_transitionsSchema = {
  description: '',
  properties: {
    posted_at: {
      description: 'Time at which this transaction posted. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    void_at: {
      description: 'Time at which this transaction was voided. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'BankConnectionsResourceTransactionResourceStatusTransitions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_meterSchema = {
  description:
    'A billing meter is a resource that allows you to track usage of a particular event. For example, you might create a billing meter to track the number of API calls made by a particular user. You can then attach the billing meter to a price and attach the price to a subscription to charge the user for the number of API calls they make.',
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    customer_mapping: {
      $ref: '#/components/schemas/billing_meter_resource_customer_mapping_settings',
    },
    default_aggregation: {
      $ref: '#/components/schemas/billing_meter_resource_aggregation_settings',
    },
    display_name: {
      description: "The meter's name.",
      maxLength: 5000,
      type: 'string',
    },
    event_name: {
      description:
        'The name of the meter event to record usage for. Corresponds with the `event_name` field on meter events.',
      maxLength: 5000,
      type: 'string',
    },
    event_time_window: {
      description: 'The time window to pre-aggregate meter events for, if any.',
      enum: ['day', 'hour'],
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing.meter'],
      type: 'string',
    },
    status: {
      description: "The meter's status.",
      enum: ['active', 'inactive'],
      type: 'string',
    },
    status_transitions: {
      $ref: '#/components/schemas/billing_meter_resource_billing_meter_status_transitions',
    },
    updated: {
      description: 'Time at which the object was last updated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    value_settings: {
      $ref: '#/components/schemas/billing_meter_resource_billing_meter_value',
    },
  },
  required: [
    'created',
    'customer_mapping',
    'default_aggregation',
    'display_name',
    'event_name',
    'id',
    'livemode',
    'object',
    'status',
    'status_transitions',
    'updated',
    'value_settings',
  ],
  title: 'BillingMeter',
  type: 'object',
  'x-expandableFields': ['customer_mapping', 'default_aggregation', 'status_transitions', 'value_settings'],
  'x-resourceId': 'billing.meter',
} as const;

export const billing_meter_eventSchema = {
  description: `A billing meter event represents a customer's usage of a product. Meter events are used to bill a customer based on their usage.
Meter events are associated with billing meters, which define the shape of the event's payload and how those events are aggregated for billing.`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    event_name: {
      description: 'The name of the meter event. Corresponds with the `event_name` field on a meter.',
      maxLength: 100,
      type: 'string',
    },
    identifier: {
      description: 'A unique identifier for the event.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing.meter_event'],
      type: 'string',
    },
    payload: {
      additionalProperties: {
        maxLength: 100,
        type: 'string',
      },
      description:
        "The payload of the event. This contains the fields corresponding to a meter's `customer_mapping.event_payload_key` (default is `stripe_customer_id`) and `value_settings.event_payload_key` (default is `value`). Read more about the [payload](https://stripe.com/docs/billing/subscriptions/usage-based/recording-usage#payload-key-overrides).",
      type: 'object',
    },
    timestamp: {
      description: 'The timestamp passed in when creating the event. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
  },
  required: ['created', 'event_name', 'identifier', 'livemode', 'object', 'payload', 'timestamp'],
  title: 'BillingMeterEvent',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'billing.meter_event',
} as const;

export const billing_meter_event_adjustmentSchema = {
  description:
    'A billing meter event adjustment is a resource that allows you to cancel a meter event. For example, you might create a billing meter event adjustment to cancel a meter event that was created in error or attached to the wrong customer.',
  properties: {
    cancel: {
      anyOf: [
        {
          $ref: '#/components/schemas/billing_meter_resource_billing_meter_event_adjustment_cancel',
        },
      ],
      description: 'Specifies which event to cancel.',
      nullable: true,
    },
    event_name: {
      description: 'The name of the meter event. Corresponds with the `event_name` field on a meter.',
      maxLength: 100,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing.meter_event_adjustment'],
      type: 'string',
    },
    status: {
      description: "The meter event adjustment's status.",
      enum: ['complete', 'pending'],
      type: 'string',
    },
    type: {
      description:
        'Specifies whether to cancel a single event or a range of events for a time period. Time period cancellation is not supported yet.',
      enum: ['cancel'],
      type: 'string',
    },
  },
  required: ['event_name', 'livemode', 'object', 'status', 'type'],
  title: 'BillingMeterEventAdjustment',
  type: 'object',
  'x-expandableFields': ['cancel'],
  'x-resourceId': 'billing.meter_event_adjustment',
} as const;

export const billing_meter_event_summarySchema = {
  description: `A billing meter event summary represents an aggregated view of a customer's billing meter events within a specified timeframe. It indicates how much
usage was accrued by a customer for that period.`,
  properties: {
    aggregated_value: {
      description:
        'Aggregated value of all the events within `start_time` (inclusive) and `end_time` (inclusive). The aggregation strategy is defined on meter via `default_aggregation`.',
      type: 'number',
    },
    end_time: {
      description: 'End timestamp for this event summary (inclusive).',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    meter: {
      description: 'The meter associated with this event summary.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing.meter_event_summary'],
      type: 'string',
    },
    start_time: {
      description: 'Start timestamp for this event summary (inclusive).',
      format: 'unix-time',
      type: 'integer',
    },
  },
  required: ['aggregated_value', 'end_time', 'id', 'livemode', 'meter', 'object', 'start_time'],
  title: 'BillingMeterEventSummary',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'billing.meter_event_summary',
} as const;

export const billing_detailsSchema = {
  description: '',
  properties: {
    address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description: 'Billing address.',
      nullable: true,
    },
    email: {
      description: 'Email address.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'Full name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    phone: {
      description: 'Billing phone number (including extension).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'billing_details',
  type: 'object',
  'x-expandableFields': ['address'],
} as const;

export const billing_meter_resource_aggregation_settingsSchema = {
  description: '',
  properties: {
    formula: {
      description: 'Specifies how events are aggregated.',
      enum: ['count', 'sum'],
      type: 'string',
    },
  },
  required: ['formula'],
  title: 'BillingMeterResourceAggregationSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_meter_resource_billing_meter_event_adjustment_cancelSchema = {
  description: '',
  properties: {
    identifier: {
      description: 'Unique identifier for the event.',
      maxLength: 100,
      nullable: true,
      type: 'string',
    },
  },
  title: 'BillingMeterResourceBillingMeterEventAdjustmentCancel',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_meter_resource_billing_meter_status_transitionsSchema = {
  description: '',
  properties: {
    deactivated_at: {
      description: 'The time the meter was deactivated, if any. Measured in seconds since Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'BillingMeterResourceBillingMeterStatusTransitions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_meter_resource_billing_meter_valueSchema = {
  description: '',
  properties: {
    event_payload_key: {
      description: 'The key in the meter event payload to use as the value for this meter.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['event_payload_key'],
  title: 'BillingMeterResourceBillingMeterValue',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_meter_resource_customer_mapping_settingsSchema = {
  description: '',
  properties: {
    event_payload_key: {
      description: 'The key in the meter event payload to use for mapping the event to a customer.',
      maxLength: 5000,
      type: 'string',
    },
    type: {
      description: 'The method for mapping a meter event to a customer.',
      enum: ['by_id'],
      type: 'string',
    },
  },
  required: ['event_payload_key', 'type'],
  title: 'BillingMeterResourceCustomerMappingSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const billing_portal_configurationSchema = {
  description: 'A portal configuration describes the functionality and behavior of a portal session.',
  properties: {
    active: {
      description: 'Whether the configuration is active and can be used to create portal sessions.',
      type: 'boolean',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
        {
          $ref: '#/components/schemas/deleted_application',
        },
      ],
      description: 'ID of the Connect Application that created the configuration.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
          {
            $ref: '#/components/schemas/deleted_application',
          },
        ],
      },
    },
    business_profile: {
      $ref: '#/components/schemas/portal_business_profile',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    default_return_url: {
      description:
        "The default URL to redirect customers to when they click on the portal's link to return to your website. This can be [overriden](https://stripe.com/docs/api/customer_portal/sessions/create#create_portal_session-return_url) when creating the session.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    features: {
      $ref: '#/components/schemas/portal_features',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    is_default: {
      description:
        'Whether the configuration is the default. If `true`, this configuration can be managed in the Dashboard and portal sessions will use this configuration unless it is overriden when creating the session.',
      type: 'boolean',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    login_page: {
      $ref: '#/components/schemas/portal_login_page',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing_portal.configuration'],
      type: 'string',
    },
    updated: {
      description: 'Time at which the object was last updated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
  },
  required: [
    'active',
    'business_profile',
    'created',
    'features',
    'id',
    'is_default',
    'livemode',
    'login_page',
    'object',
    'updated',
  ],
  title: 'PortalConfiguration',
  type: 'object',
  'x-expandableFields': ['application', 'business_profile', 'features', 'login_page'],
  'x-resourceId': 'billing_portal.configuration',
} as const;

export const billing_portal_sessionSchema = {
  description: `The Billing customer portal is a Stripe-hosted UI for subscription and
billing management.

A portal configuration describes the functionality and features that you
want to provide to your customers through the portal.

A portal session describes the instantiation of the customer portal for
a particular customer. By visiting the session's URL, the customer
can manage their subscriptions and billing details. For security reasons,
sessions are short-lived and will expire if the customer does not visit the URL.
Create sessions on-demand when customers intend to manage their subscriptions
and billing details.

Learn more in the [integration guide](https://stripe.com/docs/billing/subscriptions/integrating-customer-portal).`,
  properties: {
    configuration: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/billing_portal.configuration',
        },
      ],
      description: 'The configuration used by this session, describing the features available.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/billing_portal.configuration',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    customer: {
      description: 'The ID of the customer for this session.',
      maxLength: 5000,
      type: 'string',
    },
    flow: {
      anyOf: [
        {
          $ref: '#/components/schemas/portal_flows_flow',
        },
      ],
      description:
        'Information about a specific flow for the customer to go through. See the [docs](https://stripe.com/docs/customer-management/portal-deep-links) to learn more about using customer portal deep links and flows.',
      nullable: true,
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    locale: {
      description:
        'The IETF language tag of the locale Customer Portal is displayed in. If blank or auto, the customer’s `preferred_locales` or browser’s locale is used.',
      enum: [
        'auto',
        'bg',
        'cs',
        'da',
        'de',
        'el',
        'en',
        'en-AU',
        'en-CA',
        'en-GB',
        'en-IE',
        'en-IN',
        'en-NZ',
        'en-SG',
        'es',
        'es-419',
        'et',
        'fi',
        'fil',
        'fr',
        'fr-CA',
        'hr',
        'hu',
        'id',
        'it',
        'ja',
        'ko',
        'lt',
        'lv',
        'ms',
        'mt',
        'nb',
        'nl',
        'pl',
        'pt',
        'pt-BR',
        'ro',
        'ru',
        'sk',
        'sl',
        'sv',
        'th',
        'tr',
        'vi',
        'zh',
        'zh-HK',
        'zh-TW',
      ],
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['billing_portal.session'],
      type: 'string',
    },
    on_behalf_of: {
      description:
        "The account for which the session was created on behalf of. When specified, only subscriptions and invoices with this `on_behalf_of` account appear in the portal. For more information, see the [docs](https://stripe.com/docs/connect/separate-charges-and-transfers#settlement-merchant). Use the [Accounts API](https://stripe.com/docs/api/accounts/object#account_object-settings-branding) to modify the `on_behalf_of` account's branding settings, which the portal displays.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    return_url: {
      description: "The URL to redirect customers to when they click on the portal's link to return to your website.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'The short-lived URL of the session that gives customers access to the customer portal.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['configuration', 'created', 'customer', 'id', 'livemode', 'object', 'url'],
  title: 'PortalSession',
  type: 'object',
  'x-expandableFields': ['configuration', 'flow'],
  'x-resourceId': 'billing_portal.session',
} as const;

export const cancellation_detailsSchema = {
  description: '',
  properties: {
    comment: {
      description:
        'Additional comments about why the user canceled the subscription, if the subscription was canceled explicitly by the user.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    feedback: {
      description:
        'The customer submitted reason for why they canceled, if the subscription was canceled explicitly by the user.',
      enum: [
        'customer_service',
        'low_quality',
        'missing_features',
        'other',
        'switched_service',
        'too_complex',
        'too_expensive',
        'unused',
      ],
      nullable: true,
      type: 'string',
    },
    reason: {
      description: 'Why this subscription was canceled.',
      enum: ['cancellation_requested', 'payment_disputed', 'payment_failed'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'CancellationDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const capabilitySchema = {
  description: `This is an object representing a capability for a Stripe account.

Related guide: [Account capabilities](https://stripe.com/docs/connect/account-capabilities)`,
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'The account for which the capability enables functionality.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    future_requirements: {
      $ref: '#/components/schemas/account_capability_future_requirements',
    },
    id: {
      description: 'The identifier for the capability.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['capability'],
      type: 'string',
    },
    requested: {
      description: 'Whether the capability has been requested.',
      type: 'boolean',
    },
    requested_at: {
      description: 'Time at which the capability was requested. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    requirements: {
      $ref: '#/components/schemas/account_capability_requirements',
    },
    status: {
      description: 'The status of the capability. Can be `active`, `inactive`, `pending`, or `unrequested`.',
      enum: ['active', 'disabled', 'inactive', 'pending', 'unrequested'],
      type: 'string',
    },
  },
  required: ['account', 'id', 'object', 'requested', 'status'],
  title: 'AccountCapability',
  type: 'object',
  'x-expandableFields': ['account', 'future_requirements', 'requirements'],
  'x-resourceId': 'capability',
} as const;

export const cardSchema = {
  description: `You can store multiple cards on a customer in order to charge the customer
later. You can also store multiple debit cards on a recipient in order to
transfer to those cards later.

Related guide: [Card payments with Sources](https://stripe.com/docs/sources/cards)`,
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The account this card belongs to. This attribute will not be in the card object if the card belongs to a customer or recipient instead. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    address_city: {
      description: 'City/District/Suburb/Town/Village.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_country: {
      description: 'Billing address country, if provided when creating card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_line1: {
      description: 'Address line 1 (Street address/PO Box/Company name).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_line1_check: {
      description:
        'If `address_line1` was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_line2: {
      description: 'Address line 2 (Apartment/Suite/Unit/Building).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_state: {
      description: 'State/County/Province/Region.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_zip: {
      description: 'ZIP or postal code.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_zip_check: {
      description:
        'If `address_zip` was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    available_payout_methods: {
      description:
        'A set of available payout methods for this card. Only values from this set should be passed as the `method` when creating a payout.',
      items: {
        enum: ['instant', 'standard'],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    brand: {
      description:
        'Card brand. Can be `American Express`, `Diners Club`, `Discover`, `Eftpos Australia`, `JCB`, `MasterCard`, `UnionPay`, `Visa`, or `Unknown`.',
      maxLength: 5000,
      type: 'string',
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    currency: {
      description:
        'Three-letter [ISO code for currency](https://stripe.com/docs/payouts). Only applicable on accounts (not customers or recipients). The card can be used as a transfer destination for funds in this currency. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.',
      nullable: true,
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description:
        'The customer that this card belongs to. This attribute will not be in the card object if the card belongs to an account or recipient instead.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    cvc_check: {
      description:
        "If a CVC was provided, results of the check: `pass`, `fail`, `unavailable`, or `unchecked`. A result of unchecked indicates that CVC was provided but hasn't been checked yet. Checks are typically performed when attaching a card to a Customer object, or when creating a charge. For more details, see [Check if a card is valid without a charge](https://support.stripe.com/questions/check-if-a-card-is-valid-without-a-charge).",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    default_for_currency: {
      description:
        'Whether this card is the default external account for its currency. This property is only available for accounts where [controller.requirement_collection](/api/accounts/object#account_object-controller-requirement_collection) is `application`, which includes Custom accounts.',
      nullable: true,
      type: 'boolean',
    },
    dynamic_last4: {
      description: '(For tokenized numbers only.) The last four digits of the device account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    name: {
      description: 'Cardholder name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    networks: {
      $ref: '#/components/schemas/token_card_networks',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['card'],
      type: 'string',
    },
    status: {
      description:
        'For external accounts that are cards, possible values are `new` and `errored`. If a payout fails, the status is set to `errored` and [scheduled payouts](https://stripe.com/docs/payouts#payout-schedule) are stopped until account details are updated.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    tokenization_method: {
      description:
        'If the card number is tokenized, this is the method that was used. Can be `android_pay` (includes Google Pay), `apple_pay`, `masterpass`, `visa_checkout`, or null.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['brand', 'exp_month', 'exp_year', 'funding', 'id', 'last4', 'object'],
  title: 'Card',
  type: 'object',
  'x-expandableFields': ['account', 'customer', 'networks'],
  'x-resourceId': 'card',
} as const;

export const card_generated_from_payment_method_detailsSchema = {
  description: '',
  properties: {
    card_present: {
      $ref: '#/components/schemas/payment_method_details_card_present',
    },
    type: {
      description:
        'The type of payment method transaction-specific details from the transaction that generated this `card` payment method. Always `card_present`.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['type'],
  title: 'card_generated_from_payment_method_details',
  type: 'object',
  'x-expandableFields': ['card_present'],
} as const;

export const card_issuing_account_terms_of_serviceSchema = {
  description: '',
  properties: {
    date: {
      description: 'The Unix timestamp marking when the account representative accepted the service agreement.',
      nullable: true,
      type: 'integer',
    },
    ip: {
      description: 'The IP address from which the account representative accepted the service agreement.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description:
        'The user agent of the browser from which the account representative accepted the service agreement.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'CardIssuingAccountTermsOfService',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const card_mandate_payment_method_detailsSchema = {
  description: '',
  properties: {},
  title: 'card_mandate_payment_method_details',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const cash_balanceSchema = {
  description:
    "A customer's `Cash balance` represents real funds. Customers can add funds to their cash balance by sending a bank transfer. These funds can be used for payment and can eventually be paid out to your bank account.",
  properties: {
    available: {
      additionalProperties: {
        type: 'integer',
      },
      description:
        'A hash of all cash balances available to this customer. You cannot delete a customer with any cash balances, even if the balance is 0. Amounts are represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      nullable: true,
      type: 'object',
    },
    customer: {
      description: 'The ID of the customer whose cash balance this object represents.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['cash_balance'],
      type: 'string',
    },
    settings: {
      $ref: '#/components/schemas/customer_balance_customer_balance_settings',
    },
  },
  required: ['customer', 'livemode', 'object', 'settings'],
  title: 'cash_balance',
  type: 'object',
  'x-expandableFields': ['settings'],
  'x-resourceId': 'cash_balance',
} as const;

export const chargeSchema = {
  description: `The \`Charge\` object represents a single attempt to move money into your Stripe account.
PaymentIntent confirmation is the most common way to create Charges, but transferring
money to a different Stripe account through Connect also creates Charges.
Some legacy payment flows create Charges directly, which is not recommended for new integrations.`,
  properties: {
    amount: {
      description:
        'Amount intended to be collected by this payment. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).',
      type: 'integer',
    },
    amount_captured: {
      description:
        'Amount in cents (or local equivalent) captured (can be less than the amount attribute on the charge if a partial capture was made).',
      type: 'integer',
    },
    amount_refunded: {
      description:
        'Amount in cents (or local equivalent) refunded (can be less than the amount attribute on the charge if a partial refund was issued).',
      type: 'integer',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
      ],
      description: 'ID of the Connect application that created the charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
        ],
      },
    },
    application_fee: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application_fee',
        },
      ],
      description:
        'The application fee (if any) for the charge. [See the Connect documentation](https://stripe.com/docs/connect/direct-charges#collect-fees) for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application_fee',
          },
        ],
      },
    },
    application_fee_amount: {
      description:
        'The amount of the application fee (if any) requested for the charge. [See the Connect documentation](https://stripe.com/docs/connect/direct-charges#collect-fees) for details.',
      nullable: true,
      type: 'integer',
    },
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'ID of the balance transaction that describes the impact of this charge on your account balance (not including refunds or disputes).',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    billing_details: {
      $ref: '#/components/schemas/billing_details',
    },
    calculated_statement_descriptor: {
      description:
        "The full statement descriptor that is passed to card networks, and that is displayed on your customers' credit card and bank statements. Allows you to see what the statement descriptor looks like after the static and dynamic portions are combined.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    captured: {
      description:
        'If the charge was created without capturing, this Boolean represents whether it is still uncaptured or has since been captured.',
      type: 'boolean',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'ID of the customer this charge is for if one exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 40000,
      nullable: true,
      type: 'string',
    },
    disputed: {
      description: 'Whether the charge has been disputed.',
      type: 'boolean',
    },
    failure_balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'ID of the balance transaction that describes the reversal of the balance on your account due to payment failure.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    failure_code: {
      description:
        'Error code explaining reason for charge failure if available (see [the errors section](https://stripe.com/docs/error-codes) for a list of codes).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    failure_message: {
      description: 'Message to user further explaining reason for charge failure if available.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fraud_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/charge_fraud_details',
        },
      ],
      description: 'Information on fraud assessments for the charge.',
      nullable: true,
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'ID of the invoice this charge is for if one exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['charge'],
      type: 'string',
    },
    on_behalf_of: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The account (if any) the charge was made on behalf of without triggering an automatic transfer. See the [Connect documentation](https://stripe.com/docs/connect/separate-charges-and-transfers) for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    outcome: {
      anyOf: [
        {
          $ref: '#/components/schemas/charge_outcome',
        },
      ],
      description:
        'Details about whether the payment was accepted, and why. See [understanding declines](https://stripe.com/docs/declines) for details.',
      nullable: true,
    },
    paid: {
      description: `\`true\` if the charge succeeded, or was successfully authorized for later capture.`,
      type: 'boolean',
    },
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description: 'ID of the PaymentIntent associated with this charge, if one exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
    payment_method: {
      description: 'ID of the payment method used in this charge.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_method_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details',
        },
      ],
      description: 'Details about the payment method at the time of the transaction.',
      nullable: true,
    },
    radar_options: {
      $ref: '#/components/schemas/radar_radar_options',
    },
    receipt_email: {
      description: 'This is the email address that the receipt for this charge was sent to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    receipt_number: {
      description:
        'This is the transaction number that appears on email receipts sent for this charge. This attribute will be `null` until a receipt has been sent.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    receipt_url: {
      description:
        'This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt will be stylized as an Invoice receipt.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    refunded: {
      description:
        'Whether the charge has been fully refunded. If the charge is only partially refunded, this attribute will still be false.',
      type: 'boolean',
    },
    refunds: {
      description: 'A list of refunds that have been applied to the charge.',
      nullable: true,
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/refund',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'RefundList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    review: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/review',
        },
      ],
      description: 'ID of the review associated with this charge if one exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/review',
          },
        ],
      },
    },
    shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description: 'Shipping information for the charge.',
      nullable: true,
    },
    source_transfer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/transfer',
        },
      ],
      description:
        'The transfer ID which created this charge. Only present if the charge came from another Stripe account. [See the Connect documentation](https://stripe.com/docs/connect/destination-charges) for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/transfer',
          },
        ],
      },
    },
    statement_descriptor: {
      description:
        'For card charges, use `statement_descriptor_suffix` instead. Otherwise, you can use this value as the complete description of a charge on your customers’ statements. Must contain at least one letter, maximum 22 characters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_suffix: {
      description:
        'Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'The status of the payment is either `succeeded`, `pending`, or `failed`.',
      enum: ['failed', 'pending', 'succeeded'],
      type: 'string',
    },
    transfer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/transfer',
        },
      ],
      description:
        'ID of the transfer to the `destination` account (only applicable if the charge was created using the `destination` parameter).',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/transfer',
          },
        ],
      },
    },
    transfer_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/charge_transfer_data',
        },
      ],
      description:
        'An optional dictionary including the account to automatically transfer to as part of a destination charge. [See the Connect documentation](https://stripe.com/docs/connect/destination-charges) for details.',
      nullable: true,
    },
    transfer_group: {
      description:
        'A string that identifies this transaction as part of a group. See the [Connect documentation](https://stripe.com/docs/connect/separate-charges-and-transfers#transfer-options) for details.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'amount_captured',
    'amount_refunded',
    'billing_details',
    'captured',
    'created',
    'currency',
    'disputed',
    'id',
    'livemode',
    'metadata',
    'object',
    'paid',
    'refunded',
    'status',
  ],
  title: 'Charge',
  type: 'object',
  'x-expandableFields': [
    'application',
    'application_fee',
    'balance_transaction',
    'billing_details',
    'customer',
    'failure_balance_transaction',
    'fraud_details',
    'invoice',
    'on_behalf_of',
    'outcome',
    'payment_intent',
    'payment_method_details',
    'radar_options',
    'refunds',
    'review',
    'shipping',
    'source_transfer',
    'transfer',
    'transfer_data',
  ],
  'x-resourceId': 'charge',
} as const;

export const charge_fraud_detailsSchema = {
  description: '',
  properties: {
    stripe_report: {
      description: 'Assessments from Stripe. If set, the value is `fraudulent`.',
      maxLength: 5000,
      type: 'string',
    },
    user_report: {
      description: 'Assessments reported by you. If set, possible values of are `safe` and `fraudulent`.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'ChargeFraudDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const charge_outcomeSchema = {
  description: '',
  properties: {
    network_status: {
      description: `Possible values are \`approved_by_network\`, \`declined_by_network\`, \`not_sent_to_network\`, and \`reversed_after_approval\`. The value \`reversed_after_approval\` indicates the payment was [blocked by Stripe](https://stripe.com/docs/declines#blocked-payments) after bank authorization, and may temporarily appear as "pending" on a cardholder's statement.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reason: {
      description:
        "An enumerated value providing a more detailed explanation of the outcome's `type`. Charges blocked by Radar's default block rule have the value `highest_risk_level`. Charges placed in review by Radar's default review rule have the value `elevated_risk_level`. Charges authorized, blocked, or placed in review by custom rules have the value `rule`. See [understanding declines](https://stripe.com/docs/declines) for more details.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    risk_level: {
      description:
        "Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated payments are `normal`, `elevated`, `highest`. For non-card payments, and card-based payments predating the public assignment of risk levels, this field will have the value `not_assessed`. In the event of an error in the evaluation, this field will have the value `unknown`. This field is only available with Radar.",
      maxLength: 5000,
      type: 'string',
    },
    risk_score: {
      description:
        "Stripe Radar's evaluation of the riskiness of the payment. Possible values for evaluated payments are between 0 and 100. For non-card payments, card-based payments predating the public assignment of risk scores, or in the event of an error during evaluation, this field will not be present. This field is only available with Radar for Fraud Teams.",
      type: 'integer',
    },
    rule: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/rule',
        },
      ],
      description: 'The ID of the Radar rule that matched the payment, if applicable.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/rule',
          },
        ],
      },
    },
    seller_message: {
      description:
        'A human-readable description of the outcome type and reason, designed for you (the recipient of the payment), not your customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description:
        'Possible values are `authorized`, `manual_review`, `issuer_declined`, `blocked`, and `invalid`. See [understanding declines](https://stripe.com/docs/declines) and [Radar reviews](https://stripe.com/docs/radar/reviews) for details.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['type'],
  title: 'ChargeOutcome',
  type: 'object',
  'x-expandableFields': ['rule'],
} as const;

export const charge_transfer_dataSchema = {
  description: '',
  properties: {
    amount: {
      description:
        'The amount transferred to the destination account, if specified. By default, the entire charge amount is transferred to the destination account.',
      nullable: true,
      type: 'integer',
    },
    destination: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'ID of an existing, connected Stripe account to transfer funds to if `transfer_data` was specified in the charge request.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
  },
  required: ['destination'],
  title: 'ChargeTransferData',
  type: 'object',
  'x-expandableFields': ['destination'],
} as const;

export const checkout_sessionSchema = {
  description: `A Checkout Session represents your customer's session as they pay for
one-time purchases or subscriptions through [Checkout](https://stripe.com/docs/payments/checkout)
or [Payment Links](https://stripe.com/docs/payments/payment-links). We recommend creating a
new Session each time your customer attempts to pay.

Once payment is successful, the Checkout Session will contain a reference
to the [Customer](https://stripe.com/docs/api/customers), and either the successful
[PaymentIntent](https://stripe.com/docs/api/payment_intents) or an active
[Subscription](https://stripe.com/docs/api/subscriptions).

You can create a Checkout Session on your server and redirect to its URL
to begin Checkout.

Related guide: [Checkout quickstart](https://stripe.com/docs/checkout/quickstart)`,
  properties: {
    after_expiration: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_after_expiration',
        },
      ],
      description: 'When set, provides configuration for actions to take if this Checkout Session expires.',
      nullable: true,
    },
    allow_promotion_codes: {
      description: 'Enables user redeemable promotion codes.',
      nullable: true,
      type: 'boolean',
    },
    amount_subtotal: {
      description: 'Total of all items before discounts or taxes are applied.',
      nullable: true,
      type: 'integer',
    },
    amount_total: {
      description: 'Total of all items after discounts and taxes are applied.',
      nullable: true,
      type: 'integer',
    },
    automatic_tax: {
      $ref: '#/components/schemas/payment_pages_checkout_session_automatic_tax',
    },
    billing_address_collection: {
      description: "Describes whether Checkout should collect the customer's billing address. Defaults to `auto`.",
      enum: ['auto', 'required'],
      nullable: true,
      type: 'string',
    },
    cancel_url: {
      description:
        'If set, Checkout displays a back button and customers will be directed to this URL if they decide to cancel payment and return to your website.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    client_reference_id: {
      description: `A unique string to reference the Checkout Session. This can be a
customer ID, a cart ID, or similar, and can be used to reconcile the
Session with your internal systems.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    client_secret: {
      description: 'Client secret to be used when initializing Stripe.js embedded checkout.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    consent: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_consent',
        },
      ],
      description: 'Results of `consent_collection` for this session.',
      nullable: true,
    },
    consent_collection: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_consent_collection',
        },
      ],
      description: 'When set, provides configuration for the Checkout Session to gather active consent from customers.',
      nullable: true,
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      nullable: true,
      type: 'string',
    },
    currency_conversion: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_currency_conversion',
        },
      ],
      description: 'Currency conversion details for automatic currency conversion sessions',
      nullable: true,
    },
    custom_fields: {
      description:
        'Collect additional information from your customer using custom fields. Up to 3 fields are supported.',
      items: {
        $ref: '#/components/schemas/payment_pages_checkout_session_custom_fields',
      },
      type: 'array',
    },
    custom_text: {
      $ref: '#/components/schemas/payment_pages_checkout_session_custom_text',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: `The ID of the customer for this Session.
For Checkout Sessions in \`subscription\` mode or Checkout Sessions with \`customer_creation\` set as \`always\` in \`payment\` mode, Checkout
will create a new customer object based on information provided
during the payment flow unless an existing customer was provided when
the Session was created.`,
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    customer_creation: {
      description: 'Configure whether a Checkout Session creates a Customer when the Checkout Session completes.',
      enum: ['always', 'if_required'],
      nullable: true,
      type: 'string',
    },
    customer_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_customer_details',
        },
      ],
      description:
        "The customer details including the customer's tax exempt status and the customer's tax IDs. Customer's address details are not present on Sessions in `setup` mode.",
      nullable: true,
    },
    customer_email: {
      description: `If provided, this value will be used when the Customer object is created.
If not provided, customers will be asked to enter their email address.
Use this parameter to prefill customer data if you already have an email
on file. To access information about the customer once the payment flow is
complete, use the \`customer\` attribute.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    expires_at: {
      description: 'The timestamp at which the Checkout Session will expire.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'ID of the invoice created by the Checkout Session, if it exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    invoice_creation: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_invoice_creation',
        },
      ],
      description: 'Details on the state of invoice creation for the Checkout Session.',
      nullable: true,
    },
    line_items: {
      description: 'The line items purchased by the customer.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/item',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'PaymentPagesCheckoutSessionListLineItems',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    locale: {
      description:
        "The IETF language tag of the locale Checkout is displayed in. If blank or `auto`, the browser's locale is used.",
      enum: [
        'auto',
        'bg',
        'cs',
        'da',
        'de',
        'el',
        'en',
        'en-GB',
        'es',
        'es-419',
        'et',
        'fi',
        'fil',
        'fr',
        'fr-CA',
        'hr',
        'hu',
        'id',
        'it',
        'ja',
        'ko',
        'lt',
        'lv',
        'ms',
        'mt',
        'nb',
        'nl',
        'pl',
        'pt',
        'pt-BR',
        'ro',
        'ru',
        'sk',
        'sl',
        'sv',
        'th',
        'tr',
        'vi',
        'zh',
        'zh-HK',
        'zh-TW',
      ],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    mode: {
      description: 'The mode of the Checkout Session.',
      enum: ['payment', 'setup', 'subscription'],
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['checkout.session'],
      type: 'string',
    },
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description:
        "The ID of the PaymentIntent for Checkout Sessions in `payment` mode. You can't confirm or cancel the PaymentIntent for a Checkout Session. To cancel, [expire the Checkout Session](https://stripe.com/docs/api/checkout/sessions/expire) instead.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
    payment_link: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_link',
        },
      ],
      description: 'The ID of the Payment Link that created this Session.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_link',
          },
        ],
      },
    },
    payment_method_collection: {
      description: 'Configure whether a Checkout Session should collect a payment method. Defaults to `always`.',
      enum: ['always', 'if_required'],
      nullable: true,
      type: 'string',
    },
    payment_method_configuration_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_config_biz_payment_method_configuration_details',
        },
      ],
      description:
        'Information about the payment method configuration used for this Checkout session if using dynamic payment methods.',
      nullable: true,
    },
    payment_method_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/checkout_session_payment_method_options',
        },
      ],
      description:
        'Payment-method-specific configuration for the PaymentIntent or SetupIntent of this CheckoutSession.',
      nullable: true,
    },
    payment_method_types: {
      description: `A list of the types of payment methods (e.g. card) this Checkout
Session is allowed to accept.`,
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    payment_status: {
      description: `The payment status of the Checkout Session, one of \`paid\`, \`unpaid\`, or \`no_payment_required\`.
You can use this value to decide when to fulfill your customer's order.`,
      enum: ['no_payment_required', 'paid', 'unpaid'],
      type: 'string',
    },
    phone_number_collection: {
      $ref: '#/components/schemas/payment_pages_checkout_session_phone_number_collection',
    },
    recovered_from: {
      description: 'The ID of the original expired Checkout Session that triggered the recovery flow.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    redirect_on_completion: {
      description:
        'This parameter applies to `ui_mode: embedded`. Learn more about the [redirect behavior](https://stripe.com/docs/payments/checkout/custom-redirect-behavior) of embedded sessions. Defaults to `always`.',
      enum: ['always', 'if_required', 'never'],
      type: 'string',
    },
    return_url: {
      description:
        "Applies to Checkout Sessions with `ui_mode: embedded`. The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site.",
      maxLength: 5000,
      type: 'string',
    },
    saved_payment_method_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_saved_payment_method_options',
        },
      ],
      description:
        'Controls saved payment method settings for the session. Only available in `payment` and `subscription` mode.',
      nullable: true,
    },
    setup_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/setup_intent',
        },
      ],
      description:
        "The ID of the SetupIntent for Checkout Sessions in `setup` mode. You can't confirm or cancel the SetupIntent for a Checkout Session. To cancel, [expire the Checkout Session](https://stripe.com/docs/api/checkout/sessions/expire) instead.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/setup_intent',
          },
        ],
      },
    },
    shipping_address_collection: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_shipping_address_collection',
        },
      ],
      description: 'When set, provides configuration for Checkout to collect a shipping address from a customer.',
      nullable: true,
    },
    shipping_cost: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_shipping_cost',
        },
      ],
      description: 'The details of the customer cost of shipping, including the customer chosen ShippingRate.',
      nullable: true,
    },
    shipping_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description: 'Shipping information for this Checkout Session.',
      nullable: true,
    },
    shipping_options: {
      description: 'The shipping rate options applied to this Session.',
      items: {
        $ref: '#/components/schemas/payment_pages_checkout_session_shipping_option',
      },
      type: 'array',
    },
    status: {
      description: 'The status of the Checkout Session, one of `open`, `complete`, or `expired`.',
      enum: ['complete', 'expired', 'open'],
      nullable: true,
      type: 'string',
    },
    submit_type: {
      description: `Describes the type of transaction being performed by Checkout in order to customize
relevant text on the page, such as the submit button. \`submit_type\` can only be
specified on Checkout Sessions in \`payment\` mode. If blank or \`auto\`, \`pay\` is used.`,
      enum: ['auto', 'book', 'donate', 'pay'],
      nullable: true,
      type: 'string',
    },
    subscription: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/subscription',
        },
      ],
      description: 'The ID of the subscription for Checkout Sessions in `subscription` mode.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/subscription',
          },
        ],
      },
    },
    success_url: {
      description: `The URL the customer will be directed to after the payment or
subscription creation is successful.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    tax_id_collection: {
      $ref: '#/components/schemas/payment_pages_checkout_session_tax_id_collection',
    },
    total_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_pages_checkout_session_total_details',
        },
      ],
      description: 'Tax and discount details for the computed total amount.',
      nullable: true,
    },
    ui_mode: {
      description: 'The UI mode of the Session. Defaults to `hosted`.',
      enum: ['embedded', 'hosted'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    url: {
      description: `The URL to the Checkout Session. Redirect customers to this URL to take them to Checkout. If you’re using [Custom Domains](https://stripe.com/docs/payments/checkout/custom-domains), the URL will use your subdomain. Otherwise, it’ll use \`checkout.stripe.com.\`
This value is only present when the session is active.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'automatic_tax',
    'created',
    'custom_fields',
    'custom_text',
    'expires_at',
    'id',
    'livemode',
    'mode',
    'object',
    'payment_method_types',
    'payment_status',
    'shipping_options',
  ],
  title: 'Session',
  type: 'object',
  'x-expandableFields': [
    'after_expiration',
    'automatic_tax',
    'consent',
    'consent_collection',
    'currency_conversion',
    'custom_fields',
    'custom_text',
    'customer',
    'customer_details',
    'invoice',
    'invoice_creation',
    'line_items',
    'payment_intent',
    'payment_link',
    'payment_method_configuration_details',
    'payment_method_options',
    'phone_number_collection',
    'saved_payment_method_options',
    'setup_intent',
    'shipping_address_collection',
    'shipping_cost',
    'shipping_details',
    'shipping_options',
    'subscription',
    'tax_id_collection',
    'total_details',
  ],
  'x-resourceId': 'checkout.session',
} as const;

export const checkout_acss_debit_mandate_optionsSchema = {
  description: '',
  properties: {
    custom_mandate_url: {
      description: 'A URL for custom mandate text',
      maxLength: 5000,
      type: 'string',
    },
    default_for: {
      description:
        'List of Stripe products where this mandate can be selected automatically. Returned when the Session is in `setup` mode.',
      items: {
        enum: ['invoice', 'subscription'],
        type: 'string',
      },
      type: 'array',
    },
    interval_description: {
      description:
        "Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_schedule: {
      description: 'Payment schedule for the mandate.',
      enum: ['combined', 'interval', 'sporadic'],
      nullable: true,
      type: 'string',
    },
    transaction_type: {
      description: 'Transaction type of the mandate.',
      enum: ['business', 'personal'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'CheckoutAcssDebitMandateOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_acss_debit_payment_method_optionsSchema = {
  description: '',
  properties: {
    currency: {
      description: 'Currency supported by the bank account. Returned when the Session is in `setup` mode.',
      enum: ['cad', 'usd'],
      type: 'string',
    },
    mandate_options: {
      $ref: '#/components/schemas/checkout_acss_debit_mandate_options',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'CheckoutAcssDebitPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': ['mandate_options'],
} as const;

export const checkout_affirm_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutAffirmPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_afterpay_clearpay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutAfterpayClearpayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_alipay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutAlipayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_amazon_pay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'CheckoutAmazonPayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_au_becs_debit_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutAuBecsDebitPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_bacs_debit_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'CheckoutBacsDebitPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_bancontact_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutBancontactPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_boleto_payment_method_optionsSchema = {
  description: '',
  properties: {
    expires_after_days: {
      description:
        'The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.',
      type: 'integer',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  required: ['expires_after_days'],
  title: 'CheckoutBoletoPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_card_installments_optionsSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Indicates if installments are enabled',
      type: 'boolean',
    },
  },
  title: 'CheckoutCardInstallmentsOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_card_payment_method_optionsSchema = {
  description: '',
  properties: {
    installments: {
      $ref: '#/components/schemas/checkout_card_installments_options',
    },
    request_three_d_secure: {
      description:
        'We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.',
      enum: ['any', 'automatic', 'challenge'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    statement_descriptor_suffix_kana: {
      description:
        'Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.',
      maxLength: 5000,
      type: 'string',
    },
    statement_descriptor_suffix_kanji: {
      description:
        'Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['request_three_d_secure'],
  title: 'CheckoutCardPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': ['installments'],
} as const;

export const checkout_cashapp_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutCashappPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_customer_balance_bank_transfer_payment_method_optionsSchema = {
  description: '',
  properties: {
    eu_bank_transfer: {
      $ref: '#/components/schemas/payment_method_options_customer_balance_eu_bank_account',
    },
    requested_address_types: {
      description: `List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.

Permitted values include: \`sort_code\`, \`zengin\`, \`iban\`, or \`spei\`.`,
      items: {
        enum: ['aba', 'iban', 'sepa', 'sort_code', 'spei', 'swift', 'zengin'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      type: 'array',
    },
    type: {
      description:
        'The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.',
      enum: ['eu_bank_transfer', 'gb_bank_transfer', 'jp_bank_transfer', 'mx_bank_transfer', 'us_bank_transfer'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'CheckoutCustomerBalanceBankTransferPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': ['eu_bank_transfer'],
} as const;

export const checkout_customer_balance_payment_method_optionsSchema = {
  description: '',
  properties: {
    bank_transfer: {
      $ref: '#/components/schemas/checkout_customer_balance_bank_transfer_payment_method_options',
    },
    funding_type: {
      description:
        'The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.',
      enum: ['bank_transfer'],
      nullable: true,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutCustomerBalancePaymentMethodOptions',
  type: 'object',
  'x-expandableFields': ['bank_transfer'],
} as const;

export const checkout_eps_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutEpsPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_fpx_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutFpxPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_giropay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutGiropayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_grab_pay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutGrabPayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_ideal_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutIdealPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_klarna_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'CheckoutKlarnaPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_konbini_payment_method_optionsSchema = {
  description: '',
  properties: {
    expires_after_days: {
      description:
        'The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire. For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST.',
      nullable: true,
      type: 'integer',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutKonbiniPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_link_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'CheckoutLinkPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_mobilepay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutMobilepayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_multibanco_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutMultibancoPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_oxxo_payment_method_optionsSchema = {
  description: '',
  properties: {
    expires_after_days: {
      description:
        'The number of calendar days before an OXXO invoice expires. For example, if you create an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.',
      type: 'integer',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  required: ['expires_after_days'],
  title: 'CheckoutOxxoPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_p24_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutP24PaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_paynow_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutPaynowPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_paypal_payment_method_optionsSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    preferred_locale: {
      description: 'Preferred locale of the PayPal checkout page that the customer is redirected to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reference: {
      description:
        "A reference of the PayPal transaction visible to customer which is mapped to PayPal's invoice ID. This must be a globally unique ID if you have configured in your PayPal settings to block multiple payments per invoice ID.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'CheckoutPaypalPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_pix_payment_method_optionsSchema = {
  description: '',
  properties: {
    expires_after_seconds: {
      description: 'The number of seconds after which Pix payment will expire.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'CheckoutPixPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_revolut_pay_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'CheckoutRevolutPayPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_sepa_debit_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'CheckoutSepaDebitPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_session_payment_method_optionsSchema = {
  description: '',
  properties: {
    acss_debit: {
      $ref: '#/components/schemas/checkout_acss_debit_payment_method_options',
    },
    affirm: {
      $ref: '#/components/schemas/checkout_affirm_payment_method_options',
    },
    afterpay_clearpay: {
      $ref: '#/components/schemas/checkout_afterpay_clearpay_payment_method_options',
    },
    alipay: {
      $ref: '#/components/schemas/checkout_alipay_payment_method_options',
    },
    amazon_pay: {
      $ref: '#/components/schemas/checkout_amazon_pay_payment_method_options',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/checkout_au_becs_debit_payment_method_options',
    },
    bacs_debit: {
      $ref: '#/components/schemas/checkout_bacs_debit_payment_method_options',
    },
    bancontact: {
      $ref: '#/components/schemas/checkout_bancontact_payment_method_options',
    },
    boleto: {
      $ref: '#/components/schemas/checkout_boleto_payment_method_options',
    },
    card: {
      $ref: '#/components/schemas/checkout_card_payment_method_options',
    },
    cashapp: {
      $ref: '#/components/schemas/checkout_cashapp_payment_method_options',
    },
    customer_balance: {
      $ref: '#/components/schemas/checkout_customer_balance_payment_method_options',
    },
    eps: {
      $ref: '#/components/schemas/checkout_eps_payment_method_options',
    },
    fpx: {
      $ref: '#/components/schemas/checkout_fpx_payment_method_options',
    },
    giropay: {
      $ref: '#/components/schemas/checkout_giropay_payment_method_options',
    },
    grabpay: {
      $ref: '#/components/schemas/checkout_grab_pay_payment_method_options',
    },
    ideal: {
      $ref: '#/components/schemas/checkout_ideal_payment_method_options',
    },
    klarna: {
      $ref: '#/components/schemas/checkout_klarna_payment_method_options',
    },
    konbini: {
      $ref: '#/components/schemas/checkout_konbini_payment_method_options',
    },
    link: {
      $ref: '#/components/schemas/checkout_link_payment_method_options',
    },
    mobilepay: {
      $ref: '#/components/schemas/checkout_mobilepay_payment_method_options',
    },
    multibanco: {
      $ref: '#/components/schemas/checkout_multibanco_payment_method_options',
    },
    oxxo: {
      $ref: '#/components/schemas/checkout_oxxo_payment_method_options',
    },
    p24: {
      $ref: '#/components/schemas/checkout_p24_payment_method_options',
    },
    paynow: {
      $ref: '#/components/schemas/checkout_paynow_payment_method_options',
    },
    paypal: {
      $ref: '#/components/schemas/checkout_paypal_payment_method_options',
    },
    pix: {
      $ref: '#/components/schemas/checkout_pix_payment_method_options',
    },
    revolut_pay: {
      $ref: '#/components/schemas/checkout_revolut_pay_payment_method_options',
    },
    sepa_debit: {
      $ref: '#/components/schemas/checkout_sepa_debit_payment_method_options',
    },
    sofort: {
      $ref: '#/components/schemas/checkout_sofort_payment_method_options',
    },
    swish: {
      $ref: '#/components/schemas/checkout_swish_payment_method_options',
    },
    us_bank_account: {
      $ref: '#/components/schemas/checkout_us_bank_account_payment_method_options',
    },
  },
  title: 'CheckoutSessionPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'boleto',
    'card',
    'cashapp',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'grabpay',
    'ideal',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'pix',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'swish',
    'us_bank_account',
  ],
} as const;

export const checkout_sofort_payment_method_optionsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'CheckoutSofortPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_swish_payment_method_optionsSchema = {
  description: '',
  properties: {
    reference: {
      description:
        'The order reference that will be displayed to customers in the Swish application. Defaults to the `id` of the Payment Intent.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'CheckoutSwishPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const checkout_us_bank_account_payment_method_optionsSchema = {
  description: '',
  properties: {
    financial_connections: {
      $ref: '#/components/schemas/linked_account_options_us_bank_account',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'CheckoutUsBankAccountPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': ['financial_connections'],
} as const;

export const climate_orderSchema = {
  description: `Orders represent your intent to purchase a particular Climate product. When you create an order, the
payment is deducted from your merchant balance.`,
  properties: {
    amount_fees: {
      description:
        "Total amount of [Frontier](https://frontierclimate.com/)'s service fees in the currency's smallest unit.",
      type: 'integer',
    },
    amount_subtotal: {
      description: "Total amount of the carbon removal in the currency's smallest unit.",
      type: 'integer',
    },
    amount_total: {
      description: "Total amount of the order including fees in the currency's smallest unit.",
      type: 'integer',
    },
    beneficiary: {
      $ref: '#/components/schemas/climate_removals_beneficiary',
    },
    canceled_at: {
      description: 'Time at which the order was canceled. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    cancellation_reason: {
      description: 'Reason for the cancellation of this order.',
      enum: ['expired', 'product_unavailable', 'requested'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    certificate: {
      description: 'For delivered orders, a URL to a delivery certificate for the order.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    confirmed_at: {
      description: 'Time at which the order was confirmed. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase, representing the currency for this order.',
      maxLength: 5000,
      type: 'string',
    },
    delayed_at: {
      description:
        "Time at which the order's expected_delivery_year was delayed. Measured in seconds since the Unix epoch.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    delivered_at: {
      description: 'Time at which the order was delivered. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    delivery_details: {
      description: 'Details about the delivery of carbon removal for this order.',
      items: {
        $ref: '#/components/schemas/climate_removals_order_deliveries',
      },
      type: 'array',
    },
    expected_delivery_year: {
      description: 'The year this order is expected to be delivered.',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    metric_tons: {
      description: 'Quantity of carbon removal that is included in this order.',
      format: 'decimal',
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['climate.order'],
      type: 'string',
    },
    product: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/climate.product',
        },
      ],
      description: 'Unique ID for the Climate `Product` this order is purchasing.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/climate.product',
          },
        ],
      },
    },
    product_substituted_at: {
      description:
        "Time at which the order's product was substituted for a different product. Measured in seconds since the Unix epoch.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    status: {
      description: 'The current status of this order.',
      enum: ['awaiting_funds', 'canceled', 'confirmed', 'delivered', 'open'],
      type: 'string',
    },
  },
  required: [
    'amount_fees',
    'amount_subtotal',
    'amount_total',
    'created',
    'currency',
    'delivery_details',
    'expected_delivery_year',
    'id',
    'livemode',
    'metadata',
    'metric_tons',
    'object',
    'product',
    'status',
  ],
  title: 'ClimateRemovalsOrders',
  type: 'object',
  'x-expandableFields': ['beneficiary', 'delivery_details', 'product'],
  'x-resourceId': 'climate.order',
} as const;

export const climate_productSchema = {
  description: `A Climate product represents a type of carbon removal unit available for reservation.
You can retrieve it to see the current price and availability.`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    current_prices_per_metric_ton: {
      additionalProperties: {
        $ref: '#/components/schemas/climate_removals_products_price',
      },
      description: "Current prices for a metric ton of carbon removal in a currency's smallest unit.",
      type: 'object',
    },
    delivery_year: {
      description: 'The year in which the carbon removal is expected to be delivered.',
      nullable: true,
      type: 'integer',
    },
    id: {
      description: `Unique identifier for the object. For convenience, Climate product IDs are human-readable strings
that start with \`climsku_\`. See [carbon removal inventory](https://stripe.com/docs/climate/orders/carbon-removal-inventory)
for a list of available carbon removal products.`,
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metric_tons_available: {
      description: 'The quantity of metric tons available for reservation.',
      format: 'decimal',
      type: 'string',
    },
    name: {
      description: "The Climate product's name.",
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['climate.product'],
      type: 'string',
    },
    suppliers: {
      description: 'The carbon removal suppliers that fulfill orders for this Climate product.',
      items: {
        $ref: '#/components/schemas/climate.supplier',
      },
      type: 'array',
    },
  },
  required: [
    'created',
    'current_prices_per_metric_ton',
    'id',
    'livemode',
    'metric_tons_available',
    'name',
    'object',
    'suppliers',
  ],
  title: 'ClimateRemovalsProducts',
  type: 'object',
  'x-expandableFields': ['current_prices_per_metric_ton', 'suppliers'],
  'x-resourceId': 'climate.product',
} as const;

export const climate_supplierSchema = {
  description: 'A supplier of carbon removal.',
  properties: {
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    info_url: {
      description: 'Link to a webpage to learn more about the supplier.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    locations: {
      description: 'The locations in which this supplier operates.',
      items: {
        $ref: '#/components/schemas/climate_removals_location',
      },
      type: 'array',
    },
    name: {
      description: 'Name of this carbon removal supplier.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: 'String representing the object’s type. Objects of the same type share the same value.',
      enum: ['climate.supplier'],
      type: 'string',
    },
    removal_pathway: {
      description: 'The scientific pathway used for carbon removal.',
      enum: ['biomass_carbon_removal_and_storage', 'direct_air_capture', 'enhanced_weathering'],
      type: 'string',
    },
  },
  required: ['id', 'info_url', 'livemode', 'locations', 'name', 'object', 'removal_pathway'],
  title: 'ClimateRemovalsSuppliers',
  type: 'object',
  'x-expandableFields': ['locations'],
  'x-resourceId': 'climate.supplier',
} as const;

export const climate_removals_beneficiarySchema = {
  description: '',
  properties: {
    public_name: {
      description: 'Publicly displayable name for the end beneficiary of carbon removal.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['public_name'],
  title: 'ClimateRemovalsBeneficiary',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const climate_removals_locationSchema = {
  description: '',
  properties: {
    city: {
      description: 'The city where the supplier is located.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country where the supplier is located.',
      maxLength: 5000,
      type: 'string',
    },
    latitude: {
      description: 'The geographic latitude where the supplier is located.',
      nullable: true,
      type: 'number',
    },
    longitude: {
      description: 'The geographic longitude where the supplier is located.',
      nullable: true,
      type: 'number',
    },
    region: {
      description: 'The state/county/province/region where the supplier is located.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['country'],
  title: 'ClimateRemovalsLocation',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const climate_removals_order_deliveriesSchema = {
  description: 'The delivery of a specified quantity of carbon for an order.',
  properties: {
    delivered_at: {
      description: 'Time at which the delivery occurred. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    location: {
      anyOf: [
        {
          $ref: '#/components/schemas/climate_removals_location',
        },
      ],
      description: 'Specific location of this delivery.',
      nullable: true,
    },
    metric_tons: {
      description: 'Quantity of carbon removal supplied by this delivery.',
      maxLength: 5000,
      type: 'string',
    },
    registry_url: {
      description: 'Once retired, a URL to the registry entry for the tons from this delivery.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    supplier: {
      $ref: '#/components/schemas/climate.supplier',
    },
  },
  required: ['delivered_at', 'metric_tons', 'supplier'],
  title: 'ClimateRemovalsOrderDeliveries',
  type: 'object',
  'x-expandableFields': ['location', 'supplier'],
} as const;

export const climate_removals_products_priceSchema = {
  description: '',
  properties: {
    amount_fees: {
      description: "Fees for one metric ton of carbon removal in the currency's smallest unit.",
      type: 'integer',
    },
    amount_subtotal: {
      description: "Subtotal for one metric ton of carbon removal (excluding fees) in the currency's smallest unit.",
      type: 'integer',
    },
    amount_total: {
      description: "Total for one metric ton of carbon removal (including fees) in the currency's smallest unit.",
      type: 'integer',
    },
  },
  required: ['amount_fees', 'amount_subtotal', 'amount_total'],
  title: 'ClimateRemovalsProductsPrice',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const confirmation_tokenSchema = {
  description: `ConfirmationTokens help transport client side data collected by Stripe JS over
to your server for confirming a PaymentIntent or SetupIntent. If the confirmation
is successful, values present on the ConfirmationToken are written onto the Intent.

To learn more about how to use ConfirmationToken, visit the related guides:
- [Finalize payments on the server](https://stripe.com/docs/payments/finalize-payments-on-the-server)
- [Build two-step confirmation](https://stripe.com/docs/payments/build-a-two-step-confirmation).`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    expires_at: {
      description:
        'Time at which this ConfirmationToken expires and can no longer be used to confirm a PaymentIntent or SetupIntent.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    mandate_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/confirmation_tokens_resource_mandate_data',
        },
      ],
      description: 'Data used for generating a Mandate.',
      nullable: true,
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['confirmation_token'],
      type: 'string',
    },
    payment_intent: {
      description:
        'ID of the PaymentIntent that this ConfirmationToken was used to confirm, or null if this ConfirmationToken has not yet been used.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_method_preview: {
      anyOf: [
        {
          $ref: '#/components/schemas/confirmation_tokens_resource_payment_method_preview',
        },
      ],
      description:
        'Payment details collected by the Payment Element, used to create a PaymentMethod when a PaymentIntent or SetupIntent is confirmed with this ConfirmationToken.',
      nullable: true,
    },
    return_url: {
      description: 'Return URL used to confirm the Intent.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this ConfirmationToken's payment method.

The presence of this property will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete.`,
      enum: ['off_session', 'on_session'],
      nullable: true,
      type: 'string',
    },
    setup_intent: {
      description:
        'ID of the SetupIntent that this ConfirmationToken was used to confirm, or null if this ConfirmationToken has not yet been used.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/confirmation_tokens_resource_shipping',
        },
      ],
      description: 'Shipping information collected on this ConfirmationToken.',
      nullable: true,
    },
    use_stripe_sdk: {
      description:
        'Indicates whether the Stripe SDK is used to handle confirmation flow. Defaults to `true` on ConfirmationToken.',
      type: 'boolean',
    },
  },
  required: ['created', 'id', 'livemode', 'object', 'use_stripe_sdk'],
  title: 'ConfirmationTokensResourceConfirmationToken',
  type: 'object',
  'x-expandableFields': ['mandate_data', 'payment_method_preview', 'shipping'],
  'x-resourceId': 'confirmation_token',
} as const;

export const confirmation_tokens_resource_mandate_dataSchema = {
  description: 'Data used for generating a Mandate.',
  properties: {
    customer_acceptance: {
      $ref: '#/components/schemas/confirmation_tokens_resource_mandate_data_resource_customer_acceptance',
    },
  },
  required: ['customer_acceptance'],
  title: 'ConfirmationTokensResourceMandateData',
  type: 'object',
  'x-expandableFields': ['customer_acceptance'],
} as const;

export const confirmation_tokens_resource_mandate_data_resource_customer_acceptanceSchema = {
  description: 'This hash contains details about the customer acceptance of the Mandate.',
  properties: {
    online: {
      anyOf: [
        {
          $ref: '#/components/schemas/confirmation_tokens_resource_mandate_data_resource_customer_acceptance_resource_online',
        },
      ],
      description: 'If this is a Mandate accepted online, this hash contains details about the online acceptance.',
      nullable: true,
    },
    type: {
      description: 'The type of customer acceptance information included with the Mandate.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['type'],
  title: 'ConfirmationTokensResourceMandateDataResourceCustomerAcceptance',
  type: 'object',
  'x-expandableFields': ['online'],
} as const;

export const confirmation_tokens_resource_mandate_data_resource_customer_acceptance_resource_onlineSchema = {
  description: 'This hash contains details about the online acceptance.',
  properties: {
    ip_address: {
      description: 'The IP address from which the Mandate was accepted by the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description: 'The user agent of the browser from which the Mandate was accepted by the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'ConfirmationTokensResourceMandateDataResourceCustomerAcceptanceResourceOnline',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const confirmation_tokens_resource_payment_method_previewSchema = {
  description: 'Details of the PaymentMethod collected by Payment Element',
  properties: {
    acss_debit: {
      $ref: '#/components/schemas/payment_method_acss_debit',
    },
    affirm: {
      $ref: '#/components/schemas/payment_method_affirm',
    },
    afterpay_clearpay: {
      $ref: '#/components/schemas/payment_method_afterpay_clearpay',
    },
    alipay: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_alipay',
    },
    allow_redisplay: {
      description:
        'This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow. The field defaults to “unspecified”.',
      enum: ['always', 'limited', 'unspecified'],
      type: 'string',
    },
    amazon_pay: {
      $ref: '#/components/schemas/payment_method_amazon_pay',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/payment_method_au_becs_debit',
    },
    bacs_debit: {
      $ref: '#/components/schemas/payment_method_bacs_debit',
    },
    bancontact: {
      $ref: '#/components/schemas/payment_method_bancontact',
    },
    billing_details: {
      $ref: '#/components/schemas/billing_details',
    },
    blik: {
      $ref: '#/components/schemas/payment_method_blik',
    },
    boleto: {
      $ref: '#/components/schemas/payment_method_boleto',
    },
    card: {
      $ref: '#/components/schemas/payment_method_card',
    },
    card_present: {
      $ref: '#/components/schemas/payment_method_card_present',
    },
    cashapp: {
      $ref: '#/components/schemas/payment_method_cashapp',
    },
    customer_balance: {
      $ref: '#/components/schemas/payment_method_customer_balance',
    },
    eps: {
      $ref: '#/components/schemas/payment_method_eps',
    },
    fpx: {
      $ref: '#/components/schemas/payment_method_fpx',
    },
    giropay: {
      $ref: '#/components/schemas/payment_method_giropay',
    },
    grabpay: {
      $ref: '#/components/schemas/payment_method_grabpay',
    },
    ideal: {
      $ref: '#/components/schemas/payment_method_ideal',
    },
    interac_present: {
      $ref: '#/components/schemas/payment_method_interac_present',
    },
    klarna: {
      $ref: '#/components/schemas/payment_method_klarna',
    },
    konbini: {
      $ref: '#/components/schemas/payment_method_konbini',
    },
    link: {
      $ref: '#/components/schemas/payment_method_link',
    },
    mobilepay: {
      $ref: '#/components/schemas/payment_method_mobilepay',
    },
    multibanco: {
      $ref: '#/components/schemas/payment_method_multibanco',
    },
    oxxo: {
      $ref: '#/components/schemas/payment_method_oxxo',
    },
    p24: {
      $ref: '#/components/schemas/payment_method_p24',
    },
    paynow: {
      $ref: '#/components/schemas/payment_method_paynow',
    },
    paypal: {
      $ref: '#/components/schemas/payment_method_paypal',
    },
    pix: {
      $ref: '#/components/schemas/payment_method_pix',
    },
    promptpay: {
      $ref: '#/components/schemas/payment_method_promptpay',
    },
    revolut_pay: {
      $ref: '#/components/schemas/payment_method_revolut_pay',
    },
    sepa_debit: {
      $ref: '#/components/schemas/payment_method_sepa_debit',
    },
    sofort: {
      $ref: '#/components/schemas/payment_method_sofort',
    },
    swish: {
      $ref: '#/components/schemas/payment_method_swish',
    },
    twint: {
      $ref: '#/components/schemas/payment_method_twint',
    },
    type: {
      description:
        'The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.',
      enum: [
        'acss_debit',
        'affirm',
        'afterpay_clearpay',
        'alipay',
        'amazon_pay',
        'au_becs_debit',
        'bacs_debit',
        'bancontact',
        'blik',
        'boleto',
        'card',
        'card_present',
        'cashapp',
        'customer_balance',
        'eps',
        'fpx',
        'giropay',
        'grabpay',
        'ideal',
        'interac_present',
        'klarna',
        'konbini',
        'link',
        'mobilepay',
        'multibanco',
        'oxxo',
        'p24',
        'paynow',
        'paypal',
        'pix',
        'promptpay',
        'revolut_pay',
        'sepa_debit',
        'sofort',
        'swish',
        'twint',
        'us_bank_account',
        'wechat_pay',
        'zip',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    us_bank_account: {
      $ref: '#/components/schemas/payment_method_us_bank_account',
    },
    wechat_pay: {
      $ref: '#/components/schemas/payment_method_wechat_pay',
    },
    zip: {
      $ref: '#/components/schemas/payment_method_zip',
    },
  },
  required: ['billing_details', 'type'],
  title: 'ConfirmationTokensResourcePaymentMethodPreview',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'billing_details',
    'blik',
    'boleto',
    'card',
    'card_present',
    'cashapp',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'grabpay',
    'ideal',
    'interac_present',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'pix',
    'promptpay',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'swish',
    'twint',
    'us_bank_account',
    'wechat_pay',
    'zip',
  ],
} as const;

export const confirmation_tokens_resource_shippingSchema = {
  description: '',
  properties: {
    address: {
      $ref: '#/components/schemas/address',
    },
    name: {
      description: 'Recipient name.',
      maxLength: 5000,
      type: 'string',
    },
    phone: {
      description: 'Recipient phone (including extension).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['address', 'name'],
  title: 'ConfirmationTokensResourceShipping',
  type: 'object',
  'x-expandableFields': ['address'],
} as const;

export const connect_account_referenceSchema = {
  description: '',
  properties: {
    account: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'The connected account being referenced when `type` is `account`.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    type: {
      description: 'Type of the account referenced.',
      enum: ['account', 'self'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'ConnectAccountReference',
  type: 'object',
  'x-expandableFields': ['account'],
} as const;

export const connect_collection_transferSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Amount transferred, in cents (or local equivalent).',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    destination: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'ID of the account that funds are being collected for.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['connect_collection_transfer'],
      type: 'string',
    },
  },
  required: ['amount', 'currency', 'destination', 'id', 'livemode', 'object'],
  title: 'ConnectCollectionTransfer',
  type: 'object',
  'x-expandableFields': ['destination'],
} as const;

export const connect_embedded_account_config_claimSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Whether the embedded component is enabled.',
      type: 'boolean',
    },
    features: {
      $ref: '#/components/schemas/connect_embedded_account_features_claim',
    },
  },
  required: ['enabled', 'features'],
  title: 'ConnectEmbeddedAccountConfigClaim',
  type: 'object',
  'x-expandableFields': ['features'],
} as const;

export const connect_embedded_account_features_claimSchema = {
  description: '',
  properties: {
    external_account_collection: {
      description:
        'Whether to allow platforms to control bank account collection for their connected accounts. This feature can only be false for custom accounts (or accounts where the platform is compliance owner). Otherwise, bank account collection is determined by compliance requirements.',
      type: 'boolean',
    },
  },
  required: ['external_account_collection'],
  title: 'ConnectEmbeddedAccountFeaturesClaim',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const connect_embedded_account_session_create_componentsSchema = {
  description: '',
  properties: {
    account_management: {
      $ref: '#/components/schemas/connect_embedded_account_config_claim',
    },
    account_onboarding: {
      $ref: '#/components/schemas/connect_embedded_account_config_claim',
    },
    balances: {
      $ref: '#/components/schemas/connect_embedded_payouts_config_claim',
    },
    documents: {
      $ref: '#/components/schemas/connect_embedded_base_config_claim',
    },
    notification_banner: {
      $ref: '#/components/schemas/connect_embedded_account_config_claim',
    },
    payment_details: {
      $ref: '#/components/schemas/connect_embedded_payments_config_claim',
    },
    payments: {
      $ref: '#/components/schemas/connect_embedded_payments_config_claim',
    },
    payouts: {
      $ref: '#/components/schemas/connect_embedded_payouts_config_claim',
    },
    payouts_list: {
      $ref: '#/components/schemas/connect_embedded_base_config_claim',
    },
  },
  required: [
    'account_management',
    'account_onboarding',
    'balances',
    'documents',
    'notification_banner',
    'payment_details',
    'payments',
    'payouts',
    'payouts_list',
  ],
  title: 'ConnectEmbeddedAccountSessionCreateComponents',
  type: 'object',
  'x-expandableFields': [
    'account_management',
    'account_onboarding',
    'balances',
    'documents',
    'notification_banner',
    'payment_details',
    'payments',
    'payouts',
    'payouts_list',
  ],
} as const;

export const connect_embedded_base_config_claimSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Whether the embedded component is enabled.',
      type: 'boolean',
    },
    features: {
      $ref: '#/components/schemas/connect_embedded_base_features',
    },
  },
  required: ['enabled', 'features'],
  title: 'ConnectEmbeddedBaseConfigClaim',
  type: 'object',
  'x-expandableFields': ['features'],
} as const;

export const connect_embedded_base_featuresSchema = {
  description: '',
  properties: {},
  title: 'ConnectEmbeddedBaseFeatures',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const connect_embedded_payments_config_claimSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Whether the embedded component is enabled.',
      type: 'boolean',
    },
    features: {
      $ref: '#/components/schemas/connect_embedded_payments_features',
    },
  },
  required: ['enabled', 'features'],
  title: 'ConnectEmbeddedPaymentsConfigClaim',
  type: 'object',
  'x-expandableFields': ['features'],
} as const;

export const connect_embedded_payments_featuresSchema = {
  description: '',
  properties: {
    capture_payments: {
      description: 'Whether to allow capturing and cancelling payment intents. This is `true` by default.',
      type: 'boolean',
    },
    destination_on_behalf_of_charge_management: {
      description:
        'Whether to allow connected accounts to manage destination charges that are created on behalf of them. This is `false` by default.',
      type: 'boolean',
    },
    dispute_management: {
      description:
        'Whether to allow responding to disputes, including submitting evidence and accepting disputes. This is `true` by default.',
      type: 'boolean',
    },
    refund_management: {
      description: 'Whether to allow sending refunds. This is `true` by default.',
      type: 'boolean',
    },
  },
  required: [
    'capture_payments',
    'destination_on_behalf_of_charge_management',
    'dispute_management',
    'refund_management',
  ],
  title: 'ConnectEmbeddedPaymentsFeatures',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const connect_embedded_payouts_config_claimSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Whether the embedded component is enabled.',
      type: 'boolean',
    },
    features: {
      $ref: '#/components/schemas/connect_embedded_payouts_features',
    },
  },
  required: ['enabled', 'features'],
  title: 'ConnectEmbeddedPayoutsConfigClaim',
  type: 'object',
  'x-expandableFields': ['features'],
} as const;

export const connect_embedded_payouts_featuresSchema = {
  description: '',
  properties: {
    edit_payout_schedule: {
      description:
        'Whether to allow payout schedule to be changed. Default `true` when Stripe owns Loss Liability, default `false` otherwise.',
      type: 'boolean',
    },
    external_account_collection: {
      description:
        'Whether to allow platforms to control bank account collection for their connected accounts. This feature can only be false for custom accounts (or accounts where the platform is compliance owner). Otherwise, bank account collection is determined by compliance requirements.',
      type: 'boolean',
    },
    instant_payouts: {
      description:
        'Whether to allow creation of instant payouts. Default `true` when Stripe owns Loss Liability, default `false` otherwise.',
      type: 'boolean',
    },
    standard_payouts: {
      description:
        'Whether to allow creation of standard payouts. Default `true` when Stripe owns Loss Liability, default `false` otherwise.',
      type: 'boolean',
    },
  },
  required: ['edit_payout_schedule', 'external_account_collection', 'instant_payouts', 'standard_payouts'],
  title: 'ConnectEmbeddedPayoutsFeatures',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const country_specSchema = {
  description: `Stripe needs to collect certain pieces of information about each account
created. These requirements can differ depending on the account's country. The
Country Specs API makes these rules available to your integration.

You can also view the information from this API call as [an online
guide](/docs/connect/required-verification-information).`,
  properties: {
    default_currency: {
      description: 'The default currency for this country. This applies to both payment methods and bank accounts.',
      maxLength: 5000,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object. Represented as the ISO country code for this country.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['country_spec'],
      type: 'string',
    },
    supported_bank_account_currencies: {
      additionalProperties: {
        items: {
          maxLength: 5000,
          type: 'string',
        },
        type: 'array',
      },
      description: 'Currencies that can be accepted in the specific country (for transfers).',
      type: 'object',
    },
    supported_payment_currencies: {
      description: 'Currencies that can be accepted in the specified country (for payments).',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    supported_payment_methods: {
      description:
        'Payment methods available in the specified country. You may need to enable some payment methods (e.g., [ACH](https://stripe.com/docs/ach)) on your account before they appear in this list. The `stripe` payment method refers to [charging through your platform](https://stripe.com/docs/connect/destination-charges).',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    supported_transfer_countries: {
      description: 'Countries that can accept transfers from the specified country.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    verification_fields: {
      $ref: '#/components/schemas/country_spec_verification_fields',
    },
  },
  required: [
    'default_currency',
    'id',
    'object',
    'supported_bank_account_currencies',
    'supported_payment_currencies',
    'supported_payment_methods',
    'supported_transfer_countries',
    'verification_fields',
  ],
  title: 'CountrySpec',
  type: 'object',
  'x-expandableFields': ['verification_fields'],
  'x-resourceId': 'country_spec',
} as const;

export const country_spec_verification_field_detailsSchema = {
  description: '',
  properties: {
    additional: {
      description: 'Additional fields which are only required for some users.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    minimum: {
      description: 'Fields which every account must eventually provide.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['additional', 'minimum'],
  title: 'CountrySpecVerificationFieldDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const country_spec_verification_fieldsSchema = {
  description: '',
  properties: {
    company: {
      $ref: '#/components/schemas/country_spec_verification_field_details',
    },
    individual: {
      $ref: '#/components/schemas/country_spec_verification_field_details',
    },
  },
  required: ['company', 'individual'],
  title: 'CountrySpecVerificationFields',
  type: 'object',
  'x-expandableFields': ['company', 'individual'],
} as const;

export const couponSchema = {
  description: `A coupon contains information about a percent-off or amount-off discount you
might want to apply to a customer. Coupons may be applied to [subscriptions](https://stripe.com/docs/api#subscriptions), [invoices](https://stripe.com/docs/api#invoices),
[checkout sessions](https://stripe.com/docs/api/checkout/sessions), [quotes](https://stripe.com/docs/api#quotes), and more. Coupons do not work with conventional one-off [charges](https://stripe.com/docs/api#create_charge) or [payment intents](https://stripe.com/docs/api/payment_intents).`,
  properties: {
    amount_off: {
      description:
        'Amount (in the `currency` specified) that will be taken off the subtotal of any invoices for this customer.',
      nullable: true,
      type: 'integer',
    },
    applies_to: {
      $ref: '#/components/schemas/coupon_applies_to',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'If `amount_off` has been set, the three-letter [ISO code for the currency](https://stripe.com/docs/currencies) of the amount to take off.',
      nullable: true,
      type: 'string',
    },
    currency_options: {
      additionalProperties: {
        $ref: '#/components/schemas/coupon_currency_option',
      },
      description:
        'Coupons defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).',
      type: 'object',
    },
    duration: {
      description:
        'One of `forever`, `once`, and `repeating`. Describes how long a customer who applies this coupon will get the discount.',
      enum: ['forever', 'once', 'repeating'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    duration_in_months: {
      description:
        'If `duration` is `repeating`, the number of months the coupon applies. Null if coupon `duration` is `forever` or `once`.',
      nullable: true,
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    max_redemptions: {
      description:
        'Maximum number of times this coupon can be redeemed, in total, across all customers, before it is no longer valid.',
      nullable: true,
      type: 'integer',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    name: {
      description: 'Name of the coupon displayed to customers on for instance invoices or receipts.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['coupon'],
      type: 'string',
    },
    percent_off: {
      description:
        'Percent that will be taken off the subtotal of any invoices for this customer for the duration of the coupon. For example, a coupon with percent_off of 50 will make a $ (or local equivalent)100 invoice $ (or local equivalent)50 instead.',
      nullable: true,
      type: 'number',
    },
    redeem_by: {
      description: 'Date after which the coupon can no longer be redeemed.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    times_redeemed: {
      description: 'Number of times this coupon has been applied to a customer.',
      type: 'integer',
    },
    valid: {
      description: 'Taking account of the above properties, whether this coupon can still be applied to a customer.',
      type: 'boolean',
    },
  },
  required: ['created', 'duration', 'id', 'livemode', 'object', 'times_redeemed', 'valid'],
  title: 'Coupon',
  type: 'object',
  'x-expandableFields': ['applies_to', 'currency_options'],
  'x-resourceId': 'coupon',
} as const;

export const coupon_applies_toSchema = {
  description: '',
  properties: {
    products: {
      description: 'A list of product IDs this coupon applies to',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['products'],
  title: 'CouponAppliesTo',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const coupon_currency_optionSchema = {
  description: '',
  properties: {
    amount_off: {
      description:
        'Amount (in the `currency` specified) that will be taken off the subtotal of any invoices for this customer.',
      type: 'integer',
    },
  },
  required: ['amount_off'],
  title: 'CouponCurrencyOption',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const credit_noteSchema = {
  description: `Issue a credit note to adjust an invoice's amount after the invoice is finalized.

Related guide: [Credit notes](https://stripe.com/docs/billing/invoices/credit-notes)`,
  properties: {
    amount: {
      description:
        'The integer amount in cents (or local equivalent) representing the total amount of the credit note, including tax.',
      type: 'integer',
    },
    amount_shipping: {
      description: 'This is the sum of all the shipping amounts.',
      type: 'integer',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'ID of the customer.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    customer_balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer_balance_transaction',
        },
      ],
      description: 'Customer balance transaction related to this credit note.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer_balance_transaction',
          },
        ],
      },
    },
    discount_amount: {
      description:
        'The integer amount in cents (or local equivalent) representing the total amount of discount that was credited.',
      type: 'integer',
    },
    discount_amounts: {
      description: 'The aggregate amounts calculated per discount for all line items.',
      items: {
        $ref: '#/components/schemas/discounts_resource_discount_amount',
      },
      type: 'array',
    },
    effective_at: {
      description:
        "The date when this credit note is in effect. Same as `created` unless overwritten. When defined, this value replaces the system-generated 'Date of issue' printed on the credit note PDF.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'ID of the invoice.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    lines: {
      description: 'Line items that make up the credit note',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/credit_note_line_item',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'CreditNoteLinesList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    memo: {
      description: 'Customer-facing text that appears on the credit note PDF.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    number: {
      description:
        'A unique number that identifies this particular credit note and appears on the PDF of the credit note and its associated invoice.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['credit_note'],
      type: 'string',
    },
    out_of_band_amount: {
      description: 'Amount that was credited outside of Stripe.',
      nullable: true,
      type: 'integer',
    },
    pdf: {
      description: 'The link to download the PDF of the credit note.',
      maxLength: 5000,
      type: 'string',
    },
    reason: {
      description:
        'Reason for issuing this credit note, one of `duplicate`, `fraudulent`, `order_change`, or `product_unsatisfactory`',
      enum: ['duplicate', 'fraudulent', 'order_change', 'product_unsatisfactory'],
      nullable: true,
      type: 'string',
    },
    refund: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/refund',
        },
      ],
      description: 'Refund related to this credit note.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/refund',
          },
        ],
      },
    },
    shipping_cost: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_shipping_cost',
        },
      ],
      description: 'The details of the cost of shipping, including the ShippingRate applied to the invoice.',
      nullable: true,
    },
    status: {
      description:
        'Status of this credit note, one of `issued` or `void`. Learn more about [voiding credit notes](https://stripe.com/docs/billing/invoices/credit-notes#voiding).',
      enum: ['issued', 'void'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    subtotal: {
      description:
        'The integer amount in cents (or local equivalent) representing the amount of the credit note, excluding exclusive tax and invoice level discounts.',
      type: 'integer',
    },
    subtotal_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the amount of the credit note, excluding all tax and invoice level discounts.',
      nullable: true,
      type: 'integer',
    },
    tax_amounts: {
      description: 'The aggregate amounts calculated per tax rate for all line items.',
      items: {
        $ref: '#/components/schemas/credit_note_tax_amount',
      },
      type: 'array',
    },
    total: {
      description:
        'The integer amount in cents (or local equivalent) representing the total amount of the credit note, including tax and all discount.',
      type: 'integer',
    },
    total_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the total amount of the credit note, excluding tax, but including discounts.',
      nullable: true,
      type: 'integer',
    },
    type: {
      description:
        'Type of this credit note, one of `pre_payment` or `post_payment`. A `pre_payment` credit note means it was issued when the invoice was open. A `post_payment` credit note means it was issued when the invoice was paid.',
      enum: ['post_payment', 'pre_payment'],
      type: 'string',
    },
    voided_at: {
      description: 'The time that the credit note was voided.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  required: [
    'amount',
    'amount_shipping',
    'created',
    'currency',
    'customer',
    'discount_amount',
    'discount_amounts',
    'id',
    'invoice',
    'lines',
    'livemode',
    'number',
    'object',
    'pdf',
    'status',
    'subtotal',
    'tax_amounts',
    'total',
    'type',
  ],
  title: 'CreditNote',
  type: 'object',
  'x-expandableFields': [
    'customer',
    'customer_balance_transaction',
    'discount_amounts',
    'invoice',
    'lines',
    'refund',
    'shipping_cost',
    'tax_amounts',
  ],
  'x-resourceId': 'credit_note',
} as const;

export const credit_note_line_itemSchema = {
  description: 'The credit note line item object',
  properties: {
    amount: {
      description:
        'The integer amount in cents (or local equivalent) representing the gross amount being credited for this line item, excluding (exclusive) tax and discounts.',
      type: 'integer',
    },
    amount_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the amount being credited for this line item, excluding all tax and discounts.',
      nullable: true,
      type: 'integer',
    },
    description: {
      description: 'Description of the item being credited.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    discount_amount: {
      description:
        'The integer amount in cents (or local equivalent) representing the discount being credited for this line item.',
      type: 'integer',
    },
    discount_amounts: {
      description: 'The amount of discount calculated per discount for this line item',
      items: {
        $ref: '#/components/schemas/discounts_resource_discount_amount',
      },
      type: 'array',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice_line_item: {
      description: 'ID of the invoice line item being credited',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['credit_note_line_item'],
      type: 'string',
    },
    quantity: {
      description: 'The number of units of product being credited.',
      nullable: true,
      type: 'integer',
    },
    tax_amounts: {
      description: 'The amount of tax calculated per tax rate for this line item',
      items: {
        $ref: '#/components/schemas/credit_note_tax_amount',
      },
      type: 'array',
    },
    tax_rates: {
      description: 'The tax rates which apply to the line item.',
      items: {
        $ref: '#/components/schemas/tax_rate',
      },
      type: 'array',
    },
    type: {
      description:
        'The type of the credit note line item, one of `invoice_line_item` or `custom_line_item`. When the type is `invoice_line_item` there is an additional `invoice_line_item` property on the resource the value of which is the id of the credited line item on the invoice.',
      enum: ['custom_line_item', 'invoice_line_item'],
      type: 'string',
    },
    unit_amount: {
      description: 'The cost of each unit of product being credited.',
      nullable: true,
      type: 'integer',
    },
    unit_amount_decimal: {
      description: 'Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
    unit_amount_excluding_tax: {
      description:
        'The amount in cents (or local equivalent) representing the unit amount being credited for this line item, excluding all tax and discounts.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'discount_amount',
    'discount_amounts',
    'id',
    'livemode',
    'object',
    'tax_amounts',
    'tax_rates',
    'type',
  ],
  title: 'CreditNoteLineItem',
  type: 'object',
  'x-expandableFields': ['discount_amounts', 'tax_amounts', 'tax_rates'],
  'x-resourceId': 'credit_note_line_item',
} as const;

export const credit_note_tax_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount, in cents (or local equivalent), of the tax.',
      type: 'integer',
    },
    inclusive: {
      description: 'Whether this tax amount is inclusive or exclusive.',
      type: 'boolean',
    },
    tax_rate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/tax_rate',
        },
      ],
      description: 'The tax rate that was applied to get this tax amount.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/tax_rate',
          },
        ],
      },
    },
    taxability_reason: {
      description:
        'The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.',
      enum: [
        'customer_exempt',
        'not_collecting',
        'not_subject_to_tax',
        'not_supported',
        'portion_product_exempt',
        'portion_reduced_rated',
        'portion_standard_rated',
        'product_exempt',
        'product_exempt_holiday',
        'proportionally_rated',
        'reduced_rated',
        'reverse_charge',
        'standard_rated',
        'taxable_basis_reduced',
        'zero_rated',
      ],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    taxable_amount: {
      description: 'The amount on which tax is calculated, in cents (or local equivalent).',
      nullable: true,
      type: 'integer',
    },
  },
  required: ['amount', 'inclusive', 'tax_rate'],
  title: 'CreditNoteTaxAmount',
  type: 'object',
  'x-expandableFields': ['tax_rate'],
} as const;

export const currency_optionSchema = {
  description: '',
  properties: {
    custom_unit_amount: {
      anyOf: [
        {
          $ref: '#/components/schemas/custom_unit_amount',
        },
      ],
      description:
        'When set, provides configuration for the amount to be adjusted by the customer during Checkout Sessions and Payment Links.',
      nullable: true,
    },
    tax_behavior: {
      description:
        'Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.',
      enum: ['exclusive', 'inclusive', 'unspecified'],
      nullable: true,
      type: 'string',
    },
    tiers: {
      description:
        'Each element represents a pricing tier. This parameter requires `billing_scheme` to be set to `tiered`. See also the documentation for `billing_scheme`.',
      items: {
        $ref: '#/components/schemas/price_tier',
      },
      type: 'array',
    },
    unit_amount: {
      description:
        'The unit amount in cents (or local equivalent) to be charged, represented as a whole integer if possible. Only set if `billing_scheme=per_unit`.',
      nullable: true,
      type: 'integer',
    },
    unit_amount_decimal: {
      description:
        'The unit amount in cents (or local equivalent) to be charged, represented as a decimal string with at most 12 decimal places. Only set if `billing_scheme=per_unit`.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
  },
  title: 'CurrencyOption',
  type: 'object',
  'x-expandableFields': ['custom_unit_amount', 'tiers'],
} as const;

export const custom_unit_amountSchema = {
  description: '',
  properties: {
    maximum: {
      description: 'The maximum unit amount the customer can specify for this item.',
      nullable: true,
      type: 'integer',
    },
    minimum: {
      description:
        'The minimum unit amount the customer can specify for this item. Must be at least the minimum charge amount.',
      nullable: true,
      type: 'integer',
    },
    preset: {
      description: 'The starting unit amount which can be updated by the customer.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'CustomUnitAmount',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const customerSchema = {
  description: `This object represents a customer of your business. Use it to create recurring charges and track payments that belong to the same customer.

Related guide: [Save a card during payment](https://stripe.com/docs/payments/save-during-payment)`,
  properties: {
    address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description: "The customer's address.",
      nullable: true,
    },
    balance: {
      description:
        "The current balance, if any, that's stored on the customer. If negative, the customer has credit to apply to their next invoice. If positive, the customer has an amount owed that's added to their next invoice. The balance only considers amounts that Stripe hasn't successfully applied to any invoice. It doesn't reflect unpaid invoices. This balance is only taken into account after invoices finalize.",
      type: 'integer',
    },
    cash_balance: {
      anyOf: [
        {
          $ref: '#/components/schemas/cash_balance',
        },
      ],
      description:
        'The current funds being held by Stripe on behalf of the customer. You can apply these funds towards payment intents when the source is "cash_balance". The `settings[reconciliation_mode]` field describes if these funds apply to these payment intents manually or automatically.',
      nullable: true,
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO code for the currency](https://stripe.com/docs/currencies) the customer can be charged in for recurring billing purposes.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    default_source: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/bank_account',
        },
        {
          $ref: '#/components/schemas/card',
        },
        {
          $ref: '#/components/schemas/source',
        },
      ],
      description: `ID of the default payment source for the customer.

If you use payment methods created through the PaymentMethods API, see the [invoice_settings.default_payment_method](https://stripe.com/docs/api/customers/object#customer_object-invoice_settings-default_payment_method) field instead.`,
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/bank_account',
          },
          {
            $ref: '#/components/schemas/card',
          },
          {
            $ref: '#/components/schemas/source',
          },
        ],
      },
      'x-stripeBypassValidation': true,
    },
    delinquent: {
      description: `Tracks the most recent state change on any invoice belonging to the customer. Paying an invoice or marking it uncollectible via the API will set this field to false. An automatic payment failure or passing the \`invoice.due_date\` will set this field to \`true\`.

If an invoice becomes uncollectible by [dunning](https://stripe.com/docs/billing/automatic-collection), \`delinquent\` doesn't reset to \`false\`.

If you care whether the customer has paid their most recent subscription invoice, use \`subscription.status\` instead. Paying or marking uncollectible any customer invoice regardless of whether it is the latest invoice for a subscription will always set this field to \`false\`.`,
      nullable: true,
      type: 'boolean',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    discount: {
      anyOf: [
        {
          $ref: '#/components/schemas/discount',
        },
      ],
      description: 'Describes the current discount active on the customer, if there is one.',
      nullable: true,
    },
    email: {
      description: "The customer's email address.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice_credit_balance: {
      additionalProperties: {
        type: 'integer',
      },
      description:
        "The current multi-currency balances, if any, that's stored on the customer. If positive in a currency, the customer has a credit to apply to their next invoice denominated in that currency. If negative, the customer has an amount owed that's added to their next invoice denominated in that currency. These balances don't apply to unpaid invoices. They solely track amounts that Stripe hasn't successfully applied to any invoice. Stripe only applies a balance in a specific currency to an invoice after that invoice (which is in the same currency) finalizes.",
      type: 'object',
    },
    invoice_prefix: {
      description: 'The prefix for the customer used to generate unique invoice numbers.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_settings: {
      $ref: '#/components/schemas/invoice_setting_customer_setting',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    name: {
      description: "The customer's full name or business name.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    next_invoice_sequence: {
      description: "The suffix of the customer's next invoice number (for example, 0001).",
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['customer'],
      type: 'string',
    },
    phone: {
      description: "The customer's phone number.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_locales: {
      description: "The customer's preferred locales (languages), ordered by preference.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description: 'Mailing and shipping address for the customer. Appears on invoices emailed to this customer.',
      nullable: true,
    },
    sources: {
      description: "The customer's payment sources, if any.",
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            anyOf: [
              {
                $ref: '#/components/schemas/bank_account',
              },
              {
                $ref: '#/components/schemas/card',
              },
              {
                $ref: '#/components/schemas/source',
              },
            ],
            title: 'Polymorphic',
            'x-stripeBypassValidation': true,
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'ApmsSourcesSourceList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    subscriptions: {
      description: "The customer's current subscriptions, if any.",
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/subscription',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'SubscriptionList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    tax: {
      $ref: '#/components/schemas/customer_tax',
    },
    tax_exempt: {
      description: `Describes the customer's tax exemption status, which is \`none\`, \`exempt\`, or \`reverse\`. When set to \`reverse\`, invoice and receipt PDFs include the following text: **"Reverse charge"**.`,
      enum: ['exempt', 'none', 'reverse'],
      nullable: true,
      type: 'string',
    },
    tax_ids: {
      description: "The customer's tax IDs.",
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/tax_id',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'TaxIDsList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    test_clock: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/test_helpers.test_clock',
        },
      ],
      description: 'ID of the test clock that this customer belongs to.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/test_helpers.test_clock',
          },
        ],
      },
    },
  },
  required: ['created', 'id', 'livemode', 'object'],
  title: 'Customer',
  type: 'object',
  'x-expandableFields': [
    'address',
    'cash_balance',
    'default_source',
    'discount',
    'invoice_settings',
    'shipping',
    'sources',
    'subscriptions',
    'tax',
    'tax_ids',
    'test_clock',
  ],
  'x-resourceId': 'customer',
} as const;

export const customer_acceptanceSchema = {
  description: '',
  properties: {
    accepted_at: {
      description: 'The time that the customer accepts the mandate.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    offline: {
      $ref: '#/components/schemas/offline_acceptance',
    },
    online: {
      $ref: '#/components/schemas/online_acceptance',
    },
    type: {
      description: 'The mandate includes the type of customer acceptance information, such as: `online` or `offline`.',
      enum: ['offline', 'online'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'customer_acceptance',
  type: 'object',
  'x-expandableFields': ['offline', 'online'],
} as const;

export const customer_balance_customer_balance_settingsSchema = {
  description: '',
  properties: {
    reconciliation_mode: {
      description: 'The configuration for how funds that land in the customer cash balance are reconciled.',
      enum: ['automatic', 'manual'],
      type: 'string',
    },
    using_merchant_default: {
      description:
        "A flag to indicate if reconciliation mode returned is the user's default or is specific to this customer cash balance",
      type: 'boolean',
    },
  },
  required: ['reconciliation_mode', 'using_merchant_default'],
  title: 'CustomerBalanceCustomerBalanceSettings',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_adjusted_for_overdraftSchema = {
  description: '',
  properties: {
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'The [Balance Transaction](https://stripe.com/docs/api/balance_transactions/object) that corresponds to funds taken out of your Stripe balance.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    linked_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer_cash_balance_transaction',
        },
      ],
      description:
        'The [Cash Balance Transaction](https://stripe.com/docs/api/cash_balance_transactions/object) that brought the customer balance negative, triggering the clawback of funds.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer_cash_balance_transaction',
          },
        ],
      },
    },
  },
  required: ['balance_transaction', 'linked_transaction'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceAdjustedForOverdraft',
  type: 'object',
  'x-expandableFields': ['balance_transaction', 'linked_transaction'],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_applied_to_payment_transactionSchema = {
  description: '',
  properties: {
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description:
        'The [Payment Intent](https://stripe.com/docs/api/payment_intents/object) that funds were applied to.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
  },
  required: ['payment_intent'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceAppliedToPaymentTransaction',
  type: 'object',
  'x-expandableFields': ['payment_intent'],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transactionSchema = {
  description: '',
  properties: {
    bank_transfer: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer',
    },
  },
  required: ['bank_transfer'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransaction',
  type: 'object',
  'x-expandableFields': ['bank_transfer'],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transferSchema =
  {
    description: '',
    properties: {
      eu_bank_transfer: {
        $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_eu_bank_transfer',
      },
      gb_bank_transfer: {
        $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_gb_bank_transfer',
      },
      jp_bank_transfer: {
        $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_jp_bank_transfer',
      },
      reference: {
        description: 'The user-supplied reference field on the bank transfer.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      type: {
        description:
          'The funding method type used to fund the customer balance. Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.',
        enum: ['eu_bank_transfer', 'gb_bank_transfer', 'jp_bank_transfer', 'mx_bank_transfer', 'us_bank_transfer'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      us_bank_transfer: {
        $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_us_bank_transfer',
      },
    },
    required: ['type'],
    title: 'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransactionResourceBankTransfer',
    type: 'object',
    'x-expandableFields': ['eu_bank_transfer', 'gb_bank_transfer', 'jp_bank_transfer', 'us_bank_transfer'],
  } as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_eu_bank_transferSchema =
  {
    description: '',
    properties: {
      bic: {
        description: 'The BIC of the bank of the sender of the funding.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      iban_last4: {
        description: 'The last 4 digits of the IBAN of the sender of the funding.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      sender_name: {
        description: 'The full name of the sender, as supplied by the sending bank.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
    },
    title:
      'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransactionResourceBankTransferResourceEuBankTransfer',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_gb_bank_transferSchema =
  {
    description: '',
    properties: {
      account_number_last4: {
        description: 'The last 4 digits of the account number of the sender of the funding.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      sender_name: {
        description: 'The full name of the sender, as supplied by the sending bank.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      sort_code: {
        description: 'The sort code of the bank of the sender of the funding',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
    },
    title:
      'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransactionResourceBankTransferResourceGbBankTransfer',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_jp_bank_transferSchema =
  {
    description: '',
    properties: {
      sender_bank: {
        description: 'The name of the bank of the sender of the funding.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      sender_branch: {
        description: 'The name of the bank branch of the sender of the funding.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
      sender_name: {
        description: 'The full name of the sender, as supplied by the sending bank.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
    },
    title:
      'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransactionResourceBankTransferResourceJpBankTransfer',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const customer_balance_resource_cash_balance_transaction_resource_funded_transaction_resource_bank_transfer_resource_us_bank_transferSchema =
  {
    description: '',
    properties: {
      network: {
        description: 'The banking network used for this funding.',
        enum: ['ach', 'domestic_wire_us', 'swift'],
        type: 'string',
      },
      sender_name: {
        description: 'The full name of the sender, as supplied by the sending bank.',
        maxLength: 5000,
        nullable: true,
        type: 'string',
      },
    },
    title:
      'CustomerBalanceResourceCashBalanceTransactionResourceFundedTransactionResourceBankTransferResourceUsBankTransfer',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const customer_balance_resource_cash_balance_transaction_resource_refunded_from_payment_transactionSchema = {
  description: '',
  properties: {
    refund: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/refund',
        },
      ],
      description:
        "The [Refund](https://stripe.com/docs/api/refunds/object) that moved these funds into the customer's cash balance.",
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/refund',
          },
        ],
      },
    },
  },
  required: ['refund'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceRefundedFromPaymentTransaction',
  type: 'object',
  'x-expandableFields': ['refund'],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_transferred_to_balanceSchema = {
  description: '',
  properties: {
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'The [Balance Transaction](https://stripe.com/docs/api/balance_transactions/object) that corresponds to funds transferred to your Stripe balance.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
  },
  required: ['balance_transaction'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceTransferredToBalance',
  type: 'object',
  'x-expandableFields': ['balance_transaction'],
} as const;

export const customer_balance_resource_cash_balance_transaction_resource_unapplied_from_payment_transactionSchema = {
  description: '',
  properties: {
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description:
        'The [Payment Intent](https://stripe.com/docs/api/payment_intents/object) that funds were unapplied from.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
  },
  required: ['payment_intent'],
  title: 'CustomerBalanceResourceCashBalanceTransactionResourceUnappliedFromPaymentTransaction',
  type: 'object',
  'x-expandableFields': ['payment_intent'],
} as const;

export const customer_balance_transactionSchema = {
  description: `Each customer has a [Balance](https://stripe.com/docs/api/customers/object#customer_object-balance) value,
which denotes a debit or credit that's automatically applied to their next invoice upon finalization.
You may modify the value directly by using the [update customer API](https://stripe.com/docs/api/customers/update),
or by creating a Customer Balance Transaction, which increments or decrements the customer's \`balance\` by the specified \`amount\`.

Related guide: [Customer balance](https://stripe.com/docs/billing/customer/balance)`,
  properties: {
    amount: {
      description:
        "The amount of the transaction. A negative value is a credit for the customer's balance, and a positive value is a debit to the customer's `balance`.",
      type: 'integer',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    credit_note: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/credit_note',
        },
      ],
      description: 'The ID of the credit note (if any) related to the transaction.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/credit_note',
          },
        ],
      },
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
      ],
      description: 'The ID of the customer the transaction belongs to.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
        ],
      },
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    ending_balance: {
      description:
        "The customer's `balance` after the transaction was applied. A negative value decreases the amount due on the customer's next invoice. A positive value increases the amount due on the customer's next invoice.",
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'The ID of the invoice (if any) related to the transaction.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['customer_balance_transaction'],
      type: 'string',
    },
    type: {
      description:
        'Transaction type: `adjustment`, `applied_to_invoice`, `credit_note`, `initial`, `invoice_overpaid`, `invoice_too_large`, `invoice_too_small`, `unspent_receiver_credit`, or `unapplied_from_invoice`. See the [Customer Balance page](https://stripe.com/docs/billing/customer/balance#types) to learn more about transaction types.',
      enum: [
        'adjustment',
        'applied_to_invoice',
        'credit_note',
        'initial',
        'invoice_overpaid',
        'invoice_too_large',
        'invoice_too_small',
        'migration',
        'unapplied_from_invoice',
        'unspent_receiver_credit',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['amount', 'created', 'currency', 'customer', 'ending_balance', 'id', 'livemode', 'object', 'type'],
  title: 'CustomerBalanceTransaction',
  type: 'object',
  'x-expandableFields': ['credit_note', 'customer', 'invoice'],
  'x-resourceId': 'customer_balance_transaction',
} as const;

export const customer_cash_balance_transactionSchema = {
  description: `Customers with certain payments enabled have a cash balance, representing funds that were paid
by the customer to a merchant, but have not yet been allocated to a payment. Cash Balance Transactions
represent when funds are moved into or out of this balance. This includes funding by the customer, allocation
to payments, and refunds to the customer.`,
  properties: {
    adjusted_for_overdraft: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_adjusted_for_overdraft',
    },
    applied_to_payment: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_applied_to_payment_transaction',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      maxLength: 5000,
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
      ],
      description: 'The customer whose available cash balance changed as a result of this transaction.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
        ],
      },
    },
    ending_balance: {
      description:
        'The total available cash balance for the specified currency after this transaction was applied. Represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      type: 'integer',
    },
    funded: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_funded_transaction',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    net_amount: {
      description:
        'The amount by which the cash balance changed, represented in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). A positive value represents funds being added to the cash balance, a negative value represents funds being removed from the cash balance.',
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['customer_cash_balance_transaction'],
      type: 'string',
    },
    refunded_from_payment: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_refunded_from_payment_transaction',
    },
    transferred_to_balance: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_transferred_to_balance',
    },
    type: {
      description:
        'The type of the cash balance transaction. New types may be added in future. See [Customer Balance](https://stripe.com/docs/payments/customer-balance#types) to learn more about these types.',
      enum: [
        'adjusted_for_overdraft',
        'applied_to_payment',
        'funded',
        'funding_reversed',
        'refunded_from_payment',
        'return_canceled',
        'return_initiated',
        'transferred_to_balance',
        'unapplied_from_payment',
      ],
      type: 'string',
    },
    unapplied_from_payment: {
      $ref: '#/components/schemas/customer_balance_resource_cash_balance_transaction_resource_unapplied_from_payment_transaction',
    },
  },
  required: ['created', 'currency', 'customer', 'ending_balance', 'id', 'livemode', 'net_amount', 'object', 'type'],
  title: 'CustomerCashBalanceTransaction',
  type: 'object',
  'x-expandableFields': [
    'adjusted_for_overdraft',
    'applied_to_payment',
    'customer',
    'funded',
    'refunded_from_payment',
    'transferred_to_balance',
    'unapplied_from_payment',
  ],
  'x-resourceId': 'customer_cash_balance_transaction',
} as const;

export const customer_sessionSchema = {
  description: `A customer session allows you to grant client access to Stripe's frontend SDKs (like StripeJs)
control over a customer.`,
  properties: {
    client_secret: {
      description: `The client secret of this customer session. Used on the client to set up secure access to the given \`customer\`.

The client secret can be used to provide access to \`customer\` from your frontend. It should not be stored, logged, or exposed to anyone other than the relevant customer. Make sure that you have TLS enabled on any page that includes the client secret.`,
      maxLength: 5000,
      type: 'string',
    },
    components: {
      $ref: '#/components/schemas/customer_session_resource_components',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
      ],
      description: 'The customer the customer session was created for.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
        ],
      },
    },
    expires_at: {
      description: 'The timestamp at which this customer session will expire.',
      format: 'unix-time',
      type: 'integer',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['customer_session'],
      type: 'string',
    },
  },
  required: ['client_secret', 'created', 'customer', 'expires_at', 'livemode', 'object'],
  title: 'CustomerSessionResourceCustomerSession',
  type: 'object',
  'x-expandableFields': ['components', 'customer'],
  'x-resourceId': 'customer_session',
} as const;

export const customer_session_resource_componentsSchema = {
  description: 'Configuration for the components supported by this customer session.',
  properties: {
    buy_button: {
      $ref: '#/components/schemas/customer_session_resource_components_resource_buy_button',
    },
    pricing_table: {
      $ref: '#/components/schemas/customer_session_resource_components_resource_pricing_table',
    },
  },
  required: ['buy_button', 'pricing_table'],
  title: 'CustomerSessionResourceComponents',
  type: 'object',
  'x-expandableFields': ['buy_button', 'pricing_table'],
} as const;

export const customer_session_resource_components_resource_buy_buttonSchema = {
  description: 'This hash contains whether the buy button is enabled.',
  properties: {
    enabled: {
      description: 'Whether the buy button is enabled.',
      type: 'boolean',
    },
  },
  required: ['enabled'],
  title: 'CustomerSessionResourceComponentsResourceBuyButton',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const customer_session_resource_components_resource_pricing_tableSchema = {
  description: 'This hash contains whether the pricing table is enabled.',
  properties: {
    enabled: {
      description: 'Whether the pricing table is enabled.',
      type: 'boolean',
    },
  },
  required: ['enabled'],
  title: 'CustomerSessionResourceComponentsResourcePricingTable',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const customer_taxSchema = {
  description: '',
  properties: {
    automatic_tax: {
      description: 'Surfaces if automatic tax computation is possible given the current customer location information.',
      enum: ['failed', 'not_collecting', 'supported', 'unrecognized_location'],
      type: 'string',
    },
    ip_address: {
      description: 'A recent IP address of the customer used for tax reporting and tax location inference.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    location: {
      anyOf: [
        {
          $ref: '#/components/schemas/customer_tax_location',
        },
      ],
      description: "The customer's location as identified by Stripe Tax.",
      nullable: true,
    },
  },
  required: ['automatic_tax'],
  title: 'CustomerTax',
  type: 'object',
  'x-expandableFields': ['location'],
} as const;

export const customer_tax_locationSchema = {
  description: '',
  properties: {
    country: {
      description: "The customer's country as identified by Stripe Tax.",
      maxLength: 5000,
      type: 'string',
    },
    source: {
      description: "The data source used to infer the customer's location.",
      enum: ['billing_address', 'ip_address', 'payment_method', 'shipping_destination'],
      type: 'string',
    },
    state: {
      description: "The customer's state, county, province, or region as identified by Stripe Tax.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['country', 'source'],
  title: 'CustomerTaxLocation',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const deleted_accountSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['account'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedAccount',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_account',
} as const;

export const deleted_apple_pay_domainSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['apple_pay_domain'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedApplePayDomain',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_apple_pay_domain',
} as const;

export const deleted_applicationSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    name: {
      description: 'The name of the application.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['application'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedApplication',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const deleted_bank_accountSchema = {
  description: '',
  properties: {
    currency: {
      description:
        'Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['bank_account'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedBankAccount',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const deleted_cardSchema = {
  description: '',
  properties: {
    currency: {
      description:
        'Three-letter [ISO code for the currency](https://stripe.com/docs/payouts) paid out to the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['card'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedCard',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const deleted_couponSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['coupon'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedCoupon',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_coupon',
} as const;

export const deleted_customerSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['customer'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedCustomer',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_customer',
} as const;

export const deleted_discountSchema = {
  description: '',
  properties: {
    checkout_session: {
      description:
        'The Checkout session that this coupon is applied to, if it is applied to a particular session in payment mode. Will not be present for subscription mode.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    coupon: {
      $ref: '#/components/schemas/coupon',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'The ID of the customer associated with this discount.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description:
        'The ID of the discount object. Discounts cannot be fetched by ID. Use `expand[]=discounts` in API calls to expand discount IDs in an array.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      description:
        "The invoice that the discount's coupon was applied to, if it was applied directly to a particular invoice.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_item: {
      description:
        "The invoice item `id` (or invoice line item `id` for invoice line items of type='subscription') that the discount's coupon was applied to, if it was applied directly to a particular invoice item or invoice line item.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['discount'],
      type: 'string',
    },
    promotion_code: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/promotion_code',
        },
      ],
      description: 'The promotion code applied to create this discount.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/promotion_code',
          },
        ],
      },
    },
    start: {
      description: 'Date that the coupon was applied.',
      format: 'unix-time',
      type: 'integer',
    },
    subscription: {
      description: 'The subscription that this coupon is applied to, if it is applied to a particular subscription.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    subscription_item: {
      description:
        'The subscription item that this coupon is applied to, if it is applied to a particular subscription item.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['coupon', 'deleted', 'id', 'object', 'start'],
  title: 'DeletedDiscount',
  type: 'object',
  'x-expandableFields': ['coupon', 'customer', 'promotion_code'],
  'x-resourceId': 'deleted_discount',
} as const;

export const deleted_external_accountSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/deleted_bank_account',
    },
    {
      $ref: '#/components/schemas/deleted_card',
    },
  ],
  title: 'Polymorphic',
  'x-resourceId': 'deleted_external_account',
  'x-stripeBypassValidation': true,
} as const;

export const deleted_invoiceSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['invoice'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedInvoice',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_invoice',
} as const;

export const deleted_invoiceitemSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['invoiceitem'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedInvoiceItem',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_invoiceitem',
} as const;

export const deleted_payment_sourceSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/deleted_bank_account',
    },
    {
      $ref: '#/components/schemas/deleted_card',
    },
  ],
  title: 'Polymorphic',
  'x-resourceId': 'deleted_payment_source',
  'x-stripeBypassValidation': true,
} as const;

export const deleted_personSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['person'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedPerson',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_person',
} as const;

export const deleted_planSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['plan'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedPlan',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_plan',
} as const;

export const deleted_priceSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['price'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedPrice',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const deleted_productSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['product'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedProduct',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_product',
} as const;

export const deleted_product_featureSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['product_feature'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedProductFeature',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_product_feature',
} as const;

export const deleted_radar_value_listSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['radar.value_list'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'RadarListDeletedList',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_radar.value_list',
} as const;

export const deleted_radar_value_list_itemSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['radar.value_list_item'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'RadarListDeletedListItem',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_radar.value_list_item',
} as const;

export const deleted_subscription_itemSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['subscription_item'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedSubscriptionItem',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_subscription_item',
} as const;

export const deleted_tax_idSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['tax_id'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'deleted_tax_id',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_tax_id',
} as const;

export const deleted_terminal_configurationSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['terminal.configuration'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'TerminalConfigurationDeletedConfiguration',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_terminal.configuration',
} as const;

export const deleted_terminal_locationSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['terminal.location'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'TerminalLocationDeletedLocation',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_terminal.location',
} as const;

export const deleted_terminal_readerSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['terminal.reader'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'TerminalReaderDeletedReader',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_terminal.reader',
} as const;

export const deleted_test_helpers_test_clockSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['test_helpers.test_clock'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'DeletedTestClock',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_test_helpers.test_clock',
} as const;

export const deleted_webhook_endpointSchema = {
  description: '',
  properties: {
    deleted: {
      description: 'Always true for a deleted object',
      enum: [true],
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['webhook_endpoint'],
      type: 'string',
    },
  },
  required: ['deleted', 'id', 'object'],
  title: 'NotificationWebhookEndpointDeleted',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'deleted_webhook_endpoint',
} as const;

export const destination_details_unimplementedSchema = {
  description: '',
  properties: {},
  title: 'destination_details_unimplemented',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const discountSchema = {
  description: `A discount represents the actual application of a [coupon](https://stripe.com/docs/api#coupons) or [promotion code](https://stripe.com/docs/api#promotion_codes).
It contains information about when the discount began, when it will end, and what it is applied to.

Related guide: [Applying discounts to subscriptions](https://stripe.com/docs/billing/subscriptions/discounts)`,
  properties: {
    checkout_session: {
      description:
        'The Checkout session that this coupon is applied to, if it is applied to a particular session in payment mode. Will not be present for subscription mode.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    coupon: {
      $ref: '#/components/schemas/coupon',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'The ID of the customer associated with this discount.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    end: {
      description:
        'If the coupon has a duration of `repeating`, the date that this discount will end. If the coupon has a duration of `once` or `forever`, this attribute will be null.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    id: {
      description:
        'The ID of the discount object. Discounts cannot be fetched by ID. Use `expand[]=discounts` in API calls to expand discount IDs in an array.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      description:
        "The invoice that the discount's coupon was applied to, if it was applied directly to a particular invoice.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_item: {
      description:
        "The invoice item `id` (or invoice line item `id` for invoice line items of type='subscription') that the discount's coupon was applied to, if it was applied directly to a particular invoice item or invoice line item.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['discount'],
      type: 'string',
    },
    promotion_code: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/promotion_code',
        },
      ],
      description: 'The promotion code applied to create this discount.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/promotion_code',
          },
        ],
      },
    },
    start: {
      description: 'Date that the coupon was applied.',
      format: 'unix-time',
      type: 'integer',
    },
    subscription: {
      description: 'The subscription that this coupon is applied to, if it is applied to a particular subscription.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    subscription_item: {
      description:
        'The subscription item that this coupon is applied to, if it is applied to a particular subscription item.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['coupon', 'id', 'object', 'start'],
  title: 'Discount',
  type: 'object',
  'x-expandableFields': ['coupon', 'customer', 'promotion_code'],
  'x-resourceId': 'discount',
} as const;

export const discounts_resource_discount_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount, in cents (or local equivalent), of the discount.',
      type: 'integer',
    },
    discount: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/discount',
        },
        {
          $ref: '#/components/schemas/deleted_discount',
        },
      ],
      description: 'The discount that was applied to get this discount amount.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/discount',
          },
          {
            $ref: '#/components/schemas/deleted_discount',
          },
        ],
      },
    },
  },
  required: ['amount', 'discount'],
  title: 'DiscountsResourceDiscountAmount',
  type: 'object',
  'x-expandableFields': ['discount'],
} as const;

export const discounts_resource_stackable_discountSchema = {
  description: '',
  properties: {
    coupon: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/coupon',
        },
      ],
      description: 'ID of the coupon to create a new discount for.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/coupon',
          },
        ],
      },
    },
    discount: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/discount',
        },
      ],
      description: 'ID of an existing discount on the object (or one of its ancestors) to reuse.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/discount',
          },
        ],
      },
    },
    promotion_code: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/promotion_code',
        },
      ],
      description: 'ID of the promotion code to create a new discount for.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/promotion_code',
          },
        ],
      },
    },
  },
  title: 'DiscountsResourceStackableDiscount',
  type: 'object',
  'x-expandableFields': ['coupon', 'discount', 'promotion_code'],
} as const;

export const disputeSchema = {
  description: `A dispute occurs when a customer questions your charge with their card issuer.
When this happens, you have the opportunity to respond to the dispute with
evidence that shows that the charge is legitimate.

Related guide: [Disputes and fraud](https://stripe.com/docs/disputes)`,
  properties: {
    amount: {
      description:
        'Disputed amount. Usually the amount of the charge, but it can differ (usually because of currency fluctuation or because only part of the order is disputed).',
      type: 'integer',
    },
    balance_transactions: {
      description:
        'List of zero, one, or two balance transactions that show funds withdrawn and reinstated to your Stripe account as a result of this dispute.',
      items: {
        $ref: '#/components/schemas/balance_transaction',
      },
      type: 'array',
    },
    charge: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/charge',
        },
      ],
      description: "ID of the charge that's disputed.",
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/charge',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    evidence: {
      $ref: '#/components/schemas/dispute_evidence',
    },
    evidence_details: {
      $ref: '#/components/schemas/dispute_evidence_details',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    is_charge_refundable: {
      description:
        "If true, it's still possible to refund the disputed payment. After the payment has been fully refunded, no further funds are withdrawn from your Stripe account as a result of this dispute.",
      type: 'boolean',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['dispute'],
      type: 'string',
    },
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description: "ID of the PaymentIntent that's disputed.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
    payment_method_details: {
      $ref: '#/components/schemas/dispute_payment_method_details',
    },
    reason: {
      description:
        'Reason given by cardholder for dispute. Possible values are `bank_cannot_process`, `check_returned`, `credit_not_processed`, `customer_initiated`, `debit_not_authorized`, `duplicate`, `fraudulent`, `general`, `incorrect_account_details`, `insufficient_funds`, `product_not_received`, `product_unacceptable`, `subscription_canceled`, or `unrecognized`. Learn more about [dispute reasons](https://stripe.com/docs/disputes/categories).',
      maxLength: 5000,
      type: 'string',
    },
    status: {
      description:
        'Current status of dispute. Possible values are `warning_needs_response`, `warning_under_review`, `warning_closed`, `needs_response`, `under_review`, `won`, or `lost`.',
      enum: [
        'lost',
        'needs_response',
        'under_review',
        'warning_closed',
        'warning_needs_response',
        'warning_under_review',
        'won',
      ],
      type: 'string',
    },
  },
  required: [
    'amount',
    'balance_transactions',
    'charge',
    'created',
    'currency',
    'evidence',
    'evidence_details',
    'id',
    'is_charge_refundable',
    'livemode',
    'metadata',
    'object',
    'reason',
    'status',
  ],
  title: 'Dispute',
  type: 'object',
  'x-expandableFields': [
    'balance_transactions',
    'charge',
    'evidence',
    'evidence_details',
    'payment_intent',
    'payment_method_details',
  ],
  'x-resourceId': 'dispute',
} as const;

export const dispute_evidenceSchema = {
  description: '',
  properties: {
    access_activity_log: {
      description:
        'Any server or activity logs showing proof that the customer accessed or downloaded the purchased digital product. This information should include IP addresses, corresponding timestamps, and any detailed recorded activity.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    billing_address: {
      description: 'The billing address provided by the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cancellation_policy: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Your subscription cancellation policy, as shown to the customer.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    cancellation_policy_disclosure: {
      description: 'An explanation of how and when the customer was shown your refund policy prior to purchase.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    cancellation_rebuttal: {
      description: "A justification for why the customer's subscription was not canceled.",
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    customer_communication: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any communication with the customer that you feel is relevant to your case. Examples include emails proving that the customer received the product or service, or demonstrating their use of or satisfaction with the product or service.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    customer_email_address: {
      description: 'The email address of the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_name: {
      description: 'The name of the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_purchase_ip: {
      description: 'The IP address that the customer used when making the purchase.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_signature: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        "(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) A relevant document or contract showing the customer's signature.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    duplicate_charge_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation for the prior charge that can uniquely identify the charge, such as a receipt, shipping label, work order, etc. This document should be paired with a similar document from the disputed payment that proves the two payments are separate.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    duplicate_charge_explanation: {
      description:
        'An explanation of the difference between the disputed charge versus the prior charge that appears to be a duplicate.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    duplicate_charge_id: {
      description: 'The Stripe ID for the prior charge which appears to be a duplicate of the disputed charge.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_description: {
      description: 'A description of the product or service that was sold.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    receipt: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any receipt or message sent to the customer notifying them of the charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    refund_policy: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Your refund policy, as shown to the customer.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    refund_policy_disclosure: {
      description: 'Documentation demonstrating that the customer was shown your refund policy prior to purchase.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    refund_refusal_explanation: {
      description: 'A justification for why the customer is not entitled to a refund.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
    service_date: {
      description:
        'The date on which the customer received or began receiving the purchased service, in a clear human-readable format.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    service_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation showing proof that a service was provided to the customer. This could include a copy of a signed contract, work order, or other form of written agreement.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    shipping_address: {
      description:
        'The address to which a physical product was shipped. You should try to include as complete address information as possible.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_carrier: {
      description:
        'The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc. If multiple carriers were used for this purchase, please separate them with commas.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_date: {
      description:
        'The date on which a physical product began its route to the shipping address, in a clear human-readable format.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        "(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Documentation showing proof that a product was shipped to the customer at the same address the customer provided to you. This could include a copy of the shipment receipt, shipping label, etc. It should show the customer's full shipping address, if possible.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    shipping_tracking_number: {
      description:
        'The tracking number for a physical product, obtained from the delivery service. If multiple tracking numbers were generated for this purchase, please separate them with commas.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    uncategorized_file: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Any additional evidence or statements.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    uncategorized_text: {
      description: 'Any additional evidence or statements.',
      maxLength: 150000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'DisputeEvidence',
  type: 'object',
  'x-expandableFields': [
    'cancellation_policy',
    'customer_communication',
    'customer_signature',
    'duplicate_charge_documentation',
    'receipt',
    'refund_policy',
    'service_documentation',
    'shipping_documentation',
    'uncategorized_file',
  ],
} as const;

export const dispute_evidence_detailsSchema = {
  description: '',
  properties: {
    due_by: {
      description:
        "Date by which evidence must be submitted in order to successfully challenge dispute. Will be 0 if the customer's bank or credit card company doesn't allow a response for this particular dispute.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    has_evidence: {
      description: 'Whether evidence has been staged for this dispute.',
      type: 'boolean',
    },
    past_due: {
      description:
        'Whether the last evidence submission was submitted past the due date. Defaults to `false` if no evidence submissions have occurred. If `true`, then delivery of the latest evidence is *not* guaranteed.',
      type: 'boolean',
    },
    submission_count: {
      description: 'The number of times evidence has been submitted. Typically, you may only submit evidence once.',
      type: 'integer',
    },
  },
  required: ['has_evidence', 'past_due', 'submission_count'],
  title: 'DisputeEvidenceDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const dispute_payment_method_detailsSchema = {
  description: '',
  properties: {
    card: {
      $ref: '#/components/schemas/dispute_payment_method_details_card',
    },
    klarna: {
      $ref: '#/components/schemas/dispute_payment_method_details_klarna',
    },
    paypal: {
      $ref: '#/components/schemas/dispute_payment_method_details_paypal',
    },
    type: {
      description: 'Payment method type.',
      enum: ['card', 'klarna', 'paypal'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'DisputePaymentMethodDetails',
  type: 'object',
  'x-expandableFields': ['card', 'klarna', 'paypal'],
} as const;

export const dispute_payment_method_details_cardSchema = {
  description: '',
  properties: {
    brand: {
      description:
        'Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      type: 'string',
    },
    network_reason_code: {
      description:
        "The card network's specific dispute reason code, which maps to one of Stripe's primary dispute categories to simplify response guidance. The [Network code map](https://stripe.com/docs/disputes/categories#network-code-map) lists all available dispute reason codes by network.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['brand'],
  title: 'DisputePaymentMethodDetailsCard',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const dispute_payment_method_details_klarnaSchema = {
  description: '',
  properties: {
    reason_code: {
      description: 'The reason for the dispute as defined by Klarna',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'DisputePaymentMethodDetailsKlarna',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const dispute_payment_method_details_paypalSchema = {
  description: '',
  properties: {
    case_id: {
      description: 'The ID of the dispute in PayPal.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reason_code: {
      description: 'The reason for the dispute as defined by PayPal',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'DisputePaymentMethodDetailsPaypal',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const email_sentSchema = {
  description: '',
  properties: {
    email_sent_at: {
      description: 'The timestamp when the email was sent.',
      format: 'unix-time',
      type: 'integer',
    },
    email_sent_to: {
      description: "The recipient's email address.",
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['email_sent_at', 'email_sent_to'],
  title: 'EmailSent',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const entitlements_active_entitlementSchema = {
  description: 'An active entitlement describes access to a feature for a customer.',
  properties: {
    feature: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/entitlements.feature',
        },
      ],
      description: 'The [Feature](https://stripe.com/docs/api/entitlements/feature) that the customer is entitled to.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/entitlements.feature',
          },
        ],
      },
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    lookup_key: {
      description: 'A unique key you provide as your own system identifier. This may be up to 80 characters.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['entitlements.active_entitlement'],
      type: 'string',
    },
  },
  required: ['feature', 'id', 'livemode', 'lookup_key', 'object'],
  title: 'ActiveEntitlement',
  type: 'object',
  'x-expandableFields': ['feature'],
  'x-resourceId': 'entitlements.active_entitlement',
} as const;

export const entitlements_featureSchema = {
  description: `A feature represents a monetizable ability or functionality in your system.
Features can be assigned to products, and when those products are purchased, Stripe will create an entitlement to the feature for the purchasing customer.`,
  properties: {
    active: {
      description:
        'Inactive features cannot be attached to new products and will not be returned from the features list endpoint.',
      type: 'boolean',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    lookup_key: {
      description: 'A unique key you provide as your own system identifier. This may be up to 80 characters.',
      maxLength: 5000,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    name: {
      description: "The feature's name, for your own purpose, not meant to be displayable to the customer.",
      maxLength: 80,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['entitlements.feature'],
      type: 'string',
    },
  },
  required: ['active', 'id', 'livemode', 'lookup_key', 'metadata', 'name', 'object'],
  title: 'Feature',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'entitlements.feature',
} as const;

export const ephemeral_keySchema = {
  description: '',
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    expires: {
      description: 'Time at which the key will expire. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['ephemeral_key'],
      type: 'string',
    },
    secret: {
      description: "The key's secret. You can use this value to make authorized requests to the Stripe API.",
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['created', 'expires', 'id', 'livemode', 'object'],
  title: 'EphemeralKey',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'ephemeral_key',
} as const;

export const errorSchema = {
  description: 'An error response from the Stripe API',
  properties: {
    error: {
      $ref: '#/components/schemas/api_errors',
    },
  },
  required: ['error'],
  type: 'object',
} as const;

export const eventSchema = {
  description: `Events are our way of letting you know when something interesting happens in
your account. When an interesting event occurs, we create a new \`Event\`
object. For example, when a charge succeeds, we create a \`charge.succeeded\`
event, and when an invoice payment attempt fails, we create an
\`invoice.payment_failed\` event. Certain API requests might create multiple
events. For example, if you create a new subscription for a
customer, you receive both a \`customer.subscription.created\` event and a
\`charge.succeeded\` event.

Events occur when the state of another API resource changes. The event's data
field embeds the resource's state at the time of the change. For
example, a \`charge.succeeded\` event contains a charge, and an
\`invoice.payment_failed\` event contains an invoice.

As with other API resources, you can use endpoints to retrieve an
[individual event](https://stripe.com/docs/api#retrieve_event) or a [list of events](https://stripe.com/docs/api#list_events)
from the API. We also have a separate
[webhooks](http://en.wikipedia.org/wiki/Webhook) system for sending the
\`Event\` objects directly to an endpoint on your server. You can manage
webhooks in your
[account settings](https://dashboard.stripe.com/account/webhooks). Learn how
to [listen for events](https://docs.stripe.com/webhooks)
so that your integration can automatically trigger reactions.

When using [Connect](https://docs.stripe.com/connect), you can also receive event notifications
that occur in connected accounts. For these events, there's an
additional \`account\` attribute in the received \`Event\` object.

We only guarantee access to events through the [Retrieve Event API](https://stripe.com/docs/api#retrieve_event)
for 30 days.`,
  properties: {
    account: {
      description: 'The connected account that originates the event.',
      maxLength: 5000,
      type: 'string',
    },
    api_version: {
      description:
        'The Stripe API version used to render `data`. This property is populated only for events on or after October 31, 2014.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    data: {
      $ref: '#/components/schemas/notification_event_data',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['event'],
      type: 'string',
    },
    pending_webhooks: {
      description:
        "Number of webhooks that haven't been successfully delivered (for example, to return a 20x response) to the URLs you specify.",
      type: 'integer',
    },
    request: {
      anyOf: [
        {
          $ref: '#/components/schemas/notification_event_request',
        },
      ],
      description: 'Information on the API request that triggers the event.',
      nullable: true,
    },
    type: {
      description: 'Description of the event (for example, `invoice.created` or `charge.refunded`).',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['created', 'data', 'id', 'livemode', 'object', 'pending_webhooks', 'type'],
  title: 'NotificationEvent',
  type: 'object',
  'x-expandableFields': ['data', 'request'],
  'x-resourceId': 'event',
} as const;

export const exchange_rateSchema = {
  description: `\`ExchangeRate\` objects allow you to determine the rates that Stripe is currently
using to convert from one currency to another. Since this number is variable
throughout the day, there are various reasons why you might want to know the current
rate (for example, to dynamically price an item for a user with a default
payment in a foreign currency).

Please refer to our [Exchange Rates API](https://stripe.com/docs/fx-rates) guide for more details.

*[Note: this integration path is supported but no longer recommended]* Additionally,
you can guarantee that a charge is made with an exchange rate that you expect is
current. To do so, you must pass in the exchange_rate to charges endpoints. If the
value is no longer up to date, the charge won't go through. Please refer to our
[Using with charges](https://stripe.com/docs/exchange-rates) guide for more details.

-----

&nbsp;

*This Exchange Rates API is a Beta Service and is subject to Stripe's terms of service. You may use the API solely for the purpose of transacting on Stripe. For example, the API may be queried in order to:*

- *localize prices for processing payments on Stripe*
- *reconcile Stripe transactions*
- *determine how much money to send to a connected account*
- *determine app fees to charge a connected account*

*Using this Exchange Rates API beta for any purpose other than to transact on Stripe is strictly prohibited and constitutes a violation of Stripe's terms of service.*`,
  properties: {
    id: {
      description:
        'Unique identifier for the object. Represented as the three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) in lowercase.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['exchange_rate'],
      type: 'string',
    },
    rates: {
      additionalProperties: {
        type: 'number',
      },
      description:
        'Hash where the keys are supported currencies and the values are the exchange rate at which the base id currency converts to the key currency.',
      type: 'object',
    },
  },
  required: ['id', 'object', 'rates'],
  title: 'ExchangeRate',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'exchange_rate',
} as const;

export const external_accountSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/bank_account',
    },
    {
      $ref: '#/components/schemas/card',
    },
  ],
  title: 'Polymorphic',
  'x-resourceId': 'external_account',
  'x-stripeBypassValidation': true,
} as const;

export const external_account_requirementsSchema = {
  description: '',
  properties: {
    currently_due: {
      description:
        'Fields that need to be collected to keep the external account enabled. If not collected by `current_deadline`, these fields appear in `past_due` as well, and the account is disabled.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    errors: {
      description:
        'Fields that are `currently_due` and need to be collected again because validation or verification failed.',
      items: {
        $ref: '#/components/schemas/account_requirements_error',
      },
      nullable: true,
      type: 'array',
    },
    past_due: {
      description:
        "Fields that weren't collected by `current_deadline`. These fields need to be collected to enable the external account.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    pending_verification: {
      description:
        "Fields that might become required depending on the results of verification or review. It's an empty array unless an asynchronous verification is pending. If verification fails, these fields move to `eventually_due`, `currently_due`, or `past_due`. Fields might appear in `eventually_due`, `currently_due`, or `past_due` and in `pending_verification` if verification fails but another verification is still pending.",
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'ExternalAccountRequirements',
  type: 'object',
  'x-expandableFields': ['errors'],
} as const;

export const feeSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Amount of the fee, in cents.',
      type: 'integer',
    },
    application: {
      description: 'ID of the Connect application that earned the fee.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description:
        'Type of the fee, one of: `application_fee`, `payment_method_passthrough_fee`, `stripe_fee` or `tax`.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['amount', 'currency', 'type'],
  title: 'Fee',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const fee_refundSchema = {
  description: `\`Application Fee Refund\` objects allow you to refund an application fee that
has previously been created but not yet refunded. Funds will be refunded to
the Stripe account from which the fee was originally collected.

Related guide: [Refunding application fees](https://stripe.com/docs/connect/destination-charges#refunding-app-fee)`,
  properties: {
    amount: {
      description: 'Amount, in cents (or local equivalent).',
      type: 'integer',
    },
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description: 'Balance transaction that describes the impact on your account balance.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    fee: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application_fee',
        },
      ],
      description: 'ID of the application fee that was refunded.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application_fee',
          },
        ],
      },
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['fee_refund'],
      type: 'string',
    },
  },
  required: ['amount', 'created', 'currency', 'fee', 'id', 'object'],
  title: 'FeeRefund',
  type: 'object',
  'x-expandableFields': ['balance_transaction', 'fee'],
  'x-resourceId': 'fee_refund',
} as const;

export const fileSchema = {
  description: `This object represents files hosted on Stripe's servers. You can upload
files with the [create file](https://stripe.com/docs/api#create_file) request
(for example, when uploading dispute evidence). Stripe also
creates files independently (for example, the results of a [Sigma scheduled
query](#scheduled_queries)).

Related guide: [File upload guide](https://stripe.com/docs/file-upload)`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    expires_at: {
      description: "The file expires and isn't available at this time in epoch seconds.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    filename: {
      description: 'The suitable name for saving the file to a filesystem.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    links: {
      description: 'A list of [file links](https://stripe.com/docs/api#file_links) that point at this file.',
      nullable: true,
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/file_link',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          pattern: '^/v1/file_links',
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'FileResourceFileLinkList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['file'],
      type: 'string',
    },
    purpose: {
      description: 'The [purpose](https://stripe.com/docs/file-upload#uploading-a-file) of the uploaded file.',
      enum: [
        'account_requirement',
        'additional_verification',
        'business_icon',
        'business_logo',
        'customer_signature',
        'dispute_evidence',
        'document_provider_identity_document',
        'finance_report_run',
        'identity_document',
        'identity_document_downloadable',
        'pci_document',
        'selfie',
        'sigma_scheduled_query',
        'tax_document_user_upload',
        'terminal_reader_splashscreen',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    size: {
      description: 'The size of the file object in bytes.',
      type: 'integer',
    },
    title: {
      description: 'A suitable title for the document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description: 'The returned file type (for example, `csv`, `pdf`, `jpg`, or `png`).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'Use your live secret API key to download the file from this URL.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['created', 'id', 'object', 'purpose', 'size'],
  title: 'File',
  type: 'object',
  'x-expandableFields': ['links'],
  'x-resourceId': 'file',
} as const;

export const file_linkSchema = {
  description: `To share the contents of a \`File\` object with non-Stripe users, you can
create a \`FileLink\`. \`FileLink\`s contain a URL that you can use to
retrieve the contents of the file without authentication.`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    expired: {
      description: 'Returns if the link is already expired.',
      type: 'boolean',
    },
    expires_at: {
      description: 'Time that the link expires.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    file: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description: 'The file object this link points to.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['file_link'],
      type: 'string',
    },
    url: {
      description: 'The publicly accessible URL to download the file.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['created', 'expired', 'file', 'id', 'livemode', 'metadata', 'object'],
  title: 'FileLink',
  type: 'object',
  'x-expandableFields': ['file'],
  'x-resourceId': 'file_link',
} as const;

export const financial_connections_accountSchema = {
  description:
    'A Financial Connections Account represents an account that exists outside of Stripe, to which you have been granted some degree of access.',
  properties: {
    account_holder: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_accountholder',
        },
      ],
      description: 'The account holder that this account belongs to.',
      nullable: true,
    },
    balance: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_balance',
        },
      ],
      description: "The most recent information about the account's balance.",
      nullable: true,
    },
    balance_refresh: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_balance_refresh',
        },
      ],
      description: 'The state of the most recent attempt to refresh the account balance.',
      nullable: true,
    },
    category: {
      description: 'The type of the account. Account category is further divided in `subcategory`.',
      enum: ['cash', 'credit', 'investment', 'other'],
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    display_name: {
      description:
        'A human-readable name that has been assigned to this account, either by the account holder or by the institution.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    institution_name: {
      description: 'The name of the institution that holds this account.',
      maxLength: 5000,
      type: 'string',
    },
    last4: {
      description: 'The last 4 digits of the account number. If present, this will be 4 numeric characters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['financial_connections.account'],
      type: 'string',
    },
    ownership: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/financial_connections.account_ownership',
        },
      ],
      description: "The most recent information about the account's owners.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/financial_connections.account_ownership',
          },
        ],
      },
    },
    ownership_refresh: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_ownership_refresh',
        },
      ],
      description: 'The state of the most recent attempt to refresh the account owners.',
      nullable: true,
    },
    permissions: {
      description: 'The list of permissions granted by this account.',
      items: {
        enum: ['balances', 'ownership', 'payment_method', 'transactions'],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    status: {
      description: 'The status of the link to the account.',
      enum: ['active', 'disconnected', 'inactive'],
      type: 'string',
    },
    subcategory: {
      description: `If \`category\` is \`cash\`, one of:

 - \`checking\`
 - \`savings\`
 - \`other\`

If \`category\` is \`credit\`, one of:

 - \`mortgage\`
 - \`line_of_credit\`
 - \`credit_card\`
 - \`other\`

If \`category\` is \`investment\` or \`other\`, this will be \`other\`.`,
      enum: ['checking', 'credit_card', 'line_of_credit', 'mortgage', 'other', 'savings'],
      type: 'string',
    },
    subscriptions: {
      description: 'The list of data refresh subscriptions requested on this account.',
      items: {
        enum: ['transactions'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
    supported_payment_method_types: {
      description:
        'The [PaymentMethod type](https://stripe.com/docs/api/payment_methods/object#payment_method_object-type)(s) that can be created from this account.',
      items: {
        enum: ['link', 'us_bank_account'],
        type: 'string',
      },
      type: 'array',
    },
    transaction_refresh: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_transaction_refresh',
        },
      ],
      description: 'The state of the most recent attempt to refresh the account transactions.',
      nullable: true,
    },
  },
  required: [
    'category',
    'created',
    'id',
    'institution_name',
    'livemode',
    'object',
    'status',
    'subcategory',
    'supported_payment_method_types',
  ],
  title: 'BankConnectionsResourceLinkedAccount',
  type: 'object',
  'x-expandableFields': [
    'account_holder',
    'balance',
    'balance_refresh',
    'ownership',
    'ownership_refresh',
    'transaction_refresh',
  ],
  'x-resourceId': 'financial_connections.account',
} as const;

export const financial_connections_account_ownerSchema = {
  description: 'Describes an owner of an account.',
  properties: {
    email: {
      description: 'The email address of the owner.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    name: {
      description: 'The full name of the owner.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['financial_connections.account_owner'],
      type: 'string',
    },
    ownership: {
      description: 'The ownership object that this owner belongs to.',
      maxLength: 5000,
      type: 'string',
    },
    phone: {
      description: 'The raw phone number of the owner.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    raw_address: {
      description: 'The raw physical address of the owner.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    refreshed_at: {
      description: 'The timestamp of the refresh that updated this owner.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  required: ['id', 'name', 'object', 'ownership'],
  title: 'BankConnectionsResourceOwner',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'financial_connections.account_owner',
} as const;

export const financial_connections_account_ownershipSchema = {
  description: 'Describes a snapshot of the owners of an account at a particular point in time.',
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['financial_connections.account_ownership'],
      type: 'string',
    },
    owners: {
      description: 'A paginated list of owners for this account.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/financial_connections.account_owner',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'BankConnectionsResourceOwnerList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
  },
  required: ['created', 'id', 'object', 'owners'],
  title: 'BankConnectionsResourceOwnership',
  type: 'object',
  'x-expandableFields': ['owners'],
} as const;

export const financial_connections_sessionSchema = {
  description:
    'A Financial Connections Session is the secure way to programmatically launch the client-side Stripe.js modal that lets your users link their accounts.',
  properties: {
    account_holder: {
      anyOf: [
        {
          $ref: '#/components/schemas/bank_connections_resource_accountholder',
        },
      ],
      description: 'The account holder for whom accounts are collected in this session.',
      nullable: true,
    },
    accounts: {
      description: 'The accounts that were collected as part of this Session.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/financial_connections.account',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          pattern: '^/v1/financial_connections/accounts',
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'BankConnectionsResourceLinkedAccountList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    client_secret: {
      description: 'A value that will be passed to the client to launch the authentication flow.',
      maxLength: 5000,
      type: 'string',
    },
    filters: {
      $ref: '#/components/schemas/bank_connections_resource_link_account_session_filters',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['financial_connections.session'],
      type: 'string',
    },
    permissions: {
      description: 'Permissions requested for accounts collected during this session.',
      items: {
        enum: ['balances', 'ownership', 'payment_method', 'transactions'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      type: 'array',
    },
    prefetch: {
      description: 'Data features requested to be retrieved upon account creation.',
      items: {
        enum: ['balances', 'ownership', 'transactions'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
    return_url: {
      description:
        'For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['accounts', 'client_secret', 'id', 'livemode', 'object', 'permissions'],
  title: 'BankConnectionsResourceLinkAccountSession',
  type: 'object',
  'x-expandableFields': ['account_holder', 'accounts', 'filters'],
  'x-resourceId': 'financial_connections.session',
} as const;

export const financial_connections_transactionSchema = {
  description: 'A Transaction represents a real transaction that affects a Financial Connections Account balance.',
  properties: {
    account: {
      description: 'The ID of the Financial Connections Account this transaction belongs to.',
      maxLength: 5000,
      type: 'string',
    },
    amount: {
      description: 'The amount of this transaction, in cents (or local equivalent).',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      maxLength: 5000,
      type: 'string',
    },
    description: {
      description: 'The description of this transaction.',
      maxLength: 5000,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['financial_connections.transaction'],
      type: 'string',
    },
    status: {
      description: 'The status of the transaction.',
      enum: ['pending', 'posted', 'void'],
      type: 'string',
    },
    status_transitions: {
      $ref: '#/components/schemas/bank_connections_resource_transaction_resource_status_transitions',
    },
    transacted_at: {
      description: 'Time at which the transaction was transacted. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    transaction_refresh: {
      description: 'The token of the transaction refresh that last updated or created this transaction.',
      maxLength: 5000,
      type: 'string',
    },
    updated: {
      description: 'Time at which the object was last updated. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
  },
  required: [
    'account',
    'amount',
    'currency',
    'description',
    'id',
    'livemode',
    'object',
    'status',
    'status_transitions',
    'transacted_at',
    'transaction_refresh',
    'updated',
  ],
  title: 'BankConnectionsResourceTransaction',
  type: 'object',
  'x-expandableFields': ['status_transitions'],
  'x-resourceId': 'financial_connections.transaction',
} as const;

export const financial_reporting_finance_report_run_run_parametersSchema = {
  description: '',
  properties: {
    columns: {
      description: 'The set of output columns requested for inclusion in the report run.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    connected_account: {
      description: 'Connected account ID by which to filter the report run.',
      maxLength: 5000,
      type: 'string',
    },
    currency: {
      description: 'Currency of objects to be included in the report run.',
      type: 'string',
    },
    interval_end: {
      description:
        "Ending timestamp of data to be included in the report run. Can be any UTC timestamp between 1 second after the user specified `interval_start` and 1 second before this report's last `data_available_end` value.",
      format: 'unix-time',
      type: 'integer',
    },
    interval_start: {
      description:
        "Starting timestamp of data to be included in the report run. Can be any UTC timestamp between 1 second after this report's `data_available_start` and 1 second before the user specified `interval_end` value.",
      format: 'unix-time',
      type: 'integer',
    },
    payout: {
      description: 'Payout ID by which to filter the report run.',
      maxLength: 5000,
      type: 'string',
    },
    reporting_category: {
      description: 'Category of balance transactions to be included in the report run.',
      maxLength: 5000,
      type: 'string',
    },
    timezone: {
      description:
        'Defaults to `Etc/UTC`. The output timezone for all timestamps in the report. A list of possible time zone values is maintained at the [IANA Time Zone Database](http://www.iana.org/time-zones). Has no effect on `interval_start` or `interval_end`.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'FinancialReportingFinanceReportRunRunParameters',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const forwarded_request_contextSchema = {
  description: 'Metadata about the forwarded request.',
  properties: {
    destination_duration: {
      description: 'The time it took in milliseconds for the destination endpoint to respond.',
      type: 'integer',
    },
    destination_ip_address: {
      description: 'The IP address of the destination.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['destination_duration', 'destination_ip_address'],
  title: 'ForwardedRequestContext',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const forwarded_request_detailsSchema = {
  description: 'Details about the request forwarded to the destination endpoint.',
  properties: {
    body: {
      description: 'The body payload to send to the destination endpoint.',
      maxLength: 5000,
      type: 'string',
    },
    headers: {
      description:
        'The headers to include in the forwarded request. Can be omitted if no additional headers (excluding Stripe-generated ones such as the Content-Type header) should be included.',
      items: {
        $ref: '#/components/schemas/forwarded_request_header',
      },
      type: 'array',
    },
    http_method: {
      description: 'The HTTP method used to call the destination endpoint.',
      enum: ['POST'],
      type: 'string',
    },
  },
  required: ['body', 'headers', 'http_method'],
  title: 'ForwardedRequestDetails',
  type: 'object',
  'x-expandableFields': ['headers'],
} as const;

export const forwarded_request_headerSchema = {
  description: 'Header data.',
  properties: {
    name: {
      description: 'The header name.',
      maxLength: 5000,
      type: 'string',
    },
    value: {
      description: 'The header value.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['name', 'value'],
  title: 'ForwardedRequestHeader',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const forwarded_response_detailsSchema = {
  description: 'Details about the response from the destination endpoint.',
  properties: {
    body: {
      description: 'The response body from the destination endpoint to Stripe.',
      maxLength: 5000,
      type: 'string',
    },
    headers: {
      description: 'HTTP headers that the destination endpoint returned.',
      items: {
        $ref: '#/components/schemas/forwarded_request_header',
      },
      type: 'array',
    },
    status: {
      description: 'The HTTP status code that the destination endpoint returned.',
      type: 'integer',
    },
  },
  required: ['body', 'headers', 'status'],
  title: 'ForwardedResponseDetails',
  type: 'object',
  'x-expandableFields': ['headers'],
} as const;

export const forwarding_requestSchema = {
  description: `Instructs Stripe to make a request on your behalf using the destination URL. The destination URL
is activated by Stripe at the time of onboarding. Stripe verifies requests with your credentials
provided during onboarding, and injects card details from the payment_method into the request.

Stripe redacts all sensitive fields and headers, including authentication credentials and card numbers,
before storing the request and response data in the forwarding Request object, which are subject to a
30-day retention period.

You can provide a Stripe idempotency key to make sure that requests with the same key result in only one
outbound request. The Stripe idempotency key provided should be unique and different from any idempotency
keys provided on the underlying third-party request.

Forwarding Requests are synchronous requests that return a response or time out according to
Stripe’s limits.

Related guide: [Forward card details to third-party API endpoints](https://docs.stripe.com/payments/forwarding).`,
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['forwarding.request'],
      type: 'string',
    },
    payment_method: {
      description:
        'The PaymentMethod to insert into the forwarded request. Forwarding previously consumed PaymentMethods is allowed.',
      maxLength: 5000,
      type: 'string',
    },
    replacements: {
      description: 'The field kinds to be replaced in the forwarded request.',
      items: {
        enum: ['card_cvc', 'card_expiry', 'card_number', 'cardholder_name'],
        type: 'string',
      },
      type: 'array',
    },
    request_context: {
      anyOf: [
        {
          $ref: '#/components/schemas/forwarded_request_context',
        },
      ],
      description: "Context about the request from Stripe's servers to the destination endpoint.",
      nullable: true,
    },
    request_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/forwarded_request_details',
        },
      ],
      description: 'The request that was sent to the destination endpoint. We redact any sensitive fields.',
      nullable: true,
    },
    response_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/forwarded_response_details',
        },
      ],
      description: 'The response that the destination endpoint returned to us. We redact any sensitive fields.',
      nullable: true,
    },
    url: {
      description: 'The destination URL for the forwarded request. Must be supported by the config.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['created', 'id', 'livemode', 'object', 'payment_method', 'replacements'],
  title: 'ForwardingRequest',
  type: 'object',
  'x-expandableFields': ['request_context', 'request_details', 'response_details'],
  'x-resourceId': 'forwarding.request',
} as const;

export const funding_instructionsSchema = {
  description: `Each customer has a [\`balance\`](https://stripe.com/docs/api/customers/object#customer_object-balance) that is
automatically applied to future invoices and payments using the \`customer_balance\` payment method.
Customers can fund this balance by initiating a bank transfer to any account in the
\`financial_addresses\` field.
Related guide: [Customer balance funding instructions](https://stripe.com/docs/payments/customer-balance/funding-instructions)`,
  properties: {
    bank_transfer: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      maxLength: 5000,
      type: 'string',
    },
    funding_type: {
      description: 'The `funding_type` of the returned instructions',
      enum: ['bank_transfer'],
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['funding_instructions'],
      type: 'string',
    },
  },
  required: ['bank_transfer', 'currency', 'funding_type', 'livemode', 'object'],
  title: 'CustomerBalanceFundingInstructionsCustomerBalanceFundingInstructions',
  type: 'object',
  'x-expandableFields': ['bank_transfer'],
  'x-resourceId': 'funding_instructions',
} as const;

export const funding_instructions_bank_transferSchema = {
  description: '',
  properties: {
    country: {
      description: 'The country of the bank account to fund',
      maxLength: 5000,
      type: 'string',
    },
    financial_addresses: {
      description: 'A list of financial addresses that can be used to fund a particular balance',
      items: {
        $ref: '#/components/schemas/funding_instructions_bank_transfer_financial_address',
      },
      type: 'array',
    },
    type: {
      description: 'The bank_transfer type',
      enum: ['eu_bank_transfer', 'jp_bank_transfer'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['country', 'financial_addresses', 'type'],
  title: 'FundingInstructionsBankTransfer',
  type: 'object',
  'x-expandableFields': ['financial_addresses'],
} as const;

export const funding_instructions_bank_transfer_aba_recordSchema = {
  description: 'ABA Records contain U.S. bank account details per the ABA format.',
  properties: {
    account_number: {
      description: 'The ABA account number',
      maxLength: 5000,
      type: 'string',
    },
    bank_name: {
      description: 'The bank name',
      maxLength: 5000,
      type: 'string',
    },
    routing_number: {
      description: 'The ABA routing number',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['account_number', 'bank_name', 'routing_number'],
  title: 'FundingInstructionsBankTransferABARecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const funding_instructions_bank_transfer_financial_addressSchema = {
  description: 'FinancialAddresses contain identifying information that resolves to a FinancialAccount.',
  properties: {
    aba: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_aba_record',
    },
    iban: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_iban_record',
    },
    sort_code: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_sort_code_record',
    },
    spei: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_spei_record',
    },
    supported_networks: {
      description: 'The payment networks supported by this FinancialAddress',
      items: {
        enum: ['ach', 'bacs', 'domestic_wire_us', 'fps', 'sepa', 'spei', 'swift', 'zengin'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      type: 'array',
    },
    swift: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_swift_record',
    },
    type: {
      description: 'The type of financial address',
      enum: ['aba', 'iban', 'sort_code', 'spei', 'swift', 'zengin'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    zengin: {
      $ref: '#/components/schemas/funding_instructions_bank_transfer_zengin_record',
    },
  },
  required: ['type'],
  title: 'FundingInstructionsBankTransferFinancialAddress',
  type: 'object',
  'x-expandableFields': ['aba', 'iban', 'sort_code', 'spei', 'swift', 'zengin'],
} as const;

export const funding_instructions_bank_transfer_iban_recordSchema = {
  description: 'Iban Records contain E.U. bank account details per the SEPA format.',
  properties: {
    account_holder_name: {
      description: 'The name of the person or business that owns the bank account',
      maxLength: 5000,
      type: 'string',
    },
    bic: {
      description: 'The BIC/SWIFT code of the account.',
      maxLength: 5000,
      type: 'string',
    },
    country: {
      description: 'Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).',
      maxLength: 5000,
      type: 'string',
    },
    iban: {
      description: 'The IBAN of the account.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['account_holder_name', 'bic', 'country', 'iban'],
  title: 'FundingInstructionsBankTransferIbanRecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const funding_instructions_bank_transfer_sort_code_recordSchema = {
  description: 'Sort Code Records contain U.K. bank account details per the sort code format.',
  properties: {
    account_holder_name: {
      description: 'The name of the person or business that owns the bank account',
      maxLength: 5000,
      type: 'string',
    },
    account_number: {
      description: 'The account number',
      maxLength: 5000,
      type: 'string',
    },
    sort_code: {
      description: 'The six-digit sort code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['account_holder_name', 'account_number', 'sort_code'],
  title: 'FundingInstructionsBankTransferSortCodeRecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const funding_instructions_bank_transfer_spei_recordSchema = {
  description: 'SPEI Records contain Mexico bank account details per the SPEI format.',
  properties: {
    bank_code: {
      description: 'The three-digit bank code',
      maxLength: 5000,
      type: 'string',
    },
    bank_name: {
      description: 'The short banking institution name',
      maxLength: 5000,
      type: 'string',
    },
    clabe: {
      description: 'The CLABE number',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['bank_code', 'bank_name', 'clabe'],
  title: 'FundingInstructionsBankTransferSpeiRecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const funding_instructions_bank_transfer_swift_recordSchema = {
  description: 'SWIFT Records contain U.S. bank account details per the SWIFT format.',
  properties: {
    account_number: {
      description: 'The account number',
      maxLength: 5000,
      type: 'string',
    },
    bank_name: {
      description: 'The bank name',
      maxLength: 5000,
      type: 'string',
    },
    swift_code: {
      description: 'The SWIFT code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['account_number', 'bank_name', 'swift_code'],
  title: 'FundingInstructionsBankTransferSwiftRecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const funding_instructions_bank_transfer_zengin_recordSchema = {
  description: 'Zengin Records contain Japan bank account details per the Zengin format.',
  properties: {
    account_holder_name: {
      description: 'The account holder name',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_number: {
      description: 'The account number',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_type: {
      description: 'The bank account type. In Japan, this can only be `futsu` or `toza`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_code: {
      description: 'The bank code of the account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'The bank name of the account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    branch_code: {
      description: 'The branch code of the account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    branch_name: {
      description: 'The branch name of the account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'FundingInstructionsBankTransferZenginRecord',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_data_document_report_date_of_birthSchema = {
  description: 'Point in Time',
  properties: {
    day: {
      description: 'Numerical day between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'Numerical month between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'GelatoDataDocumentReportDateOfBirth',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_data_document_report_expiration_dateSchema = {
  description: 'Point in Time',
  properties: {
    day: {
      description: 'Numerical day between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'Numerical month between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'GelatoDataDocumentReportExpirationDate',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_data_document_report_issued_dateSchema = {
  description: 'Point in Time',
  properties: {
    day: {
      description: 'Numerical day between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'Numerical month between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'GelatoDataDocumentReportIssuedDate',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_data_id_number_report_dateSchema = {
  description: 'Point in Time',
  properties: {
    day: {
      description: 'Numerical day between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'Numerical month between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'GelatoDataIdNumberReportDate',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_data_verified_outputs_dateSchema = {
  description: 'Point in Time',
  properties: {
    day: {
      description: 'Numerical day between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'Numerical month between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'GelatoDataVerifiedOutputsDate',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_document_reportSchema = {
  description: 'Result from a document check',
  properties: {
    address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description: 'Address as it appears in the document.',
      nullable: true,
    },
    dob: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_data_document_report_date_of_birth',
        },
      ],
      description: 'Date of birth as it appears in the document.',
      nullable: true,
    },
    error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_document_report_error',
        },
      ],
      description: 'Details on the verification error. Present when status is `unverified`.',
      nullable: true,
    },
    expiration_date: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_data_document_report_expiration_date',
        },
      ],
      description: 'Expiration date of the document.',
      nullable: true,
    },
    files: {
      description: 'Array of [File](https://stripe.com/docs/api/files) ids containing images for this document.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    first_name: {
      description: 'First name as it appears in the document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    issued_date: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_data_document_report_issued_date',
        },
      ],
      description: 'Issued date of the document.',
      nullable: true,
    },
    issuing_country: {
      description: 'Issuing country of the document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last_name: {
      description: 'Last name as it appears in the document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    number: {
      description: 'Document ID number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'Status of this `document` check.',
      enum: ['unverified', 'verified'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    type: {
      description: 'Type of the document.',
      enum: ['driving_license', 'id_card', 'passport'],
      nullable: true,
      type: 'string',
    },
  },
  required: ['status'],
  title: 'GelatoDocumentReport',
  type: 'object',
  'x-expandableFields': ['address', 'dob', 'error', 'expiration_date', 'issued_date'],
} as const;

export const gelato_document_report_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification failure.',
      enum: ['document_expired', 'document_type_not_supported', 'document_unverified_other'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    reason: {
      description:
        'A human-readable message giving the reason for the failure. These messages can be shown to your users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoDocumentReportError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_email_reportSchema = {
  description: 'Result from a email check',
  properties: {
    email: {
      description: 'Email to be verified.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_email_report_error',
        },
      ],
      description: 'Details on the verification error. Present when status is `unverified`.',
      nullable: true,
    },
    status: {
      description: 'Status of this `email` check.',
      enum: ['unverified', 'verified'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['status'],
  title: 'GelatoEmailReport',
  type: 'object',
  'x-expandableFields': ['error'],
} as const;

export const gelato_email_report_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification failure.',
      enum: ['email_unverified_other', 'email_verification_declined'],
      nullable: true,
      type: 'string',
    },
    reason: {
      description:
        'A human-readable message giving the reason for the failure. These messages can be shown to your users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoEmailReportError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_id_number_reportSchema = {
  description: 'Result from an id_number check',
  properties: {
    dob: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_data_id_number_report_date',
        },
      ],
      description: 'Date of birth.',
      nullable: true,
    },
    error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_id_number_report_error',
        },
      ],
      description: 'Details on the verification error. Present when status is `unverified`.',
      nullable: true,
    },
    first_name: {
      description: 'First name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id_number: {
      description: 'ID number. When `id_number_type` is `us_ssn`, only the last 4 digits are present.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id_number_type: {
      description: 'Type of ID number.',
      enum: ['br_cpf', 'sg_nric', 'us_ssn'],
      nullable: true,
      type: 'string',
    },
    last_name: {
      description: 'Last name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'Status of this `id_number` check.',
      enum: ['unverified', 'verified'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['status'],
  title: 'GelatoIdNumberReport',
  type: 'object',
  'x-expandableFields': ['dob', 'error'],
} as const;

export const gelato_id_number_report_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification failure.',
      enum: ['id_number_insufficient_document_data', 'id_number_mismatch', 'id_number_unverified_other'],
      nullable: true,
      type: 'string',
    },
    reason: {
      description:
        'A human-readable message giving the reason for the failure. These messages can be shown to your users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoIdNumberReportError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_phone_reportSchema = {
  description: 'Result from a phone check',
  properties: {
    error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_phone_report_error',
        },
      ],
      description: 'Details on the verification error. Present when status is `unverified`.',
      nullable: true,
    },
    phone: {
      description: 'Phone to be verified.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'Status of this `phone` check.',
      enum: ['unverified', 'verified'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['status'],
  title: 'GelatoPhoneReport',
  type: 'object',
  'x-expandableFields': ['error'],
} as const;

export const gelato_phone_report_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification failure.',
      enum: ['phone_unverified_other', 'phone_verification_declined'],
      nullable: true,
      type: 'string',
    },
    reason: {
      description:
        'A human-readable message giving the reason for the failure. These messages can be shown to your users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoPhoneReportError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_provided_detailsSchema = {
  description: '',
  properties: {
    email: {
      description: 'Email of user being verified',
      maxLength: 5000,
      type: 'string',
    },
    phone: {
      description: 'Phone number of user being verified',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'GelatoProvidedDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_report_document_optionsSchema = {
  description: '',
  properties: {
    allowed_types: {
      description:
        'Array of strings of allowed identity document types. If the provided identity document isn’t one of the allowed types, the verification check will fail with a document_type_not_allowed error code.',
      items: {
        enum: ['driving_license', 'id_card', 'passport'],
        type: 'string',
      },
      type: 'array',
    },
    require_id_number: {
      description:
        'Collect an ID number and perform an [ID number check](https://stripe.com/docs/identity/verification-checks?type=id-number) with the document’s extracted name and date of birth.',
      type: 'boolean',
    },
    require_live_capture: {
      description: 'Disable image uploads, identity document images have to be captured using the device’s camera.',
      type: 'boolean',
    },
    require_matching_selfie: {
      description:
        'Capture a face image and perform a [selfie check](https://stripe.com/docs/identity/verification-checks?type=selfie) comparing a photo ID and a picture of your user’s face. [Learn more](https://stripe.com/docs/identity/selfie).',
      type: 'boolean',
    },
  },
  title: 'GelatoReportDocumentOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_report_id_number_optionsSchema = {
  description: '',
  properties: {},
  title: 'GelatoReportIdNumberOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_selfie_reportSchema = {
  description: 'Result from a selfie check',
  properties: {
    document: {
      description:
        'ID of the [File](https://stripe.com/docs/api/files) holding the image of the identity document used in this check.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_selfie_report_error',
        },
      ],
      description: 'Details on the verification error. Present when status is `unverified`.',
      nullable: true,
    },
    selfie: {
      description:
        'ID of the [File](https://stripe.com/docs/api/files) holding the image of the selfie used in this check.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'Status of this `selfie` check.',
      enum: ['unverified', 'verified'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['status'],
  title: 'GelatoSelfieReport',
  type: 'object',
  'x-expandableFields': ['error'],
} as const;

export const gelato_selfie_report_errorSchema = {
  description: '',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification failure.',
      enum: ['selfie_document_missing_photo', 'selfie_face_mismatch', 'selfie_manipulated', 'selfie_unverified_other'],
      nullable: true,
      type: 'string',
    },
    reason: {
      description:
        'A human-readable message giving the reason for the failure. These messages can be shown to your users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoSelfieReportError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_session_document_optionsSchema = {
  description: '',
  properties: {
    allowed_types: {
      description:
        'Array of strings of allowed identity document types. If the provided identity document isn’t one of the allowed types, the verification check will fail with a document_type_not_allowed error code.',
      items: {
        enum: ['driving_license', 'id_card', 'passport'],
        type: 'string',
      },
      type: 'array',
    },
    require_id_number: {
      description:
        'Collect an ID number and perform an [ID number check](https://stripe.com/docs/identity/verification-checks?type=id-number) with the document’s extracted name and date of birth.',
      type: 'boolean',
    },
    require_live_capture: {
      description: 'Disable image uploads, identity document images have to be captured using the device’s camera.',
      type: 'boolean',
    },
    require_matching_selfie: {
      description:
        'Capture a face image and perform a [selfie check](https://stripe.com/docs/identity/verification-checks?type=selfie) comparing a photo ID and a picture of your user’s face. [Learn more](https://stripe.com/docs/identity/selfie).',
      type: 'boolean',
    },
  },
  title: 'GelatoSessionDocumentOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_session_email_optionsSchema = {
  description: '',
  properties: {
    require_verification: {
      description: 'Request one time password verification of `provided_details.email`.',
      type: 'boolean',
    },
  },
  title: 'GelatoSessionEmailOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_session_id_number_optionsSchema = {
  description: '',
  properties: {},
  title: 'GelatoSessionIdNumberOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_session_last_errorSchema = {
  description: 'Shows last VerificationSession error',
  properties: {
    code: {
      description: 'A short machine-readable string giving the reason for the verification or user-session failure.',
      enum: [
        'abandoned',
        'consent_declined',
        'country_not_supported',
        'device_not_supported',
        'document_expired',
        'document_type_not_supported',
        'document_unverified_other',
        'email_unverified_other',
        'email_verification_declined',
        'id_number_insufficient_document_data',
        'id_number_mismatch',
        'id_number_unverified_other',
        'phone_unverified_other',
        'phone_verification_declined',
        'selfie_document_missing_photo',
        'selfie_face_mismatch',
        'selfie_manipulated',
        'selfie_unverified_other',
        'under_supported_age',
      ],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    reason: {
      description: 'A message that explains the reason for verification or user-session failure.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoSessionLastError',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_session_phone_optionsSchema = {
  description: '',
  properties: {
    require_verification: {
      description: 'Request one time password verification of `provided_details.phone`.',
      type: 'boolean',
    },
  },
  title: 'GelatoSessionPhoneOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const gelato_verification_report_optionsSchema = {
  description: '',
  properties: {
    document: {
      $ref: '#/components/schemas/gelato_report_document_options',
    },
    id_number: {
      $ref: '#/components/schemas/gelato_report_id_number_options',
    },
  },
  title: 'GelatoVerificationReportOptions',
  type: 'object',
  'x-expandableFields': ['document', 'id_number'],
} as const;

export const gelato_verification_session_optionsSchema = {
  description: '',
  properties: {
    document: {
      $ref: '#/components/schemas/gelato_session_document_options',
    },
    email: {
      $ref: '#/components/schemas/gelato_session_email_options',
    },
    id_number: {
      $ref: '#/components/schemas/gelato_session_id_number_options',
    },
    phone: {
      $ref: '#/components/schemas/gelato_session_phone_options',
    },
  },
  title: 'GelatoVerificationSessionOptions',
  type: 'object',
  'x-expandableFields': ['document', 'email', 'id_number', 'phone'],
} as const;

export const gelato_verified_outputsSchema = {
  description: '',
  properties: {
    address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description: "The user's verified address.",
      nullable: true,
    },
    dob: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_data_verified_outputs_date',
        },
      ],
      description: 'The user’s verified date of birth.',
      nullable: true,
    },
    email: {
      description: "The user's verified email address",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    first_name: {
      description: "The user's verified first name.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id_number: {
      description: "The user's verified id number.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id_number_type: {
      description: "The user's verified id number type.",
      enum: ['br_cpf', 'sg_nric', 'us_ssn'],
      nullable: true,
      type: 'string',
    },
    last_name: {
      description: "The user's verified last name.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    phone: {
      description: "The user's verified phone number",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'GelatoVerifiedOutputs',
  type: 'object',
  'x-expandableFields': ['address', 'dob'],
} as const;

export const identity_verification_reportSchema = {
  description: `A VerificationReport is the result of an attempt to collect and verify data from a user.
The collection of verification checks performed is determined from the \`type\` and \`options\`
parameters used. You can find the result of each verification check performed in the
appropriate sub-resource: \`document\`, \`id_number\`, \`selfie\`.

Each VerificationReport contains a copy of any data collected by the user as well as
reference IDs which can be used to access collected images through the [FileUpload](https://stripe.com/docs/api/files)
API. To configure and create VerificationReports, use the
[VerificationSession](https://stripe.com/docs/api/identity/verification_sessions) API.

Related guides: [Accessing verification results](https://stripe.com/docs/identity/verification-sessions#results).`,
  properties: {
    client_reference_id: {
      description:
        'A string to reference this user. This can be a customer ID, a session ID, or similar, and can be used to reconcile this verification with your internal systems.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    document: {
      $ref: '#/components/schemas/gelato_document_report',
    },
    email: {
      $ref: '#/components/schemas/gelato_email_report',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    id_number: {
      $ref: '#/components/schemas/gelato_id_number_report',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['identity.verification_report'],
      type: 'string',
    },
    options: {
      $ref: '#/components/schemas/gelato_verification_report_options',
    },
    phone: {
      $ref: '#/components/schemas/gelato_phone_report',
    },
    selfie: {
      $ref: '#/components/schemas/gelato_selfie_report',
    },
    type: {
      description: 'Type of report.',
      enum: ['document', 'id_number', 'verification_flow'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    verification_flow: {
      description: 'The configuration token of a Verification Flow from the dashboard.',
      maxLength: 5000,
      type: 'string',
    },
    verification_session: {
      description: 'ID of the VerificationSession that created this report.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['created', 'id', 'livemode', 'object', 'type'],
  title: 'GelatoVerificationReport',
  type: 'object',
  'x-expandableFields': ['document', 'email', 'id_number', 'options', 'phone', 'selfie'],
  'x-resourceId': 'identity.verification_report',
} as const;

export const identity_verification_sessionSchema = {
  description: `A VerificationSession guides you through the process of collecting and verifying the identities
of your users. It contains details about the type of verification, such as what [verification
check](/docs/identity/verification-checks) to perform. Only create one VerificationSession for
each verification in your system.

A VerificationSession transitions through [multiple
statuses](/docs/identity/how-sessions-work) throughout its lifetime as it progresses through
the verification flow. The VerificationSession contains the user's verified data after
verification checks are complete.

Related guide: [The Verification Sessions API](https://stripe.com/docs/identity/verification-sessions)`,
  properties: {
    client_reference_id: {
      description:
        'A string to reference this user. This can be a customer ID, a session ID, or similar, and can be used to reconcile this verification with your internal systems.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    client_secret: {
      description:
        'The short-lived client secret used by Stripe.js to [show a verification modal](https://stripe.com/docs/js/identity/modal) inside your app. This client secret expires after 24 hours and can only be used once. Don’t store it, log it, embed it in a URL, or expose it to anyone other than the user. Make sure that you have TLS enabled on any page that includes the client secret. Refer to our docs on [passing the client secret to the frontend](https://stripe.com/docs/identity/verification-sessions#client-secret) to learn more.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last_error: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_session_last_error',
        },
      ],
      description: 'If present, this property tells you the last error encountered when processing the verification.',
      nullable: true,
    },
    last_verification_report: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/identity.verification_report',
        },
      ],
      description:
        'ID of the most recent VerificationReport. [Learn more about accessing detailed verification results.](https://stripe.com/docs/identity/verification-sessions#results)',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/identity.verification_report',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['identity.verification_session'],
      type: 'string',
    },
    options: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_verification_session_options',
        },
      ],
      description: 'A set of options for the session’s verification checks.',
      nullable: true,
    },
    provided_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_provided_details',
        },
      ],
      description: 'Details provided about the user being verified. These details may be shown to the user.',
      nullable: true,
    },
    redaction: {
      anyOf: [
        {
          $ref: '#/components/schemas/verification_session_redaction',
        },
      ],
      description:
        'Redaction status of this VerificationSession. If the VerificationSession is not redacted, this field will be null.',
      nullable: true,
    },
    status: {
      description:
        'Status of this VerificationSession. [Learn more about the lifecycle of sessions](https://stripe.com/docs/identity/how-sessions-work).',
      enum: ['canceled', 'processing', 'requires_input', 'verified'],
      type: 'string',
    },
    type: {
      description:
        'The type of [verification check](https://stripe.com/docs/identity/verification-checks) to be performed.',
      enum: ['document', 'id_number', 'verification_flow'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    url: {
      description:
        'The short-lived URL that you use to redirect a user to Stripe to submit their identity information. This URL expires after 48 hours and can only be used once. Don’t store it, log it, send it in emails or expose it to anyone other than the user. Refer to our docs on [verifying identity documents](https://stripe.com/docs/identity/verify-identity-documents?platform=web&type=redirect) to learn how to redirect users to Stripe.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verification_flow: {
      description: 'The configuration token of a Verification Flow from the dashboard.',
      maxLength: 5000,
      type: 'string',
    },
    verified_outputs: {
      anyOf: [
        {
          $ref: '#/components/schemas/gelato_verified_outputs',
        },
      ],
      description: 'The user’s verified data.',
      nullable: true,
    },
  },
  required: ['created', 'id', 'livemode', 'metadata', 'object', 'status', 'type'],
  title: 'GelatoVerificationSession',
  type: 'object',
  'x-expandableFields': [
    'last_error',
    'last_verification_report',
    'options',
    'provided_details',
    'redaction',
    'verified_outputs',
  ],
  'x-resourceId': 'identity.verification_session',
} as const;

export const inbound_transfersSchema = {
  description: '',
  properties: {
    billing_details: {
      $ref: '#/components/schemas/treasury_shared_resource_billing_details',
    },
    type: {
      description: 'The type of the payment method used in the InboundTransfer.',
      enum: ['us_bank_account'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    us_bank_account: {
      $ref: '#/components/schemas/inbound_transfers_payment_method_details_us_bank_account',
    },
  },
  required: ['billing_details', 'type'],
  title: 'InboundTransfers',
  type: 'object',
  'x-expandableFields': ['billing_details', 'us_bank_account'],
} as const;

export const inbound_transfers_payment_method_details_us_bank_accountSchema = {
  description: '',
  properties: {
    account_holder_type: {
      description: 'Account holder type: individual or company.',
      enum: ['company', 'individual'],
      nullable: true,
      type: 'string',
    },
    account_type: {
      description: 'Account type: checkings or savings. Defaults to checking if omitted.',
      enum: ['checking', 'savings'],
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'ID of the mandate used to make this payment.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    network: {
      description:
        'The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.',
      enum: ['ach'],
      type: 'string',
    },
    routing_number: {
      description: 'Routing number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['network'],
  title: 'inbound_transfers_payment_method_details_us_bank_account',
  type: 'object',
  'x-expandableFields': ['mandate'],
} as const;

export const internal_cardSchema = {
  description: '',
  properties: {
    brand: {
      description: 'Brand of the card used in the transaction',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country of the card',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two digit number representing the card's expiration month",
      nullable: true,
      type: 'integer',
    },
    exp_year: {
      description: "Two digit number representing the card's expiration year",
      nullable: true,
      type: 'integer',
    },
    last4: {
      description: 'The last 4 digits of the card',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'internal_card',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoiceSchema = {
  description: `Invoices are statements of amounts owed by a customer, and are either
generated one-off, or generated periodically from a subscription.

They contain [invoice items](https://stripe.com/docs/api#invoiceitems), and proration adjustments
that may be caused by subscription upgrades/downgrades (if necessary).

If your invoice is configured to be billed through automatic charges,
Stripe automatically finalizes your invoice and attempts payment. Note
that finalizing the invoice,
[when automatic](https://stripe.com/docs/invoicing/integration/automatic-advancement-collection), does
not happen immediately as the invoice is created. Stripe waits
until one hour after the last webhook was successfully sent (or the last
webhook timed out after failing). If you (and the platforms you may have
connected to) have no webhooks configured, Stripe waits one hour after
creation to finalize the invoice.

If your invoice is configured to be billed by sending an email, then based on your
[email settings](https://dashboard.stripe.com/account/billing/automatic),
Stripe will email the invoice to your customer and await payment. These
emails can contain a link to a hosted page to pay the invoice.

Stripe applies any customer credit on the account before determining the
amount due for the invoice (i.e., the amount that will be actually
charged). If the amount due for the invoice is less than Stripe's [minimum allowed charge
per currency](/docs/currencies#minimum-and-maximum-charge-amounts), the
invoice is automatically marked paid, and we add the amount due to the
customer's credit balance which is applied to the next invoice.

More details on the customer's credit balance are
[here](https://stripe.com/docs/billing/customer/balance).

Related guide: [Send invoices to customers](https://stripe.com/docs/billing/invoices/sending)`,
  properties: {
    account_country: {
      description:
        'The country of the business associated with this invoice, most often the business creating the invoice.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_name: {
      description:
        'The public name of the business associated with this invoice, most often the business creating the invoice.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    account_tax_ids: {
      description: 'The account tax IDs associated with the invoice. Only editable when the invoice is a draft.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/tax_id',
          },
          {
            $ref: '#/components/schemas/deleted_tax_id',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/tax_id',
            },
            {
              $ref: '#/components/schemas/deleted_tax_id',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
    amount_due: {
      description:
        "Final amount due at this time for this invoice. If the invoice's total is smaller than the minimum charge amount, for example, or if there is account credit that can be applied to the invoice, the `amount_due` may be 0. If there is a positive `starting_balance` for the invoice (the customer owes money), the `amount_due` will also take that into account. The charge that gets generated for the invoice will be for the amount specified in `amount_due`.",
      type: 'integer',
    },
    amount_paid: {
      description: 'The amount, in cents (or local equivalent), that was paid.',
      type: 'integer',
    },
    amount_remaining: {
      description: 'The difference between amount_due and amount_paid, in cents (or local equivalent).',
      type: 'integer',
    },
    amount_shipping: {
      description: 'This is the sum of all the shipping amounts.',
      type: 'integer',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
        {
          $ref: '#/components/schemas/deleted_application',
        },
      ],
      description: 'ID of the Connect Application that created the invoice.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
          {
            $ref: '#/components/schemas/deleted_application',
          },
        ],
      },
    },
    application_fee_amount: {
      description:
        "The fee in cents (or local equivalent) that will be applied to the invoice and transferred to the application owner's Stripe account when the invoice is paid.",
      nullable: true,
      type: 'integer',
    },
    attempt_count: {
      description:
        'Number of payment attempts made for this invoice, from the perspective of the payment retry schedule. Any payment attempt counts as the first attempt, and subsequently only automatic retries increment the attempt count. In other words, manual payment attempts after the first attempt do not affect the retry schedule. If a failure is returned with a non-retryable return code, the invoice can no longer be retried unless a new payment method is obtained. Retries will continue to be scheduled, and attempt_count will continue to increment, but retries will only be executed if a new payment method is obtained.',
      type: 'integer',
    },
    attempted: {
      description:
        'Whether an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour after the `invoice.created` webhook, for example, so you might not want to display that invoice as unpaid to your users.',
      type: 'boolean',
    },
    auto_advance: {
      description:
        "Controls whether Stripe performs [automatic collection](https://stripe.com/docs/invoicing/integration/automatic-advancement-collection) of the invoice. If `false`, the invoice's state doesn't automatically advance without an explicit action.",
      type: 'boolean',
    },
    automatic_tax: {
      $ref: '#/components/schemas/automatic_tax',
    },
    billing_reason: {
      description: `Indicates the reason why the invoice was created.

* \`manual\`: Unrelated to a subscription, for example, created via the invoice editor.
* \`subscription\`: No longer in use. Applies to subscriptions from before May 2018 where no distinction was made between updates, cycles, and thresholds.
* \`subscription_create\`: A new subscription was created.
* \`subscription_cycle\`: A subscription advanced into a new period.
* \`subscription_threshold\`: A subscription reached a billing threshold.
* \`subscription_update\`: A subscription was updated.
* \`upcoming\`: Reserved for simulated invoices, per the upcoming invoice endpoint.`,
      enum: [
        'automatic_pending_invoice_item_invoice',
        'manual',
        'quote_accept',
        'subscription',
        'subscription_create',
        'subscription_cycle',
        'subscription_threshold',
        'subscription_update',
        'upcoming',
      ],
      nullable: true,
      type: 'string',
    },
    charge: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/charge',
        },
      ],
      description: 'ID of the latest charge generated for this invoice, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/charge',
          },
        ],
      },
    },
    collection_method: {
      description:
        'Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this invoice using the default source attached to the customer. When sending an invoice, Stripe will email this invoice to the customer with payment instructions.',
      enum: ['charge_automatically', 'send_invoice'],
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    custom_fields: {
      description: 'Custom fields displayed on the invoice.',
      items: {
        $ref: '#/components/schemas/invoice_setting_custom_field',
      },
      nullable: true,
      type: 'array',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'The ID of the customer who will be billed.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    customer_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "The customer's address. Until the invoice is finalized, this field will equal `customer.address`. Once the invoice is finalized, this field will no longer be updated.",
      nullable: true,
    },
    customer_email: {
      description:
        "The customer's email. Until the invoice is finalized, this field will equal `customer.email`. Once the invoice is finalized, this field will no longer be updated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_name: {
      description:
        "The customer's name. Until the invoice is finalized, this field will equal `customer.name`. Once the invoice is finalized, this field will no longer be updated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_phone: {
      description:
        "The customer's phone number. Until the invoice is finalized, this field will equal `customer.phone`. Once the invoice is finalized, this field will no longer be updated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    customer_shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description:
        "The customer's shipping information. Until the invoice is finalized, this field will equal `customer.shipping`. Once the invoice is finalized, this field will no longer be updated.",
      nullable: true,
    },
    customer_tax_exempt: {
      description:
        "The customer's tax exempt status. Until the invoice is finalized, this field will equal `customer.tax_exempt`. Once the invoice is finalized, this field will no longer be updated.",
      enum: ['exempt', 'none', 'reverse'],
      nullable: true,
      type: 'string',
    },
    customer_tax_ids: {
      description:
        "The customer's tax IDs. Until the invoice is finalized, this field will contain the same tax IDs as `customer.tax_ids`. Once the invoice is finalized, this field will no longer be updated.",
      items: {
        $ref: '#/components/schemas/invoices_resource_invoice_tax_id',
      },
      nullable: true,
      type: 'array',
    },
    default_payment_method: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description:
        "ID of the default payment method for the invoice. It must belong to the customer associated with the invoice. If not set, defaults to the subscription's default payment method, if any, or to the default payment method in the customer's invoice settings.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    default_source: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/bank_account',
        },
        {
          $ref: '#/components/schemas/card',
        },
        {
          $ref: '#/components/schemas/source',
        },
      ],
      description:
        "ID of the default payment source for the invoice. It must belong to the customer associated with the invoice and be in a chargeable state. If not set, defaults to the subscription's default source, if any, or to the customer's default source.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/bank_account',
          },
          {
            $ref: '#/components/schemas/card',
          },
          {
            $ref: '#/components/schemas/source',
          },
        ],
      },
      'x-stripeBypassValidation': true,
    },
    default_tax_rates: {
      description: 'The tax rates applied to this invoice, if any.',
      items: {
        $ref: '#/components/schemas/tax_rate',
      },
      type: 'array',
    },
    description: {
      description:
        "An arbitrary string attached to the object. Often useful for displaying to users. Referenced as 'memo' in the Dashboard.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    discount: {
      anyOf: [
        {
          $ref: '#/components/schemas/discount',
        },
      ],
      description:
        'Describes the current discount applied to this invoice, if there is one. Not populated if there are multiple discounts.',
      nullable: true,
    },
    discounts: {
      description:
        'The discounts applied to the invoice. Line item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/discount',
          },
          {
            $ref: '#/components/schemas/deleted_discount',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/discount',
            },
            {
              $ref: '#/components/schemas/deleted_discount',
            },
          ],
        },
      },
      type: 'array',
    },
    due_date: {
      description:
        'The date on which payment for this invoice is due. This value will be `null` for invoices where `collection_method=charge_automatically`.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    effective_at: {
      description:
        "The date when this invoice is in effect. Same as `finalized_at` unless overwritten. When defined, this value replaces the system-generated 'Date of issue' printed on the invoice PDF and receipt.",
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    ending_balance: {
      description:
        'Ending customer balance after the invoice is finalized. Invoices are finalized approximately an hour after successful webhook delivery or when payment collection is attempted for the invoice. If the invoice has not been finalized yet, this will be null.',
      nullable: true,
      type: 'integer',
    },
    footer: {
      description: 'Footer displayed on the invoice.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    from_invoice: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_from_invoice',
        },
      ],
      description:
        'Details of the invoice that was cloned. See the [revision documentation](https://stripe.com/docs/invoicing/invoice-revisions) for more details.',
      nullable: true,
    },
    hosted_invoice_url: {
      description:
        'The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the invoice has not been finalized yet, this will be null.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description:
        'Unique identifier for the object. This property is always present unless the invoice is an upcoming invoice. See [Retrieve an upcoming invoice](https://stripe.com/docs/api/invoices/upcoming) for more details.',
      maxLength: 5000,
      type: 'string',
    },
    invoice_pdf: {
      description:
        'The link to download the PDF for the invoice. If the invoice has not been finalized yet, this will be null.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    issuer: {
      $ref: '#/components/schemas/connect_account_reference',
    },
    last_finalization_error: {
      anyOf: [
        {
          $ref: '#/components/schemas/api_errors',
        },
      ],
      description:
        'The error encountered during the previous attempt to finalize the invoice. This field is cleared when the invoice is successfully finalized.',
      nullable: true,
    },
    latest_revision: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'The ID of the most recent non-draft revision of this invoice',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    lines: {
      description:
        'The individual line items that make up the invoice. `lines` is sorted as follows: (1) pending invoice items (including prorations) in reverse chronological order, (2) subscription items in reverse chronological order, and (3) invoice items added after invoice creation in chronological order.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/line_item',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'InvoiceLinesList',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    next_payment_attempt: {
      description:
        'The time at which payment will next be attempted. This value will be `null` for invoices where `collection_method=send_invoice`.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    number: {
      description:
        "A unique, identifying string that appears on emails sent to the customer for this invoice. This starts with the customer's unique invoice_prefix if it is specified.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['invoice'],
      type: 'string',
    },
    on_behalf_of: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The account (if any) for which the funds of the invoice payment are intended. If set, the invoice will be presented with the branding and support information of the specified account. See the [Invoices with Connect](https://stripe.com/docs/billing/invoices/connect) documentation for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    paid: {
      description:
        "Whether payment was successfully collected for this invoice. An invoice can be paid (most commonly) with a charge or with credit from the customer's account balance.",
      type: 'boolean',
    },
    paid_out_of_band: {
      description:
        "Returns true if the invoice was manually marked paid, returns false if the invoice hasn't been paid yet or was paid on Stripe.",
      type: 'boolean',
    },
    payment_intent: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_intent',
        },
      ],
      description:
        'The PaymentIntent associated with this invoice. The PaymentIntent is generated when the invoice is finalized, and can then be used to pay the invoice. Note that voiding an invoice will cancel the PaymentIntent.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_intent',
          },
        ],
      },
    },
    payment_settings: {
      $ref: '#/components/schemas/invoices_payment_settings',
    },
    period_end: {
      description:
        'End of the usage period during which invoice items were added to this invoice. This looks back one period for a subscription invoice. Use the [line item period](/api/invoices/line_item#invoice_line_item_object-period) to get the service period for each price.',
      format: 'unix-time',
      type: 'integer',
    },
    period_start: {
      description:
        'Start of the usage period during which invoice items were added to this invoice. This looks back one period for a subscription invoice. Use the [line item period](/api/invoices/line_item#invoice_line_item_object-period) to get the service period for each price.',
      format: 'unix-time',
      type: 'integer',
    },
    post_payment_credit_notes_amount: {
      description: 'Total amount of all post-payment credit notes issued for this invoice.',
      type: 'integer',
    },
    pre_payment_credit_notes_amount: {
      description: 'Total amount of all pre-payment credit notes issued for this invoice.',
      type: 'integer',
    },
    quote: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/quote',
        },
      ],
      description: 'The quote this invoice was generated from.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/quote',
          },
        ],
      },
    },
    receipt_number: {
      description: 'This is the transaction number that appears on email receipts sent for this invoice.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    rendering: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_invoice_rendering',
        },
      ],
      description:
        'The rendering-related settings that control how the invoice is displayed on customer-facing surfaces such as PDF and Hosted Invoice Page.',
      nullable: true,
    },
    shipping_cost: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_shipping_cost',
        },
      ],
      description: 'The details of the cost of shipping, including the ShippingRate applied on the invoice.',
      nullable: true,
    },
    shipping_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description:
        'Shipping details for the invoice. The Invoice PDF will use the `shipping_details` value if it is set, otherwise the PDF will render the shipping address from the customer.',
      nullable: true,
    },
    starting_balance: {
      description:
        'Starting customer balance before the invoice is finalized. If the invoice has not been finalized yet, this will be the current customer balance. For revision invoices, this also includes any customer balance that was applied to the original invoice.',
      type: 'integer',
    },
    statement_descriptor: {
      description: "Extra information about an invoice for the customer's credit card statement.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description:
        'The status of the invoice, one of `draft`, `open`, `paid`, `uncollectible`, or `void`. [Learn more](https://stripe.com/docs/billing/invoices/workflow#workflow-overview)',
      enum: ['draft', 'open', 'paid', 'uncollectible', 'void'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    status_transitions: {
      $ref: '#/components/schemas/invoices_resource_status_transitions',
    },
    subscription: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/subscription',
        },
      ],
      description: 'The subscription that this invoice was prepared for, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/subscription',
          },
        ],
      },
    },
    subscription_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/subscription_details_data',
        },
      ],
      description: 'Details about the subscription that created this invoice.',
      nullable: true,
    },
    subscription_proration_date: {
      description: 'Only set for upcoming invoices that preview prorations. The time used to calculate prorations.',
      type: 'integer',
    },
    subtotal: {
      description:
        'Total of all subscriptions, invoice items, and prorations on the invoice before any invoice level discount or exclusive tax is applied. Item discounts are already incorporated',
      type: 'integer',
    },
    subtotal_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the subtotal of the invoice before any invoice level discount or tax is applied. Item discounts are already incorporated',
      nullable: true,
      type: 'integer',
    },
    tax: {
      description: 'The amount of tax on this invoice. This is the sum of all the tax amounts on this invoice.',
      nullable: true,
      type: 'integer',
    },
    test_clock: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/test_helpers.test_clock',
        },
      ],
      description: 'ID of the test clock this invoice belongs to.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/test_helpers.test_clock',
          },
        ],
      },
    },
    threshold_reason: {
      $ref: '#/components/schemas/invoice_threshold_reason',
    },
    total: {
      description: 'Total after discounts and taxes.',
      type: 'integer',
    },
    total_discount_amounts: {
      description: 'The aggregate amounts calculated per discount across all line items.',
      items: {
        $ref: '#/components/schemas/discounts_resource_discount_amount',
      },
      nullable: true,
      type: 'array',
    },
    total_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the total amount of the invoice including all discounts but excluding all tax.',
      nullable: true,
      type: 'integer',
    },
    total_tax_amounts: {
      description: 'The aggregate amounts calculated per tax rate for all line items.',
      items: {
        $ref: '#/components/schemas/invoice_tax_amount',
      },
      type: 'array',
    },
    transfer_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_transfer_data',
        },
      ],
      description:
        'The account (if any) the payment will be attributed to for tax reporting, and where funds from the payment will be transferred to for the invoice.',
      nullable: true,
    },
    webhooks_delivered_at: {
      description:
        'Invoices are automatically paid or sent 1 hour after webhooks are delivered, or until all webhook delivery attempts have [been exhausted](https://stripe.com/docs/billing/webhooks#understand). This field tracks the time when webhooks for this invoice were successfully delivered. If the invoice had no webhooks to deliver, this will be set while the invoice is being created.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  required: [
    'amount_due',
    'amount_paid',
    'amount_remaining',
    'amount_shipping',
    'attempt_count',
    'attempted',
    'automatic_tax',
    'collection_method',
    'created',
    'currency',
    'default_tax_rates',
    'discounts',
    'issuer',
    'lines',
    'livemode',
    'object',
    'paid',
    'paid_out_of_band',
    'payment_settings',
    'period_end',
    'period_start',
    'post_payment_credit_notes_amount',
    'pre_payment_credit_notes_amount',
    'starting_balance',
    'status_transitions',
    'subtotal',
    'total',
    'total_tax_amounts',
  ],
  title: 'Invoice',
  type: 'object',
  'x-expandableFields': [
    'account_tax_ids',
    'application',
    'automatic_tax',
    'charge',
    'custom_fields',
    'customer',
    'customer_address',
    'customer_shipping',
    'customer_tax_ids',
    'default_payment_method',
    'default_source',
    'default_tax_rates',
    'discount',
    'discounts',
    'from_invoice',
    'issuer',
    'last_finalization_error',
    'latest_revision',
    'lines',
    'on_behalf_of',
    'payment_intent',
    'payment_settings',
    'quote',
    'rendering',
    'shipping_cost',
    'shipping_details',
    'status_transitions',
    'subscription',
    'subscription_details',
    'test_clock',
    'threshold_reason',
    'total_discount_amounts',
    'total_tax_amounts',
    'transfer_data',
  ],
  'x-resourceId': 'invoice',
} as const;

export const invoice_installments_cardSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Whether Installments are enabled for this Invoice.',
      nullable: true,
      type: 'boolean',
    },
  },
  title: 'invoice_installments_card',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_item_threshold_reasonSchema = {
  description: '',
  properties: {
    line_item_ids: {
      description: 'The IDs of the line items that triggered the threshold invoice.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    usage_gte: {
      description: 'The quantity threshold boundary that applied to the given line item.',
      type: 'integer',
    },
  },
  required: ['line_item_ids', 'usage_gte'],
  title: 'InvoiceItemThresholdReason',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_line_item_periodSchema = {
  description: '',
  properties: {
    end: {
      description: 'The end of the period, which must be greater than or equal to the start. This value is inclusive.',
      format: 'unix-time',
      type: 'integer',
    },
    start: {
      description: 'The start of the period. This value is inclusive.',
      format: 'unix-time',
      type: 'integer',
    },
  },
  required: ['end', 'start'],
  title: 'InvoiceLineItemPeriod',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_mandate_options_cardSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Amount to be charged for future payments.',
      nullable: true,
      type: 'integer',
    },
    amount_type: {
      description:
        'One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.',
      enum: ['fixed', 'maximum'],
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A description of the mandate or subscription that is meant to be displayed to the customer.',
      maxLength: 200,
      nullable: true,
      type: 'string',
    },
  },
  title: 'invoice_mandate_options_card',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_acss_debitSchema = {
  description: '',
  properties: {
    mandate_options: {
      $ref: '#/components/schemas/invoice_payment_method_options_acss_debit_mandate_options',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'invoice_payment_method_options_acss_debit',
  type: 'object',
  'x-expandableFields': ['mandate_options'],
} as const;

export const invoice_payment_method_options_acss_debit_mandate_optionsSchema = {
  description: '',
  properties: {
    transaction_type: {
      description: 'Transaction type of the mandate.',
      enum: ['business', 'personal'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'invoice_payment_method_options_acss_debit_mandate_options',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_bancontactSchema = {
  description: '',
  properties: {
    preferred_language: {
      description: 'Preferred language of the Bancontact authorization page that the customer is redirected to.',
      enum: ['de', 'en', 'fr', 'nl'],
      type: 'string',
    },
  },
  required: ['preferred_language'],
  title: 'invoice_payment_method_options_bancontact',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_cardSchema = {
  description: '',
  properties: {
    installments: {
      $ref: '#/components/schemas/invoice_installments_card',
    },
    request_three_d_secure: {
      description:
        'We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.',
      enum: ['any', 'automatic', 'challenge'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'invoice_payment_method_options_card',
  type: 'object',
  'x-expandableFields': ['installments'],
} as const;

export const invoice_payment_method_options_customer_balanceSchema = {
  description: '',
  properties: {
    bank_transfer: {
      $ref: '#/components/schemas/invoice_payment_method_options_customer_balance_bank_transfer',
    },
    funding_type: {
      description:
        'The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.',
      enum: ['bank_transfer'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'invoice_payment_method_options_customer_balance',
  type: 'object',
  'x-expandableFields': ['bank_transfer'],
} as const;

export const invoice_payment_method_options_customer_balance_bank_transferSchema = {
  description: '',
  properties: {
    eu_bank_transfer: {
      $ref: '#/components/schemas/invoice_payment_method_options_customer_balance_bank_transfer_eu_bank_transfer',
    },
    type: {
      description:
        'The bank transfer type that can be used for funding. Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.',
      nullable: true,
      type: 'string',
    },
  },
  title: 'invoice_payment_method_options_customer_balance_bank_transfer',
  type: 'object',
  'x-expandableFields': ['eu_bank_transfer'],
} as const;

export const invoice_payment_method_options_customer_balance_bank_transfer_eu_bank_transferSchema = {
  description: '',
  properties: {
    country: {
      description:
        'The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.',
      enum: ['BE', 'DE', 'ES', 'FR', 'IE', 'NL'],
      type: 'string',
    },
  },
  required: ['country'],
  title: 'invoice_payment_method_options_customer_balance_bank_transfer_eu_bank_transfer',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_konbiniSchema = {
  description: '',
  properties: {},
  title: 'invoice_payment_method_options_konbini',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_sepa_debitSchema = {
  description: '',
  properties: {},
  title: 'invoice_payment_method_options_sepa_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_payment_method_options_us_bank_accountSchema = {
  description: '',
  properties: {
    financial_connections: {
      $ref: '#/components/schemas/invoice_payment_method_options_us_bank_account_linked_account_options',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'invoice_payment_method_options_us_bank_account',
  type: 'object',
  'x-expandableFields': ['financial_connections'],
} as const;

export const invoice_payment_method_options_us_bank_account_linked_account_optionsSchema = {
  description: '',
  properties: {
    permissions: {
      description: 'The list of permissions to request. The `payment_method` permission must be included.',
      items: {
        enum: ['balances', 'ownership', 'payment_method', 'transactions'],
        type: 'string',
      },
      type: 'array',
    },
    prefetch: {
      description: 'Data features requested to be retrieved upon account creation.',
      items: {
        enum: ['balances', 'ownership', 'transactions'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'invoice_payment_method_options_us_bank_account_linked_account_options',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_rendering_pdfSchema = {
  description: '',
  properties: {
    page_size: {
      description:
        'Page size of invoice pdf. Options include a4, letter, and auto. If set to auto, page size will be switched to a4 or letter based on customer locale.',
      enum: ['a4', 'auto', 'letter'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'InvoiceRenderingPdf',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_setting_custom_fieldSchema = {
  description: '',
  properties: {
    name: {
      description: 'The name of the custom field.',
      maxLength: 5000,
      type: 'string',
    },
    value: {
      description: 'The value of the custom field.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['name', 'value'],
  title: 'InvoiceSettingCustomField',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_setting_customer_rendering_optionsSchema = {
  description: '',
  properties: {
    amount_tax_display: {
      description: 'How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'InvoiceSettingCustomerRenderingOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_setting_customer_settingSchema = {
  description: '',
  properties: {
    custom_fields: {
      description: 'Default custom fields to be displayed on invoices for this customer.',
      items: {
        $ref: '#/components/schemas/invoice_setting_custom_field',
      },
      nullable: true,
      type: 'array',
    },
    default_payment_method: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description:
        "ID of a payment method that's attached to the customer, to be used as the customer's default payment method for subscriptions and invoices.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    footer: {
      description: 'Default footer to be displayed on invoices for this customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    rendering_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_setting_customer_rendering_options',
        },
      ],
      description: 'Default options for invoice PDF rendering for this customer.',
      nullable: true,
    },
  },
  title: 'InvoiceSettingCustomerSetting',
  type: 'object',
  'x-expandableFields': ['custom_fields', 'default_payment_method', 'rendering_options'],
} as const;

export const invoice_setting_quote_settingSchema = {
  description: '',
  properties: {
    days_until_due: {
      description:
        'Number of days within which a customer must pay invoices generated by this quote. This value will be `null` for quotes where `collection_method=charge_automatically`.',
      nullable: true,
      type: 'integer',
    },
    issuer: {
      $ref: '#/components/schemas/connect_account_reference',
    },
  },
  required: ['issuer'],
  title: 'InvoiceSettingQuoteSetting',
  type: 'object',
  'x-expandableFields': ['issuer'],
} as const;

export const invoice_setting_rendering_optionsSchema = {
  description: '',
  properties: {
    amount_tax_display: {
      description: 'How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'InvoiceSettingRenderingOptions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoice_setting_subscription_schedule_phase_settingSchema = {
  description: '',
  properties: {
    account_tax_ids: {
      description:
        'The account tax IDs associated with this phase of the subscription schedule. Will be set on invoices generated by this phase of the subscription schedule.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/tax_id',
          },
          {
            $ref: '#/components/schemas/deleted_tax_id',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/tax_id',
            },
            {
              $ref: '#/components/schemas/deleted_tax_id',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
    days_until_due: {
      description:
        'Number of days within which a customer must pay invoices generated by this subscription schedule. This value will be `null` for subscription schedules where `billing=charge_automatically`.',
      nullable: true,
      type: 'integer',
    },
    issuer: {
      anyOf: [
        {
          $ref: '#/components/schemas/connect_account_reference',
        },
      ],
      description:
        'The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.',
      nullable: true,
    },
  },
  title: 'InvoiceSettingSubscriptionSchedulePhaseSetting',
  type: 'object',
  'x-expandableFields': ['account_tax_ids', 'issuer'],
} as const;

export const invoice_setting_subscription_schedule_settingSchema = {
  description: '',
  properties: {
    account_tax_ids: {
      description:
        'The account tax IDs associated with the subscription schedule. Will be set on invoices generated by the subscription schedule.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/tax_id',
          },
          {
            $ref: '#/components/schemas/deleted_tax_id',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/tax_id',
            },
            {
              $ref: '#/components/schemas/deleted_tax_id',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
    days_until_due: {
      description:
        'Number of days within which a customer must pay invoices generated by this subscription schedule. This value will be `null` for subscription schedules where `billing=charge_automatically`.',
      nullable: true,
      type: 'integer',
    },
    issuer: {
      $ref: '#/components/schemas/connect_account_reference',
    },
  },
  required: ['issuer'],
  title: 'InvoiceSettingSubscriptionScheduleSetting',
  type: 'object',
  'x-expandableFields': ['account_tax_ids', 'issuer'],
} as const;

export const invoice_tax_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount, in cents (or local equivalent), of the tax.',
      type: 'integer',
    },
    inclusive: {
      description: 'Whether this tax amount is inclusive or exclusive.',
      type: 'boolean',
    },
    tax_rate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/tax_rate',
        },
      ],
      description: 'The tax rate that was applied to get this tax amount.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/tax_rate',
          },
        ],
      },
    },
    taxability_reason: {
      description:
        'The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.',
      enum: [
        'customer_exempt',
        'not_collecting',
        'not_subject_to_tax',
        'not_supported',
        'portion_product_exempt',
        'portion_reduced_rated',
        'portion_standard_rated',
        'product_exempt',
        'product_exempt_holiday',
        'proportionally_rated',
        'reduced_rated',
        'reverse_charge',
        'standard_rated',
        'taxable_basis_reduced',
        'zero_rated',
      ],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    taxable_amount: {
      description: 'The amount on which tax is calculated, in cents (or local equivalent).',
      nullable: true,
      type: 'integer',
    },
  },
  required: ['amount', 'inclusive', 'tax_rate'],
  title: 'InvoiceTaxAmount',
  type: 'object',
  'x-expandableFields': ['tax_rate'],
} as const;

export const invoice_threshold_reasonSchema = {
  description: '',
  properties: {
    amount_gte: {
      description: 'The total invoice amount threshold boundary if it triggered the threshold invoice.',
      nullable: true,
      type: 'integer',
    },
    item_reasons: {
      description: 'Indicates which line items triggered a threshold invoice.',
      items: {
        $ref: '#/components/schemas/invoice_item_threshold_reason',
      },
      type: 'array',
    },
  },
  required: ['item_reasons'],
  title: 'InvoiceThresholdReason',
  type: 'object',
  'x-expandableFields': ['item_reasons'],
} as const;

export const invoice_transfer_dataSchema = {
  description: '',
  properties: {
    amount: {
      description:
        'The amount in cents (or local equivalent) that will be transferred to the destination account when the invoice is paid. By default, the entire amount is transferred to the destination.',
      nullable: true,
      type: 'integer',
    },
    destination: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'The account where funds from the payment will be transferred to upon payment success.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
  },
  required: ['destination'],
  title: 'InvoiceTransferData',
  type: 'object',
  'x-expandableFields': ['destination'],
} as const;

export const invoiceitemSchema = {
  description: `Invoice Items represent the component lines of an [invoice](https://stripe.com/docs/api/invoices). An invoice item is added to an
invoice by creating or updating it with an \`invoice\` field, at which point it will be included as
[an invoice line item](https://stripe.com/docs/api/invoices/line_item) within
[invoice.lines](https://stripe.com/docs/api/invoices/object#invoice_object-lines).

Invoice Items can be created before you are ready to actually send the invoice. This can be particularly useful when combined
with a [subscription](https://stripe.com/docs/api/subscriptions). Sometimes you want to add a charge or credit to a customer, but actually charge
or credit the customer’s card only at the end of a regular billing cycle. This is useful for combining several charges
(to minimize per-transaction fees), or for having Stripe tabulate your usage-based billing totals.

Related guides: [Integrate with the Invoicing API](https://stripe.com/docs/invoicing/integration), [Subscription Invoices](https://stripe.com/docs/billing/invoices/subscription#adding-upcoming-invoice-items).`,
  properties: {
    amount: {
      description:
        'Amount (in the `currency` specified) of the invoice item. This should always be equal to `unit_amount * quantity`.',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: 'The ID of the customer who will be billed when this invoice item is billed.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    date: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    discountable: {
      description: 'If true, discounts will apply to this invoice item. Always false for prorations.',
      type: 'boolean',
    },
    discounts: {
      description:
        'The discounts which apply to the invoice item. Item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/discount',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/discount',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'The ID of the invoice this invoice item belongs to.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['invoiceitem'],
      type: 'string',
    },
    period: {
      $ref: '#/components/schemas/invoice_line_item_period',
    },
    price: {
      anyOf: [
        {
          $ref: '#/components/schemas/price',
        },
      ],
      description: 'The price of the invoice item.',
      nullable: true,
    },
    proration: {
      description:
        'Whether the invoice item was created automatically as a proration adjustment when the customer switched plans.',
      type: 'boolean',
    },
    quantity: {
      description:
        'Quantity of units for the invoice item. If the invoice item is a proration, the quantity of the subscription that the proration was computed for.',
      type: 'integer',
    },
    subscription: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/subscription',
        },
      ],
      description: 'The subscription that this invoice item has been created for, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/subscription',
          },
        ],
      },
    },
    subscription_item: {
      description: 'The subscription item that this invoice item has been created for, if any.',
      maxLength: 5000,
      type: 'string',
    },
    tax_rates: {
      description:
        'The tax rates which apply to the invoice item. When set, the `default_tax_rates` on the invoice do not apply to this invoice item.',
      items: {
        $ref: '#/components/schemas/tax_rate',
      },
      nullable: true,
      type: 'array',
    },
    test_clock: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/test_helpers.test_clock',
        },
      ],
      description: 'ID of the test clock this invoice item belongs to.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/test_helpers.test_clock',
          },
        ],
      },
    },
    unit_amount: {
      description: 'Unit amount (in the `currency` specified) of the invoice item.',
      nullable: true,
      type: 'integer',
    },
    unit_amount_decimal: {
      description: 'Same as `unit_amount`, but contains a decimal value with at most 12 decimal places.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'currency',
    'customer',
    'date',
    'discountable',
    'id',
    'livemode',
    'object',
    'period',
    'proration',
    'quantity',
  ],
  title: 'InvoiceItem',
  type: 'object',
  'x-expandableFields': [
    'customer',
    'discounts',
    'invoice',
    'period',
    'price',
    'subscription',
    'tax_rates',
    'test_clock',
  ],
  'x-resourceId': 'invoiceitem',
} as const;

export const invoices_payment_method_optionsSchema = {
  description: '',
  properties: {
    acss_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_acss_debit',
        },
      ],
      description:
        'If paying by `acss_debit`, this sub-hash contains details about the Canadian pre-authorized debit payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    bancontact: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_bancontact',
        },
      ],
      description:
        'If paying by `bancontact`, this sub-hash contains details about the Bancontact payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    card: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_card',
        },
      ],
      description:
        'If paying by `card`, this sub-hash contains details about the Card payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    customer_balance: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_customer_balance',
        },
      ],
      description:
        'If paying by `customer_balance`, this sub-hash contains details about the Bank transfer payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    konbini: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_konbini',
        },
      ],
      description:
        'If paying by `konbini`, this sub-hash contains details about the Konbini payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    sepa_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_sepa_debit',
        },
      ],
      description:
        'If paying by `sepa_debit`, this sub-hash contains details about the SEPA Direct Debit payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
    us_bank_account: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_payment_method_options_us_bank_account',
        },
      ],
      description:
        'If paying by `us_bank_account`, this sub-hash contains details about the ACH direct debit payment method options to pass to the invoice’s PaymentIntent.',
      nullable: true,
    },
  },
  title: 'InvoicesPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'bancontact',
    'card',
    'customer_balance',
    'konbini',
    'sepa_debit',
    'us_bank_account',
  ],
} as const;

export const invoices_payment_settingsSchema = {
  description: '',
  properties: {
    default_mandate: {
      description:
        "ID of the mandate to be used for this invoice. It must correspond to the payment method used to pay the invoice, including the invoice's default_payment_method or default_source, if set.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_method_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_payment_method_options',
        },
      ],
      description: 'Payment-method-specific configuration to provide to the invoice’s PaymentIntent.',
      nullable: true,
    },
    payment_method_types: {
      description:
        'The list of payment method types (e.g. card) to provide to the invoice’s PaymentIntent. If not set, Stripe attempts to automatically determine the types to use by looking at the invoice’s default payment method, the subscription’s default payment method, the customer’s default payment method, and your [invoice template settings](https://dashboard.stripe.com/settings/billing/invoice).',
      items: {
        enum: [
          'ach_credit_transfer',
          'ach_debit',
          'acss_debit',
          'amazon_pay',
          'au_becs_debit',
          'bacs_debit',
          'bancontact',
          'boleto',
          'card',
          'cashapp',
          'customer_balance',
          'eps',
          'fpx',
          'giropay',
          'grabpay',
          'ideal',
          'konbini',
          'link',
          'p24',
          'paynow',
          'paypal',
          'promptpay',
          'revolut_pay',
          'sepa_debit',
          'sofort',
          'swish',
          'us_bank_account',
          'wechat_pay',
        ],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'InvoicesPaymentSettings',
  type: 'object',
  'x-expandableFields': ['payment_method_options'],
} as const;

export const invoices_resource_from_invoiceSchema = {
  description: '',
  properties: {
    action: {
      description: 'The relation between this invoice and the cloned invoice',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'The invoice that was cloned.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
  },
  required: ['action', 'invoice'],
  title: 'InvoicesResourceFromInvoice',
  type: 'object',
  'x-expandableFields': ['invoice'],
} as const;

export const invoices_resource_invoice_renderingSchema = {
  description: '',
  properties: {
    amount_tax_display: {
      description: 'How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    pdf: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_rendering_pdf',
        },
      ],
      description: 'Invoice pdf rendering options',
      nullable: true,
    },
  },
  title: 'InvoicesResourceInvoiceRendering',
  type: 'object',
  'x-expandableFields': ['pdf'],
} as const;

export const invoices_resource_invoice_tax_idSchema = {
  description: '',
  properties: {
    type: {
      description:
        'The type of the tax ID, one of `ad_nrt`, `ar_cuit`, `eu_vat`, `bo_tin`, `br_cnpj`, `br_cpf`, `cn_tin`, `co_nit`, `cr_tin`, `do_rcn`, `ec_ruc`, `eu_oss_vat`, `pe_ruc`, `ro_tin`, `rs_pib`, `sv_nit`, `uy_ruc`, `ve_rif`, `vn_tin`, `gb_vat`, `nz_gst`, `au_abn`, `au_arn`, `in_gst`, `no_vat`, `no_voec`, `za_vat`, `ch_vat`, `mx_rfc`, `sg_uen`, `ru_inn`, `ru_kpp`, `ca_bn`, `hk_br`, `es_cif`, `tw_vat`, `th_vat`, `jp_cn`, `jp_rn`, `jp_trn`, `li_uid`, `my_itn`, `us_ein`, `kr_brn`, `ca_qst`, `ca_gst_hst`, `ca_pst_bc`, `ca_pst_mb`, `ca_pst_sk`, `my_sst`, `sg_gst`, `ae_trn`, `cl_tin`, `sa_vat`, `id_npwp`, `my_frp`, `il_vat`, `ge_vat`, `ua_vat`, `is_vat`, `bg_uic`, `hu_tin`, `si_tin`, `ke_pin`, `tr_tin`, `eg_tin`, `ph_tin`, `bh_vat`, `kz_bin`, `ng_tin`, `om_vat`, `de_stn`, or `unknown`',
      enum: [
        'ad_nrt',
        'ae_trn',
        'ar_cuit',
        'au_abn',
        'au_arn',
        'bg_uic',
        'bh_vat',
        'bo_tin',
        'br_cnpj',
        'br_cpf',
        'ca_bn',
        'ca_gst_hst',
        'ca_pst_bc',
        'ca_pst_mb',
        'ca_pst_sk',
        'ca_qst',
        'ch_vat',
        'cl_tin',
        'cn_tin',
        'co_nit',
        'cr_tin',
        'de_stn',
        'do_rcn',
        'ec_ruc',
        'eg_tin',
        'es_cif',
        'eu_oss_vat',
        'eu_vat',
        'gb_vat',
        'ge_vat',
        'hk_br',
        'hu_tin',
        'id_npwp',
        'il_vat',
        'in_gst',
        'is_vat',
        'jp_cn',
        'jp_rn',
        'jp_trn',
        'ke_pin',
        'kr_brn',
        'kz_bin',
        'li_uid',
        'mx_rfc',
        'my_frp',
        'my_itn',
        'my_sst',
        'ng_tin',
        'no_vat',
        'no_voec',
        'nz_gst',
        'om_vat',
        'pe_ruc',
        'ph_tin',
        'ro_tin',
        'rs_pib',
        'ru_inn',
        'ru_kpp',
        'sa_vat',
        'sg_gst',
        'sg_uen',
        'si_tin',
        'sv_nit',
        'th_vat',
        'tr_tin',
        'tw_vat',
        'ua_vat',
        'unknown',
        'us_ein',
        'uy_ruc',
        've_rif',
        'vn_tin',
        'za_vat',
      ],
      type: 'string',
    },
    value: {
      description: 'The value of the tax ID.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['type'],
  title: 'InvoicesResourceInvoiceTaxID',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoices_resource_line_items_credited_itemsSchema = {
  description: '',
  properties: {
    invoice: {
      description: 'Invoice containing the credited invoice line items',
      maxLength: 5000,
      type: 'string',
    },
    invoice_line_items: {
      description: 'Credited invoice line items',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['invoice', 'invoice_line_items'],
  title: 'InvoicesResourceLineItemsCreditedItems',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const invoices_resource_line_items_proration_detailsSchema = {
  description: '',
  properties: {
    credited_items: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_line_items_credited_items',
        },
      ],
      description:
        'For a credit proration `line_item`, the original debit line_items to which the credit proration applies.',
      nullable: true,
    },
  },
  title: 'InvoicesResourceLineItemsProrationDetails',
  type: 'object',
  'x-expandableFields': ['credited_items'],
} as const;

export const invoices_resource_shipping_costSchema = {
  description: '',
  properties: {
    amount_subtotal: {
      description: 'Total shipping cost before any taxes are applied.',
      type: 'integer',
    },
    amount_tax: {
      description: 'Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.',
      type: 'integer',
    },
    amount_total: {
      description: 'Total shipping cost after taxes are applied.',
      type: 'integer',
    },
    shipping_rate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/shipping_rate',
        },
      ],
      description: 'The ID of the ShippingRate for this invoice.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/shipping_rate',
          },
        ],
      },
    },
    taxes: {
      description: 'The taxes applied to the shipping rate.',
      items: {
        $ref: '#/components/schemas/line_items_tax_amount',
      },
      type: 'array',
    },
  },
  required: ['amount_subtotal', 'amount_tax', 'amount_total'],
  title: 'InvoicesResourceShippingCost',
  type: 'object',
  'x-expandableFields': ['shipping_rate', 'taxes'],
} as const;

export const invoices_resource_status_transitionsSchema = {
  description: '',
  properties: {
    finalized_at: {
      description: 'The time that the invoice draft was finalized.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    marked_uncollectible_at: {
      description: 'The time that the invoice was marked uncollectible.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    paid_at: {
      description: 'The time that the invoice was paid.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    voided_at: {
      description: 'The time that the invoice was voided.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'InvoicesResourceStatusTransitions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorizationSchema = {
  description: `When an [issued card](https://stripe.com/docs/issuing) is used to make a purchase, an Issuing \`Authorization\`
object is created. [Authorizations](https://stripe.com/docs/issuing/purchases/authorizations) must be approved for the
purchase to be completed successfully.

Related guide: [Issued card authorizations](https://stripe.com/docs/issuing/purchases/authorizations)`,
  properties: {
    amount: {
      description:
        'The total amount that was authorized or rejected. This amount is in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). `amount` should be the same as `merchant_amount`, unless `currency` and `merchant_currency` are different.',
      type: 'integer',
    },
    amount_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_amount_details',
        },
      ],
      description:
        'Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      nullable: true,
    },
    approved: {
      description: 'Whether the authorization has been approved.',
      type: 'boolean',
    },
    authorization_method: {
      description: 'How the card details were provided.',
      enum: ['chip', 'contactless', 'keyed_in', 'online', 'swipe'],
      type: 'string',
    },
    balance_transactions: {
      description: 'List of balance transactions associated with this authorization.',
      items: {
        $ref: '#/components/schemas/balance_transaction',
      },
      type: 'array',
    },
    card: {
      $ref: '#/components/schemas/issuing.card',
    },
    cardholder: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.cardholder',
        },
      ],
      description: 'The cardholder to whom this authorization belongs.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.cardholder',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'The currency of the cardholder. This currency can be different from the currency presented at authorization and the `merchant_currency` field on this authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    merchant_amount: {
      description:
        'The total amount that was authorized or rejected. This amount is in the `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). `merchant_amount` should be the same as `amount`, unless `merchant_currency` and `currency` are different.',
      type: 'integer',
    },
    merchant_currency: {
      description:
        'The local currency that was presented to the cardholder for the authorization. This currency can be different from the cardholder currency and the `currency` field on this authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    merchant_data: {
      $ref: '#/components/schemas/issuing_authorization_merchant_data',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    network_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_network_data',
        },
      ],
      description: 'Details about the authorization, such as identifiers, set by the card network.',
      nullable: true,
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.authorization'],
      type: 'string',
    },
    pending_request: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_pending_request',
        },
      ],
      description:
        'The pending authorization request. This field will only be non-null during an `issuing_authorization.request` webhook.',
      nullable: true,
    },
    request_history: {
      description:
        'History of every time a `pending_request` authorization was approved/declined, either by you directly or by Stripe (e.g. based on your spending_controls). If the merchant changes the authorization by performing an incremental authorization, you can look at this field to see the previous requests for the authorization. This field can be helpful in determining why a given authorization was approved/declined.',
      items: {
        $ref: '#/components/schemas/issuing_authorization_request',
      },
      type: 'array',
    },
    status: {
      description: 'The current status of the authorization in its lifecycle.',
      enum: ['closed', 'pending', 'reversed'],
      type: 'string',
    },
    token: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.token',
        },
      ],
      description:
        '[Token](https://stripe.com/docs/api/issuing/tokens/object) object used for this authorization. If a network token was not used for this authorization, this field will be null.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.token',
          },
        ],
      },
    },
    transactions: {
      description:
        'List of [transactions](https://stripe.com/docs/api/issuing/transactions) associated with this authorization.',
      items: {
        $ref: '#/components/schemas/issuing.transaction',
      },
      type: 'array',
    },
    treasury: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_treasury',
        },
      ],
      description:
        '[Treasury](https://stripe.com/docs/api/treasury) details related to this authorization if it was created on a [FinancialAccount](https://stripe.com/docs/api/treasury/financial_accounts).',
      nullable: true,
    },
    verification_data: {
      $ref: '#/components/schemas/issuing_authorization_verification_data',
    },
    wallet: {
      description:
        'The digital wallet used for this transaction. One of `apple_pay`, `google_pay`, or `samsung_pay`. Will populate as `null` when no digital wallet was utilized.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'approved',
    'authorization_method',
    'balance_transactions',
    'card',
    'created',
    'currency',
    'id',
    'livemode',
    'merchant_amount',
    'merchant_currency',
    'merchant_data',
    'metadata',
    'object',
    'request_history',
    'status',
    'transactions',
    'verification_data',
  ],
  title: 'IssuingAuthorization',
  type: 'object',
  'x-expandableFields': [
    'amount_details',
    'balance_transactions',
    'card',
    'cardholder',
    'merchant_data',
    'network_data',
    'pending_request',
    'request_history',
    'token',
    'transactions',
    'treasury',
    'verification_data',
  ],
  'x-resourceId': 'issuing.authorization',
} as const;

export const issuing_cardSchema = {
  description:
    'You can [create physical or virtual cards](https://stripe.com/docs/issuing/cards) that are issued to cardholders.',
  properties: {
    brand: {
      description: 'The brand of the card.',
      maxLength: 5000,
      type: 'string',
    },
    cancellation_reason: {
      description: 'The reason why the card was canceled.',
      enum: ['design_rejected', 'lost', 'stolen'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    cardholder: {
      $ref: '#/components/schemas/issuing.cardholder',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Supported currencies are `usd` in the US, `eur` in the EU, and `gbp` in the UK.',
      type: 'string',
    },
    cvc: {
      description: `The card's CVC. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with [the \`expand\` parameter](https://stripe.com/docs/api/expanding_objects). Additionally, it's only available via the ["Retrieve a card" endpoint](https://stripe.com/docs/api/issuing/cards/retrieve), not via "List all cards" or any other endpoint.`,
      maxLength: 5000,
      type: 'string',
    },
    exp_month: {
      description: 'The expiration month of the card.',
      type: 'integer',
    },
    exp_year: {
      description: 'The expiration year of the card.',
      type: 'integer',
    },
    financial_account: {
      description: 'The financial account this card is attached to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last4: {
      description: 'The last 4 digits of the card number.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    number: {
      description: `The full unredacted card number. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with [the \`expand\` parameter](https://stripe.com/docs/api/expanding_objects). Additionally, it's only available via the ["Retrieve a card" endpoint](https://stripe.com/docs/api/issuing/cards/retrieve), not via "List all cards" or any other endpoint.`,
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.card'],
      type: 'string',
    },
    personalization_design: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.personalization_design',
        },
      ],
      description: 'The personalization design object belonging to this card.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.personalization_design',
          },
        ],
      },
    },
    replaced_by: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.card',
        },
      ],
      description: 'The latest card that replaces this card, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.card',
          },
        ],
      },
    },
    replacement_for: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.card',
        },
      ],
      description: 'The card this card replaces, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.card',
          },
        ],
      },
    },
    replacement_reason: {
      description: 'The reason why the previous card needed to be replaced.',
      enum: ['damaged', 'expired', 'lost', 'stolen'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_card_shipping',
        },
      ],
      description: 'Where and how the card will be shipped.',
      nullable: true,
    },
    spending_controls: {
      $ref: '#/components/schemas/issuing_card_authorization_controls',
    },
    status: {
      description:
        'Whether authorizations can be approved on this card. May be blocked from activating cards depending on past-due Cardholder requirements. Defaults to `inactive`.',
      enum: ['active', 'canceled', 'inactive'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    type: {
      description: 'The type of the card.',
      enum: ['physical', 'virtual'],
      type: 'string',
    },
    wallets: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_card_wallets',
        },
      ],
      description: 'Information relating to digital wallets (like Apple Pay and Google Pay).',
      nullable: true,
    },
  },
  required: [
    'brand',
    'cardholder',
    'created',
    'currency',
    'exp_month',
    'exp_year',
    'id',
    'last4',
    'livemode',
    'metadata',
    'object',
    'spending_controls',
    'status',
    'type',
  ],
  title: 'IssuingCard',
  type: 'object',
  'x-expandableFields': [
    'cardholder',
    'personalization_design',
    'replaced_by',
    'replacement_for',
    'shipping',
    'spending_controls',
    'wallets',
  ],
  'x-resourceId': 'issuing.card',
} as const;

export const issuing_cardholderSchema = {
  description: `An Issuing \`Cardholder\` object represents an individual or business entity who is [issued](https://stripe.com/docs/issuing) cards.

Related guide: [How to create a cardholder](https://stripe.com/docs/issuing/cards#create-cardholder)`,
  properties: {
    billing: {
      $ref: '#/components/schemas/issuing_cardholder_address',
    },
    company: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_company',
        },
      ],
      description: 'Additional information about a `company` cardholder.',
      nullable: true,
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    email: {
      description: "The cardholder's email address.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    individual: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_individual',
        },
      ],
      description: 'Additional information about an `individual` cardholder.',
      nullable: true,
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    name: {
      description: "The cardholder's name. This will be printed on cards issued to them.",
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.cardholder'],
      type: 'string',
    },
    phone_number: {
      description:
        "The cardholder's phone number. This is required for all cardholders who will be creating EU cards. See the [3D Secure documentation](https://stripe.com/docs/issuing/3d-secure#when-is-3d-secure-applied) for more details.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_locales: {
      description: `The cardholder’s preferred locales (languages), ordered by preference. Locales can be \`de\`, \`en\`, \`es\`, \`fr\`, or \`it\`.
 This changes the language of the [3D Secure flow](https://stripe.com/docs/issuing/3d-secure) and one-time password messages sent to the cardholder.`,
      items: {
        enum: ['de', 'en', 'es', 'fr', 'it'],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    requirements: {
      $ref: '#/components/schemas/issuing_cardholder_requirements',
    },
    spending_controls: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_authorization_controls',
        },
      ],
      description:
        "Rules that control spending across this cardholder's cards. Refer to our [documentation](https://stripe.com/docs/issuing/controls/spending-controls) for more details.",
      nullable: true,
    },
    status: {
      description: "Specifies whether to permit authorizations on this cardholder's cards.",
      enum: ['active', 'blocked', 'inactive'],
      type: 'string',
    },
    type: {
      description:
        'One of `individual` or `company`. See [Choose a cardholder type](https://stripe.com/docs/issuing/other/choose-cardholder) for more details.',
      enum: ['company', 'individual'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['billing', 'created', 'id', 'livemode', 'metadata', 'name', 'object', 'requirements', 'status', 'type'],
  title: 'IssuingCardholder',
  type: 'object',
  'x-expandableFields': ['billing', 'company', 'individual', 'requirements', 'spending_controls'],
  'x-resourceId': 'issuing.cardholder',
} as const;

export const issuing_disputeSchema = {
  description: `As a [card issuer](https://stripe.com/docs/issuing), you can dispute transactions that the cardholder does not recognize, suspects to be fraudulent, or has other issues with.

Related guide: [Issuing disputes](https://stripe.com/docs/issuing/purchases/disputes)`,
  properties: {
    amount: {
      description:
        "Disputed amount in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). Usually the amount of the `transaction`, but can differ (usually because of currency fluctuation).",
      type: 'integer',
    },
    balance_transactions: {
      description: 'List of balance transactions associated with the dispute.',
      items: {
        $ref: '#/components/schemas/balance_transaction',
      },
      nullable: true,
      type: 'array',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description: 'The currency the `transaction` was made in.',
      type: 'string',
    },
    evidence: {
      $ref: '#/components/schemas/issuing_dispute_evidence',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    loss_reason: {
      description:
        'The enum that describes the dispute loss outcome. If the dispute is not lost, this field will be absent. New enum values may be added in the future, so be sure to handle unknown values.',
      enum: [
        'cardholder_authentication_issuer_liability',
        'eci5_token_transaction_with_tavv',
        'excess_disputes_in_timeframe',
        'has_not_met_the_minimum_dispute_amount_requirements',
        'invalid_duplicate_dispute',
        'invalid_incorrect_amount_dispute',
        'invalid_no_authorization',
        'invalid_use_of_disputes',
        'merchandise_delivered_or_shipped',
        'merchandise_or_service_as_described',
        'not_cancelled',
        'other',
        'refund_issued',
        'submitted_beyond_allowable_time_limit',
        'transaction_3ds_required',
        'transaction_approved_after_prior_fraud_dispute',
        'transaction_authorized',
        'transaction_electronically_read',
        'transaction_qualifies_for_visa_easy_payment_service',
        'transaction_unattended',
      ],
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.dispute'],
      type: 'string',
    },
    status: {
      description: 'Current status of the dispute.',
      enum: ['expired', 'lost', 'submitted', 'unsubmitted', 'won'],
      type: 'string',
    },
    transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.transaction',
        },
      ],
      description: 'The transaction being disputed.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.transaction',
          },
        ],
      },
    },
    treasury: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_dispute_treasury',
        },
      ],
      description:
        '[Treasury](https://stripe.com/docs/api/treasury) details related to this dispute if it was created on a [FinancialAccount](/docs/api/treasury/financial_accounts',
      nullable: true,
    },
  },
  required: [
    'amount',
    'created',
    'currency',
    'evidence',
    'id',
    'livemode',
    'metadata',
    'object',
    'status',
    'transaction',
  ],
  title: 'IssuingDispute',
  type: 'object',
  'x-expandableFields': ['balance_transactions', 'evidence', 'transaction', 'treasury'],
  'x-resourceId': 'issuing.dispute',
} as const;

export const issuing_personalization_designSchema = {
  description:
    'A Personalization Design is a logical grouping of a Physical Bundle, card logo, and carrier text that represents a product line.',
  properties: {
    card_logo: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The file for the card logo to use with physical bundles that support card logos. Must have a `purpose` value of `issuing_logo`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    carrier_text: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_personalization_design_carrier_text',
        },
      ],
      description: 'Hash containing carrier text, for use with physical bundles that support carrier text.',
      nullable: true,
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    lookup_key: {
      description:
        'A lookup key used to retrieve personalization designs dynamically from a static string. This may be up to 200 characters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    name: {
      description: 'Friendly display name.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.personalization_design'],
      type: 'string',
    },
    physical_bundle: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.physical_bundle',
        },
      ],
      description: 'The physical bundle object belonging to this personalization design.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.physical_bundle',
          },
        ],
      },
    },
    preferences: {
      $ref: '#/components/schemas/issuing_personalization_design_preferences',
    },
    rejection_reasons: {
      $ref: '#/components/schemas/issuing_personalization_design_rejection_reasons',
    },
    status: {
      description: 'Whether this personalization design can be used to create cards.',
      enum: ['active', 'inactive', 'rejected', 'review'],
      type: 'string',
    },
  },
  required: [
    'created',
    'id',
    'livemode',
    'metadata',
    'object',
    'physical_bundle',
    'preferences',
    'rejection_reasons',
    'status',
  ],
  title: 'IssuingPersonalizationDesign',
  type: 'object',
  'x-expandableFields': ['card_logo', 'carrier_text', 'physical_bundle', 'preferences', 'rejection_reasons'],
  'x-resourceId': 'issuing.personalization_design',
} as const;

export const issuing_physical_bundleSchema = {
  description:
    'A Physical Bundle represents the bundle of physical items - card stock, carrier letter, and envelope - that is shipped to a cardholder when you create a physical card.',
  properties: {
    features: {
      $ref: '#/components/schemas/issuing_physical_bundle_features',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    name: {
      description: 'Friendly display name.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.physical_bundle'],
      type: 'string',
    },
    status: {
      description: 'Whether this physical bundle can be used to create cards.',
      enum: ['active', 'inactive', 'review'],
      type: 'string',
    },
    type: {
      description: 'Whether this physical bundle is a standard Stripe offering or custom-made for you.',
      enum: ['custom', 'standard'],
      type: 'string',
    },
  },
  required: ['features', 'id', 'livemode', 'name', 'object', 'status', 'type'],
  title: 'IssuingPhysicalBundle',
  type: 'object',
  'x-expandableFields': ['features'],
  'x-resourceId': 'issuing.physical_bundle',
} as const;

export const issuing_settlementSchema = {
  description:
    'When a non-stripe BIN is used, any use of an [issued card](https://stripe.com/docs/issuing) must be settled directly with the card network. The net amount owed is represented by an Issuing `Settlement` object.',
  properties: {
    bin: {
      description: 'The Bank Identification Number reflecting this settlement record.',
      maxLength: 5000,
      type: 'string',
    },
    clearing_date: {
      description: "The date that the transactions are cleared and posted to user's accounts.",
      type: 'integer',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    interchange_fees: {
      description: 'The total interchange received as reimbursement for the transactions.',
      type: 'integer',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    net_total: {
      description: 'The total net amount required to settle with the network.',
      type: 'integer',
    },
    network: {
      description: 'The card network for this settlement report. One of ["visa"]',
      enum: ['visa'],
      type: 'string',
    },
    network_fees: {
      description: 'The total amount of fees owed to the network.',
      type: 'integer',
    },
    network_settlement_identifier: {
      description: 'The Settlement Identification Number assigned by the network.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.settlement'],
      type: 'string',
    },
    settlement_service: {
      description: 'One of `international` or `uk_national_net`.',
      maxLength: 5000,
      type: 'string',
    },
    transaction_count: {
      description: 'The total number of transactions reflected in this settlement.',
      type: 'integer',
    },
    transaction_volume: {
      description: 'The total transaction amount reflected in this settlement.',
      type: 'integer',
    },
  },
  required: [
    'bin',
    'clearing_date',
    'created',
    'currency',
    'id',
    'interchange_fees',
    'livemode',
    'metadata',
    'net_total',
    'network',
    'network_fees',
    'network_settlement_identifier',
    'object',
    'settlement_service',
    'transaction_count',
    'transaction_volume',
  ],
  title: 'IssuingSettlement',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'issuing.settlement',
} as const;

export const issuing_tokenSchema = {
  description:
    'An issuing token object is created when an issued card is added to a digital wallet. As a [card issuer](https://stripe.com/docs/issuing), you can [view and manage these tokens](https://stripe.com/docs/issuing/controls/token-management) through Stripe.',
  properties: {
    card: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.card',
        },
      ],
      description: 'Card associated with this token.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.card',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    device_fingerprint: {
      description: 'The hashed ID derived from the device ID from the card network associated with the token.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the token.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    network: {
      description: 'The token service provider / card network associated with the token.',
      enum: ['mastercard', 'visa'],
      type: 'string',
    },
    network_data: {
      $ref: '#/components/schemas/issuing_network_token_network_data',
    },
    network_updated_at: {
      description:
        'Time at which the token was last updated by the card network. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.token'],
      type: 'string',
    },
    status: {
      description: 'The usage state of the token.',
      enum: ['active', 'deleted', 'requested', 'suspended'],
      type: 'string',
    },
    wallet_provider: {
      description: 'The digital wallet for this token, if one was used.',
      enum: ['apple_pay', 'google_pay', 'samsung_pay'],
      type: 'string',
    },
  },
  required: ['card', 'created', 'id', 'livemode', 'network', 'network_updated_at', 'object', 'status'],
  title: 'IssuingNetworkToken',
  type: 'object',
  'x-expandableFields': ['card', 'network_data'],
  'x-resourceId': 'issuing.token',
} as const;

export const issuing_transactionSchema = {
  description: `Any use of an [issued card](https://stripe.com/docs/issuing) that results in funds entering or leaving
your Stripe account, such as a completed purchase or refund, is represented by an Issuing
\`Transaction\` object.

Related guide: [Issued card transactions](https://stripe.com/docs/issuing/purchases/transactions)`,
  properties: {
    amount: {
      description:
        'The transaction amount, which will be reflected in your balance. This amount is in your currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      type: 'integer',
    },
    amount_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_amount_details',
        },
      ],
      description:
        'Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      nullable: true,
    },
    authorization: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.authorization',
        },
      ],
      description: 'The `Authorization` object that led to this transaction.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.authorization',
          },
        ],
      },
    },
    balance_transaction: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/balance_transaction',
        },
      ],
      description:
        'ID of the [balance transaction](https://stripe.com/docs/api/balance_transactions) associated with this transaction.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/balance_transaction',
          },
        ],
      },
    },
    card: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.card',
        },
      ],
      description: 'The card used to make this transaction.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.card',
          },
        ],
      },
    },
    cardholder: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.cardholder',
        },
      ],
      description: 'The cardholder to whom this transaction belongs.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.cardholder',
          },
        ],
      },
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    dispute: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.dispute',
        },
      ],
      description: "If you've disputed the transaction, the ID of the dispute.",
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.dispute',
          },
        ],
      },
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    merchant_amount: {
      description:
        'The amount that the merchant will receive, denominated in `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). It will be different from `amount` if the merchant is taking payment in a different currency.',
      type: 'integer',
    },
    merchant_currency: {
      description: 'The currency with which the merchant is taking payment.',
      type: 'string',
    },
    merchant_data: {
      $ref: '#/components/schemas/issuing_authorization_merchant_data',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    network_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_network_data',
        },
      ],
      description: 'Details about the transaction, such as processing dates, set by the card network.',
      nullable: true,
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['issuing.transaction'],
      type: 'string',
    },
    purchase_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_purchase_details',
        },
      ],
      description: 'Additional purchase information that is optionally provided by the merchant.',
      nullable: true,
    },
    token: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/issuing.token',
        },
      ],
      description:
        '[Token](https://stripe.com/docs/api/issuing/tokens/object) object used for this transaction. If a network token was not used for this transaction, this field will be null.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/issuing.token',
          },
        ],
      },
    },
    treasury: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_treasury',
        },
      ],
      description:
        '[Treasury](https://stripe.com/docs/api/treasury) details related to this transaction if it was created on a [FinancialAccount](/docs/api/treasury/financial_accounts',
      nullable: true,
    },
    type: {
      description: 'The nature of the transaction.',
      enum: ['capture', 'refund'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    wallet: {
      description: 'The digital wallet used for this transaction. One of `apple_pay`, `google_pay`, or `samsung_pay`.',
      enum: ['apple_pay', 'google_pay', 'samsung_pay'],
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'card',
    'created',
    'currency',
    'id',
    'livemode',
    'merchant_amount',
    'merchant_currency',
    'merchant_data',
    'metadata',
    'object',
    'type',
  ],
  title: 'IssuingTransaction',
  type: 'object',
  'x-expandableFields': [
    'amount_details',
    'authorization',
    'balance_transaction',
    'card',
    'cardholder',
    'dispute',
    'merchant_data',
    'network_data',
    'purchase_details',
    'token',
    'treasury',
  ],
  'x-resourceId': 'issuing.transaction',
} as const;

export const issuing_authorization_amount_detailsSchema = {
  description: '',
  properties: {
    atm_fee: {
      description: 'The fee charged by the ATM for the cash withdrawal.',
      nullable: true,
      type: 'integer',
    },
    cashback_amount: {
      description: 'The amount of cash requested by the cardholder.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingAuthorizationAmountDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_authentication_exemptionSchema = {
  description: '',
  properties: {
    claimed_by: {
      description: 'The entity that requested the exemption, either the acquiring merchant or the Issuing user.',
      enum: ['acquirer', 'issuer'],
      type: 'string',
    },
    type: {
      description: 'The specific exemption claimed for this authorization.',
      enum: ['low_value_transaction', 'transaction_risk_analysis', 'unknown'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['claimed_by', 'type'],
  title: 'IssuingAuthorizationAuthenticationExemption',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_merchant_dataSchema = {
  description: '',
  properties: {
    category: {
      description:
        "A categorization of the seller's type of business. See our [merchant categories guide](https://stripe.com/docs/issuing/merchant-categories) for a list of possible values.",
      maxLength: 5000,
      type: 'string',
    },
    category_code: {
      description: 'The merchant category code for the seller’s business',
      maxLength: 5000,
      type: 'string',
    },
    city: {
      description: 'City where the seller is located',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Country where the seller is located',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'Name of the seller',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    network_id: {
      description:
        'Identifier assigned to the seller by the card network. Different card networks may assign different network_id fields to the same merchant.',
      maxLength: 5000,
      type: 'string',
    },
    postal_code: {
      description: 'Postal code where the seller is located',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    state: {
      description: 'State where the seller is located',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    terminal_id: {
      description: 'An ID assigned by the seller to the location of the sale.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'URL provided by the merchant on a 3DS request',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['category', 'category_code', 'network_id'],
  title: 'IssuingAuthorizationMerchantData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_network_dataSchema = {
  description: '',
  properties: {
    acquiring_institution_id: {
      description:
        'Identifier assigned to the acquirer by the card network. Sometimes this value is not provided by the network; in this case, the value will be `null`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    system_trace_audit_number: {
      description:
        'The System Trace Audit Number (STAN) is a 6-digit identifier assigned by the acquirer. Prefer `network_data.transaction_id` if present, unless you have special requirements.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_id: {
      description:
        'Unique identifier for the authorization assigned by the card network used to match subsequent messages, disputes, and transactions.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingAuthorizationNetworkData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_pending_requestSchema = {
  description: '',
  properties: {
    amount: {
      description:
        "The additional amount Stripe will hold if the authorization is approved, in the card's [currency](https://stripe.com/docs/api#issuing_authorization_object-pending-request-currency) and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).",
      type: 'integer',
    },
    amount_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_amount_details',
        },
      ],
      description:
        'Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      nullable: true,
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    is_amount_controllable: {
      description:
        'If set `true`, you may provide [amount](https://stripe.com/docs/api/issuing/authorizations/approve#approve_issuing_authorization-amount) to control how much to hold for the authorization.',
      type: 'boolean',
    },
    merchant_amount: {
      description:
        'The amount the merchant is requesting to be authorized in the `merchant_currency`. The amount is in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      type: 'integer',
    },
    merchant_currency: {
      description: 'The local currency the merchant is requesting to authorize.',
      type: 'string',
    },
    network_risk_score: {
      description:
        "The card network's estimate of the likelihood that an authorization is fraudulent. Takes on values between 1 and 99.",
      nullable: true,
      type: 'integer',
    },
  },
  required: ['amount', 'currency', 'is_amount_controllable', 'merchant_amount', 'merchant_currency'],
  title: 'IssuingAuthorizationPendingRequest',
  type: 'object',
  'x-expandableFields': ['amount_details'],
} as const;

export const issuing_authorization_requestSchema = {
  description: '',
  properties: {
    amount: {
      description:
        "The `pending_request.amount` at the time of the request, presented in your card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal). Stripe held this amount from your account to fund the authorization if the request was approved.",
      type: 'integer',
    },
    amount_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_amount_details',
        },
      ],
      description:
        'Detailed breakdown of amount components. These amounts are denominated in `currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      nullable: true,
    },
    approved: {
      description: 'Whether this request was approved.',
      type: 'boolean',
    },
    authorization_code: {
      description:
        'A code created by Stripe which is shared with the merchant to validate the authorization. This field will be populated if the authorization message was approved. The code typically starts with the letter "S", followed by a six-digit number. For example, "S498162". Please note that the code is not guaranteed to be unique across authorizations.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      maxLength: 5000,
      type: 'string',
    },
    merchant_amount: {
      description:
        'The `pending_request.merchant_amount` at the time of the request, presented in the `merchant_currency` and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).',
      type: 'integer',
    },
    merchant_currency: {
      description:
        'The currency that was collected by the merchant and presented to the cardholder for the authorization. Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      maxLength: 5000,
      type: 'string',
    },
    network_risk_score: {
      description:
        "The card network's estimate of the likelihood that an authorization is fraudulent. Takes on values between 1 and 99.",
      nullable: true,
      type: 'integer',
    },
    reason: {
      description:
        'When an authorization is approved or declined by you or by Stripe, this field provides additional detail on the reason for the outcome.',
      enum: [
        'account_disabled',
        'card_active',
        'card_inactive',
        'cardholder_inactive',
        'cardholder_verification_required',
        'insufficient_funds',
        'not_allowed',
        'spending_controls',
        'suspected_fraud',
        'verification_failed',
        'webhook_approved',
        'webhook_declined',
        'webhook_error',
        'webhook_timeout',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    reason_message: {
      description:
        'If the `request_history.reason` is `webhook_error` because the direct webhook response is invalid (for example, parsing errors or missing parameters), we surface a more detailed error message via this field.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    requested_at: {
      description:
        'Time when the card network received an authorization request from the acquirer in UTC. Referred to by networks as transmission time.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  required: ['amount', 'approved', 'created', 'currency', 'merchant_amount', 'merchant_currency', 'reason'],
  title: 'IssuingAuthorizationRequest',
  type: 'object',
  'x-expandableFields': ['amount_details'],
} as const;

export const issuing_authorization_three_d_secureSchema = {
  description: '',
  properties: {
    result: {
      description: 'The outcome of the 3D Secure authentication request.',
      enum: ['attempt_acknowledged', 'authenticated', 'failed', 'required'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['result'],
  title: 'IssuingAuthorizationThreeDSecure',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_treasurySchema = {
  description: '',
  properties: {
    received_credits: {
      description:
        'The array of [ReceivedCredits](https://stripe.com/docs/api/treasury/received_credits) associated with this authorization',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    received_debits: {
      description:
        'The array of [ReceivedDebits](https://stripe.com/docs/api/treasury/received_debits) associated with this authorization',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    transaction: {
      description:
        'The Treasury [Transaction](https://stripe.com/docs/api/treasury/transactions) associated with this authorization',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['received_credits', 'received_debits'],
  title: 'IssuingAuthorizationTreasury',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_authorization_verification_dataSchema = {
  description: '',
  properties: {
    address_line1_check: {
      description:
        'Whether the cardholder provided an address first line and if it matched the cardholder’s `billing.address.line1`.',
      enum: ['match', 'mismatch', 'not_provided'],
      type: 'string',
    },
    address_postal_code_check: {
      description:
        'Whether the cardholder provided a postal code and if it matched the cardholder’s `billing.address.postal_code`.',
      enum: ['match', 'mismatch', 'not_provided'],
      type: 'string',
    },
    authentication_exemption: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_authentication_exemption',
        },
      ],
      description: 'The exemption applied to this authorization.',
      nullable: true,
    },
    cvc_check: {
      description: 'Whether the cardholder provided a CVC and if it matched Stripe’s record.',
      enum: ['match', 'mismatch', 'not_provided'],
      type: 'string',
    },
    expiry_check: {
      description: 'Whether the cardholder provided an expiry date and if it matched Stripe’s record.',
      enum: ['match', 'mismatch', 'not_provided'],
      type: 'string',
    },
    postal_code: {
      description: 'The postal code submitted as part of the authorization used for postal code verification.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    three_d_secure: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_authorization_three_d_secure',
        },
      ],
      description: '3D Secure details.',
      nullable: true,
    },
  },
  required: ['address_line1_check', 'address_postal_code_check', 'cvc_check', 'expiry_check'],
  title: 'IssuingAuthorizationVerificationData',
  type: 'object',
  'x-expandableFields': ['authentication_exemption', 'three_d_secure'],
} as const;

export const issuing_card_apple_paySchema = {
  description: '',
  properties: {
    eligible: {
      description: 'Apple Pay Eligibility',
      type: 'boolean',
    },
    ineligible_reason: {
      description: 'Reason the card is ineligible for Apple Pay',
      enum: ['missing_agreement', 'missing_cardholder_contact', 'unsupported_region'],
      nullable: true,
      type: 'string',
    },
  },
  required: ['eligible'],
  title: 'IssuingCardApplePay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_card_authorization_controlsSchema = {
  description: '',
  properties: {
    allowed_categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to allow. All other categories will be blocked. Cannot be set with `blocked_categories`.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    allowed_merchant_countries: {
      description:
        'Array of strings containing representing countries from which authorizations will be allowed. Authorizations from merchants in all other countries will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `blocked_merchant_countries`. Provide an empty value to unset this control.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    blocked_categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to decline. All other categories will be allowed. Cannot be set with `allowed_categories`.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    blocked_merchant_countries: {
      description:
        'Array of strings containing representing countries from which authorizations will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `allowed_merchant_countries`. Provide an empty value to unset this control.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    spending_limits: {
      description:
        "Limit spending with amount-based rules that apply across any cards this card replaced (i.e., its `replacement_for` card and _that_ card's `replacement_for` card, up the chain).",
      items: {
        $ref: '#/components/schemas/issuing_card_spending_limit',
      },
      nullable: true,
      type: 'array',
    },
    spending_limits_currency: {
      description: 'Currency of the amounts within `spending_limits`. Always the same as the currency of the card.',
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingCardAuthorizationControls',
  type: 'object',
  'x-expandableFields': ['spending_limits'],
} as const;

export const issuing_card_google_paySchema = {
  description: '',
  properties: {
    eligible: {
      description: 'Google Pay Eligibility',
      type: 'boolean',
    },
    ineligible_reason: {
      description: 'Reason the card is ineligible for Google Pay',
      enum: ['missing_agreement', 'missing_cardholder_contact', 'unsupported_region'],
      nullable: true,
      type: 'string',
    },
  },
  required: ['eligible'],
  title: 'IssuingCardGooglePay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_card_shippingSchema = {
  description: '',
  properties: {
    address: {
      $ref: '#/components/schemas/address',
    },
    carrier: {
      description: 'The delivery company that shipped a card.',
      enum: ['dhl', 'fedex', 'royal_mail', 'usps'],
      nullable: true,
      type: 'string',
    },
    customs: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_card_shipping_customs',
        },
      ],
      description: 'Additional information that may be required for clearing customs.',
      nullable: true,
    },
    eta: {
      description: 'A unix timestamp representing a best estimate of when the card will be delivered.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    name: {
      description: 'Recipient name.',
      maxLength: 5000,
      type: 'string',
    },
    phone_number: {
      description:
        'The phone number of the receiver of the shipment. Our courier partners will use this number to contact you in the event of card delivery issues. For individual shipments to the EU/UK, if this field is empty, we will provide them with the phone number provided when the cardholder was initially created.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    require_signature: {
      description:
        'Whether a signature is required for card delivery. This feature is only supported for US users. Standard shipping service does not support signature on delivery. The default value for standard shipping service is false and for express and priority services is true.',
      nullable: true,
      type: 'boolean',
    },
    service: {
      description: 'Shipment service, such as `standard` or `express`.',
      enum: ['express', 'priority', 'standard'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    status: {
      description: 'The delivery status of the card.',
      enum: ['canceled', 'delivered', 'failure', 'pending', 'returned', 'shipped'],
      nullable: true,
      type: 'string',
    },
    tracking_number: {
      description: 'A tracking number for a card shipment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    tracking_url: {
      description:
        "A link to the shipping carrier's site where you can view detailed information about a card shipment.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description: 'Packaging options.',
      enum: ['bulk', 'individual'],
      type: 'string',
    },
  },
  required: ['address', 'name', 'service', 'type'],
  title: 'IssuingCardShipping',
  type: 'object',
  'x-expandableFields': ['address', 'customs'],
} as const;

export const issuing_card_shipping_customsSchema = {
  description: '',
  properties: {
    eori_number: {
      description:
        'A registration number used for customs in Europe. See [https://www.gov.uk/eori](https://www.gov.uk/eori) for the UK and [https://ec.europa.eu/taxation_customs/business/customs-procedures-import-and-export/customs-procedures/economic-operators-registration-and-identification-number-eori_en](https://ec.europa.eu/taxation_customs/business/customs-procedures-import-and-export/customs-procedures/economic-operators-registration-and-identification-number-eori_en) for the EU.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingCardShippingCustoms',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_card_spending_limitSchema = {
  description: '',
  properties: {
    amount: {
      description:
        "Maximum amount allowed to spend per interval. This amount is in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).",
      type: 'integer',
    },
    categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) this limit applies to. Omitting this field will apply the limit to all categories.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    interval: {
      description: 'Interval (or event) to which the amount applies.',
      enum: ['all_time', 'daily', 'monthly', 'per_authorization', 'weekly', 'yearly'],
      type: 'string',
    },
  },
  required: ['amount', 'interval'],
  title: 'IssuingCardSpendingLimit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_card_walletsSchema = {
  description: '',
  properties: {
    apple_pay: {
      $ref: '#/components/schemas/issuing_card_apple_pay',
    },
    google_pay: {
      $ref: '#/components/schemas/issuing_card_google_pay',
    },
    primary_account_identifier: {
      description: 'Unique identifier for a card used with digital wallets',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['apple_pay', 'google_pay'],
  title: 'IssuingCardWallets',
  type: 'object',
  'x-expandableFields': ['apple_pay', 'google_pay'],
} as const;

export const issuing_cardholder_addressSchema = {
  description: '',
  properties: {
    address: {
      $ref: '#/components/schemas/address',
    },
  },
  required: ['address'],
  title: 'IssuingCardholderAddress',
  type: 'object',
  'x-expandableFields': ['address'],
} as const;

export const issuing_cardholder_authorization_controlsSchema = {
  description: '',
  properties: {
    allowed_categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to allow. All other categories will be blocked. Cannot be set with `blocked_categories`.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    allowed_merchant_countries: {
      description:
        'Array of strings containing representing countries from which authorizations will be allowed. Authorizations from merchants in all other countries will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `blocked_merchant_countries`. Provide an empty value to unset this control.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    blocked_categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) of authorizations to decline. All other categories will be allowed. Cannot be set with `allowed_categories`.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    blocked_merchant_countries: {
      description:
        'Array of strings containing representing countries from which authorizations will be declined. Country codes should be ISO 3166 alpha-2 country codes (e.g. `US`). Cannot be set with `allowed_merchant_countries`. Provide an empty value to unset this control.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    spending_limits: {
      description: "Limit spending with amount-based rules that apply across this cardholder's cards.",
      items: {
        $ref: '#/components/schemas/issuing_cardholder_spending_limit',
      },
      nullable: true,
      type: 'array',
    },
    spending_limits_currency: {
      description: 'Currency of the amounts within `spending_limits`.',
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingCardholderAuthorizationControls',
  type: 'object',
  'x-expandableFields': ['spending_limits'],
} as const;

export const issuing_cardholder_card_issuingSchema = {
  description: '',
  properties: {
    user_terms_acceptance: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_user_terms_acceptance',
        },
      ],
      description:
        'Information about cardholder acceptance of Celtic [Authorized User Terms](https://stripe.com/docs/issuing/cards#accept-authorized-user-terms). Required for cards backed by a Celtic program.',
      nullable: true,
    },
  },
  title: 'IssuingCardholderCardIssuing',
  type: 'object',
  'x-expandableFields': ['user_terms_acceptance'],
} as const;

export const issuing_cardholder_companySchema = {
  description: '',
  properties: {
    tax_id_provided: {
      description: "Whether the company's business ID number was provided.",
      type: 'boolean',
    },
  },
  required: ['tax_id_provided'],
  title: 'IssuingCardholderCompany',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_cardholder_id_documentSchema = {
  description: '',
  properties: {
    back: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The back of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    front: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The front of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
  },
  title: 'IssuingCardholderIdDocument',
  type: 'object',
  'x-expandableFields': ['back', 'front'],
} as const;

export const issuing_cardholder_individualSchema = {
  description: '',
  properties: {
    card_issuing: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_card_issuing',
        },
      ],
      description: 'Information related to the card_issuing program for this cardholder.',
      nullable: true,
    },
    dob: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_individual_dob',
        },
      ],
      description: 'The date of birth of this cardholder.',
      nullable: true,
    },
    first_name: {
      description:
        'The first name of this cardholder. Required before activating Cards. This field cannot contain any numbers, special characters (except periods, commas, hyphens, spaces and apostrophes) or non-latin letters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last_name: {
      description:
        'The last name of this cardholder. Required before activating Cards. This field cannot contain any numbers, special characters (except periods, commas, hyphens, spaces and apostrophes) or non-latin letters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verification: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_verification',
        },
      ],
      description: 'Government-issued ID document for this cardholder.',
      nullable: true,
    },
  },
  title: 'IssuingCardholderIndividual',
  type: 'object',
  'x-expandableFields': ['card_issuing', 'dob', 'verification'],
} as const;

export const issuing_cardholder_individual_dobSchema = {
  description: '',
  properties: {
    day: {
      description: 'The day of birth, between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'The month of birth, between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year of birth.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingCardholderIndividualDOB',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_cardholder_requirementsSchema = {
  description: '',
  properties: {
    disabled_reason: {
      description:
        'If `disabled_reason` is present, all cards will decline authorizations with `cardholder_verification_required` reason.',
      enum: ['listed', 'rejected.listed', 'requirements.past_due', 'under_review'],
      nullable: true,
      type: 'string',
    },
    past_due: {
      description: 'Array of fields that need to be collected in order to verify and re-enable the cardholder.',
      items: {
        enum: [
          'company.tax_id',
          'individual.card_issuing.user_terms_acceptance.date',
          'individual.card_issuing.user_terms_acceptance.ip',
          'individual.dob.day',
          'individual.dob.month',
          'individual.dob.year',
          'individual.first_name',
          'individual.last_name',
          'individual.verification.document',
        ],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'IssuingCardholderRequirements',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_cardholder_spending_limitSchema = {
  description: '',
  properties: {
    amount: {
      description:
        "Maximum amount allowed to spend per interval. This amount is in the card's currency and in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).",
      type: 'integer',
    },
    categories: {
      description:
        'Array of strings containing [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category) this limit applies to. Omitting this field will apply the limit to all categories.',
      items: {
        enum: [
          'ac_refrigeration_repair',
          'accounting_bookkeeping_services',
          'advertising_services',
          'agricultural_cooperative',
          'airlines_air_carriers',
          'airports_flying_fields',
          'ambulance_services',
          'amusement_parks_carnivals',
          'antique_reproductions',
          'antique_shops',
          'aquariums',
          'architectural_surveying_services',
          'art_dealers_and_galleries',
          'artists_supply_and_craft_shops',
          'auto_and_home_supply_stores',
          'auto_body_repair_shops',
          'auto_paint_shops',
          'auto_service_shops',
          'automated_cash_disburse',
          'automated_fuel_dispensers',
          'automobile_associations',
          'automotive_parts_and_accessories_stores',
          'automotive_tire_stores',
          'bail_and_bond_payments',
          'bakeries',
          'bands_orchestras',
          'barber_and_beauty_shops',
          'betting_casino_gambling',
          'bicycle_shops',
          'billiard_pool_establishments',
          'boat_dealers',
          'boat_rentals_and_leases',
          'book_stores',
          'books_periodicals_and_newspapers',
          'bowling_alleys',
          'bus_lines',
          'business_secretarial_schools',
          'buying_shopping_services',
          'cable_satellite_and_other_pay_television_and_radio',
          'camera_and_photographic_supply_stores',
          'candy_nut_and_confectionery_stores',
          'car_and_truck_dealers_new_used',
          'car_and_truck_dealers_used_only',
          'car_rental_agencies',
          'car_washes',
          'carpentry_services',
          'carpet_upholstery_cleaning',
          'caterers',
          'charitable_and_social_service_organizations_fundraising',
          'chemicals_and_allied_products',
          'child_care_services',
          'childrens_and_infants_wear_stores',
          'chiropodists_podiatrists',
          'chiropractors',
          'cigar_stores_and_stands',
          'civic_social_fraternal_associations',
          'cleaning_and_maintenance',
          'clothing_rental',
          'colleges_universities',
          'commercial_equipment',
          'commercial_footwear',
          'commercial_photography_art_and_graphics',
          'commuter_transport_and_ferries',
          'computer_network_services',
          'computer_programming',
          'computer_repair',
          'computer_software_stores',
          'computers_peripherals_and_software',
          'concrete_work_services',
          'construction_materials',
          'consulting_public_relations',
          'correspondence_schools',
          'cosmetic_stores',
          'counseling_services',
          'country_clubs',
          'courier_services',
          'court_costs',
          'credit_reporting_agencies',
          'cruise_lines',
          'dairy_products_stores',
          'dance_hall_studios_schools',
          'dating_escort_services',
          'dentists_orthodontists',
          'department_stores',
          'detective_agencies',
          'digital_goods_applications',
          'digital_goods_games',
          'digital_goods_large_volume',
          'digital_goods_media',
          'direct_marketing_catalog_merchant',
          'direct_marketing_combination_catalog_and_retail_merchant',
          'direct_marketing_inbound_telemarketing',
          'direct_marketing_insurance_services',
          'direct_marketing_other',
          'direct_marketing_outbound_telemarketing',
          'direct_marketing_subscription',
          'direct_marketing_travel',
          'discount_stores',
          'doctors',
          'door_to_door_sales',
          'drapery_window_covering_and_upholstery_stores',
          'drinking_places',
          'drug_stores_and_pharmacies',
          'drugs_drug_proprietaries_and_druggist_sundries',
          'dry_cleaners',
          'durable_goods',
          'duty_free_stores',
          'eating_places_restaurants',
          'educational_services',
          'electric_razor_stores',
          'electric_vehicle_charging',
          'electrical_parts_and_equipment',
          'electrical_services',
          'electronics_repair_shops',
          'electronics_stores',
          'elementary_secondary_schools',
          'emergency_services_gcas_visa_use_only',
          'employment_temp_agencies',
          'equipment_rental',
          'exterminating_services',
          'family_clothing_stores',
          'fast_food_restaurants',
          'financial_institutions',
          'fines_government_administrative_entities',
          'fireplace_fireplace_screens_and_accessories_stores',
          'floor_covering_stores',
          'florists',
          'florists_supplies_nursery_stock_and_flowers',
          'freezer_and_locker_meat_provisioners',
          'fuel_dealers_non_automotive',
          'funeral_services_crematories',
          'furniture_home_furnishings_and_equipment_stores_except_appliances',
          'furniture_repair_refinishing',
          'furriers_and_fur_shops',
          'general_services',
          'gift_card_novelty_and_souvenir_shops',
          'glass_paint_and_wallpaper_stores',
          'glassware_crystal_stores',
          'golf_courses_public',
          'government_licensed_horse_dog_racing_us_region_only',
          'government_licensed_online_casions_online_gambling_us_region_only',
          'government_owned_lotteries_non_us_region',
          'government_owned_lotteries_us_region_only',
          'government_services',
          'grocery_stores_supermarkets',
          'hardware_equipment_and_supplies',
          'hardware_stores',
          'health_and_beauty_spas',
          'hearing_aids_sales_and_supplies',
          'heating_plumbing_a_c',
          'hobby_toy_and_game_shops',
          'home_supply_warehouse_stores',
          'hospitals',
          'hotels_motels_and_resorts',
          'household_appliance_stores',
          'industrial_supplies',
          'information_retrieval_services',
          'insurance_default',
          'insurance_underwriting_premiums',
          'intra_company_purchases',
          'jewelry_stores_watches_clocks_and_silverware_stores',
          'landscaping_services',
          'laundries',
          'laundry_cleaning_services',
          'legal_services_attorneys',
          'luggage_and_leather_goods_stores',
          'lumber_building_materials_stores',
          'manual_cash_disburse',
          'marinas_service_and_supplies',
          'marketplaces',
          'masonry_stonework_and_plaster',
          'massage_parlors',
          'medical_and_dental_labs',
          'medical_dental_ophthalmic_and_hospital_equipment_and_supplies',
          'medical_services',
          'membership_organizations',
          'mens_and_boys_clothing_and_accessories_stores',
          'mens_womens_clothing_stores',
          'metal_service_centers',
          'miscellaneous',
          'miscellaneous_apparel_and_accessory_shops',
          'miscellaneous_auto_dealers',
          'miscellaneous_business_services',
          'miscellaneous_food_stores',
          'miscellaneous_general_merchandise',
          'miscellaneous_general_services',
          'miscellaneous_home_furnishing_specialty_stores',
          'miscellaneous_publishing_and_printing',
          'miscellaneous_recreation_services',
          'miscellaneous_repair_shops',
          'miscellaneous_specialty_retail',
          'mobile_home_dealers',
          'motion_picture_theaters',
          'motor_freight_carriers_and_trucking',
          'motor_homes_dealers',
          'motor_vehicle_supplies_and_new_parts',
          'motorcycle_shops_and_dealers',
          'motorcycle_shops_dealers',
          'music_stores_musical_instruments_pianos_and_sheet_music',
          'news_dealers_and_newsstands',
          'non_fi_money_orders',
          'non_fi_stored_value_card_purchase_load',
          'nondurable_goods',
          'nurseries_lawn_and_garden_supply_stores',
          'nursing_personal_care',
          'office_and_commercial_furniture',
          'opticians_eyeglasses',
          'optometrists_ophthalmologist',
          'orthopedic_goods_prosthetic_devices',
          'osteopaths',
          'package_stores_beer_wine_and_liquor',
          'paints_varnishes_and_supplies',
          'parking_lots_garages',
          'passenger_railways',
          'pawn_shops',
          'pet_shops_pet_food_and_supplies',
          'petroleum_and_petroleum_products',
          'photo_developing',
          'photographic_photocopy_microfilm_equipment_and_supplies',
          'photographic_studios',
          'picture_video_production',
          'piece_goods_notions_and_other_dry_goods',
          'plumbing_heating_equipment_and_supplies',
          'political_organizations',
          'postal_services_government_only',
          'precious_stones_and_metals_watches_and_jewelry',
          'professional_services',
          'public_warehousing_and_storage',
          'quick_copy_repro_and_blueprint',
          'railroads',
          'real_estate_agents_and_managers_rentals',
          'record_stores',
          'recreational_vehicle_rentals',
          'religious_goods_stores',
          'religious_organizations',
          'roofing_siding_sheet_metal',
          'secretarial_support_services',
          'security_brokers_dealers',
          'service_stations',
          'sewing_needlework_fabric_and_piece_goods_stores',
          'shoe_repair_hat_cleaning',
          'shoe_stores',
          'small_appliance_repair',
          'snowmobile_dealers',
          'special_trade_services',
          'specialty_cleaning',
          'sporting_goods_stores',
          'sporting_recreation_camps',
          'sports_and_riding_apparel_stores',
          'sports_clubs_fields',
          'stamp_and_coin_stores',
          'stationary_office_supplies_printing_and_writing_paper',
          'stationery_stores_office_and_school_supply_stores',
          'swimming_pools_sales',
          't_ui_travel_germany',
          'tailors_alterations',
          'tax_payments_government_agencies',
          'tax_preparation_services',
          'taxicabs_limousines',
          'telecommunication_equipment_and_telephone_sales',
          'telecommunication_services',
          'telegraph_services',
          'tent_and_awning_shops',
          'testing_laboratories',
          'theatrical_ticket_agencies',
          'timeshares',
          'tire_retreading_and_repair',
          'tolls_bridge_fees',
          'tourist_attractions_and_exhibits',
          'towing_services',
          'trailer_parks_campgrounds',
          'transportation_services',
          'travel_agencies_tour_operators',
          'truck_stop_iteration',
          'truck_utility_trailer_rentals',
          'typesetting_plate_making_and_related_services',
          'typewriter_stores',
          'u_s_federal_government_agencies_or_departments',
          'uniforms_commercial_clothing',
          'used_merchandise_and_secondhand_stores',
          'utilities',
          'variety_stores',
          'veterinary_services',
          'video_amusement_game_supplies',
          'video_game_arcades',
          'video_tape_rental_stores',
          'vocational_trade_schools',
          'watch_jewelry_repair',
          'welding_repair',
          'wholesale_clubs',
          'wig_and_toupee_stores',
          'wires_money_orders',
          'womens_accessory_and_specialty_shops',
          'womens_ready_to_wear_stores',
          'wrecking_and_salvage_yards',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    interval: {
      description: 'Interval (or event) to which the amount applies.',
      enum: ['all_time', 'daily', 'monthly', 'per_authorization', 'weekly', 'yearly'],
      type: 'string',
    },
  },
  required: ['amount', 'interval'],
  title: 'IssuingCardholderSpendingLimit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_cardholder_user_terms_acceptanceSchema = {
  description: '',
  properties: {
    date: {
      description: 'The Unix timestamp marking when the cardholder accepted the Authorized User Terms.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    ip: {
      description: 'The IP address from which the cardholder accepted the Authorized User Terms.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description: 'The user agent of the browser from which the cardholder accepted the Authorized User Terms.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingCardholderUserTermsAcceptance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_cardholder_verificationSchema = {
  description: '',
  properties: {
    document: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_cardholder_id_document',
        },
      ],
      description: 'An identifying document, either a passport or local ID card.',
      nullable: true,
    },
  },
  title: 'IssuingCardholderVerification',
  type: 'object',
  'x-expandableFields': ['document'],
} as const;

export const issuing_dispute_canceled_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    canceled_at: {
      description: 'Date when order was canceled.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    cancellation_policy_provided: {
      description: 'Whether the cardholder was provided with a cancellation policy.',
      nullable: true,
      type: 'boolean',
    },
    cancellation_reason: {
      description: 'Reason for canceling the order.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    expected_at: {
      description: 'Date when the cardholder expected to receive the product.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_description: {
      description: 'Description of the merchandise or service that was purchased.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_type: {
      description: 'Whether the product was a merchandise or service.',
      enum: ['merchandise', 'service'],
      nullable: true,
      type: 'string',
    },
    return_status: {
      description: "Result of cardholder's attempt to return the product.",
      enum: ['merchant_rejected', 'successful'],
      nullable: true,
      type: 'string',
    },
    returned_at: {
      description: 'Date when the product was returned or attempted to be returned.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingDisputeCanceledEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_duplicate_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    card_statement: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Copy of the card statement showing that the product had already been paid for.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    cash_receipt: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Copy of the receipt showing that the product had been paid for in cash.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    check_image: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Image of the front and back of the check that was used to pay for the product.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    original_transaction: {
      description:
        'Transaction (e.g., ipi_...) that the disputed transaction is a duplicate of. Of the two or more transactions that are copies of each other, this is original undisputed one.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingDisputeDuplicateEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation', 'card_statement', 'cash_receipt', 'check_image'],
} as const;

export const issuing_dispute_evidenceSchema = {
  description: '',
  properties: {
    canceled: {
      $ref: '#/components/schemas/issuing_dispute_canceled_evidence',
    },
    duplicate: {
      $ref: '#/components/schemas/issuing_dispute_duplicate_evidence',
    },
    fraudulent: {
      $ref: '#/components/schemas/issuing_dispute_fraudulent_evidence',
    },
    merchandise_not_as_described: {
      $ref: '#/components/schemas/issuing_dispute_merchandise_not_as_described_evidence',
    },
    no_valid_authorization: {
      $ref: '#/components/schemas/issuing_dispute_no_valid_authorization_evidence',
    },
    not_received: {
      $ref: '#/components/schemas/issuing_dispute_not_received_evidence',
    },
    other: {
      $ref: '#/components/schemas/issuing_dispute_other_evidence',
    },
    reason: {
      description: 'The reason for filing the dispute. Its value will match the field containing the evidence.',
      enum: [
        'canceled',
        'duplicate',
        'fraudulent',
        'merchandise_not_as_described',
        'no_valid_authorization',
        'not_received',
        'other',
        'service_not_as_described',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    service_not_as_described: {
      $ref: '#/components/schemas/issuing_dispute_service_not_as_described_evidence',
    },
  },
  required: ['reason'],
  title: 'IssuingDisputeEvidence',
  type: 'object',
  'x-expandableFields': [
    'canceled',
    'duplicate',
    'fraudulent',
    'merchandise_not_as_described',
    'no_valid_authorization',
    'not_received',
    'other',
    'service_not_as_described',
  ],
} as const;

export const issuing_dispute_fraudulent_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingDisputeFraudulentEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_merchandise_not_as_described_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    received_at: {
      description: 'Date when the product was received.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    return_description: {
      description: "Description of the cardholder's attempt to return the product.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    return_status: {
      description: "Result of cardholder's attempt to return the product.",
      enum: ['merchant_rejected', 'successful'],
      nullable: true,
      type: 'string',
    },
    returned_at: {
      description: 'Date when the product was returned or attempted to be returned.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingDisputeMerchandiseNotAsDescribedEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_no_valid_authorization_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingDisputeNoValidAuthorizationEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_not_received_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    expected_at: {
      description: 'Date when the cardholder expected to receive the product.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_description: {
      description: 'Description of the merchandise or service that was purchased.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_type: {
      description: 'Whether the product was a merchandise or service.',
      enum: ['merchandise', 'service'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingDisputeNotReceivedEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_other_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_description: {
      description: 'Description of the merchandise or service that was purchased.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    product_type: {
      description: 'Whether the product was a merchandise or service.',
      enum: ['merchandise', 'service'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingDisputeOtherEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_service_not_as_described_evidenceSchema = {
  description: '',
  properties: {
    additional_documentation: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        '(ID of a [file upload](https://stripe.com/docs/guides/file-upload)) Additional documentation supporting the dispute.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    canceled_at: {
      description: 'Date when order was canceled.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    cancellation_reason: {
      description: 'Reason for canceling the order.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    explanation: {
      description: 'Explanation of why the cardholder is disputing this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    received_at: {
      description: 'Date when the product was received.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingDisputeServiceNotAsDescribedEvidence',
  type: 'object',
  'x-expandableFields': ['additional_documentation'],
} as const;

export const issuing_dispute_treasurySchema = {
  description: '',
  properties: {
    debit_reversal: {
      description:
        'The Treasury [DebitReversal](https://stripe.com/docs/api/treasury/debit_reversals) representing this Issuing dispute',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    received_debit: {
      description:
        'The Treasury [ReceivedDebit](https://stripe.com/docs/api/treasury/received_debits) that is being disputed.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['received_debit'],
  title: 'IssuingDisputeTreasury',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_network_token_addressSchema = {
  description: '',
  properties: {
    line1: {
      description: 'The street address of the cardholder tokenizing the card.',
      maxLength: 5000,
      type: 'string',
    },
    postal_code: {
      description: 'The postal code of the cardholder tokenizing the card.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['line1', 'postal_code'],
  title: 'IssuingNetworkTokenAddress',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_network_token_deviceSchema = {
  description: '',
  properties: {
    device_fingerprint: {
      description: 'An obfuscated ID derived from the device ID.',
      maxLength: 5000,
      type: 'string',
    },
    ip_address: {
      description: 'The IP address of the device at provisioning time.',
      maxLength: 5000,
      type: 'string',
    },
    location: {
      description:
        'The geographic latitude/longitude coordinates of the device at provisioning time. The format is [+-]decimal/[+-]decimal.',
      maxLength: 5000,
      type: 'string',
    },
    name: {
      description: 'The name of the device used for tokenization.',
      maxLength: 5000,
      type: 'string',
    },
    phone_number: {
      description: 'The phone number of the device used for tokenization.',
      maxLength: 5000,
      type: 'string',
    },
    type: {
      description: 'The type of device used for tokenization.',
      enum: ['other', 'phone', 'watch'],
      type: 'string',
    },
  },
  title: 'IssuingNetworkTokenDevice',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_network_token_mastercardSchema = {
  description: '',
  properties: {
    card_reference_id: {
      description: 'A unique reference ID from MasterCard to represent the card account number.',
      maxLength: 5000,
      type: 'string',
    },
    token_reference_id: {
      description: 'The network-unique identifier for the token.',
      maxLength: 5000,
      type: 'string',
    },
    token_requestor_id: {
      description: 'The ID of the entity requesting tokenization, specific to MasterCard.',
      maxLength: 5000,
      type: 'string',
    },
    token_requestor_name: {
      description:
        'The name of the entity requesting tokenization, if known. This is directly provided from MasterCard.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['token_reference_id', 'token_requestor_id'],
  title: 'IssuingNetworkTokenMastercard',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_network_token_network_dataSchema = {
  description: '',
  properties: {
    device: {
      $ref: '#/components/schemas/issuing_network_token_device',
    },
    mastercard: {
      $ref: '#/components/schemas/issuing_network_token_mastercard',
    },
    type: {
      description:
        'The network that the token is associated with. An additional hash is included with a name matching this value, containing tokenization data specific to the card network.',
      enum: ['mastercard', 'visa'],
      type: 'string',
    },
    visa: {
      $ref: '#/components/schemas/issuing_network_token_visa',
    },
    wallet_provider: {
      $ref: '#/components/schemas/issuing_network_token_wallet_provider',
    },
  },
  required: ['type'],
  title: 'IssuingNetworkTokenNetworkData',
  type: 'object',
  'x-expandableFields': ['device', 'mastercard', 'visa', 'wallet_provider'],
} as const;

export const issuing_network_token_visaSchema = {
  description: '',
  properties: {
    card_reference_id: {
      description: 'A unique reference ID from Visa to represent the card account number.',
      maxLength: 5000,
      type: 'string',
    },
    token_reference_id: {
      description: 'The network-unique identifier for the token.',
      maxLength: 5000,
      type: 'string',
    },
    token_requestor_id: {
      description: 'The ID of the entity requesting tokenization, specific to Visa.',
      maxLength: 5000,
      type: 'string',
    },
    token_risk_score: {
      description:
        'Degree of risk associated with the token between `01` and `99`, with higher number indicating higher risk. A `00` value indicates the token was not scored by Visa.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['card_reference_id', 'token_reference_id', 'token_requestor_id'],
  title: 'IssuingNetworkTokenVisa',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_network_token_wallet_providerSchema = {
  description: '',
  properties: {
    account_id: {
      description: 'The wallet provider-given account ID of the digital wallet the token belongs to.',
      maxLength: 5000,
      type: 'string',
    },
    account_trust_score: {
      description:
        'An evaluation on the trustworthiness of the wallet account between 1 and 5. A higher score indicates more trustworthy.',
      type: 'integer',
    },
    card_number_source: {
      description: 'The method used for tokenizing a card.',
      enum: ['app', 'manual', 'on_file', 'other'],
      type: 'string',
    },
    cardholder_address: {
      $ref: '#/components/schemas/issuing_network_token_address',
    },
    cardholder_name: {
      description: 'The name of the cardholder tokenizing the card.',
      maxLength: 5000,
      type: 'string',
    },
    device_trust_score: {
      description: 'An evaluation on the trustworthiness of the device. A higher score indicates more trustworthy.',
      type: 'integer',
    },
    hashed_account_email_address: {
      description: "The hashed email address of the cardholder's account with the wallet provider.",
      maxLength: 5000,
      type: 'string',
    },
    reason_codes: {
      description: 'The reasons for suggested tokenization given by the card network.',
      items: {
        enum: [
          'account_card_too_new',
          'account_recently_changed',
          'account_too_new',
          'account_too_new_since_launch',
          'additional_device',
          'data_expired',
          'defer_id_v_decision',
          'device_recently_lost',
          'good_activity_history',
          'has_suspended_tokens',
          'high_risk',
          'inactive_account',
          'long_account_tenure',
          'low_account_score',
          'low_device_score',
          'low_phone_number_score',
          'network_service_error',
          'outside_home_territory',
          'provisioning_cardholder_mismatch',
          'provisioning_device_and_cardholder_mismatch',
          'provisioning_device_mismatch',
          'same_device_no_prior_authentication',
          'same_device_successful_prior_authentication',
          'software_update',
          'suspicious_activity',
          'too_many_different_cardholders',
          'too_many_recent_attempts',
          'too_many_recent_tokens',
        ],
        type: 'string',
      },
      type: 'array',
    },
    suggested_decision: {
      description: 'The recommendation on responding to the tokenization request.',
      enum: ['approve', 'decline', 'require_auth'],
      type: 'string',
    },
    suggested_decision_version: {
      description: 'The version of the standard for mapping reason codes followed by the wallet provider.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'IssuingNetworkTokenWalletProvider',
  type: 'object',
  'x-expandableFields': ['cardholder_address'],
} as const;

export const issuing_personalization_design_carrier_textSchema = {
  description: '',
  properties: {
    footer_body: {
      description: 'The footer body text of the carrier letter.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    footer_title: {
      description: 'The footer title text of the carrier letter.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    header_body: {
      description: 'The header body text of the carrier letter.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    header_title: {
      description: 'The header title text of the carrier letter.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingPersonalizationDesignCarrierText',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_personalization_design_preferencesSchema = {
  description: '',
  properties: {
    is_default: {
      description:
        "Whether we use this personalization design to create cards when one isn't specified. A connected account uses the Connect platform's default design if no personalization design is set as the default design.",
      type: 'boolean',
    },
    is_platform_default: {
      description:
        'Whether this personalization design is used to create cards when one is not specified and a default for this connected account does not exist.',
      nullable: true,
      type: 'boolean',
    },
  },
  required: ['is_default'],
  title: 'IssuingPersonalizationDesignPreferences',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_personalization_design_rejection_reasonsSchema = {
  description: '',
  properties: {
    card_logo: {
      description: 'The reason(s) the card logo was rejected.',
      items: {
        enum: [
          'geographic_location',
          'inappropriate',
          'network_name',
          'non_binary_image',
          'non_fiat_currency',
          'other',
          'other_entity',
          'promotional_material',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    carrier_text: {
      description: 'The reason(s) the carrier text was rejected.',
      items: {
        enum: [
          'geographic_location',
          'inappropriate',
          'network_name',
          'non_fiat_currency',
          'other',
          'other_entity',
          'promotional_material',
        ],
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  title: 'IssuingPersonalizationDesignRejectionReasons',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_physical_bundle_featuresSchema = {
  description: '',
  properties: {
    card_logo: {
      description: 'The policy for how to use card logo images in a card design with this physical bundle.',
      enum: ['optional', 'required', 'unsupported'],
      type: 'string',
    },
    carrier_text: {
      description: 'The policy for how to use carrier letter text in a card design with this physical bundle.',
      enum: ['optional', 'required', 'unsupported'],
      type: 'string',
    },
    second_line: {
      description: 'The policy for how to use a second line on a card with this physical bundle.',
      enum: ['optional', 'required', 'unsupported'],
      type: 'string',
    },
  },
  required: ['card_logo', 'carrier_text', 'second_line'],
  title: 'IssuingPhysicalBundleFeatures',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_amount_detailsSchema = {
  description: '',
  properties: {
    atm_fee: {
      description: 'The fee charged by the ATM for the cash withdrawal.',
      nullable: true,
      type: 'integer',
    },
    cashback_amount: {
      description: 'The amount of cash requested by the cardholder.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingTransactionAmountDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_flight_dataSchema = {
  description: '',
  properties: {
    departure_at: {
      description: 'The time that the flight departed.',
      nullable: true,
      type: 'integer',
    },
    passenger_name: {
      description: 'The name of the passenger.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    refundable: {
      description: 'Whether the ticket is refundable.',
      nullable: true,
      type: 'boolean',
    },
    segments: {
      description: 'The legs of the trip.',
      items: {
        $ref: '#/components/schemas/issuing_transaction_flight_data_leg',
      },
      nullable: true,
      type: 'array',
    },
    travel_agency: {
      description: 'The travel agency that issued the ticket.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingTransactionFlightData',
  type: 'object',
  'x-expandableFields': ['segments'],
} as const;

export const issuing_transaction_flight_data_legSchema = {
  description: '',
  properties: {
    arrival_airport_code: {
      description: "The three-letter IATA airport code of the flight's destination.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    carrier: {
      description: 'The airline carrier code.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    departure_airport_code: {
      description: 'The three-letter IATA airport code that the flight departed from.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    flight_number: {
      description: 'The flight number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    service_class: {
      description: "The flight's service class.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    stopover_allowed: {
      description: 'Whether a stopover is allowed on this flight.',
      nullable: true,
      type: 'boolean',
    },
  },
  title: 'IssuingTransactionFlightDataLeg',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_fuel_dataSchema = {
  description: '',
  properties: {
    type: {
      description:
        'The type of fuel that was purchased. One of `diesel`, `unleaded_plus`, `unleaded_regular`, `unleaded_super`, or `other`.',
      maxLength: 5000,
      type: 'string',
    },
    unit: {
      description: 'The units for `volume_decimal`. One of `liter`, `us_gallon`, or `other`.',
      maxLength: 5000,
      type: 'string',
    },
    unit_cost_decimal: {
      description:
        'The cost in cents per each unit of fuel, represented as a decimal string with at most 12 decimal places.',
      format: 'decimal',
      type: 'string',
    },
    volume_decimal: {
      description:
        'The volume of the fuel that was pumped, represented as a decimal string with at most 12 decimal places.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
  },
  required: ['type', 'unit', 'unit_cost_decimal'],
  title: 'IssuingTransactionFuelData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_lodging_dataSchema = {
  description: '',
  properties: {
    check_in_at: {
      description: 'The time of checking into the lodging.',
      nullable: true,
      type: 'integer',
    },
    nights: {
      description: 'The number of nights stayed at the lodging.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingTransactionLodgingData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_network_dataSchema = {
  description: '',
  properties: {
    authorization_code: {
      description:
        'A code created by Stripe which is shared with the merchant to validate the authorization. This field will be populated if the authorization message was approved. The code typically starts with the letter "S", followed by a six-digit number. For example, "S498162". Please note that the code is not guaranteed to be unique across authorizations.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    processing_date: {
      description:
        'The date the transaction was processed by the card network. This can be different from the date the seller recorded the transaction depending on when the acquirer submits the transaction to the network.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_id: {
      description:
        'Unique identifier for the authorization assigned by the card network used to match subsequent messages, disputes, and transactions.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingTransactionNetworkData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_purchase_detailsSchema = {
  description: '',
  properties: {
    flight: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_flight_data',
        },
      ],
      description: 'Information about the flight that was purchased with this transaction.',
      nullable: true,
    },
    fuel: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_fuel_data',
        },
      ],
      description: 'Information about fuel that was purchased with this transaction.',
      nullable: true,
    },
    lodging: {
      anyOf: [
        {
          $ref: '#/components/schemas/issuing_transaction_lodging_data',
        },
      ],
      description: 'Information about lodging that was purchased with this transaction.',
      nullable: true,
    },
    receipt: {
      description: 'The line items in the purchase.',
      items: {
        $ref: '#/components/schemas/issuing_transaction_receipt_data',
      },
      nullable: true,
      type: 'array',
    },
    reference: {
      description: 'A merchant-specific order number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingTransactionPurchaseDetails',
  type: 'object',
  'x-expandableFields': ['flight', 'fuel', 'lodging', 'receipt'],
} as const;

export const issuing_transaction_receipt_dataSchema = {
  description: '',
  properties: {
    description: {
      description: 'The description of the item. The maximum length of this field is 26 characters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    quantity: {
      description: 'The quantity of the item.',
      nullable: true,
      type: 'number',
    },
    total: {
      description: 'The total for this line item in cents.',
      nullable: true,
      type: 'integer',
    },
    unit_cost: {
      description: 'The unit cost of the item in cents.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'IssuingTransactionReceiptData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const issuing_transaction_treasurySchema = {
  description: '',
  properties: {
    received_credit: {
      description:
        'The Treasury [ReceivedCredit](https://stripe.com/docs/api/treasury/received_credits) representing this Issuing transaction if it is a refund',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    received_debit: {
      description:
        'The Treasury [ReceivedDebit](https://stripe.com/docs/api/treasury/received_debits) representing this Issuing transaction if it is a capture',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'IssuingTransactionTreasury',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const itemSchema = {
  description: 'A line item.',
  properties: {
    amount_discount: {
      description: 'Total discount amount applied. If no discounts were applied, defaults to 0.',
      type: 'integer',
    },
    amount_subtotal: {
      description: 'Total before any discounts or taxes are applied.',
      type: 'integer',
    },
    amount_tax: {
      description: 'Total tax amount applied. If no tax was applied, defaults to 0.',
      type: 'integer',
    },
    amount_total: {
      description: 'Total after discounts and taxes.',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    description: {
      description:
        'An arbitrary string attached to the object. Often useful for displaying to users. Defaults to product name.',
      maxLength: 5000,
      type: 'string',
    },
    discounts: {
      description: 'The discounts applied to the line item.',
      items: {
        $ref: '#/components/schemas/line_items_discount_amount',
      },
      type: 'array',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['item'],
      type: 'string',
    },
    price: {
      anyOf: [
        {
          $ref: '#/components/schemas/price',
        },
      ],
      description: 'The price used to generate the line item.',
      nullable: true,
    },
    quantity: {
      description: 'The quantity of products being purchased.',
      nullable: true,
      type: 'integer',
    },
    taxes: {
      description: 'The taxes applied to the line item.',
      items: {
        $ref: '#/components/schemas/line_items_tax_amount',
      },
      type: 'array',
    },
  },
  required: [
    'amount_discount',
    'amount_subtotal',
    'amount_tax',
    'amount_total',
    'currency',
    'description',
    'id',
    'object',
  ],
  title: 'LineItem',
  type: 'object',
  'x-expandableFields': ['discounts', 'price', 'taxes'],
  'x-resourceId': 'item',
} as const;

export const legal_entity_companySchema = {
  description: '',
  properties: {
    address: {
      $ref: '#/components/schemas/address',
    },
    address_kana: {
      anyOf: [
        {
          $ref: '#/components/schemas/legal_entity_japan_address',
        },
      ],
      description: "The Kana variation of the company's primary address (Japan only).",
      nullable: true,
    },
    address_kanji: {
      anyOf: [
        {
          $ref: '#/components/schemas/legal_entity_japan_address',
        },
      ],
      description: "The Kanji variation of the company's primary address (Japan only).",
      nullable: true,
    },
    directors_provided: {
      description:
        "Whether the company's directors have been provided. This Boolean will be `true` if you've manually indicated that all directors are provided via [the `directors_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-directors_provided).",
      type: 'boolean',
    },
    executives_provided: {
      description:
        "Whether the company's executives have been provided. This Boolean will be `true` if you've manually indicated that all executives are provided via [the `executives_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-executives_provided), or if Stripe determined that sufficient executives were provided.",
      type: 'boolean',
    },
    export_license_id: {
      description: 'The export license ID number of the company, also referred as Import Export Code (India only).',
      maxLength: 5000,
      type: 'string',
    },
    export_purpose_code: {
      description: 'The purpose code to use for export transactions (India only).',
      maxLength: 5000,
      type: 'string',
    },
    name: {
      description: "The company's legal name.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name_kana: {
      description: "The Kana variation of the company's legal name (Japan only).",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name_kanji: {
      description: "The Kanji variation of the company's legal name (Japan only).",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    owners_provided: {
      description:
        "Whether the company's owners have been provided. This Boolean will be `true` if you've manually indicated that all owners are provided via [the `owners_provided` parameter](https://stripe.com/docs/api/accounts/update#update_account-company-owners_provided), or if Stripe determined that sufficient owners were provided. Stripe determines ownership requirements using both the number of owners provided and their total percent ownership (calculated by adding the `percent_ownership` of each owner together).",
      type: 'boolean',
    },
    ownership_declaration: {
      anyOf: [
        {
          $ref: '#/components/schemas/legal_entity_ubo_declaration',
        },
      ],
      description:
        'This hash is used to attest that the beneficial owner information provided to Stripe is both current and correct.',
      nullable: true,
    },
    phone: {
      description: "The company's phone number (used for verification).",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    structure: {
      description:
        'The category identifying the legal structure of the company or legal entity. See [Business structure](https://stripe.com/docs/connect/identity-verification#business-structure) for more details.',
      enum: [
        'free_zone_establishment',
        'free_zone_llc',
        'government_instrumentality',
        'governmental_unit',
        'incorporated_non_profit',
        'incorporated_partnership',
        'limited_liability_partnership',
        'llc',
        'multi_member_llc',
        'private_company',
        'private_corporation',
        'private_partnership',
        'public_company',
        'public_corporation',
        'public_partnership',
        'registered_charity',
        'single_member_llc',
        'sole_establishment',
        'sole_proprietorship',
        'tax_exempt_government_instrumentality',
        'unincorporated_association',
        'unincorporated_non_profit',
        'unincorporated_partnership',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    tax_id_provided: {
      description: "Whether the company's business ID number was provided.",
      type: 'boolean',
    },
    tax_id_registrar: {
      description: 'The jurisdiction in which the `tax_id` is registered (Germany-based companies only).',
      maxLength: 5000,
      type: 'string',
    },
    vat_id_provided: {
      description: "Whether the company's business VAT number was provided.",
      type: 'boolean',
    },
    verification: {
      anyOf: [
        {
          $ref: '#/components/schemas/legal_entity_company_verification',
        },
      ],
      description: 'Information on the verification state of the company.',
      nullable: true,
    },
  },
  title: 'LegalEntityCompany',
  type: 'object',
  'x-expandableFields': ['address', 'address_kana', 'address_kanji', 'ownership_declaration', 'verification'],
} as const;

export const legal_entity_company_verificationSchema = {
  description: '',
  properties: {
    document: {
      $ref: '#/components/schemas/legal_entity_company_verification_document',
    },
  },
  required: ['document'],
  title: 'LegalEntityCompanyVerification',
  type: 'object',
  'x-expandableFields': ['document'],
} as const;

export const legal_entity_company_verification_documentSchema = {
  description: '',
  properties: {
    back: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The back of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `additional_verification`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    details: {
      description: 'A user-displayable string describing the verification state of this document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    details_code: {
      description:
        'One of `document_corrupt`, `document_expired`, `document_failed_copy`, `document_failed_greyscale`, `document_failed_other`, `document_failed_test_mode`, `document_fraudulent`, `document_incomplete`, `document_invalid`, `document_manipulated`, `document_not_readable`, `document_not_uploaded`, `document_type_not_supported`, or `document_too_large`. A machine-readable code specifying the verification state for this document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    front: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The front of a document returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `additional_verification`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
  },
  title: 'LegalEntityCompanyVerificationDocument',
  type: 'object',
  'x-expandableFields': ['back', 'front'],
} as const;

export const legal_entity_dobSchema = {
  description: '',
  properties: {
    day: {
      description: 'The day of birth, between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'The month of birth, between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year of birth.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'LegalEntityDOB',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const legal_entity_japan_addressSchema = {
  description: '',
  properties: {
    city: {
      description: 'City/Ward.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    line1: {
      description: 'Block/Building number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    line2: {
      description: 'Building details.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    postal_code: {
      description: 'ZIP or postal code.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    state: {
      description: 'Prefecture.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    town: {
      description: 'Town/cho-me.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'LegalEntityJapanAddress',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const legal_entity_person_verificationSchema = {
  description: '',
  properties: {
    additional_document: {
      anyOf: [
        {
          $ref: '#/components/schemas/legal_entity_person_verification_document',
        },
      ],
      description:
        'A document showing address, either a passport, local ID card, or utility bill from a well-known utility company.',
      nullable: true,
    },
    details: {
      description:
        'A user-displayable string describing the verification state for the person. For example, this may say "Provided identity information could not be verified".',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    details_code: {
      description:
        'One of `document_address_mismatch`, `document_dob_mismatch`, `document_duplicate_type`, `document_id_number_mismatch`, `document_name_mismatch`, `document_nationality_mismatch`, `failed_keyed_identity`, or `failed_other`. A machine-readable code specifying the verification state for the person.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    document: {
      $ref: '#/components/schemas/legal_entity_person_verification_document',
    },
    status: {
      description:
        'The state of verification for the person. Possible values are `unverified`, `pending`, or `verified`.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['status'],
  title: 'LegalEntityPersonVerification',
  type: 'object',
  'x-expandableFields': ['additional_document', 'document'],
} as const;

export const legal_entity_person_verification_documentSchema = {
  description: '',
  properties: {
    back: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The back of an ID returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
    details: {
      description:
        'A user-displayable string describing the verification state of this document. For example, if a document is uploaded and the picture is too fuzzy, this may say "Identity document is too unclear to read".',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    details_code: {
      description:
        'One of `document_corrupt`, `document_country_not_supported`, `document_expired`, `document_failed_copy`, `document_failed_other`, `document_failed_test_mode`, `document_fraudulent`, `document_failed_greyscale`, `document_incomplete`, `document_invalid`, `document_manipulated`, `document_missing_back`, `document_missing_front`, `document_not_readable`, `document_not_uploaded`, `document_photo_mismatch`, `document_too_large`, or `document_type_not_supported`. A machine-readable code specifying the verification state for this document.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    front: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/file',
        },
      ],
      description:
        'The front of an ID returned by a [file upload](https://stripe.com/docs/api#create_file) with a `purpose` value of `identity_document`.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/file',
          },
        ],
      },
    },
  },
  title: 'LegalEntityPersonVerificationDocument',
  type: 'object',
  'x-expandableFields': ['back', 'front'],
} as const;

export const legal_entity_ubo_declarationSchema = {
  description: '',
  properties: {
    date: {
      description: 'The Unix timestamp marking when the beneficial owner attestation was made.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    ip: {
      description: 'The IP address from which the beneficial owner attestation was made.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description: 'The user-agent string from the browser where the beneficial owner attestation was made.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'LegalEntityUBODeclaration',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const line_itemSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount, in cents (or local equivalent).',
      type: 'integer',
    },
    amount_excluding_tax: {
      description:
        'The integer amount in cents (or local equivalent) representing the amount for this line item, excluding all tax and discounts.',
      nullable: true,
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    discount_amounts: {
      description: 'The amount of discount calculated per discount for this line item.',
      items: {
        $ref: '#/components/schemas/discounts_resource_discount_amount',
      },
      nullable: true,
      type: 'array',
    },
    discountable: {
      description: 'If true, discounts will apply to this line item. Always false for prorations.',
      type: 'boolean',
    },
    discounts: {
      description:
        'The discounts applied to the invoice line item. Line item discounts are applied before invoice discounts. Use `expand[]=discounts` to expand each discount.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/discount',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/discount',
            },
          ],
        },
      },
      type: 'array',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      description: 'The ID of the invoice that contains this line item.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_item: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoiceitem',
        },
      ],
      description:
        'The ID of the [invoice item](https://stripe.com/docs/api/invoiceitems) associated with this line item if any.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoiceitem',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Note that for line items with `type=subscription`, `metadata` reflects the current metadata from the subscription associated with the line item, unless the invoice line was directly updated with different metadata after creation.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['line_item'],
      type: 'string',
    },
    period: {
      $ref: '#/components/schemas/invoice_line_item_period',
    },
    price: {
      anyOf: [
        {
          $ref: '#/components/schemas/price',
        },
      ],
      description: 'The price of the line item.',
      nullable: true,
    },
    proration: {
      description: 'Whether this is a proration.',
      type: 'boolean',
    },
    proration_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoices_resource_line_items_proration_details',
        },
      ],
      description: 'Additional details for proration line items',
      nullable: true,
    },
    quantity: {
      description: 'The quantity of the subscription, if the line item is a subscription or a proration.',
      nullable: true,
      type: 'integer',
    },
    subscription: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/subscription',
        },
      ],
      description: 'The subscription that the invoice item pertains to, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/subscription',
          },
        ],
      },
    },
    subscription_item: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/subscription_item',
        },
      ],
      description:
        'The subscription item that generated this line item. Left empty if the line item is not an explicit result of a subscription.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/subscription_item',
          },
        ],
      },
    },
    tax_amounts: {
      description: 'The amount of tax calculated per tax rate for this line item',
      items: {
        $ref: '#/components/schemas/invoice_tax_amount',
      },
      type: 'array',
    },
    tax_rates: {
      description: 'The tax rates which apply to the line item.',
      items: {
        $ref: '#/components/schemas/tax_rate',
      },
      type: 'array',
    },
    type: {
      description:
        'A string identifying the type of the source of this line item, either an `invoiceitem` or a `subscription`.',
      enum: ['invoiceitem', 'subscription'],
      type: 'string',
    },
    unit_amount_excluding_tax: {
      description:
        'The amount in cents (or local equivalent) representing the unit amount for this line item, excluding all tax and discounts.',
      format: 'decimal',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'currency',
    'discountable',
    'discounts',
    'id',
    'livemode',
    'metadata',
    'object',
    'period',
    'proration',
    'type',
  ],
  title: 'InvoiceLineItem',
  type: 'object',
  'x-expandableFields': [
    'discount_amounts',
    'discounts',
    'invoice_item',
    'period',
    'price',
    'proration_details',
    'subscription',
    'subscription_item',
    'tax_amounts',
    'tax_rates',
  ],
  'x-resourceId': 'line_item',
} as const;

export const line_items_discount_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount discounted.',
      type: 'integer',
    },
    discount: {
      $ref: '#/components/schemas/discount',
    },
  },
  required: ['amount', 'discount'],
  title: 'LineItemsDiscountAmount',
  type: 'object',
  'x-expandableFields': ['discount'],
} as const;

export const line_items_tax_amountSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Amount of tax applied for this rate.',
      type: 'integer',
    },
    rate: {
      $ref: '#/components/schemas/tax_rate',
    },
    taxability_reason: {
      description:
        'The reasoning behind this tax, for example, if the product is tax exempt. The possible values for this field may be extended as new tax rules are supported.',
      enum: [
        'customer_exempt',
        'not_collecting',
        'not_subject_to_tax',
        'not_supported',
        'portion_product_exempt',
        'portion_reduced_rated',
        'portion_standard_rated',
        'product_exempt',
        'product_exempt_holiday',
        'proportionally_rated',
        'reduced_rated',
        'reverse_charge',
        'standard_rated',
        'taxable_basis_reduced',
        'zero_rated',
      ],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    taxable_amount: {
      description: 'The amount on which tax is calculated, in cents (or local equivalent).',
      nullable: true,
      type: 'integer',
    },
  },
  required: ['amount', 'rate'],
  title: 'LineItemsTaxAmount',
  type: 'object',
  'x-expandableFields': ['rate'],
} as const;

export const linked_account_options_us_bank_accountSchema = {
  description: '',
  properties: {
    permissions: {
      description: 'The list of permissions to request. The `payment_method` permission must be included.',
      items: {
        enum: ['balances', 'ownership', 'payment_method', 'transactions'],
        type: 'string',
      },
      type: 'array',
    },
    prefetch: {
      description: 'Data features requested to be retrieved upon account creation.',
      items: {
        enum: ['balances', 'ownership', 'transactions'],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
    return_url: {
      description:
        'For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'linked_account_options_us_bank_account',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const login_linkSchema = {
  description:
    "Login Links are single-use URLs for a connected account to access the Express Dashboard. The connected account's [account.controller.stripe_dashboard.type](/api/accounts/object#account_object-controller-stripe_dashboard-type) must be `express` to have access to the Express Dashboard.",
  properties: {
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['login_link'],
      type: 'string',
    },
    url: {
      description: 'The URL for the login link.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['created', 'object', 'url'],
  title: 'LoginLink',
  type: 'object',
  'x-expandableFields': [],
  'x-resourceId': 'login_link',
} as const;

export const mandateSchema = {
  description: 'A Mandate is a record of the permission that your customer gives you to debit their payment method.',
  properties: {
    customer_acceptance: {
      $ref: '#/components/schemas/customer_acceptance',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    multi_use: {
      $ref: '#/components/schemas/mandate_multi_use',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['mandate'],
      type: 'string',
    },
    on_behalf_of: {
      description: 'The account (if any) that the mandate is intended for.',
      maxLength: 5000,
      type: 'string',
    },
    payment_method: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description: 'ID of the payment method associated with this mandate.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    payment_method_details: {
      $ref: '#/components/schemas/mandate_payment_method_details',
    },
    single_use: {
      $ref: '#/components/schemas/mandate_single_use',
    },
    status: {
      description: 'The mandate status indicates whether or not you can use it to initiate a payment.',
      enum: ['active', 'inactive', 'pending'],
      type: 'string',
    },
    type: {
      description: 'The type of the mandate.',
      enum: ['multi_use', 'single_use'],
      type: 'string',
    },
  },
  required: [
    'customer_acceptance',
    'id',
    'livemode',
    'object',
    'payment_method',
    'payment_method_details',
    'status',
    'type',
  ],
  title: 'Mandate',
  type: 'object',
  'x-expandableFields': ['customer_acceptance', 'multi_use', 'payment_method', 'payment_method_details', 'single_use'],
  'x-resourceId': 'mandate',
} as const;

export const mandate_acss_debitSchema = {
  description: '',
  properties: {
    default_for: {
      description: 'List of Stripe products where this mandate can be selected automatically.',
      items: {
        enum: ['invoice', 'subscription'],
        type: 'string',
      },
      type: 'array',
    },
    interval_description: {
      description:
        "Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_schedule: {
      description: 'Payment schedule for the mandate.',
      enum: ['combined', 'interval', 'sporadic'],
      type: 'string',
    },
    transaction_type: {
      description: 'Transaction type of the mandate.',
      enum: ['business', 'personal'],
      type: 'string',
    },
  },
  required: ['payment_schedule', 'transaction_type'],
  title: 'mandate_acss_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_amazon_paySchema = {
  description: '',
  properties: {},
  title: 'mandate_amazon_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_au_becs_debitSchema = {
  description: '',
  properties: {
    url: {
      description:
        'The URL of the mandate. This URL generally contains sensitive information about the customer and should be shared with them exclusively.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['url'],
  title: 'mandate_au_becs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_bacs_debitSchema = {
  description: '',
  properties: {
    network_status: {
      description:
        'The status of the mandate on the Bacs network. Can be one of `pending`, `revoked`, `refused`, or `accepted`.',
      enum: ['accepted', 'pending', 'refused', 'revoked'],
      type: 'string',
    },
    reference: {
      description: 'The unique reference identifying the mandate on the Bacs network.',
      maxLength: 5000,
      type: 'string',
    },
    revocation_reason: {
      description: 'When the mandate is revoked on the Bacs network this field displays the reason for the revocation.',
      enum: [
        'account_closed',
        'bank_account_restricted',
        'bank_ownership_changed',
        'could_not_process',
        'debit_not_authorized',
      ],
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'The URL that will contain the mandate that the customer has signed.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['network_status', 'reference', 'url'],
  title: 'mandate_bacs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_cashappSchema = {
  description: '',
  properties: {},
  title: 'mandate_cashapp',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_linkSchema = {
  description: '',
  properties: {},
  title: 'mandate_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_multi_useSchema = {
  description: '',
  properties: {},
  title: 'mandate_multi_use',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_payment_method_detailsSchema = {
  description: '',
  properties: {
    acss_debit: {
      $ref: '#/components/schemas/mandate_acss_debit',
    },
    amazon_pay: {
      $ref: '#/components/schemas/mandate_amazon_pay',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/mandate_au_becs_debit',
    },
    bacs_debit: {
      $ref: '#/components/schemas/mandate_bacs_debit',
    },
    card: {
      $ref: '#/components/schemas/card_mandate_payment_method_details',
    },
    cashapp: {
      $ref: '#/components/schemas/mandate_cashapp',
    },
    link: {
      $ref: '#/components/schemas/mandate_link',
    },
    paypal: {
      $ref: '#/components/schemas/mandate_paypal',
    },
    revolut_pay: {
      $ref: '#/components/schemas/mandate_revolut_pay',
    },
    sepa_debit: {
      $ref: '#/components/schemas/mandate_sepa_debit',
    },
    type: {
      description:
        "This mandate corresponds with a specific payment method type. The `payment_method_details` includes an additional hash with the same name and contains mandate information that's specific to that payment method.",
      maxLength: 5000,
      type: 'string',
    },
    us_bank_account: {
      $ref: '#/components/schemas/mandate_us_bank_account',
    },
  },
  required: ['type'],
  title: 'mandate_payment_method_details',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'card',
    'cashapp',
    'link',
    'paypal',
    'revolut_pay',
    'sepa_debit',
    'us_bank_account',
  ],
} as const;

export const mandate_paypalSchema = {
  description: '',
  properties: {
    billing_agreement_id: {
      description:
        'The PayPal Billing Agreement ID (BAID). This is an ID generated by PayPal which represents the mandate between the merchant and the customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payer_id: {
      description: 'PayPal account PayerID. This identifier uniquely identifies the PayPal customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'mandate_paypal',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_revolut_paySchema = {
  description: '',
  properties: {},
  title: 'mandate_revolut_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_sepa_debitSchema = {
  description: '',
  properties: {
    reference: {
      description: 'The unique reference of the mandate.',
      maxLength: 5000,
      type: 'string',
    },
    url: {
      description:
        'The URL of the mandate. This URL generally contains sensitive information about the customer and should be shared with them exclusively.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['reference', 'url'],
  title: 'mandate_sepa_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_single_useSchema = {
  description: '',
  properties: {
    amount: {
      description: 'The amount of the payment on a single use mandate.',
      type: 'integer',
    },
    currency: {
      description: 'The currency of the payment on a single use mandate.',
      type: 'string',
    },
  },
  required: ['amount', 'currency'],
  title: 'mandate_single_use',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const mandate_us_bank_accountSchema = {
  description: '',
  properties: {
    collection_method: {
      description: 'Mandate collection method',
      enum: ['paper'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'mandate_us_bank_account',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const networksSchema = {
  description: '',
  properties: {
    available: {
      description: 'All available networks for the card.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    preferred: {
      description:
        'The preferred network for co-branded cards. Can be `cartes_bancaires`, `mastercard`, `visa` or `invalid_preference` if requested network is not valid for the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['available'],
  title: 'networks',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const notification_event_dataSchema = {
  description: '',
  properties: {
    object: {
      description:
        'Object containing the API resource relevant to the event. For example, an `invoice.created` event will have a full [invoice object](https://stripe.com/docs/api#invoice_object) as the value of the object key.',
      type: 'object',
    },
    previous_attributes: {
      description:
        'Object containing the names of the updated attributes and their values prior to the event (only included in events of type `*.updated`). If an array attribute has any updated elements, this object contains the entire array. In Stripe API versions 2017-04-06 or earlier, an updated array attribute in this object includes only the updated array elements.',
      type: 'object',
    },
  },
  required: ['object'],
  title: 'NotificationEventData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const notification_event_requestSchema = {
  description: '',
  properties: {
    id: {
      description:
        "ID of the API request that caused the event. If null, the event was automatic (e.g., Stripe's automatic subscription handling). Request logs are available in the [dashboard](https://dashboard.stripe.com/logs), but currently not in the API.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    idempotency_key: {
      description:
        'The idempotency key transmitted during the request, if any. *Note: This property is populated only for events on or after May 23, 2017*.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'NotificationEventRequest',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const offline_acceptanceSchema = {
  description: '',
  properties: {},
  title: 'offline_acceptance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const online_acceptanceSchema = {
  description: '',
  properties: {
    ip_address: {
      description: 'The customer accepts the mandate from this IP address.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    user_agent: {
      description: 'The customer accepts the mandate using the user agent of the browser.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'online_acceptance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const outbound_payments_payment_method_detailsSchema = {
  description: '',
  properties: {
    billing_details: {
      $ref: '#/components/schemas/treasury_shared_resource_billing_details',
    },
    financial_account: {
      $ref: '#/components/schemas/outbound_payments_payment_method_details_financial_account',
    },
    type: {
      description: 'The type of the payment method used in the OutboundPayment.',
      enum: ['financial_account', 'us_bank_account'],
      type: 'string',
    },
    us_bank_account: {
      $ref: '#/components/schemas/outbound_payments_payment_method_details_us_bank_account',
    },
  },
  required: ['billing_details', 'type'],
  title: 'OutboundPaymentsPaymentMethodDetails',
  type: 'object',
  'x-expandableFields': ['billing_details', 'financial_account', 'us_bank_account'],
} as const;

export const outbound_payments_payment_method_details_financial_accountSchema = {
  description: '',
  properties: {
    id: {
      description: 'Token of the FinancialAccount.',
      maxLength: 5000,
      type: 'string',
    },
    network: {
      description: 'The rails used to send funds.',
      enum: ['stripe'],
      type: 'string',
    },
  },
  required: ['id', 'network'],
  title: 'outbound_payments_payment_method_details_financial_account',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const outbound_payments_payment_method_details_us_bank_accountSchema = {
  description: '',
  properties: {
    account_holder_type: {
      description: 'Account holder type: individual or company.',
      enum: ['company', 'individual'],
      nullable: true,
      type: 'string',
    },
    account_type: {
      description: 'Account type: checkings or savings. Defaults to checking if omitted.',
      enum: ['checking', 'savings'],
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'ID of the mandate used to make this payment.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    network: {
      description:
        'The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.',
      enum: ['ach', 'us_domestic_wire'],
      type: 'string',
    },
    routing_number: {
      description: 'Routing number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['network'],
  title: 'outbound_payments_payment_method_details_us_bank_account',
  type: 'object',
  'x-expandableFields': ['mandate'],
} as const;

export const outbound_transfers_payment_method_detailsSchema = {
  description: '',
  properties: {
    billing_details: {
      $ref: '#/components/schemas/treasury_shared_resource_billing_details',
    },
    type: {
      description: 'The type of the payment method used in the OutboundTransfer.',
      enum: ['us_bank_account'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    us_bank_account: {
      $ref: '#/components/schemas/outbound_transfers_payment_method_details_us_bank_account',
    },
  },
  required: ['billing_details', 'type'],
  title: 'OutboundTransfersPaymentMethodDetails',
  type: 'object',
  'x-expandableFields': ['billing_details', 'us_bank_account'],
} as const;

export const outbound_transfers_payment_method_details_us_bank_accountSchema = {
  description: '',
  properties: {
    account_holder_type: {
      description: 'Account holder type: individual or company.',
      enum: ['company', 'individual'],
      nullable: true,
      type: 'string',
    },
    account_type: {
      description: 'Account type: checkings or savings. Defaults to checking if omitted.',
      enum: ['checking', 'savings'],
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'ID of the mandate used to make this payment.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    network: {
      description:
        'The network rails used. See the [docs](https://stripe.com/docs/treasury/money-movement/timelines) to learn more about money movement timelines for each network type.',
      enum: ['ach', 'us_domestic_wire'],
      type: 'string',
    },
    routing_number: {
      description: 'Routing number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['network'],
  title: 'outbound_transfers_payment_method_details_us_bank_account',
  type: 'object',
  'x-expandableFields': ['mandate'],
} as const;

export const package_dimensionsSchema = {
  description: '',
  properties: {
    height: {
      description: 'Height, in inches.',
      type: 'number',
    },
    length: {
      description: 'Length, in inches.',
      type: 'number',
    },
    weight: {
      description: 'Weight, in ounces.',
      type: 'number',
    },
    width: {
      description: 'Width, in inches.',
      type: 'number',
    },
  },
  required: ['height', 'length', 'weight', 'width'],
  title: 'PackageDimensions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_amount_detailsSchema = {
  description: '',
  properties: {
    tip: {
      $ref: '#/components/schemas/payment_flows_amount_details_resource_tip',
    },
  },
  title: 'PaymentFlowsAmountDetails',
  type: 'object',
  'x-expandableFields': ['tip'],
} as const;

export const payment_flows_amount_details_resource_tipSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Portion of the amount that corresponds to a tip.',
      type: 'integer',
    },
  },
  title: 'PaymentFlowsAmountDetailsResourceTip',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_automatic_payment_methods_payment_intentSchema = {
  description: '',
  properties: {
    allow_redirects: {
      description: `Controls whether this PaymentIntent will accept redirect-based payment methods.

Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a \`return_url\` to redirect customers back to your site after they authenticate or complete the payment.`,
      enum: ['always', 'never'],
      type: 'string',
    },
    enabled: {
      description: 'Automatically calculates compatible payment methods',
      type: 'boolean',
    },
  },
  required: ['enabled'],
  title: 'PaymentFlowsAutomaticPaymentMethodsPaymentIntent',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_automatic_payment_methods_setup_intentSchema = {
  description: '',
  properties: {
    allow_redirects: {
      description: `Controls whether this SetupIntent will accept redirect-based payment methods.

Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/setup_intents/confirm) this SetupIntent, you may be required to provide a \`return_url\` to redirect customers back to your site after they authenticate or complete the setup.`,
      enum: ['always', 'never'],
      type: 'string',
    },
    enabled: {
      description: 'Automatically calculates compatible payment methods',
      nullable: true,
      type: 'boolean',
    },
  },
  title: 'PaymentFlowsAutomaticPaymentMethodsSetupIntent',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_installment_optionsSchema = {
  description: '',
  properties: {
    enabled: {
      type: 'boolean',
    },
    plan: {
      $ref: '#/components/schemas/payment_method_details_card_installments_plan',
    },
  },
  required: ['enabled'],
  title: 'PaymentFlowsInstallmentOptions',
  type: 'object',
  'x-expandableFields': ['plan'],
} as const;

export const payment_flows_private_payment_methods_alipaySchema = {
  description: '',
  properties: {},
  title: 'PaymentFlowsPrivatePaymentMethodsAlipay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_private_payment_methods_alipay_detailsSchema = {
  description: '',
  properties: {
    buyer_id: {
      description:
        'Uniquely identifies this particular Alipay account. You can use this attribute to check whether two Alipay accounts are the same.',
      maxLength: 5000,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular Alipay account. You can use this attribute to check whether two Alipay accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_id: {
      description: 'Transaction ID of this particular Alipay transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentFlowsPrivatePaymentMethodsAlipayDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_extended_authorization_extended_authorizationSchema =
  {
    description: '',
    properties: {
      status: {
        description: 'Indicates whether or not the capture window is extended beyond the standard authorization.',
        enum: ['disabled', 'enabled'],
        type: 'string',
      },
    },
    required: ['status'],
    title:
      'PaymentFlowsPrivatePaymentMethodsCardDetailsAPIResourceEnterpriseFeaturesExtendedAuthorizationExtendedAuthorization',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_incremental_authorization_incremental_authorizationSchema =
  {
    description: '',
    properties: {
      status: {
        description: 'Indicates whether or not the incremental authorization feature is supported.',
        enum: ['available', 'unavailable'],
        type: 'string',
      },
    },
    required: ['status'],
    title:
      'PaymentFlowsPrivatePaymentMethodsCardDetailsAPIResourceEnterpriseFeaturesIncrementalAuthorizationIncrementalAuthorization',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_overcapture_overcaptureSchema =
  {
    description: '',
    properties: {
      maximum_amount_capturable: {
        description: 'The maximum amount that can be captured.',
        type: 'integer',
      },
      status: {
        description: 'Indicates whether or not the authorized amount can be over-captured.',
        enum: ['available', 'unavailable'],
        type: 'string',
      },
    },
    required: ['maximum_amount_capturable', 'status'],
    title: 'PaymentFlowsPrivatePaymentMethodsCardDetailsAPIResourceEnterpriseFeaturesOvercaptureOvercapture',
    type: 'object',
    'x-expandableFields': [],
  } as const;

export const payment_flows_private_payment_methods_card_details_api_resource_multicaptureSchema = {
  description: '',
  properties: {
    status: {
      description: 'Indicates whether or not multiple captures are supported.',
      enum: ['available', 'unavailable'],
      type: 'string',
    },
  },
  required: ['status'],
  title: 'PaymentFlowsPrivatePaymentMethodsCardDetailsAPIResourceMulticapture',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_flows_private_payment_methods_klarna_dobSchema = {
  description: '',
  properties: {
    day: {
      description: 'The day of birth, between 1 and 31.',
      nullable: true,
      type: 'integer',
    },
    month: {
      description: 'The month of birth, between 1 and 12.',
      nullable: true,
      type: 'integer',
    },
    year: {
      description: 'The four-digit year of birth.',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'PaymentFlowsPrivatePaymentMethodsKlarnaDOB',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intentSchema = {
  description: `A PaymentIntent guides you through the process of collecting a payment from your customer.
We recommend that you create exactly one PaymentIntent for each order or
customer session in your system. You can reference the PaymentIntent later to
see the history of payment attempts for a particular session.

A PaymentIntent transitions through
[multiple statuses](https://stripe.com/docs/payments/intents#intent-statuses)
throughout its lifetime as it interfaces with Stripe.js to perform
authentication flows and ultimately creates at most one successful charge.

Related guide: [Payment Intents API](https://stripe.com/docs/payments/payment-intents)`,
  properties: {
    amount: {
      description:
        'Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).',
      type: 'integer',
    },
    amount_capturable: {
      description: 'Amount that can be captured from this PaymentIntent.',
      type: 'integer',
    },
    amount_details: {
      $ref: '#/components/schemas/payment_flows_amount_details',
    },
    amount_received: {
      description: 'Amount that this PaymentIntent collects.',
      type: 'integer',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
      ],
      description: 'ID of the Connect application that created the PaymentIntent.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
        ],
      },
    },
    application_fee_amount: {
      description:
        "The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).",
      nullable: true,
      type: 'integer',
    },
    automatic_payment_methods: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_flows_automatic_payment_methods_payment_intent',
        },
      ],
      description:
        'Settings to configure compatible payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods)',
      nullable: true,
    },
    canceled_at: {
      description:
        'Populated when `status` is `canceled`, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    cancellation_reason: {
      description:
        'Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).',
      enum: [
        'abandoned',
        'automatic',
        'duplicate',
        'failed_invoice',
        'fraudulent',
        'requested_by_customer',
        'void_invoice',
      ],
      nullable: true,
      type: 'string',
    },
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['automatic', 'automatic_async', 'manual'],
      type: 'string',
    },
    client_secret: {
      description: `The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key. 

The client secret can be used to complete a payment from your frontend. It should not be stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.

Refer to our docs to [accept a payment](https://stripe.com/docs/payments/accept-a-payment?ui=elements) and learn about how \`client_secret\` should be handled.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    confirmation_method: {
      description:
        'Describes whether we can confirm this PaymentIntent automatically, or if it requires customer action to confirm the payment.',
      enum: ['automatic', 'manual'],
      type: 'string',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
        {
          $ref: '#/components/schemas/deleted_customer',
        },
      ],
      description: `ID of the Customer this PaymentIntent belongs to, if one exists.

Payment methods attached to other Customers cannot be used with this PaymentIntent.

If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.`,
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
          {
            $ref: '#/components/schemas/deleted_customer',
          },
        ],
      },
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    invoice: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/invoice',
        },
      ],
      description: 'ID of the invoice that created this PaymentIntent, if it exists.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/invoice',
          },
        ],
      },
    },
    last_payment_error: {
      anyOf: [
        {
          $ref: '#/components/schemas/api_errors',
        },
      ],
      description:
        'The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason.',
      nullable: true,
    },
    latest_charge: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/charge',
        },
      ],
      description: 'The latest charge created by this PaymentIntent.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/charge',
          },
        ],
      },
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Learn more about [storing information in metadata](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).',
      type: 'object',
    },
    next_action: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_next_action',
        },
      ],
      description:
        'If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.',
      nullable: true,
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['payment_intent'],
      type: 'string',
    },
    on_behalf_of: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The account (if any) for which the funds of the PaymentIntent are intended. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    payment_method: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description: 'ID of the payment method used in this PaymentIntent.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    payment_method_configuration_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_config_biz_payment_method_configuration_details',
        },
      ],
      description: 'Information about the payment method configuration used for this PaymentIntent.',
      nullable: true,
    },
    payment_method_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options',
        },
      ],
      description: 'Payment-method-specific configuration for this PaymentIntent.',
      nullable: true,
    },
    payment_method_types: {
      description: 'The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    processing: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_processing',
        },
      ],
      description: 'If present, this property tells you about the processing state of the payment.',
      nullable: true,
    },
    receipt_email: {
      description:
        'Email address that the receipt for the resulting payment will be sent to. If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    review: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/review',
        },
      ],
      description: 'ID of the review associated with this PaymentIntent, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/review',
          },
        ],
      },
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['off_session', 'on_session'],
      nullable: true,
      type: 'string',
    },
    shipping: {
      anyOf: [
        {
          $ref: '#/components/schemas/shipping',
        },
      ],
      description: 'Shipping information for this PaymentIntent.',
      nullable: true,
    },
    statement_descriptor: {
      description:
        "For card charges, use [statement_descriptor_suffix](https://stripe.com/docs/payments/account/statement-descriptors#dynamic). Otherwise, you can use this value as the complete description of a charge on your customers' statements. It must contain at least one letter and be 1–22 characters long.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_suffix: {
      description:
        'Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    status: {
      description:
        'Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).',
      enum: [
        'canceled',
        'processing',
        'requires_action',
        'requires_capture',
        'requires_confirmation',
        'requires_payment_method',
        'succeeded',
      ],
      type: 'string',
    },
    transfer_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/transfer_data',
        },
      ],
      description:
        'The data that automatically creates a Transfer after the payment finalizes. Learn more about the [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).',
      nullable: true,
    },
    transfer_group: {
      description:
        'A string that identifies the resulting payment as part of a group. Learn more about the [use case for connected accounts](https://stripe.com/docs/connect/separate-charges-and-transfers).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'amount',
    'capture_method',
    'confirmation_method',
    'created',
    'currency',
    'id',
    'livemode',
    'object',
    'payment_method_types',
    'status',
  ],
  title: 'PaymentIntent',
  type: 'object',
  'x-expandableFields': [
    'amount_details',
    'application',
    'automatic_payment_methods',
    'customer',
    'invoice',
    'last_payment_error',
    'latest_charge',
    'next_action',
    'on_behalf_of',
    'payment_method',
    'payment_method_configuration_details',
    'payment_method_options',
    'processing',
    'review',
    'shipping',
    'transfer_data',
  ],
  'x-resourceId': 'payment_intent',
} as const;

export const payment_intent_card_processingSchema = {
  description: '',
  properties: {
    customer_notification: {
      $ref: '#/components/schemas/payment_intent_processing_customer_notification',
    },
  },
  title: 'PaymentIntentCardProcessing',
  type: 'object',
  'x-expandableFields': ['customer_notification'],
} as const;

export const payment_intent_next_actionSchema = {
  description: '',
  properties: {
    alipay_handle_redirect: {
      $ref: '#/components/schemas/payment_intent_next_action_alipay_handle_redirect',
    },
    boleto_display_details: {
      $ref: '#/components/schemas/payment_intent_next_action_boleto',
    },
    card_await_notification: {
      $ref: '#/components/schemas/payment_intent_next_action_card_await_notification',
    },
    cashapp_handle_redirect_or_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_cashapp_handle_redirect_or_display_qr_code',
    },
    display_bank_transfer_instructions: {
      $ref: '#/components/schemas/payment_intent_next_action_display_bank_transfer_instructions',
    },
    konbini_display_details: {
      $ref: '#/components/schemas/payment_intent_next_action_konbini',
    },
    multibanco_display_details: {
      $ref: '#/components/schemas/payment_intent_next_action_display_multibanco_details',
    },
    oxxo_display_details: {
      $ref: '#/components/schemas/payment_intent_next_action_display_oxxo_details',
    },
    paynow_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_paynow_display_qr_code',
    },
    pix_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_pix_display_qr_code',
    },
    promptpay_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_promptpay_display_qr_code',
    },
    redirect_to_url: {
      $ref: '#/components/schemas/payment_intent_next_action_redirect_to_url',
    },
    swish_handle_redirect_or_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_swish_handle_redirect_or_display_qr_code',
    },
    type: {
      description:
        'Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.',
      maxLength: 5000,
      type: 'string',
    },
    use_stripe_sdk: {
      description:
        'When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.',
      type: 'object',
    },
    verify_with_microdeposits: {
      $ref: '#/components/schemas/payment_intent_next_action_verify_with_microdeposits',
    },
    wechat_pay_display_qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_wechat_pay_display_qr_code',
    },
    wechat_pay_redirect_to_android_app: {
      $ref: '#/components/schemas/payment_intent_next_action_wechat_pay_redirect_to_android_app',
    },
    wechat_pay_redirect_to_ios_app: {
      $ref: '#/components/schemas/payment_intent_next_action_wechat_pay_redirect_to_ios_app',
    },
  },
  required: ['type'],
  title: 'PaymentIntentNextAction',
  type: 'object',
  'x-expandableFields': [
    'alipay_handle_redirect',
    'boleto_display_details',
    'card_await_notification',
    'cashapp_handle_redirect_or_display_qr_code',
    'display_bank_transfer_instructions',
    'konbini_display_details',
    'multibanco_display_details',
    'oxxo_display_details',
    'paynow_display_qr_code',
    'pix_display_qr_code',
    'promptpay_display_qr_code',
    'redirect_to_url',
    'swish_handle_redirect_or_display_qr_code',
    'verify_with_microdeposits',
    'wechat_pay_display_qr_code',
    'wechat_pay_redirect_to_android_app',
    'wechat_pay_redirect_to_ios_app',
  ],
} as const;

export const payment_intent_next_action_alipay_handle_redirectSchema = {
  description: '',
  properties: {
    native_data: {
      description:
        'The native data to be used with Alipay SDK you must redirect your customer to in order to authenticate the payment in an Android App.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    native_url: {
      description:
        'The native URL you must redirect your customer to in order to authenticate the payment in an iOS App.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    return_url: {
      description:
        'If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'The URL you must redirect your customer to in order to authenticate the payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentIntentNextActionAlipayHandleRedirect',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_boletoSchema = {
  description: '',
  properties: {
    expires_at: {
      description: 'The timestamp after which the boleto expires.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    hosted_voucher_url: {
      description: 'The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    number: {
      description: 'The boleto number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    pdf: {
      description: 'The URL to the downloadable boleto voucher PDF.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_intent_next_action_boleto',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_card_await_notificationSchema = {
  description: '',
  properties: {
    charge_attempt_at: {
      description:
        'The time that payment will be attempted. If customer approval is required, they need to provide approval before this time.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    customer_approval_required: {
      description:
        'For payments greater than INR 15000, the customer must provide explicit approval of the payment with their bank. For payments of lower amount, no customer action is required.',
      nullable: true,
      type: 'boolean',
    },
  },
  title: 'PaymentIntentNextActionCardAwaitNotification',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_cashapp_handle_redirect_or_display_qr_codeSchema = {
  description: '',
  properties: {
    hosted_instructions_url: {
      description:
        'The URL to the hosted Cash App Pay instructions page, which allows customers to view the QR code, and supports QR code refreshing on expiration.',
      maxLength: 5000,
      type: 'string',
    },
    mobile_auth_url: {
      description: 'The url for mobile redirect based auth',
      maxLength: 5000,
      type: 'string',
    },
    qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_cashapp_qr_code',
    },
  },
  required: ['hosted_instructions_url', 'mobile_auth_url', 'qr_code'],
  title: 'PaymentIntentNextActionCashappHandleRedirectOrDisplayQrCode',
  type: 'object',
  'x-expandableFields': ['qr_code'],
} as const;

export const payment_intent_next_action_cashapp_qr_codeSchema = {
  description: '',
  properties: {
    expires_at: {
      description: 'The date (unix timestamp) when the QR code expires.',
      format: 'unix-time',
      type: 'integer',
    },
    image_url_png: {
      description: 'The image_url_png string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The image_url_svg string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['expires_at', 'image_url_png', 'image_url_svg'],
  title: 'PaymentIntentNextActionCashappQRCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_display_bank_transfer_instructionsSchema = {
  description: '',
  properties: {
    amount_remaining: {
      description: 'The remaining amount that needs to be transferred to complete the payment.',
      nullable: true,
      type: 'integer',
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      nullable: true,
      type: 'string',
    },
    financial_addresses: {
      description: 'A list of financial addresses that can be used to fund the customer balance',
      items: {
        $ref: '#/components/schemas/funding_instructions_bank_transfer_financial_address',
      },
      type: 'array',
    },
    hosted_instructions_url: {
      description: 'A link to a hosted page that guides your customer through completing the transfer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reference: {
      description:
        'A string identifying this payment. Instruct your customer to include this code in the reference or memo field of their bank transfer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description: 'Type of bank transfer',
      enum: ['eu_bank_transfer', 'gb_bank_transfer', 'jp_bank_transfer', 'mx_bank_transfer', 'us_bank_transfer'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  required: ['type'],
  title: 'PaymentIntentNextActionDisplayBankTransferInstructions',
  type: 'object',
  'x-expandableFields': ['financial_addresses'],
} as const;

export const payment_intent_next_action_display_multibanco_detailsSchema = {
  description: '',
  properties: {
    entity: {
      description: 'Entity number associated with this Multibanco payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    expires_at: {
      description: 'The timestamp at which the Multibanco voucher expires.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    hosted_voucher_url: {
      description:
        'The URL for the hosted Multibanco voucher page, which allows customers to view a Multibanco voucher.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reference: {
      description: 'Reference number associated with this Multibanco payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentIntentNextActionDisplayMultibancoDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_display_oxxo_detailsSchema = {
  description: '',
  properties: {
    expires_after: {
      description: 'The timestamp after which the OXXO voucher expires.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    hosted_voucher_url: {
      description:
        'The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO voucher.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    number: {
      description: 'OXXO reference number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentIntentNextActionDisplayOxxoDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_konbiniSchema = {
  description: '',
  properties: {
    expires_at: {
      description: 'The timestamp at which the pending Konbini payment expires.',
      format: 'unix-time',
      type: 'integer',
    },
    hosted_voucher_url: {
      description:
        'The URL for the Konbini payment instructions page, which allows customers to view and print a Konbini voucher.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    stores: {
      $ref: '#/components/schemas/payment_intent_next_action_konbini_stores',
    },
  },
  required: ['expires_at', 'stores'],
  title: 'payment_intent_next_action_konbini',
  type: 'object',
  'x-expandableFields': ['stores'],
} as const;

export const payment_intent_next_action_konbini_familymartSchema = {
  description: '',
  properties: {
    confirmation_number: {
      description: 'The confirmation number.',
      maxLength: 5000,
      type: 'string',
    },
    payment_code: {
      description: 'The payment code.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['payment_code'],
  title: 'payment_intent_next_action_konbini_familymart',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_konbini_lawsonSchema = {
  description: '',
  properties: {
    confirmation_number: {
      description: 'The confirmation number.',
      maxLength: 5000,
      type: 'string',
    },
    payment_code: {
      description: 'The payment code.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['payment_code'],
  title: 'payment_intent_next_action_konbini_lawson',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_konbini_ministopSchema = {
  description: '',
  properties: {
    confirmation_number: {
      description: 'The confirmation number.',
      maxLength: 5000,
      type: 'string',
    },
    payment_code: {
      description: 'The payment code.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['payment_code'],
  title: 'payment_intent_next_action_konbini_ministop',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_konbini_seicomartSchema = {
  description: '',
  properties: {
    confirmation_number: {
      description: 'The confirmation number.',
      maxLength: 5000,
      type: 'string',
    },
    payment_code: {
      description: 'The payment code.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['payment_code'],
  title: 'payment_intent_next_action_konbini_seicomart',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_konbini_storesSchema = {
  description: '',
  properties: {
    familymart: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_next_action_konbini_familymart',
        },
      ],
      description: 'FamilyMart instruction details.',
      nullable: true,
    },
    lawson: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_next_action_konbini_lawson',
        },
      ],
      description: 'Lawson instruction details.',
      nullable: true,
    },
    ministop: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_next_action_konbini_ministop',
        },
      ],
      description: 'Ministop instruction details.',
      nullable: true,
    },
    seicomart: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_next_action_konbini_seicomart',
        },
      ],
      description: 'Seicomart instruction details.',
      nullable: true,
    },
  },
  title: 'payment_intent_next_action_konbini_stores',
  type: 'object',
  'x-expandableFields': ['familymart', 'lawson', 'ministop', 'seicomart'],
} as const;

export const payment_intent_next_action_paynow_display_qr_codeSchema = {
  description: '',
  properties: {
    data: {
      description: 'The raw data string used to generate QR code, it should be used together with QR code library.',
      maxLength: 5000,
      type: 'string',
    },
    hosted_instructions_url: {
      description: 'The URL to the hosted PayNow instructions page, which allows customers to view the PayNow QR code.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    image_url_png: {
      description: 'The image_url_png string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The image_url_svg string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['data', 'image_url_png', 'image_url_svg'],
  title: 'PaymentIntentNextActionPaynowDisplayQrCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_pix_display_qr_codeSchema = {
  description: '',
  properties: {
    data: {
      description: 'The raw data string used to generate QR code, it should be used together with QR code library.',
      maxLength: 5000,
      type: 'string',
    },
    expires_at: {
      description: 'The date (unix timestamp) when the PIX expires.',
      type: 'integer',
    },
    hosted_instructions_url: {
      description: 'The URL to the hosted pix instructions page, which allows customers to view the pix QR code.',
      maxLength: 5000,
      type: 'string',
    },
    image_url_png: {
      description: 'The image_url_png string used to render png QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The image_url_svg string used to render svg QR code',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'PaymentIntentNextActionPixDisplayQrCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_promptpay_display_qr_codeSchema = {
  description: '',
  properties: {
    data: {
      description: 'The raw data string used to generate QR code, it should be used together with QR code library.',
      maxLength: 5000,
      type: 'string',
    },
    hosted_instructions_url: {
      description:
        'The URL to the hosted PromptPay instructions page, which allows customers to view the PromptPay QR code.',
      maxLength: 5000,
      type: 'string',
    },
    image_url_png: {
      description: 'The PNG path used to render the QR code, can be used as the source in an HTML img tag',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The SVG path used to render the QR code, can be used as the source in an HTML img tag',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['data', 'hosted_instructions_url', 'image_url_png', 'image_url_svg'],
  title: 'PaymentIntentNextActionPromptpayDisplayQrCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_redirect_to_urlSchema = {
  description: '',
  properties: {
    return_url: {
      description:
        'If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'The URL you must redirect your customer to in order to authenticate the payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentIntentNextActionRedirectToUrl',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_swish_handle_redirect_or_display_qr_codeSchema = {
  description: '',
  properties: {
    hosted_instructions_url: {
      description: 'The URL to the hosted Swish instructions page, which allows customers to view the QR code.',
      maxLength: 5000,
      type: 'string',
    },
    qr_code: {
      $ref: '#/components/schemas/payment_intent_next_action_swish_qr_code',
    },
  },
  required: ['hosted_instructions_url', 'qr_code'],
  title: 'PaymentIntentNextActionSwishHandleRedirectOrDisplayQrCode',
  type: 'object',
  'x-expandableFields': ['qr_code'],
} as const;

export const payment_intent_next_action_swish_qr_codeSchema = {
  description: '',
  properties: {
    data: {
      description: 'The raw data string used to generate QR code, it should be used together with QR code library.',
      maxLength: 5000,
      type: 'string',
    },
    image_url_png: {
      description: 'The image_url_png string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The image_url_svg string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['data', 'image_url_png', 'image_url_svg'],
  title: 'PaymentIntentNextActionSwishQRCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_verify_with_microdepositsSchema = {
  description: '',
  properties: {
    arrival_date: {
      description: 'The timestamp when the microdeposits are expected to land.',
      format: 'unix-time',
      type: 'integer',
    },
    hosted_verification_url: {
      description: 'The URL for the hosted verification page, which allows customers to verify their bank account.',
      maxLength: 5000,
      type: 'string',
    },
    microdeposit_type: {
      description:
        'The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.',
      enum: ['amounts', 'descriptor_code'],
      nullable: true,
      type: 'string',
    },
  },
  required: ['arrival_date', 'hosted_verification_url'],
  title: 'PaymentIntentNextActionVerifyWithMicrodeposits',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_wechat_pay_display_qr_codeSchema = {
  description: '',
  properties: {
    data: {
      description: 'The data being used to generate QR code',
      maxLength: 5000,
      type: 'string',
    },
    hosted_instructions_url: {
      description:
        'The URL to the hosted WeChat Pay instructions page, which allows customers to view the WeChat Pay QR code.',
      maxLength: 5000,
      type: 'string',
    },
    image_data_url: {
      description: 'The base64 image data for a pre-generated QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_png: {
      description: 'The image_url_png string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
    image_url_svg: {
      description: 'The image_url_svg string used to render QR code',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['data', 'hosted_instructions_url', 'image_data_url', 'image_url_png', 'image_url_svg'],
  title: 'PaymentIntentNextActionWechatPayDisplayQrCode',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_wechat_pay_redirect_to_android_appSchema = {
  description: '',
  properties: {
    app_id: {
      description: 'app_id is the APP ID registered on WeChat open platform',
      maxLength: 5000,
      type: 'string',
    },
    nonce_str: {
      description: 'nonce_str is a random string',
      maxLength: 5000,
      type: 'string',
    },
    package: {
      description: 'package is static value',
      maxLength: 5000,
      type: 'string',
    },
    partner_id: {
      description: 'an unique merchant ID assigned by WeChat Pay',
      maxLength: 5000,
      type: 'string',
    },
    prepay_id: {
      description: 'an unique trading ID assigned by WeChat Pay',
      maxLength: 5000,
      type: 'string',
    },
    sign: {
      description: 'A signature',
      maxLength: 5000,
      type: 'string',
    },
    timestamp: {
      description: 'Specifies the current time in epoch format',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['app_id', 'nonce_str', 'package', 'partner_id', 'prepay_id', 'sign', 'timestamp'],
  title: 'PaymentIntentNextActionWechatPayRedirectToAndroidApp',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_next_action_wechat_pay_redirect_to_ios_appSchema = {
  description: '',
  properties: {
    native_url: {
      description: 'An universal link that redirect to WeChat Pay app',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['native_url'],
  title: 'PaymentIntentNextActionWechatPayRedirectToIOSApp',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_optionsSchema = {
  description: '',
  properties: {
    acss_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_acss_debit',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    affirm: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_affirm',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    afterpay_clearpay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_afterpay_clearpay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    alipay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_alipay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    amazon_pay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_amazon_pay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    au_becs_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_au_becs_debit',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    bacs_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_bacs_debit',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    bancontact: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_bancontact',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    blik: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_blik',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    boleto: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_boleto',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    card: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_card',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    card_present: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_card_present',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    cashapp: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_cashapp',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    customer_balance: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_customer_balance',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    eps: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_eps',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    fpx: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_fpx',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    giropay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_giropay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    grabpay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_grabpay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    ideal: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_ideal',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    interac_present: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_interac_present',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    klarna: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_klarna',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    konbini: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_konbini',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    link: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_link',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    mobilepay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_mobilepay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    multibanco: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_multibanco',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    oxxo: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_oxxo',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    p24: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_p24',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    paynow: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_paynow',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    paypal: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_paypal',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    pix: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_pix',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    promptpay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_promptpay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    revolut_pay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_revolut_pay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    sepa_debit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_sepa_debit',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    sofort: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_sofort',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    swish: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_swish',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    twint: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_twint',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    us_bank_account: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_intent_payment_method_options_us_bank_account',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    wechat_pay: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_wechat_pay',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
    zip: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_zip',
        },
        {
          $ref: '#/components/schemas/payment_intent_type_specific_payment_method_options_client',
        },
      ],
    },
  },
  title: 'PaymentIntentPaymentMethodOptions',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'blik',
    'boleto',
    'card',
    'card_present',
    'cashapp',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'grabpay',
    'ideal',
    'interac_present',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'pix',
    'promptpay',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'swish',
    'twint',
    'us_bank_account',
    'wechat_pay',
    'zip',
  ],
} as const;

export const payment_intent_payment_method_options_acss_debitSchema = {
  description: '',
  properties: {
    mandate_options: {
      $ref: '#/components/schemas/payment_intent_payment_method_options_mandate_options_acss_debit',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'payment_intent_payment_method_options_acss_debit',
  type: 'object',
  'x-expandableFields': ['mandate_options'],
} as const;

export const payment_intent_payment_method_options_au_becs_debitSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_au_becs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_blikSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'payment_intent_payment_method_options_blik',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_cardSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    installments: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_card_installments',
        },
      ],
      description: `Installment details for this payment (Mexico only).

For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).`,
      nullable: true,
    },
    mandate_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_options_card_mandate_options',
        },
      ],
      description: 'Configuration options for setting up an eMandate for cards issued in India.',
      nullable: true,
    },
    network: {
      description:
        'Selected network to process this payment intent on. Depends on the available networks of the card attached to the payment intent. Can be only set confirm-time.',
      enum: [
        'amex',
        'cartes_bancaires',
        'diners',
        'discover',
        'eftpos_au',
        'interac',
        'jcb',
        'mastercard',
        'unionpay',
        'unknown',
        'visa',
      ],
      nullable: true,
      type: 'string',
    },
    request_extended_authorization: {
      description:
        'Request ability to [capture beyond the standard authorization validity window](https://stripe.com/docs/payments/extended-authorization) for this PaymentIntent.',
      enum: ['if_available', 'never'],
      type: 'string',
    },
    request_incremental_authorization: {
      description:
        'Request ability to [increment the authorization](https://stripe.com/docs/payments/incremental-authorization) for this PaymentIntent.',
      enum: ['if_available', 'never'],
      type: 'string',
    },
    request_multicapture: {
      description:
        'Request ability to make [multiple captures](https://stripe.com/docs/payments/multicapture) for this PaymentIntent.',
      enum: ['if_available', 'never'],
      type: 'string',
    },
    request_overcapture: {
      description:
        'Request ability to [overcapture](https://stripe.com/docs/payments/overcapture) for this PaymentIntent.',
      enum: ['if_available', 'never'],
      type: 'string',
    },
    request_three_d_secure: {
      description:
        'We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. If not provided, this value defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure/authentication-flow#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.',
      enum: ['any', 'automatic', 'challenge'],
      nullable: true,
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    require_cvc_recollection: {
      description:
        'When enabled, using a card that is attached to a customer will require the CVC to be provided again (i.e. using the cvc_token parameter).',
      type: 'boolean',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    statement_descriptor_suffix_kana: {
      description:
        'Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.',
      maxLength: 5000,
      type: 'string',
    },
    statement_descriptor_suffix_kanji: {
      description:
        'Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_card',
  type: 'object',
  'x-expandableFields': ['installments', 'mandate_options'],
} as const;

export const payment_intent_payment_method_options_epsSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_eps',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_linkSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_mandate_options_acss_debitSchema = {
  description: '',
  properties: {
    custom_mandate_url: {
      description: 'A URL for custom mandate text',
      maxLength: 5000,
      type: 'string',
    },
    interval_description: {
      description:
        "Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_schedule: {
      description: 'Payment schedule for the mandate.',
      enum: ['combined', 'interval', 'sporadic'],
      nullable: true,
      type: 'string',
    },
    transaction_type: {
      description: 'Transaction type of the mandate.',
      enum: ['business', 'personal'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_mandate_options_acss_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_mandate_options_sepa_debitSchema = {
  description: '',
  properties: {},
  title: 'payment_intent_payment_method_options_mandate_options_sepa_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_mobilepaySchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_mobilepay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_sepa_debitSchema = {
  description: '',
  properties: {
    mandate_options: {
      $ref: '#/components/schemas/payment_intent_payment_method_options_mandate_options_sepa_debit',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_sepa_debit',
  type: 'object',
  'x-expandableFields': ['mandate_options'],
} as const;

export const payment_intent_payment_method_options_swishSchema = {
  description: '',
  properties: {
    reference: {
      description: 'The order ID displayed in the Swish app after the payment is authorized.',
      maxLength: 35,
      nullable: true,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'payment_intent_payment_method_options_swish',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_payment_method_options_us_bank_accountSchema = {
  description: '',
  properties: {
    financial_connections: {
      $ref: '#/components/schemas/linked_account_options_us_bank_account',
    },
    mandate_options: {
      $ref: '#/components/schemas/payment_method_options_us_bank_account_mandate_options',
    },
    preferred_settlement_speed: {
      description: 'Preferred transaction settlement speed',
      enum: ['fastest', 'standard'],
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'payment_intent_payment_method_options_us_bank_account',
  type: 'object',
  'x-expandableFields': ['financial_connections', 'mandate_options'],
} as const;

export const payment_intent_processingSchema = {
  description: '',
  properties: {
    card: {
      $ref: '#/components/schemas/payment_intent_card_processing',
    },
    type: {
      description: 'Type of the payment method for which payment is in `processing` state, one of `card`.',
      enum: ['card'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'PaymentIntentProcessing',
  type: 'object',
  'x-expandableFields': ['card'],
} as const;

export const payment_intent_processing_customer_notificationSchema = {
  description: '',
  properties: {
    approval_requested: {
      description:
        'Whether customer approval has been requested for this payment. For payments greater than INR 15000 or mandate amount, the customer must provide explicit approval of the payment with their bank.',
      nullable: true,
      type: 'boolean',
    },
    completes_at: {
      description: 'If customer approval is required, they need to provide approval before this time.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'PaymentIntentProcessingCustomerNotification',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_intent_type_specific_payment_method_options_clientSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual', 'manual_preferred'],
      type: 'string',
    },
    installments: {
      $ref: '#/components/schemas/payment_flows_installment_options',
    },
    require_cvc_recollection: {
      description:
        'When enabled, using a card that is attached to a customer will require the CVC to be provided again (i.e. using the cvc_token parameter).',
      type: 'boolean',
    },
    routing: {
      $ref: '#/components/schemas/payment_method_options_card_present_routing',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
    verification_method: {
      description: 'Bank account verification method.',
      enum: ['automatic', 'instant', 'microdeposits'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'PaymentIntentTypeSpecificPaymentMethodOptionsClient',
  type: 'object',
  'x-expandableFields': ['installments', 'routing'],
} as const;

export const payment_linkSchema = {
  description: `A payment link is a shareable URL that will take your customers to a hosted payment page. A payment link can be shared and used multiple times.

When a customer opens a payment link it will open a new [checkout session](https://stripe.com/docs/api/checkout/sessions) to render the payment page. You can use [checkout session events](https://stripe.com/docs/api/events/types#event_types-checkout.session.completed) to track payments through payment links.

Related guide: [Payment Links API](https://stripe.com/docs/payment-links)`,
  properties: {
    active: {
      description:
        "Whether the payment link's `url` is active. If `false`, customers visiting the URL will be shown a page saying that the link has been deactivated.",
      type: 'boolean',
    },
    after_completion: {
      $ref: '#/components/schemas/payment_links_resource_after_completion',
    },
    allow_promotion_codes: {
      description: 'Whether user redeemable promotion codes are enabled.',
      type: 'boolean',
    },
    application: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/application',
        },
        {
          $ref: '#/components/schemas/deleted_application',
        },
      ],
      description: 'The ID of the Connect application that created the Payment Link.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/application',
          },
          {
            $ref: '#/components/schemas/deleted_application',
          },
        ],
      },
    },
    application_fee_amount: {
      description:
        "The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account.",
      nullable: true,
      type: 'integer',
    },
    application_fee_percent: {
      description:
        "This represents the percentage of the subscription invoice total that will be transferred to the application owner's Stripe account.",
      nullable: true,
      type: 'number',
    },
    automatic_tax: {
      $ref: '#/components/schemas/payment_links_resource_automatic_tax',
    },
    billing_address_collection: {
      description: "Configuration for collecting the customer's billing address. Defaults to `auto`.",
      enum: ['auto', 'required'],
      type: 'string',
    },
    consent_collection: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_consent_collection',
        },
      ],
      description: 'When set, provides configuration to gather active consent from customers.',
      nullable: true,
    },
    currency: {
      description:
        'Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).',
      type: 'string',
    },
    custom_fields: {
      description:
        'Collect additional information from your customer using custom fields. Up to 3 fields are supported.',
      items: {
        $ref: '#/components/schemas/payment_links_resource_custom_fields',
      },
      type: 'array',
    },
    custom_text: {
      $ref: '#/components/schemas/payment_links_resource_custom_text',
    },
    customer_creation: {
      description: 'Configuration for Customer creation during checkout.',
      enum: ['always', 'if_required'],
      type: 'string',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    inactive_message: {
      description: 'The custom message to be displayed to a customer when a payment link is no longer active.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_creation: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_invoice_creation',
        },
      ],
      description: 'Configuration for creating invoice for payment mode payment links.',
      nullable: true,
    },
    line_items: {
      description: 'The line items representing what is being sold.',
      properties: {
        data: {
          description: 'Details about each object.',
          items: {
            $ref: '#/components/schemas/item',
          },
          type: 'array',
        },
        has_more: {
          description: 'True if this list has another page of items after this one that can be fetched.',
          type: 'boolean',
        },
        object: {
          description:
            "String representing the object's type. Objects of the same type share the same value. Always has the value `list`.",
          enum: ['list'],
          type: 'string',
        },
        url: {
          description: 'The URL where this list can be accessed.',
          maxLength: 5000,
          type: 'string',
        },
      },
      required: ['data', 'has_more', 'object', 'url'],
      title: 'PaymentLinksResourceListLineItems',
      type: 'object',
      'x-expandableFields': ['data'],
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      type: 'object',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['payment_link'],
      type: 'string',
    },
    on_behalf_of: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description:
        'The account on behalf of which to charge. See the [Connect documentation](https://support.stripe.com/questions/sending-invoices-on-behalf-of-connected-accounts) for details.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
    payment_intent_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_payment_intent_data',
        },
      ],
      description: 'Indicates the parameters to be passed to PaymentIntent creation during checkout.',
      nullable: true,
    },
    payment_method_collection: {
      description: 'Configuration for collecting a payment method during checkout. Defaults to `always`.',
      enum: ['always', 'if_required'],
      type: 'string',
    },
    payment_method_types: {
      description:
        "The list of payment method types that customers can use. When `null`, Stripe will dynamically show relevant payment methods you've enabled in your [payment method settings](https://dashboard.stripe.com/settings/payment_methods).",
      items: {
        enum: [
          'affirm',
          'afterpay_clearpay',
          'alipay',
          'au_becs_debit',
          'bacs_debit',
          'bancontact',
          'blik',
          'boleto',
          'card',
          'cashapp',
          'eps',
          'fpx',
          'giropay',
          'grabpay',
          'ideal',
          'klarna',
          'konbini',
          'link',
          'oxxo',
          'p24',
          'paynow',
          'paypal',
          'pix',
          'promptpay',
          'sepa_debit',
          'sofort',
          'swish',
          'us_bank_account',
          'wechat_pay',
        ],
        type: 'string',
        'x-stripeBypassValidation': true,
      },
      nullable: true,
      type: 'array',
    },
    phone_number_collection: {
      $ref: '#/components/schemas/payment_links_resource_phone_number_collection',
    },
    restrictions: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_restrictions',
        },
      ],
      description: 'Settings that restrict the usage of a payment link.',
      nullable: true,
    },
    shipping_address_collection: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_shipping_address_collection',
        },
      ],
      description: "Configuration for collecting the customer's shipping address.",
      nullable: true,
    },
    shipping_options: {
      description: 'The shipping rate options applied to the session.',
      items: {
        $ref: '#/components/schemas/payment_links_resource_shipping_option',
      },
      type: 'array',
    },
    submit_type: {
      description:
        'Indicates the type of transaction being performed which customizes relevant text on the page, such as the submit button.',
      enum: ['auto', 'book', 'donate', 'pay'],
      type: 'string',
    },
    subscription_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_subscription_data',
        },
      ],
      description:
        'When creating a subscription, the specified configuration data will be used. There must be at least one line item with a recurring price to use `subscription_data`.',
      nullable: true,
    },
    tax_id_collection: {
      $ref: '#/components/schemas/payment_links_resource_tax_id_collection',
    },
    transfer_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_transfer_data',
        },
      ],
      description:
        'The account (if any) the payments will be attributed to for tax reporting, and where funds from each payment will be transferred to.',
      nullable: true,
    },
    url: {
      description: 'The public URL that can be shared with customers.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: [
    'active',
    'after_completion',
    'allow_promotion_codes',
    'automatic_tax',
    'billing_address_collection',
    'currency',
    'custom_fields',
    'custom_text',
    'customer_creation',
    'id',
    'livemode',
    'metadata',
    'object',
    'payment_method_collection',
    'phone_number_collection',
    'shipping_options',
    'submit_type',
    'tax_id_collection',
    'url',
  ],
  title: 'PaymentLink',
  type: 'object',
  'x-expandableFields': [
    'after_completion',
    'application',
    'automatic_tax',
    'consent_collection',
    'custom_fields',
    'custom_text',
    'invoice_creation',
    'line_items',
    'on_behalf_of',
    'payment_intent_data',
    'phone_number_collection',
    'restrictions',
    'shipping_address_collection',
    'shipping_options',
    'subscription_data',
    'tax_id_collection',
    'transfer_data',
  ],
  'x-resourceId': 'payment_link',
} as const;

export const payment_links_resource_after_completionSchema = {
  description: '',
  properties: {
    hosted_confirmation: {
      $ref: '#/components/schemas/payment_links_resource_completion_behavior_confirmation_page',
    },
    redirect: {
      $ref: '#/components/schemas/payment_links_resource_completion_behavior_redirect',
    },
    type: {
      description: 'The specified behavior after the purchase is complete.',
      enum: ['hosted_confirmation', 'redirect'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'PaymentLinksResourceAfterCompletion',
  type: 'object',
  'x-expandableFields': ['hosted_confirmation', 'redirect'],
} as const;

export const payment_links_resource_automatic_taxSchema = {
  description: '',
  properties: {
    enabled: {
      description: "If `true`, tax will be calculated automatically using the customer's location.",
      type: 'boolean',
    },
    liability: {
      anyOf: [
        {
          $ref: '#/components/schemas/connect_account_reference',
        },
      ],
      description:
        "The account that's liable for tax. If set, the business address and tax registrations required to perform the tax calculation are loaded from this account. The tax transaction is returned in the report of the connected account.",
      nullable: true,
    },
  },
  required: ['enabled'],
  title: 'PaymentLinksResourceAutomaticTax',
  type: 'object',
  'x-expandableFields': ['liability'],
} as const;

export const payment_links_resource_completed_sessionsSchema = {
  description: '',
  properties: {
    count: {
      description:
        'The current number of checkout sessions that have been completed on the payment link which count towards the `completed_sessions` restriction to be met.',
      type: 'integer',
    },
    limit: {
      description:
        'The maximum number of checkout sessions that can be completed for the `completed_sessions` restriction to be met.',
      type: 'integer',
    },
  },
  required: ['count', 'limit'],
  title: 'PaymentLinksResourceCompletedSessions',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_completion_behavior_confirmation_pageSchema = {
  description: '',
  properties: {
    custom_message: {
      description: 'The custom message that is displayed to the customer after the purchase is complete.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentLinksResourceCompletionBehaviorConfirmationPage',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_completion_behavior_redirectSchema = {
  description: '',
  properties: {
    url: {
      description: 'The URL the customer will be redirected to after the purchase is complete.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['url'],
  title: 'PaymentLinksResourceCompletionBehaviorRedirect',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_consent_collectionSchema = {
  description: '',
  properties: {
    payment_method_reuse_agreement: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_payment_method_reuse_agreement',
        },
      ],
      description: 'Settings related to the payment method reuse text shown in the Checkout UI.',
      nullable: true,
    },
    promotions: {
      description: 'If set to `auto`, enables the collection of customer consent for promotional communications.',
      enum: ['auto', 'none'],
      nullable: true,
      type: 'string',
    },
    terms_of_service: {
      description:
        "If set to `required`, it requires cutomers to accept the terms of service before being able to pay. If set to `none`, customers won't be shown a checkbox to accept the terms of service.",
      enum: ['none', 'required'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'PaymentLinksResourceConsentCollection',
  type: 'object',
  'x-expandableFields': ['payment_method_reuse_agreement'],
} as const;

export const payment_links_resource_custom_fieldsSchema = {
  description: '',
  properties: {
    dropdown: {
      $ref: '#/components/schemas/payment_links_resource_custom_fields_dropdown',
    },
    key: {
      description:
        'String of your choice that your integration can use to reconcile this field. Must be unique to this field, alphanumeric, and up to 200 characters.',
      maxLength: 5000,
      type: 'string',
    },
    label: {
      $ref: '#/components/schemas/payment_links_resource_custom_fields_label',
    },
    numeric: {
      $ref: '#/components/schemas/payment_links_resource_custom_fields_numeric',
    },
    optional: {
      description:
        'Whether the customer is required to complete the field before completing the Checkout Session. Defaults to `false`.',
      type: 'boolean',
    },
    text: {
      $ref: '#/components/schemas/payment_links_resource_custom_fields_text',
    },
    type: {
      description: 'The type of the field.',
      enum: ['dropdown', 'numeric', 'text'],
      type: 'string',
    },
  },
  required: ['key', 'label', 'optional', 'type'],
  title: 'PaymentLinksResourceCustomFields',
  type: 'object',
  'x-expandableFields': ['dropdown', 'label', 'numeric', 'text'],
} as const;

export const payment_links_resource_custom_fields_dropdownSchema = {
  description: '',
  properties: {
    options: {
      description: 'The options available for the customer to select. Up to 200 options allowed.',
      items: {
        $ref: '#/components/schemas/payment_links_resource_custom_fields_dropdown_option',
      },
      type: 'array',
    },
  },
  required: ['options'],
  title: 'PaymentLinksResourceCustomFieldsDropdown',
  type: 'object',
  'x-expandableFields': ['options'],
} as const;

export const payment_links_resource_custom_fields_dropdown_optionSchema = {
  description: '',
  properties: {
    label: {
      description: 'The label for the option, displayed to the customer. Up to 100 characters.',
      maxLength: 5000,
      type: 'string',
    },
    value: {
      description:
        'The value for this option, not displayed to the customer, used by your integration to reconcile the option selected by the customer. Must be unique to this option, alphanumeric, and up to 100 characters.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['label', 'value'],
  title: 'PaymentLinksResourceCustomFieldsDropdownOption',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_custom_fields_labelSchema = {
  description: '',
  properties: {
    custom: {
      description: 'Custom text for the label, displayed to the customer. Up to 50 characters.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    type: {
      description: 'The type of the label.',
      enum: ['custom'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'PaymentLinksResourceCustomFieldsLabel',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_custom_fields_numericSchema = {
  description: '',
  properties: {
    maximum_length: {
      description: "The maximum character length constraint for the customer's input.",
      nullable: true,
      type: 'integer',
    },
    minimum_length: {
      description: "The minimum character length requirement for the customer's input.",
      nullable: true,
      type: 'integer',
    },
  },
  title: 'PaymentLinksResourceCustomFieldsNumeric',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_custom_fields_textSchema = {
  description: '',
  properties: {
    maximum_length: {
      description: "The maximum character length constraint for the customer's input.",
      nullable: true,
      type: 'integer',
    },
    minimum_length: {
      description: "The minimum character length requirement for the customer's input.",
      nullable: true,
      type: 'integer',
    },
  },
  title: 'PaymentLinksResourceCustomFieldsText',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_custom_textSchema = {
  description: '',
  properties: {
    after_submit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_custom_text_position',
        },
      ],
      description: 'Custom text that should be displayed after the payment confirmation button.',
      nullable: true,
    },
    shipping_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_custom_text_position',
        },
      ],
      description: 'Custom text that should be displayed alongside shipping address collection.',
      nullable: true,
    },
    submit: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_custom_text_position',
        },
      ],
      description: 'Custom text that should be displayed alongside the payment confirmation button.',
      nullable: true,
    },
    terms_of_service_acceptance: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_custom_text_position',
        },
      ],
      description: 'Custom text that should be displayed in place of the default terms of service agreement text.',
      nullable: true,
    },
  },
  title: 'PaymentLinksResourceCustomText',
  type: 'object',
  'x-expandableFields': ['after_submit', 'shipping_address', 'submit', 'terms_of_service_acceptance'],
} as const;

export const payment_links_resource_custom_text_positionSchema = {
  description: '',
  properties: {
    message: {
      description: 'Text may be up to 1200 characters in length.',
      maxLength: 500,
      type: 'string',
    },
  },
  required: ['message'],
  title: 'PaymentLinksResourceCustomTextPosition',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_invoice_creationSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Enable creating an invoice on successful payment.',
      type: 'boolean',
    },
    invoice_data: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_links_resource_invoice_settings',
        },
      ],
      description: 'Configuration for the invoice. Default invoice values will be used if unspecified.',
      nullable: true,
    },
  },
  required: ['enabled'],
  title: 'PaymentLinksResourceInvoiceCreation',
  type: 'object',
  'x-expandableFields': ['invoice_data'],
} as const;

export const payment_links_resource_invoice_settingsSchema = {
  description: '',
  properties: {
    account_tax_ids: {
      description: 'The account tax IDs associated with the invoice.',
      items: {
        anyOf: [
          {
            maxLength: 5000,
            type: 'string',
          },
          {
            $ref: '#/components/schemas/tax_id',
          },
          {
            $ref: '#/components/schemas/deleted_tax_id',
          },
        ],
        'x-expansionResources': {
          oneOf: [
            {
              $ref: '#/components/schemas/tax_id',
            },
            {
              $ref: '#/components/schemas/deleted_tax_id',
            },
          ],
        },
      },
      nullable: true,
      type: 'array',
    },
    custom_fields: {
      description: 'A list of up to 4 custom fields to be displayed on the invoice.',
      items: {
        $ref: '#/components/schemas/invoice_setting_custom_field',
      },
      nullable: true,
      type: 'array',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    footer: {
      description: 'Footer to be displayed on the invoice.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    issuer: {
      anyOf: [
        {
          $ref: '#/components/schemas/connect_account_reference',
        },
      ],
      description:
        'The connected account that issues the invoice. The invoice is presented with the branding and support information of the specified account.',
      nullable: true,
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    rendering_options: {
      anyOf: [
        {
          $ref: '#/components/schemas/invoice_setting_rendering_options',
        },
      ],
      description: 'Options for invoice PDF rendering.',
      nullable: true,
    },
  },
  title: 'PaymentLinksResourceInvoiceSettings',
  type: 'object',
  'x-expandableFields': ['account_tax_ids', 'custom_fields', 'issuer', 'rendering_options'],
} as const;

export const payment_links_resource_payment_intent_dataSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Indicates when the funds will be captured from the customer's account.",
      enum: ['automatic', 'automatic_async', 'manual'],
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'An arbitrary string attached to the object. Often useful for displaying to users.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that will set metadata on [Payment Intents](https://stripe.com/docs/api/payment_intents) generated from this payment link.',
      type: 'object',
    },
    setup_future_usage: {
      description:
        'Indicates that you intend to make future payments with the payment method collected during checkout.',
      enum: ['off_session', 'on_session'],
      nullable: true,
      type: 'string',
    },
    statement_descriptor: {
      description:
        "Extra information about the payment. This will appear on your customer's statement when this payment succeeds in creating a charge.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    statement_descriptor_suffix: {
      description:
        "Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transfer_group: {
      description:
        'A string that identifies the resulting payment as part of a group. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/connect/separate-charges-and-transfers) for details.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['metadata'],
  title: 'PaymentLinksResourcePaymentIntentData',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_payment_method_reuse_agreementSchema = {
  description: '',
  properties: {
    position: {
      description: `Determines the position and visibility of the payment method reuse agreement in the UI. When set to \`auto\`, Stripe's defaults will be used.

When set to \`hidden\`, the payment method reuse agreement text will always be hidden in the UI.`,
      enum: ['auto', 'hidden'],
      type: 'string',
    },
  },
  required: ['position'],
  title: 'PaymentLinksResourcePaymentMethodReuseAgreement',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_phone_number_collectionSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'If `true`, a phone number will be collected during checkout.',
      type: 'boolean',
    },
  },
  required: ['enabled'],
  title: 'PaymentLinksResourcePhoneNumberCollection',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_restrictionsSchema = {
  description: '',
  properties: {
    completed_sessions: {
      $ref: '#/components/schemas/payment_links_resource_completed_sessions',
    },
  },
  required: ['completed_sessions'],
  title: 'PaymentLinksResourceRestrictions',
  type: 'object',
  'x-expandableFields': ['completed_sessions'],
} as const;

export const payment_links_resource_shipping_address_collectionSchema = {
  description: '',
  properties: {
    allowed_countries: {
      description:
        'An array of two-letter ISO country codes representing which countries Checkout should provide as options for shipping locations. Unsupported country codes: `AS, CX, CC, CU, HM, IR, KP, MH, FM, NF, MP, PW, SD, SY, UM, VI`.',
      items: {
        enum: [
          'AC',
          'AD',
          'AE',
          'AF',
          'AG',
          'AI',
          'AL',
          'AM',
          'AO',
          'AQ',
          'AR',
          'AT',
          'AU',
          'AW',
          'AX',
          'AZ',
          'BA',
          'BB',
          'BD',
          'BE',
          'BF',
          'BG',
          'BH',
          'BI',
          'BJ',
          'BL',
          'BM',
          'BN',
          'BO',
          'BQ',
          'BR',
          'BS',
          'BT',
          'BV',
          'BW',
          'BY',
          'BZ',
          'CA',
          'CD',
          'CF',
          'CG',
          'CH',
          'CI',
          'CK',
          'CL',
          'CM',
          'CN',
          'CO',
          'CR',
          'CV',
          'CW',
          'CY',
          'CZ',
          'DE',
          'DJ',
          'DK',
          'DM',
          'DO',
          'DZ',
          'EC',
          'EE',
          'EG',
          'EH',
          'ER',
          'ES',
          'ET',
          'FI',
          'FJ',
          'FK',
          'FO',
          'FR',
          'GA',
          'GB',
          'GD',
          'GE',
          'GF',
          'GG',
          'GH',
          'GI',
          'GL',
          'GM',
          'GN',
          'GP',
          'GQ',
          'GR',
          'GS',
          'GT',
          'GU',
          'GW',
          'GY',
          'HK',
          'HN',
          'HR',
          'HT',
          'HU',
          'ID',
          'IE',
          'IL',
          'IM',
          'IN',
          'IO',
          'IQ',
          'IS',
          'IT',
          'JE',
          'JM',
          'JO',
          'JP',
          'KE',
          'KG',
          'KH',
          'KI',
          'KM',
          'KN',
          'KR',
          'KW',
          'KY',
          'KZ',
          'LA',
          'LB',
          'LC',
          'LI',
          'LK',
          'LR',
          'LS',
          'LT',
          'LU',
          'LV',
          'LY',
          'MA',
          'MC',
          'MD',
          'ME',
          'MF',
          'MG',
          'MK',
          'ML',
          'MM',
          'MN',
          'MO',
          'MQ',
          'MR',
          'MS',
          'MT',
          'MU',
          'MV',
          'MW',
          'MX',
          'MY',
          'MZ',
          'NA',
          'NC',
          'NE',
          'NG',
          'NI',
          'NL',
          'NO',
          'NP',
          'NR',
          'NU',
          'NZ',
          'OM',
          'PA',
          'PE',
          'PF',
          'PG',
          'PH',
          'PK',
          'PL',
          'PM',
          'PN',
          'PR',
          'PS',
          'PT',
          'PY',
          'QA',
          'RE',
          'RO',
          'RS',
          'RU',
          'RW',
          'SA',
          'SB',
          'SC',
          'SE',
          'SG',
          'SH',
          'SI',
          'SJ',
          'SK',
          'SL',
          'SM',
          'SN',
          'SO',
          'SR',
          'SS',
          'ST',
          'SV',
          'SX',
          'SZ',
          'TA',
          'TC',
          'TD',
          'TF',
          'TG',
          'TH',
          'TJ',
          'TK',
          'TL',
          'TM',
          'TN',
          'TO',
          'TR',
          'TT',
          'TV',
          'TW',
          'TZ',
          'UA',
          'UG',
          'US',
          'UY',
          'UZ',
          'VA',
          'VC',
          'VE',
          'VG',
          'VN',
          'VU',
          'WF',
          'WS',
          'XK',
          'YE',
          'YT',
          'ZA',
          'ZM',
          'ZW',
          'ZZ',
        ],
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['allowed_countries'],
  title: 'PaymentLinksResourceShippingAddressCollection',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_shipping_optionSchema = {
  description: '',
  properties: {
    shipping_amount: {
      description: 'A non-negative integer in cents representing how much to charge.',
      type: 'integer',
    },
    shipping_rate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/shipping_rate',
        },
      ],
      description: 'The ID of the Shipping Rate to use for this shipping option.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/shipping_rate',
          },
        ],
      },
    },
  },
  required: ['shipping_amount', 'shipping_rate'],
  title: 'PaymentLinksResourceShippingOption',
  type: 'object',
  'x-expandableFields': ['shipping_rate'],
} as const;

export const payment_links_resource_subscription_dataSchema = {
  description: '',
  properties: {
    description: {
      description:
        "The subscription's description, meant to be displayable to the customer. Use this field to optionally store an explanation of the subscription for rendering in Stripe surfaces and certain local payment methods UIs.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    invoice_settings: {
      $ref: '#/components/schemas/payment_links_resource_subscription_data_invoice_settings',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that will set metadata on [Subscriptions](https://stripe.com/docs/api/subscriptions) generated from this payment link.',
      type: 'object',
    },
    trial_period_days: {
      description:
        'Integer representing the number of trial period days before the customer is charged for the first time.',
      nullable: true,
      type: 'integer',
    },
    trial_settings: {
      anyOf: [
        {
          $ref: '#/components/schemas/subscriptions_trials_resource_trial_settings',
        },
      ],
      description: 'Settings related to subscription trials.',
      nullable: true,
    },
  },
  required: ['invoice_settings', 'metadata'],
  title: 'PaymentLinksResourceSubscriptionData',
  type: 'object',
  'x-expandableFields': ['invoice_settings', 'trial_settings'],
} as const;

export const payment_links_resource_subscription_data_invoice_settingsSchema = {
  description: '',
  properties: {
    issuer: {
      $ref: '#/components/schemas/connect_account_reference',
    },
  },
  required: ['issuer'],
  title: 'PaymentLinksResourceSubscriptionDataInvoiceSettings',
  type: 'object',
  'x-expandableFields': ['issuer'],
} as const;

export const payment_links_resource_tax_id_collectionSchema = {
  description: '',
  properties: {
    enabled: {
      description: 'Indicates whether tax ID collection is enabled for the session.',
      type: 'boolean',
    },
  },
  required: ['enabled'],
  title: 'PaymentLinksResourceTaxIdCollection',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_links_resource_transfer_dataSchema = {
  description: '',
  properties: {
    amount: {
      description:
        'The amount in cents (or local equivalent) that will be transferred to the destination account. By default, the entire amount is transferred to the destination.',
      nullable: true,
      type: 'integer',
    },
    destination: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/account',
        },
      ],
      description: 'The connected account receiving the transfer.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/account',
          },
        ],
      },
    },
  },
  required: ['destination'],
  title: 'PaymentLinksResourceTransferData',
  type: 'object',
  'x-expandableFields': ['destination'],
} as const;

export const payment_methodSchema = {
  description: `PaymentMethod objects represent your customer's payment instruments.
You can use them with [PaymentIntents](https://stripe.com/docs/payments/payment-intents) to collect payments or save them to
Customer objects to store instrument details for future payments.

Related guides: [Payment Methods](https://stripe.com/docs/payments/payment-methods) and [More Payment Scenarios](https://stripe.com/docs/payments/more-payment-scenarios).`,
  properties: {
    acss_debit: {
      $ref: '#/components/schemas/payment_method_acss_debit',
    },
    affirm: {
      $ref: '#/components/schemas/payment_method_affirm',
    },
    afterpay_clearpay: {
      $ref: '#/components/schemas/payment_method_afterpay_clearpay',
    },
    alipay: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_alipay',
    },
    allow_redisplay: {
      description:
        'This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow. The field defaults to “unspecified”.',
      enum: ['always', 'limited', 'unspecified'],
      type: 'string',
    },
    amazon_pay: {
      $ref: '#/components/schemas/payment_method_amazon_pay',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/payment_method_au_becs_debit',
    },
    bacs_debit: {
      $ref: '#/components/schemas/payment_method_bacs_debit',
    },
    bancontact: {
      $ref: '#/components/schemas/payment_method_bancontact',
    },
    billing_details: {
      $ref: '#/components/schemas/billing_details',
    },
    blik: {
      $ref: '#/components/schemas/payment_method_blik',
    },
    boleto: {
      $ref: '#/components/schemas/payment_method_boleto',
    },
    card: {
      $ref: '#/components/schemas/payment_method_card',
    },
    card_present: {
      $ref: '#/components/schemas/payment_method_card_present',
    },
    cashapp: {
      $ref: '#/components/schemas/payment_method_cashapp',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    customer: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/customer',
        },
      ],
      description:
        'The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/customer',
          },
        ],
      },
    },
    customer_balance: {
      $ref: '#/components/schemas/payment_method_customer_balance',
    },
    eps: {
      $ref: '#/components/schemas/payment_method_eps',
    },
    fpx: {
      $ref: '#/components/schemas/payment_method_fpx',
    },
    giropay: {
      $ref: '#/components/schemas/payment_method_giropay',
    },
    grabpay: {
      $ref: '#/components/schemas/payment_method_grabpay',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    ideal: {
      $ref: '#/components/schemas/payment_method_ideal',
    },
    interac_present: {
      $ref: '#/components/schemas/payment_method_interac_present',
    },
    klarna: {
      $ref: '#/components/schemas/payment_method_klarna',
    },
    konbini: {
      $ref: '#/components/schemas/payment_method_konbini',
    },
    link: {
      $ref: '#/components/schemas/payment_method_link',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    metadata: {
      additionalProperties: {
        maxLength: 500,
        type: 'string',
      },
      description:
        'Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.',
      nullable: true,
      type: 'object',
    },
    mobilepay: {
      $ref: '#/components/schemas/payment_method_mobilepay',
    },
    multibanco: {
      $ref: '#/components/schemas/payment_method_multibanco',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['payment_method'],
      type: 'string',
    },
    oxxo: {
      $ref: '#/components/schemas/payment_method_oxxo',
    },
    p24: {
      $ref: '#/components/schemas/payment_method_p24',
    },
    paynow: {
      $ref: '#/components/schemas/payment_method_paynow',
    },
    paypal: {
      $ref: '#/components/schemas/payment_method_paypal',
    },
    pix: {
      $ref: '#/components/schemas/payment_method_pix',
    },
    promptpay: {
      $ref: '#/components/schemas/payment_method_promptpay',
    },
    radar_options: {
      $ref: '#/components/schemas/radar_radar_options',
    },
    revolut_pay: {
      $ref: '#/components/schemas/payment_method_revolut_pay',
    },
    sepa_debit: {
      $ref: '#/components/schemas/payment_method_sepa_debit',
    },
    sofort: {
      $ref: '#/components/schemas/payment_method_sofort',
    },
    swish: {
      $ref: '#/components/schemas/payment_method_swish',
    },
    twint: {
      $ref: '#/components/schemas/payment_method_twint',
    },
    type: {
      description:
        'The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.',
      enum: [
        'acss_debit',
        'affirm',
        'afterpay_clearpay',
        'alipay',
        'amazon_pay',
        'au_becs_debit',
        'bacs_debit',
        'bancontact',
        'blik',
        'boleto',
        'card',
        'card_present',
        'cashapp',
        'customer_balance',
        'eps',
        'fpx',
        'giropay',
        'grabpay',
        'ideal',
        'interac_present',
        'klarna',
        'konbini',
        'link',
        'mobilepay',
        'multibanco',
        'oxxo',
        'p24',
        'paynow',
        'paypal',
        'pix',
        'promptpay',
        'revolut_pay',
        'sepa_debit',
        'sofort',
        'swish',
        'twint',
        'us_bank_account',
        'wechat_pay',
        'zip',
      ],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    us_bank_account: {
      $ref: '#/components/schemas/payment_method_us_bank_account',
    },
    wechat_pay: {
      $ref: '#/components/schemas/payment_method_wechat_pay',
    },
    zip: {
      $ref: '#/components/schemas/payment_method_zip',
    },
  },
  required: ['billing_details', 'created', 'id', 'livemode', 'object', 'type'],
  title: 'PaymentMethod',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'billing_details',
    'blik',
    'boleto',
    'card',
    'card_present',
    'cashapp',
    'customer',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'grabpay',
    'ideal',
    'interac_present',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'pix',
    'promptpay',
    'radar_options',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'swish',
    'twint',
    'us_bank_account',
    'wechat_pay',
    'zip',
  ],
  'x-resourceId': 'payment_method',
} as const;

export const payment_method_acss_debitSchema = {
  description: '',
  properties: {
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    institution_number: {
      description: 'Institution number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transit_number: {
      description: 'Transit number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_acss_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_affirmSchema = {
  description: '',
  properties: {},
  title: 'payment_method_affirm',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_afterpay_clearpaySchema = {
  description: '',
  properties: {},
  title: 'payment_method_afterpay_clearpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_amazon_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_amazon_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_au_becs_debitSchema = {
  description: '',
  properties: {
    bsb_number: {
      description: 'Six-digit number identifying bank and branch associated with this bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_au_becs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_bacs_debitSchema = {
  description: '',
  properties: {
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    sort_code: {
      description: 'Sort code of the bank account. (e.g., `10-20-30`)',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_bacs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_bancontactSchema = {
  description: '',
  properties: {},
  title: 'payment_method_bancontact',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_blikSchema = {
  description: '',
  properties: {},
  title: 'payment_method_blik',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_boletoSchema = {
  description: '',
  properties: {
    tax_id: {
      description: 'Uniquely identifies the customer tax id (CNPJ or CPF)',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['tax_id'],
  title: 'payment_method_boleto',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_cardSchema = {
  description: '',
  properties: {
    brand: {
      description:
        'Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      type: 'string',
    },
    checks: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_card_checks',
        },
      ],
      description: 'Checks on Card address and CVC if provided.',
      nullable: true,
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    display_brand: {
      description:
        "The brand to use when displaying the card, this accounts for customer's brand choice on dual-branded cards. Can be `american_express`, `cartes_bancaires`, `diners_club`, `discover`, `eftpos_australia`, `interac`, `jcb`, `mastercard`, `union_pay`, `visa`, or `other` and may contain more values in the future.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      type: 'string',
    },
    generated_from: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_card_generated_card',
        },
      ],
      description: 'Details of the original PaymentMethod that created this object.',
      nullable: true,
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      type: 'string',
    },
    networks: {
      anyOf: [
        {
          $ref: '#/components/schemas/networks',
        },
      ],
      description: 'Contains information about card networks that can be used to process the payment.',
      nullable: true,
    },
    three_d_secure_usage: {
      anyOf: [
        {
          $ref: '#/components/schemas/three_d_secure_usage',
        },
      ],
      description: 'Contains details on how this Card may be used for 3D Secure authentication.',
      nullable: true,
    },
    wallet: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_card_wallet',
        },
      ],
      description: 'If this Card is part of a card wallet, this contains the details of the card wallet.',
      nullable: true,
    },
  },
  required: ['brand', 'exp_month', 'exp_year', 'funding', 'last4'],
  title: 'payment_method_card',
  type: 'object',
  'x-expandableFields': ['checks', 'generated_from', 'networks', 'three_d_secure_usage', 'wallet'],
} as const;

export const payment_method_card_checksSchema = {
  description: '',
  properties: {
    address_line1_check: {
      description:
        'If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_postal_code_check: {
      description:
        'If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cvc_check: {
      description: 'If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_card_checks',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_generated_cardSchema = {
  description: '',
  properties: {
    charge: {
      description: 'The charge that created this object.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_method_details: {
      anyOf: [
        {
          $ref: '#/components/schemas/card_generated_from_payment_method_details',
        },
      ],
      description: 'Transaction-specific details of the payment method used in the payment.',
      nullable: true,
    },
    setup_attempt: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/setup_attempt',
        },
      ],
      description: 'The ID of the SetupAttempt that generated this PaymentMethod, if any.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/setup_attempt',
          },
        ],
      },
    },
  },
  title: 'payment_method_card_generated_card',
  type: 'object',
  'x-expandableFields': ['payment_method_details', 'setup_attempt'],
} as const;

export const payment_method_card_presentSchema = {
  description: '',
  properties: {
    brand: {
      description:
        'Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cardholder_name: {
      description:
        'The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    networks: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_card_present_networks',
        },
      ],
      description: 'Contains information about card networks that can be used to process the payment.',
      nullable: true,
    },
    preferred_locales: {
      description: 'EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    read_method: {
      description: 'How card details were read in this transaction.',
      enum: [
        'contact_emv',
        'contactless_emv',
        'contactless_magstripe_mode',
        'magnetic_stripe_fallback',
        'magnetic_stripe_track2',
      ],
      nullable: true,
      type: 'string',
    },
  },
  required: ['exp_month', 'exp_year'],
  title: 'payment_method_card_present',
  type: 'object',
  'x-expandableFields': ['networks'],
} as const;

export const payment_method_card_present_networksSchema = {
  description: '',
  properties: {
    available: {
      description: 'All available networks for the card.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      type: 'array',
    },
    preferred: {
      description: 'The preferred network for the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['available'],
  title: 'payment_method_card_present_networks',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_walletSchema = {
  description: '',
  properties: {
    amex_express_checkout: {
      $ref: '#/components/schemas/payment_method_card_wallet_amex_express_checkout',
    },
    apple_pay: {
      $ref: '#/components/schemas/payment_method_card_wallet_apple_pay',
    },
    dynamic_last4: {
      description: '(For tokenized numbers only.) The last four digits of the device account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    google_pay: {
      $ref: '#/components/schemas/payment_method_card_wallet_google_pay',
    },
    link: {
      $ref: '#/components/schemas/payment_method_card_wallet_link',
    },
    masterpass: {
      $ref: '#/components/schemas/payment_method_card_wallet_masterpass',
    },
    samsung_pay: {
      $ref: '#/components/schemas/payment_method_card_wallet_samsung_pay',
    },
    type: {
      description:
        'The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, `visa_checkout`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.',
      enum: ['amex_express_checkout', 'apple_pay', 'google_pay', 'link', 'masterpass', 'samsung_pay', 'visa_checkout'],
      type: 'string',
    },
    visa_checkout: {
      $ref: '#/components/schemas/payment_method_card_wallet_visa_checkout',
    },
  },
  required: ['type'],
  title: 'payment_method_card_wallet',
  type: 'object',
  'x-expandableFields': [
    'amex_express_checkout',
    'apple_pay',
    'google_pay',
    'link',
    'masterpass',
    'samsung_pay',
    'visa_checkout',
  ],
} as const;

export const payment_method_card_wallet_amex_express_checkoutSchema = {
  description: '',
  properties: {},
  title: 'payment_method_card_wallet_amex_express_checkout',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_wallet_apple_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_card_wallet_apple_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_wallet_google_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_card_wallet_google_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_wallet_linkSchema = {
  description: '',
  properties: {},
  title: 'payment_method_card_wallet_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_wallet_masterpassSchema = {
  description: '',
  properties: {
    billing_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
    email: {
      description:
        "Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        "Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
  },
  title: 'payment_method_card_wallet_masterpass',
  type: 'object',
  'x-expandableFields': ['billing_address', 'shipping_address'],
} as const;

export const payment_method_card_wallet_samsung_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_card_wallet_samsung_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_card_wallet_visa_checkoutSchema = {
  description: '',
  properties: {
    billing_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
    email: {
      description:
        "Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        "Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
  },
  title: 'payment_method_card_wallet_visa_checkout',
  type: 'object',
  'x-expandableFields': ['billing_address', 'shipping_address'],
} as const;

export const payment_method_cashappSchema = {
  description: '',
  properties: {
    buyer_id: {
      description: 'A unique and immutable identifier assigned by Cash App to every buyer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cashtag: {
      description: 'A public identifier for buyers using Cash App.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_cashapp',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_config_biz_payment_method_configuration_detailsSchema = {
  description: '',
  properties: {
    id: {
      description: 'ID of the payment method configuration used.',
      maxLength: 5000,
      type: 'string',
    },
    parent: {
      description: 'ID of the parent payment method configuration used.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['id'],
  title: 'PaymentMethodConfigBizPaymentMethodConfigurationDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_config_resource_display_preferenceSchema = {
  description: '',
  properties: {
    overridable: {
      description:
        "For child configs, whether or not the account's preference will be observed. If `false`, the parent configuration's default is used.",
      nullable: true,
      type: 'boolean',
    },
    preference: {
      description: "The account's display preference.",
      enum: ['none', 'off', 'on'],
      type: 'string',
    },
    value: {
      description: 'The effective display preference value.',
      enum: ['off', 'on'],
      type: 'string',
    },
  },
  required: ['preference', 'value'],
  title: 'PaymentMethodConfigResourceDisplayPreference',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_config_resource_payment_method_propertiesSchema = {
  description: '',
  properties: {
    available: {
      description:
        "Whether this payment method may be offered at checkout. True if `display_preference` is `on` and the payment method's capability is active.",
      type: 'boolean',
    },
    display_preference: {
      $ref: '#/components/schemas/payment_method_config_resource_display_preference',
    },
  },
  required: ['available', 'display_preference'],
  title: 'PaymentMethodConfigResourcePaymentMethodProperties',
  type: 'object',
  'x-expandableFields': ['display_preference'],
} as const;

export const payment_method_configurationSchema = {
  description: `PaymentMethodConfigurations control which payment methods are displayed to your customers when you don't explicitly specify payment method types. You can have multiple configurations with different sets of payment methods for different scenarios.

There are two types of PaymentMethodConfigurations. Which is used depends on the [charge type](https://stripe.com/docs/connect/charges):

**Direct** configurations apply to payments created on your account, including Connect destination charges, Connect separate charges and transfers, and payments not involving Connect.

**Child** configurations apply to payments created on your connected accounts using direct charges, and charges with the on_behalf_of parameter.

Child configurations have a \`parent\` that sets default values and controls which settings connected accounts may override. You can specify a parent ID at payment time, and Stripe will automatically resolve the connected account’s associated child configuration. Parent configurations are [managed in the dashboard](https://dashboard.stripe.com/settings/payment_methods/connected_accounts) and are not available in this API.

Related guides:
- [Payment Method Configurations API](https://stripe.com/docs/connect/payment-method-configurations)
- [Multiple configurations on dynamic payment methods](https://stripe.com/docs/payments/multiple-payment-method-configs)
- [Multiple configurations for your Connect accounts](https://stripe.com/docs/connect/multiple-payment-method-configurations)`,
  properties: {
    acss_debit: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    active: {
      description: 'Whether the configuration can be used for new payments.',
      type: 'boolean',
    },
    affirm: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    afterpay_clearpay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    alipay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    amazon_pay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    apple_pay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    application: {
      description: 'For child configs, the Connect application associated with the configuration.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    bacs_debit: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    bancontact: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    blik: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    boleto: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    card: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    cartes_bancaires: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    cashapp: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    customer_balance: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    eps: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    fpx: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    giropay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    google_pay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    grabpay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    ideal: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    is_default: {
      description: 'The default configuration is used whenever a payment method configuration is not specified.',
      type: 'boolean',
    },
    jcb: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    klarna: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    konbini: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    link: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    mobilepay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    multibanco: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    name: {
      description: "The configuration's name.",
      maxLength: 5000,
      type: 'string',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['payment_method_configuration'],
      type: 'string',
    },
    oxxo: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    p24: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    parent: {
      description: "For child configs, the configuration's parent configuration.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    paynow: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    paypal: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    promptpay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    revolut_pay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    sepa_debit: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    sofort: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    swish: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    us_bank_account: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    wechat_pay: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
    zip: {
      $ref: '#/components/schemas/payment_method_config_resource_payment_method_properties',
    },
  },
  required: ['active', 'id', 'is_default', 'livemode', 'name', 'object'],
  title: 'PaymentMethodConfigResourcePaymentMethodConfiguration',
  type: 'object',
  'x-expandableFields': [
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'apple_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'blik',
    'boleto',
    'card',
    'cartes_bancaires',
    'cashapp',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'google_pay',
    'grabpay',
    'ideal',
    'jcb',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'promptpay',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'swish',
    'us_bank_account',
    'wechat_pay',
    'zip',
  ],
  'x-resourceId': 'payment_method_configuration',
} as const;

export const payment_method_customer_balanceSchema = {
  description: '',
  properties: {},
  title: 'payment_method_customer_balance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_detailsSchema = {
  description: '',
  properties: {
    ach_credit_transfer: {
      $ref: '#/components/schemas/payment_method_details_ach_credit_transfer',
    },
    ach_debit: {
      $ref: '#/components/schemas/payment_method_details_ach_debit',
    },
    acss_debit: {
      $ref: '#/components/schemas/payment_method_details_acss_debit',
    },
    affirm: {
      $ref: '#/components/schemas/payment_method_details_affirm',
    },
    afterpay_clearpay: {
      $ref: '#/components/schemas/payment_method_details_afterpay_clearpay',
    },
    alipay: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_alipay_details',
    },
    amazon_pay: {
      $ref: '#/components/schemas/payment_method_details_amazon_pay',
    },
    au_becs_debit: {
      $ref: '#/components/schemas/payment_method_details_au_becs_debit',
    },
    bacs_debit: {
      $ref: '#/components/schemas/payment_method_details_bacs_debit',
    },
    bancontact: {
      $ref: '#/components/schemas/payment_method_details_bancontact',
    },
    blik: {
      $ref: '#/components/schemas/payment_method_details_blik',
    },
    boleto: {
      $ref: '#/components/schemas/payment_method_details_boleto',
    },
    card: {
      $ref: '#/components/schemas/payment_method_details_card',
    },
    card_present: {
      $ref: '#/components/schemas/payment_method_details_card_present',
    },
    cashapp: {
      $ref: '#/components/schemas/payment_method_details_cashapp',
    },
    customer_balance: {
      $ref: '#/components/schemas/payment_method_details_customer_balance',
    },
    eps: {
      $ref: '#/components/schemas/payment_method_details_eps',
    },
    fpx: {
      $ref: '#/components/schemas/payment_method_details_fpx',
    },
    giropay: {
      $ref: '#/components/schemas/payment_method_details_giropay',
    },
    grabpay: {
      $ref: '#/components/schemas/payment_method_details_grabpay',
    },
    ideal: {
      $ref: '#/components/schemas/payment_method_details_ideal',
    },
    interac_present: {
      $ref: '#/components/schemas/payment_method_details_interac_present',
    },
    klarna: {
      $ref: '#/components/schemas/payment_method_details_klarna',
    },
    konbini: {
      $ref: '#/components/schemas/payment_method_details_konbini',
    },
    link: {
      $ref: '#/components/schemas/payment_method_details_link',
    },
    mobilepay: {
      $ref: '#/components/schemas/payment_method_details_mobilepay',
    },
    multibanco: {
      $ref: '#/components/schemas/payment_method_details_multibanco',
    },
    oxxo: {
      $ref: '#/components/schemas/payment_method_details_oxxo',
    },
    p24: {
      $ref: '#/components/schemas/payment_method_details_p24',
    },
    paynow: {
      $ref: '#/components/schemas/payment_method_details_paynow',
    },
    paypal: {
      $ref: '#/components/schemas/payment_method_details_paypal',
    },
    pix: {
      $ref: '#/components/schemas/payment_method_details_pix',
    },
    promptpay: {
      $ref: '#/components/schemas/payment_method_details_promptpay',
    },
    revolut_pay: {
      $ref: '#/components/schemas/payment_method_details_revolut_pay',
    },
    sepa_debit: {
      $ref: '#/components/schemas/payment_method_details_sepa_debit',
    },
    sofort: {
      $ref: '#/components/schemas/payment_method_details_sofort',
    },
    stripe_account: {
      $ref: '#/components/schemas/payment_method_details_stripe_account',
    },
    swish: {
      $ref: '#/components/schemas/payment_method_details_swish',
    },
    twint: {
      $ref: '#/components/schemas/payment_method_details_twint',
    },
    type: {
      description: `The type of transaction-specific details of the payment method used in the payment, one of \`ach_credit_transfer\`, \`ach_debit\`, \`acss_debit\`, \`alipay\`, \`au_becs_debit\`, \`bancontact\`, \`card\`, \`card_present\`, \`eps\`, \`giropay\`, \`ideal\`, \`klarna\`, \`multibanco\`, \`p24\`, \`sepa_debit\`, \`sofort\`, \`stripe_account\`, or \`wechat\`.
An additional hash is included on \`payment_method_details\` with a name matching this value.
It contains information specific to the payment method.`,
      maxLength: 5000,
      type: 'string',
    },
    us_bank_account: {
      $ref: '#/components/schemas/payment_method_details_us_bank_account',
    },
    wechat: {
      $ref: '#/components/schemas/payment_method_details_wechat',
    },
    wechat_pay: {
      $ref: '#/components/schemas/payment_method_details_wechat_pay',
    },
    zip: {
      $ref: '#/components/schemas/payment_method_details_zip',
    },
  },
  required: ['type'],
  title: 'payment_method_details',
  type: 'object',
  'x-expandableFields': [
    'ach_credit_transfer',
    'ach_debit',
    'acss_debit',
    'affirm',
    'afterpay_clearpay',
    'alipay',
    'amazon_pay',
    'au_becs_debit',
    'bacs_debit',
    'bancontact',
    'blik',
    'boleto',
    'card',
    'card_present',
    'cashapp',
    'customer_balance',
    'eps',
    'fpx',
    'giropay',
    'grabpay',
    'ideal',
    'interac_present',
    'klarna',
    'konbini',
    'link',
    'mobilepay',
    'multibanco',
    'oxxo',
    'p24',
    'paynow',
    'paypal',
    'pix',
    'promptpay',
    'revolut_pay',
    'sepa_debit',
    'sofort',
    'stripe_account',
    'swish',
    'twint',
    'us_bank_account',
    'wechat',
    'wechat_pay',
    'zip',
  ],
} as const;

export const payment_method_details_ach_credit_transferSchema = {
  description: '',
  properties: {
    account_number: {
      description: 'Account number to transfer funds to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the routing number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    routing_number: {
      description: 'Routing transit number for the bank account to transfer funds to.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    swift_code: {
      description: 'SWIFT code of the bank associated with the routing number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_ach_credit_transfer',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_ach_debitSchema = {
  description: '',
  properties: {
    account_holder_type: {
      description: 'Type of entity that holds the account. This can be either `individual` or `company`.',
      enum: ['company', 'individual'],
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country the bank account is located in.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    routing_number: {
      description: 'Routing transit number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_ach_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_acss_debitSchema = {
  description: '',
  properties: {
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    institution_number: {
      description: 'Institution number of the bank account',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      description: 'ID of the mandate used to make this payment.',
      maxLength: 5000,
      type: 'string',
    },
    transit_number: {
      description: 'Transit number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_acss_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_affirmSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_affirm',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_afterpay_clearpaySchema = {
  description: '',
  properties: {
    order_id: {
      description: 'The Afterpay order ID associated with this payment intent.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reference: {
      description: 'Order identifier shown to the merchant in Afterpay’s online portal.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_afterpay_clearpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_amazon_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_amazon_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_au_becs_debitSchema = {
  description: '',
  properties: {
    bsb_number: {
      description: 'Bank-State-Branch number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      description: 'ID of the mandate used to make this payment.',
      maxLength: 5000,
      type: 'string',
    },
  },
  title: 'payment_method_details_au_becs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_bacs_debitSchema = {
  description: '',
  properties: {
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      description: 'ID of the mandate used to make this payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    sort_code: {
      description: 'Sort code of the bank account. (e.g., `10-20-30`)',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_bacs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_bancontactSchema = {
  description: '',
  properties: {
    bank_code: {
      description: 'Bank code of bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bic: {
      description: 'Bank Identifier Code of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    generated_sepa_debit: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description: 'The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    generated_sepa_debit_mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    iban_last4: {
      description: 'Last four characters of the IBAN.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_language: {
      description: `Preferred language of the Bancontact authorization page that the customer is redirected to.
Can be one of \`en\`, \`de\`, \`fr\`, or \`nl\``,
      enum: ['de', 'en', 'fr', 'nl'],
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by Bancontact directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_bancontact',
  type: 'object',
  'x-expandableFields': ['generated_sepa_debit', 'generated_sepa_debit_mandate'],
} as const;

export const payment_method_details_blikSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_blik',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_boletoSchema = {
  description: '',
  properties: {
    tax_id: {
      description: 'The tax ID of the customer (CPF for individuals consumers or CNPJ for businesses consumers)',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['tax_id'],
  title: 'payment_method_details_boleto',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_cardSchema = {
  description: '',
  properties: {
    amount_authorized: {
      description: 'The authorized amount.',
      nullable: true,
      type: 'integer',
    },
    brand: {
      description:
        'Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    capture_before: {
      description:
        'When using manual capture, a future timestamp at which the charge will be automatically refunded if uncaptured.',
      format: 'unix-time',
      type: 'integer',
    },
    checks: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_checks',
        },
      ],
      description: 'Check results by Card networks on Card address and CVC at time of payment.',
      nullable: true,
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    extended_authorization: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_extended_authorization_extended_authorization',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    incremental_authorization: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_incremental_authorization_incremental_authorization',
    },
    installments: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_installments',
        },
      ],
      description: `Installment details for this payment (Mexico only).

For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).`,
      nullable: true,
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      description: 'ID of the mandate used to make this payment or created by it.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    multicapture: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_card_details_api_resource_multicapture',
    },
    network: {
      description:
        'Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    network_token: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_network_token',
        },
      ],
      description:
        'If this card has network token credentials, this contains the details of the network token credentials.',
      nullable: true,
    },
    overcapture: {
      $ref: '#/components/schemas/payment_flows_private_payment_methods_card_details_api_resource_enterprise_features_overcapture_overcapture',
    },
    three_d_secure: {
      anyOf: [
        {
          $ref: '#/components/schemas/three_d_secure_details_charge',
        },
      ],
      description: 'Populated if this transaction used 3D Secure authentication.',
      nullable: true,
    },
    wallet: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_wallet',
        },
      ],
      description: 'If this Card is part of a card wallet, this contains the details of the card wallet.',
      nullable: true,
    },
  },
  required: ['exp_month', 'exp_year'],
  title: 'payment_method_details_card',
  type: 'object',
  'x-expandableFields': [
    'checks',
    'extended_authorization',
    'incremental_authorization',
    'installments',
    'multicapture',
    'network_token',
    'overcapture',
    'three_d_secure',
    'wallet',
  ],
} as const;

export const payment_method_details_card_checksSchema = {
  description: '',
  properties: {
    address_line1_check: {
      description:
        'If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    address_postal_code_check: {
      description:
        'If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cvc_check: {
      description: 'If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_card_checks',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_installmentsSchema = {
  description: '',
  properties: {
    plan: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_installments_plan',
        },
      ],
      description: 'Installment plan selected for the payment.',
      nullable: true,
    },
  },
  title: 'payment_method_details_card_installments',
  type: 'object',
  'x-expandableFields': ['plan'],
} as const;

export const payment_method_details_card_installments_planSchema = {
  description: '',
  properties: {
    count: {
      description:
        'For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.',
      nullable: true,
      type: 'integer',
    },
    interval: {
      description: `For \`fixed_count\` installment plans, this is the interval between installment payments your customer will make to their credit card.
One of \`month\`.`,
      enum: ['month'],
      nullable: true,
      type: 'string',
    },
    type: {
      description: 'Type of installment plan, one of `fixed_count`.',
      enum: ['fixed_count'],
      type: 'string',
    },
  },
  required: ['type'],
  title: 'payment_method_details_card_installments_plan',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_network_tokenSchema = {
  description: '',
  properties: {
    used: {
      description:
        'Indicates if Stripe used a network token, either user provided or Stripe managed when processing the transaction.',
      type: 'boolean',
    },
  },
  required: ['used'],
  title: 'payment_method_details_card_network_token',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_presentSchema = {
  description: '',
  properties: {
    amount_authorized: {
      description: 'The authorized amount',
      nullable: true,
      type: 'integer',
    },
    brand: {
      description:
        'Card brand. Can be `amex`, `diners`, `discover`, `eftpos_au`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    capture_before: {
      description:
        'When using manual capture, a future timestamp after which the charge will be automatically refunded if uncaptured.',
      format: 'unix-time',
      type: 'integer',
    },
    cardholder_name: {
      description:
        'The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    emv_auth_data: {
      description: 'Authorization response cryptogram.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    generated_card: {
      description:
        'ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    incremental_authorization_supported: {
      description:
        'Whether this [PaymentIntent](https://stripe.com/docs/api/payment_intents) is eligible for incremental authorizations. Request support using [request_incremental_authorization_support](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-payment_method_options-card_present-request_incremental_authorization_support).',
      type: 'boolean',
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    network: {
      description:
        'Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    offline: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_present_offline',
        },
      ],
      description: 'Details about payments collected offline.',
      nullable: true,
    },
    overcapture_supported: {
      description: 'Defines whether the authorized amount can be over-captured or not',
      type: 'boolean',
    },
    preferred_locales: {
      description: 'EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    read_method: {
      description: 'How card details were read in this transaction.',
      enum: [
        'contact_emv',
        'contactless_emv',
        'contactless_magstripe_mode',
        'magnetic_stripe_fallback',
        'magnetic_stripe_track2',
      ],
      nullable: true,
      type: 'string',
    },
    receipt: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_present_receipt',
        },
      ],
      description: 'A collection of fields required to be displayed on receipts. Only required for EMV transactions.',
      nullable: true,
    },
  },
  required: ['exp_month', 'exp_year', 'incremental_authorization_supported', 'overcapture_supported'],
  title: 'payment_method_details_card_present',
  type: 'object',
  'x-expandableFields': ['offline', 'receipt'],
} as const;

export const payment_method_details_card_present_offlineSchema = {
  description: '',
  properties: {
    stored_at: {
      description: 'Time at which the payment was collected while offline',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
  },
  title: 'payment_method_details_card_present_offline',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_present_receiptSchema = {
  description: '',
  properties: {
    account_type: {
      description: 'The type of account being debited or credited',
      enum: ['checking', 'credit', 'prepaid', 'unknown'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    application_cryptogram: {
      description: 'EMV tag 9F26, cryptogram generated by the integrated circuit chip.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    application_preferred_name: {
      description: 'Mnenomic of the Application Identifier.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    authorization_code: {
      description: 'Identifier for this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    authorization_response_code: {
      description: 'EMV tag 8A. A code returned by the card issuer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cardholder_verification_method: {
      description:
        'Describes the method used by the cardholder to verify ownership of the card. One of the following: `approval`, `failure`, `none`, `offline_pin`, `offline_pin_and_signature`, `online_pin`, or `signature`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    dedicated_file_name: {
      description: 'EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    terminal_verification_results: {
      description: 'The outcome of a series of EMV functions performed by the card reader.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_status_information: {
      description: 'An indication of various EMV functions performed during the transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_card_present_receipt',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_walletSchema = {
  description: '',
  properties: {
    amex_express_checkout: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_amex_express_checkout',
    },
    apple_pay: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_apple_pay',
    },
    dynamic_last4: {
      description: '(For tokenized numbers only.) The last four digits of the device account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    google_pay: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_google_pay',
    },
    link: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_link',
    },
    masterpass: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_masterpass',
    },
    samsung_pay: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_samsung_pay',
    },
    type: {
      description:
        'The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, `visa_checkout`, or `link`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.',
      enum: ['amex_express_checkout', 'apple_pay', 'google_pay', 'link', 'masterpass', 'samsung_pay', 'visa_checkout'],
      type: 'string',
    },
    visa_checkout: {
      $ref: '#/components/schemas/payment_method_details_card_wallet_visa_checkout',
    },
  },
  required: ['type'],
  title: 'payment_method_details_card_wallet',
  type: 'object',
  'x-expandableFields': [
    'amex_express_checkout',
    'apple_pay',
    'google_pay',
    'link',
    'masterpass',
    'samsung_pay',
    'visa_checkout',
  ],
} as const;

export const payment_method_details_card_wallet_amex_express_checkoutSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_card_wallet_amex_express_checkout',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_wallet_apple_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_card_wallet_apple_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_wallet_google_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_card_wallet_google_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_wallet_linkSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_card_wallet_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_wallet_masterpassSchema = {
  description: '',
  properties: {
    billing_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
    email: {
      description:
        "Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        "Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
  },
  title: 'payment_method_details_card_wallet_masterpass',
  type: 'object',
  'x-expandableFields': ['billing_address', 'shipping_address'],
} as const;

export const payment_method_details_card_wallet_samsung_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_card_wallet_samsung_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_card_wallet_visa_checkoutSchema = {
  description: '',
  properties: {
    billing_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
    email: {
      description:
        "Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    name: {
      description:
        "Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    shipping_address: {
      anyOf: [
        {
          $ref: '#/components/schemas/address',
        },
      ],
      description:
        "Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.",
      nullable: true,
    },
  },
  title: 'payment_method_details_card_wallet_visa_checkout',
  type: 'object',
  'x-expandableFields': ['billing_address', 'shipping_address'],
} as const;

export const payment_method_details_cashappSchema = {
  description: '',
  properties: {
    buyer_id: {
      description: 'A unique and immutable identifier assigned by Cash App to every buyer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cashtag: {
      description: 'A public identifier for buyers using Cash App.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_cashapp',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_customer_balanceSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_customer_balance',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_epsSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank. Should be one of `arzte_und_apotheker_bank`, `austrian_anadi_bank_ag`, `bank_austria`, `bankhaus_carl_spangler`, `bankhaus_schelhammer_und_schattera_ag`, `bawag_psk_ag`, `bks_bank_ag`, `brull_kallmus_bank_ag`, `btv_vier_lander_bank`, `capital_bank_grawe_gruppe_ag`, `deutsche_bank_ag`, `dolomitenbank`, `easybank_ag`, `erste_bank_und_sparkassen`, `hypo_alpeadriabank_international_ag`, `hypo_noe_lb_fur_niederosterreich_u_wien`, `hypo_oberosterreich_salzburg_steiermark`, `hypo_tirol_bank_ag`, `hypo_vorarlberg_bank_ag`, `hypo_bank_burgenland_aktiengesellschaft`, `marchfelder_bank`, `oberbank_ag`, `raiffeisen_bankengruppe_osterreich`, `schoellerbank_ag`, `sparda_bank_wien`, `volksbank_gruppe`, `volkskreditbank_ag`, or `vr_bank_braunau`.",
      enum: [
        'arzte_und_apotheker_bank',
        'austrian_anadi_bank_ag',
        'bank_austria',
        'bankhaus_carl_spangler',
        'bankhaus_schelhammer_und_schattera_ag',
        'bawag_psk_ag',
        'bks_bank_ag',
        'brull_kallmus_bank_ag',
        'btv_vier_lander_bank',
        'capital_bank_grawe_gruppe_ag',
        'deutsche_bank_ag',
        'dolomitenbank',
        'easybank_ag',
        'erste_bank_und_sparkassen',
        'hypo_alpeadriabank_international_ag',
        'hypo_bank_burgenland_aktiengesellschaft',
        'hypo_noe_lb_fur_niederosterreich_u_wien',
        'hypo_oberosterreich_salzburg_steiermark',
        'hypo_tirol_bank_ag',
        'hypo_vorarlberg_bank_ag',
        'marchfelder_bank',
        'oberbank_ag',
        'raiffeisen_bankengruppe_osterreich',
        'schoellerbank_ag',
        'sparda_bank_wien',
        'volksbank_gruppe',
        'volkskreditbank_ag',
        'vr_bank_braunau',
      ],
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by EPS directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.
EPS rarely provides this information so the attribute is usually empty.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_eps',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_fpxSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank. Can be one of `affin_bank`, `agrobank`, `alliance_bank`, `ambank`, `bank_islam`, `bank_muamalat`, `bank_rakyat`, `bsn`, `cimb`, `hong_leong_bank`, `hsbc`, `kfh`, `maybank2u`, `ocbc`, `public_bank`, `rhb`, `standard_chartered`, `uob`, `deutsche_bank`, `maybank2e`, `pb_enterprise`, or `bank_of_china`.",
      enum: [
        'affin_bank',
        'agrobank',
        'alliance_bank',
        'ambank',
        'bank_islam',
        'bank_muamalat',
        'bank_of_china',
        'bank_rakyat',
        'bsn',
        'cimb',
        'deutsche_bank',
        'hong_leong_bank',
        'hsbc',
        'kfh',
        'maybank2e',
        'maybank2u',
        'ocbc',
        'pb_enterprise',
        'public_bank',
        'rhb',
        'standard_chartered',
        'uob',
      ],
      type: 'string',
    },
    transaction_id: {
      description: 'Unique transaction id generated by FPX for every request from the merchant',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  required: ['bank'],
  title: 'payment_method_details_fpx',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_giropaySchema = {
  description: '',
  properties: {
    bank_code: {
      description: 'Bank code of bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bic: {
      description: 'Bank Identifier Code of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by Giropay directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.
Giropay rarely provides this information so the attribute is usually empty.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_giropay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_grabpaySchema = {
  description: '',
  properties: {
    transaction_id: {
      description: 'Unique transaction id generated by GrabPay',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_grabpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_idealSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.",
      enum: [
        'abn_amro',
        'asn_bank',
        'bunq',
        'handelsbanken',
        'ing',
        'knab',
        'moneyou',
        'n26',
        'nn',
        'rabobank',
        'regiobank',
        'revolut',
        'sns_bank',
        'triodos_bank',
        'van_lanschot',
        'yoursafe',
      ],
      nullable: true,
      type: 'string',
    },
    bic: {
      description: "The Bank Identifier Code of the customer's bank.",
      enum: [
        'ABNANL2A',
        'ASNBNL21',
        'BITSNL2A',
        'BUNQNL2A',
        'FVLBNL22',
        'HANDNL2A',
        'INGBNL2A',
        'KNABNL2H',
        'MOYONL21',
        'NNBANL2G',
        'NTSBDEB1',
        'RABONL2U',
        'RBRBNL21',
        'REVOIE23',
        'REVOLT21',
        'SNSBNL2A',
        'TRIONL2U',
      ],
      nullable: true,
      type: 'string',
    },
    generated_sepa_debit: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description: 'The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    generated_sepa_debit_mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    iban_last4: {
      description: 'Last four characters of the IBAN.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by iDEAL directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_ideal',
  type: 'object',
  'x-expandableFields': ['generated_sepa_debit', 'generated_sepa_debit_mandate'],
} as const;

export const payment_method_details_interac_presentSchema = {
  description: '',
  properties: {
    brand: {
      description: 'Card brand. Can be `interac`, `mastercard` or `visa`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cardholder_name: {
      description:
        'The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    emv_auth_data: {
      description: 'Authorization response cryptogram.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    generated_card: {
      description:
        'ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    network: {
      description:
        'Identifies which network this charge was processed on. Can be `amex`, `cartes_bancaires`, `diners`, `discover`, `eftpos_au`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_locales: {
      description: 'EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    read_method: {
      description: 'How card details were read in this transaction.',
      enum: [
        'contact_emv',
        'contactless_emv',
        'contactless_magstripe_mode',
        'magnetic_stripe_fallback',
        'magnetic_stripe_track2',
      ],
      nullable: true,
      type: 'string',
    },
    receipt: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_interac_present_receipt',
        },
      ],
      description: 'A collection of fields required to be displayed on receipts. Only required for EMV transactions.',
      nullable: true,
    },
  },
  required: ['exp_month', 'exp_year'],
  title: 'payment_method_details_interac_present',
  type: 'object',
  'x-expandableFields': ['receipt'],
} as const;

export const payment_method_details_interac_present_receiptSchema = {
  description: '',
  properties: {
    account_type: {
      description: 'The type of account being debited or credited',
      enum: ['checking', 'savings', 'unknown'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
    application_cryptogram: {
      description: 'EMV tag 9F26, cryptogram generated by the integrated circuit chip.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    application_preferred_name: {
      description: 'Mnenomic of the Application Identifier.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    authorization_code: {
      description: 'Identifier for this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    authorization_response_code: {
      description: 'EMV tag 8A. A code returned by the card issuer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cardholder_verification_method: {
      description:
        'Describes the method used by the cardholder to verify ownership of the card. One of the following: `approval`, `failure`, `none`, `offline_pin`, `offline_pin_and_signature`, `online_pin`, or `signature`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    dedicated_file_name: {
      description: 'EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    terminal_verification_results: {
      description: 'The outcome of a series of EMV functions performed by the card reader.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_status_information: {
      description: 'An indication of various EMV functions performed during the transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_interac_present_receipt',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_klarnaSchema = {
  description: '',
  properties: {
    payment_method_category: {
      description: `The Klarna payment method used for this transaction.
Can be one of \`pay_later\`, \`pay_now\`, \`pay_with_financing\`, or \`pay_in_installments\``,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_locale: {
      description: `Preferred language of the Klarna authorization page that the customer is redirected to.
Can be one of \`de-AT\`, \`en-AT\`, \`nl-BE\`, \`fr-BE\`, \`en-BE\`, \`de-DE\`, \`en-DE\`, \`da-DK\`, \`en-DK\`, \`es-ES\`, \`en-ES\`, \`fi-FI\`, \`sv-FI\`, \`en-FI\`, \`en-GB\`, \`en-IE\`, \`it-IT\`, \`en-IT\`, \`nl-NL\`, \`en-NL\`, \`nb-NO\`, \`en-NO\`, \`sv-SE\`, \`en-SE\`, \`en-US\`, \`es-US\`, \`fr-FR\`, \`en-FR\`, \`cs-CZ\`, \`en-CZ\`, \`ro-RO\`, \`en-RO\`, \`el-GR\`, \`en-GR\`, \`en-AU\`, \`en-NZ\`, \`en-CA\`, \`fr-CA\`, \`pl-PL\`, \`en-PL\`, \`pt-PT\`, \`en-PT\`, \`de-CH\`, \`fr-CH\`, \`it-CH\`, or \`en-CH\``,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_klarna',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_konbiniSchema = {
  description: '',
  properties: {
    store: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_konbini_store',
        },
      ],
      description:
        'If the payment succeeded, this contains the details of the convenience store where the payment was completed.',
      nullable: true,
    },
  },
  title: 'payment_method_details_konbini',
  type: 'object',
  'x-expandableFields': ['store'],
} as const;

export const payment_method_details_konbini_storeSchema = {
  description: '',
  properties: {
    chain: {
      description: 'The name of the convenience store chain where the payment was completed.',
      enum: ['familymart', 'lawson', 'ministop', 'seicomart'],
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_konbini_store',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_linkSchema = {
  description: '',
  properties: {
    country: {
      description: `Two-letter ISO code representing the funding source country beneath the Link payment.
You could use this attribute to get a sense of international fees.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_mobilepaySchema = {
  description: '',
  properties: {
    card: {
      anyOf: [
        {
          $ref: '#/components/schemas/internal_card',
        },
      ],
      description: 'Internal card details',
      nullable: true,
    },
  },
  title: 'payment_method_details_mobilepay',
  type: 'object',
  'x-expandableFields': ['card'],
} as const;

export const payment_method_details_multibancoSchema = {
  description: '',
  properties: {
    entity: {
      description: 'Entity number associated with this Multibanco payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    reference: {
      description: 'Reference number associated with this Multibanco payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_multibanco',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_oxxoSchema = {
  description: '',
  properties: {
    number: {
      description: 'OXXO reference number',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_oxxo',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_p24Schema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank. Can be one of `ing`, `citi_handlowy`, `tmobile_usbugi_bankowe`, `plus_bank`, `etransfer_pocztowy24`, `banki_spbdzielcze`, `bank_nowy_bfg_sa`, `getin_bank`, `velobank`, `blik`, `noble_pay`, `ideabank`, `envelobank`, `santander_przelew24`, `nest_przelew`, `mbank_mtransfer`, `inteligo`, `pbac_z_ipko`, `bnp_paribas`, `credit_agricole`, `toyota_bank`, `bank_pekao_sa`, `volkswagen_bank`, `bank_millennium`, `alior_bank`, or `boz`.",
      enum: [
        'alior_bank',
        'bank_millennium',
        'bank_nowy_bfg_sa',
        'bank_pekao_sa',
        'banki_spbdzielcze',
        'blik',
        'bnp_paribas',
        'boz',
        'citi_handlowy',
        'credit_agricole',
        'envelobank',
        'etransfer_pocztowy24',
        'getin_bank',
        'ideabank',
        'ing',
        'inteligo',
        'mbank_mtransfer',
        'nest_przelew',
        'noble_pay',
        'pbac_z_ipko',
        'plus_bank',
        'santander_przelew24',
        'tmobile_usbugi_bankowe',
        'toyota_bank',
        'velobank',
        'volkswagen_bank',
      ],
      nullable: true,
      type: 'string',
    },
    reference: {
      description: 'Unique reference for this Przelewy24 payment.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by Przelewy24 directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.
Przelewy24 rarely provides this information so the attribute is usually empty.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_p24',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_paynowSchema = {
  description: '',
  properties: {
    reference: {
      description: 'Reference number associated with this PayNow payment',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_paynow',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_paypalSchema = {
  description: '',
  properties: {
    payer_email: {
      description: `Owner's email. Values are provided by PayPal directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payer_id: {
      description: 'PayPal account PayerID. This identifier uniquely identifies the PayPal customer.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payer_name: {
      description: `Owner's full name. Values provided by PayPal directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    seller_protection: {
      anyOf: [
        {
          $ref: '#/components/schemas/paypal_seller_protection',
        },
      ],
      description:
        'The level of protection offered as defined by PayPal Seller Protection for Merchants, for this transaction.',
      nullable: true,
    },
    transaction_id: {
      description: 'A unique ID generated by PayPal for this transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_paypal',
  type: 'object',
  'x-expandableFields': ['seller_protection'],
} as const;

export const payment_method_details_pixSchema = {
  description: '',
  properties: {
    bank_transaction_id: {
      description: 'Unique transaction id generated by BCB',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_pix',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_promptpaySchema = {
  description: '',
  properties: {
    reference: {
      description: 'Bill reference generated by PromptPay',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_promptpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_revolut_paySchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_revolut_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_sepa_debitSchema = {
  description: '',
  properties: {
    bank_code: {
      description: 'Bank code of bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    branch_code: {
      description: 'Branch code of bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country the bank account is located in.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four characters of the IBAN.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      description:
        'Find the ID of the mandate used for this payment under the [payment_method_details.sepa_debit.mandate](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-sepa_debit-mandate) property on the Charge. Use this mandate ID to [retrieve the Mandate](https://stripe.com/docs/api/mandates/retrieve).',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_sepa_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_sofortSchema = {
  description: '',
  properties: {
    bank_code: {
      description: 'Bank code of bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    bic: {
      description: 'Bank Identifier Code of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description: 'Two-letter ISO code representing the country the bank account is located in.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    generated_sepa_debit: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/payment_method',
        },
      ],
      description: 'The ID of the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/payment_method',
          },
        ],
      },
    },
    generated_sepa_debit_mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'The mandate for the SEPA Direct Debit PaymentMethod which was generated by this Charge.',
      nullable: true,
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    iban_last4: {
      description: 'Last four characters of the IBAN.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    preferred_language: {
      description: `Preferred language of the SOFORT authorization page that the customer is redirected to.
Can be one of \`de\`, \`en\`, \`es\`, \`fr\`, \`it\`, \`nl\`, or \`pl\``,
      enum: ['de', 'en', 'es', 'fr', 'it', 'nl', 'pl'],
      nullable: true,
      type: 'string',
    },
    verified_name: {
      description: `Owner's verified full name. Values are verified or provided by SOFORT directly
(if supported) at the time of authorization or settlement. They cannot be set or mutated.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_sofort',
  type: 'object',
  'x-expandableFields': ['generated_sepa_debit', 'generated_sepa_debit_mandate'],
} as const;

export const payment_method_details_stripe_accountSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_stripe_account',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_swishSchema = {
  description: '',
  properties: {
    fingerprint: {
      description:
        "Uniquely identifies the payer's Swish account. You can use this attribute to check whether two Swish transactions were paid for by the same payer",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    payment_reference: {
      description: 'Payer bank reference number for the payment',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    verified_phone_last4: {
      description: 'The last four digits of the Swish account phone number',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_swish',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_twintSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_twint',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_us_bank_accountSchema = {
  description: '',
  properties: {
    account_holder_type: {
      description: 'Account holder type: individual or company.',
      enum: ['company', 'individual'],
      nullable: true,
      type: 'string',
    },
    account_type: {
      description: 'Account type: checkings or savings. Defaults to checking if omitted.',
      enum: ['checking', 'savings'],
      nullable: true,
      type: 'string',
    },
    bank_name: {
      description: 'Name of the bank associated with the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      description:
        'Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'Last four digits of the bank account number.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    mandate: {
      anyOf: [
        {
          maxLength: 5000,
          type: 'string',
        },
        {
          $ref: '#/components/schemas/mandate',
        },
      ],
      description: 'ID of the mandate used to make this payment.',
      'x-expansionResources': {
        oneOf: [
          {
            $ref: '#/components/schemas/mandate',
          },
        ],
      },
    },
    payment_reference: {
      description: "Reference number to locate ACH payments with customer's bank.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    routing_number: {
      description: 'Routing number of the bank account.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_us_bank_account',
  type: 'object',
  'x-expandableFields': ['mandate'],
} as const;

export const payment_method_details_wechatSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_wechat',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_wechat_paySchema = {
  description: '',
  properties: {
    fingerprint: {
      description:
        'Uniquely identifies this particular WeChat Pay account. You can use this attribute to check whether two WeChat accounts are the same.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    transaction_id: {
      description: 'Transaction ID of this particular WeChat Pay transaction.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_details_wechat_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_details_zipSchema = {
  description: '',
  properties: {},
  title: 'payment_method_details_zip',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_domainSchema = {
  description: `A payment method domain represents a web domain that you have registered with Stripe.
Stripe Elements use registered payment method domains to control where certain payment methods are shown.

Related guides: [Payment method domains](https://stripe.com/docs/payments/payment-methods/pmd-registration).`,
  properties: {
    apple_pay: {
      $ref: '#/components/schemas/payment_method_domain_resource_payment_method_status',
    },
    created: {
      description: 'Time at which the object was created. Measured in seconds since the Unix epoch.',
      format: 'unix-time',
      type: 'integer',
    },
    domain_name: {
      description: 'The domain name that this payment method domain object represents.',
      maxLength: 5000,
      type: 'string',
    },
    enabled: {
      description:
        'Whether this payment method domain is enabled. If the domain is not enabled, payment methods that require a payment method domain will not appear in Elements.',
      type: 'boolean',
    },
    google_pay: {
      $ref: '#/components/schemas/payment_method_domain_resource_payment_method_status',
    },
    id: {
      description: 'Unique identifier for the object.',
      maxLength: 5000,
      type: 'string',
    },
    link: {
      $ref: '#/components/schemas/payment_method_domain_resource_payment_method_status',
    },
    livemode: {
      description:
        'Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.',
      type: 'boolean',
    },
    object: {
      description: "String representing the object's type. Objects of the same type share the same value.",
      enum: ['payment_method_domain'],
      type: 'string',
    },
    paypal: {
      $ref: '#/components/schemas/payment_method_domain_resource_payment_method_status',
    },
  },
  required: [
    'apple_pay',
    'created',
    'domain_name',
    'enabled',
    'google_pay',
    'id',
    'link',
    'livemode',
    'object',
    'paypal',
  ],
  title: 'PaymentMethodDomainResourcePaymentMethodDomain',
  type: 'object',
  'x-expandableFields': ['apple_pay', 'google_pay', 'link', 'paypal'],
  'x-resourceId': 'payment_method_domain',
} as const;

export const payment_method_domain_resource_payment_method_statusSchema = {
  description: 'Indicates the status of a specific payment method on a payment method domain.',
  properties: {
    status: {
      description: 'The status of the payment method on the domain.',
      enum: ['active', 'inactive'],
      type: 'string',
    },
    status_details: {
      $ref: '#/components/schemas/payment_method_domain_resource_payment_method_status_details',
    },
  },
  required: ['status'],
  title: 'PaymentMethodDomainResourcePaymentMethodStatus',
  type: 'object',
  'x-expandableFields': ['status_details'],
} as const;

export const payment_method_domain_resource_payment_method_status_detailsSchema = {
  description: 'Contains additional details about the status of a payment method for a specific payment method domain.',
  properties: {
    error_message: {
      description: 'The error message associated with the status of the payment method on the domain.',
      maxLength: 5000,
      type: 'string',
    },
  },
  required: ['error_message'],
  title: 'PaymentMethodDomainResourcePaymentMethodStatusDetails',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_epsSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank. Should be one of `arzte_und_apotheker_bank`, `austrian_anadi_bank_ag`, `bank_austria`, `bankhaus_carl_spangler`, `bankhaus_schelhammer_und_schattera_ag`, `bawag_psk_ag`, `bks_bank_ag`, `brull_kallmus_bank_ag`, `btv_vier_lander_bank`, `capital_bank_grawe_gruppe_ag`, `deutsche_bank_ag`, `dolomitenbank`, `easybank_ag`, `erste_bank_und_sparkassen`, `hypo_alpeadriabank_international_ag`, `hypo_noe_lb_fur_niederosterreich_u_wien`, `hypo_oberosterreich_salzburg_steiermark`, `hypo_tirol_bank_ag`, `hypo_vorarlberg_bank_ag`, `hypo_bank_burgenland_aktiengesellschaft`, `marchfelder_bank`, `oberbank_ag`, `raiffeisen_bankengruppe_osterreich`, `schoellerbank_ag`, `sparda_bank_wien`, `volksbank_gruppe`, `volkskreditbank_ag`, or `vr_bank_braunau`.",
      enum: [
        'arzte_und_apotheker_bank',
        'austrian_anadi_bank_ag',
        'bank_austria',
        'bankhaus_carl_spangler',
        'bankhaus_schelhammer_und_schattera_ag',
        'bawag_psk_ag',
        'bks_bank_ag',
        'brull_kallmus_bank_ag',
        'btv_vier_lander_bank',
        'capital_bank_grawe_gruppe_ag',
        'deutsche_bank_ag',
        'dolomitenbank',
        'easybank_ag',
        'erste_bank_und_sparkassen',
        'hypo_alpeadriabank_international_ag',
        'hypo_bank_burgenland_aktiengesellschaft',
        'hypo_noe_lb_fur_niederosterreich_u_wien',
        'hypo_oberosterreich_salzburg_steiermark',
        'hypo_tirol_bank_ag',
        'hypo_vorarlberg_bank_ag',
        'marchfelder_bank',
        'oberbank_ag',
        'raiffeisen_bankengruppe_osterreich',
        'schoellerbank_ag',
        'sparda_bank_wien',
        'volksbank_gruppe',
        'volkskreditbank_ag',
        'vr_bank_braunau',
      ],
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_eps',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_fpxSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank, if provided. Can be one of `affin_bank`, `agrobank`, `alliance_bank`, `ambank`, `bank_islam`, `bank_muamalat`, `bank_rakyat`, `bsn`, `cimb`, `hong_leong_bank`, `hsbc`, `kfh`, `maybank2u`, `ocbc`, `public_bank`, `rhb`, `standard_chartered`, `uob`, `deutsche_bank`, `maybank2e`, `pb_enterprise`, or `bank_of_china`.",
      enum: [
        'affin_bank',
        'agrobank',
        'alliance_bank',
        'ambank',
        'bank_islam',
        'bank_muamalat',
        'bank_of_china',
        'bank_rakyat',
        'bsn',
        'cimb',
        'deutsche_bank',
        'hong_leong_bank',
        'hsbc',
        'kfh',
        'maybank2e',
        'maybank2u',
        'ocbc',
        'pb_enterprise',
        'public_bank',
        'rhb',
        'standard_chartered',
        'uob',
      ],
      type: 'string',
    },
  },
  required: ['bank'],
  title: 'payment_method_fpx',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_giropaySchema = {
  description: '',
  properties: {},
  title: 'payment_method_giropay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_grabpaySchema = {
  description: '',
  properties: {},
  title: 'payment_method_grabpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_idealSchema = {
  description: '',
  properties: {
    bank: {
      description:
        "The customer's bank, if provided. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `n26`, `nn`, `rabobank`, `regiobank`, `revolut`, `sns_bank`, `triodos_bank`, `van_lanschot`, or `yoursafe`.",
      enum: [
        'abn_amro',
        'asn_bank',
        'bunq',
        'handelsbanken',
        'ing',
        'knab',
        'moneyou',
        'n26',
        'nn',
        'rabobank',
        'regiobank',
        'revolut',
        'sns_bank',
        'triodos_bank',
        'van_lanschot',
        'yoursafe',
      ],
      nullable: true,
      type: 'string',
    },
    bic: {
      description: "The Bank Identifier Code of the customer's bank, if the bank was provided.",
      enum: [
        'ABNANL2A',
        'ASNBNL21',
        'BITSNL2A',
        'BUNQNL2A',
        'FVLBNL22',
        'HANDNL2A',
        'INGBNL2A',
        'KNABNL2H',
        'MOYONL21',
        'NNBANL2G',
        'NTSBDEB1',
        'RABONL2U',
        'RBRBNL21',
        'REVOIE23',
        'REVOLT21',
        'SNSBNL2A',
        'TRIONL2U',
      ],
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_ideal',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_interac_presentSchema = {
  description: '',
  properties: {
    brand: {
      description: 'Card brand. Can be `interac`, `mastercard` or `visa`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    cardholder_name: {
      description:
        'The cardholder name as read from the card, in [ISO 7813](https://en.wikipedia.org/wiki/ISO/IEC_7813) format. May include alphanumeric characters, special characters and first/last name separator (`/`). In some cases, the cardholder name may not be available depending on how the issuer has configured the card. Cardholder name is typically not available on swipe or contactless payments, such as those made with Apple Pay and Google Pay.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    country: {
      description:
        "Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    exp_month: {
      description: "Two-digit number representing the card's expiration month.",
      type: 'integer',
    },
    exp_year: {
      description: "Four-digit number representing the card's expiration year.",
      type: 'integer',
    },
    fingerprint: {
      description: `Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.

*As of May 1, 2021, card fingerprint in India for Connect changed to allow two fingerprints for the same card---one for India and one for the rest of the world.*`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    funding: {
      description: 'Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    last4: {
      description: 'The last four digits of the card.',
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    networks: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_card_present_networks',
        },
      ],
      description: 'Contains information about card networks that can be used to process the payment.',
      nullable: true,
    },
    preferred_locales: {
      description: 'EMV tag 5F2D. Preferred languages specified by the integrated circuit chip.',
      items: {
        maxLength: 5000,
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    read_method: {
      description: 'How card details were read in this transaction.',
      enum: [
        'contact_emv',
        'contactless_emv',
        'contactless_magstripe_mode',
        'magnetic_stripe_fallback',
        'magnetic_stripe_track2',
      ],
      nullable: true,
      type: 'string',
    },
  },
  required: ['exp_month', 'exp_year'],
  title: 'payment_method_interac_present',
  type: 'object',
  'x-expandableFields': ['networks'],
} as const;

export const payment_method_klarnaSchema = {
  description: '',
  properties: {
    dob: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_flows_private_payment_methods_klarna_dob',
        },
      ],
      description: "The customer's date of birth, if provided.",
      nullable: true,
    },
  },
  title: 'payment_method_klarna',
  type: 'object',
  'x-expandableFields': ['dob'],
} as const;

export const payment_method_konbiniSchema = {
  description: '',
  properties: {},
  title: 'payment_method_konbini',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_linkSchema = {
  description: '',
  properties: {
    email: {
      description: "Account owner's email address.",
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
  },
  title: 'payment_method_link',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_mobilepaySchema = {
  description: '',
  properties: {},
  title: 'payment_method_mobilepay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_multibancoSchema = {
  description: '',
  properties: {},
  title: 'payment_method_multibanco',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_affirmSchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    preferred_locale: {
      description: 'Preferred language of the Affirm authorization page that the customer is redirected to.',
      maxLength: 30,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
    },
  },
  title: 'payment_method_options_affirm',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_afterpay_clearpaySchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    reference: {
      description: `An internal identifier or reference that this payment corresponds to. You must limit the identifier to 128 characters, and it can only contain letters, numbers, underscores, backslashes, and dashes.
This field differs from the statement descriptor and item name.`,
      maxLength: 5000,
      nullable: true,
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none'],
      type: 'string',
      'x-stripeBypassValidation': true,
    },
  },
  title: 'payment_method_options_afterpay_clearpay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_alipaySchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'payment_method_options_alipay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_amazon_paySchema = {
  description: '',
  properties: {
    capture_method: {
      description: "Controls when the funds will be captured from the customer's account.",
      enum: ['manual'],
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  title: 'payment_method_options_amazon_pay',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_bacs_debitSchema = {
  description: '',
  properties: {
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  title: 'payment_method_options_bacs_debit',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_bancontactSchema = {
  description: '',
  properties: {
    preferred_language: {
      description: 'Preferred language of the Bancontact authorization page that the customer is redirected to.',
      enum: ['de', 'en', 'fr', 'nl'],
      type: 'string',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session'],
      type: 'string',
    },
  },
  required: ['preferred_language'],
  title: 'payment_method_options_bancontact',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_boletoSchema = {
  description: '',
  properties: {
    expires_after_days: {
      description:
        'The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.',
      type: 'integer',
    },
    setup_future_usage: {
      description: `Indicates that you intend to make future payments with this PaymentIntent's payment method.

Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.

When processing card payments, Stripe also uses \`setup_future_usage\` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).`,
      enum: ['none', 'off_session', 'on_session'],
      type: 'string',
    },
  },
  required: ['expires_after_days'],
  title: 'payment_method_options_boleto',
  type: 'object',
  'x-expandableFields': [],
} as const;

export const payment_method_options_card_installmentsSchema = {
  description: '',
  properties: {
    available_plans: {
      description: 'Installment plans that may be selected for this PaymentIntent.',
      items: {
        $ref: '#/components/schemas/payment_method_details_card_installments_plan',
      },
      nullable: true,
      type: 'array',
    },
    enabled: {
      description: 'Whether Installments are enabled for this PaymentIntent.',
      type: 'boolean',
    },
    plan: {
      anyOf: [
        {
          $ref: '#/components/schemas/payment_method_details_card_installments_plan',
        },
      ],
      description: 'Installment plan selected for this PaymentIntent.',
      nullable: true,
    },
  },
  required: ['enabled'],
  title: 'payment_method_options_card_installments',
  type: 'object',
  'x-expandableFields': ['available_plans', 'plan'],
} as const;

export const payment_method_options_card_mandate_optionsSchema = {
  description: '',
  properties: {
    amount: {
      description: 'Amount to be charged for future payments.',
      type: 'integer',
    },
    amount_type: {
      description:
        'One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.',
      enum: ['fixed', 'maximum'],
      type: 'string',
    },
    description: {
      description: 'A description of the mandate or subscription that is meant to be displayed to the customer.',
      maxLength: 200,
      nullable: true,
      type: 'string',
    },
    end_date: {
      description:
        'End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.',
      format: 'unix-time',
      nullable: true,
      type: 'integer',
    },
    interval: {
      description: 'Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.',
      enum: ['day', 'month', 'sporadic', 'week',