// Generated by ts-to-zod
import { z } from 'zod';

export const metadataSchema = z.object({
  count: z.number().optional(),
  next: z.string().optional(),
  prev: z.string().optional(),
  self: z.string().optional(),
});

export const abbvMessageSchema = z.object({
  clicks_count: z.number(),
  from_email: z.string(),
  last_event_time: z.string(),
  msg_id: z.string(),
  opens_count: z.number(),
  status: z.union([z.literal('processed'), z.literal('delivered'), z.literal('not_delivered')]),
  subject: z.string(),
  to_email: z.string(),
});

export const statusSchema = z.union([z.literal('processed'), z.literal('delivered'), z.literal('not_delivered')]);

export const abtestSummarySchema = z
  .object({
    duration: z.string(),
    expiration_date: z.string().nullable(),
    test_percentage: z.number(),
    type: z.union([z.literal('subject'), z.literal('content')]),
    winner_criteria: z.union([z.literal('open'), z.literal('click'), z.literal('manual')]),
    winner_selected_at: z.string().nullable(),
    winning_template_id: z.string(),
  })
  .nullable();

export const typeSchema = z.union([z.literal('subject'), z.literal('content')]);

export const winnerCriteriaSchema = z.union([z.literal('open'), z.literal('click'), z.literal('manual')]);

export const advancedStatsClicksSchema = z.object({
  clicks: z.number().optional(),
  unique_clicks: z.number().optional(),
});

export const advancedStatsOpensSchema = z.object({
  opens: z.number().optional(),
  unique_opens: z.number().optional(),
});

export const advancedStatsClicksOpensSchema = advancedStatsClicksSchema.and(advancedStatsOpensSchema);

export const segmentStatusResponseSchema = z.object({
  error_message: z.string().optional(),
  query_validation: z.string(),
});

export const apiErrorSchema = z.object({
  error_id: z.string(),
  field: z.string(),
  message: z.string(),
});

export const apiErrorsSchema = z.object({
  errors: z.array(apiErrorSchema).optional(),
});

export const apiKeyNameIdSchema = z.object({
  api_key_id: z.string().optional(),
  name: z.string().optional(),
});

export const apiKeyNameIdScopesSchema = z
  .object({
    scopes: z.array(z.string()).optional(),
  })
  .and(apiKeyNameIdSchema);

export const authenticationDomainSchema = z.object({
  automatic_security: z.boolean(),
  custom_spf: z.boolean(),
  default: z.boolean(),
  dns: z.object({
    dkim1: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
    dkim2: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
    mail_cname: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
  }),
  domain: z.string(),
  id: z.number(),
  ips: z.array(z.string()),
  legacy: z.boolean(),
  subdomain: z.string(),
  user_id: z.number(),
  username: z.string(),
  valid: z.boolean(),
});

export const linkTrackingMetadataSchema = z.object({
  count: z.number().optional(),
  next: z.string().optional(),
  prev: z.string().optional(),
  self: z.string().optional(),
});

export const metricsSchema = z.object({
  bounce_drops: z.number(),
  bounces: z.number(),
  clicks: z.number(),
  delivered: z.number(),
  invalid_emails: z.number(),
  opens: z.number(),
  requests: z.number(),
  spam_report_drops: z.number(),
  spam_reports: z.number(),
  unique_clicks: z.number(),
  unique_opens: z.number(),
  unsubscribes: z.number(),
});

export const blocksResponseSchema = z.array(
  z.object({
    created: z.number(),
    email: z.string(),
    reason: z.string(),
    status: z.string(),
  }),
);

export const bounceResponseSchema = z.object({
  created: z.number().optional(),
  email: z.string().optional(),
  reason: z.string().optional(),
  status: z.string().optional(),
});

export const campaignRequestSchema = z.object({
  categories: z.array(z.string()).optional().nullable(),
  custom_unsubscribe_url: z.string().optional().nullable(),
  editor: z.union([z.literal('code'), z.literal('design')]).optional(),
  html_content: z.string().optional().nullable(),
  ip_pool: z.string().optional().nullable(),
  list_ids: z.array(z.number()).optional().nullable(),
  plain_content: z.string().optional().nullable(),
  segment_ids: z.array(z.number()).optional().nullable(),
  sender_id: z.number().optional().nullable(),
  subject: z.string().optional().nullable(),
  suppression_group_id: z.number().optional().nullable(),
  title: z.string(),
});

export const editorSchema = z.union([z.literal('code'), z.literal('design')]);

export const campaignResponseSchema = campaignRequestSchema.and(
  z.object({
    id: z.number().optional(),
    status: z.string(),
  }),
);

export const categoryStatsSchema = z.object({
  date: z.string(),
  stats: z
    .array(
      z.object({
        metrics: z
          .object({
            blocks: z.number(),
            bounce_drops: z.number(),
            bounces: z.number(),
            clicks: z.number(),
            deferred: z.number(),
            delivered: z.number(),
            invalid_emails: z.number(),
            opens: z.number(),
            processed: z.number(),
            requests: z.number(),
            spam_report_drops: z.number(),
            spam_reports: z.number(),
            unique_clicks: z.number(),
            unique_opens: z.number(),
            unsubscribe_drops: z.number(),
            unsubscribes: z.number(),
          })
          .optional(),
        name: z.string().optional(),
        type: z.string(),
      }),
    )
    .optional(),
});

export const ccBccEmailObjectSchema = z.object({
  email: z.string(),
  name: z.string().optional(),
});

export const clickTrackingSchema = z.object({
  enable_text: z.boolean(),
  enabled: z.boolean(),
});

export const selfmetadataSchema = z.object({
  self: z.string().optional(),
});

export const customFieldsByNameSchema = z.record(z.unknown());

export const contactDetails2Schema = z.object({
  _metadata: selfmetadataSchema.optional(),
  address_line_1: z.string().optional(),
  address_line_2: z.string().optional(),
  alternate_emails: z.array(z.string()).optional().nullable(),
  city: z.string().optional(),
  country: z.string().optional(),
  created_at: z.string(),
  custom_fields: z.record(z.unknown()).optional(),
  email: z.string().optional(),
  facebook: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string(),
  last_name: z.string().optional(),
  line: z.string().optional(),
  list_ids: z.array(z.string()),
  phone_number: z.string().optional(),
  postal_code: z.string().optional(),
  segment_ids: z.array(z.string()).optional(),
  state_province_region: z.string().optional(),
  unique_name: z.string().optional(),
  updated_at: z.string(),
  whatsapp: z.string().optional(),
});

export const contactDetails3Schema = z.object({
  _metadata: selfmetadataSchema.optional(),
  address_line_1: z.string().optional(),
  address_line_2: z.string().optional(),
  alternate_emails: z.array(z.string()).optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  created_at: z.string(),
  custom_fields: z.record(z.unknown()).optional(),
  email: z.string().optional(),
  facebook: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string(),
  last_name: z.string().optional(),
  line: z.string().optional(),
  list_ids: z.array(z.string()),
  phone_number: z.string().optional(),
  postal_code: z.string().optional(),
  segment_ids: z.array(z.string()),
  state_province_region: z.string().optional(),
  unique_name: z.string().optional(),
  updated_at: z.string(),
  whatsapp: z.string().optional(),
});

export const contactExportSchema = z.object({
  _metadata: metadataSchema.optional(),
  completed_at: z.string().optional(),
  contact_count: z.number().optional(),
  created_at: z.string(),
  expires_at: z.string(),
  id: z.string(),
  message: z.string().optional(),
  status: z.union([z.literal('pending'), z.literal('ready'), z.literal('failure')]),
  updated_at: z.string(),
  urls: z.array(z.string()).optional(),
});

export const status2Schema = z.union([z.literal('pending'), z.literal('ready'), z.literal('failure')]);

export const contactImportSchema = z.object({
  finished_at: z.string().optional(),
  id: z.string().optional(),
  job_type: z.string().optional(),
  results: z
    .object({
      created_count: z.number().optional(),
      deleted_count: z.number().optional(),
      errored_count: z.number().optional(),
      errors_url: z.string().optional(),
      requested_count: z.number().optional(),
      updated_count: z.number().optional(),
    })
    .optional(),
  started_at: z.string().optional(),
  status: z.string().optional(),
});

export const customFieldsByIdSchema = z.record(z.unknown());

export const contactResponseSchema = z.object({
  address_line_1: z.string(),
  address_line_2: z.string(),
  alternate_emails: z.array(z.string()),
  city: z.string(),
  country: z.string(),
  custom_fields: z.object({
    '': z.string().optional(),
    custom_field_name1: z.string().optional(),
    custom_field_name2: z.string().optional(),
  }),
  email: z.string(),
  first_name: z.string(),
  id: z.string(),
  last_name: z.string(),
  list_ids: z.array(z.string()).optional(),
  postal_code: z.number(),
  segment_ids: z.array(z.string()).optional(),
  state_province_region: z.string(),
});

export const contactSummarySchema = z.object({
  _metadata: selfmetadataSchema.optional(),
  created_at: z.number(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string(),
  last_name: z.string().optional(),
  list_ids: z.array(z.string()),
  updated_at: z.number(),
});

export const contactdbCustomFieldSchema = z.object({
  name: z.string().optional(),
  type: z.union([z.literal('date'), z.literal('text'), z.literal('number')]).optional(),
});

export const type2Schema = z.union([z.literal('date'), z.literal('text'), z.literal('number')]);

export const contactdbCustomFieldWithIdSchema = contactdbCustomFieldSchema.and(
  z.object({
    id: z.number().optional(),
  }),
);

export const contactdbCustomFieldWithIdValueSchema = contactdbCustomFieldWithIdSchema.and(
  z.object({
    value: z.string().optional().nullable(),
  }),
);

export const contactdbListSchema = z.object({
  id: z.number(),
  name: z.string(),
  recipient_count: z.number(),
});

export const contactdbRecipientSchema = z.object({
  recipients: z
    .array(
      z.object({
        created_at: z.number().optional(),
        custom_fields: z.array(contactdbCustomFieldWithIdValueSchema).optional(),
        email: z.string(),
        first_name: z.string().optional().nullable(),
        id: z.string().optional(),
        last_clicked: z.number().optional().nullable(),
        last_emailed: z.number().optional().nullable(),
        last_name: z.string().optional().nullable(),
        last_opened: z.number().optional().nullable(),
        updated_at: z.number().optional(),
      }),
    )
    .optional(),
});

export const contactdbRecipientCountSchema = z.object({
  recipient_count: z.number(),
});

export const contactdbRecipientResponseSchema = z.object({
  error_count: z.number(),
  error_indices: z.array(z.number()).optional(),
  errors: z
    .array(
      z.object({
        error_indices: z.array(z.number()).optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
  new_count: z.number(),
  persisted_recipients: z.array(z.string()),
  updated_count: z.number(),
});

export const contactdbSegmentsConditionsSchema = z.object({
  and_or: z.union([z.literal('and'), z.literal('or'), z.literal('')]).optional(),
  field: z.string(),
  operator: z.union([z.literal('eq'), z.literal('ne'), z.literal('lt'), z.literal('gt'), z.literal('contains')]),
  value: z.string(),
});

export const andOrSchema = z.union([z.literal('and'), z.literal('or'), z.literal('')]);

export const operatorSchema = z.union([
  z.literal('eq'),
  z.literal('ne'),
  z.literal('lt'),
  z.literal('gt'),
  z.literal('contains'),
]);

export const contactdbSegmentsSchema = z.object({
  conditions: z.array(contactdbSegmentsConditionsSchema),
  list_id: z.number().optional(),
  name: z.string(),
  recipient_count: z.number().optional(),
});

export const contactsSchema = z.object({
  address: z.string().optional(),
  address2: z.record(z.unknown()).optional(),
  city: z.string().optional(),
  company: z.string().optional(),
  country: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  phone: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const createIntegrationRequestSchema = z.object({
  completed_integration: z.boolean().optional(),
  enabled: z.boolean(),
  entity_id: z.string(),
  name: z.string(),
  signin_url: z.string(),
  signout_url: z.string(),
});

export const credentialsSchema = z.object({
  permissions: z
    .object({
      api: z.string().optional(),
      mail: z.string().optional(),
      web: z.string().optional(),
    })
    .optional(),
  username: z.string().optional(),
});

export const customFieldDefinitionsResponseSchema = z.object({
  field_type: z.union([z.literal('Text'), z.literal('Number'), z.literal('Date')]),
  id: z.string(),
  name: z.string(),
});

export const fieldTypeSchema = z.union([z.literal('Text'), z.literal('Number'), z.literal('Date')]);

export const designDuplicateInputSchema = z.object({
  editor: z.union([z.literal('code'), z.literal('design')]).optional(),
  name: z.string().optional(),
});

export const designCommonFieldsSchema = designDuplicateInputSchema.and(
  z.object({
    categories: z.array(z.string()).optional(),
    generate_plain_content: z.boolean().optional(),
    subject: z.string().optional(),
  }),
);

export const designOutputSummarySchema = z
  .object({
    created_at: z.string().optional(),
    id: z.string().optional(),
    thumbnail_url: z.string().optional(),
    updated_at: z.string().optional(),
  })
  .and(designDuplicateInputSchema)
  .and(designCommonFieldsSchema);

export const designInputSchema = designDuplicateInputSchema.and(designCommonFieldsSchema).and(
  z.object({
    html_content: z.string(),
    plain_content: z.string().optional(),
  }),
);

export const domainAuthentication200ResponseSchema = z.array(
  authenticationDomainSchema.and(
    z.object({
      last_validation_attempt_at: z.number().optional(),
      subusers: z
        .array(
          z.object({
            user_id: z.number().optional(),
            username: z.string().optional(),
          }),
        )
        .optional(),
    }),
  ),
);

export const domainAuthenticationDomainSpfSchema = z.object({
  automatic_security: z.boolean(),
  custom_spf: z.boolean(),
  default: z.boolean(),
  dns: z.object({
    dkim: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
    domain_spf: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
    mail_server: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
    subdomain_spf: z.object({
      data: z.string(),
      host: z.string(),
      type: z.string(),
      valid: z.boolean(),
    }),
  }),
  domain: z.string(),
  id: z.number(),
  ips: z.array(z.unknown()),
  legacy: z.boolean(),
  subdomain: z.string().optional(),
  user_id: z.number(),
  username: z.string(),
  valid: z.boolean(),
});

export const emailActivityResponseCommonFieldsSchema = z.object({
  from_email: z.string().optional(),
  msg_id: z.string().optional(),
  status: z.union([z.literal('processed'), z.literal('delivered'), z.literal('not delivered')]).optional(),
  subject: z.string().optional(),
  to_email: z.string().optional(),
});

export const status3Schema = z.union([z.literal('processed'), z.literal('delivered'), z.literal('not delivered')]);

export const enforcedTlsRequestResponseSchema = z.object({
  require_tls: z.boolean().optional(),
  require_valid_cert: z.boolean().optional(),
});

export const errorSchema = z.object({
  error_id: z.string().optional(),
  field: z.string().optional(),
  message: z.string(),
  parameter: z.string().optional(),
});

export const errorsSchema = z.object({
  errors: z.array(
    z.object({
      field: z.string().optional().nullable(),
      message: z.string().nullable(),
      parameter: z.string(),
    }),
  ),
});

export const errorsSegV2Schema = z.object({
  errors: z.array(
    z.object({
      field: z.string(),
      message: z.string(),
    }),
  ),
});

export const eventWebhookResponseSchema = z.object({
  bounce: z.boolean(),
  click: z.boolean(),
  deferred: z.boolean(),
  delivered: z.boolean(),
  dropped: z.boolean(),
  enabled: z.boolean(),
  group_resubscribe: z.boolean(),
  group_unsubscribe: z.boolean(),
  oauth_client_id: z.string().optional(),
  oauth_token_url: z.string().optional(),
  open: z.boolean(),
  processed: z.boolean(),
  spam_report: z.boolean(),
  unsubscribe: z.boolean(),
  url: z.string(),
});

export const eventWebhookUpdateOauthRequestSchema = z.object({
  bounce: z.boolean(),
  click: z.boolean(),
  deferred: z.boolean(),
  delivered: z.boolean(),
  dropped: z.boolean(),
  enabled: z.boolean(),
  group_resubscribe: z.boolean(),
  group_unsubscribe: z.boolean(),
  oauth_client_id: z.string().optional(),
  oauth_client_secret: z.string().optional(),
  oauth_token_url: z.string().optional(),
  open: z.boolean(),
  processed: z.boolean(),
  spam_report: z.boolean(),
  unsubscribe: z.boolean(),
  url: z.string(),
});

export const fromEmailObjectSchema = z.object({
  email: z.string(),
  name: z.string().optional(),
});

export const segmentSummarySchema = z.object({
  contacts_count: z.number(),
  created_at: z.string(),
  id: z.string(),
  name: z.string().optional(),
  next_sample_update: z.string().optional(),
  parent_list_id: z.string().optional(),
  sample_updated_at: z.string(),
  updated_at: z.string(),
});

export const segmentWriteV2Schema = z.object({
  name: z.string(),
  parent_list_ids: z.array(z.string()).optional(),
  query_dsl: z.string(),
});

export const globalEmptyRequestSchema = z.unknown();

export const globalErrorResponseSchemaSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional().nullable(),
        help: z.record(z.unknown()).optional(),
        message: z.string(),
      }),
    )
    .optional(),
  id: z.string().optional(),
});

export const globalIdSchema = z.number();

export const googleAnalyticsSettingsSchema = z.object({
  enabled: z.boolean().optional(),
  utm_campaign: z.string().optional(),
  utm_content: z.string().optional(),
  utm_medium: z.string().optional(),
  utm_source: z.string().optional(),
  utm_term: z.string().optional(),
});

export const invalidEmailSchema = z.object({
  created: z.number().optional(),
  email: z.string().optional(),
  reason: z.string().optional(),
});

export const ipAccessResponseSchema = z.object({
  result: z
    .array(
      z.object({
        created_at: z.number().optional(),
        id: z.number().optional(),
        ip: z.string().optional(),
        updated_at: z.number().optional(),
      }),
    )
    .optional(),
});

export const ipPoolSchema = z.object({
  name: z.string(),
});

export const ipPoolResponseSchema = z.object({
  name: z.string().optional(),
});

export const ipWarmupResponseSchema = z.array(
  z.object({
    ip: z.string(),
    start_date: z.number(),
  }),
);

export const linkSchema = z.object({
  href: z.string().optional(),
  rel: z.string().optional(),
});

export const linkBranding200ResponseSchema = z.object({
  default: z.boolean(),
  dns: z.object({
    domain_cname: z.object({
      data: z.string(),
      host: z.string(),
      type: z.union([z.literal('cname'), z.literal('txt'), z.literal('mx')]),
      valid: z.boolean(),
    }),
    owner_cname: z
      .object({
        data: z.string(),
        host: z.string(),
        type: z.union([z.literal('cname'), z.literal('txt'), z.literal('mx')]).optional(),
        valid: z.boolean(),
      })
      .optional(),
  }),
  domain: z.string(),
  id: z.number(),
  legacy: z.boolean(),
  subdomain: z.string().optional(),
  user_id: z.number(),
  username: z.string(),
  valid: z.boolean(),
});

export const type3Schema = z.union([z.literal('cname'), z.literal('txt'), z.literal('mx')]);

export const listSchema = z.object({
  _metadata: selfmetadataSchema.optional(),
  contact_count: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const mailBatchIdSchema = z.object({
  batch_id: z.string(),
});

export const mailSettingsAddressWhitelabelSchema = z.object({
  enabled: z.boolean().optional(),
  list: z.array(z.string()).optional(),
});

export const mailSettingsBouncePurgeSchema = z.object({
  enabled: z.boolean().optional(),
  hard_bounces: z.number().optional().nullable(),
  soft_bounces: z.number().optional().nullable(),
});

export const mailSettingsFooterSchema = z.object({
  enabled: z.boolean().optional(),
  html_content: z.string().optional(),
  plain_content: z.string().optional(),
});

export const mailSettingsForwardBounceSchema = z.object({
  email: z.string().optional().nullable(),
  enabled: z.boolean().optional(),
});

export const mailSettingsForwardSpamSchema = z.object({
  email: z.string().optional(),
  enabled: z.boolean().optional(),
});

export const mailSettingsPatchSchema = z.object({
  email: z.string().optional(),
  enabled: z.boolean().optional(),
});

export const mailSettingsTemplateSchema = z.object({
  enabled: z.boolean().optional(),
  html_content: z.string().optional(),
});

export const makoEventSchema = z.object({
  attempt_num: z.number().optional(),
  bounce_type: z.union([z.literal('bounced'), z.literal('blocked'), z.literal('expired')]),
  event_name: z.union([
    z.literal('bounced'),
    z.literal('opened'),
    z.literal('clicked'),
    z.literal('processed'),
    z.literal('dropped'),
    z.literal('delivered'),
    z.literal('deferred'),
    z.literal('spam_report'),
    z.literal('unsubscribe'),
    z.literal('group_unsubscribe'),
    z.literal('group_resubscribe'),
  ]),
  http_user_agent: z.string(),
  mx_server: z.string(),
  processed: z.string(),
  reason: z.string().optional(),
  url: z.string(),
});

export const bounceTypeSchema = z.union([z.literal('bounced'), z.literal('blocked'), z.literal('expired')]);

export const eventNameSchema = z.union([
  z.literal('bounced'),
  z.literal('opened'),
  z.literal('clicked'),
  z.literal('processed'),
  z.literal('dropped'),
  z.literal('delivered'),
  z.literal('deferred'),
  z.literal('spam_report'),
  z.literal('unsubscribe'),
  z.literal('group_unsubscribe'),
  z.literal('group_resubscribe'),
]);

export const messageSchema = z.object({
  api_key_id: z.string(),
  asm_group_id: z.number(),
  categories: z.array(z.string()),
  events: z.array(
    z.object({
      attempt_num: z.number().optional(),
      bounce_type: z.union([z.literal('bounced'), z.literal('blocked'), z.literal('expired')]),
      event_name: z.union([
        z.literal('bounced'),
        z.literal('opened'),
        z.literal('clicked'),
        z.literal('processed'),
        z.literal('dropped'),
        z.literal('delivered'),
        z.literal('deferred'),
        z.literal('spam_report'),
        z.literal('unsubscribe'),
        z.literal('group_unsubscribe'),
        z.literal('group_resubscribe'),
      ]),
      http_user_agent: z.string(),
      mx_server: z.string(),
      processed: z.string(),
      reason: z.string().optional(),
      url: z.string(),
    }),
  ),
  from_email: z.string(),
  msg_id: z.string(),
  originating_ip: z.string(),
  outbound_ip: z.string(),
  outbound_ip_type: z.union([z.literal('dedicated'), z.literal('shared')]),
  status: z.union([z.literal('processed'), z.literal('not delivered'), z.literal('delivered')]),
  subject: z.string(),
  teammate: z.string(),
  template_id: z.string(),
  to_email: z.string(),
  unique_args: z.string(),
});

export const outboundIpTypeSchema = z.union([z.literal('dedicated'), z.literal('shared')]);

export const monitorSchema = z.object({
  email: z.string(),
  frequency: z.number(),
});

export const parametertraitAuthorizationHeaderAuthorizationSchema = z.string();

export const parametertraitAutomationQueryParamsGroupBySchema = z.array(z.literal('step_id'));

export const parametertraitAutomationQueryParamsStepIdsSchema = z.array(z.string());

export const parametertraitBaseParamsAggregatedBySchema = z.union([z.literal('day'), z.literal('total')]);

export const parametertraitBaseParamsEndDateSchema = z.string();

export const parametertraitBaseParamsStartDateSchema = z.string();

export const parametertraitBaseParamsTimezoneSchema = z.string();

export const parametertraitDesignsQueryStringsPageSizeSchema = z.number();

export const parametertraitDesignsQueryStringsPageTokenSchema = z.string();

export const parametertraitDesignsQueryStringsSummarySchema = z.boolean();

export const parametertraitOnBehalfOfSubuserOnBehalfOfSchema = z.string();

export const parametertraitPaginationPageSizeSchema = z.number();

export const parametertraitPaginationPageTokenSchema = z.string();

export const parametertraitSinglesendQueryParamsGroupBySchema = z.array(
  z.union([z.literal('ab_variation'), z.literal('ab_phase')]),
);

export const parametertraitSinglesendQueryParams2AbPhaseIdSchema = z.union([z.literal('test'), z.literal('send')]);

export const parametertraitSinglesendQueryParams2AbVariationIdSchema = z.string();

export const parametertraitSinglesendQueryParams2GroupBySchema = z.array(
  z.union([z.literal('ab_variation'), z.literal('ab_phase')]),
);

export const parametertraitStatsAdvancedQueryStringsLimitOffsetAggregatedBySchema = z.union([
  z.literal('day'),
  z.literal('week'),
  z.literal('month'),
]);

export const parametertraitStatsAdvancedQueryStringsLimitOffsetEndDateSchema = z.string();

export const parametertraitStatsAdvancedQueryStringsLimitOffsetLimitSchema = z.number();

export const parametertraitStatsAdvancedQueryStringsLimitOffsetOffsetSchema = z.number();

export const parametertraitStatsAdvancedQueryStringsLimitOffsetStartDateSchema = z.string();

export const parametertraitStatsAdvancedStatsBaseQueryStringsAggregatedBySchema = z.union([
  z.literal('day'),
  z.literal('week'),
  z.literal('month'),
]);

export const parametertraitStatsAdvancedStatsBaseQueryStringsEndDateSchema = z.string();

export const parametertraitStatsAdvancedStatsBaseQueryStringsStartDateSchema = z.string();

export const parseSettingSchema = z.object({
  hostname: z.string().optional(),
  send_raw: z.boolean().optional(),
  spam_check: z.boolean().optional(),
  url: z.string().optional(),
});

export const partnerSettingsNewRelicSchema = z.object({
  enable_subuser_statistics: z.boolean().optional(),
  enabled: z.boolean(),
  license_key: z.string(),
});

export const replyToEmailObjectSchema = z.object({
  email: z.string(),
  name: z.string().optional(),
});

export const reservedFieldDefinitionsResponseSchema = z.array(
  z.object({
    field_type: z.union([z.literal('Text'), z.literal('Number'), z.literal('Date')]).optional(),
    name: z.string().optional(),
    read_only: z.boolean().optional(),
  }),
);

export const reverseDnsSchema = z.object({
  a_record: z.object({
    data: z.string(),
    host: z.string(),
    type: z.string(),
    valid: z.boolean(),
  }),
  domain: z.string(),
  id: z.number(),
  ip: z.string(),
  last_validation_attempt_at: z.number().optional(),
  legacy: z.boolean(),
  rdns: z.string(),
  subdomain: z.string().optional(),
  users: z.array(
    z.object({
      user_id: z.number(),
      username: z.string(),
    }),
  ),
  valid: z.boolean(),
});

export const segmentQueryJsonSchema = z.object({
  contacts: z
    .object({
      l: z
        .object({
          l: z
            .object({
              l: z
                .object({
                  t: z.string().optional(),
                  v: z.string().optional(),
                })
                .optional(),
              op: z.string().optional(),
              r: z
                .object({
                  t: z.string().optional(),
                  v: z.string().optional(),
                })
                .optional(),
            })
            .optional(),
          op: z.string().optional(),
          r: z
            .object({
              l: z
                .object({
                  args: z
                    .array(
                      z.object({
                        t: z.string().optional(),
                        v: z.string().optional(),
                      }),
                    )
                    .optional(),
                  t: z.string().optional(),
                  v: z.string().optional(),
                })
                .optional(),
              op: z.string().optional(),
              r: z
                .object({
                  t: z.string().optional(),
                  v: z.string().optional(),
                })
                .optional(),
            })
            .optional(),
        })
        .optional(),
      op: z.string().optional(),
      r: z
        .object({
          l: z
            .object({
              t: z.string().optional(),
              v: z.string().optional(),
            })
            .optional(),
          op: z.string().optional(),
          r: z
            .object({
              t: z.string().optional(),
              v: z.array(z.string()).optional(),
            })
            .optional(),
        })
        .optional(),
    })
    .optional(),
});

export const segmentResponseSchema = z.object({
  contacts_count: z.number(),
  contacts_sample: z.array(contactResponseSchema),
  created_at: z.string(),
  id: z.string(),
  name: z.string(),
  next_sample_update: z.string(),
  parent_list_ids: z.array(z.string()),
  query_dsl: z.string(),
  query_version: z.string(),
  sample_updated_at: z.string(),
  status: segmentStatusResponseSchema,
  updated_at: z.string(),
});

export const segmentSummaryV2Schema = z.object({
  results: z.array(segmentSummarySchema).optional(),
});

export const segmentUpdateSchema = z.object({
  name: z.string().optional(),
  query_dsl: z.string().optional(),
});

export const segmentWriteSchema = z.object({
  name: z.string(),
  query_dsl: z.string(),
});

export const senderIdRequestSchema = z.object({
  address: z.string().optional(),
  address_2: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  from: z
    .object({
      email: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  nickname: z.string().optional(),
  reply_to: z
    .object({
      email: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const senderIDSchema = senderIdRequestSchema
  .and(
    z.object({
      created_at: z.number().optional(),
      id: z.number().optional(),
      locked: z.boolean().optional(),
      updated_at: z.number().optional(),
      verified: z.boolean().optional(),
    }),
  )
  .and(z.record(z.unknown()));

export const sendersIdRequestBodySchema = z.object({
  address: z.string(),
  address_2: z.string().optional(),
  city: z.string(),
  country: z.string(),
  from: z.object({
    email: z.string(),
    name: z.string(),
  }),
  nickname: z.string(),
  reply_to: z
    .object({
      email: z.string(),
      name: z.string().optional(),
    })
    .optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const singleContactRequestSchema = z.object({
  contact: z
    .object({
      address_line_1: z.string().optional(),
      address_line_2: z.string().optional(),
      alternate_emails: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      custom_fields: z
        .object({
          custom_field_name1: z.string().optional(),
          custom_field_name2: z.string().optional(),
        })
        .optional(),
      first_name: z.string().optional(),
      last_name: z.string().optional(),
      postal_code: z.string().optional(),
      primary_email: z.string().optional(),
      state_province_region: z.string().optional(),
    })
    .optional(),
  list_ids: z.array(z.string()).optional(),
});

export const singlesendRequestSchema = z.object({
  categories: z.array(z.string()).optional(),
  email_config: z
    .object({
      custom_unsubscribe_url: z.string().optional().nullable(),
      design_id: z.string().optional(),
      editor: z.union([z.literal('code'), z.literal('design')]).optional(),
      generate_plain_content: z.boolean().optional(),
      html_content: z.string().optional(),
      ip_pool: z.string().optional().nullable(),
      plain_content: z.string().optional(),
      sender_id: z.number().optional().nullable(),
      subject: z.string().optional(),
      suppression_group_id: z.number().optional().nullable(),
    })
    .optional(),
  name: z.string(),
  send_at: z.string().optional(),
  send_to: z
    .object({
      all: z.boolean().optional(),
      list_ids: z.array(z.string()).optional(),
      segment_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const singlesendResponseSchema = singlesendRequestSchema.and(
  z.object({
    created_at: z.string(),
    id: z.string(),
    status: z.union([z.literal('draft'), z.literal('scheduled'), z.literal('triggered')]),
    updated_at: z.string().optional(),
    warnings: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
          warning_id: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const status4Schema = z.union([z.literal('draft'), z.literal('scheduled'), z.literal('triggered')]);

export const singlesendResponseShortSchema = z.object({
  abtest: abtestSummarySchema,
  categories: z.array(z.string()),
  created_at: z.string(),
  id: z.string(),
  is_abtest: z.boolean(),
  name: z.string(),
  send_at: z.string().optional(),
  status: z.union([z.literal('draft'), z.literal('scheduled'), z.literal('triggered')]),
  updated_at: z.string(),
});

export const singlesendScheduleSchema = z.object({
  send_at: z.string(),
  status: z.union([z.literal('draft'), z.literal('scheduled'), z.literal('triggered')]).optional(),
});

export const singlesendSearchSchema = z.object({
  categories: z.array(z.string()).optional(),
  name: z.string().optional(),
  status: z.array(z.union([z.literal('draft'), z.literal('scheduled'), z.literal('triggered')])).optional(),
});

export const singlesendWarningSchema = z.object({
  warnings: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
        warning_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const singlesendsLinkStatsResponseSchema = z.object({
  _metadata: linkTrackingMetadataSchema,
  results: z.array(
    z.object({
      ab_phase: z.union([z.literal('send'), z.literal('test'), z.literal('all')]),
      ab_variation: z.string(),
      clicks: z.number(),
      url: z.string(),
      url_location: z.number().optional(),
    }),
  ),
  total_clicks: z.number().optional(),
});

export const singlesendsResponseSchema = z.object({
  _metadata: metadataSchema,
  results: z.array(
    z.object({
      ab_phase: z.union([z.literal('send'), z.literal('test'), z.literal('all')]),
      ab_variation: z.string(),
      aggregation: z.string().optional(),
      id: z.string(),
      stats: metricsSchema.optional(),
    }),
  ),
});

export const spamReportsResponseSchema = z.array(
  z.object({
    created: z.number(),
    email: z.string(),
    ip: z.string(),
  }),
);

export const ssoCertificateBodySchema = z.object({
  id: z.number().optional(),
  intergration_id: z.string().optional(),
  not_after: z.number().optional(),
  not_before: z.number().optional(),
  public_certificate: z.string().optional(),
});

export const ssoErrorResponseSchema = z.array(
  z.object({
    error_id: z.string().optional(),
    field: z.string().optional().nullable(),
    message: z.string().optional(),
  }),
);

export const ssoIntegrationSchema = createIntegrationRequestSchema.and(
  z.object({
    audience_url: z.string().optional(),
    id: z.string().optional(),
    last_updated: z.number(),
    single_signon_url: z.string().optional(),
  }),
);

export const ssoTeammateCommonFieldsSchema = z.object({
  email: z.string(),
  first_name: z.string(),
  is_admin: z.boolean().optional(),
  is_read_only: z.boolean().optional(),
  last_name: z.string(),
});

export const ssoTeammateRequestSchema = ssoTeammateCommonFieldsSchema.and(
  z.object({
    scopes: z.array(z.string()),
  }),
);

export const ssoTeammateResponseSchema = ssoTeammateCommonFieldsSchema.and(
  z.object({
    is_sso: z.boolean().optional(),
    username: z.string().optional(),
  }),
);

export const ssoTeammatesPatchResponseSchema = ssoTeammateResponseSchema.and(
  z.object({
    address: z.string().optional(),
    address2: z.string().optional(),
    city: z.string().optional(),
    company: z.string().optional(),
    country: z.string().optional(),
    email: z.string().optional(),
    phone: z.string().optional(),
    scopes: z.array(z.string()).optional(),
    state: z.string().optional(),
    user_type: z.union([z.literal('admin'), z.literal('owner'), z.literal('teammate')]).optional(),
    website: z.string().optional(),
    zip: z.string().optional(),
  }),
);

export const userTypeSchema = z.union([z.literal('admin'), z.literal('owner'), z.literal('teammate')]);

export const statsAdvancedGlobalStatsSchema = advancedStatsClicksOpensSchema.and(
  z.object({
    blocks: z.number().optional(),
    bounce_drops: z.number().optional(),
    bounces: z.number().optional(),
    deferred: z.number().optional(),
    delivered: z.number().optional(),
    invalid_emails: z.number().optional(),
    processed: z.number().optional(),
    requests: z.number().optional(),
    spam_report_drops: z.number().optional(),
    spam_reports: z.number().optional(),
    unsubscribe_drops: z.number().optional(),
    unsubscribes: z.number().optional(),
  }),
);

export const statsAdvancedStatsBaseSchemaSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: z.record(z.unknown()).optional(),
        }),
      )
      .optional(),
  }),
);

export const subscriptionTrackingSettingsSchema = z.object({
  enabled: z.boolean().optional(),
  html_content: z.string().optional(),
  landing: z.string().optional(),
  plain_content: z.string().optional(),
  replace: z.string().optional(),
  url: z.string().optional(),
});

export const subuserSchema = z.object({
  disabled: z.boolean(),
  email: z.string(),
  id: z.number(),
  username: z.string(),
});

export const subuserPostSchema = z.object({
  authorization_token: z.string().optional(),
  credit_allocation: z
    .object({
      type: z.string().optional(),
    })
    .optional(),
  email: z.string(),
  signup_session_token: z.string().optional(),
  user_id: z.number(),
  username: z.string(),
});

export const subuserStatsSchema = z.object({
  date: z.string().optional(),
  stats: z
    .array(
      z.object({
        first_name: z.string().optional(),
        last_name: z.string().optional(),
        metrics: z
          .object({
            blocks: z.number().optional(),
            bounce_drops: z.number().optional(),
            bounces: z.number().optional(),
            clicks: z.number().optional(),
            deferred: z.number().optional(),
            delivered: z.number().optional(),
            invalid_emails: z.number().optional(),
            opens: z.number().optional(),
            processed: z.number().optional(),
            requests: z.number().optional(),
            spam_report_drops: z.number().optional(),
            spam_reports: z.number().optional(),
            unique_clicks: z.number().optional(),
            unique_opens: z.number().optional(),
            unsubscribe_drops: z.number().optional(),
            unsubscribes: z.number().optional(),
          })
          .optional(),
        name: z.string().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
});

export const suppressionGroupSchema = z.object({
  description: z.string(),
  id: z.number(),
  is_default: z.boolean().optional(),
  last_email_sent_at: z.unknown().optional(),
  name: z.string(),
  unsubscribes: z.number().optional(),
});

export const suppressionGroupRequestBaseSchema = z.object({
  description: z.string().optional(),
  is_default: z.boolean().optional(),
  name: z.string().optional(),
});

export const suppressionsRequestSchema = z.object({
  recipient_emails: z.array(z.string()),
});

export const tNESenderIDSchema = z
  .object({
    id: z.number().optional(),
  })
  .and(sendersIdRequestBodySchema)
  .and(
    z.object({
      created_at: z.number().optional(),
      locked: z.boolean().optional(),
      updated_at: z.number().optional(),
      verified: z
        .object({
          reason: z.string().optional().nullable(),
          status: z.boolean().optional(),
        })
        .optional(),
    }),
  );

export const toEmailArraySchema = z.array(
  z.object({
    email: z.string(),
    name: z.string().optional(),
  }),
);

export const transactionalTemplateWarningSchema = z.object({
  message: z.string().optional(),
});

export const transactionalTemplateVersionCreateSchema = z.object({
  active: z.union([z.literal(0), z.literal(1)]).optional(),
  editor: z.union([z.literal('code'), z.literal('design')]).optional(),
  generate_plain_content: z.boolean().optional(),
  html_content: z.string().optional(),
  name: z.string(),
  plain_content: z.string().optional(),
  subject: z.string(),
  test_data: z.string().optional(),
});

export const activeSchema = z.union([z.literal(0), z.literal(1)]);

export const transactionalTemplatesVersionOutputLeanSchema = z.object({
  active: z.union([z.literal(0), z.literal(1)]).optional(),
  editor: z.union([z.literal('code'), z.literal('design')]).optional(),
  generate_plain_content: z.boolean().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  subject: z.string().optional(),
  template_id: z.string().optional(),
  thumbnail_url: z.string().optional(),
  updated_at: z.string().optional(),
});

export const transactionalTemplatesTemplateLeanSchema = z.object({
  generation: z.union([z.literal('legacy'), z.literal('dynamic')]),
  id: z.string(),
  name: z.string(),
  'updated_at ': z.string(),
  versions: z.array(transactionalTemplatesVersionOutputLeanSchema).optional(),
});

export const generationSchema = z.union([z.literal('legacy'), z.literal('dynamic')]);

export const userProfileSchema = z.object({
  address: z.string().optional(),
  address2: z.string().optional(),
  city: z.string().optional(),
  company: z.string().optional(),
  country: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  phone: z.string().optional(),
  state: z.string().optional(),
  website: z.string().optional(),
  zip: z.string().optional(),
});

export const userScheduledSendStatusSchema = mailBatchIdSchema.and(
  z.object({
    status: z.union([z.literal('cancel'), z.literal('pause')]),
  }),
);

export const status5Schema = z.union([z.literal('cancel'), z.literal('pause')]);

export const verifiedSenderRequestSchemaSchema = z.object({
  address: z.string().optional(),
  address2: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  from_email: z.string(),
  from_name: z.string().optional(),
  nickname: z.string(),
  reply_to: z.string(),
  reply_to_name: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
});

export const verifiedSenderResponseSchemaSchema = z.object({
  address: z.string().optional(),
  address2: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  from_email: z.string().optional(),
  from_name: z.string().optional(),
  id: z.number().optional(),
  locked: z.boolean().optional(),
  nickname: z.string().optional(),
  reply_to: z.string().optional(),
  reply_to_name: z.string().optional(),
  state: z.string().optional(),
  verified: z.boolean().optional(),
  zip: z.string().optional(),
});

export const webhookSchema = z.object({
  nonce: z.string(),
  url: z.string(),
});

export const webhooksEventWebhookRequestSchema = z.object({
  bounce: z.boolean(),
  click: z.boolean(),
  deferred: z.boolean(),
  delivered: z.boolean(),
  dropped: z.boolean(),
  enabled: z.boolean(),
  group_resubscribe: z.boolean(),
  group_unsubscribe: z.boolean(),
  oauth_client_id: z.string().optional(),
  oauth_token_url: z.string().optional(),
  open: z.boolean(),
  processed: z.boolean(),
  spam_report: z.boolean(),
  unsubscribe: z.boolean(),
  url: z.string(),
});

export const getAccessSettingsActivityDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
    })
    .optional(),
});

export const getAccessSettingsActivityResponseSchema = z.object({
  result: z.array(
    z.object({
      allowed: z.boolean(),
      auth_method: z.string(),
      first_at: z.number(),
      ip: z.string(),
      last_at: z.number(),
      location: z.string(),
    }),
  ),
});

export const getAccessSettingsActivityErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteAccessSettingsWhitelistDataSchema = z.object({
  body: z
    .object({
      ids: z.array(z.number()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteAccessSettingsWhitelistResponseSchema = z.record(z.unknown());

export const deleteAccessSettingsWhitelistErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getAccessSettingsWhitelistDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getAccessSettingsWhitelistResponseSchema = ipAccessResponseSchema;

export const getAccessSettingsWhitelistErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postAccessSettingsWhitelistDataSchema = z.object({
  body: z
    .object({
      ips: z.array(
        z.object({
          ip: z.string(),
        }),
      ),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postAccessSettingsWhitelistResponseSchema = ipAccessResponseSchema;

export const postAccessSettingsWhitelistErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteAccessSettingsWhitelistRuleIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    rule_id: z.string(),
  }),
});

export const deleteAccessSettingsWhitelistRuleIdResponseSchema = z.record(z.unknown());

export const deleteAccessSettingsWhitelistRuleIdErrorSchema = z.unknown();

export const getAccessSettingsWhitelistRuleIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    rule_id: z.string(),
  }),
});

export const getAccessSettingsWhitelistRuleIdResponseSchema = ipAccessResponseSchema;

export const getAccessSettingsWhitelistRuleIdErrorSchema = z.unknown();

export const getAlertsDataSchema = z.object({
  headers: z
    .object({
      Authorization: z.string().optional(),
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getAlertsResponseSchema = z.array(
  z.object({
    created_at: z.number(),
    email_to: z.string(),
    frequency: z.string().optional(),
    id: z.number(),
    percentage: z.number().optional(),
    type: z.union([z.literal('usage_limit'), z.literal('stats_notification')]),
    updated_at: z.number().optional(),
  }),
);

export const getAlertsErrorSchema = z.unknown();

export const postAlertsDataSchema = z.object({
  body: z
    .object({
      email_to: z.string().nullable(),
      frequency: z.string().optional(),
      percentage: z.number().optional(),
      type: z.union([z.literal('stats_notification'), z.literal('usage_limit')]),
    })
    .optional(),
  headers: z
    .object({
      Authorization: z.string().optional(),
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postAlertsResponseSchema = z.object({
  created_at: z.number(),
  email_to: z.string(),
  frequency: z.string().optional(),
  id: z.number(),
  percentage: z.number().optional(),
  type: z.string(),
  updated_at: z.number(),
});

export const postAlertsErrorSchema = z.object({
  field: z.string().optional(),
  message: z.string().optional(),
});

export const deleteAlertsAlertIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    alert_id: z.number(),
  }),
});

export const deleteAlertsAlertIdResponseSchema = z.record(z.unknown());

export const deleteAlertsAlertIdErrorSchema = z.unknown();

export const getAlertsAlertIdDataSchema = z.object({
  headers: z
    .object({
      Authorization: z.string().optional(),
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    alert_id: z.number(),
  }),
});

export const getAlertsAlertIdResponseSchema = z.object({
  created_at: z.number(),
  email_to: z.string(),
  frequency: z.string().optional(),
  id: z.number(),
  percentage: z.number().optional(),
  type: z.union([z.literal('usage_alert'), z.literal('stats_notification')]),
  updated_at: z.number(),
});

export const getAlertsAlertIdErrorSchema = z.unknown();

export const patchAlertsAlertIdDataSchema = z.object({
  body: z
    .object({
      email_to: z.string().optional(),
      frequency: z.string().optional(),
      percentage: z.number().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    alert_id: z.number(),
  }),
});

export const patchAlertsAlertIdResponseSchema = z.object({
  created_at: z.number(),
  email_to: z.string(),
  frequency: z.string().optional(),
  id: z.number(),
  percentage: z.number().optional(),
  type: z.union([z.literal('usage_alert'), z.literal('stats_notification')]),
  updated_at: z.number(),
});

export const patchAlertsAlertIdErrorSchema = z.unknown();

export const getApiKeysDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
    })
    .optional(),
});

export const getApiKeysResponseSchema = z.object({
  result: z.array(apiKeyNameIdSchema).optional(),
});

export const getApiKeysErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const createApiKeysDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
      scopes: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const createApiKeysResponseSchema = z.object({
  api_key: z.string().optional(),
  api_key_id: z.string().optional(),
  name: z.string().optional(),
  scopes: z.array(z.string()).optional(),
});

export const createApiKeysErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteApiKeysApiKeyIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    api_key_id: z.string(),
  }),
});

export const deleteApiKeysApiKeyIdResponseSchema = z.void();

export const deleteApiKeysApiKeyIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getApiKeysApiKeyIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    api_key_id: z.string(),
  }),
});

export const getApiKeysApiKeyIdResponseSchema = z.object({
  result: z.array(apiKeyNameIdScopesSchema).optional(),
});

export const getApiKeysApiKeyIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchApiKeysApiKeyIdDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    api_key_id: z.string(),
  }),
});

export const patchApiKeysApiKeyIdResponseSchema = apiKeyNameIdSchema;

export const patchApiKeysApiKeyIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const putApiKeysApiKeyIdDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
      scopes: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    api_key_id: z.string(),
  }),
});

export const putApiKeysApiKeyIdResponseSchema = apiKeyNameIdScopesSchema;

export const putApiKeysApiKeyIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getAsmGroupsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      id: z.number().optional(),
    })
    .optional(),
});

export const getAsmGroupsResponseSchema = z.array(suppressionGroupSchema);

export const getAsmGroupsErrorSchema = z.unknown();

export const postAsmGroupsDataSchema = z.object({
  body: suppressionGroupRequestBaseSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postAsmGroupsResponseSchema = z.object({
  description: z.string(),
  id: z.number(),
  is_default: z.boolean(),
  name: z.string(),
});

export const postAsmGroupsErrorSchema = z.unknown();

export const deleteAsmGroupsGroupIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const deleteAsmGroupsGroupIdResponseSchema = z.record(z.unknown());

export const deleteAsmGroupsGroupIdErrorSchema = z.unknown();

export const getAsmGroupsGroupIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const getAsmGroupsGroupIdResponseSchema = suppressionGroupRequestBaseSchema.and(
  z.object({
    id: z.number(),
    last_email_sent_at: z.string().optional().nullable(),
    unsubscribes: z.number().optional(),
  }),
);

export const getAsmGroupsGroupIdErrorSchema = z.unknown();

export const patchAsmGroupsGroupIdDataSchema = z.object({
  body: suppressionGroupRequestBaseSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const patchAsmGroupsGroupIdResponseSchema = suppressionGroupSchema;

export const patchAsmGroupsGroupIdErrorSchema = z.unknown();

export const getAsmGroupsGroupIdSuppressionsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const getAsmGroupsGroupIdSuppressionsResponseSchema = z.array(z.string());

export const getAsmGroupsGroupIdSuppressionsErrorSchema = z.unknown();

export const postAsmGroupsGroupIdSuppressionsDataSchema = z.object({
  body: suppressionsRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const postAsmGroupsGroupIdSuppressionsResponseSchema = z.object({
  recipient_emails: z.array(z.string()).optional(),
});

export const postAsmGroupsGroupIdSuppressionsErrorSchema = z.unknown();

export const postAsmGroupsGroupIdSuppressionsSearchDataSchema = z.object({
  body: suppressionsRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    group_id: z.string(),
  }),
});

export const postAsmGroupsGroupIdSuppressionsSearchResponseSchema = z.array(z.string());

export const postAsmGroupsGroupIdSuppressionsSearchErrorSchema = z.unknown();

export const deleteAsmGroupsGroupIdSuppressionsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
    group_id: z.string(),
  }),
});

export const deleteAsmGroupsGroupIdSuppressionsEmailResponseSchema = z.unknown();

export const deleteAsmGroupsGroupIdSuppressionsEmailErrorSchema = z.unknown();

export const getAsmSuppressionsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getAsmSuppressionsResponseSchema = z.array(
  z.object({
    created_at: z.number(),
    email: z.string(),
    group_id: z.number(),
    group_name: z.string(),
  }),
);

export const getAsmSuppressionsErrorSchema = z.unknown();

export const postAsmSuppressionsGlobalDataSchema = z.object({
  body: suppressionsRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postAsmSuppressionsGlobalResponseSchema = z.object({
  recipient_emails: z.array(z.string()),
});

export const postAsmSuppressionsGlobalErrorSchema = z.unknown();

export const deleteAsmSuppressionsGlobalEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const deleteAsmSuppressionsGlobalEmailResponseSchema = z.record(z.unknown());

export const deleteAsmSuppressionsGlobalEmailErrorSchema = z.unknown();

export const getAsmSuppressionsGlobalEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getAsmSuppressionsGlobalEmailResponseSchema = z.object({
  recipient_email: z.string(),
});

export const getAsmSuppressionsGlobalEmailErrorSchema = z.unknown();

export const getAsmSuppressionsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getAsmSuppressionsEmailResponseSchema = z.object({
  suppressions: z.array(
    z.object({
      description: z.string(),
      id: z.number(),
      is_default: z.boolean(),
      name: z.string(),
      suppressed: z.boolean(),
    }),
  ),
});

export const getAsmSuppressionsEmailErrorSchema = z.unknown();

export const getBrowsersStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    browsers: z.string().optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getBrowsersStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsClicksSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const getBrowsersStatsErrorSchema = z.unknown();

export const getCampaignsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getCampaignsResponseSchema = z.object({
  result: z.array(campaignResponseSchema).optional(),
});

export const getCampaignsErrorSchema = z.unknown();

export const postCampaignsDataSchema = z.object({
  body: campaignRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postCampaignsResponseSchema = campaignResponseSchema;

export const postCampaignsErrorSchema = z.union([globalErrorResponseSchemaSchema, z.record(z.unknown())]);

export const deleteCampaignsCampaignIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const deleteCampaignsCampaignIdResponseSchema = z.unknown();

export const deleteCampaignsCampaignIdErrorSchema = z.record(z.unknown());

export const getCampaignsCampaignIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const getCampaignsCampaignIdResponseSchema = z.object({
  categories: z.array(z.string()).optional(),
  custom_unsubscribe_url: z.string().optional(),
  html_content: z.string().optional(),
  id: z.number().optional(),
  ip_pool: z.string().optional(),
  list_ids: z.array(z.number()).optional(),
  plain_content: z.string().optional(),
  segment_ids: z.array(z.number()).optional(),
  sender_id: z.number().optional(),
  status: z.string().optional(),
  subject: z.string().optional(),
  suppression_group_id: z.number().optional(),
  title: z.string().optional(),
});

export const getCampaignsCampaignIdErrorSchema = z.record(z.unknown());

export const patchCampaignsCampaignIdDataSchema = z.object({
  body: z
    .object({
      categories: z.array(z.string()),
      html_content: z.string(),
      plain_content: z.string(),
      subject: z.string(),
      title: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const patchCampaignsCampaignIdResponseSchema = campaignResponseSchema;

export const patchCampaignsCampaignIdErrorSchema = z.union([z.record(z.unknown()), globalErrorResponseSchemaSchema]);

export const deleteCampaignsCampaignIdSchedulesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const deleteCampaignsCampaignIdSchedulesResponseSchema = z.unknown();

export const deleteCampaignsCampaignIdSchedulesErrorSchema = globalErrorResponseSchemaSchema;

export const getCampaignsCampaignIdSchedulesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const getCampaignsCampaignIdSchedulesResponseSchema = z.object({
  send_at: z.number(),
});

export const getCampaignsCampaignIdSchedulesErrorSchema = globalErrorResponseSchemaSchema;

export const patchCampaignsCampaignIdSchedulesDataSchema = z.object({
  body: z
    .object({
      send_at: z.number(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const patchCampaignsCampaignIdSchedulesResponseSchema = z.object({
  id: z.number(),
  send_at: z.number(),
  status: z.string(),
});

export const patchCampaignsCampaignIdSchedulesErrorSchema = globalErrorResponseSchemaSchema;

export const postCampaignsCampaignIdSchedulesDataSchema = z.object({
  body: z
    .object({
      send_at: z.number(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const postCampaignsCampaignIdSchedulesResponseSchema = z.object({
  id: z.number(),
  send_at: z.number(),
  status: z.literal('Scheduled'),
});

export const postCampaignsCampaignIdSchedulesErrorSchema = globalErrorResponseSchemaSchema;

export const postCampaignsCampaignIdSchedulesNowDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const postCampaignsCampaignIdSchedulesNowResponseSchema = z.object({
  id: z.number(),
  status: z.string(),
});

export const postCampaignsCampaignIdSchedulesNowErrorSchema = globalErrorResponseSchemaSchema;

export const postCampaignsCampaignIdSchedulesTestDataSchema = z.object({
  body: z
    .object({
      to: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    campaign_id: z.number(),
  }),
});

export const postCampaignsCampaignIdSchedulesTestResponseSchema = z.object({
  to: z.string(),
});

export const postCampaignsCampaignIdSchedulesTestErrorSchema = globalErrorResponseSchemaSchema;

export const getCategoriesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      category: z.string().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getCategoriesResponseSchema = z.array(
  z.object({
    category: z.string(),
  }),
);

export const getCategoriesErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string(),
        message: z.string(),
      }),
    )
    .optional(),
});

export const getCategoriesStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    categories: z.string(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getCategoriesStatsResponseSchema = z.array(categoryStatsSchema);

export const getCategoriesStatsErrorSchema = z.unknown();

export const getCategoriesStatsSumsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    sort_by_direction: z.union([z.literal('desc'), z.literal('asc')]).optional(),
    sort_by_metric: z.string().optional(),
    start_date: z.string(),
  }),
});

export const getCategoriesStatsSumsResponseSchema = categoryStatsSchema;

export const getCategoriesStatsSumsErrorSchema = z.unknown();

export const getClientsStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    start_date: z.string(),
  }),
});

export const getClientsStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsOpensSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const getClientsStatsErrorSchema = z.unknown();

export const getClientsClientTypeStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    client_type: z.union([z.literal('phone'), z.literal('tablet'), z.literal('webmail'), z.literal('desktop')]),
  }),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    start_date: z.string(),
  }),
});

export const getClientsClientTypeStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsOpensSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const getClientsClientTypeStatsErrorSchema = z.unknown();

export const getContactdbCustomFieldsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbCustomFieldsResponseSchema = z.object({
  custom_fields: z.array(contactdbCustomFieldWithIdSchema),
});

export const getContactdbCustomFieldsErrorSchema = globalErrorResponseSchemaSchema;

export const postContactdbCustomFieldsDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postContactdbCustomFieldsResponseSchema = contactdbCustomFieldWithIdSchema;

export const postContactdbCustomFieldsErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbCustomFieldsCustomFieldIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    custom_field_id: z.number(),
  }),
});

export const deleteContactdbCustomFieldsCustomFieldIdResponseSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbCustomFieldsCustomFieldIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbCustomFieldsCustomFieldIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    custom_field_id: z.number(),
  }),
});

export const getContactdbCustomFieldsCustomFieldIdResponseSchema = contactdbCustomFieldWithIdSchema;

export const getContactdbCustomFieldsCustomFieldIdErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbListsDataSchema = z.object({
  body: z.array(z.number()).optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteContactdbListsResponseSchema = z.unknown();

export const deleteContactdbListsErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbListsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbListsResponseSchema = z.object({
  lists: z.array(contactdbListSchema),
});

export const getContactdbListsErrorSchema = z.unknown();

export const postContactdbListsDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postContactdbListsResponseSchema = contactdbListSchema;

export const postContactdbListsErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbListsListIdDataSchema = z.object({
  body: z.unknown().optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      delete_contacts: z.boolean().optional(),
    })
    .optional(),
});

export const deleteContactdbListsListIdResponseSchema = z.unknown();

export const deleteContactdbListsListIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbListsListIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      list_id: z.number().optional(),
    })
    .optional(),
});

export const getContactdbListsListIdResponseSchema = contactdbListSchema;

export const getContactdbListsListIdErrorSchema = globalErrorResponseSchemaSchema;

export const patchContactdbListsListIdDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.string(),
  }),
  query: z.object({
    list_id: z.number(),
  }),
});

export const patchContactdbListsListIdResponseSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
  recipient_count: z.number().optional(),
});

export const patchContactdbListsListIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbListsListIdRecipientsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.number(),
  }),
  query: z.object({
    list_id: z.number(),
    page: z.number().optional(),
    page_size: z.number().optional(),
  }),
});

export const getContactdbListsListIdRecipientsResponseSchema = z.object({
  recipients: z.array(contactdbRecipientSchema).optional(),
});

export const getContactdbListsListIdRecipientsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.record(z.unknown()),
]);

export const postContactdbListsListIdRecipientsDataSchema = z.object({
  body: z.array(z.number()).optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.number(),
  }),
});

export const postContactdbListsListIdRecipientsResponseSchema = z.unknown();

export const postContactdbListsListIdRecipientsErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbListsListIdRecipientsRecipientIdDataSchema = z.object({
  body: z.unknown().optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.number(),
    recipient_id: z.string(),
  }),
  query: z.object({
    list_id: z.number(),
    recipient_id: z.number(),
  }),
});

export const deleteContactdbListsListIdRecipientsRecipientIdResponseSchema = z.unknown();

export const deleteContactdbListsListIdRecipientsRecipientIdErrorSchema = globalErrorResponseSchemaSchema;

export const postContactdbListsListIdRecipientsRecipientIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    list_id: z.number(),
    recipient_id: z.string(),
  }),
});

export const postContactdbListsListIdRecipientsRecipientIdResponseSchema = z.unknown();

export const postContactdbListsListIdRecipientsRecipientIdErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbRecipientsDataSchema = z.object({
  body: z.array(z.string()).optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteContactdbRecipientsResponseSchema = z.record(z.unknown());

export const deleteContactdbRecipientsErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbRecipientsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      page: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getContactdbRecipientsResponseSchema = z.object({
  recipients: z.array(z.record(z.unknown())),
});

export const getContactdbRecipientsErrorSchema = z.union([z.record(z.unknown()), globalErrorResponseSchemaSchema]);

export const patchContactdbRecipientsDataSchema = z.object({
  body: z
    .array(
      z.object({
        email: z.string(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
      }),
    )
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchContactdbRecipientsResponseSchema = contactdbRecipientResponseSchema;

export const patchContactdbRecipientsErrorSchema = globalErrorResponseSchemaSchema;

export const postContactdbRecipientsDataSchema = z.object({
  body: z
    .array(
      z.object({
        age: z.number().optional(),
        email: z.string(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
      }),
    )
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postContactdbRecipientsResponseSchema = contactdbRecipientResponseSchema;

export const postContactdbRecipientsErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbRecipientsBillableCountDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbRecipientsBillableCountResponseSchema = contactdbRecipientCountSchema;

export const getContactdbRecipientsBillableCountErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbRecipientsCountDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbRecipientsCountResponseSchema = contactdbRecipientCountSchema;

export const getContactdbRecipientsCountErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbRecipientsSearchDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      '{field_name}': z.string().optional(),
    })
    .optional(),
});

export const getContactdbRecipientsSearchResponseSchema = z.object({
  recipients: z.array(contactdbRecipientSchema).optional(),
});

export const getContactdbRecipientsSearchErrorSchema = globalErrorResponseSchemaSchema;

export const postContactdbRecipientsSearchDataSchema = z.object({
  body: z
    .object({
      conditions: z.array(z.unknown()),
      list_id: z.number(),
    })
    .optional(),
});

export const postContactdbRecipientsSearchResponseSchema = z.object({
  recipient_count: z.number().optional(),
  recipients: z
    .array(
      z.object({
        created_at: z.number().optional(),
        custom_fields: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
              type: z.string().optional(),
              value: z.union([z.number(), z.string()]).optional(),
            }),
          )
          .optional(),
        email: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_clicked: z.number().optional(),
        last_emailed: z.number().optional(),
        last_opened: z.number().optional(),
        updated_at: z.number().optional(),
      }),
    )
    .optional(),
});

export const postContactdbRecipientsSearchErrorSchema = z.unknown();

export const deleteContactdbRecipientsRecipientIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    recipient_id: z.string(),
  }),
});

export const deleteContactdbRecipientsRecipientIdResponseSchema = z.record(z.unknown());

export const deleteContactdbRecipientsRecipientIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbRecipientsRecipientIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    recipient_id: z.string(),
  }),
});

export const getContactdbRecipientsRecipientIdResponseSchema = contactdbRecipientSchema;

export const getContactdbRecipientsRecipientIdErrorSchema = z.union([
  z.record(z.unknown()),
  globalErrorResponseSchemaSchema,
]);

export const getContactdbRecipientsRecipientIdListsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    recipient_id: z.string(),
  }),
});

export const getContactdbRecipientsRecipientIdListsResponseSchema = z.object({
  lists: z.array(contactdbListSchema).optional(),
});

export const getContactdbRecipientsRecipientIdListsErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbReservedFieldsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbReservedFieldsResponseSchema = z.object({
  reserved_fields: z
    .array(
      z.object({
        name: z.string().optional(),
        type: z.string().optional(),
      }),
    )
    .optional(),
});

export const getContactdbReservedFieldsErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbSegmentsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbSegmentsResponseSchema = z.object({
  segments: z.array(contactdbSegmentsSchema),
});

export const getContactdbSegmentsErrorSchema = globalErrorResponseSchemaSchema;

export const postContactdbSegmentsDataSchema = z.object({
  body: contactdbSegmentsSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const contactdbSegmentsWithIdSchema = z
  .object({
    id: z.number(),
  })
  .and(contactdbSegmentsSchema);

export const postContactdbSegmentsErrorSchema = globalErrorResponseSchemaSchema;

export const deleteContactdbSegmentsSegmentIdDataSchema = z.object({
  body: z.unknown().optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    segment_id: z.string(),
  }),
  query: z
    .object({
      delete_contacts: z.boolean().optional(),
    })
    .optional(),
});

export const deleteContactdbSegmentsSegmentIdResponseSchema = z.unknown();

export const deleteContactdbSegmentsSegmentIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbSegmentsSegmentIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    segment_id: z.string(),
  }),
  query: z.object({
    segment_id: z.number(),
  }),
});

export const getContactdbSegmentsSegmentIdResponseSchema = contactdbSegmentsSchema;

export const getContactdbSegmentsSegmentIdErrorSchema = globalErrorResponseSchemaSchema;

export const patchContactdbSegmentsSegmentIdDataSchema = z.object({
  body: z
    .object({
      conditions: z.array(contactdbSegmentsConditionsSchema).optional(),
      list_id: z.number().optional(),
      name: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    segment_id: z.string(),
  }),
  query: z
    .object({
      segment_id: z.string().optional(),
    })
    .optional(),
});

export const patchContactdbSegmentsSegmentIdResponseSchema = contactdbSegmentsSchema;

export const patchContactdbSegmentsSegmentIdErrorSchema = globalErrorResponseSchemaSchema;

export const getContactdbSegmentsSegmentIdRecipientsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    segment_id: z.number(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getContactdbSegmentsSegmentIdRecipientsResponseSchema = z.object({
  recipients: z.array(contactdbRecipientSchema),
});

export const getContactdbSegmentsSegmentIdRecipientsErrorSchema = z.union([
  z.record(z.unknown()),
  globalErrorResponseSchemaSchema,
]);

export const getContactdbStatusDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getContactdbStatusResponseSchema = z.object({
  status: z
    .array(
      z.object({
        '': z.string().optional(),
        id: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
});

export const getContactdbStatusErrorSchema = z.unknown();

export const listDesignsDataSchema = z.object({
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      summary: z.boolean().optional(),
    })
    .optional(),
});

export const listDesignsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(designOutputSummarySchema).optional(),
});

export const listDesignsErrorSchema = z.unknown();

export const postDesignsDataSchema = z.object({
  body: designInputSchema.optional(),
});

export const designOutputSchema = designOutputSummarySchema.and(designInputSchema);

export const postDesignsErrorSchema = apiErrorsSchema;

export const listSendgridPreBuiltDesignsDataSchema = z.object({
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      summary: z.boolean().optional(),
    })
    .optional(),
});

export const listSendgridPreBuiltDesignsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(designOutputSummarySchema).optional(),
});

export const listSendgridPreBuiltDesignsErrorSchema = z.unknown();

export const getSendgridPreBuiltDesignDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getSendgridPreBuiltDesignResponseSchema = designOutputSchema;

export const getSendgridPreBuiltDesignErrorSchema = apiErrorsSchema;

export const postSendgridPreBuiltDesignDataSchema = z.object({
  body: designDuplicateInputSchema.optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const postSendgridPreBuiltDesignResponseSchema = designOutputSchema;

export const postSendgridPreBuiltDesignErrorSchema = apiErrorsSchema;

export const deleteDesignDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteDesignResponseSchema = z.record(z.unknown());

export const deleteDesignErrorSchema = apiErrorsSchema;

export const getDesignDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getDesignResponseSchema = designOutputSchema;

export const getDesignErrorSchema = apiErrorsSchema;

export const putDesignDataSchema = z.object({
  body: z
    .object({
      categories: z.array(z.string()).optional(),
      generate_plain_content: z.boolean().optional(),
      html_content: z.string().optional(),
      name: z.string().optional(),
      plain_content: z.string().optional(),
      subject: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putDesignResponseSchema = designOutputSchema;

export const putDesignErrorSchema = apiErrorsSchema;

export const postDesignDataSchema = z.object({
  body: designDuplicateInputSchema.optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const postDesignResponseSchema = designOutputSchema;

export const postDesignErrorSchema = z.union([apiErrorSchema, apiErrorsSchema]);

export const getDevicesStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getDevicesStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsOpensSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const getDevicesStatsErrorSchema = z.unknown();

export const getGeoStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    country: z.union([z.literal('US'), z.literal('CA')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getGeoStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsClicksOpensSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const getGeoStatsErrorSchema = z.unknown();

export const getIpsDataSchema = z.object({
  query: z
    .object({
      exclude_whitelabels: z.boolean().optional(),
      ip: z.string().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      sort_by_direction: z.union([z.literal('desc'), z.literal('asc')]).optional(),
      subuser: z.string().optional(),
    })
    .optional(),
});

export const getIpsResponseSchema = z.array(
  z.object({
    assigned_at: z.number().nullable(),
    ip: z.string(),
    pools: z.array(z.string()),
    rdns: z.string().optional(),
    start_date: z.number().nullable(),
    subusers: z.array(z.string()),
    warmup: z.boolean(),
    whitelabeled: z.boolean(),
  }),
);

export const getIpsErrorSchema = z.unknown();

export const postIpsDataSchema = z.object({
  body: z
    .object({
      count: z.number(),
      subusers: z.array(z.string()).optional(),
      warmup: z.boolean().optional(),
    })
    .optional(),
});

export const postIpsResponseSchema = z.object({
  ips: z.array(
    z.object({
      ip: z.string(),
      subusers: z.array(z.string()),
    }),
  ),
  remaining_ips: z.number(),
  warmup: z.boolean(),
});

export const postIpsErrorSchema = globalErrorResponseSchemaSchema;

export const getIpsAssignedResponseSchema = z.array(
  z.object({
    ip: z.string(),
    pools: z.array(z.string()),
    start_date: z.number(),
    warmup: z.boolean(),
  }),
);

export const getIpsAssignedErrorSchema = z.unknown();

export const getIpsPoolsResponseSchema = z.array(ipPoolResponseSchema);

export const getIpsPoolsErrorSchema = z.unknown();

export const postIpsPoolsDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
});

export const postIpsPoolsResponseSchema = ipPoolResponseSchema;

export const postIpsPoolsErrorSchema = z.unknown();

export const deleteIpsPoolsPoolNameDataSchema = z.object({
  path: z.object({
    pool_name: z.string(),
  }),
});

export const deleteIpsPoolsPoolNameResponseSchema = z.record(z.unknown());

export const deleteIpsPoolsPoolNameErrorSchema = z.object({
  error: z.string().optional(),
});

export const getIpsPoolsPoolNameDataSchema = z.object({
  path: z.object({
    pool_name: z.string(),
  }),
});

export const getIpsPoolsPoolNameResponseSchema = z.object({
  ips: z.array(z.string()).optional(),
  pool_name: z.string().optional(),
});

export const getIpsPoolsPoolNameErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const putIpsPoolsPoolNameDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    pool_name: z.string(),
  }),
});

export const putIpsPoolsPoolNameResponseSchema = ipPoolResponseSchema;

export const putIpsPoolsPoolNameErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.unknown().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postIpsPoolsPoolNameIpsDataSchema = z.object({
  body: z
    .object({
      ip: z.string().optional(),
    })
    .optional(),
  path: z.object({
    pool_name: z.string(),
  }),
});

export const postIpsPoolsPoolNameIpsResponseSchema = z.object({
  ip: z.string(),
  pools: z.array(z.string()),
  start_date: z.number(),
  warmup: z.boolean(),
});

export const postIpsPoolsPoolNameIpsErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.unknown().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteIpsPoolsPoolNameIpsIpDataSchema = z.object({
  path: z.object({
    ip: z.string(),
    pool_name: z.string(),
  }),
});

export const deleteIpsPoolsPoolNameIpsIpResponseSchema = z.record(z.unknown());

export const deleteIpsPoolsPoolNameIpsIpErrorSchema = z.object({
  error: z.string().optional(),
});

export const getIpsRemainingResponseSchema = z.object({
  results: z.array(
    z.object({
      period: z.string(),
      price_per_ip: z.number(),
      remaining: z.number(),
    }),
  ),
});

export const getIpsRemainingErrorSchema = z.unknown();

export const getIpsWarmupResponseSchema = ipWarmupResponseSchema;

export const getIpsWarmupErrorSchema = z.unknown();

export const postIpsWarmupDataSchema = z.object({
  body: z
    .object({
      ip: z.string().optional(),
    })
    .optional(),
});

export const postIpsWarmupResponseSchema = ipWarmupResponseSchema;

export const postIpsWarmupErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.unknown().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteIpsWarmupIpAddressDataSchema = z.object({
  path: z.object({
    ip_address: z.string(),
  }),
});

export const deleteIpsWarmupIpAddressResponseSchema = z.record(z.unknown());

export const deleteIpsWarmupIpAddressErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.unknown().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getIpsWarmupIpAddressDataSchema = z.object({
  path: z.object({
    ip_address: z.string(),
  }),
});

export const getIpsWarmupIpAddressResponseSchema = ipWarmupResponseSchema;

export const getIpsWarmupIpAddressErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.unknown().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getIpsIpAddressDataSchema = z.object({
  path: z.object({
    ip_address: z.string(),
  }),
});

export const getIpsIpAddressResponseSchema = z.object({
  ip: z.string(),
  pools: z.array(z.string()),
  rdns: z.string(),
  start_date: z.number().nullable(),
  subusers: z.array(z.string()),
  warmup: z.boolean(),
  whitelabeled: z.boolean(),
});

export const getIpsIpAddressErrorSchema = z.unknown();

export const postMailBatchDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postMailBatchResponseSchema = mailBatchIdSchema;

export const postMailBatchErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMailBatchBatchIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    batch_id: z.string(),
  }),
});

export const getMailBatchBatchIdResponseSchema = mailBatchIdSchema;

export const getMailBatchBatchIdErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postMailSendDataSchema = z.object({
  body: z
    .object({
      asm: z
        .object({
          group_id: z.number(),
          groups_to_display: z.array(z.number()).optional(),
        })
        .optional(),
      attachments: z
        .array(
          z.object({
            content: z.string(),
            content_id: z.string().optional(),
            disposition: z.union([z.literal('inline'), z.literal('attachment')]).optional(),
            filename: z.string(),
            type: z.string().optional(),
          }),
        )
        .optional(),
      batch_id: z.string().optional(),
      categories: z.array(z.string()).optional(),
      content: z.array(
        z.object({
          type: z.string(),
          value: z.string(),
        }),
      ),
      custom_args: z.string().optional(),
      from: fromEmailObjectSchema,
      headers: z.record(z.unknown()).optional(),
      ip_pool_name: z.string().optional(),
      mail_settings: z
        .object({
          bypass_bounce_management: z
            .object({
              enable: z.boolean().optional(),
            })
            .optional(),
          bypass_list_management: z
            .object({
              enable: z.boolean().optional(),
            })
            .optional(),
          bypass_spam_management: z
            .object({
              enable: z.boolean().optional(),
            })
            .optional(),
          bypass_unsubscribe_management: z
            .object({
              enable: z.boolean().optional(),
            })
            .optional(),
          footer: z
            .object({
              enable: z.boolean().optional(),
              html: z.string().optional(),
              text: z.string().optional(),
            })
            .optional(),
          sandbox_mode: z
            .object({
              enable: z.boolean().optional(),
            })
            .optional(),
        })
        .optional(),
      personalizations: z.array(
        z.object({
          bcc: z.array(ccBccEmailObjectSchema).optional(),
          cc: z.array(ccBccEmailObjectSchema).optional(),
          custom_args: z.record(z.unknown()).optional(),
          dynamic_template_data: z.record(z.unknown()).optional(),
          from: fromEmailObjectSchema.optional(),
          headers: z.record(z.unknown()).optional(),
          send_at: z.number().optional(),
          subject: z.string().optional(),
          substitutions: z.record(z.unknown()).optional(),
          to: toEmailArraySchema,
        }),
      ),
      reply_to: replyToEmailObjectSchema.optional(),
      reply_to_list: z
        .array(
          z.object({
            email: z.string(),
            name: z.string().optional(),
          }),
        )
        .optional(),
      send_at: z.number().optional(),
      subject: z.string(),
      template_id: z.string().optional(),
      tracking_settings: z
        .object({
          click_tracking: z
            .object({
              enable: z.boolean().optional(),
              enable_text: z.boolean().optional(),
            })
            .optional(),
          ganalytics: z
            .object({
              enable: z.boolean().optional(),
              utm_campaign: z.string().optional(),
              utm_content: z.string().optional(),
              utm_medium: z.string().optional(),
              utm_source: z.string().optional(),
              utm_term: z.string().optional(),
            })
            .optional(),
          open_tracking: z
            .object({
              enable: z.boolean().optional(),
              substitution_tag: z.string().optional(),
            })
            .optional(),
          subscription_tracking: z
            .object({
              enable: z.boolean().optional(),
              html: z.string().optional(),
              substitution_tag: z.string().optional(),
              text: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
    })
    .optional(),
});

export const postMailSendResponseSchema = z.unknown();

export const postMailSendErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMailSettingsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getMailSettingsResponseSchema = z.object({
  result: z.array(
    z.object({
      description: z.string(),
      enabled: z.boolean(),
      name: z.string(),
      title: z.string(),
    }),
  ),
});

export const getMailSettingsErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsAddressWhitelistDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsAddressWhitelistResponseSchema = mailSettingsAddressWhitelabelSchema;

export const getMailSettingsAddressWhitelistErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsAddressWhitelistDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
      list: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsAddressWhitelistResponseSchema = mailSettingsAddressWhitelabelSchema;

export const patchMailSettingsAddressWhitelistErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsBouncePurgeDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsBouncePurgeResponseSchema = mailSettingsBouncePurgeSchema;

export const getMailSettingsBouncePurgeErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsBouncePurgeDataSchema = z.object({
  body: mailSettingsBouncePurgeSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsBouncePurgeResponseSchema = mailSettingsBouncePurgeSchema;

export const patchMailSettingsBouncePurgeErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsFooterDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsFooterResponseSchema = mailSettingsFooterSchema;

export const getMailSettingsFooterErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsFooterDataSchema = z.object({
  body: mailSettingsFooterSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsFooterResponseSchema = mailSettingsFooterSchema;

export const patchMailSettingsFooterErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsForwardBounceDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsForwardBounceResponseSchema = mailSettingsForwardBounceSchema;

export const getMailSettingsForwardBounceErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsForwardBounceDataSchema = z.object({
  body: mailSettingsForwardBounceSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsForwardBounceResponseSchema = mailSettingsForwardBounceSchema;

export const patchMailSettingsForwardBounceErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsForwardSpamDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsForwardSpamResponseSchema = mailSettingsForwardSpamSchema;

export const getMailSettingsForwardSpamErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsForwardSpamDataSchema = z.object({
  body: mailSettingsForwardSpamSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsForwardSpamResponseSchema = mailSettingsForwardSpamSchema;

export const patchMailSettingsForwardSpamErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailSettingsTemplateDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getMailSettingsTemplateResponseSchema = mailSettingsTemplateSchema;

export const getMailSettingsTemplateErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMailSettingsTemplateDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
      html_content: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchMailSettingsTemplateResponseSchema = z.object({
  enabled: z.boolean(),
  html_content: z.string(),
});

export const patchMailSettingsTemplateErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional().nullable(),
        message: z.string(),
        parameter: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMailboxProvidersStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    mailbox_providers: z.string().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const advancedStatsMailboxProviderSchema = advancedStatsClicksOpensSchema.and(
  z.object({
    blocks: z.number().optional(),
    bounces: z.number().optional(),
    deferred: z.number().optional(),
    delivered: z.number().optional(),
    drops: z.number().optional(),
    processed: z.number().optional(),
    requests: z.number().optional(),
    spam_reports: z.number().optional(),
  }),
);

export const getMailboxProvidersStatsErrorSchema = z.unknown();

export const deleteMcContactsDataSchema = z.object({
  query: z
    .object({
      delete_all_contacts: z.string().optional(),
      ids: z.string().optional(),
    })
    .optional(),
});

export const deleteMcContactsResponseSchema = z.object({
  job_id: z.record(z.unknown()),
});

export const deleteMcContactsErrorSchema = z.union([
  z.object({
    errors: z.array(z.record(z.unknown())),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMcContatsResponseSchema = z.object({
  _metadata: selfmetadataSchema.optional(),
  contact_count: z.number().optional(),
  result: z.array(contactDetails3Schema).optional(),
});

export const getMcContatsErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema).optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.record(z.unknown()),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const contactRequestSchema = z.object({
  address_line_1: z.string().optional(),
  address_line_2: z.string().optional(),
  alternate_emails: z.array(z.string()).optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  custom_fields: customFieldsByIdSchema.optional(),
  email: z.string(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  postal_code: z.string().optional(),
  state_province_region: z.string().optional(),
});

export const putMcContactsResponseSchema = z.object({
  job_id: z.string().optional(),
});

export const putMcContactsErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema).optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postMarketingContactsBatchDataSchema = z.object({
  body: z
    .object({
      ids: z.array(z.string()),
    })
    .optional(),
});

export const postMarketingContactsBatchResponseSchema = z.object({
  result: z.array(contactDetails3Schema).optional(),
});

export const postMarketingContactsBatchErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.record(z.unknown()),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMcContactsCountResponseSchema = z.object({
  billable_breakdown: z
    .object({
      breakdown: z.record(z.unknown()).optional(),
      total: z.number().optional(),
    })
    .optional(),
  billable_count: z.number().optional(),
  contact_count: z.number(),
});

export const getMcContactsCountErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMarketingContactsExportsResponseSchema = z.object({
  _metadata: z
    .object({
      next: z.string().optional(),
      prev: z.string().optional(),
      self: z.string().optional(),
    })
    .optional(),
  result: z
    .array(
      z.object({
        _metadata: z
          .object({
            next: z.string().optional(),
            prev: z.string().optional(),
            self: z.string().optional(),
          })
          .optional(),
        completed_at: z.string().optional(),
        created_at: z.string().optional(),
        expires_at: z.string().optional(),
        export_type: z.string().optional(),
        id: z.string().optional(),
        lists: z
          .array(
            z.object({
              ID: z.string().optional(),
              Name: z.string().optional(),
            }),
          )
          .optional(),
        segments: z
          .array(
            z.object({
              ID: z.string().optional(),
              Name: z.string().optional(),
            }),
          )
          .optional(),
        status: z.string().optional(),
        urls: z.array(z.string()).optional(),
        user_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMarketingContactsExportsErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          '': z.string().optional(),
          error_id: z.string().optional(),
          message: z.string(),
        }),
      )
      .optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postMcContactsExportsDataSchema = z.object({
  body: z
    .object({
      file_type: z.union([z.literal('csv'), z.literal('json')]).optional(),
      list_ids: z.array(z.string()).optional(),
      max_file_size: z.number().optional(),
      notifications: z
        .object({
          email: z.boolean().optional(),
        })
        .optional(),
      segment_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const postMcContactsExportsResponseSchema = z.object({
  _metadata: metadataSchema,
  id: z.string().optional(),
});

export const postMcContactsExportsErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema).optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMcContactsExportsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getMcContactsExportsIdResponseSchema = contactExportSchema;

export const getMcContactsExportsIdErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema).optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const putMcContactsImportsDataSchema = z.object({
  body: z
    .object({
      field_mappings: z.array(z.union([z.string(), z.unknown()])),
      file_type: z.literal('csv'),
      list_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const putMcContactsImportsResponseSchema = z.object({
  job_id: z.string().optional(),
  upload_headers: z
    .array(
      z.object({
        header: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  upload_uri: z.string().optional(),
});

export const putMcContactsImportsErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMarketingContactsImportsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getMarketingContactsImportsIdResponseSchema = contactImportSchema;

export const getMarketingContactsImportsIdErrorSchema = z.union([
  z.object({
    errors: errorSchema.optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postMcContactsSearchDataSchema = z.object({
  body: z
    .object({
      query: z.string(),
    })
    .optional(),
});

export const postMcContactsSearchResponseSchema = z.object({
  _metadata: selfmetadataSchema.optional(),
  contact_count: z.number(),
  result: z.array(contactDetails3Schema).optional(),
});

export const postMcContactsSearchErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.unknown(),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postMarketingContactsSearchEmailsDataSchema = z.object({
  body: z
    .object({
      emails: z.array(z.string()),
    })
    .optional(),
});

export const postMarketingContactsSearchEmailsResponseSchema = z.object({
  result: z.record(z.unknown()).optional(),
});

export const postMarketingContactsSearchEmailsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMcContactsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getMcContactsIdResponseSchema = contactDetails3Schema;

export const getMcContactsIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.unknown(),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getMcFieldDefinitionsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  custom_fields: z.array(customFieldDefinitionsResponseSchema),
  reserved_fields: reservedFieldDefinitionsResponseSchema,
});

export const getMcFieldDefinitionsErrorSchema = z.unknown();

export const postMcFieldDefinitionsDataSchema = z.object({
  body: z
    .object({
      field_type: z.union([z.literal('Text'), z.literal('Number'), z.literal('Date')]),
      name: z.string(),
    })
    .optional(),
});

export const postMcFieldDefinitionsResponseSchema = customFieldDefinitionsResponseSchema.and(
  z.object({
    _metadata: metadataSchema.optional(),
  }),
);

export const postMcFieldDefinitionsErrorSchema = z.object({
  errors: z.array(errorSchema),
});

export const deleteMcFieldDefinitionsCustomFieldIdDataSchema = z.object({
  path: z.object({
    custom_field_id: z.string(),
  }),
});

export const deleteMcFieldDefinitionsCustomFieldIdResponseSchema = z.void();

export const deleteMcFieldDefinitionsCustomFieldIdErrorSchema = z.object({
  errors: z.array(errorSchema),
});

export const patchMcFieldDefinitionsCustomFieldIdDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  path: z.object({
    custom_field_id: z.string(),
  }),
});

export const patchMcFieldDefinitionsCustomFieldIdResponseSchema = customFieldDefinitionsResponseSchema.and(
  z.object({
    _metadata: metadataSchema.optional(),
  }),
);

export const patchMcFieldDefinitionsCustomFieldIdErrorSchema = z.object({
  errors: z.array(errorSchema),
});

export const getMcListsDataSchema = z.object({
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
    })
    .optional(),
});

export const getMcListsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(listSchema).optional(),
});

export const getMcListsErrorSchema = z.unknown();

export const postMcListsDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
});

export const postMcListsResponseSchema = listSchema;

export const postMcListsErrorSchema = z.object({
  errors: z.array(errorSchema).optional(),
});

export const deleteListsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      delete_contacts: z.boolean().optional(),
    })
    .optional(),
});

export const deleteListsIdResponseSchema = z.union([
  z.object({
    job_id: z.string().optional(),
  }),
  z.string(),
]);

export const deleteListsIdErrorSchema = z.object({
  errors: z.array(z.record(z.unknown())),
});

export const getMcListsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      contact_sample: z.boolean().optional(),
    })
    .optional(),
});

export const getMcListsIdResponseSchema = listSchema.and(
  z.object({
    contact_sample: contactDetails2Schema.optional(),
  }),
);

export const getMcListsIdErrorSchema = z.array(errorSchema);

export const patchMcListsIdDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const patchMcListsIdResponseSchema = listSchema;

export const patchMcListsIdErrorSchema = z.union([
  z.object({
    errors: z.array(errorSchema).optional(),
  }),
  z.record(z.unknown()),
]);

export const deleteMcListsIdContactsDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z.object({
    contact_ids: z.string(),
  }),
});

export const deleteMcListsIdContactsResponseSchema = z.object({
  job_id: z.string().optional(),
});

export const deleteMcListsIdContactsErrorSchema = z.union([errorSchema, z.unknown()]);

export const getMcListsIdContactsCountDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getMcListsIdContactsCountResponseSchema = z.object({
  billable_count: z.number().optional(),
  contact_count: z.number().optional(),
});

export const getMcListsIdContactsCountErrorSchema = z.record(z.unknown());

export const getMarketingSegmentsDataSchema = z.object({
  query: z
    .object({
      no_parent_list_id: z.boolean().optional(),
      parent_list_ids: z.string().optional(),
    })
    .optional(),
});

export const getMarketingSegmentsResponseSchema = z.object({
  results: z.array(segmentSummarySchema),
});

export const getMarketingSegmentsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const postMarketingSegmentsDataSchema = z.object({
  body: segmentWriteV2Schema
    .and(
      z.object({
        parent_list_id: z.string().optional(),
      }),
    )
    .optional(),
});

export const fullSegmentSchema = segmentSummarySchema
  .and(
    z.object({
      contacts_sample: z.array(contactResponseSchema),
      query_json: z.record(z.unknown()).optional(),
    }),
  )
  .and(segmentWriteV2Schema);

export const postMarketingSegmentsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const getSegmentsDataSchema = z.object({
  query: z
    .object({
      no_parent_list_id: z.boolean().optional(),
      parent_list_ids: z.string().optional(),
    })
    .optional(),
});

export const allSegmentsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  contacts_count: z.number(),
  created_at: z.string(),
  id: z.string(),
  name: z.string(),
  next_sample_update: z.string(),
  parent_list_ids: z.array(z.string()),
  query_version: z.string(),
  sample_updated_at: z.string(),
  status: segmentStatusResponseSchema,
  updated_at: z.string(),
});

export const getSegmentsErrorSchema = z.union([errorsSegV2Schema, z.unknown()]);

export const postSegmentsDataSchema = z.object({
  body: segmentWriteV2Schema.optional(),
});

export const postSegmentsResponseSchema = segmentResponseSchema;

export const postSegmentsErrorSchema = z.union([errorsSegV2Schema, z.unknown()]);

export const deleteSegmentsSegmentIdDataSchema = z.object({
  path: z.object({
    segment_id: z.string(),
  }),
});

export const deleteSegmentsSegmentIdResponseSchema = z.unknown();

export const deleteSegmentsSegmentIdErrorSchema = z.union([errorsSegV2Schema, z.unknown()]);

export const getSegmentsSegmentIdDataSchema = z.object({
  path: z.object({
    segment_id: z.string(),
  }),
  query: z
    .object({
      contacts_sample: z.boolean().optional(),
    })
    .optional(),
});

export const getSegmentsSegmentIdResponseSchema = segmentResponseSchema;

export const getSegmentsSegmentIdErrorSchema = errorsSegV2Schema;

export const patchSegmentsSegmentIdDataSchema = z.object({
  body: segmentUpdateSchema.optional(),
  path: z.object({
    segment_id: z.string(),
  }),
});

export const patchSegmentsSegmentIdResponseSchema = segmentResponseSchema;

export const patchSegmentsSegmentIdErrorSchema = z.union([errorsSegV2Schema, z.unknown()]);

export const postMarketingSegmentsDeleteDataSchema = z.object({
  body: z
    .object({
      ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const postMarketingSegmentsDeleteResponseSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          error: z.string().optional(),
          id: z.string().optional(),
          resources: z
            .object({
              ids: z.array(z.string()).optional(),
              type: z.string().optional(),
            })
            .optional(),
        }),
      )
      .optional(),
  }),
  z.record(z.unknown()),
]);

export const postMarketingSegmentsDeleteErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteMarketingSegmentsSegmentIdDataSchema = z.object({
  path: z.object({
    segment_id: z.string(),
  }),
});

export const deleteMarketingSegmentsSegmentIdResponseSchema = z.record(z.unknown());

export const deleteMarketingSegmentsSegmentIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        field: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const getMarketingSegmentsSegmentIdDataSchema = z.object({
  path: z.object({
    segment_id: z.string(),
  }),
  query: z
    .object({
      query_json: z.boolean().optional(),
    })
    .optional(),
});

export const getMarketingSegmentsSegmentIdResponseSchema = fullSegmentSchema;

export const getMarketingSegmentsSegmentIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        field: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const patchMarketingSegmentsSegmentIdDataSchema = z.object({
  body: segmentWriteV2Schema.optional(),
  path: z.object({
    segment_id: z.string(),
  }),
});

export const patchMarketingSegmentsSegmentIdResponseSchema = fullSegmentSchema;

export const patchMarketingSegmentsSegmentIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        field: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const postMarketingSendersDataSchema = z.object({
  body: z
    .object({
      address: z.string(),
      address_2: z.string().optional(),
      city: z.string(),
      country: z.string(),
      from: z.object({
        email: z.string(),
        name: z.string(),
      }),
      nickname: z.string(),
      reply_to: z
        .object({
          email: z.string(),
          name: z.string().optional(),
        })
        .optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postMarketingSendersResponseSchema = senderIDSchema;

export const postMarketingSendersErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteMarketingSinglesendsDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const deleteMarketingSinglesendsResponseSchema = z.void();

export const deleteMarketingSinglesendsErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMarketingSinglesendsDataSchema = z.object({
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
    })
    .optional(),
});

export const getMarketingSinglesendsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(singlesendResponseShortSchema).optional(),
});

export const getMarketingSinglesendsErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postMarketingSinglesendsDataSchema = z.object({
  body: singlesendRequestSchema.optional(),
});

export const postMarketingSinglesendsResponseSchema = singlesendResponseSchema;

export const postMarketingSinglesendsErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMarketingSinglesendsCategoriesResponseSchema = z.object({
  categories: z.array(z.string()).optional(),
});

export const getMarketingSinglesendsCategoriesErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postMarketingSinglesendsSearchDataSchema = z.object({
  body: singlesendSearchSchema.optional(),
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
    })
    .optional(),
});

export const postMarketingSinglesendsSearchResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(singlesendResponseShortSchema).optional(),
});

export const postMarketingSinglesendsSearchErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteMarketingSinglesendsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteMarketingSinglesendsIdResponseSchema = z.void();

export const deleteMarketingSinglesendsIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getMarketingSinglesendsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getMarketingSinglesendsIdResponseSchema = singlesendResponseSchema;

export const getMarketingSinglesendsIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchMarketingSinglesendsIdDataSchema = z.object({
  body: singlesendRequestSchema.optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const patchMarketingSinglesendsIdResponseSchema = singlesendResponseSchema;

export const patchMarketingSinglesendsIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postMarketingSinglesendsIdDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const postMarketingSinglesendsIdResponseSchema = singlesendResponseSchema;

export const postMarketingSinglesendsIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteMarketingSinglesendsIdScheduleDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteMarketingSinglesendsIdScheduleResponseSchema = singlesendScheduleSchema;

export const deleteMarketingSinglesendsIdScheduleErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const putMarketingSinglesendsIdScheduleDataSchema = z.object({
  body: z
    .object({
      send_at: z.literal('now'),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const putMarketingSinglesendsIdScheduleResponseSchema = z.object({
  send_at: z.string().optional(),
  status: z.literal('scheduled').optional(),
});

export const putMarketingSinglesendsIdScheduleErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        error_id: z.string().optional(),
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getallAutomationStatsDataSchema = z.object({
  query: z
    .object({
      automation_ids: z.array(z.string()).optional(),
      page_size: z.number().optional(),
      page_token: z.string().optional(),
    })
    .optional(),
});

export const automationsResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  results: z.array(
    z.object({
      aggregation: z.string(),
      id: z.string(),
      stats: metricsSchema.optional(),
      step_id: z.string(),
    }),
  ),
});

export const getallAutomationStatsErrorSchema = globalErrorResponseSchemaSchema;

export const getAutomationsStatsExportDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.string()).optional(),
      timezone: z.string().optional(),
    })
    .optional(),
});

export const getAutomationsStatsExportResponseSchema = z.string();

export const getAutomationsStatsExportErrorSchema = globalErrorResponseSchemaSchema;

export const getAutomationStatDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      aggregated_by: z.union([z.literal('day'), z.literal('total')]).optional(),
      end_date: z.string().optional(),
      group_by: z.array(z.literal('step_id')).optional(),
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      start_date: z.string().optional(),
      step_ids: z.array(z.string()).optional(),
      timezone: z.string().optional(),
    })
    .optional(),
});

export const getAutomationStatResponseSchema = automationsResponseSchema;

export const getAutomationStatErrorSchema = z.union([globalErrorResponseSchemaSchema, z.unknown()]);

export const getAutomationLinkStatDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      group_by: z.array(z.literal('step_id')).optional(),
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      step_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const automationsLinkStatsResponseSchema = z.object({
  _metadata: linkTrackingMetadataSchema,
  results: z.array(
    z.object({
      clicks: z.number(),
      step_id: z.string(),
      url: z.string(),
      url_location: z.number().optional(),
    }),
  ),
  total_clicks: z.number(),
});

export const getAutomationLinkStatErrorSchema = globalErrorResponseSchemaSchema;

export const getallSinglesendStatsDataSchema = z.object({
  query: z
    .object({
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      singlesend_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getallSinglesendStatsResponseSchema = singlesendsResponseSchema;

export const getallSinglesendStatsErrorSchema = globalErrorResponseSchemaSchema;

export const getSinglesendStatsExportDataSchema = z.object({
  query: z
    .object({
      ids: z.array(z.string()).optional(),
      timezone: z.string().optional(),
    })
    .optional(),
});

export const getSinglesendStatsExportResponseSchema = z.string();

export const getSinglesendStatsExportErrorSchema = z.unknown();

export const getSinglesendStatDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      aggregated_by: z.union([z.literal('day'), z.literal('total')]).optional(),
      end_date: z.string().optional(),
      group_by: z.array(z.union([z.literal('ab_variation'), z.literal('ab_phase')])).optional(),
      page_size: z.number().optional(),
      page_token: z.string().optional(),
      start_date: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
});

export const getSinglesendStatResponseSchema = singlesendsResponseSchema;

export const getSinglesendStatErrorSchema = z.union([globalErrorResponseSchemaSchema, z.unknown()]);

export const getSinglesendLinkStatDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      ab_phase_id: z.union([z.literal('test'), z.literal('send')]).optional(),
      ab_variation_id: z.string().optional(),
      group_by: z.array(z.union([z.literal('ab_variation'), z.literal('ab_phase')])).optional(),
      page_size: z.number().optional(),
      page_token: z.string().optional(),
    })
    .optional(),
});

export const getSinglesendLinkStatResponseSchema = singlesendsLinkStatsResponseSchema;

export const getSinglesendLinkStatErrorSchema = z.union([globalErrorResponseSchemaSchema, z.record(z.unknown())]);

export const postMarketingTestSendEmailDataSchema = z.object({
  body: z
    .object({
      custom_unsubscribe_url: z.string().optional(),
      emails: z.array(z.string()),
      from_address: z.string().optional(),
      sender_id: z.number().optional(),
      suppression_group_id: z.number().optional(),
      template_id: z.string(),
      version_id_override: z.string().optional(),
    })
    .optional(),
});

export const postMarketingTestSendEmailResponseSchema = z.record(z.unknown());

export const postMarketingTestSendEmailErrorSchema = globalErrorResponseSchemaSchema;

export const getMessagesDataSchema = z.object({
  headers: z.object({
    Authorization: z.string(),
    'X-Cursor': z.string().optional(),
    'X-Query-Id': z.string().optional(),
  }),
  query: z.object({
    limit: z.number().optional(),
    query: z.string(),
  }),
});

export const getMessagesResponseSchema = z.object({
  messages: z
    .array(
      emailActivityResponseCommonFieldsSchema.and(
        z.object({
          clicks_count: z.number().optional(),
          last_event_time: z.number().optional(),
          opens_count: z.number().optional(),
        }),
      ),
    )
    .optional(),
});

export const getMessagesErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postV3MessagesDownloadDataSchema = z.object({
  headers: z.object({
    Authorization: z.string(),
  }),
  query: z
    .object({
      query: z.string().optional(),
    })
    .optional(),
});

export const postV3MessagesDownloadResponseSchema = z.object({
  message: z.string().optional(),
  status: z.literal('pending').optional(),
});

export const postV3MessagesDownloadErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3MessagesDownloadDownloadUuidDataSchema = z.object({
  headers: z.object({
    Authorization: z.string(),
  }),
  path: z.object({
    download_uuid: z.string(),
  }),
});

export const getV3MessagesDownloadDownloadUuidResponseSchema = z.object({
  csv: z.string(),
  presigned_url: z.string().optional(),
});

export const getV3MessagesDownloadDownloadUuidErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3MessagesMsgIdDataSchema = z.object({
  headers: z.object({
    Authorization: z.string(),
  }),
  path: z.object({
    msg_id: z.string(),
  }),
});

export const getV3MessagesMsgIdResponseSchema = emailActivityResponseCommonFieldsSchema
  .and(
    z.object({
      api_key_id: z.string(),
      asm_group_id: z.number(),
      categories: z.array(z.string()),
      events: z.array(
        z.object({
          attempt_num: z.number().optional(),
          bounce_type: z.union([z.literal('soft'), z.literal('hard')]),
          event_name: z.union([
            z.literal('bounced'),
            z.literal('opened'),
            z.literal('clicked'),
            z.literal('processed'),
            z.literal('dropped'),
            z.literal('delivered'),
            z.literal('deferred'),
            z.literal('spam_report'),
            z.literal('unsubscribe'),
            z.literal('group_unsubscribe'),
            z.literal('group_resubscribe'),
          ]),
          http_user_agent: z.string(),
          mx_server: z.string(),
          processed: z.string(),
          reason: z.string().optional(),
          url: z.string().optional(),
        }),
      ),
      originating_ip: z.string(),
      outbound_ip: z.string(),
      outbound_ip_type: z.union([z.literal('dedicated'), z.literal('shared')]),
      teammate: z.string(),
      template_id: z.string(),
      unique_args: z.string(),
    }),
  )
  .and(
    z.object({
      from_email: z.string(),
      msg_id: z.string(),
      status: z.union([z.literal('processed'), z.literal('delivered'), z.literal('not delivered')]),
      subject: z.string(),
      to_email: z.string(),
      api_key_id: z.string(),
      asm_group_id: z.number(),
      categories: z.array(z.string()),
      events: z.array(
        z.object({
          attempt_num: z.number().optional(),
          bounce_type: z.union([z.literal('bounced'), z.literal('blocked'), z.literal('expired')]),
          event_name: z.union([
            z.literal('bounced'),
            z.literal('opened'),
            z.literal('clicked'),
            z.literal('processed'),
            z.literal('dropped'),
            z.literal('delivered'),
            z.literal('deferred'),
            z.literal('spam_report'),
            z.literal('unsubscribe'),
            z.literal('group_unsubscribe'),
            z.literal('group_resubscribe'),
          ]),
          http_user_agent: z.string(),
          mx_server: z.string(),
          processed: z.string(),
          reason: z.string().optional(),
          url: z.string(),
        }),
      ),
      originating_ip: z.string(),
      outbound_ip: z.string(),
      outbound_ip_type: z.union([z.literal('dedicated'), z.literal('shared')]),
      teammate: z.string(),
      template_id: z.string(),
      unique_args: z.string(),
    }),
  );

export const getV3MessagesMsgIdErrorSchema = z.union([
  z.unknown(),
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getPartnerSettingsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getPartnerSettingsResponseSchema = z.object({
  result: z
    .array(
      z.object({
        description: z.string(),
        enabled: z.boolean(),
        name: z.string(),
        title: z.string(),
      }),
    )
    .optional(),
});

export const getPartnerSettingsErrorSchema = z.unknown();

export const getPartnerSettingsNewRelicDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getPartnerSettingsNewRelicResponseSchema = partnerSettingsNewRelicSchema;

export const getPartnerSettingsNewRelicErrorSchema = z.unknown();

export const patchPartnerSettingsNewRelicDataSchema = z.object({
  body: z
    .object({
      enable_subuser_statistics: z.boolean().optional(),
      enabled: z.boolean().optional(),
      license_key: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchPartnerSettingsNewRelicResponseSchema = partnerSettingsNewRelicSchema;

export const patchPartnerSettingsNewRelicErrorSchema = z.unknown();

export const getScopesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getScopesResponseSchema = z.object({
  scopes: z.array(z.string()),
});

export const getScopesErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        field: z.unknown().optional(),
        message: z.string(),
      }),
    ),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getV3ScopesRequestsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getV3ScopesRequestsResponseSchema = z.array(
  z.object({
    email: z.string().optional(),
    first_name: z.string().optional(),
    id: z.number().optional(),
    last_name: z.string().optional(),
    scope_group_name: z.string().optional(),
    username: z.string().optional(),
  }),
);

export const getV3ScopesRequestsErrorSchema = z.unknown();

export const deleteV3ScopesRequestsRequestIdDataSchema = z.object({
  path: z.object({
    request_id: z.string(),
  }),
});

export const deleteV3ScopesRequestsRequestIdResponseSchema = z.void();

export const deleteV3ScopesRequestsRequestIdErrorSchema = z.union([
  z.unknown(),
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchV3ScopesRequestsApproveIdDataSchema = z.object({
  path: z.object({
    request_id: z.string(),
  }),
});

export const patchV3ScopesRequestsApproveIdResponseSchema = z.object({
  scope_group_name: z.string().optional(),
});

export const patchV3ScopesRequestsApproveIdErrorSchema = z.union([
  z.record(z.unknown()),
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getV3SendersDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getV3SendersResponseSchema = z.object({
  result: z.array(senderIDSchema).optional(),
});

export const getV3SendersErrorSchema = z.unknown();

export const postSendersDataSchema = z.object({
  body: senderIdRequestSchema
    .and(
      z.object({
        from: z.record(z.unknown()).optional(),
        reply_to: z.record(z.unknown()).optional(),
      }),
    )
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postSendersResponseSchema = senderIDSchema;

export const postSendersErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteV3SendersSenderIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sender_id: z.number(),
  }),
});

export const deleteV3SendersSenderIdResponseSchema = z.record(z.unknown());

export const deleteV3SendersSenderIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3SendersSenderIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sender_id: z.number(),
  }),
});

export const getV3SendersSenderIdResponseSchema = senderIDSchema;

export const getV3SendersSenderIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const patchV3SendersSenderIdDataSchema = z.object({
  body: senderIdRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sender_id: z.number(),
  }),
});

export const patchV3SendersSenderIdResponseSchema = senderIDSchema;

export const patchV3SendersSenderIdErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postV3SendersSenderIdResendVerificationDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sender_id: z.number(),
  }),
});

export const postV3SendersSenderIdResendVerificationResponseSchema = z.record(z.unknown());

export const postV3SendersSenderIdResendVerificationErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postSsoCertificatesDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
      integration_id: z.string(),
      public_certificate: z.string(),
    })
    .optional(),
});

export const postSsoCertificatesResponseSchema = ssoCertificateBodySchema;

export const postSsoCertificatesErrorSchema = ssoErrorResponseSchema;

export const deleteSsoCertificatesCertIdDataSchema = z.object({
  path: z.object({
    cert_id: z.string(),
  }),
});

export const deleteSsoCertificatesCertIdResponseSchema = ssoCertificateBodySchema;

export const deleteSsoCertificatesCertIdErrorSchema = ssoErrorResponseSchema;

export const getSsoCertificatesCertIdDataSchema = z.object({
  path: z.object({
    cert_id: z.string(),
  }),
});

export const getSsoCertificatesCertIdResponseSchema = ssoCertificateBodySchema;

export const getSsoCertificatesCertIdErrorSchema = ssoErrorResponseSchema;

export const patchSsoCertificatesCertIdDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
      integration_id: z.string().optional(),
      public_certificate: z.string().optional(),
    })
    .optional(),
  path: z.object({
    cert_id: z.string(),
  }),
});

export const getSsoIntegrationsDataSchema = z.object({
  query: z
    .object({
      si: z.boolean().optional(),
    })
    .optional(),
});

export const getSsoIntegrationsResponseSchema = z.array(ssoIntegrationSchema);

export const getSsoIntegrationsErrorSchema = ssoErrorResponseSchema;

export const postSsoIntegrationsDataSchema = z.object({
  body: createIntegrationRequestSchema.optional(),
});

export const postSsoIntegrationsResponseSchema = ssoIntegrationSchema;

export const postSsoIntegrationsErrorSchema = ssoErrorResponseSchema;

export const deleteSsoIntegrationsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteSsoIntegrationsIdResponseSchema = z.void();

export const deleteSsoIntegrationsIdErrorSchema = ssoErrorResponseSchema;

export const getSsoIntegrationsIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      si: z.boolean().optional(),
    })
    .optional(),
});

export const getSsoIntegrationsIdResponseSchema = ssoIntegrationSchema;

export const getSsoIntegrationsIdErrorSchema = ssoErrorResponseSchema;

export const patchSsoIntegrationsIdDataSchema = z.object({
  body: createIntegrationRequestSchema.optional(),
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      si: z.boolean().optional(),
    })
    .optional(),
});

export const patchSsoIntegrationsIdResponseSchema = ssoIntegrationSchema;

export const patchSsoIntegrationsIdErrorSchema = ssoErrorResponseSchema;

export const getSsoIntegrationsIntegrationIdCertificatesDataSchema = z.object({
  path: z.object({
    integration_id: z.string(),
  }),
});

export const getSsoIntegrationsIntegrationIdCertificatesResponseSchema = z.array(ssoCertificateBodySchema);

export const getSsoIntegrationsIntegrationIdCertificatesErrorSchema = ssoErrorResponseSchema;

export const postSsoTeammatesDataSchema = z.object({
  body: ssoTeammateRequestSchema.optional(),
});

export const postSsoTeammatesResponseSchema = ssoTeammateResponseSchema;

export const postSsoTeammatesErrorSchema = ssoErrorResponseSchema;

export const patchSsoTeammatesUsernameDataSchema = z.object({
  body: z
    .object({
      first_name: z.string().optional(),
      is_admin: z.boolean().optional(),
      last_name: z.string().optional(),
      scopes: z.array(z.string()).optional(),
    })
    .optional(),
  path: z.object({
    username: z.string(),
  }),
});

export const patchSsoTeammatesUsernameResponseSchema = ssoTeammatesPatchResponseSchema;

export const patchSsoTeammatesUsernameErrorSchema = ssoErrorResponseSchema;

export const getStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getStatsResponseSchema = z.array(
  z.object({
    date: z.string(),
    stats: z.array(
      z.object({
        metrics: statsAdvancedGlobalStatsSchema.optional(),
      }),
    ),
  }),
);

export const getStatsErrorSchema = z.unknown();

export const getSubusersDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getSubusersResponseSchema = z.array(subuserSchema);

export const getSubusersErrorSchema = globalErrorResponseSchemaSchema;

export const postSubusersDataSchema = z.object({
  body: z
    .object({
      email: z.string(),
      ips: z.array(z.string()),
      password: z.string(),
      username: z.string(),
    })
    .optional(),
});

export const postSubusersResponseSchema = subuserPostSchema;

export const postSubusersErrorSchema = z.union([globalErrorResponseSchemaSchema, z.record(z.unknown())]);

export const getSubusersReputationsDataSchema = z.object({
  query: z
    .object({
      usernames: z.string().optional(),
    })
    .optional(),
});

export const getSubusersReputationsResponseSchema = z.array(
  z.object({
    reputation: z.number(),
    username: z.string(),
  }),
);

export const getSubusersReputationsErrorSchema = z.unknown();

export const getSubusersStatsDataSchema = z.object({
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    start_date: z.string(),
    subusers: z.string(),
  }),
});

export const getSubusersStatsResponseSchema = categoryStatsSchema;

export const getSubusersStatsErrorSchema = z.unknown();

export const getSubusersStatsMonthlyDataSchema = z.object({
  query: z.object({
    date: z.string(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    sort_by_direction: z.union([z.literal('desc'), z.literal('asc')]).optional(),
    sort_by_metric: z
      .union([
        z.literal('blocks'),
        z.literal('bounces'),
        z.literal('clicks'),
        z.literal('delivered'),
        z.literal('opens'),
        z.literal('requests'),
        z.literal('unique_clicks'),
        z.literal('unique_opens'),
        z.literal('unsubscribes'),
      ])
      .optional(),
    subuser: z.string().optional(),
  }),
});

export const getSubusersStatsMonthlyResponseSchema = subuserStatsSchema;

export const getSubusersStatsMonthlyErrorSchema = z.unknown();

export const getSubusersStatsSumsDataSchema = z.object({
  query: z.object({
    aggregated_by: z.string().optional(),
    end_date: z.string().optional(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    sort_by_direction: z.union([z.literal('desc'), z.literal('asc')]).optional(),
    sort_by_metric: z.string().optional(),
    start_date: z.string(),
  }),
});

export const getSubusersStatsSumsResponseSchema = categoryStatsSchema;

export const getSubusersStatsSumsErrorSchema = z.unknown();

export const deleteSubusersSubuserNameDataSchema = z.object({
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const deleteSubusersSubuserNameResponseSchema = z.record(z.unknown());

export const deleteSubusersSubuserNameErrorSchema = globalErrorResponseSchemaSchema;

export const patchSubusersSubuserNameDataSchema = z.object({
  body: z
    .object({
      disabled: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const patchSubusersSubuserNameResponseSchema = z.record(z.unknown());

export const patchSubusersSubuserNameErrorSchema = globalErrorResponseSchemaSchema;

export const putSubusersSubuserNameIpsDataSchema = z.object({
  body: z.array(z.string()).optional(),
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const putSubusersSubuserNameIpsResponseSchema = z.object({
  ips: z.array(z.string()).optional(),
});

export const putSubusersSubuserNameIpsErrorSchema = globalErrorResponseSchemaSchema;

export const deleteSubusersSubuserNameMonitorDataSchema = z.object({
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const deleteSubusersSubuserNameMonitorResponseSchema = z.record(z.unknown());

export const deleteSubusersSubuserNameMonitorErrorSchema = globalErrorResponseSchemaSchema;

export const getSubusersSubuserNameMonitorDataSchema = z.object({
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const getSubusersSubuserNameMonitorResponseSchema = monitorSchema;

export const getSubusersSubuserNameMonitorErrorSchema = globalErrorResponseSchemaSchema;

export const postSubusersSubuserNameMonitorDataSchema = z.object({
  body: monitorSchema.optional(),
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const postSubusersSubuserNameMonitorResponseSchema = monitorSchema;

export const postSubusersSubuserNameMonitorErrorSchema = globalErrorResponseSchemaSchema;

export const putSubusersSubuserNameMonitorDataSchema = z.object({
  body: monitorSchema.optional(),
  path: z.object({
    subuser_name: z.string(),
  }),
});

export const putSubusersSubuserNameMonitorResponseSchema = monitorSchema;

export const putSubusersSubuserNameMonitorErrorSchema = globalErrorResponseSchemaSchema;

export const getSubusersSubuserNameStatsMonthlyDataSchema = z.object({
  path: z.object({
    subuser_name: z.string(),
  }),
  query: z.object({
    date: z.string(),
    limit: z.number().optional(),
    offset: z.number().optional(),
    sort_by_direction: z.union([z.literal('desc'), z.literal('asc')]).optional(),
    sort_by_metric: z.string().optional(),
  }),
});

export const getSubusersSubuserNameStatsMonthlyResponseSchema = subuserStatsSchema;

export const getSubusersSubuserNameStatsMonthlyErrorSchema = z.unknown();

export const deleteSuppressionBlocksDataSchema = z.object({
  body: z
    .object({
      delete_all: z.boolean().optional(),
      emails: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteSuppressionBlocksResponseSchema = z.record(z.unknown());

export const deleteSuppressionBlocksErrorSchema = z.unknown();

export const getSuppressionBlocksDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      end_time: z.number().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getSuppressionBlocksResponseSchema = blocksResponseSchema;

export const getSuppressionBlocksErrorSchema = z.unknown();

export const deleteSuppressionBlocksEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const deleteSuppressionBlocksEmailResponseSchema = z.record(z.unknown());

export const deleteSuppressionBlocksEmailErrorSchema = z.unknown();

export const getSuppressionBlocksEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getSuppressionBlocksEmailResponseSchema = blocksResponseSchema;

export const getSuppressionBlocksEmailErrorSchema = z.unknown();

export const deleteSuppressionBouncesDataSchema = z.object({
  body: z
    .object({
      delete_all: z.boolean().optional(),
      emails: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteSuppressionBouncesResponseSchema = z.unknown();

export const deleteSuppressionBouncesErrorSchema = globalErrorResponseSchemaSchema;

export const getSuppressionBouncesDataSchema = z.object({
  headers: z.object({
    Accept: z.string(),
    'on-behalf-of': z.string().optional(),
  }),
  query: z
    .object({
      end_time: z.number().optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getSuppressionBouncesResponseSchema = z.array(bounceResponseSchema);

export const getSuppressionBouncesErrorSchema = globalErrorResponseSchemaSchema;

export const deleteSuppressionBouncesEmailDataSchema = z.object({
  body: z.unknown().optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
  query: z.object({
    email_address: z.string(),
  }),
});

export const deleteSuppressionBouncesEmailResponseSchema = z.record(z.unknown());

export const deleteSuppressionBouncesEmailErrorSchema = globalErrorResponseSchemaSchema;

export const getSuppressionBouncesEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getSuppressionBouncesEmailResponseSchema = z.array(bounceResponseSchema);

export const getSuppressionBouncesEmailErrorSchema = z.unknown();

export const deleteSuppressionInvalidEmailsDataSchema = z.object({
  body: z
    .object({
      delete_all: z.boolean().optional(),
      emails: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteSuppressionInvalidEmailsResponseSchema = z.record(z.unknown());

export const deleteSuppressionInvalidEmailsErrorSchema = z.unknown();

export const getSuppressionInvalidEmailsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      end_time: z.number().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getSuppressionInvalidEmailsResponseSchema = z.array(invalidEmailSchema);

export const getSuppressionInvalidEmailsErrorSchema = z.unknown();

export const deleteSuppressionInvalidEmailsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const deleteSuppressionInvalidEmailsEmailResponseSchema = z.record(z.unknown());

export const deleteSuppressionInvalidEmailsEmailErrorSchema = z.unknown();

export const getSuppressionInvalidEmailsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getSuppressionInvalidEmailsEmailResponseSchema = z.array(invalidEmailSchema);

export const getSuppressionInvalidEmailsEmailErrorSchema = z.unknown();

export const deleteSuppressionSpamReportsDataSchema = z.object({
  body: z
    .object({
      delete_all: z.boolean().optional(),
      emails: z.array(z.string()).optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const deleteSuppressionSpamReportsResponseSchema = z.record(z.unknown());

export const deleteSuppressionSpamReportsErrorSchema = z.unknown();

export const getSuppressionSpamReportsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      end_time: z.number().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getSuppressionSpamReportsResponseSchema = spamReportsResponseSchema;

export const getSuppressionSpamReportsErrorSchema = z.unknown();

export const deleteSuppressionSpamReportsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const deleteSuppressionSpamReportsEmailResponseSchema = z.record(z.unknown());

export const deleteSuppressionSpamReportsEmailErrorSchema = z.unknown();

export const getSuppressionSpamReportsEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    email: z.string(),
  }),
});

export const getSuppressionSpamReportsEmailResponseSchema = spamReportsResponseSchema;

export const getSuppressionSpamReportsEmailErrorSchema = z.unknown();

export const getSuppressionUnsubscribesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      end_time: z.number().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getSuppressionUnsubscribesResponseSchema = z.array(
  z.object({
    created: z.number(),
    email: z.string(),
  }),
);

export const getSuppressionUnsubscribesErrorSchema = z.unknown();

export const getV3TeammatesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getV3TeammatesResponseSchema = z.object({
  result: z
    .array(
      z.object({
        address: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        email: z.string().optional(),
        first_name: z.string().optional(),
        is_admin: z.boolean().optional(),
        last_name: z.string().optional(),
        phone: z.string().optional(),
        state: z.string().optional(),
        user_type: z.union([z.literal('admin'), z.literal('owner'), z.literal('teammate')]).optional(),
        username: z.string().optional(),
        website: z.string().optional(),
        zip: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3TeammatesErrorSchema = z.unknown();

export const postV3TeammatesDataSchema = z.object({
  body: z
    .object({
      email: z.string(),
      is_admin: z.boolean(),
      scopes: z.array(z.string()),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postV3TeammatesResponseSchema = z.object({
  email: z.string().optional(),
  is_admin: z.boolean().optional(),
  scopes: z.array(z.unknown()).optional(),
  token: z.string().optional(),
});

export const postV3TeammatesErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3TeammatesPendingDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getV3TeammatesPendingResponseSchema = z.object({
  result: z
    .array(
      z.object({
        email: z.string().optional(),
        expiration_date: z.number().optional(),
        is_admin: z.boolean().optional(),
        scopes: z.array(z.string()).optional(),
        token: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3TeammatesPendingErrorSchema = z.unknown();

export const deleteV3TeammatesPendingTokenDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    token: z.string(),
  }),
});

export const deleteV3TeammatesPendingTokenResponseSchema = z.void();

export const deleteV3TeammatesPendingTokenErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postV3TeammatesPendingTokenResendDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    token: z.string(),
  }),
});

export const postV3TeammatesPendingTokenResendResponseSchema = z.object({
  email: z.string().optional(),
  is_admin: z.boolean().optional(),
  scopes: z.array(z.string()).optional(),
  token: z.string().optional(),
});

export const postV3TeammatesPendingTokenResendErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteV3TeammatesUsernameDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    username: z.string(),
  }),
});

export const deleteV3TeammatesUsernameResponseSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const deleteV3TeammatesUsernameErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getV3TeammatesUsernameDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    username: z.string(),
  }),
});

export const getV3TeammatesUsernameResponseSchema = z.object({
  address: z.string().optional(),
  address2: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  is_admin: z.boolean().optional(),
  last_name: z.string().optional(),
  phone: z.string().optional(),
  scopes: z.array(z.unknown()).optional(),
  state: z.string().optional(),
  user_type: z.union([z.literal('admin'), z.literal('owner'), z.literal('teammate')]).optional(),
  username: z.string().optional(),
  website: z.string().optional(),
  zip: z.string().optional(),
});

export const getV3TeammatesUsernameErrorSchema = z.unknown();

export const patchV3TeammatesUsernameDataSchema = z.object({
  body: z
    .object({
      is_admin: z.boolean(),
      scopes: z.array(z.string()),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    username: z.string(),
  }),
});

export const patchV3TeammatesUsernameResponseSchema = z.object({
  address: z.string().optional(),
  address2: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  is_admin: z.boolean().optional(),
  last_name: z.string().optional(),
  phone: z.string().optional(),
  scopes: z.array(z.string()).optional(),
  state: z.string().optional(),
  user_type: z.union([z.literal('admin'), z.literal('owner'), z.literal('teammate')]).optional(),
  username: z.string().optional(),
  website: z.string().optional(),
  zip: z.string().optional(),
});

export const patchV3TeammatesUsernameErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const getTemplatesDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    generations: z.union([z.literal('legacy'), z.literal('dynamic'), z.literal('legacy,dynamic')]).optional(),
    page_size: z.number(),
    page_token: z.string().optional(),
  }),
});

export const getTemplatesResponseSchema = z.object({
  _metadata: metadataSchema.optional(),
  result: z.array(transactionalTemplatesTemplateLeanSchema).optional(),
});

export const getTemplatesErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        '': z.string().optional(),
        error_id: z.string().optional(),
        message: z.string().optional(),
      }),
    )
    .optional(),
});

export const postTemplatesDataSchema = z.object({
  body: z
    .object({
      generation: z.union([z.literal('legacy'), z.literal('dynamic')]).optional(),
      name: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const transactionalTemplateSchema = transactionalTemplatesTemplateLeanSchema.and(
  z.object({
    warning: transactionalTemplateWarningSchema.optional(),
  }),
);

export const postTemplatesErrorSchema = z.unknown();

export const deleteTemplatesTemplateIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
  }),
});

export const deleteTemplatesTemplateIdResponseSchema = z.record(z.unknown());

export const deleteTemplatesTemplateIdErrorSchema = z.unknown();

export const getTemplatesTemplateIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
  }),
});

export const getTemplatesTemplateIdResponseSchema = transactionalTemplateSchema;

export const getTemplatesTemplateIdErrorSchema = z.unknown();

export const patchTemplatesTemplateIdDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
  }),
});

export const patchTemplatesTemplateIdResponseSchema = transactionalTemplateSchema;

export const patchTemplatesTemplateIdErrorSchema = z.unknown();

export const postTemplatesTemplateIdDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
  }),
});

export const postTemplatesTemplateIdResponseSchema = transactionalTemplateSchema;

export const postTemplatesTemplateIdErrorSchema = z.unknown();

export const postTemplatesTemplateIdVersionsDataSchema = z.object({
  body: transactionalTemplateVersionCreateSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
  }),
});

export const transactionalTemplateVersionOutputSchema = z
  .object({
    warnings: z.array(transactionalTemplateWarningSchema).optional(),
  })
  .and(transactionalTemplateVersionCreateSchema)
  .and(transactionalTemplatesVersionOutputLeanSchema);

export const postTemplatesTemplateIdVersionsErrorSchema = z.unknown();

export const deleteTemplatesTemplateIdVersionsVersionIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
    version_id: z.string(),
  }),
});

export const deleteTemplatesTemplateIdVersionsVersionIdResponseSchema = z.void();

export const deleteTemplatesTemplateIdVersionsVersionIdErrorSchema = z.unknown();

export const getTemplatesTemplateIdVersionsVersionIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
    version_id: z.string(),
  }),
});

export const getTemplatesTemplateIdVersionsVersionIdResponseSchema = transactionalTemplateVersionOutputSchema;

export const getTemplatesTemplateIdVersionsVersionIdErrorSchema = z.unknown();

export const patchTemplatesTemplateIdVersionsVersionIdDataSchema = z.object({
  body: transactionalTemplateVersionCreateSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
    version_id: z.string(),
  }),
});

export const patchTemplatesTemplateIdVersionsVersionIdResponseSchema = transactionalTemplateVersionOutputSchema;

export const patchTemplatesTemplateIdVersionsVersionIdErrorSchema = z.unknown();

export const postTemplatesTemplateIdVersionsVersionIdActivateDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    template_id: z.string(),
    version_id: z.string(),
  }),
});

export const postTemplatesTemplateIdVersionsVersionIdActivateResponseSchema = transactionalTemplateVersionOutputSchema;

export const postTemplatesTemplateIdVersionsVersionIdActivateErrorSchema = z.unknown();

export const getTrackingSettingsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getTrackingSettingsResponseSchema = z.object({
  result: z
    .array(
      z.object({
        description: z.string().optional(),
        enabled: z.boolean().optional(),
        name: z.string().optional(),
        title: z.string().optional(),
      }),
    )
    .optional(),
});

export const getTrackingSettingsErrorSchema = z.unknown();

export const getTrackingSettingsClickDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getTrackingSettingsClickResponseSchema = clickTrackingSchema;

export const getTrackingSettingsClickErrorSchema = z.unknown();

export const patchTrackingSettingsClickDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchTrackingSettingsClickResponseSchema = clickTrackingSchema;

export const patchTrackingSettingsClickErrorSchema = z.unknown();

export const getTrackingSettingsGoogleAnalyticsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getTrackingSettingsGoogleAnalyticsResponseSchema = googleAnalyticsSettingsSchema;

export const getTrackingSettingsGoogleAnalyticsErrorSchema = z.unknown();

export const patchTrackingSettingsGoogleAnalyticsDataSchema = z.object({
  body: googleAnalyticsSettingsSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchTrackingSettingsGoogleAnalyticsResponseSchema = googleAnalyticsSettingsSchema;

export const patchTrackingSettingsGoogleAnalyticsErrorSchema = z.unknown();

export const getTrackingSettingsOpenDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getTrackingSettingsOpenResponseSchema = z.object({
  enabled: z.boolean(),
});

export const getTrackingSettingsOpenErrorSchema = z.unknown();

export const patchTrackingSettingsOpenDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchTrackingSettingsOpenResponseSchema = z.object({
  enabled: z.boolean(),
});

export const patchTrackingSettingsOpenErrorSchema = z.unknown();

export const getTrackingSettingsSubscriptionDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getTrackingSettingsSubscriptionResponseSchema = subscriptionTrackingSettingsSchema;

export const getTrackingSettingsSubscriptionErrorSchema = z.unknown();

export const patchTrackingSettingsSubscriptionDataSchema = z.object({
  body: subscriptionTrackingSettingsSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchTrackingSettingsSubscriptionResponseSchema = subscriptionTrackingSettingsSchema;

export const patchTrackingSettingsSubscriptionErrorSchema = z.unknown();

export const getUserAccountDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserAccountResponseSchema = z.object({
  reputation: z.number(),
  type: z.union([z.literal('free'), z.literal('paid')]),
});

export const getUserAccountErrorSchema = z.unknown();

export const getUserCreditsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserCreditsResponseSchema = z.object({
  last_reset: z.string(),
  next_reset: z.string(),
  overage: z.number(),
  remain: z.number(),
  reset_frequency: z.string(),
  total: z.number(),
  used: z.number(),
});

export const getUserCreditsErrorSchema = z.unknown();

export const getUserEmailDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserEmailResponseSchema = z.object({
  email: z.string(),
});

export const getUserEmailErrorSchema = z.unknown();

export const putUserEmailDataSchema = z.object({
  body: z
    .object({
      email: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const putUserEmailResponseSchema = z.object({
  email: z.string(),
});

export const putUserEmailErrorSchema = z.unknown();

export const putUserPasswordDataSchema = z.object({
  body: z
    .object({
      new_password: z.string(),
      old_password: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const putUserPasswordResponseSchema = z.record(z.unknown());

export const putUserPasswordErrorSchema = z.unknown();

export const getUserProfileDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserProfileResponseSchema = z.object({
  address: z.string(),
  address2: z.string().optional(),
  city: z.string(),
  company: z.string(),
  country: z.string(),
  first_name: z.string(),
  last_name: z.string(),
  phone: z.string(),
  state: z.string(),
  website: z.string(),
  zip: z.string(),
});

export const getUserProfileErrorSchema = z.unknown();

export const patchUserProfileDataSchema = z.object({
  body: userProfileSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchUserProfileResponseSchema = userProfileSchema;

export const patchUserProfileErrorSchema = globalErrorResponseSchemaSchema;

export const getUserScheduledSendsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserScheduledSendsResponseSchema = z.array(userScheduledSendStatusSchema);

export const getUserScheduledSendsErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postUserScheduledSendsDataSchema = z.object({
  body: z
    .object({
      batch_id: z.string(),
      status: z.union([z.literal('pause'), z.literal('cancel')]),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postUserScheduledSendsResponseSchema = userScheduledSendStatusSchema;

export const postUserScheduledSendsErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteUserScheduledSendsBatchIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    batch_id: z.string(),
  }),
});

export const deleteUserScheduledSendsBatchIdResponseSchema = z.void();

export const deleteUserScheduledSendsBatchIdErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getUserScheduledSendsBatchIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    batch_id: z.string(),
  }),
});

export const getUserScheduledSendsBatchIdResponseSchema = z.array(userScheduledSendStatusSchema);

export const getUserScheduledSendsBatchIdErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchUserScheduledSendsBatchIdDataSchema = z.object({
  body: z
    .object({
      status: z.union([z.literal('cancel'), z.literal('pause')]),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    batch_id: z.string(),
  }),
});

export const patchUserScheduledSendsBatchIdResponseSchema = z.unknown();

export const patchUserScheduledSendsBatchIdErrorSchema = z.union([
  z.object({
    errors: z
      .array(
        z.object({
          field: z.string().optional(),
          help: z.record(z.unknown()).optional(),
          message: z.string().optional(),
        }),
      )
      .optional(),
    id: z.string().optional(),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getUserSettingsEnforcedTlsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserSettingsEnforcedTlsResponseSchema = enforcedTlsRequestResponseSchema;

export const getUserSettingsEnforcedTlsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchUserSettingsEnforcedTlsDataSchema = z.object({
  body: enforcedTlsRequestResponseSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchUserSettingsEnforcedTlsResponseSchema = enforcedTlsRequestResponseSchema;

export const patchUserSettingsEnforcedTlsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getUserUsernameDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserUsernameResponseSchema = z.object({
  user_id: z.number(),
  username: z.string(),
});

export const getUserUsernameErrorSchema = z.unknown();

export const putUserUsernameDataSchema = z.object({
  body: z
    .object({
      username: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const putUserUsernameResponseSchema = z.object({
  username: z.string(),
});

export const putUserUsernameErrorSchema = z.unknown();

export const getUserWebhooksEventSettingsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserWebhooksEventSettingsResponseSchema = eventWebhookResponseSchema;

export const getUserWebhooksEventSettingsErrorSchema = z.unknown();

export const patchUserWebhooksEventSettingsDataSchema = z.object({
  body: eventWebhookUpdateOauthRequestSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchUserWebhooksEventSettingsResponseSchema = eventWebhookResponseSchema;

export const patchUserWebhooksEventSettingsErrorSchema = z.unknown();

export const getUserWebhooksEventSettingsSignedDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserWebhooksEventSettingsSignedResponseSchema = z.object({
  public_key: z.string(),
});

export const getUserWebhooksEventSettingsSignedErrorSchema = z.unknown();

export const patchUserWebhooksEventSettingsSignedDataSchema = z.object({
  body: z
    .object({
      enabled: z.boolean(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const patchUserWebhooksEventSettingsSignedResponseSchema = z.object({
  public_key: z.string(),
});

export const patchUserWebhooksEventSettingsSignedErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        field: z.string().optional().nullable(),
        message: z.string(),
      }),
    )
    .optional(),
});

export const postUserWebhooksEventTestDataSchema = z.object({
  body: z
    .object({
      oauth_client_id: z.string().optional(),
      oauth_client_secret: z.string().optional(),
      oauth_token_url: z.string().optional(),
      url: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postUserWebhooksEventTestResponseSchema = z.void();

export const postUserWebhooksEventTestErrorSchema = z.unknown();

export const getUserWebhooksParseSettingsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const getUserWebhooksParseSettingsResponseSchema = z.object({
  result: z.array(parseSettingSchema).optional(),
});

export const getUserWebhooksParseSettingsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postUserWebhooksParseSettingsDataSchema = z.object({
  body: parseSettingSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postUserWebhooksParseSettingsResponseSchema = parseSettingSchema;

export const postUserWebhooksParseSettingsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteUserWebhooksParseSettingsHostnameDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    hostname: z.string(),
  }),
});

export const deleteUserWebhooksParseSettingsHostnameResponseSchema = z.record(z.unknown());

export const deleteUserWebhooksParseSettingsHostnameErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getUserWebhooksParseSettingsHostnameDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    hostname: z.string(),
  }),
});

export const getUserWebhooksParseSettingsHostnameResponseSchema = parseSettingSchema;

export const getUserWebhooksParseSettingsHostnameErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchUserWebhooksParseSettingsHostnameDataSchema = z.object({
  body: parseSettingSchema.optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    hostname: z.string(),
  }),
});

export const patchUserWebhooksParseSettingsHostnameResponseSchema = parseSettingSchema;

export const patchUserWebhooksParseSettingsHostnameErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getUserWebhooksParseStatsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z.object({
    aggregated_by: z.union([z.literal('day'), z.literal('week'), z.literal('month')]).optional(),
    end_date: z.string().optional(),
    limit: z.string().optional(),
    offset: z.string().optional(),
    start_date: z.string(),
  }),
});

export const getUserWebhooksParseStatsResponseSchema = z.array(
  z.object({
    date: z.string(),
    stats: z.array(
      z.object({
        metrics: z
          .object({
            received: z.number(),
          })
          .optional(),
      }),
    ),
  }),
);

export const getUserWebhooksParseStatsErrorSchema = z.unknown();

export const postValidationsEmailDataSchema = z.object({
  body: z
    .object({
      email: z.string(),
      source: z.string().optional(),
    })
    .optional(),
});

export const postValidationsEmailResponseSchema = z.object({
  result: z.object({
    checks: z.object({
      additional: z.object({
        has_known_bounces: z.boolean(),
        has_suspected_bounces: z.boolean(),
      }),
      domain: z.object({
        has_mx_or_a_record: z.boolean(),
        has_valid_address_syntax: z.boolean(),
        is_suspected_disposable_address: z.boolean(),
      }),
      local_part: z.object({
        is_suspected_role_address: z.boolean(),
      }),
    }),
    email: z.string(),
    host: z.string(),
    ip_address: z.string(),
    local: z.string(),
    score: z.number(),
    source: z.string().optional(),
    suggestion: z.string().optional(),
    verdict: z.union([z.literal('Valid'), z.literal('Risky'), z.literal('Invalid')]),
  }),
});

export const postValidationsEmailErrorSchema = z.unknown();

export const getVerifiedSendersDataSchema = z.object({
  query: z
    .object({
      id: z.number().optional(),
      lastSeenID: z.number().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const getVerifiedSendersResponseSchema = z.object({
  results: z.array(verifiedSenderResponseSchemaSchema).optional(),
});

export const getVerifiedSendersErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postVerifiedSendersDataSchema = z.object({
  body: verifiedSenderRequestSchemaSchema.optional(),
});

export const postVerifiedSendersResponseSchema = verifiedSenderResponseSchemaSchema;

export const postVerifiedSendersErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        field: z.string().optional(),
        message: z.string(),
      }),
    ),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getVerifiedSendersDomainsResponseSchema = z.object({
  results: z.object({
    hard_failures: z.array(z.string()),
    soft_failures: z.array(z.string()),
  }),
});

export const getVerifiedSendersDomainsErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postVerifiedSendersResendIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const postVerifiedSendersResendIdResponseSchema = z.record(z.unknown());

export const postVerifiedSendersResendIdErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        message: z.string(),
      }),
    ),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getVerifiedSendersStepsCompletedResponseSchema = z.object({
  results: z
    .object({
      domain_verified: z.boolean().optional(),
      sender_verified: z.boolean().optional(),
    })
    .optional(),
});

export const getVerifiedSendersStepsCompletedErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const getVerifiedSendersVerifyTokenDataSchema = z.object({
  path: z.object({
    token: z.string(),
  }),
});

export const getVerifiedSendersVerifyTokenResponseSchema = z.void();

export const getVerifiedSendersVerifyTokenErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const deleteVerifiedSendersIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteVerifiedSendersIdResponseSchema = z.record(z.unknown());

export const deleteVerifiedSendersIdErrorSchema = z.union([
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z
      .array(
        z.object({
          error_id: z.string(),
          message: z.string(),
        }),
      )
      .optional(),
  }),
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const patchVerifiedSendersIdDataSchema = z.object({
  body: verifiedSenderRequestSchemaSchema.optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const patchVerifiedSendersIdResponseSchema = verifiedSenderResponseSchemaSchema;

export const patchVerifiedSendersIdErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        field: z.string().optional(),
        message: z.string(),
      }),
    ),
  }),
  globalErrorResponseSchemaSchema,
  z.object({
    errors: z.array(
      z.object({
        error_id: z.string(),
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z
      .array(
        z.object({
          message: z.string().optional(),
        }),
      )
      .optional(),
  }),
]);

export const postWhitelabelDnsEmailDataSchema = z.object({
  body: z
    .object({
      domain_id: z.number(),
      email: z.string(),
      link_id: z.number(),
      message: z.string().optional(),
    })
    .optional(),
});

export const postWhitelabelDnsEmailResponseSchema = z.void();

export const postWhitelabelDnsEmailErrorSchema = z.object({
  errors: z
    .object({
      error: z.string().optional(),
      field: z.string().optional(),
    })
    .optional(),
});

export const getWhitelabelDomainsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      domain: z.string().optional(),
      exclude_subusers: z.boolean().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getWhitelabelDomainsResponseSchema = domainAuthentication200ResponseSchema;

export const getWhitelabelDomainsErrorSchema = z.unknown();

export const postWhitelabelDomainsDataSchema = z.object({
  body: z
    .object({
      automatic_security: z.boolean().optional(),
      custom_dkim_selector: z.string().optional(),
      custom_spf: z.boolean().optional(),
      default: z.boolean().optional(),
      domain: z.string(),
      ips: z.array(z.string()).optional(),
      subdomain: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postWhitelabelDomainsResponseSchema = authenticationDomainSchema;

export const postWhitelabelDomainsErrorSchema = z.unknown();

export const getWhitelabelDomainsDefaultDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      domain: z.string().optional(),
    })
    .optional(),
});

export const getWhitelabelDomainsDefaultResponseSchema = domainAuthentication200ResponseSchema;

export const getWhitelabelDomainsDefaultErrorSchema = z.unknown();

export const deleteWhitelabelDomainsSubuserDataSchema = z.object({
  query: z
    .object({
      username: z.string().optional(),
    })
    .optional(),
});

export const deleteWhitelabelDomainsSubuserResponseSchema = z.record(z.unknown());

export const deleteWhitelabelDomainsSubuserErrorSchema = z.unknown();

export const getWhitelabelDomainsSubuserDataSchema = z.object({
  query: z.object({
    username: z.string(),
  }),
});

export const getWhitelabelDomainsSubuserResponseSchema = domainAuthenticationDomainSpfSchema;

export const getWhitelabelDomainsSubuserErrorSchema = z.unknown();

export const deleteWhitelabelDomainsDomainIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    domain_id: z.string(),
  }),
});

export const deleteWhitelabelDomainsDomainIdResponseSchema = z.record(z.unknown());

export const deleteWhitelabelDomainsDomainIdErrorSchema = z.unknown();

export const getWhitelabelDomainsDomainIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    domain_id: z.string(),
  }),
});

export const getWhitelabelDomainsDomainIdResponseSchema = authenticationDomainSchema;

export const getWhitelabelDomainsDomainIdErrorSchema = z.unknown();

export const patchWhitelabelDomainsDomainIdDataSchema = z.object({
  body: z
    .object({
      custom_spf: z.boolean().optional(),
      default: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    domain_id: z.string(),
  }),
});

export const patchWhitelabelDomainsDomainIdResponseSchema = domainAuthentication200ResponseSchema;

export const patchWhitelabelDomainsDomainIdErrorSchema = z.unknown();

export const postWhitelabelDomainsDomainIdSubuserDataSchema = z.object({
  body: z
    .object({
      username: z.string(),
    })
    .optional(),
  path: z.object({
    domain_id: z.number(),
  }),
});

export const postWhitelabelDomainsDomainIdSubuserResponseSchema = domainAuthenticationDomainSpfSchema;

export const postWhitelabelDomainsDomainIdSubuserErrorSchema = z.unknown();

export const postWhitelabelDomainsIdIpsDataSchema = z.object({
  body: z
    .object({
      ip: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const postWhitelabelDomainsIdIpsResponseSchema = domainAuthenticationDomainSpfSchema;

export const postWhitelabelDomainsIdIpsErrorSchema = z.unknown();

export const deleteWhitelabelDomainsIdIpsIpDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
    ip: z.string(),
  }),
});

export const deleteWhitelabelDomainsIdIpsIpResponseSchema = domainAuthenticationDomainSpfSchema;

export const deleteWhitelabelDomainsIdIpsIpErrorSchema = z.unknown();

export const postWhitelabelDomainsIdValidateDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const postWhitelabelDomainsIdValidateResponseSchema = z.object({
  id: z.number().optional(),
  valid: z.boolean().optional(),
  validation_results: z
    .object({
      dkim1: z
        .object({
          reason: z.string().optional().nullable(),
          valid: z.boolean().optional(),
        })
        .optional(),
      dkim2: z
        .object({
          reason: z.string().optional().nullable(),
          valid: z.boolean().optional(),
        })
        .optional(),
      mail_cname: z
        .object({
          reason: z.string().optional().nullable(),
          valid: z.boolean().optional(),
        })
        .optional(),
      spf: z
        .object({
          reason: z.string().optional().nullable(),
          valid: z.boolean().optional(),
        })
        .optional(),
    })
    .optional(),
});

export const postWhitelabelDomainsIdValidateErrorSchema = z.object({
  errors: z
    .array(
      z.object({
        message: z.string(),
      }),
    )
    .optional(),
});

export const getWhitelabelIpsDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      ip: z.string().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getWhitelabelIpsResponseSchema = z.array(reverseDnsSchema);

export const getWhitelabelIpsErrorSchema = z.unknown();

export const postWhitelabelIpsDataSchema = z.object({
  body: z
    .object({
      domain: z.string(),
      ip: z.string(),
      subdomain: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postWhitelabelIpsResponseSchema = reverseDnsSchema;

export const postWhitelabelIpsErrorSchema = z.unknown();

export const deleteWhitelabelIpsIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const deleteWhitelabelIpsIdResponseSchema = z.record(z.unknown());

export const deleteWhitelabelIpsIdErrorSchema = z.unknown();

export const getWhitelabelIpsIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const getWhitelabelIpsIdResponseSchema = reverseDnsSchema;

export const getWhitelabelIpsIdErrorSchema = z.unknown();

export const postWhitelabelIpsIdValidateDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const postWhitelabelIpsIdValidateResponseSchema = z.object({
  id: z.number(),
  valid: z.boolean(),
  validation_results: z.object({
    a_record: z
      .object({
        reason: z.string().nullable(),
        valid: z.boolean(),
      })
      .optional(),
  }),
});

export const postWhitelabelIpsIdValidateErrorSchema = z.union([
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
  z.object({
    errors: z.array(
      z.object({
        message: z.string(),
      }),
    ),
  }),
]);

export const getWhitelabelLinksDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      limit: z.number().optional(),
    })
    .optional(),
});

export const getWhitelabelLinksResponseSchema = z.array(linkBranding200ResponseSchema);

export const getWhitelabelLinksErrorSchema = z.unknown();

export const postWhitelabelLinksDataSchema = z.object({
  body: z
    .object({
      default: z.boolean().optional(),
      domain: z.string(),
      subdomain: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
});

export const postWhitelabelLinksResponseSchema = linkBranding200ResponseSchema;

export const postWhitelabelLinksErrorSchema = z.unknown();

export const getWhitelabelLinksDefaultDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      domain: z.string().optional(),
    })
    .optional(),
});

export const getWhitelabelLinksDefaultResponseSchema = linkBranding200ResponseSchema;

export const getWhitelabelLinksDefaultErrorSchema = z.unknown();

export const deleteWhitelabelLinksSubuserDataSchema = z.object({
  query: z.object({
    username: z.string(),
  }),
});

export const deleteWhitelabelLinksSubuserResponseSchema = z.record(z.unknown());

export const deleteWhitelabelLinksSubuserErrorSchema = z.unknown();

export const getWhitelabelLinksSubuserDataSchema = z.object({
  query: z.object({
    username: z.string(),
  }),
});

export const getWhitelabelLinksSubuserResponseSchema = linkBranding200ResponseSchema;

export const getWhitelabelLinksSubuserErrorSchema = z.unknown();

export const deleteWhitelabelLinksIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const deleteWhitelabelLinksIdResponseSchema = z.record(z.unknown());

export const deleteWhitelabelLinksIdErrorSchema = z.unknown();

export const getWhitelabelLinksIdDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const getWhitelabelLinksIdResponseSchema = linkBranding200ResponseSchema;

export const getWhitelabelLinksIdErrorSchema = z.unknown();

export const patchWhitelabelLinksIdDataSchema = z.object({
  body: z
    .object({
      default: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const patchWhitelabelLinksIdResponseSchema = linkBranding200ResponseSchema;

export const patchWhitelabelLinksIdErrorSchema = z.unknown();

export const postWhitelabelLinksIdValidateDataSchema = z.object({
  headers: z
    .object({
      'on-behalf-of': z.string().optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const postWhitelabelLinksIdValidateResponseSchema = z.object({
  id: z.number(),
  valid: z.boolean(),
  validation_results: z.object({
    domain_cname: z.object({
      reason: z.string().nullable(),
      valid: z.boolean(),
    }),
    owner_cname: z
      .object({
        reason: z.string().nullable(),
        valid: z.boolean(),
      })
      .optional(),
  }),
});

export const postWhitelabelLinksIdValidateErrorSchema = z.object({
  errors: z.array(
    z.object({
      message: z.string(),
    }),
  ),
});

export const postWhitelabelLinksLinkIdSubuserDataSchema = z.object({
  body: z
    .object({
      username: z.string().optional(),
    })
    .optional(),
  path: z.object({
    link_id: z.number(),
  }),
});

export const postWhitelabelLinksLinkIdSubuserResponseSchema = linkBranding200ResponseSchema;

export const postWhitelabelLinksLinkIdSubuserErrorSchema = z.unknown();

export const contactDetailsSchema = z.object({
  _metadata: selfmetadataSchema.optional(),
  address_line_1: z.string().optional(),
  address_line_2: z.string().optional(),
  alternate_emails: z.array(z.string()).optional(),
  city: z.string().optional(),
  country: z.string().optional(),
  created_at: z.string(),
  custom_fields: customFieldsByNameSchema.optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string(),
  last_name: z.string().optional(),
  list_ids: z.array(z.string()),
  postal_code: z.string().optional(),
  state_province_region: z.string().optional(),
  updated_at: z.string(),
});

export const postContactdbSegmentsResponseSchema = contactdbSegmentsWithIdSchema;

export const postDesignsResponseSchema = designOutputSchema;

export const getMailboxProvidersStatsResponseSchema = z.array(
  z.object({
    date: z.string().optional(),
    stats: z
      .array(
        z.object({
          metrics: advancedStatsMailboxProviderSchema.optional(),
          name: z.string().optional(),
          type: z.string().optional(),
        }),
      )
      .optional(),
  }),
);

export const putMcContactsDataSchema = z.object({
  body: z
    .object({
      contacts: z.array(contactRequestSchema),
      list_ids: z.array(z.string()).optional(),
    })
    .optional(),
});

export const postMarketingSegmentsResponseSchema = fullSegmentSchema;

export const getSegmentsResponseSchema = allSegmentsResponseSchema;

export const getallAutomationStatsResponseSchema = automationsResponseSchema;

export const getAutomationLinkStatResponseSchema = automationsLinkStatsResponseSchema;

export const postTemplatesResponseSchema = transactionalTemplateSchema;

export const postTemplatesTemplateIdVersionsResponseSchema = transactionalTemplateVersionOutputSchema;
