// This file is auto-generated by @hey-api/openapi-ts

export type _metadata = {
  count?: number;
  next?: string;
  prev?: string;
  self?: string;
};

export type abbv_message = {
  clicks_count: number;
  from_email: string;
  /**
   * iso 8601 format
   */
  last_event_time: string;
  msg_id: string;
  opens_count: number;
  status: 'processed' | 'delivered' | 'not_delivered';
  subject: string;
  to_email: string;
};

export type status = 'processed' | 'delivered' | 'not_delivered';

export type abtest_summary = {
  /**
   * How long the A/B Testing will last
   */
  duration: string;
  /**
   * Last day to select an A/B Test Winner
   */
  expiration_date: string | null;
  /**
   * What percentage of your recipient will be included in your A/B testing
   */
  test_percentage: number;
  /**
   * What differs between the A/B tests
   */
  type: 'subject' | 'content';
  /**
   * How the winner will be decided
   */
  winner_criteria: 'open' | 'click' | 'manual';
  /**
   * When the winner was selected
   */
  winner_selected_at: string | null;
  /**
   * Winner of the A/B Test
   */
  winning_template_id: string;
} | null;

/**
 * What differs between the A/B tests
 */
export type type = 'subject' | 'content';

/**
 * How the winner will be decided
 */
export type winner_criteria = 'open' | 'click' | 'manual';

/**
 * The individual events and their stats.
 */
export type advanced_stats_clicks = {
  /**
   * The number of links that were clicked in your emails.
   */
  clicks?: number;
  /**
   * The number of unique recipients who clicked links in your emails.
   */
  unique_clicks?: number;
};

/**
 * The individual events and their stats.
 */
export type advanced_stats_clicks_opens = advanced_stats_clicks & advanced_stats_opens;

/**
 * The individual events and their stats.
 */
export type advanced_stats_mailbox_provider = advanced_stats_clicks_opens & {
  /**
   * The number of emails that were not allowed to be delivered by ISPs.
   */
  blocks?: number;
  /**
   * The number of emails that bounced instead of being delivered.
   */
  bounces?: number;
  /**
   * The number of emails that temporarily could not be delivered.
   */
  deferred?: number;
  /**
   * The number of emails SendGrid was able to confirm were actually delivered to a recipient.
   */
  delivered?: number;
  /**
   * The number of emails that were not delivered due to the recipient email address being on a suppression list.
   */
  drops?: number;
  /**
   * Requests from your website, application, or mail client via SMTP Relay or the Web API that SendGrid processed.
   */
  processed?: number;
  /**
   * The number of emails that were requested to be delivered.
   */
  requests?: number;
  /**
   * The number of recipients who marked your email as spam.
   */
  spam_reports?: number;
};

/**
 * The individual events and their stats.
 */
export type advanced_stats_opens = {
  /**
   * The total number of times your emails were opened by recipients.
   */
  opens?: number;
  /**
   * The number of unique recipients who opened your emails.
   */
  unique_opens?: number;
};

export type all_segments_response = {
  _metadata?: _metadata;
  /**
   * Total number of contacts present in the segment
   */
  contacts_count: number;
  /**
   * ISO8601 timestamp of when the object was created
   */
  created_at: string;
  /**
   * ID assigned to the segment when created.
   */
  id: string;
  /**
   * Name of the segment.
   */
  name: string;
  /**
   * ISO8601 timestamp of when the samples will be next updated
   */
  next_sample_update: string;
  /**
   * The array of list ids to filter contacts on when building this segment. It allows only one such list id for now. We will support more in future
   */
  parent_list_ids: Array<string>;
  /**
   * If not set, segment contains a query for use with Segment v1 APIs. If set to '2', segment contains a SQL query for use in v2.
   */
  query_version: string;
  /**
   * ISO8601 timestamp of when the samples were last updated
   */
  sample_updated_at: string;
  status: segment_status_response;
  /**
   * ISO8601 timestamp of when the object was last updated
   */
  updated_at: string;
};

export type api_error = {
  error_id: string;
  field: string;
  message: string;
};

export type api_errors = {
  errors?: Array<api_error>;
};

export type api_key_name_id = {
  /**
   * The ID of your API Key.
   */
  api_key_id?: string;
  /**
   * The name of your API Key.
   */
  name?: string;
};

export type api_key_name_id_scopes = {
  /**
   * The permissions this API Key has access to.
   */
  scopes?: Array<string>;
} & api_key_name_id;

export type authentication_domain = {
  /**
   * Indicates if this authenticated domain uses automated security.
   */
  automatic_security: boolean;
  /**
   * Indicates whether this authenticated domain uses custom SPF.
   */
  custom_spf: boolean;
  /**
   * Indicates if this is the default authenticated domain.
   */
  default: boolean;
  /**
   * The DNS records used to authenticate the sending domain.
   */
  dns: {
    /**
     * A DNS record.
     */
    dkim1: {
      /**
       * The DNS record.
       */
      data: string;
      /**
       * The domain that this DNS record was created for.
       */
      host: string;
      /**
       * The type of DNS record.
       */
      type: string;
      /**
       * Indicates if this is a valid DNS record.
       */
      valid: boolean;
    };
    /**
     * A DNS record.
     */
    dkim2: {
      /**
       * The DNS record.
       */
      data: string;
      /**
       * The domain that this DNS record was created for.
       */
      host: string;
      /**
       * The type of DNS record.
       */
      type: string;
      /**
       * Indicates if this is a valid DNS record.
       */
      valid: boolean;
    };
    /**
     * The CNAME for your sending domain that points to sendgrid.net.
     */
    mail_cname: {
      /**
       * The CNAME record.
       */
      data: string;
      /**
       * The domain that this CNAME is created for.
       */
      host: string;
      /**
       * The type of DNS record.
       */
      type: string;
      /**
       * Indicates if this is a valid CNAME.
       */
      valid: boolean;
    };
  };
  /**
   * The domain to be authenticated.
   */
  domain: string;
  /**
   * The ID of the authenticated domain.
   */
  id: number;
  /**
   * The IPs to be included in the custom SPF record for this authenticated domain.
   */
  ips: Array<string>;
  /**
   * Indicates if this authenticated domain was created using the legacy whitelabel tool. If it is a legacy whitelabel, it will still function, but you'll need to create a new authenticated domain if you need to update it.
   */
  legacy: boolean;
  /**
   * The subdomain to use for this authenticated domain.
   */
  subdomain: string;
  /**
   * The ID of the user that this domain is associated with.
   */
  user_id: number;
  /**
   * The username that this domain will be associated with.
   */
  username: string;
  /**
   * Indicates if this is a valid authenticated domain.
   */
  valid: boolean;
};

export type automations_link_stats_response = {
  _metadata: link_tracking_metadata;
  results: Array<{
    /**
     * The number of clicks on this particular link.
     */
    clicks: number;
    /**
     * This is the ID of the step if the stats were requested to be grouped by `step_id`.
     */
    step_id: string;
    /**
     * This is the URL of the link clicked. If `{{custom_fields}}` are part of the URL, they will be included.
     */
    url: string;
    /**
     * This is the location of the link clicked in each Automation step. Links are located according to their position within the message; the topmost link has index `0`.
     */
    url_location?: number;
  }>;
  total_clicks: number;
};

export type automations_response = {
  _metadata?: metadata;
  results: Array<{
    /**
     * This describes the time unit to which the stat is rolled up. It is based on the `aggregated_by` parameter included in the request. It can be "total" or the date (in YYYY-MM-DD format) the stats are for.
     */
    aggregation: string;
    /**
     * This is the ID of the Automation you are requesting stats for.
     */
    id: string;
    stats?: metrics;
    /**
     * This is the ID of the step if the stats were requested to be grouped by `step_id`.
     */
    step_id: string;
  }>;
};

export type blocks_response = Array<{
  /**
   * A Unix timestamp indicating when the email address was added to the blocks list.
   */
  created: number;
  /**
   * The email address that was added to the block list.
   */
  email: string;
  /**
   * An explanation for the reason of the block.
   */
  reason: string;
  /**
   * The status of the block.
   */
  status: string;
}>;

export type bounce_response = {
  /**
   * The unix timestamp for when the bounce record was created at SendGrid.
   */
  created?: number;
  /**
   * The email address that was added to the bounce list.
   */
  email?: string;
  /**
   * The reason for the bounce. This typically will be a bounce code, an enhanced code, and a description.
   */
  reason?: string;
  /**
   * Enhanced SMTP bounce response
   */
  status?: string;
};

export type campaign_request = {
  /**
   * The categories you would like associated to this campaign.
   */
  categories?: Array<string> | null;
  /**
   * This is the url of the custom unsubscribe page that you provide for customers to unsubscribe from your suppression groups.
   */
  custom_unsubscribe_url?: string | null;
  /**
   * The editor used in the UI.
   */
  editor?: 'code' | 'design';
  /**
   * The HTML of your marketing email.
   */
  html_content?: string | null;
  /**
   * The pool of IPs that you would like to send this email from.
   */
  ip_pool?: string | null;
  /**
   * The IDs of the lists you are sending this campaign to. You can have both segment IDs and list IDs
   */
  list_ids?: Array<number> | null;
  /**
   * The plain text content of your emails.
   */
  plain_content?: string | null;
  /**
   * The segment IDs that you are sending this list to. You can have both segment IDs and list IDs. Segments are limited to 10 segment IDs.
   */
  segment_ids?: Array<number> | null;
  /**
   * The ID of the "sender" identity that you have created. Your recipients will see this as the "from" on your marketing emails.
   */
  sender_id?: number | null;
  /**
   * The subject of your campaign that your recipients will see.
   */
  subject?: string | null;
  /**
   * The suppression group that this marketing email belongs to, allowing recipients to opt-out of emails of this type.
   */
  suppression_group_id?: number | null;
  /**
   * The display title of your campaign. This will be viewable by you in the Marketing Campaigns UI.
   */
  title: string;
};

/**
 * The editor used in the UI.
 */
export type editor = 'code' | 'design';

export type campaign_response = campaign_request & {
  id?: number;
  /**
   * The status of your campaign.
   */
  status: string;
};

export type category_stats = {
  /**
   * The date the statistics were gathered.
   */
  date: string;
  stats?: Array<{
    metrics?: {
      /**
       * The number of emails that were not allowed to be delivered by ISPs.
       */
      blocks: number;
      /**
       * The number of emails that were dropped because of a bounce.
       */
      bounce_drops: number;
      /**
       * The number of emails that bounced instead of being delivered.
       */
      bounces: number;
      /**
       * The number of links that were clicked.
       */
      clicks: number;
      /**
       * The number of emails that temporarily could not be delivered.
       */
      deferred: number;
      /**
       * The number of emails SendGrid was able to confirm were actually delivered to a recipient.
       */
      delivered: number;
      /**
       * The number of recipients who had malformed email addresses or whose mail provider reported the address as invalid.
       */
      invalid_emails: number;
      /**
       * The total number of times your emails were opened by recipients.
       */
      opens: number;
      /**
       * Requests from your website, application, or mail client via SMTP Relay or the API that SendGrid processed.
       */
      processed: number;
      /**
       * The number of emails that were requested to be delivered.
       */
      requests: number;
      /**
       * The number of emails that were dropped due to a recipient previously marking your emails as spam.
       */
      spam_report_drops: number;
      /**
       * The number of recipients who marked your email as spam.
       */
      spam_reports: number;
      /**
       * The number of unique recipients who clicked links in your emails.
       */
      unique_clicks: number;
      /**
       * The number of unique recipients who opened your emails.
       */
      unique_opens: number;
      /**
       * The number of emails dropped due to a recipient unsubscribing from your emails.
       */
      unsubscribe_drops: number;
      /**
       * The number of recipients who unsubscribed from your emails.
       */
      unsubscribes: number;
    };
    /**
     * The name of the category.
     */
    name?: string;
    /**
     * How you are segmenting your statistics.
     */
    type: string;
  }>;
};

export type cc_bcc_email_object = {
  /**
   * The intended recipient's email address.
   */
  email: string;
  /**
   * The intended recipient's name.
   */
  name?: string;
};

export type click_tracking = {
  /**
   * Indicates if click tracking is enabled for plain text emails.
   */
  enable_text: boolean;
  /**
   * Indicates if click tracking is enabled or disabled.
   */
  enabled: boolean;
};

export type contact_details = {
  _metadata?: selfmetadata;
  address_line_1?: string;
  address_line_2?: string;
  alternate_emails?: Array<string>;
  city?: string;
  country?: string;
  /**
   * The ISO8601 timestamp when the contact was created.
   */
  created_at: string;
  custom_fields?: custom_fields_by_name;
  email?: string;
  first_name?: string;
  id: string;
  last_name?: string;
  list_ids: Array<string>;
  postal_code?: string;
  state_province_region?: string;
  /**
   * The ISO8601 timestamp when the contact was updated.
   */
  updated_at: string;
};

export type contact_details2 = {
  _metadata?: selfmetadata;
  address_line_1?: string;
  address_line_2?: string;
  alternate_emails?: Array<string> | null;
  city?: string;
  country?: string;
  created_at: string;
  custom_fields?: {
    [key: string]: unknown;
  };
  email?: string;
  facebook?: string;
  first_name?: string;
  id: string;
  last_name?: string;
  line?: string;
  list_ids: Array<string>;
  phone_number?: string;
  postal_code?: string;
  segment_ids?: Array<string>;
  state_province_region?: string;
  unique_name?: string;
  updated_at: string;
  whatsapp?: string;
};

export type contact_details3 = {
  _metadata?: selfmetadata;
  address_line_1?: string;
  address_line_2?: string;
  alternate_emails?: Array<string>;
  city?: string;
  country?: string;
  created_at: string;
  custom_fields?: {
    [key: string]: unknown;
  };
  email?: string;
  facebook?: string;
  first_name?: string;
  id: string;
  last_name?: string;
  line?: string;
  list_ids: Array<string>;
  phone_number?: string;
  postal_code?: string;
  segment_ids: Array<string>;
  state_province_region?: string;
  unique_name?: string;
  updated_at: string;
  whatsapp?: string;
};

export type contact_export = {
  _metadata?: metadata;
  /**
   * The ISO8601 timestamp when the export was completed.
   */
  completed_at?: string;
  /**
   * The total number of exported contacts.
   */
  contact_count?: number;
  /**
   * The ISO8601 timestamp when the export was begun.
   */
  created_at: string;
  /**
   * The ISO8601 timestamp when the exported file on S3 will expire.
   */
  expires_at: string;
  id: string;
  /**
   * A human readable message if the status is `failure`.
   */
  message?: string;
  /**
   * The export job's status. Allowed values: `pending`, `ready`, or `failure`.
   */
  status: 'pending' | 'ready' | 'failure';
  /**
   * The ISO8601 timestamp when the export was updated.
   */
  updated_at: string;
  /**
   * One or more download URLs for the contact file if the status is `ready`.
   */
  urls?: Array<string>;
};

/**
 * The export job's status. Allowed values: `pending`, `ready`, or `failure`.
 */
export type status2 = 'pending' | 'ready' | 'failure';

export type contact_import = {
  /**
   * The ISO8601 timestamp when the job was finished.
   */
  finished_at?: string;
  /**
   * The job ID.
   */
  id?: string;
  /**
   * The job type. Allowed values: `upsert`, or `delete`.
   */
  job_type?: string;
  /**
   * Result map of the import job.
   */
  results?: {
    /**
     * Created contact count from the import.
     */
    created_count?: number;
    /**
     * Count of deleted contacts that resulted in error.
     */
    deleted_count?: number;
    /**
     * Count of imported contacts that resulted in error.
     */
    errored_count?: number;
    /**
     * The download URL of the file which provides information about any errors.
     */
    errors_url?: string;
    /**
     * Requested contact count from the import.
     */
    requested_count?: number;
    /**
     * Updated contact count from the import.
     */
    updated_count?: number;
  };
  /**
   * The ISO8601 timestamp when the job was created.
   */
  started_at?: string;
  /**
   * The job state. Allowed values: `pending`, `completed`, `errored`, or `failed`.
   */
  status?: string;
};

export type contact_request = {
  /**
   * The first line of the address.
   */
  address_line_1?: string;
  /**
   * An optional second line for the address.
   */
  address_line_2?: string;
  /**
   * Additional emails associated with the contact.
   */
  alternate_emails?: Array<string>;
  /**
   * The contact's city.
   */
  city?: string;
  /**
   * The contact's country. Can be a full name or an abbreviation.
   */
  country?: string;
  custom_fields?: custom_fields_by_id;
  /**
   * The contact's primary email. This is required to be a valid email.
   */
  email: string;
  /**
   * The contact's personal name.
   */
  first_name?: string;
  /**
   * The contact's family name.
   */
  last_name?: string;
  /**
   * The contact's ZIP code or other postal code.
   */
  postal_code?: string;
  /**
   * The contact's state, province, or region.
   */
  state_province_region?: string;
};

export type contact_response = {
  /**
   * First line of address of the contact. This is a reserved field.
   */
  address_line_1: string;
  /**
   * Second line of address of the contact. This is a reserved field.
   */
  address_line_2: string;
  /**
   * Alternate emails of the contact. This is a reserved field.
   */
  alternate_emails: Array<string>;
  /**
   * City associated with the contact. This is a reserved field.
   */
  city: string;
  /**
   * Country associated with the address of the contact. This is a reserved field.
   */
  country: string;
  /**
   * The user may choose to create up to 120 custom fields or none at all. This is not a reserved field.
   */
  custom_fields: {
    ''?: string;
    custom_field_name1?: string;
    custom_field_name2?: string;
  };
  /**
   * Email of the contact. This is a reserved field.
   */
  email: string;
  /**
   * First name of the contact. This is a reserved field.
   */
  first_name: string;
  /**
   * ID assigned to a contact when added to the system.
   */
  id: string;
  /**
   * Last name of the contact. This is a reserved field.
   */
  last_name: string;
  /**
   * IDs of all lists the contact is part of
   */
  list_ids?: Array<string>;
  /**
   * Zipcode associated with the address of the contact. This is a reserved field.
   */
  postal_code: number;
  /**
   * IDs of all segments the contact is part of
   */
  segment_ids?: Array<string>;
  /**
   * State associated with the contact. This is a reserved field.
   */
  state_province_region: string;
};

export type contact_summary = {
  _metadata?: selfmetadata;
  /**
   * Unix Epoch Timestamp.
   */
  created_at: number;
  /**
   * Primary email address.
   */
  email?: string;
  first_name?: string;
  /**
   * Contact UUID.
   */
  id: string;
  last_name?: string;
  /**
   * List UUID linked with this contact.
   */
  list_ids: Array<string>;
  /**
   * Unix Epoch Timestamp.
   */
  updated_at: number;
};

export type contactdb_custom_field = {
  /**
   * The name of the field
   */
  name?: string;
  /**
   * The type of the field.
   */
  type?: 'date' | 'text' | 'number';
};

/**
 * The type of the field.
 */
export type type2 = 'date' | 'text' | 'number';

export type contactdb_custom_field_with_id = contactdb_custom_field & {
  /**
   * The ID of the custom field.
   */
  id?: number;
};

export type contactdb_custom_field_with_id_value = contactdb_custom_field_with_id & {
  /**
   * The value of this recipient's custom field
   */
  value?: string | null;
};

export type contactdb_list = {
  /**
   * The reference ID of your list.
   */
  id: number;
  /**
   * The name of your list. Must be unique against all other list and segment names.
   */
  name: string;
  /**
   * The count of recipients currently in the list.
   */
  recipient_count: number;
};

export type contactdb_recipient = {
  recipients?: Array<{
    /**
     * The time this record was created in your contactdb, in unixtime.
     */
    created_at?: number;
    /**
     * The custom fields assigned to this recipient and their values.
     */
    custom_fields?: Array<contactdb_custom_field_with_id_value>;
    /**
     * The email address of this recipient. This is a default custom field that SendGrid provides.
     */
    email: string;
    /**
     * The first name of this recipient. This is a default custom field that SendGrid provides.
     */
    first_name?: string | null;
    /**
     * The ID of this recipient.
     */
    id?: string;
    /**
     * The last time this recipient clicked a link from one of your campaigns, in unixtime.
     */
    last_clicked?: number | null;
    /**
     * The last time this user was emailed by one of your campaigns, in unixtime.
     */
    last_emailed?: number | null;
    /**
     * The last name of the recipient.
     */
    last_name?: string | null;
    /**
     * The last time this recipient opened an email from you, in unixtime.
     */
    last_opened?: number | null;
    /**
     * The last update date for this recipient's record.
     */
    updated_at?: number;
  }>;
};

export type contactdb_recipient_count = {
  /**
   * The count of recipients.
   */
  recipient_count: number;
};

export type contactdb_recipient_response = {
  /**
   * The number of errors found while adding recipients.
   */
  error_count: number;
  /**
   * The indices of the recipient(s) sent that caused the error.
   */
  error_indices?: Array<number>;
  errors?: Array<{
    error_indices?: Array<number>;
    message?: string;
  }>;
  /**
   * The count of new recipients added to the contactdb.
   */
  new_count: number;
  /**
   * The recipient IDs of the recipients that already existed from this request.
   */
  persisted_recipients: Array<string>;
  /**
   * The recipients who were updated from this request.
   */
  updated_count: number;
};

export type contactdb_segments = {
  /**
   * The conditions for a recipient to be included in this segment.
   */
  conditions: Array<contactdb_segments_conditions>;
  /**
   * The list id from which to make this segment. Not including this ID will mean your segment is created from the main contactdb rather than a list.
   */
  list_id?: number;
  /**
   * The name of this segment.
   */
  name: string;
  /**
   * The count of recipients in this list. This is not included on creation of segments.
   */
  recipient_count?: number;
};

export type contactdb_segments_conditions = {
  and_or?: 'and' | 'or' | '';
  field: string;
  operator: 'eq' | 'ne' | 'lt' | 'gt' | 'contains';
  value: string;
};

export type and_or = 'and' | 'or' | '';

export type operator = 'eq' | 'ne' | 'lt' | 'gt' | 'contains';

export type contactdb_segments_with_id = {
  /**
   * The ID of the segment.
   */
  id: number;
} & contactdb_segments;

export type contacts = {
  address?: string;
  address2?: {
    [key: string]: unknown;
  };
  city?: string;
  company?: string;
  country?: string;
  email?: string;
  first_name?: string;
  last_name?: string;
  phone?: string;
  state?: string;
  zip?: string;
};

export type create_integration_request = {
  /**
   * Indicates if the integration is complete.
   */
  completed_integration?: boolean;
  /**
   * Indicates if the integration is enabled.
   */
  enabled: boolean;
  /**
   * An identifier provided by your IdP to identify Twilio SendGrid in the SAML interaction. This is called the "SAML Issuer ID" in the Twilio SendGrid UI.
   */
  entity_id: string;
  /**
   * The name of your integration. This name can be anything that makes sense for your organization (eg. Twilio SendGrid)
   */
  name: string;
  /**
   * The IdP's SAML POST endpoint. This endpoint should receive requests and initiate an SSO login flow. This is called the "Embed Link" in the Twilio SendGrid UI.
   */
  signin_url: string;
  /**
   * This URL is relevant only for an IdP-initiated authentication flow. If a user authenticates from their IdP, this URL will return them to their IdP when logging out.
   */
  signout_url: string;
};

export type credentials = {
  permissions?: {
    api?: string;
    mail?: string;
    web?: string;
  };
  username?: string;
};

export type custom_field_definitions_response = {
  field_type: 'Text' | 'Number' | 'Date';
  id: string;
  name: string;
};

export type field_type = 'Text' | 'Number' | 'Date';

export type custom_fields_by_id = {
  [key: string]: unknown;
};

export type custom_fields_by_name = {
  [key: string]: unknown;
};

export type design_common_fields = design_duplicate_input & {
  /**
   * The list of categories applied to the design
   */
  categories?: Array<string>;
  /**
   * If true, plain_content is always generated from html_content. If false, plain_content is not altered.
   */
  generate_plain_content?: boolean;
  /**
   * Subject of the Design.
   */
  subject?: string;
};

export type design_duplicate_input = {
  /**
   * The editor used in the UI.
   */
  editor?: 'code' | 'design';
  /**
   * The name of the new design.
   */
  name?: string;
};

export type design_input = design_duplicate_input &
  design_common_fields & {
    /**
     * The HTML content of the Design.
     */
    html_content: string;
    /**
     * Plain text content of the Design.
     */
    plain_content?: string;
  };

export type design_output = design_output_summary & design_input;

export type design_output_summary = {
  /**
   * Datetime that Design was created.
   */
  created_at?: string;
  /**
   * ID of the Design.
   */
  id?: string;
  /**
   * A Thumbnail preview of the template's html content.
   */
  thumbnail_url?: string;
  /**
   * Datetime that Design was last updated.
   */
  updated_at?: string;
} & design_duplicate_input &
  design_common_fields;

export type domain_authentication_200_response = Array<
  authentication_domain & {
    /**
     * A Unix epoch timestamp representing the last time of a validation attempt.
     */
    last_validation_attempt_at?: number;
    subusers?: Array<{
      /**
       * The ID of the subuser that this authenticated domain will be associated with.
       */
      user_id?: number;
      /**
       * The username of the subuser that this authenticated domain is associated with.
       */
      username?: string;
    }>;
  }
>;

export type domain_authentication_domain_spf = {
  /**
   * Indicates if this authenticated domain uses automated security.
   */
  automatic_security: boolean;
  /**
   * Indicates if this authenticated domain uses custom SPF.
   */
  custom_spf: boolean;
  /**
   * Indicates if this is the default domain.
   */
  default: boolean;
  /**
   * The DNS records for this authenticated domain.
   */
  dns: {
    /**
     * The DKIM record for messages sent using this authenticated domain.
     */
    dkim: {
      /**
       * The DKIM record.
       */
      data: string;
      /**
       * The DNS labels for the DKIM signature.
       */
      host: string;
      /**
       * The type of data in the DKIM record.
       */
      type: string;
      /**
       * Indicates if the DKIM record is valid.
       */
      valid: boolean;
    };
    /**
     * The SPF record for the root domain.
     */
    domain_spf: {
      /**
       * The SPF record.
       */
      data: string;
      /**
       * The root domain that this SPF record will be used to authenticate.
       */
      host: string;
      /**
       * The type of data in the SPF record.
       */
      type: string;
      /**
       * Indicates if the SPF record is valid.
       */
      valid: boolean;
    };
    /**
     * Designates which mail server is responsible for accepting messages from a domain.
     */
    mail_server: {
      /**
       * The mail server responsible for accepting messages from the sending domain.
       */
      data: string;
      /**
       * The domain sending the messages.
       */
      host: string;
      /**
       * They type of DNS record.
       */
      type: string;
      /**
       * Indicates if this is a valid DNS record.
       */
      valid: boolean;
    };
    /**
     * The SPF record for the subdomain used to create this authenticated domain.
     */
    subdomain_spf: {
      /**
       * The SPF record.
       */
      data: string;
      /**
       * The domain that this SPF record will be used to authenticate.
       */
      host: string;
      /**
       * The type of data in the SPF record.
       */
      type: string;
      /**
       * Indicates if this is a valid SPF record.
       */
      valid: boolean;
    };
  };
  /**
   * The domain authenticated.
   */
  domain: string;
  /**
   * The ID of the authenticated domain.
   */
  id: number;
  /**
   * The IP addresses that are included in the SPF record for this authenticated domain.
   */
  ips: Array<unknown>;
  /**
   * Indicates if this authenticated domain was created using the legacy whitelabel tool. If it is a legacy whitelabel, it will still function, but you'll need to create a new authenticated domain if you need to update it.
   */
  legacy: boolean;
  /**
   * The subdomain that was used to create this authenticated domain.
   */
  subdomain?: string;
  /**
   * The user_id of the account that this authenticated domain is associated with.
   */
  user_id: number;
  /**
   * The username of the account that this authenticated domain is associated with.
   */
  username: string;
  /**
   * Indicates if this is a valid authenticated domain .
   */
  valid: boolean;
};

export type email_activity_response_common_fields = {
  /**
   * The 'From' email address used to deliver the message. This address should be a verified sender in your Twilio SendGrid account.
   */
  from_email?: string;
  /**
   * A unique ID assigned to the message. This ID can be used to retrieve activity data for the specific message.
   */
  msg_id?: string;
  /**
   * The message's status.
   */
  status?: 'processed' | 'delivered' | 'not delivered';
  /**
   * The email's subject line.
   */
  subject?: string;
  /**
   * The intended recipient's email address.
   */
  to_email?: string;
};

/**
 * The message's status.
 */
export type status3 = 'processed' | 'delivered' | 'not delivered';

export type enforced_tls_request_response = {
  /**
   * Indicates if you want to require your recipients to support TLS.
   */
  require_tls?: boolean;
  /**
   * Indicates if you want to require your recipients to have a valid certificate.
   */
  require_valid_cert?: boolean;
};

export type error = {
  error_id?: string;
  field?: string;
  message: string;
  parameter?: string;
};

/**
 * If the request is incorrect, an array of errors will be returned.
 */
export type errors = {
  errors: Array<{
    field?: string | null;
    /**
     * A description of what is wrong with the field passed in the request.
     */
    message: string | null;
    /**
     * The parameter in the request body that is incorrect.
     */
    parameter: string;
  }>;
};

/**
 * If the request is incorrect, an array of errors will be returned.
 */
export type errors_seg_v2 = {
  errors: Array<{
    /**
     * the field in the request body that is incorrect
     */
    field: string;
    /**
     * a description of what is specifically wrong with the field passed in the request
     */
    message: string;
  }>;
};

export type event_webhook_response = {
  /**
   * Receiving server could not or would not accept message.
   */
  bounce: boolean;
  /**
   * Recipient clicked on a link within the message. You need to enable Click Tracking for getting this type of event.
   */
  click: boolean;
  /**
   * Recipient's email server temporarily rejected message.
   */
  deferred: boolean;
  /**
   * Message has been successfully delivered to the receiving server.
   */
  delivered: boolean;
  /**
   * You may see the following drop reasons: Invalid SMTPAPI header, Spam Content (if spam checker app enabled), Unsubscribed Address, Bounced Address, Spam Reporting Address, Invalid, Recipient List over Package Quota
   */
  dropped: boolean;
  /**
   * Indicates if the event webhook is enabled.
   */
  enabled: boolean;
  /**
   * Recipient resubscribes to specific group by updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_resubscribe: boolean;
  /**
   * Recipient unsubscribe from specific group, by either direct link or updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_unsubscribe: boolean;
  /**
   * The client ID Twilio SendGrid sends to your OAuth server or service provider to generate an OAuth access token.
   */
  oauth_client_id?: string;
  /**
   * The URL where Twilio SendGrid sends the Client ID and Client Secret to generate an access token. This should be your OAuth server or service provider.
   */
  oauth_token_url?: string;
  /**
   * Recipient has opened the HTML message. You need to enable Open Tracking for getting this type of event.
   */
  open: boolean;
  /**
   * Message has been received and is ready to be delivered.
   */
  processed: boolean;
  /**
   * Recipient marked a message as spam.
   */
  spam_report: boolean;
  /**
   * Recipient clicked on message's subscription management link. You need to enable Subscription Tracking for getting this type of event.
   */
  unsubscribe: boolean;
  /**
   * The URL that you want the event webhook to POST to.
   */
  url: string;
};

export type event_webhook_update_oauth_request = {
  /**
   * Receiving server could not or would not accept message.
   */
  bounce: boolean;
  /**
   * Recipient clicked on a link within the message. You need to enable Click Tracking for getting this type of event.
   */
  click: boolean;
  /**
   * Recipient's email server temporarily rejected message.
   */
  deferred: boolean;
  /**
   * Message has been successfully delivered to the receiving server.
   */
  delivered: boolean;
  /**
   * You may see the following drop reasons: Invalid SMTPAPI header, Spam Content (if spam checker app enabled), Unsubscribed Address, Bounced Address, Spam Reporting Address, Invalid, Recipient List over Package Quota
   */
  dropped: boolean;
  /**
   * Indicates if the event webhook is enabled.
   */
  enabled: boolean;
  /**
   * Recipient resubscribes to specific group by updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_resubscribe: boolean;
  /**
   * Recipient unsubscribe from specific group, by either direct link or updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_unsubscribe: boolean;
  /**
   * The client ID Twilio SendGrid sends to your OAuth server or service provider to generate an OAuth access token. When passing data in this field, you must also include the oauth_token_url field.
   */
  oauth_client_id?: string;
  /**
   * This secret is needed only once to create an access token. SendGrid will store this secret, allowing you to update your Client ID and Token URL without passing the secret to SendGrid again.  When passing data in this field, you must also include the oauth_client_id and oauth_token_url fields.
   */
  oauth_client_secret?: string;
  /**
   * The URL where Twilio SendGrid sends the Client ID and Client Secret to generate an access token. This should be your OAuth server or service provider. When passing data in this field, you must also include the oauth_client_id field.
   */
  oauth_token_url?: string;
  /**
   * Recipient has opened the HTML message. You need to enable Open Tracking for getting this type of event.
   */
  open: boolean;
  /**
   * Message has been received and is ready to be delivered.
   */
  processed: boolean;
  /**
   * Recipient marked a message as spam.
   */
  spam_report: boolean;
  /**
   * Recipient clicked on message's subscription management link. You need to enable Subscription Tracking for getting this type of event.
   */
  unsubscribe: boolean;
  /**
   * The URL that you want the event webhook to POST to.
   */
  url: string;
};

export type from_email_object = {
  /**
   * The 'From' email address used to deliver the message. This address should be a verified sender in your Twilio SendGrid account.
   */
  email: string;
  /**
   * A name or title associated with the sending email address.
   */
  name?: string;
};

export type full_segment = segment_summary & {
  contacts_sample: Array<contact_response>;
  /**
   * AST representation of the query DSL
   */
  query_json?: {
    [key: string]: unknown;
  };
} & segment_write_v2;

export type global_empty_request = unknown;

export type global_error_response_schema = {
  errors?: Array<{
    /**
     * the field that generated the error
     */
    field?: string | null;
    /**
     * helper text or docs for troubleshooting
     */
    help?: {
      [key: string]: unknown;
    };
    /**
     * the error message
     */
    message: string;
  }>;
  id?: string;
};

export type global_id = number;

export type google_analytics_settings = {
  /**
   * Indicates if Google Analytics is enabled.
   */
  enabled?: boolean;
  /**
   * The name of the campaign.
   */
  utm_campaign?: string;
  /**
   * Used to differentiate ads
   */
  utm_content?: string;
  /**
   * Name of the marketing medium (e.g. "Email").
   */
  utm_medium?: string;
  /**
   * Name of the referrer source.
   */
  utm_source?: string;
  /**
   * Any paid keywords.
   */
  utm_term?: string;
};

export type invalid_email = {
  /**
   * A Unix timestamp indicating when the email address was added to the invalid emails list.
   */
  created?: number;
  /**
   * The email address that was marked as invalid.
   */
  email?: string;
  /**
   * The reason that the email address was marked as invalid.
   */
  reason?: string;
};

export type ip_access_response = {
  /**
   * An array listing all of your allowed IPs.
   */
  result?: Array<{
    /**
     * A Unix timestamp indicating when the IP was added to the allow list.
     */
    created_at?: number;
    /**
     * The ID of the allowed IP.
     */
    id?: number;
    /**
     * The allowed IP.
     */
    ip?: string;
    /**
     * A Unix timestamp indicating when the IPs allow status was most recently updated.
     */
    updated_at?: number;
  }>;
};

export type ip_pool = {
  /**
   * The name of the IP pool.
   */
  name: string;
};

export type ip_pool_response = {
  /**
   * The name of the IP pool.
   */
  name?: string;
};

export type ip_warmup_response = Array<{
  /**
   * The IP address.
   */
  ip: string;
  /**
   * A Unix timestamp indicating when the IP address entered warmup mode.
   */
  start_date: number;
}>;

export type link = {
  href?: string;
  rel?: string;
};

export type link_branding_200_response = {
  /**
   * Indicates if this is the default link branding.
   */
  default: boolean;
  /**
   * The DNS records generated for this link branding.
   */
  dns: {
    /**
     * The DNS record generated to point to your link branding subdomain.
     */
    domain_cname: {
      /**
       * The domain that the DNS record points to.
       */
      data: string;
      /**
       * The domain that this link branding will use for the links in your email.
       */
      host: string;
      /**
       * The type of DNS record that was generated.
       */
      type: 'cname' | 'txt' | 'mx';
      /**
       * Indicates if the DNS record is valid.
       */
      valid: boolean;
    };
    /**
     * The DNS record generated to verify who created the link branding.
     */
    owner_cname?: {
      /**
       * The domain that the DNS record points to.
       */
      data: string;
      /**
       * Used to verify the link branding. The subdomain of this domain is the ID of the user who created the link branding.
       */
      host: string;
      /**
       * The type of DNS record generated.
       */
      type?: 'cname' | 'txt' | 'mx';
      /**
       * Indicates if the DNS record is valid.
       */
      valid: boolean;
    };
  };
  /**
   * The root domain of the branded link.
   */
  domain: string;
  /**
   * The ID of the branded link.
   */
  id: number;
  /**
   * Indicates if this link branding was created using the legacy whitelabel tool. If it is a legacy whitelabel, it will still function, but you'll need to create new link branding if you need to update it.
   */
  legacy: boolean;
  /**
   * The subdomain used to generate the DNS records for this link branding. This subdomain must be different from the subdomain used for your authenticated domain.
   */
  subdomain?: string;
  /**
   * The ID of the user that this link branding is associated with.
   */
  user_id: number;
  /**
   * The username of the account that this link branding is associated with.
   */
  username: string;
  /**
   * Indicates if this link branding is valid.
   */
  valid: boolean;
};

/**
 * The type of DNS record that was generated.
 */
export type type3 = 'cname' | 'txt' | 'mx';

export type link_tracking_metadata = {
  /**
   * The number of items in the entire list, i.e., across all pages.
   */
  count?: number;
  /**
   * The URL of the next page of results. If this field isn't present, you're at the end of the list.
   */
  next?: string;
  /**
   * The URL of the previous page of results. If this field isn't present, you're at the start of the list.
   */
  prev?: string;
  /**
   * The URL of the current page of results.
   */
  self?: string;
};

export type list = {
  _metadata?: selfmetadata;
  /**
   * The number of contacts currently stored on the list.
   */
  contact_count?: number;
  /**
   * The generated ID for your list.
   */
  id?: string;
  /**
   * The name you gave your list.
   */
  name?: string;
};

export type mail_batch_id = {
  batch_id: string;
};

export type mail_settings_address_whitelabel = {
  /**
   * Indicates if you have an email address whitelist enabled.
   */
  enabled?: boolean;
  /**
   * All email addresses that are currently on the whitelist.
   */
  list?: Array<string>;
};

export type mail_settings_bounce_purge = {
  /**
   * Indicates if the bounce purge mail setting is enabled.
   */
  enabled?: boolean;
  /**
   * The number of days after which SendGrid will purge all contacts from your hard bounces suppression lists.
   */
  hard_bounces?: number | null;
  /**
   * The number of days after which SendGrid will purge all contacts from your soft bounces suppression lists.
   */
  soft_bounces?: number | null;
};

export type mail_settings_footer = {
  /**
   * Indicates if the Footer mail setting is currently enabled.
   */
  enabled?: boolean;
  /**
   * The custom HTML content of your email footer.
   */
  html_content?: string;
  /**
   * The plain text content of your email footer.
   */
  plain_content?: string;
};

export type mail_settings_forward_bounce = {
  /**
   * The email address that you would like your bounce reports forwarded to.
   */
  email?: string | null;
  /**
   * Indicates if the bounce forwarding mail setting is enabled.
   */
  enabled?: boolean;
};

export type mail_settings_forward_spam = {
  /**
   * The email address where you would like the spam reports to be forwarded.
   */
  email?: string;
  /**
   * Indicates if the Forward Spam setting is enabled.
   */
  enabled?: boolean;
};

export type mail_settings_patch = {
  /**
   * The email address of the recipient.
   */
  email?: string;
  /**
   * Indicates if the mail setting is enabled.
   */
  enabled?: boolean;
};

export type mail_settings_template = {
  /**
   * Indicates if the legacy email template setting is enabled.
   */
  enabled?: boolean;
  /**
   * The HTML content that you want to use for your legacy email template.
   */
  html_content?: string;
};

export type mako_event = {
  /**
   * Used with "deferred" events to indicate the attempt number out of 10. One "deferred" entry will exists under events array for each time a message was deferred with error message from the server.
   */
  attempt_num?: number;
  /**
   * Use to distinguish between types of bounces
   */
  bounce_type: 'bounced' | 'blocked' | 'expired';
  /**
   * Name of event
   */
  event_name:
    | 'bounced'
    | 'opened'
    | 'clicked'
    | 'processed'
    | 'dropped'
    | 'delivered'
    | 'deferred'
    | 'spam_report'
    | 'unsubscribe'
    | 'group_unsubscribe'
    | 'group_resubscribe';
  /**
   * Client recipient used to click or open message
   */
  http_user_agent: string;
  /**
   * For example mx.gmail.com
   */
  mx_server: string;
  /**
   * Date of when event occurred
   */
  processed: string;
  /**
   * Explanation of what caused "bounced", "deferred", or "blocked". Usually contains error message from the server - e.g. message from gmail why mail was deferred
   */
  reason?: string;
  /**
   * Used with "clicked" event to indicate which url the user clicked.
   */
  url: string;
};

/**
 * Use to distinguish between types of bounces
 */
export type bounce_type = 'bounced' | 'blocked' | 'expired';

/**
 * Name of event
 */
export type event_name =
  | 'bounced'
  | 'opened'
  | 'clicked'
  | 'processed'
  | 'dropped'
  | 'delivered'
  | 'deferred'
  | 'spam_report'
  | 'unsubscribe'
  | 'group_unsubscribe'
  | 'group_resubscribe';

export type message = {
  api_key_id: string;
  asm_group_id: number;
  /**
   * Categories users associated to the message
   */
  categories: Array<string>;
  /**
   * List of events related to email message
   */
  events: Array<{
    /**
     * Used with "deferred" events to indicate the attempt number out of 10. One "deferred" entry will exists under events array for each time a message was deferred with error message from the server.
     */
    attempt_num?: number;
    /**
     * Use to distinguish between types of bounces
     */
    bounce_type: 'bounced' | 'blocked' | 'expired';
    /**
     * Name of event
     */
    event_name:
      | 'bounced'
      | 'opened'
      | 'clicked'
      | 'processed'
      | 'dropped'
      | 'delivered'
      | 'deferred'
      | 'spam_report'
      | 'unsubscribe'
      | 'group_unsubscribe'
      | 'group_resubscribe';
    /**
     * Client recipient used to click or open message
     */
    http_user_agent: string;
    /**
     * For example mx.gmail.com
     */
    mx_server: string;
    /**
     * Date of when event occurred
     */
    processed: string;
    /**
     * Explanation of what caused "bounced", "deferred", or "blocked". Usually contains error message from the server - e.g. message from gmail why mail was deferred
     */
    reason?: string;
    /**
     * Used with "clicked" event to indicate which url the user clicked.
     */
    url: string;
  }>;
  from_email: string;
  msg_id: string;
  /**
   * This is the IP of the user who sent the message.
   */
  originating_ip: string;
  /**
   * IP used to send to the remote MTA. Used by UI to display IP in detailed view
   */
  outbound_ip: string;
  /**
   * Whether or not the outbound IP is dedicated vs shared
   */
  outbound_ip_type: 'dedicated' | 'shared';
  /**
   * Quick summary of the status of a message
   */
  status: 'processed' | 'not delivered' | 'delivered';
  subject: string;
  /**
   * Teammate's username
   */
  teammate: string;
  template_id: string;
  to_email: string;
  /**
   * JSON hash of arbitrary key-value pairs
   */
  unique_args: string;
};

/**
 * Whether or not the outbound IP is dedicated vs shared
 */
export type outbound_ip_type = 'dedicated' | 'shared';

export type metadata = {
  /**
   * The number of items in the entire list, i.e., across all pages.
   */
  count?: number;
  /**
   * The URL of the next page of results. If this field isn't present, you're at the end of the list.
   */
  next?: string;
  /**
   * The URL of the previous page of results. If this field isn't present, you're at the start of the list.
   */
  prev?: string;
  /**
   * The URL of the current page of results.
   */
  self?: string;
};

export type metrics = {
  bounce_drops: number;
  bounces: number;
  clicks: number;
  delivered: number;
  invalid_emails: number;
  opens: number;
  requests: number;
  spam_report_drops: number;
  spam_reports: number;
  unique_clicks: number;
  unique_opens: number;
  unsubscribes: number;
};

export type monitor = {
  /**
   * The email address to which Sendgrid should send emails for monitoring.
   */
  email: string;
  /**
   * The frequency at which to forward monitoring emails. An email will be sent when your subuser sends this many (e.g., 1,000) emails.
   */
  frequency: number;
};

export type Parametertrait_authorizationHeader_Authorization = string;

/**
 * Automations can have multiple steps. Including `step_id` as a `group_by` metric allows further granularity of stats.
 */
export type Parametertrait_automationQueryParams_group_by = Array<'step_id'>;

/**
 * Comma-separated list of `step_ids` that you want the link stats for.
 */
export type Parametertrait_automationQueryParams_step_ids = Array<string>;

/**
 * Dictates how the stats are time-sliced. Currently, `"total"` and `"day"` are supported.
 */
export type Parametertrait_baseParams_aggregated_by = 'day' | 'total';

/**
 * Format: `YYYY-MM-DD`.If this parameter is included, the stats' end date is included in the search.
 */
export type Parametertrait_baseParams_end_date = string;

/**
 * Format: `YYYY-MM-DD`. If this parameter is included, the stats' start date is included in the search.
 */
export type Parametertrait_baseParams_start_date = string;

/**
 * [IANA Area/Region](https://en.wikipedia.org/wiki/Tz_database#Names_of_time_zones) string representing the timezone in which the stats are to be presented, e.g., "America/Chicago".
 */
export type Parametertrait_baseParams_timezone = string;

/**
 * number of results to return
 */
export type Parametertrait_designsQueryStrings_page_size = number;

/**
 * token corresponding to a specific page of results, as provided by metadata
 */
export type Parametertrait_designsQueryStrings_page_token = string;

/**
 * set to false to return all fields
 */
export type Parametertrait_designsQueryStrings_summary = boolean;

export type Parametertrait_onBehalfOfSubuser_on_behalf_of = string;

/**
 * The number of elements you want returned on each page.
 */
export type Parametertrait_pagination_page_size = number;

/**
 * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
 */
export type Parametertrait_pagination_page_token = string;

/**
 * A/B Single Sends have multiple variation IDs and phase IDs. Including these additional fields allows further granularity of stats by these fields.
 */
export type Parametertrait_singlesendQueryParams_group_by = Array<'ab_variation' | 'ab_phase'>;

export type Parametertrait_singlesendQueryParams2_ab_phase_id = 'test' | 'send';

export type Parametertrait_singlesendQueryParams2_ab_variation_id = string;

/**
 * A/B Single Sends have multiple variation IDs and phase IDs. Including these additional fields allows further granularity of stats by these fields.
 */
export type Parametertrait_singlesendQueryParams2_group_by = Array<'ab_variation' | 'ab_phase'>;

/**
 * How to group the statistics. Must be either "day", "week", or "month".
 */
export type Parametertrait_statsAdvancedQueryStringsLimitOffset_aggregated_by = 'day' | 'week' | 'month';

/**
 * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
 */
export type Parametertrait_statsAdvancedQueryStringsLimitOffset_end_date = string;

/**
 * The number of results to return.
 */
export type Parametertrait_statsAdvancedQueryStringsLimitOffset_limit = number;

/**
 * The point in the list to begin retrieving results.
 */
export type Parametertrait_statsAdvancedQueryStringsLimitOffset_offset = number;

/**
 * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
 */
export type Parametertrait_statsAdvancedQueryStringsLimitOffset_start_date = string;

/**
 * How to group the statistics. Must be either "day", "week", or "month".
 */
export type Parametertrait_statsAdvancedStatsBaseQueryStrings_aggregated_by = 'day' | 'week' | 'month';

/**
 * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
 */
export type Parametertrait_statsAdvancedStatsBaseQueryStrings_end_date = string;

/**
 * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
 */
export type Parametertrait_statsAdvancedStatsBaseQueryStrings_start_date = string;

export type parse_setting = {
  /**
   * A specific and unique domain or subdomain that you have created to use exclusively to parse your incoming email. For example, `parse.yourdomain.com`.
   */
  hostname?: string;
  /**
   * Indicates if you would like SendGrid to post the original MIME-type content of your parsed email. When this parameter is set to `true`, SendGrid will send a JSON payload of the content of your email.
   */
  send_raw?: boolean;
  /**
   * Indicates if you would like SendGrid to check the content parsed from your emails for spam before POSTing them to your domain.
   */
  spam_check?: boolean;
  /**
   * The public URL where you would like SendGrid to POST the data parsed from your email. Any emails sent with the given hostname provided (whose MX records have been updated to point to SendGrid) will be parsed and POSTed to this URL.
   */
  url?: string;
};

export type partner_settings_new_relic = {
  /**
   * Indicates if your subuser statistics will be sent to your New Relic Dashboard.
   */
  enable_subuser_statistics?: boolean;
  /**
   * Indicates if this setting is enabled.
   */
  enabled: boolean;
  /**
   * The license key provided with your New Relic account.
   */
  license_key: string;
};

export type reply_to_email_object = {
  /**
   * The email address where any replies or bounces will be returned.
   */
  email: string;
  /**
   * A name or title associated with the `reply_to` email address.
   */
  name?: string;
};

export type reserved_field_definitions_response = Array<{
  field_type?: 'Text' | 'Number' | 'Date';
  name?: string;
  /**
   * When `true` this means API consumers are unable to set the value of this field on contacts.
   */
  read_only?: boolean;
}>;

export type reverse_dns = {
  a_record: {
    /**
     * The IP address being set up with Reverse DNS.
     */
    data: string;
    /**
     * This is the web address that will be mapped to the IP address.
     */
    host: string;
    /**
     * The type of DNS record.
     */
    type: string;
    /**
     * Indicates if the a_record is valid.
     */
    valid: boolean;
  };
  /**
   * The root, or sending, domain.
   */
  domain: string;
  /**
   * The ID of the Reverse DNS.
   */
  id: number;
  /**
   * The IP address that this Reverse DNS was created for.
   */
  ip: string;
  /**
   * A Unix epoch timestamp representing the last time of a validation attempt.
   */
  last_validation_attempt_at?: number;
  /**
   * Indicates if this Reverse DNS was created using the legacy whitelabel tool. If it is a legacy whitelabel, it will still function, but you'll need to create a new Reverse DNS if you need to update it.
   */
  legacy: boolean;
  /**
   * The reverse DNS record for the IP address. This points to the Reverse DNS subdomain.
   */
  rdns: string;
  /**
   * The subdomain created for this reverse DNS. This is where the rDNS record points.
   */
  subdomain?: string;
  /**
   * The users who are able to send mail from the IP address.
   */
  users: Array<{
    /**
     * The ID of a user who can send mail from the IP address.
     */
    user_id: number;
    /**
     * The username of a user who can send mail from the IP address.
     */
    username: string;
  }>;
  /**
   * Indicates if this is a valid Reverse DNS.
   */
  valid: boolean;
};

export type segment_query_json = {
  contacts?: {
    l?: {
      l?: {
        l?: {
          t?: string;
          v?: string;
        };
        op?: string;
        r?: {
          t?: string;
          v?: string;
        };
      };
      op?: string;
      r?: {
        l?: {
          args?: Array<{
            t?: string;
            v?: string;
          }>;
          t?: string;
          v?: string;
        };
        op?: string;
        r?: {
          t?: string;
          v?: string;
        };
      };
    };
    op?: string;
    r?: {
      l?: {
        t?: string;
        v?: string;
      };
      op?: string;
      r?: {
        t?: string;
        v?: Array<string>;
      };
    };
  };
};

export type segment_response = {
  /**
   * Total number of contacts present in the segment
   */
  contacts_count: number;
  /**
   * A subset of all contacts that are in this segment
   */
  contacts_sample: Array<contact_response>;
  /**
   * ISO8601 timestamp of when the object was created
   */
  created_at: string;
  /**
   * ID assigned to the segment when created.
   */
  id: string;
  /**
   * Name of the segment.
   */
  name: string;
  /**
   * ISO8601 timestamp of when the samples will be next updated
   */
  next_sample_update: string;
  /**
   * The array of list ids to filter contacts on when building this segment. It allows only one such list id for now. We will support more in future
   */
  parent_list_ids: Array<string>;
  /**
   * SQL query which will filter contacts based on the conditions provided
   */
  query_dsl: string;
  /**
   * If not set, segment contains a Query for use with Segment v1 APIs. If set to '2', segment contains a SQL query for use in v2.
   */
  query_version: string;
  /**
   * ISO8601 timestamp of when the samples were last updated
   */
  sample_updated_at: string;
  status: segment_status_response;
  /**
   * ISO8601 timestamp of when the object was last updated
   */
  updated_at: string;
};

/**
 * Segment status indicates whether the segment's contacts will be updated periodically
 */
export type segment_status_response = {
  /**
   * Describes any errors that were encountered during query validation
   */
  error_message?: string;
  /**
   * Status of query validation. PENDING, VALID, or INVALID
   */
  query_validation: string;
};

export type segment_summary = {
  contacts_count: number;
  /**
   * ISO8601 of created timestamp
   *
   */
  created_at: string;
  id: string;
  name?: string;
  /**
   * ISO8601 string that is equal to `sample_updated_at` plus an internally calculated offset that depends on how often contacts enter or exit segments as the scheduled pipeline updates the samples.
   */
  next_sample_update?: string;
  /**
   * The id of the list if this segment is a child of a list.  This implies the query `AND CONTAINS(list_ids, ${parent_list_id})`
   */
  parent_list_id?: string;
  /**
   * ISO8601 timestamp the sample was last updated
   */
  sample_updated_at: string;
  /**
   * ISO8601 timestamp the object was last updated
   */
  updated_at: string;
};

export type segment_summary_v2 = {
  results?: Array<segment_summary>;
};

export type segment_update = {
  /**
   * Name of the segment.
   */
  name?: string;
  /**
   * SQL query which will filter contacts based on the conditions provided
   */
  query_dsl?: string;
};

export type segment_write = {
  name: string;
  /**
   * Use this field for adding your query string.
   */
  query_dsl: string;
};

export type segment_write_v2 = {
  /**
   * Name of the segment.
   */
  name: string;
  /**
   * The array of list ids to filter contacts on when building this segment. It allows only one such list id for now. We will support more in future
   */
  parent_list_ids?: Array<string>;
  /**
   * SQL query which will filter contacts based on the conditions provided
   */
  query_dsl: string;
};

export type selfmetadata = {
  /**
   * A link to this object.
   */
  self?: string;
};

export type sender_id_request = {
  /**
   * The physical address of the sender identity.
   */
  address?: string;
  /**
   * Additional sender identity address information.
   */
  address_2?: string;
  /**
   * The city of the sender identity.
   */
  city?: string;
  /**
   * The country of the sender identity.
   */
  country?: string;
  from?: {
    /**
     * The email address from which your recipient will receive emails.
     */
    email?: string;
    /**
     * The name appended to the from email field. Typically your name or company name.
     */
    name?: string;
  };
  /**
   * A nickname for the sender identity. Not used for sending.
   */
  nickname?: string;
  reply_to?: {
    /**
     * The email address to which your recipient will reply.
     */
    email?: string;
    /**
     * The name appended to the reply to email field. Typically your name or company name.
     */
    name?: string;
  };
  /**
   * The state of the sender identity.
   */
  state?: string;
  /**
   * The zipcode of the sender identity.
   */
  zip?: string;
};

export type senderID = sender_id_request & {
  /**
   * The time the sender identity was created.
   */
  created_at?: number;
  /**
   * The unique identifier of the sender identity.
   */
  id?: number;
  /**
   * True when the sender id is associated to a campaign in the Draft, Scheduled, or In Progress status. You cannot update or delete a locked sender identity.
   */
  locked?: boolean;
  /**
   * The time the sender identity was last updated.
   */
  updated_at?: number;
  /**
   * If the sender identity is verified or not. Only verified sender identities can be used to send email.
   */
  verified?: boolean;
} & {
  [key: string]: unknown;
};

export type senders_id_request_body = {
  /**
   * The physical address of the sender identity.
   */
  address: string;
  /**
   * Additional sender identity address information.
   */
  address_2?: string;
  /**
   * The city of the sender identity.
   */
  city: string;
  /**
   * The country of the sender identity.
   */
  country: string;
  from: {
    /**
     * This is where the email will appear to originate from for your recipient
     */
    email: string;
    /**
     * This is the name appended to the from email field. IE - Your name or company name.
     */
    name: string;
  };
  /**
   * A nickname for the sender identity. Not used for sending.
   */
  nickname: string;
  reply_to?: {
    /**
     * This is the email that your recipient will reply to.
     */
    email: string;
    /**
     * This is the name appended to the reply to email field. IE - Your name or company name.
     */
    name?: string;
  };
  /**
   * The state of the sender identity.
   */
  state?: string;
  /**
   * The zipcode of the sender identity.
   */
  zip?: string;
};

export type single_contact_request = {
  contact?: {
    address_line_1?: string;
    address_line_2?: string;
    alternate_emails?: string;
    city?: string;
    country?: string;
    custom_fields?: {
      custom_field_name1?: string;
      custom_field_name2?: string;
    };
    first_name?: string;
    last_name?: string;
    postal_code?: string;
    primary_email?: string;
    state_province_region?: string;
  };
  /**
   * The contact's list IDs.
   */
  list_ids?: Array<string>;
};

export type singlesend_request = {
  /**
   * The categories to associate with this Single Send.
   */
  categories?: Array<string>;
  email_config?: {
    /**
     * The URL allowing recipients to unsubscribe — you must provide this or the `suppression_group_id`.
     */
    custom_unsubscribe_url?: string | null;
    /**
     * A `design_id` can be used in place of `html_content`, `plain_content`, and/or `subject`. You can retrieve a design's ID from the ["List Designs" endpoint](https://sendgrid.api-docs.io/v3.0/designs-api/list-designs) or by pulling it from the design's detail page URL in the Marketing Campaigns App.
     */
    design_id?: string;
    /**
     * The editor — `"design"` or `"code"` — used to modify the Single Send's design in the Marketing Campaigns App.
     */
    editor?: 'code' | 'design';
    /**
     * If set to `true`, `plain_content` is always generated from `html_content`. If set to false, `plain_content` is not altered.
     */
    generate_plain_content?: boolean;
    /**
     * The HTML content of the Single Send. Do not include this field when using a `design_id`.
     */
    html_content?: string;
    /**
     * The name of the IP Pool from which the Single Send emails are sent.
     */
    ip_pool?: string | null;
    /**
     * The plain text content of the Single Send. Do not include this field when using a `design_id`.
     */
    plain_content?: string;
    /**
     * The ID of the verified Sender. You can retrieve a verified Sender's ID from the ["Get Verified Senders" endpoint](https://sendgrid.api-docs.io/v3.0/sender-verification/get-verified-senders) or by pulling it from the Sender's detail page URL in the SendGrid App.
     */
    sender_id?: number | null;
    /**
     * The subject line of the Single Send. Do not include this field when using a `design_id`.
     */
    subject?: string;
    /**
     * The ID of the Suppression Group to allow recipients to unsubscribe — you must provide this or the `custom_unsubscribe_url`.
     */
    suppression_group_id?: number | null;
  };
  /**
   * The name of the Single Send.
   */
  name: string;
  /**
   * The ISO 8601 time at which to send the Single Send — this must be set for a future time.
   */
  send_at?: string;
  send_to?: {
    /**
     * Set to `true` to send to All Contacts. If set to `false`, at least one `list_ids` or `segment_ids` value must be provided before the Single Send is scheduled to be sent to recipients.
     */
    all?: boolean;
    /**
     * The recipient List IDs that will receive the Single Send.
     */
    list_ids?: Array<string>;
    /**
     * The recipient Segment IDs that will receive the Single Send.
     */
    segment_ids?: Array<string>;
  };
};

export type singlesend_response = singlesend_request & {
  /**
   * the ISO 8601 time at which the Single Send was created
   */
  created_at: string;
  id: string;
  /**
   * current status of the Single Send
   */
  status: 'draft' | 'scheduled' | 'triggered';
  /**
   * the ISO 8601 time at which the Single Send was last updated
   */
  updated_at?: string;
  warnings?: Array<{
    field?: string;
    message?: string;
    warning_id?: string;
  }>;
};

/**
 * current status of the Single Send
 */
export type status4 = 'draft' | 'scheduled' | 'triggered';

export type singlesend_response_short = {
  abtest: abtest_summary;
  /**
   * categories to associate with this Single Send
   */
  categories: Array<string>;
  /**
   * the ISO 8601 time at which the Single Send was created
   */
  created_at: string;
  id: string;
  /**
   * true if the Single Send's AB Test functionality has been toggled on
   */
  is_abtest: boolean;
  /**
   * name of the Single Send
   */
  name: string;
  /**
   * the ISO 8601 time at which to send the Single Send; must be in future
   */
  send_at?: string;
  /**
   * current status of the Single Send
   */
  status: 'draft' | 'scheduled' | 'triggered';
  /**
   * the ISO 8601 time at which the Single Send was last updated
   */
  updated_at: string;
};

export type singlesend_schedule = {
  /**
   * This is the ISO 8601 time at which to send the Single Send; must be in future, or the string "now"
   */
  send_at: string;
  status?: 'draft' | 'scheduled' | 'triggered';
};

export type singlesend_search = {
  /**
   * categories to associate with this Single Send, match any single send that has at least one of the categories
   */
  categories?: Array<string>;
  /**
   * leading and trailing wildcard search on name of the Single Send
   */
  name?: string;
  /**
   * current status of the Single Send
   */
  status?: Array<'draft' | 'scheduled' | 'triggered'>;
};

export type singlesend_warning = {
  warnings?: Array<{
    field?: string;
    message?: string;
    warning_id?: string;
  }>;
};

export type singlesends_link_stats_response = {
  _metadata: link_tracking_metadata;
  /**
   * This is the index of the link's location in the email contents.
   */
  results: Array<{
    /**
     * This is the A/B phase of the Single Send stat returned. If the `ab_phase` query parameter was not provided, it will return `"all"`.
     */
    ab_phase: 'send' | 'test' | 'all';
    /**
     * This is the A/B variation of the Single Send stat returned. It is set to `"all"` if the `ab_variation` query parameter was not set in the request and `group_by` doesn't contain `ab_variation`.
     */
    ab_variation: string;
    /**
     * the number of clicks on this particular link
     */
    clicks: number;
    /**
     * This is the URL of the link clicked. If `{{custom_fields}}` are part of the URL, they will be included.
     */
    url: string;
    /**
     * This is the location of the link clicked in each Single Send A/B variation, or in the Single Send itself if there are no variations. Links are numbered from the top down; the topmost link is index `0`.
     */
    url_location?: number;
  }>;
  total_clicks?: number;
};

export type singlesends_response = {
  _metadata: metadata;
  results: Array<{
    /**
     * This is the A/B phase of the Single Send stat returned. If the `group_by` parameter doesn't include `ab_phase` in the request, then the value is "all".
     */
    ab_phase: 'send' | 'test' | 'all';
    /**
     * This is the A/B variation of the Single Send stat returned. If the `group_by` parameter doesn't include `ab_variation` in the request, then the value is "all".
     */
    ab_variation: string;
    /**
     * This describes the time unit to which the stat is rolled up. It is based on the `aggregated_by` parameter included in the request. It can be "total" or the date (in YYYY-MM-DD format) the stats are for.
     */
    aggregation?: string;
    /**
     * This is the ID of the Single Dend you require stats for.
     */
    id: string;
    stats?: metrics;
  }>;
};

export type spam_reports_response = Array<{
  /**
   * A Unix timestamp that indicates when the recipient marked your message as spam.
   */
  created: number;
  /**
   * The email address of the recipient that marked your message as spam.
   */
  email: string;
  /**
   * The IP address that the message was sent from.
   */
  ip: string;
}>;

export type sso_certificate_body = {
  /**
   * A unique ID assigned to the certificate by SendGrid.
   */
  id?: number;
  /**
   * An ID that matches a certificate to a specific IdP integration.
   */
  intergration_id?: string;
  /**
   * A unix timestamp (e.g., 1603915954) that indicates the time after which the certificate is no longer valid.
   */
  not_after?: number;
  /**
   * A unix timestamp (e.g., 1603915954) that indicates the time before which the certificate is not valid.
   */
  not_before?: number;
  /**
   * This certificate is used by Twilio SendGrid to verify that SAML requests are coming from Okta. This is called the X509 certificate in the Twilio SendGrid UI.
   */
  public_certificate?: string;
};

export type sso_error_response = Array<{
  error_id?: string;
  field?: string | null;
  message?: string;
}>;

export type sso_integration = create_integration_request & {
  /**
   * The URL where your IdP should POST its SAML response. This is the Twilio SendGrid URL that is responsible for receiving and parsing a SAML assertion. This is the same URL as the Single Sign-On URL when using SendGrid.
   */
  audience_url?: string;
  /**
   * A unique ID assigned to the configuration by SendGrid.
   */
  id?: string;
  /**
   * A timestamp representing the last time the configuration was modified.
   */
  last_updated: number;
  /**
   * The URL where your IdP should POST its SAML response. This is the Twilio SendGrid URL that is responsible for receiving and parsing a SAML assertion. This is the same URL as the Audience URL when using SendGrid.
   */
  single_signon_url?: string;
};

export type sso_teammate_common_fields = {
  /**
   * The Teammate’s email address. This email address will also function as the Teammate’s username and must match the address assigned to the user in your IdP. This address cannot be changed after the Teammate is created.
   */
  email: string;
  /**
   * The Teammate’s first name.
   */
  first_name: string;
  /**
   * Indicates if the Teammate has admin permissions.
   */
  is_admin?: boolean;
  /**
   * Indicates if the Teammate has read_only permissions.
   */
  is_read_only?: boolean;
  /**
   * The Teammate’s last name.
   */
  last_name: string;
};

export type sso_teammate_request = sso_teammate_common_fields & {
  /**
   * The permission scopes assigned to the Teammate.
   */
  scopes: Array<string>;
};

export type sso_teammate_response = sso_teammate_common_fields & {
  /**
   * Indicates if the Teammate authenticates with SendGrid using SSO or with a username and password.
   */
  is_sso?: boolean;
  /**
   * This should be set to the Teammate's email address.
   */
  username?: string;
};

export type sso_teammates_patch_response = sso_teammate_response & {
  /**
   * The Teammate’s street address.
   */
  address?: string;
  /**
   * The Teammate’s apartment number, suite number, or other secondary address information that is not part of the physical street address.
   */
  address2?: string;
  /**
   * The Teammate's city.
   */
  city?: string;
  /**
   * The Teammate’s company name.
   */
  company?: string;
  /**
   * The Teammate’s country of residence.
   */
  country?: string;
  email?: string;
  /**
   * The Teammate’s stored phone number.
   */
  phone?: string;
  /**
   * The permission scopes assigned to the Teammate.
   */
  scopes?: Array<string>;
  /**
   * The Teammate’s state or province.
   */
  state?: string;
  /**
   * A Teammate can be an “admin,” “owner,” or “teammate.” Each role is associated with the scope of the Teammate’s permissions.
   */
  user_type?: 'admin' | 'owner' | 'teammate';
  /**
   * A website associated with the Teammate
   */
  website?: string;
  /**
   * The Teammate’s zip code.
   */
  zip?: string;
};

/**
 * A Teammate can be an “admin,” “owner,” or “teammate.” Each role is associated with the scope of the Teammate’s permissions.
 */
export type user_type = 'admin' | 'owner' | 'teammate';

export type stats_advanced_global_stats = advanced_stats_clicks_opens & {
  /**
   * The number of emails that were not allowed to be delivered by ISPs.
   */
  blocks?: number;
  /**
   * The number of emails that were dropped because of a bounce.
   */
  bounce_drops?: number;
  /**
   * The number of emails that bounced instead of being delivered.
   */
  bounces?: number;
  /**
   * The number of emails that temporarily could not be delivered.
   */
  deferred?: number;
  /**
   * The number of emails SendGrid was able to confirm were actually delivered to a recipient.
   */
  delivered?: number;
  /**
   * The number of recipients who had malformed email addresses or whose mail provider reported the address as invalid.
   */
  invalid_emails?: number;
  /**
   * Requests from your website, application, or mail client via SMTP Relay or the API that SendGrid processed.
   */
  processed?: number;
  /**
   * The number of emails that were requested to be delivered.
   */
  requests?: number;
  /**
   * The number of emails that were dropped due to a recipient previously marking your emails as spam.
   */
  spam_report_drops?: number;
  /**
   * The number of recipients who marked your email as spam.
   */
  spam_reports?: number;
  /**
   * The number of emails dropped due to a recipient unsubscribing from your emails.
   */
  unsubscribe_drops?: number;
  /**
   * The number of recipients who unsubscribed from your emails.
   */
  unsubscribes?: number;
};

export type stats_advanced_stats_base_schema = Array<{
  /**
   * The date the stats were gathered.
   */
  date?: string;
  /**
   * The individual email activity stats.
   */
  stats?: Array<{
    metrics?: {
      [key: string]: unknown;
    };
  }>;
}>;

export type subscription_tracking_settings = {
  /**
   * Indicates if subscription tracking is enabled.
   */
  enabled?: boolean;
  /**
   * The information and HTML for your unsubscribe link.
   */
  html_content?: string;
  /**
   * The HTML that will be displayed on the page that your customers will see after clicking unsubscribe, hosted on SendGrid’s server.
   */
  landing?: string;
  /**
   * The information in plain text for your unsubscribe link. You should have the “<% %>” tag in your content, otherwise the user will have no URL for unsubscribing.
   */
  plain_content?: string;
  /**
   * Your custom defined replacement tag for your templates. Use this tag to place your unsubscribe content anywhere in your emailtemplate.
   */
  replace?: string;
  /**
   * The URL where you would like your users sent to unsubscribe.
   */
  url?: string;
};

export type subuser = {
  /**
   * Whether or not the user is enabled or disabled.
   */
  disabled: boolean;
  /**
   * The email address to contact this subuser.
   */
  email: string;
  /**
   * The ID of this subuser.
   */
  id: number;
  /**
   * The name by which this subuser will be referred.
   */
  username: string;
};

export type subuser_post = {
  authorization_token?: string;
  credit_allocation?: {
    type?: string;
  };
  /**
   * The email address for this subuser.
   */
  email: string;
  signup_session_token?: string;
  /**
   * The user ID for this subuser.
   */
  user_id: number;
  /**
   * The username of the subuser.
   */
  username: string;
};

export type subuser_stats = {
  /**
   * The date the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    /**
     * The first name of the subuser.
     */
    first_name?: string;
    /**
     * The last name of the subuser.
     */
    last_name?: string;
    metrics?: {
      /**
       * The number of emails that were not allowed to be delivered by ISPs.
       */
      blocks?: number;
      /**
       * The number of emails that were dropped because of a bounce.
       */
      bounce_drops?: number;
      /**
       * The number of emails that bounced instead of being delivered.
       */
      bounces?: number;
      /**
       * The number of links that were clicked in your emails.
       */
      clicks?: number;
      /**
       * The number of emails that temporarily could not be delivered.
       */
      deferred?: number;
      /**
       * The number of emails SendGrid was able to confirm were actually delivered to a recipient.
       */
      delivered?: number;
      /**
       * The number of recipients who had malformed email addresses or whose mail provider reported the address as invalid.
       */
      invalid_emails?: number;
      /**
       * The total number of times your emails were opened by recipients.
       */
      opens?: number;
      /**
       * Requests from your website, application, or mail client via SMTP Relay or the API that SendGrid processed.
       */
      processed?: number;
      /**
       * The number of emails that were requested to be delivered.
       */
      requests?: number;
      /**
       * The number of emails that were dropped due to a recipient previously marking your emails as spam.
       */
      spam_report_drops?: number;
      /**
       * The number of recipients who marked your email as spam.
       */
      spam_reports?: number;
      /**
       * The number of unique recipients who clicked links in your emails.
       */
      unique_clicks?: number;
      /**
       * The number of unique recipients who opened your emails.
       */
      unique_opens?: number;
      /**
       * The number of emails dropped due to a recipient unsubscribing from your emails.
       */
      unsubscribe_drops?: number;
      /**
       * The number of recipients who unsubscribed from your emails.
       */
      unsubscribes?: number;
    };
    /**
     * The username of the subuser.
     */
    name?: string;
    /**
     * The type of account.
     */
    type?: string;
  }>;
};

export type suppression_group = {
  /**
   * A description of the suppression group.
   */
  description: string;
  /**
   * The id of the suppression group.
   */
  id: number;
  /**
   * Indicates if this is the default suppression group.
   */
  is_default?: boolean;
  last_email_sent_at?: unknown;
  /**
   * The name of the suppression group. Each group created by a user must have a unique name.
   */
  name: string;
  /**
   * The unsubscribes associated with this group.
   */
  unsubscribes?: number;
};

export type suppression_group_request_base = {
  /**
   * A brief description of your suppression group. Required when creating a group.
   */
  description?: string;
  /**
   * Indicates if you would like this to be your default suppression group.
   */
  is_default?: boolean;
  /**
   * The name of your suppression group. Required when creating a group.
   */
  name?: string;
};

export type suppressions_request = {
  /**
   * The array of email addresses to add or find.
   */
  recipient_emails: Array<string>;
};

export type TNE_senderID = {
  /**
   * The unique identifier of the sender.
   */
  id?: number;
} & senders_id_request_body & {
    /**
     * The time the sender identity was created.
     */
    created_at?: number;
    /**
     * A sender identity is locked when it is associated with a campaign in the Draft, Scheduled, or In Progress state. You can't update or delete a locked sender identity.
     */
    locked?: boolean;
    /**
     * The time the sender identity was last updated.
     */
    updated_at?: number;
    /**
     * Only verified sender identities can be used to send email.
     */
    verified?: {
      /**
       * The reason for a verification failure, or null if verification succeeeded or has yet to take place.
       */
      reason?: string | null;
      /**
       * Whether the sender identity has been verified. Only verified sender identities can be used to send email.
       */
      status?: boolean;
    };
  };

export type to_email_array = Array<{
  /**
   * The intended recipient's email address.
   */
  email: string;
  /**
   * The intended recipient's name.
   */
  name?: string;
}>;

export type transactional_template = transactional_templates_template_lean & {
  warning?: transactional_template_warning;
};

export type transactional_template_version_create = {
  /**
   * Set the version as the active version associated with the template (0 is inactive, 1 is active). Only one version of a template can be active. The first version created for a template will automatically be set to Active.
   */
  active?: 0 | 1;
  /**
   * The editor used in the UI.
   */
  editor?: 'code' | 'design';
  /**
   * If true, plain_content is always generated from html_content. If false, plain_content is not altered.
   */
  generate_plain_content?: boolean;
  /**
   * The HTML content of the version. Maximum of 1048576 bytes allowed.
   */
  html_content?: string;
  /**
   * Name of the transactional template version.
   */
  name: string;
  /**
   * Text/plain content of the transactional template version. Maximum of 1048576 bytes allowed.
   */
  plain_content?: string;
  /**
   * Subject of the new transactional template version.
   */
  subject: string;
  /**
   * For dynamic templates only, the mock json data that will be used for template preview and test sends.
   */
  test_data?: string;
};

/**
 * Set the version as the active version associated with the template (0 is inactive, 1 is active). Only one version of a template can be active. The first version created for a template will automatically be set to Active.
 */
export type active = 0 | 1;

export type transactional_template_version_output = {
  warnings?: Array<transactional_template_warning>;
} & transactional_template_version_create &
  transactional_templates_version_output_lean;

export type transactional_template_warning = {
  /**
   * Warning message for the user
   */
  message?: string;
};

export type transactional_templates_template_lean = {
  /**
   * Defines the generation of the template.
   */
  generation: 'legacy' | 'dynamic';
  /**
   * The ID of the transactional template.
   */
  id: string;
  /**
   * The name for the transactional template.
   */
  name: string;
  /**
   * The date and time that this transactional template version was updated.
   */
  'updated_at ': string;
  /**
   * The different versions of this transactional template.
   */
  versions?: Array<transactional_templates_version_output_lean>;
};

/**
 * Defines the generation of the template.
 */
export type generation = 'legacy' | 'dynamic';

export type transactional_templates_version_output_lean = {
  /**
   * Set the version as the active version associated with the template. Only one version of a template can be active. The first version created for a template will automatically be set to Active.
   */
  active?: 0 | 1;
  /**
   * The editor used in the UI.
   */
  editor?: 'code' | 'design';
  /**
   * If true, plain_content is always generated from html_content. If false, plain_content is not altered.
   */
  generate_plain_content?: boolean;
  /**
   * ID of the transactional template version.
   */
  id?: string;
  /**
   * Name of the transactional template version.
   */
  name?: string;
  /**
   * Subject of the new transactional template version.
   */
  subject?: string;
  /**
   * ID of the transactional template.
   */
  template_id?: string;
  /**
   * A Thumbnail preview of the template's html content.
   */
  thumbnail_url?: string;
  /**
   * The date and time that this transactional template version was updated.
   */
  updated_at?: string;
};

export type user_profile = {
  /**
   * The street address for this user profile.
   */
  address?: string;
  /**
   * An optional second line for the street address of this user profile.
   */
  address2?: string;
  /**
   * The city for the user profile.
   */
  city?: string;
  /**
   * That company that this user profile is associated with.
   */
  company?: string;
  /**
   * Th country of this user profile.
   */
  country?: string;
  /**
   * The first name of the user.
   */
  first_name?: string;
  /**
   * The last name of the user.
   */
  last_name?: string;
  /**
   * The phone number for the user.
   */
  phone?: string;
  /**
   * The state for this user.
   */
  state?: string;
  /**
   * The website associated with this user.
   */
  website?: string;
  /**
   * The zip code for this user.
   */
  zip?: string;
};

export type user_scheduled_send_status = mail_batch_id & {
  /**
   * The status of the scheduled send.
   */
  status: 'cancel' | 'pause';
};

/**
 * The status of the scheduled send.
 */
export type status5 = 'cancel' | 'pause';

export type verified_sender_request_schema = {
  address?: string;
  address2?: string;
  city?: string;
  country?: string;
  from_email: string;
  from_name?: string;
  nickname: string;
  reply_to: string;
  reply_to_name?: string;
  state?: string;
  zip?: string;
};

export type verified_sender_response_schema = {
  address?: string;
  address2?: string;
  city?: string;
  country?: string;
  from_email?: string;
  from_name?: string;
  id?: number;
  locked?: boolean;
  nickname?: string;
  reply_to?: string;
  reply_to_name?: string;
  state?: string;
  verified?: boolean;
  zip?: string;
};

export type webhook = {
  /**
   * The one time nonce to use when "signature" is "hmac-sha1"
   */
  nonce: string;
  /**
   * The URL to invoke in the webhook
   */
  url: string;
};

export type webhooks_event_webhook_request = {
  /**
   * Receiving server could not or would not accept message.
   */
  bounce: boolean;
  /**
   * Recipient clicked on a link within the message. You need to enable Click Tracking for getting this type of event.
   */
  click: boolean;
  /**
   * Recipient's email server temporarily rejected message.
   */
  deferred: boolean;
  /**
   * Message has been successfully delivered to the receiving server.
   */
  delivered: boolean;
  /**
   * You may see the following drop reasons: Invalid SMTPAPI header, Spam Content (if spam checker app enabled), Unsubscribed Address, Bounced Address, Spam Reporting Address, Invalid, Recipient List over Package Quota
   */
  dropped: boolean;
  /**
   * Indicates if the event webhook is enabled.
   */
  enabled: boolean;
  /**
   * Recipient resubscribes to specific group by updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_resubscribe: boolean;
  /**
   * Recipient unsubscribe from specific group, by either direct link or updating preferences. You need to enable Subscription Tracking for getting this type of event.
   */
  group_unsubscribe: boolean;
  /**
   * The client ID Twilio SendGrid sends to your OAuth server or service provider to generate an OAuth access token. When passing data in this field, you must also include the oauth_token_url field.
   */
  oauth_client_id?: string;
  /**
   * The URL where Twilio SendGrid sends the Client ID and Client Secret to generate an access token. This should be your OAuth server or service provider. When passing data in this field, you must also include the oauth_client_id field.
   */
  oauth_token_url?: string;
  /**
   * Recipient has opened the HTML message. You need to enable Open Tracking for getting this type of event.
   */
  open: boolean;
  /**
   * Message has been received and is ready to be delivered.
   */
  processed: boolean;
  /**
   * Recipient marked a message as spam.
   */
  spam_report: boolean;
  /**
   * Recipient clicked on message's subscription management link. You need to enable Subscription Tracking for getting this type of event.
   */
  unsubscribe: boolean;
  /**
   * The URL that you want the event webhook to POST to.
   */
  url: string;
};

export type GetAccessSettingsActivityData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Limits the number of IPs to return.
     */
    limit?: number;
  };
};

export type GetAccessSettingsActivityResponse = {
  /**
   * An array containing the IPs that recently attempted to access your account.
   */
  result: Array<{
    /**
     * Indicates if the IP address was granted access to the account.
     */
    allowed: boolean;
    /**
     * The authentication method used when attempting access.
     */
    auth_method: string;
    /**
     * A Unix timestamp indicating when the first access attempt was made.
     */
    first_at: number;
    /**
     * The IP addressed used during the access attempt.
     */
    ip: string;
    /**
     * A Unix timestamp indicating when the most recent access attempt was made
     */
    last_at: number;
    /**
     * The geographic location from which the access attempt originated.
     */
    location: string;
  }>;
};

export type GetAccessSettingsActivityError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteAccessSettingsWhitelistData = {
  body?: {
    /**
     * An array of the IDs of the IP address that you want to remove from your allow list.
     */
    ids?: Array<number>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteAccessSettingsWhitelistResponse = {
  [key: string]: unknown;
};

export type DeleteAccessSettingsWhitelistError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetAccessSettingsWhitelistData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetAccessSettingsWhitelistResponse = ip_access_response;

export type GetAccessSettingsWhitelistError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostAccessSettingsWhitelistData = {
  body?: {
    /**
     * An array containing the IP(s) you want to allow.
     */
    ips: Array<{
      /**
       * An IP address that you want to allow.
       */
      ip: string;
    }>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostAccessSettingsWhitelistResponse = ip_access_response;

export type PostAccessSettingsWhitelistError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteAccessSettingsWhitelistRuleIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the allowed IP address that you want to retrieve.
     */
    rule_id: string;
  };
};

export type DeleteAccessSettingsWhitelistRuleIdResponse = {
  [key: string]: unknown;
};

export type DeleteAccessSettingsWhitelistRuleIdError = unknown;

export type GetAccessSettingsWhitelistRuleIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the allowed IP address that you want to retrieve.
     */
    rule_id: string;
  };
};

export type GetAccessSettingsWhitelistRuleIdResponse = ip_access_response;

export type GetAccessSettingsWhitelistRuleIdError = unknown;

export type GetAlertsData = {
  headers?: {
    Authorization?: string;
    'on-behalf-of'?: string;
  };
};

export type GetAlertsResponse = Array<{
  /**
   * A Unix timestamp indicating when the alert was created.
   */
  created_at: number;
  /**
   * The email address that the alert will be sent to.
   */
  email_to: string;
  /**
   * If the alert is of type stats_notification, this indicates how frequently the stats notifications will be sent. For example, "daily", "weekly", or "monthly".
   */
  frequency?: string;
  /**
   * The ID of the alert.
   */
  id: number;
  /**
   * If the alert is of type usage_limit, this indicates the percentage of email usage that must be reached before the alert will be sent.
   */
  percentage?: number;
  /**
   * The type of alert.
   */
  type: 'usage_limit' | 'stats_notification';
  /**
   * A Unix timestamp indicating when the alert was last modified.
   */
  updated_at?: number;
}>;

export type GetAlertsError = unknown;

export type PostAlertsData = {
  body?: {
    /**
     * The email address the alert will be sent to.
     * Example: test@example.com
     */
    email_to: string | null;
    /**
     * Required for stats_notification. How frequently the alert will be sent.
     * Example: daily
     */
    frequency?: string;
    /**
     * Required for usage_alert. When this usage threshold is reached, the alert will be sent.
     * Example: 90
     */
    percentage?: number;
    /**
     * The type of alert you want to create. Can be either usage_limit or stats_notification.
     * Example: usage_limit
     */
    type: 'stats_notification' | 'usage_limit';
  };
  headers?: {
    Authorization?: string;
    'on-behalf-of'?: string;
  };
};

export type PostAlertsResponse = {
  /**
   * A Unix timestamp indicating when the alert was created.
   */
  created_at: number;
  /**
   * The email address that the alert will be sent to.
   */
  email_to: string;
  /**
   * If the alert is of type stats_notification, this indicates how frequently the stats notifications will be sent. For example, "daily", "weekly", or "monthly".
   */
  frequency?: string;
  /**
   * The ID of the alert.
   */
  id: number;
  /**
   * "If the alert is of type usage_limit, this indicates the percentage of email usage that must be reached before the alert will be sent.
   */
  percentage?: number;
  /**
   * The type of alert.
   */
  type: string;
  /**
   * A Unix timestamp indicating when the alert was last modified.
   */
  updated_at: number;
};

export type PostAlertsError = {
  field?: string;
  message?: string;
};

export type DeleteAlertsAlertIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the alert you would like to retrieve.
     */
    alert_id: number;
  };
};

export type DeleteAlertsAlertIdResponse = {
  [key: string]: unknown;
};

export type DeleteAlertsAlertIdError = unknown;

export type GetAlertsAlertIdData = {
  headers?: {
    Authorization?: string;
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the alert you would like to retrieve.
     */
    alert_id: number;
  };
};

export type GetAlertsAlertIdResponse = {
  /**
   * A Unix timestamp indicating when the alert was created.
   */
  created_at: number;
  /**
   * The email address that the alert will be sent to.
   */
  email_to: string;
  /**
   * If the alert is of type stats_notification, this indicates how frequently the stats notifications will be sent. For example: "daily", "weekly", or "monthly".
   */
  frequency?: string;
  /**
   * The ID of the alert.
   */
  id: number;
  /**
   * If the alert is of type usage_limit, this indicates the percentage of email usage that must be reached before the alert will be sent.
   */
  percentage?: number;
  /**
   * The type of alert.
   */
  type: 'usage_alert' | 'stats_notification';
  /**
   * A Unix timestamp indicating when the alert was last modified.
   */
  updated_at: number;
};

export type GetAlertsAlertIdError = unknown;

export type PatchAlertsAlertIdData = {
  body?: {
    /**
     * The new email address you want your alert to be sent to.
     * Example: test@example.com
     */
    email_to?: string;
    /**
     * The new frequency at which to send the stats_notification alert.
     * Example: monthly
     */
    frequency?: string;
    /**
     * The new percentage threshold at which the usage_limit alert will be sent.
     * Example: 90
     */
    percentage?: number;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the alert you would like to retrieve.
     */
    alert_id: number;
  };
};

export type PatchAlertsAlertIdResponse = {
  /**
   * A Unix timestamp indicating when the alert was created.
   */
  created_at: number;
  /**
   * The email address that the alert will be sent to.
   */
  email_to: string;
  /**
   * If the alert is of type stats_notification, this indicates how frequently the stats notifications will be sent. For example: "daily", "weekly", or "monthly".
   */
  frequency?: string;
  /**
   * The ID of the alert.
   */
  id: number;
  /**
   * If the alert is of type usage_limit, this indicates the percentage of email usage that must be reached before the alert will be sent.
   */
  percentage?: number;
  /**
   * The type of alert.
   */
  type: 'usage_alert' | 'stats_notification';
  /**
   * A Unix timestamp indicating when the alert was last modified.
   */
  updated_at: number;
};

export type PatchAlertsAlertIdError = unknown;

export type GetApiKeysData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    limit?: number;
  };
};

export type GetApiKeysResponse = {
  result?: Array<api_key_name_id>;
};

export type GetApiKeysError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type CreateApiKeysData = {
  body?: {
    /**
     * The name you will use to describe this API Key.
     */
    name: string;
    /**
     * The individual permissions that you are giving to this API Key.
     */
    scopes?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type CreateApiKeysResponse = {
  api_key?: string;
  api_key_id?: string;
  name?: string;
  scopes?: Array<string>;
};

export type CreateApiKeysError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteApiKeysApiKeyIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    api_key_id: string;
  };
};

export type DeleteApiKeysApiKeyIdResponse = void;

export type DeleteApiKeysApiKeyIdError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetApiKeysApiKeyIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    api_key_id: string;
  };
};

export type GetApiKeysApiKeyIdResponse = {
  result?: Array<api_key_name_id_scopes>;
};

export type GetApiKeysApiKeyIdError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PatchApiKeysApiKeyIdData = {
  body?: {
    /**
     * The new name of the API Key.
     */
    name: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    api_key_id: string;
  };
};

export type PatchApiKeysApiKeyIdResponse = api_key_name_id;

export type PatchApiKeysApiKeyIdError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PutApiKeysApiKeyIdData = {
  body?: {
    name: string;
    scopes?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    api_key_id: string;
  };
};

export type PutApiKeysApiKeyIdResponse = api_key_name_id_scopes;

export type PutApiKeysApiKeyIdError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetAsmGroupsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    id?: number;
  };
};

export type GetAsmGroupsResponse = Array<suppression_group>;

export type GetAsmGroupsError = unknown;

export type PostAsmGroupsData = {
  body?: suppression_group_request_base;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostAsmGroupsResponse = {
  /**
   * A brief description of the suppression group.
   */
  description: string;
  /**
   * The ID of the suppression group.
   */
  id: number;
  /**
   * Indicates if this is the default suppression group.
   */
  is_default: boolean;
  /**
   * The name of the suppression group.
   */
  name: string;
};

export type PostAsmGroupsError = unknown;

export type DeleteAsmGroupsGroupIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the suppression group you would like to retrieve.
     */
    group_id: string;
  };
};

export type DeleteAsmGroupsGroupIdResponse = {
  [key: string]: unknown;
};

export type DeleteAsmGroupsGroupIdError = unknown;

export type GetAsmGroupsGroupIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the suppression group you would like to retrieve.
     */
    group_id: string;
  };
};

export type GetAsmGroupsGroupIdResponse = suppression_group_request_base & {
  /**
   * The ID of the suppression group.
   */
  id: number;
  last_email_sent_at?: string | null;
  /**
   * The number of unsubscribes, or suppressions, in this group.
   */
  unsubscribes?: number;
};

export type GetAsmGroupsGroupIdError = unknown;

export type PatchAsmGroupsGroupIdData = {
  body?: suppression_group_request_base;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the suppression group you would like to retrieve.
     */
    group_id: string;
  };
};

export type PatchAsmGroupsGroupIdResponse = suppression_group;

export type PatchAsmGroupsGroupIdError = unknown;

export type GetAsmGroupsGroupIdSuppressionsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the unsubscribe group that you are adding suppressions to.
     */
    group_id: string;
  };
};

export type GetAsmGroupsGroupIdSuppressionsResponse = Array<string>;

export type GetAsmGroupsGroupIdSuppressionsError = unknown;

export type PostAsmGroupsGroupIdSuppressionsData = {
  body?: suppressions_request;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the unsubscribe group that you are adding suppressions to.
     */
    group_id: string;
  };
};

export type PostAsmGroupsGroupIdSuppressionsResponse = {
  /**
   * The email addresses you added to the unsubscribe group
   */
  recipient_emails?: Array<string>;
};

export type PostAsmGroupsGroupIdSuppressionsError = unknown;

export type PostAsmGroupsGroupIdSuppressionsSearchData = {
  body?: suppressions_request;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the suppression group that you would like to search.
     */
    group_id: string;
  };
};

export type PostAsmGroupsGroupIdSuppressionsSearchResponse = Array<string>;

export type PostAsmGroupsGroupIdSuppressionsSearchError = unknown;

export type DeleteAsmGroupsGroupIdSuppressionsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address that you want to remove from the suppression group.
     */
    email: string;
    /**
     * The id of the suppression group that you are removing an email address from.
     */
    group_id: string;
  };
};

export type DeleteAsmGroupsGroupIdSuppressionsEmailResponse = unknown;

export type DeleteAsmGroupsGroupIdSuppressionsEmailError = unknown;

export type GetAsmSuppressionsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetAsmSuppressionsResponse = Array<{
  /**
   * A UNIX timestamp indicating when the suppression was created.
   */
  created_at: number;
  /**
   * The email address that was suppressed.
   */
  email: string;
  /**
   * The id of the suppression group that this email address belongs to.
   */
  group_id: number;
  /**
   * The name of the suppression group that this email address belongs to.
   */
  group_name: string;
}>;

export type GetAsmSuppressionsError = unknown;

export type PostAsmSuppressionsGlobalData = {
  body?: suppressions_request;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostAsmSuppressionsGlobalResponse = {
  /**
   * The email addresses that are globally suppressed
   */
  recipient_emails: Array<string>;
};

export type PostAsmSuppressionsGlobalError = unknown;

export type DeleteAsmSuppressionsGlobalEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of the global suppression you want to retrieve. Or, if you want to check if an email address is on the global suppressions list, enter that email address here.
     */
    email: string;
  };
};

export type DeleteAsmSuppressionsGlobalEmailResponse = {
  [key: string]: unknown;
};

export type DeleteAsmSuppressionsGlobalEmailError = unknown;

export type GetAsmSuppressionsGlobalEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of the global suppression you want to retrieve. Or, if you want to check if an email address is on the global suppressions list, enter that email address here.
     */
    email: string;
  };
};

export type GetAsmSuppressionsGlobalEmailResponse = {
  /**
   * The email address that is globally suppressed. This will be an empty object if the email address you included in your call is not globally suppressed.
   */
  recipient_email: string;
};

export type GetAsmSuppressionsGlobalEmailError = unknown;

export type GetAsmSuppressionsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address that you want to search suppression groups for.
     */
    email: string;
  };
};

export type GetAsmSuppressionsEmailResponse = {
  /**
   * The array of suppression groups.
   */
  suppressions: Array<{
    /**
     * The description of the suppression group.
     */
    description: string;
    /**
     * The id of the suppression group.
     */
    id: number;
    /**
     * Indicates if the suppression group  is set as the default.
     */
    is_default: boolean;
    /**
     * The name of the suppression group.
     */
    name: string;
    /**
     * Indicates if the given email address is suppressed for this group.
     */
    suppressed: boolean;
  }>;
};

export type GetAsmSuppressionsEmailError = unknown;

export type GetBrowsersStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The browsers to get statistics for. You can include up to 10 different browsers by including this parameter multiple times.
     */
    browsers?: string;
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to return.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetBrowsersStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_clicks;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetBrowsersStatsError = unknown;

export type GetCampaignsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The number of results you would like to receive at a time.
     */
    limit?: number;
    /**
     * The index of the first campaign to return, where 0 is the first campaign.
     */
    offset?: number;
  };
};

export type GetCampaignsResponse = {
  result?: Array<campaign_response>;
};

export type GetCampaignsError = unknown;

export type PostCampaignsData = {
  body?: campaign_request;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostCampaignsResponse = campaign_response;

export type PostCampaignsError =
  | global_error_response_schema
  | {
      [key: string]: unknown;
    };

export type DeleteCampaignsCampaignIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the campaign you would like to retrieve.
     */
    campaign_id: number;
  };
};

export type DeleteCampaignsCampaignIdResponse = unknown;

export type DeleteCampaignsCampaignIdError = {
  [key: string]: unknown;
};

export type GetCampaignsCampaignIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the campaign you would like to retrieve.
     */
    campaign_id: number;
  };
};

export type GetCampaignsCampaignIdResponse = {
  categories?: Array<string>;
  custom_unsubscribe_url?: string;
  html_content?: string;
  id?: number;
  ip_pool?: string;
  list_ids?: Array<number>;
  plain_content?: string;
  segment_ids?: Array<number>;
  sender_id?: number;
  status?: string;
  subject?: string;
  suppression_group_id?: number;
  title?: string;
};

export type GetCampaignsCampaignIdError = {
  [key: string]: unknown;
};

export type PatchCampaignsCampaignIdData = {
  body?: {
    /**
     * The categories you want to tag on this campaign.
     */
    categories: Array<string>;
    /**
     * The HTML content of this campaign.
     */
    html_content: string;
    /**
     * The plain content of this campaign.
     */
    plain_content: string;
    /**
     * The subject line for your campaign.
     */
    subject: string;
    /**
     * The title of the campaign.
     */
    title: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the campaign you would like to retrieve.
     */
    campaign_id: number;
  };
};

export type PatchCampaignsCampaignIdResponse = campaign_response;

export type PatchCampaignsCampaignIdError =
  | {
      [key: string]: unknown;
    }
  | global_error_response_schema;

export type DeleteCampaignsCampaignIdSchedulesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type DeleteCampaignsCampaignIdSchedulesResponse = unknown;

export type DeleteCampaignsCampaignIdSchedulesError = global_error_response_schema;

export type GetCampaignsCampaignIdSchedulesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type GetCampaignsCampaignIdSchedulesResponse = {
  send_at: number;
};

export type GetCampaignsCampaignIdSchedulesError = global_error_response_schema;

export type PatchCampaignsCampaignIdSchedulesData = {
  body?: {
    send_at: number;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type PatchCampaignsCampaignIdSchedulesResponse = {
  /**
   * The campaign ID
   */
  id: number;
  /**
   * The unix timestamp to send the campaign.
   */
  send_at: number;
  /**
   * The status of the schedule.
   */
  status: string;
};

export type PatchCampaignsCampaignIdSchedulesError = global_error_response_schema;

export type PostCampaignsCampaignIdSchedulesData = {
  body?: {
    /**
     * The unix timestamp for the date and time you would like your campaign to be sent out.
     */
    send_at: number;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type PostCampaignsCampaignIdSchedulesResponse = {
  /**
   * The campaign ID.
   */
  id: number;
  /**
   * The date time you scheduled your campaign to be sent.
   */
  send_at: number;
  /**
   * The status of your campaign.
   */
  status: 'Scheduled';
};

export type PostCampaignsCampaignIdSchedulesError = global_error_response_schema;

export type PostCampaignsCampaignIdSchedulesNowData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type PostCampaignsCampaignIdSchedulesNowResponse = {
  id: number;
  status: string;
};

export type PostCampaignsCampaignIdSchedulesNowError = global_error_response_schema;

export type PostCampaignsCampaignIdSchedulesTestData = {
  body?: {
    /**
     * The email address that should receive the test campaign.
     */
    to: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    campaign_id: number;
  };
};

export type PostCampaignsCampaignIdSchedulesTestResponse = {
  to: string;
};

export type PostCampaignsCampaignIdSchedulesTestError = global_error_response_schema;

export type GetCategoriesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Allows you to perform a prefix search on this particular category.
     */
    category?: string;
    /**
     * The number of categories to display per page.
     */
    limit?: number;
    /**
     * The point in the list that you would like to begin displaying results.
     */
    offset?: number;
  };
};

export type GetCategoriesResponse = Array<{
  /**
   * A category used to group emails by broad topic.
   */
  category: string;
}>;

export type GetCategoriesError = {
  /**
   * The error returned.
   */
  errors?: Array<{
    field: string;
    /**
     * A message explaining why your categories could not be retrieved.
     */
    message: string;
  }>;
};

export type GetCategoriesStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The individual categories that you want to retrieve statistics for. You may include up to 10 different categories.
     */
    categories: string;
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to include.
     */
    limit?: number;
    /**
     * The number of results to skip.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD
     */
    start_date: string;
  };
};

export type GetCategoriesStatsResponse = Array<category_stats>;

export type GetCategoriesStatsError = unknown;

export type GetCategoriesStatsSumsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * Limits the number of results returned.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The direction you want to sort.
     */
    sort_by_direction?: 'desc' | 'asc';
    /**
     * The metric that you want to sort by.  Must be a single metric.
     */
    sort_by_metric?: string;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetCategoriesStatsSumsResponse = category_stats;

export type GetCategoriesStatsSumsError = unknown;

export type GetClientsStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetClientsStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_opens;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetClientsStatsError = unknown;

export type GetClientsClientTypeStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * Specifies the type of client to retrieve stats for. Must be either "phone", "tablet", "webmail", or "desktop".
     */
    client_type: 'phone' | 'tablet' | 'webmail' | 'desktop';
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetClientsClientTypeStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_opens;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetClientsClientTypeStatsError = unknown;

export type GetContactdbCustomFieldsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbCustomFieldsResponse = {
  custom_fields: Array<contactdb_custom_field_with_id>;
};

export type GetContactdbCustomFieldsError = global_error_response_schema;

export type PostContactdbCustomFieldsData = {
  body?: {
    name?: string;
    type?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostContactdbCustomFieldsResponse = contactdb_custom_field_with_id;

export type PostContactdbCustomFieldsError = global_error_response_schema;

export type DeleteContactdbCustomFieldsCustomFieldIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the custom field that you want to retrieve.
     */
    custom_field_id: number;
  };
};

export type DeleteContactdbCustomFieldsCustomFieldIdResponse = global_error_response_schema;

export type DeleteContactdbCustomFieldsCustomFieldIdError = global_error_response_schema;

export type GetContactdbCustomFieldsCustomFieldIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the custom field that you want to retrieve.
     */
    custom_field_id: number;
  };
};

export type GetContactdbCustomFieldsCustomFieldIdResponse = contactdb_custom_field_with_id;

export type GetContactdbCustomFieldsCustomFieldIdError = global_error_response_schema;

export type DeleteContactdbListsData = {
  body?: Array<number>;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteContactdbListsResponse = unknown;

export type DeleteContactdbListsError = global_error_response_schema;

export type GetContactdbListsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbListsResponse = {
  lists: Array<contactdb_list>;
};

export type GetContactdbListsError = unknown;

export type PostContactdbListsData = {
  body?: {
    name: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostContactdbListsResponse = contactdb_list;

export type PostContactdbListsError = global_error_response_schema;

export type DeleteContactdbListsListIdData = {
  body?: unknown;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    list_id: string;
  };
  query?: {
    /**
     * Adds the ability to delete all contacts on the list in addition to deleting the list.
     */
    delete_contacts?: boolean;
  };
};

export type DeleteContactdbListsListIdResponse = unknown;

export type DeleteContactdbListsListIdError = global_error_response_schema;

export type GetContactdbListsListIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    list_id: string;
  };
  query?: {
    /**
     * The ID of the list to retrieve.
     */
    list_id?: number;
  };
};

export type GetContactdbListsListIdResponse = contactdb_list;

export type GetContactdbListsListIdError = global_error_response_schema;

export type PatchContactdbListsListIdData = {
  body?: {
    /**
     * The new name for your list.
     */
    name: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    list_id: string;
  };
  query: {
    /**
     * The ID of the list you are updating.
     */
    list_id: number;
  };
};

export type PatchContactdbListsListIdResponse = {
  /**
   * The ID of the list
   */
  id?: number;
  /**
   * The new name for the list
   */
  name?: string;
  /**
   * The number of recipients on the list
   */
  recipient_count?: number;
};

export type PatchContactdbListsListIdError = global_error_response_schema;

export type GetContactdbListsListIdRecipientsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the list of recipients you want to retrieve.
     */
    list_id: number;
  };
  query: {
    /**
     * The ID of the list whose recipients you are requesting.
     */
    list_id: number;
    /**
     * Page index of first recipient to return (must be a positive integer)
     */
    page?: number;
    /**
     * Number of recipients to return at a time (must be a positive integer between 1 and 1000)
     */
    page_size?: number;
  };
};

export type GetContactdbListsListIdRecipientsResponse = {
  recipients?: Array<contactdb_recipient>;
};

export type GetContactdbListsListIdRecipientsError =
  | global_error_response_schema
  | {
      [key: string]: unknown;
    };

export type PostContactdbListsListIdRecipientsData = {
  body?: Array<number>;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The id of the list of recipients you want to retrieve.
     */
    list_id: number;
  };
};

export type PostContactdbListsListIdRecipientsResponse = unknown;

export type PostContactdbListsListIdRecipientsError = global_error_response_schema;

export type DeleteContactdbListsListIdRecipientsRecipientIdData = {
  body?: unknown;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the list that you want to add the recipient to.
     */
    list_id: number;
    /**
     * The ID of the recipient you are adding to the list.
     */
    recipient_id: string;
  };
  query: {
    /**
     * The ID of the list you are taking this recipient away from.
     */
    list_id: number;
    /**
     * The ID of the recipient to take off the list.
     */
    recipient_id: number;
  };
};

export type DeleteContactdbListsListIdRecipientsRecipientIdResponse = unknown;

export type DeleteContactdbListsListIdRecipientsRecipientIdError = global_error_response_schema;

export type PostContactdbListsListIdRecipientsRecipientIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the list that you want to add the recipient to.
     */
    list_id: number;
    /**
     * The ID of the recipient you are adding to the list.
     */
    recipient_id: string;
  };
};

export type PostContactdbListsListIdRecipientsRecipientIdResponse = unknown;

export type PostContactdbListsListIdRecipientsRecipientIdError = global_error_response_schema;

export type DeleteContactdbRecipientsData = {
  body?: Array<string>;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteContactdbRecipientsResponse = {
  [key: string]: unknown;
};

export type DeleteContactdbRecipientsError = global_error_response_schema;

export type GetContactdbRecipientsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Page index of first recipients to return (must be a positive integer)
     */
    page?: number;
    /**
     * Number of recipients to return at a time (must be a positive integer between 1 and 1000)
     */
    page_size?: number;
  };
};

export type GetContactdbRecipientsResponse = {
  recipients: Array<{
    [key: string]: unknown;
  }>;
};

export type GetContactdbRecipientsError =
  | {
      [key: string]: unknown;
    }
  | global_error_response_schema;

export type PatchContactdbRecipientsData = {
  body?: Array<{
    email: string;
    /**
     * The first name of the recipient. This is one of the default custom fields.
     */
    first_name?: string;
    /**
     * The last name of the recipient. This is one of the default custom fields.
     */
    last_name?: string;
  }>;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchContactdbRecipientsResponse = contactdb_recipient_response;

export type PatchContactdbRecipientsError = global_error_response_schema;

export type PostContactdbRecipientsData = {
  body?: Array<{
    age?: number;
    /**
     * The email address of the recipient.
     */
    email: string;
    /**
     * The first name of the recipient.
     */
    first_name?: string;
    /**
     * The last name of the recipient.
     */
    last_name?: string;
  }>;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostContactdbRecipientsResponse = contactdb_recipient_response;

export type PostContactdbRecipientsError = global_error_response_schema;

export type GetContactdbRecipientsBillableCountData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbRecipientsBillableCountResponse = contactdb_recipient_count;

export type GetContactdbRecipientsBillableCountError = global_error_response_schema;

export type GetContactdbRecipientsCountData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbRecipientsCountResponse = contactdb_recipient_count;

export type GetContactdbRecipientsCountError = global_error_response_schema;

export type GetContactdbRecipientsSearchData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    '{field_name}'?: string;
  };
};

export type GetContactdbRecipientsSearchResponse = {
  recipients?: Array<contactdb_recipient>;
};

export type GetContactdbRecipientsSearchError = global_error_response_schema;

export type PostContactdbRecipientsSearchData = {
  body?: {
    conditions: Array<unknown>;
    list_id: number;
  };
};

export type PostContactdbRecipientsSearchResponse = {
  recipient_count?: number;
  recipients?: Array<{
    created_at?: number;
    custom_fields?: Array<{
      id?: number;
      name?: string;
      type?: string;
      value?: number | string;
    }>;
    email?: string;
    first_name?: string;
    id?: string;
    last_clicked?: number;
    last_emailed?: number;
    last_opened?: number;
    updated_at?: number;
  }>;
};

export type PostContactdbRecipientsSearchError = unknown;

export type DeleteContactdbRecipientsRecipientIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the recipient that you want to retrieve.
     */
    recipient_id: string;
  };
};

export type DeleteContactdbRecipientsRecipientIdResponse = {
  [key: string]: unknown;
};

export type DeleteContactdbRecipientsRecipientIdError = global_error_response_schema;

export type GetContactdbRecipientsRecipientIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the recipient that you want to retrieve.
     */
    recipient_id: string;
  };
};

export type GetContactdbRecipientsRecipientIdResponse = contactdb_recipient;

export type GetContactdbRecipientsRecipientIdError =
  | {
      [key: string]: unknown;
    }
  | global_error_response_schema;

export type GetContactdbRecipientsRecipientIdListsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the recipient for whom you are retrieving lists.
     */
    recipient_id: string;
  };
};

export type GetContactdbRecipientsRecipientIdListsResponse = {
  lists?: Array<contactdb_list>;
};

export type GetContactdbRecipientsRecipientIdListsError = global_error_response_schema;

export type GetContactdbReservedFieldsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbReservedFieldsResponse = {
  reserved_fields?: Array<{
    name?: string;
    type?: string;
  }>;
};

export type GetContactdbReservedFieldsError = global_error_response_schema;

export type GetContactdbSegmentsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbSegmentsResponse = {
  segments: Array<contactdb_segments>;
};

export type GetContactdbSegmentsError = global_error_response_schema;

export type PostContactdbSegmentsData = {
  body?: contactdb_segments;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostContactdbSegmentsResponse = contactdb_segments_with_id;

export type PostContactdbSegmentsError = global_error_response_schema;

export type DeleteContactdbSegmentsSegmentIdData = {
  body?: unknown;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    segment_id: string;
  };
  query?: {
    /**
     * True to delete all contacts matching the segment in addition to deleting the segment
     */
    delete_contacts?: boolean;
  };
};

export type DeleteContactdbSegmentsSegmentIdResponse = unknown;

export type DeleteContactdbSegmentsSegmentIdError = global_error_response_schema;

export type GetContactdbSegmentsSegmentIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    segment_id: string;
  };
  query: {
    /**
     * The ID of the segment you want to request.
     */
    segment_id: number;
  };
};

export type GetContactdbSegmentsSegmentIdResponse = contactdb_segments;

export type GetContactdbSegmentsSegmentIdError = global_error_response_schema;

export type PatchContactdbSegmentsSegmentIdData = {
  body?: {
    /**
     * The conditions by which this segment should be created.
     */
    conditions?: Array<contactdb_segments_conditions>;
    /**
     * The list ID you would like this segment to be built from.
     */
    list_id?: number;
    name: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    segment_id: string;
  };
  query?: {
    /**
     * The ID of the segment you are updating.
     */
    segment_id?: string;
  };
};

export type PatchContactdbSegmentsSegmentIdResponse = contactdb_segments;

export type PatchContactdbSegmentsSegmentIdError = global_error_response_schema;

export type GetContactdbSegmentsSegmentIdRecipientsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the segment from which you want to retrieve recipients.
     */
    segment_id: number;
  };
  query?: {
    page?: number;
    page_size?: number;
  };
};

export type GetContactdbSegmentsSegmentIdRecipientsResponse = {
  recipients: Array<contactdb_recipient>;
};

export type GetContactdbSegmentsSegmentIdRecipientsError =
  | {
      [key: string]: unknown;
    }
  | global_error_response_schema;

export type GetContactdbStatusData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetContactdbStatusResponse = {
  status?: Array<{
    ''?: string;
    /**
     * Valid values are "worker_delay" and "worker_delay_seconds" (the second value appears only if "worker_delay" has a value of "delayed").
     */
    id?: string;
    /**
     * Valid values for the ID "worker_delay" are "OK" or "Delayed". Valid values for the ID "worker_delay_seconds" is the time of delay to upload.
     */
    value?: string;
  }>;
};

export type GetContactdbStatusError = unknown;

export type ListDesignsData = {
  query?: {
    /**
     * number of results to return
     */
    page_size?: number;
    /**
     * token corresponding to a specific page of results, as provided by metadata
     */
    page_token?: string;
    /**
     * set to false to return all fields
     */
    summary?: boolean;
  };
};

export type ListDesignsResponse = {
  _metadata?: _metadata;
  result?: Array<design_output_summary>;
};

export type ListDesignsError = unknown;

export type PostDesignsData = {
  body?: design_input;
};

export type PostDesignsResponse = design_output;

export type PostDesignsError = api_errors;

export type ListSendgridPreBuiltDesignsData = {
  query?: {
    /**
     * number of results to return
     */
    page_size?: number;
    /**
     * token corresponding to a specific page of results, as provided by metadata
     */
    page_token?: string;
    /**
     * set to false to return all fields
     */
    summary?: boolean;
  };
};

export type ListSendgridPreBuiltDesignsResponse = {
  _metadata?: _metadata;
  result?: Array<design_output_summary>;
};

export type ListSendgridPreBuiltDesignsError = unknown;

export type GetSendgridPreBuiltDesignData = {
  path: {
    /**
     * The ID of the pre-built Design you want to duplicate.
     */
    id: string;
  };
};

export type GetSendgridPreBuiltDesignResponse = design_output;

export type GetSendgridPreBuiltDesignError = api_errors;

export type PostSendgridPreBuiltDesignData = {
  body?: design_duplicate_input;
  path: {
    /**
     * The ID of the pre-built Design you want to duplicate.
     */
    id: string;
  };
};

export type PostSendgridPreBuiltDesignResponse = design_output;

export type PostSendgridPreBuiltDesignError = api_errors;

export type DeleteDesignData = {
  path: {
    /**
     * The ID of the Design you want to duplicate.
     */
    id: string;
  };
};

export type DeleteDesignResponse = {
  [key: string]: unknown;
};

export type DeleteDesignError = api_errors;

export type GetDesignData = {
  path: {
    /**
     * The ID of the Design you want to duplicate.
     */
    id: string;
  };
};

export type GetDesignResponse = design_output;

export type GetDesignError = api_errors;

export type PutDesignData = {
  body?: {
    /**
     * The list of categories applied to the design
     */
    categories?: Array<string>;
    /**
     * If true, plain_content is always generated from html_content. If false, plain_content is not altered.
     */
    generate_plain_content?: boolean;
    /**
     * The HTML content of the Design.
     */
    html_content?: string;
    /**
     * Name of the Design.
     */
    name?: string;
    /**
     * Plain text content of the Design.
     */
    plain_content?: string;
    /**
     * Subject of the Design.
     */
    subject?: string;
  };
  path: {
    /**
     * The ID of the Design you want to duplicate.
     */
    id: string;
  };
};

export type PutDesignResponse = design_output;

export type PutDesignError = api_errors;

export type PostDesignData = {
  body?: design_duplicate_input;
  path: {
    /**
     * The ID of the Design you want to duplicate.
     */
    id: string;
  };
};

export type PostDesignResponse = design_output;

export type PostDesignError = api_error | api_errors;

export type GetDevicesStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to return.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetDevicesStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_opens;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetDevicesStatsError = unknown;

export type GetGeoStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The country you would like to see statistics for. Currently only supported for US and CA.
     */
    country?: 'US' | 'CA';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to return.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetGeoStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_clicks_opens;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetGeoStatsError = unknown;

export type GetIpsData = {
  query?: {
    /**
     * Should we exclude reverse DNS records (whitelabels)?
     */
    exclude_whitelabels?: boolean;
    /**
     * The IP address to get
     */
    ip?: string;
    /**
     * The number of IPs you want returned at the same time.
     */
    limit?: number;
    /**
     * The offset for the number of IPs that you are requesting.
     */
    offset?: number;
    /**
     * The direction to sort the results.
     */
    sort_by_direction?: 'desc' | 'asc';
    /**
     * The subuser you are requesting for.
     */
    subuser?: string;
  };
};

export type GetIpsResponse = Array<{
  /**
   * The date that the IP address was assigned to the user.
   */
  assigned_at: number | null;
  /**
   * An IP address.
   */
  ip: string;
  /**
   * The IP pools that this IP has been added to.
   */
  pools: Array<string>;
  /**
   * The reverse DNS record for this IP address.
   */
  rdns?: string;
  /**
   * The date that the IP address was entered into warmup.
   */
  start_date: number | null;
  /**
   * The subusers that are able to send email from this IP.
   */
  subusers: Array<string>;
  /**
   * Indicates if this IP address is currently warming up.
   */
  warmup: boolean;
  /**
   * Indicates if this IP address is associated with a reverse DNS record.
   */
  whitelabeled: boolean;
}>;

export type GetIpsError = unknown;

export type PostIpsData = {
  body?: {
    /**
     * The amount of IPs to add to the account.
     */
    count: number;
    /**
     * Array of usernames to be assigned a send IP.
     */
    subusers?: Array<string>;
    /**
     * Whether or not to warmup the IPs being added.
     */
    warmup?: boolean;
  };
};

export type PostIpsResponse = {
  /**
   * List of IP objects.
   */
  ips: Array<{
    /**
     * IP added to account.
     */
    ip: string;
    /**
     * Array of usernames assigned a send IP.
     */
    subusers: Array<string>;
  }>;
  /**
   * The number of IPs that can still be added to the user.
   */
  remaining_ips: number;
  /**
   * Whether or not the IPs are being warmed up.
   */
  warmup: boolean;
};

export type PostIpsError = global_error_response_schema;

export type GetIpsAssignedResponse = Array<{
  /**
   * The IP address.
   */
  ip: string;
  /**
   * The IP pools that this IP address has been added to.
   */
  pools: Array<string>;
  /**
   * The start date that this IP address was entered into warmup.
   */
  start_date: number;
  /**
   * Indicates if this IP address is currently warming up.
   */
  warmup: boolean;
}>;

export type GetIpsAssignedError = unknown;

export type GetIpsPoolsResponse = Array<ip_pool_response>;

export type GetIpsPoolsError = unknown;

export type PostIpsPoolsData = {
  body?: {
    /**
     * The name of your new IP pool.
     */
    name: string;
  };
};

export type PostIpsPoolsResponse = ip_pool_response;

export type PostIpsPoolsError = unknown;

export type DeleteIpsPoolsPoolNameData = {
  path: {
    /**
     * The name of the IP pool that you want to retrieve the IP addresses for.
     */
    pool_name: string;
  };
};

export type DeleteIpsPoolsPoolNameResponse = {
  [key: string]: unknown;
};

export type DeleteIpsPoolsPoolNameError = {
  /**
   * An error explaining why the pool could not be deleted.
   */
  error?: string;
};

export type GetIpsPoolsPoolNameData = {
  path: {
    /**
     * The name of the IP pool that you want to retrieve the IP addresses for.
     */
    pool_name: string;
  };
};

export type GetIpsPoolsPoolNameResponse = {
  /**
   * The IP addresses that belong to this pool.
   */
  ips?: Array<string>;
  /**
   * The name of the IP pool.
   */
  pool_name?: string;
};

export type GetIpsPoolsPoolNameError = {
  errors?: Array<{
    /**
     * The name of the error.
     */
    field?: string;
    /**
     * A message explaining why the IP addresses could not be listed.
     */
    message?: string;
  }>;
};

export type PutIpsPoolsPoolNameData = {
  body?: {
    /**
     * The new name for your IP pool.
     */
    name?: string;
  };
  path: {
    /**
     * The name of the IP pool that you want to retrieve the IP addresses for.
     */
    pool_name: string;
  };
};

export type PutIpsPoolsPoolNameResponse = ip_pool_response;

export type PutIpsPoolsPoolNameError = {
  errors?: Array<{
    field?: unknown;
    /**
     * A message explaining why the name of your IP pool could not be updated.
     */
    message?: string;
  }>;
};

export type PostIpsPoolsPoolNameIpsData = {
  body?: {
    /**
     * The IP address that you want to add to the named pool.
     */
    ip?: string;
  };
  path: {
    /**
     * The name of the IP pool you want to add the address to. If the name contains spaces, they must be URL encoded (e.g., "Test Pool" becomes "Test%20Pool").
     */
    pool_name: string;
  };
};

export type PostIpsPoolsPoolNameIpsResponse = {
  /**
   * The IP address.
   */
  ip: string;
  /**
   * The IP pools that this IP address has been added to.
   */
  pools: Array<string>;
  /**
   * A Unix timestamp indicating when the warmup process began for the added IP address.
   */
  start_date: number;
  /**
   * Indicates if the IP address is in warmup.
   */
  warmup: boolean;
};

export type PostIpsPoolsPoolNameIpsError = {
  /**
   * The error returned.
   */
  errors?: Array<{
    field?: unknown;
    /**
     * A message explaining why the IP address could not be added to the IP Pool.
     */
    message?: string;
  }>;
};

export type DeleteIpsPoolsPoolNameIpsIpData = {
  path: {
    /**
     * The IP address that you wish to remove.
     */
    ip: string;
    /**
     * The name of the IP pool that you are removing the IP address from.
     */
    pool_name: string;
  };
};

export type DeleteIpsPoolsPoolNameIpsIpResponse = {
  [key: string]: unknown;
};

export type DeleteIpsPoolsPoolNameIpsIpError = {
  /**
   * An error explaining why the IP address could not be removed from the IP pool.
   */
  error?: string;
};

export type GetIpsRemainingResponse = {
  results: Array<{
    /**
     * The length of time until user can add more IPs.
     */
    period: string;
    /**
     * The current cost to add an IP.
     */
    price_per_ip: number;
    /**
     * The number of IPs that can still be added to the user.
     */
    remaining: number;
  }>;
};

export type GetIpsRemainingError = unknown;

export type GetIpsWarmupResponse = ip_warmup_response;

export type GetIpsWarmupError = unknown;

export type PostIpsWarmupData = {
  body?: {
    /**
     * The IP address that you want to begin warming up.
     */
    ip?: string;
  };
};

export type PostIpsWarmupResponse = ip_warmup_response;

export type PostIpsWarmupError = {
  /**
   * The errors that were encountered.
   */
  errors?: Array<{
    field?: unknown;
    /**
     * A message explaining why the IP couldn't entered into warmup mode.
     */
    message?: string;
  }>;
};

export type DeleteIpsWarmupIpAddressData = {
  path: {
    /**
     * The IP address that you want to retrieve the warmup status for.
     */
    ip_address: string;
  };
};

export type DeleteIpsWarmupIpAddressResponse = {
  [key: string]: unknown;
};

export type DeleteIpsWarmupIpAddressError = {
  /**
   * The errors that were encountered.
   */
  errors?: Array<{
    field?: unknown;
    /**
     * A message explaining why the IP couldn't be removed from warmup.
     */
    message?: string;
  }>;
};

export type GetIpsWarmupIpAddressData = {
  path: {
    /**
     * The IP address that you want to retrieve the warmup status for.
     */
    ip_address: string;
  };
};

export type GetIpsWarmupIpAddressResponse = ip_warmup_response;

export type GetIpsWarmupIpAddressError = {
  /**
   * The errors that were encountered.
   */
  errors?: Array<{
    field?: unknown;
    /**
     * A message explaining why the warmup status could not be retrieved.
     */
    message?: string;
  }>;
};

export type GetIpsIpAddressData = {
  path: {
    /**
     * The IP address you are retrieving the IP pools for.
     */
    ip_address: string;
  };
};

export type GetIpsIpAddressResponse = {
  /**
   * The IP address.
   */
  ip: string;
  /**
   * The list of IP pools that this IP address belongs to.
   */
  pools: Array<string>;
  /**
   * The reverse DNS record for this IP address.
   */
  rdns: string;
  /**
   * The date that the IP address was entered into warmup.
   */
  start_date: number | null;
  /**
   * The subusers that can send email using this IP address.
   */
  subusers: Array<string>;
  /**
   * Indicates if this IP address is currently warming up.
   */
  warmup: boolean;
  /**
   * Indicates if this IP address is associated with a reverse DNS record.
   */
  whitelabeled: boolean;
};

export type GetIpsIpAddressError = unknown;

export type PostMailBatchData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostMailBatchResponse = mail_batch_id;

export type PostMailBatchError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMailBatchBatchIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    batch_id: string;
  };
};

export type GetMailBatchBatchIdResponse = mail_batch_id;

export type GetMailBatchBatchIdError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostMailSendData = {
  body?: {
    /**
     * An object allowing you to specify how to handle unsubscribes.
     */
    asm?: {
      /**
       * The unsubscribe group to associate with this email.
       */
      group_id: number;
      /**
       * An array containing the unsubscribe groups that you would like to be displayed on the unsubscribe preferences page.
       */
      groups_to_display?: Array<number>;
    };
    /**
     * An array of objects where you can specify any attachments you want to include.
     */
    attachments?: Array<{
      /**
       * The Base64 encoded content of the attachment.
       */
      content: string;
      /**
       * The attachment's content ID. This is used when the disposition is set to `“inline”` and the attachment is an image, allowing the file to be displayed within the body of your email.
       */
      content_id?: string;
      /**
       * The attachment's content-disposition, specifying how you would like the attachment to be displayed. For example, `“inline”` results in the attached file are displayed automatically within the message while `“attachment”` results in the attached file require some action to be taken before it is displayed, such as opening or downloading the file.
       */
      disposition?: 'inline' | 'attachment';
      /**
       * The attachment's filename.
       */
      filename: string;
      /**
       * The MIME type of the content you are attaching (e.g., `“text/plain”` or `“text/html”`).
       */
      type?: string;
    }>;
    /**
     * An ID representing a batch of emails to be sent at the same time. Including a `batch_id` in your request allows you include this email in that batch. It also enables you to cancel or pause the delivery of that batch. For more information, see the [Cancel Scheduled Sends API](https://sendgrid.com/docs/api-reference/).
     */
    batch_id?: string;
    /**
     * An array of category names for this message. Each category name may not exceed 255 characters.
     */
    categories?: Array<string>;
    /**
     * An array where you can specify the content of your email. You can include multiple [MIME types](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types) of content, but you must specify at least one MIME type. To include more than one MIME type, add another object to the array containing the `type` and `value` parameters.
     */
    content: Array<{
      /**
       * The MIME type of the content you are including in your email (e.g., `“text/plain”` or `“text/html”`).
       */
      type: string;
      /**
       * The actual content of the specified MIME type that you are including in your email.
       */
      value: string;
    }>;
    /**
     * Values that are specific to the entire send that will be carried along with the email and its activity data.  Key/value pairs must be strings. Substitutions will not be made on custom arguments, so any string that is entered into this parameter will be assumed to be the custom argument that you would like to be used. This parameter is overridden by `custom_args` set at the personalizations level. Total `custom_args` size may not exceed 10,000 bytes.
     */
    custom_args?: string;
    from: from_email_object;
    /**
     * An object containing key/value pairs of header names and the value to substitute for them. The key/value pairs must be strings. You must ensure these are properly encoded if they contain unicode characters. These headers cannot be one of the reserved headers.
     */
    headers?: {
      [key: string]: unknown;
    };
    /**
     * The IP Pool that you would like to send this email from.
     */
    ip_pool_name?: string;
    /**
     * A collection of different mail settings that you can use to specify how you would like this email to be handled.
     */
    mail_settings?: {
      /**
       * Allows you to bypass the bounce list to ensure that the email is delivered to recipients. Spam report and unsubscribe lists will still be checked; addresses on these other lists will not receive the message. This filter cannot be combined with the `bypass_list_management` filter. See our [documentation](https://sendgrid.com/docs/ui/sending-email/index-suppressions/#bypass-suppressions) for more about bypass filters.
       */
      bypass_bounce_management?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
      };
      /**
       * Allows you to bypass all unsubscribe groups and suppressions to ensure that the email is delivered to every single recipient. This should only be used in emergencies when it is absolutely necessary that every recipient receives your email. This filter cannot be combined with any other bypass filters. See our [documentation](https://sendgrid.com/docs/ui/sending-email/index-suppressions/#bypass-suppressions) for more about bypass filters.
       */
      bypass_list_management?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
      };
      /**
       * Allows you to bypass the spam report list to ensure that the email is delivered to recipients. Bounce and unsubscribe lists will still be checked; addresses on these other lists will not receive the message. This filter cannot be combined with the `bypass_list_management` filter. See our [documentation](https://sendgrid.com/docs/ui/sending-email/index-suppressions/#bypass-suppressions) for more about bypass filters.
       */
      bypass_spam_management?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
      };
      /**
       * Allows you to bypass the global unsubscribe list to ensure that the email is delivered to recipients. Bounce and spam report lists will still be checked; addresses on these other lists will not receive the message. This filter applies only to global unsubscribes and will not bypass group unsubscribes. This filter cannot be combined with the `bypass_list_management` filter. See our [documentation](https://sendgrid.com/docs/ui/sending-email/index-suppressions/#bypass-suppressions) for more about bypass filters.
       */
      bypass_unsubscribe_management?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
      };
      /**
       * The default footer that you would like included on every email.
       */
      footer?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
        /**
         * The HTML content of your footer.
         */
        html?: string;
        /**
         * The plain text content of your footer.
         */
        text?: string;
      };
      /**
       * Sandbox Mode allows you to send a test email to ensure that your request body is valid and formatted correctly.
       */
      sandbox_mode?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
      };
    };
    /**
     * An array of messages and their metadata. Each object within personalizations can be thought of as an envelope - it defines who should receive an individual message and how that message should be handled. See our [Personalizations documentation](https://sendgrid.com/docs/for-developers/sending-email/personalizations/) for examples.
     */
    personalizations: Array<{
      /**
       * An array of recipients who will receive a blind carbon copy of your email. Each object in this array must contain the recipient's email address. Each object in the array may optionally contain the recipient's name.
       */
      bcc?: Array<cc_bcc_email_object>;
      /**
       * An array of recipients who will receive a copy of your email. Each object in this array must contain the recipient's email address. Each object in the array may optionally contain the recipient's name.
       */
      cc?: Array<cc_bcc_email_object>;
      /**
       * Values that are specific to this personalization that will be carried along with the email and its activity data. Substitutions will not be made on custom arguments, so any string that is entered into this parameter will be assumed to be the custom argument that you would like to be used. This field may not exceed 10,000 bytes.
       */
      custom_args?: {
        [key: string]: unknown;
      };
      /**
       * Dynamic template data is available using Handlebars syntax in Dynamic Transactional Templates. This field should be used in combination with a Dynamic Transactional Template, which can be identified by a `template_id` starting with `d-`. This field is a collection of key/value pairs following the pattern "variable_name":"value to insert".
       */
      dynamic_template_data?: {
        [key: string]: unknown;
      };
      from?: from_email_object;
      /**
       * A collection of JSON key/value pairs allowing you to specify handling instructions for your email. You may not overwrite the following headers: `x-sg-id`, `x-sg-eid`, `received`, `dkim-signature`, `Content-Type`, `Content-Transfer-Encoding`, `To`, `From`, `Subject`, `Reply-To`, `CC`, `BCC`
       */
      headers?: {
        [key: string]: unknown;
      };
      /**
       * A unix timestamp allowing you to specify when your email should be delivered. Scheduling delivery more than 72 hours in advance is forbidden.
       */
      send_at?: number;
      /**
       * The subject of your email. See character length requirements according to [RFC 2822](http://stackoverflow.com/questions/1592291/what-is-the-email-subject-length-limit#answer-1592310).
       */
      subject?: string;
      /**
       * Substitutions allow you to insert data without using Dynamic Transactional Templates. This field should **not** be used in combination with a Dynamic Transactional Template, which can be identified by a `template_id` starting with `d-`. This field is a collection of key/value pairs following the pattern "substitution_tag":"value to substitute". The key/value pairs must be strings. These substitutions will apply to the text and html content of the body of your email, in addition to the `subject` and `reply-to` parameters. The total collective size of your substitutions may not exceed 10,000 bytes per personalization object.
       */
      substitutions?: {
        [key: string]: unknown;
      };
      to: to_email_array;
    }>;
    reply_to?: reply_to_email_object;
    /**
     * An array of recipients who will receive replies and/or bounces. Each object in this array must contain the recipient's email address. Each object in the array may optionally contain the recipient's name. You can either choose to use “reply_to” field or “reply_to_list” but not both.
     */
    reply_to_list?: Array<{
      /**
       * The email address where any replies or bounces will be returned.
       */
      email: string;
      /**
       * A name or title associated with the `reply_to_list` email address.
       */
      name?: string;
    }>;
    /**
     * A unix timestamp allowing you to specify when you want your email to be delivered. This may be overridden by the `send_at` parameter set at the personalizations level. Delivery cannot be scheduled more than 72 hours in advance. If you have the flexibility, it's better to schedule mail for off-peak times. Most emails are scheduled and sent at the top of the hour or half hour. Scheduling email to avoid peak times — for example, scheduling at 10:53 — can result in lower deferral rates due to the reduced traffic during off-peak times.
     */
    send_at?: number;
    /**
     * The global or 'message level' subject of your email. This may be overridden by subject lines set in personalizations.
     */
    subject: string;
    /**
     * An email template ID. A template that contains a subject and content — either text or html — will override any subject and content values specified at the personalizations or message level.
     */
    template_id?: string;
    /**
     * Settings to determine how you would like to track the metrics of how your recipients interact with your email.
     */
    tracking_settings?: {
      /**
       * Allows you to track if a recipient clicked a link in your email.
       */
      click_tracking?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
        /**
         * Indicates if this setting should be included in the `text/plain` portion of your email.
         */
        enable_text?: boolean;
      };
      /**
       * Allows you to enable tracking provided by Google Analytics.
       */
      ganalytics?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
        /**
         * The name of the campaign.
         */
        utm_campaign?: string;
        /**
         * Used to differentiate your campaign from advertisements.
         */
        utm_content?: string;
        /**
         * Name of the marketing medium. (e.g. Email)
         */
        utm_medium?: string;
        /**
         * Name of the referrer source. (e.g. Google, SomeDomain.com, or Marketing Email)
         */
        utm_source?: string;
        /**
         * Used to identify any paid keywords.
         */
        utm_term?: string;
      };
      /**
       * Allows you to track if the email was opened by including a single pixel image in the body of the content. When the pixel is loaded, Twilio SendGrid can log that the email was opened.
       */
      open_tracking?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
        /**
         * Allows you to specify a substitution tag that you can insert in the body of your email at a location that you desire. This tag will be replaced by the open tracking pixel.
         */
        substitution_tag?: string;
      };
      /**
       * Allows you to insert a subscription management link at the bottom of the text and HTML bodies of your email. If you would like to specify the location of the link within your email, you may use the `substitution_tag`.
       */
      subscription_tracking?: {
        /**
         * Indicates if this setting is enabled.
         */
        enable?: boolean;
        /**
         * HTML to be appended to the email with the subscription tracking link. You may control where the link is by using the tag <% %>
         */
        html?: string;
        /**
         * A tag that will be replaced with the unsubscribe URL. for example: `[unsubscribe_url]`. If this parameter is used, it will override both the `text` and `html` parameters. The URL of the link will be placed at the substitution tag’s location with no additional formatting.
         */
        substitution_tag?: string;
        /**
         * Text to be appended to the email with the subscription tracking link. You may control where the link is by using the tag <% %>
         */
        text?: string;
      };
    };
  };
};

export type PostMailSendResponse = unknown;

export type PostMailSendError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMailSettingsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The number of settings to return.
     */
    limit?: number;
    /**
     * Where in the list of results to begin displaying settings.
     */
    offset?: number;
  };
};

export type GetMailSettingsResponse = {
  /**
   * The list of all mail settings.
   */
  result: Array<{
    /**
     * A description of the mail setting.
     */
    description: string;
    /**
     * Indicates if this mail setting is currently enabled.
     */
    enabled: boolean;
    /**
     * The name of the mail setting.
     */
    name: string;
    /**
     * The title of the mail setting.
     */
    title: string;
  }>;
};

export type GetMailSettingsError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsAddressWhitelistData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsAddressWhitelistResponse = mail_settings_address_whitelabel;

export type GetMailSettingsAddressWhitelistError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsAddressWhitelistData = {
  body?: {
    /**
     * Indicates if your email address whitelist is enabled.
     */
    enabled?: boolean;
    /**
     * Either a single email address that you want whitelisted or a domain, for which all email addresses belonging to this domain will be whitelisted.
     */
    list?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsAddressWhitelistResponse = mail_settings_address_whitelabel;

export type PatchMailSettingsAddressWhitelistError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsBouncePurgeData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsBouncePurgeResponse = mail_settings_bounce_purge;

export type GetMailSettingsBouncePurgeError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsBouncePurgeData = {
  body?: mail_settings_bounce_purge;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsBouncePurgeResponse = mail_settings_bounce_purge;

export type PatchMailSettingsBouncePurgeError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsFooterData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsFooterResponse = mail_settings_footer;

export type GetMailSettingsFooterError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsFooterData = {
  body?: mail_settings_footer;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsFooterResponse = mail_settings_footer;

export type PatchMailSettingsFooterError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsForwardBounceData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsForwardBounceResponse = mail_settings_forward_bounce;

export type GetMailSettingsForwardBounceError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsForwardBounceData = {
  body?: mail_settings_forward_bounce;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsForwardBounceResponse = mail_settings_forward_bounce;

export type PatchMailSettingsForwardBounceError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsForwardSpamData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsForwardSpamResponse = mail_settings_forward_spam;

export type GetMailSettingsForwardSpamError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsForwardSpamData = {
  body?: mail_settings_forward_spam;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsForwardSpamResponse = mail_settings_forward_spam;

export type PatchMailSettingsForwardSpamError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailSettingsTemplateData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetMailSettingsTemplateResponse = mail_settings_template;

export type GetMailSettingsTemplateError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type PatchMailSettingsTemplateData = {
  body?: {
    /**
     * Indicates if you want to enable the legacy email template mail setting.
     */
    enabled?: boolean;
    /**
     * The new HTML content for your legacy email template.
     */
    html_content?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchMailSettingsTemplateResponse = {
  /**
   * Indicates if the legacy email template mail setting is enabled.
   */
  enabled: boolean;
  /**
   * The HTML content of your legacy email template.
   */
  html_content: string;
};

export type PatchMailSettingsTemplateError = {
  errors?: Array<{
    /**
     * The ID associated with the error.
     */
    error_id?: string;
    /**
     * The field that generated the error.
     */
    field?: string | null;
    /**
     * The error message.
     */
    message: string;
    parameter?: string;
  }>;
};

export type GetMailboxProvidersStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to return.
     */
    limit?: number;
    /**
     * The mail box providers to get statistics for. You can include up to 10 by including this parameter multiple times.
     */
    mailbox_providers?: string;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetMailboxProvidersStatsResponse = Array<{
  /**
   * The date that the statistics were gathered.
   */
  date?: string;
  /**
   * The list of statistics.
   */
  stats?: Array<{
    metrics?: advanced_stats_mailbox_provider;
    /**
     * The name of the specific segmentation.
     */
    name?: string;
    /**
     * The type of segmentation.
     */
    type?: string;
  }>;
}>;

export type GetMailboxProvidersStatsError = unknown;

export type DeleteMcContactsData = {
  query?: {
    /**
     * Must be set to `"true"` to delete all contacts.
     */
    delete_all_contacts?: string;
    /**
     * A comma-separated list of contact IDs.
     */
    ids?: string;
  };
};

export type DeleteMcContactsResponse = {
  /**
   * The deletion job ID.
   */
  job_id: {
    [key: string]: unknown;
  };
};

export type DeleteMcContactsError =
  | {
      errors: Array<{
        [key: string]: unknown;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMcContatsResponse = {
  _metadata?: selfmetadata;
  contact_count?: number;
  result?: Array<contact_details3>;
};

export type GetMcContatsError =
  | {
      errors?: Array<error>;
    }
  | global_error_response_schema
  | {
      [key: string]: unknown;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PutMcContactsData = {
  body?: {
    /**
     * One or more contacts objects that you intend to upsert. The available fields for a contact, including the required `email` field are described below.
     */
    contacts: Array<contact_request>;
    /**
     * An array of List ID strings that this contact will be added to.
     */
    list_ids?: Array<string>;
  };
};

export type PutMcContactsResponse = {
  /**
   * Indicates that the contacts are queued for processing. Check the job status with the "Import Contacts Status" endpoint.
   */
  job_id?: string;
};

export type PutMcContactsError =
  | {
      errors?: Array<error>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostMarketingContactsBatchData = {
  body?: {
    ids: Array<string>;
  };
};

export type PostMarketingContactsBatchResponse = {
  result?: Array<contact_details3>;
};

export type PostMarketingContactsBatchError =
  | global_error_response_schema
  | {
      [key: string]: unknown;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMcContactsCountResponse = {
  /**
   * `billable_breakdown` will only appear to the parent user in an account with subusers.
   */
  billable_breakdown?: {
    /**
     * A map of each subuser's billable contact usage. Each key is the subuser's ID and each value is the usage thus far this month.
     */
    breakdown?: {
      [key: string]: unknown;
    };
    /**
     * The sum of all the subuser's billable contacts
     */
    total?: number;
  };
  /**
   * The count of contacts this month for billing purposes.
   */
  billable_count?: number;
  /**
   * The total number of contacts.
   */
  contact_count: number;
};

export type GetMcContactsCountError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMarketingContactsExportsResponse = {
  _metadata?: {
    /**
     * Link to next page.
     */
    next?: string;
    prev?: string;
    /**
     * Link to this page.
     */
    self?: string;
  };
  result?: Array<{
    _metadata?: {
      next?: string;
      prev?: string;
      self?: string;
    };
    /**
     * This ISO8601 timestamp when the export was completed.
     */
    completed_at?: string;
    /**
     * This ISO8601 timestamp when the export was created.
     */
    created_at?: string;
    /**
     * This ISO8601 timestamp when the export expires.
     */
    expires_at?: string;
    /**
     * Allowed types: `contacts_export`, `list_export`, or `segment_export`.
     */
    export_type?: string;
    /**
     * Export jobs ID.
     */
    id?: string;
    lists?: Array<{
      ID?: string;
      Name?: string;
    }>;
    segments?: Array<{
      ID?: string;
      Name?: string;
    }>;
    /**
     * Allowed values: `pending`, `ready`, or `failure`.
     */
    status?: string;
    /**
     * One or more download URLs for the contact file(s) if the status is `ready`.
     */
    urls?: Array<string>;
    /**
     * User ID.
     */
    user_id?: string;
  }>;
};

export type GetMarketingContactsExportsError =
  | {
      errors?: Array<{
        ''?: string;
        error_id?: string;
        message: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostMcContactsExportsData = {
  body?: {
    /**
     * File type for export file. Choose from `json` or `csv`.
     */
    file_type?: 'csv' | 'json';
    /**
     * IDs of the contact lists you want to export.
     */
    list_ids?: Array<string>;
    /**
     * The maximum size of an export file in MB. Note that when this option is specified, multiple output files may be returned from the export.
     */
    max_file_size?: number;
    notifications?: {
      email?: boolean;
    };
    /**
     * IDs of the contact segments you want to export.
     */
    segment_ids?: Array<string>;
  };
};

export type PostMcContactsExportsResponse = {
  _metadata: metadata;
  /**
   * The ID of the export job.
   */
  id?: string;
};

export type PostMcContactsExportsError =
  | {
      errors?: Array<error>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMcContactsExportsIdData = {
  path: {
    id: string;
  };
};

export type GetMcContactsExportsIdResponse = contact_export;

export type GetMcContactsExportsIdError =
  | {
      errors?: Array<error>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PutMcContactsImportsData = {
  body?: {
    /**
     * Import file header to reserved/custom field mapping.
     */
    field_mappings: Array<string | unknown>;
    /**
     * Upload file type.
     */
    file_type: 'csv';
    /**
     * All contacts will be added to each of the specified lists.
     */
    list_ids?: Array<string>;
  };
};

export type PutMcContactsImportsResponse = {
  /**
   * The ID of the import job.
   */
  job_id?: string;
  /**
   * A list of headers that must be included in PUT request.
   */
  upload_headers?: Array<{
    header: string;
    value: string;
  }>;
  /**
   * The URI to PUT the upload file to.
   */
  upload_uri?: string;
};

export type PutMcContactsImportsError =
  | {
      errors: Array<error>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMarketingContactsImportsIdData = {
  path: {
    id: string;
  };
};

export type GetMarketingContactsImportsIdResponse = contact_import;

export type GetMarketingContactsImportsIdError =
  | {
      errors?: error;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostMcContactsSearchData = {
  body?: {
    query: string;
  };
};

export type PostMcContactsSearchResponse = {
  _metadata?: selfmetadata;
  /**
   * The total number of contacts matched.
   */
  contact_count: number;
  result?: Array<contact_details3>;
};

export type PostMcContactsSearchError =
  | {
      errors?: Array<{
        field?: string;
        message?: string;
      }>;
    }
  | global_error_response_schema
  | unknown
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostMarketingContactsSearchEmailsData = {
  body?: {
    /**
     * One or more primary emails and/or alternate emails to search through your contacts for.
     */
    emails: Array<string>;
  };
};

export type PostMarketingContactsSearchEmailsResponse = {
  result?: {
    [key: string]: unknown;
  };
};

export type PostMarketingContactsSearchEmailsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMcContactsIdData = {
  path: {
    id: string;
  };
};

export type GetMcContactsIdResponse = contact_details3;

export type GetMcContactsIdError =
  | global_error_response_schema
  | unknown
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetMcFieldDefinitionsResponse = {
  _metadata?: _metadata;
  custom_fields: Array<custom_field_definitions_response>;
  reserved_fields: reserved_field_definitions_response;
};

export type GetMcFieldDefinitionsError = unknown;

export type PostMcFieldDefinitionsData = {
  body?: {
    field_type: 'Text' | 'Number' | 'Date';
    name: string;
  };
};

export type PostMcFieldDefinitionsResponse = custom_field_definitions_response & {
  _metadata?: _metadata;
};

export type PostMcFieldDefinitionsError = {
  errors: Array<error>;
};

export type DeleteMcFieldDefinitionsCustomFieldIdData = {
  path: {
    custom_field_id: string;
  };
};

export type DeleteMcFieldDefinitionsCustomFieldIdResponse = void;

export type DeleteMcFieldDefinitionsCustomFieldIdError = {
  errors: Array<error>;
};

export type PatchMcFieldDefinitionsCustomFieldIdData = {
  body?: {
    name: string;
  };
  path: {
    custom_field_id: string;
  };
};

export type PatchMcFieldDefinitionsCustomFieldIdResponse = custom_field_definitions_response & {
  _metadata?: _metadata;
};

export type PatchMcFieldDefinitionsCustomFieldIdError = {
  errors: Array<error>;
};

export type GetMcListsData = {
  query?: {
    /**
     * Maximum number of elements to return. Defaults to 100, returns 1000 max
     */
    page_size?: number;
    page_token?: string;
  };
};

export type GetMcListsResponse = {
  _metadata?: metadata;
  result?: Array<list>;
};

export type GetMcListsError = unknown;

export type PostMcListsData = {
  body?: {
    /**
     * Your name for your list
     */
    name: string;
  };
};

export type PostMcListsResponse = list;

export type PostMcListsError = {
  errors?: Array<error>;
};

export type DeleteListsIdData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * Flag indicates that all contacts on the list are also to be deleted.
     */
    delete_contacts?: boolean;
  };
};

export type DeleteListsIdResponse =
  | {
      /**
       * job_id of the async job
       */
      job_id?: string;
    }
  | string;

export type DeleteListsIdError = {
  errors: Array<{
    [key: string]: unknown;
  }>;
};

export type GetMcListsIdData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * Setting this parameter to the true  will cause the contact_sample to be returned
     */
    contact_sample?: boolean;
  };
};

export type GetMcListsIdResponse = list & {
  contact_sample?: contact_details2;
};

export type GetMcListsIdError = Array<error>;

export type PatchMcListsIdData = {
  body?: {
    /**
     * Your name for your list.
     */
    name?: string;
  };
  path: {
    id: string;
  };
};

export type PatchMcListsIdResponse = list;

export type PatchMcListsIdError =
  | {
      errors?: Array<error>;
    }
  | {
      [key: string]: unknown;
    };

export type DeleteMcListsIdContactsData = {
  path: {
    id: string;
  };
  query: {
    /**
     * comma separated list of contact ids
     */
    contact_ids: string;
  };
};

export type DeleteMcListsIdContactsResponse = {
  /**
   * job_id of the async job
   */
  job_id?: string;
};

export type DeleteMcListsIdContactsError = error | unknown;

export type GetMcListsIdContactsCountData = {
  path: {
    id: string;
  };
};

export type GetMcListsIdContactsCountResponse = {
  billable_count?: number;
  contact_count?: number;
};

export type GetMcListsIdContactsCountError = {
  [key: string]: unknown;
};

export type GetMarketingSegmentsData = {
  query?: {
    /**
     * If set to `true` segments with an empty value of `parent_list_id` will be returned in the filter.  If the value is not present it defaults to 'false'.
     */
    no_parent_list_id?: boolean;
    /**
     * A comma separated list of list ids to be used when searching for segments with the specified parent_list_id, no more than 50 is allowed
     */
    parent_list_ids?: string;
  };
};

export type GetMarketingSegmentsResponse = {
  results: Array<segment_summary>;
};

export type GetMarketingSegmentsError =
  | global_error_response_schema
  | {
      errors: Array<{
        message: string;
      }>;
    };

export type PostMarketingSegmentsData = {
  body?: segment_write_v2 & {
    /**
     * The id of the list if this segment is a child of a list.  This implies the query is rewritten as `(${query_dsl}) AND CONTAINS(list_ids, ${parent_list_id})`
     */
    parent_list_id?: string;
  };
};

export type PostMarketingSegmentsResponse = full_segment;

export type PostMarketingSegmentsError =
  | global_error_response_schema
  | {
      errors: Array<{
        message: string;
      }>;
    };

export type GetSegmentsData = {
  query?: {
    /**
     * If set to `true` segments with an empty value of `parent_list_id` will be returned in the filter.  If the value is not present it defaults to 'false'.
     */
    no_parent_list_id?: boolean;
    /**
     * A comma separated list up to 50 in size, to filter segments on.  Only segments that have any of these list ids as the parent list will be retrieved. This is different from the parameter of the same name used when creating a segment.
     */
    parent_list_ids?: string;
  };
};

export type GetSegmentsResponse = all_segments_response;

export type GetSegmentsError = errors_seg_v2 | unknown;

export type PostSegmentsData = {
  body?: segment_write_v2;
};

export type PostSegmentsResponse = segment_response;

export type PostSegmentsError = errors_seg_v2 | unknown;

export type DeleteSegmentsSegmentIdData = {
  path: {
    segment_id: string;
  };
};

export type DeleteSegmentsSegmentIdResponse = unknown;

export type DeleteSegmentsSegmentIdError = errors_seg_v2 | unknown;

export type GetSegmentsSegmentIdData = {
  path: {
    segment_id: string;
  };
  query?: {
    /**
     * Defaults to `true`. Set to `false` to exclude the contacts_sample in the response.
     */
    contacts_sample?: boolean;
  };
};

export type GetSegmentsSegmentIdResponse = segment_response;

export type GetSegmentsSegmentIdError = errors_seg_v2;

export type PatchSegmentsSegmentIdData = {
  body?: segment_update;
  path: {
    segment_id: string;
  };
};

export type PatchSegmentsSegmentIdResponse = segment_response;

export type PatchSegmentsSegmentIdError = errors_seg_v2 | unknown;

export type PostMarketingSegmentsDeleteData = {
  body?: {
    ids?: Array<string>;
  };
};

export type PostMarketingSegmentsDeleteResponse =
  | {
      errors?: Array<{
        /**
         * error message that indicates why segment cannot be deleted ("in-use", "segment not found", "invalid uuid")
         */
        error?: string;
        /**
         * Segment ID
         */
        id?: string;
        /**
         * resources in which segment is being used
         */
        resources?: {
          /**
           * the resource ids
           */
          ids?: Array<string>;
          /**
           * the type of resource in use (e.g., "automation")
           */
          type?: string;
        };
      }>;
    }
  | {
      [key: string]: unknown;
    };

export type PostMarketingSegmentsDeleteError =
  | {
      errors?: Array<{
        field?: string;
        message?: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteMarketingSegmentsSegmentIdData = {
  path: {
    segment_id: string;
  };
};

export type DeleteMarketingSegmentsSegmentIdResponse = {
  [key: string]: unknown;
};

export type DeleteMarketingSegmentsSegmentIdError =
  | global_error_response_schema
  | {
      errors: Array<{
        field: string;
        message: string;
      }>;
    }
  | {
      errors: Array<{
        message: string;
      }>;
    };

export type GetMarketingSegmentsSegmentIdData = {
  path: {
    segment_id: string;
  };
  query?: {
    /**
     * Defaults to `false`.  Set to `true` to return the parsed SQL AST as a JSON object in the field `query_json`
     */
    query_json?: boolean;
  };
};

export type GetMarketingSegmentsSegmentIdResponse = full_segment;

export type GetMarketingSegmentsSegmentIdError =
  | global_error_response_schema
  | {
      errors: Array<{
        field: string;
        message: string;
      }>;
    }
  | {
      errors: Array<{
        message: string;
      }>;
    };

export type PatchMarketingSegmentsSegmentIdData = {
  body?: segment_write_v2;
  path: {
    segment_id: string;
  };
};

export type PatchMarketingSegmentsSegmentIdResponse = full_segment;

export type PatchMarketingSegmentsSegmentIdError =
  | global_error_response_schema
  | {
      errors: Array<{
        field: string;
        message: string;
      }>;
    }
  | {
      errors: Array<{
        message: string;
      }>;
    };

export type PostMarketingSendersData = {
  body?: {
    /**
     * The physical address of the sender identity.
     */
    address: string;
    /**
     * Additional sender identity address information.
     */
    address_2?: string;
    /**
     * The city of the sender identity.
     */
    city: string;
    /**
     * The country of the sender identity.
     */
    country: string;
    from: {
      /**
       * This is where the email will appear to originate from for your recipient
       */
      email: string;
      /**
       * This is the name appended to the from email field. IE - Your name or company name.
       */
      name: string;
    };
    /**
     * A nickname for the sender identity. Not used for sending.
     */
    nickname: string;
    reply_to?: {
      /**
       * This is the email that your recipient will reply to.
       */
      email: string;
      /**
       * This is the name appended to the reply to email field. IE - Your name or company name.
       */
      name?: string;
    };
    /**
     * The state of the sender identity.
     */
    state?: string;
    /**
     * The zipcode of the sender identity.
     */
    zip?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostMarketingSendersResponse = senderID;

export type PostMarketingSendersError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteMarketingSinglesendsData = {
  query?: {
    /**
     * Single Send IDs to delete
     */
    ids?: Array<string>;
  };
};

export type DeleteMarketingSinglesendsResponse = void;

export type DeleteMarketingSinglesendsError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type GetMarketingSinglesendsData = {
  query?: {
    page_size?: number;
    page_token?: string;
  };
};

export type GetMarketingSinglesendsResponse = {
  _metadata?: _metadata;
  result?: Array<singlesend_response_short>;
};

export type GetMarketingSinglesendsError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type PostMarketingSinglesendsData = {
  body?: singlesend_request;
};

export type PostMarketingSinglesendsResponse = singlesend_response;

export type PostMarketingSinglesendsError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type GetMarketingSinglesendsCategoriesResponse = {
  /**
   * list of latest one thousand unique categories associated with all Single Sends in ascending order
   */
  categories?: Array<string>;
};

export type GetMarketingSinglesendsCategoriesError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type PostMarketingSinglesendsSearchData = {
  body?: singlesend_search;
  query?: {
    page_size?: number;
    page_token?: string;
  };
};

export type PostMarketingSinglesendsSearchResponse = {
  _metadata?: _metadata;
  result?: Array<singlesend_response_short>;
};

export type PostMarketingSinglesendsSearchError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type DeleteMarketingSinglesendsIdData = {
  path: {
    id: string;
  };
};

export type DeleteMarketingSinglesendsIdResponse = void;

export type DeleteMarketingSinglesendsIdError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type GetMarketingSinglesendsIdData = {
  path: {
    id: string;
  };
};

export type GetMarketingSinglesendsIdResponse = singlesend_response;

export type GetMarketingSinglesendsIdError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type PatchMarketingSinglesendsIdData = {
  body?: singlesend_request;
  path: {
    id: string;
  };
};

export type PatchMarketingSinglesendsIdResponse = singlesend_response;

export type PatchMarketingSinglesendsIdError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type PostMarketingSinglesendsIdData = {
  body?: {
    /**
     * The name of the duplicate Single Send. If you choose to leave the name field blank, your duplicate will be assigned the name of the Single Send it was copied from with the text 'Copy of ' prepended to it. The end of the new Single Send name, including 'Copy of ', will be trimmed if the name exceeds the character limit.
     */
    name?: string;
  };
  path: {
    id: string;
  };
};

export type PostMarketingSinglesendsIdResponse = singlesend_response;

export type PostMarketingSinglesendsIdError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type DeleteMarketingSinglesendsIdScheduleData = {
  path: {
    id: string;
  };
};

export type DeleteMarketingSinglesendsIdScheduleResponse = singlesend_schedule;

export type DeleteMarketingSinglesendsIdScheduleError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type PutMarketingSinglesendsIdScheduleData = {
  body?: {
    /**
     * This is the ISO 8601 time at which to send the Single Send; must be in future, or the string "now"
     */
    send_at: 'now';
  };
  path: {
    id: string;
  };
};

export type PutMarketingSinglesendsIdScheduleResponse = {
  send_at?: string;
  status?: 'scheduled';
};

export type PutMarketingSinglesendsIdScheduleError = {
  errors?: Array<{
    error_id?: string;
    field?: string;
    message?: string;
  }>;
};

export type GetallAutomationStatsData = {
  query?: {
    /**
     * This endpoint returns all automation IDs if no `automation_ids` are specified.
     */
    automation_ids?: Array<string>;
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
  };
};

export type GetallAutomationStatsResponse = automations_response;

export type GetallAutomationStatsError = global_error_response_schema;

export type GetAutomationsStatsExportData = {
  query?: {
    /**
     * The IDs of Automations for which to export stats.
     */
    ids?: Array<string>;
    /**
     * The [IANA Area/Region](https://en.wikipedia.org/wiki/Tz_database#Names_of_time_zones) string representing the timezone in which the stats are to be presented; i.e. `"America/Chicago"`. This parameter changes the timezone format only; it does not alter which stats are returned.
     */
    timezone?: string;
  };
};

export type GetAutomationsStatsExportResponse = string;

export type GetAutomationsStatsExportError = global_error_response_schema;

export type GetAutomationStatData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * Dictates how the stats are time-sliced. Currently, `"total"` and `"day"` are supported.
     */
    aggregated_by?: 'day' | 'total';
    /**
     * Format: `YYYY-MM-DD`.If this parameter is included, the stats' end date is included in the search.
     */
    end_date?: string;
    /**
     * Automations can have multiple steps. Including `step_id` as a `group_by` metric allows further granularity of stats.
     */
    group_by?: Array<'step_id'>;
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
    /**
     * Format: `YYYY-MM-DD`. If this parameter is included, the stats' start date is included in the search.
     */
    start_date?: string;
    /**
     * Comma-separated list of `step_ids` that you want the link stats for.
     */
    step_ids?: Array<string>;
    /**
     * [IANA Area/Region](https://en.wikipedia.org/wiki/Tz_database#Names_of_time_zones) string representing the timezone in which the stats are to be presented, e.g., "America/Chicago".
     */
    timezone?: string;
  };
};

export type GetAutomationStatResponse = automations_response;

export type GetAutomationStatError = global_error_response_schema | unknown;

export type GetAutomationLinkStatData = {
  path: {
    /**
     * The ID of the Automation you want to get click tracking stats for.
     */
    id: string;
  };
  query?: {
    /**
     * Automations can have multiple steps. Including `step_id` as a `group_by` metric allows further granularity of stats.
     */
    group_by?: Array<'step_id'>;
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
    /**
     * Comma-separated list of `step_ids` that you want the link stats for.
     */
    step_ids?: Array<string>;
  };
};

export type GetAutomationLinkStatResponse = automations_link_stats_response;

export type GetAutomationLinkStatError = global_error_response_schema;

export type GetallSinglesendStatsData = {
  query?: {
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
    /**
     * This endpoint returns all Single Send IDs if no IDs are included in `singlesend_ids`.
     */
    singlesend_ids?: Array<string>;
  };
};

export type GetallSinglesendStatsResponse = singlesends_response;

export type GetallSinglesendStatsError = global_error_response_schema;

export type GetSinglesendStatsExportData = {
  query?: {
    /**
     * The IDs of Single Sends for which to export stats.
     */
    ids?: Array<string>;
    /**
     * The [IANA Area/Region](https://en.wikipedia.org/wiki/Tz_database#Names_of_time_zones) string representing the timezone in which the stats are to be presented; i.e. `"America/Chicago"`. This parameter changes the timezone format only; it does not alter which stats are returned.
     */
    timezone?: string;
  };
};

export type GetSinglesendStatsExportResponse = string;

export type GetSinglesendStatsExportError = unknown;

export type GetSinglesendStatData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * Dictates how the stats are time-sliced. Currently, `"total"` and `"day"` are supported.
     */
    aggregated_by?: 'day' | 'total';
    /**
     * Format: `YYYY-MM-DD`.If this parameter is included, the stats' end date is included in the search.
     */
    end_date?: string;
    /**
     * A/B Single Sends have multiple variation IDs and phase IDs. Including these additional fields allows further granularity of stats by these fields.
     */
    group_by?: Array<'ab_variation' | 'ab_phase'>;
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
    /**
     * Format: `YYYY-MM-DD`. If this parameter is included, the stats' start date is included in the search.
     */
    start_date?: string;
    /**
     * [IANA Area/Region](https://en.wikipedia.org/wiki/Tz_database#Names_of_time_zones) string representing the timezone in which the stats are to be presented, e.g., "America/Chicago".
     */
    timezone?: string;
  };
};

export type GetSinglesendStatResponse = singlesends_response;

export type GetSinglesendStatError = global_error_response_schema | unknown;

export type GetSinglesendLinkStatData = {
  path: {
    id: string;
  };
  query?: {
    ab_phase_id?: 'test' | 'send';
    ab_variation_id?: string;
    /**
     * A/B Single Sends have multiple variation IDs and phase IDs. Including these additional fields allows further granularity of stats by these fields.
     */
    group_by?: Array<'ab_variation' | 'ab_phase'>;
    /**
     * The number of elements you want returned on each page.
     */
    page_size?: number;
    /**
     * The stats endpoints are paginated. To get the next page, call the passed `_metadata.next` URL. If `_metadata.prev` doesn't exist, you're at the first page. Similarly, if `_metadata.next` is not present, you're at the last page.
     */
    page_token?: string;
  };
};

export type GetSinglesendLinkStatResponse = singlesends_link_stats_response;

export type GetSinglesendLinkStatError =
  | global_error_response_schema
  | {
      [key: string]: unknown;
    };

export type PostMarketingTestSendEmailData = {
  body?: {
    /**
     * A custom unsubscribe URL.
     */
    custom_unsubscribe_url?: string;
    /**
     * An array of email addresses you want to send the test message to.
     */
    emails: Array<string>;
    /**
     * You can either specify this address or specify a verified sender ID.
     */
    from_address?: string;
    /**
     * This ID must belong to a verified sender. Alternatively, you may supply a `from_address` email.
     */
    sender_id?: number;
    suppression_group_id?: number;
    /**
     * The ID of the template that you would like to use. If you use a template that contains a subject and content (either text or HTML), then those values specified at the personalizations or message level will not be used.
     */
    template_id: string;
    /**
     *  You can override the active template with an alternative template version by passing the version ID in this field. If this field is blank, the active template version will be used.
     */
    version_id_override?: string;
  };
};

export type PostMarketingTestSendEmailResponse = {
  [key: string]: unknown;
};

export type PostMarketingTestSendEmailError = global_error_response_schema;

export type GetMessagesData = {
  headers: {
    Authorization: string;
    'X-Cursor'?: string;
    'X-Query-Id'?: string;
  };
  query: {
    /**
     * The number of messages returned. This parameter must be greater than 0 and less than or equal to 1000
     */
    limit?: number;
    /**
     * Use the query syntax  to filter your email activity.
     */
    query: string;
  };
};

export type GetMessagesResponse = {
  messages?: Array<
    email_activity_response_common_fields & {
      /**
       * The number of times links in the message were clicked.
       */
      clicks_count?: number;
      /**
       * A timestamp of the last event received for the specific message.
       */
      last_event_time?: number;
      /**
       * The number of times the message was opened.
       */
      opens_count?: number;
    }
  >;
};

export type GetMessagesError =
  | {
      errors: Array<{
        message: string;
      }>;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostV3MessagesDownloadData = {
  headers: {
    Authorization: string;
  };
  query?: {
    /**
     * Uses a SQL like syntax to indicate which messages to include in the CSV
     */
    query?: string;
  };
};

export type PostV3MessagesDownloadResponse = {
  message?: string;
  status?: 'pending';
};

export type PostV3MessagesDownloadError = {
  errors?: Array<{
    message?: string;
  }>;
};

export type GetV3MessagesDownloadDownloadUuidData = {
  headers: {
    Authorization: string;
  };
  path: {
    /**
     * UUID used to locate the download csv request entry in the DB.
     *
     * This is the UUID provided in the email sent to the user when their csv file is ready to download
     */
    download_uuid: string;
  };
};

export type GetV3MessagesDownloadDownloadUuidResponse = {
  /**
   * Returns the aws signed link to the csv file which mako UI should perform a get on to trigger the csv download for the user
   */
  csv: string;
  /**
   * A signed link that will allow you to download the CSV file requested by the Request a CSV endpoint.
   */
  presigned_url?: string;
};

export type GetV3MessagesDownloadDownloadUuidError = {
  errors?: Array<{
    message?: string;
  }>;
};

export type GetV3MessagesMsgIdData = {
  headers: {
    Authorization: string;
  };
  path: {
    /**
     * The ID of the message you are requesting details for.
     */
    msg_id: string;
  };
};

export type GetV3MessagesMsgIdResponse = email_activity_response_common_fields & {
  /**
   * The ID of the API Key used to authenticate the sending request for the message.
   */
  api_key_id: string;
  /**
   * The unsubscribe group associated with this email.
   */
  asm_group_id: number;
  /**
   * Categories users associated to the message
   */
  categories: Array<string>;
  /**
   * List of events related to email message
   */
  events: Array<{
    /**
     * Used with "deferred" events to indicate the attempt number out of 10. One "deferred" entry will exists under events array for each time a message was deferred with error message from the server.
     */
    attempt_num?: number;
    /**
     * Use to distinguish between types of bounces
     */
    bounce_type: 'soft' | 'hard';
    /**
     * Name of event
     */
    event_name:
      | 'bounced'
      | 'opened'
      | 'clicked'
      | 'processed'
      | 'dropped'
      | 'delivered'
      | 'deferred'
      | 'spam_report'
      | 'unsubscribe'
      | 'group_unsubscribe'
      | 'group_resubscribe';
    /**
     * Client recipient used to click or open message
     */
    http_user_agent: string;
    /**
     * The MX server that received the email. For example, mx.gmail.com
     */
    mx_server: string;
    /**
     * The date when the event was processed
     */
    processed: string;
    /**
     * Explanation of what caused the message to be "bounced", "deferred", or "blocked". Usually contains error message from the server - e.g. message from gmail why mail was deferred.
     */
    reason?: string;
    /**
     * Used with "clicked" event to indicate which url the user clicked.
     */
    url?: string;
  }>;
  /**
   * This is the IP of the user who sent the message.
   */
  originating_ip: string;
  /**
   * IP used to send to the remote Mail Transfer Agent.
   */
  outbound_ip: string;
  /**
   * Whether or not the outbound IP is dedicated vs shared
   */
  outbound_ip_type: 'dedicated' | 'shared';
  /**
   * Teammate's username
   */
  teammate: string;
  /**
   * The ID associated with a Twilio SendGrid email template used to format the message.
   */
  template_id: string;
  /**
   * JSON hash of key-value pairs associated with the message.
   */
  unique_args: string;
} & {
  /**
   * The 'From' email address used to deliver the message. This address should be a verified sender in your Twilio SendGrid account.
   */
  from_email: string;
  /**
   * A unique ID assigned to the message. This ID can be used to retrieve activity data for the specific message.
   */
  msg_id: string;
  /**
   * The message's status.
   */
  status: 'processed' | 'delivered' | 'not delivered';
  /**
   * The email's subject line.
   */
  subject: string;
  /**
   * The intended recipient's email address.
   */
  to_email: string;
  api_key_id: string;
  asm_group_id: number;
  /**
   * Categories users associated to the message
   */
  categories: Array<string>;
  /**
   * List of events related to email message
   */
  events: Array<{
    /**
     * Used with "deferred" events to indicate the attempt number out of 10. One "deferred" entry will exists under events array for each time a message was deferred with error message from the server.
     */
    attempt_num?: number;
    /**
     * Use to distinguish between types of bounces
     */
    bounce_type: 'bounced' | 'blocked' | 'expired';
    /**
     * Name of event
     */
    event_name:
      | 'bounced'
      | 'opened'
      | 'clicked'
      | 'processed'
      | 'dropped'
      | 'delivered'
      | 'deferred'
      | 'spam_report'
      | 'unsubscribe'
      | 'group_unsubscribe'
      | 'group_resubscribe';
    /**
     * Client recipient used to click or open message
     */
    http_user_agent: string;
    /**
     * For example mx.gmail.com
     */
    mx_server: string;
    /**
     * Date of when event occurred
     */
    processed: string;
    /**
     * Explanation of what caused "bounced", "deferred", or "blocked". Usually contains error message from the server - e.g. message from gmail why mail was deferred
     */
    reason?: string;
    /**
     * Used with "clicked" event to indicate which url the user clicked.
     */
    url: string;
  }>;
  /**
   * This is the IP of the user who sent the message.
   */
  originating_ip: string;
  /**
   * IP used to send to the remote MTA. Used by UI to display IP in detailed view
   */
  outbound_ip: string;
  /**
   * Whether or not the outbound IP is dedicated vs shared
   */
  outbound_ip_type: 'dedicated' | 'shared';
  /**
   * Teammate's username
   */
  teammate: string;
  template_id: string;
  /**
   * JSON hash of arbitrary key-value pairs
   */
  unique_args: string;
};

export type GetV3MessagesMsgIdError =
  | unknown
  | {
      errors?: Array<{
        field?: string;
        message?: string;
      }>;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetPartnerSettingsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The number of settings to return per page.
     */
    limit?: number;
    /**
     * The paging offset.
     */
    offset?: number;
  };
};

export type GetPartnerSettingsResponse = {
  result?: Array<{
    /**
     * A description of this partner setting.
     */
    description: string;
    /**
     * Indicates if this partner setting has been enabled.
     */
    enabled: boolean;
    /**
     * The name of the partner setting.
     */
    name: string;
    /**
     * The title of the partner.
     */
    title: string;
  }>;
};

export type GetPartnerSettingsError = unknown;

export type GetPartnerSettingsNewRelicData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetPartnerSettingsNewRelicResponse = partner_settings_new_relic;

export type GetPartnerSettingsNewRelicError = unknown;

export type PatchPartnerSettingsNewRelicData = {
  body?: {
    /**
     * Indicates if your subuser statistics will be sent to your New Relic Dashboard.
     */
    enable_subuser_statistics?: boolean;
    /**
     * Indicates if this partner setting is enabled.
     */
    enabled?: boolean;
    /**
     * The license key for your New Relic account.
     */
    license_key?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchPartnerSettingsNewRelicResponse = partner_settings_new_relic;

export type PatchPartnerSettingsNewRelicError = unknown;

export type GetScopesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetScopesResponse = {
  /**
   * The list of scopes for which this user has access.
   */
  scopes: Array<string>;
};

export type GetScopesError =
  | {
      /**
       * This 401 response indicates that the user making the call doesn't have the authorization to view the list of scopes.
       */
      errors: Array<{
        /**
         * This empty field is returned instead of the list of scopes if the user making the call doesn't have the authorization required.
         */
        field?: unknown;
        /**
         * Explains why the scopes cannot be returned.
         */
        message: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetV3ScopesRequestsData = {
  query?: {
    /**
     * Optional field to limit the number of results returned.
     */
    limit?: number;
    /**
     * Optional beginning point in the list to retrieve from.
     */
    offset?: number;
  };
};

export type GetV3ScopesRequestsResponse = Array<{
  /**
   * Teammate's email
   */
  email?: string;
  /**
   * Teammate's first name
   */
  first_name?: string;
  /**
   * Request ID
   */
  id?: number;
  /**
   * Teammate's last name
   */
  last_name?: string;
  /**
   * Name of group of scopes associated to page teammate is requesting access to
   */
  scope_group_name?: string;
  /**
   * Teammate's username
   */
  username?: string;
}>;

export type GetV3ScopesRequestsError = unknown;

export type DeleteV3ScopesRequestsRequestIdData = {
  path: {
    /**
     * The ID of the request that you want to deny.
     */
    request_id: string;
  };
};

export type DeleteV3ScopesRequestsRequestIdResponse = void;

export type DeleteV3ScopesRequestsRequestIdError =
  | unknown
  | {
      errors?: Array<{
        field?: string;
        message?: string;
      }>;
    };

export type PatchV3ScopesRequestsApproveIdData = {
  path: {
    /**
     * The ID of the request that you want to approve.
     */
    request_id: string;
  };
};

export type PatchV3ScopesRequestsApproveIdResponse = {
  /**
   * name of feature teammate will be given access to
   */
  scope_group_name?: string;
};

export type PatchV3ScopesRequestsApproveIdError =
  | {
      [key: string]: unknown;
    }
  | {
      errors?: Array<{
        field?: string;
        message?: string;
      }>;
    };

export type GetV3SendersData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetV3SendersResponse = {
  result?: Array<senderID>;
};

export type GetV3SendersError = unknown;

export type PostSendersData = {
  body?: sender_id_request & {
    from?: {
      [key: string]: unknown;
    };
    reply_to?: {
      [key: string]: unknown;
    };
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostSendersResponse = senderID;

export type PostSendersError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type DeleteV3SendersSenderIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the sender identity that you want to retrieve.
     */
    sender_id: number;
  };
};

export type DeleteV3SendersSenderIdResponse = {
  [key: string]: unknown;
};

export type DeleteV3SendersSenderIdError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type GetV3SendersSenderIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the sender identity that you want to retrieve.
     */
    sender_id: number;
  };
};

export type GetV3SendersSenderIdResponse = senderID;

export type GetV3SendersSenderIdError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type PatchV3SendersSenderIdData = {
  body?: sender_id_request;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the sender identity that you want to retrieve.
     */
    sender_id: number;
  };
};

export type PatchV3SendersSenderIdResponse = senderID;

export type PatchV3SendersSenderIdError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type PostV3SendersSenderIdResendVerificationData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the sender identity for which you would like to resend a verification email.
     */
    sender_id: number;
  };
};

export type PostV3SendersSenderIdResendVerificationResponse = {
  [key: string]: unknown;
};

export type PostV3SendersSenderIdResendVerificationError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type PostSsoCertificatesData = {
  body?: {
    /**
     * Indicates if the certificate is enabled.
     */
    enabled?: boolean;
    /**
     * An ID that matches a certificate to a specific IdP integration. This is the `id` returned by the "Get All SSO Integrations" endpoint.
     */
    integration_id: string;
    /**
     * This public certificate allows SendGrid to verify that SAML requests it receives are signed by an IdP that it recognizes.
     */
    public_certificate: string;
  };
};

export type PostSsoCertificatesResponse = sso_certificate_body;

export type PostSsoCertificatesError = sso_error_response;

export type DeleteSsoCertificatesCertIdData = {
  path: {
    cert_id: string;
  };
};

export type DeleteSsoCertificatesCertIdResponse = sso_certificate_body;

export type DeleteSsoCertificatesCertIdError = sso_error_response;

export type GetSsoCertificatesCertIdData = {
  path: {
    cert_id: string;
  };
};

export type GetSsoCertificatesCertIdResponse = sso_certificate_body;

export type GetSsoCertificatesCertIdError = sso_error_response;

export type PatchSsoCertificatesCertIdData = {
  body?: {
    /**
     * Indicates whether or not the certificate is enabled.
     */
    enabled?: boolean;
    /**
     * An ID that matches a certificate to a specific IdP integration.
     */
    integration_id?: string;
    /**
     * This public certificate allows SendGrid to verify that SAML requests it receives are signed by an IdP that it recognizes.
     */
    public_certificate?: string;
  };
  path: {
    cert_id: string;
  };
};

export type GetSsoIntegrationsData = {
  query?: {
    /**
     * If this parameter is set to `true`, the response will include the `completed_integration` field.
     */
    si?: boolean;
  };
};

export type GetSsoIntegrationsResponse = Array<sso_integration>;

export type GetSsoIntegrationsError = sso_error_response;

export type PostSsoIntegrationsData = {
  body?: create_integration_request;
};

export type PostSsoIntegrationsResponse = sso_integration;

export type PostSsoIntegrationsError = sso_error_response;

export type DeleteSsoIntegrationsIdData = {
  path: {
    id: string;
  };
};

export type DeleteSsoIntegrationsIdResponse = void;

export type DeleteSsoIntegrationsIdError = sso_error_response;

export type GetSsoIntegrationsIdData = {
  path: {
    id: string;
  };
  query?: {
    /**
     * If this parameter is set to `true`, the response will include the `completed_integration` field.
     */
    si?: boolean;
  };
};

export type GetSsoIntegrationsIdResponse = sso_integration;

export type GetSsoIntegrationsIdError = sso_error_response;

export type PatchSsoIntegrationsIdData = {
  body?: create_integration_request;
  path: {
    id: string;
  };
  query?: {
    /**
     * If this parameter is set to `true`, the response will include the `completed_integration` field.
     */
    si?: boolean;
  };
};

export type PatchSsoIntegrationsIdResponse = sso_integration;

export type PatchSsoIntegrationsIdError = sso_error_response;

export type GetSsoIntegrationsIntegrationIdCertificatesData = {
  path: {
    /**
     * An ID that matches a certificate to a specific IdP integration.
     */
    integration_id: string;
  };
};

export type GetSsoIntegrationsIntegrationIdCertificatesResponse = Array<sso_certificate_body>;

export type GetSsoIntegrationsIntegrationIdCertificatesError = sso_error_response;

export type PostSsoTeammatesData = {
  body?: sso_teammate_request;
};

export type PostSsoTeammatesResponse = sso_teammate_response;

export type PostSsoTeammatesError = sso_error_response;

export type PatchSsoTeammatesUsernameData = {
  body?: {
    first_name?: string;
    is_admin?: boolean;
    last_name?: string;
    scopes?: Array<string>;
  };
  path: {
    /**
     * This email address must be the same address assigned to the teammate in your IdP
     */
    username: string;
  };
};

export type PatchSsoTeammatesUsernameResponse = sso_teammates_patch_response;

export type PatchSsoTeammatesUsernameError = sso_error_response;

export type GetStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * The number of results to return.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetStatsResponse = Array<{
  /**
   * The date the stats were gathered.
   */
  date: string;
  /**
   * The individual email activity stats.
   */
  stats: Array<{
    metrics?: stats_advanced_global_stats;
  }>;
}>;

export type GetStatsError = unknown;

export type GetSubusersData = {
  query?: {
    /**
     * The number of results you would like to get in each request.
     */
    limit?: number;
    /**
     * The number of subusers to skip.
     */
    offset?: number;
    /**
     * The username of this subuser.
     */
    username?: string;
  };
};

export type GetSubusersResponse = Array<subuser>;

export type GetSubusersError = global_error_response_schema;

export type PostSubusersData = {
  body?: {
    /**
     * The email address of the subuser.
     */
    email: string;
    /**
     * The IP addresses that should be assigned to this subuser.
     */
    ips: Array<string>;
    /**
     * The password this subuser will use when logging into SendGrid.
     */
    password: string;
    /**
     * The username for this subuser.
     */
    username: string;
  };
};

export type PostSubusersResponse = subuser_post;

export type PostSubusersError =
  | global_error_response_schema
  | {
      [key: string]: unknown;
    };

export type GetSubusersReputationsData = {
  query?: {
    usernames?: string;
  };
};

export type GetSubusersReputationsResponse = Array<{
  /**
   * The sender reputation this subuser has attained.
   */
  reputation: number;
  /**
   * The subuser that has this reputation.f
   */
  username: string;
}>;

export type GetSubusersReputationsError = unknown;

export type GetSubusersStatsData = {
  query: {
    /**
     * How to group the statistics. Must be either "day", "week", or "month".
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics to retrieve. Defaults to today.
     */
    end_date?: string;
    /**
     * Limits the number of results returned per page.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results from.
     */
    offset?: number;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
    /**
     * The subuser you want to retrieve statistics for. You may include this parameter up to 10 times to retrieve statistics for multiple subusers.
     */
    subusers: string;
  };
};

export type GetSubusersStatsResponse = category_stats;

export type GetSubusersStatsError = unknown;

export type GetSubusersStatsMonthlyData = {
  query: {
    /**
     * The date of the month to retrieve statistics for. Must be formatted YYYY-MM-DD
     */
    date: string;
    /**
     * Optional field to limit the number of results returned.
     */
    limit?: number;
    /**
     * Optional beginning point in the list to retrieve from.
     */
    offset?: number;
    /**
     * The direction you want to sort.
     */
    sort_by_direction?: 'desc' | 'asc';
    /**
     * The metric that you want to sort by. Metrics that you can sort by are: `blocks`, `bounces`, `clicks`, `delivered`, `opens`, `requests`, `unique_clicks`, `unique_opens`, and `unsubscribes`.'
     */
    sort_by_metric?:
      | 'blocks'
      | 'bounces'
      | 'clicks'
      | 'delivered'
      | 'opens'
      | 'requests'
      | 'unique_clicks'
      | 'unique_opens'
      | 'unsubscribes';
    /**
     * A substring search of your subusers.
     */
    subuser?: string;
  };
};

export type GetSubusersStatsMonthlyResponse = subuser_stats;

export type GetSubusersStatsMonthlyError = unknown;

export type GetSubusersStatsSumsData = {
  query: {
    /**
     * How to group the statistics. Defaults to today. Must follow format YYYY-MM-DD.
     */
    aggregated_by?: string;
    /**
     * The end date of the statistics to retrieve. Defaults to today. Must follow format YYYY-MM-DD.
     */
    end_date?: string;
    /**
     * Limits the number of results returned per page.
     */
    limit?: number;
    /**
     * The point in the list to begin retrieving results from.
     */
    offset?: number;
    /**
     * The direction you want to sort.
     */
    sort_by_direction?: 'desc' | 'asc';
    /**
     * The metric that you want to sort by.  Must be a single metric.
     */
    sort_by_metric?: string;
    /**
     * The starting date of the statistics to retrieve. Must follow format YYYY-MM-DD.
     */
    start_date: string;
  };
};

export type GetSubusersStatsSumsResponse = category_stats;

export type GetSubusersStatsSumsError = unknown;

export type DeleteSubusersSubuserNameData = {
  path: {
    subuser_name: string;
  };
};

export type DeleteSubusersSubuserNameResponse = {
  [key: string]: unknown;
};

export type DeleteSubusersSubuserNameError = global_error_response_schema;

export type PatchSubusersSubuserNameData = {
  body?: {
    /**
     * Whether or not this subuser is disabled. True means disabled, False means enabled.
     */
    disabled?: boolean;
  };
  path: {
    subuser_name: string;
  };
};

export type PatchSubusersSubuserNameResponse = {
  [key: string]: unknown;
};

export type PatchSubusersSubuserNameError = global_error_response_schema;

export type PutSubusersSubuserNameIpsData = {
  body?: Array<string>;
  path: {
    subuser_name: string;
  };
};

export type PutSubusersSubuserNameIpsResponse = {
  /**
   * The IP addresses that are assigned to the subuser.
   */
  ips?: Array<string>;
};

export type PutSubusersSubuserNameIpsError = global_error_response_schema;

export type DeleteSubusersSubuserNameMonitorData = {
  path: {
    /**
     * The name of the subuser for which to retrieve monitor settings.
     */
    subuser_name: string;
  };
};

export type DeleteSubusersSubuserNameMonitorResponse = {
  [key: string]: unknown;
};

export type DeleteSubusersSubuserNameMonitorError = global_error_response_schema;

export type GetSubusersSubuserNameMonitorData = {
  path: {
    /**
     * The name of the subuser for which to retrieve monitor settings.
     */
    subuser_name: string;
  };
};

export type GetSubusersSubuserNameMonitorResponse = monitor;

export type GetSubusersSubuserNameMonitorError = global_error_response_schema;

export type PostSubusersSubuserNameMonitorData = {
  body?: monitor;
  path: {
    /**
     * The name of the subuser for which to retrieve monitor settings.
     */
    subuser_name: string;
  };
};

export type PostSubusersSubuserNameMonitorResponse = monitor;

export type PostSubusersSubuserNameMonitorError = global_error_response_schema;

export type PutSubusersSubuserNameMonitorData = {
  body?: monitor;
  path: {
    /**
     * The name of the subuser for which to retrieve monitor settings.
     */
    subuser_name: string;
  };
};

export type PutSubusersSubuserNameMonitorResponse = monitor;

export type PutSubusersSubuserNameMonitorError = global_error_response_schema;

export type GetSubusersSubuserNameStatsMonthlyData = {
  path: {
    subuser_name: string;
  };
  query: {
    /**
     * The date of the month to retrieve statistics for. Must be formatted YYYY-MM-DD
     */
    date: string;
    /**
     * Optional field to limit the number of results returned.
     */
    limit?: number;
    /**
     * Optional beginning point in the list to retrieve from.
     */
    offset?: number;
    /**
     * The direction you want to sort.
     */
    sort_by_direction?: 'desc' | 'asc';
    /**
     * The metric that you want to sort by. Metrics that you can sort by are: `blocks`, `bounces`, `clicks`, `delivered`, `opens`, `requests`, `unique_clicks`, `unique_opens`, and `unsubscribes`.'
     */
    sort_by_metric?: string;
  };
};

export type GetSubusersSubuserNameStatsMonthlyResponse = subuser_stats;

export type GetSubusersSubuserNameStatsMonthlyError = unknown;

export type DeleteSuppressionBlocksData = {
  body?: {
    /**
     * Indicates if you want to delete all blocked email addresses.
     */
    delete_all?: boolean;
    /**
     * The specific blocked email addresses that you want to delete.
     */
    emails?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteSuppressionBlocksResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionBlocksError = unknown;

export type GetSuppressionBlocksData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The end of the time range when a blocked email was created (inclusive). This is a unix timestamp.
     */
    end_time?: number;
    /**
     * Limit the number of results to be displayed per page.
     */
    limit?: number;
    /**
     * The point in the list to begin displaying results.
     */
    offset?: number;
    /**
     * The start of the time range when a blocked email was created (inclusive). This is a unix timestamp.
     */
    start_time?: number;
  };
};

export type GetSuppressionBlocksResponse = blocks_response;

export type GetSuppressionBlocksError = unknown;

export type DeleteSuppressionBlocksEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of the specific block.
     */
    email: string;
  };
};

export type DeleteSuppressionBlocksEmailResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionBlocksEmailError = unknown;

export type GetSuppressionBlocksEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of the specific block.
     */
    email: string;
  };
};

export type GetSuppressionBlocksEmailResponse = blocks_response;

export type GetSuppressionBlocksEmailError = unknown;

export type DeleteSuppressionBouncesData = {
  body?: {
    /**
     * This parameter allows you to delete **every** email in your bounce list. This should not be used with the emails parameter.
     */
    delete_all?: boolean;
    /**
     * Delete multiple emails from your bounce list at the same time. This should not be used with the delete_all parameter.
     */
    emails?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteSuppressionBouncesResponse = unknown;

export type DeleteSuppressionBouncesError = global_error_response_schema;

export type GetSuppressionBouncesData = {
  headers: {
    Accept: string;
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Refers end of the time range in unix timestamp when a bounce was created (inclusive).
     */
    end_time?: number;
    /**
     * Refers start of the time range in unix timestamp when a bounce was created (inclusive).
     */
    start_time?: number;
  };
};

export type GetSuppressionBouncesResponse = Array<bounce_response>;

export type GetSuppressionBouncesError = global_error_response_schema;

export type DeleteSuppressionBouncesEmailData = {
  body?: unknown;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    email: string;
  };
  query: {
    /**
     * The email address you would like to remove from the bounce list.
     */
    email_address: string;
  };
};

export type DeleteSuppressionBouncesEmailResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionBouncesEmailError = global_error_response_schema;

export type GetSuppressionBouncesEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    email: string;
  };
};

export type GetSuppressionBouncesEmailResponse = Array<bounce_response>;

export type GetSuppressionBouncesEmailError = unknown;

export type DeleteSuppressionInvalidEmailsData = {
  body?: {
    /**
     * Indicates if you want to remove all email address from the invalid emails list.
     */
    delete_all?: boolean;
    /**
     * The list of specific email addresses that you want to remove.
     */
    emails?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteSuppressionInvalidEmailsResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionInvalidEmailsError = unknown;

export type GetSuppressionInvalidEmailsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Refers end of the time range in unix timestamp when an invalid email was created (inclusive).
     */
    end_time?: number;
    /**
     * Limit the number of results to be displayed per page.
     */
    limit?: number;
    /**
     * Paging offset. The point in the list to begin displaying results.
     */
    offset?: number;
    /**
     * Refers start of the time range in unix timestamp when an invalid email was created (inclusive).
     */
    start_time?: number;
  };
};

export type GetSuppressionInvalidEmailsResponse = Array<invalid_email>;

export type GetSuppressionInvalidEmailsError = unknown;

export type DeleteSuppressionInvalidEmailsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The specific email address of the invalid email entry that you want to retrieve.
     */
    email: string;
  };
};

export type DeleteSuppressionInvalidEmailsEmailResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionInvalidEmailsEmailError = unknown;

export type GetSuppressionInvalidEmailsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The specific email address of the invalid email entry that you want to retrieve.
     */
    email: string;
  };
};

export type GetSuppressionInvalidEmailsEmailResponse = Array<invalid_email>;

export type GetSuppressionInvalidEmailsEmailError = unknown;

export type DeleteSuppressionSpamReportsData = {
  body?: {
    /**
     * Indicates if you want to delete all email addresses on the spam report list.
     */
    delete_all?: boolean;
    /**
     * A list of specific email addresses that you want to remove from the spam report list.
     */
    emails?: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type DeleteSuppressionSpamReportsResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionSpamReportsError = unknown;

export type GetSuppressionSpamReportsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The end of the time range when a spam report was created (inclusive). This is a unix timestamp.
     */
    end_time?: number;
    /**
     * Limit the number of results to be displayed per page.
     */
    limit?: number;
    /**
     * Paging offset. The point in the list to begin displaying results.
     */
    offset?: number;
    /**
     * The start of the time range when a spam report was created (inclusive). This is a unix timestamp.
     */
    start_time?: number;
  };
};

export type GetSuppressionSpamReportsResponse = spam_reports_response;

export type GetSuppressionSpamReportsError = unknown;

export type DeleteSuppressionSpamReportsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of a specific spam report that you want to retrieve.
     */
    email: string;
  };
};

export type DeleteSuppressionSpamReportsEmailResponse = {
  [key: string]: unknown;
};

export type DeleteSuppressionSpamReportsEmailError = unknown;

export type GetSuppressionSpamReportsEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The email address of a specific spam report that you want to retrieve.
     */
    email: string;
  };
};

export type GetSuppressionSpamReportsEmailResponse = spam_reports_response;

export type GetSuppressionSpamReportsEmailError = unknown;

export type GetSuppressionUnsubscribesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Refers end of the time range in unix timestamp when an unsubscribe email was created (inclusive).
     */
    end_time?: number;
    /**
     * The number of results to display on each page.
     */
    limit?: number;
    /**
     * The point in the list of results to begin displaying global suppressions.
     */
    offset?: number;
    /**
     * Refers start of the time range in unix timestamp when an unsubscribe email was created (inclusive).
     */
    start_time?: number;
  };
};

export type GetSuppressionUnsubscribesResponse = Array<{
  /**
   * A Unix timestamp indicating when the recipient was added to the global suppression list.
   */
  created: number;
  /**
   * The email address of the recipient who is globally suppressed.
   */
  email: string;
}>;

export type GetSuppressionUnsubscribesError = unknown;

export type GetV3TeammatesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Number of items to return
     */
    limit?: number;
    /**
     * Paging offset
     */
    offset?: number;
  };
};

export type GetV3TeammatesResponse = {
  result?: Array<{
    /**
     * (optional) Teammate's address
     */
    address?: string;
    /**
     * (optional) Teammate's address
     */
    address2?: string;
    /**
     * (optional) Teammate's city
     */
    city?: string;
    /**
     * (optional) Teammate's country
     */
    country?: string;
    /**
     * Teammate's email
     */
    email?: string;
    /**
     * Teammate's first name
     */
    first_name?: string;
    /**
     * Set to true if teammate has admin privileges
     */
    is_admin?: boolean;
    /**
     * Teammate's last name
     */
    last_name?: string;
    /**
     * (optional) Teammate's phone number
     */
    phone?: string;
    /**
     * (optional) Teammate's state
     */
    state?: string;
    /**
     * Indicate the type of user: owner user, teammate admin user, or normal teammate
     */
    user_type?: 'admin' | 'owner' | 'teammate';
    /**
     * Teammate's username
     */
    username?: string;
    /**
     * (optional) Teammate's website
     */
    website?: string;
    /**
     * (optional) Teammate's zip
     */
    zip?: string;
  }>;
};

export type GetV3TeammatesError = unknown;

export type PostV3TeammatesData = {
  body?: {
    /**
     * New teammate's email
     */
    email: string;
    /**
     * Set to true if teammate should be an admin user
     */
    is_admin: boolean;
    /**
     * Set to specify list of scopes that teammate should have. Should be empty if teammate is an admin.
     */
    scopes: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostV3TeammatesResponse = {
  /**
   * Teammate's email address
   */
  email?: string;
  /**
   * Set to true if teammate should have admin privileges
   */
  is_admin?: boolean;
  /**
   * Initial set of permissions to give to teammate if they accept the invite
   */
  scopes?: Array<unknown>;
  /**
   * Token to identify invite
   */
  token?: string;
};

export type PostV3TeammatesError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type GetV3TeammatesPendingData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetV3TeammatesPendingResponse = {
  result?: Array<{
    /**
     * Email address teammate invite will be sent to
     */
    email?: string;
    /**
     * timestamp indicates when invite will expire. Expiration is 7 days after invite creation
     */
    expiration_date?: number;
    /**
     * Set to true to indicate teammate should have the same set of permissions as parent user
     */
    is_admin?: boolean;
    /**
     * List of permissions to give teammate if they accept
     */
    scopes?: Array<string>;
    /**
     * Invitation token used to identify user
     */
    token?: string;
  }>;
};

export type GetV3TeammatesPendingError = unknown;

export type DeleteV3TeammatesPendingTokenData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The token for the invite you want to delete.
     */
    token: string;
  };
};

export type DeleteV3TeammatesPendingTokenResponse = void;

export type DeleteV3TeammatesPendingTokenError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type PostV3TeammatesPendingTokenResendData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The token for the invite that you want to resend.
     */
    token: string;
  };
};

export type PostV3TeammatesPendingTokenResendResponse = {
  /**
   * Teammate's email address
   */
  email?: string;
  /**
   * Set to true if teammate should have admin privileges
   */
  is_admin?: boolean;
  /**
   * Initial set of permissions to give to teammate if they accept the invite
   */
  scopes?: Array<string>;
  /**
   * ID to identify invite
   */
  token?: string;
};

export type PostV3TeammatesPendingTokenResendError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type DeleteV3TeammatesUsernameData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The username of the teammate that you want to retrieve.
     */
    username: string;
  };
};

export type DeleteV3TeammatesUsernameResponse = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type DeleteV3TeammatesUsernameError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type GetV3TeammatesUsernameData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The username of the teammate that you want to retrieve.
     */
    username: string;
  };
};

export type GetV3TeammatesUsernameResponse = {
  /**
   * (optional) Teammate's address
   */
  address?: string;
  /**
   * (optional) Teammate's address
   */
  address2?: string;
  /**
   * (optional) Teammate's city
   */
  city?: string;
  /**
   * (optional) Teammate's country
   */
  country?: string;
  /**
   * Teammate's email
   */
  email?: string;
  /**
   * Teammate's first name
   */
  first_name?: string;
  /**
   * Set to true if teammate has admin privileges
   */
  is_admin?: boolean;
  /**
   * Teammate's last name
   */
  last_name?: string;
  /**
   * (optional) Teammate's phone number
   */
  phone?: string;
  /**
   * Scopes associated to teammate
   */
  scopes?: Array<unknown>;
  /**
   * (optional) Teammate's state
   */
  state?: string;
  /**
   * Indicate the type of user: account owner, teammate admin user, or normal teammate
   */
  user_type?: 'admin' | 'owner' | 'teammate';
  /**
   * Teammate's username
   */
  username?: string;
  /**
   * (optional) Teammate's website
   */
  website?: string;
  /**
   * (optional) Teammate's zip
   */
  zip?: string;
};

export type GetV3TeammatesUsernameError = unknown;

export type PatchV3TeammatesUsernameData = {
  body?: {
    /**
     * Set to True if this teammate should be promoted to an admin user. If True, scopes should be an empty array.
     */
    is_admin: boolean;
    /**
     * Provide list of scopes that should be given to teammate. If specifying list of scopes, is_admin should be set to False.
     */
    scopes: Array<string>;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The username of the teammate that you want to retrieve.
     */
    username: string;
  };
};

export type PatchV3TeammatesUsernameResponse = {
  /**
   * (optional) Teammate's address
   */
  address?: string;
  /**
   * (optional) Teammate's address
   */
  address2?: string;
  /**
   * (optional) Teammate's city
   */
  city?: string;
  /**
   * (optional) Teammate's country
   */
  country?: string;
  /**
   * Teammate's email address
   */
  email?: string;
  /**
   * Teammate's first name
   */
  first_name?: string;
  /**
   * Set to true if teammate has admin priveleges
   */
  is_admin?: boolean;
  /**
   * Teammate's last name
   */
  last_name?: string;
  /**
   * (optional) Teammate's phone number
   */
  phone?: string;
  /**
   * Scopes given to teammate
   */
  scopes?: Array<string>;
  /**
   * (optional) Teammate's state
   */
  state?: string;
  /**
   * Indicate the type of user: owner user, teammate admin user, or normal teammate
   */
  user_type?: 'admin' | 'owner' | 'teammate';
  /**
   * Teammate's username
   */
  username?: string;
  /**
   * (optional) Teammate's website
   */
  website?: string;
  /**
   * (optional) Teammate's zip
   */
  zip?: string;
};

export type PatchV3TeammatesUsernameError = {
  errors?: Array<{
    field?: string;
    message?: string;
  }>;
};

export type GetTemplatesData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * Comma-delimited list specifying which generations of templates to return. Options are `legacy`, `dynamic` or `legacy,dynamic`.
     */
    generations?: 'legacy' | 'dynamic' | 'legacy,dynamic';
    /**
     * The number of templates to be returned in each page of results
     */
    page_size: number;
    /**
     * A token corresponding to a specific page of results, as provided by metadata
     */
    page_token?: string;
  };
};

export type GetTemplatesResponse = {
  _metadata?: _metadata;
  result?: Array<transactional_templates_template_lean>;
};

export type GetTemplatesError = {
  errors?: Array<{
    ''?: string;
    error_id?: string;
    message?: string;
  }>;
};

export type PostTemplatesData = {
  body?: {
    /**
     * Defines whether the template supports dynamic replacement.
     */
    generation?: 'legacy' | 'dynamic';
    /**
     * The name for the new transactional template.
     */
    name: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostTemplatesResponse = transactional_template;

export type PostTemplatesError = unknown;

export type DeleteTemplatesTemplateIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    template_id: string;
  };
};

export type DeleteTemplatesTemplateIdResponse = {
  [key: string]: unknown;
};

export type DeleteTemplatesTemplateIdError = unknown;

export type GetTemplatesTemplateIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    template_id: string;
  };
};

export type GetTemplatesTemplateIdResponse = transactional_template;

export type GetTemplatesTemplateIdError = unknown;

export type PatchTemplatesTemplateIdData = {
  body?: {
    /**
     * The name of the transactional template.
     */
    name?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    template_id: string;
  };
};

export type PatchTemplatesTemplateIdResponse = transactional_template;

export type PatchTemplatesTemplateIdError = unknown;

export type PostTemplatesTemplateIdData = {
  body?: {
    /**
     * The name for the new transactional template.
     */
    name?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    template_id: string;
  };
};

export type PostTemplatesTemplateIdResponse = transactional_template;

export type PostTemplatesTemplateIdError = unknown;

export type PostTemplatesTemplateIdVersionsData = {
  body?: transactional_template_version_create;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    template_id: string;
  };
};

export type PostTemplatesTemplateIdVersionsResponse = transactional_template_version_output;

export type PostTemplatesTemplateIdVersionsError = unknown;

export type DeleteTemplatesTemplateIdVersionsVersionIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     *  The ID of the original template
     */
    template_id: string;
    /**
     * The ID of the template version
     */
    version_id: string;
  };
};

export type DeleteTemplatesTemplateIdVersionsVersionIdResponse = void;

export type DeleteTemplatesTemplateIdVersionsVersionIdError = unknown;

export type GetTemplatesTemplateIdVersionsVersionIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     *  The ID of the original template
     */
    template_id: string;
    /**
     * The ID of the template version
     */
    version_id: string;
  };
};

export type GetTemplatesTemplateIdVersionsVersionIdResponse = transactional_template_version_output;

export type GetTemplatesTemplateIdVersionsVersionIdError = unknown;

export type PatchTemplatesTemplateIdVersionsVersionIdData = {
  body?: transactional_template_version_create;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     *  The ID of the original template
     */
    template_id: string;
    /**
     * The ID of the template version
     */
    version_id: string;
  };
};

export type PatchTemplatesTemplateIdVersionsVersionIdResponse = transactional_template_version_output;

export type PatchTemplatesTemplateIdVersionsVersionIdError = unknown;

export type PostTemplatesTemplateIdVersionsVersionIdActivateData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the original template
     */
    template_id: string;
    /**
     * The ID of the template version
     */
    version_id: string;
  };
};

export type PostTemplatesTemplateIdVersionsVersionIdActivateResponse = transactional_template_version_output;

export type PostTemplatesTemplateIdVersionsVersionIdActivateError = unknown;

export type GetTrackingSettingsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetTrackingSettingsResponse = {
  /**
   * The list of all tracking settings.
   */
  result?: Array<{
    /**
     * A description about the event that is being tracked.
     */
    description?: string;
    /**
     * Indicates if this tracking setting is currently enabled.
     */
    enabled?: boolean;
    /**
     * The name of the event being tracked.
     */
    name?: string;
    /**
     * The title of the tracking setting.
     */
    title?: string;
  }>;
};

export type GetTrackingSettingsError = unknown;

export type GetTrackingSettingsClickData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetTrackingSettingsClickResponse = click_tracking;

export type GetTrackingSettingsClickError = unknown;

export type PatchTrackingSettingsClickData = {
  body?: {
    /**
     * The setting you want to use for click tracking.
     */
    enabled?: boolean;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchTrackingSettingsClickResponse = click_tracking;

export type PatchTrackingSettingsClickError = unknown;

export type GetTrackingSettingsGoogleAnalyticsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetTrackingSettingsGoogleAnalyticsResponse = google_analytics_settings;

export type GetTrackingSettingsGoogleAnalyticsError = unknown;

export type PatchTrackingSettingsGoogleAnalyticsData = {
  body?: google_analytics_settings;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchTrackingSettingsGoogleAnalyticsResponse = google_analytics_settings;

export type PatchTrackingSettingsGoogleAnalyticsError = unknown;

export type GetTrackingSettingsOpenData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetTrackingSettingsOpenResponse = {
  /**
   * Indicates if open tracking is enabled.
   */
  enabled: boolean;
};

export type GetTrackingSettingsOpenError = unknown;

export type PatchTrackingSettingsOpenData = {
  body?: {
    /**
     * The new status that you want to set for open tracking.
     */
    enabled?: boolean;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchTrackingSettingsOpenResponse = {
  /**
   * Indicates if open tracking is enabled.
   */
  enabled: boolean;
};

export type PatchTrackingSettingsOpenError = unknown;

export type GetTrackingSettingsSubscriptionData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetTrackingSettingsSubscriptionResponse = subscription_tracking_settings;

export type GetTrackingSettingsSubscriptionError = unknown;

export type PatchTrackingSettingsSubscriptionData = {
  body?: subscription_tracking_settings;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchTrackingSettingsSubscriptionResponse = subscription_tracking_settings;

export type PatchTrackingSettingsSubscriptionError = unknown;

export type GetUserAccountData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserAccountResponse = {
  /**
   * The sender reputation for this user.
   */
  reputation: number;
  /**
   * The type of account for this user.
   */
  type: 'free' | 'paid';
};

export type GetUserAccountError = unknown;

export type GetUserCreditsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserCreditsResponse = {
  /**
   * The date that your credit balance was last reset.
   */
  last_reset: string;
  /**
   * The next date that your credit balance will be reset.
   */
  next_reset: string;
  /**
   * The number of overdrawn credits for your account.
   */
  overage: number;
  /**
   * The remaining number of credits available on your account.
   */
  remain: number;
  /**
   * The frequency at which your credit balance will be reset.
   */
  reset_frequency: string;
  /**
   * The total number of credits assigned to your account.
   */
  total: number;
  /**
   * The number of credits that you have used.
   */
  used: number;
};

export type GetUserCreditsError = unknown;

export type GetUserEmailData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserEmailResponse = {
  /**
   * The email address currently on file for your account.
   */
  email: string;
};

export type GetUserEmailError = unknown;

export type PutUserEmailData = {
  body?: {
    /**
     * The new email address that you would like to use for your account.
     */
    email?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PutUserEmailResponse = {
  /**
   * The current email address on file for your account.
   */
  email: string;
};

export type PutUserEmailError = unknown;

export type PutUserPasswordData = {
  body?: {
    /**
     * The new password you would like to use for your account.
     */
    new_password: string;
    /**
     * The old password for your account.
     */
    old_password: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PutUserPasswordResponse = {
  [key: string]: unknown;
};

export type PutUserPasswordError = unknown;

export type GetUserProfileData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserProfileResponse = {
  /**
   * The user's address.
   */
  address: string;
  /**
   * The second line of the user's address.
   */
  address2?: string;
  /**
   * The user's city.
   */
  city: string;
  /**
   * The name of the user's company.
   */
  company: string;
  /**
   * The user's country.
   */
  country: string;
  /**
   * The user's first name.
   */
  first_name: string;
  /**
   * The user's last name.
   */
  last_name: string;
  /**
   * The user's phone number.
   */
  phone: string;
  /**
   * The user's state.
   */
  state: string;
  /**
   * The user's website URL.
   */
  website: string;
  /**
   * The user's zip code.
   */
  zip: string;
};

export type GetUserProfileError = unknown;

export type PatchUserProfileData = {
  body?: user_profile;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchUserProfileResponse = user_profile;

export type PatchUserProfileError = global_error_response_schema;

export type GetUserScheduledSendsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserScheduledSendsResponse = Array<user_scheduled_send_status>;

export type GetUserScheduledSendsError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostUserScheduledSendsData = {
  body?: {
    /**
     * The batch ID is the identifier that your scheduled mail sends share.
     */
    batch_id: string;
    /**
     * The status of the send you would like to implement. This can be pause or cancel. To delete a pause or cancel status see DELETE /v3/user/scheduled_sends/{batch_id}
     */
    status: 'pause' | 'cancel';
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostUserScheduledSendsResponse = user_scheduled_send_status;

export type PostUserScheduledSendsError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteUserScheduledSendsBatchIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    batch_id: string;
  };
};

export type DeleteUserScheduledSendsBatchIdResponse = void;

export type DeleteUserScheduledSendsBatchIdError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetUserScheduledSendsBatchIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    batch_id: string;
  };
};

export type GetUserScheduledSendsBatchIdResponse = Array<user_scheduled_send_status>;

export type GetUserScheduledSendsBatchIdError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PatchUserScheduledSendsBatchIdData = {
  body?: {
    /**
     * The status you would like the scheduled send to have.
     */
    status: 'cancel' | 'pause';
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    batch_id: string;
  };
};

export type PatchUserScheduledSendsBatchIdResponse = unknown;

export type PatchUserScheduledSendsBatchIdError =
  | {
      errors?: Array<{
        field?: string;
        help?: {
          [key: string]: unknown;
        };
        message?: string;
      }>;
      id?: string;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetUserSettingsEnforcedTlsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserSettingsEnforcedTlsResponse = enforced_tls_request_response;

export type GetUserSettingsEnforcedTlsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PatchUserSettingsEnforcedTlsData = {
  body?: enforced_tls_request_response;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchUserSettingsEnforcedTlsResponse = enforced_tls_request_response;

export type PatchUserSettingsEnforcedTlsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetUserUsernameData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserUsernameResponse = {
  /**
   * The user ID for your account.
   */
  user_id: number;
  /**
   * Your account username.
   */
  username: string;
};

export type GetUserUsernameError = unknown;

export type PutUserUsernameData = {
  body?: {
    /**
     * The new username you would like to use for your account.
     */
    username?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PutUserUsernameResponse = {
  /**
   * The current username on file for your account.
   */
  username: string;
};

export type PutUserUsernameError = unknown;

export type GetUserWebhooksEventSettingsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserWebhooksEventSettingsResponse = event_webhook_response;

export type GetUserWebhooksEventSettingsError = unknown;

export type PatchUserWebhooksEventSettingsData = {
  body?: event_webhook_update_oauth_request;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchUserWebhooksEventSettingsResponse = event_webhook_response;

export type PatchUserWebhooksEventSettingsError = unknown;

export type GetUserWebhooksEventSettingsSignedData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserWebhooksEventSettingsSignedResponse = {
  /**
   * The public key you can use to verify the Twilio SendGrid signature.
   */
  public_key: string;
};

export type GetUserWebhooksEventSettingsSignedError = unknown;

export type PatchUserWebhooksEventSettingsSignedData = {
  body?: {
    enabled: boolean;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PatchUserWebhooksEventSettingsSignedResponse = {
  /**
   * The public key you can use to verify the Twilio SendGrid signature.
   */
  public_key: string;
};

export type PatchUserWebhooksEventSettingsSignedError = {
  errors?: Array<{
    field?: string | null;
    message: string;
  }>;
};

export type PostUserWebhooksEventTestData = {
  body?: {
    /**
     * The client ID Twilio SendGrid sends to your OAuth server or service provider to generate an OAuth access token. When passing data in this field, you must also include the oauth_client_secret and oauth_token_url fields.
     */
    oauth_client_id?: string;
    /**
     * This secret is needed only once to create an access token. SendGrid will store this secret, allowing you to update your Client ID and Token URL without passing the secret to SendGrid again.  When passing data in this field, you must also include the oauth_client_id and oauth_token_url fields.
     */
    oauth_client_secret?: string;
    /**
     * The URL where Twilio SendGrid sends the Client ID and Client Secret to generate an access token. This should be your OAuth server or service provider.  When passing data in this field, you must also include the oauth_client_id and oauth_client_secret fields.
     */
    oauth_token_url?: string;
    /**
     * The URL where you would like the test notification to be sent.
     */
    url?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostUserWebhooksEventTestResponse = void;

export type PostUserWebhooksEventTestError = unknown;

export type GetUserWebhooksParseSettingsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type GetUserWebhooksParseSettingsResponse = {
  /**
   * The list of your current inbound parse settings.
   */
  result?: Array<parse_setting>;
};

export type GetUserWebhooksParseSettingsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostUserWebhooksParseSettingsData = {
  body?: parse_setting;
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostUserWebhooksParseSettingsResponse = parse_setting;

export type PostUserWebhooksParseSettingsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteUserWebhooksParseSettingsHostnameData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The hostname associated with the inbound parse setting that you would like to retrieve.
     */
    hostname: string;
  };
};

export type DeleteUserWebhooksParseSettingsHostnameResponse = {
  [key: string]: unknown;
};

export type DeleteUserWebhooksParseSettingsHostnameError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetUserWebhooksParseSettingsHostnameData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The hostname associated with the inbound parse setting that you would like to retrieve.
     */
    hostname: string;
  };
};

export type GetUserWebhooksParseSettingsHostnameResponse = parse_setting;

export type GetUserWebhooksParseSettingsHostnameError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PatchUserWebhooksParseSettingsHostnameData = {
  body?: parse_setting;
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The hostname associated with the inbound parse setting that you would like to retrieve.
     */
    hostname: string;
  };
};

export type PatchUserWebhooksParseSettingsHostnameResponse = parse_setting;

export type PatchUserWebhooksParseSettingsHostnameError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetUserWebhooksParseStatsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query: {
    /**
     * How you would like the statistics to by grouped.
     */
    aggregated_by?: 'day' | 'week' | 'month';
    /**
     * The end date of the statistics you want to retrieve. Must be in the format YYYY-MM-DD
     */
    end_date?: string;
    /**
     * The number of statistics to return on each page.
     */
    limit?: string;
    /**
     * The number of statistics to skip.
     */
    offset?: string;
    /**
     * The starting date of the statistics you want to retrieve. Must be in the format YYYY-MM-DD
     */
    start_date: string;
  };
};

export type GetUserWebhooksParseStatsResponse = Array<{
  /**
   * The date that the stats were collected.
   */
  date: string;
  /**
   * The Parse Webhook usage statistics.
   */
  stats: Array<{
    metrics?: {
      /**
       * The number of emails received and parsed by the Parse Webhook.
       */
      received: number;
    };
  }>;
}>;

export type GetUserWebhooksParseStatsError = unknown;

export type PostValidationsEmailData = {
  body?: {
    /**
     * The email address that you want to validate.
     */
    email: string;
    /**
     * A one-word classifier for where this validation originated.
     */
    source?: string;
  };
};

export type PostValidationsEmailResponse = {
  result: {
    /**
     * Granular checks for email address validity.
     */
    checks: {
      /**
       * Additional checks on the email address.
       */
      additional: {
        /**
         * WHether email sent to this address from your account has bounced.
         */
        has_known_bounces: boolean;
        /**
         * Whether our model predicts that the email address might bounce.
         */
        has_suspected_bounces: boolean;
      };
      /**
       * Checks on the domain portion of the email address.
       */
      domain: {
        /**
         * Whether the email has appropriate DNS records to deliver a message.
         */
        has_mx_or_a_record: boolean;
        /**
         * Whether the email address syntax is valid.
         */
        has_valid_address_syntax: boolean;
        /**
         * Whether the domain appears to be from a disposable email address service.
         */
        is_suspected_disposable_address: boolean;
      };
      /**
       * Checks on the local part of the email address.
       */
      local_part: {
        /**
         * Whether the local part of email appears to be a role or group (e.g., hr, admin)
         */
        is_suspected_role_address: boolean;
      };
    };
    /**
     * The email being validated
     */
    email: string;
    /**
     * The domain of the email address.
     */
    host: string;
    /**
     * The IP address associated with this email.
     */
    ip_address: string;
    /**
     * The local part of the email address.
     */
    local: string;
    /**
     * A numeric representation of the email validity.
     */
    score: number;
    /**
     * The source of the validation, as per the API request.
     */
    source?: string;
    /**
     * A suggested correction in the event of domain name typos (e.g., gmial.com)
     */
    suggestion?: string;
    /**
     * A generic classification of whether or not the email address is valid.
     */
    verdict: 'Valid' | 'Risky' | 'Invalid';
  };
};

export type PostValidationsEmailError = unknown;

export type GetVerifiedSendersData = {
  query?: {
    id?: number;
    lastSeenID?: number;
    limit?: number;
  };
};

export type GetVerifiedSendersResponse = {
  results?: Array<verified_sender_response_schema>;
};

export type GetVerifiedSendersError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostVerifiedSendersData = {
  body?: verified_sender_request_schema;
};

export type PostVerifiedSendersResponse = verified_sender_response_schema;

export type PostVerifiedSendersError =
  | {
      errors: Array<{
        error_id: string;
        field?: string;
        message: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetVerifiedSendersDomainsResponse = {
  results: {
    hard_failures: Array<string>;
    soft_failures: Array<string>;
  };
};

export type GetVerifiedSendersDomainsError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostVerifiedSendersResendIdData = {
  path: {
    id: string;
  };
};

export type PostVerifiedSendersResendIdResponse = {
  [key: string]: unknown;
};

export type PostVerifiedSendersResendIdError =
  | {
      errors: Array<{
        error_id: string;
        message: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetVerifiedSendersStepsCompletedResponse = {
  results?: {
    domain_verified?: boolean;
    sender_verified?: boolean;
  };
};

export type GetVerifiedSendersStepsCompletedError =
  | global_error_response_schema
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type GetVerifiedSendersVerifyTokenData = {
  path: {
    token: string;
  };
};

export type GetVerifiedSendersVerifyTokenResponse = void;

export type GetVerifiedSendersVerifyTokenError =
  | global_error_response_schema
  | {
      errors: Array<{
        error_id: string;
        message: string;
      }>;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type DeleteVerifiedSendersIdData = {
  path: {
    id: string;
  };
};

export type DeleteVerifiedSendersIdResponse = {
  [key: string]: unknown;
};

export type DeleteVerifiedSendersIdError =
  | global_error_response_schema
  | {
      errors?: Array<{
        error_id: string;
        message: string;
      }>;
    }
  | {
      errors: Array<{
        error_id: string;
        message: string;
      }>;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PatchVerifiedSendersIdData = {
  body?: verified_sender_request_schema;
  path: {
    id: string;
  };
};

export type PatchVerifiedSendersIdResponse = verified_sender_response_schema;

export type PatchVerifiedSendersIdError =
  | {
      errors: Array<{
        error_id: string;
        field?: string;
        message: string;
      }>;
    }
  | global_error_response_schema
  | {
      errors: Array<{
        error_id: string;
        message: string;
      }>;
    }
  | {
      errors?: Array<{
        message?: string;
      }>;
    };

export type PostWhitelabelDnsEmailData = {
  body?: {
    /**
     * The ID of your SendGrid domain record.
     */
    domain_id: number;
    /**
     * The email address to send the DNS information to.
     */
    email: string;
    link_id: number;
    /**
     * A custom text block to include in the email body sent with the records.
     */
    message?: string;
  };
};

export type PostWhitelabelDnsEmailResponse = void;

export type PostWhitelabelDnsEmailError = {
  errors?: {
    error?: string;
    field?: string;
  };
};

export type GetWhitelabelDomainsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Search for authenticated domains.
     */
    domain?: string;
    /**
     * Exclude subuser domains from the result.
     */
    exclude_subusers?: boolean;
    /**
     * Number of domains to return.
     */
    limit?: number;
    /**
     * Paging offset.
     */
    offset?: number;
    /**
     * The username associated with an authenticated domain.
     */
    username?: string;
  };
};

export type GetWhitelabelDomainsResponse = domain_authentication_200_response;

export type GetWhitelabelDomainsError = unknown;

export type PostWhitelabelDomainsData = {
  body?: {
    /**
     * Whether to allow SendGrid to manage your SPF records, DKIM keys, and DKIM key rotation.
     */
    automatic_security?: boolean;
    /**
     * Add a custom DKIM selector. Accepts three letters or numbers.
     */
    custom_dkim_selector?: string;
    /**
     * Specify whether to use a custom SPF or allow SendGrid to manage your SPF. This option is only available to authenticated domains set up for manual security.
     */
    custom_spf?: boolean;
    /**
     * Whether to use this authenticated domain as the fallback if no authenticated domains match the sender's domain.
     */
    default?: boolean;
    /**
     * Domain being authenticated.
     */
    domain: string;
    /**
     * The IP addresses that will be included in the custom SPF record for this authenticated domain.
     */
    ips?: Array<string>;
    /**
     * The subdomain to use for this authenticated domain.
     */
    subdomain?: string;
    /**
     * The username associated with this domain.
     */
    username?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostWhitelabelDomainsResponse = authentication_domain;

export type PostWhitelabelDomainsError = unknown;

export type GetWhitelabelDomainsDefaultData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The domain to find a default authentication.
     */
    domain?: string;
  };
};

export type GetWhitelabelDomainsDefaultResponse = domain_authentication_200_response;

export type GetWhitelabelDomainsDefaultError = unknown;

export type DeleteWhitelabelDomainsSubuserData = {
  query?: {
    /**
     * Username for the subuser to find associated authenticated domain.
     */
    username?: string;
  };
};

export type DeleteWhitelabelDomainsSubuserResponse = {
  [key: string]: unknown;
};

export type DeleteWhitelabelDomainsSubuserError = unknown;

export type GetWhitelabelDomainsSubuserData = {
  query: {
    /**
     * Username for the subuser to find associated authenticated domain.
     */
    username: string;
  };
};

export type GetWhitelabelDomainsSubuserResponse = domain_authentication_domain_spf;

export type GetWhitelabelDomainsSubuserError = unknown;

export type DeleteWhitelabelDomainsDomainIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    domain_id: string;
  };
};

export type DeleteWhitelabelDomainsDomainIdResponse = {
  [key: string]: unknown;
};

export type DeleteWhitelabelDomainsDomainIdError = unknown;

export type GetWhitelabelDomainsDomainIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    domain_id: string;
  };
};

export type GetWhitelabelDomainsDomainIdResponse = authentication_domain;

export type GetWhitelabelDomainsDomainIdError = unknown;

export type PatchWhitelabelDomainsDomainIdData = {
  body?: {
    /**
     * Indicates whether to generate a custom SPF record for manual security.
     */
    custom_spf?: boolean;
    /**
     * Indicates whether this is the default authenticated domain.
     */
    default?: boolean;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    domain_id: string;
  };
};

export type PatchWhitelabelDomainsDomainIdResponse = domain_authentication_200_response;

export type PatchWhitelabelDomainsDomainIdError = unknown;

export type PostWhitelabelDomainsDomainIdSubuserData = {
  body?: {
    /**
     * Username to associate with the authenticated domain.
     */
    username: string;
  };
  path: {
    /**
     * ID of the authenticated domain to associate with the subuser
     */
    domain_id: number;
  };
};

export type PostWhitelabelDomainsDomainIdSubuserResponse = domain_authentication_domain_spf;

export type PostWhitelabelDomainsDomainIdSubuserError = unknown;

export type PostWhitelabelDomainsIdIpsData = {
  body?: {
    /**
     * IP to associate with the domain. Used for manually specifying IPs for custom SPF.
     */
    ip: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * ID of the domain to which you are adding an IP
     */
    id: number;
  };
};

export type PostWhitelabelDomainsIdIpsResponse = domain_authentication_domain_spf;

export type PostWhitelabelDomainsIdIpsError = unknown;

export type DeleteWhitelabelDomainsIdIpsIpData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * ID of the domain to delete the IP from.
     */
    id: number;
    /**
     * IP to remove from the domain.
     */
    ip: string;
  };
};

export type DeleteWhitelabelDomainsIdIpsIpResponse = domain_authentication_domain_spf;

export type DeleteWhitelabelDomainsIdIpsIpError = unknown;

export type PostWhitelabelDomainsIdValidateData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * ID of the domain to validate.
     */
    id: number;
  };
};

export type PostWhitelabelDomainsIdValidateResponse = {
  /**
   * The ID of the authenticated domain.
   */
  id?: number;
  /**
   * Indicates if this is a valid authenticated domain.
   */
  valid?: boolean;
  /**
   * The individual DNS records that are checked when validating, including the reason for any invalid DNS records.
   */
  validation_results?: {
    /**
     * A DNS record for this authenticated domain.
     */
    dkim1?: {
      reason?: string | null;
      /**
       * Indicates if the DNS record is valid.
       */
      valid?: boolean;
    };
    /**
     * A DNS record for this authenticated domain.
     */
    dkim2?: {
      reason?: string | null;
      /**
       * Indicates if the DNS record is valid.
       */
      valid?: boolean;
    };
    /**
     * The CNAME record for the authenticated domain.
     */
    mail_cname?: {
      /**
       * The reason this record is invalid.
       */
      reason?: string | null;
      /**
       * Indicates if this DNS record is valid.
       */
      valid?: boolean;
    };
    /**
     * The SPF record for the authenticated domain.
     */
    spf?: {
      reason?: string | null;
      /**
       * Indicates if the SPF record is valid.
       */
      valid?: boolean;
    };
  };
};

export type PostWhitelabelDomainsIdValidateError = {
  errors?: Array<{
    /**
     * A message explaining the reason for the error.
     */
    message: string;
  }>;
};

export type GetWhitelabelIpsData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The IP address segment that you'd like to use in a prefix search.
     */
    ip?: string;
    /**
     * The maximum number of results to retrieve.
     */
    limit?: number;
    /**
     * The point in the list of results to begin retrieving IP addresses from.
     */
    offset?: number;
  };
};

export type GetWhitelabelIpsResponse = Array<reverse_dns>;

export type GetWhitelabelIpsError = unknown;

export type PostWhitelabelIpsData = {
  body?: {
    /**
     * The root, or sending, domain that will be used to send message from the IP address.
     */
    domain: string;
    /**
     * The IP address for which you want to set up reverse DNS.
     */
    ip: string;
    /**
     * The subdomain that will be used to send emails from the IP address. This should be the same as the subdomain used to set up an authenticated domain.
     */
    subdomain?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostWhitelabelIpsResponse = reverse_dns;

export type PostWhitelabelIpsError = unknown;

export type DeleteWhitelabelIpsIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the reverse DNS record that you would like to retrieve.
     */
    id: string;
  };
};

export type DeleteWhitelabelIpsIdResponse = {
  [key: string]: unknown;
};

export type DeleteWhitelabelIpsIdError = unknown;

export type GetWhitelabelIpsIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the reverse DNS record that you would like to retrieve.
     */
    id: string;
  };
};

export type GetWhitelabelIpsIdResponse = reverse_dns;

export type GetWhitelabelIpsIdError = unknown;

export type PostWhitelabelIpsIdValidateData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the reverse DNS record that you would like to validate.
     */
    id: string;
  };
};

export type PostWhitelabelIpsIdValidateResponse = {
  /**
   * The ID of the reverse DNS record.
   */
  id: number;
  /**
   * Indicates if the reverse DNS record is valid.
   */
  valid: boolean;
  /**
   * The specific results of the validation.
   */
  validation_results: {
    a_record?: {
      /**
       * The reason the reverse DNS record could not be validated. Is `null` if the reverse DNS record was validated.
       */
      reason: string | null;
      /**
       * Indicates if the reverse DNS record could be validated.
       */
      valid: boolean;
    };
  };
};

export type PostWhitelabelIpsIdValidateError =
  | {
      /**
       * The error messages for the failed validation.
       */
      errors: Array<{
        /**
         * A message describing why the reverse DNS could not be validated.
         */
        message: string;
      }>;
    }
  | {
      /**
       * The error messages for the failed validation.
       */
      errors: Array<{
        /**
         * A message describing why the IP whitelabel could not be validated.
         */
        message: string;
      }>;
    };

export type GetWhitelabelLinksData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * Limits the number of results returned per page.
     */
    limit?: number;
  };
};

export type GetWhitelabelLinksResponse = Array<link_branding_200_response>;

export type GetWhitelabelLinksError = unknown;

export type PostWhitelabelLinksData = {
  body?: {
    /**
     * Indicates if you want to use this link branding as the default or fallback. When setting a new default, the existing default link branding will have its default status removed automatically.
     */
    default?: boolean;
    /**
     * The root domain for the subdomain that you are creating the link branding for. This should match your FROM email address.
     */
    domain: string;
    /**
     * The subdomain to create the link branding for. Must be different from the subdomain you used for authenticating your domain.
     */
    subdomain?: string;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
};

export type PostWhitelabelLinksResponse = link_branding_200_response;

export type PostWhitelabelLinksError = unknown;

export type GetWhitelabelLinksDefaultData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  query?: {
    /**
     * The domain to match against when finding the default branded link.
     */
    domain?: string;
  };
};

export type GetWhitelabelLinksDefaultResponse = link_branding_200_response;

export type GetWhitelabelLinksDefaultError = unknown;

export type DeleteWhitelabelLinksSubuserData = {
  query: {
    /**
     * The username of the subuser account that you want to disassociate a branded link from.
     */
    username: string;
  };
};

export type DeleteWhitelabelLinksSubuserResponse = {
  [key: string]: unknown;
};

export type DeleteWhitelabelLinksSubuserError = unknown;

export type GetWhitelabelLinksSubuserData = {
  query: {
    /**
     * The username of the subuser to retrieve associated branded links for.
     */
    username: string;
  };
};

export type GetWhitelabelLinksSubuserResponse = link_branding_200_response;

export type GetWhitelabelLinksSubuserError = unknown;

export type DeleteWhitelabelLinksIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the branded link you want to retrieve.
     */
    id: number;
  };
};

export type DeleteWhitelabelLinksIdResponse = {
  [key: string]: unknown;
};

export type DeleteWhitelabelLinksIdError = unknown;

export type GetWhitelabelLinksIdData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the branded link you want to retrieve.
     */
    id: number;
  };
};

export type GetWhitelabelLinksIdResponse = link_branding_200_response;

export type GetWhitelabelLinksIdError = unknown;

export type PatchWhitelabelLinksIdData = {
  body?: {
    /**
     * Indicates if the branded link is set as the default. When setting a new default, the existing default link branding will have its default status removed automatically.
     */
    default?: boolean;
  };
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the branded link you want to retrieve.
     */
    id: number;
  };
};

export type PatchWhitelabelLinksIdResponse = link_branding_200_response;

export type PatchWhitelabelLinksIdError = unknown;

export type PostWhitelabelLinksIdValidateData = {
  headers?: {
    'on-behalf-of'?: string;
  };
  path: {
    /**
     * The ID of the branded link that you want to validate.
     */
    id: number;
  };
};

export type PostWhitelabelLinksIdValidateResponse = {
  /**
   * The ID of the branded link.
   */
  id: number;
  /**
   * Indicates if the link branding is valid.
   */
  valid: boolean;
  /**
   * The individual validation results for each of the DNS records associated with this branded link.
   */
  validation_results: {
    /**
     * The DNS record generated for the sending domain used for this branded link.
     */
    domain_cname: {
      /**
       * Null if the DNS record is valid. If the DNS record is invalid, this will explain why.
       */
      reason: string | null;
      /**
       * Indicates if this DNS record is valid.
       */
      valid: boolean;
    };
    /**
     * The DNS record created to verify the branded link.
     */
    owner_cname?: {
      /**
       * Null if valid. If the DNS record is invalid, this will explain why.
       */
      reason: string | null;
      /**
       * Indicates if the DNS record is valid.
       */
      valid: boolean;
    };
  };
};

export type PostWhitelabelLinksIdValidateError = {
  /**
   * The reasons why the validation failed.
   */
  errors: Array<{
    /**
     * The reason why the link whitelabel could not be validated.
     */
    message: string;
  }>;
};

export type PostWhitelabelLinksLinkIdSubuserData = {
  body?: {
    /**
     * The username of the subuser account that you want to associate the branded link with.
     */
    username?: string;
  };
  path: {
    /**
     * The ID of the branded link you want to associate.
     */
    link_id: number;
  };
};

export type PostWhitelabelLinksLinkIdSubuserResponse = link_branding_200_response;

export type PostWhitelabelLinksLinkIdSubuserError = unknown;
