// Generated by ts-to-zod
import { z } from 'zod';

export const apiKeySchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  created_at: z.string().optional(),
});

export const createApiKeyRequestSchema = z.object({
  name: z.string(),
  permission: z.union([z.literal('full_access'), z.literal('sending_access')]).optional(),
  domain_id: z.string().optional(),
});

export const permissionSchema = z.union([z.literal('full_access'), z.literal('sending_access')]);

export const createApiKeyResponseSchema = z.object({
  id: z.string().optional(),
  token: z.string().optional(),
});

export const createAudienceOptionsSchema = z.object({
  name: z.string(),
});

export const createAudienceResponseSuccessSchema = z.object({
  id: z.string().optional(),
  object: z.string().optional(),
  name: z.string().optional(),
});

export const createBatchEmailsResponseSchema = z.object({
  data: z
    .array(
      z.object({
        id: z.string().optional(),
      }),
    )
    .optional(),
});

export const createContactOptionsSchema = z.object({
  email: z.string(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  unsubscribed: z.boolean().optional(),
  audience_id: z.string().optional(),
});

export const createContactResponseSuccessSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
});

export const createDomainRequestSchema = z.object({
  name: z.string(),
  region: z.union([z.literal('us-east-1'), z.literal('eu-west-1'), z.literal('sa-east-1')]).optional(),
});

export const regionSchema = z.union([z.literal('us-east-1'), z.literal('eu-west-1'), z.literal('sa-east-1')]);

export const domainRecordSchema = z.object({
  record: z.string().optional(),
  name: z.string().optional(),
  type: z.string().optional(),
  ttl: z.string().optional(),
  status: z.string().optional(),
  value: z.string().optional(),
  priority: z.number().optional(),
});

export const deleteDomainResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  deleted: z.boolean().optional(),
});

export const domainSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  status: z.string().optional(),
  created_at: z.string().optional(),
  region: z.string().optional(),
  records: z.array(domainRecordSchema).optional(),
});

export const emailSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  to: z.array(z.string()).optional(),
  from: z.string().optional(),
  created_at: z.string().optional(),
  subject: z.string().optional(),
  html: z.string().optional(),
  text: z.string().optional(),
  bcc: z.array(z.string()).optional(),
  cc: z.array(z.string()).optional(),
  reply_to: z.array(z.string()).optional(),
  last_event: z.string().optional(),
});

export const getAudienceResponseSuccessSchema = z.object({
  id: z.string().optional(),
  object: z.string().optional(),
  name: z.string().optional(),
  created_at: z.string().optional(),
});

export const getContactResponseSuccessSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  created_at: z.string().optional(),
  unsubscribed: z.boolean().optional(),
});

export const listApiKeysResponseSchema = z.object({
  data: z.array(apiKeySchema).optional(),
});

export const listAudiencesResponseSuccessSchema = z.object({
  object: z.string().optional(),
  data: z
    .array(
      z.object({
        id: z.string().optional(),
        name: z.string().optional(),
        created_at: z.string().optional(),
      }),
    )
    .optional(),
});

export const listContactsResponseSuccessSchema = z.object({
  object: z.string().optional(),
  data: z
    .array(
      z.object({
        id: z.string().optional(),
        email: z.string().optional(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
        created_at: z.string().optional(),
        unsubscribed: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const listDomainsItemSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  status: z.string().optional(),
  created_at: z.string().optional(),
  region: z.string().optional(),
});

export const listDomainsResponseSchema = z.object({
  data: z.array(listDomainsItemSchema).optional(),
});

export const removeAudienceResponseSuccessSchema = z.object({
  id: z.string().optional(),
  object: z.string().optional(),
  deleted: z.boolean().optional(),
});

export const removeContactResponseSuccessSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  deleted: z.boolean().optional(),
});

export const tagSchema = z.object({
  name: z.string().optional(),
  value: z.string().optional(),
});

export const sendEmailResponseSchema = z.object({
  id: z.string().optional(),
});

export const updateContactOptionsSchema = z.object({
  email: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
  unsubscribed: z.boolean().optional(),
});

export const updateContactResponseSuccessSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
});

export const updateDomainOptionsSchema = z.object({
  open_tracking: z.boolean().optional(),
  click_tracking: z.boolean().optional(),
  tls: z.string().optional(),
});

export const updateDomainResponseSuccessSchema = z.object({
  id: z.string().optional(),
  object: z.string().optional(),
});

export const updateEmailOptionsSchema = z.object({
  scheduled_at: z.string().optional(),
});

export const verifyDomainResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
});

export const postEmailsResponseSchema = sendEmailResponseSchema;

export const postEmailsErrorSchema = z.unknown();

export const getEmailsByEmailIdDataSchema = z.object({
  path: z.object({
    email_id: z.string(),
  }),
});

export const getEmailsByEmailIdResponseSchema = emailSchema;

export const getEmailsByEmailIdErrorSchema = z.unknown();

export const patchEmailsByEmailIdDataSchema = z.object({
  path: z.object({
    email_id: z.string(),
  }),
});

export const patchEmailsByEmailIdResponseSchema = updateEmailOptionsSchema;

export const patchEmailsByEmailIdErrorSchema = z.unknown();

export const postEmailsByEmailIdCancelDataSchema = z.object({
  path: z.object({
    email_id: z.string(),
  }),
});

export const postEmailsByEmailIdCancelResponseSchema = emailSchema;

export const postEmailsByEmailIdCancelErrorSchema = z.unknown();

export const postEmailsBatchResponseSchema = createBatchEmailsResponseSchema;

export const postEmailsBatchErrorSchema = z.unknown();

export const postDomainsDataSchema = z.object({
  body: createDomainRequestSchema.optional(),
});

export const createDomainResponseSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  created_at: z.string().optional(),
  status: z.string().optional(),
  records: z.array(domainRecordSchema).optional(),
  region: z.string().optional(),
});

export const postDomainsErrorSchema = z.unknown();

export const getDomainsResponseSchema = listDomainsResponseSchema;

export const getDomainsErrorSchema = z.unknown();

export const getDomainsByDomainIdDataSchema = z.object({
  path: z.object({
    domain_id: z.string(),
  }),
});

export const getDomainsByDomainIdResponseSchema = domainSchema;

export const getDomainsByDomainIdErrorSchema = z.unknown();

export const patchDomainsByDomainIdDataSchema = z.object({
  body: updateDomainOptionsSchema.optional(),
  path: z.object({
    domain_id: z.string(),
  }),
});

export const patchDomainsByDomainIdResponseSchema = updateDomainResponseSuccessSchema;

export const patchDomainsByDomainIdErrorSchema = z.unknown();

export const deleteDomainsByDomainIdDataSchema = z.object({
  path: z.object({
    domain_id: z.string(),
  }),
});

export const deleteDomainsByDomainIdResponseSchema = deleteDomainResponseSchema;

export const deleteDomainsByDomainIdErrorSchema = z.unknown();

export const postDomainsByDomainIdVerifyDataSchema = z.object({
  path: z.object({
    domain_id: z.string(),
  }),
});

export const postDomainsByDomainIdVerifyResponseSchema = verifyDomainResponseSchema;

export const postDomainsByDomainIdVerifyErrorSchema = z.unknown();

export const postApiKeysDataSchema = z.object({
  body: createApiKeyRequestSchema.optional(),
});

export const postApiKeysResponseSchema = createApiKeyResponseSchema;

export const postApiKeysErrorSchema = z.unknown();

export const getApiKeysResponseSchema = listApiKeysResponseSchema;

export const getApiKeysErrorSchema = z.unknown();

export const deleteApiKeysByApiKeyIdDataSchema = z.object({
  path: z.object({
    api_key_id: z.string(),
  }),
});

export const deleteApiKeysByApiKeyIdResponseSchema = z.unknown();

export const deleteApiKeysByApiKeyIdErrorSchema = z.unknown();

export const postAudiencesDataSchema = z.object({
  body: createAudienceOptionsSchema.optional(),
});

export const postAudiencesResponseSchema = createAudienceResponseSuccessSchema;

export const postAudiencesErrorSchema = z.unknown();

export const getAudiencesResponseSchema = listAudiencesResponseSuccessSchema;

export const getAudiencesErrorSchema = z.unknown();

export const deleteAudiencesByIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteAudiencesByIdResponseSchema = removeAudienceResponseSuccessSchema;

export const deleteAudiencesByIdErrorSchema = z.unknown();

export const getAudiencesByIdDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAudiencesByIdResponseSchema = getAudienceResponseSuccessSchema;

export const getAudiencesByIdErrorSchema = z.unknown();

export const postAudiencesByAudienceIdContactsDataSchema = z.object({
  body: createContactOptionsSchema.optional(),
  path: z.object({
    audience_id: z.string(),
  }),
});

export const postAudiencesByAudienceIdContactsResponseSchema = createContactResponseSuccessSchema;

export const postAudiencesByAudienceIdContactsErrorSchema = z.unknown();

export const getAudiencesByAudienceIdContactsDataSchema = z.object({
  path: z.object({
    audience_id: z.string(),
  }),
});

export const getAudiencesByAudienceIdContactsResponseSchema = listContactsResponseSuccessSchema;

export const getAudiencesByAudienceIdContactsErrorSchema = z.unknown();

export const deleteAudiencesByAudienceIdContactsByEmailDataSchema = z.object({
  path: z.object({
    audience_id: z.string(),
    email: z.string(),
  }),
});

export const deleteAudiencesByAudienceIdContactsByEmailResponseSchema = removeContactResponseSuccessSchema;

export const deleteAudiencesByAudienceIdContactsByEmailErrorSchema = z.unknown();

export const deleteAudiencesByAudienceIdContactsByIdDataSchema = z.object({
  path: z.object({
    audience_id: z.string(),
    id: z.string(),
  }),
});

export const deleteAudiencesByAudienceIdContactsByIdResponseSchema = removeContactResponseSuccessSchema;

export const deleteAudiencesByAudienceIdContactsByIdErrorSchema = z.unknown();

export const getAudiencesByAudienceIdContactsByIdDataSchema = z.object({
  path: z.object({
    audience_id: z.string(),
    id: z.string(),
  }),
});

export const getAudiencesByAudienceIdContactsByIdResponseSchema = getContactResponseSuccessSchema;

export const getAudiencesByAudienceIdContactsByIdErrorSchema = z.unknown();

export const patchAudiencesByAudienceIdContactsByIdDataSchema = z.object({
  body: updateContactOptionsSchema.optional(),
  path: z.object({
    audience_id: z.string(),
    id: z.string(),
  }),
});

export const patchAudiencesByAudienceIdContactsByIdResponseSchema = updateContactResponseSuccessSchema;

export const patchAudiencesByAudienceIdContactsByIdErrorSchema = z.unknown();

export const postDomainsResponseSchema = createDomainResponseSchema;
