// This file is auto-generated by @hey-api/openapi-ts

export type ApiKey = {
  /**
   * The ID of the API key.
   */
  id?: string;
  /**
   * The name of the API key.
   */
  name?: string;
  /**
   * The date and time the API key was created.
   */
  created_at?: string;
};

export type Attachment = {
  /**
   * Content of an attached file.
   */
  content?: Blob | File;
  /**
   * Name of attached file.
   */
  filename?: string;
  /**
   * Path where the attachment file is hosted
   */
  path?: string;
  /**
   * Optional content type for the attachment, if not set it will be derived from the filename property
   */
  content_type?: string;
};

export type CreateApiKeyRequest = {
  /**
   * The API key name.
   */
  name: string;
  /**
   * The API key can have full access to Resend’s API or be only restricted to send emails. * full_access - Can create, delete, get, and update any resource. * sending_access - Can only send emails.
   */
  permission?: 'full_access' | 'sending_access';
  /**
   * Restrict an API key to send emails only from a specific domain. Only used when the permission is sending_acces.
   */
  domain_id?: string;
};

/**
 * The API key can have full access to Resend’s API or be only restricted to send emails. * full_access - Can create, delete, get, and update any resource. * sending_access - Can only send emails.
 */
export type permission = 'full_access' | 'sending_access';

export type CreateApiKeyResponse = {
  /**
   * The ID of the API key.
   */
  id?: string;
  /**
   * The token of the API key.
   */
  token?: string;
};

export type CreateAudienceOptions = {
  /**
   * The name of the audience you want to create.
   */
  name: string;
};

export type CreateAudienceResponseSuccess = {
  /**
   * The ID of the audience.
   */
  id?: string;
  /**
   * The object of the audience.
   */
  object?: string;
  /**
   * The name of the audience.
   */
  name?: string;
};

export type CreateBatchEmailsResponse = {
  data?: Array<{
    /**
     * The ID of the sent email.
     */
    id?: string;
  }>;
};

export type CreateContactOptions = {
  /**
   * Email address of the contact.
   */
  email: string;
  /**
   * First name of the contact.
   */
  first_name?: string;
  /**
   * Last name of the contact.
   */
  last_name?: string;
  /**
   * Indicates if the contact is unsubscribed.
   */
  unsubscribed?: boolean;
  /**
   * Unique identifier of the audience to which the contact belongs.
   */
  audience_id?: string;
};

export type CreateContactResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Unique identifier for the created contact.
   */
  id?: string;
};

export type CreateDomainRequest = {
  /**
   * The name of the domain you want to create.
   */
  name: string;
  /**
   * The region where emails will be sent from. Possible values are us-east-1' | 'eu-west-1' | 'sa-east-1
   */
  region?: 'us-east-1' | 'eu-west-1' | 'sa-east-1';
};

/**
 * The region where emails will be sent from. Possible values are us-east-1' | 'eu-west-1' | 'sa-east-1
 */
export type region = 'us-east-1' | 'eu-west-1' | 'sa-east-1';

export type CreateDomainResponse = {
  /**
   * The ID of the domain.
   */
  id?: string;
  /**
   * The name of the domain.
   */
  name?: string;
  /**
   * The date and time the domain was created.
   */
  created_at?: string;
  /**
   * The status of the domain.
   */
  status?: string;
  records?: Array<DomainRecord>;
  /**
   * The region where the domain is hosted.
   */
  region?: string;
};

export type DeleteDomainResponse = {
  /**
   * The type of object.
   */
  object?: string;
  /**
   * The ID of the domain.
   */
  id?: string;
  /**
   * Indicates whether the domain was deleted successfully.
   */
  deleted?: boolean;
};

export type Domain = {
  /**
   * The type of object.
   */
  object?: string;
  /**
   * The ID of the domain.
   */
  id?: string;
  /**
   * The name of the domain.
   */
  name?: string;
  /**
   * The status of the domain.
   */
  status?: string;
  /**
   * The date and time the domain was created.
   */
  created_at?: string;
  /**
   * The region where the domain is hosted.
   */
  region?: string;
  records?: Array<DomainRecord>;
};

export type DomainRecord = {
  /**
   * The type of record.
   */
  record?: string;
  /**
   * The name of the record.
   */
  name?: string;
  /**
   * The type of record.
   */
  type?: string;
  /**
   * The time to live for the record.
   */
  ttl?: string;
  /**
   * The status of the record.
   */
  status?: string;
  /**
   * The value of the record.
   */
  value?: string;
  /**
   * The priority of the record.
   */
  priority?: number;
};

export type Email = {
  /**
   * The type of object.
   */
  object?: string;
  /**
   * The ID of the email.
   */
  id?: string;
  to?: Array<string>;
  /**
   * The email address of the sender.
   */
  from?: string;
  /**
   * The date and time the email was created.
   */
  created_at?: string;
  /**
   * The subject line of the email.
   */
  subject?: string;
  /**
   * The HTML body of the email.
   */
  html?: string;
  /**
   * The plain text body of the email.
   */
  text?: string;
  /**
   * The email addresses of the blind carbon copy recipients.
   */
  bcc?: Array<string>;
  /**
   * The email addresses of the carbon copy recipients.
   */
  cc?: Array<string>;
  /**
   * The email addresses to which replies should be sent.
   */
  reply_to?: Array<string>;
  /**
   * The status of the email.
   */
  last_event?: string;
};

export type GetAudienceResponseSuccess = {
  /**
   * The ID of the audience.
   */
  id?: string;
  /**
   * The object of the audience.
   */
  object?: string;
  /**
   * The name of the audience.
   */
  name?: string;
  /**
   * The date that the object was created.
   */
  created_at?: string;
};

export type GetContactResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Unique identifier for the contact.
   */
  id?: string;
  /**
   * Email address of the contact.
   */
  email?: string;
  /**
   * First name of the contact.
   */
  first_name?: string;
  /**
   * Last name of the contact.
   */
  last_name?: string;
  /**
   * Timestamp indicating when the contact was created.
   */
  created_at?: string;
  /**
   * Indicates if the contact is unsubscribed.
   */
  unsubscribed?: boolean;
};

export type ListApiKeysResponse = {
  data?: Array<ApiKey>;
};

export type ListAudiencesResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Array containing audience information.
   */
  data?: Array<{
    /**
     * Unique identifier for the audience.
     */
    id?: string;
    /**
     * Name of the audience.
     */
    name?: string;
    /**
     * Timestamp indicating when the audience was created.
     */
    created_at?: string;
  }>;
};

export type ListContactsResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Array containing contact information.
   */
  data?: Array<{
    /**
     * Unique identifier for the contact.
     */
    id?: string;
    /**
     * Email address of the contact.
     */
    email?: string;
    /**
     * First name of the contact.
     */
    first_name?: string;
    /**
     * Last name of the contact.
     */
    last_name?: string;
    /**
     * Timestamp indicating when the contact was created.
     */
    created_at?: string;
    /**
     * Indicates if the contact is unsubscribed.
     */
    unsubscribed?: boolean;
  }>;
};

export type ListDomainsItem = {
  /**
   * The ID of the domain.
   */
  id?: string;
  /**
   * The name of the domain.
   */
  name?: string;
  /**
   * The status of the domain.
   */
  status?: string;
  /**
   * The date and time the domain was created.
   */
  created_at?: string;
  /**
   * The region where the domain is hosted.
   */
  region?: string;
};

export type ListDomainsResponse = {
  data?: Array<ListDomainsItem>;
};

export type RemoveAudienceResponseSuccess = {
  /**
   * The ID of the audience.
   */
  id?: string;
  /**
   * The object of the audience.
   */
  object?: string;
  /**
   * The deleted attribute indicates that the corresponding audience has been deleted.
   */
  deleted?: boolean;
};

export type RemoveContactResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Unique identifier for the removed contact.
   */
  id?: string;
  /**
   * Indicates whether the contact was successfully deleted.
   */
  deleted?: boolean;
};

export type SendEmailRequest = {
  /**
   * Sender email address. To include a friendly name, use the format "Your Name <sender@domain.com>".
   */
  from: string;
  to: Array<string>;
  /**
   * Email subject.
   */
  subject: string;
  /**
   * Bcc recipient email address. For multiple addresses, send as an array of strings.
   */
  bcc?: string;
  /**
   * Cc recipient email address. For multiple addresses, send as an array of strings.
   */
  cc?: string;
  /**
   * Reply-to email address. For multiple addresses, send as an array of strings.
   */
  reply_to?: string;
  /**
   * The HTML version of the message.
   */
  html?: string;
  /**
   * The plain text version of the message.
   */
  text?: string;
  /**
   * Custom headers to add to the email.
   */
  headers?: {
    [key: string]: unknown;
  };
  /**
   * Schedule email to be sent later. The date should be in ISO 8601 format.
   */
  scheduled_at?: string;
  attachments?: Array<Attachment>;
  tags?: Array<Tag>;
};

export type SendEmailResponse = {
  /**
   * The ID of the sent email.
   */
  id?: string;
};

export type Tag = {
  /**
   * The name of the email tag. It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-). It can contain no more than 256 characters.
   */
  name?: string;
  /**
   * The value of the email tag.It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-). It can contain no more than 256 characters.
   */
  value?: string;
};

export type UpdateContactOptions = {
  /**
   * Email address of the contact.
   */
  email?: string;
  /**
   * First name of the contact.
   */
  first_name?: string;
  /**
   * Last name of the contact.
   */
  last_name?: string;
  /**
   * Indicates the subscription status of the contact.
   */
  unsubscribed?: boolean;
};

export type UpdateContactResponseSuccess = {
  /**
   * Type of the response object.
   */
  object?: string;
  /**
   * Unique identifier for the updated contact.
   */
  id?: string;
};

export type UpdateDomainOptions = {
  /**
   * Track the open rate of each email.
   */
  open_tracking?: boolean;
  /**
   * Track clicks within the body of each HTML email.
   */
  click_tracking?: boolean;
  /**
   * enforced | opportunistic.
   */
  tls?: string;
};

export type UpdateDomainResponseSuccess = {
  /**
   * The ID of the updated domain.
   */
  id?: string;
  /**
   * The object type representing the updated domain.
   */
  object?: string;
};

export type UpdateEmailOptions = {
  /**
   * Schedule email to be sent later. The date should be in ISO 8601 format.
   */
  scheduled_at?: string;
};

export type VerifyDomainResponse = {
  /**
   * The type of object.
   */
  object?: string;
  /**
   * The ID of the domain.
   */
  id?: string;
};

export type PostEmailsData = {
  body?: SendEmailRequest;
};

export type PostEmailsResponse = SendEmailResponse;

export type PostEmailsError = unknown;

export type GetEmailsByEmailIdData = {
  path: {
    email_id: string;
  };
};

export type GetEmailsByEmailIdResponse = Email;

export type GetEmailsByEmailIdError = unknown;

export type PatchEmailsByEmailIdData = {
  path: {
    email_id: string;
  };
};

export type PatchEmailsByEmailIdResponse = UpdateEmailOptions;

export type PatchEmailsByEmailIdError = unknown;

export type PostEmailsByEmailIdCancelData = {
  path: {
    email_id: string;
  };
};

export type PostEmailsByEmailIdCancelResponse = Email;

export type PostEmailsByEmailIdCancelError = unknown;

export type PostEmailsBatchData = {
  body?: Array<SendEmailRequest>;
};

export type PostEmailsBatchResponse = CreateBatchEmailsResponse;

export type PostEmailsBatchError = unknown;

export type PostDomainsData = {
  body?: CreateDomainRequest;
};

export type PostDomainsResponse = CreateDomainResponse;

export type PostDomainsError = unknown;

export type GetDomainsResponse = ListDomainsResponse;

export type GetDomainsError = unknown;

export type GetDomainsByDomainIdData = {
  path: {
    domain_id: string;
  };
};

export type GetDomainsByDomainIdResponse = Domain;

export type GetDomainsByDomainIdError = unknown;

export type PatchDomainsByDomainIdData = {
  body?: UpdateDomainOptions;
  path: {
    domain_id: string;
  };
};

export type PatchDomainsByDomainIdResponse = UpdateDomainResponseSuccess;

export type PatchDomainsByDomainIdError = unknown;

export type DeleteDomainsByDomainIdData = {
  path: {
    domain_id: string;
  };
};

export type DeleteDomainsByDomainIdResponse = DeleteDomainResponse;

export type DeleteDomainsByDomainIdError = unknown;

export type PostDomainsByDomainIdVerifyData = {
  path: {
    domain_id: string;
  };
};

export type PostDomainsByDomainIdVerifyResponse = VerifyDomainResponse;

export type PostDomainsByDomainIdVerifyError = unknown;

export type PostApiKeysData = {
  body?: CreateApiKeyRequest;
};

export type PostApiKeysResponse = CreateApiKeyResponse;

export type PostApiKeysError = unknown;

export type GetApiKeysResponse = ListApiKeysResponse;

export type GetApiKeysError = unknown;

export type DeleteApiKeysByApiKeyIdData = {
  path: {
    api_key_id: string;
  };
};

export type DeleteApiKeysByApiKeyIdResponse = unknown;

export type DeleteApiKeysByApiKeyIdError = unknown;

export type PostAudiencesData = {
  body?: CreateAudienceOptions;
};

export type PostAudiencesResponse = CreateAudienceResponseSuccess;

export type PostAudiencesError = unknown;

export type GetAudiencesResponse = ListAudiencesResponseSuccess;

export type GetAudiencesError = unknown;

export type DeleteAudiencesByIdData = {
  path: {
    id: string;
  };
};

export type DeleteAudiencesByIdResponse = RemoveAudienceResponseSuccess;

export type DeleteAudiencesByIdError = unknown;

export type GetAudiencesByIdData = {
  path: {
    id: string;
  };
};

export type GetAudiencesByIdResponse = GetAudienceResponseSuccess;

export type GetAudiencesByIdError = unknown;

export type PostAudiencesByAudienceIdContactsData = {
  body?: CreateContactOptions;
  path: {
    audience_id: string;
  };
};

export type PostAudiencesByAudienceIdContactsResponse = CreateContactResponseSuccess;

export type PostAudiencesByAudienceIdContactsError = unknown;

export type GetAudiencesByAudienceIdContactsData = {
  path: {
    audience_id: string;
  };
};

export type GetAudiencesByAudienceIdContactsResponse = ListContactsResponseSuccess;

export type GetAudiencesByAudienceIdContactsError = unknown;

export type DeleteAudiencesByAudienceIdContactsByEmailData = {
  path: {
    audience_id: string;
    email: string;
  };
};

export type DeleteAudiencesByAudienceIdContactsByEmailResponse = RemoveContactResponseSuccess;

export type DeleteAudiencesByAudienceIdContactsByEmailError = unknown;

export type DeleteAudiencesByAudienceIdContactsByIdData = {
  path: {
    audience_id: string;
    id: string;
  };
};

export type DeleteAudiencesByAudienceIdContactsByIdResponse = RemoveContactResponseSuccess;

export type DeleteAudiencesByAudienceIdContactsByIdError = unknown;

export type GetAudiencesByAudienceIdContactsByIdData = {
  path: {
    audience_id: string;
    id: string;
  };
};

export type GetAudiencesByAudienceIdContactsByIdResponse = GetContactResponseSuccess;

export type GetAudiencesByAudienceIdContactsByIdError = unknown;

export type PatchAudiencesByAudienceIdContactsByIdData = {
  body?: UpdateContactOptions;
  path: {
    audience_id: string;
    id: string;
  };
};

export type PatchAudiencesByAudienceIdContactsByIdResponse = UpdateContactResponseSuccess;

export type PatchAudiencesByAudienceIdContactsByIdError = unknown;
