// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  PostEmailsData,
  PostEmailsError,
  PostEmailsResponse,
  GetEmailsByEmailIdData,
  GetEmailsByEmailIdError,
  GetEmailsByEmailIdResponse,
  PatchEmailsByEmailIdData,
  PatchEmailsByEmailIdError,
  PatchEmailsByEmailIdResponse,
  PostEmailsByEmailIdCancelData,
  PostEmailsByEmailIdCancelError,
  PostEmailsByEmailIdCancelResponse,
  PostEmailsBatchData,
  PostEmailsBatchError,
  PostEmailsBatchResponse,
  PostDomainsData,
  PostDomainsError,
  PostDomainsResponse,
  GetDomainsError,
  GetDomainsResponse,
  GetDomainsByDomainIdData,
  GetDomainsByDomainIdError,
  GetDomainsByDomainIdResponse,
  PatchDomainsByDomainIdData,
  PatchDomainsByDomainIdError,
  PatchDomainsByDomainIdResponse,
  DeleteDomainsByDomainIdData,
  DeleteDomainsByDomainIdError,
  DeleteDomainsByDomainIdResponse,
  PostDomainsByDomainIdVerifyData,
  PostDomainsByDomainIdVerifyError,
  PostDomainsByDomainIdVerifyResponse,
  PostApiKeysData,
  PostApiKeysError,
  PostApiKeysResponse,
  GetApiKeysError,
  GetApiKeysResponse,
  DeleteApiKeysByApiKeyIdData,
  DeleteApiKeysByApiKeyIdError,
  DeleteApiKeysByApiKeyIdResponse,
  PostAudiencesData,
  PostAudiencesError,
  PostAudiencesResponse,
  GetAudiencesError,
  GetAudiencesResponse,
  DeleteAudiencesByIdData,
  DeleteAudiencesByIdError,
  DeleteAudiencesByIdResponse,
  GetAudiencesByIdData,
  GetAudiencesByIdError,
  GetAudiencesByIdResponse,
  PostAudiencesByAudienceIdContactsData,
  PostAudiencesByAudienceIdContactsError,
  PostAudiencesByAudienceIdContactsResponse,
  GetAudiencesByAudienceIdContactsData,
  GetAudiencesByAudienceIdContactsError,
  GetAudiencesByAudienceIdContactsResponse,
  DeleteAudiencesByAudienceIdContactsByEmailData,
  DeleteAudiencesByAudienceIdContactsByEmailError,
  DeleteAudiencesByAudienceIdContactsByEmailResponse,
  DeleteAudiencesByAudienceIdContactsByIdData,
  DeleteAudiencesByAudienceIdContactsByIdError,
  DeleteAudiencesByAudienceIdContactsByIdResponse,
  GetAudiencesByAudienceIdContactsByIdData,
  GetAudiencesByAudienceIdContactsByIdError,
  GetAudiencesByAudienceIdContactsByIdResponse,
  PatchAudiencesByAudienceIdContactsByIdData,
  PatchAudiencesByAudienceIdContactsByIdError,
  PatchAudiencesByAudienceIdContactsByIdResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Send an email
 */
export const postEmails = <ThrowOnError extends boolean = false>(options?: Options<PostEmailsData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostEmailsResponse, PostEmailsError, ThrowOnError>({
    ...options,
    url: '/emails',
  });
};

/**
 * Retrieve a single email
 */
export const getEmailsByEmailId = <ThrowOnError extends boolean = false>(
  options: Options<GetEmailsByEmailIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEmailsByEmailIdResponse, GetEmailsByEmailIdError, ThrowOnError>({
    ...options,
    url: '/emails/{email_id}',
  });
};

/**
 * Update a single email
 */
export const patchEmailsByEmailId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEmailsByEmailIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchEmailsByEmailIdResponse, PatchEmailsByEmailIdError, ThrowOnError>({
    ...options,
    url: '/emails/{email_id}',
  });
};

/**
 * Cancel the schedule of the e-mail.
 */
export const postEmailsByEmailIdCancel = <ThrowOnError extends boolean = false>(
  options: Options<PostEmailsByEmailIdCancelData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEmailsByEmailIdCancelResponse,
    PostEmailsByEmailIdCancelError,
    ThrowOnError
  >({
    ...options,
    url: '/emails/{email_id}/cancel',
  });
};

/**
 * Trigger up to 100 batch emails at once.
 */
export const postEmailsBatch = <ThrowOnError extends boolean = false>(
  options?: Options<PostEmailsBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostEmailsBatchResponse, PostEmailsBatchError, ThrowOnError>({
    ...options,
    url: '/emails/batch',
  });
};

/**
 * Create a new domain
 */
export const postDomains = <ThrowOnError extends boolean = false>(options?: Options<PostDomainsData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostDomainsResponse, PostDomainsError, ThrowOnError>({
    ...options,
    url: '/domains',
  });
};

/**
 * Retrieve a list of domains
 */
export const getDomains = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDomainsResponse, GetDomainsError, ThrowOnError>({
    ...options,
    url: '/domains',
  });
};

/**
 * Retrieve a single domain
 */
export const getDomainsByDomainId = <ThrowOnError extends boolean = false>(
  options: Options<GetDomainsByDomainIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDomainsByDomainIdResponse, GetDomainsByDomainIdError, ThrowOnError>({
    ...options,
    url: '/domains/{domain_id}',
  });
};

/**
 * Update an existing domain
 */
export const patchDomainsByDomainId = <ThrowOnError extends boolean = false>(
  options: Options<PatchDomainsByDomainIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchDomainsByDomainIdResponse, PatchDomainsByDomainIdError, ThrowOnError>({
    ...options,
    url: '/domains/{domain_id}',
  });
};

/**
 * Remove an existing domain
 */
export const deleteDomainsByDomainId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDomainsByDomainIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteDomainsByDomainIdResponse,
    DeleteDomainsByDomainIdError,
    ThrowOnError
  >({
    ...options,
    url: '/domains/{domain_id}',
  });
};

/**
 * Verify an existing domain
 */
export const postDomainsByDomainIdVerify = <ThrowOnError extends boolean = false>(
  options: Options<PostDomainsByDomainIdVerifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostDomainsByDomainIdVerifyResponse,
    PostDomainsByDomainIdVerifyError,
    ThrowOnError
  >({
    ...options,
    url: '/domains/{domain_id}/verify',
  });
};

/**
 * Create a new API key
 */
export const postApiKeys = <ThrowOnError extends boolean = false>(options?: Options<PostApiKeysData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostApiKeysResponse, PostApiKeysError, ThrowOnError>({
    ...options,
    url: '/api-keys',
  });
};

/**
 * Retrieve a list of API keys
 */
export const getApiKeys = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetApiKeysResponse, GetApiKeysError, ThrowOnError>({
    ...options,
    url: '/api-keys',
  });
};

/**
 * Remove an existing API key
 */
export const deleteApiKeysByApiKeyId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteApiKeysByApiKeyIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteApiKeysByApiKeyIdResponse,
    DeleteApiKeysByApiKeyIdError,
    ThrowOnError
  >({
    ...options,
    url: '/api-keys/{api_key_id}',
  });
};

/**
 * Create a list of contacts
 */
export const postAudiences = <ThrowOnError extends boolean = false>(
  options?: Options<PostAudiencesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostAudiencesResponse, PostAudiencesError, ThrowOnError>({
    ...options,
    url: '/audiences',
  });
};

/**
 * Retrieve a list of audiences
 */
export const getAudiences = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetAudiencesResponse, GetAudiencesError, ThrowOnError>({
    ...options,
    url: '/audiences',
  });
};

/**
 * Remove an existing audience
 */
export const deleteAudiencesById = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAudiencesByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAudiencesByIdResponse, DeleteAudiencesByIdError, ThrowOnError>({
    ...options,
    url: '/audiences/{id}',
  });
};

/**
 * Retrieve a single audience
 */
export const getAudiencesById = <ThrowOnError extends boolean = false>(
  options: Options<GetAudiencesByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAudiencesByIdResponse, GetAudiencesByIdError, ThrowOnError>({
    ...options,
    url: '/audiences/{id}',
  });
};

/**
 * Create a new contact
 */
export const postAudiencesByAudienceIdContacts = <ThrowOnError extends boolean = false>(
  options: Options<PostAudiencesByAudienceIdContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAudiencesByAudienceIdContactsResponse,
    PostAudiencesByAudienceIdContactsError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts',
  });
};

/**
 * Retrieve a list of contacts
 */
export const getAudiencesByAudienceIdContacts = <ThrowOnError extends boolean = false>(
  options: Options<GetAudiencesByAudienceIdContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAudiencesByAudienceIdContactsResponse,
    GetAudiencesByAudienceIdContactsError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts',
  });
};

/**
 * Remove an existing contact by email
 */
export const deleteAudiencesByAudienceIdContactsByEmail = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAudiencesByAudienceIdContactsByEmailData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAudiencesByAudienceIdContactsByEmailResponse,
    DeleteAudiencesByAudienceIdContactsByEmailError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts/{email}',
  });
};

/**
 * Remove an existing contact by id
 */
export const deleteAudiencesByAudienceIdContactsById = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAudiencesByAudienceIdContactsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAudiencesByAudienceIdContactsByIdResponse,
    DeleteAudiencesByAudienceIdContactsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts/{id}',
  });
};

/**
 * Retrieve a single contact
 */
export const getAudiencesByAudienceIdContactsById = <ThrowOnError extends boolean = false>(
  options: Options<GetAudiencesByAudienceIdContactsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAudiencesByAudienceIdContactsByIdResponse,
    GetAudiencesByAudienceIdContactsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts/{id}',
  });
};

/**
 * Update a single contact
 */
export const patchAudiencesByAudienceIdContactsById = <ThrowOnError extends boolean = false>(
  options: Options<PatchAudiencesByAudienceIdContactsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchAudiencesByAudienceIdContactsByIdResponse,
    PatchAudiencesByAudienceIdContactsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/audiences/{audience_id}/contacts/{id}',
  });
};
