// Generated by ts-to-zod
import { z } from 'zod';

export const modeSchema = z.union([z.literal('hi_res'), z.literal('fast')]);

export const connectionSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  metadata: z.record(z.unknown()),
  type: z.string(),
  name: z.string(),
  enabled: z.boolean(),
  last_synced_at: z.string().optional().nullable(),
  syncing: z.boolean().optional().nullable(),
});

export const connectionBaseSchema = z.object({
  partition_strategy: z.union([z.literal('hi_res'), z.literal('fast')]),
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])).optional(),
});

export const partitionStrategySchema = z.union([z.literal('hi_res'), z.literal('fast')]);

export const paginationSchema = z.object({
  next_cursor: z.string().optional().nullable(),
});

export const connectionStatsSchema = z.object({
  document_count: z.number(),
});

export const connectionSyncFinishedWebhookPayloadSchema = z.object({
  connection_id: z.string(),
  sync_id: z.string(),
  partition: z.string(),
  connection_metadata: z.record(z.unknown()),
});

export const typeSchema = z.literal('connection_sync_finished');

export const connectionSyncProgressWebhookPayloadSchema = z.object({
  connection_id: z.string(),
  sync_id: z.string(),
  partition: z.string(),
  connection_metadata: z.record(z.unknown()),
  create_count: z.number(),
  created_count: z.number(),
  update_content_count: z.number(),
  updated_content_count: z.number(),
  update_metadata_count: z.number(),
  updated_metadata_count: z.number(),
  delete_count: z.number(),
  deleted_count: z.number(),
  errored_count: z.number(),
});

export const type2Schema = z.literal('connection_sync_progress');

export const connectionSyncStartedWebhookPayloadSchema = z.object({
  connection_id: z.string(),
  sync_id: z.string(),
  partition: z.string(),
  connection_metadata: z.record(z.unknown()),
  create_count: z.number(),
  update_content_count: z.number(),
  update_metadata_count: z.number(),
  delete_count: z.number(),
});

export const type3Schema = z.literal('connection_sync_started');

export const createDocumentFromUrlParamsSchema = z.object({
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])).optional(),
  mode: z.union([z.literal('hi_res'), z.literal('fast')]).optional(),
  name: z.string().optional(),
  external_id: z.string().optional(),
  url: z.string(),
  partition: z.string().optional(),
});

export const createDocumentRawParamsSchema = z.object({
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])).optional(),
  name: z.string().optional(),
  data: z.union([z.string(), z.record(z.unknown())]),
  partition: z.string().optional(),
});

export const entitySchemaTypeSchema = z.record(z.unknown());

export const scopeSchema = z.union([z.literal('document'), z.literal('chunk')]);

export const deleteConnectionPayloadSchema = z.object({
  keep_files: z.boolean(),
});

export const documentSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  status: z.string(),
  name: z.string(),
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])),
  partition: z.string(),
  chunk_count: z.number().optional().nullable(),
  external_id: z.string().optional().nullable(),
});

export const documentDeleteSchema = z.object({
  status: z.string(),
});

export const documentDeleteWebhookPayloadSchema = z.object({
  document_id: z.string(),
  partition: z.string(),
  metadata: z.record(z.unknown()),
  external_id: z.string().nullable(),
  sync_id: z.string().nullable(),
});

export const type4Schema = z.literal('document_deleted');

export const documentFileUpdateSchema = z.object({
  status: z.string(),
});

export const documentGetSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  status: z.string(),
  name: z.string(),
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])),
  partition: z.string(),
  chunk_count: z.number().optional().nullable(),
  external_id: z.string().optional().nullable(),
  errors: z.array(z.string()),
});

export const documentListSchema = z.object({
  pagination: paginationSchema,
  documents: z.array(documentSchema),
});

export const documentMetadataSchema = z.record(z.unknown());

export const documentMetadataUpdateSchema = z.object({
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())])),
});

export const documentRawUpdateSchema = z.object({
  status: z.string(),
});

export const documentSummarySchema = z.object({
  document_id: z.string(),
  summary: z.string(),
});

export const documentUpdateWebhookPayloadSchema = z.object({
  document_id: z.string(),
  status: z.union([z.literal('ready'), z.literal('failed')]),
  partition: z.string(),
  metadata: z.record(z.unknown()),
  external_id: z.string().nullable(),
  sync_id: z.string().nullable(),
});

export const type5Schema = z.literal('document_status_updated');

export const entityDataSchema = z.record(z.unknown());

export const entityExtractedWebhookPayloadSchema = z.object({
  entity_id: z.string(),
  document_id: z.string(),
  instruction_id: z.string(),
  document_metadata: z.record(z.unknown()),
  document_external_id: z.string().nullable(),
  partition: z.string(),
  sync_id: z.string().nullable(),
  data: z.record(z.unknown()),
});

export const type6Schema = z.literal('entity_extracted');

export const entitySchema = z.object({
  id: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  instruction_id: z.string(),
  document_id: z.string(),
  data: entityDataSchema,
});

export const errorMessageSchema = z.object({
  detail: z.string(),
});

export const validationErrorSchema = z.object({
  loc: z.array(z.union([z.string(), z.number()])),
  msg: z.string(),
  type: z.string(),
});

export const instructionSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  name: z.string(),
  active: z.boolean().optional(),
  scope: z.union([z.literal('document'), z.literal('chunk')]).optional(),
  prompt: z.string(),
  entity_schema: entitySchemaTypeSchema,
  filter: z.record(z.unknown()).optional(),
  partition: z.string().optional(),
});

export const metadataFilterSchema = z.record(z.unknown());

export const patchDocumentMetadataParamsSchema = z.object({
  metadata: z.record(z.union([z.string(), z.number(), z.boolean(), z.array(z.string())]).nullable()),
});

export const scoredChunkSchema = z.object({
  text: z.string(),
  score: z.number(),
  document_id: z.string(),
  document_name: z.string(),
  document_metadata: documentMetadataSchema,
});

export const retrieveParamsSchema = z.object({
  query: z.string(),
  top_k: z.number().optional(),
  filter: metadataFilterSchema.optional(),
  rerank: z.boolean().optional(),
  max_chunks_per_document: z.number().optional(),
  partition: z.string().optional(),
});

export const setConnectionEnabledPayloadSchema = z.object({
  enabled: z.boolean(),
});

export const updateDocumentRawParamsSchema = z.object({
  data: z.union([z.string(), z.record(z.unknown())]),
});

export const updateInstructionParamsSchema = z.object({
  active: z.boolean(),
});

export const createDocumentResponseSchema = documentSchema;

export const hTTPValidationErrorSchema = z.object({
  detail: z.array(validationErrorSchema).optional(),
});

export const listDocumentsDataSchema = z.object({
  headers: z
    .object({
      partition: z.string().optional().nullable(),
    })
    .optional(),
  query: z
    .object({
      cursor: z.string().optional().nullable(),
      filter: z.string().optional().nullable(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listDocumentsResponseSchema = documentListSchema;

export const listDocumentsErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const createDocumentRawDataSchema = z.object({
  body: createDocumentRawParamsSchema,
});

export const createDocumentRawResponseSchema = documentSchema;

export const createDocumentRawErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const createDocumentFromUrlDataSchema = z.object({
  body: createDocumentFromUrlParamsSchema,
});

export const createDocumentFromUrlResponseSchema = documentSchema;

export const createDocumentFromUrlErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const getDocumentDataSchema = z.object({
  path: z.object({
    document_id: z.string(),
  }),
});

export const getDocumentResponseSchema = documentGetSchema;

export const getDocumentErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const deleteDocumentDataSchema = z.object({
  path: z.object({
    document_id: z.string(),
  }),
});

export const deleteDocumentResponseSchema = documentDeleteSchema;

export const deleteDocumentErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const updateDocumentFileResponseSchema = documentFileUpdateSchema;

export const updateDocumentFileErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const updateDocumentRawDataSchema = z.object({
  body: updateDocumentRawParamsSchema,
  path: z.object({
    document_id: z.string(),
  }),
});

export const updateDocumentRawResponseSchema = documentRawUpdateSchema;

export const updateDocumentRawErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const patchDocumentMetadataDataSchema = z.object({
  body: patchDocumentMetadataParamsSchema,
  path: z.object({
    document_id: z.string(),
  }),
});

export const patchDocumentMetadataResponseSchema = documentMetadataUpdateSchema;

export const patchDocumentMetadataErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const retrieveDataSchema = z.object({
  body: retrieveParamsSchema,
});

export const retrievalSchema = z.object({
  scored_chunks: z.array(scoredChunkSchema),
});

export const retrieveErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const getDocumentSummaryDataSchema = z.object({
  path: z.object({
    document_id: z.string(),
  }),
});

export const getDocumentSummaryResponseSchema = documentSummarySchema;

export const getDocumentSummaryErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const listInstructionsResponseSchema = z.array(instructionSchema);

export const listInstructionsErrorSchema = errorMessageSchema;

export const createInstructionParamsSchema = z.object({
  name: z.string(),
  active: z.boolean().optional(),
  scope: z.union([z.literal('document'), z.literal('chunk')]).optional(),
  prompt: z.string(),
  entity_schema: entitySchemaTypeSchema,
  filter: z.record(z.unknown()).optional(),
  partition: z.string().optional(),
});

export const createInstructionResponseSchema = instructionSchema;

export const createInstructionErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const updateInstructionDataSchema = z.object({
  body: updateInstructionParamsSchema,
  path: z.object({
    instruction_id: z.string(),
  }),
});

export const updateInstructionResponseSchema = instructionSchema;

export const updateInstructionErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const listEntitiesByInstructionDataSchema = z.object({
  path: z.object({
    instruction_id: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional().nullable(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const entityListSchema = z.object({
  pagination: paginationSchema,
  entities: z.array(entitySchema),
});

export const listEntitiesByInstructionErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const listEntitiesByDocumentDataSchema = z.object({
  path: z.object({
    document_id: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional().nullable(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const listEntitiesByDocumentResponseSchema = entityListSchema;

export const listEntitiesByDocumentErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const listConnectionsConnectionsGetDataSchema = z.object({
  query: z
    .object({
      cursor: z.string().optional().nullable(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const connectionListSchema = z.object({
  pagination: paginationSchema,
  connections: z.array(connectionSchema),
});

export const listConnectionsConnectionsGetErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const setConnectionEnabledConnectionsConnectionIdEnabledPutDataSchema = z.object({
  body: setConnectionEnabledPayloadSchema,
  path: z.object({
    connection_id: z.string(),
  }),
});

export const setConnectionEnabledConnectionsConnectionIdEnabledPutResponseSchema = connectionSchema;

export const setConnectionEnabledConnectionsConnectionIdEnabledPutErrorSchema = z.union([
  errorMessageSchema,
  hTTPValidationErrorSchema,
]);

export const updateConnectionConnectionsConnectionIdPutDataSchema = z.object({
  body: connectionBaseSchema,
  path: z.object({
    connection_id: z.string(),
  }),
});

export const updateConnectionConnectionsConnectionIdPutResponseSchema = connectionSchema;

export const updateConnectionConnectionsConnectionIdPutErrorSchema = z.union([
  errorMessageSchema,
  hTTPValidationErrorSchema,
]);

export const getConnectionStatsConnectionsConnectionIdStatsGetDataSchema = z.object({
  path: z.object({
    connection_id: z.string(),
  }),
});

export const getConnectionStatsConnectionsConnectionIdStatsGetResponseSchema = connectionStatsSchema;

export const getConnectionStatsConnectionsConnectionIdStatsGetErrorSchema = z.union([
  errorMessageSchema,
  hTTPValidationErrorSchema,
]);

export const deleteConnectionConnectionsConnectionIdDeletePostDataSchema = z.object({
  body: deleteConnectionPayloadSchema,
  path: z.object({
    connection_id: z.string(),
  }),
});

export const deleteConnectionConnectionsConnectionIdDeletePostResponseSchema = z.record(z.string());

export const deleteConnectionConnectionsConnectionIdDeletePostErrorSchema = z.union([
  errorMessageSchema,
  hTTPValidationErrorSchema,
]);

export const connectionSyncFinishedWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('connection_sync_finished'),
  payload: connectionSyncFinishedWebhookPayloadSchema,
});

export const connectionSyncProgressWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('connection_sync_progress'),
  payload: connectionSyncProgressWebhookPayloadSchema,
});

export const connectionSyncStartedWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('connection_sync_started'),
  payload: connectionSyncStartedWebhookPayloadSchema,
});

export const documentDeleteWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('document_deleted'),
  payload: documentDeleteWebhookPayloadSchema,
});

export const documentUpdateWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('document_status_updated'),
  payload: documentUpdateWebhookPayloadSchema,
});

export const entityExtractedWebhookSchema = z.object({
  nonce: z.string(),
  type: z.literal('entity_extracted'),
  payload: entityExtractedWebhookPayloadSchema,
});

export const createDocumentErrorSchema = z.union([errorMessageSchema, hTTPValidationErrorSchema]);

export const retrieveResponseSchema = retrievalSchema;

export const createInstructionDataSchema = z.object({
  body: createInstructionParamsSchema,
});

export const listEntitiesByInstructionResponseSchema = entityListSchema;

export const listConnectionsConnectionsGetResponseSchema = connectionListSchema;
