// This file is auto-generated by @hey-api/openapi-ts

export type Body_CreateDocument = {
  /**
   * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
   */
  mode?: 'hi_res' | 'fast';
  /**
   * Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.
   */
  metadata?: string;
  /**
   * The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: `.eml` `.html` `.json` `.md` `.msg` `.rst` `.rtf` `.txt` `.xml`
   * Images: `.png` `.webp` `.jpg` `.jpeg` `.tiff` `.bmp` `.heic`
   * Documents: `.csv` `.doc` `.docx` `.epub` `.epub+zip` `.odt` `.pdf` `.ppt` `.pptx` `.tsv` `.xlsx` `.xls`.
   */
  file: Blob | File;
  /**
   * An optional identifier for the document. A common value might be an id in an external system or the URL where the source file may be found.
   */
  external_id?: string;
  /**
   * An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.
   */
  partition?: string;
};

/**
 * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
 */
export type mode = 'hi_res' | 'fast';

export type Body_UpdateDocumentFile = {
  /**
   * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
   */
  mode?: 'hi_res' | 'fast';
  /**
   * The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: `.eml` `.html` `.json` `.md` `.msg` `.rst` `.rtf` `.txt` `.xml`
   * Images: `.png` `.webp` `.jpg` `.jpeg` `.tiff` `.bmp` `.heic`
   * Documents: `.csv` `.doc` `.docx` `.epub` `.epub+zip` `.odt` `.pdf` `.ppt` `.pptx` `.tsv` `.xlsx` `.xls`.
   */
  file: Blob | File;
};

export type Connection = {
  id: string;
  created_at: string;
  updated_at: string;
  metadata: {
    [key: string]: unknown;
  };
  type: string;
  name: string;
  enabled: boolean;
  last_synced_at?: string | null;
  syncing?: boolean | null;
};

export type ConnectionBase = {
  partition_strategy: 'hi_res' | 'fast';
  /**
   * Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.
   */
  metadata?: {
    [key: string]: string | number | boolean | Array<string>;
  };
};

export type partition_strategy = 'hi_res' | 'fast';

export type ConnectionList = {
  pagination: Pagination;
  connections: Array<Connection>;
};

export type ConnectionStats = {
  document_count: number;
};

export type ConnectionSyncFinishedWebhook = {
  nonce: string;
  type: 'connection_sync_finished';
  payload: ConnectionSyncFinishedWebhookPayload;
};

export type type = 'connection_sync_finished';

export type ConnectionSyncFinishedWebhookPayload = {
  connection_id: string;
  sync_id: string;
  partition: string;
  connection_metadata: {
    [key: string]: unknown;
  };
};

export type ConnectionSyncProgressWebhook = {
  nonce: string;
  type: 'connection_sync_progress';
  payload: ConnectionSyncProgressWebhookPayload;
};

export type type2 = 'connection_sync_progress';

export type ConnectionSyncProgressWebhookPayload = {
  connection_id: string;
  sync_id: string;
  partition: string;
  connection_metadata: {
    [key: string]: unknown;
  };
  create_count: number;
  created_count: number;
  update_content_count: number;
  updated_content_count: number;
  update_metadata_count: number;
  updated_metadata_count: number;
  delete_count: number;
  deleted_count: number;
  errored_count: number;
};

export type ConnectionSyncStartedWebhook = {
  nonce: string;
  type: 'connection_sync_started';
  payload: ConnectionSyncStartedWebhookPayload;
};

export type type3 = 'connection_sync_started';

export type ConnectionSyncStartedWebhookPayload = {
  connection_id: string;
  sync_id: string;
  partition: string;
  connection_metadata: {
    [key: string]: unknown;
  };
  create_count: number;
  update_content_count: number;
  update_metadata_count: number;
  delete_count: number;
};

export type CreateDocumentFromUrlParams = {
  /**
   * Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.
   */
  metadata?: {
    [key: string]: string | number | boolean | Array<string>;
  };
  /**
   * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
   */
  mode?: 'hi_res' | 'fast';
  name?: string;
  external_id?: string;
  /**
   * Url of the file to download. Must be publicly accessible and HTTP or HTTPS scheme
   */
  url: string;
  /**
   * An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.
   */
  partition?: string;
};

export type CreateDocumentParams = {
  /**
   * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
   */
  mode?: 'hi_res' | 'fast';
  /**
   * Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.
   */
  metadata?: {
    [key: string]: string | number | boolean | Array<string>;
  };
  /**
   * The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: `.eml` `.html` `.json` `.md` `.msg` `.rst` `.rtf` `.txt` `.xml`
   * Images: `.png` `.webp` `.jpg` `.jpeg` `.tiff` `.bmp` `.heic`
   * Documents: `.csv` `.doc` `.docx` `.epub` `.epub+zip` `.odt` `.pdf` `.ppt` `.pptx` `.tsv` `.xlsx` `.xls`.
   */
  file: Blob | File;
  /**
   * An optional identifier for the document. A common value might be an id in an external system or the URL where the source file may be found.
   */
  external_id?: string;
  /**
   * An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.
   */
  partition?: string;
};

export type CreateDocumentRawParams = {
  /**
   * Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.
   */
  metadata?: {
    [key: string]: string | number | boolean | Array<string>;
  };
  /**
   * An optional name for the document. If set, the document will have this name. Otherwise it will default to the current timestamp.
   */
  name?: string;
  /**
   * Document data in a text or JSON format.
   */
  data:
    | string
    | {
        [key: string]: unknown;
      };
  /**
   * An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.
   */
  partition?: string;
};

export type CreateInstructionParams = {
  /**
   * The name of the instruction. Must be unique.
   */
  name: string;
  /**
   * Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.
   */
  active?: boolean;
  /**
   * The scope of the instruction. Determines whether the instruction is applied to the entire document or to each chunk of the document. Options are `'document'` or `'chunk'`. Generally `'document'` should be used when analyzing the full document is desired, such as when generating a summary or determining sentiment, and `'chunk'` should be used when a fine grained search over a document is desired.
   */
  scope?: 'document' | 'chunk';
  /**
   * A natural language instruction which will be applied to documents as they are created and updated. The results of the `instruction_prompt` will be stored as an `entity` in the schema defined by the `entity_schema` parameter.
   */
  prompt: string;
  /**
   * The JSON schema definition of the entity generated by an instruction. The schema must define an `object` at its root. If the instruction is expected to generate multiple items, the root object should have a key which defines an array of the expected items. An instruction which generates multiple emails may be expressed as `{"type": "object", "properties": {"emails": { "type": "array", "items": { "type": "string"}}}}`. Simple values may be expressed as an object with a single key. For example, a summary instruction may generate a single string value. The schema might be `{"type": "object", "properties": { "summary": { "type": "string"}}}`.
   */
  entity_schema: EntitySchemaType;
  /**
   * An optional metadata filter that is matched against document metadata during update and creation. The instruction will only be applied to documents with metadata matching the filter.  The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.
   */
  filter?: {
    [key: string]: unknown;
  };
  /**
   * An optional partition identifier. Instructions can be scoped to a partition. An instruction that defines a partition will only be executed for documents in that partition.
   */
  partition?: string;
};

/**
 * The scope of the instruction. Determines whether the instruction is applied to the entire document or to each chunk of the document. Options are `'document'` or `'chunk'`. Generally `'document'` should be used when analyzing the full document is desired, such as when generating a summary or determining sentiment, and `'chunk'` should be used when a fine grained search over a document is desired.
 */
export type scope = 'document' | 'chunk';

export type DeleteConnectionPayload = {
  keep_files: boolean;
};

export type Document = {
  id: string;
  created_at: string;
  updated_at: string;
  status: string;
  name: string;
  metadata: {
    [key: string]: string | number | boolean | Array<string>;
  };
  partition: string;
  chunk_count?: number | null;
  external_id?: string | null;
};

export type DocumentDelete = {
  status: string;
};

export type DocumentDeleteWebhook = {
  nonce: string;
  type: 'document_deleted';
  payload: DocumentDeleteWebhookPayload;
};

export type type4 = 'document_deleted';

export type DocumentDeleteWebhookPayload = {
  document_id: string;
  partition: string;
  metadata: {
    [key: string]: unknown;
  };
  external_id: string | null;
  sync_id: string | null;
};

export type DocumentFileUpdate = {
  status: string;
};

export type DocumentGet = {
  id: string;
  created_at: string;
  updated_at: string;
  status: string;
  name: string;
  metadata: {
    [key: string]: string | number | boolean | Array<string>;
  };
  partition: string;
  chunk_count?: number | null;
  external_id?: string | null;
  errors: Array<string>;
};

export type DocumentList = {
  pagination: Pagination;
  documents: Array<Document>;
};

export type DocumentMetadata = {
  [key: string]: unknown;
};

export type DocumentMetadataUpdate = {
  /**
   * The full document metadata inclusive of the update.
   */
  metadata: {
    [key: string]: string | number | boolean | Array<string>;
  };
};

export type DocumentRawUpdate = {
  status: string;
};

export type DocumentSummary = {
  document_id: string;
  summary: string;
};

export type DocumentUpdateWebhook = {
  nonce: string;
  type: 'document_status_updated';
  payload: DocumentUpdateWebhookPayload;
};

export type type5 = 'document_status_updated';

export type DocumentUpdateWebhookPayload = {
  document_id: string;
  status: 'ready' | 'failed';
  partition: string;
  metadata: {
    [key: string]: unknown;
  };
  external_id: string | null;
  sync_id: string | null;
};

export type Entity = {
  id: string;
  created_at: string;
  updated_at: string;
  /**
   * The ID of the instruction which generated the entity.
   */
  instruction_id: string;
  /**
   * The ID of the document which the entity was produced from.
   */
  document_id: string;
  /**
   * The entity data generated by the instruction.
   */
  data: EntityData;
};

export type EntityData = {
  [key: string]: unknown;
};

export type EntityExtractedWebhook = {
  nonce: string;
  type: 'entity_extracted';
  payload: EntityExtractedWebhookPayload;
};

export type type6 = 'entity_extracted';

export type EntityExtractedWebhookPayload = {
  entity_id: string;
  document_id: string;
  instruction_id: string;
  document_metadata: {
    [key: string]: unknown;
  };
  document_external_id: string | null;
  partition: string;
  sync_id: string | null;
  data: {
    [key: string]: unknown;
  };
};

export type EntityList = {
  pagination: Pagination;
  entities: Array<Entity>;
};

export type EntitySchemaType = {
  [key: string]: unknown;
};

export type ErrorMessage = {
  detail: string;
};

export type HTTPValidationError = {
  detail?: Array<ValidationError>;
};

export type Instruction = {
  id: string;
  created_at: string;
  updated_at: string;
  /**
   * The name of the instruction. Must be unique.
   */
  name: string;
  /**
   * Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.
   */
  active?: boolean;
  /**
   * The scope of the instruction. Determines whether the instruction is applied to the entire document or to each chunk of the document. Options are `'document'` or `'chunk'`. Generally `'document'` should be used when analyzing the full document is desired, such as when generating a summary or determining sentiment, and `'chunk'` should be used when a fine grained search over a document is desired.
   */
  scope?: 'document' | 'chunk';
  /**
   * A natural language instruction which will be applied to documents as they are created and updated. The results of the `instruction_prompt` will be stored as an `entity` in the schema defined by the `entity_schema` parameter.
   */
  prompt: string;
  /**
   * The JSON schema definition of the entity generated by an instruction. The schema must define an `object` at its root. If the instruction is expected to generate multiple items, the root object should have a key which defines an array of the expected items. An instruction which generates multiple emails may be expressed as `{"type": "object", "properties": {"emails": { "type": "array", "items": { "type": "string"}}}}`. Simple values may be expressed as an object with a single key. For example, a summary instruction may generate a single string value. The schema might be `{"type": "object", "properties": { "summary": { "type": "string"}}}`.
   */
  entity_schema: EntitySchemaType;
  /**
   * An optional metadata filter that is matched against document metadata during update and creation. The instruction will only be applied to documents with metadata matching the filter.  The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.
   */
  filter?: {
    [key: string]: unknown;
  };
  /**
   * An optional partition identifier. Instructions can be scoped to a partition. An instruction that defines a partition will only be executed for documents in that partition.
   */
  partition?: string;
};

export type MetadataFilter = {
  [key: string]: unknown;
};

export type Pagination = {
  next_cursor?: string | null;
};

export type PatchDocumentMetadataParams = {
  /**
   * The metadata to update on the document. Performs a partial update of the document's metadata. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. Keys set to `null` are deleted. 1000 total values are allowed, inclusive of existing metadata. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`. If the document is managed by a connection, this operation will extend a metadata overlay which is applied to the document any time the connection syncs the document.
   */
  metadata: {
    [key: string]: string | number | boolean | Array<string> | null;
  };
};

export type Retrieval = {
  scored_chunks: Array<ScoredChunk>;
};

export type RetrieveParams = {
  /**
   * The query to search with when retrieving document chunks.
   */
  query: string;
  /**
   * The maximum number of chunks to return. Defaults to 8.
   */
  top_k?: number;
  /**
   * The metadata search filter on documents. Returns chunks only from documents which match the filter. The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.
   */
  filter?: MetadataFilter;
  /**
   * Reranks the chunks for semantic relevancy post cosine similarity. Will be slower but returns a subset of highly relevant chunks. Best for reducing hallucinations and improving accuracy for LLM generation.
   */
  rerank?: boolean;
  /**
   * Maximum number of chunks to retrieve per document. Use this to increase the number of documents the final chunks are retreived from. This feature is in beta and may change in the future.
   */
  max_chunks_per_document?: number;
  /**
   * The partition to scope a retrieval to. If omitted, the retrieval will be scoped to the default partition, which includes any documents that have not been created in or moved to a partition.
   */
  partition?: string;
};

export type ScoredChunk = {
  text: string;
  score: number;
  document_id: string;
  document_name: string;
  document_metadata: DocumentMetadata;
};

export type SetConnectionEnabledPayload = {
  enabled: boolean;
};

export type UpdateDocumentFileParams = {
  /**
   * Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.
   */
  mode?: 'hi_res' | 'fast';
  /**
   * The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: `.eml` `.html` `.json` `.md` `.msg` `.rst` `.rtf` `.txt` `.xml`
   * Images: `.png` `.webp` `.jpg` `.jpeg` `.tiff` `.bmp` `.heic`
   * Documents: `.csv` `.doc` `.docx` `.epub` `.epub+zip` `.odt` `.pdf` `.ppt` `.pptx` `.tsv` `.xlsx` `.xls`.
   */
  file: Blob | File;
};

export type UpdateDocumentRawParams = {
  /**
   * Document data in a text or JSON format.
   */
  data:
    | string
    | {
        [key: string]: unknown;
      };
};

export type UpdateInstructionParams = {
  /**
   * Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.
   */
  active: boolean;
};

export type ValidationError = {
  loc: Array<string | number>;
  msg: string;
  type: string;
};

export type CreateDocumentData = {
  body: CreateDocumentParams;
};

export type CreateDocumentResponse = Document;

export type CreateDocumentError = ErrorMessage | HTTPValidationError;

export type ListDocumentsData = {
  headers?: {
    partition?: string | null;
  };
  query?: {
    /**
     * An opaque cursor for pagination
     */
    cursor?: string | null;
    /**
     * The metadata search filter on documents. Returns only documents which match the filter. The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.
     */
    filter?: string | null;
    /**
     * The number of items per page (must be greater than 0 and less than or equal to 100)
     */
    page_size?: number;
  };
};

export type ListDocumentsResponse = DocumentList;

export type ListDocumentsError = ErrorMessage | HTTPValidationError;

export type CreateDocumentRawData = {
  body: CreateDocumentRawParams;
};

export type CreateDocumentRawResponse = Document;

export type CreateDocumentRawError = ErrorMessage | HTTPValidationError;

export type CreateDocumentFromUrlData = {
  body: CreateDocumentFromUrlParams;
};

export type CreateDocumentFromUrlResponse = Document;

export type CreateDocumentFromUrlError = ErrorMessage | HTTPValidationError;

export type GetDocumentData = {
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type GetDocumentResponse = DocumentGet;

export type GetDocumentError = ErrorMessage | HTTPValidationError;

export type DeleteDocumentData = {
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type DeleteDocumentResponse = DocumentDelete;

export type DeleteDocumentError = ErrorMessage | HTTPValidationError;

export type UpdateDocumentFileData = {
  body: UpdateDocumentFileParams;
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type UpdateDocumentFileResponse = DocumentFileUpdate;

export type UpdateDocumentFileError = ErrorMessage | HTTPValidationError;

export type UpdateDocumentRawData = {
  body: UpdateDocumentRawParams;
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type UpdateDocumentRawResponse = DocumentRawUpdate;

export type UpdateDocumentRawError = ErrorMessage | HTTPValidationError;

export type PatchDocumentMetadataData = {
  body: PatchDocumentMetadataParams;
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type PatchDocumentMetadataResponse = DocumentMetadataUpdate;

export type PatchDocumentMetadataError = ErrorMessage | HTTPValidationError;

export type RetrieveData = {
  body: RetrieveParams;
};

export type RetrieveResponse = Retrieval;

export type RetrieveError = ErrorMessage | HTTPValidationError;

export type GetDocumentSummaryData = {
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
};

export type GetDocumentSummaryResponse = DocumentSummary;

export type GetDocumentSummaryError = ErrorMessage | HTTPValidationError;

export type ListInstructionsResponse = Array<Instruction>;

export type ListInstructionsError = ErrorMessage;

export type CreateInstructionData = {
  body: CreateInstructionParams;
};

export type CreateInstructionResponse = Instruction;

export type CreateInstructionError = ErrorMessage | HTTPValidationError;

export type UpdateInstructionData = {
  body: UpdateInstructionParams;
  path: {
    /**
     * The ID of the instruction.
     */
    instruction_id: string;
  };
};

export type UpdateInstructionResponse = Instruction;

export type UpdateInstructionError = ErrorMessage | HTTPValidationError;

export type ListEntitiesByInstructionData = {
  path: {
    /**
     * The ID of the instruction.
     */
    instruction_id: string;
  };
  query?: {
    /**
     * An opaque cursor for pagination
     */
    cursor?: string | null;
    /**
     * The number of items per page (must be greater than 0 and less than or equal to 100)
     */
    page_size?: number;
  };
};

export type ListEntitiesByInstructionResponse = EntityList;

export type ListEntitiesByInstructionError = ErrorMessage | HTTPValidationError;

export type ListEntitiesByDocumentData = {
  path: {
    /**
     * The id of the document.
     */
    document_id: string;
  };
  query?: {
    /**
     * An opaque cursor for pagination
     */
    cursor?: string | null;
    /**
     * The number of items per page (must be greater than 0 and less than or equal to 100)
     */
    page_size?: number;
  };
};

export type ListEntitiesByDocumentResponse = EntityList;

export type ListEntitiesByDocumentError = ErrorMessage | HTTPValidationError;

export type ListConnectionsConnectionsGetData = {
  query?: {
    /**
     * An opaque cursor for pagination
     */
    cursor?: string | null;
    /**
     * The number of items per page (must be greater than 0 and less than or equal to 100)
     */
    page_size?: number;
  };
};

export type ListConnectionsConnectionsGetResponse = ConnectionList;

export type ListConnectionsConnectionsGetError = ErrorMessage | HTTPValidationError;

export type SetConnectionEnabledConnectionsConnectionIdEnabledPutData = {
  body: SetConnectionEnabledPayload;
  path: {
    connection_id: string;
  };
};

export type SetConnectionEnabledConnectionsConnectionIdEnabledPutResponse = Connection;

export type SetConnectionEnabledConnectionsConnectionIdEnabledPutError = ErrorMessage | HTTPValidationError;

export type UpdateConnectionConnectionsConnectionIdPutData = {
  body: ConnectionBase;
  path: {
    connection_id: string;
  };
};

export type UpdateConnectionConnectionsConnectionIdPutResponse = Connection;

export type UpdateConnectionConnectionsConnectionIdPutError = ErrorMessage | HTTPValidationError;

export type GetConnectionStatsConnectionsConnectionIdStatsGetData = {
  path: {
    connection_id: string;
  };
};

export type GetConnectionStatsConnectionsConnectionIdStatsGetResponse = ConnectionStats;

export type GetConnectionStatsConnectionsConnectionIdStatsGetError = ErrorMessage | HTTPValidationError;

export type DeleteConnectionConnectionsConnectionIdDeletePostData = {
  body: DeleteConnectionPayload;
  path: {
    connection_id: string;
  };
};

export type DeleteConnectionConnectionsConnectionIdDeletePostResponse = {
  [key: string]: string;
};

export type DeleteConnectionConnectionsConnectionIdDeletePostError = ErrorMessage | HTTPValidationError;
