// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  CreateDocumentData,
  CreateDocumentError,
  CreateDocumentResponse,
  ListDocumentsData,
  ListDocumentsError,
  ListDocumentsResponse,
  CreateDocumentRawData,
  CreateDocumentRawError,
  CreateDocumentRawResponse,
  CreateDocumentFromUrlData,
  CreateDocumentFromUrlError,
  CreateDocumentFromUrlResponse,
  GetDocumentData,
  GetDocumentError,
  GetDocumentResponse,
  DeleteDocumentData,
  DeleteDocumentError,
  DeleteDocumentResponse,
  UpdateDocumentFileData,
  UpdateDocumentFileError,
  UpdateDocumentFileResponse,
  UpdateDocumentRawData,
  UpdateDocumentRawError,
  UpdateDocumentRawResponse,
  PatchDocumentMetadataData,
  PatchDocumentMetadataError,
  PatchDocumentMetadataResponse,
  RetrieveData,
  RetrieveError,
  RetrieveResponse,
  GetDocumentSummaryData,
  GetDocumentSummaryError,
  GetDocumentSummaryResponse,
  ListInstructionsError,
  ListInstructionsResponse,
  CreateInstructionData,
  CreateInstructionError,
  CreateInstructionResponse,
  UpdateInstructionData,
  UpdateInstructionError,
  UpdateInstructionResponse,
  ListEntitiesByInstructionData,
  ListEntitiesByInstructionError,
  ListEntitiesByInstructionResponse,
  ListEntitiesByDocumentData,
  ListEntitiesByDocumentError,
  ListEntitiesByDocumentResponse,
  ListConnectionsConnectionsGetData,
  ListConnectionsConnectionsGetError,
  ListConnectionsConnectionsGetResponse,
  SetConnectionEnabledConnectionsConnectionIdEnabledPutData,
  SetConnectionEnabledConnectionsConnectionIdEnabledPutError,
  SetConnectionEnabledConnectionsConnectionIdEnabledPutResponse,
  UpdateConnectionConnectionsConnectionIdPutData,
  UpdateConnectionConnectionsConnectionIdPutError,
  UpdateConnectionConnectionsConnectionIdPutResponse,
  GetConnectionStatsConnectionsConnectionIdStatsGetData,
  GetConnectionStatsConnectionsConnectionIdStatsGetError,
  GetConnectionStatsConnectionsConnectionIdStatsGetResponse,
  DeleteConnectionConnectionsConnectionIdDeletePostData,
  DeleteConnectionConnectionsConnectionIdDeletePostError,
  DeleteConnectionConnectionsConnectionIdDeletePostResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Create Document
 * On ingest, the document goes through a series of steps before it is ready for retrieval. Each step is reflected in the status of the document which can be one of [`pending`, `partitioning`, `partitioned`, `refined`, `chunked`, `indexed`, `summary_indexed`, `ready`, `failed`]. The document is available for retrieval once it is in ready state. The summary index step can take a few seconds. You can optionally use the document for retrieval once it is in `indexed` state. However the summary will only be available once the state has changed to `summary_indexed` or `ready`.
 */
export const createDocument = <ThrowOnError extends boolean = false>(
  options: Options<CreateDocumentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDocumentResponse, CreateDocumentError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/documents',
  });
};

/**
 * List Documents
 * List all documents sorted by created_at in descending order. Results are paginated with a max limit of 100. When more documents are available, a `cursor` will be provided. Use the `cursor` parameter to retrieve the subsequent page.
 */
export const listDocuments = <ThrowOnError extends boolean = false>(
  options?: Options<ListDocumentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDocumentsResponse, ListDocumentsError, ThrowOnError>({
    ...options,
    url: '/documents',
  });
};

/**
 * Create Document Raw
 * Ingest a document as raw text. On ingest, the document goes through a series of steps before it is ready for retrieval. Each step is reflected in the status of the document which can be one of [`pending`, `partitioning`, `partitioned`, `refined`, `chunked`, `indexed`, `summary_indexed`, `ready`, `failed`]. The document is available for retrieval once it is in ready state. The summary index step can take a few seconds. You can optionally use the document for retrieval once it is in `indexed` state. However the summary will only be available once the state has changed to `summary_indexed` or `ready`.
 */
export const createDocumentRaw = <ThrowOnError extends boolean = false>(
  options: Options<CreateDocumentRawData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDocumentRawResponse, CreateDocumentRawError, ThrowOnError>({
    ...options,
    url: '/documents/raw',
  });
};

/**
 * Create Document From Url
 */
export const createDocumentFromUrl = <ThrowOnError extends boolean = false>(
  options: Options<CreateDocumentFromUrlData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDocumentFromUrlResponse, CreateDocumentFromUrlError, ThrowOnError>({
    ...options,
    url: '/documents/url',
  });
};

/**
 * Get Document
 */
export const getDocument = <ThrowOnError extends boolean = false>(options: Options<GetDocumentData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDocumentResponse, GetDocumentError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}',
  });
};

/**
 * Delete Document
 */
export const deleteDocument = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDocumentData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDocumentResponse, DeleteDocumentError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}',
  });
};

/**
 * Update Document File
 */
export const updateDocumentFile = <ThrowOnError extends boolean = false>(
  options: Options<UpdateDocumentFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDocumentFileResponse, UpdateDocumentFileError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/documents/{document_id}/file',
  });
};

/**
 * Update Document Raw
 */
export const updateDocumentRaw = <ThrowOnError extends boolean = false>(
  options: Options<UpdateDocumentRawData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDocumentRawResponse, UpdateDocumentRawError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}/raw',
  });
};

/**
 * Patch Document Metadata
 */
export const patchDocumentMetadata = <ThrowOnError extends boolean = false>(
  options: Options<PatchDocumentMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchDocumentMetadataResponse, PatchDocumentMetadataError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}/metadata',
  });
};

/**
 * Retrieve
 */
export const retrieve = <ThrowOnError extends boolean = false>(options: Options<RetrieveData, ThrowOnError>) => {
  return (options?.client ?? client).post<RetrieveResponse, RetrieveError, ThrowOnError>({
    ...options,
    url: '/retrievals',
  });
};

/**
 * Get Document Summary
 * Get a LLM generated summary of the document. The summary is created when the document is first created or updated. Documents of types ['xls', 'xlsx', 'csv', 'json'] are not supported for summarization. Documents greater than 1M in token length are not supported. This feature is in beta and may change in the future.
 */
export const getDocumentSummary = <ThrowOnError extends boolean = false>(
  options: Options<GetDocumentSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDocumentSummaryResponse, GetDocumentSummaryError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}/summary',
  });
};

/**
 * List Instructions
 * List all instructions.
 */
export const listInstructions = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListInstructionsResponse, ListInstructionsError, ThrowOnError>({
    ...options,
    url: '/instructions',
  });
};

/**
 * Create Instruction
 * Create a new instruction. Instructions are applied to documents as they are created or updated. The results of the instruction are stored as structured data in the schema defined by the `entity_schema` parameter. The `prompt` parameter is a natural language instruction which will be applied to documents. This feature is in beta and may change in the future.
 */
export const createInstruction = <ThrowOnError extends boolean = false>(
  options: Options<CreateInstructionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateInstructionResponse, CreateInstructionError, ThrowOnError>({
    ...options,
    url: '/instructions',
  });
};

/**
 * Update Instruction
 */
export const updateInstruction = <ThrowOnError extends boolean = false>(
  options: Options<UpdateInstructionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateInstructionResponse, UpdateInstructionError, ThrowOnError>({
    ...options,
    url: '/instructions/{instruction_id}',
  });
};

/**
 * Get Instruction Extracted Entities
 */
export const listEntitiesByInstruction = <ThrowOnError extends boolean = false>(
  options: Options<ListEntitiesByInstructionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListEntitiesByInstructionResponse,
    ListEntitiesByInstructionError,
    ThrowOnError
  >({
    ...options,
    url: '/instructions/{instruction_id}/entities',
  });
};

/**
 * Get Document Extracted Entities
 */
export const listEntitiesByDocument = <ThrowOnError extends boolean = false>(
  options: Options<ListEntitiesByDocumentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListEntitiesByDocumentResponse, ListEntitiesByDocumentError, ThrowOnError>({
    ...options,
    url: '/documents/{document_id}/entities',
  });
};

/**
 * List Connections
 * List all connections sorted by created_at in descending order. Results are paginated with a max limit of 100. When more documents are available, a `cursor` will be provided. Use the `cursor` parameter to retrieve the subsequent page.
 */
export const listConnectionsConnectionsGet = <ThrowOnError extends boolean = false>(
  options?: Options<ListConnectionsConnectionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListConnectionsConnectionsGetResponse,
    ListConnectionsConnectionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/connections',
  });
};

/**
 * Set Connection Enabled
 * Enable or disable the connection. A disabled connection won't sync.
 */
export const setConnectionEnabledConnectionsConnectionIdEnabledPut = <ThrowOnError extends boolean = false>(
  options: Options<SetConnectionEnabledConnectionsConnectionIdEnabledPutData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SetConnectionEnabledConnectionsConnectionIdEnabledPutResponse,
    SetConnectionEnabledConnectionsConnectionIdEnabledPutError,
    ThrowOnError
  >({
    ...options,
    url: '/connections/{connection_id}/enabled',
  });
};

/**
 * Update Connection
 * Updates a connections metadata or mode. These changes will be seen after the next sync.
 */
export const updateConnectionConnectionsConnectionIdPut = <ThrowOnError extends boolean = false>(
  options: Options<UpdateConnectionConnectionsConnectionIdPutData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    UpdateConnectionConnectionsConnectionIdPutResponse,
    UpdateConnectionConnectionsConnectionIdPutError,
    ThrowOnError
  >({
    ...options,
    url: '/connections/{connection_id}',
  });
};

/**
 * Get Connection Stats
 * Lists connection stats: total documents synced.
 */
export const getConnectionStatsConnectionsConnectionIdStatsGet = <ThrowOnError extends boolean = false>(
  options: Options<GetConnectionStatsConnectionsConnectionIdStatsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetConnectionStatsConnectionsConnectionIdStatsGetResponse,
    GetConnectionStatsConnectionsConnectionIdStatsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/connections/{connection_id}/stats',
  });
};

/**
 * Delete Connection
 * Schedules a connection to be deleted. You can choose to keep the files from the connection or delete them all. If you keep the files, they will no longer be associated to the connection. Deleting can take some time, so you will still see files for a bit after this is called.
 */
export const deleteConnectionConnectionsConnectionIdDeletePost = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConnectionConnectionsConnectionIdDeletePostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DeleteConnectionConnectionsConnectionIdDeletePostResponse,
    DeleteConnectionConnectionsConnectionIdDeletePostError,
    ThrowOnError
  >({
    ...options,
    url: '/connections/{connection_id}/delete',
  });
};
