// This file is auto-generated by @hey-api/openapi-ts

export const Body_CreateDocumentSchema = {
  properties: {
    mode: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Mode',
      description:
        "Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.",
      default: 'fast',
    },
    metadata: {
      type: 'string',
      title: 'Metadata',
      description:
        'Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.',
      default: '{}',
    },
    file: {
      type: 'string',
      format: 'binary',
      title: 'File',
      description: `The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: \`.eml\` \`.html\` \`.json\` \`.md\` \`.msg\` \`.rst\` \`.rtf\` \`.txt\` \`.xml\`
Images: \`.png\` \`.webp\` \`.jpg\` \`.jpeg\` \`.tiff\` \`.bmp\` \`.heic\`
Documents: \`.csv\` \`.doc\` \`.docx\` \`.epub\` \`.epub+zip\` \`.odt\` \`.pdf\` \`.ppt\` \`.pptx\` \`.tsv\` \`.xlsx\` \`.xls\`.`,
    },
    external_id: {
      type: 'string',
      title: 'External Id',
      description:
        'An optional identifier for the document. A common value might be an id in an external system or the URL where the source file may be found.',
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.',
    },
  },
  type: 'object',
  required: ['file'],
  title: 'Body_CreateDocument',
} as const;

export const Body_UpdateDocumentFileSchema = {
  properties: {
    mode: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Mode',
      description:
        "Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.",
      default: 'fast',
    },
    file: {
      type: 'string',
      format: 'binary',
      title: 'File',
      description: `The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: \`.eml\` \`.html\` \`.json\` \`.md\` \`.msg\` \`.rst\` \`.rtf\` \`.txt\` \`.xml\`
Images: \`.png\` \`.webp\` \`.jpg\` \`.jpeg\` \`.tiff\` \`.bmp\` \`.heic\`
Documents: \`.csv\` \`.doc\` \`.docx\` \`.epub\` \`.epub+zip\` \`.odt\` \`.pdf\` \`.ppt\` \`.pptx\` \`.tsv\` \`.xlsx\` \`.xls\`.`,
    },
  },
  type: 'object',
  required: ['file'],
  title: 'Body_UpdateDocumentFile',
} as const;

export const ConnectionSchema = {
  properties: {
    id: {
      type: 'string',
      format: 'uuid',
      title: 'Id',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      title: 'Created At',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      title: 'Updated At',
    },
    metadata: {
      type: 'object',
      title: 'Metadata',
    },
    type: {
      type: 'string',
      title: 'Type',
    },
    name: {
      type: 'string',
      title: 'Name',
    },
    enabled: {
      type: 'boolean',
      title: 'Enabled',
    },
    last_synced_at: {
      anyOf: [
        {
          type: 'string',
          format: 'date-time',
        },
        {
          type: 'null',
        },
      ],
      title: 'Last Synced At',
    },
    syncing: {
      anyOf: [
        {
          type: 'boolean',
        },
        {
          type: 'null',
        },
      ],
      title: 'Syncing',
    },
  },
  type: 'object',
  required: ['id', 'created_at', 'updated_at', 'metadata', 'type', 'name', 'enabled'],
  title: 'Connection',
} as const;

export const ConnectionBaseSchema = {
  properties: {
    partition_strategy: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Partition Strategy',
    },
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
      description:
        'Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.',
      default: {},
    },
  },
  type: 'object',
  required: ['partition_strategy'],
  title: 'ConnectionBase',
} as const;

export const ConnectionListSchema = {
  properties: {
    pagination: {
      $ref: '#/components/schemas/Pagination',
    },
    connections: {
      items: {
        $ref: '#/components/schemas/Connection',
      },
      type: 'array',
      title: 'Connections',
    },
  },
  type: 'object',
  required: ['pagination', 'connections'],
  title: 'ConnectionList',
} as const;

export const ConnectionStatsSchema = {
  properties: {
    document_count: {
      type: 'integer',
      title: 'Document Count',
    },
  },
  type: 'object',
  required: ['document_count'],
  title: 'ConnectionStats',
} as const;

export const ConnectionSyncFinishedWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['connection_sync_finished'],
      const: 'connection_sync_finished',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/ConnectionSyncFinishedWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'ConnectionSyncFinishedWebhook',
} as const;

export const ConnectionSyncFinishedWebhookPayloadSchema = {
  properties: {
    connection_id: {
      type: 'string',
      title: 'Connection Id',
    },
    sync_id: {
      type: 'string',
      title: 'Sync Id',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    connection_metadata: {
      type: 'object',
      title: 'Connection Metadata',
    },
  },
  type: 'object',
  required: ['connection_id', 'sync_id', 'partition', 'connection_metadata'],
  title: 'ConnectionSyncFinishedWebhookPayload',
} as const;

export const ConnectionSyncProgressWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['connection_sync_progress'],
      const: 'connection_sync_progress',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/ConnectionSyncProgressWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'ConnectionSyncProgressWebhook',
} as const;

export const ConnectionSyncProgressWebhookPayloadSchema = {
  properties: {
    connection_id: {
      type: 'string',
      title: 'Connection Id',
    },
    sync_id: {
      type: 'string',
      title: 'Sync Id',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    connection_metadata: {
      type: 'object',
      title: 'Connection Metadata',
    },
    create_count: {
      type: 'integer',
      title: 'Create Count',
    },
    created_count: {
      type: 'integer',
      title: 'Created Count',
    },
    update_content_count: {
      type: 'integer',
      title: 'Update Content Count',
    },
    updated_content_count: {
      type: 'integer',
      title: 'Updated Content Count',
    },
    update_metadata_count: {
      type: 'integer',
      title: 'Update Metadata Count',
    },
    updated_metadata_count: {
      type: 'integer',
      title: 'Updated Metadata Count',
    },
    delete_count: {
      type: 'integer',
      title: 'Delete Count',
    },
    deleted_count: {
      type: 'integer',
      title: 'Deleted Count',
    },
    errored_count: {
      type: 'integer',
      title: 'Errored Count',
    },
  },
  type: 'object',
  required: [
    'connection_id',
    'sync_id',
    'partition',
    'connection_metadata',
    'create_count',
    'created_count',
    'update_content_count',
    'updated_content_count',
    'update_metadata_count',
    'updated_metadata_count',
    'delete_count',
    'deleted_count',
    'errored_count',
  ],
  title: 'ConnectionSyncProgressWebhookPayload',
} as const;

export const ConnectionSyncStartedWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['connection_sync_started'],
      const: 'connection_sync_started',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/ConnectionSyncStartedWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'ConnectionSyncStartedWebhook',
} as const;

export const ConnectionSyncStartedWebhookPayloadSchema = {
  properties: {
    connection_id: {
      type: 'string',
      title: 'Connection Id',
    },
    sync_id: {
      type: 'string',
      title: 'Sync Id',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    connection_metadata: {
      type: 'object',
      title: 'Connection Metadata',
    },
    create_count: {
      type: 'integer',
      title: 'Create Count',
    },
    update_content_count: {
      type: 'integer',
      title: 'Update Content Count',
    },
    update_metadata_count: {
      type: 'integer',
      title: 'Update Metadata Count',
    },
    delete_count: {
      type: 'integer',
      title: 'Delete Count',
    },
  },
  type: 'object',
  required: [
    'connection_id',
    'sync_id',
    'partition',
    'connection_metadata',
    'create_count',
    'update_content_count',
    'update_metadata_count',
    'delete_count',
  ],
  title: 'ConnectionSyncStartedWebhookPayload',
} as const;

export const CreateDocumentFromUrlParamsSchema = {
  properties: {
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
      description:
        'Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.',
      default: {},
    },
    mode: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Mode',
      description:
        "Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.",
      default: 'fast',
    },
    name: {
      type: 'string',
      title: 'Name',
    },
    external_id: {
      type: 'string',
      title: 'External Id',
    },
    url: {
      type: 'string',
      title: 'Url',
      description: 'Url of the file to download. Must be publicly accessible and HTTP or HTTPS scheme',
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.',
      examples: [null],
    },
  },
  type: 'object',
  required: ['url'],
  title: 'CreateDocumentFromUrlParams',
} as const;

export const CreateDocumentRawParamsSchema = {
  properties: {
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
      description:
        'Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.',
      default: {},
    },
    name: {
      type: 'string',
      title: 'Name',
      description:
        'An optional name for the document. If set, the document will have this name. Otherwise it will default to the current timestamp.',
    },
    data: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'object',
        },
      ],
      minLength: 1,
      title: 'Data',
      description: 'Document data in a text or JSON format.',
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.',
      examples: [null],
    },
  },
  type: 'object',
  required: ['data'],
  title: 'CreateDocumentRawParams',
} as const;

export const CreateInstructionParamsSchema = {
  properties: {
    name: {
      type: 'string',
      title: 'Name',
      description: 'The name of the instruction. Must be unique.',
      examples: ['Find all pizzas'],
    },
    active: {
      type: 'boolean',
      title: 'Active',
      description:
        "Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.",
      default: true,
      examples: [true],
    },
    scope: {
      type: 'string',
      enum: ['document', 'chunk'],
      title: 'Scope',
      description:
        "The scope of the instruction. Determines whether the instruction is applied to the entire document or to each chunk of the document. Options are `'document'` or `'chunk'`. Generally `'document'` should be used when analyzing the full document is desired, such as when generating a summary or determining sentiment, and `'chunk'` should be used when a fine grained search over a document is desired.",
      default: 'chunk',
      examples: ['Find all pizzas described in the text.'],
    },
    prompt: {
      type: 'string',
      title: 'Prompt',
      description:
        'A natural language instruction which will be applied to documents as they are created and updated. The results of the `instruction_prompt` will be stored as an `entity` in the schema defined by the `entity_schema` parameter.',
      examples: ['Find all pizzas described in the text.'],
    },
    entity_schema: {
      $ref: '#/components/schemas/EntitySchema',
      description:
        'The JSON schema definition of the entity generated by an instruction. The schema must define an `object` at its root. If the instruction is expected to generate multiple items, the root object should have a key which defines an array of the expected items. An instruction which generates multiple emails may be expressed as `{"type": "object", "properties": {"emails": { "type": "array", "items": { "type": "string"}}}}`. Simple values may be expressed as an object with a single key. For example, a summary instruction may generate a single string value. The schema might be `{"type": "object", "properties": { "summary": { "type": "string"}}}`.',
      examples: [
        {
          additionalProperties: false,
          properties: {
            size: {
              enum: ['small', 'medium', 'large'],
              type: 'string',
            },
            crust: {
              enum: ['thin', 'thick', 'stuffed'],
              type: 'string',
            },
            sauce: {
              enum: ['tomato', 'alfredo', 'pesto'],
              type: 'string',
            },
            cheese: {
              enum: ['mozzarella', 'cheddar', 'parmesan', 'vegan'],
              type: 'string',
            },
            toppings: {
              items: {
                enum: [
                  'pepperoni',
                  'mushrooms',
                  'onions',
                  'sausage',
                  'bacon',
                  'extra cheese',
                  'black olives',
                  'green peppers',
                  'pineapple',
                  'spinach',
                ],
                type: 'string',
              },
              type: 'array',
              uniqueItems: true,
            },
            extraInstructions: {
              type: 'string',
            },
          },
          required: ['size', 'crust', 'sauce', 'cheese'],
          title: 'Pizza',
          type: 'object',
        },
      ],
      additional_properties: true,
    },
    filter: {
      type: 'object',
      title: 'Filter',
      description:
        'An optional metadata filter that is matched against document metadata during update and creation. The instruction will only be applied to documents with metadata matching the filter.  The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.',
      examples: [
        {
          toppings: {
            $in: ['pizza', 'mushrooms'],
          },
        },
      ],
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Instructions can be scoped to a partition. An instruction that defines a partition will only be executed for documents in that partition.',
      examples: [null],
    },
  },
  type: 'object',
  required: ['name', 'prompt', 'entity_schema'],
  title: 'CreateInstructionParams',
} as const;

export const DeleteConnectionPayloadSchema = {
  properties: {
    keep_files: {
      type: 'boolean',
      title: 'Keep Files',
    },
  },
  type: 'object',
  required: ['keep_files'],
  title: 'DeleteConnectionPayload',
} as const;

export const DocumentSchema = {
  properties: {
    id: {
      type: 'string',
      format: 'uuid',
      title: 'Id',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      title: 'Created At',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      title: 'Updated At',
    },
    status: {
      type: 'string',
      title: 'Status',
    },
    name: {
      type: 'string',
      title: 'Name',
    },
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    chunk_count: {
      anyOf: [
        {
          type: 'integer',
        },
        {
          type: 'null',
        },
      ],
      title: 'Chunk Count',
    },
    external_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'External Id',
    },
  },
  type: 'object',
  required: ['id', 'created_at', 'updated_at', 'status', 'name', 'metadata', 'partition'],
  title: 'Document',
} as const;

export const DocumentDeleteSchema = {
  properties: {
    status: {
      type: 'string',
      title: 'Status',
    },
  },
  type: 'object',
  required: ['status'],
  title: 'DocumentDelete',
} as const;

export const DocumentDeleteWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['document_deleted'],
      const: 'document_deleted',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/DocumentDeleteWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'DocumentDeleteWebhook',
} as const;

export const DocumentDeleteWebhookPayloadSchema = {
  properties: {
    document_id: {
      type: 'string',
      title: 'Document Id',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    metadata: {
      type: 'object',
      title: 'Metadata',
    },
    external_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'External Id',
    },
    sync_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'Sync Id',
    },
  },
  type: 'object',
  required: ['document_id', 'partition', 'metadata', 'external_id', 'sync_id'],
  title: 'DocumentDeleteWebhookPayload',
} as const;

export const DocumentFileUpdateSchema = {
  properties: {
    status: {
      type: 'string',
      title: 'Status',
    },
  },
  type: 'object',
  required: ['status'],
  title: 'DocumentFileUpdate',
} as const;

export const DocumentGetSchema = {
  properties: {
    id: {
      type: 'string',
      format: 'uuid',
      title: 'Id',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      title: 'Created At',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      title: 'Updated At',
    },
    status: {
      type: 'string',
      title: 'Status',
    },
    name: {
      type: 'string',
      title: 'Name',
    },
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    chunk_count: {
      anyOf: [
        {
          type: 'integer',
        },
        {
          type: 'null',
        },
      ],
      title: 'Chunk Count',
    },
    external_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'External Id',
    },
    errors: {
      items: {
        type: 'string',
      },
      type: 'array',
      title: 'Errors',
    },
  },
  type: 'object',
  required: ['id', 'created_at', 'updated_at', 'status', 'name', 'metadata', 'partition', 'errors'],
  title: 'DocumentGet',
} as const;

export const DocumentListSchema = {
  properties: {
    pagination: {
      $ref: '#/components/schemas/Pagination',
    },
    documents: {
      items: {
        $ref: '#/components/schemas/Document',
      },
      type: 'array',
      title: 'Documents',
    },
  },
  type: 'object',
  required: ['pagination', 'documents'],
  title: 'DocumentList',
} as const;

export const DocumentMetadataSchema = {
  properties: {},
  additionalProperties: true,
  type: 'object',
  title: 'DocumentMetadata',
} as const;

export const DocumentMetadataUpdateSchema = {
  properties: {
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
      description: 'The full document metadata inclusive of the update.',
      examples: [
        {
          editors: ['Alice', 'Bob'],
          title: 'declassified report',
          unchanged_key: 'unchanged_value',
          updated_at: 1714491736216,
        },
      ],
    },
  },
  type: 'object',
  required: ['metadata'],
  title: 'DocumentMetadataUpdate',
} as const;

export const DocumentRawUpdateSchema = {
  properties: {
    status: {
      type: 'string',
      title: 'Status',
    },
  },
  type: 'object',
  required: ['status'],
  title: 'DocumentRawUpdate',
} as const;

export const DocumentSummarySchema = {
  properties: {
    document_id: {
      type: 'string',
      title: 'Document Id',
    },
    summary: {
      type: 'string',
      title: 'Summary',
    },
  },
  type: 'object',
  required: ['document_id', 'summary'],
  title: 'DocumentSummary',
} as const;

export const DocumentUpdateWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['document_status_updated'],
      const: 'document_status_updated',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/DocumentUpdateWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'DocumentUpdateWebhook',
} as const;

export const DocumentUpdateWebhookPayloadSchema = {
  properties: {
    document_id: {
      type: 'string',
      title: 'Document Id',
    },
    status: {
      anyOf: [
        {
          type: 'string',
          enum: ['ready'],
          const: 'ready',
        },
        {
          type: 'string',
          enum: ['failed'],
          const: 'failed',
        },
      ],
      title: 'Status',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    metadata: {
      type: 'object',
      title: 'Metadata',
    },
    external_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'External Id',
    },
    sync_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'Sync Id',
    },
  },
  type: 'object',
  required: ['document_id', 'status', 'partition', 'metadata', 'external_id', 'sync_id'],
  title: 'DocumentUpdateWebhookPayload',
} as const;

export const EntitySchema = {
  properties: {
    id: {
      type: 'string',
      format: 'uuid',
      title: 'Id',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      title: 'Created At',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      title: 'Updated At',
    },
    instruction_id: {
      type: 'string',
      format: 'uuid',
      title: 'Instruction Id',
      description: 'The ID of the instruction which generated the entity.',
    },
    document_id: {
      type: 'string',
      format: 'uuid',
      title: 'Document Id',
      description: 'The ID of the document which the entity was produced from.',
    },
    data: {
      $ref: '#/components/schemas/EntityData',
      description: 'The entity data generated by the instruction.',
    },
  },
  type: 'object',
  required: ['id', 'created_at', 'updated_at', 'instruction_id', 'document_id', 'data'],
  title: 'Entity',
} as const;

export const EntityDataSchema = {
  properties: {},
  additionalProperties: true,
  type: 'object',
  title: 'EntityData',
} as const;

export const EntityExtractedWebhookSchema = {
  properties: {
    nonce: {
      type: 'string',
      title: 'Nonce',
    },
    type: {
      type: 'string',
      enum: ['entity_extracted'],
      const: 'entity_extracted',
      title: 'Type',
    },
    payload: {
      $ref: '#/components/schemas/EntityExtractedWebhookPayload',
    },
  },
  type: 'object',
  required: ['nonce', 'type', 'payload'],
  title: 'EntityExtractedWebhook',
} as const;

export const EntityExtractedWebhookPayloadSchema = {
  properties: {
    entity_id: {
      type: 'string',
      title: 'Entity Id',
    },
    document_id: {
      type: 'string',
      title: 'Document Id',
    },
    instruction_id: {
      type: 'string',
      title: 'Instruction Id',
    },
    document_metadata: {
      type: 'object',
      title: 'Document Metadata',
    },
    document_external_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'Document External Id',
    },
    partition: {
      type: 'string',
      title: 'Partition',
    },
    sync_id: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'Sync Id',
    },
    data: {
      type: 'object',
      title: 'Data',
    },
  },
  type: 'object',
  required: [
    'entity_id',
    'document_id',
    'instruction_id',
    'document_metadata',
    'document_external_id',
    'partition',
    'sync_id',
    'data',
  ],
  title: 'EntityExtractedWebhookPayload',
} as const;

export const EntityListSchema = {
  properties: {
    pagination: {
      $ref: '#/components/schemas/Pagination',
    },
    entities: {
      items: {
        $ref: '#/components/schemas/Entity',
      },
      type: 'array',
      title: 'Entities',
    },
  },
  type: 'object',
  required: ['pagination', 'entities'],
  title: 'EntityList',
} as const;

export const EntitySchemaSchema = {
  properties: {},
  additionalProperties: true,
  type: 'object',
  title: 'EntitySchema',
} as const;

export const ErrorMessageSchema = {
  properties: {
    detail: {
      type: 'string',
      title: 'Detail',
    },
  },
  type: 'object',
  required: ['detail'],
  title: 'ErrorMessage',
} as const;

export const HTTPValidationErrorSchema = {
  properties: {
    detail: {
      items: {
        $ref: '#/components/schemas/ValidationError',
      },
      type: 'array',
      title: 'Detail',
    },
  },
  type: 'object',
  title: 'HTTPValidationError',
} as const;

export const InstructionSchema = {
  properties: {
    id: {
      type: 'string',
      format: 'uuid',
      title: 'Id',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      title: 'Created At',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      title: 'Updated At',
    },
    name: {
      type: 'string',
      title: 'Name',
      description: 'The name of the instruction. Must be unique.',
      examples: ['Find all pizzas'],
    },
    active: {
      type: 'boolean',
      title: 'Active',
      description:
        "Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.",
      default: true,
      examples: [true],
    },
    scope: {
      type: 'string',
      enum: ['document', 'chunk'],
      title: 'Scope',
      description:
        "The scope of the instruction. Determines whether the instruction is applied to the entire document or to each chunk of the document. Options are `'document'` or `'chunk'`. Generally `'document'` should be used when analyzing the full document is desired, such as when generating a summary or determining sentiment, and `'chunk'` should be used when a fine grained search over a document is desired.",
      default: 'chunk',
      examples: ['Find all pizzas described in the text.'],
    },
    prompt: {
      type: 'string',
      title: 'Prompt',
      description:
        'A natural language instruction which will be applied to documents as they are created and updated. The results of the `instruction_prompt` will be stored as an `entity` in the schema defined by the `entity_schema` parameter.',
      examples: ['Find all pizzas described in the text.'],
    },
    entity_schema: {
      $ref: '#/components/schemas/EntitySchema',
      description:
        'The JSON schema definition of the entity generated by an instruction. The schema must define an `object` at its root. If the instruction is expected to generate multiple items, the root object should have a key which defines an array of the expected items. An instruction which generates multiple emails may be expressed as `{"type": "object", "properties": {"emails": { "type": "array", "items": { "type": "string"}}}}`. Simple values may be expressed as an object with a single key. For example, a summary instruction may generate a single string value. The schema might be `{"type": "object", "properties": { "summary": { "type": "string"}}}`.',
      examples: [
        {
          additionalProperties: false,
          properties: {
            size: {
              enum: ['small', 'medium', 'large'],
              type: 'string',
            },
            crust: {
              enum: ['thin', 'thick', 'stuffed'],
              type: 'string',
            },
            sauce: {
              enum: ['tomato', 'alfredo', 'pesto'],
              type: 'string',
            },
            cheese: {
              enum: ['mozzarella', 'cheddar', 'parmesan', 'vegan'],
              type: 'string',
            },
            toppings: {
              items: {
                enum: [
                  'pepperoni',
                  'mushrooms',
                  'onions',
                  'sausage',
                  'bacon',
                  'extra cheese',
                  'black olives',
                  'green peppers',
                  'pineapple',
                  'spinach',
                ],
                type: 'string',
              },
              type: 'array',
              uniqueItems: true,
            },
            extraInstructions: {
              type: 'string',
            },
          },
          required: ['size', 'crust', 'sauce', 'cheese'],
          title: 'Pizza',
          type: 'object',
        },
      ],
      additional_properties: true,
    },
    filter: {
      type: 'object',
      title: 'Filter',
      description:
        'An optional metadata filter that is matched against document metadata during update and creation. The instruction will only be applied to documents with metadata matching the filter.  The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.',
      examples: [
        {
          toppings: {
            $in: ['pizza', 'mushrooms'],
          },
        },
      ],
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Instructions can be scoped to a partition. An instruction that defines a partition will only be executed for documents in that partition.',
      examples: [null],
    },
  },
  type: 'object',
  required: ['id', 'created_at', 'updated_at', 'name', 'prompt', 'entity_schema'],
  title: 'Instruction',
} as const;

export const MetadataFilterSchema = {
  additionalProperties: true,
  type: 'object',
  title: 'MetadataFilter',
} as const;

export const PaginationSchema = {
  properties: {
    next_cursor: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'null',
        },
      ],
      title: 'Next Cursor',
    },
  },
  type: 'object',
  title: 'Pagination',
} as const;

export const PatchDocumentMetadataParamsSchema = {
  properties: {
    metadata: {
      additionalProperties: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
          {
            type: 'boolean',
          },
          {
            items: {
              type: 'string',
            },
            type: 'array',
          },
          {
            type: 'null',
          },
        ],
      },
      type: 'object',
      title: 'Metadata',
      description:
        "The metadata to update on the document. Performs a partial update of the document's metadata. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. Keys set to `null` are deleted. 1000 total values are allowed, inclusive of existing metadata. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`. If the document is managed by a connection, this operation will extend a metadata overlay which is applied to the document any time the connection syncs the document.",
      examples: [
        {
          classified: 'null (setting null deletes key from metadata)',
          editors: ['Alice', 'Bob'],
          title: 'declassified report',
        },
      ],
    },
  },
  type: 'object',
  required: ['metadata'],
  title: 'PatchDocumentMetadataParams',
} as const;

export const RetrievalSchema = {
  properties: {
    scored_chunks: {
      items: {
        $ref: '#/components/schemas/ScoredChunk',
      },
      type: 'array',
      title: 'Scored Chunks',
    },
  },
  type: 'object',
  required: ['scored_chunks'],
  title: 'Retrieval',
} as const;

export const RetrieveParamsSchema = {
  properties: {
    query: {
      type: 'string',
      title: 'Query',
      description: 'The query to search with when retrieving document chunks.',
      examples: ['What is the best pizza place in SF?'],
    },
    top_k: {
      type: 'integer',
      title: 'Top K',
      description: 'The maximum number of chunks to return. Defaults to 8.',
      default: 8,
      examples: [8],
    },
    filter: {
      $ref: '#/components/schemas/MetadataFilter',
      title: 'Filter',
      description:
        'The metadata search filter on documents. Returns chunks only from documents which match the filter. The following filter operators are supported: $eq - Equal to (number, string, boolean), $ne - Not equal to (number, string, boolean), $gt - Greater than (number), $gte - Greater than or equal to (number), $lt - Less than (number), $lte - Less than or equal to (number), $in - In array (string or number), $nin - Not in array (string or number). The operators can be combined with AND and OR. Read [Metadata & Filters guide](https://docs.ragie.ai/docs/metadata-filters) for more details and examples.',
      examples: [
        {
          department: {
            $in: ['sales', 'marketing'],
          },
        },
      ],
    },
    rerank: {
      type: 'boolean',
      title: 'Rerank',
      description:
        'Reranks the chunks for semantic relevancy post cosine similarity. Will be slower but returns a subset of highly relevant chunks. Best for reducing hallucinations and improving accuracy for LLM generation.',
      default: false,
      examples: [true],
    },
    max_chunks_per_document: {
      type: 'integer',
      title: 'Max Chunks Per Document',
      description:
        'Maximum number of chunks to retrieve per document. Use this to increase the number of documents the final chunks are retreived from. This feature is in beta and may change in the future.',
      examples: [0],
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'The partition to scope a retrieval to. If omitted, the retrieval will be scoped to the default partition, which includes any documents that have not been created in or moved to a partition.',
      examples: [null],
    },
  },
  type: 'object',
  required: ['query'],
  title: 'RetrieveParams',
} as const;

export const ScoredChunkSchema = {
  properties: {
    text: {
      type: 'string',
      title: 'Text',
    },
    score: {
      type: 'number',
      title: 'Score',
    },
    document_id: {
      type: 'string',
      title: 'Document Id',
    },
    document_name: {
      type: 'string',
      title: 'Document Name',
    },
    document_metadata: {
      $ref: '#/components/schemas/DocumentMetadata',
    },
  },
  type: 'object',
  required: ['text', 'score', 'document_id', 'document_name', 'document_metadata'],
  title: 'ScoredChunk',
} as const;

export const SetConnectionEnabledPayloadSchema = {
  properties: {
    enabled: {
      type: 'boolean',
      title: 'Enabled',
    },
  },
  type: 'object',
  required: ['enabled'],
  title: 'SetConnectionEnabledPayload',
} as const;

export const UpdateDocumentRawParamsSchema = {
  properties: {
    data: {
      anyOf: [
        {
          type: 'string',
        },
        {
          type: 'object',
        },
      ],
      minLength: 1,
      title: 'Data',
      description: 'Document data in a text or JSON format.',
    },
  },
  type: 'object',
  required: ['data'],
  title: 'UpdateDocumentRawParams',
} as const;

export const UpdateInstructionParamsSchema = {
  properties: {
    active: {
      type: 'boolean',
      title: 'Active',
      description:
        "Whether the instruction is active. Active instructions are applied to documents when they're created or when their file is updated.",
      examples: [true],
    },
  },
  type: 'object',
  required: ['active'],
  title: 'UpdateInstructionParams',
} as const;

export const ValidationErrorSchema = {
  properties: {
    loc: {
      items: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
        ],
      },
      type: 'array',
      title: 'Location',
    },
    msg: {
      type: 'string',
      title: 'Message',
    },
    type: {
      type: 'string',
      title: 'Error Type',
    },
  },
  type: 'object',
  required: ['loc', 'msg', 'type'],
  title: 'ValidationError',
} as const;

export const CreateDocumentParamsSchema = {
  type: 'object',
  title: 'CreateDocumentParams',
  properties: {
    mode: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Mode',
      description:
        "Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.",
      default: 'fast',
    },
    metadata: {
      type: 'object',
      title: 'Metadata',
      description:
        'Metadata for the document. Keys must be strings. Values may be strings, numbers, booleans, or lists of strings. Numbers may be integers or floating point and will be converted to 64 bit floating point. 1000 total values are allowed. Each item in an array counts towards the total. The following keys are reserved for internal use: `document_id`, `document_type`, `document_source`, `document_name`, `document_uploaded_at`.',
      default: '{}',
      additionalProperties: {
        oneOf: [
          {
            type: 'string',
          },
          {
            type: 'number',
          },
          {
            type: 'boolean',
          },
          {
            type: 'array',
            items: {
              type: 'string',
            },
          },
        ],
      },
    },
    file: {
      type: 'string',
      format: 'binary',
      title: 'File',
      description: `The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: \`.eml\` \`.html\` \`.json\` \`.md\` \`.msg\` \`.rst\` \`.rtf\` \`.txt\` \`.xml\`
Images: \`.png\` \`.webp\` \`.jpg\` \`.jpeg\` \`.tiff\` \`.bmp\` \`.heic\`
Documents: \`.csv\` \`.doc\` \`.docx\` \`.epub\` \`.epub+zip\` \`.odt\` \`.pdf\` \`.ppt\` \`.pptx\` \`.tsv\` \`.xlsx\` \`.xls\`.`,
    },
    external_id: {
      type: 'string',
      title: 'External Id',
      description:
        'An optional identifier for the document. A common value might be an id in an external system or the URL where the source file may be found.',
    },
    partition: {
      type: 'string',
      title: 'Partition',
      description:
        'An optional partition identifier. Documents can be scoped to a partition. Partitions must be lowercase alphanumeric and may only include the special characters `_` and `-`.  A partition is created any time a document is created or moved to a new partition.',
    },
  },
  required: ['file'],
} as const;

export const UpdateDocumentFileParamsSchema = {
  type: 'object',
  title: 'UpdateDocumentFileParams',
  properties: {
    mode: {
      type: 'string',
      enum: ['hi_res', 'fast'],
      title: 'Mode',
      description:
        "Partition strategy for the document. Options are `'hi_res'` or `'fast'`. Only applicable for rich documents such as word documents and PDFs. When set to `'hi_res'`, images and tables will be extracted from the document. `'fast'` will only extract text. `'fast'` may be up to 20x faster than `'hi_res'`.",
      default: 'fast',
    },
    file: {
      type: 'string',
      format: 'binary',
      title: 'File',
      description: `The binary file to upload, extract, and index for retrieval. The following file types are supported: Plain Text: \`.eml\` \`.html\` \`.json\` \`.md\` \`.msg\` \`.rst\` \`.rtf\` \`.txt\` \`.xml\`
Images: \`.png\` \`.webp\` \`.jpg\` \`.jpeg\` \`.tiff\` \`.bmp\` \`.heic\`
Documents: \`.csv\` \`.doc\` \`.docx\` \`.epub\` \`.epub+zip\` \`.odt\` \`.pdf\` \`.ppt\` \`.pptx\` \`.tsv\` \`.xlsx\` \`.xls\`.`,
    },
  },
  required: ['file'],
} as const;
