// Generated by ts-to-zod
import { z } from 'zod';

export const assistantToolsCodeSchema = z.object({
  type: z.literal('code_interpreter'),
});

export const assistantToolsFileSearchSchema = z.object({
  type: z.literal('file_search'),
  file_search: z
    .object({
      max_num_results: z.number().optional(),
    })
    .optional(),
});

export const openAiObjectSchema = z.literal('assistant');

export const responseFormatTextSchema = z.object({
  type: z.literal('text'),
});

export const responseFormatJsonObjectSchema = z.object({
  type: z.literal('json_object'),
});

export const assistantsNamedToolChoiceSchema = z.object({
  type: z.union([z.literal('function'), z.literal('code_interpreter'), z.literal('file_search')]),
  function: z
    .object({
      name: z.string(),
    })
    .optional(),
});

export const typeSchema = z.union([z.literal('function'), z.literal('code_interpreter'), z.literal('file_search')]);

export const doneEventSchema = z.object({
  event: z.literal('done'),
  data: z.literal('[DONE]'),
});

export const type2Schema = z.literal('code_interpreter');

export const type3Schema = z.literal('file_search');

export const assistantToolsFileSearchTypeOnlySchema = z.object({
  type: z.literal('file_search'),
});

export const type4Schema = z.literal('function');

export const auditLogEventTypeSchema = z.union([
  z.literal('api_key.created'),
  z.literal('api_key.updated'),
  z.literal('api_key.deleted'),
  z.literal('invite.sent'),
  z.literal('invite.accepted'),
  z.literal('invite.deleted'),
  z.literal('login.succeeded'),
  z.literal('login.failed'),
  z.literal('logout.succeeded'),
  z.literal('logout.failed'),
  z.literal('organization.updated'),
  z.literal('project.created'),
  z.literal('project.updated'),
  z.literal('project.archived'),
  z.literal('service_account.created'),
  z.literal('service_account.updated'),
  z.literal('service_account.deleted'),
  z.literal('user.added'),
  z.literal('user.updated'),
  z.literal('user.deleted'),
]);

export const type5Schema = z.union([z.literal('session'), z.literal('api_key')]);

export const auditLogActorUserSchema = z.object({
  id: z.string().optional(),
  email: z.string().optional(),
});

export const auditLogActorServiceAccountSchema = z.object({
  id: z.string().optional(),
});

export const type6Schema = z.union([z.literal('user'), z.literal('service_account')]);

export const auditLogActorSessionSchema = z.object({
  user: auditLogActorUserSchema.optional(),
  ip_address: z.string().optional(),
});

export const autoChunkingStrategyRequestParamSchema = z.object({
  type: z.literal('auto'),
});

export const type7Schema = z.literal('auto');

export const batchSchema = z.object({
  id: z.string(),
  object: z.literal('batch'),
  endpoint: z.string(),
  errors: z
    .object({
      object: z.string().optional(),
      data: z
        .array(
          z.object({
            code: z.string().optional(),
            message: z.string().optional(),
            param: z.string().optional().nullable(),
            line: z.number().optional().nullable(),
          }),
        )
        .optional(),
    })
    .optional(),
  input_file_id: z.string(),
  completion_window: z.string(),
  status: z.union([
    z.literal('validating'),
    z.literal('failed'),
    z.literal('in_progress'),
    z.literal('finalizing'),
    z.literal('completed'),
    z.literal('expired'),
    z.literal('cancelling'),
    z.literal('cancelled'),
  ]),
  output_file_id: z.string().optional(),
  error_file_id: z.string().optional(),
  created_at: z.number(),
  in_progress_at: z.number().optional(),
  expires_at: z.number().optional(),
  finalizing_at: z.number().optional(),
  completed_at: z.number().optional(),
  failed_at: z.number().optional(),
  expired_at: z.number().optional(),
  cancelling_at: z.number().optional(),
  cancelled_at: z.number().optional(),
  request_counts: z
    .object({
      total: z.number(),
      completed: z.number(),
      failed: z.number(),
    })
    .optional(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const object2Schema = z.literal('batch');

export const statusSchema = z.union([
  z.literal('validating'),
  z.literal('failed'),
  z.literal('in_progress'),
  z.literal('finalizing'),
  z.literal('completed'),
  z.literal('expired'),
  z.literal('cancelling'),
  z.literal('cancelled'),
]);

export const batchRequestInputSchema = z.object({
  custom_id: z.string().optional(),
  method: z.literal('POST').optional(),
  url: z.string().optional(),
});

export const methodSchema = z.literal('POST');

export const batchRequestOutputSchema = z.object({
  id: z.string().optional(),
  custom_id: z.string().optional(),
  response: z
    .object({
      status_code: z.number().optional(),
      request_id: z.string().optional(),
      body: z.record(z.unknown()).optional(),
    })
    .optional()
    .nullable(),
  error: z
    .object({
      code: z.string().optional(),
      message: z.string().optional(),
    })
    .optional()
    .nullable(),
});

export const cancelUploadRequestSchema = z.record(z.unknown());

export const chatCompletionFunctionCallOptionSchema = z.object({
  name: z.string(),
});

export const functionParametersSchema = z.record(z.unknown());

export const chatCompletionMessageToolCallSchema = z.object({
  id: z.string(),
  type: z.literal('function'),
  function: z.object({
    name: z.string(),
    arguments: z.string(),
  }),
});

export const chatCompletionMessageToolCallChunkSchema = z.object({
  index: z.number(),
  id: z.string().optional(),
  type: z.literal('function').optional(),
  function: z
    .object({
      name: z.string().optional(),
      arguments: z.string().optional(),
    })
    .optional(),
});

export const chatCompletionMessageToolCallsSchema = z.array(chatCompletionMessageToolCallSchema);

export const chatCompletionNamedToolChoiceSchema = z.object({
  type: z.literal('function'),
  function: z.object({
    name: z.string(),
  }),
});

export const roleSchema = z.literal('assistant');

export const chatCompletionRequestMessageContentPartTextSchema = z.object({
  type: z.literal('text'),
  text: z.string(),
});

export const chatCompletionRequestMessageContentPartRefusalSchema = z.object({
  type: z.literal('refusal'),
  refusal: z.string(),
});

export const chatCompletionRequestFunctionMessageSchema = z.object({
  role: z.literal('function'),
  content: z.string().nullable(),
  name: z.string(),
});

export const role2Schema = z.literal('function');

export const chatCompletionRequestMessageContentPartImageSchema = z.object({
  type: z.literal('image_url'),
  image_url: z.object({
    url: z.string(),
    detail: z.union([z.literal('auto'), z.literal('low'), z.literal('high')]).optional(),
  }),
});

export const type8Schema = z.literal('image_url');

export const detailSchema = z.union([z.literal('auto'), z.literal('low'), z.literal('high')]);

export const type9Schema = z.literal('refusal');

export const type10Schema = z.literal('text');

export const chatCompletionRequestSystemMessageContentPartSchema = chatCompletionRequestMessageContentPartTextSchema;

export const role3Schema = z.literal('system');

export const chatCompletionRequestToolMessageContentPartSchema = chatCompletionRequestMessageContentPartTextSchema;

export const role4Schema = z.literal('tool');

export const chatCompletionRequestUserMessageContentPartSchema = z.union([
  chatCompletionRequestMessageContentPartTextSchema,
  chatCompletionRequestMessageContentPartImageSchema,
]);

export const role5Schema = z.literal('user');

export const chatCompletionResponseMessageSchema = z.object({
  content: z.string().nullable(),
  refusal: z.string().nullable(),
  tool_calls: chatCompletionMessageToolCallsSchema.optional(),
  role: z.literal('assistant'),
  function_call: z
    .object({
      arguments: z.string(),
      name: z.string(),
    })
    .optional(),
});

export const chatCompletionRoleSchema = z.union([
  z.literal('system'),
  z.literal('user'),
  z.literal('assistant'),
  z.literal('tool'),
  z.literal('function'),
]);

export const chatCompletionStreamOptionsSchema = z
  .object({
    include_usage: z.boolean().optional(),
  })
  .nullable();

export const chatCompletionStreamResponseDeltaSchema = z.object({
  content: z.string().optional().nullable(),
  function_call: z
    .object({
      arguments: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  tool_calls: z.array(chatCompletionMessageToolCallChunkSchema).optional(),
  role: z.union([z.literal('system'), z.literal('user'), z.literal('assistant'), z.literal('tool')]).optional(),
  refusal: z.string().optional().nullable(),
});

export const role6Schema = z.union([z.literal('system'), z.literal('user'), z.literal('assistant'), z.literal('tool')]);

export const chatCompletionTokenLogprobSchema = z.object({
  token: z.string(),
  logprob: z.number(),
  bytes: z.array(z.number()).nullable(),
  top_logprobs: z.array(
    z.object({
      token: z.string(),
      logprob: z.number(),
      bytes: z.array(z.number()).nullable(),
    }),
  ),
});

export const functionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: functionParametersSchema.optional(),
  strict: z.boolean().optional().nullable(),
});

export const chatCompletionToolChoiceOptionSchema = z.union([
  z.literal('none'),
  z.literal('auto'),
  z.literal('required'),
  chatCompletionNamedToolChoiceSchema,
]);

export const completeUploadRequestSchema = z.object({
  part_ids: z.array(z.string()),
  md5: z.string().optional(),
});

export const completionUsageSchema = z.object({
  completion_tokens: z.number(),
  prompt_tokens: z.number(),
  total_tokens: z.number(),
});

export const assistantToolsFunctionSchema = z.object({
  type: z.literal('function'),
  function: functionObjectSchema,
});

export const createChatCompletionFunctionResponseSchema = z.object({
  id: z.string(),
  choices: z.array(
    z.object({
      finish_reason: z.union([
        z.literal('stop'),
        z.literal('length'),
        z.literal('function_call'),
        z.literal('content_filter'),
      ]),
      index: z.number(),
      message: chatCompletionResponseMessageSchema,
    }),
  ),
  created: z.number(),
  model: z.string(),
  system_fingerprint: z.string().optional(),
  object: z.literal('chat.completion'),
  usage: completionUsageSchema.optional(),
});

export const object3Schema = z.literal('chat.completion');

export const createChatCompletionImageResponseSchema = z.record(z.unknown());

export const chatCompletionToolSchema = z.object({
  type: z.literal('function'),
  function: functionObjectSchema,
});

export const parallelToolCallsSchema = z.boolean().nullable();

export const chatCompletionFunctionsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: functionParametersSchema.optional(),
});

export const serviceTierSchema = z.union([z.literal('auto'), z.literal('default')]);

export const createChatCompletionResponseSchema = z.object({
  id: z.string(),
  choices: z.array(
    z.object({
      finish_reason: z.union([
        z.literal('stop'),
        z.literal('length'),
        z.literal('tool_calls'),
        z.literal('content_filter'),
        z.literal('function_call'),
      ]),
      index: z.number(),
      message: chatCompletionResponseMessageSchema,
      logprobs: z
        .object({
          content: z.array(chatCompletionTokenLogprobSchema).nullable(),
          refusal: z.array(chatCompletionTokenLogprobSchema).nullable(),
        })
        .optional()
        .nullable(),
    }),
  ),
  created: z.number(),
  model: z.string(),
  service_tier: z
    .union([z.literal('scale'), z.literal('default')])
    .optional()
    .nullable(),
  system_fingerprint: z.string().optional(),
  object: z.literal('chat.completion'),
  usage: completionUsageSchema.optional(),
});

export const serviceTier2Schema = z.union([z.literal('scale'), z.literal('default')]);

export const createChatCompletionStreamResponseSchema = z.object({
  id: z.string(),
  choices: z.array(
    z.object({
      delta: chatCompletionStreamResponseDeltaSchema,
      logprobs: z
        .object({
          content: z.array(chatCompletionTokenLogprobSchema).nullable(),
          refusal: z.array(chatCompletionTokenLogprobSchema).nullable(),
        })
        .optional()
        .nullable(),
      finish_reason: z
        .union([
          z.literal('stop'),
          z.literal('length'),
          z.literal('tool_calls'),
          z.literal('content_filter'),
          z.literal('function_call'),
        ])
        .nullable(),
      index: z.number(),
    }),
  ),
  created: z.number(),
  model: z.string(),
  service_tier: z
    .union([z.literal('scale'), z.literal('default')])
    .optional()
    .nullable(),
  system_fingerprint: z.string().optional(),
  object: z.literal('chat.completion.chunk'),
  usage: z
    .object({
      completion_tokens: z.number(),
      prompt_tokens: z.number(),
      total_tokens: z.number(),
    })
    .optional(),
});

export const object4Schema = z.literal('chat.completion.chunk');

export const createCompletionRequestSchema = z.object({
  model: z.union([z.string(), z.literal('gpt-3.5-turbo-instruct'), z.literal('davinci-002'), z.literal('babbage-002')]),
  prompt: z.union([z.string(), z.array(z.string()), z.array(z.number()), z.array(z.array(z.number()))]).nullable(),
  best_of: z.number().optional().nullable(),
  echo: z.boolean().optional().nullable(),
  frequency_penalty: z.number().optional().nullable(),
  logit_bias: z.record(z.number()).optional().nullable(),
  logprobs: z.number().optional().nullable(),
  max_tokens: z.number().optional().nullable(),
  n: z.number().optional().nullable(),
  presence_penalty: z.number().optional().nullable(),
  seed: z.number().optional().nullable(),
  stop: z
    .union([z.string(), z.array(z.string())])
    .optional()
    .nullable(),
  stream: z.boolean().optional().nullable(),
  stream_options: chatCompletionStreamOptionsSchema.optional(),
  suffix: z.string().optional().nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  user: z.string().optional(),
});

export const createCompletionResponseSchema = z.object({
  id: z.string(),
  choices: z.array(
    z.object({
      finish_reason: z.union([z.literal('stop'), z.literal('length'), z.literal('content_filter')]),
      index: z.number(),
      logprobs: z
        .object({
          text_offset: z.array(z.number()).optional(),
          token_logprobs: z.array(z.number()).optional(),
          tokens: z.array(z.string()).optional(),
          top_logprobs: z.array(z.record(z.number())).optional(),
        })
        .nullable(),
      text: z.string(),
    }),
  ),
  created: z.number(),
  model: z.string(),
  system_fingerprint: z.string().optional(),
  object: z.literal('text_completion'),
  usage: completionUsageSchema.optional(),
});

export const object5Schema = z.literal('text_completion');

export const createEmbeddingRequestSchema = z.object({
  input: z.union([z.string(), z.array(z.string()), z.array(z.number()), z.array(z.array(z.number()))]),
  model: z.union([
    z.string(),
    z.literal('text-embedding-ada-002'),
    z.literal('text-embedding-3-small'),
    z.literal('text-embedding-3-large'),
  ]),
  encoding_format: z.union([z.literal('float'), z.literal('base64')]).optional(),
  dimensions: z.number().optional().nullable(),
  user: z.string().optional(),
});

export const encodingFormatSchema = z.union([z.literal('float'), z.literal('base64')]);

export const embeddingSchema = z.object({
  index: z.number(),
  embedding: z.array(z.number()),
  object: z.literal('embedding'),
});

export const object6Schema = z.literal('list');

export const purposeSchema = z.union([
  z.literal('assistants'),
  z.literal('batch'),
  z.literal('fine-tune'),
  z.literal('vision'),
]);

export const createFineTuningJobRequestSchema = z.object({
  model: z.union([
    z.string(),
    z.literal('babbage-002'),
    z.literal('davinci-002'),
    z.literal('gpt-3.5-turbo'),
    z.literal('gpt-4o-mini'),
  ]),
  training_file: z.string(),
  hyperparameters: z
    .object({
      batch_size: z.union([z.literal('auto'), z.number()]).optional(),
      learning_rate_multiplier: z.union([z.literal('auto'), z.number()]).optional(),
      n_epochs: z.union([z.literal('auto'), z.number()]).optional(),
    })
    .optional(),
  suffix: z.string().optional().nullable(),
  validation_file: z.string().optional().nullable(),
  integrations: z
    .array(
      z.object({
        type: z.literal('wandb'),
        wandb: z.object({
          project: z.string(),
          name: z.string().optional().nullable(),
          entity: z.string().optional().nullable(),
          tags: z.array(z.string()).optional(),
        }),
      }),
    )
    .optional()
    .nullable(),
  seed: z.number().optional().nullable(),
});

export const sizeSchema = z.union([z.literal('256x256'), z.literal('512x512'), z.literal('1024x1024')]);

export const responseFormatSchema = z.union([z.literal('url'), z.literal('b64_json')]);

export const createImageRequestSchema = z.object({
  prompt: z.string(),
  model: z
    .union([z.string(), z.literal('dall-e-2'), z.literal('dall-e-3')])
    .optional()
    .nullable(),
  n: z.number().optional().nullable(),
  quality: z.union([z.literal('standard'), z.literal('hd')]).optional(),
  response_format: z
    .union([z.literal('url'), z.literal('b64_json')])
    .optional()
    .nullable(),
  size: z
    .union([
      z.literal('256x256'),
      z.literal('512x512'),
      z.literal('1024x1024'),
      z.literal('1792x1024'),
      z.literal('1024x1792'),
    ])
    .optional()
    .nullable(),
  style: z
    .union([z.literal('vivid'), z.literal('natural')])
    .optional()
    .nullable(),
  user: z.string().optional(),
});

export const qualitySchema = z.union([z.literal('standard'), z.literal('hd')]);

export const size2Schema = z.union([
  z.literal('256x256'),
  z.literal('512x512'),
  z.literal('1024x1024'),
  z.literal('1792x1024'),
  z.literal('1024x1792'),
]);

export const styleSchema = z.union([z.literal('vivid'), z.literal('natural')]);

export const messageContentImageFileObjectSchema = z.object({
  type: z.literal('image_file'),
  image_file: z.object({
    file_id: z.string(),
    detail: z.union([z.literal('auto'), z.literal('low'), z.literal('high')]).optional(),
  }),
});

export const messageContentImageUrlObjectSchema = z.object({
  type: z.literal('image_url'),
  image_url: z.object({
    url: z.string(),
    detail: z.union([z.literal('auto'), z.literal('low'), z.literal('high')]).optional(),
  }),
});

export const messageRequestContentTextObjectSchema = z.object({
  type: z.literal('text'),
  text: z.string(),
});

export const role7Schema = z.union([z.literal('user'), z.literal('assistant')]);

export const createModerationRequestSchema = z.object({
  input: z.union([z.string(), z.array(z.string())]),
  model: z.union([z.string(), z.literal('text-moderation-latest'), z.literal('text-moderation-stable')]).optional(),
});

export const createModerationResponseSchema = z.object({
  id: z.string(),
  model: z.string(),
  results: z.array(
    z.object({
      flagged: z.boolean(),
      categories: z.object({
        hate: z.boolean(),
        'hate/threatening': z.boolean(),
        harassment: z.boolean(),
        'harassment/threatening': z.boolean(),
        'self-harm': z.boolean(),
        'self-harm/intent': z.boolean(),
        'self-harm/instructions': z.boolean(),
        sexual: z.boolean(),
        'sexual/minors': z.boolean(),
        violence: z.boolean(),
        'violence/graphic': z.boolean(),
      }),
      category_scores: z.object({
        hate: z.number(),
        'hate/threatening': z.number(),
        harassment: z.number(),
        'harassment/threatening': z.number(),
        'self-harm': z.number(),
        'self-harm/intent': z.number(),
        'self-harm/instructions': z.number(),
        sexual: z.number(),
        'sexual/minors': z.number(),
        violence: z.number(),
        'violence/graphic': z.number(),
      }),
    }),
  ),
});

export const createMessageRequestSchema = z.object({
  role: z.union([z.literal('user'), z.literal('assistant')]),
  content: z.union([
    z.string(),
    z.array(
      z.union([
        messageContentImageFileObjectSchema,
        messageContentImageUrlObjectSchema,
        messageRequestContentTextObjectSchema,
      ]),
    ),
  ]),
  attachments: z
    .array(
      z.object({
        file_id: z.string().optional(),
        tools: z.array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchTypeOnlySchema])).optional(),
      }),
    )
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const truncationObjectSchema = z.object({
  type: z.union([z.literal('auto'), z.literal('last_messages')]),
  last_messages: z.number().optional().nullable(),
});

export const assistantsApiToolChoiceOptionSchema = z.union([
  z.literal('none'),
  z.literal('auto'),
  z.literal('required'),
  assistantsNamedToolChoiceSchema,
]);

export const createSpeechRequestSchema = z.object({
  model: z.union([z.string(), z.literal('tts-1'), z.literal('tts-1-hd')]),
  input: z.string(),
  voice: z.union([
    z.literal('alloy'),
    z.literal('echo'),
    z.literal('fable'),
    z.literal('onyx'),
    z.literal('nova'),
    z.literal('shimmer'),
  ]),
  response_format: z
    .union([
      z.literal('mp3'),
      z.literal('opus'),
      z.literal('aac'),
      z.literal('flac'),
      z.literal('wav'),
      z.literal('pcm'),
    ])
    .optional(),
  speed: z.number().optional(),
});

export const voiceSchema = z.union([
  z.literal('alloy'),
  z.literal('echo'),
  z.literal('fable'),
  z.literal('onyx'),
  z.literal('nova'),
  z.literal('shimmer'),
]);

export const responseFormat2Schema = z.union([
  z.literal('mp3'),
  z.literal('opus'),
  z.literal('aac'),
  z.literal('flac'),
  z.literal('wav'),
  z.literal('pcm'),
]);

export const createThreadRequestSchema = z.object({
  messages: z.array(createMessageRequestSchema).optional(),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .unknown()
        .and(
          z.object({
            vector_store_ids: z.array(z.string()).optional(),
            vector_stores: z
              .array(
                z.object({
                  file_ids: z.array(z.string()).optional(),
                  chunking_strategy: z
                    .union([
                      z.object({
                        type: z.literal('auto'),
                      }),
                      z.object({
                        type: z.literal('static'),
                        static: z.object({
                          max_chunk_size_tokens: z.number(),
                          chunk_overlap_tokens: z.number(),
                        }),
                      }),
                    ])
                    .optional(),
                  metadata: z.record(z.unknown()).optional(),
                }),
              )
              .optional(),
          }),
        )
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const responseFormat3Schema = z.union([
  z.literal('json'),
  z.literal('text'),
  z.literal('srt'),
  z.literal('verbose_json'),
  z.literal('vtt'),
]);

export const createTranscriptionResponseJsonSchema = z.object({
  text: z.string(),
});

export const transcriptionWordSchema = z.object({
  word: z.string(),
  start: z.number(),
  end: z.number(),
});

export const transcriptionSegmentSchema = z.object({
  id: z.number(),
  seek: z.number(),
  start: z.number(),
  end: z.number(),
  text: z.string(),
  tokens: z.array(z.number()),
  temperature: z.number(),
  avg_logprob: z.number(),
  compression_ratio: z.number(),
  no_speech_prob: z.number(),
});

export const createTranslationResponseJsonSchema = z.object({
  text: z.string(),
});

export const createTranslationResponseVerboseJsonSchema = z.object({
  language: z.string(),
  duration: z.string(),
  text: z.string(),
  segments: z.array(transcriptionSegmentSchema).optional(),
});

export const createUploadRequestSchema = z.object({
  filename: z.string(),
  purpose: z.union([z.literal('assistants'), z.literal('batch'), z.literal('fine-tune'), z.literal('vision')]),
  bytes: z.number(),
  mime_type: z.string(),
});

export const vectorStoreExpirationAfterSchema = z.object({
  anchor: z.literal('last_active_at'),
  days: z.number(),
});

export const defaultProjectErrorResponseSchema = z.object({
  code: z.number(),
  message: z.string(),
});

export const deleteAssistantResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.literal('assistant.deleted'),
});

export const object7Schema = z.literal('assistant.deleted');

export const deleteFileResponseSchema = z.object({
  id: z.string(),
  object: z.literal('file'),
  deleted: z.boolean(),
});

export const object8Schema = z.literal('file');

export const deleteMessageResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.literal('thread.message.deleted'),
});

export const object9Schema = z.literal('thread.message.deleted');

export const deleteModelResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.string(),
});

export const deleteThreadResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.literal('thread.deleted'),
});

export const object10Schema = z.literal('thread.deleted');

export const deleteVectorStoreFileResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.literal('vector_store.file.deleted'),
});

export const object11Schema = z.literal('vector_store.file.deleted');

export const deleteVectorStoreResponseSchema = z.object({
  id: z.string(),
  deleted: z.boolean(),
  object: z.literal('vector_store.deleted'),
});

export const object12Schema = z.literal('vector_store.deleted');

export const eventSchema = z.literal('done');

export const dataSchema = z.literal('[DONE]');

export const object13Schema = z.literal('embedding');

export const errorSchema = z.object({
  code: z.string().nullable(),
  message: z.string(),
  param: z.string().nullable(),
  type: z.string(),
});

export const errorEventSchema = z.object({
  event: z.literal('error'),
  data: errorSchema,
});

export const event2Schema = z.literal('error');

export const errorResponseSchema = z.object({
  error: errorSchema,
});

export const weightSchema = z.union([z.literal(0), z.literal(1)]);

export const chatCompletionRequestSystemMessageSchema = z.object({
  content: z.union([z.string(), z.array(chatCompletionRequestSystemMessageContentPartSchema)]),
  role: z.literal('system'),
  name: z.string().optional(),
});

export const chatCompletionRequestUserMessageSchema = z.object({
  content: z.union([z.string(), z.array(chatCompletionRequestUserMessageContentPartSchema)]),
  role: z.literal('user'),
  name: z.string().optional(),
});

export const chatCompletionRequestToolMessageSchema = z.object({
  role: z.literal('tool'),
  content: z.union([z.string(), z.array(chatCompletionRequestToolMessageContentPartSchema)]),
  tool_call_id: z.string(),
});

export const finetuneCompletionRequestInputSchema = z.object({
  prompt: z.string().optional(),
  completion: z.string().optional(),
});

export const fineTuningIntegrationSchema = z.object({
  type: z.literal('wandb'),
  wandb: z.object({
    project: z.string(),
    name: z.string().optional().nullable(),
    entity: z.string().optional().nullable(),
    tags: z.array(z.string()).optional(),
  }),
});

export const type11Schema = z.literal('wandb');

export const fineTuningJobSchema = z.object({
  id: z.string(),
  created_at: z.number(),
  error: z
    .object({
      code: z.string(),
      message: z.string(),
      param: z.string().nullable(),
    })
    .nullable(),
  fine_tuned_model: z.string().nullable(),
  finished_at: z.number().nullable(),
  hyperparameters: z.object({
    n_epochs: z.union([z.literal('auto'), z.number()]),
  }),
  model: z.string(),
  object: z.literal('fine_tuning.job'),
  organization_id: z.string(),
  result_files: z.array(z.string()),
  status: z.union([
    z.literal('validating_files'),
    z.literal('queued'),
    z.literal('running'),
    z.literal('succeeded'),
    z.literal('failed'),
    z.literal('cancelled'),
  ]),
  trained_tokens: z.number().nullable(),
  training_file: z.string(),
  validation_file: z.string().nullable(),
  integrations: z.array(fineTuningIntegrationSchema).optional().nullable(),
  seed: z.number(),
  estimated_finish: z.number().optional().nullable(),
});

export const object14Schema = z.literal('fine_tuning.job');

export const status2Schema = z.union([
  z.literal('validating_files'),
  z.literal('queued'),
  z.literal('running'),
  z.literal('succeeded'),
  z.literal('failed'),
  z.literal('cancelled'),
]);

export const fineTuningJobCheckpointSchema = z.object({
  id: z.string(),
  created_at: z.number(),
  fine_tuned_model_checkpoint: z.string(),
  step_number: z.number(),
  metrics: z.object({
    step: z.number().optional(),
    train_loss: z.number().optional(),
    train_mean_token_accuracy: z.number().optional(),
    valid_loss: z.number().optional(),
    valid_mean_token_accuracy: z.number().optional(),
    full_valid_loss: z.number().optional(),
    full_valid_mean_token_accuracy: z.number().optional(),
  }),
  fine_tuning_job_id: z.string(),
  object: z.literal('fine_tuning.job.checkpoint'),
});

export const object15Schema = z.literal('fine_tuning.job.checkpoint');

export const fineTuningJobEventSchema = z.object({
  id: z.string(),
  created_at: z.number(),
  level: z.union([z.literal('info'), z.literal('warn'), z.literal('error')]),
  message: z.string(),
  object: z.literal('fine_tuning.job.event'),
});

export const levelSchema = z.union([z.literal('info'), z.literal('warn'), z.literal('error')]);

export const object16Schema = z.literal('fine_tuning.job.event');

export const imageSchema = z.object({
  b64_json: z.string().optional(),
  url: z.string().optional(),
  revised_prompt: z.string().optional(),
});

export const imagesResponseSchema = z.object({
  created: z.number(),
  data: z.array(imageSchema),
});

export const inviteSchema = z.object({
  object: z.literal('organization.invite'),
  id: z.string(),
  email: z.string(),
  role: z.union([z.literal('owner'), z.literal('reader')]),
  status: z.union([z.literal('accepted'), z.literal('expired'), z.literal('pending')]),
  invited_at: z.number(),
  expires_at: z.number(),
  accepted_at: z.number().optional(),
});

export const object17Schema = z.literal('organization.invite');

export const role8Schema = z.union([z.literal('owner'), z.literal('reader')]);

export const status3Schema = z.union([z.literal('accepted'), z.literal('expired'), z.literal('pending')]);

export const inviteDeleteResponseSchema = z.object({
  object: z.literal('organization.invite.deleted'),
  id: z.string(),
  deleted: z.boolean(),
});

export const object18Schema = z.literal('organization.invite.deleted');

export const inviteListResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(inviteSchema),
  first_id: z.string().optional(),
  last_id: z.string().optional(),
  has_more: z.boolean().optional(),
});

export const inviteRequestSchema = z.object({
  email: z.string(),
  role: z.union([z.literal('reader'), z.literal('owner')]),
});

export const listBatchesResponseSchema = z.object({
  data: z.array(batchSchema),
  first_id: z.string().optional(),
  last_id: z.string().optional(),
  has_more: z.boolean(),
  object: z.literal('list'),
});

export const openAIFileSchema = z.object({
  id: z.string(),
  bytes: z.number(),
  created_at: z.number(),
  filename: z.string(),
  object: z.literal('file'),
  purpose: z.union([
    z.literal('assistants'),
    z.literal('assistants_output'),
    z.literal('batch'),
    z.literal('batch_output'),
    z.literal('fine-tune'),
    z.literal('fine-tune-results'),
    z.literal('vision'),
  ]),
  status: z.union([z.literal('uploaded'), z.literal('processed'), z.literal('error')]),
  status_details: z.string().optional(),
});

export const listFineTuningJobCheckpointsResponseSchema = z.object({
  data: z.array(fineTuningJobCheckpointSchema),
  object: z.literal('list'),
  first_id: z.string().optional().nullable(),
  last_id: z.string().optional().nullable(),
  has_more: z.boolean(),
});

export const listFineTuningJobEventsResponseSchema = z.object({
  data: z.array(fineTuningJobEventSchema),
  object: z.literal('list'),
});

export const modelSchema = z.object({
  id: z.string(),
  created: z.number(),
  object: z.literal('model'),
  owned_by: z.string(),
});

export const listPaginatedFineTuningJobsResponseSchema = z.object({
  data: z.array(fineTuningJobSchema),
  has_more: z.boolean(),
  object: z.literal('list'),
});

export const threadObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread'),
  created_at: z.number(),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .object({
          vector_store_ids: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .nullable(),
  metadata: z.record(z.unknown()).nullable(),
});

export const vectorStoreObjectSchema = z.object({
  id: z.string(),
  object: z.literal('vector_store'),
  created_at: z.number(),
  name: z.string(),
  usage_bytes: z.number(),
  file_counts: z.object({
    in_progress: z.number(),
    completed: z.number(),
    failed: z.number(),
    cancelled: z.number(),
    total: z.number(),
  }),
  status: z.union([z.literal('expired'), z.literal('in_progress'), z.literal('completed')]),
  expires_after: vectorStoreExpirationAfterSchema.optional(),
  expires_at: z.number().optional().nullable(),
  last_active_at: z.number().nullable(),
  metadata: z.record(z.unknown()).nullable(),
});

export const type12Schema = z.literal('image_file');

export const messageContentRefusalObjectSchema = z.object({
  type: z.literal('refusal'),
  refusal: z.string(),
});

export const messageContentTextAnnotationsFileCitationObjectSchema = z.object({
  type: z.literal('file_citation'),
  text: z.string(),
  file_citation: z.object({
    file_id: z.string(),
  }),
  start_index: z.number(),
  end_index: z.number(),
});

export const type13Schema = z.literal('file_citation');

export const messageContentTextAnnotationsFilePathObjectSchema = z.object({
  type: z.literal('file_path'),
  text: z.string(),
  file_path: z.object({
    file_id: z.string(),
  }),
  start_index: z.number(),
  end_index: z.number(),
});

export const type14Schema = z.literal('file_path');

export const messageContentTextObjectSchema = z.object({
  type: z.literal('text'),
  text: z.object({
    value: z.string(),
    annotations: z.array(
      z.union([
        messageContentTextAnnotationsFileCitationObjectSchema,
        messageContentTextAnnotationsFilePathObjectSchema,
      ]),
    ),
  }),
});

export const messageDeltaContentImageFileObjectSchema = z.object({
  index: z.number(),
  type: z.literal('image_file'),
  image_file: z
    .object({
      file_id: z.string().optional(),
      detail: z.union([z.literal('auto'), z.literal('low'), z.literal('high')]).optional(),
    })
    .optional(),
});

export const messageDeltaContentImageUrlObjectSchema = z.object({
  index: z.number(),
  type: z.literal('image_url'),
  image_url: z
    .object({
      url: z.string().optional(),
      detail: z.union([z.literal('auto'), z.literal('low'), z.literal('high')]).optional(),
    })
    .optional(),
});

export const messageDeltaContentRefusalObjectSchema = z.object({
  index: z.number(),
  type: z.literal('refusal'),
  refusal: z.string().optional(),
});

export const messageDeltaContentTextAnnotationsFileCitationObjectSchema = z.object({
  index: z.number(),
  type: z.literal('file_citation'),
  text: z.string().optional(),
  file_citation: z
    .object({
      file_id: z.string().optional(),
      quote: z.string().optional(),
    })
    .optional(),
  start_index: z.number().optional(),
  end_index: z.number().optional(),
});

export const messageDeltaContentTextAnnotationsFilePathObjectSchema = z.object({
  index: z.number(),
  type: z.literal('file_path'),
  text: z.string().optional(),
  file_path: z
    .object({
      file_id: z.string().optional(),
    })
    .optional(),
  start_index: z.number().optional(),
  end_index: z.number().optional(),
});

export const messageDeltaContentTextObjectSchema = z.object({
  index: z.number(),
  type: z.literal('text'),
  text: z
    .object({
      value: z.string().optional(),
      annotations: z
        .array(
          z.union([
            messageDeltaContentTextAnnotationsFileCitationObjectSchema,
            messageDeltaContentTextAnnotationsFilePathObjectSchema,
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const messageDeltaObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread.message.delta'),
  delta: z.object({
    role: z.union([z.literal('user'), z.literal('assistant')]).optional(),
    content: z
      .array(
        z.union([
          messageDeltaContentImageFileObjectSchema,
          messageDeltaContentTextObjectSchema,
          messageDeltaContentRefusalObjectSchema,
          messageDeltaContentImageUrlObjectSchema,
        ]),
      )
      .optional(),
  }),
});

export const object19Schema = z.literal('thread.message.delta');

export const messageObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread.message'),
  created_at: z.number(),
  thread_id: z.string(),
  status: z.union([z.literal('in_progress'), z.literal('incomplete'), z.literal('completed')]),
  incomplete_details: z
    .object({
      reason: z.union([
        z.literal('content_filter'),
        z.literal('max_tokens'),
        z.literal('run_cancelled'),
        z.literal('run_expired'),
        z.literal('run_failed'),
      ]),
    })
    .nullable(),
  completed_at: z.number().nullable(),
  incomplete_at: z.number().nullable(),
  role: z.union([z.literal('user'), z.literal('assistant')]),
  content: z.array(
    z.union([
      messageContentImageFileObjectSchema,
      messageContentImageUrlObjectSchema,
      messageContentTextObjectSchema,
      messageContentRefusalObjectSchema,
    ]),
  ),
  assistant_id: z.string().nullable(),
  run_id: z.string().nullable(),
  attachments: z
    .array(
      z.object({
        file_id: z.string().optional(),
        tools: z.array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchTypeOnlySchema])).optional(),
      }),
    )
    .nullable(),
  metadata: z.record(z.unknown()).nullable(),
});

export const object20Schema = z.literal('thread.message');

export const status4Schema = z.union([z.literal('in_progress'), z.literal('incomplete'), z.literal('completed')]);

export const reasonSchema = z.union([
  z.literal('content_filter'),
  z.literal('max_tokens'),
  z.literal('run_cancelled'),
  z.literal('run_expired'),
  z.literal('run_failed'),
]);

export const messageStreamEventSchema = z.union([
  z.object({
    event: z.literal('thread.message.created'),
    data: messageObjectSchema,
  }),
  z.object({
    event: z.literal('thread.message.in_progress'),
    data: messageObjectSchema,
  }),
  z.object({
    event: z.literal('thread.message.delta'),
    data: messageDeltaObjectSchema,
  }),
  z.object({
    event: z.literal('thread.message.completed'),
    data: messageObjectSchema,
  }),
  z.object({
    event: z.literal('thread.message.incomplete'),
    data: messageObjectSchema,
  }),
]);

export const event3Schema = z.literal('thread.message.created');

export const object21Schema = z.literal('model');

export const modifyMessageRequestSchema = z.object({
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const modifyRunRequestSchema = z.object({
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const modifyThreadRequestSchema = z.object({
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .object({
          vector_store_ids: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const purpose2Schema = z.union([
  z.literal('assistants'),
  z.literal('assistants_output'),
  z.literal('batch'),
  z.literal('batch_output'),
  z.literal('fine-tune'),
  z.literal('fine-tune-results'),
  z.literal('vision'),
]);

export const status5Schema = z.union([z.literal('uploaded'), z.literal('processed'), z.literal('error')]);

export const otherChunkingStrategyResponseParamSchema = z.object({
  type: z.literal('other'),
});

export const type15Schema = z.literal('other');

export const projectSchema = z.object({
  id: z.string(),
  object: z.literal('organization.project'),
  name: z.string(),
  created_at: z.number(),
  archived_at: z.number().optional().nullable(),
  status: z.union([z.literal('active'), z.literal('archived')]),
});

export const object22Schema = z.literal('organization.project');

export const status6Schema = z.union([z.literal('active'), z.literal('archived')]);

export const projectUserSchema = z.object({
  object: z.literal('organization.project.user'),
  id: z.string(),
  name: z.string(),
  email: z.string(),
  role: z.union([z.literal('owner'), z.literal('member')]),
  added_at: z.number(),
});

export const projectServiceAccountSchema = z.object({
  object: z.literal('organization.project.service_account'),
  id: z.string(),
  name: z.string(),
  role: z.union([z.literal('owner'), z.literal('member')]),
  created_at: z.number(),
});

export const object23Schema = z.literal('organization.project.api_key');

export const projectApiKeyDeleteResponseSchema = z.object({
  object: z.literal('organization.project.api_key.deleted'),
  id: z.string(),
  deleted: z.boolean(),
});

export const object24Schema = z.literal('organization.project.api_key.deleted');

export const projectApiKeySchema = z.object({
  object: z.literal('organization.project.api_key'),
  redacted_value: z.string(),
  name: z.string(),
  created_at: z.number(),
  id: z.string(),
  owner: z.object({
    type: z.union([z.literal('user'), z.literal('service_account')]).optional(),
    user: projectUserSchema.optional(),
    service_account: projectServiceAccountSchema.optional(),
  }),
});

export const projectCreateRequestSchema = z.object({
  name: z.string(),
});

export const projectListResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(projectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const object25Schema = z.literal('organization.project.service_account');

export const role9Schema = z.union([z.literal('owner'), z.literal('member')]);

export const projectServiceAccountApiKeySchema = z.object({
  object: z.literal('organization.project.service_account.api_key'),
  value: z.string(),
  name: z.string(),
  created_at: z.number(),
  id: z.string(),
});

export const object26Schema = z.literal('organization.project.service_account.api_key');

export const projectServiceAccountCreateRequestSchema = z.object({
  name: z.string(),
});

export const projectServiceAccountCreateResponseSchema = z.object({
  object: z.literal('organization.project.service_account'),
  id: z.string(),
  name: z.string(),
  role: z.literal('member'),
  created_at: z.number(),
  api_key: projectServiceAccountApiKeySchema,
});

export const role10Schema = z.literal('member');

export const projectServiceAccountDeleteResponseSchema = z.object({
  object: z.literal('organization.project.service_account.deleted'),
  id: z.string(),
  deleted: z.boolean(),
});

export const object27Schema = z.literal('organization.project.service_account.deleted');

export const projectServiceAccountListResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(projectServiceAccountSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const projectUpdateRequestSchema = z.object({
  name: z.string(),
});

export const object28Schema = z.literal('organization.project.user');

export const projectUserCreateRequestSchema = z.object({
  user_id: z.string(),
  role: z.union([z.literal('owner'), z.literal('member')]),
});

export const projectUserDeleteResponseSchema = z.object({
  object: z.literal('organization.project.user.deleted'),
  id: z.string(),
  deleted: z.boolean(),
});

export const object29Schema = z.literal('organization.project.user.deleted');

export const projectUserListResponseSchema = z.object({
  object: z.string(),
  data: z.array(projectUserSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const projectUserUpdateRequestSchema = z.object({
  role: z.union([z.literal('owner'), z.literal('member')]),
});

export const type16Schema = z.literal('json_object');

export const responseFormatJsonSchemaSchemaSchema = z.record(z.unknown());

export const type17Schema = z.literal('json_schema');

export const runCompletionUsageSchema = z
  .object({
    completion_tokens: z.number(),
    prompt_tokens: z.number(),
    total_tokens: z.number(),
  })
  .nullable();

export const runToolCallObjectSchema = z.object({
  id: z.string(),
  type: z.literal('function'),
  function: z.object({
    name: z.string(),
    arguments: z.string(),
  }),
});

export const object30Schema = z.literal('thread.run');

export const status7Schema = z.union([
  z.literal('queued'),
  z.literal('in_progress'),
  z.literal('requires_action'),
  z.literal('cancelling'),
  z.literal('cancelled'),
  z.literal('failed'),
  z.literal('completed'),
  z.literal('incomplete'),
  z.literal('expired'),
]);

export const type18Schema = z.literal('submit_tool_outputs');

export const codeSchema = z.union([
  z.literal('server_error'),
  z.literal('rate_limit_exceeded'),
  z.literal('invalid_prompt'),
]);

export const reason2Schema = z.union([z.literal('max_completion_tokens'), z.literal('max_prompt_tokens')]);

export const runStepCompletionUsageSchema = z
  .object({
    completion_tokens: z.number(),
    prompt_tokens: z.number(),
    total_tokens: z.number(),
  })
  .nullable();

export const runStepDeltaStepDetailsMessageCreationObjectSchema = z.object({
  type: z.literal('message_creation'),
  message_creation: z
    .object({
      message_id: z.string().optional(),
    })
    .optional(),
});

export const object31Schema = z.literal('thread.run.step.delta');

export const type19Schema = z.literal('message_creation');

export const runStepDeltaStepDetailsToolCallsCodeOutputLogsObjectSchema = z.object({
  index: z.number(),
  type: z.literal('logs'),
  logs: z.string().optional(),
});

export const runStepDeltaStepDetailsToolCallsCodeOutputImageObjectSchema = z.object({
  index: z.number(),
  type: z.literal('image'),
  image: z
    .object({
      file_id: z.string().optional(),
    })
    .optional(),
});

export const type20Schema = z.literal('image');

export const type21Schema = z.literal('logs');

export const runStepDeltaStepDetailsToolCallsFileSearchObjectSchema = z.object({
  index: z.number(),
  id: z.string().optional(),
  type: z.literal('file_search'),
  file_search: z.record(z.unknown()),
});

export const runStepDeltaStepDetailsToolCallsFunctionObjectSchema = z.object({
  index: z.number(),
  id: z.string().optional(),
  type: z.literal('function'),
  function: z
    .object({
      name: z.string().optional(),
      arguments: z.string().optional(),
      output: z.string().optional().nullable(),
    })
    .optional(),
});

export const runStepDeltaStepDetailsToolCallsCodeObjectSchema = z.object({
  index: z.number(),
  id: z.string().optional(),
  type: z.literal('code_interpreter'),
  code_interpreter: z
    .object({
      input: z.string().optional(),
      outputs: z
        .array(
          z.union([
            runStepDeltaStepDetailsToolCallsCodeOutputLogsObjectSchema,
            runStepDeltaStepDetailsToolCallsCodeOutputImageObjectSchema,
          ]),
        )
        .optional(),
    })
    .optional(),
});

export const type22Schema = z.literal('tool_calls');

export const runStepDetailsMessageCreationObjectSchema = z.object({
  type: z.literal('message_creation'),
  message_creation: z.object({
    message_id: z.string(),
  }),
});

export const runStepDetailsToolCallsCodeOutputLogsObjectSchema = z.object({
  type: z.literal('logs'),
  logs: z.string(),
});

export const runStepDetailsToolCallsCodeOutputImageObjectSchema = z.object({
  type: z.literal('image'),
  image: z.object({
    file_id: z.string(),
  }),
});

export const runStepDetailsToolCallsFileSearchObjectSchema = z.object({
  id: z.string(),
  type: z.literal('file_search'),
  file_search: z.record(z.unknown()),
});

export const runStepDetailsToolCallsFunctionObjectSchema = z.object({
  id: z.string(),
  type: z.literal('function'),
  function: z.object({
    name: z.string(),
    arguments: z.string(),
    output: z.string().nullable(),
  }),
});

export const runStepDetailsToolCallsCodeObjectSchema = z.object({
  id: z.string(),
  type: z.literal('code_interpreter'),
  code_interpreter: z.object({
    input: z.string(),
    outputs: z.array(
      z.union([runStepDetailsToolCallsCodeOutputLogsObjectSchema, runStepDetailsToolCallsCodeOutputImageObjectSchema]),
    ),
  }),
});

export const runStepDetailsToolCallsObjectSchema = z.object({
  type: z.literal('tool_calls'),
  tool_calls: z.array(
    z.union([
      runStepDetailsToolCallsCodeObjectSchema,
      runStepDetailsToolCallsFileSearchObjectSchema,
      runStepDetailsToolCallsFunctionObjectSchema,
    ]),
  ),
});

export const object32Schema = z.literal('thread.run.step');

export const type23Schema = z.union([z.literal('message_creation'), z.literal('tool_calls')]);

export const status8Schema = z.union([
  z.literal('in_progress'),
  z.literal('cancelled'),
  z.literal('failed'),
  z.literal('completed'),
  z.literal('expired'),
]);

export const code2Schema = z.union([z.literal('server_error'), z.literal('rate_limit_exceeded')]);

export const runStepObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread.run.step'),
  created_at: z.number(),
  assistant_id: z.string(),
  thread_id: z.string(),
  run_id: z.string(),
  type: z.union([z.literal('message_creation'), z.literal('tool_calls')]),
  status: z.union([
    z.literal('in_progress'),
    z.literal('cancelled'),
    z.literal('failed'),
    z.literal('completed'),
    z.literal('expired'),
  ]),
  step_details: z.union([runStepDetailsMessageCreationObjectSchema, runStepDetailsToolCallsObjectSchema]),
  last_error: z
    .object({
      code: z.union([z.literal('server_error'), z.literal('rate_limit_exceeded')]),
      message: z.string(),
    })
    .nullable(),
  expired_at: z.number().nullable(),
  cancelled_at: z.number().nullable(),
  failed_at: z.number().nullable(),
  completed_at: z.number().nullable(),
  metadata: z.record(z.unknown()).nullable(),
  usage: runStepCompletionUsageSchema,
});

export const event4Schema = z.literal('thread.run.step.created');

export const event5Schema = z.literal('thread.run.created');

export const staticChunkingStrategySchema = z.object({
  max_chunk_size_tokens: z.number(),
  chunk_overlap_tokens: z.number(),
});

export const staticChunkingStrategyRequestParamSchema = z.object({
  type: z.literal('static'),
  static: staticChunkingStrategySchema,
});

export const type24Schema = z.literal('static');

export const staticChunkingStrategyResponseParamSchema = z.object({
  type: z.literal('static'),
  static: staticChunkingStrategySchema,
});

export const submitToolOutputsRunRequestSchema = z.object({
  tool_outputs: z.array(
    z.object({
      tool_call_id: z.string().optional(),
      output: z.string().optional(),
    }),
  ),
  stream: z.boolean().optional().nullable(),
});

export const object33Schema = z.literal('thread');

export const threadStreamEventSchema = z.object({
  event: z.literal('thread.created'),
  data: threadObjectSchema,
});

export const event6Schema = z.literal('thread.created');

export const type25Schema = z.union([z.literal('auto'), z.literal('last_messages')]);

export const updateVectorStoreRequestSchema = z.object({
  name: z.string().optional().nullable(),
  expires_after: vectorStoreExpirationAfterSchema.optional(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const uploadSchema = z.object({
  id: z.string(),
  created_at: z.number(),
  filename: z.string(),
  bytes: z.number(),
  purpose: z.string(),
  status: z.union([z.literal('pending'), z.literal('completed'), z.literal('cancelled'), z.literal('expired')]),
  expires_at: z.number(),
  object: z.literal('upload').optional(),
  file: openAIFileSchema.optional(),
});

export const status9Schema = z.union([
  z.literal('pending'),
  z.literal('completed'),
  z.literal('cancelled'),
  z.literal('expired'),
]);

export const object34Schema = z.literal('upload');

export const uploadPartSchema = z.object({
  id: z.string(),
  created_at: z.number(),
  upload_id: z.string(),
  object: z.literal('upload.part'),
});

export const object35Schema = z.literal('upload.part');

export const userSchema = z.object({
  object: z.literal('organization.user'),
  id: z.string(),
  name: z.string(),
  email: z.string(),
  role: z.union([z.literal('owner'), z.literal('reader')]),
  added_at: z.number(),
});

export const object36Schema = z.literal('organization.user');

export const userDeleteResponseSchema = z.object({
  object: z.literal('organization.user.deleted'),
  id: z.string(),
  deleted: z.boolean(),
});

export const object37Schema = z.literal('organization.user.deleted');

export const userListResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(userSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const userRoleUpdateRequestSchema = z.object({
  role: z.union([z.literal('owner'), z.literal('reader')]),
});

export const anchorSchema = z.literal('last_active_at');

export const vectorStoreFileBatchObjectSchema = z.object({
  id: z.string(),
  object: z.literal('vector_store.files_batch'),
  created_at: z.number(),
  vector_store_id: z.string(),
  status: z.union([z.literal('in_progress'), z.literal('completed'), z.literal('cancelled'), z.literal('failed')]),
  file_counts: z.object({
    in_progress: z.number(),
    completed: z.number(),
    failed: z.number(),
    cancelled: z.number(),
    total: z.number(),
  }),
});

export const object38Schema = z.literal('vector_store.files_batch');

export const status10Schema = z.union([
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('cancelled'),
  z.literal('failed'),
]);

export const vectorStoreFileObjectSchema = z.object({
  id: z.string(),
  object: z.literal('vector_store.file'),
  usage_bytes: z.number(),
  created_at: z.number(),
  vector_store_id: z.string(),
  status: z.union([z.literal('in_progress'), z.literal('completed'), z.literal('cancelled'), z.literal('failed')]),
  last_error: z
    .object({
      code: z.union([z.literal('server_error'), z.literal('unsupported_file'), z.literal('invalid_file')]),
      message: z.string(),
    })
    .nullable(),
  chunking_strategy: z
    .union([staticChunkingStrategyResponseParamSchema, otherChunkingStrategyResponseParamSchema])
    .optional(),
});

export const object39Schema = z.literal('vector_store.file');

export const code3Schema = z.union([
  z.literal('server_error'),
  z.literal('unsupported_file'),
  z.literal('invalid_file'),
]);

export const object40Schema = z.literal('vector_store');

export const status11Schema = z.union([z.literal('expired'), z.literal('in_progress'), z.literal('completed')]);

export const createChatCompletionResponse2Schema = createChatCompletionResponseSchema;

export const createChatCompletionErrorSchema = z.unknown();

export const createCompletionDataSchema = z.object({
  body: createCompletionRequestSchema,
});

export const createCompletionResponse2Schema = createCompletionResponseSchema;

export const createCompletionErrorSchema = z.unknown();

export const createImageDataSchema = z.object({
  body: createImageRequestSchema,
});

export const createImageResponseSchema = imagesResponseSchema;

export const createImageErrorSchema = z.unknown();

export const createImageEditResponseSchema = imagesResponseSchema;

export const createImageEditErrorSchema = z.unknown();

export const createImageVariationResponseSchema = imagesResponseSchema;

export const createImageVariationErrorSchema = z.unknown();

export const createEmbeddingDataSchema = z.object({
  body: createEmbeddingRequestSchema,
});

export const createEmbeddingResponseSchema = z.object({
  data: z.array(embeddingSchema),
  model: z.string(),
  object: z.literal('list'),
  usage: z.object({
    prompt_tokens: z.number(),
    total_tokens: z.number(),
  }),
});

export const createEmbeddingErrorSchema = z.unknown();

export const createSpeechDataSchema = z.object({
  body: createSpeechRequestSchema,
});

export const createSpeechErrorSchema = z.unknown();

export const createTranscriptionErrorSchema = z.unknown();

export const createTranslationResponseSchema = z.union([
  createTranslationResponseJsonSchema,
  createTranslationResponseVerboseJsonSchema,
]);

export const createTranslationErrorSchema = z.unknown();

export const listFilesDataSchema = z.object({
  query: z
    .object({
      purpose: z.string().optional(),
    })
    .optional(),
});

export const listFilesResponseSchema = z.object({
  data: z.array(openAIFileSchema),
  object: z.literal('list'),
});

export const listFilesErrorSchema = z.unknown();

export const createFileResponseSchema = openAIFileSchema;

export const createFileErrorSchema = z.unknown();

export const deleteFileDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
  }),
});

export const deleteFileResponse2Schema = deleteFileResponseSchema;

export const deleteFileErrorSchema = z.unknown();

export const retrieveFileDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
  }),
});

export const retrieveFileResponseSchema = openAIFileSchema;

export const retrieveFileErrorSchema = z.unknown();

export const downloadFileDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
  }),
});

export const downloadFileResponseSchema = z.string();

export const downloadFileErrorSchema = z.unknown();

export const createUploadDataSchema = z.object({
  body: createUploadRequestSchema,
});

export const createUploadResponseSchema = uploadSchema;

export const createUploadErrorSchema = z.unknown();

export const addUploadPartResponseSchema = uploadPartSchema;

export const addUploadPartErrorSchema = z.unknown();

export const completeUploadDataSchema = z.object({
  body: completeUploadRequestSchema,
  path: z.object({
    upload_id: z.string(),
  }),
});

export const completeUploadResponseSchema = uploadSchema;

export const completeUploadErrorSchema = z.unknown();

export const cancelUploadDataSchema = z.object({
  path: z.object({
    upload_id: z.string(),
  }),
});

export const cancelUploadResponseSchema = uploadSchema;

export const cancelUploadErrorSchema = z.unknown();

export const createFineTuningJobDataSchema = z.object({
  body: createFineTuningJobRequestSchema,
});

export const createFineTuningJobResponseSchema = fineTuningJobSchema;

export const createFineTuningJobErrorSchema = z.unknown();

export const listPaginatedFineTuningJobsDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listPaginatedFineTuningJobsResponse2Schema = listPaginatedFineTuningJobsResponseSchema;

export const listPaginatedFineTuningJobsErrorSchema = z.unknown();

export const retrieveFineTuningJobDataSchema = z.object({
  path: z.object({
    fine_tuning_job_id: z.string(),
  }),
});

export const retrieveFineTuningJobResponseSchema = fineTuningJobSchema;

export const retrieveFineTuningJobErrorSchema = z.unknown();

export const listFineTuningEventsDataSchema = z.object({
  path: z.object({
    fine_tuning_job_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listFineTuningEventsResponseSchema = listFineTuningJobEventsResponseSchema;

export const listFineTuningEventsErrorSchema = z.unknown();

export const cancelFineTuningJobDataSchema = z.object({
  path: z.object({
    fine_tuning_job_id: z.string(),
  }),
});

export const cancelFineTuningJobResponseSchema = fineTuningJobSchema;

export const cancelFineTuningJobErrorSchema = z.unknown();

export const listFineTuningJobCheckpointsDataSchema = z.object({
  path: z.object({
    fine_tuning_job_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listFineTuningJobCheckpointsResponse2Schema = listFineTuningJobCheckpointsResponseSchema;

export const listFineTuningJobCheckpointsErrorSchema = z.unknown();

export const listModelsResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(modelSchema),
});

export const listModelsErrorSchema = z.unknown();

export const retrieveModelDataSchema = z.object({
  path: z.object({
    model: z.string(),
  }),
});

export const retrieveModelResponseSchema = modelSchema;

export const retrieveModelErrorSchema = z.unknown();

export const deleteModelDataSchema = z.object({
  path: z.object({
    model: z.string(),
  }),
});

export const deleteModelResponse2Schema = deleteModelResponseSchema;

export const deleteModelErrorSchema = z.unknown();

export const createModerationDataSchema = z.object({
  body: createModerationRequestSchema,
});

export const createModerationResponse2Schema = createModerationResponseSchema;

export const createModerationErrorSchema = z.unknown();

export const listAssistantsDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listAssistantsErrorSchema = z.unknown();

export const createAssistantErrorSchema = z.unknown();

export const getAssistantDataSchema = z.object({
  path: z.object({
    assistant_id: z.string(),
  }),
});

export const getAssistantErrorSchema = z.unknown();

export const modifyAssistantErrorSchema = z.unknown();

export const deleteAssistantDataSchema = z.object({
  path: z.object({
    assistant_id: z.string(),
  }),
});

export const deleteAssistantResponse2Schema = deleteAssistantResponseSchema;

export const deleteAssistantErrorSchema = z.unknown();

export const createThreadDataSchema = z.object({
  body: createThreadRequestSchema.optional(),
});

export const createThreadResponseSchema = threadObjectSchema;

export const createThreadErrorSchema = z.unknown();

export const getThreadDataSchema = z.object({
  path: z.object({
    thread_id: z.string(),
  }),
});

export const getThreadResponseSchema = threadObjectSchema;

export const getThreadErrorSchema = z.unknown();

export const modifyThreadDataSchema = z.object({
  body: modifyThreadRequestSchema,
  path: z.object({
    thread_id: z.string(),
  }),
});

export const modifyThreadResponseSchema = threadObjectSchema;

export const modifyThreadErrorSchema = z.unknown();

export const deleteThreadDataSchema = z.object({
  path: z.object({
    thread_id: z.string(),
  }),
});

export const deleteThreadResponse2Schema = deleteThreadResponseSchema;

export const deleteThreadErrorSchema = z.unknown();

export const listMessagesDataSchema = z.object({
  path: z.object({
    thread_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      run_id: z.string().optional(),
    })
    .optional(),
});

export const listMessagesResponseSchema = z.object({
  object: z.string(),
  data: z.array(messageObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const listMessagesErrorSchema = z.unknown();

export const createMessageDataSchema = z.object({
  body: createMessageRequestSchema,
  path: z.object({
    thread_id: z.string(),
  }),
});

export const createMessageResponseSchema = messageObjectSchema;

export const createMessageErrorSchema = z.unknown();

export const getMessageDataSchema = z.object({
  path: z.object({
    message_id: z.string(),
    thread_id: z.string(),
  }),
});

export const getMessageResponseSchema = messageObjectSchema;

export const getMessageErrorSchema = z.unknown();

export const modifyMessageDataSchema = z.object({
  body: modifyMessageRequestSchema,
  path: z.object({
    message_id: z.string(),
    thread_id: z.string(),
  }),
});

export const modifyMessageResponseSchema = messageObjectSchema;

export const modifyMessageErrorSchema = z.unknown();

export const deleteMessageDataSchema = z.object({
  path: z.object({
    message_id: z.string(),
    thread_id: z.string(),
  }),
});

export const deleteMessageResponse2Schema = deleteMessageResponseSchema;

export const deleteMessageErrorSchema = z.unknown();

export const createThreadAndRunErrorSchema = z.unknown();

export const listRunsDataSchema = z.object({
  path: z.object({
    thread_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listRunsErrorSchema = z.unknown();

export const createRunErrorSchema = z.unknown();

export const getRunDataSchema = z.object({
  path: z.object({
    run_id: z.string(),
    thread_id: z.string(),
  }),
});

export const getRunErrorSchema = z.unknown();

export const modifyRunDataSchema = z.object({
  body: modifyRunRequestSchema,
  path: z.object({
    run_id: z.string(),
    thread_id: z.string(),
  }),
});

export const modifyRunErrorSchema = z.unknown();

export const submitToolOuputsToRunDataSchema = z.object({
  body: submitToolOutputsRunRequestSchema,
  path: z.object({
    run_id: z.string(),
    thread_id: z.string(),
  }),
});

export const submitToolOuputsToRunErrorSchema = z.unknown();

export const cancelRunDataSchema = z.object({
  path: z.object({
    run_id: z.string(),
    thread_id: z.string(),
  }),
});

export const cancelRunErrorSchema = z.unknown();

export const listRunStepsDataSchema = z.object({
  path: z.object({
    run_id: z.string(),
    thread_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listRunStepsResponseSchema = z.object({
  object: z.string(),
  data: z.array(runStepObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const listRunStepsErrorSchema = z.unknown();

export const getRunStepDataSchema = z.object({
  path: z.object({
    run_id: z.string(),
    step_id: z.string(),
    thread_id: z.string(),
  }),
});

export const getRunStepResponseSchema = runStepObjectSchema;

export const getRunStepErrorSchema = z.unknown();

export const listVectorStoresDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listVectorStoresResponseSchema = z.object({
  object: z.string(),
  data: z.array(vectorStoreObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const listVectorStoresErrorSchema = z.unknown();

export const createVectorStoreRequestSchema = z.object({
  file_ids: z.array(z.string()).optional(),
  name: z.string().optional(),
  expires_after: vectorStoreExpirationAfterSchema.optional(),
  chunking_strategy: z
    .union([autoChunkingStrategyRequestParamSchema, staticChunkingStrategyRequestParamSchema])
    .optional(),
  metadata: z.record(z.unknown()).optional().nullable(),
});

export const createVectorStoreResponseSchema = vectorStoreObjectSchema;

export const createVectorStoreErrorSchema = z.unknown();

export const getVectorStoreDataSchema = z.object({
  path: z.object({
    vector_store_id: z.string(),
  }),
});

export const getVectorStoreResponseSchema = vectorStoreObjectSchema;

export const getVectorStoreErrorSchema = z.unknown();

export const modifyVectorStoreDataSchema = z.object({
  body: updateVectorStoreRequestSchema,
  path: z.object({
    vector_store_id: z.string(),
  }),
});

export const modifyVectorStoreResponseSchema = vectorStoreObjectSchema;

export const modifyVectorStoreErrorSchema = z.unknown();

export const deleteVectorStoreDataSchema = z.object({
  path: z.object({
    vector_store_id: z.string(),
  }),
});

export const deleteVectorStoreResponse2Schema = deleteVectorStoreResponseSchema;

export const deleteVectorStoreErrorSchema = z.unknown();

export const listVectorStoreFilesDataSchema = z.object({
  path: z.object({
    vector_store_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      filter: z
        .union([z.literal('in_progress'), z.literal('completed'), z.literal('failed'), z.literal('cancelled')])
        .optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listVectorStoreFilesResponseSchema = z.object({
  object: z.string(),
  data: z.array(vectorStoreFileObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const listVectorStoreFilesErrorSchema = z.unknown();

export const createVectorStoreFileResponseSchema = vectorStoreFileObjectSchema;

export const createVectorStoreFileErrorSchema = z.unknown();

export const getVectorStoreFileDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
    vector_store_id: z.string(),
  }),
});

export const getVectorStoreFileResponseSchema = vectorStoreFileObjectSchema;

export const getVectorStoreFileErrorSchema = z.unknown();

export const deleteVectorStoreFileDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
    vector_store_id: z.string(),
  }),
});

export const deleteVectorStoreFileResponse2Schema = deleteVectorStoreFileResponseSchema;

export const deleteVectorStoreFileErrorSchema = z.unknown();

export const createVectorStoreFileBatchResponseSchema = vectorStoreFileBatchObjectSchema;

export const createVectorStoreFileBatchErrorSchema = z.unknown();

export const getVectorStoreFileBatchDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
    vector_store_id: z.string(),
  }),
});

export const getVectorStoreFileBatchResponseSchema = vectorStoreFileBatchObjectSchema;

export const getVectorStoreFileBatchErrorSchema = z.unknown();

export const cancelVectorStoreFileBatchDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
    vector_store_id: z.string(),
  }),
});

export const cancelVectorStoreFileBatchResponseSchema = vectorStoreFileBatchObjectSchema;

export const cancelVectorStoreFileBatchErrorSchema = z.unknown();

export const listFilesInVectorStoreBatchDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
    vector_store_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      before: z.string().optional(),
      filter: z
        .union([z.literal('in_progress'), z.literal('completed'), z.literal('failed'), z.literal('cancelled')])
        .optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    })
    .optional(),
});

export const listFilesInVectorStoreBatchResponseSchema = listVectorStoreFilesResponseSchema;

export const listFilesInVectorStoreBatchErrorSchema = z.unknown();

export const createBatchDataSchema = z.object({
  body: z.object({
    input_file_id: z.string(),
    endpoint: z.union([z.literal('/v1/chat/completions'), z.literal('/v1/embeddings'), z.literal('/v1/completions')]),
    completion_window: z.literal('24h'),
    metadata: z.record(z.string()).optional().nullable(),
  }),
});

export const createBatchResponseSchema = batchSchema;

export const createBatchErrorSchema = z.unknown();

export const listBatchesDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listBatchesResponse2Schema = listBatchesResponseSchema;

export const listBatchesErrorSchema = z.unknown();

export const retrieveBatchDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
  }),
});

export const retrieveBatchResponseSchema = batchSchema;

export const retrieveBatchErrorSchema = z.unknown();

export const cancelBatchDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
  }),
});

export const cancelBatchResponseSchema = batchSchema;

export const cancelBatchErrorSchema = z.unknown();

export const listAuditLogsDataSchema = z.object({
  query: z
    .object({
      'actor_emails[]': z.array(z.string()).optional(),
      'actor_ids[]': z.array(z.string()).optional(),
      after: z.string().optional(),
      before: z.string().optional(),
      effective_at: z
        .object({
          gt: z.number().optional(),
          gte: z.number().optional(),
          lt: z.number().optional(),
          lte: z.number().optional(),
        })
        .optional(),
      'event_types[]': z.array(auditLogEventTypeSchema).optional(),
      limit: z.number().optional(),
      'project_ids[]': z.array(z.string()).optional(),
      'resource_ids[]': z.array(z.string()).optional(),
    })
    .optional(),
});

export const listAuditLogsErrorSchema = z.unknown();

export const listInvitesDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listInvitesResponseSchema = inviteListResponseSchema;

export const listInvitesErrorSchema = z.unknown();

export const inviteUserDataSchema = z.object({
  body: inviteRequestSchema,
});

export const inviteUserResponseSchema = inviteSchema;

export const inviteUserErrorSchema = z.unknown();

export const retrieveInviteDataSchema = z.object({
  path: z.object({
    invite_id: z.string(),
  }),
});

export const retrieveInviteResponseSchema = inviteSchema;

export const retrieveInviteErrorSchema = z.unknown();

export const deleteInviteDataSchema = z.object({
  path: z.object({
    invite_id: z.string(),
  }),
});

export const deleteInviteResponseSchema = inviteDeleteResponseSchema;

export const deleteInviteErrorSchema = z.unknown();

export const listUsersDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listUsersResponseSchema = userListResponseSchema;

export const listUsersErrorSchema = z.unknown();

export const retrieveUserDataSchema = z.object({
  path: z.object({
    user_id: z.string(),
  }),
});

export const retrieveUserResponseSchema = userSchema;

export const retrieveUserErrorSchema = z.unknown();

export const modifyUserDataSchema = z.object({
  body: userRoleUpdateRequestSchema,
});

export const modifyUserResponseSchema = userSchema;

export const modifyUserErrorSchema = z.unknown();

export const deleteUserDataSchema = z.object({
  path: z.object({
    user_id: z.string(),
  }),
});

export const deleteUserResponseSchema = userDeleteResponseSchema;

export const deleteUserErrorSchema = z.unknown();

export const listProjectsDataSchema = z.object({
  query: z
    .object({
      after: z.string().optional(),
      include_archived: z.boolean().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listProjectsResponseSchema = projectListResponseSchema;

export const listProjectsErrorSchema = z.unknown();

export const createProjectDataSchema = z.object({
  body: projectCreateRequestSchema,
});

export const createProjectResponseSchema = projectSchema;

export const createProjectErrorSchema = z.unknown();

export const retrieveProjectDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
});

export const retrieveProjectResponseSchema = projectSchema;

export const retrieveProjectErrorSchema = z.unknown();

export const modifyProjectDataSchema = z.object({
  body: projectUpdateRequestSchema,
});

export const modifyProjectResponseSchema = projectSchema;

export const modifyProjectErrorSchema = errorResponseSchema;

export const archiveProjectDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
});

export const archiveProjectResponseSchema = projectSchema;

export const archiveProjectErrorSchema = z.unknown();

export const listProjectUsersDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listProjectUsersResponseSchema = projectUserListResponseSchema;

export const listProjectUsersErrorSchema = errorResponseSchema;

export const createProjectUserDataSchema = z.object({
  body: projectUserCreateRequestSchema,
  path: z.object({
    project_id: z.string(),
  }),
});

export const createProjectUserResponseSchema = projectUserSchema;

export const createProjectUserErrorSchema = errorResponseSchema;

export const retrieveProjectUserDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
    user_id: z.string(),
  }),
});

export const retrieveProjectUserResponseSchema = projectUserSchema;

export const retrieveProjectUserErrorSchema = z.unknown();

export const modifyProjectUserDataSchema = z.object({
  body: projectUserUpdateRequestSchema,
});

export const modifyProjectUserResponseSchema = projectUserSchema;

export const modifyProjectUserErrorSchema = errorResponseSchema;

export const deleteProjectUserDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
    user_id: z.string(),
  }),
});

export const deleteProjectUserResponseSchema = projectUserDeleteResponseSchema;

export const deleteProjectUserErrorSchema = errorResponseSchema;

export const listProjectServiceAccountsDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const listProjectServiceAccountsResponseSchema = projectServiceAccountListResponseSchema;

export const listProjectServiceAccountsErrorSchema = errorResponseSchema;

export const createProjectServiceAccountDataSchema = z.object({
  body: projectServiceAccountCreateRequestSchema,
  path: z.object({
    project_id: z.string(),
  }),
});

export const createProjectServiceAccountResponseSchema = projectServiceAccountCreateResponseSchema;

export const createProjectServiceAccountErrorSchema = errorResponseSchema;

export const retrieveProjectServiceAccountDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
    service_account_id: z.string(),
  }),
});

export const retrieveProjectServiceAccountResponseSchema = projectServiceAccountSchema;

export const retrieveProjectServiceAccountErrorSchema = z.unknown();

export const deleteProjectServiceAccountDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
    service_account_id: z.string(),
  }),
});

export const deleteProjectServiceAccountResponseSchema = projectServiceAccountDeleteResponseSchema;

export const deleteProjectServiceAccountErrorSchema = z.unknown();

export const listProjectApiKeysDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
  query: z
    .object({
      after: z.string().optional(),
      limit: z.number().optional(),
    })
    .optional(),
});

export const projectApiKeyListResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(projectApiKeySchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const listProjectApiKeysErrorSchema = z.unknown();

export const retrieveProjectApiKeyDataSchema = z.object({
  path: z.object({
    key_id: z.string(),
    project_id: z.string(),
  }),
});

export const retrieveProjectApiKeyResponseSchema = projectApiKeySchema;

export const retrieveProjectApiKeyErrorSchema = z.unknown();

export const deleteProjectApiKeyDataSchema = z.object({
  path: z.object({
    key_id: z.string(),
    project_id: z.string(),
  }),
});

export const deleteProjectApiKeyResponseSchema = projectApiKeyDeleteResponseSchema;

export const deleteProjectApiKeyErrorSchema = errorResponseSchema;

export const responseFormatJsonSchemaSchema = z.object({
  type: z.literal('json_schema'),
  json_schema: z.object({
    description: z.string().optional(),
    name: z.string(),
    schema: responseFormatJsonSchemaSchemaSchema.optional(),
    strict: z.boolean().optional().nullable(),
  }),
});

export const auditLogActorApiKeySchema = z.object({
  id: z.string().optional(),
  type: z.union([z.literal('user'), z.literal('service_account')]).optional(),
  user: auditLogActorUserSchema.optional(),
  service_account: auditLogActorServiceAccountSchema.optional(),
});

export const chatCompletionRequestAssistantMessageContentPartSchema = z.union([
  chatCompletionRequestMessageContentPartTextSchema,
  chatCompletionRequestMessageContentPartRefusalSchema,
]);

export const chatCompletionRequestAssistantMessageSchema = z.object({
  content: z
    .union([z.string(), z.array(chatCompletionRequestAssistantMessageContentPartSchema)])
    .optional()
    .nullable(),
  refusal: z.string().optional().nullable(),
  role: z.literal('assistant'),
  name: z.string().optional(),
  tool_calls: chatCompletionMessageToolCallsSchema.optional(),
  function_call: z
    .object({
      arguments: z.string(),
      name: z.string(),
    })
    .optional()
    .nullable(),
});

export const chunkingStrategyRequestParamSchema = z.union([
  autoChunkingStrategyRequestParamSchema,
  staticChunkingStrategyRequestParamSchema,
]);

export const assistantsApiResponseFormatOptionSchema = z.union([
  z.literal('auto'),
  responseFormatTextSchema,
  responseFormatJsonObjectSchema,
  responseFormatJsonSchemaSchema,
]);

export const chatCompletionRequestMessageSchema = z.union([
  chatCompletionRequestSystemMessageSchema,
  chatCompletionRequestUserMessageSchema,
  chatCompletionRequestAssistantMessageSchema,
  chatCompletionRequestToolMessageSchema,
  chatCompletionRequestFunctionMessageSchema,
]);

export const createRunRequestSchema = z.object({
  assistant_id: z.string(),
  model: z
    .union([
      z.string(),
      z.literal('gpt-4o'),
      z.literal('gpt-4o-2024-08-06'),
      z.literal('gpt-4o-2024-05-13'),
      z.literal('gpt-4o-mini'),
      z.literal('gpt-4o-mini-2024-07-18'),
      z.literal('gpt-4-turbo'),
      z.literal('gpt-4-turbo-2024-04-09'),
      z.literal('gpt-4-0125-preview'),
      z.literal('gpt-4-turbo-preview'),
      z.literal('gpt-4-1106-preview'),
      z.literal('gpt-4-vision-preview'),
      z.literal('gpt-4'),
      z.literal('gpt-4-0314'),
      z.literal('gpt-4-0613'),
      z.literal('gpt-4-32k'),
      z.literal('gpt-4-32k-0314'),
      z.literal('gpt-4-32k-0613'),
      z.literal('gpt-3.5-turbo'),
      z.literal('gpt-3.5-turbo-16k'),
      z.literal('gpt-3.5-turbo-0613'),
      z.literal('gpt-3.5-turbo-1106'),
      z.literal('gpt-3.5-turbo-0125'),
      z.literal('gpt-3.5-turbo-16k-0613'),
    ])
    .optional()
    .nullable(),
  instructions: z.string().optional().nullable(),
  additional_instructions: z.string().optional().nullable(),
  additional_messages: z.array(createMessageRequestSchema).optional().nullable(),
  tools: z
    .array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema]))
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  stream: z.boolean().optional().nullable(),
  max_prompt_tokens: z.number().optional().nullable(),
  max_completion_tokens: z.number().optional().nullable(),
  truncation_strategy: truncationObjectSchema.optional(),
  tool_choice: assistantsApiToolChoiceOptionSchema.optional(),
  parallel_tool_calls: parallelToolCallsSchema.optional(),
  response_format: assistantsApiResponseFormatOptionSchema.optional(),
});

export const createThreadAndRunRequestSchema = z.object({
  assistant_id: z.string(),
  thread: createThreadRequestSchema.optional(),
  model: z
    .union([
      z.string(),
      z.literal('gpt-4o'),
      z.literal('gpt-4o-2024-08-06'),
      z.literal('gpt-4o-2024-05-13'),
      z.literal('gpt-4o-mini'),
      z.literal('gpt-4o-mini-2024-07-18'),
      z.literal('gpt-4-turbo'),
      z.literal('gpt-4-turbo-2024-04-09'),
      z.literal('gpt-4-0125-preview'),
      z.literal('gpt-4-turbo-preview'),
      z.literal('gpt-4-1106-preview'),
      z.literal('gpt-4-vision-preview'),
      z.literal('gpt-4'),
      z.literal('gpt-4-0314'),
      z.literal('gpt-4-0613'),
      z.literal('gpt-4-32k'),
      z.literal('gpt-4-32k-0314'),
      z.literal('gpt-4-32k-0613'),
      z.literal('gpt-3.5-turbo'),
      z.literal('gpt-3.5-turbo-16k'),
      z.literal('gpt-3.5-turbo-0613'),
      z.literal('gpt-3.5-turbo-1106'),
      z.literal('gpt-3.5-turbo-0125'),
      z.literal('gpt-3.5-turbo-16k-0613'),
    ])
    .optional()
    .nullable(),
  instructions: z.string().optional().nullable(),
  tools: z
    .array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema]))
    .optional()
    .nullable(),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .object({
          vector_store_ids: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  stream: z.boolean().optional().nullable(),
  max_prompt_tokens: z.number().optional().nullable(),
  max_completion_tokens: z.number().optional().nullable(),
  truncation_strategy: truncationObjectSchema.optional(),
  tool_choice: assistantsApiToolChoiceOptionSchema.optional(),
  parallel_tool_calls: parallelToolCallsSchema.optional(),
  response_format: assistantsApiResponseFormatOptionSchema.optional(),
});

export const createTranscriptionResponseVerboseJsonSchema = z.object({
  language: z.string(),
  duration: z.string(),
  text: z.string(),
  words: z.array(transcriptionWordSchema).optional(),
  segments: z.array(transcriptionSegmentSchema).optional(),
});

export const createVectorStoreFileBatchRequestSchema = z.object({
  file_ids: z.array(z.string()),
  chunking_strategy: chunkingStrategyRequestParamSchema.optional(),
});

export const createVectorStoreFileRequestSchema = z.object({
  file_id: z.string(),
  chunking_strategy: chunkingStrategyRequestParamSchema.optional(),
});

export const fineTuneChatCompletionRequestAssistantMessageSchema = z
  .object({
    weight: z.union([z.literal(0), z.literal(1)]).optional(),
  })
  .and(chatCompletionRequestAssistantMessageSchema);

export const finetuneChatRequestInputSchema = z.object({
  messages: z
    .array(
      z.union([
        chatCompletionRequestSystemMessageSchema,
        chatCompletionRequestUserMessageSchema,
        fineTuneChatCompletionRequestAssistantMessageSchema,
        chatCompletionRequestToolMessageSchema,
        chatCompletionRequestFunctionMessageSchema,
      ]),
    )
    .optional(),
  tools: z.array(chatCompletionToolSchema).optional(),
  parallel_tool_calls: parallelToolCallsSchema.optional(),
  functions: z.array(chatCompletionFunctionsSchema).optional(),
});

export const assistantObjectSchema = z.object({
  id: z.string(),
  object: z.literal('assistant'),
  created_at: z.number(),
  name: z.string().nullable(),
  description: z.string().nullable(),
  model: z.string(),
  instructions: z.string().nullable(),
  tools: z.array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema])),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .object({
          vector_store_ids: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  response_format: assistantsApiResponseFormatOptionSchema.optional(),
});

export const runObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread.run'),
  created_at: z.number(),
  thread_id: z.string(),
  assistant_id: z.string(),
  status: z.union([
    z.literal('queued'),
    z.literal('in_progress'),
    z.literal('requires_action'),
    z.literal('cancelling'),
    z.literal('cancelled'),
    z.literal('failed'),
    z.literal('completed'),
    z.literal('incomplete'),
    z.literal('expired'),
  ]),
  required_action: z
    .object({
      type: z.literal('submit_tool_outputs'),
      submit_tool_outputs: z.object({
        tool_calls: z.array(runToolCallObjectSchema),
      }),
    })
    .nullable(),
  last_error: z
    .object({
      code: z.union([z.literal('server_error'), z.literal('rate_limit_exceeded'), z.literal('invalid_prompt')]),
      message: z.string(),
    })
    .nullable(),
  expires_at: z.number().nullable(),
  started_at: z.number().nullable(),
  cancelled_at: z.number().nullable(),
  failed_at: z.number().nullable(),
  completed_at: z.number().nullable(),
  incomplete_details: z
    .object({
      reason: z.union([z.literal('max_completion_tokens'), z.literal('max_prompt_tokens')]).optional(),
    })
    .nullable(),
  model: z.string(),
  instructions: z.string(),
  tools: z.array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema])),
  metadata: z.record(z.unknown()).nullable(),
  usage: runCompletionUsageSchema,
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  max_prompt_tokens: z.number().nullable(),
  max_completion_tokens: z.number().nullable(),
  truncation_strategy: truncationObjectSchema,
  tool_choice: assistantsApiToolChoiceOptionSchema,
  parallel_tool_calls: parallelToolCallsSchema,
  response_format: assistantsApiResponseFormatOptionSchema,
});

export const listThreadsResponseSchema = z.object({
  object: z.string(),
  data: z.array(threadObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const modifyAssistantRequestSchema = z.object({
  model: z.string().optional(),
  name: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  instructions: z.string().optional().nullable(),
  tools: z
    .array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema]))
    .optional(),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .object({
          vector_store_ids: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  response_format: assistantsApiResponseFormatOptionSchema.optional(),
});

export const runStepDeltaStepDetailsToolCallsObjectSchema = z.object({
  type: z.literal('tool_calls'),
  tool_calls: z
    .array(
      z.union([
        runStepDeltaStepDetailsToolCallsCodeObjectSchema,
        runStepDeltaStepDetailsToolCallsFileSearchObjectSchema,
        runStepDeltaStepDetailsToolCallsFunctionObjectSchema,
      ]),
    )
    .optional(),
});

export const runStepDeltaObjectSchema = z.object({
  id: z.string(),
  object: z.literal('thread.run.step.delta'),
  delta: z.object({
    step_details: z
      .union([runStepDeltaStepDetailsMessageCreationObjectSchema, runStepDeltaStepDetailsToolCallsObjectSchema])
      .optional(),
  }),
});

export const runStreamEventSchema = z.union([
  z.object({
    event: z.literal('thread.run.created'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.queued'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.in_progress'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.requires_action'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.completed'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.incomplete'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.failed'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.cancelling'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.cancelled'),
    data: runObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.expired'),
    data: runObjectSchema,
  }),
]);

export const createChatCompletionRequestSchema = z.object({
  messages: z.array(chatCompletionRequestMessageSchema),
  model: z.union([
    z.string(),
    z.literal('gpt-4o'),
    z.literal('gpt-4o-2024-08-06'),
    z.literal('gpt-4o-2024-05-13'),
    z.literal('gpt-4o-mini'),
    z.literal('gpt-4o-mini-2024-07-18'),
    z.literal('gpt-4-turbo'),
    z.literal('gpt-4-turbo-2024-04-09'),
    z.literal('gpt-4-0125-preview'),
    z.literal('gpt-4-turbo-preview'),
    z.literal('gpt-4-1106-preview'),
    z.literal('gpt-4-vision-preview'),
    z.literal('gpt-4'),
    z.literal('gpt-4-0314'),
    z.literal('gpt-4-0613'),
    z.literal('gpt-4-32k'),
    z.literal('gpt-4-32k-0314'),
    z.literal('gpt-4-32k-0613'),
    z.literal('gpt-3.5-turbo'),
    z.literal('gpt-3.5-turbo-16k'),
    z.literal('gpt-3.5-turbo-0301'),
    z.literal('gpt-3.5-turbo-0613'),
    z.literal('gpt-3.5-turbo-1106'),
    z.literal('gpt-3.5-turbo-0125'),
    z.literal('gpt-3.5-turbo-16k-0613'),
  ]),
  frequency_penalty: z.number().optional().nullable(),
  logit_bias: z.record(z.number()).optional().nullable(),
  logprobs: z.boolean().optional().nullable(),
  top_logprobs: z.number().optional().nullable(),
  max_tokens: z.number().optional().nullable(),
  n: z.number().optional().nullable(),
  presence_penalty: z.number().optional().nullable(),
  response_format: z
    .union([responseFormatTextSchema, responseFormatJsonObjectSchema, responseFormatJsonSchemaSchema])
    .optional(),
  seed: z.number().optional().nullable(),
  service_tier: z
    .union([z.literal('auto'), z.literal('default')])
    .optional()
    .nullable(),
  stop: z
    .union([z.string(), z.array(z.string())])
    .optional()
    .nullable(),
  stream: z.boolean().optional().nullable(),
  stream_options: chatCompletionStreamOptionsSchema.optional(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  tools: z.array(chatCompletionToolSchema).optional(),
  tool_choice: chatCompletionToolChoiceOptionSchema.optional(),
  parallel_tool_calls: parallelToolCallsSchema.optional(),
  user: z.string().optional(),
  function_call: z.union([z.literal('none'), z.literal('auto'), chatCompletionFunctionCallOptionSchema]).optional(),
  functions: z.array(chatCompletionFunctionsSchema).optional(),
});

export const createEmbeddingResponse2Schema = createEmbeddingResponseSchema;

export const createTranscriptionResponseSchema = z.union([
  createTranscriptionResponseJsonSchema,
  createTranscriptionResponseVerboseJsonSchema,
]);

export const listFilesResponse2Schema = listFilesResponseSchema;

export const listModelsResponse2Schema = listModelsResponseSchema;

export const listAssistantsResponseSchema = z.object({
  object: z.string(),
  data: z.array(assistantObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const createAssistantRequestSchema = z.object({
  model: z.union([
    z.string(),
    z.literal('gpt-4o'),
    z.literal('gpt-4o-2024-08-06'),
    z.literal('gpt-4o-2024-05-13'),
    z.literal('gpt-4o-mini'),
    z.literal('gpt-4o-mini-2024-07-18'),
    z.literal('gpt-4-turbo'),
    z.literal('gpt-4-turbo-2024-04-09'),
    z.literal('gpt-4-0125-preview'),
    z.literal('gpt-4-turbo-preview'),
    z.literal('gpt-4-1106-preview'),
    z.literal('gpt-4-vision-preview'),
    z.literal('gpt-4'),
    z.literal('gpt-4-0314'),
    z.literal('gpt-4-0613'),
    z.literal('gpt-4-32k'),
    z.literal('gpt-4-32k-0314'),
    z.literal('gpt-4-32k-0613'),
    z.literal('gpt-3.5-turbo'),
    z.literal('gpt-3.5-turbo-16k'),
    z.literal('gpt-3.5-turbo-0613'),
    z.literal('gpt-3.5-turbo-1106'),
    z.literal('gpt-3.5-turbo-0125'),
    z.literal('gpt-3.5-turbo-16k-0613'),
  ]),
  name: z.string().optional().nullable(),
  description: z.string().optional().nullable(),
  instructions: z.string().optional().nullable(),
  tools: z
    .array(z.union([assistantToolsCodeSchema, assistantToolsFileSearchSchema, assistantToolsFunctionSchema]))
    .optional(),
  tool_resources: z
    .object({
      code_interpreter: z
        .object({
          file_ids: z.array(z.string()).optional(),
        })
        .optional(),
      file_search: z
        .unknown()
        .and(
          z.object({
            vector_store_ids: z.array(z.string()).optional(),
            vector_stores: z
              .array(
                z.object({
                  file_ids: z.array(z.string()).optional(),
                  chunking_strategy: z
                    .union([
                      z.object({
                        type: z.literal('auto'),
                      }),
                      z.object({
                        type: z.literal('static'),
                        static: z.object({
                          max_chunk_size_tokens: z.number(),
                          chunk_overlap_tokens: z.number(),
                        }),
                      }),
                    ])
                    .optional(),
                  metadata: z.record(z.unknown()).optional(),
                }),
              )
              .optional(),
          }),
        )
        .optional(),
    })
    .optional()
    .nullable(),
  metadata: z.record(z.unknown()).optional().nullable(),
  temperature: z.number().optional().nullable(),
  top_p: z.number().optional().nullable(),
  response_format: assistantsApiResponseFormatOptionSchema.optional(),
});

export const createAssistantResponseSchema = assistantObjectSchema;

export const getAssistantResponseSchema = assistantObjectSchema;

export const modifyAssistantDataSchema = z.object({
  body: modifyAssistantRequestSchema,
  path: z.object({
    assistant_id: z.string(),
  }),
});

export const modifyAssistantResponseSchema = assistantObjectSchema;

export const listMessagesResponse2Schema = listMessagesResponseSchema;

export const createThreadAndRunDataSchema = z.object({
  body: createThreadAndRunRequestSchema,
});

export const createThreadAndRunResponseSchema = runObjectSchema;

export const listRunsResponseSchema = z.object({
  object: z.string(),
  data: z.array(runObjectSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const createRunDataSchema = z.object({
  body: createRunRequestSchema,
  path: z.object({
    thread_id: z.string(),
  }),
});

export const createRunResponseSchema = runObjectSchema;

export const getRunResponseSchema = runObjectSchema;

export const modifyRunResponseSchema = runObjectSchema;

export const submitToolOuputsToRunResponseSchema = runObjectSchema;

export const cancelRunResponseSchema = runObjectSchema;

export const listRunStepsResponse2Schema = listRunStepsResponseSchema;

export const listVectorStoresResponse2Schema = listVectorStoresResponseSchema;

export const createVectorStoreDataSchema = z.object({
  body: createVectorStoreRequestSchema,
});

export const listVectorStoreFilesResponse2Schema = listVectorStoreFilesResponseSchema;

export const createVectorStoreFileDataSchema = z.object({
  body: createVectorStoreFileRequestSchema,
  path: z.object({
    vector_store_id: z.string(),
  }),
});

export const createVectorStoreFileBatchDataSchema = z.object({
  body: createVectorStoreFileBatchRequestSchema,
  path: z.object({
    vector_store_id: z.string(),
  }),
});

export const listProjectApiKeysResponseSchema = projectApiKeyListResponseSchema;

export const runStepStreamEventSchema = z.union([
  z.object({
    event: z.literal('thread.run.step.created'),
    data: runStepObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.in_progress'),
    data: runStepObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.delta'),
    data: runStepDeltaObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.completed'),
    data: runStepObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.failed'),
    data: runStepObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.cancelled'),
    data: runStepObjectSchema,
  }),
  z.object({
    event: z.literal('thread.run.step.expired'),
    data: runStepObjectSchema,
  }),
]);

export const auditLogActorSchema = z.object({
  type: z.union([z.literal('session'), z.literal('api_key')]).optional(),
  session: auditLogActorSessionSchema.optional(),
  api_key: auditLogActorApiKeySchema.optional(),
});

export const auditLogSchema = z.object({
  id: z.string(),
  type: auditLogEventTypeSchema,
  effective_at: z.number(),
  project: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  actor: auditLogActorSchema,
  'api_key.created': z
    .object({
      id: z.string().optional(),
      data: z
        .object({
          scopes: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional(),
  'api_key.updated': z
    .object({
      id: z.string().optional(),
      changes_requested: z
        .object({
          scopes: z.array(z.string()).optional(),
        })
        .optional(),
    })
    .optional(),
  'api_key.deleted': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
  'invite.sent': z
    .object({
      id: z.string().optional(),
      data: z
        .object({
          email: z.string().optional(),
          role: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'invite.accepted': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
  'invite.deleted': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
  'login.failed': z
    .object({
      error_code: z.string().optional(),
      error_message: z.string().optional(),
    })
    .optional(),
  'logout.failed': z
    .object({
      error_code: z.string().optional(),
      error_message: z.string().optional(),
    })
    .optional(),
  'organization.updated': z
    .object({
      id: z.string().optional(),
      changes_requested: z
        .object({
          title: z.string().optional(),
          description: z.string().optional(),
          name: z.string().optional(),
          settings: z
            .object({
              threads_ui_visibility: z.string().optional(),
              usage_dashboard_visibility: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
    })
    .optional(),
  'project.created': z
    .object({
      id: z.string().optional(),
      data: z
        .object({
          name: z.string().optional(),
          title: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'project.updated': z
    .object({
      id: z.string().optional(),
      changes_requested: z
        .object({
          title: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'project.archived': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
  'service_account.created': z
    .object({
      id: z.string().optional(),
      data: z
        .object({
          role: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'service_account.updated': z
    .object({
      id: z.string().optional(),
      changes_requested: z
        .object({
          role: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'service_account.deleted': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
  'user.added': z
    .object({
      id: z.string().optional(),
      data: z
        .object({
          role: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'user.updated': z
    .object({
      id: z.string().optional(),
      changes_requested: z
        .object({
          role: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  'user.deleted': z
    .object({
      id: z.string().optional(),
    })
    .optional(),
});

export const createChatCompletionDataSchema = z.object({
  body: createChatCompletionRequestSchema,
});

export const listAssistantsResponse2Schema = listAssistantsResponseSchema;

export const createAssistantDataSchema = z.object({
  body: createAssistantRequestSchema,
});

export const listRunsResponse2Schema = listRunsResponseSchema;

export const listAuditLogsResponseSchema = z.object({
  object: z.literal('list'),
  data: z.array(auditLogSchema),
  first_id: z.string(),
  last_id: z.string(),
  has_more: z.boolean(),
});

export const assistantStreamEventSchema = z.union([
  threadStreamEventSchema,
  runStreamEventSchema,
  runStepStreamEventSchema,
  messageStreamEventSchema,
  errorEventSchema,
  doneEventSchema,
]);

export const listAuditLogsResponse2Schema = listAuditLogsResponseSchema;
