// This file is auto-generated by @hey-api/openapi-ts

export type AddUploadPartRequest = {
  /**
   * The chunk of bytes for this Part.
   *
   */
  data: Blob | File;
};

/**
 * Represents an `assistant` that can call the model and use tools.
 */
export type AssistantObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `assistant`.
   */
  object: 'assistant';
  /**
   * The Unix timestamp (in seconds) for when the assistant was created.
   */
  created_at: number;
  /**
   * The name of the assistant. The maximum length is 256 characters.
   *
   */
  name: string | null;
  /**
   * The description of the assistant. The maximum length is 512 characters.
   *
   */
  description: string | null;
  /**
   * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
   *
   */
  model: string;
  /**
   * The system instructions that the assistant uses. The maximum length is 256,000 characters.
   *
   */
  instructions: string | null;
  /**
   * A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.
   *
   */
  tools: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction>;
  /**
   * A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter`` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: {
      /**
       * The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
       *
       */
      vector_store_ids?: Array<string>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
  /**
   * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
   *
   */
  temperature?: number | null;
  /**
   * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
   *
   * We generally recommend altering this or temperature but not both.
   *
   */
  top_p?: number | null;
  response_format?: AssistantsApiResponseFormatOption;
};

/**
 * The object type, which is always `assistant`.
 */
export type OpenAiObject = 'assistant';

/**
 * Specifies the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4 Turbo](/docs/models/gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models since `gpt-3.5-turbo-1106`.
 *
 * Setting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).
 *
 * Setting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.
 *
 * **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.
 *
 */
export type AssistantsApiResponseFormatOption =
  | 'auto'
  | ResponseFormatText
  | ResponseFormatJsonObject
  | ResponseFormatJsonSchema;

/**
 * Controls which (if any) tool is called by the model.
 * `none` means the model will not call any tools and instead generates a message.
 * `auto` is the default value and means the model can pick between generating a message or calling one or more tools.
 * `required` means the model must call one or more tools before responding to the user.
 * Specifying a particular tool like `{"type": "file_search"}` or `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.
 *
 */
export type AssistantsApiToolChoiceOption = 'none' | 'auto' | 'required' | AssistantsNamedToolChoice;

/**
 * Specifies a tool the model should use. Use to force the model to call a specific tool.
 */
export type AssistantsNamedToolChoice = {
  /**
   * The type of the tool. If type is `function`, the function name must be set
   */
  type: 'function' | 'code_interpreter' | 'file_search';
  function?: {
    /**
     * The name of the function to call.
     */
    name: string;
  };
};

/**
 * The type of the tool. If type is `function`, the function name must be set
 */
export type type = 'function' | 'code_interpreter' | 'file_search';

/**
 * Represents an event emitted when streaming a Run.
 *
 * Each event in a server-sent events stream has an `event` and `data` property:
 *
 * ```
 * event: thread.created
 * data: {"id": "thread_123", "object": "thread", ...}
 * ```
 *
 * We emit events whenever a new object is created, transitions to a new state, or is being
 * streamed in parts (deltas). For example, we emit `thread.run.created` when a new run
 * is created, `thread.run.completed` when a run completes, and so on. When an Assistant chooses
 * to create a message during a run, we emit a `thread.message.created event`, a
 * `thread.message.in_progress` event, many `thread.message.delta` events, and finally a
 * `thread.message.completed` event.
 *
 * We may add additional events over time, so we recommend handling unknown events gracefully
 * in your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to
 * integrate the Assistants API with streaming.
 *
 */
export type AssistantStreamEvent =
  | ThreadStreamEvent
  | RunStreamEvent
  | RunStepStreamEvent
  | MessageStreamEvent
  | ErrorEvent
  | DoneEvent;

export type AssistantToolsCode = {
  /**
   * The type of tool being defined: `code_interpreter`
   */
  type: 'code_interpreter';
};

/**
 * The type of tool being defined: `code_interpreter`
 */
export type type2 = 'code_interpreter';

export type AssistantToolsFileSearch = {
  /**
   * The type of tool being defined: `file_search`
   */
  type: 'file_search';
  /**
   * Overrides for the file search tool.
   */
  file_search?: {
    /**
     * The maximum number of results the file search tool should output. The default is 20 for `gpt-4*` models and 5 for `gpt-3.5-turbo`. This number should be between 1 and 50 inclusive.
     *
     * Note that the file search tool may output fewer than `max_num_results` results. See the [file search tool documentation](/docs/assistants/tools/file-search/number-of-chunks-returned) for more information.
     *
     */
    max_num_results?: number;
  };
};

/**
 * The type of tool being defined: `file_search`
 */
export type type3 = 'file_search';

export type AssistantToolsFileSearchTypeOnly = {
  /**
   * The type of tool being defined: `file_search`
   */
  type: 'file_search';
};

export type AssistantToolsFunction = {
  /**
   * The type of tool being defined: `function`
   */
  type: 'function';
  function: FunctionObject;
};

/**
 * The type of tool being defined: `function`
 */
export type type4 = 'function';

/**
 * A log of a user action or configuration change within this organization.
 */
export type AuditLog = {
  /**
   * The ID of this log.
   */
  id: string;
  type: AuditLogEventType;
  /**
   * The Unix timestamp (in seconds) of the event.
   */
  effective_at: number;
  /**
   * The project that the action was scoped to. Absent for actions not scoped to projects.
   */
  project?: {
    /**
     * The project ID.
     */
    id?: string;
    /**
     * The project title.
     */
    name?: string;
  };
  actor: AuditLogActor;
  /**
   * The details for events with this `type`.
   */
  'api_key.created'?: {
    /**
     * The tracking ID of the API key.
     */
    id?: string;
    /**
     * The payload used to create the API key.
     */
    data?: {
      /**
       * A list of scopes allowed for the API key, e.g. `["api.model.request"]`
       */
      scopes?: Array<string>;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'api_key.updated'?: {
    /**
     * The tracking ID of the API key.
     */
    id?: string;
    /**
     * The payload used to update the API key.
     */
    changes_requested?: {
      /**
       * A list of scopes allowed for the API key, e.g. `["api.model.request"]`
       */
      scopes?: Array<string>;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'api_key.deleted'?: {
    /**
     * The tracking ID of the API key.
     */
    id?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'invite.sent'?: {
    /**
     * The ID of the invite.
     */
    id?: string;
    /**
     * The payload used to create the invite.
     */
    data?: {
      /**
       * The email invited to the organization.
       */
      email?: string;
      /**
       * The role the email was invited to be. Is either `owner` or `member`.
       */
      role?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'invite.accepted'?: {
    /**
     * The ID of the invite.
     */
    id?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'invite.deleted'?: {
    /**
     * The ID of the invite.
     */
    id?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'login.failed'?: {
    /**
     * The error code of the failure.
     */
    error_code?: string;
    /**
     * The error message of the failure.
     */
    error_message?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'logout.failed'?: {
    /**
     * The error code of the failure.
     */
    error_code?: string;
    /**
     * The error message of the failure.
     */
    error_message?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'organization.updated'?: {
    /**
     * The organization ID.
     */
    id?: string;
    /**
     * The payload used to update the organization settings.
     */
    changes_requested?: {
      /**
       * The organization title.
       */
      title?: string;
      /**
       * The organization description.
       */
      description?: string;
      /**
       * The organization name.
       */
      name?: string;
      settings?: {
        /**
         * Visibility of the threads page which shows messages created with the Assistants API and Playground. One of `ANY_ROLE`, `OWNERS`, or `NONE`.
         */
        threads_ui_visibility?: string;
        /**
         * Visibility of the usage dashboard which shows activity and costs for your organization. One of `ANY_ROLE` or `OWNERS`.
         */
        usage_dashboard_visibility?: string;
      };
    };
  };
  /**
   * The details for events with this `type`.
   */
  'project.created'?: {
    /**
     * The project ID.
     */
    id?: string;
    /**
     * The payload used to create the project.
     */
    data?: {
      /**
       * The project name.
       */
      name?: string;
      /**
       * The title of the project as seen on the dashboard.
       */
      title?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'project.updated'?: {
    /**
     * The project ID.
     */
    id?: string;
    /**
     * The payload used to update the project.
     */
    changes_requested?: {
      /**
       * The title of the project as seen on the dashboard.
       */
      title?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'project.archived'?: {
    /**
     * The project ID.
     */
    id?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'service_account.created'?: {
    /**
     * The service account ID.
     */
    id?: string;
    /**
     * The payload used to create the service account.
     */
    data?: {
      /**
       * The role of the service account. Is either `owner` or `member`.
       */
      role?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'service_account.updated'?: {
    /**
     * The service account ID.
     */
    id?: string;
    /**
     * The payload used to updated the service account.
     */
    changes_requested?: {
      /**
       * The role of the service account. Is either `owner` or `member`.
       */
      role?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'service_account.deleted'?: {
    /**
     * The service account ID.
     */
    id?: string;
  };
  /**
   * The details for events with this `type`.
   */
  'user.added'?: {
    /**
     * The user ID.
     */
    id?: string;
    /**
     * The payload used to add the user to the project.
     */
    data?: {
      /**
       * The role of the user. Is either `owner` or `member`.
       */
      role?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'user.updated'?: {
    /**
     * The project ID.
     */
    id?: string;
    /**
     * The payload used to update the user.
     */
    changes_requested?: {
      /**
       * The role of the user. Is either `owner` or `member`.
       */
      role?: string;
    };
  };
  /**
   * The details for events with this `type`.
   */
  'user.deleted'?: {
    /**
     * The user ID.
     */
    id?: string;
  };
};

/**
 * The actor who performed the audit logged action.
 */
export type AuditLogActor = {
  /**
   * The type of actor. Is either `session` or `api_key`.
   */
  type?: 'session' | 'api_key';
  session?: AuditLogActorSession;
  api_key?: AuditLogActorApiKey;
};

/**
 * The type of actor. Is either `session` or `api_key`.
 */
export type type5 = 'session' | 'api_key';

/**
 * The API Key used to perform the audit logged action.
 */
export type AuditLogActorApiKey = {
  /**
   * The tracking id of the API key.
   */
  id?: string;
  /**
   * The type of API key. Can be either `user` or `service_account`.
   */
  type?: 'user' | 'service_account';
  user?: AuditLogActorUser;
  service_account?: AuditLogActorServiceAccount;
};

/**
 * The type of API key. Can be either `user` or `service_account`.
 */
export type type6 = 'user' | 'service_account';

/**
 * The service account that performed the audit logged action.
 */
export type AuditLogActorServiceAccount = {
  /**
   * The service account id.
   */
  id?: string;
};

/**
 * The session in which the audit logged action was performed.
 */
export type AuditLogActorSession = {
  user?: AuditLogActorUser;
  /**
   * The IP address from which the action was performed.
   */
  ip_address?: string;
};

/**
 * The user who performed the audit logged action.
 */
export type AuditLogActorUser = {
  /**
   * The user id.
   */
  id?: string;
  /**
   * The user email.
   */
  email?: string;
};

/**
 * The event type.
 */
export type AuditLogEventType =
  | 'api_key.created'
  | 'api_key.updated'
  | 'api_key.deleted'
  | 'invite.sent'
  | 'invite.accepted'
  | 'invite.deleted'
  | 'login.succeeded'
  | 'login.failed'
  | 'logout.succeeded'
  | 'logout.failed'
  | 'organization.updated'
  | 'project.created'
  | 'project.updated'
  | 'project.archived'
  | 'service_account.created'
  | 'service_account.updated'
  | 'service_account.deleted'
  | 'user.added'
  | 'user.updated'
  | 'user.deleted';

/**
 * The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
 */
export type AutoChunkingStrategyRequestParam = {
  /**
   * Always `auto`.
   */
  type: 'auto';
};

/**
 * Always `auto`.
 */
export type type7 = 'auto';

export type Batch = {
  id: string;
  /**
   * The object type, which is always `batch`.
   */
  object: 'batch';
  /**
   * The OpenAI API endpoint used by the batch.
   */
  endpoint: string;
  errors?: {
    /**
     * The object type, which is always `list`.
     */
    object?: string;
    data?: Array<{
      /**
       * An error code identifying the error type.
       */
      code?: string;
      /**
       * A human-readable message providing more details about the error.
       */
      message?: string;
      /**
       * The name of the parameter that caused the error, if applicable.
       */
      param?: string | null;
      /**
       * The line number of the input file where the error occurred, if applicable.
       */
      line?: number | null;
    }>;
  };
  /**
   * The ID of the input file for the batch.
   */
  input_file_id: string;
  /**
   * The time frame within which the batch should be processed.
   */
  completion_window: string;
  /**
   * The current status of the batch.
   */
  status: 'validating' | 'failed' | 'in_progress' | 'finalizing' | 'completed' | 'expired' | 'cancelling' | 'cancelled';
  /**
   * The ID of the file containing the outputs of successfully executed requests.
   */
  output_file_id?: string;
  /**
   * The ID of the file containing the outputs of requests with errors.
   */
  error_file_id?: string;
  /**
   * The Unix timestamp (in seconds) for when the batch was created.
   */
  created_at: number;
  /**
   * The Unix timestamp (in seconds) for when the batch started processing.
   */
  in_progress_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch will expire.
   */
  expires_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch started finalizing.
   */
  finalizing_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch was completed.
   */
  completed_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch failed.
   */
  failed_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch expired.
   */
  expired_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch started cancelling.
   */
  cancelling_at?: number;
  /**
   * The Unix timestamp (in seconds) for when the batch was cancelled.
   */
  cancelled_at?: number;
  /**
   * The request counts for different statuses within the batch.
   */
  request_counts?: {
    /**
     * Total number of requests in the batch.
     */
    total: number;
    /**
     * Number of requests that have been completed successfully.
     */
    completed: number;
    /**
     * Number of requests that have failed.
     */
    failed: number;
  };
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

/**
 * The object type, which is always `batch`.
 */
export type object2 = 'batch';

/**
 * The current status of the batch.
 */
export type status =
  | 'validating'
  | 'failed'
  | 'in_progress'
  | 'finalizing'
  | 'completed'
  | 'expired'
  | 'cancelling'
  | 'cancelled';

/**
 * The per-line object of the batch input file
 */
export type BatchRequestInput = {
  /**
   * A developer-provided per-request id that will be used to match outputs to inputs. Must be unique for each request in a batch.
   */
  custom_id?: string;
  /**
   * The HTTP method to be used for the request. Currently only `POST` is supported.
   */
  method?: 'POST';
  /**
   * The OpenAI API relative URL to be used for the request. Currently `/v1/chat/completions`, `/v1/embeddings`, and `/v1/completions` are supported.
   */
  url?: string;
};

/**
 * The HTTP method to be used for the request. Currently only `POST` is supported.
 */
export type method = 'POST';

/**
 * The per-line object of the batch output and error files
 */
export type BatchRequestOutput = {
  id?: string;
  /**
   * A developer-provided per-request id that will be used to match outputs to inputs.
   */
  custom_id?: string;
  response?: {
    /**
     * The HTTP status code of the response
     */
    status_code?: number;
    /**
     * An unique identifier for the OpenAI API request. Please include this request ID when contacting support.
     */
    request_id?: string;
    /**
     * The JSON body of the response
     */
    body?: {
      [key: string]: unknown;
    };
  } | null;
  /**
   * For requests that failed with a non-HTTP error, this will contain more information on the cause of the failure.
   */
  error?: {
    /**
     * A machine-readable error code.
     */
    code?: string;
    /**
     * A human-readable error message.
     */
    message?: string;
  } | null;
};

export type CancelUploadRequest = {
  [key: string]: unknown;
};

/**
 * Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
 *
 */
export type ChatCompletionFunctionCallOption = {
  /**
   * The name of the function to call.
   */
  name: string;
};

/**
 * @deprecated
 */
export type ChatCompletionFunctions = {
  /**
   * A description of what the function does, used by the model to choose when and how to call the function.
   */
  description?: string;
  /**
   * The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
   */
  name: string;
  parameters?: FunctionParameters;
};

export type ChatCompletionMessageToolCall = {
  /**
   * The ID of the tool call.
   */
  id: string;
  /**
   * The type of the tool. Currently, only `function` is supported.
   */
  type: 'function';
  /**
   * The function that the model called.
   */
  function: {
    /**
     * The name of the function to call.
     */
    name: string;
    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     */
    arguments: string;
  };
};

export type ChatCompletionMessageToolCallChunk = {
  index: number;
  /**
   * The ID of the tool call.
   */
  id?: string;
  /**
   * The type of the tool. Currently, only `function` is supported.
   */
  type?: 'function';
  function?: {
    /**
     * The name of the function to call.
     */
    name?: string;
    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     */
    arguments?: string;
  };
};

/**
 * The tool calls generated by the model, such as function calls.
 */
export type ChatCompletionMessageToolCalls = Array<ChatCompletionMessageToolCall>;

/**
 * Specifies a tool the model should use. Use to force the model to call a specific function.
 */
export type ChatCompletionNamedToolChoice = {
  /**
   * The type of the tool. Currently, only `function` is supported.
   */
  type: 'function';
  function: {
    /**
     * The name of the function to call.
     */
    name: string;
  };
};

export type ChatCompletionRequestAssistantMessage = {
  /**
   * The contents of the assistant message. Required unless `tool_calls` or `function_call` is specified.
   *
   */
  content?: (string | Array<ChatCompletionRequestAssistantMessageContentPart>) | null;
  /**
   * The refusal message by the assistant.
   */
  refusal?: string | null;
  /**
   * The role of the messages author, in this case `assistant`.
   */
  role: 'assistant';
  /**
   * An optional name for the participant. Provides the model information to differentiate between participants of the same role.
   */
  name?: string;
  tool_calls?: ChatCompletionMessageToolCalls;
  /**
   * Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
   * @deprecated
   */
  function_call?: {
    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     */
    arguments: string;
    /**
     * The name of the function to call.
     */
    name: string;
  } | null;
};

/**
 * The role of the messages author, in this case `assistant`.
 */
export type role = 'assistant';

export type ChatCompletionRequestAssistantMessageContentPart =
  | ChatCompletionRequestMessageContentPartText
  | ChatCompletionRequestMessageContentPartRefusal;

/**
 * @deprecated
 */
export type ChatCompletionRequestFunctionMessage = {
  /**
   * The role of the messages author, in this case `function`.
   */
  role: 'function';
  /**
   * The contents of the function message.
   */
  content: string | null;
  /**
   * The name of the function to call.
   */
  name: string;
};

/**
 * The role of the messages author, in this case `function`.
 */
export type role2 = 'function';

export type ChatCompletionRequestMessage =
  | ChatCompletionRequestSystemMessage
  | ChatCompletionRequestUserMessage
  | ChatCompletionRequestAssistantMessage
  | ChatCompletionRequestToolMessage
  | ChatCompletionRequestFunctionMessage;

export type ChatCompletionRequestMessageContentPartImage = {
  /**
   * The type of the content part.
   */
  type: 'image_url';
  image_url: {
    /**
     * Either a URL of the image or the base64 encoded image data.
     */
    url: string;
    /**
     * Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision/low-or-high-fidelity-image-understanding).
     */
    detail?: 'auto' | 'low' | 'high';
  };
};

/**
 * The type of the content part.
 */
export type type8 = 'image_url';

/**
 * Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision/low-or-high-fidelity-image-understanding).
 */
export type detail = 'auto' | 'low' | 'high';

export type ChatCompletionRequestMessageContentPartRefusal = {
  /**
   * The type of the content part.
   */
  type: 'refusal';
  /**
   * The refusal message generated by the model.
   */
  refusal: string;
};

/**
 * The type of the content part.
 */
export type type9 = 'refusal';

export type ChatCompletionRequestMessageContentPartText = {
  /**
   * The type of the content part.
   */
  type: 'text';
  /**
   * The text content.
   */
  text: string;
};

/**
 * The type of the content part.
 */
export type type10 = 'text';

export type ChatCompletionRequestSystemMessage = {
  /**
   * The contents of the system message.
   */
  content: string | Array<ChatCompletionRequestSystemMessageContentPart>;
  /**
   * The role of the messages author, in this case `system`.
   */
  role: 'system';
  /**
   * An optional name for the participant. Provides the model information to differentiate between participants of the same role.
   */
  name?: string;
};

/**
 * The role of the messages author, in this case `system`.
 */
export type role3 = 'system';

export type ChatCompletionRequestSystemMessageContentPart = ChatCompletionRequestMessageContentPartText;

export type ChatCompletionRequestToolMessage = {
  /**
   * The role of the messages author, in this case `tool`.
   */
  role: 'tool';
  /**
   * The contents of the tool message.
   */
  content: string | Array<ChatCompletionRequestToolMessageContentPart>;
  /**
   * Tool call that this message is responding to.
   */
  tool_call_id: string;
};

/**
 * The role of the messages author, in this case `tool`.
 */
export type role4 = 'tool';

export type ChatCompletionRequestToolMessageContentPart = ChatCompletionRequestMessageContentPartText;

export type ChatCompletionRequestUserMessage = {
  /**
   * The contents of the user message.
   *
   */
  content: string | Array<ChatCompletionRequestUserMessageContentPart>;
  /**
   * The role of the messages author, in this case `user`.
   */
  role: 'user';
  /**
   * An optional name for the participant. Provides the model information to differentiate between participants of the same role.
   */
  name?: string;
};

/**
 * The role of the messages author, in this case `user`.
 */
export type role5 = 'user';

export type ChatCompletionRequestUserMessageContentPart =
  | ChatCompletionRequestMessageContentPartText
  | ChatCompletionRequestMessageContentPartImage;

/**
 * A chat completion message generated by the model.
 */
export type ChatCompletionResponseMessage = {
  /**
   * The contents of the message.
   */
  content: string | null;
  /**
   * The refusal message generated by the model.
   */
  refusal: string | null;
  tool_calls?: ChatCompletionMessageToolCalls;
  /**
   * The role of the author of this message.
   */
  role: 'assistant';
  /**
   * Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
   * @deprecated
   */
  function_call?: {
    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     */
    arguments: string;
    /**
     * The name of the function to call.
     */
    name: string;
  };
};

/**
 * The role of the author of a message
 */
export type ChatCompletionRole = 'system' | 'user' | 'assistant' | 'tool' | 'function';

/**
 * Options for streaming response. Only set this when you set `stream: true`.
 *
 */
export type ChatCompletionStreamOptions = {
  /**
   * If set, an additional chunk will be streamed before the `data: [DONE]` message. The `usage` field on this chunk shows the token usage statistics for the entire request, and the `choices` field will always be an empty array. All other chunks will also include a `usage` field, but with a null value.
   *
   */
  include_usage?: boolean;
} | null;

/**
 * A chat completion delta generated by streamed model responses.
 */
export type ChatCompletionStreamResponseDelta = {
  /**
   * The contents of the chunk message.
   */
  content?: string | null;
  /**
   * Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
   * @deprecated
   */
  function_call?: {
    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     */
    arguments?: string;
    /**
     * The name of the function to call.
     */
    name?: string;
  };
  tool_calls?: Array<ChatCompletionMessageToolCallChunk>;
  /**
   * The role of the author of this message.
   */
  role?: 'system' | 'user' | 'assistant' | 'tool';
  /**
   * The refusal message generated by the model.
   */
  refusal?: string | null;
};

/**
 * The role of the author of this message.
 */
export type role6 = 'system' | 'user' | 'assistant' | 'tool';

export type ChatCompletionTokenLogprob = {
  /**
   * The token.
   */
  token: string;
  /**
   * The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.
   */
  logprob: number;
  /**
   * A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.
   */
  bytes: Array<number> | null;
  /**
   * List of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested `top_logprobs` returned.
   */
  top_logprobs: Array<{
    /**
     * The token.
     */
    token: string;
    /**
     * The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.
     */
    logprob: number;
    /**
     * A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.
     */
    bytes: Array<number> | null;
  }>;
};

export type ChatCompletionTool = {
  /**
   * The type of the tool. Currently, only `function` is supported.
   */
  type: 'function';
  function: FunctionObject;
};

/**
 * Controls which (if any) tool is called by the model.
 * `none` means the model will not call any tool and instead generates a message.
 * `auto` means the model can pick between generating a message or calling one or more tools.
 * `required` means the model must call one or more tools.
 * Specifying a particular tool via `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.
 *
 * `none` is the default when no tools are present. `auto` is the default if tools are present.
 *
 */
export type ChatCompletionToolChoiceOption = 'none' | 'auto' | 'required' | ChatCompletionNamedToolChoice;

/**
 * The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
 */
export type ChunkingStrategyRequestParam = AutoChunkingStrategyRequestParam | StaticChunkingStrategyRequestParam;

export type CompleteUploadRequest = {
  /**
   * The ordered list of Part IDs.
   *
   */
  part_ids: Array<string>;
  /**
   * The optional md5 checksum for the file contents to verify if the bytes uploaded matches what you expect.
   *
   */
  md5?: string;
};

/**
 * Usage statistics for the completion request.
 */
export type CompletionUsage = {
  /**
   * Number of tokens in the generated completion.
   */
  completion_tokens: number;
  /**
   * Number of tokens in the prompt.
   */
  prompt_tokens: number;
  /**
   * Total number of tokens used in the request (prompt + completion).
   */
  total_tokens: number;
};

export type CreateAssistantRequest = {
  /**
   * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
   *
   */
  model:
    | string
    | 'gpt-4o'
    | 'gpt-4o-2024-08-06'
    | 'gpt-4o-2024-05-13'
    | 'gpt-4o-mini'
    | 'gpt-4o-mini-2024-07-18'
    | 'gpt-4-turbo'
    | 'gpt-4-turbo-2024-04-09'
    | 'gpt-4-0125-preview'
    | 'gpt-4-turbo-preview'
    | 'gpt-4-1106-preview'
    | 'gpt-4-vision-preview'
    | 'gpt-4'
    | 'gpt-4-0314'
    | 'gpt-4-0613'
    | 'gpt-4-32k'
    | 'gpt-4-32k-0314'
    | 'gpt-4-32k-0613'
    | 'gpt-3.5-turbo'
    | 'gpt-3.5-turbo-16k'
    | 'gpt-3.5-turbo-0613'
    | 'gpt-3.5-turbo-1106'
    | 'gpt-3.5-turbo-0125'
    | 'gpt-3.5-turbo-16k-0613';
  /**
   * The name of the assistant. The maximum length is 256 characters.
   *
   */
  name?: string | null;
  /**
   * The description of the assistant. The maximum length is 512 characters.
   *
   */
  description?: string | null;
  /**
   * The system instructions that the assistant uses. The maximum length is 256,000 characters.
   *
   */
  instructions?: string | null;
  /**
   * A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.
   *
   */
  tools?: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction>;
  /**
   * A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: unknown & {
      /**
       * The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
       *
       */
      vector_store_ids?: Array<string>;
      /**
       * A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.
       *
       */
      vector_stores?: Array<{
        /**
         * A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.
         *
         */
        file_ids?: Array<string>;
        /**
         * The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
         */
        chunking_strategy?:
          | {
              /**
               * Always `auto`.
               */
              type: 'auto';
            }
          | {
              /**
               * Always `static`.
               */
              type: 'static';
              static: {
                /**
                 * The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.
                 */
                max_chunk_size_tokens: number;
                /**
                 * The number of tokens that overlap between chunks. The default value is `400`.
                 *
                 * Note that the overlap must not exceed half of `max_chunk_size_tokens`.
                 *
                 */
                chunk_overlap_tokens: number;
              };
            };
        /**
         * Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
         *
         */
        metadata?: {
          [key: string]: unknown;
        };
      }>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
  /**
   * empty
   */
  temperature?: number | null;
  /**
   * empty
   */
  top_p?: number | null;
  response_format?: AssistantsApiResponseFormatOption;
};

/**
 * Represents a chat completion response returned by model, based on the provided input.
 */
export type CreateChatCompletionFunctionResponse = {
  /**
   * A unique identifier for the chat completion.
   */
  id: string;
  /**
   * A list of chat completion choices. Can be more than one if `n` is greater than 1.
   */
  choices: Array<{
    /**
     * The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.
     *
     */
    finish_reason: 'stop' | 'length' | 'function_call' | 'content_filter';
    /**
     * The index of the choice in the list of choices.
     */
    index: number;
    message: ChatCompletionResponseMessage;
  }>;
  /**
   * The Unix timestamp (in seconds) of when the chat completion was created.
   */
  created: number;
  /**
   * The model used for the chat completion.
   */
  model: string;
  /**
   * This fingerprint represents the backend configuration that the model runs with.
   *
   * Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
   *
   */
  system_fingerprint?: string;
  /**
   * The object type, which is always `chat.completion`.
   */
  object: 'chat.completion';
  usage?: CompletionUsage;
};

/**
 * The object type, which is always `chat.completion`.
 */
export type object3 = 'chat.completion';

/**
 * Represents a streamed chunk of a chat completion response returned by model, based on the provided input.
 */
export type CreateChatCompletionImageResponse = {
  [key: string]: unknown;
};

export type CreateChatCompletionRequest = {
  /**
   * A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).
   */
  messages: Array<ChatCompletionRequestMessage>;
  /**
   * ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.
   */
  model:
    | string
    | 'gpt-4o'
    | 'gpt-4o-2024-08-06'
    | 'gpt-4o-2024-05-13'
    | 'gpt-4o-mini'
    | 'gpt-4o-mini-2024-07-18'
    | 'gpt-4-turbo'
    | 'gpt-4-turbo-2024-04-09'
    | 'gpt-4-0125-preview'
    | 'gpt-4-turbo-preview'
    | 'gpt-4-1106-preview'
    | 'gpt-4-vision-preview'
    | 'gpt-4'
    | 'gpt-4-0314'
    | 'gpt-4-0613'
    | 'gpt-4-32k'
    | 'gpt-4-32k-0314'
    | 'gpt-4-32k-0613'
    | 'gpt-3.5-turbo'
    | 'gpt-3.5-turbo-16k'
    | 'gpt-3.5-turbo-0301'
    | 'gpt-3.5-turbo-0613'
    | 'gpt-3.5-turbo-1106'
    | 'gpt-3.5-turbo-0125'
    | 'gpt-3.5-turbo-16k-0613';
  /**
   * Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
   *
   * [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
   *
   */
  frequency_penalty?: number | null;
  /**
   * Modify the likelihood of specified tokens appearing in the completion.
   *
   * Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
   *
   */
  logit_bias?: {
    [key: string]: number;
  } | null;
  /**
   * Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the `content` of `message`.
   */
  logprobs?: boolean | null;
  /**
   * An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter is used.
   */
  top_logprobs?: number | null;
  /**
   * The maximum number of [tokens](/tokenizer) that can be generated in the chat completion.
   *
   * The total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
   *
   */
  max_tokens?: number | null;
  /**
   * How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.
   */
  n?: number | null;
  /**
   * Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
   *
   * [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
   *
   */
  presence_penalty?: number | null;
  /**
   * An object specifying the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4o mini](/docs/models/gpt-4o-mini), [GPT-4 Turbo](/docs/models/gpt-4-and-gpt-4-turbo) and all GPT-3.5 Turbo models newer than `gpt-3.5-turbo-1106`.
   *
   * Setting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).
   *
   * Setting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.
   *
   * **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.
   *
   */
  response_format?: ResponseFormatText | ResponseFormatJsonObject | ResponseFormatJsonSchema;
  /**
   * This feature is in Beta.
   * If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
   * Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.
   *
   */
  seed?: number | null;
  /**
   * Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service:
   * - If set to 'auto', the system will utilize scale tier credits until they are exhausted.
   * - If set to 'default', the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.
   * - When not set, the default behavior is 'auto'.
   *
   * When this parameter is set, the response body will include the `service_tier` utilized.
   *
   */
  service_tier?: ('auto' | 'default') | null;
  /**
   * Up to 4 sequences where the API will stop generating further tokens.
   *
   */
  stop?: string | null | Array<string>;
  /**
   * If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
   *
   */
  stream?: boolean | null;
  stream_options?: ChatCompletionStreamOptions;
  /**
   * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
   *
   * We generally recommend altering this or `top_p` but not both.
   *
   */
  temperature?: number | null;
  /**
   * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
   *
   * We generally recommend altering this or `temperature` but not both.
   *
   */
  top_p?: number | null;
  /**
   * A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
   *
   */
  tools?: Array<ChatCompletionTool>;
  tool_choice?: ChatCompletionToolChoiceOption;
  parallel_tool_calls?: ParallelToolCalls;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
  /**
   * Deprecated in favor of `tool_choice`.
   *
   * Controls which (if any) function is called by the model.
   * `none` means the model will not call a function and instead generates a message.
   * `auto` means the model can pick between generating a message or calling a function.
   * Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
   *
   * `none` is the default when no functions are present. `auto` is the default if functions are present.
   *
   * @deprecated
   */
  function_call?: 'none' | 'auto' | ChatCompletionFunctionCallOption;
  /**
   * Deprecated in favor of `tools`.
   *
   * A list of functions the model may generate JSON inputs for.
   *
   * @deprecated
   */
  functions?: Array<ChatCompletionFunctions>;
};

/**
 * Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service:
 * - If set to 'auto', the system will utilize scale tier credits until they are exhausted.
 * - If set to 'default', the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.
 * - When not set, the default behavior is 'auto'.
 *
 * When this parameter is set, the response body will include the `service_tier` utilized.
 *
 */
export type service_tier = 'auto' | 'default';

/**
 * Represents a chat completion response returned by model, based on the provided input.
 */
export type CreateChatCompletionResponse = {
  /**
   * A unique identifier for the chat completion.
   */
  id: string;
  /**
   * A list of chat completion choices. Can be more than one if `n` is greater than 1.
   */
  choices: Array<{
    /**
     * The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
     * `length` if the maximum number of tokens specified in the request was reached,
     * `content_filter` if content was omitted due to a flag from our content filters,
     * `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
     *
     */
    finish_reason: 'stop' | 'length' | 'tool_calls' | 'content_filter' | 'function_call';
    /**
     * The index of the choice in the list of choices.
     */
    index: number;
    message: ChatCompletionResponseMessage;
    /**
     * Log probability information for the choice.
     */
    logprobs?: {
      /**
       * A list of message content tokens with log probability information.
       */
      content: Array<ChatCompletionTokenLogprob> | null;
      /**
       * A list of message refusal tokens with log probability information.
       */
      refusal: Array<ChatCompletionTokenLogprob> | null;
    } | null;
  }>;
  /**
   * The Unix timestamp (in seconds) of when the chat completion was created.
   */
  created: number;
  /**
   * The model used for the chat completion.
   */
  model: string;
  /**
   * The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.
   */
  service_tier?: ('scale' | 'default') | null;
  /**
   * This fingerprint represents the backend configuration that the model runs with.
   *
   * Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
   *
   */
  system_fingerprint?: string;
  /**
   * The object type, which is always `chat.completion`.
   */
  object: 'chat.completion';
  usage?: CompletionUsage;
};

/**
 * The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.
 */
export type service_tier2 = 'scale' | 'default';

/**
 * Represents a streamed chunk of a chat completion response returned by model, based on the provided input.
 */
export type CreateChatCompletionStreamResponse = {
  /**
   * A unique identifier for the chat completion. Each chunk has the same ID.
   */
  id: string;
  /**
   * A list of chat completion choices. Can contain more than one elements if `n` is greater than 1. Can also be empty for the
   * last chunk if you set `stream_options: {"include_usage": true}`.
   *
   */
  choices: Array<{
    delta: ChatCompletionStreamResponseDelta;
    /**
     * Log probability information for the choice.
     */
    logprobs?: {
      /**
       * A list of message content tokens with log probability information.
       */
      content: Array<ChatCompletionTokenLogprob> | null;
      /**
       * A list of message refusal tokens with log probability information.
       */
      refusal: Array<ChatCompletionTokenLogprob> | null;
    } | null;
    /**
     * The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
     * `length` if the maximum number of tokens specified in the request was reached,
     * `content_filter` if content was omitted due to a flag from our content filters,
     * `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
     *
     */
    finish_reason: ('stop' | 'length' | 'tool_calls' | 'content_filter' | 'function_call') | null;
    /**
     * The index of the choice in the list of choices.
     */
    index: number;
  }>;
  /**
   * The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.
   */
  created: number;
  /**
   * The model to generate the completion.
   */
  model: string;
  /**
   * The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.
   */
  service_tier?: ('scale' | 'default') | null;
  /**
   * This fingerprint represents the backend configuration that the model runs with.
   * Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
   *
   */
  system_fingerprint?: string;
  /**
   * The object type, which is always `chat.completion.chunk`.
   */
  object: 'chat.completion.chunk';
  /**
   * An optional field that will only be present when you set `stream_options: {"include_usage": true}` in your request.
   * When present, it contains a null value except for the last chunk which contains the token usage statistics for the entire request.
   *
   */
  usage?: {
    /**
     * Number of tokens in the generated completion.
     */
    completion_tokens: number;
    /**
     * Number of tokens in the prompt.
     */
    prompt_tokens: number;
    /**
     * Total number of tokens used in the request (prompt + completion).
     */
    total_tokens: number;
  };
};

/**
 * The object type, which is always `chat.completion.chunk`.
 */
export type object4 = 'chat.completion.chunk';

export type CreateCompletionRequest = {
  /**
   * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
   *
   */
  model: string | 'gpt-3.5-turbo-instruct' | 'davinci-002' | 'babbage-002';
  /**
   * The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.
   *
   * Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.
   *
   */
  prompt: (string | Array<string> | Array<number> | Array<Array<number>>) | null;
  /**
   * Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.
   *
   * When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.
   *
   * **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
   *
   */
  best_of?: number | null;
  /**
   * Echo back the prompt in addition to the completion
   *
   */
  echo?: boolean | null;
  /**
   * Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
   *
   * [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
   *
   */
  frequency_penalty?: number | null;
  /**
   * Modify the likelihood of specified tokens appearing in the completion.
   *
   * Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
   *
   * As an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.
   *
   */
  logit_bias?: {
    [key: string]: number;
  } | null;
  /**
   * Include the log probabilities on the `logprobs` most likely output tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.
   *
   * The maximum value for `logprobs` is 5.
   *
   */
  logprobs?: number | null;
  /**
   * The maximum number of [tokens](/tokenizer) that can be generated in the completion.
   *
   * The token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
   *
   */
  max_tokens?: number | null;
  /**
   * How many completions to generate for each prompt.
   *
   * **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
   *
   */
  n?: number | null;
  /**
   * Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
   *
   * [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
   *
   */
  presence_penalty?: number | null;
  /**
   * If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
   *
   * Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.
   *
   */
  seed?: number | null;
  /**
   * Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
   *
   */
  stop?: string | null | Array<string>;
  /**
   * Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
   *
   */
  stream?: boolean | null;
  stream_options?: ChatCompletionStreamOptions;
  /**
   * The suffix that comes after a completion of inserted text.
   *
   * This parameter is only supported for `gpt-3.5-turbo-instruct`.
   *
   */
  suffix?: string | null;
  /**
   * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
   *
   * We generally recommend altering this or `top_p` but not both.
   *
   */
  temperature?: number | null;
  /**
   * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
   *
   * We generally recommend altering this or `temperature` but not both.
   *
   */
  top_p?: number | null;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
};

/**
 * Represents a completion response from the API. Note: both the streamed and non-streamed response objects share the same shape (unlike the chat endpoint).
 *
 */
export type CreateCompletionResponse = {
  /**
   * A unique identifier for the completion.
   */
  id: string;
  /**
   * The list of completion choices the model generated for the input prompt.
   */
  choices: Array<{
    /**
     * The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
     * `length` if the maximum number of tokens specified in the request was reached,
     * or `content_filter` if content was omitted due to a flag from our content filters.
     *
     */
    finish_reason: 'stop' | 'length' | 'content_filter';
    index: number;
    logprobs: {
      text_offset?: Array<number>;
      token_logprobs?: Array<number>;
      tokens?: Array<string>;
      top_logprobs?: Array<{
        [key: string]: number;
      }>;
    } | null;
    text: string;
  }>;
  /**
   * The Unix timestamp (in seconds) of when the completion was created.
   */
  created: number;
  /**
   * The model used for completion.
   */
  model: string;
  /**
   * This fingerprint represents the backend configuration that the model runs with.
   *
   * Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
   *
   */
  system_fingerprint?: string;
  /**
   * The object type, which is always "text_completion"
   */
  object: 'text_completion';
  usage?: CompletionUsage;
};

/**
 * The object type, which is always "text_completion"
 */
export type object5 = 'text_completion';

export type CreateEmbeddingRequest = {
  /**
   * Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`), cannot be an empty string, and any array must be 2048 dimensions or less. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
   *
   */
  input: string | Array<string> | Array<number> | Array<Array<number>>;
  /**
   * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
   *
   */
  model: string | 'text-embedding-ada-002' | 'text-embedding-3-small' | 'text-embedding-3-large';
  /**
   * The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
   */
  encoding_format?: 'float' | 'base64';
  /**
   * The number of dimensions the resulting output embeddings should have. Only supported in `text-embedding-3` and later models.
   *
   */
  dimensions?: number | null;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
};

/**
 * The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
 */
export type encoding_format = 'float' | 'base64';

export type CreateEmbeddingResponse = {
  /**
   * The list of embeddings generated by the model.
   */
  data: Array<Embedding>;
  /**
   * The name of the model used to generate the embedding.
   */
  model: string;
  /**
   * The object type, which is always "list".
   */
  object: 'list';
  /**
   * The usage information for the request.
   */
  usage: {
    /**
     * The number of tokens used by the prompt.
     */
    prompt_tokens: number;
    /**
     * The total number of tokens used by the request.
     */
    total_tokens: number;
  };
};

/**
 * The object type, which is always "list".
 */
export type object6 = 'list';

export type CreateFileRequest = {
  /**
   * The File object (not file name) to be uploaded.
   *
   */
  file: Blob | File;
  /**
   * The intended purpose of the uploaded file.
   *
   * Use "assistants" for [Assistants](/docs/api-reference/assistants) and [Message](/docs/api-reference/messages) files, "vision" for Assistants image file inputs, "batch" for [Batch API](/docs/guides/batch), and "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning).
   *
   */
  purpose: 'assistants' | 'batch' | 'fine-tune' | 'vision';
};

/**
 * The intended purpose of the uploaded file.
 *
 * Use "assistants" for [Assistants](/docs/api-reference/assistants) and [Message](/docs/api-reference/messages) files, "vision" for Assistants image file inputs, "batch" for [Batch API](/docs/guides/batch), and "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning).
 *
 */
export type purpose = 'assistants' | 'batch' | 'fine-tune' | 'vision';

export type CreateFineTuningJobRequest = {
  /**
   * The name of the model to fine-tune. You can select one of the
   * [supported models](/docs/guides/fine-tuning/which-models-can-be-fine-tuned).
   *
   */
  model: string | 'babbage-002' | 'davinci-002' | 'gpt-3.5-turbo' | 'gpt-4o-mini';
  /**
   * The ID of an uploaded file that contains training data.
   *
   * See [upload file](/docs/api-reference/files/create) for how to upload a file.
   *
   * Your dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.
   *
   * The contents of the file should differ depending on if the model uses the [chat](/docs/api-reference/fine-tuning/chat-input) or [completions](/docs/api-reference/fine-tuning/completions-input) format.
   *
   * See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
   *
   */
  training_file: string;
  /**
   * The hyperparameters used for the fine-tuning job.
   */
  hyperparameters?: {
    /**
     * Number of examples in each batch. A larger batch size means that model parameters
     * are updated less frequently, but with lower variance.
     *
     */
    batch_size?: 'auto' | number;
    /**
     * Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
     * overfitting.
     *
     */
    learning_rate_multiplier?: 'auto' | number;
    /**
     * The number of epochs to train the model for. An epoch refers to one full cycle
     * through the training dataset.
     *
     */
    n_epochs?: 'auto' | number;
  };
  /**
   * A string of up to 18 characters that will be added to your fine-tuned model name.
   *
   * For example, a `suffix` of "custom-model-name" would produce a model name like `ft:gpt-4o-mini:openai:custom-model-name:7p4lURel`.
   *
   */
  suffix?: string | null;
  /**
   * The ID of an uploaded file that contains validation data.
   *
   * If you provide this file, the data is used to generate validation
   * metrics periodically during fine-tuning. These metrics can be viewed in
   * the fine-tuning results file.
   * The same data should not be present in both train and validation files.
   *
   * Your dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.
   *
   * See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
   *
   */
  validation_file?: string | null;
  /**
   * A list of integrations to enable for your fine-tuning job.
   */
  integrations?: Array<{
    /**
     * The type of integration to enable. Currently, only "wandb" (Weights and Biases) is supported.
     *
     */
    type: 'wandb';
    /**
     * The settings for your integration with Weights and Biases. This payload specifies the project that
     * metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
     * to your run, and set a default entity (team, username, etc) to be associated with your run.
     *
     */
    wandb: {
      /**
       * The name of the project that the new run will be created under.
       *
       */
      project: string;
      /**
       * A display name to set for the run. If not set, we will use the Job ID as the name.
       *
       */
      name?: string | null;
      /**
       * The entity to use for the run. This allows you to set the team or username of the WandB user that you would
       * like associated with the run. If not set, the default entity for the registered WandB API key is used.
       *
       */
      entity?: string | null;
      /**
       * A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some
       * default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
       *
       */
      tags?: Array<string>;
    };
  }> | null;
  /**
   * The seed controls the reproducibility of the job. Passing in the same seed and job parameters should produce the same results, but may differ in rare cases.
   * If a seed is not specified, one will be generated for you.
   *
   */
  seed?: number | null;
};

export type CreateImageEditRequest = {
  /**
   * The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.
   */
  image: Blob | File;
  /**
   * A text description of the desired image(s). The maximum length is 1000 characters.
   */
  prompt: string;
  /**
   * An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where `image` should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.
   */
  mask?: Blob | File;
  /**
   * The model to use for image generation. Only `dall-e-2` is supported at this time.
   */
  model?: (string | 'dall-e-2') | null;
  /**
   * The number of images to generate. Must be between 1 and 10.
   */
  n?: number | null;
  /**
   * The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.
   */
  size?: ('256x256' | '512x512' | '1024x1024') | null;
  /**
   * The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.
   */
  response_format?: ('url' | 'b64_json') | null;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
};

/**
 * The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.
 */
export type size = '256x256' | '512x512' | '1024x1024';

/**
 * The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.
 */
export type response_format = 'url' | 'b64_json';

export type CreateImageRequest = {
  /**
   * A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.
   */
  prompt: string;
  /**
   * The model to use for image generation.
   */
  model?: (string | 'dall-e-2' | 'dall-e-3') | null;
  /**
   * The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
   */
  n?: number | null;
  /**
   * The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.
   */
  quality?: 'standard' | 'hd';
  /**
   * The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.
   */
  response_format?: ('url' | 'b64_json') | null;
  /**
   * The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.
   */
  size?: ('256x256' | '512x512' | '1024x1024' | '1792x1024' | '1024x1792') | null;
  /**
   * The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.
   */
  style?: ('vivid' | 'natural') | null;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
};

/**
 * The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.
 */
export type quality = 'standard' | 'hd';

/**
 * The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.
 */
export type size2 = '256x256' | '512x512' | '1024x1024' | '1792x1024' | '1024x1792';

/**
 * The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.
 */
export type style = 'vivid' | 'natural';

export type CreateImageVariationRequest = {
  /**
   * The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
   */
  image: Blob | File;
  /**
   * The model to use for image generation. Only `dall-e-2` is supported at this time.
   */
  model?: (string | 'dall-e-2') | null;
  /**
   * The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
   */
  n?: number | null;
  /**
   * The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.
   */
  response_format?: ('url' | 'b64_json') | null;
  /**
   * The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.
   */
  size?: ('256x256' | '512x512' | '1024x1024') | null;
  /**
   * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
   *
   */
  user?: string;
};

export type CreateMessageRequest = {
  /**
   * The role of the entity that is creating the message. Allowed values include:
   * - `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.
   * - `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.
   *
   */
  role: 'user' | 'assistant';
  content:
    | string
    | Array<MessageContentImageFileObject | MessageContentImageUrlObject | MessageRequestContentTextObject>;
  /**
   * A list of files attached to the message, and the tools they should be added to.
   */
  attachments?: Array<{
    /**
     * The ID of the file to attach to the message.
     */
    file_id?: string;
    /**
     * The tools to add this file to.
     */
    tools?: Array<AssistantToolsCode | AssistantToolsFileSearchTypeOnly>;
  }> | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

/**
 * The role of the entity that is creating the message. Allowed values include:
 * - `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.
 * - `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.
 *
 */
export type role7 = 'user' | 'assistant';

export type CreateModerationRequest = {
  /**
   * The input text to classify
   */
  input: string | Array<string>;
  /**
   * Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.
   *
   * The default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.
   *
   */
  model?: string | 'text-moderation-latest' | 'text-moderation-stable';
};

/**
 * Represents if a given text input is potentially harmful.
 */
export type CreateModerationResponse = {
  /**
   * The unique identifier for the moderation request.
   */
  id: string;
  /**
   * The model used to generate the moderation results.
   */
  model: string;
  /**
   * A list of moderation objects.
   */
  results: Array<{
    /**
     * Whether any of the below categories are flagged.
     */
    flagged: boolean;
    /**
     * A list of the categories, and whether they are flagged or not.
     */
    categories: {
      /**
       * Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harassment.
       */
      hate: boolean;
      /**
       * Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.
       */
      'hate/threatening': boolean;
      /**
       * Content that expresses, incites, or promotes harassing language towards any target.
       */
      harassment: boolean;
      /**
       * Harassment content that also includes violence or serious harm towards any target.
       */
      'harassment/threatening': boolean;
      /**
       * Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.
       */
      'self-harm': boolean;
      /**
       * Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.
       */
      'self-harm/intent': boolean;
      /**
       * Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.
       */
      'self-harm/instructions': boolean;
      /**
       * Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).
       */
      sexual: boolean;
      /**
       * Sexual content that includes an individual who is under 18 years old.
       */
      'sexual/minors': boolean;
      /**
       * Content that depicts death, violence, or physical injury.
       */
      violence: boolean;
      /**
       * Content that depicts death, violence, or physical injury in graphic detail.
       */
      'violence/graphic': boolean;
    };
    /**
     * A list of the categories along with their scores as predicted by model.
     */
    category_scores: {
      /**
       * The score for the category 'hate'.
       */
      hate: number;
      /**
       * The score for the category 'hate/threatening'.
       */
      'hate/threatening': number;
      /**
       * The score for the category 'harassment'.
       */
      harassment: number;
      /**
       * The score for the category 'harassment/threatening'.
       */
      'harassment/threatening': number;
      /**
       * The score for the category 'self-harm'.
       */
      'self-harm': number;
      /**
       * The score for the category 'self-harm/intent'.
       */
      'self-harm/intent': number;
      /**
       * The score for the category 'self-harm/instructions'.
       */
      'self-harm/instructions': number;
      /**
       * The score for the category 'sexual'.
       */
      sexual: number;
      /**
       * The score for the category 'sexual/minors'.
       */
      'sexual/minors': number;
      /**
       * The score for the category 'violence'.
       */
      violence: number;
      /**
       * The score for the category 'violence/graphic'.
       */
      'violence/graphic': number;
    };
  }>;
};

export type CreateRunRequest = {
  /**
   * The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
   */
  assistant_id: string;
  /**
   * The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
   */
  model?:
    | (
        | string
        | 'gpt-4o'
        | 'gpt-4o-2024-08-06'
        | 'gpt-4o-2024-05-13'
        | 'gpt-4o-mini'
        | 'gpt-4o-mini-2024-07-18'
        | 'gpt-4-turbo'
        | 'gpt-4-turbo-2024-04-09'
        | 'gpt-4-0125-preview'
        | 'gpt-4-turbo-preview'
        | 'gpt-4-1106-preview'
        | 'gpt-4-vision-preview'
        | 'gpt-4'
        | 'gpt-4-0314'
        | 'gpt-4-0613'
        | 'gpt-4-32k'
        | 'gpt-4-32k-0314'
        | 'gpt-4-32k-0613'
        | 'gpt-3.5-turbo'
        | 'gpt-3.5-turbo-16k'
        | 'gpt-3.5-turbo-0613'
        | 'gpt-3.5-turbo-1106'
        | 'gpt-3.5-turbo-0125'
        | 'gpt-3.5-turbo-16k-0613'
      )
    | null;
  /**
   * Overrides the [instructions](/docs/api-reference/assistants/createAssistant) of the assistant. This is useful for modifying the behavior on a per-run basis.
   */
  instructions?: string | null;
  /**
   * Appends additional instructions at the end of the instructions for the run. This is useful for modifying the behavior on a per-run basis without overriding other instructions.
   */
  additional_instructions?: string | null;
  /**
   * Adds additional messages to the thread before creating the run.
   */
  additional_messages?: Array<CreateMessageRequest> | null;
  /**
   * Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
   */
  tools?: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction> | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
  /**
   * empty
   */
  temperature?: number | null;
  /**
   * empty
   */
  top_p?: number | null;
  /**
   * If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.
   *
   */
  stream?: boolean | null;
  /**
   * The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
   *
   */
  max_prompt_tokens?: number | null;
  /**
   * The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
   *
   */
  max_completion_tokens?: number | null;
  truncation_strategy?: TruncationObject;
  tool_choice?: AssistantsApiToolChoiceOption;
  parallel_tool_calls?: ParallelToolCalls;
  response_format?: AssistantsApiResponseFormatOption;
};

export type CreateSpeechRequest = {
  /**
   * One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`
   *
   */
  model: string | 'tts-1' | 'tts-1-hd';
  /**
   * The text to generate audio for. The maximum length is 4096 characters.
   */
  input: string;
  /**
   * The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).
   */
  voice: 'alloy' | 'echo' | 'fable' | 'onyx' | 'nova' | 'shimmer';
  /**
   * The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.
   */
  response_format?: 'mp3' | 'opus' | 'aac' | 'flac' | 'wav' | 'pcm';
  /**
   * The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.
   */
  speed?: number;
};

/**
 * The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).
 */
export type voice = 'alloy' | 'echo' | 'fable' | 'onyx' | 'nova' | 'shimmer';

/**
 * The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.
 */
export type response_format2 = 'mp3' | 'opus' | 'aac' | 'flac' | 'wav' | 'pcm';

export type CreateThreadAndRunRequest = {
  /**
   * The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
   */
  assistant_id: string;
  thread?: CreateThreadRequest;
  /**
   * The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
   */
  model?:
    | (
        | string
        | 'gpt-4o'
        | 'gpt-4o-2024-08-06'
        | 'gpt-4o-2024-05-13'
        | 'gpt-4o-mini'
        | 'gpt-4o-mini-2024-07-18'
        | 'gpt-4-turbo'
        | 'gpt-4-turbo-2024-04-09'
        | 'gpt-4-0125-preview'
        | 'gpt-4-turbo-preview'
        | 'gpt-4-1106-preview'
        | 'gpt-4-vision-preview'
        | 'gpt-4'
        | 'gpt-4-0314'
        | 'gpt-4-0613'
        | 'gpt-4-32k'
        | 'gpt-4-32k-0314'
        | 'gpt-4-32k-0613'
        | 'gpt-3.5-turbo'
        | 'gpt-3.5-turbo-16k'
        | 'gpt-3.5-turbo-0613'
        | 'gpt-3.5-turbo-1106'
        | 'gpt-3.5-turbo-0125'
        | 'gpt-3.5-turbo-16k-0613'
      )
    | null;
  /**
   * Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
   */
  instructions?: string | null;
  /**
   * Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
   */
  tools?: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction> | null;
  /**
   * A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: {
      /**
       * The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
       *
       */
      vector_store_ids?: Array<string>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
  /**
   * empty
   */
  temperature?: number | null;
  /**
   * empty
   */
  top_p?: number | null;
  /**
   * If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.
   *
   */
  stream?: boolean | null;
  /**
   * The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
   *
   */
  max_prompt_tokens?: number | null;
  /**
   * The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
   *
   */
  max_completion_tokens?: number | null;
  truncation_strategy?: TruncationObject;
  tool_choice?: AssistantsApiToolChoiceOption;
  parallel_tool_calls?: ParallelToolCalls;
  response_format?: AssistantsApiResponseFormatOption;
};

export type CreateThreadRequest = {
  /**
   * A list of [messages](/docs/api-reference/messages) to start the thread with.
   */
  messages?: Array<CreateMessageRequest>;
  /**
   * A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: unknown & {
      /**
       * The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
       *
       */
      vector_store_ids?: Array<string>;
      /**
       * A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.
       *
       */
      vector_stores?: Array<{
        /**
         * A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.
         *
         */
        file_ids?: Array<string>;
        /**
         * The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
         */
        chunking_strategy?:
          | {
              /**
               * Always `auto`.
               */
              type: 'auto';
            }
          | {
              /**
               * Always `static`.
               */
              type: 'static';
              static: {
                /**
                 * The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.
                 */
                max_chunk_size_tokens: number;
                /**
                 * The number of tokens that overlap between chunks. The default value is `400`.
                 *
                 * Note that the overlap must not exceed half of `max_chunk_size_tokens`.
                 *
                 */
                chunk_overlap_tokens: number;
              };
            };
        /**
         * Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
         *
         */
        metadata?: {
          [key: string]: unknown;
        };
      }>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

export type CreateTranscriptionRequest = {
  /**
   * The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.
   *
   */
  file: Blob | File;
  /**
   * ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.
   *
   */
  model: string | 'whisper-1';
  /**
   * The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
   *
   */
  language?: string;
  /**
   * An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
   *
   */
  prompt?: string;
  /**
   * The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.
   *
   */
  response_format?: 'json' | 'text' | 'srt' | 'verbose_json' | 'vtt';
  /**
   * The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
   *
   */
  temperature?: number;
  /**
   * The timestamp granularities to populate for this transcription. `response_format` must be set `verbose_json` to use timestamp granularities. Either or both of these options are supported: `word`, or `segment`. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.
   *
   */
  'timestamp_granularities[]'?: Array<'word' | 'segment'>;
};

/**
 * The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.
 *
 */
export type response_format3 = 'json' | 'text' | 'srt' | 'verbose_json' | 'vtt';

/**
 * Represents a transcription response returned by model, based on the provided input.
 */
export type CreateTranscriptionResponseJson = {
  /**
   * The transcribed text.
   */
  text: string;
};

/**
 * Represents a verbose json transcription response returned by model, based on the provided input.
 */
export type CreateTranscriptionResponseVerboseJson = {
  /**
   * The language of the input audio.
   */
  language: string;
  /**
   * The duration of the input audio.
   */
  duration: string;
  /**
   * The transcribed text.
   */
  text: string;
  /**
   * Extracted words and their corresponding timestamps.
   */
  words?: Array<TranscriptionWord>;
  /**
   * Segments of the transcribed text and their corresponding details.
   */
  segments?: Array<TranscriptionSegment>;
};

export type CreateTranslationRequest = {
  /**
   * The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.
   *
   */
  file: Blob | File;
  /**
   * ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.
   *
   */
  model: string | 'whisper-1';
  /**
   * An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
   *
   */
  prompt?: string;
  /**
   * The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.
   *
   */
  response_format?: string;
  /**
   * The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
   *
   */
  temperature?: number;
};

export type CreateTranslationResponseJson = {
  text: string;
};

export type CreateTranslationResponseVerboseJson = {
  /**
   * The language of the output translation (always `english`).
   */
  language: string;
  /**
   * The duration of the input audio.
   */
  duration: string;
  /**
   * The translated text.
   */
  text: string;
  /**
   * Segments of the translated text and their corresponding details.
   */
  segments?: Array<TranscriptionSegment>;
};

export type CreateUploadRequest = {
  /**
   * The name of the file to upload.
   *
   */
  filename: string;
  /**
   * The intended purpose of the uploaded file.
   *
   * See the [documentation on File purposes](/docs/api-reference/files/create#files-create-purpose).
   *
   */
  purpose: 'assistants' | 'batch' | 'fine-tune' | 'vision';
  /**
   * The number of bytes in the file you are uploading.
   *
   */
  bytes: number;
  /**
   * The MIME type of the file.
   *
   * This must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants and vision.
   *
   */
  mime_type: string;
};

export type CreateVectorStoreFileBatchRequest = {
  /**
   * A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.
   */
  file_ids: Array<string>;
  chunking_strategy?: ChunkingStrategyRequestParam;
};

export type CreateVectorStoreFileRequest = {
  /**
   * A [File](/docs/api-reference/files) ID that the vector store should use. Useful for tools like `file_search` that can access files.
   */
  file_id: string;
  chunking_strategy?: ChunkingStrategyRequestParam;
};

export type CreateVectorStoreRequest = {
  /**
   * A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.
   */
  file_ids?: Array<string>;
  /**
   * The name of the vector store.
   */
  name?: string;
  expires_after?: VectorStoreExpirationAfter;
  /**
   * The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy. Only applicable if `file_ids` is non-empty.
   */
  chunking_strategy?: AutoChunkingStrategyRequestParam | StaticChunkingStrategyRequestParam;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

export type DefaultProjectErrorResponse = {
  code: number;
  message: string;
};

export type DeleteAssistantResponse = {
  id: string;
  deleted: boolean;
  object: 'assistant.deleted';
};

export type object7 = 'assistant.deleted';

export type DeleteFileResponse = {
  id: string;
  object: 'file';
  deleted: boolean;
};

export type object8 = 'file';

export type DeleteMessageResponse = {
  id: string;
  deleted: boolean;
  object: 'thread.message.deleted';
};

export type object9 = 'thread.message.deleted';

export type DeleteModelResponse = {
  id: string;
  deleted: boolean;
  object: string;
};

export type DeleteThreadResponse = {
  id: string;
  deleted: boolean;
  object: 'thread.deleted';
};

export type object10 = 'thread.deleted';

export type DeleteVectorStoreFileResponse = {
  id: string;
  deleted: boolean;
  object: 'vector_store.file.deleted';
};

export type object11 = 'vector_store.file.deleted';

export type DeleteVectorStoreResponse = {
  id: string;
  deleted: boolean;
  object: 'vector_store.deleted';
};

export type object12 = 'vector_store.deleted';

/**
 * Occurs when a stream ends.
 */
export type DoneEvent = {
  event: 'done';
  data: '[DONE]';
};

export type event = 'done';

export type data = '[DONE]';

/**
 * Represents an embedding vector returned by embedding endpoint.
 *
 */
export type Embedding = {
  /**
   * The index of the embedding in the list of embeddings.
   */
  index: number;
  /**
   * The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).
   *
   */
  embedding: Array<number>;
  /**
   * The object type, which is always "embedding".
   */
  object: 'embedding';
};

/**
 * The object type, which is always "embedding".
 */
export type object13 = 'embedding';

export type Error = {
  code: string | null;
  message: string;
  param: string | null;
  type: string;
};

/**
 * Occurs when an [error](/docs/guides/error-codes/api-errors) occurs. This can happen due to an internal server error or a timeout.
 */
export type ErrorEvent = {
  event: 'error';
  data: Error;
};

export type event2 = 'error';

export type ErrorResponse = {
  error: Error;
};

export type FineTuneChatCompletionRequestAssistantMessage = {
  /**
   * Controls whether the assistant message is trained against (0 or 1)
   */
  weight?: 0 | 1;
} & ChatCompletionRequestAssistantMessage;

/**
 * Controls whether the assistant message is trained against (0 or 1)
 */
export type weight = 0 | 1;

/**
 * The per-line training example of a fine-tuning input file for chat models
 */
export type FinetuneChatRequestInput = {
  messages?: Array<
    | ChatCompletionRequestSystemMessage
    | ChatCompletionRequestUserMessage
    | FineTuneChatCompletionRequestAssistantMessage
    | ChatCompletionRequestToolMessage
    | ChatCompletionRequestFunctionMessage
  >;
  /**
   * A list of tools the model may generate JSON inputs for.
   */
  tools?: Array<ChatCompletionTool>;
  parallel_tool_calls?: ParallelToolCalls;
  /**
   * A list of functions the model may generate JSON inputs for.
   * @deprecated
   */
  functions?: Array<ChatCompletionFunctions>;
};

/**
 * The per-line training example of a fine-tuning input file for completions models
 */
export type FinetuneCompletionRequestInput = {
  /**
   * The input prompt for this training example.
   */
  prompt?: string;
  /**
   * The desired completion for this training example.
   */
  completion?: string;
};

export type FineTuningIntegration = {
  /**
   * The type of the integration being enabled for the fine-tuning job
   */
  type: 'wandb';
  /**
   * The settings for your integration with Weights and Biases. This payload specifies the project that
   * metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
   * to your run, and set a default entity (team, username, etc) to be associated with your run.
   *
   */
  wandb: {
    /**
     * The name of the project that the new run will be created under.
     *
     */
    project: string;
    /**
     * A display name to set for the run. If not set, we will use the Job ID as the name.
     *
     */
    name?: string | null;
    /**
     * The entity to use for the run. This allows you to set the team or username of the WandB user that you would
     * like associated with the run. If not set, the default entity for the registered WandB API key is used.
     *
     */
    entity?: string | null;
    /**
     * A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some
     * default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
     *
     */
    tags?: Array<string>;
  };
};

/**
 * The type of the integration being enabled for the fine-tuning job
 */
export type type11 = 'wandb';

/**
 * The `fine_tuning.job` object represents a fine-tuning job that has been created through the API.
 *
 */
export type FineTuningJob = {
  /**
   * The object identifier, which can be referenced in the API endpoints.
   */
  id: string;
  /**
   * The Unix timestamp (in seconds) for when the fine-tuning job was created.
   */
  created_at: number;
  /**
   * For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
   */
  error: {
    /**
     * A machine-readable error code.
     */
    code: string;
    /**
     * A human-readable error message.
     */
    message: string;
    /**
     * The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.
     */
    param: string | null;
  } | null;
  /**
   * The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.
   */
  fine_tuned_model: string | null;
  /**
   * The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.
   */
  finished_at: number | null;
  /**
   * The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
   */
  hyperparameters: {
    /**
     * The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
     * "auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.
     */
    n_epochs: 'auto' | number;
  };
  /**
   * The base model that is being fine-tuned.
   */
  model: string;
  /**
   * The object type, which is always "fine_tuning.job".
   */
  object: 'fine_tuning.job';
  /**
   * The organization that owns the fine-tuning job.
   */
  organization_id: string;
  /**
   * The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).
   */
  result_files: Array<string>;
  /**
   * The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
   */
  status: 'validating_files' | 'queued' | 'running' | 'succeeded' | 'failed' | 'cancelled';
  /**
   * The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.
   */
  trained_tokens: number | null;
  /**
   * The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).
   */
  training_file: string;
  /**
   * The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).
   */
  validation_file: string | null;
  /**
   * A list of integrations to enable for this fine-tuning job.
   */
  integrations?: Array<FineTuningIntegration> | null;
  /**
   * The seed used for the fine-tuning job.
   */
  seed: number;
  /**
   * The Unix timestamp (in seconds) for when the fine-tuning job is estimated to finish. The value will be null if the fine-tuning job is not running.
   */
  estimated_finish?: number | null;
};

/**
 * The object type, which is always "fine_tuning.job".
 */
export type object14 = 'fine_tuning.job';

/**
 * The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
 */
export type status2 = 'validating_files' | 'queued' | 'running' | 'succeeded' | 'failed' | 'cancelled';

/**
 * The `fine_tuning.job.checkpoint` object represents a model checkpoint for a fine-tuning job that is ready to use.
 *
 */
export type FineTuningJobCheckpoint = {
  /**
   * The checkpoint identifier, which can be referenced in the API endpoints.
   */
  id: string;
  /**
   * The Unix timestamp (in seconds) for when the checkpoint was created.
   */
  created_at: number;
  /**
   * The name of the fine-tuned checkpoint model that is created.
   */
  fine_tuned_model_checkpoint: string;
  /**
   * The step number that the checkpoint was created at.
   */
  step_number: number;
  /**
   * Metrics at the step number during the fine-tuning job.
   */
  metrics: {
    step?: number;
    train_loss?: number;
    train_mean_token_accuracy?: number;
    valid_loss?: number;
    valid_mean_token_accuracy?: number;
    full_valid_loss?: number;
    full_valid_mean_token_accuracy?: number;
  };
  /**
   * The name of the fine-tuning job that this checkpoint was created from.
   */
  fine_tuning_job_id: string;
  /**
   * The object type, which is always "fine_tuning.job.checkpoint".
   */
  object: 'fine_tuning.job.checkpoint';
};

/**
 * The object type, which is always "fine_tuning.job.checkpoint".
 */
export type object15 = 'fine_tuning.job.checkpoint';

/**
 * Fine-tuning job event object
 */
export type FineTuningJobEvent = {
  id: string;
  created_at: number;
  level: 'info' | 'warn' | 'error';
  message: string;
  object: 'fine_tuning.job.event';
};

export type level = 'info' | 'warn' | 'error';

export type object16 = 'fine_tuning.job.event';

export type FunctionObject = {
  /**
   * A description of what the function does, used by the model to choose when and how to call the function.
   */
  description?: string;
  /**
   * The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
   */
  name: string;
  parameters?: FunctionParameters;
  /**
   * Whether to enable strict schema adherence when generating the function call. If set to true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling guide](docs/guides/function-calling).
   */
  strict?: boolean | null;
};

/**
 * The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.
 *
 * Omitting `parameters` defines a function with an empty parameter list.
 */
export type FunctionParameters = {
  [key: string]: unknown;
};

/**
 * Represents the url or the content of an image generated by the OpenAI API.
 */
export type Image = {
  /**
   * The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.
   */
  b64_json?: string;
  /**
   * The URL of the generated image, if `response_format` is `url` (default).
   */
  url?: string;
  /**
   * The prompt that was used to generate the image, if there was any revision to the prompt.
   */
  revised_prompt?: string;
};

export type ImagesResponse = {
  created: number;
  data: Array<Image>;
};

/**
 * Represents an individual `invite` to the organization.
 */
export type Invite = {
  /**
   * The object type, which is always `organization.invite`
   */
  object: 'organization.invite';
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  /**
   * The email address of the individual to whom the invite was sent
   */
  email: string;
  /**
   * `owner` or `reader`
   */
  role: 'owner' | 'reader';
  /**
   * `accepted`,`expired`, or `pending`
   */
  status: 'accepted' | 'expired' | 'pending';
  /**
   * The Unix timestamp (in seconds) of when the invite was sent.
   */
  invited_at: number;
  /**
   * The Unix timestamp (in seconds) of when the invite expires.
   */
  expires_at: number;
  /**
   * The Unix timestamp (in seconds) of when the invite was accepted.
   */
  accepted_at?: number;
};

/**
 * The object type, which is always `organization.invite`
 */
export type object17 = 'organization.invite';

/**
 * `owner` or `reader`
 */
export type role8 = 'owner' | 'reader';

/**
 * `accepted`,`expired`, or `pending`
 */
export type status3 = 'accepted' | 'expired' | 'pending';

export type InviteDeleteResponse = {
  /**
   * The object type, which is always `organization.invite.deleted`
   */
  object: 'organization.invite.deleted';
  id: string;
  deleted: boolean;
};

/**
 * The object type, which is always `organization.invite.deleted`
 */
export type object18 = 'organization.invite.deleted';

export type InviteListResponse = {
  /**
   * The object type, which is always `list`
   */
  object: 'list';
  data: Array<Invite>;
  /**
   * The first `invite_id` in the retrieved `list`
   */
  first_id?: string;
  /**
   * The last `invite_id` in the retrieved `list`
   */
  last_id?: string;
  /**
   * The `has_more` property is used for pagination to indicate there are additional results.
   */
  has_more?: boolean;
};

export type InviteRequest = {
  /**
   * Send an email to this address
   */
  email: string;
  /**
   * `owner` or `reader`
   */
  role: 'reader' | 'owner';
};

export type ListAssistantsResponse = {
  object: string;
  data: Array<AssistantObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListAuditLogsResponse = {
  object: 'list';
  data: Array<AuditLog>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListBatchesResponse = {
  data: Array<Batch>;
  first_id?: string;
  last_id?: string;
  has_more: boolean;
  object: 'list';
};

export type ListFilesResponse = {
  data: Array<OpenAIFile>;
  object: 'list';
};

export type ListFineTuningJobCheckpointsResponse = {
  data: Array<FineTuningJobCheckpoint>;
  object: 'list';
  first_id?: string | null;
  last_id?: string | null;
  has_more: boolean;
};

export type ListFineTuningJobEventsResponse = {
  data: Array<FineTuningJobEvent>;
  object: 'list';
};

export type ListMessagesResponse = {
  object: string;
  data: Array<MessageObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListModelsResponse = {
  object: 'list';
  data: Array<Model>;
};

export type ListPaginatedFineTuningJobsResponse = {
  data: Array<FineTuningJob>;
  has_more: boolean;
  object: 'list';
};

export type ListRunsResponse = {
  object: string;
  data: Array<RunObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListRunStepsResponse = {
  object: string;
  data: Array<RunStepObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListThreadsResponse = {
  object: string;
  data: Array<ThreadObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListVectorStoreFilesResponse = {
  object: string;
  data: Array<VectorStoreFileObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ListVectorStoresResponse = {
  object: string;
  data: Array<VectorStoreObject>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

/**
 * References an image [File](/docs/api-reference/files) in the content of a message.
 */
export type MessageContentImageFileObject = {
  /**
   * Always `image_file`.
   */
  type: 'image_file';
  image_file: {
    /**
     * The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.
     */
    file_id: string;
    /**
     * Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.
     */
    detail?: 'auto' | 'low' | 'high';
  };
};

/**
 * Always `image_file`.
 */
export type type12 = 'image_file';

/**
 * References an image URL in the content of a message.
 */
export type MessageContentImageUrlObject = {
  /**
   * The type of the content part.
   */
  type: 'image_url';
  image_url: {
    /**
     * The external URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.
     */
    url: string;
    /**
     * Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`. Default value is `auto`
     */
    detail?: 'auto' | 'low' | 'high';
  };
};

/**
 * The refusal content generated by the assistant.
 */
export type MessageContentRefusalObject = {
  /**
   * Always `refusal`.
   */
  type: 'refusal';
  refusal: string;
};

/**
 * A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.
 */
export type MessageContentTextAnnotationsFileCitationObject = {
  /**
   * Always `file_citation`.
   */
  type: 'file_citation';
  /**
   * The text in the message content that needs to be replaced.
   */
  text: string;
  file_citation: {
    /**
     * The ID of the specific File the citation is from.
     */
    file_id: string;
  };
  start_index: number;
  end_index: number;
};

/**
 * Always `file_citation`.
 */
export type type13 = 'file_citation';

/**
 * A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.
 */
export type MessageContentTextAnnotationsFilePathObject = {
  /**
   * Always `file_path`.
   */
  type: 'file_path';
  /**
   * The text in the message content that needs to be replaced.
   */
  text: string;
  file_path: {
    /**
     * The ID of the file that was generated.
     */
    file_id: string;
  };
  start_index: number;
  end_index: number;
};

/**
 * Always `file_path`.
 */
export type type14 = 'file_path';

/**
 * The text content that is part of a message.
 */
export type MessageContentTextObject = {
  /**
   * Always `text`.
   */
  type: 'text';
  text: {
    /**
     * The data that makes up the text.
     */
    value: string;
    annotations: Array<MessageContentTextAnnotationsFileCitationObject | MessageContentTextAnnotationsFilePathObject>;
  };
};

/**
 * References an image [File](/docs/api-reference/files) in the content of a message.
 */
export type MessageDeltaContentImageFileObject = {
  /**
   * The index of the content part in the message.
   */
  index: number;
  /**
   * Always `image_file`.
   */
  type: 'image_file';
  image_file?: {
    /**
     * The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.
     */
    file_id?: string;
    /**
     * Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.
     */
    detail?: 'auto' | 'low' | 'high';
  };
};

/**
 * References an image URL in the content of a message.
 */
export type MessageDeltaContentImageUrlObject = {
  /**
   * The index of the content part in the message.
   */
  index: number;
  /**
   * Always `image_url`.
   */
  type: 'image_url';
  image_url?: {
    /**
     * The URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.
     */
    url?: string;
    /**
     * Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`.
     */
    detail?: 'auto' | 'low' | 'high';
  };
};

/**
 * The refusal content that is part of a message.
 */
export type MessageDeltaContentRefusalObject = {
  /**
   * The index of the refusal part in the message.
   */
  index: number;
  /**
   * Always `refusal`.
   */
  type: 'refusal';
  refusal?: string;
};

/**
 * A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.
 */
export type MessageDeltaContentTextAnnotationsFileCitationObject = {
  /**
   * The index of the annotation in the text content part.
   */
  index: number;
  /**
   * Always `file_citation`.
   */
  type: 'file_citation';
  /**
   * The text in the message content that needs to be replaced.
   */
  text?: string;
  file_citation?: {
    /**
     * The ID of the specific File the citation is from.
     */
    file_id?: string;
    /**
     * The specific quote in the file.
     */
    quote?: string;
  };
  start_index?: number;
  end_index?: number;
};

/**
 * A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.
 */
export type MessageDeltaContentTextAnnotationsFilePathObject = {
  /**
   * The index of the annotation in the text content part.
   */
  index: number;
  /**
   * Always `file_path`.
   */
  type: 'file_path';
  /**
   * The text in the message content that needs to be replaced.
   */
  text?: string;
  file_path?: {
    /**
     * The ID of the file that was generated.
     */
    file_id?: string;
  };
  start_index?: number;
  end_index?: number;
};

/**
 * The text content that is part of a message.
 */
export type MessageDeltaContentTextObject = {
  /**
   * The index of the content part in the message.
   */
  index: number;
  /**
   * Always `text`.
   */
  type: 'text';
  text?: {
    /**
     * The data that makes up the text.
     */
    value?: string;
    annotations?: Array<
      MessageDeltaContentTextAnnotationsFileCitationObject | MessageDeltaContentTextAnnotationsFilePathObject
    >;
  };
};

/**
 * Represents a message delta i.e. any changed fields on a message during streaming.
 *
 */
export type MessageDeltaObject = {
  /**
   * The identifier of the message, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread.message.delta`.
   */
  object: 'thread.message.delta';
  /**
   * The delta containing the fields that have changed on the Message.
   */
  delta: {
    /**
     * The entity that produced the message. One of `user` or `assistant`.
     */
    role?: 'user' | 'assistant';
    /**
     * The content of the message in array of text and/or images.
     */
    content?: Array<
      | MessageDeltaContentImageFileObject
      | MessageDeltaContentTextObject
      | MessageDeltaContentRefusalObject
      | MessageDeltaContentImageUrlObject
    >;
  };
};

/**
 * The object type, which is always `thread.message.delta`.
 */
export type object19 = 'thread.message.delta';

/**
 * Represents a message within a [thread](/docs/api-reference/threads).
 */
export type MessageObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread.message`.
   */
  object: 'thread.message';
  /**
   * The Unix timestamp (in seconds) for when the message was created.
   */
  created_at: number;
  /**
   * The [thread](/docs/api-reference/threads) ID that this message belongs to.
   */
  thread_id: string;
  /**
   * The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.
   */
  status: 'in_progress' | 'incomplete' | 'completed';
  /**
   * On an incomplete message, details about why the message is incomplete.
   */
  incomplete_details: {
    /**
     * The reason the message is incomplete.
     */
    reason: 'content_filter' | 'max_tokens' | 'run_cancelled' | 'run_expired' | 'run_failed';
  } | null;
  /**
   * The Unix timestamp (in seconds) for when the message was completed.
   */
  completed_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the message was marked as incomplete.
   */
  incomplete_at: number | null;
  /**
   * The entity that produced the message. One of `user` or `assistant`.
   */
  role: 'user' | 'assistant';
  /**
   * The content of the message in array of text and/or images.
   */
  content: Array<
    | MessageContentImageFileObject
    | MessageContentImageUrlObject
    | MessageContentTextObject
    | MessageContentRefusalObject
  >;
  /**
   * If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.
   */
  assistant_id: string | null;
  /**
   * The ID of the [run](/docs/api-reference/runs) associated with the creation of this message. Value is `null` when messages are created manually using the create message or create thread endpoints.
   */
  run_id: string | null;
  /**
   * A list of files attached to the message, and the tools they were added to.
   */
  attachments: Array<{
    /**
     * The ID of the file to attach to the message.
     */
    file_id?: string;
    /**
     * The tools to add this file to.
     */
    tools?: Array<AssistantToolsCode | AssistantToolsFileSearchTypeOnly>;
  }> | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
};

/**
 * The object type, which is always `thread.message`.
 */
export type object20 = 'thread.message';

/**
 * The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.
 */
export type status4 = 'in_progress' | 'incomplete' | 'completed';

/**
 * The reason the message is incomplete.
 */
export type reason = 'content_filter' | 'max_tokens' | 'run_cancelled' | 'run_expired' | 'run_failed';

/**
 * The text content that is part of a message.
 */
export type MessageRequestContentTextObject = {
  /**
   * Always `text`.
   */
  type: 'text';
  /**
   * Text content to be sent to the model
   */
  text: string;
};

export type MessageStreamEvent =
  | {
      event: 'thread.message.created';
      data: MessageObject;
    }
  | {
      event: 'thread.message.in_progress';
      data: MessageObject;
    }
  | {
      event: 'thread.message.delta';
      data: MessageDeltaObject;
    }
  | {
      event: 'thread.message.completed';
      data: MessageObject;
    }
  | {
      event: 'thread.message.incomplete';
      data: MessageObject;
    };

export type event3 = 'thread.message.created';

/**
 * Describes an OpenAI model offering that can be used with the API.
 */
export type Model = {
  /**
   * The model identifier, which can be referenced in the API endpoints.
   */
  id: string;
  /**
   * The Unix timestamp (in seconds) when the model was created.
   */
  created: number;
  /**
   * The object type, which is always "model".
   */
  object: 'model';
  /**
   * The organization that owns the model.
   */
  owned_by: string;
};

/**
 * The object type, which is always "model".
 */
export type object21 = 'model';

export type ModifyAssistantRequest = {
  /**
   * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
   *
   */
  model?: string;
  /**
   * The name of the assistant. The maximum length is 256 characters.
   *
   */
  name?: string | null;
  /**
   * The description of the assistant. The maximum length is 512 characters.
   *
   */
  description?: string | null;
  /**
   * The system instructions that the assistant uses. The maximum length is 256,000 characters.
   *
   */
  instructions?: string | null;
  /**
   * A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.
   *
   */
  tools?: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction>;
  /**
   * A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * Overrides the list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: {
      /**
       * Overrides the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
       *
       */
      vector_store_ids?: Array<string>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
  /**
   * empty
   */
  temperature?: number | null;
  /**
   * empty
   */
  top_p?: number | null;
  response_format?: AssistantsApiResponseFormatOption;
};

export type ModifyMessageRequest = {
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

export type ModifyRunRequest = {
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

export type ModifyThreadRequest = {
  /**
   * A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources?: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: {
      /**
       * The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
       *
       */
      vector_store_ids?: Array<string>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

/**
 * The `File` object represents a document that has been uploaded to OpenAI.
 */
export type OpenAIFile = {
  /**
   * The file identifier, which can be referenced in the API endpoints.
   */
  id: string;
  /**
   * The size of the file, in bytes.
   */
  bytes: number;
  /**
   * The Unix timestamp (in seconds) for when the file was created.
   */
  created_at: number;
  /**
   * The name of the file.
   */
  filename: string;
  /**
   * The object type, which is always `file`.
   */
  object: 'file';
  /**
   * The intended purpose of the file. Supported values are `assistants`, `assistants_output`, `batch`, `batch_output`, `fine-tune`, `fine-tune-results` and `vision`.
   */
  purpose: 'assistants' | 'assistants_output' | 'batch' | 'batch_output' | 'fine-tune' | 'fine-tune-results' | 'vision';
  /**
   * Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
   * @deprecated
   */
  status: 'uploaded' | 'processed' | 'error';
  /**
   * Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.
   * @deprecated
   */
  status_details?: string;
};

/**
 * The intended purpose of the file. Supported values are `assistants`, `assistants_output`, `batch`, `batch_output`, `fine-tune`, `fine-tune-results` and `vision`.
 */
export type purpose2 =
  | 'assistants'
  | 'assistants_output'
  | 'batch'
  | 'batch_output'
  | 'fine-tune'
  | 'fine-tune-results'
  | 'vision';

/**
 * Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
 * @deprecated
 */
export type status5 = 'uploaded' | 'processed' | 'error';

/**
 * This is returned when the chunking strategy is unknown. Typically, this is because the file was indexed before the `chunking_strategy` concept was introduced in the API.
 */
export type OtherChunkingStrategyResponseParam = {
  /**
   * Always `other`.
   */
  type: 'other';
};

/**
 * Always `other`.
 */
export type type15 = 'other';

/**
 * Whether to enable [parallel function calling](/docs/guides/function-calling/parallel-function-calling) during tool use.
 */
export type ParallelToolCalls = boolean | null;

/**
 * Represents an individual project.
 */
export type Project = {
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  /**
   * The object type, which is always `organization.project`
   */
  object: 'organization.project';
  /**
   * The name of the project. This appears in reporting.
   */
  name: string;
  /**
   * The Unix timestamp (in seconds) of when the project was created.
   */
  created_at: number;
  /**
   * The Unix timestamp (in seconds) of when the project was archived or `null`.
   */
  archived_at?: number | null;
  /**
   * `active` or `archived`
   */
  status: 'active' | 'archived';
};

/**
 * The object type, which is always `organization.project`
 */
export type object22 = 'organization.project';

/**
 * `active` or `archived`
 */
export type status6 = 'active' | 'archived';

/**
 * Represents an individual API key in a project.
 */
export type ProjectApiKey = {
  /**
   * The object type, which is always `organization.project.api_key`
   */
  object: 'organization.project.api_key';
  /**
   * The redacted value of the API key
   */
  redacted_value: string;
  /**
   * The name of the API key
   */
  name: string;
  /**
   * The Unix timestamp (in seconds) of when the API key was created
   */
  created_at: number;
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  owner: {
    /**
     * `user` or `service_account`
     */
    type?: 'user' | 'service_account';
    user?: ProjectUser;
    service_account?: ProjectServiceAccount;
  };
};

/**
 * The object type, which is always `organization.project.api_key`
 */
export type object23 = 'organization.project.api_key';

export type ProjectApiKeyDeleteResponse = {
  object: 'organization.project.api_key.deleted';
  id: string;
  deleted: boolean;
};

export type object24 = 'organization.project.api_key.deleted';

export type ProjectApiKeyListResponse = {
  object: 'list';
  data: Array<ProjectApiKey>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ProjectCreateRequest = {
  /**
   * The friendly name of the project, this name appears in reports.
   */
  name: string;
};

export type ProjectListResponse = {
  object: 'list';
  data: Array<Project>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

/**
 * Represents an individual service account in a project.
 */
export type ProjectServiceAccount = {
  /**
   * The object type, which is always `organization.project.service_account`
   */
  object: 'organization.project.service_account';
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  /**
   * The name of the service account
   */
  name: string;
  /**
   * `owner` or `member`
   */
  role: 'owner' | 'member';
  /**
   * The Unix timestamp (in seconds) of when the service account was created
   */
  created_at: number;
};

/**
 * The object type, which is always `organization.project.service_account`
 */
export type object25 = 'organization.project.service_account';

/**
 * `owner` or `member`
 */
export type role9 = 'owner' | 'member';

export type ProjectServiceAccountApiKey = {
  /**
   * The object type, which is always `organization.project.service_account.api_key`
   */
  object: 'organization.project.service_account.api_key';
  value: string;
  name: string;
  created_at: number;
  id: string;
};

/**
 * The object type, which is always `organization.project.service_account.api_key`
 */
export type object26 = 'organization.project.service_account.api_key';

export type ProjectServiceAccountCreateRequest = {
  /**
   * The name of the service account being created.
   */
  name: string;
};

export type ProjectServiceAccountCreateResponse = {
  object: 'organization.project.service_account';
  id: string;
  name: string;
  /**
   * Service accounts can only have one role of type `member`
   */
  role: 'member';
  created_at: number;
  api_key: ProjectServiceAccountApiKey;
};

/**
 * Service accounts can only have one role of type `member`
 */
export type role10 = 'member';

export type ProjectServiceAccountDeleteResponse = {
  object: 'organization.project.service_account.deleted';
  id: string;
  deleted: boolean;
};

export type object27 = 'organization.project.service_account.deleted';

export type ProjectServiceAccountListResponse = {
  object: 'list';
  data: Array<ProjectServiceAccount>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ProjectUpdateRequest = {
  /**
   * The updated name of the project, this name appears in reports.
   */
  name: string;
};

/**
 * Represents an individual user in a project.
 */
export type ProjectUser = {
  /**
   * The object type, which is always `organization.project.user`
   */
  object: 'organization.project.user';
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  /**
   * The name of the user
   */
  name: string;
  /**
   * The email address of the user
   */
  email: string;
  /**
   * `owner` or `member`
   */
  role: 'owner' | 'member';
  /**
   * The Unix timestamp (in seconds) of when the project was added.
   */
  added_at: number;
};

/**
 * The object type, which is always `organization.project.user`
 */
export type object28 = 'organization.project.user';

export type ProjectUserCreateRequest = {
  /**
   * The ID of the user.
   */
  user_id: string;
  /**
   * `owner` or `member`
   */
  role: 'owner' | 'member';
};

export type ProjectUserDeleteResponse = {
  object: 'organization.project.user.deleted';
  id: string;
  deleted: boolean;
};

export type object29 = 'organization.project.user.deleted';

export type ProjectUserListResponse = {
  object: string;
  data: Array<ProjectUser>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type ProjectUserUpdateRequest = {
  /**
   * `owner` or `member`
   */
  role: 'owner' | 'member';
};

export type ResponseFormatJsonObject = {
  /**
   * The type of response format being defined: `json_object`
   */
  type: 'json_object';
};

/**
 * The type of response format being defined: `json_object`
 */
export type type16 = 'json_object';

export type ResponseFormatJsonSchema = {
  /**
   * The type of response format being defined: `json_schema`
   */
  type: 'json_schema';
  json_schema: {
    /**
     * A description of what the response format is for, used by the model to determine how to respond in the format.
     */
    description?: string;
    /**
     * The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
     */
    name: string;
    schema?: ResponseFormatJsonSchemaSchema;
    /**
     * Whether to enable strict schema adherence when generating the output. If set to true, the model will always follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is supported when `strict` is `true`. To learn more, read the [Structured Outputs guide](/docs/guides/structured-outputs).
     */
    strict?: boolean | null;
  };
};

/**
 * The type of response format being defined: `json_schema`
 */
export type type17 = 'json_schema';

/**
 * The schema for the response format, described as a JSON Schema object.
 */
export type ResponseFormatJsonSchemaSchema = {
  [key: string]: unknown;
};

export type ResponseFormatText = {
  /**
   * The type of response format being defined: `text`
   */
  type: 'text';
};

/**
 * Usage statistics related to the run. This value will be `null` if the run is not in a terminal state (i.e. `in_progress`, `queued`, etc.).
 */
export type RunCompletionUsage = {
  /**
   * Number of completion tokens used over the course of the run.
   */
  completion_tokens: number;
  /**
   * Number of prompt tokens used over the course of the run.
   */
  prompt_tokens: number;
  /**
   * Total number of tokens used (prompt + completion).
   */
  total_tokens: number;
} | null;

/**
 * Represents an execution run on a [thread](/docs/api-reference/threads).
 */
export type RunObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread.run`.
   */
  object: 'thread.run';
  /**
   * The Unix timestamp (in seconds) for when the run was created.
   */
  created_at: number;
  /**
   * The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.
   */
  thread_id: string;
  /**
   * The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.
   */
  assistant_id: string;
  /**
   * The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, `incomplete`, or `expired`.
   */
  status:
    | 'queued'
    | 'in_progress'
    | 'requires_action'
    | 'cancelling'
    | 'cancelled'
    | 'failed'
    | 'completed'
    | 'incomplete'
    | 'expired';
  /**
   * Details on the action required to continue the run. Will be `null` if no action is required.
   */
  required_action: {
    /**
     * For now, this is always `submit_tool_outputs`.
     */
    type: 'submit_tool_outputs';
    /**
     * Details on the tool outputs needed for this run to continue.
     */
    submit_tool_outputs: {
      /**
       * A list of the relevant tool calls.
       */
      tool_calls: Array<RunToolCallObject>;
    };
  } | null;
  /**
   * The last error associated with this run. Will be `null` if there are no errors.
   */
  last_error: {
    /**
     * One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.
     */
    code: 'server_error' | 'rate_limit_exceeded' | 'invalid_prompt';
    /**
     * A human-readable description of the error.
     */
    message: string;
  } | null;
  /**
   * The Unix timestamp (in seconds) for when the run will expire.
   */
  expires_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run was started.
   */
  started_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run was cancelled.
   */
  cancelled_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run failed.
   */
  failed_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run was completed.
   */
  completed_at: number | null;
  /**
   * Details on why the run is incomplete. Will be `null` if the run is not incomplete.
   */
  incomplete_details: {
    /**
     * The reason why the run is incomplete. This will point to which specific token limit was reached over the course of the run.
     */
    reason?: 'max_completion_tokens' | 'max_prompt_tokens';
  } | null;
  /**
   * The model that the [assistant](/docs/api-reference/assistants) used for this run.
   */
  model: string;
  /**
   * The instructions that the [assistant](/docs/api-reference/assistants) used for this run.
   */
  instructions: string;
  /**
   * The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.
   */
  tools: Array<AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction>;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
  usage: RunCompletionUsage;
  /**
   * The sampling temperature used for this run. If not set, defaults to 1.
   */
  temperature?: number | null;
  /**
   * The nucleus sampling value used for this run. If not set, defaults to 1.
   */
  top_p?: number | null;
  /**
   * The maximum number of prompt tokens specified to have been used over the course of the run.
   *
   */
  max_prompt_tokens: number | null;
  /**
   * The maximum number of completion tokens specified to have been used over the course of the run.
   *
   */
  max_completion_tokens: number | null;
  truncation_strategy: TruncationObject;
  tool_choice: AssistantsApiToolChoiceOption;
  parallel_tool_calls: ParallelToolCalls;
  response_format: AssistantsApiResponseFormatOption;
};

/**
 * The object type, which is always `thread.run`.
 */
export type object30 = 'thread.run';

/**
 * The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, `incomplete`, or `expired`.
 */
export type status7 =
  | 'queued'
  | 'in_progress'
  | 'requires_action'
  | 'cancelling'
  | 'cancelled'
  | 'failed'
  | 'completed'
  | 'incomplete'
  | 'expired';

/**
 * For now, this is always `submit_tool_outputs`.
 */
export type type18 = 'submit_tool_outputs';

/**
 * One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.
 */
export type code = 'server_error' | 'rate_limit_exceeded' | 'invalid_prompt';

/**
 * The reason why the run is incomplete. This will point to which specific token limit was reached over the course of the run.
 */
export type reason2 = 'max_completion_tokens' | 'max_prompt_tokens';

/**
 * Usage statistics related to the run step. This value will be `null` while the run step's status is `in_progress`.
 */
export type RunStepCompletionUsage = {
  /**
   * Number of completion tokens used over the course of the run step.
   */
  completion_tokens: number;
  /**
   * Number of prompt tokens used over the course of the run step.
   */
  prompt_tokens: number;
  /**
   * Total number of tokens used (prompt + completion).
   */
  total_tokens: number;
} | null;

/**
 * Represents a run step delta i.e. any changed fields on a run step during streaming.
 *
 */
export type RunStepDeltaObject = {
  /**
   * The identifier of the run step, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread.run.step.delta`.
   */
  object: 'thread.run.step.delta';
  /**
   * The delta containing the fields that have changed on the run step.
   */
  delta: {
    /**
     * The details of the run step.
     */
    step_details?: RunStepDeltaStepDetailsMessageCreationObject | RunStepDeltaStepDetailsToolCallsObject;
  };
};

/**
 * The object type, which is always `thread.run.step.delta`.
 */
export type object31 = 'thread.run.step.delta';

/**
 * Details of the message creation by the run step.
 */
export type RunStepDeltaStepDetailsMessageCreationObject = {
  /**
   * Always `message_creation`.
   */
  type: 'message_creation';
  message_creation?: {
    /**
     * The ID of the message that was created by this run step.
     */
    message_id?: string;
  };
};

/**
 * Always `message_creation`.
 */
export type type19 = 'message_creation';

/**
 * Details of the Code Interpreter tool call the run step was involved in.
 */
export type RunStepDeltaStepDetailsToolCallsCodeObject = {
  /**
   * The index of the tool call in the tool calls array.
   */
  index: number;
  /**
   * The ID of the tool call.
   */
  id?: string;
  /**
   * The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
   */
  type: 'code_interpreter';
  /**
   * The Code Interpreter tool call definition.
   */
  code_interpreter?: {
    /**
     * The input to the Code Interpreter tool call.
     */
    input?: string;
    /**
     * The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
     */
    outputs?: Array<
      RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject | RunStepDeltaStepDetailsToolCallsCodeOutputImageObject
    >;
  };
};

export type RunStepDeltaStepDetailsToolCallsCodeOutputImageObject = {
  /**
   * The index of the output in the outputs array.
   */
  index: number;
  /**
   * Always `image`.
   */
  type: 'image';
  image?: {
    /**
     * The [file](/docs/api-reference/files) ID of the image.
     */
    file_id?: string;
  };
};

/**
 * Always `image`.
 */
export type type20 = 'image';

/**
 * Text output from the Code Interpreter tool call as part of a run step.
 */
export type RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject = {
  /**
   * The index of the output in the outputs array.
   */
  index: number;
  /**
   * Always `logs`.
   */
  type: 'logs';
  /**
   * The text output from the Code Interpreter tool call.
   */
  logs?: string;
};

/**
 * Always `logs`.
 */
export type type21 = 'logs';

export type RunStepDeltaStepDetailsToolCallsFileSearchObject = {
  /**
   * The index of the tool call in the tool calls array.
   */
  index: number;
  /**
   * The ID of the tool call object.
   */
  id?: string;
  /**
   * The type of tool call. This is always going to be `file_search` for this type of tool call.
   */
  type: 'file_search';
  /**
   * For now, this is always going to be an empty object.
   */
  file_search: {
    [key: string]: unknown;
  };
};

export type RunStepDeltaStepDetailsToolCallsFunctionObject = {
  /**
   * The index of the tool call in the tool calls array.
   */
  index: number;
  /**
   * The ID of the tool call object.
   */
  id?: string;
  /**
   * The type of tool call. This is always going to be `function` for this type of tool call.
   */
  type: 'function';
  /**
   * The definition of the function that was called.
   */
  function?: {
    /**
     * The name of the function.
     */
    name?: string;
    /**
     * The arguments passed to the function.
     */
    arguments?: string;
    /**
     * The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
     */
    output?: string | null;
  };
};

/**
 * Details of the tool call.
 */
export type RunStepDeltaStepDetailsToolCallsObject = {
  /**
   * Always `tool_calls`.
   */
  type: 'tool_calls';
  /**
   * An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.
   *
   */
  tool_calls?: Array<
    | RunStepDeltaStepDetailsToolCallsCodeObject
    | RunStepDeltaStepDetailsToolCallsFileSearchObject
    | RunStepDeltaStepDetailsToolCallsFunctionObject
  >;
};

/**
 * Always `tool_calls`.
 */
export type type22 = 'tool_calls';

/**
 * Details of the message creation by the run step.
 */
export type RunStepDetailsMessageCreationObject = {
  /**
   * Always `message_creation`.
   */
  type: 'message_creation';
  message_creation: {
    /**
     * The ID of the message that was created by this run step.
     */
    message_id: string;
  };
};

/**
 * Details of the Code Interpreter tool call the run step was involved in.
 */
export type RunStepDetailsToolCallsCodeObject = {
  /**
   * The ID of the tool call.
   */
  id: string;
  /**
   * The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
   */
  type: 'code_interpreter';
  /**
   * The Code Interpreter tool call definition.
   */
  code_interpreter: {
    /**
     * The input to the Code Interpreter tool call.
     */
    input: string;
    /**
     * The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
     */
    outputs: Array<RunStepDetailsToolCallsCodeOutputLogsObject | RunStepDetailsToolCallsCodeOutputImageObject>;
  };
};

export type RunStepDetailsToolCallsCodeOutputImageObject = {
  /**
   * Always `image`.
   */
  type: 'image';
  image: {
    /**
     * The [file](/docs/api-reference/files) ID of the image.
     */
    file_id: string;
  };
};

/**
 * Text output from the Code Interpreter tool call as part of a run step.
 */
export type RunStepDetailsToolCallsCodeOutputLogsObject = {
  /**
   * Always `logs`.
   */
  type: 'logs';
  /**
   * The text output from the Code Interpreter tool call.
   */
  logs: string;
};

export type RunStepDetailsToolCallsFileSearchObject = {
  /**
   * The ID of the tool call object.
   */
  id: string;
  /**
   * The type of tool call. This is always going to be `file_search` for this type of tool call.
   */
  type: 'file_search';
  /**
   * For now, this is always going to be an empty object.
   */
  file_search: {
    [key: string]: unknown;
  };
};

export type RunStepDetailsToolCallsFunctionObject = {
  /**
   * The ID of the tool call object.
   */
  id: string;
  /**
   * The type of tool call. This is always going to be `function` for this type of tool call.
   */
  type: 'function';
  /**
   * The definition of the function that was called.
   */
  function: {
    /**
     * The name of the function.
     */
    name: string;
    /**
     * The arguments passed to the function.
     */
    arguments: string;
    /**
     * The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
     */
    output: string | null;
  };
};

/**
 * Details of the tool call.
 */
export type RunStepDetailsToolCallsObject = {
  /**
   * Always `tool_calls`.
   */
  type: 'tool_calls';
  /**
   * An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.
   *
   */
  tool_calls: Array<
    RunStepDetailsToolCallsCodeObject | RunStepDetailsToolCallsFileSearchObject | RunStepDetailsToolCallsFunctionObject
  >;
};

/**
 * Represents a step in execution of a run.
 *
 */
export type RunStepObject = {
  /**
   * The identifier of the run step, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread.run.step`.
   */
  object: 'thread.run.step';
  /**
   * The Unix timestamp (in seconds) for when the run step was created.
   */
  created_at: number;
  /**
   * The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.
   */
  assistant_id: string;
  /**
   * The ID of the [thread](/docs/api-reference/threads) that was run.
   */
  thread_id: string;
  /**
   * The ID of the [run](/docs/api-reference/runs) that this run step is a part of.
   */
  run_id: string;
  /**
   * The type of run step, which can be either `message_creation` or `tool_calls`.
   */
  type: 'message_creation' | 'tool_calls';
  /**
   * The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
   */
  status: 'in_progress' | 'cancelled' | 'failed' | 'completed' | 'expired';
  /**
   * The details of the run step.
   */
  step_details: RunStepDetailsMessageCreationObject | RunStepDetailsToolCallsObject;
  /**
   * The last error associated with this run step. Will be `null` if there are no errors.
   */
  last_error: {
    /**
     * One of `server_error` or `rate_limit_exceeded`.
     */
    code: 'server_error' | 'rate_limit_exceeded';
    /**
     * A human-readable description of the error.
     */
    message: string;
  } | null;
  /**
   * The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.
   */
  expired_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run step was cancelled.
   */
  cancelled_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run step failed.
   */
  failed_at: number | null;
  /**
   * The Unix timestamp (in seconds) for when the run step completed.
   */
  completed_at: number | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
  usage: RunStepCompletionUsage;
};

/**
 * The object type, which is always `thread.run.step`.
 */
export type object32 = 'thread.run.step';

/**
 * The type of run step, which can be either `message_creation` or `tool_calls`.
 */
export type type23 = 'message_creation' | 'tool_calls';

/**
 * The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
 */
export type status8 = 'in_progress' | 'cancelled' | 'failed' | 'completed' | 'expired';

/**
 * One of `server_error` or `rate_limit_exceeded`.
 */
export type code2 = 'server_error' | 'rate_limit_exceeded';

export type RunStepStreamEvent =
  | {
      event: 'thread.run.step.created';
      data: RunStepObject;
    }
  | {
      event: 'thread.run.step.in_progress';
      data: RunStepObject;
    }
  | {
      event: 'thread.run.step.delta';
      data: RunStepDeltaObject;
    }
  | {
      event: 'thread.run.step.completed';
      data: RunStepObject;
    }
  | {
      event: 'thread.run.step.failed';
      data: RunStepObject;
    }
  | {
      event: 'thread.run.step.cancelled';
      data: RunStepObject;
    }
  | {
      event: 'thread.run.step.expired';
      data: RunStepObject;
    };

export type event4 = 'thread.run.step.created';

export type RunStreamEvent =
  | {
      event: 'thread.run.created';
      data: RunObject;
    }
  | {
      event: 'thread.run.queued';
      data: RunObject;
    }
  | {
      event: 'thread.run.in_progress';
      data: RunObject;
    }
  | {
      event: 'thread.run.requires_action';
      data: RunObject;
    }
  | {
      event: 'thread.run.completed';
      data: RunObject;
    }
  | {
      event: 'thread.run.incomplete';
      data: RunObject;
    }
  | {
      event: 'thread.run.failed';
      data: RunObject;
    }
  | {
      event: 'thread.run.cancelling';
      data: RunObject;
    }
  | {
      event: 'thread.run.cancelled';
      data: RunObject;
    }
  | {
      event: 'thread.run.expired';
      data: RunObject;
    };

export type event5 = 'thread.run.created';

/**
 * Tool call objects
 */
export type RunToolCallObject = {
  /**
   * The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.
   */
  id: string;
  /**
   * The type of tool call the output is required for. For now, this is always `function`.
   */
  type: 'function';
  /**
   * The function definition.
   */
  function: {
    /**
     * The name of the function.
     */
    name: string;
    /**
     * The arguments that the model expects you to pass to the function.
     */
    arguments: string;
  };
};

export type StaticChunkingStrategy = {
  /**
   * The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.
   */
  max_chunk_size_tokens: number;
  /**
   * The number of tokens that overlap between chunks. The default value is `400`.
   *
   * Note that the overlap must not exceed half of `max_chunk_size_tokens`.
   *
   */
  chunk_overlap_tokens: number;
};

export type StaticChunkingStrategyRequestParam = {
  /**
   * Always `static`.
   */
  type: 'static';
  static: StaticChunkingStrategy;
};

/**
 * Always `static`.
 */
export type type24 = 'static';

export type StaticChunkingStrategyResponseParam = {
  /**
   * Always `static`.
   */
  type: 'static';
  static: StaticChunkingStrategy;
};

export type SubmitToolOutputsRunRequest = {
  /**
   * A list of tools for which the outputs are being submitted.
   */
  tool_outputs: Array<{
    /**
     * The ID of the tool call in the `required_action` object within the run object the output is being submitted for.
     */
    tool_call_id?: string;
    /**
     * The output of the tool call to be submitted to continue the run.
     */
    output?: string;
  }>;
  /**
   * If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.
   *
   */
  stream?: boolean | null;
};

/**
 * Represents a thread that contains [messages](/docs/api-reference/messages).
 */
export type ThreadObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `thread`.
   */
  object: 'thread';
  /**
   * The Unix timestamp (in seconds) for when the thread was created.
   */
  created_at: number;
  /**
   * A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
   *
   */
  tool_resources: {
    code_interpreter?: {
      /**
       * A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.
       *
       */
      file_ids?: Array<string>;
    };
    file_search?: {
      /**
       * The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
       *
       */
      vector_store_ids?: Array<string>;
    };
  } | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
};

/**
 * The object type, which is always `thread`.
 */
export type object33 = 'thread';

export type ThreadStreamEvent = {
  event: 'thread.created';
  data: ThreadObject;
};

export type event6 = 'thread.created';

export type TranscriptionSegment = {
  /**
   * Unique identifier of the segment.
   */
  id: number;
  /**
   * Seek offset of the segment.
   */
  seek: number;
  /**
   * Start time of the segment in seconds.
   */
  start: number;
  /**
   * End time of the segment in seconds.
   */
  end: number;
  /**
   * Text content of the segment.
   */
  text: string;
  /**
   * Array of token IDs for the text content.
   */
  tokens: Array<number>;
  /**
   * Temperature parameter used for generating the segment.
   */
  temperature: number;
  /**
   * Average logprob of the segment. If the value is lower than -1, consider the logprobs failed.
   */
  avg_logprob: number;
  /**
   * Compression ratio of the segment. If the value is greater than 2.4, consider the compression failed.
   */
  compression_ratio: number;
  /**
   * Probability of no speech in the segment. If the value is higher than 1.0 and the `avg_logprob` is below -1, consider this segment silent.
   */
  no_speech_prob: number;
};

export type TranscriptionWord = {
  /**
   * The text content of the word.
   */
  word: string;
  /**
   * Start time of the word in seconds.
   */
  start: number;
  /**
   * End time of the word in seconds.
   */
  end: number;
};

/**
 * Controls for how a thread will be truncated prior to the run. Use this to control the intial context window of the run.
 */
export type TruncationObject = {
  /**
   * The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will be truncated to the n most recent messages in the thread. When set to `auto`, messages in the middle of the thread will be dropped to fit the context length of the model, `max_prompt_tokens`.
   */
  type: 'auto' | 'last_messages';
  /**
   * The number of most recent messages from the thread when constructing the context for the run.
   */
  last_messages?: number | null;
};

/**
 * The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will be truncated to the n most recent messages in the thread. When set to `auto`, messages in the middle of the thread will be dropped to fit the context length of the model, `max_prompt_tokens`.
 */
export type type25 = 'auto' | 'last_messages';

export type UpdateVectorStoreRequest = {
  /**
   * The name of the vector store.
   */
  name?: string | null;
  expires_after?: VectorStoreExpirationAfter;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata?: {
    [key: string]: unknown;
  } | null;
};

/**
 * The Upload object can accept byte chunks in the form of Parts.
 *
 */
export type Upload = {
  /**
   * The Upload unique identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The Unix timestamp (in seconds) for when the Upload was created.
   */
  created_at: number;
  /**
   * The name of the file to be uploaded.
   */
  filename: string;
  /**
   * The intended number of bytes to be uploaded.
   */
  bytes: number;
  /**
   * The intended purpose of the file. [Please refer here](/docs/api-reference/files/object#files/object-purpose) for acceptable values.
   */
  purpose: string;
  /**
   * The status of the Upload.
   */
  status: 'pending' | 'completed' | 'cancelled' | 'expired';
  /**
   * The Unix timestamp (in seconds) for when the Upload was created.
   */
  expires_at: number;
  /**
   * The object type, which is always "upload".
   */
  object?: 'upload';
  file?: OpenAIFile;
};

/**
 * The status of the Upload.
 */
export type status9 = 'pending' | 'completed' | 'cancelled' | 'expired';

/**
 * The object type, which is always "upload".
 */
export type object34 = 'upload';

/**
 * The upload Part represents a chunk of bytes we can add to an Upload object.
 *
 */
export type UploadPart = {
  /**
   * The upload Part unique identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The Unix timestamp (in seconds) for when the Part was created.
   */
  created_at: number;
  /**
   * The ID of the Upload object that this Part was added to.
   */
  upload_id: string;
  /**
   * The object type, which is always `upload.part`.
   */
  object: 'upload.part';
};

/**
 * The object type, which is always `upload.part`.
 */
export type object35 = 'upload.part';

/**
 * Represents an individual `user` within an organization.
 */
export type User = {
  /**
   * The object type, which is always `organization.user`
   */
  object: 'organization.user';
  /**
   * The identifier, which can be referenced in API endpoints
   */
  id: string;
  /**
   * The name of the user
   */
  name: string;
  /**
   * The email address of the user
   */
  email: string;
  /**
   * `owner` or `reader`
   */
  role: 'owner' | 'reader';
  /**
   * The Unix timestamp (in seconds) of when the user was added.
   */
  added_at: number;
};

/**
 * The object type, which is always `organization.user`
 */
export type object36 = 'organization.user';

export type UserDeleteResponse = {
  object: 'organization.user.deleted';
  id: string;
  deleted: boolean;
};

export type object37 = 'organization.user.deleted';

export type UserListResponse = {
  object: 'list';
  data: Array<User>;
  first_id: string;
  last_id: string;
  has_more: boolean;
};

export type UserRoleUpdateRequest = {
  /**
   * `owner` or `reader`
   */
  role: 'owner' | 'reader';
};

/**
 * The expiration policy for a vector store.
 */
export type VectorStoreExpirationAfter = {
  /**
   * Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.
   */
  anchor: 'last_active_at';
  /**
   * The number of days after the anchor time that the vector store will expire.
   */
  days: number;
};

/**
 * Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.
 */
export type anchor = 'last_active_at';

/**
 * A batch of files attached to a vector store.
 */
export type VectorStoreFileBatchObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `vector_store.file_batch`.
   */
  object: 'vector_store.files_batch';
  /**
   * The Unix timestamp (in seconds) for when the vector store files batch was created.
   */
  created_at: number;
  /**
   * The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.
   */
  vector_store_id: string;
  /**
   * The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.
   */
  status: 'in_progress' | 'completed' | 'cancelled' | 'failed';
  file_counts: {
    /**
     * The number of files that are currently being processed.
     */
    in_progress: number;
    /**
     * The number of files that have been processed.
     */
    completed: number;
    /**
     * The number of files that have failed to process.
     */
    failed: number;
    /**
     * The number of files that where cancelled.
     */
    cancelled: number;
    /**
     * The total number of files.
     */
    total: number;
  };
};

/**
 * The object type, which is always `vector_store.file_batch`.
 */
export type object38 = 'vector_store.files_batch';

/**
 * The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.
 */
export type status10 = 'in_progress' | 'completed' | 'cancelled' | 'failed';

/**
 * A list of files attached to a vector store.
 */
export type VectorStoreFileObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `vector_store.file`.
   */
  object: 'vector_store.file';
  /**
   * The total vector store usage in bytes. Note that this may be different from the original file size.
   */
  usage_bytes: number;
  /**
   * The Unix timestamp (in seconds) for when the vector store file was created.
   */
  created_at: number;
  /**
   * The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.
   */
  vector_store_id: string;
  /**
   * The status of the vector store file, which can be either `in_progress`, `completed`, `cancelled`, or `failed`. The status `completed` indicates that the vector store file is ready for use.
   */
  status: 'in_progress' | 'completed' | 'cancelled' | 'failed';
  /**
   * The last error associated with this vector store file. Will be `null` if there are no errors.
   */
  last_error: {
    /**
     * One of `server_error` or `rate_limit_exceeded`.
     */
    code: 'server_error' | 'unsupported_file' | 'invalid_file';
    /**
     * A human-readable description of the error.
     */
    message: string;
  } | null;
  /**
   * The strategy used to chunk the file.
   */
  chunking_strategy?: StaticChunkingStrategyResponseParam | OtherChunkingStrategyResponseParam;
};

/**
 * The object type, which is always `vector_store.file`.
 */
export type object39 = 'vector_store.file';

/**
 * One of `server_error` or `rate_limit_exceeded`.
 */
export type code3 = 'server_error' | 'unsupported_file' | 'invalid_file';

/**
 * A vector store is a collection of processed files can be used by the `file_search` tool.
 */
export type VectorStoreObject = {
  /**
   * The identifier, which can be referenced in API endpoints.
   */
  id: string;
  /**
   * The object type, which is always `vector_store`.
   */
  object: 'vector_store';
  /**
   * The Unix timestamp (in seconds) for when the vector store was created.
   */
  created_at: number;
  /**
   * The name of the vector store.
   */
  name: string;
  /**
   * The total number of bytes used by the files in the vector store.
   */
  usage_bytes: number;
  file_counts: {
    /**
     * The number of files that are currently being processed.
     */
    in_progress: number;
    /**
     * The number of files that have been successfully processed.
     */
    completed: number;
    /**
     * The number of files that have failed to process.
     */
    failed: number;
    /**
     * The number of files that were cancelled.
     */
    cancelled: number;
    /**
     * The total number of files.
     */
    total: number;
  };
  /**
   * The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.
   */
  status: 'expired' | 'in_progress' | 'completed';
  expires_after?: VectorStoreExpirationAfter;
  /**
   * The Unix timestamp (in seconds) for when the vector store will expire.
   */
  expires_at?: number | null;
  /**
   * The Unix timestamp (in seconds) for when the vector store was last active.
   */
  last_active_at: number | null;
  /**
   * Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
   *
   */
  metadata: {
    [key: string]: unknown;
  } | null;
};

/**
 * The object type, which is always `vector_store`.
 */
export type object40 = 'vector_store';

/**
 * The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.
 */
export type status11 = 'expired' | 'in_progress' | 'completed';

export type CreateChatCompletionData = {
  body: CreateChatCompletionRequest;
};

export type CreateChatCompletionResponse2 = CreateChatCompletionResponse;

export type CreateChatCompletionError = unknown;

export type CreateCompletionData = {
  body: CreateCompletionRequest;
};

export type CreateCompletionResponse2 = CreateCompletionResponse;

export type CreateCompletionError = unknown;

export type CreateImageData = {
  body: CreateImageRequest;
};

export type CreateImageResponse = ImagesResponse;

export type CreateImageError = unknown;

export type CreateImageEditData = {
  body: CreateImageEditRequest;
};

export type CreateImageEditResponse = ImagesResponse;

export type CreateImageEditError = unknown;

export type CreateImageVariationData = {
  body: CreateImageVariationRequest;
};

export type CreateImageVariationResponse = ImagesResponse;

export type CreateImageVariationError = unknown;

export type CreateEmbeddingData = {
  body: CreateEmbeddingRequest;
};

export type CreateEmbeddingResponse2 = CreateEmbeddingResponse;

export type CreateEmbeddingError = unknown;

export type CreateSpeechData = {
  body: CreateSpeechRequest;
};

export type CreateSpeechResponse = Blob | File;

export type CreateSpeechError = unknown;

export type CreateTranscriptionData = {
  body: CreateTranscriptionRequest;
};

export type CreateTranscriptionResponse = CreateTranscriptionResponseJson | CreateTranscriptionResponseVerboseJson;

export type CreateTranscriptionError = unknown;

export type CreateTranslationData = {
  body: CreateTranslationRequest;
};

export type CreateTranslationResponse = CreateTranslationResponseJson | CreateTranslationResponseVerboseJson;

export type CreateTranslationError = unknown;

export type ListFilesData = {
  query?: {
    /**
     * Only return files with the given purpose.
     */
    purpose?: string;
  };
};

export type ListFilesResponse2 = ListFilesResponse;

export type ListFilesError = unknown;

export type CreateFileData = {
  body: CreateFileRequest;
};

export type CreateFileResponse = OpenAIFile;

export type CreateFileError = unknown;

export type DeleteFileData = {
  path: {
    /**
     * The ID of the file to use for this request.
     */
    file_id: string;
  };
};

export type DeleteFileResponse2 = DeleteFileResponse;

export type DeleteFileError = unknown;

export type RetrieveFileData = {
  path: {
    /**
     * The ID of the file to use for this request.
     */
    file_id: string;
  };
};

export type RetrieveFileResponse = OpenAIFile;

export type RetrieveFileError = unknown;

export type DownloadFileData = {
  path: {
    /**
     * The ID of the file to use for this request.
     */
    file_id: string;
  };
};

export type DownloadFileResponse = string;

export type DownloadFileError = unknown;

export type CreateUploadData = {
  body: CreateUploadRequest;
};

export type CreateUploadResponse = Upload;

export type CreateUploadError = unknown;

export type AddUploadPartData = {
  body: AddUploadPartRequest;
  path: {
    /**
     * The ID of the Upload.
     *
     */
    upload_id: string;
  };
};

export type AddUploadPartResponse = UploadPart;

export type AddUploadPartError = unknown;

export type CompleteUploadData = {
  body: CompleteUploadRequest;
  path: {
    /**
     * The ID of the Upload.
     *
     */
    upload_id: string;
  };
};

export type CompleteUploadResponse = Upload;

export type CompleteUploadError = unknown;

export type CancelUploadData = {
  path: {
    /**
     * The ID of the Upload.
     *
     */
    upload_id: string;
  };
};

export type CancelUploadResponse = Upload;

export type CancelUploadError = unknown;

export type CreateFineTuningJobData = {
  body: CreateFineTuningJobRequest;
};

export type CreateFineTuningJobResponse = FineTuningJob;

export type CreateFineTuningJobError = unknown;

export type ListPaginatedFineTuningJobsData = {
  query?: {
    /**
     * Identifier for the last job from the previous pagination request.
     */
    after?: string;
    /**
     * Number of fine-tuning jobs to retrieve.
     */
    limit?: number;
  };
};

export type ListPaginatedFineTuningJobsResponse2 = ListPaginatedFineTuningJobsResponse;

export type ListPaginatedFineTuningJobsError = unknown;

export type RetrieveFineTuningJobData = {
  path: {
    /**
     * The ID of the fine-tuning job.
     *
     */
    fine_tuning_job_id: string;
  };
};

export type RetrieveFineTuningJobResponse = FineTuningJob;

export type RetrieveFineTuningJobError = unknown;

export type ListFineTuningEventsData = {
  path: {
    /**
     * The ID of the fine-tuning job to get events for.
     *
     */
    fine_tuning_job_id: string;
  };
  query?: {
    /**
     * Identifier for the last event from the previous pagination request.
     */
    after?: string;
    /**
     * Number of events to retrieve.
     */
    limit?: number;
  };
};

export type ListFineTuningEventsResponse = ListFineTuningJobEventsResponse;

export type ListFineTuningEventsError = unknown;

export type CancelFineTuningJobData = {
  path: {
    /**
     * The ID of the fine-tuning job to cancel.
     *
     */
    fine_tuning_job_id: string;
  };
};

export type CancelFineTuningJobResponse = FineTuningJob;

export type CancelFineTuningJobError = unknown;

export type ListFineTuningJobCheckpointsData = {
  path: {
    /**
     * The ID of the fine-tuning job to get checkpoints for.
     *
     */
    fine_tuning_job_id: string;
  };
  query?: {
    /**
     * Identifier for the last checkpoint ID from the previous pagination request.
     */
    after?: string;
    /**
     * Number of checkpoints to retrieve.
     */
    limit?: number;
  };
};

export type ListFineTuningJobCheckpointsResponse2 = ListFineTuningJobCheckpointsResponse;

export type ListFineTuningJobCheckpointsError = unknown;

export type ListModelsResponse2 = ListModelsResponse;

export type ListModelsError = unknown;

export type RetrieveModelData = {
  path: {
    /**
     * The ID of the model to use for this request
     */
    model: string;
  };
};

export type RetrieveModelResponse = Model;

export type RetrieveModelError = unknown;

export type DeleteModelData = {
  path: {
    /**
     * The model to delete
     */
    model: string;
  };
};

export type DeleteModelResponse2 = DeleteModelResponse;

export type DeleteModelError = unknown;

export type CreateModerationData = {
  body: CreateModerationRequest;
};

export type CreateModerationResponse2 = CreateModerationResponse;

export type CreateModerationError = unknown;

export type ListAssistantsData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListAssistantsResponse2 = ListAssistantsResponse;

export type ListAssistantsError = unknown;

export type CreateAssistantData = {
  body: CreateAssistantRequest;
};

export type CreateAssistantResponse = AssistantObject;

export type CreateAssistantError = unknown;

export type GetAssistantData = {
  path: {
    /**
     * The ID of the assistant to retrieve.
     */
    assistant_id: string;
  };
};

export type GetAssistantResponse = AssistantObject;

export type GetAssistantError = unknown;

export type ModifyAssistantData = {
  body: ModifyAssistantRequest;
  path: {
    /**
     * The ID of the assistant to modify.
     */
    assistant_id: string;
  };
};

export type ModifyAssistantResponse = AssistantObject;

export type ModifyAssistantError = unknown;

export type DeleteAssistantData = {
  path: {
    /**
     * The ID of the assistant to delete.
     */
    assistant_id: string;
  };
};

export type DeleteAssistantResponse2 = DeleteAssistantResponse;

export type DeleteAssistantError = unknown;

export type CreateThreadData = {
  body?: CreateThreadRequest;
};

export type CreateThreadResponse = ThreadObject;

export type CreateThreadError = unknown;

export type GetThreadData = {
  path: {
    /**
     * The ID of the thread to retrieve.
     */
    thread_id: string;
  };
};

export type GetThreadResponse = ThreadObject;

export type GetThreadError = unknown;

export type ModifyThreadData = {
  body: ModifyThreadRequest;
  path: {
    /**
     * The ID of the thread to modify. Only the `metadata` can be modified.
     */
    thread_id: string;
  };
};

export type ModifyThreadResponse = ThreadObject;

export type ModifyThreadError = unknown;

export type DeleteThreadData = {
  path: {
    /**
     * The ID of the thread to delete.
     */
    thread_id: string;
  };
};

export type DeleteThreadResponse2 = DeleteThreadResponse;

export type DeleteThreadError = unknown;

export type ListMessagesData = {
  path: {
    /**
     * The ID of the [thread](/docs/api-reference/threads) the messages belong to.
     */
    thread_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * Filter messages by the run ID that generated them.
     *
     */
    run_id?: string;
  };
};

export type ListMessagesResponse2 = ListMessagesResponse;

export type ListMessagesError = unknown;

export type CreateMessageData = {
  body: CreateMessageRequest;
  path: {
    /**
     * The ID of the [thread](/docs/api-reference/threads) to create a message for.
     */
    thread_id: string;
  };
};

export type CreateMessageResponse = MessageObject;

export type CreateMessageError = unknown;

export type GetMessageData = {
  path: {
    /**
     * The ID of the message to retrieve.
     */
    message_id: string;
    /**
     * The ID of the [thread](/docs/api-reference/threads) to which this message belongs.
     */
    thread_id: string;
  };
};

export type GetMessageResponse = MessageObject;

export type GetMessageError = unknown;

export type ModifyMessageData = {
  body: ModifyMessageRequest;
  path: {
    /**
     * The ID of the message to modify.
     */
    message_id: string;
    /**
     * The ID of the thread to which this message belongs.
     */
    thread_id: string;
  };
};

export type ModifyMessageResponse = MessageObject;

export type ModifyMessageError = unknown;

export type DeleteMessageData = {
  path: {
    /**
     * The ID of the message to delete.
     */
    message_id: string;
    /**
     * The ID of the thread to which this message belongs.
     */
    thread_id: string;
  };
};

export type DeleteMessageResponse2 = DeleteMessageResponse;

export type DeleteMessageError = unknown;

export type CreateThreadAndRunData = {
  body: CreateThreadAndRunRequest;
};

export type CreateThreadAndRunResponse = RunObject;

export type CreateThreadAndRunError = unknown;

export type ListRunsData = {
  path: {
    /**
     * The ID of the thread the run belongs to.
     */
    thread_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListRunsResponse2 = ListRunsResponse;

export type ListRunsError = unknown;

export type CreateRunData = {
  body: CreateRunRequest;
  path: {
    /**
     * The ID of the thread to run.
     */
    thread_id: string;
  };
};

export type CreateRunResponse = RunObject;

export type CreateRunError = unknown;

export type GetRunData = {
  path: {
    /**
     * The ID of the run to retrieve.
     */
    run_id: string;
    /**
     * The ID of the [thread](/docs/api-reference/threads) that was run.
     */
    thread_id: string;
  };
};

export type GetRunResponse = RunObject;

export type GetRunError = unknown;

export type ModifyRunData = {
  body: ModifyRunRequest;
  path: {
    /**
     * The ID of the run to modify.
     */
    run_id: string;
    /**
     * The ID of the [thread](/docs/api-reference/threads) that was run.
     */
    thread_id: string;
  };
};

export type ModifyRunResponse = RunObject;

export type ModifyRunError = unknown;

export type SubmitToolOuputsToRunData = {
  body: SubmitToolOutputsRunRequest;
  path: {
    /**
     * The ID of the run that requires the tool output submission.
     */
    run_id: string;
    /**
     * The ID of the [thread](/docs/api-reference/threads) to which this run belongs.
     */
    thread_id: string;
  };
};

export type SubmitToolOuputsToRunResponse = RunObject;

export type SubmitToolOuputsToRunError = unknown;

export type CancelRunData = {
  path: {
    /**
     * The ID of the run to cancel.
     */
    run_id: string;
    /**
     * The ID of the thread to which this run belongs.
     */
    thread_id: string;
  };
};

export type CancelRunResponse = RunObject;

export type CancelRunError = unknown;

export type ListRunStepsData = {
  path: {
    /**
     * The ID of the run the run steps belong to.
     */
    run_id: string;
    /**
     * The ID of the thread the run and run steps belong to.
     */
    thread_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListRunStepsResponse2 = ListRunStepsResponse;

export type ListRunStepsError = unknown;

export type GetRunStepData = {
  path: {
    /**
     * The ID of the run to which the run step belongs.
     */
    run_id: string;
    /**
     * The ID of the run step to retrieve.
     */
    step_id: string;
    /**
     * The ID of the thread to which the run and run step belongs.
     */
    thread_id: string;
  };
};

export type GetRunStepResponse = RunStepObject;

export type GetRunStepError = unknown;

export type ListVectorStoresData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListVectorStoresResponse2 = ListVectorStoresResponse;

export type ListVectorStoresError = unknown;

export type CreateVectorStoreData = {
  body: CreateVectorStoreRequest;
};

export type CreateVectorStoreResponse = VectorStoreObject;

export type CreateVectorStoreError = unknown;

export type GetVectorStoreData = {
  path: {
    /**
     * The ID of the vector store to retrieve.
     */
    vector_store_id: string;
  };
};

export type GetVectorStoreResponse = VectorStoreObject;

export type GetVectorStoreError = unknown;

export type ModifyVectorStoreData = {
  body: UpdateVectorStoreRequest;
  path: {
    /**
     * The ID of the vector store to modify.
     */
    vector_store_id: string;
  };
};

export type ModifyVectorStoreResponse = VectorStoreObject;

export type ModifyVectorStoreError = unknown;

export type DeleteVectorStoreData = {
  path: {
    /**
     * The ID of the vector store to delete.
     */
    vector_store_id: string;
  };
};

export type DeleteVectorStoreResponse2 = DeleteVectorStoreResponse;

export type DeleteVectorStoreError = unknown;

export type ListVectorStoreFilesData = {
  path: {
    /**
     * The ID of the vector store that the files belong to.
     */
    vector_store_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * Filter by file status. One of `in_progress`, `completed`, `failed`, `cancelled`.
     */
    filter?: 'in_progress' | 'completed' | 'failed' | 'cancelled';
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListVectorStoreFilesResponse2 = ListVectorStoreFilesResponse;

export type ListVectorStoreFilesError = unknown;

export type CreateVectorStoreFileData = {
  body: CreateVectorStoreFileRequest;
  path: {
    /**
     * The ID of the vector store for which to create a File.
     *
     */
    vector_store_id: string;
  };
};

export type CreateVectorStoreFileResponse = VectorStoreFileObject;

export type CreateVectorStoreFileError = unknown;

export type GetVectorStoreFileData = {
  path: {
    /**
     * The ID of the file being retrieved.
     */
    file_id: string;
    /**
     * The ID of the vector store that the file belongs to.
     */
    vector_store_id: string;
  };
};

export type GetVectorStoreFileResponse = VectorStoreFileObject;

export type GetVectorStoreFileError = unknown;

export type DeleteVectorStoreFileData = {
  path: {
    /**
     * The ID of the file to delete.
     */
    file_id: string;
    /**
     * The ID of the vector store that the file belongs to.
     */
    vector_store_id: string;
  };
};

export type DeleteVectorStoreFileResponse2 = DeleteVectorStoreFileResponse;

export type DeleteVectorStoreFileError = unknown;

export type CreateVectorStoreFileBatchData = {
  body: CreateVectorStoreFileBatchRequest;
  path: {
    /**
     * The ID of the vector store for which to create a File Batch.
     *
     */
    vector_store_id: string;
  };
};

export type CreateVectorStoreFileBatchResponse = VectorStoreFileBatchObject;

export type CreateVectorStoreFileBatchError = unknown;

export type GetVectorStoreFileBatchData = {
  path: {
    /**
     * The ID of the file batch being retrieved.
     */
    batch_id: string;
    /**
     * The ID of the vector store that the file batch belongs to.
     */
    vector_store_id: string;
  };
};

export type GetVectorStoreFileBatchResponse = VectorStoreFileBatchObject;

export type GetVectorStoreFileBatchError = unknown;

export type CancelVectorStoreFileBatchData = {
  path: {
    /**
     * The ID of the file batch to cancel.
     */
    batch_id: string;
    /**
     * The ID of the vector store that the file batch belongs to.
     */
    vector_store_id: string;
  };
};

export type CancelVectorStoreFileBatchResponse = VectorStoreFileBatchObject;

export type CancelVectorStoreFileBatchError = unknown;

export type ListFilesInVectorStoreBatchData = {
  path: {
    /**
     * The ID of the file batch that the files belong to.
     */
    batch_id: string;
    /**
     * The ID of the vector store that the files belong to.
     */
    vector_store_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * Filter by file status. One of `in_progress`, `completed`, `failed`, `cancelled`.
     */
    filter?: 'in_progress' | 'completed' | 'failed' | 'cancelled';
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
     *
     */
    order?: 'asc' | 'desc';
  };
};

export type ListFilesInVectorStoreBatchResponse = ListVectorStoreFilesResponse;

export type ListFilesInVectorStoreBatchError = unknown;

export type CreateBatchData = {
  body: {
    /**
     * The ID of an uploaded file that contains requests for the new batch.
     *
     * See [upload file](/docs/api-reference/files/create) for how to upload a file.
     *
     * Your input file must be formatted as a [JSONL file](/docs/api-reference/batch/request-input), and must be uploaded with the purpose `batch`. The file can contain up to 50,000 requests, and can be up to 100 MB in size.
     *
     */
    input_file_id: string;
    /**
     * The endpoint to be used for all requests in the batch. Currently `/v1/chat/completions`, `/v1/embeddings`, and `/v1/completions` are supported. Note that `/v1/embeddings` batches are also restricted to a maximum of 50,000 embedding inputs across all requests in the batch.
     */
    endpoint: '/v1/chat/completions' | '/v1/embeddings' | '/v1/completions';
    /**
     * The time frame within which the batch should be processed. Currently only `24h` is supported.
     */
    completion_window: '24h';
    /**
     * Optional custom metadata for the batch.
     */
    metadata?: {
      [key: string]: string;
    } | null;
  };
};

export type CreateBatchResponse = Batch;

export type CreateBatchError = unknown;

export type ListBatchesData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListBatchesResponse2 = ListBatchesResponse;

export type ListBatchesError = unknown;

export type RetrieveBatchData = {
  path: {
    /**
     * The ID of the batch to retrieve.
     */
    batch_id: string;
  };
};

export type RetrieveBatchResponse = Batch;

export type RetrieveBatchError = unknown;

export type CancelBatchData = {
  path: {
    /**
     * The ID of the batch to cancel.
     */
    batch_id: string;
  };
};

export type CancelBatchResponse = Batch;

export type CancelBatchError = unknown;

export type ListAuditLogsData = {
  query?: {
    /**
     * Return only events performed by users with these emails.
     */
    'actor_emails[]'?: Array<string>;
    /**
     * Return only events performed by these actors. Can be a user ID, a service account ID, or an api key tracking ID.
     */
    'actor_ids[]'?: Array<string>;
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
     *
     */
    before?: string;
    /**
     * Return only events whose `effective_at` (Unix seconds) is in this range.
     */
    effective_at?: {
      /**
       * Return only events whose `effective_at` (Unix seconds) is greater than this value.
       */
      gt?: number;
      /**
       * Return only events whose `effective_at` (Unix seconds) is greater than or equal to this value.
       */
      gte?: number;
      /**
       * Return only events whose `effective_at` (Unix seconds) is less than this value.
       */
      lt?: number;
      /**
       * Return only events whose `effective_at` (Unix seconds) is less than or equal to this value.
       */
      lte?: number;
    };
    /**
     * Return only events with a `type` in one of these values. For example, `project.created`. For all options, see the documentation for the [audit log object](/docs/api-reference/audit-logs/object).
     */
    'event_types[]'?: Array<AuditLogEventType>;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
    /**
     * Return only events for these projects.
     */
    'project_ids[]'?: Array<string>;
    /**
     * Return only events performed on these targets. For example, a project ID updated.
     */
    'resource_ids[]'?: Array<string>;
  };
};

export type ListAuditLogsResponse2 = ListAuditLogsResponse;

export type ListAuditLogsError = unknown;

export type ListInvitesData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListInvitesResponse = InviteListResponse;

export type ListInvitesError = unknown;

export type InviteUserData = {
  /**
   * The invite request payload.
   */
  body: InviteRequest;
};

export type InviteUserResponse = Invite;

export type InviteUserError = unknown;

export type RetrieveInviteData = {
  path: {
    /**
     * The ID of the invite to retrieve.
     */
    invite_id: string;
  };
};

export type RetrieveInviteResponse = Invite;

export type RetrieveInviteError = unknown;

export type DeleteInviteData = {
  path: {
    /**
     * The ID of the invite to delete.
     */
    invite_id: string;
  };
};

export type DeleteInviteResponse = InviteDeleteResponse;

export type DeleteInviteError = unknown;

export type ListUsersData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListUsersResponse = UserListResponse;

export type ListUsersError = unknown;

export type RetrieveUserData = {
  path: {
    /**
     * The ID of the user.
     */
    user_id: string;
  };
};

export type RetrieveUserResponse = User;

export type RetrieveUserError = unknown;

export type ModifyUserData = {
  /**
   * The new user role to modify. This must be one of `owner` or `member`.
   */
  body: UserRoleUpdateRequest;
};

export type ModifyUserResponse = User;

export type ModifyUserError = unknown;

export type DeleteUserData = {
  path: {
    /**
     * The ID of the user.
     */
    user_id: string;
  };
};

export type DeleteUserResponse = UserDeleteResponse;

export type DeleteUserError = unknown;

export type ListProjectsData = {
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * If `true` returns all projects including those that have been `archived`. Archived projects are not included by default.
     */
    include_archived?: boolean;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListProjectsResponse = ProjectListResponse;

export type ListProjectsError = unknown;

export type CreateProjectData = {
  /**
   * The project create request payload.
   */
  body: ProjectCreateRequest;
};

export type CreateProjectResponse = Project;

export type CreateProjectError = unknown;

export type RetrieveProjectData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type RetrieveProjectResponse = Project;

export type RetrieveProjectError = unknown;

export type ModifyProjectData = {
  /**
   * The project update request payload.
   */
  body: ProjectUpdateRequest;
};

export type ModifyProjectResponse = Project;

export type ModifyProjectError = ErrorResponse;

export type ArchiveProjectData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type ArchiveProjectResponse = Project;

export type ArchiveProjectError = unknown;

export type ListProjectUsersData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListProjectUsersResponse = ProjectUserListResponse;

export type ListProjectUsersError = ErrorResponse;

export type CreateProjectUserData = {
  /**
   * The project user create request payload.
   */
  body: ProjectUserCreateRequest;
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type CreateProjectUserResponse = ProjectUser;

export type CreateProjectUserError = ErrorResponse;

export type RetrieveProjectUserData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
    /**
     * The ID of the user.
     */
    user_id: string;
  };
};

export type RetrieveProjectUserResponse = ProjectUser;

export type RetrieveProjectUserError = unknown;

export type ModifyProjectUserData = {
  /**
   * The project user update request payload.
   */
  body: ProjectUserUpdateRequest;
};

export type ModifyProjectUserResponse = ProjectUser;

export type ModifyProjectUserError = ErrorResponse;

export type DeleteProjectUserData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
    /**
     * The ID of the user.
     */
    user_id: string;
  };
};

export type DeleteProjectUserResponse = ProjectUserDeleteResponse;

export type DeleteProjectUserError = ErrorResponse;

export type ListProjectServiceAccountsData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListProjectServiceAccountsResponse = ProjectServiceAccountListResponse;

export type ListProjectServiceAccountsError = ErrorResponse;

export type CreateProjectServiceAccountData = {
  /**
   * The project service account create request payload.
   */
  body: ProjectServiceAccountCreateRequest;
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type CreateProjectServiceAccountResponse = ProjectServiceAccountCreateResponse;

export type CreateProjectServiceAccountError = ErrorResponse;

export type RetrieveProjectServiceAccountData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
    /**
     * The ID of the service account.
     */
    service_account_id: string;
  };
};

export type RetrieveProjectServiceAccountResponse = ProjectServiceAccount;

export type RetrieveProjectServiceAccountError = unknown;

export type DeleteProjectServiceAccountData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
    /**
     * The ID of the service account.
     */
    service_account_id: string;
  };
};

export type DeleteProjectServiceAccountResponse = ProjectServiceAccountDeleteResponse;

export type DeleteProjectServiceAccountError = unknown;

export type ListProjectApiKeysData = {
  path: {
    /**
     * The ID of the project.
     */
    project_id: string;
  };
  query?: {
    /**
     * A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
     *
     */
    after?: string;
    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
     *
     */
    limit?: number;
  };
};

export type ListProjectApiKeysResponse = ProjectApiKeyListResponse;

export type ListProjectApiKeysError = unknown;

export type RetrieveProjectApiKeyData = {
  path: {
    /**
     * The ID of the API key.
     */
    key_id: string;
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type RetrieveProjectApiKeyResponse = ProjectApiKey;

export type RetrieveProjectApiKeyError = unknown;

export type DeleteProjectApiKeyData = {
  path: {
    /**
     * The ID of the API key.
     */
    key_id: string;
    /**
     * The ID of the project.
     */
    project_id: string;
  };
};

export type DeleteProjectApiKeyResponse = ProjectApiKeyDeleteResponse;

export type DeleteProjectApiKeyError = ErrorResponse;
