// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  CreateChatCompletionData,
  CreateChatCompletionError,
  CreateChatCompletionResponse2,
  CreateCompletionData,
  CreateCompletionError,
  CreateCompletionResponse2,
  CreateImageData,
  CreateImageError,
  CreateImageResponse,
  CreateImageEditData,
  CreateImageEditError,
  CreateImageEditResponse,
  CreateImageVariationData,
  CreateImageVariationError,
  CreateImageVariationResponse,
  CreateEmbeddingData,
  CreateEmbeddingError,
  CreateEmbeddingResponse2,
  CreateSpeechData,
  CreateSpeechError,
  CreateSpeechResponse,
  CreateTranscriptionData,
  CreateTranscriptionError,
  CreateTranscriptionResponse,
  CreateTranslationData,
  CreateTranslationError,
  CreateTranslationResponse,
  ListFilesData,
  ListFilesError,
  ListFilesResponse2,
  CreateFileData,
  CreateFileError,
  CreateFileResponse,
  DeleteFileData,
  DeleteFileError,
  DeleteFileResponse2,
  RetrieveFileData,
  RetrieveFileError,
  RetrieveFileResponse,
  DownloadFileData,
  DownloadFileError,
  DownloadFileResponse,
  CreateUploadData,
  CreateUploadError,
  CreateUploadResponse,
  AddUploadPartData,
  AddUploadPartError,
  AddUploadPartResponse,
  CompleteUploadData,
  CompleteUploadError,
  CompleteUploadResponse,
  CancelUploadData,
  CancelUploadError,
  CancelUploadResponse,
  CreateFineTuningJobData,
  CreateFineTuningJobError,
  CreateFineTuningJobResponse,
  ListPaginatedFineTuningJobsData,
  ListPaginatedFineTuningJobsError,
  ListPaginatedFineTuningJobsResponse2,
  RetrieveFineTuningJobData,
  RetrieveFineTuningJobError,
  RetrieveFineTuningJobResponse,
  ListFineTuningEventsData,
  ListFineTuningEventsError,
  ListFineTuningEventsResponse,
  CancelFineTuningJobData,
  CancelFineTuningJobError,
  CancelFineTuningJobResponse,
  ListFineTuningJobCheckpointsData,
  ListFineTuningJobCheckpointsError,
  ListFineTuningJobCheckpointsResponse2,
  ListModelsError,
  ListModelsResponse2,
  RetrieveModelData,
  RetrieveModelError,
  RetrieveModelResponse,
  DeleteModelData,
  DeleteModelError,
  DeleteModelResponse2,
  CreateModerationData,
  CreateModerationError,
  CreateModerationResponse2,
  ListAssistantsData,
  ListAssistantsError,
  ListAssistantsResponse2,
  CreateAssistantData,
  CreateAssistantError,
  CreateAssistantResponse,
  GetAssistantData,
  GetAssistantError,
  GetAssistantResponse,
  ModifyAssistantData,
  ModifyAssistantError,
  ModifyAssistantResponse,
  DeleteAssistantData,
  DeleteAssistantError,
  DeleteAssistantResponse2,
  CreateThreadData,
  CreateThreadError,
  CreateThreadResponse,
  GetThreadData,
  GetThreadError,
  GetThreadResponse,
  ModifyThreadData,
  ModifyThreadError,
  ModifyThreadResponse,
  DeleteThreadData,
  DeleteThreadError,
  DeleteThreadResponse2,
  ListMessagesData,
  ListMessagesError,
  ListMessagesResponse2,
  CreateMessageData,
  CreateMessageError,
  CreateMessageResponse,
  GetMessageData,
  GetMessageError,
  GetMessageResponse,
  ModifyMessageData,
  ModifyMessageError,
  ModifyMessageResponse,
  DeleteMessageData,
  DeleteMessageError,
  DeleteMessageResponse2,
  CreateThreadAndRunData,
  CreateThreadAndRunError,
  CreateThreadAndRunResponse,
  ListRunsData,
  ListRunsError,
  ListRunsResponse2,
  CreateRunData,
  CreateRunError,
  CreateRunResponse,
  GetRunData,
  GetRunError,
  GetRunResponse,
  ModifyRunData,
  ModifyRunError,
  ModifyRunResponse,
  SubmitToolOuputsToRunData,
  SubmitToolOuputsToRunError,
  SubmitToolOuputsToRunResponse,
  CancelRunData,
  CancelRunError,
  CancelRunResponse,
  ListRunStepsData,
  ListRunStepsError,
  ListRunStepsResponse2,
  GetRunStepData,
  GetRunStepError,
  GetRunStepResponse,
  ListVectorStoresData,
  ListVectorStoresError,
  ListVectorStoresResponse2,
  CreateVectorStoreData,
  CreateVectorStoreError,
  CreateVectorStoreResponse,
  GetVectorStoreData,
  GetVectorStoreError,
  GetVectorStoreResponse,
  ModifyVectorStoreData,
  ModifyVectorStoreError,
  ModifyVectorStoreResponse,
  DeleteVectorStoreData,
  DeleteVectorStoreError,
  DeleteVectorStoreResponse2,
  ListVectorStoreFilesData,
  ListVectorStoreFilesError,
  ListVectorStoreFilesResponse2,
  CreateVectorStoreFileData,
  CreateVectorStoreFileError,
  CreateVectorStoreFileResponse,
  GetVectorStoreFileData,
  GetVectorStoreFileError,
  GetVectorStoreFileResponse,
  DeleteVectorStoreFileData,
  DeleteVectorStoreFileError,
  DeleteVectorStoreFileResponse2,
  CreateVectorStoreFileBatchData,
  CreateVectorStoreFileBatchError,
  CreateVectorStoreFileBatchResponse,
  GetVectorStoreFileBatchData,
  GetVectorStoreFileBatchError,
  GetVectorStoreFileBatchResponse,
  CancelVectorStoreFileBatchData,
  CancelVectorStoreFileBatchError,
  CancelVectorStoreFileBatchResponse,
  ListFilesInVectorStoreBatchData,
  ListFilesInVectorStoreBatchError,
  ListFilesInVectorStoreBatchResponse,
  CreateBatchData,
  CreateBatchError,
  CreateBatchResponse,
  ListBatchesData,
  ListBatchesError,
  ListBatchesResponse2,
  RetrieveBatchData,
  RetrieveBatchError,
  RetrieveBatchResponse,
  CancelBatchData,
  CancelBatchError,
  CancelBatchResponse,
  ListAuditLogsData,
  ListAuditLogsError,
  ListAuditLogsResponse2,
  ListInvitesData,
  ListInvitesError,
  ListInvitesResponse,
  InviteUserData,
  InviteUserError,
  InviteUserResponse,
  RetrieveInviteData,
  RetrieveInviteError,
  RetrieveInviteResponse,
  DeleteInviteData,
  DeleteInviteError,
  DeleteInviteResponse,
  ListUsersData,
  ListUsersError,
  ListUsersResponse,
  RetrieveUserData,
  RetrieveUserError,
  RetrieveUserResponse,
  ModifyUserData,
  ModifyUserError,
  ModifyUserResponse,
  DeleteUserData,
  DeleteUserError,
  DeleteUserResponse,
  ListProjectsData,
  ListProjectsError,
  ListProjectsResponse,
  CreateProjectData,
  CreateProjectError,
  CreateProjectResponse,
  RetrieveProjectData,
  RetrieveProjectError,
  RetrieveProjectResponse,
  ModifyProjectData,
  ModifyProjectError,
  ModifyProjectResponse,
  ArchiveProjectData,
  ArchiveProjectError,
  ArchiveProjectResponse,
  ListProjectUsersData,
  ListProjectUsersError,
  ListProjectUsersResponse,
  CreateProjectUserData,
  CreateProjectUserError,
  CreateProjectUserResponse,
  RetrieveProjectUserData,
  RetrieveProjectUserError,
  RetrieveProjectUserResponse,
  ModifyProjectUserData,
  ModifyProjectUserError,
  ModifyProjectUserResponse,
  DeleteProjectUserData,
  DeleteProjectUserError,
  DeleteProjectUserResponse,
  ListProjectServiceAccountsData,
  ListProjectServiceAccountsError,
  ListProjectServiceAccountsResponse,
  CreateProjectServiceAccountData,
  CreateProjectServiceAccountError,
  CreateProjectServiceAccountResponse,
  RetrieveProjectServiceAccountData,
  RetrieveProjectServiceAccountError,
  RetrieveProjectServiceAccountResponse,
  DeleteProjectServiceAccountData,
  DeleteProjectServiceAccountError,
  DeleteProjectServiceAccountResponse,
  ListProjectApiKeysData,
  ListProjectApiKeysError,
  ListProjectApiKeysResponse,
  RetrieveProjectApiKeyData,
  RetrieveProjectApiKeyError,
  RetrieveProjectApiKeyResponse,
  DeleteProjectApiKeyData,
  DeleteProjectApiKeyError,
  DeleteProjectApiKeyResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Creates a model response for the given chat conversation.
 */
export const createChatCompletion = <ThrowOnError extends boolean = false>(
  options: Options<CreateChatCompletionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateChatCompletionResponse2, CreateChatCompletionError, ThrowOnError>({
    ...options,
    url: '/chat/completions',
  });
};

/**
 * Creates a completion for the provided prompt and parameters.
 */
export const createCompletion = <ThrowOnError extends boolean = false>(
  options: Options<CreateCompletionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateCompletionResponse2, CreateCompletionError, ThrowOnError>({
    ...options,
    url: '/completions',
  });
};

/**
 * Creates an image given a prompt.
 */
export const createImage = <ThrowOnError extends boolean = false>(options: Options<CreateImageData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateImageResponse, CreateImageError, ThrowOnError>({
    ...options,
    url: '/images/generations',
  });
};

/**
 * Creates an edited or extended image given an original image and a prompt.
 */
export const createImageEdit = <ThrowOnError extends boolean = false>(
  options: Options<CreateImageEditData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateImageEditResponse, CreateImageEditError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/images/edits',
  });
};

/**
 * Creates a variation of a given image.
 */
export const createImageVariation = <ThrowOnError extends boolean = false>(
  options: Options<CreateImageVariationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateImageVariationResponse, CreateImageVariationError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/images/variations',
  });
};

/**
 * Creates an embedding vector representing the input text.
 */
export const createEmbedding = <ThrowOnError extends boolean = false>(
  options: Options<CreateEmbeddingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateEmbeddingResponse2, CreateEmbeddingError, ThrowOnError>({
    ...options,
    url: '/embeddings',
  });
};

/**
 * Generates audio from the input text.
 */
export const createSpeech = <ThrowOnError extends boolean = false>(
  options: Options<CreateSpeechData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSpeechResponse, CreateSpeechError, ThrowOnError>({
    ...options,
    url: '/audio/speech',
  });
};

/**
 * Transcribes audio into the input language.
 */
export const createTranscription = <ThrowOnError extends boolean = false>(
  options: Options<CreateTranscriptionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTranscriptionResponse, CreateTranscriptionError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/audio/transcriptions',
  });
};

/**
 * Translates audio into English.
 */
export const createTranslation = <ThrowOnError extends boolean = false>(
  options: Options<CreateTranslationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTranslationResponse, CreateTranslationError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/audio/translations',
  });
};

/**
 * Returns a list of files that belong to the user's organization.
 */
export const listFiles = <ThrowOnError extends boolean = false>(options?: Options<ListFilesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListFilesResponse2, ListFilesError, ThrowOnError>({
    ...options,
    url: '/files',
  });
};

/**
 * Upload a file that can be used across various endpoints. Individual files can be up to 512 MB, and the size of all files uploaded by one organization can be up to 100 GB.
 *
 * The Assistants API supports files up to 2 million tokens and of specific file types. See the [Assistants Tools guide](/docs/assistants/tools) for details.
 *
 * The Fine-tuning API only supports `.jsonl` files. The input also has certain required formats for fine-tuning [chat](/docs/api-reference/fine-tuning/chat-input) or [completions](/docs/api-reference/fine-tuning/completions-input) models.
 *
 * The Batch API only supports `.jsonl` files up to 100 MB in size. The input also has a specific required [format](/docs/api-reference/batch/request-input).
 *
 * Please [contact us](https://help.openai.com/) if you need to increase these storage limits.
 *
 */
export const createFile = <ThrowOnError extends boolean = false>(options: Options<CreateFileData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateFileResponse, CreateFileError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/files',
  });
};

/**
 * Delete a file.
 */
export const deleteFile = <ThrowOnError extends boolean = false>(options: Options<DeleteFileData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteFileResponse2, DeleteFileError, ThrowOnError>({
    ...options,
    url: '/files/{file_id}',
  });
};

/**
 * Returns information about a specific file.
 */
export const retrieveFile = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveFileResponse, RetrieveFileError, ThrowOnError>({
    ...options,
    url: '/files/{file_id}',
  });
};

/**
 * Returns the contents of the specified file.
 */
export const downloadFile = <ThrowOnError extends boolean = false>(
  options: Options<DownloadFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DownloadFileResponse, DownloadFileError, ThrowOnError>({
    ...options,
    url: '/files/{file_id}/content',
  });
};

/**
 * Creates an intermediate [Upload](/docs/api-reference/uploads/object) object that you can add [Parts](/docs/api-reference/uploads/part-object) to. Currently, an Upload can accept at most 8 GB in total and expires after an hour after you create it.
 *
 * Once you complete the Upload, we will create a [File](/docs/api-reference/files/object) object that contains all the parts you uploaded. This File is usable in the rest of our platform as a regular File object.
 *
 * For certain `purpose`s, the correct `mime_type` must be specified. Please refer to documentation for the supported MIME types for your use case:
 * - [Assistants](/docs/assistants/tools/file-search/supported-files)
 *
 * For guidance on the proper filename extensions for each purpose, please follow the documentation on [creating a File](/docs/api-reference/files/create).
 *
 */
export const createUpload = <ThrowOnError extends boolean = false>(
  options: Options<CreateUploadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateUploadResponse, CreateUploadError, ThrowOnError>({
    ...options,
    url: '/uploads',
  });
};

/**
 * Adds a [Part](/docs/api-reference/uploads/part-object) to an [Upload](/docs/api-reference/uploads/object) object. A Part represents a chunk of bytes from the file you are trying to upload.
 *
 * Each Part can be at most 64 MB, and you can add Parts until you hit the Upload maximum of 8 GB.
 *
 * It is possible to add multiple Parts in parallel. You can decide the intended order of the Parts when you [complete the Upload](/docs/api-reference/uploads/complete).
 *
 */
export const addUploadPart = <ThrowOnError extends boolean = false>(
  options: Options<AddUploadPartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddUploadPartResponse, AddUploadPartError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/uploads/{upload_id}/parts',
  });
};

/**
 * Completes the [Upload](/docs/api-reference/uploads/object).
 *
 * Within the returned Upload object, there is a nested [File](/docs/api-reference/files/object) object that is ready to use in the rest of the platform.
 *
 * You can specify the order of the Parts by passing in an ordered list of the Part IDs.
 *
 * The number of bytes uploaded upon completion must match the number of bytes initially specified when creating the Upload object. No Parts may be added after an Upload is completed.
 *
 */
export const completeUpload = <ThrowOnError extends boolean = false>(
  options: Options<CompleteUploadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CompleteUploadResponse, CompleteUploadError, ThrowOnError>({
    ...options,
    url: '/uploads/{upload_id}/complete',
  });
};

/**
 * Cancels the Upload. No Parts may be added after an Upload is cancelled.
 *
 */
export const cancelUpload = <ThrowOnError extends boolean = false>(
  options: Options<CancelUploadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CancelUploadResponse, CancelUploadError, ThrowOnError>({
    ...options,
    url: '/uploads/{upload_id}/cancel',
  });
};

/**
 * Creates a fine-tuning job which begins the process of creating a new model from a given dataset.
 *
 * Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
 *
 * [Learn more about fine-tuning](/docs/guides/fine-tuning)
 *
 */
export const createFineTuningJob = <ThrowOnError extends boolean = false>(
  options: Options<CreateFineTuningJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateFineTuningJobResponse, CreateFineTuningJobError, ThrowOnError>({
    ...options,
    url: '/fine_tuning/jobs',
  });
};

/**
 * List your organization's fine-tuning jobs
 *
 */
export const listPaginatedFineTuningJobs = <ThrowOnError extends boolean = false>(
  options?: Options<ListPaginatedFineTuningJobsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListPaginatedFineTuningJobsResponse2,
    ListPaginatedFineTuningJobsError,
    ThrowOnError
  >({
    ...options,
    url: '/fine_tuning/jobs',
  });
};

/**
 * Get info about a fine-tuning job.
 *
 * [Learn more about fine-tuning](/docs/guides/fine-tuning)
 *
 */
export const retrieveFineTuningJob = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveFineTuningJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveFineTuningJobResponse, RetrieveFineTuningJobError, ThrowOnError>({
    ...options,
    url: '/fine_tuning/jobs/{fine_tuning_job_id}',
  });
};

/**
 * Get status updates for a fine-tuning job.
 *
 */
export const listFineTuningEvents = <ThrowOnError extends boolean = false>(
  options: Options<ListFineTuningEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListFineTuningEventsResponse, ListFineTuningEventsError, ThrowOnError>({
    ...options,
    url: '/fine_tuning/jobs/{fine_tuning_job_id}/events',
  });
};

/**
 * Immediately cancel a fine-tune job.
 *
 */
export const cancelFineTuningJob = <ThrowOnError extends boolean = false>(
  options: Options<CancelFineTuningJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CancelFineTuningJobResponse, CancelFineTuningJobError, ThrowOnError>({
    ...options,
    url: '/fine_tuning/jobs/{fine_tuning_job_id}/cancel',
  });
};

/**
 * List checkpoints for a fine-tuning job.
 *
 */
export const listFineTuningJobCheckpoints = <ThrowOnError extends boolean = false>(
  options: Options<ListFineTuningJobCheckpointsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListFineTuningJobCheckpointsResponse2,
    ListFineTuningJobCheckpointsError,
    ThrowOnError
  >({
    ...options,
    url: '/fine_tuning/jobs/{fine_tuning_job_id}/checkpoints',
  });
};

/**
 * Lists the currently available models, and provides basic information about each one such as the owner and availability.
 */
export const listModels = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListModelsResponse2, ListModelsError, ThrowOnError>({
    ...options,
    url: '/models',
  });
};

/**
 * Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
 */
export const retrieveModel = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveModelData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveModelResponse, RetrieveModelError, ThrowOnError>({
    ...options,
    url: '/models/{model}',
  });
};

/**
 * Delete a fine-tuned model. You must have the Owner role in your organization to delete a model.
 */
export const deleteModel = <ThrowOnError extends boolean = false>(options: Options<DeleteModelData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteModelResponse2, DeleteModelError, ThrowOnError>({
    ...options,
    url: '/models/{model}',
  });
};

/**
 * Classifies if text is potentially harmful.
 */
export const createModeration = <ThrowOnError extends boolean = false>(
  options: Options<CreateModerationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateModerationResponse2, CreateModerationError, ThrowOnError>({
    ...options,
    url: '/moderations',
  });
};

/**
 * Returns a list of assistants.
 */
export const listAssistants = <ThrowOnError extends boolean = false>(
  options?: Options<ListAssistantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAssistantsResponse2, ListAssistantsError, ThrowOnError>({
    ...options,
    url: '/assistants',
  });
};

/**
 * Create an assistant with a model and instructions.
 */
export const createAssistant = <ThrowOnError extends boolean = false>(
  options: Options<CreateAssistantData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAssistantResponse, CreateAssistantError, ThrowOnError>({
    ...options,
    url: '/assistants',
  });
};

/**
 * Retrieves an assistant.
 */
export const getAssistant = <ThrowOnError extends boolean = false>(
  options: Options<GetAssistantData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAssistantResponse, GetAssistantError, ThrowOnError>({
    ...options,
    url: '/assistants/{assistant_id}',
  });
};

/**
 * Modifies an assistant.
 */
export const modifyAssistant = <ThrowOnError extends boolean = false>(
  options: Options<ModifyAssistantData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyAssistantResponse, ModifyAssistantError, ThrowOnError>({
    ...options,
    url: '/assistants/{assistant_id}',
  });
};

/**
 * Delete an assistant.
 */
export const deleteAssistant = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAssistantData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAssistantResponse2, DeleteAssistantError, ThrowOnError>({
    ...options,
    url: '/assistants/{assistant_id}',
  });
};

/**
 * Create a thread.
 */
export const createThread = <ThrowOnError extends boolean = false>(
  options?: Options<CreateThreadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateThreadResponse, CreateThreadError, ThrowOnError>({
    ...options,
    url: '/threads',
  });
};

/**
 * Retrieves a thread.
 */
export const getThread = <ThrowOnError extends boolean = false>(options: Options<GetThreadData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetThreadResponse, GetThreadError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}',
  });
};

/**
 * Modifies a thread.
 */
export const modifyThread = <ThrowOnError extends boolean = false>(
  options: Options<ModifyThreadData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyThreadResponse, ModifyThreadError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}',
  });
};

/**
 * Delete a thread.
 */
export const deleteThread = <ThrowOnError extends boolean = false>(
  options: Options<DeleteThreadData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteThreadResponse2, DeleteThreadError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}',
  });
};

/**
 * Returns a list of messages for a given thread.
 */
export const listMessages = <ThrowOnError extends boolean = false>(
  options: Options<ListMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListMessagesResponse2, ListMessagesError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/messages',
  });
};

/**
 * Create a message.
 */
export const createMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageResponse, CreateMessageError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/messages',
  });
};

/**
 * Retrieve a message.
 */
export const getMessage = <ThrowOnError extends boolean = false>(options: Options<GetMessageData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetMessageResponse, GetMessageError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/messages/{message_id}',
  });
};

/**
 * Modifies a message.
 */
export const modifyMessage = <ThrowOnError extends boolean = false>(
  options: Options<ModifyMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyMessageResponse, ModifyMessageError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/messages/{message_id}',
  });
};

/**
 * Deletes a message.
 */
export const deleteMessage = <ThrowOnError extends boolean = false>(
  options: Options<DeleteMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteMessageResponse2, DeleteMessageError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/messages/{message_id}',
  });
};

/**
 * Create a thread and run it in one request.
 */
export const createThreadAndRun = <ThrowOnError extends boolean = false>(
  options: Options<CreateThreadAndRunData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateThreadAndRunResponse, CreateThreadAndRunError, ThrowOnError>({
    ...options,
    url: '/threads/runs',
  });
};

/**
 * Returns a list of runs belonging to a thread.
 */
export const listRuns = <ThrowOnError extends boolean = false>(options: Options<ListRunsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListRunsResponse2, ListRunsError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs',
  });
};

/**
 * Create a run.
 */
export const createRun = <ThrowOnError extends boolean = false>(options: Options<CreateRunData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateRunResponse, CreateRunError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs',
  });
};

/**
 * Retrieves a run.
 */
export const getRun = <ThrowOnError extends boolean = false>(options: Options<GetRunData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRunResponse, GetRunError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}',
  });
};

/**
 * Modifies a run.
 */
export const modifyRun = <ThrowOnError extends boolean = false>(options: Options<ModifyRunData, ThrowOnError>) => {
  return (options?.client ?? client).post<ModifyRunResponse, ModifyRunError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}',
  });
};

/**
 * When a run has the `status: "requires_action"` and `required_action.type` is `submit_tool_outputs`, this endpoint can be used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single request.
 *
 */
export const submitToolOuputsToRun = <ThrowOnError extends boolean = false>(
  options: Options<SubmitToolOuputsToRunData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SubmitToolOuputsToRunResponse, SubmitToolOuputsToRunError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}/submit_tool_outputs',
  });
};

/**
 * Cancels a run that is `in_progress`.
 */
export const cancelRun = <ThrowOnError extends boolean = false>(options: Options<CancelRunData, ThrowOnError>) => {
  return (options?.client ?? client).post<CancelRunResponse, CancelRunError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}/cancel',
  });
};

/**
 * Returns a list of run steps belonging to a run.
 */
export const listRunSteps = <ThrowOnError extends boolean = false>(
  options: Options<ListRunStepsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListRunStepsResponse2, ListRunStepsError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}/steps',
  });
};

/**
 * Retrieves a run step.
 */
export const getRunStep = <ThrowOnError extends boolean = false>(options: Options<GetRunStepData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRunStepResponse, GetRunStepError, ThrowOnError>({
    ...options,
    url: '/threads/{thread_id}/runs/{run_id}/steps/{step_id}',
  });
};

/**
 * Returns a list of vector stores.
 */
export const listVectorStores = <ThrowOnError extends boolean = false>(
  options?: Options<ListVectorStoresData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListVectorStoresResponse2, ListVectorStoresError, ThrowOnError>({
    ...options,
    url: '/vector_stores',
  });
};

/**
 * Create a vector store.
 */
export const createVectorStore = <ThrowOnError extends boolean = false>(
  options: Options<CreateVectorStoreData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateVectorStoreResponse, CreateVectorStoreError, ThrowOnError>({
    ...options,
    url: '/vector_stores',
  });
};

/**
 * Retrieves a vector store.
 */
export const getVectorStore = <ThrowOnError extends boolean = false>(
  options: Options<GetVectorStoreData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetVectorStoreResponse, GetVectorStoreError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}',
  });
};

/**
 * Modifies a vector store.
 */
export const modifyVectorStore = <ThrowOnError extends boolean = false>(
  options: Options<ModifyVectorStoreData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyVectorStoreResponse, ModifyVectorStoreError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}',
  });
};

/**
 * Delete a vector store.
 */
export const deleteVectorStore = <ThrowOnError extends boolean = false>(
  options: Options<DeleteVectorStoreData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteVectorStoreResponse2, DeleteVectorStoreError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}',
  });
};

/**
 * Returns a list of vector store files.
 */
export const listVectorStoreFiles = <ThrowOnError extends boolean = false>(
  options: Options<ListVectorStoreFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListVectorStoreFilesResponse2, ListVectorStoreFilesError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}/files',
  });
};

/**
 * Create a vector store file by attaching a [File](/docs/api-reference/files) to a [vector store](/docs/api-reference/vector-stores/object).
 */
export const createVectorStoreFile = <ThrowOnError extends boolean = false>(
  options: Options<CreateVectorStoreFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateVectorStoreFileResponse, CreateVectorStoreFileError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}/files',
  });
};

/**
 * Retrieves a vector store file.
 */
export const getVectorStoreFile = <ThrowOnError extends boolean = false>(
  options: Options<GetVectorStoreFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetVectorStoreFileResponse, GetVectorStoreFileError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}/files/{file_id}',
  });
};

/**
 * Delete a vector store file. This will remove the file from the vector store but the file itself will not be deleted. To delete the file, use the [delete file](/docs/api-reference/files/delete) endpoint.
 */
export const deleteVectorStoreFile = <ThrowOnError extends boolean = false>(
  options: Options<DeleteVectorStoreFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteVectorStoreFileResponse2, DeleteVectorStoreFileError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}/files/{file_id}',
  });
};

/**
 * Create a vector store file batch.
 */
export const createVectorStoreFileBatch = <ThrowOnError extends boolean = false>(
  options: Options<CreateVectorStoreFileBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateVectorStoreFileBatchResponse,
    CreateVectorStoreFileBatchError,
    ThrowOnError
  >({
    ...options,
    url: '/vector_stores/{vector_store_id}/file_batches',
  });
};

/**
 * Retrieves a vector store file batch.
 */
export const getVectorStoreFileBatch = <ThrowOnError extends boolean = false>(
  options: Options<GetVectorStoreFileBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetVectorStoreFileBatchResponse, GetVectorStoreFileBatchError, ThrowOnError>({
    ...options,
    url: '/vector_stores/{vector_store_id}/file_batches/{batch_id}',
  });
};

/**
 * Cancel a vector store file batch. This attempts to cancel the processing of files in this batch as soon as possible.
 */
export const cancelVectorStoreFileBatch = <ThrowOnError extends boolean = false>(
  options: Options<CancelVectorStoreFileBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CancelVectorStoreFileBatchResponse,
    CancelVectorStoreFileBatchError,
    ThrowOnError
  >({
    ...options,
    url: '/vector_stores/{vector_store_id}/file_batches/{batch_id}/cancel',
  });
};

/**
 * Returns a list of vector store files in a batch.
 */
export const listFilesInVectorStoreBatch = <ThrowOnError extends boolean = false>(
  options: Options<ListFilesInVectorStoreBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListFilesInVectorStoreBatchResponse,
    ListFilesInVectorStoreBatchError,
    ThrowOnError
  >({
    ...options,
    url: '/vector_stores/{vector_store_id}/file_batches/{batch_id}/files',
  });
};

/**
 * Creates and executes a batch from an uploaded file of requests
 */
export const createBatch = <ThrowOnError extends boolean = false>(options: Options<CreateBatchData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateBatchResponse, CreateBatchError, ThrowOnError>({
    ...options,
    url: '/batches',
  });
};

/**
 * List your organization's batches.
 */
export const listBatches = <ThrowOnError extends boolean = false>(options?: Options<ListBatchesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListBatchesResponse2, ListBatchesError, ThrowOnError>({
    ...options,
    url: '/batches',
  });
};

/**
 * Retrieves a batch.
 */
export const retrieveBatch = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveBatchResponse, RetrieveBatchError, ThrowOnError>({
    ...options,
    url: '/batches/{batch_id}',
  });
};

/**
 * Cancels an in-progress batch. The batch will be in status `cancelling` for up to 10 minutes, before changing to `cancelled`, where it will have partial results (if any) available in the output file.
 */
export const cancelBatch = <ThrowOnError extends boolean = false>(options: Options<CancelBatchData, ThrowOnError>) => {
  return (options?.client ?? client).post<CancelBatchResponse, CancelBatchError, ThrowOnError>({
    ...options,
    url: '/batches/{batch_id}/cancel',
  });
};

/**
 * List user actions and configuration changes within this organization.
 */
export const listAuditLogs = <ThrowOnError extends boolean = false>(
  options?: Options<ListAuditLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAuditLogsResponse2, ListAuditLogsError, ThrowOnError>({
    ...options,
    url: '/organization/audit_logs',
  });
};

/**
 * Returns a list of invites in the organization.
 */
export const listInvites = <ThrowOnError extends boolean = false>(options?: Options<ListInvitesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListInvitesResponse, ListInvitesError, ThrowOnError>({
    ...options,
    url: '/organization/invites',
  });
};

/**
 * Create an invite for a user to the organization. The invite must be accepted by the user before they have access to the organization.
 */
export const inviteUser = <ThrowOnError extends boolean = false>(options: Options<InviteUserData, ThrowOnError>) => {
  return (options?.client ?? client).post<InviteUserResponse, InviteUserError, ThrowOnError>({
    ...options,
    url: '/organization/invites',
  });
};

/**
 * Retrieves an invite.
 */
export const retrieveInvite = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveInviteData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveInviteResponse, RetrieveInviteError, ThrowOnError>({
    ...options,
    url: '/organization/invites/{invite_id}',
  });
};

/**
 * Delete an invite. If the invite has already been accepted, it cannot be deleted.
 */
export const deleteInvite = <ThrowOnError extends boolean = false>(
  options: Options<DeleteInviteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteInviteResponse, DeleteInviteError, ThrowOnError>({
    ...options,
    url: '/organization/invites/{invite_id}',
  });
};

/**
 * Lists all of the users in the organization.
 */
export const listUsers = <ThrowOnError extends boolean = false>(options?: Options<ListUsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListUsersResponse, ListUsersError, ThrowOnError>({
    ...options,
    url: '/organization/users',
  });
};

/**
 * Retrieves a user by their identifier.
 */
export const retrieveUser = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveUserResponse, RetrieveUserError, ThrowOnError>({
    ...options,
    url: '/organization/users/{user_id}',
  });
};

/**
 * Modifies a user's role in the organization.
 */
export const modifyUser = <ThrowOnError extends boolean = false>(options: Options<ModifyUserData, ThrowOnError>) => {
  return (options?.client ?? client).post<ModifyUserResponse, ModifyUserError, ThrowOnError>({
    ...options,
    url: '/organization/users/{user_id}',
  });
};

/**
 * Deletes a user from the organization.
 */
export const deleteUser = <ThrowOnError extends boolean = false>(options: Options<DeleteUserData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteUserResponse, DeleteUserError, ThrowOnError>({
    ...options,
    url: '/organization/users/{user_id}',
  });
};

/**
 * Returns a list of projects.
 */
export const listProjects = <ThrowOnError extends boolean = false>(
  options?: Options<ListProjectsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListProjectsResponse, ListProjectsError, ThrowOnError>({
    ...options,
    url: '/organization/projects',
  });
};

/**
 * Create a new project in the organization. Projects can be created and archived, but cannot be deleted.
 */
export const createProject = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectResponse, CreateProjectError, ThrowOnError>({
    ...options,
    url: '/organization/projects',
  });
};

/**
 * Retrieves a project.
 */
export const retrieveProject = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveProjectResponse, RetrieveProjectError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}',
  });
};

/**
 * Modifies a project in the organization.
 */
export const modifyProject = <ThrowOnError extends boolean = false>(
  options: Options<ModifyProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyProjectResponse, ModifyProjectError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}',
  });
};

/**
 * Archives a project in the organization. Archived projects cannot be used or updated.
 */
export const archiveProject = <ThrowOnError extends boolean = false>(
  options: Options<ArchiveProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ArchiveProjectResponse, ArchiveProjectError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/archive',
  });
};

/**
 * Returns a list of users in the project.
 */
export const listProjectUsers = <ThrowOnError extends boolean = false>(
  options: Options<ListProjectUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListProjectUsersResponse, ListProjectUsersError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/users',
  });
};

/**
 * Adds a user to the project. Users must already be members of the organization to be added to a project.
 */
export const createProjectUser = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateProjectUserResponse, CreateProjectUserError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/users',
  });
};

/**
 * Retrieves a user in the project.
 */
export const retrieveProjectUser = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveProjectUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveProjectUserResponse, RetrieveProjectUserError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/users/{user_id}',
  });
};

/**
 * Modifies a user's role in the project.
 */
export const modifyProjectUser = <ThrowOnError extends boolean = false>(
  options: Options<ModifyProjectUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ModifyProjectUserResponse, ModifyProjectUserError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/users/{user_id}',
  });
};

/**
 * Deletes a user from the project.
 */
export const deleteProjectUser = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectUserData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectUserResponse, DeleteProjectUserError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/users/{user_id}',
  });
};

/**
 * Returns a list of service accounts in the project.
 */
export const listProjectServiceAccounts = <ThrowOnError extends boolean = false>(
  options: Options<ListProjectServiceAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListProjectServiceAccountsResponse,
    ListProjectServiceAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/organization/projects/{project_id}/service_accounts',
  });
};

/**
 * Creates a new service account in the project. This also returns an unredacted API key for the service account.
 */
export const createProjectServiceAccount = <ThrowOnError extends boolean = false>(
  options: Options<CreateProjectServiceAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateProjectServiceAccountResponse,
    CreateProjectServiceAccountError,
    ThrowOnError
  >({
    ...options,
    url: '/organization/projects/{project_id}/service_accounts',
  });
};

/**
 * Retrieves a service account in the project.
 */
export const retrieveProjectServiceAccount = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveProjectServiceAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    RetrieveProjectServiceAccountResponse,
    RetrieveProjectServiceAccountError,
    ThrowOnError
  >({
    ...options,
    url: '/organization/projects/{project_id}/service_accounts/{service_account_id}',
  });
};

/**
 * Deletes a service account from the project.
 */
export const deleteProjectServiceAccount = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectServiceAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteProjectServiceAccountResponse,
    DeleteProjectServiceAccountError,
    ThrowOnError
  >({
    ...options,
    url: '/organization/projects/{project_id}/service_accounts/{service_account_id}',
  });
};

/**
 * Returns a list of API keys in the project.
 */
export const listProjectApiKeys = <ThrowOnError extends boolean = false>(
  options: Options<ListProjectApiKeysData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListProjectApiKeysResponse, ListProjectApiKeysError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/api_keys',
  });
};

/**
 * Retrieves an API key in the project.
 */
export const retrieveProjectApiKey = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveProjectApiKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveProjectApiKeyResponse, RetrieveProjectApiKeyError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/api_keys/{key_id}',
  });
};

/**
 * Deletes an API key from the project.
 */
export const deleteProjectApiKey = <ThrowOnError extends boolean = false>(
  options: Options<DeleteProjectApiKeyData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteProjectApiKeyResponse, DeleteProjectApiKeyError, ThrowOnError>({
    ...options,
    url: '/organization/projects/{project_id}/api_keys/{key_id}',
  });
};
