// This file is auto-generated by @hey-api/openapi-ts

export const ErrorSchema = {
  required: ['type', 'message', 'param', 'code'],
  type: 'object',
  properties: {
    code: {
      type: 'string',
      nullable: true,
    },
    message: {
      type: 'string',
    },
    param: {
      type: 'string',
      nullable: true,
    },
    type: {
      type: 'string',
    },
  },
} as const;

export const ErrorResponseSchema = {
  required: ['error'],
  type: 'object',
  properties: {
    error: {
      $ref: '#/components/schemas/Error',
    },
  },
} as const;

export const ListModelsResponseSchema = {
  required: ['object', 'data'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Model',
      },
    },
  },
} as const;

export const DeleteModelResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      type: 'string',
    },
  },
} as const;

export const CreateCompletionRequestSchema = {
  required: ['model', 'prompt'],
  type: 'object',
  properties: {
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['gpt-3.5-turbo-instruct', 'davinci-002', 'babbage-002'],
          type: 'string',
        },
      ],
      description: `ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
`,
      'x-oaiTypeLabel': 'string',
    },
    prompt: {
      oneOf: [
        {
          type: 'string',
          default: '',
          example: 'This is a test.',
        },
        {
          type: 'array',
          items: {
            type: 'string',
            default: '',
            example: 'This is a test.',
          },
        },
        {
          minItems: 1,
          type: 'array',
          items: {
            type: 'integer',
          },
          example: '[1212, 318, 257, 1332, 13]',
        },
        {
          minItems: 1,
          type: 'array',
          items: {
            minItems: 1,
            type: 'array',
            items: {
              type: 'integer',
            },
          },
          example: '[[1212, 318, 257, 1332, 13]]',
        },
      ],
      description: `The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.

Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.
`,
      default: '<|endoftext|>',
      nullable: true,
    },
    best_of: {
      maximum: 20,
      minimum: 0,
      type: 'integer',
      description: `Generates \`best_of\` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.

When used with \`n\`, \`best_of\` controls the number of candidate completions and \`n\` specifies how many to return – \`best_of\` must be greater than \`n\`.

**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for \`max_tokens\` and \`stop\`.
`,
      default: 1,
      nullable: true,
    },
    echo: {
      type: 'boolean',
      description: `Echo back the prompt in addition to the completion
`,
      default: false,
      nullable: true,
    },
    frequency_penalty: {
      maximum: 2,
      minimum: -2,
      type: 'number',
      description: `Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.

[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
`,
      default: 0,
      nullable: true,
    },
    logit_bias: {
      type: 'object',
      additionalProperties: {
        type: 'integer',
      },
      description: `Modify the likelihood of specified tokens appearing in the completion.

Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.

As an example, you can pass \`{"50256": -100}\` to prevent the <|endoftext|> token from being generated.
`,
      default: null,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    logprobs: {
      maximum: 5,
      minimum: 0,
      type: 'integer',
      description: `Include the log probabilities on the \`logprobs\` most likely output tokens, as well the chosen tokens. For example, if \`logprobs\` is 5, the API will return a list of the 5 most likely tokens. The API will always return the \`logprob\` of the sampled token, so there may be up to \`logprobs+1\` elements in the response.

The maximum value for \`logprobs\` is 5.
`,
      default: null,
      nullable: true,
    },
    max_tokens: {
      minimum: 0,
      type: 'integer',
      description: `The maximum number of [tokens](/tokenizer) that can be generated in the completion.

The token count of your prompt plus \`max_tokens\` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
`,
      default: 16,
      nullable: true,
      example: 16,
    },
    n: {
      maximum: 128,
      minimum: 1,
      type: 'integer',
      description: `How many completions to generate for each prompt.

**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for \`max_tokens\` and \`stop\`.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    presence_penalty: {
      maximum: 2,
      minimum: -2,
      type: 'number',
      description: `Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.

[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
`,
      default: 0,
      nullable: true,
    },
    seed: {
      maximum: 9223372036854776000,
      minimum: -9223372036854776000,
      type: 'integer',
      description: `If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same \`seed\` and parameters should return the same result.

Determinism is not guaranteed, and you should refer to the \`system_fingerprint\` response parameter to monitor changes in the backend.
`,
      nullable: true,
    },
    stop: {
      oneOf: [
        {
          type: 'string',
          default: '<|endoftext|>',
          nullable: true,
          example: `
`,
        },
        {
          maxItems: 4,
          minItems: 1,
          type: 'array',
          items: {
            type: 'string',
            example: '["\\n"]',
          },
        },
      ],
      description: `Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
`,
      default: null,
      nullable: true,
    },
    stream: {
      type: 'boolean',
      description: `Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a \`data: [DONE]\` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
`,
      default: false,
      nullable: true,
    },
    stream_options: {
      $ref: '#/components/schemas/ChatCompletionStreamOptions',
    },
    suffix: {
      type: 'string',
      description: `The suffix that comes after a completion of inserted text.

This parameter is only supported for \`gpt-3.5-turbo-instruct\`.
`,
      default: null,
      nullable: true,
      example: 'test.',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: `What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

We generally recommend altering this or \`top_p\` but not both.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: `An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

We generally recommend altering this or \`temperature\` but not both.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
  },
} as const;

export const CreateCompletionResponseSchema = {
  required: ['id', 'object', 'created', 'model', 'choices'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'A unique identifier for the completion.',
    },
    choices: {
      type: 'array',
      items: {
        required: ['finish_reason', 'index', 'logprobs', 'text'],
        type: 'object',
        properties: {
          finish_reason: {
            enum: ['stop', 'length', 'content_filter'],
            type: 'string',
            description: `The reason the model stopped generating tokens. This will be \`stop\` if the model hit a natural stop point or a provided stop sequence,
\`length\` if the maximum number of tokens specified in the request was reached,
or \`content_filter\` if content was omitted due to a flag from our content filters.
`,
          },
          index: {
            type: 'integer',
          },
          logprobs: {
            type: 'object',
            properties: {
              text_offset: {
                type: 'array',
                items: {
                  type: 'integer',
                },
              },
              token_logprobs: {
                type: 'array',
                items: {
                  type: 'number',
                },
              },
              tokens: {
                type: 'array',
                items: {
                  type: 'string',
                },
              },
              top_logprobs: {
                type: 'array',
                items: {
                  type: 'object',
                  additionalProperties: {
                    type: 'number',
                  },
                },
              },
            },
            nullable: true,
          },
          text: {
            type: 'string',
          },
        },
      },
      description: 'The list of completion choices the model generated for the input prompt.',
    },
    created: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the completion was created.',
    },
    model: {
      type: 'string',
      description: 'The model used for completion.',
    },
    system_fingerprint: {
      type: 'string',
      description: `This fingerprint represents the backend configuration that the model runs with.

Can be used in conjunction with the \`seed\` request parameter to understand when backend changes have been made that might impact determinism.
`,
    },
    object: {
      enum: ['text_completion'],
      type: 'string',
      description: 'The object type, which is always "text_completion"',
    },
    usage: {
      $ref: '#/components/schemas/CompletionUsage',
    },
  },
  description: `Represents a completion response from the API. Note: both the streamed and non-streamed response objects share the same shape (unlike the chat endpoint).
`,
  'x-oaiMeta': {
    name: 'The completion object',
    legacy: true,
    example: `{
  "id": "cmpl-uqkvlQyYK7bGYrRHQ0eXlWi7",
  "object": "text_completion",
  "created": 1589478378,
  "model": "gpt-4-turbo",
  "choices": [
    {
      "text": "\n\nThis is indeed a test",
      "index": 0,
      "logprobs": null,
      "finish_reason": "length"
    }
  ],
  "usage": {
    "prompt_tokens": 5,
    "completion_tokens": 7,
    "total_tokens": 12
  }
}
`,
  },
} as const;

export const ChatCompletionRequestMessageContentPartTextSchema = {
  title: 'Text content part',
  required: ['type', 'text'],
  type: 'object',
  properties: {
    type: {
      enum: ['text'],
      type: 'string',
      description: 'The type of the content part.',
    },
    text: {
      type: 'string',
      description: 'The text content.',
    },
  },
} as const;

export const ChatCompletionRequestMessageContentPartImageSchema = {
  title: 'Image content part',
  required: ['type', 'image_url'],
  type: 'object',
  properties: {
    type: {
      enum: ['image_url'],
      type: 'string',
      description: 'The type of the content part.',
    },
    image_url: {
      required: ['url'],
      type: 'object',
      properties: {
        url: {
          type: 'string',
          description: 'Either a URL of the image or the base64 encoded image data.',
          format: 'uri',
        },
        detail: {
          enum: ['auto', 'low', 'high'],
          type: 'string',
          description:
            'Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision/low-or-high-fidelity-image-understanding).',
          default: 'auto',
        },
      },
    },
  },
} as const;

export const ChatCompletionRequestMessageContentPartRefusalSchema = {
  title: 'Refusal content part',
  required: ['type', 'refusal'],
  type: 'object',
  properties: {
    type: {
      enum: ['refusal'],
      type: 'string',
      description: 'The type of the content part.',
    },
    refusal: {
      type: 'string',
      description: 'The refusal message generated by the model.',
    },
  },
} as const;

export const ChatCompletionRequestMessageSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ChatCompletionRequestSystemMessage',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestUserMessage',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestAssistantMessage',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestToolMessage',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestFunctionMessage',
    },
  ],
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionRequestSystemMessageContentPartSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartText',
    },
  ],
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionRequestUserMessageContentPartSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartText',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartImage',
    },
  ],
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionRequestAssistantMessageContentPartSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartText',
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartRefusal',
    },
  ],
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionRequestToolMessageContentPartSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ChatCompletionRequestMessageContentPartText',
    },
  ],
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionRequestSystemMessageSchema = {
  title: 'System message',
  required: ['content', 'role'],
  type: 'object',
  properties: {
    content: {
      oneOf: [
        {
          title: 'Text content',
          type: 'string',
          description: 'The contents of the system message.',
        },
        {
          title: 'Array of content parts',
          minItems: 1,
          type: 'array',
          items: {
            $ref: '#/components/schemas/ChatCompletionRequestSystemMessageContentPart',
          },
          description:
            'An array of content parts with a defined type. For system messages, only type `text` is supported.',
        },
      ],
      description: 'The contents of the system message.',
    },
    role: {
      enum: ['system'],
      type: 'string',
      description: 'The role of the messages author, in this case `system`.',
    },
    name: {
      type: 'string',
      description:
        'An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    },
  },
} as const;

export const ChatCompletionRequestUserMessageSchema = {
  title: 'User message',
  required: ['content', 'role'],
  type: 'object',
  properties: {
    content: {
      oneOf: [
        {
          title: 'Text content',
          type: 'string',
          description: 'The text contents of the message.',
        },
        {
          title: 'Array of content parts',
          minItems: 1,
          type: 'array',
          items: {
            $ref: '#/components/schemas/ChatCompletionRequestUserMessageContentPart',
          },
          description:
            'An array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts. Image input is only supported when using the `gpt-4o` model.',
        },
      ],
      description: `The contents of the user message.
`,
      'x-oaiExpandable': true,
    },
    role: {
      enum: ['user'],
      type: 'string',
      description: 'The role of the messages author, in this case `user`.',
    },
    name: {
      type: 'string',
      description:
        'An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    },
  },
} as const;

export const ChatCompletionRequestAssistantMessageSchema = {
  title: 'Assistant message',
  required: ['role'],
  type: 'object',
  properties: {
    content: {
      oneOf: [
        {
          title: 'Text content',
          type: 'string',
          description: 'The contents of the assistant message.',
        },
        {
          title: 'Array of content parts',
          minItems: 1,
          type: 'array',
          items: {
            $ref: '#/components/schemas/ChatCompletionRequestAssistantMessageContentPart',
          },
          description:
            'An array of content parts with a defined type. Can be one or more of type `text`, or exactly one of type `refusal`.',
        },
      ],
      description: `The contents of the assistant message. Required unless \`tool_calls\` or \`function_call\` is specified.
`,
      nullable: true,
    },
    refusal: {
      type: 'string',
      description: 'The refusal message by the assistant.',
      nullable: true,
    },
    role: {
      enum: ['assistant'],
      type: 'string',
      description: 'The role of the messages author, in this case `assistant`.',
    },
    name: {
      type: 'string',
      description:
        'An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    },
    tool_calls: {
      $ref: '#/components/schemas/ChatCompletionMessageToolCalls',
    },
    function_call: {
      required: ['arguments', 'name'],
      type: 'object',
      properties: {
        arguments: {
          type: 'string',
          description:
            'The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
        },
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
      },
      description:
        'Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
      nullable: true,
      deprecated: true,
    },
  },
} as const;

export const FineTuneChatCompletionRequestAssistantMessageSchema = {
  required: ['role'],
  allOf: [
    {
      title: 'Assistant message',
      type: 'object',
      properties: {
        weight: {
          enum: [0, 1],
          type: 'integer',
          description: 'Controls whether the assistant message is trained against (0 or 1)',
        },
      },
    },
    {
      $ref: '#/components/schemas/ChatCompletionRequestAssistantMessage',
    },
  ],
} as const;

export const ChatCompletionRequestToolMessageSchema = {
  title: 'Tool message',
  required: ['role', 'content', 'tool_call_id'],
  type: 'object',
  properties: {
    role: {
      enum: ['tool'],
      type: 'string',
      description: 'The role of the messages author, in this case `tool`.',
    },
    content: {
      oneOf: [
        {
          title: 'Text content',
          type: 'string',
          description: 'The contents of the tool message.',
        },
        {
          title: 'Array of content parts',
          minItems: 1,
          type: 'array',
          items: {
            $ref: '#/components/schemas/ChatCompletionRequestToolMessageContentPart',
          },
          description:
            'An array of content parts with a defined type. For tool messages, only type `text` is supported.',
        },
      ],
      description: 'The contents of the tool message.',
    },
    tool_call_id: {
      type: 'string',
      description: 'Tool call that this message is responding to.',
    },
  },
} as const;

export const ChatCompletionRequestFunctionMessageSchema = {
  title: 'Function message',
  required: ['role', 'content', 'name'],
  type: 'object',
  properties: {
    role: {
      enum: ['function'],
      type: 'string',
      description: 'The role of the messages author, in this case `function`.',
    },
    content: {
      type: 'string',
      description: 'The contents of the function message.',
      nullable: true,
    },
    name: {
      type: 'string',
      description: 'The name of the function to call.',
    },
  },
  deprecated: true,
} as const;

export const FunctionParametersSchema = {
  type: 'object',
  description: `The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format. 

Omitting \`parameters\` defines a function with an empty parameter list.`,
} as const;

export const ChatCompletionFunctionsSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    description: {
      type: 'string',
      description:
        'A description of what the function does, used by the model to choose when and how to call the function.',
    },
    name: {
      type: 'string',
      description:
        'The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
    },
    parameters: {
      $ref: '#/components/schemas/FunctionParameters',
    },
  },
  deprecated: true,
} as const;

export const ChatCompletionFunctionCallOptionSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The name of the function to call.',
    },
  },
  description: `Specifying a particular function via \`{"name": "my_function"}\` forces the model to call that function.
`,
} as const;

export const ChatCompletionToolSchema = {
  required: ['type', 'function'],
  type: 'object',
  properties: {
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of the tool. Currently, only `function` is supported.',
    },
    function: {
      $ref: '#/components/schemas/FunctionObject',
    },
  },
} as const;

export const FunctionObjectSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    description: {
      type: 'string',
      description:
        'A description of what the function does, used by the model to choose when and how to call the function.',
    },
    name: {
      type: 'string',
      description:
        'The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
    },
    parameters: {
      $ref: '#/components/schemas/FunctionParameters',
    },
    strict: {
      type: 'boolean',
      description:
        'Whether to enable strict schema adherence when generating the function call. If set to true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling guide](docs/guides/function-calling).',
      default: false,
      nullable: true,
    },
  },
} as const;

export const ResponseFormatTextSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['text'],
      type: 'string',
      description: 'The type of response format being defined: `text`',
    },
  },
} as const;

export const ResponseFormatJsonObjectSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['json_object'],
      type: 'string',
      description: 'The type of response format being defined: `json_object`',
    },
  },
} as const;

export const ResponseFormatJsonSchemaSchemaSchema = {
  type: 'object',
  description: 'The schema for the response format, described as a JSON Schema object.',
} as const;

export const ResponseFormatJsonSchemaSchema = {
  required: ['type', 'json_schema'],
  type: 'object',
  properties: {
    type: {
      enum: ['json_schema'],
      type: 'string',
      description: 'The type of response format being defined: `json_schema`',
    },
    json_schema: {
      required: ['type', 'name'],
      type: 'object',
      properties: {
        description: {
          type: 'string',
          description:
            'A description of what the response format is for, used by the model to determine how to respond in the format.',
        },
        name: {
          type: 'string',
          description:
            'The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
        },
        schema: {
          $ref: '#/components/schemas/ResponseFormatJsonSchemaSchema',
        },
        strict: {
          type: 'boolean',
          description:
            'Whether to enable strict schema adherence when generating the output. If set to true, the model will always follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is supported when `strict` is `true`. To learn more, read the [Structured Outputs guide](/docs/guides/structured-outputs).',
          default: false,
          nullable: true,
        },
      },
    },
  },
} as const;

export const ChatCompletionToolChoiceOptionSchema = {
  oneOf: [
    {
      enum: ['none', 'auto', 'required'],
      type: 'string',
      description: `\`none\` means the model will not call any tool and instead generates a message. \`auto\` means the model can pick between generating a message or calling one or more tools. \`required\` means the model must call one or more tools.
`,
    },
    {
      $ref: '#/components/schemas/ChatCompletionNamedToolChoice',
    },
  ],
  description: `Controls which (if any) tool is called by the model.
\`none\` means the model will not call any tool and instead generates a message.
\`auto\` means the model can pick between generating a message or calling one or more tools.
\`required\` means the model must call one or more tools.
Specifying a particular tool via \`{"type": "function", "function": {"name": "my_function"}}\` forces the model to call that tool.

\`none\` is the default when no tools are present. \`auto\` is the default if tools are present.
`,
  'x-oaiExpandable': true,
} as const;

export const ChatCompletionNamedToolChoiceSchema = {
  required: ['type', 'function'],
  type: 'object',
  properties: {
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of the tool. Currently, only `function` is supported.',
    },
    function: {
      required: ['name'],
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
      },
    },
  },
  description: 'Specifies a tool the model should use. Use to force the model to call a specific function.',
} as const;

export const ParallelToolCallsSchema = {
  type: 'boolean',
  description:
    'Whether to enable [parallel function calling](/docs/guides/function-calling/parallel-function-calling) during tool use.',
  nullable: true,
} as const;

export const ChatCompletionMessageToolCallsSchema = {
  type: 'array',
  items: {
    $ref: '#/components/schemas/ChatCompletionMessageToolCall',
  },
  description: 'The tool calls generated by the model, such as function calls.',
} as const;

export const ChatCompletionMessageToolCallSchema = {
  required: ['id', 'type', 'function'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The ID of the tool call.',
    },
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of the tool. Currently, only `function` is supported.',
    },
    function: {
      required: ['name', 'arguments'],
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
        arguments: {
          type: 'string',
          description:
            'The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
        },
      },
      description: 'The function that the model called.',
    },
  },
} as const;

export const ChatCompletionMessageToolCallChunkSchema = {
  required: ['index'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
    },
    id: {
      type: 'string',
      description: 'The ID of the tool call.',
    },
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of the tool. Currently, only `function` is supported.',
    },
    function: {
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
        arguments: {
          type: 'string',
          description:
            'The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
        },
      },
    },
  },
} as const;

export const ChatCompletionRoleSchema = {
  enum: ['system', 'user', 'assistant', 'tool', 'function'],
  type: 'string',
  description: 'The role of the author of a message',
} as const;

export const ChatCompletionStreamOptionsSchema = {
  type: 'object',
  properties: {
    include_usage: {
      type: 'boolean',
      description: `If set, an additional chunk will be streamed before the \`data: [DONE]\` message. The \`usage\` field on this chunk shows the token usage statistics for the entire request, and the \`choices\` field will always be an empty array. All other chunks will also include a \`usage\` field, but with a null value.
`,
    },
  },
  description: `Options for streaming response. Only set this when you set \`stream: true\`.
`,
  default: null,
  nullable: true,
} as const;

export const ChatCompletionResponseMessageSchema = {
  required: ['role', 'content', 'refusal'],
  type: 'object',
  properties: {
    content: {
      type: 'string',
      description: 'The contents of the message.',
      nullable: true,
    },
    refusal: {
      type: 'string',
      description: 'The refusal message generated by the model.',
      nullable: true,
    },
    tool_calls: {
      $ref: '#/components/schemas/ChatCompletionMessageToolCalls',
    },
    role: {
      enum: ['assistant'],
      type: 'string',
      description: 'The role of the author of this message.',
    },
    function_call: {
      required: ['name', 'arguments'],
      type: 'object',
      properties: {
        arguments: {
          type: 'string',
          description:
            'The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
        },
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
      },
      description:
        'Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
      deprecated: true,
    },
  },
  description: 'A chat completion message generated by the model.',
} as const;

export const ChatCompletionStreamResponseDeltaSchema = {
  type: 'object',
  properties: {
    content: {
      type: 'string',
      description: 'The contents of the chunk message.',
      nullable: true,
    },
    function_call: {
      type: 'object',
      properties: {
        arguments: {
          type: 'string',
          description:
            'The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
        },
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
      },
      description:
        'Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
      deprecated: true,
    },
    tool_calls: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionMessageToolCallChunk',
      },
    },
    role: {
      enum: ['system', 'user', 'assistant', 'tool'],
      type: 'string',
      description: 'The role of the author of this message.',
    },
    refusal: {
      type: 'string',
      description: 'The refusal message generated by the model.',
      nullable: true,
    },
  },
  description: 'A chat completion delta generated by streamed model responses.',
} as const;

export const CreateChatCompletionRequestSchema = {
  required: ['model', 'messages'],
  type: 'object',
  properties: {
    messages: {
      minItems: 1,
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionRequestMessage',
      },
      description:
        'A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: [
            'gpt-4o',
            'gpt-4o-2024-08-06',
            'gpt-4o-2024-05-13',
            'gpt-4o-mini',
            'gpt-4o-mini-2024-07-18',
            'gpt-4-turbo',
            'gpt-4-turbo-2024-04-09',
            'gpt-4-0125-preview',
            'gpt-4-turbo-preview',
            'gpt-4-1106-preview',
            'gpt-4-vision-preview',
            'gpt-4',
            'gpt-4-0314',
            'gpt-4-0613',
            'gpt-4-32k',
            'gpt-4-32k-0314',
            'gpt-4-32k-0613',
            'gpt-3.5-turbo',
            'gpt-3.5-turbo-16k',
            'gpt-3.5-turbo-0301',
            'gpt-3.5-turbo-0613',
            'gpt-3.5-turbo-1106',
            'gpt-3.5-turbo-0125',
            'gpt-3.5-turbo-16k-0613',
          ],
          type: 'string',
        },
      ],
      description:
        'ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.',
      example: 'gpt-4o',
      'x-oaiTypeLabel': 'string',
    },
    frequency_penalty: {
      maximum: 2,
      minimum: -2,
      type: 'number',
      description: `Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.

[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
`,
      default: 0,
      nullable: true,
    },
    logit_bias: {
      type: 'object',
      additionalProperties: {
        type: 'integer',
      },
      description: `Modify the likelihood of specified tokens appearing in the completion.

Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
`,
      default: null,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    logprobs: {
      type: 'boolean',
      description:
        'Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the `content` of `message`.',
      default: false,
      nullable: true,
    },
    top_logprobs: {
      maximum: 20,
      minimum: 0,
      type: 'integer',
      description:
        'An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter is used.',
      nullable: true,
    },
    max_tokens: {
      type: 'integer',
      description: `The maximum number of [tokens](/tokenizer) that can be generated in the chat completion.

The total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
`,
      nullable: true,
    },
    n: {
      maximum: 128,
      minimum: 1,
      type: 'integer',
      description:
        'How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.',
      default: 1,
      nullable: true,
      example: 1,
    },
    presence_penalty: {
      maximum: 2,
      minimum: -2,
      type: 'number',
      description: `Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.

[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
`,
      default: 0,
      nullable: true,
    },
    response_format: {
      oneOf: [
        {
          $ref: '#/components/schemas/ResponseFormatText',
        },
        {
          $ref: '#/components/schemas/ResponseFormatJsonObject',
        },
        {
          $ref: '#/components/schemas/ResponseFormatJsonSchema',
        },
      ],
      description: `An object specifying the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4o mini](/docs/models/gpt-4o-mini), [GPT-4 Turbo](/docs/models/gpt-4-and-gpt-4-turbo) and all GPT-3.5 Turbo models newer than \`gpt-3.5-turbo-1106\`.

Setting to \`{ "type": "json_schema", "json_schema": {...} }\` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).

Setting to \`{ "type": "json_object" }\` enables JSON mode, which guarantees the message the model generates is valid JSON.

**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if \`finish_reason="length"\`, which indicates the generation exceeded \`max_tokens\` or the conversation exceeded the max context length.
`,
      'x-oaiExpandable': true,
    },
    seed: {
      maximum: 9223372036854776000,
      minimum: -9223372036854776000,
      type: 'integer',
      description: `This feature is in Beta.
If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same \`seed\` and parameters should return the same result.
Determinism is not guaranteed, and you should refer to the \`system_fingerprint\` response parameter to monitor changes in the backend.
`,
      nullable: true,
      'x-oaiMeta': {
        beta: true,
      },
    },
    service_tier: {
      enum: ['auto', 'default'],
      type: 'string',
      description: `Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service:
  - If set to 'auto', the system will utilize scale tier credits until they are exhausted.
  - If set to 'default', the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.
  - When not set, the default behavior is 'auto'.

  When this parameter is set, the response body will include the \`service_tier\` utilized.
`,
      default: null,
      nullable: true,
    },
    stop: {
      oneOf: [
        {
          type: 'string',
          nullable: true,
        },
        {
          maxItems: 4,
          minItems: 1,
          type: 'array',
          items: {
            type: 'string',
          },
        },
      ],
      description: `Up to 4 sequences where the API will stop generating further tokens.
`,
      default: null,
    },
    stream: {
      type: 'boolean',
      description: `If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a \`data: [DONE]\` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
`,
      default: false,
      nullable: true,
    },
    stream_options: {
      $ref: '#/components/schemas/ChatCompletionStreamOptions',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: `What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

We generally recommend altering this or \`top_p\` but not both.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: `An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

We generally recommend altering this or \`temperature\` but not both.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    tools: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionTool',
      },
      description: `A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
`,
    },
    tool_choice: {
      $ref: '#/components/schemas/ChatCompletionToolChoiceOption',
    },
    parallel_tool_calls: {
      $ref: '#/components/schemas/ParallelToolCalls',
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
    function_call: {
      oneOf: [
        {
          enum: ['none', 'auto'],
          type: 'string',
          description: `\`none\` means the model will not call a function and instead generates a message. \`auto\` means the model can pick between generating a message or calling a function.
`,
        },
        {
          $ref: '#/components/schemas/ChatCompletionFunctionCallOption',
        },
      ],
      description: `Deprecated in favor of \`tool_choice\`.

Controls which (if any) function is called by the model.
\`none\` means the model will not call a function and instead generates a message.
\`auto\` means the model can pick between generating a message or calling a function.
Specifying a particular function via \`{"name": "my_function"}\` forces the model to call that function.

\`none\` is the default when no functions are present. \`auto\` is the default if functions are present.
`,
      deprecated: true,
      'x-oaiExpandable': true,
    },
    functions: {
      maxItems: 128,
      minItems: 1,
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionFunctions',
      },
      description: `Deprecated in favor of \`tools\`.

A list of functions the model may generate JSON inputs for.
`,
      deprecated: true,
    },
  },
} as const;

export const CreateChatCompletionResponseSchema = {
  required: ['choices', 'created', 'id', 'model', 'object'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'A unique identifier for the chat completion.',
    },
    choices: {
      type: 'array',
      items: {
        required: ['finish_reason', 'index', 'message'],
        type: 'object',
        properties: {
          finish_reason: {
            enum: ['stop', 'length', 'tool_calls', 'content_filter', 'function_call'],
            type: 'string',
            description: `The reason the model stopped generating tokens. This will be \`stop\` if the model hit a natural stop point or a provided stop sequence,
\`length\` if the maximum number of tokens specified in the request was reached,
\`content_filter\` if content was omitted due to a flag from our content filters,
\`tool_calls\` if the model called a tool, or \`function_call\` (deprecated) if the model called a function.
`,
          },
          index: {
            type: 'integer',
            description: 'The index of the choice in the list of choices.',
          },
          message: {
            $ref: '#/components/schemas/ChatCompletionResponseMessage',
          },
          logprobs: {
            required: ['content', 'refusal'],
            type: 'object',
            properties: {
              content: {
                type: 'array',
                items: {
                  $ref: '#/components/schemas/ChatCompletionTokenLogprob',
                },
                description: 'A list of message content tokens with log probability information.',
                nullable: true,
              },
              refusal: {
                type: 'array',
                items: {
                  $ref: '#/components/schemas/ChatCompletionTokenLogprob',
                },
                description: 'A list of message refusal tokens with log probability information.',
                nullable: true,
              },
            },
            description: 'Log probability information for the choice.',
            nullable: true,
          },
        },
      },
      description: 'A list of chat completion choices. Can be more than one if `n` is greater than 1.',
    },
    created: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the chat completion was created.',
    },
    model: {
      type: 'string',
      description: 'The model used for the chat completion.',
    },
    service_tier: {
      enum: ['scale', 'default'],
      type: 'string',
      description:
        'The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.',
      nullable: true,
      example: 'scale',
    },
    system_fingerprint: {
      type: 'string',
      description: `This fingerprint represents the backend configuration that the model runs with.

Can be used in conjunction with the \`seed\` request parameter to understand when backend changes have been made that might impact determinism.
`,
    },
    object: {
      enum: ['chat.completion'],
      type: 'string',
      description: 'The object type, which is always `chat.completion`.',
    },
    usage: {
      $ref: '#/components/schemas/CompletionUsage',
    },
  },
  description: 'Represents a chat completion response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The chat completion object',
    group: 'chat',
    example: `{
  "id": "chatcmpl-123",
  "object": "chat.completion",
  "created": 1677652288,
  "model": "gpt-4o-mini",
  "system_fingerprint": "fp_44709d6fcb",
  "choices": [{
    "index": 0,
    "message": {
      "role": "assistant",
      "content": "\n\nHello there, how may I assist you today?",
    },
    "logprobs": null,
    "finish_reason": "stop"
  }],
  "usage": {
    "prompt_tokens": 9,
    "completion_tokens": 12,
    "total_tokens": 21
  }
}
`,
  },
} as const;

export const CreateChatCompletionFunctionResponseSchema = {
  required: ['choices', 'created', 'id', 'model', 'object'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'A unique identifier for the chat completion.',
    },
    choices: {
      type: 'array',
      items: {
        required: ['finish_reason', 'index', 'message', 'logprobs'],
        type: 'object',
        properties: {
          finish_reason: {
            enum: ['stop', 'length', 'function_call', 'content_filter'],
            type: 'string',
            description: `The reason the model stopped generating tokens. This will be \`stop\` if the model hit a natural stop point or a provided stop sequence, \`length\` if the maximum number of tokens specified in the request was reached, \`content_filter\` if content was omitted due to a flag from our content filters, or \`function_call\` if the model called a function.
`,
          },
          index: {
            type: 'integer',
            description: 'The index of the choice in the list of choices.',
          },
          message: {
            $ref: '#/components/schemas/ChatCompletionResponseMessage',
          },
        },
      },
      description: 'A list of chat completion choices. Can be more than one if `n` is greater than 1.',
    },
    created: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the chat completion was created.',
    },
    model: {
      type: 'string',
      description: 'The model used for the chat completion.',
    },
    system_fingerprint: {
      type: 'string',
      description: `This fingerprint represents the backend configuration that the model runs with.

Can be used in conjunction with the \`seed\` request parameter to understand when backend changes have been made that might impact determinism.
`,
    },
    object: {
      enum: ['chat.completion'],
      type: 'string',
      description: 'The object type, which is always `chat.completion`.',
    },
    usage: {
      $ref: '#/components/schemas/CompletionUsage',
    },
  },
  description: 'Represents a chat completion response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The chat completion object',
    group: 'chat',
    example: `{
  "id": "chatcmpl-abc123",
  "object": "chat.completion",
  "created": 1699896916,
  "model": "gpt-4o-mini",
  "choices": [
    {
      "index": 0,
      "message": {
        "role": "assistant",
        "content": null,
        "tool_calls": [
          {
            "id": "call_abc123",
            "type": "function",
            "function": {
              "name": "get_current_weather",
              "arguments": "{\n\"location\": \"Boston, MA\"\n}"
            }
          }
        ]
      },
      "logprobs": null,
      "finish_reason": "tool_calls"
    }
  ],
  "usage": {
    "prompt_tokens": 82,
    "completion_tokens": 17,
    "total_tokens": 99
  }
}
`,
  },
} as const;

export const ChatCompletionTokenLogprobSchema = {
  required: ['token', 'logprob', 'bytes', 'top_logprobs'],
  type: 'object',
  properties: {
    token: {
      type: 'string',
      description: 'The token.',
    },
    logprob: {
      type: 'number',
      description:
        'The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.',
    },
    bytes: {
      type: 'array',
      items: {
        type: 'integer',
      },
      description:
        'A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.',
      nullable: true,
    },
    top_logprobs: {
      type: 'array',
      items: {
        required: ['token', 'logprob', 'bytes'],
        type: 'object',
        properties: {
          token: {
            type: 'string',
            description: 'The token.',
          },
          logprob: {
            type: 'number',
            description:
              'The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.',
          },
          bytes: {
            type: 'array',
            items: {
              type: 'integer',
            },
            description:
              'A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.',
            nullable: true,
          },
        },
      },
      description:
        'List of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested `top_logprobs` returned.',
    },
  },
} as const;

export const ListPaginatedFineTuningJobsResponseSchema = {
  required: ['object', 'data', 'has_more'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/FineTuningJob',
      },
    },
    has_more: {
      type: 'boolean',
    },
    object: {
      enum: ['list'],
      type: 'string',
    },
  },
} as const;

export const CreateChatCompletionStreamResponseSchema = {
  required: ['choices', 'created', 'id', 'model', 'object'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'A unique identifier for the chat completion. Each chunk has the same ID.',
    },
    choices: {
      type: 'array',
      items: {
        required: ['delta', 'finish_reason', 'index'],
        type: 'object',
        properties: {
          delta: {
            $ref: '#/components/schemas/ChatCompletionStreamResponseDelta',
          },
          logprobs: {
            required: ['content', 'refusal'],
            type: 'object',
            properties: {
              content: {
                type: 'array',
                items: {
                  $ref: '#/components/schemas/ChatCompletionTokenLogprob',
                },
                description: 'A list of message content tokens with log probability information.',
                nullable: true,
              },
              refusal: {
                type: 'array',
                items: {
                  $ref: '#/components/schemas/ChatCompletionTokenLogprob',
                },
                description: 'A list of message refusal tokens with log probability information.',
                nullable: true,
              },
            },
            description: 'Log probability information for the choice.',
            nullable: true,
          },
          finish_reason: {
            enum: ['stop', 'length', 'tool_calls', 'content_filter', 'function_call'],
            type: 'string',
            description: `The reason the model stopped generating tokens. This will be \`stop\` if the model hit a natural stop point or a provided stop sequence,
\`length\` if the maximum number of tokens specified in the request was reached,
\`content_filter\` if content was omitted due to a flag from our content filters,
\`tool_calls\` if the model called a tool, or \`function_call\` (deprecated) if the model called a function.
`,
            nullable: true,
          },
          index: {
            type: 'integer',
            description: 'The index of the choice in the list of choices.',
          },
        },
      },
      description: `A list of chat completion choices. Can contain more than one elements if \`n\` is greater than 1. Can also be empty for the
last chunk if you set \`stream_options: {"include_usage": true}\`.
`,
    },
    created: {
      type: 'integer',
      description:
        'The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.',
    },
    model: {
      type: 'string',
      description: 'The model to generate the completion.',
    },
    service_tier: {
      enum: ['scale', 'default'],
      type: 'string',
      description:
        'The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.',
      nullable: true,
      example: 'scale',
    },
    system_fingerprint: {
      type: 'string',
      description: `This fingerprint represents the backend configuration that the model runs with.
Can be used in conjunction with the \`seed\` request parameter to understand when backend changes have been made that might impact determinism.
`,
    },
    object: {
      enum: ['chat.completion.chunk'],
      type: 'string',
      description: 'The object type, which is always `chat.completion.chunk`.',
    },
    usage: {
      required: ['prompt_tokens', 'completion_tokens', 'total_tokens'],
      type: 'object',
      properties: {
        completion_tokens: {
          type: 'integer',
          description: 'Number of tokens in the generated completion.',
        },
        prompt_tokens: {
          type: 'integer',
          description: 'Number of tokens in the prompt.',
        },
        total_tokens: {
          type: 'integer',
          description: 'Total number of tokens used in the request (prompt + completion).',
        },
      },
      description: `An optional field that will only be present when you set \`stream_options: {"include_usage": true}\` in your request.
When present, it contains a null value except for the last chunk which contains the token usage statistics for the entire request.
`,
    },
  },
  description:
    'Represents a streamed chunk of a chat completion response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The chat completion chunk object',
    group: 'chat',
    example: `{"id":"chatcmpl-123","object":"chat.completion.chunk","created":1694268190,"model":"gpt-4o-mini", "system_fingerprint": "fp_44709d6fcb", "choices":[{"index":0,"delta":{"role":"assistant","content":""},"logprobs":null,"finish_reason":null}]}

{"id":"chatcmpl-123","object":"chat.completion.chunk","created":1694268190,"model":"gpt-4o-mini", "system_fingerprint": "fp_44709d6fcb", "choices":[{"index":0,"delta":{"content":"Hello"},"logprobs":null,"finish_reason":null}]}

....

{"id":"chatcmpl-123","object":"chat.completion.chunk","created":1694268190,"model":"gpt-4o-mini", "system_fingerprint": "fp_44709d6fcb", "choices":[{"index":0,"delta":{},"logprobs":null,"finish_reason":"stop"}]}
`,
  },
} as const;

export const CreateChatCompletionImageResponseSchema = {
  type: 'object',
  description:
    'Represents a streamed chunk of a chat completion response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The chat completion chunk object',
    group: 'chat',
    example: `{
  "id": "chatcmpl-123",
  "object": "chat.completion",
  "created": 1677652288,
  "model": "gpt-4o-mini",
  "system_fingerprint": "fp_44709d6fcb",
  "choices": [{
    "index": 0,
    "message": {
      "role": "assistant",
      "content": "\n\nThis image shows a wooden boardwalk extending through a lush green marshland.",
    },
    "logprobs": null,
    "finish_reason": "stop"
  }],
  "usage": {
    "prompt_tokens": 9,
    "completion_tokens": 12,
    "total_tokens": 21
  }
}
`,
  },
} as const;

export const CreateImageRequestSchema = {
  required: ['prompt'],
  type: 'object',
  properties: {
    prompt: {
      type: 'string',
      description:
        'A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.',
      example: 'A cute baby sea otter',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['dall-e-2', 'dall-e-3'],
          type: 'string',
        },
      ],
      description: 'The model to use for image generation.',
      default: 'dall-e-2',
      nullable: true,
      example: 'dall-e-3',
      'x-oaiTypeLabel': 'string',
    },
    n: {
      maximum: 10,
      minimum: 1,
      type: 'integer',
      description:
        'The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.',
      default: 1,
      nullable: true,
      example: 1,
    },
    quality: {
      enum: ['standard', 'hd'],
      type: 'string',
      description:
        'The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.',
      default: 'standard',
      example: 'standard',
    },
    response_format: {
      enum: ['url', 'b64_json'],
      type: 'string',
      description:
        'The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
      default: 'url',
      nullable: true,
      example: 'url',
    },
    size: {
      enum: ['256x256', '512x512', '1024x1024', '1792x1024', '1024x1792'],
      type: 'string',
      description:
        'The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.',
      default: '1024x1024',
      nullable: true,
      example: '1024x1024',
    },
    style: {
      enum: ['vivid', 'natural'],
      type: 'string',
      description:
        'The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.',
      default: 'vivid',
      nullable: true,
      example: 'vivid',
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
  },
} as const;

export const ImagesResponseSchema = {
  required: ['created', 'data'],
  properties: {
    created: {
      type: 'integer',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Image',
      },
    },
  },
} as const;

export const ImageSchema = {
  type: 'object',
  properties: {
    b64_json: {
      type: 'string',
      description: 'The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.',
    },
    url: {
      type: 'string',
      description: 'The URL of the generated image, if `response_format` is `url` (default).',
    },
    revised_prompt: {
      type: 'string',
      description: 'The prompt that was used to generate the image, if there was any revision to the prompt.',
    },
  },
  description: 'Represents the url or the content of an image generated by the OpenAI API.',
  'x-oaiMeta': {
    name: 'The image object',
    example: `{
  "url": "...",
  "revised_prompt": "..."
}
`,
  },
} as const;

export const CreateImageEditRequestSchema = {
  required: ['prompt', 'image'],
  type: 'object',
  properties: {
    image: {
      type: 'string',
      description:
        'The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.',
      format: 'binary',
    },
    prompt: {
      type: 'string',
      description: 'A text description of the desired image(s). The maximum length is 1000 characters.',
      example: 'A cute baby sea otter wearing a beret',
    },
    mask: {
      type: 'string',
      description:
        'An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where `image` should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.',
      format: 'binary',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['dall-e-2'],
          type: 'string',
        },
      ],
      description: 'The model to use for image generation. Only `dall-e-2` is supported at this time.',
      default: 'dall-e-2',
      nullable: true,
      example: 'dall-e-2',
      'x-oaiTypeLabel': 'string',
    },
    n: {
      maximum: 10,
      minimum: 1,
      type: 'integer',
      description: 'The number of images to generate. Must be between 1 and 10.',
      default: 1,
      nullable: true,
      example: 1,
    },
    size: {
      enum: ['256x256', '512x512', '1024x1024'],
      type: 'string',
      description: 'The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.',
      default: '1024x1024',
      nullable: true,
      example: '1024x1024',
    },
    response_format: {
      enum: ['url', 'b64_json'],
      type: 'string',
      description:
        'The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
      default: 'url',
      nullable: true,
      example: 'url',
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
  },
} as const;

export const CreateImageVariationRequestSchema = {
  required: ['image'],
  type: 'object',
  properties: {
    image: {
      type: 'string',
      description:
        'The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.',
      format: 'binary',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['dall-e-2'],
          type: 'string',
        },
      ],
      description: 'The model to use for image generation. Only `dall-e-2` is supported at this time.',
      default: 'dall-e-2',
      nullable: true,
      example: 'dall-e-2',
      'x-oaiTypeLabel': 'string',
    },
    n: {
      maximum: 10,
      minimum: 1,
      type: 'integer',
      description:
        'The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.',
      default: 1,
      nullable: true,
      example: 1,
    },
    response_format: {
      enum: ['url', 'b64_json'],
      type: 'string',
      description:
        'The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
      default: 'url',
      nullable: true,
      example: 'url',
    },
    size: {
      enum: ['256x256', '512x512', '1024x1024'],
      type: 'string',
      description: 'The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.',
      default: '1024x1024',
      nullable: true,
      example: '1024x1024',
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
  },
} as const;

export const CreateModerationRequestSchema = {
  required: ['input'],
  type: 'object',
  properties: {
    input: {
      oneOf: [
        {
          type: 'string',
          default: '',
          example: 'I want to kill them.',
        },
        {
          type: 'array',
          items: {
            type: 'string',
            default: '',
            example: 'I want to kill them.',
          },
        },
      ],
      description: 'The input text to classify',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['text-moderation-latest', 'text-moderation-stable'],
          type: 'string',
        },
      ],
      description: `Two content moderations models are available: \`text-moderation-stable\` and \`text-moderation-latest\`.

The default is \`text-moderation-latest\` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use \`text-moderation-stable\`, we will provide advanced notice before updating the model. Accuracy of \`text-moderation-stable\` may be slightly lower than for \`text-moderation-latest\`.
`,
      default: 'text-moderation-latest',
      example: 'text-moderation-stable',
      'x-oaiTypeLabel': 'string',
    },
  },
} as const;

export const CreateModerationResponseSchema = {
  required: ['id', 'model', 'results'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The unique identifier for the moderation request.',
    },
    model: {
      type: 'string',
      description: 'The model used to generate the moderation results.',
    },
    results: {
      type: 'array',
      items: {
        required: ['flagged', 'categories', 'category_scores'],
        type: 'object',
        properties: {
          flagged: {
            type: 'boolean',
            description: 'Whether any of the below categories are flagged.',
          },
          categories: {
            required: [
              'hate',
              'hate/threatening',
              'harassment',
              'harassment/threatening',
              'self-harm',
              'self-harm/intent',
              'self-harm/instructions',
              'sexual',
              'sexual/minors',
              'violence',
              'violence/graphic',
            ],
            type: 'object',
            properties: {
              hate: {
                type: 'boolean',
                description:
                  'Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harassment.',
              },
              'hate/threatening': {
                type: 'boolean',
                description:
                  'Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.',
              },
              harassment: {
                type: 'boolean',
                description: 'Content that expresses, incites, or promotes harassing language towards any target.',
              },
              'harassment/threatening': {
                type: 'boolean',
                description: 'Harassment content that also includes violence or serious harm towards any target.',
              },
              'self-harm': {
                type: 'boolean',
                description:
                  'Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.',
              },
              'self-harm/intent': {
                type: 'boolean',
                description:
                  'Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.',
              },
              'self-harm/instructions': {
                type: 'boolean',
                description:
                  'Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.',
              },
              sexual: {
                type: 'boolean',
                description:
                  'Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).',
              },
              'sexual/minors': {
                type: 'boolean',
                description: 'Sexual content that includes an individual who is under 18 years old.',
              },
              violence: {
                type: 'boolean',
                description: 'Content that depicts death, violence, or physical injury.',
              },
              'violence/graphic': {
                type: 'boolean',
                description: 'Content that depicts death, violence, or physical injury in graphic detail.',
              },
            },
            description: 'A list of the categories, and whether they are flagged or not.',
          },
          category_scores: {
            required: [
              'hate',
              'hate/threatening',
              'harassment',
              'harassment/threatening',
              'self-harm',
              'self-harm/intent',
              'self-harm/instructions',
              'sexual',
              'sexual/minors',
              'violence',
              'violence/graphic',
            ],
            type: 'object',
            properties: {
              hate: {
                type: 'number',
                description: "The score for the category 'hate'.",
              },
              'hate/threatening': {
                type: 'number',
                description: "The score for the category 'hate/threatening'.",
              },
              harassment: {
                type: 'number',
                description: "The score for the category 'harassment'.",
              },
              'harassment/threatening': {
                type: 'number',
                description: "The score for the category 'harassment/threatening'.",
              },
              'self-harm': {
                type: 'number',
                description: "The score for the category 'self-harm'.",
              },
              'self-harm/intent': {
                type: 'number',
                description: "The score for the category 'self-harm/intent'.",
              },
              'self-harm/instructions': {
                type: 'number',
                description: "The score for the category 'self-harm/instructions'.",
              },
              sexual: {
                type: 'number',
                description: "The score for the category 'sexual'.",
              },
              'sexual/minors': {
                type: 'number',
                description: "The score for the category 'sexual/minors'.",
              },
              violence: {
                type: 'number',
                description: "The score for the category 'violence'.",
              },
              'violence/graphic': {
                type: 'number',
                description: "The score for the category 'violence/graphic'.",
              },
            },
            description: 'A list of the categories along with their scores as predicted by model.',
          },
        },
      },
      description: 'A list of moderation objects.',
    },
  },
  description: 'Represents if a given text input is potentially harmful.',
  'x-oaiMeta': {
    name: 'The moderation object',
    example: `{
  "id": "modr-XXXXX",
  "model": "text-moderation-005",
  "results": [
    {
      "flagged": true,
      "categories": {
        "sexual": false,
        "hate": false,
        "harassment": false,
        "self-harm": false,
        "sexual/minors": false,
        "hate/threatening": false,
        "violence/graphic": false,
        "self-harm/intent": false,
        "self-harm/instructions": false,
        "harassment/threatening": true,
        "violence": true,
      },
      "category_scores": {
        "sexual": 1.2282071e-06,
        "hate": 0.010696256,
        "harassment": 0.29842457,
        "self-harm": 1.5236925e-08,
        "sexual/minors": 5.7246268e-08,
        "hate/threatening": 0.0060676364,
        "violence/graphic": 4.435014e-06,
        "self-harm/intent": 8.098441e-10,
        "self-harm/instructions": 2.8498655e-11,
        "harassment/threatening": 0.63055265,
        "violence": 0.99011886,
      }
    }
  ]
}
`,
  },
} as const;

export const ListFilesResponseSchema = {
  required: ['object', 'data'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OpenAIFile',
      },
    },
    object: {
      enum: ['list'],
      type: 'string',
    },
  },
} as const;

export const CreateFileRequestSchema = {
  required: ['file', 'purpose'],
  type: 'object',
  properties: {
    file: {
      type: 'string',
      description: `The File object (not file name) to be uploaded.
`,
      format: 'binary',
    },
    purpose: {
      enum: ['assistants', 'batch', 'fine-tune', 'vision'],
      type: 'string',
      description: `The intended purpose of the uploaded file.

Use "assistants" for [Assistants](/docs/api-reference/assistants) and [Message](/docs/api-reference/messages) files, "vision" for Assistants image file inputs, "batch" for [Batch API](/docs/guides/batch), and "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning).
`,
    },
  },
  additionalProperties: false,
} as const;

export const DeleteFileResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    object: {
      enum: ['file'],
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;

export const CreateUploadRequestSchema = {
  required: ['filename', 'purpose', 'bytes', 'mime_type'],
  type: 'object',
  properties: {
    filename: {
      type: 'string',
      description: `The name of the file to upload.
`,
    },
    purpose: {
      enum: ['assistants', 'batch', 'fine-tune', 'vision'],
      type: 'string',
      description: `The intended purpose of the uploaded file.

See the [documentation on File purposes](/docs/api-reference/files/create#files-create-purpose).
`,
    },
    bytes: {
      type: 'integer',
      description: `The number of bytes in the file you are uploading.
`,
    },
    mime_type: {
      type: 'string',
      description: `The MIME type of the file.

This must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants and vision.
`,
    },
  },
  additionalProperties: false,
} as const;

export const AddUploadPartRequestSchema = {
  required: ['data'],
  type: 'object',
  properties: {
    data: {
      type: 'string',
      description: `The chunk of bytes for this Part.
`,
      format: 'binary',
    },
  },
  additionalProperties: false,
} as const;

export const CompleteUploadRequestSchema = {
  required: ['part_ids'],
  type: 'object',
  properties: {
    part_ids: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `The ordered list of Part IDs.
`,
    },
    md5: {
      type: 'string',
      description: `The optional md5 checksum for the file contents to verify if the bytes uploaded matches what you expect.
`,
    },
  },
  additionalProperties: false,
} as const;

export const CancelUploadRequestSchema = {
  type: 'object',
  additionalProperties: false,
} as const;

export const CreateFineTuningJobRequestSchema = {
  required: ['model', 'training_file'],
  type: 'object',
  properties: {
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['babbage-002', 'davinci-002', 'gpt-3.5-turbo', 'gpt-4o-mini'],
          type: 'string',
        },
      ],
      description: `The name of the model to fine-tune. You can select one of the
[supported models](/docs/guides/fine-tuning/which-models-can-be-fine-tuned).
`,
      example: 'gpt-4o-mini',
      'x-oaiTypeLabel': 'string',
    },
    training_file: {
      type: 'string',
      description: `The ID of an uploaded file that contains training data.

See [upload file](/docs/api-reference/files/create) for how to upload a file.

Your dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose \`fine-tune\`.

The contents of the file should differ depending on if the model uses the [chat](/docs/api-reference/fine-tuning/chat-input) or [completions](/docs/api-reference/fine-tuning/completions-input) format.

See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
`,
      example: 'file-abc123',
    },
    hyperparameters: {
      type: 'object',
      properties: {
        batch_size: {
          oneOf: [
            {
              enum: ['auto'],
              type: 'string',
            },
            {
              maximum: 256,
              minimum: 1,
              type: 'integer',
            },
          ],
          description: `Number of examples in each batch. A larger batch size means that model parameters
are updated less frequently, but with lower variance.
`,
          default: 'auto',
        },
        learning_rate_multiplier: {
          oneOf: [
            {
              enum: ['auto'],
              type: 'string',
            },
            {
              minimum: 0,
              exclusiveMinimum: true,
              type: 'number',
            },
          ],
          description: `Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
overfitting.
`,
          default: 'auto',
        },
        n_epochs: {
          oneOf: [
            {
              enum: ['auto'],
              type: 'string',
            },
            {
              maximum: 50,
              minimum: 1,
              type: 'integer',
            },
          ],
          description: `The number of epochs to train the model for. An epoch refers to one full cycle
through the training dataset.
`,
          default: 'auto',
        },
      },
      description: 'The hyperparameters used for the fine-tuning job.',
    },
    suffix: {
      maxLength: 40,
      minLength: 1,
      type: 'string',
      description: `A string of up to 18 characters that will be added to your fine-tuned model name.

For example, a \`suffix\` of "custom-model-name" would produce a model name like \`ft:gpt-4o-mini:openai:custom-model-name:7p4lURel\`.
`,
      default: null,
      nullable: true,
    },
    validation_file: {
      type: 'string',
      description: `The ID of an uploaded file that contains validation data.

If you provide this file, the data is used to generate validation
metrics periodically during fine-tuning. These metrics can be viewed in
the fine-tuning results file.
The same data should not be present in both train and validation files.

Your dataset must be formatted as a JSONL file. You must upload your file with the purpose \`fine-tune\`.

See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
`,
      nullable: true,
      example: 'file-abc123',
    },
    integrations: {
      type: 'array',
      items: {
        required: ['type', 'wandb'],
        type: 'object',
        properties: {
          type: {
            oneOf: [
              {
                enum: ['wandb'],
                type: 'string',
              },
            ],
            description: `The type of integration to enable. Currently, only "wandb" (Weights and Biases) is supported.
`,
          },
          wandb: {
            required: ['project'],
            type: 'object',
            properties: {
              project: {
                type: 'string',
                description: `The name of the project that the new run will be created under.
`,
                example: 'my-wandb-project',
              },
              name: {
                type: 'string',
                description: `A display name to set for the run. If not set, we will use the Job ID as the name.
`,
                nullable: true,
              },
              entity: {
                type: 'string',
                description: `The entity to use for the run. This allows you to set the team or username of the WandB user that you would
like associated with the run. If not set, the default entity for the registered WandB API key is used.
`,
                nullable: true,
              },
              tags: {
                type: 'array',
                items: {
                  type: 'string',
                  example: 'custom-tag',
                },
                description: `A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some
default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
`,
              },
            },
            description: `The settings for your integration with Weights and Biases. This payload specifies the project that
metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
to your run, and set a default entity (team, username, etc) to be associated with your run.
`,
          },
        },
      },
      description: 'A list of integrations to enable for your fine-tuning job.',
      nullable: true,
    },
    seed: {
      maximum: 2147483647,
      minimum: 0,
      type: 'integer',
      description: `The seed controls the reproducibility of the job. Passing in the same seed and job parameters should produce the same results, but may differ in rare cases.
If a seed is not specified, one will be generated for you.
`,
      nullable: true,
      example: 42,
    },
  },
} as const;

export const ListFineTuningJobEventsResponseSchema = {
  required: ['object', 'data'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/FineTuningJobEvent',
      },
    },
    object: {
      enum: ['list'],
      type: 'string',
    },
  },
} as const;

export const ListFineTuningJobCheckpointsResponseSchema = {
  required: ['object', 'data', 'has_more'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/FineTuningJobCheckpoint',
      },
    },
    object: {
      enum: ['list'],
      type: 'string',
    },
    first_id: {
      type: 'string',
      nullable: true,
    },
    last_id: {
      type: 'string',
      nullable: true,
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const CreateEmbeddingRequestSchema = {
  required: ['model', 'input'],
  type: 'object',
  properties: {
    input: {
      oneOf: [
        {
          title: 'string',
          type: 'string',
          description: 'The string that will be turned into an embedding.',
          default: '',
          example: 'This is a test.',
        },
        {
          title: 'array',
          maxItems: 2048,
          minItems: 1,
          type: 'array',
          items: {
            type: 'string',
            default: '',
            example: "['This is a test.']",
          },
          description: 'The array of strings that will be turned into an embedding.',
        },
        {
          title: 'array',
          maxItems: 2048,
          minItems: 1,
          type: 'array',
          items: {
            type: 'integer',
          },
          description: 'The array of integers that will be turned into an embedding.',
          example: '[1212, 318, 257, 1332, 13]',
        },
        {
          title: 'array',
          maxItems: 2048,
          minItems: 1,
          type: 'array',
          items: {
            minItems: 1,
            type: 'array',
            items: {
              type: 'integer',
            },
          },
          description: 'The array of arrays containing integers that will be turned into an embedding.',
          example: '[[1212, 318, 257, 1332, 13]]',
        },
      ],
      description: `Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for \`text-embedding-ada-002\`), cannot be an empty string, and any array must be 2048 dimensions or less. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
`,
      example: 'The quick brown fox jumped over the lazy dog',
      'x-oaiExpandable': true,
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['text-embedding-ada-002', 'text-embedding-3-small', 'text-embedding-3-large'],
          type: 'string',
        },
      ],
      description: `ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
`,
      example: 'text-embedding-3-small',
      'x-oaiTypeLabel': 'string',
    },
    encoding_format: {
      enum: ['float', 'base64'],
      type: 'string',
      description:
        'The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).',
      default: 'float',
      example: 'float',
    },
    dimensions: {
      minimum: 1,
      type: 'integer',
      description: `The number of dimensions the resulting output embeddings should have. Only supported in \`text-embedding-3\` and later models.
`,
      nullable: true,
    },
    user: {
      type: 'string',
      description: `A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
`,
      example: 'user-1234',
    },
  },
  additionalProperties: false,
} as const;

export const CreateEmbeddingResponseSchema = {
  required: ['object', 'model', 'data', 'usage'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Embedding',
      },
      description: 'The list of embeddings generated by the model.',
    },
    model: {
      type: 'string',
      description: 'The name of the model used to generate the embedding.',
    },
    object: {
      enum: ['list'],
      type: 'string',
      description: 'The object type, which is always "list".',
    },
    usage: {
      required: ['prompt_tokens', 'total_tokens'],
      type: 'object',
      properties: {
        prompt_tokens: {
          type: 'integer',
          description: 'The number of tokens used by the prompt.',
        },
        total_tokens: {
          type: 'integer',
          description: 'The total number of tokens used by the request.',
        },
      },
      description: 'The usage information for the request.',
    },
  },
} as const;

export const CreateTranscriptionRequestSchema = {
  required: ['file', 'model'],
  type: 'object',
  properties: {
    file: {
      type: 'string',
      description: `The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.
`,
      format: 'binary',
      'x-oaiTypeLabel': 'file',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['whisper-1'],
          type: 'string',
        },
      ],
      description: `ID of the model to use. Only \`whisper-1\` (which is powered by our open source Whisper V2 model) is currently available.
`,
      example: 'whisper-1',
      'x-oaiTypeLabel': 'string',
    },
    language: {
      type: 'string',
      description: `The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
`,
    },
    prompt: {
      type: 'string',
      description: `An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
`,
    },
    response_format: {
      enum: ['json', 'text', 'srt', 'verbose_json', 'vtt'],
      type: 'string',
      description: `The format of the transcript output, in one of these options: \`json\`, \`text\`, \`srt\`, \`verbose_json\`, or \`vtt\`.
`,
      default: 'json',
    },
    temperature: {
      type: 'number',
      description: `The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
`,
      default: 0,
    },
    'timestamp_granularities[]': {
      type: 'array',
      items: {
        enum: ['word', 'segment'],
        type: 'string',
      },
      description: `The timestamp granularities to populate for this transcription. \`response_format\` must be set \`verbose_json\` to use timestamp granularities. Either or both of these options are supported: \`word\`, or \`segment\`. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.
`,
      default: ['segment'],
    },
  },
  additionalProperties: false,
} as const;

export const CreateTranscriptionResponseJsonSchema = {
  required: ['text'],
  type: 'object',
  properties: {
    text: {
      type: 'string',
      description: 'The transcribed text.',
    },
  },
  description: 'Represents a transcription response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The transcription object (JSON)',
    group: 'audio',
    example: `{
  "text": "Imagine the wildest idea that you've ever had, and you're curious about how it might scale to something that's a 100, a 1,000 times bigger. This is a place where you can get to do that."
}
`,
  },
} as const;

export const TranscriptionSegmentSchema = {
  required: [
    'id',
    'seek',
    'start',
    'end',
    'text',
    'tokens',
    'temperature',
    'avg_logprob',
    'compression_ratio',
    'no_speech_prob',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'integer',
      description: 'Unique identifier of the segment.',
    },
    seek: {
      type: 'integer',
      description: 'Seek offset of the segment.',
    },
    start: {
      type: 'number',
      description: 'Start time of the segment in seconds.',
      format: 'float',
    },
    end: {
      type: 'number',
      description: 'End time of the segment in seconds.',
      format: 'float',
    },
    text: {
      type: 'string',
      description: 'Text content of the segment.',
    },
    tokens: {
      type: 'array',
      items: {
        type: 'integer',
      },
      description: 'Array of token IDs for the text content.',
    },
    temperature: {
      type: 'number',
      description: 'Temperature parameter used for generating the segment.',
      format: 'float',
    },
    avg_logprob: {
      type: 'number',
      description: 'Average logprob of the segment. If the value is lower than -1, consider the logprobs failed.',
      format: 'float',
    },
    compression_ratio: {
      type: 'number',
      description:
        'Compression ratio of the segment. If the value is greater than 2.4, consider the compression failed.',
      format: 'float',
    },
    no_speech_prob: {
      type: 'number',
      description:
        'Probability of no speech in the segment. If the value is higher than 1.0 and the `avg_logprob` is below -1, consider this segment silent.',
      format: 'float',
    },
  },
} as const;

export const TranscriptionWordSchema = {
  required: ['word', 'start', 'end'],
  type: 'object',
  properties: {
    word: {
      type: 'string',
      description: 'The text content of the word.',
    },
    start: {
      type: 'number',
      description: 'Start time of the word in seconds.',
      format: 'float',
    },
    end: {
      type: 'number',
      description: 'End time of the word in seconds.',
      format: 'float',
    },
  },
} as const;

export const CreateTranscriptionResponseVerboseJsonSchema = {
  required: ['language', 'duration', 'text'],
  type: 'object',
  properties: {
    language: {
      type: 'string',
      description: 'The language of the input audio.',
    },
    duration: {
      type: 'string',
      description: 'The duration of the input audio.',
    },
    text: {
      type: 'string',
      description: 'The transcribed text.',
    },
    words: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TranscriptionWord',
      },
      description: 'Extracted words and their corresponding timestamps.',
    },
    segments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TranscriptionSegment',
      },
      description: 'Segments of the transcribed text and their corresponding details.',
    },
  },
  description: 'Represents a verbose json transcription response returned by model, based on the provided input.',
  'x-oaiMeta': {
    name: 'The transcription object (Verbose JSON)',
    group: 'audio',
    example: `{
  "task": "transcribe",
  "language": "english",
  "duration": 8.470000267028809,
  "text": "The beach was a popular spot on a hot summer day. People were swimming in the ocean, building sandcastles, and playing beach volleyball.",
  "segments": [
    {
      "id": 0,
      "seek": 0,
      "start": 0.0,
      "end": 3.319999933242798,
      "text": " The beach was a popular spot on a hot summer day.",
      "tokens": [
        50364, 440, 7534, 390, 257, 3743, 4008, 322, 257, 2368, 4266, 786, 13, 50530
      ],
      "temperature": 0.0,
      "avg_logprob": -0.2860786020755768,
      "compression_ratio": 1.2363636493682861,
      "no_speech_prob": 0.00985979475080967
    },
    ...
  ]
}
`,
  },
} as const;

export const CreateTranslationRequestSchema = {
  required: ['file', 'model'],
  type: 'object',
  properties: {
    file: {
      type: 'string',
      description: `The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.
`,
      format: 'binary',
      'x-oaiTypeLabel': 'file',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['whisper-1'],
          type: 'string',
        },
      ],
      description: `ID of the model to use. Only \`whisper-1\` (which is powered by our open source Whisper V2 model) is currently available.
`,
      example: 'whisper-1',
      'x-oaiTypeLabel': 'string',
    },
    prompt: {
      type: 'string',
      description: `An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
`,
    },
    response_format: {
      type: 'string',
      description: `The format of the transcript output, in one of these options: \`json\`, \`text\`, \`srt\`, \`verbose_json\`, or \`vtt\`.
`,
      default: 'json',
    },
    temperature: {
      type: 'number',
      description: `The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
`,
      default: 0,
    },
  },
  additionalProperties: false,
} as const;

export const CreateTranslationResponseJsonSchema = {
  required: ['text'],
  type: 'object',
  properties: {
    text: {
      type: 'string',
    },
  },
} as const;

export const CreateTranslationResponseVerboseJsonSchema = {
  required: ['language', 'duration', 'text'],
  type: 'object',
  properties: {
    language: {
      type: 'string',
      description: 'The language of the output translation (always `english`).',
    },
    duration: {
      type: 'string',
      description: 'The duration of the input audio.',
    },
    text: {
      type: 'string',
      description: 'The translated text.',
    },
    segments: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/TranscriptionSegment',
      },
      description: 'Segments of the translated text and their corresponding details.',
    },
  },
} as const;

export const CreateSpeechRequestSchema = {
  required: ['model', 'input', 'voice'],
  type: 'object',
  properties: {
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: ['tts-1', 'tts-1-hd'],
          type: 'string',
        },
      ],
      description: `One of the available [TTS models](/docs/models/tts): \`tts-1\` or \`tts-1-hd\`
`,
      'x-oaiTypeLabel': 'string',
    },
    input: {
      maxLength: 4096,
      type: 'string',
      description: 'The text to generate audio for. The maximum length is 4096 characters.',
    },
    voice: {
      enum: ['alloy', 'echo', 'fable', 'onyx', 'nova', 'shimmer'],
      type: 'string',
      description:
        'The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).',
    },
    response_format: {
      enum: ['mp3', 'opus', 'aac', 'flac', 'wav', 'pcm'],
      type: 'string',
      description: 'The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.',
      default: 'mp3',
    },
    speed: {
      maximum: 4,
      minimum: 0.25,
      type: 'number',
      description: 'The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.',
      default: 1,
    },
  },
  additionalProperties: false,
} as const;

export const ModelSchema = {
  title: 'Model',
  required: ['id', 'object', 'created', 'owned_by'],
  properties: {
    id: {
      type: 'string',
      description: 'The model identifier, which can be referenced in the API endpoints.',
    },
    created: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) when the model was created.',
    },
    object: {
      enum: ['model'],
      type: 'string',
      description: 'The object type, which is always "model".',
    },
    owned_by: {
      type: 'string',
      description: 'The organization that owns the model.',
    },
  },
  description: 'Describes an OpenAI model offering that can be used with the API.',
  'x-oaiMeta': {
    name: 'The model object',
    example: `{
  "id": "VAR_model_id",
  "object": "model",
  "created": 1686935002,
  "owned_by": "openai"
}
`,
  },
} as const;

export const OpenAIFileSchema = {
  title: 'OpenAIFile',
  required: ['id', 'object', 'bytes', 'created_at', 'filename', 'purpose', 'status'],
  properties: {
    id: {
      type: 'string',
      description: 'The file identifier, which can be referenced in the API endpoints.',
    },
    bytes: {
      type: 'integer',
      description: 'The size of the file, in bytes.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the file was created.',
    },
    filename: {
      type: 'string',
      description: 'The name of the file.',
    },
    object: {
      enum: ['file'],
      type: 'string',
      description: 'The object type, which is always `file`.',
    },
    purpose: {
      enum: ['assistants', 'assistants_output', 'batch', 'batch_output', 'fine-tune', 'fine-tune-results', 'vision'],
      type: 'string',
      description:
        'The intended purpose of the file. Supported values are `assistants`, `assistants_output`, `batch`, `batch_output`, `fine-tune`, `fine-tune-results` and `vision`.',
    },
    status: {
      enum: ['uploaded', 'processed', 'error'],
      type: 'string',
      description:
        'Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.',
      deprecated: true,
    },
    status_details: {
      type: 'string',
      description:
        'Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.',
      deprecated: true,
    },
  },
  description: 'The `File` object represents a document that has been uploaded to OpenAI.',
  'x-oaiMeta': {
    name: 'The file object',
    example: `{
  "id": "file-abc123",
  "object": "file",
  "bytes": 120000,
  "created_at": 1677610602,
  "filename": "salesOverview.pdf",
  "purpose": "assistants",
}
`,
  },
} as const;

export const UploadSchema = {
  title: 'Upload',
  required: ['bytes', 'created_at', 'expires_at', 'filename', 'id', 'purpose', 'status', 'step_number'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The Upload unique identifier, which can be referenced in API endpoints.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the Upload was created.',
    },
    filename: {
      type: 'string',
      description: 'The name of the file to be uploaded.',
    },
    bytes: {
      type: 'integer',
      description: 'The intended number of bytes to be uploaded.',
    },
    purpose: {
      type: 'string',
      description:
        'The intended purpose of the file. [Please refer here](/docs/api-reference/files/object#files/object-purpose) for acceptable values.',
    },
    status: {
      enum: ['pending', 'completed', 'cancelled', 'expired'],
      type: 'string',
      description: 'The status of the Upload.',
    },
    expires_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the Upload was created.',
    },
    object: {
      enum: ['upload'],
      type: 'string',
      description: 'The object type, which is always "upload".',
    },
    file: {
      $ref: '#/components/schemas/OpenAIFile',
    },
  },
  description: `The Upload object can accept byte chunks in the form of Parts.
`,
  'x-oaiMeta': {
    name: 'The upload object',
    example: `{
  "id": "upload_abc123",
  "object": "upload",
  "bytes": 2147483648,
  "created_at": 1719184911,
  "filename": "training_examples.jsonl",
  "purpose": "fine-tune",
  "status": "completed",
  "expires_at": 1719127296,
  "file": {
    "id": "file-xyz321",
    "object": "file",
    "bytes": 2147483648,
    "created_at": 1719186911,
    "filename": "training_examples.jsonl",
    "purpose": "fine-tune",
  }
}
`,
  },
} as const;

export const UploadPartSchema = {
  title: 'UploadPart',
  required: ['created_at', 'id', 'object', 'upload_id'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The upload Part unique identifier, which can be referenced in API endpoints.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the Part was created.',
    },
    upload_id: {
      type: 'string',
      description: 'The ID of the Upload object that this Part was added to.',
    },
    object: {
      enum: ['upload.part'],
      type: 'string',
      description: 'The object type, which is always `upload.part`.',
    },
  },
  description: `The upload Part represents a chunk of bytes we can add to an Upload object.
`,
  'x-oaiMeta': {
    name: 'The upload part object',
    example: `{
    "id": "part_def456",
    "object": "upload.part",
    "created_at": 1719186911,
    "upload_id": "upload_abc123"
}
`,
  },
} as const;

export const EmbeddingSchema = {
  required: ['index', 'object', 'embedding'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the embedding in the list of embeddings.',
    },
    embedding: {
      type: 'array',
      items: {
        type: 'number',
      },
      description: `The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).
`,
    },
    object: {
      enum: ['embedding'],
      type: 'string',
      description: 'The object type, which is always "embedding".',
    },
  },
  description: `Represents an embedding vector returned by embedding endpoint.
`,
  'x-oaiMeta': {
    name: 'The embedding object',
    example: `{
  "object": "embedding",
  "embedding": [
    0.0023064255,
    -0.009327292,
    .... (1536 floats total for ada-002)
    -0.0028842222,
  ],
  "index": 0
}
`,
  },
} as const;

export const FineTuningJobSchema = {
  title: 'FineTuningJob',
  required: [
    'created_at',
    'error',
    'finished_at',
    'fine_tuned_model',
    'hyperparameters',
    'id',
    'model',
    'object',
    'organization_id',
    'result_files',
    'status',
    'trained_tokens',
    'training_file',
    'validation_file',
    'seed',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The object identifier, which can be referenced in the API endpoints.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the fine-tuning job was created.',
    },
    error: {
      required: ['code', 'message', 'param'],
      type: 'object',
      properties: {
        code: {
          type: 'string',
          description: 'A machine-readable error code.',
        },
        message: {
          type: 'string',
          description: 'A human-readable error message.',
        },
        param: {
          type: 'string',
          description:
            'The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.',
          nullable: true,
        },
      },
      description:
        'For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.',
      nullable: true,
    },
    fine_tuned_model: {
      type: 'string',
      description:
        'The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.',
      nullable: true,
    },
    finished_at: {
      type: 'integer',
      description:
        'The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.',
      nullable: true,
    },
    hyperparameters: {
      required: ['n_epochs'],
      type: 'object',
      properties: {
        n_epochs: {
          oneOf: [
            {
              enum: ['auto'],
              type: 'string',
            },
            {
              maximum: 50,
              minimum: 1,
              type: 'integer',
            },
          ],
          description: `The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
"auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.`,
          default: 'auto',
        },
      },
      description:
        'The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.',
    },
    model: {
      type: 'string',
      description: 'The base model that is being fine-tuned.',
    },
    object: {
      enum: ['fine_tuning.job'],
      type: 'string',
      description: 'The object type, which is always "fine_tuning.job".',
    },
    organization_id: {
      type: 'string',
      description: 'The organization that owns the fine-tuning job.',
    },
    result_files: {
      type: 'array',
      items: {
        type: 'string',
        example: 'file-abc123',
      },
      description:
        'The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).',
    },
    status: {
      enum: ['validating_files', 'queued', 'running', 'succeeded', 'failed', 'cancelled'],
      type: 'string',
      description:
        'The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.',
    },
    trained_tokens: {
      type: 'integer',
      description:
        'The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.',
      nullable: true,
    },
    training_file: {
      type: 'string',
      description:
        'The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).',
    },
    validation_file: {
      type: 'string',
      description:
        'The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).',
      nullable: true,
    },
    integrations: {
      maxItems: 5,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/FineTuningIntegration',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: 'A list of integrations to enable for this fine-tuning job.',
      nullable: true,
    },
    seed: {
      type: 'integer',
      description: 'The seed used for the fine-tuning job.',
    },
    estimated_finish: {
      type: 'integer',
      description:
        'The Unix timestamp (in seconds) for when the fine-tuning job is estimated to finish. The value will be null if the fine-tuning job is not running.',
      nullable: true,
    },
  },
  description: `The \`fine_tuning.job\` object represents a fine-tuning job that has been created through the API.
`,
  'x-oaiMeta': {
    name: 'The fine-tuning job object',
    example: `{
  "object": "fine_tuning.job",
  "id": "ftjob-abc123",
  "model": "davinci-002",
  "created_at": 1692661014,
  "finished_at": 1692661190,
  "fine_tuned_model": "ft:davinci-002:my-org:custom_suffix:7q8mpxmy",
  "organization_id": "org-123",
  "result_files": [
      "file-abc123"
  ],
  "status": "succeeded",
  "validation_file": null,
  "training_file": "file-abc123",
  "hyperparameters": {
      "n_epochs": 4,
      "batch_size": 1,
      "learning_rate_multiplier": 1.0
  },
  "trained_tokens": 5768,
  "integrations": [],
  "seed": 0,
  "estimated_finish": 0
}
`,
  },
} as const;

export const FineTuningIntegrationSchema = {
  title: 'Fine-Tuning Job Integration',
  required: ['type', 'wandb'],
  type: 'object',
  properties: {
    type: {
      enum: ['wandb'],
      type: 'string',
      description: 'The type of the integration being enabled for the fine-tuning job',
    },
    wandb: {
      required: ['project'],
      type: 'object',
      properties: {
        project: {
          type: 'string',
          description: `The name of the project that the new run will be created under.
`,
          example: 'my-wandb-project',
        },
        name: {
          type: 'string',
          description: `A display name to set for the run. If not set, we will use the Job ID as the name.
`,
          nullable: true,
        },
        entity: {
          type: 'string',
          description: `The entity to use for the run. This allows you to set the team or username of the WandB user that you would
like associated with the run. If not set, the default entity for the registered WandB API key is used.
`,
          nullable: true,
        },
        tags: {
          type: 'array',
          items: {
            type: 'string',
            example: 'custom-tag',
          },
          description: `A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some
default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
`,
        },
      },
      description: `The settings for your integration with Weights and Biases. This payload specifies the project that
metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
to your run, and set a default entity (team, username, etc) to be associated with your run.
`,
    },
  },
} as const;

export const FineTuningJobEventSchema = {
  required: ['id', 'object', 'created_at', 'level', 'message'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    created_at: {
      type: 'integer',
    },
    level: {
      enum: ['info', 'warn', 'error'],
      type: 'string',
    },
    message: {
      type: 'string',
    },
    object: {
      enum: ['fine_tuning.job.event'],
      type: 'string',
    },
  },
  description: 'Fine-tuning job event object',
  'x-oaiMeta': {
    name: 'The fine-tuning job event object',
    example: `{
  "object": "fine_tuning.job.event",
  "id": "ftevent-abc123"
  "created_at": 1677610602,
  "level": "info",
  "message": "Created fine-tuning job"
}
`,
  },
} as const;

export const FineTuningJobCheckpointSchema = {
  title: 'FineTuningJobCheckpoint',
  required: [
    'created_at',
    'fine_tuning_job_id',
    'fine_tuned_model_checkpoint',
    'id',
    'metrics',
    'object',
    'step_number',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The checkpoint identifier, which can be referenced in the API endpoints.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the checkpoint was created.',
    },
    fine_tuned_model_checkpoint: {
      type: 'string',
      description: 'The name of the fine-tuned checkpoint model that is created.',
    },
    step_number: {
      type: 'integer',
      description: 'The step number that the checkpoint was created at.',
    },
    metrics: {
      type: 'object',
      properties: {
        step: {
          type: 'number',
        },
        train_loss: {
          type: 'number',
        },
        train_mean_token_accuracy: {
          type: 'number',
        },
        valid_loss: {
          type: 'number',
        },
        valid_mean_token_accuracy: {
          type: 'number',
        },
        full_valid_loss: {
          type: 'number',
        },
        full_valid_mean_token_accuracy: {
          type: 'number',
        },
      },
      description: 'Metrics at the step number during the fine-tuning job.',
    },
    fine_tuning_job_id: {
      type: 'string',
      description: 'The name of the fine-tuning job that this checkpoint was created from.',
    },
    object: {
      enum: ['fine_tuning.job.checkpoint'],
      type: 'string',
      description: 'The object type, which is always "fine_tuning.job.checkpoint".',
    },
  },
  description: `The \`fine_tuning.job.checkpoint\` object represents a model checkpoint for a fine-tuning job that is ready to use.
`,
  'x-oaiMeta': {
    name: 'The fine-tuning job checkpoint object',
    example: `{
  "object": "fine_tuning.job.checkpoint",
  "id": "ftckpt_qtZ5Gyk4BLq1SfLFWp3RtO3P",
  "created_at": 1712211699,
  "fine_tuned_model_checkpoint": "ft:gpt-4o-mini-2024-07-18:my-org:custom_suffix:9ABel2dg:ckpt-step-88",
  "fine_tuning_job_id": "ftjob-fpbNQ3H1GrMehXRf8cO97xTN",
  "metrics": {
    "step": 88,
    "train_loss": 0.478,
    "train_mean_token_accuracy": 0.924,
    "valid_loss": 10.112,
    "valid_mean_token_accuracy": 0.145,
    "full_valid_loss": 0.567,
    "full_valid_mean_token_accuracy": 0.944
  },
  "step_number": 88
}
`,
  },
} as const;

export const FinetuneChatRequestInputSchema = {
  type: 'object',
  properties: {
    messages: {
      minItems: 1,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/ChatCompletionRequestSystemMessage',
          },
          {
            $ref: '#/components/schemas/ChatCompletionRequestUserMessage',
          },
          {
            $ref: '#/components/schemas/FineTuneChatCompletionRequestAssistantMessage',
          },
          {
            $ref: '#/components/schemas/ChatCompletionRequestToolMessage',
          },
          {
            $ref: '#/components/schemas/ChatCompletionRequestFunctionMessage',
          },
        ],
        'x-oaiExpandable': true,
      },
    },
    tools: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionTool',
      },
      description: 'A list of tools the model may generate JSON inputs for.',
    },
    parallel_tool_calls: {
      $ref: '#/components/schemas/ParallelToolCalls',
    },
    functions: {
      maxItems: 128,
      minItems: 1,
      type: 'array',
      items: {
        $ref: '#/components/schemas/ChatCompletionFunctions',
      },
      description: 'A list of functions the model may generate JSON inputs for.',
      deprecated: true,
    },
  },
  description: 'The per-line training example of a fine-tuning input file for chat models',
  'x-oaiMeta': {
    name: 'Training format for chat models',
    example: `{
  "messages": [
    { "role": "user", "content": "What is the weather in San Francisco?" },
    {
      "role": "assistant",
      "tool_calls": [
        {
          "id": "call_id",
          "type": "function",
          "function": {
            "name": "get_current_weather",
            "arguments": "{\"location\": \"San Francisco, USA\", \"format\": \"celsius\"}"
          }
        }
      ]
    }
  ],
  "parallel_tool_calls": false,
  "tools": [
    {
      "type": "function",
      "function": {
        "name": "get_current_weather",
        "description": "Get the current weather",
        "parameters": {
          "type": "object",
          "properties": {
            "location": {
                "type": "string",
                "description": "The city and country, eg. San Francisco, USA"
            },
            "format": { "type": "string", "enum": ["celsius", "fahrenheit"] }
          },
          "required": ["location", "format"]
        }
      }
    }
  ]
}
`,
  },
} as const;

export const FinetuneCompletionRequestInputSchema = {
  type: 'object',
  properties: {
    prompt: {
      type: 'string',
      description: 'The input prompt for this training example.',
    },
    completion: {
      type: 'string',
      description: 'The desired completion for this training example.',
    },
  },
  description: 'The per-line training example of a fine-tuning input file for completions models',
  'x-oaiMeta': {
    name: 'Training format for completions models',
    example: `{
  "prompt": "What is the answer to 2+2",
  "completion": "4"
}
`,
  },
} as const;

export const CompletionUsageSchema = {
  required: ['prompt_tokens', 'completion_tokens', 'total_tokens'],
  type: 'object',
  properties: {
    completion_tokens: {
      type: 'integer',
      description: 'Number of tokens in the generated completion.',
    },
    prompt_tokens: {
      type: 'integer',
      description: 'Number of tokens in the prompt.',
    },
    total_tokens: {
      type: 'integer',
      description: 'Total number of tokens used in the request (prompt + completion).',
    },
  },
  description: 'Usage statistics for the completion request.',
} as const;

export const RunCompletionUsageSchema = {
  required: ['prompt_tokens', 'completion_tokens', 'total_tokens'],
  type: 'object',
  properties: {
    completion_tokens: {
      type: 'integer',
      description: 'Number of completion tokens used over the course of the run.',
    },
    prompt_tokens: {
      type: 'integer',
      description: 'Number of prompt tokens used over the course of the run.',
    },
    total_tokens: {
      type: 'integer',
      description: 'Total number of tokens used (prompt + completion).',
    },
  },
  description:
    'Usage statistics related to the run. This value will be `null` if the run is not in a terminal state (i.e. `in_progress`, `queued`, etc.).',
  nullable: true,
} as const;

export const RunStepCompletionUsageSchema = {
  required: ['prompt_tokens', 'completion_tokens', 'total_tokens'],
  type: 'object',
  properties: {
    completion_tokens: {
      type: 'integer',
      description: 'Number of completion tokens used over the course of the run step.',
    },
    prompt_tokens: {
      type: 'integer',
      description: 'Number of prompt tokens used over the course of the run step.',
    },
    total_tokens: {
      type: 'integer',
      description: 'Total number of tokens used (prompt + completion).',
    },
  },
  description:
    "Usage statistics related to the run step. This value will be `null` while the run step's status is `in_progress`.",
  nullable: true,
} as const;

export const AssistantsApiResponseFormatOptionSchema = {
  oneOf: [
    {
      enum: ['auto'],
      type: 'string',
      description: `\`auto\` is the default value
`,
    },
    {
      $ref: '#/components/schemas/ResponseFormatText',
    },
    {
      $ref: '#/components/schemas/ResponseFormatJsonObject',
    },
    {
      $ref: '#/components/schemas/ResponseFormatJsonSchema',
    },
  ],
  description: `Specifies the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4 Turbo](/docs/models/gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models since \`gpt-3.5-turbo-1106\`.

Setting to \`{ "type": "json_schema", "json_schema": {...} }\` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).

Setting to \`{ "type": "json_object" }\` enables JSON mode, which guarantees the message the model generates is valid JSON.

**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if \`finish_reason="length"\`, which indicates the generation exceeded \`max_tokens\` or the conversation exceeded the max context length.
`,
  'x-oaiExpandable': true,
} as const;

export const AssistantObjectSchema = {
  title: 'Assistant',
  required: ['id', 'object', 'created_at', 'name', 'description', 'model', 'instructions', 'tools', 'metadata'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['assistant'],
      type: 'string',
      description: 'The object type, which is always `assistant`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the assistant was created.',
    },
    name: {
      maxLength: 256,
      type: 'string',
      description: `The name of the assistant. The maximum length is 256 characters.
`,
      nullable: true,
    },
    description: {
      maxLength: 512,
      type: 'string',
      description: `The description of the assistant. The maximum length is 512 characters.
`,
      nullable: true,
    },
    model: {
      type: 'string',
      description: `ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
`,
    },
    instructions: {
      maxLength: 256000,
      type: 'string',
      description: `The system instructions that the assistant uses. The maximum length is 256,000 characters.
`,
      nullable: true,
    },
    tools: {
      maxItems: 128,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: `A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types \`code_interpreter\`, \`file_search\`, or \`function\`.
`,
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\`\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
`,
            },
          },
        },
      },
      description: `A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: `What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: `An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

We generally recommend altering this or temperature but not both.
`,
      default: 1,
      nullable: true,
      example: 1,
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  description: 'Represents an `assistant` that can call the model and use tools.',
  'x-oaiMeta': {
    name: 'The assistant object',
    beta: true,
    example: `{
  "id": "asst_abc123",
  "object": "assistant",
  "created_at": 1698984975,
  "name": "Math Tutor",
  "description": null,
  "model": "gpt-4o",
  "instructions": "You are a personal math tutor. When asked a question, write and run Python code to answer the question.",
  "tools": [
    {
      "type": "code_interpreter"
    }
  ],
  "metadata": {},
  "top_p": 1.0,
  "temperature": 1.0,
  "response_format": "auto"
}
`,
  },
} as const;

export const CreateAssistantRequestSchema = {
  required: ['model'],
  type: 'object',
  properties: {
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: [
            'gpt-4o',
            'gpt-4o-2024-08-06',
            'gpt-4o-2024-05-13',
            'gpt-4o-mini',
            'gpt-4o-mini-2024-07-18',
            'gpt-4-turbo',
            'gpt-4-turbo-2024-04-09',
            'gpt-4-0125-preview',
            'gpt-4-turbo-preview',
            'gpt-4-1106-preview',
            'gpt-4-vision-preview',
            'gpt-4',
            'gpt-4-0314',
            'gpt-4-0613',
            'gpt-4-32k',
            'gpt-4-32k-0314',
            'gpt-4-32k-0613',
            'gpt-3.5-turbo',
            'gpt-3.5-turbo-16k',
            'gpt-3.5-turbo-0613',
            'gpt-3.5-turbo-1106',
            'gpt-3.5-turbo-0125',
            'gpt-3.5-turbo-16k-0613',
          ],
          type: 'string',
        },
      ],
      description: `ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
`,
      example: 'gpt-4o',
      'x-oaiTypeLabel': 'string',
    },
    name: {
      maxLength: 256,
      type: 'string',
      description: `The name of the assistant. The maximum length is 256 characters.
`,
      nullable: true,
    },
    description: {
      maxLength: 512,
      type: 'string',
      description: `The description of the assistant. The maximum length is 512 characters.
`,
      nullable: true,
    },
    instructions: {
      maxLength: 256000,
      type: 'string',
      description: `The system instructions that the assistant uses. The maximum length is 256,000 characters.
`,
      nullable: true,
    },
    tools: {
      maxItems: 128,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: `A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types \`code_interpreter\`, \`file_search\`, or \`function\`.
`,
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          oneOf: [
            {
              required: ['vector_store_ids'],
            },
            {
              required: ['vector_stores'],
            },
          ],
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
`,
            },
            vector_stores: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  file_ids: {
                    maxItems: 10000,
                    type: 'array',
                    items: {
                      type: 'string',
                    },
                    description: `A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.
`,
                  },
                  chunking_strategy: {
                    type: 'object',
                    oneOf: [
                      {
                        title: 'Auto Chunking Strategy',
                        required: ['type'],
                        type: 'object',
                        properties: {
                          type: {
                            enum: ['auto'],
                            type: 'string',
                            description: 'Always `auto`.',
                          },
                        },
                        additionalProperties: false,
                        description:
                          'The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.',
                      },
                      {
                        title: 'Static Chunking Strategy',
                        required: ['type', 'static'],
                        type: 'object',
                        properties: {
                          type: {
                            enum: ['static'],
                            type: 'string',
                            description: 'Always `static`.',
                          },
                          static: {
                            required: ['max_chunk_size_tokens', 'chunk_overlap_tokens'],
                            type: 'object',
                            properties: {
                              max_chunk_size_tokens: {
                                maximum: 4096,
                                minimum: 100,
                                type: 'integer',
                                description:
                                  'The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.',
                              },
                              chunk_overlap_tokens: {
                                type: 'integer',
                                description: `The number of tokens that overlap between chunks. The default value is \`400\`.

Note that the overlap must not exceed half of \`max_chunk_size_tokens\`.
`,
                              },
                            },
                            additionalProperties: false,
                          },
                        },
                        additionalProperties: false,
                      },
                    ],
                    description:
                      'The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
                    'x-oaiExpandable': true,
                  },
                  metadata: {
                    type: 'object',
                    description: `Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
                    'x-oaiTypeLabel': 'map',
                  },
                },
              },
              description: `A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.
`,
            },
          },
        },
      },
      description: `A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  additionalProperties: false,
} as const;

export const ModifyAssistantRequestSchema = {
  type: 'object',
  properties: {
    model: {
      anyOf: [
        {
          type: 'string',
        },
      ],
      description: `ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
`,
    },
    name: {
      maxLength: 256,
      type: 'string',
      description: `The name of the assistant. The maximum length is 256 characters.
`,
      nullable: true,
    },
    description: {
      maxLength: 512,
      type: 'string',
      description: `The description of the assistant. The maximum length is 512 characters.
`,
      nullable: true,
    },
    instructions: {
      maxLength: 256000,
      type: 'string',
      description: `The system instructions that the assistant uses. The maximum length is 256,000 characters.
`,
      nullable: true,
    },
    tools: {
      maxItems: 128,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: `A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types \`code_interpreter\`, \`file_search\`, or \`function\`.
`,
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `Overrides the list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `Overrides the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
`,
            },
          },
        },
      },
      description: `A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  additionalProperties: false,
} as const;

export const DeleteAssistantResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      enum: ['assistant.deleted'],
      type: 'string',
    },
  },
} as const;

export const ListAssistantsResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AssistantObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'asst_abc123',
    },
    last_id: {
      type: 'string',
      example: 'asst_abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
  'x-oaiMeta': {
    name: 'List assistants response object',
    group: 'chat',
    example: `{
  "object": "list",
  "data": [
    {
      "id": "asst_abc123",
      "object": "assistant",
      "created_at": 1698982736,
      "name": "Coding Tutor",
      "description": null,
      "model": "gpt-4o",
      "instructions": "You are a helpful assistant designed to make me better at coding!",
      "tools": [],
      "tool_resources": {},
      "metadata": {},
      "top_p": 1.0,
      "temperature": 1.0,
      "response_format": "auto"
    },
    {
      "id": "asst_abc456",
      "object": "assistant",
      "created_at": 1698982718,
      "name": "My Assistant",
      "description": null,
      "model": "gpt-4o",
      "instructions": "You are a helpful assistant designed to make me better at coding!",
      "tools": [],
      "tool_resources": {},
      "metadata": {},
      "top_p": 1.0,
      "temperature": 1.0,
      "response_format": "auto"
    },
    {
      "id": "asst_abc789",
      "object": "assistant",
      "created_at": 1698982643,
      "name": null,
      "description": null,
      "model": "gpt-4o",
      "instructions": null,
      "tools": [],
      "tool_resources": {},
      "metadata": {},
      "top_p": 1.0,
      "temperature": 1.0,
      "response_format": "auto"
    }
  ],
  "first_id": "asst_abc123",
  "last_id": "asst_abc789",
  "has_more": false
}
`,
  },
} as const;

export const AssistantToolsCodeSchema = {
  title: 'Code interpreter tool',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['code_interpreter'],
      type: 'string',
      description: 'The type of tool being defined: `code_interpreter`',
    },
  },
} as const;

export const AssistantToolsFileSearchSchema = {
  title: 'FileSearch tool',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['file_search'],
      type: 'string',
      description: 'The type of tool being defined: `file_search`',
    },
    file_search: {
      type: 'object',
      properties: {
        max_num_results: {
          maximum: 50,
          minimum: 1,
          type: 'integer',
          description: `The maximum number of results the file search tool should output. The default is 20 for \`gpt-4*\` models and 5 for \`gpt-3.5-turbo\`. This number should be between 1 and 50 inclusive.

Note that the file search tool may output fewer than \`max_num_results\` results. See the [file search tool documentation](/docs/assistants/tools/file-search/number-of-chunks-returned) for more information.
`,
        },
      },
      description: 'Overrides for the file search tool.',
    },
  },
} as const;

export const AssistantToolsFileSearchTypeOnlySchema = {
  title: 'FileSearch tool',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['file_search'],
      type: 'string',
      description: 'The type of tool being defined: `file_search`',
    },
  },
} as const;

export const AssistantToolsFunctionSchema = {
  title: 'Function tool',
  required: ['type', 'function'],
  type: 'object',
  properties: {
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of tool being defined: `function`',
    },
    function: {
      $ref: '#/components/schemas/FunctionObject',
    },
  },
} as const;

export const TruncationObjectSchema = {
  title: 'Thread Truncation Controls',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['auto', 'last_messages'],
      type: 'string',
      description:
        'The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will be truncated to the n most recent messages in the thread. When set to `auto`, messages in the middle of the thread will be dropped to fit the context length of the model, `max_prompt_tokens`.',
    },
    last_messages: {
      minimum: 1,
      type: 'integer',
      description: 'The number of most recent messages from the thread when constructing the context for the run.',
      nullable: true,
    },
  },
  description:
    'Controls for how a thread will be truncated prior to the run. Use this to control the intial context window of the run.',
} as const;

export const AssistantsApiToolChoiceOptionSchema = {
  oneOf: [
    {
      enum: ['none', 'auto', 'required'],
      type: 'string',
      description: `\`none\` means the model will not call any tools and instead generates a message. \`auto\` means the model can pick between generating a message or calling one or more tools. \`required\` means the model must call one or more tools before responding to the user.
`,
    },
    {
      $ref: '#/components/schemas/AssistantsNamedToolChoice',
    },
  ],
  description: `Controls which (if any) tool is called by the model.
\`none\` means the model will not call any tools and instead generates a message.
\`auto\` is the default value and means the model can pick between generating a message or calling one or more tools.
\`required\` means the model must call one or more tools before responding to the user.
Specifying a particular tool like \`{"type": "file_search"}\` or \`{"type": "function", "function": {"name": "my_function"}}\` forces the model to call that tool.
`,
  'x-oaiExpandable': true,
} as const;

export const AssistantsNamedToolChoiceSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['function', 'code_interpreter', 'file_search'],
      type: 'string',
      description: 'The type of the tool. If type is `function`, the function name must be set',
    },
    function: {
      required: ['name'],
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function to call.',
        },
      },
    },
  },
  description: 'Specifies a tool the model should use. Use to force the model to call a specific tool.',
} as const;

export const RunObjectSchema = {
  title: 'A run on a thread',
  required: [
    'id',
    'object',
    'created_at',
    'thread_id',
    'assistant_id',
    'status',
    'required_action',
    'last_error',
    'expires_at',
    'started_at',
    'cancelled_at',
    'failed_at',
    'completed_at',
    'model',
    'instructions',
    'tools',
    'metadata',
    'usage',
    'incomplete_details',
    'max_prompt_tokens',
    'max_completion_tokens',
    'truncation_strategy',
    'tool_choice',
    'parallel_tool_calls',
    'response_format',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread.run'],
      type: 'string',
      description: 'The object type, which is always `thread.run`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run was created.',
    },
    thread_id: {
      type: 'string',
      description: 'The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.',
    },
    assistant_id: {
      type: 'string',
      description: 'The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.',
    },
    status: {
      enum: [
        'queued',
        'in_progress',
        'requires_action',
        'cancelling',
        'cancelled',
        'failed',
        'completed',
        'incomplete',
        'expired',
      ],
      type: 'string',
      description:
        'The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, `incomplete`, or `expired`.',
    },
    required_action: {
      required: ['type', 'submit_tool_outputs'],
      type: 'object',
      properties: {
        type: {
          enum: ['submit_tool_outputs'],
          type: 'string',
          description: 'For now, this is always `submit_tool_outputs`.',
        },
        submit_tool_outputs: {
          required: ['tool_calls'],
          type: 'object',
          properties: {
            tool_calls: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/RunToolCallObject',
              },
              description: 'A list of the relevant tool calls.',
            },
          },
          description: 'Details on the tool outputs needed for this run to continue.',
        },
      },
      description: 'Details on the action required to continue the run. Will be `null` if no action is required.',
      nullable: true,
    },
    last_error: {
      required: ['code', 'message'],
      type: 'object',
      properties: {
        code: {
          enum: ['server_error', 'rate_limit_exceeded', 'invalid_prompt'],
          type: 'string',
          description: 'One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.',
        },
        message: {
          type: 'string',
          description: 'A human-readable description of the error.',
        },
      },
      description: 'The last error associated with this run. Will be `null` if there are no errors.',
      nullable: true,
    },
    expires_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run will expire.',
      nullable: true,
    },
    started_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run was started.',
      nullable: true,
    },
    cancelled_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run was cancelled.',
      nullable: true,
    },
    failed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run failed.',
      nullable: true,
    },
    completed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run was completed.',
      nullable: true,
    },
    incomplete_details: {
      type: 'object',
      properties: {
        reason: {
          enum: ['max_completion_tokens', 'max_prompt_tokens'],
          type: 'string',
          description:
            'The reason why the run is incomplete. This will point to which specific token limit was reached over the course of the run.',
        },
      },
      description: 'Details on why the run is incomplete. Will be `null` if the run is not incomplete.',
      nullable: true,
    },
    model: {
      type: 'string',
      description: 'The model that the [assistant](/docs/api-reference/assistants) used for this run.',
    },
    instructions: {
      type: 'string',
      description: 'The instructions that the [assistant](/docs/api-reference/assistants) used for this run.',
    },
    tools: {
      maxItems: 20,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: 'The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.',
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    usage: {
      $ref: '#/components/schemas/RunCompletionUsage',
    },
    temperature: {
      type: 'number',
      description: 'The sampling temperature used for this run. If not set, defaults to 1.',
      nullable: true,
    },
    top_p: {
      type: 'number',
      description: 'The nucleus sampling value used for this run. If not set, defaults to 1.',
      nullable: true,
    },
    max_prompt_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of prompt tokens specified to have been used over the course of the run.
`,
      nullable: true,
    },
    max_completion_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of completion tokens specified to have been used over the course of the run.
`,
      nullable: true,
    },
    truncation_strategy: {
      $ref: '#/components/schemas/TruncationObject',
    },
    tool_choice: {
      $ref: '#/components/schemas/AssistantsApiToolChoiceOption',
    },
    parallel_tool_calls: {
      $ref: '#/components/schemas/ParallelToolCalls',
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  description: 'Represents an execution run on a [thread](/docs/api-reference/threads).',
  'x-oaiMeta': {
    name: 'The run object',
    beta: true,
    example: `{
  "id": "run_abc123",
  "object": "thread.run",
  "created_at": 1698107661,
  "assistant_id": "asst_abc123",
  "thread_id": "thread_abc123",
  "status": "completed",
  "started_at": 1699073476,
  "expires_at": null,
  "cancelled_at": null,
  "failed_at": null,
  "completed_at": 1699073498,
  "last_error": null,
  "model": "gpt-4o",
  "instructions": null,
  "tools": [{"type": "file_search"}, {"type": "code_interpreter"}],
  "metadata": {},
  "incomplete_details": null,
  "usage": {
    "prompt_tokens": 123,
    "completion_tokens": 456,
    "total_tokens": 579
  },
  "temperature": 1.0,
  "top_p": 1.0,
  "max_prompt_tokens": 1000,
  "max_completion_tokens": 1000,
  "truncation_strategy": {
    "type": "auto",
    "last_messages": null
  },
  "response_format": "auto",
  "tool_choice": "auto",
  "parallel_tool_calls": true
}
`,
  },
} as const;

export const CreateRunRequestSchema = {
  required: ['thread_id', 'assistant_id'],
  type: 'object',
  properties: {
    assistant_id: {
      type: 'string',
      description: 'The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: [
            'gpt-4o',
            'gpt-4o-2024-08-06',
            'gpt-4o-2024-05-13',
            'gpt-4o-mini',
            'gpt-4o-mini-2024-07-18',
            'gpt-4-turbo',
            'gpt-4-turbo-2024-04-09',
            'gpt-4-0125-preview',
            'gpt-4-turbo-preview',
            'gpt-4-1106-preview',
            'gpt-4-vision-preview',
            'gpt-4',
            'gpt-4-0314',
            'gpt-4-0613',
            'gpt-4-32k',
            'gpt-4-32k-0314',
            'gpt-4-32k-0613',
            'gpt-3.5-turbo',
            'gpt-3.5-turbo-16k',
            'gpt-3.5-turbo-0613',
            'gpt-3.5-turbo-1106',
            'gpt-3.5-turbo-0125',
            'gpt-3.5-turbo-16k-0613',
          ],
          type: 'string',
        },
      ],
      description:
        'The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.',
      nullable: true,
      example: 'gpt-4o',
      'x-oaiTypeLabel': 'string',
    },
    instructions: {
      type: 'string',
      description:
        'Overrides the [instructions](/docs/api-reference/assistants/createAssistant) of the assistant. This is useful for modifying the behavior on a per-run basis.',
      nullable: true,
    },
    additional_instructions: {
      type: 'string',
      description:
        'Appends additional instructions at the end of the instructions for the run. This is useful for modifying the behavior on a per-run basis without overriding other instructions.',
      nullable: true,
    },
    additional_messages: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CreateMessageRequest',
      },
      description: 'Adds additional messages to the thread before creating the run.',
      nullable: true,
    },
    tools: {
      maxItems: 20,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
        'x-oaiExpandable': true,
      },
      description:
        'Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.',
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    stream: {
      type: 'boolean',
      description: `If \`true\`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a \`data: [DONE]\` message.
`,
      nullable: true,
    },
    max_prompt_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status \`incomplete\`. See \`incomplete_details\` for more info.
`,
      nullable: true,
    },
    max_completion_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status \`incomplete\`. See \`incomplete_details\` for more info.
`,
      nullable: true,
    },
    truncation_strategy: {
      $ref: '#/components/schemas/TruncationObject',
    },
    tool_choice: {
      $ref: '#/components/schemas/AssistantsApiToolChoiceOption',
    },
    parallel_tool_calls: {
      $ref: '#/components/schemas/ParallelToolCalls',
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  additionalProperties: false,
} as const;

export const ListRunsResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/RunObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'run_abc123',
    },
    last_id: {
      type: 'string',
      example: 'run_abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const ModifyRunRequestSchema = {
  type: 'object',
  properties: {
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const SubmitToolOutputsRunRequestSchema = {
  required: ['tool_outputs'],
  type: 'object',
  properties: {
    tool_outputs: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          tool_call_id: {
            type: 'string',
            description:
              'The ID of the tool call in the `required_action` object within the run object the output is being submitted for.',
          },
          output: {
            type: 'string',
            description: 'The output of the tool call to be submitted to continue the run.',
          },
        },
      },
      description: 'A list of tools for which the outputs are being submitted.',
    },
    stream: {
      type: 'boolean',
      description: `If \`true\`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a \`data: [DONE]\` message.
`,
      nullable: true,
    },
  },
  additionalProperties: false,
} as const;

export const RunToolCallObjectSchema = {
  required: ['id', 'type', 'function'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description:
        'The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.',
    },
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of tool call the output is required for. For now, this is always `function`.',
    },
    function: {
      required: ['name', 'arguments'],
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function.',
        },
        arguments: {
          type: 'string',
          description: 'The arguments that the model expects you to pass to the function.',
        },
      },
      description: 'The function definition.',
    },
  },
  description: 'Tool call objects',
} as const;

export const CreateThreadAndRunRequestSchema = {
  required: ['thread_id', 'assistant_id'],
  type: 'object',
  properties: {
    assistant_id: {
      type: 'string',
      description: 'The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.',
    },
    thread: {
      $ref: '#/components/schemas/CreateThreadRequest',
    },
    model: {
      anyOf: [
        {
          type: 'string',
        },
        {
          enum: [
            'gpt-4o',
            'gpt-4o-2024-08-06',
            'gpt-4o-2024-05-13',
            'gpt-4o-mini',
            'gpt-4o-mini-2024-07-18',
            'gpt-4-turbo',
            'gpt-4-turbo-2024-04-09',
            'gpt-4-0125-preview',
            'gpt-4-turbo-preview',
            'gpt-4-1106-preview',
            'gpt-4-vision-preview',
            'gpt-4',
            'gpt-4-0314',
            'gpt-4-0613',
            'gpt-4-32k',
            'gpt-4-32k-0314',
            'gpt-4-32k-0613',
            'gpt-3.5-turbo',
            'gpt-3.5-turbo-16k',
            'gpt-3.5-turbo-0613',
            'gpt-3.5-turbo-1106',
            'gpt-3.5-turbo-0125',
            'gpt-3.5-turbo-16k-0613',
          ],
          type: 'string',
        },
      ],
      description:
        'The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.',
      nullable: true,
      example: 'gpt-4o',
      'x-oaiTypeLabel': 'string',
    },
    instructions: {
      type: 'string',
      description:
        'Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.',
      nullable: true,
    },
    tools: {
      maxItems: 20,
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/AssistantToolsCode',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFileSearch',
          },
          {
            $ref: '#/components/schemas/AssistantToolsFunction',
          },
        ],
      },
      description:
        'Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.',
      nullable: true,
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.
`,
            },
          },
        },
      },
      description: `A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    temperature: {
      maximum: 2,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    top_p: {
      maximum: 1,
      minimum: 0,
      type: 'number',
      description: 'empty',
      default: 1,
      nullable: true,
      example: 1,
    },
    stream: {
      type: 'boolean',
      description: `If \`true\`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a \`data: [DONE]\` message.
`,
      nullable: true,
    },
    max_prompt_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status \`incomplete\`. See \`incomplete_details\` for more info.
`,
      nullable: true,
    },
    max_completion_tokens: {
      minimum: 256,
      type: 'integer',
      description: `The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status \`incomplete\`. See \`incomplete_details\` for more info.
`,
      nullable: true,
    },
    truncation_strategy: {
      $ref: '#/components/schemas/TruncationObject',
    },
    tool_choice: {
      $ref: '#/components/schemas/AssistantsApiToolChoiceOption',
    },
    parallel_tool_calls: {
      $ref: '#/components/schemas/ParallelToolCalls',
    },
    response_format: {
      $ref: '#/components/schemas/AssistantsApiResponseFormatOption',
    },
  },
  additionalProperties: false,
} as const;

export const ThreadObjectSchema = {
  title: 'Thread',
  required: ['id', 'object', 'created_at', 'tool_resources', 'metadata'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread'],
      type: 'string',
      description: 'The object type, which is always `thread`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the thread was created.',
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
`,
            },
          },
        },
      },
      description: `A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  description: 'Represents a thread that contains [messages](/docs/api-reference/messages).',
  'x-oaiMeta': {
    name: 'The thread object',
    beta: true,
    example: `{
  "id": "thread_abc123",
  "object": "thread",
  "created_at": 1698107661,
  "metadata": {}
}
`,
  },
} as const;

export const CreateThreadRequestSchema = {
  type: 'object',
  properties: {
    messages: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CreateMessageRequest',
      },
      description: 'A list of [messages](/docs/api-reference/messages) to start the thread with.',
    },
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          oneOf: [
            {
              required: ['vector_store_ids'],
            },
            {
              required: ['vector_stores'],
            },
          ],
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
`,
            },
            vector_stores: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  file_ids: {
                    maxItems: 10000,
                    type: 'array',
                    items: {
                      type: 'string',
                    },
                    description: `A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.
`,
                  },
                  chunking_strategy: {
                    type: 'object',
                    oneOf: [
                      {
                        title: 'Auto Chunking Strategy',
                        required: ['type'],
                        type: 'object',
                        properties: {
                          type: {
                            enum: ['auto'],
                            type: 'string',
                            description: 'Always `auto`.',
                          },
                        },
                        additionalProperties: false,
                        description:
                          'The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.',
                      },
                      {
                        title: 'Static Chunking Strategy',
                        required: ['type', 'static'],
                        type: 'object',
                        properties: {
                          type: {
                            enum: ['static'],
                            type: 'string',
                            description: 'Always `static`.',
                          },
                          static: {
                            required: ['max_chunk_size_tokens', 'chunk_overlap_tokens'],
                            type: 'object',
                            properties: {
                              max_chunk_size_tokens: {
                                maximum: 4096,
                                minimum: 100,
                                type: 'integer',
                                description:
                                  'The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.',
                              },
                              chunk_overlap_tokens: {
                                type: 'integer',
                                description: `The number of tokens that overlap between chunks. The default value is \`400\`.

Note that the overlap must not exceed half of \`max_chunk_size_tokens\`.
`,
                              },
                            },
                            additionalProperties: false,
                          },
                        },
                        additionalProperties: false,
                      },
                    ],
                    description:
                      'The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
                    'x-oaiExpandable': true,
                  },
                  metadata: {
                    type: 'object',
                    description: `Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
                    'x-oaiTypeLabel': 'map',
                  },
                },
                'x-oaiExpandable': true,
              },
              description: `A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.
`,
            },
          },
        },
      },
      description: `A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const ModifyThreadRequestSchema = {
  type: 'object',
  properties: {
    tool_resources: {
      type: 'object',
      properties: {
        code_interpreter: {
          type: 'object',
          properties: {
            file_ids: {
              maxItems: 20,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `A list of [file](/docs/api-reference/files) IDs made available to the \`code_interpreter\` tool. There can be a maximum of 20 files associated with the tool.
`,
            },
          },
        },
        file_search: {
          type: 'object',
          properties: {
            vector_store_ids: {
              maxItems: 1,
              type: 'array',
              items: {
                type: 'string',
              },
              description: `The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.
`,
            },
          },
        },
      },
      description: `A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the \`code_interpreter\` tool requires a list of file IDs, while the \`file_search\` tool requires a list of vector store IDs.
`,
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const DeleteThreadResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      enum: ['thread.deleted'],
      type: 'string',
    },
  },
} as const;

export const ListThreadsResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ThreadObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'asst_abc123',
    },
    last_id: {
      type: 'string',
      example: 'asst_abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const MessageObjectSchema = {
  title: 'The message object',
  required: [
    'id',
    'object',
    'created_at',
    'thread_id',
    'status',
    'incomplete_details',
    'completed_at',
    'incomplete_at',
    'role',
    'content',
    'assistant_id',
    'run_id',
    'attachments',
    'metadata',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread.message'],
      type: 'string',
      description: 'The object type, which is always `thread.message`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the message was created.',
    },
    thread_id: {
      type: 'string',
      description: 'The [thread](/docs/api-reference/threads) ID that this message belongs to.',
    },
    status: {
      enum: ['in_progress', 'incomplete', 'completed'],
      type: 'string',
      description: 'The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.',
    },
    incomplete_details: {
      required: ['reason'],
      type: 'object',
      properties: {
        reason: {
          enum: ['content_filter', 'max_tokens', 'run_cancelled', 'run_expired', 'run_failed'],
          type: 'string',
          description: 'The reason the message is incomplete.',
        },
      },
      description: 'On an incomplete message, details about why the message is incomplete.',
      nullable: true,
    },
    completed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the message was completed.',
      nullable: true,
    },
    incomplete_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the message was marked as incomplete.',
      nullable: true,
    },
    role: {
      enum: ['user', 'assistant'],
      type: 'string',
      description: 'The entity that produced the message. One of `user` or `assistant`.',
    },
    content: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/MessageContentImageFileObject',
          },
          {
            $ref: '#/components/schemas/MessageContentImageUrlObject',
          },
          {
            $ref: '#/components/schemas/MessageContentTextObject',
          },
          {
            $ref: '#/components/schemas/MessageContentRefusalObject',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: 'The content of the message in array of text and/or images.',
    },
    assistant_id: {
      type: 'string',
      description:
        'If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.',
      nullable: true,
    },
    run_id: {
      type: 'string',
      description:
        'The ID of the [run](/docs/api-reference/runs) associated with the creation of this message. Value is `null` when messages are created manually using the create message or create thread endpoints.',
      nullable: true,
    },
    attachments: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          file_id: {
            type: 'string',
            description: 'The ID of the file to attach to the message.',
          },
          tools: {
            type: 'array',
            items: {
              oneOf: [
                {
                  $ref: '#/components/schemas/AssistantToolsCode',
                },
                {
                  $ref: '#/components/schemas/AssistantToolsFileSearchTypeOnly',
                },
              ],
              'x-oaiExpandable': true,
            },
            description: 'The tools to add this file to.',
          },
        },
      },
      description: 'A list of files attached to the message, and the tools they were added to.',
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  description: 'Represents a message within a [thread](/docs/api-reference/threads).',
  'x-oaiMeta': {
    name: 'The message object',
    beta: true,
    example: `{
  "id": "msg_abc123",
  "object": "thread.message",
  "created_at": 1698983503,
  "thread_id": "thread_abc123",
  "role": "assistant",
  "content": [
    {
      "type": "text",
      "text": {
        "value": "Hi! How can I help you today?",
        "annotations": []
      }
    }
  ],
  "assistant_id": "asst_abc123",
  "run_id": "run_abc123",
  "attachments": [],
  "metadata": {}
}
`,
  },
} as const;

export const MessageDeltaObjectSchema = {
  title: 'Message delta object',
  required: ['id', 'object', 'delta'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier of the message, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread.message.delta'],
      type: 'string',
      description: 'The object type, which is always `thread.message.delta`.',
    },
    delta: {
      type: 'object',
      properties: {
        role: {
          enum: ['user', 'assistant'],
          type: 'string',
          description: 'The entity that produced the message. One of `user` or `assistant`.',
        },
        content: {
          type: 'array',
          items: {
            oneOf: [
              {
                $ref: '#/components/schemas/MessageDeltaContentImageFileObject',
              },
              {
                $ref: '#/components/schemas/MessageDeltaContentTextObject',
              },
              {
                $ref: '#/components/schemas/MessageDeltaContentRefusalObject',
              },
              {
                $ref: '#/components/schemas/MessageDeltaContentImageUrlObject',
              },
            ],
            'x-oaiExpandable': true,
          },
          description: 'The content of the message in array of text and/or images.',
        },
      },
      description: 'The delta containing the fields that have changed on the Message.',
    },
  },
  description: `Represents a message delta i.e. any changed fields on a message during streaming.
`,
  'x-oaiMeta': {
    name: 'The message delta object',
    beta: true,
    example: `{
  "id": "msg_123",
  "object": "thread.message.delta",
  "delta": {
    "content": [
      {
        "index": 0,
        "type": "text",
        "text": { "value": "Hello", "annotations": [] }
      }
    ]
  }
}
`,
  },
} as const;

export const CreateMessageRequestSchema = {
  required: ['role', 'content'],
  type: 'object',
  properties: {
    role: {
      enum: ['user', 'assistant'],
      type: 'string',
      description: `The role of the entity that is creating the message. Allowed values include:
- \`user\`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.
- \`assistant\`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.
`,
    },
    content: {
      oneOf: [
        {
          title: 'Text content',
          type: 'string',
          description: 'The text contents of the message.',
        },
        {
          title: 'Array of content parts',
          minItems: 1,
          type: 'array',
          items: {
            oneOf: [
              {
                $ref: '#/components/schemas/MessageContentImageFileObject',
              },
              {
                $ref: '#/components/schemas/MessageContentImageUrlObject',
              },
              {
                $ref: '#/components/schemas/MessageRequestContentTextObject',
              },
            ],
            'x-oaiExpandable': true,
          },
          description:
            'An array of content parts with a defined type, each can be of type `text` or images can be passed with `image_url` or `image_file`. Image types are only supported on [Vision-compatible models](/docs/models/overview).',
        },
      ],
      'x-oaiExpandable': true,
    },
    attachments: {
      required: ['file_id', 'tools'],
      type: 'array',
      items: {
        type: 'object',
        properties: {
          file_id: {
            type: 'string',
            description: 'The ID of the file to attach to the message.',
          },
          tools: {
            type: 'array',
            items: {
              oneOf: [
                {
                  $ref: '#/components/schemas/AssistantToolsCode',
                },
                {
                  $ref: '#/components/schemas/AssistantToolsFileSearchTypeOnly',
                },
              ],
              'x-oaiExpandable': true,
            },
            description: 'The tools to add this file to.',
          },
        },
      },
      description: 'A list of files attached to the message, and the tools they should be added to.',
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const ModifyMessageRequestSchema = {
  type: 'object',
  properties: {
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const DeleteMessageResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      enum: ['thread.message.deleted'],
      type: 'string',
    },
  },
} as const;

export const ListMessagesResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MessageObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'msg_abc123',
    },
    last_id: {
      type: 'string',
      example: 'msg_abc123',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const MessageContentImageFileObjectSchema = {
  title: 'Image file',
  required: ['type', 'image_file'],
  type: 'object',
  properties: {
    type: {
      enum: ['image_file'],
      type: 'string',
      description: 'Always `image_file`.',
    },
    image_file: {
      required: ['file_id'],
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description:
            'The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.',
        },
        detail: {
          enum: ['auto', 'low', 'high'],
          type: 'string',
          description:
            'Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
          default: 'auto',
        },
      },
    },
  },
  description: 'References an image [File](/docs/api-reference/files) in the content of a message.',
} as const;

export const MessageDeltaContentImageFileObjectSchema = {
  title: 'Image file',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the content part in the message.',
    },
    type: {
      enum: ['image_file'],
      type: 'string',
      description: 'Always `image_file`.',
    },
    image_file: {
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description:
            'The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.',
        },
        detail: {
          enum: ['auto', 'low', 'high'],
          type: 'string',
          description:
            'Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
          default: 'auto',
        },
      },
    },
  },
  description: 'References an image [File](/docs/api-reference/files) in the content of a message.',
} as const;

export const MessageContentImageUrlObjectSchema = {
  title: 'Image URL',
  required: ['type', 'image_url'],
  type: 'object',
  properties: {
    type: {
      enum: ['image_url'],
      type: 'string',
      description: 'The type of the content part.',
    },
    image_url: {
      required: ['url'],
      type: 'object',
      properties: {
        url: {
          type: 'string',
          description: 'The external URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.',
          format: 'uri',
        },
        detail: {
          enum: ['auto', 'low', 'high'],
          type: 'string',
          description:
            'Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`. Default value is `auto`',
          default: 'auto',
        },
      },
    },
  },
  description: 'References an image URL in the content of a message.',
} as const;

export const MessageDeltaContentImageUrlObjectSchema = {
  title: 'Image URL',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the content part in the message.',
    },
    type: {
      enum: ['image_url'],
      type: 'string',
      description: 'Always `image_url`.',
    },
    image_url: {
      type: 'object',
      properties: {
        url: {
          type: 'string',
          description: 'The URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.',
        },
        detail: {
          enum: ['auto', 'low', 'high'],
          type: 'string',
          description:
            'Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
          default: 'auto',
        },
      },
    },
  },
  description: 'References an image URL in the content of a message.',
} as const;

export const MessageContentTextObjectSchema = {
  title: 'Text',
  required: ['type', 'text'],
  type: 'object',
  properties: {
    type: {
      enum: ['text'],
      type: 'string',
      description: 'Always `text`.',
    },
    text: {
      required: ['value', 'annotations'],
      type: 'object',
      properties: {
        value: {
          type: 'string',
          description: 'The data that makes up the text.',
        },
        annotations: {
          type: 'array',
          items: {
            oneOf: [
              {
                $ref: '#/components/schemas/MessageContentTextAnnotationsFileCitationObject',
              },
              {
                $ref: '#/components/schemas/MessageContentTextAnnotationsFilePathObject',
              },
            ],
            'x-oaiExpandable': true,
          },
        },
      },
    },
  },
  description: 'The text content that is part of a message.',
} as const;

export const MessageContentRefusalObjectSchema = {
  title: 'Refusal',
  required: ['type', 'refusal'],
  type: 'object',
  properties: {
    type: {
      enum: ['refusal'],
      type: 'string',
      description: 'Always `refusal`.',
    },
    refusal: {
      type: 'string',
    },
  },
  description: 'The refusal content generated by the assistant.',
} as const;

export const MessageRequestContentTextObjectSchema = {
  title: 'Text',
  required: ['type', 'text'],
  type: 'object',
  properties: {
    type: {
      enum: ['text'],
      type: 'string',
      description: 'Always `text`.',
    },
    text: {
      type: 'string',
      description: 'Text content to be sent to the model',
    },
  },
  description: 'The text content that is part of a message.',
} as const;

export const MessageContentTextAnnotationsFileCitationObjectSchema = {
  title: 'File citation',
  required: ['type', 'text', 'file_citation', 'start_index', 'end_index'],
  type: 'object',
  properties: {
    type: {
      enum: ['file_citation'],
      type: 'string',
      description: 'Always `file_citation`.',
    },
    text: {
      type: 'string',
      description: 'The text in the message content that needs to be replaced.',
    },
    file_citation: {
      required: ['file_id'],
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The ID of the specific File the citation is from.',
        },
      },
    },
    start_index: {
      minimum: 0,
      type: 'integer',
    },
    end_index: {
      minimum: 0,
      type: 'integer',
    },
  },
  description:
    'A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.',
} as const;

export const MessageContentTextAnnotationsFilePathObjectSchema = {
  title: 'File path',
  required: ['type', 'text', 'file_path', 'start_index', 'end_index'],
  type: 'object',
  properties: {
    type: {
      enum: ['file_path'],
      type: 'string',
      description: 'Always `file_path`.',
    },
    text: {
      type: 'string',
      description: 'The text in the message content that needs to be replaced.',
    },
    file_path: {
      required: ['file_id'],
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The ID of the file that was generated.',
        },
      },
    },
    start_index: {
      minimum: 0,
      type: 'integer',
    },
    end_index: {
      minimum: 0,
      type: 'integer',
    },
  },
  description:
    "A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.",
} as const;

export const MessageDeltaContentTextObjectSchema = {
  title: 'Text',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the content part in the message.',
    },
    type: {
      enum: ['text'],
      type: 'string',
      description: 'Always `text`.',
    },
    text: {
      type: 'object',
      properties: {
        value: {
          type: 'string',
          description: 'The data that makes up the text.',
        },
        annotations: {
          type: 'array',
          items: {
            oneOf: [
              {
                $ref: '#/components/schemas/MessageDeltaContentTextAnnotationsFileCitationObject',
              },
              {
                $ref: '#/components/schemas/MessageDeltaContentTextAnnotationsFilePathObject',
              },
            ],
            'x-oaiExpandable': true,
          },
        },
      },
    },
  },
  description: 'The text content that is part of a message.',
} as const;

export const MessageDeltaContentRefusalObjectSchema = {
  title: 'Refusal',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the refusal part in the message.',
    },
    type: {
      enum: ['refusal'],
      type: 'string',
      description: 'Always `refusal`.',
    },
    refusal: {
      type: 'string',
    },
  },
  description: 'The refusal content that is part of a message.',
} as const;

export const MessageDeltaContentTextAnnotationsFileCitationObjectSchema = {
  title: 'File citation',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the annotation in the text content part.',
    },
    type: {
      enum: ['file_citation'],
      type: 'string',
      description: 'Always `file_citation`.',
    },
    text: {
      type: 'string',
      description: 'The text in the message content that needs to be replaced.',
    },
    file_citation: {
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The ID of the specific File the citation is from.',
        },
        quote: {
          type: 'string',
          description: 'The specific quote in the file.',
        },
      },
    },
    start_index: {
      minimum: 0,
      type: 'integer',
    },
    end_index: {
      minimum: 0,
      type: 'integer',
    },
  },
  description:
    'A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.',
} as const;

export const MessageDeltaContentTextAnnotationsFilePathObjectSchema = {
  title: 'File path',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the annotation in the text content part.',
    },
    type: {
      enum: ['file_path'],
      type: 'string',
      description: 'Always `file_path`.',
    },
    text: {
      type: 'string',
      description: 'The text in the message content that needs to be replaced.',
    },
    file_path: {
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The ID of the file that was generated.',
        },
      },
    },
    start_index: {
      minimum: 0,
      type: 'integer',
    },
    end_index: {
      minimum: 0,
      type: 'integer',
    },
  },
  description:
    "A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.",
} as const;

export const RunStepObjectSchema = {
  title: 'Run steps',
  required: [
    'id',
    'object',
    'created_at',
    'assistant_id',
    'thread_id',
    'run_id',
    'type',
    'status',
    'step_details',
    'last_error',
    'expired_at',
    'cancelled_at',
    'failed_at',
    'completed_at',
    'metadata',
    'usage',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier of the run step, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread.run.step'],
      type: 'string',
      description: 'The object type, which is always `thread.run.step`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run step was created.',
    },
    assistant_id: {
      type: 'string',
      description: 'The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.',
    },
    thread_id: {
      type: 'string',
      description: 'The ID of the [thread](/docs/api-reference/threads) that was run.',
    },
    run_id: {
      type: 'string',
      description: 'The ID of the [run](/docs/api-reference/runs) that this run step is a part of.',
    },
    type: {
      enum: ['message_creation', 'tool_calls'],
      type: 'string',
      description: 'The type of run step, which can be either `message_creation` or `tool_calls`.',
    },
    status: {
      enum: ['in_progress', 'cancelled', 'failed', 'completed', 'expired'],
      type: 'string',
      description:
        'The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.',
    },
    step_details: {
      type: 'object',
      oneOf: [
        {
          $ref: '#/components/schemas/RunStepDetailsMessageCreationObject',
        },
        {
          $ref: '#/components/schemas/RunStepDetailsToolCallsObject',
        },
      ],
      description: 'The details of the run step.',
      'x-oaiExpandable': true,
    },
    last_error: {
      required: ['code', 'message'],
      type: 'object',
      properties: {
        code: {
          enum: ['server_error', 'rate_limit_exceeded'],
          type: 'string',
          description: 'One of `server_error` or `rate_limit_exceeded`.',
        },
        message: {
          type: 'string',
          description: 'A human-readable description of the error.',
        },
      },
      description: 'The last error associated with this run step. Will be `null` if there are no errors.',
      nullable: true,
    },
    expired_at: {
      type: 'integer',
      description:
        'The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.',
      nullable: true,
    },
    cancelled_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run step was cancelled.',
      nullable: true,
    },
    failed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run step failed.',
      nullable: true,
    },
    completed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the run step completed.',
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
    usage: {
      $ref: '#/components/schemas/RunStepCompletionUsage',
    },
  },
  description: `Represents a step in execution of a run.
`,
  'x-oaiMeta': {
    name: 'The run step object',
    beta: true,
    example: `{
  "id": "step_abc123",
  "object": "thread.run.step",
  "created_at": 1699063291,
  "run_id": "run_abc123",
  "assistant_id": "asst_abc123",
  "thread_id": "thread_abc123",
  "type": "message_creation",
  "status": "completed",
  "cancelled_at": null,
  "completed_at": 1699063291,
  "expired_at": null,
  "failed_at": null,
  "last_error": null,
  "step_details": {
    "type": "message_creation",
    "message_creation": {
      "message_id": "msg_abc123"
    }
  },
  "usage": {
    "prompt_tokens": 123,
    "completion_tokens": 456,
    "total_tokens": 579
  }
}
`,
  },
} as const;

export const RunStepDeltaObjectSchema = {
  title: 'Run step delta object',
  required: ['id', 'object', 'delta'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier of the run step, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['thread.run.step.delta'],
      type: 'string',
      description: 'The object type, which is always `thread.run.step.delta`.',
    },
    delta: {
      type: 'object',
      properties: {
        step_details: {
          type: 'object',
          oneOf: [
            {
              $ref: '#/components/schemas/RunStepDeltaStepDetailsMessageCreationObject',
            },
            {
              $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsObject',
            },
          ],
          description: 'The details of the run step.',
          'x-oaiExpandable': true,
        },
      },
      description: 'The delta containing the fields that have changed on the run step.',
    },
  },
  description: `Represents a run step delta i.e. any changed fields on a run step during streaming.
`,
  'x-oaiMeta': {
    name: 'The run step delta object',
    beta: true,
    example: `{
  "id": "step_123",
  "object": "thread.run.step.delta",
  "delta": {
    "step_details": {
      "type": "tool_calls",
      "tool_calls": [
        {
          "index": 0,
          "id": "call_123",
          "type": "code_interpreter",
          "code_interpreter": { "input": "", "outputs": [] }
        }
      ]
    }
  }
}
`,
  },
} as const;

export const ListRunStepsResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/RunStepObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'step_abc123',
    },
    last_id: {
      type: 'string',
      example: 'step_abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const RunStepDetailsMessageCreationObjectSchema = {
  title: 'Message creation',
  required: ['type', 'message_creation'],
  type: 'object',
  properties: {
    type: {
      enum: ['message_creation'],
      type: 'string',
      description: 'Always `message_creation`.',
    },
    message_creation: {
      required: ['message_id'],
      type: 'object',
      properties: {
        message_id: {
          type: 'string',
          description: 'The ID of the message that was created by this run step.',
        },
      },
    },
  },
  description: 'Details of the message creation by the run step.',
} as const;

export const RunStepDeltaStepDetailsMessageCreationObjectSchema = {
  title: 'Message creation',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['message_creation'],
      type: 'string',
      description: 'Always `message_creation`.',
    },
    message_creation: {
      type: 'object',
      properties: {
        message_id: {
          type: 'string',
          description: 'The ID of the message that was created by this run step.',
        },
      },
    },
  },
  description: 'Details of the message creation by the run step.',
} as const;

export const RunStepDetailsToolCallsObjectSchema = {
  title: 'Tool calls',
  required: ['type', 'tool_calls'],
  type: 'object',
  properties: {
    type: {
      enum: ['tool_calls'],
      type: 'string',
      description: 'Always `tool_calls`.',
    },
    tool_calls: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/RunStepDetailsToolCallsCodeObject',
          },
          {
            $ref: '#/components/schemas/RunStepDetailsToolCallsFileSearchObject',
          },
          {
            $ref: '#/components/schemas/RunStepDetailsToolCallsFunctionObject',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: `An array of tool calls the run step was involved in. These can be associated with one of three types of tools: \`code_interpreter\`, \`file_search\`, or \`function\`.
`,
    },
  },
  description: 'Details of the tool call.',
} as const;

export const RunStepDeltaStepDetailsToolCallsObjectSchema = {
  title: 'Tool calls',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['tool_calls'],
      type: 'string',
      description: 'Always `tool_calls`.',
    },
    tool_calls: {
      type: 'array',
      items: {
        oneOf: [
          {
            $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsCodeObject',
          },
          {
            $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsFileSearchObject',
          },
          {
            $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsFunctionObject',
          },
        ],
        'x-oaiExpandable': true,
      },
      description: `An array of tool calls the run step was involved in. These can be associated with one of three types of tools: \`code_interpreter\`, \`file_search\`, or \`function\`.
`,
    },
  },
  description: 'Details of the tool call.',
} as const;

export const RunStepDetailsToolCallsCodeObjectSchema = {
  title: 'Code Interpreter tool call',
  required: ['id', 'type', 'code_interpreter'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The ID of the tool call.',
    },
    type: {
      enum: ['code_interpreter'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `code_interpreter` for this type of tool call.',
    },
    code_interpreter: {
      required: ['input', 'outputs'],
      type: 'object',
      properties: {
        input: {
          type: 'string',
          description: 'The input to the Code Interpreter tool call.',
        },
        outputs: {
          type: 'array',
          items: {
            type: 'object',
            oneOf: [
              {
                $ref: '#/components/schemas/RunStepDetailsToolCallsCodeOutputLogsObject',
              },
              {
                $ref: '#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject',
              },
            ],
            'x-oaiExpandable': true,
          },
          description:
            'The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.',
        },
      },
      description: 'The Code Interpreter tool call definition.',
    },
  },
  description: 'Details of the Code Interpreter tool call the run step was involved in.',
} as const;

export const RunStepDeltaStepDetailsToolCallsCodeObjectSchema = {
  title: 'Code interpreter tool call',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the tool call in the tool calls array.',
    },
    id: {
      type: 'string',
      description: 'The ID of the tool call.',
    },
    type: {
      enum: ['code_interpreter'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `code_interpreter` for this type of tool call.',
    },
    code_interpreter: {
      type: 'object',
      properties: {
        input: {
          type: 'string',
          description: 'The input to the Code Interpreter tool call.',
        },
        outputs: {
          type: 'array',
          items: {
            type: 'object',
            oneOf: [
              {
                $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject',
              },
              {
                $ref: '#/components/schemas/RunStepDeltaStepDetailsToolCallsCodeOutputImageObject',
              },
            ],
            'x-oaiExpandable': true,
          },
          description:
            'The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.',
        },
      },
      description: 'The Code Interpreter tool call definition.',
    },
  },
  description: 'Details of the Code Interpreter tool call the run step was involved in.',
} as const;

export const RunStepDetailsToolCallsCodeOutputLogsObjectSchema = {
  title: 'Code Interpreter log output',
  required: ['type', 'logs'],
  type: 'object',
  properties: {
    type: {
      enum: ['logs'],
      type: 'string',
      description: 'Always `logs`.',
    },
    logs: {
      type: 'string',
      description: 'The text output from the Code Interpreter tool call.',
    },
  },
  description: 'Text output from the Code Interpreter tool call as part of a run step.',
} as const;

export const RunStepDeltaStepDetailsToolCallsCodeOutputLogsObjectSchema = {
  title: 'Code interpreter log output',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the output in the outputs array.',
    },
    type: {
      enum: ['logs'],
      type: 'string',
      description: 'Always `logs`.',
    },
    logs: {
      type: 'string',
      description: 'The text output from the Code Interpreter tool call.',
    },
  },
  description: 'Text output from the Code Interpreter tool call as part of a run step.',
} as const;

export const RunStepDetailsToolCallsCodeOutputImageObjectSchema = {
  title: 'Code Interpreter image output',
  required: ['type', 'image'],
  type: 'object',
  properties: {
    type: {
      enum: ['image'],
      type: 'string',
      description: 'Always `image`.',
    },
    image: {
      required: ['file_id'],
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The [file](/docs/api-reference/files) ID of the image.',
        },
      },
    },
  },
} as const;

export const RunStepDeltaStepDetailsToolCallsCodeOutputImageObjectSchema = {
  title: 'Code interpreter image output',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the output in the outputs array.',
    },
    type: {
      enum: ['image'],
      type: 'string',
      description: 'Always `image`.',
    },
    image: {
      type: 'object',
      properties: {
        file_id: {
          type: 'string',
          description: 'The [file](/docs/api-reference/files) ID of the image.',
        },
      },
    },
  },
} as const;

export const RunStepDetailsToolCallsFileSearchObjectSchema = {
  title: 'File search tool call',
  required: ['id', 'type', 'file_search'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The ID of the tool call object.',
    },
    type: {
      enum: ['file_search'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `file_search` for this type of tool call.',
    },
    file_search: {
      type: 'object',
      description: 'For now, this is always going to be an empty object.',
      'x-oaiTypeLabel': 'map',
    },
  },
} as const;

export const RunStepDeltaStepDetailsToolCallsFileSearchObjectSchema = {
  title: 'File search tool call',
  required: ['index', 'type', 'file_search'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the tool call in the tool calls array.',
    },
    id: {
      type: 'string',
      description: 'The ID of the tool call object.',
    },
    type: {
      enum: ['file_search'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `file_search` for this type of tool call.',
    },
    file_search: {
      type: 'object',
      description: 'For now, this is always going to be an empty object.',
      'x-oaiTypeLabel': 'map',
    },
  },
} as const;

export const RunStepDetailsToolCallsFunctionObjectSchema = {
  title: 'Function tool call',
  required: ['id', 'type', 'function'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The ID of the tool call object.',
    },
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `function` for this type of tool call.',
    },
    function: {
      required: ['name', 'arguments', 'output'],
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function.',
        },
        arguments: {
          type: 'string',
          description: 'The arguments passed to the function.',
        },
        output: {
          type: 'string',
          description:
            'The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.',
          nullable: true,
        },
      },
      description: 'The definition of the function that was called.',
    },
  },
} as const;

export const RunStepDeltaStepDetailsToolCallsFunctionObjectSchema = {
  title: 'Function tool call',
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the tool call in the tool calls array.',
    },
    id: {
      type: 'string',
      description: 'The ID of the tool call object.',
    },
    type: {
      enum: ['function'],
      type: 'string',
      description: 'The type of tool call. This is always going to be `function` for this type of tool call.',
    },
    function: {
      type: 'object',
      properties: {
        name: {
          type: 'string',
          description: 'The name of the function.',
        },
        arguments: {
          type: 'string',
          description: 'The arguments passed to the function.',
        },
        output: {
          type: 'string',
          description:
            'The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.',
          nullable: true,
        },
      },
      description: 'The definition of the function that was called.',
    },
  },
} as const;

export const VectorStoreExpirationAfterSchema = {
  title: 'Vector store expiration policy',
  required: ['anchor', 'days'],
  type: 'object',
  properties: {
    anchor: {
      enum: ['last_active_at'],
      type: 'string',
      description: 'Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.',
    },
    days: {
      maximum: 365,
      minimum: 1,
      type: 'integer',
      description: 'The number of days after the anchor time that the vector store will expire.',
    },
  },
  description: 'The expiration policy for a vector store.',
} as const;

export const VectorStoreObjectSchema = {
  title: 'Vector store',
  required: [
    'id',
    'object',
    'usage_bytes',
    'created_at',
    'status',
    'last_active_at',
    'name',
    'file_counts',
    'metadata',
  ],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['vector_store'],
      type: 'string',
      description: 'The object type, which is always `vector_store`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the vector store was created.',
    },
    name: {
      type: 'string',
      description: 'The name of the vector store.',
    },
    usage_bytes: {
      type: 'integer',
      description: 'The total number of bytes used by the files in the vector store.',
    },
    file_counts: {
      required: ['in_progress', 'completed', 'failed', 'cancelled', 'total'],
      type: 'object',
      properties: {
        in_progress: {
          type: 'integer',
          description: 'The number of files that are currently being processed.',
        },
        completed: {
          type: 'integer',
          description: 'The number of files that have been successfully processed.',
        },
        failed: {
          type: 'integer',
          description: 'The number of files that have failed to process.',
        },
        cancelled: {
          type: 'integer',
          description: 'The number of files that were cancelled.',
        },
        total: {
          type: 'integer',
          description: 'The total number of files.',
        },
      },
    },
    status: {
      enum: ['expired', 'in_progress', 'completed'],
      type: 'string',
      description:
        'The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.',
    },
    expires_after: {
      $ref: '#/components/schemas/VectorStoreExpirationAfter',
    },
    expires_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the vector store will expire.',
      nullable: true,
    },
    last_active_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the vector store was last active.',
      nullable: true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  description: 'A vector store is a collection of processed files can be used by the `file_search` tool.',
  'x-oaiMeta': {
    name: 'The vector store object',
    beta: true,
    example: `{
  "id": "vs_123",
  "object": "vector_store",
  "created_at": 1698107661,
  "usage_bytes": 123456,
  "last_active_at": 1698107661,
  "name": "my_vector_store",
  "status": "completed",
  "file_counts": {
    "in_progress": 0,
    "completed": 100,
    "cancelled": 0,
    "failed": 0,
    "total": 100
  },
  "metadata": {},
  "last_used_at": 1698107661
}
`,
  },
} as const;

export const CreateVectorStoreRequestSchema = {
  type: 'object',
  properties: {
    file_ids: {
      maxItems: 500,
      type: 'array',
      items: {
        type: 'string',
      },
      description:
        'A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.',
    },
    name: {
      type: 'string',
      description: 'The name of the vector store.',
    },
    expires_after: {
      $ref: '#/components/schemas/VectorStoreExpirationAfter',
    },
    chunking_strategy: {
      type: 'object',
      oneOf: [
        {
          $ref: '#/components/schemas/AutoChunkingStrategyRequestParam',
        },
        {
          $ref: '#/components/schemas/StaticChunkingStrategyRequestParam',
        },
      ],
      description:
        'The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy. Only applicable if `file_ids` is non-empty.',
      'x-oaiExpandable': true,
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const UpdateVectorStoreRequestSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The name of the vector store.',
      nullable: true,
    },
    expires_after: {
      $ref: '#/components/schemas/VectorStoreExpirationAfter',
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  additionalProperties: false,
} as const;

export const ListVectorStoresResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/VectorStoreObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'vs_abc123',
    },
    last_id: {
      type: 'string',
      example: 'vs_abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const DeleteVectorStoreResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      enum: ['vector_store.deleted'],
      type: 'string',
    },
  },
} as const;

export const VectorStoreFileObjectSchema = {
  title: 'Vector store files',
  required: ['id', 'object', 'usage_bytes', 'created_at', 'vector_store_id', 'status', 'last_error'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['vector_store.file'],
      type: 'string',
      description: 'The object type, which is always `vector_store.file`.',
    },
    usage_bytes: {
      type: 'integer',
      description:
        'The total vector store usage in bytes. Note that this may be different from the original file size.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the vector store file was created.',
    },
    vector_store_id: {
      type: 'string',
      description:
        'The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.',
    },
    status: {
      enum: ['in_progress', 'completed', 'cancelled', 'failed'],
      type: 'string',
      description:
        'The status of the vector store file, which can be either `in_progress`, `completed`, `cancelled`, or `failed`. The status `completed` indicates that the vector store file is ready for use.',
    },
    last_error: {
      required: ['code', 'message'],
      type: 'object',
      properties: {
        code: {
          enum: ['server_error', 'unsupported_file', 'invalid_file'],
          type: 'string',
          description: 'One of `server_error` or `rate_limit_exceeded`.',
        },
        message: {
          type: 'string',
          description: 'A human-readable description of the error.',
        },
      },
      description: 'The last error associated with this vector store file. Will be `null` if there are no errors.',
      nullable: true,
    },
    chunking_strategy: {
      type: 'object',
      oneOf: [
        {
          $ref: '#/components/schemas/StaticChunkingStrategyResponseParam',
        },
        {
          $ref: '#/components/schemas/OtherChunkingStrategyResponseParam',
        },
      ],
      description: 'The strategy used to chunk the file.',
      'x-oaiExpandable': true,
    },
  },
  description: 'A list of files attached to a vector store.',
  'x-oaiMeta': {
    name: 'The vector store file object',
    beta: true,
    example: `{
  "id": "file-abc123",
  "object": "vector_store.file",
  "usage_bytes": 1234,
  "created_at": 1698107661,
  "vector_store_id": "vs_abc123",
  "status": "completed",
  "last_error": null,
  "chunking_strategy": {
    "type": "static",
    "static": {
      "max_chunk_size_tokens": 800,
      "chunk_overlap_tokens": 400
    }
  }
}
`,
  },
} as const;

export const OtherChunkingStrategyResponseParamSchema = {
  title: 'Other Chunking Strategy',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['other'],
      type: 'string',
      description: 'Always `other`.',
    },
  },
  additionalProperties: false,
  description:
    'This is returned when the chunking strategy is unknown. Typically, this is because the file was indexed before the `chunking_strategy` concept was introduced in the API.',
} as const;

export const StaticChunkingStrategyResponseParamSchema = {
  title: 'Static Chunking Strategy',
  required: ['type', 'static'],
  type: 'object',
  properties: {
    type: {
      enum: ['static'],
      type: 'string',
      description: 'Always `static`.',
    },
    static: {
      $ref: '#/components/schemas/StaticChunkingStrategy',
    },
  },
  additionalProperties: false,
} as const;

export const StaticChunkingStrategySchema = {
  required: ['max_chunk_size_tokens', 'chunk_overlap_tokens'],
  type: 'object',
  properties: {
    max_chunk_size_tokens: {
      maximum: 4096,
      minimum: 100,
      type: 'integer',
      description:
        'The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.',
    },
    chunk_overlap_tokens: {
      type: 'integer',
      description: `The number of tokens that overlap between chunks. The default value is \`400\`.

Note that the overlap must not exceed half of \`max_chunk_size_tokens\`.
`,
    },
  },
  additionalProperties: false,
} as const;

export const AutoChunkingStrategyRequestParamSchema = {
  title: 'Auto Chunking Strategy',
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      enum: ['auto'],
      type: 'string',
      description: 'Always `auto`.',
    },
  },
  additionalProperties: false,
  description:
    'The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.',
} as const;

export const StaticChunkingStrategyRequestParamSchema = {
  title: 'Static Chunking Strategy',
  required: ['type', 'static'],
  type: 'object',
  properties: {
    type: {
      enum: ['static'],
      type: 'string',
      description: 'Always `static`.',
    },
    static: {
      $ref: '#/components/schemas/StaticChunkingStrategy',
    },
  },
  additionalProperties: false,
} as const;

export const ChunkingStrategyRequestParamSchema = {
  type: 'object',
  oneOf: [
    {
      $ref: '#/components/schemas/AutoChunkingStrategyRequestParam',
    },
    {
      $ref: '#/components/schemas/StaticChunkingStrategyRequestParam',
    },
  ],
  description: 'The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
  'x-oaiExpandable': true,
} as const;

export const CreateVectorStoreFileRequestSchema = {
  required: ['file_id'],
  type: 'object',
  properties: {
    file_id: {
      type: 'string',
      description:
        'A [File](/docs/api-reference/files) ID that the vector store should use. Useful for tools like `file_search` that can access files.',
    },
    chunking_strategy: {
      $ref: '#/components/schemas/ChunkingStrategyRequestParam',
    },
  },
  additionalProperties: false,
} as const;

export const ListVectorStoreFilesResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  properties: {
    object: {
      type: 'string',
      example: 'list',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/VectorStoreFileObject',
      },
    },
    first_id: {
      type: 'string',
      example: 'file-abc123',
    },
    last_id: {
      type: 'string',
      example: 'file-abc456',
    },
    has_more: {
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const DeleteVectorStoreFileResponseSchema = {
  required: ['id', 'object', 'deleted'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
    object: {
      enum: ['vector_store.file.deleted'],
      type: 'string',
    },
  },
} as const;

export const VectorStoreFileBatchObjectSchema = {
  title: 'Vector store file batch',
  required: ['id', 'object', 'created_at', 'vector_store_id', 'status', 'file_counts'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints.',
    },
    object: {
      enum: ['vector_store.files_batch'],
      type: 'string',
      description: 'The object type, which is always `vector_store.file_batch`.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the vector store files batch was created.',
    },
    vector_store_id: {
      type: 'string',
      description:
        'The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.',
    },
    status: {
      enum: ['in_progress', 'completed', 'cancelled', 'failed'],
      type: 'string',
      description:
        'The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.',
    },
    file_counts: {
      required: ['in_progress', 'completed', 'cancelled', 'failed', 'total'],
      type: 'object',
      properties: {
        in_progress: {
          type: 'integer',
          description: 'The number of files that are currently being processed.',
        },
        completed: {
          type: 'integer',
          description: 'The number of files that have been processed.',
        },
        failed: {
          type: 'integer',
          description: 'The number of files that have failed to process.',
        },
        cancelled: {
          type: 'integer',
          description: 'The number of files that where cancelled.',
        },
        total: {
          type: 'integer',
          description: 'The total number of files.',
        },
      },
    },
  },
  description: 'A batch of files attached to a vector store.',
  'x-oaiMeta': {
    name: 'The vector store files batch object',
    beta: true,
    example: `{
  "id": "vsfb_123",
  "object": "vector_store.files_batch",
  "created_at": 1698107661,
  "vector_store_id": "vs_abc123",
  "status": "completed",
  "file_counts": {
    "in_progress": 0,
    "completed": 100,
    "failed": 0,
    "cancelled": 0,
    "total": 100
  }
}
`,
  },
} as const;

export const CreateVectorStoreFileBatchRequestSchema = {
  required: ['file_ids'],
  type: 'object',
  properties: {
    file_ids: {
      maxItems: 500,
      minItems: 1,
      type: 'array',
      items: {
        type: 'string',
      },
      description:
        'A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.',
    },
    chunking_strategy: {
      $ref: '#/components/schemas/ChunkingStrategyRequestParam',
    },
  },
  additionalProperties: false,
} as const;

export const AssistantStreamEventSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ThreadStreamEvent',
    },
    {
      $ref: '#/components/schemas/RunStreamEvent',
    },
    {
      $ref: '#/components/schemas/RunStepStreamEvent',
    },
    {
      $ref: '#/components/schemas/MessageStreamEvent',
    },
    {
      $ref: '#/components/schemas/ErrorEvent',
    },
    {
      $ref: '#/components/schemas/DoneEvent',
    },
  ],
  description: `Represents an event emitted when streaming a Run.

Each event in a server-sent events stream has an \`event\` and \`data\` property:

\`\`\`
event: thread.created
data: {"id": "thread_123", "object": "thread", ...}
\`\`\`

We emit events whenever a new object is created, transitions to a new state, or is being
streamed in parts (deltas). For example, we emit \`thread.run.created\` when a new run
is created, \`thread.run.completed\` when a run completes, and so on. When an Assistant chooses
to create a message during a run, we emit a \`thread.message.created event\`, a
\`thread.message.in_progress\` event, many \`thread.message.delta\` events, and finally a
\`thread.message.completed\` event.

We may add additional events over time, so we recommend handling unknown events gracefully
in your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to
integrate the Assistants API with streaming.
`,
  'x-oaiMeta': {
    name: 'Assistant stream events',
    beta: true,
  },
} as const;

export const ThreadStreamEventSchema = {
  oneOf: [
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.created'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/ThreadObject',
        },
      },
      description: 'Occurs when a new [thread](/docs/api-reference/threads/object) is created.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [thread](/docs/api-reference/threads/object)`,
      },
    },
  ],
} as const;

export const RunStreamEventSchema = {
  oneOf: [
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.created'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a new [run](/docs/api-reference/runs/object) is created.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.queued'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) moves to a `queued` status.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.in_progress'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) moves to an `in_progress` status.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.requires_action'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) moves to a `requires_action` status.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.completed'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) is completed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.incomplete'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) ends with status `incomplete`.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.failed'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) fails.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.cancelling'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) moves to a `cancelling` status.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.cancelled'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) is cancelled.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.expired'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunObject',
        },
      },
      description: 'Occurs when a [run](/docs/api-reference/runs/object) expires.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run](/docs/api-reference/runs/object)`,
      },
    },
  ],
} as const;

export const RunStepStreamEventSchema = {
  oneOf: [
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.created'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) is created.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.in_progress'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) moves to an `in_progress` state.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.delta'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepDeltaObject',
        },
      },
      description: 'Occurs when parts of a [run step](/docs/api-reference/runs/step-object) are being streamed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step delta](/docs/api-reference/assistants-streaming/run-step-delta-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.completed'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) is completed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.failed'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) fails.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.cancelled'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) is cancelled.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.run.step.expired'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/RunStepObject',
        },
      },
      description: 'Occurs when a [run step](/docs/api-reference/runs/step-object) expires.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [run step](/docs/api-reference/runs/step-object)`,
      },
    },
  ],
} as const;

export const MessageStreamEventSchema = {
  oneOf: [
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.message.created'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/MessageObject',
        },
      },
      description: 'Occurs when a [message](/docs/api-reference/messages/object) is created.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [message](/docs/api-reference/messages/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.message.in_progress'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/MessageObject',
        },
      },
      description: 'Occurs when a [message](/docs/api-reference/messages/object) moves to an `in_progress` state.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [message](/docs/api-reference/messages/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.message.delta'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/MessageDeltaObject',
        },
      },
      description: 'Occurs when parts of a [Message](/docs/api-reference/messages/object) are being streamed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [message delta](/docs/api-reference/assistants-streaming/message-delta-object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.message.completed'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/MessageObject',
        },
      },
      description: 'Occurs when a [message](/docs/api-reference/messages/object) is completed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [message](/docs/api-reference/messages/object)`,
      },
    },
    {
      required: ['event', 'data'],
      type: 'object',
      properties: {
        event: {
          enum: ['thread.message.incomplete'],
          type: 'string',
        },
        data: {
          $ref: '#/components/schemas/MessageObject',
        },
      },
      description: 'Occurs when a [message](/docs/api-reference/messages/object) ends before it is completed.',
      'x-oaiMeta': {
        dataDescription: `\`data\` is a [message](/docs/api-reference/messages/object)`,
      },
    },
  ],
} as const;

export const ErrorEventSchema = {
  required: ['event', 'data'],
  type: 'object',
  properties: {
    event: {
      enum: ['error'],
      type: 'string',
    },
    data: {
      $ref: '#/components/schemas/Error',
    },
  },
  description:
    'Occurs when an [error](/docs/guides/error-codes/api-errors) occurs. This can happen due to an internal server error or a timeout.',
  'x-oaiMeta': {
    dataDescription: `\`data\` is an [error](/docs/guides/error-codes/api-errors)`,
  },
} as const;

export const DoneEventSchema = {
  required: ['event', 'data'],
  type: 'object',
  properties: {
    event: {
      enum: ['done'],
      type: 'string',
    },
    data: {
      enum: ['[DONE]'],
      type: 'string',
    },
  },
  description: 'Occurs when a stream ends.',
  'x-oaiMeta': {
    dataDescription: `\`data\` is \`[DONE]\``,
  },
} as const;

export const BatchSchema = {
  required: ['id', 'object', 'endpoint', 'input_file_id', 'completion_window', 'status', 'created_at'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    object: {
      enum: ['batch'],
      type: 'string',
      description: 'The object type, which is always `batch`.',
    },
    endpoint: {
      type: 'string',
      description: 'The OpenAI API endpoint used by the batch.',
    },
    errors: {
      type: 'object',
      properties: {
        object: {
          type: 'string',
          description: 'The object type, which is always `list`.',
        },
        data: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              code: {
                type: 'string',
                description: 'An error code identifying the error type.',
              },
              message: {
                type: 'string',
                description: 'A human-readable message providing more details about the error.',
              },
              param: {
                type: 'string',
                description: 'The name of the parameter that caused the error, if applicable.',
                nullable: true,
              },
              line: {
                type: 'integer',
                description: 'The line number of the input file where the error occurred, if applicable.',
                nullable: true,
              },
            },
          },
        },
      },
    },
    input_file_id: {
      type: 'string',
      description: 'The ID of the input file for the batch.',
    },
    completion_window: {
      type: 'string',
      description: 'The time frame within which the batch should be processed.',
    },
    status: {
      enum: ['validating', 'failed', 'in_progress', 'finalizing', 'completed', 'expired', 'cancelling', 'cancelled'],
      type: 'string',
      description: 'The current status of the batch.',
    },
    output_file_id: {
      type: 'string',
      description: 'The ID of the file containing the outputs of successfully executed requests.',
    },
    error_file_id: {
      type: 'string',
      description: 'The ID of the file containing the outputs of requests with errors.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch was created.',
    },
    in_progress_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch started processing.',
    },
    expires_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch will expire.',
    },
    finalizing_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch started finalizing.',
    },
    completed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch was completed.',
    },
    failed_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch failed.',
    },
    expired_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch expired.',
    },
    cancelling_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch started cancelling.',
    },
    cancelled_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) for when the batch was cancelled.',
    },
    request_counts: {
      required: ['total', 'completed', 'failed'],
      type: 'object',
      properties: {
        total: {
          type: 'integer',
          description: 'Total number of requests in the batch.',
        },
        completed: {
          type: 'integer',
          description: 'Number of requests that have been completed successfully.',
        },
        failed: {
          type: 'integer',
          description: 'Number of requests that have failed.',
        },
      },
      description: 'The request counts for different statuses within the batch.',
    },
    metadata: {
      type: 'object',
      description: `Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
`,
      nullable: true,
      'x-oaiTypeLabel': 'map',
    },
  },
  'x-oaiMeta': {
    name: 'The batch object',
    example: `{
  "id": "batch_abc123",
  "object": "batch",
  "endpoint": "/v1/completions",
  "errors": null,
  "input_file_id": "file-abc123",
  "completion_window": "24h",
  "status": "completed",
  "output_file_id": "file-cvaTdG",
  "error_file_id": "file-HOWS94",
  "created_at": 1711471533,
  "in_progress_at": 1711471538,
  "expires_at": 1711557933,
  "finalizing_at": 1711493133,
  "completed_at": 1711493163,
  "failed_at": null,
  "expired_at": null,
  "cancelling_at": null,
  "cancelled_at": null,
  "request_counts": {
    "total": 100,
    "completed": 95,
    "failed": 5
  },
  "metadata": {
    "customer_id": "user_123456789",
    "batch_description": "Nightly eval job",
  }
}
`,
  },
} as const;

export const BatchRequestInputSchema = {
  type: 'object',
  properties: {
    custom_id: {
      type: 'string',
      description:
        'A developer-provided per-request id that will be used to match outputs to inputs. Must be unique for each request in a batch.',
    },
    method: {
      enum: ['POST'],
      type: 'string',
      description: 'The HTTP method to be used for the request. Currently only `POST` is supported.',
    },
    url: {
      type: 'string',
      description:
        'The OpenAI API relative URL to be used for the request. Currently `/v1/chat/completions`, `/v1/embeddings`, and `/v1/completions` are supported.',
    },
  },
  description: 'The per-line object of the batch input file',
  'x-oaiMeta': {
    name: 'The request input object',
    example: `{"custom_id": "request-1", "method": "POST", "url": "/v1/chat/completions", "body": {"model": "gpt-4o-mini", "messages": [{"role": "system", "content": "You are a helpful assistant."}, {"role": "user", "content": "What is 2+2?"}]}}
`,
  },
} as const;

export const BatchRequestOutputSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
    },
    custom_id: {
      type: 'string',
      description: 'A developer-provided per-request id that will be used to match outputs to inputs.',
    },
    response: {
      type: 'object',
      properties: {
        status_code: {
          type: 'integer',
          description: 'The HTTP status code of the response',
        },
        request_id: {
          type: 'string',
          description:
            'An unique identifier for the OpenAI API request. Please include this request ID when contacting support.',
        },
        body: {
          type: 'object',
          description: 'The JSON body of the response',
          'x-oaiTypeLabel': 'map',
        },
      },
      nullable: true,
    },
    error: {
      type: 'object',
      properties: {
        code: {
          type: 'string',
          description: 'A machine-readable error code.',
        },
        message: {
          type: 'string',
          description: 'A human-readable error message.',
        },
      },
      description:
        'For requests that failed with a non-HTTP error, this will contain more information on the cause of the failure.',
      nullable: true,
    },
  },
  description: 'The per-line object of the batch output and error files',
  'x-oaiMeta': {
    name: 'The request output object',
    example: `{"id": "batch_req_wnaDys", "custom_id": "request-2", "response": {"status_code": 200, "request_id": "req_c187b3", "body": {"id": "chatcmpl-9758Iw", "object": "chat.completion", "created": 1711475054, "model": "gpt-4o-mini", "choices": [{"index": 0, "message": {"role": "assistant", "content": "2 + 2 equals 4."}, "finish_reason": "stop"}], "usage": {"prompt_tokens": 24, "completion_tokens": 15, "total_tokens": 39}, "system_fingerprint": null}}, "error": null}
`,
  },
} as const;

export const ListBatchesResponseSchema = {
  required: ['object', 'data', 'has_more'],
  type: 'object',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Batch',
      },
    },
    first_id: {
      type: 'string',
      example: 'batch_abc123',
    },
    last_id: {
      type: 'string',
      example: 'batch_abc456',
    },
    has_more: {
      type: 'boolean',
    },
    object: {
      enum: ['list'],
      type: 'string',
    },
  },
} as const;

export const AuditLogActorServiceAccountSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The service account id.',
    },
  },
  description: 'The service account that performed the audit logged action.',
} as const;

export const AuditLogActorUserSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The user id.',
    },
    email: {
      type: 'string',
      description: 'The user email.',
    },
  },
  description: 'The user who performed the audit logged action.',
} as const;

export const AuditLogActorApiKeySchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The tracking id of the API key.',
    },
    type: {
      enum: ['user', 'service_account'],
      type: 'string',
      description: 'The type of API key. Can be either `user` or `service_account`.',
    },
    user: {
      $ref: '#/components/schemas/AuditLogActorUser',
    },
    service_account: {
      $ref: '#/components/schemas/AuditLogActorServiceAccount',
    },
  },
  description: 'The API Key used to perform the audit logged action.',
} as const;

export const AuditLogActorSessionSchema = {
  type: 'object',
  properties: {
    user: {
      $ref: '#/components/schemas/AuditLogActorUser',
    },
    ip_address: {
      type: 'string',
      description: 'The IP address from which the action was performed.',
    },
  },
  description: 'The session in which the audit logged action was performed.',
} as const;

export const AuditLogActorSchema = {
  type: 'object',
  properties: {
    type: {
      enum: ['session', 'api_key'],
      type: 'string',
      description: 'The type of actor. Is either `session` or `api_key`.',
    },
    session: {
      $ref: '#/components/schemas/AuditLogActorSession',
    },
    api_key: {
      $ref: '#/components/schemas/AuditLogActorApiKey',
    },
  },
  description: 'The actor who performed the audit logged action.',
} as const;

export const AuditLogEventTypeSchema = {
  enum: [
    'api_key.created',
    'api_key.updated',
    'api_key.deleted',
    'invite.sent',
    'invite.accepted',
    'invite.deleted',
    'login.succeeded',
    'login.failed',
    'logout.succeeded',
    'logout.failed',
    'organization.updated',
    'project.created',
    'project.updated',
    'project.archived',
    'service_account.created',
    'service_account.updated',
    'service_account.deleted',
    'user.added',
    'user.updated',
    'user.deleted',
  ],
  type: 'string',
  description: 'The event type.',
  'x-oaiExpandable': true,
} as const;

export const AuditLogSchema = {
  required: ['id', 'type', 'effective_at', 'actor'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The ID of this log.',
    },
    type: {
      $ref: '#/components/schemas/AuditLogEventType',
    },
    effective_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of the event.',
    },
    project: {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The project ID.',
        },
        name: {
          type: 'string',
          description: 'The project title.',
        },
      },
      description: 'The project that the action was scoped to. Absent for actions not scoped to projects.',
    },
    actor: {
      $ref: '#/components/schemas/AuditLogActor',
    },
    'api_key.created': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The tracking ID of the API key.',
        },
        data: {
          type: 'object',
          properties: {
            scopes: {
              type: 'array',
              items: {
                type: 'string',
              },
              description: 'A list of scopes allowed for the API key, e.g. `["api.model.request"]`',
            },
          },
          description: 'The payload used to create the API key.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'api_key.updated': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The tracking ID of the API key.',
        },
        changes_requested: {
          type: 'object',
          properties: {
            scopes: {
              type: 'array',
              items: {
                type: 'string',
              },
              description: 'A list of scopes allowed for the API key, e.g. `["api.model.request"]`',
            },
          },
          description: 'The payload used to update the API key.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'api_key.deleted': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The tracking ID of the API key.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'invite.sent': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The ID of the invite.',
        },
        data: {
          type: 'object',
          properties: {
            email: {
              type: 'string',
              description: 'The email invited to the organization.',
            },
            role: {
              type: 'string',
              description: 'The role the email was invited to be. Is either `owner` or `member`.',
            },
          },
          description: 'The payload used to create the invite.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'invite.accepted': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The ID of the invite.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'invite.deleted': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The ID of the invite.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'login.failed': {
      type: 'object',
      properties: {
        error_code: {
          type: 'string',
          description: 'The error code of the failure.',
        },
        error_message: {
          type: 'string',
          description: 'The error message of the failure.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'logout.failed': {
      type: 'object',
      properties: {
        error_code: {
          type: 'string',
          description: 'The error code of the failure.',
        },
        error_message: {
          type: 'string',
          description: 'The error message of the failure.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'organization.updated': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The organization ID.',
        },
        changes_requested: {
          type: 'object',
          properties: {
            title: {
              type: 'string',
              description: 'The organization title.',
            },
            description: {
              type: 'string',
              description: 'The organization description.',
            },
            name: {
              type: 'string',
              description: 'The organization name.',
            },
            settings: {
              type: 'object',
              properties: {
                threads_ui_visibility: {
                  type: 'string',
                  description:
                    'Visibility of the threads page which shows messages created with the Assistants API and Playground. One of `ANY_ROLE`, `OWNERS`, or `NONE`.',
                },
                usage_dashboard_visibility: {
                  type: 'string',
                  description:
                    'Visibility of the usage dashboard which shows activity and costs for your organization. One of `ANY_ROLE` or `OWNERS`.',
                },
              },
            },
          },
          description: 'The payload used to update the organization settings.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'project.created': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The project ID.',
        },
        data: {
          type: 'object',
          properties: {
            name: {
              type: 'string',
              description: 'The project name.',
            },
            title: {
              type: 'string',
              description: 'The title of the project as seen on the dashboard.',
            },
          },
          description: 'The payload used to create the project.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'project.updated': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The project ID.',
        },
        changes_requested: {
          type: 'object',
          properties: {
            title: {
              type: 'string',
              description: 'The title of the project as seen on the dashboard.',
            },
          },
          description: 'The payload used to update the project.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'project.archived': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The project ID.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'service_account.created': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The service account ID.',
        },
        data: {
          type: 'object',
          properties: {
            role: {
              type: 'string',
              description: 'The role of the service account. Is either `owner` or `member`.',
            },
          },
          description: 'The payload used to create the service account.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'service_account.updated': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The service account ID.',
        },
        changes_requested: {
          type: 'object',
          properties: {
            role: {
              type: 'string',
              description: 'The role of the service account. Is either `owner` or `member`.',
            },
          },
          description: 'The payload used to updated the service account.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'service_account.deleted': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The service account ID.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'user.added': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The user ID.',
        },
        data: {
          type: 'object',
          properties: {
            role: {
              type: 'string',
              description: 'The role of the user. Is either `owner` or `member`.',
            },
          },
          description: 'The payload used to add the user to the project.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'user.updated': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The project ID.',
        },
        changes_requested: {
          type: 'object',
          properties: {
            role: {
              type: 'string',
              description: 'The role of the user. Is either `owner` or `member`.',
            },
          },
          description: 'The payload used to update the user.',
        },
      },
      description: 'The details for events with this `type`.',
    },
    'user.deleted': {
      type: 'object',
      properties: {
        id: {
          type: 'string',
          description: 'The user ID.',
        },
      },
      description: 'The details for events with this `type`.',
    },
  },
  description: 'A log of a user action or configuration change within this organization.',
  'x-oaiMeta': {
    name: 'The audit log object',
    example: `{
    "id": "req_xxx_20240101",
    "type": "api_key.created",
    "effective_at": 1720804090,
    "actor": {
        "type": "session",
        "session": {
            "user": {
                "id": "user-xxx",
                "email": "user@example.com"
            },
            "ip_address": "127.0.0.1",
            "user_agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36"
        }
    },
    "api_key.created": {
        "id": "key_xxxx",
        "data": {
            "scopes": ["resource.operation"]
        }
    }
}
`,
  },
} as const;

export const ListAuditLogsResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AuditLog',
      },
    },
    first_id: {
      type: 'string',
      example: 'audit_log-defb456h8dks',
    },
    last_id: {
      type: 'string',
      example: 'audit_log-hnbkd8s93s',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const InviteSchema = {
  required: ['object', 'id', 'email', 'role', 'status', 'invited_at', 'expires_at'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.invite'],
      type: 'string',
      description: 'The object type, which is always `organization.invite`',
    },
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    email: {
      type: 'string',
      description: 'The email address of the individual to whom the invite was sent',
    },
    role: {
      enum: ['owner', 'reader'],
      type: 'string',
      description: `\`owner\` or \`reader\``,
    },
    status: {
      enum: ['accepted', 'expired', 'pending'],
      type: 'string',
      description: `\`accepted\`,\`expired\`, or \`pending\``,
    },
    invited_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the invite was sent.',
    },
    expires_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the invite expires.',
    },
    accepted_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the invite was accepted.',
    },
  },
  description: 'Represents an individual `invite` to the organization.',
  'x-oaiMeta': {
    name: 'The invite object',
    example: `{
  "object": "organization.invite",
  "id": "invite-abc",
  "email": "user@example.com",
  "role": "owner",
  "status": "accepted",
  "invited_at": 1711471533,
  "expires_at": 1711471533,
  "accepted_at": 1711471533
}
`,
  },
} as const;

export const InviteListResponseSchema = {
  required: ['object', 'data'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
      description: 'The object type, which is always `list`',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Invite',
      },
    },
    first_id: {
      type: 'string',
      description: 'The first `invite_id` in the retrieved `list`',
    },
    last_id: {
      type: 'string',
      description: 'The last `invite_id` in the retrieved `list`',
    },
    has_more: {
      type: 'boolean',
      description: 'The `has_more` property is used for pagination to indicate there are additional results.',
    },
  },
} as const;

export const InviteRequestSchema = {
  required: ['email', 'role'],
  type: 'object',
  properties: {
    email: {
      type: 'string',
      description: 'Send an email to this address',
    },
    role: {
      enum: ['reader', 'owner'],
      type: 'string',
      description: `\`owner\` or \`reader\``,
    },
  },
} as const;

export const InviteDeleteResponseSchema = {
  required: ['object', 'id', 'deleted'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.invite.deleted'],
      type: 'string',
      description: 'The object type, which is always `organization.invite.deleted`',
    },
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;

export const UserSchema = {
  required: ['object', 'id', 'name', 'email', 'role', 'added_at'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.user'],
      type: 'string',
      description: 'The object type, which is always `organization.user`',
    },
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    name: {
      type: 'string',
      description: 'The name of the user',
    },
    email: {
      type: 'string',
      description: 'The email address of the user',
    },
    role: {
      enum: ['owner', 'reader'],
      type: 'string',
      description: `\`owner\` or \`reader\``,
    },
    added_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the user was added.',
    },
  },
  description: 'Represents an individual `user` within an organization.',
  'x-oaiMeta': {
    name: 'The user object',
    example: `{
    "object": "organization.user",
    "id": "user_abc",
    "name": "First Last",
    "email": "user@example.com",
    "role": "owner",
    "added_at": 1711471533
}
`,
  },
} as const;

export const UserListResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/User',
      },
    },
    first_id: {
      type: 'string',
    },
    last_id: {
      type: 'string',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const UserRoleUpdateRequestSchema = {
  required: ['role'],
  type: 'object',
  properties: {
    role: {
      enum: ['owner', 'reader'],
      type: 'string',
      description: `\`owner\` or \`reader\``,
    },
  },
} as const;

export const UserDeleteResponseSchema = {
  required: ['object', 'id', 'deleted'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.user.deleted'],
      type: 'string',
    },
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectSchema = {
  required: ['id', 'object', 'name', 'created_at', 'status'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    object: {
      enum: ['organization.project'],
      type: 'string',
      description: 'The object type, which is always `organization.project`',
    },
    name: {
      type: 'string',
      description: 'The name of the project. This appears in reporting.',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the project was created.',
    },
    archived_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the project was archived or `null`.',
      nullable: true,
    },
    status: {
      enum: ['active', 'archived'],
      type: 'string',
      description: `\`active\` or \`archived\``,
    },
  },
  description: 'Represents an individual project.',
  'x-oaiMeta': {
    name: 'The project object',
    example: `{
    "id": "proj_abc",
    "object": "organization.project",
    "name": "Project example",
    "created_at": 1711471533,
    "archived_at": null,
    "status": "active"
}
`,
  },
} as const;

export const ProjectListResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Project',
      },
    },
    first_id: {
      type: 'string',
    },
    last_id: {
      type: 'string',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectCreateRequestSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The friendly name of the project, this name appears in reports.',
    },
  },
} as const;

export const ProjectUpdateRequestSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The updated name of the project, this name appears in reports.',
    },
  },
} as const;

export const DefaultProjectErrorResponseSchema = {
  required: ['code', 'message'],
  type: 'object',
  properties: {
    code: {
      type: 'integer',
    },
    message: {
      type: 'string',
    },
  },
} as const;

export const ProjectUserSchema = {
  required: ['object', 'id', 'name', 'email', 'role', 'added_at'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.user'],
      type: 'string',
      description: 'The object type, which is always `organization.project.user`',
    },
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    name: {
      type: 'string',
      description: 'The name of the user',
    },
    email: {
      type: 'string',
      description: 'The email address of the user',
    },
    role: {
      enum: ['owner', 'member'],
      type: 'string',
      description: `\`owner\` or \`member\``,
    },
    added_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the project was added.',
    },
  },
  description: 'Represents an individual user in a project.',
  'x-oaiMeta': {
    name: 'The project user object',
    example: `{
    "object": "organization.project.user",
    "id": "user_abc",
    "name": "First Last",
    "email": "user@example.com",
    "role": "owner",
    "added_at": 1711471533
}
`,
  },
} as const;

export const ProjectUserListResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProjectUser',
      },
    },
    first_id: {
      type: 'string',
    },
    last_id: {
      type: 'string',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectUserCreateRequestSchema = {
  required: ['user_id', 'role'],
  type: 'object',
  properties: {
    user_id: {
      type: 'string',
      description: 'The ID of the user.',
    },
    role: {
      enum: ['owner', 'member'],
      type: 'string',
      description: `\`owner\` or \`member\``,
    },
  },
} as const;

export const ProjectUserUpdateRequestSchema = {
  required: ['role'],
  type: 'object',
  properties: {
    role: {
      enum: ['owner', 'member'],
      type: 'string',
      description: `\`owner\` or \`member\``,
    },
  },
} as const;

export const ProjectUserDeleteResponseSchema = {
  required: ['object', 'id', 'deleted'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.user.deleted'],
      type: 'string',
    },
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectServiceAccountSchema = {
  required: ['object', 'id', 'name', 'role', 'created_at'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.service_account'],
      type: 'string',
      description: 'The object type, which is always `organization.project.service_account`',
    },
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    name: {
      type: 'string',
      description: 'The name of the service account',
    },
    role: {
      enum: ['owner', 'member'],
      type: 'string',
      description: `\`owner\` or \`member\``,
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the service account was created',
    },
  },
  description: 'Represents an individual service account in a project.',
  'x-oaiMeta': {
    name: 'The project service account object',
    example: `{
    "object": "organization.project.service_account",
    "id": "svc_acct_abc",
    "name": "Service Account",
    "role": "owner",
    "created_at": 1711471533
}
`,
  },
} as const;

export const ProjectServiceAccountListResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProjectServiceAccount',
      },
    },
    first_id: {
      type: 'string',
    },
    last_id: {
      type: 'string',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectServiceAccountCreateRequestSchema = {
  required: ['name'],
  type: 'object',
  properties: {
    name: {
      type: 'string',
      description: 'The name of the service account being created.',
    },
  },
} as const;

export const ProjectServiceAccountCreateResponseSchema = {
  required: ['object', 'id', 'name', 'role', 'created_at', 'api_key'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.service_account'],
      type: 'string',
    },
    id: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    role: {
      enum: ['member'],
      type: 'string',
      description: 'Service accounts can only have one role of type `member`',
    },
    created_at: {
      type: 'integer',
    },
    api_key: {
      $ref: '#/components/schemas/ProjectServiceAccountApiKey',
    },
  },
} as const;

export const ProjectServiceAccountApiKeySchema = {
  required: ['object', 'value', 'name', 'created_at', 'id'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.service_account.api_key'],
      type: 'string',
      description: 'The object type, which is always `organization.project.service_account.api_key`',
    },
    value: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    created_at: {
      type: 'integer',
    },
    id: {
      type: 'string',
    },
  },
} as const;

export const ProjectServiceAccountDeleteResponseSchema = {
  required: ['object', 'id', 'deleted'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.service_account.deleted'],
      type: 'string',
    },
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectApiKeySchema = {
  required: ['object', 'redacted_value', 'name', 'created_at', 'id', 'owner'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.api_key'],
      type: 'string',
      description: 'The object type, which is always `organization.project.api_key`',
    },
    redacted_value: {
      type: 'string',
      description: 'The redacted value of the API key',
    },
    name: {
      type: 'string',
      description: 'The name of the API key',
    },
    created_at: {
      type: 'integer',
      description: 'The Unix timestamp (in seconds) of when the API key was created',
    },
    id: {
      type: 'string',
      description: 'The identifier, which can be referenced in API endpoints',
    },
    owner: {
      type: 'object',
      properties: {
        type: {
          enum: ['user', 'service_account'],
          type: 'string',
          description: `\`user\` or \`service_account\``,
        },
        user: {
          $ref: '#/components/schemas/ProjectUser',
        },
        service_account: {
          $ref: '#/components/schemas/ProjectServiceAccount',
        },
      },
    },
  },
  description: 'Represents an individual API key in a project.',
  'x-oaiMeta': {
    name: 'The project API key object',
    example: `{
    "object": "organization.project.api_key",
    "redacted_value": "sk-abc...def",
    "name": "My API Key",
    "created_at": 1711471533,
    "id": "key_abc",
    "owner": {
        "type": "user",
        "user": {
            "object": "organization.project.user",
            "id": "user_abc",
            "name": "First Last",
            "email": "user@example.com",
            "role": "owner",
            "added_at": 1711471533
        }
    }
}
`,
  },
} as const;

export const ProjectApiKeyListResponseSchema = {
  required: ['object', 'data', 'first_id', 'last_id', 'has_more'],
  type: 'object',
  properties: {
    object: {
      enum: ['list'],
      type: 'string',
    },
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProjectApiKey',
      },
    },
    first_id: {
      type: 'string',
    },
    last_id: {
      type: 'string',
    },
    has_more: {
      type: 'boolean',
    },
  },
} as const;

export const ProjectApiKeyDeleteResponseSchema = {
  required: ['object', 'id', 'deleted'],
  type: 'object',
  properties: {
    object: {
      enum: ['organization.project.api_key.deleted'],
      type: 'string',
    },
    id: {
      type: 'string',
    },
    deleted: {
      type: 'boolean',
    },
  },
} as const;
