// Generated by ts-to-zod
import { z } from 'zod';

export const importSchema = z.object({
  authors_count: z.number().optional().nullable(),
  authors_url: z.string(),
  commit_count: z.number().optional().nullable(),
  error_message: z.string().optional().nullable(),
  failed_step: z.string().optional().nullable(),
  has_large_files: z.boolean().optional(),
  html_url: z.string(),
  import_percent: z.number().optional().nullable(),
  large_files_count: z.number().optional(),
  large_files_size: z.number().optional(),
  message: z.string().optional(),
  project_choices: z
    .array(
      z.object({
        human_name: z.string().optional(),
        tfvc_project: z.string().optional(),
        vcs: z.string().optional(),
      }),
    )
    .optional(),
  push_percent: z.number().optional().nullable(),
  repository_url: z.string(),
  status: z.union([
    z.literal('auth'),
    z.literal('error'),
    z.literal('none'),
    z.literal('detecting'),
    z.literal('choose'),
    z.literal('auth_failed'),
    z.literal('importing'),
    z.literal('mapping'),
    z.literal('waiting_to_push'),
    z.literal('pushing'),
    z.literal('complete'),
    z.literal('setup'),
    z.literal('unknown'),
    z.literal('detection_found_multiple'),
    z.literal('detection_found_nothing'),
    z.literal('detection_needs_auth'),
  ]),
  status_text: z.string().optional().nullable(),
  svc_root: z.string().optional(),
  svn_root: z.string().optional(),
  tfvc_project: z.string().optional(),
  url: z.string(),
  use_lfs: z.boolean().optional(),
  vcs: z.string().nullable(),
  vcs_url: z.string(),
});

export const statusSchema = z.union([
  z.literal('auth'),
  z.literal('error'),
  z.literal('none'),
  z.literal('detecting'),
  z.literal('choose'),
  z.literal('auth_failed'),
  z.literal('importing'),
  z.literal('mapping'),
  z.literal('waiting_to_push'),
  z.literal('pushing'),
  z.literal('complete'),
  z.literal('setup'),
  z.literal('unknown'),
  z.literal('detection_found_multiple'),
  z.literal('detection_found_nothing'),
  z.literal('detection_needs_auth'),
]);

export const nullableSimpleUserSchema = z
  .object({
    avatar_url: z.string(),
    email: z.string().optional().nullable(),
    events_url: z.string(),
    followers_url: z.string(),
    following_url: z.string(),
    gists_url: z.string(),
    gravatar_id: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    login: z.string(),
    name: z.string().optional().nullable(),
    node_id: z.string(),
    organizations_url: z.string(),
    received_events_url: z.string(),
    repos_url: z.string(),
    site_admin: z.boolean(),
    starred_at: z.string().optional(),
    starred_url: z.string(),
    subscriptions_url: z.string(),
    type: z.string(),
    url: z.string(),
  })
  .nullable();

export const packageTypeSchema = z.union([
  z.literal('npm'),
  z.literal('maven'),
  z.literal('rubygems'),
  z.literal('docker'),
  z.literal('nuget'),
  z.literal('container'),
]);

export const visibilitySchema = z.union([z.literal('private'), z.literal('public')]);

export const actionsBillingUsageSchema = z.object({
  included_minutes: z.number(),
  minutes_used_breakdown: z.object({
    MACOS: z.number().optional(),
    UBUNTU: z.number().optional(),
    WINDOWS: z.number().optional(),
    macos_12_core: z.number().optional(),
    total: z.number().optional(),
    ubuntu_16_core: z.number().optional(),
    ubuntu_32_core: z.number().optional(),
    ubuntu_4_core: z.number().optional(),
    ubuntu_64_core: z.number().optional(),
    ubuntu_8_core: z.number().optional(),
    windows_16_core: z.number().optional(),
    windows_32_core: z.number().optional(),
    windows_4_core: z.number().optional(),
    windows_64_core: z.number().optional(),
    windows_8_core: z.number().optional(),
  }),
  total_minutes_used: z.number(),
  total_paid_minutes_used: z.number(),
});

export const actionsCacheListSchema = z.object({
  actions_caches: z.array(
    z.object({
      created_at: z.string().optional(),
      id: z.number().optional(),
      key: z.string().optional(),
      last_accessed_at: z.string().optional(),
      ref: z.string().optional(),
      size_in_bytes: z.number().optional(),
      version: z.string().optional(),
    }),
  ),
  total_count: z.number(),
});

export const actionsCacheUsageByRepositorySchema = z.object({
  active_caches_count: z.number(),
  active_caches_size_in_bytes: z.number(),
  full_name: z.string(),
});

export const actionsCacheUsageOrgEnterpriseSchema = z.object({
  total_active_caches_count: z.number(),
  total_active_caches_size_in_bytes: z.number(),
});

export const actionsCanApprovePullRequestReviewsSchema = z.boolean();

export const actionsDefaultWorkflowPermissionsSchema = z.union([z.literal('read'), z.literal('write')]);

export const actionsEnabledSchema = z.boolean();

export const actionsGetDefaultWorkflowPermissionsSchema = z.object({
  can_approve_pull_request_reviews: actionsCanApprovePullRequestReviewsSchema,
  default_workflow_permissions: actionsDefaultWorkflowPermissionsSchema,
});

export const allowedActionsSchema = z.union([z.literal('all'), z.literal('local_only'), z.literal('selected')]);

export const enabledRepositoriesSchema = z.union([z.literal('all'), z.literal('none'), z.literal('selected')]);

export const selectedActionsUrlSchema = z.string();

export const actionsPublicKeySchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  key: z.string(),
  key_id: z.string(),
  title: z.string().optional(),
  url: z.string().optional(),
});

export const actionsRepositoryPermissionsSchema = z.object({
  allowed_actions: allowedActionsSchema.optional(),
  enabled: actionsEnabledSchema,
  selected_actions_url: selectedActionsUrlSchema.optional(),
});

export const actionsSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  updated_at: z.string(),
});

export const actionsSetDefaultWorkflowPermissionsSchema = z.object({
  can_approve_pull_request_reviews: actionsCanApprovePullRequestReviewsSchema.optional(),
  default_workflow_permissions: actionsDefaultWorkflowPermissionsSchema.optional(),
});

export const actionsVariableSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  updated_at: z.string(),
  value: z.string(),
});

export const actionsWorkflowAccessToRepositorySchema = z.object({
  access_level: z.union([z.literal('none'), z.literal('user'), z.literal('organization')]),
});

export const accessLevelSchema = z.union([z.literal('none'), z.literal('user'), z.literal('organization')]);

export const actorSchema = z.object({
  avatar_url: z.string(),
  display_login: z.string().optional(),
  gravatar_id: z.string().nullable(),
  id: z.number(),
  login: z.string(),
  url: z.string(),
});

export const simpleUserSchema = z.object({
  avatar_url: z.string(),
  email: z.string().optional().nullable(),
  events_url: z.string(),
  followers_url: z.string(),
  following_url: z.string(),
  gists_url: z.string(),
  gravatar_id: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  login: z.string(),
  name: z.string().optional().nullable(),
  node_id: z.string(),
  organizations_url: z.string(),
  received_events_url: z.string(),
  repos_url: z.string(),
  site_admin: z.boolean(),
  starred_at: z.string().optional(),
  starred_url: z.string(),
  subscriptions_url: z.string(),
  type: z.string(),
  url: z.string(),
});

export const nullableIntegrationSchema = z
  .object({
    client_id: z.string().optional(),
    client_secret: z.string().optional(),
    created_at: z.string(),
    description: z.string().nullable(),
    events: z.array(z.string()),
    external_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    installations_count: z.number().optional(),
    name: z.string(),
    node_id: z.string(),
    owner: nullableSimpleUserSchema,
    pem: z.string().optional(),
    permissions: z.record(z.union([z.string(), z.undefined()])).and(
      z.object({
        checks: z.string().optional(),
        contents: z.string().optional(),
        deployments: z.string().optional(),
        issues: z.string().optional(),
        metadata: z.string().optional(),
      }),
    ),
    slug: z.string().optional(),
    updated_at: z.string(),
    webhook_secret: z.string().optional().nullable(),
  })
  .nullable();

export const alertCreatedAtSchema = z.string();

export const alertDismissedAtSchema = z.string().nullable();

export const alertFixedAtSchema = z.string().nullable();

export const alertHtmlUrlSchema = z.string();

export const alertInstancesUrlSchema = z.string();

export const alertNumberSchema = z.number();

export const alertUpdatedAtSchema = z.string();

export const alertUrlSchema = z.string();

export const apiOverviewSchema = z.object({
  actions: z.array(z.string()).optional(),
  api: z.array(z.string()).optional(),
  dependabot: z.array(z.string()).optional(),
  git: z.array(z.string()).optional(),
  hooks: z.array(z.string()).optional(),
  importer: z.array(z.string()).optional(),
  packages: z.array(z.string()).optional(),
  pages: z.array(z.string()).optional(),
  ssh_key_fingerprints: z
    .object({
      SHA256_DSA: z.string().optional(),
      SHA256_ECDSA: z.string().optional(),
      SHA256_ED25519: z.string().optional(),
      SHA256_RSA: z.string().optional(),
    })
    .optional(),
  ssh_keys: z.array(z.string()).optional(),
  verifiable_password_authentication: z.boolean(),
  web: z.array(z.string()).optional(),
});

export const appPermissionsSchema = z.object({
  actions: z.union([z.literal('read'), z.literal('write')]).optional(),
  administration: z.union([z.literal('read'), z.literal('write')]).optional(),
  checks: z.union([z.literal('read'), z.literal('write')]).optional(),
  contents: z.union([z.literal('read'), z.literal('write')]).optional(),
  deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
  environments: z.union([z.literal('read'), z.literal('write')]).optional(),
  issues: z.union([z.literal('read'), z.literal('write')]).optional(),
  members: z.union([z.literal('read'), z.literal('write')]).optional(),
  metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_announcement_banners: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_custom_roles: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_plan: z.literal('read').optional(),
  organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
  organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
  organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
  packages: z.union([z.literal('read'), z.literal('write')]).optional(),
  pages: z.union([z.literal('read'), z.literal('write')]).optional(),
  pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
  repository_announcement_banners: z.union([z.literal('read'), z.literal('write')]).optional(),
  repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
  repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
  secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
  secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
  security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
  single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
  statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
  team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
  vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
  workflows: z.literal('write').optional(),
});

export const actionsSchema = z.union([z.literal('read'), z.literal('write')]);

export const administrationSchema = z.union([z.literal('read'), z.literal('write')]);

export const checksSchema = z.union([z.literal('read'), z.literal('write')]);

export const contentsSchema = z.union([z.literal('read'), z.literal('write')]);

export const deploymentsSchema = z.union([z.literal('read'), z.literal('write')]);

export const environmentsSchema = z.union([z.literal('read'), z.literal('write')]);

export const issuesSchema = z.union([z.literal('read'), z.literal('write')]);

export const membersSchema = z.union([z.literal('read'), z.literal('write')]);

export const metadataSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationAdministrationSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationAnnouncementBannersSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationCustomRolesSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationHooksSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationPackagesSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationPlanSchema = z.literal('read');

export const organizationProjectsSchema = z.union([z.literal('read'), z.literal('write'), z.literal('admin')]);

export const organizationSecretsSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationSelfHostedRunnersSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationUserBlockingSchema = z.union([z.literal('read'), z.literal('write')]);

export const packagesSchema = z.union([z.literal('read'), z.literal('write')]);

export const pagesSchema = z.union([z.literal('read'), z.literal('write')]);

export const pullRequestsSchema = z.union([z.literal('read'), z.literal('write')]);

export const repositoryAnnouncementBannersSchema = z.union([z.literal('read'), z.literal('write')]);

export const repositoryHooksSchema = z.union([z.literal('read'), z.literal('write')]);

export const repositoryProjectsSchema = z.union([z.literal('read'), z.literal('write'), z.literal('admin')]);

export const secretScanningAlertsSchema = z.union([z.literal('read'), z.literal('write')]);

export const secretsSchema = z.union([z.literal('read'), z.literal('write')]);

export const securityEventsSchema = z.union([z.literal('read'), z.literal('write')]);

export const singleFileSchema = z.union([z.literal('read'), z.literal('write')]);

export const statusesSchema = z.union([z.literal('read'), z.literal('write')]);

export const teamDiscussionsSchema = z.union([z.literal('read'), z.literal('write')]);

export const vulnerabilityAlertsSchema = z.union([z.literal('read'), z.literal('write')]);

export const workflowsSchema = z.literal('write');

export const artifactSchema = z.object({
  archive_download_url: z.string(),
  created_at: z.string().nullable(),
  expired: z.boolean(),
  expires_at: z.string().nullable(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  size_in_bytes: z.number(),
  updated_at: z.string().nullable(),
  url: z.string(),
  workflow_run: z
    .object({
      head_branch: z.string().optional(),
      head_repository_id: z.number().optional(),
      head_sha: z.string().optional(),
      id: z.number().optional(),
      repository_id: z.number().optional(),
    })
    .optional()
    .nullable(),
});

export const integrationSchema = z.object({
  client_id: z.string().optional(),
  client_secret: z.string().optional(),
  created_at: z.string(),
  description: z.string().nullable(),
  events: z.array(z.string()),
  external_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  installations_count: z.number().optional(),
  name: z.string(),
  node_id: z.string(),
  owner: nullableSimpleUserSchema,
  pem: z.string().optional(),
  permissions: z.record(z.union([z.string(), z.undefined()])).and(
    z.object({
      checks: z.string().optional(),
      contents: z.string().optional(),
      deployments: z.string().optional(),
      issues: z.string().optional(),
      metadata: z.string().optional(),
    }),
  ),
  slug: z.string().optional(),
  updated_at: z.string(),
  webhook_secret: z.string().optional().nullable(),
});

export const repositorySelectionSchema = z.union([z.literal('all'), z.literal('selected')]);

export const authorAssociationSchema = z.union([
  z.literal('COLLABORATOR'),
  z.literal('CONTRIBUTOR'),
  z.literal('FIRST_TIMER'),
  z.literal('FIRST_TIME_CONTRIBUTOR'),
  z.literal('MANNEQUIN'),
  z.literal('MEMBER'),
  z.literal('NONE'),
  z.literal('OWNER'),
]);

export const nullableScopedInstallationSchema = z
  .object({
    account: simpleUserSchema,
    has_multiple_single_files: z.boolean().optional(),
    permissions: appPermissionsSchema,
    repositories_url: z.string(),
    repository_selection: z.union([z.literal('all'), z.literal('selected')]),
    single_file_name: z.string().nullable(),
    single_file_paths: z.array(z.string()).optional(),
  })
  .nullable();

export const autoMergeSchema = z
  .object({
    commit_message: z.string(),
    commit_title: z.string(),
    enabled_by: simpleUserSchema,
    merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
  })
  .nullable();

export const mergeMethodSchema = z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]);

export const autolinkSchema = z.object({
  id: z.number(),
  is_alphanumeric: z.boolean(),
  key_prefix: z.string(),
  url_template: z.string(),
});

export const baseGistSchema = z.object({
  comments: z.number(),
  comments_url: z.string(),
  commits_url: z.string(),
  created_at: z.string(),
  description: z.string().nullable(),
  files: z.record(
    z.object({
      filename: z.string().optional(),
      language: z.string().optional(),
      raw_url: z.string().optional(),
      size: z.number().optional(),
      type: z.string().optional(),
    }),
  ),
  forks: z.array(z.unknown()).optional(),
  forks_url: z.string(),
  git_pull_url: z.string(),
  git_push_url: z.string(),
  history: z.array(z.unknown()).optional(),
  html_url: z.string(),
  id: z.string(),
  node_id: z.string(),
  owner: simpleUserSchema.optional(),
  public: z.boolean(),
  truncated: z.boolean().optional(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const basicErrorSchema = z.object({
  documentation_url: z.string().optional(),
  message: z.string().optional(),
  status: z.string().optional(),
  url: z.string().optional(),
});

export const blobSchema = z.object({
  content: z.string(),
  encoding: z.string(),
  highlighted_content: z.string().optional(),
  node_id: z.string(),
  sha: z.string(),
  size: z.number().nullable(),
  url: z.string(),
});

export const protectedBranchAdminEnforcedSchema = z.object({
  enabled: z.boolean(),
  url: z.string(),
});

export const protectedBranchRequiredStatusCheckSchema = z.object({
  checks: z.array(
    z.object({
      app_id: z.number().nullable(),
      context: z.string(),
    }),
  ),
  contexts: z.array(z.string()),
  contexts_url: z.string().optional(),
  enforcement_level: z.string().optional(),
  strict: z.boolean().optional(),
  url: z.string().optional(),
});

export const branchRestrictionPolicySchema = z.object({
  apps: z.array(
    z.object({
      created_at: z.string().optional(),
      description: z.string().optional(),
      events: z.array(z.string()).optional(),
      external_url: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          description: z.string().optional(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          hooks_url: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          issues_url: z.string().optional(),
          login: z.string().optional(),
          members_url: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          public_members_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      permissions: z
        .object({
          contents: z.string().optional(),
          issues: z.string().optional(),
          metadata: z.string().optional(),
          single_file: z.string().optional(),
        })
        .optional(),
      slug: z.string().optional(),
      updated_at: z.string().optional(),
    }),
  ),
  apps_url: z.string(),
  teams: z.array(
    z.object({
      description: z.string().optional().nullable(),
      html_url: z.string().optional(),
      id: z.number().optional(),
      members_url: z.string().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      parent: z.string().optional().nullable(),
      permission: z.string().optional(),
      privacy: z.string().optional(),
      repositories_url: z.string().optional(),
      slug: z.string().optional(),
      url: z.string().optional(),
    }),
  ),
  teams_url: z.string(),
  url: z.string(),
  users: z.array(
    z.object({
      avatar_url: z.string().optional(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number().optional(),
      login: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.string().optional(),
      url: z.string().optional(),
    }),
  ),
  users_url: z.string(),
});

export const branchShortSchema = z.object({
  commit: z.object({
    sha: z.string(),
    url: z.string(),
  }),
  name: z.string(),
  protected: z.boolean(),
});

export const checkAnnotationSchema = z.object({
  annotation_level: z.string().nullable(),
  blob_href: z.string(),
  end_column: z.number().nullable(),
  end_line: z.number(),
  message: z.string().nullable(),
  path: z.string(),
  raw_details: z.string().nullable(),
  start_column: z.number().nullable(),
  start_line: z.number(),
  title: z.string().nullable(),
});

export const deploymentSimpleSchema = z.object({
  created_at: z.string(),
  description: z.string().nullable(),
  environment: z.string(),
  id: z.number(),
  node_id: z.string(),
  original_environment: z.string().optional(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  production_environment: z.boolean().optional(),
  repository_url: z.string(),
  statuses_url: z.string(),
  task: z.string(),
  transient_environment: z.boolean().optional(),
  updated_at: z.string(),
  url: z.string(),
});

export const pullRequestMinimalSchema = z.object({
  base: z.object({
    ref: z.string(),
    repo: z.object({
      id: z.number(),
      name: z.string(),
      url: z.string(),
    }),
    sha: z.string(),
  }),
  head: z.object({
    ref: z.string(),
    repo: z.object({
      id: z.number(),
      name: z.string(),
      url: z.string(),
    }),
    sha: z.string(),
  }),
  id: z.number(),
  number: z.number(),
  url: z.string(),
});

export const conclusionSchema = z.union([
  z.literal('success'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('cancelled'),
  z.literal('skipped'),
  z.literal('timed_out'),
  z.literal('action_required'),
]);

export const status2Schema = z.union([z.literal('queued'), z.literal('in_progress'), z.literal('completed')]);

export const conclusion2Schema = z.union([
  z.literal('waiting'),
  z.literal('pending'),
  z.literal('startup_failure'),
  z.literal('stale'),
  z.literal('success'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('cancelled'),
  z.literal('skipped'),
  z.literal('timed_out'),
  z.literal('action_required'),
]);

export const status3Schema = z.union([
  z.literal('queued'),
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('pending'),
]);

export const simpleCommitSchema = z.object({
  author: z
    .object({
      email: z.string(),
      name: z.string(),
    })
    .nullable(),
  committer: z
    .object({
      email: z.string(),
      name: z.string(),
    })
    .nullable(),
  id: z.string(),
  message: z.string(),
  timestamp: z.string(),
  tree_id: z.string(),
});

export const conclusion3Schema = z.union([
  z.literal('success'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('cancelled'),
  z.literal('skipped'),
  z.literal('timed_out'),
  z.literal('action_required'),
  z.literal('startup_failure'),
  z.literal('stale'),
]);

export const trafficSchema = z.object({
  count: z.number(),
  timestamp: z.string(),
  uniques: z.number(),
});

export const codeFrequencyStatSchema = z.array(z.number());

export const codeOfConductSchema = z.object({
  body: z.string().optional(),
  html_url: z.string().nullable(),
  key: z.string(),
  name: z.string(),
  url: z.string(),
});

export const codeOfConductSimpleSchema = z.object({
  html_url: z.string().nullable(),
  key: z.string(),
  name: z.string(),
  url: z.string(),
});

export const codeScanningAlertDismissedCommentSchema = z.string().nullable();

export const codeScanningAlertDismissedReasonSchema = z.union([
  z.literal('false positive'),
  z.literal("won't fix"),
  z.literal('used in tests'),
]);

export const codeScanningAlertRuleSchema = z.object({
  description: z.string().optional(),
  full_description: z.string().optional(),
  help: z.string().optional().nullable(),
  help_uri: z.string().optional().nullable(),
  id: z.string().optional().nullable(),
  name: z.string().optional(),
  security_severity_level: z
    .union([z.literal('low'), z.literal('medium'), z.literal('high'), z.literal('critical')])
    .optional()
    .nullable(),
  severity: z
    .union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')])
    .optional()
    .nullable(),
  tags: z.array(z.string()).optional().nullable(),
});

export const codeScanningAlertStateSchema = z.union([
  z.literal('open'),
  z.literal('closed'),
  z.literal('dismissed'),
  z.literal('fixed'),
]);

export const codeScanningAlertClassificationSchema = z.union([
  z.literal('source'),
  z.literal('generated'),
  z.literal('test'),
  z.literal('library'),
]);

export const codeScanningAlertEnvironmentSchema = z.string();

export const codeScanningAnalysisAnalysisKeySchema = z.string();

export const codeScanningAnalysisCategorySchema = z.string();

export const codeScanningAlertLocationSchema = z.object({
  end_column: z.number().optional(),
  end_line: z.number().optional(),
  path: z.string().optional(),
  start_column: z.number().optional(),
  start_line: z.number().optional(),
});

export const codeScanningRefSchema = z.string();

export const codeScanningAlertInstanceSchema = z.object({
  analysis_key: codeScanningAnalysisAnalysisKeySchema.optional(),
  category: codeScanningAnalysisCategorySchema.optional(),
  classifications: z.array(codeScanningAlertClassificationSchema).optional(),
  commit_sha: z.string().optional(),
  environment: codeScanningAlertEnvironmentSchema.optional(),
  html_url: z.string().optional(),
  location: codeScanningAlertLocationSchema.optional(),
  message: z
    .object({
      text: z.string().optional(),
    })
    .optional(),
  ref: codeScanningRefSchema.optional(),
  state: codeScanningAlertStateSchema.optional(),
});

export const codeScanningAlertRuleSummarySchema = z.object({
  description: z.string().optional(),
  id: z.string().optional().nullable(),
  name: z.string().optional(),
  severity: z
    .union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')])
    .optional()
    .nullable(),
  tags: z.array(z.string()).optional().nullable(),
});

export const securitySeverityLevelSchema = z.union([
  z.literal('low'),
  z.literal('medium'),
  z.literal('high'),
  z.literal('critical'),
]);

export const severitySchema = z.union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')]);

export const codeScanningAlertSetStateSchema = z.union([z.literal('open'), z.literal('dismissed')]);

export const codeScanningAlertSeveritySchema = z.union([
  z.literal('critical'),
  z.literal('high'),
  z.literal('medium'),
  z.literal('low'),
  z.literal('warning'),
  z.literal('note'),
  z.literal('error'),
]);

export const codeScanningAnalysisCommitShaSchema = z.string();

export const codeScanningAnalysisCreatedAtSchema = z.string();

export const codeScanningAnalysisEnvironmentSchema = z.string();

export const codeScanningAnalysisSarifIdSchema = z.string();

export const codeScanningAnalysisUrlSchema = z.string();

export const codeScanningAnalysisDeletionSchema = z.object({
  confirm_delete_url: z.string().nullable(),
  next_analysis_url: z.string().nullable(),
});

export const codeScanningAnalysisSarifFileSchema = z.string();

export const codeScanningAnalysisToolGuidSchema = z.string().nullable();

export const codeScanningAnalysisToolNameSchema = z.string();

export const codeScanningAnalysisToolVersionSchema = z.string().nullable();

export const codeScanningCodeqlDatabaseSchema = z.object({
  content_type: z.string(),
  created_at: z.string(),
  id: z.number(),
  language: z.string(),
  name: z.string(),
  size: z.number(),
  updated_at: z.string(),
  uploader: simpleUserSchema,
  url: z.string(),
});

export const simpleRepositorySchema = z.object({
  archive_url: z.string(),
  assignees_url: z.string(),
  blobs_url: z.string(),
  branches_url: z.string(),
  collaborators_url: z.string(),
  comments_url: z.string(),
  commits_url: z.string(),
  compare_url: z.string(),
  contents_url: z.string(),
  contributors_url: z.string(),
  deployments_url: z.string(),
  description: z.string().nullable(),
  downloads_url: z.string(),
  events_url: z.string(),
  fork: z.boolean(),
  forks_url: z.string(),
  full_name: z.string(),
  git_commits_url: z.string(),
  git_refs_url: z.string(),
  git_tags_url: z.string(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  issue_comment_url: z.string(),
  issue_events_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  labels_url: z.string(),
  languages_url: z.string(),
  merges_url: z.string(),
  milestones_url: z.string(),
  name: z.string(),
  node_id: z.string(),
  notifications_url: z.string(),
  owner: simpleUserSchema,
  private: z.boolean(),
  pulls_url: z.string(),
  releases_url: z.string(),
  stargazers_url: z.string(),
  statuses_url: z.string(),
  subscribers_url: z.string(),
  subscription_url: z.string(),
  tags_url: z.string(),
  teams_url: z.string(),
  trees_url: z.string(),
  url: z.string(),
});

export const codeScanningAnalysisToolSchema = z.object({
  guid: codeScanningAnalysisToolGuidSchema.optional(),
  name: codeScanningAnalysisToolNameSchema.optional(),
  version: codeScanningAnalysisToolVersionSchema.optional(),
});

export const codeScanningSarifsReceiptSchema = z.object({
  id: codeScanningAnalysisSarifIdSchema.optional(),
  url: z.string().optional(),
});

export const codeScanningSarifsStatusSchema = z.object({
  analyses_url: z.string().optional().nullable(),
  errors: z.array(z.string()).optional().nullable(),
  processing_status: z.union([z.literal('pending'), z.literal('complete'), z.literal('failed')]).optional(),
});

export const processingStatusSchema = z.union([z.literal('pending'), z.literal('complete'), z.literal('failed')]);

export const searchResultTextMatchesSchema = z.array(
  z.object({
    fragment: z.string().optional(),
    matches: z
      .array(
        z.object({
          indices: z.array(z.number()).optional(),
          text: z.string().optional(),
        }),
      )
      .optional(),
    object_type: z.string().optional().nullable(),
    object_url: z.string().optional(),
    property: z.string().optional(),
  }),
);

export const codeownersErrorsSchema = z.object({
  errors: z.array(
    z.object({
      column: z.number(),
      kind: z.string(),
      line: z.number(),
      message: z.string(),
      path: z.string(),
      source: z.string().optional(),
      suggestion: z.string().optional().nullable(),
    }),
  ),
});

export const nullableCodespaceMachineSchema = z
  .object({
    cpus: z.number(),
    display_name: z.string(),
    memory_in_bytes: z.number(),
    name: z.string(),
    operating_system: z.string(),
    prebuild_availability: z.union([z.literal('none'), z.literal('ready'), z.literal('in_progress')]).nullable(),
    storage_in_bytes: z.number(),
  })
  .nullable();

export const locationSchema = z.union([
  z.literal('EastUs'),
  z.literal('SouthEastAsia'),
  z.literal('WestEurope'),
  z.literal('WestUs2'),
]);

export const stateSchema = z.union([
  z.literal('Unknown'),
  z.literal('Created'),
  z.literal('Queued'),
  z.literal('Provisioning'),
  z.literal('Available'),
  z.literal('Awaiting'),
  z.literal('Unavailable'),
  z.literal('Deleted'),
  z.literal('Moved'),
  z.literal('Shutdown'),
  z.literal('Archived'),
  z.literal('Starting'),
  z.literal('ShuttingDown'),
  z.literal('Failed'),
  z.literal('Exporting'),
  z.literal('Updating'),
  z.literal('Rebuilding'),
]);

export const codespaceExportDetailsSchema = z.object({
  branch: z.string().optional().nullable(),
  completed_at: z.string().optional().nullable(),
  export_url: z.string().optional(),
  html_url: z.string().optional().nullable(),
  id: z.string().optional(),
  sha: z.string().optional().nullable(),
  state: z.string().optional().nullable(),
});

export const codespaceMachineSchema = z.object({
  cpus: z.number(),
  display_name: z.string(),
  memory_in_bytes: z.number(),
  name: z.string(),
  operating_system: z.string(),
  prebuild_availability: z.union([z.literal('none'), z.literal('ready'), z.literal('in_progress')]).nullable(),
  storage_in_bytes: z.number(),
});

export const prebuildAvailabilitySchema = z.union([z.literal('none'), z.literal('ready'), z.literal('in_progress')]);

export const codespacesOrgSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  selected_repositories_url: z.string().optional(),
  updated_at: z.string(),
  visibility: z.union([z.literal('all'), z.literal('private'), z.literal('selected')]),
});

export const visibility2Schema = z.union([z.literal('all'), z.literal('private'), z.literal('selected')]);

export const codespacesPublicKeySchema = z.object({
  created_at: z.string().optional(),
  id: z.number().optional(),
  key: z.string(),
  key_id: z.string(),
  title: z.string().optional(),
  url: z.string().optional(),
});

export const codespacesSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  selected_repositories_url: z.string(),
  updated_at: z.string(),
  visibility: z.union([z.literal('all'), z.literal('private'), z.literal('selected')]),
});

export const codespacesUserPublicKeySchema = z.object({
  key: z.string(),
  key_id: z.string(),
});

export const collaboratorSchema = z.object({
  avatar_url: z.string(),
  email: z.string().optional().nullable(),
  events_url: z.string(),
  followers_url: z.string(),
  following_url: z.string(),
  gists_url: z.string(),
  gravatar_id: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  login: z.string(),
  name: z.string().optional().nullable(),
  node_id: z.string(),
  organizations_url: z.string(),
  permissions: z
    .object({
      admin: z.boolean(),
      maintain: z.boolean().optional(),
      pull: z.boolean(),
      push: z.boolean(),
      triage: z.boolean().optional(),
    })
    .optional(),
  received_events_url: z.string(),
  repos_url: z.string(),
  role_name: z.string(),
  site_admin: z.boolean(),
  starred_url: z.string(),
  subscriptions_url: z.string(),
  type: z.string(),
  url: z.string(),
});

export const combinedBillingUsageSchema = z.object({
  days_left_in_billing_cycle: z.number(),
  estimated_paid_storage_for_month: z.number(),
  estimated_storage_for_month: z.number(),
});

export const simpleCommitStatusSchema = z.object({
  avatar_url: z.string().nullable(),
  context: z.string(),
  created_at: z.string(),
  description: z.string().nullable(),
  id: z.number(),
  node_id: z.string(),
  required: z.boolean().optional().nullable(),
  state: z.string(),
  target_url: z.string().nullable(),
  updated_at: z.string(),
  url: z.string(),
});

export const nullableGitUserSchema = z
  .object({
    date: z.string().optional(),
    email: z.string().optional(),
    name: z.string().optional(),
  })
  .nullable();

export const verificationSchema = z.object({
  payload: z.string().nullable(),
  reason: z.string(),
  signature: z.string().nullable(),
  verified: z.boolean(),
});

export const diffEntrySchema = z.object({
  additions: z.number(),
  blob_url: z.string(),
  changes: z.number(),
  contents_url: z.string(),
  deletions: z.number(),
  filename: z.string(),
  patch: z.string().optional(),
  previous_filename: z.string().optional(),
  raw_url: z.string(),
  sha: z.string(),
  status: z.union([
    z.literal('added'),
    z.literal('removed'),
    z.literal('modified'),
    z.literal('renamed'),
    z.literal('copied'),
    z.literal('changed'),
    z.literal('unchanged'),
  ]),
});

export const commitActivitySchema = z.object({
  days: z.array(z.number()),
  total: z.number(),
  week: z.number(),
});

export const reactionRollupSchema = z.object({
  '+1': z.number(),
  '-1': z.number(),
  confused: z.number(),
  eyes: z.number(),
  heart: z.number(),
  hooray: z.number(),
  laugh: z.number(),
  rocket: z.number(),
  total_count: z.number(),
  url: z.string(),
});

export const commitSchema = z.object({
  author: nullableSimpleUserSchema,
  comments_url: z.string(),
  commit: z.object({
    author: nullableGitUserSchema,
    comment_count: z.number(),
    committer: nullableGitUserSchema,
    message: z.string(),
    tree: z.object({
      sha: z.string(),
      url: z.string(),
    }),
    url: z.string(),
    verification: verificationSchema.optional(),
  }),
  committer: nullableSimpleUserSchema,
  files: z.array(diffEntrySchema).optional(),
  html_url: z.string(),
  node_id: z.string(),
  parents: z.array(
    z.object({
      html_url: z.string().optional(),
      sha: z.string(),
      url: z.string(),
    }),
  ),
  sha: z.string(),
  stats: z
    .object({
      additions: z.number().optional(),
      deletions: z.number().optional(),
      total: z.number().optional(),
    })
    .optional(),
  url: z.string(),
});

export const status4Schema = z.union([
  z.literal('diverged'),
  z.literal('ahead'),
  z.literal('behind'),
  z.literal('identical'),
]);

export const nullableCodeOfConductSimpleSchema = z
  .object({
    html_url: z.string().nullable(),
    key: z.string(),
    name: z.string(),
    url: z.string(),
  })
  .nullable();

export const nullableCommunityHealthFileSchema = z
  .object({
    html_url: z.string(),
    url: z.string(),
  })
  .nullable();

export const nullableLicenseSimpleSchema = z
  .object({
    html_url: z.string().optional(),
    key: z.string(),
    name: z.string(),
    node_id: z.string(),
    spdx_id: z.string().nullable(),
    url: z.string().nullable(),
  })
  .nullable();

export const contentDirectorySchema = z.array(
  z.object({
    _links: z.object({
      git: z.string().nullable(),
      html: z.string().nullable(),
      self: z.string(),
    }),
    content: z.string().optional(),
    download_url: z.string().nullable(),
    git_url: z.string().nullable(),
    html_url: z.string().nullable(),
    name: z.string(),
    path: z.string(),
    sha: z.string(),
    size: z.number(),
    type: z.union([z.literal('dir'), z.literal('file'), z.literal('submodule'), z.literal('symlink')]),
    url: z.string(),
  }),
);

export const contentFileSchema = z.object({
  _links: z.object({
    git: z.string().nullable(),
    html: z.string().nullable(),
    self: z.string(),
  }),
  content: z.string(),
  download_url: z.string().nullable(),
  encoding: z.string(),
  git_url: z.string().nullable(),
  html_url: z.string().nullable(),
  name: z.string(),
  path: z.string(),
  sha: z.string(),
  size: z.number(),
  submodule_git_url: z.string().optional(),
  target: z.string().optional(),
  type: z.literal('file'),
  url: z.string(),
});

export const typeSchema = z.literal('file');

export const contentSubmoduleSchema = z.object({
  _links: z.object({
    git: z.string().nullable(),
    html: z.string().nullable(),
    self: z.string(),
  }),
  download_url: z.string().nullable(),
  git_url: z.string().nullable(),
  html_url: z.string().nullable(),
  name: z.string(),
  path: z.string(),
  sha: z.string(),
  size: z.number(),
  submodule_git_url: z.string(),
  type: z.literal('submodule'),
  url: z.string(),
});

export const type2Schema = z.literal('submodule');

export const contentSymlinkSchema = z.object({
  _links: z.object({
    git: z.string().nullable(),
    html: z.string().nullable(),
    self: z.string(),
  }),
  download_url: z.string().nullable(),
  git_url: z.string().nullable(),
  html_url: z.string().nullable(),
  name: z.string(),
  path: z.string(),
  sha: z.string(),
  size: z.number(),
  target: z.string(),
  type: z.literal('symlink'),
  url: z.string(),
});

export const type3Schema = z.literal('symlink');

export const contentTrafficSchema = z.object({
  count: z.number(),
  path: z.string(),
  title: z.string(),
  uniques: z.number(),
});

export const contentTreeSchema = z.object({
  _links: z.object({
    git: z.string().nullable(),
    html: z.string().nullable(),
    self: z.string(),
  }),
  download_url: z.string().nullable(),
  entries: z
    .array(
      z.object({
        _links: z.object({
          git: z.string().nullable(),
          html: z.string().nullable(),
          self: z.string(),
        }),
        content: z.string().optional(),
        download_url: z.string().nullable(),
        git_url: z.string().nullable(),
        html_url: z.string().nullable(),
        name: z.string(),
        path: z.string(),
        sha: z.string(),
        size: z.number(),
        type: z.string(),
        url: z.string(),
      }),
    )
    .optional(),
  git_url: z.string().nullable(),
  html_url: z.string().nullable(),
  name: z.string(),
  path: z.string(),
  sha: z.string(),
  size: z.number(),
  type: z.string(),
  url: z.string(),
});

export const contributorSchema = z.object({
  avatar_url: z.string().optional(),
  contributions: z.number(),
  email: z.string().optional(),
  events_url: z.string().optional(),
  followers_url: z.string().optional(),
  following_url: z.string().optional(),
  gists_url: z.string().optional(),
  gravatar_id: z.string().optional().nullable(),
  html_url: z.string().optional(),
  id: z.number().optional(),
  login: z.string().optional(),
  name: z.string().optional(),
  node_id: z.string().optional(),
  organizations_url: z.string().optional(),
  received_events_url: z.string().optional(),
  repos_url: z.string().optional(),
  site_admin: z.boolean().optional(),
  starred_url: z.string().optional(),
  subscriptions_url: z.string().optional(),
  type: z.string(),
  url: z.string().optional(),
});

export const contributorActivitySchema = z.object({
  author: nullableSimpleUserSchema,
  total: z.number(),
  weeks: z.array(
    z.object({
      a: z.number().optional(),
      c: z.number().optional(),
      d: z.number().optional(),
      w: z.number().optional(),
    }),
  ),
});

export const convertedNoteToIssueIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: integrationSchema,
  project_card: z
    .object({
      column_name: z.string(),
      id: z.number(),
      previous_column_name: z.string().optional(),
      project_id: z.number(),
      project_url: z.string(),
      url: z.string(),
    })
    .optional(),
  url: z.string(),
});

export const demilestonedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  milestone: z.object({
    title: z.string(),
  }),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const dependabotAlertPackageSchema = z.object({
  ecosystem: z.string(),
  name: z.string(),
});

export const dependabotAlertSecurityVulnerabilitySchema = z.object({
  first_patched_version: z
    .object({
      identifier: z.string(),
    })
    .nullable(),
  package: dependabotAlertPackageSchema,
  severity: z.union([z.literal('low'), z.literal('medium'), z.literal('high'), z.literal('critical')]),
  vulnerable_version_range: z.string(),
});

export const scopeSchema = z.union([z.literal('development'), z.literal('runtime')]);

export const dismissedReasonSchema = z.union([
  z.literal('fix_started'),
  z.literal('inaccurate'),
  z.literal('no_bandwidth'),
  z.literal('not_used'),
  z.literal('tolerable_risk'),
]);

export const state2Schema = z.union([z.literal('dismissed'), z.literal('fixed'), z.literal('open')]);

export const dependabotAlertSecurityAdvisorySchema = z.object({
  cve_id: z.string().nullable(),
  cvss: z.object({
    score: z.number(),
    vector_string: z.string().nullable(),
  }),
  cwes: z.array(
    z.object({
      cwe_id: z.string(),
      name: z.string(),
    }),
  ),
  description: z.string(),
  ghsa_id: z.string(),
  identifiers: z.array(
    z.object({
      type: z.union([z.literal('CVE'), z.literal('GHSA')]),
      value: z.string(),
    }),
  ),
  published_at: z.string(),
  references: z.array(
    z.object({
      url: z.string(),
    }),
  ),
  severity: z.union([z.literal('low'), z.literal('medium'), z.literal('high'), z.literal('critical')]),
  summary: z.string(),
  updated_at: z.string(),
  vulnerabilities: z.array(dependabotAlertSecurityVulnerabilitySchema),
  withdrawn_at: z.string().nullable(),
});

export const severity2Schema = z.union([
  z.literal('low'),
  z.literal('medium'),
  z.literal('high'),
  z.literal('critical'),
]);

export const dependabotAlertWithRepositorySchema = z.object({
  created_at: alertCreatedAtSchema,
  dependency: z.object({
    manifest_path: z.string().optional(),
    package: dependabotAlertPackageSchema.optional(),
    scope: z
      .union([z.literal('development'), z.literal('runtime')])
      .optional()
      .nullable(),
  }),
  dismissed_at: alertDismissedAtSchema,
  dismissed_by: nullableSimpleUserSchema,
  dismissed_comment: z.string().nullable(),
  dismissed_reason: z
    .union([
      z.literal('fix_started'),
      z.literal('inaccurate'),
      z.literal('no_bandwidth'),
      z.literal('not_used'),
      z.literal('tolerable_risk'),
    ])
    .nullable(),
  fixed_at: alertFixedAtSchema,
  html_url: alertHtmlUrlSchema,
  number: alertNumberSchema,
  repository: simpleRepositorySchema,
  security_advisory: dependabotAlertSecurityAdvisorySchema,
  security_vulnerability: dependabotAlertSecurityVulnerabilitySchema,
  state: z.union([z.literal('dismissed'), z.literal('fixed'), z.literal('open')]),
  updated_at: alertUpdatedAtSchema,
  url: alertUrlSchema,
});

export const dependabotPublicKeySchema = z.object({
  key: z.string(),
  key_id: z.string(),
});

export const dependabotSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  updated_at: z.string(),
});

export const dependencySchema = z.object({
  dependencies: z.array(z.string()).optional(),
  metadata: metadataSchema.optional(),
  package_url: z.string().optional(),
  relationship: z.union([z.literal('direct'), z.literal('indirect')]).optional(),
  scope: z.union([z.literal('runtime'), z.literal('development')]).optional(),
});

export const relationshipSchema = z.union([z.literal('direct'), z.literal('indirect')]);

export const dependencyGraphDiffSchema = z.array(
  z.object({
    change_type: z.union([z.literal('added'), z.literal('removed')]),
    ecosystem: z.string(),
    license: z.string().nullable(),
    manifest: z.string(),
    name: z.string(),
    package_url: z.string().nullable(),
    scope: z.union([z.literal('unknown'), z.literal('runtime'), z.literal('development')]),
    source_repository_url: z.string().nullable(),
    version: z.string(),
    vulnerabilities: z.array(
      z.object({
        advisory_ghsa_id: z.string(),
        advisory_summary: z.string(),
        advisory_url: z.string(),
        severity: z.string(),
      }),
    ),
  }),
);

export const deployKeySchema = z.object({
  added_by: z.string().optional().nullable(),
  created_at: z.string(),
  id: z.number(),
  key: z.string(),
  last_used: z.string().optional().nullable(),
  read_only: z.boolean(),
  title: z.string(),
  url: z.string(),
  verified: z.boolean(),
});

export const deploymentSchema = z.object({
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  description: z.string().nullable(),
  environment: z.string(),
  id: z.number(),
  node_id: z.string(),
  original_environment: z.string().optional(),
  payload: z.union([z.record(z.unknown()), z.string()]),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  production_environment: z.boolean().optional(),
  ref: z.string(),
  repository_url: z.string(),
  sha: z.string(),
  statuses_url: z.string(),
  task: z.string(),
  transient_environment: z.boolean().optional(),
  updated_at: z.string(),
  url: z.string(),
});

export const deploymentBranchPolicySchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
  node_id: z.string().optional(),
});

export const deploymentBranchPolicyNamePatternSchema = z.object({
  name: z.string(),
});

export const deploymentBranchPolicySettingsSchema = z
  .object({
    custom_branch_policies: z.boolean(),
    protected_branches: z.boolean(),
  })
  .nullable();

export const deploymentReviewerTypeSchema = z.union([z.literal('User'), z.literal('Team')]);

export const deploymentStatusSchema = z.object({
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  deployment_url: z.string(),
  description: z.string(),
  environment: z.string().optional(),
  environment_url: z.string().optional(),
  id: z.number(),
  log_url: z.string().optional(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  repository_url: z.string(),
  state: z.union([
    z.literal('error'),
    z.literal('failure'),
    z.literal('inactive'),
    z.literal('pending'),
    z.literal('success'),
    z.literal('queued'),
    z.literal('in_progress'),
  ]),
  target_url: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const state3Schema = z.union([
  z.literal('error'),
  z.literal('failure'),
  z.literal('inactive'),
  z.literal('pending'),
  z.literal('success'),
  z.literal('queued'),
  z.literal('in_progress'),
]);

export const status5Schema = z.union([
  z.literal('added'),
  z.literal('removed'),
  z.literal('modified'),
  z.literal('renamed'),
  z.literal('copied'),
  z.literal('changed'),
  z.literal('unchanged'),
]);

export const discussionSchema = z.object({
  active_lock_reason: z.string().nullable(),
  answer_chosen_at: z.string().nullable(),
  answer_chosen_by: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  answer_html_url: z.string().nullable(),
  author_association: z.union([
    z.literal('COLLABORATOR'),
    z.literal('CONTRIBUTOR'),
    z.literal('FIRST_TIMER'),
    z.literal('FIRST_TIME_CONTRIBUTOR'),
    z.literal('MANNEQUIN'),
    z.literal('MEMBER'),
    z.literal('NONE'),
    z.literal('OWNER'),
  ]),
  body: z.string(),
  category: z.object({
    created_at: z.string(),
    description: z.string(),
    emoji: z.string(),
    id: z.number(),
    is_answerable: z.boolean(),
    name: z.string(),
    node_id: z.string().optional(),
    repository_id: z.number(),
    slug: z.string(),
    updated_at: z.string(),
  }),
  comments: z.number(),
  created_at: z.string(),
  html_url: z.string(),
  id: z.number(),
  locked: z.boolean(),
  node_id: z.string(),
  number: z.number(),
  reactions: z
    .object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    })
    .optional(),
  repository_url: z.string(),
  state: z.union([z.literal('open'), z.literal('locked'), z.literal('converting'), z.literal('transferring')]),
  timeline_url: z.string().optional(),
  title: z.string(),
  updated_at: z.string(),
  user: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
});

export const type4Schema = z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]);

export const authorAssociation2Schema = z.union([
  z.literal('COLLABORATOR'),
  z.literal('CONTRIBUTOR'),
  z.literal('FIRST_TIMER'),
  z.literal('FIRST_TIME_CONTRIBUTOR'),
  z.literal('MANNEQUIN'),
  z.literal('MEMBER'),
  z.literal('NONE'),
  z.literal('OWNER'),
]);

export const state4Schema = z.union([
  z.literal('open'),
  z.literal('locked'),
  z.literal('converting'),
  z.literal('transferring'),
]);

export const emailSchema = z.object({
  email: z.string(),
  primary: z.boolean(),
  verified: z.boolean(),
  visibility: z.string().nullable(),
});

export const emptyObjectSchema = z.record(z.unknown());

export const enterpriseSchema = z.object({
  avatar_url: z.string(),
  created_at: z.string().nullable(),
  description: z.string().optional().nullable(),
  html_url: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  slug: z.string(),
  updated_at: z.string().nullable(),
  website_url: z.string().optional().nullable(),
});

export const waitTimerSchema = z.number();

export const environmentApprovalsSchema = z.object({
  comment: z.string(),
  environments: z.array(
    z.object({
      created_at: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      updated_at: z.string().optional(),
      url: z.string().optional(),
    }),
  ),
  state: z.union([z.literal('approved'), z.literal('rejected'), z.literal('pending')]),
  user: simpleUserSchema,
});

export const state5Schema = z.union([z.literal('approved'), z.literal('rejected'), z.literal('pending')]);

export const issueCommentSchema = z.object({
  author_association: authorAssociationSchema,
  body: z.string().optional(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  created_at: z.string(),
  html_url: z.string(),
  id: z.number(),
  issue_url: z.string(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  reactions: reactionRollupSchema.optional(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const linkWithTypeSchema = z.object({
  href: z.string(),
  type: z.string(),
});

export const fileCommitSchema = z.object({
  commit: z.object({
    author: z
      .object({
        date: z.string().optional(),
        email: z.string().optional(),
        name: z.string().optional(),
      })
      .optional(),
    committer: z
      .object({
        date: z.string().optional(),
        email: z.string().optional(),
        name: z.string().optional(),
      })
      .optional(),
    html_url: z.string().optional(),
    message: z.string().optional(),
    node_id: z.string().optional(),
    parents: z
      .array(
        z.object({
          html_url: z.string().optional(),
          sha: z.string().optional(),
          url: z.string().optional(),
        }),
      )
      .optional(),
    sha: z.string().optional(),
    tree: z
      .object({
        sha: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    url: z.string().optional(),
    verification: z
      .object({
        payload: z.string().optional().nullable(),
        reason: z.string().optional(),
        signature: z.string().optional().nullable(),
        verified: z.boolean().optional(),
      })
      .optional(),
  }),
  content: z
    .object({
      _links: z
        .object({
          git: z.string().optional(),
          html: z.string().optional(),
          self: z.string().optional(),
        })
        .optional(),
      download_url: z.string().optional(),
      git_url: z.string().optional(),
      html_url: z.string().optional(),
      name: z.string().optional(),
      path: z.string().optional(),
      sha: z.string().optional(),
      size: z.number().optional(),
      type: z.string().optional(),
      url: z.string().optional(),
    })
    .nullable(),
});

export const repositorySchema = z.object({
  allow_auto_merge: z.boolean().optional(),
  allow_forking: z.boolean().optional(),
  allow_merge_commit: z.boolean().optional(),
  allow_rebase_merge: z.boolean().optional(),
  allow_squash_merge: z.boolean().optional(),
  allow_update_branch: z.boolean().optional(),
  anonymous_access_enabled: z.boolean().optional(),
  archive_url: z.string(),
  archived: z.boolean(),
  assignees_url: z.string(),
  blobs_url: z.string(),
  branches_url: z.string(),
  clone_url: z.string(),
  collaborators_url: z.string(),
  comments_url: z.string(),
  commits_url: z.string(),
  compare_url: z.string(),
  contents_url: z.string(),
  contributors_url: z.string(),
  created_at: z.string().nullable(),
  default_branch: z.string(),
  delete_branch_on_merge: z.boolean().optional(),
  deployments_url: z.string(),
  description: z.string().nullable(),
  disabled: z.boolean(),
  downloads_url: z.string(),
  events_url: z.string(),
  fork: z.boolean(),
  forks: z.number(),
  forks_count: z.number(),
  forks_url: z.string(),
  full_name: z.string(),
  git_commits_url: z.string(),
  git_refs_url: z.string(),
  git_tags_url: z.string(),
  git_url: z.string(),
  has_discussions: z.boolean().optional(),
  has_downloads: z.boolean(),
  has_issues: z.boolean(),
  has_pages: z.boolean(),
  has_projects: z.boolean(),
  has_wiki: z.boolean(),
  homepage: z.string().nullable(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_template: z.boolean().optional(),
  issue_comment_url: z.string(),
  issue_events_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  labels_url: z.string(),
  language: z.string().nullable(),
  languages_url: z.string(),
  license: nullableLicenseSimpleSchema,
  master_branch: z.string().optional(),
  merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
  merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
  merges_url: z.string(),
  milestones_url: z.string(),
  mirror_url: z.string().nullable(),
  name: z.string(),
  network_count: z.number().optional(),
  node_id: z.string(),
  notifications_url: z.string(),
  open_issues: z.number(),
  open_issues_count: z.number(),
  organization: nullableSimpleUserSchema.optional(),
  owner: simpleUserSchema,
  permissions: z
    .object({
      admin: z.boolean(),
      maintain: z.boolean().optional(),
      pull: z.boolean(),
      push: z.boolean(),
      triage: z.boolean().optional(),
    })
    .optional(),
  private: z.boolean(),
  pulls_url: z.string(),
  pushed_at: z.string().nullable(),
  releases_url: z.string(),
  size: z.number(),
  squash_merge_commit_message: z
    .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
    .optional(),
  squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
  ssh_url: z.string(),
  stargazers_count: z.number(),
  stargazers_url: z.string(),
  starred_at: z.string().optional(),
  statuses_url: z.string(),
  subscribers_count: z.number().optional(),
  subscribers_url: z.string(),
  subscription_url: z.string(),
  svn_url: z.string(),
  tags_url: z.string(),
  teams_url: z.string(),
  temp_clone_token: z.string().optional(),
  template_repository: z
    .object({
      allow_auto_merge: z.boolean().optional(),
      allow_merge_commit: z.boolean().optional(),
      allow_rebase_merge: z.boolean().optional(),
      allow_squash_merge: z.boolean().optional(),
      allow_update_branch: z.boolean().optional(),
      archive_url: z.string().optional(),
      archived: z.boolean().optional(),
      assignees_url: z.string().optional(),
      blobs_url: z.string().optional(),
      branches_url: z.string().optional(),
      clone_url: z.string().optional(),
      collaborators_url: z.string().optional(),
      comments_url: z.string().optional(),
      commits_url: z.string().optional(),
      compare_url: z.string().optional(),
      contents_url: z.string().optional(),
      contributors_url: z.string().optional(),
      created_at: z.string().optional(),
      default_branch: z.string().optional(),
      delete_branch_on_merge: z.boolean().optional(),
      deployments_url: z.string().optional(),
      description: z.string().optional(),
      disabled: z.boolean().optional(),
      downloads_url: z.string().optional(),
      events_url: z.string().optional(),
      fork: z.boolean().optional(),
      forks_count: z.number().optional(),
      forks_url: z.string().optional(),
      full_name: z.string().optional(),
      git_commits_url: z.string().optional(),
      git_refs_url: z.string().optional(),
      git_tags_url: z.string().optional(),
      git_url: z.string().optional(),
      has_downloads: z.boolean().optional(),
      has_issues: z.boolean().optional(),
      has_pages: z.boolean().optional(),
      has_projects: z.boolean().optional(),
      has_wiki: z.boolean().optional(),
      homepage: z.string().optional(),
      hooks_url: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number().optional(),
      is_template: z.boolean().optional(),
      issue_comment_url: z.string().optional(),
      issue_events_url: z.string().optional(),
      issues_url: z.string().optional(),
      keys_url: z.string().optional(),
      labels_url: z.string().optional(),
      language: z.string().optional(),
      languages_url: z.string().optional(),
      merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
      merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
      merges_url: z.string().optional(),
      milestones_url: z.string().optional(),
      mirror_url: z.string().optional(),
      name: z.string().optional(),
      network_count: z.number().optional(),
      node_id: z.string().optional(),
      notifications_url: z.string().optional(),
      open_issues_count: z.number().optional(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          login: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      permissions: z
        .object({
          admin: z.boolean().optional(),
          maintain: z.boolean().optional(),
          pull: z.boolean().optional(),
          push: z.boolean().optional(),
          triage: z.boolean().optional(),
        })
        .optional(),
      private: z.boolean().optional(),
      pulls_url: z.string().optional(),
      pushed_at: z.string().optional(),
      releases_url: z.string().optional(),
      size: z.number().optional(),
      squash_merge_commit_message: z
        .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
        .optional(),
      squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
      ssh_url: z.string().optional(),
      stargazers_count: z.number().optional(),
      stargazers_url: z.string().optional(),
      statuses_url: z.string().optional(),
      subscribers_count: z.number().optional(),
      subscribers_url: z.string().optional(),
      subscription_url: z.string().optional(),
      svn_url: z.string().optional(),
      tags_url: z.string().optional(),
      teams_url: z.string().optional(),
      temp_clone_token: z.string().optional(),
      topics: z.array(z.string()).optional(),
      trees_url: z.string().optional(),
      updated_at: z.string().optional(),
      url: z.string().optional(),
      use_squash_pr_title_as_default: z.boolean().optional(),
      visibility: z.string().optional(),
      watchers_count: z.number().optional(),
    })
    .optional()
    .nullable(),
  topics: z.array(z.string()).optional(),
  trees_url: z.string(),
  updated_at: z.string().nullable(),
  url: z.string(),
  use_squash_pr_title_as_default: z.boolean().optional(),
  visibility: z.string().optional(),
  watchers: z.number(),
  watchers_count: z.number(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const securityAndAnalysisSchema = z
  .object({
    advanced_security: z
      .object({
        status: z.union([z.literal('enabled'), z.literal('disabled')]).optional(),
      })
      .optional(),
    secret_scanning: z
      .object({
        status: z.union([z.literal('enabled'), z.literal('disabled')]).optional(),
      })
      .optional(),
    secret_scanning_push_protection: z
      .object({
        status: z.union([z.literal('enabled'), z.literal('disabled')]).optional(),
      })
      .optional(),
  })
  .nullable();

export const nullableRepositorySchema = z
  .object({
    allow_auto_merge: z.boolean().optional(),
    allow_forking: z.boolean().optional(),
    allow_merge_commit: z.boolean().optional(),
    allow_rebase_merge: z.boolean().optional(),
    allow_squash_merge: z.boolean().optional(),
    allow_update_branch: z.boolean().optional(),
    anonymous_access_enabled: z.boolean().optional(),
    archive_url: z.string(),
    archived: z.boolean(),
    assignees_url: z.string(),
    blobs_url: z.string(),
    branches_url: z.string(),
    clone_url: z.string(),
    collaborators_url: z.string(),
    comments_url: z.string(),
    commits_url: z.string(),
    compare_url: z.string(),
    contents_url: z.string(),
    contributors_url: z.string(),
    created_at: z.string().nullable(),
    default_branch: z.string(),
    delete_branch_on_merge: z.boolean().optional(),
    deployments_url: z.string(),
    description: z.string().nullable(),
    disabled: z.boolean(),
    downloads_url: z.string(),
    events_url: z.string(),
    fork: z.boolean(),
    forks: z.number(),
    forks_count: z.number(),
    forks_url: z.string(),
    full_name: z.string(),
    git_commits_url: z.string(),
    git_refs_url: z.string(),
    git_tags_url: z.string(),
    git_url: z.string(),
    has_discussions: z.boolean().optional(),
    has_downloads: z.boolean(),
    has_issues: z.boolean(),
    has_pages: z.boolean(),
    has_projects: z.boolean(),
    has_wiki: z.boolean(),
    homepage: z.string().nullable(),
    hooks_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    is_template: z.boolean().optional(),
    issue_comment_url: z.string(),
    issue_events_url: z.string(),
    issues_url: z.string(),
    keys_url: z.string(),
    labels_url: z.string(),
    language: z.string().nullable(),
    languages_url: z.string(),
    license: nullableLicenseSimpleSchema,
    master_branch: z.string().optional(),
    merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
    merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
    merges_url: z.string(),
    milestones_url: z.string(),
    mirror_url: z.string().nullable(),
    name: z.string(),
    network_count: z.number().optional(),
    node_id: z.string(),
    notifications_url: z.string(),
    open_issues: z.number(),
    open_issues_count: z.number(),
    organization: nullableSimpleUserSchema.optional(),
    owner: simpleUserSchema,
    permissions: z
      .object({
        admin: z.boolean(),
        maintain: z.boolean().optional(),
        pull: z.boolean(),
        push: z.boolean(),
        triage: z.boolean().optional(),
      })
      .optional(),
    private: z.boolean(),
    pulls_url: z.string(),
    pushed_at: z.string().nullable(),
    releases_url: z.string(),
    size: z.number(),
    squash_merge_commit_message: z
      .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
      .optional(),
    squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
    ssh_url: z.string(),
    stargazers_count: z.number(),
    stargazers_url: z.string(),
    starred_at: z.string().optional(),
    statuses_url: z.string(),
    subscribers_count: z.number().optional(),
    subscribers_url: z.string(),
    subscription_url: z.string(),
    svn_url: z.string(),
    tags_url: z.string(),
    teams_url: z.string(),
    temp_clone_token: z.string().optional(),
    template_repository: z
      .object({
        allow_auto_merge: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string().optional(),
        archived: z.boolean().optional(),
        assignees_url: z.string().optional(),
        blobs_url: z.string().optional(),
        branches_url: z.string().optional(),
        clone_url: z.string().optional(),
        collaborators_url: z.string().optional(),
        comments_url: z.string().optional(),
        commits_url: z.string().optional(),
        compare_url: z.string().optional(),
        contents_url: z.string().optional(),
        contributors_url: z.string().optional(),
        created_at: z.string().optional(),
        default_branch: z.string().optional(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string().optional(),
        description: z.string().optional(),
        disabled: z.boolean().optional(),
        downloads_url: z.string().optional(),
        events_url: z.string().optional(),
        fork: z.boolean().optional(),
        forks_count: z.number().optional(),
        forks_url: z.string().optional(),
        full_name: z.string().optional(),
        git_commits_url: z.string().optional(),
        git_refs_url: z.string().optional(),
        git_tags_url: z.string().optional(),
        git_url: z.string().optional(),
        has_downloads: z.boolean().optional(),
        has_issues: z.boolean().optional(),
        has_pages: z.boolean().optional(),
        has_projects: z.boolean().optional(),
        has_wiki: z.boolean().optional(),
        homepage: z.string().optional(),
        hooks_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string().optional(),
        issue_events_url: z.string().optional(),
        issues_url: z.string().optional(),
        keys_url: z.string().optional(),
        labels_url: z.string().optional(),
        language: z.string().optional(),
        languages_url: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string().optional(),
        milestones_url: z.string().optional(),
        mirror_url: z.string().optional(),
        name: z.string().optional(),
        network_count: z.number().optional(),
        node_id: z.string().optional(),
        notifications_url: z.string().optional(),
        open_issues_count: z.number().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
        permissions: z
          .object({
            admin: z.boolean().optional(),
            maintain: z.boolean().optional(),
            pull: z.boolean().optional(),
            push: z.boolean().optional(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean().optional(),
        pulls_url: z.string().optional(),
        pushed_at: z.string().optional(),
        releases_url: z.string().optional(),
        size: z.number().optional(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string().optional(),
        stargazers_count: z.number().optional(),
        stargazers_url: z.string().optional(),
        statuses_url: z.string().optional(),
        subscribers_count: z.number().optional(),
        subscribers_url: z.string().optional(),
        subscription_url: z.string().optional(),
        svn_url: z.string().optional(),
        tags_url: z.string().optional(),
        teams_url: z.string().optional(),
        temp_clone_token: z.string().optional(),
        topics: z.array(z.string()).optional(),
        trees_url: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.string().optional(),
        watchers_count: z.number().optional(),
      })
      .optional()
      .nullable(),
    topics: z.array(z.string()).optional(),
    trees_url: z.string(),
    updated_at: z.string().nullable(),
    url: z.string(),
    use_squash_pr_title_as_default: z.boolean().optional(),
    visibility: z.string().optional(),
    watchers: z.number(),
    watchers_count: z.number(),
    web_commit_signoff_required: z.boolean().optional(),
  })
  .nullable();

export const mergeCommitMessageSchema = z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]);

export const mergeCommitTitleSchema = z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]);

export const squashMergeCommitMessageSchema = z.union([
  z.literal('PR_BODY'),
  z.literal('COMMIT_MESSAGES'),
  z.literal('BLANK'),
]);

export const squashMergeCommitTitleSchema = z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]);

export const gistCommentSchema = z.object({
  author_association: authorAssociationSchema,
  body: z.string(),
  created_at: z.string(),
  id: z.number(),
  node_id: z.string(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const gistCommitSchema = z.object({
  change_status: z.object({
    additions: z.number().optional(),
    deletions: z.number().optional(),
    total: z.number().optional(),
  }),
  committed_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
  version: z.string(),
});

export const gistHistorySchema = z.object({
  change_status: z
    .object({
      additions: z.number().optional(),
      deletions: z.number().optional(),
      total: z.number().optional(),
    })
    .optional(),
  committed_at: z.string().optional(),
  url: z.string().optional(),
  user: nullableSimpleUserSchema.optional(),
  version: z.string().optional(),
});

export const publicUserSchema = z.object({
  avatar_url: z.string(),
  bio: z.string().nullable(),
  blog: z.string().nullable(),
  collaborators: z.number().optional(),
  company: z.string().nullable(),
  created_at: z.string(),
  disk_usage: z.number().optional(),
  email: z.string().nullable(),
  events_url: z.string(),
  followers: z.number(),
  followers_url: z.string(),
  following: z.number(),
  following_url: z.string(),
  gists_url: z.string(),
  gravatar_id: z.string().nullable(),
  hireable: z.boolean().nullable(),
  html_url: z.string(),
  id: z.number(),
  location: z.string().nullable(),
  login: z.string(),
  name: z.string().nullable(),
  node_id: z.string(),
  organizations_url: z.string(),
  owned_private_repos: z.number().optional(),
  plan: z
    .object({
      collaborators: z.number(),
      name: z.string(),
      private_repos: z.number(),
      space: z.number(),
    })
    .optional(),
  private_gists: z.number().optional(),
  public_gists: z.number(),
  public_repos: z.number(),
  received_events_url: z.string(),
  repos_url: z.string(),
  site_admin: z.boolean(),
  starred_url: z.string(),
  subscriptions_url: z.string(),
  suspended_at: z.string().optional().nullable(),
  total_private_repos: z.number().optional(),
  twitter_username: z.string().optional().nullable(),
  type: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const gitCommitSchema = z.object({
  author: z.object({
    date: z.string(),
    email: z.string(),
    name: z.string(),
  }),
  committer: z.object({
    date: z.string(),
    email: z.string(),
    name: z.string(),
  }),
  html_url: z.string(),
  message: z.string(),
  node_id: z.string(),
  parents: z.array(
    z.object({
      html_url: z.string(),
      sha: z.string(),
      url: z.string(),
    }),
  ),
  sha: z.string(),
  tree: z.object({
    sha: z.string(),
    url: z.string(),
  }),
  url: z.string(),
  verification: z.object({
    payload: z.string().nullable(),
    reason: z.string(),
    signature: z.string().nullable(),
    verified: z.boolean(),
  }),
});

export const gitRefSchema = z.object({
  node_id: z.string(),
  object: z.object({
    sha: z.string(),
    type: z.string(),
    url: z.string(),
  }),
  ref: z.string(),
  url: z.string(),
});

export const gitTagSchema = z.object({
  message: z.string(),
  node_id: z.string(),
  object: z.object({
    sha: z.string(),
    type: z.string(),
    url: z.string(),
  }),
  sha: z.string(),
  tag: z.string(),
  tagger: z.object({
    date: z.string(),
    email: z.string(),
    name: z.string(),
  }),
  url: z.string(),
  verification: verificationSchema.optional(),
});

export const gitTreeSchema = z.object({
  sha: z.string(),
  tree: z.array(
    z.object({
      mode: z.string().optional(),
      path: z.string().optional(),
      sha: z.string().optional(),
      size: z.number().optional(),
      type: z.string().optional(),
      url: z.string().optional(),
    }),
  ),
  truncated: z.boolean(),
  url: z.string(),
});

export const gitignoreTemplateSchema = z.object({
  name: z.string(),
  source: z.string(),
});

export const gpgKeySchema = z.object({
  can_certify: z.boolean(),
  can_encrypt_comms: z.boolean(),
  can_encrypt_storage: z.boolean(),
  can_sign: z.boolean(),
  created_at: z.string(),
  emails: z.array(
    z.object({
      email: z.string().optional(),
      verified: z.boolean().optional(),
    }),
  ),
  expires_at: z.string().nullable(),
  id: z.number(),
  key_id: z.string(),
  name: z.string().optional().nullable(),
  primary_key_id: z.number().nullable(),
  public_key: z.string(),
  raw_key: z.string().nullable(),
  revoked: z.boolean(),
  subkeys: z.array(
    z.object({
      can_certify: z.boolean().optional(),
      can_encrypt_comms: z.boolean().optional(),
      can_encrypt_storage: z.boolean().optional(),
      can_sign: z.boolean().optional(),
      created_at: z.string().optional(),
      emails: z.array(z.unknown()).optional(),
      expires_at: z.string().optional().nullable(),
      id: z.number().optional(),
      key_id: z.string().optional(),
      primary_key_id: z.number().optional(),
      public_key: z.string().optional(),
      raw_key: z.string().optional().nullable(),
      revoked: z.boolean().optional(),
      subkeys: z.array(z.unknown()).optional(),
    }),
  ),
});

export const webhookConfigContentTypeSchema = z.string();

export const webhookConfigInsecureSslSchema = z.union([z.string(), z.number()]);

export const webhookConfigSecretSchema = z.string();

export const webhookConfigUrlSchema = z.string();

export const hookResponseSchema = z.object({
  code: z.number().nullable(),
  message: z.string().nullable(),
  status: z.string().nullable(),
});

export const hookDeliverySchema = z.object({
  action: z.string().nullable(),
  delivered_at: z.string(),
  duration: z.number(),
  event: z.string(),
  guid: z.string(),
  id: z.number(),
  installation_id: z.number().nullable(),
  redelivery: z.boolean(),
  repository_id: z.number().nullable(),
  request: z.object({
    headers: z.record(z.unknown()).nullable(),
    payload: z.record(z.unknown()).nullable(),
  }),
  response: z.object({
    headers: z.record(z.unknown()).nullable(),
    payload: z.record(z.unknown()).nullable(),
  }),
  status: z.string(),
  status_code: z.number(),
  url: z.string().optional(),
});

export const hookDeliveryItemSchema = z.object({
  action: z.string().nullable(),
  delivered_at: z.string(),
  duration: z.number(),
  event: z.string(),
  guid: z.string(),
  id: z.number(),
  installation_id: z.number().nullable(),
  redelivery: z.boolean(),
  repository_id: z.number().nullable(),
  status: z.string(),
  status_code: z.number(),
});

export const hovercardSchema = z.object({
  contexts: z.array(
    z.object({
      message: z.string(),
      octicon: z.string(),
    }),
  ),
});

export const installationSchema = z.object({
  access_tokens_url: z.string(),
  account: z.union([simpleUserSchema, enterpriseSchema]).nullable(),
  app_id: z.number(),
  app_slug: z.string(),
  contact_email: z.string().optional().nullable(),
  created_at: z.string(),
  events: z.array(z.string()),
  has_multiple_single_files: z.boolean().optional(),
  html_url: z.string(),
  id: z.number(),
  permissions: appPermissionsSchema,
  repositories_url: z.string(),
  repository_selection: z.union([z.literal('all'), z.literal('selected')]),
  single_file_name: z.string().nullable(),
  single_file_paths: z.array(z.string()).optional(),
  suspended_at: z.string().nullable(),
  suspended_by: nullableSimpleUserSchema,
  target_id: z.number(),
  target_type: z.string(),
  updated_at: z.string(),
});

export const installationTokenSchema = z.object({
  expires_at: z.string(),
  has_multiple_single_files: z.boolean().optional(),
  permissions: appPermissionsSchema.optional(),
  repositories: z.array(repositorySchema).optional(),
  repository_selection: z.union([z.literal('all'), z.literal('selected')]).optional(),
  single_file: z.string().optional(),
  single_file_paths: z.array(z.string()).optional(),
  token: z.string(),
});

export const interactionExpirySchema = z.union([
  z.literal('one_day'),
  z.literal('three_days'),
  z.literal('one_week'),
  z.literal('one_month'),
  z.literal('six_months'),
]);

export const interactionGroupSchema = z.union([
  z.literal('existing_users'),
  z.literal('contributors_only'),
  z.literal('collaborators_only'),
]);

export const interactionLimitSchema = z.object({
  expiry: interactionExpirySchema.optional(),
  limit: interactionGroupSchema,
});

export const interactionLimitResponseSchema = z.object({
  expires_at: z.string(),
  limit: interactionGroupSchema,
  origin: z.string(),
});

export const nullableMilestoneSchema = z
  .object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: nullableSimpleUserSchema,
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  })
  .nullable();

export const stateReasonSchema = z.union([z.literal('completed'), z.literal('reopened'), z.literal('not_planned')]);

export const issueEventDismissedReviewSchema = z.object({
  dismissal_commit_id: z.string().optional().nullable(),
  dismissal_message: z.string().nullable(),
  review_id: z.number(),
  state: z.string(),
});

export const nullableIssueSchema = z
  .object({
    active_lock_reason: z.string().optional().nullable(),
    assignee: nullableSimpleUserSchema,
    assignees: z.array(simpleUserSchema).optional().nullable(),
    author_association: authorAssociationSchema,
    body: z.string().optional().nullable(),
    body_html: z.string().optional(),
    body_text: z.string().optional(),
    closed_at: z.string().nullable(),
    closed_by: nullableSimpleUserSchema.optional(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z.array(
      z.union([
        z.string(),
        z.object({
          color: z.string().optional().nullable(),
          default: z.boolean().optional(),
          description: z.string().optional().nullable(),
          id: z.number().optional(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          url: z.string().optional(),
        }),
      ]),
    ),
    labels_url: z.string(),
    locked: z.boolean(),
    milestone: nullableMilestoneSchema,
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: nullableIntegrationSchema.optional(),
    pull_request: z
      .object({
        diff_url: z.string().nullable(),
        html_url: z.string().nullable(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().nullable(),
        url: z.string().nullable(),
      })
      .optional(),
    reactions: reactionRollupSchema.optional(),
    repository: repositorySchema.optional(),
    repository_url: z.string(),
    state: z.string(),
    state_reason: z
      .union([z.literal('completed'), z.literal('reopened'), z.literal('not_planned')])
      .optional()
      .nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: nullableSimpleUserSchema,
  })
  .nullable();

export const issueEventLabelSchema = z.object({
  color: z.string().nullable(),
  name: z.string().nullable(),
});

export const issueEventMilestoneSchema = z.object({
  title: z.string(),
});

export const issueEventProjectCardSchema = z.object({
  column_name: z.string(),
  id: z.number(),
  previous_column_name: z.string().optional(),
  project_id: z.number(),
  project_url: z.string(),
  url: z.string(),
});

export const issueEventRenameSchema = z.object({
  from: z.string(),
  to: z.string(),
});

export const labeledIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  label: z.object({
    color: z.string(),
    name: z.string(),
  }),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const unlabeledIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  label: z.object({
    color: z.string(),
    name: z.string(),
  }),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const assignedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  assignee: simpleUserSchema,
  assigner: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: integrationSchema,
  url: z.string(),
});

export const unassignedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  assignee: simpleUserSchema,
  assigner: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const milestonedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  milestone: z.object({
    title: z.string(),
  }),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const renamedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  rename: z.object({
    from: z.string(),
    to: z.string(),
  }),
  url: z.string(),
});

export const reviewDismissedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  dismissed_review: z.object({
    dismissal_commit_id: z.string().optional(),
    dismissal_message: z.string().nullable(),
    review_id: z.number(),
    state: z.string(),
  }),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const lockedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  lock_reason: z.string().nullable(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const addedToProjectIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  project_card: z
    .object({
      column_name: z.string(),
      id: z.number(),
      previous_column_name: z.string().optional(),
      project_id: z.number(),
      project_url: z.string(),
      url: z.string(),
    })
    .optional(),
  url: z.string(),
});

export const movedColumnInProjectIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  project_card: z
    .object({
      column_name: z.string(),
      id: z.number(),
      previous_column_name: z.string().optional(),
      project_id: z.number(),
      project_url: z.string(),
      url: z.string(),
    })
    .optional(),
  url: z.string(),
});

export const removedFromProjectIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  project_card: z
    .object({
      column_name: z.string(),
      id: z.number(),
      previous_column_name: z.string().optional(),
      project_id: z.number(),
      project_url: z.string(),
      url: z.string(),
    })
    .optional(),
  url: z.string(),
});

export const issueSearchResultItemSchema = z.object({
  active_lock_reason: z.string().optional().nullable(),
  assignee: nullableSimpleUserSchema,
  assignees: z.array(simpleUserSchema).optional().nullable(),
  author_association: authorAssociationSchema,
  body: z.string().optional(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  closed_at: z.string().nullable(),
  comments: z.number(),
  comments_url: z.string(),
  created_at: z.string(),
  draft: z.boolean().optional(),
  events_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  labels: z.array(
    z.object({
      color: z.string().optional(),
      default: z.boolean().optional(),
      description: z.string().optional().nullable(),
      id: z.number().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      url: z.string().optional(),
    }),
  ),
  labels_url: z.string(),
  locked: z.boolean(),
  milestone: nullableMilestoneSchema,
  node_id: z.string(),
  number: z.number(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  pull_request: z
    .object({
      diff_url: z.string().nullable(),
      html_url: z.string().nullable(),
      merged_at: z.string().optional().nullable(),
      patch_url: z.string().nullable(),
      url: z.string().nullable(),
    })
    .optional(),
  reactions: reactionRollupSchema.optional(),
  repository: repositorySchema.optional(),
  repository_url: z.string(),
  score: z.number(),
  state: z.string(),
  state_reason: z.string().optional().nullable(),
  text_matches: searchResultTextMatchesSchema.optional(),
  timeline_url: z.string().optional(),
  title: z.string(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const jobSchema = z.object({
  check_run_url: z.string(),
  completed_at: z.string().nullable(),
  conclusion: z
    .union([
      z.literal('success'),
      z.literal('failure'),
      z.literal('neutral'),
      z.literal('cancelled'),
      z.literal('skipped'),
      z.literal('timed_out'),
      z.literal('action_required'),
    ])
    .nullable(),
  head_branch: z.string().nullable(),
  head_sha: z.string(),
  html_url: z.string().nullable(),
  id: z.number(),
  labels: z.array(z.string()),
  name: z.string(),
  node_id: z.string(),
  run_attempt: z.number().optional(),
  run_id: z.number(),
  run_url: z.string(),
  runner_group_id: z.number().nullable(),
  runner_group_name: z.string().nullable(),
  runner_id: z.number().nullable(),
  runner_name: z.string().nullable(),
  started_at: z.string(),
  status: z.union([z.literal('queued'), z.literal('in_progress'), z.literal('completed')]),
  steps: z
    .array(
      z.object({
        completed_at: z.string().optional().nullable(),
        conclusion: z.string().nullable(),
        name: z.string(),
        number: z.number(),
        started_at: z.string().optional().nullable(),
        status: z.union([z.literal('queued'), z.literal('in_progress'), z.literal('completed')]),
      }),
    )
    .optional(),
  url: z.string(),
  workflow_name: z.string().nullable(),
});

export const keySchema = z.object({
  created_at: z.string(),
  id: z.number(),
  key: z.string(),
  read_only: z.boolean(),
  title: z.string(),
  url: z.string(),
  verified: z.boolean(),
});

export const keySimpleSchema = z.object({
  id: z.number(),
  key: z.string(),
});

export const labelSchema = z.object({
  color: z.string(),
  default: z.boolean(),
  description: z.string().nullable(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  url: z.string(),
});

export const labelSearchResultItemSchema = z.object({
  color: z.string(),
  default: z.boolean(),
  description: z.string().nullable(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  score: z.number(),
  text_matches: searchResultTextMatchesSchema.optional(),
  url: z.string(),
});

export const languageSchema = z.record(z.number());

export const licenseSchema = z.object({
  body: z.string(),
  conditions: z.array(z.string()),
  description: z.string(),
  featured: z.boolean(),
  html_url: z.string(),
  implementation: z.string(),
  key: z.string(),
  limitations: z.array(z.string()),
  name: z.string(),
  node_id: z.string(),
  permissions: z.array(z.string()),
  spdx_id: z.string().nullable(),
  url: z.string().nullable(),
});

export const licenseContentSchema = z.object({
  _links: z.object({
    git: z.string().nullable(),
    html: z.string().nullable(),
    self: z.string(),
  }),
  content: z.string(),
  download_url: z.string().nullable(),
  encoding: z.string(),
  git_url: z.string().nullable(),
  html_url: z.string().nullable(),
  license: nullableLicenseSimpleSchema,
  name: z.string(),
  path: z.string(),
  sha: z.string(),
  size: z.number(),
  type: z.string(),
  url: z.string(),
});

export const licenseSimpleSchema = z.object({
  html_url: z.string().optional(),
  key: z.string(),
  name: z.string(),
  node_id: z.string(),
  spdx_id: z.string().nullable(),
  url: z.string().nullable(),
});

export const linkSchema = z.object({
  href: z.string(),
});

export const manifestSchema = z.object({
  file: z
    .object({
      source_location: z.string().optional(),
    })
    .optional(),
  metadata: metadataSchema.optional(),
  name: z.string(),
  resolved: z.record(dependencySchema).optional(),
});

export const marketplaceAccountSchema = z.object({
  email: z.string().optional().nullable(),
  id: z.number(),
  login: z.string(),
  node_id: z.string().optional(),
  organization_billing_email: z.string().optional().nullable(),
  type: z.string(),
  url: z.string(),
});

export const marketplaceListingPlanSchema = z.object({
  accounts_url: z.string(),
  bullets: z.array(z.string()),
  description: z.string(),
  has_free_trial: z.boolean(),
  id: z.number(),
  monthly_price_in_cents: z.number(),
  name: z.string(),
  number: z.number(),
  price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
  state: z.string(),
  unit_name: z.string().nullable(),
  url: z.string(),
  yearly_price_in_cents: z.number(),
});

export const priceModelSchema = z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]);

export const marketplacePurchaseSchema = z.object({
  email: z.string().optional().nullable(),
  id: z.number(),
  login: z.string(),
  marketplace_pending_change: z
    .object({
      effective_date: z.string().optional(),
      id: z.number().optional(),
      is_installed: z.boolean().optional(),
      plan: marketplaceListingPlanSchema.optional(),
      unit_count: z.number().optional().nullable(),
    })
    .optional()
    .nullable(),
  marketplace_purchase: z.object({
    billing_cycle: z.string().optional(),
    free_trial_ends_on: z.string().optional().nullable(),
    is_installed: z.boolean().optional(),
    next_billing_date: z.string().optional().nullable(),
    on_free_trial: z.boolean().optional(),
    plan: marketplaceListingPlanSchema.optional(),
    unit_count: z.number().optional().nullable(),
    updated_at: z.string().optional(),
  }),
  organization_billing_email: z.string().optional(),
  type: z.string(),
  url: z.string(),
});

export const mergedUpstreamSchema = z.object({
  base_branch: z.string().optional(),
  merge_type: z.union([z.literal('merge'), z.literal('fast-forward'), z.literal('none')]).optional(),
  message: z.string().optional(),
});

export const mergeTypeSchema = z.union([z.literal('merge'), z.literal('fast-forward'), z.literal('none')]);

export const metadata2Schema = z.record(z.union([z.string(), z.number(), z.boolean()]).nullable());

export const migrationSchema = z.object({
  archive_url: z.string().optional(),
  created_at: z.string(),
  exclude: z.array(z.unknown()).optional(),
  exclude_attachments: z.boolean(),
  exclude_git_data: z.boolean(),
  exclude_metadata: z.boolean(),
  exclude_owner_projects: z.boolean(),
  exclude_releases: z.boolean(),
  guid: z.string(),
  id: z.number(),
  lock_repositories: z.boolean(),
  node_id: z.string(),
  org_metadata_only: z.boolean(),
  owner: nullableSimpleUserSchema,
  repositories: z.array(repositorySchema),
  state: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const milestoneSchema = z.object({
  closed_at: z.string().nullable(),
  closed_issues: z.number(),
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  description: z.string().nullable(),
  due_on: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  labels_url: z.string(),
  node_id: z.string(),
  number: z.number(),
  open_issues: z.number(),
  state: z.union([z.literal('open'), z.literal('closed')]),
  title: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const state6Schema = z.union([z.literal('open'), z.literal('closed')]);

export const minimalRepositorySchema = z.object({
  allow_forking: z.boolean().optional(),
  archive_url: z.string(),
  archived: z.boolean().optional(),
  assignees_url: z.string(),
  blobs_url: z.string(),
  branches_url: z.string(),
  clone_url: z.string().optional(),
  code_of_conduct: codeOfConductSchema.optional(),
  collaborators_url: z.string(),
  comments_url: z.string(),
  commits_url: z.string(),
  compare_url: z.string(),
  contents_url: z.string(),
  contributors_url: z.string(),
  created_at: z.string().optional().nullable(),
  default_branch: z.string().optional(),
  delete_branch_on_merge: z.boolean().optional(),
  deployments_url: z.string(),
  description: z.string().nullable(),
  disabled: z.boolean().optional(),
  downloads_url: z.string(),
  events_url: z.string(),
  fork: z.boolean(),
  forks: z.number().optional(),
  forks_count: z.number().optional(),
  forks_url: z.string(),
  full_name: z.string(),
  git_commits_url: z.string(),
  git_refs_url: z.string(),
  git_tags_url: z.string(),
  git_url: z.string().optional(),
  has_discussions: z.boolean().optional(),
  has_downloads: z.boolean().optional(),
  has_issues: z.boolean().optional(),
  has_pages: z.boolean().optional(),
  has_projects: z.boolean().optional(),
  has_wiki: z.boolean().optional(),
  homepage: z.string().optional().nullable(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_template: z.boolean().optional(),
  issue_comment_url: z.string(),
  issue_events_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  labels_url: z.string(),
  language: z.string().optional().nullable(),
  languages_url: z.string(),
  license: z
    .object({
      key: z.string().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      spdx_id: z.string().optional(),
      url: z.string().optional(),
    })
    .optional()
    .nullable(),
  merges_url: z.string(),
  milestones_url: z.string(),
  mirror_url: z.string().optional().nullable(),
  name: z.string(),
  network_count: z.number().optional(),
  node_id: z.string(),
  notifications_url: z.string(),
  open_issues: z.number().optional(),
  open_issues_count: z.number().optional(),
  owner: simpleUserSchema,
  permissions: z
    .object({
      admin: z.boolean().optional(),
      maintain: z.boolean().optional(),
      pull: z.boolean().optional(),
      push: z.boolean().optional(),
      triage: z.boolean().optional(),
    })
    .optional(),
  private: z.boolean(),
  pulls_url: z.string(),
  pushed_at: z.string().optional().nullable(),
  releases_url: z.string(),
  role_name: z.string().optional(),
  security_and_analysis: securityAndAnalysisSchema.optional(),
  size: z.number().optional(),
  ssh_url: z.string().optional(),
  stargazers_count: z.number().optional(),
  stargazers_url: z.string(),
  statuses_url: z.string(),
  subscribers_count: z.number().optional(),
  subscribers_url: z.string(),
  subscription_url: z.string(),
  svn_url: z.string().optional(),
  tags_url: z.string(),
  teams_url: z.string(),
  temp_clone_token: z.string().optional(),
  topics: z.array(z.string()).optional(),
  trees_url: z.string(),
  updated_at: z.string().optional().nullable(),
  url: z.string(),
  visibility: z.string().optional(),
  watchers: z.number().optional(),
  watchers_count: z.number().optional(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const nullableAlertUpdatedAtSchema = z.string().nullable();

export const nullableCollaboratorSchema = z
  .object({
    avatar_url: z.string(),
    email: z.string().optional().nullable(),
    events_url: z.string(),
    followers_url: z.string(),
    following_url: z.string(),
    gists_url: z.string(),
    gravatar_id: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    login: z.string(),
    name: z.string().optional().nullable(),
    node_id: z.string(),
    organizations_url: z.string(),
    permissions: z
      .object({
        admin: z.boolean(),
        maintain: z.boolean().optional(),
        pull: z.boolean(),
        push: z.boolean(),
        triage: z.boolean().optional(),
      })
      .optional(),
    received_events_url: z.string(),
    repos_url: z.string(),
    role_name: z.string(),
    site_admin: z.boolean(),
    starred_url: z.string(),
    subscriptions_url: z.string(),
    type: z.string(),
    url: z.string(),
  })
  .nullable();

export const nullableMinimalRepositorySchema = z
  .object({
    allow_forking: z.boolean().optional(),
    archive_url: z.string(),
    archived: z.boolean().optional(),
    assignees_url: z.string(),
    blobs_url: z.string(),
    branches_url: z.string(),
    clone_url: z.string().optional(),
    code_of_conduct: codeOfConductSchema.optional(),
    collaborators_url: z.string(),
    comments_url: z.string(),
    commits_url: z.string(),
    compare_url: z.string(),
    contents_url: z.string(),
    contributors_url: z.string(),
    created_at: z.string().optional().nullable(),
    default_branch: z.string().optional(),
    delete_branch_on_merge: z.boolean().optional(),
    deployments_url: z.string(),
    description: z.string().nullable(),
    disabled: z.boolean().optional(),
    downloads_url: z.string(),
    events_url: z.string(),
    fork: z.boolean(),
    forks: z.number().optional(),
    forks_count: z.number().optional(),
    forks_url: z.string(),
    full_name: z.string(),
    git_commits_url: z.string(),
    git_refs_url: z.string(),
    git_tags_url: z.string(),
    git_url: z.string().optional(),
    has_discussions: z.boolean().optional(),
    has_downloads: z.boolean().optional(),
    has_issues: z.boolean().optional(),
    has_pages: z.boolean().optional(),
    has_projects: z.boolean().optional(),
    has_wiki: z.boolean().optional(),
    homepage: z.string().optional().nullable(),
    hooks_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    is_template: z.boolean().optional(),
    issue_comment_url: z.string(),
    issue_events_url: z.string(),
    issues_url: z.string(),
    keys_url: z.string(),
    labels_url: z.string(),
    language: z.string().optional().nullable(),
    languages_url: z.string(),
    license: z
      .object({
        key: z.string().optional(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        spdx_id: z.string().optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    merges_url: z.string(),
    milestones_url: z.string(),
    mirror_url: z.string().optional().nullable(),
    name: z.string(),
    network_count: z.number().optional(),
    node_id: z.string(),
    notifications_url: z.string(),
    open_issues: z.number().optional(),
    open_issues_count: z.number().optional(),
    owner: simpleUserSchema,
    permissions: z
      .object({
        admin: z.boolean().optional(),
        maintain: z.boolean().optional(),
        pull: z.boolean().optional(),
        push: z.boolean().optional(),
        triage: z.boolean().optional(),
      })
      .optional(),
    private: z.boolean(),
    pulls_url: z.string(),
    pushed_at: z.string().optional().nullable(),
    releases_url: z.string(),
    role_name: z.string().optional(),
    security_and_analysis: securityAndAnalysisSchema.optional(),
    size: z.number().optional(),
    ssh_url: z.string().optional(),
    stargazers_count: z.number().optional(),
    stargazers_url: z.string(),
    statuses_url: z.string(),
    subscribers_count: z.number().optional(),
    subscribers_url: z.string(),
    subscription_url: z.string(),
    svn_url: z.string().optional(),
    tags_url: z.string(),
    teams_url: z.string(),
    temp_clone_token: z.string().optional(),
    topics: z.array(z.string()).optional(),
    trees_url: z.string(),
    updated_at: z.string().optional().nullable(),
    url: z.string(),
    visibility: z.string().optional(),
    watchers: z.number().optional(),
    watchers_count: z.number().optional(),
    web_commit_signoff_required: z.boolean().optional(),
  })
  .nullable();

export const nullableSimpleCommitSchema = z
  .object({
    author: z
      .object({
        email: z.string(),
        name: z.string(),
      })
      .nullable(),
    committer: z
      .object({
        email: z.string(),
        name: z.string(),
      })
      .nullable(),
    id: z.string(),
    message: z.string(),
    timestamp: z.string(),
    tree_id: z.string(),
  })
  .nullable();

export const nullableTeamSimpleSchema = z
  .object({
    description: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    ldap_dn: z.string().optional(),
    members_url: z.string(),
    name: z.string(),
    node_id: z.string(),
    permission: z.string(),
    privacy: z.string().optional(),
    repositories_url: z.string(),
    slug: z.string(),
    url: z.string(),
  })
  .nullable();

export const oidcCustomSubSchema = z.object({
  include_claim_keys: z.array(z.string()),
});

export const oidcCustomSubRepoSchema = z.object({
  include_claim_keys: z.array(z.string()).optional(),
  use_default: z.boolean(),
});

export const orgHookSchema = z.object({
  active: z.boolean(),
  config: z.object({
    content_type: z.string().optional(),
    insecure_ssl: z.string().optional(),
    secret: z.string().optional(),
    url: z.string().optional(),
  }),
  created_at: z.string(),
  deliveries_url: z.string().optional(),
  events: z.array(z.string()),
  id: z.number(),
  name: z.string(),
  ping_url: z.string(),
  type: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const organizationSimpleSchema = z.object({
  avatar_url: z.string(),
  description: z.string().nullable(),
  events_url: z.string(),
  hooks_url: z.string(),
  id: z.number(),
  issues_url: z.string(),
  login: z.string(),
  members_url: z.string(),
  node_id: z.string(),
  public_members_url: z.string(),
  repos_url: z.string(),
  url: z.string(),
});

export const roleSchema = z.union([z.literal('admin'), z.literal('member'), z.literal('billing_manager')]);

export const state7Schema = z.union([z.literal('active'), z.literal('pending')]);

export const organizationActionsSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  selected_repositories_url: z.string().optional(),
  updated_at: z.string(),
  visibility: z.union([z.literal('all'), z.literal('private'), z.literal('selected')]),
});

export const organizationActionsVariableSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  selected_repositories_url: z.string().optional(),
  updated_at: z.string(),
  value: z.string(),
  visibility: z.union([z.literal('all'), z.literal('private'), z.literal('selected')]),
});

export const organizationDependabotSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  selected_repositories_url: z.string().optional(),
  updated_at: z.string(),
  visibility: z.union([z.literal('all'), z.literal('private'), z.literal('selected')]),
});

export const organizationFullSchema = z.object({
  advanced_security_enabled_for_new_repositories: z.boolean().optional(),
  avatar_url: z.string(),
  billing_email: z.string().optional().nullable(),
  blog: z.string().optional(),
  collaborators: z.number().optional().nullable(),
  company: z.string().optional(),
  created_at: z.string(),
  default_repository_permission: z.string().optional().nullable(),
  dependabot_alerts_enabled_for_new_repositories: z.boolean().optional(),
  dependabot_security_updates_enabled_for_new_repositories: z.boolean().optional(),
  dependency_graph_enabled_for_new_repositories: z.boolean().optional(),
  description: z.string().nullable(),
  disk_usage: z.number().optional().nullable(),
  email: z.string().optional(),
  events_url: z.string(),
  followers: z.number(),
  following: z.number(),
  has_organization_projects: z.boolean(),
  has_repository_projects: z.boolean(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_verified: z.boolean().optional(),
  issues_url: z.string(),
  location: z.string().optional(),
  login: z.string(),
  members_allowed_repository_creation_type: z.string().optional(),
  members_can_create_internal_repositories: z.boolean().optional(),
  members_can_create_pages: z.boolean().optional(),
  members_can_create_private_pages: z.boolean().optional(),
  members_can_create_private_repositories: z.boolean().optional(),
  members_can_create_public_pages: z.boolean().optional(),
  members_can_create_public_repositories: z.boolean().optional(),
  members_can_create_repositories: z.boolean().optional().nullable(),
  members_can_fork_private_repositories: z.boolean().optional().nullable(),
  members_url: z.string(),
  name: z.string().optional(),
  node_id: z.string(),
  owned_private_repos: z.number().optional(),
  plan: z
    .object({
      filled_seats: z.number().optional(),
      name: z.string(),
      private_repos: z.number(),
      seats: z.number().optional(),
      space: z.number(),
    })
    .optional(),
  private_gists: z.number().optional().nullable(),
  public_gists: z.number(),
  public_members_url: z.string(),
  public_repos: z.number(),
  repos_url: z.string(),
  secret_scanning_enabled_for_new_repositories: z.boolean().optional(),
  secret_scanning_push_protection_custom_link: z.string().optional().nullable(),
  secret_scanning_push_protection_custom_link_enabled: z.boolean().optional(),
  secret_scanning_push_protection_enabled_for_new_repositories: z.boolean().optional(),
  total_private_repos: z.number().optional(),
  twitter_username: z.string().optional().nullable(),
  two_factor_requirement_enabled: z.boolean().optional().nullable(),
  type: z.string(),
  updated_at: z.string(),
  url: z.string(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const organizationInvitationSchema = z.object({
  created_at: z.string(),
  email: z.string().nullable(),
  failed_at: z.string().optional().nullable(),
  failed_reason: z.string().optional().nullable(),
  id: z.number(),
  invitation_source: z.string().optional(),
  invitation_teams_url: z.string(),
  inviter: simpleUserSchema,
  login: z.string().nullable(),
  node_id: z.string(),
  role: z.string(),
  team_count: z.number(),
});

export const secretScanningAlertResolutionSchema = z.union([
  z.literal('false_positive'),
  z.literal('wont_fix'),
  z.literal('revoked'),
  z.literal('used_in_tests'),
]);

export const secretScanningAlertStateSchema = z.union([z.literal('open'), z.literal('resolved')]);

export const packageVersionSchema = z.object({
  created_at: z.string(),
  deleted_at: z.string().optional(),
  description: z.string().optional(),
  html_url: z.string().optional(),
  id: z.number(),
  license: z.string().optional(),
  metadata: z
    .object({
      container: z
        .object({
          tags: z.array(z.string()),
        })
        .optional(),
      docker: z
        .object({
          tag: z.array(z.string()).optional(),
        })
        .optional(),
      package_type: z.union([
        z.literal('npm'),
        z.literal('maven'),
        z.literal('rubygems'),
        z.literal('docker'),
        z.literal('nuget'),
        z.literal('container'),
      ]),
    })
    .optional(),
  name: z.string(),
  package_html_url: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const packagesBillingUsageSchema = z.object({
  included_gigabytes_bandwidth: z.number(),
  total_gigabytes_bandwidth_used: z.number(),
  total_paid_gigabytes_bandwidth_used: z.number(),
});

export const pagesHttpsCertificateSchema = z.object({
  description: z.string(),
  domains: z.array(z.string()),
  expires_at: z.string().optional(),
  state: z.union([
    z.literal('new'),
    z.literal('authorization_created'),
    z.literal('authorization_pending'),
    z.literal('authorized'),
    z.literal('authorization_revoked'),
    z.literal('issued'),
    z.literal('uploaded'),
    z.literal('approved'),
    z.literal('errored'),
    z.literal('bad_authz'),
    z.literal('destroy_pending'),
    z.literal('dns_changed'),
  ]),
});

export const pagesSourceHashSchema = z.object({
  branch: z.string(),
  path: z.string(),
});

export const buildTypeSchema = z.union([z.literal('legacy'), z.literal('workflow')]);

export const protectedDomainStateSchema = z.union([
  z.literal('pending'),
  z.literal('verified'),
  z.literal('unverified'),
]);

export const status6Schema = z.union([z.literal('built'), z.literal('building'), z.literal('errored')]);

export const pageBuildSchema = z.object({
  commit: z.string(),
  created_at: z.string(),
  duration: z.number(),
  error: z.object({
    message: z.string().nullable(),
  }),
  pusher: nullableSimpleUserSchema,
  status: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const pageBuildStatusSchema = z.object({
  status: z.string(),
  url: z.string(),
});

export const pageDeploymentSchema = z.object({
  page_url: z.string(),
  preview_url: z.string().optional(),
  status_url: z.string(),
});

export const pagesHealthCheckSchema = z.object({
  alt_domain: z
    .object({
      caa_error: z.string().optional().nullable(),
      dns_resolves: z.boolean().optional(),
      enforces_https: z.boolean().optional(),
      has_cname_record: z.boolean().optional().nullable(),
      has_mx_records_present: z.boolean().optional().nullable(),
      host: z.string().optional(),
      https_error: z.string().optional().nullable(),
      is_a_record: z.boolean().optional().nullable(),
      is_apex_domain: z.boolean().optional(),
      is_cloudflare_ip: z.boolean().optional().nullable(),
      is_cname_to_fastly: z.boolean().optional().nullable(),
      is_cname_to_github_user_domain: z.boolean().optional().nullable(),
      is_cname_to_pages_dot_github_dot_com: z.boolean().optional().nullable(),
      is_fastly_ip: z.boolean().optional().nullable(),
      is_https_eligible: z.boolean().optional().nullable(),
      is_non_github_pages_ip_present: z.boolean().optional().nullable(),
      is_old_ip_address: z.boolean().optional().nullable(),
      is_pages_domain: z.boolean().optional(),
      is_pointed_to_github_pages_ip: z.boolean().optional().nullable(),
      is_proxied: z.boolean().optional().nullable(),
      is_served_by_pages: z.boolean().optional().nullable(),
      is_valid: z.boolean().optional(),
      is_valid_domain: z.boolean().optional(),
      nameservers: z.string().optional(),
      reason: z.string().optional().nullable(),
      responds_to_https: z.boolean().optional(),
      should_be_a_record: z.boolean().optional().nullable(),
      uri: z.string().optional(),
    })
    .optional()
    .nullable(),
  domain: z
    .object({
      caa_error: z.string().optional().nullable(),
      dns_resolves: z.boolean().optional(),
      enforces_https: z.boolean().optional(),
      has_cname_record: z.boolean().optional().nullable(),
      has_mx_records_present: z.boolean().optional().nullable(),
      host: z.string().optional(),
      https_error: z.string().optional().nullable(),
      is_a_record: z.boolean().optional().nullable(),
      is_apex_domain: z.boolean().optional(),
      is_cloudflare_ip: z.boolean().optional().nullable(),
      is_cname_to_fastly: z.boolean().optional().nullable(),
      is_cname_to_github_user_domain: z.boolean().optional().nullable(),
      is_cname_to_pages_dot_github_dot_com: z.boolean().optional().nullable(),
      is_fastly_ip: z.boolean().optional().nullable(),
      is_https_eligible: z.boolean().optional().nullable(),
      is_non_github_pages_ip_present: z.boolean().optional().nullable(),
      is_old_ip_address: z.boolean().optional().nullable(),
      is_pages_domain: z.boolean().optional(),
      is_pointed_to_github_pages_ip: z.boolean().optional().nullable(),
      is_proxied: z.boolean().optional().nullable(),
      is_served_by_pages: z.boolean().optional().nullable(),
      is_valid: z.boolean().optional(),
      is_valid_domain: z.boolean().optional(),
      nameservers: z.string().optional(),
      reason: z.string().optional().nullable(),
      responds_to_https: z.boolean().optional(),
      should_be_a_record: z.boolean().optional().nullable(),
      uri: z.string().optional(),
    })
    .optional(),
});

export const state8Schema = z.union([
  z.literal('new'),
  z.literal('authorization_created'),
  z.literal('authorization_pending'),
  z.literal('authorized'),
  z.literal('authorization_revoked'),
  z.literal('issued'),
  z.literal('uploaded'),
  z.literal('approved'),
  z.literal('errored'),
  z.literal('bad_authz'),
  z.literal('destroy_pending'),
  z.literal('dns_changed'),
]);

export const parameteraccountIdSchema = z.number();

export const parameteractionsCacheKeySchema = z.string();

export const parameteractionsCacheKeyRequiredSchema = z.string();

export const parameteractionsCacheListSortSchema = z.union([
  z.literal('created_at'),
  z.literal('last_accessed_at'),
  z.literal('size_in_bytes'),
]);

export const parameteractorSchema = z.string();

export const parameteralertNumberSchema = alertNumberSchema;

export const parameterallSchema = z.boolean();

export const parameterappSlugSchema = z.string();

export const parameterartifactIdSchema = z.number();

export const parameterassetIdSchema = z.number();

export const parameterattemptNumberSchema = z.number();

export const parameterautolinkIdSchema = z.number();

export const parameterbeforeSchema = z.string();

export const parameterbranchSchema = z.string();

export const parameterbranchPolicyIdSchema = z.number();

export const parametercacheIdSchema = z.number();

export const parametercardIdSchema = z.number();

export const parametercheckNameSchema = z.string();

export const parametercheckRunIdSchema = z.number();

export const parametercheckSuiteIdSchema = z.number();

export const parameterclientIdSchema = z.string();

export const parametercodespaceNameSchema = z.string();

export const parametercolumnIdSchema = z.number();

export const parametercommentIdSchema = z.number();

export const parametercommentNumberSchema = z.number();

export const parametercommitShaSchema = z.string();

export const parametercreatedSchema = z.string();

export const parametercursorSchema = z.string();

export const parameterdeliveryIdSchema = z.number();

export const parameterdependabotAlertCommaSeparatedEcosystemsSchema = z.string();

export const parameterdependabotAlertCommaSeparatedManifestsSchema = z.string();

export const parameterdependabotAlertCommaSeparatedPackagesSchema = z.string();

export const parameterdependabotAlertCommaSeparatedSeveritiesSchema = z.string();

export const parameterdependabotAlertCommaSeparatedStatesSchema = z.string();

export const parameterdependabotAlertNumberSchema = alertNumberSchema;

export const parameterdependabotAlertScopeSchema = z.union([z.literal('development'), z.literal('runtime')]);

export const parameterdependabotAlertSortSchema = z.union([z.literal('created'), z.literal('updated')]);

export const parameterdeploymentIdSchema = z.number();

export const parameterdirectionSchema = z.union([z.literal('asc'), z.literal('desc')]);

export const parameterdiscussionNumberSchema = z.number();

export const parameterenterpriseSchema = z.string();

export const parameterenvironmentNameSchema = z.string();

export const parametereventSchema = z.string();

export const parameterexcludePullRequestsSchema = z.boolean();

export const parameterexportIdSchema = z.string();

export const parametergistIdSchema = z.string();

export const parametergitRefSchema = codeScanningRefSchema;

export const parametergpgKeyIdSchema = z.number();

export const parameterhookIdSchema = z.number();

export const parameterinstallationIdSchema = z.number();

export const parameterinvitationIdSchema = z.number();

export const parameterissueNumberSchema = z.number();

export const parameterjobIdSchema = z.number();

export const parameterkeyIdSchema = z.number();

export const parameterlabelsSchema = z.string();

export const parametermanifestPathSchema = z.string();

export const parametermigrationIdSchema = z.number();

export const parametermilestoneNumberSchema = z.number();

export const parameterorderSchema = z.union([z.literal('desc'), z.literal('asc')]);

export const parameterorgSchema = z.string();

export const parameterorgSecurityProductEnablementSchema = z.union([z.literal('enable_all'), z.literal('disable_all')]);

export const parameterownerSchema = z.string();

export const parameterpackageNameSchema = z.string();

export const parameterpackageTypeSchema = z.union([
  z.literal('npm'),
  z.literal('maven'),
  z.literal('rubygems'),
  z.literal('docker'),
  z.literal('nuget'),
  z.literal('container'),
]);

export const parameterpackageVersionIdSchema = z.number();

export const parameterpackageVisibilitySchema = z.union([
  z.literal('public'),
  z.literal('private'),
  z.literal('internal'),
]);

export const parameterpageSchema = z.number();

export const parameterpaginationAfterSchema = z.string();

export const parameterpaginationBeforeSchema = z.string();

export const parameterpaginationFirstSchema = z.number();

export const parameterpaginationLastSchema = z.number();

export const parameterparticipatingSchema = z.boolean();

export const parameterperSchema = z.union([z.literal('day'), z.literal('week')]);

export const parameterperPageSchema = z.number();

export const parameterplanIdSchema = z.number();

export const parameterprojectIdSchema = z.number();

export const parameterpullNumberSchema = z.number();

export const parameterreactionIdSchema = z.number();

export const parameterreleaseIdSchema = z.number();

export const parameterrepoSchema = z.string();

export const parameterrepoNameSchema = z.string();

export const parameterrepoRequiredWorkflowIdSchema = z.number();

export const parameterrepositoryIdSchema = z.number();

export const parameterrepositoryIdInQuerySchema = z.number();

export const parameterrequiredWorkflowIdSchema = z.number();

export const parameterreviewIdSchema = z.number();

export const parameterrunIdSchema = z.number();

export const parameterrunnerIdSchema = z.number();

export const parameterrunnerLabelNameSchema = z.string();

export const parametersecretNameSchema = z.string();

export const parametersecretScanningAlertResolutionSchema = z.string();

export const parametersecretScanningAlertSecretTypeSchema = z.string();

export const parametersecretScanningAlertSortSchema = z.union([z.literal('created'), z.literal('updated')]);

export const parametersecretScanningAlertStateSchema = z.union([z.literal('open'), z.literal('resolved')]);

export const parametersecretScanningPaginationAfterOrgRepoSchema = z.string();

export const parametersecretScanningPaginationBeforeOrgRepoSchema = z.string();

export const parametersecurityProductSchema = z.union([
  z.literal('dependency_graph'),
  z.literal('dependabot_alerts'),
  z.literal('dependabot_security_updates'),
  z.literal('advanced_security'),
  z.literal('secret_scanning'),
  z.literal('secret_scanning_push_protection'),
]);

export const parametersinceSchema = z.string();

export const parametersinceOrgSchema = z.number();

export const parametersinceRepoSchema = z.number();

export const parametersinceUserSchema = z.number();

export const parametersortSchema = z.union([z.literal('created'), z.literal('updated')]);

export const parametersshSigningKeyIdSchema = z.number();

export const parameterstatusSchema = z.union([z.literal('queued'), z.literal('in_progress'), z.literal('completed')]);

export const parametertagProtectionIdSchema = z.number();

export const parameterteamIdSchema = z.number();

export const parameterteamSlugSchema = z.string();

export const parameterthreadIdSchema = z.number();

export const parametertoolGuidSchema = codeScanningAnalysisToolGuidSchema;

export const parametertoolNameSchema = codeScanningAnalysisToolNameSchema;

export const parameterusernameSchema = z.string();

export const parametervariableNameSchema = z.string();

export const parametervariablesPerPageSchema = z.number();

export const parameterworkflowIdSchema = z.union([z.number(), z.string()]);

export const parameterworkflowRunBranchSchema = z.string();

export const parameterworkflowRunCheckSuiteIdSchema = z.number();

export const parameterworkflowRunHeadShaSchema = z.string();

export const parameterworkflowRunStatusSchema = z.union([
  z.literal('completed'),
  z.literal('action_required'),
  z.literal('cancelled'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('skipped'),
  z.literal('stale'),
  z.literal('success'),
  z.literal('timed_out'),
  z.literal('in_progress'),
  z.literal('queued'),
  z.literal('requested'),
  z.literal('waiting'),
  z.literal('pending'),
]);

export const participationStatsSchema = z.object({
  all: z.array(z.number()),
  owner: z.array(z.number()),
});

export const teamSchema = z.object({
  description: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  members_url: z.string(),
  name: z.string(),
  node_id: z.string(),
  parent: nullableTeamSimpleSchema,
  permission: z.string(),
  permissions: z
    .object({
      admin: z.boolean(),
      maintain: z.boolean(),
      pull: z.boolean(),
      push: z.boolean(),
      triage: z.boolean(),
    })
    .optional(),
  privacy: z.string().optional(),
  repositories_url: z.string(),
  slug: z.string(),
  url: z.string(),
});

export const porterAuthorSchema = z.object({
  email: z.string(),
  id: z.number(),
  import_url: z.string(),
  name: z.string(),
  remote_id: z.string(),
  remote_name: z.string(),
  url: z.string(),
});

export const porterLargeFileSchema = z.object({
  oid: z.string(),
  path: z.string(),
  ref_name: z.string(),
  size: z.number(),
});

export const privateUserSchema = z.object({
  avatar_url: z.string(),
  bio: z.string().nullable(),
  blog: z.string().nullable(),
  business_plus: z.boolean().optional(),
  collaborators: z.number(),
  company: z.string().nullable(),
  created_at: z.string(),
  disk_usage: z.number(),
  email: z.string().nullable(),
  events_url: z.string(),
  followers: z.number(),
  followers_url: z.string(),
  following: z.number(),
  following_url: z.string(),
  gists_url: z.string(),
  gravatar_id: z.string().nullable(),
  hireable: z.boolean().nullable(),
  html_url: z.string(),
  id: z.number(),
  ldap_dn: z.string().optional(),
  location: z.string().nullable(),
  login: z.string(),
  name: z.string().nullable(),
  node_id: z.string(),
  organizations_url: z.string(),
  owned_private_repos: z.number(),
  plan: z
    .object({
      collaborators: z.number(),
      name: z.string(),
      private_repos: z.number(),
      space: z.number(),
    })
    .optional(),
  private_gists: z.number(),
  public_gists: z.number(),
  public_repos: z.number(),
  received_events_url: z.string(),
  repos_url: z.string(),
  site_admin: z.boolean(),
  starred_url: z.string(),
  subscriptions_url: z.string(),
  suspended_at: z.string().optional().nullable(),
  total_private_repos: z.number(),
  twitter_username: z.string().optional().nullable(),
  two_factor_authentication: z.boolean(),
  type: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const projectSchema = z.object({
  body: z.string().nullable(),
  columns_url: z.string(),
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  html_url: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  number: z.number(),
  organization_permission: z
    .union([z.literal('read'), z.literal('write'), z.literal('admin'), z.literal('none')])
    .optional(),
  owner_url: z.string(),
  private: z.boolean().optional(),
  state: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const organizationPermissionSchema = z.union([
  z.literal('read'),
  z.literal('write'),
  z.literal('admin'),
  z.literal('none'),
]);

export const projectCardSchema = z.object({
  archived: z.boolean().optional(),
  column_name: z.string().optional(),
  column_url: z.string(),
  content_url: z.string().optional(),
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  id: z.number(),
  node_id: z.string(),
  note: z.string().nullable(),
  project_id: z.string().optional(),
  project_url: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const projectCollaboratorPermissionSchema = z.object({
  permission: z.string(),
  user: nullableSimpleUserSchema,
});

export const projectColumnSchema = z.object({
  cards_url: z.string(),
  created_at: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  project_url: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const projectsV2Schema = z.object({
  closed_at: z.string().nullable(),
  created_at: z.string(),
  creator: simpleUserSchema,
  deleted_at: z.string().nullable(),
  deleted_by: nullableSimpleUserSchema,
  description: z.string().nullable(),
  id: z.number(),
  node_id: z.string(),
  number: z.number(),
  owner: simpleUserSchema,
  public: z.boolean(),
  short_description: z.string().nullable(),
  title: z.string(),
  updated_at: z.string(),
});

export const projectsV2ItemContentTypeSchema = z.union([
  z.literal('Issue'),
  z.literal('PullRequest'),
  z.literal('DraftIssue'),
]);

export const statusCheckPolicySchema = z.object({
  checks: z.array(
    z.object({
      app_id: z.number().nullable(),
      context: z.string(),
    }),
  ),
  contexts: z.array(z.string()),
  contexts_url: z.string(),
  strict: z.boolean(),
  url: z.string(),
});

export const protectedBranchPullRequestReviewSchema = z.object({
  bypass_pull_request_allowances: z
    .object({
      apps: z.array(integrationSchema).optional(),
      teams: z.array(teamSchema).optional(),
      users: z.array(simpleUserSchema).optional(),
    })
    .optional(),
  dismiss_stale_reviews: z.boolean(),
  dismissal_restrictions: z
    .object({
      apps: z.array(integrationSchema).optional(),
      teams: z.array(teamSchema).optional(),
      teams_url: z.string().optional(),
      url: z.string().optional(),
      users: z.array(simpleUserSchema).optional(),
      users_url: z.string().optional(),
    })
    .optional(),
  require_code_owner_reviews: z.boolean(),
  require_last_push_approval: z.boolean().optional(),
  required_approving_review_count: z.number().optional(),
  url: z.string().optional(),
});

export const teamSimpleSchema = z.object({
  description: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  ldap_dn: z.string().optional(),
  members_url: z.string(),
  name: z.string(),
  node_id: z.string(),
  permission: z.string(),
  privacy: z.string().optional(),
  repositories_url: z.string(),
  slug: z.string(),
  url: z.string(),
});

export const pullRequestMergeResultSchema = z.object({
  merged: z.boolean(),
  message: z.string(),
  sha: z.string(),
});

export const pullRequestReviewSchema = z.object({
  _links: z.object({
    html: z.object({
      href: z.string(),
    }),
    pull_request: z.object({
      href: z.string(),
    }),
  }),
  author_association: authorAssociationSchema,
  body: z.string(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  commit_id: z.string().nullable(),
  html_url: z.string(),
  id: z.number(),
  node_id: z.string(),
  pull_request_url: z.string(),
  state: z.string(),
  submitted_at: z.string().optional(),
  user: nullableSimpleUserSchema,
});

export const pullRequestReviewCommentSchema = z.object({
  _links: z.object({
    html: z.object({
      href: z.string(),
    }),
    pull_request: z.object({
      href: z.string(),
    }),
    self: z.object({
      href: z.string(),
    }),
  }),
  author_association: authorAssociationSchema,
  body: z.string(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  commit_id: z.string(),
  created_at: z.string(),
  diff_hunk: z.string(),
  html_url: z.string(),
  id: z.number(),
  in_reply_to_id: z.number().optional(),
  line: z.number().optional(),
  node_id: z.string(),
  original_commit_id: z.string(),
  original_line: z.number().optional(),
  original_position: z.number(),
  original_start_line: z.number().optional().nullable(),
  path: z.string(),
  position: z.number(),
  pull_request_review_id: z.number().nullable(),
  pull_request_url: z.string(),
  reactions: reactionRollupSchema.optional(),
  side: z.union([z.literal('LEFT'), z.literal('RIGHT')]).optional(),
  start_line: z.number().optional().nullable(),
  start_side: z
    .union([z.literal('LEFT'), z.literal('RIGHT')])
    .optional()
    .nullable(),
  updated_at: z.string(),
  url: z.string(),
  user: simpleUserSchema,
});

export const sideSchema = z.union([z.literal('LEFT'), z.literal('RIGHT')]);

export const startSideSchema = z.union([z.literal('LEFT'), z.literal('RIGHT')]);

export const pullRequestReviewRequestSchema = z.object({
  teams: z.array(teamSchema),
  users: z.array(simpleUserSchema),
});

export const pullRequestSimpleSchema = z.object({
  _links: z.object({
    comments: linkSchema,
    commits: linkSchema,
    html: linkSchema,
    issue: linkSchema,
    review_comment: linkSchema,
    review_comments: linkSchema,
    self: linkSchema,
    statuses: linkSchema,
  }),
  active_lock_reason: z.string().optional().nullable(),
  assignee: nullableSimpleUserSchema,
  assignees: z.array(simpleUserSchema).optional().nullable(),
  author_association: authorAssociationSchema,
  auto_merge: autoMergeSchema,
  base: z.object({
    label: z.string(),
    ref: z.string(),
    repo: repositorySchema,
    sha: z.string(),
    user: nullableSimpleUserSchema,
  }),
  body: z.string().nullable(),
  closed_at: z.string().nullable(),
  comments_url: z.string(),
  commits_url: z.string(),
  created_at: z.string(),
  diff_url: z.string(),
  draft: z.boolean().optional(),
  head: z.object({
    label: z.string(),
    ref: z.string(),
    repo: repositorySchema,
    sha: z.string(),
    user: nullableSimpleUserSchema,
  }),
  html_url: z.string(),
  id: z.number(),
  issue_url: z.string(),
  labels: z.array(
    z.object({
      color: z.string(),
      default: z.boolean(),
      description: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      url: z.string(),
    }),
  ),
  locked: z.boolean(),
  merge_commit_sha: z.string().nullable(),
  merged_at: z.string().nullable(),
  milestone: nullableMilestoneSchema,
  node_id: z.string(),
  number: z.number(),
  patch_url: z.string(),
  requested_reviewers: z.array(simpleUserSchema).optional().nullable(),
  requested_teams: z.array(teamSchema).optional().nullable(),
  review_comment_url: z.string(),
  review_comments_url: z.string(),
  state: z.string(),
  statuses_url: z.string(),
  title: z.string(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const rateLimitSchema = z.object({
  limit: z.number(),
  remaining: z.number(),
  reset: z.number(),
  used: z.number(),
});

export const rateLimitOverviewSchema = z.object({
  rate: rateLimitSchema,
  resources: z.object({
    actions_runner_registration: rateLimitSchema.optional(),
    code_scanning_upload: rateLimitSchema.optional(),
    core: rateLimitSchema,
    dependency_snapshots: rateLimitSchema.optional(),
    graphql: rateLimitSchema.optional(),
    integration_manifest: rateLimitSchema.optional(),
    scim: rateLimitSchema.optional(),
    search: rateLimitSchema,
    source_import: rateLimitSchema.optional(),
  }),
});

export const reactionSchema = z.object({
  content: z.union([
    z.literal('+1'),
    z.literal('-1'),
    z.literal('laugh'),
    z.literal('confused'),
    z.literal('heart'),
    z.literal('hooray'),
    z.literal('rocket'),
    z.literal('eyes'),
  ]),
  created_at: z.string(),
  id: z.number(),
  node_id: z.string(),
  user: nullableSimpleUserSchema,
});

export const contentSchema = z.union([
  z.literal('+1'),
  z.literal('-1'),
  z.literal('laugh'),
  z.literal('confused'),
  z.literal('heart'),
  z.literal('hooray'),
  z.literal('rocket'),
  z.literal('eyes'),
]);

export const referencedWorkflowSchema = z.object({
  path: z.string(),
  ref: z.string().optional(),
  sha: z.string(),
});

export const referrerTrafficSchema = z.object({
  count: z.number(),
  referrer: z.string(),
  uniques: z.number(),
});

export const releaseAssetSchema = z.object({
  browser_download_url: z.string(),
  content_type: z.string(),
  created_at: z.string(),
  download_count: z.number(),
  id: z.number(),
  label: z.string().nullable(),
  name: z.string(),
  node_id: z.string(),
  size: z.number(),
  state: z.union([z.literal('uploaded'), z.literal('open')]),
  updated_at: z.string(),
  uploader: nullableSimpleUserSchema,
  url: z.string(),
});

export const state9Schema = z.union([z.literal('uploaded'), z.literal('open')]);

export const releaseNotesContentSchema = z.object({
  body: z.string(),
  name: z.string(),
});

export const repoCodespacesSecretSchema = z.object({
  created_at: z.string(),
  name: z.string(),
  updated_at: z.string(),
});

export const repoRequiredWorkflowSchema = z.object({
  badge_url: z.string(),
  created_at: z.string(),
  html_url: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  path: z.string(),
  source_repository: minimalRepositorySchema,
  state: z.union([z.literal('active'), z.literal('deleted')]),
  updated_at: z.string(),
  url: z.string(),
});

export const state10Schema = z.union([z.literal('active'), z.literal('deleted')]);

export const repoSearchResultItemSchema = z.object({
  allow_auto_merge: z.boolean().optional(),
  allow_forking: z.boolean().optional(),
  allow_merge_commit: z.boolean().optional(),
  allow_rebase_merge: z.boolean().optional(),
  allow_squash_merge: z.boolean().optional(),
  archive_url: z.string(),
  archived: z.boolean(),
  assignees_url: z.string(),
  blobs_url: z.string(),
  branches_url: z.string(),
  clone_url: z.string(),
  collaborators_url: z.string(),
  comments_url: z.string(),
  commits_url: z.string(),
  compare_url: z.string(),
  contents_url: z.string(),
  contributors_url: z.string(),
  created_at: z.string(),
  default_branch: z.string(),
  delete_branch_on_merge: z.boolean().optional(),
  deployments_url: z.string(),
  description: z.string().nullable(),
  disabled: z.boolean(),
  downloads_url: z.string(),
  events_url: z.string(),
  fork: z.boolean(),
  forks: z.number(),
  forks_count: z.number(),
  forks_url: z.string(),
  full_name: z.string(),
  git_commits_url: z.string(),
  git_refs_url: z.string(),
  git_tags_url: z.string(),
  git_url: z.string(),
  has_discussions: z.boolean().optional(),
  has_downloads: z.boolean(),
  has_issues: z.boolean(),
  has_pages: z.boolean(),
  has_projects: z.boolean(),
  has_wiki: z.boolean(),
  homepage: z.string().nullable(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_template: z.boolean().optional(),
  issue_comment_url: z.string(),
  issue_events_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  labels_url: z.string(),
  language: z.string().nullable(),
  languages_url: z.string(),
  license: nullableLicenseSimpleSchema,
  master_branch: z.string().optional(),
  merges_url: z.string(),
  milestones_url: z.string(),
  mirror_url: z.string().nullable(),
  name: z.string(),
  node_id: z.string(),
  notifications_url: z.string(),
  open_issues: z.number(),
  open_issues_count: z.number(),
  owner: nullableSimpleUserSchema,
  permissions: z
    .object({
      admin: z.boolean(),
      maintain: z.boolean().optional(),
      pull: z.boolean(),
      push: z.boolean(),
      triage: z.boolean().optional(),
    })
    .optional(),
  private: z.boolean(),
  pulls_url: z.string(),
  pushed_at: z.string(),
  releases_url: z.string(),
  score: z.number(),
  size: z.number(),
  ssh_url: z.string(),
  stargazers_count: z.number(),
  stargazers_url: z.string(),
  statuses_url: z.string(),
  subscribers_url: z.string(),
  subscription_url: z.string(),
  svn_url: z.string(),
  tags_url: z.string(),
  teams_url: z.string(),
  temp_clone_token: z.string().optional(),
  text_matches: searchResultTextMatchesSchema.optional(),
  topics: z.array(z.string()).optional(),
  trees_url: z.string(),
  updated_at: z.string(),
  url: z.string(),
  visibility: z.string().optional(),
  watchers: z.number(),
  watchers_count: z.number(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const repositoryCollaboratorPermissionSchema = z.object({
  permission: z.string(),
  role_name: z.string(),
  user: nullableCollaboratorSchema,
});

export const repositoryInvitationSchema = z.object({
  created_at: z.string(),
  expired: z.boolean().optional(),
  html_url: z.string(),
  id: z.number(),
  invitee: nullableSimpleUserSchema,
  inviter: nullableSimpleUserSchema,
  node_id: z.string(),
  permissions: z.union([
    z.literal('read'),
    z.literal('write'),
    z.literal('admin'),
    z.literal('triage'),
    z.literal('maintain'),
  ]),
  repository: minimalRepositorySchema,
  url: z.string(),
});

export const permissionsSchema = z.union([
  z.literal('read'),
  z.literal('write'),
  z.literal('admin'),
  z.literal('triage'),
  z.literal('maintain'),
]);

export const repositorySubscriptionSchema = z.object({
  created_at: z.string(),
  ignored: z.boolean(),
  reason: z.string().nullable(),
  repository_url: z.string(),
  subscribed: z.boolean(),
  url: z.string(),
});

export const requiredWorkflowSchema = z.object({
  created_at: z.string(),
  id: z.number(),
  name: z.string(),
  path: z.string(),
  ref: z.string(),
  repository: minimalRepositorySchema,
  scope: z.union([z.literal('all'), z.literal('selected')]),
  selected_repositories_url: z.string().optional(),
  state: z.union([z.literal('active'), z.literal('deleted')]),
  updated_at: z.string(),
});

export const scope2Schema = z.union([z.literal('all'), z.literal('selected')]);

export const reviewCommentSchema = z.object({
  _links: z.object({
    html: linkSchema,
    pull_request: linkSchema,
    self: linkSchema,
  }),
  author_association: authorAssociationSchema,
  body: z.string(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  commit_id: z.string(),
  created_at: z.string(),
  diff_hunk: z.string(),
  html_url: z.string(),
  id: z.number(),
  in_reply_to_id: z.number().optional(),
  line: z.number().optional(),
  node_id: z.string(),
  original_commit_id: z.string(),
  original_line: z.number().optional(),
  original_position: z.number(),
  original_start_line: z.number().optional().nullable(),
  path: z.string(),
  position: z.number().nullable(),
  pull_request_review_id: z.number().nullable(),
  pull_request_url: z.string(),
  reactions: reactionRollupSchema.optional(),
  side: z.union([z.literal('LEFT'), z.literal('RIGHT')]).optional(),
  start_line: z.number().optional().nullable(),
  start_side: z
    .union([z.literal('LEFT'), z.literal('RIGHT')])
    .optional()
    .nullable(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const reviewRequestRemovedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  requested_reviewer: simpleUserSchema.optional(),
  requested_team: teamSchema.optional(),
  review_requester: simpleUserSchema,
  url: z.string(),
});

export const reviewRequestedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  requested_reviewer: simpleUserSchema.optional(),
  requested_team: teamSchema.optional(),
  review_requester: simpleUserSchema,
  url: z.string(),
});

export const rootSchema = z.object({
  authorizations_url: z.string(),
  code_search_url: z.string(),
  commit_search_url: z.string(),
  current_user_authorizations_html_url: z.string(),
  current_user_repositories_url: z.string(),
  current_user_url: z.string(),
  emails_url: z.string(),
  emojis_url: z.string(),
  events_url: z.string(),
  feeds_url: z.string(),
  followers_url: z.string(),
  following_url: z.string(),
  gists_url: z.string(),
  hub_url: z.string(),
  issue_search_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  label_search_url: z.string(),
  notifications_url: z.string(),
  organization_repositories_url: z.string(),
  organization_teams_url: z.string(),
  organization_url: z.string(),
  public_gists_url: z.string(),
  rate_limit_url: z.string(),
  repository_search_url: z.string(),
  repository_url: z.string(),
  starred_gists_url: z.string(),
  starred_url: z.string(),
  topic_search_url: z.string().optional(),
  user_organizations_url: z.string(),
  user_repositories_url: z.string(),
  user_search_url: z.string(),
  user_url: z.string(),
});

export const runnerLabelSchema = z.object({
  id: z.number().optional(),
  name: z.string(),
  type: z.union([z.literal('read-only'), z.literal('custom')]).optional(),
});

export const runnerApplicationSchema = z.object({
  architecture: z.string(),
  download_url: z.string(),
  filename: z.string(),
  os: z.string(),
  sha256_checksum: z.string().optional(),
  temp_download_token: z.string().optional(),
});

export const type5Schema = z.union([z.literal('read-only'), z.literal('custom')]);

export const scimErrorSchema = z.object({
  detail: z.string().optional().nullable(),
  documentation_url: z.string().optional().nullable(),
  message: z.string().optional().nullable(),
  schemas: z.array(z.string()).optional(),
  scimType: z.string().optional().nullable(),
  status: z.number().optional(),
});

export const secretScanningAlertSchema = z.object({
  created_at: alertCreatedAtSchema.optional(),
  html_url: alertHtmlUrlSchema.optional(),
  locations_url: z.string().optional(),
  number: alertNumberSchema.optional(),
  push_protection_bypassed: z.boolean().optional().nullable(),
  push_protection_bypassed_at: z.string().optional().nullable(),
  push_protection_bypassed_by: nullableSimpleUserSchema.optional(),
  resolution: secretScanningAlertResolutionSchema.optional(),
  resolution_comment: z.string().optional().nullable(),
  resolved_at: z.string().optional().nullable(),
  resolved_by: nullableSimpleUserSchema.optional(),
  secret: z.string().optional(),
  secret_type: z.string().optional(),
  secret_type_display_name: z.string().optional(),
  state: secretScanningAlertStateSchema.optional(),
  updated_at: nullableAlertUpdatedAtSchema.optional(),
  url: alertUrlSchema.optional(),
});

export const secretScanningAlertResolutionCommentSchema = z.string().nullable();

export const secretScanningLocationCommitSchema = z.object({
  blob_sha: z.string(),
  blob_url: z.string(),
  commit_sha: z.string(),
  commit_url: z.string(),
  end_column: z.number(),
  end_line: z.number(),
  path: z.string(),
  start_column: z.number(),
  start_line: z.number(),
});

export const secretScanningLocationIssueTitleSchema = z.object({
  issue_title_url: z.string(),
});

export const secretScanningLocationIssueBodySchema = z.object({
  issue_body_url: z.string(),
});

export const secretScanningLocationIssueCommentSchema = z.object({
  issue_comment_url: z.string(),
});

export const type6Schema = z.union([
  z.literal('commit'),
  z.literal('issue_title'),
  z.literal('issue_body'),
  z.literal('issue_comment'),
]);

export const status7Schema = z.union([z.literal('enabled'), z.literal('disabled')]);

export const selectedActionsSchema = z.object({
  github_owned_allowed: z.boolean().optional(),
  patterns_allowed: z.array(z.string()).optional(),
  verified_allowed: z.boolean().optional(),
});

export const shortBlobSchema = z.object({
  sha: z.string(),
  url: z.string(),
});

export const branchProtectionSchema = z.object({
  allow_deletions: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  allow_force_pushes: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  allow_fork_syncing: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  block_creations: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  enabled: z.boolean().optional(),
  enforce_admins: protectedBranchAdminEnforcedSchema.optional(),
  lock_branch: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  name: z.string().optional(),
  protection_url: z.string().optional(),
  required_conversation_resolution: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  required_linear_history: z
    .object({
      enabled: z.boolean().optional(),
    })
    .optional(),
  required_pull_request_reviews: protectedBranchPullRequestReviewSchema.optional(),
  required_signatures: z
    .object({
      enabled: z.boolean(),
      url: z.string(),
    })
    .optional(),
  required_status_checks: protectedBranchRequiredStatusCheckSchema.optional(),
  restrictions: branchRestrictionPolicySchema.optional(),
  url: z.string().optional(),
});

export const simpleCheckSuiteSchema = z.object({
  after: z.string().optional().nullable(),
  app: integrationSchema.optional(),
  before: z.string().optional().nullable(),
  conclusion: z
    .union([
      z.literal('success'),
      z.literal('failure'),
      z.literal('neutral'),
      z.literal('cancelled'),
      z.literal('skipped'),
      z.literal('timed_out'),
      z.literal('action_required'),
      z.literal('stale'),
      z.literal('startup_failure'),
    ])
    .optional()
    .nullable(),
  created_at: z.string().optional(),
  head_branch: z.string().optional().nullable(),
  head_sha: z.string().optional(),
  id: z.number().optional(),
  node_id: z.string().optional(),
  pull_requests: z.array(pullRequestMinimalSchema).optional(),
  repository: minimalRepositorySchema.optional(),
  status: z
    .union([
      z.literal('queued'),
      z.literal('in_progress'),
      z.literal('completed'),
      z.literal('pending'),
      z.literal('waiting'),
    ])
    .optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
});

export const status8Schema = z.union([
  z.literal('queued'),
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('pending'),
  z.literal('waiting'),
]);

export const simpleInstallationSchema = z.object({
  id: z.number(),
  node_id: z.string(),
});

export const snapshotSchema = z.object({
  detector: z.object({
    name: z.string(),
    url: z.string(),
    version: z.string(),
  }),
  job: z.object({
    correlator: z.string(),
    html_url: z.string().optional(),
    id: z.string(),
  }),
  manifests: z.record(manifestSchema).optional(),
  metadata: metadataSchema.optional(),
  ref: z.string(),
  scanned: z.string(),
  sha: z.string(),
  version: z.number(),
});

export const sshSigningKeySchema = z.object({
  created_at: z.string(),
  id: z.number(),
  key: z.string(),
  title: z.string(),
});

export const stargazerSchema = z.object({
  starred_at: z.string(),
  user: nullableSimpleUserSchema,
});

export const starredRepositorySchema = z.object({
  repo: repositorySchema,
  starred_at: z.string(),
});

export const stateChangeIssueEventSchema = z.object({
  actor: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  state_reason: z.string().optional().nullable(),
  url: z.string(),
});

export const status9Schema = z.object({
  avatar_url: z.string().nullable(),
  context: z.string(),
  created_at: z.string(),
  creator: nullableSimpleUserSchema,
  description: z.string().nullable(),
  id: z.number(),
  node_id: z.string(),
  state: z.string(),
  target_url: z.string().nullable(),
  updated_at: z.string(),
  url: z.string(),
});

export const tagSchema = z.object({
  commit: z.object({
    sha: z.string(),
    url: z.string(),
  }),
  name: z.string(),
  node_id: z.string(),
  tarball_url: z.string(),
  zipball_url: z.string(),
});

export const tagProtectionSchema = z.object({
  created_at: z.string().optional(),
  enabled: z.boolean().optional(),
  id: z.number().optional(),
  pattern: z.string(),
  updated_at: z.string().optional(),
});

export const teamDiscussionSchema = z.object({
  author: nullableSimpleUserSchema,
  body: z.string(),
  body_html: z.string(),
  body_version: z.string(),
  comments_count: z.number(),
  comments_url: z.string(),
  created_at: z.string(),
  html_url: z.string(),
  last_edited_at: z.string().nullable(),
  node_id: z.string(),
  number: z.number(),
  pinned: z.boolean(),
  private: z.boolean(),
  reactions: reactionRollupSchema.optional(),
  team_url: z.string(),
  title: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const teamDiscussionCommentSchema = z.object({
  author: nullableSimpleUserSchema,
  body: z.string(),
  body_html: z.string(),
  body_version: z.string(),
  created_at: z.string(),
  discussion_url: z.string(),
  html_url: z.string(),
  last_edited_at: z.string().nullable(),
  node_id: z.string(),
  number: z.number(),
  reactions: reactionRollupSchema.optional(),
  updated_at: z.string(),
  url: z.string(),
});

export const teamOrganizationSchema = z.object({
  avatar_url: z.string(),
  billing_email: z.string().optional().nullable(),
  blog: z.string().optional(),
  collaborators: z.number().optional().nullable(),
  company: z.string().optional(),
  created_at: z.string(),
  default_repository_permission: z.string().optional().nullable(),
  description: z.string().nullable(),
  disk_usage: z.number().optional().nullable(),
  email: z.string().optional(),
  events_url: z.string(),
  followers: z.number(),
  following: z.number(),
  has_organization_projects: z.boolean(),
  has_repository_projects: z.boolean(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_verified: z.boolean().optional(),
  issues_url: z.string(),
  location: z.string().optional(),
  login: z.string(),
  members_allowed_repository_creation_type: z.string().optional(),
  members_can_create_internal_repositories: z.boolean().optional(),
  members_can_create_pages: z.boolean().optional(),
  members_can_create_private_pages: z.boolean().optional(),
  members_can_create_private_repositories: z.boolean().optional(),
  members_can_create_public_pages: z.boolean().optional(),
  members_can_create_public_repositories: z.boolean().optional(),
  members_can_create_repositories: z.boolean().optional().nullable(),
  members_can_fork_private_repositories: z.boolean().optional().nullable(),
  members_url: z.string(),
  name: z.string().optional(),
  node_id: z.string(),
  owned_private_repos: z.number().optional(),
  plan: z
    .object({
      filled_seats: z.number().optional(),
      name: z.string(),
      private_repos: z.number(),
      seats: z.number().optional(),
      space: z.number(),
    })
    .optional(),
  private_gists: z.number().optional().nullable(),
  public_gists: z.number(),
  public_members_url: z.string(),
  public_repos: z.number(),
  repos_url: z.string(),
  total_private_repos: z.number().optional(),
  twitter_username: z.string().optional().nullable(),
  two_factor_requirement_enabled: z.boolean().optional().nullable(),
  type: z.string(),
  updated_at: z.string(),
  url: z.string(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const privacySchema = z.union([z.literal('closed'), z.literal('secret')]);

export const teamMembershipSchema = z.object({
  role: z.union([z.literal('member'), z.literal('maintainer')]),
  state: z.union([z.literal('active'), z.literal('pending')]),
  url: z.string(),
});

export const role2Schema = z.union([z.literal('member'), z.literal('maintainer')]);

export const teamProjectSchema = z.object({
  body: z.string().nullable(),
  columns_url: z.string(),
  created_at: z.string(),
  creator: simpleUserSchema,
  html_url: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  number: z.number(),
  organization_permission: z.string().optional(),
  owner_url: z.string(),
  permissions: z.object({
    admin: z.boolean(),
    read: z.boolean(),
    write: z.boolean(),
  }),
  private: z.boolean().optional(),
  state: z.string(),
  updated_at: z.string(),
  url: z.string(),
});

export const teamRepositorySchema = z.object({
  allow_auto_merge: z.boolean().optional(),
  allow_forking: z.boolean().optional(),
  allow_merge_commit: z.boolean().optional(),
  allow_rebase_merge: z.boolean().optional(),
  allow_squash_merge: z.boolean().optional(),
  archive_url: z.string(),
  archived: z.boolean(),
  assignees_url: z.string(),
  blobs_url: z.string(),
  branches_url: z.string(),
  clone_url: z.string(),
  collaborators_url: z.string(),
  comments_url: z.string(),
  commits_url: z.string(),
  compare_url: z.string(),
  contents_url: z.string(),
  contributors_url: z.string(),
  created_at: z.string().nullable(),
  default_branch: z.string(),
  delete_branch_on_merge: z.boolean().optional(),
  deployments_url: z.string(),
  description: z.string().nullable(),
  disabled: z.boolean(),
  downloads_url: z.string(),
  events_url: z.string(),
  fork: z.boolean(),
  forks: z.number(),
  forks_count: z.number(),
  forks_url: z.string(),
  full_name: z.string(),
  git_commits_url: z.string(),
  git_refs_url: z.string(),
  git_tags_url: z.string(),
  git_url: z.string(),
  has_downloads: z.boolean(),
  has_issues: z.boolean(),
  has_pages: z.boolean(),
  has_projects: z.boolean(),
  has_wiki: z.boolean(),
  homepage: z.string().nullable(),
  hooks_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  is_template: z.boolean().optional(),
  issue_comment_url: z.string(),
  issue_events_url: z.string(),
  issues_url: z.string(),
  keys_url: z.string(),
  labels_url: z.string(),
  language: z.string().nullable(),
  languages_url: z.string(),
  license: nullableLicenseSimpleSchema,
  master_branch: z.string().optional(),
  merges_url: z.string(),
  milestones_url: z.string(),
  mirror_url: z.string().nullable(),
  name: z.string(),
  network_count: z.number().optional(),
  node_id: z.string(),
  notifications_url: z.string(),
  open_issues: z.number(),
  open_issues_count: z.number(),
  owner: nullableSimpleUserSchema,
  permissions: z
    .object({
      admin: z.boolean(),
      maintain: z.boolean().optional(),
      pull: z.boolean(),
      push: z.boolean(),
      triage: z.boolean().optional(),
    })
    .optional(),
  private: z.boolean(),
  pulls_url: z.string(),
  pushed_at: z.string().nullable(),
  releases_url: z.string(),
  role_name: z.string().optional(),
  size: z.number(),
  ssh_url: z.string(),
  stargazers_count: z.number(),
  stargazers_url: z.string(),
  statuses_url: z.string(),
  subscribers_count: z.number().optional(),
  subscribers_url: z.string(),
  subscription_url: z.string(),
  svn_url: z.string(),
  tags_url: z.string(),
  teams_url: z.string(),
  temp_clone_token: z.string().optional(),
  template_repository: nullableRepositorySchema.optional(),
  topics: z.array(z.string()).optional(),
  trees_url: z.string(),
  updated_at: z.string().nullable(),
  url: z.string(),
  visibility: z.string().optional(),
  watchers: z.number(),
  watchers_count: z.number(),
  web_commit_signoff_required: z.boolean().optional(),
});

export const threadSchema = z.object({
  id: z.string(),
  last_read_at: z.string().nullable(),
  reason: z.string(),
  repository: minimalRepositorySchema,
  subject: z.object({
    latest_comment_url: z.string(),
    title: z.string(),
    type: z.string(),
    url: z.string(),
  }),
  subscription_url: z.string(),
  unread: z.boolean(),
  updated_at: z.string(),
  url: z.string(),
});

export const threadSubscriptionSchema = z.object({
  created_at: z.string().nullable(),
  ignored: z.boolean(),
  reason: z.string().nullable(),
  repository_url: z.string().optional(),
  subscribed: z.boolean(),
  thread_url: z.string().optional(),
  url: z.string(),
});

export const timelineAssignedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  assignee: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const timelineCommentEventSchema = z.object({
  actor: simpleUserSchema,
  author_association: authorAssociationSchema,
  body: z.string().optional(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  created_at: z.string(),
  event: z.string(),
  html_url: z.string(),
  id: z.number(),
  issue_url: z.string(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  reactions: reactionRollupSchema.optional(),
  updated_at: z.string(),
  url: z.string(),
  user: simpleUserSchema,
});

export const commitCommentSchema = z.object({
  author_association: authorAssociationSchema,
  body: z.string(),
  commit_id: z.string(),
  created_at: z.string(),
  html_url: z.string(),
  id: z.number(),
  line: z.number().nullable(),
  node_id: z.string(),
  path: z.string().nullable(),
  position: z.number().nullable(),
  reactions: reactionRollupSchema.optional(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const timelineCommittedEventSchema = z.object({
  author: z.object({
    date: z.string(),
    email: z.string(),
    name: z.string(),
  }),
  committer: z.object({
    date: z.string(),
    email: z.string(),
    name: z.string(),
  }),
  event: z.string().optional(),
  html_url: z.string(),
  message: z.string(),
  node_id: z.string(),
  parents: z.array(
    z.object({
      html_url: z.string(),
      sha: z.string(),
      url: z.string(),
    }),
  ),
  sha: z.string(),
  tree: z.object({
    sha: z.string(),
    url: z.string(),
  }),
  url: z.string(),
  verification: z.object({
    payload: z.string().nullable(),
    reason: z.string(),
    signature: z.string().nullable(),
    verified: z.boolean(),
  }),
});

export const issueSchema = z.object({
  active_lock_reason: z.string().optional().nullable(),
  assignee: nullableSimpleUserSchema,
  assignees: z.array(simpleUserSchema).optional().nullable(),
  author_association: authorAssociationSchema,
  body: z.string().optional().nullable(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  closed_at: z.string().nullable(),
  closed_by: nullableSimpleUserSchema.optional(),
  comments: z.number(),
  comments_url: z.string(),
  created_at: z.string(),
  draft: z.boolean().optional(),
  events_url: z.string(),
  html_url: z.string(),
  id: z.number(),
  labels: z.array(
    z.union([
      z.string(),
      z.object({
        color: z.string().optional().nullable(),
        default: z.boolean().optional(),
        description: z.string().optional().nullable(),
        id: z.number().optional(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        url: z.string().optional(),
      }),
    ]),
  ),
  labels_url: z.string(),
  locked: z.boolean(),
  milestone: nullableMilestoneSchema,
  node_id: z.string(),
  number: z.number(),
  performed_via_github_app: nullableIntegrationSchema.optional(),
  pull_request: z
    .object({
      diff_url: z.string().nullable(),
      html_url: z.string().nullable(),
      merged_at: z.string().optional().nullable(),
      patch_url: z.string().nullable(),
      url: z.string().nullable(),
    })
    .optional(),
  reactions: reactionRollupSchema.optional(),
  repository: repositorySchema.optional(),
  repository_url: z.string(),
  state: z.string(),
  state_reason: z
    .union([z.literal('completed'), z.literal('reopened'), z.literal('not_planned')])
    .optional()
    .nullable(),
  timeline_url: z.string().optional(),
  title: z.string(),
  updated_at: z.string(),
  url: z.string(),
  user: nullableSimpleUserSchema,
});

export const timelineCrossReferencedEventSchema = z.object({
  actor: simpleUserSchema.optional(),
  created_at: z.string(),
  event: z.string(),
  source: z.object({
    issue: issueSchema.optional(),
    type: z.string().optional(),
  }),
  updated_at: z.string(),
});

export const timelineReviewedEventSchema = z.object({
  _links: z.object({
    html: z.object({
      href: z.string(),
    }),
    pull_request: z.object({
      href: z.string(),
    }),
  }),
  author_association: authorAssociationSchema,
  body: z.string().nullable(),
  body_html: z.string().optional(),
  body_text: z.string().optional(),
  commit_id: z.string(),
  event: z.string(),
  html_url: z.string(),
  id: z.number(),
  node_id: z.string(),
  pull_request_url: z.string(),
  state: z.string(),
  submitted_at: z.string().optional(),
  user: simpleUserSchema,
});

export const timelineLineCommentedEventSchema = z.object({
  comments: z.array(pullRequestReviewCommentSchema).optional(),
  event: z.string().optional(),
  node_id: z.string().optional(),
});

export const timelineCommitCommentedEventSchema = z.object({
  comments: z.array(commitCommentSchema).optional(),
  commit_id: z.string().optional(),
  event: z.string().optional(),
  node_id: z.string().optional(),
});

export const timelineUnassignedIssueEventSchema = z.object({
  actor: simpleUserSchema,
  assignee: simpleUserSchema,
  commit_id: z.string().nullable(),
  commit_url: z.string().nullable(),
  created_at: z.string(),
  event: z.string(),
  id: z.number(),
  node_id: z.string(),
  performed_via_github_app: nullableIntegrationSchema,
  url: z.string(),
});

export const topicSchema = z.object({
  names: z.array(z.string()),
});

export const topicSearchResultItemSchema = z.object({
  aliases: z
    .array(
      z.object({
        topic_relation: z
          .object({
            id: z.number().optional(),
            name: z.string().optional(),
            relation_type: z.string().optional(),
            topic_id: z.number().optional(),
          })
          .optional(),
      }),
    )
    .optional()
    .nullable(),
  created_at: z.string(),
  created_by: z.string().nullable(),
  curated: z.boolean(),
  description: z.string().nullable(),
  display_name: z.string().nullable(),
  featured: z.boolean(),
  logo_url: z.string().optional().nullable(),
  name: z.string(),
  related: z
    .array(
      z.object({
        topic_relation: z
          .object({
            id: z.number().optional(),
            name: z.string().optional(),
            relation_type: z.string().optional(),
            topic_id: z.number().optional(),
          })
          .optional(),
      }),
    )
    .optional()
    .nullable(),
  released: z.string().nullable(),
  repository_count: z.number().optional().nullable(),
  score: z.number(),
  short_description: z.string().nullable(),
  text_matches: searchResultTextMatchesSchema.optional(),
  updated_at: z.string(),
});

export const userMarketplacePurchaseSchema = z.object({
  account: marketplaceAccountSchema,
  billing_cycle: z.string(),
  free_trial_ends_on: z.string().nullable(),
  next_billing_date: z.string().nullable(),
  on_free_trial: z.boolean(),
  plan: marketplaceListingPlanSchema,
  unit_count: z.number().nullable(),
  updated_at: z.string().nullable(),
});

export const userSearchResultItemSchema = z.object({
  avatar_url: z.string(),
  bio: z.string().optional().nullable(),
  blog: z.string().optional().nullable(),
  company: z.string().optional().nullable(),
  created_at: z.string().optional(),
  email: z.string().optional().nullable(),
  events_url: z.string(),
  followers: z.number().optional(),
  followers_url: z.string(),
  following: z.number().optional(),
  following_url: z.string(),
  gists_url: z.string(),
  gravatar_id: z.string().nullable(),
  hireable: z.boolean().optional().nullable(),
  html_url: z.string(),
  id: z.number(),
  location: z.string().optional().nullable(),
  login: z.string(),
  name: z.string().optional().nullable(),
  node_id: z.string(),
  organizations_url: z.string(),
  public_gists: z.number().optional(),
  public_repos: z.number().optional(),
  received_events_url: z.string(),
  repos_url: z.string(),
  score: z.number(),
  site_admin: z.boolean(),
  starred_url: z.string(),
  subscriptions_url: z.string(),
  suspended_at: z.string().optional().nullable(),
  text_matches: searchResultTextMatchesSchema.optional(),
  type: z.string(),
  updated_at: z.string().optional(),
  url: z.string(),
});

export const validationErrorSchema = z.object({
  documentation_url: z.string(),
  errors: z
    .array(
      z.object({
        code: z.string(),
        field: z.string().optional(),
        index: z.number().optional(),
        message: z.string().optional(),
        resource: z.string().optional(),
        value: z
          .union([z.string(), z.number(), z.array(z.string())])
          .optional()
          .nullable(),
      }),
    )
    .optional(),
  message: z.string(),
});

export const validationErrorSimpleSchema = z.object({
  documentation_url: z.string(),
  errors: z.array(z.string()).optional(),
  message: z.string(),
});

export const viewTrafficSchema = z.object({
  count: z.number(),
  uniques: z.number(),
  views: z.array(trafficSchema),
});

export const webhookBranchProtectionRuleCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  rule: z.object({
    admin_enforced: z.boolean(),
    allow_deletions_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    allow_force_pushes_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    authorized_actor_names: z.array(z.string()),
    authorized_actors_only: z.boolean(),
    authorized_dismissal_actors_only: z.boolean(),
    create_protected: z.boolean().optional(),
    created_at: z.string(),
    dismiss_stale_reviews_on_push: z.boolean(),
    id: z.number(),
    ignore_approvals_from_contributors: z.boolean(),
    linear_history_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    merge_queue_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    name: z.string(),
    pull_request_reviews_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    repository_id: z.number(),
    require_code_owner_review: z.boolean(),
    required_approving_review_count: z.number(),
    required_conversation_resolution_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_deployments_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_status_checks: z.array(z.string()),
    required_status_checks_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    signature_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    strict_required_status_checks_policy: z.boolean(),
    updated_at: z.string(),
  }),
  sender: simpleUserSchema,
});

export const actionSchema = z.literal('created');

export const allowDeletionsEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const allowForcePushesEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const linearHistoryRequirementEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const mergeQueueEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const pullRequestReviewsEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const requiredConversationResolutionLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const requiredDeploymentsEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const requiredStatusChecksEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const signatureRequirementEnforcementLevelSchema = z.union([
  z.literal('off'),
  z.literal('non_admins'),
  z.literal('everyone'),
]);

export const webhookBranchProtectionRuleDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  rule: z.object({
    admin_enforced: z.boolean(),
    allow_deletions_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    allow_force_pushes_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    authorized_actor_names: z.array(z.string()),
    authorized_actors_only: z.boolean(),
    authorized_dismissal_actors_only: z.boolean(),
    create_protected: z.boolean().optional(),
    created_at: z.string(),
    dismiss_stale_reviews_on_push: z.boolean(),
    id: z.number(),
    ignore_approvals_from_contributors: z.boolean(),
    linear_history_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    merge_queue_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    name: z.string(),
    pull_request_reviews_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    repository_id: z.number(),
    require_code_owner_review: z.boolean(),
    required_approving_review_count: z.number(),
    required_conversation_resolution_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_deployments_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_status_checks: z.array(z.string()),
    required_status_checks_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    signature_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    strict_required_status_checks_policy: z.boolean(),
    updated_at: z.string(),
  }),
  sender: simpleUserSchema,
});

export const action2Schema = z.literal('deleted');

export const webhookBranchProtectionRuleEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z
    .object({
      admin_enforced: z
        .object({
          from: z.boolean().nullable(),
        })
        .optional(),
      authorized_actor_names: z
        .object({
          from: z.array(z.string()),
        })
        .optional(),
      authorized_actors_only: z
        .object({
          from: z.boolean().nullable(),
        })
        .optional(),
      authorized_dismissal_actors_only: z
        .object({
          from: z.boolean().nullable(),
        })
        .optional(),
      linear_history_requirement_enforcement_level: z
        .object({
          from: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
        })
        .optional(),
      required_status_checks: z
        .object({
          from: z.array(z.string()),
        })
        .optional(),
      required_status_checks_enforcement_level: z
        .object({
          from: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
        })
        .optional(),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  rule: z.object({
    admin_enforced: z.boolean(),
    allow_deletions_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    allow_force_pushes_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    authorized_actor_names: z.array(z.string()),
    authorized_actors_only: z.boolean(),
    authorized_dismissal_actors_only: z.boolean(),
    create_protected: z.boolean().optional(),
    created_at: z.string(),
    dismiss_stale_reviews_on_push: z.boolean(),
    id: z.number(),
    ignore_approvals_from_contributors: z.boolean(),
    linear_history_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    merge_queue_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    name: z.string(),
    pull_request_reviews_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    repository_id: z.number(),
    require_code_owner_review: z.boolean(),
    required_approving_review_count: z.number(),
    required_conversation_resolution_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_deployments_enforcement_level: z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]),
    required_status_checks: z.array(z.string()),
    required_status_checks_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    signature_requirement_enforcement_level: z.union([
      z.literal('off'),
      z.literal('non_admins'),
      z.literal('everyone'),
    ]),
    strict_required_status_checks_policy: z.boolean(),
    updated_at: z.string(),
  }),
  sender: simpleUserSchema,
});

export const action3Schema = z.literal('edited');

export const fromSchema = z.union([z.literal('off'), z.literal('non_admins'), z.literal('everyone')]);

export const checkRunWithSimpleCheckSuiteSchema = z.object({
  app: nullableIntegrationSchema,
  check_suite: simpleCheckSuiteSchema,
  completed_at: z.string().nullable(),
  conclusion: z
    .union([
      z.literal('waiting'),
      z.literal('pending'),
      z.literal('startup_failure'),
      z.literal('stale'),
      z.literal('success'),
      z.literal('failure'),
      z.literal('neutral'),
      z.literal('cancelled'),
      z.literal('skipped'),
      z.literal('timed_out'),
      z.literal('action_required'),
    ])
    .nullable(),
  deployment: deploymentSimpleSchema.optional(),
  details_url: z.string(),
  external_id: z.string(),
  head_sha: z.string(),
  html_url: z.string(),
  id: z.number(),
  name: z.string(),
  node_id: z.string(),
  output: z.object({
    annotations_count: z.number(),
    annotations_url: z.string(),
    summary: z.string().nullable(),
    text: z.string().nullable(),
    title: z.string().nullable(),
  }),
  pull_requests: z.array(pullRequestMinimalSchema),
  started_at: z.string(),
  status: z.union([z.literal('queued'), z.literal('in_progress'), z.literal('completed'), z.literal('pending')]),
  url: z.string(),
});

export const action4Schema = z.literal('completed');

export const webhookCheckRunCompletedFormEncodedSchema = z.object({
  payload: z.string(),
});

export const webhookCheckRunCreatedSchema = z.object({
  action: z.literal('created').optional(),
  check_run: checkRunWithSimpleCheckSuiteSchema,
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookCheckRunCreatedFormEncodedSchema = z.object({
  payload: z.string(),
});

export const webhookCheckRunRequestedActionSchema = z.object({
  action: z.literal('requested_action'),
  check_run: checkRunWithSimpleCheckSuiteSchema,
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  requested_action: z
    .object({
      identifier: z.string().optional(),
    })
    .optional(),
  sender: simpleUserSchema,
});

export const action5Schema = z.literal('requested_action');

export const webhookCheckRunRequestedActionFormEncodedSchema = z.object({
  payload: z.string(),
});

export const webhookCheckRunRerequestedSchema = z.object({
  action: z.literal('rerequested').optional(),
  check_run: checkRunWithSimpleCheckSuiteSchema,
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action6Schema = z.literal('rerequested');

export const webhookCheckRunRerequestedFormEncodedSchema = z.object({
  payload: z.string(),
});

export const webhookCheckSuiteCompletedSchema = z.object({
  action: z.literal('completed'),
  actions_meta: z.record(z.unknown()).optional().nullable(),
  check_suite: z.object({
    after: z.string().nullable(),
    app: z.object({
      created_at: z.string().nullable(),
      description: z.string().nullable(),
      events: z
        .array(
          z.union([
            z.literal('branch_protection_rule'),
            z.literal('check_run'),
            z.literal('check_suite'),
            z.literal('code_scanning_alert'),
            z.literal('commit_comment'),
            z.literal('content_reference'),
            z.literal('create'),
            z.literal('delete'),
            z.literal('deployment'),
            z.literal('deployment_review'),
            z.literal('deployment_status'),
            z.literal('deploy_key'),
            z.literal('discussion'),
            z.literal('discussion_comment'),
            z.literal('fork'),
            z.literal('gollum'),
            z.literal('issues'),
            z.literal('issue_comment'),
            z.literal('label'),
            z.literal('member'),
            z.literal('membership'),
            z.literal('milestone'),
            z.literal('organization'),
            z.literal('org_block'),
            z.literal('page_build'),
            z.literal('project'),
            z.literal('project_card'),
            z.literal('project_column'),
            z.literal('public'),
            z.literal('pull_request'),
            z.literal('pull_request_review'),
            z.literal('pull_request_review_comment'),
            z.literal('push'),
            z.literal('registry_package'),
            z.literal('release'),
            z.literal('repository'),
            z.literal('repository_dispatch'),
            z.literal('secret_scanning_alert'),
            z.literal('star'),
            z.literal('status'),
            z.literal('team'),
            z.literal('team_add'),
            z.literal('watch'),
            z.literal('workflow_dispatch'),
            z.literal('workflow_run'),
            z.literal('merge_group'),
            z.literal('pull_request_review_thread'),
            z.literal('workflow_job'),
            z.literal('merge_queue_entry'),
            z.literal('security_and_analysis'),
            z.literal('projects_v2_item'),
            z.literal('secret_scanning_alert_location'),
          ]),
        )
        .optional(),
      external_url: z.string().nullable(),
      html_url: z.string(),
      id: z.number().nullable(),
      name: z.string(),
      node_id: z.string(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          actions: z.union([z.literal('read'), z.literal('write')]).optional(),
          administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          checks: z.union([z.literal('read'), z.literal('write')]).optional(),
          content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
          contents: z.union([z.literal('read'), z.literal('write')]).optional(),
          deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
          discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          emails: z.union([z.literal('read'), z.literal('write')]).optional(),
          environments: z.union([z.literal('read'), z.literal('write')]).optional(),
          issues: z.union([z.literal('read'), z.literal('write')]).optional(),
          keys: z.union([z.literal('read'), z.literal('write')]).optional(),
          members: z.union([z.literal('read'), z.literal('write')]).optional(),
          metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
          packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
          single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
          statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
          team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
        })
        .optional(),
      slug: z.string().optional(),
      updated_at: z.string().nullable(),
    }),
    before: z.string().nullable(),
    check_runs_url: z.string(),
    conclusion: z
      .union([
        z.literal('success'),
        z.literal('failure'),
        z.literal('neutral'),
        z.literal('cancelled'),
        z.literal('timed_out'),
        z.literal('action_required'),
        z.literal('stale'),
        z.literal('skipped'),
        z.literal('startup_failure'),
      ])
      .nullable(),
    created_at: z.string(),
    head_branch: z.string().nullable(),
    head_commit: z.object({
      author: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      committer: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      id: z.string(),
      message: z.string(),
      timestamp: z.string(),
      tree_id: z.string(),
    }),
    head_sha: z.string(),
    id: z.number(),
    latest_check_runs_count: z.number(),
    node_id: z.string(),
    pull_requests: z.array(
      z.object({
        base: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        head: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        id: z.number(),
        number: z.number(),
        url: z.string(),
      }),
    ),
    rerequestable: z.boolean().optional(),
    runs_rerequestable: z.boolean().optional(),
    status: z
      .union([
        z.literal('requested'),
        z.literal('in_progress'),
        z.literal('completed'),
        z.literal('queued'),
        z.literal('pending'),
      ])
      .nullable(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const contentReferencesSchema = z.union([z.literal('read'), z.literal('write')]);

export const discussionsSchema = z.union([z.literal('read'), z.literal('write')]);

export const emailsSchema = z.union([z.literal('read'), z.literal('write')]);

export const keysSchema = z.union([z.literal('read'), z.literal('write')]);

export const organizationPlan2Schema = z.union([z.literal('read'), z.literal('write')]);

export const securityScanningAlertSchema = z.union([z.literal('read'), z.literal('write')]);

export const workflows2Schema = z.union([z.literal('read'), z.literal('write')]);

export const status10Schema = z.union([
  z.literal('requested'),
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('queued'),
  z.literal('pending'),
]);

export const webhookCheckSuiteRequestedSchema = z.object({
  action: z.literal('requested'),
  actions_meta: z.record(z.unknown()).optional().nullable(),
  check_suite: z.object({
    after: z.string().nullable(),
    app: z.object({
      created_at: z.string().nullable(),
      description: z.string().nullable(),
      events: z
        .array(
          z.union([
            z.literal('branch_protection_rule'),
            z.literal('check_run'),
            z.literal('check_suite'),
            z.literal('code_scanning_alert'),
            z.literal('commit_comment'),
            z.literal('content_reference'),
            z.literal('create'),
            z.literal('delete'),
            z.literal('deployment'),
            z.literal('deployment_review'),
            z.literal('deployment_status'),
            z.literal('deploy_key'),
            z.literal('discussion'),
            z.literal('discussion_comment'),
            z.literal('fork'),
            z.literal('gollum'),
            z.literal('issues'),
            z.literal('issue_comment'),
            z.literal('label'),
            z.literal('member'),
            z.literal('membership'),
            z.literal('milestone'),
            z.literal('organization'),
            z.literal('org_block'),
            z.literal('page_build'),
            z.literal('project'),
            z.literal('project_card'),
            z.literal('project_column'),
            z.literal('public'),
            z.literal('pull_request'),
            z.literal('pull_request_review'),
            z.literal('pull_request_review_comment'),
            z.literal('push'),
            z.literal('registry_package'),
            z.literal('release'),
            z.literal('repository'),
            z.literal('repository_dispatch'),
            z.literal('secret_scanning_alert'),
            z.literal('star'),
            z.literal('status'),
            z.literal('team'),
            z.literal('team_add'),
            z.literal('watch'),
            z.literal('workflow_dispatch'),
            z.literal('workflow_run'),
            z.literal('pull_request_review_thread'),
            z.literal('workflow_job'),
            z.literal('merge_queue_entry'),
            z.literal('security_and_analysis'),
            z.literal('secret_scanning_alert_location'),
            z.literal('projects_v2_item'),
            z.literal('merge_group'),
            z.literal('repository_import'),
          ]),
        )
        .optional(),
      external_url: z.string().nullable(),
      html_url: z.string(),
      id: z.number().nullable(),
      name: z.string(),
      node_id: z.string(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          actions: z.union([z.literal('read'), z.literal('write')]).optional(),
          administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          checks: z.union([z.literal('read'), z.literal('write')]).optional(),
          content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
          contents: z.union([z.literal('read'), z.literal('write')]).optional(),
          deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
          discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          emails: z.union([z.literal('read'), z.literal('write')]).optional(),
          environments: z.union([z.literal('read'), z.literal('write')]).optional(),
          issues: z.union([z.literal('read'), z.literal('write')]).optional(),
          keys: z.union([z.literal('read'), z.literal('write')]).optional(),
          members: z.union([z.literal('read'), z.literal('write')]).optional(),
          metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
          packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
          single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
          statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
          team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
        })
        .optional(),
      slug: z.string().optional(),
      updated_at: z.string().nullable(),
    }),
    before: z.string().nullable(),
    check_runs_url: z.string(),
    conclusion: z
      .union([
        z.literal('success'),
        z.literal('failure'),
        z.literal('neutral'),
        z.literal('cancelled'),
        z.literal('timed_out'),
        z.literal('action_required'),
        z.literal('stale'),
        z.literal('skipped'),
      ])
      .nullable(),
    created_at: z.string(),
    head_branch: z.string().nullable(),
    head_commit: z.object({
      author: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      committer: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      id: z.string(),
      message: z.string(),
      timestamp: z.string(),
      tree_id: z.string(),
    }),
    head_sha: z.string(),
    id: z.number(),
    latest_check_runs_count: z.number(),
    node_id: z.string(),
    pull_requests: z.array(
      z.object({
        base: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        head: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        id: z.number(),
        number: z.number(),
        url: z.string(),
      }),
    ),
    rerequestable: z.boolean().optional(),
    runs_rerequestable: z.boolean().optional(),
    status: z
      .union([z.literal('requested'), z.literal('in_progress'), z.literal('completed'), z.literal('queued')])
      .nullable(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action7Schema = z.literal('requested');

export const conclusion4Schema = z.union([
  z.literal('success'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('cancelled'),
  z.literal('timed_out'),
  z.literal('action_required'),
  z.literal('stale'),
  z.literal('skipped'),
]);

export const status11Schema = z.union([
  z.literal('requested'),
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('queued'),
]);

export const webhookCheckSuiteRerequestedSchema = z.object({
  action: z.literal('rerequested'),
  actions_meta: z
    .object({
      rerun_info: z
        .object({
          job_ids: z.array(z.string()).optional(),
          plan_id: z.string().optional(),
        })
        .optional(),
    })
    .optional()
    .nullable(),
  check_suite: z.object({
    after: z.string().nullable(),
    app: z.object({
      created_at: z.string().nullable(),
      description: z.string().nullable(),
      events: z
        .array(
          z.union([
            z.literal('branch_protection_rule'),
            z.literal('check_run'),
            z.literal('check_suite'),
            z.literal('code_scanning_alert'),
            z.literal('commit_comment'),
            z.literal('content_reference'),
            z.literal('create'),
            z.literal('delete'),
            z.literal('deployment'),
            z.literal('deployment_review'),
            z.literal('deployment_status'),
            z.literal('deploy_key'),
            z.literal('discussion'),
            z.literal('discussion_comment'),
            z.literal('fork'),
            z.literal('gollum'),
            z.literal('issues'),
            z.literal('issue_comment'),
            z.literal('label'),
            z.literal('member'),
            z.literal('membership'),
            z.literal('milestone'),
            z.literal('organization'),
            z.literal('org_block'),
            z.literal('page_build'),
            z.literal('project'),
            z.literal('project_card'),
            z.literal('project_column'),
            z.literal('public'),
            z.literal('pull_request'),
            z.literal('pull_request_review'),
            z.literal('pull_request_review_comment'),
            z.literal('push'),
            z.literal('registry_package'),
            z.literal('release'),
            z.literal('repository'),
            z.literal('repository_dispatch'),
            z.literal('secret_scanning_alert'),
            z.literal('star'),
            z.literal('status'),
            z.literal('team'),
            z.literal('team_add'),
            z.literal('watch'),
            z.literal('workflow_dispatch'),
            z.literal('workflow_run'),
            z.literal('pull_request_review_thread'),
            z.literal('merge_queue_entry'),
            z.literal('workflow_job'),
          ]),
        )
        .optional(),
      external_url: z.string().nullable(),
      html_url: z.string(),
      id: z.number().nullable(),
      name: z.string(),
      node_id: z.string(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          actions: z.union([z.literal('read'), z.literal('write')]).optional(),
          administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          checks: z.union([z.literal('read'), z.literal('write')]).optional(),
          content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
          contents: z.union([z.literal('read'), z.literal('write')]).optional(),
          deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
          discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          emails: z.union([z.literal('read'), z.literal('write')]).optional(),
          environments: z.union([z.literal('read'), z.literal('write')]).optional(),
          issues: z.union([z.literal('read'), z.literal('write')]).optional(),
          keys: z.union([z.literal('read'), z.literal('write')]).optional(),
          members: z.union([z.literal('read'), z.literal('write')]).optional(),
          metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
          organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
          packages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pages: z.union([z.literal('read'), z.literal('write')]).optional(),
          pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
          repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
          secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
          security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
          single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
          statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
          team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
          vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
          workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
        })
        .optional(),
      slug: z.string().optional(),
      updated_at: z.string().nullable(),
    }),
    before: z.string().nullable(),
    check_runs_url: z.string(),
    conclusion: z
      .union([
        z.literal('success'),
        z.literal('failure'),
        z.literal('neutral'),
        z.literal('cancelled'),
        z.literal('timed_out'),
        z.literal('action_required'),
        z.literal('stale'),
      ])
      .nullable(),
    created_at: z.string(),
    head_branch: z.string().nullable(),
    head_commit: z.object({
      author: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      committer: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      id: z.string(),
      message: z.string(),
      timestamp: z.string(),
      tree_id: z.string(),
    }),
    head_sha: z.string(),
    id: z.number(),
    latest_check_runs_count: z.number(),
    node_id: z.string(),
    pull_requests: z.array(
      z.object({
        base: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        head: z.object({
          ref: z.string(),
          repo: z.object({
            id: z.number(),
            name: z.string(),
            url: z.string(),
          }),
          sha: z.string(),
        }),
        id: z.number(),
        number: z.number(),
        url: z.string(),
      }),
    ),
    rerequestable: z.boolean().optional(),
    runs_rerequestable: z.boolean().optional(),
    status: z
      .union([z.literal('requested'), z.literal('in_progress'), z.literal('completed'), z.literal('queued')])
      .nullable(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const conclusion5Schema = z.union([
  z.literal('success'),
  z.literal('failure'),
  z.literal('neutral'),
  z.literal('cancelled'),
  z.literal('timed_out'),
  z.literal('action_required'),
  z.literal('stale'),
]);

export const webhookCodeScanningAlertAppearedInBranchSchema = z.object({
  action: z.literal('appeared_in_branch'),
  alert: z.object({
    created_at: z.string(),
    dismissed_at: z.string().nullable(),
    dismissed_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    dismissed_reason: z.union([z.literal('false positive'), z.literal('won')]),
  }),
});

export const action8Schema = z.literal('appeared_in_branch');

export const dismissedReason2Schema = z.union([
  z.literal('false positive'),
  z.literal("won't fix"),
  z.literal('used in tests'),
]);

export const webhookCodeScanningAlertClosedByUserSchema = z.object({
  action: z.literal('closed_by_user'),
  alert: z.object({
    created_at: z.string(),
    dismissed_at: z.string(),
    dismissed_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    dismissed_reason: z.union([z.literal('false positive'), z.literal('won')]),
  }),
});

export const action9Schema = z.literal('closed_by_user');

export const webhookCodeScanningAlertCreatedSchema = z.object({
  action: z.literal('created'),
  alert: z.object({
    created_at: z.string().nullable(),
    dismissed_at: z.unknown(),
    dismissed_by: z.unknown(),
    dismissed_comment: codeScanningAlertDismissedCommentSchema.optional(),
    dismissed_reason: z.unknown(),
    fixed_at: z.unknown().optional(),
    html_url: z.string(),
    instances_url: z.string().optional(),
    most_recent_instance: z
      .object({
        analysis_key: z.string(),
        classifications: z.array(z.string()).optional(),
        commit_sha: z.string().optional(),
        environment: z.string(),
        location: z
          .object({
            end_column: z.number().optional(),
            end_line: z.number().optional(),
            path: z.string().optional(),
            start_column: z.number().optional(),
            start_line: z.number().optional(),
          })
          .optional(),
        message: z
          .object({
            text: z.string().optional(),
          })
          .optional(),
        ref: z.string(),
        state: z.union([z.literal('open'), z.literal('dismissed'), z.literal('fixed')]),
      })
      .optional()
      .nullable(),
    number: z.number(),
    rule: z.object({
      description: z.string(),
      full_description: z.string().optional(),
      help: z.string().optional().nullable(),
      help_uri: z.string().optional().nullable(),
      id: z.string(),
      name: z.string().optional(),
      severity: z.union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')]).nullable(),
      tags: z.array(z.string()).optional().nullable(),
    }),
    state: z.union([z.literal('open'), z.literal('dismissed')]),
    tool: z
      .object({
        guid: z.string().optional().nullable(),
        name: z.string(),
        version: z.string().nullable(),
      })
      .nullable(),
    updated_at: z.string().optional().nullable(),
    url: z.string(),
  }),
  commit_oid: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  ref: z.string(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookCodeScanningAlertFixedSchema = z.object({
  action: z.literal('fixed'),
  alert: z.object({
    created_at: z.string(),
    dismissed_at: z.string().nullable(),
    dismissed_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    dismissed_reason: z.union([z.literal('false positive'), z.literal('won')]),
  }),
});

export const action10Schema = z.literal('fixed');

export const webhookCodeScanningAlertReopenedSchema = z.object({
  action: z.literal('reopened'),
  alert: z
    .object({
      created_at: z.string(),
      dismissed_at: z.string().nullable(),
      dismissed_by: z.record(z.unknown()).nullable(),
      dismissed_reason: z.string().nullable(),
      html_url: z.string(),
      most_recent_instance: z
        .object({
          analysis_key: z.string(),
          classifications: z.array(z.string()).optional(),
          commit_sha: z.string().optional(),
          environment: z.string(),
          location: z
            .object({
              end_column: z.number().optional(),
              end_line: z.number().optional(),
              path: z.string().optional(),
              start_column: z.number().optional(),
              start_line: z.number().optional(),
            })
            .optional(),
          message: z
            .object({
              text: z.string().optional(),
            })
            .optional(),
          ref: z.string(),
          state: z.union([z.literal('open'), z.literal('dismissed'), z.literal('fixed')]),
        })
        .optional()
        .nullable(),
      number: z.number(),
      rule: z.object({
        description: z.string(),
        full_description: z.string().optional(),
        help: z.string().optional().nullable(),
        help_uri: z.string().optional().nullable(),
        id: z.string(),
        name: z.string().optional(),
        severity: z.union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')]).nullable(),
        tags: z.array(z.string()).optional().nullable(),
      }),
      state: z.union([z.literal('open'), z.literal('dismissed'), z.literal('fixed')]),
      tool: z.object({
        guid: z.string().optional().nullable(),
        name: z.string(),
        version: z.string().nullable(),
      }),
      url: z.string(),
    })
    .nullable(),
  commit_oid: z.string().nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  ref: z.string().nullable(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action11Schema = z.literal('reopened');

export const webhookCodeScanningAlertReopenedByUserSchema = z.object({
  action: z.literal('reopened_by_user'),
  alert: z.object({
    created_at: z.string(),
    dismissed_at: z.unknown(),
    dismissed_by: z.unknown(),
    dismissed_reason: z.unknown(),
    html_url: z.string(),
    most_recent_instance: z
      .object({
        analysis_key: z.string(),
        classifications: z.array(z.string()).optional(),
        commit_sha: z.string().optional(),
        environment: z.string(),
        location: z
          .object({
            end_column: z.number().optional(),
            end_line: z.number().optional(),
            path: z.string().optional(),
            start_column: z.number().optional(),
            start_line: z.number().optional(),
          })
          .optional(),
        message: z
          .object({
            text: z.string().optional(),
          })
          .optional(),
        ref: z.string(),
        state: z.union([z.literal('open'), z.literal('dismissed'), z.literal('fixed')]),
      })
      .optional()
      .nullable(),
    number: z.number(),
    rule: z.object({
      description: z.string(),
      id: z.string(),
      severity: z.union([z.literal('none'), z.literal('note'), z.literal('warning'), z.literal('error')]).nullable(),
    }),
    state: z.union([z.literal('open'), z.literal('fixed')]),
    tool: z.object({
      name: z.string(),
      version: z.string().nullable(),
    }),
    url: z.string(),
  }),
  commit_oid: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  ref: z.string(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action12Schema = z.literal('reopened_by_user');

export const webhookCommitCommentCreatedSchema = z.object({
  action: z.literal('created'),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    commit_id: z.string(),
    created_at: z.string(),
    html_url: z.string(),
    id: z.number(),
    line: z.number().nullable(),
    node_id: z.string(),
    path: z.string().nullable(),
    position: z.number().nullable(),
    reactions: z
      .object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      })
      .optional(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookConfigSchema = z.object({
  content_type: webhookConfigContentTypeSchema.optional(),
  insecure_ssl: webhookConfigInsecureSslSchema.optional(),
  secret: webhookConfigSecretSchema.optional(),
  url: webhookConfigUrlSchema.optional(),
});

export const webhookCreateSchema = z.object({
  description: z.string().nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  master_branch: z.string(),
  organization: organizationSimpleSchema.optional(),
  pusher_type: z.string(),
  ref: z.string(),
  ref_type: z.union([z.literal('tag'), z.literal('branch')]),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const refTypeSchema = z.union([z.literal('tag'), z.literal('branch')]);

export const webhookDeleteSchema = z.object({
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  pusher_type: z.string(),
  ref: z.string(),
  ref_type: z.union([z.literal('tag'), z.literal('branch')]),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const dependabotAlertSchema = z.object({
  created_at: alertCreatedAtSchema,
  dependency: z.object({
    manifest_path: z.string().optional(),
    package: dependabotAlertPackageSchema.optional(),
    scope: z
      .union([z.literal('development'), z.literal('runtime')])
      .optional()
      .nullable(),
  }),
  dismissed_at: alertDismissedAtSchema,
  dismissed_by: nullableSimpleUserSchema,
  dismissed_comment: z.string().nullable(),
  dismissed_reason: z
    .union([
      z.literal('fix_started'),
      z.literal('inaccurate'),
      z.literal('no_bandwidth'),
      z.literal('not_used'),
      z.literal('tolerable_risk'),
    ])
    .nullable(),
  fixed_at: alertFixedAtSchema,
  html_url: alertHtmlUrlSchema,
  number: alertNumberSchema,
  security_advisory: dependabotAlertSecurityAdvisorySchema,
  security_vulnerability: dependabotAlertSecurityVulnerabilitySchema,
  state: z.union([z.literal('dismissed'), z.literal('fixed'), z.literal('open')]),
  updated_at: alertUpdatedAtSchema,
  url: alertUrlSchema,
});

export const webhookDependabotAlertDismissedSchema = z.object({
  action: z.literal('dismissed'),
  alert: dependabotAlertSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action13Schema = z.literal('dismissed');

export const webhookDependabotAlertFixedSchema = z.object({
  action: z.literal('fixed'),
  alert: dependabotAlertSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDependabotAlertReintroducedSchema = z.object({
  action: z.literal('reintroduced'),
  alert: dependabotAlertSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action14Schema = z.literal('reintroduced');

export const webhookDependabotAlertReopenedSchema = z.object({
  action: z.literal('reopened'),
  alert: dependabotAlertSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDeployKeyCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  key: z.object({
    added_by: z.string().optional().nullable(),
    created_at: z.string(),
    id: z.number(),
    key: z.string(),
    last_used: z.string().optional().nullable(),
    read_only: z.boolean(),
    title: z.string(),
    url: z.string(),
    verified: z.boolean(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDeployKeyDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  key: z.object({
    added_by: z.string().optional().nullable(),
    created_at: z.string(),
    id: z.number(),
    key: z.string(),
    last_used: z.string().optional().nullable(),
    read_only: z.boolean(),
    title: z.string(),
    url: z.string(),
    verified: z.boolean(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDeploymentCreatedSchema = z.object({
  action: z.literal('created'),
  deployment: z.object({
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    environment: z.string(),
    id: z.number(),
    node_id: z.string(),
    original_environment: z.string(),
    payload: z.union([z.record(z.unknown()), z.string()]),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('workflow_job'),
              z.literal('pull_request_review_thread'),
              z.literal('merge_queue_entry'),
              z.literal('secret_scanning_alert_location'),
              z.literal('merge_group'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    production_environment: z.boolean().optional(),
    ref: z.string(),
    repository_url: z.string(),
    sha: z.string(),
    statuses_url: z.string(),
    task: z.string(),
    transient_environment: z.boolean().optional(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
  workflow: z
    .object({
      badge_url: z.string(),
      created_at: z.string(),
      html_url: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      path: z.string(),
      state: z.string(),
      updated_at: z.string(),
      url: z.string(),
    })
    .nullable(),
  workflow_run: z
    .object({
      actor: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      artifacts_url: z.string().optional(),
      cancel_url: z.string().optional(),
      check_suite_id: z.number(),
      check_suite_node_id: z.string(),
      check_suite_url: z.string().optional(),
      conclusion: z
        .union([
          z.literal('success'),
          z.literal('failure'),
          z.literal('neutral'),
          z.literal('cancelled'),
          z.literal('timed_out'),
          z.literal('action_required'),
          z.literal('stale'),
        ])
        .nullable(),
      created_at: z.string(),
      display_title: z.string(),
      event: z.string(),
      head_branch: z.string(),
      head_commit: z.unknown().optional(),
      head_repository: z
        .object({
          archive_url: z.string().optional(),
          assignees_url: z.string().optional(),
          blobs_url: z.string().optional(),
          branches_url: z.string().optional(),
          collaborators_url: z.string().optional(),
          comments_url: z.string().optional(),
          commits_url: z.string().optional(),
          compare_url: z.string().optional(),
          contents_url: z.string().optional(),
          contributors_url: z.string().optional(),
          deployments_url: z.string().optional(),
          description: z.unknown().optional(),
          downloads_url: z.string().optional(),
          events_url: z.string().optional(),
          fork: z.boolean().optional(),
          forks_url: z.string().optional(),
          full_name: z.string().optional(),
          git_commits_url: z.string().optional(),
          git_refs_url: z.string().optional(),
          git_tags_url: z.string().optional(),
          hooks_url: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          issue_comment_url: z.string().optional(),
          issue_events_url: z.string().optional(),
          issues_url: z.string().optional(),
          keys_url: z.string().optional(),
          labels_url: z.string().optional(),
          languages_url: z.string().optional(),
          merges_url: z.string().optional(),
          milestones_url: z.string().optional(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          notifications_url: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number().optional(),
              login: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.string().optional(),
              url: z.string().optional(),
            })
            .optional(),
          private: z.boolean().optional(),
          pulls_url: z.string().optional(),
          releases_url: z.string().optional(),
          stargazers_url: z.string().optional(),
          statuses_url: z.string().optional(),
          subscribers_url: z.string().optional(),
          subscription_url: z.string().optional(),
          tags_url: z.string().optional(),
          teams_url: z.string().optional(),
          trees_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      head_sha: z.string(),
      html_url: z.string(),
      id: z.number(),
      jobs_url: z.string().optional(),
      logs_url: z.string().optional(),
      name: z.string(),
      node_id: z.string(),
      path: z.string(),
      previous_attempt_url: z.unknown().optional(),
      pull_requests: z.array(
        z.object({
          base: z.object({
            ref: z.string(),
            repo: z.object({
              id: z.number(),
              name: z.string(),
              url: z.string(),
            }),
            sha: z.string(),
          }),
          head: z.object({
            ref: z.string(),
            repo: z.object({
              id: z.number(),
              name: z.string(),
              url: z.string(),
            }),
            sha: z.string(),
          }),
          id: z.number(),
          number: z.number(),
          url: z.string(),
        }),
      ),
      referenced_workflows: z
        .array(
          z.object({
            path: z.string(),
            ref: z.string().optional(),
            sha: z.string(),
          }),
        )
        .optional()
        .nullable(),
      repository: z
        .object({
          archive_url: z.string().optional(),
          assignees_url: z.string().optional(),
          blobs_url: z.string().optional(),
          branches_url: z.string().optional(),
          collaborators_url: z.string().optional(),
          comments_url: z.string().optional(),
          commits_url: z.string().optional(),
          compare_url: z.string().optional(),
          contents_url: z.string().optional(),
          contributors_url: z.string().optional(),
          deployments_url: z.string().optional(),
          description: z.unknown().optional(),
          downloads_url: z.string().optional(),
          events_url: z.string().optional(),
          fork: z.boolean().optional(),
          forks_url: z.string().optional(),
          full_name: z.string().optional(),
          git_commits_url: z.string().optional(),
          git_refs_url: z.string().optional(),
          git_tags_url: z.string().optional(),
          hooks_url: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          issue_comment_url: z.string().optional(),
          issue_events_url: z.string().optional(),
          issues_url: z.string().optional(),
          keys_url: z.string().optional(),
          labels_url: z.string().optional(),
          languages_url: z.string().optional(),
          merges_url: z.string().optional(),
          milestones_url: z.string().optional(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          notifications_url: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number().optional(),
              login: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.string().optional(),
              url: z.string().optional(),
            })
            .optional(),
          private: z.boolean().optional(),
          pulls_url: z.string().optional(),
          releases_url: z.string().optional(),
          stargazers_url: z.string().optional(),
          statuses_url: z.string().optional(),
          subscribers_url: z.string().optional(),
          subscription_url: z.string().optional(),
          tags_url: z.string().optional(),
          teams_url: z.string().optional(),
          trees_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      rerun_url: z.string().optional(),
      run_attempt: z.number(),
      run_number: z.number(),
      run_started_at: z.string(),
      status: z.union([
        z.literal('requested'),
        z.literal('in_progress'),
        z.literal('completed'),
        z.literal('queued'),
        z.literal('waiting'),
        z.literal('pending'),
      ]),
      triggering_actor: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      updated_at: z.string(),
      url: z.string(),
      workflow_id: z.number(),
      workflow_url: z.string().optional(),
    })
    .nullable(),
});

export const organizationProjects2Schema = z.union([z.literal('read'), z.literal('write')]);

export const repositoryProjects2Schema = z.union([z.literal('read'), z.literal('write')]);

export const status12Schema = z.union([
  z.literal('requested'),
  z.literal('in_progress'),
  z.literal('completed'),
  z.literal('queued'),
  z.literal('waiting'),
  z.literal('pending'),
]);

export const webhookDeploymentStatusCreatedSchema = z.object({
  action: z.literal('created'),
  check_run: z
    .object({
      completed_at: z.string().nullable(),
      conclusion: z
        .union([
          z.literal('success'),
          z.literal('failure'),
          z.literal('neutral'),
          z.literal('cancelled'),
          z.literal('timed_out'),
          z.literal('action_required'),
          z.literal('stale'),
          z.literal('skipped'),
        ])
        .nullable(),
      details_url: z.string(),
      external_id: z.string(),
      head_sha: z.string(),
      html_url: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      started_at: z.string(),
      status: z.union([
        z.literal('queued'),
        z.literal('in_progress'),
        z.literal('completed'),
        z.literal('waiting'),
        z.literal('pending'),
      ]),
      url: z.string(),
    })
    .optional()
    .nullable(),
  deployment: z.object({
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    environment: z.string(),
    id: z.number(),
    node_id: z.string(),
    original_environment: z.string(),
    payload: z.union([z.string(), z.record(z.unknown())]).nullable(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('merge_queue_entry'),
              z.literal('workflow_job'),
              z.literal('pull_request_review_thread'),
              z.literal('secret_scanning_alert_location'),
              z.literal('merge_group'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    production_environment: z.boolean().optional(),
    ref: z.string(),
    repository_url: z.string(),
    sha: z.string(),
    statuses_url: z.string(),
    task: z.string(),
    transient_environment: z.boolean().optional(),
    updated_at: z.string(),
    url: z.string(),
  }),
  deployment_status: z.object({
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    deployment_url: z.string(),
    description: z.string(),
    environment: z.string(),
    environment_url: z.string().optional(),
    id: z.number(),
    log_url: z.string().optional(),
    node_id: z.string(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('pull_request_review_thread'),
              z.literal('merge_queue_entry'),
              z.literal('workflow_job'),
              z.literal('merge_group'),
              z.literal('secret_scanning_alert_location'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    repository_url: z.string(),
    state: z.string(),
    target_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
  workflow: z
    .object({
      badge_url: z.string(),
      created_at: z.string(),
      html_url: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      path: z.string(),
      state: z.string(),
      updated_at: z.string(),
      url: z.string(),
    })
    .optional()
    .nullable(),
  workflow_run: z
    .object({
      actor: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      artifacts_url: z.string().optional(),
      cancel_url: z.string().optional(),
      check_suite_id: z.number(),
      check_suite_node_id: z.string(),
      check_suite_url: z.string().optional(),
      conclusion: z
        .union([
          z.literal('success'),
          z.literal('failure'),
          z.literal('neutral'),
          z.literal('cancelled'),
          z.literal('timed_out'),
          z.literal('action_required'),
          z.literal('stale'),
          z.literal('startup_failure'),
        ])
        .nullable(),
      created_at: z.string(),
      display_title: z.string(),
      event: z.string(),
      head_branch: z.string(),
      head_commit: z.unknown().optional(),
      head_repository: z
        .object({
          archive_url: z.string().optional(),
          assignees_url: z.string().optional(),
          blobs_url: z.string().optional(),
          branches_url: z.string().optional(),
          collaborators_url: z.string().optional(),
          comments_url: z.string().optional(),
          commits_url: z.string().optional(),
          compare_url: z.string().optional(),
          contents_url: z.string().optional(),
          contributors_url: z.string().optional(),
          deployments_url: z.string().optional(),
          description: z.unknown().optional(),
          downloads_url: z.string().optional(),
          events_url: z.string().optional(),
          fork: z.boolean().optional(),
          forks_url: z.string().optional(),
          full_name: z.string().optional(),
          git_commits_url: z.string().optional(),
          git_refs_url: z.string().optional(),
          git_tags_url: z.string().optional(),
          hooks_url: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          issue_comment_url: z.string().optional(),
          issue_events_url: z.string().optional(),
          issues_url: z.string().optional(),
          keys_url: z.string().optional(),
          labels_url: z.string().optional(),
          languages_url: z.string().optional(),
          merges_url: z.string().optional(),
          milestones_url: z.string().optional(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          notifications_url: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number().optional(),
              login: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.string().optional(),
              url: z.string().optional(),
            })
            .optional(),
          private: z.boolean().optional(),
          pulls_url: z.string().optional(),
          releases_url: z.string().optional(),
          stargazers_url: z.string().optional(),
          statuses_url: z.string().optional(),
          subscribers_url: z.string().optional(),
          subscription_url: z.string().optional(),
          tags_url: z.string().optional(),
          teams_url: z.string().optional(),
          trees_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      head_sha: z.string(),
      html_url: z.string(),
      id: z.number(),
      jobs_url: z.string().optional(),
      logs_url: z.string().optional(),
      name: z.string(),
      node_id: z.string(),
      path: z.string(),
      previous_attempt_url: z.unknown().optional(),
      pull_requests: z.array(
        z.object({
          base: z.object({
            ref: z.string(),
            repo: z.object({
              id: z.number(),
              name: z.string(),
              url: z.string(),
            }),
            sha: z.string(),
          }),
          head: z.object({
            ref: z.string(),
            repo: z.object({
              id: z.number(),
              name: z.string(),
              url: z.string(),
            }),
            sha: z.string(),
          }),
          id: z.number(),
          number: z.number(),
          url: z.string(),
        }),
      ),
      referenced_workflows: z
        .array(
          z.object({
            path: z.string(),
            ref: z.string().optional(),
            sha: z.string(),
          }),
        )
        .optional()
        .nullable(),
      repository: z
        .object({
          archive_url: z.string().optional(),
          assignees_url: z.string().optional(),
          blobs_url: z.string().optional(),
          branches_url: z.string().optional(),
          collaborators_url: z.string().optional(),
          comments_url: z.string().optional(),
          commits_url: z.string().optional(),
          compare_url: z.string().optional(),
          contents_url: z.string().optional(),
          contributors_url: z.string().optional(),
          deployments_url: z.string().optional(),
          description: z.unknown().optional(),
          downloads_url: z.string().optional(),
          events_url: z.string().optional(),
          fork: z.boolean().optional(),
          forks_url: z.string().optional(),
          full_name: z.string().optional(),
          git_commits_url: z.string().optional(),
          git_refs_url: z.string().optional(),
          git_tags_url: z.string().optional(),
          hooks_url: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number().optional(),
          issue_comment_url: z.string().optional(),
          issue_events_url: z.string().optional(),
          issues_url: z.string().optional(),
          keys_url: z.string().optional(),
          labels_url: z.string().optional(),
          languages_url: z.string().optional(),
          merges_url: z.string().optional(),
          milestones_url: z.string().optional(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          notifications_url: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number().optional(),
              login: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.string().optional(),
              url: z.string().optional(),
            })
            .optional(),
          private: z.boolean().optional(),
          pulls_url: z.string().optional(),
          releases_url: z.string().optional(),
          stargazers_url: z.string().optional(),
          statuses_url: z.string().optional(),
          subscribers_url: z.string().optional(),
          subscription_url: z.string().optional(),
          tags_url: z.string().optional(),
          teams_url: z.string().optional(),
          trees_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      rerun_url: z.string().optional(),
      run_attempt: z.number(),
      run_number: z.number(),
      run_started_at: z.string(),
      status: z.union([
        z.literal('requested'),
        z.literal('in_progress'),
        z.literal('completed'),
        z.literal('queued'),
        z.literal('waiting'),
        z.literal('pending'),
      ]),
      triggering_actor: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      updated_at: z.string(),
      url: z.string(),
      workflow_id: z.number(),
      workflow_url: z.string().optional(),
    })
    .optional()
    .nullable(),
});

export const webhookDiscussionAnsweredSchema = z.object({
  action: z.literal('answered'),
  answer: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    child_comment_count: z.number(),
    created_at: z.string(),
    discussion_id: z.number(),
    html_url: z.string(),
    id: z.number(),
    node_id: z.string(),
    parent_id: z.unknown(),
    reactions: z
      .object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      })
      .optional(),
    repository_url: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action15Schema = z.literal('answered');

export const webhookDiscussionCategoryChangedSchema = z.object({
  action: z.literal('category_changed'),
  changes: z.object({
    category: z.object({
      from: z.object({
        created_at: z.string(),
        description: z.string(),
        emoji: z.string(),
        id: z.number(),
        is_answerable: z.boolean(),
        name: z.string(),
        node_id: z.string().optional(),
        repository_id: z.number(),
        slug: z.string(),
        updated_at: z.string(),
      }),
    }),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action16Schema = z.literal('category_changed');

export const webhookDiscussionCommentCreatedSchema = z.object({
  action: z.literal('created'),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    child_comment_count: z.number(),
    created_at: z.string(),
    discussion_id: z.number(),
    html_url: z.string(),
    id: z.number(),
    node_id: z.string(),
    parent_id: z.number().nullable(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionCommentDeletedSchema = z.object({
  action: z.literal('deleted'),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    child_comment_count: z.number(),
    created_at: z.string(),
    discussion_id: z.number(),
    html_url: z.string(),
    id: z.number(),
    node_id: z.string(),
    parent_id: z.number().nullable(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionCommentEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    body: z.object({
      from: z.string(),
    }),
  }),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    child_comment_count: z.number(),
    created_at: z.string(),
    discussion_id: z.number(),
    html_url: z.string(),
    id: z.number(),
    node_id: z.string(),
    parent_id: z.number().nullable(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionCreatedSchema = z.object({
  action: z.literal('created'),
  discussion: z
    .object({
      active_lock_reason: z.string().nullable(),
      answer_chosen_at: z.string().nullable(),
      answer_chosen_by: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      answer_html_url: z.string().nullable(),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      category: z.object({
        created_at: z.string(),
        description: z.string(),
        emoji: z.string(),
        id: z.number(),
        is_answerable: z.boolean(),
        name: z.string(),
        node_id: z.string().optional(),
        repository_id: z.number(),
        slug: z.string(),
        updated_at: z.string(),
      }),
      comments: z.number(),
      created_at: z.string(),
      html_url: z.string(),
      id: z.number(),
      locked: z.boolean(),
      node_id: z.string(),
      number: z.number(),
      reactions: z
        .object({
          '+1': z.number(),
          '-1': z.number(),
          confused: z.number(),
          eyes: z.number(),
          heart: z.number(),
          hooray: z.number(),
          laugh: z.number(),
          rocket: z.number(),
          total_count: z.number(),
          url: z.string(),
        })
        .optional(),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('locked'), z.literal('converting'), z.literal('transferring')]),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.unknown().optional(),
        answer_chosen_at: z.unknown(),
        answer_chosen_by: z.unknown(),
        answer_html_url: z.string().nullable(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        category: z
          .object({
            created_at: z.string().optional(),
            description: z.string().optional(),
            emoji: z.string().optional(),
            id: z.number().optional(),
            is_answerable: z.boolean().optional(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            repository_id: z.number().optional(),
            slug: z.string().optional(),
            updated_at: z.string().optional(),
          })
          .optional(),
        comments: z.number().optional(),
        created_at: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        locked: z.boolean(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('open'), z.literal('converting'), z.literal('transferring')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionDeletedSchema = z.object({
  action: z.literal('deleted'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z
    .object({
      body: z
        .object({
          from: z.string(),
        })
        .optional(),
      title: z
        .object({
          from: z.string(),
        })
        .optional(),
    })
    .optional(),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookDiscussionLabeledSchema = z.object({
  action: z.literal('labeled'),
  discussion: z.object({
    active_lock_reason: z.string().nullable(),
    answer_chosen_at: z.string().nullable(),
    answer_chosen_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    answer_html_url: z.string().nullable(),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    category: z.object({
      created_at: z.string(),
      description: z.string(),
      emoji: z.string(),
      id: z.number(),
      is_answerable: z.boolean(),
      name: z.string(),
      node_id: z.string().optional(),
      repository_id: z.number(),
      slug: z.string(),
      updated_at: z.string(),
    }),
    comments: z.number(),
    created_at: z.string(),
    html_url: z.string(),
    id: z.number(),
    locked: z.boolean(),
    node_id: z.string(),
    number: z.number(),
    reactions: z
      .object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      })
      .optional(),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('locked'), z.literal('converting'), z.literal('transferring')]),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  label: z.object({
    color: z.string(),
    default: z.boolean(),
    description: z.string().nullable(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action17Schema = z.literal('labeled');

export const webhookDiscussionLockedSchema = z.object({
  action: z.literal('locked'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action18Schema = z.literal('locked');

export const webhookDiscussionPinnedSchema = z.object({
  action: z.literal('pinned'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action19Schema = z.literal('pinned');

export const webhookDiscussionTransferredSchema = z.object({
  action: z.literal('transferred'),
  changes: z.object({
    new_discussion: z.object({
      active_lock_reason: z.string().nullable(),
      answer_chosen_at: z.string().nullable(),
      answer_chosen_by: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      answer_html_url: z.string().nullable(),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string(),
      category: z.object({
        created_at: z.string(),
        description: z.string(),
        emoji: z.string(),
        id: z.number(),
        is_answerable: z.boolean(),
        name: z.string(),
        node_id: z.string().optional(),
        repository_id: z.number(),
        slug: z.string(),
        updated_at: z.string(),
      }),
      comments: z.number(),
      created_at: z.string(),
      html_url: z.string(),
      id: z.number(),
      locked: z.boolean(),
      node_id: z.string(),
      number: z.number(),
      reactions: z
        .object({
          '+1': z.number(),
          '-1': z.number(),
          confused: z.number(),
          eyes: z.number(),
          heart: z.number(),
          hooray: z.number(),
          laugh: z.number(),
          rocket: z.number(),
          total_count: z.number(),
          url: z.string(),
        })
        .optional(),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('locked'), z.literal('converting'), z.literal('transferring')]),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    new_repository: z.object({
      allow_auto_merge: z.boolean().optional(),
      allow_forking: z.boolean().optional(),
      allow_merge_commit: z.boolean().optional(),
      allow_rebase_merge: z.boolean().optional(),
      allow_squash_merge: z.boolean().optional(),
      allow_update_branch: z.boolean().optional(),
      archive_url: z.string(),
      archived: z.boolean(),
      assignees_url: z.string(),
      blobs_url: z.string(),
      branches_url: z.string(),
      clone_url: z.string(),
      collaborators_url: z.string(),
      comments_url: z.string(),
      commits_url: z.string(),
      compare_url: z.string(),
      contents_url: z.string(),
      contributors_url: z.string(),
      created_at: z.union([z.number(), z.string()]),
      default_branch: z.string(),
      delete_branch_on_merge: z.boolean().optional(),
      deployments_url: z.string(),
      description: z.string().nullable(),
      disabled: z.boolean().optional(),
      downloads_url: z.string(),
      events_url: z.string(),
      fork: z.boolean(),
      forks: z.number(),
      forks_count: z.number(),
      forks_url: z.string(),
      full_name: z.string(),
      git_commits_url: z.string(),
      git_refs_url: z.string(),
      git_tags_url: z.string(),
      git_url: z.string(),
      has_discussions: z.boolean(),
      has_downloads: z.boolean(),
      has_issues: z.boolean(),
      has_pages: z.boolean(),
      has_projects: z.boolean(),
      has_wiki: z.boolean(),
      homepage: z.string().nullable(),
      hooks_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      is_template: z.boolean().optional(),
      issue_comment_url: z.string(),
      issue_events_url: z.string(),
      issues_url: z.string(),
      keys_url: z.string(),
      labels_url: z.string(),
      language: z.string().nullable(),
      languages_url: z.string(),
      license: z
        .object({
          key: z.string(),
          name: z.string(),
          node_id: z.string(),
          spdx_id: z.string(),
          url: z.string().nullable(),
        })
        .nullable(),
      master_branch: z.string().optional(),
      merges_url: z.string(),
      milestones_url: z.string(),
      mirror_url: z.string().nullable(),
      name: z.string(),
      node_id: z.string(),
      notifications_url: z.string(),
      open_issues: z.number(),
      open_issues_count: z.number(),
      organization: z.string().optional(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          admin: z.boolean(),
          maintain: z.boolean().optional(),
          pull: z.boolean(),
          push: z.boolean(),
          triage: z.boolean().optional(),
        })
        .optional(),
      private: z.boolean(),
      public: z.boolean().optional(),
      pulls_url: z.string(),
      pushed_at: z.union([z.number(), z.string()]).nullable(),
      releases_url: z.string(),
      role_name: z.string().optional().nullable(),
      size: z.number(),
      ssh_url: z.string(),
      stargazers: z.number().optional(),
      stargazers_count: z.number(),
      stargazers_url: z.string(),
      statuses_url: z.string(),
      subscribers_url: z.string(),
      subscription_url: z.string(),
      svn_url: z.string(),
      tags_url: z.string(),
      teams_url: z.string(),
      topics: z.array(z.string()),
      trees_url: z.string(),
      updated_at: z.string(),
      url: z.string(),
      visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
      watchers: z.number(),
      watchers_count: z.number(),
      web_commit_signoff_required: z.boolean().optional(),
    }),
  }),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action20Schema = z.literal('transferred');

export const visibility3Schema = z.union([z.literal('public'), z.literal('private'), z.literal('internal')]);

export const webhookDiscussionUnansweredSchema = z.object({
  action: z.literal('unanswered'),
  discussion: discussionSchema,
  old_answer: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    child_comment_count: z.number(),
    created_at: z.string(),
    discussion_id: z.number(),
    html_url: z.string(),
    id: z.number(),
    node_id: z.string(),
    parent_id: z.unknown(),
    reactions: z
      .object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      })
      .optional(),
    repository_url: z.string(),
    updated_at: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema.optional(),
});

export const action21Schema = z.literal('unanswered');

export const webhookDiscussionUnlabeledSchema = z.object({
  action: z.literal('unlabeled'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  label: z.object({
    color: z.string(),
    default: z.boolean(),
    description: z.string().nullable(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action22Schema = z.literal('unlabeled');

export const webhookDiscussionUnlockedSchema = z.object({
  action: z.literal('unlocked'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action23Schema = z.literal('unlocked');

export const webhookDiscussionUnpinnedSchema = z.object({
  action: z.literal('unpinned'),
  discussion: discussionSchema,
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action24Schema = z.literal('unpinned');

export const webhookForkSchema = z.object({
  enterprise: enterpriseSchema.optional(),
  forkee: z
    .object({
      allow_auto_merge: z.boolean().optional(),
      allow_forking: z.boolean().optional(),
      allow_merge_commit: z.boolean().optional(),
      allow_rebase_merge: z.boolean().optional(),
      allow_squash_merge: z.boolean().optional(),
      allow_update_branch: z.boolean().optional(),
      archive_url: z.string(),
      archived: z.boolean(),
      assignees_url: z.string(),
      blobs_url: z.string(),
      branches_url: z.string(),
      clone_url: z.string(),
      collaborators_url: z.string(),
      comments_url: z.string(),
      commits_url: z.string(),
      compare_url: z.string(),
      contents_url: z.string(),
      contributors_url: z.string(),
      created_at: z.union([z.number(), z.string()]),
      default_branch: z.string(),
      delete_branch_on_merge: z.boolean().optional(),
      deployments_url: z.string(),
      description: z.string().nullable(),
      disabled: z.boolean().optional(),
      downloads_url: z.string(),
      events_url: z.string(),
      fork: z.boolean(),
      forks: z.number(),
      forks_count: z.number(),
      forks_url: z.string(),
      full_name: z.string(),
      git_commits_url: z.string(),
      git_refs_url: z.string(),
      git_tags_url: z.string(),
      git_url: z.string(),
      has_downloads: z.boolean(),
      has_issues: z.boolean(),
      has_pages: z.boolean(),
      has_projects: z.boolean(),
      has_wiki: z.boolean(),
      homepage: z.string().nullable(),
      hooks_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      is_template: z.boolean().optional(),
      issue_comment_url: z.string(),
      issue_events_url: z.string(),
      issues_url: z.string(),
      keys_url: z.string(),
      labels_url: z.string(),
      language: z.string().nullable(),
      languages_url: z.string(),
      license: z
        .object({
          key: z.string(),
          name: z.string(),
          node_id: z.string(),
          spdx_id: z.string(),
          url: z.string().nullable(),
        })
        .nullable(),
      master_branch: z.string().optional(),
      merges_url: z.string(),
      milestones_url: z.string(),
      mirror_url: z.string().nullable(),
      name: z.string(),
      node_id: z.string(),
      notifications_url: z.string(),
      open_issues: z.number(),
      open_issues_count: z.number(),
      organization: z.string().optional(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          admin: z.boolean(),
          maintain: z.boolean().optional(),
          pull: z.boolean(),
          push: z.boolean(),
          triage: z.boolean().optional(),
        })
        .optional(),
      private: z.boolean(),
      public: z.boolean().optional(),
      pulls_url: z.string(),
      pushed_at: z.union([z.number(), z.string()]).nullable(),
      releases_url: z.string(),
      role_name: z.string().optional().nullable(),
      size: z.number(),
      ssh_url: z.string(),
      stargazers: z.number().optional(),
      stargazers_count: z.number(),
      stargazers_url: z.string(),
      statuses_url: z.string(),
      subscribers_url: z.string(),
      subscription_url: z.string(),
      svn_url: z.string(),
      tags_url: z.string(),
      teams_url: z.string(),
      topics: z.array(z.string()),
      trees_url: z.string(),
      updated_at: z.string(),
      url: z.string(),
      visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
      watchers: z.number(),
      watchers_count: z.number(),
      web_commit_signoff_required: z.boolean().optional(),
    })
    .and(
      z.object({
        allow_forking: z.boolean().optional(),
        archive_url: z.string().optional(),
        archived: z.boolean().optional(),
        assignees_url: z.string().optional(),
        blobs_url: z.string().optional(),
        branches_url: z.string().optional(),
        clone_url: z.string().optional(),
        collaborators_url: z.string().optional(),
        comments_url: z.string().optional(),
        commits_url: z.string().optional(),
        compare_url: z.string().optional(),
        contents_url: z.string().optional(),
        contributors_url: z.string().optional(),
        created_at: z.string().optional(),
        default_branch: z.string().optional(),
        deployments_url: z.string().optional(),
        description: z.string().optional().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string().optional(),
        events_url: z.string().optional(),
        fork: z.boolean().optional(),
        forks: z.number().optional(),
        forks_count: z.number().optional(),
        forks_url: z.string().optional(),
        full_name: z.string().optional(),
        git_commits_url: z.string().optional(),
        git_refs_url: z.string().optional(),
        git_tags_url: z.string().optional(),
        git_url: z.string().optional(),
        has_downloads: z.boolean().optional(),
        has_issues: z.boolean().optional(),
        has_pages: z.boolean().optional(),
        has_projects: z.boolean().optional(),
        has_wiki: z.boolean().optional(),
        homepage: z.string().optional().nullable(),
        hooks_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string().optional(),
        issue_events_url: z.string().optional(),
        issues_url: z.string().optional(),
        keys_url: z.string().optional(),
        labels_url: z.string().optional(),
        language: z.unknown().optional(),
        languages_url: z.string().optional(),
        license: z.record(z.unknown()).optional().nullable(),
        merges_url: z.string().optional(),
        milestones_url: z.string().optional(),
        mirror_url: z.unknown().optional(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        notifications_url: z.string().optional(),
        open_issues: z.number().optional(),
        open_issues_count: z.number().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
        private: z.boolean().optional(),
        public: z.boolean().optional(),
        pulls_url: z.string().optional(),
        pushed_at: z.string().optional(),
        releases_url: z.string().optional(),
        size: z.number().optional(),
        ssh_url: z.string().optional(),
        stargazers_count: z.number().optional(),
        stargazers_url: z.string().optional(),
        statuses_url: z.string().optional(),
        subscribers_url: z.string().optional(),
        subscription_url: z.string().optional(),
        svn_url: z.string().optional(),
        tags_url: z.string().optional(),
        teams_url: z.string().optional(),
        topics: z.array(z.unknown()).optional(),
        trees_url: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        visibility: z.string().optional(),
        watchers: z.number().optional(),
        watchers_count: z.number().optional(),
      }),
    ),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookGithubAppAuthorizationRevokedSchema = z.object({
  action: z.literal('revoked'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action25Schema = z.literal('revoked');

export const webhookGollumSchema = z.object({
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  pages: z.array(
    z.object({
      action: z.union([z.literal('created'), z.literal('edited')]),
      html_url: z.string(),
      page_name: z.string(),
      sha: z.string(),
      summary: z.string().nullable(),
      title: z.string(),
    }),
  ),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookInstallationCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories: z
    .array(
      z.object({
        full_name: z.string(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        private: z.boolean(),
      }),
    )
    .optional(),
  repository: repositorySchema.optional(),
  requester: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .optional()
    .nullable(),
  sender: simpleUserSchema,
});

export const webhookInstallationDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories: z
    .array(
      z.object({
        full_name: z.string(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        private: z.boolean(),
      }),
    )
    .optional(),
  repository: repositorySchema.optional(),
  requester: z.unknown().optional(),
  sender: simpleUserSchema,
});

export const webhookInstallationNewPermissionsAcceptedSchema = z.object({
  action: z.literal('new_permissions_accepted'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories: z
    .array(
      z.object({
        full_name: z.string(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        private: z.boolean(),
      }),
    )
    .optional(),
  repository: repositorySchema.optional(),
  requester: z.unknown().optional(),
  sender: simpleUserSchema,
});

export const action26Schema = z.literal('new_permissions_accepted');

export const webhookInstallationRepositoriesAddedSchema = z.object({
  action: z.literal('added'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories_added: z.array(
    z.object({
      full_name: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      private: z.boolean(),
    }),
  ),
  repositories_removed: z.array(
    z.object({
      full_name: z.string().optional(),
      id: z.number().optional(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      private: z.boolean().optional(),
    }),
  ),
  repository: repositorySchema.optional(),
  repository_selection: z.union([z.literal('all'), z.literal('selected')]),
  requester: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  sender: simpleUserSchema,
});

export const action27Schema = z.literal('added');

export const webhookInstallationRepositoriesRemovedSchema = z.object({
  action: z.literal('removed'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories_added: z.array(
    z.object({
      full_name: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      private: z.boolean(),
    }),
  ),
  repositories_removed: z.array(
    z.object({
      full_name: z.string(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      private: z.boolean(),
    }),
  ),
  repository: repositorySchema.optional(),
  repository_selection: z.union([z.literal('all'), z.literal('selected')]),
  requester: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  sender: simpleUserSchema,
});

export const action28Schema = z.literal('removed');

export const webhookInstallationSuspendSchema = z.object({
  action: z.literal('suspend'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories: z
    .array(
      z.object({
        full_name: z.string(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        private: z.boolean(),
      }),
    )
    .optional(),
  repository: repositorySchema.optional(),
  requester: z.unknown().optional(),
  sender: simpleUserSchema,
});

export const action29Schema = z.literal('suspend');

export const webhookInstallationTargetRenamedSchema = z.object({
  account: z.object({
    avatar_url: z.string(),
    created_at: z.string().optional(),
    description: z.unknown().optional(),
    events_url: z.string().optional(),
    followers: z.number().optional(),
    followers_url: z.string().optional(),
    following: z.number().optional(),
    following_url: z.string().optional(),
    gists_url: z.string().optional(),
    gravatar_id: z.string().optional(),
    has_organization_projects: z.boolean().optional(),
    has_repository_projects: z.boolean().optional(),
    hooks_url: z.string().optional(),
    html_url: z.string(),
    id: z.number(),
    is_verified: z.boolean().optional(),
    issues_url: z.string().optional(),
    login: z.string().optional(),
    members_url: z.string().optional(),
    name: z.string().optional(),
    node_id: z.string(),
    organizations_url: z.string().optional(),
    public_gists: z.number().optional(),
    public_members_url: z.string().optional(),
    public_repos: z.number().optional(),
    received_events_url: z.string().optional(),
    repos_url: z.string().optional(),
    site_admin: z.boolean().optional(),
    slug: z.string().optional(),
    starred_url: z.string().optional(),
    subscriptions_url: z.string().optional(),
    type: z.string().optional(),
    updated_at: z.string().optional(),
    url: z.string().optional(),
    website_url: z.unknown().optional(),
  }),
  action: z.string(),
  changes: z.object({
    login: z
      .object({
        from: z.string(),
      })
      .optional(),
    slug: z
      .object({
        from: z.string(),
      })
      .optional(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema,
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
  target_type: z.string(),
});

export const webhookInstallationUnsuspendSchema = z.object({
  action: z.literal('unsuspend'),
  enterprise: enterpriseSchema.optional(),
  installation: installationSchema,
  organization: organizationSimpleSchema.optional(),
  repositories: z
    .array(
      z.object({
        full_name: z.string(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        private: z.boolean(),
      }),
    )
    .optional(),
  repository: repositorySchema.optional(),
  requester: z.unknown().optional(),
  sender: simpleUserSchema,
});

export const action30Schema = z.literal('unsuspend');

export const webhookIssueCommentCreatedSchema = z.object({
  action: z.literal('created'),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    created_at: z.string(),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    node_id: z.string(),
    performed_via_github_app: nullableIntegrationSchema,
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('reminder'),
                z.literal('pull_request_review_thread'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        ),
        labels_url: z.string().optional(),
        locked: z.boolean(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const activeLockReasonSchema = z.union([
  z.literal('resolved'),
  z.literal('off-topic'),
  z.literal('too heated'),
  z.literal('spam'),
]);

export const webhookIssueCommentDeletedSchema = z.object({
  action: z.literal('deleted'),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    created_at: z.string(),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    node_id: z.string(),
    performed_via_github_app: nullableIntegrationSchema,
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        ),
        labels_url: z.string().optional(),
        locked: z.boolean(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const type7Schema = z.union([
  z.literal('Bot'),
  z.literal('User'),
  z.literal('Organization'),
  z.literal('Mannequin'),
]);

export const webhookIssueCommentEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    body: z
      .object({
        from: z.string(),
      })
      .optional(),
  }),
  comment: z.object({
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string(),
    created_at: z.string(),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    node_id: z.string(),
    performed_via_github_app: nullableIntegrationSchema,
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('reminder'),
                z.literal('pull_request_review_thread'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        ),
        labels_url: z.string().optional(),
        locked: z.boolean(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesAssignedSchema = z.object({
  action: z.literal('assigned'),
  assignee: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .optional()
    .nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('reminder'),
              z.literal('pull_request_review_thread'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action31Schema = z.literal('assigned');

export const webhookIssuesClosedSchema = z.object({
  action: z.literal('closed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('security_and_analysis'),
                z.literal('reminder'),
                z.literal('pull_request_review_thread'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean().optional(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('closed'), z.literal('open')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action32Schema = z.literal('closed');

export const webhookIssuesDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('reminder'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesDemilestonedSchema = z.object({
  action: z.literal('demilestoned'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean().optional(),
        milestone: z
          .object({
            closed_at: z.string().nullable(),
            closed_issues: z.number(),
            created_at: z.string(),
            creator: z
              .object({
                avatar_url: z.string().optional(),
                deleted: z.boolean().optional(),
                email: z.string().optional().nullable(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number(),
                login: z.string(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z
                  .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                  .optional(),
                url: z.string().optional(),
              })
              .nullable(),
            description: z.string().nullable(),
            due_on: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            labels_url: z.string(),
            node_id: z.string(),
            number: z.number(),
            open_issues: z.number(),
            state: z.union([z.literal('open'), z.literal('closed')]),
            title: z.string(),
            updated_at: z.string(),
            url: z.string(),
          })
          .nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.string().optional(),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  milestone: z
    .object({
      closed_at: z.string().nullable(),
      closed_issues: z.number(),
      created_at: z.string(),
      creator: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
      description: z.string().nullable(),
      due_on: z.string().nullable(),
      html_url: z.string(),
      id: z.number(),
      labels_url: z.string(),
      node_id: z.string(),
      number: z.number(),
      open_issues: z.number(),
      state: z.union([z.literal('open'), z.literal('closed')]),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
    })
    .optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action33Schema = z.literal('demilestoned');

export const webhookIssuesEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    body: z
      .object({
        from: z.string(),
      })
      .optional(),
    title: z
      .object({
        from: z.string(),
      })
      .optional(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('security_and_analysis'),
              z.literal('pull_request_review_thread'),
              z.literal('reminder'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  label: z
    .object({
      color: z.string(),
      default: z.boolean(),
      description: z.string().nullable(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      url: z.string(),
    })
    .optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesLabeledSchema = z.object({
  action: z.literal('labeled'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('pull_request_review_thread'),
              z.literal('reminder'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  label: z
    .object({
      color: z.string(),
      default: z.boolean(),
      description: z.string().nullable(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      url: z.string(),
    })
    .optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesLockedSchema = z.object({
  action: z.literal('locked'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('reminder'),
                z.literal('security_and_analysis'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z
          .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
          .nullable(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.string().optional(),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesMilestonedSchema = z.object({
  action: z.literal('milestoned'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('reminder'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean().optional(),
        milestone: z.object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        }),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.string().optional(),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action34Schema = z.literal('milestoned');

export const webhookIssuesOpenedSchema = z.object({
  action: z.literal('opened'),
  changes: z
    .object({
      old_issue: z
        .object({
          active_lock_reason: z
            .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
            .nullable(),
          assignee: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .optional()
            .nullable(),
          assignees: z.array(
            z
              .object({
                avatar_url: z.string().optional(),
                deleted: z.boolean().optional(),
                email: z.string().optional().nullable(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number(),
                login: z.string(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                url: z.string().optional(),
              })
              .nullable(),
          ),
          author_association: z.union([
            z.literal('COLLABORATOR'),
            z.literal('CONTRIBUTOR'),
            z.literal('FIRST_TIMER'),
            z.literal('FIRST_TIME_CONTRIBUTOR'),
            z.literal('MANNEQUIN'),
            z.literal('MEMBER'),
            z.literal('NONE'),
            z.literal('OWNER'),
          ]),
          body: z.string().nullable(),
          closed_at: z.string().nullable(),
          comments: z.number(),
          comments_url: z.string(),
          created_at: z.string(),
          draft: z.boolean().optional(),
          events_url: z.string(),
          html_url: z.string(),
          id: z.number(),
          labels: z
            .array(
              z.object({
                color: z.string(),
                default: z.boolean(),
                description: z.string().nullable(),
                id: z.number(),
                name: z.string(),
                node_id: z.string(),
                url: z.string(),
              }),
            )
            .optional(),
          labels_url: z.string(),
          locked: z.boolean().optional(),
          milestone: z
            .object({
              closed_at: z.string().nullable(),
              closed_issues: z.number(),
              created_at: z.string(),
              creator: z
                .object({
                  avatar_url: z.string().optional(),
                  deleted: z.boolean().optional(),
                  email: z.string().optional().nullable(),
                  events_url: z.string().optional(),
                  followers_url: z.string().optional(),
                  following_url: z.string().optional(),
                  gists_url: z.string().optional(),
                  gravatar_id: z.string().optional(),
                  html_url: z.string().optional(),
                  id: z.number(),
                  login: z.string(),
                  name: z.string().optional(),
                  node_id: z.string().optional(),
                  organizations_url: z.string().optional(),
                  received_events_url: z.string().optional(),
                  repos_url: z.string().optional(),
                  site_admin: z.boolean().optional(),
                  starred_url: z.string().optional(),
                  subscriptions_url: z.string().optional(),
                  type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                  url: z.string().optional(),
                })
                .nullable(),
              description: z.string().nullable(),
              due_on: z.string().nullable(),
              html_url: z.string(),
              id: z.number(),
              labels_url: z.string(),
              node_id: z.string(),
              number: z.number(),
              open_issues: z.number(),
              state: z.union([z.literal('open'), z.literal('closed')]),
              title: z.string(),
              updated_at: z.string(),
              url: z.string(),
            })
            .nullable(),
          node_id: z.string(),
          number: z.number(),
          performed_via_github_app: z
            .object({
              created_at: z.string().nullable(),
              description: z.string().nullable(),
              events: z
                .array(
                  z.union([
                    z.literal('branch_protection_rule'),
                    z.literal('check_run'),
                    z.literal('check_suite'),
                    z.literal('code_scanning_alert'),
                    z.literal('commit_comment'),
                    z.literal('content_reference'),
                    z.literal('create'),
                    z.literal('delete'),
                    z.literal('deployment'),
                    z.literal('deployment_review'),
                    z.literal('deployment_status'),
                    z.literal('deploy_key'),
                    z.literal('discussion'),
                    z.literal('discussion_comment'),
                    z.literal('fork'),
                    z.literal('gollum'),
                    z.literal('issues'),
                    z.literal('issue_comment'),
                    z.literal('label'),
                    z.literal('member'),
                    z.literal('membership'),
                    z.literal('milestone'),
                    z.literal('organization'),
                    z.literal('org_block'),
                    z.literal('page_build'),
                    z.literal('project'),
                    z.literal('project_card'),
                    z.literal('project_column'),
                    z.literal('public'),
                    z.literal('pull_request'),
                    z.literal('pull_request_review'),
                    z.literal('pull_request_review_comment'),
                    z.literal('push'),
                    z.literal('registry_package'),
                    z.literal('release'),
                    z.literal('repository'),
                    z.literal('repository_dispatch'),
                    z.literal('secret_scanning_alert'),
                    z.literal('star'),
                    z.literal('status'),
                    z.literal('team'),
                    z.literal('team_add'),
                    z.literal('watch'),
                    z.literal('workflow_dispatch'),
                    z.literal('workflow_run'),
                  ]),
                )
                .optional(),
              external_url: z.string().nullable(),
              html_url: z.string(),
              id: z.number().nullable(),
              name: z.string(),
              node_id: z.string(),
              owner: z
                .object({
                  avatar_url: z.string().optional(),
                  deleted: z.boolean().optional(),
                  email: z.string().optional().nullable(),
                  events_url: z.string().optional(),
                  followers_url: z.string().optional(),
                  following_url: z.string().optional(),
                  gists_url: z.string().optional(),
                  gravatar_id: z.string().optional(),
                  html_url: z.string().optional(),
                  id: z.number(),
                  login: z.string(),
                  name: z.string().optional(),
                  node_id: z.string().optional(),
                  organizations_url: z.string().optional(),
                  received_events_url: z.string().optional(),
                  repos_url: z.string().optional(),
                  site_admin: z.boolean().optional(),
                  starred_url: z.string().optional(),
                  subscriptions_url: z.string().optional(),
                  type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                  url: z.string().optional(),
                })
                .nullable(),
              permissions: z
                .object({
                  actions: z.union([z.literal('read'), z.literal('write')]).optional(),
                  administration: z.union([z.literal('read'), z.literal('write')]).optional(),
                  checks: z.union([z.literal('read'), z.literal('write')]).optional(),
                  content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
                  contents: z.union([z.literal('read'), z.literal('write')]).optional(),
                  deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
                  discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
                  emails: z.union([z.literal('read'), z.literal('write')]).optional(),
                  environments: z.union([z.literal('read'), z.literal('write')]).optional(),
                  issues: z.union([z.literal('read'), z.literal('write')]).optional(),
                  keys: z.union([z.literal('read'), z.literal('write')]).optional(),
                  members: z.union([z.literal('read'), z.literal('write')]).optional(),
                  metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
                  organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
                  packages: z.union([z.literal('read'), z.literal('write')]).optional(),
                  pages: z.union([z.literal('read'), z.literal('write')]).optional(),
                  pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
                  repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
                  repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
                  secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
                  secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
                  security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
                  security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
                  single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
                  statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
                  team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
                  vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
                  workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
                })
                .optional(),
              slug: z.string().optional(),
              updated_at: z.string().nullable(),
            })
            .optional()
            .nullable(),
          pull_request: z
            .object({
              diff_url: z.string().optional(),
              html_url: z.string().optional(),
              merged_at: z.string().optional().nullable(),
              patch_url: z.string().optional(),
              url: z.string().optional(),
            })
            .optional(),
          reactions: z.object({
            '+1': z.number(),
            '-1': z.number(),
            confused: z.number(),
            eyes: z.number(),
            heart: z.number(),
            hooray: z.number(),
            laugh: z.number(),
            rocket: z.number(),
            total_count: z.number(),
            url: z.string(),
          }),
          repository_url: z.string(),
          state: z.union([z.literal('open'), z.literal('closed')]).optional(),
          state_reason: z.string().optional().nullable(),
          timeline_url: z.string().optional(),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
          user: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
        })
        .nullable(),
      old_repository: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
      }),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('security_and_analysis'),
              z.literal('pull_request_review_thread'),
              z.literal('reminder'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action35Schema = z.literal('opened');

export const webhookIssuesPinnedSchema = z.object({
  action: z.literal('pinned'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesReopenedSchema = z.object({
  action: z.literal('reopened'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
                z.literal('pull_request_review_thread'),
                z.literal('reminder'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.string().optional().nullable(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean().optional(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.record(z.unknown()).optional().nullable(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesTransferredSchema = z.object({
  action: z.literal('transferred'),
  changes: z.object({
    new_issue: z.object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    new_repository: z.object({
      allow_auto_merge: z.boolean().optional(),
      allow_forking: z.boolean().optional(),
      allow_merge_commit: z.boolean().optional(),
      allow_rebase_merge: z.boolean().optional(),
      allow_squash_merge: z.boolean().optional(),
      allow_update_branch: z.boolean().optional(),
      archive_url: z.string(),
      archived: z.boolean(),
      assignees_url: z.string(),
      blobs_url: z.string(),
      branches_url: z.string(),
      clone_url: z.string(),
      collaborators_url: z.string(),
      comments_url: z.string(),
      commits_url: z.string(),
      compare_url: z.string(),
      contents_url: z.string(),
      contributors_url: z.string(),
      created_at: z.union([z.number(), z.string()]),
      default_branch: z.string(),
      delete_branch_on_merge: z.boolean().optional(),
      deployments_url: z.string(),
      description: z.string().nullable(),
      disabled: z.boolean().optional(),
      downloads_url: z.string(),
      events_url: z.string(),
      fork: z.boolean(),
      forks: z.number(),
      forks_count: z.number(),
      forks_url: z.string(),
      full_name: z.string(),
      git_commits_url: z.string(),
      git_refs_url: z.string(),
      git_tags_url: z.string(),
      git_url: z.string(),
      has_discussions: z.boolean(),
      has_downloads: z.boolean(),
      has_issues: z.boolean(),
      has_pages: z.boolean(),
      has_projects: z.boolean(),
      has_wiki: z.boolean(),
      homepage: z.string().nullable(),
      hooks_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      is_template: z.boolean().optional(),
      issue_comment_url: z.string(),
      issue_events_url: z.string(),
      issues_url: z.string(),
      keys_url: z.string(),
      labels_url: z.string(),
      language: z.string().nullable(),
      languages_url: z.string(),
      license: z
        .object({
          key: z.string(),
          name: z.string(),
          node_id: z.string(),
          spdx_id: z.string(),
          url: z.string().nullable(),
        })
        .nullable(),
      master_branch: z.string().optional(),
      merges_url: z.string(),
      milestones_url: z.string(),
      mirror_url: z.string().nullable(),
      name: z.string(),
      node_id: z.string(),
      notifications_url: z.string(),
      open_issues: z.number(),
      open_issues_count: z.number(),
      organization: z.string().optional(),
      owner: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      permissions: z
        .object({
          admin: z.boolean(),
          maintain: z.boolean().optional(),
          pull: z.boolean(),
          push: z.boolean(),
          triage: z.boolean().optional(),
        })
        .optional(),
      private: z.boolean(),
      public: z.boolean().optional(),
      pulls_url: z.string(),
      pushed_at: z.union([z.number(), z.string()]).nullable(),
      releases_url: z.string(),
      role_name: z.string().optional().nullable(),
      size: z.number(),
      ssh_url: z.string(),
      stargazers: z.number().optional(),
      stargazers_count: z.number(),
      stargazers_url: z.string(),
      statuses_url: z.string(),
      subscribers_url: z.string(),
      subscription_url: z.string(),
      svn_url: z.string(),
      tags_url: z.string(),
      teams_url: z.string(),
      topics: z.array(z.string()),
      trees_url: z.string(),
      updated_at: z.string(),
      url: z.string(),
      visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
      watchers: z.number(),
      watchers_count: z.number(),
      web_commit_signoff_required: z.boolean().optional(),
    }),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesUnassignedSchema = z.object({
  action: z.literal('unassigned'),
  assignee: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z
        .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
        .optional(),
      url: z.string().optional(),
    })
    .optional()
    .nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('reminder'),
              z.literal('pull_request_review_thread'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action36Schema = z.literal('unassigned');

export const webhookIssuesUnlabeledSchema = z.object({
  action: z.literal('unlabeled'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
              z.literal('reminder'),
              z.literal('pull_request_review_thread'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write'), z.literal('admin')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  label: z
    .object({
      color: z.string(),
      default: z.boolean(),
      description: z.string().nullable(),
      id: z.number(),
      name: z.string(),
      node_id: z.string(),
      url: z.string(),
    })
    .optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesUnlockedSchema = z.object({
  action: z.literal('unlocked'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z
    .object({
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      body: z.string().nullable(),
      closed_at: z.string().nullable(),
      comments: z.number(),
      comments_url: z.string(),
      created_at: z.string(),
      draft: z.boolean().optional(),
      events_url: z.string(),
      html_url: z.string(),
      id: z.number(),
      labels: z
        .array(
          z.object({
            color: z.string(),
            default: z.boolean(),
            description: z.string().nullable(),
            id: z.number(),
            name: z.string(),
            node_id: z.string(),
            url: z.string(),
          }),
        )
        .optional(),
      labels_url: z.string(),
      locked: z.boolean().optional(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      performed_via_github_app: z
        .object({
          created_at: z.string().nullable(),
          description: z.string().nullable(),
          events: z
            .array(
              z.union([
                z.literal('branch_protection_rule'),
                z.literal('check_run'),
                z.literal('check_suite'),
                z.literal('code_scanning_alert'),
                z.literal('commit_comment'),
                z.literal('content_reference'),
                z.literal('create'),
                z.literal('delete'),
                z.literal('deployment'),
                z.literal('deployment_review'),
                z.literal('deployment_status'),
                z.literal('deploy_key'),
                z.literal('discussion'),
                z.literal('discussion_comment'),
                z.literal('fork'),
                z.literal('gollum'),
                z.literal('issues'),
                z.literal('issue_comment'),
                z.literal('label'),
                z.literal('member'),
                z.literal('membership'),
                z.literal('milestone'),
                z.literal('organization'),
                z.literal('org_block'),
                z.literal('page_build'),
                z.literal('project'),
                z.literal('project_card'),
                z.literal('project_column'),
                z.literal('public'),
                z.literal('pull_request'),
                z.literal('pull_request_review'),
                z.literal('pull_request_review_comment'),
                z.literal('push'),
                z.literal('registry_package'),
                z.literal('release'),
                z.literal('repository'),
                z.literal('repository_dispatch'),
                z.literal('secret_scanning_alert'),
                z.literal('star'),
                z.literal('status'),
                z.literal('team'),
                z.literal('team_add'),
                z.literal('watch'),
                z.literal('workflow_dispatch'),
                z.literal('workflow_run'),
              ]),
            )
            .optional(),
          external_url: z.string().nullable(),
          html_url: z.string(),
          id: z.number().nullable(),
          name: z.string(),
          node_id: z.string(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              actions: z.union([z.literal('read'), z.literal('write')]).optional(),
              administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              checks: z.union([z.literal('read'), z.literal('write')]).optional(),
              content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
              contents: z.union([z.literal('read'), z.literal('write')]).optional(),
              deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
              discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              emails: z.union([z.literal('read'), z.literal('write')]).optional(),
              environments: z.union([z.literal('read'), z.literal('write')]).optional(),
              issues: z.union([z.literal('read'), z.literal('write')]).optional(),
              keys: z.union([z.literal('read'), z.literal('write')]).optional(),
              members: z.union([z.literal('read'), z.literal('write')]).optional(),
              metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
              organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
              packages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pages: z.union([z.literal('read'), z.literal('write')]).optional(),
              pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
              repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
              secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
              security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
              single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
              statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
              team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
              vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
              workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
            })
            .optional(),
          slug: z.string().optional(),
          updated_at: z.string().nullable(),
        })
        .optional()
        .nullable(),
      pull_request: z
        .object({
          diff_url: z.string().optional(),
          html_url: z.string().optional(),
          merged_at: z.string().optional().nullable(),
          patch_url: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      reactions: z.object({
        '+1': z.number(),
        '-1': z.number(),
        confused: z.number(),
        eyes: z.number(),
        heart: z.number(),
        hooray: z.number(),
        laugh: z.number(),
        rocket: z.number(),
        total_count: z.number(),
        url: z.string(),
      }),
      repository_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]).optional(),
      state_reason: z.string().optional().nullable(),
      timeline_url: z.string().optional(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        active_lock_reason: z.unknown(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        body: z.string().optional().nullable(),
        closed_at: z.string().optional().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        created_at: z.string().optional(),
        events_url: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        labels_url: z.string().optional(),
        locked: z.boolean(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        performed_via_github_app: z.unknown().optional(),
        reactions: z
          .object({
            '+1': z.number().optional(),
            '-1': z.number().optional(),
            confused: z.number().optional(),
            eyes: z.number().optional(),
            heart: z.number().optional(),
            hooray: z.number().optional(),
            laugh: z.number().optional(),
            rocket: z.number().optional(),
            total_count: z.number().optional(),
            url: z.string().optional(),
          })
          .optional(),
        repository_url: z.string().optional(),
        state: z.string().optional(),
        timeline_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookIssuesUnpinnedSchema = z.object({
  action: z.literal('unpinned'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  issue: z.object({
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    body: z.string().nullable(),
    closed_at: z.string().nullable(),
    comments: z.number(),
    comments_url: z.string(),
    created_at: z.string(),
    draft: z.boolean().optional(),
    events_url: z.string(),
    html_url: z.string(),
    id: z.number(),
    labels: z
      .array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      )
      .optional(),
    labels_url: z.string(),
    locked: z.boolean().optional(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    performed_via_github_app: z
      .object({
        created_at: z.string().nullable(),
        description: z.string().nullable(),
        events: z
          .array(
            z.union([
              z.literal('branch_protection_rule'),
              z.literal('check_run'),
              z.literal('check_suite'),
              z.literal('code_scanning_alert'),
              z.literal('commit_comment'),
              z.literal('content_reference'),
              z.literal('create'),
              z.literal('delete'),
              z.literal('deployment'),
              z.literal('deployment_review'),
              z.literal('deployment_status'),
              z.literal('deploy_key'),
              z.literal('discussion'),
              z.literal('discussion_comment'),
              z.literal('fork'),
              z.literal('gollum'),
              z.literal('issues'),
              z.literal('issue_comment'),
              z.literal('label'),
              z.literal('member'),
              z.literal('membership'),
              z.literal('milestone'),
              z.literal('organization'),
              z.literal('org_block'),
              z.literal('page_build'),
              z.literal('project'),
              z.literal('project_card'),
              z.literal('project_column'),
              z.literal('public'),
              z.literal('pull_request'),
              z.literal('pull_request_review'),
              z.literal('pull_request_review_comment'),
              z.literal('push'),
              z.literal('registry_package'),
              z.literal('release'),
              z.literal('repository'),
              z.literal('repository_dispatch'),
              z.literal('secret_scanning_alert'),
              z.literal('star'),
              z.literal('status'),
              z.literal('team'),
              z.literal('team_add'),
              z.literal('watch'),
              z.literal('workflow_dispatch'),
              z.literal('workflow_run'),
            ]),
          )
          .optional(),
        external_url: z.string().nullable(),
        html_url: z.string(),
        id: z.number().nullable(),
        name: z.string(),
        node_id: z.string(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            actions: z.union([z.literal('read'), z.literal('write')]).optional(),
            administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            checks: z.union([z.literal('read'), z.literal('write')]).optional(),
            content_references: z.union([z.literal('read'), z.literal('write')]).optional(),
            contents: z.union([z.literal('read'), z.literal('write')]).optional(),
            deployments: z.union([z.literal('read'), z.literal('write')]).optional(),
            discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            emails: z.union([z.literal('read'), z.literal('write')]).optional(),
            environments: z.union([z.literal('read'), z.literal('write')]).optional(),
            issues: z.union([z.literal('read'), z.literal('write')]).optional(),
            keys: z.union([z.literal('read'), z.literal('write')]).optional(),
            members: z.union([z.literal('read'), z.literal('write')]).optional(),
            metadata: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_administration: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_plan: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_self_hosted_runners: z.union([z.literal('read'), z.literal('write')]).optional(),
            organization_user_blocking: z.union([z.literal('read'), z.literal('write')]).optional(),
            packages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pages: z.union([z.literal('read'), z.literal('write')]).optional(),
            pull_requests: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_hooks: z.union([z.literal('read'), z.literal('write')]).optional(),
            repository_projects: z.union([z.literal('read'), z.literal('write')]).optional(),
            secret_scanning_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            secrets: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_events: z.union([z.literal('read'), z.literal('write')]).optional(),
            security_scanning_alert: z.union([z.literal('read'), z.literal('write')]).optional(),
            single_file: z.union([z.literal('read'), z.literal('write')]).optional(),
            statuses: z.union([z.literal('read'), z.literal('write')]).optional(),
            team_discussions: z.union([z.literal('read'), z.literal('write')]).optional(),
            vulnerability_alerts: z.union([z.literal('read'), z.literal('write')]).optional(),
            workflows: z.union([z.literal('read'), z.literal('write')]).optional(),
          })
          .optional(),
        slug: z.string().optional(),
        updated_at: z.string().nullable(),
      })
      .optional()
      .nullable(),
    pull_request: z
      .object({
        diff_url: z.string().optional(),
        html_url: z.string().optional(),
        merged_at: z.string().optional().nullable(),
        patch_url: z.string().optional(),
        url: z.string().optional(),
      })
      .optional(),
    reactions: z.object({
      '+1': z.number(),
      '-1': z.number(),
      confused: z.number(),
      eyes: z.number(),
      heart: z.number(),
      hooray: z.number(),
      laugh: z.number(),
      rocket: z.number(),
      total_count: z.number(),
      url: z.string(),
    }),
    repository_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]).optional(),
    state_reason: z.string().optional().nullable(),
    timeline_url: z.string().optional(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookLabelCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  label: z.object({
    color: z.string(),
    default: z.boolean(),
    description: z.string().nullable(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema.optional(),
});

export const webhookLabelDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  label: z.object({
    color: z.string(),
    default: z.boolean(),
    description: z.string().nullable(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookLabelEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z
    .object({
      color: z
        .object({
          from: z.string(),
        })
        .optional(),
      description: z
        .object({
          from: z.string(),
        })
        .optional(),
      name: z
        .object({
          from: z.string(),
        })
        .optional(),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  label: z.object({
    color: z.string(),
    default: z.boolean(),
    description: z.string().nullable(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMarketplacePurchaseCancelledSchema = z.object({
  action: z.literal('cancelled'),
  effective_date: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .and(
      z.object({
        account: z
          .object({
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organization_billing_email: z.string().optional().nullable(),
            type: z.string().optional(),
          })
          .optional(),
        billing_cycle: z.string().optional(),
        free_trial_ends_on: z.string().optional().nullable(),
        next_billing_date: z.string().nullable(),
        on_free_trial: z.boolean().optional(),
        plan: z
          .object({
            bullets: z.array(z.string().nullable()).optional(),
            description: z.string().optional(),
            has_free_trial: z.boolean().optional(),
            id: z.number().optional(),
            monthly_price_in_cents: z.number().optional(),
            name: z.string().optional(),
            price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]).optional(),
            unit_name: z.string().optional().nullable(),
            yearly_price_in_cents: z.number().optional(),
          })
          .optional(),
        unit_count: z.number().optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  previous_marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.unknown(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action37Schema = z.literal('cancelled');

export const webhookMarketplacePurchaseChangedSchema = z.object({
  action: z.literal('changed'),
  effective_date: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .and(
      z.object({
        account: z
          .object({
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organization_billing_email: z.string().optional().nullable(),
            type: z.string().optional(),
          })
          .optional(),
        billing_cycle: z.string().optional(),
        free_trial_ends_on: z.string().optional().nullable(),
        next_billing_date: z.string().nullable(),
        on_free_trial: z.boolean().optional(),
        plan: z
          .object({
            bullets: z.array(z.string().nullable()).optional(),
            description: z.string().optional(),
            has_free_trial: z.boolean().optional(),
            id: z.number().optional(),
            monthly_price_in_cents: z.number().optional(),
            name: z.string().optional(),
            price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]).optional(),
            unit_name: z.string().optional().nullable(),
            yearly_price_in_cents: z.number().optional(),
          })
          .optional(),
        unit_count: z.number().optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  previous_marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean().nullable(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action38Schema = z.literal('changed');

export const webhookMarketplacePurchasePendingChangeSchema = z.object({
  action: z.literal('pending_change'),
  effective_date: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .and(
      z.object({
        account: z
          .object({
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organization_billing_email: z.string().optional().nullable(),
            type: z.string().optional(),
          })
          .optional(),
        billing_cycle: z.string().optional(),
        free_trial_ends_on: z.string().optional().nullable(),
        next_billing_date: z.string().nullable(),
        on_free_trial: z.boolean().optional(),
        plan: z
          .object({
            bullets: z.array(z.string().nullable()).optional(),
            description: z.string().optional(),
            has_free_trial: z.boolean().optional(),
            id: z.number().optional(),
            monthly_price_in_cents: z.number().optional(),
            name: z.string().optional(),
            price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]).optional(),
            unit_name: z.string().optional().nullable(),
            yearly_price_in_cents: z.number().optional(),
          })
          .optional(),
        unit_count: z.number().optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  previous_marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action39Schema = z.literal('pending_change');

export const webhookMarketplacePurchasePendingChangeCancelledSchema = z.object({
  action: z.literal('pending_change_cancelled'),
  effective_date: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.unknown(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .and(
      z.object({
        next_billing_date: z.string(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  previous_marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.unknown(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action40Schema = z.literal('pending_change_cancelled');

export const webhookMarketplacePurchasePurchasedSchema = z.object({
  action: z.literal('purchased'),
  effective_date: z.string(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.string().nullable(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .and(
      z.object({
        account: z
          .object({
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organization_billing_email: z.string().optional().nullable(),
            type: z.string().optional(),
          })
          .optional(),
        billing_cycle: z.string().optional(),
        free_trial_ends_on: z.string().optional().nullable(),
        next_billing_date: z.string().nullable(),
        on_free_trial: z.boolean().optional(),
        plan: z
          .object({
            bullets: z.array(z.string().nullable()).optional(),
            description: z.string().optional(),
            has_free_trial: z.boolean().optional(),
            id: z.number().optional(),
            monthly_price_in_cents: z.number().optional(),
            name: z.string().optional(),
            price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]).optional(),
            unit_name: z.string().optional().nullable(),
            yearly_price_in_cents: z.number().optional(),
          })
          .optional(),
        unit_count: z.number().optional(),
      }),
    ),
  organization: organizationSimpleSchema.optional(),
  previous_marketplace_purchase: z
    .object({
      account: z.object({
        id: z.number(),
        login: z.string(),
        node_id: z.string(),
        organization_billing_email: z.string().nullable(),
        type: z.string(),
      }),
      billing_cycle: z.string(),
      free_trial_ends_on: z.unknown(),
      next_billing_date: z.string().optional().nullable(),
      on_free_trial: z.boolean(),
      plan: z.object({
        bullets: z.array(z.string()),
        description: z.string(),
        has_free_trial: z.boolean(),
        id: z.number(),
        monthly_price_in_cents: z.number(),
        name: z.string(),
        price_model: z.union([z.literal('FREE'), z.literal('FLAT_RATE'), z.literal('PER_UNIT')]),
        unit_name: z.string().nullable(),
        yearly_price_in_cents: z.number(),
      }),
      unit_count: z.number(),
    })
    .optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action41Schema = z.literal('purchased');

export const webhookMemberAddedSchema = z.object({
  action: z.literal('added'),
  changes: z
    .object({
      permission: z
        .object({
          to: z.union([z.literal('write'), z.literal('admin'), z.literal('read')]),
        })
        .optional(),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  member: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const toSchema = z.union([z.literal('write'), z.literal('admin'), z.literal('read')]);

export const webhookMemberEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    old_permission: z
      .object({
        from: z.string(),
      })
      .optional(),
    permission: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional().nullable(),
      })
      .optional(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  member: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMemberRemovedSchema = z.object({
  action: z.literal('removed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  member: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMembershipAddedSchema = z.object({
  action: z.literal('added'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  member: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  scope: z.literal('team'),
  sender: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  team: z.object({
    deleted: z.boolean().optional(),
    description: z.string().optional().nullable(),
    html_url: z.string().optional(),
    id: z.number(),
    members_url: z.string().optional(),
    name: z.string(),
    node_id: z.string().optional(),
    parent: z
      .object({
        description: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        members_url: z.string(),
        name: z.string(),
        node_id: z.string(),
        permission: z.string(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
        repositories_url: z.string(),
        slug: z.string(),
        url: z.string(),
      })
      .optional()
      .nullable(),
    permission: z.string().optional(),
    privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
    repositories_url: z.string().optional(),
    slug: z.string().optional(),
    url: z.string().optional(),
  }),
});

export const scope3Schema = z.literal('team');

export const privacy2Schema = z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]);

export const webhookMembershipRemovedSchema = z.object({
  action: z.literal('removed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  member: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  scope: z.union([z.literal('team'), z.literal('organization')]),
  sender: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  team: z.object({
    deleted: z.boolean().optional(),
    description: z.string().optional().nullable(),
    html_url: z.string().optional(),
    id: z.number(),
    members_url: z.string().optional(),
    name: z.string(),
    node_id: z.string().optional(),
    parent: z
      .object({
        description: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        members_url: z.string(),
        name: z.string(),
        node_id: z.string(),
        permission: z.string(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
        repositories_url: z.string(),
        slug: z.string(),
        url: z.string(),
      })
      .optional()
      .nullable(),
    permission: z.string().optional(),
    privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
    repositories_url: z.string().optional(),
    slug: z.string().optional(),
    url: z.string().optional(),
  }),
});

export const scope4Schema = z.union([z.literal('team'), z.literal('organization')]);

export const webhookMergeGroupChecksRequestedSchema = z.object({
  action: z.string(),
  installation: simpleInstallationSchema.optional(),
  merge_group: z.object({
    base_ref: z.string(),
    base_sha: z.string(),
    head_commit: z.object({
      author: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      committer: z.object({
        date: z.string().optional(),
        email: z.string().nullable(),
        name: z.string(),
        username: z.string().optional(),
      }),
      id: z.string(),
      message: z.string(),
      timestamp: z.string(),
      tree_id: z.string(),
    }),
    head_ref: z.string(),
    head_sha: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookMetaDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  hook: z.object({
    active: z.boolean(),
    config: z.object({
      content_type: z.union([z.literal('json'), z.literal('form')]),
      insecure_ssl: z.string(),
      secret: z.string().optional(),
      url: z.string(),
    }),
    created_at: z.string(),
    events: z.array(
      z.union([
        z.literal('*'),
        z.literal('branch_protection_rule'),
        z.literal('check_run'),
        z.literal('check_suite'),
        z.literal('code_scanning_alert'),
        z.literal('commit_comment'),
        z.literal('create'),
        z.literal('delete'),
        z.literal('deployment'),
        z.literal('deployment_status'),
        z.literal('deploy_key'),
        z.literal('discussion'),
        z.literal('discussion_comment'),
        z.literal('fork'),
        z.literal('gollum'),
        z.literal('issues'),
        z.literal('issue_comment'),
        z.literal('label'),
        z.literal('member'),
        z.literal('membership'),
        z.literal('meta'),
        z.literal('milestone'),
        z.literal('organization'),
        z.literal('org_block'),
        z.literal('package'),
        z.literal('page_build'),
        z.literal('project'),
        z.literal('project_card'),
        z.literal('project_column'),
        z.literal('public'),
        z.literal('pull_request'),
        z.literal('pull_request_review'),
        z.literal('pull_request_review_comment'),
        z.literal('pull_request_review_thread'),
        z.literal('push'),
        z.literal('registry_package'),
        z.literal('release'),
        z.literal('repository'),
        z.literal('repository_import'),
        z.literal('repository_vulnerability_alert'),
        z.literal('secret_scanning_alert'),
        z.literal('secret_scanning_alert_location'),
        z.literal('security_and_analysis'),
        z.literal('star'),
        z.literal('status'),
        z.literal('team'),
        z.literal('team_add'),
        z.literal('watch'),
        z.literal('workflow_job'),
        z.literal('workflow_run'),
        z.literal('repository_dispatch'),
        z.literal('projects_v2_item'),
      ]),
    ),
    id: z.number(),
    name: z.string(),
    type: z.string(),
    updated_at: z.string(),
  }),
  hook_id: z.number(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: nullableRepositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const contentTypeSchema = z.union([z.literal('json'), z.literal('form')]);

export const webhookMilestoneClosedSchema = z.object({
  action: z.literal('closed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMilestoneCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMilestoneDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMilestoneEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    description: z
      .object({
        from: z.string(),
      })
      .optional(),
    due_on: z
      .object({
        from: z.string(),
      })
      .optional(),
    title: z
      .object({
        from: z.string(),
      })
      .optional(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookMilestoneOpenedSchema = z.object({
  action: z.literal('opened'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  milestone: z.object({
    closed_at: z.string().nullable(),
    closed_issues: z.number(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    description: z.string().nullable(),
    due_on: z.string().nullable(),
    html_url: z.string(),
    id: z.number(),
    labels_url: z.string(),
    node_id: z.string(),
    number: z.number(),
    open_issues: z.number(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookOrgBlockBlockedSchema = z.object({
  action: z.literal('blocked'),
  blocked_user: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action42Schema = z.literal('blocked');

export const webhookOrgBlockUnblockedSchema = z.object({
  action: z.literal('unblocked'),
  blocked_user: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action43Schema = z.literal('unblocked');

export const webhookOrganizationDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  membership: z
    .object({
      organization_url: z.string(),
      role: z.string(),
      state: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .optional(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookOrganizationMemberAddedSchema = z.object({
  action: z.literal('member_added'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  membership: z.object({
    organization_url: z.string(),
    role: z.string(),
    state: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action44Schema = z.literal('member_added');

export const webhookOrganizationMemberInvitedSchema = z.object({
  action: z.literal('member_invited'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  invitation: z.object({
    created_at: z.string(),
    email: z.string().nullable(),
    failed_at: z.string().nullable(),
    failed_reason: z.string().nullable(),
    id: z.number(),
    invitation_source: z.string().optional(),
    invitation_teams_url: z.string(),
    inviter: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    login: z.string().nullable(),
    node_id: z.string(),
    role: z.string(),
    team_count: z.number(),
  }),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
  user: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .optional()
    .nullable(),
});

export const action45Schema = z.literal('member_invited');

export const webhookOrganizationMemberRemovedSchema = z.object({
  action: z.literal('member_removed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  membership: z.object({
    organization_url: z.string(),
    role: z.string(),
    state: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action46Schema = z.literal('member_removed');

export const webhookOrganizationRenamedSchema = z.object({
  action: z.literal('renamed'),
  changes: z
    .object({
      login: z
        .object({
          from: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  membership: z
    .object({
      organization_url: z.string(),
      role: z.string(),
      state: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .optional(),
  organization: organizationSimpleSchema,
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action47Schema = z.literal('renamed');

export const webhookPackagePublishedSchema = z.object({
  action: z.literal('published'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  package: z.object({
    created_at: z.string().nullable(),
    description: z.string().nullable(),
    ecosystem: z.string(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    namespace: z.string(),
    owner: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    package_type: z.string(),
    package_version: z
      .object({
        author: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .optional()
          .nullable(),
        body: z.union([z.string(), z.record(z.unknown())]).optional(),
        body_html: z.string().optional(),
        container_metadata: z
          .object({
            labels: z.record(z.unknown()).optional().nullable(),
            manifest: z.record(z.unknown()).optional().nullable(),
            tag: z
              .object({
                digest: z.string().optional(),
                name: z.string().optional(),
              })
              .optional(),
          })
          .optional()
          .nullable(),
        created_at: z.string().optional(),
        description: z.string(),
        docker_metadata: z.array(z.unknown()).optional(),
        draft: z.boolean().optional(),
        html_url: z.string(),
        id: z.number(),
        installation_command: z.string(),
        manifest: z.string().optional(),
        metadata: z.array(z.record(z.unknown())),
        name: z.string(),
        npm_metadata: z
          .object({
            author: z.record(z.unknown()).optional().nullable(),
            bin: z.record(z.unknown()).optional(),
            bugs: z.record(z.unknown()).optional().nullable(),
            commit_oid: z.string().optional(),
            contributors: z.array(z.record(z.unknown())).optional(),
            cpu: z.array(z.string()).optional(),
            deleted_by_id: z.number().optional(),
            dependencies: z.record(z.unknown()).optional(),
            description: z.string().optional(),
            dev_dependencies: z.record(z.unknown()).optional(),
            directories: z.record(z.unknown()).optional().nullable(),
            dist: z.record(z.unknown()).optional().nullable(),
            engines: z.record(z.unknown()).optional(),
            files: z.array(z.string()).optional(),
            git_head: z.string().optional(),
            has_shrinkwrap: z.boolean().optional(),
            homepage: z.string().optional(),
            id: z.string().optional(),
            installation_command: z.string().optional(),
            keywords: z.array(z.string()).optional(),
            license: z.string().optional(),
            main: z.string().optional(),
            maintainers: z.array(z.record(z.unknown())).optional(),
            man: z.record(z.unknown()).optional(),
            name: z.string().optional(),
            node_version: z.string().optional(),
            npm_user: z.string().optional(),
            npm_version: z.string().optional(),
            optional_dependencies: z.record(z.unknown()).optional(),
            os: z.array(z.string()).optional(),
            peer_dependencies: z.record(z.unknown()).optional(),
            published_via_actions: z.boolean().optional(),
            readme: z.string().optional(),
            release_id: z.number().optional(),
            repository: z.record(z.unknown()).optional().nullable(),
            scripts: z.record(z.unknown()).optional(),
            version: z.string().optional(),
          })
          .optional()
          .nullable(),
        nuget_metadata: z
          .array(
            z.object({
              id: z.union([z.number(), z.string()]).optional(),
              name: z.string().optional(),
              value: z
                .union([
                  z.boolean(),
                  z.string(),
                  z.number(),
                  z.object({
                    branch: z.string().optional(),
                    commit: z.string().optional(),
                    type: z.string().optional(),
                    url: z.string().optional(),
                  }),
                ])
                .optional(),
            }),
          )
          .optional()
          .nullable(),
        package_files: z.array(
          z.object({
            content_type: z.string(),
            created_at: z.string(),
            download_url: z.string(),
            id: z.number(),
            md5: z.string().nullable(),
            name: z.string(),
            sha1: z.string().nullable(),
            sha256: z.string().nullable(),
            size: z.number(),
            state: z.string().nullable(),
            updated_at: z.string(),
          }),
        ),
        package_url: z.string().optional(),
        prerelease: z.boolean().optional(),
        release: z
          .object({
            author: z
              .object({
                avatar_url: z.string().optional(),
                deleted: z.boolean().optional(),
                email: z.string().optional().nullable(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number(),
                login: z.string(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                url: z.string().optional(),
              })
              .nullable(),
            created_at: z.string(),
            draft: z.boolean(),
            html_url: z.string(),
            id: z.number(),
            name: z.string().nullable(),
            prerelease: z.boolean(),
            published_at: z.string(),
            tag_name: z.string(),
            target_commitish: z.string(),
            url: z.string(),
          })
          .optional(),
        rubygems_metadata: z.array(z.unknown()).optional(),
        source_url: z.string().optional(),
        summary: z.string(),
        tag_name: z.string().optional(),
        target_commitish: z.string().optional(),
        target_oid: z.string().optional(),
        updated_at: z.string().optional(),
        version: z.string(),
      })
      .nullable(),
    registry: z
      .object({
        about_url: z.string(),
        name: z.string(),
        type: z.string(),
        url: z.string(),
        vendor: z.string(),
      })
      .nullable(),
    updated_at: z.string().nullable(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action48Schema = z.literal('published');

export const webhookPackageUpdatedSchema = z.object({
  action: z.literal('updated'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  package: z.object({
    created_at: z.string(),
    description: z.string().nullable(),
    ecosystem: z.string(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    namespace: z.string(),
    owner: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    package_type: z.string(),
    package_version: z.object({
      author: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      body: z.string(),
      body_html: z.string(),
      created_at: z.string(),
      description: z.string(),
      docker_metadata: z.array(z.unknown()).optional(),
      draft: z.boolean().optional(),
      html_url: z.string(),
      id: z.number(),
      installation_command: z.string(),
      manifest: z.string().optional(),
      metadata: z.array(z.unknown()),
      name: z.string(),
      package_files: z.array(
        z.object({
          content_type: z.string(),
          created_at: z.string(),
          download_url: z.string(),
          id: z.number(),
          md5: z.string().nullable(),
          name: z.string(),
          sha1: z.string().nullable(),
          sha256: z.string(),
          size: z.number(),
          state: z.string(),
          updated_at: z.string(),
        }),
      ),
      package_url: z.string().optional(),
      prerelease: z.boolean().optional(),
      release: z
        .object({
          author: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          created_at: z.string(),
          draft: z.boolean(),
          html_url: z.string(),
          id: z.number(),
          name: z.string(),
          prerelease: z.boolean(),
          published_at: z.string(),
          tag_name: z.string(),
          target_commitish: z.string(),
          url: z.string(),
        })
        .optional(),
      rubygems_metadata: z.array(z.unknown()).optional(),
      source_url: z.string().optional(),
      summary: z.string(),
      tag_name: z.string().optional(),
      target_commitish: z.string(),
      target_oid: z.string(),
      updated_at: z.string(),
      version: z.string(),
    }),
    registry: z
      .object({
        about_url: z.string(),
        name: z.string(),
        type: z.string(),
        url: z.string(),
        vendor: z.string(),
      })
      .nullable(),
    updated_at: z.string(),
  }),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action49Schema = z.literal('updated');

export const webhookPageBuildSchema = z.object({
  build: z.object({
    commit: z.string().nullable(),
    created_at: z.string(),
    duration: z.number(),
    error: z.object({
      message: z.string().nullable(),
    }),
    pusher: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    status: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  enterprise: enterpriseSchema.optional(),
  id: z.number(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookPingSchema = z.object({
  hook: z
    .object({
      active: z.boolean(),
      app_id: z.number().optional(),
      config: z.object({
        content_type: webhookConfigContentTypeSchema.optional(),
        insecure_ssl: webhookConfigInsecureSslSchema.optional(),
        secret: webhookConfigSecretSchema.optional(),
        url: webhookConfigUrlSchema.optional(),
      }),
      created_at: z.string(),
      deliveries_url: z.string().optional(),
      events: z.array(z.string()),
      id: z.number(),
      last_response: hookResponseSchema.optional(),
      name: z.literal('web'),
      ping_url: z.string().optional(),
      test_url: z.string().optional(),
      type: z.string(),
      updated_at: z.string(),
      url: z.string().optional(),
    })
    .optional(),
  hook_id: z.number().optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
  zen: z.string().optional(),
});

export const nameSchema = z.literal('web');

export const webhookPingFormEncodedSchema = z.object({
  payload: z.string(),
});

export const webhookProjectCardConvertedSchema = z.object({
  action: z.literal('converted'),
  changes: z.object({
    note: z.object({
      from: z.string(),
    }),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_card: z.object({
    after_id: z.number().optional().nullable(),
    archived: z.boolean(),
    column_id: z.number(),
    column_url: z.string(),
    content_url: z.string().optional(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    id: z.number(),
    node_id: z.string(),
    note: z.string().nullable(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action50Schema = z.literal('converted');

export const webhookProjectCardCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_card: z.object({
    after_id: z.number().optional().nullable(),
    archived: z.boolean(),
    column_id: z.number(),
    column_url: z.string(),
    content_url: z.string().optional(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    id: z.number(),
    node_id: z.string(),
    note: z.string().nullable(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectCardDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_card: z.object({
    after_id: z.number().optional().nullable(),
    archived: z.boolean(),
    column_id: z.number().nullable(),
    column_url: z.string(),
    content_url: z.string().optional(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    id: z.number(),
    node_id: z.string(),
    note: z.string().nullable(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: nullableRepositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectCardEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    note: z.object({
      from: z.string().nullable(),
    }),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_card: z.object({
    after_id: z.number().optional().nullable(),
    archived: z.boolean(),
    column_id: z.number(),
    column_url: z.string(),
    content_url: z.string().optional(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    id: z.number(),
    node_id: z.string(),
    note: z.string().nullable(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectCardMovedSchema = z.object({
  action: z.literal('moved'),
  changes: z
    .object({
      column_id: z.object({
        from: z.number(),
      }),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_card: z
    .object({
      after_id: z.number().optional().nullable(),
      archived: z.boolean(),
      column_id: z.number(),
      column_url: z.string(),
      content_url: z.string().optional(),
      created_at: z.string(),
      creator: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
      id: z.number(),
      node_id: z.string(),
      note: z.string().nullable(),
      project_url: z.string(),
      updated_at: z.string(),
      url: z.string(),
    })
    .and(
      z.object({
        after_id: z.number().nullable(),
        archived: z.boolean().optional(),
        column_id: z.number().optional(),
        column_url: z.string().optional(),
        created_at: z.string().optional(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional()
          .nullable(),
        id: z.number().optional(),
        node_id: z.string().optional(),
        note: z.string().optional().nullable(),
        project_url: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const action51Schema = z.literal('moved');

export const webhookProjectClosedSchema = z.object({
  action: z.literal('closed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project: z.object({
    body: z.string().nullable(),
    columns_url: z.string(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    number: z.number(),
    owner_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectColumnCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_column: z.object({
    after_id: z.number().optional().nullable(),
    cards_url: z.string(),
    created_at: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookProjectColumnDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_column: z.object({
    after_id: z.number().optional().nullable(),
    cards_url: z.string(),
    created_at: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: nullableRepositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookProjectColumnEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    name: z
      .object({
        from: z.string(),
      })
      .optional(),
  }),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_column: z.object({
    after_id: z.number().optional().nullable(),
    cards_url: z.string(),
    created_at: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookProjectColumnMovedSchema = z.object({
  action: z.literal('moved'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project_column: z.object({
    after_id: z.number().optional().nullable(),
    cards_url: z.string(),
    created_at: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    project_url: z.string(),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectCreatedSchema = z.object({
  action: z.literal('created'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project: z.object({
    body: z.string().nullable(),
    columns_url: z.string(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    number: z.number(),
    owner_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const webhookProjectDeletedSchema = z.object({
  action: z.literal('deleted'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project: z.object({
    body: z.string().nullable(),
    columns_url: z.string(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    number: z.number(),
    owner_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: nullableRepositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookProjectEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z
    .object({
      body: z
        .object({
          from: z.string(),
        })
        .optional(),
      name: z
        .object({
          from: z.string(),
        })
        .optional(),
    })
    .optional(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project: z.object({
    body: z.string().nullable(),
    columns_url: z.string(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    number: z.number(),
    owner_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema.optional(),
});

export const webhookProjectReopenedSchema = z.object({
  action: z.literal('reopened'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  project: z.object({
    body: z.string().nullable(),
    columns_url: z.string(),
    created_at: z.string(),
    creator: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    html_url: z.string(),
    id: z.number(),
    name: z.string(),
    node_id: z.string(),
    number: z.number(),
    owner_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    updated_at: z.string(),
    url: z.string(),
  }),
  repository: repositorySchema.optional(),
  sender: simpleUserSchema,
});

export const projectsV2ItemSchema = z.object({
  archived_at: z.string().nullable(),
  content_node_id: z.string(),
  content_type: projectsV2ItemContentTypeSchema,
  created_at: z.string(),
  creator: simpleUserSchema.optional(),
  id: z.number(),
  node_id: z.string().optional(),
  project_node_id: z.string().optional(),
  updated_at: z.string(),
});

export const action52Schema = z.literal('archived');

export const webhookProjectsV2ItemConvertedSchema = z.object({
  action: z.literal('converted'),
  changes: z.object({
    content_type: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional(),
      })
      .optional(),
  }),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ItemCreatedSchema = z.object({
  action: z.literal('created'),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ItemDeletedSchema = z.object({
  action: z.literal('deleted'),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ItemEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z
    .union([
      z.object({
        field_value: z.object({
          field_node_id: z.string().optional(),
          field_type: z.string().optional(),
        }),
      }),
      z.object({
        body: z.object({
          from: z.string().optional().nullable(),
          to: z.string().optional().nullable(),
        }),
      }),
    ])
    .optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ItemReorderedSchema = z.object({
  action: z.literal('reordered'),
  changes: z.object({
    previous_projects_v2_item_node_id: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional().nullable(),
      })
      .optional(),
  }),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const action53Schema = z.literal('reordered');

export const webhookProjectsV2ItemRestoredSchema = z.object({
  action: z.literal('restored'),
  changes: z.object({
    archived_at: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional().nullable(),
      })
      .optional(),
  }),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema,
  projects_v2_item: projectsV2ItemSchema,
  sender: simpleUserSchema,
});

export const action54Schema = z.literal('restored');

export const webhookProjectsV2ProjectClosedSchema = z.object({
  action: z.literal('closed'),
  organization: organizationSimpleSchema,
  projects_v2: projectsV2Schema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ProjectCreatedSchema = z.object({
  action: z.literal('created'),
  organization: organizationSimpleSchema,
  projects_v2: projectsV2Schema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ProjectEditedSchema = z.object({
  action: z.literal('edited'),
  changes: z.object({
    description: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional().nullable(),
      })
      .optional(),
    public: z
      .object({
        from: z.boolean().optional(),
        to: z.boolean().optional(),
      })
      .optional(),
    short_description: z
      .object({
        from: z.string().optional().nullable(),
        to: z.string().optional().nullable(),
      })
      .optional(),
    title: z
      .object({
        from: z.string().optional(),
        to: z.string().optional(),
      })
      .optional(),
  }),
  organization: organizationSimpleSchema,
  projects_v2: projectsV2Schema,
  sender: simpleUserSchema,
});

export const webhookProjectsV2ProjectReopenedSchema = z.object({
  action: z.literal('reopened'),
  organization: organizationSimpleSchema,
  projects_v2: projectsV2Schema,
  sender: simpleUserSchema,
});

export const webhookPublicSchema = z.object({
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  organization: organizationSimpleSchema.optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookPullRequestAssignedSchema = z.object({
  action: z.literal('assigned'),
  assignee: z
    .object({
      avatar_url: z.string().optional(),
      deleted: z.boolean().optional(),
      email: z.string().optional().nullable(),
      events_url: z.string().optional(),
      followers_url: z.string().optional(),
      following_url: z.string().optional(),
      gists_url: z.string().optional(),
      gravatar_id: z.string().optional(),
      html_url: z.string().optional(),
      id: z.number(),
      login: z.string(),
      name: z.string().optional(),
      node_id: z.string().optional(),
      organizations_url: z.string().optional(),
      received_events_url: z.string().optional(),
      repos_url: z.string().optional(),
      site_admin: z.boolean().optional(),
      starred_url: z.string().optional(),
      subscriptions_url: z.string().optional(),
      type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
      url: z.string().optional(),
    })
    .nullable(),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z.object({
    _links: z.object({
      comments: z.object({
        href: z.string(),
      }),
      commits: z.object({
        href: z.string(),
      }),
      html: z.object({
        href: z.string(),
      }),
      issue: z.object({
        href: z.string(),
      }),
      review_comment: z.object({
        href: z.string(),
      }),
      review_comments: z.object({
        href: z.string(),
      }),
      self: z.object({
        href: z.string(),
      }),
      statuses: z.object({
        href: z.string(),
      }),
    }),
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    additions: z.number().optional(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    auto_merge: z
      .object({
        commit_message: z.string().nullable(),
        commit_title: z.string().nullable(),
        enabled_by: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
      })
      .nullable(),
    base: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    body: z.string().nullable(),
    changed_files: z.number().optional(),
    closed_at: z.string().nullable(),
    comments: z.number().optional(),
    comments_url: z.string(),
    commits: z.number().optional(),
    commits_url: z.string(),
    created_at: z.string(),
    deletions: z.number().optional(),
    diff_url: z.string(),
    draft: z.boolean(),
    head: z.object({
      label: z.string().nullable(),
      ref: z.string(),
      repo: z
        .object({
          allow_auto_merge: z.boolean().optional(),
          allow_forking: z.boolean().optional(),
          allow_merge_commit: z.boolean().optional(),
          allow_rebase_merge: z.boolean().optional(),
          allow_squash_merge: z.boolean().optional(),
          allow_update_branch: z.boolean().optional(),
          archive_url: z.string(),
          archived: z.boolean(),
          assignees_url: z.string(),
          blobs_url: z.string(),
          branches_url: z.string(),
          clone_url: z.string(),
          collaborators_url: z.string(),
          comments_url: z.string(),
          commits_url: z.string(),
          compare_url: z.string(),
          contents_url: z.string(),
          contributors_url: z.string(),
          created_at: z.union([z.number(), z.string()]),
          default_branch: z.string(),
          delete_branch_on_merge: z.boolean().optional(),
          deployments_url: z.string(),
          description: z.string().nullable(),
          disabled: z.boolean().optional(),
          downloads_url: z.string(),
          events_url: z.string(),
          fork: z.boolean(),
          forks: z.number(),
          forks_count: z.number(),
          forks_url: z.string(),
          full_name: z.string(),
          git_commits_url: z.string(),
          git_refs_url: z.string(),
          git_tags_url: z.string(),
          git_url: z.string(),
          has_discussions: z.boolean(),
          has_downloads: z.boolean(),
          has_issues: z.boolean(),
          has_pages: z.boolean(),
          has_projects: z.boolean(),
          has_wiki: z.boolean(),
          homepage: z.string().nullable(),
          hooks_url: z.string(),
          html_url: z.string(),
          id: z.number(),
          is_template: z.boolean().optional(),
          issue_comment_url: z.string(),
          issue_events_url: z.string(),
          issues_url: z.string(),
          keys_url: z.string(),
          labels_url: z.string(),
          language: z.string().nullable(),
          languages_url: z.string(),
          license: z
            .object({
              key: z.string(),
              name: z.string(),
              node_id: z.string(),
              spdx_id: z.string(),
              url: z.string().nullable(),
            })
            .nullable(),
          master_branch: z.string().optional(),
          merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
          merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
          merges_url: z.string(),
          milestones_url: z.string(),
          mirror_url: z.string().nullable(),
          name: z.string(),
          node_id: z.string(),
          notifications_url: z.string(),
          open_issues: z.number(),
          open_issues_count: z.number(),
          organization: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              admin: z.boolean(),
              maintain: z.boolean().optional(),
              pull: z.boolean(),
              push: z.boolean(),
              triage: z.boolean().optional(),
            })
            .optional(),
          private: z.boolean(),
          public: z.boolean().optional(),
          pulls_url: z.string(),
          pushed_at: z.union([z.number(), z.string()]).nullable(),
          releases_url: z.string(),
          role_name: z.string().optional().nullable(),
          size: z.number(),
          squash_merge_commit_message: z
            .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
            .optional(),
          squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
          ssh_url: z.string(),
          stargazers: z.number().optional(),
          stargazers_count: z.number(),
          stargazers_url: z.string(),
          statuses_url: z.string(),
          subscribers_url: z.string(),
          subscription_url: z.string(),
          svn_url: z.string(),
          tags_url: z.string(),
          teams_url: z.string(),
          topics: z.array(z.string()),
          trees_url: z.string(),
          updated_at: z.string(),
          url: z.string(),
          use_squash_pr_title_as_default: z.boolean().optional(),
          visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
          watchers: z.number(),
          watchers_count: z.number(),
          web_commit_signoff_required: z.boolean().optional(),
        })
        .nullable(),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    labels: z.array(
      z.object({
        color: z.string(),
        default: z.boolean(),
        description: z.string().nullable(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        url: z.string(),
      }),
    ),
    locked: z.boolean(),
    maintainer_can_modify: z.boolean().optional(),
    merge_commit_sha: z.string().nullable(),
    mergeable: z.boolean().optional().nullable(),
    mergeable_state: z.string().optional(),
    merged: z.boolean().optional().nullable(),
    merged_at: z.string().nullable(),
    merged_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    patch_url: z.string(),
    rebaseable: z.boolean().optional().nullable(),
    requested_reviewers: z.array(
      z
        .union([
          z.object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          }),
          z.object({
            deleted: z.boolean().optional(),
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            parent: z
              .object({
                description: z.string().nullable(),
                html_url: z.string(),
                id: z.number(),
                members_url: z.string(),
                name: z.string(),
                node_id: z.string(),
                permission: z.string(),
                privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                repositories_url: z.string(),
                slug: z.string(),
                url: z.string(),
              })
              .optional()
              .nullable(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          }),
        ])
        .nullable(),
    ),
    requested_teams: z.array(
      z.object({
        deleted: z.boolean().optional(),
        description: z.string().optional().nullable(),
        html_url: z.string().optional(),
        id: z.number(),
        members_url: z.string().optional(),
        name: z.string(),
        node_id: z.string().optional(),
        parent: z
          .object({
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          })
          .optional()
          .nullable(),
        permission: z.string().optional(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
        repositories_url: z.string().optional(),
        slug: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
    review_comment_url: z.string(),
    review_comments: z.number().optional(),
    review_comments_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    statuses_url: z.string(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookPullRequestAutoMergeDisabledSchema = z.object({
  action: z.literal('auto_merge_disabled'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z.object({
    _links: z.object({
      comments: z.object({
        href: z.string(),
      }),
      commits: z.object({
        href: z.string(),
      }),
      html: z.object({
        href: z.string(),
      }),
      issue: z.object({
        href: z.string(),
      }),
      review_comment: z.object({
        href: z.string(),
      }),
      review_comments: z.object({
        href: z.string(),
      }),
      self: z.object({
        href: z.string(),
      }),
      statuses: z.object({
        href: z.string(),
      }),
    }),
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    additions: z.number().optional(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    auto_merge: z
      .object({
        commit_message: z.string().nullable(),
        commit_title: z.string().nullable(),
        enabled_by: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
      })
      .nullable(),
    base: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    body: z.string().nullable(),
    changed_files: z.number().optional(),
    closed_at: z.string().nullable(),
    comments: z.number().optional(),
    comments_url: z.string(),
    commits: z.number().optional(),
    commits_url: z.string(),
    created_at: z.string(),
    deletions: z.number().optional(),
    diff_url: z.string(),
    draft: z.boolean(),
    head: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    labels: z.array(
      z.object({
        color: z.string(),
        default: z.boolean(),
        description: z.string().nullable(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        url: z.string(),
      }),
    ),
    locked: z.boolean(),
    maintainer_can_modify: z.boolean().optional(),
    merge_commit_sha: z.string().nullable(),
    mergeable: z.boolean().optional().nullable(),
    mergeable_state: z.string().optional(),
    merged: z.boolean().optional().nullable(),
    merged_at: z.string().nullable(),
    merged_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    patch_url: z.string(),
    rebaseable: z.boolean().optional().nullable(),
    requested_reviewers: z.array(
      z
        .union([
          z.object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          }),
          z.object({
            deleted: z.boolean().optional(),
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            parent: z
              .object({
                description: z.string().nullable(),
                html_url: z.string(),
                id: z.number(),
                members_url: z.string(),
                name: z.string(),
                node_id: z.string(),
                permission: z.string(),
                privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                repositories_url: z.string(),
                slug: z.string(),
                url: z.string(),
              })
              .optional()
              .nullable(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          }),
        ])
        .nullable(),
    ),
    requested_teams: z.array(
      z.object({
        deleted: z.boolean().optional(),
        description: z.string().optional().nullable(),
        html_url: z.string().optional(),
        id: z.number(),
        members_url: z.string().optional(),
        name: z.string(),
        node_id: z.string().optional(),
        parent: z
          .object({
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          })
          .optional()
          .nullable(),
        permission: z.string().optional(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
        repositories_url: z.string().optional(),
        slug: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
    review_comment_url: z.string(),
    review_comments: z.number().optional(),
    review_comments_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    statuses_url: z.string(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  reason: z.string(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action55Schema = z.literal('auto_merge_disabled');

export const webhookPullRequestAutoMergeEnabledSchema = z.object({
  action: z.literal('auto_merge_enabled'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z.object({
    _links: z.object({
      comments: z.object({
        href: z.string(),
      }),
      commits: z.object({
        href: z.string(),
      }),
      html: z.object({
        href: z.string(),
      }),
      issue: z.object({
        href: z.string(),
      }),
      review_comment: z.object({
        href: z.string(),
      }),
      review_comments: z.object({
        href: z.string(),
      }),
      self: z.object({
        href: z.string(),
      }),
      statuses: z.object({
        href: z.string(),
      }),
    }),
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    additions: z.number().optional(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    auto_merge: z
      .object({
        commit_message: z.string().nullable(),
        commit_title: z.string().nullable(),
        enabled_by: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
      })
      .nullable(),
    base: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    body: z.string().nullable(),
    changed_files: z.number().optional(),
    closed_at: z.string().nullable(),
    comments: z.number().optional(),
    comments_url: z.string(),
    commits: z.number().optional(),
    commits_url: z.string(),
    created_at: z.string(),
    deletions: z.number().optional(),
    diff_url: z.string(),
    draft: z.boolean(),
    head: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    labels: z.array(
      z.object({
        color: z.string(),
        default: z.boolean(),
        description: z.string().nullable(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        url: z.string(),
      }),
    ),
    locked: z.boolean(),
    maintainer_can_modify: z.boolean().optional(),
    merge_commit_sha: z.string().nullable(),
    mergeable: z.boolean().optional().nullable(),
    mergeable_state: z.string().optional(),
    merged: z.boolean().optional().nullable(),
    merged_at: z.string().nullable(),
    merged_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    patch_url: z.string(),
    rebaseable: z.boolean().optional().nullable(),
    requested_reviewers: z.array(
      z
        .union([
          z.object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          }),
          z.object({
            deleted: z.boolean().optional(),
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            parent: z
              .object({
                description: z.string().nullable(),
                html_url: z.string(),
                id: z.number(),
                members_url: z.string(),
                name: z.string(),
                node_id: z.string(),
                permission: z.string(),
                privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                repositories_url: z.string(),
                slug: z.string(),
                url: z.string(),
              })
              .optional()
              .nullable(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          }),
        ])
        .nullable(),
    ),
    requested_teams: z.array(
      z.object({
        deleted: z.boolean().optional(),
        description: z.string().optional().nullable(),
        html_url: z.string().optional(),
        id: z.number(),
        members_url: z.string().optional(),
        name: z.string(),
        node_id: z.string().optional(),
        parent: z
          .object({
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          })
          .optional()
          .nullable(),
        permission: z.string().optional(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
        repositories_url: z.string().optional(),
        slug: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
    review_comment_url: z.string(),
    review_comments: z.number().optional(),
    review_comments_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    statuses_url: z.string(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  reason: z.string().optional(),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action56Schema = z.literal('auto_merge_enabled');

export const webhookPullRequestClosedSchema = z.object({
  action: z.literal('closed'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z
    .object({
      _links: z.object({
        comments: z.object({
          href: z.string(),
        }),
        commits: z.object({
          href: z.string(),
        }),
        html: z.object({
          href: z.string(),
        }),
        issue: z.object({
          href: z.string(),
        }),
        review_comment: z.object({
          href: z.string(),
        }),
        review_comments: z.object({
          href: z.string(),
        }),
        self: z.object({
          href: z.string(),
        }),
        statuses: z.object({
          href: z.string(),
        }),
      }),
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      additions: z.number().optional(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      auto_merge: z
        .object({
          commit_message: z.string().nullable(),
          commit_title: z.string().nullable(),
          enabled_by: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
        })
        .nullable(),
      base: z.object({
        label: z.string(),
        ref: z.string(),
        repo: z.object({
          allow_auto_merge: z.boolean().optional(),
          allow_forking: z.boolean().optional(),
          allow_merge_commit: z.boolean().optional(),
          allow_rebase_merge: z.boolean().optional(),
          allow_squash_merge: z.boolean().optional(),
          allow_update_branch: z.boolean().optional(),
          archive_url: z.string(),
          archived: z.boolean(),
          assignees_url: z.string(),
          blobs_url: z.string(),
          branches_url: z.string(),
          clone_url: z.string(),
          collaborators_url: z.string(),
          comments_url: z.string(),
          commits_url: z.string(),
          compare_url: z.string(),
          contents_url: z.string(),
          contributors_url: z.string(),
          created_at: z.union([z.number(), z.string()]),
          default_branch: z.string(),
          delete_branch_on_merge: z.boolean().optional(),
          deployments_url: z.string(),
          description: z.string().nullable(),
          disabled: z.boolean().optional(),
          downloads_url: z.string(),
          events_url: z.string(),
          fork: z.boolean(),
          forks: z.number(),
          forks_count: z.number(),
          forks_url: z.string(),
          full_name: z.string(),
          git_commits_url: z.string(),
          git_refs_url: z.string(),
          git_tags_url: z.string(),
          git_url: z.string(),
          has_downloads: z.boolean(),
          has_issues: z.boolean(),
          has_pages: z.boolean(),
          has_projects: z.boolean(),
          has_wiki: z.boolean(),
          homepage: z.string().nullable(),
          hooks_url: z.string(),
          html_url: z.string(),
          id: z.number(),
          is_template: z.boolean().optional(),
          issue_comment_url: z.string(),
          issue_events_url: z.string(),
          issues_url: z.string(),
          keys_url: z.string(),
          labels_url: z.string(),
          language: z.string().nullable(),
          languages_url: z.string(),
          license: z
            .object({
              key: z.string(),
              name: z.string(),
              node_id: z.string(),
              spdx_id: z.string(),
              url: z.string().nullable(),
            })
            .nullable(),
          master_branch: z.string().optional(),
          merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
          merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
          merges_url: z.string(),
          milestones_url: z.string(),
          mirror_url: z.string().nullable(),
          name: z.string(),
          node_id: z.string(),
          notifications_url: z.string(),
          open_issues: z.number(),
          open_issues_count: z.number(),
          organization: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              admin: z.boolean(),
              maintain: z.boolean().optional(),
              pull: z.boolean(),
              push: z.boolean(),
              triage: z.boolean().optional(),
            })
            .optional(),
          private: z.boolean(),
          public: z.boolean().optional(),
          pulls_url: z.string(),
          pushed_at: z.union([z.number(), z.string()]).nullable(),
          releases_url: z.string(),
          role_name: z.string().optional().nullable(),
          size: z.number(),
          squash_merge_commit_message: z
            .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
            .optional(),
          squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
          ssh_url: z.string(),
          stargazers: z.number().optional(),
          stargazers_count: z.number(),
          stargazers_url: z.string(),
          statuses_url: z.string(),
          subscribers_url: z.string(),
          subscription_url: z.string(),
          svn_url: z.string(),
          tags_url: z.string(),
          teams_url: z.string(),
          topics: z.array(z.string()),
          trees_url: z.string(),
          updated_at: z.string(),
          url: z.string(),
          use_squash_pr_title_as_default: z.boolean().optional(),
          visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
          watchers: z.number(),
          watchers_count: z.number(),
          web_commit_signoff_required: z.boolean().optional(),
        }),
        sha: z.string(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      }),
      body: z.string().nullable(),
      changed_files: z.number().optional(),
      closed_at: z.string().nullable(),
      comments: z.number().optional(),
      comments_url: z.string(),
      commits: z.number().optional(),
      commits_url: z.string(),
      created_at: z.string(),
      deletions: z.number().optional(),
      diff_url: z.string(),
      draft: z.boolean(),
      head: z.object({
        label: z.string().nullable(),
        ref: z.string(),
        repo: z
          .object({
            allow_auto_merge: z.boolean().optional(),
            allow_forking: z.boolean().optional(),
            allow_merge_commit: z.boolean().optional(),
            allow_rebase_merge: z.boolean().optional(),
            allow_squash_merge: z.boolean().optional(),
            allow_update_branch: z.boolean().optional(),
            archive_url: z.string(),
            archived: z.boolean(),
            assignees_url: z.string(),
            blobs_url: z.string(),
            branches_url: z.string(),
            clone_url: z.string(),
            collaborators_url: z.string(),
            comments_url: z.string(),
            commits_url: z.string(),
            compare_url: z.string(),
            contents_url: z.string(),
            contributors_url: z.string(),
            created_at: z.union([z.number(), z.string()]),
            default_branch: z.string(),
            delete_branch_on_merge: z.boolean().optional(),
            deployments_url: z.string(),
            description: z.string().nullable(),
            disabled: z.boolean().optional(),
            downloads_url: z.string(),
            events_url: z.string(),
            fork: z.boolean(),
            forks: z.number(),
            forks_count: z.number(),
            forks_url: z.string(),
            full_name: z.string(),
            git_commits_url: z.string(),
            git_refs_url: z.string(),
            git_tags_url: z.string(),
            git_url: z.string(),
            has_downloads: z.boolean(),
            has_issues: z.boolean(),
            has_pages: z.boolean(),
            has_projects: z.boolean(),
            has_wiki: z.boolean(),
            homepage: z.string().nullable(),
            hooks_url: z.string(),
            html_url: z.string(),
            id: z.number(),
            is_template: z.boolean().optional(),
            issue_comment_url: z.string(),
            issue_events_url: z.string(),
            issues_url: z.string(),
            keys_url: z.string(),
            labels_url: z.string(),
            language: z.string().nullable(),
            languages_url: z.string(),
            license: z
              .object({
                key: z.string(),
                name: z.string(),
                node_id: z.string(),
                spdx_id: z.string(),
                url: z.string().nullable(),
              })
              .nullable(),
            master_branch: z.string().optional(),
            merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
            merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
            merges_url: z.string(),
            milestones_url: z.string(),
            mirror_url: z.string().nullable(),
            name: z.string(),
            node_id: z.string(),
            notifications_url: z.string(),
            open_issues: z.number(),
            open_issues_count: z.number(),
            organization: z.string().optional(),
            owner: z
              .object({
                avatar_url: z.string().optional(),
                deleted: z.boolean().optional(),
                email: z.string().optional().nullable(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number(),
                login: z.string(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                url: z.string().optional(),
              })
              .nullable(),
            permissions: z
              .object({
                admin: z.boolean(),
                maintain: z.boolean().optional(),
                pull: z.boolean(),
                push: z.boolean(),
                triage: z.boolean().optional(),
              })
              .optional(),
            private: z.boolean(),
            public: z.boolean().optional(),
            pulls_url: z.string(),
            pushed_at: z.union([z.number(), z.string()]).nullable(),
            releases_url: z.string(),
            role_name: z.string().optional().nullable(),
            size: z.number(),
            squash_merge_commit_message: z
              .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
              .optional(),
            squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
            ssh_url: z.string(),
            stargazers: z.number().optional(),
            stargazers_count: z.number(),
            stargazers_url: z.string(),
            statuses_url: z.string(),
            subscribers_url: z.string(),
            subscription_url: z.string(),
            svn_url: z.string(),
            tags_url: z.string(),
            teams_url: z.string(),
            topics: z.array(z.string()),
            trees_url: z.string(),
            updated_at: z.string(),
            url: z.string(),
            use_squash_pr_title_as_default: z.boolean().optional(),
            visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
            watchers: z.number(),
            watchers_count: z.number(),
            web_commit_signoff_required: z.boolean().optional(),
          })
          .nullable(),
        sha: z.string(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      }),
      html_url: z.string(),
      id: z.number(),
      issue_url: z.string(),
      labels: z.array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      ),
      locked: z.boolean(),
      maintainer_can_modify: z.boolean().optional(),
      merge_commit_sha: z.string().nullable(),
      mergeable: z.boolean().optional().nullable(),
      mergeable_state: z.string().optional(),
      merged: z.boolean().optional().nullable(),
      merged_at: z.string().nullable(),
      merged_by: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      patch_url: z.string(),
      rebaseable: z.boolean().optional().nullable(),
      requested_reviewers: z.array(
        z
          .union([
            z.object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z
                .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
                .optional(),
              url: z.string().optional(),
            }),
            z.object({
              deleted: z.boolean().optional(),
              description: z.string().nullable(),
              html_url: z.string(),
              id: z.number(),
              members_url: z.string(),
              name: z.string(),
              node_id: z.string(),
              parent: z
                .object({
                  description: z.string().nullable(),
                  html_url: z.string(),
                  id: z.number(),
                  members_url: z.string(),
                  name: z.string(),
                  node_id: z.string(),
                  permission: z.string(),
                  privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                  repositories_url: z.string(),
                  slug: z.string(),
                  url: z.string(),
                })
                .optional()
                .nullable(),
              permission: z.string(),
              privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
              repositories_url: z.string(),
              slug: z.string(),
              url: z.string(),
            }),
          ])
          .nullable(),
      ),
      requested_teams: z.array(
        z.object({
          deleted: z.boolean().optional(),
          description: z.string().optional().nullable(),
          html_url: z.string().optional(),
          id: z.number(),
          members_url: z.string().optional(),
          name: z.string(),
          node_id: z.string().optional(),
          parent: z
            .object({
              description: z.string().nullable(),
              html_url: z.string(),
              id: z.number(),
              members_url: z.string(),
              name: z.string(),
              node_id: z.string(),
              permission: z.string(),
              privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
              repositories_url: z.string(),
              slug: z.string(),
              url: z.string(),
            })
            .optional()
            .nullable(),
          permission: z.string().optional(),
          privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
          repositories_url: z.string().optional(),
          slug: z.string().optional(),
          url: z.string().optional(),
        }),
      ),
      review_comment_url: z.string(),
      review_comments: z.number().optional(),
      review_comments_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]),
      statuses_url: z.string(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        _links: z
          .object({
            comments: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            commits: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            html: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            issue: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            review_comment: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            review_comments: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            self: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            statuses: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        active_lock_reason: z.string().optional().nullable(),
        additions: z.number().optional(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        auto_merge: z.record(z.unknown()).optional().nullable(),
        base: z
          .object({
            label: z.string().optional(),
            ref: z.string().optional(),
            repo: z
              .object({
                allow_auto_merge: z.boolean().optional(),
                allow_forking: z.boolean().optional(),
                allow_merge_commit: z.boolean().optional(),
                allow_rebase_merge: z.boolean().optional(),
                allow_squash_merge: z.boolean().optional(),
                allow_update_branch: z.boolean().optional(),
                archive_url: z.string().optional(),
                archived: z.boolean().optional(),
                assignees_url: z.string().optional(),
                blobs_url: z.string().optional(),
                branches_url: z.string().optional(),
                clone_url: z.string().optional(),
                collaborators_url: z.string().optional(),
                comments_url: z.string().optional(),
                commits_url: z.string().optional(),
                compare_url: z.string().optional(),
                contents_url: z.string().optional(),
                contributors_url: z.string().optional(),
                created_at: z.string().optional(),
                default_branch: z.string().optional(),
                delete_branch_on_merge: z.boolean().optional(),
                deployments_url: z.string().optional(),
                description: z.string().optional().nullable(),
                disabled: z.boolean().optional(),
                downloads_url: z.string().optional(),
                events_url: z.string().optional(),
                fork: z.boolean().optional(),
                forks: z.number().optional(),
                forks_count: z.number().optional(),
                forks_url: z.string().optional(),
                full_name: z.string().optional(),
                git_commits_url: z.string().optional(),
                git_refs_url: z.string().optional(),
                git_tags_url: z.string().optional(),
                git_url: z.string().optional(),
                has_downloads: z.boolean().optional(),
                has_issues: z.boolean().optional(),
                has_pages: z.boolean().optional(),
                has_projects: z.boolean().optional(),
                has_wiki: z.boolean().optional(),
                homepage: z.string().optional().nullable(),
                hooks_url: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                is_template: z.boolean().optional(),
                issue_comment_url: z.string().optional(),
                issue_events_url: z.string().optional(),
                issues_url: z.string().optional(),
                keys_url: z.string().optional(),
                labels_url: z.string().optional(),
                language: z.string().optional().nullable(),
                languages_url: z.string().optional(),
                license: z.record(z.unknown()).optional().nullable(),
                merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')])
                  .optional(),
                merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
                merges_url: z.string().optional(),
                milestones_url: z.string().optional(),
                mirror_url: z.string().optional().nullable(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                notifications_url: z.string().optional(),
                open_issues: z.number().optional(),
                open_issues_count: z.number().optional(),
                owner: z
                  .object({
                    avatar_url: z.string().optional(),
                    events_url: z.string().optional(),
                    followers_url: z.string().optional(),
                    following_url: z.string().optional(),
                    gists_url: z.string().optional(),
                    gravatar_id: z.string().optional(),
                    html_url: z.string().optional(),
                    id: z.number().optional(),
                    login: z.string().optional(),
                    node_id: z.string().optional(),
                    organizations_url: z.string().optional(),
                    received_events_url: z.string().optional(),
                    repos_url: z.string().optional(),
                    site_admin: z.boolean().optional(),
                    starred_url: z.string().optional(),
                    subscriptions_url: z.string().optional(),
                    type: z.string().optional(),
                    url: z.string().optional(),
                  })
                  .optional(),
                private: z.boolean().optional(),
                pulls_url: z.string().optional(),
                pushed_at: z.string().optional(),
                releases_url: z.string().optional(),
                size: z.number().optional(),
                squash_merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
                  .optional(),
                squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
                ssh_url: z.string().optional(),
                stargazers_count: z.number().optional(),
                stargazers_url: z.string().optional(),
                statuses_url: z.string().optional(),
                subscribers_url: z.string().optional(),
                subscription_url: z.string().optional(),
                svn_url: z.string().optional(),
                tags_url: z.string().optional(),
                teams_url: z.string().optional(),
                topics: z.array(z.string().nullable()).optional(),
                trees_url: z.string().optional(),
                updated_at: z.string().optional(),
                url: z.string().optional(),
                use_squash_pr_title_as_default: z.boolean().optional(),
                visibility: z.string().optional(),
                watchers: z.number().optional(),
                watchers_count: z.number().optional(),
                web_commit_signoff_required: z.boolean().optional(),
              })
              .optional(),
            sha: z.string().optional(),
            user: z
              .object({
                avatar_url: z.string().optional(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                login: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        body: z.string().optional().nullable(),
        changed_files: z.number().optional(),
        closed_at: z.string().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        commits: z.number().optional(),
        commits_url: z.string().optional(),
        created_at: z.string().optional(),
        deletions: z.number().optional(),
        diff_url: z.string().optional(),
        draft: z.boolean().optional(),
        head: z
          .object({
            label: z.string().optional().nullable(),
            ref: z.string().optional(),
            repo: z
              .object({
                allow_auto_merge: z.boolean().optional(),
                allow_forking: z.boolean().optional(),
                allow_merge_commit: z.boolean().optional(),
                allow_rebase_merge: z.boolean().optional(),
                allow_squash_merge: z.boolean().optional(),
                allow_update_branch: z.boolean().optional(),
                archive_url: z.string().optional(),
                archived: z.boolean().optional(),
                assignees_url: z.string().optional(),
                blobs_url: z.string().optional(),
                branches_url: z.string().optional(),
                clone_url: z.string().optional(),
                collaborators_url: z.string().optional(),
                comments_url: z.string().optional(),
                commits_url: z.string().optional(),
                compare_url: z.string().optional(),
                contents_url: z.string().optional(),
                contributors_url: z.string().optional(),
                created_at: z.string().optional(),
                default_branch: z.string().optional(),
                delete_branch_on_merge: z.boolean().optional(),
                deployments_url: z.string().optional(),
                description: z.string().optional().nullable(),
                disabled: z.boolean().optional(),
                downloads_url: z.string().optional(),
                events_url: z.string().optional(),
                fork: z.boolean().optional(),
                forks: z.number().optional(),
                forks_count: z.number().optional(),
                forks_url: z.string().optional(),
                full_name: z.string().optional(),
                git_commits_url: z.string().optional(),
                git_refs_url: z.string().optional(),
                git_tags_url: z.string().optional(),
                git_url: z.string().optional(),
                has_downloads: z.boolean().optional(),
                has_issues: z.boolean().optional(),
                has_pages: z.boolean().optional(),
                has_projects: z.boolean().optional(),
                has_wiki: z.boolean().optional(),
                homepage: z.string().optional().nullable(),
                hooks_url: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                is_template: z.boolean().optional(),
                issue_comment_url: z.string().optional(),
                issue_events_url: z.string().optional(),
                issues_url: z.string().optional(),
                keys_url: z.string().optional(),
                labels_url: z.string().optional(),
                language: z.string().optional().nullable(),
                languages_url: z.string().optional(),
                license: z.record(z.unknown()).optional().nullable(),
                merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')])
                  .optional(),
                merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
                merges_url: z.string().optional(),
                milestones_url: z.string().optional(),
                mirror_url: z.string().optional().nullable(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                notifications_url: z.string().optional(),
                open_issues: z.number().optional(),
                open_issues_count: z.number().optional(),
                owner: z
                  .object({
                    avatar_url: z.string().optional(),
                    events_url: z.string().optional(),
                    followers_url: z.string().optional(),
                    following_url: z.string().optional(),
                    gists_url: z.string().optional(),
                    gravatar_id: z.string().optional(),
                    html_url: z.string().optional(),
                    id: z.number().optional(),
                    login: z.string().optional(),
                    node_id: z.string().optional(),
                    organizations_url: z.string().optional(),
                    received_events_url: z.string().optional(),
                    repos_url: z.string().optional(),
                    site_admin: z.boolean().optional(),
                    starred_url: z.string().optional(),
                    subscriptions_url: z.string().optional(),
                    type: z.string().optional(),
                    url: z.string().optional(),
                  })
                  .optional()
                  .nullable(),
                private: z.boolean().optional(),
                pulls_url: z.string().optional(),
                pushed_at: z.string().optional(),
                releases_url: z.string().optional(),
                size: z.number().optional(),
                squash_merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
                  .optional(),
                squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
                ssh_url: z.string().optional(),
                stargazers_count: z.number().optional(),
                stargazers_url: z.string().optional(),
                statuses_url: z.string().optional(),
                subscribers_url: z.string().optional(),
                subscription_url: z.string().optional(),
                svn_url: z.string().optional(),
                tags_url: z.string().optional(),
                teams_url: z.string().optional(),
                topics: z.array(z.string().nullable()).optional(),
                trees_url: z.string().optional(),
                updated_at: z.string().optional(),
                url: z.string().optional(),
                use_squash_pr_title_as_default: z.boolean().optional(),
                visibility: z.string().optional(),
                watchers: z.number().optional(),
                watchers_count: z.number().optional(),
                web_commit_signoff_required: z.boolean().optional(),
              })
              .optional()
              .nullable(),
            sha: z.string().optional(),
            user: z
              .object({
                avatar_url: z.string().optional(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                login: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.string().optional(),
                url: z.string().optional(),
              })
              .optional()
              .nullable(),
          })
          .optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        issue_url: z.string().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        locked: z.boolean().optional(),
        maintainer_can_modify: z.boolean().optional(),
        merge_commit_sha: z.string().optional().nullable(),
        mergeable: z.boolean().optional().nullable(),
        mergeable_state: z.string().optional(),
        merged: z.boolean(),
        merged_at: z.string().optional().nullable(),
        merged_by: z.record(z.unknown()).optional().nullable(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        patch_url: z.string().optional(),
        rebaseable: z.boolean().optional().nullable(),
        requested_reviewers: z.array(z.record(z.unknown()).nullable()).optional(),
        requested_teams: z.array(z.record(z.unknown()).nullable()).optional(),
        review_comment_url: z.string().optional(),
        review_comments: z.number().optional(),
        review_comments_url: z.string().optional(),
        state: z.union([z.literal('closed'), z.literal('open')]),
        statuses_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const webhookPullRequestConvertedToDraftSchema = z.object({
  action: z.literal('converted_to_draft'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z
    .object({
      _links: z.object({
        comments: z.object({
          href: z.string(),
        }),
        commits: z.object({
          href: z.string(),
        }),
        html: z.object({
          href: z.string(),
        }),
        issue: z.object({
          href: z.string(),
        }),
        review_comment: z.object({
          href: z.string(),
        }),
        review_comments: z.object({
          href: z.string(),
        }),
        self: z.object({
          href: z.string(),
        }),
        statuses: z.object({
          href: z.string(),
        }),
      }),
      active_lock_reason: z
        .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
        .nullable(),
      additions: z.number().optional(),
      assignee: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
      assignees: z.array(
        z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      ),
      author_association: z.union([
        z.literal('COLLABORATOR'),
        z.literal('CONTRIBUTOR'),
        z.literal('FIRST_TIMER'),
        z.literal('FIRST_TIME_CONTRIBUTOR'),
        z.literal('MANNEQUIN'),
        z.literal('MEMBER'),
        z.literal('NONE'),
        z.literal('OWNER'),
      ]),
      auto_merge: z
        .object({
          commit_message: z.string().nullable(),
          commit_title: z.string().nullable(),
          enabled_by: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
        })
        .nullable(),
      base: z.object({
        label: z.string(),
        ref: z.string(),
        repo: z.object({
          allow_auto_merge: z.boolean().optional(),
          allow_forking: z.boolean().optional(),
          allow_merge_commit: z.boolean().optional(),
          allow_rebase_merge: z.boolean().optional(),
          allow_squash_merge: z.boolean().optional(),
          allow_update_branch: z.boolean().optional(),
          archive_url: z.string(),
          archived: z.boolean(),
          assignees_url: z.string(),
          blobs_url: z.string(),
          branches_url: z.string(),
          clone_url: z.string(),
          collaborators_url: z.string(),
          comments_url: z.string(),
          commits_url: z.string(),
          compare_url: z.string(),
          contents_url: z.string(),
          contributors_url: z.string(),
          created_at: z.union([z.number(), z.string()]),
          default_branch: z.string(),
          delete_branch_on_merge: z.boolean().optional(),
          deployments_url: z.string(),
          description: z.string().nullable(),
          disabled: z.boolean().optional(),
          downloads_url: z.string(),
          events_url: z.string(),
          fork: z.boolean(),
          forks: z.number(),
          forks_count: z.number(),
          forks_url: z.string(),
          full_name: z.string(),
          git_commits_url: z.string(),
          git_refs_url: z.string(),
          git_tags_url: z.string(),
          git_url: z.string(),
          has_downloads: z.boolean(),
          has_issues: z.boolean(),
          has_pages: z.boolean(),
          has_projects: z.boolean(),
          has_wiki: z.boolean(),
          homepage: z.string().nullable(),
          hooks_url: z.string(),
          html_url: z.string(),
          id: z.number(),
          is_template: z.boolean().optional(),
          issue_comment_url: z.string(),
          issue_events_url: z.string(),
          issues_url: z.string(),
          keys_url: z.string(),
          labels_url: z.string(),
          language: z.string().nullable(),
          languages_url: z.string(),
          license: z
            .object({
              key: z.string(),
              name: z.string(),
              node_id: z.string(),
              spdx_id: z.string(),
              url: z.string().nullable(),
            })
            .nullable(),
          master_branch: z.string().optional(),
          merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
          merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
          merges_url: z.string(),
          milestones_url: z.string(),
          mirror_url: z.string().nullable(),
          name: z.string(),
          node_id: z.string(),
          notifications_url: z.string(),
          open_issues: z.number(),
          open_issues_count: z.number(),
          organization: z.string().optional(),
          owner: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          permissions: z
            .object({
              admin: z.boolean(),
              maintain: z.boolean().optional(),
              pull: z.boolean(),
              push: z.boolean(),
              triage: z.boolean().optional(),
            })
            .optional(),
          private: z.boolean(),
          public: z.boolean().optional(),
          pulls_url: z.string(),
          pushed_at: z.union([z.number(), z.string()]).nullable(),
          releases_url: z.string(),
          role_name: z.string().optional().nullable(),
          size: z.number(),
          squash_merge_commit_message: z
            .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
            .optional(),
          squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
          ssh_url: z.string(),
          stargazers: z.number().optional(),
          stargazers_count: z.number(),
          stargazers_url: z.string(),
          statuses_url: z.string(),
          subscribers_url: z.string(),
          subscription_url: z.string(),
          svn_url: z.string(),
          tags_url: z.string(),
          teams_url: z.string(),
          topics: z.array(z.string()),
          trees_url: z.string(),
          updated_at: z.string(),
          url: z.string(),
          use_squash_pr_title_as_default: z.boolean().optional(),
          visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
          watchers: z.number(),
          watchers_count: z.number(),
          web_commit_signoff_required: z.boolean().optional(),
        }),
        sha: z.string(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      }),
      body: z.string().nullable(),
      changed_files: z.number().optional(),
      closed_at: z.string().nullable(),
      comments: z.number().optional(),
      comments_url: z.string(),
      commits: z.number().optional(),
      commits_url: z.string(),
      created_at: z.string(),
      deletions: z.number().optional(),
      diff_url: z.string(),
      draft: z.boolean(),
      head: z.object({
        label: z.string(),
        ref: z.string(),
        repo: z
          .object({
            allow_auto_merge: z.boolean().optional(),
            allow_forking: z.boolean().optional(),
            allow_merge_commit: z.boolean().optional(),
            allow_rebase_merge: z.boolean().optional(),
            allow_squash_merge: z.boolean().optional(),
            allow_update_branch: z.boolean().optional(),
            archive_url: z.string(),
            archived: z.boolean(),
            assignees_url: z.string(),
            blobs_url: z.string(),
            branches_url: z.string(),
            clone_url: z.string(),
            collaborators_url: z.string(),
            comments_url: z.string(),
            commits_url: z.string(),
            compare_url: z.string(),
            contents_url: z.string(),
            contributors_url: z.string(),
            created_at: z.union([z.number(), z.string()]),
            default_branch: z.string(),
            delete_branch_on_merge: z.boolean().optional(),
            deployments_url: z.string(),
            description: z.string().nullable(),
            disabled: z.boolean().optional(),
            downloads_url: z.string(),
            events_url: z.string(),
            fork: z.boolean(),
            forks: z.number(),
            forks_count: z.number(),
            forks_url: z.string(),
            full_name: z.string(),
            git_commits_url: z.string(),
            git_refs_url: z.string(),
            git_tags_url: z.string(),
            git_url: z.string(),
            has_downloads: z.boolean(),
            has_issues: z.boolean(),
            has_pages: z.boolean(),
            has_projects: z.boolean(),
            has_wiki: z.boolean(),
            homepage: z.string().nullable(),
            hooks_url: z.string(),
            html_url: z.string(),
            id: z.number(),
            is_template: z.boolean().optional(),
            issue_comment_url: z.string(),
            issue_events_url: z.string(),
            issues_url: z.string(),
            keys_url: z.string(),
            labels_url: z.string(),
            language: z.string().nullable(),
            languages_url: z.string(),
            license: z
              .object({
                key: z.string(),
                name: z.string(),
                node_id: z.string(),
                spdx_id: z.string(),
                url: z.string().nullable(),
              })
              .nullable(),
            master_branch: z.string().optional(),
            merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
            merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
            merges_url: z.string(),
            milestones_url: z.string(),
            mirror_url: z.string().nullable(),
            name: z.string(),
            node_id: z.string(),
            notifications_url: z.string(),
            open_issues: z.number(),
            open_issues_count: z.number(),
            organization: z.string().optional(),
            owner: z
              .object({
                avatar_url: z.string().optional(),
                deleted: z.boolean().optional(),
                email: z.string().optional().nullable(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number(),
                login: z.string(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
                url: z.string().optional(),
              })
              .nullable(),
            permissions: z
              .object({
                admin: z.boolean(),
                maintain: z.boolean().optional(),
                pull: z.boolean(),
                push: z.boolean(),
                triage: z.boolean().optional(),
              })
              .optional(),
            private: z.boolean(),
            public: z.boolean().optional(),
            pulls_url: z.string(),
            pushed_at: z.union([z.number(), z.string()]).nullable(),
            releases_url: z.string(),
            role_name: z.string().optional().nullable(),
            size: z.number(),
            squash_merge_commit_message: z
              .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
              .optional(),
            squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
            ssh_url: z.string(),
            stargazers: z.number().optional(),
            stargazers_count: z.number(),
            stargazers_url: z.string(),
            statuses_url: z.string(),
            subscribers_url: z.string(),
            subscription_url: z.string(),
            svn_url: z.string(),
            tags_url: z.string(),
            teams_url: z.string(),
            topics: z.array(z.string()),
            trees_url: z.string(),
            updated_at: z.string(),
            url: z.string(),
            use_squash_pr_title_as_default: z.boolean().optional(),
            visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
            watchers: z.number(),
            watchers_count: z.number(),
            web_commit_signoff_required: z.boolean().optional(),
          })
          .nullable(),
        sha: z.string(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
      }),
      html_url: z.string(),
      id: z.number(),
      issue_url: z.string(),
      labels: z.array(
        z.object({
          color: z.string(),
          default: z.boolean(),
          description: z.string().nullable(),
          id: z.number(),
          name: z.string(),
          node_id: z.string(),
          url: z.string(),
        }),
      ),
      locked: z.boolean(),
      maintainer_can_modify: z.boolean().optional(),
      merge_commit_sha: z.string().nullable(),
      mergeable: z.boolean().optional().nullable(),
      mergeable_state: z.string().optional(),
      merged: z.boolean().optional().nullable(),
      merged_at: z.string().nullable(),
      merged_by: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .optional()
        .nullable(),
      milestone: z
        .object({
          closed_at: z.string().nullable(),
          closed_issues: z.number(),
          created_at: z.string(),
          creator: z
            .object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            })
            .nullable(),
          description: z.string().nullable(),
          due_on: z.string().nullable(),
          html_url: z.string(),
          id: z.number(),
          labels_url: z.string(),
          node_id: z.string(),
          number: z.number(),
          open_issues: z.number(),
          state: z.union([z.literal('open'), z.literal('closed')]),
          title: z.string(),
          updated_at: z.string(),
          url: z.string(),
        })
        .nullable(),
      node_id: z.string(),
      number: z.number(),
      patch_url: z.string(),
      rebaseable: z.boolean().optional().nullable(),
      requested_reviewers: z.array(
        z
          .union([
            z.object({
              avatar_url: z.string().optional(),
              deleted: z.boolean().optional(),
              email: z.string().optional().nullable(),
              events_url: z.string().optional(),
              followers_url: z.string().optional(),
              following_url: z.string().optional(),
              gists_url: z.string().optional(),
              gravatar_id: z.string().optional(),
              html_url: z.string().optional(),
              id: z.number(),
              login: z.string(),
              name: z.string().optional(),
              node_id: z.string().optional(),
              organizations_url: z.string().optional(),
              received_events_url: z.string().optional(),
              repos_url: z.string().optional(),
              site_admin: z.boolean().optional(),
              starred_url: z.string().optional(),
              subscriptions_url: z.string().optional(),
              type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
              url: z.string().optional(),
            }),
            z.object({
              deleted: z.boolean().optional(),
              description: z.string().optional().nullable(),
              html_url: z.string().optional(),
              id: z.number(),
              members_url: z.string().optional(),
              name: z.string(),
              node_id: z.string().optional(),
              parent: z
                .object({
                  description: z.string().nullable(),
                  html_url: z.string(),
                  id: z.number(),
                  members_url: z.string(),
                  name: z.string(),
                  node_id: z.string(),
                  permission: z.string(),
                  privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                  repositories_url: z.string(),
                  slug: z.string(),
                  url: z.string(),
                })
                .optional()
                .nullable(),
              permission: z.string().optional(),
              privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
              repositories_url: z.string().optional(),
              slug: z.string().optional(),
              url: z.string().optional(),
            }),
          ])
          .nullable(),
      ),
      requested_teams: z.array(
        z.object({
          deleted: z.boolean().optional(),
          description: z.string().optional().nullable(),
          html_url: z.string().optional(),
          id: z.number(),
          members_url: z.string().optional(),
          name: z.string(),
          node_id: z.string().optional(),
          parent: z
            .object({
              description: z.string().nullable(),
              html_url: z.string(),
              id: z.number(),
              members_url: z.string(),
              name: z.string(),
              node_id: z.string(),
              permission: z.string(),
              privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
              repositories_url: z.string(),
              slug: z.string(),
              url: z.string(),
            })
            .optional()
            .nullable(),
          permission: z.string().optional(),
          privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
          repositories_url: z.string().optional(),
          slug: z.string().optional(),
          url: z.string().optional(),
        }),
      ),
      review_comment_url: z.string(),
      review_comments: z.number().optional(),
      review_comments_url: z.string(),
      state: z.union([z.literal('open'), z.literal('closed')]),
      statuses_url: z.string(),
      title: z.string(),
      updated_at: z.string(),
      url: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    })
    .and(
      z.object({
        _links: z
          .object({
            comments: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            commits: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            html: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            issue: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            review_comment: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            review_comments: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            self: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
            statuses: z
              .object({
                href: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        active_lock_reason: z.string().optional().nullable(),
        additions: z.number().optional(),
        assignee: z.record(z.unknown()).optional().nullable(),
        assignees: z.array(z.record(z.unknown()).nullable()).optional(),
        author_association: z.string().optional(),
        auto_merge: z.record(z.unknown()).optional().nullable(),
        base: z
          .object({
            label: z.string().optional(),
            ref: z.string().optional(),
            repo: z
              .object({
                allow_auto_merge: z.boolean().optional(),
                allow_forking: z.boolean().optional(),
                allow_merge_commit: z.boolean().optional(),
                allow_rebase_merge: z.boolean().optional(),
                allow_squash_merge: z.boolean().optional(),
                allow_update_branch: z.boolean().optional(),
                archive_url: z.string().optional(),
                archived: z.boolean().optional(),
                assignees_url: z.string().optional(),
                blobs_url: z.string().optional(),
                branches_url: z.string().optional(),
                clone_url: z.string().optional(),
                collaborators_url: z.string().optional(),
                comments_url: z.string().optional(),
                commits_url: z.string().optional(),
                compare_url: z.string().optional(),
                contents_url: z.string().optional(),
                contributors_url: z.string().optional(),
                created_at: z.string().optional(),
                default_branch: z.string().optional(),
                delete_branch_on_merge: z.boolean().optional(),
                deployments_url: z.string().optional(),
                description: z.string().optional().nullable(),
                disabled: z.boolean().optional(),
                downloads_url: z.string().optional(),
                events_url: z.string().optional(),
                fork: z.boolean().optional(),
                forks: z.number().optional(),
                forks_count: z.number().optional(),
                forks_url: z.string().optional(),
                full_name: z.string().optional(),
                git_commits_url: z.string().optional(),
                git_refs_url: z.string().optional(),
                git_tags_url: z.string().optional(),
                git_url: z.string().optional(),
                has_downloads: z.boolean().optional(),
                has_issues: z.boolean().optional(),
                has_pages: z.boolean().optional(),
                has_projects: z.boolean().optional(),
                has_wiki: z.boolean().optional(),
                homepage: z.string().optional().nullable(),
                hooks_url: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                is_template: z.boolean().optional(),
                issue_comment_url: z.string().optional(),
                issue_events_url: z.string().optional(),
                issues_url: z.string().optional(),
                keys_url: z.string().optional(),
                labels_url: z.string().optional(),
                language: z.string().optional().nullable(),
                languages_url: z.string().optional(),
                license: z.record(z.unknown()).optional().nullable(),
                merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')])
                  .optional(),
                merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
                merges_url: z.string().optional(),
                milestones_url: z.string().optional(),
                mirror_url: z.unknown().optional(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                notifications_url: z.string().optional(),
                open_issues: z.number().optional(),
                open_issues_count: z.number().optional(),
                owner: z
                  .object({
                    avatar_url: z.string().optional(),
                    events_url: z.string().optional(),
                    followers_url: z.string().optional(),
                    following_url: z.string().optional(),
                    gists_url: z.string().optional(),
                    gravatar_id: z.string().optional(),
                    html_url: z.string().optional(),
                    id: z.number().optional(),
                    login: z.string().optional(),
                    node_id: z.string().optional(),
                    organizations_url: z.string().optional(),
                    received_events_url: z.string().optional(),
                    repos_url: z.string().optional(),
                    site_admin: z.boolean().optional(),
                    starred_url: z.string().optional(),
                    subscriptions_url: z.string().optional(),
                    type: z.string().optional(),
                    url: z.string().optional(),
                  })
                  .optional(),
                private: z.boolean().optional(),
                pulls_url: z.string().optional(),
                pushed_at: z.string().optional(),
                releases_url: z.string().optional(),
                size: z.number().optional(),
                squash_merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
                  .optional(),
                squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
                ssh_url: z.string().optional(),
                stargazers_count: z.number().optional(),
                stargazers_url: z.string().optional(),
                statuses_url: z.string().optional(),
                subscribers_url: z.string().optional(),
                subscription_url: z.string().optional(),
                svn_url: z.string().optional(),
                tags_url: z.string().optional(),
                teams_url: z.string().optional(),
                topics: z.array(z.string().nullable()).optional(),
                trees_url: z.string().optional(),
                updated_at: z.string().optional(),
                url: z.string().optional(),
                use_squash_pr_title_as_default: z.boolean().optional(),
                visibility: z.string().optional(),
                watchers: z.number().optional(),
                watchers_count: z.number().optional(),
                web_commit_signoff_required: z.boolean().optional(),
              })
              .optional(),
            sha: z.string().optional(),
            user: z
              .object({
                avatar_url: z.string().optional(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                login: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        body: z.string().optional().nullable(),
        changed_files: z.number().optional(),
        closed_at: z.string().nullable(),
        comments: z.number().optional(),
        comments_url: z.string().optional(),
        commits: z.number().optional(),
        commits_url: z.string().optional(),
        created_at: z.string().optional(),
        deletions: z.number().optional(),
        diff_url: z.string().optional(),
        draft: z.boolean(),
        head: z
          .object({
            label: z.string().optional(),
            ref: z.string().optional(),
            repo: z
              .object({
                allow_auto_merge: z.boolean().optional(),
                allow_forking: z.boolean().optional(),
                allow_merge_commit: z.boolean().optional(),
                allow_rebase_merge: z.boolean().optional(),
                allow_squash_merge: z.boolean().optional(),
                allow_update_branch: z.boolean().optional(),
                archive_url: z.string().optional(),
                archived: z.boolean().optional(),
                assignees_url: z.string().optional(),
                blobs_url: z.string().optional(),
                branches_url: z.string().optional(),
                clone_url: z.string().optional(),
                collaborators_url: z.string().optional(),
                comments_url: z.string().optional(),
                commits_url: z.string().optional(),
                compare_url: z.string().optional(),
                contents_url: z.string().optional(),
                contributors_url: z.string().optional(),
                created_at: z.string().optional(),
                default_branch: z.string().optional(),
                delete_branch_on_merge: z.boolean().optional(),
                deployments_url: z.string().optional(),
                description: z.string().optional().nullable(),
                disabled: z.boolean().optional(),
                downloads_url: z.string().optional(),
                events_url: z.string().optional(),
                fork: z.boolean().optional(),
                forks: z.number().optional(),
                forks_count: z.number().optional(),
                forks_url: z.string().optional(),
                full_name: z.string().optional(),
                git_commits_url: z.string().optional(),
                git_refs_url: z.string().optional(),
                git_tags_url: z.string().optional(),
                git_url: z.string().optional(),
                has_downloads: z.boolean().optional(),
                has_issues: z.boolean().optional(),
                has_pages: z.boolean().optional(),
                has_projects: z.boolean().optional(),
                has_wiki: z.boolean().optional(),
                homepage: z.string().optional().nullable(),
                hooks_url: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                is_template: z.boolean().optional(),
                issue_comment_url: z.string().optional(),
                issue_events_url: z.string().optional(),
                issues_url: z.string().optional(),
                keys_url: z.string().optional(),
                labels_url: z.string().optional(),
                language: z.string().optional().nullable(),
                languages_url: z.string().optional(),
                license: z.record(z.unknown()).optional().nullable(),
                merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')])
                  .optional(),
                merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
                merges_url: z.string().optional(),
                milestones_url: z.string().optional(),
                mirror_url: z.unknown().optional(),
                name: z.string().optional(),
                node_id: z.string().optional(),
                notifications_url: z.string().optional(),
                open_issues: z.number().optional(),
                open_issues_count: z.number().optional(),
                owner: z
                  .object({
                    avatar_url: z.string().optional(),
                    events_url: z.string().optional(),
                    followers_url: z.string().optional(),
                    following_url: z.string().optional(),
                    gists_url: z.string().optional(),
                    gravatar_id: z.string().optional(),
                    html_url: z.string().optional(),
                    id: z.number().optional(),
                    login: z.string().optional(),
                    node_id: z.string().optional(),
                    organizations_url: z.string().optional(),
                    received_events_url: z.string().optional(),
                    repos_url: z.string().optional(),
                    site_admin: z.boolean().optional(),
                    starred_url: z.string().optional(),
                    subscriptions_url: z.string().optional(),
                    type: z.string().optional(),
                    url: z.string().optional(),
                  })
                  .optional(),
                private: z.boolean().optional(),
                pulls_url: z.string().optional(),
                pushed_at: z.string().optional(),
                releases_url: z.string().optional(),
                size: z.number().optional(),
                squash_merge_commit_message: z
                  .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
                  .optional(),
                squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
                ssh_url: z.string().optional(),
                stargazers_count: z.number().optional(),
                stargazers_url: z.string().optional(),
                statuses_url: z.string().optional(),
                subscribers_url: z.string().optional(),
                subscription_url: z.string().optional(),
                svn_url: z.string().optional(),
                tags_url: z.string().optional(),
                teams_url: z.string().optional(),
                topics: z.array(z.string().nullable()).optional(),
                trees_url: z.string().optional(),
                updated_at: z.string().optional(),
                url: z.string().optional(),
                use_squash_pr_title_as_default: z.boolean().optional(),
                visibility: z.string().optional(),
                watchers: z.number().optional(),
                watchers_count: z.number().optional(),
                web_commit_signoff_required: z.boolean().optional(),
              })
              .optional()
              .nullable(),
            sha: z.string().optional(),
            user: z
              .object({
                avatar_url: z.string().optional(),
                events_url: z.string().optional(),
                followers_url: z.string().optional(),
                following_url: z.string().optional(),
                gists_url: z.string().optional(),
                gravatar_id: z.string().optional(),
                html_url: z.string().optional(),
                id: z.number().optional(),
                login: z.string().optional(),
                node_id: z.string().optional(),
                organizations_url: z.string().optional(),
                received_events_url: z.string().optional(),
                repos_url: z.string().optional(),
                site_admin: z.boolean().optional(),
                starred_url: z.string().optional(),
                subscriptions_url: z.string().optional(),
                type: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        html_url: z.string().optional(),
        id: z.number().optional(),
        issue_url: z.string().optional(),
        labels: z.array(z.record(z.unknown()).nullable()).optional(),
        locked: z.boolean().optional(),
        maintainer_can_modify: z.boolean().optional(),
        merge_commit_sha: z.string().optional().nullable(),
        mergeable: z.boolean().optional().nullable(),
        mergeable_state: z.string().optional(),
        merged: z.boolean(),
        merged_at: z.unknown(),
        merged_by: z.unknown(),
        milestone: z.record(z.unknown()).optional().nullable(),
        node_id: z.string().optional(),
        number: z.number().optional(),
        patch_url: z.string().optional(),
        rebaseable: z.boolean().optional().nullable(),
        requested_reviewers: z.array(z.record(z.unknown()).nullable()).optional(),
        requested_teams: z.array(z.record(z.unknown()).nullable()).optional(),
        review_comment_url: z.string().optional(),
        review_comments: z.number().optional(),
        review_comments_url: z.string().optional(),
        state: z.string().optional(),
        statuses_url: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        user: z
          .object({
            avatar_url: z.string().optional(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number().optional(),
            login: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
      }),
    ),
  repository: repositorySchema,
  sender: simpleUserSchema,
});

export const action57Schema = z.literal('converted_to_draft');

export const webhookPullRequestDemilestonedSchema = z.object({
  action: z.literal('demilestoned'),
  enterprise: enterpriseSchema.optional(),
  milestone: milestoneSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z.object({
    _links: z.object({
      comments: z.object({
        href: z.string(),
      }),
      commits: z.object({
        href: z.string(),
      }),
      html: z.object({
        href: z.string(),
      }),
      issue: z.object({
        href: z.string(),
      }),
      review_comment: z.object({
        href: z.string(),
      }),
      review_comments: z.object({
        href: z.string(),
      }),
      self: z.object({
        href: z.string(),
      }),
      statuses: z.object({
        href: z.string(),
      }),
    }),
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    additions: z.number().optional(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z
            .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
            .optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    auto_merge: z
      .object({
        commit_message: z.string().nullable(),
        commit_title: z.string().nullable(),
        enabled_by: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
      })
      .nullable(),
    base: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    body: z.string().nullable(),
    changed_files: z.number().optional(),
    closed_at: z.string().nullable(),
    comments: z.number().optional(),
    comments_url: z.string(),
    commits: z.number().optional(),
    commits_url: z.string(),
    created_at: z.string(),
    deletions: z.number().optional(),
    diff_url: z.string(),
    draft: z.boolean(),
    head: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        commits_url: z.string(),
        compare_url: z.string(),
        contents_url: z.string(),
        contributors_url: z.string(),
        created_at: z.union([z.number(), z.string()]),
        default_branch: z.string(),
        delete_branch_on_merge: z.boolean().optional(),
        deployments_url: z.string(),
        description: z.string().nullable(),
        disabled: z.boolean().optional(),
        downloads_url: z.string(),
        events_url: z.string(),
        fork: z.boolean(),
        forks: z.number(),
        forks_count: z.number(),
        forks_url: z.string(),
        full_name: z.string(),
        git_commits_url: z.string(),
        git_refs_url: z.string(),
        git_tags_url: z.string(),
        git_url: z.string(),
        has_discussions: z.boolean(),
        has_downloads: z.boolean(),
        has_issues: z.boolean(),
        has_pages: z.boolean(),
        has_projects: z.boolean(),
        has_wiki: z.boolean(),
        homepage: z.string().nullable(),
        hooks_url: z.string(),
        html_url: z.string(),
        id: z.number(),
        is_template: z.boolean().optional(),
        issue_comment_url: z.string(),
        issue_events_url: z.string(),
        issues_url: z.string(),
        keys_url: z.string(),
        labels_url: z.string(),
        language: z.string().nullable(),
        languages_url: z.string(),
        license: z
          .object({
            key: z.string(),
            name: z.string(),
            node_id: z.string(),
            spdx_id: z.string(),
            url: z.string().nullable(),
          })
          .nullable(),
        master_branch: z.string().optional(),
        merge_commit_message: z.union([z.literal('PR_BODY'), z.literal('PR_TITLE'), z.literal('BLANK')]).optional(),
        merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('MERGE_MESSAGE')]).optional(),
        merges_url: z.string(),
        milestones_url: z.string(),
        mirror_url: z.string().nullable(),
        name: z.string(),
        node_id: z.string(),
        notifications_url: z.string(),
        open_issues: z.number(),
        open_issues_count: z.number(),
        organization: z.string().optional(),
        owner: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        permissions: z
          .object({
            admin: z.boolean(),
            maintain: z.boolean().optional(),
            pull: z.boolean(),
            push: z.boolean(),
            triage: z.boolean().optional(),
          })
          .optional(),
        private: z.boolean(),
        public: z.boolean().optional(),
        pulls_url: z.string(),
        pushed_at: z.union([z.number(), z.string()]).nullable(),
        releases_url: z.string(),
        role_name: z.string().optional().nullable(),
        size: z.number(),
        squash_merge_commit_message: z
          .union([z.literal('PR_BODY'), z.literal('COMMIT_MESSAGES'), z.literal('BLANK')])
          .optional(),
        squash_merge_commit_title: z.union([z.literal('PR_TITLE'), z.literal('COMMIT_OR_PR_TITLE')]).optional(),
        ssh_url: z.string(),
        stargazers: z.number().optional(),
        stargazers_count: z.number(),
        stargazers_url: z.string(),
        statuses_url: z.string(),
        subscribers_url: z.string(),
        subscription_url: z.string(),
        svn_url: z.string(),
        tags_url: z.string(),
        teams_url: z.string(),
        topics: z.array(z.string()),
        trees_url: z.string(),
        updated_at: z.string(),
        url: z.string(),
        use_squash_pr_title_as_default: z.boolean().optional(),
        visibility: z.union([z.literal('public'), z.literal('private'), z.literal('internal')]),
        watchers: z.number(),
        watchers_count: z.number(),
        web_commit_signoff_required: z.boolean().optional(),
      }),
      sha: z.string(),
      user: z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    }),
    html_url: z.string(),
    id: z.number(),
    issue_url: z.string(),
    labels: z.array(
      z.object({
        color: z.string(),
        default: z.boolean(),
        description: z.string().nullable(),
        id: z.number(),
        name: z.string(),
        node_id: z.string(),
        url: z.string(),
      }),
    ),
    locked: z.boolean(),
    maintainer_can_modify: z.boolean().optional(),
    merge_commit_sha: z.string().nullable(),
    mergeable: z.boolean().optional().nullable(),
    mergeable_state: z.string().optional(),
    merged: z.boolean().optional().nullable(),
    merged_at: z.string().nullable(),
    merged_by: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .optional()
      .nullable(),
    milestone: z
      .object({
        closed_at: z.string().nullable(),
        closed_issues: z.number(),
        created_at: z.string(),
        creator: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z
              .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
              .optional(),
            url: z.string().optional(),
          })
          .nullable(),
        description: z.string().nullable(),
        due_on: z.string().nullable(),
        html_url: z.string(),
        id: z.number(),
        labels_url: z.string(),
        node_id: z.string(),
        number: z.number(),
        open_issues: z.number(),
        state: z.union([z.literal('open'), z.literal('closed')]),
        title: z.string(),
        updated_at: z.string(),
        url: z.string(),
      })
      .nullable(),
    node_id: z.string(),
    number: z.number(),
    patch_url: z.string(),
    rebaseable: z.boolean().optional().nullable(),
    requested_reviewers: z.array(
      z
        .union([
          z.object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          }),
          z.object({
            deleted: z.boolean().optional(),
            description: z.string().optional().nullable(),
            html_url: z.string().optional(),
            id: z.number(),
            members_url: z.string().optional(),
            name: z.string(),
            node_id: z.string().optional(),
            parent: z
              .object({
                description: z.string().nullable(),
                html_url: z.string(),
                id: z.number(),
                members_url: z.string(),
                name: z.string(),
                node_id: z.string(),
                permission: z.string(),
                privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
                repositories_url: z.string(),
                slug: z.string(),
                url: z.string(),
              })
              .optional()
              .nullable(),
            permission: z.string().optional(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
            repositories_url: z.string().optional(),
            slug: z.string().optional(),
            url: z.string().optional(),
          }),
        ])
        .nullable(),
    ),
    requested_teams: z.array(
      z.object({
        deleted: z.boolean().optional(),
        description: z.string().optional().nullable(),
        html_url: z.string().optional(),
        id: z.number(),
        members_url: z.string().optional(),
        name: z.string(),
        node_id: z.string().optional(),
        parent: z
          .object({
            description: z.string().nullable(),
            html_url: z.string(),
            id: z.number(),
            members_url: z.string(),
            name: z.string(),
            node_id: z.string(),
            permission: z.string(),
            privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]),
            repositories_url: z.string(),
            slug: z.string(),
            url: z.string(),
          })
          .optional()
          .nullable(),
        permission: z.string().optional(),
        privacy: z.union([z.literal('open'), z.literal('closed'), z.literal('secret')]).optional(),
        repositories_url: z.string().optional(),
        slug: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
    review_comment_url: z.string(),
    review_comments: z.number().optional(),
    review_comments_url: z.string(),
    state: z.union([z.literal('open'), z.literal('closed')]),
    statuses_url: z.string(),
    title: z.string(),
    updated_at: z.string(),
    url: z.string(),
    user: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z
          .union([z.literal('Bot'), z.literal('User'), z.literal('Organization'), z.literal('Mannequin')])
          .optional(),
        url: z.string().optional(),
      })
      .nullable(),
  }),
  repository: repositorySchema,
  sender: simpleUserSchema.optional(),
});

export const webhookPullRequestDequeuedSchema = z.object({
  action: z.literal('dequeued'),
  enterprise: enterpriseSchema.optional(),
  installation: simpleInstallationSchema.optional(),
  number: z.number(),
  organization: organizationSimpleSchema.optional(),
  pull_request: z.object({
    _links: z.object({
      comments: z.object({
        href: z.string(),
      }),
      commits: z.object({
        href: z.string(),
      }),
      html: z.object({
        href: z.string(),
      }),
      issue: z.object({
        href: z.string(),
      }),
      review_comment: z.object({
        href: z.string(),
      }),
      review_comments: z.object({
        href: z.string(),
      }),
      self: z.object({
        href: z.string(),
      }),
      statuses: z.object({
        href: z.string(),
      }),
    }),
    active_lock_reason: z
      .union([z.literal('resolved'), z.literal('off-topic'), z.literal('too heated'), z.literal('spam')])
      .nullable(),
    additions: z.number().optional(),
    assignee: z
      .object({
        avatar_url: z.string().optional(),
        deleted: z.boolean().optional(),
        email: z.string().optional().nullable(),
        events_url: z.string().optional(),
        followers_url: z.string().optional(),
        following_url: z.string().optional(),
        gists_url: z.string().optional(),
        gravatar_id: z.string().optional(),
        html_url: z.string().optional(),
        id: z.number(),
        login: z.string(),
        name: z.string().optional(),
        node_id: z.string().optional(),
        organizations_url: z.string().optional(),
        received_events_url: z.string().optional(),
        repos_url: z.string().optional(),
        site_admin: z.boolean().optional(),
        starred_url: z.string().optional(),
        subscriptions_url: z.string().optional(),
        type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
        url: z.string().optional(),
      })
      .nullable(),
    assignees: z.array(
      z
        .object({
          avatar_url: z.string().optional(),
          deleted: z.boolean().optional(),
          email: z.string().optional().nullable(),
          events_url: z.string().optional(),
          followers_url: z.string().optional(),
          following_url: z.string().optional(),
          gists_url: z.string().optional(),
          gravatar_id: z.string().optional(),
          html_url: z.string().optional(),
          id: z.number(),
          login: z.string(),
          name: z.string().optional(),
          node_id: z.string().optional(),
          organizations_url: z.string().optional(),
          received_events_url: z.string().optional(),
          repos_url: z.string().optional(),
          site_admin: z.boolean().optional(),
          starred_url: z.string().optional(),
          subscriptions_url: z.string().optional(),
          type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
          url: z.string().optional(),
        })
        .nullable(),
    ),
    author_association: z.union([
      z.literal('COLLABORATOR'),
      z.literal('CONTRIBUTOR'),
      z.literal('FIRST_TIMER'),
      z.literal('FIRST_TIME_CONTRIBUTOR'),
      z.literal('MANNEQUIN'),
      z.literal('MEMBER'),
      z.literal('NONE'),
      z.literal('OWNER'),
    ]),
    auto_merge: z
      .object({
        commit_message: z.string().nullable(),
        commit_title: z.string().nullable(),
        enabled_by: z
          .object({
            avatar_url: z.string().optional(),
            deleted: z.boolean().optional(),
            email: z.string().optional().nullable(),
            events_url: z.string().optional(),
            followers_url: z.string().optional(),
            following_url: z.string().optional(),
            gists_url: z.string().optional(),
            gravatar_id: z.string().optional(),
            html_url: z.string().optional(),
            id: z.number(),
            login: z.string(),
            name: z.string().optional(),
            node_id: z.string().optional(),
            organizations_url: z.string().optional(),
            received_events_url: z.string().optional(),
            repos_url: z.string().optional(),
            site_admin: z.boolean().optional(),
            starred_url: z.string().optional(),
            subscriptions_url: z.string().optional(),
            type: z.union([z.literal('Bot'), z.literal('User'), z.literal('Organization')]).optional(),
            url: z.string().optional(),
          })
          .nullable(),
        merge_method: z.union([z.literal('merge'), z.literal('squash'), z.literal('rebase')]),
      })
      .nullable(),
    base: z.object({
      label: z.string(),
      ref: z.string(),
      repo: z.object({
        allow_auto_merge: z.boolean().optional(),
        allow_forking: z.boolean().optional(),
        allow_merge_commit: z.boolean().optional(),
        allow_rebase_merge: z.boolean().optional(),
        allow_squash_merge: z.boolean().optional(),
        allow_update_branch: z.boolean().optional(),
        archive_url: z.string(),
        archived: z.boolean(),
        assignees_url: z.string(),
        blobs_url: z.string(),
        branches_url: z.string(),
        clone_url: z.string(),
        collaborators_url: z.string(),
        comments_url: z.string(),
        co